require.config({"config": {
        "jsbuild":{"knockoutjs/knockout.js":"/*!\n * Knockout JavaScript library v3.4.2\n * (c) The Knockout.js team - http://knockoutjs.com/\n * License: MIT (http://www.opensource.org/licenses/mit-license.php)\n */\n\n(function(){\nvar DEBUG=true;\n(function(undefined){\n    // (0, eval)('this') is a robust way of getting a reference to the global object\n    // For details, see http://stackoverflow.com/questions/14119988/return-this-0-evalthis/14120023#14120023\n    var window = this || (0, eval)('this'),\n        document = window['document'],\n        navigator = window['navigator'],\n        jQueryInstance = window[\"jQuery\"],\n        JSON = window[\"JSON\"];\n(function(factory) {\n    // Support three module loading scenarios\n    if (typeof define === 'function' && define['amd']) {\n        // [1] AMD anonymous module\n        define(['exports', 'require'], factory);\n    } else if (typeof exports === 'object' && typeof module === 'object') {\n        // [2] CommonJS/Node.js\n        factory(module['exports'] || exports);  // module.exports is for Node.js\n    } else {\n        // [3] No module loader (plain <script> tag) - put directly in global namespace\n        factory(window['ko'] = {});\n    }\n}(function(koExports, amdRequire){\n// Internally, all KO objects are attached to koExports (even the non-exported ones whose names will be minified by the closure compiler).\n// In the future, the following \"ko\" variable may be made distinct from \"koExports\" so that private objects are not externally reachable.\nvar ko = typeof koExports !== 'undefined' ? koExports : {};\n// Google Closure Compiler helpers (used only to make the minified file smaller)\nko.exportSymbol = function(koPath, object) {\n    var tokens = koPath.split(\".\");\n\n    // In the future, \"ko\" may become distinct from \"koExports\" (so that non-exported objects are not reachable)\n    // At that point, \"target\" would be set to: (typeof koExports !== \"undefined\" ? koExports : ko)\n    var target = ko;\n\n    for (var i = 0; i < tokens.length - 1; i++)\n        target = target[tokens[i]];\n    target[tokens[tokens.length - 1]] = object;\n};\nko.exportProperty = function(owner, publicName, object) {\n    owner[publicName] = object;\n};\nko.version = \"3.4.2\";\n\nko.exportSymbol('version', ko.version);\n// For any options that may affect various areas of Knockout and aren't directly associated with data binding.\nko.options = {\n    'deferUpdates': false,\n    'useOnlyNativeEvents': false\n};\n\n//ko.exportSymbol('options', ko.options);   // 'options' isn't minified\nko.utils = (function () {\n    function objectForEach(obj, action) {\n        for (var prop in obj) {\n            if (obj.hasOwnProperty(prop)) {\n                action(prop, obj[prop]);\n            }\n        }\n    }\n\n    function extend(target, source) {\n        if (source) {\n            for(var prop in source) {\n                if(source.hasOwnProperty(prop)) {\n                    target[prop] = source[prop];\n                }\n            }\n        }\n        return target;\n    }\n\n    function setPrototypeOf(obj, proto) {\n        obj.__proto__ = proto;\n        return obj;\n    }\n\n    var canSetPrototype = ({ __proto__: [] } instanceof Array);\n    var canUseSymbols = !DEBUG && typeof Symbol === 'function';\n\n    // Represent the known event types in a compact way, then at runtime transform it into a hash with event name as key (for fast lookup)\n    var knownEvents = {}, knownEventTypesByEventName = {};\n    var keyEventTypeName = (navigator && /Firefox\\/2/i.test(navigator.userAgent)) ? 'KeyboardEvent' : 'UIEvents';\n    knownEvents[keyEventTypeName] = ['keyup', 'keydown', 'keypress'];\n    knownEvents['MouseEvents'] = ['click', 'dblclick', 'mousedown', 'mouseup', 'mousemove', 'mouseover', 'mouseout', 'mouseenter', 'mouseleave'];\n    objectForEach(knownEvents, function(eventType, knownEventsForType) {\n        if (knownEventsForType.length) {\n            for (var i = 0, j = knownEventsForType.length; i < j; i++)\n                knownEventTypesByEventName[knownEventsForType[i]] = eventType;\n        }\n    });\n    var eventsThatMustBeRegisteredUsingAttachEvent = { 'propertychange': true }; // Workaround for an IE9 issue - https://github.com/SteveSanderson/knockout/issues/406\n\n    // Detect IE versions for bug workarounds (uses IE conditionals, not UA string, for robustness)\n    // Note that, since IE 10 does not support conditional comments, the following logic only detects IE < 10.\n    // Currently this is by design, since IE 10+ behaves correctly when treated as a standard browser.\n    // If there is a future need to detect specific versions of IE10+, we will amend this.\n    var ieVersion = document && (function() {\n        var version = 3, div = document.createElement('div'), iElems = div.getElementsByTagName('i');\n\n        // Keep constructing conditional HTML blocks until we hit one that resolves to an empty fragment\n        while (\n            div.innerHTML = '<!--[if gt IE ' + (++version) + ']><i></i><![endif]-->',\n            iElems[0]\n        ) {}\n        return version > 4 ? version : undefined;\n    }());\n    var isIe6 = ieVersion === 6,\n        isIe7 = ieVersion === 7;\n\n    function isClickOnCheckableElement(element, eventType) {\n        if ((ko.utils.tagNameLower(element) !== \"input\") || !element.type) return false;\n        if (eventType.toLowerCase() != \"click\") return false;\n        var inputType = element.type;\n        return (inputType == \"checkbox\") || (inputType == \"radio\");\n    }\n\n    // For details on the pattern for changing node classes\n    // see: https://github.com/knockout/knockout/issues/1597\n    var cssClassNameRegex = /\\S+/g;\n\n    function toggleDomNodeCssClass(node, classNames, shouldHaveClass) {\n        var addOrRemoveFn;\n        if (classNames) {\n            if (typeof node.classList === 'object') {\n                addOrRemoveFn = node.classList[shouldHaveClass ? 'add' : 'remove'];\n                ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n                    addOrRemoveFn.call(node.classList, className);\n                });\n            } else if (typeof node.className['baseVal'] === 'string') {\n                // SVG tag .classNames is an SVGAnimatedString instance\n                toggleObjectClassPropertyString(node.className, 'baseVal', classNames, shouldHaveClass);\n            } else {\n                // node.className ought to be a string.\n                toggleObjectClassPropertyString(node, 'className', classNames, shouldHaveClass);\n            }\n        }\n    }\n\n    function toggleObjectClassPropertyString(obj, prop, classNames, shouldHaveClass) {\n        // obj/prop is either a node/'className' or a SVGAnimatedString/'baseVal'.\n        var currentClassNames = obj[prop].match(cssClassNameRegex) || [];\n        ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {\n            ko.utils.addOrRemoveItem(currentClassNames, className, shouldHaveClass);\n        });\n        obj[prop] = currentClassNames.join(\" \");\n    }\n\n    return {\n        fieldsIncludedWithJsonPost: ['authenticity_token', /^__RequestVerificationToken(_.*)?$/],\n\n        arrayForEach: function (array, action) {\n            for (var i = 0, j = array.length; i < j; i++)\n                action(array[i], i);\n        },\n\n        arrayIndexOf: function (array, item) {\n            if (typeof Array.prototype.indexOf == \"function\")\n                return Array.prototype.indexOf.call(array, item);\n            for (var i = 0, j = array.length; i < j; i++)\n                if (array[i] === item)\n                    return i;\n            return -1;\n        },\n\n        arrayFirst: function (array, predicate, predicateOwner) {\n            for (var i = 0, j = array.length; i < j; i++)\n                if (predicate.call(predicateOwner, array[i], i))\n                    return array[i];\n            return null;\n        },\n\n        arrayRemoveItem: function (array, itemToRemove) {\n            var index = ko.utils.arrayIndexOf(array, itemToRemove);\n            if (index > 0) {\n                array.splice(index, 1);\n            }\n            else if (index === 0) {\n                array.shift();\n            }\n        },\n\n        arrayGetDistinctValues: function (array) {\n            array = array || [];\n            var result = [];\n            for (var i = 0, j = array.length; i < j; i++) {\n                if (ko.utils.arrayIndexOf(result, array[i]) < 0)\n                    result.push(array[i]);\n            }\n            return result;\n        },\n\n        arrayMap: function (array, mapping) {\n            array = array || [];\n            var result = [];\n            for (var i = 0, j = array.length; i < j; i++)\n                result.push(mapping(array[i], i));\n            return result;\n        },\n\n        arrayFilter: function (array, predicate) {\n            array = array || [];\n            var result = [];\n            for (var i = 0, j = array.length; i < j; i++)\n                if (predicate(array[i], i))\n                    result.push(array[i]);\n            return result;\n        },\n\n        arrayPushAll: function (array, valuesToPush) {\n            if (valuesToPush instanceof Array)\n                array.push.apply(array, valuesToPush);\n            else\n                for (var i = 0, j = valuesToPush.length; i < j; i++)\n                    array.push(valuesToPush[i]);\n            return array;\n        },\n\n        addOrRemoveItem: function(array, value, included) {\n            var existingEntryIndex = ko.utils.arrayIndexOf(ko.utils.peekObservable(array), value);\n            if (existingEntryIndex < 0) {\n                if (included)\n                    array.push(value);\n            } else {\n                if (!included)\n                    array.splice(existingEntryIndex, 1);\n            }\n        },\n\n        canSetPrototype: canSetPrototype,\n\n        extend: extend,\n\n        setPrototypeOf: setPrototypeOf,\n\n        setPrototypeOfOrExtend: canSetPrototype ? setPrototypeOf : extend,\n\n        objectForEach: objectForEach,\n\n        objectMap: function(source, mapping) {\n            if (!source)\n                return source;\n            var target = {};\n            for (var prop in source) {\n                if (source.hasOwnProperty(prop)) {\n                    target[prop] = mapping(source[prop], prop, source);\n                }\n            }\n            return target;\n        },\n\n        emptyDomNode: function (domNode) {\n            while (domNode.firstChild) {\n                ko.removeNode(domNode.firstChild);\n            }\n        },\n\n        moveCleanedNodesToContainerElement: function(nodes) {\n            // Ensure it's a real array, as we're about to reparent the nodes and\n            // we don't want the underlying collection to change while we're doing that.\n            var nodesArray = ko.utils.makeArray(nodes);\n            var templateDocument = (nodesArray[0] && nodesArray[0].ownerDocument) || document;\n\n            var container = templateDocument.createElement('div');\n            for (var i = 0, j = nodesArray.length; i < j; i++) {\n                container.appendChild(ko.cleanNode(nodesArray[i]));\n            }\n            return container;\n        },\n\n        cloneNodes: function (nodesArray, shouldCleanNodes) {\n            for (var i = 0, j = nodesArray.length, newNodesArray = []; i < j; i++) {\n                var clonedNode = nodesArray[i].cloneNode(true);\n                newNodesArray.push(shouldCleanNodes ? ko.cleanNode(clonedNode) : clonedNode);\n            }\n            return newNodesArray;\n        },\n\n        setDomNodeChildren: function (domNode, childNodes) {\n            ko.utils.emptyDomNode(domNode);\n            if (childNodes) {\n                for (var i = 0, j = childNodes.length; i < j; i++)\n                    domNode.appendChild(childNodes[i]);\n            }\n        },\n\n        replaceDomNodes: function (nodeToReplaceOrNodeArray, newNodesArray) {\n            var nodesToReplaceArray = nodeToReplaceOrNodeArray.nodeType ? [nodeToReplaceOrNodeArray] : nodeToReplaceOrNodeArray;\n            if (nodesToReplaceArray.length > 0) {\n                var insertionPoint = nodesToReplaceArray[0];\n                var parent = insertionPoint.parentNode;\n                for (var i = 0, j = newNodesArray.length; i < j; i++)\n                    parent.insertBefore(newNodesArray[i], insertionPoint);\n                for (var i = 0, j = nodesToReplaceArray.length; i < j; i++) {\n                    ko.removeNode(nodesToReplaceArray[i]);\n                }\n            }\n        },\n\n        fixUpContinuousNodeArray: function(continuousNodeArray, parentNode) {\n            // Before acting on a set of nodes that were previously outputted by a template function, we have to reconcile\n            // them against what is in the DOM right now. It may be that some of the nodes have already been removed, or that\n            // new nodes might have been inserted in the middle, for example by a binding. Also, there may previously have been\n            // leading comment nodes (created by rewritten string-based templates) that have since been removed during binding.\n            // So, this function translates the old \"map\" output array into its best guess of the set of current DOM nodes.\n            //\n            // Rules:\n            //   [A] Any leading nodes that have been removed should be ignored\n            //       These most likely correspond to memoization nodes that were already removed during binding\n            //       See https://github.com/knockout/knockout/pull/440\n            //   [B] Any trailing nodes that have been remove should be ignored\n            //       This prevents the code here from adding unrelated nodes to the array while processing rule [C]\n            //       See https://github.com/knockout/knockout/pull/1903\n            //   [C] We want to output a continuous series of nodes. So, ignore any nodes that have already been removed,\n            //       and include any nodes that have been inserted among the previous collection\n\n            if (continuousNodeArray.length) {\n                // The parent node can be a virtual element; so get the real parent node\n                parentNode = (parentNode.nodeType === 8 && parentNode.parentNode) || parentNode;\n\n                // Rule [A]\n                while (continuousNodeArray.length && continuousNodeArray[0].parentNode !== parentNode)\n                    continuousNodeArray.splice(0, 1);\n\n                // Rule [B]\n                while (continuousNodeArray.length > 1 && continuousNodeArray[continuousNodeArray.length - 1].parentNode !== parentNode)\n                    continuousNodeArray.length--;\n\n                // Rule [C]\n                if (continuousNodeArray.length > 1) {\n                    var current = continuousNodeArray[0], last = continuousNodeArray[continuousNodeArray.length - 1];\n                    // Replace with the actual new continuous node set\n                    continuousNodeArray.length = 0;\n                    while (current !== last) {\n                        continuousNodeArray.push(current);\n                        current = current.nextSibling;\n                    }\n                    continuousNodeArray.push(last);\n                }\n            }\n            return continuousNodeArray;\n        },\n\n        setOptionNodeSelectionState: function (optionNode, isSelected) {\n            // IE6 sometimes throws \"unknown error\" if you try to write to .selected directly, whereas Firefox struggles with setAttribute. Pick one based on browser.\n            if (ieVersion < 7)\n                optionNode.setAttribute(\"selected\", isSelected);\n            else\n                optionNode.selected = isSelected;\n        },\n\n        stringTrim: function (string) {\n            return string === null || string === undefined ? '' :\n                string.trim ?\n                    string.trim() :\n                    string.toString().replace(/^[\\s\\xa0]+|[\\s\\xa0]+$/g, '');\n        },\n\n        stringStartsWith: function (string, startsWith) {\n            string = string || \"\";\n            if (startsWith.length > string.length)\n                return false;\n            return string.substring(0, startsWith.length) === startsWith;\n        },\n\n        domNodeIsContainedBy: function (node, containedByNode) {\n            if (node === containedByNode)\n                return true;\n            if (node.nodeType === 11)\n                return false; // Fixes issue #1162 - can't use node.contains for document fragments on IE8\n            if (containedByNode.contains)\n                return containedByNode.contains(node.nodeType === 3 ? node.parentNode : node);\n            if (containedByNode.compareDocumentPosition)\n                return (containedByNode.compareDocumentPosition(node) & 16) == 16;\n            while (node && node != containedByNode) {\n                node = node.parentNode;\n            }\n            return !!node;\n        },\n\n        domNodeIsAttachedToDocument: function (node) {\n            return ko.utils.domNodeIsContainedBy(node, node.ownerDocument.documentElement);\n        },\n\n        anyDomNodeIsAttachedToDocument: function(nodes) {\n            return !!ko.utils.arrayFirst(nodes, ko.utils.domNodeIsAttachedToDocument);\n        },\n\n        tagNameLower: function(element) {\n            // For HTML elements, tagName will always be upper case; for XHTML elements, it'll be lower case.\n            // Possible future optimization: If we know it's an element from an XHTML document (not HTML),\n            // we don't need to do the .toLowerCase() as it will always be lower case anyway.\n            return element && element.tagName && element.tagName.toLowerCase();\n        },\n\n        catchFunctionErrors: function (delegate) {\n            return ko['onError'] ? function () {\n                try {\n                    return delegate.apply(this, arguments);\n                } catch (e) {\n                    ko['onError'] && ko['onError'](e);\n                    throw e;\n                }\n            } : delegate;\n        },\n\n        setTimeout: function (handler, timeout) {\n            return setTimeout(ko.utils.catchFunctionErrors(handler), timeout);\n        },\n\n        deferError: function (error) {\n            setTimeout(function () {\n                ko['onError'] && ko['onError'](error);\n                throw error;\n            }, 0);\n        },\n\n        registerEventHandler: function (element, eventType, handler) {\n            var wrappedHandler = ko.utils.catchFunctionErrors(handler);\n\n            var mustUseAttachEvent = ieVersion && eventsThatMustBeRegisteredUsingAttachEvent[eventType];\n            if (!ko.options['useOnlyNativeEvents'] && !mustUseAttachEvent && jQueryInstance) {\n                jQueryInstance(element)['bind'](eventType, wrappedHandler);\n            } else if (!mustUseAttachEvent && typeof element.addEventListener == \"function\")\n                element.addEventListener(eventType, wrappedHandler, false);\n            else if (typeof element.attachEvent != \"undefined\") {\n                var attachEventHandler = function (event) { wrappedHandler.call(element, event); },\n                    attachEventName = \"on\" + eventType;\n                element.attachEvent(attachEventName, attachEventHandler);\n\n                // IE does not dispose attachEvent handlers automatically (unlike with addEventListener)\n                // so to avoid leaks, we have to remove them manually. See bug #856\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function() {\n                    element.detachEvent(attachEventName, attachEventHandler);\n                });\n            } else\n                throw new Error(\"Browser doesn't support addEventListener or attachEvent\");\n        },\n\n        triggerEvent: function (element, eventType) {\n            if (!(element && element.nodeType))\n                throw new Error(\"element must be a DOM node when calling triggerEvent\");\n\n            // For click events on checkboxes and radio buttons, jQuery toggles the element checked state *after* the\n            // event handler runs instead of *before*. (This was fixed in 1.9 for checkboxes but not for radio buttons.)\n            // IE doesn't change the checked state when you trigger the click event using \"fireEvent\".\n            // In both cases, we'll use the click method instead.\n            var useClickWorkaround = isClickOnCheckableElement(element, eventType);\n\n            if (!ko.options['useOnlyNativeEvents'] && jQueryInstance && !useClickWorkaround) {\n                jQueryInstance(element)['trigger'](eventType);\n            } else if (typeof document.createEvent == \"function\") {\n                if (typeof element.dispatchEvent == \"function\") {\n                    var eventCategory = knownEventTypesByEventName[eventType] || \"HTMLEvents\";\n                    var event = document.createEvent(eventCategory);\n                    event.initEvent(eventType, true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, element);\n                    element.dispatchEvent(event);\n                }\n                else\n                    throw new Error(\"The supplied element doesn't support dispatchEvent\");\n            } else if (useClickWorkaround && element.click) {\n                element.click();\n            } else if (typeof element.fireEvent != \"undefined\") {\n                element.fireEvent(\"on\" + eventType);\n            } else {\n                throw new Error(\"Browser doesn't support triggering events\");\n            }\n        },\n\n        unwrapObservable: function (value) {\n            return ko.isObservable(value) ? value() : value;\n        },\n\n        peekObservable: function (value) {\n            return ko.isObservable(value) ? value.peek() : value;\n        },\n\n        toggleDomNodeCssClass: toggleDomNodeCssClass,\n\n        setTextContent: function(element, textContent) {\n            var value = ko.utils.unwrapObservable(textContent);\n            if ((value === null) || (value === undefined))\n                value = \"\";\n\n            // We need there to be exactly one child: a text node.\n            // If there are no children, more than one, or if it's not a text node,\n            // we'll clear everything and create a single text node.\n            var innerTextNode = ko.virtualElements.firstChild(element);\n            if (!innerTextNode || innerTextNode.nodeType != 3 || ko.virtualElements.nextSibling(innerTextNode)) {\n                ko.virtualElements.setDomNodeChildren(element, [element.ownerDocument.createTextNode(value)]);\n            } else {\n                innerTextNode.data = value;\n            }\n\n            ko.utils.forceRefresh(element);\n        },\n\n        setElementName: function(element, name) {\n            element.name = name;\n        },\n\n        forceRefresh: function(node) {\n            // Workaround for an IE9 rendering bug - https://github.com/SteveSanderson/knockout/issues/209\n            if (ieVersion >= 9) {\n                // For text nodes and comment nodes (most likely virtual elements), we will have to refresh the container\n                var elem = node.nodeType == 1 ? node : node.parentNode;\n                if (elem.style)\n                    elem.style.zoom = elem.style.zoom;\n            }\n        },\n\n        ensureSelectElementIsRenderedCorrectly: function(selectElement) {\n            // Workaround for IE9 rendering bug - it doesn't reliably display all the text in dynamically-added select boxes unless you force it to re-render by updating the width.\n            // (See https://github.com/SteveSanderson/knockout/issues/312, http://stackoverflow.com/questions/5908494/select-only-shows-first-char-of-selected-option)\n            // Also fixes IE7 and IE8 bug that causes selects to be zero width if enclosed by 'if' or 'with'. (See issue #839)\n            if (ieVersion) {\n                var originalWidth = selectElement.style.width;\n                selectElement.style.width = 0;\n                selectElement.style.width = originalWidth;\n            }\n        },\n\n        range: function (min, max) {\n            min = ko.utils.unwrapObservable(min);\n            max = ko.utils.unwrapObservable(max);\n            var result = [];\n            for (var i = min; i <= max; i++)\n                result.push(i);\n            return result;\n        },\n\n        makeArray: function(arrayLikeObject) {\n            var result = [];\n            for (var i = 0, j = arrayLikeObject.length; i < j; i++) {\n                result.push(arrayLikeObject[i]);\n            };\n            return result;\n        },\n\n        createSymbolOrString: function(identifier) {\n            return canUseSymbols ? Symbol(identifier) : identifier;\n        },\n\n        isIe6 : isIe6,\n        isIe7 : isIe7,\n        ieVersion : ieVersion,\n\n        getFormFields: function(form, fieldName) {\n            var fields = ko.utils.makeArray(form.getElementsByTagName(\"input\")).concat(ko.utils.makeArray(form.getElementsByTagName(\"textarea\")));\n            var isMatchingField = (typeof fieldName == 'string')\n                ? function(field) { return field.name === fieldName }\n                : function(field) { return fieldName.test(field.name) }; // Treat fieldName as regex or object containing predicate\n            var matches = [];\n            for (var i = fields.length - 1; i >= 0; i--) {\n                if (isMatchingField(fields[i]))\n                    matches.push(fields[i]);\n            };\n            return matches;\n        },\n\n        parseJson: function (jsonString) {\n            if (typeof jsonString == \"string\") {\n                jsonString = ko.utils.stringTrim(jsonString);\n                if (jsonString) {\n                    if (JSON && JSON.parse) // Use native parsing where available\n                        return JSON.parse(jsonString);\n                    return (new Function(\"return \" + jsonString))(); // Fallback on less safe parsing for older browsers\n                }\n            }\n            return null;\n        },\n\n        stringifyJson: function (data, replacer, space) {   // replacer and space are optional\n            if (!JSON || !JSON.stringify)\n                throw new Error(\"Cannot find JSON.stringify(). Some browsers (e.g., IE < 8) don't support it natively, but you can overcome this by adding a script reference to json2.js, downloadable from http://www.json.org/json2.js\");\n            return JSON.stringify(ko.utils.unwrapObservable(data), replacer, space);\n        },\n\n        postJson: function (urlOrForm, data, options) {\n            options = options || {};\n            var params = options['params'] || {};\n            var includeFields = options['includeFields'] || this.fieldsIncludedWithJsonPost;\n            var url = urlOrForm;\n\n            // If we were given a form, use its 'action' URL and pick out any requested field values\n            if((typeof urlOrForm == 'object') && (ko.utils.tagNameLower(urlOrForm) === \"form\")) {\n                var originalForm = urlOrForm;\n                url = originalForm.action;\n                for (var i = includeFields.length - 1; i >= 0; i--) {\n                    var fields = ko.utils.getFormFields(originalForm, includeFields[i]);\n                    for (var j = fields.length - 1; j >= 0; j--)\n                        params[fields[j].name] = fields[j].value;\n                }\n            }\n\n            data = ko.utils.unwrapObservable(data);\n            var form = document.createElement(\"form\");\n            form.style.display = \"none\";\n            form.action = url;\n            form.method = \"post\";\n            for (var key in data) {\n                // Since 'data' this is a model object, we include all properties including those inherited from its prototype\n                var input = document.createElement(\"input\");\n                input.type = \"hidden\";\n                input.name = key;\n                input.value = ko.utils.stringifyJson(ko.utils.unwrapObservable(data[key]));\n                form.appendChild(input);\n            }\n            objectForEach(params, function(key, value) {\n                var input = document.createElement(\"input\");\n                input.type = \"hidden\";\n                input.name = key;\n                input.value = value;\n                form.appendChild(input);\n            });\n            document.body.appendChild(form);\n            options['submitter'] ? options['submitter'](form) : form.submit();\n            setTimeout(function () { form.parentNode.removeChild(form); }, 0);\n        }\n    }\n}());\n\nko.exportSymbol('utils', ko.utils);\nko.exportSymbol('utils.arrayForEach', ko.utils.arrayForEach);\nko.exportSymbol('utils.arrayFirst', ko.utils.arrayFirst);\nko.exportSymbol('utils.arrayFilter', ko.utils.arrayFilter);\nko.exportSymbol('utils.arrayGetDistinctValues', ko.utils.arrayGetDistinctValues);\nko.exportSymbol('utils.arrayIndexOf', ko.utils.arrayIndexOf);\nko.exportSymbol('utils.arrayMap', ko.utils.arrayMap);\nko.exportSymbol('utils.arrayPushAll', ko.utils.arrayPushAll);\nko.exportSymbol('utils.arrayRemoveItem', ko.utils.arrayRemoveItem);\nko.exportSymbol('utils.extend', ko.utils.extend);\nko.exportSymbol('utils.fieldsIncludedWithJsonPost', ko.utils.fieldsIncludedWithJsonPost);\nko.exportSymbol('utils.getFormFields', ko.utils.getFormFields);\nko.exportSymbol('utils.peekObservable', ko.utils.peekObservable);\nko.exportSymbol('utils.postJson', ko.utils.postJson);\nko.exportSymbol('utils.parseJson', ko.utils.parseJson);\nko.exportSymbol('utils.registerEventHandler', ko.utils.registerEventHandler);\nko.exportSymbol('utils.stringifyJson', ko.utils.stringifyJson);\nko.exportSymbol('utils.range', ko.utils.range);\nko.exportSymbol('utils.toggleDomNodeCssClass', ko.utils.toggleDomNodeCssClass);\nko.exportSymbol('utils.triggerEvent', ko.utils.triggerEvent);\nko.exportSymbol('utils.unwrapObservable', ko.utils.unwrapObservable);\nko.exportSymbol('utils.objectForEach', ko.utils.objectForEach);\nko.exportSymbol('utils.addOrRemoveItem', ko.utils.addOrRemoveItem);\nko.exportSymbol('utils.setTextContent', ko.utils.setTextContent);\nko.exportSymbol('unwrap', ko.utils.unwrapObservable); // Convenient shorthand, because this is used so commonly\n\nif (!Function.prototype['bind']) {\n    // Function.prototype.bind is a standard part of ECMAScript 5th Edition (December 2009, http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-262.pdf)\n    // In case the browser doesn't implement it natively, provide a JavaScript implementation. This implementation is based on the one in prototype.js\n    Function.prototype['bind'] = function (object) {\n        var originalFunction = this;\n        if (arguments.length === 1) {\n            return function () {\n                return originalFunction.apply(object, arguments);\n            };\n        } else {\n            var partialArgs = Array.prototype.slice.call(arguments, 1);\n            return function () {\n                var args = partialArgs.slice(0);\n                args.push.apply(args, arguments);\n                return originalFunction.apply(object, args);\n            };\n        }\n    };\n}\n\nko.utils.domData = new (function () {\n    var uniqueId = 0;\n    var dataStoreKeyExpandoPropertyName = \"__ko__\" + (new Date).getTime();\n    var dataStore = {};\n\n    function getAll(node, createIfNotFound) {\n        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n        var hasExistingDataStore = dataStoreKey && (dataStoreKey !== \"null\") && dataStore[dataStoreKey];\n        if (!hasExistingDataStore) {\n            if (!createIfNotFound)\n                return undefined;\n            dataStoreKey = node[dataStoreKeyExpandoPropertyName] = \"ko\" + uniqueId++;\n            dataStore[dataStoreKey] = {};\n        }\n        return dataStore[dataStoreKey];\n    }\n\n    return {\n        get: function (node, key) {\n            var allDataForNode = getAll(node, false);\n            return allDataForNode === undefined ? undefined : allDataForNode[key];\n        },\n        set: function (node, key, value) {\n            if (value === undefined) {\n                // Make sure we don't actually create a new domData key if we are actually deleting a value\n                if (getAll(node, false) === undefined)\n                    return;\n            }\n            var allDataForNode = getAll(node, true);\n            allDataForNode[key] = value;\n        },\n        clear: function (node) {\n            var dataStoreKey = node[dataStoreKeyExpandoPropertyName];\n            if (dataStoreKey) {\n                delete dataStore[dataStoreKey];\n                node[dataStoreKeyExpandoPropertyName] = null;\n                return true; // Exposing \"did clean\" flag purely so specs can infer whether things have been cleaned up as intended\n            }\n            return false;\n        },\n\n        nextKey: function () {\n            return (uniqueId++) + dataStoreKeyExpandoPropertyName;\n        }\n    };\n})();\n\nko.exportSymbol('utils.domData', ko.utils.domData);\nko.exportSymbol('utils.domData.clear', ko.utils.domData.clear); // Exporting only so specs can clear up after themselves fully\n\nko.utils.domNodeDisposal = new (function () {\n    var domDataKey = ko.utils.domData.nextKey();\n    var cleanableNodeTypes = { 1: true, 8: true, 9: true };       // Element, Comment, Document\n    var cleanableNodeTypesWithDescendants = { 1: true, 9: true }; // Element, Document\n\n    function getDisposeCallbacksCollection(node, createIfNotFound) {\n        var allDisposeCallbacks = ko.utils.domData.get(node, domDataKey);\n        if ((allDisposeCallbacks === undefined) && createIfNotFound) {\n            allDisposeCallbacks = [];\n            ko.utils.domData.set(node, domDataKey, allDisposeCallbacks);\n        }\n        return allDisposeCallbacks;\n    }\n    function destroyCallbacksCollection(node) {\n        ko.utils.domData.set(node, domDataKey, undefined);\n    }\n\n    function cleanSingleNode(node) {\n        // Run all the dispose callbacks\n        var callbacks = getDisposeCallbacksCollection(node, false);\n        if (callbacks) {\n            callbacks = callbacks.slice(0); // Clone, as the array may be modified during iteration (typically, callbacks will remove themselves)\n            for (var i = 0; i < callbacks.length; i++)\n                callbacks[i](node);\n        }\n\n        // Erase the DOM data\n        ko.utils.domData.clear(node);\n\n        // Perform cleanup needed by external libraries (currently only jQuery, but can be extended)\n        ko.utils.domNodeDisposal[\"cleanExternalData\"](node);\n\n        // Clear any immediate-child comment nodes, as these wouldn't have been found by\n        // node.getElementsByTagName(\"*\") in cleanNode() (comment nodes aren't elements)\n        if (cleanableNodeTypesWithDescendants[node.nodeType])\n            cleanImmediateCommentTypeChildren(node);\n    }\n\n    function cleanImmediateCommentTypeChildren(nodeWithChildren) {\n        var child, nextChild = nodeWithChildren.firstChild;\n        while (child = nextChild) {\n            nextChild = child.nextSibling;\n            if (child.nodeType === 8)\n                cleanSingleNode(child);\n        }\n    }\n\n    return {\n        addDisposeCallback : function(node, callback) {\n            if (typeof callback != \"function\")\n                throw new Error(\"Callback must be a function\");\n            getDisposeCallbacksCollection(node, true).push(callback);\n        },\n\n        removeDisposeCallback : function(node, callback) {\n            var callbacksCollection = getDisposeCallbacksCollection(node, false);\n            if (callbacksCollection) {\n                ko.utils.arrayRemoveItem(callbacksCollection, callback);\n                if (callbacksCollection.length == 0)\n                    destroyCallbacksCollection(node);\n            }\n        },\n\n        cleanNode : function(node) {\n            // First clean this node, where applicable\n            if (cleanableNodeTypes[node.nodeType]) {\n                cleanSingleNode(node);\n\n                // ... then its descendants, where applicable\n                if (cleanableNodeTypesWithDescendants[node.nodeType]) {\n                    // Clone the descendants list in case it changes during iteration\n                    var descendants = [];\n                    ko.utils.arrayPushAll(descendants, node.getElementsByTagName(\"*\"));\n                    for (var i = 0, j = descendants.length; i < j; i++)\n                        cleanSingleNode(descendants[i]);\n                }\n            }\n            return node;\n        },\n\n        removeNode : function(node) {\n            ko.cleanNode(node);\n            if (node.parentNode)\n                node.parentNode.removeChild(node);\n        },\n\n        \"cleanExternalData\" : function (node) {\n            // Special support for jQuery here because it's so commonly used.\n            // Many jQuery plugins (including jquery.tmpl) store data using jQuery's equivalent of domData\n            // so notify it to tear down any resources associated with the node & descendants here.\n            if (jQueryInstance && (typeof jQueryInstance['cleanData'] == \"function\"))\n                jQueryInstance['cleanData']([node]);\n        }\n    };\n})();\nko.cleanNode = ko.utils.domNodeDisposal.cleanNode; // Shorthand name for convenience\nko.removeNode = ko.utils.domNodeDisposal.removeNode; // Shorthand name for convenience\nko.exportSymbol('cleanNode', ko.cleanNode);\nko.exportSymbol('removeNode', ko.removeNode);\nko.exportSymbol('utils.domNodeDisposal', ko.utils.domNodeDisposal);\nko.exportSymbol('utils.domNodeDisposal.addDisposeCallback', ko.utils.domNodeDisposal.addDisposeCallback);\nko.exportSymbol('utils.domNodeDisposal.removeDisposeCallback', ko.utils.domNodeDisposal.removeDisposeCallback);\n(function () {\n    var none = [0, \"\", \"\"],\n        table = [1, \"<table>\", \"</table>\"],\n        tbody = [2, \"<table><tbody>\", \"</tbody></table>\"],\n        tr = [3, \"<table><tbody><tr>\", \"</tr></tbody></table>\"],\n        select = [1, \"<select multiple='multiple'>\", \"</select>\"],\n        lookup = {\n            'thead': table,\n            'tbody': table,\n            'tfoot': table,\n            'tr': tbody,\n            'td': tr,\n            'th': tr,\n            'option': select,\n            'optgroup': select\n        },\n\n        // This is needed for old IE if you're *not* using either jQuery or innerShiv. Doesn't affect other cases.\n        mayRequireCreateElementHack = ko.utils.ieVersion <= 8;\n\n    function getWrap(tags) {\n        var m = tags.match(/^<([a-z]+)[ >]/);\n        return (m && lookup[m[1]]) || none;\n    }\n\n    function simpleHtmlParse(html, documentContext) {\n        documentContext || (documentContext = document);\n        var windowContext = documentContext['parentWindow'] || documentContext['defaultView'] || window;\n\n        // Based on jQuery's \"clean\" function, but only accounting for table-related elements.\n        // If you have referenced jQuery, this won't be used anyway - KO will use jQuery's \"clean\" function directly\n\n        // Note that there's still an issue in IE < 9 whereby it will discard comment nodes that are the first child of\n        // a descendant node. For example: \"<div><!-- mycomment -->abc</div>\" will get parsed as \"<div>abc</div>\"\n        // This won't affect anyone who has referenced jQuery, and there's always the workaround of inserting a dummy node\n        // (possibly a text node) in front of the comment. So, KO does not attempt to workaround this IE issue automatically at present.\n\n        // Trim whitespace, otherwise indexOf won't work as expected\n        var tags = ko.utils.stringTrim(html).toLowerCase(), div = documentContext.createElement(\"div\"),\n            wrap = getWrap(tags),\n            depth = wrap[0];\n\n        // Go to html and back, then peel off extra wrappers\n        // Note that we always prefix with some dummy text, because otherwise, IE<9 will strip out leading comment nodes in descendants. Total madness.\n        var markup = \"ignored<div>\" + wrap[1] + html + wrap[2] + \"</div>\";\n        if (typeof windowContext['innerShiv'] == \"function\") {\n            // Note that innerShiv is deprecated in favour of html5shiv. We should consider adding\n            // support for html5shiv (except if no explicit support is needed, e.g., if html5shiv\n            // somehow shims the native APIs so it just works anyway)\n            div.appendChild(windowContext['innerShiv'](markup));\n        } else {\n            if (mayRequireCreateElementHack) {\n                // The document.createElement('my-element') trick to enable custom elements in IE6-8\n                // only works if we assign innerHTML on an element associated with that document.\n                documentContext.appendChild(div);\n            }\n\n            div.innerHTML = markup;\n\n            if (mayRequireCreateElementHack) {\n                div.parentNode.removeChild(div);\n            }\n        }\n\n        // Move to the right depth\n        while (depth--)\n            div = div.lastChild;\n\n        return ko.utils.makeArray(div.lastChild.childNodes);\n    }\n\n    function jQueryHtmlParse(html, documentContext) {\n        // jQuery's \"parseHTML\" function was introduced in jQuery 1.8.0 and is a documented public API.\n        if (jQueryInstance['parseHTML']) {\n            return jQueryInstance['parseHTML'](html, documentContext) || []; // Ensure we always return an array and never null\n        } else {\n            // For jQuery < 1.8.0, we fall back on the undocumented internal \"clean\" function.\n            var elems = jQueryInstance['clean']([html], documentContext);\n\n            // As of jQuery 1.7.1, jQuery parses the HTML by appending it to some dummy parent nodes held in an in-memory document fragment.\n            // Unfortunately, it never clears the dummy parent nodes from the document fragment, so it leaks memory over time.\n            // Fix this by finding the top-most dummy parent element, and detaching it from its owner fragment.\n            if (elems && elems[0]) {\n                // Find the top-most parent element that's a direct child of a document fragment\n                var elem = elems[0];\n                while (elem.parentNode && elem.parentNode.nodeType !== 11 /* i.e., DocumentFragment */)\n                    elem = elem.parentNode;\n                // ... then detach it\n                if (elem.parentNode)\n                    elem.parentNode.removeChild(elem);\n            }\n\n            return elems;\n        }\n    }\n\n    ko.utils.parseHtmlFragment = function(html, documentContext) {\n        return jQueryInstance ?\n            jQueryHtmlParse(html, documentContext) :   // As below, benefit from jQuery's optimisations where possible\n            simpleHtmlParse(html, documentContext);  // ... otherwise, this simple logic will do in most common cases.\n    };\n\n    ko.utils.setHtml = function(node, html) {\n        ko.utils.emptyDomNode(node);\n\n        // There's no legitimate reason to display a stringified observable without unwrapping it, so we'll unwrap it\n        html = ko.utils.unwrapObservable(html);\n\n        if ((html !== null) && (html !== undefined)) {\n            if (typeof html != 'string')\n                html = html.toString();\n\n            // jQuery contains a lot of sophisticated code to parse arbitrary HTML fragments,\n            // for example <tr> elements which are not normally allowed to exist on their own.\n            // If you've referenced jQuery we'll use that rather than duplicating its code.\n            if (jQueryInstance) {\n                jQueryInstance(node)['html'](html);\n            } else {\n                // ... otherwise, use KO's own parsing logic.\n                var parsedNodes = ko.utils.parseHtmlFragment(html, node.ownerDocument);\n                for (var i = 0; i < parsedNodes.length; i++)\n                    node.appendChild(parsedNodes[i]);\n            }\n        }\n    };\n})();\n\nko.exportSymbol('utils.parseHtmlFragment', ko.utils.parseHtmlFragment);\nko.exportSymbol('utils.setHtml', ko.utils.setHtml);\n\nko.memoization = (function () {\n    var memos = {};\n\n    function randomMax8HexChars() {\n        return (((1 + Math.random()) * 0x100000000) | 0).toString(16).substring(1);\n    }\n    function generateRandomId() {\n        return randomMax8HexChars() + randomMax8HexChars();\n    }\n    function findMemoNodes(rootNode, appendToArray) {\n        if (!rootNode)\n            return;\n        if (rootNode.nodeType == 8) {\n            var memoId = ko.memoization.parseMemoText(rootNode.nodeValue);\n            if (memoId != null)\n                appendToArray.push({ domNode: rootNode, memoId: memoId });\n        } else if (rootNode.nodeType == 1) {\n            for (var i = 0, childNodes = rootNode.childNodes, j = childNodes.length; i < j; i++)\n                findMemoNodes(childNodes[i], appendToArray);\n        }\n    }\n\n    return {\n        memoize: function (callback) {\n            if (typeof callback != \"function\")\n                throw new Error(\"You can only pass a function to ko.memoization.memoize()\");\n            var memoId = generateRandomId();\n            memos[memoId] = callback;\n            return \"<!--[ko_memo:\" + memoId + \"]-->\";\n        },\n\n        unmemoize: function (memoId, callbackParams) {\n            var callback = memos[memoId];\n            if (callback === undefined)\n                throw new Error(\"Couldn't find any memo with ID \" + memoId + \". Perhaps it's already been unmemoized.\");\n            try {\n                callback.apply(null, callbackParams || []);\n                return true;\n            }\n            finally { delete memos[memoId]; }\n        },\n\n        unmemoizeDomNodeAndDescendants: function (domNode, extraCallbackParamsArray) {\n            var memos = [];\n            findMemoNodes(domNode, memos);\n            for (var i = 0, j = memos.length; i < j; i++) {\n                var node = memos[i].domNode;\n                var combinedParams = [node];\n                if (extraCallbackParamsArray)\n                    ko.utils.arrayPushAll(combinedParams, extraCallbackParamsArray);\n                ko.memoization.unmemoize(memos[i].memoId, combinedParams);\n                node.nodeValue = \"\"; // Neuter this node so we don't try to unmemoize it again\n                if (node.parentNode)\n                    node.parentNode.removeChild(node); // If possible, erase it totally (not always possible - someone else might just hold a reference to it then call unmemoizeDomNodeAndDescendants again)\n            }\n        },\n\n        parseMemoText: function (memoText) {\n            var match = memoText.match(/^\\[ko_memo\\:(.*?)\\]$/);\n            return match ? match[1] : null;\n        }\n    };\n})();\n\nko.exportSymbol('memoization', ko.memoization);\nko.exportSymbol('memoization.memoize', ko.memoization.memoize);\nko.exportSymbol('memoization.unmemoize', ko.memoization.unmemoize);\nko.exportSymbol('memoization.parseMemoText', ko.memoization.parseMemoText);\nko.exportSymbol('memoization.unmemoizeDomNodeAndDescendants', ko.memoization.unmemoizeDomNodeAndDescendants);\nko.tasks = (function () {\n    var scheduler,\n        taskQueue = [],\n        taskQueueLength = 0,\n        nextHandle = 1,\n        nextIndexToProcess = 0;\n\n    if (window['MutationObserver']) {\n        // Chrome 27+, Firefox 14+, IE 11+, Opera 15+, Safari 6.1+\n        // From https://github.com/petkaantonov/bluebird * Copyright (c) 2014 Petka Antonov * License: MIT\n        scheduler = (function (callback) {\n            var div = document.createElement(\"div\");\n            new MutationObserver(callback).observe(div, {attributes: true});\n            return function () { div.classList.toggle(\"foo\"); };\n        })(scheduledProcess);\n    } else if (document && \"onreadystatechange\" in document.createElement(\"script\")) {\n        // IE 6-10\n        // From https://github.com/YuzuJS/setImmediate * Copyright (c) 2012 Barnesandnoble.com, llc, Donavon West, and Domenic Denicola * License: MIT\n        scheduler = function (callback) {\n            var script = document.createElement(\"script\");\n            script.onreadystatechange = function () {\n                script.onreadystatechange = null;\n                document.documentElement.removeChild(script);\n                script = null;\n                callback();\n            };\n            document.documentElement.appendChild(script);\n        };\n    } else {\n        scheduler = function (callback) {\n            setTimeout(callback, 0);\n        };\n    }\n\n    function processTasks() {\n        if (taskQueueLength) {\n            // Each mark represents the end of a logical group of tasks and the number of these groups is\n            // limited to prevent unchecked recursion.\n            var mark = taskQueueLength, countMarks = 0;\n\n            // nextIndexToProcess keeps track of where we are in the queue; processTasks can be called recursively without issue\n            for (var task; nextIndexToProcess < taskQueueLength; ) {\n                if (task = taskQueue[nextIndexToProcess++]) {\n                    if (nextIndexToProcess > mark) {\n                        if (++countMarks >= 5000) {\n                            nextIndexToProcess = taskQueueLength;   // skip all tasks remaining in the queue since any of them could be causing the recursion\n                            ko.utils.deferError(Error(\"'Too much recursion' after processing \" + countMarks + \" task groups.\"));\n                            break;\n                        }\n                        mark = taskQueueLength;\n                    }\n                    try {\n                        task();\n                    } catch (ex) {\n                        ko.utils.deferError(ex);\n                    }\n                }\n            }\n        }\n    }\n\n    function scheduledProcess() {\n        processTasks();\n\n        // Reset the queue\n        nextIndexToProcess = taskQueueLength = taskQueue.length = 0;\n    }\n\n    function scheduleTaskProcessing() {\n        ko.tasks['scheduler'](scheduledProcess);\n    }\n\n    var tasks = {\n        'scheduler': scheduler,     // Allow overriding the scheduler\n\n        schedule: function (func) {\n            if (!taskQueueLength) {\n                scheduleTaskProcessing();\n            }\n\n            taskQueue[taskQueueLength++] = func;\n            return nextHandle++;\n        },\n\n        cancel: function (handle) {\n            var index = handle - (nextHandle - taskQueueLength);\n            if (index >= nextIndexToProcess && index < taskQueueLength) {\n                taskQueue[index] = null;\n            }\n        },\n\n        // For testing only: reset the queue and return the previous queue length\n        'resetForTesting': function () {\n            var length = taskQueueLength - nextIndexToProcess;\n            nextIndexToProcess = taskQueueLength = taskQueue.length = 0;\n            return length;\n        },\n\n        runEarly: processTasks\n    };\n\n    return tasks;\n})();\n\nko.exportSymbol('tasks', ko.tasks);\nko.exportSymbol('tasks.schedule', ko.tasks.schedule);\n//ko.exportSymbol('tasks.cancel', ko.tasks.cancel);  \"cancel\" isn't minified\nko.exportSymbol('tasks.runEarly', ko.tasks.runEarly);\nko.extenders = {\n    'throttle': function(target, timeout) {\n        // Throttling means two things:\n\n        // (1) For dependent observables, we throttle *evaluations* so that, no matter how fast its dependencies\n        //     notify updates, the target doesn't re-evaluate (and hence doesn't notify) faster than a certain rate\n        target['throttleEvaluation'] = timeout;\n\n        // (2) For writable targets (observables, or writable dependent observables), we throttle *writes*\n        //     so the target cannot change value synchronously or faster than a certain rate\n        var writeTimeoutInstance = null;\n        return ko.dependentObservable({\n            'read': target,\n            'write': function(value) {\n                clearTimeout(writeTimeoutInstance);\n                writeTimeoutInstance = ko.utils.setTimeout(function() {\n                    target(value);\n                }, timeout);\n            }\n        });\n    },\n\n    'rateLimit': function(target, options) {\n        var timeout, method, limitFunction;\n\n        if (typeof options == 'number') {\n            timeout = options;\n        } else {\n            timeout = options['timeout'];\n            method = options['method'];\n        }\n\n        // rateLimit supersedes deferred updates\n        target._deferUpdates = false;\n\n        limitFunction = method == 'notifyWhenChangesStop' ?  debounce : throttle;\n        target.limit(function(callback) {\n            return limitFunction(callback, timeout);\n        });\n    },\n\n    'deferred': function(target, options) {\n        if (options !== true) {\n            throw new Error('The \\'deferred\\' extender only accepts the value \\'true\\', because it is not supported to turn deferral off once enabled.')\n        }\n\n        if (!target._deferUpdates) {\n            target._deferUpdates = true;\n            target.limit(function (callback) {\n                var handle,\n                    ignoreUpdates = false;\n                return function () {\n                    if (!ignoreUpdates) {\n                        ko.tasks.cancel(handle);\n                        handle = ko.tasks.schedule(callback);\n\n                        try {\n                            ignoreUpdates = true;\n                            target['notifySubscribers'](undefined, 'dirty');\n                        } finally {\n                            ignoreUpdates = false;\n                        }\n                    }\n                };\n            });\n        }\n    },\n\n    'notify': function(target, notifyWhen) {\n        target[\"equalityComparer\"] = notifyWhen == \"always\" ?\n            null :  // null equalityComparer means to always notify\n            valuesArePrimitiveAndEqual;\n    }\n};\n\nvar primitiveTypes = { 'undefined':1, 'boolean':1, 'number':1, 'string':1 };\nfunction valuesArePrimitiveAndEqual(a, b) {\n    var oldValueIsPrimitive = (a === null) || (typeof(a) in primitiveTypes);\n    return oldValueIsPrimitive ? (a === b) : false;\n}\n\nfunction throttle(callback, timeout) {\n    var timeoutInstance;\n    return function () {\n        if (!timeoutInstance) {\n            timeoutInstance = ko.utils.setTimeout(function () {\n                timeoutInstance = undefined;\n                callback();\n            }, timeout);\n        }\n    };\n}\n\nfunction debounce(callback, timeout) {\n    var timeoutInstance;\n    return function () {\n        clearTimeout(timeoutInstance);\n        timeoutInstance = ko.utils.setTimeout(callback, timeout);\n    };\n}\n\nfunction applyExtenders(requestedExtenders) {\n    var target = this;\n    if (requestedExtenders) {\n        ko.utils.objectForEach(requestedExtenders, function(key, value) {\n            var extenderHandler = ko.extenders[key];\n            if (typeof extenderHandler == 'function') {\n                target = extenderHandler(target, value) || target;\n            }\n        });\n    }\n    return target;\n}\n\nko.exportSymbol('extenders', ko.extenders);\n\nko.subscription = function (target, callback, disposeCallback) {\n    this._target = target;\n    this.callback = callback;\n    this.disposeCallback = disposeCallback;\n    this.isDisposed = false;\n    ko.exportProperty(this, 'dispose', this.dispose);\n};\nko.subscription.prototype.dispose = function () {\n    this.isDisposed = true;\n    this.disposeCallback();\n};\n\nko.subscribable = function () {\n    ko.utils.setPrototypeOfOrExtend(this, ko_subscribable_fn);\n    ko_subscribable_fn.init(this);\n}\n\nvar defaultEvent = \"change\";\n\n// Moved out of \"limit\" to avoid the extra closure\nfunction limitNotifySubscribers(value, event) {\n    if (!event || event === defaultEvent) {\n        this._limitChange(value);\n    } else if (event === 'beforeChange') {\n        this._limitBeforeChange(value);\n    } else {\n        this._origNotifySubscribers(value, event);\n    }\n}\n\nvar ko_subscribable_fn = {\n    init: function(instance) {\n        instance._subscriptions = { \"change\": [] };\n        instance._versionNumber = 1;\n    },\n\n    subscribe: function (callback, callbackTarget, event) {\n        var self = this;\n\n        event = event || defaultEvent;\n        var boundCallback = callbackTarget ? callback.bind(callbackTarget) : callback;\n\n        var subscription = new ko.subscription(self, boundCallback, function () {\n            ko.utils.arrayRemoveItem(self._subscriptions[event], subscription);\n            if (self.afterSubscriptionRemove)\n                self.afterSubscriptionRemove(event);\n        });\n\n        if (self.beforeSubscriptionAdd)\n            self.beforeSubscriptionAdd(event);\n\n        if (!self._subscriptions[event])\n            self._subscriptions[event] = [];\n        self._subscriptions[event].push(subscription);\n\n        return subscription;\n    },\n\n    \"notifySubscribers\": function (valueToNotify, event) {\n        event = event || defaultEvent;\n        if (event === defaultEvent) {\n            this.updateVersion();\n        }\n        if (this.hasSubscriptionsForEvent(event)) {\n            var subs = event === defaultEvent && this._changeSubscriptions || this._subscriptions[event].slice(0);\n            try {\n                ko.dependencyDetection.begin(); // Begin suppressing dependency detection (by setting the top frame to undefined)\n                for (var i = 0, subscription; subscription = subs[i]; ++i) {\n                    // In case a subscription was disposed during the arrayForEach cycle, check\n                    // for isDisposed on each subscription before invoking its callback\n                    if (!subscription.isDisposed)\n                        subscription.callback(valueToNotify);\n                }\n            } finally {\n                ko.dependencyDetection.end(); // End suppressing dependency detection\n            }\n        }\n    },\n\n    getVersion: function () {\n        return this._versionNumber;\n    },\n\n    hasChanged: function (versionToCheck) {\n        return this.getVersion() !== versionToCheck;\n    },\n\n    updateVersion: function () {\n        ++this._versionNumber;\n    },\n\n    limit: function(limitFunction) {\n        var self = this, selfIsObservable = ko.isObservable(self),\n            ignoreBeforeChange, notifyNextChange, previousValue, pendingValue, beforeChange = 'beforeChange';\n\n        if (!self._origNotifySubscribers) {\n            self._origNotifySubscribers = self[\"notifySubscribers\"];\n            self[\"notifySubscribers\"] = limitNotifySubscribers;\n        }\n\n        var finish = limitFunction(function() {\n            self._notificationIsPending = false;\n\n            // If an observable provided a reference to itself, access it to get the latest value.\n            // This allows computed observables to delay calculating their value until needed.\n            if (selfIsObservable && pendingValue === self) {\n                pendingValue = self._evalIfChanged ? self._evalIfChanged() : self();\n            }\n            var shouldNotify = notifyNextChange || self.isDifferent(previousValue, pendingValue);\n\n            notifyNextChange = ignoreBeforeChange = false;\n\n            if (shouldNotify) {\n                self._origNotifySubscribers(previousValue = pendingValue);\n            }\n        });\n\n        self._limitChange = function(value) {\n            self._changeSubscriptions = self._subscriptions[defaultEvent].slice(0);\n            self._notificationIsPending = ignoreBeforeChange = true;\n            pendingValue = value;\n            finish();\n        };\n        self._limitBeforeChange = function(value) {\n            if (!ignoreBeforeChange) {\n                previousValue = value;\n                self._origNotifySubscribers(value, beforeChange);\n            }\n        };\n        self._notifyNextChangeIfValueIsDifferent = function() {\n            if (self.isDifferent(previousValue, self.peek(true /*evaluate*/))) {\n                notifyNextChange = true;\n            }\n        };\n    },\n\n    hasSubscriptionsForEvent: function(event) {\n        return this._subscriptions[event] && this._subscriptions[event].length;\n    },\n\n    getSubscriptionsCount: function (event) {\n        if (event) {\n            return this._subscriptions[event] && this._subscriptions[event].length || 0;\n        } else {\n            var total = 0;\n            ko.utils.objectForEach(this._subscriptions, function(eventName, subscriptions) {\n                if (eventName !== 'dirty')\n                    total += subscriptions.length;\n            });\n            return total;\n        }\n    },\n\n    isDifferent: function(oldValue, newValue) {\n        return !this['equalityComparer'] || !this['equalityComparer'](oldValue, newValue);\n    },\n\n    extend: applyExtenders\n};\n\nko.exportProperty(ko_subscribable_fn, 'subscribe', ko_subscribable_fn.subscribe);\nko.exportProperty(ko_subscribable_fn, 'extend', ko_subscribable_fn.extend);\nko.exportProperty(ko_subscribable_fn, 'getSubscriptionsCount', ko_subscribable_fn.getSubscriptionsCount);\n\n// For browsers that support proto assignment, we overwrite the prototype of each\n// observable instance. Since observables are functions, we need Function.prototype\n// to still be in the prototype chain.\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(ko_subscribable_fn, Function.prototype);\n}\n\nko.subscribable['fn'] = ko_subscribable_fn;\n\n\nko.isSubscribable = function (instance) {\n    return instance != null && typeof instance.subscribe == \"function\" && typeof instance[\"notifySubscribers\"] == \"function\";\n};\n\nko.exportSymbol('subscribable', ko.subscribable);\nko.exportSymbol('isSubscribable', ko.isSubscribable);\n\nko.computedContext = ko.dependencyDetection = (function () {\n    var outerFrames = [],\n        currentFrame,\n        lastId = 0;\n\n    // Return a unique ID that can be assigned to an observable for dependency tracking.\n    // Theoretically, you could eventually overflow the number storage size, resulting\n    // in duplicate IDs. But in JavaScript, the largest exact integral value is 2^53\n    // or 9,007,199,254,740,992. If you created 1,000,000 IDs per second, it would\n    // take over 285 years to reach that number.\n    // Reference http://blog.vjeux.com/2010/javascript/javascript-max_int-number-limits.html\n    function getId() {\n        return ++lastId;\n    }\n\n    function begin(options) {\n        outerFrames.push(currentFrame);\n        currentFrame = options;\n    }\n\n    function end() {\n        currentFrame = outerFrames.pop();\n    }\n\n    return {\n        begin: begin,\n\n        end: end,\n\n        registerDependency: function (subscribable) {\n            if (currentFrame) {\n                if (!ko.isSubscribable(subscribable))\n                    throw new Error(\"Only subscribable things can act as dependencies\");\n                currentFrame.callback.call(currentFrame.callbackTarget, subscribable, subscribable._id || (subscribable._id = getId()));\n            }\n        },\n\n        ignore: function (callback, callbackTarget, callbackArgs) {\n            try {\n                begin();\n                return callback.apply(callbackTarget, callbackArgs || []);\n            } finally {\n                end();\n            }\n        },\n\n        getDependenciesCount: function () {\n            if (currentFrame)\n                return currentFrame.computed.getDependenciesCount();\n        },\n\n        isInitial: function() {\n            if (currentFrame)\n                return currentFrame.isInitial;\n        }\n    };\n})();\n\nko.exportSymbol('computedContext', ko.computedContext);\nko.exportSymbol('computedContext.getDependenciesCount', ko.computedContext.getDependenciesCount);\nko.exportSymbol('computedContext.isInitial', ko.computedContext.isInitial);\n\nko.exportSymbol('ignoreDependencies', ko.ignoreDependencies = ko.dependencyDetection.ignore);\nvar observableLatestValue = ko.utils.createSymbolOrString('_latestValue');\n\nko.observable = function (initialValue) {\n    function observable() {\n        if (arguments.length > 0) {\n            // Write\n\n            // Ignore writes if the value hasn't changed\n            if (observable.isDifferent(observable[observableLatestValue], arguments[0])) {\n                observable.valueWillMutate();\n                observable[observableLatestValue] = arguments[0];\n                observable.valueHasMutated();\n            }\n            return this; // Permits chained assignments\n        }\n        else {\n            // Read\n            ko.dependencyDetection.registerDependency(observable); // The caller only needs to be notified of changes if they did a \"read\" operation\n            return observable[observableLatestValue];\n        }\n    }\n\n    observable[observableLatestValue] = initialValue;\n\n    // Inherit from 'subscribable'\n    if (!ko.utils.canSetPrototype) {\n        // 'subscribable' won't be on the prototype chain unless we put it there directly\n        ko.utils.extend(observable, ko.subscribable['fn']);\n    }\n    ko.subscribable['fn'].init(observable);\n\n    // Inherit from 'observable'\n    ko.utils.setPrototypeOfOrExtend(observable, observableFn);\n\n    if (ko.options['deferUpdates']) {\n        ko.extenders['deferred'](observable, true);\n    }\n\n    return observable;\n}\n\n// Define prototype for observables\nvar observableFn = {\n    'equalityComparer': valuesArePrimitiveAndEqual,\n    peek: function() { return this[observableLatestValue]; },\n    valueHasMutated: function () { this['notifySubscribers'](this[observableLatestValue]); },\n    valueWillMutate: function () { this['notifySubscribers'](this[observableLatestValue], 'beforeChange'); }\n};\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observable constructor\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(observableFn, ko.subscribable['fn']);\n}\n\nvar protoProperty = ko.observable.protoProperty = '__ko_proto__';\nobservableFn[protoProperty] = ko.observable;\n\nko.hasPrototype = function(instance, prototype) {\n    if ((instance === null) || (instance === undefined) || (instance[protoProperty] === undefined)) return false;\n    if (instance[protoProperty] === prototype) return true;\n    return ko.hasPrototype(instance[protoProperty], prototype); // Walk the prototype chain\n};\n\nko.isObservable = function (instance) {\n    return ko.hasPrototype(instance, ko.observable);\n}\nko.isWriteableObservable = function (instance) {\n    // Observable\n    if ((typeof instance == 'function') && instance[protoProperty] === ko.observable)\n        return true;\n    // Writeable dependent observable\n    if ((typeof instance == 'function') && (instance[protoProperty] === ko.dependentObservable) && (instance.hasWriteFunction))\n        return true;\n    // Anything else\n    return false;\n}\n\nko.exportSymbol('observable', ko.observable);\nko.exportSymbol('isObservable', ko.isObservable);\nko.exportSymbol('isWriteableObservable', ko.isWriteableObservable);\nko.exportSymbol('isWritableObservable', ko.isWriteableObservable);\nko.exportSymbol('observable.fn', observableFn);\nko.exportProperty(observableFn, 'peek', observableFn.peek);\nko.exportProperty(observableFn, 'valueHasMutated', observableFn.valueHasMutated);\nko.exportProperty(observableFn, 'valueWillMutate', observableFn.valueWillMutate);\nko.observableArray = function (initialValues) {\n    initialValues = initialValues || [];\n\n    if (typeof initialValues != 'object' || !('length' in initialValues))\n        throw new Error(\"The argument passed when initializing an observable array must be an array, or null, or undefined.\");\n\n    var result = ko.observable(initialValues);\n    ko.utils.setPrototypeOfOrExtend(result, ko.observableArray['fn']);\n    return result.extend({'trackArrayChanges':true});\n};\n\nko.observableArray['fn'] = {\n    'remove': function (valueOrPredicate) {\n        var underlyingArray = this.peek();\n        var removedValues = [];\n        var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n        for (var i = 0; i < underlyingArray.length; i++) {\n            var value = underlyingArray[i];\n            if (predicate(value)) {\n                if (removedValues.length === 0) {\n                    this.valueWillMutate();\n                }\n                removedValues.push(value);\n                underlyingArray.splice(i, 1);\n                i--;\n            }\n        }\n        if (removedValues.length) {\n            this.valueHasMutated();\n        }\n        return removedValues;\n    },\n\n    'removeAll': function (arrayOfValues) {\n        // If you passed zero args, we remove everything\n        if (arrayOfValues === undefined) {\n            var underlyingArray = this.peek();\n            var allValues = underlyingArray.slice(0);\n            this.valueWillMutate();\n            underlyingArray.splice(0, underlyingArray.length);\n            this.valueHasMutated();\n            return allValues;\n        }\n        // If you passed an arg, we interpret it as an array of entries to remove\n        if (!arrayOfValues)\n            return [];\n        return this['remove'](function (value) {\n            return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n        });\n    },\n\n    'destroy': function (valueOrPredicate) {\n        var underlyingArray = this.peek();\n        var predicate = typeof valueOrPredicate == \"function\" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function (value) { return value === valueOrPredicate; };\n        this.valueWillMutate();\n        for (var i = underlyingArray.length - 1; i >= 0; i--) {\n            var value = underlyingArray[i];\n            if (predicate(value))\n                underlyingArray[i][\"_destroy\"] = true;\n        }\n        this.valueHasMutated();\n    },\n\n    'destroyAll': function (arrayOfValues) {\n        // If you passed zero args, we destroy everything\n        if (arrayOfValues === undefined)\n            return this['destroy'](function() { return true });\n\n        // If you passed an arg, we interpret it as an array of entries to destroy\n        if (!arrayOfValues)\n            return [];\n        return this['destroy'](function (value) {\n            return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;\n        });\n    },\n\n    'indexOf': function (item) {\n        var underlyingArray = this();\n        return ko.utils.arrayIndexOf(underlyingArray, item);\n    },\n\n    'replace': function(oldItem, newItem) {\n        var index = this['indexOf'](oldItem);\n        if (index >= 0) {\n            this.valueWillMutate();\n            this.peek()[index] = newItem;\n            this.valueHasMutated();\n        }\n    }\n};\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.observableArray constructor\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(ko.observableArray['fn'], ko.observable['fn']);\n}\n\n// Populate ko.observableArray.fn with read/write functions from native arrays\n// Important: Do not add any additional functions here that may reasonably be used to *read* data from the array\n// because we'll eval them without causing subscriptions, so ko.computed output could end up getting stale\nko.utils.arrayForEach([\"pop\", \"push\", \"reverse\", \"shift\", \"sort\", \"splice\", \"unshift\"], function (methodName) {\n    ko.observableArray['fn'][methodName] = function () {\n        // Use \"peek\" to avoid creating a subscription in any computed that we're executing in the context of\n        // (for consistency with mutating regular observables)\n        var underlyingArray = this.peek();\n        this.valueWillMutate();\n        this.cacheDiffForKnownOperation(underlyingArray, methodName, arguments);\n        var methodCallResult = underlyingArray[methodName].apply(underlyingArray, arguments);\n        this.valueHasMutated();\n        // The native sort and reverse methods return a reference to the array, but it makes more sense to return the observable array instead.\n        return methodCallResult === underlyingArray ? this : methodCallResult;\n    };\n});\n\n// Populate ko.observableArray.fn with read-only functions from native arrays\nko.utils.arrayForEach([\"slice\"], function (methodName) {\n    ko.observableArray['fn'][methodName] = function () {\n        var underlyingArray = this();\n        return underlyingArray[methodName].apply(underlyingArray, arguments);\n    };\n});\n\nko.exportSymbol('observableArray', ko.observableArray);\nvar arrayChangeEventName = 'arrayChange';\nko.extenders['trackArrayChanges'] = function(target, options) {\n    // Use the provided options--each call to trackArrayChanges overwrites the previously set options\n    target.compareArrayOptions = {};\n    if (options && typeof options == \"object\") {\n        ko.utils.extend(target.compareArrayOptions, options);\n    }\n    target.compareArrayOptions['sparse'] = true;\n\n    // Only modify the target observable once\n    if (target.cacheDiffForKnownOperation) {\n        return;\n    }\n    var trackingChanges = false,\n        cachedDiff = null,\n        arrayChangeSubscription,\n        pendingNotifications = 0,\n        underlyingNotifySubscribersFunction,\n        underlyingBeforeSubscriptionAddFunction = target.beforeSubscriptionAdd,\n        underlyingAfterSubscriptionRemoveFunction = target.afterSubscriptionRemove;\n\n    // Watch \"subscribe\" calls, and for array change events, ensure change tracking is enabled\n    target.beforeSubscriptionAdd = function (event) {\n        if (underlyingBeforeSubscriptionAddFunction)\n            underlyingBeforeSubscriptionAddFunction.call(target, event);\n        if (event === arrayChangeEventName) {\n            trackChanges();\n        }\n    };\n    // Watch \"dispose\" calls, and for array change events, ensure change tracking is disabled when all are disposed\n    target.afterSubscriptionRemove = function (event) {\n        if (underlyingAfterSubscriptionRemoveFunction)\n            underlyingAfterSubscriptionRemoveFunction.call(target, event);\n        if (event === arrayChangeEventName && !target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n            if (underlyingNotifySubscribersFunction) {\n                target['notifySubscribers'] = underlyingNotifySubscribersFunction;\n                underlyingNotifySubscribersFunction = undefined;\n            }\n            arrayChangeSubscription.dispose();\n            trackingChanges = false;\n        }\n    };\n\n    function trackChanges() {\n        // Calling 'trackChanges' multiple times is the same as calling it once\n        if (trackingChanges) {\n            return;\n        }\n\n        trackingChanges = true;\n\n        // Intercept \"notifySubscribers\" to track how many times it was called.\n        underlyingNotifySubscribersFunction = target['notifySubscribers'];\n        target['notifySubscribers'] = function(valueToNotify, event) {\n            if (!event || event === defaultEvent) {\n                ++pendingNotifications;\n            }\n            return underlyingNotifySubscribersFunction.apply(this, arguments);\n        };\n\n        // Each time the array changes value, capture a clone so that on the next\n        // change it's possible to produce a diff\n        var previousContents = [].concat(target.peek() || []);\n        cachedDiff = null;\n        arrayChangeSubscription = target.subscribe(function(currentContents) {\n            // Make a copy of the current contents and ensure it's an array\n            currentContents = [].concat(currentContents || []);\n\n            // Compute the diff and issue notifications, but only if someone is listening\n            if (target.hasSubscriptionsForEvent(arrayChangeEventName)) {\n                var changes = getChanges(previousContents, currentContents);\n            }\n\n            // Eliminate references to the old, removed items, so they can be GCed\n            previousContents = currentContents;\n            cachedDiff = null;\n            pendingNotifications = 0;\n\n            if (changes && changes.length) {\n                target['notifySubscribers'](changes, arrayChangeEventName);\n            }\n        });\n    }\n\n    function getChanges(previousContents, currentContents) {\n        // We try to re-use cached diffs.\n        // The scenarios where pendingNotifications > 1 are when using rate-limiting or the Deferred Updates\n        // plugin, which without this check would not be compatible with arrayChange notifications. Normally,\n        // notifications are issued immediately so we wouldn't be queueing up more than one.\n        if (!cachedDiff || pendingNotifications > 1) {\n            cachedDiff = ko.utils.compareArrays(previousContents, currentContents, target.compareArrayOptions);\n        }\n\n        return cachedDiff;\n    }\n\n    target.cacheDiffForKnownOperation = function(rawArray, operationName, args) {\n        // Only run if we're currently tracking changes for this observable array\n        // and there aren't any pending deferred notifications.\n        if (!trackingChanges || pendingNotifications) {\n            return;\n        }\n        var diff = [],\n            arrayLength = rawArray.length,\n            argsLength = args.length,\n            offset = 0;\n\n        function pushDiff(status, value, index) {\n            return diff[diff.length] = { 'status': status, 'value': value, 'index': index };\n        }\n        switch (operationName) {\n            case 'push':\n                offset = arrayLength;\n            case 'unshift':\n                for (var index = 0; index < argsLength; index++) {\n                    pushDiff('added', args[index], offset + index);\n                }\n                break;\n\n            case 'pop':\n                offset = arrayLength - 1;\n            case 'shift':\n                if (arrayLength) {\n                    pushDiff('deleted', rawArray[offset], offset);\n                }\n                break;\n\n            case 'splice':\n                // Negative start index means 'from end of array'. After that we clamp to [0...arrayLength].\n                // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/splice\n                var startIndex = Math.min(Math.max(0, args[0] < 0 ? arrayLength + args[0] : args[0]), arrayLength),\n                    endDeleteIndex = argsLength === 1 ? arrayLength : Math.min(startIndex + (args[1] || 0), arrayLength),\n                    endAddIndex = startIndex + argsLength - 2,\n                    endIndex = Math.max(endDeleteIndex, endAddIndex),\n                    additions = [], deletions = [];\n                for (var index = startIndex, argsIndex = 2; index < endIndex; ++index, ++argsIndex) {\n                    if (index < endDeleteIndex)\n                        deletions.push(pushDiff('deleted', rawArray[index], index));\n                    if (index < endAddIndex)\n                        additions.push(pushDiff('added', args[argsIndex], index));\n                }\n                ko.utils.findMovesInArrayComparison(deletions, additions);\n                break;\n\n            default:\n                return;\n        }\n        cachedDiff = diff;\n    };\n};\nvar computedState = ko.utils.createSymbolOrString('_state');\n\nko.computed = ko.dependentObservable = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget, options) {\n    if (typeof evaluatorFunctionOrOptions === \"object\") {\n        // Single-parameter syntax - everything is on this \"options\" param\n        options = evaluatorFunctionOrOptions;\n    } else {\n        // Multi-parameter syntax - construct the options according to the params passed\n        options = options || {};\n        if (evaluatorFunctionOrOptions) {\n            options[\"read\"] = evaluatorFunctionOrOptions;\n        }\n    }\n    if (typeof options[\"read\"] != \"function\")\n        throw Error(\"Pass a function that returns the value of the ko.computed\");\n\n    var writeFunction = options[\"write\"];\n    var state = {\n        latestValue: undefined,\n        isStale: true,\n        isDirty: true,\n        isBeingEvaluated: false,\n        suppressDisposalUntilDisposeWhenReturnsFalse: false,\n        isDisposed: false,\n        pure: false,\n        isSleeping: false,\n        readFunction: options[\"read\"],\n        evaluatorFunctionTarget: evaluatorFunctionTarget || options[\"owner\"],\n        disposeWhenNodeIsRemoved: options[\"disposeWhenNodeIsRemoved\"] || options.disposeWhenNodeIsRemoved || null,\n        disposeWhen: options[\"disposeWhen\"] || options.disposeWhen,\n        domNodeDisposalCallback: null,\n        dependencyTracking: {},\n        dependenciesCount: 0,\n        evaluationTimeoutInstance: null\n    };\n\n    function computedObservable() {\n        if (arguments.length > 0) {\n            if (typeof writeFunction === \"function\") {\n                // Writing a value\n                writeFunction.apply(state.evaluatorFunctionTarget, arguments);\n            } else {\n                throw new Error(\"Cannot write a value to a ko.computed unless you specify a 'write' option. If you wish to read the current value, don't pass any parameters.\");\n            }\n            return this; // Permits chained assignments\n        } else {\n            // Reading the value\n            ko.dependencyDetection.registerDependency(computedObservable);\n            if (state.isDirty || (state.isSleeping && computedObservable.haveDependenciesChanged())) {\n                computedObservable.evaluateImmediate();\n            }\n            return state.latestValue;\n        }\n    }\n\n    computedObservable[computedState] = state;\n    computedObservable.hasWriteFunction = typeof writeFunction === \"function\";\n\n    // Inherit from 'subscribable'\n    if (!ko.utils.canSetPrototype) {\n        // 'subscribable' won't be on the prototype chain unless we put it there directly\n        ko.utils.extend(computedObservable, ko.subscribable['fn']);\n    }\n    ko.subscribable['fn'].init(computedObservable);\n\n    // Inherit from 'computed'\n    ko.utils.setPrototypeOfOrExtend(computedObservable, computedFn);\n\n    if (options['pure']) {\n        state.pure = true;\n        state.isSleeping = true;     // Starts off sleeping; will awake on the first subscription\n        ko.utils.extend(computedObservable, pureComputedOverrides);\n    } else if (options['deferEvaluation']) {\n        ko.utils.extend(computedObservable, deferEvaluationOverrides);\n    }\n\n    if (ko.options['deferUpdates']) {\n        ko.extenders['deferred'](computedObservable, true);\n    }\n\n    if (DEBUG) {\n        // #1731 - Aid debugging by exposing the computed's options\n        computedObservable[\"_options\"] = options;\n    }\n\n    if (state.disposeWhenNodeIsRemoved) {\n        // Since this computed is associated with a DOM node, and we don't want to dispose the computed\n        // until the DOM node is *removed* from the document (as opposed to never having been in the document),\n        // we'll prevent disposal until \"disposeWhen\" first returns false.\n        state.suppressDisposalUntilDisposeWhenReturnsFalse = true;\n\n        // disposeWhenNodeIsRemoved: true can be used to opt into the \"only dispose after first false result\"\n        // behaviour even if there's no specific node to watch. In that case, clear the option so we don't try\n        // to watch for a non-node's disposal. This technique is intended for KO's internal use only and shouldn't\n        // be documented or used by application code, as it's likely to change in a future version of KO.\n        if (!state.disposeWhenNodeIsRemoved.nodeType) {\n            state.disposeWhenNodeIsRemoved = null;\n        }\n    }\n\n    // Evaluate, unless sleeping or deferEvaluation is true\n    if (!state.isSleeping && !options['deferEvaluation']) {\n        computedObservable.evaluateImmediate();\n    }\n\n    // Attach a DOM node disposal callback so that the computed will be proactively disposed as soon as the node is\n    // removed using ko.removeNode. But skip if isActive is false (there will never be any dependencies to dispose).\n    if (state.disposeWhenNodeIsRemoved && computedObservable.isActive()) {\n        ko.utils.domNodeDisposal.addDisposeCallback(state.disposeWhenNodeIsRemoved, state.domNodeDisposalCallback = function () {\n            computedObservable.dispose();\n        });\n    }\n\n    return computedObservable;\n};\n\n// Utility function that disposes a given dependencyTracking entry\nfunction computedDisposeDependencyCallback(id, entryToDispose) {\n    if (entryToDispose !== null && entryToDispose.dispose) {\n        entryToDispose.dispose();\n    }\n}\n\n// This function gets called each time a dependency is detected while evaluating a computed.\n// It's factored out as a shared function to avoid creating unnecessary function instances during evaluation.\nfunction computedBeginDependencyDetectionCallback(subscribable, id) {\n    var computedObservable = this.computedObservable,\n        state = computedObservable[computedState];\n    if (!state.isDisposed) {\n        if (this.disposalCount && this.disposalCandidates[id]) {\n            // Don't want to dispose this subscription, as it's still being used\n            computedObservable.addDependencyTracking(id, subscribable, this.disposalCandidates[id]);\n            this.disposalCandidates[id] = null; // No need to actually delete the property - disposalCandidates is a transient object anyway\n            --this.disposalCount;\n        } else if (!state.dependencyTracking[id]) {\n            // Brand new subscription - add it\n            computedObservable.addDependencyTracking(id, subscribable, state.isSleeping ? { _target: subscribable } : computedObservable.subscribeToDependency(subscribable));\n        }\n        // If the observable we've accessed has a pending notification, ensure we get notified of the actual final value (bypass equality checks)\n        if (subscribable._notificationIsPending) {\n            subscribable._notifyNextChangeIfValueIsDifferent();\n        }\n    }\n}\n\nvar computedFn = {\n    \"equalityComparer\": valuesArePrimitiveAndEqual,\n    getDependenciesCount: function () {\n        return this[computedState].dependenciesCount;\n    },\n    addDependencyTracking: function (id, target, trackingObj) {\n        if (this[computedState].pure && target === this) {\n            throw Error(\"A 'pure' computed must not be called recursively\");\n        }\n\n        this[computedState].dependencyTracking[id] = trackingObj;\n        trackingObj._order = this[computedState].dependenciesCount++;\n        trackingObj._version = target.getVersion();\n    },\n    haveDependenciesChanged: function () {\n        var id, dependency, dependencyTracking = this[computedState].dependencyTracking;\n        for (id in dependencyTracking) {\n            if (dependencyTracking.hasOwnProperty(id)) {\n                dependency = dependencyTracking[id];\n                if ((this._evalDelayed && dependency._target._notificationIsPending) || dependency._target.hasChanged(dependency._version)) {\n                    return true;\n                }\n            }\n        }\n    },\n    markDirty: function () {\n        // Process \"dirty\" events if we can handle delayed notifications\n        if (this._evalDelayed && !this[computedState].isBeingEvaluated) {\n            this._evalDelayed(false /*isChange*/);\n        }\n    },\n    isActive: function () {\n        var state = this[computedState];\n        return state.isDirty || state.dependenciesCount > 0;\n    },\n    respondToChange: function () {\n        // Ignore \"change\" events if we've already scheduled a delayed notification\n        if (!this._notificationIsPending) {\n            this.evaluatePossiblyAsync();\n        } else if (this[computedState].isDirty) {\n            this[computedState].isStale = true;\n        }\n    },\n    subscribeToDependency: function (target) {\n        if (target._deferUpdates && !this[computedState].disposeWhenNodeIsRemoved) {\n            var dirtySub = target.subscribe(this.markDirty, this, 'dirty'),\n                changeSub = target.subscribe(this.respondToChange, this);\n            return {\n                _target: target,\n                dispose: function () {\n                    dirtySub.dispose();\n                    changeSub.dispose();\n                }\n            };\n        } else {\n            return target.subscribe(this.evaluatePossiblyAsync, this);\n        }\n    },\n    evaluatePossiblyAsync: function () {\n        var computedObservable = this,\n            throttleEvaluationTimeout = computedObservable['throttleEvaluation'];\n        if (throttleEvaluationTimeout && throttleEvaluationTimeout >= 0) {\n            clearTimeout(this[computedState].evaluationTimeoutInstance);\n            this[computedState].evaluationTimeoutInstance = ko.utils.setTimeout(function () {\n                computedObservable.evaluateImmediate(true /*notifyChange*/);\n            }, throttleEvaluationTimeout);\n        } else if (computedObservable._evalDelayed) {\n            computedObservable._evalDelayed(true /*isChange*/);\n        } else {\n            computedObservable.evaluateImmediate(true /*notifyChange*/);\n        }\n    },\n    evaluateImmediate: function (notifyChange) {\n        var computedObservable = this,\n            state = computedObservable[computedState],\n            disposeWhen = state.disposeWhen,\n            changed = false;\n\n        if (state.isBeingEvaluated) {\n            // If the evaluation of a ko.computed causes side effects, it's possible that it will trigger its own re-evaluation.\n            // This is not desirable (it's hard for a developer to realise a chain of dependencies might cause this, and they almost\n            // certainly didn't intend infinite re-evaluations). So, for predictability, we simply prevent ko.computeds from causing\n            // their own re-evaluation. Further discussion at https://github.com/SteveSanderson/knockout/pull/387\n            return;\n        }\n\n        // Do not evaluate (and possibly capture new dependencies) if disposed\n        if (state.isDisposed) {\n            return;\n        }\n\n        if (state.disposeWhenNodeIsRemoved && !ko.utils.domNodeIsAttachedToDocument(state.disposeWhenNodeIsRemoved) || disposeWhen && disposeWhen()) {\n            // See comment above about suppressDisposalUntilDisposeWhenReturnsFalse\n            if (!state.suppressDisposalUntilDisposeWhenReturnsFalse) {\n                computedObservable.dispose();\n                return;\n            }\n        } else {\n            // It just did return false, so we can stop suppressing now\n            state.suppressDisposalUntilDisposeWhenReturnsFalse = false;\n        }\n\n        state.isBeingEvaluated = true;\n        try {\n            changed = this.evaluateImmediate_CallReadWithDependencyDetection(notifyChange);\n        } finally {\n            state.isBeingEvaluated = false;\n        }\n\n        if (!state.dependenciesCount) {\n            computedObservable.dispose();\n        }\n\n        return changed;\n    },\n    evaluateImmediate_CallReadWithDependencyDetection: function (notifyChange) {\n        // This function is really just part of the evaluateImmediate logic. You would never call it from anywhere else.\n        // Factoring it out into a separate function means it can be independent of the try/catch block in evaluateImmediate,\n        // which contributes to saving about 40% off the CPU overhead of computed evaluation (on V8 at least).\n\n        var computedObservable = this,\n            state = computedObservable[computedState],\n            changed = false;\n\n        // Initially, we assume that none of the subscriptions are still being used (i.e., all are candidates for disposal).\n        // Then, during evaluation, we cross off any that are in fact still being used.\n        var isInitial = state.pure ? undefined : !state.dependenciesCount,   // If we're evaluating when there are no previous dependencies, it must be the first time\n            dependencyDetectionContext = {\n                computedObservable: computedObservable,\n                disposalCandidates: state.dependencyTracking,\n                disposalCount: state.dependenciesCount\n            };\n\n        ko.dependencyDetection.begin({\n            callbackTarget: dependencyDetectionContext,\n            callback: computedBeginDependencyDetectionCallback,\n            computed: computedObservable,\n            isInitial: isInitial\n        });\n\n        state.dependencyTracking = {};\n        state.dependenciesCount = 0;\n\n        var newValue = this.evaluateImmediate_CallReadThenEndDependencyDetection(state, dependencyDetectionContext);\n\n        if (computedObservable.isDifferent(state.latestValue, newValue)) {\n            if (!state.isSleeping) {\n                computedObservable[\"notifySubscribers\"](state.latestValue, \"beforeChange\");\n            }\n\n            state.latestValue = newValue;\n            if (DEBUG) computedObservable._latestValue = newValue;\n\n            if (state.isSleeping) {\n                computedObservable.updateVersion();\n            } else if (notifyChange) {\n                computedObservable[\"notifySubscribers\"](state.latestValue);\n            }\n\n            changed = true;\n        }\n\n        if (isInitial) {\n            computedObservable[\"notifySubscribers\"](state.latestValue, \"awake\");\n        }\n\n        return changed;\n    },\n    evaluateImmediate_CallReadThenEndDependencyDetection: function (state, dependencyDetectionContext) {\n        // This function is really part of the evaluateImmediate_CallReadWithDependencyDetection logic.\n        // You'd never call it from anywhere else. Factoring it out means that evaluateImmediate_CallReadWithDependencyDetection\n        // can be independent of try/finally blocks, which contributes to saving about 40% off the CPU\n        // overhead of computed evaluation (on V8 at least).\n\n        try {\n            var readFunction = state.readFunction;\n            return state.evaluatorFunctionTarget ? readFunction.call(state.evaluatorFunctionTarget) : readFunction();\n        } finally {\n            ko.dependencyDetection.end();\n\n            // For each subscription no longer being used, remove it from the active subscriptions list and dispose it\n            if (dependencyDetectionContext.disposalCount && !state.isSleeping) {\n                ko.utils.objectForEach(dependencyDetectionContext.disposalCandidates, computedDisposeDependencyCallback);\n            }\n\n            state.isStale = state.isDirty = false;\n        }\n    },\n    peek: function (evaluate) {\n        // By default, peek won't re-evaluate, except while the computed is sleeping or to get the initial value when \"deferEvaluation\" is set.\n        // Pass in true to evaluate if needed.\n        var state = this[computedState];\n        if ((state.isDirty && (evaluate || !state.dependenciesCount)) || (state.isSleeping && this.haveDependenciesChanged())) {\n            this.evaluateImmediate();\n        }\n        return state.latestValue;\n    },\n    limit: function (limitFunction) {\n        // Override the limit function with one that delays evaluation as well\n        ko.subscribable['fn'].limit.call(this, limitFunction);\n        this._evalIfChanged = function () {\n            if (this[computedState].isStale) {\n                this.evaluateImmediate();\n            } else {\n                this[computedState].isDirty = false;\n            }\n            return this[computedState].latestValue;\n        };\n        this._evalDelayed = function (isChange) {\n            this._limitBeforeChange(this[computedState].latestValue);\n\n            // Mark as dirty\n            this[computedState].isDirty = true;\n            if (isChange) {\n                this[computedState].isStale = true;\n            }\n\n            // Pass the observable to the \"limit\" code, which will evaluate it when\n            // it's time to do the notification.\n            this._limitChange(this);\n        };\n    },\n    dispose: function () {\n        var state = this[computedState];\n        if (!state.isSleeping && state.dependencyTracking) {\n            ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                if (dependency.dispose)\n                    dependency.dispose();\n            });\n        }\n        if (state.disposeWhenNodeIsRemoved && state.domNodeDisposalCallback) {\n            ko.utils.domNodeDisposal.removeDisposeCallback(state.disposeWhenNodeIsRemoved, state.domNodeDisposalCallback);\n        }\n        state.dependencyTracking = null;\n        state.dependenciesCount = 0;\n        state.isDisposed = true;\n        state.isStale = false;\n        state.isDirty = false;\n        state.isSleeping = false;\n        state.disposeWhenNodeIsRemoved = null;\n    }\n};\n\nvar pureComputedOverrides = {\n    beforeSubscriptionAdd: function (event) {\n        // If asleep, wake up the computed by subscribing to any dependencies.\n        var computedObservable = this,\n            state = computedObservable[computedState];\n        if (!state.isDisposed && state.isSleeping && event == 'change') {\n            state.isSleeping = false;\n            if (state.isStale || computedObservable.haveDependenciesChanged()) {\n                state.dependencyTracking = null;\n                state.dependenciesCount = 0;\n                if (computedObservable.evaluateImmediate()) {\n                    computedObservable.updateVersion();\n                }\n            } else {\n                // First put the dependencies in order\n                var dependeciesOrder = [];\n                ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                    dependeciesOrder[dependency._order] = id;\n                });\n                // Next, subscribe to each one\n                ko.utils.arrayForEach(dependeciesOrder, function (id, order) {\n                    var dependency = state.dependencyTracking[id],\n                        subscription = computedObservable.subscribeToDependency(dependency._target);\n                    subscription._order = order;\n                    subscription._version = dependency._version;\n                    state.dependencyTracking[id] = subscription;\n                });\n            }\n            if (!state.isDisposed) {     // test since evaluating could trigger disposal\n                computedObservable[\"notifySubscribers\"](state.latestValue, \"awake\");\n            }\n        }\n    },\n    afterSubscriptionRemove: function (event) {\n        var state = this[computedState];\n        if (!state.isDisposed && event == 'change' && !this.hasSubscriptionsForEvent('change')) {\n            ko.utils.objectForEach(state.dependencyTracking, function (id, dependency) {\n                if (dependency.dispose) {\n                    state.dependencyTracking[id] = {\n                        _target: dependency._target,\n                        _order: dependency._order,\n                        _version: dependency._version\n                    };\n                    dependency.dispose();\n                }\n            });\n            state.isSleeping = true;\n            this[\"notifySubscribers\"](undefined, \"asleep\");\n        }\n    },\n    getVersion: function () {\n        // Because a pure computed is not automatically updated while it is sleeping, we can't\n        // simply return the version number. Instead, we check if any of the dependencies have\n        // changed and conditionally re-evaluate the computed observable.\n        var state = this[computedState];\n        if (state.isSleeping && (state.isStale || this.haveDependenciesChanged())) {\n            this.evaluateImmediate();\n        }\n        return ko.subscribable['fn'].getVersion.call(this);\n    }\n};\n\nvar deferEvaluationOverrides = {\n    beforeSubscriptionAdd: function (event) {\n        // This will force a computed with deferEvaluation to evaluate when the first subscription is registered.\n        if (event == 'change' || event == 'beforeChange') {\n            this.peek();\n        }\n    }\n};\n\n// Note that for browsers that don't support proto assignment, the\n// inheritance chain is created manually in the ko.computed constructor\nif (ko.utils.canSetPrototype) {\n    ko.utils.setPrototypeOf(computedFn, ko.subscribable['fn']);\n}\n\n// Set the proto chain values for ko.hasPrototype\nvar protoProp = ko.observable.protoProperty; // == \"__ko_proto__\"\nko.computed[protoProp] = ko.observable;\ncomputedFn[protoProp] = ko.computed;\n\nko.isComputed = function (instance) {\n    return ko.hasPrototype(instance, ko.computed);\n};\n\nko.isPureComputed = function (instance) {\n    return ko.hasPrototype(instance, ko.computed)\n        && instance[computedState] && instance[computedState].pure;\n};\n\nko.exportSymbol('computed', ko.computed);\nko.exportSymbol('dependentObservable', ko.computed);    // export ko.dependentObservable for backwards compatibility (1.x)\nko.exportSymbol('isComputed', ko.isComputed);\nko.exportSymbol('isPureComputed', ko.isPureComputed);\nko.exportSymbol('computed.fn', computedFn);\nko.exportProperty(computedFn, 'peek', computedFn.peek);\nko.exportProperty(computedFn, 'dispose', computedFn.dispose);\nko.exportProperty(computedFn, 'isActive', computedFn.isActive);\nko.exportProperty(computedFn, 'getDependenciesCount', computedFn.getDependenciesCount);\n\nko.pureComputed = function (evaluatorFunctionOrOptions, evaluatorFunctionTarget) {\n    if (typeof evaluatorFunctionOrOptions === 'function') {\n        return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget, {'pure':true});\n    } else {\n        evaluatorFunctionOrOptions = ko.utils.extend({}, evaluatorFunctionOrOptions);   // make a copy of the parameter object\n        evaluatorFunctionOrOptions['pure'] = true;\n        return ko.computed(evaluatorFunctionOrOptions, evaluatorFunctionTarget);\n    }\n}\nko.exportSymbol('pureComputed', ko.pureComputed);\n\n(function() {\n    var maxNestedObservableDepth = 10; // Escape the (unlikely) pathalogical case where an observable's current value is itself (or similar reference cycle)\n\n    ko.toJS = function(rootObject) {\n        if (arguments.length == 0)\n            throw new Error(\"When calling ko.toJS, pass the object you want to convert.\");\n\n        // We just unwrap everything at every level in the object graph\n        return mapJsObjectGraph(rootObject, function(valueToMap) {\n            // Loop because an observable's value might in turn be another observable wrapper\n            for (var i = 0; ko.isObservable(valueToMap) && (i < maxNestedObservableDepth); i++)\n                valueToMap = valueToMap();\n            return valueToMap;\n        });\n    };\n\n    ko.toJSON = function(rootObject, replacer, space) {     // replacer and space are optional\n        var plainJavaScriptObject = ko.toJS(rootObject);\n        return ko.utils.stringifyJson(plainJavaScriptObject, replacer, space);\n    };\n\n    function mapJsObjectGraph(rootObject, mapInputCallback, visitedObjects) {\n        visitedObjects = visitedObjects || new objectLookup();\n\n        rootObject = mapInputCallback(rootObject);\n        var canHaveProperties = (typeof rootObject == \"object\") && (rootObject !== null) && (rootObject !== undefined) && (!(rootObject instanceof RegExp)) && (!(rootObject instanceof Date)) && (!(rootObject instanceof String)) && (!(rootObject instanceof Number)) && (!(rootObject instanceof Boolean));\n        if (!canHaveProperties)\n            return rootObject;\n\n        var outputProperties = rootObject instanceof Array ? [] : {};\n        visitedObjects.save(rootObject, outputProperties);\n\n        visitPropertiesOrArrayEntries(rootObject, function(indexer) {\n            var propertyValue = mapInputCallback(rootObject[indexer]);\n\n            switch (typeof propertyValue) {\n                case \"boolean\":\n                case \"number\":\n                case \"string\":\n                case \"function\":\n                    outputProperties[indexer] = propertyValue;\n                    break;\n                case \"object\":\n                case \"undefined\":\n                    var previouslyMappedValue = visitedObjects.get(propertyValue);\n                    outputProperties[indexer] = (previouslyMappedValue !== undefined)\n                        ? previouslyMappedValue\n                        : mapJsObjectGraph(propertyValue, mapInputCallback, visitedObjects);\n                    break;\n            }\n        });\n\n        return outputProperties;\n    }\n\n    function visitPropertiesOrArrayEntries(rootObject, visitorCallback) {\n        if (rootObject instanceof Array) {\n            for (var i = 0; i < rootObject.length; i++)\n                visitorCallback(i);\n\n            // For arrays, also respect toJSON property for custom mappings (fixes #278)\n            if (typeof rootObject['toJSON'] == 'function')\n                visitorCallback('toJSON');\n        } else {\n            for (var propertyName in rootObject) {\n                visitorCallback(propertyName);\n            }\n        }\n    };\n\n    function objectLookup() {\n        this.keys = [];\n        this.values = [];\n    };\n\n    objectLookup.prototype = {\n        constructor: objectLookup,\n        save: function(key, value) {\n            var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n            if (existingIndex >= 0)\n                this.values[existingIndex] = value;\n            else {\n                this.keys.push(key);\n                this.values.push(value);\n            }\n        },\n        get: function(key) {\n            var existingIndex = ko.utils.arrayIndexOf(this.keys, key);\n            return (existingIndex >= 0) ? this.values[existingIndex] : undefined;\n        }\n    };\n})();\n\nko.exportSymbol('toJS', ko.toJS);\nko.exportSymbol('toJSON', ko.toJSON);\n(function () {\n    var hasDomDataExpandoProperty = '__ko__hasDomDataOptionValue__';\n\n    // Normally, SELECT elements and their OPTIONs can only take value of type 'string' (because the values\n    // are stored on DOM attributes). ko.selectExtensions provides a way for SELECTs/OPTIONs to have values\n    // that are arbitrary objects. This is very convenient when implementing things like cascading dropdowns.\n    ko.selectExtensions = {\n        readValue : function(element) {\n            switch (ko.utils.tagNameLower(element)) {\n                case 'option':\n                    if (element[hasDomDataExpandoProperty] === true)\n                        return ko.utils.domData.get(element, ko.bindingHandlers.options.optionValueDomDataKey);\n                    return ko.utils.ieVersion <= 7\n                        ? (element.getAttributeNode('value') && element.getAttributeNode('value').specified ? element.value : element.text)\n                        : element.value;\n                case 'select':\n                    return element.selectedIndex >= 0 ? ko.selectExtensions.readValue(element.options[element.selectedIndex]) : undefined;\n                default:\n                    return element.value;\n            }\n        },\n\n        writeValue: function(element, value, allowUnset) {\n            switch (ko.utils.tagNameLower(element)) {\n                case 'option':\n                    switch(typeof value) {\n                        case \"string\":\n                            ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, undefined);\n                            if (hasDomDataExpandoProperty in element) { // IE <= 8 throws errors if you delete non-existent properties from a DOM node\n                                delete element[hasDomDataExpandoProperty];\n                            }\n                            element.value = value;\n                            break;\n                        default:\n                            // Store arbitrary object using DomData\n                            ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, value);\n                            element[hasDomDataExpandoProperty] = true;\n\n                            // Special treatment of numbers is just for backward compatibility. KO 1.2.1 wrote numerical values to element.value.\n                            element.value = typeof value === \"number\" ? value : \"\";\n                            break;\n                    }\n                    break;\n                case 'select':\n                    if (value === \"\" || value === null)       // A blank string or null value will select the caption\n                        value = undefined;\n                    var selection = -1;\n                    for (var i = 0, n = element.options.length, optionValue; i < n; ++i) {\n                        optionValue = ko.selectExtensions.readValue(element.options[i]);\n                        // Include special check to handle selecting a caption with a blank string value\n                        if (optionValue == value || (optionValue == \"\" && value === undefined)) {\n                            selection = i;\n                            break;\n                        }\n                    }\n                    if (allowUnset || selection >= 0 || (value === undefined && element.size > 1)) {\n                        element.selectedIndex = selection;\n                    }\n                    break;\n                default:\n                    if ((value === null) || (value === undefined))\n                        value = \"\";\n                    element.value = value;\n                    break;\n            }\n        }\n    };\n})();\n\nko.exportSymbol('selectExtensions', ko.selectExtensions);\nko.exportSymbol('selectExtensions.readValue', ko.selectExtensions.readValue);\nko.exportSymbol('selectExtensions.writeValue', ko.selectExtensions.writeValue);\nko.expressionRewriting = (function () {\n    var javaScriptReservedWords = [\"true\", \"false\", \"null\", \"undefined\"];\n\n    // Matches something that can be assigned to--either an isolated identifier or something ending with a property accessor\n    // This is designed to be simple and avoid false negatives, but could produce false positives (e.g., a+b.c).\n    // This also will not properly handle nested brackets (e.g., obj1[obj2['prop']]; see #911).\n    var javaScriptAssignmentTarget = /^(?:[$_a-z][$\\w]*|(.+)(\\.\\s*[$_a-z][$\\w]*|\\[.+\\]))$/i;\n\n    function getWriteableValue(expression) {\n        if (ko.utils.arrayIndexOf(javaScriptReservedWords, expression) >= 0)\n            return false;\n        var match = expression.match(javaScriptAssignmentTarget);\n        return match === null ? false : match[1] ? ('Object(' + match[1] + ')' + match[2]) : expression;\n    }\n\n    // The following regular expressions will be used to split an object-literal string into tokens\n\n        // These two match strings, either with double quotes or single quotes\n    var stringDouble = '\"(?:[^\"\\\\\\\\]|\\\\\\\\.)*\"',\n        stringSingle = \"'(?:[^'\\\\\\\\]|\\\\\\\\.)*'\",\n        // Matches a regular expression (text enclosed by slashes), but will also match sets of divisions\n        // as a regular expression (this is handled by the parsing loop below).\n        stringRegexp = '/(?:[^/\\\\\\\\]|\\\\\\\\.)*/\\w*',\n        // These characters have special meaning to the parser and must not appear in the middle of a\n        // token, except as part of a string.\n        specials = ',\"\\'{}()/:[\\\\]',\n        // Match text (at least two characters) that does not contain any of the above special characters,\n        // although some of the special characters are allowed to start it (all but the colon and comma).\n        // The text can contain spaces, but leading or trailing spaces are skipped.\n        everyThingElse = '[^\\\\s:,/][^' + specials + ']*[^\\\\s' + specials + ']',\n        // Match any non-space character not matched already. This will match colons and commas, since they're\n        // not matched by \"everyThingElse\", but will also match any other single character that wasn't already\n        // matched (for example: in \"a: 1, b: 2\", each of the non-space characters will be matched by oneNotSpace).\n        oneNotSpace = '[^\\\\s]',\n\n        // Create the actual regular expression by or-ing the above strings. The order is important.\n        bindingToken = RegExp(stringDouble + '|' + stringSingle + '|' + stringRegexp + '|' + everyThingElse + '|' + oneNotSpace, 'g'),\n\n        // Match end of previous token to determine whether a slash is a division or regex.\n        divisionLookBehind = /[\\])\"'A-Za-z0-9_$]+$/,\n        keywordRegexLookBehind = {'in':1,'return':1,'typeof':1};\n\n    function parseObjectLiteral(objectLiteralString) {\n        // Trim leading and trailing spaces from the string\n        var str = ko.utils.stringTrim(objectLiteralString);\n\n        // Trim braces '{' surrounding the whole object literal\n        if (str.charCodeAt(0) === 123) str = str.slice(1, -1);\n\n        // Split into tokens\n        var result = [], toks = str.match(bindingToken), key, values = [], depth = 0;\n\n        if (toks) {\n            // Append a comma so that we don't need a separate code block to deal with the last item\n            toks.push(',');\n\n            for (var i = 0, tok; tok = toks[i]; ++i) {\n                var c = tok.charCodeAt(0);\n                // A comma signals the end of a key/value pair if depth is zero\n                if (c === 44) { // \",\"\n                    if (depth <= 0) {\n                        result.push((key && values.length) ? {key: key, value: values.join('')} : {'unknown': key || values.join('')});\n                        key = depth = 0;\n                        values = [];\n                        continue;\n                    }\n                // Simply skip the colon that separates the name and value\n                } else if (c === 58) { // \":\"\n                    if (!depth && !key && values.length === 1) {\n                        key = values.pop();\n                        continue;\n                    }\n                // A set of slashes is initially matched as a regular expression, but could be division\n                } else if (c === 47 && i && tok.length > 1) {  // \"/\"\n                    // Look at the end of the previous token to determine if the slash is actually division\n                    var match = toks[i-1].match(divisionLookBehind);\n                    if (match && !keywordRegexLookBehind[match[0]]) {\n                        // The slash is actually a division punctuator; re-parse the remainder of the string (not including the slash)\n                        str = str.substr(str.indexOf(tok) + 1);\n                        toks = str.match(bindingToken);\n                        toks.push(',');\n                        i = -1;\n                        // Continue with just the slash\n                        tok = '/';\n                    }\n                // Increment depth for parentheses, braces, and brackets so that interior commas are ignored\n                } else if (c === 40 || c === 123 || c === 91) { // '(', '{', '['\n                    ++depth;\n                } else if (c === 41 || c === 125 || c === 93) { // ')', '}', ']'\n                    --depth;\n                // The key will be the first token; if it's a string, trim the quotes\n                } else if (!key && !values.length && (c === 34 || c === 39)) { // '\"', \"'\"\n                    tok = tok.slice(1, -1);\n                }\n                values.push(tok);\n            }\n        }\n        return result;\n    }\n\n    // Two-way bindings include a write function that allow the handler to update the value even if it's not an observable.\n    var twoWayBindings = {};\n\n    function preProcessBindings(bindingsStringOrKeyValueArray, bindingOptions) {\n        bindingOptions = bindingOptions || {};\n\n        function processKeyValue(key, val) {\n            var writableVal;\n            function callPreprocessHook(obj) {\n                return (obj && obj['preprocess']) ? (val = obj['preprocess'](val, key, processKeyValue)) : true;\n            }\n            if (!bindingParams) {\n                if (!callPreprocessHook(ko['getBindingHandler'](key)))\n                    return;\n\n                if (twoWayBindings[key] && (writableVal = getWriteableValue(val))) {\n                    // For two-way bindings, provide a write method in case the value\n                    // isn't a writable observable.\n                    propertyAccessorResultStrings.push(\"'\" + key + \"':function(_z){\" + writableVal + \"=_z}\");\n                }\n            }\n            // Values are wrapped in a function so that each value can be accessed independently\n            if (makeValueAccessors) {\n                val = 'function(){return ' + val + ' }';\n            }\n            resultStrings.push(\"'\" + key + \"':\" + val);\n        }\n\n        var resultStrings = [],\n            propertyAccessorResultStrings = [],\n            makeValueAccessors = bindingOptions['valueAccessors'],\n            bindingParams = bindingOptions['bindingParams'],\n            keyValueArray = typeof bindingsStringOrKeyValueArray === \"string\" ?\n                parseObjectLiteral(bindingsStringOrKeyValueArray) : bindingsStringOrKeyValueArray;\n\n        ko.utils.arrayForEach(keyValueArray, function(keyValue) {\n            processKeyValue(keyValue.key || keyValue['unknown'], keyValue.value);\n        });\n\n        if (propertyAccessorResultStrings.length)\n            processKeyValue('_ko_property_writers', \"{\" + propertyAccessorResultStrings.join(\",\") + \" }\");\n\n        return resultStrings.join(\",\");\n    }\n\n    return {\n        bindingRewriteValidators: [],\n\n        twoWayBindings: twoWayBindings,\n\n        parseObjectLiteral: parseObjectLiteral,\n\n        preProcessBindings: preProcessBindings,\n\n        keyValueArrayContainsKey: function(keyValueArray, key) {\n            for (var i = 0; i < keyValueArray.length; i++)\n                if (keyValueArray[i]['key'] == key)\n                    return true;\n            return false;\n        },\n\n        // Internal, private KO utility for updating model properties from within bindings\n        // property:            If the property being updated is (or might be) an observable, pass it here\n        //                      If it turns out to be a writable observable, it will be written to directly\n        // allBindings:         An object with a get method to retrieve bindings in the current execution context.\n        //                      This will be searched for a '_ko_property_writers' property in case you're writing to a non-observable\n        // key:                 The key identifying the property to be written. Example: for { hasFocus: myValue }, write to 'myValue' by specifying the key 'hasFocus'\n        // value:               The value to be written\n        // checkIfDifferent:    If true, and if the property being written is a writable observable, the value will only be written if\n        //                      it is !== existing value on that writable observable\n        writeValueToProperty: function(property, allBindings, key, value, checkIfDifferent) {\n            if (!property || !ko.isObservable(property)) {\n                var propWriters = allBindings.get('_ko_property_writers');\n                if (propWriters && propWriters[key])\n                    propWriters[key](value);\n            } else if (ko.isWriteableObservable(property) && (!checkIfDifferent || property.peek() !== value)) {\n                property(value);\n            }\n        }\n    };\n})();\n\nko.exportSymbol('expressionRewriting', ko.expressionRewriting);\nko.exportSymbol('expressionRewriting.bindingRewriteValidators', ko.expressionRewriting.bindingRewriteValidators);\nko.exportSymbol('expressionRewriting.parseObjectLiteral', ko.expressionRewriting.parseObjectLiteral);\nko.exportSymbol('expressionRewriting.preProcessBindings', ko.expressionRewriting.preProcessBindings);\n\n// Making bindings explicitly declare themselves as \"two way\" isn't ideal in the long term (it would be better if\n// all bindings could use an official 'property writer' API without needing to declare that they might). However,\n// since this is not, and has never been, a public API (_ko_property_writers was never documented), it's acceptable\n// as an internal implementation detail in the short term.\n// For those developers who rely on _ko_property_writers in their custom bindings, we expose _twoWayBindings as an\n// undocumented feature that makes it relatively easy to upgrade to KO 3.0. However, this is still not an official\n// public API, and we reserve the right to remove it at any time if we create a real public property writers API.\nko.exportSymbol('expressionRewriting._twoWayBindings', ko.expressionRewriting.twoWayBindings);\n\n// For backward compatibility, define the following aliases. (Previously, these function names were misleading because\n// they referred to JSON specifically, even though they actually work with arbitrary JavaScript object literal expressions.)\nko.exportSymbol('jsonExpressionRewriting', ko.expressionRewriting);\nko.exportSymbol('jsonExpressionRewriting.insertPropertyAccessorsIntoJson', ko.expressionRewriting.preProcessBindings);\n(function() {\n    // \"Virtual elements\" is an abstraction on top of the usual DOM API which understands the notion that comment nodes\n    // may be used to represent hierarchy (in addition to the DOM's natural hierarchy).\n    // If you call the DOM-manipulating functions on ko.virtualElements, you will be able to read and write the state\n    // of that virtual hierarchy\n    //\n    // The point of all this is to support containerless templates (e.g., <!-- ko foreach:someCollection -->blah<!-- /ko -->)\n    // without having to scatter special cases all over the binding and templating code.\n\n    // IE 9 cannot reliably read the \"nodeValue\" property of a comment node (see https://github.com/SteveSanderson/knockout/issues/186)\n    // but it does give them a nonstandard alternative property called \"text\" that it can read reliably. Other browsers don't have that property.\n    // So, use node.text where available, and node.nodeValue elsewhere\n    var commentNodesHaveTextProperty = document && document.createComment(\"test\").text === \"<!--test-->\";\n\n    var startCommentRegex = commentNodesHaveTextProperty ? /^<!--\\s*ko(?:\\s+([\\s\\S]+))?\\s*-->$/ : /^\\s*ko(?:\\s+([\\s\\S]+))?\\s*$/;\n    var endCommentRegex =   commentNodesHaveTextProperty ? /^<!--\\s*\\/ko\\s*-->$/ : /^\\s*\\/ko\\s*$/;\n    var htmlTagsWithOptionallyClosingChildren = { 'ul': true, 'ol': true };\n\n    function isStartComment(node) {\n        return (node.nodeType == 8) && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n    }\n\n    function isEndComment(node) {\n        return (node.nodeType == 8) && endCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);\n    }\n\n    function getVirtualChildren(startComment, allowUnbalanced) {\n        var currentNode = startComment;\n        var depth = 1;\n        var children = [];\n        while (currentNode = currentNode.nextSibling) {\n            if (isEndComment(currentNode)) {\n                depth--;\n                if (depth === 0)\n                    return children;\n            }\n\n            children.push(currentNode);\n\n            if (isStartComment(currentNode))\n                depth++;\n        }\n        if (!allowUnbalanced)\n            throw new Error(\"Cannot find closing comment tag to match: \" + startComment.nodeValue);\n        return null;\n    }\n\n    function getMatchingEndComment(startComment, allowUnbalanced) {\n        var allVirtualChildren = getVirtualChildren(startComment, allowUnbalanced);\n        if (allVirtualChildren) {\n            if (allVirtualChildren.length > 0)\n                return allVirtualChildren[allVirtualChildren.length - 1].nextSibling;\n            return startComment.nextSibling;\n        } else\n            return null; // Must have no matching end comment, and allowUnbalanced is true\n    }\n\n    function getUnbalancedChildTags(node) {\n        // e.g., from <div>OK</div><!-- ko blah --><span>Another</span>, returns: <!-- ko blah --><span>Another</span>\n        //       from <div>OK</div><!-- /ko --><!-- /ko -->,             returns: <!-- /ko --><!-- /ko -->\n        var childNode = node.firstChild, captureRemaining = null;\n        if (childNode) {\n            do {\n                if (captureRemaining)                   // We already hit an unbalanced node and are now just scooping up all subsequent nodes\n                    captureRemaining.push(childNode);\n                else if (isStartComment(childNode)) {\n                    var matchingEndComment = getMatchingEndComment(childNode, /* allowUnbalanced: */ true);\n                    if (matchingEndComment)             // It's a balanced tag, so skip immediately to the end of this virtual set\n                        childNode = matchingEndComment;\n                    else\n                        captureRemaining = [childNode]; // It's unbalanced, so start capturing from this point\n                } else if (isEndComment(childNode)) {\n                    captureRemaining = [childNode];     // It's unbalanced (if it wasn't, we'd have skipped over it already), so start capturing\n                }\n            } while (childNode = childNode.nextSibling);\n        }\n        return captureRemaining;\n    }\n\n    ko.virtualElements = {\n        allowedBindings: {},\n\n        childNodes: function(node) {\n            return isStartComment(node) ? getVirtualChildren(node) : node.childNodes;\n        },\n\n        emptyNode: function(node) {\n            if (!isStartComment(node))\n                ko.utils.emptyDomNode(node);\n            else {\n                var virtualChildren = ko.virtualElements.childNodes(node);\n                for (var i = 0, j = virtualChildren.length; i < j; i++)\n                    ko.removeNode(virtualChildren[i]);\n            }\n        },\n\n        setDomNodeChildren: function(node, childNodes) {\n            if (!isStartComment(node))\n                ko.utils.setDomNodeChildren(node, childNodes);\n            else {\n                ko.virtualElements.emptyNode(node);\n                var endCommentNode = node.nextSibling; // Must be the next sibling, as we just emptied the children\n                for (var i = 0, j = childNodes.length; i < j; i++)\n                    endCommentNode.parentNode.insertBefore(childNodes[i], endCommentNode);\n            }\n        },\n\n        prepend: function(containerNode, nodeToPrepend) {\n            if (!isStartComment(containerNode)) {\n                if (containerNode.firstChild)\n                    containerNode.insertBefore(nodeToPrepend, containerNode.firstChild);\n                else\n                    containerNode.appendChild(nodeToPrepend);\n            } else {\n                // Start comments must always have a parent and at least one following sibling (the end comment)\n                containerNode.parentNode.insertBefore(nodeToPrepend, containerNode.nextSibling);\n            }\n        },\n\n        insertAfter: function(containerNode, nodeToInsert, insertAfterNode) {\n            if (!insertAfterNode) {\n                ko.virtualElements.prepend(containerNode, nodeToInsert);\n            } else if (!isStartComment(containerNode)) {\n                // Insert after insertion point\n                if (insertAfterNode.nextSibling)\n                    containerNode.insertBefore(nodeToInsert, insertAfterNode.nextSibling);\n                else\n                    containerNode.appendChild(nodeToInsert);\n            } else {\n                // Children of start comments must always have a parent and at least one following sibling (the end comment)\n                containerNode.parentNode.insertBefore(nodeToInsert, insertAfterNode.nextSibling);\n            }\n        },\n\n        firstChild: function(node) {\n            if (!isStartComment(node))\n                return node.firstChild;\n            if (!node.nextSibling || isEndComment(node.nextSibling))\n                return null;\n            return node.nextSibling;\n        },\n\n        nextSibling: function(node) {\n            if (isStartComment(node))\n                node = getMatchingEndComment(node);\n            if (node.nextSibling && isEndComment(node.nextSibling))\n                return null;\n            return node.nextSibling;\n        },\n\n        hasBindingValue: isStartComment,\n\n        virtualNodeBindingValue: function(node) {\n            var regexMatch = (commentNodesHaveTextProperty ? node.text : node.nodeValue).match(startCommentRegex);\n            return regexMatch ? regexMatch[1] : null;\n        },\n\n        normaliseVirtualElementDomStructure: function(elementVerified) {\n            // Workaround for https://github.com/SteveSanderson/knockout/issues/155\n            // (IE <= 8 or IE 9 quirks mode parses your HTML weirdly, treating closing </li> tags as if they don't exist, thereby moving comment nodes\n            // that are direct descendants of <ul> into the preceding <li>)\n            if (!htmlTagsWithOptionallyClosingChildren[ko.utils.tagNameLower(elementVerified)])\n                return;\n\n            // Scan immediate children to see if they contain unbalanced comment tags. If they do, those comment tags\n            // must be intended to appear *after* that child, so move them there.\n            var childNode = elementVerified.firstChild;\n            if (childNode) {\n                do {\n                    if (childNode.nodeType === 1) {\n                        var unbalancedTags = getUnbalancedChildTags(childNode);\n                        if (unbalancedTags) {\n                            // Fix up the DOM by moving the unbalanced tags to where they most likely were intended to be placed - *after* the child\n                            var nodeToInsertBefore = childNode.nextSibling;\n                            for (var i = 0; i < unbalancedTags.length; i++) {\n                                if (nodeToInsertBefore)\n                                    elementVerified.insertBefore(unbalancedTags[i], nodeToInsertBefore);\n                                else\n                                    elementVerified.appendChild(unbalancedTags[i]);\n                            }\n                        }\n                    }\n                } while (childNode = childNode.nextSibling);\n            }\n        }\n    };\n})();\nko.exportSymbol('virtualElements', ko.virtualElements);\nko.exportSymbol('virtualElements.allowedBindings', ko.virtualElements.allowedBindings);\nko.exportSymbol('virtualElements.emptyNode', ko.virtualElements.emptyNode);\n//ko.exportSymbol('virtualElements.firstChild', ko.virtualElements.firstChild);     // firstChild is not minified\nko.exportSymbol('virtualElements.insertAfter', ko.virtualElements.insertAfter);\n//ko.exportSymbol('virtualElements.nextSibling', ko.virtualElements.nextSibling);   // nextSibling is not minified\nko.exportSymbol('virtualElements.prepend', ko.virtualElements.prepend);\nko.exportSymbol('virtualElements.setDomNodeChildren', ko.virtualElements.setDomNodeChildren);\n(function() {\n    var defaultBindingAttributeName = \"data-bind\";\n\n    ko.bindingProvider = function() {\n        this.bindingCache = {};\n    };\n\n    ko.utils.extend(ko.bindingProvider.prototype, {\n        'nodeHasBindings': function(node) {\n            switch (node.nodeType) {\n                case 1: // Element\n                    return node.getAttribute(defaultBindingAttributeName) != null\n                        || ko.components['getComponentNameForNode'](node);\n                case 8: // Comment node\n                    return ko.virtualElements.hasBindingValue(node);\n                default: return false;\n            }\n        },\n\n        'getBindings': function(node, bindingContext) {\n            var bindingsString = this['getBindingsString'](node, bindingContext),\n                parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node) : null;\n            return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ false);\n        },\n\n        'getBindingAccessors': function(node, bindingContext) {\n            var bindingsString = this['getBindingsString'](node, bindingContext),\n                parsedBindings = bindingsString ? this['parseBindingsString'](bindingsString, bindingContext, node, { 'valueAccessors': true }) : null;\n            return ko.components.addBindingsForCustomElement(parsedBindings, node, bindingContext, /* valueAccessors */ true);\n        },\n\n        // The following function is only used internally by this default provider.\n        // It's not part of the interface definition for a general binding provider.\n        'getBindingsString': function(node, bindingContext) {\n            switch (node.nodeType) {\n                case 1: return node.getAttribute(defaultBindingAttributeName);   // Element\n                case 8: return ko.virtualElements.virtualNodeBindingValue(node); // Comment node\n                default: return null;\n            }\n        },\n\n        // The following function is only used internally by this default provider.\n        // It's not part of the interface definition for a general binding provider.\n        'parseBindingsString': function(bindingsString, bindingContext, node, options) {\n            try {\n                var bindingFunction = createBindingsStringEvaluatorViaCache(bindingsString, this.bindingCache, options);\n                return bindingFunction(bindingContext, node);\n            } catch (ex) {\n                ex.message = \"Unable to parse bindings.\\nBindings value: \" + bindingsString + \"\\nMessage: \" + ex.message;\n                throw ex;\n            }\n        }\n    });\n\n    ko.bindingProvider['instance'] = new ko.bindingProvider();\n\n    function createBindingsStringEvaluatorViaCache(bindingsString, cache, options) {\n        var cacheKey = bindingsString + (options && options['valueAccessors'] || '');\n        return cache[cacheKey]\n            || (cache[cacheKey] = createBindingsStringEvaluator(bindingsString, options));\n    }\n\n    function createBindingsStringEvaluator(bindingsString, options) {\n        // Build the source for a function that evaluates \"expression\"\n        // For each scope variable, add an extra level of \"with\" nesting\n        // Example result: with(sc1) { with(sc0) { return (expression) } }\n        var rewrittenBindings = ko.expressionRewriting.preProcessBindings(bindingsString, options),\n            functionBody = \"with($context){with($data||{}){return{\" + rewrittenBindings + \"}}}\";\n        return new Function(\"$context\", \"$element\", functionBody);\n    }\n})();\n\nko.exportSymbol('bindingProvider', ko.bindingProvider);\n(function () {\n    ko.bindingHandlers = {};\n\n    // The following element types will not be recursed into during binding.\n    var bindingDoesNotRecurseIntoElementTypes = {\n        // Don't want bindings that operate on text nodes to mutate <script> and <textarea> contents,\n        // because it's unexpected and a potential XSS issue.\n        // Also bindings should not operate on <template> elements since this breaks in Internet Explorer\n        // and because such elements' contents are always intended to be bound in a different context\n        // from where they appear in the document.\n        'script': true,\n        'textarea': true,\n        'template': true\n    };\n\n    // Use an overridable method for retrieving binding handlers so that a plugins may support dynamically created handlers\n    ko['getBindingHandler'] = function(bindingKey) {\n        return ko.bindingHandlers[bindingKey];\n    };\n\n    // The ko.bindingContext constructor is only called directly to create the root context. For child\n    // contexts, use bindingContext.createChildContext or bindingContext.extend.\n    ko.bindingContext = function(dataItemOrAccessor, parentContext, dataItemAlias, extendCallback, options) {\n\n        // The binding context object includes static properties for the current, parent, and root view models.\n        // If a view model is actually stored in an observable, the corresponding binding context object, and\n        // any child contexts, must be updated when the view model is changed.\n        function updateContext() {\n            // Most of the time, the context will directly get a view model object, but if a function is given,\n            // we call the function to retrieve the view model. If the function accesses any observables or returns\n            // an observable, the dependency is tracked, and those observables can later cause the binding\n            // context to be updated.\n            var dataItemOrObservable = isFunc ? dataItemOrAccessor() : dataItemOrAccessor,\n                dataItem = ko.utils.unwrapObservable(dataItemOrObservable);\n\n            if (parentContext) {\n                // When a \"parent\" context is given, register a dependency on the parent context. Thus whenever the\n                // parent context is updated, this context will also be updated.\n                if (parentContext._subscribable)\n                    parentContext._subscribable();\n\n                // Copy $root and any custom properties from the parent context\n                ko.utils.extend(self, parentContext);\n\n                // Because the above copy overwrites our own properties, we need to reset them.\n                self._subscribable = subscribable;\n            } else {\n                self['$parents'] = [];\n                self['$root'] = dataItem;\n\n                // Export 'ko' in the binding context so it will be available in bindings and templates\n                // even if 'ko' isn't exported as a global, such as when using an AMD loader.\n                // See https://github.com/SteveSanderson/knockout/issues/490\n                self['ko'] = ko;\n            }\n            self['$rawData'] = dataItemOrObservable;\n            self['$data'] = dataItem;\n            if (dataItemAlias)\n                self[dataItemAlias] = dataItem;\n\n            // The extendCallback function is provided when creating a child context or extending a context.\n            // It handles the specific actions needed to finish setting up the binding context. Actions in this\n            // function could also add dependencies to this binding context.\n            if (extendCallback)\n                extendCallback(self, parentContext, dataItem);\n\n            return self['$data'];\n        }\n        function disposeWhen() {\n            return nodes && !ko.utils.anyDomNodeIsAttachedToDocument(nodes);\n        }\n\n        var self = this,\n            isFunc = typeof(dataItemOrAccessor) == \"function\" && !ko.isObservable(dataItemOrAccessor),\n            nodes,\n            subscribable;\n\n        if (options && options['exportDependencies']) {\n            // The \"exportDependencies\" option means that the calling code will track any dependencies and re-create\n            // the binding context when they change.\n            updateContext();\n        } else {\n            subscribable = ko.dependentObservable(updateContext, null, { disposeWhen: disposeWhen, disposeWhenNodeIsRemoved: true });\n\n            // At this point, the binding context has been initialized, and the \"subscribable\" computed observable is\n            // subscribed to any observables that were accessed in the process. If there is nothing to track, the\n            // computed will be inactive, and we can safely throw it away. If it's active, the computed is stored in\n            // the context object.\n            if (subscribable.isActive()) {\n                self._subscribable = subscribable;\n\n                // Always notify because even if the model ($data) hasn't changed, other context properties might have changed\n                subscribable['equalityComparer'] = null;\n\n                // We need to be able to dispose of this computed observable when it's no longer needed. This would be\n                // easy if we had a single node to watch, but binding contexts can be used by many different nodes, and\n                // we cannot assume that those nodes have any relation to each other. So instead we track any node that\n                // the context is attached to, and dispose the computed when all of those nodes have been cleaned.\n\n                // Add properties to *subscribable* instead of *self* because any properties added to *self* may be overwritten on updates\n                nodes = [];\n                subscribable._addNode = function(node) {\n                    nodes.push(node);\n                    ko.utils.domNodeDisposal.addDisposeCallback(node, function(node) {\n                        ko.utils.arrayRemoveItem(nodes, node);\n                        if (!nodes.length) {\n                            subscribable.dispose();\n                            self._subscribable = subscribable = undefined;\n                        }\n                    });\n                };\n            }\n        }\n    }\n\n    // Extend the binding context hierarchy with a new view model object. If the parent context is watching\n    // any observables, the new child context will automatically get a dependency on the parent context.\n    // But this does not mean that the $data value of the child context will also get updated. If the child\n    // view model also depends on the parent view model, you must provide a function that returns the correct\n    // view model on each update.\n    ko.bindingContext.prototype['createChildContext'] = function (dataItemOrAccessor, dataItemAlias, extendCallback, options) {\n        return new ko.bindingContext(dataItemOrAccessor, this, dataItemAlias, function(self, parentContext) {\n            // Extend the context hierarchy by setting the appropriate pointers\n            self['$parentContext'] = parentContext;\n            self['$parent'] = parentContext['$data'];\n            self['$parents'] = (parentContext['$parents'] || []).slice(0);\n            self['$parents'].unshift(self['$parent']);\n            if (extendCallback)\n                extendCallback(self);\n        }, options);\n    };\n\n    // Extend the binding context with new custom properties. This doesn't change the context hierarchy.\n    // Similarly to \"child\" contexts, provide a function here to make sure that the correct values are set\n    // when an observable view model is updated.\n    ko.bindingContext.prototype['extend'] = function(properties) {\n        // If the parent context references an observable view model, \"_subscribable\" will always be the\n        // latest view model object. If not, \"_subscribable\" isn't set, and we can use the static \"$data\" value.\n        return new ko.bindingContext(this._subscribable || this['$data'], this, null, function(self, parentContext) {\n            // This \"child\" context doesn't directly track a parent observable view model,\n            // so we need to manually set the $rawData value to match the parent.\n            self['$rawData'] = parentContext['$rawData'];\n            ko.utils.extend(self, typeof(properties) == \"function\" ? properties() : properties);\n        });\n    };\n\n    ko.bindingContext.prototype.createStaticChildContext = function (dataItemOrAccessor, dataItemAlias) {\n        return this['createChildContext'](dataItemOrAccessor, dataItemAlias, null, { \"exportDependencies\": true });\n    };\n\n    // Returns the valueAccesor function for a binding value\n    function makeValueAccessor(value) {\n        return function() {\n            return value;\n        };\n    }\n\n    // Returns the value of a valueAccessor function\n    function evaluateValueAccessor(valueAccessor) {\n        return valueAccessor();\n    }\n\n    // Given a function that returns bindings, create and return a new object that contains\n    // binding value-accessors functions. Each accessor function calls the original function\n    // so that it always gets the latest value and all dependencies are captured. This is used\n    // by ko.applyBindingsToNode and getBindingsAndMakeAccessors.\n    function makeAccessorsFromFunction(callback) {\n        return ko.utils.objectMap(ko.dependencyDetection.ignore(callback), function(value, key) {\n            return function() {\n                return callback()[key];\n            };\n        });\n    }\n\n    // Given a bindings function or object, create and return a new object that contains\n    // binding value-accessors functions. This is used by ko.applyBindingsToNode.\n    function makeBindingAccessors(bindings, context, node) {\n        if (typeof bindings === 'function') {\n            return makeAccessorsFromFunction(bindings.bind(null, context, node));\n        } else {\n            return ko.utils.objectMap(bindings, makeValueAccessor);\n        }\n    }\n\n    // This function is used if the binding provider doesn't include a getBindingAccessors function.\n    // It must be called with 'this' set to the provider instance.\n    function getBindingsAndMakeAccessors(node, context) {\n        return makeAccessorsFromFunction(this['getBindings'].bind(this, node, context));\n    }\n\n    function validateThatBindingIsAllowedForVirtualElements(bindingName) {\n        var validator = ko.virtualElements.allowedBindings[bindingName];\n        if (!validator)\n            throw new Error(\"The binding '\" + bindingName + \"' cannot be used with virtual elements\")\n    }\n\n    function applyBindingsToDescendantsInternal (bindingContext, elementOrVirtualElement, bindingContextsMayDifferFromDomParentElement) {\n        var currentChild,\n            nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement),\n            provider = ko.bindingProvider['instance'],\n            preprocessNode = provider['preprocessNode'];\n\n        // Preprocessing allows a binding provider to mutate a node before bindings are applied to it. For example it's\n        // possible to insert new siblings after it, and/or replace the node with a different one. This can be used to\n        // implement custom binding syntaxes, such as {{ value }} for string interpolation, or custom element types that\n        // trigger insertion of <template> contents at that point in the document.\n        if (preprocessNode) {\n            while (currentChild = nextInQueue) {\n                nextInQueue = ko.virtualElements.nextSibling(currentChild);\n                preprocessNode.call(provider, currentChild);\n            }\n            // Reset nextInQueue for the next loop\n            nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);\n        }\n\n        while (currentChild = nextInQueue) {\n            // Keep a record of the next child *before* applying bindings, in case the binding removes the current child from its position\n            nextInQueue = ko.virtualElements.nextSibling(currentChild);\n            applyBindingsToNodeAndDescendantsInternal(bindingContext, currentChild, bindingContextsMayDifferFromDomParentElement);\n        }\n    }\n\n    function applyBindingsToNodeAndDescendantsInternal (bindingContext, nodeVerified, bindingContextMayDifferFromDomParentElement) {\n        var shouldBindDescendants = true;\n\n        // Perf optimisation: Apply bindings only if...\n        // (1) We need to store the binding context on this node (because it may differ from the DOM parent node's binding context)\n        //     Note that we can't store binding contexts on non-elements (e.g., text nodes), as IE doesn't allow expando properties for those\n        // (2) It might have bindings (e.g., it has a data-bind attribute, or it's a marker for a containerless template)\n        var isElement = (nodeVerified.nodeType === 1);\n        if (isElement) // Workaround IE <= 8 HTML parsing weirdness\n            ko.virtualElements.normaliseVirtualElementDomStructure(nodeVerified);\n\n        var shouldApplyBindings = (isElement && bindingContextMayDifferFromDomParentElement)             // Case (1)\n                               || ko.bindingProvider['instance']['nodeHasBindings'](nodeVerified);       // Case (2)\n        if (shouldApplyBindings)\n            shouldBindDescendants = applyBindingsToNodeInternal(nodeVerified, null, bindingContext, bindingContextMayDifferFromDomParentElement)['shouldBindDescendants'];\n\n        if (shouldBindDescendants && !bindingDoesNotRecurseIntoElementTypes[ko.utils.tagNameLower(nodeVerified)]) {\n            // We're recursing automatically into (real or virtual) child nodes without changing binding contexts. So,\n            //  * For children of a *real* element, the binding context is certainly the same as on their DOM .parentNode,\n            //    hence bindingContextsMayDifferFromDomParentElement is false\n            //  * For children of a *virtual* element, we can't be sure. Evaluating .parentNode on those children may\n            //    skip over any number of intermediate virtual elements, any of which might define a custom binding context,\n            //    hence bindingContextsMayDifferFromDomParentElement is true\n            applyBindingsToDescendantsInternal(bindingContext, nodeVerified, /* bindingContextsMayDifferFromDomParentElement: */ !isElement);\n        }\n    }\n\n    var boundElementDomDataKey = ko.utils.domData.nextKey();\n\n\n    function topologicalSortBindings(bindings) {\n        // Depth-first sort\n        var result = [],                // The list of key/handler pairs that we will return\n            bindingsConsidered = {},    // A temporary record of which bindings are already in 'result'\n            cyclicDependencyStack = []; // Keeps track of a depth-search so that, if there's a cycle, we know which bindings caused it\n        ko.utils.objectForEach(bindings, function pushBinding(bindingKey) {\n            if (!bindingsConsidered[bindingKey]) {\n                var binding = ko['getBindingHandler'](bindingKey);\n                if (binding) {\n                    // First add dependencies (if any) of the current binding\n                    if (binding['after']) {\n                        cyclicDependencyStack.push(bindingKey);\n                        ko.utils.arrayForEach(binding['after'], function(bindingDependencyKey) {\n                            if (bindings[bindingDependencyKey]) {\n                                if (ko.utils.arrayIndexOf(cyclicDependencyStack, bindingDependencyKey) !== -1) {\n                                    throw Error(\"Cannot combine the following bindings, because they have a cyclic dependency: \" + cyclicDependencyStack.join(\", \"));\n                                } else {\n                                    pushBinding(bindingDependencyKey);\n                                }\n                            }\n                        });\n                        cyclicDependencyStack.length--;\n                    }\n                    // Next add the current binding\n                    result.push({ key: bindingKey, handler: binding });\n                }\n                bindingsConsidered[bindingKey] = true;\n            }\n        });\n\n        return result;\n    }\n\n    function applyBindingsToNodeInternal(node, sourceBindings, bindingContext, bindingContextMayDifferFromDomParentElement) {\n        // Prevent multiple applyBindings calls for the same node, except when a binding value is specified\n        var alreadyBound = ko.utils.domData.get(node, boundElementDomDataKey);\n        if (!sourceBindings) {\n            if (alreadyBound) {\n                throw Error(\"You cannot apply bindings multiple times to the same element.\");\n            }\n            ko.utils.domData.set(node, boundElementDomDataKey, true);\n        }\n\n        // Optimization: Don't store the binding context on this node if it's definitely the same as on node.parentNode, because\n        // we can easily recover it just by scanning up the node's ancestors in the DOM\n        // (note: here, parent node means \"real DOM parent\" not \"virtual parent\", as there's no O(1) way to find the virtual parent)\n        if (!alreadyBound && bindingContextMayDifferFromDomParentElement)\n            ko.storedBindingContextForNode(node, bindingContext);\n\n        // Use bindings if given, otherwise fall back on asking the bindings provider to give us some bindings\n        var bindings;\n        if (sourceBindings && typeof sourceBindings !== 'function') {\n            bindings = sourceBindings;\n        } else {\n            var provider = ko.bindingProvider['instance'],\n                getBindings = provider['getBindingAccessors'] || getBindingsAndMakeAccessors;\n\n            // Get the binding from the provider within a computed observable so that we can update the bindings whenever\n            // the binding context is updated or if the binding provider accesses observables.\n            var bindingsUpdater = ko.dependentObservable(\n                function() {\n                    bindings = sourceBindings ? sourceBindings(bindingContext, node) : getBindings.call(provider, node, bindingContext);\n                    // Register a dependency on the binding context to support observable view models.\n                    if (bindings && bindingContext._subscribable)\n                        bindingContext._subscribable();\n                    return bindings;\n                },\n                null, { disposeWhenNodeIsRemoved: node }\n            );\n\n            if (!bindings || !bindingsUpdater.isActive())\n                bindingsUpdater = null;\n        }\n\n        var bindingHandlerThatControlsDescendantBindings;\n        if (bindings) {\n            // Return the value accessor for a given binding. When bindings are static (won't be updated because of a binding\n            // context update), just return the value accessor from the binding. Otherwise, return a function that always gets\n            // the latest binding value and registers a dependency on the binding updater.\n            var getValueAccessor = bindingsUpdater\n                ? function(bindingKey) {\n                    return function() {\n                        return evaluateValueAccessor(bindingsUpdater()[bindingKey]);\n                    };\n                } : function(bindingKey) {\n                    return bindings[bindingKey];\n                };\n\n            // Use of allBindings as a function is maintained for backwards compatibility, but its use is deprecated\n            function allBindings() {\n                return ko.utils.objectMap(bindingsUpdater ? bindingsUpdater() : bindings, evaluateValueAccessor);\n            }\n            // The following is the 3.x allBindings API\n            allBindings['get'] = function(key) {\n                return bindings[key] && evaluateValueAccessor(getValueAccessor(key));\n            };\n            allBindings['has'] = function(key) {\n                return key in bindings;\n            };\n\n            // First put the bindings into the right order\n            var orderedBindings = topologicalSortBindings(bindings);\n\n            // Go through the sorted bindings, calling init and update for each\n            ko.utils.arrayForEach(orderedBindings, function(bindingKeyAndHandler) {\n                // Note that topologicalSortBindings has already filtered out any nonexistent binding handlers,\n                // so bindingKeyAndHandler.handler will always be nonnull.\n                var handlerInitFn = bindingKeyAndHandler.handler[\"init\"],\n                    handlerUpdateFn = bindingKeyAndHandler.handler[\"update\"],\n                    bindingKey = bindingKeyAndHandler.key;\n\n                if (node.nodeType === 8) {\n                    validateThatBindingIsAllowedForVirtualElements(bindingKey);\n                }\n\n                try {\n                    // Run init, ignoring any dependencies\n                    if (typeof handlerInitFn == \"function\") {\n                        ko.dependencyDetection.ignore(function() {\n                            var initResult = handlerInitFn(node, getValueAccessor(bindingKey), allBindings, bindingContext['$data'], bindingContext);\n\n                            // If this binding handler claims to control descendant bindings, make a note of this\n                            if (initResult && initResult['controlsDescendantBindings']) {\n                                if (bindingHandlerThatControlsDescendantBindings !== undefined)\n                                    throw new Error(\"Multiple bindings (\" + bindingHandlerThatControlsDescendantBindings + \" and \" + bindingKey + \") are trying to control descendant bindings of the same element. You cannot use these bindings together on the same element.\");\n                                bindingHandlerThatControlsDescendantBindings = bindingKey;\n                            }\n                        });\n                    }\n\n                    // Run update in its own computed wrapper\n                    if (typeof handlerUpdateFn == \"function\") {\n                        ko.dependentObservable(\n                            function() {\n                                handlerUpdateFn(node, getValueAccessor(bindingKey), allBindings, bindingContext['$data'], bindingContext);\n                            },\n                            null,\n                            { disposeWhenNodeIsRemoved: node }\n                        );\n                    }\n                } catch (ex) {\n                    ex.message = \"Unable to process binding \\\"\" + bindingKey + \": \" + bindings[bindingKey] + \"\\\"\\nMessage: \" + ex.message;\n                    throw ex;\n                }\n            });\n        }\n\n        return {\n            'shouldBindDescendants': bindingHandlerThatControlsDescendantBindings === undefined\n        };\n    };\n\n    var storedBindingContextDomDataKey = ko.utils.domData.nextKey();\n    ko.storedBindingContextForNode = function (node, bindingContext) {\n        if (arguments.length == 2) {\n            ko.utils.domData.set(node, storedBindingContextDomDataKey, bindingContext);\n            if (bindingContext._subscribable)\n                bindingContext._subscribable._addNode(node);\n        } else {\n            return ko.utils.domData.get(node, storedBindingContextDomDataKey);\n        }\n    }\n\n    function getBindingContext(viewModelOrBindingContext) {\n        return viewModelOrBindingContext && (viewModelOrBindingContext instanceof ko.bindingContext)\n            ? viewModelOrBindingContext\n            : new ko.bindingContext(viewModelOrBindingContext);\n    }\n\n    ko.applyBindingAccessorsToNode = function (node, bindings, viewModelOrBindingContext) {\n        if (node.nodeType === 1) // If it's an element, workaround IE <= 8 HTML parsing weirdness\n            ko.virtualElements.normaliseVirtualElementDomStructure(node);\n        return applyBindingsToNodeInternal(node, bindings, getBindingContext(viewModelOrBindingContext), true);\n    };\n\n    ko.applyBindingsToNode = function (node, bindings, viewModelOrBindingContext) {\n        var context = getBindingContext(viewModelOrBindingContext);\n        return ko.applyBindingAccessorsToNode(node, makeBindingAccessors(bindings, context, node), context);\n    };\n\n    ko.applyBindingsToDescendants = function(viewModelOrBindingContext, rootNode) {\n        if (rootNode.nodeType === 1 || rootNode.nodeType === 8)\n            applyBindingsToDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode, true);\n    };\n\n    ko.applyBindings = function (viewModelOrBindingContext, rootNode) {\n        // If jQuery is loaded after Knockout, we won't initially have access to it. So save it here.\n        if (!jQueryInstance && window['jQuery']) {\n            jQueryInstance = window['jQuery'];\n        }\n\n        if (rootNode && (rootNode.nodeType !== 1) && (rootNode.nodeType !== 8))\n            throw new Error(\"ko.applyBindings: first parameter should be your view model; second parameter should be a DOM node\");\n        rootNode = rootNode || window.document.body; // Make \"rootNode\" parameter optional\n\n        applyBindingsToNodeAndDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode, true);\n    };\n\n    // Retrieving binding context from arbitrary nodes\n    ko.contextFor = function(node) {\n        // We can only do something meaningful for elements and comment nodes (in particular, not text nodes, as IE can't store domdata for them)\n        switch (node.nodeType) {\n            case 1:\n            case 8:\n                var context = ko.storedBindingContextForNode(node);\n                if (context) return context;\n                if (node.parentNode) return ko.contextFor(node.parentNode);\n                break;\n        }\n        return undefined;\n    };\n    ko.dataFor = function(node) {\n        var context = ko.contextFor(node);\n        return context ? context['$data'] : undefined;\n    };\n\n    ko.exportSymbol('bindingHandlers', ko.bindingHandlers);\n    ko.exportSymbol('applyBindings', ko.applyBindings);\n    ko.exportSymbol('applyBindingsToDescendants', ko.applyBindingsToDescendants);\n    ko.exportSymbol('applyBindingAccessorsToNode', ko.applyBindingAccessorsToNode);\n    ko.exportSymbol('applyBindingsToNode', ko.applyBindingsToNode);\n    ko.exportSymbol('contextFor', ko.contextFor);\n    ko.exportSymbol('dataFor', ko.dataFor);\n})();\n(function(undefined) {\n    var loadingSubscribablesCache = {}, // Tracks component loads that are currently in flight\n        loadedDefinitionsCache = {};    // Tracks component loads that have already completed\n\n    ko.components = {\n        get: function(componentName, callback) {\n            var cachedDefinition = getObjectOwnProperty(loadedDefinitionsCache, componentName);\n            if (cachedDefinition) {\n                // It's already loaded and cached. Reuse the same definition object.\n                // Note that for API consistency, even cache hits complete asynchronously by default.\n                // You can bypass this by putting synchronous:true on your component config.\n                if (cachedDefinition.isSynchronousComponent) {\n                    ko.dependencyDetection.ignore(function() { // See comment in loaderRegistryBehaviors.js for reasoning\n                        callback(cachedDefinition.definition);\n                    });\n                } else {\n                    ko.tasks.schedule(function() { callback(cachedDefinition.definition); });\n                }\n            } else {\n                // Join the loading process that is already underway, or start a new one.\n                loadComponentAndNotify(componentName, callback);\n            }\n        },\n\n        clearCachedDefinition: function(componentName) {\n            delete loadedDefinitionsCache[componentName];\n        },\n\n        _getFirstResultFromLoaders: getFirstResultFromLoaders\n    };\n\n    function getObjectOwnProperty(obj, propName) {\n        return obj.hasOwnProperty(propName) ? obj[propName] : undefined;\n    }\n\n    function loadComponentAndNotify(componentName, callback) {\n        var subscribable = getObjectOwnProperty(loadingSubscribablesCache, componentName),\n            completedAsync;\n        if (!subscribable) {\n            // It's not started loading yet. Start loading, and when it's done, move it to loadedDefinitionsCache.\n            subscribable = loadingSubscribablesCache[componentName] = new ko.subscribable();\n            subscribable.subscribe(callback);\n\n            beginLoadingComponent(componentName, function(definition, config) {\n                var isSynchronousComponent = !!(config && config['synchronous']);\n                loadedDefinitionsCache[componentName] = { definition: definition, isSynchronousComponent: isSynchronousComponent };\n                delete loadingSubscribablesCache[componentName];\n\n                // For API consistency, all loads complete asynchronously. However we want to avoid\n                // adding an extra task schedule if it's unnecessary (i.e., the completion is already\n                // async).\n                //\n                // You can bypass the 'always asynchronous' feature by putting the synchronous:true\n                // flag on your component configuration when you register it.\n                if (completedAsync || isSynchronousComponent) {\n                    // Note that notifySubscribers ignores any dependencies read within the callback.\n                    // See comment in loaderRegistryBehaviors.js for reasoning\n                    subscribable['notifySubscribers'](definition);\n                } else {\n                    ko.tasks.schedule(function() {\n                        subscribable['notifySubscribers'](definition);\n                    });\n                }\n            });\n            completedAsync = true;\n        } else {\n            subscribable.subscribe(callback);\n        }\n    }\n\n    function beginLoadingComponent(componentName, callback) {\n        getFirstResultFromLoaders('getConfig', [componentName], function(config) {\n            if (config) {\n                // We have a config, so now load its definition\n                getFirstResultFromLoaders('loadComponent', [componentName, config], function(definition) {\n                    callback(definition, config);\n                });\n            } else {\n                // The component has no config - it's unknown to all the loaders.\n                // Note that this is not an error (e.g., a module loading error) - that would abort the\n                // process and this callback would not run. For this callback to run, all loaders must\n                // have confirmed they don't know about this component.\n                callback(null, null);\n            }\n        });\n    }\n\n    function getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders) {\n        // On the first call in the stack, start with the full set of loaders\n        if (!candidateLoaders) {\n            candidateLoaders = ko.components['loaders'].slice(0); // Use a copy, because we'll be mutating this array\n        }\n\n        // Try the next candidate\n        var currentCandidateLoader = candidateLoaders.shift();\n        if (currentCandidateLoader) {\n            var methodInstance = currentCandidateLoader[methodName];\n            if (methodInstance) {\n                var wasAborted = false,\n                    synchronousReturnValue = methodInstance.apply(currentCandidateLoader, argsExceptCallback.concat(function(result) {\n                        if (wasAborted) {\n                            callback(null);\n                        } else if (result !== null) {\n                            // This candidate returned a value. Use it.\n                            callback(result);\n                        } else {\n                            // Try the next candidate\n                            getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n                        }\n                    }));\n\n                // Currently, loaders may not return anything synchronously. This leaves open the possibility\n                // that we'll extend the API to support synchronous return values in the future. It won't be\n                // a breaking change, because currently no loader is allowed to return anything except undefined.\n                if (synchronousReturnValue !== undefined) {\n                    wasAborted = true;\n\n                    // Method to suppress exceptions will remain undocumented. This is only to keep\n                    // KO's specs running tidily, since we can observe the loading got aborted without\n                    // having exceptions cluttering up the console too.\n                    if (!currentCandidateLoader['suppressLoaderExceptions']) {\n                        throw new Error('Component loaders must supply values by invoking the callback, not by returning values synchronously.');\n                    }\n                }\n            } else {\n                // This candidate doesn't have the relevant handler. Synchronously move on to the next one.\n                getFirstResultFromLoaders(methodName, argsExceptCallback, callback, candidateLoaders);\n            }\n        } else {\n            // No candidates returned a value\n            callback(null);\n        }\n    }\n\n    // Reference the loaders via string name so it's possible for developers\n    // to replace the whole array by assigning to ko.components.loaders\n    ko.components['loaders'] = [];\n\n    ko.exportSymbol('components', ko.components);\n    ko.exportSymbol('components.get', ko.components.get);\n    ko.exportSymbol('components.clearCachedDefinition', ko.components.clearCachedDefinition);\n})();\n(function(undefined) {\n\n    // The default loader is responsible for two things:\n    // 1. Maintaining the default in-memory registry of component configuration objects\n    //    (i.e., the thing you're writing to when you call ko.components.register(someName, ...))\n    // 2. Answering requests for components by fetching configuration objects\n    //    from that default in-memory registry and resolving them into standard\n    //    component definition objects (of the form { createViewModel: ..., template: ... })\n    // Custom loaders may override either of these facilities, i.e.,\n    // 1. To supply configuration objects from some other source (e.g., conventions)\n    // 2. Or, to resolve configuration objects by loading viewmodels/templates via arbitrary logic.\n\n    var defaultConfigRegistry = {};\n\n    ko.components.register = function(componentName, config) {\n        if (!config) {\n            throw new Error('Invalid configuration for ' + componentName);\n        }\n\n        if (ko.components.isRegistered(componentName)) {\n            throw new Error('Component ' + componentName + ' is already registered');\n        }\n\n        defaultConfigRegistry[componentName] = config;\n    };\n\n    ko.components.isRegistered = function(componentName) {\n        return defaultConfigRegistry.hasOwnProperty(componentName);\n    };\n\n    ko.components.unregister = function(componentName) {\n        delete defaultConfigRegistry[componentName];\n        ko.components.clearCachedDefinition(componentName);\n    };\n\n    ko.components.defaultLoader = {\n        'getConfig': function(componentName, callback) {\n            var result = defaultConfigRegistry.hasOwnProperty(componentName)\n                ? defaultConfigRegistry[componentName]\n                : null;\n            callback(result);\n        },\n\n        'loadComponent': function(componentName, config, callback) {\n            var errorCallback = makeErrorCallback(componentName);\n            possiblyGetConfigFromAmd(errorCallback, config, function(loadedConfig) {\n                resolveConfig(componentName, errorCallback, loadedConfig, callback);\n            });\n        },\n\n        'loadTemplate': function(componentName, templateConfig, callback) {\n            resolveTemplate(makeErrorCallback(componentName), templateConfig, callback);\n        },\n\n        'loadViewModel': function(componentName, viewModelConfig, callback) {\n            resolveViewModel(makeErrorCallback(componentName), viewModelConfig, callback);\n        }\n    };\n\n    var createViewModelKey = 'createViewModel';\n\n    // Takes a config object of the form { template: ..., viewModel: ... }, and asynchronously convert it\n    // into the standard component definition format:\n    //    { template: <ArrayOfDomNodes>, createViewModel: function(params, componentInfo) { ... } }.\n    // Since both template and viewModel may need to be resolved asynchronously, both tasks are performed\n    // in parallel, and the results joined when both are ready. We don't depend on any promises infrastructure,\n    // so this is implemented manually below.\n    function resolveConfig(componentName, errorCallback, config, callback) {\n        var result = {},\n            makeCallBackWhenZero = 2,\n            tryIssueCallback = function() {\n                if (--makeCallBackWhenZero === 0) {\n                    callback(result);\n                }\n            },\n            templateConfig = config['template'],\n            viewModelConfig = config['viewModel'];\n\n        if (templateConfig) {\n            possiblyGetConfigFromAmd(errorCallback, templateConfig, function(loadedConfig) {\n                ko.components._getFirstResultFromLoaders('loadTemplate', [componentName, loadedConfig], function(resolvedTemplate) {\n                    result['template'] = resolvedTemplate;\n                    tryIssueCallback();\n                });\n            });\n        } else {\n            tryIssueCallback();\n        }\n\n        if (viewModelConfig) {\n            possiblyGetConfigFromAmd(errorCallback, viewModelConfig, function(loadedConfig) {\n                ko.components._getFirstResultFromLoaders('loadViewModel', [componentName, loadedConfig], function(resolvedViewModel) {\n                    result[createViewModelKey] = resolvedViewModel;\n                    tryIssueCallback();\n                });\n            });\n        } else {\n            tryIssueCallback();\n        }\n    }\n\n    function resolveTemplate(errorCallback, templateConfig, callback) {\n        if (typeof templateConfig === 'string') {\n            // Markup - parse it\n            callback(ko.utils.parseHtmlFragment(templateConfig));\n        } else if (templateConfig instanceof Array) {\n            // Assume already an array of DOM nodes - pass through unchanged\n            callback(templateConfig);\n        } else if (isDocumentFragment(templateConfig)) {\n            // Document fragment - use its child nodes\n            callback(ko.utils.makeArray(templateConfig.childNodes));\n        } else if (templateConfig['element']) {\n            var element = templateConfig['element'];\n            if (isDomElement(element)) {\n                // Element instance - copy its child nodes\n                callback(cloneNodesFromTemplateSourceElement(element));\n            } else if (typeof element === 'string') {\n                // Element ID - find it, then copy its child nodes\n                var elemInstance = document.getElementById(element);\n                if (elemInstance) {\n                    callback(cloneNodesFromTemplateSourceElement(elemInstance));\n                } else {\n                    errorCallback('Cannot find element with ID ' + element);\n                }\n            } else {\n                errorCallback('Unknown element type: ' + element);\n            }\n        } else {\n            errorCallback('Unknown template value: ' + templateConfig);\n        }\n    }\n\n    function resolveViewModel(errorCallback, viewModelConfig, callback) {\n        if (typeof viewModelConfig === 'function') {\n            // Constructor - convert to standard factory function format\n            // By design, this does *not* supply componentInfo to the constructor, as the intent is that\n            // componentInfo contains non-viewmodel data (e.g., the component's element) that should only\n            // be used in factory functions, not viewmodel constructors.\n            callback(function (params /*, componentInfo */) {\n                return new viewModelConfig(params);\n            });\n        } else if (typeof viewModelConfig[createViewModelKey] === 'function') {\n            // Already a factory function - use it as-is\n            callback(viewModelConfig[createViewModelKey]);\n        } else if ('instance' in viewModelConfig) {\n            // Fixed object instance - promote to createViewModel format for API consistency\n            var fixedInstance = viewModelConfig['instance'];\n            callback(function (params, componentInfo) {\n                return fixedInstance;\n            });\n        } else if ('viewModel' in viewModelConfig) {\n            // Resolved AMD module whose value is of the form { viewModel: ... }\n            resolveViewModel(errorCallback, viewModelConfig['viewModel'], callback);\n        } else {\n            errorCallback('Unknown viewModel value: ' + viewModelConfig);\n        }\n    }\n\n    function cloneNodesFromTemplateSourceElement(elemInstance) {\n        switch (ko.utils.tagNameLower(elemInstance)) {\n            case 'script':\n                return ko.utils.parseHtmlFragment(elemInstance.text);\n            case 'textarea':\n                return ko.utils.parseHtmlFragment(elemInstance.value);\n            case 'template':\n                // For browsers with proper <template> element support (i.e., where the .content property\n                // gives a document fragment), use that document fragment.\n                if (isDocumentFragment(elemInstance.content)) {\n                    return ko.utils.cloneNodes(elemInstance.content.childNodes);\n                }\n        }\n\n        // Regular elements such as <div>, and <template> elements on old browsers that don't really\n        // understand <template> and just treat it as a regular container\n        return ko.utils.cloneNodes(elemInstance.childNodes);\n    }\n\n    function isDomElement(obj) {\n        if (window['HTMLElement']) {\n            return obj instanceof HTMLElement;\n        } else {\n            return obj && obj.tagName && obj.nodeType === 1;\n        }\n    }\n\n    function isDocumentFragment(obj) {\n        if (window['DocumentFragment']) {\n            return obj instanceof DocumentFragment;\n        } else {\n            return obj && obj.nodeType === 11;\n        }\n    }\n\n    function possiblyGetConfigFromAmd(errorCallback, config, callback) {\n        if (typeof config['require'] === 'string') {\n            // The config is the value of an AMD module\n            if (amdRequire || window['require']) {\n                (amdRequire || window['require'])([config['require']], callback);\n            } else {\n                errorCallback('Uses require, but no AMD loader is present');\n            }\n        } else {\n            callback(config);\n        }\n    }\n\n    function makeErrorCallback(componentName) {\n        return function (message) {\n            throw new Error('Component \\'' + componentName + '\\': ' + message);\n        };\n    }\n\n    ko.exportSymbol('components.register', ko.components.register);\n    ko.exportSymbol('components.isRegistered', ko.components.isRegistered);\n    ko.exportSymbol('components.unregister', ko.components.unregister);\n\n    // Expose the default loader so that developers can directly ask it for configuration\n    // or to resolve configuration\n    ko.exportSymbol('components.defaultLoader', ko.components.defaultLoader);\n\n    // By default, the default loader is the only registered component loader\n    ko.components['loaders'].push(ko.components.defaultLoader);\n\n    // Privately expose the underlying config registry for use in old-IE shim\n    ko.components._allRegisteredComponents = defaultConfigRegistry;\n})();\n(function (undefined) {\n    // Overridable API for determining which component name applies to a given node. By overriding this,\n    // you can for example map specific tagNames to components that are not preregistered.\n    ko.components['getComponentNameForNode'] = function(node) {\n        var tagNameLower = ko.utils.tagNameLower(node);\n        if (ko.components.isRegistered(tagNameLower)) {\n            // Try to determine that this node can be considered a *custom* element; see https://github.com/knockout/knockout/issues/1603\n            if (tagNameLower.indexOf('-') != -1 || ('' + node) == \"[object HTMLUnknownElement]\" || (ko.utils.ieVersion <= 8 && node.tagName === tagNameLower)) {\n                return tagNameLower;\n            }\n        }\n    };\n\n    ko.components.addBindingsForCustomElement = function(allBindings, node, bindingContext, valueAccessors) {\n        // Determine if it's really a custom element matching a component\n        if (node.nodeType === 1) {\n            var componentName = ko.components['getComponentNameForNode'](node);\n            if (componentName) {\n                // It does represent a component, so add a component binding for it\n                allBindings = allBindings || {};\n\n                if (allBindings['component']) {\n                    // Avoid silently overwriting some other 'component' binding that may already be on the element\n                    throw new Error('Cannot use the \"component\" binding on a custom element matching a component');\n                }\n\n                var componentBindingValue = { 'name': componentName, 'params': getComponentParamsFromCustomElement(node, bindingContext) };\n\n                allBindings['component'] = valueAccessors\n                    ? function() { return componentBindingValue; }\n                    : componentBindingValue;\n            }\n        }\n\n        return allBindings;\n    }\n\n    var nativeBindingProviderInstance = new ko.bindingProvider();\n\n    function getComponentParamsFromCustomElement(elem, bindingContext) {\n        var paramsAttribute = elem.getAttribute('params');\n\n        if (paramsAttribute) {\n            var params = nativeBindingProviderInstance['parseBindingsString'](paramsAttribute, bindingContext, elem, { 'valueAccessors': true, 'bindingParams': true }),\n                rawParamComputedValues = ko.utils.objectMap(params, function(paramValue, paramName) {\n                    return ko.computed(paramValue, null, { disposeWhenNodeIsRemoved: elem });\n                }),\n                result = ko.utils.objectMap(rawParamComputedValues, function(paramValueComputed, paramName) {\n                    var paramValue = paramValueComputed.peek();\n                    // Does the evaluation of the parameter value unwrap any observables?\n                    if (!paramValueComputed.isActive()) {\n                        // No it doesn't, so there's no need for any computed wrapper. Just pass through the supplied value directly.\n                        // Example: \"someVal: firstName, age: 123\" (whether or not firstName is an observable/computed)\n                        return paramValue;\n                    } else {\n                        // Yes it does. Supply a computed property that unwraps both the outer (binding expression)\n                        // level of observability, and any inner (resulting model value) level of observability.\n                        // This means the component doesn't have to worry about multiple unwrapping. If the value is a\n                        // writable observable, the computed will also be writable and pass the value on to the observable.\n                        return ko.computed({\n                            'read': function() {\n                                return ko.utils.unwrapObservable(paramValueComputed());\n                            },\n                            'write': ko.isWriteableObservable(paramValue) && function(value) {\n                                paramValueComputed()(value);\n                            },\n                            disposeWhenNodeIsRemoved: elem\n                        });\n                    }\n                });\n\n            // Give access to the raw computeds, as long as that wouldn't overwrite any custom param also called '$raw'\n            // This is in case the developer wants to react to outer (binding) observability separately from inner\n            // (model value) observability, or in case the model value observable has subobservables.\n            if (!result.hasOwnProperty('$raw')) {\n                result['$raw'] = rawParamComputedValues;\n            }\n\n            return result;\n        } else {\n            // For consistency, absence of a \"params\" attribute is treated the same as the presence of\n            // any empty one. Otherwise component viewmodels need special code to check whether or not\n            // 'params' or 'params.$raw' is null/undefined before reading subproperties, which is annoying.\n            return { '$raw': {} };\n        }\n    }\n\n    // --------------------------------------------------------------------------------\n    // Compatibility code for older (pre-HTML5) IE browsers\n\n    if (ko.utils.ieVersion < 9) {\n        // Whenever you preregister a component, enable it as a custom element in the current document\n        ko.components['register'] = (function(originalFunction) {\n            return function(componentName) {\n                document.createElement(componentName); // Allows IE<9 to parse markup containing the custom element\n                return originalFunction.apply(this, arguments);\n            }\n        })(ko.components['register']);\n\n        // Whenever you create a document fragment, enable all preregistered component names as custom elements\n        // This is needed to make innerShiv/jQuery HTML parsing correctly handle the custom elements\n        document.createDocumentFragment = (function(originalFunction) {\n            return function() {\n                var newDocFrag = originalFunction(),\n                    allComponents = ko.components._allRegisteredComponents;\n                for (var componentName in allComponents) {\n                    if (allComponents.hasOwnProperty(componentName)) {\n                        newDocFrag.createElement(componentName);\n                    }\n                }\n                return newDocFrag;\n            };\n        })(document.createDocumentFragment);\n    }\n})();(function(undefined) {\n\n    var componentLoadingOperationUniqueId = 0;\n\n    ko.bindingHandlers['component'] = {\n        'init': function(element, valueAccessor, ignored1, ignored2, bindingContext) {\n            var currentViewModel,\n                currentLoadingOperationId,\n                disposeAssociatedComponentViewModel = function () {\n                    var currentViewModelDispose = currentViewModel && currentViewModel['dispose'];\n                    if (typeof currentViewModelDispose === 'function') {\n                        currentViewModelDispose.call(currentViewModel);\n                    }\n                    currentViewModel = null;\n                    // Any in-flight loading operation is no longer relevant, so make sure we ignore its completion\n                    currentLoadingOperationId = null;\n                },\n                originalChildNodes = ko.utils.makeArray(ko.virtualElements.childNodes(element));\n\n            ko.utils.domNodeDisposal.addDisposeCallback(element, disposeAssociatedComponentViewModel);\n\n            ko.computed(function () {\n                var value = ko.utils.unwrapObservable(valueAccessor()),\n                    componentName, componentParams;\n\n                if (typeof value === 'string') {\n                    componentName = value;\n                } else {\n                    componentName = ko.utils.unwrapObservable(value['name']);\n                    componentParams = ko.utils.unwrapObservable(value['params']);\n                }\n\n                if (!componentName) {\n                    throw new Error('No component name specified');\n                }\n\n                var loadingOperationId = currentLoadingOperationId = ++componentLoadingOperationUniqueId;\n                ko.components.get(componentName, function(componentDefinition) {\n                    // If this is not the current load operation for this element, ignore it.\n                    if (currentLoadingOperationId !== loadingOperationId) {\n                        return;\n                    }\n\n                    // Clean up previous state\n                    disposeAssociatedComponentViewModel();\n\n                    // Instantiate and bind new component. Implicitly this cleans any old DOM nodes.\n                    if (!componentDefinition) {\n                        throw new Error('Unknown component \\'' + componentName + '\\'');\n                    }\n                    cloneTemplateIntoElement(componentName, componentDefinition, element);\n                    var componentViewModel = createViewModel(componentDefinition, element, originalChildNodes, componentParams),\n                        childBindingContext = bindingContext['createChildContext'](componentViewModel, /* dataItemAlias */ undefined, function(ctx) {\n                            ctx['$component'] = componentViewModel;\n                            ctx['$componentTemplateNodes'] = originalChildNodes;\n                        });\n                    currentViewModel = componentViewModel;\n                    ko.applyBindingsToDescendants(childBindingContext, element);\n                });\n            }, null, { disposeWhenNodeIsRemoved: element });\n\n            return { 'controlsDescendantBindings': true };\n        }\n    };\n\n    ko.virtualElements.allowedBindings['component'] = true;\n\n    function cloneTemplateIntoElement(componentName, componentDefinition, element) {\n        var template = componentDefinition['template'];\n        if (!template) {\n            throw new Error('Component \\'' + componentName + '\\' has no template');\n        }\n\n        var clonedNodesArray = ko.utils.cloneNodes(template);\n        ko.virtualElements.setDomNodeChildren(element, clonedNodesArray);\n    }\n\n    function createViewModel(componentDefinition, element, originalChildNodes, componentParams) {\n        var componentViewModelFactory = componentDefinition['createViewModel'];\n        return componentViewModelFactory\n            ? componentViewModelFactory.call(componentDefinition, componentParams, { 'element': element, 'templateNodes': originalChildNodes })\n            : componentParams; // Template-only component\n    }\n\n})();\nvar attrHtmlToJavascriptMap = { 'class': 'className', 'for': 'htmlFor' };\nko.bindingHandlers['attr'] = {\n    'update': function(element, valueAccessor, allBindings) {\n        var value = ko.utils.unwrapObservable(valueAccessor()) || {};\n        ko.utils.objectForEach(value, function(attrName, attrValue) {\n            attrValue = ko.utils.unwrapObservable(attrValue);\n\n            // To cover cases like \"attr: { checked:someProp }\", we want to remove the attribute entirely\n            // when someProp is a \"no value\"-like value (strictly null, false, or undefined)\n            // (because the absence of the \"checked\" attr is how to mark an element as not checked, etc.)\n            var toRemove = (attrValue === false) || (attrValue === null) || (attrValue === undefined);\n            if (toRemove)\n                element.removeAttribute(attrName);\n\n            // In IE <= 7 and IE8 Quirks Mode, you have to use the Javascript property name instead of the\n            // HTML attribute name for certain attributes. IE8 Standards Mode supports the correct behavior,\n            // but instead of figuring out the mode, we'll just set the attribute through the Javascript\n            // property for IE <= 8.\n            if (ko.utils.ieVersion <= 8 && attrName in attrHtmlToJavascriptMap) {\n                attrName = attrHtmlToJavascriptMap[attrName];\n                if (toRemove)\n                    element.removeAttribute(attrName);\n                else\n                    element[attrName] = attrValue;\n            } else if (!toRemove) {\n                element.setAttribute(attrName, attrValue.toString());\n            }\n\n            // Treat \"name\" specially - although you can think of it as an attribute, it also needs\n            // special handling on older versions of IE (https://github.com/SteveSanderson/knockout/pull/333)\n            // Deliberately being case-sensitive here because XHTML would regard \"Name\" as a different thing\n            // entirely, and there's no strong reason to allow for such casing in HTML.\n            if (attrName === \"name\") {\n                ko.utils.setElementName(element, toRemove ? \"\" : attrValue.toString());\n            }\n        });\n    }\n};\n(function() {\n\nko.bindingHandlers['checked'] = {\n    'after': ['value', 'attr'],\n    'init': function (element, valueAccessor, allBindings) {\n        var checkedValue = ko.pureComputed(function() {\n            // Treat \"value\" like \"checkedValue\" when it is included with \"checked\" binding\n            if (allBindings['has']('checkedValue')) {\n                return ko.utils.unwrapObservable(allBindings.get('checkedValue'));\n            } else if (allBindings['has']('value')) {\n                return ko.utils.unwrapObservable(allBindings.get('value'));\n            }\n\n            return element.value;\n        });\n\n        function updateModel() {\n            // This updates the model value from the view value.\n            // It runs in response to DOM events (click) and changes in checkedValue.\n            var isChecked = element.checked,\n                elemValue = useCheckedValue ? checkedValue() : isChecked;\n\n            // When we're first setting up this computed, don't change any model state.\n            if (ko.computedContext.isInitial()) {\n                return;\n            }\n\n            // We can ignore unchecked radio buttons, because some other radio\n            // button will be getting checked, and that one can take care of updating state.\n            if (isRadio && !isChecked) {\n                return;\n            }\n\n            var modelValue = ko.dependencyDetection.ignore(valueAccessor);\n            if (valueIsArray) {\n                var writableValue = rawValueIsNonArrayObservable ? modelValue.peek() : modelValue;\n                if (oldElemValue !== elemValue) {\n                    // When we're responding to the checkedValue changing, and the element is\n                    // currently checked, replace the old elem value with the new elem value\n                    // in the model array.\n                    if (isChecked) {\n                        ko.utils.addOrRemoveItem(writableValue, elemValue, true);\n                        ko.utils.addOrRemoveItem(writableValue, oldElemValue, false);\n                    }\n\n                    oldElemValue = elemValue;\n                } else {\n                    // When we're responding to the user having checked/unchecked a checkbox,\n                    // add/remove the element value to the model array.\n                    ko.utils.addOrRemoveItem(writableValue, elemValue, isChecked);\n                }\n                if (rawValueIsNonArrayObservable && ko.isWriteableObservable(modelValue)) {\n                    modelValue(writableValue);\n                }\n            } else {\n                ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'checked', elemValue, true);\n            }\n        };\n\n        function updateView() {\n            // This updates the view value from the model value.\n            // It runs in response to changes in the bound (checked) value.\n            var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n            if (valueIsArray) {\n                // When a checkbox is bound to an array, being checked represents its value being present in that array\n                element.checked = ko.utils.arrayIndexOf(modelValue, checkedValue()) >= 0;\n            } else if (isCheckbox) {\n                // When a checkbox is bound to any other value (not an array), being checked represents the value being trueish\n                element.checked = modelValue;\n            } else {\n                // For radio buttons, being checked means that the radio button's value corresponds to the model value\n                element.checked = (checkedValue() === modelValue);\n            }\n        };\n\n        var isCheckbox = element.type == \"checkbox\",\n            isRadio = element.type == \"radio\";\n\n        // Only bind to check boxes and radio buttons\n        if (!isCheckbox && !isRadio) {\n            return;\n        }\n\n        var rawValue = valueAccessor(),\n            valueIsArray = isCheckbox && (ko.utils.unwrapObservable(rawValue) instanceof Array),\n            rawValueIsNonArrayObservable = !(valueIsArray && rawValue.push && rawValue.splice),\n            oldElemValue = valueIsArray ? checkedValue() : undefined,\n            useCheckedValue = isRadio || valueIsArray;\n\n        // IE 6 won't allow radio buttons to be selected unless they have a name\n        if (isRadio && !element.name)\n            ko.bindingHandlers['uniqueName']['init'](element, function() { return true });\n\n        // Set up two computeds to update the binding:\n\n        // The first responds to changes in the checkedValue value and to element clicks\n        ko.computed(updateModel, null, { disposeWhenNodeIsRemoved: element });\n        ko.utils.registerEventHandler(element, \"click\", updateModel);\n\n        // The second responds to changes in the model value (the one associated with the checked binding)\n        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n\n        rawValue = undefined;\n    }\n};\nko.expressionRewriting.twoWayBindings['checked'] = true;\n\nko.bindingHandlers['checkedValue'] = {\n    'update': function (element, valueAccessor) {\n        element.value = ko.utils.unwrapObservable(valueAccessor());\n    }\n};\n\n})();var classesWrittenByBindingKey = '__ko__cssValue';\nko.bindingHandlers['css'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor());\n        if (value !== null && typeof value == \"object\") {\n            ko.utils.objectForEach(value, function(className, shouldHaveClass) {\n                shouldHaveClass = ko.utils.unwrapObservable(shouldHaveClass);\n                ko.utils.toggleDomNodeCssClass(element, className, shouldHaveClass);\n            });\n        } else {\n            value = ko.utils.stringTrim(String(value || '')); // Make sure we don't try to store or set a non-string value\n            ko.utils.toggleDomNodeCssClass(element, element[classesWrittenByBindingKey], false);\n            element[classesWrittenByBindingKey] = value;\n            ko.utils.toggleDomNodeCssClass(element, value, true);\n        }\n    }\n};\nko.bindingHandlers['enable'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor());\n        if (value && element.disabled)\n            element.removeAttribute(\"disabled\");\n        else if ((!value) && (!element.disabled))\n            element.disabled = true;\n    }\n};\n\nko.bindingHandlers['disable'] = {\n    'update': function (element, valueAccessor) {\n        ko.bindingHandlers['enable']['update'](element, function() { return !ko.utils.unwrapObservable(valueAccessor()) });\n    }\n};\n// For certain common events (currently just 'click'), allow a simplified data-binding syntax\n// e.g. click:handler instead of the usual full-length event:{click:handler}\nfunction makeEventHandlerShortcut(eventName) {\n    ko.bindingHandlers[eventName] = {\n        'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n            var newValueAccessor = function () {\n                var result = {};\n                result[eventName] = valueAccessor();\n                return result;\n            };\n            return ko.bindingHandlers['event']['init'].call(this, element, newValueAccessor, allBindings, viewModel, bindingContext);\n        }\n    }\n}\n\nko.bindingHandlers['event'] = {\n    'init' : function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n        var eventsToHandle = valueAccessor() || {};\n        ko.utils.objectForEach(eventsToHandle, function(eventName) {\n            if (typeof eventName == \"string\") {\n                ko.utils.registerEventHandler(element, eventName, function (event) {\n                    var handlerReturnValue;\n                    var handlerFunction = valueAccessor()[eventName];\n                    if (!handlerFunction)\n                        return;\n\n                    try {\n                        // Take all the event args, and prefix with the viewmodel\n                        var argsForHandler = ko.utils.makeArray(arguments);\n                        viewModel = bindingContext['$data'];\n                        argsForHandler.unshift(viewModel);\n                        handlerReturnValue = handlerFunction.apply(viewModel, argsForHandler);\n                    } finally {\n                        if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                            if (event.preventDefault)\n                                event.preventDefault();\n                            else\n                                event.returnValue = false;\n                        }\n                    }\n\n                    var bubble = allBindings.get(eventName + 'Bubble') !== false;\n                    if (!bubble) {\n                        event.cancelBubble = true;\n                        if (event.stopPropagation)\n                            event.stopPropagation();\n                    }\n                });\n            }\n        });\n    }\n};\n// \"foreach: someExpression\" is equivalent to \"template: { foreach: someExpression }\"\n// \"foreach: { data: someExpression, afterAdd: myfn }\" is equivalent to \"template: { foreach: someExpression, afterAdd: myfn }\"\nko.bindingHandlers['foreach'] = {\n    makeTemplateValueAccessor: function(valueAccessor) {\n        return function() {\n            var modelValue = valueAccessor(),\n                unwrappedValue = ko.utils.peekObservable(modelValue);    // Unwrap without setting a dependency here\n\n            // If unwrappedValue is the array, pass in the wrapped value on its own\n            // The value will be unwrapped and tracked within the template binding\n            // (See https://github.com/SteveSanderson/knockout/issues/523)\n            if ((!unwrappedValue) || typeof unwrappedValue.length == \"number\")\n                return { 'foreach': modelValue, 'templateEngine': ko.nativeTemplateEngine.instance };\n\n            // If unwrappedValue.data is the array, preserve all relevant options and unwrap again value so we get updates\n            ko.utils.unwrapObservable(modelValue);\n            return {\n                'foreach': unwrappedValue['data'],\n                'as': unwrappedValue['as'],\n                'includeDestroyed': unwrappedValue['includeDestroyed'],\n                'afterAdd': unwrappedValue['afterAdd'],\n                'beforeRemove': unwrappedValue['beforeRemove'],\n                'afterRender': unwrappedValue['afterRender'],\n                'beforeMove': unwrappedValue['beforeMove'],\n                'afterMove': unwrappedValue['afterMove'],\n                'templateEngine': ko.nativeTemplateEngine.instance\n            };\n        };\n    },\n    'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n        return ko.bindingHandlers['template']['init'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor));\n    },\n    'update': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n        return ko.bindingHandlers['template']['update'](element, ko.bindingHandlers['foreach'].makeTemplateValueAccessor(valueAccessor), allBindings, viewModel, bindingContext);\n    }\n};\nko.expressionRewriting.bindingRewriteValidators['foreach'] = false; // Can't rewrite control flow bindings\nko.virtualElements.allowedBindings['foreach'] = true;\nvar hasfocusUpdatingProperty = '__ko_hasfocusUpdating';\nvar hasfocusLastValue = '__ko_hasfocusLastValue';\nko.bindingHandlers['hasfocus'] = {\n    'init': function(element, valueAccessor, allBindings) {\n        var handleElementFocusChange = function(isFocused) {\n            // Where possible, ignore which event was raised and determine focus state using activeElement,\n            // as this avoids phantom focus/blur events raised when changing tabs in modern browsers.\n            // However, not all KO-targeted browsers (Firefox 2) support activeElement. For those browsers,\n            // prevent a loss of focus when changing tabs/windows by setting a flag that prevents hasfocus\n            // from calling 'blur()' on the element when it loses focus.\n            // Discussion at https://github.com/SteveSanderson/knockout/pull/352\n            element[hasfocusUpdatingProperty] = true;\n            var ownerDoc = element.ownerDocument;\n            if (\"activeElement\" in ownerDoc) {\n                var active;\n                try {\n                    active = ownerDoc.activeElement;\n                } catch(e) {\n                    // IE9 throws if you access activeElement during page load (see issue #703)\n                    active = ownerDoc.body;\n                }\n                isFocused = (active === element);\n            }\n            var modelValue = valueAccessor();\n            ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'hasfocus', isFocused, true);\n\n            //cache the latest value, so we can avoid unnecessarily calling focus/blur in the update function\n            element[hasfocusLastValue] = isFocused;\n            element[hasfocusUpdatingProperty] = false;\n        };\n        var handleElementFocusIn = handleElementFocusChange.bind(null, true);\n        var handleElementFocusOut = handleElementFocusChange.bind(null, false);\n\n        ko.utils.registerEventHandler(element, \"focus\", handleElementFocusIn);\n        ko.utils.registerEventHandler(element, \"focusin\", handleElementFocusIn); // For IE\n        ko.utils.registerEventHandler(element, \"blur\",  handleElementFocusOut);\n        ko.utils.registerEventHandler(element, \"focusout\",  handleElementFocusOut); // For IE\n    },\n    'update': function(element, valueAccessor) {\n        var value = !!ko.utils.unwrapObservable(valueAccessor());\n\n        if (!element[hasfocusUpdatingProperty] && element[hasfocusLastValue] !== value) {\n            value ? element.focus() : element.blur();\n\n            // In IE, the blur method doesn't always cause the element to lose focus (for example, if the window is not in focus).\n            // Setting focus to the body element does seem to be reliable in IE, but should only be used if we know that the current\n            // element was focused already.\n            if (!value && element[hasfocusLastValue]) {\n                element.ownerDocument.body.focus();\n            }\n\n            // For IE, which doesn't reliably fire \"focus\" or \"blur\" events synchronously\n            ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, value ? \"focusin\" : \"focusout\"]);\n        }\n    }\n};\nko.expressionRewriting.twoWayBindings['hasfocus'] = true;\n\nko.bindingHandlers['hasFocus'] = ko.bindingHandlers['hasfocus']; // Make \"hasFocus\" an alias\nko.expressionRewriting.twoWayBindings['hasFocus'] = true;\nko.bindingHandlers['html'] = {\n    'init': function() {\n        // Prevent binding on the dynamically-injected HTML (as developers are unlikely to expect that, and it has security implications)\n        return { 'controlsDescendantBindings': true };\n    },\n    'update': function (element, valueAccessor) {\n        // setHtml will unwrap the value if needed\n        ko.utils.setHtml(element, valueAccessor());\n    }\n};\n// Makes a binding like with or if\nfunction makeWithIfBinding(bindingKey, isWith, isNot, makeContextCallback) {\n    ko.bindingHandlers[bindingKey] = {\n        'init': function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n            var didDisplayOnLastUpdate,\n                savedNodes;\n            ko.computed(function() {\n                var rawValue = valueAccessor(),\n                    dataValue = ko.utils.unwrapObservable(rawValue),\n                    shouldDisplay = !isNot !== !dataValue, // equivalent to isNot ? !dataValue : !!dataValue\n                    isFirstRender = !savedNodes,\n                    needsRefresh = isFirstRender || isWith || (shouldDisplay !== didDisplayOnLastUpdate);\n\n                if (needsRefresh) {\n                    // Save a copy of the inner nodes on the initial update, but only if we have dependencies.\n                    if (isFirstRender && ko.computedContext.getDependenciesCount()) {\n                        savedNodes = ko.utils.cloneNodes(ko.virtualElements.childNodes(element), true /* shouldCleanNodes */);\n                    }\n\n                    if (shouldDisplay) {\n                        if (!isFirstRender) {\n                            ko.virtualElements.setDomNodeChildren(element, ko.utils.cloneNodes(savedNodes));\n                        }\n                        ko.applyBindingsToDescendants(makeContextCallback ? makeContextCallback(bindingContext, rawValue) : bindingContext, element);\n                    } else {\n                        ko.virtualElements.emptyNode(element);\n                    }\n\n                    didDisplayOnLastUpdate = shouldDisplay;\n                }\n            }, null, { disposeWhenNodeIsRemoved: element });\n            return { 'controlsDescendantBindings': true };\n        }\n    };\n    ko.expressionRewriting.bindingRewriteValidators[bindingKey] = false; // Can't rewrite control flow bindings\n    ko.virtualElements.allowedBindings[bindingKey] = true;\n}\n\n// Construct the actual binding handlers\nmakeWithIfBinding('if');\nmakeWithIfBinding('ifnot', false /* isWith */, true /* isNot */);\nmakeWithIfBinding('with', true /* isWith */, false /* isNot */,\n    function(bindingContext, dataValue) {\n        return bindingContext.createStaticChildContext(dataValue);\n    }\n);\nvar captionPlaceholder = {};\nko.bindingHandlers['options'] = {\n    'init': function(element) {\n        if (ko.utils.tagNameLower(element) !== \"select\")\n            throw new Error(\"options binding applies only to SELECT elements\");\n\n        // Remove all existing <option>s.\n        while (element.length > 0) {\n            element.remove(0);\n        }\n\n        // Ensures that the binding processor doesn't try to bind the options\n        return { 'controlsDescendantBindings': true };\n    },\n    'update': function (element, valueAccessor, allBindings) {\n        function selectedOptions() {\n            return ko.utils.arrayFilter(element.options, function (node) { return node.selected; });\n        }\n\n        var selectWasPreviouslyEmpty = element.length == 0,\n            multiple = element.multiple,\n            previousScrollTop = (!selectWasPreviouslyEmpty && multiple) ? element.scrollTop : null,\n            unwrappedArray = ko.utils.unwrapObservable(valueAccessor()),\n            valueAllowUnset = allBindings.get('valueAllowUnset') && allBindings['has']('value'),\n            includeDestroyed = allBindings.get('optionsIncludeDestroyed'),\n            arrayToDomNodeChildrenOptions = {},\n            captionValue,\n            filteredArray,\n            previousSelectedValues = [];\n\n        if (!valueAllowUnset) {\n            if (multiple) {\n                previousSelectedValues = ko.utils.arrayMap(selectedOptions(), ko.selectExtensions.readValue);\n            } else if (element.selectedIndex >= 0) {\n                previousSelectedValues.push(ko.selectExtensions.readValue(element.options[element.selectedIndex]));\n            }\n        }\n\n        if (unwrappedArray) {\n            if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                unwrappedArray = [unwrappedArray];\n\n            // Filter out any entries marked as destroyed\n            filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                return includeDestroyed || item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n            });\n\n            // If caption is included, add it to the array\n            if (allBindings['has']('optionsCaption')) {\n                captionValue = ko.utils.unwrapObservable(allBindings.get('optionsCaption'));\n                // If caption value is null or undefined, don't show a caption\n                if (captionValue !== null && captionValue !== undefined) {\n                    filteredArray.unshift(captionPlaceholder);\n                }\n            }\n        } else {\n            // If a falsy value is provided (e.g. null), we'll simply empty the select element\n        }\n\n        function applyToObject(object, predicate, defaultValue) {\n            var predicateType = typeof predicate;\n            if (predicateType == \"function\")    // Given a function; run it against the data value\n                return predicate(object);\n            else if (predicateType == \"string\") // Given a string; treat it as a property name on the data value\n                return object[predicate];\n            else                                // Given no optionsText arg; use the data value itself\n                return defaultValue;\n        }\n\n        // The following functions can run at two different times:\n        // The first is when the whole array is being updated directly from this binding handler.\n        // The second is when an observable value for a specific array entry is updated.\n        // oldOptions will be empty in the first case, but will be filled with the previously generated option in the second.\n        var itemUpdate = false;\n        function optionForArrayItem(arrayEntry, index, oldOptions) {\n            if (oldOptions.length) {\n                previousSelectedValues = !valueAllowUnset && oldOptions[0].selected ? [ ko.selectExtensions.readValue(oldOptions[0]) ] : [];\n                itemUpdate = true;\n            }\n            var option = element.ownerDocument.createElement(\"option\");\n            if (arrayEntry === captionPlaceholder) {\n                ko.utils.setTextContent(option, allBindings.get('optionsCaption'));\n                ko.selectExtensions.writeValue(option, undefined);\n            } else {\n                // Apply a value to the option element\n                var optionValue = applyToObject(arrayEntry, allBindings.get('optionsValue'), arrayEntry);\n                ko.selectExtensions.writeValue(option, ko.utils.unwrapObservable(optionValue));\n\n                // Apply some text to the option element\n                var optionText = applyToObject(arrayEntry, allBindings.get('optionsText'), optionValue);\n                ko.utils.setTextContent(option, optionText);\n            }\n            return [option];\n        }\n\n        // By using a beforeRemove callback, we delay the removal until after new items are added. This fixes a selection\n        // problem in IE<=8 and Firefox. See https://github.com/knockout/knockout/issues/1208\n        arrayToDomNodeChildrenOptions['beforeRemove'] =\n            function (option) {\n                element.removeChild(option);\n            };\n\n        function setSelectionCallback(arrayEntry, newOptions) {\n            if (itemUpdate && valueAllowUnset) {\n                // The model value is authoritative, so make sure its value is the one selected\n                // There is no need to use dependencyDetection.ignore since setDomNodeChildrenFromArrayMapping does so already.\n                ko.selectExtensions.writeValue(element, ko.utils.unwrapObservable(allBindings.get('value')), true /* allowUnset */);\n            } else if (previousSelectedValues.length) {\n                // IE6 doesn't like us to assign selection to OPTION nodes before they're added to the document.\n                // That's why we first added them without selection. Now it's time to set the selection.\n                var isSelected = ko.utils.arrayIndexOf(previousSelectedValues, ko.selectExtensions.readValue(newOptions[0])) >= 0;\n                ko.utils.setOptionNodeSelectionState(newOptions[0], isSelected);\n\n                // If this option was changed from being selected during a single-item update, notify the change\n                if (itemUpdate && !isSelected) {\n                    ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                }\n            }\n        }\n\n        var callback = setSelectionCallback;\n        if (allBindings['has']('optionsAfterRender') && typeof allBindings.get('optionsAfterRender') == \"function\") {\n            callback = function(arrayEntry, newOptions) {\n                setSelectionCallback(arrayEntry, newOptions);\n                ko.dependencyDetection.ignore(allBindings.get('optionsAfterRender'), null, [newOptions[0], arrayEntry !== captionPlaceholder ? arrayEntry : undefined]);\n            }\n        }\n\n        ko.utils.setDomNodeChildrenFromArrayMapping(element, filteredArray, optionForArrayItem, arrayToDomNodeChildrenOptions, callback);\n\n        ko.dependencyDetection.ignore(function () {\n            if (valueAllowUnset) {\n                // The model value is authoritative, so make sure its value is the one selected\n                ko.selectExtensions.writeValue(element, ko.utils.unwrapObservable(allBindings.get('value')), true /* allowUnset */);\n            } else {\n                // Determine if the selection has changed as a result of updating the options list\n                var selectionChanged;\n                if (multiple) {\n                    // For a multiple-select box, compare the new selection count to the previous one\n                    // But if nothing was selected before, the selection can't have changed\n                    selectionChanged = previousSelectedValues.length && selectedOptions().length < previousSelectedValues.length;\n                } else {\n                    // For a single-select box, compare the current value to the previous value\n                    // But if nothing was selected before or nothing is selected now, just look for a change in selection\n                    selectionChanged = (previousSelectedValues.length && element.selectedIndex >= 0)\n                        ? (ko.selectExtensions.readValue(element.options[element.selectedIndex]) !== previousSelectedValues[0])\n                        : (previousSelectedValues.length || element.selectedIndex >= 0);\n                }\n\n                // Ensure consistency between model value and selected option.\n                // If the dropdown was changed so that selection is no longer the same,\n                // notify the value or selectedOptions binding.\n                if (selectionChanged) {\n                    ko.utils.triggerEvent(element, \"change\");\n                }\n            }\n        });\n\n        // Workaround for IE bug\n        ko.utils.ensureSelectElementIsRenderedCorrectly(element);\n\n        if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20)\n            element.scrollTop = previousScrollTop;\n    }\n};\nko.bindingHandlers['options'].optionValueDomDataKey = ko.utils.domData.nextKey();\nko.bindingHandlers['selectedOptions'] = {\n    'after': ['options', 'foreach'],\n    'init': function (element, valueAccessor, allBindings) {\n        ko.utils.registerEventHandler(element, \"change\", function () {\n            var value = valueAccessor(), valueToWrite = [];\n            ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                if (node.selected)\n                    valueToWrite.push(ko.selectExtensions.readValue(node));\n            });\n            ko.expressionRewriting.writeValueToProperty(value, allBindings, 'selectedOptions', valueToWrite);\n        });\n    },\n    'update': function (element, valueAccessor) {\n        if (ko.utils.tagNameLower(element) != \"select\")\n            throw new Error(\"values binding applies only to SELECT elements\");\n\n        var newValue = ko.utils.unwrapObservable(valueAccessor()),\n            previousScrollTop = element.scrollTop;\n\n        if (newValue && typeof newValue.length == \"number\") {\n            ko.utils.arrayForEach(element.getElementsByTagName(\"option\"), function(node) {\n                var isSelected = ko.utils.arrayIndexOf(newValue, ko.selectExtensions.readValue(node)) >= 0;\n                if (node.selected != isSelected) {      // This check prevents flashing of the select element in IE\n                    ko.utils.setOptionNodeSelectionState(node, isSelected);\n                }\n            });\n        }\n\n        element.scrollTop = previousScrollTop;\n    }\n};\nko.expressionRewriting.twoWayBindings['selectedOptions'] = true;\nko.bindingHandlers['style'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor() || {});\n        ko.utils.objectForEach(value, function(styleName, styleValue) {\n            styleValue = ko.utils.unwrapObservable(styleValue);\n\n            if (styleValue === null || styleValue === undefined || styleValue === false) {\n                // Empty string removes the value, whereas null/undefined have no effect\n                styleValue = \"\";\n            }\n\n            element.style[styleName] = styleValue;\n        });\n    }\n};\nko.bindingHandlers['submit'] = {\n    'init': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n        if (typeof valueAccessor() != \"function\")\n            throw new Error(\"The value for a submit binding must be a function\");\n        ko.utils.registerEventHandler(element, \"submit\", function (event) {\n            var handlerReturnValue;\n            var value = valueAccessor();\n            try { handlerReturnValue = value.call(bindingContext['$data'], element); }\n            finally {\n                if (handlerReturnValue !== true) { // Normally we want to prevent default action. Developer can override this be explicitly returning true.\n                    if (event.preventDefault)\n                        event.preventDefault();\n                    else\n                        event.returnValue = false;\n                }\n            }\n        });\n    }\n};\nko.bindingHandlers['text'] = {\n    'init': function() {\n        // Prevent binding on the dynamically-injected text node (as developers are unlikely to expect that, and it has security implications).\n        // It should also make things faster, as we no longer have to consider whether the text node might be bindable.\n        return { 'controlsDescendantBindings': true };\n    },\n    'update': function (element, valueAccessor) {\n        ko.utils.setTextContent(element, valueAccessor());\n    }\n};\nko.virtualElements.allowedBindings['text'] = true;\n(function () {\n\nif (window && window.navigator) {\n    var parseVersion = function (matches) {\n        if (matches) {\n            return parseFloat(matches[1]);\n        }\n    };\n\n    // Detect various browser versions because some old versions don't fully support the 'input' event\n    var operaVersion = window.opera && window.opera.version && parseInt(window.opera.version()),\n        userAgent = window.navigator.userAgent,\n        safariVersion = parseVersion(userAgent.match(/^(?:(?!chrome).)*version\\/([^ ]*) safari/i)),\n        firefoxVersion = parseVersion(userAgent.match(/Firefox\\/([^ ]*)/));\n}\n\n// IE 8 and 9 have bugs that prevent the normal events from firing when the value changes.\n// But it does fire the 'selectionchange' event on many of those, presumably because the\n// cursor is moving and that counts as the selection changing. The 'selectionchange' event is\n// fired at the document level only and doesn't directly indicate which element changed. We\n// set up just one event handler for the document and use 'activeElement' to determine which\n// element was changed.\nif (ko.utils.ieVersion < 10) {\n    var selectionChangeRegisteredName = ko.utils.domData.nextKey(),\n        selectionChangeHandlerName = ko.utils.domData.nextKey();\n    var selectionChangeHandler = function(event) {\n        var target = this.activeElement,\n            handler = target && ko.utils.domData.get(target, selectionChangeHandlerName);\n        if (handler) {\n            handler(event);\n        }\n    };\n    var registerForSelectionChangeEvent = function (element, handler) {\n        var ownerDoc = element.ownerDocument;\n        if (!ko.utils.domData.get(ownerDoc, selectionChangeRegisteredName)) {\n            ko.utils.domData.set(ownerDoc, selectionChangeRegisteredName, true);\n            ko.utils.registerEventHandler(ownerDoc, 'selectionchange', selectionChangeHandler);\n        }\n        ko.utils.domData.set(element, selectionChangeHandlerName, handler);\n    };\n}\n\nko.bindingHandlers['textInput'] = {\n    'init': function (element, valueAccessor, allBindings) {\n\n        var previousElementValue = element.value,\n            timeoutHandle,\n            elementValueBeforeEvent;\n\n        var updateModel = function (event) {\n            clearTimeout(timeoutHandle);\n            elementValueBeforeEvent = timeoutHandle = undefined;\n\n            var elementValue = element.value;\n            if (previousElementValue !== elementValue) {\n                // Provide a way for tests to know exactly which event was processed\n                if (DEBUG && event) element['_ko_textInputProcessedEvent'] = event.type;\n                previousElementValue = elementValue;\n                ko.expressionRewriting.writeValueToProperty(valueAccessor(), allBindings, 'textInput', elementValue);\n            }\n        };\n\n        var deferUpdateModel = function (event) {\n            if (!timeoutHandle) {\n                // The elementValueBeforeEvent variable is set *only* during the brief gap between an\n                // event firing and the updateModel function running. This allows us to ignore model\n                // updates that are from the previous state of the element, usually due to techniques\n                // such as rateLimit. Such updates, if not ignored, can cause keystrokes to be lost.\n                elementValueBeforeEvent = element.value;\n                var handler = DEBUG ? updateModel.bind(element, {type: event.type}) : updateModel;\n                timeoutHandle = ko.utils.setTimeout(handler, 4);\n            }\n        };\n\n        // IE9 will mess up the DOM if you handle events synchronously which results in DOM changes (such as other bindings);\n        // so we'll make sure all updates are asynchronous\n        var ieUpdateModel = ko.utils.ieVersion == 9 ? deferUpdateModel : updateModel;\n\n        var updateView = function () {\n            var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n            if (modelValue === null || modelValue === undefined) {\n                modelValue = '';\n            }\n\n            if (elementValueBeforeEvent !== undefined && modelValue === elementValueBeforeEvent) {\n                ko.utils.setTimeout(updateView, 4);\n                return;\n            }\n\n            // Update the element only if the element and model are different. On some browsers, updating the value\n            // will move the cursor to the end of the input, which would be bad while the user is typing.\n            if (element.value !== modelValue) {\n                previousElementValue = modelValue;  // Make sure we ignore events (propertychange) that result from updating the value\n                element.value = modelValue;\n            }\n        };\n\n        var onEvent = function (event, handler) {\n            ko.utils.registerEventHandler(element, event, handler);\n        };\n\n        if (DEBUG && ko.bindingHandlers['textInput']['_forceUpdateOn']) {\n            // Provide a way for tests to specify exactly which events are bound\n            ko.utils.arrayForEach(ko.bindingHandlers['textInput']['_forceUpdateOn'], function(eventName) {\n                if (eventName.slice(0,5) == 'after') {\n                    onEvent(eventName.slice(5), deferUpdateModel);\n                } else {\n                    onEvent(eventName, updateModel);\n                }\n            });\n        } else {\n            if (ko.utils.ieVersion < 10) {\n                // Internet Explorer <= 8 doesn't support the 'input' event, but does include 'propertychange' that fires whenever\n                // any property of an element changes. Unlike 'input', it also fires if a property is changed from JavaScript code,\n                // but that's an acceptable compromise for this binding. IE 9 does support 'input', but since it doesn't fire it\n                // when using autocomplete, we'll use 'propertychange' for it also.\n                onEvent('propertychange', function(event) {\n                    if (event.propertyName === 'value') {\n                        ieUpdateModel(event);\n                    }\n                });\n\n                if (ko.utils.ieVersion == 8) {\n                    // IE 8 has a bug where it fails to fire 'propertychange' on the first update following a value change from\n                    // JavaScript code. It also doesn't fire if you clear the entire value. To fix this, we bind to the following\n                    // events too.\n                    onEvent('keyup', updateModel);      // A single keystoke\n                    onEvent('keydown', updateModel);    // The first character when a key is held down\n                }\n                if (ko.utils.ieVersion >= 8) {\n                    // Internet Explorer 9 doesn't fire the 'input' event when deleting text, including using\n                    // the backspace, delete, or ctrl-x keys, clicking the 'x' to clear the input, dragging text\n                    // out of the field, and cutting or deleting text using the context menu. 'selectionchange'\n                    // can detect all of those except dragging text out of the field, for which we use 'dragend'.\n                    // These are also needed in IE8 because of the bug described above.\n                    registerForSelectionChangeEvent(element, ieUpdateModel);  // 'selectionchange' covers cut, paste, drop, delete, etc.\n                    onEvent('dragend', deferUpdateModel);\n                }\n            } else {\n                // All other supported browsers support the 'input' event, which fires whenever the content of the element is changed\n                // through the user interface.\n                onEvent('input', updateModel);\n\n                if (safariVersion < 5 && ko.utils.tagNameLower(element) === \"textarea\") {\n                    // Safari <5 doesn't fire the 'input' event for <textarea> elements (it does fire 'textInput'\n                    // but only when typing). So we'll just catch as much as we can with keydown, cut, and paste.\n                    onEvent('keydown', deferUpdateModel);\n                    onEvent('paste', deferUpdateModel);\n                    onEvent('cut', deferUpdateModel);\n                } else if (operaVersion < 11) {\n                    // Opera 10 doesn't always fire the 'input' event for cut, paste, undo & drop operations.\n                    // We can try to catch some of those using 'keydown'.\n                    onEvent('keydown', deferUpdateModel);\n                } else if (firefoxVersion < 4.0) {\n                    // Firefox <= 3.6 doesn't fire the 'input' event when text is filled in through autocomplete\n                    onEvent('DOMAutoComplete', updateModel);\n\n                    // Firefox <=3.5 doesn't fire the 'input' event when text is dropped into the input.\n                    onEvent('dragdrop', updateModel);       // <3.5\n                    onEvent('drop', updateModel);           // 3.5\n                }\n            }\n        }\n\n        // Bind to the change event so that we can catch programmatic updates of the value that fire this event.\n        onEvent('change', updateModel);\n\n        ko.computed(updateView, null, { disposeWhenNodeIsRemoved: element });\n    }\n};\nko.expressionRewriting.twoWayBindings['textInput'] = true;\n\n// textinput is an alias for textInput\nko.bindingHandlers['textinput'] = {\n    // preprocess is the only way to set up a full alias\n    'preprocess': function (value, name, addBinding) {\n        addBinding('textInput', value);\n    }\n};\n\n})();ko.bindingHandlers['uniqueName'] = {\n    'init': function (element, valueAccessor) {\n        if (valueAccessor()) {\n            var name = \"ko_unique_\" + (++ko.bindingHandlers['uniqueName'].currentIndex);\n            ko.utils.setElementName(element, name);\n        }\n    }\n};\nko.bindingHandlers['uniqueName'].currentIndex = 0;\nko.bindingHandlers['value'] = {\n    'after': ['options', 'foreach'],\n    'init': function (element, valueAccessor, allBindings) {\n        // If the value binding is placed on a radio/checkbox, then just pass through to checkedValue and quit\n        if (element.tagName.toLowerCase() == \"input\" && (element.type == \"checkbox\" || element.type == \"radio\")) {\n            ko.applyBindingAccessorsToNode(element, { 'checkedValue': valueAccessor });\n            return;\n        }\n\n        // Always catch \"change\" event; possibly other events too if asked\n        var eventsToCatch = [\"change\"];\n        var requestedEventsToCatch = allBindings.get(\"valueUpdate\");\n        var propertyChangedFired = false;\n        var elementValueBeforeEvent = null;\n\n        if (requestedEventsToCatch) {\n            if (typeof requestedEventsToCatch == \"string\") // Allow both individual event names, and arrays of event names\n                requestedEventsToCatch = [requestedEventsToCatch];\n            ko.utils.arrayPushAll(eventsToCatch, requestedEventsToCatch);\n            eventsToCatch = ko.utils.arrayGetDistinctValues(eventsToCatch);\n        }\n\n        var valueUpdateHandler = function() {\n            elementValueBeforeEvent = null;\n            propertyChangedFired = false;\n            var modelValue = valueAccessor();\n            var elementValue = ko.selectExtensions.readValue(element);\n            ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'value', elementValue);\n        }\n\n        // Workaround for https://github.com/SteveSanderson/knockout/issues/122\n        // IE doesn't fire \"change\" events on textboxes if the user selects a value from its autocomplete list\n        var ieAutoCompleteHackNeeded = ko.utils.ieVersion && element.tagName.toLowerCase() == \"input\" && element.type == \"text\"\n                                       && element.autocomplete != \"off\" && (!element.form || element.form.autocomplete != \"off\");\n        if (ieAutoCompleteHackNeeded && ko.utils.arrayIndexOf(eventsToCatch, \"propertychange\") == -1) {\n            ko.utils.registerEventHandler(element, \"propertychange\", function () { propertyChangedFired = true });\n            ko.utils.registerEventHandler(element, \"focus\", function () { propertyChangedFired = false });\n            ko.utils.registerEventHandler(element, \"blur\", function() {\n                if (propertyChangedFired) {\n                    valueUpdateHandler();\n                }\n            });\n        }\n\n        ko.utils.arrayForEach(eventsToCatch, function(eventName) {\n            // The syntax \"after<eventname>\" means \"run the handler asynchronously after the event\"\n            // This is useful, for example, to catch \"keydown\" events after the browser has updated the control\n            // (otherwise, ko.selectExtensions.readValue(this) will receive the control's value *before* the key event)\n            var handler = valueUpdateHandler;\n            if (ko.utils.stringStartsWith(eventName, \"after\")) {\n                handler = function() {\n                    // The elementValueBeforeEvent variable is non-null *only* during the brief gap between\n                    // a keyX event firing and the valueUpdateHandler running, which is scheduled to happen\n                    // at the earliest asynchronous opportunity. We store this temporary information so that\n                    // if, between keyX and valueUpdateHandler, the underlying model value changes separately,\n                    // we can overwrite that model value change with the value the user just typed. Otherwise,\n                    // techniques like rateLimit can trigger model changes at critical moments that will\n                    // override the user's inputs, causing keystrokes to be lost.\n                    elementValueBeforeEvent = ko.selectExtensions.readValue(element);\n                    ko.utils.setTimeout(valueUpdateHandler, 0);\n                };\n                eventName = eventName.substring(\"after\".length);\n            }\n            ko.utils.registerEventHandler(element, eventName, handler);\n        });\n\n        var updateFromModel = function () {\n            var newValue = ko.utils.unwrapObservable(valueAccessor());\n            var elementValue = ko.selectExtensions.readValue(element);\n\n            if (elementValueBeforeEvent !== null && newValue === elementValueBeforeEvent) {\n                ko.utils.setTimeout(updateFromModel, 0);\n                return;\n            }\n\n            var valueHasChanged = (newValue !== elementValue);\n\n            if (valueHasChanged) {\n                if (ko.utils.tagNameLower(element) === \"select\") {\n                    var allowUnset = allBindings.get('valueAllowUnset');\n                    var applyValueAction = function () {\n                        ko.selectExtensions.writeValue(element, newValue, allowUnset);\n                    };\n                    applyValueAction();\n\n                    if (!allowUnset && newValue !== ko.selectExtensions.readValue(element)) {\n                        // If you try to set a model value that can't be represented in an already-populated dropdown, reject that change,\n                        // because you're not allowed to have a model value that disagrees with a visible UI selection.\n                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, \"change\"]);\n                    } else {\n                        // Workaround for IE6 bug: It won't reliably apply values to SELECT nodes during the same execution thread\n                        // right after you've changed the set of OPTION nodes on it. So for that node type, we'll schedule a second thread\n                        // to apply the value as well.\n                        ko.utils.setTimeout(applyValueAction, 0);\n                    }\n                } else {\n                    ko.selectExtensions.writeValue(element, newValue);\n                }\n            }\n        };\n\n        ko.computed(updateFromModel, null, { disposeWhenNodeIsRemoved: element });\n    },\n    'update': function() {} // Keep for backwards compatibility with code that may have wrapped value binding\n};\nko.expressionRewriting.twoWayBindings['value'] = true;\nko.bindingHandlers['visible'] = {\n    'update': function (element, valueAccessor) {\n        var value = ko.utils.unwrapObservable(valueAccessor());\n        var isCurrentlyVisible = !(element.style.display == \"none\");\n        if (value && !isCurrentlyVisible)\n            element.style.display = \"\";\n        else if ((!value) && isCurrentlyVisible)\n            element.style.display = \"none\";\n    }\n};\n// 'click' is just a shorthand for the usual full-length event:{click:handler}\nmakeEventHandlerShortcut('click');\n// If you want to make a custom template engine,\n//\n// [1] Inherit from this class (like ko.nativeTemplateEngine does)\n// [2] Override 'renderTemplateSource', supplying a function with this signature:\n//\n//        function (templateSource, bindingContext, options) {\n//            // - templateSource.text() is the text of the template you should render\n//            // - bindingContext.$data is the data you should pass into the template\n//            //   - you might also want to make bindingContext.$parent, bindingContext.$parents,\n//            //     and bindingContext.$root available in the template too\n//            // - options gives you access to any other properties set on \"data-bind: { template: options }\"\n//            // - templateDocument is the document object of the template\n//            //\n//            // Return value: an array of DOM nodes\n//        }\n//\n// [3] Override 'createJavaScriptEvaluatorBlock', supplying a function with this signature:\n//\n//        function (script) {\n//            // Return value: Whatever syntax means \"Evaluate the JavaScript statement 'script' and output the result\"\n//            //               For example, the jquery.tmpl template engine converts 'someScript' to '${ someScript }'\n//        }\n//\n//     This is only necessary if you want to allow data-bind attributes to reference arbitrary template variables.\n//     If you don't want to allow that, you can set the property 'allowTemplateRewriting' to false (like ko.nativeTemplateEngine does)\n//     and then you don't need to override 'createJavaScriptEvaluatorBlock'.\n\nko.templateEngine = function () { };\n\nko.templateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n    throw new Error(\"Override renderTemplateSource\");\n};\n\nko.templateEngine.prototype['createJavaScriptEvaluatorBlock'] = function (script) {\n    throw new Error(\"Override createJavaScriptEvaluatorBlock\");\n};\n\nko.templateEngine.prototype['makeTemplateSource'] = function(template, templateDocument) {\n    // Named template\n    if (typeof template == \"string\") {\n        templateDocument = templateDocument || document;\n        var elem = templateDocument.getElementById(template);\n        if (!elem)\n            throw new Error(\"Cannot find template with ID \" + template);\n        return new ko.templateSources.domElement(elem);\n    } else if ((template.nodeType == 1) || (template.nodeType == 8)) {\n        // Anonymous template\n        return new ko.templateSources.anonymousTemplate(template);\n    } else\n        throw new Error(\"Unknown template type: \" + template);\n};\n\nko.templateEngine.prototype['renderTemplate'] = function (template, bindingContext, options, templateDocument) {\n    var templateSource = this['makeTemplateSource'](template, templateDocument);\n    return this['renderTemplateSource'](templateSource, bindingContext, options, templateDocument);\n};\n\nko.templateEngine.prototype['isTemplateRewritten'] = function (template, templateDocument) {\n    // Skip rewriting if requested\n    if (this['allowTemplateRewriting'] === false)\n        return true;\n    return this['makeTemplateSource'](template, templateDocument)['data'](\"isRewritten\");\n};\n\nko.templateEngine.prototype['rewriteTemplate'] = function (template, rewriterCallback, templateDocument) {\n    var templateSource = this['makeTemplateSource'](template, templateDocument);\n    var rewritten = rewriterCallback(templateSource['text']());\n    templateSource['text'](rewritten);\n    templateSource['data'](\"isRewritten\", true);\n};\n\nko.exportSymbol('templateEngine', ko.templateEngine);\n\nko.templateRewriting = (function () {\n    var memoizeDataBindingAttributeSyntaxRegex = /(<([a-z]+\\d*)(?:\\s+(?!data-bind\\s*=\\s*)[a-z0-9\\-]+(?:=(?:\\\"[^\\\"]*\\\"|\\'[^\\']*\\'|[^>]*))?)*\\s+)data-bind\\s*=\\s*([\"'])([\\s\\S]*?)\\3/gi;\n    var memoizeVirtualContainerBindingSyntaxRegex = /<!--\\s*ko\\b\\s*([\\s\\S]*?)\\s*-->/g;\n\n    function validateDataBindValuesForRewriting(keyValueArray) {\n        var allValidators = ko.expressionRewriting.bindingRewriteValidators;\n        for (var i = 0; i < keyValueArray.length; i++) {\n            var key = keyValueArray[i]['key'];\n            if (allValidators.hasOwnProperty(key)) {\n                var validator = allValidators[key];\n\n                if (typeof validator === \"function\") {\n                    var possibleErrorMessage = validator(keyValueArray[i]['value']);\n                    if (possibleErrorMessage)\n                        throw new Error(possibleErrorMessage);\n                } else if (!validator) {\n                    throw new Error(\"This template engine does not support the '\" + key + \"' binding within its templates\");\n                }\n            }\n        }\n    }\n\n    function constructMemoizedTagReplacement(dataBindAttributeValue, tagToRetain, nodeName, templateEngine) {\n        var dataBindKeyValueArray = ko.expressionRewriting.parseObjectLiteral(dataBindAttributeValue);\n        validateDataBindValuesForRewriting(dataBindKeyValueArray);\n        var rewrittenDataBindAttributeValue = ko.expressionRewriting.preProcessBindings(dataBindKeyValueArray, {'valueAccessors':true});\n\n        // For no obvious reason, Opera fails to evaluate rewrittenDataBindAttributeValue unless it's wrapped in an additional\n        // anonymous function, even though Opera's built-in debugger can evaluate it anyway. No other browser requires this\n        // extra indirection.\n        var applyBindingsToNextSiblingScript =\n            \"ko.__tr_ambtns(function($context,$element){return(function(){return{ \" + rewrittenDataBindAttributeValue + \" } })()},'\" + nodeName.toLowerCase() + \"')\";\n        return templateEngine['createJavaScriptEvaluatorBlock'](applyBindingsToNextSiblingScript) + tagToRetain;\n    }\n\n    return {\n        ensureTemplateIsRewritten: function (template, templateEngine, templateDocument) {\n            if (!templateEngine['isTemplateRewritten'](template, templateDocument))\n                templateEngine['rewriteTemplate'](template, function (htmlString) {\n                    return ko.templateRewriting.memoizeBindingAttributeSyntax(htmlString, templateEngine);\n                }, templateDocument);\n        },\n\n        memoizeBindingAttributeSyntax: function (htmlString, templateEngine) {\n            return htmlString.replace(memoizeDataBindingAttributeSyntaxRegex, function () {\n                return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[4], /* tagToRetain: */ arguments[1], /* nodeName: */ arguments[2], templateEngine);\n            }).replace(memoizeVirtualContainerBindingSyntaxRegex, function() {\n                return constructMemoizedTagReplacement(/* dataBindAttributeValue: */ arguments[1], /* tagToRetain: */ \"<!-- ko -->\", /* nodeName: */ \"#comment\", templateEngine);\n            });\n        },\n\n        applyMemoizedBindingsToNextSibling: function (bindings, nodeName) {\n            return ko.memoization.memoize(function (domNode, bindingContext) {\n                var nodeToBind = domNode.nextSibling;\n                if (nodeToBind && nodeToBind.nodeName.toLowerCase() === nodeName) {\n                    ko.applyBindingAccessorsToNode(nodeToBind, bindings, bindingContext);\n                }\n            });\n        }\n    }\n})();\n\n\n// Exported only because it has to be referenced by string lookup from within rewritten template\nko.exportSymbol('__tr_ambtns', ko.templateRewriting.applyMemoizedBindingsToNextSibling);\n(function() {\n    // A template source represents a read/write way of accessing a template. This is to eliminate the need for template loading/saving\n    // logic to be duplicated in every template engine (and means they can all work with anonymous templates, etc.)\n    //\n    // Two are provided by default:\n    //  1. ko.templateSources.domElement       - reads/writes the text content of an arbitrary DOM element\n    //  2. ko.templateSources.anonymousElement - uses ko.utils.domData to read/write text *associated* with the DOM element, but\n    //                                           without reading/writing the actual element text content, since it will be overwritten\n    //                                           with the rendered template output.\n    // You can implement your own template source if you want to fetch/store templates somewhere other than in DOM elements.\n    // Template sources need to have the following functions:\n    //   text() \t\t\t- returns the template text from your storage location\n    //   text(value)\t\t- writes the supplied template text to your storage location\n    //   data(key)\t\t\t- reads values stored using data(key, value) - see below\n    //   data(key, value)\t- associates \"value\" with this template and the key \"key\". Is used to store information like \"isRewritten\".\n    //\n    // Optionally, template sources can also have the following functions:\n    //   nodes()            - returns a DOM element containing the nodes of this template, where available\n    //   nodes(value)       - writes the given DOM element to your storage location\n    // If a DOM element is available for a given template source, template engines are encouraged to use it in preference over text()\n    // for improved speed. However, all templateSources must supply text() even if they don't supply nodes().\n    //\n    // Once you've implemented a templateSource, make your template engine use it by subclassing whatever template engine you were\n    // using and overriding \"makeTemplateSource\" to return an instance of your custom template source.\n\n    ko.templateSources = {};\n\n    // ---- ko.templateSources.domElement -----\n\n    // template types\n    var templateScript = 1,\n        templateTextArea = 2,\n        templateTemplate = 3,\n        templateElement = 4;\n\n    ko.templateSources.domElement = function(element) {\n        this.domElement = element;\n\n        if (element) {\n            var tagNameLower = ko.utils.tagNameLower(element);\n            this.templateType =\n                tagNameLower === \"script\" ? templateScript :\n                tagNameLower === \"textarea\" ? templateTextArea :\n                    // For browsers with proper <template> element support, where the .content property gives a document fragment\n                tagNameLower == \"template\" && element.content && element.content.nodeType === 11 ? templateTemplate :\n                templateElement;\n        }\n    }\n\n    ko.templateSources.domElement.prototype['text'] = function(/* valueToWrite */) {\n        var elemContentsProperty = this.templateType === templateScript ? \"text\"\n                                 : this.templateType === templateTextArea ? \"value\"\n                                 : \"innerHTML\";\n\n        if (arguments.length == 0) {\n            return this.domElement[elemContentsProperty];\n        } else {\n            var valueToWrite = arguments[0];\n            if (elemContentsProperty === \"innerHTML\")\n                ko.utils.setHtml(this.domElement, valueToWrite);\n            else\n                this.domElement[elemContentsProperty] = valueToWrite;\n        }\n    };\n\n    var dataDomDataPrefix = ko.utils.domData.nextKey() + \"_\";\n    ko.templateSources.domElement.prototype['data'] = function(key /*, valueToWrite */) {\n        if (arguments.length === 1) {\n            return ko.utils.domData.get(this.domElement, dataDomDataPrefix + key);\n        } else {\n            ko.utils.domData.set(this.domElement, dataDomDataPrefix + key, arguments[1]);\n        }\n    };\n\n    var templatesDomDataKey = ko.utils.domData.nextKey();\n    function getTemplateDomData(element) {\n        return ko.utils.domData.get(element, templatesDomDataKey) || {};\n    }\n    function setTemplateDomData(element, data) {\n        ko.utils.domData.set(element, templatesDomDataKey, data);\n    }\n\n    ko.templateSources.domElement.prototype['nodes'] = function(/* valueToWrite */) {\n        var element = this.domElement;\n        if (arguments.length == 0) {\n            var templateData = getTemplateDomData(element),\n                containerData = templateData.containerData;\n            return containerData || (\n                this.templateType === templateTemplate ? element.content :\n                this.templateType === templateElement ? element :\n                undefined);\n        } else {\n            var valueToWrite = arguments[0];\n            setTemplateDomData(element, {containerData: valueToWrite});\n        }\n    };\n\n    // ---- ko.templateSources.anonymousTemplate -----\n    // Anonymous templates are normally saved/retrieved as DOM nodes through \"nodes\".\n    // For compatibility, you can also read \"text\"; it will be serialized from the nodes on demand.\n    // Writing to \"text\" is still supported, but then the template data will not be available as DOM nodes.\n\n    ko.templateSources.anonymousTemplate = function(element) {\n        this.domElement = element;\n    }\n    ko.templateSources.anonymousTemplate.prototype = new ko.templateSources.domElement();\n    ko.templateSources.anonymousTemplate.prototype.constructor = ko.templateSources.anonymousTemplate;\n    ko.templateSources.anonymousTemplate.prototype['text'] = function(/* valueToWrite */) {\n        if (arguments.length == 0) {\n            var templateData = getTemplateDomData(this.domElement);\n            if (templateData.textData === undefined && templateData.containerData)\n                templateData.textData = templateData.containerData.innerHTML;\n            return templateData.textData;\n        } else {\n            var valueToWrite = arguments[0];\n            setTemplateDomData(this.domElement, {textData: valueToWrite});\n        }\n    };\n\n    ko.exportSymbol('templateSources', ko.templateSources);\n    ko.exportSymbol('templateSources.domElement', ko.templateSources.domElement);\n    ko.exportSymbol('templateSources.anonymousTemplate', ko.templateSources.anonymousTemplate);\n})();\n(function () {\n    var _templateEngine;\n    ko.setTemplateEngine = function (templateEngine) {\n        if ((templateEngine != undefined) && !(templateEngine instanceof ko.templateEngine))\n            throw new Error(\"templateEngine must inherit from ko.templateEngine\");\n        _templateEngine = templateEngine;\n    }\n\n    function invokeForEachNodeInContinuousRange(firstNode, lastNode, action) {\n        var node, nextInQueue = firstNode, firstOutOfRangeNode = ko.virtualElements.nextSibling(lastNode);\n        while (nextInQueue && ((node = nextInQueue) !== firstOutOfRangeNode)) {\n            nextInQueue = ko.virtualElements.nextSibling(node);\n            action(node, nextInQueue);\n        }\n    }\n\n    function activateBindingsOnContinuousNodeArray(continuousNodeArray, bindingContext) {\n        // To be used on any nodes that have been rendered by a template and have been inserted into some parent element\n        // Walks through continuousNodeArray (which *must* be continuous, i.e., an uninterrupted sequence of sibling nodes, because\n        // the algorithm for walking them relies on this), and for each top-level item in the virtual-element sense,\n        // (1) Does a regular \"applyBindings\" to associate bindingContext with this node and to activate any non-memoized bindings\n        // (2) Unmemoizes any memos in the DOM subtree (e.g., to activate bindings that had been memoized during template rewriting)\n\n        if (continuousNodeArray.length) {\n            var firstNode = continuousNodeArray[0],\n                lastNode = continuousNodeArray[continuousNodeArray.length - 1],\n                parentNode = firstNode.parentNode,\n                provider = ko.bindingProvider['instance'],\n                preprocessNode = provider['preprocessNode'];\n\n            if (preprocessNode) {\n                invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node, nextNodeInRange) {\n                    var nodePreviousSibling = node.previousSibling;\n                    var newNodes = preprocessNode.call(provider, node);\n                    if (newNodes) {\n                        if (node === firstNode)\n                            firstNode = newNodes[0] || nextNodeInRange;\n                        if (node === lastNode)\n                            lastNode = newNodes[newNodes.length - 1] || nodePreviousSibling;\n                    }\n                });\n\n                // Because preprocessNode can change the nodes, including the first and last nodes, update continuousNodeArray to match.\n                // We need the full set, including inner nodes, because the unmemoize step might remove the first node (and so the real\n                // first node needs to be in the array).\n                continuousNodeArray.length = 0;\n                if (!firstNode) { // preprocessNode might have removed all the nodes, in which case there's nothing left to do\n                    return;\n                }\n                if (firstNode === lastNode) {\n                    continuousNodeArray.push(firstNode);\n                } else {\n                    continuousNodeArray.push(firstNode, lastNode);\n                    ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n                }\n            }\n\n            // Need to applyBindings *before* unmemoziation, because unmemoization might introduce extra nodes (that we don't want to re-bind)\n            // whereas a regular applyBindings won't introduce new memoized nodes\n            invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                if (node.nodeType === 1 || node.nodeType === 8)\n                    ko.applyBindings(bindingContext, node);\n            });\n            invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {\n                if (node.nodeType === 1 || node.nodeType === 8)\n                    ko.memoization.unmemoizeDomNodeAndDescendants(node, [bindingContext]);\n            });\n\n            // Make sure any changes done by applyBindings or unmemoize are reflected in the array\n            ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);\n        }\n    }\n\n    function getFirstNodeFromPossibleArray(nodeOrNodeArray) {\n        return nodeOrNodeArray.nodeType ? nodeOrNodeArray\n                                        : nodeOrNodeArray.length > 0 ? nodeOrNodeArray[0]\n                                        : null;\n    }\n\n    function executeTemplate(targetNodeOrNodeArray, renderMode, template, bindingContext, options) {\n        options = options || {};\n        var firstTargetNode = targetNodeOrNodeArray && getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n        var templateDocument = (firstTargetNode || template || {}).ownerDocument;\n        var templateEngineToUse = (options['templateEngine'] || _templateEngine);\n        ko.templateRewriting.ensureTemplateIsRewritten(template, templateEngineToUse, templateDocument);\n        var renderedNodesArray = templateEngineToUse['renderTemplate'](template, bindingContext, options, templateDocument);\n\n        // Loosely check result is an array of DOM nodes\n        if ((typeof renderedNodesArray.length != \"number\") || (renderedNodesArray.length > 0 && typeof renderedNodesArray[0].nodeType != \"number\"))\n            throw new Error(\"Template engine must return an array of DOM nodes\");\n\n        var haveAddedNodesToParent = false;\n        switch (renderMode) {\n            case \"replaceChildren\":\n                ko.virtualElements.setDomNodeChildren(targetNodeOrNodeArray, renderedNodesArray);\n                haveAddedNodesToParent = true;\n                break;\n            case \"replaceNode\":\n                ko.utils.replaceDomNodes(targetNodeOrNodeArray, renderedNodesArray);\n                haveAddedNodesToParent = true;\n                break;\n            case \"ignoreTargetNode\": break;\n            default:\n                throw new Error(\"Unknown renderMode: \" + renderMode);\n        }\n\n        if (haveAddedNodesToParent) {\n            activateBindingsOnContinuousNodeArray(renderedNodesArray, bindingContext);\n            if (options['afterRender'])\n                ko.dependencyDetection.ignore(options['afterRender'], null, [renderedNodesArray, bindingContext['$data']]);\n        }\n\n        return renderedNodesArray;\n    }\n\n    function resolveTemplateName(template, data, context) {\n        // The template can be specified as:\n        if (ko.isObservable(template)) {\n            // 1. An observable, with string value\n            return template();\n        } else if (typeof template === 'function') {\n            // 2. A function of (data, context) returning a string\n            return template(data, context);\n        } else {\n            // 3. A string\n            return template;\n        }\n    }\n\n    ko.renderTemplate = function (template, dataOrBindingContext, options, targetNodeOrNodeArray, renderMode) {\n        options = options || {};\n        if ((options['templateEngine'] || _templateEngine) == undefined)\n            throw new Error(\"Set a template engine before calling renderTemplate\");\n        renderMode = renderMode || \"replaceChildren\";\n\n        if (targetNodeOrNodeArray) {\n            var firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n\n            var whenToDispose = function () { return (!firstTargetNode) || !ko.utils.domNodeIsAttachedToDocument(firstTargetNode); }; // Passive disposal (on next evaluation)\n            var activelyDisposeWhenNodeIsRemoved = (firstTargetNode && renderMode == \"replaceNode\") ? firstTargetNode.parentNode : firstTargetNode;\n\n            return ko.dependentObservable( // So the DOM is automatically updated when any dependency changes\n                function () {\n                    // Ensure we've got a proper binding context to work with\n                    var bindingContext = (dataOrBindingContext && (dataOrBindingContext instanceof ko.bindingContext))\n                        ? dataOrBindingContext\n                        : new ko.bindingContext(dataOrBindingContext, null, null, null, { \"exportDependencies\": true });\n\n                    var templateName = resolveTemplateName(template, bindingContext['$data'], bindingContext),\n                        renderedNodesArray = executeTemplate(targetNodeOrNodeArray, renderMode, templateName, bindingContext, options);\n\n                    if (renderMode == \"replaceNode\") {\n                        targetNodeOrNodeArray = renderedNodesArray;\n                        firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);\n                    }\n                },\n                null,\n                { disposeWhen: whenToDispose, disposeWhenNodeIsRemoved: activelyDisposeWhenNodeIsRemoved }\n            );\n        } else {\n            // We don't yet have a DOM node to evaluate, so use a memo and render the template later when there is a DOM node\n            return ko.memoization.memoize(function (domNode) {\n                ko.renderTemplate(template, dataOrBindingContext, options, domNode, \"replaceNode\");\n            });\n        }\n    };\n\n    ko.renderTemplateForEach = function (template, arrayOrObservableArray, options, targetNode, parentBindingContext) {\n        // Since setDomNodeChildrenFromArrayMapping always calls executeTemplateForArrayItem and then\n        // activateBindingsCallback for added items, we can store the binding context in the former to use in the latter.\n        var arrayItemContext;\n\n        // This will be called by setDomNodeChildrenFromArrayMapping to get the nodes to add to targetNode\n        var executeTemplateForArrayItem = function (arrayValue, index) {\n            // Support selecting template as a function of the data being rendered\n            arrayItemContext = parentBindingContext['createChildContext'](arrayValue, options['as'], function(context) {\n                context['$index'] = index;\n            });\n\n            var templateName = resolveTemplateName(template, arrayValue, arrayItemContext);\n            return executeTemplate(null, \"ignoreTargetNode\", templateName, arrayItemContext, options);\n        }\n\n        // This will be called whenever setDomNodeChildrenFromArrayMapping has added nodes to targetNode\n        var activateBindingsCallback = function(arrayValue, addedNodesArray, index) {\n            activateBindingsOnContinuousNodeArray(addedNodesArray, arrayItemContext);\n            if (options['afterRender'])\n                options['afterRender'](addedNodesArray, arrayValue);\n\n            // release the \"cache\" variable, so that it can be collected by\n            // the GC when its value isn't used from within the bindings anymore.\n            arrayItemContext = null;\n        };\n\n        return ko.dependentObservable(function () {\n            var unwrappedArray = ko.utils.unwrapObservable(arrayOrObservableArray) || [];\n            if (typeof unwrappedArray.length == \"undefined\") // Coerce single value into array\n                unwrappedArray = [unwrappedArray];\n\n            // Filter out any entries marked as destroyed\n            var filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {\n                return options['includeDestroyed'] || item === undefined || item === null || !ko.utils.unwrapObservable(item['_destroy']);\n            });\n\n            // Call setDomNodeChildrenFromArrayMapping, ignoring any observables unwrapped within (most likely from a callback function).\n            // If the array items are observables, though, they will be unwrapped in executeTemplateForArrayItem and managed within setDomNodeChildrenFromArrayMapping.\n            ko.dependencyDetection.ignore(ko.utils.setDomNodeChildrenFromArrayMapping, null, [targetNode, filteredArray, executeTemplateForArrayItem, options, activateBindingsCallback]);\n\n        }, null, { disposeWhenNodeIsRemoved: targetNode });\n    };\n\n    var templateComputedDomDataKey = ko.utils.domData.nextKey();\n    function disposeOldComputedAndStoreNewOne(element, newComputed) {\n        var oldComputed = ko.utils.domData.get(element, templateComputedDomDataKey);\n        if (oldComputed && (typeof(oldComputed.dispose) == 'function'))\n            oldComputed.dispose();\n        ko.utils.domData.set(element, templateComputedDomDataKey, (newComputed && newComputed.isActive()) ? newComputed : undefined);\n    }\n\n    ko.bindingHandlers['template'] = {\n        'init': function(element, valueAccessor) {\n            // Support anonymous templates\n            var bindingValue = ko.utils.unwrapObservable(valueAccessor());\n            if (typeof bindingValue == \"string\" || bindingValue['name']) {\n                // It's a named template - clear the element\n                ko.virtualElements.emptyNode(element);\n            } else if ('nodes' in bindingValue) {\n                // We've been given an array of DOM nodes. Save them as the template source.\n                // There is no known use case for the node array being an observable array (if the output\n                // varies, put that behavior *into* your template - that's what templates are for), and\n                // the implementation would be a mess, so assert that it's not observable.\n                var nodes = bindingValue['nodes'] || [];\n                if (ko.isObservable(nodes)) {\n                    throw new Error('The \"nodes\" option must be a plain, non-observable array.');\n                }\n                var container = ko.utils.moveCleanedNodesToContainerElement(nodes); // This also removes the nodes from their current parent\n                new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n            } else {\n                // It's an anonymous template - store the element contents, then clear the element\n                var templateNodes = ko.virtualElements.childNodes(element),\n                    container = ko.utils.moveCleanedNodesToContainerElement(templateNodes); // This also removes the nodes from their current parent\n                new ko.templateSources.anonymousTemplate(element)['nodes'](container);\n            }\n            return { 'controlsDescendantBindings': true };\n        },\n        'update': function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n            var value = valueAccessor(),\n                options = ko.utils.unwrapObservable(value),\n                shouldDisplay = true,\n                templateComputed = null,\n                templateName;\n\n            if (typeof options == \"string\") {\n                templateName = value;\n                options = {};\n            } else {\n                templateName = options['name'];\n\n                // Support \"if\"/\"ifnot\" conditions\n                if ('if' in options)\n                    shouldDisplay = ko.utils.unwrapObservable(options['if']);\n                if (shouldDisplay && 'ifnot' in options)\n                    shouldDisplay = !ko.utils.unwrapObservable(options['ifnot']);\n            }\n\n            if ('foreach' in options) {\n                // Render once for each data point (treating data set as empty if shouldDisplay==false)\n                var dataArray = (shouldDisplay && options['foreach']) || [];\n                templateComputed = ko.renderTemplateForEach(templateName || element, dataArray, options, element, bindingContext);\n            } else if (!shouldDisplay) {\n                ko.virtualElements.emptyNode(element);\n            } else {\n                // Render once for this single data point (or use the viewModel if no data was provided)\n                var innerBindingContext = ('data' in options) ?\n                    bindingContext.createStaticChildContext(options['data'], options['as']) :  // Given an explitit 'data' value, we create a child binding context for it\n                    bindingContext;                                                        // Given no explicit 'data' value, we retain the same binding context\n                templateComputed = ko.renderTemplate(templateName || element, innerBindingContext, options, element);\n            }\n\n            // It only makes sense to have a single template computed per element (otherwise which one should have its output displayed?)\n            disposeOldComputedAndStoreNewOne(element, templateComputed);\n        }\n    };\n\n    // Anonymous templates can't be rewritten. Give a nice error message if you try to do it.\n    ko.expressionRewriting.bindingRewriteValidators['template'] = function(bindingValue) {\n        var parsedBindingValue = ko.expressionRewriting.parseObjectLiteral(bindingValue);\n\n        if ((parsedBindingValue.length == 1) && parsedBindingValue[0]['unknown'])\n            return null; // It looks like a string literal, not an object literal, so treat it as a named template (which is allowed for rewriting)\n\n        if (ko.expressionRewriting.keyValueArrayContainsKey(parsedBindingValue, \"name\"))\n            return null; // Named templates can be rewritten, so return \"no error\"\n        return \"This template engine does not support anonymous templates nested within its templates\";\n    };\n\n    ko.virtualElements.allowedBindings['template'] = true;\n})();\n\nko.exportSymbol('setTemplateEngine', ko.setTemplateEngine);\nko.exportSymbol('renderTemplate', ko.renderTemplate);\n// Go through the items that have been added and deleted and try to find matches between them.\nko.utils.findMovesInArrayComparison = function (left, right, limitFailedCompares) {\n    if (left.length && right.length) {\n        var failedCompares, l, r, leftItem, rightItem;\n        for (failedCompares = l = 0; (!limitFailedCompares || failedCompares < limitFailedCompares) && (leftItem = left[l]); ++l) {\n            for (r = 0; rightItem = right[r]; ++r) {\n                if (leftItem['value'] === rightItem['value']) {\n                    leftItem['moved'] = rightItem['index'];\n                    rightItem['moved'] = leftItem['index'];\n                    right.splice(r, 1);         // This item is marked as moved; so remove it from right list\n                    failedCompares = r = 0;     // Reset failed compares count because we're checking for consecutive failures\n                    break;\n                }\n            }\n            failedCompares += r;\n        }\n    }\n};\n\nko.utils.compareArrays = (function () {\n    var statusNotInOld = 'added', statusNotInNew = 'deleted';\n\n    // Simple calculation based on Levenshtein distance.\n    function compareArrays(oldArray, newArray, options) {\n        // For backward compatibility, if the third arg is actually a bool, interpret\n        // it as the old parameter 'dontLimitMoves'. Newer code should use { dontLimitMoves: true }.\n        options = (typeof options === 'boolean') ? { 'dontLimitMoves': options } : (options || {});\n        oldArray = oldArray || [];\n        newArray = newArray || [];\n\n        if (oldArray.length < newArray.length)\n            return compareSmallArrayToBigArray(oldArray, newArray, statusNotInOld, statusNotInNew, options);\n        else\n            return compareSmallArrayToBigArray(newArray, oldArray, statusNotInNew, statusNotInOld, options);\n    }\n\n    function compareSmallArrayToBigArray(smlArray, bigArray, statusNotInSml, statusNotInBig, options) {\n        var myMin = Math.min,\n            myMax = Math.max,\n            editDistanceMatrix = [],\n            smlIndex, smlIndexMax = smlArray.length,\n            bigIndex, bigIndexMax = bigArray.length,\n            compareRange = (bigIndexMax - smlIndexMax) || 1,\n            maxDistance = smlIndexMax + bigIndexMax + 1,\n            thisRow, lastRow,\n            bigIndexMaxForRow, bigIndexMinForRow;\n\n        for (smlIndex = 0; smlIndex <= smlIndexMax; smlIndex++) {\n            lastRow = thisRow;\n            editDistanceMatrix.push(thisRow = []);\n            bigIndexMaxForRow = myMin(bigIndexMax, smlIndex + compareRange);\n            bigIndexMinForRow = myMax(0, smlIndex - 1);\n            for (bigIndex = bigIndexMinForRow; bigIndex <= bigIndexMaxForRow; bigIndex++) {\n                if (!bigIndex)\n                    thisRow[bigIndex] = smlIndex + 1;\n                else if (!smlIndex)  // Top row - transform empty array into new array via additions\n                    thisRow[bigIndex] = bigIndex + 1;\n                else if (smlArray[smlIndex - 1] === bigArray[bigIndex - 1])\n                    thisRow[bigIndex] = lastRow[bigIndex - 1];                  // copy value (no edit)\n                else {\n                    var northDistance = lastRow[bigIndex] || maxDistance;       // not in big (deletion)\n                    var westDistance = thisRow[bigIndex - 1] || maxDistance;    // not in small (addition)\n                    thisRow[bigIndex] = myMin(northDistance, westDistance) + 1;\n                }\n            }\n        }\n\n        var editScript = [], meMinusOne, notInSml = [], notInBig = [];\n        for (smlIndex = smlIndexMax, bigIndex = bigIndexMax; smlIndex || bigIndex;) {\n            meMinusOne = editDistanceMatrix[smlIndex][bigIndex] - 1;\n            if (bigIndex && meMinusOne === editDistanceMatrix[smlIndex][bigIndex-1]) {\n                notInSml.push(editScript[editScript.length] = {     // added\n                    'status': statusNotInSml,\n                    'value': bigArray[--bigIndex],\n                    'index': bigIndex });\n            } else if (smlIndex && meMinusOne === editDistanceMatrix[smlIndex - 1][bigIndex]) {\n                notInBig.push(editScript[editScript.length] = {     // deleted\n                    'status': statusNotInBig,\n                    'value': smlArray[--smlIndex],\n                    'index': smlIndex });\n            } else {\n                --bigIndex;\n                --smlIndex;\n                if (!options['sparse']) {\n                    editScript.push({\n                        'status': \"retained\",\n                        'value': bigArray[bigIndex] });\n                }\n            }\n        }\n\n        // Set a limit on the number of consecutive non-matching comparisons; having it a multiple of\n        // smlIndexMax keeps the time complexity of this algorithm linear.\n        ko.utils.findMovesInArrayComparison(notInBig, notInSml, !options['dontLimitMoves'] && smlIndexMax * 10);\n\n        return editScript.reverse();\n    }\n\n    return compareArrays;\n})();\n\nko.exportSymbol('utils.compareArrays', ko.utils.compareArrays);\n(function () {\n    // Objective:\n    // * Given an input array, a container DOM node, and a function from array elements to arrays of DOM nodes,\n    //   map the array elements to arrays of DOM nodes, concatenate together all these arrays, and use them to populate the container DOM node\n    // * Next time we're given the same combination of things (with the array possibly having mutated), update the container DOM node\n    //   so that its children is again the concatenation of the mappings of the array elements, but don't re-map any array elements that we\n    //   previously mapped - retain those nodes, and just insert/delete other ones\n\n    // \"callbackAfterAddingNodes\" will be invoked after any \"mapping\"-generated nodes are inserted into the container node\n    // You can use this, for example, to activate bindings on those nodes.\n\n    function mapNodeAndRefreshWhenChanged(containerNode, mapping, valueToMap, callbackAfterAddingNodes, index) {\n        // Map this array value inside a dependentObservable so we re-map when any dependency changes\n        var mappedNodes = [];\n        var dependentObservable = ko.dependentObservable(function() {\n            var newMappedNodes = mapping(valueToMap, index, ko.utils.fixUpContinuousNodeArray(mappedNodes, containerNode)) || [];\n\n            // On subsequent evaluations, just replace the previously-inserted DOM nodes\n            if (mappedNodes.length > 0) {\n                ko.utils.replaceDomNodes(mappedNodes, newMappedNodes);\n                if (callbackAfterAddingNodes)\n                    ko.dependencyDetection.ignore(callbackAfterAddingNodes, null, [valueToMap, newMappedNodes, index]);\n            }\n\n            // Replace the contents of the mappedNodes array, thereby updating the record\n            // of which nodes would be deleted if valueToMap was itself later removed\n            mappedNodes.length = 0;\n            ko.utils.arrayPushAll(mappedNodes, newMappedNodes);\n        }, null, { disposeWhenNodeIsRemoved: containerNode, disposeWhen: function() { return !ko.utils.anyDomNodeIsAttachedToDocument(mappedNodes); } });\n        return { mappedNodes : mappedNodes, dependentObservable : (dependentObservable.isActive() ? dependentObservable : undefined) };\n    }\n\n    var lastMappingResultDomDataKey = ko.utils.domData.nextKey(),\n        deletedItemDummyValue = ko.utils.domData.nextKey();\n\n    ko.utils.setDomNodeChildrenFromArrayMapping = function (domNode, array, mapping, options, callbackAfterAddingNodes) {\n        // Compare the provided array against the previous one\n        array = array || [];\n        options = options || {};\n        var isFirstExecution = ko.utils.domData.get(domNode, lastMappingResultDomDataKey) === undefined;\n        var lastMappingResult = ko.utils.domData.get(domNode, lastMappingResultDomDataKey) || [];\n        var lastArray = ko.utils.arrayMap(lastMappingResult, function (x) { return x.arrayEntry; });\n        var editScript = ko.utils.compareArrays(lastArray, array, options['dontLimitMoves']);\n\n        // Build the new mapping result\n        var newMappingResult = [];\n        var lastMappingResultIndex = 0;\n        var newMappingResultIndex = 0;\n\n        var nodesToDelete = [];\n        var itemsToProcess = [];\n        var itemsForBeforeRemoveCallbacks = [];\n        var itemsForMoveCallbacks = [];\n        var itemsForAfterAddCallbacks = [];\n        var mapData;\n\n        function itemMovedOrRetained(editScriptIndex, oldPosition) {\n            mapData = lastMappingResult[oldPosition];\n            if (newMappingResultIndex !== oldPosition)\n                itemsForMoveCallbacks[editScriptIndex] = mapData;\n            // Since updating the index might change the nodes, do so before calling fixUpContinuousNodeArray\n            mapData.indexObservable(newMappingResultIndex++);\n            ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode);\n            newMappingResult.push(mapData);\n            itemsToProcess.push(mapData);\n        }\n\n        function callCallback(callback, items) {\n            if (callback) {\n                for (var i = 0, n = items.length; i < n; i++) {\n                    if (items[i]) {\n                        ko.utils.arrayForEach(items[i].mappedNodes, function(node) {\n                            callback(node, i, items[i].arrayEntry);\n                        });\n                    }\n                }\n            }\n        }\n\n        for (var i = 0, editScriptItem, movedIndex; editScriptItem = editScript[i]; i++) {\n            movedIndex = editScriptItem['moved'];\n            switch (editScriptItem['status']) {\n                case \"deleted\":\n                    if (movedIndex === undefined) {\n                        mapData = lastMappingResult[lastMappingResultIndex];\n\n                        // Stop tracking changes to the mapping for these nodes\n                        if (mapData.dependentObservable) {\n                            mapData.dependentObservable.dispose();\n                            mapData.dependentObservable = undefined;\n                        }\n\n                        // Queue these nodes for later removal\n                        if (ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode).length) {\n                            if (options['beforeRemove']) {\n                                newMappingResult.push(mapData);\n                                itemsToProcess.push(mapData);\n                                if (mapData.arrayEntry === deletedItemDummyValue) {\n                                    mapData = null;\n                                } else {\n                                    itemsForBeforeRemoveCallbacks[i] = mapData;\n                                }\n                            }\n                            if (mapData) {\n                                nodesToDelete.push.apply(nodesToDelete, mapData.mappedNodes);\n                            }\n                        }\n                    }\n                    lastMappingResultIndex++;\n                    break;\n\n                case \"retained\":\n                    itemMovedOrRetained(i, lastMappingResultIndex++);\n                    break;\n\n                case \"added\":\n                    if (movedIndex !== undefined) {\n                        itemMovedOrRetained(i, movedIndex);\n                    } else {\n                        mapData = { arrayEntry: editScriptItem['value'], indexObservable: ko.observable(newMappingResultIndex++) };\n                        newMappingResult.push(mapData);\n                        itemsToProcess.push(mapData);\n                        if (!isFirstExecution)\n                            itemsForAfterAddCallbacks[i] = mapData;\n                    }\n                    break;\n            }\n        }\n\n        // Store a copy of the array items we just considered so we can difference it next time\n        ko.utils.domData.set(domNode, lastMappingResultDomDataKey, newMappingResult);\n\n        // Call beforeMove first before any changes have been made to the DOM\n        callCallback(options['beforeMove'], itemsForMoveCallbacks);\n\n        // Next remove nodes for deleted items (or just clean if there's a beforeRemove callback)\n        ko.utils.arrayForEach(nodesToDelete, options['beforeRemove'] ? ko.cleanNode : ko.removeNode);\n\n        // Next add/reorder the remaining items (will include deleted items if there's a beforeRemove callback)\n        for (var i = 0, nextNode = ko.virtualElements.firstChild(domNode), lastNode, node; mapData = itemsToProcess[i]; i++) {\n            // Get nodes for newly added items\n            if (!mapData.mappedNodes)\n                ko.utils.extend(mapData, mapNodeAndRefreshWhenChanged(domNode, mapping, mapData.arrayEntry, callbackAfterAddingNodes, mapData.indexObservable));\n\n            // Put nodes in the right place if they aren't there already\n            for (var j = 0; node = mapData.mappedNodes[j]; nextNode = node.nextSibling, lastNode = node, j++) {\n                if (node !== nextNode)\n                    ko.virtualElements.insertAfter(domNode, node, lastNode);\n            }\n\n            // Run the callbacks for newly added nodes (for example, to apply bindings, etc.)\n            if (!mapData.initialized && callbackAfterAddingNodes) {\n                callbackAfterAddingNodes(mapData.arrayEntry, mapData.mappedNodes, mapData.indexObservable);\n                mapData.initialized = true;\n            }\n        }\n\n        // If there's a beforeRemove callback, call it after reordering.\n        // Note that we assume that the beforeRemove callback will usually be used to remove the nodes using\n        // some sort of animation, which is why we first reorder the nodes that will be removed. If the\n        // callback instead removes the nodes right away, it would be more efficient to skip reordering them.\n        // Perhaps we'll make that change in the future if this scenario becomes more common.\n        callCallback(options['beforeRemove'], itemsForBeforeRemoveCallbacks);\n\n        // Replace the stored values of deleted items with a dummy value. This provides two benefits: it marks this item\n        // as already \"removed\" so we won't call beforeRemove for it again, and it ensures that the item won't match up\n        // with an actual item in the array and appear as \"retained\" or \"moved\".\n        for (i = 0; i < itemsForBeforeRemoveCallbacks.length; ++i) {\n            if (itemsForBeforeRemoveCallbacks[i]) {\n                itemsForBeforeRemoveCallbacks[i].arrayEntry = deletedItemDummyValue;\n            }\n        }\n\n        // Finally call afterMove and afterAdd callbacks\n        callCallback(options['afterMove'], itemsForMoveCallbacks);\n        callCallback(options['afterAdd'], itemsForAfterAddCallbacks);\n    }\n})();\n\nko.exportSymbol('utils.setDomNodeChildrenFromArrayMapping', ko.utils.setDomNodeChildrenFromArrayMapping);\nko.nativeTemplateEngine = function () {\n    this['allowTemplateRewriting'] = false;\n}\n\nko.nativeTemplateEngine.prototype = new ko.templateEngine();\nko.nativeTemplateEngine.prototype.constructor = ko.nativeTemplateEngine;\nko.nativeTemplateEngine.prototype['renderTemplateSource'] = function (templateSource, bindingContext, options, templateDocument) {\n    var useNodesIfAvailable = !(ko.utils.ieVersion < 9), // IE<9 cloneNode doesn't work properly\n        templateNodesFunc = useNodesIfAvailable ? templateSource['nodes'] : null,\n        templateNodes = templateNodesFunc ? templateSource['nodes']() : null;\n\n    if (templateNodes) {\n        return ko.utils.makeArray(templateNodes.cloneNode(true).childNodes);\n    } else {\n        var templateText = templateSource['text']();\n        return ko.utils.parseHtmlFragment(templateText, templateDocument);\n    }\n};\n\nko.nativeTemplateEngine.instance = new ko.nativeTemplateEngine();\nko.setTemplateEngine(ko.nativeTemplateEngine.instance);\n\nko.exportSymbol('nativeTemplateEngine', ko.nativeTemplateEngine);\n(function() {\n    ko.jqueryTmplTemplateEngine = function () {\n        // Detect which version of jquery-tmpl you're using. Unfortunately jquery-tmpl\n        // doesn't expose a version number, so we have to infer it.\n        // Note that as of Knockout 1.3, we only support jQuery.tmpl 1.0.0pre and later,\n        // which KO internally refers to as version \"2\", so older versions are no longer detected.\n        var jQueryTmplVersion = this.jQueryTmplVersion = (function() {\n            if (!jQueryInstance || !(jQueryInstance['tmpl']))\n                return 0;\n            // Since it exposes no official version number, we use our own numbering system. To be updated as jquery-tmpl evolves.\n            try {\n                if (jQueryInstance['tmpl']['tag']['tmpl']['open'].toString().indexOf('__') >= 0) {\n                    // Since 1.0.0pre, custom tags should append markup to an array called \"__\"\n                    return 2; // Final version of jquery.tmpl\n                }\n            } catch(ex) { /* Apparently not the version we were looking for */ }\n\n            return 1; // Any older version that we don't support\n        })();\n\n        function ensureHasReferencedJQueryTemplates() {\n            if (jQueryTmplVersion < 2)\n                throw new Error(\"Your version of jQuery.tmpl is too old. Please upgrade to jQuery.tmpl 1.0.0pre or later.\");\n        }\n\n        function executeTemplate(compiledTemplate, data, jQueryTemplateOptions) {\n            return jQueryInstance['tmpl'](compiledTemplate, data, jQueryTemplateOptions);\n        }\n\n        this['renderTemplateSource'] = function(templateSource, bindingContext, options, templateDocument) {\n            templateDocument = templateDocument || document;\n            options = options || {};\n            ensureHasReferencedJQueryTemplates();\n\n            // Ensure we have stored a precompiled version of this template (don't want to reparse on every render)\n            var precompiled = templateSource['data']('precompiled');\n            if (!precompiled) {\n                var templateText = templateSource['text']() || \"\";\n                // Wrap in \"with($whatever.koBindingContext) { ... }\"\n                templateText = \"{{ko_with $item.koBindingContext}}\" + templateText + \"{{/ko_with}}\";\n\n                precompiled = jQueryInstance['template'](null, templateText);\n                templateSource['data']('precompiled', precompiled);\n            }\n\n            var data = [bindingContext['$data']]; // Prewrap the data in an array to stop jquery.tmpl from trying to unwrap any arrays\n            var jQueryTemplateOptions = jQueryInstance['extend']({ 'koBindingContext': bindingContext }, options['templateOptions']);\n\n            var resultNodes = executeTemplate(precompiled, data, jQueryTemplateOptions);\n            resultNodes['appendTo'](templateDocument.createElement(\"div\")); // Using \"appendTo\" forces jQuery/jQuery.tmpl to perform necessary cleanup work\n\n            jQueryInstance['fragments'] = {}; // Clear jQuery's fragment cache to avoid a memory leak after a large number of template renders\n            return resultNodes;\n        };\n\n        this['createJavaScriptEvaluatorBlock'] = function(script) {\n            return \"{{ko_code ((function() { return \" + script + \" })()) }}\";\n        };\n\n        this['addTemplate'] = function(templateName, templateMarkup) {\n            document.write(\"<script type='text/html' id='\" + templateName + \"'>\" + templateMarkup + \"<\" + \"/script>\");\n        };\n\n        if (jQueryTmplVersion > 0) {\n            jQueryInstance['tmpl']['tag']['ko_code'] = {\n                open: \"__.push($1 || '');\"\n            };\n            jQueryInstance['tmpl']['tag']['ko_with'] = {\n                open: \"with($1) {\",\n                close: \"} \"\n            };\n        }\n    };\n\n    ko.jqueryTmplTemplateEngine.prototype = new ko.templateEngine();\n    ko.jqueryTmplTemplateEngine.prototype.constructor = ko.jqueryTmplTemplateEngine;\n\n    // Use this one by default *only if jquery.tmpl is referenced*\n    var jqueryTmplTemplateEngineInstance = new ko.jqueryTmplTemplateEngine();\n    if (jqueryTmplTemplateEngineInstance.jQueryTmplVersion > 0)\n        ko.setTemplateEngine(jqueryTmplTemplateEngineInstance);\n\n    ko.exportSymbol('jqueryTmplTemplateEngine', ko.jqueryTmplTemplateEngine);\n})();\n}));\n}());\n})();\n","Magento_AdminAnalytics/js/modal/component.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'Magento_Ui/js/modal/modal-component',\n    'uiRegistry',\n    'analyticsPopupConfig'\n],\n    function (_, $, Modal, registry, analyticsPopupConfig) {\n        'use strict';\n\n        return Modal.extend(\n            {\n                defaults: {\n                    imports: {\n                        enableLogAction: '${ $.provider }:data.enableLogAction',\n                        disableLogAction: '${ $.provider }:data.disableLogAction'\n                    },\n                    options: {\n                        keyEventHandlers: {\n                            /**\n                             * Prevents escape key from exiting out of modal\n                             */\n                            escapeKey: function () {\n                                return;\n                            }\n                        }\n                    },\n                    notificationWindow: null\n                },\n\n                /**\n                 * Initializes modal on opened function\n                 */\n                initModal: function () {\n                    this.options.opened = this.onOpened.bind(this);\n                    this._super();\n                },\n\n                /**\n                 * Once the modal is opened it hides the X\n                 */\n                onOpened: function () {\n                    $('.modal-header button.action-close').hide();\n                },\n\n                /**\n                 * Changes admin usage setting to yes\n                 */\n                enableAdminUsage: function () {\n                    var data = {\n                        'form_key': window.FORM_KEY\n                    };\n\n                    $.ajax(\n                        {\n                            type: 'POST',\n                            url: this.enableLogAction,\n                            data: data,\n                            showLoader: true\n                        }\n                    ).done(\n                        function (xhr) {\n                            if (xhr.error) {\n                                self.onError(xhr);\n                            }\n                        }\n                    ).fail(this.onError);\n                    this.openReleasePopup();\n                    this.closeModal();\n                },\n\n                /**\n                 * Changes admin usage setting to no\n                 */\n                disableAdminUsage: function () {\n                    var data = {\n                        'form_key': window.FORM_KEY\n                    };\n\n                    $.ajax(\n                        {\n                            type: 'POST',\n                            url: this.disableLogAction,\n                            data: data,\n                            showLoader: true\n                        }\n                    ).done(\n                        function (xhr) {\n                            if (xhr.error) {\n                                self.onError(xhr);\n                            }\n                        }\n                    ).fail(this.onError);\n                    this.openReleasePopup();\n                    this.closeModal();\n                },\n\n                /**\n                 * Allows admin usage popup to be shown first and then new release notification\n                 */\n                openReleasePopup: function () {\n                    var notifiModal = registry.get('release_notification.release_notification.notification_modal_1');\n\n                    if (analyticsPopupConfig.releaseVisible) {\n                        notifiModal.initializeContentAfterAnalytics();\n                    }\n                }\n            }\n        );\n    }\n);\n","Magento_AdminAnalytics/js/release-notification/modal/component-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery', 'analyticsPopupConfig'], function ($, analyticsPopupConfig) {\n    'use strict';\n\n    var deferred = $.Deferred(),\n\n        mixin = {\n        /**\n         * Initializes content only if its visible\n         */\n        initializeContent: function () {\n            var initializeContent = this._super.bind(this);\n\n            if (!analyticsPopupConfig.analyticsVisible) {\n                initializeContent();\n            } else {\n                deferred.then(function () {\n                    initializeContent();\n                });\n            }\n        },\n\n        /**\n         * Initializes release notification content after admin analytics\n         */\n        initializeContentAfterAnalytics: function () {\n            deferred.resolve();\n        }\n    };\n\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n\n","Magento_Customer/edit/post-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'mage/translate'\n], function ($, confirm) {\n    'use strict';\n\n    /**\n     * @param {String} url\n     * @returns {Object}\n     */\n    function getForm(url) {\n        return $('<form>', {\n            'action': url,\n            'method': 'POST'\n        }).append($('<input>', {\n            'name': 'form_key',\n            'value': window.FORM_KEY,\n            'type': 'hidden'\n        }));\n    }\n\n    $('#customer-edit-delete-button').click(function () {\n        var msg = $.mage.__('Are you sure you want to do this?'),\n            url = $('#customer-edit-delete-button').data('url');\n\n        confirm({\n            'content': msg,\n            'actions': {\n\n                /**\n                 * 'Confirm' action handler.\n                 */\n                confirm: function () {\n                    getForm(url).appendTo('body').submit();\n                }\n            }\n        });\n\n        return false;\n    });\n});\n","Magento_Customer/edit/tab/js/addresses.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/confirm',\n    'jquery/ui',\n    'mage/backend/tabs'\n], function ($, mageTemplate, confirm) {\n    'use strict';\n\n    $.widget('mage.addressTabs', $.mage.tabs, {\n        options: {\n            itemCount: 0,\n            baseItemId: 'new_item',\n            templatePrefix: '_templatePrefix_',\n            regionsUrl: null,\n            defaultCountries: [],\n            optionalZipCountries: [],\n            requiredStateForCountries: [],\n            deleteConfirmPrompt: '',\n            formTemplateSelector: '[data-template=\"address-form\"]',\n            tabTemplateSelector: '[data-template=\"address-tab\"]',\n            tabAddressTemplateSelector: '[data-template=\"tab-address-content\"]',\n            formsSelector: '[data-container=\"address-forms\"]',\n            addAddressSelector: '[data-container=\"add-address\"]',\n            formFirstNameSelector: ':input' +\n                '[data-ui-id=\"adminhtml-edit-tab-addresses-fieldset-element-text-address-template-firstname\"]',\n            accountFirstNameSelector: ':input' +\n                '[data-ui-id=\"adminhtml-edit-tab-account-fieldset-element-text-account-firstname\"]',\n            formLastNameSelector: ':input' +\n                '[data-ui-id=\"adminhtml-edit-tab-addresses-fieldset-element-text-address-template-lastname\"]',\n            accountLastNameSelector: ':input' +\n                '[data-ui-id=\"adminhtml-edit-tab-account-fieldset-element-text-account-lastname\"]',\n            accountWebsiteIdSelector: ':input' +\n                '[data-ui-id=\"store-switcher-form-renderer-fieldset-element-select-account-website-id\"]',\n            formCountrySelector: 'customer-edit-tab-addresses-fieldset-element-form-field-country-id',\n            addAddressButtonSelector: ':button[data-ui-id=\"adminhtml-edit-tab-addresses-add-address-button\"]'\n        },\n\n        /**\n         * This method adds a new address - tab and form to the widget.\n         */\n        _addNewAddress: function () {\n            var formName, newForm, formTemplate, itemTemplate, firstname, accountWebsiteId;\n\n            this.options.itemCount++;\n\n            // prevent duplication of ids\n            while (this.element.find('div[data-item=' + this.options.itemCount + ']').length) {\n                this.options.itemCount++;\n            }\n\n            formName = this.options.baseItemId + this.options.itemCount;\n            newForm = $('#form_' + formName);\n            formTemplate = this.element.find(this.options.formTemplateSelector).html();\n            itemTemplate = this.element.find(this.options.tabTemplateSelector).html();\n\n            formTemplate = mageTemplate(formTemplate, {\n                data: {\n                    formName: formName,\n                    itemCount: this.options.itemCount\n                }\n            });\n\n            itemTemplate = mageTemplate(itemTemplate, {\n                data: {\n                    'itemId': this.options.itemCount\n                }\n            });\n\n            this.element.find(this.options.formsSelector).append(this._prepareTemplate(formTemplate));\n\n            // add the new address to the tabs list before the add new action list\n            this.element.find(this.options.addAddressSelector).before(itemTemplate);\n\n            // refresh the widget to pick up the newly added tab.\n            this.refresh();\n\n            // activate the newly added tab\n            this.option('active', -1);\n\n            this.element.trigger('contentUpdated', $(formName));\n\n            // pre-fill form with account firstname, lastname, and country\n            firstname = newForm.find(this.options.formFirstNameSelector);\n            firstname.val($(this.options.accountFirstNameSelector).val());\n            newForm.find(this.options.formLastNameSelector).val($(this.options.accountLastNameSelector).val());\n\n            accountWebsiteId = $(this.options.accountWebsiteIdSelector).val();\n\n            if (accountWebsiteId !== '' && typeof this.options.defaultCountries[accountWebsiteId] !== 'undefined') {\n                newForm.find(this.options.formCountrySelector).val(this.options.defaultCountries[accountWebsiteId]);\n            }\n\n            // .val does not trigger change event, so manually trigger.\n            // (Triggering change of any field will handle update of all fields.)\n            firstname.trigger('change');\n\n            this._bindCountryRegionRelation(newForm);\n        },\n\n        /**\n         * This method is used to bind events associated with this widget.\n         */\n        _bind: function () {\n            this._on(this.element.find(this.options.addAddressButtonSelector), {\n                'click': '_addNewAddress'\n            });\n            this._on({\n                'formchange': '_updateAddress',\n                'dataItemDelete': '_deleteItemPrompt'\n            });\n            this.element.find('.countries').addressCountry({\n                regionsUrl: this.options.regionsUrl,\n                optionalZipCountries: this.options.optionalZipCountries,\n                requiredStateForCountries: this.options.requiredStateForCountries\n            });\n        },\n\n        /**\n         * Create, Initialize this widget.\n         */\n        _create: function () {\n            this._super();\n            this._bind();\n        },\n\n        /**\n         * This method deletes the item in the list.\n         * @private\n         */\n        _deleteItem: function (dataItem) {\n            // remove the elements from the page\n            this.element.find('[data-item=\"' + dataItem + '\"]').remove();\n\n            // refresh the widget to pick up the removed tab\n            this.refresh();\n        },\n\n        /**\n         * This method prompts the user to confirm the deletion of the item in the list.\n         * @private\n         */\n        _deleteItemPrompt: function (event, data) {\n            var self = this;\n\n            confirm({\n                content: this.options.deleteConfirmPrompt,\n                actions: {\n\n                    /** @inheritdoc */\n                    confirm: function () {\n                        self._deleteItem(data.item);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Initialize form template variables for the new address item.\n         * @param {Element} template - Address form html 'template'.\n         * @private\n         */\n        _prepareTemplate: function (template) {\n            var re = new RegExp(this.options.templatePrefix, 'g');\n\n            return template.replace(re, '_item' + this.options.itemCount);\n        },\n\n        /**\n         * This method is used to grab the data from the form and display it nicely.\n         * @param {Element} container - Address form container.\n         * @private\n         */\n        _syncFormData: function (container) {\n            var data = {},\n                itemContainer, tmpl;\n\n            if (container) {\n                $(container).find(':input').each(function (index, inputField) {\n                    var id = inputField.id,\n                        value, tagName, values, l, j, o, option, text;\n\n                    if (id) {\n                        id = id.replace(/^(_item)?[0-9]+/, '');\n                        id = id.replace(/^(id)?[0-9]+/, '');\n                        value = inputField.getValue();\n                        tagName = inputField.tagName.toLowerCase();\n\n                        if (tagName === 'select') {\n                            if (inputField.multiple) { //eslint-disable-line max-depth\n                                values = $([]);\n                                l = inputField.options.length;\n\n                                for (j = 0; j < l; j++) { //eslint-disable-line max-depth\n                                    o = inputField.options[j];\n\n                                    if (o.selected === true) { //eslint-disable-line max-depth\n                                        values[values.length] = o.text.escapeHTML();\n                                    }\n                                }\n                                data[id] = values.join(', ');\n                            } else {\n                                option = inputField.options[inputField.selectedIndex];\n                                text = option.value == '0' || option.value === '' ? '' : option.text; //eslint-disable-line\n                                data[id] = text.escapeHTML();\n                            }\n                        } else if (value !== null) {\n                            data[id] = value.escapeHTML();\n                        }\n                    }\n                });\n\n                // Set name of state to 'region' if list of states are in 'region_id' selectbox\n                if (!data.region && data['region_id']) {\n                    data.region = data['region_id'];\n                    delete data['region_id'];\n                }\n\n                // Set data to html\n                itemContainer = this.element.find('[aria-selected=\"true\"] address');\n\n                if (itemContainer.length && itemContainer[0]) {\n                    tmpl = mageTemplate(this.options.tabAddressTemplateSelector, {\n                        data: data\n                    });\n\n                    itemContainer[0].innerHTML = tmpl;\n                }\n            }\n        },\n\n        /**\n         * This method processes the event associated with a form field changing.\n         * @param {EventObject} event - Event occurring.\n         * @private\n         */\n        _updateAddress: function (event) {\n            this._syncFormData(this._getFormContainer(event.target));\n        },\n\n        /**\n         * This method returns the form containing this element.\n         * @param {JQuery|Element} element - JQuery object or DOM element.\n         * @private\n         */\n        _getFormContainer: function (element) {\n            if (!(element instanceof $)) {\n                element = $(element);\n            }\n\n            return element.closest('[data-item]');\n        },\n\n        /**\n         * This method binds a country element on the given form to the addressCountry widget.\n         * @param {JQuery} formElement - The form containing the country.\n         * @private\n         */\n        _bindCountryRegionRelation: function (formElement) {\n            $(formElement).find('.countries').addressCountry({\n                regionsUrl: this.options.regionsUrl,\n                optionalZipCountries: this.options.optionalZipCountries,\n                requiredStateForCountries: this.options.requiredStateForCountries\n            });\n        }\n    });\n\n    $.widget('mage.addressCountry', {\n        options: {\n            regionsUrl: null,\n            optionalZipCountries: [],\n            requiredStateForCountries: [],\n            countryElement: null,\n            regionIdElement: null,\n            regionElement: null\n        },\n\n        /**\n         * This method is used to bind events associated with this widget.\n         */\n        _bind: function () {\n            this._on({\n                'change': '_onAddressCountryChange'\n            });\n        },\n\n        /**\n         * Create, Initialize this widget.\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * This method updates country dependent fields; region input, and region and zipCode required indicator.\n         * @param {Event} event - Change event occurring.\n         * @private\n         */\n        _onAddressCountryChange: function (event) {\n            var countryElement = event.target,\n                formElement = $(countryElement).closest('[data-item]'),\n                fieldElement = $(formElement).find('.field-region'),\n                regionElement = $(fieldElement).find('.input-text');\n\n            this.options.countryElement = countryElement;\n\n            if ($(regionElement).prop('tagName').toLowerCase() === 'select') {\n                this.options.regionIdElement = regionElement;\n                this.options.regionElement = regionElement.next();\n            } else {\n                this.options.regionElement = regionElement;\n                this.options.regionIdElement = regionElement.next();\n            }\n\n            if (countryElement.value) {\n                // obtain regions for the country\n                $.ajax({\n                    url: this.options.regionsUrl,\n                    type: 'post',\n                    dataType: 'json',\n                    showLoader: true,\n                    data: {\n                        parent: countryElement.value\n                    },\n                    context: this,\n                    success: $.proxy(this._refreshRegionField, this)\n                });\n            } else {\n                // Set empty text field in region\n                this._refreshRegionField({});\n            }\n            // set Zip optional/required\n            this._setPostcodeOptional(countryElement);\n        },\n\n        /**\n         * This method updates the region input from the server response.\n         * @param {Object} data - Regions (state/province) or empty if regions n/a for the country.\n         * @private\n         */\n        _refreshRegionField: function (data) {\n            var regionField = $(this.options.regionElement).closest('div.field'),\n                regionControl = regionField.find('.control'),\n                regionInput,\n                regionIdInput,\n                newInput,\n                regionValue;\n\n            // clear current region input/select\n            regionControl.empty();\n\n            if (data.length) {\n                // Create visible selectbox 'region_id' and hidden 'region'\n                regionIdInput = $('<select>').attr({\n                    'name': this.options.regionIdElement.attr('name'),\n                    'id': this.options.regionIdElement.attr('id'),\n                    'class': 'required-entry input-text select',\n                    'title': this.options.regionIdElement.attr('title')\n                }).appendTo(regionControl);\n\n                regionValue = this.options.regionElement.attr('value');\n\n                $.each(data, function (idx, item) {\n                    var regionOption = $('<option />').val(item.value).text(item.label);\n\n                    if (regionValue && regionValue == item.label) { //eslint-disable-line eqeqeq\n                        regionOption.attr('selected', 'selected');\n                    }\n\n                    regionIdInput.append(regionOption);\n                });\n\n                regionInput = $('<input>').attr({\n                    'name': this.options.regionElement.attr('name'),\n                    'id': this.options.regionElement.attr('id'),\n                    'type': 'hidden'\n                }).appendTo(regionControl);\n\n                newInput = regionIdInput;\n            } else {\n                // Create visible text input 'region' and hidden 'region_id'\n                regionInput = $('<input>').attr({\n                    'type': 'text',\n                    'name': this.options.regionElement.attr('name'),\n                    'id': this.options.regionElement.attr('id'),\n                    'class': 'input-text',\n                    'title': this.options.regionElement.attr('title')\n                }).appendTo(regionControl);\n\n                regionIdInput = $('<input>').attr({\n                    'type': 'hidden',\n                    'name': this.options.regionIdElement.attr('name'),\n                    'id': this.options.regionIdElement.attr('id')\n                }).appendTo(regionControl);\n\n                newInput = regionInput;\n            }\n\n            this.options.regionElement = regionInput;\n            this.options.regionIdElement = regionIdInput;\n\n            // Updating in address info\n            this.element.trigger('formchange');\n\n            // bind region input change event\n            newInput.on('change', $.proxy(this._triggerFormChange, this, newInput));\n\n            this._checkRegionRequired([regionInput, regionIdInput], newInput, regionField);\n        },\n\n        /**\n         * This method is used to trigger a change element for a given element.\n         */\n        _triggerFormChange: function (element) {\n            element.trigger('formchange');\n        },\n\n        /**\n         * This method updates the region input required/optional and validation classes.\n         * @param {Array} elements - Region elements\n         * @param {Element} activeElement - Active Region element\n         * @param {Element} regionField - Region section element\n         * @private\n         */\n        _checkRegionRequired: function (elements, activeElement, regionField) {\n            var regionRequired = this.options.requiredStateForCountries.indexOf(this.options.countryElement.value) >= 0;\n\n            elements.each(function (currentElement) {\n                var form = $(currentElement).closest('form'),\n                    validationInstance = form ? $(form).data('validation') : null;\n\n                if (validationInstance) {\n                    validationInstance.clearError(currentElement);\n                }\n\n                if (!regionRequired) {\n                    if (regionField.hasClass('required')) {\n                        regionField.removeClass('required');\n                    }\n\n                    if (currentElement.hasClass('required-entry')) {\n                        currentElement.removeClass('required-entry');\n                    }\n\n                    if (currentElement.prop('tagName').toLowerCase() === 'select' &&\n                        currentElement.hasClass('validate-select')) {\n                        currentElement.removeClass('validate-select');\n                    }\n                } else {\n                    if (regionField.hasClass('required') === false) {\n                        regionField.addClass('required');\n                    }\n\n                    if (activeElement == currentElement) { //eslint-disable-line eqeqeq\n                        if (!currentElement.hasClass('required-entry')) { //eslint-disable-line max-depth\n                            currentElement.addClass('required-entry');\n                        }\n\n                        if (currentElement.prop('tagName').toLowerCase() === 'select' && //eslint-disable-line max-depth\n                            !currentElement.hasClass('validate-select')) {\n                            currentElement.addClass('validate-select');\n                        }\n                    }\n                }\n            });\n        },\n\n        /**\n         * This method shows/hides the zip/postalCode code required indicator.\n         * @param {Element} countryElement\n         * @private\n         */\n        _setPostcodeOptional: function (countryElement) {\n            var formElement = $(countryElement).closest('[data-item]'),\n                fieldElement = $(formElement).find('.field-postcode'),\n                zipElement = $(fieldElement).find('.input-text'),\n                zipField = $(zipElement).closest('.field-postcode');\n\n            if (this.options.optionalZipCountries.indexOf(countryElement.value) !== -1) {\n                if ($(zipElement).hasClass('required-entry')) {\n                    $(zipElement).removeClass('required-entry');\n                }\n                $(zipField).removeClass('required');\n            } else {\n                $(zipElement).addClass('required-entry');\n                $(zipField).addClass('required');\n            }\n        }\n    });\n\n    $.widget('mage.observableInputs', {\n        options: {\n            name: ''\n        },\n\n        /**\n         * This method is used to bind events associated with this widget.\n         */\n        _bind: function () {\n            this._on(this.element.find(':input').not('.countries'), {\n                'change': '_triggerChange'\n            });\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._super();\n            this._bind();\n        },\n\n        /**\n         * This method is used to trigger a change element for a given entity.\n         */\n        _triggerChange: function (element) {\n            // send the name of the captor and the field that changed\n            this.element.trigger('formchange', {\n                'name': this.options.name,\n                'element': element.target\n            });\n        }\n    });\n\n    /**\n     * This widget is used to trigger a message to delete a data item (i.e. D of CRUD).\n     */\n    $.widget('mage.dataItemDeleteButton', {\n        options: {\n            item: ''\n        },\n\n        /**\n         * This method is used to bind events associated with this widget.\n         */\n        _bind: function () {\n            this._on(this.element.find('[data-role=\"delete\"]'), {\n                'click': '_triggerDelete'\n            });\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var dataItemContainer;\n\n            this._super();\n            this._bind();\n\n            // if the item was not specified, find the data-item element wrapper\n            if (this.options.item.length === 0) {\n                dataItemContainer = this.element.parents('[data-item]');\n\n                if (dataItemContainer.length === 1) {\n                    this.options.item = dataItemContainer.attr('data-item');\n                }\n            }\n        },\n\n        /**\n         * This method is used to trigger a delete message for this item.\n         */\n        _triggerDelete: function () {\n            // send the name of the captor and the field that changed\n            this.element.trigger('dataItemDelete', {\n                'item': this.options.item\n            });\n\n            // we are handling the click, so stop processing\n            return false;\n        }\n    });\n\n    return {\n        addressTabs: $.mage.addressTabs,\n        addressCountry: $.mage.addressCountry,\n        observableInputs: $.mage.observableInputs,\n        dataItemDeleteButton: $.mage.dataItemDeleteButton\n    };\n});\n","Magento_Customer/js/address/default-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/button',\n    'underscore'\n], function (Button, _) {\n    'use strict';\n\n    return Button.extend({\n        defaults: {\n            entityId: null,\n            parentId: null,\n            listens: {\n                entity: 'changeVisibility'\n            }\n        },\n\n        /**\n         * Apply action on target component,\n         * but previously create this component from template if it is not existed\n         *\n         * @param {Object} action - action configuration\n         */\n        applyAction: function (action) {\n            if (action.params && action.params[0]) {\n                action.params[0]['entity_id'] = this.entityId;\n                action.params[0]['parent_id'] = this.parentId;\n            } else {\n                action.params = [{\n                    'entity_id': this.entityId,\n                    'parent_id': this.parentId\n                }];\n            }\n\n            this._super();\n        },\n\n        /**\n         * Change visibility of the default address shipping/billing blocks\n         *\n         * @param {Object} entity - customer address\n         */\n        changeVisibility: function (entity) {\n            this.visible(!_.isEmpty(entity));\n        }\n    });\n});\n","Magento_Customer/js/form/element/country.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/country'\n], function (Country) {\n    'use strict';\n\n    return Country.extend({\n        defaults: {\n            countryScope: 'data.country'\n        },\n\n        /**\n         * Set country to customer address form\n         *\n         * @param {String} value - country\n         */\n        setDifferedFromDefault: function (value) {\n            this._super();\n\n            if (value) {\n                this.source.set(this.countryScope, this.indexedOptions[value].label);\n            }\n        }\n    });\n});\n","Magento_Customer/js/form/element/region.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/region'\n], function (Region) {\n    'use strict';\n\n    return Region.extend({\n        defaults: {\n            regionScope: 'data.region'\n        },\n\n        /**\n         * Set region to customer address form\n         *\n         * @param {String} value - region\n         */\n        setDifferedFromDefault: function (value) {\n            this._super();\n\n            if (parseFloat(value)) {\n                this.source.set(this.regionScope, this.indexedOptions[value].label);\n            }\n        }\n    });\n});\n","Magento_Customer/js/form/components/insert-listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-listing',\n    'underscore'\n], function (Insert, _) {\n    'use strict';\n\n    return Insert.extend({\n\n        /**\n         * On action call\n         *\n         * @param {Object} data - customer address and actions\n         */\n        onAction: function (data) {\n            this[data.action + 'Action'].call(this, data.data);\n        },\n\n        /**\n         * On mass action call\n         *\n         * @param {Object} data - customer address\n         */\n        onMassAction: function (data) {\n            this[data.action + 'Massaction'].call(this, data.data);\n        },\n\n        /**\n         * Set default billing address\n         *\n         * @param {Object} data - customer address\n         */\n        setDefaultBillingAction: function (data) {\n            this.source.set('data.default_billing_address', data);\n        },\n\n        /**\n         * Set default shipping address\n         *\n         * @param {Object} data - customer address\n         */\n        setDefaultShippingAction: function (data) {\n            this.source.set('data.default_shipping_address', data);\n        },\n\n        /**\n         * Delete customer address\n         *\n         * @param {Object} data - customer address\n         */\n        deleteAction: function (data) {\n            this._delete([parseFloat(data[data['id_field_name']])]);\n        },\n\n        /**\n         * Mass action delete\n         *\n         * @param {Object} data - customer address\n         */\n        deleteMassaction: function (data) {\n            var ids = _.map(data, function (val) {\n                return parseFloat(val);\n            });\n\n            this._delete(ids);\n        },\n\n        /**\n         * Delete customer address by ids\n         *\n         * @param {Array} ids\n         */\n        _delete: function (ids) {\n            var defaultShippingId = parseFloat(this.source.get('data.default_shipping_address.entity_id')),\n                defaultBillingId = parseFloat(this.source.get('data.default_billing_address.entity_id'));\n\n            if (ids.indexOf(defaultShippingId) !== -1) {\n                this.source.set('data.default_shipping_address', []);\n            }\n\n            if (ids.indexOf(defaultBillingId) !== -1) {\n                this.source.set('data.default_billing_address', []);\n            }\n        }\n    });\n});\n","Magento_Customer/js/form/components/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/form/form',\n    'underscore',\n    'mage/translate'\n], function ($, uiAlert, uiConfirm, Form, _, $t) {\n    'use strict';\n\n    return Form.extend({\n        defaults: {\n            deleteConfirmationMessage: '',\n            ajaxSettings: {\n                method: 'POST',\n                dataType: 'json'\n            }\n        },\n\n        /**\n         * Delete customer address by provided url.\n         * Will call confirmation message to be sure that user is really wants to delete this address\n         *\n         * @param {String} url - ajax url\n         */\n        deleteAddress: function (url) {\n            var that = this;\n\n            uiConfirm({\n                content: this.deleteConfirmationMessage,\n                actions: {\n                    /** @inheritdoc */\n                    confirm: function () {\n                        that._delete(url);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Perform asynchronous DELETE request to server.\n         * @param {String} url - ajax url\n         * @returns {Deferred}\n         */\n        _delete: function (url) {\n            var settings = _.extend({}, this.ajaxSettings, {\n                    url: url,\n                    data: {\n                        'form_key': window.FORM_KEY\n                    }\n                }),\n                that = this;\n\n            $('body').trigger('processStart');\n\n            return $.ajax(settings)\n                .done(function (response) {\n                    if (response.error) {\n                        uiAlert({\n                            content: response.message\n                        });\n                    } else {\n                        that.trigger('deleteAddressAction', that.source.get('data.entity_id'));\n                    }\n                })\n                .fail(function () {\n                    uiAlert({\n                        content: $t('Sorry, there has been an error processing your request. Please try again later.')\n                    });\n                })\n                .always(function () {\n                    $('body').trigger('processStop');\n                });\n\n        }\n    });\n});\n","Magento_Customer/js/form/components/insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form'\n], function (Insert) {\n    'use strict';\n\n    return Insert.extend({\n        defaults: {\n            listens: {\n                responseData: 'onResponse'\n            },\n            modules: {\n                addressListing: '${ $.addressListingProvider }',\n                addressModal: '${ $.addressModalProvider }'\n            }\n        },\n\n        /**\n         * Close modal, reload customer address listing and save customer address\n         *\n         * @param {Object} responseData\n         */\n        onResponse: function (responseData) {\n            var data;\n\n            if (!responseData.error) {\n                this.addressModal().closeModal();\n                this.addressListing().reload({\n                    refresh: true\n                });\n                data = this.externalSource().get('data');\n                this.saveAddress(responseData, data);\n            }\n        },\n\n        /**\n         * Save customer address to customer form data source\n         *\n         * @param {Object} responseData\n         * @param {Object} data - customer address\n         */\n        saveAddress: function (responseData, data) {\n            data['entity_id'] = responseData.data['entity_id'];\n\n            if (parseFloat(data['default_billing'])) {\n                this.source.set('data.default_billing_address', data);\n            } else if (\n                parseFloat(this.source.get('data.default_billing_address')['entity_id']) === data['entity_id']\n            ) {\n                this.source.set('data.default_billing_address', []);\n            }\n\n            if (parseFloat(data['default_shipping'])) {\n                this.source.set('data.default_shipping_address', data);\n            } else if (\n                parseFloat(this.source.get('data.default_shipping_address')['entity_id']) === data['entity_id']\n            ) {\n                this.source.set('data.default_shipping_address', []);\n            }\n        },\n\n        /**\n         * Event method that closes \"Edit customer address\" modal and refreshes grid after customer address\n         * was removed through \"Delete\" button on the \"Edit customer address\" modal\n         *\n         * @param {String} id - customer address ID to delete\n         */\n        onAddressDelete: function (id) {\n            this.addressModal().closeModal();\n            this.addressListing().reload({\n                refresh: true\n            });\n            this.addressListing()._delete([parseFloat(id)]);\n        }\n    });\n});\n","Magento_Customer/js/grid/massactions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/massactions',\n    'Magento_Ui/js/modal/alert',\n    'underscore',\n    'jquery',\n    'mage/translate'\n], function (Massactions, uiAlert, _, $, $t) {\n    'use strict';\n\n    return Massactions.extend({\n        defaults: {\n            ajaxSettings: {\n                method: 'POST',\n                dataType: 'json'\n            },\n            listens: {\n                massaction: 'onAction'\n            }\n        },\n\n        /**\n         * Reload customer addresses listing\n         *\n         * @param {Object} data\n         */\n        onAction: function (data) {\n            if (data.action === 'delete') {\n                this.source.reload({\n                    refresh: true\n                });\n            }\n        },\n\n        /**\n         * Default action callback. Send selections data\n         * via POST request.\n         *\n         * @param {Object} action - Action data.\n         * @param {Object} data - Selections data.\n         */\n        defaultCallback: function (action, data) {\n            var itemsType, selections;\n\n            if (action.isAjax) {\n                itemsType = data.excludeMode ? 'excluded' : 'selected';\n                selections = {};\n\n                selections[itemsType] = data[itemsType];\n\n                if (!selections[itemsType].length) {\n                    selections[itemsType] = false;\n                }\n\n                _.extend(selections, data.params || {});\n\n                this.request(action.url, selections).done(function (response) {\n                    if (!response.error) {\n                        this.trigger('massaction', {\n                            action: action.type,\n                            data: selections\n                        });\n                    }\n                }.bind(this));\n            } else {\n                this._super();\n            }\n        },\n\n        /**\n         * Send customer address listing mass action ajax request\n         *\n         * @param {String} href\n         * @param {Object} data\n         */\n        request: function (href, data) {\n            var settings = _.extend({}, this.ajaxSettings, {\n                url: href,\n                data: data\n            });\n\n            $('body').trigger('processStart');\n\n            return $.ajax(settings)\n                .done(function (response) {\n                    if (response.error) {\n                        uiAlert({\n                            content: response.message\n                        });\n                    }\n                })\n                .fail(function () {\n                    uiAlert({\n                        content: $t('Sorry, there has been an error processing your request. Please try again later.')\n                    });\n                })\n                .always(function () {\n                    $('body').trigger('processStop');\n                });\n        }\n    });\n});\n","Magento_Customer/js/grid/filters/filters.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/filters/filters'\n], function (Filters) {\n    'use strict';\n\n    return Filters.extend({\n        defaults: {\n            chipsConfig: {\n                name: '${ $.name }_chips',\n                provider: '${ $.chipsConfig.name }',\n                component: 'Magento_Customer/js/grid/filters/chips'\n            }\n        }\n    });\n});\n","Magento_Customer/js/grid/filters/chips.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/filters/chips'\n], function (Chips) {\n    'use strict';\n\n    return Chips.extend({\n\n        /**\n         * Clear previous filters while initializing element to prevent filters sharing between customers\n         *\n         * @param {Object} elem\n         */\n        initElement: function (elem) {\n            this.clear();\n            this._super(elem);\n        }\n    });\n});\n","Magento_Customer/js/grid/columns/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/actions',\n    'Magento_Ui/js/modal/alert',\n    'underscore',\n    'jquery',\n    'mage/translate'\n], function (Actions, uiAlert, _, $, $t) {\n    'use strict';\n\n    return Actions.extend({\n        defaults: {\n            ajaxSettings: {\n                method: 'POST',\n                dataType: 'json'\n            },\n            listens: {\n                action: 'onAction'\n            },\n            ignoreTmpls: {\n                fieldAction: true,\n                options: true,\n                action: true\n            }\n        },\n\n        /**\n         * Reload customer address listing data source after customer address delete action\n         *\n         * @param {Object} data\n         */\n        onAction: function (data) {\n            if (data.action === 'delete') {\n                this.source().reload({\n                    refresh: true\n                });\n            }\n        },\n\n        /**\n         * Default action callback. Redirects to\n         * the specified in action's data url.\n         *\n         * @param {String} actionIndex - Action's identifier.\n         * @param {(Number|String)} recordId - Id of the record associated\n         *      with a specified action.\n         * @param {Object} action - Action's data.\n         */\n        defaultCallback: function (actionIndex, recordId, action) {\n            if (action.isAjax) {\n                this.request(action.href).done(function (response) {\n                    var data;\n\n                    if (!response.error) {\n                        data = _.findWhere(this.rows, {\n                            _rowIndex: action.rowIndex\n                        });\n\n                        this.trigger('action', {\n                            action: actionIndex,\n                            data: data\n                        });\n                    }\n                }.bind(this));\n\n            } else {\n                this._super();\n            }\n        },\n\n        /**\n         * Send customer address listing ajax request\n         *\n         * @param {String} href\n         */\n        request: function (href) {\n            var settings = _.extend({}, this.ajaxSettings, {\n                url: href,\n                data: {\n                    'form_key': window.FORM_KEY\n                }\n            });\n\n            $('body').trigger('processStart');\n\n            return $.ajax(settings)\n                .done(function (response) {\n                    if (response.error) {\n                        uiAlert({\n                            content: response.message\n                        });\n                    }\n                })\n                .fail(function () {\n                    uiAlert({\n                        content: $t('Sorry, there has been an error processing your request. Please try again later.')\n                    });\n                })\n                .always(function () {\n                    $('body').trigger('processStop');\n                });\n        }\n    });\n});\n","Magento_Customer/js/bootstrap/customer-post-action.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'Magento_Customer/edit/post-wrapper'\n]);\n","modernizr/modernizr.js":"/*!\n * Modernizr v2.6.1\n * www.modernizr.com\n *\n * Copyright (c) Faruk Ates, Paul Irish, Alex Sexton\n * Available under the BSD and MIT licenses: www.modernizr.com/license/\n */\n\n/*\n * Modernizr tests which native CSS3 and HTML5 features are available in\n * the current UA and makes the results available to you in two ways:\n * as properties on a global Modernizr object, and as classes on the\n * <html> element. This information allows you to progressively enhance\n * your pages with a granular level of control over the experience.\n *\n * Modernizr has an optional (not included) conditional resource loader\n * called Modernizr.load(), based on Yepnope.js (yepnopejs.com).\n * To get a build that includes Modernizr.load(), as well as choosing\n * which tests to include, go to www.modernizr.com/download/\n *\n * Authors        Faruk Ates, Paul Irish, Alex Sexton\n * Contributors   Ryan Seddon, Ben Alman\n */\n\nwindow.Modernizr = (function( window, document, undefined ) {\n\n    var version = '2.6.1',\n\n        Modernizr = {},\n\n    /*>>cssclasses*/\n    // option for enabling the HTML classes to be added\n        enableClasses = true,\n    /*>>cssclasses*/\n\n        docElement = document.documentElement,\n\n        /**\n         * Create our \"modernizr\" element that we do most feature tests on.\n         */\n            mod = 'modernizr',\n        modElem = document.createElement(mod),\n        mStyle = modElem.style,\n\n        /**\n         * Create the input element for various Web Forms feature tests.\n         */\n            inputElem /*>>inputelem*/ = document.createElement('input') /*>>inputelem*/ ,\n\n    /*>>smile*/\n        smile = ':)',\n    /*>>smile*/\n\n        toString = {}.toString,\n\n    // TODO :: make the prefixes more granular\n    /*>>prefixes*/\n    // List of property values to set for css tests. See ticket #21\n        prefixes = ' -webkit- -moz- -o- -ms- '.split(' '),\n    /*>>prefixes*/\n\n    /*>>domprefixes*/\n    // Following spec is to expose vendor-specific style properties as:\n    //   elem.style.WebkitBorderRadius\n    // and the following would be incorrect:\n    //   elem.style.webkitBorderRadius\n\n    // Webkit ghosts their properties in lowercase but Opera & Moz do not.\n    // Microsoft uses a lowercase `ms` instead of the correct `Ms` in IE8+\n    //   erik.eae.net/archives/2008/03/10/21.48.10/\n\n    // More here: github.com/Modernizr/Modernizr/issues/issue/21\n        omPrefixes = 'Webkit Moz O ms',\n\n        cssomPrefixes = omPrefixes.split(' '),\n\n        domPrefixes = omPrefixes.toLowerCase().split(' '),\n    /*>>domprefixes*/\n\n    /*>>ns*/\n        ns = {'svg': 'http://www.w3.org/2000/svg'},\n    /*>>ns*/\n\n        tests = {},\n        inputs = {},\n        attrs = {},\n\n        classes = [],\n\n        slice = classes.slice,\n\n        featureName, // used in testing loop\n\n\n    /*>>teststyles*/\n    // Inject element with style element and some CSS rules\n        injectElementWithStyles = function( rule, callback, nodes, testnames ) {\n\n            var style, ret, node,\n                div = document.createElement('div'),\n            // After page load injecting a fake body doesn't work so check if body exists\n                body = document.body,\n            // IE6 and 7 won't return offsetWidth or offsetHeight unless it's in the body element, so we fake it.\n                fakeBody = body ? body : document.createElement('body');\n\n            if ( parseInt(nodes, 10) ) {\n                // In order not to give false positives we create a node for each test\n                // This also allows the method to scale for unspecified uses\n                while ( nodes-- ) {\n                    node = document.createElement('div');\n                    node.id = testnames ? testnames[nodes] : mod + (nodes + 1);\n                    div.appendChild(node);\n                }\n            }\n\n            // <style> elements in IE6-9 are considered 'NoScope' elements and therefore will be removed\n            // when injected with innerHTML. To get around this you need to prepend the 'NoScope' element\n            // with a 'scoped' element, in our case the soft-hyphen entity as it won't mess with our measurements.\n            // msdn.microsoft.com/en-us/library/ms533897%28VS.85%29.aspx\n            // Documents served as xml will throw if using &shy; so use xml friendly encoded version. See issue #277\n            style = ['&#173;','<style id=\"s', mod, '\">', rule, '</style>'].join('');\n            div.id = mod;\n            // IE6 will false positive on some tests due to the style element inside the test div somehow interfering offsetHeight, so insert it into body or fakebody.\n            // Opera will act all quirky when injecting elements in documentElement when page is served as xml, needs fakebody too. #270\n            (body ? div : fakeBody).innerHTML += style;\n            fakeBody.appendChild(div);\n            if ( !body ) {\n                //avoid crashing IE8, if background image is used\n                fakeBody.style.background = \"\";\n                docElement.appendChild(fakeBody);\n            }\n\n            ret = callback(div, rule);\n            // If this is done after page load we don't want to remove the body so check if body exists\n            !body ? fakeBody.parentNode.removeChild(fakeBody) : div.parentNode.removeChild(div);\n\n            return !!ret;\n\n        },\n    /*>>teststyles*/\n\n    /*>>mq*/\n    // adapted from matchMedia polyfill\n    // by Scott Jehl and Paul Irish\n    // gist.github.com/786768\n        testMediaQuery = function( mq ) {\n\n            var matchMedia = window.matchMedia || window.msMatchMedia;\n            if ( matchMedia ) {\n                return matchMedia(mq).matches;\n            }\n\n            var bool;\n\n            injectElementWithStyles('@media ' + mq + ' { #' + mod + ' { position: absolute; } }', function( node ) {\n                bool = (window.getComputedStyle ?\n                    getComputedStyle(node, null) :\n                    node.currentStyle)['position'] == 'absolute';\n            });\n\n            return bool;\n\n        },\n    /*>>mq*/\n\n\n    /*>>hasevent*/\n    //\n    // isEventSupported determines if a given element supports the given event\n    // kangax.github.com/iseventsupported/\n    //\n    // The following results are known incorrect:\n    //   Modernizr.hasEvent(\"webkitTransitionEnd\", elem) // false negative\n    //   Modernizr.hasEvent(\"textInput\") // in Webkit. github.com/Modernizr/Modernizr/issues/333\n    //   ...\n        isEventSupported = (function() {\n\n            var TAGNAMES = {\n                'select': 'input', 'change': 'input',\n                'submit': 'form', 'reset': 'form',\n                'error': 'img', 'load': 'img', 'abort': 'img'\n            };\n\n            function isEventSupported( eventName, element ) {\n\n                element = element || document.createElement(TAGNAMES[eventName] || 'div');\n                eventName = 'on' + eventName;\n\n                // When using `setAttribute`, IE skips \"unload\", WebKit skips \"unload\" and \"resize\", whereas `in` \"catches\" those\n                var isSupported = eventName in element;\n\n                if ( !isSupported ) {\n                    // If it has no `setAttribute` (i.e. doesn't implement Node interface), try generic element\n                    if ( !element.setAttribute ) {\n                        element = document.createElement('div');\n                    }\n                    if ( element.setAttribute && element.removeAttribute ) {\n                        element.setAttribute(eventName, '');\n                        isSupported = is(element[eventName], 'function');\n\n                        // If property was created, \"remove it\" (by setting value to `undefined`)\n                        if ( !is(element[eventName], 'undefined') ) {\n                            element[eventName] = undefined;\n                        }\n                        element.removeAttribute(eventName);\n                    }\n                }\n\n                element = null;\n                return isSupported;\n            }\n            return isEventSupported;\n        })(),\n    /*>>hasevent*/\n\n    // TODO :: Add flag for hasownprop ? didn't last time\n\n    // hasOwnProperty shim by kangax needed for Safari 2.0 support\n        _hasOwnProperty = ({}).hasOwnProperty, hasOwnProp;\n\n    if ( !is(_hasOwnProperty, 'undefined') && !is(_hasOwnProperty.call, 'undefined') ) {\n        hasOwnProp = function (object, property) {\n            return _hasOwnProperty.call(object, property);\n        };\n    }\n    else {\n        hasOwnProp = function (object, property) { /* yes, this can give false positives/negatives, but most of the time we don't care about those */\n            return ((property in object) && is(object.constructor.prototype[property], 'undefined'));\n        };\n    }\n\n    // Adapted from ES5-shim https://github.com/kriskowal/es5-shim/blob/master/es5-shim.js\n    // es5.github.com/#x15.3.4.5\n\n    if (!Function.prototype.bind) {\n        Function.prototype.bind = function bind(that) {\n\n            var target = this;\n\n            if (typeof target != \"function\") {\n                throw new TypeError();\n            }\n\n            var args = slice.call(arguments, 1),\n                bound = function () {\n\n                    if (this instanceof bound) {\n\n                        var F = function(){};\n                        F.prototype = target.prototype;\n                        var self = new F();\n\n                        var result = target.apply(\n                            self,\n                            args.concat(slice.call(arguments))\n                        );\n                        if (Object(result) === result) {\n                            return result;\n                        }\n                        return self;\n\n                    } else {\n\n                        return target.apply(\n                            that,\n                            args.concat(slice.call(arguments))\n                        );\n\n                    }\n\n                };\n\n            return bound;\n        };\n    }\n\n    /**\n     * setCss applies given styles to the Modernizr DOM node.\n     */\n    function setCss( str ) {\n        mStyle.cssText = str;\n    }\n\n    /**\n     * setCssAll extrapolates all vendor-specific css strings.\n     */\n    function setCssAll( str1, str2 ) {\n        return setCss(prefixes.join(str1 + ';') + ( str2 || '' ));\n    }\n\n    /**\n     * is returns a boolean for if typeof obj is exactly type.\n     */\n    function is( obj, type ) {\n        return typeof obj === type;\n    }\n\n    /**\n     * contains returns a boolean for if substr is found within str.\n     */\n    function contains( str, substr ) {\n        return !!~('' + str).indexOf(substr);\n    }\n\n    /*>>testprop*/\n\n    // testProps is a generic CSS / DOM property test.\n\n    // In testing support for a given CSS property, it's legit to test:\n    //    `elem.style[styleName] !== undefined`\n    // If the property is supported it will return an empty string,\n    // if unsupported it will return undefined.\n\n    // We'll take advantage of this quick test and skip setting a style\n    // on our modernizr element, but instead just testing undefined vs\n    // empty string.\n\n    // Because the testing of the CSS property names (with \"-\", as\n    // opposed to the camelCase DOM properties) is non-portable and\n    // non-standard but works in WebKit and IE (but not Gecko or Opera),\n    // we explicitly reject properties with dashes so that authors\n    // developing in WebKit or IE first don't end up with\n    // browser-specific content by accident.\n\n    function testProps( props, prefixed ) {\n        for ( var i in props ) {\n            var prop = props[i];\n            if ( !contains(prop, \"-\") && mStyle[prop] !== undefined ) {\n                return prefixed == 'pfx' ? prop : true;\n            }\n        }\n        return false;\n    }\n    /*>>testprop*/\n\n    // TODO :: add testDOMProps\n    /**\n     * testDOMProps is a generic DOM property test; if a browser supports\n     *   a certain property, it won't return undefined for it.\n     */\n    function testDOMProps( props, obj, elem ) {\n        for ( var i in props ) {\n            var item = obj[props[i]];\n            if ( item !== undefined) {\n\n                // return the property name as a string\n                if (elem === false) return props[i];\n\n                // let's bind a function\n                if (is(item, 'function')){\n                    // default to autobind unless override\n                    return item.bind(elem || obj);\n                }\n\n                // return the unbound function or obj or value\n                return item;\n            }\n        }\n        return false;\n    }\n\n    /*>>testallprops*/\n    /**\n     * testPropsAll tests a list of DOM properties we want to check against.\n     *   We specify literally ALL possible (known and/or likely) properties on\n     *   the element including the non-vendor prefixed one, for forward-\n     *   compatibility.\n     */\n    function testPropsAll( prop, prefixed, elem ) {\n\n        var ucProp  = prop.charAt(0).toUpperCase() + prop.slice(1),\n            props   = (prop + ' ' + cssomPrefixes.join(ucProp + ' ') + ucProp).split(' ');\n\n        // did they call .prefixed('boxSizing') or are we just testing a prop?\n        if(is(prefixed, \"string\") || is(prefixed, \"undefined\")) {\n            return testProps(props, prefixed);\n\n            // otherwise, they called .prefixed('requestAnimationFrame', window[, elem])\n        } else {\n            props = (prop + ' ' + (domPrefixes).join(ucProp + ' ') + ucProp).split(' ');\n            return testDOMProps(props, prefixed, elem);\n        }\n    }\n    /*>>testallprops*/\n\n\n    /**\n     * Tests\n     * -----\n     */\n\n        // The *new* flexbox\n        // dev.w3.org/csswg/css3-flexbox\n\n    tests['flexbox'] = function() {\n        return testPropsAll('flexWrap');\n    };\n\n    // The *old* flexbox\n    // www.w3.org/TR/2009/WD-css3-flexbox-20090723/\n\n    tests['flexboxlegacy'] = function() {\n        return testPropsAll('boxDirection');\n    };\n\n    // On the S60 and BB Storm, getContext exists, but always returns undefined\n    // so we actually have to call getContext() to verify\n    // github.com/Modernizr/Modernizr/issues/issue/97/\n\n    tests['canvas'] = function() {\n        var elem = document.createElement('canvas');\n        return !!(elem.getContext && elem.getContext('2d'));\n    };\n\n    tests['canvastext'] = function() {\n        return !!(Modernizr['canvas'] && is(document.createElement('canvas').getContext('2d').fillText, 'function'));\n    };\n\n    // webk.it/70117 is tracking a legit WebGL feature detect proposal\n\n    // We do a soft detect which may false positive in order to avoid\n    // an expensive context creation: bugzil.la/732441\n\n    tests['webgl'] = function() {\n        return !!window.WebGLRenderingContext;\n    };\n\n    /*\n     * The Modernizr.touch test only indicates if the browser supports\n     *    touch events, which does not necessarily reflect a touchscreen\n     *    device, as evidenced by tablets running Windows 7 or, alas,\n     *    the Palm Pre / WebOS (touch) phones.\n     *\n     * Additionally, Chrome (desktop) used to lie about its support on this,\n     *    but that has since been rectified: crbug.com/36415\n     *\n     * We also test for Firefox 4 Multitouch Support.\n     *\n     * For more info, see: modernizr.github.com/Modernizr/touch.html\n     */\n\n    tests['touch'] = function() {\n        var bool;\n\n        if(('ontouchstart' in window) || window.DocumentTouch && document instanceof DocumentTouch) {\n            bool = true;\n        } else {\n            injectElementWithStyles(['@media (',prefixes.join('touch-enabled),('),mod,')','{#modernizr{top:9px;position:absolute}}'].join(''), function( node ) {\n                bool = node.offsetTop === 9;\n            });\n        }\n\n        return bool;\n    };\n\n\n    // geolocation is often considered a trivial feature detect...\n    // Turns out, it's quite tricky to get right:\n    //\n    // Using !!navigator.geolocation does two things we don't want. It:\n    //   1. Leaks memory in IE9: github.com/Modernizr/Modernizr/issues/513\n    //   2. Disables page caching in WebKit: webk.it/43956\n    //\n    // Meanwhile, in Firefox < 8, an about:config setting could expose\n    // a false positive that would throw an exception: bugzil.la/688158\n\n    tests['geolocation'] = function() {\n        return 'geolocation' in navigator;\n    };\n\n\n    tests['postmessage'] = function() {\n        return !!window.postMessage;\n    };\n\n\n    // Chrome incognito mode used to throw an exception when using openDatabase\n    // It doesn't anymore.\n    tests['websqldatabase'] = function() {\n        return !!window.openDatabase;\n    };\n\n    // Vendors had inconsistent prefixing with the experimental Indexed DB:\n    // - Webkit's implementation is accessible through webkitIndexedDB\n    // - Firefox shipped moz_indexedDB before FF4b9, but since then has been mozIndexedDB\n    // For speed, we don't test the legacy (and beta-only) indexedDB\n    tests['indexedDB'] = function() {\n        return !!testPropsAll(\"indexedDB\", window);\n    };\n\n    // documentMode logic from YUI to filter out IE8 Compat Mode\n    //   which false positives.\n    tests['hashchange'] = function() {\n        return isEventSupported('hashchange', window) && (document.documentMode === undefined || document.documentMode > 7);\n    };\n\n    // Per 1.6:\n    // This used to be Modernizr.historymanagement but the longer\n    // name has been deprecated in favor of a shorter and property-matching one.\n    // The old API is still available in 1.6, but as of 2.0 will throw a warning,\n    // and in the first release thereafter disappear entirely.\n    tests['history'] = function() {\n        return !!(window.history && history.pushState);\n    };\n\n    tests['draganddrop'] = function() {\n        var div = document.createElement('div');\n        return ('draggable' in div) || ('ondragstart' in div && 'ondrop' in div);\n    };\n\n    // FF3.6 was EOL'ed on 4/24/12, but the ESR version of FF10\n    // will be supported until FF19 (2/12/13), at which time, ESR becomes FF17.\n    // FF10 still uses prefixes, so check for it until then.\n    // for more ESR info, see: mozilla.org/en-US/firefox/organizations/faq/\n    tests['websockets'] = function() {\n        return 'WebSocket' in window || 'MozWebSocket' in window;\n    };\n\n\n    // css-tricks.com/rgba-browser-support/\n    tests['rgba'] = function() {\n        // Set an rgba() color and check the returned value\n\n        setCss('background-color:rgba(150,255,150,.5)');\n\n        return contains(mStyle.backgroundColor, 'rgba');\n    };\n\n    tests['hsla'] = function() {\n        // Same as rgba(), in fact, browsers re-map hsla() to rgba() internally,\n        //   except IE9 who retains it as hsla\n\n        setCss('background-color:hsla(120,40%,100%,.5)');\n\n        return contains(mStyle.backgroundColor, 'rgba') || contains(mStyle.backgroundColor, 'hsla');\n    };\n\n    tests['multiplebgs'] = function() {\n        // Setting multiple images AND a color on the background shorthand property\n        //  and then querying the style.background property value for the number of\n        //  occurrences of \"url(\" is a reliable method for detecting ACTUAL support for this!\n\n        setCss('background:url(https://),url(https://),red url(https://)');\n\n        // If the UA supports multiple backgrounds, there should be three occurrences\n        //   of the string \"url(\" in the return value for elemStyle.background\n\n        return (/(url\\s*\\(.*?){3}/).test(mStyle.background);\n    };\n\n\n\n    // this will false positive in Opera Mini\n    //   github.com/Modernizr/Modernizr/issues/396\n\n    tests['backgroundsize'] = function() {\n        return testPropsAll('backgroundSize');\n    };\n\n    tests['borderimage'] = function() {\n        return testPropsAll('borderImage');\n    };\n\n\n    // Super comprehensive table about all the unique implementations of\n    // border-radius: muddledramblings.com/table-of-css3-border-radius-compliance\n\n    tests['borderradius'] = function() {\n        return testPropsAll('borderRadius');\n    };\n\n    // WebOS unfortunately false positives on this test.\n    tests['boxshadow'] = function() {\n        return testPropsAll('boxShadow');\n    };\n\n    // FF3.0 will false positive on this test\n    tests['textshadow'] = function() {\n        return document.createElement('div').style.textShadow === '';\n    };\n\n\n    tests['opacity'] = function() {\n        // Browsers that actually have CSS Opacity implemented have done so\n        //  according to spec, which means their return values are within the\n        //  range of [0.0,1.0] - including the leading zero.\n\n        setCssAll('opacity:.55');\n\n        // The non-literal . in this regex is intentional:\n        //   German Chrome returns this value as 0,55\n        // github.com/Modernizr/Modernizr/issues/#issue/59/comment/516632\n        return (/^0.55$/).test(mStyle.opacity);\n    };\n\n\n    // Note, Android < 4 will pass this test, but can only animate\n    //   a single property at a time\n    //   daneden.me/2011/12/putting-up-with-androids-bullshit/\n    tests['cssanimations'] = function() {\n        return testPropsAll('animationName');\n    };\n\n\n    tests['csscolumns'] = function() {\n        return testPropsAll('columnCount');\n    };\n\n\n    tests['cssgradients'] = function() {\n        /**\n         * For CSS Gradients syntax, please see:\n         * webkit.org/blog/175/introducing-css-gradients/\n         * developer.mozilla.org/en/CSS/-moz-linear-gradient\n         * developer.mozilla.org/en/CSS/-moz-radial-gradient\n         * dev.w3.org/csswg/css3-images/#gradients-\n         */\n\n        var str1 = 'background-image:',\n            str2 = 'gradient(linear,left top,right bottom,from(#9f9),to(white));',\n            str3 = 'linear-gradient(left top,#9f9, white);';\n\n        setCss(\n            // legacy webkit syntax (FIXME: remove when syntax not in use anymore)\n            (str1 + '-webkit- '.split(' ').join(str2 + str1) +\n                // standard syntax             // trailing 'background-image:'\n                prefixes.join(str3 + str1)).slice(0, -str1.length)\n        );\n\n        return contains(mStyle.backgroundImage, 'gradient');\n    };\n\n\n    tests['cssreflections'] = function() {\n        return testPropsAll('boxReflect');\n    };\n\n\n    tests['csstransforms'] = function() {\n        return !!testPropsAll('transform');\n    };\n\n\n    tests['csstransforms3d'] = function() {\n\n        var ret = !!testPropsAll('perspective');\n\n        // Webkit's 3D transforms are passed off to the browser's own graphics renderer.\n        //   It works fine in Safari on Leopard and Snow Leopard, but not in Chrome in\n        //   some conditions. As a result, Webkit typically recognizes the syntax but\n        //   will sometimes throw a false positive, thus we must do a more thorough check:\n        if ( ret && 'webkitPerspective' in docElement.style ) {\n\n            // Webkit allows this media query to succeed only if the feature is enabled.\n            // `@media (transform-3d),(-webkit-transform-3d){ ... }`\n            injectElementWithStyles('@media (transform-3d),(-webkit-transform-3d){#modernizr{left:9px;position:absolute;height:3px;}}', function( node, rule ) {\n                ret = node.offsetLeft === 9 && node.offsetHeight === 3;\n            });\n        }\n        return ret;\n    };\n\n\n    tests['csstransitions'] = function() {\n        return testPropsAll('transition');\n    };\n\n\n    /*>>fontface*/\n    // @font-face detection routine by Diego Perini\n    // javascript.nwbox.com/CSSSupport/\n\n    // false positives:\n    //   WebOS github.com/Modernizr/Modernizr/issues/342\n    //   WP7   github.com/Modernizr/Modernizr/issues/538\n    tests['fontface'] = function() {\n        var bool;\n\n        injectElementWithStyles('@font-face {font-family:\"font\";src:url(\"https://\")}', function( node, rule ) {\n            var style = document.getElementById('smodernizr'),\n                sheet = style.sheet || style.styleSheet,\n                cssText = sheet ? (sheet.cssRules && sheet.cssRules[0] ? sheet.cssRules[0].cssText : sheet.cssText || '') : '';\n\n            bool = /src/i.test(cssText) && cssText.indexOf(rule.split(' ')[0]) === 0;\n        });\n\n        return bool;\n    };\n    /*>>fontface*/\n\n    // CSS generated content detection\n    tests['generatedcontent'] = function() {\n        var bool;\n\n        injectElementWithStyles(['#modernizr:after{content:\"',smile,'\";visibility:hidden}'].join(''), function( node ) {\n            bool = node.offsetHeight >= 1;\n        });\n\n        return bool;\n    };\n\n\n\n    // These tests evaluate support of the video/audio elements, as well as\n    // testing what types of content they support.\n    //\n    // We're using the Boolean constructor here, so that we can extend the value\n    // e.g.  Modernizr.video     // true\n    //       Modernizr.video.ogg // 'probably'\n    //\n    // Codec values from : github.com/NielsLeenheer/html5test/blob/9106a8/index.html#L845\n    //                     thx to NielsLeenheer and zcorpan\n\n    // Note: in some older browsers, \"no\" was a return value instead of empty string.\n    //   It was live in FF3.5.0 and 3.5.1, but fixed in 3.5.2\n    //   It was also live in Safari 4.0.0 - 4.0.4, but fixed in 4.0.5\n\n    tests['video'] = function() {\n        var elem = document.createElement('video'),\n            bool = false;\n\n        // IE9 Running on Windows Server SKU can cause an exception to be thrown, bug #224\n        try {\n            if ( bool = !!elem.canPlayType ) {\n                bool      = new Boolean(bool);\n                bool.ogg  = elem.canPlayType('video/ogg; codecs=\"theora\"')      .replace(/^no$/,'');\n\n                // Without QuickTime, this value will be `undefined`. github.com/Modernizr/Modernizr/issues/546\n                bool.h264 = elem.canPlayType('video/mp4; codecs=\"avc1.42E01E\"') .replace(/^no$/,'');\n\n                bool.webm = elem.canPlayType('video/webm; codecs=\"vp8, vorbis\"').replace(/^no$/,'');\n            }\n\n        } catch(e) { }\n\n        return bool;\n    };\n\n    tests['audio'] = function() {\n        var elem = document.createElement('audio'),\n            bool = false;\n\n        try {\n            if ( bool = !!elem.canPlayType ) {\n                bool      = new Boolean(bool);\n                bool.ogg  = elem.canPlayType('audio/ogg; codecs=\"vorbis\"').replace(/^no$/,'');\n                bool.mp3  = elem.canPlayType('audio/mpeg;')               .replace(/^no$/,'');\n\n                // Mimetypes accepted:\n                //   developer.mozilla.org/En/Media_formats_supported_by_the_audio_and_video_elements\n                //   bit.ly/iphoneoscodecs\n                bool.wav  = elem.canPlayType('audio/wav; codecs=\"1\"')     .replace(/^no$/,'');\n                bool.m4a  = ( elem.canPlayType('audio/x-m4a;')            ||\n                    elem.canPlayType('audio/aac;'))             .replace(/^no$/,'');\n            }\n        } catch(e) { }\n\n        return bool;\n    };\n\n\n    // In FF4, if disabled, window.localStorage should === null.\n\n    // Normally, we could not test that directly and need to do a\n    //   `('localStorage' in window) && ` test first because otherwise Firefox will\n    //   throw bugzil.la/365772 if cookies are disabled\n\n    // Also in iOS5 Private Browsing mode, attempting to use localStorage.setItem\n    // will throw the exception:\n    //   QUOTA_EXCEEDED_ERRROR DOM Exception 22.\n    // Peculiarly, getItem and removeItem calls do not throw.\n\n    // Because we are forced to try/catch this, we'll go aggressive.\n\n    // Just FWIW: IE8 Compat mode supports these features completely:\n    //   www.quirksmode.org/dom/html5.html\n    // But IE8 doesn't support either with local files\n\n    tests['localstorage'] = function() {\n        try {\n            localStorage.setItem(mod, mod);\n            localStorage.removeItem(mod);\n            return true;\n        } catch(e) {\n            return false;\n        }\n    };\n\n    tests['sessionstorage'] = function() {\n        try {\n            sessionStorage.setItem(mod, mod);\n            sessionStorage.removeItem(mod);\n            return true;\n        } catch(e) {\n            return false;\n        }\n    };\n\n\n    tests['webworkers'] = function() {\n        return !!window.Worker;\n    };\n\n\n    tests['applicationcache'] = function() {\n        return !!window.applicationCache;\n    };\n\n\n    // Thanks to Erik Dahlstrom\n    tests['svg'] = function() {\n        return !!document.createElementNS && !!document.createElementNS(ns.svg, 'svg').createSVGRect;\n    };\n\n    // specifically for SVG inline in HTML, not within XHTML\n    // test page: paulirish.com/demo/inline-svg\n    tests['inlinesvg'] = function() {\n        var div = document.createElement('div');\n        div.innerHTML = '<svg/>';\n        return (div.firstChild && div.firstChild.namespaceURI) == ns.svg;\n    };\n\n    // SVG SMIL animation\n    tests['smil'] = function() {\n        return !!document.createElementNS && /SVGAnimate/.test(toString.call(document.createElementNS(ns.svg, 'animate')));\n    };\n\n    // This test is only for clip paths in SVG proper, not clip paths on HTML content\n    // demo: srufaculty.sru.edu/david.dailey/svg/newstuff/clipPath4.svg\n\n    // However read the comments to dig into applying SVG clippaths to HTML content here:\n    //   github.com/Modernizr/Modernizr/issues/213#issuecomment-1149491\n    tests['svgclippaths'] = function() {\n        return !!document.createElementNS && /SVGClipPath/.test(toString.call(document.createElementNS(ns.svg, 'clipPath')));\n    };\n\n    /*>>webforms*/\n    // input features and input types go directly onto the ret object, bypassing the tests loop.\n    // Hold this guy to execute in a moment.\n    function webforms() {\n        /*>>input*/\n        // Run through HTML5's new input attributes to see if the UA understands any.\n        // We're using f which is the <input> element created early on\n        // Mike Taylr has created a comprehensive resource for testing these attributes\n        //   when applied to all input types:\n        //   miketaylr.com/code/input-type-attr.html\n        // spec: www.whatwg.org/specs/web-apps/current-work/multipage/the-input-element.html#input-type-attr-summary\n\n        // Only input placeholder is tested while textarea's placeholder is not.\n        // Currently Safari 4 and Opera 11 have support only for the input placeholder\n        // Both tests are available in feature-detects/forms-placeholder.js\n        Modernizr['input'] = (function( props ) {\n            for ( var i = 0, len = props.length; i < len; i++ ) {\n                attrs[ props[i] ] = !!(props[i] in inputElem);\n            }\n            if (attrs.list){\n                // safari false positive's on datalist: webk.it/74252\n                // see also github.com/Modernizr/Modernizr/issues/146\n                attrs.list = !!(document.createElement('datalist') && window.HTMLDataListElement);\n            }\n            return attrs;\n        })('autocomplete autofocus list placeholder max min multiple pattern required step'.split(' '));\n        /*>>input*/\n\n        /*>>inputtypes*/\n        // Run through HTML5's new input types to see if the UA understands any.\n        //   This is put behind the tests runloop because it doesn't return a\n        //   true/false like all the other tests; instead, it returns an object\n        //   containing each input type with its corresponding true/false value\n\n        // Big thanks to @miketaylr for the html5 forms expertise. miketaylr.com/\n        Modernizr['inputtypes'] = (function(props) {\n\n            for ( var i = 0, bool, inputElemType, defaultView, len = props.length; i < len; i++ ) {\n\n                inputElem.setAttribute('type', inputElemType = props[i]);\n                bool = inputElem.type !== 'text';\n\n                // We first check to see if the type we give it sticks..\n                // If the type does, we feed it a textual value, which shouldn't be valid.\n                // If the value doesn't stick, we know there's input sanitization which infers a custom UI\n                if ( bool ) {\n\n                    inputElem.value         = smile;\n                    inputElem.style.cssText = 'position:absolute;visibility:hidden;';\n\n                    if ( /^range$/.test(inputElemType) && inputElem.style.WebkitAppearance !== undefined ) {\n\n                        docElement.appendChild(inputElem);\n                        defaultView = document.defaultView;\n\n                        // Safari 2-4 allows the smiley as a value, despite making a slider\n                        bool =  defaultView.getComputedStyle &&\n                            defaultView.getComputedStyle(inputElem, null).WebkitAppearance !== 'textfield' &&\n                            // Mobile android web browser has false positive, so must\n                            // check the height to see if the widget is actually there.\n                            (inputElem.offsetHeight !== 0);\n\n                        docElement.removeChild(inputElem);\n\n                    } else if ( /^(search|tel)$/.test(inputElemType) ){\n                        // Spec doesn't define any special parsing or detectable UI\n                        //   behaviors so we pass these through as true\n\n                        // Interestingly, opera fails the earlier test, so it doesn't\n                        //  even make it here.\n\n                    } else if ( /^(url|email)$/.test(inputElemType) ) {\n                        // Real url and email support comes with prebaked validation.\n                        bool = inputElem.checkValidity && inputElem.checkValidity() === false;\n\n                    } else {\n                        // If the upgraded input component rejects the :) text, we got a winner\n                        bool = inputElem.value != smile;\n                    }\n                }\n\n                inputs[ props[i] ] = !!bool;\n            }\n            return inputs;\n        })('search tel url email datetime date month week time datetime-local number range color'.split(' '));\n        /*>>inputtypes*/\n    }\n    /*>>webforms*/\n\n\n    // End of test definitions\n    // -----------------------\n\n\n\n    // Run through all tests and detect their support in the current UA.\n    // todo: hypothetically we could be doing an array of tests and use a basic loop here.\n    for ( var feature in tests ) {\n        if ( hasOwnProp(tests, feature) ) {\n            // run the test, throw the return value into the Modernizr,\n            //   then based on that boolean, define an appropriate className\n            //   and push it into an array of classes we'll join later.\n            featureName  = feature.toLowerCase();\n            Modernizr[featureName] = tests[feature]();\n\n            classes.push((Modernizr[featureName] ? '' : 'no-') + featureName);\n        }\n    }\n\n    /*>>webforms*/\n    // input tests need to run.\n    Modernizr.input || webforms();\n    /*>>webforms*/\n\n\n    /**\n     * addTest allows the user to define their own feature tests\n     * the result will be added onto the Modernizr object,\n     * as well as an appropriate className set on the html element\n     *\n     * @param feature - String naming the feature\n     * @param test - Function returning true if feature is supported, false if not\n     */\n    Modernizr.addTest = function ( feature, test ) {\n        if ( typeof feature == 'object' ) {\n            for ( var key in feature ) {\n                if ( hasOwnProp( feature, key ) ) {\n                    Modernizr.addTest( key, feature[ key ] );\n                }\n            }\n        } else {\n\n            feature = feature.toLowerCase();\n\n            if ( Modernizr[feature] !== undefined ) {\n                // we're going to quit if you're trying to overwrite an existing test\n                // if we were to allow it, we'd do this:\n                //   var re = new RegExp(\"\\\\b(no-)?\" + feature + \"\\\\b\");\n                //   docElement.className = docElement.className.replace( re, '' );\n                // but, no rly, stuff 'em.\n                return Modernizr;\n            }\n\n            test = typeof test == 'function' ? test() : test;\n\n            if (enableClasses) {\n                docElement.className += ' ' + (test ? '' : 'no-') + feature;\n            }\n            Modernizr[feature] = test;\n\n        }\n\n        return Modernizr; // allow chaining.\n    };\n\n\n    // Reset modElem.cssText to nothing to reduce memory footprint.\n    setCss('');\n    modElem = inputElem = null;\n\n    /*>>shiv*/\n    /*! HTML5 Shiv v3.6 | @afarkas @jdalton @jon_neal @rem | MIT/GPL2 Licensed */\n    ;(function(window, document) {\n        /*jshint evil:true */\n        /** Preset options */\n        var options = window.html5 || {};\n\n        /** Used to skip problem elements */\n        var reSkip = /^<|^(?:button|map|select|textarea|object|iframe|option|optgroup)$/i;\n\n        /** Not all elements can be cloned in IE (this list can be shortend) **/\n        var saveClones = /^<|^(?:a|b|button|code|div|fieldset|form|h1|h2|h3|h4|h5|h6|i|iframe|img|input|label|li|link|ol|option|p|param|q|script|select|span|strong|style|table|tbody|td|textarea|tfoot|th|thead|tr|ul)$/i;\n\n        /** Detect whether the browser supports default html5 styles */\n        var supportsHtml5Styles;\n\n        /** Name of the expando, to work with multiple documents or to re-shiv one document */\n        var expando = '_html5shiv';\n\n        /** The id for the documents expando */\n        var expanID = 0;\n\n        /** Cached data for each document */\n        var expandoData = {};\n\n        /** Detect whether the browser supports unknown elements */\n        var supportsUnknownElements;\n\n        (function() {\n            try {\n                var a = document.createElement('a');\n                a.innerHTML = '<xyz></xyz>';\n                //if the hidden property is implemented we can assume, that the browser supports basic HTML5 Styles\n                supportsHtml5Styles = ('hidden' in a);\n\n                supportsUnknownElements = a.childNodes.length == 1 || (function() {\n                    // assign a false positive if unable to shiv\n                    (document.createElement)('a');\n                    var frag = document.createDocumentFragment();\n                    return (\n                        typeof frag.cloneNode == 'undefined' ||\n                            typeof frag.createDocumentFragment == 'undefined' ||\n                            typeof frag.createElement == 'undefined'\n                        );\n                }());\n            } catch(e) {\n                supportsHtml5Styles = true;\n                supportsUnknownElements = true;\n            }\n\n        }());\n\n        /*--------------------------------------------------------------------------*/\n\n        /**\n         * Creates a style sheet with the given CSS text and adds it to the document.\n         * @private\n         * @param {Document} ownerDocument The document.\n         * @param {String} cssText The CSS text.\n         * @returns {StyleSheet} The style element.\n         */\n        function addStyleSheet(ownerDocument, cssText) {\n            var p = ownerDocument.createElement('p'),\n                parent = ownerDocument.getElementsByTagName('head')[0] || ownerDocument.documentElement;\n\n            p.innerHTML = 'x<style>' + cssText + '</style>';\n            return parent.insertBefore(p.lastChild, parent.firstChild);\n        }\n\n        /**\n         * Returns the value of `html5.elements` as an array.\n         * @private\n         * @returns {Array} An array of shived element node names.\n         */\n        function getElements() {\n            var elements = html5.elements;\n            return typeof elements == 'string' ? elements.split(' ') : elements;\n        }\n\n        /**\n         * Returns the data associated to the given document\n         * @private\n         * @param {Document} ownerDocument The document.\n         * @returns {Object} An object of data.\n         */\n        function getExpandoData(ownerDocument) {\n            var data = expandoData[ownerDocument[expando]];\n            if (!data) {\n                data = {};\n                expanID++;\n                ownerDocument[expando] = expanID;\n                expandoData[expanID] = data;\n            }\n            return data;\n        }\n\n        /**\n         * returns a shived element for the given nodeName and document\n         * @memberOf html5\n         * @param {String} nodeName name of the element\n         * @param {Document} ownerDocument The context document.\n         * @returns {Object} The shived element.\n         */\n        function createElement(nodeName, ownerDocument, data){\n            if (!ownerDocument) {\n                ownerDocument = document;\n            }\n            if(supportsUnknownElements){\n                return ownerDocument.createElement(nodeName);\n            }\n            if (!data) {\n                data = getExpandoData(ownerDocument);\n            }\n            var node;\n\n            if (data.cache[nodeName]) {\n                node = data.cache[nodeName].cloneNode();\n            } else if (saveClones.test(nodeName)) {\n                node = (data.cache[nodeName] = data.createElem(nodeName)).cloneNode();\n            } else {\n                node = data.createElem(nodeName);\n            }\n\n            // Avoid adding some elements to fragments in IE < 9 because\n            // * Attributes like `name` or `type` cannot be set/changed once an element\n            //   is inserted into a document/fragment\n            // * Link elements with `src` attributes that are inaccessible, as with\n            //   a 403 response, will cause the tab/window to crash\n            // * Script elements appended to fragments will execute when their `src`\n            //   or `text` property is set\n            return node.canHaveChildren && !reSkip.test(nodeName) ? data.frag.appendChild(node) : node;\n        }\n\n        /**\n         * returns a shived DocumentFragment for the given document\n         * @memberOf html5\n         * @param {Document} ownerDocument The context document.\n         * @returns {Object} The shived DocumentFragment.\n         */\n        function createDocumentFragment(ownerDocument, data){\n            if (!ownerDocument) {\n                ownerDocument = document;\n            }\n            if(supportsUnknownElements){\n                return ownerDocument.createDocumentFragment();\n            }\n            data = data || getExpandoData(ownerDocument);\n            var clone = data.frag.cloneNode(),\n                i = 0,\n                elems = getElements(),\n                l = elems.length;\n            for(;i<l;i++){\n                clone.createElement(elems[i]);\n            }\n            return clone;\n        }\n\n        /**\n         * Shivs the `createElement` and `createDocumentFragment` methods of the document.\n         * @private\n         * @param {Document|DocumentFragment} ownerDocument The document.\n         * @param {Object} data of the document.\n         */\n        function shivMethods(ownerDocument, data) {\n            if (!data.cache) {\n                data.cache = {};\n                data.createElem = ownerDocument.createElement;\n                data.createFrag = ownerDocument.createDocumentFragment;\n                data.frag = data.createFrag();\n            }\n\n\n            ownerDocument.createElement = function(nodeName) {\n                //abort shiv\n                if (!html5.shivMethods) {\n                    return data.createElem(nodeName);\n                }\n                return createElement(nodeName, ownerDocument, data);\n            };\n\n            ownerDocument.createDocumentFragment = Function('h,f', 'return function(){' +\n                'var n=f.cloneNode(),c=n.createElement;' +\n                'h.shivMethods&&(' +\n                // unroll the `createElement` calls\n                getElements().join().replace(/\\w+/g, function(nodeName) {\n                    data.createElem(nodeName);\n                    data.frag.createElement(nodeName);\n                    return 'c(\"' + nodeName + '\")';\n                }) +\n                ');return n}'\n            )(html5, data.frag);\n        }\n\n        /*--------------------------------------------------------------------------*/\n\n        /**\n         * Shivs the given document.\n         * @memberOf html5\n         * @param {Document} ownerDocument The document to shiv.\n         * @returns {Document} The shived document.\n         */\n        function shivDocument(ownerDocument) {\n            if (!ownerDocument) {\n                ownerDocument = document;\n            }\n            var data = getExpandoData(ownerDocument);\n\n            if (html5.shivCSS && !supportsHtml5Styles && !data.hasCSS) {\n                data.hasCSS = !!addStyleSheet(ownerDocument,\n                    // corrects block display not defined in IE6/7/8/9\n                    'article,aside,figcaption,figure,footer,header,hgroup,nav,section{display:block}' +\n                        // adds styling not present in IE6/7/8/9\n                        'mark{background:#FF0;color:#000}'\n                );\n            }\n            if (!supportsUnknownElements) {\n                shivMethods(ownerDocument, data);\n            }\n            return ownerDocument;\n        }\n\n        /*--------------------------------------------------------------------------*/\n\n        /**\n         * The `html5` object is exposed so that more elements can be shived and\n         * existing shiving can be detected on iframes.\n         * @type Object\n         * @example\n         *\n         * // options can be changed before the script is included\n         * html5 = { 'elements': 'mark section', 'shivCSS': false, 'shivMethods': false };\n         */\n        var html5 = {\n\n            /**\n             * An array or space separated string of node names of the elements to shiv.\n             * @memberOf html5\n             * @type Array|String\n             */\n            'elements': options.elements || 'abbr article aside audio bdi canvas data datalist details figcaption figure footer header hgroup mark meter nav output progress section summary time video',\n\n            /**\n             * A flag to indicate that the HTML5 style sheet should be inserted.\n             * @memberOf html5\n             * @type Boolean\n             */\n            'shivCSS': (options.shivCSS !== false),\n\n            /**\n             * Is equal to true if a browser supports creating unknown/HTML5 elements\n             * @memberOf html5\n             * @type boolean\n             */\n            'supportsUnknownElements': supportsUnknownElements,\n\n            /**\n             * A flag to indicate that the document's `createElement` and `createDocumentFragment`\n             * methods should be overwritten.\n             * @memberOf html5\n             * @type Boolean\n             */\n            'shivMethods': (options.shivMethods !== false),\n\n            /**\n             * A string to describe the type of `html5` object (\"default\" or \"default print\").\n             * @memberOf html5\n             * @type String\n             */\n            'type': 'default',\n\n            // shivs the document according to the specified `html5` object options\n            'shivDocument': shivDocument,\n\n            //creates a shived element\n            createElement: createElement,\n\n            //creates a shived documentFragment\n            createDocumentFragment: createDocumentFragment\n        };\n\n        /*--------------------------------------------------------------------------*/\n\n        // expose html5\n        window.html5 = html5;\n\n        // shiv the document\n        shivDocument(document);\n\n    }(this, document));\n    /*>>shiv*/\n\n    // Assign private properties to the return object with prefix\n    Modernizr._version      = version;\n\n    // expose these for the plugin API. Look in the source for how to join() them against your input\n    /*>>prefixes*/\n    Modernizr._prefixes     = prefixes;\n    /*>>prefixes*/\n    /*>>domprefixes*/\n    Modernizr._domPrefixes  = domPrefixes;\n    Modernizr._cssomPrefixes  = cssomPrefixes;\n    /*>>domprefixes*/\n\n    /*>>mq*/\n    // Modernizr.mq tests a given media query, live against the current state of the window\n    // A few important notes:\n    //   * If a browser does not support media queries at all (eg. oldIE) the mq() will always return false\n    //   * A max-width or orientation query will be evaluated against the current state, which may change later.\n    //   * You must specify values. Eg. If you are testing support for the min-width media query use:\n    //       Modernizr.mq('(min-width:0)')\n    // usage:\n    // Modernizr.mq('only screen and (max-width:768)')\n    Modernizr.mq            = testMediaQuery;\n    /*>>mq*/\n\n    /*>>hasevent*/\n    // Modernizr.hasEvent() detects support for a given event, with an optional element to test on\n    // Modernizr.hasEvent('gesturestart', elem)\n    Modernizr.hasEvent      = isEventSupported;\n    /*>>hasevent*/\n\n    /*>>testprop*/\n    // Modernizr.testProp() investigates whether a given style property is recognized\n    // Note that the property names must be provided in the camelCase variant.\n    // Modernizr.testProp('pointerEvents')\n    Modernizr.testProp      = function(prop){\n        return testProps([prop]);\n    };\n    /*>>testprop*/\n\n    /*>>testallprops*/\n    // Modernizr.testAllProps() investigates whether a given style property,\n    //   or any of its vendor-prefixed variants, is recognized\n    // Note that the property names must be provided in the camelCase variant.\n    // Modernizr.testAllProps('boxSizing')\n    Modernizr.testAllProps  = testPropsAll;\n    /*>>testallprops*/\n\n\n    /*>>teststyles*/\n    // Modernizr.testStyles() allows you to add custom styles to the document and test an element afterwards\n    // Modernizr.testStyles('#modernizr { position:absolute }', function(elem, rule){ ... })\n    Modernizr.testStyles    = injectElementWithStyles;\n    /*>>teststyles*/\n\n\n    /*>>prefixed*/\n    // Modernizr.prefixed() returns the prefixed or nonprefixed property name variant of your input\n    // Modernizr.prefixed('boxSizing') // 'MozBoxSizing'\n\n    // Properties must be passed as dom-style camelcase, rather than `box-sizing` hypentated style.\n    // Return values will also be the camelCase variant, if you need to translate that to hypenated style use:\n    //\n    //     str.replace(/([A-Z])/g, function(str,m1){ return '-' + m1.toLowerCase(); }).replace(/^ms-/,'-ms-');\n\n    // If you're trying to ascertain which transition end event to bind to, you might do something like...\n    //\n    //     var transEndEventNames = {\n    //       'WebkitTransition' : 'webkitTransitionEnd',\n    //       'MozTransition'    : 'transitionend',\n    //       'OTransition'      : 'oTransitionEnd',\n    //       'msTransition'     : 'MSTransitionEnd',\n    //       'transition'       : 'transitionend'\n    //     },\n    //     transEndEventName = transEndEventNames[ Modernizr.prefixed('transition') ];\n\n    Modernizr.prefixed      = function(prop, obj, elem){\n        if(!obj) {\n            return testPropsAll(prop, 'pfx');\n        } else {\n            // Testing DOM property e.g. Modernizr.prefixed('requestAnimationFrame', window) // 'mozRequestAnimationFrame'\n            return testPropsAll(prop, obj, elem);\n        }\n    };\n    /*>>prefixed*/\n\n\n    /*>>cssclasses*/\n    // Remove \"no-js\" class from <html> element, if it exists:\n    docElement.className = docElement.className.replace(/(^|\\s)no-js(\\s|$)/, '$1$2') +\n\n        // Add the new classes to the <html> element.\n        (enableClasses ? ' js ' + classes.join(' ') : '');\n    /*>>cssclasses*/\n\n    return Modernizr;\n\n})(this, this.document);","modernizr/modernizr.2.0.6.js":"/* Modernizr 2.0.6 (Custom Build) | MIT & BSD\n * Build: http://www.modernizr.com/download/#-csstransforms-csstransforms3d-cssclasses-prefixed-teststyles-testprop-testallprops-prefixes-domprefixes\n */\n;window.Modernizr=function(a,b,c){function C(a,b){var c=a.charAt(0).toUpperCase()+a.substr(1),d=(a+\" \"+o.join(c+\" \")+c).split(\" \");return B(d,b)}function B(a,b){for(var d in a)if(k[a[d]]!==c)return b==\"pfx\"?a[d]:!0;return!1}function A(a,b){return!!~(\"\"+a).indexOf(b)}function z(a,b){return typeof a===b}function y(a,b){return x(n.join(a+\";\")+(b||\"\"))}function x(a){k.cssText=a}var d=\"2.0.6\",e={},f=!0,g=b.documentElement,h=b.head||b.getElementsByTagName(\"head\")[0],i=\"modernizr\",j=b.createElement(i),k=j.style,l,m=Object.prototype.toString,n=\" -webkit- -moz- -o- -ms- -khtml- \".split(\" \"),o=\"Webkit Moz O ms Khtml\".split(\" \"),p={},q={},r={},s=[],t=function(a,c,d,e){var f,h,j,k=b.createElement(\"div\");if(parseInt(d,10))while(d--)j=b.createElement(\"div\"),j.id=e?e[d]:i+(d+1),k.appendChild(j);f=[\"&shy;\",\"<style>\",a,\"</style>\"].join(\"\"),k.id=i,k.innerHTML+=f,g.appendChild(k),h=c(k,a),k.parentNode.removeChild(k);return!!h},u,v={}.hasOwnProperty,w;!z(v,c)&&!z(v.call,c)?w=function(a,b){return v.call(a,b)}:w=function(a,b){return b in a&&z(a.constructor.prototype[b],c)};var D=function(a,c){var d=a.join(\"\"),f=c.length;t(d,function(a,c){var d=b.styleSheets[b.styleSheets.length-1],g=d.cssRules&&d.cssRules[0]?d.cssRules[0].cssText:d.cssText||\"\",h=a.childNodes,i={};while(f--)i[h[f].id]=h[f];e.csstransforms3d=i.csstransforms3d.offsetLeft===9},f,c)}([,[\"@media (\",n.join(\"transform-3d),(\"),i,\")\",\"{#csstransforms3d{left:9px;position:absolute}}\"].join(\"\")],[,\"csstransforms3d\"]);p.csstransforms=function(){return!!B([\"transformProperty\",\"WebkitTransform\",\"MozTransform\",\"OTransform\",\"msTransform\"])},p.csstransforms3d=function(){var a=!!B([\"perspectiveProperty\",\"WebkitPerspective\",\"MozPerspective\",\"OPerspective\",\"msPerspective\"]);a&&\"webkitPerspective\"in g.style&&(a=e.csstransforms3d);return a};for(var E in p)w(p,E)&&(u=E.toLowerCase(),e[u]=p[E](),s.push((e[u]?\"\":\"no-\")+u));x(\"\"),j=l=null,e._version=d,e._prefixes=n,e._domPrefixes=o,e.testProp=function(a){return B([a])},e.testAllProps=C,e.testStyles=t,e.prefixed=function(a){return C(a,\"pfx\")},g.className=g.className.replace(/\\bno-js\\b/,\"\")+(f?\" js \"+s.join(\" \"):\"\");return e}(this,this.document);","modernizr/modernizr.details.js":"// By @mathias, based on http://mths.be/axh\ndefine([\n    'modernizr/modernizr'\n], function(){\n\n    Modernizr.addTest('details', function() {\n        var doc = document,\n            el = doc.createElement('details'),\n            fake,\n            root,\n            diff;\n        if (!('open' in el)) { // return early if possible; thanks @aFarkas!\n            return false;\n        }\n        root = doc.body || (function() {\n            var de = doc.documentElement;\n            fake = true;\n            return de.insertBefore(doc.createElement('body'), de.firstElementChild || de.firstChild);\n        }());\n        el.innerHTML = '<summary>a</summary>b';\n        el.style.display = 'block';\n        root.appendChild(el);\n        diff = el.offsetHeight;\n        el.open = true;\n        diff = diff != el.offsetHeight;\n        root.removeChild(el);\n        fake && root.parentNode.removeChild(root);\n        return diff;\n    });\n\n});","Magento_Theme/js/sortable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * JQuery UI Widget declaration: 'mage.sortable'\n *\n * @api\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    /**\n     * Widget panel\n     */\n    $.widget('mage.sortable', $.ui.sortable, {\n        options: {\n            moveUpEvent:   'moveUp',\n            moveDownEvent: 'moveDown'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._super();\n            this.initButtons();\n            this.bind();\n        },\n\n        /**\n         * Init buttons.\n         */\n        initButtons: function () {\n            this.element.find('input.up').on('click', $.proxy(function (event) {\n                $('body').trigger(this.options.moveUpEvent, {\n                    item: $(event.target).parent('li')\n                });\n            }, this));\n            this.element.find('input.down').on('click', $.proxy(function (event) {\n                $('body').trigger(this.options.moveDownEvent, {\n                    item: $(event.target).parent('li')\n                });\n            }, this));\n        },\n\n        /**\n         * Bind.\n         */\n        bind: function () {\n            var $body = $('body');\n\n            $body.on(this.options.moveUpEvent, $.proxy(this._onMoveUp, this));\n            $body.on(this.options.moveDownEvent, $.proxy(this._onMoveDown, this));\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _onMoveUp: function (event, data) {\n            data.item.insertBefore(data.item.prev());\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _onMoveDown: function (event, data) {\n            data.item.insertAfter(data.item.next());\n        }\n    });\n\n    return $.mage.sortable;\n});\n","Magento_Theme/js/bootstrap.js":"/**\n *\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'jquery/fileUploader/jquery.fileupload-ui',\n    'mage/adminhtml/browser',\n    'Magento_Theme/js/form'\n]);\n","Magento_Theme/js/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'prototype'\n], function () {\n    'use strict';\n\n    /**\n     * @param {*} selected\n     * @param {Object} defaultsById\n     */\n    function parentThemeOnChange(selected, defaultsById) {\n        var statusBar = $$('.tab-item-link')[0],\n            isChanged = statusBar.hasClassName('changed'),\n            defaults;\n\n        if (!isChanged) {\n            defaults = defaultsById[selected];\n            $('theme_title').value = defaults['theme_title'];\n        }\n    }\n\n    window.parentThemeOnChange = parentThemeOnChange;\n});\n","Magento_Theme/js/custom-js-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('theme.themeJsList', {\n        options: {\n            templateId: null,\n            emptyTemplateId: null,\n            refreshFileListEvent: null,\n            prefixItemId: '',\n            suffixItemId: ''\n        },\n\n        /**\n         * Initialize widget\n         *\n         * @protected\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * Bind event handlers\n         *\n         * @protected\n         */\n        _bind: function () {\n            $('body').on(this.options.refreshFileListEvent, $.proxy(this._onRefreshList, this));\n        },\n\n        /**\n         * Render js files list\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @protected\n         */\n        _onRefreshList: function (event, data) {\n            $(this.element).html('');\n\n            if (data.jsList.length) {\n                this._renderList(data.jsList);\n            } else {\n                this._renderEmptyList();\n            }\n        },\n\n        /**\n         * Get item js list id\n         *\n         * @param {*} fileId\n         * @return {String}\n         * @protected\n         */\n        _getItemId: function (fileId) {\n            return this.options.prefixItemId + fileId + this.options.suffixItemId;\n        },\n\n        /**\n         * Render js list\n         *\n         * @param {Array} jsList\n         * @protected\n         */\n        _renderList: function (jsList) {\n            var itemTmpl,\n                index,\n                tmpl;\n\n            for (index = 0; index < jsList.length; index++) {\n                itemTmpl = $('<li></li>').html($(this.options.templateId).html());\n\n                $(itemTmpl).attr('class', $(this.options.templateId).attr('class'));\n\n                itemTmpl.attr('id', this._getItemId(jsList[index].id));\n\n                tmpl = mageTemplate(itemTmpl.html(), {\n                    data: jsList[index]\n                });\n\n                itemTmpl.html(tmpl);\n\n                itemTmpl.removeClass('no-display');\n                itemTmpl.appendTo(this.element);\n            }\n        },\n\n        /**\n         * Set empty js list\n         *\n         * @protected\n         */\n        _renderEmptyList: function () {\n            var itemTmpl = $('<li></li>').html($(this.options.emptyTemplateId).html());\n\n            $(itemTmpl).attr('class', $(this.options.emptyTemplateId).attr('class'));\n\n            itemTmpl.attr('id', 'empty-js-list');\n            itemTmpl.removeClass('no-display');\n            itemTmpl.appendTo(this.element);\n        }\n    });\n});\n","Magento_Theme/js/form/component/robots-reset-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/components/button',\n    'uiRegistry'\n], function (Button, registry) {\n    'use strict';\n\n    return Button.extend({\n        defaults: {\n            customInstructionField: '${ $.parentName }.custom_instructions',\n            label: '',\n            buttonTpl: 'Magento_Theme/form/element/button'\n        },\n\n        /**\n         * @private\n         * @param {String} json\n         * @return {String}\n         */\n        _parseJson: function (json) {\n            return JSON.parse(json);\n        },\n\n        /**\n         * @param {String} defaultRobotsTxt\n         */\n        reset: function (defaultRobotsTxt) {\n            var customInstructions = registry.get(this.customInstructionField);\n\n            if (customInstructions) {\n                customInstructions.set('value', this._parseJson(defaultRobotsTxt));\n            }\n        }\n    });\n});\n","Magento_User/app-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\nrequire.config({\n    'waitSeconds': 0,\n    'shim': {\n        'jquery/jstree/jquery.hotkeys': ['jquery'],\n        'jquery/hover-intent': ['jquery'],\n        'mage/adminhtml/backup': ['prototype'],\n        'mage/captcha': ['prototype'],\n        'mage/common': ['jquery'],\n        'mage/webapi': ['jquery'],\n        'ko': {\n            exports: 'ko'\n        },\n        'moment': {\n            exports: 'moment'\n        }\n    },\n    'paths': {\n        'jquery/ui': 'jquery/jquery-ui-1.9.2',\n        'jquery/validate': 'jquery/jquery.validate',\n        'jquery/hover-intent': 'jquery/jquery.hoverIntent',\n        'jquery/file-uploader': 'jquery/fileUploader/jquery.fileupload-fp',\n        'prototype': 'prototype/prototype-amd',\n        'text': 'requirejs/text',\n        'domReady': 'requirejs/domReady',\n        'ko': 'ko/ko'\n    }\n});\n\nrequire(['jquery'], function (jQuery) {\n    'use strict';\n\n    jQuery.noConflict();\n});\n","Magento_User/js/roles-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery/ui',\n    'jquery/jstree/jquery.jstree'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.rolesTree', {\n        options: {\n            treeInitData: {},\n            treeInitSelectedData: {}\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.element.jstree({\n                plugins: ['themes', 'json_data', 'ui', 'crrm', 'types', 'vcheckbox', 'hotkeys'],\n                vcheckbox: {\n                    'two_state': true,\n                    'real_checkboxes': true,\n\n                    /**\n                     * @param {*} n\n                     * @return {Array}\n                     */\n                    'real_checkboxes_names': function (n) {\n                        return ['resource[]', $(n).data('id')];\n                    }\n                },\n                'json_data': {\n                    data: this.options.treeInitData\n                },\n                ui: {\n                    'select_limit': 0\n                },\n                hotkeys: {\n                    space: this._changeState,\n                    'return': this._changeState\n                },\n                types: {\n                    'types': {\n                        'disabled': {\n                            'check_node': false,\n                            'uncheck_node': false\n                        }\n                    }\n                }\n            });\n            this._bind();\n        },\n\n        /**\n         * @private\n         */\n        _destroy: function () {\n            this.element.jstree('destroy');\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            this.element.on('loaded.jstree', $.proxy(this._checkNodes, this));\n            this.element.on('click.jstree', 'a', $.proxy(this._checkNode, this));\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _checkNode: function (event) {\n            event.stopPropagation();\n            this.element.jstree(\n                'change_state',\n                event.currentTarget,\n                this.element.jstree('is_checked', event.currentTarget)\n            );\n        },\n\n        /**\n         * @private\n         */\n        _checkNodes: function () {\n            var $items = $('[data-id=\"' + this.options.treeInitSelectedData.join('\"],[data-id=\"') + '\"]');\n\n            $items.removeClass('jstree-unchecked').addClass('jstree-checked');\n            $items.children(':checkbox').prop('checked', true);\n        },\n\n        /**\n         * @return {Boolean}\n         * @private\n         */\n        _changeState: function () {\n            var element;\n\n            if (this.data.ui.hovered) {\n                element = this.data.ui.hovered;\n                this['change_state'](element, this['is_checked'](element));\n            }\n\n            return false;\n        }\n    });\n\n    return $.mage.rolesTree;\n});\n","Magento_User/js/delete-user-account.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var postData;\n\n    return function (params, elem) {\n\n        elem.on('click', function () {\n\n            postData = {\n                'data': {\n                    'user_id': params.objId,\n                    'current_password': $('[name=\"current_password\"]').val()\n                }\n            };\n\n            if ($.validator.validateElement($('[name=\"current_password\"]'))) {\n                window.deleteConfirm(params.message, params.url, postData);\n            }\n        });\n    };\n});\n","Magento_InventoryLowQuantityNotificationAdminUi/js/components/use-config-settings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (checkbox) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: '',\n            linkedValue: ''\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig', 'linkedValue']);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        'onCheckedChanged': function (newChecked) {\n            if (newChecked) {\n                this.linkedValue(this.valueFromConfig());\n            }\n\n            this._super(newChecked);\n        },\n\n        /**\n         * @returns {String}\n         */\n        getInitialValue: function () {\n            var values = [this.value(), this.default],\n                value;\n\n            values.some(function (v) {\n                value = v || !!v;\n\n                return value;\n            });\n\n            return this.normalizeData(value);\n        }\n    });\n});\n","Magento_InventoryLowQuantityNotificationAdminUi/js/components/notify-stock-qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (AbstractField) {\n    'use strict';\n\n    return AbstractField.extend({\n        defaults: {\n            notifyStockQtyUseDefault: '',\n            manageStock: '',\n            listens: {\n                notifyStockQtyUseDefault: 'onChange',\n                manageStock: 'onChange'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['notifyStockQtyUseDefault', 'manageStock']);\n        },\n\n        /**\n         * Disable input when Manage Stock switched off or Notify Quantity Use Default\n         */\n        onChange: function () {\n            this.disabled(\n                this.notifyStockQtyUseDefault() ||\n                this.manageStock()\n            );\n        }\n    });\n});\n","Magento_UrlRewrite/js/url-rewrite-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/backend/form',\n    'mage/backend/validation'\n], function ($) {\n    'use strict';\n\n    return function (data, element) {\n\n        $(element).form().validation({\n            validationUrl: data.url\n        });\n    };\n});\n","Magento_ReleaseNotification/js/modal/component.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal-component',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate'\n], function ($, Modal, alert, $t) {\n    'use strict';\n\n    return Modal.extend({\n        defaults: {\n            imports: {\n                logAction:  '${ $.provider }:data.logAction'\n            }\n        },\n\n        /**\n         * Error handler.\n         *\n         * @param {Object} xhr - request result.\n         */\n        onError: function (xhr) {\n            if (xhr.statusText === 'abort') {\n                return;\n            }\n\n            alert({\n                content: xhr.message || $t('An error occurred while logging process.')\n            });\n        },\n\n        /**\n         * Log release notes show\n         */\n        logReleaseNotesShow: function () {\n            var self = this,\n                data = {\n                    'form_key': window.FORM_KEY\n                };\n\n            $.ajax({\n                type: 'POST',\n                url: this.logAction,\n                data: data,\n                showLoader: true\n            }).done(function (xhr) {\n                if (xhr.error) {\n                    self.onError(xhr);\n                }\n            }).fail(this.onError);\n        },\n\n        /**\n         * Close release notes\n         */\n        closeReleaseNotes: function () {\n            this.logReleaseNotesShow();\n            this.closeModal();\n        }\n    });\n});\n","Magento_CurrencySymbol/js/symbols-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/mage'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element)\n            .mage('form')\n            .mage('validation');\n\n        /**\n         * Toggle the field to use the default value\n         *\n         * @param {String} code\n         * @param {String} value\n         */\n        function toggleUseDefault(code, value) {\n            var checkbox = $('#custom_currency_symbol_inherit' + code),\n                input = $('#custom_currency_symbol' + code);\n\n            if (checkbox.is(':checked')) {\n                input.addClass('disabled');\n                input.val(value);\n                input.prop('readonly', true);\n            } else {\n                input.removeClass('disabled');\n                input.prop('readonly', false);\n            }\n        }\n\n        window.toggleUseDefault = toggleUseDefault;\n    };\n});\n","Magento_Shipping/js/packages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, modal, $t) {\n    'use strict';\n\n    return function (config, element) {\n        config.buttons = [\n            {\n                text: $t('Print'),\n                'class': 'action action-primary',\n\n                /**\n                 * Click handler\n                 */\n                click: function () {\n                    window.location.href = this.options.url;\n                }\n            }, {\n                text: $t('Cancel'),\n                'class': 'action action-secondary',\n\n                /**\n                 * Click handler\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }\n        ];\n        modal(config, element);\n    };\n});\n","Magento_Shipping/order/packaging.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['prototype'], function () {\n\n    window.Packaging = Class.create();\n    Packaging.prototype = {\n        /**\n         * Initialize object\n         */\n        initialize: function (params) {\n            this.packageIncrement = 0;\n            this.packages = [];\n            this.itemsAll = [];\n            this.createLabelUrl = params.createLabelUrl ? params.createLabelUrl : null;\n            this.itemsGridUrl = params.itemsGridUrl ? params.itemsGridUrl : null;\n            this.errorQtyOverLimit = params.errorQtyOverLimit;\n            this.titleDisabledSaveBtn = params.titleDisabledSaveBtn;\n            this.window = $('packaging_window');\n            this.messages = this.window.select('.message-warning')[0];\n            this.packagesContent = $('packages_content');\n            this.template = $('package_template');\n            this.paramsCreateLabelRequest = {};\n            this.validationErrorMsg = params.validationErrorMsg;\n\n            this.defaultItemsQty            = params.shipmentItemsQty ? params.shipmentItemsQty : null;\n            this.defaultItemsPrice          = params.shipmentItemsPrice ? params.shipmentItemsPrice : null;\n            this.defaultItemsName           = params.shipmentItemsName ? params.shipmentItemsName : null;\n            this.defaultItemsWeight         = params.shipmentItemsWeight ? params.shipmentItemsWeight : null;\n            this.defaultItemsProductId      = params.shipmentItemsProductId ? params.shipmentItemsProductId : null;\n            this.defaultItemsOrderItemId    = params.shipmentItemsOrderItemId ? params.shipmentItemsOrderItemId : null;\n\n            this.shippingInformation = params.shippingInformation ? params.shippingInformation : null;\n            this.thisPage           = params.thisPage ? params.thisPage : null;\n            this.customizableContainers = params.customizable ? params.customizable : [];\n\n            this.eps = 0.000001;\n        },\n\n        /**\n         * Get Package Id\n         */\n        getPackageId: function (packageBlock) {\n            return packageBlock.id.match(/\\d{0,}$/)[0];\n        },\n\n        //******************** Setters **********************************//\n        setLabelCreatedCallback: function (callback) {\n            this.labelCreatedCallback = callback;\n        },\n        setCancelCallback: function (callback) {\n            this.cancelCallback = callback;\n        },\n        setConfirmPackagingCallback: function (callback) {\n            this.confirmPackagingCallback = callback;\n        },\n        setItemQtyCallback: function (callback) {\n            this.itemQtyCallback = callback;\n        },\n        setCreateLabelUrl: function (url) {\n            this.createLabelUrl = url;\n        },\n        setParamsCreateLabelRequest: function (params) {\n            Object.extend(this.paramsCreateLabelRequest, params);\n        },\n        //******************** End Setters *******************************//\n\n        showWindow: function () {\n            if (this.packagesContent.childElements().length == 0) {\n                this.newPackage();\n            }\n            jQuery(this.window).modal('openModal');\n        },\n\n        cancelPackaging: function () {\n            if (Object.isFunction(this.cancelCallback)) {\n                this.cancelCallback();\n            }\n        },\n\n        confirmPackaging: function (params) {\n            if (Object.isFunction(this.confirmPackagingCallback)) {\n                this.confirmPackagingCallback();\n            }\n        },\n\n        checkAllItems: function (headCheckbox) {\n            $(headCheckbox).up('table').select('tbody input[type=\"checkbox\"]').each(function (checkbox) {\n                checkbox.checked = headCheckbox.checked;\n                this._observeQty.call(checkbox);\n            }.bind(this));\n        },\n\n        cleanPackages: function () {\n            this.packagesContent.update();\n            this.packages = [];\n            this.itemsAll = [];\n            this.packageIncrement = 0;\n            this._setAllItemsPackedState();\n            this.messages.hide().update();\n        },\n\n        sendCreateLabelRequest: function () {\n            var self = this;\n\n            if (!this.validate()) {\n                this.messages.show().update(this.validationErrorMsg);\n\n                return;\n            }\n            this.messages.hide().update();\n\n            if (this.createLabelUrl) {\n                var weight, length, width, height = null;\n                var packagesParams = [];\n\n                this.packagesContent.childElements().each(function (pack) {\n                    var packageId = this.getPackageId(pack);\n\n                    weight = parseFloat(pack.select('input[name=\"container_weight\"]')[0].value);\n                    length = parseFloat(pack.select('input[name=\"container_length\"]')[0].value);\n                    width = parseFloat(pack.select('input[name=\"container_width\"]')[0].value);\n                    height = parseFloat(pack.select('input[name=\"container_height\"]')[0].value);\n                    packagesParams[packageId] = {\n                        container:                  pack.select('select[name=\"package_container\"]')[0].value,\n                        customs_value:              parseFloat(pack.select('input[name=\"package_customs_value\"]')[0].value, 10),\n                        weight:                     isNaN(weight) ? '' : weight,\n                        length:                     isNaN(length) ? '' : length,\n                        width:                      isNaN(width) ? '' : width,\n                        height:                     isNaN(height) ? '' : height,\n                        weight_units:               pack.select('select[name=\"container_weight_units\"]')[0].value,\n                        dimension_units:            pack.select('select[name=\"container_dimension_units\"]')[0].value\n                    };\n\n                    if (isNaN(packagesParams[packageId]['customs_value'])) {\n                        packagesParams[packageId]['customs_value'] = 0;\n                    }\n\n                    if ('undefined' != typeof pack.select('select[name=\"package_size\"]')[0]) {\n                        if ('' != pack.select('select[name=\"package_size\"]')[0].value) {\n                            packagesParams[packageId]['size'] = pack.select('select[name=\"package_size\"]')[0].value;\n                        }\n                    }\n\n                    if ('undefined' != typeof pack.select('input[name=\"container_girth\"]')[0]) {\n                        if ('' != pack.select('input[name=\"container_girth\"]')[0].value) {\n                            packagesParams[packageId]['girth'] = pack.select('input[name=\"container_girth\"]')[0].value;\n                            packagesParams[packageId]['girth_dimension_units'] = pack.select('select[name=\"container_girth_dimension_units\"]')[0].value;\n                        }\n                    }\n\n                    if ('undefined' != typeof pack.select('select[name=\"content_type\"]')[0] && 'undefined' != typeof pack.select('input[name=\"content_type_other\"]')[0]) {\n                        packagesParams[packageId]['content_type'] = pack.select('select[name=\"content_type\"]')[0].value;\n                        packagesParams[packageId]['content_type_other'] = pack.select('input[name=\"content_type_other\"]')[0].value;\n                    } else {\n                        packagesParams[packageId]['content_type'] = '';\n                        packagesParams[packageId]['content_type_other'] = '';\n                    }\n                    var deliveryConfirmation = pack.select('select[name=\"delivery_confirmation_types\"]');\n\n                    if (deliveryConfirmation.length) {\n                        packagesParams[packageId]['delivery_confirmation'] =  deliveryConfirmation[0].value;\n                    }\n                }.bind(this));\n\n                for (var packageId in this.packages) {\n                    if (!isNaN(packageId)) {\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[container]']              = packagesParams[packageId]['container'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[weight]']                 = packagesParams[packageId]['weight'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[customs_value]']          = packagesParams[packageId]['customs_value'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[length]']                 = packagesParams[packageId]['length'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[width]']                  = packagesParams[packageId]['width'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[height]']                 = packagesParams[packageId]['height'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[weight_units]']           = packagesParams[packageId]['weight_units'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[dimension_units]']        = packagesParams[packageId]['dimension_units'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[content_type]']           = packagesParams[packageId]['content_type'];\n                        this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[content_type_other]']     = packagesParams[packageId]['content_type_other'];\n\n                        if ('undefined' != typeof packagesParams[packageId]['size']) {\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[size]'] = packagesParams[packageId]['size'];\n                        }\n\n                        if ('undefined' != typeof packagesParams[packageId]['girth']) {\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[girth]'] = packagesParams[packageId]['girth'];\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[girth_dimension_units]'] = packagesParams[packageId]['girth_dimension_units'];\n                        }\n\n                        if ('undefined' != typeof packagesParams[packageId]['delivery_confirmation']) {\n                            this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[params]' + '[delivery_confirmation]']  = packagesParams[packageId]['delivery_confirmation'];\n                        }\n\n                        for (var packedItemId in this.packages[packageId]['items']) {\n                            if (!isNaN(packedItemId)) {\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][qty]']           = this.packages[packageId]['items'][packedItemId]['qty'];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][customs_value]'] = this.packages[packageId]['items'][packedItemId]['customs_value'];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][price]']         = self.defaultItemsPrice[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][name]']          = self.defaultItemsName[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][weight]']        = self.defaultItemsWeight[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][product_id]']    = self.defaultItemsProductId[packedItemId];\n                                this.paramsCreateLabelRequest['packages[' + packageId + ']' + '[items]' + '[' + packedItemId + '][order_item_id]'] = self.defaultItemsOrderItemId[packedItemId];\n                            }\n                        }\n                    }\n                }\n\n                new Ajax.Request(this.createLabelUrl, {\n                    parameters: this.paramsCreateLabelRequest,\n                    onSuccess: function (transport) {\n                        var response = transport.responseText;\n\n                        if (response.isJSON()) {\n                            response = response.evalJSON();\n\n                            if (response.error) {\n                                this.messages.show().innerHTML = response.message;\n                            } else if (response.ok && Object.isFunction(this.labelCreatedCallback)) {\n                                this.labelCreatedCallback(response);\n                            }\n                        }\n                    }.bind(this)\n                });\n\n                if (this.paramsCreateLabelRequest['code'] &&\n                    this.paramsCreateLabelRequest['carrier_title'] &&\n                    this.paramsCreateLabelRequest['method_title'] &&\n                    this.paramsCreateLabelRequest['price']\n                ) {\n                    var a = this.paramsCreateLabelRequest['code'];\n                    var b = this.paramsCreateLabelRequest['carrier_title'];\n                    var c = this.paramsCreateLabelRequest['method_title'];\n                    var d = this.paramsCreateLabelRequest['price'];\n\n                    this.paramsCreateLabelRequest = {};\n                    this.paramsCreateLabelRequest['code']           = a;\n                    this.paramsCreateLabelRequest['carrier_title']  = b;\n                    this.paramsCreateLabelRequest['method_title']   = c;\n                    this.paramsCreateLabelRequest['price']          = d;\n                } else {\n                    this.paramsCreateLabelRequest = {};\n                }\n            }\n        },\n\n        validate: function () {\n            var dimensionElements = $('packaging_window').select(\n                'input[name=container_length],input[name=container_width],input[name=container_height],input[name=container_girth]:not(\"._disabled\")'\n            );\n            var callback = null;\n\n            if (dimensionElements.any(function (element) {\n                return !!element.value;\n            })) {\n                callback = function (element) {\n                    $(element).addClassName('required-entry');\n                };\n            } else {\n                callback = function (element) {\n                    $(element).removeClassName('required-entry');\n                };\n            }\n            dimensionElements.each(callback);\n\n            return result = $$('[id^=\"package_block_\"] input').collect(function (element) {\n                return this.validateElement(element);\n            }, this).all();\n        },\n\n        validateElement: function (elm) {\n            var cn = $w(elm.className);\n\n            return result = cn.all(function (value) {\n                var v = Validation.get(value);\n\n                if (Validation.isVisible(elm) && !v.test($F(elm), elm)) {\n                    $(elm).addClassName('validation-failed');\n\n                    return false;\n                }\n                $(elm).removeClassName('validation-failed');\n\n                return true;\n\n            });\n        },\n\n        validateCustomsValue: function () {\n            var items = [];\n            var isValid = true;\n            var itemsPrepare = [];\n            var itemsPacked = [];\n\n            this.packagesContent.childElements().each(function (pack) {\n                itemsPrepare = pack.select('[data-role=\"package-items\"]')[0];\n\n                if (itemsPrepare) {\n                    items = items.concat(itemsPrepare.select('.grid tbody tr'));\n                }\n                itemsPacked = pack.select('.package_items')[0];\n\n                if (itemsPacked) {\n                    items = items.concat(itemsPacked.select('.grid tbody tr'));\n                }\n            });\n\n            items.each(function (item) {\n                var itemCustomsValue = item.select('[name=\"customs_value\"]')[0];\n\n                if (!this.validateElement(itemCustomsValue)) {\n                    isValid = false;\n                }\n            }.bind(this));\n\n            if (isValid) {\n                this.messages.hide().update();\n            } else {\n                this.messages.show().update(this.validationErrorMsg);\n            }\n\n            return isValid;\n        },\n\n        newPackage: function () {\n            var pack = this.template.cloneNode(true);\n\n            pack.id = 'package_block_' + ++this.packageIncrement;\n            pack.addClassName('package-block');\n            pack.select('[data-role=package-number]')[0].update(this.packageIncrement);\n            this.packagesContent.insert({\n                top: pack\n            });\n            pack.select('[data-action=package-save-items]')[0].hide();\n            pack.show();\n        },\n\n        deletePackage: function (obj) {\n            var pack = $(obj).up('[id^=\"package_block\"]');\n\n            var packItems = pack.select('.package_items')[0];\n            var packageId = this.getPackageId(pack);\n\n            delete this.packages[packageId];\n            pack.remove();\n            this.messages.hide().update();\n            this._setAllItemsPackedState();\n        },\n\n        deleteItem: function (obj) {\n            var item = $(obj).up('tr');\n            var itemId = item.select('[type=\"checkbox\"]')[0].value;\n            var pack = $(obj).up('[id^=\"package_block\"]');\n            var packItems = pack.select('.package_items')[0];\n            var packageId = this.getPackageId(pack);\n\n            delete this.packages[packageId]['items'][itemId];\n\n            if (item.offsetParent.rows.length <= 2) { /* head + this last row */\n                $(packItems).hide();\n            }\n            item.remove();\n            this.messages.hide().update();\n            this._recalcContainerWeightAndCustomsValue(packItems);\n            this._setAllItemsPackedState();\n        },\n\n        recalcContainerWeightAndCustomsValue: function (obj) {\n            var pack = $(obj).up('[id^=\"package_block\"]');\n            var packItems = pack.select('.package_items')[0];\n\n            if (packItems) {\n                if (!this.validateCustomsValue()) {\n                    return;\n                }\n                this._recalcContainerWeightAndCustomsValue(packItems);\n            }\n        },\n\n        getItemsForPack: function (obj) {\n            if (this.itemsGridUrl) {\n                var parameters = $H({\n                    'shipment_id': this.shipmentId\n                });\n                var packageBlock = $(obj).up('[id^=\"package_block\"]');\n                var packagePrapare = packageBlock.select('[data-role=package-items]')[0];\n                var packagePrapareGrid = packagePrapare.select('.grid_prepare')[0];\n\n                new Ajax.Request(this.itemsGridUrl, {\n                    parameters: parameters,\n                    onSuccess: function (transport) {\n                        var response = transport.responseText;\n\n                        if (response) {\n                            packagePrapareGrid.update(response);\n                            this.processPackagePrepare(packagePrapareGrid);\n\n                            if (packagePrapareGrid.select('.grid tbody tr').length) {\n                                packageBlock.select('[data-action=package-add-items]')[0].hide();\n                                packageBlock.select('[data-action=package-save-items]')[0].show();\n                                packagePrapare.show();\n                            } else {\n                                packagePrapareGrid.update();\n                            }\n                        }\n                    }.bind(this)\n                });\n            }\n        },\n\n        getPackedItemsQty: function () {\n            var items = [];\n\n            for (var packageId in this.packages) {\n                if (!isNaN(packageId)) {\n                    for (var packedItemId in this.packages[packageId]['items']) {\n                        if (!isNaN(packedItemId)) {\n                            if (items[packedItemId]) {\n                                items[packedItemId] += this.packages[packageId]['items'][packedItemId]['qty'];\n                            } else {\n                                items[packedItemId] = this.packages[packageId]['items'][packedItemId]['qty'];\n                            }\n                        }\n                    }\n                }\n            }\n\n            return items;\n        },\n\n        _parseQty: function (obj) {\n            var qty = $(obj).hasClassName('qty-decimal') ? parseFloat(obj.value) : parseInt(obj.value);\n\n            if (isNaN(qty) || qty <= 0) {\n                qty = 1;\n            }\n\n            return qty;\n        },\n\n        packItems: function (obj) {\n            var anySelected = false;\n            var packageBlock = $(obj).up('[id^=\"package_block\"]');\n            var packageId = this.getPackageId(packageBlock);\n            var packagePrepare = packageBlock.select('[data-role=package-items]')[0];\n            var packagePrepareGrid = packagePrepare.select('.grid_prepare')[0];\n\n            // check for exceeds the total shipped quantity\n            var checkExceedsQty = false;\n\n            this.messages.hide().update();\n            packagePrepareGrid.select('.grid tbody tr').each(function (item) {\n                var checkbox = item.select('[type=\"checkbox\"]')[0];\n                var itemId = checkbox.value;\n                var qtyValue  = this._parseQty(item.select('[name=\"qty\"]')[0]);\n\n                item.select('[name=\"qty\"]')[0].value = qtyValue;\n\n                if (checkbox.checked && this._checkExceedsQty(itemId, qtyValue)) {\n                    this.messages.show().update(this.errorQtyOverLimit);\n                    checkExceedsQty = true;\n                }\n            }.bind(this));\n\n            if (checkExceedsQty) {\n                return;\n            }\n\n            if (!this.validateCustomsValue()) {\n                return;\n            }\n\n            // prepare items for packing\n            packagePrepareGrid.select('.grid tbody tr').each(function (item) {\n                var checkbox = item.select('[type=\"checkbox\"]')[0];\n\n                if (checkbox.checked) {\n                    var qty  = item.select('[name=\"qty\"]')[0];\n                    var qtyValue  = this._parseQty(qty);\n\n                    item.select('[name=\"qty\"]')[0].value = qtyValue;\n                    anySelected = true;\n                    qty.disabled = 'disabled';\n                    checkbox.disabled = 'disabled';\n                    packagePrepareGrid.select('.grid th [type=\"checkbox\"]')[0].up('th label').hide();\n                    item.select('[data-action=package-delete-item]')[0].show();\n                } else {\n                    item.remove();\n                }\n            }.bind(this));\n\n            // packing items\n            if (anySelected) {\n                var packItems = packageBlock.select('.package_items')[0];\n\n                if (!packItems) {\n                    packagePrepare.insert(new Element('div').addClassName('grid_prepare'));\n                    packagePrepare.insert({\n                        after: packagePrepareGrid\n                    });\n                    packItems = packagePrepareGrid.removeClassName('grid_prepare').addClassName('package_items');\n                    packItems.select('.grid tbody tr').each(function (item) {\n                        var itemId = item.select('[type=\"checkbox\"]')[0].value;\n                        var qtyValue  = parseFloat(item.select('[name=\"qty\"]')[0].value);\n\n                        qtyValue = qtyValue <= 0 ? 1 : qtyValue;\n\n                        if ('undefined' == typeof this.packages[packageId]) {\n                            this.packages[packageId] = {\n                                'items': [], 'params': {}\n                            };\n                        }\n\n                        if ('undefined' == typeof this.packages[packageId]['items'][itemId]) {\n                            this.packages[packageId]['items'][itemId] = {};\n                            this.packages[packageId]['items'][itemId]['qty'] = qtyValue;\n                        } else {\n                            this.packages[packageId]['items'][itemId]['qty'] += qtyValue;\n                        }\n                    }.bind(this));\n                } else {\n                    packagePrepareGrid.select('.grid tbody tr').each(function (item) {\n                        var itemId = item.select('[type=\"checkbox\"]')[0].value;\n                        var qtyValue  = parseFloat(item.select('[name=\"qty\"]')[0].value);\n\n                        qtyValue = qtyValue <= 0 ? 1 : qtyValue;\n\n                        if ('undefined' == typeof this.packages[packageId]['items'][itemId]) {\n                            this.packages[packageId]['items'][itemId] = {};\n                            this.packages[packageId]['items'][itemId]['qty'] = qtyValue;\n                            packItems.select('.grid tbody')[0].insert(item);\n                        } else {\n                            this.packages[packageId]['items'][itemId]['qty'] += qtyValue;\n                            var packItem = packItems.select('[type=\"checkbox\"][value=\"' + itemId + '\"]')[0].up('tr').select('[name=\"qty\"]')[0];\n\n                            packItem.value = this.packages[packageId]['items'][itemId]['qty'];\n                        }\n                    }.bind(this));\n                    packagePrepareGrid.update();\n                }\n                $(packItems).show();\n                this._recalcContainerWeightAndCustomsValue(packItems);\n            } else {\n                packagePrepareGrid.update();\n            }\n\n            // show/hide disable/enable\n            packagePrepare.hide();\n            packageBlock.select('[data-action=package-save-items]')[0].hide();\n            packageBlock.select('[data-action=package-add-items]')[0].show();\n            this._setAllItemsPackedState();\n        },\n\n        validateItemQty: function (itemId, qty) {\n            return this.defaultItemsQty[itemId] < qty ? this.defaultItemsQty[itemId] : qty;\n        },\n\n        changeMeasures: function (obj) {\n            var incr = 0;\n            var incrSelected = 0;\n\n            obj.childElements().each(function (option) {\n                if (option.selected) {\n                    incrSelected = incr;\n                }\n                incr++;\n            });\n\n            var packageBlock = $(obj).up('[id^=\"package_block\"]');\n\n            packageBlock.select('.measures').each(function (item) {\n                if (item.name != obj.name) {\n                    var incr = 0;\n\n                    item.select('option').each(function (option) {\n                        if (incr == incrSelected) {\n                            item.value = option.value;\n                            //option.selected = true\n                        }\n                        incr++;\n                    });\n                }\n            });\n\n        },\n\n        checkSizeAndGirthParameter: function (obj, enabled) {\n            if (enabled == 0) {\n                return;\n            }\n            var currentNode = obj;\n\n            while (currentNode.nodeName != 'TBODY') {\n                currentNode = currentNode.parentNode;\n            }\n\n            if (!currentNode) {\n                return;\n            }\n\n            var packageSize = currentNode.select('select[name=package_size]');\n            var packageContainer = currentNode.select('select[name=package_container]');\n            var packageGirth = currentNode.select('input[name=container_girth]');\n            var packageGirthDimensionUnits = currentNode.select('select[name=container_girth_dimension_units]');\n\n            if (packageSize.length <= 0) {\n                return;\n            }\n\n            var girthEnabled = packageContainer[0].value == 'NONRECTANGULAR' || packageContainer[0].value == 'VARIABLE';\n\n            if (!girthEnabled) {\n                packageGirth[0].value = '';\n                packageGirth[0].disable();\n                packageGirth[0].addClassName('_disabled');\n                packageGirthDimensionUnits[0].disable();\n                packageGirthDimensionUnits[0].addClassName('_disabled');\n            } else {\n                packageGirth[0].enable();\n                packageGirth[0].removeClassName('_disabled');\n                packageGirthDimensionUnits[0].enable();\n                packageGirthDimensionUnits[0].removeClassName('_disabled');\n            }\n\n            var sizeEnabled = packageContainer[0].value == 'NONRECTANGULAR' || packageContainer[0].value == 'RECTANGULAR' ||\n                packageContainer[0].value == 'VARIABLE';\n\n            if (!sizeEnabled) {\n                option = document.createElement('OPTION');\n                option.value = '';\n                option.text = '';\n                packageSize[0].options.add(option);\n                packageSize[0].value = '';\n                packageSize[0].disable();\n                packageSize[0].addClassName('_disabled');\n            } else {\n                for (i = 0; i < packageSize[0].length; i++) {\n                    if (packageSize[0].options[i].value == '') {\n                        packageSize[0].removeChild(packageSize[0].options[i]);\n                    }\n                }\n                packageSize[0].enable();\n                packageSize[0].removeClassName('_disabled');\n            }\n        },\n\n        changeContainerType: function (obj) {\n            if (this.customizableContainers.length <= 0) {\n                return;\n            }\n\n            var disable = true;\n\n            for (var i in this.customizableContainers) {\n                if (this.customizableContainers[i] == obj.value) {\n                    disable = false;\n                    break;\n                }\n            }\n\n            var currentNode = obj;\n\n            while (currentNode.nodeName != 'TBODY') {\n                currentNode = currentNode.parentNode;\n            }\n\n            if (!currentNode) {\n                return;\n            }\n\n            $(currentNode).select(\n                'input[name=container_length],input[name=container_width],input[name=container_height],select[name=container_dimension_units]'\n            ).each(function (inputElement) {\n                if (disable) {\n                    Form.Element.disable(inputElement);\n                    inputElement.addClassName('_disabled');\n\n                    if (inputElement.nodeName == 'INPUT') {\n                        $(inputElement).value = '';\n                    }\n                } else {\n                    Form.Element.enable(inputElement);\n                    inputElement.removeClassName('_disabled');\n                }\n            });\n        },\n\n        changeContentTypes: function (obj) {\n            var packageBlock = $(obj).up('[id^=\"package_block\"]');\n            var contentType = packageBlock.select('[name=content_type]')[0];\n            var contentTypeOther = packageBlock.select('[name=content_type_other]')[0];\n\n            if (contentType.value == 'OTHER') {\n                Form.Element.enable(contentTypeOther);\n                contentTypeOther.removeClassName('_disabled');\n            } else {\n                Form.Element.disable(contentTypeOther);\n                contentTypeOther.addClassName('_disabled');\n            }\n\n        },\n\n        //******************** Private functions **********************************//\n        _getItemsCount: function (items) {\n            var count = 0;\n\n            items.each(function (itemCount) {\n                if (!isNaN(itemCount)) {\n                    count += parseFloat(itemCount);\n                }\n            });\n\n            return count;\n        },\n\n        /**\n         * Show/hide disable/enable buttons in case of all items packed state\n         */\n        _setAllItemsPackedState: function () {\n            var addPackageBtn = $$('[data-action=add-packages]')[0];\n            var savePackagesBtn = $$('[data-action=save-packages]')[0];\n\n            if (this._getItemsCount(this.itemsAll) > 0 &&\n                    this._checkExceedsQtyFinal(this._getItemsCount(this.getPackedItemsQty()), this._getItemsCount(this.itemsAll))\n            ) {\n                this.packagesContent.select('[data-action=package-add-items]').each(function (button) {\n                    button.disabled = 'disabled';\n                    button.addClassName('_disabled');\n                });\n                addPackageBtn.addClassName('_disabled');\n                Form.Element.disable(addPackageBtn);\n                savePackagesBtn.removeClassName('_disabled');\n                Form.Element.enable(savePackagesBtn);\n                savePackagesBtn.title = '';\n\n                // package number recalculation\n                var packagesRecalc = [];\n\n                this.packagesContent.childElements().each(function (pack) {\n                    if (!pack.select('.package_items .grid tbody tr').length) {\n                        pack.remove();\n                    }\n                });\n                var packagesCount = this.packagesContent.childElements().length;\n\n                this.packageIncrement = packagesCount;\n                this.packagesContent.childElements().each(function (pack) {\n                    var packageId = this.getPackageId(pack);\n\n                    pack.id = 'package_block_' + packagesCount;\n                    pack.select('[data-role=package-number]')[0].update(packagesCount);\n                    packagesRecalc[packagesCount] = this.packages[packageId];\n                    --packagesCount;\n                }.bind(this));\n                this.packages = packagesRecalc;\n\n            } else {\n                this.packagesContent.select('[data-action=package-add-items]').each(function (button) {\n                    button.removeClassName('_disabled');\n                    Form.Element.enable(button);\n                });\n                addPackageBtn.removeClassName('_disabled');\n                Form.Element.enable(addPackageBtn);\n                savePackagesBtn.addClassName('_disabled');\n                Form.Element.disable(savePackagesBtn);\n                savePackagesBtn.title = this.titleDisabledSaveBtn;\n            }\n        },\n\n        processPackagePrepare: function (packagePrepare) {\n            var itemsAll = [],\n                qty,\n                itemId,\n                qtyValue = 0,\n                value = 1;\n\n            packagePrepare.select('.grid tbody tr').each(function (item) {\n                qty = item.select('[name=\"qty\"]')[0],\n                    itemId = item.select('[type=\"checkbox\"]')[0].value,\n                    qtyValue = parseFloat(qty.value);\n\n                if (Object.isFunction(this.itemQtyCallback)) {\n                    value = this.itemQtyCallback(itemId);\n\n                    if (typeof value !== 'undefined') {\n                        qtyValue = parseFloat(value);\n                        qtyValue = this.validateItemQty(itemId, qtyValue);\n                        qty.value = qtyValue;\n                    }\n                } else {\n                    value = item.select('[name=\"qty\"]')[0].value;\n                    qtyValue = typeof value == 'string' && value.length == 0 ? 0 : parseFloat(value);\n\n                    if (isNaN(qtyValue) || qtyValue < 0) {\n                        qtyValue = 1;\n                    }\n                }\n\n                if (qtyValue == 0) {\n                    item.remove();\n\n                    return;\n                }\n                var packedItems = this.getPackedItemsQty();\n\n                itemsAll[itemId] = qtyValue;\n\n                for (var packedItemId in packedItems) {\n                    if (!isNaN(packedItemId)) {\n                        var packedQty = packedItems[packedItemId];\n\n                        if (itemId == packedItemId) {\n                            if (qtyValue == packedQty || qtyValue <= packedQty) {\n                                item.remove();\n                            } else if (qtyValue > packedQty) {\n                                /* fix float number precision */\n                                qty.value = Number(Number(Math.round(qtyValue - packedQty + 'e+4') + 'e-4').toFixed(4));\n                            }\n                        }\n                    }\n                }\n            }.bind(this));\n\n            if (!this.itemsAll.length) {\n                this.itemsAll = itemsAll;\n            }\n\n            packagePrepare.select('tbody input[type=\"checkbox\"]').each(function (item) {\n                $(item).observe('change', this._observeQty);\n                this._observeQty.call(item);\n            }.bind(this));\n        },\n\n        _observeQty: function () {\n            /** this = input[type=\"checkbox\"] */\n            var tr  = jQuery(this).closest('tr')[0],\n                qty = $(tr.cells[tr.cells.length - 1]).select('input[name=\"qty\"]')[0];\n\n            if (qty.disabled = !this.checked) {\n                $(qty).addClassName('_disabled');\n            } else {\n                $(qty).removeClassName('_disabled');\n            }\n        },\n\n        _checkExceedsQty: function (itemId, qty) {\n            var packedItemQty = this.getPackedItemsQty()[itemId] ? this.getPackedItemsQty()[itemId] : 0;\n            var allItemQty = this.itemsAll[itemId];\n\n            return qty * (1 - this.eps) > allItemQty *  (1 + this.eps)  - packedItemQty * (1 - this.eps);\n        },\n\n        _checkExceedsQtyFinal: function (checkOne, defQty) {\n            return checkOne * (1 + this.eps) >= defQty * (1 - this.eps);\n        },\n\n        _recalcContainerWeightAndCustomsValue: function (container) {\n            var packageBlock = container.up('[id^=\"package_block\"]');\n            var packageId = this.getPackageId(packageBlock);\n            var containerWeight = packageBlock.select('[name=\"container_weight\"]')[0];\n            var containerCustomsValue = packageBlock.select('[name=\"package_customs_value\"]')[0];\n\n            containerWeight.value = 0;\n            containerCustomsValue.value = 0;\n            container.select('.grid tbody tr').each(function (item) {\n                var itemId = item.select('[type=\"checkbox\"]')[0].value;\n                var qtyValue  = parseFloat(item.select('[name=\"qty\"]')[0].value);\n\n                if (isNaN(qtyValue) || qtyValue <= 0) {\n                    qtyValue = 1;\n                    item.select('[name=\"qty\"]')[0].value = qtyValue;\n                }\n                var itemWeight = parseFloat(this._getElementText(item.select('[data-role=item-weight]')[0]));\n\n                containerWeight.value = parseFloat(containerWeight.value) + itemWeight * qtyValue;\n                var itemCustomsValue = parseFloat(item.select('[name=\"customs_value\"]')[0].value) || 0;\n\n                containerCustomsValue.value = parseFloat(containerCustomsValue.value) + itemCustomsValue * qtyValue;\n                this.packages[packageId]['items'][itemId]['customs_value'] = itemCustomsValue;\n            }.bind(this));\n            containerWeight.value = parseFloat(parseFloat(Math.round(containerWeight.value + 'e+4') + 'e-4').toFixed(4));\n            containerCustomsValue.value = parseFloat(Math.round(containerCustomsValue.value + 'e+2') + 'e-2').toFixed(2);\n\n            if (containerCustomsValue.value == 0) {\n                containerCustomsValue.value = '';\n            }\n        },\n\n        _getElementText: function (el) {\n            if ('string' == typeof el.textContent) {\n                return el.textContent;\n            }\n\n            if ('string' == typeof el.innerText) {\n                return el.innerText;\n            }\n\n            return el.innerHTML.replace(/<[^>]*>/g, '');\n        }\n        //******************** End Private functions ******************************//\n    };\n\n});\n","Magento_Weee/js/regions-tax-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            filterBy: {\n                field: 'country',\n                target: '${ $.parentName }.country:value'\n            }\n        },\n\n        /** @inheritdoc */\n        filter: function () {\n            this._super();\n            this.disableSelect();\n        },\n\n        /**\n         * Disables select if there's no regions/states\n         *\n         * @returns {*} instance - Chainable\n         */\n        disableSelect: function () {\n            var empty = !this.options().length;\n\n            this.disabled(empty);\n\n            if (empty) {\n                this.error('');\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Weee/js/fpt-group.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/group',\n    'uiRegistry',\n    'Magento_Ui/js/lib/validation/validator',\n    'mage/translate',\n    'underscore'\n], function (Group, uiRegistry, validation, $t, _) {\n    'use strict';\n\n    return Group.extend({\n        defaults: {\n            visible: true,\n            label: '',\n            showLabel: true,\n            required: false,\n            template: 'ui/group/group',\n            fieldTemplate: 'ui/form/field',\n            breakLine: true,\n            validateWholeGroup: false,\n            additionalClasses: {}\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            validation.addRule('validate-fpt-group', function (value) {\n                if (value.indexOf('?') !== -1) {\n\n                    return false;\n                }\n\n                return true;\n            }, $t(\n                'Set unique country-state combinations within the same fixed product tax. ' +\n                'Verify the combinations and try again.'\n            ));\n\n            this._super();\n        },\n\n        /**\n         *\n         * @private\n         */\n        _handleOptionsAvailability: function () {\n            var parent,\n                dup;\n\n            dup = {};\n            parent = uiRegistry.get(uiRegistry.get(this.parentName).parentName);\n            _.each(parent.elems(), function (elem) {\n                var country,\n                    state,\n                    val,\n                    key;\n\n                country = uiRegistry.get(elem.name + '.countryState.country');\n                state = uiRegistry.get(elem.name + '.countryState.state');\n                val = uiRegistry.get(elem.name + '.countryState.val');\n\n                key = country.value() + (state.value() > 0 ? state.value() : 0);\n                dup[key]++;\n\n                if (!dup[key]) {\n                    dup[key] = 1;\n                    val.value('');\n                } else {\n                    dup[key]++;\n                    val.value(country.value() + '?' + country.name);\n                }\n            });\n        },\n\n        /** @inheritdoc */\n        initElement: function (elem) {\n            var obj;\n\n            obj = this;\n            this._super();\n            elem.on('value', function () {\n                obj._handleOptionsAvailability();\n            });\n\n            return this;\n        }\n    });\n});\n","Magento_Weee/js/fpt-attribute.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global RegionUpdater */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui',\n    'mage/adminhtml/form'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.fptAttribute', {\n        /** @inheritdoc */\n        _create: function () {\n            var widget = this;\n\n            this.rowTmpl = mageTemplate(this.element.find('[data-role=\"row-template\"]').html());\n\n            this._initOptionItem();\n\n            if ($(this.options.bundlePriceType).val() === '0') {\n                this.element.hide();\n            }\n\n            $.each(this.options.itemsData, function () {\n                widget.addItem(this);\n            });\n        },\n\n        /**\n         * @private\n         */\n        _initOptionItem: function () {\n            var widget = this,\n                isOriginalRequired = $(widget.element).hasClass('required');\n\n            this._on({\n                /**\n                 * Add new tax item.\n                 *\n                 * @param {jQuery.Event} event\n                 */\n                'click [data-action=add-fpt-item]': function (event) {\n                    this.addItem(event);\n                },\n\n                /**\n                 * Delete tax item.\n                 *\n                 * @param {jQuery.Event} event\n                 */\n                'click [data-action=delete-fpt-item]': function (event) {\n                    var parent = $(event.target).closest('[data-role=\"fpt-item-row\"]');\n\n                    parent.find('[data-role=\"delete-fpt-item\"]').val(1);\n                    parent.addClass('ignore-validate').hide();\n                },\n\n                /**\n                 * Change tax item country/state.\n                 *\n                 * @param {jQuery.Event} event\n                 * @param {Object} data\n                 */\n                'change [data-role=\"select-country\"]': function (event, data) {\n                    var currentElement = event.target || event.srcElement || event.currentTarget,\n                        parentElement = $(currentElement).closest('[data-role=\"fpt-item-row\"]'),\n                        updater;\n\n                    data = data || {};\n                    updater = new RegionUpdater(\n                        parentElement.find('[data-role=\"select-country\"]').attr('id'), null,\n                        parentElement.find('[data-role=\"select-state\"]').attr('id'),\n                        widget.options.region, 'disable', true\n                    );\n                    updater.update();\n                    //set selected state value if set\n                    if (data.state) {\n                        parentElement.find('[data-role=\"select-state\"]').val(data.state);\n                    }\n\n                    if (!isOriginalRequired && $(widget.element).hasClass('required')) {\n                        $(widget.element).removeClass('required');\n                    }\n                }\n            });\n\n            $(this.options.bundlePriceType).on('change', function (event) {\n                var attributeItems = widget.element.find('[data-role=\"delete-fpt-item\"]');\n\n                if ($(event.target).val() === '0') {\n                    widget.element.hide();\n                    attributeItems.each(function () {\n                        $(this).val(1);\n                    });\n                } else {\n                    widget.element.show();\n                    attributeItems.each(function () {\n                        if ($(this).closest('[data-role=\"fpt-item-row\"]').is(':visible')) {\n                            $(this).val(0);\n                        }\n                    });\n                }\n            });\n        },\n\n        /**\n         * Add custom option.\n         *\n         * @param {jQuery.Event} event\n         */\n        addItem: function (event) {\n            var data = {},\n                currentElement = event.target || event.srcElement || event.currentTarget,\n                tmpl;\n\n            if (typeof currentElement !== 'undefined') {\n                data['website_id'] = 0;\n            } else {\n                data = event;\n            }\n\n            data.index = this.element.find('[data-role=\"fpt-item-row\"]').length;\n\n            tmpl = this.rowTmpl({\n                data: data\n            });\n\n            $(tmpl).appendTo(this.element.find('[data-role=\"fpt-item-container\"]'));\n\n            //set selected website_id value if set\n            if (data['website_id']) {\n                this.element.find('[data-role=\"select-website\"][id$=\"_' + data.index + '_website\"]')\n                    .val(data['website_id']);\n            }\n\n            //set selected country value if set\n            if (data.country) {\n                this.element.find('[data-role=\"select-country\"][id$=\"_' + data.index + '_country\"]')\n                    .val(data.country).trigger('change', data);\n            }\n        }\n    });\n\n    return $.mage.fptAttribute;\n});\n","Magento_Weee/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Weee/price/adjustment',\n            dataSource: '${ $.parentName }.provider',\n            //Weee configuration constants can be configured from backend\n            inclFptWithDesc: 1,//show FPT and description\n            inclFpt: 0, //show FPT attribute\n            exclFpt: 2, //do not show FPT\n            bothFptPrices: 3 //show price without FPT and with FPT and with description\n        },\n\n        /**\n         * Get Weee attributes.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeAttributes: function (row) {\n            return row['price_info']['extension_attributes']['weee_attributes'];\n        },\n\n        /**\n         * Get Weee without Tax attributes.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithoutTax: function (taxAmount) {\n            return taxAmount['amount_excl_tax'];\n        },\n\n        /**\n         * Get Weee with Tax attributes.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithTax: function (taxAmount) {\n            return taxAmount['tax_amount_incl_tax'];\n        },\n\n        /**\n         * Get Weee Tax name.\n         *\n         * @param {String} taxAmount\n         * @return {String} Weee name\n         */\n        getWeeTaxAttributeName: function (taxAmount) {\n            return taxAmount['attribute_code'];\n        },\n\n        /**\n         * Set price type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Check if Weee Tax must be shown.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        isShown: function (row) {\n            return row['price_info']['extension_attributes']['weee_attributes'].length;\n        },\n\n        /**\n         * Get Weee final price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee final price html\n         */\n        getWeeeAdjustment: function (row) {\n            return row['price_info']['extension_attributes']['weee_adjustment'];\n        },\n\n        /**\n         * Return whether display setting is to display price including FPT only.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclFpt: function () {\n            return +this.source.data.displayWeee === this.inclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * price including FPT and FPT description.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclFptDescr: function () {\n            return +this.source.data.displayWeee === this.inclFptWithDesc;\n        },\n\n        /**\n         * Return whether display setting is to display price\n         * excluding FPT but including FPT description and final price.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclFptDescr: function () {\n            return +this.source.data.displayWeee === this.exclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding FPT.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclFpt: function () {\n            return +this.source.data.displayWeee === this.bothFptPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.inclFptWithDesc;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclTax: function () {\n            return +this.source.data.displayTaxes === this.exclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPricesTax: function () {\n            return +this.source.data.displayTaxes === this.bothFptPrices;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/configurable-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events',\n    'collapsible',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'domReady!'\n], function ($, productType) {\n    'use strict';\n\n    return {\n        $block: null,\n        hasVariations: null,\n        configurationSectionMessageHandler: (function () {\n            var title = $('[data-role=\"product-create-configuration-info\"]'),\n                buttons = $('[data-action=\"product-create-configuration-buttons\"]'),\n                newText = 'Configurations cannot be created for a standard product with downloadable files.' +\n                ' To create configurations, first remove all downloadable files.',\n                oldText = title.text();\n\n            return function (change) {\n                if (change) {\n                    title.text(newText);\n                    buttons.hide();\n                } else {\n                    title.text(oldText);\n                    buttons.show();\n                }\n            };\n        }()),\n\n        /**\n         * Set element disabled\n         * @param {Object} $element - jquery instance element\n         * @param {Bool} state\n         * @param {Bool} triggerEvent\n         * @private\n         */\n        _setElementDisabled: function ($element, state, triggerEvent) {\n            if (!$element.is('[data-locked]')) {\n                $element.prop('disabled', state);\n\n                if (triggerEvent) {\n                    $element.trigger('change');\n                }\n            }\n        },\n\n        /**\n         * Show\n         */\n        show: function () {\n            this.configurationSectionMessageHandler(false);\n        },\n\n        /**\n         * Hide\n         */\n        hide: function () {\n            this.configurationSectionMessageHandler(true);\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            $(document).on('changeConfigurableTypeProduct', function (event, isConfigurable) {\n                $(document).trigger('setTypeProduct', isConfigurable ?\n                    'configurable' :\n                    productType.type.init === 'configurable' ? 'simple' : productType.type.init\n                );\n            });\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n        },\n\n        /**\n         * Init type\n         * @private\n         */\n        _initType: function () {\n\n            /*var suggestContainer = $('#product-template-suggest-container .action-dropdown > .action-toggle');\n\n\n            if (productType.type.current === 'configurable') {\n                this._setElementDisabled(suggestContainer.addClass('disabled'), true);\n                this._setElementDisabled($('#inventory_qty'), true);\n                this._setElementDisabled($('#inventory_stock_availability'), false);\n                this._setElementDisabled($('#qty'), true, true);\n                this._setElementDisabled($('#quantity_and_stock_status'), false, false);\n            } else {\n                this._setElementDisabled(suggestContainer.removeClass('disabled'), false);\n                this._setElementDisabled($('#inventory_qty'), false);\n                this._setElementDisabled($('#inventory_stock_availability'), true);\n                this._setElementDisabled($('#qty'), false, true);\n            }\n            */\n\n            /*if (['simple', 'virtual', 'configurable'].indexOf(productType.type.current) < 0) {\n                this.hide();\n            } else {\n                this.show();\n            }*/\n\n            this.show();\n        },\n\n        /**\n         * Constructor component\n         * @param {Object} data - this backend data\n         */\n        'Magento_ConfigurableProduct/js/configurable-type-handler': function (data) {\n            this.$block = $(data.blockId + ' input[name=\"attributes[]\"]');\n            this.hasVariations = data.hasVariations;\n\n            //advancedPricingHandler.init();\n            //priceTypeHandler.init();\n\n            /*if (productType.type.init === 'configurable' && !this.hasVariations) {\n                $(document).trigger('setTypeProduct', 'simple');\n            }*/\n            $(document).trigger('setTypeProduct', 'simple');\n\n            this.bindAll();\n            this._initType();\n        }\n    };\n});\n","Magento_ConfigurableProduct/js/configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**************************** CONFIGURABLE PRODUCT **************************/\n/* global Product, optionsPrice */\ndefine([\n    'jquery',\n    'mage/template',\n    'mage/translate',\n    'prototype'\n], function (jQuery, mageTemplate) {\n    'use strict';\n\n    if (typeof Product == 'undefined') {\n        window.Product = {};\n    }\n\n    Product.Config = Class.create();\n    Product.Config.prototype = {\n        /**\n         * Initialize function.\n         *\n         * @param {Object} config\n         */\n        initialize: function (config) {\n            var separatorIndex, paramsStr, urlValues, i, childSettings, prevSetting, nextSetting;\n\n            // Magic preprocessing\n            // TODO MAGETWO-31539\n            config.taxConfig = {\n                showBothPrices: false,\n                inclTaxTitle: jQuery.mage.__('Incl. Tax')\n            };\n\n            this.config     = config;\n            this.taxConfig  = this.config.taxConfig;\n\n            if (config.containerId) {\n                this.settings   = $$('#' + config.containerId + ' ' + '.super-attribute-select');\n            } else {\n                this.settings   = $$('.super-attribute-select');\n            }\n            this.state      = new Hash();\n            this.priceTemplate = mageTemplate(this.config.template);\n            this.prices     = config.prices;\n            this.values     = {};\n\n            // Set default values from config\n            if (config.defaultValues) {\n                this.values = config.defaultValues;\n            }\n\n            // Overwrite defaults by url\n            separatorIndex = window.location.href.indexOf('#');\n\n            if (separatorIndex != -1) { //eslint-disable-line eqeqeq\n                paramsStr = window.location.href.substr(separatorIndex + 1);\n                urlValues = paramsStr.toQueryParams();\n\n                for (i in urlValues) { //eslint-disable-line guard-for-in\n                    this.values[i] = urlValues[i];\n                }\n            }\n\n            // Overwrite defaults by inputs values if needed\n            if (config.inputsInitialized) {\n                this.values = {};\n                this.settings.each(function (element) {\n                    var attributeId;\n\n                    if (element.value) {\n                        attributeId = element.id.replace(/[a-z]*/, '');\n                        this.values[attributeId] = element.value;\n                    }\n                }.bind(this));\n            }\n\n            // Put events to check select reloads\n            this.settings.each(function (element) {\n                Event.observe(element, 'change', this.configure.bind(this));\n            }.bind(this));\n\n            // fill state\n            this.settings.each(function (element) {\n                var attributeId = element.id.replace(/[a-z]*/, '');\n\n                if (attributeId && this.config.attributes[attributeId]) {\n                    element.config = this.config.attributes[attributeId];\n                    element.attributeId = attributeId;\n                    this.state[attributeId] = false;\n                }\n            }.bind(this));\n\n            // Init settings dropdown\n            childSettings = [];\n\n            for (i = this.settings.length - 1; i >= 0; i--) {\n                prevSetting = this.settings[i - 1] ? this.settings[i - 1] : false;\n                nextSetting = this.settings[i + 1] ? this.settings[i + 1] : false;\n\n                if (i === 0) {\n                    this.fillSelect(this.settings[i]);\n                } else {\n                    this.settings[i].disabled = true;\n                }\n                $(this.settings[i]).childSettings = childSettings.clone();\n                $(this.settings[i]).prevSetting   = prevSetting;\n                $(this.settings[i]).nextSetting   = nextSetting;\n                childSettings.push(this.settings[i]);\n            }\n\n            // Set values to inputs\n            this.configureForValues();\n            document.observe('dom:loaded', this.configureForValues.bind(this));\n        },\n\n        /**\n         * Configure for values.\n         */\n        configureForValues: function () {\n            if (this.values) {\n                this.settings.each(function (element) {\n                    var attributeId = element.attributeId;\n\n                    element.value = typeof this.values[attributeId] === 'undefined' ? '' : this.values[attributeId];\n                    this.configureElement(element);\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @param {Object} event\n         */\n        configure: function (event) {\n            var element = Event.element(event);\n\n            this.configureElement(element);\n        },\n\n        /**\n         * @param {Object} element\n         */\n        configureElement: function (element) {\n            this.reloadOptionLabels(element);\n\n            if (element.value) {\n                this.state[element.config.id] = element.value;\n\n                if (element.nextSetting) {\n                    element.nextSetting.disabled = false;\n                    this.fillSelect(element.nextSetting);\n                    this.resetChildren(element.nextSetting);\n                }\n            } else {\n                this.resetChildren(element);\n            }\n            this.reloadPrice();\n        },\n\n        /**\n         * @param {Object} element\n         */\n        reloadOptionLabels: function (element) {\n            var selectedPrice = 0,\n                option, i;\n\n            if (element.options[element.selectedIndex] && element.options[element.selectedIndex].config) {\n                option = element.options[element.selectedIndex].config;\n                selectedPrice = parseFloat(this.config.optionPrices[option.allowedProducts[0]].finalPrice.amount);\n            }\n            element.setAttribute('price', selectedPrice);\n\n            for (i = 0; i < element.options.length; i++) {\n                if (element.options[i].config) {\n                    element.options[i].setAttribute('price', selectedPrice);\n                    element.options[i].setAttribute('summarizePrice', 0);\n                    element.options[i].text = this.getOptionLabel(element.options[i].config, selectedPrice);\n                }\n            }\n        },\n\n        /* eslint-disable max-depth */\n        /**\n         * @param {Object} element\n         */\n        resetChildren: function (element) {\n            var i;\n\n            if (element.childSettings) {\n                for (i = 0; i < element.childSettings.length; i++) {\n                    element.childSettings[i].selectedIndex = 0;\n                    element.childSettings[i].disabled = true;\n\n                    if (element.config) {\n                        this.state[element.config.id] = false;\n                    }\n                }\n            }\n        },\n\n        /**\n         * @param {Object} element\n         */\n        fillSelect: function (element) {\n            var attributeId = element.id.replace(/[a-z]*/, ''),\n                options = this.getAttributeOptions(attributeId),\n                prevConfig = false,\n                index = 1,\n                i, j, allowedProducts;\n\n            this.clearSelect(element);\n            element.options[0] = new Option('', '');\n            element.options[0].innerHTML = this.config.chooseText;\n\n            if (element.prevSetting) {\n                prevConfig = element.prevSetting.options[element.prevSetting.selectedIndex];\n            }\n\n            if (options) {\n                for (i = 0; i < options.length; i++) {\n                    allowedProducts = [];\n\n                    if (prevConfig) {\n                        for (j = 0; j < options[i].products.length; j++) {\n                            if (prevConfig.config.allowedProducts &&\n                                prevConfig.config.allowedProducts.indexOf(options[i].products[j]) > -1\n                            ) {\n                                allowedProducts.push(options[i].products[j]);\n                            }\n                        }\n                    } else {\n                        allowedProducts = options[i].products.clone();\n                    }\n\n                    if (allowedProducts.size() > 0) {\n                        options[i].allowedProducts = allowedProducts;\n                        element.options[index] = new Option(this.getOptionLabel(options[i]), options[i].id);\n\n                        if (typeof options[i].price != 'undefined') {\n                            element.options[index].setAttribute('price', options[i].price);\n                        }\n                        element.options[index].config = options[i];\n                        index++;\n                    }\n                }\n            }\n        },\n\n        //eslint-enable max-depth\n        /**\n         * @param {Object} option\n         */\n        getOptionLabel: function (option) {\n            return option.label;\n        },\n\n        /**\n         * @param {*} price\n         * @param {Boolean} showSign\n         * @return {String}\n         */\n        formatPrice: function (price, showSign) {\n            var str = '',\n                roundedPrice;\n\n            price = parseFloat(price);\n\n            if (showSign) {\n                if (price < 0) {\n                    str += '-';\n                    price = -price;\n                } else {\n                    str += '+';\n                }\n            }\n\n            roundedPrice = Number(Math.round(price + 'e+2') + 'e-2').toString();\n\n            if (this.prices && this.prices[roundedPrice]) {\n                str += this.prices[roundedPrice];\n            } else {\n                str += this.priceTemplate({\n                    data: {\n                        price: price.toFixed(2)\n                    }\n                });\n            }\n\n            return str;\n        },\n\n        /**\n         * @param {Object} element\n         */\n        clearSelect: function (element) {\n            var i;\n\n            for (i = element.options.length - 1; i >= 0; i--) {\n                element.remove(i);\n            }\n        },\n\n        /**\n         * @param {*} attributeId\n         * @return {*|undefined}\n         */\n        getAttributeOptions: function (attributeId) {\n            if (this.config.attributes[attributeId]) {\n                return this.config.attributes[attributeId].options;\n            }\n        },\n\n        /**\n         * Reload price.\n         *\n         * @return {undefined|Number}\n         */\n        reloadPrice: function () {\n            var price = 0,\n                oldPrice = 0,\n                inclTaxPrice = 0,\n                exclTaxPrice = 0,\n                i, selected;\n\n            if (this.config.disablePriceReload) {\n                return undefined;\n            }\n\n            for (i = this.settings.length - 1; i >= 0; i--) {\n                selected = this.settings[i].options[this.settings[i].selectedIndex];\n\n                if (selected.config) {\n                    price += parseFloat(selected.config.price);\n                    oldPrice += parseFloat(selected.config.oldPrice);\n                    inclTaxPrice += parseFloat(selected.config.inclTaxPrice);\n                    exclTaxPrice += parseFloat(selected.config.exclTaxPrice);\n                }\n            }\n\n            optionsPrice.changePrice(\n                'config', {\n                    'price': price,\n                    'oldPrice': oldPrice,\n                    'inclTaxPrice': inclTaxPrice,\n                    'exclTaxPrice': exclTaxPrice\n                }\n            );\n            optionsPrice.reload();\n\n            return price;\n        },\n\n        /**\n         * Reload old price.\n         */\n        reloadOldPrice: function () {\n            var price, i, selected;\n\n            if (this.config.disablePriceReload) {\n                return;\n            }\n\n            if ($('old-price-' + this.config.productId)) {\n\n                price = parseFloat(this.config.oldPrice);\n\n                for (i = this.settings.length - 1; i >= 0; i--) {\n                    selected = this.settings[i].options[this.settings[i].selectedIndex];\n\n                    if (selected.config) {\n                        price += parseFloat(selected.config.price);\n                    }\n                }\n\n                if (price < 0) {\n                    price = 0;\n                }\n                price = this.formatPrice(price);\n\n                if ($('old-price-' + this.config.productId)) {\n                    $('old-price-' + this.config.productId).innerHTML = price;\n                }\n\n            }\n        }\n    };\n});\n","Magento_ConfigurableProduct/js/options/price-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events',\n    'notification',\n    'mage/translate'\n], function ($, productType) {\n    'use strict';\n\n    return {\n        isConfigurable: false,\n        messageInited: false,\n        messageSelector: '[data-role=product-custom-options-content]',\n        isPercentPriceTypeExist: function () {\n            var productOptionsContainer = $('#product_options_container_top');\n\n            return !!productOptionsContainer.length;\n        },\n        showWarning: function () {\n            if (!this.messageInited) {\n                $(this.messageSelector).notification();\n                this.messageInited = true;\n            }\n            this.hideWarning();\n            $(this.messageSelector).notification('add', {\n                message: $.mage.__('Custom options with price type \"percent\" is not available for ' +\n                    'configurable product.'),\n                error: false,\n                messageContainer: this.messageSelector\n            });\n        },\n        hideWarning: function () {\n            $(this.messageSelector).notification('clear');\n        },\n        init: function () {\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n\n            $('#product-edit-form-tabs').on('change', '.opt-type > select', function () {\n                var selected = $('.opt-type > select :selected'),\n                    optGroup = selected.parent().attr('label');\n\n                if (optGroup === 'Select') {\n                    $('#product-edit-form-tabs').on(\n                        'click',\n                        '[data-ui-id=\"admin-product-options-options-box-select-option-type-add-select-row-button\"]',\n                        function () {\n                            this.percentPriceTypeHandler();\n                        }.bind(this)\n                    );\n                } else {\n                    this.percentPriceTypeHandler();\n                }\n            }.bind(this));\n\n            this._initType();\n        },\n        _initType: function () {\n            this.isConfigurable = productType.type.current === 'configurable';\n            if (this.isPercentPriceTypeExist()) {\n                this.percentPriceTypeHandler();\n            }\n        },\n        percentPriceTypeHandler: function () {\n            var priceType = $('[data-attr=\"price-type\"]'),\n                optionPercentPriceType = priceType.find('option[value=\"percent\"]');\n\n            if (this.isConfigurable) {\n                this.showWarning();\n                optionPercentPriceType.hide();\n                optionPercentPriceType.parent().val() === 'percent' ? optionPercentPriceType.parent().val('fixed') : '';\n            } else {\n                $(this.messageSelector).notification();\n                optionPercentPriceType.show();\n                this.hideWarning();\n            }\n        }\n    };\n});\n*/\n","Magento_ConfigurableProduct/js/variations/product-grid.js":"// jscs:disable requireDotNotation\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'Magento_Ui/js/core/app',\n    'underscore',\n    'notification',\n    'mage/translate'\n], function (Component, $, bootstrap, _) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            productsGridUrl: null,\n            productAttributes: [],\n            productsModal: null,\n            button: '',\n            gridSelector: '[data-grid-id=associated-products-container]',\n            modules: {\n                productsFilter: '${ $.productsFilter }',\n                productsProvider: '${ $.productsProvider }',\n                productsMassAction: '${ $.productsMassAction }',\n                productsColumns: '${ $.productsColumns }',\n                variationsComponent: '${ $.configurableVariations }'\n            },\n            listens: {\n                '${ $.productsProvider }:data': '_showMessageAssociatedGrid _handleManualGridOpening',\n                '${ $.productsMassAction }:selected': '_handleManualGridSelect',\n                '${ $.configurableVariations }:productMatrix': '_showButtonAddManual _switchProductType'\n            }\n        },\n\n        /**\n         * Initialize\n         *\n         * @param {Array} options\n         */\n        initialize: function (options) {\n            this._super(options);\n            this.productsModal = $(this.gridSelector).modal({\n                title: $.mage.__('Select Associated Product'),\n                type: 'slide',\n                buttons: [\n                    {\n                        text: $.mage.__('Cancel'),\n\n                        /** Close modal */\n                        click: function () {\n                            this.closeModal();\n                        }\n                    }, {\n                        text: $.mage.__('Done'),\n                        click: this.close.bind(this, null)\n                    }\n                ]\n            });\n\n            this.productsProvider(function () {\n                this.productsModal.notification();\n            }.bind(this));\n            this.variationsComponent(function (variation) {\n                this._showButtonAddManual(variation.productMatrix());\n            }.bind(this));\n\n            this._initGrid = _.once(this._initGrid);\n            this._switchProductType = _.wrap(this._switchProductType.bind(this), function (func, params) {\n                if (!!params.length !== !!this.init) {\n                    this.init = !!params.length;\n                    func(params);\n                }\n            }.bind(this._switchProductType));\n        },\n\n        /**\n         * Initial observerable\n         * @returns {*}\n         */\n        initObservable: function () {\n            this._super().observe('button');\n\n            return this;\n        },\n\n        /**\n         * init Grid\n         * @private\n         */\n        _initGrid: function (filterData) {\n            $.ajax({\n                type: 'GET',\n                url: this._buildGridUrl(filterData),\n                context: $('body')\n            }).done(function (data) {\n                bootstrap(JSON.parse(data));\n            });\n        },\n\n        /**\n         * Select different product in configurations section\n         * @see configurable_associated_product_listing.xml\n         * @param {Integer} rowIndex\n         */\n        selectProduct: function (rowIndex) {\n            this.close(rowIndex);\n        },\n\n        /**\n         * Open\n         * @param {Object} filterData - filter data\n         * @param {Object|*} filterData.filters - attribute name\n         * @param {Object|*} filterData.filters_modifier - modifier value\n         * @param {String} callbackName\n         * @param {Boolean} showMassActionColumn\n         */\n        open: function (filterData, callbackName, showMassActionColumn) {\n            this.callbackName = callbackName;\n            this.productsMassAction(function (massActionComponent) {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = showMassActionColumn;\n                });\n                massActionComponent.visible = showMassActionColumn;\n            }.bind(this));\n            this._setFilter(filterData);\n            this._initGrid(filterData);\n            this.productsModal.trigger('openModal');\n        },\n\n        /**\n         * Close\n         */\n        close: function (rowIndex) {\n            try {\n                if (this.productsMassAction().selected.getLength()) {\n                    this.variationsComponent()[this.callbackName](this.productsMassAction()\n                        .selected.map(this.getProductById.bind(this)));\n                    this.productsMassAction().deselectAll();\n                } else if (!_.isNull(rowIndex)) {\n                    this.variationsComponent()[this.callbackName]([this.getProductByIndex(rowIndex)]);\n                }\n                this.productsModal.trigger('closeModal');\n            } catch (e) {\n                if (e.name === 'UserException') {\n                    this.productsModal.notification('clear');\n                    this.productsModal.notification('add', {\n                        message: e.message,\n                        messageContainer: this.gridSelector\n                    });\n                } else {\n                    throw e;\n                }\n            }\n        },\n\n        /**\n         * Get product by id\n         * @param {Integer} productId\n         * @returns {*}\n         */\n        getProductById: function (productId) {\n            return _.findWhere(this.productsProvider().data.items, {\n                'entity_id': productId\n            });\n        },\n\n        /**\n         * Get product\n         * @param {Integer} rowIndex\n         * @returns {*}\n         */\n        getProductByIndex: function (rowIndex) {\n            return this.productsProvider().data.items[rowIndex];\n        },\n\n        /**\n         * Build grid url\n         * @private\n         */\n        _buildGridUrl: function (filterData) {\n            var params = '?' + $.param({\n                'filters': filterData.filters,\n                'attributes_codes': this._getAttributesCodes(),\n                'filters_modifier': filterData['filters_modifier']\n            });\n\n            return this.productsGridUrl + params;\n        },\n\n        /**\n         * Show button add manual\n         * @param {Array} variations\n         * @returns {*}\n         * @private\n         */\n        _showButtonAddManual: function (variations) {\n            return this.button(variations.length);\n        },\n\n        /**\n         * @param {Array} variations\n         * @private\n         */\n        _switchProductType: function (variations) {\n            $(document).trigger('changeConfigurableTypeProduct', variations.length);\n        },\n\n        /**\n         * Get attributes codes used for configurable\n         * @private\n         */\n        _getAttributesCodes: function () {\n            return this.variationsComponent().attributes.pluck('code');\n        },\n\n        /**\n         * Show data associated grid\n         * @private\n         */\n        _showMessageAssociatedGrid: function (data) {\n            this.productsModal.notification('clear');\n\n            if (data.items.length) {\n                this.productsModal.notification('add', {\n                    message: $.mage.__('Choose a new product to delete and replace the current product configuration.'),\n                    messageContainer: this.gridSelector\n                });\n            } else {\n                this.productsModal.notification('add', {\n                    message: $.mage.__('For better results, add attributes and attribute values to your products.'),\n                    messageContainer: this.gridSelector\n                });\n            }\n        },\n\n        /**\n         * Show manually grid\n         */\n        showManuallyGrid: function () {\n            var filterModifier = _.mapObject(_.object(this._getAttributesCodes(), []), function () {\n                    return {\n                        'condition_type': 'notnull'\n                    };\n                }),\n                usedProductIds = _.values(this.variationsComponent().productAttributesMap);\n\n            if (usedProductIds && usedProductIds.length > 0) {\n                filterModifier['entity_id'] = {\n                    'condition_type': 'nin', value: usedProductIds\n                };\n            }\n\n            this.open(\n                {\n                    'filters_modifier': filterModifier\n                },\n                'appendProducts',\n                true\n            );\n        },\n\n        /**\n         * Handle manual grid after opening\n         * @private\n         */\n        _handleManualGridOpening: function (data) {\n            if (data.items.length && this.callbackName == 'appendProducts') { //eslint-disable-line eqeqeq\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = true;\n                });\n\n                this._disableRows(data.items);\n            }\n        },\n\n        /**\n         * Disable rows in grid for products with the same variation key\n         *\n         * @param {Array} items\n         * @param {Array} selectedVariationKeys\n         * @param {Array} selected\n         * @private\n         */\n        _disableRows: function (items, selectedVariationKeys, selected) {\n            selectedVariationKeys = selectedVariationKeys === undefined ? [] : selectedVariationKeys;\n            selected = selected === undefined ? [] : selected;\n            this.productsMassAction(function (massaction) {\n                var configurableVariationKeys = _.union(\n                        selectedVariationKeys,\n                        _.pluck(this.variationsComponent().productMatrix(), 'variationKey')\n                    ),\n                    variationKeyMap = this._getVariationKeyMap(items),\n                    rowsForDisable = _.keys(_.pick(\n                        variationKeyMap,\n                        function (variationKey) {\n                            return configurableVariationKeys.indexOf(variationKey) !== -1;\n                        }\n                    ));\n\n                massaction.disabled(_.difference(rowsForDisable, selected));\n            }.bind(this));\n        },\n\n        /**\n         * @private\n         */\n        _handleManualGridSelect: function (selected) {\n            var selectedRows, selectedVariationKeys;\n\n            if (this.callbackName == 'appendProducts') { //eslint-disable-line eqeqeq\n                selectedRows = _.filter(this.productsProvider().data.items, function (row) {\n                    return selected.indexOf(row['entity_id']) !== -1;\n                });\n                selectedVariationKeys = _.values(this._getVariationKeyMap(selectedRows));\n                this._disableRows(this.productsProvider().data.items, selectedVariationKeys, selected);\n            }\n        },\n\n        /**\n         * Get variation key map used in manual grid.\n         *\n         * @param {Object} items\n         * @returns {Array} [{entity_id: variation-key}, ...]\n         * @private\n         */\n        _getVariationKeyMap: function (items) {\n            this._variationKeyMap = {};\n\n            _.each(items, function (row) {\n                this._variationKeyMap[row['entity_id']] = _.values(\n                    _.pick(row, this._getAttributesCodes())\n                ).sort().join('-');\n\n            }, this);\n\n            return this._variationKeyMap;\n        },\n\n        /**\n         * Set filter\n         * @private\n         */\n        _setFilter: function (filterData) {\n            this.productsProvider(function (provider) {\n                provider.params['filters_modifier'] = filterData['filters_modifier'];\n                provider.params['attributes_codes'] = this._getAttributesCodes();\n            }.bind(this));\n\n            this.productsFilter(function (filter) {\n                filter.set('filters', _.extend({\n                    'filters_modifier': filterData['filters_modifier']\n                }, filterData.filters))\n                    .apply();\n            });\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/variations.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'uiRegistry',\n    'mage/translate'\n], function (Component, $, ko, _, alert, registry, $t) {\n    'use strict';\n\n    /**\n     * @param {*} message\n     * @constructor\n     */\n    function UserException(message) {\n        this.message = message;\n        this.name = 'UserException';\n    }\n    UserException.prototype = Object.create(Error.prototype);\n\n    return Component.extend({\n        defaults: {\n            opened: false,\n            attributes: [],\n            usedAttributes: [],\n            attributeCodes: [],\n            attributesData: {},\n            productMatrix: [],\n            variations: [],\n            formSaveParams: [],\n            productAttributes: [],\n            disabledAttributes: [],\n            fullAttributes: [],\n            rowIndexToEdit: false,\n            productAttributesMap: null,\n            value: [],\n            modules: {\n                associatedProductGrid: '${ $.configurableProductGrid }',\n                wizardButtonElement: '${ $.wizardModalButtonName }',\n                formElement: '${ $.formName }',\n                attributeSetHandlerModal: '${ $.attributeSetHandler }'\n            },\n            imports: {\n                attributeSetName: '${ $.provider }:configurableNewAttributeSetName',\n                attributeSetId: '${ $.provider }:configurableExistingAttributeSetId',\n                attributeSetSelection: '${ $.provider }:configurableAffectedAttributeSet',\n                productPrice: '${ $.provider }:data.product.price'\n            },\n            links: {\n                value: '${ $.provider }:${ $.dataScopeVariations }',\n                usedAttributes: '${ $.provider }:${ $.dataScopeAttributes }',\n                attributesData: '${ $.provider }:${ $.dataScopeAttributesData }',\n                attributeCodes: '${ $.provider }:${ $.dataScopeAttributeCodes }',\n                skeletonAttributeSet: '${ $.provider }:data.new-variations-attribute-set-id'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.changeButtonWizard();\n            this.initProductAttributesMap();\n            this.disableConfigurableAttributes(this.productAttributes);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(\n                'actions opened attributes productMatrix value usedAttributes attributesData attributeCodes'\n            );\n\n            return this;\n        },\n\n        /**\n         * @param {Object} product\n         * @return {Object}\n         * @private\n         */\n        _makeProduct: function (product) {\n            var productId = product['entity_id'] || product.productId || null,\n                attributes = _.pick(product, this.attributes.pluck('code')),\n                options = _.map(attributes, function (option, attribute) {\n                    var oldOptions = _.findWhere(this.attributes(), {\n                            code: attribute\n                        }).options,\n                        result;\n\n                    if (_.isFunction(oldOptions)) {\n                        result = oldOptions.findWhere({\n                            value: option\n                        });\n                    } else {\n                        result = _.findWhere(oldOptions, {\n                            value: option\n                        });\n                    }\n\n                    return result;\n                }.bind(this));\n\n            return {\n                attribute: JSON.stringify(attributes),\n                editable: false,\n                images: {\n                    preview: product['thumbnail_src']\n                },\n                name: product.name || product.sku,\n                options: options,\n                price: parseFloat(Math.round(product.price.replace(/[^\\d.]+/g, '') + 'e+4') + 'e-4').toFixed(4),\n                productId: productId,\n                productUrl: this.buildProductUrl(productId),\n                quantity: product.quantity || null,\n                sku: product.sku,\n                status: product.status === undefined ? 1 : parseInt(product.status, 10),\n                variationKey: this.getVariationKey(options),\n                weight: product.weight || null\n            };\n        },\n\n        /**\n         * @param {String} name\n         * @return {String|Number|Array}\n         */\n        getProductValue: function (name) {\n            name = name.split('/').join('][');\n\n            return $('[name=\"product[' + name + ']\"]:enabled:not(.ignore-validate)', this.productForm).val();\n        },\n\n        /**\n         * @param {Object} data\n         * @param {String} field\n         * @return {String}\n         */\n        getRowId: function (data, field) {\n            var key = data.variationKey;\n\n            return 'variations-matrix-' + key + '-' + field;\n        },\n\n        /**\n         * @param {Object} variation\n         * @param {String} field\n         * @return {String}\n         */\n        getVariationRowName: function (variation, field) {\n            var result;\n\n            if (variation.productId) {\n                result = 'configurations[' + variation.productId + '][' + field.split('/').join('][') + ']';\n            } else {\n                result = 'variations-matrix[' + variation.variationKey + '][' + field.split('/').join('][') + ']';\n            }\n\n            return result;\n        },\n\n        /**\n         * @param {*} variations\n         * @param {*} attributes\n         */\n        render: function (variations, attributes) {\n            this.changeButtonWizard();\n            this.populateVariationMatrix(variations);\n            this.attributes(attributes);\n            this.disableConfigurableAttributes(attributes);\n            this.handleValue(variations);\n            this.handleAttributes();\n        },\n\n        /**\n         * Change button wizard.\n         */\n        changeButtonWizard: function () {\n            if (this.variations.length) {\n                this.wizardButtonElement().title(this.wizardModalButtonTitle);\n            }\n        },\n\n        /**\n         * @param {Array} variations\n         */\n        handleValue: function (variations) {\n            var tmpArray = [];\n\n            _.each(variations, function (variation) {\n                var attributes = _.reduce(variation.options, function (memo, option) {\n                    var attribute = {};\n\n                    attribute[option['attribute_code']] = option.value;\n\n                    return _.extend(memo, attribute);\n                }, {}),\n                    gallery = {\n                        images: {}\n                    },\n                    types = {};\n\n                _.each(variation.images.images, function (image) {\n                    gallery.images[image['file_id']] = {\n                        position: image.position,\n                        file: image.file,\n                        disabled: image.disabled,\n                        label: image.label || ''\n                    };\n                    _.each(image.galleryTypes, function (type) {\n                        types[type] = image.file;\n                    });\n                }, this);\n\n                tmpArray.push(_.extend(variation, types, {\n                    productId: variation.productId || null,\n                    name: variation.name || variation.sku,\n                    priceCurrency: this.currencySymbol,\n                    weight: variation.weight,\n                    attribute: JSON.stringify(attributes),\n                    variationKey: this.getVariationKey(variation.options),\n                    editable: variation.editable === undefined ? 0 : 1,\n                    productUrl: this.buildProductUrl(variation.productId),\n                    status: variation.status === undefined ? 1 : parseInt(variation.status, 10),\n                    newProduct: variation.productId ? 0 : 1,\n                    'media_gallery': gallery\n                }));\n            }, this);\n\n            this.value(tmpArray);\n        },\n\n        /**\n         * Handle attributes.\n         */\n        handleAttributes: function () {\n            var tmpArray = [],\n                codesArray = [],\n                tmpOptions = {},\n                option = {},\n                position = 0,\n                values = {};\n\n            _.each(this.attributes(), function (attribute) {\n                tmpArray.push(attribute.id);\n                codesArray.push(attribute.code);\n                values = {};\n                _.each(attribute.chosen, function (row) {\n                    values[row.value] = {\n                        'include': '1',\n                        'value_index': row.value\n                    };\n                }, this);\n                option = {\n                    'attribute_id': attribute.id,\n                    'code': attribute.code,\n                    'label': attribute.label,\n                    'position': position,\n                    'values': values\n                };\n                tmpOptions[attribute.id] = option;\n                position++;\n            }, this);\n\n            this.attributesData(tmpOptions);\n            this.usedAttributes(tmpArray);\n            this.attributeCodes(codesArray);\n        },\n\n        /**\n         * Get attributes options\n         * @see use in matrix.phtml\n         *\n         * @returns {Array}\n         */\n        getAttributesOptions: function () {\n            return this.showVariations() ? this.productMatrix()[0].options : [];\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        showVariations: function () {\n            return this.productMatrix().length > 0;\n        },\n\n        /**\n         * @param {Array} variations\n         */\n        populateVariationMatrix: function (variations) {\n            this.productMatrix([]);\n            _.each(variations, function (variation) {\n                var attributes = _.reduce(variation.options, function (memo, option) {\n                    var attribute = {};\n\n                    attribute[option['attribute_code']] = option.value;\n\n                    return _.extend(memo, attribute);\n                }, {});\n\n                this.productMatrix.push(_.extend(variation, {\n                    productId: variation.productId || null,\n                    name: variation.name || variation.sku,\n                    weight: variation.weight,\n                    attribute: JSON.stringify(attributes),\n                    variationKey: this.getVariationKey(variation.options),\n                    editable: variation.editable === undefined ? !variation.productId : variation.editable,\n                    productUrl: this.buildProductUrl(variation.productId),\n                    status: variation.status === undefined ? 1 : parseInt(variation.status, 10)\n                }));\n            }, this);\n        },\n\n        /**\n         * @param {*} productId\n         */\n        buildProductUrl: function (productId) {\n            return this.productUrl.replace('%id%', productId);\n        },\n\n        /**\n         * @param {Object} options\n         * @return {String}\n         */\n        getVariationKey: function (options) {\n            return _.pluck(options, 'value').sort().join('-');\n        },\n\n        /**\n         * @param {*} options\n         * @return {*|null}\n         */\n        getProductIdByOptions: function (options) {\n            return this.productAttributesMap[this.getVariationKey(options)] || null;\n        },\n\n        /**\n         * Init product attributes map\n         */\n        initProductAttributesMap: function () {\n            if (this.productAttributesMap === null) {\n                this.productAttributesMap = {};\n                _.each(this.variations, function (product) {\n                    this.productAttributesMap[this.getVariationKey(product.options)] = product.productId;\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @param {Array} attributes\n         */\n        disableConfigurableAttributes: function (attributes) {\n            var element;\n\n            _.each(this.disabledAttributes, function (attribute) {\n                registry.get('inputName = ' + 'product[' + attribute + ']').disabled(false);\n            });\n            this.disabledAttributes = [];\n\n            _.each(attributes, function (attribute) {\n                element = registry.get('inputName = ' + 'product[' + attribute.code + ']');\n\n                if (!_.isUndefined(element)) {\n                    element.disabled(true);\n                    this.disabledAttributes.push(attribute.code);\n                }\n            }, this);\n        },\n\n        /**\n         * Get currency symbol\n         * @returns {String}\n         */\n        getCurrencySymbol: function () {\n            return this.currencySymbol;\n        },\n\n        /**\n         * Chose action for the form save button\n         */\n        saveFormHandler: function () {\n            this.formElement().validate();\n\n            if (this.formElement().source.get('params.invalid') === false) {\n                this.serializeData();\n            }\n\n            if (this.checkForNewAttributes()) {\n                this.formSaveParams = arguments;\n                this.attributeSetHandlerModal().openModal();\n            } else {\n                if (this.validateForm(this.formElement())) {\n                    this.clearOutdatedData();\n                }\n                this.formElement().save(arguments[0], arguments[1]);\n\n                if (this.formElement().source.get('params.invalid')) {\n                    this.unserializeData();\n                }\n            }\n        },\n\n        /**\n         * @param {Object} formElement\n         *\n         * Validates each form element and returns true, if all elements are valid.\n         */\n        validateForm: function (formElement) {\n            formElement.validate();\n\n            return !formElement.additionalInvalid && !formElement.source.get('params.invalid');\n        },\n\n        /**\n         * Serialize data for specific form fields\n         *\n         * Serializes some complex data fields\n         *\n         * Original fields:\n         *   - configurable-matrix;\n         *   - associated_product_ids.\n         *\n         * Serialized fields in request:\n         *   - configurable-matrix-serialized;\n         *   - associated_product_ids_serialized.\n         */\n        serializeData: function () {\n            if (this.source.data['configurable-matrix']) {\n                this.source.data['configurable-matrix-serialized'] =\n                    JSON.stringify(this.source.data['configurable-matrix']);\n            }\n\n            if (this.source.data['associated_product_ids']) {\n                this.source.data['associated_product_ids_serialized'] =\n                    JSON.stringify(this.source.data['associated_product_ids']);\n            }\n        },\n\n        /**\n         * Clear outdated data for specific form fields\n         *\n         * Outdated fields:\n         *   - configurable-matrix;\n         *   - associated_product_ids.\n         */\n        clearOutdatedData: function () {\n            if (this.source.data['configurable-matrix']) {\n                delete this.source.data['configurable-matrix'];\n            }\n\n            if (this.source.data['associated_product_ids']) {\n                delete this.source.data['associated_product_ids'];\n            }\n        },\n\n        /**\n         * Unserialize data for specific form fields\n         *\n         * Unserializes some fields that were serialized this.serializeData\n         */\n        unserializeData: function () {\n            if (this.source.data['configurable-matrix-serialized']) {\n                this.source.data['configurable-matrix'] =\n                    JSON.parse(this.source.data['configurable-matrix-serialized']);\n                delete this.source.data['configurable-matrix-serialized'];\n            }\n\n            if (this.source.data['associated_product_ids_serialized']) {\n                this.source.data['associated_product_ids'] =\n                    JSON.parse(this.source.data['associated_product_ids_serialized']);\n                delete this.source.data['associated_product_ids_serialized'];\n            }\n        },\n\n        /**\n         * Check for newly added attributes\n         * @returns {Boolean}\n         */\n        checkForNewAttributes: function () {\n            var element, newAttributes = false;\n\n            _.each(this.source.get('data.attribute_codes'), function (attribute) {\n                element = registry.get('index = ' + attribute);\n\n                if (_.isUndefined(element)) {\n                    newAttributes = true;\n                }\n            }, this);\n\n            return newAttributes;\n        },\n\n        /**\n         * New attributes handler\n         * @returns {Boolean}\n         */\n        addNewAttributeSetHandler: function () {\n            var chosenAttributeSetOption;\n\n            this.formElement().validate();\n\n            if (this.formElement().source.get('params.invalid') === false) {\n                chosenAttributeSetOption = this.attributeSetSelection;\n\n                if (chosenAttributeSetOption === 'new') {\n                    this.createNewAttributeSet();\n\n                    return false;\n                }\n\n                if (chosenAttributeSetOption === 'existing') {\n                    this.set(\n                        'skeletonAttributeSet',\n                        this.attributeSetId\n                    );\n                }\n\n                this.closeDialogAndProcessForm();\n\n                return true;\n            }\n\n            this.unserializeData();\n\n            return false;\n        },\n\n        /**\n         * Handles new attribute set creation\n         * @returns {Boolean}\n         */\n        createNewAttributeSet: function () {\n            var messageBoxElement = registry.get('index = affectedAttributeSetError');\n\n            messageBoxElement.visible(false);\n\n            $.ajax({\n                type: 'POST',\n                url: this.attributeSetCreationUrl,\n                data: {\n                    gotoEdit: 1,\n                    'attribute_set_name': this.attributeSetName,\n                    'skeleton_set': this.skeletonAttributeSet,\n                    'return_session_messages_only': 1\n                },\n                dataType: 'json',\n                showLoader: true,\n                context: this\n            }).done(function (data) {\n                if (!data.error) {\n                    this.set(\n                        'skeletonAttributeSet',\n                        data.id\n                    );\n                    messageBoxElement.content(data.messages);\n                    messageBoxElement.visible(true);\n                    this.closeDialogAndProcessForm();\n                } else {\n                    messageBoxElement.content(data.messages);\n                    messageBoxElement.visible(true);\n                }\n\n                return false;\n            }).fail(function (xhr) {\n                if (xhr.statusText === 'abort') {\n                    return;\n                }\n\n                alert({\n                    content: $t('Something went wrong.')\n                });\n            });\n\n            return false;\n        },\n\n        /**\n         * Closes attribute set handler modal and process product form\n         */\n        closeDialogAndProcessForm: function () {\n            this.attributeSetHandlerModal().closeModal();\n            this.formElement().save(this.formSaveParams[0], this.formSaveParams[1]);\n        },\n\n        /**\n         * Retrieves product price\n         * @returns {*}\n         */\n        getProductPrice: function () {\n            return this.productPrice;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/paging/sizes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/paging/sizes'\n], function (Sizes) {\n    'use strict';\n\n    return Sizes.extend({\n        defaults: {\n            options: {\n                '20': {\n                    value: 20,\n                    label: 20\n                },\n                '30': {\n                    value: 30,\n                    label: 30\n                },\n                '50': {\n                    value: 50,\n                    label: 50\n                }\n            },\n            value: 20\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/summary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/paging/paging',\n    'mage/translate'\n], function (Component, $, ko, _, paging) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            modules: {\n                variationsComponent: '${ $.variationsComponent }',\n                modalComponent: '${ $.modalComponent }'\n            },\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            gridExisting: [],\n            gridNew: [],\n            gridDeleted: [],\n            variationsExisting: [],\n            variationsNew: [],\n            variationsDeleted: [],\n            pagingExisting: paging({\n                name: 'configurableWizard.pagingExisting',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingExisting_sizes'\n                }\n            }),\n            pagingNew: paging({\n                name: 'configurableWizard.pagingNew',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingNew_sizes'\n                }\n            }),\n            pagingDeleted: paging({\n                name: 'configurableWizard.pagingDeleted',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingDeleted_sizes'\n                }\n            }),\n            attributes: [],\n            attributesName: [$.mage.__('Images'), $.mage.__('SKU'), $.mage.__('Quantity'), $.mage.__('Price')],\n            sections: [],\n            gridTemplate: 'Magento_ConfigurableProduct/variations/steps/summary-grid',\n            quantityFieldName: 'quantity'\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            var pagingObservables = {\n                currentNew: ko.getObservable(this.pagingNew, 'current'),\n                currentExisting: ko.getObservable(this.pagingExisting, 'current'),\n                currentDeleted: ko.getObservable(this.pagingDeleted, 'current'),\n                pageSizeNew: ko.getObservable(this.pagingNew, 'pageSize'),\n                pageSizeExisting: ko.getObservable(this.pagingExisting, 'pageSize'),\n                pageSizeDeleted: ko.getObservable(this.pagingDeleted, 'pageSize')\n            };\n\n            this._super().observe('gridExisting gridNew gridDeleted attributes sections');\n            this.gridExisting.columns = ko.observableArray();\n            this.gridNew.columns = ko.observableArray();\n            this.gridDeleted.columns = ko.observableArray();\n\n            _.each(pagingObservables, function (observable) {\n                observable.subscribe(function () {\n                    this.generateGrid();\n                }, this);\n            }, this);\n\n            return this;\n        },\n        nextLabelText: $.mage.__('Generate Products'),\n        variations: [],\n\n        /**\n         * @param {*} variations\n         * @param {Function} getSectionValue\n         */\n        calculate: function (variations, getSectionValue) {\n            var productSku = this.variationsComponent().getProductValue('sku'),\n                productPrice = this.variationsComponent().getProductPrice(),\n                productWeight = this.variationsComponent().getProductValue('weight'),\n                productName = this.variationsComponent().getProductValue('name'),\n                variationsKeys = [],\n                gridExisting = [],\n                gridNew = [],\n                gridDeleted = [];\n\n            this.variations = [];\n            _.each(variations, function (options) {\n                var product, images, sku, name, quantity, price, variation,\n                    productId = this.variationsComponent().getProductIdByOptions(options);\n\n                if (productId) {\n                    product = _.findWhere(this.variationsComponent().variations, {\n                        productId: productId\n                    });\n                }\n                images = getSectionValue('images', options);\n                sku = productSku + _.reduce(options, function (memo, option) {\n                    return memo + '-' + option.label;\n                }, '');\n                name = productName + _.reduce(options, function (memo, option) {\n                    return memo + '-' + option.label;\n                }, '');\n                quantity = getSectionValue(this.quantityFieldName, options);\n\n                if (!quantity && productId) {\n                    quantity = product[this.quantityFieldName];\n                }\n                price = getSectionValue('price', options);\n\n                if (!price) {\n                    price = productId ? product.price : productPrice;\n                }\n\n                if (productId && !images.file) {\n                    images = product.images;\n                }\n                variation = {\n                    options: options,\n                    images: images,\n                    sku: sku,\n                    name: name,\n                    price: price,\n                    productId: productId,\n                    weight: productWeight,\n                    editable: true\n                };\n                variation[this.quantityFieldName] = quantity;\n\n                if (productId) {\n                    variation.sku = product.sku;\n                    variation.weight = product.weight;\n                    variation.name = product.name;\n                    gridExisting.push(this.prepareRowForGrid(variation));\n                } else {\n                    gridNew.push(this.prepareRowForGrid(variation));\n                }\n                this.variations.push(variation);\n                variationsKeys.push(this.variationsComponent().getVariationKey(options));\n            }, this);\n\n            _.each(_.omit(this.variationsComponent().productAttributesMap, variationsKeys), function (productId) {\n                gridDeleted.push(this.prepareRowForGrid(\n                    _.findWhere(this.variationsComponent().variations, {\n                        productId: productId\n                    })\n                ));\n            }.bind(this));\n\n            this.variationsExisting = gridExisting;\n            this.variationsNew = gridNew;\n            this.variationsDeleted = gridDeleted;\n        },\n\n        /**\n         * Generate grid.\n         */\n        generateGrid: function () {\n            var pageExisting = this.pagingExisting.pageSize * this.pagingExisting.current,\n                pageNew = this.pagingNew.pageSize * this.pagingNew.current,\n                pageDeleted = this.pagingDeleted.pageSize * this.pagingDeleted.current;\n\n            this.pagingExisting.totalRecords = this.variationsExisting.length;\n            this.gridExisting(this.variationsExisting.slice(pageExisting - this.pagingExisting.pageSize, pageExisting));\n\n            this.pagingNew.totalRecords = this.variationsNew.length;\n            this.gridNew(this.variationsNew.slice(pageNew - this.pagingNew.pageSize, pageNew));\n\n            this.pagingDeleted.totalRecords = this.variationsDeleted.length;\n            this.gridDeleted(this.variationsDeleted.slice(pageDeleted - this.pagingDeleted.pageSize, pageDeleted));\n        },\n\n        /**\n         * @param {Object} variation\n         * @return {Array}\n         */\n        prepareRowForGrid: function (variation) {\n            var row = [];\n\n            row.push(_.extend({\n                images: []\n            }, variation.images));\n            row.push(variation.sku);\n            row.push(variation[this.quantityFieldName]);\n            _.each(variation.options, function (option) {\n                row.push(option.label);\n            });\n            row.push(this.variationsComponent().getCurrencySymbol() +  ' ' + variation.price);\n\n            return row;\n        },\n\n        /**\n         * @return {String|*}\n         */\n        getGridTemplate: function () {\n            return this.gridTemplate;\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getGridId: function () {\n            return _.uniqueId('grid_');\n        },\n\n        /**\n         * @param {*} attributes\n         * @return {Array}\n         */\n        getColumnsName: function (attributes) {\n            var columns = this.attributesName.slice(0);\n\n            attributes.each(function (attribute, index) {\n                columns.splice(3 + index, 0, attribute.label);\n            }, this);\n\n            return columns;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.sections(wizard.data.sections());\n            this.attributes(wizard.data.attributes());\n            this.gridNew([]);\n            this.gridExisting([]);\n            this.gridDeleted([]);\n            this.gridExisting.columns(this.getColumnsName(this.wizard.data.attributes));\n            this.gridNew.columns(this.getColumnsName(this.wizard.data.attributes));\n            this.gridDeleted.columns(this.getColumnsName(this.variationsComponent().productAttributes));\n            this.calculate(wizard.data.variations, wizard.data.sectionHelper);\n            this.generateGrid();\n        },\n\n        /**\n         * Force.\n         */\n        force: function () {\n            this.variationsComponent().render(this.variations, this.attributes());\n            this.modalComponent().closeModal();\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/bulk.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY, byteConvert */\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/lib/collapsible',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Catalog/js/product-gallery',\n    'jquery/file-uploader',\n    'mage/translate',\n    'Magento_ConfigurableProduct/js/variations/variations'\n], function (Component, $, ko, _, Collapsible, mageTemplate, alert) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            modules: {\n                variationsComponent: '${ $.variationsComponent }'\n            },\n            countVariations: 0,\n            attributes: [],\n            sections: {},\n            images: null,\n            price: '',\n            quantity: '',\n            notificationMessage: {\n                text: null,\n                error: null\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe('countVariations attributes sections');\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n            this.sections({\n                images: {\n                    label: 'images',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable()\n                },\n                price: {\n                    label: 'price',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable(),\n                    currencySymbol: ''\n                },\n                quantity: {\n                    label: 'quantity',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable()\n                }\n            });\n\n            this.variationsComponent(function (variationsComponent) {\n                this.sections().price.currencySymbol = variationsComponent.getCurrencySymbol();\n            }.bind(this));\n\n            /**\n             * Make options sections.\n             */\n            this.makeOptionSections = function () {\n                return {\n                    images: new this.makeImages(null),\n                    price: this.price,\n                    quantity: this.quantity\n                };\n            }.bind(this);\n\n            /**\n             * @param {Object} images\n             * @param {*} typePreview\n             */\n            this.makeImages = function (images, typePreview) {\n                var preview;\n\n                if (!images) {\n                    this.images = [];\n                    this.preview = self.noImage;\n                    this.file = null;\n                } else {\n                    this.images = images;\n                    preview = _.find(this.images, function (image) {\n                        return _.contains(image.galleryTypes, typePreview);\n                    });\n\n                    if (preview) {\n                        this.file = preview.file;\n                        this.preview = preview.url;\n                    } else {\n                        this.file = null;\n                        this.preview = self.noImage;\n                    }\n                }\n            };\n            this.images = new this.makeImages();\n            _.each(this.sections(), function (section) {\n                section.type.subscribe(function () {\n                    this.setWizardNotifyMessageDependOnSectionType();\n                }.bind(this));\n            }, this);\n        },\n        types: ['each', 'single', 'none'],\n\n        /**\n         * Set Wizard notify message depend on section type\n         */\n        setWizardNotifyMessageDependOnSectionType: function () {\n            var flag = false;\n\n            _.each(this.sections(), function (section) {\n                if (section.type() !== 'none') {\n                    flag = true;\n                }\n            }, this);\n\n            if (flag) {\n                this.wizard.setNotificationMessage(\n                    $.mage.__('Choose this option to delete and replace extension data for all past configurations.')\n                );\n            } else {\n                this.wizard.cleanNotificationMessage();\n            }\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.attributes(wizard.data.attributes());\n\n            if (this.mode === 'edit') {\n                this.setWizardNotifyMessageDependOnSectionType();\n            }\n            //fill option section data\n            this.attributes.each(function (attribute) {\n                attribute.chosen.each(function (option) {\n                    option.sections = ko.observable(this.makeOptionSections());\n                }, this);\n            }, this);\n            //reset section.attribute\n            _.each(this.sections(), function (section) {\n                section.attribute(null);\n            });\n\n            this.initCountVariations();\n            this.bindGalleries();\n        },\n\n        /**\n         * Init count variations.\n         */\n        initCountVariations: function () {\n            var variations = this.generateVariation(this.attributes()),\n                newVariations = _.map(variations, function (options) {\n                    return this.variationsComponent().getVariationKey(options);\n                }.bind(this)),\n                existingVariations = _.keys(this.variationsComponent().productAttributesMap);\n\n            this.countVariations(_.difference(newVariations, existingVariations).length);\n        },\n\n        /**\n         * @param {Object} attributes - example [['b1', 'b2'],['a1', 'a2', 'a3'],['c1', 'c2', 'c3'],['d1']]\n         * @returns {*} example [['b1','a1','c1','d1'],['b1','a1','c2','d1']...]\n         */\n        generateVariation: function (attributes) {\n            return _.reduce(attributes, function (matrix, attribute) {\n                var tmp = [];\n\n                _.each(matrix, function (variations) {\n                    _.each(attribute.chosen, function (option) {\n                        option['attribute_code'] = attribute.code;\n                        option['attribute_label'] = attribute.label;\n                        tmp.push(_.union(variations, [option]));\n                    });\n                });\n\n                if (!tmp.length) {\n                    return _.map(attribute.chosen, function (option) {\n                        option['attribute_code'] = attribute.code;\n                        option['attribute_label'] = attribute.label;\n\n                        return [option];\n                    });\n                }\n\n                return tmp;\n            }, []);\n        },\n\n        /**\n         * @param {*} section\n         * @param {Object} options\n         * @return {*}\n         */\n        getSectionValue: function (section, options) {\n            switch (this.sections()[section].type()) {\n                case 'each':\n                    return _.find(this.sections()[section].attribute().chosen, function (chosen) {\n                        return _.find(options, function (option) {\n                            return chosen.id == option.id; //eslint-disable-line eqeqeq\n                        });\n                    }).sections()[section];\n\n                case 'single':\n                    return this.sections()[section].value();\n\n                case 'none':\n                    return this[section];\n            }\n        },\n\n        /**\n         * @param {*} node\n         * @return {Promise|*}\n         */\n        getImageProperty: function (node) {\n            var types = node.find('[data-role=gallery]').productGallery('option').types,\n                images = _.map(node.find('[data-role=image]'), function (image) {\n                    var imageData = $(image).data('imageData');\n\n                    imageData.galleryTypes = _.pluck(_.filter(types, function (type) {\n                        return type.value === imageData.file;\n                    }), 'code');\n\n                    return imageData;\n                });\n\n            return _.reject(images, function (image) {\n                return !!image.isRemoved;\n            });\n        },\n\n        /**\n         * Fill images section.\n         */\n        fillImagesSection: function () {\n            switch (this.sections().images.type()) {\n                case 'each':\n                    if (this.sections().images.attribute()) {\n                        this.sections().images.attribute().chosen.each(function (option) {\n                            option.sections().images = new this.makeImages(\n                                this.getImageProperty($('[data-role=step-gallery-option-' + option.id + ']')),\n                                'thumbnail'\n                            );\n                        }, this);\n                    }\n                    break;\n\n                case 'single':\n                    this.sections().images.value(new this.makeImages(\n                        this.getImageProperty($('[data-role=step-gallery-single]')),\n                        'thumbnail'\n                    ));\n                    break;\n\n                default:\n                    this.sections().images.value(new this.makeImages());\n                    break;\n            }\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            this.fillImagesSection();\n            this.validate();\n            this.validateImage();\n            wizard.data.sections = this.sections;\n            wizard.data.sectionHelper = this.getSectionValue.bind(this);\n            wizard.data.variations = this.generateVariation(this.attributes());\n        },\n\n        /**\n         * Validate.\n         */\n        validate: function () {\n            var formValid;\n\n            _.each(this.sections(), function (section) {\n                switch (section.type()) {\n                    case 'each':\n                        if (!section.attribute()) {\n                            throw new Error($.mage.__('Please select attribute for {section} section.')\n                                .replace('{section}', section.label));\n                        }\n                        break;\n\n                    case 'single':\n                        if (!section.value()) {\n                            throw new Error($.mage.__('Please fill in the values for {section} section.')\n                                .replace('{section}', section.label));\n                        }\n                        break;\n                }\n            }, this);\n            formValid = true;\n            _.each($('[data-role=attributes-values-form]'), function (form) {\n                formValid = $(form).valid() && formValid;\n            });\n\n            if (!formValid) {\n                throw new Error($.mage.__('Please fill-in correct values.'));\n            }\n        },\n\n        /**\n         * Validate image.\n         */\n        validateImage: function () {\n            switch (this.sections().images.type()) {\n                case 'each':\n                    _.each(this.sections().images.attribute().chosen, function (option) {\n                        if (!option.sections().images.images.length) {\n                            throw new Error($.mage.__('Please select image(s) for your attribute.'));\n                        }\n                    });\n                    break;\n\n                case 'single':\n                    if (this.sections().images.value().file == null) {\n                        throw new Error($.mage.__('Please choose image(s).'));\n                    }\n                    break;\n            }\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n            this.setWizardNotifyMessageDependOnSectionType();\n        },\n\n        /**\n         * Bind galleries.\n         */\n        bindGalleries: function () {\n            $('[data-role=bulk-step] [data-role=gallery]').each(function (index, element) {\n                var gallery = $(element),\n                    uploadInput = $(gallery.find('[name=image]')),\n                    dropZone = $(gallery).find('.image-placeholder');\n\n                if (!gallery.data('gallery-initialized')) {\n                    gallery.mage('productGallery', {\n                        template: '[data-template=gallery-content]',\n                        dialogTemplate: '.dialog-template',\n                        dialogContainerTmpl: '[data-role=img-dialog-container-tmpl]'\n                    });\n\n                    uploadInput.fileupload({\n                        dataType: 'json',\n                        dropZone: dropZone,\n                        process: [{\n                            action: 'load',\n                            fileTypes: /^image\\/(gif|jpeg|png)$/\n                        }, {\n                            action: 'resize',\n                            maxWidth: 1920,\n                            maxHeight: 1200\n                        }, {\n                            action: 'save'\n                        }],\n                        formData: {\n                            'form_key': FORM_KEY\n                        },\n                        sequentialUploads: true,\n                        acceptFileTypes: /(\\.|\\/)(gif|jpe?g|png)$/i,\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        add: function (e, data) {\n                            var progressTmpl = mageTemplate('[data-template=uploader]'),\n                                fileSize,\n                                tmpl;\n\n                            $.each(data.files, function (i, file) {\n                                fileSize = typeof file.size == 'undefined' ?\n                                    $.mage.__('We could not detect a size.') :\n                                    byteConvert(file.size);\n\n                                data.fileId = Math.random().toString(33).substr(2, 18);\n\n                                tmpl = progressTmpl({\n                                    data: {\n                                        name: file.name,\n                                        size: fileSize,\n                                        id: data.fileId\n                                    }\n                                });\n\n                                $(tmpl).appendTo(gallery.find('[data-role=uploader]'));\n                            });\n\n                            $(this).fileupload('process', data).done(function () {\n                                data.submit();\n                            });\n                        },\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        done: function (e, data) {\n                            if (data.result && !data.result.error) {\n                                gallery.trigger('addItem', data.result);\n                            } else {\n                                $('#' + data.fileId)\n                                    .delay(2000)\n                                    .hide('highlight');\n                                alert({\n                                    content: $.mage.__('We don\\'t recognize or support this file extension type.')\n                                });\n                            }\n                            $('#' + data.fileId).remove();\n                        },\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        progress: function (e, data) {\n                            var progress = parseInt(data.loaded / data.total * 100, 10),\n                                progressSelector = '#' + data.fileId + ' .progressbar-container .progressbar';\n\n                            $(progressSelector).css('width', progress + '%');\n                        },\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        fail: function (e, data) {\n                            var progressSelector = '#' + data.fileId;\n\n                            $(progressSelector).removeClass('upload-progress').addClass('upload-failure')\n                                .delay(2000)\n                                .hide('highlight')\n                                .remove();\n                        }\n                    });\n                    gallery.data('gallery-initialized', 1);\n                }\n            });\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/select_attributes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'underscore',\n    'mage/translate'\n], function (Component, $, _) {\n    'use strict';\n\n    /**\n     * @param {Function} provider\n     */\n    var initNewAttributeListener = function (provider) {\n        $('[data-role=product-variations-matrix]').on('add', function () {\n            provider().reload();\n        });\n    };\n\n    return Component.extend({\n        attributesLabels: {},\n        stepInitialized: false,\n        defaults: {\n            modules: {\n                multiselect: '${ $.multiselectName }',\n                attributeProvider: '${ $.providerName }'\n            },\n            listens: {\n                '${ $.multiselectName }:selected': 'doSelectedAttributesLabels',\n                '${ $.multiselectName }:rows': 'doSelectSavedAttributes'\n            },\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            selectedAttributes: []\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.selected = [];\n\n            initNewAttributeListener(this.attributeProvider);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(['selectedAttributes']);\n\n            return this;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.setNotificationMessage();\n        },\n\n        /**\n         * Set notification message.\n         */\n        setNotificationMessage: function () {\n            /*eslint-disable max-len*/\n            var msg = $.mage.__('When you remove or add an attribute, we automatically update all configurations and you will need to recreate current configurations manually.');\n\n            /*eslint-enable max-len*/\n\n            if (this.mode === 'edit') {\n                this.wizard.setNotificationMessage(msg);\n            }\n        },\n\n        /**\n         * Do select saved attributes.\n         */\n        doSelectSavedAttributes: function () {\n            if (this.stepInitialized === false) {\n                this.stepInitialized = true;\n                //cache attributes labels, which can be present on the 2nd page\n                _.each(this.initData.attributes, function (attribute) {\n                    this.attributesLabels[attribute.id] = attribute.label;\n                }.bind(this));\n                this.multiselect().selected(_.pluck(this.initData.attributes, 'id'));\n            }\n        },\n\n        /**\n         * @param {*} selected\n         */\n        doSelectedAttributesLabels: function (selected) {\n            var labels = [];\n\n            this.selected = selected;\n            _.each(selected, function (attributeId) {\n                var attribute;\n\n                if (!this.attributesLabels[attributeId]) {\n                    attribute = _.findWhere(this.multiselect().rows(), {\n                        'attribute_id': attributeId\n                    });\n\n                    if (attribute) {\n                        this.attributesLabels[attribute['attribute_id']] = attribute['frontend_label'];\n                    }\n                }\n                labels.push(this.attributesLabels[attributeId]);\n            }.bind(this));\n            this.selectedAttributes(labels.join(', '));\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            wizard.data.attributesIds = this.multiselect().selected;\n\n            if (!wizard.data.attributesIds() || wizard.data.attributesIds().length === 0) {\n                throw new Error($.mage.__('Please select attribute(s).'));\n            }\n            this.setNotificationMessage();\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/attributes_values.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'mageUtils',\n    'Magento_Ui/js/lib/collapsible',\n    'mage/translate'\n], function (Component, $, ko, _, utils, Collapsible) {\n    'use strict';\n\n    //connect items with observableArrays\n    ko.bindingHandlers.sortableList = {\n        /** @inheritdoc */\n        init: function (element, valueAccessor) {\n            var list = valueAccessor();\n\n            $(element).sortable({\n                axis: 'y',\n                handle: '[data-role=\"draggable\"]',\n                tolerance: 'pointer',\n\n                /** @inheritdoc */\n                update: function (event, ui) {\n                    var item = ko.contextFor(ui.item[0]).$data,\n                        position = ko.utils.arrayIndexOf(ui.item.parent().children(), ui.item[0]);\n\n                    if (ko.contextFor(ui.item[0]).$index() != position) { //eslint-disable-line eqeqeq\n                        if (position >= 0) {\n                            list.remove(item);\n                            list.splice(position, 0, item);\n                        }\n                        ui.item.remove();\n                    }\n                }\n            });\n        }\n    };\n\n    return Collapsible.extend({\n        defaults: {\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            createOptionsUrl: null,\n            attributes: [],\n            stepInitialized: false\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.createAttribute = _.wrap(this.createAttribute, function () {\n                var args = _.toArray(arguments),\n                    createAttribute = args.shift();\n\n                return this.doInitSavedOptions(createAttribute.apply(this, args));\n            });\n            this.createAttribute = _.memoize(this.createAttribute.bind(this), _.property('id'));\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(['attributes']);\n\n            return this;\n        },\n\n        /**\n         * Create option.\n         */\n        createOption: function () {\n            // this - current attribute\n            this.options.push({\n                value: 0,\n                label: '',\n                id: utils.uniqueid(),\n                'attribute_id': this.id,\n                'is_new': true\n            });\n        },\n\n        /**\n         * @param {Object} option\n         */\n        saveOption: function (option) {\n            if (this.isValidOption(option)) {\n                this.options.remove(option);\n                this.options.push(option);\n                this.chosenOptions.push(option.id);\n            }\n        },\n\n        /**\n         * @param {Object} newOption\n         * @return boolean\n         */\n        isValidOption: function (newOption) {\n            var duplicatedOptions = [],\n                errorOption,\n                allOptions = [];\n\n            if (_.isEmpty(newOption.label)) {\n                return false;\n            }\n\n            _.each(this.options(), function (option) {\n                if (!_.isUndefined(allOptions[option.label]) && newOption.label === option.label) {\n                    duplicatedOptions.push(option);\n                }\n\n                allOptions[option.label] = option.label;\n            });\n\n            if (duplicatedOptions.length) {\n                _.each(duplicatedOptions, function (duplicatedOption) {\n                    errorOption = $('[data-role=\"' + duplicatedOption.id + '\"]');\n                    errorOption.addClass('_error');\n                });\n\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * @param {Object} option\n         */\n        removeOption: function (option) {\n            this.options.remove(option);\n        },\n\n        /**\n         * @param {String} attribute\n         */\n        removeAttribute: function (attribute) {\n            this.attributes.remove(attribute);\n            this.wizard.setNotificationMessage(\n                $.mage.__('An attribute has been removed. This attribute will no longer appear in your configurations.')\n            );\n        },\n\n        /**\n         * @param {Object} attribute\n         * @param {*} index\n         * @return {Object}\n         */\n        createAttribute: function (attribute, index) {\n            attribute.chosenOptions = ko.observableArray([]);\n            attribute.options = ko.observableArray(_.map(attribute.options, function (option) {\n                option.id = utils.uniqueid();\n\n                return option;\n            }));\n            attribute.opened = ko.observable(this.initialOpened(index));\n            attribute.collapsible = ko.observable(true);\n            attribute.isValidOption = this.isValidOption;\n\n            return attribute;\n        },\n\n        /**\n         * First 3 attribute panels must be open.\n         *\n         * @param {Number} index\n         * @return {Boolean}\n         */\n        initialOpened: function (index) {\n            return index < 3;\n        },\n\n        /**\n         * Save attribute.\n         */\n        saveAttribute: function () {\n            var errorMessage = $.mage.__('Select options for all attributes or remove unused attributes.');\n\n            if (!this.attributes().length) {\n                throw new Error(errorMessage);\n            }\n\n            _.each(this.attributes(), function (attribute) {\n                attribute.chosen = [];\n\n                if (!attribute.chosenOptions.getLength()) {\n                    throw new Error(errorMessage);\n                }\n                _.each(attribute.chosenOptions(), function (id) {\n                    attribute.chosen.push(attribute.options.findWhere({\n                        id: id\n                    }));\n                });\n            });\n        },\n\n        /**\n         * @param {Object} attribute\n         */\n        selectAllAttributes: function (attribute) {\n            this.chosenOptions(_.pluck(attribute.options(), 'id'));\n        },\n\n        /**\n         * @param {Object} attribute\n         */\n        deSelectAllAttributes: function (attribute) {\n            attribute.chosenOptions.removeAll();\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        saveOptions: function () {\n            var newOptions = [];\n\n            _.each(this.attributes(), function (attribute) {\n                _.each(attribute.options(), function (element) {\n                    var option = attribute.options.findWhere({\n                        id: element.id\n                    });\n\n                    if (option['is_new'] === true) {\n                        if (!attribute.isValidOption(option)) {\n                            throw new Error(\n                                $.mage.__('The value of attribute \"\"%1\"\" must be unique')\n                                    .replace('\"%1\"', attribute.label)\n                            );\n                        }\n\n                        newOptions.push(option);\n                    }\n                });\n            });\n\n            if (!newOptions.length) {\n                return false;\n            }\n\n            $.ajax({\n                type: 'POST',\n                url: this.createOptionsUrl,\n                data: {\n                    options: newOptions\n                },\n                showLoader: true\n            }).done(function (savedOptions) {\n                if (savedOptions.error) {\n                    this.notificationMessage.error = savedOptions.error;\n                    this.notificationMessage.text = savedOptions.message;\n\n                    return;\n                }\n\n                _.each(this.attributes(), function (attribute) {\n                    _.each(savedOptions, function (newOptionId, oldOptionId) {\n                        var option = attribute.options.findWhere({\n                            id: oldOptionId\n                        });\n\n                        if (option) {\n                            attribute.options.remove(option);\n                            option['is_new'] = false;\n                            option.value = newOptionId;\n                            attribute.options.push(option);\n                        }\n                    });\n                });\n\n            }.bind(this));\n        },\n\n        /**\n         * @param {*} attributeIds\n         */\n        requestAttributes: function (attributeIds) {\n            $.ajax({\n                type: 'GET',\n                url: this.optionsUrl,\n                data: {\n                    attributes: attributeIds\n                },\n                showLoader: true\n            }).done(function (attributes) {\n                attributes = _.sortBy(attributes, function (attribute) {\n                    return this.wizard.data.attributesIds.indexOf(attribute.id);\n                }.bind(this));\n                this.attributes(_.map(attributes, this.createAttribute));\n            }.bind(this));\n        },\n\n        /**\n         * @param {*} attribute\n         * @return {*}\n         */\n        doInitSavedOptions: function (attribute) {\n            var selectedOptions, selectedOptionsIds, selectedAttribute = _.findWhere(this.initData.attributes, {\n                id: attribute.id\n            });\n\n            if (selectedAttribute) {\n                selectedOptions = _.pluck(selectedAttribute.chosen, 'value');\n                selectedOptionsIds = _.pluck(_.filter(attribute.options(), function (option) {\n                    return _.contains(selectedOptions, option.value);\n                }), 'id');\n                attribute.chosenOptions(selectedOptionsIds);\n                this.initData.attributes = _.without(this.initData.attributes, selectedAttribute);\n            }\n\n            return attribute;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.requestAttributes(wizard.data.attributesIds());\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            this.saveOptions();\n            this.saveAttribute(wizard);\n\n            wizard.data.attributes = this.attributes;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        back: function (wizard) {\n            wizard.data.attributesIds(this.attributes().pluck('id'));\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/container-configurable-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            listens: {\n                '${ $.provider }:data.is_downloadable': 'handleProductType'\n            },\n            links: {\n                isDownloadable: '${ $.provider }:data.is_downloadable'\n            },\n            modules: {\n                createConfigurableButton: '${$.createConfigurableButton}'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super();\n            this.handleProductType(this.isDownloadable);\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['content']);\n\n            return this;\n        },\n\n        /**\n         * Change content for container and visibility for button\n         *\n         * @param {String} isDownloadable\n         */\n        handleProductType: function (isDownloadable) {\n            if (isDownloadable === '1') {\n                this.content(this.content2);\n\n                if (this.createConfigurableButton()) {\n                    this.createConfigurableButton().visible(false);\n                }\n            } else {\n                this.content(this.content1);\n\n                if (this.createConfigurableButton()) {\n                    this.createConfigurableButton().visible(true);\n                }\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/dynamic-rows-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows',\n    'jquery'\n], function (_, registry, dynamicRows, $) {\n    'use strict';\n\n    return dynamicRows.extend({\n        defaults: {\n            actionsListOpened: false,\n            canEditField: 'canEdit',\n            newProductField: 'newProduct',\n            dataScopeAssociatedProduct: 'data.associated_product_ids',\n            dataProviderFromGrid: '',\n            dataProviderChangeFromGrid: '',\n            insertDataFromGrid: [],\n            changeDataFromGrid: [],\n            dataProviderFromWizard: '',\n            insertDataFromWizard: [],\n            map: null,\n            isEmpty: true,\n            isShowAddProductButton: false,\n            cacheGridData: [],\n            unionInsertData: [],\n            deleteProperty: false,\n            dataLength: 0,\n            identificationProperty: 'id',\n            'attribute_set_id': '',\n            attributesTmp: [],\n            changedFlag: 'was_changed',\n            listens: {\n                'insertDataFromGrid': 'processingInsertDataFromGrid',\n                'insertDataFromWizard': 'processingInsertDataFromWizard',\n                'unionInsertData': 'processingUnionInsertData',\n                'changeDataFromGrid': 'processingChangeDataFromGrid',\n                'isEmpty': 'changeVisibility'\n            },\n            imports: {\n                'attribute_set_id': '${$.provider}:data.product.attribute_set_id'\n            },\n            'exports': {\n                'attribute_set_id': '${$.provider}:data.new-variations-attribute-set-id'\n            },\n            modules: {\n                modalWithGrid: '${ $.modalWithGrid }',\n                gridWithProducts: '${ $.gridWithProducts}'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super()\n                .changeVisibility(this.isEmpty());\n\n            return this;\n        },\n\n        /**\n         * Change visibility\n         *\n         * When isEmpty = true, then visbible = false\n         *\n         * @param {Boolean} isEmpty\n         */\n        changeVisibility: function (isEmpty) {\n            this.visible(!isEmpty);\n        },\n\n        /**\n         * Open modal with grid.\n         *\n         * @param {String} rowIndex\n         */\n        openModalWithGrid: function (rowIndex) {\n            var productSource = this.source.get(this.dataScope + '.' + this.index + '.' + rowIndex),\n                product = {\n                    'id': productSource.id,\n                    'attributes': productSource['configurable_attribute']\n                };\n\n            this.modalWithGrid().openModal();\n            this.gridWithProducts().showGridChangeProduct(rowIndex, product);\n        },\n\n        /**\n         * Initialize children\n         *\n         * @returns {Object} Chainable.\n         */\n        initChildren: function () {\n            var tmpArray = [];\n\n            this.recordData.each(function (recordData) {\n                tmpArray.push(recordData);\n            }, this);\n\n            this.unionInsertData(tmpArray);\n\n            return this;\n        },\n\n        /**\n         * Delete record\n         *\n         * @param {Number} index - row index\n         */\n        deleteRecord: function (index) {\n            var tmpArray,\n                lastRecord;\n\n            this.reRender = false;\n            tmpArray = this.getUnionInsertData();\n            tmpArray.splice(index, 1);\n\n            if (!tmpArray.length) {\n                this.attributesTmp = this.source.get('data.attributes');\n                this.source.set('data.attributes', []);\n                this.cacheGridData = [];\n            }\n\n            if (parseInt(this.currentPage(), 10) === this.pages()) {\n                lastRecord =\n                    _.findWhere(this.elems(), {\n                        index: this.startIndex + this.getChildItems().length - 1\n                    }) ||\n                    _.findWhere(this.elems(), {\n                        index: (this.startIndex + this.getChildItems().length - 1).toString()\n                    });\n\n                lastRecord.destroy();\n            }\n\n            this.unionInsertData(tmpArray);\n\n            if (this.pages() < parseInt(this.currentPage(), 10)) {\n                this.currentPage(this.pages());\n            }\n\n            this.reRender = true;\n            this.showSpinner(false);\n        },\n\n        /**\n         * Generate associated products\n         */\n        generateAssociatedProducts: function () {\n            var productsIds = [];\n\n            this.getUnionInsertData().forEach(function (data) {\n                if (data.id !== null) {\n                    productsIds.push(data.id);\n                }\n            });\n\n            this.source.set(this.dataScopeAssociatedProduct, productsIds);\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'insertDataFromGrid', 'unionInsertData', 'isEmpty', 'isShowAddProductButton', 'actionsListOpened'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Get union insert data from source\n         *\n         * @returns {Array}\n         */\n        getUnionInsertData: function () {\n            var source = this.source.get(this.dataScope + '.' + this.index),\n                result = [];\n\n            _.each(source, function (data) {\n                result.push(data);\n            });\n\n            return result;\n        },\n\n        /**\n         * Process union insert data.\n         *\n         * @param {Array} data\n         */\n        processingUnionInsertData: function (data) {\n            var dataCount,\n                elemsCount,\n                tmpData,\n                path,\n                attributeCodes = this.source.get('data.attribute_codes');\n\n            this.isEmpty(data.length === 0);\n            this.isShowAddProductButton(\n                (!attributeCodes || data.length > 0 ? data.length : attributeCodes.length) > 0\n            );\n\n            tmpData = data.slice(this.pageSize * (this.currentPage() - 1),\n                                 this.pageSize * (this.currentPage() - 1) + this.pageSize);\n\n            this.source.set(this.dataScope + '.' + this.index, []);\n\n            _.each(tmpData, function (row, index) {\n                path = this.dataScope + '.' + this.index + '.' + (this.startIndex + index);\n                row.attributes = $('<i></i>').text(row.attributes).html();\n                row.sku = $('<i></i>').text(row.sku).html();\n                this.source.set(path, row);\n            }, this);\n\n            this.source.set(this.dataScope + '.' + this.index, data);\n            this.parsePagesData(data);\n\n            // Render\n            dataCount = data.length;\n            elemsCount = this.elems().length;\n\n            if (dataCount > elemsCount) {\n                this.getChildItems().each(function (elemData, index) {\n                    this.addChild(elemData, this.startIndex + index);\n                }, this);\n            } else {\n                for (elemsCount; elemsCount > dataCount; elemsCount--) {\n                    this.elems()[elemsCount - 1].destroy();\n                }\n            }\n\n            this.generateAssociatedProducts();\n        },\n\n        /**\n         * Parsed data\n         *\n         * @param {Array} data - array with data\n         * about selected records\n         */\n        processingInsertDataFromGrid: function (data) {\n            var changes,\n                tmpArray;\n\n            if (!data.length) {\n                return;\n            }\n\n            tmpArray = this.getUnionInsertData();\n\n            changes = this._checkGridData(data);\n            this.cacheGridData = data;\n\n            changes.each(function (changedObject) {\n                var mappedData = this.mappingValue(changedObject);\n\n                mappedData[this.canEditField] = 0;\n                mappedData[this.newProductField] = 0;\n                mappedData.variationKey = this._getVariationKey(changedObject);\n                mappedData['configurable_attribute'] = this._getConfigurableAttribute(changedObject);\n                tmpArray.push(mappedData);\n            }, this);\n\n            // Attributes cannot be changed before regeneration thought wizard\n            if (!this.source.get('data.attributes').length) {\n                this.source.set('data.attributes', this.attributesTmp);\n            }\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         * Process changes from grid.\n         *\n         * @param {Object} data\n         */\n        processingChangeDataFromGrid: function (data) {\n            var tmpArray = this.getUnionInsertData(),\n                mappedData = this.mappingValue(data.product);\n\n            mappedData[this.canEditField] = 0;\n            mappedData[this.newProductField] = 0;\n            mappedData.variationKey = this._getVariationKey(data.product);\n            mappedData['configurable_attribute'] = this._getConfigurableAttribute(data.product);\n            tmpArray[data.rowIndex] = mappedData;\n\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         * Get variation key.\n         *\n         * @param {Object} data\n         * @returns {String}\n         * @private\n         */\n        _getVariationKey: function (data) {\n            var attrCodes = this.source.get('data.attribute_codes'),\n                key = [];\n\n            attrCodes.each(function (code) {\n                key.push(data[code]);\n            });\n\n            return key.sort().join('-');\n        },\n\n        /**\n         * Get configurable attribute.\n         *\n         * @param {Object} data\n         * @returns {String}\n         * @private\n         */\n        _getConfigurableAttribute: function (data) {\n            var attrCodes = this.source.get('data.attribute_codes'),\n                confAttrs = {};\n\n            attrCodes.each(function (code) {\n                confAttrs[code] = data[code];\n            });\n\n            return JSON.stringify(confAttrs);\n        },\n\n        /**\n         * Process data insertion from wizard\n         *\n         * @param {Object} data\n         */\n        processingInsertDataFromWizard: function (data) {\n            var tmpArray = this.getUnionInsertData(),\n                productIdsToDelete = this.source.get(this.dataScopeAssociatedProduct),\n                index,\n                product = {};\n\n            tmpArray = this.unsetArrayItem(\n                tmpArray,\n                {\n                    id: null\n                }\n            );\n\n            _.each(data, function (row) {\n                if (row.productId) {\n                    index = _.indexOf(productIdsToDelete, row.productId);\n\n                    if (index > -1) {\n                        productIdsToDelete.splice(index, 1);\n                        tmpArray = this.unsetArrayItem(\n                            tmpArray,\n                            {\n                                id: row.productId\n                            }\n                        );\n                    }\n                }\n                product = this.getProductData(row);\n\n                product[this.changedFlag] = true;\n                product[this.canEditField] = row.editable;\n                product[this.newProductField] = row.newProduct;\n                tmpArray.push(product);\n            }, this);\n\n            _.each(productIdsToDelete, function (id) {\n                tmpArray = this.unsetArrayItem(\n                    tmpArray,\n                    {\n                        id: id\n                    }\n                );\n            }, this);\n\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         *\n         * @param {Object} row\n         * @returns {Object}\n         */\n        getProductData: function (row) {\n            var product,\n                attributesText = '';\n\n            _.each(row.options, function (attribute) {\n                if (attributesText) {\n                    attributesText += ', ';\n                }\n                attributesText += attribute['attribute_label'] + ': ' + attribute.label;\n            }, this);\n\n            product = {\n                'id': row.productId,\n                'product_link': row.productUrl,\n                'name': $('<i></i>').text(row.name).html(),\n                'sku': $('<i></i>').text(row.sku).html(),\n                'status': row.status,\n                'price': row.price,\n                'price_currency': row.priceCurrency,\n                'price_string': row.priceCurrency + row.price,\n                'weight': row.weight,\n                'qty': row.quantity,\n                'variationKey': row.variationKey,\n                'configurable_attribute': row.attribute,\n                'thumbnail_image': row.images.preview,\n                'media_gallery': row['media_gallery'],\n                'swatch_image': row['swatch_image'],\n                'small_image': row['small_image'],\n                image: row.image,\n                'thumbnail': row.thumbnail,\n                'attributes': attributesText\n            };\n\n            return product;\n        },\n\n        /**\n         * Remove array items matching condition.\n         *\n         * @param {Array} data\n         * @param {Object} condition\n         * @returns {Array}\n         */\n        unsetArrayItem: function (data, condition) {\n            var objs = _.where(data, condition);\n\n            _.each(objs, function (obj) {\n                var index = _.indexOf(data, obj);\n\n                if (index > -1) {\n                    data.splice(index, 1);\n                }\n            });\n\n            return data;\n        },\n\n        /**\n         * Check changed records\n         *\n         * @param {Array} data - array with records data\n         * @returns {Array} Changed records\n         */\n        _checkGridData: function (data) {\n            var cacheLength = this.cacheGridData.length,\n                curData = data.length,\n                max = cacheLength > curData ? this.cacheGridData : data,\n                changes = [],\n                obj = {};\n\n            max.each(function (record, index) {\n                obj[this.map.id] = record[this.map.id];\n\n                if (!_.where(this.cacheGridData, obj).length) {\n                    changes.push(data[index]);\n                }\n            }, this);\n\n            return changes;\n        },\n\n        /**\n         * Mapped value\n         */\n        mappingValue: function (data) {\n            var result = {};\n\n            _.each(this.map, function (prop, index) {\n                result[index] = data[prop];\n            });\n\n            return result;\n        },\n\n        /**\n         * Toggle actions list.\n         *\n         * @param {Number} rowIndex\n         * @returns {Object} Chainable.\n         */\n        toggleActionsList: function (rowIndex) {\n            var state = false;\n\n            if (rowIndex !== this.actionsListOpened()) {\n                state = rowIndex;\n            }\n            this.actionsListOpened(state);\n\n            return this;\n        },\n\n        /**\n         * Close action list.\n         *\n         * @param {Number} rowIndex\n         * @returns {Object} Chainable\n         */\n        closeList: function (rowIndex) {\n            if (this.actionsListOpened() === rowIndex) {\n                this.actionsListOpened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggle product status.\n         *\n         * @param {Number} rowIndex\n         */\n        toggleStatusProduct: function (rowIndex) {\n            var tmpArray = this.getUnionInsertData(),\n                status = parseInt(tmpArray[rowIndex].status, 10);\n\n            if (status === 1) {\n                tmpArray[rowIndex].status = 2;\n            } else {\n                tmpArray[rowIndex].status = 1;\n            }\n\n            tmpArray[rowIndex][this.changedFlag] = true;\n            this.unionInsertData(tmpArray);\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/file-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/file-uploader',\n    'underscore'\n], function (Element, _) {\n    'use strict';\n\n    return Element.extend({\n        processedFile: {},\n        actionsListOpened: false,\n        thumbnailUrl: '',\n        thumbnail: null,\n        smallImage: null,\n        defaults: {\n            fileInputName: ''\n        },\n\n        /**\n         * Initialize observables.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(['processedFile', 'actionsListOpened', 'thumbnailUrl', 'thumbnail', 'smallImage']);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        setInitialValue: function () {\n            var value = this.getInitialValue();\n\n            if (!_.isString(value)) {\n                this._super();\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds provided file to the files list.\n         *\n         * @param {Object} file\n         * @returns {Object} Chainable.\n         */\n        addFile: function (file) {\n            this.processedFile(this.processFile(file));\n\n            this.value(this.processedFile().file);\n\n            return this;\n        },\n\n        /**\n         * Toggle actions list.\n         *\n         * @returns {Object} Chainable.\n         */\n        toggleActionsList: function () {\n            if (this.actionsListOpened()) {\n                this.actionsListOpened(false);\n            } else {\n                this.actionsListOpened(true);\n            }\n\n            return this;\n        },\n\n        /**\n         * Close action list.\n         *\n         * @returns {Object} Chainable\n         */\n        closeList: function () {\n            if (this.actionsListOpened()) {\n                this.actionsListOpened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Delete Image\n         *\n         * @returns {Object} Chainable\n         */\n        deleteImage: function () {\n            this.processedFile({});\n            this.value(null);\n            this.thumbnail(null);\n            this.thumbnailUrl(null);\n            this.smallImage(null);\n\n            return this;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/custom-options-warning.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/html'\n], function (Html) {\n    'use strict';\n\n    return Html.extend({\n        defaults: {\n            isConfigurable: false\n        },\n\n        /**\n         * Updates component visibility state.\n         *\n         * @param {Boolean} variationsEmpty\n         * @returns {Boolean}\n         */\n        updateVisibility: function (variationsEmpty) {\n            var isVisible = this.isConfigurable || !variationsEmpty;\n\n            this.visible(isVisible);\n\n            return isVisible;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/associated-product-insert-listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/components/insert-listing'\n], function (_, insertListing) {\n    'use strict';\n\n    return insertListing.extend({\n        defaults: {\n            gridInitialized: false,\n            paramsUpdated: false,\n            showMassActionColumn: true,\n            currentProductId: 0,\n            dataScopeAssociatedProduct: 'data.associated_product_ids',\n            typeGrid: '',\n            product: {},\n            rowIndexForChange: undefined,\n            changeProductData: [],\n            modules: {\n                productsProvider: '${ $.productsProvider }',\n                productsColumns: '${ $.productsColumns }',\n                productsMassAction: '${ $.productsMassAction }',\n                modalWithGrid: '${ $.modalWithGrid }',\n                productsFilters: '${ $.productsFilters }'\n            },\n            exports: {\n                externalProviderParams: '${ $.externalProvider }:params'\n            },\n            links: {\n                changeProductData: '${ $.provider }:${ $.changeProductProvider }'\n            },\n            listens: {\n                '${ $.externalProvider }:params': '_setFilters _setVisibilityMassActionColumn',\n                '${ $.productsProvider }:data': '_handleManualGridOpening',\n                '${ $.productsMassAction }:selected': '_handleManualGridSelect'\n            }\n        },\n\n        /**\n         * Initialize observables.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(\n                'changeProductData'\n            );\n\n            return this;\n        },\n\n        /**\n         * Get ids of used products.\n         *\n         * @returns {Array}\n         */\n        getUsedProductIds: function () {\n            var usedProductsIds = this.source.get(this.dataScopeAssociatedProduct);\n\n            return usedProductsIds.slice();\n        },\n\n        /**\n         * Request for render content.\n         *\n         * @returns {Object}\n         */\n        doRender: function (showMassActionColumn, typeGrid) {\n            this.typeGrid = typeGrid;\n            this.showMassActionColumn = showMassActionColumn;\n\n            if (this.gridInitialized) {\n                this.paramsUpdated = false;\n                this.productsFilters().clear();\n                this._setFilters(this.externalProviderParams);\n                this._setVisibilityMassActionColumn();\n            }\n\n            return this.render();\n        },\n\n        /**\n         * Show grid with assigned product.\n         *\n         * @returns {Object}\n         */\n        showGridAssignProduct: function () {\n            this.product = {};\n            this.rowIndexForChange = undefined;\n\n            return this.doRender(true, 'assignProduct');\n        },\n\n        /**\n         * Show grid with changed product.\n         *\n         * @param {String} rowIndex\n         * @param {String} product\n         */\n        showGridChangeProduct: function (rowIndex, product) {\n            this.rowIndexForChange = rowIndex;\n            this.product = product;\n            this.doRender(false, 'changeProduct');\n        },\n\n        /**\n         * Select product.\n         *\n         * @param {String} rowIndex\n         */\n        selectProduct: function (rowIndex) {\n            this.changeProductData({\n                rowIndex: this.rowIndexForChange,\n                product: this.productsProvider().data.items[rowIndex]\n            });\n            this.modalWithGrid().closeModal();\n        },\n\n        /**\n         * Set visibility state for mass action column\n         *\n         * @private\n         */\n        _setVisibilityMassActionColumn: function () {\n            this.productsMassAction(function (massActionComponent) {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = this.showMassActionColumn;\n                }, this);\n                massActionComponent.visible = this.showMassActionColumn;\n            }.bind(this));\n        },\n\n        /**\n         * Set filters.\n         *\n         * @param {Object} params\n         * @private\n         */\n        _setFilters: function (params) {\n            var filterModifier = {},\n                attrCodes,\n                usedProductIds,\n                attributes;\n\n            params = _.omit(params);\n\n            if (!this.paramsUpdated) {\n                this.gridInitialized = true;\n                this.paramsUpdated = true;\n\n                attrCodes = this._getAttributesCodes();\n                usedProductIds = this.getUsedProductIds();\n\n                if (this.currentProductId) {\n                    usedProductIds.push(this.currentProductId);\n                }\n\n                filterModifier['entity_id'] = {\n                    'condition_type': 'nin', value: usedProductIds\n                };\n                attrCodes.each(function (code) {\n                    filterModifier[code] = {\n                        'condition_type': 'notnull'\n                    };\n                });\n\n                if (this.typeGrid === 'changeProduct') {\n                    attributes = JSON.parse(this.product.attributes);\n\n                    filterModifier = _.extend(filterModifier, _.mapObject(attributes, function (value) {\n                        return {\n                            'condition_type': 'eq',\n                            'value': value\n                        };\n                    }));\n\n                    params.filters = attributes;\n                } else {\n                    params.filters = {};\n                }\n\n                params['attributes_codes'] = attrCodes;\n\n                this.set('externalProviderParams', params);\n                this.set('externalFiltersModifier', filterModifier);\n            }\n        },\n\n        /**\n         * Get attribute codes.\n         *\n         * @returns {Array}\n         * @private\n         */\n        _getAttributesCodes: function () {\n            var attrCodes = this.source.get('data.attribute_codes');\n\n            return attrCodes ? attrCodes : [];\n        },\n\n        /**\n         * Get product variations.\n         *\n         * @returns {Array}\n         * @private\n         */\n        _getProductVariations: function () {\n            var matrix = this.source.get('data.configurable-matrix');\n\n            return matrix ? matrix : [];\n        },\n\n        /**\n         * Handle manual grid after opening\n         * @private\n         */\n        _handleManualGridOpening: function (data) {\n            if (data.items.length && this.typeGrid === 'assignProduct') {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = true;\n                });\n\n                this._disableRows(data.items);\n            }\n        },\n\n        /**\n         * Handle manual selection.\n         *\n         * @param {Array} selected\n         * @private\n         */\n        _handleManualGridSelect: function (selected) {\n            var selectedRows,\n                selectedVariationKeys;\n\n            if (this.typeGrid === 'assignProduct') {\n                selectedRows = _.filter(this.productsProvider().data.items, function (row) {\n                    return selected.indexOf(row['entity_id']) !== -1;\n                });\n                selectedVariationKeys = _.values(this._getVariationKeyMap(selectedRows));\n                this._disableRows(this.productsProvider().data.items, selectedVariationKeys, selected);\n            }\n        },\n\n        /**\n         * Disable rows in grid for products with the same variation key\n         *\n         * @param {Array} items\n         * @param {Array} selectedVariationKeys\n         * @param {Array} selected\n         * @private\n         */\n        _disableRows: function (items, selectedVariationKeys, selected) {\n            selectedVariationKeys = selectedVariationKeys === undefined ? [] : selectedVariationKeys;\n            selected = selected === undefined ? [] : selected;\n            this.productsMassAction(function (massaction) {\n                var configurableVariationKeys = _.union(\n                    selectedVariationKeys,\n                    _.pluck(this._getProductVariations(), 'variationKey')\n                    ),\n                    variationKeyMap = this._getVariationKeyMap(items),\n                    rowsForDisable = _.keys(_.pick(\n                        variationKeyMap,\n                        function (variationKey) {\n                            return configurableVariationKeys.indexOf(variationKey) !== -1;\n                        }\n                    ));\n\n                massaction.disabled(_.difference(rowsForDisable, selected));\n            }.bind(this));\n        },\n\n        /**\n         * Get variation key map used in manual grid.\n         *\n         * @param {Array} items\n         * @returns {Array} [{entity_id: variation-key}, ...]\n         * @private\n         */\n        _getVariationKeyMap: function (items) {\n            var variationKeyMap = {};\n\n            _.each(items, function (row) {\n                variationKeyMap[row['entity_id']] = _.values(\n                    _.pick(row, this._getAttributesCodes())\n                ).sort().join('-');\n\n            }, this);\n\n            return variationKeyMap;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/price-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, registry, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            imports: {\n                isConfigurable: '!ns = ${ $.ns }, index = configurable-matrix:isEmpty'\n            },\n            modules: {\n                createConfigurableButton: '${$.createConfigurableButton}'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            // resolve initial disable state\n            this.handlePriceValue(this.isConfigurable);\n            // add listener to track \"configurable\" type\n            this.setListeners({\n                isConfigurable: 'handlePriceValue'\n            });\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['content']);\n\n            return this;\n        },\n\n        /**\n         * Disable and clear price if product type changed to configurable\n         *\n         * @param {String} isConfigurable\n         */\n        handlePriceValue: function (isConfigurable) {\n            this.disabled(!!this.isUseDefault() || isConfigurable);\n\n            if (isConfigurable) {\n                this.clear();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/custom-options-price-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Catalog/js/components/custom-options-price-type'\n], function (_, PriceType) {\n    'use strict';\n\n    return PriceType.extend({\n        defaults: {\n            isConfigurable: false,\n            isFiltered: null,\n            defaultOptions: null,\n            filteredOptions: null,\n            bannedOptions: []\n        },\n\n        /**\n         * Updates options.\n         *\n         * @param {Boolean} variationsEmpty\n         * @returns {Boolean}\n         */\n        updateOptions: function (variationsEmpty) {\n            var isFiltered = this.isConfigurable || !variationsEmpty,\n                value;\n\n            if (this.isFiltered !== isFiltered) {\n                value = this.value();\n\n                this.options(isFiltered ? this.getFilteredOptions() : this.getDefaultOptions());\n                this.value(value);\n            }\n\n            return isFiltered;\n        },\n\n        /**\n         * Get default list of options.\n         *\n         * @returns {Array}\n         */\n        getDefaultOptions: function () {\n            if (this.defaultOptions === null) {\n                this.defaultOptions = this.options();\n            }\n\n            return this.defaultOptions;\n        },\n\n        /**\n         * Get filtered list of options.\n         *\n         * @returns {Array}\n         */\n        getFilteredOptions: function () {\n            var defaultOptions;\n\n            if (this.filteredOptions === null) {\n                defaultOptions = this.getDefaultOptions();\n                this.filteredOptions = [];\n\n                _.each(defaultOptions, function (option) {\n                    if (this.bannedOptions.indexOf(option.value) === -1) {\n                        this.filteredOptions.push(option);\n                    }\n                }, this);\n            }\n\n            return this.filteredOptions;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/modal-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/modal/modal-component',\n    'uiRegistry',\n    'underscore'\n], function (Modal, registry, _) {\n    'use strict';\n\n    return Modal.extend({\n        defaults: {\n            stepWizard: '',\n            modules: {\n                form: '${ $.formName }'\n            }\n        },\n\n        /**\n         * Open modal\n         */\n        openModal: function () {\n            var stepWizard = {};\n\n            this.form().validate();\n\n            if (this.form().source.get('params.invalid') === false) {\n                stepWizard = registry.get('index = ' + this.stepWizard);\n\n                if (!_.isUndefined(stepWizard)) {\n                    stepWizard.open();\n                }\n\n                this._super();\n            } else {\n                this.form().focusInvalid();\n            }\n        }\n    });\n});\n","Magento_InventorySalesAdminUi/js/stock/grid/cell/sales-channels.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'underscore'\n], function (Column, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventorySalesAdminUi/stock/grid/cell/sales-channel-cell.html'\n        },\n\n        /**\n         * Get sales channels grouped by type\n         *\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSalesChannelsGroupedByType: function (record) {\n            var result = [];\n\n            _.each(record[this.index], function (channels, type) {\n                result.push({\n                    type: type,\n                    channels: channels\n                });\n            });\n\n            return result;\n        }\n    });\n});\n","Magento_InventorySalesAdminUi/js/product/grid/cell/salable-quantity.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventorySalesAdminUi/product/grid/cell/salable-quantity.html'\n        },\n\n        /**\n         * Get salable quantity data (stock name and salable qty)\n         *\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSalableQuantityData: function (record) {\n            return record[this.index] ? record[this.index] : [];\n        }\n    });\n});\n","Magento_Ui/js/block-loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Ui/js/lib/knockout/template/loader',\n    'mage/template'\n], function (ko, $, templateLoader, template) {\n    'use strict';\n\n    var blockLoaderTemplatePath = 'ui/block-loader',\n        blockContentLoadingClass = '_block-content-loading',\n        blockLoader,\n        blockLoaderClass,\n        loaderImageHref;\n\n    templateLoader.loadTemplate(blockLoaderTemplatePath).done(function (blockLoaderTemplate) {\n        blockLoader = template($.trim(blockLoaderTemplate), {\n            loaderImageHref: loaderImageHref\n        });\n        blockLoader = $(blockLoader);\n        blockLoaderClass = '.' + blockLoader.attr('class');\n    });\n\n    /**\n     * Helper function to check if blockContentLoading class should be applied.\n     * @param {Object} element\n     * @returns {Boolean}\n     */\n    function isLoadingClassRequired(element) {\n        var position = element.css('position');\n\n        if (position === 'absolute' || position === 'fixed') {\n            return false;\n        }\n\n        return true;\n    }\n\n    /**\n     * Add loader to block.\n     * @param {Object} element\n     */\n    function addBlockLoader(element) {\n        element.find(':focus').blur();\n        element.find('input:disabled, select:disabled').addClass('_disabled');\n        element.find('input, select').prop('disabled', true);\n\n        if (isLoadingClassRequired(element)) {\n            element.addClass(blockContentLoadingClass);\n        }\n        element.append(blockLoader.clone());\n    }\n\n    /**\n     * Remove loader from block.\n     * @param {Object} element\n     */\n    function removeBlockLoader(element) {\n        if (!element.has(blockLoaderClass).length) {\n            return;\n        }\n        element.find(blockLoaderClass).remove();\n        element.find('input:not(\"._disabled\"), select:not(\"._disabled\")').prop('disabled', false);\n        element.find('input:disabled, select:disabled').removeClass('_disabled');\n        element.removeClass(blockContentLoadingClass);\n    }\n\n    return function (loaderHref) {\n        loaderImageHref = loaderHref;\n        ko.bindingHandlers.blockLoader = {\n            /**\n             * Process loader for block\n             * @param {String} element\n             * @param {Boolean} displayBlockLoader\n             */\n            update: function (element, displayBlockLoader) {\n                element = $(element);\n\n                if (ko.unwrap(displayBlockLoader())) {\n                    addBlockLoader(element);\n                } else {\n                    removeBlockLoader(element);\n                }\n            }\n        };\n    };\n});\n","Magento_Ui/js/dynamic-rows/dynamic-rows-grid.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './dynamic-rows'\n], function (_, dynamicRows) {\n    'use strict';\n\n    return dynamicRows.extend({\n        defaults: {\n            dataProvider: '',\n            insertData: [],\n            map: null,\n            cacheGridData: [],\n            deleteProperty: false,\n            positionProvider: 'position',\n            dataLength: 0,\n            identificationProperty: 'id',\n            identificationDRProperty: 'id',\n            listens: {\n                'insertData': 'processingInsertData',\n                'recordData': 'initElements setToInsertData'\n            },\n            mappingSettings: {\n                enabled: true,\n                distinct: true\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this.setToInsertData = _.debounce(this.setToInsertData, 200);\n\n            return this._super();\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'insertData'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Set data from recordData to insertData\n         */\n        setToInsertData: function () {\n            var insertData = [],\n                obj;\n\n            if (this.recordData().length && !this.update) {\n                _.each(this.recordData(), function (recordData) {\n                    obj = {};\n                    obj[this.map[this.identificationProperty]] = recordData[this.identificationProperty];\n                    insertData.push(obj);\n                }, this);\n\n                if (insertData.length) {\n                    this.source.set(this.dataProvider, insertData);\n                }\n            }\n        },\n\n        /**\n         * Initialize children\n         *\n         * @returns {Object} Chainable.\n         */\n        initChildren: function () {\n            this.getChildItems().forEach(function (data, index) {\n                this.processingAddChild(data, this.startIndex + index, data[this.identificationDRProperty]);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Initialize elements from grid\n         *\n         * @param {Array} data\n         *\n         * @returns {Object} Chainable.\n         */\n        initElements: function (data) {\n            var newData = this.getNewData(data);\n\n            this.parsePagesData(data);\n\n            if (newData.length) {\n                if (this.insertData().length) {\n                    this.processingAddChild(newData[0], data.length - 1, newData[0][this.identificationProperty]);\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Delete record instance\n         * update data provider dataScope\n         *\n         * @param {String|Number} index - record index\n         * @param {String|Number} recordId\n         */\n        deleteRecord: function (index, recordId) {\n            this.updateInsertData(recordId);\n            this._super();\n        },\n\n        /**\n         * Updates insertData when record is deleted\n         *\n         * @param {String|Number} recordId\n         */\n        updateInsertData: function (recordId) {\n            var data = this.getElementData(this.insertData(), recordId),\n            prop = this.map[this.identificationDRProperty];\n\n            this.insertData(_.reject(this.source.get(this.dataProvider), function (recordData) {\n                return recordData[prop].toString() === data[prop].toString();\n            }, this));\n        },\n\n        /**\n         * Find data object by index\n         *\n         * @param {Array} array - data collection\n         * @param {Number} index - element index\n         * @param {String} property - to find by property\n         *\n         * @returns {Object} data object\n         */\n        getElementData: function (array, index, property) {\n            var obj = {},\n                result;\n\n            property ? obj[property] = index : obj[this.map[this.identificationDRProperty]] = index;\n            result = _.findWhere(array, obj);\n\n            if (!result) {\n                property ?\n                    obj[property] = index.toString() :\n                    obj[this.map[this.identificationDRProperty]] = index.toString();\n            }\n\n            result = _.findWhere(array, obj);\n\n            return result;\n        },\n\n        /**\n         * Processing pages before addChild\n         *\n         * @param {Object} ctx - element context\n         * @param {Number|String} index - element index\n         * @param {Number|String} prop - additional property to element\n         */\n        processingAddChild: function (ctx, index, prop) {\n            if (this._elems.length > this.pageSize) {\n                return false;\n            }\n\n            this.showSpinner(true);\n            this.addChild(ctx, index, prop);\n        },\n\n        /**\n         * Contains old data with new\n         *\n         * @param {Array} data\n         *\n         * @returns {Array} changed data\n         */\n        getNewData: function (data) {\n            var changes = [],\n                tmpObj = {};\n\n            if (data.length !== this.relatedData.length) {\n                _.each(data, function (obj) {\n                    tmpObj[this.identificationDRProperty] = obj[this.identificationDRProperty];\n\n                    if (!_.findWhere(this.relatedData, tmpObj)) {\n                        changes.push(obj);\n                    }\n                }, this);\n            }\n\n            return changes;\n        },\n\n        /**\n         * Processing insert data\n         *\n         * @param {Object} data\n         */\n        processingInsertData: function (data) {\n            var changes,\n                obj = {};\n\n            changes = this._checkGridData(data);\n            this.cacheGridData = data;\n\n            if (changes.length) {\n                obj[this.identificationDRProperty] = changes[0][this.map[this.identificationProperty]];\n\n                if (_.findWhere(this.recordData(), obj)) {\n                    return false;\n                }\n\n                changes.forEach(function (changedObject) {\n                    this.mappingValue(changedObject);\n                }, this);\n            }\n        },\n\n        /**\n         * Mapping value from grid\n         *\n         * @param {Array} data\n         */\n        mappingValue: function (data) {\n            var obj = {},\n                tmpObj = {};\n\n            if (this.mappingSettings.enabled) {\n                _.each(this.map, function (prop, index) {\n                    obj[index] = !_.isUndefined(data[prop]) ? data[prop] : '';\n                }, this);\n            } else {\n                obj = data;\n            }\n\n            if (this.mappingSettings.distinct) {\n                tmpObj[this.identificationDRProperty] = obj[this.identificationDRProperty];\n\n                if (_.findWhere(this.recordData(), tmpObj)) {\n                    return false;\n                }\n            }\n\n            if (!obj.hasOwnProperty(this.positionProvider)) {\n                this.setMaxPosition();\n                obj[this.positionProvider] = this.maxPosition;\n            }\n\n            this.source.set(this.dataScope + '.' + this.index + '.' + this.recordData().length, obj);\n        },\n\n        /**\n         * Check changed records\n         *\n         * @param {Array} data - array with records data\n         * @returns {Array} Changed records\n         */\n        _checkGridData: function (data) {\n            var cacheLength = this.cacheGridData.length,\n                curData = data.length,\n                max = cacheLength > curData ? this.cacheGridData : data,\n                changes = [],\n                obj = {};\n\n            max.forEach(function (record, index) {\n                obj[this.map[this.identificationDRProperty]] = record[this.map[this.identificationDRProperty]];\n\n                if (!_.where(this.cacheGridData, obj).length) {\n                    changes.push(data[index]);\n                }\n            }, this);\n\n            return changes;\n        }\n    });\n});\n","Magento_Ui/js/dynamic-rows/dynamic-rows.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'mageUtils',\n    'underscore',\n    'uiLayout',\n    'uiCollection',\n    'uiRegistry',\n    'mage/translate'\n], function (ko, utils, _, layout, uiCollection, registry, $t) {\n    'use strict';\n\n    /**\n     * Checks value type and cast to boolean if needed\n     *\n     * @param {*} value\n     *\n     * @returns {Boolean|*} casted or origin value\n     */\n    function castValue(value) {\n        if (_.isUndefined(value) || value === '' || _.isNull(value)) {\n            return false;\n        }\n\n        return value;\n    }\n\n    /**\n     * Compares arrays.\n     *\n     * @param {Array} base - array as method bases its decision on first argument.\n     * @param {Array} current - second array\n     *\n     * @returns {Boolean} result - is current array equal to base array\n     */\n    function compareArrays(base, current) {\n        var index = 0,\n            length = base.length;\n\n        if (base.length !== current.length) {\n            return false;\n        }\n\n        /*eslint-disable max-depth, eqeqeq, no-use-before-define */\n        for (index; index < length; index++) {\n            if (_.isArray(base[index]) && _.isArray(current[index])) {\n                if (!compareArrays(base[index], current[index])) {\n                    return false;\n                }\n            } else if (typeof base[index] === 'object' && typeof current[index] === 'object') {\n                if (!compareObjects(base[index], current[index])) {\n                    return false;\n                }\n            } else if (castValue(base[index]) != castValue(current[index])) {\n                return false;\n            }\n        }/*eslint-enable max-depth, eqeqeq, no-use-before-define */\n\n        return true;\n    }\n\n    /**\n     * Compares objects. Compares only properties from origin object,\n     * if current object has more properties - they are not considered\n     *\n     * @param {Object} base - first object\n     * @param {Object} current - second object\n     *\n     * @returns {Boolean} result - is current object equal to base object\n     */\n    function compareObjects(base, current) {\n        var prop;\n\n        /*eslint-disable max-depth, eqeqeq*/\n        for (prop in base) {\n            if (_.isArray(base[prop]) && _.isArray(current[prop])) {\n                if (!compareArrays(base[prop], current[prop])) {\n                    return false;\n                }\n            } else if (typeof base[prop] === 'object' && typeof current[prop] === 'object') {\n                if (!compareObjects(base[prop], current[prop])) {\n                    return false;\n                }\n            } else if (castValue(base[prop]) != castValue(current[prop])) {\n                return false;\n            }\n        }/*eslint-enable max-depth, eqeqeq */\n\n        return true;\n    }\n\n    return uiCollection.extend({\n        defaults: {\n            defaultRecord: false,\n            columnsHeader: true,\n            columnsHeaderAfterRender: false,\n            columnsHeaderClasses: '',\n            labels: [],\n            recordTemplate: 'record',\n            collapsibleHeader: false,\n            additionalClasses: {},\n            visible: true,\n            disabled: false,\n            fit: false,\n            addButton: true,\n            addButtonLabel: $t('Add'),\n            recordData: [],\n            maxPosition: 0,\n            deleteProperty: 'delete',\n            identificationProperty: 'record_id',\n            deleteValue: true,\n            showSpinner: true,\n            isDifferedFromDefault: false,\n            defaultState: [],\n            defaultPagesState: {},\n            pagesChanged: {},\n            hasInitialPagesState: {},\n            changed: false,\n            fallbackResetTpl: 'ui/form/element/helper/fallback-reset-link',\n            dndConfig: {\n                name: '${ $.name }_dnd',\n                component: 'Magento_Ui/js/dynamic-rows/dnd',\n                template: 'ui/dynamic-rows/cells/dnd',\n                recordsProvider: '${ $.name }',\n                enabled: true\n            },\n            templates: {\n                record: {\n                    parent: '${ $.$data.collection.name }',\n                    name: '${ $.$data.index }',\n                    dataScope: '${ $.$data.collection.index }.${ $.name }',\n                    nodeTemplate: '${ $.parent }.${ $.$data.collection.recordTemplate }'\n                }\n            },\n            links: {\n                recordData: '${ $.provider }:${ $.dataScope }.${ $.index }'\n            },\n            listens: {\n                visible: 'setVisible',\n                disabled: 'setDisabled',\n                childTemplate: 'initHeader',\n                recordTemplate: 'onUpdateRecordTemplate',\n                recordData: 'setDifferedFromDefault parsePagesData setRecordDataToCache',\n                currentPage: 'changePage',\n                elems: 'checkSpinner',\n                changed: 'updateTrigger'\n            },\n            modules: {\n                dnd: '${ $.dndConfig.name }'\n            },\n            pages: 1,\n            pageSize: 20,\n            relatedData: [],\n            currentPage: 1,\n            recordDataCache: [],\n            startIndex: 0\n        },\n\n        /**\n         * Sets record data to cache\n         */\n        setRecordDataToCache: function (data) {\n            this.recordDataCache = data;\n        },\n\n        /**\n         * Extends instance with default config, calls initialize of parent\n         * class, calls initChildren method, set observe variable.\n         * Use parent \"track\" method - wrapper observe array\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this,\n                'processingDeleteRecord',\n                'onChildrenUpdate',\n                'checkDefaultState',\n                'renderColumnsHeader',\n                'deleteHandler',\n                'setDefaultState'\n            );\n\n            this._super()\n                .initChildren()\n                .initDnd()\n                .initDefaultRecord()\n                .setInitialProperty()\n                .setColumnsHeaderListener()\n                .checkSpinner();\n\n            this.on('recordData', this.checkDefaultState);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        bubble: function (event) {\n            if (event === 'deleteRecord' || event === 'update') {\n                return false;\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Inits DND module\n         *\n         * @returns {Object} Chainable.\n         */\n        initDnd: function () {\n            if (this.dndConfig.enabled) {\n                layout([this.dndConfig]);\n            }\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            if (this.dnd()) {\n                this.dnd().destroy();\n            }\n            this._super();\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('childTemplate')\n                .observe([\n                    'pages',\n                    'currentPage',\n                    'recordData',\n                    'columnsHeader',\n                    'visible',\n                    'disabled',\n                    'labels',\n                    'showSpinner',\n                    'isDifferedFromDefault',\n                    'changed'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initElement: function (elem) {\n            this._super();\n            elem.on({\n                'deleteRecord': this.deleteHandler,\n                'update': this.onChildrenUpdate,\n                'addChild': this.setDefaultState\n            });\n\n            return this;\n        },\n\n        /**\n         * Handler for deleteRecord event\n         *\n         * @param {Number|String} index - element index\n         * @param {Number|String} id\n         */\n        deleteHandler: function (index, id) {\n            var defaultState;\n\n            this.setDefaultState();\n            defaultState = this.defaultPagesState[this.currentPage()];\n            this.processingDeleteRecord(index, id);\n            this.pagesChanged[this.currentPage()] =\n                !compareArrays(defaultState, this.arrayFilter(this.getChildItems()));\n            this.changed(_.some(this.pagesChanged));\n        },\n\n        /**\n         * Set initial property to records data\n         *\n         * @returns {Object} Chainable.\n         */\n        setInitialProperty: function () {\n            if (_.isArray(this.recordData())) {\n                this.recordData.each(function (data, index) {\n                    this.source.set(this.dataScope + '.' + this.index + '.' + index + '.initialize', true);\n                }, this);\n            }\n\n            return this;\n        },\n\n        /**\n         * Handler for update event\n         *\n         * @param {Boolean} state\n         */\n        onChildrenUpdate: function (state) {\n            var changed,\n                dataScope,\n                changedElemDataScope;\n\n            if (state && !this.hasInitialPagesState[this.currentPage()]) {\n                this.setDefaultState();\n                changed = this.getChangedElems(this.elems());\n                dataScope = this.elems()[0].dataScope.split('.');\n                dataScope.splice(dataScope.length - 1, 1);\n                changed.forEach(function (elem) {\n                    changedElemDataScope = elem.dataScope.split('.');\n                    changedElemDataScope.splice(0, dataScope.length);\n                    changedElemDataScope[0] =\n                        (parseInt(changedElemDataScope[0], 10) - this.pageSize * (this.currentPage() - 1)).toString();\n                    this.setValueByPath(\n                        this.defaultPagesState[this.currentPage()],\n                        changedElemDataScope, elem.initialValue\n                    );\n                }, this);\n            }\n\n            if (this.defaultPagesState[this.currentPage()]) {\n                this.setChangedForCurrentPage();\n            }\n        },\n\n        /**\n         * Set default dynamic-rows state or state before changing data\n         *\n         * @param {Array} data - defaultState data\n         */\n        setDefaultState: function (data) {\n            var componentData,\n                childItems;\n\n            if (!this.hasInitialPagesState[this.currentPage()]) {\n                childItems = this.getChildItems();\n                componentData = childItems.length ?\n                    utils.copy(childItems) :\n                    utils.copy(this.getChildItems(this.recordDataCache));\n                componentData.forEach(function (dataObj) {\n                    if (dataObj.hasOwnProperty('initialize')) {\n                        delete dataObj.initialize;\n                    }\n                });\n\n                this.hasInitialPagesState[this.currentPage()] = true;\n                this.defaultPagesState[this.currentPage()] = data ? data : this.arrayFilter(componentData);\n            }\n        },\n\n        /**\n         * Sets value to object by string path\n         *\n         * @param {Object} obj\n         * @param {Array|String} path\n         * @param {*} value\n         */\n        setValueByPath: function (obj, path, value) {\n            var prop;\n\n            if (_.isString(path)) {\n                path = path.split('.');\n            }\n\n            if (path.length - 1) {\n                prop = obj[path[0]];\n                path.splice(0, 1);\n                this.setValueByPath(prop, path, value);\n            } else if (path.length && obj) {\n                obj[path[0]] = value;\n            }\n        },\n\n        /**\n         * Returns elements which changed self state\n         *\n         * @param {Array} array - data array\n         * @param {Array} changed - array with changed elements\n         * @returns {Array} changed - array with changed elements\n         */\n        getChangedElems: function (array, changed) {\n            changed = changed || [];\n\n            array.forEach(function (elem) {\n                if (_.isFunction(elem.elems)) {\n                    this.getChangedElems(elem.elems(), changed);\n                } else if (_.isFunction(elem.hasChanged) && elem.hasChanged()) {\n                    changed.push(elem);\n                }\n            }, this);\n\n            return changed;\n        },\n\n        /**\n         * Checks columnsHeaderAfterRender property,\n         * and set listener on elems if needed\n         *\n         * @returns {Object} Chainable.\n         */\n        setColumnsHeaderListener: function () {\n            if (this.columnsHeaderAfterRender) {\n                this.on('recordData', this.renderColumnsHeader);\n\n                if (_.isArray(this.recordData()) && this.recordData().length) {\n                    this.renderColumnsHeader();\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks whether component's state is default or not\n         */\n        checkDefaultState: function () {\n            var isRecordDataArray = _.isArray(this.recordData()),\n                initialize,\n                hasNotDefaultRecords = isRecordDataArray ? !!this.recordData().filter(function (data) {\n                    return !data.initialize;\n                }).length : false;\n\n            if (!this.hasInitialPagesState[this.currentPage()] && isRecordDataArray && hasNotDefaultRecords) {\n                this.hasInitialPagesState[this.currentPage()] = true;\n                this.defaultPagesState[this.currentPage()] = utils.copy(this.getChildItems().filter(function (data) {\n                    initialize = data.initialize;\n                    delete data.initialize;\n\n                    return initialize;\n                }));\n\n                this.setChangedForCurrentPage();\n            } else if (this.hasInitialPagesState[this.currentPage()]) {\n                this.setChangedForCurrentPage();\n            }\n        },\n\n        /**\n         * Filters out deleted items from array\n         *\n         * @param {Array} data\n         *\n         * @returns {Array} filtered array\n         */\n        arrayFilter: function (data) {\n            var prop;\n\n            /*eslint-disable no-loop-func*/\n            data.forEach(function (elem) {\n                for (prop in elem) {\n                    if (_.isArray(elem[prop])) {\n                        elem[prop] = _.filter(elem[prop], function (elemProp) {\n                            return elemProp[this.deleteProperty] !== this.deleteValue;\n                        }, this);\n\n                        elem[prop].forEach(function (elemProp) {\n                            if (_.isArray(elemProp)) {\n                                elem[prop] = this.arrayFilter(elemProp);\n                            }\n                        }, this);\n                    }\n                }\n            }, this);\n\n            /*eslint-enable no-loop-func*/\n\n            return data;\n        },\n\n        /**\n         * Triggers update event\n         *\n         * @param {Boolean} val\n         */\n        updateTrigger: function (val) {\n            this.trigger('update', val);\n        },\n\n        /**\n         * Returns component state\n         */\n        hasChanged: function () {\n            return this.changed();\n        },\n\n        /**\n         * Render column header\n         */\n        renderColumnsHeader: function () {\n            this.recordData().length ? this.columnsHeader(true) : this.columnsHeader(false);\n        },\n\n        /**\n         * Init default record\n         *\n         * @returns Chainable.\n         */\n        initDefaultRecord: function () {\n            if (this.defaultRecord && !this.recordData().length) {\n                this.addChild();\n            }\n\n            return this;\n        },\n\n        /**\n         * Create header template\n         *\n         * @param {Object} prop - instance obj\n         *\n         * @returns {Object} Chainable.\n         */\n        createHeaderTemplate: function (prop) {\n            var visible = prop.visible !== false,\n                disabled = _.isUndefined(prop.disabled) ? this.disabled() : prop.disabled;\n\n            return {\n                visible: ko.observable(visible),\n                disabled: ko.observable(disabled)\n            };\n        },\n\n        /**\n         * Init header elements\n         */\n        initHeader: function () {\n            var labels = [],\n                data;\n\n            if (!this.labels().length) {\n                _.each(this.childTemplate.children, function (cell) {\n                    data = this.createHeaderTemplate(cell.config);\n                    cell.config.labelVisible = false;\n                    _.extend(data, {\n                        defaultLabelVisible: data.visible(),\n                        label: cell.config.label,\n                        name: cell.name,\n                        required: !!cell.config.validation,\n                        columnsHeaderClasses: cell.config.columnsHeaderClasses,\n                        sortOrder: cell.config.sortOrder\n                    });\n                    labels.push(data);\n                }, this);\n                this.labels(_.sortBy(labels, 'sortOrder'));\n            }\n        },\n\n        /**\n         * Set max element position\n         *\n         * @param {Number} position - element position\n         * @param {Object} elem - instance\n         */\n        setMaxPosition: function (position, elem) {\n            if (position || position === 0) {\n                this.checkMaxPosition(position);\n                this.sort(position, elem);\n            } else {\n                this.maxPosition += 1;\n            }\n        },\n\n        /**\n         * Sort element by position\n         *\n         * @param {Number} position - element position\n         * @param {Object} elem - instance\n         */\n        sort: function (position, elem) {\n            var that = this,\n                sorted,\n                updatedCollection;\n\n            if (this.elems().filter(function (el) {\n                    return el.position || el.position === 0;\n                }).length !== this.getChildItems().length) {\n\n                return false;\n            }\n\n            if (!elem.containers.length) {\n                registry.get(elem.name, function () {\n                    that.sort(position, elem);\n                });\n\n                return false;\n            }\n\n            sorted = this.elems().sort(function (propOne, propTwo) {\n                return ~~propOne.position - ~~propTwo.position;\n            });\n\n            updatedCollection = this.updatePosition(sorted, position, elem.name);\n            this.elems(updatedCollection);\n        },\n\n        /**\n         * Checking loader visibility\n         *\n         * @param {Array} elems\n         */\n        checkSpinner: function (elems) {\n            this.showSpinner(!(!this.recordData().length || elems && elems.length === this.getChildItems().length));\n        },\n\n        /**\n         * Filtering data and calculates the quantity of pages\n         *\n         * @param {Array} data\n         */\n        parsePagesData: function (data) {\n            var pages;\n\n            this.relatedData = this.deleteProperty ?\n                _.filter(data, function (elem) {\n                    return elem && elem[this.deleteProperty] !== this.deleteValue;\n                }, this) : data;\n\n            pages = Math.ceil(this.relatedData.length / this.pageSize) || 1;\n            this.pages(pages);\n        },\n\n        /**\n         * Reinit record data in order to remove deleted values\n         *\n         * @return void\n         */\n        reinitRecordData: function () {\n            this.recordData(\n                _.filter(this.recordData(), function (elem) {\n                    return elem && elem[this.deleteProperty] !== this.deleteValue;\n                }, this)\n            );\n        },\n\n        /**\n         * Get items to rendering on current page\n         *\n         * @returns {Array} data\n         */\n        getChildItems: function (data, page) {\n            var dataRecord = data || this.relatedData,\n                startIndex;\n\n            this.startIndex = (~~this.currentPage() - 1) * this.pageSize;\n\n            startIndex = page || this.startIndex;\n\n            return dataRecord.slice(startIndex, this.startIndex + this.pageSize);\n        },\n\n        /**\n         * Get record count with filtered delete property.\n         *\n         * @returns {Number} count\n         */\n        getRecordCount: function () {\n            return _.filter(this.recordData(), function (record) {\n                return record && record[this.deleteProperty] !== this.deleteValue;\n            }, this).length;\n        },\n\n        /**\n         * Get number of columns\n         *\n         * @returns {Number} columns\n         */\n        getColumnsCount: function () {\n            return this.labels().length + (this.dndConfig.enabled ? 1 : 0);\n        },\n\n        /**\n         * Processing pages before addChild\n         *\n         * @param {Object} ctx - element context\n         * @param {Number|String} index - element index\n         * @param {Number|String} prop - additional property to element\n         */\n        processingAddChild: function (ctx, index, prop) {\n            this.bubble('addChild', false);\n\n            if (this.relatedData.length && this.relatedData.length % this.pageSize === 0) {\n                this.pages(this.pages() + 1);\n                this.nextPage();\n            } else if (~~this.currentPage() !== this.pages()) {\n                this.currentPage(this.pages());\n            }\n\n            this.addChild(ctx, index, prop);\n        },\n\n        /**\n         * Processing pages before deleteRecord\n         *\n         * @param {Number|String} index - element index\n         * @param {Number|String} recordId\n         */\n        processingDeleteRecord: function (index, recordId) {\n            this.deleteRecord(index, recordId);\n        },\n\n        /**\n         * Change page\n         *\n         * @param {Number} page - current page\n         */\n        changePage: function (page) {\n            this.clear();\n\n            if (page === 1 && !this.recordData().length) {\n                return false;\n            }\n\n            if (~~page > this.pages()) {\n                this.currentPage(this.pages());\n\n                return false;\n            } else if (~~page < 1) {\n                this.currentPage(1);\n\n                return false;\n            }\n\n            this.initChildren();\n\n            return true;\n        },\n\n        /**\n         * Check page\n         *\n         * @returns {Boolean} is page first or not\n         */\n        isFirst: function () {\n            return this.currentPage() === 1;\n        },\n\n        /**\n         * Check page\n         *\n         * @returns {Boolean} is page last or not\n         */\n        isLast: function () {\n            return this.currentPage() === this.pages();\n        },\n\n        /**\n         * Change page to next\n         */\n        nextPage: function () {\n            this.currentPage(this.currentPage() + 1);\n        },\n\n        /**\n         * Change page to previous\n         */\n        previousPage: function () {\n            this.currentPage(this.currentPage() - 1);\n        },\n\n        /**\n         * Check dependency and set position to elements\n         *\n         * @param {Array} collection - elems\n         * @param {Number} position - current position\n         * @param {String} elemName - element name\n         *\n         * @returns {Array} collection\n         */\n        updatePosition: function (collection, position, elemName) {\n            var curPos,\n                parsePosition = ~~position,\n                result = _.filter(collection, function (record) {\n                    return ~~record.position === parsePosition;\n                });\n\n            if (result[1]) {\n                curPos = parsePosition + 1;\n                result[0].name === elemName ? result[1].position = curPos : result[0].position = curPos;\n                this.updatePosition(collection, curPos);\n            }\n\n            return collection;\n        },\n\n        /**\n         * Check max elements position and set if max\n         *\n         * @param {Number} position - current position\n         */\n        checkMaxPosition: function (position) {\n            var max = 0,\n                pos;\n\n            this.elems.each(function (record) {\n                pos = ~~record.position;\n                pos > max ? max = pos : false;\n            });\n\n            max < position ? max = position : false;\n            this.maxPosition = max;\n        },\n\n        /**\n         * Remove and set new max position\n         */\n        removeMaxPosition: function () {\n            this.maxPosition = 0;\n            this.elems.each(function (record) {\n                this.maxPosition < record.position ? this.maxPosition = ~~record.position : false;\n            }, this);\n        },\n\n        /**\n         * Update record template and rerender elems\n         *\n         * @param {String} recordName - record name\n         */\n        onUpdateRecordTemplate: function (recordName) {\n            if (recordName) {\n                this.recordTemplate = recordName;\n                this.reload();\n            }\n        },\n\n        /**\n         * Delete record\n         *\n         * @param {Number} index - row index\n         *\n         */\n        deleteRecord: function (index, recordId) {\n            var recordInstance,\n                lastRecord,\n                recordsData,\n                lastRecordIndex;\n\n            if (this.deleteProperty) {\n                recordsData = this.recordData();\n                recordInstance = _.find(this.elems(), function (elem) {\n                    return elem.index === index;\n                });\n                recordInstance.destroy();\n                this.elems([]);\n                this._updateCollection();\n                this.removeMaxPosition();\n                recordsData[recordInstance.index][this.deleteProperty] = this.deleteValue;\n                this.recordData(recordsData);\n                this.reinitRecordData();\n                this.reload();\n            } else {\n                this.update = true;\n\n                if (~~this.currentPage() === this.pages()) {\n                    lastRecordIndex = this.startIndex + this.getChildItems().length - 1;\n                    lastRecord =\n                        _.findWhere(this.elems(), {\n                            index: lastRecordIndex\n                        }) ||\n                        _.findWhere(this.elems(), {\n                            index: lastRecordIndex.toString()\n                        });\n\n                    lastRecord.destroy();\n                }\n\n                this.removeMaxPosition();\n                recordsData = this._getDataByProp(recordId);\n                this._updateData(recordsData);\n                this.update = false;\n            }\n\n            this._reducePages();\n            this._sort();\n        },\n\n        /**\n         * Reduce the number of pages\n         *\n         * @private\n         * @return void\n         */\n        _reducePages: function () {\n            if (this.pages() < ~~this.currentPage()) {\n                this.currentPage(this.pages());\n            }\n        },\n\n        /**\n         * Get data object by some property\n         *\n         * @param {Number} id - element id\n         * @param {String} prop - property\n         */\n        _getDataByProp: function (id, prop) {\n            prop = prop || this.identificationProperty;\n\n            return _.reject(this.getChildItems(), function (recordData) {\n                return recordData[prop].toString() === id.toString();\n            }, this);\n        },\n\n        /**\n         * Sort elems by position property\n         */\n        _sort: function () {\n            this.elems(this.elems().sort(function (propOne, propTwo) {\n                return ~~propOne.position - ~~propTwo.position;\n            }));\n        },\n\n        /**\n         * Set new data to dataSource,\n         * delete element\n         *\n         * @param {Array} data - record data\n         */\n        _updateData: function (data) {\n            var elems = _.clone(this.elems()),\n                path,\n                dataArr;\n\n            dataArr = this.recordData.splice(this.startIndex, this.recordData().length - this.startIndex);\n            dataArr.splice(0, this.pageSize);\n            elems = _.sortBy(this.elems(), function (elem) {\n                return ~~elem.index;\n            });\n\n            data.concat(dataArr).forEach(function (rec, idx) {\n                if (elems[idx]) {\n                    elems[idx].recordId = rec[this.identificationProperty];\n                }\n\n                if (!rec.position) {\n                    rec.position = this.maxPosition;\n                    this.setMaxPosition();\n                }\n\n                path = this.dataScope + '.' + this.index + '.' + (this.startIndex + idx);\n                this.source.set(path, rec);\n            }, this);\n\n            this.elems(elems);\n        },\n\n        /**\n         * Rerender dynamic-rows elems\n         */\n        reload: function () {\n            this.clear();\n            this.initChildren(false, true);\n        },\n\n        /**\n         * Destroy all dynamic-rows elems\n         *\n         * @returns {Object} Chainable.\n         */\n        clear: function () {\n            this.destroyChildren();\n\n            return this;\n        },\n\n        /**\n         * Reset data to initial value.\n         * Call method reset on child elements.\n         */\n        reset: function () {\n            var elems = this.elems();\n\n            _.each(elems, function (elem) {\n                if (_.isFunction(elem.reset)) {\n                    elem.reset();\n                }\n            });\n        },\n\n        /**\n         * Set classes\n         *\n         * @param {Object} data\n         *\n         * @returns {Object} Classes\n         */\n        setClasses: function (data) {\n            var additional;\n\n            if (_.isString(data.additionalClasses)) {\n                additional = data.additionalClasses.split(' ');\n                data.additionalClasses = {};\n\n                additional.forEach(function (name) {\n                    data.additionalClasses[name] = true;\n                });\n            }\n\n            if (!data.additionalClasses) {\n                data.additionalClasses = {};\n            }\n\n            _.extend(data.additionalClasses, {\n                '_fit': data.fit,\n                '_required': data.required,\n                '_error': data.error,\n                '_empty': !this.elems().length,\n                '_no-header': this.columnsHeaderAfterRender || this.collapsibleHeader\n            });\n\n            return data.additionalClasses;\n        },\n\n        /**\n         * Initialize children\n         *\n         * @returns {Object} Chainable.\n         */\n        initChildren: function () {\n            this.showSpinner(true);\n            this.getChildItems().forEach(function (data, index) {\n                this.addChild(data, this.startIndex + index);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Set visibility to dynamic-rows child\n         *\n         * @param {Boolean} state\n         */\n        setVisible: function (state) {\n            this.elems.each(function (record) {\n                record.setVisible(state);\n            }, this);\n        },\n\n        /**\n         * Set disabled property to dynamic-rows child\n         *\n         * @param {Boolean} state\n         */\n        setDisabled: function (state) {\n            this.elems.each(function (record) {\n                record.setDisabled(state);\n            }, this);\n        },\n\n        /**\n         * Set visibility to column\n         *\n         * @param {Number} index - column index\n         * @param {Boolean} state\n         */\n        setVisibilityColumn: function (index, state) {\n            this.elems.each(function (record) {\n                record.setVisibilityColumn(index, state);\n            }, this);\n        },\n\n        /**\n         * Set disabled property to column\n         *\n         * @param {Number} index - column index\n         * @param {Boolean} state\n         */\n        setDisabledColumn: function (index, state) {\n            this.elems.each(function (record) {\n                record.setDisabledColumn(index, state);\n            }, this);\n        },\n\n        /**\n         * Add child components\n         *\n         * @param {Object} data - component data\n         * @param {Number} index - record(row) index\n         * @param {Number|String} prop - custom identify property\n         *\n         * @returns {Object} Chainable.\n         */\n        addChild: function (data, index, prop) {\n            var template = this.templates.record,\n                child;\n\n            index = index || _.isNumber(index) ? index : this.recordData().length;\n            prop = prop || _.isNumber(prop) ? prop : index;\n\n            _.extend(this.templates.record, {\n                recordId: prop\n            });\n\n            child = utils.template(template, {\n                collection: this,\n                index: index\n            });\n\n            layout([child]);\n\n            return this;\n        },\n\n        /**\n         * Restore value to default\n         */\n        restoreToDefault: function () {\n            this.recordData(utils.copy(this.default));\n            this.reload();\n        },\n\n        /**\n         * Update whether value differs from default value\n         */\n        setDifferedFromDefault: function () {\n            var recordData = utils.copy(this.recordData());\n\n            Array.isArray(recordData) && recordData.forEach(function (item) {\n                delete item['record_id'];\n            });\n\n            this.isDifferedFromDefault(!_.isEqual(recordData, this.default));\n        },\n\n        /**\n         * Set the changed property if the current page is different\n         * than the default state\n         *\n         * @return void\n         */\n        setChangedForCurrentPage: function () {\n            this.pagesChanged[this.currentPage()] =\n                !compareArrays(this.defaultPagesState[this.currentPage()], this.arrayFilter(this.getChildItems()));\n            this.changed(_.some(this.pagesChanged));\n        }\n    });\n});\n","Magento_Ui/js/dynamic-rows/action-delete.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            links: {\n                value: false\n            }\n        },\n\n        /**\n         * Delete record handler.\n         *\n         * @param {Number} index\n         * @param {Number} id\n         */\n        deleteRecord: function (index, id) {\n            this.bubble('deleteRecord', index, id);\n        }\n    });\n});\n","Magento_Ui/js/dynamic-rows/dnd.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'uiElement',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (ko, $, _, Element) {\n    'use strict';\n\n    var transformProp;\n\n    /**\n     * Get element context\n     */\n    function getContext(elem) {\n        return ko.contextFor(elem);\n    }\n\n    /**\n     * Defines supported css 'transform' property.\n     *\n     * @returns {String|Undefined}\n     */\n    transformProp = (function () {\n        var style = document.createElement('div').style,\n            base = 'Transform',\n            vendors = ['webkit', 'moz', 'ms', 'o'],\n            vi = vendors.length,\n            property;\n\n        if (typeof style.transform !== 'undefined') {\n            return 'transform';\n        }\n\n        while (vi--) {\n            property = vendors[vi] + base;\n\n            if (typeof style[property] !== 'undefined') {\n                return property;\n            }\n        }\n    })();\n\n    return Element.extend({\n        defaults: {\n            separatorsClass: {\n                top: '_dragover-top',\n                bottom: '_dragover-bottom'\n            },\n            step: 'auto',\n            tableClass: 'table.admin__dynamic-rows',\n            recordsCache: [],\n            draggableElement: {},\n            draggableElementClass: '_dragged',\n            elemPositions: [],\n            listens: {\n                '${ $.recordsProvider }:elems': 'setCacheRecords'\n            },\n            modules: {\n                parentComponent: '${ $.recordsProvider }'\n            }\n        },\n\n        /**\n         * Initialize component\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'mousemoveHandler',\n                'mouseupHandler'\n            );\n\n            this._super()\n                .body = $('body');\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent, initializes 'options' and 'initialOptions'\n         *     properties, calls 'setOptions' passing options to it\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'recordsCache'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Init listens to start drag\n         *\n         * @param {Object} elem - DOM element\n         * @param {Object} data - element data\n         */\n        initListeners: function (elem, data) {\n            $(elem).on('mousedown touchstart', this.mousedownHandler.bind(this, data, elem));\n        },\n\n        /**\n         * Mouse down handler\n         *\n         * @param {Object} data - element data\n         * @param {Object} elem - element\n         * @param {Object} event - key down event\n         */\n        mousedownHandler: function (data, elem, event) {\n            var recordNode = this.getRecordNode(elem),\n                originRecord = $(elem).parents('tr').eq(0),\n                drEl = this.draggableElement,\n                $table = $(elem).parents('table').eq(0),\n                $tableWrapper = $table.parent();\n\n            this.disableScroll();\n            $(recordNode).addClass(this.draggableElementClass);\n            $(originRecord).addClass(this.draggableElementClass);\n            this.step = this.step === 'auto' ? originRecord.height() / 2 : this.step;\n            drEl.originRow = originRecord;\n            drEl.instance = recordNode = this.processingStyles(recordNode, elem);\n            drEl.instanceCtx = this.getRecord(originRecord[0]);\n            drEl.eventMousedownY = this.getPageY(event);\n            drEl.minYpos =\n                $table.offset().top - originRecord.offset().top + $table.children('thead').outerHeight();\n            drEl.maxYpos = drEl.minYpos + $table.children('tbody').outerHeight() - originRecord.outerHeight();\n            $tableWrapper.append(recordNode);\n            this.body.bind('mousemove touchmove', this.mousemoveHandler);\n            this.body.bind('mouseup touchend', this.mouseupHandler);\n        },\n\n        /**\n         * Mouse move handler\n         *\n         * @param {Object} event - mouse move event\n         */\n        mousemoveHandler: function (event) {\n            var depEl = this.draggableElement,\n                pageY = this.getPageY(event),\n                positionY = pageY - depEl.eventMousedownY,\n                processingPositionY = positionY + 'px',\n                processingMaxYpos = depEl.maxYpos + 'px',\n                processingMinYpos = depEl.minYpos + 'px',\n                depElement = this.getDepElement(depEl.instance, positionY, depEl.originRow);\n\n            if (depElement) {\n                depEl.depElement ? depEl.depElement.elem.removeClass(depEl.depElement.className) : false;\n                depEl.depElement = depElement;\n                depEl.depElement.insert !== 'none' ? depEl.depElement.elem.addClass(depElement.className) : false;\n            } else if (depEl.depElement && depEl.depElement.insert !== 'none') {\n                depEl.depElement.elem.removeClass(depEl.depElement.className);\n                depEl.depElement.insert = 'none';\n            }\n\n            if (positionY > depEl.minYpos && positionY < depEl.maxYpos) {\n                $(depEl.instance)[0].style[transformProp] = 'translateY(' + processingPositionY + ')';\n            } else if (positionY < depEl.minYpos) {\n                $(depEl.instance)[0].style[transformProp] = 'translateY(' + processingMinYpos + ')';\n            } else if (positionY >= depEl.maxYpos) {\n                $(depEl.instance)[0].style[transformProp] = 'translateY(' + processingMaxYpos + ')';\n            }\n        },\n\n        /**\n         * Mouse up handler\n         */\n        mouseupHandler: function (event) {\n            var depElementCtx,\n                drEl = this.draggableElement,\n                pageY = this.getPageY(event),\n                positionY = pageY - drEl.eventMousedownY;\n\n            this.enableScroll();\n            drEl.depElement = this.getDepElement(drEl.instance, positionY, this.draggableElement.originRow);\n\n            drEl.instance.remove();\n\n            if (drEl.depElement) {\n                depElementCtx = this.getRecord(drEl.depElement.elem[0]);\n                drEl.depElement.elem.removeClass(drEl.depElement.className);\n\n                if (drEl.depElement.insert !== 'none') {\n                    this.setPosition(drEl.depElement.elem, depElementCtx, drEl);\n                }\n            }\n\n            drEl.originRow.removeClass(this.draggableElementClass);\n\n            this.body.unbind('mousemove touchmove', this.mousemoveHandler);\n            this.body.unbind('mouseup touchend', this.mouseupHandler);\n\n            this.draggableElement = {};\n        },\n\n        /**\n         * Set position to element\n         *\n         * @param {Object} depElem - dep element\n         * @param {Object} depElementCtx - dep element context\n         * @param {Object} dragData - data draggable element\n         */\n        setPosition: function (depElem, depElementCtx, dragData) {\n            var depElemPosition = ~~depElementCtx.position;\n\n            if (dragData.depElement.insert === 'after') {\n                dragData.instanceCtx.position = depElemPosition + 1;\n            } else if (dragData.depElement.insert === 'before') {\n                dragData.instanceCtx.position = depElemPosition;\n            }\n        },\n\n        /**\n         * Get dependency element\n         *\n         * @param {Object} curInstance - current element instance\n         * @param {Number} position\n         * @param {Object} row\n         */\n        getDepElement: function (curInstance, position, row) {\n            var tableSelector = this.tableClass + ' tr',\n                $table = $(row).parents('table').eq(0),\n                $curInstance = $(curInstance),\n                recordsCollection = $table.find('table').length ?\n                    $table.find('tbody > tr').filter(function (index, elem) {\n                        return !$(elem).parents(tableSelector).length;\n                    }) :\n                    $table.find('tbody > tr'),\n                curInstancePositionTop = $curInstance.position().top,\n                curInstancePositionBottom = curInstancePositionTop + $curInstance.height();\n\n            if (position < 0) {\n                return this._getDepElement(recordsCollection, 'before', curInstancePositionTop);\n            } else if (position > 0) {\n                return this._getDepElement(recordsCollection, 'after', curInstancePositionBottom);\n            }\n        },\n\n        /**\n         * Get dependency element private\n         *\n         * @param {Array} collection - record collection\n         * @param {String} position - position to add\n         * @param {Number} dragPosition - position drag element\n         */\n        _getDepElement: function (collection, position, dragPosition) {\n            var rec,\n                rangeEnd,\n                rangeStart,\n                result,\n                className,\n                i = 0,\n                length = collection.length;\n\n            for (i; i < length; i++) {\n                rec = collection.eq(i);\n\n                if (position === 'before') {\n                    rangeStart = collection.eq(i).position().top - this.step;\n                    rangeEnd = rangeStart + this.step * 2;\n                    className = this.separatorsClass.top;\n                } else if (position === 'after') {\n                    rangeEnd = rec.position().top + rec.height() + this.step;\n                    rangeStart = rangeEnd - this.step * 2;\n                    className = this.separatorsClass.bottom;\n                }\n\n                if (dragPosition > rangeStart && dragPosition < rangeEnd) {\n                    result = {\n                        elem: rec,\n                        insert: rec[0] === this.draggableElement.originRow[0] ? 'none' : position,\n                        className: className\n                    };\n                }\n            }\n\n            return result;\n        },\n\n        /**\n         * Set default position of draggable element\n         *\n         * @param {Object} elem - current element instance\n         * @param {Object} data - current element data\n         */\n        _setDefaultPosition: function (elem, data) {\n            var originRecord = $(elem).parents('tr').eq(0),\n                position = originRecord.position();\n\n            ++position.top;\n            $(data).css(position);\n        },\n\n        /**\n         * Set records to cache\n         *\n         * @param {Object} records - record instance\n         */\n        setCacheRecords: function (records) {\n            this.recordsCache(records);\n        },\n\n        /**\n         * Set styles to draggable element\n         *\n         * @param {Object} data - data\n         * @param {Object} elem - elem instance\n         * @returns {Object} instance data.\n         */\n        processingStyles: function (data, elem) {\n            var table = $(elem).parents('table').eq(0),\n                columns = table.find('th'),\n                recordColumns = $(data).find('td');\n\n            this._setDefaultPosition(elem, $(data));\n            this._setColumnsWidth(columns, recordColumns);\n            this._setTableWidth(table, $(data));\n\n            return data;\n        },\n\n        /**\n         * Set table width.\n         *\n         * @param {Object} originalTable - original record instance\n         * @param {Object} recordTable - draggable record instance\n         */\n        _setTableWidth: function (originalTable, recordTable) {\n            recordTable.outerWidth(originalTable.outerWidth());\n        },\n\n        /**\n         * Set columns width.\n         *\n         * @param {Object} originColumns - original record instance\n         * @param {Object} recordColumns - draggable record instance\n         */\n        _setColumnsWidth: function (originColumns, recordColumns) {\n            var i = 0,\n                length = originColumns.length;\n\n            for (i; i < length; i++) {\n                recordColumns.eq(i).outerWidth(originColumns.eq(i).outerWidth());\n            }\n        },\n\n        /**\n         * Get copy original record\n         *\n         * @param {Object} record - original record instance\n         * @returns {Object} draggable record instance\n         */\n        getRecordNode: function (record) {\n            var $record = $(record),\n                table = $record.parents('table')[0].cloneNode(true),\n                $table = $(table);\n\n            $table.find('tr').remove();\n            $table.append($record.parents('tr')[0].cloneNode(true));\n\n            return table;\n        },\n\n        /**\n         * Get record context by element\n         *\n         * @param {Object} elem - original element\n         * @returns {Object} draggable record context\n         */\n        getRecord: function (elem) {\n            var ctx = getContext(elem),\n                index = _.isFunction(ctx.$index) ? ctx.$index() : ctx.$index;\n\n            return this.recordsCache()[index];\n        },\n\n        /**\n         * Get correct page Y\n         *\n         * @param {Object} event - current event\n         * @returns {integer}\n         */\n        getPageY: function (event) {\n            var pageY;\n\n            if (event.type.indexOf('touch') >= 0) {\n                if (event.originalEvent.touches[0]) {\n                    pageY = event.originalEvent.touches[0].pageY;\n                } else {\n                    pageY = event.originalEvent.changedTouches[0].pageY;\n                }\n            } else {\n                pageY = event.pageY;\n            }\n\n            return pageY;\n        },\n\n        /**\n         * Disable page scrolling\n         */\n        disableScroll: function () {\n            document.body.addEventListener('touchmove', this.preventDefault, {\n                passive: false\n            });\n        },\n\n        /**\n         * Enable page scrolling\n         */\n        enableScroll: function () {\n            document.body.removeEventListener('touchmove', this.preventDefault, {\n                passive: false\n            });\n        },\n\n        /**\n         * Prevent default function\n         *\n         * @param {Object} event - event object\n         */\n        preventDefault: function (event) {\n            event.preventDefault();\n        }\n\n    });\n});\n","Magento_Ui/js/dynamic-rows/record.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiCollection',\n    'uiRegistry'\n], function (_, uiCollection, registry) {\n    'use strict';\n\n    return uiCollection.extend({\n        defaults: {\n            visible: true,\n            disabled: true,\n            headerLabel: '',\n            label: '',\n            positionProvider: 'position',\n            imports: {\n                data: '${ $.provider }:${ $.dataScope }'\n            },\n            listens: {\n                position: 'initPosition',\n                elems: 'setColumnVisibleListener'\n            },\n            links: {\n                position: '${ $.name }.${ $.positionProvider }:value'\n            },\n            exports: {\n                recordId: '${ $.provider }:${ $.dataScope }.record_id'\n            },\n            modules: {\n                parentComponent: '${ $.parentName }'\n            }\n        },\n\n        /**\n         * Extends instance with default config, calls initialize of parent\n         * class, calls initChildren method, set observe variable.\n         * Use parent \"track\" method - wrapper observe array\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n\n            registry.async(this.name + '.' + this.positionProvider)(function (component) {\n\n                /**\n                 * Overwrite hasChanged method\n                 *\n                 * @returns {Boolean}\n                 */\n                component.hasChanged = function () {\n\n                    /* eslint-disable eqeqeq */\n                    return this.value().toString() != this.initialValue.toString();\n\n                    /* eslint-enable eqeqeq */\n                };\n\n                if (!component.initialValue) {\n                    component.initialValue = self.parentComponent().maxPosition;\n                    component.bubble('update', component.hasChanged());\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Init config\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.label = this.label || this.headerLabel;\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('position')\n                .observe([\n                    'visible',\n                    'disabled',\n                    'data',\n                    'label'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Init element position\n         *\n         * @param {Number} position - element position\n         */\n        initPosition: function (position) {\n            var pos = parseInt(position, 10);\n\n            this.parentComponent().setMaxPosition(pos, this);\n\n            if (!pos && pos !== 0) {\n                this.position = this.parentComponent().maxPosition;\n            }\n        },\n\n        /**\n         * Set column visibility listener\n         */\n        setColumnVisibleListener: function () {\n            var elem = _.find(this.elems(), function (curElem) {\n                return !curElem.hasOwnProperty('visibleListener');\n            });\n\n            if (!elem) {\n                return;\n            }\n\n            this.childVisibleListener(elem);\n\n            if (!elem.visibleListener) {\n                elem.on('visible', this.childVisibleListener.bind(this, elem));\n            }\n\n            elem.visibleListener = true;\n        },\n\n        /**\n         * Child visibility listener\n         *\n         * @param {Object} data\n         */\n        childVisibleListener: function (data) {\n            this.setVisibilityColumn(data.index, data.visible());\n        },\n\n        /**\n         * Reset data to initial value.\n         * Call method reset on child elements.\n         */\n        reset: function () {\n            var elems = this.elems(),\n                nameIsEqual,\n                dataScopeIsEqual;\n\n            _.each(elems, function (elem) {\n                nameIsEqual = this.name + '.' + this.positionProvider === elem.name;\n                dataScopeIsEqual = this.dataScope === elem.dataScope;\n\n                if (!(nameIsEqual || dataScopeIsEqual) && _.isFunction(elem.reset)) {\n                    elem.reset();\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Clear data\n         *\n         * @returns {Collection} Chainable.\n         */\n        clear: function () {\n            var elems = this.elems(),\n                nameIsEqual,\n                dataScopeIsEqual;\n\n            _.each(elems, function (elem) {\n                nameIsEqual = this.name + '.' + this.positionProvider === elem.name;\n                dataScopeIsEqual = this.dataScope === elem.dataScope;\n\n                if (!(nameIsEqual || dataScopeIsEqual) && _.isFunction(elem.reset)) {\n                    elem.clear();\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Get label for collapsible header\n         *\n         * @param {String} label\n         *\n         * @returns {String}\n         */\n        getLabel: function (label) {\n            if (_.isString(label)) {\n                this.label(label);\n            } else if (label && this.label()) {\n                return this.label();\n            } else {\n                this.label(this.headerLabel);\n            }\n\n            return this.label();\n        },\n\n        /**\n         * Set visibility to record child\n         *\n         * @param {Boolean} state\n         */\n        setVisible: function (state) {\n            this.elems.each(function (cell) {\n                cell.visible(state);\n            });\n        },\n\n        /**\n         * Set visibility to child by index\n         *\n         * @param {Number} index\n         * @param {Boolean} state\n         */\n        setVisibilityColumn: function (index, state) {\n            var elems = this.elems(),\n                curElem = parseInt(index, 10),\n                label;\n\n            if (!this.parentComponent()) {\n                return false;\n            }\n\n            if (_.isNaN(curElem)) {\n                _.findWhere(elems, {\n                    index: index\n                }).visible(state);\n                label = _.findWhere(this.parentComponent().labels(), {\n                    name: index\n                });\n                label.defaultLabelVisible && label.visible(state);\n            } else {\n                elems[curElem].visible(state);\n            }\n        },\n\n        /**\n         * Set disabled to child\n         *\n         * @param {Boolean} state\n         */\n        setDisabled: function (state) {\n            this.elems.each(function (cell) {\n                cell.disabled(state);\n            });\n        },\n\n        /**\n         * Set disabled to child by index\n         *\n         * @param {Number} index\n         * @param {Boolean} state\n         */\n        setDisabledColumn: function (index, state) {\n            index = ~~index;\n            this.elems()[index].disabled(state);\n        }\n    });\n});\n","Magento_Ui/js/lib/step-wizard.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiRegistry',\n    'uiComponent',\n    'jquery',\n    'underscore',\n    'ko',\n    'mage/backend/notification',\n    'mage/translate'\n], function (uiRegistry, Component, $, _, ko) {\n    'use strict';\n\n    var Wizard;\n\n    ko.utils.domNodeDisposal.cleanExternalData = _.wrap(\n        ko.utils.domNodeDisposal.cleanExternalData,\n        function (func, node) {\n            if (!$(node).closest('[data-type=skipKO]').length) {\n                func(node);\n            }\n        }\n    );\n\n    /**\n     * Wizard constructor.\n     *\n     * @param {Array} steps\n     * @param {String} modalClass\n     * @constructor\n     */\n    Wizard = function (steps, modalClass) {\n        this.steps = steps;\n        this.index = 0;\n        this.data = {};\n        this.nextLabelText = $.mage.__('Next');\n        this.prevLabelText = $.mage.__('Back');\n        this.elementSelector = '[data-role=steps-wizard-main]';\n        this.element = modalClass ? $('.' + modalClass + this.elementSelector) : $(this.elementSelector);\n        this.nextLabel = '[data-role=\"step-wizard-next\"]';\n        this.prevLabel = '[data-role=\"step-wizard-prev\"]';\n        this.element.notification();\n\n        /**\n         * Move to newIndex.\n         *\n         * @param {Number} newIndex\n         * @return {String}\n         */\n        this.move = function (newIndex) {\n            if (!this.preventSwitch(newIndex)) {\n                if (newIndex > this.index) {\n                    this._next(newIndex);\n                } else if (newIndex < this.index) {\n                    this._prev(newIndex);\n                }\n            }\n            this.updateLabels(this.getStep());\n            this.showNotificationMessage();\n\n            return this.getStep().name;\n        };\n\n        /**\n         * Move wizard to next step.\n         *\n         * @return {String}\n         */\n        this.next = function () {\n            this.move(this.index + 1);\n\n            return this.getStep().name;\n        };\n\n        /**\n         * Move wizard to previous step.\n         *\n         * @return {String}\n         */\n        this.prev = function () {\n            this.move(this.index - 1);\n\n            return this.getStep().name;\n        };\n\n        /**\n         * @return {*}\n         */\n        this.preventSwitch = function (newIndex) {\n            return newIndex < 0 || (newIndex - this.index) > 1;//eslint-disable-line no-extra-parens\n        };\n\n        /**\n         * @param {Number} newIndex\n         * @return {Boolean}\n         * @private\n         */\n        this._next = function (newIndex) {\n            newIndex = _.isNumber(newIndex) ? newIndex : this.index + 1;\n\n            try {\n                this.getStep().force(this);\n\n                if (newIndex >= steps.length) {\n                    return false;\n                }\n            } catch (e) {\n                this.setNotificationMessage(e.message, true);\n\n                return false;\n            }\n            this.cleanErrorNotificationMessage();\n            this.index = newIndex;\n            this.cleanNotificationMessage();\n            this.render();\n        };\n\n        /**\n         * @param {Number} newIndex\n         * @private\n         */\n        this._prev = function (newIndex) {\n            newIndex = _.isNumber(newIndex) ? newIndex : this.index - 1;\n            this.getStep().back(this);\n            this.index = newIndex;\n        };\n\n        /**\n         * @param {Number} stepIndex\n         * @return {Object}\n         */\n        this.getStep = function (stepIndex) {\n            return this.steps[stepIndex || this.index] || {};\n        };\n\n        /**\n         * @param {String} message\n         * @param {String} error\n         */\n        this.notifyMessage = function (message, error) {\n            $(this.element).notification('clear').notification('add', {\n                error: error,\n                message: message\n            });\n        };\n\n        /**\n         * @param {Object} step\n         */\n        this.updateLabels = function (step) {\n            this.element.find(this.nextLabel).find('button').text(step.nextLabelText || this.nextLabelText);\n            this.element.find(this.prevLabel).find('button').text(step.prevLabelText || this.prevLabelText);\n        };\n\n        /**\n         * Show notification message.\n         */\n        this.showNotificationMessage = function () {\n            if (!_.isEmpty(this.getStep())) {\n                this.hideNotificationMessage();\n\n                if (this.getStep().notificationMessage.text !== null) {\n                    this.notifyMessage(\n                        this.getStep().notificationMessage.text,\n                        this.getStep().notificationMessage.error\n                    );\n                }\n            }\n        };\n\n        /**\n         * Remove notification message.\n         */\n        this.cleanNotificationMessage = function () {\n            this.getStep().notificationMessage.text = null;\n            this.hideNotificationMessage();\n        };\n\n        /**\n         * Remove error message.\n         */\n        this.cleanErrorNotificationMessage = function () {\n            if (this.getStep().notificationMessage.error === true) {\n                this.cleanNotificationMessage();\n            }\n        };\n\n        /**\n         * @param {String} text\n         * @param {String} error\n         */\n        this.setNotificationMessage = function (text, error) {\n            error = error !== undefined;\n\n            if (!_.isEmpty(this.getStep())) {\n                this.getStep().notificationMessage.text = text;\n                this.getStep().notificationMessage.error = error;\n                this.showNotificationMessage();\n            }\n        };\n\n        /**\n         * Hide notification message.\n         */\n        this.hideNotificationMessage = function () {\n            $(this.element).notification('clear');\n        };\n\n        /**\n         * Render step.\n         */\n        this.render = function () {\n            this.hideNotificationMessage();\n            this.getStep().render(this);\n        };\n\n        /**\n         * Initialize step.\n         */\n        this.init = function () {\n            this.updateLabels(this.getStep());\n            this.render();\n        };\n        this.init();\n    };\n\n    return Component.extend({\n        defaults: {\n            modalClass: '',\n            initData: [],\n            stepsNames: [],\n            selectedStep: '',\n            steps: [],\n            disabled: true\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.selectedStep.subscribe(this.wrapDisabledBackButton.bind(this));\n        },\n\n        /** @inheritdoc */\n        initElement: function (step) {\n            step.initData = this.initData;\n            step.mode = _.all(this.initData, _.isEmpty) ? 'create' : 'edit';\n            this.steps[this.getStepIndexByName(step.name)] = step;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe([\n                'selectedStep',\n                'disabled'\n            ]);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            _.each(this.steps, function (step) {\n                step.destroy();\n            });\n\n            this._super();\n        },\n\n        /**\n         * Toggle disable property.\n         *\n         * @param {String} stepName\n         */\n        wrapDisabledBackButton: function (stepName) {\n            if (_.first(this.stepsNames) === stepName) {\n                this.disabled(true);\n            } else {\n                this.disabled(false);\n            }\n        },\n\n        /**\n         * Get step by index name.\n         *\n         * @param {String} stepName\n         */\n        getStepIndexByName: function (stepName) {\n            return _.indexOf(this.stepsNames, stepName);\n        },\n        //controls, todo to another object\n        /**\n         * Select next step.\n         */\n        next: function () {\n            this.selectedStep(this.wizard.next());\n        },\n\n        /**\n         * Select previous step.\n         */\n        back: function () {\n            this.selectedStep(this.wizard.prev());\n        },\n\n        /**\n         * Open wizard.\n         */\n        open: function () {\n            this.selectedStep(this.stepsNames.first());\n            this.wizard = new Wizard(this.steps, this.modalClass);\n        },\n\n        /**\n         * Close wizard.\n         */\n        close: function () {\n            var modal =  uiRegistry.get(this.initData.configurableModal);\n\n            if (!_.isUndefined(modal)) {\n                modal.closeModal();\n            }\n        },\n\n        /**\n         * @param {Object} data\n         * @param {Object} event\n         */\n        showSpecificStep: function (data, event) {\n            var index = _.indexOf(this.stepsNames, event.target.hash.substr(1)),\n                stepName = this.wizard.move(index);\n\n            this.selectedStep(stepName);\n        }\n    });\n});\n","Magento_Ui/js/lib/spinner.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var selector = '[data-role=\"spinner\"]',\n        spinner = $(selector);\n\n    return {\n        /**\n         * Show spinner.\n         */\n        show: function () {\n            spinner.show();\n        },\n\n        /**\n         * Hide spinner.\n         */\n        hide: function () {\n            spinner.hide();\n        },\n\n        /**\n         * Get spinner by selector.\n         *\n         * @param {String} id\n         * @return {jQuery}\n         */\n        get: function (id) {\n            return $(selector + '[data-component=\"' + id + '\"]');\n        }\n    };\n});\n","Magento_Ui/js/lib/key-codes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    return {\n        13: 'enterKey',\n        27: 'escapeKey',\n        40: 'pageDownKey',\n        38: 'pageUpKey',\n        32: 'spaceKey',\n        9:  'tabKey',\n        37: 'pageLeftKey',\n        39: 'pageRightKey',\n        17: 'ctrlKey',\n        18: 'altKey',\n        16: 'shiftKey',\n        66: 'bKey',\n        73: 'iKey',\n        85: 'uKey'\n    };\n});\n","Magento_Ui/js/lib/collapsible.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiComponent'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            opened: false,\n            collapsible: true\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('opened');\n\n            return this;\n        },\n\n        /**\n         * Toggles value of the 'opened' property.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        toggleOpened: function () {\n            this.opened() ?\n                this.close() :\n                this.open();\n\n            return this;\n        },\n\n        /**\n         * Sets 'opened' flag to false.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        close: function () {\n            if (this.collapsible) {\n                this.opened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets 'opened' flag to true.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        open: function () {\n            if (this.collapsible) {\n                this.opened(true);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/lib/registry/registry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n/* global WeakMap */\ndefine([\n    'jquery',\n    'underscore',\n    'es6-collections'\n], function ($, _) {\n    'use strict';\n\n    var privateData = new WeakMap();\n\n    /**\n     * Extracts private item storage associated\n     * with a provided registry instance.\n     *\n     * @param {Object} container\n     * @returns {Object}\n     */\n    function getItems(container) {\n        return privateData.get(container).items;\n    }\n\n    /**\n     * Extracts private requests array associated\n     * with a provided registry instance.\n     *\n     * @param {Object} container\n     * @returns {Array}\n     */\n    function getRequests(container) {\n        return privateData.get(container).requests;\n    }\n\n    /**\n     * Wrapper function used for convenient access to the elements.\n     * See 'async' method for examples of usage and comparison\n     * with a regular 'get' method.\n     *\n     * @param {(String|Object|Function)} name - Key of the requested element.\n     * @param {Registry} registry - Instance of a registry\n     *      where to search for the element.\n     * @param {(Function|String)} [method] - Optional callback function\n     *      or a name of the elements' method which\n     *      will be invoked when element is available in registry.\n     * @returns {*}\n     */\n    function async(name, registry, method) {\n        var args = _.toArray(arguments).slice(3);\n\n        if (_.isString(method)) {\n            registry.get(name, function (component) {\n                component[method].apply(component, args);\n            });\n        } else if (_.isFunction(method)) {\n            registry.get(name, method);\n        } else if (!args.length) {\n            return registry.get(name);\n        }\n    }\n\n    /**\n     * Checks that every property of the query object\n     * is present and equal to the corresponding\n     * property in target object.\n     * Note that non-strict comparison is used.\n     *\n     * @param {Object} query - Query object.\n     * @param {Object} target - Target object.\n     * @returns {Boolean}\n     */\n    function compare(query, target) {\n        var matches = true,\n            index,\n            keys,\n            key;\n\n        if (!_.isObject(query) || !_.isObject(target)) {\n            return false;\n        }\n\n        keys = Object.getOwnPropertyNames(query);\n        index = keys.length;\n\n        while (matches && index--) {\n            key = keys[index];\n\n            /* eslint-disable eqeqeq */\n            if (target[key] != query[key]) {\n                matches = false;\n            }\n\n            /* eslint-enable eqeqeq */\n        }\n\n        return matches;\n    }\n\n    /**\n     * Explodes incoming string into object if\n     * string is defined as a set of key = value pairs.\n     *\n     * @param {(String|*)} query - String to be processed.\n     * @returns {Object|*} Either created object or an unmodified incoming\n     *      value if conversion was not possible.\n     * @example Sample conversions.\n     *      'key = value, key2 = value2'\n     *      => {key: 'value', key2: 'value2'}\n     */\n    function explode(query) {\n        var result = {},\n            index,\n            data;\n\n        if (typeof query !== 'string' || !~query.indexOf('=')) {\n            return query;\n        }\n\n        query = query.split(',');\n        index = query.length;\n\n        while (index--) {\n            data = query[index].split('=');\n\n            result[data[0].trim()] = data[1].trim();\n        }\n\n        return result;\n    }\n\n    /**\n     * Extracts items from the provided data object\n     * which matches specified search criteria.\n     *\n     * @param {Object} data - Data object where to perform a lookup.\n     * @param {(String|Object|Function)} query - Search criteria.\n     * @param {Boolean} findAll - Flag that defines whether to\n     *      search for all applicable items or to stop on a first found entry.\n     * @returns {Array|Object|*}\n     */\n    function find(data, query, findAll) {\n        var iterator,\n            item;\n\n        query = explode(query);\n\n        if (typeof query === 'string') {\n            item = data[query];\n\n            if (findAll) {\n                return item ? [item] : [];\n            }\n\n            return item;\n        }\n\n        iterator = !_.isFunction(query) ?\n            compare.bind(null, query) :\n            query;\n\n        return findAll ?\n            _.filter(data, iterator) :\n            _.find(data, iterator);\n    }\n\n    /**\n     * @constructor\n     */\n    function Registry() {\n        var data = {\n            items: {},\n            requests: []\n        };\n\n        this._updateRequests = _.debounce(this._updateRequests.bind(this), 10);\n        privateData.set(this, data);\n    }\n\n    Registry.prototype = {\n        constructor: Registry,\n\n        /**\n         * Retrieves item from registry which matches specified search criteria.\n         *\n         * @param {(Object|String|Function|Array)} query - Search condition (see examples).\n         * @param {Function} [callback] - Callback that will be invoked when\n         *      all of the requested items are available.\n         * @returns {*}\n         *\n         * @example Requesting item by it's name.\n         *      var obj = {index: 'test', sample: true};\n         *\n         *      registry.set('first', obj);\n         *      registry.get('first') === obj;\n         *      => true\n         *\n         * @example Requesting item with a specific properties.\n         *      registry.get('sample = 1, index = test') === obj;\n         *      => true\n         *      registry.get('sample = 0, index = foo') === obj;\n         *      => false\n         *\n         * @example Declaring search criteria as an object.\n         *      registry.get({sample: true}) === obj;\n         *      => true;\n         *\n         * @example Providing custom search handler.\n         *      registry.get(function (item) { return item.sample === true; }) === obj;\n         *      => true\n         *\n         * @example Sample asynchronous request declaration.\n         *      registry.get('index = test', function (item) {});\n         *\n         * @example Requesting multiple elements.\n         *      registry.set('second', {index: 'test2'});\n         *      registry.get(['first', 'second'], function (first, second) {});\n         */\n        get: function (query, callback) {\n            if (typeof callback !== 'function') {\n                return find(getItems(this), query);\n            }\n\n            this._addRequest(query, callback);\n        },\n\n        /**\n         * Sets provided item to the registry.\n         *\n         * @param {String} id - Item's identifier.\n         * @param {*} item - Item's data.\n         * returns {Registry} Chainable.\n         */\n        set: function (id, item) {\n            getItems(this)[id] = item;\n\n            this._updateRequests();\n\n            return this;\n        },\n\n        /**\n         * Removes specified item from registry.\n         * Note that search query is not applicable.\n         *\n         * @param {String} id - Item's identifier.\n         * @returns {Registry} Chainable.\n         */\n        remove: function (id) {\n            delete getItems(this)[id];\n\n            return this;\n        },\n\n        /**\n         * Retrieves a collection of elements that match\n         * provided search criteria.\n         *\n         * @param {(Object|String|Function)} query - Search query.\n         *      See 'get' method for the syntax examples.\n         * @returns {Array} Found elements.\n         */\n        filter: function (query) {\n            return find(getItems(this), query, true);\n        },\n\n        /**\n         * Checks that at least one element in collection\n         * matches provided search criteria.\n         *\n         * @param {(Object|String|Function)} query - Search query.\n         *      See 'get' method for the syntax examples.\n         * @returns {Boolean}\n         */\n        has: function (query) {\n            return !!this.get(query);\n        },\n\n        /**\n         * Checks that registry contains a provided item.\n         *\n         * @param {*} item - Item to be checked.\n         * @returns {Boolean}\n         */\n        contains: function (item) {\n            return _.contains(getItems(this), item);\n        },\n\n        /**\n         * Extracts identifier of an item if it's present in registry.\n         *\n         * @param {*} item - Item whose identifier will be extracted.\n         * @returns {String|Undefined}\n         */\n        indexOf: function (item) {\n            return _.findKey(getItems(this), function (elem) {\n                return item === elem;\n            });\n        },\n\n        /**\n         * Same as a 'get' method except that it returns\n         * a promise object instead of invoking provided callback.\n         *\n         * @param {(String|Function|Object|Array)} query - Search query.\n         *      See 'get' method for the syntax examples.\n         * @returns {jQueryPromise}\n         */\n        promise: function (query) {\n            var defer    = $.Deferred(),\n                callback = defer.resolve.bind(defer);\n\n            this.get(query, callback);\n\n            return defer.promise();\n        },\n\n        /**\n         * Creates a wrapper function over the provided search query\n         * in order to provide somehow more convenient access to the\n         * registry's items.\n         *\n         * @param {(String|Object|Function)} query - Search criteria.\n         *      See 'get' method for the syntax examples.\n         * @returns {Function}\n         *\n         * @example Comparison with a 'get' method on retrieving items.\n         *      var module = registry.async('name');\n         *\n         *      module();\n         *      => registry.get('name');\n         *\n         * @example Asynchronous request.\n         *      module(function (component) {});\n         *      => registry.get('name', function (component) {});\n         *\n         * @example Requesting item and invoking it's method with specified parameters.\n         *      module('trigger', true);\n         *      => registry.get('name', function (component) {\n         *          component.trigger(true);\n         *      });\n         */\n        async: function (query) {\n            return async.bind(null, query, this);\n        },\n\n        /**\n         * Creates new instance of a Registry.\n         *\n         * @returns {Registry} New instance.\n         */\n        create: function () {\n            return new Registry;\n        },\n\n        /**\n         * Adds new request to the queue or resolves it immediately\n         * if all of the required items are available.\n         *\n         * @private\n         * @param {(Object|String|Function|Array)} queries - Search criteria.\n         *      See 'get' method for the syntax examples.\n         * @param {Function} callback - Callback that will be invoked when\n         *      all of the requested items are available.\n         * @returns {Registry}\n         */\n        _addRequest: function (queries, callback) {\n            var request;\n\n            if (!Array.isArray(queries)) {\n                queries = queries ? [queries] : [];\n            }\n\n            request = {\n                queries: queries.map(explode),\n                callback: callback\n            };\n\n            this._canResolve(request) ?\n                this._resolveRequest(request) :\n                getRequests(this).push(request);\n\n            return this;\n        },\n\n        /**\n         * Updates requests list resolving applicable items.\n         *\n         * @private\n         * @returns {Registry} Chainable.\n         */\n        _updateRequests: function () {\n            getRequests(this)\n                .filter(this._canResolve, this)\n                .forEach(this._resolveRequest, this);\n\n            return this;\n        },\n\n        /**\n         * Resolves provided request invoking it's callback\n         * with items specified in query parameters.\n         *\n         * @private\n         * @param {Object} request - Request object.\n         * @returns {Registry} Chainable.\n         */\n        _resolveRequest: function (request) {\n            var requests = getRequests(this),\n                items    = request.queries.map(this.get, this),\n                index    = requests.indexOf(request);\n\n            request.callback.apply(null, items);\n\n            if (~index) {\n                requests.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks if provided request can be resolved.\n         *\n         * @private\n         * @param {Object} request - Request object.\n         * @returns {Boolean}\n         */\n        _canResolve: function (request) {\n            var queries = request.queries;\n\n            return queries.every(this.has, this);\n        }\n    };\n\n    return new Registry;\n});\n","Magento_Ui/js/lib/knockout/bootstrap.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Loads all available knockout bindings, sets custom template engine, initializes knockout on page */\n\ndefine([\n    'ko',\n    './template/engine',\n    'knockoutjs/knockout-es5',\n    './bindings/bootstrap',\n    './extender/observable_array',\n    './extender/bound-nodes',\n    'domReady!'\n], function (ko, templateEngine) {\n    'use strict';\n\n    ko.uid = 0;\n\n    ko.setTemplateEngine(templateEngine);\n    ko.applyBindings();\n});\n","Magento_Ui/js/lib/knockout/template/observable_source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * Is being used by knockout template engine to store template to.\n */\ndefine([\n    'ko',\n    'uiClass'\n], function (ko, Class) {\n    'use strict';\n\n    return Class.extend({\n\n        /**\n         * Initializes templateName, _data, nodes properties.\n         *\n         * @param  {template} template - identifier of template\n         */\n        initialize: function (template) {\n            this.templateName = template;\n            this._data = {};\n            this.nodes = ko.observable([]);\n        },\n\n        /**\n         * Data setter. If only one arguments passed, returns corresponding value.\n         * Else, writes into it.\n         * @param  {String} key - key to write to or to read from\n         * @param  {*} value\n         * @return {*} - if 1 arg provided, Returns _data[key] property\n         */\n        data: function (key, value) {\n            if (arguments.length === 1) {\n                return this._data[key];\n            }\n\n            this._data[key] = value;\n        }\n    });\n});\n","Magento_Ui/js/lib/knockout/template/loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var licenseRegExp   = /<!--[\\s\\S]*?-->/,\n        defaultPlugin   = 'text',\n        defaultExt      = 'html';\n\n    /**\n     * Checks of provided string contains a file extension.\n     *\n     * @param {String} str - String to be checked.\n     * @returns {Boolean}\n     */\n    function hasFileExtension(str) {\n        return !!~str.indexOf('.') && !!str.split('.').pop();\n    }\n\n    /**\n     * Checks if provided string contains a requirejs's plugin reference.\n     *\n     * @param {String} str - String to be checked.\n     * @returns {Boolean}\n     */\n    function hasPlugin(str) {\n        return !!~str.indexOf('!');\n    }\n\n    /**\n     * Checks if provided string is a full path to the file.\n     *\n     * @param {String} str - String to be checked.\n     * @returns {Boolean}\n     */\n    function isFullPath(str) {\n        return !!~str.indexOf('://');\n    }\n\n    /**\n     * Removes license comment from the provided string.\n     *\n     * @param {String} content - String to be processed.\n     * @returns {String}\n     */\n    function removeLicense(content) {\n        return content.replace(licenseRegExp, function (match) {\n            return ~match.indexOf('/**') ? '' : match;\n        });\n    }\n\n    return {\n\n        /**\n         * Attempts to extract template by provided path from\n         * a DOM element and falls back to a file loading if\n         * none of the DOM nodes was found.\n         *\n         * @param {String} path - Path to the template or a DOM selector.\n         * @returns {jQueryPromise}\n         */\n        loadTemplate: function (path) {\n            var content = this.loadFromNode(path),\n                defer;\n\n            if (content) {\n                defer = $.Deferred();\n\n                defer.resolve(content);\n\n                return defer.promise();\n            }\n\n            return this.loadFromFile(path);\n        },\n\n        /**\n         * Loads template from external file by provided\n         * path, which will be preliminary formatted.\n         *\n         * @param {String} path - Path to the template.\n         * @returns {jQueryPromise}\n         */\n        loadFromFile: function (path) {\n            var loading = $.Deferred();\n\n            path = this.formatPath(path);\n\n            require([path], function (template) {\n                template = removeLicense(template);\n                loading.resolve(template);\n            }, function (err) {\n                loading.reject(err);\n            });\n\n            return loading.promise();\n        },\n\n        /**\n         * Attempts to extract content of a node found by provided selector.\n         *\n         * @param {String} selector - Node's selector (not necessary valid).\n         * @returns {String|Boolean} If specified node doesn't exists\n         *      'false' will be returned, otherwise returns node's content.\n         */\n        loadFromNode: function (selector) {\n            var node;\n\n            try {\n                node =\n                    document.getElementById(selector) ||\n                    document.querySelector(selector);\n\n                return node ? node.innerHTML : false;\n            } catch (e) {\n                return false;\n            }\n        },\n\n        /**\n         * Adds requirejs's plugin and file extension to\n         * to the provided string if it's necessary.\n         *\n         * @param {String} path - Path to be processed.\n         * @returns {String} Formatted path.\n         */\n        formatPath: function (path) {\n            var result = path;\n\n            if (!hasPlugin(path)) {\n                result = defaultPlugin + '!' + result;\n            }\n\n            if (isFullPath(path)) {\n                return result;\n            }\n\n            if (!hasFileExtension(path)) {\n                result += '.' + defaultExt;\n            }\n\n            return result.replace(/^([^\\/]+)/g, '$1/template');\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/template/engine.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'ko',\n    'underscore',\n    './observable_source',\n    './renderer',\n    '../../logger/console-logger'\n], function ($, ko, _, Source, renderer, consoleLogger) {\n    'use strict';\n\n    var RemoteTemplateEngine,\n        NativeTemplateEngine = ko.nativeTemplateEngine,\n        sources = {};\n\n    /**\n     * Remote template engine class. Is used to be able to load remote templates via knockout template binding.\n     */\n    RemoteTemplateEngine = function () {\n        // Instance reference for closure.\n        var engine = this,\n        // Decorate the builtin Knockout \"template\" binding to track synchronous template renders.\n        origUpdate = ko.bindingHandlers.template.update;\n\n        /**\n         * Counter to track the number of currently running render tasks (both synchronous and asynchronous).\n         * @type {Number}\n         * @private\n         */\n        this._rendersOutstanding = 0;\n\n        /**\n         * Use a jQuery object as an event bus (but any event emitter with on/off/emit methods could work)\n         * @type {jQuery}\n         * @private\n         */\n        this._events = $(this);\n\n        /**\n         * Rendered templates\n         * @type {Object}\n         * @private\n         */\n        this._templatesRendered = {};\n\n        /*eslint-disable no-unused-vars*/\n        /**\n         * Decorate update method\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         * @param {Object} allBindings\n         * @param {Object} viewModel\n         * @param {ko.bindingContext} bindingContext\n         * @returns {*}\n         */\n        ko.bindingHandlers.template.update = function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n            /*eslint-enable no-unused-vars*/\n            var options = ko.utils.peekObservable(valueAccessor()),\n                templateName,\n                isSync,\n                updated;\n\n            if (typeof options === 'object') {\n                if (options.templateEngine && options.templateEngine !== engine) {\n                    return origUpdate.apply(this, arguments);\n                }\n\n                if (!options.name) {\n                    consoleLogger.error('Could not find template name', options);\n                }\n                templateName = options.name;\n            } else if (typeof options === 'string') {\n                templateName = options;\n            } else {\n                consoleLogger.error('Could not build a template binding', options);\n            }\n            engine._trackRender(templateName);\n            isSync = engine._hasTemplateLoaded(templateName);\n            updated = origUpdate.apply(this, arguments);\n\n            if (isSync) {\n                engine._releaseRender(templateName, 'sync');\n            }\n\n            return updated;\n        };\n    };\n\n    /**\n     * Creates unique template identifier based on template name and it's extenders (optional)\n     * @param  {String} templateName\n     * @return {String} - unique template identifier\n     */\n    function createTemplateIdentifier(templateName) {\n        return templateName;\n    }\n\n    RemoteTemplateEngine.prototype = new NativeTemplateEngine;\n    RemoteTemplateEngine.prototype.constructor = RemoteTemplateEngine;\n\n    /**\n     * When an asynchronous render task begins, increment the internal counter for tracking when renders are complete.\n     * @private\n     */\n    RemoteTemplateEngine.prototype._trackRender = function (templateName) {\n        var rendersForTemplate = this._templatesRendered[templateName] !== undefined ?\n            this._templatesRendered[templateName] : 0;\n\n        this._rendersOutstanding++;\n        this._templatesRendered[templateName] = rendersForTemplate + 1;\n        this._resolveRenderWaits();\n    };\n\n    /**\n     * When an asynchronous render task ends, decrement the internal counter for tracking when renders are complete.\n     * @private\n     */\n    RemoteTemplateEngine.prototype._releaseRender = function (templateName) {\n        var rendersForTemplate = this._templatesRendered[templateName];\n\n        this._rendersOutstanding--;\n        this._templatesRendered[templateName] = rendersForTemplate - 1;\n        this._resolveRenderWaits();\n    };\n\n    /**\n     * Check to see if renders are complete and trigger events for listeners.\n     * @private\n     */\n    RemoteTemplateEngine.prototype._resolveRenderWaits = function () {\n        if (this._rendersOutstanding === 0) {\n            this._events.triggerHandler('finishrender');\n        }\n    };\n\n    /**\n     * Get a promise for the end of the current run of renders, both sync and async.\n     * @return {jQueryPromise} - promise that resolves when render completes\n     */\n    RemoteTemplateEngine.prototype.waitForFinishRender = function () {\n        var defer = $.Deferred();\n\n        this._events.one('finishrender', defer.resolve);\n\n        return defer.promise();\n    };\n\n    /**\n     * Returns true if this template has already been asynchronously loaded and will be synchronously rendered.\n     * @param {String} templateName\n     * @returns {Boolean}\n     * @private\n     */\n    RemoteTemplateEngine.prototype._hasTemplateLoaded = function (templateName) {\n        // Sources object will have cached template once makeTemplateSource has run\n        return sources.hasOwnProperty(templateName);\n    };\n\n    /**\n     * Overrided method of native knockout template engine.\n     * Caches template after it's unique name and renders in once.\n     * If template name is not typeof string, delegates work to knockout.templateSources.anonymousTemplate.\n     * @param  {*} template\n     * @param  {HTMLElement} templateDocument - document\n     * @param  {Object} options - options, passed to template binding\n     * @param  {ko.bindingContext} bindingContext\n     * @returns {TemplateSource} Object with methods 'nodes' and 'data'.\n     */\n    RemoteTemplateEngine.prototype.makeTemplateSource = function (template, templateDocument, options, bindingContext) {\n        var engine = this,\n            source,\n            templateId;\n\n        if (typeof template === 'string') {\n            templateId = createTemplateIdentifier(template);\n            source = sources[templateId];\n\n            if (!source) {\n                source = new Source(template);\n                source.requestedBy = bindingContext.$data.name;\n                sources[templateId] = source;\n\n                consoleLogger.info('templateStartLoading', {\n                    template: templateId,\n                    component: bindingContext.$data.name\n                });\n\n                renderer.render(template).then(function (rendered) {\n                    consoleLogger.info('templateLoadedFromServer', {\n                        template: templateId,\n                        component: bindingContext.$data.name\n                    });\n                    source.nodes(rendered);\n                    engine._releaseRender(templateId, 'async');\n                }).fail(function () {\n                    consoleLogger.error('templateLoadingFail', {\n                        template: templateId,\n                        component: bindingContext.$data.name\n                    });\n                });\n            }\n\n            if (source.requestedBy !== bindingContext.$data.name) {\n                consoleLogger.info('templateLoadedFromCache', {\n                    template: templateId,\n                    component: bindingContext.$data.name\n                });\n            }\n\n            return source;\n        } else if (template.nodeType === 1 || template.nodeType === 8) {\n            source = new ko.templateSources.anonymousTemplate(template);\n\n            return source;\n        }\n\n        throw new Error('Unknown template type: ' + template);\n    };\n\n    /**\n     * Overrided method of native knockout template engine.\n     * Should return array of html elements.\n     * @param  {TemplateSource} templateSource - object with methods 'nodes' and 'data'.\n     * @return {Array} - array of html elements\n     */\n    RemoteTemplateEngine.prototype.renderTemplateSource = function (templateSource) {\n        var nodes = templateSource.nodes();\n\n        return ko.utils.cloneNodes(nodes);\n    };\n\n    /**\n     * Overrided method of native knockout template engine.\n     * Created in order to invoke makeTemplateSource method with custom set of params.\n     * @param  {*} template - template identifier\n     * @param  {ko.bindingContext} bindingContext\n     * @param  {Object} options - options, passed to template binding\n     * @param  {HTMLElement} templateDocument - document\n     * @return {Array} - array of html elements\n     */\n    RemoteTemplateEngine.prototype.renderTemplate = function (template, bindingContext, options, templateDocument) {\n        var templateSource = this.makeTemplateSource(template, templateDocument, options, bindingContext);\n\n        return this.renderTemplateSource(templateSource);\n    };\n\n    return new RemoteTemplateEngine;\n});\n","Magento_Ui/js/lib/knockout/template/renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    './loader'\n], function ($, _, loader) {\n    'use strict';\n\n    var colonReg       = /\\\\:/g,\n        renderedTemplatePromises = {},\n        attributes     = {},\n        elements       = {},\n        globals        = [],\n        renderer,\n        preset;\n\n    renderer = {\n\n        /**\n         * Loads template by provided path and\n         * than converts it's content to html.\n         *\n         * @param {String} tmplPath - Path to the template.\n         * @returns {jQueryPromise}\n         * @alias getRendered\n         */\n        render: function (tmplPath) {\n            var cachedPromise = renderedTemplatePromises[tmplPath];\n\n            if (!cachedPromise) {\n                cachedPromise = renderedTemplatePromises[tmplPath] = loader\n                    .loadTemplate(tmplPath)\n                    .then(renderer.parseTemplate);\n            }\n\n            return cachedPromise;\n        },\n\n        /**\n         * @ignore\n         */\n        getRendered: function (tmplPath) {\n            return renderer.render(tmplPath);\n        },\n\n        /**\n         * Parses provided string as html content\n         * and returns an array of DOM elements.\n         *\n         * @param {String} html - String to be processed.\n         * @returns {Array}\n         */\n        parseTemplate: function (html) {\n            var fragment = document.createDocumentFragment();\n\n            $(fragment).append(html);\n\n            return renderer.normalize(fragment);\n        },\n\n        /**\n         * Processes custom attributes and nodes of provided DOM element.\n         *\n         * @param {HTMLElement} content - Element to be processed.\n         * @returns {Array} An array of content's child nodes.\n         */\n        normalize: function (content) {\n            globals.forEach(function (handler) {\n                handler(content);\n            });\n\n            return _.toArray(content.childNodes);\n        },\n\n        /**\n         * Adds new global content handler.\n         *\n         * @param {Function} handler - Function which will be invoked for\n         *      an every content passed to 'normalize' method.\n         * @returns {Renderer} Chainable.\n         */\n        addGlobal: function (handler) {\n            if (!_.contains(globals, handler)) {\n                globals.push(handler);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes specified global content handler.\n         *\n         * @param {Function} handler - Handler to be removed.\n         * @returns {Renderer} Chainable.\n         */\n        removeGlobal: function (handler) {\n            var index = globals.indexOf(handler);\n\n            if (~index) {\n                globals.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds new custom attribute handler.\n         *\n         * @param {String} id - Attribute identifier.\n         * @param {(Object|Function)} [config={}]\n         * @returns {Renderer} Chainable.\n         */\n        addAttribute: function (id, config) {\n            var data = {\n                name: id,\n                binding: id,\n                handler: renderer.handlers.attribute\n            };\n\n            if (_.isFunction(config)) {\n                data.handler = config;\n            } else if (_.isObject(config)) {\n                _.extend(data, config);\n            }\n\n            data.id = id;\n            attributes[id] = data;\n\n            return this;\n        },\n\n        /**\n         * Removes specified attribute handler.\n         *\n         * @param {String} id - Attribute identifier.\n         * @returns {Renderer} Chainable.\n         */\n        removeAttribute: function (id) {\n            delete attributes[id];\n\n            return this;\n        },\n\n        /**\n         * Adds new custom node handler.\n         *\n         * @param {String} id - Node identifier.\n         * @param {(Object|Function)} [config={}]\n         * @returns {Renderer} Chainable.\n         */\n        addNode: function (id, config) {\n            var data = {\n                name: id,\n                binding: id,\n                handler: renderer.handlers.node\n            };\n\n            if (_.isFunction(config)) {\n                data.handler = config;\n            } else if (_.isObject(config)) {\n                _.extend(data, config);\n            }\n\n            data.id = id;\n            elements[id] = data;\n\n            return this;\n        },\n\n        /**\n         * Removes specified custom node handler.\n         *\n         * @param {String} id - Node identifier.\n         * @returns {Renderer} Chainable.\n         */\n        removeNode: function (id) {\n            delete elements[id];\n\n            return this;\n        },\n\n        /**\n         * Checks if provided DOM element is a custom node.\n         *\n         * @param {HTMLElement} node - Node to be checked.\n         * @returns {Boolean}\n         */\n        isCustomNode: function (node) {\n            return _.some(elements, function (elem) {\n                return elem.name.toUpperCase() === node.tagName;\n            });\n        },\n\n        /**\n         * Processes custom attributes of a content's child nodes.\n         *\n         * @param {HTMLElement} content - DOM element to be processed.\n         */\n        processAttributes: function (content) {\n            var repeat;\n\n            repeat = _.some(attributes, function (attr) {\n                var attrName = attr.name,\n                    nodes    = content.querySelectorAll('[' + attrName + ']'),\n                    handler  = attr.handler;\n\n                return _.toArray(nodes).some(function (node) {\n                    var data = node.getAttribute(attrName);\n\n                    return handler(node, data, attr) === true;\n                });\n            });\n\n            if (repeat) {\n                renderer.processAttributes(content);\n            }\n        },\n\n        /**\n         * Processes custom nodes of a provided content.\n         *\n         * @param {HTMLElement} content - DOM element to be processed.\n         */\n        processNodes: function (content) {\n            var repeat;\n\n            repeat = _.some(elements, function (element) {\n                var nodes   = content.querySelectorAll(element.name),\n                    handler = element.handler;\n\n                return _.toArray(nodes).some(function (node) {\n                    var data = node.getAttribute('args');\n\n                    return handler(node, data, element) === true;\n                });\n            });\n\n            if (repeat) {\n                renderer.processNodes(content);\n            }\n        },\n\n        /**\n         * Wraps provided string in curly braces if it's necessary.\n         *\n         * @param {String} args - String to be wrapped.\n         * @returns {String} Wrapped string.\n         */\n        wrapArgs: function (args) {\n            if (~args.indexOf('\\\\:')) {\n                args = args.replace(colonReg, ':');\n            } else if (~args.indexOf(':') && !~args.indexOf('}')) {\n                args = '{' + args + '}';\n            }\n\n            return args;\n        },\n\n        /**\n         * Wraps child nodes of provided DOM element\n         * with knockout's comment tag.\n         *\n         * @param {HTMLElement} node - Node whose children should be wrapped.\n         * @param {String} binding - Name of the binding for the opener comment tag.\n         * @param {String} data - Data associated with a binding.\n         *\n         * @example\n         *      <div id=\"example\"><span/></div>\n         *      wrapChildren(document.getElementById('example'), 'foreach', 'data');\n         *      =>\n         *      <div id=\"example\">\n         *      <!-- ko foreach: data -->\n         *          <span></span>\n         *      <!-- /ko -->\n         *      </div>\n         */\n        wrapChildren: function (node, binding, data) {\n            var tag = this.createComment(binding, data),\n                $node = $(node);\n\n            $node.prepend(tag.open);\n            $node.append(tag.close);\n        },\n\n        /**\n         * Wraps specified node with knockout's comment tag.\n         *\n         * @param {HTMLElement} node - Node to be wrapped.\n         * @param {String} binding - Name of the binding for the opener comment tag.\n         * @param {String} data - Data associated with a binding.\n         *\n         * @example\n         *      <div id=\"example\"></div>\n         *      wrapNode(document.getElementById('example'), 'foreach', 'data');\n         *      =>\n         *      <!-- ko foreach: data -->\n         *          <div id=\"example\"></div>\n         *      <!-- /ko -->\n         */\n        wrapNode: function (node, binding, data) {\n            var tag = this.createComment(binding, data),\n                $node = $(node);\n\n            $node.before(tag.open);\n            $node.after(tag.close);\n        },\n\n        /**\n         * Creates knockouts' comment tag for the provided binding.\n         *\n         * @param {String} binding - Name of the binding.\n         * @param {String} data - Data associated with a binding.\n         * @returns {Object} Object with an open and close comment elements.\n         */\n        createComment: function (binding, data) {\n            return {\n                open: document.createComment(' ko ' + binding + ': ' + data + ' '),\n                close: document.createComment(' /ko ')\n            };\n        }\n    };\n\n    renderer.handlers = {\n\n        /**\n         * Basic node handler. Replaces custom nodes\n         * with a corresponding knockout's comment tag.\n         *\n         * @param {HTMLElement} node - Node to be processed.\n         * @param {String} data\n         * @param {Object} element\n         * @returns {Boolean} True\n         *\n         * @example Sample syntaxes conversions.\n         *      <with args=\"model\">\n         *          <span/>\n         *      </with>\n         *      =>\n         *      <!-- ko with: model-->\n         *          <span/>\n         *      <!-- /ko -->\n         */\n        node: function (node, data, element) {\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapNode(node, element.binding, data);\n            $(node).replaceWith(node.childNodes);\n\n            return true;\n        },\n\n        /**\n         * Base attribute handler. Replaces custom attributes with\n         * a corresponding knockouts' data binding.\n         *\n         * @param {HTMLElement} node - Node to be processed.\n         * @param {String} data - Data associated with a binding.\n         * @param {Object} attr - Attribute definition.\n         *\n         * @example Sample syntaxes conversions.\n         *      <div text=\"label\"></div>\n         *      =>\n         *      <div data-bind=\"text: label\"></div>\n         */\n        attribute: function (node, data, attr) {\n            data = renderer.wrapArgs(data);\n\n            renderer.bindings.add(node, attr.binding, data);\n            node.removeAttribute(attr.name);\n        },\n\n        /**\n         * Wraps provided node with a knockouts' comment tag.\n         *\n         * @param {HTMLElement} node - Node that will be wrapped.\n         * @param {String} data - Data associated with a binding.\n         * @param {Object} attr - Attribute definition.\n         *\n         * @example\n         *      <div outereach=\"data\" class=\"test\"></div>\n         *      =>\n         *      <!-- ko foreach: data -->\n         *          <div class=\"test\"></div>\n         *      <!-- /ko -->\n         */\n        wrapAttribute: function (node, data, attr) {\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapNode(node, attr.binding, data);\n            node.removeAttribute(attr.name);\n        }\n    };\n\n    renderer.bindings = {\n\n        /**\n         * Appends binding string to the current\n         * 'data-bind' attribute of provided node.\n         *\n         * @param {HTMLElement} node - DOM element whose 'data-bind' attribute will be extended.\n         * @param {String} name - Name of a binding.\n         * @param {String} data - Data associated with the binding.\n         */\n        add: function (node, name, data) {\n            var bindings = this.get(node);\n\n            if (bindings) {\n                bindings += ', ';\n            }\n\n            bindings += name;\n\n            if (data) {\n                bindings += ': ' + data;\n            }\n\n            this.set(node, bindings);\n        },\n\n        /**\n         * Extracts value of a 'data-bind' attribute from provided node.\n         *\n         * @param {HTMLElement} node - Node whose attribute to be extracted.\n         * @returns {String}\n         */\n        get: function (node) {\n            return node.getAttribute('data-bind') || '';\n        },\n\n        /**\n         * Sets 'data-bind' attribute of the specified node\n         * to the provided value.\n         *\n         * @param {HTMLElement} node - Node whose attribute will be altered.\n         * @param {String} bindings - New value of 'data-bind' attribute.\n         */\n        set: function (node, bindings) {\n            node.setAttribute('data-bind', bindings);\n        }\n    };\n\n    renderer\n        .addGlobal(renderer.processAttributes)\n        .addGlobal(renderer.processNodes);\n\n    /**\n     * Collection of default binding conversions.\n     */\n    preset = {\n        nodes: _.object([\n            'if',\n            'text',\n            'with',\n            'scope',\n            'ifnot',\n            'foreach',\n            'component'\n        ], Array.prototype),\n        attributes: _.object([\n            'css',\n            'attr',\n            'html',\n            'with',\n            'text',\n            'click',\n            'event',\n            'submit',\n            'enable',\n            'disable',\n            'options',\n            'visible',\n            'template',\n            'hasFocus',\n            'textInput',\n            'component',\n            'uniqueName',\n            'optionsText',\n            'optionsValue',\n            'checkedValue',\n            'selectedOptions'\n        ], Array.prototype)\n    };\n\n    _.extend(preset.attributes, {\n        if: renderer.handlers.wrapAttribute,\n        ifnot: renderer.handlers.wrapAttribute,\n        innerif: {\n            binding: 'if'\n        },\n        innerifnot: {\n            binding: 'ifnot'\n        },\n        outereach: {\n            binding: 'foreach',\n            handler: renderer.handlers.wrapAttribute\n        },\n        foreach: {\n            name: 'each'\n        },\n        value: {\n            name: 'ko-value'\n        },\n        style: {\n            name: 'ko-style'\n        },\n        checked: {\n            name: 'ko-checked'\n        },\n        disabled: {\n            name: 'ko-disabled',\n            binding: 'disable'\n        },\n        focused: {\n            name: 'ko-focused',\n            binding: 'hasFocus'\n        },\n\n        /**\n         * Custom 'render' attribute handler function. Wraps child elements\n         * of a node with knockout's 'ko template:' comment tag.\n         *\n         * @param {HTMLElement} node - Element to be processed.\n         * @param {String} data - Data specified in 'render' attribute of a node.\n         */\n        render: function (node, data) {\n            data = data || 'getTemplate()';\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapChildren(node, 'template', data);\n            node.removeAttribute('render');\n        }\n    });\n\n    _.extend(preset.nodes, {\n        foreach: {\n            name: 'each'\n        },\n\n        /**\n         * Custom 'render' node handler function.\n         * Replaces node with knockout's 'ko template:' comment tag.\n         *\n         * @param {HTMLElement} node - Element to be processed.\n         * @param {String} data - Data specified in 'args' attribute of a node.\n         */\n        render: function (node, data) {\n            data = data || 'getTemplate()';\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapNode(node, 'template', data);\n            $(node).replaceWith(node.childNodes);\n        }\n    });\n\n    _.each(preset.attributes, function (data, id) {\n        renderer.addAttribute(id, data);\n    });\n\n    _.each(preset.nodes, function (data, id) {\n        renderer.addNode(id, data);\n    });\n\n    return renderer;\n});\n","Magento_Ui/js/lib/knockout/bindings/keyboard.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.keyboard = {\n\n        /**\n         * Attaches keypress handlers to element\n         * @param {HTMLElement} el - Element, that binding is applied to\n         * @param {Function} valueAccessor - Function that returns value, passed to binding\n         * @param  {Object} allBindings - all bindings object\n         * @param  {Object} viewModel - reference to viewmodel\n         */\n        init: function (el, valueAccessor, allBindings, viewModel) {\n            var map = valueAccessor();\n\n            ko.utils.registerEventHandler(el, 'keyup', function (e) {\n                var callback = map[e.keyCode];\n\n                if (callback) {\n                    return callback.call(viewModel, e);\n                }\n            });\n        }\n    };\n\n    renderer.addAttribute('keyboard');\n});\n","Magento_Ui/js/lib/knockout/bindings/bootstrap.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function (require) {\n    'use strict';\n\n    var renderer = require('../template/renderer');\n\n    renderer.addAttribute('repeat', renderer.handlers.wrapAttribute);\n\n    renderer.addAttribute('outerfasteach', {\n        binding: 'fastForEach',\n        handler: renderer.handlers.wrapAttribute\n    });\n\n    renderer\n        .addNode('repeat')\n        .addNode('fastForEach');\n\n    return {\n        resizable:      require('./resizable'),\n        i18n:           require('./i18n'),\n        scope:          require('./scope'),\n        range:          require('./range'),\n        mageInit:       require('./mage-init'),\n        keyboard:       require('./keyboard'),\n        optgroup:       require('./optgroup'),\n        afterRender:     require('./after-render'),\n        autoselect:     require('./autoselect'),\n        datepicker:     require('./datepicker'),\n        outerClick:     require('./outer_click'),\n        fadeVisible:    require('./fadeVisible'),\n        collapsible:    require('./collapsible'),\n        staticChecked:  require('./staticChecked'),\n        simpleChecked:  require('./simple-checked'),\n        bindHtml:       require('./bind-html'),\n        tooltip:        require('./tooltip'),\n        repeat:         require('knockoutjs/knockout-repeat'),\n        fastForEach:    require('knockoutjs/knockout-fast-foreach'),\n        colorPicker:    require('./color-picker')\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/datepicker.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Creates datepicker binding and registers in to ko.bindingHandlers object */\ndefine([\n    'ko',\n    'underscore',\n    'jquery',\n    'mage/translate',\n    'mage/calendar',\n    'moment',\n    'mageUtils'\n], function (ko, _, $, $t, calendar, moment, utils) {\n    'use strict';\n\n    var defaults = {\n        dateFormat: 'mm\\/dd\\/yyyy',\n        showsTime: false,\n        timeFormat: null,\n        buttonImage: null,\n        buttonImageOnly: null,\n        buttonText: $t('Select Date')\n    };\n\n    ko.bindingHandlers.datepicker = {\n        /**\n         * Initializes calendar widget on element and stores it's value to observable property.\n         * Datepicker binding takes either observable property or object\n         *  { storage: {ko.observable}, options: {Object} }.\n         * For more info about options take a look at \"mage/calendar\" and jquery.ui.datepicker widget.\n         * @param {HTMLElement} el - Element, that binding is applied to\n         * @param {Function} valueAccessor - Function that returns value, passed to binding\n         */\n        init: function (el, valueAccessor) {\n            var config = valueAccessor(),\n                observable,\n                options = {};\n\n            _.extend(options, defaults);\n\n            if (typeof config === 'object') {\n                observable = config.storage;\n                _.extend(options, config.options);\n            } else {\n                observable = config;\n            }\n\n            $(el).calendar(options);\n\n            ko.utils.registerEventHandler(el, 'change', function () {\n                observable(this.value);\n            });\n        },\n\n        /**\n         * Update calendar widget on element and stores it's value to observable property.\n         * Datepicker binding takes either observable property or object\n         *  { storage: {ko.observable}, options: {Object} }.\n         * @param {HTMLElement} element - Element, that binding is applied to\n         * @param {Function} valueAccessor - Function that returns value, passed to binding\n         */\n        update: function (element, valueAccessor) {\n            var config = valueAccessor(),\n                observable,\n                options = {},\n                newVal;\n\n            _.extend(options, defaults);\n\n            if (typeof config === 'object') {\n                observable = config.storage;\n                _.extend(options, config.options);\n            } else {\n                observable = config;\n            }\n\n            if (_.isEmpty(observable())) {\n                if ($(element).datepicker('getDate')) {\n                    $(element).datepicker('setDate', null);\n                    $(element).blur();\n                }\n            } else {\n                newVal = moment(\n                    observable(),\n                    utils.convertToMomentFormat(\n                        options.dateFormat + (options.showsTime ? ' ' + options.timeFormat : '')\n                    )\n                ).toDate();\n\n                if ($(element).datepicker('getDate') == null ||\n                    newVal.valueOf() !== $(element).datepicker('getDate').valueOf()\n                ) {\n                    $(element).datepicker('setDate', newVal);\n                    $(element).blur();\n                }\n            }\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/range.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    '../template/renderer',\n    'jquery-ui-modules/slider'\n], function (ko, $, _, renderer) {\n    'use strict';\n\n    var isTouchDevice = !_.isUndefined(document.ontouchstart),\n        sliderFn = 'slider';\n\n    ko.bindingHandlers.range = {\n\n        /**\n         * Initializes binding and a slider update.\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         */\n        init: function (element, valueAccessor) {\n            var config  = valueAccessor(),\n                value   = config.value;\n\n            _.extend(config, {\n                value: value(),\n\n                /**\n                 * Callback which is being called when sliders' value changes.\n                 *\n                 * @param {Event} event\n                 * @param {Object} ui\n                 */\n                slide: function (event, ui) {\n                    value(ui.value);\n                }\n            });\n\n            $(element)[sliderFn](config);\n        },\n\n        /**\n         * Updates sliders' plugin configuration.\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         */\n        update: function (element, valueAccessor) {\n            var config = valueAccessor();\n\n            config.value = ko.unwrap(config.value);\n\n            $(element)[sliderFn]('option', config);\n        }\n    };\n\n    renderer.addAttribute('range');\n\n    if (!isTouchDevice) {\n        return;\n    }\n\n    $.widget('mage.touchSlider', $.ui.slider, {\n\n        /**\n         * Creates instance of widget.\n         *\n         * @override\n         */\n        _create: function () {\n            _.bindAll(\n                this,\n                '_mouseDown',\n                '_mouseMove',\n                '_onTouchEnd'\n            );\n\n            return this._superApply(arguments);\n        },\n\n        /**\n         * Initializes mouse events on element.\n         * @override\n         */\n        _mouseInit: function () {\n            var result = this._superApply(arguments);\n\n            this.element\n                .off('mousedown.' + this.widgetName)\n                .on('touchstart.' + this.widgetName, this._mouseDown);\n\n            return result;\n        },\n\n        /**\n         * Elements' 'mousedown' event handler polyfill.\n         * @override\n         */\n        _mouseDown: function (event) {\n            var prevDelegate = this._mouseMoveDelegate,\n                result;\n\n            event = this._touchToMouse(event);\n            result = this._super(event);\n\n            if (prevDelegate === this._mouseMoveDelegate) {\n                return result;\n            }\n\n            $(document)\n                .off('mousemove.' + this.widgetName)\n                .off('mouseup.' + this.widgetName);\n\n            $(document)\n                .on('touchmove.' + this.widgetName, this._mouseMove)\n                .on('touchend.' + this.widgetName, this._onTouchEnd)\n                .on('tochleave.' + this.widgetName, this._onTouchEnd);\n\n            return result;\n        },\n\n        /**\n         * Documents' 'mousemove' event handler polyfill.\n         *\n         * @override\n         * @param {Event} event - Touch event object.\n         */\n        _mouseMove: function (event) {\n            event = this._touchToMouse(event);\n\n            return this._super(event);\n        },\n\n        /**\n         * Documents' 'touchend' event handler.\n         */\n        _onTouchEnd: function (event) {\n            $(document).trigger('mouseup');\n\n            return this._mouseUp(event);\n        },\n\n        /**\n         * Removes previously assigned touch handlers.\n         *\n         * @override\n         */\n        _mouseUp: function () {\n            this._removeTouchHandlers();\n\n            return this._superApply(arguments);\n        },\n\n        /**\n         * Removes previously assigned touch handlers.\n         *\n         * @override\n         */\n        _mouseDestroy: function () {\n            this._removeTouchHandlers();\n\n            return this._superApply(arguments);\n        },\n\n        /**\n         * Removes touch events from document object.\n         */\n        _removeTouchHandlers: function () {\n            $(document)\n                .off('touchmove.' + this.widgetName)\n                .off('touchend.' + this.widgetName)\n                .off('touchleave.' + this.widgetName);\n        },\n\n        /**\n         * Adds properties to the touch event to mimic mouse event.\n         *\n         * @param {Event} event - Touch event object.\n         * @returns {Event}\n         */\n        _touchToMouse: function (event) {\n            var orig = event.originalEvent,\n                touch = orig.touches[0];\n\n            return _.extend(event, {\n                which:      1,\n                pageX:      touch.pageX,\n                pageY:      touch.pageY,\n                clientX:    touch.clientX,\n                clientY:    touch.clientY,\n                screenX:    touch.screenX,\n                screenY:    touch.screenY\n            });\n        }\n    });\n\n    sliderFn = 'touchSlider';\n});\n","Magento_Ui/js/lib/knockout/bindings/autoselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    '../template/renderer'\n], function (ko, $, renderer) {\n    'use strict';\n\n    /**\n     * 'Focus' event handler.\n     *\n     * @param {EventObject} e\n     */\n    function onFocus(e) {\n        e.target.select();\n    }\n\n    ko.bindingHandlers.autoselect = {\n\n        /**\n         * Adds event handler which automatically\n         * selects inputs' element text when field gets focused.\n         */\n        init: function (element, valueAccessor) {\n            var enabled = ko.unwrap(valueAccessor());\n\n            if (enabled !== false) {\n                $(element).on('focus', onFocus);\n            }\n        }\n    };\n\n    renderer.addAttribute('autoselect');\n});\n","Magento_Ui/js/lib/knockout/bindings/scope.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Creates scope binding and registers in to ko.bindingHandlers object */\ndefine([\n    'ko',\n    'uiRegistry',\n    'mage/translate',\n    '../template/renderer',\n    'jquery',\n    '../../logger/console-logger'\n], function (ko, registry, $t, renderer, $, consoleLogger) {\n    'use strict';\n\n    /**\n     * Creates child context with passed component param as $data. Extends context with $t helper.\n     * Applies bindings to descendant nodes.\n     * @param {HTMLElement} el - element to apply bindings to.\n     * @param {ko.bindingContext} bindingContext - instance of ko.bindingContext, passed to binding initially.\n     * @param {Promise} promise - instance of jQuery promise\n     * @param {Object} component - component instance to attach to new context\n     */\n    function applyComponents(el, bindingContext, promise, component) {\n        promise.resolve();\n        component = bindingContext.createChildContext(component);\n\n        ko.utils.extend(component, {\n            $t: $t\n        });\n\n        ko.utils.arrayForEach(el.childNodes, ko.cleanNode);\n\n        ko.applyBindingsToDescendants(component, el);\n    }\n\n    ko.bindingHandlers.scope = {\n\n        /**\n         * Scope binding's init method.\n         * @returns {Object} - Knockout declaration for it to let binding control descendants.\n         */\n        init: function () {\n            return {\n                controlsDescendantBindings: true\n            };\n        },\n\n        /**\n         * Reads params passed to binding, parses component declarations.\n         * Fetches for those found and attaches them to the new context.\n         * @param {HTMLElement} el - Element to apply bindings to.\n         * @param {Function} valueAccessor - Function that returns value, passed to binding.\n         * @param {Object} allBindings - Object, which represents all bindings applied to element.\n         * @param {Object} viewModel - Object, which represents view model binded to el.\n         * @param {ko.bindingContext} bindingContext - Instance of ko.bindingContext, passed to binding initially.\n         */\n        update: function (el, valueAccessor, allBindings, viewModel, bindingContext) {\n            var component = valueAccessor(),\n                promise = $.Deferred(),\n                apply = applyComponents.bind(this, el, bindingContext, promise),\n                loggerUtils = consoleLogger.utils;\n\n            if (typeof component === 'string') {\n                loggerUtils.asyncLog(\n                    promise,\n                    {\n                        data: {\n                            component: component\n                        },\n                        messages: loggerUtils.createMessages(\n                            'requestingComponent',\n                            'requestingComponentIsLoaded',\n                            'requestingComponentIsFailed'\n                        )\n                    }\n                );\n\n                registry.get(component, apply);\n            } else if (typeof component === 'function') {\n                component(apply);\n            }\n        }\n    };\n\n    ko.virtualElements.allowedBindings.scope = true;\n\n    renderer\n        .addNode('scope')\n        .addAttribute('scope', {\n            name: 'ko-scope'\n        });\n});\n","Magento_Ui/js/lib/knockout/bindings/optgroup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'mageUtils'\n    ], function (ko, utils) {\n    'use strict';\n\n    var captionPlaceholder = {},\n        optgroupTmpl = '<optgroup label=\"${ $.label }\"></optgroup>',\n        nbspRe = /&nbsp;/g,\n        optionsText,\n        optionsValue,\n        optionTitle;\n\n    ko.bindingHandlers.optgroup = {\n        /**\n         * @param {*} element\n         * @returns {Object}\n         */\n        init: function (element) {\n            if (ko.utils.tagNameLower(element) !== 'select') {\n                throw new Error('options binding applies only to SELECT elements');\n            }\n\n            // Remove all existing <option>s.\n            while (element.length > 0) {\n                element.remove(0);\n            }\n\n            // Ensures that the binding processor doesn't try to bind the options\n            return {\n                'controlsDescendantBindings': true\n            };\n        },\n\n        /**\n         * @param {*} element\n         * @param {*} valueAccessor\n         * @param {*} allBindings\n         */\n        update: function (element, valueAccessor, allBindings) {\n            var selectWasPreviouslyEmpty = element.length === 0,\n                previousScrollTop = !selectWasPreviouslyEmpty && element.multiple ? element.scrollTop : null,\n                includeDestroyed = allBindings.get('optionsIncludeDestroyed'),\n                arrayToDomNodeChildrenOptions = {},\n                captionValue,\n                unwrappedArray = ko.utils.unwrapObservable(valueAccessor()),\n                filteredArray,\n                previousSelectedValues,\n                itemUpdate = false,\n                callback = setSelectionCallback,//eslint-disable-line no-use-before-define\n                nestedOptionsLevel = -1;\n\n            optionsText = ko.utils.unwrapObservable(allBindings.get('optionsText')) || 'text';\n            optionsValue = ko.utils.unwrapObservable(allBindings.get('optionsValue')) || 'value';\n            optionTitle = optionsText + 'title';\n\n            if (element.multiple) {\n                previousSelectedValues = ko.utils.arrayMap(\n                    selectedOptions(),//eslint-disable-line no-use-before-define\n                    ko.selectExtensions.readValue\n                );\n            } else {\n                previousSelectedValues = element.selectedIndex >= 0 ?\n                    [ko.selectExtensions.readValue(element.options[element.selectedIndex])] :\n                    [];\n            }\n\n            if (unwrappedArray) {\n                if (typeof unwrappedArray.length === 'undefined') { // Coerce single value into array\n                    unwrappedArray = [unwrappedArray];\n                }\n\n                // Filter out any entries marked as destroyed\n                filteredArray = ko.utils.arrayFilter(unwrappedArray, function (item) {\n                    if (item && !item.label) {\n                        return false;\n                    }\n\n                    return includeDestroyed ||\n                        item === undefined ||\n                        item === null ||\n                        !ko.utils.unwrapObservable(item._destroy);\n                });\n                filteredArray.map(recursivePathBuilder, null);//eslint-disable-line no-use-before-define\n            }\n\n            /**\n             * @param {*} option\n             */\n            arrayToDomNodeChildrenOptions.beforeRemove = function (option) {\n                element.removeChild(option);\n            };\n\n            if (allBindings.has('optionsAfterRender')) {\n\n                /**\n                 * @param {*} arrayEntry\n                 * @param {*} newOptions\n                 */\n                callback = function (arrayEntry, newOptions) {\n                    setSelectionCallback(arrayEntry, newOptions);//eslint-disable-line no-use-before-define\n                    ko.dependencyDetection.ignore(\n                        allBindings.get('optionsAfterRender'),\n                        null,\n                        [newOptions[0],\n                        arrayEntry !== captionPlaceholder ? arrayEntry : undefined]\n                    );\n                };\n            }\n\n            filteredArray = formatOptions(filteredArray);//eslint-disable-line no-use-before-define\n            ko.utils.setDomNodeChildrenFromArrayMapping(\n                element,\n                filteredArray,\n                optionNodeFromArray,//eslint-disable-line no-use-before-define\n                arrayToDomNodeChildrenOptions,\n                callback\n            );\n\n            ko.dependencyDetection.ignore(function () {\n                var selectionChanged;\n\n                if (allBindings.get('valueAllowUnset') && allBindings.has('value')) {\n                    // The model value is authoritative, so make sure its value is the one selected\n                    ko.selectExtensions.writeValue(\n                        element,\n                        ko.utils.unwrapObservable(allBindings.get('value')),\n                        true /* allowUnset */\n                    );\n                } else {\n                    // Determine if the selection has changed as a result of updating the options list\n                    if (element.multiple) {\n                        // For a multiple-select box, compare the new selection count to the previous one\n                        // But if nothing was selected before, the selection can't have changed\n                        selectionChanged = previousSelectedValues.length &&\n                            selectedOptions().length < //eslint-disable-line no-use-before-define\n                            previousSelectedValues.length;\n                    } else {\n                        // For a single-select box, compare the current value to the previous value\n                        // But if nothing was selected before or nothing is selected now,\n                        // just look for a change in selection\n                        selectionChanged = previousSelectedValues.length && element.selectedIndex >= 0 ?\n                            ko.selectExtensions.readValue(element.options[element.selectedIndex]) !==\n                            previousSelectedValues[0] : previousSelectedValues.length || element.selectedIndex >= 0;\n                    }\n\n                    // Ensure consistency between model value and selected option.\n                    // If the dropdown was changed so that selection is no longer the same,\n                    // notify the value or selectedOptions binding.\n                    if (selectionChanged) {\n                        ko.utils.triggerEvent(element, 'change');\n                    }\n                }\n            });\n\n            /*eslint-enable max-len, no-use-before-define*/\n\n            if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20) {\n                element.scrollTop = previousScrollTop;\n            }\n\n            /**\n             * @returns {*}\n             */\n            function selectedOptions() {\n                return ko.utils.arrayFilter(element.options, function (node) {\n                    return node.selected;\n                });\n            }\n\n            /**\n             * @param {*} object\n             * @param {*} predicate\n             * @param {*} defaultValue\n             * @returns {*}\n             */\n            function applyToObject(object, predicate, defaultValue) {\n                var predicateType = typeof predicate;\n\n                if (predicateType === 'function') {   // run it against the data value\n                    return predicate(object);\n                } else if (predicateType === 'string') { // treat it as a property name on the data value\n                    return object[predicate];\n                }\n\n                return defaultValue;\n            }\n\n            /**\n             * @param {*} obj\n             */\n            function recursivePathBuilder(obj) {\n\n                obj[optionTitle] = (this && this[optionTitle] ? this[optionTitle] + '/' : '') + obj[optionsText].trim();\n\n                if (Array.isArray(obj[optionsValue])) {\n                    obj[optionsValue].map(recursivePathBuilder, obj);\n                }\n            }\n\n            /**\n             * @param {Array} arrayEntry\n             * @param {*} oldOptions\n             * @returns {*[]}\n             */\n            function optionNodeFromArray(arrayEntry, oldOptions) {\n                var option;\n\n                if (oldOptions.length) {\n                    previousSelectedValues = oldOptions[0].selected ?\n                        [ko.selectExtensions.readValue(oldOptions[0])] : [];\n                    itemUpdate = true;\n                }\n\n                if (arrayEntry === captionPlaceholder) { // empty value, label === caption\n                    option = element.ownerDocument.createElement('option');\n                    ko.utils.setTextContent(option, allBindings.get('optionsCaption'));\n                    ko.selectExtensions.writeValue(option, undefined);\n                } else if (typeof arrayEntry[optionsValue] === 'undefined') { // empty value === optgroup\n                    if (arrayEntry.__disableTmpl) {\n                        option = '<optgroup label=\"' + arrayEntry[optionsText] + '\"></optgroup>';\n                    } else {\n                        option = utils.template(optgroupTmpl, {\n                            label: arrayEntry[optionsText],\n                            title: arrayEntry[optionsText + 'title']\n                        });\n                    }\n                    option = ko.utils.parseHtmlFragment(option)[0];\n\n                } else {\n                    option = element.ownerDocument.createElement('option');\n                    option.setAttribute('data-title', arrayEntry[optionsText + 'title']);\n                    ko.selectExtensions.writeValue(option, arrayEntry[optionsValue]);\n                    ko.utils.setTextContent(option, arrayEntry[optionsText]);\n                }\n\n                return [option];\n            }\n\n            /**\n             * @param {*} newOptions\n             */\n            function setSelectionCallback(newOptions) {\n                var isSelected;\n\n                // IE6 doesn't like us to assign selection to OPTION nodes before they're added to the document.\n                // That's why we first added them without selection. Now it's time to set the selection.\n                if (previousSelectedValues.length) {\n                    isSelected = ko.utils.arrayIndexOf(\n                        previousSelectedValues,\n                        ko.selectExtensions.readValue(newOptions.value)\n                    ) >= 0;\n\n                    ko.utils.setOptionNodeSelectionState(newOptions.value, isSelected);\n\n                    // If this option was changed from being selected during a single-item update, notify the change\n                    if (itemUpdate && !isSelected) {\n                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, 'change']);\n                    }\n                }\n            }\n\n            /**\n             * @param {*} string\n             * @param {Number} times\n             * @returns {Array}\n             */\n            function strPad(string, times) {\n                return (new Array(times + 1)).join(string);\n            }\n\n            /**\n             * @param {*} options\n             * @returns {Array}\n             */\n            function formatOptions(options) {\n                var res = [];\n\n                nestedOptionsLevel++;\n\n                if (!nestedOptionsLevel) { // zero level\n                    // If caption is included, add it to the array\n                    if (allBindings.has('optionsCaption')) {\n                        captionValue = ko.utils.unwrapObservable(allBindings.get('optionsCaption'));\n                        // If caption value is null or undefined, don't show a caption\n                        if (//eslint-disable-line max-depth\n                            captionValue !== null &&\n                            captionValue !== undefined &&\n                            captionValue !== false\n                        ) {\n                            res.push(captionPlaceholder);\n                        }\n                    }\n                }\n\n                ko.utils.arrayForEach(options, function (option) {\n                    var value = applyToObject(option, optionsValue, option),\n                        label = applyToObject(option, optionsText, value) || '',\n                        disabled = applyToObject(option, 'disabled', false) || false,\n                        obj = {},\n                        space = '\\u2007\\u2007\\u2007';\n\n                    obj[optionTitle] = applyToObject(option, optionsText + 'title', value);\n\n                    if (disabled) {\n                        obj.disabled = disabled;\n                    }\n\n                    if (option.hasOwnProperty('__disableTmpl')) {\n                        obj.__disableTmpl = option.__disableTmpl;\n                    }\n\n                    label = label.replace(nbspRe, '').trim();\n\n                    if (Array.isArray(value)) {\n                        obj[optionsText] = strPad('&nbsp;', nestedOptionsLevel * 4) + label;\n                        res.push(obj);\n                        res = res.concat(formatOptions(value));\n                    } else {\n                        obj[optionsText] = strPad(space, nestedOptionsLevel * 2) + label;\n                        obj[optionsValue] = value;\n                        res.push(obj);\n                    }\n                });\n                nestedOptionsLevel--;\n\n                return res;\n            }\n        }\n    };\n    ko.bindingHandlers.selectedOptions.after.push('optgroup');\n});\n","Magento_Ui/js/lib/knockout/bindings/mage-init.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'mage/apply/main'\n], function (ko, _, mage) {\n    'use strict';\n\n    ko.bindingHandlers.mageInit = {\n        /**\n         * Initializes components assigned to HTML elements.\n         *\n         * @param {HTMLElement} el\n         * @param {Function} valueAccessor\n         */\n        init: function (el, valueAccessor) {\n            var data = valueAccessor();\n\n            _.each(data, function (config, component) {\n                mage.applyFor(el, config, component);\n            });\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/staticChecked.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.staticChecked = {\n        'after': ['value', 'attr'],\n\n        /**\n         * Implements same functionality as a standard 'checked' binding,\n         * but with a difference that it wont' change values array if\n         * value of DOM element changes.\n         */\n        init: function (element, valueAccessor, allBindings) {\n            var isCheckbox = element.type === 'checkbox',\n                isRadio = element.type === 'radio',\n                isValueArray,\n                oldElemValue,\n                useCheckedValue,\n                checkedValue,\n                updateModel,\n                updateView;\n\n            if (!isCheckbox && !isRadio) {\n                return;\n            }\n\n            checkedValue = ko.pureComputed(function () {\n                if (allBindings.has('checkedValue')) {\n                    return ko.utils.unwrapObservable(allBindings.get('checkedValue'));\n                } else if (allBindings.has('value')) {\n                    return ko.utils.unwrapObservable(allBindings.get('value'));\n                }\n\n                return element.value;\n            });\n\n            isValueArray = isCheckbox && ko.utils.unwrapObservable(valueAccessor()) instanceof Array;\n            oldElemValue = isValueArray ? checkedValue() : undefined;\n            useCheckedValue = isRadio || isValueArray;\n\n            /**\n             * Updates values array if it's necessary.\n             */\n            updateModel = function () {\n                var isChecked = element.checked,\n                    elemValue = useCheckedValue ? checkedValue() : isChecked,\n                    modelValue;\n\n                if (ko.computedContext.isInitial()) {\n                    return;\n                }\n\n                if (isRadio && !isChecked) {\n                    return;\n                }\n\n                modelValue = ko.dependencyDetection.ignore(valueAccessor);\n\n                if (isValueArray) {\n                    if (oldElemValue !== elemValue) {\n                        oldElemValue = elemValue;\n                    } else {\n                        ko.utils.addOrRemoveItem(modelValue, elemValue, isChecked);\n                    }\n                } else {\n                    ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'checked', elemValue, true);\n                }\n            };\n\n            /**\n             * Updates checkbox state.\n             */\n            updateView = function () {\n                var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n                if (isValueArray) {\n                    element.checked = ko.utils.arrayIndexOf(modelValue, checkedValue()) >= 0;\n                } else if (isCheckbox) {\n                    element.checked = modelValue;\n                } else {\n                    element.checked = checkedValue() === modelValue;\n                }\n            };\n\n            ko.computed(updateModel, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n\n            ko.utils.registerEventHandler(element, 'click', updateModel);\n\n            ko.computed(updateView, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n        }\n    };\n\n    ko.expressionRewriting._twoWayBindings.staticChecked = true;\n\n    renderer.addAttribute('staticChecked');\n});\n","Magento_Ui/js/lib/knockout/bindings/simple-checked.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.simpleChecked = {\n        'after': ['attr'],\n\n        /**\n         * Implements same functionality as a standard 'simpleChecked' binding,\n         * but with a difference that it wont' change values array if\n         * value of DOM element changes.\n         */\n        init: function (element, valueAccessor) {\n            var isCheckbox = element.type === 'checkbox',\n                isRadio = element.type === 'radio',\n                updateView,\n                updateModel;\n\n            if (!isCheckbox && !isRadio) {\n                return;\n            }\n\n            /**\n             * Updates checked observable\n             */\n            updateModel = function () {\n                var  modelValue = ko.dependencyDetection.ignore(valueAccessor),\n                    isChecked = element.checked;\n\n                if (ko.computedContext.isInitial()) {\n                    return;\n                }\n\n                if (modelValue.peek() === isChecked) {\n                    return;\n                }\n\n                if (isRadio && !isChecked) {\n                    return;\n                }\n\n                modelValue(isChecked);\n            };\n\n            /**\n             * Updates checkbox state\n             */\n            updateView = function () {\n                var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n                element.checked = !!modelValue;\n            };\n\n            ko.utils.registerEventHandler(element, 'change', updateModel);\n\n            ko.computed(updateModel, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n            ko.computed(updateView, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n        }\n    };\n\n    ko.expressionRewriting._twoWayBindings.simpleChecked = true;\n\n    renderer.addAttribute('simpleChecked');\n    renderer.addAttribute('simple-checked', {\n        binding: 'simpleChecked'\n    });\n});\n","Magento_Ui/js/lib/knockout/bindings/tooltip.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'underscore',\n    'mage/template',\n    'text!ui/template/tooltip/tooltip.html',\n    '../template/renderer'\n], function ($, ko, _, template, tooltipTmpl, renderer) {\n    'use strict';\n\n    var tooltip,\n        defaults,\n        positions,\n        transformProp,\n        checkedPositions = {},\n        iterator = 0,\n        previousTooltip,\n        tooltipData,\n        positionData = {},\n        tooltipsCollection = {},\n        isTouchDevice = (function () {\n            return 'ontouchstart' in document.documentElement;\n        })(),\n        CLICK_EVENT = (function () {\n            return isTouchDevice ? 'touchstart' : 'click';\n        })();\n\n    defaults = {\n        tooltipWrapper: '[data-tooltip=tooltip-wrapper]',\n        tooltipContentBlock: 'data-tooltip-content',\n        closeButtonClass: 'action-close',\n        tailClass: 'data-tooltip-tail',\n        action: 'hover',\n        delay: 300,\n        track: false,\n        step: 20,\n        position: 'top',\n        closeButton: false,\n        showed: false,\n        strict: true,\n        center: false,\n        closeOnScroll: true\n    };\n\n    tooltipData = {\n        tooltipClasses: '',\n        trigger: false,\n        timeout: 0,\n        element: false,\n        event: false,\n        targetElement: {},\n        showed: false,\n        currentID: 0\n    };\n\n    /**\n     * Polyfill for css transform\n     */\n    transformProp = (function () {\n        var style = document.createElement('div').style,\n            base = 'Transform',\n            vendors = ['webkit', 'moz', 'ms', 'o'],\n            vi = vendors.length,\n            property;\n\n        if (typeof style.transform !== 'undefined') {\n            return 'transform';\n        }\n\n        while (vi--) {\n            property = vendors[vi] + base;\n\n            if (typeof style[property] !== 'undefined') {\n                return property;\n            }\n        }\n    })();\n\n    positions = {\n\n        /*eslint max-depth: [0, 0]*/\n\n        map: {\n            horizontal: {\n                s: 'w',\n                p: 'left'\n            },\n            vertical: {\n                s: 'h',\n                p: 'top'\n            }\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        top: function (s) {\n            return positions._topLeftChecker(s, positions.map, 'vertical', '_bottom', 'top', 'right');\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        left: function (s) {\n            return positions._topLeftChecker(s, positions.map, 'horizontal', '_right', 'left', 'top');\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        bottom: function (s) {\n            return positions._bottomRightChecker(s, positions.map, 'vertical', '_top', 'bottom', 'left');\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        right: function (s) {\n            return positions._bottomRightChecker(s, positions.map, 'horizontal', '_left', 'right', 'bottom');\n        },\n\n        /**\n         * Check can tooltip setted on current position or not. If can't setted - delegate call.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @param {String} className - class whats should be setted to tooltip\n         * @param {String} side - parent method name\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _topLeftChecker: function (s, map, direction, className, side, delegate) {\n            var result = {\n                    position: {}\n                },\n                config = tooltip.getTooltip(tooltipData.currentID),\n                startPosition = !config.strict ? s.eventPosition : s.elementPosition,\n                changedDirection;\n\n            checkedPositions[side] = true;\n\n            if (\n                startPosition[map[direction].p] - s.tooltipSize[map[direction].s] - config.step >\n                s.scrollPosition[map[direction].p]\n            ) {\n                result.position[map[direction].p] = startPosition[map[direction].p] - s.tooltipSize[map[direction].s] -\n                    config.step;\n                result.className = className;\n                result.side = side;\n                changedDirection = direction === 'vertical' ? 'horizontal' : 'vertical';\n                result = positions._normalize(s, result, config, delegate, map, changedDirection);\n            } else if (!checkedPositions[delegate]) {\n                result = positions[delegate].apply(null, arguments);\n            } else {\n                result = positions.positionCenter(s, result);\n            }\n\n            return result;\n        },\n\n        /**\n         * Check can tooltip setted on current position or not. If can't setted - delegate call.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @param {String} className - class whats should be setted to tooltip\n         * @param {String} side - parent method name\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _bottomRightChecker: function (s, map, direction, className, side, delegate) {\n            var result = {\n                    position: {}\n                },\n                config = tooltip.getTooltip(tooltipData.currentID),\n                startPosition = !config.strict ? s.eventPosition : {\n                    top: s.elementPosition.top + s.elementSize.h,\n                    left: s.elementPosition.left + s.elementSize.w\n                },\n                changedDirection;\n\n            checkedPositions[side] = true;\n\n            if (\n                startPosition[map[direction].p] + s.tooltipSize[map[direction].s] + config.step <\n                s.scrollPosition[map[direction].p] + s.windowSize[map[direction].s]\n            ) {\n                result.position[map[direction].p] = startPosition[map[direction].p] + config.step;\n                result.className = className;\n                result.side = side;\n                changedDirection = direction === 'vertical' ? 'horizontal' : 'vertical';\n                result = positions._normalize(s, result, config, delegate, map, changedDirection);\n            } else if (!checkedPositions[delegate]) {\n                result = positions[delegate].apply(null, arguments);\n            } else {\n                result = positions.positionCenter(s, result);\n            }\n\n            return result;\n        },\n\n        /**\n         * Centered tooltip if tooltip does not fit in window\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        positionCenter: function (s, data) {\n            data = positions._positionCenter(s, data, 'horizontal', positions.map);\n            data = positions._positionCenter(s, data, 'vertical', positions.map);\n\n            return data;\n        },\n\n        /**\n         * Centered tooltip side\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @param {String} direction - vertical or horizontal\n         * @param {Object} map - mapping for get direction positions\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _positionCenter: function (s, data, direction, map) {\n            if (s.tooltipSize[map[direction].s] < s.windowSize[map[direction].s]) {\n                data.position[map[direction].p] = (s.windowSize[map[direction].s] -\n                    s.tooltipSize[map[direction].s]) / 2 + s.scrollPosition[map[direction].p];\n            } else {\n                data.position[map[direction].p] = s.scrollPosition[map[direction].p];\n                data.tooltipSize = {};\n                data.tooltipSize[map[direction].s] = s.windowSize[map[direction].s];\n            }\n\n            return data;\n        },\n\n        /**\n         * Normalize horizontal or vertical position.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @param {Object} config - tooltip config\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _normalize: function (s, data, config, delegate, map, direction) {\n            var startPosition = !config.center ? s.eventPosition : {\n                    left: s.elementPosition.left + s.elementSize.w / 2,\n                    top: s.elementPosition.top + s.elementSize.h / 2\n                },\n                depResult;\n\n            if (startPosition[map[direction].p] - s.tooltipSize[map[direction].s] / 2 >\n                s.scrollPosition[map[direction].p] && startPosition[map[direction].p] +\n                s.tooltipSize[map[direction].s] / 2 <\n                s.scrollPosition[map[direction].p] + s.windowSize[map[direction].s]\n            ) {\n                data.position[map[direction].p] = startPosition[map[direction].p] - s.tooltipSize[map[direction].s] / 2;\n            } else {\n\n                /*eslint-disable no-lonely-if*/\n                if (!checkedPositions[delegate]) {\n                    depResult = positions[delegate].apply(null, arguments);\n\n                    if (depResult.hasOwnProperty('className')) {\n                        data = depResult;\n                    } else {\n                        data = positions._normalizeTail(s, data, config, delegate, map, direction, startPosition);\n                    }\n                } else {\n                    data = positions._normalizeTail(s, data, config, delegate, map, direction, startPosition);\n                }\n            }\n\n            return data;\n        },\n\n        /**\n         * Calc tail position.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @param {Object} config - tooltip config\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @param {Object} startPosition - start position\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _normalizeTail: function (s, data, config, delegate, map, direction, startPosition) {\n            data.tail = {};\n\n            if (s.tooltipSize[map[direction].s] < s.windowSize[map[direction].s]) {\n\n                if (\n                    startPosition[map[direction].p] >\n                    s.windowSize[map[direction].s] / 2 + s.scrollPosition[map[direction].p]\n                ) {\n                    data.position[map[direction].p] = s.windowSize[map[direction].s] +\n                        s.scrollPosition[map[direction].p] - s.tooltipSize[map[direction].s];\n                    data.tail[map[direction].p] = startPosition[map[direction].p] -\n                        s.tooltipSize[map[direction].s] / 2 - data.position[map[direction].p];\n                } else {\n                    data.position[map[direction].p] = s.scrollPosition[map[direction].p];\n                    data.tail[map[direction].p] = startPosition[map[direction].p] -\n                        s.tooltipSize[map[direction].s] / 2 - data.position[map[direction].p];\n                }\n            } else {\n                data.position[map[direction].p] = s.scrollPosition[map[direction].p];\n                data.tail[map[direction].p] = s.eventPosition[map[direction].p] - s.windowSize[map[direction].s] / 2;\n                data.tooltipSize = {};\n                data.tooltipSize[map[direction].s] = s.windowSize[map[direction].s];\n            }\n\n            return data;\n        }\n    };\n\n    tooltip = {\n\n        /**\n         * Set new tooltip to tooltipCollection, save config, and add unic id\n         *\n         * @param {Object} config - tooltip config\n         * @returns {String} tooltip id\n         */\n        setTooltip: function (config) {\n            var property = 'id-' + iterator;\n\n            tooltipsCollection[property] = config;\n            iterator++;\n\n            return property;\n        },\n\n        /**\n         * Get tooltip config by id\n         *\n         * @param {String} id - tooltip id\n         * @returns {Object} tooltip config\n         */\n        getTooltip: function (id) {\n            return tooltipsCollection[id];\n        },\n\n        /**\n         * Set content to current tooltip\n         *\n         * @param {Object} tooltipElement - tooltip element\n         * @param {Object} viewModel - tooltip view model\n         * @param {String} id - tooltip id\n         * @param {Object} bindingCtx - tooltip context\n         * @param {Object} event - action event\n         */\n        setContent: function (tooltipElement, viewModel, id, bindingCtx, event) {\n            var html = $(tooltipElement).html(),\n                config = tooltip.getTooltip(id),\n                body = $('body');\n\n            tooltipData.currentID = id;\n            tooltipData.trigger = $(event.currentTarget);\n            tooltip.setTargetData(event);\n            body.on('mousemove.setTargetData', tooltip.setTargetData);\n            tooltip.clearTimeout(id);\n\n            tooltipData.timeout = _.delay(function () {\n                body.off('mousemove.setTargetData', tooltip.setTargetData);\n\n                if (tooltipData.trigger[0] === tooltipData.targetElement) {\n                    tooltip.destroy(id);\n                    event.stopPropagation();\n                    tooltipElement = tooltip.createTooltip(id);\n                    tooltipElement.find('.' + defaults.tooltipContentBlock).append(html);\n                    tooltipElement.applyBindings(bindingCtx);\n                    tooltip.setHandlers(id);\n                    tooltip.setPosition(tooltipElement, id);\n                    previousTooltip = id;\n                }\n\n            }, config.delay);\n        },\n\n        /**\n         * Set position to current tooltip\n         *\n         * @param {Object} tooltipElement - tooltip element\n         * @param {String} id - tooltip id\n         */\n        setPosition: function (tooltipElement, id) {\n            var config = tooltip.getTooltip(id);\n\n            tooltip.sizeData = {\n                windowSize: {\n                    h: $(window).outerHeight(),\n                    w: $(window).outerWidth()\n                },\n                scrollPosition: {\n                    top: $(window).scrollTop(),\n                    left: $(window).scrollLeft()\n                },\n                tooltipSize: {\n                    h: tooltipElement.outerHeight(),\n                    w: tooltipElement.outerWidth()\n                },\n                elementSize: {\n                    h: tooltipData.trigger.outerHeight(),\n                    w: tooltipData.trigger.outerWidth()\n                },\n                elementPosition: tooltipData.trigger.offset(),\n                eventPosition: this.getEventPosition(tooltipData.event)\n            };\n\n            _.extend(positionData, positions[config.position](tooltip.sizeData));\n            tooltipElement.css(positionData.position);\n            tooltipElement.addClass(positionData.className);\n            tooltip._setTooltipSize(positionData, tooltipElement);\n            tooltip._setTailPosition(positionData, tooltipElement);\n            checkedPositions = {};\n        },\n\n        /**\n         * Check position data and change tooltip size if needs\n         *\n         * @param {Object} data - position data\n         * @param {Object} tooltipElement - tooltip element\n         */\n        _setTooltipSize: function (data, tooltipElement) {\n            if (data.tooltipSize) {\n                data.tooltipSize.w ?\n                    tooltipElement.css('width', data.tooltipSize.w) :\n                    tooltipElement.css('height', data.tooltipSize.h);\n            }\n        },\n\n        /**\n         * Check position data and set position to tail\n         *\n         * @param {Object} data - position data\n         * @param {Object} tooltipElement - tooltip element\n         */\n        _setTailPosition: function (data, tooltipElement) {\n            var tail,\n                tailMargin;\n\n            if (data.tail) {\n                tail = tooltipElement.find('.' + defaults.tailClass);\n\n                if (data.tail.left) {\n                    tailMargin = parseInt(tail.css('margin-left'), 10);\n                    tail.css('margin-left', tailMargin + data.tail.left);\n                } else {\n                    tailMargin = parseInt(tail.css('margin-top'), 10);\n                    tail.css('margin-top', tailMargin + data.tail.top);\n                }\n            }\n        },\n\n        /**\n         * Resolves position for tooltip\n         *\n         * @param {Object} event\n         * @returns {Object}\n         */\n        getEventPosition: function (event) {\n            var position = {\n                left: event.originalEvent && event.originalEvent.pageX || 0,\n                top: event.originalEvent && event.originalEvent.pageY || 0\n            };\n\n            if (position.left === 0 && position.top === 0) {\n                _.extend(position, event.target.getBoundingClientRect());\n            }\n\n            return position;\n        },\n\n        /**\n         * Close tooltip if action happened outside handler and tooltip element\n         *\n         * @param {String} id - tooltip id\n         * @param {Object} event - action event\n         */\n        outerClick: function (id, event) {\n            var tooltipElement = $(event.target).parents(defaults.tooltipWrapper)[0],\n                isTrigger = event.target === tooltipData.trigger[0] || $.contains(tooltipData.trigger[0], event.target);\n\n            if (tooltipData.showed && tooltipElement !== tooltipData.element[0] && !isTrigger) {\n                tooltip.destroy(id);\n            }\n        },\n\n        /**\n         * Parse keydown event and if event trigger is escape key - close tooltip\n         *\n         * @param {Object} event - action event\n         */\n        keydownHandler: function (event) {\n            if (tooltipData.showed && event.keyCode === 27) {\n                tooltip.destroy(tooltipData.currentID);\n            }\n        },\n\n        /**\n         * Change tooltip position when track is enabled\n         *\n         * @param {Object} event - current event\n         */\n        track: function (event) {\n            var inequality = {},\n                map = positions.map,\n                translate = {\n                    left: 'translateX',\n                    top: 'translateY'\n                },\n                eventPosition = {\n                    left: event.pageX,\n                    top: event.pageY\n                },\n                tooltipSize = {\n                    w: tooltipData.element.outerWidth(),\n                    h: tooltipData.element.outerHeight()\n                },\n                direction = positionData.side === 'bottom' || positionData.side === 'top' ? 'horizontal' : 'vertical';\n\n            inequality[map[direction].p] = eventPosition[map[direction].p] - (positionData.position[map[direction].p] +\n                tooltipSize[map[direction].s] / 2);\n\n            if (positionData.position[map[direction].p] + inequality[map[direction].p] +\n                tooltip.sizeData.tooltipSize[map[direction].s] >\n                tooltip.sizeData.windowSize[map[direction].s] + tooltip.sizeData.scrollPosition[map[direction].p] ||\n                inequality[map[direction].p] + positionData.position[map[direction].p] <\n                tooltip.sizeData.scrollPosition[map[direction].p]) {\n\n                return false;\n            }\n\n            tooltipData.element[0].style[transformProp] = translate[map[direction].p] +\n                '(' + inequality[map[direction].p] + 'px)';\n        },\n\n        /**\n         * Set handlers to tooltip\n         *\n         * @param {String} id - tooltip id\n         */\n        setHandlers: function (id) {\n            var config = tooltip.getTooltip(id);\n\n            if (config.track) {\n                tooltipData.trigger.on('mousemove.track', tooltip.track);\n            }\n\n            if (config.action === 'click') {\n                $(window).on(CLICK_EVENT + '.outerClick', tooltip.outerClick.bind(null, id));\n            }\n\n            if (config.closeButton) {\n                $('.' + config.closeButtonClass).on('click.closeButton', tooltip.destroy.bind(null, id));\n            }\n\n            if (config.closeOnScroll) {\n                document.addEventListener('scroll', tooltip.destroy, true);\n                $(window).on('scroll.tooltip', tooltip.outerClick.bind(null, id));\n            }\n\n            $(window).on('keydown.tooltip', tooltip.keydownHandler);\n            $(window).on('resize.outerClick', tooltip.outerClick.bind(null, id));\n        },\n\n        /**\n         * Toggle tooltip\n         *\n         * @param {Object} tooltipElement - tooltip element\n         * @param {Object} viewModel - tooltip view model\n         * @param {String} id - tooltip id\n         */\n        toggleTooltip: function (tooltipElement, viewModel, id) {\n            if (previousTooltip === id && tooltipData.showed) {\n                tooltip.destroy(id);\n\n                return false;\n            }\n\n            tooltip.setContent.apply(null, arguments);\n\n            return false;\n        },\n\n        /**\n         * Create tooltip and append to DOM\n         *\n         * @param {String} id - tooltip id\n         * @returns {Object} tooltip element\n         */\n        createTooltip: function (id) {\n            var body = $('body'),\n                config = tooltip.getTooltip(id);\n\n            $(template(tooltipTmpl, {\n                data: config\n            })).appendTo(body);\n\n            tooltipData.showed = true;\n            tooltipData.element = $(config.tooltipWrapper);\n\n            return tooltipData.element;\n        },\n\n        /**\n         * Check action and clean timeout\n         *\n         * @param {String} id - tooltip id\n         */\n        clearTimeout: function (id) {\n            var config = tooltip.getTooltip(id);\n\n            if (config.action === 'hover') {\n                clearTimeout(tooltipData.timeout);\n            }\n        },\n\n        /**\n         * Check previous tooltip\n         */\n        checkPreviousTooltip: function () {\n            if (!tooltipData.timeout) {\n                tooltip.destroy();\n            }\n        },\n\n        /**\n         * Destroy tooltip instance\n         */\n        destroy: function () {\n            if (tooltipData.element) {\n                tooltipData.element.remove();\n                tooltipData.showed = false;\n            }\n\n            positionData = {};\n            tooltipData.timeout = false;\n            tooltip.removeHandlers();\n        },\n\n        /**\n         * Remove tooltip handlers\n         */\n        removeHandlers: function () {\n            $('.' + defaults.closeButtonClass).off('click.closeButton');\n            tooltipData.trigger.off('mousemove.track');\n            document.removeEventListener('scroll', tooltip.destroy, true);\n            $(window).off('scroll.tooltip');\n            $(window).off(CLICK_EVENT + '.outerClick');\n            $(window).off('keydown.tooltip');\n            $(window).off('resize.outerClick');\n        },\n\n        /**\n         * Set target element\n         *\n         * @param {Object} event - current event\n         */\n        setTargetData: function (event) {\n            tooltipData.event = event;\n\n            //TODO: bug chrome v.49; Link to issue https://bugs.chromium.org/p/chromium/issues/detail?id=161464\n            if (event.timeStamp - (tooltipData.timestamp || 0) < 1) {\n                return;\n            }\n\n            if (event.type === 'mousemove') {\n                tooltipData.targetElement = event.target;\n            } else {\n                tooltipData.targetElement = event.currentTarget;\n                tooltipData.timestamp = event.timeStamp;\n            }\n        },\n\n        /**\n         * Merged user config with defaults configuration\n         *\n         * @param {Object} config - user config\n         * @returns {Object} merged config\n         */\n        processingConfig: function (config) {\n            return _.extend({}, defaults, config);\n        }\n    };\n\n    ko.bindingHandlers.tooltip = {\n\n        /**\n         * Initialize tooltip\n         *\n         * @param {Object} elem - tooltip DOM element\n         * @param {Function} valueAccessor - ko observable property, tooltip data\n         * @param {Object} allBindings - all bindings on current element\n         * @param {Object} viewModel - current element viewModel\n         * @param {Object} bindingCtx - current element binding context\n         */\n        init: function (elem, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var config = tooltip.processingConfig(valueAccessor()),\n                $parentScope = config.parentScope ? $(config.parentScope) : $(elem).parent(),\n                tooltipId;\n\n            $(elem).addClass('hidden');\n\n            if (isTouchDevice) {\n                config.action = 'click';\n            }\n            tooltipId = tooltip.setTooltip(config);\n\n            if (config.action === 'hover') {\n                $parentScope.on(\n                    'mouseenter',\n                    config.trigger,\n                    tooltip.setContent.bind(null, elem, viewModel, tooltipId, bindingCtx)\n                );\n                $parentScope.on(\n                    'mouseleave',\n                    config.trigger,\n                    tooltip.checkPreviousTooltip.bind(null, tooltipId)\n                );\n            } else if (config.action === 'click') {\n                $parentScope.on(\n                    'click',\n                    config.trigger,\n                    tooltip.toggleTooltip.bind(null, elem, viewModel, tooltipId, bindingCtx)\n                );\n            }\n\n            return {\n                controlsDescendantBindings: true\n            };\n        }\n    };\n\n    renderer.addAttribute('tooltip');\n});\n","Magento_Ui/js/lib/knockout/bindings/color-picker.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    '../template/renderer',\n    'spectrum',\n    'tinycolor'\n], function (ko, $, renderer, spectrum, tinycolor) {\n    'use strict';\n\n    /**\n     * Change color picker status to be enabled or disabled\n     *\n     * @param {HTMLElement} element - Element to apply colorpicker enable/disable status to.\n     * @param {Object} viewModel - Object, which represents view model binded to el.\n     */\n    function changeColorPickerStateBasedOnViewModel(element, viewModel) {\n        $(element).spectrum(viewModel.disabled() ? 'disable' : 'enable');\n    }\n\n    ko.bindingHandlers.colorPicker = {\n        /**\n         * Binding init callback.\n         *\n         * @param {*} element\n         * @param {Function} valueAccessor\n         * @param {Function} allBindings\n         * @param {Object} viewModel\n         */\n        init: function (element, valueAccessor, allBindings, viewModel) {\n            var config = valueAccessor(),\n\n                /** change value */\n                changeValue = function (value) {\n                    if (value == null) {\n                        value = '';\n                    }\n                    config.value(value.toString());\n                };\n\n            config.change = changeValue;\n\n            config.hide = changeValue;\n\n            /** show value */\n            config.show = function () {\n                if (!viewModel.focused()) {\n                    viewModel.focused(true);\n                }\n\n                return true;\n            };\n\n            $(element).spectrum(config);\n\n            changeColorPickerStateBasedOnViewModel(element, viewModel);\n        },\n\n        /**\n         * Reads params passed to binding, parses component declarations.\n         * Fetches for those found and attaches them to the new context.\n         *\n         * @param {HTMLElement} element - Element to apply bindings to.\n         * @param {Function} valueAccessor - Function that returns value, passed to binding.\n         * @param {Object} allBindings - Object, which represents all bindings applied to element.\n         * @param {Object} viewModel - Object, which represents view model binded to element.\n         */\n        update: function (element, valueAccessor, allBindings, viewModel) {\n            var config = valueAccessor();\n\n            if (tinycolor(config.value()).isValid() || config.value() === '') {\n                $(element).spectrum('set', config.value());\n\n                if (config.value() !== '') {\n                    config.value($(element).spectrum('get').toString());\n                }\n            }\n\n            changeColorPickerStateBasedOnViewModel(element, viewModel);\n        }\n    };\n\n    renderer.addAttribute('colorPicker');\n});\n","Magento_Ui/js/lib/knockout/bindings/fadeVisible.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko'\n], function ($, ko) {\n    'use strict';\n\n    ko.bindingHandlers.fadeVisible = {\n        /**\n         * Initially set the element to be instantly visible/hidden depending on the value.\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         */\n        init: function (element, valueAccessor) {\n            var value = valueAccessor();\n\n            // Use \"unwrapObservable\" so we can handle values that may or may not be observable\n            $(element).toggle(ko.unwrap(value));\n        },\n\n        /**\n         * Whenever the value subsequently changes, slowly fade the element in or out.\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         */\n        update: function (element, valueAccessor) {\n            var value = valueAccessor();\n\n            ko.unwrap(value) ? $(element).fadeIn() : $(element).fadeOut();\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/bind-html.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'mage/apply/main',\n    '../template/renderer'\n], function (ko, _, mage, renderer) {\n    'use strict';\n\n    /**\n     * Set html to node element.\n     *\n     * @param {HTMLElement} el - Element to apply bindings to.\n     * @param {Function} html - Observable html content.\n     */\n    function setHtml(el, html) {\n        ko.utils.emptyDomNode(el);\n        html = ko.utils.unwrapObservable(html);\n\n        if (!_.isNull(html) && !_.isUndefined(html)) {\n            if (!_.isString(html)) {\n                html = html.toString();\n            }\n\n            el.innerHTML = html;\n        }\n    }\n\n    /**\n     * Apply bindings and call magento attributes parser.\n     *\n     * @param {HTMLElement} el - Element to apply bindings to.\n     * @param {ko.bindingContext} ctx - Instance of ko.bindingContext, passed to binding initially.\n     */\n    function applyComponents(el, ctx) {\n        ko.utils.arrayForEach(el.childNodes, ko.cleanNode);\n        ko.applyBindingsToDescendants(ctx, el);\n        mage.apply();\n    }\n\n    ko.bindingHandlers.bindHtml = {\n        /**\n         * Scope binding's init method.\n         *\n         * @returns {Object} - Knockout declaration for it to let binding control descendants.\n         */\n        init: function () {\n            return {\n                controlsDescendantBindings: true\n            };\n        },\n\n        /**\n         * Reads params passed to binding.\n         * Set html to node element, apply bindings and call magento attributes parser.\n         *\n         * @param {HTMLElement} el - Element to apply bindings to.\n         * @param {Function} valueAccessor - Function that returns value, passed to binding.\n         * @param {Object} allBindings - Object, which represents all bindings applied to element.\n         * @param {Object} viewModel - Object, which represents view model binded to el.\n         * @param {ko.bindingContext} bindingContext - Instance of ko.bindingContext, passed to binding initially.\n         */\n        update: function (el, valueAccessor, allBindings, viewModel, bindingContext) {\n            setHtml(el, valueAccessor());\n            applyComponents(el, bindingContext);\n        }\n    };\n\n    renderer.addAttribute('bindHtml');\n});\n","Magento_Ui/js/lib/knockout/bindings/resizable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Ui/js/lib/view/utils/async',\n    'uiRegistry',\n    'underscore',\n    '../template/renderer',\n    'jquery-ui-modules/resizable'\n], function (ko, $, async, registry, _, renderer) {\n    'use strict';\n\n    var sizeOptions = [\n            'minHeight',\n            'maxHeight',\n            'minWidth',\n            'maxWidth'\n        ],\n\n        handles = {\n            height: '.ui-resizable-s, .ui-resizable-n',\n            width: '.ui-resizable-w, .ui-resizable-e'\n        };\n\n    /**\n     * Recalcs visibility of handles, width and height of resizable based on content\n     * @param {HTMLElement} element\n     */\n    function adjustSize(element) {\n        var maxHeight,\n            maxWidth;\n\n        element = $(element);\n        maxHeight = element.resizable('option').maxHeight;\n        maxWidth = element.resizable('option').maxWidth;\n\n        if (maxHeight && element.height() > maxHeight) {\n            element.height(maxHeight + 1);\n            $(handles.height).hide();\n        } else {\n            $(handles.height).show();\n        }\n\n        if (maxWidth && element.width() > maxWidth) {\n            element.width(maxWidth + 1);\n            $(handles.width).hide();\n        } else {\n            $(handles.width).show();\n        }\n    }\n\n    /**\n     * Recalcs allowed min, max width and height based on configured selectors\n     * @param {Object} sizeConstraints\n     * @param {String} componentName\n     * @param {HTMLElement} element\n     * @param {Boolean} hasWidthUpdate\n     */\n    function recalcAllowedSize(sizeConstraints, componentName, element, hasWidthUpdate) {\n        var size;\n\n        element = $(element);\n\n        if (!element.data('resizable')) {\n            return;\n        }\n\n        if (!hasWidthUpdate) {\n            element.css('width', 'auto');\n        }\n\n        _.each(sizeConstraints, function (selector, key) {\n            async.async({\n                component: componentName,\n                selector: selector\n            }, function (elem) {\n                size = key.indexOf('Height') !== -1 ? $(elem).outerHeight(true) : $(elem).outerWidth(true);\n\n                if (element.data('resizable')) {\n                    element.resizable('option', key, size + 1);\n                }\n            });\n        }, this);\n\n        adjustSize(element);\n    }\n\n    /**\n     * Preprocess config to separate options,\n     * which must be processed further before applying\n     *\n     * @param {Object} config\n     * @param {Object} viewModel\n     * @param {*} element\n     * @return {Object} config\n     */\n    function processConfig(config, viewModel, element) {\n        var sizeConstraint,\n            sizeConstraints = {},\n            recalc,\n            hasWidthUpdate;\n\n        if (_.isEmpty(config)) {\n            return {};\n        }\n        _.each(sizeOptions, function (key) {\n            sizeConstraint = config[key];\n\n            if (sizeConstraint && !_.isNumber(sizeConstraint)) {\n                sizeConstraints[key] = sizeConstraint;\n                delete config[key];\n            }\n        });\n        hasWidthUpdate =  _.some(sizeConstraints, function (value, key) {\n            return key.indexOf('Width') !== -1;\n        });\n\n        recalc = recalcAllowedSize.bind(null, sizeConstraints, viewModel.name, element, hasWidthUpdate);\n        config.start = recalc;\n        $(window).on('resize.resizable', recalc);\n        registry.get(viewModel.provider).on('reloaded', recalc);\n\n        return config;\n    }\n\n    ko.bindingHandlers.resizable = {\n\n        /**\n         * Binding init callback.\n         *\n         * @param {*} element\n         * @param {Function} valueAccessor\n         * @param {Function} allBindings\n         * @param {Object} viewModel\n         */\n        init: function (element, valueAccessor, allBindings, viewModel) {\n            var config = processConfig(valueAccessor(), viewModel, element);\n\n            $(element).resizable(config);\n        }\n    };\n\n    renderer.addAttribute('resizable');\n});\n","Magento_Ui/js/lib/knockout/bindings/collapsible.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    '../template/renderer'\n], function (ko, $, _, renderer) {\n    'use strict';\n\n    var collapsible,\n        defaults;\n\n    defaults = {\n        closeOnOuter: true,\n        onTarget: false,\n        openClass: '_active',\n        as: '$collapsible'\n    };\n\n    collapsible = {\n\n        /**\n         * Sets 'opened' property to true.\n         */\n        open: function () {\n            this.opened(true);\n        },\n\n        /**\n         * Sets 'opened' property to false.\n         */\n        close: function () {\n            this.opened(false);\n        },\n\n        /**\n         * Toggles value of the 'opened' property.\n         */\n        toggle: function () {\n            this.opened(!this.opened());\n        }\n    };\n\n    /**\n     * Document click handler which in case if event target is not\n     * a descendant of provided container element, closes collapsible model.\n     *\n     * @param {HTMLElement} container\n     * @param {Object} model\n     * @param {EventObject} e\n     */\n    function onOuterClick(container, model, e) {\n        var target = e.target;\n\n        if (target !== container && !container.contains(target)) {\n            model.close();\n        }\n    }\n\n    /**\n     * Creates 'css' binding which toggles\n     * class specified in 'name' parameter.\n     *\n     * @param {Object} model\n     * @param {String} name\n     * @returns {Object}\n     */\n    function getClassBinding(model, name) {\n        var binding = {};\n\n        binding[name] = model.opened;\n\n        return {\n            css: binding\n        };\n    }\n\n    /**\n     * Prepares configuration for the binding based\n     * on a default properties and provided options.\n     *\n     * @param {Object} [options={}]\n     * @returns {Object} Complete instance configuration.\n     */\n    function buildConfig(options) {\n        if (typeof options !== 'object') {\n            options = {};\n        }\n\n        return _.extend({}, defaults, options);\n    }\n\n    ko.bindingHandlers.collapsible = {\n\n        /**\n         * Initializes 'collapsible' binding.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var $collapsible = Object.create(collapsible),\n                config = buildConfig(valueAccessor()),\n                outerClick,\n                bindings;\n\n            _.bindAll($collapsible, 'open', 'close', 'toggle');\n\n            $collapsible.opened = ko.observable(!!config.opened);\n\n            bindingCtx[config.as] = $collapsible;\n\n            if (config.closeOnOuter) {\n                outerClick = onOuterClick.bind(null, element, $collapsible);\n\n                $(document).on('click', outerClick);\n\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n                    $(document).off('click', outerClick);\n                });\n            }\n\n            if (config.openClass) {\n                bindings = getClassBinding($collapsible, config.openClass);\n\n                ko.applyBindingsToNode(element, bindings, bindingCtx);\n            }\n\n            if (config.onTarget) {\n                $(element).on('click', $collapsible.toggle);\n            }\n\n            if (viewModel && _.isFunction(viewModel.on)) {\n                viewModel.on({\n                    close:          $collapsible.close,\n                    open:           $collapsible.open,\n                    toggleOpened:   $collapsible.toggle\n                });\n            }\n        }\n    };\n\n    ko.bindingHandlers.closeCollapsible = {\n\n        /**\n         * Creates listener for the click event on provided DOM element,\n         * which closes associated with it collapsible model.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var name = valueAccessor() || defaults.as,\n                $collapsible = bindingCtx[name];\n\n            if ($collapsible) {\n                $(element).on('click', $collapsible.close);\n            }\n        }\n    };\n\n    ko.bindingHandlers.openCollapsible = {\n\n        /**\n         * Creates listener for the click event on provided DOM element,\n         * which opens associated with it collapsible model.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var name = valueAccessor() || defaults.as,\n                $collapsible = bindingCtx[name];\n\n            if ($collapsible) {\n                $(element).on('click', $collapsible.open);\n            }\n        }\n    };\n\n    ko.bindingHandlers.toggleCollapsible = {\n\n        /**\n         * Creates listener for the click event on provided DOM element,\n         * which toggles associated with it collapsible model.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var name = valueAccessor() || defaults.as,\n                $collapsible = bindingCtx[name];\n\n            if ($collapsible) {\n                $(element).on('click', $collapsible.toggle);\n            }\n        }\n    };\n\n    renderer\n        .addAttribute('collapsible')\n        .addAttribute('openCollapsible')\n        .addAttribute('closeCollapsible')\n        .addAttribute('toggleCollapsible');\n});\n","Magento_Ui/js/lib/knockout/bindings/outer_click.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Creates outerClick binding and registers in to ko.bindingHandlers object */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    '../template/renderer'\n], function (ko, $, _, renderer) {\n    'use strict';\n\n    var defaults = {\n        onlyIfVisible: true\n    };\n\n    /**\n     * Checks if element sis visible.\n     *\n     * @param {Element} el\n     * @returns {Boolean}\n     */\n    function isVisible(el) {\n        var style = window.getComputedStyle(el),\n            visibility = {\n                display: 'none',\n                visibility: 'hidden',\n                opacity: '0'\n            },\n            visible = true;\n\n        _.each(visibility, function (val, key) {\n            if (style[key] === val) {\n                visible = false;\n            }\n        });\n\n        return visible;\n    }\n\n    /**\n     * Document click handler which in case if event target is not\n     * a descendant of provided container element,\n     * invokes specified in configuration callback.\n     *\n     * @param {HTMLElement} container\n     * @param {Object} config\n     * @param {EventObject} e\n     */\n    function onOuterClick(container, config, e) {\n        var target = e.target,\n            callback = config.callback;\n\n        if (container === target || container.contains(target)) {\n            return;\n        }\n\n        if (config.onlyIfVisible) {\n            if (!_.isNull(container.offsetParent) && isVisible(container)) {\n                callback();\n            }\n        } else {\n            callback();\n        }\n    }\n\n    /**\n     * Prepares configuration for the binding based\n     * on a default properties and provided options.\n     *\n     * @param {(Object|Function)} [options={}]\n     * @returns {Object}\n     */\n    function buildConfig(options) {\n        var config = {};\n\n        if (_.isFunction(options)) {\n            options = {\n                callback: options\n            };\n        } else if (!_.isObject(options)) {\n            options = {};\n        }\n\n        return _.extend(config, defaults, options);\n    }\n\n    ko.bindingHandlers.outerClick = {\n\n        /**\n         * Initializes outer click binding.\n         */\n        init: function (element, valueAccessor) {\n            var config = buildConfig(valueAccessor()),\n                outerClick = onOuterClick.bind(null, element, config),\n                isTouchDevice = typeof document.ontouchstart !== 'undefined';\n\n            if (isTouchDevice) {\n                $(document).on('touchstart', outerClick);\n\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n                    $(document).off('touchstart', outerClick);\n                });\n            } else {\n                $(document).on('click', outerClick);\n\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n                    $(document).off('click', outerClick);\n                });\n            }\n        }\n    };\n\n    renderer.addAttribute('outerClick');\n});\n","Magento_Ui/js/lib/knockout/bindings/after-render.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.afterRender = {\n\n        /**\n         * Binding init callback.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel) {\n            var callback = valueAccessor();\n\n            if (typeof callback === 'function') {\n                callback.call(viewModel, element, viewModel);\n            }\n        }\n    };\n\n    renderer.addAttribute('afterRender');\n});\n","Magento_Ui/js/lib/knockout/bindings/i18n.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'module',\n    '../template/renderer',\n    'mage/translate'\n], function ($, ko, module, renderer) {\n    'use strict';\n\n    var locations = {\n            'legend': 'Caption for the fieldset element',\n            'label': 'Label for an input element.',\n            'button': 'Push button',\n            'a': 'Link label',\n            'b': 'Bold text',\n            'strong': 'Strong emphasized text',\n            'i': 'Italic text',\n            'em': 'Emphasized text',\n            'u': 'Underlined text',\n            'sup': 'Superscript text',\n            'sub': 'Subscript text',\n            'span': 'Span element',\n            'small': 'Smaller text',\n            'big': 'Bigger text',\n            'address': 'Contact information',\n            'blockquote': 'Long quotation',\n            'q': 'Short quotation',\n            'cite': 'Citation',\n            'caption': 'Table caption',\n            'abbr': 'Abbreviated phrase',\n            'acronym': 'An acronym',\n            'var': 'Variable part of a text',\n            'dfn': 'Term',\n            'strike': 'Strikethrough text',\n            'del': 'Deleted text',\n            'ins': 'Inserted text',\n            'h1': 'Heading level 1',\n            'h2': 'Heading level 2',\n            'h3': 'Heading level 3',\n            'h4': 'Heading level 4',\n            'h5': 'Heading level 5',\n            'h6': 'Heading level 6',\n            'center': 'Centered text',\n            'select': 'List options',\n            'img': 'Image',\n            'input': 'Form element'\n        },\n\n        /**\n         * Generates [data-translate] attribute's value\n         * @param {Object} translationData\n         * @param {String} location\n         */\n        composeTranslateAttr = function (translationData, location) {\n            var obj = [{\n                'shown': translationData.shown,\n                'translated': translationData.translated,\n                'original': translationData.original,\n                'location': locations[location] || 'Text'\n            }];\n\n            return JSON.stringify(obj);\n        },\n\n        /**\n         * Sets text for the element\n         * @param {Object} el\n         * @param {String} text\n         */\n        setText = function (el, text) {\n            $(el).text(text);\n        },\n\n        /**\n         * Sets [data-translate] attribute for the element\n         * @param {Object} el - The element which is binded\n         * @param {String} original - The original value of the element\n         */\n        setTranslateProp = function (el, original) {\n            var location = $(el).prop('tagName').toLowerCase(),\n                translated = $.mage.__(original),\n                translationData = {\n                    shown: translated,\n                    translated: translated,\n                    original: original\n                },\n                translateAttr = composeTranslateAttr(translationData, location);\n\n            $(el).attr('data-translate', translateAttr);\n\n            setText(el, translationData.shown);\n        },\n\n        /**\n         * Checks if node represents ko virtual node (nodeType === 8, nodeName === '#comment').\n         *\n         * @param {HTMLElement} node\n         * @returns {Boolean}\n         */\n        isVirtualElement = function (node) {\n            return node.nodeType === 8;\n        },\n\n        /**\n        * Checks if it's real DOM element\n        * in case of virtual element, returns span wrapper\n        * @param {Object} el\n        * @param {bool} isUpdate\n        * @return {Object} el\n        */\n        getRealElement = function (el, isUpdate) {\n            if (isVirtualElement(el)) {\n                if (isUpdate) {\n                    return $(el).next('span');\n                }\n\n                return $('<span/>').insertAfter(el);\n            }\n\n            return el;\n        },\n\n        /**\n         * execute i18n binding\n         * @param {Object} element\n         * @param {Function} valueAccessor\n         * @param {bool} isUpdate\n         */\n        execute = function (element, valueAccessor, isUpdate) {\n            var original = ko.unwrap(valueAccessor() || ''),\n                el = getRealElement(element, isUpdate),\n                inlineTranslation = (module.config() || {}).inlineTranslation;\n\n            if (inlineTranslation) {\n                setTranslateProp(el, original);\n            } else {\n                setText(el, $.mage.__(original));\n            }\n        };\n\n    /**\n     * i18n binding\n     * @property {Function}  init\n     * @property {Function}  update\n     */\n    ko.bindingHandlers.i18n = {\n\n        /**\n         * init i18n binding\n         * @param {Object} element\n         * @param {Function} valueAccessor\n         */\n        init: function (element, valueAccessor) {\n            execute(element, valueAccessor);\n        },\n\n        /**\n         * update i18n binding\n         * @param {Object} element\n         * @param {Function} valueAccessor\n         */\n        update: function (element, valueAccessor) {\n            execute(element, valueAccessor, true);\n        }\n    };\n\n    ko.virtualElements.allowedBindings.i18n = true;\n\n    renderer\n        .addNode('translate', {\n            binding: 'i18n'\n        })\n        .addAttribute('translate', {\n            binding: 'i18n'\n        });\n});\n","Magento_Ui/js/lib/knockout/extender/observable_array.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore'\n], function (ko, _) {\n    'use strict';\n\n    /**\n     * Iterator function.\n     *\n     * @param {String} callback\n     * @param {Array} args\n     * @param {Object} elem\n     * @returns {*}\n     */\n    function iterator(callback, args, elem) {\n        callback = elem[callback];\n\n        if (_.isFunction(callback)) {\n            return callback.apply(elem, args);\n        }\n\n        return callback;\n    }\n\n    /**\n     * Wrapper function.\n     *\n     * @param {String} method\n     * @returns {Function}\n     */\n    function wrapper(method) {\n        return function (iteratee) {\n            var callback = iteratee,\n                elems = this(),\n                args = _.toArray(arguments);\n\n            if (_.isString(iteratee)) {\n                callback = iterator.bind(null, iteratee, args.slice(1));\n\n                args.unshift(callback);\n            }\n\n            args.unshift(elems);\n\n            return _[method].apply(_, args);\n        };\n    }\n\n    _.extend(ko.observableArray.fn, {\n        each: wrapper('each'),\n\n        map: wrapper('map'),\n\n        filter: wrapper('filter'),\n\n        some: wrapper('some'),\n\n        every: wrapper('every'),\n\n        groupBy: wrapper('groupBy'),\n\n        sortBy: wrapper('sortBy'),\n\n        /**\n         * Wrapper for underscore findWhere function.\n         *\n         * @param {Object} properties\n         * @return {Object}\n         */\n        findWhere: function (properties) {\n            return _.findWhere(this(), properties);\n        },\n\n        /**\n         * Wrapper for underscore contains function.\n         *\n         * @param {*} value\n         * @return {Boolean}\n         */\n        contains: function (value) {\n            return _.contains(this(), value);\n        },\n\n        /**\n         * Inverse contains call.\n         *\n         * @return {Boolean}\n         */\n        hasNo: function () {\n            return !this.contains.apply(this, arguments);\n        },\n\n        /**\n         * Getter for length property.\n         *\n         * @return {Number}\n         */\n        getLength: function () {\n            return this().length;\n        },\n\n        /**\n         * Create object with keys that gets from each object property.\n         *\n         * @return {Object}\n         */\n        indexBy: function (key) {\n            return _.indexBy(this(), key);\n        },\n\n        /**\n         * Returns a copy of the array with all instances of the values removed.\n         *\n         * @return {Array}\n         */\n        without: function () {\n            var args = Array.prototype.slice.call(arguments);\n\n            args.unshift(this());\n\n            return _.without.apply(_, args);\n        },\n\n        /**\n         * Returns the first element of an array.\n         *\n         * @return {*}\n         */\n        first: function () {\n            return _.first(this());\n        },\n\n        /**\n         * Returns the last element of an array\n         *\n         * @return {*}\n         */\n        last: function () {\n            return _.last(this());\n        },\n\n        /**\n         * Iterate and pick provided properties.\n         *\n         * @return {Array}\n         */\n        pluck: function () {\n            var args = Array.prototype.slice.call(arguments);\n\n            args.unshift(this());\n\n            return _.pluck.apply(_, args);\n        }\n    });\n});\n","Magento_Ui/js/lib/knockout/extender/bound-nodes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global WeakMap */\ndefine([\n    'ko',\n    'underscore',\n    'mage/utils/wrapper',\n    'uiEvents',\n    'es6-collections'\n], function (ko, _, wrapper, Events) {\n    'use strict';\n\n    var nodesMap = new WeakMap();\n\n    /**\n     * Returns a array of nodes associated with a specified model.\n     *\n     * @param {Object} model\n     * @returns {Undefined|Array}\n     */\n    function getBounded(model) {\n        return nodesMap.get(model);\n    }\n\n    /**\n     * Removes specified node to models' associations list, if it's\n     * a root node (node is not a descendant of any previously added nodes).\n     * Triggers 'addNode' event.\n     *\n     * @param {Object} model\n     * @param {HTMLElement} node\n     */\n    function addBounded(model, node) {\n        var nodes = getBounded(model),\n            isRoot;\n\n        if (!nodes) {\n            nodesMap.set(model, [node]);\n\n            Events.trigger.call(model, 'addNode', node);\n\n            return;\n        }\n\n        isRoot = nodes.every(function (bounded) {\n            return !bounded.contains(node);\n        });\n\n        if (isRoot) {\n            nodes.push(node);\n\n            Events.trigger.call(model, 'addNode', node);\n        }\n    }\n\n    /**\n     * Removes specified node from models' associations list.\n     * Triggers 'removeNode' event.\n     *\n     * @param {Object} model\n     * @param {HTMLElement} node\n     */\n    function removeBounded(model, node) {\n        var nodes = getBounded(model),\n            index;\n\n        if (!nodes) {\n            return;\n        }\n\n        index = nodes.indexOf(node);\n\n        if (~index) {\n            nodes.splice(index, 0);\n\n            Events.trigger.call(model, 'removeNode', node);\n        }\n\n        if (!nodes.length) {\n            nodesMap.delete(model);\n        }\n    }\n\n    /**\n     * Returns node's first sibling of 'element' type within the common component scope\n     *\n     * @param {HTMLElement} node\n     * @param {*} data\n     * @returns {HTMLElement}\n     */\n    function getElement(node, data) {\n        var elem;\n\n        while (node.nextElementSibling) {\n            node = node.nextElementSibling;\n\n            if (node.nodeType === 1 && ko.dataFor(node) === data) {\n                elem = node;\n                break;\n            }\n        }\n\n        return elem;\n    }\n\n    wrapper.extend(ko, {\n\n        /**\n         * Extends knockouts' 'applyBindings'\n         * to track nodes associated with model.\n         *\n         * @param {Function} orig - Original 'applyBindings' method.\n         * @param {Object} ctx\n         * @param {HTMLElement} node - Original 'applyBindings' method.\n         */\n        applyBindings: function (orig, ctx, node) {\n            var result = orig(),\n                data = ctx && (ctx.$data || ctx);\n\n            if (node && node.nodeType === 8) {\n                node = getElement(node, data);\n            }\n\n            if (!node || node.nodeType !== 1) {\n                return result;\n            }\n\n            if (data && data.registerNodes) {\n                addBounded(data, node);\n            }\n\n            return result;\n        },\n\n        /**\n         * Extends knockouts' cleanNode\n         * to track nodes associated with model.\n         *\n         * @param {Function} orig - Original 'cleanNode' method.\n         * @param {HTMLElement} node - Original 'cleanNode' method.\n         */\n        cleanNode: function (orig, node) {\n            var result = orig(),\n                data;\n\n            if (node.nodeType !== 1) {\n                return result;\n            }\n\n            data = ko.dataFor(node);\n\n            if (data && data.registerNodes) {\n                removeBounded(data, node);\n            }\n\n            return result;\n        }\n    });\n\n    return {\n\n        /**\n         * Returns root nodes associated with a model. If callback is provided,\n         * will iterate through all of the present nodes triggering callback\n         * for each of it. Also it will subscribe to the 'addNode' event.\n         *\n         * @param {Object} model\n         * @param {Function} [callback]\n         * @returns {Array|Undefined}\n         */\n        get: function (model, callback) {\n            var nodes = getBounded(model) || [];\n\n            if (!_.isFunction(callback)) {\n                return nodes;\n            }\n\n            nodes.forEach(function (node) {\n                callback(node);\n            });\n\n            this.add.apply(this, arguments);\n        },\n\n        /**\n         * Subscribes to adding of nodes associated with a model.\n         *\n         * @param {Object} model\n         */\n        add: function (model) {\n            var args = _.toArray(arguments).slice(1);\n\n            args.unshift('addNode');\n\n            Events.on.apply(model, args);\n        },\n\n        /**\n         * Subscribes to removal of nodes associated with a model.\n         *\n         * @param {Object} model\n         */\n        remove: function (model) {\n            var args = _.toArray(arguments).slice(1);\n\n            args.unshift('removeNode');\n\n            Events.on.apply(model, args);\n        },\n\n        /**\n         * Removes subscriptions from the model.\n         *\n         * @param {Object} model\n         */\n        off: function (model) {\n            var args = _.toArray(arguments).slice(1);\n\n            Events.off.apply(model, args);\n        }\n    };\n});\n","Magento_Ui/js/lib/core/events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global WeakMap, Map*/\ndefine([\n    'ko',\n    'underscore',\n    'es6-collections'\n], function (ko, _) {\n    'use strict';\n\n    var eventsMap = new WeakMap();\n\n    /**\n     * Returns events map or a specific event\n     * data associated with a provided object.\n     *\n     * @param {Object} obj - Key in the events weakmap.\n     * @param {String} [name] - Name of the event.\n     * @returns {Map|Array|Boolean}\n     */\n    function getEvents(obj, name) {\n        var events = eventsMap.get(obj);\n\n        if (!events) {\n            return false;\n        }\n\n        return name ? events.get(name) : events;\n    }\n\n    /**\n     * Adds new event handler.\n     *\n     * @param {Object} obj - Key in the events weakmap.\n     * @param {String} ns - Callback namespace.\n     * @param {Function} callback - Event callback.\n     * @param {String} name - Name of the event.\n     */\n    function addHandler(obj, ns, callback, name) {\n        var events      = getEvents(obj),\n            observable,\n            data;\n\n        observable = !ko.isObservable(obj[name]) ?\n            ko.getObservable(obj, name) :\n            obj[name];\n\n        if (observable) {\n            observable.subscribe(callback);\n\n            return;\n        }\n\n        if (!events) {\n            events = new Map();\n\n            eventsMap.set(obj, events);\n        }\n\n        data = {\n            callback: callback,\n            ns: ns\n        };\n\n        events.has(name) ?\n            events.get(name).push(data) :\n            events.set(name, [data]);\n    }\n\n    /**\n     * Invokes provided callbacks with a specified arguments.\n     *\n     * @param {Array} handlers\n     * @param {Array} args\n     * @returns {Boolean}\n     */\n    function trigger(handlers, args) {\n        var bubble = true,\n            callback;\n\n        handlers.forEach(function (handler) {\n            callback = handler.callback;\n\n            if (callback.apply(null, args) === false) {\n                bubble = false;\n            }\n        });\n\n        return bubble;\n    }\n\n    return {\n\n        /**\n         * Calls callback when name event is triggered.\n         * @param  {String}   events\n         * @param  {Function} callback\n         * @param  {Function} ns\n         * @return {Object} reference to this\n         */\n        on: function (events, callback, ns) {\n            var iterator;\n\n            if (arguments.length < 2) {\n                ns = callback;\n            }\n\n            iterator = addHandler.bind(null, this, ns);\n\n            _.isObject(events) ?\n                _.each(events, iterator) :\n                iterator(callback, events);\n\n            return this;\n        },\n\n        /**\n         * Removed callback from listening to target event\n         * @param  {String} ns\n         * @return {Object} reference to this\n         */\n        off: function (ns) {\n            var storage = getEvents(this);\n\n            if (!storage) {\n                return this;\n            }\n\n            storage.forEach(function (handlers, name) {\n                handlers = handlers.filter(function (handler) {\n                    return !ns ? false : handler.ns !== ns;\n                });\n\n                handlers.length ?\n                    storage.set(name, handlers) :\n                    storage.delete(name);\n            });\n\n            return this;\n        },\n\n        /**\n         * Triggers event and executes all attached callbacks.\n         *\n         * @param {String} name - Name of the event to be triggered.\n         * @returns {Boolean}\n         */\n        trigger: function (name) {\n            var handlers,\n                args;\n\n            handlers = getEvents(this, name),\n            args = _.toArray(arguments).slice(1);\n\n            if (!handlers || !name) {\n                return true;\n            }\n\n            return trigger(handlers, args);\n        }\n    };\n});\n","Magento_Ui/js/lib/core/collection.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'uiElement'\n], function (_, utils, registry, Element) {\n    'use strict';\n\n    /**\n     * Removes non plain object items from the specified array.\n     *\n     * @param {Array} container - Array whose value should be filtered.\n     * @returns {Array}\n     */\n    function compact(container) {\n        return container.filter(utils.isObject);\n    }\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/collection',\n            _elems: [],\n            ignoreTmpls: {\n                childDefaults: true\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Model} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe({\n                    elems: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Called when another element was added to current component.\n         *\n         * @param {Object} elem - Instance of an element that was added.\n         * @returns {Collection} Chainable.\n         */\n        initElement: function (elem) {\n            elem.initContainer(this);\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a child found by provided index.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {Object}\n         */\n        getChild: function (index) {\n            return _.findWhere(this.elems(), {\n                index: index\n            });\n        },\n\n        /**\n         * Requests specified components to insert\n         * them into 'elems' array starting from provided position.\n         *\n         * @param {(String|Array)} elems - Name of the component to insert.\n         * @param {Number} [position=-1] - Position at which to insert elements.\n         * @returns {Collection} Chainable.\n         */\n        insertChild: function (elems, position) {\n            var container   = this._elems,\n                insert      = this._insert.bind(this),\n                update;\n\n            if (!Array.isArray(elems)) {\n                elems = [elems];\n            }\n\n            elems.map(function (item) {\n                return item.elem ?\n                    utils.insert(item.elem, container, item.position) :\n                    utils.insert(item, container, position);\n            }).forEach(function (item) {\n                if (item === true) {\n                    update = true;\n                } else if (_.isString(item)) {\n                    registry.get(item, insert);\n                } else if (utils.isObject(item)) {\n                    insert(item);\n                }\n            });\n\n            if (update) {\n                this._updateCollection();\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes specified child from collection.\n         *\n         * @param {(Object|String)} elem - Child or index of a child to be removed.\n         * @param {Boolean} skipUpdate - skip collection update when element to be destroyed.\n         *\n         * @returns {Collection} Chainable.\n         */\n        removeChild: function (elem, skipUpdate) {\n            if (_.isString(elem)) {\n                elem = this.getChild(elem);\n            }\n\n            if (elem) {\n                utils.remove(this._elems, elem);\n\n                if (!skipUpdate) {\n                    this._updateCollection();\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Destroys collection children with its' elements.\n         */\n        destroyChildren: function () {\n            this.elems.each(function (elem) {\n                elem.destroy(true);\n            });\n\n            this._updateCollection();\n        },\n\n        /**\n         * Clear data. Call method \"clear\"\n         * in child components\n         *\n         * @returns {Object} Chainable.\n         */\n        clear: function () {\n            var elems = this.elems();\n\n            _.each(elems, function (elem) {\n                if (_.isFunction(elem.clear)) {\n                    elem.clear();\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Checks if specified child exists in collection.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {Boolean}\n         */\n        hasChild: function (index) {\n            return !!this.getChild(index);\n        },\n\n        /**\n         * Creates 'async' wrapper for the specified child\n         * using uiRegistry 'async' method and caches it\n         * in a '_requested' components  object.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {Function} Async module wrapper.\n         */\n        requestChild: function (index) {\n            var name = this.formChildName(index);\n\n            return this.requestModule(name);\n        },\n\n        /**\n         * Creates complete child name based on a provided index.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {String}\n         */\n        formChildName: function (index) {\n            return this.name + '.' + index;\n        },\n\n        /**\n         * Retrieves requested region.\n         * Creates region if it was not created yet\n         *\n         * @returns {ObservableArray}\n         */\n        getRegion: function (name) {\n            var regions = this.regions = this.regions || {};\n\n            if (!regions[name]) {\n                regions[name] = [];\n\n                this.observe.call(regions, name);\n            }\n\n            return regions[name];\n        },\n\n        /**\n         * Replaces specified regions' data with a provided one.\n         * Creates region if it was not created yet.\n         *\n         * @param {Array} items - New regions' data.\n         * @param {String} name - Name of the region.\n         * @returns {Collection} Chainable.\n         */\n        updateRegion: function (items, name) {\n            this.getRegion(name)(items);\n\n            return this;\n        },\n\n        /**\n         * Destroys collection along with its' elements.\n         */\n        destroy: function () {\n            this._super();\n\n            this.elems.each('destroy');\n        },\n\n        /**\n         * Inserts provided component into 'elems' array at a specified position.\n         * @private\n         *\n         * @param {Object} elem - Element to insert.\n         */\n        _insert: function (elem) {\n            var index = this._elems.indexOf(elem.name);\n\n            if (~index) {\n                this._elems[index] = elem;\n            }\n\n            this._updateCollection()\n                .initElement(elem);\n        },\n\n        /**\n         * Synchronizes multiple elements arrays with a core '_elems' container.\n         * Performs elemets grouping by theirs 'displayArea' property.\n         * @private\n         *\n         * @returns {Collection} Chainable.\n         */\n        _updateCollection: function () {\n            var _elems = compact(this._elems),\n                grouped;\n\n            grouped = _elems.filter(function (elem) {\n                return elem.displayArea && _.isString(elem.displayArea);\n            });\n            grouped = _.groupBy(grouped, 'displayArea');\n\n            _.each(grouped, this.updateRegion, this);\n\n            _.each(this.regions, function (items) {\n                var hasObsoleteComponents = items().length && !_.intersection(_elems, items()).length;\n\n                if (hasObsoleteComponents) {\n                    items.removeAll();\n                }\n            });\n\n            this.elems(_elems);\n\n            return this;\n        },\n\n        /**\n         * Tries to call specified method of a current component,\n         * otherwise delegates attempt to its' children.\n         *\n         * @param {String} target - Name of the method.\n         * @param {...*} parameters - Arguments that will be passed to method.\n         * @returns {*} Result of the method calls.\n         */\n        delegate: function (target) {\n            var args = _.toArray(arguments);\n\n            target = this[target];\n\n            if (_.isFunction(target)) {\n                return target.apply(this, args.slice(1));\n            }\n\n            return this._delegate(args);\n        },\n\n        /**\n         * Calls 'delegate' method of all of it's children components.\n         * @private\n         *\n         * @param {Array} args - An array of arguments to pass to the next delegation call.\n         * @returns {Array} An array of delegation results.\n         */\n        _delegate: function (args) {\n            var result;\n\n            result = this.elems.map(function (elem) {\n                var target;\n\n                if (!_.isFunction(elem.delegate)) {\n                    target = elem[args[0]];\n\n                    if (_.isFunction(target)) {\n                        return target.apply(elem, args.slice(1));\n                    }\n                } else {\n                    return elem.delegate.apply(elem, args);\n                }\n            });\n\n            return _.flatten(result);\n        }\n    });\n});\n","Magento_Ui/js/lib/core/class.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'mage/utils/wrapper'\n], function (_, utils, wrapper) {\n    'use strict';\n\n    var Class;\n\n    /**\n     * Returns property of an object if\n     * it's his own property.\n     *\n     * @param {Object} obj - Object whose property should be retrieved.\n     * @param {String} prop - Name of the property.\n     * @returns {*} Value of the property or false.\n     */\n    function getOwn(obj, prop) {\n        return _.isObject(obj) && obj.hasOwnProperty(prop) && obj[prop];\n    }\n\n    /**\n     * Creates constructor function which allows\n     * initialization without usage of a 'new' operator.\n     *\n     * @param {Object} protoProps - Prototypal properties of a new constructor.\n     * @param {Function} constructor\n     * @returns {Function} Created constructor.\n     */\n    function createConstructor(protoProps, constructor) {\n        var UiClass = constructor;\n\n        if (!UiClass) {\n\n            /**\n             * Default constructor function.\n             */\n            UiClass = function () {\n                var obj = this;\n\n                if (!_.isObject(obj) || Object.getPrototypeOf(obj) !== UiClass.prototype) {\n                    obj = Object.create(UiClass.prototype);\n                }\n\n                obj.initialize.apply(obj, arguments);\n\n                return obj;\n            };\n        }\n\n        UiClass.prototype = protoProps;\n        UiClass.prototype.constructor = UiClass;\n\n        return UiClass;\n    }\n\n    Class = createConstructor({\n\n        /**\n         * Entry point to the initialization of constructor's instance.\n         *\n         * @param {Object} [options={}]\n         * @returns {Class} Chainable.\n         */\n        initialize: function (options) {\n            this.initConfig(options);\n\n            return this;\n        },\n\n        /**\n         * Recursively extends data specified in constructors' 'defaults'\n         * property with provided options object. Evaluates resulting\n         * object using string templates (see: mage/utils/template.js).\n         *\n         * @param {Object} [options={}]\n         * @returns {Class} Chainable.\n         */\n        initConfig: function (options) {\n            var defaults    = this.constructor.defaults,\n                config      = utils.extend({}, defaults, options || {}),\n                ignored     = config.ignoreTmpls || {},\n                cached      = utils.omit(config, ignored);\n\n            config = utils.template(config, this, false, true);\n\n            _.each(cached, function (value, key) {\n                utils.nested(config, key, value);\n            });\n\n            return _.extend(this, config);\n        }\n    });\n\n    _.extend(Class, {\n        defaults: {\n            ignoreTmpls: {\n                templates: true\n            }\n        },\n\n        /**\n         * Creates new constructor based on a current prototype properties,\n         * extending them with properties specified in 'exender' object.\n         *\n         * @param {Object} [extender={}]\n         * @returns {Function} New constructor.\n         */\n        extend: function (extender) {\n            var parent      = this,\n                parentProto = parent.prototype,\n                childProto  = Object.create(parentProto),\n                child       = createConstructor(childProto, getOwn(extender, 'constructor')),\n                defaults;\n\n            extender = extender || {};\n            defaults = extender.defaults;\n\n            delete extender.defaults;\n\n            _.each(extender, function (method, name) {\n                childProto[name] = wrapper.wrapSuper(parentProto[name], method);\n            });\n\n            child.defaults = utils.extend({}, parent.defaults || {});\n\n            if (defaults) {\n                utils.extend(child.defaults, defaults);\n                extender.defaults = defaults;\n            }\n\n            return _.extend(child, {\n                __super__:  parentProto,\n                extend:     parent.extend\n            });\n        }\n    });\n\n    return Class;\n});\n","Magento_Ui/js/lib/core/element/element.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'uiEvents',\n    'uiClass',\n    './links',\n    '../storage/local'\n], function (ko, _, utils, registry, Events, Class, links) {\n    'use strict';\n\n    var Element;\n\n    /**\n     * Creates observable property using knockouts'\n     * 'observableArray' or 'observable' methods,\n     * depending on a type of 'value' parameter.\n     *\n     * @param {Object} obj - Object to whom property belongs.\n     * @param {String} key - Key of the property.\n     * @param {*} value - Initial value.\n     */\n    function observable(obj, key, value) {\n        var method = Array.isArray(value) ? 'observableArray' : 'observable';\n\n        if (_.isFunction(obj[key]) && !ko.isObservable(obj[key])) {\n            return;\n        }\n\n        if (ko.isObservable(value)) {\n            value = value();\n        }\n\n        ko.isObservable(obj[key]) ?\n            obj[key](value) :\n            obj[key] = ko[method](value);\n    }\n\n    /**\n     * Creates observable property using 'track' method.\n     *\n     * @param {Object} obj - Object to whom property belongs.\n     * @param {String} key - Key of the property.\n     * @param {*} value - Initial value.\n     */\n    function accessor(obj, key, value) {\n        if (_.isFunction(obj[key]) || ko.isObservable(obj[key])) {\n            return;\n        }\n\n        obj[key] = value;\n\n        if (!ko.es5.isTracked(obj, key)) {\n            ko.track(obj, [key]);\n        }\n    }\n\n    Element = _.extend({\n        defaults: {\n            _requested: {},\n            containers: [],\n            exports: {},\n            imports: {},\n            links: {},\n            listens: {},\n            name: '',\n            ns: '${ $.name.split(\".\")[0] }',\n            provider: '',\n            registerNodes: true,\n            source: null,\n            statefull: {},\n            template: '',\n            tracks: {},\n            storageConfig: {\n                provider: 'localStorage',\n                namespace: '${ $.name }',\n                path: '${ $.storageConfig.provider }:${ $.storageConfig.namespace }'\n            },\n            maps: {\n                imports: {},\n                exports: {}\n            },\n            modules: {\n                storage: '${ $.storageConfig.provider }'\n            }\n        },\n\n        /**\n         * Initializes model instance.\n         *\n         * @returns {Element} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initObservable()\n                .initModules()\n                .initStatefull()\n                .initLinks()\n                .initUnique();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Element} Chainable.\n         */\n        initObservable: function () {\n            _.each(this.tracks, function (enabled, key) {\n                if (enabled) {\n                    this.track(key);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Parses 'modules' object and creates\n         * async wrappers for specified components.\n         *\n         * @returns {Element} Chainable.\n         */\n        initModules: function () {\n            _.each(this.modules, function (name, property) {\n                if (name) {\n                    this[property] = this.requestModule(name);\n                }\n            }, this);\n\n            if (!_.isFunction(this.source)) {\n                this.source = registry.get(this.provider);\n            }\n\n            return this;\n        },\n\n        /**\n         * Called when current element was injected to another component.\n         *\n         * @param {Object} parent - Instance of a 'parent' component.\n         * @returns {Collection} Chainable.\n         */\n        initContainer: function (parent) {\n            this.containers.push(parent);\n\n            return this;\n        },\n\n        /**\n         * Initializes statefull properties\n         * based on the keys of 'statefull' object.\n         *\n         * @returns {Element} Chainable.\n         */\n        initStatefull: function () {\n            _.each(this.statefull, function (path, key) {\n                if (path) {\n                    this.setStatefull(key, path);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Initializes links between properties.\n         *\n         * @returns {Element} Chainbale.\n         */\n        initLinks: function () {\n            return this.setListeners(this.listens)\n                       .setLinks(this.links, 'imports')\n                       .setLinks(this.links, 'exports')\n                       .setLinks(this.exports, 'exports')\n                       .setLinks(this.imports, 'imports');\n        },\n\n        /**\n         * Initializes listeners of the unique property.\n         *\n         * @returns {Element} Chainable.\n         */\n        initUnique: function () {\n            var update = this.onUniqueUpdate.bind(this),\n                uniqueNs = this.uniqueNs;\n\n            this.hasUnique = this.uniqueProp && uniqueNs;\n\n            if (this.hasUnique) {\n                this.source.on(uniqueNs, update, this.name);\n            }\n\n            return this;\n        },\n\n        /**\n         * Makes specified property to be stored automatically.\n         *\n         * @param {String} key - Name of the property\n         *      that will be stored.\n         * @param {String} [path=key] - Path to the property in storage.\n         * @returns {Element} Chainable.\n         */\n        setStatefull: function (key, path) {\n            var link = {};\n\n            path        = !_.isString(path) || !path ? key : path;\n            link[key]   = this.storageConfig.path + '.' + path;\n\n            this.setLinks(link, 'imports')\n                .setLinks(link, 'exports');\n\n            return this;\n        },\n\n        /**\n         * Updates property specified in uniqueNs\n         * if elements' unique property is set to 'true'.\n         *\n         * @returns {Element} Chainable.\n         */\n        setUnique: function () {\n            var property = this.uniqueProp;\n\n            if (this[property]()) {\n                this.source.set(this.uniqueNs, this.name);\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates 'async' wrapper for the specified component\n         * using uiRegistry 'async' method and caches it\n         * in a '_requested' components  object.\n         *\n         * @param {String} name - Name of requested component.\n         * @returns {Function} Async module wrapper.\n         */\n        requestModule: function (name) {\n            var requested = this._requested;\n\n            if (!requested[name]) {\n                requested[name] = registry.async(name);\n            }\n\n            return requested[name];\n        },\n\n        /**\n         * Returns path to elements' template.\n         *\n         * @returns {String}\n         */\n        getTemplate: function () {\n            return this.template;\n        },\n\n        /**\n         * Checks if template was specified for an element.\n         *\n         * @returns {Boolean}\n         */\n        hasTemplate: function () {\n            return !!this.template;\n        },\n\n        /**\n         * Returns value of the nested property.\n         *\n         * @param {String} path - Path to the property.\n         * @returns {*} Value of the property.\n         */\n        get: function (path) {\n            return utils.nested(this, path);\n        },\n\n        /**\n         * Sets provided value as a value of the specified nested property.\n         * Triggers changes notifications, if value has mutated.\n         *\n         * @param {String} path - Path to property.\n         * @param {*} value - New value of the property.\n         * @returns {Element} Chainable.\n         */\n        set: function (path, value) {\n            var data = this.get(path),\n                diffs;\n\n            diffs = !_.isFunction(data) && !this.isTracked(path) ?\n                utils.compare(data, value, path) :\n                false;\n\n            utils.nested(this, path, value);\n\n            if (diffs) {\n                this._notifyChanges(diffs);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes nested property from the object.\n         *\n         * @param {String} path - Path to the property.\n         * @returns {Element} Chainable.\n         */\n        remove: function (path) {\n            var data = utils.nested(this, path),\n                diffs;\n\n            if (_.isUndefined(data) || _.isFunction(data)) {\n                return this;\n            }\n\n            diffs = utils.compare(data, undefined, path);\n\n            utils.nestedRemove(this, path);\n\n            this._notifyChanges(diffs);\n\n            return this;\n        },\n\n        /**\n         * Creates observable properties for the current object.\n         *\n         * If 'useTrack' flag is set to 'true' then each property will be\n         * created with a ES5 get/set accessor descriptors, instead of\n         * making them an observable functions.\n         * See 'knockout-es5' library for more information.\n         *\n         * @param {Boolean} [useAccessors=false] - Whether to create an\n         *      observable function or to use property accesessors.\n         * @param {(Object|String|Array)} properties - List of observable properties.\n         * @returns {Element} Chainable.\n         *\n         * @example Sample declaration and equivalent knockout methods.\n         *      this.key = 'value';\n         *      this.array = ['value'];\n         *\n         *      this.observe(['key', 'array']);\n         *      =>\n         *          this.key = ko.observable('value');\n         *          this.array = ko.observableArray(['value']);\n         *\n         * @example Another syntaxes of the previous example.\n         *      this.observe({\n         *          key: 'value',\n         *          array: ['value']\n         *      });\n         */\n        observe: function (useAccessors, properties) {\n            var model = this,\n                trackMethod;\n\n            if (typeof useAccessors !== 'boolean') {\n                properties   = useAccessors;\n                useAccessors = false;\n            }\n\n            trackMethod = useAccessors ? accessor : observable;\n\n            if (_.isString(properties)) {\n                properties = properties.split(' ');\n            }\n\n            if (Array.isArray(properties)) {\n                properties.forEach(function (key) {\n                    trackMethod(model, key, model[key]);\n                });\n            } else if (typeof properties === 'object') {\n                _.each(properties, function (value, key) {\n                    trackMethod(model, key, value);\n                });\n            }\n\n            return this;\n        },\n\n        /**\n         * Delegates call to 'observe' method but\n         * with a predefined 'useAccessors' flag.\n         *\n         * @param {(String|Array|Object)} properties - List of observable properties.\n         * @returns {Element} Chainable.\n         */\n        track: function (properties) {\n            this.observe(true, properties);\n\n            return this;\n        },\n\n        /**\n         * Checks if specified property is tracked.\n         *\n         * @param {String} property - Property to be checked.\n         * @returns {Boolean}\n         */\n        isTracked: function (property) {\n            return ko.es5.isTracked(this, property);\n        },\n\n        /**\n         * Invokes subscribers for the provided changes.\n         *\n         * @param {Object} diffs - Object with changes descriptions.\n         * @returns {Element} Chainable.\n         */\n        _notifyChanges: function (diffs) {\n            diffs.changes.forEach(function (change) {\n                this.trigger(change.path, change.value, change);\n            }, this);\n\n            _.each(diffs.containers, function (changes, name) {\n                var value = utils.nested(this, name);\n\n                this.trigger(name, value, changes);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Extracts all stored data and sets it to element.\n         *\n         * @returns {Element} Chainable.\n         */\n        restore: function () {\n            var ns = this.storageConfig.namespace,\n                storage = this.storage();\n\n            if (storage) {\n                utils.extend(this, storage.get(ns));\n            }\n\n            return this;\n        },\n\n        /**\n         * Stores value of the specified property in components' storage module.\n         *\n         * @param {String} property\n         * @param {*} [data=this[property]]\n         * @returns {Element} Chainable.\n         */\n        store: function (property, data) {\n            var ns = this.storageConfig.namespace,\n                path = utils.fullPath(ns, property);\n\n            if (arguments.length < 2) {\n                data = this.get(property);\n            }\n\n            this.storage('set', path, data);\n\n            return this;\n        },\n\n        /**\n         * Extracts specified property from storage.\n         *\n         * @param {String} [property] - Name of the property\n         *      to be extracted. If not specified then all of the\n         *      stored will be returned.\n         * @returns {*}\n         */\n        getStored: function (property) {\n            var ns = this.storageConfig.namespace,\n                path = utils.fullPath(ns, property),\n                storage = this.storage(),\n                data;\n\n            if (storage) {\n                data = storage.get(path);\n            }\n\n            return data;\n        },\n\n        /**\n         * Removes stored property.\n         *\n         * @param {String} property - Property to be removed from storage.\n         * @returns {Element} Chainable.\n         */\n        removeStored: function (property) {\n            var ns = this.storageConfig.namespace,\n                path = utils.fullPath(ns, property);\n\n            this.storage('remove', path);\n\n            return this;\n        },\n\n        /**\n         * Destroys current instance along with all of its' children.\n         * @param {Boolean} skipUpdate - skip collection update when element to be destroyed.\n         */\n        destroy: function (skipUpdate) {\n            this._dropHandlers()\n                ._clearRefs(skipUpdate);\n        },\n\n        /**\n         * Removes events listeners.\n         * @private\n         *\n         * @returns {Element} Chainable.\n         */\n        _dropHandlers: function () {\n            this.off();\n\n            if (_.isFunction(this.source)) {\n                this.source().off(this.name);\n            } else if (this.source) {\n                this.source.off(this.name);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes all references to current instance and\n         * calls 'destroy' method on all of its' children.\n         * @private\n         * @param {Boolean} skipUpdate - skip collection update when element to be destroyed.\n         *\n         * @returns {Element} Chainable.\n         */\n        _clearRefs: function (skipUpdate) {\n            registry.remove(this.name);\n\n            this.containers.forEach(function (parent) {\n                parent.removeChild(this, skipUpdate);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Overrides 'EventsBus.trigger' method to implement events bubbling.\n         *\n         * @param {...*} arguments - Any number of arguments that should be passed to the events' handler.\n         * @returns {Boolean} False if event bubbling was canceled.\n         */\n        bubble: function () {\n            var args = _.toArray(arguments),\n                bubble = this.trigger.apply(this, args),\n                result;\n\n            if (!bubble) {\n                return false;\n            }\n\n            this.containers.forEach(function (parent) {\n                result = parent.bubble.apply(parent, args);\n\n                if (result === false) {\n                    bubble = false;\n                }\n            });\n\n            return !!bubble;\n        },\n\n        /**\n         * Callback which fires when property under uniqueNs has changed.\n         */\n        onUniqueUpdate: function (name) {\n            var active = name === this.name,\n                property = this.uniqueProp;\n\n            this[property](active);\n        },\n\n        /**\n         * Clean data form data source.\n         *\n         * @returns {Element}\n         */\n        cleanData: function () {\n            if (this.source && this.source.componentType === 'dataSource') {\n                if (this.elems) {\n                    _.each(this.elems(), function (val) {\n                        val.cleanData();\n                    });\n                } else {\n                    this.source.remove(this.dataScope);\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Fallback data.\n         */\n        cacheData: function () {\n            this.cachedComponent = utils.copy(this);\n        },\n\n        /**\n         * Update configuration in component.\n         *\n         * @param {*} oldValue\n         * @param {*} newValue\n         * @param {String} path - path to value.\n         * @returns {Element}\n         */\n        updateConfig: function (oldValue, newValue, path) {\n            var names = path.split('.'),\n                index = _.lastIndexOf(names, 'config') + 1;\n\n            names = names.splice(index, names.length - index).join('.');\n            this.set(names, newValue);\n\n            return this;\n        }\n    }, Events, links);\n\n    return Class.extend(Element);\n});\n","Magento_Ui/js/lib/core/element/links.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiRegistry'\n], function (ko, _, utils, registry) {\n    'use strict';\n\n    /**\n     * Parse provided data.\n     *\n     * @param {String} placeholder\n     * @param {String} data\n     * @param {String} direction\n     * @returns {Boolean|Object}\n     */\n    function parseData(placeholder, data, direction) {\n        if (typeof data !== 'string') {\n            return false;\n        }\n\n        data = data.split(':');\n\n        if (!data[0]) {\n            return false;\n        }\n\n        if (!data[1]) {\n            data[1] = data[0];\n            data[0] = placeholder;\n        }\n\n        return {\n            target: data[0],\n            property: data[1],\n            direction: direction\n        };\n    }\n\n    /**\n     * Check if value not empty.\n     *\n     * @param {*} value\n     * @returns {Boolean}\n     */\n    function notEmpty(value) {\n        return typeof value !== 'undefined' && value != null;\n    }\n\n    /**\n     * Update value for linked component.\n     *\n     * @param {Object} data\n     * @param {Object} owner\n     * @param {Object} target\n     * @param {*} value\n     */\n    function updateValue(data, owner, target, value) {\n        var component = target.component,\n            property = target.property,\n            linked = data.linked;\n\n        if (data.mute) {\n            return;\n        }\n\n        if (linked) {\n            linked.mute = true;\n        }\n\n        if (owner.component !== target.component) {\n            value = data.inversionValue ? !utils.copy(value) : utils.copy(value);\n        }\n\n        component.set(property, value, owner);\n\n        if (linked) {\n            linked.mute = false;\n        }\n    }\n\n    /**\n     * Get value form owner component property.\n     *\n     * @param {Object} owner\n     * @returns {*}\n     */\n    function getValue(owner) {\n        var component = owner.component,\n            property = owner.property;\n\n        return component.get(property);\n    }\n\n    /**\n     * Format provided params to object.\n     *\n     * @param {String} ownerComponent\n     * @param {String} targetComponent\n     * @param {String} ownerProp\n     * @param {String} targetProp\n     * @param {String} direction\n     * @returns {Object}\n     */\n    function form(ownerComponent, targetComponent, ownerProp, targetProp, direction) {\n        var result,\n            tmp;\n\n        result = {\n            owner: {\n                component: ownerComponent,\n                property: ownerProp\n            },\n            target: {\n                component: targetComponent,\n                property: targetProp\n            }\n        };\n\n        if (direction === 'exports') {\n            tmp = result.owner;\n            result.owner = result.target;\n            result.target = tmp;\n        }\n\n        return result;\n    }\n\n    /**\n     * Set data to linked property.\n     *\n     * @param {Object} map\n     * @param {Object} data\n     */\n    function setLinked(map, data) {\n        var match;\n\n        if (!map) {\n            return;\n        }\n\n        match = _.findWhere(map, {\n            linked: false,\n            target: data.target,\n            property: data.property\n        });\n\n        if (match) {\n            match.linked = data;\n            data.linked = match;\n        }\n    }\n\n    /**\n     * Set data by direction.\n     *\n     * @param {Object} maps\n     * @param {String} property\n     * @param {Object} data\n     */\n    function setData(maps, property, data) {\n        var direction   = data.direction,\n            map         = maps[direction];\n\n        data.linked = false;\n\n        (map[property] = map[property] || []).push(data);\n\n        direction = direction === 'imports' ? 'exports' : 'imports';\n\n        setLinked(maps[direction][property], data);\n    }\n\n    /**\n     * Set links for components.\n     *\n     * @param {String} target\n     * @param {String} owner\n     * @param {Object} data\n     * @param {String} property\n     * @param {Boolean} immediate\n     */\n    function setLink(target, owner, data, property, immediate) {\n        var direction = data.direction,\n            formated = form(target, owner, data.property, property, direction),\n            callback,\n            value;\n\n        owner = formated.owner;\n        target = formated.target;\n\n        callback = updateValue.bind(null, data, owner, target);\n\n        owner.component.on(owner.property, callback, target.component.name);\n\n        if (immediate) {\n            value = getValue(owner);\n\n            if (notEmpty(value)) {\n                updateValue(data, owner, target, value);\n            }\n        }\n    }\n\n    /**\n     * Transfer data between components.\n     *\n     * @param {Object} owner\n     * @param {Object} data\n     */\n    function transfer(owner, data) {\n        var args = _.toArray(arguments);\n\n        if (data.target.substr(0, 1) === '!') {\n            data.target = data.target.substr(1);\n            data.inversionValue = true;\n        }\n\n        if (owner.name === data.target) {\n            args.unshift(owner);\n\n            setLink.apply(null, args);\n        } else {\n            registry.get(data.target, function (target) {\n                args.unshift(target);\n\n                setLink.apply(null, args);\n            });\n        }\n    }\n\n    return {\n        /**\n         * Assign listeners.\n         *\n         * @param {Object} listeners\n         * @returns {Object} Chainable\n         */\n        setListeners: function (listeners) {\n            var owner = this,\n                data;\n\n            _.each(listeners, function (callbacks, sources) {\n                sources = sources.split(' ');\n                callbacks = callbacks.split(' ');\n\n                sources.forEach(function (target) {\n                    callbacks.forEach(function (callback) {//eslint-disable-line max-nested-callbacks\n                        data = parseData(owner.name, target, 'imports');\n\n                        if (data) {\n                            setData(owner.maps, callback, data);\n                            transfer(owner, data, callback);\n                        }\n                    });\n                });\n            });\n\n            return this;\n        },\n\n        /**\n         * Set links in provided direction.\n         *\n         * @param {Object} links\n         * @param {String} direction\n         * @returns {Object} Chainable\n         */\n        setLinks: function (links, direction) {\n            var owner = this,\n                property,\n                data;\n\n            for (property in links) {\n                if (links.hasOwnProperty(property)) {\n                    data = parseData(owner.name, links[property], direction);\n\n                    if (data) {//eslint-disable-line max-depth\n                        setData(owner.maps, property, data);\n                        transfer(owner, data, property, true);\n                    }\n                }\n            }\n\n            return this;\n        }\n    };\n});\n","Magento_Ui/js/lib/core/storage/local.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiEvents'\n], function (_, registry, utils, EventsBus) {\n    'use strict';\n\n    var root = 'appData',\n        localStorage,\n        hasSupport,\n        storage;\n\n    /**\n     * Flag which indicates whether localStorage is supported.\n     */\n    hasSupport = (function () {\n        var key = '_storageSupported';\n\n        try {\n            localStorage = window.localStorage;\n            localStorage.setItem(key, 'true');\n\n            if (localStorage.getItem(key) === 'true') {\n                localStorage.removeItem(key);\n\n                return true;\n            }\n\n            return false;\n        } catch (e) {\n            return false;\n        }\n    })();\n\n    if (!hasSupport) {\n        localStorage = {\n            _data: {},\n\n            /**\n             * Sets value of the specified item.\n             *\n             * @param {String} key - Key of the property.\n             * @param {*} value - Properties' value.\n             */\n            setItem: function (key, value) {\n                this._data[key] = value + '';\n            },\n\n            /**\n             * Retrieves specified item.\n             *\n             * @param {String} key - Key of the property to be retrieved.\n             */\n            getItem: function (key) {\n                return this._data[key];\n            },\n\n            /**\n             * Removes specified item.\n             *\n             * @param {String} key - Key of the property to be removed.\n             */\n            removeItem: function (key) {\n                delete this._data[key];\n            },\n\n            /**\n             * Removes all items.\n             */\n            clear: function () {\n                this._data = {};\n            }\n        };\n    }\n\n    /**\n     * Extracts and parses data stored in localStorage by the\n     * key specified in 'root' variable.\n     *\n     * @returns {Object}\n     */\n    function getRoot() {\n        var data = localStorage.getItem(root),\n            result = {};\n\n        if (!_.isNull(data) && typeof data != 'undefined') {\n            result = JSON.parse(data);\n        }\n\n        return result;\n    }\n\n    /**\n     * Writes provided data to the localStorage.\n     *\n     * @param {*} data - Data to be stored.\n     */\n    function setRoot(data) {\n        localStorage.setItem(root, JSON.stringify(data));\n    }\n\n    /**\n     * Provides methods to work with a localStorage\n     * as a single nested structure.\n     */\n    storage = _.extend({\n\n        /**\n         * Retrieves value of the specified property.\n         *\n         * @param {String} path - Path to the property.\n         *\n         * @example Retrieving data.\n         *      localStorage =>\n         *          'appData' => '\n         *              \"one\": {\"two\": \"three\"}\n         *          '\n         *      storage.get('one.two')\n         *      => \"three\"\n         *\n         *      storage.get('one')\n         *      => {\"two\": \"three\"}\n         */\n        get: function (path) {\n            var data = getRoot();\n\n            return utils.nested(data, path);\n        },\n\n        /**\n         * Sets specified data to the localStorage.\n         *\n         * @param {String} path - Path of the property.\n         * @param {*} value - Value of the property.\n         *\n         * @example Setting data.\n         *      storage.set('one.two', 'four');\n         *      => localStorage =>\n         *          'appData' => '\n         *              \"one\": {\"two\": \"four\"}\n         *          '\n         */\n        set: function (path, value) {\n            var data = getRoot();\n\n            utils.nested(data, path, value);\n\n            setRoot(data);\n        },\n\n        /**\n         * Removes specified data from the localStorage.\n         *\n         * @param {String} path - Path to the property that should be removed.\n         *\n         * @example Removing data.\n         *      storage.remove('one.two', 'four');\n         *      => localStorage =>\n         *          'appData' => '\n         *              \"one\": {}\n         *          '\n         */\n        remove: function (path) {\n            var data = getRoot();\n\n            utils.nestedRemove(data, path);\n\n            setRoot(data);\n        }\n    }, EventsBus);\n\n    registry.set('localStorage', storage);\n\n    return storage;\n});\n","Magento_Ui/js/lib/view/utils/dom-observer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'MutationObserver',\n    'domReady!'\n], function ($, _) {\n    'use strict';\n\n    var counter = 1,\n        watchers,\n        globalObserver,\n        disabledNodes = [];\n\n    watchers = {\n        selectors: {},\n        nodes: {}\n    };\n\n    /**\n     * Checks if node represents an element node (nodeType === 1).\n     *\n     * @param {HTMLElement} node\n     * @returns {Boolean}\n     */\n    function isElementNode(node) {\n        return node.nodeType === 1;\n    }\n\n    /**\n     * Extracts all child descendant\n     * elements of a specified node.\n     *\n     * @param {HTMLElement} node\n     * @returns {Array}\n     */\n    function extractChildren(node) {\n        var children = node.querySelectorAll('*');\n\n        return _.toArray(children);\n    }\n\n    /**\n     * Extracts node identifier. If ID is not specified,\n     * then it will be created for the provided node.\n     *\n     * @param {HTMLElement} node\n     * @returns {Number}\n     */\n    function getNodeId(node) {\n        var id = node._observeId;\n\n        if (!id) {\n            id = node._observeId = counter++;\n        }\n\n        return id;\n    }\n\n    /**\n     * Invokes callback passing node to it.\n     *\n     * @param {HTMLElement} node\n     * @param {Object} data\n     */\n    function trigger(node, data) {\n        var id = getNodeId(node),\n            ids = data.invoked;\n\n        if (_.contains(ids, id)) {\n            return;\n        }\n\n        data.callback(node);\n        data.invoked.push(id);\n    }\n\n    /**\n     * Adds node to the observer list.\n     *\n     * @param {HTMLElement} node\n     * @returns {Object}\n     */\n    function createNodeData(node) {\n        var nodes   = watchers.nodes,\n            id      = getNodeId(node);\n\n        nodes[id] = nodes[id] || {};\n\n        return nodes[id];\n    }\n\n    /**\n     * Returns data associated with a specified node.\n     *\n     * @param {HTMLElement} node\n     * @returns {Object|Undefined}\n     */\n    function getNodeData(node) {\n        var nodeId = node._observeId;\n\n        return watchers.nodes[nodeId];\n    }\n\n    /**\n     * Removes data associated with a specified node.\n     *\n     * @param {HTMLElement} node\n     */\n    function removeNodeData(node) {\n        var nodeId = node._observeId;\n\n        delete watchers.nodes[nodeId];\n    }\n\n    /**\n     * Adds removal listener for a specified node.\n     *\n     * @param {HTMLElement} node\n     * @param {Object} data\n     */\n    function addRemovalListener(node, data) {\n        var nodeData = createNodeData(node);\n\n        (nodeData.remove = nodeData.remove || []).push(data);\n    }\n\n    /**\n     * Adds listener for the nodes which matches specified selector.\n     *\n     * @param {String} selector - CSS selector.\n     * @param {Object} data\n     */\n    function addSelectorListener(selector, data) {\n        var storage = watchers.selectors;\n\n        (storage[selector] = storage[selector] || []).push(data);\n    }\n\n    /**\n     * Calls handlers associated with an added node.\n     * Adds listeners for the node removal.\n     *\n     * @param {HTMLElement} node - Added node.\n     */\n    function processAdded(node) {\n        _.each(watchers.selectors, function (listeners, selector) {\n            listeners.forEach(function (data) {\n                if (!data.ctx.contains(node) || !$(node, data.ctx).is(selector)) {\n                    return;\n                }\n\n                if (data.type === 'add') {\n                    trigger(node, data);\n                } else if (data.type === 'remove') {\n                    addRemovalListener(node, data);\n                }\n            });\n        });\n    }\n\n    /**\n     * Calls handlers associated with a removed node.\n     *\n     * @param {HTMLElement} node - Removed node.\n     */\n    function processRemoved(node) {\n        var nodeData    = getNodeData(node),\n            listeners   = nodeData && nodeData.remove;\n\n        if (!listeners) {\n            return;\n        }\n\n        listeners.forEach(function (data) {\n            trigger(node, data);\n        });\n\n        removeNodeData(node);\n    }\n\n    /**\n     * Removes all non-element nodes from provided array\n     * and appends to it descendant elements.\n     *\n     * @param {Array} nodes\n     * @returns {Array}\n     */\n    function formNodesList(nodes) {\n        var result = [],\n            children;\n\n        nodes = _.toArray(nodes).filter(isElementNode);\n\n        nodes.forEach(function (node) {\n            result.push(node);\n\n            children = extractChildren(node);\n            result   = result.concat(children);\n        });\n\n        return result;\n    }\n\n    /**\n     * Collects all removed and added nodes from\n     * mutation records into separate arrays\n     * while removing duplicates between both types of changes.\n     *\n     * @param {Array} mutations - An array of mutation records.\n     * @returns {Object} Object with 'removed' and 'added' nodes arrays.\n     */\n    function formChangesLists(mutations) {\n        var removed = [],\n            added = [];\n\n        mutations.forEach(function (record) {\n            removed = removed.concat(_.toArray(record.removedNodes));\n            added   = added.concat(_.toArray(record.addedNodes));\n        });\n\n        removed = removed.filter(function (node) {\n            var addIndex = added.indexOf(node),\n                wasAdded = !!~addIndex;\n\n            if (wasAdded) {\n                added.splice(addIndex, 1);\n            }\n\n            return !wasAdded;\n        });\n\n        return {\n            removed: formNodesList(removed),\n            added: formNodesList(added)\n        };\n    }\n\n    /**\n     * Verify if the DOM node is a child of a defined disabled node, if so we shouldn't observe provided mutation.\n     *\n     * @param {Object} mutation - a single mutation\n     * @returns {Boolean}\n     */\n    function shouldObserveMutation(mutation) {\n        var isDisabled;\n\n        if (disabledNodes.length > 0) {\n            // Iterate through the disabled nodes and determine if this mutation is occurring inside one of them\n            isDisabled = _.find(disabledNodes, function (node) {\n                return node === mutation.target || $.contains(node, mutation.target);\n            });\n\n            // If we find a matching node we should not observe the mutation\n            return !isDisabled;\n        }\n\n        return true;\n    }\n\n    /**\n     * Should we observe these mutations? Check the first and last mutation to determine if this is a disabled mutation,\n     * we check both the first and last in case one has been removed from the DOM during the process of the mutation.\n     *\n     * @param {Array} mutations - An array of mutation records.\n     * @returns {Boolean}\n     */\n    function shouldObserveMutations(mutations) {\n        var firstMutation,\n            lastMutation;\n\n        if (mutations.length > 0) {\n            firstMutation = mutations[0];\n            lastMutation = mutations[mutations.length - 1];\n\n            return shouldObserveMutation(firstMutation) && shouldObserveMutation(lastMutation);\n        }\n\n        return true;\n    }\n\n    globalObserver = new MutationObserver(function (mutations) {\n        var changes;\n\n        if (shouldObserveMutations(mutations)) {\n            changes = formChangesLists(mutations);\n\n            changes.removed.forEach(processRemoved);\n            changes.added.forEach(processAdded);\n        }\n    });\n\n    globalObserver.observe(document.body, {\n        subtree: true,\n        childList: true\n    });\n\n    return {\n        /**\n         * Disable a node from being observed by the mutations, you may want to disable specific aspects of the\n         * application which are heavy on DOM changes. The observer running on some actions could cause significant\n         * delays and degrade the performance of that specific part of the application exponentially.\n         *\n         * @param {HTMLElement} node - a HTML node within the document\n         */\n        disableNode: function (node) {\n            disabledNodes.push(node);\n        },\n\n        /**\n         * Adds listener for the appearance of nodes that matches provided\n         * selector and which are inside of the provided context. Callback will be\n         * also invoked on elements which a currently present.\n         *\n         * @param {String} selector - CSS selector.\n         * @param {Function} callback - Function that will invoked when node appears.\n         * @param {HTMLElement} [ctx=document.body] - Context inside of which to search for the node.\n         */\n        get: function (selector, callback, ctx) {\n            var data,\n                nodes;\n\n            data = {\n                ctx: ctx || document.body,\n                type: 'add',\n                callback: callback,\n                invoked: []\n            };\n\n            nodes = $(selector, data.ctx).toArray();\n\n            nodes.forEach(function (node) {\n                trigger(node, data);\n            });\n\n            addSelectorListener(selector, data);\n        },\n\n        /**\n         * Adds listener for the nodes removal.\n         *\n         * @param {(jQueryObject|HTMLElement|Array|String)} selector\n         * @param {Function} callback - Function that will invoked when node is removed.\n         * @param {HTMLElement} [ctx=document.body] - Context inside of which to search for the node.\n         */\n        remove: function (selector, callback, ctx) {\n            var nodes = [],\n                data;\n\n            data = {\n                ctx: ctx || document.body,\n                type: 'remove',\n                callback: callback,\n                invoked: []\n            };\n\n            if (typeof selector === 'object') {\n                nodes = !_.isUndefined(selector.length) ?\n                    _.toArray(selector) :\n                    [selector];\n            } else if (_.isString(selector)) {\n                nodes = $(selector, ctx).toArray();\n\n                addSelectorListener(selector, data);\n            }\n\n            nodes.forEach(function (node) {\n                addRemovalListener(node, data);\n            });\n        },\n\n        /**\n         * Removes listeners.\n         *\n         * @param {String} selector\n         * @param {Function} [fn]\n         */\n        off: function (selector, fn) {\n            var selectors = watchers.selectors,\n                listeners = selectors[selector];\n\n            if (selector && !fn) {\n                delete selectors[selector];\n            } else if (listeners && fn) {\n                selectors[selector] = listeners.filter(function (data) {\n                    return data.callback !== fn;\n                });\n            }\n        }\n    };\n});\n","Magento_Ui/js/lib/view/utils/raf.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global WeakMap */\ndefine([\n    'es6-collections'\n], function () {\n    'use strict';\n\n    var processMap = new WeakMap(),\n        origRaf,\n        raf;\n\n    origRaf = window.requestAnimationFrame ||\n        window.webkitRequestAnimationFrame ||\n        window.mozRequestAnimationFrame ||\n        window.onRequestAnimationFrame ||\n        window.msRequestAnimationFrame ||\n        function (callback) {\n            if (typeof callback != 'function') {\n                throw new Error('raf argument \"callback\" must be of type function');\n            }\n            window.setTimeout(callback, 1000 / 60);\n        };\n\n    /**\n     * Creates new process object or extracts the\n     * the existing one.\n     *\n     * @param {*} id - Process identifier.\n     * @param {Number} fps - Required FPS count.\n     * @returns {Object}\n     */\n    function getProcess(id, fps) {\n        var process = processMap.get(id);\n\n        if (!process) {\n            process = {};\n            processMap.set(id, process);\n        }\n\n        if (process.fps !== fps) {\n            process.fps        = fps;\n            process.interval   = 1000 / fps;\n            process.update     = Date.now();\n        }\n\n        return process;\n    }\n\n    /**\n     * Proxy method which delegates call to the 'requestAnimationFrame'\n     * function and optionally can keep track of the FPS with which\n     * provided function is called.\n     *\n     * @param {Function} callback - Callback function to be passed to 'requestAnimationFrame'.\n     * @param {Number} [fps] - If specified, will update FPS counter for the provided function.\n     * @returns {Number|Boolean} ID of request or a flag which indicates\n     *      whether callback fits specified FPS.\n     */\n    raf = function (callback, fps) {\n        var rafId = origRaf(callback);\n\n        return fps ? raf.tick(callback, fps) : rafId;\n    };\n\n    /**\n     * Updates FPS counter for the specified process\n     * and returns a flag which indicates whether\n     * counter value is equal or greater than the required FPS.\n     *\n     * @param {*} id - Process identifier.\n     * @param {Number} fps - Required FPS count.\n     * @returns {Boolean}\n     */\n    raf.tick = function (id, fps) {\n        var process  = getProcess(id, fps),\n            now      = Date.now(),\n            delta    = now - process.update,\n            interval = process.interval;\n\n        if (fps >= 60 || delta >= interval) {\n            process.update = now - delta % interval;\n\n            return true;\n        }\n\n        return false;\n    };\n\n    return raf;\n});\n","Magento_Ui/js/lib/view/utils/async.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    './dom-observer',\n    'Magento_Ui/js/lib/knockout/extender/bound-nodes',\n    './bindings'\n], function (ko, $, _, registry, domObserver, boundedNodes) {\n    'use strict';\n\n    /**\n     * Checks if provided value is a dom element.\n     *\n     * @param {*} node - Value to be checked.\n     * @returns {Boolean}\n     */\n    function isDomElement(node) {\n        return typeof node === 'object' && node.tagName && node.nodeType;\n    }\n\n    /**\n     * Parses provided string and extracts\n     * component, context and selector data from it.\n     *\n     * @param {String} str - String to be processed.\n     * @returns {Object} Data retrieved from string.\n     *\n     * @example Sample format.\n     *      '{{component}}:{{ctx}} -> {{selector}}'\n     *\n     *      component - Name of component.\n     *      ctx - Selector of the root node upon which component is binded.\n     *      selector - Selector of DOM elements located\n     *          inside of a previously specified context.\n     */\n    function parseSelector(str) {\n        var data    = str.trim().split('->'),\n            result  = {},\n            componentData;\n\n        if (data.length === 1) {\n            if (!~data[0].indexOf(':')) {\n                result.selector = data[0];\n            } else {\n                componentData = data[0];\n            }\n        } else {\n            componentData   = data[0];\n            result.selector = data[1];\n        }\n\n        if (componentData) {\n            componentData = componentData.split(':');\n\n            result.component = componentData[0];\n            result.ctx = componentData[1];\n        }\n\n        _.each(result, function (value, key) {\n            result[key] = value.trim();\n        });\n\n        return result;\n    }\n\n    /**\n     * Internal method used to normalize argumnets passed\n     * to 'async' module methods.\n     *\n     * @param {(String|Objetc)} selector\n     * @param {(HTMLElement|Object|String)} [ctx]\n     * @returns {Object}\n     */\n    function parseData(selector, ctx) {\n        var data = {};\n\n        if (arguments.length === 2) {\n            data.selector = selector;\n\n            if (isDomElement(ctx)) {\n                data.ctx = ctx;\n            } else {\n                data.component = ctx;\n                data.ctx = '*';\n            }\n        } else {\n            data = _.isString(selector) ?\n                parseSelector(selector) :\n                selector;\n        }\n\n        return data;\n    }\n\n    /**\n     * Creates promise that will be resolved\n     * when requested component is registred.\n     *\n     * @param {String} name - Name of component.\n     * @returns {jQueryPromise}\n     */\n    function waitComponent(name) {\n        var deffer = $.Deferred();\n\n        if (_.isString(name)) {\n            registry.get(name, function (component) {\n                deffer.resolve(component);\n            });\n        } else {\n            deffer.resolve(name);\n        }\n\n        return deffer.promise();\n    }\n\n    /**\n     * Creates listener for the nodes binded to provided component.\n     *\n     * @param {Object} data - Listener data.\n     * @param {Object} component - Associated with nodes component.\n     */\n    function setRootListener(data, component) {\n        boundedNodes.get(component, function (root) {\n            if (!$(root).is(data.ctx || '*')) {\n                return;\n            }\n\n            data.selector ?\n                domObserver.get(data.selector, data.fn, root) :\n                data.fn(root);\n        });\n    }\n\n    /*eslint-disable no-unused-vars*/\n    /**\n     * Sets listener for the appearance of elements which\n     * matches specified selector data.\n     *\n     * @param {(String|Object)} selector - Valid css selector or a string\n     *      in format acceptable by 'parseSelector' method or an object with\n     *      'component', 'selector' and 'ctx' properties.\n     * @param {(HTMLElement|Object|String)} [ctx] - Optional context parameter\n     *      which might be a DOM element, component instance or components' name.\n     * @param {Function} fn - Callback that will be invoked\n     *      when required DOM element appears.\n     *\n     * @example\n     *      Creating listener of the 'span' nodes appearance,\n     *      located inside of 'div' nodes, which are binded to 'cms_page_listing' component:\n     *\n     *      $.async('cms_page_listing:div -> span', function (node) {});\n     *\n     * @example Another syntaxes of the previous example.\n     *      $.async({\n     *          component: 'cms_page_listing',\n     *          ctx: 'div',\n     *          selector: 'span'\n     *       }, function (node) {});\n     *\n     * @example Listens for appearance of any child node inside of specified component.\n     *      $.async('> *', 'cms_page_lsiting', function (node) {});\n     *\n     * @example Listens for appearance of 'span' nodes inside of specific context.\n     *      $.async('span', document.getElementById('test'), function (node) {});\n     */\n    $.async = function (selector, ctx, fn) {\n        var args = _.toArray(arguments),\n            data = parseData.apply(null, _.initial(args));\n\n        data.fn = _.last(args);\n\n        if (data.component) {\n            waitComponent(data.component)\n                .then(setRootListener.bind(null, data));\n        } else {\n            domObserver.get(data.selector, data.fn, data.ctx);\n        }\n    };\n\n    /*eslint-enable no-unused-vars*/\n\n    _.extend($.async, {\n\n        /*eslint-disable no-unused-vars*/\n        /**\n         * Returns collection of elements found by provided selector data.\n         *\n         * @param {(String|Object)} selector - See 'async' definition.\n         * @param {(HTMLElement|Object|String)} [ctx] - See 'async' definition.\n         * @returns {Array} An array of DOM elements.\n         */\n        get: function (selector, ctx) {\n            var data        = parseData.apply(null, arguments),\n                component   = data.component,\n                nodes;\n\n            if (!component) {\n                return $(data.selector, data.ctx).toArray();\n            } else if (_.isString(component)) {\n                component = registry.get(component);\n            }\n\n            if (!component) {\n                return [];\n            }\n\n            nodes = boundedNodes.get(component);\n            nodes = $(nodes).filter(data.ctx).toArray();\n\n            return data.selector ?\n                $(data.selector, nodes).toArray() :\n                nodes;\n        },\n\n        /*eslint-enable no-unused-vars*/\n\n        /**\n         * Sets removal listener of the specified nodes.\n         *\n         * @param {(HTMLElement|Array|ArrayLike)} nodes - Nodes whose removal to track.\n         * @param {Function} fn - Callback that will be invoked when node is removed.\n         */\n        remove: function (nodes, fn) {\n            domObserver.remove(nodes, fn);\n        },\n\n        parseSelector: parseSelector\n    });\n\n    return $;\n});\n","Magento_Ui/js/lib/view/utils/bindings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore'\n], function (ko, $, _) {\n    'use strict';\n\n    /**\n     * Checks if provided  value is a dom element.\n     *\n     * @param {*} node - Value to be checked.\n     * @returns {Boolean}\n     */\n    function isDomElement(node) {\n        return typeof node === 'object' && node.tagName && node.nodeType;\n    }\n\n    /**\n     * Removes from the provided array all non-root nodes located inside\n     * of the comment element as long as the closing comment tags.\n     *\n     * @param {(Array|ArrayLike)} nodes - An array of nodes to be processed.\n     * @returns {Array}\n     */\n    function normalize(nodes) {\n        var result;\n\n        nodes   = _.toArray(nodes);\n        result  = nodes.slice();\n\n        nodes.forEach(function (node) {\n            if (node.nodeType === 8) {\n                result = !ko.virtualElements.hasBindingValue(node) ?\n                    _.without(result, node) :\n                    _.difference(result, ko.virtualElements.childNodes(node));\n            }\n        });\n\n        return result;\n    }\n\n    /**\n     * Extends binding context of each item in the collection.\n     *\n     * @param {...Object} extenders - Multiple extender objects to be applied to the context.\n     * @returns {jQueryCollection} Chainable.\n     */\n    $.fn.extendCtx = function () {\n        var nodes       = normalize(this),\n            extenders   = _.toArray(arguments);\n\n        nodes.forEach(function (node) {\n            var ctx  = ko.contextFor(node),\n                data = [ctx].concat(extenders);\n\n            _.extend.apply(_, data);\n        });\n\n        return this;\n    };\n\n    /**\n     * Evaluates bindings specified in each DOM element of collection.\n     *\n     * @param {(HTMLElement|Object)} [ctx] - Context to use for bindings evaluation.\n     *      If not specified then current context of a collections' item will be used.\n     * @returns {jQueryCollection} Chainable.\n     */\n    $.fn.applyBindings = function (ctx) {\n        var nodes = normalize(this),\n            nodeCtx;\n\n        if (isDomElement(ctx)) {\n            ctx = ko.contextFor(ctx);\n        }\n\n        nodes.forEach(function (node) {\n            nodeCtx = ctx || ko.contextFor(node);\n\n            ko.applyBindings(nodeCtx, node);\n        });\n\n        return this;\n    };\n\n    /**\n     * Adds specified bindings to each DOM element in\n     * collection and evaluates them with provided context.\n     *\n     * @param {(Object|Function)} data - Either bindings object or a function\n     *      which returns bindings data for each element in collection.\n     * @param {(HTMLElement|Object)} [ctx] - Context to use for bindings evaluation.\n     *      If not specified then current context of a collections' item will be used.\n     * @returns {jQueryCollection} Chainable.\n     */\n    $.fn.bindings = function (data, ctx) {\n        var nodes    = normalize(this),\n            bindings = data,\n            nodeCtx;\n\n        if (isDomElement(ctx)) {\n            ctx = ko.contextFor(ctx);\n        }\n\n        nodes.forEach(function (node) {\n            nodeCtx = ctx || ko.contextFor(node);\n\n            if (_.isFunction(data)) {\n                bindings = data(nodeCtx, node);\n            }\n\n            ko.applyBindingsToNode(node, bindings, nodeCtx);\n        });\n\n        return this;\n    };\n});\n","Magento_Ui/js/lib/logger/message-pool.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(function () {\n    'use strict';\n\n    var MESSAGES = {\n        templateStartLoading:\n            'The \"${ $.template }\" template requested by  the \"${$.component}\" component started loading.',\n        templateLoadedFromServer:\n            'The \"${ $.template }\" template requested by the \"${$.component}\" component  was loaded from server.\"',\n        templateLoadedFromCache:\n            'The \"${ $.template }\" template  requested by the \"${$.component}\" component was loaded from cache.\"',\n        templateLoadingFail: 'Failed to load the \"${ $.template }\" template requested by \"${$.component}\".',\n        componentStartInitialization:\n            'Component \"${$.component}\" start initialization with instance name \"${$.componentName}\".',\n        componentStartLoading: ' Started loading the \"${$.component}\" component.',\n        componentFinishLoading: 'The \"${$.component}\" component was loaded.',\n        componentLoadingFail: 'Failed to load the \"${$.component}\" component.',\n        depsLoadingFail: 'Could not get the declared \"${$.deps}\" dependency for the \"${$.component}\" instance.',\n        depsStartRequesting: 'Requesting the \"${$.deps}\" dependency for the \"${$.component}\" instance.',\n        depsFinishRequesting: 'The \"${$.deps}\" dependency for the \"${$.component}\" instance was received.',\n        requestingComponent: 'Requesting the \"${$.component}\" component.',\n        requestingComponentIsLoaded: 'The requested \"${$.component}\" component was received.',\n        requestingComponentIsFailed: 'Could not get the requested \"${$.component}\" component.'\n    };\n\n    return {\n        /**\n         * Returns message that matches the provided code.\n         *\n         * @param {String} code - Message's identifier\n         * @returns {String}\n         */\n        getMessage: function (code) {\n            return MESSAGES[code];\n        },\n\n        /**\n         * Adds a new message to the poll.\n         *\n         * @param {String} code - Message's identifier.\n         * @param {String} message - Text of the message\n         */\n        addMessage: function (code, message) {\n            MESSAGES[code] = message;\n        },\n\n        /**\n         * Tells whether message with provide code exists in the poll.\n         *\n         * @param {String} code - Message's identifier.\n         * @returns {Boolean}\n         */\n        hasMessage: function (code) {\n            return MESSAGES.hasOwnProperty(code);\n        }\n    };\n});\n","Magento_Ui/js/lib/logger/console-output-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './levels-pool'\n], function (logLevels) {\n    'use strict';\n\n    var levels = logLevels.getLevels();\n\n    /**\n     * @param {LogFormatter} formatter\n     */\n    function ConsoleOutputHandler(formatter) {\n        /**\n         * @protected\n         * @type {LogFormatter}\n         */\n        this.formatter_ = formatter;\n    }\n\n    /**\n     * Display data of the provided entry to the console.\n     *\n     * @param {LogEntry} entry - Entry to be displayed.\n     */\n    ConsoleOutputHandler.prototype.show = function (entry) {\n        var displayString = this.formatter_.process(entry);\n\n        switch (entry.level) {\n            case levels.ERROR:\n                console.error(displayString);\n                break;\n\n            case levels.WARN:\n                console.warn(displayString);\n                break;\n\n            case levels.INFO:\n                console.info(displayString);\n                break;\n\n            case levels.DEBUG:\n                console.log(displayString);\n                break;\n        }\n    };\n\n    /**\n     * Displays the array of entries.\n     *\n     * @param {Array<LogEntry>} entries\n     */\n    ConsoleOutputHandler.prototype.dump = function (entries) {\n        entries.forEach(this.show, this);\n    };\n\n    return ConsoleOutputHandler;\n});\n","Magento_Ui/js/lib/logger/console-logger.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './logger',\n    './entry-factory',\n    './console-output-handler',\n    './formatter',\n    './message-pool',\n    './levels-pool',\n    'Magento_Ui/js/lib/core/storage/local',\n    'underscore',\n    './logger-utils'\n], function (Logger, entryFactory, ConsoleHandler, Formatter, messagePoll, levelsPoll, storage, _, LoggerUtils) {\n    'use strict';\n\n    var STORAGE_NAMESPACE = 'CONSOLE_LOGGER';\n\n    /**\n     * Singleton Logger's sub-class instance of which is configured to display its\n     * messages to the console. It also provides the support of predefined messages\n     * and persists its display level.\n     */\n    function ConsoleLogger() {\n        var formatter = new Formatter(),\n            consoleHandler = new ConsoleHandler(formatter),\n            savedLevel = storage.get(STORAGE_NAMESPACE),\n            utils = new LoggerUtils(this);\n\n        Logger.call(this, consoleHandler, entryFactory);\n\n        if (savedLevel) {\n            this.displayLevel_ = savedLevel;\n        }\n\n        this.utils = utils;\n        this.messages = messagePoll;\n        this.levels = levelsPoll.getLevels();\n    }\n\n    _.extend(ConsoleLogger, Logger);\n\n    ConsoleLogger.prototype = Object.create(Logger.prototype);\n    ConsoleLogger.prototype.constructor = ConsoleLogger;\n\n    /**\n     * Overrides parent method to save the provided display level.\n     *\n     * @override\n     */\n    ConsoleLogger.prototype.setDisplayLevel = function (level) {\n        Logger.prototype.setDisplayLevel.call(this, level);\n\n        storage.set(STORAGE_NAMESPACE, level);\n    };\n\n    /**\n     * Adds the support of predefined messages.\n     *\n     * @protected\n     * @override\n     */\n    ConsoleLogger.prototype.createEntry_ = function (message, level, data) {\n        var code;\n\n        if (messagePoll.hasMessage(message)) {\n            data = data || {};\n            code = message;\n            message = messagePoll.getMessage(code);\n\n            data.messageCode = code;\n        }\n\n        return Logger.prototype.createEntry_.call(this, message, level, data);\n    };\n\n    return new ConsoleLogger();\n});\n","Magento_Ui/js/lib/logger/formatter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'moment',\n    'mage/utils/template'\n], function (moment, mageTemplate) {\n    'use strict';\n\n    /**\n     * @param {String} dateFormat\n     * @param {String} template\n     */\n    function LogFormatter(dateFormat, template) {\n        /**\n         * @protected\n         * @type {String}\n         */\n        this.dateFormat_ = 'YYYY-MM-DD hh:mm:ss';\n\n        /**\n         * @protected\n         * @type {String}\n         */\n        this.template_ = '[${ $.date }] [${ $.entry.levelName }] ${ $.message }';\n\n        if (dateFormat) {\n            this.dateFormat_ = dateFormat;\n        }\n\n        if (template) {\n            this.template_ = template;\n        }\n    }\n\n    /**\n     * @param {LogEntry} entry\n     * @returns {String}\n     */\n    LogFormatter.prototype.process = function (entry) {\n        var message = mageTemplate.template(entry.message, entry.data),\n            date = moment(entry.timestamp).format(this.dateFormat_);\n\n        return mageTemplate.template(this.template_, {\n            date: date,\n            entry: entry,\n            message: message\n        });\n    };\n\n    return LogFormatter;\n});\n","Magento_Ui/js/lib/logger/levels-pool.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var LEVELS,\n        CODE_MAP;\n\n    LEVELS = {\n        NONE: 0,\n        ERROR: 1,\n        WARN: 2,\n        INFO: 3,\n        DEBUG: 4,\n        ALL: 5\n    };\n\n    CODE_MAP = _.invert(LEVELS);\n\n    return {\n        /**\n         * Returns the list of available log levels.\n         *\n         * @returns {Object}\n         */\n        getLevels: function () {\n            return LEVELS;\n        },\n\n        /**\n         * Returns name of the log level that matches to the provided code.\n         *\n         * @returns {String}\n         */\n        getNameByCode: function (code) {\n            return CODE_MAP[code];\n        }\n    };\n});\n","Magento_Ui/js/lib/logger/logger-utils.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Utils methods for logger\n     * @param {Logger} logger\n     */\n    function LogUtils(logger) {\n        this.logger = logger;\n\n    }\n\n    /**\n     * Method for logging asynchronous operations\n     * @param {Promise} promise\n     * @param {Object} config\n     */\n    LogUtils.prototype.asyncLog = function (promise, config) {\n        var levels,\n            messages,\n            wait;\n\n        config = config || {};\n        levels = config.levels || this.createLevels();\n        messages = config.messages || this.createMessages();\n        wait = config.wait || 5000;\n\n        this.logger[levels.requested](messages.requested, config.data);\n        setTimeout(function () {\n            promise.state() === 'pending' ?\n                this.logger[levels.failed](messages.failed, config.data) :\n                this.logger[levels.loaded](messages.loaded, config.data);\n        }.bind(this), wait);\n    };\n\n    /**\n     * Method that creates object of messages\n     * @param {String} requested - log message that showing that request for class is started\n     * @param {String} loaded - log message that show when requested class is loaded\n     * @param {String} failed - log message that show when requested class is failed\n     * @returns {Object}\n     */\n    LogUtils.prototype.createMessages = function (requested, loaded, failed) {\n        return {\n            requested: requested || '',\n            loaded: loaded || '',\n            failed: failed || ''\n        };\n    };\n\n    /**\n     * Method that creates object of log levels\n     * @param {String} requested - log message that showing that request for class is started\n     * @param {String} loaded - log message that show when requested class is loaded\n     * @param {String} failed - log message that show when requested class is failed\n     * @returns {Object}\n     */\n    LogUtils.prototype.createLevels = function (requested, loaded, failed) {\n        return {\n            requested: requested || 'info',\n            loaded: loaded || 'info',\n            failed: failed || 'warn'\n        };\n    };\n\n    return LogUtils;\n});\n","Magento_Ui/js/lib/logger/entry-factory.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './entry'\n], function (LogEntry) {\n    'use strict';\n\n    return {\n        /**\n         * @param {String} message\n         * @param {Number} level\n         * @param {Object} [messageData]\n         * @returns {LogEntry}\n         */\n        createEntry: function (message, level, messageData) {\n            return new LogEntry(message, level, messageData);\n        }\n    };\n});\n","Magento_Ui/js/lib/logger/entry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './levels-pool'\n], function (logLevels) {\n    'use strict';\n\n    /**\n     * @param {String} message\n     * @param {Number} level\n     * @param {Object} [data]\n     */\n    function LogEntry(message, level, data) {\n        /**\n         * @readonly\n         * @type {Number}\n         */\n        this.timestamp = Date.now();\n\n        /**\n         * @readonly\n         * @type {Number}\n         */\n        this.level = level;\n\n        /**\n         * @readonly\n         * @type {String}\n         */\n        this.levelName = logLevels.getNameByCode(level);\n\n        /**\n         * @readonly\n         * @type {Object}\n         */\n        this.data = data;\n\n        /**\n         * @readonly\n         * @type {String}\n         */\n        this.message = message;\n    }\n\n    return LogEntry;\n});\n","Magento_Ui/js/lib/logger/logger.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './levels-pool'\n], function (logLevels) {\n    'use strict';\n\n    var levels = logLevels.getLevels();\n\n    /**\n     * @param {LogOutputHandler} outputHandler\n     * @param {LogEntryFactory} entryFactory\n     */\n    function Logger(outputHandler, entryFactory) {\n        /**\n         * An array of log entries.\n         *\n         * @protected\n         * @type {Array<LogEntry>}\n         */\n        this.entries_ = [];\n\n        /**\n         * Current display level.\n         *\n         * @protected\n         * @type {Number}\n         */\n        this.displayLevel_ = levels.ERROR;\n\n        /**\n         * An array of display criteria.\n         *\n         * @protected\n         * @type {Array<LogCriteria>}\n         */\n        this.displayCriteria_ = [];\n\n        /**\n         * @protected\n         * @type {LogEntryFactory}\n         */\n        this.entryFactory_ = entryFactory;\n\n        /**\n         * @protected\n         * @type {Array<LogOutputHandler>}\n         */\n        this.outputHandlers_ = [outputHandler];\n\n        this.addDisplayCriteria(this.matchesLevel_);\n    }\n\n    /**\n     * Swaps current display level with the provided one.\n     *\n     * @param {Number} level - Level's code.\n     */\n    Logger.prototype.setDisplayLevel = function (level) {\n        var levelName = logLevels.getNameByCode(level);\n\n        if (!levelName) {\n            throw new TypeError('The provided level is not defined in the levels list.');\n        }\n\n        this.displayLevel_ = level;\n    };\n\n    /**\n     * Sets up the criteria by which log entries will be filtered out from the output.\n     *\n     * @param {LogCriteria} criteria\n     */\n    Logger.prototype.addDisplayCriteria = function (criteria) {\n        this.displayCriteria_.push(criteria);\n    };\n\n    /**\n     * Removes previously defined criteria.\n     *\n     * @param {LogCriteria} criteria\n     */\n    Logger.prototype.removeDisplayCriteria = function (criteria) {\n        var index = this.displayCriteria_.indexOf(criteria);\n\n        if (~index) {\n            this.displayCriteria_.splice(index, 1);\n        }\n    };\n\n    /**\n     * @param {String} message\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.error = function (message, messageData) {\n        return this.log_(message, levels.ERROR, messageData);\n    };\n\n    /**\n     * @param {String} message\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.warn = function (message, messageData) {\n        return this.log_(message, levels.WARN, messageData);\n    };\n\n    /**\n     * @param {String} message\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.info = function (message, messageData) {\n        return this.log_(message, levels.INFO, messageData);\n    };\n\n    /**\n     * @param {String} message\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.debug = function (message, messageData) {\n        return this.log_(message, levels.DEBUG, messageData);\n    };\n\n    /**\n     * @protected\n     * @param {String} message\n     * @param {Number} level\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.log_ = function (message, level, messageData) {\n        var entry = this.createEntry_(message, level, messageData);\n\n        this.entries_.push(entry);\n\n        if (this.matchesCriteria_(entry)) {\n            this.processOutput_(entry);\n        }\n\n        return entry;\n    };\n\n    /**\n     * @protected\n     * @param {String} message\n     * @param {Number} level\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.createEntry_ = function (message, level, messageData) {\n        return this.entryFactory_.createEntry(message, level, messageData);\n    };\n\n    /**\n     * Returns an array of log entries that have been added to the logger.\n     *\n     * @param {LogCriteria} [criteria] - Optional filter criteria.\n     * @returns {Array<LogEntry>}\n     */\n    Logger.prototype.getEntries = function (criteria) {\n        if (criteria) {\n            return this.entries_.filter(criteria);\n        }\n\n        return this.entries_;\n    };\n\n    /**\n     * @param {LogCriteria} [criteria]\n     */\n    Logger.prototype.dump = function (criteria) {\n        var entries;\n\n        if (!criteria) {\n            criteria = this.matchesCriteria_;\n        }\n\n        entries = this.entries_.filter(criteria, this);\n\n        this.outputHandlers_.forEach(function (handler) {\n            handler.dump(entries);\n        });\n    };\n\n    /**\n     * @protected\n     * @param {LogEntry} entry\n     */\n    Logger.prototype.processOutput_ = function (entry) {\n        this.outputHandlers_.forEach(function (handler) {\n            handler.show(entry);\n        });\n    };\n\n    /**\n     * @protected\n     * @param {LogEntry} entry\n     * @returns {Boolean}\n     */\n    Logger.prototype.matchesCriteria_ = function (entry) {\n        return this.displayCriteria_.every(function (criteria) {\n            return criteria.call(this, entry);\n        }, this);\n    };\n\n    /**\n     * Checks that the level of provided entry passes the \"displayLevel_\" threshold.\n     *\n     * @protected\n     * @param {LogEntry} entry - Entry to be checked.\n     * @returns {Boolean}\n     */\n    Logger.prototype.matchesLevel_ = function (entry) {\n        return entry.level <= this.displayLevel_;\n    };\n\n    return Logger;\n});\n","Magento_Ui/js/lib/validation/rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    './utils',\n    'moment',\n    'tinycolor',\n    'jquery/validate',\n    'mage/translate'\n], function ($, _, utils, moment, tinycolor) {\n    'use strict';\n\n    /**\n     * validate credit card number using mod10\n     * @param {String} s\n     * @return {Boolean}\n     */\n    function validateCreditCard(s) {\n        // remove non-numerics\n        var v = '0123456789',\n            w = '',\n            i, j, k, m, c, a, x;\n\n        for (i = 0; i < s.length; i++) {\n            x = s.charAt(i);\n\n            if (v.indexOf(x, 0) !== -1) {\n                w += x;\n            }\n        }\n        // validate number\n        j = w.length / 2;\n        k = Math.floor(j);\n        m = Math.ceil(j) - k;\n        c = 0;\n\n        for (i = 0; i < k; i++) {\n            a = w.charAt(i * 2 + m) * 2;\n            c += a > 9 ? Math.floor(a / 10 + a % 10) : a;\n        }\n\n        for (i = 0; i < k + m; i++) {\n            c += w.charAt(i * 2 + 1 - m) * 1;\n        }\n\n        return c % 10 === 0;\n    }\n\n    /**\n     * Collection of validation rules including rules from additional-methods.js\n     * @type {Object}\n     */\n    return _.mapObject({\n        'min_text_length': [\n            function (value, params) {\n                return _.isUndefined(value) || value.length === 0 || value.length >= +params;\n            },\n            $.mage.__('Please enter more or equal than {0} symbols.')\n        ],\n        'max_text_length': [\n            function (value, params) {\n                return !_.isUndefined(value) && value.length <= +params;\n            },\n            $.mage.__('Please enter less or equal than {0} symbols.')\n        ],\n        'max-words': [\n            function (value, params) {\n                return utils.isEmpty(value) || utils.stripHtml(value).match(/\\b\\w+\\b/g).length < params;\n            },\n            $.mage.__('Please enter {0} words or less.')\n        ],\n        'min-words': [\n            function (value, params) {\n                return utils.isEmpty(value) || utils.stripHtml(value).match(/\\b\\w+\\b/g).length >= params;\n            },\n            $.mage.__('Please enter at least {0} words.')\n        ],\n        'range-words': [\n            function (value, params) {\n                var match = utils.stripHtml(value).match(/\\b\\w+\\b/g) || [];\n\n                return utils.isEmpty(value) || match.length >= params[0] &&\n                    match.length <= params[1];\n            },\n            $.mage.__('Please enter between {0} and {1} words.')\n        ],\n        'letters-with-basic-punc': [\n            function (value) {\n                return utils.isEmpty(value) || /^[a-z\\-.,()\\u0027\\u0022\\s]+$/i.test(value);\n            },\n            $.mage.__('Letters or punctuation only please')\n        ],\n        'alphanumeric': [\n            function (value) {\n                return utils.isEmpty(value) || /^\\w+$/i.test(value);\n            },\n            $.mage.__('Letters, numbers, spaces or underscores only please')\n        ],\n        'letters-only': [\n            function (value) {\n                return utils.isEmpty(value) || /^[a-z]+$/i.test(value);\n            },\n            $.mage.__('Letters only please')\n        ],\n        'no-whitespace': [\n            function (value) {\n                return utils.isEmpty(value) || /^\\S+$/i.test(value);\n            },\n            $.mage.__('No white space please')\n        ],\n        'no-marginal-whitespace': [\n            function (value) {\n                return !/^\\s+|\\s+$/i.test(value);\n            },\n            $.mage.__('No marginal white space please')\n        ],\n        'zip-range': [\n            function (value) {\n                return utils.isEmpty(value) || /^90[2-5]-\\d{2}-\\d{4}$/.test(value);\n            },\n            $.mage.__('Your ZIP-code must be in the range 902xx-xxxx to 905-xx-xxxx')\n        ],\n        'integer': [\n            function (value) {\n                return utils.isEmpty(value) || /^-?\\d+$/.test(value);\n            },\n            $.mage.__('A positive or negative non-decimal number please')\n        ],\n        'vinUS': [\n            function (value) {\n                if (utils.isEmpty(value)) {\n                    return true;\n                }\n\n                if (value.length !== 17) {\n                    return false;\n                }\n                var i, n, d, f, cd, cdv,//eslint-disable-line vars-on-top\n                    LL = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'],//eslint-disable-line max-len\n                    VL = [1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 7, 9, 2, 3, 4, 5, 6, 7, 8, 9],\n                    FL = [8, 7, 6, 5, 4, 3, 2, 10, 0, 9, 8, 7, 6, 5, 4, 3, 2],\n                    rs = 0;\n\n                for (i = 0; i < 17; i++) {\n                    f = FL[i];\n                    d = value.slice(i, i + 1);\n\n                    if (i === 8) {\n                        cdv = d;\n                    }\n\n                    if (!isNaN(d)) {\n                        d *= f;\n                    } else {\n                        for (n = 0; n < LL.length; n++) {//eslint-disable-line max-depth\n                            if (d.toUpperCase() === LL[n]) {//eslint-disable-line max-depth\n                                d = VL[n];\n                                d *= f;\n\n                                if (isNaN(cdv) && n === 8) {//eslint-disable-line max-depth\n                                    cdv = LL[n];\n                                }\n                                break;\n                            }\n                        }\n                    }\n                    rs += d;\n                }\n                cd = rs % 11;\n\n                if (cd === 10) {\n                    cd = 'X';\n                }\n\n                if (cd === cdv) {\n                    return true;\n                }\n\n                return false;\n            },\n            $.mage.__('The specified vehicle identification number (VIN) is invalid.')\n        ],\n        'dateITA': [\n            function (value) {\n                var check = false,\n                    re = /^\\d{1,2}\\/\\d{1,2}\\/\\d{4}$/,\n                    adata, gg, mm, aaaa, xdata;\n\n                if (re.test(value)) {\n                    adata = value.split('/');\n                    gg = parseInt(adata[0], 10);\n                    mm = parseInt(adata[1], 10);\n                    aaaa = parseInt(adata[2], 10);\n                    xdata = new Date(aaaa, mm - 1, gg);\n\n                    if (xdata.getFullYear() === aaaa &&\n                        xdata.getMonth() === mm - 1 &&\n                        xdata.getDate() === gg\n                    ) {\n                        check = true;\n                    } else {\n                        check = false;\n                    }\n                } else {\n                    check = false;\n                }\n\n                return check;\n            },\n            $.mage.__('Please enter a correct date')\n        ],\n        'dateNL': [\n            function (value) {\n                return /^\\d\\d?[\\.\\/-]\\d\\d?[\\.\\/-]\\d\\d\\d?\\d?$/.test(value);\n            },\n            $.mage.__('Vul hier een geldige datum in.')\n        ],\n        'time': [\n            function (value) {\n                return utils.isEmpty(value) || /^([01]\\d|2[0-3])(:[0-5]\\d){0,2}$/.test(value);\n            },\n            $.mage.__('Please enter a valid time, between 00:00 and 23:59')\n        ],\n        'time12h': [\n            function (value) {\n                return utils.isEmpty(value) || /^((0?[1-9]|1[012])(:[0-5]\\d){0,2}(\\s[AP]M))$/i.test(value);\n            },\n            $.mage.__('Please enter a valid time, between 00:00 am and 12:00 pm')\n        ],\n        'phoneUS': [\n            function (value) {\n                value = value.replace(/\\s+/g, '');\n\n                return utils.isEmpty(value) || value.length > 9 &&\n                    value.match(/^(1-?)?(\\([2-9]\\d{2}\\)|[2-9]\\d{2})-?[2-9]\\d{2}-?\\d{4}$/);\n            },\n            $.mage.__('Please specify a valid phone number')\n        ],\n        'phoneUK': [\n            function (value) {\n                return utils.isEmpty(value) || value.length > 9 &&\n                    value.match(/^(\\(?(0|\\+44)[1-9]{1}\\d{1,4}?\\)?\\s?\\d{3,4}\\s?\\d{3,4})$/);\n            },\n            $.mage.__('Please specify a valid phone number')\n        ],\n        'mobileUK': [\n            function (value) {\n                return utils.isEmpty(value) || value.length > 9 && value.match(/^((0|\\+44)7\\d{3}\\s?\\d{6})$/);\n            },\n            $.mage.__('Please specify a valid mobile number')\n        ],\n        'stripped-min-length': [\n            function (value, param) {\n                return _.isUndefined(value) || value.length === 0 || utils.stripHtml(value).length >= param;\n            },\n            $.mage.__('Please enter at least {0} characters')\n        ],\n        'email2': [\n            function (value) {\n                return utils.isEmpty(value) || /^((([a-z]|\\d|[!#\\$%&\\u0027\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z]|\\d|[!#\\$%&\\u0027\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*)|((\\u0022)((((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(([\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x7f]|\\x21|[\\x23-\\x5b]|[\\x5d-\\x7e]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(\\\\([\\x01-\\x09\\x0b\\x0c\\x0d-\\x7f]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]))))*(((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(\\u0022)))@((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?$/i.test(value);//eslint-disable-line max-len\n            },\n            $.validator.messages.email\n        ],\n        'url2': [\n            function (value) {\n                return utils.isEmpty(value) || /^(https?|ftp):\\/\\/(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:)*@)?(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?)(:\\d*)?)(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)*)*)?)?(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?$/i.test(value);//eslint-disable-line max-len\n            },\n            $.validator.messages.url\n        ],\n        'credit-card-types': [\n            function (value, param) {\n                var validTypes;\n\n                if (utils.isEmpty(value)) {\n                    return true;\n                }\n\n                if (/[^0-9-]+/.test(value)) {\n                    return false;\n                }\n                value = value.replace(/\\D/g, '');\n                validTypes = 0x0000;\n\n                if (param.mastercard) {\n                    validTypes |= 0x0001;\n                }\n\n                if (param.visa) {\n                    validTypes |= 0x0002;\n                }\n\n                if (param.amex) {\n                    validTypes |= 0x0004;\n                }\n\n                if (param.dinersclub) {\n                    validTypes |= 0x0008;\n                }\n\n                if (param.enroute) {\n                    validTypes |= 0x0010;\n                }\n\n                if (param.discover) {\n                    validTypes |= 0x0020;\n                }\n\n                if (param.jcb) {\n                    validTypes |= 0x0040;\n                }\n\n                if (param.unknown) {\n                    validTypes |= 0x0080;\n                }\n\n                if (param.all) {\n                    validTypes = 0x0001 | 0x0002 | 0x0004 | 0x0008 | 0x0010 | 0x0020 | 0x0040 | 0x0080;\n                }\n\n                if (validTypes & 0x0001 && /^(51|52|53|54|55)/.test(value)) { //mastercard\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0002 && /^(4)/.test(value)) { //visa\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0004 && /^(34|37)/.test(value)) { //amex\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0008 && /^(300|301|302|303|304|305|36|38)/.test(value)) { //dinersclub\n                    return value.length === 14;\n                }\n\n                if (validTypes & 0x0010 && /^(2014|2149)/.test(value)) { //enroute\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0020 && /^(6011)/.test(value)) { //discover\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0040 && /^(3)/.test(value)) { //jcb\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0040 && /^(2131|1800)/.test(value)) { //jcb\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0080) { //unknown\n                    return true;\n                }\n\n                return false;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n        'ipv4': [\n            function (value) {\n                return utils.isEmpty(value) || /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/i.test(value);//eslint-disable-line max-len\n            },\n            $.mage.__('Please enter a valid IP v4 address.')\n        ],\n        'ipv6': [\n            function (value) {\n                return utils.isEmpty(value) || /^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(([0-9A-Fa-f]{1,4}:){0,5}:((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(::([0-9A-Fa-f]{1,4}:){0,5}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))$/i.test(value);//eslint-disable-line max-len\n            },\n            $.mage.__('Please enter a valid IP v6 address.')\n        ],\n        'pattern': [\n            function (value, param) {\n                return utils.isEmpty(value) || new RegExp(param).test(value);\n            },\n            $.mage.__('Invalid format.')\n        ],\n        'validate-no-html-tags': [\n            function (value) {\n                return !/<(\\/)?\\w+/.test(value);\n            },\n            $.mage.__('HTML tags are not allowed.')\n        ],\n        'validate-select': [\n            function (value) {\n                return value !== 'none' && value != null && value.length !== 0;\n            },\n            $.mage.__('Please select an option.')\n        ],\n        'validate-no-empty': [\n            function (value) {\n                return !utils.isEmpty(value);\n            },\n            $.mage.__('Empty Value.')\n        ],\n        'validate-alphanum-with-spaces': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-zA-Z0-9 ]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or spaces only in this field.')\n        ],\n        'validate-data': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[A-Za-z]+[A-Za-z0-9_]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.')//eslint-disable-line max-len\n        ],\n        'validate-street': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) ||\n                    /^[ \\w]{3,}([A-Za-z]\\.)?([ \\w]*\\#\\d+)?(\\r\\n| )[ \\w]{3,}/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9), spaces and \"#\" in this field.')\n        ],\n        'validate-phoneStrict': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(value);\n            },\n            $.mage.__('Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.')\n        ],\n        'validate-phoneLax': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) ||\n                    /^((\\d[\\-. ]?)?((\\(\\d{3}\\))|\\d{3}))?[\\-. ]?\\d{3}[\\-. ]?\\d{4}$/.test(value);\n            },\n            $.mage.__('Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.')\n        ],\n        'validate-fax': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(value);\n            },\n            $.mage.__('Please enter a valid fax number (Ex: 123-456-7890).')\n        ],\n        'validate-email': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*@([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*\\.(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]){2,})$/i.test(value);//eslint-disable-line max-len\n            },\n            $.mage.__('Please enter a valid email address (Ex: johndoe@domain.com).')\n        ],\n        'validate-emailSender': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[\\S ]+$/.test(value);\n            },\n            $.mage.__('Please enter a valid email address (Ex: johndoe@domain.com).')\n        ],\n        'validate-password': [\n            function (value) {\n                var pass;\n\n                if (value == null) {\n                    return false;\n                }\n\n                pass = $.trim(value);\n\n                if (!pass.length) {\n                    return true;\n                }\n\n                return !(pass.length > 0 && pass.length < 6);\n            },\n            $.mage.__('Please enter 6 or more characters. Leading and trailing spaces will be ignored.')\n        ],\n        'validate-admin-password': [\n            function (value) {\n                var pass;\n\n                if (value == null) {\n                    return false;\n                }\n\n                pass = $.trim(value);\n\n                if (pass.length === 0) {\n                    return true;\n                }\n\n                if (!/[a-z]/i.test(value) || !/[0-9]/.test(value)) {\n                    return false;\n                }\n\n                if (pass.length < 7) {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter 7 or more characters, using both numeric and alphabetic.')\n        ],\n        'validate-customer-password': [\n            function (v, elm) {\n                var validator = this,\n                    counter = 0,\n                    passwordMinLength = $(elm).data('password-min-length'),\n                    passwordMinCharacterSets = $(elm).data('password-min-character-sets'),\n                    pass = $.trim(v),\n                    result = pass.length >= passwordMinLength;\n\n                if (result === false) {\n                    validator.passwordErrorMessage = $.mage.__('Minimum length of this field must be equal or greater than %1 symbols. Leading and trailing spaces will be ignored.').replace('%1', passwordMinLength);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                if (pass.match(/\\d+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[a-z]+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[A-Z]+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[^a-zA-Z0-9]+/)) {\n                    counter++;\n                }\n\n                if (counter < passwordMinCharacterSets) {\n                    result = false;\n                    validator.passwordErrorMessage = $.mage.__('Minimum of different classes of characters in password is %1. Classes of characters: Lower Case, Upper Case, Digits, Special Characters.').replace('%1', passwordMinCharacterSets);//eslint-disable-line max-len\n                }\n\n                return result;\n            }, function () {\n                return this.passwordErrorMessage;\n            }\n        ],\n        'validate-url': [\n            function (value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n                value = (value || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n\n                return (/^(http|https|ftp):\\/\\/(([A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))(\\.[A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))*)(:(\\d+))?(\\/[A-Z0-9~](([A-Z0-9_~-]|\\.)*[A-Z0-9~]|))*\\/?(.*)?$/i).test(value);//eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid URL. Protocol is required (http://, https:// or ftp://).')\n        ],\n        'validate-clean-url': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^(http|https|ftp):\\/\\/(([A-Z0-9][A-Z0-9_-]*)(\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(value) || /^(www)((\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(value);//eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid URL. For example http://www.example.com or www.example.com.')\n        ],\n        'validate-xml-identifier': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[A-Z][A-Z0-9_\\/-]*$/i.test(value);\n\n            },\n            $.mage.__('Please enter a valid XML-identifier (Ex: something_1, block5, id-4).')\n        ],\n        'validate-ssn': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^\\d{3}-?\\d{2}-?\\d{4}$/.test(value);\n\n            },\n            $.mage.__('Please enter a valid social security number (Ex: 123-45-6789).')\n        ],\n        'validate-zip-us': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /(^\\d{5}$)|(^\\d{5}-\\d{4}$)/.test(value);\n\n            },\n            $.mage.__('Please enter a valid zip code (Ex: 90602 or 90602-1234).')\n        ],\n        'validate-date-au': [\n            function (value) {\n                var regex = /^(\\d{2})\\/(\\d{2})\\/(\\d{4})$/,\n                    d;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                if (utils.isEmpty(value) || !regex.test(value)) {\n                    return false;\n                }\n                d = new Date(value.replace(regex, '$2/$1/$3'));\n\n                return parseInt(RegExp.$2, 10) === 1 + d.getMonth() &&\n                    parseInt(RegExp.$1, 10) === d.getDate() &&\n                    parseInt(RegExp.$3, 10) === d.getFullYear();\n\n            },\n            $.mage.__('Please use this date format: dd/mm/yyyy. For example 17/03/2006 for the 17th of March, 2006.')\n        ],\n        'validate-currency-dollar': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^\\$?\\-?([1-9]{1}[0-9]{0,2}(\\,[0-9]{3})*(\\.[0-9]{0,2})?|[1-9]{1}\\d*(\\.[0-9]{0,2})?|0(\\.[0-9]{0,2})?|(\\.[0-9]{1,2})?)$/.test(value);//eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid $ amount. For example $100.00.')\n        ],\n        'validate-not-negative-number': [\n            function (value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n                value = utils.parseNumber(value);\n\n                return !isNaN(value) && value >= 0;\n\n            },\n            $.mage.__('Please enter a number 0 or greater in this field.')\n        ],\n        // validate-not-negative-number should be replaced in all places with this one and then removed\n        'validate-zero-or-greater': [\n            function (value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n                value = utils.parseNumber(value);\n\n                return !isNaN(value) && value >= 0;\n            },\n            $.mage.__('Please enter a number 0 or greater in this field.')\n        ],\n        'validate-greater-than-zero': [\n            function (value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n                value = utils.parseNumber(value);\n\n                return !isNaN(value) && value > 0;\n            },\n            $.mage.__('Please enter a number greater than 0 in this field.')\n        ],\n        'validate-css-length': [\n            function (value) {\n                if (value !== '') {\n                    return (/^[0-9]*\\.*[0-9]+(px|pc|pt|ex|em|mm|cm|in|%)?$/).test(value);\n                }\n\n                return true;\n            },\n            $.mage.__('Please input a valid CSS-length (Ex: 100px, 77pt, 20em, .5ex or 50%).')\n        ],\n        'validate-number': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) ||\n                    !isNaN(utils.parseNumber(value)) && /^\\s*-?\\d*(,\\d*)*(\\.\\d*)?\\s*$/.test(value);\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        'validate-integer': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !isNaN(utils.parseNumber(value)) && /^\\s*-?\\d*\\s*$/.test(value);\n            },\n            $.mage.__('Please enter a valid integer in this field.')\n        ],\n        'validate-number-range': [\n            function (value, param) {\n                var numValue, dataAttrRange, result, range, m;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                numValue = utils.parseNumber(value);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                dataAttrRange = /^(-?[\\d.,]+)?-(-?[\\d.,]+)?$/;\n                result = true;\n                range = param;\n\n                if (range) {\n                    m = dataAttrRange.exec(range);\n\n                    if (m) {\n                        result = result && utils.isBetween(numValue, m[1], m[2]);\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        'validate-positive-percent-decimal': [\n            function (value) {\n                var numValue;\n\n                if (utils.isEmptyNoTrim(value) || !/^\\s*-?\\d*(\\.\\d*)?\\s*$/.test(value)) {\n                    return false;\n                }\n\n                numValue = utils.parseNumber(value);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                return utils.isBetween(numValue, 0.01, 100);\n            },\n            $.mage.__('Please enter a valid percentage discount value greater than 0.')\n        ],\n        'validate-digits': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !/[^\\d]/.test(value);\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        'validate-digits-range': [\n            function (value, param) {\n                var numValue, dataAttrRange, result, range, m;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                numValue = utils.parseNumber(value);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                dataAttrRange = /^(-?\\d+)?-(-?\\d+)?$/;\n                result = true;\n                range = param;\n\n                if (range) {\n                    m = dataAttrRange.exec(range);\n\n                    if (m) {\n                        result = result && utils.isBetween(numValue, m[1], m[2]);\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        'validate-range': [\n            function (value) {\n                var minValue, maxValue, ranges;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                } else if ($.validator.methods['validate-digits'] && $.validator.methods['validate-digits'](value)) {\n                    minValue = maxValue = utils.parseNumber(value);\n                } else {\n                    ranges = /^(-?\\d+)?-(-?\\d+)?$/.exec(value);\n\n                    if (ranges) {\n                        minValue = utils.parseNumber(ranges[1]);\n                        maxValue = utils.parseNumber(ranges[2]);\n\n                        if (minValue > maxValue) {//eslint-disable-line max-depth\n                            return false;\n                        }\n                    } else {\n                        return false;\n                    }\n                }\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        'validate-alpha': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-zA-Z]+$/.test(value);\n            },\n            $.mage.__('Please use letters only (a-z or A-Z) in this field.')\n        ],\n        'validate-code': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-z]+[a-z0-9_]+$/.test(value);\n            },\n            $.mage.__('Please use only lowercase letters (a-z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.')//eslint-disable-line max-len\n        ],\n        'validate-alphanum': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-zA-Z0-9]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z) or numbers (0-9) in this field. No spaces or other characters are allowed.')//eslint-disable-line max-len\n        ],\n        'validate-not-number-first': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[^0-9-\\.].*$/.test(value.trim());\n            },\n            $.mage.__('First character must be letter.')\n        ],\n        'validate-date': [\n            function (value, params, additionalParams) {\n                var test = moment(value, additionalParams.dateFormat);\n\n                return utils.isEmptyNoTrim(value) || test.isValid();\n            },\n            $.mage.__('Please enter a valid date.')\n        ],\n        'validate-date-range': [\n            function (value, params) {\n                var fromDate = $('input[name*=\"' + params + '\"]').val();\n\n                return moment.utc(value).unix() >= moment.utc(fromDate).unix() || isNaN(moment.utc(value).unix());\n            },\n            $.mage.__('Make sure the To Date is later than or the same as the From Date.')\n        ],\n        'validate-identifier': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-z0-9][a-z0-9_\\/-]+(\\.[a-z0-9_-]+)?$/.test(value);\n            },\n            $.mage.__('Please enter a valid URL Key (Ex: \"example-page\", \"example-page.html\" or \"anotherlevel/example-page\").')//eslint-disable-line max-len\n        ],\n        'validate-zip-international': [\n\n            /*function(v) {\n            // @TODO: Cleanup\n            return Validation.get('IsEmpty').test(v) || /(^[A-z0-9]{2,10}([\\s]{0,1}|[\\-]{0,1})[A-z0-9]{2,10}$)/.test(v);\n            }*/\n            function () {\n                return true;\n            },\n            $.mage.__('Please enter a valid zip code.')\n        ],\n        'validate-state': [\n            function (value) {\n                return value !== 0 || value === '';\n            },\n            $.mage.__('Please select State/Province.')\n        ],\n        'less-than-equals-to': [\n            function (value, params) {\n                if ($.isNumeric(params) && $.isNumeric(value)) {\n                    return parseFloat(value) <= parseFloat(params);\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter a value less than or equal to {0}.')\n        ],\n        'greater-than-equals-to': [\n            function (value, params) {\n                if ($.isNumeric(params) && $.isNumeric(value)) {\n                    return parseFloat(value) >= parseFloat(params);\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter a value greater than or equal to {0}.')\n        ],\n        'validate-emails': [\n            function (value) {\n                var validRegexp, emails, i;\n\n                if (utils.isEmpty(value)) {\n                    return true;\n                }\n                validRegexp = /^[a-z0-9\\._-]{1,30}@([a-z0-9_-]{1,30}\\.){1,5}[a-z]{2,4}$/i;\n                emails = value.split(/[\\s\\n\\,]+/g);\n\n                for (i = 0; i < emails.length; i++) {\n                    if (!validRegexp.test(emails[i].strip())) {\n                        return false;\n                    }\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter valid email addresses, separated by commas. For example, johndoe@domain.com, johnsmith@domain.com.')//eslint-disable-line max-len\n        ],\n        'validate-cc-number': [\n\n            /**\n             * Validate credit card number based on mod 10.\n             *\n             * @param {String} value - credit card number\n             * @return {Boolean}\n             */\n            function (value) {\n                if (value) {\n                    return validateCreditCard(value);\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n        'validate-cc-ukss': [\n\n            /**\n             * Validate Switch/Solo/Maestro issue number and start date is filled.\n             *\n             * @param {String} value - input field value\n             * @return {*}\n             */\n            function (value) {\n                return value;\n            },\n            $.mage.__('Please enter issue number or start date for switch/solo card type.')\n        ],\n        'required-entry': [\n            function (value) {\n                return !utils.isEmpty(value);\n            },\n            $.mage.__('This is a required field.')\n        ],\n        'checked': [\n            function (value) {\n                return value;\n            },\n            $.mage.__('This is a required field.')\n        ],\n        'not-negative-amount': [\n            function (value) {\n                if (value.length) {\n                    return (/^\\s*\\d+([,.]\\d+)*\\s*%?\\s*$/).test(value);\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter positive number in this field.')\n        ],\n        'validate-per-page-value-list': [\n            function (value) {\n                var isValid = true,\n                    values = value.split(','),\n                    i;\n\n                if (utils.isEmpty(value)) {\n                    return isValid;\n                }\n\n                for (i = 0; i < values.length; i++) {\n                    if (!/^[0-9]+$/.test(values[i])) {\n                        isValid = false;\n                    }\n                }\n\n                return isValid;\n            },\n            $.mage.__('Please enter a valid value, ex: 10,20,30')\n        ],\n        'validate-new-password': [\n            function (value) {\n                if ($.validator.methods['validate-password'] && !$.validator.methods['validate-password'](value)) {\n                    return false;\n                }\n\n                if (utils.isEmpty(value) && value !== '') {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter 6 or more characters. Leading and trailing spaces will be ignored.')\n        ],\n        'validate-item-quantity': [\n            function (value, params) {\n                var validator = this,\n                    result = false,\n                    // obtain values for validation\n                    qty = utils.parseNumber(value),\n                    isMinAllowedValid = typeof params.minAllowed === 'undefined' ||\n                        qty >= utils.parseNumber(params.minAllowed),\n                    isMaxAllowedValid = typeof params.maxAllowed === 'undefined' ||\n                        qty <= utils.parseNumber(params.maxAllowed),\n                    isQtyIncrementsValid = typeof params.qtyIncrements === 'undefined' ||\n                        qty % utils.parseNumber(params.qtyIncrements) === 0;\n\n                result = qty > 0;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('Please enter a quantity greater than 0.');//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isMinAllowedValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('The fewest you may purchase is %1.').replace('%1', params.minAllowed);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isMaxAllowedValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('The maximum you may purchase is %1.').replace('%1', params.maxAllowed);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isQtyIncrementsValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('You can buy this product only in quantities of %1 at a time.').replace('%1', params.qtyIncrements);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                return result;\n            }, function () {\n                return this.itemQtyErrorMessage;\n            }\n        ],\n        'equalTo': [\n            function (value, param) {\n                return value === $(param).val();\n            },\n            $.validator.messages.equalTo\n        ],\n        'validate-file-type': [\n            function (name, types) {\n                var extension = name.split('.').pop().toLowerCase();\n\n                if (types && typeof types === 'string') {\n                    types = types.split(' ');\n                }\n\n                return !types || !types.length || ~types.indexOf(extension);\n            },\n            $.mage.__('We don\\'t recognize or support this file extension type.')\n        ],\n        'validate-max-size': [\n            function (size, maxSize) {\n                return maxSize === false || size < maxSize;\n            },\n            $.mage.__('File you are trying to upload exceeds maximum file size limit.')\n        ],\n        'validate-if-tag-script-exist': [\n            function (value) {\n                return !value || (/<script\\b[^>]*>([\\s\\S]*?)<\\/script>$/ig).test(value);\n            },\n            $.mage.__('Please use tag SCRIPT with SRC attribute or with proper content to include JavaScript to the document.')//eslint-disable-line max-len\n        ],\n        'date_range_min': [\n            function (value, minValue, params) {\n                return moment.utc(value, params.dateFormat).unix() >= minValue;\n            },\n            $.mage.__('The date is not within the specified range.')\n        ],\n        'date_range_max': [\n            function (value, maxValue, params) {\n                return moment.utc(value, params.dateFormat).unix() <= maxValue;\n            },\n            $.mage.__('The date is not within the specified range.')\n        ],\n        'validate-color': [\n            function (value) {\n                if (value === '') {\n                    return true;\n                }\n\n                return tinycolor(value).isValid();\n            },\n            $.mage.__('Wrong color format. Please specify color in HEX, RGBa, HSVa, HSLa or use color name.')\n        ],\n        'blacklist-url': [\n            function (value, param) {\n                return new RegExp(param).test(value);\n            },\n            $.mage.__('This link is not allowed.')\n        ]\n    }, function (data) {\n        return {\n            handler: data[0],\n            message: data[1]\n        };\n    });\n});\n","Magento_Ui/js/lib/validation/utils.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(function () {\n    'use strict';\n\n    var utils = {\n        /**\n         * Check if string is empty with trim.\n         *\n         * @param {String} value\n         * @return {Boolean}\n         */\n        isEmpty: function (value) {\n            return value === '' || value == null || value.length === 0 || /^\\s+$/.test(value);\n        },\n\n        /**\n         * Check if string is empty no trim.\n         *\n         * @param {String} value\n         * @return {Boolean}\n         */\n        isEmptyNoTrim: function (value) {\n            return value === '' || value == null || value.length === 0;\n        },\n\n        /**\n         * Checks if {value} is between numbers {from} and {to}.\n         *\n         * @param {String} value\n         * @param {String} from\n         * @param {String} to\n         * @return {Boolean}\n         */\n        isBetween: function (value, from, to) {\n            return (from === null || from === '' || value >= utils.parseNumber(from)) &&\n                   (to === null || to === '' || value <= utils.parseNumber(to));\n        },\n\n        /**\n         * Parse price string.\n         *\n         * @param {String} value\n         * @return {Number}\n         */\n        parseNumber: function (value) {\n            var isDot, isComa;\n\n            if (typeof value !== 'string') {\n                return parseFloat(value);\n            }\n            isDot = value.indexOf('.');\n            isComa = value.indexOf(',');\n\n            if (isDot !== -1 && isComa !== -1) {\n                if (isComa > isDot) {\n                    value = value.replace('.', '').replace(',', '.');\n                } else {\n                    value = value.replace(',', '');\n                }\n            } else if (isComa !== -1) {\n                value = value.replace(',', '.');\n            }\n\n            return parseFloat(value);\n        },\n\n        /**\n         * Removes HTML tags and space characters, numbers and punctuation.\n         *\n         * @param {String} value -  Value being stripped.\n         * @return {String}\n         */\n        stripHtml: function (value) {\n            return value.replace(/<.[^<>]*?>/g, ' ').replace(/&nbsp;|&#160;/gi, ' ')\n                .replace(/[0-9.(),;:!?%#$'\"_+=\\/-]*/g, '');\n        }\n    };\n\n    return utils;\n});\n","Magento_Ui/js/lib/validation/validator.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './rules'\n], function (_, rulesList) {\n    'use strict';\n\n    /**\n     * Validates provided value be the specified rule.\n     *\n     * @param {String} id - Rule identifier.\n     * @param {*} value - Value to be checked.\n     * @param {*} [params]\n     * @param {*} additionalParams - additional validation params set by method caller\n     * @returns {Object}\n     */\n    function validate(id, value, params, additionalParams) {\n        var rule,\n            message,\n            valid,\n            result = {\n                rule: id,\n                passed: true,\n                message: ''\n            };\n\n        if (_.isObject(params)) {\n            message = params.message || '';\n        }\n\n        if (!rulesList[id]) {\n            return result;\n        }\n\n        rule    = rulesList[id];\n        message = message || rule.message;\n        valid   = rule.handler(value, params, additionalParams);\n\n        if (!valid) {\n            params = Array.isArray(params) ?\n                params :\n                [params];\n\n            if (typeof message === 'function') {\n                message = message.call(rule);\n            }\n\n            message = params.reduce(function (msg, param, idx) {\n                return msg.replace(new RegExp('\\\\{' + idx + '\\\\}', 'g'), param);\n            }, message);\n\n            result.passed = false;\n            result.message = message;\n        }\n\n        return result;\n    }\n\n    /**\n     * Validates provided value by a specified set of rules.\n     *\n     * @param {(String|Object)} rules - One or many validation rules.\n     * @param {*} value - Value to be checked.\n     * @param {*} additionalParams - additional validation params set by method caller\n     * @returns {Object}\n     */\n    function validator(rules, value, additionalParams) {\n        var result;\n\n        if (typeof rules === 'object') {\n            result = {\n                passed: true\n            };\n\n            _.every(rules, function (ruleParams, id) {\n                if (ruleParams.validate || ruleParams !== false || additionalParams) {\n                    result = validate(id, value, ruleParams, additionalParams);\n\n                    return result.passed;\n                }\n\n                return true;\n            });\n\n            return result;\n        }\n\n        return validate.apply(null, arguments);\n    }\n\n    /**\n     * Adds new validation rule.\n     *\n     * @param {String} id - Rule identifier.\n     * @param {Function} handler - Validation function.\n     * @param {String} message - Error message.\n     */\n    validator.addRule = function (id, handler, message) {\n        rulesList[id] = {\n            handler: handler,\n            message: message\n        };\n    };\n\n    /**\n     * Returns rule object found by provided identifier.\n     *\n     * @param {String} id - Rule identifier.\n     * @returns {Object}\n     */\n    validator.getRule = function (id) {\n        return rulesList[id];\n    };\n\n    return validator;\n});\n","Magento_Ui/js/form/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiElement',\n    './client',\n    'mageUtils'\n], function (_, Element, Client, utils) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            clientConfig: {\n                urls: {\n                    save: '${ $.submit_url }',\n                    beforeSave: '${ $.validate_url }'\n                }\n            },\n            ignoreTmpls: {\n                data: true\n            }\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initClient();\n\n            return this;\n        },\n\n        /**\n         * Initializes client component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initClient: function () {\n            this.client = new Client(this.clientConfig);\n\n            return this;\n        },\n\n        /**\n         * Saves currently available data.\n         *\n         * @param {Object} [options] - Addtitional request options.\n         * @returns {Provider} Chainable.\n         */\n        save: function (options) {\n            var data = this.get('data');\n\n            this.client.save(data, options);\n\n            return this;\n        },\n\n        /**\n         * Update data that stored in provider.\n         *\n         * @param {Boolean} isProvider\n         * @param {Object} newData\n         * @param {Object} oldData\n         *\n         * @returns {Provider}\n         */\n        updateConfig: function (isProvider, newData, oldData) {\n            if (isProvider === true) {\n                this.setData(oldData, newData, this);\n            }\n\n            return this;\n        },\n\n        /**\n         *  Set data to provider based on current data.\n         *\n         * @param {Object} oldData\n         * @param {Object} newData\n         * @param {Provider} current\n         * @param {String} parentPath\n         */\n        setData: function (oldData, newData, current, parentPath) {\n            _.each(newData, function (val, key) {\n                if (_.isObject(val) || _.isArray(val)) {\n                    this.setData(oldData[key], val, current[key], utils.fullPath(parentPath, key));\n                } else if (val != oldData[key] && oldData[key] == current[key]) {//eslint-disable-line eqeqeq\n                    this.set(utils.fullPath(parentPath, key), val);\n                }\n            }, this);\n        }\n    });\n});\n","Magento_Ui/js/form/client.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'uiClass'\n], function ($, _, utils, Class) {\n    'use strict';\n\n    /**\n     * Before save validate request.\n     *\n     * @param {Object} data\n     * @param {String} url\n     * @param {String} selectorPrefix\n     * @param {String} messagesClass\n     * @returns {*}\n     */\n    function beforeSave(data, url, selectorPrefix, messagesClass) {\n        var save = $.Deferred();\n\n        data = utils.serialize(utils.filterFormData(data));\n        data['form_key'] = window.FORM_KEY;\n\n        if (!url || url === 'undefined') {\n            return save.resolve();\n        }\n\n        $('body').trigger('processStart');\n\n        $.ajax({\n            url: url,\n            data: data,\n\n            /**\n             * Success callback.\n             * @param {Object} resp\n             * @returns {Boolean}\n             */\n            success: function (resp) {\n                if (!resp.error) {\n                    save.resolve();\n\n                    return true;\n                }\n\n                $('body').notification('clear');\n                $.each(resp.messages || [resp.message] || [], function (key, message) {\n                    $('body').notification('add', {\n                        error: resp.error,\n                        message: message,\n\n                        /**\n                         * Insert method.\n                         *\n                         * @param {String} msg\n                         */\n                        insertMethod: function (msg) {\n                            var $wrapper = $('<div/>').addClass(messagesClass).html(msg);\n\n                            $('.page-main-actions', selectorPrefix).after($wrapper);\n                        }\n                    });\n                });\n            },\n\n            /**\n             * Complete callback.\n             */\n            complete: function () {\n                $('body').trigger('processStop');\n            }\n        });\n\n        return save.promise();\n    }\n\n    return Class.extend({\n\n        /**\n         * Assembles data and submits it using 'utils.submit' method\n         */\n        save: function (data, options) {\n            var url = this.urls.beforeSave,\n                save = this._save.bind(this, data, options);\n\n            beforeSave(data, url, this.selectorPrefix, this.messagesClass).then(save);\n\n            return this;\n        },\n\n        /**\n         * Save data.\n         *\n         * @param {Object} data\n         * @param {Object} options\n         * @returns {Object}\n         * @private\n         */\n        _save: function (data, options) {\n            var url = this.urls.save;\n\n            $('body').trigger('processStart');\n            options = options || {};\n\n            if (!options.redirect) {\n                url += 'back/edit';\n            }\n\n            if (options.ajaxSave) {\n                utils.ajaxSubmit({\n                    url: url,\n                    data: data\n                }, options);\n\n                $('body').trigger('processStop');\n\n                return this;\n            }\n\n            utils.submit({\n                url: url,\n                data: data\n            }, options.attributes);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/button-adapter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiClass',\n    'jquery',\n    'underscore',\n    'uiRegistry'\n], function (Class, $, _, registry) {\n    'use strict';\n\n    return Class.extend({\n\n        /**\n         * Initialize actions and adapter.\n         *\n         * @param {Object} config\n         * @param {Element} elem\n         * @returns {Object}\n         */\n        initialize: function (config, elem) {\n            return this._super()\n                .initActions()\n                .initAdapter(elem);\n        },\n\n        /**\n         * Creates callback from declared actions.\n         *\n         * @returns {Object}\n         */\n        initActions: function () {\n            var callbacks = [];\n\n            _.each(this.actions, function (action) {\n                callbacks.push({\n                    action: registry.async(action.targetName),\n                    args: _.union([action.actionName], action.params)\n                });\n            });\n\n            /**\n             * Callback function.\n             */\n            this.callback = function () {\n                _.each(callbacks, function (callback) {\n                    callback.action.apply(callback.action, callback.args);\n                });\n            };\n\n            return this;\n        },\n\n        /**\n         * Attach callback handler on button.\n         *\n         * @param {Element} elem\n         */\n        initAdapter: function (elem) {\n            $(elem).on('click', this.callback);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/switcher.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'uiClass'\n], function (_, registry, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            rules: []\n        },\n\n        /**\n         * Initializes instance of a DataSwitcher.\n         *\n         * @returns {DataSwitcher} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initRules();\n\n            return this;\n        },\n\n        /**\n         *\n         * @returns {DataSwitcher} Chainable.\n         */\n        initRules: function () {\n            this.rules.forEach(this.initRule, this);\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {Object} rule - Rule definition.\n         * @returns {DataSwitcher} Chainable.\n         */\n        initRule: function (rule) {\n            var handler = this.onValueChange.bind(this, rule);\n\n            if (!rule.target) {\n                rule.target = this.target;\n            }\n\n            if (!rule.property) {\n                rule.property = this.property;\n            }\n\n            registry.get(rule.target, function (target) {\n                this.applyRule(rule, target.get(rule.property));\n                target.on(rule.property, handler);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {Object} rule - Rule definition.\n         * @returns {DataSwitcher} Chainable.\n         */\n        addRule: function (rule) {\n            this.rules.push(rule);\n            this.initRule(rule);\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {Object} rule - Rule object.\n         * @param {*} value - Current value associated with a rule.\n         */\n        applyRule: function (rule, value) {\n            var actions = rule.actions;\n\n            //TODO Refactor this logic in scope of MAGETWO-48585\n            /* eslint-disable eqeqeq */\n            if (rule.value != value) {\n                return;\n            } else if (rule.strict) {\n                return;\n            }\n\n            /* eslint-enable eqeqeq */\n            actions.forEach(this.applyAction, this);\n        },\n\n        /**\n         *\n         * @param {Object} action - Action object.\n         */\n        applyAction: function (action) {\n            registry.get(action.target, function (target) {\n                var callback = target[action.callback];\n\n                callback.apply(target, action.params || []);\n            });\n        },\n\n        /**\n         *\n         * @param {Object} rule - Rules object.\n         * @param {*} value - Current value associated with a rule.\n         */\n        onValueChange: function (rule, value) {\n            this.applyRule(rule, value);\n        }\n    });\n});\n","Magento_Ui/js/form/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/lib/spinner',\n    'rjsResolver',\n    './adapter',\n    'uiCollection',\n    'mageUtils',\n    'jquery',\n    'Magento_Ui/js/core/app',\n    'mage/validation'\n], function (_, loader, resolver, adapter, Collection, utils, $, app) {\n    'use strict';\n\n    /**\n     * Format params\n     *\n     * @param {Object} params\n     * @returns {Array}\n     */\n    function prepareParams(params) {\n        var result = '?';\n\n        _.each(params, function (value, key) {\n            result += key + '=' + value + '&';\n        });\n\n        return result.slice(0, -1);\n    }\n\n    /**\n     * Collect form data.\n     *\n     * @param {Array} items\n     * @returns {Object}\n     */\n    function collectData(items) {\n        var result = {},\n            name;\n\n        items = Array.prototype.slice.call(items);\n\n        items.forEach(function (item) {\n            switch (item.type) {\n                case 'checkbox':\n                    result[item.name] = +!!item.checked;\n                    break;\n\n                case 'radio':\n                    if (item.checked) {\n                        result[item.name] = item.value;\n                    }\n                    break;\n\n                case 'select-multiple':\n                    name = item.name.substring(0, item.name.length - 2); //remove [] from the name ending\n                    result[name] = _.pluck(item.selectedOptions, 'value');\n                    break;\n\n                default:\n                    result[item.name] = item.value;\n            }\n        });\n\n        return result;\n    }\n\n    /**\n     * Makes ajax request\n     *\n     * @param {Object} params\n     * @param {Object} data\n     * @param {String} url\n     * @returns {*}\n     */\n    function makeRequest(params, data, url) {\n        var save = $.Deferred();\n\n        data = utils.serialize(data);\n        data['form_key'] = window.FORM_KEY;\n\n        if (!url) {\n            save.resolve();\n        }\n\n        $('body').trigger('processStart');\n\n        $.ajax({\n            url: url + prepareParams(params),\n            data: data,\n            dataType: 'json',\n\n            /**\n             * Success callback.\n             * @param {Object} resp\n             * @returns {Boolean}\n             */\n            success: function (resp) {\n                if (resp.ajaxExpired) {\n                    window.location.href = resp.ajaxRedirect;\n                }\n\n                if (!resp.error) {\n                    save.resolve(resp);\n\n                    return true;\n                }\n\n                $('body').notification('clear');\n                $.each(resp.messages, function (key, message) {\n                    $('body').notification('add', {\n                        error: resp.error,\n                        message: message,\n\n                        /**\n                         * Inserts message on page\n                         * @param {String} msg\n                         */\n                        insertMethod: function (msg) {\n                            $('.page-main-actions').after(msg);\n                        }\n                    });\n                });\n            },\n\n            /**\n             * Complete callback.\n             */\n            complete: function () {\n                $('body').trigger('processStop');\n            }\n        });\n\n        return save.promise();\n    }\n\n    /**\n     * Check if fields is valid.\n     *\n     * @param {Array}items\n     * @returns {Boolean}\n     */\n    function isValidFields(items) {\n        var result = true;\n\n        _.each(items, function (item) {\n            if (!$.validator.validateSingleElement(item)) {\n                result = false;\n            }\n        });\n\n        return result;\n    }\n\n    return Collection.extend({\n        defaults: {\n            additionalFields: [],\n            additionalInvalid: false,\n            selectorPrefix: '.page-content',\n            messagesClass: 'messages',\n            errorClass: '.admin__field._error',\n            eventPrefix: '.${ $.index }',\n            ajaxSave: false,\n            ajaxSaveType: 'default',\n            imports: {\n                reloadUrl: '${ $.provider}:reloadUrl'\n            },\n            listens: {\n                selectorPrefix: 'destroyAdapter initAdapter',\n                '${ $.name }.${ $.reloadItem }': 'params.set reload'\n            },\n            exports: {\n                selectorPrefix: '${ $.provider }:client.selectorPrefix',\n                messagesClass: '${ $.provider }:client.messagesClass'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super()\n                .initAdapter();\n\n            resolver(this.hideLoader, this);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe([\n                    'r