require.config({"config": {
        "jsbuild":{"Magento_Tinymce3/tiny_mce/tiny_mce_src.js":"(function(win) {\n\tvar whiteSpaceRe = /^\\s*|\\s*$/g,\n\t\tundefined, isRegExpBroken = 'B'.replace(/A(.)|B/, '$1') === '$1';\n\n\tvar tinymce = {\n\t\tmajorVersion : '3',\n\n\t\tminorVersion : '4.7',\n\n\t\treleaseDate : '2011-11-03',\n\n\t\t_init : function() {\n\t\t\tvar t = this, d = document, na = navigator, ua = na.userAgent, i, nl, n, base, p, v;\n\n\t\t\tt.isOpera = win.opera && opera.buildNumber;\n\n\t\t\tt.isWebKit = /WebKit/.test(ua);\n\n\t\t\tt.isIE = !t.isWebKit && !t.isOpera && (/MSIE/gi).test(ua) && (/Explorer/gi).test(na.appName);\n\n\t\t\tt.isIE6 = t.isIE && /MSIE [56]/.test(ua);\n\n\t\t\tt.isIE7 = t.isIE && /MSIE [7]/.test(ua);\n\n\t\t\tt.isIE8 = t.isIE && /MSIE [8]/.test(ua);\n\n\t\t\tt.isIE9 = t.isIE && /MSIE [9]/.test(ua);\n\n\t\t\tt.isGecko = !t.isWebKit && /Gecko/.test(ua);\n\n\t\t\tt.isMac = ua.indexOf('Mac') != -1;\n\n\t\t\tt.isAir = /adobeair/i.test(ua);\n\n\t\t\tt.isIDevice = /(iPad|iPhone)/.test(ua);\n\n\t\t\tt.isIOS5 = t.isIDevice && ua.match(/AppleWebKit\\/(\\d*)/)[1]>=534;\n\n\t\t\t// TinyMCE .NET webcontrol might be setting the values for TinyMCE\n\t\t\tif (win.tinyMCEPreInit) {\n\t\t\t\tt.suffix = tinyMCEPreInit.suffix;\n\t\t\t\tt.baseURL = tinyMCEPreInit.base;\n\t\t\t\tt.query = tinyMCEPreInit.query;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Get suffix and base\n\t\t\tt.suffix = '';\n\n\t\t\t// If base element found, add that infront of baseURL\n\t\t\tnl = d.getElementsByTagName('base');\n\t\t\tfor (i=0; i<nl.length; i++) {\n\t\t\t\tif (v = nl[i].href) {\n\t\t\t\t\t// Host only value like http://site.com or http://site.com:8008\n\t\t\t\t\tif (/^https?:\\/\\/[^\\/]+$/.test(v))\n\t\t\t\t\t\tv += '/';\n\n\t\t\t\t\tbase = v ? v.match(/.*\\//)[0] : ''; // Get only directory\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfunction getBase(n) {\n\t\t\t\tif (n.src && /tiny_mce(|_gzip|_jquery|_prototype|_full)(_dev|_src)?.js/.test(n.src)) {\n\t\t\t\t\tif (/_(src|dev)\\.js/g.test(n.src))\n\t\t\t\t\t\tt.suffix = '_src';\n\n\t\t\t\t\tif ((p = n.src.indexOf('?')) != -1)\n\t\t\t\t\t\tt.query = n.src.substring(p + 1);\n\n\t\t\t\t\tt.baseURL = n.src.substring(0, n.src.lastIndexOf('/'));\n\n\t\t\t\t\t// If path to script is relative and a base href was found add that one infront\n\t\t\t\t\t// the src property will always be an absolute one on non IE browsers and IE 8\n\t\t\t\t\t// so this logic will basically only be executed on older IE versions\n\t\t\t\t\tif (base && t.baseURL.indexOf('://') == -1 && t.baseURL.indexOf('/') !== 0)\n\t\t\t\t\t\tt.baseURL = base + t.baseURL;\n\n\t\t\t\t\treturn t.baseURL;\n\t\t\t\t}\n\n\t\t\t\treturn null;\n\t\t\t};\n\n\t\t\t// Check document\n\t\t\tnl = d.getElementsByTagName('script');\n\t\t\tfor (i=0; i<nl.length; i++) {\n\t\t\t\tif (getBase(nl[i]))\n\t\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Check head\n\t\t\tn = d.getElementsByTagName('head')[0];\n\t\t\tif (n) {\n\t\t\t\tnl = n.getElementsByTagName('script');\n\t\t\t\tfor (i=0; i<nl.length; i++) {\n\t\t\t\t\tif (getBase(nl[i]))\n\t\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn;\n\t\t},\n\n\t\tis : function(o, t) {\n\t\t\tif (!t)\n\t\t\t\treturn o !== undefined;\n\n\t\t\tif (t == 'array' && (o.hasOwnProperty && o instanceof Array))\n\t\t\t\treturn true;\n\n\t\t\treturn typeof(o) == t;\n\t\t},\n\n\t\tmakeMap : function(items, delim, map) {\n\t\t\tvar i;\n\n\t\t\titems = items || [];\n\t\t\tdelim = delim || ',';\n\n\t\t\tif (typeof(items) == \"string\")\n\t\t\t\titems = items.split(delim);\n\n\t\t\tmap = map || {};\n\n\t\t\ti = items.length;\n\t\t\twhile (i--)\n\t\t\t\tmap[items[i]] = {};\n\n\t\t\treturn map;\n\t\t},\n\n\t\teach : function(o, cb, s) {\n\t\t\tvar n, l;\n\n\t\t\tif (!o)\n\t\t\t\treturn 0;\n\n\t\t\ts = s || o;\n\n\t\t\tif (o.length !== undefined) {\n\t\t\t\t// Indexed arrays, needed for Safari\n\t\t\t\tfor (n=0, l = o.length; n < l; n++) {\n\t\t\t\t\tif (cb.call(s, o[n], n, o) === false)\n\t\t\t\t\t\treturn 0;\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Hashtables\n\t\t\t\tfor (n in o) {\n\t\t\t\t\tif (o.hasOwnProperty(n)) {\n\t\t\t\t\t\tif (cb.call(s, o[n], n, o) === false)\n\t\t\t\t\t\t\treturn 0;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn 1;\n\t\t},\n\n\n\t\tmap : function(a, f) {\n\t\t\tvar o = [];\n\n\t\t\ttinymce.each(a, function(v) {\n\t\t\t\to.push(f(v));\n\t\t\t});\n\n\t\t\treturn o;\n\t\t},\n\n\t\tgrep : function(a, f) {\n\t\t\tvar o = [];\n\n\t\t\ttinymce.each(a, function(v) {\n\t\t\t\tif (!f || f(v))\n\t\t\t\t\to.push(v);\n\t\t\t});\n\n\t\t\treturn o;\n\t\t},\n\n\t\tinArray : function(a, v) {\n\t\t\tvar i, l;\n\n\t\t\tif (a) {\n\t\t\t\tfor (i = 0, l = a.length; i < l; i++) {\n\t\t\t\t\tif (a[i] === v)\n\t\t\t\t\t\treturn i;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn -1;\n\t\t},\n\n\t\textend : function(o, e) {\n\t\t\tvar i, l, a = arguments;\n\n\t\t\tfor (i = 1, l = a.length; i < l; i++) {\n\t\t\t\te = a[i];\n\n\t\t\t\ttinymce.each(e, function(v, n) {\n\t\t\t\t\tif (v !== undefined)\n\t\t\t\t\t\to[n] = v;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn o;\n\t\t},\n\n\n\t\ttrim : function(s) {\n\t\t\treturn (s ? '' + s : '').replace(whiteSpaceRe, '');\n\t\t},\n\n\t\tcreate : function(s, p, root) {\n\t\t\tvar t = this, sp, ns, cn, scn, c, de = 0;\n\n\t\t\t// Parse : <prefix> <class>:<super class>\n\t\t\ts = /^((static) )?([\\w.]+)(:([\\w.]+))?/.exec(s);\n\t\t\tcn = s[3].match(/(^|\\.)(\\w+)$/i)[2]; // Class name\n\n\t\t\t// Create namespace for new class\n\t\t\tns = t.createNS(s[3].replace(/\\.\\w+$/, ''), root);\n\n\t\t\t// Class already exists\n\t\t\tif (ns[cn])\n\t\t\t\treturn;\n\n\t\t\t// Make pure static class\n\t\t\tif (s[2] == 'static') {\n\t\t\t\tns[cn] = p;\n\n\t\t\t\tif (this.onCreate)\n\t\t\t\t\tthis.onCreate(s[2], s[3], ns[cn]);\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Create default constructor\n\t\t\tif (!p[cn]) {\n\t\t\t\tp[cn] = function() {};\n\t\t\t\tde = 1;\n\t\t\t}\n\n\t\t\t// Add constructor and methods\n\t\t\tns[cn] = p[cn];\n\t\t\tt.extend(ns[cn].prototype, p);\n\n\t\t\t// Extend\n\t\t\tif (s[5]) {\n\t\t\t\tsp = t.resolve(s[5]).prototype;\n\t\t\t\tscn = s[5].match(/\\.(\\w+)$/i)[1]; // Class name\n\n\t\t\t\t// Extend constructor\n\t\t\t\tc = ns[cn];\n\t\t\t\tif (de) {\n\t\t\t\t\t// Add passthrough constructor\n\t\t\t\t\tns[cn] = function() {\n\t\t\t\t\t\treturn sp[scn].apply(this, arguments);\n\t\t\t\t\t};\n\t\t\t\t} else {\n\t\t\t\t\t// Add inherit constructor\n\t\t\t\t\tns[cn] = function() {\n\t\t\t\t\t\tthis.parent = sp[scn];\n\t\t\t\t\t\treturn c.apply(this, arguments);\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t\tns[cn].prototype[cn] = ns[cn];\n\n\t\t\t\t// Add super methods\n\t\t\t\tt.each(sp, function(f, n) {\n\t\t\t\t\tns[cn].prototype[n] = sp[n];\n\t\t\t\t});\n\n\t\t\t\t// Add overridden methods\n\t\t\t\tt.each(p, function(f, n) {\n\t\t\t\t\t// Extend methods if needed\n\t\t\t\t\tif (sp[n]) {\n\t\t\t\t\t\tns[cn].prototype[n] = function() {\n\t\t\t\t\t\t\tthis.parent = sp[n];\n\t\t\t\t\t\t\treturn f.apply(this, arguments);\n\t\t\t\t\t\t};\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif (n != cn)\n\t\t\t\t\t\t\tns[cn].prototype[n] = f;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Add static methods\n\t\t\tt.each(p['static'], function(f, n) {\n\t\t\t\tns[cn][n] = f;\n\t\t\t});\n\n\t\t\tif (this.onCreate)\n\t\t\t\tthis.onCreate(s[2], s[3], ns[cn].prototype);\n\t\t},\n\n\t\twalk : function(o, f, n, s) {\n\t\t\ts = s || this;\n\n\t\t\tif (o) {\n\t\t\t\tif (n)\n\t\t\t\t\to = o[n];\n\n\t\t\t\ttinymce.each(o, function(o, i) {\n\t\t\t\t\tif (f.call(s, o, i, n) === false)\n\t\t\t\t\t\treturn false;\n\n\t\t\t\t\ttinymce.walk(o, f, n, s);\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\tcreateNS : function(n, o) {\n\t\t\tvar i, v;\n\n\t\t\to = o || win;\n\n\t\t\tn = n.split('.');\n\t\t\tfor (i=0; i<n.length; i++) {\n\t\t\t\tv = n[i];\n\n\t\t\t\tif (!o[v])\n\t\t\t\t\to[v] = {};\n\n\t\t\t\to = o[v];\n\t\t\t}\n\n\t\t\treturn o;\n\t\t},\n\n\t\tresolve : function(n, o) {\n\t\t\tvar i, l;\n\n\t\t\to = o || win;\n\n\t\t\tn = n.split('.');\n\t\t\tfor (i = 0, l = n.length; i < l; i++) {\n\t\t\t\to = o[n[i]];\n\n\t\t\t\tif (!o)\n\t\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\treturn o;\n\t\t},\n\n\t\taddUnload : function(f, s) {\n\t\t\tvar t = this;\n\n\t\t\tf = {func : f, scope : s || this};\n\n\t\t\tif (!t.unloads) {\n\t\t\t\tfunction unload() {\n\t\t\t\t\tvar li = t.unloads, o, n;\n\n\t\t\t\t\tif (li) {\n\t\t\t\t\t\t// Call unload handlers\n\t\t\t\t\t\tfor (n in li) {\n\t\t\t\t\t\t\to = li[n];\n\n\t\t\t\t\t\t\tif (o && o.func)\n\t\t\t\t\t\t\t\to.func.call(o.scope, 1); // Send in one arg to distinct unload and user destroy\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Detach unload function\n\t\t\t\t\t\tif (win.detachEvent) {\n\t\t\t\t\t\t\twin.detachEvent('onbeforeunload', fakeUnload);\n\t\t\t\t\t\t\twin.detachEvent('onunload', unload);\n\t\t\t\t\t\t} else if (win.removeEventListener)\n\t\t\t\t\t\t\twin.removeEventListener('unload', unload, false);\n\n\t\t\t\t\t\t// Destroy references\n\t\t\t\t\t\tt.unloads = o = li = w = unload = 0;\n\n\t\t\t\t\t\t// Run garbarge collector on IE\n\t\t\t\t\t\tif (win.CollectGarbage)\n\t\t\t\t\t\t\tCollectGarbage();\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\tfunction fakeUnload() {\n\t\t\t\t\tvar d = document;\n\n\t\t\t\t\t// Is there things still loading, then do some magic\n\t\t\t\t\tif (d.readyState == 'interactive') {\n\t\t\t\t\t\tfunction stop() {\n\t\t\t\t\t\t\t// Prevent memory leak\n\t\t\t\t\t\t\td.detachEvent('onstop', stop);\n\n\t\t\t\t\t\t\t// Call unload handler\n\t\t\t\t\t\t\tif (unload)\n\t\t\t\t\t\t\t\tunload();\n\n\t\t\t\t\t\t\td = 0;\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\t// Fire unload when the currently loading page is stopped\n\t\t\t\t\t\tif (d)\n\t\t\t\t\t\t\td.attachEvent('onstop', stop);\n\n\t\t\t\t\t\t// Remove onstop listener after a while to prevent the unload function\n\t\t\t\t\t\t// to execute if the user presses cancel in an onbeforeunload\n\t\t\t\t\t\t// confirm dialog and then presses the browser stop button\n\t\t\t\t\t\twin.setTimeout(function() {\n\t\t\t\t\t\t\tif (d)\n\t\t\t\t\t\t\t\td.detachEvent('onstop', stop);\n\t\t\t\t\t\t}, 0);\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\t// Attach unload handler\n\t\t\t\tif (win.attachEvent) {\n\t\t\t\t\twin.attachEvent('onunload', unload);\n\t\t\t\t\twin.attachEvent('onbeforeunload', fakeUnload);\n\t\t\t\t} else if (win.addEventListener)\n\t\t\t\t\twin.addEventListener('unload', unload, false);\n\n\t\t\t\t// Setup initial unload handler array\n\t\t\t\tt.unloads = [f];\n\t\t\t} else\n\t\t\t\tt.unloads.push(f);\n\n\t\t\treturn f;\n\t\t},\n\n\t\tremoveUnload : function(f) {\n\t\t\tvar u = this.unloads, r = null;\n\n\t\t\ttinymce.each(u, function(o, i) {\n\t\t\t\tif (o && o.func == f) {\n\t\t\t\t\tu.splice(i, 1);\n\t\t\t\t\tr = f;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn r;\n\t\t},\n\n\t\texplode : function(s, d) {\n\t\t\treturn s ? tinymce.map(s.split(d || ','), tinymce.trim) : s;\n\t\t},\n\n\t\t_addVer : function(u) {\n\t\t\tvar v;\n\n\t\t\tif (!this.query)\n\t\t\t\treturn u;\n\n\t\t\tv = (u.indexOf('?') == -1 ? '?' : '&') + this.query;\n\n\t\t\tif (u.indexOf('#') == -1)\n\t\t\t\treturn u + v;\n\n\t\t\treturn u.replace('#', v + '#');\n\t\t},\n\n\t\t// Fix function for IE 9 where regexps isn't working correctly\n\t\t// Todo: remove me once MS fixes the bug\n\t\t_replace : function(find, replace, str) {\n\t\t\t// On IE9 we have to fake $x replacement\n\t\t\tif (isRegExpBroken) {\n\t\t\t\treturn str.replace(find, function() {\n\t\t\t\t\tvar val = replace, args = arguments, i;\n\n\t\t\t\t\tfor (i = 0; i < args.length - 2; i++) {\n\t\t\t\t\t\tif (args[i] === undefined) {\n\t\t\t\t\t\t\tval = val.replace(new RegExp('\\\\$' + i, 'g'), '');\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tval = val.replace(new RegExp('\\\\$' + i, 'g'), args[i]);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn val;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn str.replace(find, replace);\n\t\t}\n\n\t\t};\n\n\t// Initialize the API\n\ttinymce._init();\n\n\t// Expose tinymce namespace to the global namespace (window)\n\twin.tinymce = win.tinyMCE = tinymce;\n\n\t// Describe the different namespaces\n\n\t})(window);\n\n\n\ntinymce.create('tinymce.util.Dispatcher', {\n\tscope : null,\n\tlisteners : null,\n\n\tDispatcher : function(s) {\n\t\tthis.scope = s || this;\n\t\tthis.listeners = [];\n\t},\n\n\tadd : function(cb, s) {\n\t\tthis.listeners.push({cb : cb, scope : s || this.scope});\n\n\t\treturn cb;\n\t},\n\n\taddToTop : function(cb, s) {\n\t\tthis.listeners.unshift({cb : cb, scope : s || this.scope});\n\n\t\treturn cb;\n\t},\n\n\tremove : function(cb) {\n\t\tvar l = this.listeners, o = null;\n\n\t\ttinymce.each(l, function(c, i) {\n\t\t\tif (cb == c.cb) {\n\t\t\t\to = cb;\n\t\t\t\tl.splice(i, 1);\n\t\t\t\treturn false;\n\t\t\t}\n\t\t});\n\n\t\treturn o;\n\t},\n\n\tdispatch : function() {\n\t\tvar s, a = arguments, i, li = this.listeners, c;\n\n\t\t// Needs to be a real loop since the listener count might change while looping\n\t\t// And this is also more efficient\n\t\tfor (i = 0; i<li.length; i++) {\n\t\t\tc = li[i];\n\t\t\ts = c.cb.apply(c.scope, a);\n\n\t\t\tif (s === false)\n\t\t\t\tbreak;\n\t\t}\n\n\t\treturn s;\n\t}\n\n\t});\n\n(function() {\n\tvar each = tinymce.each;\n\n\ttinymce.create('tinymce.util.URI', {\n\t\tURI : function(u, s) {\n\t\t\tvar t = this, o, a, b, base_url;\n\n\t\t\t// Trim whitespace\n\t\t\tu = tinymce.trim(u);\n\n\t\t\t// Default settings\n\t\t\ts = t.settings = s || {};\n\n\t\t\t// Strange app protocol that isn't http/https or local anchor\n\t\t\t// For example: mailto,skype,tel etc.\n\t\t\tif (/^([\\w\\-]+):([^\\/]{2})/i.test(u) || /^\\s*#/.test(u)) {\n\t\t\t\tt.source = u;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Absolute path with no host, fake host and protocol\n\t\t\tif (u.indexOf('/') === 0 && u.indexOf('//') !== 0)\n\t\t\t\tu = (s.base_uri ? s.base_uri.protocol || 'http' : 'http') + '://mce_host' + u;\n\n\t\t\t// Relative path http:// or protocol relative //path\n\t\t\tif (!/^[\\w-]*:?\\/\\//.test(u)) {\n\t\t\t\tbase_url = s.base_uri ? s.base_uri.path : new tinymce.util.URI(location.href).directory;\n\t\t\t\tu = ((s.base_uri && s.base_uri.protocol) || 'http') + '://mce_host' + t.toAbsPath(base_url, u);\n\t\t\t}\n\n\t\t\t// Parse URL (Credits goes to Steave, http://blog.stevenlevithan.com/archives/parseuri)\n\t\t\tu = u.replace(/@@/g, '(mce_at)'); // Zope 3 workaround, they use @@something\n\t\t\tu = /^(?:(?![^:@]+:[^:@\\/]*@)([^:\\/?#.]+):)?(?:\\/\\/)?((?:(([^:@]*):?([^:@]*))?@)?([^:\\/?#]*)(?::(\\d*))?)(((\\/(?:[^?#](?![^?#\\/]*\\.[^?#\\/.]+(?:[?#]|$)))*\\/?)?([^?#\\/]*))(?:\\?([^#]*))?(?:#(.*))?)/.exec(u);\n\t\t\teach([\"source\",\"protocol\",\"authority\",\"userInfo\",\"user\",\"password\",\"host\",\"port\",\"relative\",\"path\",\"directory\",\"file\",\"query\",\"anchor\"], function(v, i) {\n\t\t\t\tvar s = u[i];\n\n\t\t\t\t// Zope 3 workaround, they use @@something\n\t\t\t\tif (s)\n\t\t\t\t\ts = s.replace(/\\(mce_at\\)/g, '@@');\n\n\t\t\t\tt[v] = s;\n\t\t\t});\n\n\t\t\tif (b = s.base_uri) {\n\t\t\t\tif (!t.protocol)\n\t\t\t\t\tt.protocol = b.protocol;\n\n\t\t\t\tif (!t.userInfo)\n\t\t\t\t\tt.userInfo = b.userInfo;\n\n\t\t\t\tif (!t.port && t.host == 'mce_host')\n\t\t\t\t\tt.port = b.port;\n\n\t\t\t\tif (!t.host || t.host == 'mce_host')\n\t\t\t\t\tt.host = b.host;\n\n\t\t\t\tt.source = '';\n\t\t\t}\n\n\t\t\t//t.path = t.path || '/';\n\t\t},\n\n\t\tsetPath : function(p) {\n\t\t\tvar t = this;\n\n\t\t\tp = /^(.*?)\\/?(\\w+)?$/.exec(p);\n\n\t\t\t// Update path parts\n\t\t\tt.path = p[0];\n\t\t\tt.directory = p[1];\n\t\t\tt.file = p[2];\n\n\t\t\t// Rebuild source\n\t\t\tt.source = '';\n\t\t\tt.getURI();\n\t\t},\n\n\t\ttoRelative : function(u) {\n\t\t\tvar t = this, o;\n\n\t\t\tif (u === \"./\")\n\t\t\t\treturn u;\n\n\t\t\tu = new tinymce.util.URI(u, {base_uri : t});\n\n\t\t\t// Not on same domain/port or protocol\n\t\t\tif ((u.host != 'mce_host' && t.host != u.host && u.host) || t.port != u.port || t.protocol != u.protocol)\n\t\t\t\treturn u.getURI();\n\n\t\t\to = t.toRelPath(t.path, u.path);\n\n\t\t\t// Add query\n\t\t\tif (u.query)\n\t\t\t\to += '?' + u.query;\n\n\t\t\t// Add anchor\n\t\t\tif (u.anchor)\n\t\t\t\to += '#' + u.anchor;\n\n\t\t\treturn o;\n\t\t},\n\n\t\ttoAbsolute : function(u, nh) {\n\t\t\tvar u = new tinymce.util.URI(u, {base_uri : this});\n\n\t\t\treturn u.getURI(this.host == u.host && this.protocol == u.protocol ? nh : 0);\n\t\t},\n\n\t\ttoRelPath : function(base, path) {\n\t\t\tvar items, bp = 0, out = '', i, l;\n\n\t\t\t// Split the paths\n\t\t\tbase = base.substring(0, base.lastIndexOf('/'));\n\t\t\tbase = base.split('/');\n\t\t\titems = path.split('/');\n\n\t\t\tif (base.length >= items.length) {\n\t\t\t\tfor (i = 0, l = base.length; i < l; i++) {\n\t\t\t\t\tif (i >= items.length || base[i] != items[i]) {\n\t\t\t\t\t\tbp = i + 1;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (base.length < items.length) {\n\t\t\t\tfor (i = 0, l = items.length; i < l; i++) {\n\t\t\t\t\tif (i >= base.length || base[i] != items[i]) {\n\t\t\t\t\t\tbp = i + 1;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (bp == 1)\n\t\t\t\treturn path;\n\n\t\t\tfor (i = 0, l = base.length - (bp - 1); i < l; i++)\n\t\t\t\tout += \"../\";\n\n\t\t\tfor (i = bp - 1, l = items.length; i < l; i++) {\n\t\t\t\tif (i != bp - 1)\n\t\t\t\t\tout += \"/\" + items[i];\n\t\t\t\telse\n\t\t\t\t\tout += items[i];\n\t\t\t}\n\n\t\t\treturn out;\n\t\t},\n\n\t\ttoAbsPath : function(base, path) {\n\t\t\tvar i, nb = 0, o = [], tr, outPath;\n\n\t\t\t// Split paths\n\t\t\ttr = /\\/$/.test(path) ? '/' : '';\n\t\t\tbase = base.split('/');\n\t\t\tpath = path.split('/');\n\n\t\t\t// Remove empty chunks\n\t\t\teach(base, function(k) {\n\t\t\t\tif (k)\n\t\t\t\t\to.push(k);\n\t\t\t});\n\n\t\t\tbase = o;\n\n\t\t\t// Merge relURLParts chunks\n\t\t\tfor (i = path.length - 1, o = []; i >= 0; i--) {\n\t\t\t\t// Ignore empty or .\n\t\t\t\tif (path[i].length == 0 || path[i] == \".\")\n\t\t\t\t\tcontinue;\n\n\t\t\t\t// Is parent\n\t\t\t\tif (path[i] == '..') {\n\t\t\t\t\tnb++;\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\t// Move up\n\t\t\t\tif (nb > 0) {\n\t\t\t\t\tnb--;\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\to.push(path[i]);\n\t\t\t}\n\n\t\t\ti = base.length - nb;\n\n\t\t\t// If /a/b/c or /\n\t\t\tif (i <= 0)\n\t\t\t\toutPath = o.reverse().join('/');\n\t\t\telse\n\t\t\t\toutPath = base.slice(0, i).join('/') + '/' + o.reverse().join('/');\n\n\t\t\t// Add front / if it's needed\n\t\t\tif (outPath.indexOf('/') !== 0)\n\t\t\t\toutPath = '/' + outPath;\n\n\t\t\t// Add traling / if it's needed\n\t\t\tif (tr && outPath.lastIndexOf('/') !== outPath.length - 1)\n\t\t\t\toutPath += tr;\n\n\t\t\treturn outPath;\n\t\t},\n\n\t\tgetURI : function(nh) {\n\t\t\tvar s, t = this;\n\n\t\t\t// Rebuild source\n\t\t\tif (!t.source || nh) {\n\t\t\t\ts = '';\n\n\t\t\t\tif (!nh) {\n\t\t\t\t\tif (t.protocol)\n\t\t\t\t\t\ts += t.protocol + '://';\n\n\t\t\t\t\tif (t.userInfo)\n\t\t\t\t\t\ts += t.userInfo + '@';\n\n\t\t\t\t\tif (t.host)\n\t\t\t\t\t\ts += t.host;\n\n\t\t\t\t\tif (t.port)\n\t\t\t\t\t\ts += ':' + t.port;\n\t\t\t\t}\n\n\t\t\t\tif (t.path)\n\t\t\t\t\ts += t.path;\n\n\t\t\t\tif (t.query)\n\t\t\t\t\ts += '?' + t.query;\n\n\t\t\t\tif (t.anchor)\n\t\t\t\t\ts += '#' + t.anchor;\n\n\t\t\t\tt.source = s;\n\t\t\t}\n\n\t\t\treturn t.source;\n\t\t}\n\t});\n})();\n\n(function() {\n\tvar each = tinymce.each;\n\n\ttinymce.create('static tinymce.util.Cookie', {\n\t\tgetHash : function(n) {\n\t\t\tvar v = this.get(n), h;\n\n\t\t\tif (v) {\n\t\t\t\teach(v.split('&'), function(v) {\n\t\t\t\t\tv = v.split('=');\n\t\t\t\t\th = h || {};\n\t\t\t\t\th[unescape(v[0])] = unescape(v[1]);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn h;\n\t\t},\n\n\t\tsetHash : function(n, v, e, p, d, s) {\n\t\t\tvar o = '';\n\n\t\t\teach(v, function(v, k) {\n\t\t\t\to += (!o ? '' : '&') + escape(k) + '=' + escape(v);\n\t\t\t});\n\n\t\t\tthis.set(n, o, e, p, d, s);\n\t\t},\n\n\t\tget : function(n) {\n\t\t\tvar c = document.cookie, e, p = n + \"=\", b;\n\n\t\t\t// Strict mode\n\t\t\tif (!c)\n\t\t\t\treturn;\n\n\t\t\tb = c.indexOf(\"; \" + p);\n\n\t\t\tif (b == -1) {\n\t\t\t\tb = c.indexOf(p);\n\n\t\t\t\tif (b != 0)\n\t\t\t\t\treturn null;\n\t\t\t} else\n\t\t\t\tb += 2;\n\n\t\t\te = c.indexOf(\";\", b);\n\n\t\t\tif (e == -1)\n\t\t\t\te = c.length;\n\n\t\t\treturn unescape(c.substring(b + p.length, e));\n\t\t},\n\n\t\tset : function(n, v, e, p, d, s) {\n\t\t\tdocument.cookie = n + \"=\" + escape(v) +\n\t\t\t\t((e) ? \"; expires=\" + e.toUTCString() : \"\") +\n\t\t\t\t((p) ? \"; path=\" + escape(p) : \"\") +\n\t\t\t\t((d) ? \"; domain=\" + d : \"\") +\n\t\t\t\t((s) ? \"; secure\" : \"\");\n\t\t},\n\n\t\tremove : function(n, p) {\n\t\t\tvar d = new Date();\n\n\t\t\td.setTime(d.getTime() - 1000);\n\n\t\t\tthis.set(n, '', d, p, d);\n\t\t}\n\t});\n})();\n\n(function() {\n\tfunction serialize(o, quote) {\n\t\tvar i, v, t;\n\n\t\tquote = quote || '\"';\n\n\t\tif (o == null)\n\t\t\treturn 'null';\n\n\t\tt = typeof o;\n\n\t\tif (t == 'string') {\n\t\t\tv = '\\bb\\tt\\nn\\ff\\rr\\\"\"\\'\\'\\\\\\\\';\n\n\t\t\treturn quote + o.replace(/([\\u0080-\\uFFFF\\x00-\\x1f\\\"\\'\\\\])/g, function(a, b) {\n\t\t\t\t// Make sure single quotes never get encoded inside double quotes for JSON compatibility\n\t\t\t\tif (quote === '\"' && a === \"'\")\n\t\t\t\t\treturn a;\n\n\t\t\t\ti = v.indexOf(b);\n\n\t\t\t\tif (i + 1)\n\t\t\t\t\treturn '\\\\' + v.charAt(i + 1);\n\n\t\t\t\ta = b.charCodeAt().toString(16);\n\n\t\t\t\treturn '\\\\u' + '0000'.substring(a.length) + a;\n\t\t\t}) + quote;\n\t\t}\n\n\t\tif (t == 'object') {\n\t\t\tif (o.hasOwnProperty && o instanceof Array) {\n\t\t\t\t\tfor (i=0, v = '['; i<o.length; i++)\n\t\t\t\t\t\tv += (i > 0 ? ',' : '') + serialize(o[i], quote);\n\n\t\t\t\t\treturn v + ']';\n\t\t\t\t}\n\n\t\t\t\tv = '{';\n\n\t\t\t\tfor (i in o) {\n\t\t\t\t\tif (o.hasOwnProperty(i)) {\n\t\t\t\t\t\tv += typeof o[i] != 'function' ? (v.length > 1 ? ',' + quote : quote) + i + quote +':' + serialize(o[i], quote) : '';\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn v + '}';\n\t\t}\n\n\t\treturn '' + o;\n\t};\n\n\ttinymce.util.JSON = {\n\t\tserialize: serialize,\n\n\t\tparse: function(s) {\n\t\t\ttry {\n\t\t\t\treturn JSON.parse(s);\n\t\t\t} catch (ex) {\n\t\t\t\t// Ignore\n\t\t\t}\n\t\t}\n\n\t\t};\n})();\n\ntinymce.create('static tinymce.util.XHR', {\n\tsend : function(o) {\n\t\tvar x, t, w = window, c = 0;\n\n\t\t// Default settings\n\t\to.scope = o.scope || this;\n\t\to.success_scope = o.success_scope || o.scope;\n\t\to.error_scope = o.error_scope || o.scope;\n\t\to.async = o.async === false ? false : true;\n\t\to.data = o.data || '';\n\n\t\tfunction get(s) {\n\t\t\tx = 0;\n\n\t\t\ttry {\n\t\t\t\tx = new ActiveXObject(s);\n\t\t\t} catch (ex) {\n\t\t\t}\n\n\t\t\treturn x;\n\t\t};\n\n\t\tx = w.XMLHttpRequest ? new XMLHttpRequest() : get('Microsoft.XMLHTTP') || get('Msxml2.XMLHTTP');\n\n\t\tif (x) {\n\t\t\tif (x.overrideMimeType)\n\t\t\t\tx.overrideMimeType(o.content_type);\n\n\t\t\tx.open(o.type || (o.data ? 'POST' : 'GET'), o.url, o.async);\n\n\t\t\tif (o.content_type)\n\t\t\t\tx.setRequestHeader('Content-Type', o.content_type);\n\n\t\t\tx.setRequestHeader('X-Requested-With', 'XMLHttpRequest');\n\n\t\t\tx.send(o.data);\n\n\t\t\tfunction ready() {\n\t\t\t\tif (!o.async || x.readyState == 4 || c++ > 10000) {\n\t\t\t\t\tif (o.success && c < 10000 && x.status == 200)\n\t\t\t\t\t\to.success.call(o.success_scope, '' + x.responseText, x, o);\n\t\t\t\t\telse if (o.error)\n\t\t\t\t\t\to.error.call(o.error_scope, c > 10000 ? 'TIMED_OUT' : 'GENERAL', x, o);\n\n\t\t\t\t\tx = null;\n\t\t\t\t} else\n\t\t\t\t\tw.setTimeout(ready, 10);\n\t\t\t};\n\n\t\t\t// Syncronous request\n\t\t\tif (!o.async)\n\t\t\t\treturn ready();\n\n\t\t\t// Wait for response, onReadyStateChange can not be used since it leaks memory in IE\n\t\t\tt = w.setTimeout(ready, 10);\n\t\t}\n\t}\n});\n\n(function() {\n\tvar extend = tinymce.extend, JSON = tinymce.util.JSON, XHR = tinymce.util.XHR;\n\n\ttinymce.create('tinymce.util.JSONRequest', {\n\t\tJSONRequest : function(s) {\n\t\t\tthis.settings = extend({\n\t\t\t}, s);\n\t\t\tthis.count = 0;\n\t\t},\n\n\t\tsend : function(o) {\n\t\t\tvar ecb = o.error, scb = o.success;\n\n\t\t\to = extend(this.settings, o);\n\n\t\t\to.success = function(c, x) {\n\t\t\t\tc = JSON.parse(c);\n\n\t\t\t\tif (typeof(c) == 'undefined') {\n\t\t\t\t\tc = {\n\t\t\t\t\t\terror : 'JSON Parse error.'\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\tif (c.error)\n\t\t\t\t\tecb.call(o.error_scope || o.scope, c.error, x);\n\t\t\t\telse\n\t\t\t\t\tscb.call(o.success_scope || o.scope, c.result);\n\t\t\t};\n\n\t\t\to.error = function(ty, x) {\n\t\t\t\tif (ecb)\n\t\t\t\t\tecb.call(o.error_scope || o.scope, ty, x);\n\t\t\t};\n\n\t\t\to.data = JSON.serialize({\n\t\t\t\tid : o.id || 'c' + (this.count++),\n\t\t\t\tmethod : o.method,\n\t\t\t\tparams : o.params\n\t\t\t});\n\n\t\t\t// JSON content type for Ruby on rails. Bug: #1883287\n\t\t\to.content_type = 'application/json';\n\n\t\t\tXHR.send(o);\n\t\t},\n\n\t\t'static' : {\n\t\t\tsendRPC : function(o) {\n\t\t\t\treturn new tinymce.util.JSONRequest().send(o);\n\t\t\t}\n\t\t}\n\t});\n}());\n(function(tinymce){\n\ttinymce.VK = {\n\t\tDELETE: 46,\n\t\tBACKSPACE: 8,\n\t\tENTER: 13,\n\t\tTAB: 9,\n        SPACEBAR: 32,\n\t\tUP: 38,\n\t\tDOWN: 40\n\t}\n})(tinymce);\n\n(function(tinymce) {\n\tvar VK = tinymce.VK, BACKSPACE = VK.BACKSPACE, DELETE = VK.DELETE;\n\n\tfunction cleanupStylesWhenDeleting(ed) {\n\t\tvar dom = ed.dom, selection = ed.selection;\n\n\t\ted.onKeyDown.add(function(ed, e) {\n\t\t\tvar rng, blockElm, node, clonedSpan, isDelete;\n\n\t\t\tisDelete = e.keyCode == DELETE;\n\t\t\tif (isDelete || e.keyCode == BACKSPACE) {\n\t\t\t\te.preventDefault();\n\t\t\t\trng = selection.getRng();\n\n\t\t\t\t// Find root block\n\t\t\t\tblockElm = dom.getParent(rng.startContainer, dom.isBlock);\n\n\t\t\t\t// On delete clone the root span of the next block element\n\t\t\t\tif (isDelete)\n\t\t\t\t\tblockElm = dom.getNext(blockElm, dom.isBlock);\n\n\t\t\t\t// Locate root span element and clone it since it would otherwise get merged by the \"apple-style-span\" on delete/backspace\n\t\t\t\tif (blockElm) {\n\t\t\t\t\tnode = blockElm.firstChild;\n\n\t\t\t\t\t// Ignore empty text nodes\n\t\t\t\t\twhile (node && node.nodeType == 3 && node.nodeValue.length == 0)\n\t\t\t\t\t\tnode = node.nextSibling;\n\n\t\t\t\t\tif (node && node.nodeName === 'SPAN') {\n\t\t\t\t\t\tclonedSpan = node.cloneNode(false);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Do the backspace/delete actiopn\n\t\t\t\ted.getDoc().execCommand(isDelete ? 'ForwardDelete' : 'Delete', false, null);\n\n\t\t\t\t// Find all odd apple-style-spans\n\t\t\t\tblockElm = dom.getParent(rng.startContainer, dom.isBlock);\n\t\t\t\ttinymce.each(dom.select('span.Apple-style-span,font.Apple-style-span', blockElm), function(span) {\n\t\t\t\t\tvar bm = selection.getBookmark();\n\n\t\t\t\t\tif (clonedSpan) {\n\t\t\t\t\t\tdom.replace(clonedSpan.cloneNode(false), span, true);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tdom.remove(span, true);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Restore the selection\n\t\t\t\t\tselection.moveToBookmark(bm);\n\t\t\t\t});\n\t\t\t}\n\t\t});\n\t};\n\n\tfunction emptyEditorWhenDeleting(ed) {\n\t\ted.onKeyUp.add(function(ed, e) {\n\t\t\tvar keyCode = e.keyCode;\n\n\t\t\tif (keyCode == DELETE || keyCode == BACKSPACE) {\n\t\t\t\tif (ed.dom.isEmpty(ed.getBody())) {\n\t\t\t\t\ted.setContent('', {format : 'raw'});\n\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t};\n\n\tfunction inputMethodFocus(ed) {\n\t\ted.dom.bind(ed.getDoc(), 'focusin', function() {\n\t\t\ted.selection.setRng(ed.selection.getRng());\n\t\t});\n\t};\n\n\tfunction removeHrOnBackspace(ed) {\n\t\ted.onKeyDown.add(function(ed, e) {\n\t\t\tif (e.keyCode === BACKSPACE) {\n\t\t\t\tif (ed.selection.isCollapsed() && ed.selection.getRng(true).startOffset === 0) {\n\t\t\t\t\tvar node = ed.selection.getNode();\n\t\t\t\t\tvar previousSibling = node.previousSibling;\n\t\t\t\t\tif (previousSibling && previousSibling.nodeName && previousSibling.nodeName.toLowerCase() === \"hr\") {\n\t\t\t\t\t\ted.dom.remove(previousSibling);\n\t\t\t\t\t\ttinymce.dom.Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t})\n\t}\n\n\tfunction focusBody(ed) {\n\t\t// Fix for a focus bug in FF 3.x where the body element\n\t\t// wouldn't get proper focus if the user clicked on the HTML element\n\t\tif (!Range.prototype.getClientRects) { // Detect getClientRects got introduced in FF 4\n\t\t\ted.onMouseDown.add(function(ed, e) {\n\t\t\t\tif (e.target.nodeName === \"HTML\") {\n\t\t\t\t\tvar body = ed.getBody();\n\n\t\t\t\t\t// Blur the body it's focused but not correctly focused\n\t\t\t\t\tbody.blur();\n\n\t\t\t\t\t// Refocus the body after a little while\n\t\t\t\t\tsetTimeout(function() {\n\t\t\t\t\t\tbody.focus();\n\t\t\t\t\t}, 0);\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t};\n\n\tfunction selectControlElements(ed) {\n\t\ted.onClick.add(function(ed, e) {\n\t\t\te = e.target;\n\n\t\t\tif (/^(IMG|HR)$/.test(e.nodeName))\n\t\t\t\ted.selection.select(e);\n\n\t\t\tif (e.nodeName == 'A' && ed.dom.hasClass(e, 'mceItemAnchor'))\n\t\t\t\ted.selection.select(e);\n\n\t\t\ted.nodeChanged();\n\t\t});\n\t};\n\n\tfunction selectionChangeNodeChanged(ed) {\n\t\tvar lastRng, selectionTimer;\n\n\t\ted.dom.bind(ed.getDoc(), 'selectionchange', function() {\n\t\t\tif (selectionTimer) {\n\t\t\t\tclearTimeout(selectionTimer);\n\t\t\t\tselectionTimer = 0;\n\t\t\t}\n\n\t\t\tselectionTimer = window.setTimeout(function() {\n\t\t\t\tvar rng = ed.selection.getRng();\n\n\t\t\t\t// Compare the ranges to see if it was a real change or not\n\t\t\t\tif (!lastRng || !tinymce.dom.RangeUtils.compareRanges(rng, lastRng)) {\n\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\tlastRng = rng;\n\t\t\t\t}\n\t\t\t}, 50);\n\t\t});\n\t}\n\n\tfunction ensureBodyHasRoleApplication(ed) {\n\t\tdocument.body.setAttribute(\"role\", \"application\");\n\t}\n\n\ttinymce.create('tinymce.util.Quirks', {\n\t\tQuirks: function(ed) {\n\t\t\t// WebKit\n\t\t\tif (tinymce.isWebKit) {\n\t\t\t\tcleanupStylesWhenDeleting(ed);\n\t\t\t\temptyEditorWhenDeleting(ed);\n\t\t\t\tinputMethodFocus(ed);\n\t\t\t\tselectControlElements(ed);\n\n\t\t\t\t// iOS\n\t\t\t\tif (tinymce.isIDevice) {\n\t\t\t\t\tselectionChangeNodeChanged(ed);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// IE\n\t\t\tif (tinymce.isIE) {\n\t\t\t\tremoveHrOnBackspace(ed);\n\t\t\t\temptyEditorWhenDeleting(ed);\n\t\t\t\tensureBodyHasRoleApplication(ed);\n\t\t\t}\n\n\t\t\t// Gecko\n\t\t\tif (tinymce.isGecko) {\n\t\t\t\tremoveHrOnBackspace(ed);\n\t\t\t\tfocusBody(ed);\n\t\t\t}\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar namedEntities, baseEntities, reverseEntities,\n\t\tattrsCharsRegExp = /[&<>\\\"\\u007E-\\uD7FF\\uE000-\\uFFEF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,\n\t\ttextCharsRegExp = /[<>&\\u007E-\\uD7FF\\uE000-\\uFFEF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,\n\t\trawCharsRegExp = /[<>&\\\"\\']/g,\n\t\tentityRegExp = /&(#x|#)?([\\w]+);/g,\n\t\tasciiMap = {\n\t\t\t\t128 : \"\\u20AC\", 130 : \"\\u201A\", 131 : \"\\u0192\", 132 : \"\\u201E\", 133 : \"\\u2026\", 134 : \"\\u2020\",\n\t\t\t\t135 : \"\\u2021\", 136 : \"\\u02C6\", 137 : \"\\u2030\", 138 : \"\\u0160\", 139 : \"\\u2039\", 140 : \"\\u0152\",\n\t\t\t\t142 : \"\\u017D\", 145 : \"\\u2018\", 146 : \"\\u2019\", 147 : \"\\u201C\", 148 : \"\\u201D\", 149 : \"\\u2022\",\n\t\t\t\t150 : \"\\u2013\", 151 : \"\\u2014\", 152 : \"\\u02DC\", 153 : \"\\u2122\", 154 : \"\\u0161\", 155 : \"\\u203A\",\n\t\t\t\t156 : \"\\u0153\", 158 : \"\\u017E\", 159 : \"\\u0178\"\n\t\t};\n\n\t// Raw entities\n\tbaseEntities = {\n\t\t'\\\"' : '&quot;', // Needs to be escaped since the YUI compressor would otherwise break the code\n\t\t\"'\" : '&#39;',\n\t\t'<' : '&lt;',\n\t\t'>' : '&gt;',\n\t\t'&' : '&amp;'\n\t};\n\n\t// Reverse lookup table for raw entities\n\treverseEntities = {\n\t\t'&lt;' : '<',\n\t\t'&gt;' : '>',\n\t\t'&amp;' : '&',\n\t\t'&quot;' : '\"',\n\t\t'&apos;' : \"'\"\n\t};\n\n\t// Decodes text by using the browser\n\tfunction nativeDecode(text) {\n\t\tvar elm;\n\n\t\telm = document.createElement(\"div\");\n\t\telm.innerHTML = text;\n\n\t\treturn elm.textContent || elm.innerText || text;\n\t};\n\n\t// Build a two way lookup table for the entities\n\tfunction buildEntitiesLookup(items, radix) {\n\t\tvar i, chr, entity, lookup = {};\n\n\t\tif (items) {\n\t\t\titems = items.split(',');\n\t\t\tradix = radix || 10;\n\n\t\t\t// Build entities lookup table\n\t\t\tfor (i = 0; i < items.length; i += 2) {\n\t\t\t\tchr = String.fromCharCode(parseInt(items[i], radix));\n\n\t\t\t\t// Only add non base entities\n\t\t\t\tif (!baseEntities[chr]) {\n\t\t\t\t\tentity = '&' + items[i + 1] + ';';\n\t\t\t\t\tlookup[chr] = entity;\n\t\t\t\t\tlookup[entity] = chr;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn lookup;\n\t\t}\n\t};\n\n\t// Unpack entities lookup where the numbers are in radix 32 to reduce the size\n\tnamedEntities = buildEntitiesLookup(\n\t\t'50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,' +\n\t\t'5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,' +\n\t\t'5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,' +\n\t\t'5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,' +\n\t\t'68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,' +\n\t\t'6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,' +\n\t\t'6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,' +\n\t\t'75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,' +\n\t\t'7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,' +\n\t\t'7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,' +\n\t\t'sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,' +\n\t\t'st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,' +\n\t\t't9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,' +\n\t\t'tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,' +\n\t\t'u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,' +\n\t\t'81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,' +\n\t\t'8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,' +\n\t\t'8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,' +\n\t\t'8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,' +\n\t\t'8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,' +\n\t\t'nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,' +\n\t\t'rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,' +\n\t\t'Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,' +\n\t\t'80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,' +\n\t\t'811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro'\n\t, 32);\n\n\ttinymce.html = tinymce.html || {};\n\n\ttinymce.html.Entities = {\n\t\tencodeRaw : function(text, attr) {\n\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\treturn baseEntities[chr] || chr;\n\t\t\t});\n\t\t},\n\n\t\tencodeAllRaw : function(text) {\n\t\t\treturn ('' + text).replace(rawCharsRegExp, function(chr) {\n\t\t\t\treturn baseEntities[chr] || chr;\n\t\t\t});\n\t\t},\n\n\t\tencodeNumeric : function(text, attr) {\n\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\t// Multi byte sequence convert it to a single entity\n\t\t\t\tif (chr.length > 1)\n\t\t\t\t\treturn '&#' + (((chr.charCodeAt(0) - 0xD800) * 0x400) + (chr.charCodeAt(1) - 0xDC00) + 0x10000) + ';';\n\n\t\t\t\treturn baseEntities[chr] || '&#' + chr.charCodeAt(0) + ';';\n\t\t\t});\n\t\t},\n\n\t\tencodeNamed : function(text, attr, entities) {\n\t\t\tentities = entities || namedEntities;\n\n\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\treturn baseEntities[chr] || entities[chr] || chr;\n\t\t\t});\n\t\t},\n\n\t\tgetEncodeFunc : function(name, entities) {\n\t\t\tvar Entities = tinymce.html.Entities;\n\n\t\t\tentities = buildEntitiesLookup(entities) || namedEntities;\n\n\t\t\tfunction encodeNamedAndNumeric(text, attr) {\n\t\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\t\treturn baseEntities[chr] || entities[chr] || '&#' + chr.charCodeAt(0) + ';' || chr;\n\t\t\t\t});\n\t\t\t};\n\n\t\t\tfunction encodeCustomNamed(text, attr) {\n\t\t\t\treturn Entities.encodeNamed(text, attr, entities);\n\t\t\t};\n\n\t\t\t// Replace + with , to be compatible with previous TinyMCE versions\n\t\t\tname = tinymce.makeMap(name.replace(/\\+/g, ','));\n\n\t\t\t// Named and numeric encoder\n\t\t\tif (name.named && name.numeric)\n\t\t\t\treturn encodeNamedAndNumeric;\n\n\t\t\t// Named encoder\n\t\t\tif (name.named) {\n\t\t\t\t// Custom names\n\t\t\t\tif (entities)\n\t\t\t\t\treturn encodeCustomNamed;\n\n\t\t\t\treturn Entities.encodeNamed;\n\t\t\t}\n\n\t\t\t// Numeric\n\t\t\tif (name.numeric)\n\t\t\t\treturn Entities.encodeNumeric;\n\n\t\t\t// Raw encoder\n\t\t\treturn Entities.encodeRaw;\n\t\t},\n\n\t\tdecode : function(text) {\n\t\t\treturn text.replace(entityRegExp, function(all, numeric, value) {\n\t\t\t\tif (numeric) {\n\t\t\t\t\tvalue = parseInt(value, numeric.length === 2 ? 16 : 10);\n\n\t\t\t\t\t// Support upper UTF\n\t\t\t\t\tif (value > 0xFFFF) {\n\t\t\t\t\t\tvalue -= 0x10000;\n\n\t\t\t\t\t\treturn String.fromCharCode(0xD800 + (value >> 10), 0xDC00 + (value & 0x3FF));\n\t\t\t\t\t} else\n\t\t\t\t\t\treturn asciiMap[value] || String.fromCharCode(value);\n\t\t\t\t}\n\n\t\t\t\treturn reverseEntities[all] || namedEntities[all] || nativeDecode(all);\n\t\t\t});\n\t\t}\n\t};\n})(tinymce);\n\ntinymce.html.Styles = function(settings, schema) {\n\tvar rgbRegExp = /rgb\\s*\\(\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*\\)/gi,\n\t\turlOrStrRegExp = /(?:url(?:(?:\\(\\s*\\\"([^\\\"]+)\\\"\\s*\\))|(?:\\(\\s*\\'([^\\']+)\\'\\s*\\))|(?:\\(\\s*([^)\\s]+)\\s*\\))))|(?:\\'([^\\']+)\\')|(?:\\\"([^\\\"]+)\\\")/gi,\n\t\tstyleRegExp = /\\s*([^:]+):\\s*([^;]+);?/g,\n\t\ttrimRightRegExp = /\\s+$/,\n\t\turlColorRegExp = /rgb/,\n\t\tundef, i, encodingLookup = {}, encodingItems;\n\n\tsettings = settings || {};\n\n\tencodingItems = '\\\\\" \\\\\\' \\\\; \\\\: ; : \\uFEFF'.split(' ');\n\tfor (i = 0; i < encodingItems.length; i++) {\n\t\tencodingLookup[encodingItems[i]] = '\\uFEFF' + i;\n\t\tencodingLookup['\\uFEFF' + i] = encodingItems[i];\n\t}\n\n\tfunction toHex(match, r, g, b) {\n\t\tfunction hex(val) {\n\t\t\tval = parseInt(val).toString(16);\n\n\t\t\treturn val.length > 1 ? val : '0' + val; // 0 -> 00\n\t\t};\n\n\t\treturn '#' + hex(r) + hex(g) + hex(b);\n\t};\n\n\treturn {\n\t\ttoHex : function(color) {\n\t\t\treturn color.replace(rgbRegExp, toHex);\n\t\t},\n\n\t\tparse : function(css) {\n\t\t\tvar styles = {}, matches, name, value, isEncoded, urlConverter = settings.url_converter, urlConverterScope = settings.url_converter_scope || this;\n\n\t\t\tfunction compress(prefix, suffix) {\n\t\t\t\tvar top, right, bottom, left;\n\n\t\t\t\t// Get values and check it needs compressing\n\t\t\t\ttop = styles[prefix + '-top' + suffix];\n\t\t\t\tif (!top)\n\t\t\t\t\treturn;\n\n\t\t\t\tright = styles[prefix + '-right' + suffix];\n\t\t\t\tif (top != right)\n\t\t\t\t\treturn;\n\n\t\t\t\tbottom = styles[prefix + '-bottom' + suffix];\n\t\t\t\tif (right != bottom)\n\t\t\t\t\treturn;\n\n\t\t\t\tleft = styles[prefix + '-left' + suffix];\n\t\t\t\tif (bottom != left)\n\t\t\t\t\treturn;\n\n\t\t\t\t// Compress\n\t\t\t\tstyles[prefix + suffix] = left;\n\t\t\t\tdelete styles[prefix + '-top' + suffix];\n\t\t\t\tdelete styles[prefix + '-right' + suffix];\n\t\t\t\tdelete styles[prefix + '-bottom' + suffix];\n\t\t\t\tdelete styles[prefix + '-left' + suffix];\n\t\t\t};\n\n\t\t\tfunction canCompress(key) {\n\t\t\t\tvar value = styles[key], i;\n\n\t\t\t\tif (!value || value.indexOf(' ') < 0)\n\t\t\t\t\treturn;\n\n\t\t\t\tvalue = value.split(' ');\n\t\t\t\ti = value.length;\n\t\t\t\twhile (i--) {\n\t\t\t\t\tif (value[i] !== value[0])\n\t\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tstyles[key] = value[0];\n\n\t\t\t\treturn true;\n\t\t\t};\n\n\t\t\tfunction compress2(target, a, b, c) {\n\t\t\t\tif (!canCompress(a))\n\t\t\t\t\treturn;\n\n\t\t\t\tif (!canCompress(b))\n\t\t\t\t\treturn;\n\n\t\t\t\tif (!canCompress(c))\n\t\t\t\t\treturn;\n\n\t\t\t\t// Compress\n\t\t\t\tstyles[target] = styles[a] + ' ' + styles[b] + ' ' + styles[c];\n\t\t\t\tdelete styles[a];\n\t\t\t\tdelete styles[b];\n\t\t\t\tdelete styles[c];\n\t\t\t};\n\n\t\t\t// Encodes the specified string by replacing all \\\" \\' ; : with _<num>\n\t\t\tfunction encode(str) {\n\t\t\t\tisEncoded = true;\n\n\t\t\t\treturn encodingLookup[str];\n\t\t\t};\n\n\t\t\t// Decodes the specified string by replacing all _<num> with it's original value \\\" \\' etc\n\t\t\t// It will also decode the \\\" \\' if keep_slashes is set to fale or omitted\n\t\t\tfunction decode(str, keep_slashes) {\n\t\t\t\tif (isEncoded) {\n\t\t\t\t\tstr = str.replace(/\\uFEFF[0-9]/g, function(str) {\n\t\t\t\t\t\treturn encodingLookup[str];\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif (!keep_slashes)\n\t\t\t\t\tstr = str.replace(/\\\\([\\'\\\";:])/g, \"$1\");\n\n\t\t\t\treturn str;\n\t\t\t}\n\n\t\t\tif (css) {\n\t\t\t\t// Encode \\\" \\' % and ; and : inside strings so they don't interfere with the style parsing\n\t\t\t\tcss = css.replace(/\\\\[\\\"\\';:\\uFEFF]/g, encode).replace(/\\\"[^\\\"]+\\\"|\\'[^\\']+\\'/g, function(str) {\n\t\t\t\t\treturn str.replace(/[;:]/g, encode);\n\t\t\t\t});\n\n\t\t\t\t// Parse styles\n\t\t\t\twhile (matches = styleRegExp.exec(css)) {\n\t\t\t\t\tname = matches[1].replace(trimRightRegExp, '').toLowerCase();\n\t\t\t\t\tvalue = matches[2].replace(trimRightRegExp, '');\n\n\t\t\t\t\tif (name && value.length > 0) {\n\t\t\t\t\t\t// Opera will produce 700 instead of bold in their style values\n\t\t\t\t\t\tif (name === 'font-weight' && value === '700')\n\t\t\t\t\t\t\tvalue = 'bold';\n\t\t\t\t\t\telse if (name === 'color' || name === 'background-color') // Lowercase colors like RED\n\t\t\t\t\t\t\tvalue = value.toLowerCase();\n\n\t\t\t\t\t\t// Convert RGB colors to HEX\n\t\t\t\t\t\tvalue = value.replace(rgbRegExp, toHex);\n\n\t\t\t\t\t\t// Convert URLs and force them into url('value') format\n\t\t\t\t\t\tvalue = value.replace(urlOrStrRegExp, function(match, url, url2, url3, str, str2) {\n\t\t\t\t\t\t\tstr = str || str2;\n\n\t\t\t\t\t\t\tif (str) {\n\t\t\t\t\t\t\t\tstr = decode(str);\n\n\t\t\t\t\t\t\t\t// Force strings into single quote format\n\t\t\t\t\t\t\t\treturn \"'\" + str.replace(/\\'/g, \"\\\\'\") + \"'\";\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\turl = decode(url || url2 || url3);\n\n\t\t\t\t\t\t\t// Convert the URL to relative/absolute depending on config\n\t\t\t\t\t\t\tif (urlConverter)\n\t\t\t\t\t\t\t\turl = urlConverter.call(urlConverterScope, url, 'style');\n\n\t\t\t\t\t\t\t// Output new URL format\n\t\t\t\t\t\t\treturn \"url('\" + url.replace(/\\'/g, \"\\\\'\") + \"')\";\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tstyles[name] = isEncoded ? decode(value, true) : value;\n\t\t\t\t\t}\n\n\t\t\t\t\tstyleRegExp.lastIndex = matches.index + matches[0].length;\n\t\t\t\t}\n\n\t\t\t\t// Compress the styles to reduce it's size for example IE will expand styles\n\t\t\t\tcompress(\"border\", \"\");\n\t\t\t\tcompress(\"border\", \"-width\");\n\t\t\t\tcompress(\"border\", \"-color\");\n\t\t\t\tcompress(\"border\", \"-style\");\n\t\t\t\tcompress(\"padding\", \"\");\n\t\t\t\tcompress(\"margin\", \"\");\n\t\t\t\tcompress2('border', 'border-width', 'border-style', 'border-color');\n\n\t\t\t\t// Remove pointless border, IE produces these\n\t\t\t\tif (styles.border === 'medium none')\n\t\t\t\t\tdelete styles.border;\n\t\t\t}\n\n\t\t\treturn styles;\n\t\t},\n\n\t\tserialize : function(styles, element_name) {\n\t\t\tvar css = '', name, value;\n\n\t\t\tfunction serializeStyles(name) {\n\t\t\t\tvar styleList, i, l, value;\n\n\t\t\t\tstyleList = schema.styles[name];\n\t\t\t\tif (styleList) {\n\t\t\t\t\tfor (i = 0, l = styleList.length; i < l; i++) {\n\t\t\t\t\t\tname = styleList[i];\n\t\t\t\t\t\tvalue = styles[name];\n\n\t\t\t\t\t\tif (value !== undef && value.length > 0)\n\t\t\t\t\t\t\tcss += (css.length > 0 ? ' ' : '') + name + ': ' + value + ';';\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Serialize styles according to schema\n\t\t\tif (element_name && schema && schema.styles) {\n\t\t\t\t// Serialize global styles and element specific styles\n\t\t\t\tserializeStyles('*');\n\t\t\t\tserializeStyles(element_name);\n\t\t\t} else {\n\t\t\t\t// Output the styles in the order they are inside the object\n\t\t\t\tfor (name in styles) {\n\t\t\t\t\tvalue = styles[name];\n\n\t\t\t\t\tif (value !== undef && value.length > 0)\n\t\t\t\t\t\tcss += (css.length > 0 ? ' ' : '') + name + ': ' + value + ';';\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn css;\n\t\t}\n\t};\n};\n\n(function(tinymce) {\n\tvar transitional = {}, boolAttrMap, blockElementsMap, shortEndedElementsMap, nonEmptyElementsMap, customElementsMap = {},\n\t\tdefaultWhiteSpaceElementsMap, selfClosingElementsMap, makeMap = tinymce.makeMap, each = tinymce.each;\n\n\tfunction split(str, delim) {\n\t\treturn str.split(delim || ',');\n\t};\n\n\tfunction unpack(lookup, data) {\n\t\tvar key, elements = {};\n\n\t\tfunction replace(value) {\n\t\t\treturn value.replace(/[A-Z]+/g, function(key) {\n\t\t\t\treturn replace(lookup[key]);\n\t\t\t});\n\t\t};\n\n\t\t// Unpack lookup\n\t\tfor (key in lookup) {\n\t\t\tif (lookup.hasOwnProperty(key))\n\t\t\t\tlookup[key] = replace(lookup[key]);\n\t\t}\n\n\t\t// Unpack and parse data into object map\n\t\treplace(data).replace(/#/g, '#text').replace(/(\\w+)\\[([^\\]]+)\\]\\[([^\\]]*)\\]/g, function(str, name, attributes, children) {\n\t\t\tattributes = split(attributes, '|');\n\n\t\t\telements[name] = {\n\t\t\t\tattributes : makeMap(attributes),\n\t\t\t\tattributesOrder : attributes,\n\t\t\t\tchildren : makeMap(children, '|', {'#comment' : {}})\n\t\t\t}\n\t\t});\n\n\t\treturn elements;\n\t};\n\n\t// Build a lookup table for block elements both lowercase and uppercase\n\tblockElementsMap = 'h1,h2,h3,h4,h5,h6,hr,p,div,address,pre,form,table,tbody,thead,tfoot,' +\n\t\t\t\t\t\t'th,tr,td,li,ol,ul,caption,blockquote,center,dl,dt,dd,dir,fieldset,' +\n\t\t\t\t\t\t'noscript,menu,isindex,samp,header,footer,article,section,hgroup';\n\tblockElementsMap = makeMap(blockElementsMap, ',', makeMap(blockElementsMap.toUpperCase()));\n\n\t// This is the XHTML 1.0 transitional elements with it's attributes and children packed to reduce it's size\n\ttransitional = unpack({\n\t\tZ : 'H|K|N|O|P',\n\t\tY : 'X|form|R|Q',\n\t\tZG : 'E|span|width|align|char|charoff|valign',\n\t\tX : 'p|T|div|U|W|isindex|fieldset|table',\n\t\tZF : 'E|align|char|charoff|valign',\n\t\tW : 'pre|hr|blockquote|address|center|noframes',\n\t\tZE : 'abbr|axis|headers|scope|rowspan|colspan|align|char|charoff|valign|nowrap|bgcolor|width|height',\n\t\tZD : '[E][S]',\n\t\tU : 'ul|ol|dl|menu|dir',\n\t\tZC : 'p|Y|div|U|W|table|br|span|bdo|object|applet|img|map|K|N|Q',\n\t\tT : 'h1|h2|h3|h4|h5|h6',\n\t\tZB : 'X|S|Q',\n\t\tS : 'R|P',\n\t\tZA : 'a|G|J|M|O|P',\n\t\tR : 'a|H|K|N|O',\n\t\tQ : 'noscript|P',\n\t\tP : 'ins|del|script',\n\t\tO : 'input|select|textarea|label|button',\n\t\tN : 'M|L',\n\t\tM : 'em|strong|dfn|code|q|samp|kbd|var|cite|abbr|acronym',\n\t\tL : 'sub|sup',\n\t\tK : 'J|I',\n\t\tJ : 'tt|i|b|u|s|strike',\n\t\tI : 'big|small|font|basefont',\n\t\tH : 'G|F',\n\t\tG : 'br|span|bdo',\n\t\tF : 'object|applet|img|map|iframe',\n\t\tE : 'A|B|C',\n\t\tD : 'accesskey|tabindex|onfocus|onblur',\n\t\tC : 'onclick|ondblclick|onmousedown|onmouseup|onmouseover|onmousemove|onmouseout|onkeypress|onkeydown|onkeyup',\n\t\tB : 'lang|xml:lang|dir',\n\t\tA : 'id|class|style|title'\n\t}, 'script[id|charset|type|language|src|defer|xml:space][]' +\n\t\t'style[B|id|type|media|title|xml:space][]' +\n\t\t'object[E|declare|classid|codebase|data|type|codetype|archive|standby|width|height|usemap|name|tabindex|align|border|hspace|vspace][#|param|Y]' +\n\t\t'param[id|name|value|valuetype|type][]' +\n\t\t'p[E|align][#|S]' +\n\t\t'a[E|D|charset|type|name|href|hreflang|rel|rev|shape|coords|target][#|Z]' +\n\t\t'br[A|clear][]' +\n\t\t'span[E][#|S]' +\n\t\t'bdo[A|C|B][#|S]' +\n\t\t'applet[A|codebase|archive|code|object|alt|name|width|height|align|hspace|vspace][#|param|Y]' +\n\t\t'h1[E|align][#|S]' +\n\t\t'img[E|src|alt|name|longdesc|width|height|usemap|ismap|align|border|hspace|vspace][]' +\n\t\t'map[B|C|A|name][X|form|Q|area]' +\n\t\t'h2[E|align][#|S]' +\n\t\t'iframe[A|longdesc|name|src|frameborder|marginwidth|marginheight|scrolling|align|width|height][#|Y]' +\n\t\t'h3[E|align][#|S]' +\n\t\t'tt[E][#|S]' +\n\t\t'i[E][#|S]' +\n\t\t'b[E][#|S]' +\n\t\t'u[E][#|S]' +\n\t\t's[E][#|S]' +\n\t\t'strike[E][#|S]' +\n\t\t'big[E][#|S]' +\n\t\t'small[E][#|S]' +\n\t\t'font[A|B|size|color|face][#|S]' +\n\t\t'basefont[id|size|color|face][]' +\n\t\t'em[E][#|S]' +\n\t\t'strong[E][#|S]' +\n\t\t'dfn[E][#|S]' +\n\t\t'code[E][#|S]' +\n\t\t'q[E|cite][#|S]' +\n\t\t'samp[E][#|S]' +\n\t\t'kbd[E][#|S]' +\n\t\t'var[E][#|S]' +\n\t\t'cite[E][#|S]' +\n\t\t'abbr[E][#|S]' +\n\t\t'acronym[E][#|S]' +\n\t\t'sub[E][#|S]' +\n\t\t'sup[E][#|S]' +\n\t\t'input[E|D|type|name|value|checked|disabled|readonly|size|maxlength|src|alt|usemap|onselect|onchange|accept|align][]' +\n\t\t'select[E|name|size|multiple|disabled|tabindex|onfocus|onblur|onchange][optgroup|option]' +\n\t\t'optgroup[E|disabled|label][option]' +\n\t\t'option[E|selected|disabled|label|value][]' +\n\t\t'textarea[E|D|name|rows|cols|disabled|readonly|onselect|onchange][]' +\n\t\t'label[E|for|accesskey|onfocus|onblur][#|S]' +\n\t\t'button[E|D|name|value|type|disabled][#|p|T|div|U|W|table|G|object|applet|img|map|K|N|Q]' +\n\t\t'h4[E|align][#|S]' +\n\t\t'ins[E|cite|datetime][#|Y]' +\n\t\t'h5[E|align][#|S]' +\n\t\t'del[E|cite|datetime][#|Y]' +\n\t\t'h6[E|align][#|S]' +\n\t\t'div[E|align][#|Y]' +\n\t\t'ul[E|type|compact][li]' +\n\t\t'li[E|type|value][#|Y]' +\n\t\t'ol[E|type|compact|start][li]' +\n\t\t'dl[E|compact][dt|dd]' +\n\t\t'dt[E][#|S]' +\n\t\t'dd[E][#|Y]' +\n\t\t'menu[E|compact][li]' +\n\t\t'dir[E|compact][li]' +\n\t\t'pre[E|width|xml:space][#|ZA]' +\n\t\t'hr[E|align|noshade|size|width][]' +\n\t\t'blockquote[E|cite][#|Y]' +\n\t\t'address[E][#|S|p]' +\n\t\t'center[E][#|Y]' +\n\t\t'noframes[E][#|Y]' +\n\t\t'isindex[A|B|prompt][]' +\n\t\t'fieldset[E][#|legend|Y]' +\n\t\t'legend[E|accesskey|align][#|S]' +\n\t\t'table[E|summary|width|border|frame|rules|cellspacing|cellpadding|align|bgcolor][caption|col|colgroup|thead|tfoot|tbody|tr]' +\n\t\t'caption[E|align][#|S]' +\n\t\t'col[ZG][]' +\n\t\t'colgroup[ZG][col]' +\n\t\t'thead[ZF][tr]' +\n\t\t'tr[ZF|bgcolor][th|td]' +\n\t\t'th[E|ZE][#|Y]' +\n\t\t'form[E|action|method|name|enctype|onsubmit|onreset|accept|accept-charset|target][#|X|R|Q]' +\n\t\t'noscript[E][#|Y]' +\n\t\t'td[E|ZE][#|Y]' +\n\t\t'tfoot[ZF][tr]' +\n\t\t'tbody[ZF][tr]' +\n\t\t'area[E|D|shape|coords|href|nohref|alt|target][]' +\n\t\t'base[id|href|target][]' +\n\t\t'body[E|onload|onunload|background|bgcolor|text|link|vlink|alink][#|Y]'\n\t);\n\n\tboolAttrMap = makeMap('checked,compact,declare,defer,disabled,ismap,multiple,nohref,noresize,noshade,nowrap,readonly,selected,autoplay,loop,controls');\n\tshortEndedElementsMap = makeMap('area,base,basefont,br,col,frame,hr,img,input,isindex,link,meta,param,embed,source');\n\tnonEmptyElementsMap = tinymce.extend(makeMap('td,th,iframe,video,audio,object'), shortEndedElementsMap);\n\tdefaultWhiteSpaceElementsMap = makeMap('pre,script,style,textarea');\n\tselfClosingElementsMap = makeMap('colgroup,dd,dt,li,options,p,td,tfoot,th,thead,tr');\n\n\ttinymce.html.Schema = function(settings) {\n\t\tvar self = this, elements = {}, children = {}, patternElements = [], validStyles, whiteSpaceElementsMap;\n\n\t\tsettings = settings || {};\n\n\t\t// Allow all elements and attributes if verify_html is set to false\n\t\tif (settings.verify_html === false)\n\t\t\tsettings.valid_elements = '*[*]';\n\n\t\t// Build styles list\n\t\tif (settings.valid_styles) {\n\t\t\tvalidStyles = {};\n\n\t\t\t// Convert styles into a rule list\n\t\t\teach(settings.valid_styles, function(value, key) {\n\t\t\t\tvalidStyles[key] = tinymce.explode(value);\n\t\t\t});\n\t\t}\n\n\t\twhiteSpaceElementsMap = settings.whitespace_elements ? makeMap(settings.whitespace_elements) : defaultWhiteSpaceElementsMap;\n\n\t\t// Converts a wildcard expression string to a regexp for example *a will become /.*a/.\n\t\tfunction patternToRegExp(str) {\n\t\t\treturn new RegExp('^' + str.replace(/([?+*])/g, '.$1') + '$');\n\t\t};\n\n\t\t// Parses the specified valid_elements string and adds to the current rules\n\t\t// This function is a bit hard to read since it's heavily optimized for speed\n\t\tfunction addValidElements(valid_elements) {\n\t\t\tvar ei, el, ai, al, yl, matches, element, attr, attrData, elementName, attrName, attrType, attributes, attributesOrder,\n\t\t\t\tprefix, outputName, globalAttributes, globalAttributesOrder, transElement, key, childKey, value,\n\t\t\t\telementRuleRegExp = /^([#+-])?([^\\[\\/]+)(?:\\/([^\\[]+))?(?:\\[([^\\]]+)\\])?$/,\n\t\t\t\tattrRuleRegExp = /^([!\\-])?(\\w+::\\w+|[^=:<]+)?(?:([=:<])(.*))?$/,\n\t\t\t\thasPatternsRegExp = /[*?+]/;\n\n\t\t\tif (valid_elements) {\n\t\t\t\t// Split valid elements into an array with rules\n\t\t\t\tvalid_elements = split(valid_elements);\n\n\t\t\t\tif (elements['@']) {\n\t\t\t\t\tglobalAttributes = elements['@'].attributes;\n\t\t\t\t\tglobalAttributesOrder = elements['@'].attributesOrder;\n\t\t\t\t}\n\n\t\t\t\t// Loop all rules\n\t\t\t\tfor (ei = 0, el = valid_elements.length; ei < el; ei++) {\n\t\t\t\t\t// Parse element rule\n\t\t\t\t\tmatches = elementRuleRegExp.exec(valid_elements[ei]);\n\t\t\t\t\tif (matches) {\n\t\t\t\t\t\t// Setup local names for matches\n\t\t\t\t\t\tprefix = matches[1];\n\t\t\t\t\t\telementName = matches[2];\n\t\t\t\t\t\toutputName = matches[3];\n\t\t\t\t\t\tattrData = matches[4];\n\n\t\t\t\t\t\t// Create new attributes and attributesOrder\n\t\t\t\t\t\tattributes = {};\n\t\t\t\t\t\tattributesOrder = [];\n\n\t\t\t\t\t\t// Create the new element\n\t\t\t\t\t\telement = {\n\t\t\t\t\t\t\tattributes : attributes,\n\t\t\t\t\t\t\tattributesOrder : attributesOrder\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\t// Padd empty elements prefix\n\t\t\t\t\t\tif (prefix === '#')\n\t\t\t\t\t\t\telement.paddEmpty = true;\n\n\t\t\t\t\t\t// Remove empty elements prefix\n\t\t\t\t\t\tif (prefix === '-')\n\t\t\t\t\t\t\telement.removeEmpty = true;\n\n\t\t\t\t\t\t// Copy attributes from global rule into current rule\n\t\t\t\t\t\tif (globalAttributes) {\n\t\t\t\t\t\t\tfor (key in globalAttributes)\n\t\t\t\t\t\t\t\tattributes[key] = globalAttributes[key];\n\n\t\t\t\t\t\t\tattributesOrder.push.apply(attributesOrder, globalAttributesOrder);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Attributes defined\n\t\t\t\t\t\tif (attrData) {\n\t\t\t\t\t\t\tattrData = split(attrData, '|');\n\t\t\t\t\t\t\tfor (ai = 0, al = attrData.length; ai < al; ai++) {\n\t\t\t\t\t\t\t\tmatches = attrRuleRegExp.exec(attrData[ai]);\n\t\t\t\t\t\t\t\tif (matches) {\n\t\t\t\t\t\t\t\t\tattr = {};\n\t\t\t\t\t\t\t\t\tattrType = matches[1];\n\t\t\t\t\t\t\t\t\tattrName = matches[2].replace(/::/g, ':');\n\t\t\t\t\t\t\t\t\tprefix = matches[3];\n\t\t\t\t\t\t\t\t\tvalue = matches[4];\n\n\t\t\t\t\t\t\t\t\t// Required\n\t\t\t\t\t\t\t\t\tif (attrType === '!') {\n\t\t\t\t\t\t\t\t\t\telement.attributesRequired = element.attributesRequired || [];\n\t\t\t\t\t\t\t\t\t\telement.attributesRequired.push(attrName);\n\t\t\t\t\t\t\t\t\t\tattr.required = true;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Denied from global\n\t\t\t\t\t\t\t\t\tif (attrType === '-') {\n\t\t\t\t\t\t\t\t\t\tdelete attributes[attrName];\n\t\t\t\t\t\t\t\t\t\tattributesOrder.splice(tinymce.inArray(attributesOrder, attrName), 1);\n\t\t\t\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Default value\n\t\t\t\t\t\t\t\t\tif (prefix) {\n\t\t\t\t\t\t\t\t\t\t// Default value\n\t\t\t\t\t\t\t\t\t\tif (prefix === '=') {\n\t\t\t\t\t\t\t\t\t\t\telement.attributesDefault = element.attributesDefault || [];\n\t\t\t\t\t\t\t\t\t\t\telement.attributesDefault.push({name: attrName, value: value});\n\t\t\t\t\t\t\t\t\t\t\tattr.defaultValue = value;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// Forced value\n\t\t\t\t\t\t\t\t\t\tif (prefix === ':') {\n\t\t\t\t\t\t\t\t\t\t\telement.attributesForced = element.attributesForced || [];\n\t\t\t\t\t\t\t\t\t\t\telement.attributesForced.push({name: attrName, value: value});\n\t\t\t\t\t\t\t\t\t\t\tattr.forcedValue = value;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// Required values\n\t\t\t\t\t\t\t\t\t\tif (prefix === '<')\n\t\t\t\t\t\t\t\t\t\t\tattr.validValues = makeMap(value, '?');\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Check for attribute patterns\n\t\t\t\t\t\t\t\t\tif (hasPatternsRegExp.test(attrName)) {\n\t\t\t\t\t\t\t\t\t\telement.attributePatterns = element.attributePatterns || [];\n\t\t\t\t\t\t\t\t\t\tattr.pattern = patternToRegExp(attrName);\n\t\t\t\t\t\t\t\t\t\telement.attributePatterns.push(attr);\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\t// Add attribute to order list if it doesn't already exist\n\t\t\t\t\t\t\t\t\t\tif (!attributes[attrName])\n\t\t\t\t\t\t\t\t\t\t\tattributesOrder.push(attrName);\n\n\t\t\t\t\t\t\t\t\t\tattributes[attrName] = attr;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Global rule, store away these for later usage\n\t\t\t\t\t\tif (!globalAttributes && elementName == '@') {\n\t\t\t\t\t\t\tglobalAttributes = attributes;\n\t\t\t\t\t\t\tglobalAttributesOrder = attributesOrder;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Handle substitute elements such as b/strong\n\t\t\t\t\t\tif (outputName) {\n\t\t\t\t\t\t\telement.outputName = elementName;\n\t\t\t\t\t\t\telements[outputName] = element;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Add pattern or exact element\n\t\t\t\t\t\tif (hasPatternsRegExp.test(elementName)) {\n\t\t\t\t\t\t\telement.pattern = patternToRegExp(elementName);\n\t\t\t\t\t\t\tpatternElements.push(element);\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\telements[elementName] = element;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction setValidElements(valid_elements) {\n\t\t\telements = {};\n\t\t\tpatternElements = [];\n\n\t\t\taddValidElements(valid_elements);\n\n\t\t\teach(transitional, function(element, name) {\n\t\t\t\tchildren[name] = element.children;\n\t\t\t});\n\t\t};\n\n\t\t// Adds custom non HTML elements to the schema\n\t\tfunction addCustomElements(custom_elements) {\n\t\t\tvar customElementRegExp = /^(~)?(.+)$/;\n\n\t\t\tif (custom_elements) {\n\t\t\t\teach(split(custom_elements), function(rule) {\n\t\t\t\t\tvar matches = customElementRegExp.exec(rule),\n\t\t\t\t\t\tinline = matches[1] === '~',\n\t\t\t\t\t\tcloneName = inline ? 'span' : 'div',\n\t\t\t\t\t\tname = matches[2];\n\n\t\t\t\t\tchildren[name] = children[cloneName];\n\t\t\t\t\tcustomElementsMap[name] = cloneName;\n\n\t\t\t\t\t// If it's not marked as inline then add it to valid block elements\n\t\t\t\t\tif (!inline)\n\t\t\t\t\t\tblockElementsMap[name] = {};\n\n\t\t\t\t\t// Add custom elements at span/div positions\n\t\t\t\t\teach(children, function(element, child) {\n\t\t\t\t\t\tif (element[cloneName])\n\t\t\t\t\t\t\telement[name] = element[cloneName];\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\t// Adds valid children to the schema object\n\t\tfunction addValidChildren(valid_children) {\n\t\t\tvar childRuleRegExp = /^([+\\-]?)(\\w+)\\[([^\\]]+)\\]$/;\n\n\t\t\tif (valid_children) {\n\t\t\t\teach(split(valid_children), function(rule) {\n\t\t\t\t\tvar matches = childRuleRegExp.exec(rule), parent, prefix;\n\n\t\t\t\t\tif (matches) {\n\t\t\t\t\t\tprefix = matches[1];\n\n\t\t\t\t\t\t// Add/remove items from default\n\t\t\t\t\t\tif (prefix)\n\t\t\t\t\t\t\tparent = children[matches[2]];\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tparent = children[matches[2]] = {'#comment' : {}};\n\n\t\t\t\t\t\tparent = children[matches[2]];\n\n\t\t\t\t\t\teach(split(matches[3], '|'), function(child) {\n\t\t\t\t\t\t\tif (prefix === '-')\n\t\t\t\t\t\t\t\tdelete parent[child];\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tparent[child] = {};\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\tfunction getElementRule(name) {\n\t\t\tvar element = elements[name], i;\n\n\t\t\t// Exact match found\n\t\t\tif (element)\n\t\t\t\treturn element;\n\n\t\t\t// No exact match then try the patterns\n\t\t\ti = patternElements.length;\n\t\t\twhile (i--) {\n\t\t\t\telement = patternElements[i];\n\n\t\t\t\tif (element.pattern.test(name))\n\t\t\t\t\treturn element;\n\t\t\t}\n\t\t};\n\n\t\tif (!settings.valid_elements) {\n\t\t\t// No valid elements defined then clone the elements from the transitional spec\n\t\t\teach(transitional, function(element, name) {\n\t\t\t\telements[name] = {\n\t\t\t\t\tattributes : element.attributes,\n\t\t\t\t\tattributesOrder : element.attributesOrder\n\t\t\t\t};\n\n\t\t\t\tchildren[name] = element.children;\n\t\t\t});\n\n\t\t\t// Switch these\n\t\t\teach(split('strong/b,em/i'), function(item) {\n\t\t\t\titem = split(item, '/');\n\t\t\t\telements[item[1]].outputName = item[0];\n\t\t\t});\n\n\t\t\t// Add default alt attribute for images\n\t\t\telements.img.attributesDefault = [{name: 'alt', value: ''}];\n\n\t\t\t// Remove these if they are empty by default\n\t\t\teach(split('ol,ul,sub,sup,blockquote,span,font,a,table,tbody,tr'), function(name) {\n\t\t\t\telements[name].removeEmpty = true;\n\t\t\t});\n\n\t\t\t// Padd these by default\n\t\t\teach(split('p,h1,h2,h3,h4,h5,h6,th,td,pre,div,address,caption'), function(name) {\n\t\t\t\telements[name].paddEmpty = true;\n\t\t\t});\n\t\t} else\n\t\t\tsetValidElements(settings.valid_elements);\n\n\t\taddCustomElements(settings.custom_elements);\n\t\taddValidChildren(settings.valid_children);\n\t\taddValidElements(settings.extended_valid_elements);\n\n\t\t// Todo: Remove this when we fix list handling to be valid\n\t\taddValidChildren('+ol[ul|ol],+ul[ul|ol]');\n\n\t\t// If the user didn't allow span only allow internal spans\n\t\tif (!getElementRule('span'))\n\t\t\taddValidElements('span[!data-mce-type|*]');\n\n\t\t// Delete invalid elements\n\t\tif (settings.invalid_elements) {\n\t\t\ttinymce.each(tinymce.explode(settings.invalid_elements), function(item) {\n\t\t\t\tif (elements[item])\n\t\t\t\t\tdelete elements[item];\n\t\t\t});\n\t\t}\n\n\t\tself.children = children;\n\n\t\tself.styles = validStyles;\n\n\t\tself.getBoolAttrs = function() {\n\t\t\treturn boolAttrMap;\n\t\t};\n\n\t\tself.getBlockElements = function() {\n\t\t\treturn blockElementsMap;\n\t\t};\n\n\t\tself.getShortEndedElements = function() {\n\t\t\treturn shortEndedElementsMap;\n\t\t};\n\n\t\tself.getSelfClosingElements = function() {\n\t\t\treturn selfClosingElementsMap;\n\t\t};\n\n\t\tself.getNonEmptyElements = function() {\n\t\t\treturn nonEmptyElementsMap;\n\t\t};\n\n\t\tself.getWhiteSpaceElements = function() {\n\t\t\treturn whiteSpaceElementsMap;\n\t\t};\n\n\t\tself.isValidChild = function(name, child) {\n\t\t\tvar parent = children[name];\n\n\t\t\treturn !!(parent && parent[child]);\n\t\t};\n\n\t\tself.getElementRule = getElementRule;\n\n\t\tself.getCustomElements = function() {\n\t\t\treturn customElementsMap;\n\t\t};\n\n\t\tself.addValidElements = addValidElements;\n\n\t\tself.setValidElements = setValidElements;\n\n\t\tself.addCustomElements = addCustomElements;\n\n\t\tself.addValidChildren = addValidChildren;\n\t};\n\n\t// Expose boolMap and blockElementMap as static properties for usage in DOMUtils\n\ttinymce.html.Schema.boolAttrMap = boolAttrMap;\n\ttinymce.html.Schema.blockElementsMap = blockElementsMap;\n})(tinymce);\n\n(function(tinymce) {\n\ttinymce.html.SaxParser = function(settings, schema) {\n\t\tvar self = this, noop = function() {};\n\n\t\tsettings = settings || {};\n\t\tself.schema = schema = schema || new tinymce.html.Schema();\n\n\t\tif (settings.fix_self_closing !== false)\n\t\t\tsettings.fix_self_closing = true;\n\n\t\t// Add handler functions from settings and setup default handlers\n\t\ttinymce.each('comment cdata text start end pi doctype'.split(' '), function(name) {\n\t\t\tif (name)\n\t\t\t\tself[name] = settings[name] || noop;\n\t\t});\n\n\t\tself.parse = function(html) {\n\t\t\tvar self = this, matches, index = 0, value, endRegExp, stack = [], attrList, i, text, name, isInternalElement, removeInternalElements,\n\t\t\t\tshortEndedElements, fillAttrsMap, isShortEnded, validate, elementRule, isValidElement, attr, attribsValue, invalidPrefixRegExp,\n\t\t\t\tvalidAttributesMap, validAttributePatterns, attributesRequired, attributesDefault, attributesForced, selfClosing,\n\t\t\t\ttokenRegExp, attrRegExp, specialElements, attrValue, idCount = 0, decode = tinymce.html.Entities.decode, fixSelfClosing, isIE;\n\n\t\t\tfunction processEndTag(name) {\n\t\t\t\tvar pos, i;\n\n\t\t\t\t// Find position of parent of the same type\n\t\t\t\tpos = stack.length;\n\t\t\t\twhile (pos--) {\n\t\t\t\t\tif (stack[pos].name === name)\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\t// Found parent\n\t\t\t\tif (pos >= 0) {\n\t\t\t\t\t// Close all the open elements\n\t\t\t\t\tfor (i = stack.length - 1; i >= pos; i--) {\n\t\t\t\t\t\tname = stack[i];\n\n\t\t\t\t\t\tif (name.valid)\n\t\t\t\t\t\t\tself.end(name.name);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove the open elements from the stack\n\t\t\t\t\tstack.length = pos;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Precompile RegExps and map objects\n\t\t\ttokenRegExp = new RegExp('<(?:' +\n\t\t\t\t'(?:!--([\\\\w\\\\W]*?)-->)|' + // Comment\n\t\t\t\t'(?:!\\\\[CDATA\\\\[([\\\\w\\\\W]*?)\\\\]\\\\]>)|' + // CDATA\n\t\t\t\t'(?:!DOCTYPE([\\\\w\\\\W]*?)>)|' + // DOCTYPE\n\t\t\t\t'(?:\\\\?([^\\\\s\\\\/<>]+) ?([\\\\w\\\\W]*?)[?/]>)|' + // PI\n\t\t\t\t'(?:\\\\/([^>]+)>)|' + // End element\n\t\t\t\t'(?:([^\\\\s\\\\/<>]+)((?:\\\\s+[^\"\\'>]+(?:(?:\"[^\"]*\")|(?:\\'[^\\']*\\')|[^>]*))*|\\\\/)>)' + // Start element\n\t\t\t')', 'g');\n\n\t\t\tattrRegExp = /([\\w:\\-]+)(?:\\s*=\\s*(?:(?:\\\"((?:\\\\.|[^\\\"])*)\\\")|(?:\\'((?:\\\\.|[^\\'])*)\\')|([^>\\s]+)))?/g;\n\t\t\tspecialElements = {\n\t\t\t\t'script' : /<\\/script[^>]*>/gi,\n\t\t\t\t'style' : /<\\/style[^>]*>/gi,\n\t\t\t\t'noscript' : /<\\/noscript[^>]*>/gi\n\t\t\t};\n\n\t\t\t// Setup lookup tables for empty elements and boolean attributes\n\t\t\tshortEndedElements = schema.getShortEndedElements();\n\t\t\tselfClosing = schema.getSelfClosingElements();\n\t\t\tfillAttrsMap = schema.getBoolAttrs();\n\t\t\tvalidate = settings.validate;\n\t\t\tremoveInternalElements = settings.remove_internals;\n\t\t\tfixSelfClosing = settings.fix_self_closing;\n\t\t\tisIE = tinymce.isIE;\n\t\t\tinvalidPrefixRegExp = /^:/;\n\n\t\t\twhile (matches = tokenRegExp.exec(html)) {\n\t\t\t\t// Text\n\t\t\t\tif (index < matches.index)\n\t\t\t\t\tself.text(decode(html.substr(index, matches.index - index)));\n\n\t\t\t\tif (value = matches[6]) { // End element\n\t\t\t\t\tvalue = value.toLowerCase();\n\n\t\t\t\t\t// IE will add a \":\" in front of elements it doesn't understand like custom elements or HTML5 elements\n\t\t\t\t\tif (isIE && invalidPrefixRegExp.test(value))\n\t\t\t\t\t\tvalue = value.substr(1);\n\n\t\t\t\t\tprocessEndTag(value);\n\t\t\t\t} else if (value = matches[7]) { // Start element\n\t\t\t\t\tvalue = value.toLowerCase();\n\n\t\t\t\t\t// IE will add a \":\" in front of elements it doesn't understand like custom elements or HTML5 elements\n\t\t\t\t\tif (isIE && invalidPrefixRegExp.test(value))\n\t\t\t\t\t\tvalue = value.substr(1);\n\n\t\t\t\t\tisShortEnded = value in shortEndedElements;\n\n\t\t\t\t\t// Is self closing tag for example an <li> after an open <li>\n\t\t\t\t\tif (fixSelfClosing && selfClosing[value] && stack.length > 0 && stack[stack.length - 1].name === value)\n\t\t\t\t\t\tprocessEndTag(value);\n\n\t\t\t\t\t// Validate element\n\t\t\t\t\tif (!validate || (elementRule = schema.getElementRule(value))) {\n\t\t\t\t\t\tisValidElement = true;\n\n\t\t\t\t\t\t// Grab attributes map and patters when validation is enabled\n\t\t\t\t\t\tif (validate) {\n\t\t\t\t\t\t\tvalidAttributesMap = elementRule.attributes;\n\t\t\t\t\t\t\tvalidAttributePatterns = elementRule.attributePatterns;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Parse attributes\n\t\t\t\t\t\tif (attribsValue = matches[8]) {\n\t\t\t\t\t\t\tisInternalElement = attribsValue.indexOf('data-mce-type') !== -1; // Check if the element is an internal element\n\n\t\t\t\t\t\t\t// If the element has internal attributes then remove it if we are told to do so\n\t\t\t\t\t\t\tif (isInternalElement && removeInternalElements)\n\t\t\t\t\t\t\t\tisValidElement = false;\n\n\t\t\t\t\t\t\tattrList = [];\n\t\t\t\t\t\t\tattrList.map = {};\n\n\t\t\t\t\t\t\tattribsValue.replace(attrRegExp, function(match, name, value, val2, val3) {\n\t\t\t\t\t\t\t\tvar attrRule, i;\n\n\t\t\t\t\t\t\t\tname = name.toLowerCase();\n\t\t\t\t\t\t\t\tvalue = name in fillAttrsMap ? name : decode(value || val2 || val3 || ''); // Handle boolean attribute than value attribute\n\n\t\t\t\t\t\t\t\t// Validate name and value\n\t\t\t\t\t\t\t\tif (validate && !isInternalElement && name.indexOf('data-') !== 0) {\n\t\t\t\t\t\t\t\t\tattrRule = validAttributesMap[name];\n\n\t\t\t\t\t\t\t\t\t// Find rule by pattern matching\n\t\t\t\t\t\t\t\t\tif (!attrRule && validAttributePatterns) {\n\t\t\t\t\t\t\t\t\t\ti = validAttributePatterns.length;\n\t\t\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\t\t\tattrRule = validAttributePatterns[i];\n\t\t\t\t\t\t\t\t\t\t\tif (attrRule.pattern.test(name))\n\t\t\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// No rule matched\n\t\t\t\t\t\t\t\t\t\tif (i === -1)\n\t\t\t\t\t\t\t\t\t\t\tattrRule = null;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// No attribute rule found\n\t\t\t\t\t\t\t\t\tif (!attrRule)\n\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t// Validate value\n\t\t\t\t\t\t\t\t\tif (attrRule.validValues && !(value in attrRule.validValues))\n\t\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Add attribute to list and map\n\t\t\t\t\t\t\t\tattrList.map[name] = value;\n\t\t\t\t\t\t\t\tattrList.push({\n\t\t\t\t\t\t\t\t\tname: name,\n\t\t\t\t\t\t\t\t\tvalue: value\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tattrList = [];\n\t\t\t\t\t\t\tattrList.map = {};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Process attributes if validation is enabled\n\t\t\t\t\t\tif (validate && !isInternalElement) {\n\t\t\t\t\t\t\tattributesRequired = elementRule.attributesRequired;\n\t\t\t\t\t\t\tattributesDefault = elementRule.attributesDefault;\n\t\t\t\t\t\t\tattributesForced = elementRule.attributesForced;\n\n\t\t\t\t\t\t\t// Handle forced attributes\n\t\t\t\t\t\t\tif (attributesForced) {\n\t\t\t\t\t\t\t\ti = attributesForced.length;\n\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\tattr = attributesForced[i];\n\t\t\t\t\t\t\t\t\tname = attr.name;\n\t\t\t\t\t\t\t\t\tattrValue = attr.value;\n\n\t\t\t\t\t\t\t\t\tif (attrValue === '{$uid}')\n\t\t\t\t\t\t\t\t\t\tattrValue = 'mce_' + idCount++;\n\n\t\t\t\t\t\t\t\t\tattrList.map[name] = attrValue;\n\t\t\t\t\t\t\t\t\tattrList.push({name: name, value: attrValue});\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Handle default attributes\n\t\t\t\t\t\t\tif (attributesDefault) {\n\t\t\t\t\t\t\t\ti = attributesDefault.length;\n\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\tattr = attributesDefault[i];\n\t\t\t\t\t\t\t\t\tname = attr.name;\n\n\t\t\t\t\t\t\t\t\tif (!(name in attrList.map)) {\n\t\t\t\t\t\t\t\t\t\tattrValue = attr.value;\n\n\t\t\t\t\t\t\t\t\t\tif (attrValue === '{$uid}')\n\t\t\t\t\t\t\t\t\t\t\tattrValue = 'mce_' + idCount++;\n\n\t\t\t\t\t\t\t\t\t\tattrList.map[name] = attrValue;\n\t\t\t\t\t\t\t\t\t\tattrList.push({name: name, value: attrValue});\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Handle required attributes\n\t\t\t\t\t\t\tif (attributesRequired) {\n\t\t\t\t\t\t\t\ti = attributesRequired.length;\n\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\tif (attributesRequired[i] in attrList.map)\n\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// None of the required attributes where found\n\t\t\t\t\t\t\t\tif (i === -1)\n\t\t\t\t\t\t\t\t\tisValidElement = false;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Invalidate element if it's marked as bogus\n\t\t\t\t\t\t\tif (attrList.map['data-mce-bogus'])\n\t\t\t\t\t\t\t\tisValidElement = false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (isValidElement)\n\t\t\t\t\t\t\tself.start(value, attrList, isShortEnded);\n\t\t\t\t\t} else\n\t\t\t\t\t\tisValidElement = false;\n\n\t\t\t\t\t// Treat script, noscript and style a bit different since they may include code that looks like elements\n\t\t\t\t\tif (endRegExp = specialElements[value]) {\n\t\t\t\t\t\tendRegExp.lastIndex = index = matches.index + matches[0].length;\n\n\t\t\t\t\t\tif (matches = endRegExp.exec(html)) {\n\t\t\t\t\t\t\tif (isValidElement)\n\t\t\t\t\t\t\t\ttext = html.substr(index, matches.index - index);\n\n\t\t\t\t\t\t\tindex = matches.index + matches[0].length;\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\ttext = html.substr(index);\n\t\t\t\t\t\t\tindex = html.length;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (isValidElement && text.length > 0)\n\t\t\t\t\t\t\tself.text(text, true);\n\n\t\t\t\t\t\tif (isValidElement)\n\t\t\t\t\t\t\tself.end(value);\n\n\t\t\t\t\t\ttokenRegExp.lastIndex = index;\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Push value on to stack\n\t\t\t\t\tif (!isShortEnded) {\n\t\t\t\t\t\tif (!attribsValue || attribsValue.indexOf('/') != attribsValue.length - 1)\n\t\t\t\t\t\t\tstack.push({name: value, valid: isValidElement});\n\t\t\t\t\t\telse if (isValidElement)\n\t\t\t\t\t\t\tself.end(value);\n\t\t\t\t\t}\n\t\t\t\t} else if (value = matches[1]) { // Comment\n\t\t\t\t\tself.comment(value);\n\t\t\t\t} else if (value = matches[2]) { // CDATA\n\t\t\t\t\tself.cdata(value);\n\t\t\t\t} else if (value = matches[3]) { // DOCTYPE\n\t\t\t\t\tself.doctype(value);\n\t\t\t\t} else if (value = matches[4]) { // PI\n\t\t\t\t\tself.pi(value, matches[5]);\n\t\t\t\t}\n\n\t\t\t\tindex = matches.index + matches[0].length;\n\t\t\t}\n\n\t\t\t// Text\n\t\t\tif (index < html.length)\n\t\t\t\tself.text(decode(html.substr(index)));\n\n\t\t\t// Close any open elements\n\t\t\tfor (i = stack.length - 1; i >= 0; i--) {\n\t\t\t\tvalue = stack[i];\n\n\t\t\t\tif (value.valid)\n\t\t\t\t\tself.end(value.name);\n\t\t\t}\n\t\t};\n\t}\n})(tinymce);\n\n(function(tinymce) {\n\tvar whiteSpaceRegExp = /^[ \\t\\r\\n]*$/, typeLookup = {\n\t\t'#text' : 3,\n\t\t'#comment' : 8,\n\t\t'#cdata' : 4,\n\t\t'#pi' : 7,\n\t\t'#doctype' : 10,\n\t\t'#document-fragment' : 11\n\t};\n\n\t// Walks the tree left/right\n\tfunction walk(node, root_node, prev) {\n\t\tvar sibling, parent, startName = prev ? 'lastChild' : 'firstChild', siblingName = prev ? 'prev' : 'next';\n\n\t\t// Walk into nodes if it has a start\n\t\tif (node[startName])\n\t\t\treturn node[startName];\n\n\t\t// Return the sibling if it has one\n\t\tif (node !== root_node) {\n\t\t\tsibling = node[siblingName];\n\n\t\t\tif (sibling)\n\t\t\t\treturn sibling;\n\n\t\t\t// Walk up the parents to look for siblings\n\t\t\tfor (parent = node.parent; parent && parent !== root_node; parent = parent.parent) {\n\t\t\t\tsibling = parent[siblingName];\n\n\t\t\t\tif (sibling)\n\t\t\t\t\treturn sibling;\n\t\t\t}\n\t\t}\n\t};\n\n\tfunction Node(name, type) {\n\t\tthis.name = name;\n\t\tthis.type = type;\n\n\t\tif (type === 1) {\n\t\t\tthis.attributes = [];\n\t\t\tthis.attributes.map = {};\n\t\t}\n\t}\n\n\ttinymce.extend(Node.prototype, {\n\t\treplace : function(node) {\n\t\t\tvar self = this;\n\n\t\t\tif (node.parent)\n\t\t\t\tnode.remove();\n\n\t\t\tself.insert(node, self);\n\t\t\tself.remove();\n\n\t\t\treturn self;\n\t\t},\n\n\t\tattr : function(name, value) {\n\t\t\tvar self = this, attrs, i, undef;\n\n\t\t\tif (typeof name !== \"string\") {\n\t\t\t\tfor (i in name)\n\t\t\t\t\tself.attr(i, name[i]);\n\n\t\t\t\treturn self;\n\t\t\t}\n\n\t\t\tif (attrs = self.attributes) {\n\t\t\t\tif (value !== undef) {\n\t\t\t\t\t// Remove attribute\n\t\t\t\t\tif (value === null) {\n\t\t\t\t\t\tif (name in attrs.map) {\n\t\t\t\t\t\t\tdelete attrs.map[name];\n\n\t\t\t\t\t\t\ti = attrs.length;\n\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\tif (attrs[i].name === name) {\n\t\t\t\t\t\t\t\t\tattrs = attrs.splice(i, 1);\n\t\t\t\t\t\t\t\t\treturn self;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn self;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Set attribute\n\t\t\t\t\tif (name in attrs.map) {\n\t\t\t\t\t\t// Set attribute\n\t\t\t\t\t\ti = attrs.length;\n\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\tif (attrs[i].name === name) {\n\t\t\t\t\t\t\t\tattrs[i].value = value;\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t} else\n\t\t\t\t\t\tattrs.push({name: name, value: value});\n\n\t\t\t\t\tattrs.map[name] = value;\n\n\t\t\t\t\treturn self;\n\t\t\t\t} else {\n\t\t\t\t\treturn attrs.map[name];\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tclone : function() {\n\t\t\tvar self = this, clone = new Node(self.name, self.type), i, l, selfAttrs, selfAttr, cloneAttrs;\n\n\t\t\t// Clone element attributes\n\t\t\tif (selfAttrs = self.attributes) {\n\t\t\t\tcloneAttrs = [];\n\t\t\t\tcloneAttrs.map = {};\n\n\t\t\t\tfor (i = 0, l = selfAttrs.length; i < l; i++) {\n\t\t\t\t\tselfAttr = selfAttrs[i];\n\n\t\t\t\t\t// Clone everything except id\n\t\t\t\t\tif (selfAttr.name !== 'id') {\n\t\t\t\t\t\tcloneAttrs[cloneAttrs.length] = {name: selfAttr.name, value: selfAttr.value};\n\t\t\t\t\t\tcloneAttrs.map[selfAttr.name] = selfAttr.value;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tclone.attributes = cloneAttrs;\n\t\t\t}\n\n\t\t\tclone.value = self.value;\n\t\t\tclone.shortEnded = self.shortEnded;\n\n\t\t\treturn clone;\n\t\t},\n\n\t\twrap : function(wrapper) {\n\t\t\tvar self = this;\n\n\t\t\tself.parent.insert(wrapper, self);\n\t\t\twrapper.append(self);\n\n\t\t\treturn self;\n\t\t},\n\n\t\tunwrap : function() {\n\t\t\tvar self = this, node, next;\n\n\t\t\tfor (node = self.firstChild; node; ) {\n\t\t\t\tnext = node.next;\n\t\t\t\tself.insert(node, self, true);\n\t\t\t\tnode = next;\n\t\t\t}\n\n\t\t\tself.remove();\n\t\t},\n\n\t\tremove : function() {\n\t\t\tvar self = this, parent = self.parent, next = self.next, prev = self.prev;\n\n\t\t\tif (parent) {\n\t\t\t\tif (parent.firstChild === self) {\n\t\t\t\t\tparent.firstChild = next;\n\n\t\t\t\t\tif (next)\n\t\t\t\t\t\tnext.prev = null;\n\t\t\t\t} else {\n\t\t\t\t\tprev.next = next;\n\t\t\t\t}\n\n\t\t\t\tif (parent.lastChild === self) {\n\t\t\t\t\tparent.lastChild = prev;\n\n\t\t\t\t\tif (prev)\n\t\t\t\t\t\tprev.next = null;\n\t\t\t\t} else {\n\t\t\t\t\tnext.prev = prev;\n\t\t\t\t}\n\n\t\t\t\tself.parent = self.next = self.prev = null;\n\t\t\t}\n\n\t\t\treturn self;\n\t\t},\n\n\t\tappend : function(node) {\n\t\t\tvar self = this, last;\n\n\t\t\tif (node.parent)\n\t\t\t\tnode.remove();\n\n\t\t\tlast = self.lastChild;\n\t\t\tif (last) {\n\t\t\t\tlast.next = node;\n\t\t\t\tnode.prev = last;\n\t\t\t\tself.lastChild = node;\n\t\t\t} else\n\t\t\t\tself.lastChild = self.firstChild = node;\n\n\t\t\tnode.parent = self;\n\n\t\t\treturn node;\n\t\t},\n\n\t\tinsert : function(node, ref_node, before) {\n\t\t\tvar parent;\n\n\t\t\tif (node.parent)\n\t\t\t\tnode.remove();\n\n\t\t\tparent = ref_node.parent || this;\n\n\t\t\tif (before) {\n\t\t\t\tif (ref_node === parent.firstChild)\n\t\t\t\t\tparent.firstChild = node;\n\t\t\t\telse\n\t\t\t\t\tref_node.prev.next = node;\n\n\t\t\t\tnode.prev = ref_node.prev;\n\t\t\t\tnode.next = ref_node;\n\t\t\t\tref_node.prev = node;\n\t\t\t} else {\n\t\t\t\tif (ref_node === parent.lastChild)\n\t\t\t\t\tparent.lastChild = node;\n\t\t\t\telse\n\t\t\t\t\tref_node.next.prev = node;\n\n\t\t\t\tnode.next = ref_node.next;\n\t\t\t\tnode.prev = ref_node;\n\t\t\t\tref_node.next = node;\n\t\t\t}\n\n\t\t\tnode.parent = parent;\n\n\t\t\treturn node;\n\t\t},\n\n\t\tgetAll : function(name) {\n\t\t\tvar self = this, node, collection = [];\n\n\t\t\tfor (node = self.firstChild; node; node = walk(node, self)) {\n\t\t\t\tif (node.name === name)\n\t\t\t\t\tcollection.push(node);\n\t\t\t}\n\n\t\t\treturn collection;\n\t\t},\n\n\t\tempty : function() {\n\t\t\tvar self = this, nodes, i, node;\n\n\t\t\t// Remove all children\n\t\t\tif (self.firstChild) {\n\t\t\t\tnodes = [];\n\n\t\t\t\t// Collect the children\n\t\t\t\tfor (node = self.firstChild; node; node = walk(node, self))\n\t\t\t\t\tnodes.push(node);\n\n\t\t\t\t// Remove the children\n\t\t\t\ti = nodes.length;\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tnode.parent = node.firstChild = node.lastChild = node.next = node.prev = null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tself.firstChild = self.lastChild = null;\n\n\t\t\treturn self;\n\t\t},\n\n\t\tisEmpty : function(elements) {\n\t\t\tvar self = this, node = self.firstChild, i, name;\n\n\t\t\tif (node) {\n\t\t\t\tdo {\n\t\t\t\t\tif (node.type === 1) {\n\t\t\t\t\t\t// Ignore bogus elements\n\t\t\t\t\t\tif (node.attributes.map['data-mce-bogus'])\n\t\t\t\t\t\t\tcontinue;\n\n\t\t\t\t\t\t// Keep empty elements like <img />\n\t\t\t\t\t\tif (elements[node.name])\n\t\t\t\t\t\t\treturn false;\n\n\t\t\t\t\t\t// Keep elements with data attributes or name attribute like <a name=\"1\"></a>\n\t\t\t\t\t\ti = node.attributes.length;\n\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\tname = node.attributes[i].name;\n\t\t\t\t\t\t\tif (name === \"name\" || name.indexOf('data-') === 0)\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Keep non whitespace text nodes\n\t\t\t\t\tif ((node.type === 3 && !whiteSpaceRegExp.test(node.value)))\n\t\t\t\t\t\treturn false;\n\t\t\t\t} while (node = walk(node, self));\n\t\t\t}\n\n\t\t\treturn true;\n\t\t},\n\n\t\twalk : function(prev) {\n\t\t\treturn walk(this, null, prev);\n\t\t}\n\t});\n\n\ttinymce.extend(Node, {\n\t\tcreate : function(name, attrs) {\n\t\t\tvar node, attrName;\n\n\t\t\t// Create node\n\t\t\tnode = new Node(name, typeLookup[name] || 1);\n\n\t\t\t// Add attributes if needed\n\t\t\tif (attrs) {\n\t\t\t\tfor (attrName in attrs)\n\t\t\t\t\tnode.attr(attrName, attrs[attrName]);\n\t\t\t}\n\n\t\t\treturn node;\n\t\t}\n\t});\n\n\ttinymce.html.Node = Node;\n})(tinymce);\n\n(function(tinymce) {\n\tvar Node = tinymce.html.Node;\n\n\ttinymce.html.DomParser = function(settings, schema) {\n\t\tvar self = this, nodeFilters = {}, attributeFilters = [], matchedNodes = {}, matchedAttributes = {};\n\n\t\tsettings = settings || {};\n\t\tsettings.validate = \"validate\" in settings ? settings.validate : true;\n\t\tsettings.root_name = settings.root_name || 'body';\n\t\tself.schema = schema = schema || new tinymce.html.Schema();\n\n\t\tfunction fixInvalidChildren(nodes) {\n\t\t\tvar ni, node, parent, parents, newParent, currentNode, tempNode, childNode, i,\n\t\t\t\tchildClone, nonEmptyElements, nonSplitableElements, sibling, nextNode;\n\n\t\t\tnonSplitableElements = tinymce.makeMap('tr,td,th,tbody,thead,tfoot,table');\n\t\t\tnonEmptyElements = schema.getNonEmptyElements();\n\n\t\t\tfor (ni = 0; ni < nodes.length; ni++) {\n\t\t\t\tnode = nodes[ni];\n\n\t\t\t\t// Already removed\n\t\t\t\tif (!node.parent)\n\t\t\t\t\tcontinue;\n\n\t\t\t\t// Get list of all parent nodes until we find a valid parent to stick the child into\n\t\t\t\tparents = [node];\n\t\t\t\tfor (parent = node.parent; parent && !schema.isValidChild(parent.name, node.name) && !nonSplitableElements[parent.name]; parent = parent.parent)\n\t\t\t\t\tparents.push(parent);\n\n\t\t\t\t// Found a suitable parent\n\t\t\t\tif (parent && parents.length > 1) {\n\t\t\t\t\t// Reverse the array since it makes looping easier\n\t\t\t\t\tparents.reverse();\n\n\t\t\t\t\t// Clone the related parent and insert that after the moved node\n\t\t\t\t\tnewParent = currentNode = self.filterNode(parents[0].clone());\n\n\t\t\t\t\t// Start cloning and moving children on the left side of the target node\n\t\t\t\t\tfor (i = 0; i < parents.length - 1; i++) {\n\t\t\t\t\t\tif (schema.isValidChild(currentNode.name, parents[i].name)) {\n\t\t\t\t\t\t\ttempNode = self.filterNode(parents[i].clone());\n\t\t\t\t\t\t\tcurrentNode.append(tempNode);\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\ttempNode = currentNode;\n\n\t\t\t\t\t\tfor (childNode = parents[i].firstChild; childNode && childNode != parents[i + 1]; ) {\n\t\t\t\t\t\t\tnextNode = childNode.next;\n\t\t\t\t\t\t\ttempNode.append(childNode);\n\t\t\t\t\t\t\tchildNode = nextNode;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tcurrentNode = tempNode;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!newParent.isEmpty(nonEmptyElements)) {\n\t\t\t\t\t\tparent.insert(newParent, parents[0], true);\n\t\t\t\t\t\tparent.insert(node, newParent);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tparent.insert(node, parents[0], true);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Check if the element is empty by looking through it's contents and special treatment for <p><br /></p>\n\t\t\t\t\tparent = parents[0];\n\t\t\t\t\tif (parent.isEmpty(nonEmptyElements) || parent.firstChild === parent.lastChild && parent.firstChild.name === 'br') {\n\t\t\t\t\t\tparent.empty().remove();\n\t\t\t\t\t}\n\t\t\t\t} else if (node.parent) {\n\t\t\t\t\t// If it's an LI try to find a UL/OL for it or wrap it\n\t\t\t\t\tif (node.name === 'li') {\n\t\t\t\t\t\tsibling = node.prev;\n\t\t\t\t\t\tif (sibling && (sibling.name === 'ul' || sibling.name === 'ul')) {\n\t\t\t\t\t\t\tsibling.append(node);\n\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tsibling = node.next;\n\t\t\t\t\t\tif (sibling && (sibling.name === 'ul' || sibling.name === 'ul')) {\n\t\t\t\t\t\t\tsibling.insert(node, sibling.firstChild, true);\n\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tnode.wrap(self.filterNode(new Node('ul', 1)));\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Try wrapping the element in a DIV\n\t\t\t\t\tif (schema.isValidChild(node.parent.name, 'div') && schema.isValidChild('div', node.name)) {\n\t\t\t\t\t\tnode.wrap(self.filterNode(new Node('div', 1)));\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// We failed wrapping it, then remove or unwrap it\n\t\t\t\t\t\tif (node.name === 'style' || node.name === 'script')\n\t\t\t\t\t\t\tnode.empty().remove();\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tnode.unwrap();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tself.filterNode = function(node) {\n\t\t\tvar i, name, list;\n\n\t\t\t// Run element filters\n\t\t\tif (name in nodeFilters) {\n\t\t\t\tlist = matchedNodes[name];\n\n\t\t\t\tif (list)\n\t\t\t\t\tlist.push(node);\n\t\t\t\telse\n\t\t\t\t\tmatchedNodes[name] = [node];\n\t\t\t}\n\n\t\t\t// Run attribute filters\n\t\t\ti = attributeFilters.length;\n\t\t\twhile (i--) {\n\t\t\t\tname = attributeFilters[i].name;\n\n\t\t\t\tif (name in node.attributes.map) {\n\t\t\t\t\tlist = matchedAttributes[name];\n\n\t\t\t\t\tif (list)\n\t\t\t\t\t\tlist.push(node);\n\t\t\t\t\telse\n\t\t\t\t\t\tmatchedAttributes[name] = [node];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn node;\n\t\t};\n\n\t\tself.addNodeFilter = function(name, callback) {\n\t\t\ttinymce.each(tinymce.explode(name), function(name) {\n\t\t\t\tvar list = nodeFilters[name];\n\n\t\t\t\tif (!list)\n\t\t\t\t\tnodeFilters[name] = list = [];\n\n\t\t\t\tlist.push(callback);\n\t\t\t});\n\t\t};\n\n\t\tself.addAttributeFilter = function(name, callback) {\n\t\t\ttinymce.each(tinymce.explode(name), function(name) {\n\t\t\t\tvar i;\n\n\t\t\t\tfor (i = 0; i < attributeFilters.length; i++) {\n\t\t\t\t\tif (attributeFilters[i].name === name) {\n\t\t\t\t\t\tattributeFilters[i].callbacks.push(callback);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tattributeFilters.push({name: name, callbacks: [callback]});\n\t\t\t});\n\t\t};\n\n\t\tself.parse = function(html, args) {\n\t\t\tvar parser, rootNode, node, nodes, i, l, fi, fl, list, name, validate,\n\t\t\t\tblockElements, startWhiteSpaceRegExp, invalidChildren = [],\n\t\t\t\tendWhiteSpaceRegExp, allWhiteSpaceRegExp, whiteSpaceElements, children, nonEmptyElements, rootBlockName;\n\n\t\t\targs = args || {};\n\t\t\tmatchedNodes = {};\n\t\t\tmatchedAttributes = {};\n\t\t\tblockElements = tinymce.extend(tinymce.makeMap('script,style,head,html,body,title,meta,param'), schema.getBlockElements());\n\t\t\tnonEmptyElements = schema.getNonEmptyElements();\n\t\t\tchildren = schema.children;\n\t\t\tvalidate = settings.validate;\n\t\t\trootBlockName = \"forced_root_block\" in args ? args.forced_root_block : settings.forced_root_block;\n\n\t\t\twhiteSpaceElements = schema.getWhiteSpaceElements();\n\t\t\tstartWhiteSpaceRegExp = /^[ \\t\\r\\n]+/;\n\t\t\tendWhiteSpaceRegExp = /[ \\t\\r\\n]+$/;\n\t\t\tallWhiteSpaceRegExp = /[ \\t\\r\\n]+/g;\n\n\t\t\tfunction addRootBlocks() {\n\t\t\t\tvar node = rootNode.firstChild, next, rootBlockNode;\n\n\t\t\t\twhile (node) {\n\t\t\t\t\tnext = node.next;\n\n\t\t\t\t\tif (node.type == 3 || (node.type == 1 && node.name !== 'p' && !blockElements[node.name] && !node.attr('data-mce-type'))) {\n\t\t\t\t\t\tif (!rootBlockNode) {\n\t\t\t\t\t\t\t// Create a new root block element\n\t\t\t\t\t\t\trootBlockNode = createNode(rootBlockName, 1);\n\t\t\t\t\t\t\trootNode.insert(rootBlockNode, node);\n\t\t\t\t\t\t\trootBlockNode.append(node);\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\trootBlockNode.append(node);\n\t\t\t\t\t} else {\n\t\t\t\t\t\trootBlockNode = null;\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = next;\n\t\t\t\t};\n\t\t\t};\n\n\t\t\tfunction createNode(name, type) {\n\t\t\t\tvar node = new Node(name, type), list;\n\n\t\t\t\tif (name in nodeFilters) {\n\t\t\t\t\tlist = matchedNodes[name];\n\n\t\t\t\t\tif (list)\n\t\t\t\t\t\tlist.push(node);\n\t\t\t\t\telse\n\t\t\t\t\t\tmatchedNodes[name] = [node];\n\t\t\t\t}\n\n\t\t\t\treturn node;\n\t\t\t};\n\n\t\t\tfunction removeWhitespaceBefore(node) {\n\t\t\t\tvar textNode, textVal, sibling;\n\n\t\t\t\tfor (textNode = node.prev; textNode && textNode.type === 3; ) {\n\t\t\t\t\ttextVal = textNode.value.replace(endWhiteSpaceRegExp, '');\n\n\t\t\t\t\tif (textVal.length > 0) {\n\t\t\t\t\t\ttextNode.value = textVal;\n\t\t\t\t\t\ttextNode = textNode.prev;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tsibling = textNode.prev;\n\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\ttextNode = sibling;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tparser = new tinymce.html.SaxParser({\n\t\t\t\tvalidate : validate,\n\t\t\t\tfix_self_closing : !validate, // Let the DOM parser handle <li> in <li> or <p> in <p> for better results\n\n\t\t\t\tcdata: function(text) {\n\t\t\t\t\tnode.append(createNode('#cdata', 4)).value = text;\n\t\t\t\t},\n\n\t\t\t\ttext: function(text, raw) {\n\t\t\t\t\tvar textNode;\n\n\t\t\t\t\t// Trim all redundant whitespace on non white space elements\n\t\t\t\t\tif (!whiteSpaceElements[node.name]) {\n\t\t\t\t\t\ttext = text.replace(allWhiteSpaceRegExp, ' ');\n\n\t\t\t\t\t\tif (node.lastChild && blockElements[node.lastChild.name])\n\t\t\t\t\t\t\ttext = text.replace(startWhiteSpaceRegExp, '');\n\t\t\t\t\t}\n\n\t\t\t\t\t// Do we need to create the node\n\t\t\t\t\tif (text.length !== 0) {\n\t\t\t\t\t\ttextNode = createNode('#text', 3);\n\t\t\t\t\t\ttextNode.raw = !!raw;\n\t\t\t\t\t\tnode.append(textNode).value = text;\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tcomment: function(text) {\n\t\t\t\t\tnode.append(createNode('#comment', 8)).value = text;\n\t\t\t\t},\n\n\t\t\t\tpi: function(name, text) {\n\t\t\t\t\tnode.append(createNode(name, 7)).value = text;\n\t\t\t\t\tremoveWhitespaceBefore(node);\n\t\t\t\t},\n\n\t\t\t\tdoctype: function(text) {\n\t\t\t\t\tvar newNode;\n\n\t\t\t\t\tnewNode = node.append(createNode('#doctype', 10));\n\t\t\t\t\tnewNode.value = text;\n\t\t\t\t\tremoveWhitespaceBefore(node);\n\t\t\t\t},\n\n\t\t\t\tstart: function(name, attrs, empty) {\n\t\t\t\t\tvar newNode, attrFiltersLen, elementRule, textNode, attrName, text, sibling, parent;\n\n\t\t\t\t\telementRule = validate ? schema.getElementRule(name) : {};\n\t\t\t\t\tif (elementRule) {\n\t\t\t\t\t\tnewNode = createNode(elementRule.outputName || name, 1);\n\t\t\t\t\t\tnewNode.attributes = attrs;\n\t\t\t\t\t\tnewNode.shortEnded = empty;\n\n\t\t\t\t\t\tnode.append(newNode);\n\n\t\t\t\t\t\t// Check if node is valid child of the parent node is the child is\n\t\t\t\t\t\t// unknown we don't collect it since it's probably a custom element\n\t\t\t\t\t\tparent = children[node.name];\n\t\t\t\t\t\tif (parent && children[newNode.name] && !parent[newNode.name])\n\t\t\t\t\t\t\tinvalidChildren.push(newNode);\n\n\t\t\t\t\t\tattrFiltersLen = attributeFilters.length;\n\t\t\t\t\t\twhile (attrFiltersLen--) {\n\t\t\t\t\t\t\tattrName = attributeFilters[attrFiltersLen].name;\n\n\t\t\t\t\t\t\tif (attrName in attrs.map) {\n\t\t\t\t\t\t\t\tlist = matchedAttributes[attrName];\n\n\t\t\t\t\t\t\t\tif (list)\n\t\t\t\t\t\t\t\t\tlist.push(newNode);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\tmatchedAttributes[attrName] = [newNode];\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Trim whitespace before block\n\t\t\t\t\t\tif (blockElements[name])\n\t\t\t\t\t\t\tremoveWhitespaceBefore(newNode);\n\n\t\t\t\t\t\t// Change current node if the element wasn't empty i.e not <br /> or <img />\n\t\t\t\t\t\tif (!empty)\n\t\t\t\t\t\t\tnode = newNode;\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tend: function(name) {\n\t\t\t\t\tvar textNode, elementRule, text, sibling, tempNode;\n\n\t\t\t\t\telementRule = validate ? schema.getElementRule(name) : {};\n\t\t\t\t\tif (elementRule) {\n\t\t\t\t\t\tif (blockElements[name]) {\n\t\t\t\t\t\t\tif (!whiteSpaceElements[node.name]) {\n\t\t\t\t\t\t\t\t// Trim whitespace at beginning of block\n\t\t\t\t\t\t\t\tfor (textNode = node.firstChild; textNode && textNode.type === 3; ) {\n\t\t\t\t\t\t\t\t\ttext = textNode.value.replace(startWhiteSpaceRegExp, '');\n\n\t\t\t\t\t\t\t\t\tif (text.length > 0) {\n\t\t\t\t\t\t\t\t\t\ttextNode.value = text;\n\t\t\t\t\t\t\t\t\t\ttextNode = textNode.next;\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tsibling = textNode.next;\n\t\t\t\t\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\t\t\t\t\ttextNode = sibling;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Trim whitespace at end of block\n\t\t\t\t\t\t\t\tfor (textNode = node.lastChild; textNode && textNode.type === 3; ) {\n\t\t\t\t\t\t\t\t\ttext = textNode.value.replace(endWhiteSpaceRegExp, '');\n\n\t\t\t\t\t\t\t\t\tif (text.length > 0) {\n\t\t\t\t\t\t\t\t\t\ttextNode.value = text;\n\t\t\t\t\t\t\t\t\t\ttextNode = textNode.prev;\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tsibling = textNode.prev;\n\t\t\t\t\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\t\t\t\t\ttextNode = sibling;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Trim start white space\n\t\t\t\t\t\t\ttextNode = node.prev;\n\t\t\t\t\t\t\tif (textNode && textNode.type === 3) {\n\t\t\t\t\t\t\t\ttext = textNode.value.replace(startWhiteSpaceRegExp, '');\n\n\t\t\t\t\t\t\t\tif (text.length > 0)\n\t\t\t\t\t\t\t\t\ttextNode.value = text;\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Handle empty nodes\n\t\t\t\t\t\tif (elementRule.removeEmpty || elementRule.paddEmpty) {\n\t\t\t\t\t\t\tif (node.isEmpty(nonEmptyElements)) {\n\t\t\t\t\t\t\t\tif (elementRule.paddEmpty)\n\t\t\t\t\t\t\t\t\tnode.empty().append(new Node('#text', '3')).value = '\\u00a0';\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t// Leave nodes that have a name like <a name=\"name\">\n\t\t\t\t\t\t\t\t\tif (!node.attributes.map.name) {\n\t\t\t\t\t\t\t\t\t\ttempNode = node.parent;\n\t\t\t\t\t\t\t\t\t\tnode.empty().remove();\n\t\t\t\t\t\t\t\t\t\tnode = tempNode;\n\t\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tnode = node.parent;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}, schema);\n\n\t\t\trootNode = node = new Node(args.context || settings.root_name, 11);\n\n\t\t\tparser.parse(html);\n\n\t\t\t// Fix invalid children or report invalid children in a contextual parsing\n\t\t\tif (validate && invalidChildren.length) {\n\t\t\t\tif (!args.context)\n\t\t\t\t\tfixInvalidChildren(invalidChildren);\n\t\t\t\telse\n\t\t\t\t\targs.invalid = true;\n\t\t\t}\n\n\t\t\t// Wrap nodes in the root into block elements if the root is body\n\t\t\tif (rootBlockName && rootNode.name == 'body')\n\t\t\t\taddRootBlocks();\n\n\t\t\t// Run filters only when the contents is valid\n\t\t\tif (!args.invalid) {\n\t\t\t\t// Run node filters\n\t\t\t\tfor (name in matchedNodes) {\n\t\t\t\t\tlist = nodeFilters[name];\n\t\t\t\t\tnodes = matchedNodes[name];\n\n\t\t\t\t\t// Remove already removed children\n\t\t\t\t\tfi = nodes.length;\n\t\t\t\t\twhile (fi--) {\n\t\t\t\t\t\tif (!nodes[fi].parent)\n\t\t\t\t\t\t\tnodes.splice(fi, 1);\n\t\t\t\t\t}\n\n\t\t\t\t\tfor (i = 0, l = list.length; i < l; i++)\n\t\t\t\t\t\tlist[i](nodes, name, args);\n\t\t\t\t}\n\n\t\t\t\t// Run attribute filters\n\t\t\t\tfor (i = 0, l = attributeFilters.length; i < l; i++) {\n\t\t\t\t\tlist = attributeFilters[i];\n\n\t\t\t\t\tif (list.name in matchedAttributes) {\n\t\t\t\t\t\tnodes = matchedAttributes[list.name];\n\n\t\t\t\t\t\t// Remove already removed children\n\t\t\t\t\t\tfi = nodes.length;\n\t\t\t\t\t\twhile (fi--) {\n\t\t\t\t\t\t\tif (!nodes[fi].parent)\n\t\t\t\t\t\t\t\tnodes.splice(fi, 1);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfor (fi = 0, fl = list.callbacks.length; fi < fl; fi++)\n\t\t\t\t\t\t\tlist.callbacks[fi](nodes, list.name, args);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn rootNode;\n\t\t};\n\n\t\t// Remove <br> at end of block elements Gecko and WebKit injects BR elements to\n\t\t// make it possible to place the caret inside empty blocks. This logic tries to remove\n\t\t// these elements and keep br elements that where intended to be there intact\n\t\tif (settings.remove_trailing_brs) {\n\t\t\tself.addNodeFilter('br', function(nodes, name) {\n\t\t\t\tvar i, l = nodes.length, node, blockElements = schema.getBlockElements(),\n\t\t\t\t\tnonEmptyElements = schema.getNonEmptyElements(), parent, prev, prevName;\n\n\t\t\t\t// Remove brs from body element as well\n\t\t\t\tblockElements.body = 1;\n\n\t\t\t\t// Must loop forwards since it will otherwise remove all brs in <p>a<br><br><br></p>\n\t\t\t\tfor (i = 0; i < l; i++) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tparent = node.parent;\n\n\t\t\t\t\tif (blockElements[node.parent.name] && node === parent.lastChild) {\n\t\t\t\t\t\t// Loop all nodes to the right of the current node and check for other BR elements\n\t\t\t\t\t\t// excluding bookmarks since they are invisible\n\t\t\t\t\t\tprev = node.prev;\n\t\t\t\t\t\twhile (prev) {\n\t\t\t\t\t\t\tprevName = prev.name;\n\n\t\t\t\t\t\t\t// Ignore bookmarks\n\t\t\t\t\t\t\tif (prevName !== \"span\" || prev.attr('data-mce-type') !== 'bookmark') {\n\t\t\t\t\t\t\t\t// Found a non BR element\n\t\t\t\t\t\t\t\tif (prevName !== \"br\")\n\t\t\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\t\t\t// Found another br it's a <br><br> structure then don't remove anything\n\t\t\t\t\t\t\t\tif (prevName === 'br') {\n\t\t\t\t\t\t\t\t\tnode = null;\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tprev = prev.prev;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (node) {\n\t\t\t\t\t\t\tnode.remove();\n\n\t\t\t\t\t\t\t// Is the parent to be considered empty after we removed the BR\n\t\t\t\t\t\t\tif (parent.isEmpty(nonEmptyElements)) {\n\t\t\t\t\t\t\t\telementRule = schema.getElementRule(parent.name);\n\n\t\t\t\t\t\t\t\t// Remove or padd the element depending on schema rule\n\t\t\t\t\t\t\t\tif (elementRule) {\n\t\t\t\t\t\t\t\t  if (elementRule.removeEmpty)\n\t\t\t\t\t\t\t\t\t  parent.remove();\n\t\t\t\t\t\t\t\t  else if (elementRule.paddEmpty)\n\t\t\t\t\t\t\t\t\t  parent.empty().append(new tinymce.html.Node('#text', 3)).value = '\\u00a0';\n\t\t\t\t\t\t\t  }\n              }\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t}\n})(tinymce);\n\ntinymce.html.Writer = function(settings) {\n\tvar html = [], indent, indentBefore, indentAfter, encode, htmlOutput;\n\n\tsettings = settings || {};\n\tindent = settings.indent;\n\tindentBefore = tinymce.makeMap(settings.indent_before || '');\n\tindentAfter = tinymce.makeMap(settings.indent_after || '');\n\tencode = tinymce.html.Entities.getEncodeFunc(settings.entity_encoding || 'raw', settings.entities);\n\thtmlOutput = settings.element_format == \"html\";\n\n\treturn {\n\t\tstart: function(name, attrs, empty) {\n\t\t\tvar i, l, attr, value;\n\n\t\t\tif (indent && indentBefore[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}\n\n\t\t\thtml.push('<', name);\n\n\t\t\tif (attrs) {\n\t\t\t\tfor (i = 0, l = attrs.length; i < l; i++) {\n\t\t\t\t\tattr = attrs[i];\n\t\t\t\t\thtml.push(' ', attr.name, '=\"', encode(attr.value, true), '\"');\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (!empty || htmlOutput)\n\t\t\t\thtml[html.length] = '>';\n\t\t\telse\n\t\t\t\thtml[html.length] = ' />';\n\n\t\t\tif (empty && indent && indentAfter[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}\n\t\t},\n\n\t\tend: function(name) {\n\t\t\tvar value;\n\n\t\t\t/*if (indent && indentBefore[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}*/\n\n\t\t\thtml.push('</', name, '>');\n\n\t\t\tif (indent && indentAfter[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}\n\t\t},\n\n\t\ttext: function(text, raw) {\n\t\t\tif (text.length > 0)\n\t\t\t\thtml[html.length] = raw ? text : encode(text);\n\t\t},\n\n\t\tcdata: function(text) {\n\t\t\thtml.push('<![CDATA[', text, ']]>');\n\t\t},\n\n\t\tcomment: function(text) {\n\t\t\thtml.push('<!--', text, '-->');\n\t\t},\n\n\t\tpi: function(name, text) {\n\t\t\tif (text)\n\t\t\t\thtml.push('<?', name, ' ', text, '?>');\n\t\t\telse\n\t\t\t\thtml.push('<?', name, '?>');\n\n\t\t\tif (indent)\n\t\t\t\thtml.push('\\n');\n\t\t},\n\n\t\tdoctype: function(text) {\n\t\t\thtml.push('<!DOCTYPE', text, '>', indent ? '\\n' : '');\n\t\t},\n\n\t\treset: function() {\n\t\t\thtml.length = 0;\n\t\t},\n\n\t\tgetContent: function() {\n\t\t\treturn html.join('').replace(/\\n$/, '');\n\t\t}\n\t};\n};\n\n(function(tinymce) {\n\ttinymce.html.Serializer = function(settings, schema) {\n\t\tvar self = this, writer = new tinymce.html.Writer(settings);\n\n\t\tsettings = settings || {};\n\t\tsettings.validate = \"validate\" in settings ? settings.validate : true;\n\n\t\tself.schema = schema = schema || new tinymce.html.Schema();\n\t\tself.writer = writer;\n\n\t\tself.serialize = function(node) {\n\t\t\tvar handlers, validate;\n\n\t\t\tvalidate = settings.validate;\n\n\t\t\thandlers = {\n\t\t\t\t// #text\n\t\t\t\t3: function(node, raw) {\n\t\t\t\t\twriter.text(node.value, node.raw);\n\t\t\t\t},\n\n\t\t\t\t// #comment\n\t\t\t\t8: function(node) {\n\t\t\t\t\twriter.comment(node.value);\n\t\t\t\t},\n\n\t\t\t\t// Processing instruction\n\t\t\t\t7: function(node) {\n\t\t\t\t\twriter.pi(node.name, node.value);\n\t\t\t\t},\n\n\t\t\t\t// Doctype\n\t\t\t\t10: function(node) {\n\t\t\t\t\twriter.doctype(node.value);\n\t\t\t\t},\n\n\t\t\t\t// CDATA\n\t\t\t\t4: function(node) {\n\t\t\t\t\twriter.cdata(node.value);\n\t\t\t\t},\n\n \t\t\t\t// Document fragment\n\t\t\t\t11: function(node) {\n\t\t\t\t\tif ((node = node.firstChild)) {\n\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\twalk(node);\n\t\t\t\t\t\t} while (node = node.next);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\twriter.reset();\n\n\t\t\tfunction walk(node) {\n\t\t\t\tvar handler = handlers[node.type], name, isEmpty, attrs, attrName, attrValue, sortedAttrs, i, l, elementRule;\n\n\t\t\t\tif (!handler) {\n\t\t\t\t\tname = node.name;\n\t\t\t\t\tisEmpty = node.shortEnded;\n\t\t\t\t\tattrs = node.attributes;\n\n\t\t\t\t\t// Sort attributes\n\t\t\t\t\tif (validate && attrs && attrs.length > 1) {\n\t\t\t\t\t\tsortedAttrs = [];\n\t\t\t\t\t\tsortedAttrs.map = {};\n\n\t\t\t\t\t\telementRule = schema.getElementRule(node.name);\n\t\t\t\t\t\tfor (i = 0, l = elementRule.attributesOrder.length; i < l; i++) {\n\t\t\t\t\t\t\tattrName = elementRule.attributesOrder[i];\n\n\t\t\t\t\t\t\tif (attrName in attrs.map) {\n\t\t\t\t\t\t\t\tattrValue = attrs.map[attrName];\n\t\t\t\t\t\t\t\tsortedAttrs.map[attrName] = attrValue;\n\t\t\t\t\t\t\t\tsortedAttrs.push({name: attrName, value: attrValue});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfor (i = 0, l = attrs.length; i < l; i++) {\n\t\t\t\t\t\t\tattrName = attrs[i].name;\n\n\t\t\t\t\t\t\tif (!(attrName in sortedAttrs.map)) {\n\t\t\t\t\t\t\t\tattrValue = attrs.map[attrName];\n\t\t\t\t\t\t\t\tsortedAttrs.map[attrName] = attrValue;\n\t\t\t\t\t\t\t\tsortedAttrs.push({name: attrName, value: attrValue});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tattrs = sortedAttrs;\n\t\t\t\t\t}\n\n\t\t\t\t\twriter.start(node.name, attrs, isEmpty);\n\n\t\t\t\t\tif (!isEmpty) {\n\t\t\t\t\t\tif ((node = node.firstChild)) {\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\twalk(node);\n\t\t\t\t\t\t\t} while (node = node.next);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\twriter.end(name);\n\t\t\t\t\t}\n\t\t\t\t} else\n\t\t\t\t\thandler(node);\n\t\t\t}\n\n\t\t\t// Serialize element and treat all non elements as fragments\n\t\t\tif (node.type == 1 && !settings.inner)\n\t\t\t\twalk(node);\n\t\t\telse\n\t\t\t\thandlers[11](node);\n\n\t\t\treturn writer.getContent();\n\t\t};\n\t}\n})(tinymce);\n\n(function(tinymce) {\n\t// Shorten names\n\tvar each = tinymce.each,\n\t\tis = tinymce.is,\n\t\tisWebKit = tinymce.isWebKit,\n\t\tisIE = tinymce.isIE,\n\t\tEntities = tinymce.html.Entities,\n\t\tsimpleSelectorRe = /^([a-z0-9],?)+$/i,\n\t\tblockElementsMap = tinymce.html.Schema.blockElementsMap,\n\t\twhiteSpaceRegExp = /^[ \\t\\r\\n]*$/;\n\n\ttinymce.create('tinymce.dom.DOMUtils', {\n\t\tdoc : null,\n\t\troot : null,\n\t\tfiles : null,\n\t\tpixelStyles : /^(top|left|bottom|right|width|height|borderWidth)$/,\n\t\tprops : {\n\t\t\t\"for\" : \"htmlFor\",\n\t\t\t\"class\" : \"className\",\n\t\t\tclassName : \"className\",\n\t\t\tchecked : \"checked\",\n\t\t\tdisabled : \"disabled\",\n\t\t\tmaxlength : \"maxLength\",\n\t\t\treadonly : \"readOnly\",\n\t\t\tselected : \"selected\",\n\t\t\tvalue : \"value\",\n\t\t\tid : \"id\",\n\t\t\tname : \"name\",\n\t\t\ttype : \"type\"\n\t\t},\n\n\t\tDOMUtils : function(d, s) {\n\t\t\tvar t = this, globalStyle, name;\n\n\t\t\tt.doc = d;\n\t\t\tt.win = window;\n\t\t\tt.files = {};\n\t\t\tt.cssFlicker = false;\n\t\t\tt.counter = 0;\n\t\t\tt.stdMode = !tinymce.isIE || d.documentMode >= 8;\n\t\t\tt.boxModel = !tinymce.isIE || d.compatMode == \"CSS1Compat\" || t.stdMode;\n\t\t\tt.hasOuterHTML = \"outerHTML\" in d.createElement(\"a\");\n\n\t\t\tt.settings = s = tinymce.extend({\n\t\t\t\tkeep_values : false,\n\t\t\t\thex_colors : 1\n\t\t\t}, s);\n\n\t\t\tt.schema = s.schema;\n\t\t\tt.styles = new tinymce.html.Styles({\n\t\t\t\turl_converter : s.url_converter,\n\t\t\t\turl_converter_scope : s.url_converter_scope\n\t\t\t}, s.schema);\n\n\t\t\t// Fix IE6SP2 flicker and check it failed for pre SP2\n\t\t\tif (tinymce.isIE6) {\n\t\t\t\ttry {\n\t\t\t\t\td.execCommand('BackgroundImageCache', false, true);\n\t\t\t\t} catch (e) {\n\t\t\t\t\tt.cssFlicker = true;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (isIE && s.schema) {\n\t\t\t\t// Add missing HTML 4/5 elements to IE\n\t\t\t\t('abbr article aside audio canvas ' +\n\t\t\t\t'details figcaption figure footer ' +\n\t\t\t\t'header hgroup mark menu meter nav ' +\n\t\t\t\t'output progress section summary ' +\n\t\t\t\t'time video').replace(/\\w+/g, function(name) {\n\t\t\t\t\td.createElement(name);\n\t\t\t\t});\n\n\t\t\t\t// Create all custom elements\n\t\t\t\tfor (name in s.schema.getCustomElements()) {\n\t\t\t\t\td.createElement(name);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\ttinymce.addUnload(t.destroy, t);\n\t\t},\n\n\t\tgetRoot : function() {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\treturn (s && t.get(s.root_element)) || t.doc.body;\n\t\t},\n\n\t\tgetViewPort : function(w) {\n\t\t\tvar d, b;\n\n\t\t\tw = !w ? this.win : w;\n\t\t\td = w.document;\n\t\t\tb = this.boxModel ? d.documentElement : d.body;\n\n\t\t\t// Returns viewport size excluding scrollbars\n\t\t\treturn {\n\t\t\t\tx : w.pageXOffset || b.scrollLeft,\n\t\t\t\ty : w.pageYOffset || b.scrollTop,\n\t\t\t\tw : w.innerWidth || b.clientWidth,\n\t\t\t\th : w.innerHeight || b.clientHeight\n\t\t\t};\n\t\t},\n\n\t\tgetRect : function(e) {\n\t\t\tvar p, t = this, sr;\n\n\t\t\te = t.get(e);\n\t\t\tp = t.getPos(e);\n\t\t\tsr = t.getSize(e);\n\n\t\t\treturn {\n\t\t\t\tx : p.x,\n\t\t\t\ty : p.y,\n\t\t\t\tw : sr.w,\n\t\t\t\th : sr.h\n\t\t\t};\n\t\t},\n\n\t\tgetSize : function(e) {\n\t\t\tvar t = this, w, h;\n\n\t\t\te = t.get(e);\n\t\t\tw = t.getStyle(e, 'width');\n\t\t\th = t.getStyle(e, 'height');\n\n\t\t\t// Non pixel value, then force offset/clientWidth\n\t\t\tif (w.indexOf('px') === -1)\n\t\t\t\tw = 0;\n\n\t\t\t// Non pixel value, then force offset/clientWidth\n\t\t\tif (h.indexOf('px') === -1)\n\t\t\t\th = 0;\n\n\t\t\treturn {\n\t\t\t\tw : parseInt(w) || e.offsetWidth || e.clientWidth,\n\t\t\t\th : parseInt(h) || e.offsetHeight || e.clientHeight\n\t\t\t};\n\t\t},\n\n\t\tgetParent : function(n, f, r) {\n\t\t\treturn this.getParents(n, f, r, false);\n\t\t},\n\n\t\tgetParents : function(n, f, r, c) {\n\t\t\tvar t = this, na, se = t.settings, o = [];\n\n\t\t\tn = t.get(n);\n\t\t\tc = c === undefined;\n\n\t\t\tif (se.strict_root)\n\t\t\t\tr = r || t.getRoot();\n\n\t\t\t// Wrap node name as func\n\t\t\tif (is(f, 'string')) {\n\t\t\t\tna = f;\n\n\t\t\t\tif (f === '*') {\n\t\t\t\t\tf = function(n) {return n.nodeType == 1;};\n\t\t\t\t} else {\n\t\t\t\t\tf = function(n) {\n\t\t\t\t\t\treturn t.is(n, na);\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t}\n\n\t\t\twhile (n) {\n\t\t\t\tif (n == r || !n.nodeType || n.nodeType === 9)\n\t\t\t\t\tbreak;\n\n\t\t\t\tif (!f || f(n)) {\n\t\t\t\t\tif (c)\n\t\t\t\t\t\to.push(n);\n\t\t\t\t\telse\n\t\t\t\t\t\treturn n;\n\t\t\t\t}\n\n\t\t\t\tn = n.parentNode;\n\t\t\t}\n\n\t\t\treturn c ? o : null;\n\t\t},\n\n\t\tget : function(e) {\n\t\t\tvar n;\n\n\t\t\tif (e && this.doc && typeof(e) == 'string') {\n\t\t\t\tn = e;\n\t\t\t\te = this.doc.getElementById(e);\n\n\t\t\t\t// IE and Opera returns meta elements when they match the specified input ID, but getElementsByName seems to do the trick\n\t\t\t\tif (e && e.id !== n)\n\t\t\t\t\treturn this.doc.getElementsByName(n)[1];\n\t\t\t}\n\n\t\t\treturn e;\n\t\t},\n\n\t\tgetNext : function(node, selector) {\n\t\t\treturn this._findSib(node, selector, 'nextSibling');\n\t\t},\n\n\t\tgetPrev : function(node, selector) {\n\t\t\treturn this._findSib(node, selector, 'previousSibling');\n\t\t},\n\n\n\t\tselect : function(pa, s) {\n\t\t\tvar t = this;\n\n\t\t\treturn tinymce.dom.Sizzle(pa, t.get(s) || t.get(t.settings.root_element) || t.doc, []);\n\t\t},\n\n\t\tis : function(n, selector) {\n\t\t\tvar i;\n\n\t\t\t// If it isn't an array then try to do some simple selectors instead of Sizzle for to boost performance\n\t\t\tif (n.length === undefined) {\n\t\t\t\t// Simple all selector\n\t\t\t\tif (selector === '*')\n\t\t\t\t\treturn n.nodeType == 1;\n\n\t\t\t\t// Simple selector just elements\n\t\t\t\tif (simpleSelectorRe.test(selector)) {\n\t\t\t\t\tselector = selector.toLowerCase().split(/,/);\n\t\t\t\t\tn = n.nodeName.toLowerCase();\n\n\t\t\t\t\tfor (i = selector.length - 1; i >= 0; i--) {\n\t\t\t\t\t\tif (selector[i] == n)\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn tinymce.dom.Sizzle.matches(selector, n.nodeType ? [n] : n).length > 0;\n\t\t},\n\n\n\t\tadd : function(p, n, a, h, c) {\n\t\t\tvar t = this;\n\n\t\t\treturn this.run(p, function(p) {\n\t\t\t\tvar e, k;\n\n\t\t\t\te = is(n, 'string') ? t.doc.createElement(n) : n;\n\t\t\t\tt.setAttribs(e, a);\n\n\t\t\t\tif (h) {\n\t\t\t\t\tif (h.nodeType)\n\t\t\t\t\t\te.appendChild(h);\n\t\t\t\t\telse\n\t\t\t\t\t\tt.setHTML(e, h);\n\t\t\t\t}\n\n\t\t\t\treturn !c ? p.appendChild(e) : e;\n\t\t\t});\n\t\t},\n\n\t\tcreate : function(n, a, h) {\n\t\t\treturn this.add(this.doc.createElement(n), n, a, h, 1);\n\t\t},\n\n\t\tcreateHTML : function(n, a, h) {\n\t\t\tvar o = '', t = this, k;\n\n\t\t\to += '<' + n;\n\n\t\t\tfor (k in a) {\n\t\t\t\tif (a.hasOwnProperty(k))\n\t\t\t\t\to += ' ' + k + '=\"' + t.encode(a[k]) + '\"';\n\t\t\t}\n\n\t\t\t// A call to tinymce.is doesn't work for some odd reason on IE9 possible bug inside their JS runtime\n\t\t\tif (typeof(h) != \"undefined\")\n\t\t\t\treturn o + '>' + h + '</' + n + '>';\n\n\t\t\treturn o + ' />';\n\t\t},\n\n\t\tremove : function(node, keep_children) {\n\t\t\treturn this.run(node, function(node) {\n\t\t\t\tvar child, parent = node.parentNode;\n\n\t\t\t\tif (!parent)\n\t\t\t\t\treturn null;\n\n\t\t\t\tif (keep_children) {\n\t\t\t\t\twhile (child = node.firstChild) {\n\t\t\t\t\t\t// IE 8 will crash if you don't remove completely empty text nodes\n\t\t\t\t\t\tif (!tinymce.isIE || child.nodeType !== 3 || child.nodeValue)\n\t\t\t\t\t\t\tparent.insertBefore(child, node);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tnode.removeChild(child);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn parent.removeChild(node);\n\t\t\t});\n\t\t},\n\n\t\tsetStyle : function(n, na, v) {\n\t\t\tvar t = this;\n\n\t\t\treturn t.run(n, function(e) {\n\t\t\t\tvar s, i;\n\n\t\t\t\ts = e.style;\n\n\t\t\t\t// Camelcase it, if needed\n\t\t\t\tna = na.replace(/-(\\D)/g, function(a, b){\n\t\t\t\t\treturn b.toUpperCase();\n\t\t\t\t});\n\n\t\t\t\t// Default px suffix on these\n\t\t\t\tif (t.pixelStyles.test(na) && (tinymce.is(v, 'number') || /^[\\-0-9\\.]+$/.test(v)))\n\t\t\t\t\tv += 'px';\n\n\t\t\t\tswitch (na) {\n\t\t\t\t\tcase 'opacity':\n\t\t\t\t\t\t// IE specific opacity\n\t\t\t\t\t\tif (isIE) {\n\t\t\t\t\t\t\ts.filter = v === '' ? '' : \"alpha(opacity=\" + (v * 100) + \")\";\n\n\t\t\t\t\t\t\tif (!n.currentStyle || !n.currentStyle.hasLayout)\n\t\t\t\t\t\t\t\ts.display = 'inline-block';\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Fix for older browsers\n\t\t\t\t\t\ts[na] = s['-moz-opacity'] = s['-khtml-opacity'] = v || '';\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'float':\n\t\t\t\t\t\tisIE ? s.styleFloat = v : s.cssFloat = v;\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tdefault:\n\t\t\t\t\t\ts[na] = v || '';\n\t\t\t\t}\n\n\t\t\t\t// Force update of the style data\n\t\t\t\tif (t.settings.update_styles)\n\t\t\t\t\tt.setAttrib(e, 'data-mce-style');\n\t\t\t});\n\t\t},\n\n\t\tgetStyle : function(n, na, c) {\n\t\t\tn = this.get(n);\n\n\t\t\tif (!n)\n\t\t\t\treturn;\n\n\t\t\t// Gecko\n\t\t\tif (this.doc.defaultView && c) {\n\t\t\t\t// Remove camelcase\n\t\t\t\tna = na.replace(/[A-Z]/g, function(a){\n\t\t\t\t\treturn '-' + a;\n\t\t\t\t});\n\n\t\t\t\ttry {\n\t\t\t\t\treturn this.doc.defaultView.getComputedStyle(n, null).getPropertyValue(na);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Old safari might fail\n\t\t\t\t\treturn null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Camelcase it, if needed\n\t\t\tna = na.replace(/-(\\D)/g, function(a, b){\n\t\t\t\treturn b.toUpperCase();\n\t\t\t});\n\n\t\t\tif (na == 'float')\n\t\t\t\tna = isIE ? 'styleFloat' : 'cssFloat';\n\n\t\t\t// IE & Opera\n\t\t\tif (n.currentStyle && c)\n\t\t\t\treturn n.currentStyle[na];\n\n\t\t\treturn n.style ? n.style[na] : undefined;\n\t\t},\n\n\t\tsetStyles : function(e, o) {\n\t\t\tvar t = this, s = t.settings, ol;\n\n\t\t\tol = s.update_styles;\n\t\t\ts.update_styles = 0;\n\n\t\t\teach(o, function(v, n) {\n\t\t\t\tt.setStyle(e, n, v);\n\t\t\t});\n\n\t\t\t// Update style info\n\t\t\ts.update_styles = ol;\n\t\t\tif (s.update_styles)\n\t\t\t\tt.setAttrib(e, s.cssText);\n\t\t},\n\n\t\tremoveAllAttribs: function(e) {\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\tvar i, attrs = e.attributes;\n\t\t\t\tfor (i = attrs.length - 1; i >= 0; i--) {\n\t\t\t\t\te.removeAttributeNode(attrs.item(i));\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\tsetAttrib : function(e, n, v) {\n\t\t\tvar t = this;\n\n\t\t\t// Whats the point\n\t\t\tif (!e || !n)\n\t\t\t\treturn;\n\n\t\t\t// Strict XML mode\n\t\t\tif (t.settings.strict)\n\t\t\t\tn = n.toLowerCase();\n\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\tvar s = t.settings;\n\t\t\t\tif (v !== null) {\n\t\t\t\t\tswitch (n) {\n\t\t\t\t\t\tcase \"style\":\n\t\t\t\t\t\t\tif (!is(v, 'string')) {\n\t\t\t\t\t\t\t\teach(v, function(v, n) {\n\t\t\t\t\t\t\t\t\tt.setStyle(e, n, v);\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// No mce_style for elements with these since they might get resized by the user\n\t\t\t\t\t\t\tif (s.keep_values) {\n\t\t\t\t\t\t\t\tif (v && !t._isRes(v))\n\t\t\t\t\t\t\t\t\te.setAttribute('data-mce-style', v, 2);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\te.removeAttribute('data-mce-style', 2);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\te.style.cssText = v;\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase \"class\":\n\t\t\t\t\t\t\te.className = v || ''; // Fix IE null bug\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase \"src\":\n\t\t\t\t\t\tcase \"href\":\n\t\t\t\t\t\t\tif (s.keep_values) {\n\t\t\t\t\t\t\t\tif (s.url_converter)\n\t\t\t\t\t\t\t\t\tv = s.url_converter.call(s.url_converter_scope || t, v, n, e);\n\n\t\t\t\t\t\t\t\tt.setAttrib(e, 'data-mce-' + n, v, 2);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase \"shape\":\n\t\t\t\t\t\t\te.setAttribute('data-mce-style', v);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif (is(v) && v !== null && v.length !== 0)\n\t\t\t\t\te.setAttribute(n, '' + v, 2);\n\t\t\t\telse\n\t\t\t\t\te.removeAttribute(n, 2);\n\t\t\t});\n\t\t},\n\n\t\tsetAttribs : function(e, o) {\n\t\t\tvar t = this;\n\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\teach(o, function(v, n) {\n\t\t\t\t\tt.setAttrib(e, n, v);\n\t\t\t\t});\n\t\t\t});\n\t\t},\n\n\t\tgetAttrib : function(e, n, dv) {\n\t\t\tvar v, t = this, undef;\n\n\t\t\te = t.get(e);\n\n\t\t\tif (!e || e.nodeType !== 1)\n\t\t\t\treturn dv === undef ? false : dv;\n\n\t\t\tif (!is(dv))\n\t\t\t\tdv = '';\n\n\t\t\t// Try the mce variant for these\n\t\t\tif (/^(src|href|style|coords|shape)$/.test(n)) {\n\t\t\t\tv = e.getAttribute(\"data-mce-\" + n);\n\n\t\t\t\tif (v)\n\t\t\t\t\treturn v;\n\t\t\t}\n\n\t\t\tif (isIE && t.props[n]) {\n\t\t\t\tv = e[t.props[n]];\n\t\t\t\tv = v && v.nodeValue ? v.nodeValue : v;\n\t\t\t}\n\n\t\t\tif (!v)\n\t\t\t\tv = e.getAttribute(n, 2);\n\n\t\t\t// Check boolean attribs\n\t\t\tif (/^(checked|compact|declare|defer|disabled|ismap|multiple|nohref|noshade|nowrap|readonly|selected)$/.test(n)) {\n\t\t\t\tif (e[t.props[n]] === true && v === '')\n\t\t\t\t\treturn n;\n\n\t\t\t\treturn v ? n : '';\n\t\t\t}\n\n\t\t\t// Inner input elements will override attributes on form elements\n\t\t\tif (e.nodeName === \"FORM\" && e.getAttributeNode(n))\n\t\t\t\treturn e.getAttributeNode(n).nodeValue;\n\n\t\t\tif (n === 'style') {\n\t\t\t\tv = v || e.style.cssText;\n\n\t\t\t\tif (v) {\n\t\t\t\t\tv = t.serializeStyle(t.parseStyle(v), e.nodeName);\n\n\t\t\t\t\tif (t.settings.keep_values && !t._isRes(v))\n\t\t\t\t\t\te.setAttribute('data-mce-style', v);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Remove Apple and WebKit stuff\n\t\t\tif (isWebKit && n === \"class\" && v)\n\t\t\t\tv = v.replace(/(apple|webkit)\\-[a-z\\-]+/gi, '');\n\n\t\t\t// Handle IE issues\n\t\t\tif (isIE) {\n\t\t\t\tswitch (n) {\n\t\t\t\t\tcase 'rowspan':\n\t\t\t\t\tcase 'colspan':\n\t\t\t\t\t\t// IE returns 1 as default value\n\t\t\t\t\t\tif (v === 1)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'size':\n\t\t\t\t\t\t// IE returns +0 as default value for size\n\t\t\t\t\t\tif (v === '+0' || v === 20 || v === 0)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'width':\n\t\t\t\t\tcase 'height':\n\t\t\t\t\tcase 'vspace':\n\t\t\t\t\tcase 'checked':\n\t\t\t\t\tcase 'disabled':\n\t\t\t\t\tcase 'readonly':\n\t\t\t\t\t\tif (v === 0)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'hspace':\n\t\t\t\t\t\t// IE returns -1 as default value\n\t\t\t\t\t\tif (v === -1)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'maxlength':\n\t\t\t\t\tcase 'tabindex':\n\t\t\t\t\t\t// IE returns default value\n\t\t\t\t\t\tif (v === 32768 || v === 2147483647 || v === '32768')\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'multiple':\n\t\t\t\t\tcase 'compact':\n\t\t\t\t\tcase 'noshade':\n\t\t\t\t\tcase 'nowrap':\n\t\t\t\t\t\tif (v === 65535)\n\t\t\t\t\t\t\treturn n;\n\n\t\t\t\t\t\treturn dv;\n\n\t\t\t\t\tcase 'shape':\n\t\t\t\t\t\tv = v.toLowerCase();\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tdefault:\n\t\t\t\t\t\t// IE has odd anonymous function for event attributes\n\t\t\t\t\t\tif (n.indexOf('on') === 0 && v)\n\t\t\t\t\t\t\tv = tinymce._replace(/^function\\s+\\w+\\(\\)\\s+\\{\\s+(.*)\\s+\\}$/, '$1', '' + v);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn (v !== undef && v !== null && v !== '') ? '' + v : dv;\n\t\t},\n\n\t\tgetPos : function(n, ro) {\n\t\t\tvar t = this, x = 0, y = 0, e, d = t.doc, r;\n\n\t\t\tn = t.get(n);\n\t\t\tro = ro || d.body;\n\n\t\t\tif (n) {\n\t\t\t\t// Use getBoundingClientRect if it exists since it's faster than looping offset nodes\n\t\t\t\tif (n.getBoundingClientRect) {\n\t\t\t\t\tn = n.getBoundingClientRect();\n\t\t\t\t\te = t.boxModel ? d.documentElement : d.body;\n\n\t\t\t\t\t// Add scroll offsets from documentElement or body since IE with the wrong box model will use d.body and so do WebKit\n\t\t\t\t\t// Also remove the body/documentelement clientTop/clientLeft on IE 6, 7 since they offset the position\n\t\t\t\t\tx = n.left + (d.documentElement.scrollLeft || d.body.scrollLeft) - e.clientTop;\n\t\t\t\t\ty = n.top + (d.documentElement.scrollTop || d.body.scrollTop) - e.clientLeft;\n\n\t\t\t\t\treturn {x : x, y : y};\n\t\t\t\t}\n\n\t\t\t\tr = n;\n\t\t\t\twhile (r && r != ro && r.nodeType) {\n\t\t\t\t\tx += r.offsetLeft || 0;\n\t\t\t\t\ty += r.offsetTop || 0;\n\t\t\t\t\tr = r.offsetParent;\n\t\t\t\t}\n\n\t\t\t\tr = n.parentNode;\n\t\t\t\twhile (r && r != ro && r.nodeType) {\n\t\t\t\t\tx -= r.scrollLeft || 0;\n\t\t\t\t\ty -= r.scrollTop || 0;\n\t\t\t\t\tr = r.parentNode;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn {x : x, y : y};\n\t\t},\n\n\t\tparseStyle : function(st) {\n\t\t\treturn this.styles.parse(st);\n\t\t},\n\n\t\tserializeStyle : function(o, name) {\n\t\t\treturn this.styles.serialize(o, name);\n\t\t},\n\n\t\tloadCSS : function(u) {\n\t\t\tvar t = this, d = t.doc, head;\n\n\t\t\tif (!u)\n\t\t\t\tu = '';\n\n\t\t\thead = t.select('head')[0];\n\n\t\t\teach(u.split(','), function(u) {\n\t\t\t\tvar link;\n\n\t\t\t\tif (t.files[u])\n\t\t\t\t\treturn;\n\n\t\t\t\tt.files[u] = true;\n\t\t\t\tlink = t.create('link', {rel : 'stylesheet', href : tinymce._addVer(u)});\n\n\t\t\t\t// IE 8 has a bug where dynamically loading stylesheets would produce a 1 item remaining bug\n\t\t\t\t// This fix seems to resolve that issue by realcing the document ones a stylesheet finishes loading\n\t\t\t\t// It's ugly but it seems to work fine.\n\t\t\t\tif (isIE && d.documentMode && d.recalc) {\n\t\t\t\t\tlink.onload = function() {\n\t\t\t\t\t\tif (d.recalc)\n\t\t\t\t\t\t\td.recalc();\n\n\t\t\t\t\t\tlink.onload = null;\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\thead.appendChild(link);\n\t\t\t});\n\t\t},\n\n\t\taddClass : function(e, c) {\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\tvar o;\n\n\t\t\t\tif (!c)\n\t\t\t\t\treturn 0;\n\n\t\t\t\tif (this.hasClass(e, c))\n\t\t\t\t\treturn e.className;\n\n\t\t\t\to = this.removeClass(e, c);\n\n\t\t\t\treturn e.className = (o != '' ? (o + ' ') : '') + c;\n\t\t\t});\n\t\t},\n\n\t\tremoveClass : function(e, c) {\n\t\t\tvar t = this, re;\n\n\t\t\treturn t.run(e, function(e) {\n\t\t\t\tvar v;\n\n\t\t\t\tif (t.hasClass(e, c)) {\n\t\t\t\t\tif (!re)\n\t\t\t\t\t\tre = new RegExp(\"(^|\\\\s+)\" + c + \"(\\\\s+|$)\", \"g\");\n\n\t\t\t\t\tv = e.className.replace(re, ' ');\n\t\t\t\t\tv = tinymce.trim(v != ' ' ? v : '');\n\n\t\t\t\t\te.className = v;\n\n\t\t\t\t\t// Empty class attr\n\t\t\t\t\tif (!v) {\n\t\t\t\t\t\te.removeAttribute('class');\n\t\t\t\t\t\te.removeAttribute('className');\n\t\t\t\t\t}\n\n\t\t\t\t\treturn v;\n\t\t\t\t}\n\n\t\t\t\treturn e.className;\n\t\t\t});\n\t\t},\n\n\t\thasClass : function(n, c) {\n\t\t\tn = this.get(n);\n\n\t\t\tif (!n || !c)\n\t\t\t\treturn false;\n\n\t\t\treturn (' ' + n.className + ' ').indexOf(' ' + c + ' ') !== -1;\n\t\t},\n\n\t\tshow : function(e) {\n\t\t\treturn this.setStyle(e, 'display', 'block');\n\t\t},\n\n\t\thide : function(e) {\n\t\t\treturn this.setStyle(e, 'display', 'none');\n\t\t},\n\n\t\tisHidden : function(e) {\n\t\t\te = this.get(e);\n\n\t\t\treturn !e || e.style.display == 'none' || this.getStyle(e, 'display') == 'none';\n\t\t},\n\n\t\tuniqueId : function(p) {\n\t\t\treturn (!p ? 'mce_' : p) + (this.counter++);\n\t\t},\n\n\t\tsetHTML : function(element, html) {\n\t\t\tvar self = this;\n\n\t\t\treturn self.run(element, function(element) {\n\t\t\t\tif (isIE) {\n\t\t\t\t\t// Remove all child nodes, IE keeps empty text nodes in DOM\n\t\t\t\t\twhile (element.firstChild)\n\t\t\t\t\t\telement.removeChild(element.firstChild);\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\t// IE will remove comments from the beginning\n\t\t\t\t\t\t// unless you padd the contents with something\n\t\t\t\t\t\telement.innerHTML = '<br />' + html;\n\t\t\t\t\t\telement.removeChild(element.firstChild);\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// IE sometimes produces an unknown runtime error on innerHTML if it's an block element within a block element for example a div inside a p\n\t\t\t\t\t\t// This seems to fix this problem\n\n\t\t\t\t\t\t// Create new div with HTML contents and a BR infront to keep comments\n\t\t\t\t\t\telement = self.create('div');\n\t\t\t\t\t\telement.innerHTML = '<br />' + html;\n\n\t\t\t\t\t\t// Add all children from div to target\n\t\t\t\t\t\teach (element.childNodes, function(node, i) {\n\t\t\t\t\t\t\t// Skip br element\n\t\t\t\t\t\t\tif (i)\n\t\t\t\t\t\t\t\telement.appendChild(node);\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t} else\n\t\t\t\t\telement.innerHTML = html;\n\n\t\t\t\treturn html;\n\t\t\t});\n\t\t},\n\n\t\tgetOuterHTML : function(elm) {\n\t\t\tvar doc, self = this;\n\n\t\t\telm = self.get(elm);\n\n\t\t\tif (!elm)\n\t\t\t\treturn null;\n\n\t\t\tif (elm.nodeType === 1 && self.hasOuterHTML)\n\t\t\t\treturn elm.outerHTML;\n\n\t\t\tdoc = (elm.ownerDocument || self.doc).createElement(\"body\");\n\t\t\tdoc.appendChild(elm.cloneNode(true));\n\n\t\t\treturn doc.innerHTML;\n\t\t},\n\n\t\tsetOuterHTML : function(e, h, d) {\n\t\t\tvar t = this;\n\n\t\t\tfunction setHTML(e, h, d) {\n\t\t\t\tvar n, tp;\n\n\t\t\t\ttp = d.createElement(\"body\");\n\t\t\t\ttp.innerHTML = h;\n\n\t\t\t\tn = tp.lastChild;\n\t\t\t\twhile (n) {\n\t\t\t\t\tt.insertAfter(n.cloneNode(true), e);\n\t\t\t\t\tn = n.previousSibling;\n\t\t\t\t}\n\n\t\t\t\tt.remove(e);\n\t\t\t};\n\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\te = t.get(e);\n\n\t\t\t\t// Only set HTML on elements\n\t\t\t\tif (e.nodeType == 1) {\n\t\t\t\t\td = d || e.ownerDocument || t.doc;\n\n\t\t\t\t\tif (isIE) {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t// Try outerHTML for IE it sometimes produces an unknown runtime error\n\t\t\t\t\t\t\tif (isIE && e.nodeType == 1)\n\t\t\t\t\t\t\t\te.outerHTML = h;\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tsetHTML(e, h, d);\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\t// Fix for unknown runtime error\n\t\t\t\t\t\t\tsetHTML(e, h, d);\n\t\t\t\t\t\t}\n\t\t\t\t\t} else\n\t\t\t\t\t\tsetHTML(e, h, d);\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\tdecode : Entities.decode,\n\n\t\tencode : Entities.encodeAllRaw,\n\n\t\tinsertAfter : function(node, reference_node) {\n\t\t\treference_node = this.get(reference_node);\n\n\t\t\treturn this.run(node, function(node) {\n\t\t\t\tvar parent, nextSibling;\n\n\t\t\t\tparent = reference_node.parentNode;\n\t\t\t\tnextSibling = reference_node.nextSibling;\n\n\t\t\t\tif (nextSibling)\n\t\t\t\t\tparent.insertBefore(node, nextSibling);\n\t\t\t\telse\n\t\t\t\t\tparent.appendChild(node);\n\n\t\t\t\treturn node;\n\t\t\t});\n\t\t},\n\n\t\tisBlock : function(node) {\n\t\t\tvar type = node.nodeType;\n\n\t\t\t// If it's a node then check the type and use the nodeName\n\t\t\tif (type)\n\t\t\t\treturn !!(type === 1 && blockElementsMap[node.nodeName]);\n\n\t\t\treturn !!blockElementsMap[node];\n\t\t},\n\n\t\treplace : function(n, o, k) {\n\t\t\tvar t = this;\n\n\t\t\tif (is(o, 'array'))\n\t\t\t\tn = n.cloneNode(true);\n\n\t\t\treturn t.run(o, function(o) {\n\t\t\t\tif (k) {\n\t\t\t\t\teach(tinymce.grep(o.childNodes), function(c) {\n\t\t\t\t\t\tn.appendChild(c);\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\treturn o.parentNode.replaceChild(n, o);\n\t\t\t});\n\t\t},\n\n\t\trename : function(elm, name) {\n\t\t\tvar t = this, newElm;\n\n\t\t\tif (elm.nodeName != name.toUpperCase()) {\n\t\t\t\t// Rename block element\n\t\t\t\tnewElm = t.create(name);\n\n\t\t\t\t// Copy attribs to new block\n\t\t\t\teach(t.getAttribs(elm), function(attr_node) {\n\t\t\t\t\tt.setAttrib(newElm, attr_node.nodeName, t.getAttrib(elm, attr_node.nodeName));\n\t\t\t\t});\n\n\t\t\t\t// Replace block\n\t\t\t\tt.replace(newElm, elm, 1);\n\t\t\t}\n\n\t\t\treturn newElm || elm;\n\t\t},\n\n\t\tfindCommonAncestor : function(a, b) {\n\t\t\tvar ps = a, pe;\n\n\t\t\twhile (ps) {\n\t\t\t\tpe = b;\n\n\t\t\t\twhile (pe && ps != pe)\n\t\t\t\t\tpe = pe.parentNode;\n\n\t\t\t\tif (ps == pe)\n\t\t\t\t\tbreak;\n\n\t\t\t\tps = ps.parentNode;\n\t\t\t}\n\n\t\t\tif (!ps && a.ownerDocument)\n\t\t\t\treturn a.ownerDocument.documentElement;\n\n\t\t\treturn ps;\n\t\t},\n\n\t\ttoHex : function(s) {\n\t\t\tvar c = /^\\s*rgb\\s*?\\(\\s*?([0-9]+)\\s*?,\\s*?([0-9]+)\\s*?,\\s*?([0-9]+)\\s*?\\)\\s*$/i.exec(s);\n\n\t\t\tfunction hex(s) {\n\t\t\t\ts = parseInt(s).toString(16);\n\n\t\t\t\treturn s.length > 1 ? s : '0' + s; // 0 -> 00\n\t\t\t};\n\n\t\t\tif (c) {\n\t\t\t\ts = '#' + hex(c[1]) + hex(c[2]) + hex(c[3]);\n\n\t\t\t\treturn s;\n\t\t\t}\n\n\t\t\treturn s;\n\t\t},\n\n\t\tgetClasses : function() {\n\t\t\tvar t = this, cl = [], i, lo = {}, f = t.settings.class_filter, ov;\n\n\t\t\tif (t.classes)\n\t\t\t\treturn t.classes;\n\n\t\t\tfunction addClasses(s) {\n\t\t\t\t// IE style imports\n\t\t\t\teach(s.imports, function(r) {\n\t\t\t\t\taddClasses(r);\n\t\t\t\t});\n\n\t\t\t\teach(s.cssRules || s.rules, function(r) {\n\t\t\t\t\t// Real type or fake it on IE\n\t\t\t\t\tswitch (r.type || 1) {\n\t\t\t\t\t\t// Rule\n\t\t\t\t\t\tcase 1:\n\t\t\t\t\t\t\tif (r.selectorText) {\n\t\t\t\t\t\t\t\teach(r.selectorText.split(','), function(v) {\n\t\t\t\t\t\t\t\t\tv = v.replace(/^\\s*|\\s*$|^\\s\\./g, \"\");\n\n\t\t\t\t\t\t\t\t\t// Is internal or it doesn't contain a class\n\t\t\t\t\t\t\t\t\tif (/\\.mce/.test(v) || !/\\.[\\w\\-]+$/.test(v))\n\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t// Remove everything but class name\n\t\t\t\t\t\t\t\t\tov = v;\n\t\t\t\t\t\t\t\t\tv = tinymce._replace(/.*\\.([a-z0-9_\\-]+).*/i, '$1', v);\n\n\t\t\t\t\t\t\t\t\t// Filter classes\n\t\t\t\t\t\t\t\t\tif (f && !(v = f(v, ov)))\n\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\tif (!lo[v]) {\n\t\t\t\t\t\t\t\t\t\tcl.push({'class' : v});\n\t\t\t\t\t\t\t\t\t\tlo[v] = 1;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\t// Import\n\t\t\t\t\t\tcase 3:\n\t\t\t\t\t\t\taddClasses(r.styleSheet);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t};\n\n\t\t\ttry {\n\t\t\t\teach(t.doc.styleSheets, addClasses);\n\t\t\t} catch (ex) {\n\t\t\t\t// Ignore\n\t\t\t}\n\n\t\t\tif (cl.length > 0)\n\t\t\t\tt.classes = cl;\n\n\t\t\treturn cl;\n\t\t},\n\n\t\trun : function(e, f, s) {\n\t\t\tvar t = this, o;\n\n\t\t\tif (t.doc && typeof(e) === 'string')\n\t\t\t\te = t.get(e);\n\n\t\t\tif (!e)\n\t\t\t\treturn false;\n\n\t\t\ts = s || this;\n\t\t\tif (!e.nodeType && (e.length || e.length === 0)) {\n\t\t\t\to = [];\n\n\t\t\t\teach(e, function(e, i) {\n\t\t\t\t\tif (e) {\n\t\t\t\t\t\tif (typeof(e) == 'string')\n\t\t\t\t\t\t\te = t.doc.getElementById(e);\n\n\t\t\t\t\t\to.push(f.call(s, e, i));\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\treturn o;\n\t\t\t}\n\n\t\t\treturn f.call(s, e);\n\t\t},\n\n\t\tgetAttribs : function(n) {\n\t\t\tvar o;\n\n\t\t\tn = this.get(n);\n\n\t\t\tif (!n)\n\t\t\t\treturn [];\n\n\t\t\tif (isIE) {\n\t\t\t\to = [];\n\n\t\t\t\t// Object will throw exception in IE\n\t\t\t\tif (n.nodeName == 'OBJECT')\n\t\t\t\t\treturn n.attributes;\n\n\t\t\t\t// IE doesn't keep the selected attribute if you clone option elements\n\t\t\t\tif (n.nodeName === 'OPTION' && this.getAttrib(n, 'selected'))\n\t\t\t\t\to.push({specified : 1, nodeName : 'selected'});\n\n\t\t\t\t// It's crazy that this is faster in IE but it's because it returns all attributes all the time\n\t\t\t\tn.cloneNode(false).outerHTML.replace(/<\\/?[\\w:\\-]+ ?|=[\\\"][^\\\"]+\\\"|=\\'[^\\']+\\'|=[\\w\\-]+|>/gi, '').replace(/[\\w:\\-]+/gi, function(a) {\n\t\t\t\t\to.push({specified : 1, nodeName : a});\n\t\t\t\t});\n\n\t\t\t\treturn o;\n\t\t\t}\n\n\t\t\treturn n.attributes;\n\t\t},\n\n\t\tisEmpty : function(node, elements) {\n\t\t\tvar self = this, i, attributes, type, walker, name, parentNode;\n\n\t\t\tnode = node.firstChild;\n\t\t\tif (node) {\n\t\t\t\twalker = new tinymce.dom.TreeWalker(node);\n\t\t\t\telements = elements || self.schema ? self.schema.getNonEmptyElements() : null;\n\n\t\t\t\tdo {\n\t\t\t\t\ttype = node.nodeType;\n\n\t\t\t\t\tif (type === 1) {\n\t\t\t\t\t\t// Ignore bogus elements\n\t\t\t\t\t\tif (node.getAttribute('data-mce-bogus'))\n\t\t\t\t\t\t\tcontinue;\n\n\t\t\t\t\t\t// Keep empty elements like <img />\n\t\t\t\t\t\tname = node.nodeName.toLowerCase();\n\t\t\t\t\t\tif (elements && elements[name]) {\n\t\t\t\t\t\t\t// Ignore single BR elements in blocks like <p><br /></p>\n\t\t\t\t\t\t\tparentNode = node.parentNode;\n\t\t\t\t\t\t\tif (name === 'br' && self.isBlock(parentNode) && parentNode.firstChild === node && parentNode.lastChild === node) {\n\t\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Keep elements with data-bookmark attributes or name attribute like <a name=\"1\"></a>\n\t\t\t\t\t\tattributes = self.getAttribs(node);\n\t\t\t\t\t\ti = node.attributes.length;\n\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\tname = node.attributes[i].nodeName;\n\t\t\t\t\t\t\tif (name === \"name\" || name === 'data-mce-bookmark')\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Keep non whitespace text nodes\n\t\t\t\t\tif ((type === 3 && !whiteSpaceRegExp.test(node.nodeValue)))\n\t\t\t\t\t\treturn false;\n\t\t\t\t} while (node = walker.next());\n\t\t\t}\n\n\t\t\treturn true;\n\t\t},\n\n\t\tdestroy : function(s) {\n\t\t\tvar t = this;\n\n\t\t\tif (t.events)\n\t\t\t\tt.events.destroy();\n\n\t\t\tt.win = t.doc = t.root = t.events = null;\n\n\t\t\t// Manual destroy then remove unload handler\n\t\t\tif (!s)\n\t\t\t\ttinymce.removeUnload(t.destroy);\n\t\t},\n\n\t\tcreateRng : function() {\n\t\t\tvar d = this.doc;\n\n\t\t\treturn d.createRange ? d.createRange() : new tinymce.dom.Range(this);\n\t\t},\n\n\t\tnodeIndex : function(node, normalized) {\n\t\t\tvar idx = 0, lastNodeType, lastNode, nodeType;\n\n\t\t\tif (node) {\n\t\t\t\tfor (lastNodeType = node.nodeType, node = node.previousSibling, lastNode = node; node; node = node.previousSibling) {\n\t\t\t\t\tnodeType = node.nodeType;\n\n\t\t\t\t\t// Normalize text nodes\n\t\t\t\t\tif (normalized && nodeType == 3) {\n\t\t\t\t\t\tif (nodeType == lastNodeType || !node.nodeValue.length)\n\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\t\t\t\t\tidx++;\n\t\t\t\t\tlastNodeType = nodeType;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn idx;\n\t\t},\n\n\t\tsplit : function(pe, e, re) {\n\t\t\tvar t = this, r = t.createRng(), bef, aft, pa;\n\n\t\t\t// W3C valid browsers tend to leave empty nodes to the left/right side of the contents, this makes sense\n\t\t\t// but we don't want that in our code since it serves no purpose for the end user\n\t\t\t// For example if this is chopped:\n\t\t\t//   <p>text 1<span><b>CHOP</b></span>text 2</p>\n\t\t\t// would produce:\n\t\t\t//   <p>text 1<span></span></p><b>CHOP</b><p><span></span>text 2</p>\n\t\t\t// this function will then trim of empty edges and produce:\n\t\t\t//   <p>text 1</p><b>CHOP</b><p>text 2</p>\n\t\t\tfunction trim(node) {\n\t\t\t\tvar i, children = node.childNodes, type = node.nodeType;\n\n\t\t\t\tif (type == 1 && node.getAttribute('data-mce-type') == 'bookmark')\n\t\t\t\t\treturn;\n\n\t\t\t\tfor (i = children.length - 1; i >= 0; i--)\n\t\t\t\t\ttrim(children[i]);\n\n\t\t\t\tif (type != 9) {\n\t\t\t\t\t// Keep non whitespace text nodes\n\t\t\t\t\tif (type == 3 && node.nodeValue.length > 0) {\n\t\t\t\t\t\t// If parent element isn't a block or there isn't any useful contents for example \"<p>   </p>\"\n\t\t\t\t\t\tif (!t.isBlock(node.parentNode) || tinymce.trim(node.nodeValue).length > 0)\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t} else if (type == 1) {\n\t\t\t\t\t\t// If the only child is a bookmark then move it up\n\t\t\t\t\t\tchildren = node.childNodes;\n\t\t\t\t\t\tif (children.length == 1 && children[0] && children[0].nodeType == 1 && children[0].getAttribute('data-mce-type') == 'bookmark')\n\t\t\t\t\t\t\tnode.parentNode.insertBefore(children[0], node);\n\n\t\t\t\t\t\t// Keep non empty elements or img, hr etc\n\t\t\t\t\t\tif (children.length || /^(br|hr|input|img)$/i.test(node.nodeName))\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tt.remove(node);\n\t\t\t\t}\n\n\t\t\t\treturn node;\n\t\t\t};\n\n\t\t\tif (pe && e) {\n\t\t\t\t// Get before chunk\n\t\t\t\tr.setStart(pe.parentNode, t.nodeIndex(pe));\n\t\t\t\tr.setEnd(e.parentNode, t.nodeIndex(e));\n\t\t\t\tbef = r.extractContents();\n\n\t\t\t\t// Get after chunk\n\t\t\t\tr = t.createRng();\n\t\t\t\tr.setStart(e.parentNode, t.nodeIndex(e) + 1);\n\t\t\t\tr.setEnd(pe.parentNode, t.nodeIndex(pe) + 1);\n\t\t\t\taft = r.extractContents();\n\n\t\t\t\t// Insert before chunk\n\t\t\t\tpa = pe.parentNode;\n\t\t\t\tpa.insertBefore(trim(bef), pe);\n\n\t\t\t\t// Insert middle chunk\n\t\t\t\tif (re)\n\t\t\t\t\tpa.replaceChild(re, e);\n\t\t\t\telse\n\t\t\t\t\tpa.insertBefore(e, pe);\n\n\t\t\t\t// Insert after chunk\n\t\t\t\tpa.insertBefore(trim(aft), pe);\n\t\t\t\tt.remove(pe);\n\n\t\t\t\treturn re || e;\n\t\t\t}\n\t\t},\n\n\t\tbind : function(target, name, func, scope) {\n\t\t\tvar t = this;\n\n\t\t\tif (!t.events)\n\t\t\t\tt.events = new tinymce.dom.EventUtils();\n\n\t\t\treturn t.events.add(target, name, func, scope || this);\n\t\t},\n\n\t\tunbind : function(target, name, func) {\n\t\t\tvar t = this;\n\n\t\t\tif (!t.events)\n\t\t\t\tt.events = new tinymce.dom.EventUtils();\n\n\t\t\treturn t.events.remove(target, name, func);\n\t\t},\n\n\n\t\t_findSib : function(node, selector, name) {\n\t\t\tvar t = this, f = selector;\n\n\t\t\tif (node) {\n\t\t\t\t// If expression make a function of it using is\n\t\t\t\tif (is(f, 'string')) {\n\t\t\t\t\tf = function(node) {\n\t\t\t\t\t\treturn t.is(node, selector);\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\t// Loop all siblings\n\t\t\t\tfor (node = node[name]; node; node = node[name]) {\n\t\t\t\t\tif (f(node))\n\t\t\t\t\t\treturn node;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn null;\n\t\t},\n\n\t\t_isRes : function(c) {\n\t\t\t// Is live resizble element\n\t\t\treturn /^(top|left|bottom|right|width|height)/i.test(c) || /;\\s*(top|left|bottom|right|width|height)/i.test(c);\n\t\t}\n\n\t\t/*\n\t\twalk : function(n, f, s) {\n\t\t\tvar d = this.doc, w;\n\n\t\t\tif (d.createTreeWalker) {\n\t\t\t\tw = d.createTreeWalker(n, NodeFilter.SHOW_TEXT, null, false);\n\n\t\t\t\twhile ((n = w.nextNode()) != null)\n\t\t\t\t\tf.call(s || this, n);\n\t\t\t} else\n\t\t\t\ttinymce.walk(n, f, 'childNodes', s);\n\t\t}\n\t\t*/\n\n\t\t/*\n\t\ttoRGB : function(s) {\n\t\t\tvar c = /^\\s*?#([0-9A-F]{2})([0-9A-F]{1,2})([0-9A-F]{2})?\\s*?$/.exec(s);\n\n\t\t\tif (c) {\n\t\t\t\t// #FFF -> #FFFFFF\n\t\t\t\tif (!is(c[3]))\n\t\t\t\t\tc[3] = c[2] = c[1];\n\n\t\t\t\treturn \"rgb(\" + parseInt(c[1], 16) + \",\" + parseInt(c[2], 16) + \",\" + parseInt(c[3], 16) + \")\";\n\t\t\t}\n\n\t\t\treturn s;\n\t\t}\n\t\t*/\n\t});\n\n\ttinymce.DOM = new tinymce.dom.DOMUtils(document, {process_html : 0});\n})(tinymce);\n\n(function(ns) {\n\t// Range constructor\n\tfunction Range(dom) {\n\t\tvar t = this,\n\t\t\tdoc = dom.doc,\n\t\t\tEXTRACT = 0,\n\t\t\tCLONE = 1,\n\t\t\tDELETE = 2,\n\t\t\tTRUE = true,\n\t\t\tFALSE = false,\n\t\t\tSTART_OFFSET = 'startOffset',\n\t\t\tSTART_CONTAINER = 'startContainer',\n\t\t\tEND_CONTAINER = 'endContainer',\n\t\t\tEND_OFFSET = 'endOffset',\n\t\t\textend = tinymce.extend,\n\t\t\tnodeIndex = dom.nodeIndex;\n\n\t\textend(t, {\n\t\t\t// Inital states\n\t\t\tstartContainer : doc,\n\t\t\tstartOffset : 0,\n\t\t\tendContainer : doc,\n\t\t\tendOffset : 0,\n\t\t\tcollapsed : TRUE,\n\t\t\tcommonAncestorContainer : doc,\n\n\t\t\t// Range constants\n\t\t\tSTART_TO_START : 0,\n\t\t\tSTART_TO_END : 1,\n\t\t\tEND_TO_END : 2,\n\t\t\tEND_TO_START : 3,\n\n\t\t\t// Public methods\n\t\t\tsetStart : setStart,\n\t\t\tsetEnd : setEnd,\n\t\t\tsetStartBefore : setStartBefore,\n\t\t\tsetStartAfter : setStartAfter,\n\t\t\tsetEndBefore : setEndBefore,\n\t\t\tsetEndAfter : setEndAfter,\n\t\t\tcollapse : collapse,\n\t\t\tselectNode : selectNode,\n\t\t\tselectNodeContents : selectNodeContents,\n\t\t\tcompareBoundaryPoints : compareBoundaryPoints,\n\t\t\tdeleteContents : deleteContents,\n\t\t\textractContents : extractContents,\n\t\t\tcloneContents : cloneContents,\n\t\t\tinsertNode : insertNode,\n\t\t\tsurroundContents : surroundContents,\n\t\t\tcloneRange : cloneRange\n\t\t});\n\n\t\tfunction setStart(n, o) {\n\t\t\t_setEndPoint(TRUE, n, o);\n\t\t};\n\n\t\tfunction setEnd(n, o) {\n\t\t\t_setEndPoint(FALSE, n, o);\n\t\t};\n\n\t\tfunction setStartBefore(n) {\n\t\t\tsetStart(n.parentNode, nodeIndex(n));\n\t\t};\n\n\t\tfunction setStartAfter(n) {\n\t\t\tsetStart(n.parentNode, nodeIndex(n) + 1);\n\t\t};\n\n\t\tfunction setEndBefore(n) {\n\t\t\tsetEnd(n.parentNode, nodeIndex(n));\n\t\t};\n\n\t\tfunction setEndAfter(n) {\n\t\t\tsetEnd(n.parentNode, nodeIndex(n) + 1);\n\t\t};\n\n\t\tfunction collapse(ts) {\n\t\t\tif (ts) {\n\t\t\t\tt[END_CONTAINER] = t[START_CONTAINER];\n\t\t\t\tt[END_OFFSET] = t[START_OFFSET];\n\t\t\t} else {\n\t\t\t\tt[START_CONTAINER] = t[END_CONTAINER];\n\t\t\t\tt[START_OFFSET] = t[END_OFFSET];\n\t\t\t}\n\n\t\t\tt.collapsed = TRUE;\n\t\t};\n\n\t\tfunction selectNode(n) {\n\t\t\tsetStartBefore(n);\n\t\t\tsetEndAfter(n);\n\t\t};\n\n\t\tfunction selectNodeContents(n) {\n\t\t\tsetStart(n, 0);\n\t\t\tsetEnd(n, n.nodeType === 1 ? n.childNodes.length : n.nodeValue.length);\n\t\t};\n\n\t\tfunction compareBoundaryPoints(h, r) {\n\t\t\tvar sc = t[START_CONTAINER], so = t[START_OFFSET], ec = t[END_CONTAINER], eo = t[END_OFFSET],\n\t\t\trsc = r.startContainer, rso = r.startOffset, rec = r.endContainer, reo = r.endOffset;\n\n\t\t\t// Check START_TO_START\n\t\t\tif (h === 0)\n\t\t\t\treturn _compareBoundaryPoints(sc, so, rsc, rso);\n\n\t\t\t// Check START_TO_END\n\t\t\tif (h === 1)\n\t\t\t\treturn _compareBoundaryPoints(ec, eo, rsc, rso);\n\n\t\t\t// Check END_TO_END\n\t\t\tif (h === 2)\n\t\t\t\treturn _compareBoundaryPoints(ec, eo, rec, reo);\n\n\t\t\t// Check END_TO_START\n\t\t\tif (h === 3)\n\t\t\t\treturn _compareBoundaryPoints(sc, so, rec, reo);\n\t\t};\n\n\t\tfunction deleteContents() {\n\t\t\t_traverse(DELETE);\n\t\t};\n\n\t\tfunction extractContents() {\n\t\t\treturn _traverse(EXTRACT);\n\t\t};\n\n\t\tfunction cloneContents() {\n\t\t\treturn _traverse(CLONE);\n\t\t};\n\n\t\tfunction insertNode(n) {\n\t\t\tvar startContainer = this[START_CONTAINER],\n\t\t\t\tstartOffset = this[START_OFFSET], nn, o;\n\n\t\t\t// Node is TEXT_NODE or CDATA\n\t\t\tif ((startContainer.nodeType === 3 || startContainer.nodeType === 4) && startContainer.nodeValue) {\n\t\t\t\tif (!startOffset) {\n\t\t\t\t\t// At the start of text\n\t\t\t\t\tstartContainer.parentNode.insertBefore(n, startContainer);\n\t\t\t\t} else if (startOffset >= startContainer.nodeValue.length) {\n\t\t\t\t\t// At the end of text\n\t\t\t\t\tdom.insertAfter(n, startContainer);\n\t\t\t\t} else {\n\t\t\t\t\t// Middle, need to split\n\t\t\t\t\tnn = startContainer.splitText(startOffset);\n\t\t\t\t\tstartContainer.parentNode.insertBefore(n, nn);\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Insert element node\n\t\t\t\tif (startContainer.childNodes.length > 0)\n\t\t\t\t\to = startContainer.childNodes[startOffset];\n\n\t\t\t\tif (o)\n\t\t\t\t\tstartContainer.insertBefore(n, o);\n\t\t\t\telse\n\t\t\t\t\tstartContainer.appendChild(n);\n\t\t\t}\n\t\t};\n\n\t\tfunction surroundContents(n) {\n\t\t\tvar f = t.extractContents();\n\n\t\t\tt.insertNode(n);\n\t\t\tn.appendChild(f);\n\t\t\tt.selectNode(n);\n\t\t};\n\n\t\tfunction cloneRange() {\n\t\t\treturn extend(new Range(dom), {\n\t\t\t\tstartContainer : t[START_CONTAINER],\n\t\t\t\tstartOffset : t[START_OFFSET],\n\t\t\t\tendContainer : t[END_CONTAINER],\n\t\t\t\tendOffset : t[END_OFFSET],\n\t\t\t\tcollapsed : t.collapsed,\n\t\t\t\tcommonAncestorContainer : t.commonAncestorContainer\n\t\t\t});\n\t\t};\n\n\t\t// Private methods\n\n\t\tfunction _getSelectedNode(container, offset) {\n\t\t\tvar child;\n\n\t\t\tif (container.nodeType == 3 /* TEXT_NODE */)\n\t\t\t\treturn container;\n\n\t\t\tif (offset < 0)\n\t\t\t\treturn container;\n\n\t\t\tchild = container.firstChild;\n\t\t\twhile (child && offset > 0) {\n\t\t\t\t--offset;\n\t\t\t\tchild = child.nextSibling;\n\t\t\t}\n\n\t\t\tif (child)\n\t\t\t\treturn child;\n\n\t\t\treturn container;\n\t\t};\n\n\t\tfunction _isCollapsed() {\n\t\t\treturn (t[START_CONTAINER] == t[END_CONTAINER] && t[START_OFFSET] == t[END_OFFSET]);\n\t\t};\n\n\t\tfunction _compareBoundaryPoints(containerA, offsetA, containerB, offsetB) {\n\t\t\tvar c, offsetC, n, cmnRoot, childA, childB;\n\n\t\t\t// In the first case the boundary-points have the same container. A is before B\n\t\t\t// if its offset is less than the offset of B, A is equal to B if its offset is\n\t\t\t// equal to the offset of B, and A is after B if its offset is greater than the\n\t\t\t// offset of B.\n\t\t\tif (containerA == containerB) {\n\t\t\t\tif (offsetA == offsetB)\n\t\t\t\t\treturn 0; // equal\n\n\t\t\t\tif (offsetA < offsetB)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\treturn 1; // after\n\t\t\t}\n\n\t\t\t// In the second case a child node C of the container of A is an ancestor\n\t\t\t// container of B. In this case, A is before B if the offset of A is less than or\n\t\t\t// equal to the index of the child node C and A is after B otherwise.\n\t\t\tc = containerB;\n\t\t\twhile (c && c.parentNode != containerA)\n\t\t\t\tc = c.parentNode;\n\n\t\t\tif (c) {\n\t\t\t\toffsetC = 0;\n\t\t\t\tn = containerA.firstChild;\n\n\t\t\t\twhile (n != c && offsetC < offsetA) {\n\t\t\t\t\toffsetC++;\n\t\t\t\t\tn = n.nextSibling;\n\t\t\t\t}\n\n\t\t\t\tif (offsetA <= offsetC)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\treturn 1; // after\n\t\t\t}\n\n\t\t\t// In the third case a child node C of the container of B is an ancestor container\n\t\t\t// of A. In this case, A is before B if the index of the child node C is less than\n\t\t\t// the offset of B and A is after B otherwise.\n\t\t\tc = containerA;\n\t\t\twhile (c && c.parentNode != containerB) {\n\t\t\t\tc = c.parentNode;\n\t\t\t}\n\n\t\t\tif (c) {\n\t\t\t\toffsetC = 0;\n\t\t\t\tn = containerB.firstChild;\n\n\t\t\t\twhile (n != c && offsetC < offsetB) {\n\t\t\t\t\toffsetC++;\n\t\t\t\t\tn = n.nextSibling;\n\t\t\t\t}\n\n\t\t\t\tif (offsetC < offsetB)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\treturn 1; // after\n\t\t\t}\n\n\t\t\t// In the fourth case, none of three other cases hold: the containers of A and B\n\t\t\t// are siblings or descendants of sibling nodes. In this case, A is before B if\n\t\t\t// the container of A is before the container of B in a pre-order traversal of the\n\t\t\t// Ranges' context tree and A is after B otherwise.\n\t\t\tcmnRoot = dom.findCommonAncestor(containerA, containerB);\n\t\t\tchildA = containerA;\n\n\t\t\twhile (childA && childA.parentNode != cmnRoot)\n\t\t\t\tchildA = childA.parentNode;\n\n\t\t\tif (!childA)\n\t\t\t\tchildA = cmnRoot;\n\n\t\t\tchildB = containerB;\n\t\t\twhile (childB && childB.parentNode != cmnRoot)\n\t\t\t\tchildB = childB.parentNode;\n\n\t\t\tif (!childB)\n\t\t\t\tchildB = cmnRoot;\n\n\t\t\tif (childA == childB)\n\t\t\t\treturn 0; // equal\n\n\t\t\tn = cmnRoot.firstChild;\n\t\t\twhile (n) {\n\t\t\t\tif (n == childA)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\tif (n == childB)\n\t\t\t\t\treturn 1; // after\n\n\t\t\t\tn = n.nextSibling;\n\t\t\t}\n\t\t};\n\n\t\tfunction _setEndPoint(st, n, o) {\n\t\t\tvar ec, sc;\n\n\t\t\tif (st) {\n\t\t\t\tt[START_CONTAINER] = n;\n\t\t\t\tt[START_OFFSET] = o;\n\t\t\t} else {\n\t\t\t\tt[END_CONTAINER] = n;\n\t\t\t\tt[END_OFFSET] = o;\n\t\t\t}\n\n\t\t\t// If one boundary-point of a Range is set to have a root container\n\t\t\t// other than the current one for the Range, the Range is collapsed to\n\t\t\t// the new position. This enforces the restriction that both boundary-\n\t\t\t// points of a Range must have the same root container.\n\t\t\tec = t[END_CONTAINER];\n\t\t\twhile (ec.parentNode)\n\t\t\t\tec = ec.parentNode;\n\n\t\t\tsc = t[START_CONTAINER];\n\t\t\twhile (sc.parentNode)\n\t\t\t\tsc = sc.parentNode;\n\n\t\t\tif (sc == ec) {\n\t\t\t\t// The start position of a Range is guaranteed to never be after the\n\t\t\t\t// end position. To enforce this restriction, if the start is set to\n\t\t\t\t// be at a position after the end, the Range is collapsed to that\n\t\t\t\t// position.\n\t\t\t\tif (_compareBoundaryPoints(t[START_CONTAINER], t[START_OFFSET], t[END_CONTAINER], t[END_OFFSET]) > 0)\n\t\t\t\t\tt.collapse(st);\n\t\t\t} else\n\t\t\t\tt.collapse(st);\n\n\t\t\tt.collapsed = _isCollapsed();\n\t\t\tt.commonAncestorContainer = dom.findCommonAncestor(t[START_CONTAINER], t[END_CONTAINER]);\n\t\t};\n\n\t\tfunction _traverse(how) {\n\t\t\tvar c, endContainerDepth = 0, startContainerDepth = 0, p, depthDiff, startNode, endNode, sp, ep;\n\n\t\t\tif (t[START_CONTAINER] == t[END_CONTAINER])\n\t\t\t\treturn _traverseSameContainer(how);\n\n\t\t\tfor (c = t[END_CONTAINER], p = c.parentNode; p; c = p, p = p.parentNode) {\n\t\t\t\tif (p == t[START_CONTAINER])\n\t\t\t\t\treturn _traverseCommonStartContainer(c, how);\n\n\t\t\t\t++endContainerDepth;\n\t\t\t}\n\n\t\t\tfor (c = t[START_CONTAINER], p = c.parentNode; p; c = p, p = p.parentNode) {\n\t\t\t\tif (p == t[END_CONTAINER])\n\t\t\t\t\treturn _traverseCommonEndContainer(c, how);\n\n\t\t\t\t++startContainerDepth;\n\t\t\t}\n\n\t\t\tdepthDiff = startContainerDepth - endContainerDepth;\n\n\t\t\tstartNode = t[START_CONTAINER];\n\t\t\twhile (depthDiff > 0) {\n\t\t\t\tstartNode = startNode.parentNode;\n\t\t\t\tdepthDiff--;\n\t\t\t}\n\n\t\t\tendNode = t[END_CONTAINER];\n\t\t\twhile (depthDiff < 0) {\n\t\t\t\tendNode = endNode.parentNode;\n\t\t\t\tdepthDiff++;\n\t\t\t}\n\n\t\t\t// ascend the ancestor hierarchy until we have a common parent.\n\t\t\tfor (sp = startNode.parentNode, ep = endNode.parentNode; sp != ep; sp = sp.parentNode, ep = ep.parentNode) {\n\t\t\t\tstartNode = sp;\n\t\t\t\tendNode = ep;\n\t\t\t}\n\n\t\t\treturn _traverseCommonAncestors(startNode, endNode, how);\n\t\t};\n\n\t\t function _traverseSameContainer(how) {\n\t\t\tvar frag, s, sub, n, cnt, sibling, xferNode;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\t// If selection is empty, just return the fragment\n\t\t\tif (t[START_OFFSET] == t[END_OFFSET])\n\t\t\t\treturn frag;\n\n\t\t\t// Text node needs special case handling\n\t\t\tif (t[START_CONTAINER].nodeType == 3 /* TEXT_NODE */) {\n\t\t\t\t// get the substring\n\t\t\t\ts = t[START_CONTAINER].nodeValue;\n\t\t\t\tsub = s.substring(t[START_OFFSET], t[END_OFFSET]);\n\n\t\t\t\t// set the original text node to its new value\n\t\t\t\tif (how != CLONE) {\n\t\t\t\t\tt[START_CONTAINER].deleteData(t[START_OFFSET], t[END_OFFSET] - t[START_OFFSET]);\n\n\t\t\t\t\t// Nothing is partially selected, so collapse to start point\n\t\t\t\t\tt.collapse(TRUE);\n\t\t\t\t}\n\n\t\t\t\tif (how == DELETE)\n\t\t\t\t\treturn;\n\n\t\t\t\tfrag.appendChild(doc.createTextNode(sub));\n\t\t\t\treturn frag;\n\t\t\t}\n\n\t\t\t// Copy nodes between the start/end offsets.\n\t\t\tn = _getSelectedNode(t[START_CONTAINER], t[START_OFFSET]);\n\t\t\tcnt = t[END_OFFSET] - t[START_OFFSET];\n\n\t\t\twhile (cnt > 0) {\n\t\t\t\tsibling = n.nextSibling;\n\t\t\t\txferNode = _traverseFullySelected(n, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.appendChild( xferNode );\n\n\t\t\t\t--cnt;\n\t\t\t\tn = sibling;\n\t\t\t}\n\n\t\t\t// Nothing is partially selected, so collapse to start point\n\t\t\tif (how != CLONE)\n\t\t\t\tt.collapse(TRUE);\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseCommonStartContainer(endAncestor, how) {\n\t\t\tvar frag, n, endIdx, cnt, sibling, xferNode;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\tn = _traverseRightBoundary(endAncestor, how);\n\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tendIdx = nodeIndex(endAncestor);\n\t\t\tcnt = endIdx - t[START_OFFSET];\n\n\t\t\tif (cnt <= 0) {\n\t\t\t\t// Collapse to just before the endAncestor, which\n\t\t\t\t// is partially selected.\n\t\t\t\tif (how != CLONE) {\n\t\t\t\t\tt.setEndBefore(endAncestor);\n\t\t\t\t\tt.collapse(FALSE);\n\t\t\t\t}\n\n\t\t\t\treturn frag;\n\t\t\t}\n\n\t\t\tn = endAncestor.previousSibling;\n\t\t\twhile (cnt > 0) {\n\t\t\t\tsibling = n.previousSibling;\n\t\t\t\txferNode = _traverseFullySelected(n, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.insertBefore(xferNode, frag.firstChild);\n\n\t\t\t\t--cnt;\n\t\t\t\tn = sibling;\n\t\t\t}\n\n\t\t\t// Collapse to just before the endAncestor, which\n\t\t\t// is partially selected.\n\t\t\tif (how != CLONE) {\n\t\t\t\tt.setEndBefore(endAncestor);\n\t\t\t\tt.collapse(FALSE);\n\t\t\t}\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseCommonEndContainer(startAncestor, how) {\n\t\t\tvar frag, startIdx, n, cnt, sibling, xferNode;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\tn = _traverseLeftBoundary(startAncestor, how);\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tstartIdx = nodeIndex(startAncestor);\n\t\t\t++startIdx; // Because we already traversed it\n\n\t\t\tcnt = t[END_OFFSET] - startIdx;\n\t\t\tn = startAncestor.nextSibling;\n\t\t\twhile (cnt > 0) {\n\t\t\t\tsibling = n.nextSibling;\n\t\t\t\txferNode = _traverseFullySelected(n, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.appendChild(xferNode);\n\n\t\t\t\t--cnt;\n\t\t\t\tn = sibling;\n\t\t\t}\n\n\t\t\tif (how != CLONE) {\n\t\t\t\tt.setStartAfter(startAncestor);\n\t\t\t\tt.collapse(TRUE);\n\t\t\t}\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseCommonAncestors(startAncestor, endAncestor, how) {\n\t\t\tvar n, frag, commonParent, startOffset, endOffset, cnt, sibling, nextSibling;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\tn = _traverseLeftBoundary(startAncestor, how);\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tcommonParent = startAncestor.parentNode;\n\t\t\tstartOffset = nodeIndex(startAncestor);\n\t\t\tendOffset = nodeIndex(endAncestor);\n\t\t\t++startOffset;\n\n\t\t\tcnt = endOffset - startOffset;\n\t\t\tsibling = startAncestor.nextSibling;\n\n\t\t\twhile (cnt > 0) {\n\t\t\t\tnextSibling = sibling.nextSibling;\n\t\t\t\tn = _traverseFullySelected(sibling, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.appendChild(n);\n\n\t\t\t\tsibling = nextSibling;\n\t\t\t\t--cnt;\n\t\t\t}\n\n\t\t\tn = _traverseRightBoundary(endAncestor, how);\n\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tif (how != CLONE) {\n\t\t\t\tt.setStartAfter(startAncestor);\n\t\t\t\tt.collapse(TRUE);\n\t\t\t}\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseRightBoundary(root, how) {\n\t\t\tvar next = _getSelectedNode(t[END_CONTAINER], t[END_OFFSET] - 1), parent, clonedParent, prevSibling, clonedChild, clonedGrandParent, isFullySelected = next != t[END_CONTAINER];\n\n\t\t\tif (next == root)\n\t\t\t\treturn _traverseNode(next, isFullySelected, FALSE, how);\n\n\t\t\tparent = next.parentNode;\n\t\t\tclonedParent = _traverseNode(parent, FALSE, FALSE, how);\n\n\t\t\twhile (parent) {\n\t\t\t\twhile (next) {\n\t\t\t\t\tprevSibling = next.previousSibling;\n\t\t\t\t\tclonedChild = _traverseNode(next, isFullySelected, FALSE, how);\n\n\t\t\t\t\tif (how != DELETE)\n\t\t\t\t\t\tclonedParent.insertBefore(clonedChild, clonedParent.firstChild);\n\n\t\t\t\t\tisFullySelected = TRUE;\n\t\t\t\t\tnext = prevSibling;\n\t\t\t\t}\n\n\t\t\t\tif (parent == root)\n\t\t\t\t\treturn clonedParent;\n\n\t\t\t\tnext = parent.previousSibling;\n\t\t\t\tparent = parent.parentNode;\n\n\t\t\t\tclonedGrandParent = _traverseNode(parent, FALSE, FALSE, how);\n\n\t\t\t\tif (how != DELETE)\n\t\t\t\t\tclonedGrandParent.appendChild(clonedParent);\n\n\t\t\t\tclonedParent = clonedGrandParent;\n\t\t\t}\n\t\t};\n\n\t\tfunction _traverseLeftBoundary(root, how) {\n\t\t\tvar next = _getSelectedNode(t[START_CONTAINER], t[START_OFFSET]), isFullySelected = next != t[START_CONTAINER], parent, clonedParent, nextSibling, clonedChild, clonedGrandParent;\n\n\t\t\tif (next == root)\n\t\t\t\treturn _traverseNode(next, isFullySelected, TRUE, how);\n\n\t\t\tparent = next.parentNode;\n\t\t\tclonedParent = _traverseNode(parent, FALSE, TRUE, how);\n\n\t\t\twhile (parent) {\n\t\t\t\twhile (next) {\n\t\t\t\t\tnextSibling = next.nextSibling;\n\t\t\t\t\tclonedChild = _traverseNode(next, isFullySelected, TRUE, how);\n\n\t\t\t\t\tif (how != DELETE)\n\t\t\t\t\t\tclonedParent.appendChild(clonedChild);\n\n\t\t\t\t\tisFullySelected = TRUE;\n\t\t\t\t\tnext = nextSibling;\n\t\t\t\t}\n\n\t\t\t\tif (parent == root)\n\t\t\t\t\treturn clonedParent;\n\n\t\t\t\tnext = parent.nextSibling;\n\t\t\t\tparent = parent.parentNode;\n\n\t\t\t\tclonedGrandParent = _traverseNode(parent, FALSE, TRUE, how);\n\n\t\t\t\tif (how != DELETE)\n\t\t\t\t\tclonedGrandParent.appendChild(clonedParent);\n\n\t\t\t\tclonedParent = clonedGrandParent;\n\t\t\t}\n\t\t};\n\n\t\tfunction _traverseNode(n, isFullySelected, isLeft, how) {\n\t\t\tvar txtValue, newNodeValue, oldNodeValue, offset, newNode;\n\n\t\t\tif (isFullySelected)\n\t\t\t\treturn _traverseFullySelected(n, how);\n\n\t\t\tif (n.nodeType == 3 /* TEXT_NODE */) {\n\t\t\t\ttxtValue = n.nodeValue;\n\n\t\t\t\tif (isLeft) {\n\t\t\t\t\toffset = t[START_OFFSET];\n\t\t\t\t\tnewNodeValue = txtValue.substring(offset);\n\t\t\t\t\toldNodeValue = txtValue.substring(0, offset);\n\t\t\t\t} else {\n\t\t\t\t\toffset = t[END_OFFSET];\n\t\t\t\t\tnewNodeValue = txtValue.substring(0, offset);\n\t\t\t\t\toldNodeValue = txtValue.substring(offset);\n\t\t\t\t}\n\n\t\t\t\tif (how != CLONE)\n\t\t\t\t\tn.nodeValue = oldNodeValue;\n\n\t\t\t\tif (how == DELETE)\n\t\t\t\t\treturn;\n\n\t\t\t\tnewNode = n.cloneNode(FALSE);\n\t\t\t\tnewNode.nodeValue = newNodeValue;\n\n\t\t\t\treturn newNode;\n\t\t\t}\n\n\t\t\tif (how == DELETE)\n\t\t\t\treturn;\n\n\t\t\treturn n.cloneNode(FALSE);\n\t\t};\n\n\t\tfunction _traverseFullySelected(n, how) {\n\t\t\tif (how != DELETE)\n\t\t\t\treturn how == CLONE ? n.cloneNode(TRUE) : n;\n\n\t\t\tn.parentNode.removeChild(n);\n\t\t};\n\t};\n\n\tns.Range = Range;\n})(tinymce.dom);\n\n(function() {\n\tfunction Selection(selection) {\n\t\tvar self = this, dom = selection.dom, TRUE = true, FALSE = false;\n\n\t\tfunction getPosition(rng, start) {\n\t\t\tvar checkRng, startIndex = 0, endIndex, inside,\n\t\t\t\tchildren, child, offset, index, position = -1, parent;\n\n\t\t\t// Setup test range, collapse it and get the parent\n\t\t\tcheckRng = rng.duplicate();\n\t\t\tcheckRng.collapse(start);\n\t\t\tparent = checkRng.parentElement();\n\n\t\t\t// Check if the selection is within the right document\n\t\t\tif (parent.ownerDocument !== selection.dom.doc)\n\t\t\t\treturn;\n\n\t\t\t// IE will report non editable elements as it's parent so look for an editable one\n\t\t\twhile (parent.contentEditable === \"false\") {\n\t\t\t\tparent = parent.parentNode;\n\t\t\t}\n\n\t\t\t// If parent doesn't have any children then return that we are inside the element\n\t\t\tif (!parent.hasChildNodes()) {\n\t\t\t\treturn {node : parent, inside : 1};\n\t\t\t}\n\n\t\t\t// Setup node list and endIndex\n\t\t\tchildren = parent.children;\n\t\t\tendIndex = children.length - 1;\n\n\t\t\t// Perform a binary search for the position\n\t\t\twhile (startIndex <= endIndex) {\n\t\t\t\tindex = Math.floor((startIndex + endIndex) / 2);\n\n\t\t\t\t// Move selection to node and compare the ranges\n\t\t\t\tchild = children[index];\n\t\t\t\tcheckRng.moveToElementText(child);\n\t\t\t\tposition = checkRng.compareEndPoints(start ? 'StartToStart' : 'EndToEnd', rng);\n\n\t\t\t\t// Before/after or an exact match\n\t\t\t\tif (position > 0) {\n\t\t\t\t\tendIndex = index - 1;\n\t\t\t\t} else if (position < 0) {\n\t\t\t\t\tstartIndex = index + 1;\n\t\t\t\t} else {\n\t\t\t\t\treturn {node : child};\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Check if child position is before or we didn't find a position\n\t\t\tif (position < 0) {\n\t\t\t\t// No element child was found use the parent element and the offset inside that\n\t\t\t\tif (!child) {\n\t\t\t\t\tcheckRng.moveToElementText(parent);\n\t\t\t\t\tcheckRng.collapse(true);\n\t\t\t\t\tchild = parent;\n\t\t\t\t\tinside = true;\n\t\t\t\t} else\n\t\t\t\t\tcheckRng.collapse(false);\n\n\t\t\t\tcheckRng.setEndPoint(start ? 'EndToStart' : 'EndToEnd', rng);\n\n\t\t\t\t// Fix for edge case: <div style=\"width: 100px; height:100px;\"><table>..</table>ab|c</div>\n\t\t\t\tif (checkRng.compareEndPoints(start ? 'StartToStart' : 'StartToEnd', rng) > 0) {\n\t\t\t\t\tcheckRng = rng.duplicate();\n\t\t\t\t\tcheckRng.collapse(start);\n\n\t\t\t\t\toffset = -1;\n\t\t\t\t\twhile (parent == checkRng.parentElement()) {\n\t\t\t\t\t\tif (checkRng.move('character', -1) == 0)\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\toffset++;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\toffset = offset || checkRng.text.replace('\\r\\n', ' ').length;\n\t\t\t} else {\n\t\t\t\t// Child position is after the selection endpoint\n\t\t\t\tcheckRng.collapse(true);\n\t\t\t\tcheckRng.setEndPoint(start ? 'StartToStart' : 'StartToEnd', rng);\n\n\t\t\t\t// Get the length of the text to find where the endpoint is relative to it's container\n\t\t\t\toffset = checkRng.text.replace('\\r\\n', ' ').length;\n\t\t\t}\n\n\t\t\treturn {node : child, position : position, offset : offset, inside : inside};\n\t\t};\n\n\t\t// Returns a W3C DOM compatible range object by using the IE Range API\n\t\tfunction getRange() {\n\t\t\tvar ieRange = selection.getRng(), domRange = dom.createRng(), element, collapsed, tmpRange, element2, bookmark, fail;\n\n\t\t\t// If selection is outside the current document just return an empty range\n\t\t\telement = ieRange.item ? ieRange.item(0) : ieRange.parentElement();\n\t\t\tif (element.ownerDocument != dom.doc)\n\t\t\t\treturn domRange;\n\n\t\t\tcollapsed = selection.isCollapsed();\n\n\t\t\t// Handle control selection\n\t\t\tif (ieRange.item) {\n\t\t\t\tdomRange.setStart(element.parentNode, dom.nodeIndex(element));\n\t\t\t\tdomRange.setEnd(domRange.startContainer, domRange.startOffset + 1);\n\n\t\t\t\treturn domRange;\n\t\t\t}\n\n\t\t\tfunction findEndPoint(start) {\n\t\t\t\tvar endPoint = getPosition(ieRange, start), container, offset, textNodeOffset = 0, sibling, undef, nodeValue;\n\n\t\t\t\tcontainer = endPoint.node;\n\t\t\t\toffset = endPoint.offset;\n\n\t\t\t\tif (endPoint.inside && !container.hasChildNodes()) {\n\t\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](container, 0);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (offset === undef) {\n\t\t\t\t\tdomRange[start ? 'setStartBefore' : 'setEndAfter'](container);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (endPoint.position < 0) {\n\t\t\t\t\tsibling = endPoint.inside ? container.firstChild : container.nextSibling;\n\n\t\t\t\t\tif (!sibling) {\n\t\t\t\t\t\tdomRange[start ? 'setStartAfter' : 'setEndAfter'](container);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!offset) {\n\t\t\t\t\t\tif (sibling.nodeType == 3)\n\t\t\t\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](sibling, 0);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tdomRange[start ? 'setStartBefore' : 'setEndBefore'](sibling);\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Find the text node and offset\n\t\t\t\t\twhile (sibling) {\n\t\t\t\t\t\tnodeValue = sibling.nodeValue;\n\t\t\t\t\t\ttextNodeOffset += nodeValue.length;\n\n\t\t\t\t\t\t// We are at or passed the position we where looking for\n\t\t\t\t\t\tif (textNodeOffset >= offset) {\n\t\t\t\t\t\t\tcontainer = sibling;\n\t\t\t\t\t\t\ttextNodeOffset -= offset;\n\t\t\t\t\t\t\ttextNodeOffset = nodeValue.length - textNodeOffset;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tsibling = sibling.nextSibling;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\t// Find the text node and offset\n\t\t\t\t\tsibling = container.previousSibling;\n\n\t\t\t\t\tif (!sibling)\n\t\t\t\t\t\treturn domRange[start ? 'setStartBefore' : 'setEndBefore'](container);\n\n\t\t\t\t\t// If there isn't any text to loop then use the first position\n\t\t\t\t\tif (!offset) {\n\t\t\t\t\t\tif (container.nodeType == 3)\n\t\t\t\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](sibling, container.nodeValue.length);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tdomRange[start ? 'setStartAfter' : 'setEndAfter'](sibling);\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\twhile (sibling) {\n\t\t\t\t\t\ttextNodeOffset += sibling.nodeValue.length;\n\n\t\t\t\t\t\t// We are at or passed the position we where looking for\n\t\t\t\t\t\tif (textNodeOffset >= offset) {\n\t\t\t\t\t\t\tcontainer = sibling;\n\t\t\t\t\t\t\ttextNodeOffset -= offset;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tsibling = sibling.previousSibling;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](container, textNodeOffset);\n\t\t\t};\n\n\t\t\ttry {\n\t\t\t\t// Find start point\n\t\t\t\tfindEndPoint(true);\n\n\t\t\t\t// Find end point if needed\n\t\t\t\tif (!collapsed)\n\t\t\t\t\tfindEndPoint();\n\t\t\t} catch (ex) {\n\t\t\t\t// IE has a nasty bug where text nodes might throw \"invalid argument\" when you\n\t\t\t\t// access the nodeValue or other properties of text nodes. This seems to happend when\n\t\t\t\t// text nodes are split into two nodes by a delete/backspace call. So lets detect it and try to fix it.\n\t\t\t\tif (ex.number == -2147024809) {\n\t\t\t\t\t// Get the current selection\n\t\t\t\t\tbookmark = self.getBookmark(2);\n\n\t\t\t\t\t// Get start element\n\t\t\t\t\ttmpRange = ieRange.duplicate();\n\t\t\t\t\ttmpRange.collapse(true);\n\t\t\t\t\telement = tmpRange.parentElement();\n\n\t\t\t\t\t// Get end element\n\t\t\t\t\tif (!collapsed) {\n\t\t\t\t\t\ttmpRange = ieRange.duplicate();\n\t\t\t\t\t\ttmpRange.collapse(false);\n\t\t\t\t\t\telement2 = tmpRange.parentElement();\n\t\t\t\t\t\telement2.innerHTML = element2.innerHTML;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove the broken elements\n\t\t\t\t\telement.innerHTML = element.innerHTML;\n\n\t\t\t\t\t// Restore the selection\n\t\t\t\t\tself.moveToBookmark(bookmark);\n\n\t\t\t\t\t// Since the range has moved we need to re-get it\n\t\t\t\t\tieRange = selection.getRng();\n\n\t\t\t\t\t// Find start point\n\t\t\t\t\tfindEndPoint(true);\n\n\t\t\t\t\t// Find end point if needed\n\t\t\t\t\tif (!collapsed)\n\t\t\t\t\t\tfindEndPoint();\n\t\t\t\t} else\n\t\t\t\t\tthrow ex; // Throw other errors\n\t\t\t}\n\n\t\t\treturn domRange;\n\t\t};\n\n\t\tthis.getBookmark = function(type) {\n\t\t\tvar rng = selection.getRng(), start, end, bookmark = {};\n\n\t\t\tfunction getIndexes(node) {\n\t\t\t\tvar node, parent, root, children, i, indexes = [];\n\n\t\t\t\tparent = node.parentNode;\n\t\t\t\troot = dom.getRoot().parentNode;\n\n\t\t\t\twhile (parent != root && parent.nodeType !== 9) {\n\t\t\t\t\tchildren = parent.children;\n\n\t\t\t\t\ti = children.length;\n\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\tif (node === children[i]) {\n\t\t\t\t\t\t\tindexes.push(i);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = parent;\n\t\t\t\t\tparent = parent.parentNode;\n\t\t\t\t}\n\n\t\t\t\treturn indexes;\n\t\t\t};\n\n\t\t\tfunction getBookmarkEndPoint(start) {\n\t\t\t\tvar position;\n\n\t\t\t\tposition = getPosition(rng, start);\n\t\t\t\tif (position) {\n\t\t\t\t\treturn {\n\t\t\t\t\t\tposition : position.position,\n\t\t\t\t\t\toffset : position.offset,\n\t\t\t\t\t\tindexes : getIndexes(position.node),\n\t\t\t\t\t\tinside : position.inside\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Non ubstructive bookmark\n\t\t\tif (type === 2) {\n\t\t\t\t// Handle text selection\n\t\t\t\tif (!rng.item) {\n\t\t\t\t\tbookmark.start = getBookmarkEndPoint(true);\n\n\t\t\t\t\tif (!selection.isCollapsed())\n\t\t\t\t\t\tbookmark.end = getBookmarkEndPoint();\n\t\t\t\t} else\n\t\t\t\t\tbookmark.start = {ctrl : true, indexes : getIndexes(rng.item(0))};\n\t\t\t}\n\n\t\t\treturn bookmark;\n\t\t};\n\n\t\tthis.moveToBookmark = function(bookmark) {\n\t\t\tvar rng, body = dom.doc.body;\n\n\t\t\tfunction resolveIndexes(indexes) {\n\t\t\t\tvar node, i, idx, children;\n\n\t\t\t\tnode = dom.getRoot();\n\t\t\t\tfor (i = indexes.length - 1; i >= 0; i--) {\n\t\t\t\t\tchildren = node.children;\n\t\t\t\t\tidx = indexes[i];\n\n\t\t\t\t\tif (idx <= children.length - 1) {\n\t\t\t\t\t\tnode = children[idx];\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn node;\n\t\t\t};\n\n\t\t\tfunction setBookmarkEndPoint(start) {\n\t\t\t\tvar endPoint = bookmark[start ? 'start' : 'end'], moveLeft, moveRng, undef;\n\n\t\t\t\tif (endPoint) {\n\t\t\t\t\tmoveLeft = endPoint.position > 0;\n\n\t\t\t\t\tmoveRng = body.createTextRange();\n\t\t\t\t\tmoveRng.moveToElementText(resolveIndexes(endPoint.indexes));\n\n\t\t\t\t\toffset = endPoint.offset;\n\t\t\t\t\tif (offset !== undef) {\n\t\t\t\t\t\tmoveRng.collapse(endPoint.inside || moveLeft);\n\t\t\t\t\t\tmoveRng.moveStart('character', moveLeft ? -offset : offset);\n\t\t\t\t\t} else\n\t\t\t\t\t\tmoveRng.collapse(start);\n\n\t\t\t\t\trng.setEndPoint(start ? 'StartToStart' : 'EndToStart', moveRng);\n\n\t\t\t\t\tif (start)\n\t\t\t\t\t\trng.collapse(true);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tif (bookmark.start) {\n\t\t\t\tif (bookmark.start.ctrl) {\n\t\t\t\t\trng = body.createControlRange();\n\t\t\t\t\trng.addElement(resolveIndexes(bookmark.start.indexes));\n\t\t\t\t\trng.select();\n\t\t\t\t} else {\n\t\t\t\t\trng = body.createTextRange();\n\t\t\t\t\tsetBookmarkEndPoint(true);\n\t\t\t\t\tsetBookmarkEndPoint();\n\t\t\t\t\trng.select();\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tthis.addRange = function(rng) {\n\t\t\tvar ieRng, ctrlRng, startContainer, startOffset, endContainer, endOffset, doc = selection.dom.doc, body = doc.body;\n\n\t\t\tfunction setEndPoint(start) {\n\t\t\t\tvar container, offset, marker, tmpRng, nodes;\n\n\t\t\t\tmarker = dom.create('a');\n\t\t\t\tcontainer = start ? startContainer : endContainer;\n\t\t\t\toffset = start ? startOffset : endOffset;\n\t\t\t\ttmpRng = ieRng.duplicate();\n\n\t\t\t\tif (container == doc || container == doc.documentElement) {\n\t\t\t\t\tcontainer = body;\n\t\t\t\t\toffset = 0;\n\t\t\t\t}\n\n\t\t\t\tif (container.nodeType == 3) {\n\t\t\t\t\tcontainer.parentNode.insertBefore(marker, container);\n\t\t\t\t\ttmpRng.moveToElementText(marker);\n\t\t\t\t\ttmpRng.moveStart('character', offset);\n\t\t\t\t\tdom.remove(marker);\n\t\t\t\t\tieRng.setEndPoint(start ? 'StartToStart' : 'EndToEnd', tmpRng);\n\t\t\t\t} else {\n\t\t\t\t\tnodes = container.childNodes;\n\n\t\t\t\t\tif (nodes.length) {\n\t\t\t\t\t\tif (offset >= nodes.length) {\n\t\t\t\t\t\t\tdom.insertAfter(marker, nodes[nodes.length - 1]);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tcontainer.insertBefore(marker, nodes[offset]);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\ttmpRng.moveToElementText(marker);\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Empty node selection for example <div>|</div>\n\t\t\t\t\t\tmarker = doc.createTextNode('\\uFEFF');\n\t\t\t\t\t\tcontainer.appendChild(marker);\n\t\t\t\t\t\ttmpRng.moveToElementText(marker.parentNode);\n\t\t\t\t\t\ttmpRng.collapse(TRUE);\n\t\t\t\t\t}\n\n\t\t\t\t\tieRng.setEndPoint(start ? 'StartToStart' : 'EndToEnd', tmpRng);\n\t\t\t\t\tdom.remove(marker);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Setup some shorter versions\n\t\t\tstartContainer = rng.startContainer;\n\t\t\tstartOffset = rng.startOffset;\n\t\t\tendContainer = rng.endContainer;\n\t\t\tendOffset = rng.endOffset;\n\t\t\tieRng = body.createTextRange();\n\n\t\t\t// If single element selection then try making a control selection out of it\n\t\t\tif (startContainer == endContainer && startContainer.nodeType == 1 && startOffset == endOffset - 1) {\n\t\t\t\tif (startOffset == endOffset - 1) {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tctrlRng = body.createControlRange();\n\t\t\t\t\t\tctrlRng.addElement(startContainer.childNodes[startOffset]);\n\t\t\t\t\t\tctrlRng.select();\n\t\t\t\t\t\treturn;\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// Ignore\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Set start/end point of selection\n\t\t\tsetEndPoint(true);\n\t\t\tsetEndPoint();\n\n\t\t\t// Select the new range and scroll it into view\n\t\t\tieRng.select();\n\t\t};\n\n\t\t// Expose range method\n\t\tthis.getRangeAt = getRange;\n\t};\n\n\t// Expose the selection object\n\ttinymce.dom.TridentSelection = Selection;\n})();\n\n\n/*\n * Sizzle CSS Selector Engine - v1.0\n *  Copyright 2009, The Dojo Foundation\n *  Released under the MIT, BSD, and GPL Licenses.\n *  More information: http://sizzlejs.com/\n */\n(function(){\n\nvar chunker = /((?:\\((?:\\([^()]+\\)|[^()]+)+\\)|\\[(?:\\[[^\\[\\]]*\\]|['\"][^'\"]*['\"]|[^\\[\\]'\"]+)+\\]|\\\\.|[^ >+~,(\\[\\\\]+)+|[>+~])(\\s*,\\s*)?((?:.|\\r|\\n)*)/g,\n\tdone = 0,\n\ttoString = Object.prototype.toString,\n\thasDuplicate = false,\n\tbaseHasDuplicate = true;\n\n// Here we check if the JavaScript engine is using some sort of\n// optimization where it does not always call our comparision\n// function. If that is the case, discard the hasDuplicate value.\n//   Thus far that includes Google Chrome.\n[0, 0].sort(function(){\n\tbaseHasDuplicate = false;\n\treturn 0;\n});\n\nvar Sizzle = function(selector, context, results, seed) {\n\tresults = results || [];\n\tcontext = context || document;\n\n\tvar origContext = context;\n\n\tif ( context.nodeType !== 1 && context.nodeType !== 9 ) {\n\t\treturn [];\n\t}\n\n\tif ( !selector || typeof selector !== \"string\" ) {\n\t\treturn results;\n\t}\n\n\tvar parts = [], m, set, checkSet, extra, prune = true, contextXML = Sizzle.isXML(context),\n\t\tsoFar = selector, ret, cur, pop, i;\n\n\t// Reset the position of the chunker regexp (start from head)\n\tdo {\n\t\tchunker.exec(\"\");\n\t\tm = chunker.exec(soFar);\n\n\t\tif ( m ) {\n\t\t\tsoFar = m[3];\n\n\t\t\tparts.push( m[1] );\n\n\t\t\tif ( m[2] ) {\n\t\t\t\textra = m[3];\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t} while ( m );\n\n\tif ( parts.length > 1 && origPOS.exec( selector ) ) {\n\t\tif ( parts.length === 2 && Expr.relative[ parts[0] ] ) {\n\t\t\tset = posProcess( parts[0] + parts[1], context );\n\t\t} else {\n\t\t\tset = Expr.relative[ parts[0] ] ?\n\t\t\t\t[ context ] :\n\t\t\t\tSizzle( parts.shift(), context );\n\n\t\t\twhile ( parts.length ) {\n\t\t\t\tselector = parts.shift();\n\n\t\t\t\tif ( Expr.relative[ selector ] ) {\n\t\t\t\t\tselector += parts.shift();\n\t\t\t\t}\n\n\t\t\t\tset = posProcess( selector, set );\n\t\t\t}\n\t\t}\n\t} else {\n\t\t// Take a shortcut and set the context if the root selector is an ID\n\t\t// (but not if it'll be faster if the inner selector is an ID)\n\t\tif ( !seed && parts.length > 1 && context.nodeType === 9 && !contextXML &&\n\t\t\t\tExpr.match.ID.test(parts[0]) && !Expr.match.ID.test(parts[parts.length - 1]) ) {\n\t\t\tret = Sizzle.find( parts.shift(), context, contextXML );\n\t\t\tcontext = ret.expr ? Sizzle.filter( ret.expr, ret.set )[0] : ret.set[0];\n\t\t}\n\n\t\tif ( context ) {\n\t\t\tret = seed ?\n\t\t\t\t{ expr: parts.pop(), set: makeArray(seed) } :\n\t\t\t\tSizzle.find( parts.pop(), parts.length === 1 && (parts[0] === \"~\" || parts[0] === \"+\") && context.parentNode ? context.parentNode : context, contextXML );\n\t\t\tset = ret.expr ? Sizzle.filter( ret.expr, ret.set ) : ret.set;\n\n\t\t\tif ( parts.length > 0 ) {\n\t\t\t\tcheckSet = makeArray(set);\n\t\t\t} else {\n\t\t\t\tprune = false;\n\t\t\t}\n\n\t\t\twhile ( parts.length ) {\n\t\t\t\tcur = parts.pop();\n\t\t\t\tpop = cur;\n\n\t\t\t\tif ( !Expr.relative[ cur ] ) {\n\t\t\t\t\tcur = \"\";\n\t\t\t\t} else {\n\t\t\t\t\tpop = parts.pop();\n\t\t\t\t}\n\n\t\t\t\tif ( pop == null ) {\n\t\t\t\t\tpop = context;\n\t\t\t\t}\n\n\t\t\t\tExpr.relative[ cur ]( checkSet, pop, contextXML );\n\t\t\t}\n\t\t} else {\n\t\t\tcheckSet = parts = [];\n\t\t}\n\t}\n\n\tif ( !checkSet ) {\n\t\tcheckSet = set;\n\t}\n\n\tif ( !checkSet ) {\n\t\tSizzle.error( cur || selector );\n\t}\n\n\tif ( toString.call(checkSet) === \"[object Array]\" ) {\n\t\tif ( !prune ) {\n\t\t\tresults.push.apply( results, checkSet );\n\t\t} else if ( context && context.nodeType === 1 ) {\n\t\t\tfor ( i = 0; checkSet[i] != null; i++ ) {\n\t\t\t\tif ( checkSet[i] && (checkSet[i] === true || checkSet[i].nodeType === 1 && Sizzle.contains(context, checkSet[i])) ) {\n\t\t\t\t\tresults.push( set[i] );\n\t\t\t\t}\n\t\t\t}\n\t\t} else {\n\t\t\tfor ( i = 0; checkSet[i] != null; i++ ) {\n\t\t\t\tif ( checkSet[i] && checkSet[i].nodeType === 1 ) {\n\t\t\t\t\tresults.push( set[i] );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t} else {\n\t\tmakeArray( checkSet, results );\n\t}\n\n\tif ( extra ) {\n\t\tSizzle( extra, origContext, results, seed );\n\t\tSizzle.uniqueSort( results );\n\t}\n\n\treturn results;\n};\n\nSizzle.uniqueSort = function(results){\n\tif ( sortOrder ) {\n\t\thasDuplicate = baseHasDuplicate;\n\t\tresults.sort(sortOrder);\n\n\t\tif ( hasDuplicate ) {\n\t\t\tfor ( var i = 1; i < results.length; i++ ) {\n\t\t\t\tif ( results[i] === results[i-1] ) {\n\t\t\t\t\tresults.splice(i--, 1);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\treturn results;\n};\n\nSizzle.matches = function(expr, set){\n\treturn Sizzle(expr, null, null, set);\n};\n\nSizzle.find = function(expr, context, isXML){\n\tvar set;\n\n\tif ( !expr ) {\n\t\treturn [];\n\t}\n\n\tfor ( var i = 0, l = Expr.order.length; i < l; i++ ) {\n\t\tvar type = Expr.order[i], match;\n\n\t\tif ( (match = Expr.leftMatch[ type ].exec( expr )) ) {\n\t\t\tvar left = match[1];\n\t\t\tmatch.splice(1,1);\n\n\t\t\tif ( left.substr( left.length - 1 ) !== \"\\\\\" ) {\n\t\t\t\tmatch[1] = (match[1] || \"\").replace(/\\\\/g, \"\");\n\t\t\t\tset = Expr.find[ type ]( match, context, isXML );\n\t\t\t\tif ( set != null ) {\n\t\t\t\t\texpr = expr.replace( Expr.match[ type ], \"\" );\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\tif ( !set ) {\n\t\tset = context.getElementsByTagName(\"*\");\n\t}\n\n\treturn {set: set, expr: expr};\n};\n\nSizzle.filter = function(expr, set, inplace, not){\n\tvar old = expr, result = [], curLoop = set, match, anyFound,\n\t\tisXMLFilter = set && set[0] && Sizzle.isXML(set[0]);\n\n\twhile ( expr && set.length ) {\n\t\tfor ( var type in Expr.filter ) {\n\t\t\tif ( (match = Expr.leftMatch[ type ].exec( expr )) != null && match[2] ) {\n\t\t\t\tvar filter = Expr.filter[ type ], found, item, left = match[1];\n\t\t\t\tanyFound = false;\n\n\t\t\t\tmatch.splice(1,1);\n\n\t\t\t\tif ( left.substr( left.length - 1 ) === \"\\\\\" ) {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\tif ( curLoop === result ) {\n\t\t\t\t\tresult = [];\n\t\t\t\t}\n\n\t\t\t\tif ( Expr.preFilter[ type ] ) {\n\t\t\t\t\tmatch = Expr.preFilter[ type ]( match, curLoop, inplace, result, not, isXMLFilter );\n\n\t\t\t\t\tif ( !match ) {\n\t\t\t\t\t\tanyFound = found = true;\n\t\t\t\t\t} else if ( match === true ) {\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ( match ) {\n\t\t\t\t\tfor ( var i = 0; (item = curLoop[i]) != null; i++ ) {\n\t\t\t\t\t\tif ( item ) {\n\t\t\t\t\t\t\tfound = filter( item, match, i, curLoop );\n\t\t\t\t\t\t\tvar pass = not ^ !!found;\n\n\t\t\t\t\t\t\tif ( inplace && found != null ) {\n\t\t\t\t\t\t\t\tif ( pass ) {\n\t\t\t\t\t\t\t\t\tanyFound = true;\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tcurLoop[i] = false;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else if ( pass ) {\n\t\t\t\t\t\t\t\tresult.push( item );\n\t\t\t\t\t\t\t\tanyFound = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ( found !== undefined ) {\n\t\t\t\t\tif ( !inplace ) {\n\t\t\t\t\t\tcurLoop = result;\n\t\t\t\t\t}\n\n\t\t\t\t\texpr = expr.replace( Expr.match[ type ], \"\" );\n\n\t\t\t\t\tif ( !anyFound ) {\n\t\t\t\t\t\treturn [];\n\t\t\t\t\t}\n\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Improper expression\n\t\tif ( expr === old ) {\n\t\t\tif ( anyFound == null ) {\n\t\t\t\tSizzle.error( expr );\n\t\t\t} else {\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\n\t\told = expr;\n\t}\n\n\treturn curLoop;\n};\n\nSizzle.error = function( msg ) {\n\tthrow \"Syntax error, unrecognized expression: \" + msg;\n};\n\nvar Expr = Sizzle.selectors = {\n\torder: [ \"ID\", \"NAME\", \"TAG\" ],\n\tmatch: {\n\t\tID: /#((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)/,\n\t\tCLASS: /\\.((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)/,\n\t\tNAME: /\\[name=['\"]*((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)['\"]*\\]/,\n\t\tATTR: /\\[\\s*((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)\\s*(?:(\\S?=)\\s*(['\"]*)(.*?)\\3|)\\s*\\]/,\n\t\tTAG: /^((?:[\\w\\u00c0-\\uFFFF\\*\\-]|\\\\.)+)/,\n\t\tCHILD: /:(only|nth|last|first)-child(?:\\((even|odd|[\\dn+\\-]*)\\))?/,\n\t\tPOS: /:(nth|eq|gt|lt|first|last|even|odd)(?:\\((\\d*)\\))?(?=[^\\-]|$)/,\n\t\tPSEUDO: /:((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)(?:\\((['\"]?)((?:\\([^\\)]+\\)|[^\\(\\)]*)+)\\2\\))?/\n\t},\n\tleftMatch: {},\n\tattrMap: {\n\t\t\"class\": \"className\",\n\t\t\"for\": \"htmlFor\"\n\t},\n\tattrHandle: {\n\t\thref: function(elem){\n\t\t\treturn elem.getAttribute(\"href\");\n\t\t}\n\t},\n\trelative: {\n\t\t\"+\": function(checkSet, part){\n\t\t\tvar isPartStr = typeof part === \"string\",\n\t\t\t\tisTag = isPartStr && !/\\W/.test(part),\n\t\t\t\tisPartStrNotTag = isPartStr && !isTag;\n\n\t\t\tif ( isTag ) {\n\t\t\t\tpart = part.toLowerCase();\n\t\t\t}\n\n\t\t\tfor ( var i = 0, l = checkSet.length, elem; i < l; i++ ) {\n\t\t\t\tif ( (elem = checkSet[i]) ) {\n\t\t\t\t\twhile ( (elem = elem.previousSibling) && elem.nodeType !== 1 ) {}\n\n\t\t\t\t\tcheckSet[i] = isPartStrNotTag || elem && elem.nodeName.toLowerCase() === part ?\n\t\t\t\t\t\telem || false :\n\t\t\t\t\t\telem === part;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( isPartStrNotTag ) {\n\t\t\t\tSizzle.filter( part, checkSet, true );\n\t\t\t}\n\t\t},\n\t\t\">\": function(checkSet, part){\n\t\t\tvar isPartStr = typeof part === \"string\",\n\t\t\t\telem, i = 0, l = checkSet.length;\n\n\t\t\tif ( isPartStr && !/\\W/.test(part) ) {\n\t\t\t\tpart = part.toLowerCase();\n\n\t\t\t\tfor ( ; i < l; i++ ) {\n\t\t\t\t\telem = checkSet[i];\n\t\t\t\t\tif ( elem ) {\n\t\t\t\t\t\tvar parent = elem.parentNode;\n\t\t\t\t\t\tcheckSet[i] = parent.nodeName.toLowerCase() === part ? parent : false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tfor ( ; i < l; i++ ) {\n\t\t\t\t\telem = checkSet[i];\n\t\t\t\t\tif ( elem ) {\n\t\t\t\t\t\tcheckSet[i] = isPartStr ?\n\t\t\t\t\t\t\telem.parentNode :\n\t\t\t\t\t\t\telem.parentNode === part;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ( isPartStr ) {\n\t\t\t\t\tSizzle.filter( part, checkSet, true );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"\": function(checkSet, part, isXML){\n\t\t\tvar doneName = done++, checkFn = dirCheck, nodeCheck;\n\n\t\t\tif ( typeof part === \"string\" && !/\\W/.test(part) ) {\n\t\t\t\tpart = part.toLowerCase();\n\t\t\t\tnodeCheck = part;\n\t\t\t\tcheckFn = dirNodeCheck;\n\t\t\t}\n\n\t\t\tcheckFn(\"parentNode\", part, doneName, checkSet, nodeCheck, isXML);\n\t\t},\n\t\t\"~\": function(checkSet, part, isXML){\n\t\t\tvar doneName = done++, checkFn = dirCheck, nodeCheck;\n\n\t\t\tif ( typeof part === \"string\" && !/\\W/.test(part) ) {\n\t\t\t\tpart = part.toLowerCase();\n\t\t\t\tnodeCheck = part;\n\t\t\t\tcheckFn = dirNodeCheck;\n\t\t\t}\n\n\t\t\tcheckFn(\"previousSibling\", part, doneName, checkSet, nodeCheck, isXML);\n\t\t}\n\t},\n\tfind: {\n\t\tID: function(match, context, isXML){\n\t\t\tif ( typeof context.getElementById !== \"undefined\" && !isXML ) {\n\t\t\t\tvar m = context.getElementById(match[1]);\n\t\t\t\treturn m ? [m] : [];\n\t\t\t}\n\t\t},\n\t\tNAME: function(match, context){\n\t\t\tif ( typeof context.getElementsByName !== \"undefined\" ) {\n\t\t\t\tvar ret = [], results = context.getElementsByName(match[1]);\n\n\t\t\t\tfor ( var i = 0, l = results.length; i < l; i++ ) {\n\t\t\t\t\tif ( results[i].getAttribute(\"name\") === match[1] ) {\n\t\t\t\t\t\tret.push( results[i] );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn ret.length === 0 ? null : ret;\n\t\t\t}\n\t\t},\n\t\tTAG: function(match, context){\n\t\t\treturn context.getElementsByTagName(match[1]);\n\t\t}\n\t},\n\tpreFilter: {\n\t\tCLASS: function(match, curLoop, inplace, result, not, isXML){\n\t\t\tmatch = \" \" + match[1].replace(/\\\\/g, \"\") + \" \";\n\n\t\t\tif ( isXML ) {\n\t\t\t\treturn match;\n\t\t\t}\n\n\t\t\tfor ( var i = 0, elem; (elem = curLoop[i]) != null; i++ ) {\n\t\t\t\tif ( elem ) {\n\t\t\t\t\tif ( not ^ (elem.className && (\" \" + elem.className + \" \").replace(/[\\t\\n]/g, \" \").indexOf(match) >= 0) ) {\n\t\t\t\t\t\tif ( !inplace ) {\n\t\t\t\t\t\t\tresult.push( elem );\n\t\t\t\t\t\t}\n\t\t\t\t\t} else if ( inplace ) {\n\t\t\t\t\t\tcurLoop[i] = false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn false;\n\t\t},\n\t\tID: function(match){\n\t\t\treturn match[1].replace(/\\\\/g, \"\");\n\t\t},\n\t\tTAG: function(match, curLoop){\n\t\t\treturn match[1].toLowerCase();\n\t\t},\n\t\tCHILD: function(match){\n\t\t\tif ( match[1] === \"nth\" ) {\n\t\t\t\t// parse equations like 'even', 'odd', '5', '2n', '3n+2', '4n-1', '-n+6'\n\t\t\t\tvar test = /(-?)(\\d*)n((?:\\+|-)?\\d*)/.exec(\n\t\t\t\t\tmatch[2] === \"even\" && \"2n\" || match[2] === \"odd\" && \"2n+1\" ||\n\t\t\t\t\t!/\\D/.test( match[2] ) && \"0n+\" + match[2] || match[2]);\n\n\t\t\t\t// calculate the numbers (first)n+(last) including if they are negative\n\t\t\t\tmatch[2] = (test[1] + (test[2] || 1)) - 0;\n\t\t\t\tmatch[3] = test[3] - 0;\n\t\t\t}\n\n\t\t\t// TODO: Move to normal caching system\n\t\t\tmatch[0] = done++;\n\n\t\t\treturn match;\n\t\t},\n\t\tATTR: function(match, curLoop, inplace, result, not, isXML){\n\t\t\tvar name = match[1].replace(/\\\\/g, \"\");\n\n\t\t\tif ( !isXML && Expr.attrMap[name] ) {\n\t\t\t\tmatch[1] = Expr.attrMap[name];\n\t\t\t}\n\n\t\t\tif ( match[2] === \"~=\" ) {\n\t\t\t\tmatch[4] = \" \" + match[4] + \" \";\n\t\t\t}\n\n\t\t\treturn match;\n\t\t},\n\t\tPSEUDO: function(match, curLoop, inplace, result, not){\n\t\t\tif ( match[1] === \"not\" ) {\n\t\t\t\t// If we're dealing with a complex expression, or a simple one\n\t\t\t\tif ( ( chunker.exec(match[3]) || \"\" ).length > 1 || /^\\w/.test(match[3]) ) {\n\t\t\t\t\tmatch[3] = Sizzle(match[3], null, null, curLoop);\n\t\t\t\t} else {\n\t\t\t\t\tvar ret = Sizzle.filter(match[3], curLoop, inplace, true ^ not);\n\t\t\t\t\tif ( !inplace ) {\n\t\t\t\t\t\tresult.push.apply( result, ret );\n\t\t\t\t\t}\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t} else if ( Expr.match.POS.test( match[0] ) || Expr.match.CHILD.test( match[0] ) ) {\n\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\treturn match;\n\t\t},\n\t\tPOS: function(match){\n\t\t\tmatch.unshift( true );\n\t\t\treturn match;\n\t\t}\n\t},\n\tfilters: {\n\t\tenabled: function(elem){\n\t\t\treturn elem.disabled === false && elem.type !== \"hidden\";\n\t\t},\n\t\tdisabled: function(elem){\n\t\t\treturn elem.disabled === true;\n\t\t},\n\t\tchecked: function(elem){\n\t\t\treturn elem.checked === true;\n\t\t},\n\t\tselected: function(elem){\n\t\t\t// Accessing this property makes selected-by-default\n\t\t\t// options in Safari work properly\n\t\t\telem.parentNode.selectedIndex;\n\t\t\treturn elem.selected === true;\n\t\t},\n\t\tparent: function(elem){\n\t\t\treturn !!elem.firstChild;\n\t\t},\n\t\tempty: function(elem){\n\t\t\treturn !elem.firstChild;\n\t\t},\n\t\thas: function(elem, i, match){\n\t\t\treturn !!Sizzle( match[3], elem ).length;\n\t\t},\n\t\theader: function(elem){\n\t\t\treturn (/h\\d/i).test( elem.nodeName );\n\t\t},\n\t\ttext: function(elem){\n\t\t\treturn \"text\" === elem.type;\n\t\t},\n\t\tradio: function(elem){\n\t\t\treturn \"radio\" === elem.type;\n\t\t},\n\t\tcheckbox: function(elem){\n\t\t\treturn \"checkbox\" === elem.type;\n\t\t},\n\t\tfile: function(elem){\n\t\t\treturn \"file\" === elem.type;\n\t\t},\n\t\tpassword: function(elem){\n\t\t\treturn \"password\" === elem.type;\n\t\t},\n\t\tsubmit: function(elem){\n\t\t\treturn \"submit\" === elem.type;\n\t\t},\n\t\timage: function(elem){\n\t\t\treturn \"image\" === elem.type;\n\t\t},\n\t\treset: function(elem){\n\t\t\treturn \"reset\" === elem.type;\n\t\t},\n\t\tbutton: function(elem){\n\t\t\treturn \"button\" === elem.type || elem.nodeName.toLowerCase() === \"button\";\n\t\t},\n\t\tinput: function(elem){\n\t\t\treturn (/input|select|textarea|button/i).test(elem.nodeName);\n\t\t}\n\t},\n\tsetFilters: {\n\t\tfirst: function(elem, i){\n\t\t\treturn i === 0;\n\t\t},\n\t\tlast: function(elem, i, match, array){\n\t\t\treturn i === array.length - 1;\n\t\t},\n\t\teven: function(elem, i){\n\t\t\treturn i % 2 === 0;\n\t\t},\n\t\todd: function(elem, i){\n\t\t\treturn i % 2 === 1;\n\t\t},\n\t\tlt: function(elem, i, match){\n\t\t\treturn i < match[3] - 0;\n\t\t},\n\t\tgt: function(elem, i, match){\n\t\t\treturn i > match[3] - 0;\n\t\t},\n\t\tnth: function(elem, i, match){\n\t\t\treturn match[3] - 0 === i;\n\t\t},\n\t\teq: function(elem, i, match){\n\t\t\treturn match[3] - 0 === i;\n\t\t}\n\t},\n\tfilter: {\n\t\tPSEUDO: function(elem, match, i, array){\n\t\t\tvar name = match[1], filter = Expr.filters[ name ];\n\n\t\t\tif ( filter ) {\n\t\t\t\treturn filter( elem, i, match, array );\n\t\t\t} else if ( name === \"contains\" ) {\n\t\t\t\treturn (elem.textContent || elem.innerText || Sizzle.getText([ elem ]) || \"\").indexOf(match[3]) >= 0;\n\t\t\t} else if ( name === \"not\" ) {\n\t\t\t\tvar not = match[3];\n\n\t\t\t\tfor ( var j = 0, l = not.length; j < l; j++ ) {\n\t\t\t\t\tif ( not[j] === elem ) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn true;\n\t\t\t} else {\n\t\t\t\tSizzle.error( \"Syntax error, unrecognized expression: \" + name );\n\t\t\t}\n\t\t},\n\t\tCHILD: function(elem, match){\n\t\t\tvar type = match[1], node = elem;\n\t\t\tswitch (type) {\n\t\t\t\tcase 'only':\n\t\t\t\tcase 'first':\n\t\t\t\t\twhile ( (node = node.previousSibling) )\t {\n\t\t\t\t\t\tif ( node.nodeType === 1 ) {\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tif ( type === \"first\" ) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\t\t\t\t\tnode = elem;\n\t\t\t\tcase 'last':\n\t\t\t\t\twhile ( (node = node.nextSibling) )\t {\n\t\t\t\t\t\tif ( node.nodeType === 1 ) {\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn true;\n\t\t\t\tcase 'nth':\n\t\t\t\t\tvar first = match[2], last = match[3];\n\n\t\t\t\t\tif ( first === 1 && last === 0 ) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\n\t\t\t\t\tvar doneName = match[0],\n\t\t\t\t\t\tparent = elem.parentNode;\n\n\t\t\t\t\tif ( parent && (parent.sizcache !== doneName || !elem.nodeIndex) ) {\n\t\t\t\t\t\tvar count = 0;\n\t\t\t\t\t\tfor ( node = parent.firstChild; node; node = node.nextSibling ) {\n\t\t\t\t\t\t\tif ( node.nodeType === 1 ) {\n\t\t\t\t\t\t\t\tnode.nodeIndex = ++count;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tparent.sizcache = doneName;\n\t\t\t\t\t}\n\n\t\t\t\t\tvar diff = elem.nodeIndex - last;\n\t\t\t\t\tif ( first === 0 ) {\n\t\t\t\t\t\treturn diff === 0;\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn ( diff % first === 0 && diff / first >= 0 );\n\t\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\tID: function(elem, match){\n\t\t\treturn elem.nodeType === 1 && elem.getAttribute(\"id\") === match;\n\t\t},\n\t\tTAG: function(elem, match){\n\t\t\treturn (match === \"*\" && elem.nodeType === 1) || elem.nodeName.toLowerCase() === match;\n\t\t},\n\t\tCLASS: function(elem, match){\n\t\t\treturn (\" \" + (elem.className || elem.getAttribute(\"class\")) + \" \")\n\t\t\t\t.indexOf( match ) > -1;\n\t\t},\n\t\tATTR: function(elem, match){\n\t\t\tvar name = match[1],\n\t\t\t\tresult = Expr.attrHandle[ name ] ?\n\t\t\t\t\tExpr.attrHandle[ name ]( elem ) :\n\t\t\t\t\telem[ name ] != null ?\n\t\t\t\t\t\telem[ name ] :\n\t\t\t\t\t\telem.getAttribute( name ),\n\t\t\t\tvalue = result + \"\",\n\t\t\t\ttype = match[2],\n\t\t\t\tcheck = match[4];\n\n\t\t\treturn result == null ?\n\t\t\t\ttype === \"!=\" :\n\t\t\t\ttype === \"=\" ?\n\t\t\t\tvalue === check :\n\t\t\t\ttype === \"*=\" ?\n\t\t\t\tvalue.indexOf(check) >= 0 :\n\t\t\t\ttype === \"~=\" ?\n\t\t\t\t(\" \" + value + \" \").indexOf(check) >= 0 :\n\t\t\t\t!check ?\n\t\t\t\tvalue && result !== false :\n\t\t\t\ttype === \"!=\" ?\n\t\t\t\tvalue !== check :\n\t\t\t\ttype === \"^=\" ?\n\t\t\t\tvalue.indexOf(check) === 0 :\n\t\t\t\ttype === \"$=\" ?\n\t\t\t\tvalue.substr(value.length - check.length) === check :\n\t\t\t\ttype === \"|=\" ?\n\t\t\t\tvalue === check || value.substr(0, check.length + 1) === check + \"-\" :\n\t\t\t\tfalse;\n\t\t},\n\t\tPOS: function(elem, match, i, array){\n\t\t\tvar name = match[2], filter = Expr.setFilters[ name ];\n\n\t\t\tif ( filter ) {\n\t\t\t\treturn filter( elem, i, match, array );\n\t\t\t}\n\t\t}\n\t}\n};\n\nvar origPOS = Expr.match.POS,\n\tfescape = function(all, num){\n\t\treturn \"\\\\\" + (num - 0 + 1);\n\t};\n\nfor ( var type in Expr.match ) {\n\tExpr.match[ type ] = new RegExp( Expr.match[ type ].source + (/(?![^\\[]*\\])(?![^\\(]*\\))/.source) );\n\tExpr.leftMatch[ type ] = new RegExp( /(^(?:.|\\r|\\n)*?)/.source + Expr.match[ type ].source.replace(/\\\\(\\d+)/g, fescape) );\n}\n\nvar makeArray = function(array, results) {\n\tarray = Array.prototype.slice.call( array, 0 );\n\n\tif ( results ) {\n\t\tresults.push.apply( results, array );\n\t\treturn results;\n\t}\n\n\treturn array;\n};\n\n// Perform a simple check to determine if the browser is capable of\n// converting a NodeList to an array using builtin methods.\n// Also verifies that the returned array holds DOM nodes\n// (which is not the case in the Blackberry browser)\ntry {\n\tArray.prototype.slice.call( document.documentElement.childNodes, 0 )[0].nodeType;\n\n// Provide a fallback method if it does not work\n} catch(e){\n\tmakeArray = function(array, results) {\n\t\tvar ret = results || [], i = 0;\n\n\t\tif ( toString.call(array) === \"[object Array]\" ) {\n\t\t\tArray.prototype.push.apply( ret, array );\n\t\t} else {\n\t\t\tif ( typeof array.length === \"number\" ) {\n\t\t\t\tfor ( var l = array.length; i < l; i++ ) {\n\t\t\t\t\tret.push( array[i] );\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tfor ( ; array[i]; i++ ) {\n\t\t\t\t\tret.push( array[i] );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn ret;\n\t};\n}\n\nvar sortOrder;\n\nif ( document.documentElement.compareDocumentPosition ) {\n\tsortOrder = function( a, b ) {\n\t\tif ( !a.compareDocumentPosition || !b.compareDocumentPosition ) {\n\t\t\tif ( a == b ) {\n\t\t\t\thasDuplicate = true;\n\t\t\t}\n\t\t\treturn a.compareDocumentPosition ? -1 : 1;\n\t\t}\n\n\t\tvar ret = a.compareDocumentPosition(b) & 4 ? -1 : a === b ? 0 : 1;\n\t\tif ( ret === 0 ) {\n\t\t\thasDuplicate = true;\n\t\t}\n\t\treturn ret;\n\t};\n} else if ( \"sourceIndex\" in document.documentElement ) {\n\tsortOrder = function( a, b ) {\n\t\tif ( !a.sourceIndex || !b.sourceIndex ) {\n\t\t\tif ( a == b ) {\n\t\t\t\thasDuplicate = true;\n\t\t\t}\n\t\t\treturn a.sourceIndex ? -1 : 1;\n\t\t}\n\n\t\tvar ret = a.sourceIndex - b.sourceIndex;\n\t\tif ( ret === 0 ) {\n\t\t\thasDuplicate = true;\n\t\t}\n\t\treturn ret;\n\t};\n} else if ( document.createRange ) {\n\tsortOrder = function( a, b ) {\n\t\tif ( !a.ownerDocument || !b.ownerDocument ) {\n\t\t\tif ( a == b ) {\n\t\t\t\thasDuplicate = true;\n\t\t\t}\n\t\t\treturn a.ownerDocument ? -1 : 1;\n\t\t}\n\n\t\tvar aRange = a.ownerDocument.createRange(), bRange = b.ownerDocument.createRange();\n\t\taRange.setStart(a, 0);\n\t\taRange.setEnd(a, 0);\n\t\tbRange.setStart(b, 0);\n\t\tbRange.setEnd(b, 0);\n\t\tvar ret = aRange.compareBoundaryPoints(Range.START_TO_END, bRange);\n\t\tif ( ret === 0 ) {\n\t\t\thasDuplicate = true;\n\t\t}\n\t\treturn ret;\n\t};\n}\n\n// Utility function for retreiving the text value of an array of DOM nodes\nSizzle.getText = function( elems ) {\n\tvar ret = \"\", elem;\n\n\tfor ( var i = 0; elems[i]; i++ ) {\n\t\telem = elems[i];\n\n\t\t// Get the text from text nodes and CDATA nodes\n\t\tif ( elem.nodeType === 3 || elem.nodeType === 4 ) {\n\t\t\tret += elem.nodeValue;\n\n\t\t// Traverse everything else, except comment nodes\n\t\t} else if ( elem.nodeType !== 8 ) {\n\t\t\tret += Sizzle.getText( elem.childNodes );\n\t\t}\n\t}\n\n\treturn ret;\n};\n\n// Check to see if the browser returns elements by name when\n// querying by getElementById (and provide a workaround)\n(function(){\n\t// We're going to inject a fake input element with a specified name\n\tvar form = document.createElement(\"div\"),\n\t\tid = \"script\" + (new Date()).getTime();\n\tform.innerHTML = \"<a name='\" + id + \"'/>\";\n\n\t// Inject it into the root element, check its status, and remove it quickly\n\tvar root = document.documentElement;\n\troot.insertBefore( form, root.firstChild );\n\n\t// The workaround has to do additional checks after a getElementById\n\t// Which slows things down for other browsers (hence the branching)\n\tif ( document.getElementById( id ) ) {\n\t\tExpr.find.ID = function(match, context, isXML){\n\t\t\tif ( typeof context.getElementById !== \"undefined\" && !isXML ) {\n\t\t\t\tvar m = context.getElementById(match[1]);\n\t\t\t\treturn m ? m.id === match[1] || typeof m.getAttributeNode !== \"undefined\" && m.getAttributeNode(\"id\").nodeValue === match[1] ? [m] : undefined : [];\n\t\t\t}\n\t\t};\n\n\t\tExpr.filter.ID = function(elem, match){\n\t\t\tvar node = typeof elem.getAttributeNode !== \"undefined\" && elem.getAttributeNode(\"id\");\n\t\t\treturn elem.nodeType === 1 && node && node.nodeValue === match;\n\t\t};\n\t}\n\n\troot.removeChild( form );\n\troot = form = null; // release memory in IE\n})();\n\n(function(){\n\t// Check to see if the browser returns only elements\n\t// when doing getElementsByTagName(\"*\")\n\n\t// Create a fake element\n\tvar div = document.createElement(\"div\");\n\tdiv.appendChild( document.createComment(\"\") );\n\n\t// Make sure no comments are found\n\tif ( div.getElementsByTagName(\"*\").length > 0 ) {\n\t\tExpr.find.TAG = function(match, context){\n\t\t\tvar results = context.getElementsByTagName(match[1]);\n\n\t\t\t// Filter out possible comments\n\t\t\tif ( match[1] === \"*\" ) {\n\t\t\t\tvar tmp = [];\n\n\t\t\t\tfor ( var i = 0; results[i]; i++ ) {\n\t\t\t\t\tif ( results[i].nodeType === 1 ) {\n\t\t\t\t\t\ttmp.push( results[i] );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tresults = tmp;\n\t\t\t}\n\n\t\t\treturn results;\n\t\t};\n\t}\n\n\t// Check to see if an attribute returns normalized href attributes\n\tdiv.innerHTML = \"<a href='#'></a>\";\n\tif ( div.firstChild && typeof div.firstChild.getAttribute !== \"undefined\" &&\n\t\t\tdiv.firstChild.getAttribute(\"href\") !== \"#\" ) {\n\t\tExpr.attrHandle.href = function(elem){\n\t\t\treturn elem.getAttribute(\"href\", 2);\n\t\t};\n\t}\n\n\tdiv = null; // release memory in IE\n})();\n\nif ( document.querySelectorAll ) {\n\t(function(){\n\t\tvar oldSizzle = Sizzle, div = document.createElement(\"div\");\n\t\tdiv.innerHTML = \"<p class='TEST'></p>\";\n\n\t\t// Safari can't handle uppercase or unicode characters when\n\t\t// in quirks mode.\n\t\tif ( div.querySelectorAll && div.querySelectorAll(\".TEST\").length === 0 ) {\n\t\t\treturn;\n\t\t}\n\n\t\tSizzle = function(query, context, extra, seed){\n\t\t\tcontext = context || document;\n\n\t\t\t// Only use querySelectorAll on non-XML documents\n\t\t\t// (ID selectors don't work in non-HTML documents)\n\t\t\tif ( !seed && context.nodeType === 9 && !Sizzle.isXML(context) ) {\n\t\t\t\ttry {\n\t\t\t\t\treturn makeArray( context.querySelectorAll(query), extra );\n\t\t\t\t} catch(e){}\n\t\t\t}\n\n\t\t\treturn oldSizzle(query, context, extra, seed);\n\t\t};\n\n\t\tfor ( var prop in oldSizzle ) {\n\t\t\tSizzle[ prop ] = oldSizzle[ prop ];\n\t\t}\n\n\t\tdiv = null; // release memory in IE\n\t})();\n}\n\n(function(){\n\tvar div = document.createElement(\"div\");\n\n\tdiv.innerHTML = \"<div class='test e'></div><div class='test'></div>\";\n\n\t// Opera can't find a second classname (in 9.6)\n\t// Also, make sure that getElementsByClassName actually exists\n\tif ( !div.getElementsByClassName || div.getElementsByClassName(\"e\").length === 0 ) {\n\t\treturn;\n\t}\n\n\t// Safari caches class attributes, doesn't catch changes (in 3.2)\n\tdiv.lastChild.className = \"e\";\n\n\tif ( div.getElementsByClassName(\"e\").length === 1 ) {\n\t\treturn;\n\t}\n\n\tExpr.order.splice(1, 0, \"CLASS\");\n\tExpr.find.CLASS = function(match, context, isXML) {\n\t\tif ( typeof context.getElementsByClassName !== \"undefined\" && !isXML ) {\n\t\t\treturn context.getElementsByClassName(match[1]);\n\t\t}\n\t};\n\n\tdiv = null; // release memory in IE\n})();\n\nfunction dirNodeCheck( dir, cur, doneName, checkSet, nodeCheck, isXML ) {\n\tfor ( var i = 0, l = checkSet.length; i < l; i++ ) {\n\t\tvar elem = checkSet[i];\n\t\tif ( elem ) {\n\t\t\telem = elem[dir];\n\t\t\tvar match = false;\n\n\t\t\twhile ( elem ) {\n\t\t\t\tif ( elem.sizcache === doneName ) {\n\t\t\t\t\tmatch = checkSet[elem.sizset];\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tif ( elem.nodeType === 1 && !isXML ){\n\t\t\t\t\telem.sizcache = doneName;\n\t\t\t\t\telem.sizset = i;\n\t\t\t\t}\n\n\t\t\t\tif ( elem.nodeName.toLowerCase() === cur ) {\n\t\t\t\t\tmatch = elem;\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\telem = elem[dir];\n\t\t\t}\n\n\t\t\tcheckSet[i] = match;\n\t\t}\n\t}\n}\n\nfunction dirCheck( dir, cur, doneName, checkSet, nodeCheck, isXML ) {\n\tfor ( var i = 0, l = checkSet.length; i < l; i++ ) {\n\t\tvar elem = checkSet[i];\n\t\tif ( elem ) {\n\t\t\telem = elem[dir];\n\t\t\tvar match = false;\n\n\t\t\twhile ( elem ) {\n\t\t\t\tif ( elem.sizcache === doneName ) {\n\t\t\t\t\tmatch = checkSet[elem.sizset];\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\t\tif ( !isXML ) {\n\t\t\t\t\t\telem.sizcache = doneName;\n\t\t\t\t\t\telem.sizset = i;\n\t\t\t\t\t}\n\t\t\t\t\tif ( typeof cur !== \"string\" ) {\n\t\t\t\t\t\tif ( elem === cur ) {\n\t\t\t\t\t\t\tmatch = true;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t} else if ( Sizzle.filter( cur, [elem] ).length > 0 ) {\n\t\t\t\t\t\tmatch = elem;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\telem = elem[dir];\n\t\t\t}\n\n\t\t\tcheckSet[i] = match;\n\t\t}\n\t}\n}\n\nSizzle.contains = document.compareDocumentPosition ? function(a, b){\n\treturn !!(a.compareDocumentPosition(b) & 16);\n} : function(a, b){\n\treturn a !== b && (a.contains ? a.contains(b) : true);\n};\n\nSizzle.isXML = function(elem){\n\t// documentElement is verified for cases where it doesn't yet exist\n\t// (such as loading iframes in IE - #4833)\n\tvar documentElement = (elem ? elem.ownerDocument || elem : 0).documentElement;\n\treturn documentElement ? documentElement.nodeName !== \"HTML\" : false;\n};\n\nvar posProcess = function(selector, context){\n\tvar tmpSet = [], later = \"\", match,\n\t\troot = context.nodeType ? [context] : context;\n\n\t// Position selectors must be done after the filter\n\t// And so must :not(positional) so we move all PSEUDOs to the end\n\twhile ( (match = Expr.match.PSEUDO.exec( selector )) ) {\n\t\tlater += match[0];\n\t\tselector = selector.replace( Expr.match.PSEUDO, \"\" );\n\t}\n\n\tselector = Expr.relative[selector] ? selector + \"*\" : selector;\n\n\tfor ( var i = 0, l = root.length; i < l; i++ ) {\n\t\tSizzle( selector, root[i], tmpSet );\n\t}\n\n\treturn Sizzle.filter( later, tmpSet );\n};\n\n// EXPOSE\n\nwindow.tinymce.dom.Sizzle = Sizzle;\n\n})();\n\n\n(function(tinymce) {\n\t// Shorten names\n\tvar each = tinymce.each, DOM = tinymce.DOM, isIE = tinymce.isIE, isWebKit = tinymce.isWebKit, Event;\n\n\ttinymce.create('tinymce.dom.EventUtils', {\n\t\tEventUtils : function() {\n\t\t\tthis.inits = [];\n\t\t\tthis.events = [];\n\t\t},\n\n\t\tadd : function(o, n, f, s) {\n\t\t\tvar cb, t = this, el = t.events, r;\n\n\t\t\tif (n instanceof Array) {\n\t\t\t\tr = [];\n\n\t\t\t\teach(n, function(n) {\n\t\t\t\t\tr.push(t.add(o, n, f, s));\n\t\t\t\t});\n\n\t\t\t\treturn r;\n\t\t\t}\n\n\t\t\t// Handle array\n\t\t\tif (o && o.hasOwnProperty && o instanceof Array) {\n\t\t\t\tr = [];\n\n\t\t\t\teach(o, function(o) {\n\t\t\t\t\to = DOM.get(o);\n\t\t\t\t\tr.push(t.add(o, n, f, s));\n\t\t\t\t});\n\n\t\t\t\treturn r;\n\t\t\t}\n\n\t\t\to = DOM.get(o);\n\n\t\t\tif (!o)\n\t\t\t\treturn;\n\n\t\t\t// Setup event callback\n\t\t\tcb = function(e) {\n\t\t\t\t// Is all events disabled\n\t\t\t\tif (t.disabled)\n\t\t\t\t\treturn;\n\n\t\t\t\te = e || window.event;\n\n\t\t\t\t// Patch in target, preventDefault and stopPropagation in IE it's W3C valid\n\t\t\t\tif (e && isIE) {\n\t\t\t\t\tif (!e.target)\n\t\t\t\t\t\te.target = e.srcElement;\n\n\t\t\t\t\t// Patch in preventDefault, stopPropagation methods for W3C compatibility\n\t\t\t\t\ttinymce.extend(e, t._stoppers);\n\t\t\t\t}\n\n\t\t\t\tif (!s)\n\t\t\t\t\treturn f(e);\n\n\t\t\t\treturn f.call(s, e);\n\t\t\t};\n\n\t\t\tif (n == 'unload') {\n\t\t\t\ttinymce.unloads.unshift({func : cb});\n\t\t\t\treturn cb;\n\t\t\t}\n\n\t\t\tif (n == 'init') {\n\t\t\t\tif (t.domLoaded)\n\t\t\t\t\tcb();\n\t\t\t\telse\n\t\t\t\t\tt.inits.push(cb);\n\n\t\t\t\treturn cb;\n\t\t\t}\n\n\t\t\t// Store away listener reference\n\t\t\tel.push({\n\t\t\t\tobj : o,\n\t\t\t\tname : n,\n\t\t\t\tfunc : f,\n\t\t\t\tcfunc : cb,\n\t\t\t\tscope : s\n\t\t\t});\n\n\t\t\tt._add(o, n, cb);\n\n\t\t\treturn f;\n\t\t},\n\n\t\tremove : function(o, n, f) {\n\t\t\tvar t = this, a = t.events, s = false, r;\n\n\t\t\t// Handle array\n\t\t\tif (o && o.hasOwnProperty && o instanceof Array) {\n\t\t\t\tr = [];\n\n\t\t\t\teach(o, function(o) {\n\t\t\t\t\to = DOM.get(o);\n\t\t\t\t\tr.push(t.remove(o, n, f));\n\t\t\t\t});\n\n\t\t\t\treturn r;\n\t\t\t}\n\n\t\t\to = DOM.get(o);\n\n\t\t\teach(a, function(e, i) {\n\t\t\t\tif (e.obj == o && e.name == n && (!f || (e.func == f || e.cfunc == f))) {\n\t\t\t\t\ta.splice(i, 1);\n\t\t\t\t\tt._remove(o, n, e.cfunc);\n\t\t\t\t\ts = true;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn s;\n\t\t},\n\n\t\tclear : function(o) {\n\t\t\tvar t = this, a = t.events, i, e;\n\n\t\t\tif (o) {\n\t\t\t\to = DOM.get(o);\n\n\t\t\t\tfor (i = a.length - 1; i >= 0; i--) {\n\t\t\t\t\te = a[i];\n\n\t\t\t\t\tif (e.obj === o) {\n\t\t\t\t\t\tt._remove(e.obj, e.name, e.cfunc);\n\t\t\t\t\t\te.obj = e.cfunc = null;\n\t\t\t\t\t\ta.splice(i, 1);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tcancel : function(e) {\n\t\t\tif (!e)\n\t\t\t\treturn false;\n\n\t\t\tthis.stop(e);\n\n\t\t\treturn this.prevent(e);\n\t\t},\n\n\t\tstop : function(e) {\n\t\t\tif (e.stopPropagation)\n\t\t\t\te.stopPropagation();\n\t\t\telse\n\t\t\t\te.cancelBubble = true;\n\n\t\t\treturn false;\n\t\t},\n\n\t\tprevent : function(e) {\n\t\t\tif (e.preventDefault)\n\t\t\t\te.preventDefault();\n\t\t\telse\n\t\t\t\te.returnValue = false;\n\n\t\t\treturn false;\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tvar t = this;\n\n\t\t\teach(t.events, function(e, i) {\n\t\t\t\tt._remove(e.obj, e.name, e.cfunc);\n\t\t\t\te.obj = e.cfunc = null;\n\t\t\t});\n\n\t\t\tt.events = [];\n\t\t\tt = null;\n\t\t},\n\n\t\t_add : function(o, n, f) {\n\t\t\tif (o.attachEvent)\n\t\t\t\to.attachEvent('on' + n, f);\n\t\t\telse if (o.addEventListener)\n\t\t\t\to.addEventListener(n, f, false);\n\t\t\telse\n\t\t\t\to['on' + n] = f;\n\t\t},\n\n\t\t_remove : function(o, n, f) {\n\t\t\tif (o) {\n\t\t\t\ttry {\n\t\t\t\t\tif (o.detachEvent)\n\t\t\t\t\t\to.detachEvent('on' + n, f);\n\t\t\t\t\telse if (o.removeEventListener)\n\t\t\t\t\t\to.removeEventListener(n, f, false);\n\t\t\t\t\telse\n\t\t\t\t\t\to['on' + n] = null;\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Might fail with permission denined on IE so we just ignore that\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t_pageInit : function(win) {\n\t\t\tvar t = this;\n\n\t\t\t// Keep it from running more than once\n\t\t\tif (t.domLoaded)\n\t\t\t\treturn;\n\n\t\t\tt.domLoaded = true;\n\n\t\t\teach(t.inits, function(c) {\n\t\t\t\tc();\n\t\t\t});\n\n\t\t\tt.inits = [];\n\t\t},\n\n\t\t_wait : function(win) {\n\t\t\tvar t = this, doc = win.document;\n\n\t\t\t// No need since the document is already loaded\n\t\t\tif (win.tinyMCE_GZ && tinyMCE_GZ.loaded) {\n\t\t\t\tt.domLoaded = 1;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Use IE method\n\t\t\tif (doc.attachEvent) {\n\t\t\t\tdoc.attachEvent(\"onreadystatechange\", function() {\n\t\t\t\t\tif (doc.readyState === \"complete\") {\n\t\t\t\t\t\tdoc.detachEvent(\"onreadystatechange\", arguments.callee);\n\t\t\t\t\t\tt._pageInit(win);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tif (doc.documentElement.doScroll && win == win.top) {\n\t\t\t\t\t(function() {\n\t\t\t\t\t\tif (t.domLoaded)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t// If IE is used, use the trick by Diego Perini licensed under MIT by request to the author.\n\t\t\t\t\t\t\t// http://javascript.nwbox.com/IEContentLoaded/\n\t\t\t\t\t\t\tdoc.documentElement.doScroll(\"left\");\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\tsetTimeout(arguments.callee, 0);\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tt._pageInit(win);\n\t\t\t\t\t})();\n\t\t\t\t}\n\t\t\t} else if (doc.addEventListener) {\n\t\t\t\tt._add(win, 'DOMContentLoaded', function() {\n\t\t\t\t\tt._pageInit(win);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tt._add(win, 'load', function() {\n\t\t\t\tt._pageInit(win);\n\t\t\t});\n\t\t},\n\n\t\t_stoppers : {\n\t\t\tpreventDefault : function() {\n\t\t\t\tthis.returnValue = false;\n\t\t\t},\n\n\t\t\tstopPropagation : function() {\n\t\t\t\tthis.cancelBubble = true;\n\t\t\t}\n\t\t}\n\t});\n\n\tEvent = tinymce.dom.Event = new tinymce.dom.EventUtils();\n\n\t// Dispatch DOM content loaded event for IE and Safari\n\tEvent._wait(window);\n\n\ttinymce.addUnload(function() {\n\t\tEvent.destroy();\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\ttinymce.dom.Element = function(id, settings) {\n\t\tvar t = this, dom, el;\n\n\t\tt.settings = settings = settings || {};\n\t\tt.id = id;\n\t\tt.dom = dom = settings.dom || tinymce.DOM;\n\n\t\t// Only IE leaks DOM references, this is a lot faster\n\t\tif (!tinymce.isIE)\n\t\t\tel = dom.get(t.id);\n\n\t\ttinymce.each(\n\t\t\t\t('getPos,getRect,getParent,add,setStyle,getStyle,setStyles,' +\n\t\t\t\t'setAttrib,setAttribs,getAttrib,addClass,removeClass,' +\n\t\t\t\t'hasClass,getOuterHTML,setOuterHTML,remove,show,hide,' +\n\t\t\t\t'isHidden,setHTML,get').split(/,/)\n\t\t\t, function(k) {\n\t\t\t\tt[k] = function() {\n\t\t\t\t\tvar a = [id], i;\n\n\t\t\t\t\tfor (i = 0; i < arguments.length; i++)\n\t\t\t\t\t\ta.push(arguments[i]);\n\n\t\t\t\t\ta = dom[k].apply(dom, a);\n\t\t\t\t\tt.update(k);\n\n\t\t\t\t\treturn a;\n\t\t\t\t};\n\t\t});\n\n\t\ttinymce.extend(t, {\n\t\t\ton : function(n, f, s) {\n\t\t\t\treturn tinymce.dom.Event.add(t.id, n, f, s);\n\t\t\t},\n\n\t\t\tgetXY : function() {\n\t\t\t\treturn {\n\t\t\t\t\tx : parseInt(t.getStyle('left')),\n\t\t\t\t\ty : parseInt(t.getStyle('top'))\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tgetSize : function() {\n\t\t\t\tvar n = dom.get(t.id);\n\n\t\t\t\treturn {\n\t\t\t\t\tw : parseInt(t.getStyle('width') || n.clientWidth),\n\t\t\t\t\th : parseInt(t.getStyle('height') || n.clientHeight)\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tmoveTo : function(x, y) {\n\t\t\t\tt.setStyles({left : x, top : y});\n\t\t\t},\n\n\t\t\tmoveBy : function(x, y) {\n\t\t\t\tvar p = t.getXY();\n\n\t\t\t\tt.moveTo(p.x + x, p.y + y);\n\t\t\t},\n\n\t\t\tresizeTo : function(w, h) {\n\t\t\t\tt.setStyles({width : w, height : h});\n\t\t\t},\n\n\t\t\tresizeBy : function(w, h) {\n\t\t\t\tvar s = t.getSize();\n\n\t\t\t\tt.resizeTo(s.w + w, s.h + h);\n\t\t\t},\n\n\t\t\tupdate : function(k) {\n\t\t\t\tvar b;\n\n\t\t\t\tif (tinymce.isIE6 && settings.blocker) {\n\t\t\t\t\tk = k || '';\n\n\t\t\t\t\t// Ignore getters\n\t\t\t\t\tif (k.indexOf('get') === 0 || k.indexOf('has') === 0 || k.indexOf('is') === 0)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Remove blocker on remove\n\t\t\t\t\tif (k == 'remove') {\n\t\t\t\t\t\tdom.remove(t.blocker);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!t.blocker) {\n\t\t\t\t\t\tt.blocker = dom.uniqueId();\n\t\t\t\t\t\tb = dom.add(settings.container || dom.getRoot(), 'iframe', {id : t.blocker, style : 'position:absolute;', frameBorder : 0, src : 'javascript:\"\"'});\n\t\t\t\t\t\tdom.setStyle(b, 'opacity', 0);\n\t\t\t\t\t} else\n\t\t\t\t\t\tb = dom.get(t.blocker);\n\n\t\t\t\t\tdom.setStyles(b, {\n\t\t\t\t\t\tleft : t.getStyle('left', 1),\n\t\t\t\t\t\ttop : t.getStyle('top', 1),\n\t\t\t\t\t\twidth : t.getStyle('width', 1),\n\t\t\t\t\t\theight : t.getStyle('height', 1),\n\t\t\t\t\t\tdisplay : t.getStyle('display', 1),\n\t\t\t\t\t\tzIndex : parseInt(t.getStyle('zIndex', 1) || 0) - 1\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t};\n})(tinymce);\n\n(function(tinymce) {\n\tfunction trimNl(s) {\n\t\treturn s.replace(/[\\n\\r]+/g, '');\n\t};\n\n\t// Shorten names\n\tvar is = tinymce.is, isIE = tinymce.isIE, each = tinymce.each;\n\n\ttinymce.create('tinymce.dom.Selection', {\n\t\tSelection : function(dom, win, serializer) {\n\t\t\tvar t = this;\n\n\t\t\tt.dom = dom;\n\t\t\tt.win = win;\n\t\t\tt.serializer = serializer;\n\n\t\t\t// Add events\n\t\t\teach([\n\t\t\t\t'onBeforeSetContent',\n\n\t\t\t\t'onBeforeGetContent',\n\n\t\t\t\t'onSetContent',\n\n\t\t\t\t'onGetContent'\n\t\t\t], function(e) {\n\t\t\t\tt[e] = new tinymce.util.Dispatcher(t);\n\t\t\t});\n\n\t\t\t// No W3C Range support\n\t\t\tif (!t.win.getSelection)\n\t\t\t\tt.tridentSel = new tinymce.dom.TridentSelection(t);\n\n\t\t\tif (tinymce.isIE && dom.boxModel)\n\t\t\t\tthis._fixIESelection();\n\n\t\t\t// Prevent leaks\n\t\t\ttinymce.addUnload(t.destroy, t);\n\t\t},\n\n\t\tsetCursorLocation: function(node, offset) {\n\t\t\tvar t = this; var r = t.dom.createRng();\n\t\t\tr.setStart(node, offset);\n\t\t\tr.setEnd(node, offset);\n\t\t\tt.setRng(r);\n\t\t\tt.collapse(false);\n\t\t},\n\t\tgetContent : function(s) {\n\t\t\tvar t = this, r = t.getRng(), e = t.dom.create(\"body\"), se = t.getSel(), wb, wa, n;\n\n\t\t\ts = s || {};\n\t\t\twb = wa = '';\n\t\t\ts.get = true;\n\t\t\ts.format = s.format || 'html';\n\t\t\ts.forced_root_block = '';\n\t\t\tt.onBeforeGetContent.dispatch(t, s);\n\n\t\t\tif (s.format == 'text')\n\t\t\t\treturn t.isCollapsed() ? '' : (r.text || (se.toString ? se.toString() : ''));\n\n\t\t\tif (r.cloneContents) {\n\t\t\t\tn = r.cloneContents();\n\n\t\t\t\tif (n)\n\t\t\t\t\te.appendChild(n);\n\t\t\t} else if (is(r.item) || is(r.htmlText)) {\n\t\t\t\t// IE will produce invalid markup if elements are present that\n\t\t\t\t// it doesn't understand like custom elements or HTML5 elements.\n\t\t\t\t// Adding a BR in front of the contents and then remoiving it seems to fix it though.\n\t\t\t\te.innerHTML = '<br>' + (r.item ? r.item(0).outerHTML : r.htmlText);\n\t\t\t\te.removeChild(e.firstChild);\n\t\t\t} else\n\t\t\t\te.innerHTML = r.toString();\n\n\t\t\t// Keep whitespace before and after\n\t\t\tif (/^\\s/.test(e.innerHTML))\n\t\t\t\twb = ' ';\n\n\t\t\tif (/\\s+$/.test(e.innerHTML))\n\t\t\t\twa = ' ';\n\n\t\t\ts.getInner = true;\n\n\t\t\ts.content = t.isCollapsed() ? '' : wb + t.serializer.serialize(e, s) + wa;\n\t\t\tt.onGetContent.dispatch(t, s);\n\n\t\t\treturn s.content;\n\t\t},\n\n\t\tsetContent : function(content, args) {\n\t\t\tvar self = this, rng = self.getRng(), caretNode, doc = self.win.document, frag, temp;\n\n\t\t\targs = args || {format : 'html'};\n\t\t\targs.set = true;\n\t\t\tcontent = args.content = content;\n\n\t\t\t// Dispatch before set content event\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onBeforeSetContent.dispatch(self, args);\n\n\t\t\tcontent = args.content;\n\n\t\t\tif (rng.insertNode) {\n\t\t\t\t// Make caret marker since insertNode places the caret in the beginning of text after insert\n\t\t\t\tcontent += '<span id=\"__caret\">_</span>';\n\n\t\t\t\t// Delete and insert new node\n\t\t\t\tif (rng.startContainer == doc && rng.endContainer == doc) {\n\t\t\t\t\t// WebKit will fail if the body is empty since the range is then invalid and it can't insert contents\n\t\t\t\t\tdoc.body.innerHTML = content;\n\t\t\t\t} else {\n\t\t\t\t\trng.deleteContents();\n\n\t\t\t\t\tif (doc.body.childNodes.length == 0) {\n\t\t\t\t\t\tdoc.body.innerHTML = content;\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// createContextualFragment doesn't exists in IE 9 DOMRanges\n\t\t\t\t\t\tif (rng.createContextualFragment) {\n\t\t\t\t\t\t\trng.insertNode(rng.createContextualFragment(content));\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Fake createContextualFragment call in IE 9\n\t\t\t\t\t\t\tfrag = doc.createDocumentFragment();\n\t\t\t\t\t\t\ttemp = doc.createElement('div');\n\n\t\t\t\t\t\t\tfrag.appendChild(temp);\n\t\t\t\t\t\t\ttemp.outerHTML = content;\n\n\t\t\t\t\t\t\trng.insertNode(frag);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Move to caret marker\n\t\t\t\tcaretNode = self.dom.get('__caret');\n\n\t\t\t\t// Make sure we wrap it compleatly, Opera fails with a simple select call\n\t\t\t\trng = doc.createRange();\n\t\t\t\trng.setStartBefore(caretNode);\n\t\t\t\trng.setEndBefore(caretNode);\n\t\t\t\tself.setRng(rng);\n\n\t\t\t\t// Remove the caret position\n\t\t\t\tself.dom.remove('__caret');\n\n\t\t\t\ttry {\n\t\t\t\t\tself.setRng(rng);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Might fail on Opera for some odd reason\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tif (rng.item) {\n\t\t\t\t\t// Delete content and get caret text selection\n\t\t\t\t\tdoc.execCommand('Delete', false, null);\n\t\t\t\t\trng = self.getRng();\n\t\t\t\t}\n\n\t\t\t\t// Explorer removes spaces from the beginning of pasted contents\n\t\t\t\tif (/^\\s+/.test(content)) {\n\t\t\t\t\trng.pasteHTML('<span id=\"__mce_tmp\">_</span>' + content);\n\t\t\t\t\tself.dom.remove('__mce_tmp');\n\t\t\t\t} else\n\t\t\t\t\trng.pasteHTML(content);\n\t\t\t}\n\n\t\t\t// Dispatch set content event\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onSetContent.dispatch(self, args);\n\t\t},\n\n\t\tgetStart : function() {\n\t\t\tvar rng = this.getRng(), startElement, parentElement, checkRng, node;\n\n\t\t\tif (rng.duplicate || rng.item) {\n\t\t\t\t// Control selection, return first item\n\t\t\t\tif (rng.item)\n\t\t\t\t\treturn rng.item(0);\n\n\t\t\t\t// Get start element\n\t\t\t\tcheckRng = rng.duplicate();\n\t\t\t\tcheckRng.collapse(1);\n\t\t\t\tstartElement = checkRng.parentElement();\n\n\t\t\t\t// Check if range parent is inside the start element, then return the inner parent element\n\t\t\t\t// This will fix issues when a single element is selected, IE would otherwise return the wrong start element\n\t\t\t\tparentElement = node = rng.parentElement();\n\t\t\t\twhile (node = node.parentNode) {\n\t\t\t\t\tif (node == startElement) {\n\t\t\t\t\t\tstartElement = parentElement;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn startElement;\n\t\t\t} else {\n\t\t\t\tstartElement = rng.startContainer;\n\n\t\t\t\tif (startElement.nodeType == 1 && startElement.hasChildNodes())\n\t\t\t\t\tstartElement = startElement.childNodes[Math.min(startElement.childNodes.length - 1, rng.startOffset)];\n\n\t\t\t\tif (startElement && startElement.nodeType == 3)\n\t\t\t\t\treturn startElement.parentNode;\n\n\t\t\t\treturn startElement;\n\t\t\t}\n\t\t},\n\n\t\tgetEnd : function() {\n\t\t\tvar t = this, r = t.getRng(), e, eo;\n\n\t\t\tif (r.duplicate || r.item) {\n\t\t\t\tif (r.item)\n\t\t\t\t\treturn r.item(0);\n\n\t\t\t\tr = r.duplicate();\n\t\t\t\tr.collapse(0);\n\t\t\t\te = r.parentElement();\n\n\t\t\t\tif (e && e.nodeName == 'BODY')\n\t\t\t\t\treturn e.lastChild || e;\n\n\t\t\t\treturn e;\n\t\t\t} else {\n\t\t\t\te = r.endContainer;\n\t\t\t\teo = r.endOffset;\n\n\t\t\t\tif (e.nodeType == 1 && e.hasChildNodes())\n\t\t\t\t\te = e.childNodes[eo > 0 ? eo - 1 : eo];\n\n\t\t\t\tif (e && e.nodeType == 3)\n\t\t\t\t\treturn e.parentNode;\n\n\t\t\t\treturn e;\n\t\t\t}\n\t\t},\n\n\t\tgetBookmark : function(type, normalized) {\n\t\t\tvar t = this, dom = t.dom, rng, rng2, id, collapsed, name, element, index, chr = '\\uFEFF', styles;\n\n\t\t\tfunction findIndex(name, element) {\n\t\t\t\tvar index = 0;\n\n\t\t\t\teach(dom.select(name), function(node, i) {\n\t\t\t\t\tif (node == element)\n\t\t\t\t\t\tindex = i;\n\t\t\t\t});\n\n\t\t\t\treturn index;\n\t\t\t};\n\n\t\t\tif (type == 2) {\n\t\t\t\tfunction getLocation() {\n\t\t\t\t\tvar rng = t.getRng(true), root = dom.getRoot(), bookmark = {};\n\n\t\t\t\t\tfunction getPoint(rng, start) {\n\t\t\t\t\t\tvar container = rng[start ? 'startContainer' : 'endContainer'],\n\t\t\t\t\t\t\toffset = rng[start ? 'startOffset' : 'endOffset'], point = [], node, childNodes, after = 0;\n\n\t\t\t\t\t\tif (container.nodeType == 3) {\n\t\t\t\t\t\t\tif (normalized) {\n\t\t\t\t\t\t\t\tfor (node = container.previousSibling; node && node.nodeType == 3; node = node.previousSibling)\n\t\t\t\t\t\t\t\t\toffset += node.nodeValue.length;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tpoint.push(offset);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tchildNodes = container.childNodes;\n\n\t\t\t\t\t\t\tif (offset >= childNodes.length && childNodes.length) {\n\t\t\t\t\t\t\t\tafter = 1;\n\t\t\t\t\t\t\t\toffset = Math.max(0, childNodes.length - 1);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tpoint.push(t.dom.nodeIndex(childNodes[offset], normalized) + after);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfor (; container && container != root; container = container.parentNode)\n\t\t\t\t\t\t\tpoint.push(t.dom.nodeIndex(container, normalized));\n\n\t\t\t\t\t\treturn point;\n\t\t\t\t\t};\n\n\t\t\t\t\tbookmark.start = getPoint(rng, true);\n\n\t\t\t\t\tif (!t.isCollapsed())\n\t\t\t\t\t\tbookmark.end = getPoint(rng);\n\n\t\t\t\t\treturn bookmark;\n\t\t\t\t};\n\n\t\t\t\tif (t.tridentSel)\n\t\t\t\t\treturn t.tridentSel.getBookmark(type);\n\n\t\t\t\treturn getLocation();\n\t\t\t}\n\n\t\t\t// Handle simple range\n\t\t\tif (type)\n\t\t\t\treturn {rng : t.getRng()};\n\n\t\t\trng = t.getRng();\n\t\t\tid = dom.uniqueId();\n\t\t\tcollapsed = tinyMCE.activeEditor.selection.isCollapsed();\n\t\t\tstyles = 'overflow:hidden;line-height:0px';\n\n\t\t\t// Explorer method\n\t\t\tif (rng.duplicate || rng.item) {\n\t\t\t\t// Text selection\n\t\t\t\tif (!rng.item) {\n\t\t\t\t\trng2 = rng.duplicate();\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\t// Insert start marker\n\t\t\t\t\t\trng.collapse();\n\t\t\t\t\t\trng.pasteHTML('<span data-mce-type=\"bookmark\" id=\"' + id + '_start\" style=\"' + styles + '\">' + chr + '</span>');\n\n\t\t\t\t\t\t// Insert end marker\n\t\t\t\t\t\tif (!collapsed) {\n\t\t\t\t\t\t\trng2.collapse(false);\n\n\t\t\t\t\t\t\t// Detect the empty space after block elements in IE and move the end back one character <p></p>] becomes <p>]</p>\n\t\t\t\t\t\t\trng.moveToElementText(rng2.parentElement());\n\t\t\t\t\t\t\tif (rng.compareEndPoints('StartToEnd', rng2) == 0)\n\t\t\t\t\t\t\t\trng2.move('character', -1);\n\n\t\t\t\t\t\t\trng2.pasteHTML('<span data-mce-type=\"bookmark\" id=\"' + id + '_end\" style=\"' + styles + '\">' + chr + '</span>');\n\t\t\t\t\t\t}\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// IE might throw unspecified error so lets ignore it\n\t\t\t\t\t\treturn null;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\t// Control selection\n\t\t\t\t\telement = rng.item(0);\n\t\t\t\t\tname = element.nodeName;\n\n\t\t\t\t\treturn {name : name, index : findIndex(name, element)};\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\telement = t.getNode();\n\t\t\t\tname = element.nodeName;\n\t\t\t\tif (name == 'IMG')\n\t\t\t\t\treturn {name : name, index : findIndex(name, element)};\n\n\t\t\t\t// W3C method\n\t\t\t\trng2 = rng.cloneRange();\n\n\t\t\t\t// Insert end marker\n\t\t\t\tif (!collapsed) {\n\t\t\t\t\trng2.collapse(false);\n\t\t\t\t\trng2.insertNode(dom.create('span', {'data-mce-type' : \"bookmark\", id : id + '_end', style : styles}, chr));\n\t\t\t\t}\n\n\t\t\t\trng.collapse(true);\n\t\t\t\trng.insertNode(dom.create('span', {'data-mce-type' : \"bookmark\", id : id + '_start', style : styles}, chr));\n\t\t\t}\n\n\t\t\tt.moveToBookmark({id : id, keep : 1});\n\n\t\t\treturn {id : id};\n\t\t},\n\n\t\tmoveToBookmark : function(bookmark) {\n\t\t\tvar t = this, dom = t.dom, marker1, marker2, rng, root, startContainer, endContainer, startOffset, endOffset;\n\n\t\t\tif (bookmark) {\n\t\t\t\tif (bookmark.start) {\n\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\troot = dom.getRoot();\n\n\t\t\t\t\tfunction setEndPoint(start) {\n\t\t\t\t\t\tvar point = bookmark[start ? 'start' : 'end'], i, node, offset, children;\n\n\t\t\t\t\t\tif (point) {\n\t\t\t\t\t\t\toffset = point[0];\n\n\t\t\t\t\t\t\t// Find container node\n\t\t\t\t\t\t\tfor (node = root, i = point.length - 1; i >= 1; i--) {\n\t\t\t\t\t\t\t\tchildren = node.childNodes;\n\n\t\t\t\t\t\t\t\tif (point[i] > children.length - 1)\n\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\tnode = children[point[i]];\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Move text offset to best suitable location\n\t\t\t\t\t\t\tif (node.nodeType === 3)\n\t\t\t\t\t\t\t\toffset = Math.min(point[0], node.nodeValue.length);\n\n\t\t\t\t\t\t\t// Move element offset to best suitable location\n\t\t\t\t\t\t\tif (node.nodeType === 1)\n\t\t\t\t\t\t\t\toffset = Math.min(point[0], node.childNodes.length);\n\n\t\t\t\t\t\t\t// Set offset within container node\n\t\t\t\t\t\t\tif (start)\n\t\t\t\t\t\t\t\trng.setStart(node, offset);\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\trng.setEnd(node, offset);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t};\n\n\t\t\t\t\tif (t.tridentSel)\n\t\t\t\t\t\treturn t.tridentSel.moveToBookmark(bookmark);\n\n\t\t\t\t\tif (setEndPoint(true) && setEndPoint()) {\n\t\t\t\t\t\tt.setRng(rng);\n\t\t\t\t\t}\n\t\t\t\t} else if (bookmark.id) {\n\t\t\t\t\tfunction restoreEndPoint(suffix) {\n\t\t\t\t\t\tvar marker = dom.get(bookmark.id + '_' + suffix), node, idx, next, prev, keep = bookmark.keep;\n\n\t\t\t\t\t\tif (marker) {\n\t\t\t\t\t\t\tnode = marker.parentNode;\n\n\t\t\t\t\t\t\tif (suffix == 'start') {\n\t\t\t\t\t\t\t\tif (!keep) {\n\t\t\t\t\t\t\t\t\tidx = dom.nodeIndex(marker);\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tnode = marker.firstChild;\n\t\t\t\t\t\t\t\t\tidx = 1;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tstartContainer = endContainer = node;\n\t\t\t\t\t\t\t\tstartOffset = endOffset = idx;\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tif (!keep) {\n\t\t\t\t\t\t\t\t\tidx = dom.nodeIndex(marker);\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tnode = marker.firstChild;\n\t\t\t\t\t\t\t\t\tidx = 1;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tendContainer = node;\n\t\t\t\t\t\t\t\tendOffset = idx;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (!keep) {\n\t\t\t\t\t\t\t\tprev = marker.previousSibling;\n\t\t\t\t\t\t\t\tnext = marker.nextSibling;\n\n\t\t\t\t\t\t\t\t// Remove all marker text nodes\n\t\t\t\t\t\t\t\teach(tinymce.grep(marker.childNodes), function(node) {\n\t\t\t\t\t\t\t\t\tif (node.nodeType == 3)\n\t\t\t\t\t\t\t\t\t\tnode.nodeValue = node.nodeValue.replace(/\\uFEFF/g, '');\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\t// Remove marker but keep children if for example contents where inserted into the marker\n\t\t\t\t\t\t\t\t// Also remove duplicated instances of the marker for example by a split operation or by WebKit auto split on paste feature\n\t\t\t\t\t\t\t\twhile (marker = dom.get(bookmark.id + '_' + suffix))\n\t\t\t\t\t\t\t\t\tdom.remove(marker, 1);\n\n\t\t\t\t\t\t\t\t// If siblings are text nodes then merge them unless it's Opera since it some how removes the node\n\t\t\t\t\t\t\t\t// and we are sniffing since adding a lot of detection code for a browser with 3% of the market isn't worth the effort. Sorry, Opera but it's just a fact\n\t\t\t\t\t\t\t\tif (prev && next && prev.nodeType == next.nodeType && prev.nodeType == 3 && !tinymce.isOpera) {\n\t\t\t\t\t\t\t\t\tidx = prev.nodeValue.length;\n\t\t\t\t\t\t\t\t\tprev.appendData(next.nodeValue);\n\t\t\t\t\t\t\t\t\tdom.remove(next);\n\n\t\t\t\t\t\t\t\t\tif (suffix == 'start') {\n\t\t\t\t\t\t\t\t\t\tstartContainer = endContainer = prev;\n\t\t\t\t\t\t\t\t\t\tstartOffset = endOffset = idx;\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tendContainer = prev;\n\t\t\t\t\t\t\t\t\t\tendOffset = idx;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\t\tfunction addBogus(node) {\n\t\t\t\t\t\t// Adds a bogus BR element for empty block elements or just a space on IE since it renders BR elements incorrectly\n\t\t\t\t\t\tif (dom.isBlock(node) && !node.innerHTML)\n\t\t\t\t\t\t\tnode.innerHTML = !isIE ? '<br data-mce-bogus=\"1\" />' : ' ';\n\n\t\t\t\t\t\treturn node;\n\t\t\t\t\t};\n\n\t\t\t\t\t// Restore start/end points\n\t\t\t\t\trestoreEndPoint('start');\n\t\t\t\t\trestoreEndPoint('end');\n\n\t\t\t\t\tif (startContainer) {\n\t\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\t\trng.setStart(addBogus(startContainer), startOffset);\n\t\t\t\t\t\trng.setEnd(addBogus(endContainer), endOffset);\n\t\t\t\t\t\tt.setRng(rng);\n\t\t\t\t\t}\n\t\t\t\t} else if (bookmark.name) {\n\t\t\t\t\tt.select(dom.select(bookmark.name)[bookmark.index]);\n\t\t\t\t} else if (bookmark.rng)\n\t\t\t\t\tt.setRng(bookmark.rng);\n\t\t\t}\n\t\t},\n\n\t\tselect : function(node, content) {\n\t\t\tvar t = this, dom = t.dom, rng = dom.createRng(), idx;\n\n\t\t\tif (node) {\n\t\t\t\tidx = dom.nodeIndex(node);\n\t\t\t\trng.setStart(node.parentNode, idx);\n\t\t\t\trng.setEnd(node.parentNode, idx + 1);\n\n\t\t\t\t// Find first/last text node or BR element\n\t\t\t\tif (content) {\n\t\t\t\t\tfunction setPoint(node, start) {\n\t\t\t\t\t\tvar walker = new tinymce.dom.TreeWalker(node, node);\n\n\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t// Text node\n\t\t\t\t\t\t\tif (node.nodeType == 3 && tinymce.trim(node.nodeValue).length != 0) {\n\t\t\t\t\t\t\t\tif (start)\n\t\t\t\t\t\t\t\t\trng.setStart(node, 0);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\trng.setEnd(node, node.nodeValue.length);\n\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// BR element\n\t\t\t\t\t\t\tif (node.nodeName == 'BR') {\n\t\t\t\t\t\t\t\tif (start)\n\t\t\t\t\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\trng.setEndBefore(node);\n\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} while (node = (start ? walker.next() : walker.prev()));\n\t\t\t\t\t};\n\n\t\t\t\t\tsetPoint(node, 1);\n\t\t\t\t\tsetPoint(node);\n\t\t\t\t}\n\n\t\t\t\tt.setRng(rng);\n\t\t\t}\n\n\t\t\treturn node;\n\t\t},\n\n\t\tisCollapsed : function() {\n\t\t\tvar t = this, r = t.getRng(), s = t.getSel();\n\n\t\t\tif (!r || r.item)\n\t\t\t\treturn false;\n\n\t\t\tif (r.compareEndPoints)\n\t\t\t\treturn r.compareEndPoints('StartToEnd', r) === 0;\n\n\t\t\treturn !s || r.collapsed;\n\t\t},\n\n\t\tcollapse : function(to_start) {\n\t\t\tvar self = this, rng = self.getRng(), node;\n\n\t\t\t// Control range on IE\n\t\t\tif (rng.item) {\n\t\t\t\tnode = rng.item(0);\n\t\t\t\trng = self.win.document.body.createTextRange();\n\t\t\t\trng.moveToElementText(node);\n\t\t\t}\n\n\t\t\trng.collapse(!!to_start);\n\t\t\tself.setRng(rng);\n\t\t},\n\n\t\tgetSel : function() {\n\t\t\tvar t = this, w = this.win;\n\n\t\t\treturn w.getSelection ? w.getSelection() : w.document.selection;\n\t\t},\n\n\t\tgetRng : function(w3c) {\n\t\t\tvar t = this, s, r, elm, doc = t.win.document;\n\n\t\t\t// Found tridentSel object then we need to use that one\n\t\t\tif (w3c && t.tridentSel)\n\t\t\t\treturn t.tridentSel.getRangeAt(0);\n\n\t\t\ttry {\n\t\t\t\tif (s = t.getSel())\n\t\t\t\t\tr = s.rangeCount > 0 ? s.getRangeAt(0) : (s.createRange ? s.createRange() : doc.createRange());\n\t\t\t} catch (ex) {\n\t\t\t\t// IE throws unspecified error here if TinyMCE is placed in a frame/iframe\n\t\t\t}\n\n\t\t\t// We have W3C ranges and it's IE then fake control selection since IE9 doesn't handle that correctly yet\n\t\t\tif (tinymce.isIE && r && r.setStart && doc.selection.createRange().item) {\n\t\t\t\telm = doc.selection.createRange().item(0);\n\t\t\t\tr = doc.createRange();\n\t\t\t\tr.setStartBefore(elm);\n\t\t\t\tr.setEndAfter(elm);\n\t\t\t}\n\n\t\t\t// No range found then create an empty one\n\t\t\t// This can occur when the editor is placed in a hidden container element on Gecko\n\t\t\t// Or on IE when there was an exception\n\t\t\tif (!r)\n\t\t\t\tr = doc.createRange ? doc.createRange() : doc.body.createTextRange();\n\n\t\t\tif (t.selectedRange && t.explicitRange) {\n\t\t\t\tif (r.compareBoundaryPoints(r.START_TO_START, t.selectedRange) === 0 && r.compareBoundaryPoints(r.END_TO_END, t.selectedRange) === 0) {\n\t\t\t\t\t// Safari, Opera and Chrome only ever select text which causes the range to change.\n\t\t\t\t\t// This lets us use the originally set range if the selection hasn't been changed by the user.\n\t\t\t\t\tr = t.explicitRange;\n\t\t\t\t} else {\n\t\t\t\t\tt.selectedRange = null;\n\t\t\t\t\tt.explicitRange = null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn r;\n\t\t},\n\n\t\tsetRng : function(r) {\n\t\t\tvar s, t = this;\n\n\t\t\tif (!t.tridentSel) {\n\t\t\t\ts = t.getSel();\n\n\t\t\t\tif (s) {\n\t\t\t\t\tt.explicitRange = r;\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\ts.removeAllRanges();\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// IE9 might throw errors here don't know why\n\t\t\t\t\t}\n\n\t\t\t\t\ts.addRange(r);\n\t\t\t\t\tt.selectedRange = s.getRangeAt(0);\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Is W3C Range\n\t\t\t\tif (r.cloneRange) {\n\t\t\t\t\tt.tridentSel.addRange(r);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Is IE specific range\n\t\t\t\ttry {\n\t\t\t\t\tr.select();\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Needed for some odd IE bug #1843306\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tsetNode : function(n) {\n\t\t\tvar t = this;\n\n\t\t\tt.setContent(t.dom.getOuterHTML(n));\n\n\t\t\treturn n;\n\t\t},\n\n\t\tgetNode : function() {\n\t\t\tvar t = this, rng = t.getRng(), sel = t.getSel(), elm, start = rng.startContainer, end = rng.endContainer;\n\n\t\t\t// Range maybe lost after the editor is made visible again\n\t\t\tif (!rng)\n\t\t\t\treturn t.dom.getRoot();\n\n\t\t\tif (rng.setStart) {\n\t\t\t\telm = rng.commonAncestorContainer;\n\n\t\t\t\t// Handle selection a image or other control like element such as anchors\n\t\t\t\tif (!rng.collapsed) {\n\t\t\t\t\tif (rng.startContainer == rng.endContainer) {\n\t\t\t\t\t\tif (rng.endOffset - rng.startOffset < 2) {\n\t\t\t\t\t\t\tif (rng.startContainer.hasChildNodes())\n\t\t\t\t\t\t\t\telm = rng.startContainer.childNodes[rng.startOffset];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// If the anchor node is a element instead of a text node then return this element\n\t\t\t\t\t//if (tinymce.isWebKit && sel.anchorNode && sel.anchorNode.nodeType == 1)\n\t\t\t\t\t//\treturn sel.anchorNode.childNodes[sel.anchorOffset];\n\n\t\t\t\t\t// Handle cases where the selection is immediately wrapped around a node and return that node instead of it's parent.\n\t\t\t\t\t// This happens when you double click an underlined word in FireFox.\n\t\t\t\t\tif (start.nodeType === 3 && end.nodeType === 3) {\n\t\t\t\t\t\tfunction skipEmptyTextNodes(n, forwards) {\n\t\t\t\t\t\t\tvar orig = n;\n\t\t\t\t\t\t\twhile (n && n.nodeType === 3 && n.length === 0) {\n\t\t\t\t\t\t\t\tn = forwards ? n.nextSibling : n.previousSibling;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn n || orig;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (start.length === rng.startOffset) {\n\t\t\t\t\t\t\tstart = skipEmptyTextNodes(start.nextSibling, true);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tstart = start.parentNode;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (rng.endOffset === 0) {\n\t\t\t\t\t\t\tend = skipEmptyTextNodes(end.previousSibling, false);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tend = end.parentNode;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (start && start === end)\n\t\t\t\t\t\t\treturn start;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (elm && elm.nodeType == 3)\n\t\t\t\t\treturn elm.parentNode;\n\n\t\t\t\treturn elm;\n\t\t\t}\n\n\t\t\treturn rng.item ? rng.item(0) : rng.parentElement();\n\t\t},\n\n\t\tgetSelectedBlocks : function(st, en) {\n\t\t\tvar t = this, dom = t.dom, sb, eb, n, bl = [];\n\n\t\t\tsb = dom.getParent(st || t.getStart(), dom.isBlock);\n\t\t\teb = dom.getParent(en || t.getEnd(), dom.isBlock);\n\n\t\t\tif (sb)\n\t\t\t\tbl.push(sb);\n\n\t\t\tif (sb && eb && sb != eb) {\n\t\t\t\tn = sb;\n\n\t\t\t\tvar walker = new tinymce.dom.TreeWalker(sb, dom.getRoot());\n\t\t\t\twhile ((n = walker.next()) && n != eb) {\n\t\t\t\t\tif (dom.isBlock(n))\n\t\t\t\t\t\tbl.push(n);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (eb && sb != eb)\n\t\t\t\tbl.push(eb);\n\n\t\t\treturn bl;\n\t\t},\n\n\t\tnormalize : function() {\n\t\t\tvar self = this, rng, normalized;\n\n\t\t\t// Normalize only on non IE browsers for now\n\t\t\tif (tinymce.isIE)\n\t\t\t\treturn;\n\n\t\t\tfunction normalizeEndPoint(start) {\n\t\t\t\tvar container, offset, walker, dom = self.dom, body = dom.getRoot(), node;\n\n\t\t\t\tcontainer = rng[(start ? 'start' : 'end') + 'Container'];\n\t\t\t\toffset = rng[(start ? 'start' : 'end') + 'Offset'];\n\n\t\t\t\t// If the container is a document move it to the body element\n\t\t\t\tif (container.nodeType === 9) {\n\t\t\t\t\tcontainer = container.body;\n\t\t\t\t\toffset = 0;\n\t\t\t\t}\n\n\t\t\t\t// If the container is body try move it into the closest text node or position\n\t\t\t\t// TODO: Add more logic here to handle element selection cases\n\t\t\t\tif (container === body) {\n\t\t\t\t\t// Resolve the index\n\t\t\t\t\tif (container.hasChildNodes()) {\n\t\t\t\t\t\tcontainer = container.childNodes[Math.min(!start && offset > 0 ? offset - 1 : offset, container.childNodes.length - 1)];\n\t\t\t\t\t\toffset = 0;\n\n\t\t\t\t\t\t// Don't walk into elements that doesn't have any child nodes like a IMG\n\t\t\t\t\t\tif (container.hasChildNodes()) {\n\t\t\t\t\t\t\t// Walk the DOM to find a text node to place the caret at or a BR\n\t\t\t\t\t\t\tnode = container;\n\t\t\t\t\t\t\twalker = new tinymce.dom.TreeWalker(container, body);\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\t// Found a text node use that position\n\t\t\t\t\t\t\t\tif (node.nodeType === 3) {\n\t\t\t\t\t\t\t\t\toffset = start ? 0 : node.nodeValue.length - 1;\n\t\t\t\t\t\t\t\t\tcontainer = node;\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Found a BR element that we can place the caret before\n\t\t\t\t\t\t\t\tif (node.nodeName === 'BR') {\n\t\t\t\t\t\t\t\t\toffset = dom.nodeIndex(node);\n\t\t\t\t\t\t\t\t\tcontainer = node.parentNode;\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} while (node = (start ? walker.next() : walker.prev()));\n\n\t\t\t\t\t\t\tnormalized = true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Set endpoint if it was normalized\n\t\t\t\tif (normalized)\n\t\t\t\t\trng['set' + (start ? 'Start' : 'End')](container, offset);\n\t\t\t};\n\n\t\t\trng = self.getRng();\n\n\t\t\t// Normalize the end points\n\t\t\tnormalizeEndPoint(true);\n\n\t\t\tif (rng.collapsed)\n\t\t\t\tnormalizeEndPoint();\n\n\t\t\t// Set the selection if it was normalized\n\t\t\tif (normalized) {\n\t\t\t\t//console.log(self.dom.dumpRng(rng));\n\t\t\t\tself.setRng(rng);\n\t\t\t}\n\t\t},\n\n\t\tdestroy : function(s) {\n\t\t\tvar t = this;\n\n\t\t\tt.win = null;\n\n\t\t\t// Manual destroy then remove unload handler\n\t\t\tif (!s)\n\t\t\t\ttinymce.removeUnload(t.destroy);\n\t\t},\n\n\t\t// IE has an issue where you can't select/move the caret by clicking outside the body if the document is in standards mode\n\t\t_fixIESelection : function() {\n\t\t\tvar dom = this.dom, doc = dom.doc, body = doc.body, started, startRng, htmlElm;\n\n\t\t\t// Make HTML element unselectable since we are going to handle selection by hand\n\t\t\tdoc.documentElement.unselectable = true;\n\n\t\t\t// Return range from point or null if it failed\n\t\t\tfunction rngFromPoint(x, y) {\n\t\t\t\tvar rng = body.createTextRange();\n\n\t\t\t\ttry {\n\t\t\t\t\trng.moveToPoint(x, y);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// IE sometimes throws and exception, so lets just ignore it\n\t\t\t\t\trng = null;\n\t\t\t\t}\n\n\t\t\t\treturn rng;\n\t\t\t};\n\n\t\t\t// Fires while the selection is changing\n\t\t\tfunction selectionChange(e) {\n\t\t\t\tvar pointRng;\n\n\t\t\t\t// Check if the button is down or not\n\t\t\t\tif (e.button) {\n\t\t\t\t\t// Create range from mouse position\n\t\t\t\t\tpointRng = rngFromPoint(e.x, e.y);\n\n\t\t\t\t\tif (pointRng) {\n\t\t\t\t\t\t// Check if pointRange is before/after selection then change the endPoint\n\t\t\t\t\t\tif (pointRng.compareEndPoints('StartToStart', startRng) > 0)\n\t\t\t\t\t\t\tpointRng.setEndPoint('StartToStart', startRng);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tpointRng.setEndPoint('EndToEnd', startRng);\n\n\t\t\t\t\t\tpointRng.select();\n\t\t\t\t\t}\n\t\t\t\t} else\n\t\t\t\t\tendSelection();\n\t\t\t}\n\n\t\t\t// Removes listeners\n\t\t\tfunction endSelection() {\n\t\t\t\tvar rng = doc.selection.createRange();\n\n\t\t\t\t// If the range is collapsed then use the last start range\n\t\t\t\tif (startRng && !rng.item && rng.compareEndPoints('StartToEnd', rng) === 0)\n\t\t\t\t\tstartRng.select();\n\n\t\t\t\tdom.unbind(doc, 'mouseup', endSelection);\n\t\t\t\tdom.unbind(doc, 'mousemove', selectionChange);\n\t\t\t\tstartRng = started = 0;\n\t\t\t};\n\n\t\t\t// Detect when user selects outside BODY\n\t\t\tdom.bind(doc, ['mousedown', 'contextmenu'], function(e) {\n\t\t\t\tif (e.target.nodeName === 'HTML') {\n\t\t\t\t\tif (started)\n\t\t\t\t\t\tendSelection();\n\n\t\t\t\t\t// Detect vertical scrollbar, since IE will fire a mousedown on the scrollbar and have target set as HTML\n\t\t\t\t\thtmlElm = doc.documentElement;\n\t\t\t\t\tif (htmlElm.scrollHeight > htmlElm.clientHeight)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tstarted = 1;\n\t\t\t\t\t// Setup start position\n\t\t\t\t\tstartRng = rngFromPoint(e.x, e.y);\n\t\t\t\t\tif (startRng) {\n\t\t\t\t\t\t// Listen for selection change events\n\t\t\t\t\t\tdom.bind(doc, 'mouseup', endSelection);\n\t\t\t\t\t\tdom.bind(doc, 'mousemove', selectionChange);\n\n\t\t\t\t\t\tdom.win.focus();\n\t\t\t\t\t\tstartRng.select();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\ttinymce.dom.Serializer = function(settings, dom, schema) {\n\t\tvar onPreProcess, onPostProcess, isIE = tinymce.isIE, each = tinymce.each, htmlParser;\n\n\t\t// Support the old apply_source_formatting option\n\t\tif (!settings.apply_source_formatting)\n\t\t\tsettings.indent = false;\n\n\t\tsettings.remove_trailing_brs = true;\n\n\t\t// Default DOM and Schema if they are undefined\n\t\tdom = dom || tinymce.DOM;\n\t\tschema = schema || new tinymce.html.Schema(settings);\n\t\tsettings.entity_encoding = settings.entity_encoding || 'named';\n\n\t\tonPreProcess = new tinymce.util.Dispatcher(self);\n\n\t\tonPostProcess = new tinymce.util.Dispatcher(self);\n\n\t\thtmlParser = new tinymce.html.DomParser(settings, schema);\n\n\t\t// Convert move data-mce-src, data-mce-href and data-mce-style into nodes or process them if needed\n\t\thtmlParser.addAttributeFilter('src,href,style', function(nodes, name) {\n\t\t\tvar i = nodes.length, node, value, internalName = 'data-mce-' + name, urlConverter = settings.url_converter, urlConverterScope = settings.url_converter_scope, undef;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\n\t\t\t\tvalue = node.attributes.map[internalName];\n\t\t\t\tif (value !== undef) {\n\t\t\t\t\t// Set external name to internal value and remove internal\n\t\t\t\t\tnode.attr(name, value.length > 0 ? value : null);\n\t\t\t\t\tnode.attr(internalName, null);\n\t\t\t\t} else {\n\t\t\t\t\t// No internal attribute found then convert the value we have in the DOM\n\t\t\t\t\tvalue = node.attributes.map[name];\n\n\t\t\t\t\tif (name === \"style\")\n\t\t\t\t\t\tvalue = dom.serializeStyle(dom.parseStyle(value), node.name);\n\t\t\t\t\telse if (urlConverter)\n\t\t\t\t\t\tvalue = urlConverter.call(urlConverterScope, value, name, node.name);\n\n\t\t\t\t\tnode.attr(name, value.length > 0 ? value : null);\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\t// Remove internal classes mceItem<..>\n\t\thtmlParser.addAttributeFilter('class', function(nodes, name) {\n\t\t\tvar i = nodes.length, node, value;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\t\t\t\tvalue = node.attr('class').replace(/\\s*mce(Item\\w+|Selected)\\s*/g, '');\n\t\t\t\tnode.attr('class', value.length > 0 ? value : null);\n\t\t\t}\n\t\t});\n\n\t\t// Remove bookmark elements\n\t\thtmlParser.addAttributeFilter('data-mce-type', function(nodes, name, args) {\n\t\t\tvar i = nodes.length, node;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\n\t\t\t\tif (node.attributes.map['data-mce-type'] === 'bookmark' && !args.cleanup)\n\t\t\t\t\tnode.remove();\n\t\t\t}\n\t\t});\n\n\t\t// Force script into CDATA sections and remove the mce- prefix also add comments around styles\n\t\thtmlParser.addNodeFilter('script,style', function(nodes, name) {\n\t\t\tvar i = nodes.length, node, value;\n\n\t\t\tfunction trim(value) {\n\t\t\t\treturn value.replace(/(<!--\\[CDATA\\[|\\]\\]-->)/g, '\\n')\n\t\t\t\t\t\t.replace(/^[\\r\\n]*|[\\r\\n]*$/g, '')\n\t\t\t\t\t\t.replace(/^\\s*(\\/\\/\\s*<!--|\\/\\/\\s*<!\\[CDATA\\[|<!--|<!\\[CDATA\\[)[\\r\\n]*/g, '')\n\t\t\t\t\t\t.replace(/\\s*(\\/\\/\\s*\\]\\]>|\\/\\/\\s*-->|\\]\\]>|-->|\\]\\]-->)\\s*$/g, '');\n\t\t\t};\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\t\t\t\tvalue = node.firstChild ? node.firstChild.value : '';\n\n\t\t\t\tif (name === \"script\") {\n\t\t\t\t\t// Remove mce- prefix from script elements\n\t\t\t\t\tnode.attr('type', (node.attr('type') || 'text/javascript').replace(/^mce\\-/, ''));\n\n\t\t\t\t\tif (value.length > 0)\n\t\t\t\t\t\tnode.firstChild.value = '// <![CDATA[\\n' + trim(value) + '\\n// ]]>';\n\t\t\t\t} else {\n\t\t\t\t\tif (value.length > 0)\n\t\t\t\t\t\tnode.firstChild.value = '<!--\\n' + trim(value) + '\\n-->';\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\t// Convert comments to cdata and handle protected comments\n\t\thtmlParser.addNodeFilter('#comment', function(nodes, name) {\n\t\t\tvar i = nodes.length, node;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\n\t\t\t\tif (node.value.indexOf('[CDATA[') === 0) {\n\t\t\t\t\tnode.name = '#cdata';\n\t\t\t\t\tnode.type = 4;\n\t\t\t\t\tnode.value = node.value.replace(/^\\[CDATA\\[|\\]\\]$/g, '');\n\t\t\t\t} else if (node.value.indexOf('mce:protected ') === 0) {\n\t\t\t\t\tnode.name = \"#text\";\n\t\t\t\t\tnode.type = 3;\n\t\t\t\t\tnode.raw = true;\n\t\t\t\t\tnode.value = unescape(node.value).substr(14);\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\thtmlParser.addNodeFilter('xml:namespace,input', function(nodes, name) {\n\t\t\tvar i = nodes.length, node;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\t\t\t\tif (node.type === 7)\n\t\t\t\t\tnode.remove();\n\t\t\t\telse if (node.type === 1) {\n\t\t\t\t\tif (name === \"input\" && !(\"type\" in node.attributes.map))\n\t\t\t\t\t\tnode.attr('type', 'text');\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\t// Fix list elements, TODO: Replace this later\n\t\tif (settings.fix_list_elements) {\n\t\t\thtmlParser.addNodeFilter('ul,ol', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node, parentNode;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tparentNode = node.parent;\n\n\t\t\t\t\tif (parentNode.name === 'ul' || parentNode.name === 'ol') {\n\t\t\t\t\t\tif (node.prev && node.prev.name === 'li') {\n\t\t\t\t\t\t\tnode.prev.append(node);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\n\t\t// Remove internal data attributes\n\t\thtmlParser.addAttributeFilter('data-mce-src,data-mce-href,data-mce-style', function(nodes, name) {\n\t\t\tvar i = nodes.length;\n\n\t\t\twhile (i--) {\n\t\t\t\tnodes[i].attr(name, null);\n\t\t\t}\n\t\t});\n\n\t\t// Return public methods\n\t\treturn {\n\t\t\tschema : schema,\n\n\t\t\taddNodeFilter : htmlParser.addNodeFilter,\n\n\t\t\taddAttributeFilter : htmlParser.addAttributeFilter,\n\n\t\t\tonPreProcess : onPreProcess,\n\n\t\t\tonPostProcess : onPostProcess,\n\n\t\t\tserialize : function(node, args) {\n\t\t\t\tvar impl, doc, oldDoc, htmlSerializer, content;\n\n\t\t\t\t// Explorer won't clone contents of script and style and the\n\t\t\t\t// selected index of select elements are cleared on a clone operation.\n\t\t\t\tif (isIE && dom.select('script,style,select,map').length > 0) {\n\t\t\t\t\tcontent = node.innerHTML;\n\t\t\t\t\tnode = node.cloneNode(false);\n\t\t\t\t\tdom.setHTML(node, content);\n\t\t\t\t} else\n\t\t\t\t\tnode = node.cloneNode(true);\n\n\t\t\t\t// Nodes needs to be attached to something in WebKit/Opera\n\t\t\t\t// Older builds of Opera crashes if you attach the node to an document created dynamically\n\t\t\t\t// and since we can't feature detect a crash we need to sniff the acutal build number\n\t\t\t\t// This fix will make DOM ranges and make Sizzle happy!\n                if (tinymce.isOpera && opera.buildNumber() >= 1767) {\n                    impl = node.ownerDocument.implementation;\n                    if (impl.createHTMLDocument) {\n                        // Create an empty HTML document\n                        doc = impl.createHTMLDocument(\"\");\n\n                        // Add the element or it's children if it's a body element to the new document\n                        each(node.nodeName == 'BODY' ? node.childNodes : [node], function(node) {\n                            doc.body.appendChild(doc.importNode(node, true));\n                        });\n\n                        // Grab first child or body element for serialization\n                        if (node.nodeName != 'BODY')\n                            node = doc.body.firstChild;\n                        else\n                            node = doc.body;\n\n                        // set the new document in DOMUtils so createElement etc works\n                        oldDoc = dom.doc;\n                        dom.doc = doc;\n                    }\n                }\n\t\t\t\targs = args || {};\n\t\t\t\targs.format = args.format || 'html';\n\n\t\t\t\t// Pre process\n\t\t\t\tif (!args.no_events) {\n\t\t\t\t\targs.node = node;\n\t\t\t\t\tonPreProcess.dispatch(self, args);\n\t\t\t\t}\n\n\t\t\t\t// Setup serializer\n\t\t\t\thtmlSerializer = new tinymce.html.Serializer(settings, schema);\n\n\t\t\t\t// Parse and serialize HTML\n\t\t\t\targs.content = htmlSerializer.serialize(\n\t\t\t\t\thtmlParser.parse(args.getInner ? node.innerHTML : tinymce.trim(dom.getOuterHTML(node), args), args)\n\t\t\t\t);\n\n\t\t\t\t// Replace all BOM characters for now until we can find a better solution\n\t\t\t\tif (!args.cleanup)\n\t\t\t\t\targs.content = args.content.replace(/\\uFEFF|\\u200B/g, '');\n\n\t\t\t\t// Post process\n\t\t\t\tif (!args.no_events)\n\t\t\t\t\tonPostProcess.dispatch(self, args);\n\n\t\t\t\t// Restore the old document if it was changed\n\t\t\t\tif (oldDoc)\n\t\t\t\t\tdom.doc = oldDoc;\n\n\t\t\t\targs.node = null;\n\n\t\t\t\treturn args.content;\n\t\t\t},\n\n\t\t\taddRules : function(rules) {\n\t\t\t\tschema.addValidElements(rules);\n\t\t\t},\n\n\t\t\tsetRules : function(rules) {\n\t\t\t\tschema.setValidElements(rules);\n\t\t\t}\n\t\t};\n\t};\n})(tinymce);\n(function(tinymce) {\n\ttinymce.dom.ScriptLoader = function(settings) {\n\t\tvar QUEUED = 0,\n\t\t\tLOADING = 1,\n\t\t\tLOADED = 2,\n\t\t\tstates = {},\n\t\t\tqueue = [],\n\t\t\tscriptLoadedCallbacks = {},\n\t\t\tqueueLoadedCallbacks = [],\n\t\t\tloading = 0,\n\t\t\tundefined;\n\n\t\tfunction loadScript(url, callback) {\n\t\t\tvar t = this, dom = tinymce.DOM, elm, uri, loc, id;\n\n\t\t\t// Execute callback when script is loaded\n\t\t\tfunction done() {\n\t\t\t\tdom.remove(id);\n\n\t\t\t\tif (elm)\n\t\t\t\t\telm.onreadystatechange = elm.onload = elm = null;\n\n\t\t\t\tcallback();\n\t\t\t};\n\n\t\t\tfunction error() {\n\t\t\t\t// Report the error so it's easier for people to spot loading errors\n\t\t\t\tif (typeof(console) !== \"undefined\" && console.log)\n\t\t\t\t\tconsole.log(\"Failed to load: \" + url);\n\n\t\t\t\t// We can't mark it as done if there is a load error since\n\t\t\t\t// A) We don't want to produce 404 errors on the server and\n\t\t\t\t// B) the onerror event won't fire on all browsers.\n\t\t\t\t// done();\n\t\t\t};\n\n\t\t\tid = dom.uniqueId();\n\n\t\t\tif (tinymce.isIE6) {\n\t\t\t\turi = new tinymce.util.URI(url);\n\t\t\t\tloc = location;\n\n\t\t\t\t// If script is from same domain and we\n\t\t\t\t// use IE 6 then use XHR since it's more reliable\n\t\t\t\tif (uri.host == loc.hostname && uri.port == loc.port && (uri.protocol + ':') == loc.protocol && uri.protocol.toLowerCase() != 'file') {\n\t\t\t\t\ttinymce.util.XHR.send({\n\t\t\t\t\t\turl : tinymce._addVer(uri.getURI()),\n\t\t\t\t\t\tsuccess : function(content) {\n\t\t\t\t\t\t\t// Create new temp script element\n\t\t\t\t\t\t\tvar script = dom.create('script', {\n\t\t\t\t\t\t\t\ttype : 'text/javascript'\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t// Evaluate script in global scope\n\t\t\t\t\t\t\tscript.text = content;\n\t\t\t\t\t\t\tdocument.getElementsByTagName('head')[0].appendChild(script);\n\t\t\t\t\t\t\tdom.remove(script);\n\n\t\t\t\t\t\t\tdone();\n\t\t\t\t\t\t},\n\n\t\t\t\t\t\terror : error\n\t\t\t\t\t});\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Create new script element\n\t\t\telm = dom.create('script', {\n\t\t\t\tid : id,\n\t\t\t\ttype : 'text/javascript',\n\t\t\t\tsrc : tinymce._addVer(url)\n\t\t\t});\n\n\t\t\t// Add onload listener for non IE browsers since IE9\n\t\t\t// fires onload event before the script is parsed and executed\n\t\t\tif (!tinymce.isIE)\n\t\t\t\telm.onload = done;\n\n\t\t\t// Add onerror event will get fired on some browsers but not all of them\n\t\t\telm.onerror = error;\n\n\t\t\t// Opera 9.60 doesn't seem to fire the onreadystate event at correctly\n\t\t\tif (!tinymce.isOpera) {\n\t\t\t\telm.onreadystatechange = function() {\n\t\t\t\t\tvar state = elm.readyState;\n\n\t\t\t\t\t// Loaded state is passed on IE 6 however there\n\t\t\t\t\t// are known issues with this method but we can't use\n\t\t\t\t\t// XHR in a cross domain loading\n\t\t\t\t\tif (state == 'complete' || state == 'loaded')\n\t\t\t\t\t\tdone();\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t// Most browsers support this feature so we report errors\n\t\t\t// for those at least to help users track their missing plugins etc\n\t\t\t// todo: Removed since it produced error if the document is unloaded by navigating away, re-add it as an option\n\t\t\t/*elm.onerror = function() {\n\t\t\t\talert('Failed to load: ' + url);\n\t\t\t};*/\n\n\t\t\t// Add script to document\n\t\t\t(document.getElementsByTagName('head')[0] || document.body).appendChild(elm);\n\t\t};\n\n\t\tthis.isDone = function(url) {\n\t\t\treturn states[url] == LOADED;\n\t\t};\n\n\t\tthis.markDone = function(url) {\n\t\t\tstates[url] = LOADED;\n\t\t};\n\n\t\tthis.add = this.load = function(url, callback, scope) {\n\t\t\tvar item, state = states[url];\n\n\t\t\t// Add url to load queue\n\t\t\tif (state == undefined) {\n\t\t\t\tqueue.push(url);\n\t\t\t\tstates[url] = QUEUED;\n\t\t\t}\n\n\t\t\tif (callback) {\n\t\t\t\t// Store away callback for later execution\n\t\t\t\tif (!scriptLoadedCallbacks[url])\n\t\t\t\t\tscriptLoadedCallbacks[url] = [];\n\n\t\t\t\tscriptLoadedCallbacks[url].push({\n\t\t\t\t\tfunc : callback,\n\t\t\t\t\tscope : scope || this\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\tthis.loadQueue = function(callback, scope) {\n\t\t\tthis.loadScripts(queue, callback, scope);\n\t\t};\n\n\t\tthis.loadScripts = function(scripts, callback, scope) {\n\t\t\tvar loadScripts;\n\n\t\t\tfunction execScriptLoadedCallbacks(url) {\n\t\t\t\t// Execute URL callback functions\n\t\t\t\ttinymce.each(scriptLoadedCallbacks[url], function(callback) {\n\t\t\t\t\tcallback.func.call(callback.scope);\n\t\t\t\t});\n\n\t\t\t\tscriptLoadedCallbacks[url] = undefined;\n\t\t\t};\n\n\t\t\tqueueLoadedCallbacks.push({\n\t\t\t\tfunc : callback,\n\t\t\t\tscope : scope || this\n\t\t\t});\n\n\t\t\tloadScripts = function() {\n\t\t\t\tvar loadingScripts = tinymce.grep(scripts);\n\n\t\t\t\t// Current scripts has been handled\n\t\t\t\tscripts.length = 0;\n\n\t\t\t\t// Load scripts that needs to be loaded\n\t\t\t\ttinymce.each(loadingScripts, function(url) {\n\t\t\t\t\t// Script is already loaded then execute script callbacks directly\n\t\t\t\t\tif (states[url] == LOADED) {\n\t\t\t\t\t\texecScriptLoadedCallbacks(url);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Is script not loading then start loading it\n\t\t\t\t\tif (states[url] != LOADING) {\n\t\t\t\t\t\tstates[url] = LOADING;\n\t\t\t\t\t\tloading++;\n\n\t\t\t\t\t\tloadScript(url, function() {\n\t\t\t\t\t\t\tstates[url] = LOADED;\n\t\t\t\t\t\t\tloading--;\n\n\t\t\t\t\t\t\texecScriptLoadedCallbacks(url);\n\n\t\t\t\t\t\t\t// Load more scripts if they where added by the recently loaded script\n\t\t\t\t\t\t\tloadScripts();\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// No scripts are currently loading then execute all pending queue loaded callbacks\n\t\t\t\tif (!loading) {\n\t\t\t\t\ttinymce.each(queueLoadedCallbacks, function(callback) {\n\t\t\t\t\t\tcallback.func.call(callback.scope);\n\t\t\t\t\t});\n\n\t\t\t\t\tqueueLoadedCallbacks.length = 0;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tloadScripts();\n\t\t};\n\t};\n\n\t// Global script loader\n\ttinymce.ScriptLoader = new tinymce.dom.ScriptLoader();\n})(tinymce);\n\ntinymce.dom.TreeWalker = function(start_node, root_node) {\n\tvar node = start_node;\n\n\tfunction findSibling(node, start_name, sibling_name, shallow) {\n\t\tvar sibling, parent;\n\n\t\tif (node) {\n\t\t\t// Walk into nodes if it has a start\n\t\t\tif (!shallow && node[start_name])\n\t\t\t\treturn node[start_name];\n\n\t\t\t// Return the sibling if it has one\n\t\t\tif (node != root_node) {\n\t\t\t\tsibling = node[sibling_name];\n\t\t\t\tif (sibling)\n\t\t\t\t\treturn sibling;\n\n\t\t\t\t// Walk up the parents to look for siblings\n\t\t\t\tfor (parent = node.parentNode; parent && parent != root_node; parent = parent.parentNode) {\n\t\t\t\t\tsibling = parent[sibling_name];\n\t\t\t\t\tif (sibling)\n\t\t\t\t\t\treturn sibling;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t};\n\n\tthis.current = function() {\n\t\treturn node;\n\t};\n\n\tthis.next = function(shallow) {\n\t\treturn (node = findSibling(node, 'firstChild', 'nextSibling', shallow));\n\t};\n\n\tthis.prev = function(shallow) {\n\t\treturn (node = findSibling(node, 'lastChild', 'previousSibling', shallow));\n\t};\n};\n\n(function(tinymce) {\n\ttinymce.dom.RangeUtils = function(dom) {\n\t\tvar INVISIBLE_CHAR = '\\uFEFF';\n\n\t\tthis.walk = function(rng, callback) {\n\t\t\tvar startContainer = rng.startContainer,\n\t\t\t\tstartOffset = rng.startOffset,\n\t\t\t\tendContainer = rng.endContainer,\n\t\t\t\tendOffset = rng.endOffset,\n\t\t\t\tancestor, startPoint,\n\t\t\t\tendPoint, node, parent, siblings, nodes;\n\n\t\t\t// Handle table cell selection the table plugin enables\n\t\t\t// you to fake select table cells and perform formatting actions on them\n\t\t\tnodes = dom.select('td.mceSelected,th.mceSelected');\n\t\t\tif (nodes.length > 0) {\n\t\t\t\ttinymce.each(nodes, function(node) {\n\t\t\t\t\tcallback([node]);\n\t\t\t\t});\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tfunction exclude(nodes) {\n\t\t\t\tvar node;\n\n\t\t\t\t// First node is excluded\n\t\t\t\tnode = nodes[0];\n\t\t\t\tif (node.nodeType === 3 && node === startContainer && startOffset >= node.nodeValue.length) {\n\t\t\t\t\tnodes.splice(0, 1);\n\t\t\t\t}\n\n\t\t\t\t// Last node is excluded\n\t\t\t\tnode = nodes[nodes.length - 1];\n\t\t\t\tif (endOffset === 0 && nodes.length > 0 && node === endContainer && node.nodeType === 3) {\n\t\t\t\t\tnodes.splice(nodes.length - 1, 1);\n\t\t\t\t}\n\n\t\t\t\treturn nodes;\n\t\t\t};\n\n\t\t\tfunction collectSiblings(node, name, end_node) {\n\t\t\t\tvar siblings = [];\n\n\t\t\t\tfor (; node && node != end_node; node = node[name])\n\t\t\t\t\tsiblings.push(node);\n\n\t\t\t\treturn siblings;\n\t\t\t};\n\n\t\t\tfunction findEndPoint(node, root) {\n\t\t\t\tdo {\n\t\t\t\t\tif (node.parentNode == root)\n\t\t\t\t\t\treturn node;\n\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t} while(node);\n\t\t\t};\n\n\t\t\tfunction walkBoundary(start_node, end_node, next) {\n\t\t\t\tvar siblingName = next ? 'nextSibling' : 'previousSibling';\n\n\t\t\t\tfor (node = start_node, parent = node.parentNode; node && node != end_node; node = parent) {\n\t\t\t\t\tparent = node.parentNode;\n\t\t\t\t\tsiblings = collectSiblings(node == start_node ? node : node[siblingName], siblingName);\n\n\t\t\t\t\tif (siblings.length) {\n\t\t\t\t\t\tif (!next)\n\t\t\t\t\t\t\tsiblings.reverse();\n\n\t\t\t\t\t\tcallback(exclude(siblings));\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// If index based start position then resolve it\n\t\t\tif (startContainer.nodeType == 1 && startContainer.hasChildNodes())\n\t\t\t\tstartContainer = startContainer.childNodes[startOffset];\n\n\t\t\t// If index based end position then resolve it\n\t\t\tif (endContainer.nodeType == 1 && endContainer.hasChildNodes())\n\t\t\t\tendContainer = endContainer.childNodes[Math.min(endOffset - 1, endContainer.childNodes.length - 1)];\n\n\t\t\t// Same container\n\t\t\tif (startContainer == endContainer)\n\t\t\t\treturn callback(exclude([startContainer]));\n\n\t\t\t// Find common ancestor and end points\n\t\t\tancestor = dom.findCommonAncestor(startContainer, endContainer);\n\n\t\t\t// Process left side\n\t\t\tfor (node = startContainer; node; node = node.parentNode) {\n\t\t\t\tif (node === endContainer)\n\t\t\t\t\treturn walkBoundary(startContainer, ancestor, true);\n\n\t\t\t\tif (node === ancestor)\n\t\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\t// Process right side\n\t\t\tfor (node = endContainer; node; node = node.parentNode) {\n\t\t\t\tif (node === startContainer)\n\t\t\t\t\treturn walkBoundary(endContainer, ancestor);\n\n\t\t\t\tif (node === ancestor)\n\t\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\t// Find start/end point\n\t\t\tstartPoint = findEndPoint(startContainer, ancestor) || startContainer;\n\t\t\tendPoint = findEndPoint(endContainer, ancestor) || endContainer;\n\n\t\t\t// Walk left leaf\n\t\t\twalkBoundary(startContainer, startPoint, true);\n\n\t\t\t// Walk the middle from start to end point\n\t\t\tsiblings = collectSiblings(\n\t\t\t\tstartPoint == startContainer ? startPoint : startPoint.nextSibling,\n\t\t\t\t'nextSibling',\n\t\t\t\tendPoint == endContainer ? endPoint.nextSibling : endPoint\n\t\t\t);\n\n\t\t\tif (siblings.length)\n\t\t\t\tcallback(exclude(siblings));\n\n\t\t\t// Walk right leaf\n\t\t\twalkBoundary(endContainer, endPoint);\n\t\t};\n\n\t\tthis.split = function(rng) {\n\t\t\tvar startContainer = rng.startContainer,\n\t\t\t\tstartOffset = rng.startOffset,\n\t\t\t\tendContainer = rng.endContainer,\n\t\t\t\tendOffset = rng.endOffset;\n\n\t\t\tfunction splitText(node, offset) {\n\t\t\t\treturn node.splitText(offset);\n\t\t\t};\n\n\t\t\t// Handle single text node\n\t\t\tif (startContainer == endContainer && startContainer.nodeType == 3) {\n\t\t\t\tif (startOffset > 0 && startOffset < startContainer.nodeValue.length) {\n\t\t\t\t\tendContainer = splitText(startContainer, startOffset);\n\t\t\t\t\tstartContainer = endContainer.previousSibling;\n\n\t\t\t\t\tif (endOffset > startOffset) {\n\t\t\t\t\t\tendOffset = endOffset - startOffset;\n\t\t\t\t\t\tstartContainer = endContainer = splitText(endContainer, endOffset).previousSibling;\n\t\t\t\t\t\tendOffset = endContainer.nodeValue.length;\n\t\t\t\t\t\tstartOffset = 0;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tendOffset = 0;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Split startContainer text node if needed\n\t\t\t\tif (startContainer.nodeType == 3 && startOffset > 0 && startOffset < startContainer.nodeValue.length) {\n\t\t\t\t\tstartContainer = splitText(startContainer, startOffset);\n\t\t\t\t\tstartOffset = 0;\n\t\t\t\t}\n\n\t\t\t\t// Split endContainer text node if needed\n\t\t\t\tif (endContainer.nodeType == 3 && endOffset > 0 && endOffset < endContainer.nodeValue.length) {\n\t\t\t\t\tendContainer = splitText(endContainer, endOffset).previousSibling;\n\t\t\t\t\tendOffset = endContainer.nodeValue.length;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn {\n\t\t\t\tstartContainer : startContainer,\n\t\t\t\tstartOffset : startOffset,\n\t\t\t\tendContainer : endContainer,\n\t\t\t\tendOffset : endOffset\n\t\t\t};\n\t\t};\n\n\t};\n\n\ttinymce.dom.RangeUtils.compareRanges = function(rng1, rng2) {\n\t\tif (rng1 && rng2) {\n\t\t\t// Compare native IE ranges\n\t\t\tif (rng1.item || rng1.duplicate) {\n\t\t\t\t// Both are control ranges and the selected element matches\n\t\t\t\tif (rng1.item && rng2.item && rng1.item(0) === rng2.item(0))\n\t\t\t\t\treturn true;\n\n\t\t\t\t// Both are text ranges and the range matches\n\t\t\t\tif (rng1.isEqual && rng2.isEqual && rng2.isEqual(rng1))\n\t\t\t\t\treturn true;\n\t\t\t} else {\n\t\t\t\t// Compare w3c ranges\n\t\t\t\treturn rng1.startContainer == rng2.startContainer && rng1.startOffset == rng2.startOffset;\n\t\t\t}\n\t\t}\n\n\t\treturn false;\n\t};\n})(tinymce);\n\n(function(tinymce) {\n\tvar Event = tinymce.dom.Event, each = tinymce.each;\n\n\ttinymce.create('tinymce.ui.KeyboardNavigation', {\n\t\tKeyboardNavigation: function(settings, dom) {\n\t\t\tvar t = this, root = settings.root, items = settings.items,\n\t\t\t\t\tenableUpDown = settings.enableUpDown, enableLeftRight = settings.enableLeftRight || !settings.enableUpDown,\n\t\t\t\t\texcludeFromTabOrder = settings.excludeFromTabOrder,\n\t\t\t\t\titemFocussed, itemBlurred, rootKeydown, rootFocussed, focussedId;\n\n\t\t\tdom = dom || tinymce.DOM;\n\n\t\t\titemFocussed = function(evt) {\n\t\t\t\tfocussedId = evt.target.id;\n\t\t\t};\n\n\t\t\titemBlurred = function(evt) {\n\t\t\t\tdom.setAttrib(evt.target.id, 'tabindex', '-1');\n\t\t\t};\n\n\t\t\trootFocussed = function(evt) {\n\t\t\t\tvar item = dom.get(focussedId);\n\t\t\t\tdom.setAttrib(item, 'tabindex', '0');\n\t\t\t\titem.focus();\n\t\t\t};\n\n\t\t\tt.focus = function() {\n\t\t\t\tdom.get(focussedId).focus();\n\t\t\t};\n\n\t\t\tt.destroy = function() {\n\t\t\t\teach(items, function(item) {\n\t\t\t\t\tdom.unbind(dom.get(item.id), 'focus', itemFocussed);\n\t\t\t\t\tdom.unbind(dom.get(item.id), 'blur', itemBlurred);\n\t\t\t\t});\n\n\t\t\t\tdom.unbind(dom.get(root), 'focus', rootFocussed);\n\t\t\t\tdom.unbind(dom.get(root), 'keydown', rootKeydown);\n\n\t\t\t\titems = dom = root = t.focus = itemFocussed = itemBlurred = rootKeydown = rootFocussed = null;\n\t\t\t\tt.destroy = function() {};\n\t\t\t};\n\n\t\t\tt.moveFocus = function(dir, evt) {\n\t\t\t\tvar idx = -1, controls = t.controls, newFocus;\n\n\t\t\t\tif (!focussedId)\n\t\t\t\t\treturn;\n\n\t\t\t\teach(items, function(item, index) {\n\t\t\t\t\tif (item.id === focussedId) {\n\t\t\t\t\t\tidx = index;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tidx += dir;\n\t\t\t\tif (idx < 0) {\n\t\t\t\t\tidx = items.length - 1;\n\t\t\t\t} else if (idx >= items.length) {\n\t\t\t\t\tidx = 0;\n\t\t\t\t}\n\n\t\t\t\tnewFocus = items[idx];\n\t\t\t\tdom.setAttrib(focussedId, 'tabindex', '-1');\n\t\t\t\tdom.setAttrib(newFocus.id, 'tabindex', '0');\n\t\t\t\tdom.get(newFocus.id).focus();\n\n\t\t\t\tif (settings.actOnFocus) {\n\t\t\t\t\tsettings.onAction(newFocus.id);\n\t\t\t\t}\n\n\t\t\t\tif (evt)\n\t\t\t\t\tEvent.cancel(evt);\n\t\t\t};\n\n\t\t\trootKeydown = function(evt) {\n\t\t\t\tvar DOM_VK_LEFT = 37, DOM_VK_RIGHT = 39, DOM_VK_UP = 38, DOM_VK_DOWN = 40, DOM_VK_ESCAPE = 27, DOM_VK_ENTER = 14, DOM_VK_RETURN = 13, DOM_VK_SPACE = 32;\n\n\t\t\t\tswitch (evt.keyCode) {\n\t\t\t\t\tcase DOM_VK_LEFT:\n\t\t\t\t\t\tif (enableLeftRight) t.moveFocus(-1);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase DOM_VK_RIGHT:\n\t\t\t\t\t\tif (enableLeftRight) t.moveFocus(1);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase DOM_VK_UP:\n\t\t\t\t\t\tif (enableUpDown) t.moveFocus(-1);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase DOM_VK_DOWN:\n\t\t\t\t\t\tif (enableUpDown) t.moveFocus(1);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase DOM_VK_ESCAPE:\n\t\t\t\t\t\tif (settings.onCancel) {\n\t\t\t\t\t\t\tsettings.onCancel();\n\t\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase DOM_VK_ENTER:\n\t\t\t\t\tcase DOM_VK_RETURN:\n\t\t\t\t\tcase DOM_VK_SPACE:\n\t\t\t\t\t\tif (settings.onAction) {\n\t\t\t\t\t\t\tsettings.onAction(focussedId);\n\t\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Set up state and listeners for each item.\n\t\t\teach(items, function(item, idx) {\n\t\t\t\tvar tabindex;\n\n\t\t\t\tif (!item.id) {\n\t\t\t\t\titem.id = dom.uniqueId('_mce_item_');\n\t\t\t\t}\n\n\t\t\t\tif (excludeFromTabOrder) {\n\t\t\t\t\tdom.bind(item.id, 'blur', itemBlurred);\n\t\t\t\t\ttabindex = '-1';\n\t\t\t\t} else {\n\t\t\t\t\ttabindex = (idx === 0 ? '0' : '-1');\n\t\t\t\t}\n\n\t\t\t\tdom.setAttrib(item.id, 'tabindex', tabindex);\n\t\t\t\tdom.bind(dom.get(item.id), 'focus', itemFocussed);\n\t\t\t});\n\n\t\t\t// Setup initial state for root element.\n\t\t\tif (items[0]){\n\t\t\t\tfocussedId = items[0].id;\n\t\t\t}\n\n\t\t\tdom.setAttrib(root, 'tabindex', '-1');\n\n\t\t\t// Setup listeners for root element.\n\t\t\tdom.bind(dom.get(root), 'focus', rootFocussed);\n\t\t\tdom.bind(dom.get(root), 'keydown', rootKeydown);\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\t// Shorten class names\n\tvar DOM = tinymce.DOM, is = tinymce.is;\n\n\ttinymce.create('tinymce.ui.Control', {\n\t\tControl : function(id, s, editor) {\n\t\t\tthis.id = id;\n\t\t\tthis.settings = s = s || {};\n\t\t\tthis.rendered = false;\n\t\t\tthis.onRender = new tinymce.util.Dispatcher(this);\n\t\t\tthis.classPrefix = '';\n\t\t\tthis.scope = s.scope || this;\n\t\t\tthis.disabled = 0;\n\t\t\tthis.active = 0;\n\t\t\tthis.editor = editor;\n\t\t},\n\n\t\tsetAriaProperty : function(property, value) {\n\t\t\tvar element = DOM.get(this.id + '_aria') || DOM.get(this.id);\n\t\t\tif (element) {\n\t\t\t\tDOM.setAttrib(element, 'aria-' + property, !!value);\n\t\t\t}\n\t\t},\n\n\t\tfocus : function() {\n\t\t\tDOM.get(this.id).focus();\n\t\t},\n\n\t\tsetDisabled : function(s) {\n\t\t\tif (s != this.disabled) {\n\t\t\t\tthis.setAriaProperty('disabled', s);\n\n\t\t\t\tthis.setState('Disabled', s);\n\t\t\t\tthis.setState('Enabled', !s);\n\t\t\t\tthis.disabled = s;\n\t\t\t}\n\t\t},\n\n\t\tisDisabled : function() {\n\t\t\treturn this.disabled;\n\t\t},\n\n\t\tsetActive : function(s) {\n\t\t\tif (s != this.active) {\n\t\t\t\tthis.setState('Active', s);\n\t\t\t\tthis.active = s;\n\t\t\t\tthis.setAriaProperty('pressed', s);\n\t\t\t}\n\t\t},\n\n\t\tisActive : function() {\n\t\t\treturn this.active;\n\t\t},\n\n\t\tsetState : function(c, s) {\n\t\t\tvar n = DOM.get(this.id);\n\n\t\t\tc = this.classPrefix + c;\n\n\t\t\tif (s)\n\t\t\t\tDOM.addClass(n, c);\n\t\t\telse\n\t\t\t\tDOM.removeClass(n, c);\n\t\t},\n\n\t\tisRendered : function() {\n\t\t\treturn this.rendered;\n\t\t},\n\n\t\trenderHTML : function() {\n\t\t},\n\n\t\trenderTo : function(n) {\n\t\t\tDOM.setHTML(n, this.renderHTML());\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, b;\n\n\t\t\t// Set pending states\n\t\t\tif (is(t.disabled)) {\n\t\t\t\tb = t.disabled;\n\t\t\t\tt.disabled = -1;\n\t\t\t\tt.setDisabled(b);\n\t\t\t}\n\n\t\t\tif (is(t.active)) {\n\t\t\t\tb = t.active;\n\t\t\t\tt.active = -1;\n\t\t\t\tt.setActive(b);\n\t\t\t}\n\t\t},\n\n\t\tremove : function() {\n\t\t\tDOM.remove(this.id);\n\t\t\tthis.destroy();\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\ttinymce.dom.Event.clear(this.id);\n\t\t}\n\t});\n})(tinymce);\ntinymce.create('tinymce.ui.Container:tinymce.ui.Control', {\n\tContainer : function(id, s, editor) {\n\t\tthis.parent(id, s, editor);\n\n\t\tthis.controls = [];\n\n\t\tthis.lookup = {};\n\t},\n\n\tadd : function(c) {\n\t\tthis.lookup[c.id] = c;\n\t\tthis.controls.push(c);\n\n\t\treturn c;\n\t},\n\n\tget : function(n) {\n\t\treturn this.lookup[n];\n\t}\n});\n\n\ntinymce.create('tinymce.ui.Separator:tinymce.ui.Control', {\n\tSeparator : function(id, s) {\n\t\tthis.parent(id, s);\n\t\tthis.classPrefix = 'mceSeparator';\n\t\tthis.setDisabled(true);\n\t},\n\n\trenderHTML : function() {\n\t\treturn tinymce.DOM.createHTML('span', {'class' : this.classPrefix, role : 'separator', 'aria-orientation' : 'vertical', tabindex : '-1'});\n\t}\n});\n\n(function(tinymce) {\n\tvar is = tinymce.is, DOM = tinymce.DOM, each = tinymce.each, walk = tinymce.walk;\n\n\ttinymce.create('tinymce.ui.MenuItem:tinymce.ui.Control', {\n\t\tMenuItem : function(id, s) {\n\t\t\tthis.parent(id, s);\n\t\t\tthis.classPrefix = 'mceMenuItem';\n\t\t},\n\n\t\tsetSelected : function(s) {\n\t\t\tthis.setState('Selected', s);\n\t\t\tthis.setAriaProperty('checked', !!s);\n\t\t\tthis.selected = s;\n\t\t},\n\n\t\tisSelected : function() {\n\t\t\treturn this.selected;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this;\n\n\t\t\tt.parent();\n\n\t\t\t// Set pending state\n\t\t\tif (is(t.selected))\n\t\t\t\tt.setSelected(t.selected);\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar is = tinymce.is, DOM = tinymce.DOM, each = tinymce.each, walk = tinymce.walk;\n\n\ttinymce.create('tinymce.ui.Menu:tinymce.ui.MenuItem', {\n\t\tMenu : function(id, s) {\n\t\t\tvar t = this;\n\n\t\t\tt.parent(id, s);\n\t\t\tt.items = {};\n\t\t\tt.collapsed = false;\n\t\t\tt.menuCount = 0;\n\t\t\tt.onAddItem = new tinymce.util.Dispatcher(this);\n\t\t},\n\n\t\texpand : function(d) {\n\t\t\tvar t = this;\n\n\t\t\tif (d) {\n\t\t\t\twalk(t, function(o) {\n\t\t\t\t\tif (o.expand)\n\t\t\t\t\t\to.expand();\n\t\t\t\t}, 'items', t);\n\t\t\t}\n\n\t\t\tt.collapsed = false;\n\t\t},\n\n\t\tcollapse : function(d) {\n\t\t\tvar t = this;\n\n\t\t\tif (d) {\n\t\t\t\twalk(t, function(o) {\n\t\t\t\t\tif (o.collapse)\n\t\t\t\t\t\to.collapse();\n\t\t\t\t}, 'items', t);\n\t\t\t}\n\n\t\t\tt.collapsed = true;\n\t\t},\n\n\t\tisCollapsed : function() {\n\t\t\treturn this.collapsed;\n\t\t},\n\n\t\tadd : function(o) {\n\t\t\tif (!o.settings)\n\t\t\t\to = new tinymce.ui.MenuItem(o.id || DOM.uniqueId(), o);\n\n\t\t\tthis.onAddItem.dispatch(this, o);\n\n\t\t\treturn this.items[o.id] = o;\n\t\t},\n\n\t\taddSeparator : function() {\n\t\t\treturn this.add({separator : true});\n\t\t},\n\n\t\taddMenu : function(o) {\n\t\t\tif (!o.collapse)\n\t\t\t\to = this.createMenu(o);\n\n\t\t\tthis.menuCount++;\n\n\t\t\treturn this.add(o);\n\t\t},\n\n\t\thasMenus : function() {\n\t\t\treturn this.menuCount !== 0;\n\t\t},\n\n\t\tremove : function(o) {\n\t\t\tdelete this.items[o.id];\n\t\t},\n\n\t\tremoveAll : function() {\n\t\t\tvar t = this;\n\n\t\t\twalk(t, function(o) {\n\t\t\t\tif (o.removeAll)\n\t\t\t\t\to.removeAll();\n\t\t\t\telse\n\t\t\t\t\to.remove();\n\n\t\t\t\to.destroy();\n\t\t\t}, 'items', t);\n\n\t\t\tt.items = {};\n\t\t},\n\n\t\tcreateMenu : function(o) {\n\t\t\tvar m = new tinymce.ui.Menu(o.id || DOM.uniqueId(), o);\n\n\t\t\tm.onAddItem.add(this.onAddItem.dispatch, this.onAddItem);\n\n\t\t\treturn m;\n\t\t}\n\t});\n})(tinymce);\n(function(tinymce) {\n\tvar is = tinymce.is, DOM = tinymce.DOM, each = tinymce.each, Event = tinymce.dom.Event, Element = tinymce.dom.Element;\n\n\ttinymce.create('tinymce.ui.DropMenu:tinymce.ui.Menu', {\n\t\tDropMenu : function(id, s) {\n\t\t\ts = s || {};\n\t\t\ts.container = s.container || DOM.doc.body;\n\t\t\ts.offset_x = s.offset_x || 0;\n\t\t\ts.offset_y = s.offset_y || 0;\n\t\t\ts.vp_offset_x = s.vp_offset_x || 0;\n\t\t\ts.vp_offset_y = s.vp_offset_y || 0;\n\n\t\t\tif (is(s.icons) && !s.icons)\n\t\t\t\ts['class'] += ' mceNoIcons';\n\n\t\t\tthis.parent(id, s);\n\t\t\tthis.onShowMenu = new tinymce.util.Dispatcher(this);\n\t\t\tthis.onHideMenu = new tinymce.util.Dispatcher(this);\n\t\t\tthis.classPrefix = 'mceMenu';\n\t\t},\n\n\t\tcreateMenu : function(s) {\n\t\t\tvar t = this, cs = t.settings, m;\n\n\t\t\ts.container = s.container || cs.container;\n\t\t\ts.parent = t;\n\t\t\ts.constrain = s.constrain || cs.constrain;\n\t\t\ts['class'] = s['class'] || cs['class'];\n\t\t\ts.vp_offset_x = s.vp_offset_x || cs.vp_offset_x;\n\t\t\ts.vp_offset_y = s.vp_offset_y || cs.vp_offset_y;\n\t\t\ts.keyboard_focus = cs.keyboard_focus;\n\t\t\tm = new tinymce.ui.DropMenu(s.id || DOM.uniqueId(), s);\n\n\t\t\tm.onAddItem.add(t.onAddItem.dispatch, t.onAddItem);\n\n\t\t\treturn m;\n\t\t},\n\n\t\tfocus : function() {\n\t\t\tvar t = this;\n\t\t\tif (t.keyboardNav) {\n\t\t\t\tt.keyboardNav.focus();\n\t\t\t}\n\t\t},\n\n\t\tupdate : function() {\n\t\t\tvar t = this, s = t.settings, tb = DOM.get('menu_' + t.id + '_tbl'), co = DOM.get('menu_' + t.id + '_co'), tw, th;\n\n\t\t\ttw = s.max_width ? Math.min(tb.clientWidth, s.max_width) : tb.clientWidth;\n\t\t\tth = s.max_height ? Math.min(tb.clientHeight, s.max_height) : tb.clientHeight;\n\n\t\t\tif (!DOM.boxModel)\n\t\t\t\tt.element.setStyles({width : tw + 2, height : th + 2});\n\t\t\telse\n\t\t\t\tt.element.setStyles({width : tw, height : th});\n\n\t\t\tif (s.max_width)\n\t\t\t\tDOM.setStyle(co, 'width', tw);\n\n\t\t\tif (s.max_height) {\n\t\t\t\tDOM.setStyle(co, 'height', th);\n\n\t\t\t\tif (tb.clientHeight < s.max_height)\n\t\t\t\t\tDOM.setStyle(co, 'overflow', 'hidden');\n\t\t\t}\n\t\t},\n\n\t\tshowMenu : function(x, y, px) {\n\t\t\tvar t = this, s = t.settings, co, vp = DOM.getViewPort(), w, h, mx, my, ot = 2, dm, tb, cp = t.classPrefix;\n\n\t\t\tt.collapse(1);\n\n\t\t\tif (t.isMenuVisible)\n\t\t\t\treturn;\n\n\t\t\tif (!t.rendered) {\n\t\t\t\tco = DOM.add(t.settings.container, t.renderNode());\n\n\t\t\t\teach(t.items, function(o) {\n\t\t\t\t\to.postRender();\n\t\t\t\t});\n\n\t\t\t\tt.element = new Element('menu_' + t.id, {blocker : 1, container : s.container});\n\t\t\t} else\n\t\t\t\tco = DOM.get('menu_' + t.id);\n\n\t\t\t// Move layer out of sight unless it's Opera since it scrolls to top of page due to an bug\n\t\t\tif (!tinymce.isOpera)\n\t\t\t\tDOM.setStyles(co, {left : -0xFFFF , top : -0xFFFF});\n\n\t\t\tDOM.show(co);\n\t\t\tt.update();\n\n\t\t\tx += s.offset_x || 0;\n\t\t\ty += s.offset_y || 0;\n\t\t\tvp.w -= 4;\n\t\t\tvp.h -= 4;\n\n\t\t\t// Move inside viewport if not submenu\n\t\t\tif (s.constrain) {\n\t\t\t\tw = co.clientWidth - ot;\n\t\t\t\th = co.clientHeight - ot;\n\t\t\t\tmx = vp.x + vp.w;\n\t\t\t\tmy = vp.y + vp.h;\n\n\t\t\t\tif ((x + s.vp_offset_x + w) > mx)\n\t\t\t\t\tx = px ? px - w : Math.max(0, (mx - s.vp_offset_x) - w);\n\n\t\t\t\tif ((y + s.vp_offset_y + h) > my)\n\t\t\t\t\ty = Math.max(0, (my - s.vp_offset_y) - h);\n\t\t\t}\n\n\t\t\tDOM.setStyles(co, {left : x , top : y});\n\t\t\tt.element.update();\n\n\t\t\tt.isMenuVisible = 1;\n\t\t\tt.mouseClickFunc = Event.add(co, 'click', function(e) {\n\t\t\t\tvar m;\n\n\t\t\t\te = e.target;\n\n\t\t\t\tif (e && (e = DOM.getParent(e, 'tr')) && !DOM.hasClass(e, cp + 'ItemSub')) {\n\t\t\t\t\tm = t.items[e.id];\n\n\t\t\t\t\tif (m.isDisabled())\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tdm = t;\n\n\t\t\t\t\twhile (dm) {\n\t\t\t\t\t\tif (dm.hideMenu)\n\t\t\t\t\t\t\tdm.hideMenu();\n\n\t\t\t\t\t\tdm = dm.settings.parent;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (m.settings.onclick)\n\t\t\t\t\t\tm.settings.onclick(e);\n\n\t\t\t\t\treturn Event.cancel(e); // Cancel to fix onbeforeunload problem\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tif (t.hasMenus()) {\n\t\t\t\tt.mouseOverFunc = Event.add(co, 'mouseover', function(e) {\n\t\t\t\t\tvar m, r, mi;\n\n\t\t\t\t\te = e.target;\n\t\t\t\t\tif (e && (e = DOM.getParent(e, 'tr'))) {\n\t\t\t\t\t\tm = t.items[e.id];\n\n\t\t\t\t\t\tif (t.lastMenu)\n\t\t\t\t\t\t\tt.lastMenu.collapse(1);\n\n\t\t\t\t\t\tif (m.isDisabled())\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tif (e && DOM.hasClass(e, cp + 'ItemSub')) {\n\t\t\t\t\t\t\t//p = DOM.getPos(s.container);\n\t\t\t\t\t\t\tr = DOM.getRect(e);\n\t\t\t\t\t\t\tm.showMenu((r.x + r.w - ot), r.y - ot, r.x);\n\t\t\t\t\t\t\tt.lastMenu = m;\n\t\t\t\t\t\t\tDOM.addClass(DOM.get(m.id).firstChild, cp + 'ItemActive');\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tEvent.add(co, 'keydown', t._keyHandler, t);\n\n\t\t\tt.onShowMenu.dispatch(t);\n\n\t\t\tif (s.keyboard_focus) {\n\t\t\t\tt._setupKeyboardNav();\n\t\t\t}\n\t\t},\n\n\t\thideMenu : function(c) {\n\t\t\tvar t = this, co = DOM.get('menu_' + t.id), e;\n\n\t\t\tif (!t.isMenuVisible)\n\t\t\t\treturn;\n\n\t\t\tif (t.keyboardNav) t.keyboardNav.destroy();\n\t\t\tEvent.remove(co, 'mouseover', t.mouseOverFunc);\n\t\t\tEvent.remove(co, 'click', t.mouseClickFunc);\n\t\t\tEvent.remove(co, 'keydown', t._keyHandler);\n\t\t\tDOM.hide(co);\n\t\t\tt.isMenuVisible = 0;\n\n\t\t\tif (!c)\n\t\t\t\tt.collapse(1);\n\n\t\t\tif (t.element)\n\t\t\t\tt.element.hide();\n\n\t\t\tif (e = DOM.get(t.id))\n\t\t\t\tDOM.removeClass(e.firstChild, t.classPrefix + 'ItemActive');\n\n\t\t\tt.onHideMenu.dispatch(t);\n\t\t},\n\n\t\tadd : function(o) {\n\t\t\tvar t = this, co;\n\n\t\t\to = t.parent(o);\n\n\t\t\tif (t.isRendered && (co = DOM.get('menu_' + t.id)))\n\t\t\t\tt._add(DOM.select('tbody', co)[0], o);\n\n\t\t\treturn o;\n\t\t},\n\n\t\tcollapse : function(d) {\n\t\t\tthis.parent(d);\n\t\t\tthis.hideMenu(1);\n\t\t},\n\n\t\tremove : function(o) {\n\t\t\tDOM.remove(o.id);\n\t\t\tthis.destroy();\n\n\t\t\treturn this.parent(o);\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tvar t = this, co = DOM.get('menu_' + t.id);\n\n\t\t\tif (t.keyboardNav) t.keyboardNav.destroy();\n\t\t\tEvent.remove(co, 'mouseover', t.mouseOverFunc);\n\t\t\tEvent.remove(DOM.select('a', co), 'focus', t.mouseOverFunc);\n\t\t\tEvent.remove(co, 'click', t.mouseClickFunc);\n\t\t\tEvent.remove(co, 'keydown', t._keyHandler);\n\n\t\t\tif (t.element)\n\t\t\t\tt.element.remove();\n\n\t\t\tDOM.remove(co);\n\t\t},\n\n\t\trenderNode : function() {\n\t\t\tvar t = this, s = t.settings, n, tb, co, w;\n\n\t\t\tw = DOM.create('div', {role: 'listbox', id : 'menu_' + t.id, 'class' : s['class'], 'style' : 'position:absolute;left:0;top:0;z-index:200000;outline:0'});\n\t\t\tif (t.settings.parent) {\n\t\t\t\tDOM.setAttrib(w, 'aria-parent', 'menu_' + t.settings.parent.id);\n\t\t\t}\n\t\t\tco = DOM.add(w, 'div', {role: 'presentation', id : 'menu_' + t.id + '_co', 'class' : t.classPrefix + (s['class'] ? ' ' + s['class'] : '')});\n\t\t\tt.element = new Element('menu_' + t.id, {blocker : 1, container : s.container});\n\n\t\t\tif (s.menu_line)\n\t\t\t\tDOM.add(co, 'span', {'class' : t.classPrefix + 'Line'});\n\n//\t\t\tn = DOM.add(co, 'div', {id : 'menu_' + t.id + '_co', 'class' : 'mceMenuContainer'});\n\t\t\tn = DOM.add(co, 'table', {role: 'presentation', id : 'menu_' + t.id + '_tbl', border : 0, cellPadding : 0, cellSpacing : 0});\n\t\t\ttb = DOM.add(n, 'tbody');\n\n\t\t\teach(t.items, function(o) {\n\t\t\t\tt._add(tb, o);\n\t\t\t});\n\n\t\t\tt.rendered = true;\n\n\t\t\treturn w;\n\t\t},\n\n\t\t// Internal functions\n\t\t_setupKeyboardNav : function(){\n\t\t\tvar contextMenu, menuItems, t=this;\n\t\t\tcontextMenu = DOM.select('#menu_' + t.id)[0];\n\t\t\tmenuItems = DOM.select('a[role=option]', 'menu_' + t.id);\n\t\t\tmenuItems.splice(0,0,contextMenu);\n\t\t\tt.keyboardNav = new tinymce.ui.KeyboardNavigation({\n\t\t\t\troot: 'menu_' + t.id,\n\t\t\t\titems: menuItems,\n\t\t\t\tonCancel: function() {\n\t\t\t\t\tt.hideMenu();\n\t\t\t\t},\n\t\t\t\tenableUpDown: true\n\t\t\t});\n\t\t\tcontextMenu.focus();\n\t\t},\n\n\t\t_keyHandler : function(evt) {\n\t\t\tvar t = this, e;\n\t\t\tswitch (evt.keyCode) {\n\t\t\t\tcase 37: // Left\n\t\t\t\t\tif (t.settings.parent) {\n\t\t\t\t\t\tt.hideMenu();\n\t\t\t\t\t\tt.settings.parent.focus();\n\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tcase 39: // Right\n\t\t\t\t\tif (t.mouseOverFunc)\n\t\t\t\t\t\tt.mouseOverFunc(evt);\n\t\t\t\t\tbreak;\n\t\t\t}\n\t\t},\n\n\t\t_add : function(tb, o) {\n\t\t\tvar n, s = o.settings, a, ro, it, cp = this.classPrefix, ic;\n\n\t\t\tif (s.separator) {\n\t\t\t\tro = DOM.add(tb, 'tr', {id : o.id, 'class' : cp + 'ItemSeparator'});\n\t\t\t\tDOM.add(ro, 'td', {'class' : cp + 'ItemSeparator'});\n\n\t\t\t\tif (n = ro.previousSibling)\n\t\t\t\t\tDOM.addClass(n, 'mceLast');\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tn = ro = DOM.add(tb, 'tr', {id : o.id, 'class' : cp + 'Item ' + cp + 'ItemEnabled'});\n\t\t\tn = it = DOM.add(n, s.titleItem ? 'th' : 'td');\n\t\t\tn = a = DOM.add(n, 'a', {id: o.id + '_aria',  role: s.titleItem ? 'presentation' : 'option', href : 'javascript:;', onclick : \"return false;\", onmousedown : 'return false;'});\n\n\t\t\tif (s.parent) {\n\t\t\t\tDOM.setAttrib(a, 'aria-haspopup', 'true');\n\t\t\t\tDOM.setAttrib(a, 'aria-owns', 'menu_' + o.id);\n\t\t\t}\n\n\t\t\tDOM.addClass(it, s['class']);\n//\t\t\tn = DOM.add(n, 'span', {'class' : 'item'});\n\n\t\t\tic = DOM.add(n, 'span', {'class' : 'mceIcon' + (s.icon ? ' mce_' + s.icon : '')});\n\n\t\t\tif (s.icon_src)\n\t\t\t\tDOM.add(ic, 'img', {src : s.icon_src});\n\n\t\t\tn = DOM.add(n, s.element || 'span', {'class' : 'mceText', title : o.settings.title}, o.settings.title);\n\n\t\t\tif (o.settings.style)\n\t\t\t\tDOM.setAttrib(n, 'style', o.settings.style);\n\n\t\t\tif (tb.childNodes.length == 1)\n\t\t\t\tDOM.addClass(ro, 'mceFirst');\n\n\t\t\tif ((n = ro.previousSibling) && DOM.hasClass(n, cp + 'ItemSeparator'))\n\t\t\t\tDOM.addClass(ro, 'mceFirst');\n\n\t\t\tif (o.collapse)\n\t\t\t\tDOM.addClass(ro, cp + 'ItemSub');\n\n\t\t\tif (n = ro.previousSibling)\n\t\t\t\tDOM.removeClass(n, 'mceLast');\n\n\t\t\tDOM.addClass(ro, 'mceLast');\n\t\t}\n\t});\n})(tinymce);\n(function(tinymce) {\n\tvar DOM = tinymce.DOM;\n\n\ttinymce.create('tinymce.ui.Button:tinymce.ui.Control', {\n\t\tButton : function(id, s, ed) {\n\t\t\tthis.parent(id, s, ed);\n\t\t\tthis.classPrefix = 'mceButton';\n\t\t},\n\n\t\trenderHTML : function() {\n\t\t\tvar cp = this.classPrefix, s = this.settings, h, l;\n\n\t\t\tl = DOM.encode(s.label || '');\n\t\t\th = '<a role=\"button\" id=\"' + this.id + '\" href=\"javascript:;\" class=\"' + cp + ' ' + cp + 'Enabled ' + s['class'] + (l ? ' ' + cp + 'Labeled' : '') +'\" onmousedown=\"return false;\" onclick=\"return false;\" aria-labelledby=\"' + this.id + '_voice\" title=\"' + DOM.encode(s.title) + '\">';\n\t\t\tif (s.image && !(this.editor  &&this.editor.forcedHighContrastMode) )\n\t\t\t\th += '<img class=\"mceIcon\" src=\"' + s.image + '\" alt=\"' + DOM.encode(s.title) + '\" />' + l;\n\t\t\telse\n\t\t\t\th += '<span class=\"mceIcon ' + s['class'] + '\"></span>' + (l ? '<span class=\"' + cp + 'Label\">' + l + '</span>' : '');\n\n\t\t\th += '<span class=\"mceVoiceLabel mceIconOnly\" style=\"display: none;\" id=\"' + this.id + '_voice\">' + s.title + '</span>';\n\t\t\th += '</a>';\n\t\t\treturn h;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\ttinymce.dom.Event.add(t.id, 'click', function(e) {\n\t\t\t\tif (!t.isDisabled())\n\t\t\t\t\treturn s.onclick.call(s.scope, e);\n\t\t\t});\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each, Dispatcher = tinymce.util.Dispatcher;\n\n\ttinymce.create('tinymce.ui.ListBox:tinymce.ui.Control', {\n\t\tListBox : function(id, s, ed) {\n\t\t\tvar t = this;\n\n\t\t\tt.parent(id, s, ed);\n\n\t\t\tt.items = [];\n\n\t\t\tt.onChange = new Dispatcher(t);\n\n\t\t\tt.onPostRender = new Dispatcher(t);\n\n\t\t\tt.onAdd = new Dispatcher(t);\n\n\t\t\tt.onRenderMenu = new tinymce.util.Dispatcher(this);\n\n\t\t\tt.classPrefix = 'mceListBox';\n\t\t},\n\n\t\tselect : function(va) {\n\t\t\tvar t = this, fv, f;\n\n\t\t\tif (va == undefined)\n\t\t\t\treturn t.selectByIndex(-1);\n\n\t\t\t// Is string or number make function selector\n\t\t\tif (va && va.call)\n\t\t\t\tf = va;\n\t\t\telse {\n\t\t\t\tf = function(v) {\n\t\t\t\t\treturn v == va;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t// Do we need to do something?\n\t\t\tif (va != t.selectedValue) {\n\t\t\t\t// Find item\n\t\t\t\teach(t.items, function(o, i) {\n\t\t\t\t\tif (f(o.value)) {\n\t\t\t\t\t\tfv = 1;\n\t\t\t\t\t\tt.selectByIndex(i);\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tif (!fv)\n\t\t\t\t\tt.selectByIndex(-1);\n\t\t\t}\n\t\t},\n\n\t\tselectByIndex : function(idx) {\n\t\t\tvar t = this, e, o, label;\n\n\t\t\tif (idx != t.selectedIndex) {\n\t\t\t\te = DOM.get(t.id + '_text');\n\t\t\t\tlabel = DOM.get(t.id + '_voiceDesc');\n\t\t\t\to = t.items[idx];\n\n\t\t\t\tif (o) {\n\t\t\t\t\tt.selectedValue = o.value;\n\t\t\t\t\tt.selectedIndex = idx;\n\t\t\t\t\tDOM.setHTML(e, DOM.encode(o.title));\n\t\t\t\t\tDOM.setHTML(label, t.settings.title + \" - \" + o.title);\n\t\t\t\t\tDOM.removeClass(e, 'mceTitle');\n\t\t\t\t\tDOM.setAttrib(t.id, 'aria-valuenow', o.title);\n\t\t\t\t} else {\n\t\t\t\t\tDOM.setHTML(e, DOM.encode(t.settings.title));\n\t\t\t\t\tDOM.setHTML(label, DOM.encode(t.settings.title));\n\t\t\t\t\tDOM.addClass(e, 'mceTitle');\n\t\t\t\t\tt.selectedValue = t.selectedIndex = null;\n\t\t\t\t\tDOM.setAttrib(t.id, 'aria-valuenow', t.settings.title);\n\t\t\t\t}\n\t\t\t\te = 0;\n\t\t\t}\n\t\t},\n\n\t\tadd : function(n, v, o) {\n\t\t\tvar t = this;\n\n\t\t\to = o || {};\n\t\t\to = tinymce.extend(o, {\n\t\t\t\ttitle : n,\n\t\t\t\tvalue : v\n\t\t\t});\n\n\t\t\tt.items.push(o);\n\t\t\tt.onAdd.dispatch(t, o);\n\t\t},\n\n\t\tgetLength : function() {\n\t\t\treturn this.items.length;\n\t\t},\n\n\t\trenderHTML : function() {\n\t\t\tvar h = '', t = this, s = t.settings, cp = t.classPrefix;\n\n\t\t\th = '<span role=\"listbox\" aria-haspopup=\"true\" aria-labelledby=\"' + t.id +'_voiceDesc\" aria-describedby=\"' + t.id + '_voiceDesc\"><table role=\"presentation\" tabindex=\"0\" id=\"' + t.id + '\" cellpadding=\"0\" cellspacing=\"0\" class=\"' + cp + ' ' + cp + 'Enabled' + (s['class'] ? (' ' + s['class']) : '') + '\"><tbody><tr>';\n\t\t\th += '<td>' + DOM.createHTML('span', {id: t.id + '_voiceDesc', 'class': 'voiceLabel', style:'display:none;'}, t.settings.title);\n\t\t\th += DOM.createHTML('a', {id : t.id + '_text', tabindex : -1, href : 'javascript:;', 'class' : 'mceText', onclick : \"return false;\", onmousedown : 'return false;'}, DOM.encode(t.settings.title)) + '</td>';\n\t\t\th += '<td>' + DOM.createHTML('a', {id : t.id + '_open', tabindex : -1, href : 'javascript:;', 'class' : 'mceOpen', onclick : \"return false;\", onmousedown : 'return false;'}, '<span><span style=\"display:none;\" class=\"mceIconOnly\" aria-hidden=\"true\">\\u25BC</span></span>') + '</td>';\n\t\t\th += '</tr></tbody></table></span>';\n\n\t\t\treturn h;\n\t\t},\n\n\t\tshowMenu : function() {\n\t\t\tvar t = this, p2, e = DOM.get(this.id), m;\n\n\t\t\tif (t.isDisabled() || t.items.length == 0)\n\t\t\t\treturn;\n\n\t\t\tif (t.menu && t.menu.isMenuVisible)\n\t\t\t\treturn t.hideMenu();\n\n\t\t\tif (!t.isMenuRendered) {\n\t\t\t\tt.renderMenu();\n\t\t\t\tt.isMenuRendered = true;\n\t\t\t}\n\n\t\t\tp2 = DOM.getPos(e);\n\n\t\t\tm = t.menu;\n\t\t\tm.settings.offset_x = p2.x;\n\t\t\tm.settings.offset_y = p2.y;\n\t\t\tm.settings.keyboard_focus = !tinymce.isOpera; // Opera is buggy when it comes to auto focus\n\n\t\t\t// Select in menu\n\t\t\tif (t.oldID)\n\t\t\t\tm.items[t.oldID].setSelected(0);\n\n\t\t\teach(t.items, function(o) {\n\t\t\t\tif (o.value === t.selectedValue) {\n\t\t\t\t\tm.items[o.id].setSelected(1);\n\t\t\t\t\tt.oldID = o.id;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tm.showMenu(0, e.clientHeight);\n\n\t\t\tEvent.add(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\tDOM.addClass(t.id, t.classPrefix + 'Selected');\n\n\t\t\t//DOM.get(t.id + '_text').focus();\n\t\t},\n\n\t\thideMenu : function(e) {\n\t\t\tvar t = this;\n\n\t\t\tif (t.menu && t.menu.isMenuVisible) {\n\t\t\t\tDOM.removeClass(t.id, t.classPrefix + 'Selected');\n\n\t\t\t\t// Prevent double toogles by canceling the mouse click event to the button\n\t\t\t\tif (e && e.type == \"mousedown\" && (e.target.id == t.id + '_text' || e.target.id == t.id + '_open'))\n\t\t\t\t\treturn;\n\n\t\t\t\tif (!e || !DOM.getParent(e.target, '.mceMenu')) {\n\t\t\t\t\tDOM.removeClass(t.id, t.classPrefix + 'Selected');\n\t\t\t\t\tEvent.remove(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\t\t\tt.menu.hideMenu();\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\trenderMenu : function() {\n\t\t\tvar t = this, m;\n\n\t\t\tm = t.settings.control_manager.createDropMenu(t.id + '_menu', {\n\t\t\t\tmenu_line : 1,\n\t\t\t\t'class' : t.classPrefix + 'Menu mceNoIcons',\n\t\t\t\tmax_width : 150,\n\t\t\t\tmax_height : 150\n\t\t\t});\n\n\t\t\tm.onHideMenu.add(function() {\n\t\t\t\tt.hideMenu();\n\t\t\t\tt.focus();\n\t\t\t});\n\n\t\t\tm.add({\n\t\t\t\ttitle : t.settings.title,\n\t\t\t\t'class' : 'mceMenuItemTitle',\n\t\t\t\tonclick : function() {\n\t\t\t\t\tif (t.settings.onselect('') !== false)\n\t\t\t\t\t\tt.select(''); // Must be runned after\n\t\t\t\t}\n\t\t\t});\n\n\t\t\teach(t.items, function(o) {\n\t\t\t\t// No value then treat it as a title\n\t\t\t\tif (o.value === undefined) {\n\t\t\t\t\tm.add({\n\t\t\t\t\t\ttitle : o.title,\n\t\t\t\t\t\trole : \"option\",\n\t\t\t\t\t\t'class' : 'mceMenuItemTitle',\n\t\t\t\t\t\tonclick : function() {\n\t\t\t\t\t\t\tif (t.settings.onselect('') !== false)\n\t\t\t\t\t\t\t\tt.select(''); // Must be runned after\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\to.id = DOM.uniqueId();\n\t\t\t\t\to.role= \"option\";\n\t\t\t\t\to.onclick = function() {\n\t\t\t\t\t\tif (t.settings.onselect(o.value) !== false)\n\t\t\t\t\t\t\tt.select(o.value); // Must be runned after\n\t\t\t\t\t};\n\n\t\t\t\t\tm.add(o);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.onRenderMenu.dispatch(t, m);\n\t\t\tt.menu = m;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, cp = t.classPrefix;\n\n\t\t\tEvent.add(t.id, 'click', t.showMenu, t);\n\t\t\tEvent.add(t.id, 'keydown', function(evt) {\n\t\t\t\tif (evt.keyCode == 32) { // Space\n\t\t\t\t\tt.showMenu(evt);\n\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t}\n\t\t\t});\n\t\t\tEvent.add(t.id, 'focus', function() {\n\t\t\t\tif (!t._focused) {\n\t\t\t\t\tt.keyDownHandler = Event.add(t.id, 'keydown', function(e) {\n\t\t\t\t\t\tif (e.keyCode == 40) {\n\t\t\t\t\t\t\tt.showMenu();\n\t\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tt.keyPressHandler = Event.add(t.id, 'keypress', function(e) {\n\t\t\t\t\t\tvar v;\n\t\t\t\t\t\tif (e.keyCode == 13) {\n\t\t\t\t\t\t\t// Fake select on enter\n\t\t\t\t\t\t\tv = t.selectedValue;\n\t\t\t\t\t\t\tt.selectedValue = null; // Needs to be null to fake change\n\t\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t\t\t\tt.settings.onselect(v);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tt._focused = 1;\n\t\t\t});\n\t\t\tEvent.add(t.id, 'blur', function() {\n\t\t\t\tEvent.remove(t.id, 'keydown', t.keyDownHandler);\n\t\t\t\tEvent.remove(t.id, 'keypress', t.keyPressHandler);\n\t\t\t\tt._focused = 0;\n\t\t\t});\n\n\t\t\t// Old IE doesn't have hover on all elements\n\t\t\tif (tinymce.isIE6 || !DOM.boxModel) {\n\t\t\t\tEvent.add(t.id, 'mouseover', function() {\n\t\t\t\t\tif (!DOM.hasClass(t.id, cp + 'Disabled'))\n\t\t\t\t\t\tDOM.addClass(t.id, cp + 'Hover');\n\t\t\t\t});\n\n\t\t\t\tEvent.add(t.id, 'mouseout', function() {\n\t\t\t\t\tif (!DOM.hasClass(t.id, cp + 'Disabled'))\n\t\t\t\t\t\tDOM.removeClass(t.id, cp + 'Hover');\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tt.onPostRender.dispatch(t, DOM.get(t.id));\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tthis.parent();\n\n\t\t\tEvent.clear(this.id + '_text');\n\t\t\tEvent.clear(this.id + '_open');\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each, Dispatcher = tinymce.util.Dispatcher;\n\n\ttinymce.create('tinymce.ui.NativeListBox:tinymce.ui.ListBox', {\n\t\tNativeListBox : function(id, s) {\n\t\t\tthis.parent(id, s);\n\t\t\tthis.classPrefix = 'mceNativeListBox';\n\t\t},\n\n\t\tsetDisabled : function(s) {\n\t\t\tDOM.get(this.id).disabled = s;\n\t\t\tthis.setAriaProperty('disabled', s);\n\t\t},\n\n\t\tisDisabled : function() {\n\t\t\treturn DOM.get(this.id).disabled;\n\t\t},\n\n\t\tselect : function(va) {\n\t\t\tvar t = this, fv, f;\n\n\t\t\tif (va == undefined)\n\t\t\t\treturn t.selectByIndex(-1);\n\n\t\t\t// Is string or number make function selector\n\t\t\tif (va && va.call)\n\t\t\t\tf = va;\n\t\t\telse {\n\t\t\t\tf = function(v) {\n\t\t\t\t\treturn v == va;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t// Do we need to do something?\n\t\t\tif (va != t.selectedValue) {\n\t\t\t\t// Find item\n\t\t\t\teach(t.items, function(o, i) {\n\t\t\t\t\tif (f(o.value)) {\n\t\t\t\t\t\tfv = 1;\n\t\t\t\t\t\tt.selectByIndex(i);\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tif (!fv)\n\t\t\t\t\tt.selectByIndex(-1);\n\t\t\t}\n\t\t},\n\n\t\tselectByIndex : function(idx) {\n\t\t\tDOM.get(this.id).selectedIndex = idx + 1;\n\t\t\tthis.selectedValue = this.items[idx] ? this.items[idx].value : null;\n\t\t},\n\n\t\tadd : function(n, v, a) {\n\t\t\tvar o, t = this;\n\n\t\t\ta = a || {};\n\t\t\ta.value = v;\n\n\t\t\tif (t.isRendered())\n\t\t\t\tDOM.add(DOM.get(this.id), 'option', a, n);\n\n\t\t\to = {\n\t\t\t\ttitle : n,\n\t\t\t\tvalue : v,\n\t\t\t\tattribs : a\n\t\t\t};\n\n\t\t\tt.items.push(o);\n\t\t\tt.onAdd.dispatch(t, o);\n\t\t},\n\n\t\tgetLength : function() {\n\t\t\treturn this.items.length;\n\t\t},\n\n\t\trenderHTML : function() {\n\t\t\tvar h, t = this;\n\n\t\t\th = DOM.createHTML('option', {value : ''}, '-- ' + t.settings.title + ' --');\n\n\t\t\teach(t.items, function(it) {\n\t\t\t\th += DOM.createHTML('option', {value : it.value}, it.title);\n\t\t\t});\n\n\t\t\th = DOM.createHTML('select', {id : t.id, 'class' : 'mceNativeListBox', 'aria-labelledby': t.id + '_aria'}, h);\n\t\t\th += DOM.createHTML('span', {id : t.id + '_aria', 'style': 'display: none'}, t.settings.title);\n\t\t\treturn h;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, ch, changeListenerAdded = true;\n\n\t\t\tt.rendered = true;\n\n\t\t\tfunction onChange(e) {\n\t\t\t\tvar v = t.items[e.target.selectedIndex - 1];\n\n\t\t\t\tif (v && (v = v.value)) {\n\t\t\t\t\tt.onChange.dispatch(t, v);\n\n\t\t\t\t\tif (t.settings.onselect)\n\t\t\t\t\t\tt.settings.onselect(v);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tEvent.add(t.id, 'change', onChange);\n\n\t\t\t// Accessibility keyhandler\n\t\t\tEvent.add(t.id, 'keydown', function(e) {\n\t\t\t\tvar bf;\n\n\t\t\t\tEvent.remove(t.id, 'change', ch);\n\t\t\t\tchangeListenerAdded = false;\n\n\t\t\t\tbf = Event.add(t.id, 'blur', function() {\n\t\t\t\t\tif (changeListenerAdded) return;\n\t\t\t\t\tchangeListenerAdded = true;\n\t\t\t\t\tEvent.add(t.id, 'change', onChange);\n\t\t\t\t\tEvent.remove(t.id, 'blur', bf);\n\t\t\t\t});\n\n\t\t\t\t//prevent default left and right keys on chrome - so that the keyboard navigation is used.\n\t\t\t\tif (tinymce.isWebKit && (e.keyCode==37 ||e.keyCode==39)) {\n\t\t\t\t\treturn Event.prevent(e);\n\t\t\t\t}\n\n\t\t\t\tif (e.keyCode == 13 || e.keyCode == 32) {\n\t\t\t\t\tonChange(e);\n\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.onPostRender.dispatch(t, DOM.get(t.id));\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each;\n\n\ttinymce.create('tinymce.ui.MenuButton:tinymce.ui.Button', {\n\t\tMenuButton : function(id, s, ed) {\n\t\t\tthis.parent(id, s, ed);\n\n\t\t\tthis.onRenderMenu = new tinymce.util.Dispatcher(this);\n\n\t\t\ts.menu_container = s.menu_container || DOM.doc.body;\n\t\t},\n\n\t\tshowMenu : function() {\n\t\t\tvar t = this, p1, p2, e = DOM.get(t.id), m;\n\n\t\t\tif (t.isDisabled())\n\t\t\t\treturn;\n\n\t\t\tif (!t.isMenuRendered) {\n\t\t\t\tt.renderMenu();\n\t\t\t\tt.isMenuRendered = true;\n\t\t\t}\n\n\t\t\tif (t.isMenuVisible)\n\t\t\t\treturn t.hideMenu();\n\n\t\t\tp1 = DOM.getPos(t.settings.menu_container);\n\t\t\tp2 = DOM.getPos(e);\n\n\t\t\tm = t.menu;\n\t\t\tm.settings.offset_x = p2.x;\n\t\t\tm.settings.offset_y = p2.y;\n\t\t\tm.settings.vp_offset_x = p2.x;\n\t\t\tm.settings.vp_offset_y = p2.y;\n\t\t\tm.settings.keyboard_focus = t._focused;\n\t\t\tm.showMenu(0, e.clientHeight);\n\n\t\t\tEvent.add(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\tt.setState('Selected', 1);\n\n\t\t\tt.isMenuVisible = 1;\n\t\t},\n\n\t\trenderMenu : function() {\n\t\t\tvar t = this, m;\n\n\t\t\tm = t.settings.control_manager.createDropMenu(t.id + '_menu', {\n\t\t\t\tmenu_line : 1,\n\t\t\t\t'class' : this.classPrefix + 'Menu',\n\t\t\t\ticons : t.settings.icons\n\t\t\t});\n\n\t\t\tm.onHideMenu.add(function() {\n\t\t\t\tt.hideMenu();\n\t\t\t\tt.focus();\n\t\t\t});\n\n\t\t\tt.onRenderMenu.dispatch(t, m);\n\t\t\tt.menu = m;\n\t\t},\n\n\t\thideMenu : function(e) {\n\t\t\tvar t = this;\n\n\t\t\t// Prevent double toogles by canceling the mouse click event to the button\n\t\t\tif (e && e.type == \"mousedown\" && DOM.getParent(e.target, function(e) {return e.id === t.id || e.id === t.id + '_open';}))\n\t\t\t\treturn;\n\n\t\t\tif (!e || !DOM.getParent(e.target, '.mceMenu')) {\n\t\t\t\tt.setState('Selected', 0);\n\t\t\t\tEvent.remove(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\t\tif (t.menu)\n\t\t\t\t\tt.menu.hideMenu();\n\t\t\t}\n\n\t\t\tt.isMenuVisible = 0;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\tEvent.add(t.id, 'click', function() {\n\t\t\t\tif (!t.isDisabled()) {\n\t\t\t\t\tif (s.onclick)\n\t\t\t\t\t\ts.onclick(t.value);\n\n\t\t\t\t\tt.showMenu();\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each;\n\n\ttinymce.create('tinymce.ui.SplitButton:tinymce.ui.MenuButton', {\n\t\tSplitButton : function(id, s, ed) {\n\t\t\tthis.parent(id, s, ed);\n\t\t\tthis.classPrefix = 'mceSplitButton';\n\t\t},\n\n\t\trenderHTML : function() {\n\t\t\tvar h, t = this, s = t.settings, h1;\n\n\t\t\th = '<tbody><tr>';\n\n\t\t\tif (s.image)\n\t\t\t\th1 = DOM.createHTML('img ', {src : s.image, role: 'presentation', 'class' : 'mceAction ' + s['class']});\n\t\t\telse\n\t\t\t\th1 = DOM.createHTML('span', {'class' : 'mceAction ' + s['class']}, '');\n\n\t\t\th1 += DOM.createHTML('span', {'class': 'mceVoiceLabel mceIconOnly', id: t.id + '_voice', style: 'display:none;'}, s.title);\n\t\t\th += '<td >' + DOM.createHTML('a', {role: 'button', id : t.id + '_action', tabindex: '-1', href : 'javascript:;', 'class' : 'mceAction ' + s['class'], onclick : \"return false;\", onmousedown : 'return false;', title : s.title}, h1) + '</td>';\n\n\t\t\th1 = DOM.createHTML('span', {'class' : 'mceOpen ' + s['class']}, '<span style=\"display:none;\" class=\"mceIconOnly\" aria-hidden=\"true\">\\u25BC</span>');\n\t\t\th += '<td >' + DOM.createHTML('a', {role: 'button', id : t.id + '_open', tabindex: '-1', href : 'javascript:;', 'class' : 'mceOpen ' + s['class'], onclick : \"return false;\", onmousedown : 'return false;', title : s.title}, h1) + '</td>';\n\n\t\t\th += '</tr></tbody>';\n\t\t\th = DOM.createHTML('table', { role: 'presentation',   'class' : 'mceSplitButton mceSplitButtonEnabled ' + s['class'], cellpadding : '0', cellspacing : '0', title : s.title}, h);\n\t\t\treturn DOM.createHTML('div', {id : t.id, role: 'button', tabindex: '0', 'aria-labelledby': t.id + '_voice', 'aria-haspopup': 'true'}, h);\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, s = t.settings, activate;\n\n\t\t\tif (s.onclick) {\n\t\t\t\tactivate = function(evt) {\n\t\t\t\t\tif (!t.isDisabled()) {\n\t\t\t\t\t\ts.onclick(t.value);\n\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t\tEvent.add(t.id + '_action', 'click', activate);\n\t\t\t\tEvent.add(t.id, ['click', 'keydown'], function(evt) {\n\t\t\t\t\tvar DOM_VK_SPACE = 32, DOM_VK_ENTER = 14, DOM_VK_RETURN = 13, DOM_VK_UP = 38, DOM_VK_DOWN = 40;\n\t\t\t\t\tif ((evt.keyCode === 32 || evt.keyCode === 13 || evt.keyCode === 14) && !evt.altKey && !evt.ctrlKey && !evt.metaKey) {\n\t\t\t\t\t\tactivate();\n\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t} else if (evt.type === 'click' || evt.keyCode === DOM_VK_DOWN) {\n\t\t\t\t\t\tt.showMenu();\n\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tEvent.add(t.id + '_open', 'click', function (evt) {\n\t\t\t\tt.showMenu();\n\t\t\t\tEvent.cancel(evt);\n\t\t\t});\n\t\t\tEvent.add([t.id, t.id + '_open'], 'focus', function() {t._focused = 1;});\n\t\t\tEvent.add([t.id, t.id + '_open'], 'blur', function() {t._focused = 0;});\n\n\t\t\t// Old IE doesn't have hover on all elements\n\t\t\tif (tinymce.isIE6 || !DOM.boxModel) {\n\t\t\t\tEvent.add(t.id, 'mouseover', function() {\n\t\t\t\t\tif (!DOM.hasClass(t.id, 'mceSplitButtonDisabled'))\n\t\t\t\t\t\tDOM.addClass(t.id, 'mceSplitButtonHover');\n\t\t\t\t});\n\n\t\t\t\tEvent.add(t.id, 'mouseout', function() {\n\t\t\t\t\tif (!DOM.hasClass(t.id, 'mceSplitButtonDisabled'))\n\t\t\t\t\t\tDOM.removeClass(t.id, 'mceSplitButtonHover');\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tthis.parent();\n\n\t\t\tEvent.clear(this.id + '_action');\n\t\t\tEvent.clear(this.id + '_open');\n\t\t\tEvent.clear(this.id);\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, is = tinymce.is, each = tinymce.each;\n\n\ttinymce.create('tinymce.ui.ColorSplitButton:tinymce.ui.SplitButton', {\n\t\tColorSplitButton : function(id, s, ed) {\n\t\t\tvar t = this;\n\n\t\t\tt.parent(id, s, ed);\n\n\t\t\tt.settings = s = tinymce.extend({\n\t\t\t\tcolors : '000000,993300,333300,003300,003366,000080,333399,333333,800000,FF6600,808000,008000,008080,0000FF,666699,808080,FF0000,FF9900,99CC00,339966,33CCCC,3366FF,800080,999999,FF00FF,FFCC00,FFFF00,00FF00,00FFFF,00CCFF,993366,C0C0C0,FF99CC,FFCC99,FFFF99,CCFFCC,CCFFFF,99CCFF,CC99FF,FFFFFF',\n\t\t\t\tgrid_width : 8,\n\t\t\t\tdefault_color : '#888888'\n\t\t\t}, t.settings);\n\n\t\t\tt.onShowMenu = new tinymce.util.Dispatcher(t);\n\n\t\t\tt.onHideMenu = new tinymce.util.Dispatcher(t);\n\n\t\t\tt.value = s.default_color;\n\t\t},\n\n\t\tshowMenu : function() {\n\t\t\tvar t = this, r, p, e, p2;\n\n\t\t\tif (t.isDisabled())\n\t\t\t\treturn;\n\n\t\t\tif (!t.isMenuRendered) {\n\t\t\t\tt.renderMenu();\n\t\t\t\tt.isMenuRendered = true;\n\t\t\t}\n\n\t\t\tif (t.isMenuVisible)\n\t\t\t\treturn t.hideMenu();\n\n\t\t\te = DOM.get(t.id);\n\t\t\tDOM.show(t.id + '_menu');\n\t\t\tDOM.addClass(e, 'mceSplitButtonSelected');\n\t\t\tp2 = DOM.getPos(e);\n\t\t\tDOM.setStyles(t.id + '_menu', {\n\t\t\t\tleft : p2.x,\n\t\t\t\ttop : p2.y + e.clientHeight,\n\t\t\t\tzIndex : 200000\n\t\t\t});\n\t\t\te = 0;\n\n\t\t\tEvent.add(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\tt.onShowMenu.dispatch(t);\n\n\t\t\tif (t._focused) {\n\t\t\t\tt._keyHandler = Event.add(t.id + '_menu', 'keydown', function(e) {\n\t\t\t\t\tif (e.keyCode == 27)\n\t\t\t\t\t\tt.hideMenu();\n\t\t\t\t});\n\n\t\t\t\tDOM.select('a', t.id + '_menu')[0].focus(); // Select first link\n\t\t\t}\n\n\t\t\tt.isMenuVisible = 1;\n\t\t},\n\n\t\thideMenu : function(e) {\n\t\t\tvar t = this;\n\n\t\t\tif (t.isMenuVisible) {\n\t\t\t\t// Prevent double toogles by canceling the mouse click event to the button\n\t\t\t\tif (e && e.type == \"mousedown\" && DOM.getParent(e.target, function(e) {return e.id === t.id + '_open';}))\n\t\t\t\t\treturn;\n\n\t\t\t\tif (!e || !DOM.getParent(e.target, '.mceSplitButtonMenu')) {\n\t\t\t\t\tDOM.removeClass(t.id, 'mceSplitButtonSelected');\n\t\t\t\t\tEvent.remove(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\t\t\tEvent.remove(t.id + '_menu', 'keydown', t._keyHandler);\n\t\t\t\t\tDOM.hide(t.id + '_menu');\n\t\t\t\t}\n\n\t\t\t\tt.isMenuVisible = 0;\n\t\t\t\tt.onHideMenu.dispatch();\n\t\t\t}\n\t\t},\n\n\t\trenderMenu : function() {\n\t\t\tvar t = this, m, i = 0, s = t.settings, n, tb, tr, w, context;\n\n\t\t\tw = DOM.add(s.menu_container, 'div', {role: 'listbox', id : t.id + '_menu', 'class' : s['menu_class'] + ' ' + s['class'], style : 'position:absolute;left:0;top:-1000px;'});\n\t\t\tm = DOM.add(w, 'div', {'class' : s['class'] + ' mceSplitButtonMenu'});\n\t\t\tDOM.add(m, 'span', {'class' : 'mceMenuLine'});\n\n\t\t\tn = DOM.add(m, 'table', {role: 'presentation', 'class' : 'mceColorSplitMenu'});\n\t\t\ttb = DOM.add(n, 'tbody');\n\n\t\t\t// Generate color grid\n\t\t\ti = 0;\n\t\t\teach(is(s.colors, 'array') ? s.colors : s.colors.split(','), function(c) {\n\t\t\t\tc = c.replace(/^#/, '');\n\n\t\t\t\tif (!i--) {\n\t\t\t\t\ttr = DOM.add(tb, 'tr');\n\t\t\t\t\ti = s.grid_width - 1;\n\t\t\t\t}\n\n\t\t\t\tn = DOM.add(tr, 'td');\n\t\t\t\tn = DOM.add(n, 'a', {\n\t\t\t\t\trole : 'option',\n\t\t\t\t\thref : 'javascript:;',\n\t\t\t\t\tstyle : {\n\t\t\t\t\t\tbackgroundColor : '#' + c\n\t\t\t\t\t},\n\t\t\t\t\t'title': t.editor.getLang('colors.' + c, c),\n\t\t\t\t\t'data-mce-color' : '#' + c\n\t\t\t\t});\n\n\t\t\t\tif (t.editor.forcedHighContrastMode) {\n\t\t\t\t\tn = DOM.add(n, 'canvas', { width: 16, height: 16, 'aria-hidden': 'true' });\n\t\t\t\t\tif (n.getContext && (context = n.getContext(\"2d\"))) {\n\t\t\t\t\t\tcontext.fillStyle = '#' + c;\n\t\t\t\t\t\tcontext.fillRect(0, 0, 16, 16);\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// No point leaving a canvas element around if it's not supported for drawing on anyway.\n\t\t\t\t\t\tDOM.remove(n);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tif (s.more_colors_func) {\n\t\t\t\tn = DOM.add(tb, 'tr');\n\t\t\t\tn = DOM.add(n, 'td', {colspan : s.grid_width, 'class' : 'mceMoreColors'});\n\t\t\t\tn = DOM.add(n, 'a', {role: 'option', id : t.id + '_more', href : 'javascript:;', onclick : 'return false;', 'class' : 'mceMoreColors'}, s.more_colors_title);\n\n\t\t\t\tEvent.add(n, 'click', function(e) {\n\t\t\t\t\ts.more_colors_func.call(s.more_colors_scope || this);\n\t\t\t\t\treturn Event.cancel(e); // Cancel to fix onbeforeunload problem\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tDOM.addClass(m, 'mceColorSplitMenu');\n\n\t\t\tnew tinymce.ui.KeyboardNavigation({\n\t\t\t\troot: t.id + '_menu',\n\t\t\t\titems: DOM.select('a', t.id + '_menu'),\n\t\t\t\tonCancel: function() {\n\t\t\t\t\tt.hideMenu();\n\t\t\t\t\tt.focus();\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Prevent IE from scrolling and hindering click to occur #4019\n\t\t\tEvent.add(t.id + '_menu', 'mousedown', function(e) {return Event.cancel(e);});\n\n\t\t\tEvent.add(t.id + '_menu', 'click', function(e) {\n\t\t\t\tvar c;\n\n\t\t\t\te = DOM.getParent(e.target, 'a', tb);\n\n\t\t\t\tif (e && e.nodeName.toLowerCase() == 'a' && (c = e.getAttribute('data-mce-color')))\n\t\t\t\t\tt.setColor(c);\n\n\t\t\t\treturn Event.cancel(e); // Prevent IE auto save warning\n\t\t\t});\n\n\t\t\treturn w;\n\t\t},\n\n\t\tsetColor : function(c) {\n\t\t\tthis.displayColor(c);\n\t\t\tthis.hideMenu();\n\t\t\tthis.settings.onselect(c);\n\t\t},\n\n\t\tdisplayColor : function(c) {\n\t\t\tvar t = this;\n\n\t\t\tDOM.setStyle(t.id + '_preview', 'backgroundColor', c);\n\n\t\t\tt.value = c;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, id = t.id;\n\n\t\t\tt.parent();\n\t\t\tDOM.add(id + '_action', 'div', {id : id + '_preview', 'class' : 'mceColorPreview'});\n\t\t\tDOM.setStyle(t.id + '_preview', 'backgroundColor', t.value);\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tthis.parent();\n\n\t\t\tEvent.clear(this.id + '_menu');\n\t\t\tEvent.clear(this.id + '_more');\n\t\t\tDOM.remove(this.id + '_menu');\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n// Shorten class names\nvar dom = tinymce.DOM, each = tinymce.each, Event = tinymce.dom.Event;\ntinymce.create('tinymce.ui.ToolbarGroup:tinymce.ui.Container', {\n\trenderHTML : function() {\n\t\tvar t = this, h = [], controls = t.controls, each = tinymce.each, settings = t.settings;\n\n\t\th.push('<div id=\"' + t.id + '\" role=\"group\" aria-labelledby=\"' + t.id + '_voice\">');\n\t\t//TODO: ACC test this out - adding a role = application for getting the landmarks working well.\n\t\th.push(\"<span role='application'>\");\n\t\th.push('<span id=\"' + t.id + '_voice\" class=\"mceVoiceLabel\" style=\"display:none;\">' + dom.encode(settings.name) + '</span>');\n\t\teach(controls, function(toolbar) {\n\t\t\th.push(toolbar.renderHTML());\n\t\t});\n\t\th.push(\"</span>\");\n\t\th.push('</div>');\n\n\t\treturn h.join('');\n\t},\n\n\tfocus : function() {\n\t\tvar t = this;\n\t\tdom.get(t.id).focus();\n\t},\n\n\tpostRender : function() {\n\t\tvar t = this, items = [];\n\n\t\teach(t.controls, function(toolbar) {\n\t\t\teach (toolbar.controls, function(control) {\n\t\t\t\tif (control.id) {\n\t\t\t\t\titems.push(control);\n\t\t\t\t}\n\t\t\t});\n\t\t});\n\n\t\tt.keyNav = new tinymce.ui.KeyboardNavigation({\n\t\t\troot: t.id,\n\t\t\titems: items,\n\t\t\tonCancel: function() {\n\t\t\t\t//Move focus if webkit so that navigation back will read the item.\n\t\t\t\tif (tinymce.isWebKit) {\n\t\t\t\t\tdom.get(t.editor.id+\"_ifr\").focus();\n\t\t\t\t}\n\t\t\t\tt.editor.focus();\n\t\t\t},\n\t\t\texcludeFromTabOrder: !t.settings.tab_focus_toolbar\n\t\t});\n\t},\n\n\tdestroy : function() {\n\t\tvar self = this;\n\n\t\tself.parent();\n\t\tself.keyNav.destroy();\n\t\tEvent.clear(self.id);\n\t}\n});\n})(tinymce);\n\n(function(tinymce) {\n// Shorten class names\nvar dom = tinymce.DOM, each = tinymce.each;\ntinymce.create('tinymce.ui.Toolbar:tinymce.ui.Container', {\n\trenderHTML : function() {\n\t\tvar t = this, h = '', c, co, s = t.settings, i, pr, nx, cl;\n\n\t\tcl = t.controls;\n\t\tfor (i=0; i<cl.length; i++) {\n\t\t\t// Get current control, prev control, next control and if the control is a list box or not\n\t\t\tco = cl[i];\n\t\t\tpr = cl[i - 1];\n\t\t\tnx = cl[i + 1];\n\n\t\t\t// Add toolbar start\n\t\t\tif (i === 0) {\n\t\t\t\tc = 'mceToolbarStart';\n\n\t\t\t\tif (co.Button)\n\t\t\t\t\tc += ' mceToolbarStartButton';\n\t\t\t\telse if (co.SplitButton)\n\t\t\t\t\tc += ' mceToolbarStartSplitButton';\n\t\t\t\telse if (co.ListBox)\n\t\t\t\t\tc += ' mceToolbarStartListBox';\n\n\t\t\t\th += dom.createHTML('td', {'class' : c}, dom.createHTML('span', null, '<!-- IE -->'));\n\t\t\t}\n\n\t\t\t// Add toolbar end before list box and after the previous button\n\t\t\t// This is to fix the o2k7 editor skins\n\t\t\tif (pr && co.ListBox) {\n\t\t\t\tif (pr.Button || pr.SplitButton)\n\t\t\t\t\th += dom.createHTML('td', {'class' : 'mceToolbarEnd'}, dom.createHTML('span', null, '<!-- IE -->'));\n\t\t\t}\n\n\t\t\t// Render control HTML\n\n\t\t\t// IE 8 quick fix, needed to propertly generate a hit area for anchors\n\t\t\tif (dom.stdMode)\n\t\t\t\th += '<td style=\"position: relative\">' + co.renderHTML() + '</td>';\n\t\t\telse\n\t\t\t\th += '<td>' + co.renderHTML() + '</td>';\n\n\t\t\t// Add toolbar start after list box and before the next button\n\t\t\t// This is to fix the o2k7 editor skins\n\t\t\tif (nx && co.ListBox) {\n\t\t\t\tif (nx.Button || nx.SplitButton)\n\t\t\t\t\th += dom.createHTML('td', {'class' : 'mceToolbarStart'}, dom.createHTML('span', null, '<!-- IE -->'));\n\t\t\t}\n\t\t}\n\n\t\tc = 'mceToolbarEnd';\n\n\t\tif (co.Button)\n\t\t\tc += ' mceToolbarEndButton';\n\t\telse if (co.SplitButton)\n\t\t\tc += ' mceToolbarEndSplitButton';\n\t\telse if (co.ListBox)\n\t\t\tc += ' mceToolbarEndListBox';\n\n\t\th += dom.createHTML('td', {'class' : c}, dom.createHTML('span', null, '<!-- IE -->'));\n\n\t\treturn dom.createHTML('table', {id : t.id, 'class' : 'mceToolbar' + (s['class'] ? ' ' + s['class'] : ''), cellpadding : '0', cellspacing : '0', align : t.settings.align || '', role: 'presentation', tabindex: '-1'}, '<tbody><tr>' + h + '</tr></tbody>');\n\t}\n});\n})(tinymce);\n\n(function(tinymce) {\n\tvar Dispatcher = tinymce.util.Dispatcher, each = tinymce.each;\n\n\ttinymce.create('tinymce.AddOnManager', {\n\t\tAddOnManager : function() {\n\t\t\tvar self = this;\n\n\t\t\tself.items = [];\n\t\t\tself.urls = {};\n\t\t\tself.lookup = {};\n\t\t\tself.onAdd = new Dispatcher(self);\n\t\t},\n\n\t\tget : function(n) {\n\t\t\tif (this.lookup[n]) {\n\t\t\t\treturn this.lookup[n].instance;\n\t\t\t} else {\n\t\t\t\treturn undefined;\n\t\t\t}\n\t\t},\n\n\t\tdependencies : function(n) {\n\t\t\tvar result;\n\t\t\tif (this.lookup[n]) {\n\t\t\t\tresult = this.lookup[n].dependencies;\n\t\t\t}\n\t\t\treturn result || [];\n\t\t},\n\n\t\trequireLangPack : function(n) {\n\t\t\tvar s = tinymce.settings;\n\n\t\t\tif (s && s.language && s.language_load !== false)\n\t\t\t\ttinymce.ScriptLoader.add(this.urls[n] + '/langs/' + s.language + '.js');\n\t\t},\n\n\t\tadd : function(id, o, dependencies) {\n\t\t\tthis.items.push(o);\n\t\t\tthis.lookup[id] = {instance:o, dependencies:dependencies};\n\t\t\tthis.onAdd.dispatch(this, id, o);\n\n\t\t\treturn o;\n\t\t},\n\t\tcreateUrl: function(baseUrl, dep) {\n\t\t\tif (typeof dep === \"object\") {\n\t\t\t\treturn dep\n\t\t\t} else {\n\t\t\t\treturn {prefix: baseUrl.prefix, resource: dep, suffix: baseUrl.suffix};\n\t\t\t}\n\t\t},\n\n\t\taddComponents: function(pluginName, scripts) {\n\t\t\tvar pluginUrl = this.urls[pluginName];\n\t\t\ttinymce.each(scripts, function(script){\n\t\t\t\ttinymce.ScriptLoader.add(pluginUrl+\"/\"+script);\n\t\t\t});\n\t\t},\n\n\t\tload : function(n, u, cb, s) {\n\t\t\tvar t = this, url = u;\n\n\t\t\tfunction loadDependencies() {\n\t\t\t\tvar dependencies = t.dependencies(n);\n\t\t\t\ttinymce.each(dependencies, function(dep) {\n\t\t\t\t\tvar newUrl = t.createUrl(u, dep);\n\t\t\t\t\tt.load(newUrl.resource, newUrl, undefined, undefined);\n\t\t\t\t});\n\t\t\t\tif (cb) {\n\t\t\t\t\tif (s) {\n\t\t\t\t\t\tcb.call(s);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tcb.call(tinymce.ScriptLoader);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (t.urls[n])\n\t\t\t\treturn;\n\t\t\tif (typeof u === \"object\")\n\t\t\t\turl = u.prefix + u.resource + u.suffix;\n\n\t\t\tif (url.indexOf('/') != 0 && url.indexOf('://') == -1)\n\t\t\t\turl = tinymce.baseURL + '/' + url;\n\n\t\t\tt.urls[n] = url.substring(0, url.lastIndexOf('/'));\n\n\t\t\tif (t.lookup[n]) {\n\t\t\t\tloadDependencies();\n\t\t\t} else {\n\t\t\t\ttinymce.ScriptLoader.add(url, loadDependencies, s);\n\t\t\t}\n\t\t}\n\t});\n\n\t// Create plugin and theme managers\n\ttinymce.PluginManager = new tinymce.AddOnManager();\n\ttinymce.ThemeManager = new tinymce.AddOnManager();\n}(tinymce));\n\n(function(tinymce) {\n\t// Shorten names\n\tvar each = tinymce.each, extend = tinymce.extend,\n\t\tDOM = tinymce.DOM, Event = tinymce.dom.Event,\n\t\tThemeManager = tinymce.ThemeManager, PluginManager = tinymce.PluginManager,\n\t\texplode = tinymce.explode,\n\t\tDispatcher = tinymce.util.Dispatcher, undefined, instanceCounter = 0;\n\n\t// Setup some URLs where the editor API is located and where the document is\n\ttinymce.documentBaseURL = window.location.href.replace(/[\\?#].*$/, '').replace(/[\\/\\\\][^\\/]+$/, '');\n\tif (!/[\\/\\\\]$/.test(tinymce.documentBaseURL))\n\t\ttinymce.documentBaseURL += '/';\n\n\ttinymce.baseURL = new tinymce.util.URI(tinymce.documentBaseURL).toAbsolute(tinymce.baseURL);\n\n\ttinymce.baseURI = new tinymce.util.URI(tinymce.baseURL);\n\n\t// Add before unload listener\n\t// This was required since IE was leaking memory if you added and removed beforeunload listeners\n\t// with attachEvent/detatchEvent so this only adds one listener and instances can the attach to the onBeforeUnload event\n\ttinymce.onBeforeUnload = new Dispatcher(tinymce);\n\n\t// Must be on window or IE will leak if the editor is placed in frame or iframe\n\tEvent.add(window, 'beforeunload', function(e) {\n\t\ttinymce.onBeforeUnload.dispatch(tinymce, e);\n\t});\n\n\ttinymce.onAddEditor = new Dispatcher(tinymce);\n\n\ttinymce.onRemoveEditor = new Dispatcher(tinymce);\n\n\ttinymce.EditorManager = extend(tinymce, {\n\t\teditors : [],\n\n\t\ti18n : {},\n\n\t\tactiveEditor : null,\n\n\t\tinit : function(s) {\n\t\t\tvar t = this, pl, sl = tinymce.ScriptLoader, e, el = [], ed;\n\n\t\t\tfunction execCallback(se, n, s) {\n\t\t\t\tvar f = se[n];\n\n\t\t\t\tif (!f)\n\t\t\t\t\treturn;\n\n\t\t\t\tif (tinymce.is(f, 'string')) {\n\t\t\t\t\ts = f.replace(/\\.\\w+$/, '');\n\t\t\t\t\ts = s ? tinymce.resolve(s) : 0;\n\t\t\t\t\tf = tinymce.resolve(f);\n\t\t\t\t}\n\n\t\t\t\treturn f.apply(s || this, Array.prototype.slice.call(arguments, 2));\n\t\t\t};\n\n\t\t\ts = extend({\n\t\t\t\ttheme : \"simple\",\n\t\t\t\tlanguage : \"en\"\n\t\t\t}, s);\n\n\t\t\tt.settings = s;\n\n\t\t\t// Legacy call\n\t\t\tEvent.add(document, 'init', function() {\n\t\t\t\tvar l, co;\n\n\t\t\t\texecCallback(s, 'onpageload');\n\n\t\t\t\tswitch (s.mode) {\n\t\t\t\t\tcase \"exact\":\n\t\t\t\t\t\tl = s.elements || '';\n\n\t\t\t\t\t\tif(l.length > 0) {\n\t\t\t\t\t\t\teach(explode(l), function(v) {\n\t\t\t\t\t\t\t\tif (DOM.get(v)) {\n\t\t\t\t\t\t\t\t\ted = new tinymce.Editor(v, s);\n\t\t\t\t\t\t\t\t\tel.push(ed);\n\t\t\t\t\t\t\t\t\ted.render(1);\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\teach(document.forms, function(f) {\n\t\t\t\t\t\t\t\t\t\teach(f.elements, function(e) {\n\t\t\t\t\t\t\t\t\t\t\tif (e.name === v) {\n\t\t\t\t\t\t\t\t\t\t\t\tv = 'mce_editor_' + instanceCounter++;\n\t\t\t\t\t\t\t\t\t\t\t\tDOM.setAttrib(e, 'id', v);\n\n\t\t\t\t\t\t\t\t\t\t\t\ted = new tinymce.Editor(v, s);\n\t\t\t\t\t\t\t\t\t\t\t\tel.push(ed);\n\t\t\t\t\t\t\t\t\t\t\t\ted.render(1);\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase \"textareas\":\n\t\t\t\t\tcase \"specific_textareas\":\n\t\t\t\t\t\tfunction hasClass(n, c) {\n\t\t\t\t\t\t\treturn c.constructor === RegExp ? c.test(n.className) : DOM.hasClass(n, c);\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\teach(DOM.select('textarea'), function(v) {\n\t\t\t\t\t\t\tif (s.editor_deselector && hasClass(v, s.editor_deselector))\n\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\tif (!s.editor_selector || hasClass(v, s.editor_selector)) {\n\t\t\t\t\t\t\t\t// Can we use the name\n\t\t\t\t\t\t\t\te = DOM.get(v.name);\n\t\t\t\t\t\t\t\tif (!v.id && !e)\n\t\t\t\t\t\t\t\t\tv.id = v.name;\n\n\t\t\t\t\t\t\t\t// Generate unique name if missing or already exists\n\t\t\t\t\t\t\t\tif (!v.id || t.get(v.id))\n\t\t\t\t\t\t\t\t\tv.id = DOM.uniqueId();\n\n\t\t\t\t\t\t\t\ted = new tinymce.Editor(v.id, s);\n\t\t\t\t\t\t\t\tel.push(ed);\n\t\t\t\t\t\t\t\ted.render(1);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\t// Call onInit when all editors are initialized\n\t\t\t\tif (s.oninit) {\n\t\t\t\t\tl = co = 0;\n\n\t\t\t\t\teach(el, function(ed) {\n\t\t\t\t\t\tco++;\n\n\t\t\t\t\t\tif (!ed.initialized) {\n\t\t\t\t\t\t\t// Wait for it\n\t\t\t\t\t\t\ted.onInit.add(function() {\n\t\t\t\t\t\t\t\tl++;\n\n\t\t\t\t\t\t\t\t// All done\n\t\t\t\t\t\t\t\tif (l == co)\n\t\t\t\t\t\t\t\t\texecCallback(s, 'oninit');\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\tl++;\n\n\t\t\t\t\t\t// All done\n\t\t\t\t\t\tif (l == co)\n\t\t\t\t\t\t\texecCallback(s, 'oninit');\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\tget : function(id) {\n\t\t\tif (id === undefined)\n\t\t\t\treturn this.editors;\n\n\t\t\treturn this.editors[id];\n\t\t},\n\n\t\tgetInstanceById : function(id) {\n\t\t\treturn this.get(id);\n\t\t},\n\n\t\tadd : function(editor) {\n\t\t\tvar self = this, editors = self.editors;\n\n\t\t\t// Add named and index editor instance\n\t\t\teditors[editor.id] = editor;\n\t\t\teditors.push(editor);\n\n\t\t\tself._setActive(editor);\n\t\t\tself.onAddEditor.dispatch(self, editor);\n\n\n\t\t\treturn editor;\n\t\t},\n\n\t\tremove : function(editor) {\n\t\t\tvar t = this, i, editors = t.editors;\n\n\t\t\t// Not in the collection\n\t\t\tif (!editors[editor.id])\n\t\t\t\treturn null;\n\n\t\t\tdelete editors[editor.id];\n\n\t\t\tfor (i = 0; i < editors.length; i++) {\n\t\t\t\tif (editors[i] == editor) {\n\t\t\t\t\teditors.splice(i, 1);\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Select another editor since the active one was removed\n\t\t\tif (t.activeEditor == editor)\n\t\t\t\tt._setActive(editors[0]);\n\n\t\t\teditor.destroy();\n\t\t\tt.onRemoveEditor.dispatch(t, editor);\n\n\t\t\treturn editor;\n\t\t},\n\n\t\texecCommand : function(c, u, v) {\n\t\t\tvar t = this, ed = t.get(v), w;\n\n\t\t\t// Manager commands\n\t\t\tswitch (c) {\n\t\t\t\tcase \"mceFocus\":\n\t\t\t\t\ted.focus();\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase \"mceAddEditor\":\n\t\t\t\tcase \"mceAddControl\":\n\t\t\t\t\tif (!t.get(v))\n\t\t\t\t\t\tnew tinymce.Editor(v, t.settings).render();\n\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase \"mceAddFrameControl\":\n\t\t\t\t\tw = v.window;\n\n\t\t\t\t\t// Add tinyMCE global instance and tinymce namespace to specified window\n\t\t\t\t\tw.tinyMCE = tinyMCE;\n\t\t\t\t\tw.tinymce = tinymce;\n\n\t\t\t\t\ttinymce.DOM.doc = w.document;\n\t\t\t\t\ttinymce.DOM.win = w;\n\n\t\t\t\t\ted = new tinymce.Editor(v.element_id, v);\n\t\t\t\t\ted.render();\n\n\t\t\t\t\t// Fix IE memory leaks\n\t\t\t\t\tif (tinymce.isIE) {\n\t\t\t\t\t\tfunction clr() {\n\t\t\t\t\t\t\ted.destroy();\n\t\t\t\t\t\t\tw.detachEvent('onunload', clr);\n\t\t\t\t\t\t\tw = w.tinyMCE = w.tinymce = null; // IE leak\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tw.attachEvent('onunload', clr);\n\t\t\t\t\t}\n\n\t\t\t\t\tv.page_window = null;\n\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase \"mceRemoveEditor\":\n\t\t\t\tcase \"mceRemoveControl\":\n\t\t\t\t\tif (ed)\n\t\t\t\t\t\ted.remove();\n\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase 'mceToggleEditor':\n\t\t\t\t\tif (!ed) {\n\t\t\t\t\t\tt.execCommand('mceAddControl', 0, v);\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (ed.isHidden())\n\t\t\t\t\t\ted.show();\n\t\t\t\t\telse\n\t\t\t\t\t\ted.hide();\n\n\t\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Run command on active editor\n\t\t\tif (t.activeEditor)\n\t\t\t\treturn t.activeEditor.execCommand(c, u, v);\n\n\t\t\treturn false;\n\t\t},\n\n\t\texecInstanceCommand : function(id, c, u, v) {\n\t\t\tvar ed = this.get(id);\n\n\t\t\tif (ed)\n\t\t\t\treturn ed.execCommand(c, u, v);\n\n\t\t\treturn false;\n\t\t},\n\n\t\ttriggerSave : function() {\n\t\t\teach(this.editors, function(e) {\n\t\t\t\te.save();\n\t\t\t});\n\t\t},\n\n\t\taddI18n : function(p, o) {\n\t\t\tvar lo, i18n = this.i18n;\n\n\t\t\tif (!tinymce.is(p, 'string')) {\n\t\t\t\teach(p, function(o, lc) {\n\t\t\t\t\teach(o, function(o, g) {\n\t\t\t\t\t\teach(o, function(o, k) {\n\t\t\t\t\t\t\tif (g === 'common')\n\t\t\t\t\t\t\t\ti18n[lc + '.' + k] = o;\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\ti18n[lc + '.' + g + '.' + k] = o;\n\t\t\t\t\t\t});\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\teach(o, function(o, k) {\n\t\t\t\t\ti18n[p + '.' + k] = o;\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\t// Private methods\n\n\t\t_setActive : function(editor) {\n\t\t\tthis.selectedInstance = this.activeEditor = editor;\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\t// Shorten these names\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, extend = tinymce.extend,\n\t\tDispatcher = tinymce.util.Dispatcher, each = tinymce.each, isGecko = tinymce.isGecko,\n\t\tisIE = tinymce.isIE, isWebKit = tinymce.isWebKit, is = tinymce.is,\n\t\tThemeManager = tinymce.ThemeManager, PluginManager = tinymce.PluginManager,\n\t\tinArray = tinymce.inArray, grep = tinymce.grep, explode = tinymce.explode;\n\n\ttinymce.create('tinymce.Editor', {\n\t\tEditor : function(id, s) {\n\t\t\tvar t = this;\n\n\t\t\tt.id = t.editorId = id;\n\n\t\t\tt.execCommands = {};\n\t\t\tt.queryStateCommands = {};\n\t\t\tt.queryValueCommands = {};\n\n\t\t\tt.isNotDirty = false;\n\n\t\t\tt.plugins = {};\n\n\t\t\t// Add events to the editor\n\t\t\teach([\n\t\t\t\t'onPreInit',\n\n\t\t\t\t'onBeforeRenderUI',\n\n\t\t\t\t'onPostRender',\n\n\t\t\t\t'onInit',\n\n\t\t\t\t'onRemove',\n\n\t\t\t\t'onActivate',\n\n\t\t\t\t'onDeactivate',\n\n\t\t\t\t'onClick',\n\n\t\t\t\t'onEvent',\n\n\t\t\t\t'onMouseUp',\n\n\t\t\t\t'onMouseDown',\n\n\t\t\t\t'onDblClick',\n\n\t\t\t\t'onKeyDown',\n\n\t\t\t\t'onKeyUp',\n\n\t\t\t\t'onKeyPress',\n\n\t\t\t\t'onContextMenu',\n\n\t\t\t\t'onSubmit',\n\n\t\t\t\t'onReset',\n\n\t\t\t\t'onPaste',\n\n\t\t\t\t'onPreProcess',\n\n\t\t\t\t'onPostProcess',\n\n\t\t\t\t'onBeforeSetContent',\n\n\t\t\t\t'onBeforeGetContent',\n\n\t\t\t\t'onSetContent',\n\n\t\t\t\t'onGetContent',\n\n\t\t\t\t'onLoadContent',\n\n\t\t\t\t'onSaveContent',\n\n\t\t\t\t'onNodeChange',\n\n\t\t\t\t'onChange',\n\n\t\t\t\t'onBeforeExecCommand',\n\n\t\t\t\t'onExecCommand',\n\n\t\t\t\t'onUndo',\n\n\t\t\t\t'onRedo',\n\n\t\t\t\t'onVisualAid',\n\n\t\t\t\t'onSetProgressState'\n\t\t\t], function(e) {\n\t\t\t\tt[e] = new Dispatcher(t);\n\t\t\t});\n\n\t\t\tt.settings = s = extend({\n\t\t\t\tid : id,\n\t\t\t\tlanguage : 'en',\n\t\t\t\tdocs_language : 'en',\n\t\t\t\ttheme : 'simple',\n\t\t\t\tskin : 'default',\n\t\t\t\tdelta_width : 0,\n\t\t\t\tdelta_height : 0,\n\t\t\t\tpopup_css : '',\n\t\t\t\tplugins : '',\n\t\t\t\tdocument_base_url : tinymce.documentBaseURL,\n\t\t\t\tadd_form_submit_trigger : 1,\n\t\t\t\tsubmit_patch : 1,\n\t\t\t\tadd_unload_trigger : 1,\n\t\t\t\tconvert_urls : 1,\n\t\t\t\trelative_urls : 1,\n\t\t\t\tremove_script_host : 1,\n\t\t\t\ttable_inline_editing : 0,\n\t\t\t\tobject_resizing : 1,\n\t\t\t\tcleanup : 1,\n\t\t\t\taccessibility_focus : 1,\n\t\t\t\tcustom_shortcuts : 1,\n\t\t\t\tcustom_undo_redo_keyboard_shortcuts : 1,\n\t\t\t\tcustom_undo_redo_restore_selection : 1,\n\t\t\t\tcustom_undo_redo : 1,\n\t\t\t\tdoctype : tinymce.isIE6 ? '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">' : '<!DOCTYPE>', // Use old doctype on IE 6 to avoid horizontal scroll\n\t\t\t\tvisual_table_class : 'mceItemTable',\n\t\t\t\tvisual : 1,\n\t\t\t\tfont_size_style_values : 'xx-small,x-small,small,medium,large,x-large,xx-large',\n\t\t\t\tfont_size_legacy_values : 'xx-small,small,medium,large,x-large,xx-large,300%', // See: http://www.w3.org/TR/CSS2/fonts.html#propdef-font-size\n\t\t\t\tapply_source_formatting : 1,\n\t\t\t\tdirectionality : 'ltr',\n\t\t\t\tforced_root_block : 'p',\n\t\t\t\thidden_input : 1,\n\t\t\t\tpadd_empty_editor : 1,\n\t\t\t\trender_ui : 1,\n\t\t\t\tinit_theme : 1,\n\t\t\t\tforce_p_newlines : 1,\n\t\t\t\tindentation : '30px',\n\t\t\t\tkeep_styles : 1,\n\t\t\t\tfix_table_elements : 1,\n\t\t\t\tinline_styles : 1,\n\t\t\t\tconvert_fonts_to_spans : true,\n\t\t\t\tindent : 'simple',\n\t\t\t\tindent_before : 'p,h1,h2,h3,h4,h5,h6,blockquote,div,title,style,pre,script,td,ul,li,area,table,thead,tfoot,tbody,tr',\n\t\t\t\tindent_after : 'p,h1,h2,h3,h4,h5,h6,blockquote,div,title,style,pre,script,td,ul,li,area,table,thead,tfoot,tbody,tr',\n\t\t\t\tvalidate : true,\n\t\t\t\tentity_encoding : 'named',\n\t\t\t\turl_converter : t.convertURL,\n\t\t\t\turl_converter_scope : t,\n\t\t\t\tie7_compat : true\n\t\t\t}, s);\n\n\t\t\tt.documentBaseURI = new tinymce.util.URI(s.document_base_url || tinymce.documentBaseURL, {\n\t\t\t\tbase_uri : tinyMCE.baseURI\n\t\t\t});\n\n\t\t\tt.baseURI = tinymce.baseURI;\n\n\t\t\tt.contentCSS = [];\n\n\t\t\t// Call setup\n\t\t\tt.execCallback('setup', t);\n\t\t},\n\n\t\trender : function(nst) {\n\t\t\tvar t = this, s = t.settings, id = t.id, sl = tinymce.ScriptLoader;\n\n\t\t\t// Page is not loaded yet, wait for it\n\t\t\tif (!Event.domLoaded) {\n\t\t\t\tEvent.add(document, 'init', function() {\n\t\t\t\t\tt.render();\n\t\t\t\t});\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\ttinyMCE.settings = s;\n\n\t\t\t// Element not found, then skip initialization\n\t\t\tif (!t.getElement())\n\t\t\t\treturn;\n\n\t\t\t// Is a iPad/iPhone and not on iOS5, then skip initialization. We need to sniff\n\t\t\t// here since the browser says it has contentEditable support but there is no visible\n\t\t\t// caret We will remove this check ones Apple implements full contentEditable support\n\t\t\tif (tinymce.isIDevice && !tinymce.isIOS5)\n\t\t\t\treturn;\n\n\t\t\t// Add hidden input for non input elements inside form elements\n\t\t\tif (!/TEXTAREA|INPUT/i.test(t.getElement().nodeName) && s.hidden_input && DOM.getParent(id, 'form'))\n\t\t\t\tDOM.insertAfter(DOM.create('input', {type : 'hidden', name : id}), id);\n\n\t\t\tif (tinymce.WindowManager)\n\t\t\t\tt.windowManager = new tinymce.WindowManager(t);\n\n\t\t\tif (s.encoding == 'xml') {\n\t\t\t\tt.onGetContent.add(function(ed, o) {\n\t\t\t\t\tif (o.save)\n\t\t\t\t\t\to.content = DOM.encode(o.content);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.add_form_submit_trigger) {\n\t\t\t\tt.onSubmit.addToTop(function() {\n\t\t\t\t\tif (t.initialized) {\n\t\t\t\t\t\tt.save();\n\t\t\t\t\t\tt.isNotDirty = 1;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.add_unload_trigger) {\n\t\t\t\tt._beforeUnload = tinyMCE.onBeforeUnload.add(function() {\n\t\t\t\t\tif (t.initialized && !t.destroyed && !t.isHidden())\n\t\t\t\t\t\tt.save({format : 'raw', no_events : true});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\ttinymce.addUnload(t.destroy, t);\n\n\t\t\tif (s.submit_patch) {\n\t\t\t\tt.onBeforeRenderUI.add(function() {\n\t\t\t\t\tvar n = t.getElement().form;\n\n\t\t\t\t\tif (!n)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Already patched\n\t\t\t\t\tif (n._mceOldSubmit)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Check page uses id=\"submit\" or name=\"submit\" for it's submit button\n\t\t\t\t\tif (!n.submit.nodeType && !n.submit.length) {\n\t\t\t\t\t\tt.formElement = n;\n\t\t\t\t\t\tn._mceOldSubmit = n.submit;\n\t\t\t\t\t\tn.submit = function() {\n\t\t\t\t\t\t\t// Save all instances\n\t\t\t\t\t\t\ttinymce.triggerSave();\n\t\t\t\t\t\t\tt.isNotDirty = 1;\n\n\t\t\t\t\t\t\treturn t.formElement._mceOldSubmit(t.formElement);\n\t\t\t\t\t\t};\n\t\t\t\t\t}\n\n\t\t\t\t\tn = null;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Load scripts\n\t\t\tfunction loadScripts() {\n\t\t\t\tif (s.language && s.language_load !== false)\n\t\t\t\t\tsl.add(tinymce.baseURL + '/langs/' + s.language + '.js');\n\n\t\t\t\tif (s.theme && s.theme.charAt(0) != '-' && !ThemeManager.urls[s.theme])\n\t\t\t\t\tThemeManager.load(s.theme, 'themes/' + s.theme + '/editor_template' + tinymce.suffix + '.js');\n\n\t\t\t\teach(explode(s.plugins), function(p) {\n\t\t\t\t\tif (p &&!PluginManager.urls[p]) {\n\t\t\t\t\t\tif (p.charAt(0) == '-') {\n\t\t\t\t\t\t\tp = p.substr(1, p.length);\n\t\t\t\t\t\t\tvar dependencies = PluginManager.dependencies(p);\n\t\t\t\t\t\t\teach(dependencies, function(dep) {\n\t\t\t\t\t\t\t\tvar defaultSettings = {prefix:'plugins/', resource: dep, suffix:'/editor_plugin' + tinymce.suffix + '.js'};\n\t\t\t\t\t\t\t\tvar dep = PluginManager.createUrl(defaultSettings, dep);\n\t\t\t\t\t\t\t\tPluginManager.load(dep.resource, dep);\n\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Skip safari plugin, since it is removed as of 3.3b1\n\t\t\t\t\t\t\tif (p == 'safari') {\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tPluginManager.load(p, {prefix:'plugins/', resource: p, suffix:'/editor_plugin' + tinymce.suffix + '.js'});\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// Init when que is loaded\n\t\t\t\tsl.loadQueue(function() {\n\t\t\t\t\tif (!t.removed)\n\t\t\t\t\t\tt.init();\n\t\t\t\t});\n\t\t\t};\n\n\t\t\tloadScripts();\n\t\t},\n\n\t\tinit : function() {\n\t\t\tvar n, t = this, s = t.settings, w, h, e = t.getElement(), o, ti, u, bi, bc, re, i, initializedPlugins = [];\n\n\t\t\ttinymce.add(t);\n\n\t\t\ts.aria_label = s.aria_label || DOM.getAttrib(e, 'aria-label', t.getLang('aria.rich_text_area'));\n\n\t\t\tif (s.theme) {\n\t\t\t\ts.theme = s.theme.replace(/-/, '');\n\t\t\t\to = ThemeManager.get(s.theme);\n\t\t\t\tt.theme = new o();\n\n\t\t\t\tif (t.theme.init && s.init_theme)\n\t\t\t\t\tt.theme.init(t, ThemeManager.urls[s.theme] || tinymce.documentBaseURL.replace(/\\/$/, ''));\n\t\t\t}\n\t\t\tfunction initPlugin(p) {\n\t\t\t\tvar c = PluginManager.get(p), u = PluginManager.urls[p] || tinymce.documentBaseURL.replace(/\\/$/, ''), po;\n\t\t\t\tif (c && tinymce.inArray(initializedPlugins,p) === -1) {\n\t\t\t\t\teach(PluginManager.dependencies(p), function(dep){\n\t\t\t\t\t\tinitPlugin(dep);\n\t\t\t\t\t});\n\t\t\t\t\tpo = new c(t, u);\n\n\t\t\t\t\tt.plugins[p] = po;\n\n\t\t\t\t\tif (po.init) {\n\t\t\t\t\t\tpo.init(t, u);\n\t\t\t\t\t\tinitializedPlugins.push(p);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Create all plugins\n\t\t\teach(explode(s.plugins.replace(/\\-/g, '')), initPlugin);\n\n\t\t\t// Setup popup CSS path(s)\n\t\t\tif (s.popup_css !== false) {\n\t\t\t\tif (s.popup_css)\n\t\t\t\t\ts.popup_css = t.documentBaseURI.toAbsolute(s.popup_css);\n\t\t\t\telse\n\t\t\t\t\ts.popup_css = t.baseURI.toAbsolute(\"themes/\" + s.theme + \"/skins/\" + s.skin + \"/dialog.css\");\n\t\t\t}\n\n\t\t\tif (s.popup_css_add)\n\t\t\t\ts.popup_css += ',' + t.documentBaseURI.toAbsolute(s.popup_css_add);\n\n\t\t\tt.controlManager = new tinymce.ControlManager(t);\n\n\t\t\tif (s.custom_undo_redo) {\n\t\t\t\tt.onBeforeExecCommand.add(function(ed, cmd, ui, val, a) {\n\t\t\t\t\tif (cmd != 'Undo' && cmd != 'Redo' && cmd != 'mceRepaint' && (!a || !a.skip_undo))\n\t\t\t\t\t\tt.undoManager.beforeChange();\n\t\t\t\t});\n\n\t\t\t\tt.onExecCommand.add(function(ed, cmd, ui, val, a) {\n\t\t\t\t\tif (cmd != 'Undo' && cmd != 'Redo' && cmd != 'mceRepaint' && (!a || !a.skip_undo))\n\t\t\t\t\t\tt.undoManager.add();\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tt.onExecCommand.add(function(ed, c) {\n\t\t\t\t// Don't refresh the select lists until caret move\n\t\t\t\tif (!/^(FontName|FontSize)$/.test(c))\n\t\t\t\t\tt.nodeChanged();\n\t\t\t});\n\n\t\t\t// Remove ghost selections on images and tables in Gecko\n\t\t\tif (isGecko) {\n\t\t\t\tfunction repaint(a, o) {\n\t\t\t\t\tif (!o || !o.initial)\n\t\t\t\t\t\tt.execCommand('mceRepaint');\n\t\t\t\t};\n\n\t\t\t\tt.onUndo.add(repaint);\n\t\t\t\tt.onRedo.add(repaint);\n\t\t\t\tt.onSetContent.add(repaint);\n\t\t\t}\n\n\t\t\t// Enables users to override the control factory\n\t\t\tt.onBeforeRenderUI.dispatch(t, t.controlManager);\n\n\t\t\t// Measure box\n\t\t\tif (s.render_ui) {\n\t\t\t\tw = s.width || e.style.width || e.offsetWidth;\n\t\t\t\th = s.height || e.style.height || e.offsetHeight;\n\t\t\t\tt.orgDisplay = e.style.display;\n\t\t\t\tre = /^[0-9\\.]+(|px)$/i;\n\n\t\t\t\tif (re.test('' + w))\n\t\t\t\t\tw = Math.max(parseInt(w) + (o.deltaWidth || 0), 100);\n\n\t\t\t\tif (re.test('' + h))\n\t\t\t\t\th = Math.max(parseInt(h) + (o.deltaHeight || 0), 100);\n\n\t\t\t\t// Render UI\n\t\t\t\to = t.theme.renderUI({\n\t\t\t\t\ttargetNode : e,\n\t\t\t\t\twidth : w,\n\t\t\t\t\theight : h,\n\t\t\t\t\tdeltaWidth : s.delta_width,\n\t\t\t\t\tdeltaHeight : s.delta_height\n\t\t\t\t});\n\n\t\t\t\tt.editorContainer = o.editorContainer;\n\t\t\t}\n\n\n\t\t\t// User specified a document.domain value\n\t\t\tif (document.domain && location.hostname != document.domain)\n\t\t\t\ttinymce.relaxedDomain = document.domain;\n\n\t\t\t// Resize editor\n\t\t\tDOM.setStyles(o.sizeContainer || o.editorContainer, {\n\t\t\t\twidth : w,\n\t\t\t\theight : h\n\t\t\t});\n\n\t\t\t// Load specified content CSS last\n\t\t\tif (s.content_css) {\n\t\t\t\ttinymce.each(explode(s.content_css), function(u) {\n\t\t\t\t\tt.contentCSS.push(t.documentBaseURI.toAbsolute(u));\n\t\t\t\t});\n\t\t\t}\n\n\t\t\th = (o.iframeHeight || h) + (typeof(h) == 'number' ? (o.deltaHeight || 0) : '');\n\t\t\tif (h < 100)\n\t\t\t\th = 100;\n\n\t\t\tt.iframeHTML = s.doctype + '<html><head xmlns=\"http://www.w3.org/1999/xhtml\">';\n\n\t\t\t// We only need to override paths if we have to\n\t\t\t// IE has a bug where it remove site absolute urls to relative ones if this is specified\n\t\t\tif (s.document_base_url != tinymce.documentBaseURL)\n\t\t\t\tt.iframeHTML += '<base href=\"' + t.documentBaseURI.getURI() + '\" />';\n\n\t\t\t// IE8 doesn't support carets behind images setting ie7_compat would force IE8+ to run in IE7 compat mode.\n\t\t\tif (s.ie7_compat)\n\t\t\t\tt.iframeHTML += '<meta http-equiv=\"X-UA-Compatible\" content=\"IE=7\" />';\n\t\t\telse\n\t\t\t\tt.iframeHTML += '<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />';\n\n\t\t\tt.iframeHTML += '<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />';\n\n\t\t\t// Load the CSS by injecting them into the HTML this will reduce \"flicker\"\n\t\t\tfor (i = 0; i < t.contentCSS.length; i++) {\n\t\t\t\tt.iframeHTML += '<link type=\"text/css\" rel=\"stylesheet\" href=\"' + t.contentCSS[i] + '\" />';\n\t\t\t}\n\n\t\t\tbi = s.body_id || 'tinymce';\n\t\t\tif (bi.indexOf('=') != -1) {\n\t\t\t\tbi = t.getParam('body_id', '', 'hash');\n\t\t\t\tbi = bi[t.id] || bi;\n\t\t\t}\n\n\t\t\tbc = s.body_class || '';\n\t\t\tif (bc.indexOf('=') != -1) {\n\t\t\t\tbc = t.getParam('body_class', '', 'hash');\n\t\t\t\tbc = bc[t.id] || '';\n\t\t\t}\n\n\t\t\tt.iframeHTML += '</head><body id=\"' + bi + '\" class=\"mceContentBody ' + bc + '\"><br></body></html>';\n\n\t\t\t// Domain relaxing enabled, then set document domain\n\t\t\tif (tinymce.relaxedDomain && (isIE || (tinymce.isOpera && parseFloat(opera.version()) < 11))) {\n\t\t\t\t// We need to write the contents here in IE since multiple writes messes up refresh button and back button\n\t\t\t\tu = 'javascript:(function(){document.open();document.domain=\"' + document.domain + '\";var ed = window.parent.tinyMCE.get(\"' + t.id + '\");document.write(ed.iframeHTML);document.close();ed.setupIframe();})()';\n\t\t\t}\n\n\t\t\t// Create iframe\n\t\t\t// TODO: ACC add the appropriate description on this.\n\t\t\tn = DOM.add(o.iframeContainer, 'iframe', {\n\t\t\t\tid : t.id + \"_ifr\",\n\t\t\t\tsrc : u || 'javascript:\"\"', // Workaround for HTTPS warning in IE6/7\n\t\t\t\tframeBorder : '0',\n\t\t\t\tallowTransparency : \"true\",\n\t\t\t\ttitle : s.aria_label,\n\t\t\t\tstyle : {\n\t\t\t\t\twidth : '100%',\n\t\t\t\t\theight : h,\n\t\t\t\t\tdisplay : 'block' // Important for Gecko to render the iframe correctly\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.contentAreaContainer = o.iframeContainer;\n\t\t\tDOM.get(o.editorContainer).style.display = t.orgDisplay;\n\t\t\tDOM.get(t.id).style.display = 'none';\n\t\t\tDOM.setAttrib(t.id, 'aria-hidden', true);\n\n\t\t\tif (!tinymce.relaxedDomain || !u)\n\t\t\t\tt.setupIframe();\n\n\t\t\te = n = o = null; // Cleanup\n\t\t},\n\n\t\tsetupIframe : function() {\n\t\t\tvar t = this, s = t.settings, e = DOM.get(t.id), d = t.getDoc(), h, b;\n\n\t\t\t// Setup iframe body\n\t\t\tif (!isIE || !tinymce.relaxedDomain) {\n\t\t\t\td.open();\n\t\t\t\td.write(t.iframeHTML);\n\t\t\t\td.close();\n\n\t\t\t\tif (tinymce.relaxedDomain)\n\t\t\t\t\td.domain = tinymce.relaxedDomain;\n\t\t\t}\n\n\t\t\t// It will not steal focus while setting contentEditable\n\t\t\tb = t.getBody();\n\t\t\tb.disabled = true;\n\n\t\t\tif (!s.readonly)\n\t\t\t\tb.contentEditable = true;\n\n\t\t\tb.disabled = false;\n\n\t\t\tt.schema = new tinymce.html.Schema(s);\n\n\t\t\tt.dom = new tinymce.dom.DOMUtils(t.getDoc(), {\n\t\t\t\tkeep_values : true,\n\t\t\t\turl_converter : t.convertURL,\n\t\t\t\turl_converter_scope : t,\n\t\t\t\thex_colors : s.force_hex_style_colors,\n\t\t\t\tclass_filter : s.class_filter,\n\t\t\t\tupdate_styles : 1,\n\t\t\t\tfix_ie_paragraphs : 1,\n\t\t\t\tschema : t.schema\n\t\t\t});\n\n\t\t\tt.parser = new tinymce.html.DomParser(s, t.schema);\n\n\t\t\t// Force anchor names closed, unless the setting \"allow_html_in_named_anchor\" is explicitly included.\n\t\t\tif (!t.settings.allow_html_in_named_anchor) {\n\t\t\t\tt.parser.addAttributeFilter('name', function(nodes, name) {\n\t\t\t\t\tvar i = nodes.length, sibling, prevSibling, parent, node;\n\n\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\t\tif (node.name === 'a' && node.firstChild) {\n\t\t\t\t\t\t\tparent = node.parent;\n\n\t\t\t\t\t\t\t// Move children after current node\n\t\t\t\t\t\t\tsibling = node.lastChild;\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\tprevSibling = sibling.prev;\n\t\t\t\t\t\t\t\tparent.insert(sibling, node);\n\t\t\t\t\t\t\t\tsibling = prevSibling;\n\t\t\t\t\t\t\t} while (sibling);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Convert src and href into data-mce-src, data-mce-href and data-mce-style\n\t\t\tt.parser.addAttributeFilter('src,href,style', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node, dom = t.dom, value, internalName;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tvalue = node.attr(name);\n\t\t\t\t\tinternalName = 'data-mce-' + name;\n\n\t\t\t\t\t// Add internal attribute if we need to we don't on a refresh of the document\n\t\t\t\t\tif (!node.attributes.map[internalName]) {\n\t\t\t\t\t\tif (name === \"style\")\n\t\t\t\t\t\t\tnode.attr(internalName, dom.serializeStyle(dom.parseStyle(value), node.name));\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tnode.attr(internalName, t.convertURL(value, name, node.name));\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Keep scripts from executing\n\t\t\tt.parser.addNodeFilter('script', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tnode.attr('type', 'mce-' + (node.attr('type') || 'text/javascript'));\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.parser.addNodeFilter('#cdata', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tnode.type = 8;\n\t\t\t\t\tnode.name = '#comment';\n\t\t\t\t\tnode.value = '[CDATA[' + node.value + ']]';\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.parser.addNodeFilter('p,h1,h2,h3,h4,h5,h6,div', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node, nonEmptyElements = t.schema.getNonEmptyElements();\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\n\t\t\t\t\tif (node.isEmpty(nonEmptyElements))\n\t\t\t\t\t\tnode.empty().append(new tinymce.html.Node('br', 1)).shortEnded = true;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.serializer = new tinymce.dom.Serializer(s, t.dom, t.schema);\n\n\t\t\tt.selection = new tinymce.dom.Selection(t.dom, t.getWin(), t.serializer);\n\n\t\t\tt.formatter = new tinymce.Formatter(this);\n\n\t\t\t// Register default formats\n\t\t\tt.formatter.register({\n\t\t\t\talignleft : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'left'}},\n\t\t\t\t\t{selector : 'img,table', collapsed : false, styles : {'float' : 'left'}}\n\t\t\t\t],\n\n\t\t\t\taligncenter : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'center'}},\n\t\t\t\t\t{selector : 'img', collapsed : false, styles : {display : 'block', marginLeft : 'auto', marginRight : 'auto'}},\n\t\t\t\t\t{selector : 'table', collapsed : false, styles : {marginLeft : 'auto', marginRight : 'auto'}}\n\t\t\t\t],\n\n\t\t\t\talignright : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'right'}},\n\t\t\t\t\t{selector : 'img,table', collapsed : false, styles : {'float' : 'right'}}\n\t\t\t\t],\n\n\t\t\t\talignfull : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'justify'}}\n\t\t\t\t],\n\n\t\t\t\tbold : [\n\t\t\t\t\t{inline : 'strong', remove : 'all'},\n\t\t\t\t\t{inline : 'span', styles : {fontWeight : 'bold'}},\n\t\t\t\t\t{inline : 'b', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\titalic : [\n\t\t\t\t\t{inline : 'em', remove : 'all'},\n\t\t\t\t\t{inline : 'span', styles : {fontStyle : 'italic'}},\n\t\t\t\t\t{inline : 'i', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\tunderline : [\n\t\t\t\t\t{inline : 'span', styles : {textDecoration : 'underline'}, exact : true},\n\t\t\t\t\t{inline : 'u', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\tstrikethrough : [\n\t\t\t\t\t{inline : 'span', styles : {textDecoration : 'line-through'}, exact : true},\n\t\t\t\t\t{inline : 'strike', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\tforecolor : {inline : 'span', styles : {color : '%value'}, wrap_links : false},\n\t\t\t\thilitecolor : {inline : 'span', styles : {backgroundColor : '%value'}, wrap_links : false},\n\t\t\t\tfontname : {inline : 'span', styles : {fontFamily : '%value'}},\n\t\t\t\tfontsize : {inline : 'span', styles : {fontSize : '%value'}},\n\t\t\t\tfontsize_class : {inline : 'span', attributes : {'class' : '%value'}},\n\t\t\t\tblockquote : {block : 'blockquote', wrapper : 1, remove : 'all'},\n\t\t\t\tsubscript : {inline : 'sub'},\n\t\t\t\tsuperscript : {inline : 'sup'},\n\n\t\t\t\tlink : {inline : 'a', selector : 'a', remove : 'all', split : true, deep : true,\n\t\t\t\t\tonmatch : function(node) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t},\n\n\t\t\t\t\tonformat : function(elm, fmt, vars) {\n\t\t\t\t\t\teach(vars, function(value, key) {\n\t\t\t\t\t\t\tt.dom.setAttrib(elm, key, value);\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tremoveformat : [\n\t\t\t\t\t{selector : 'b,strong,em,i,font,u,strike', remove : 'all', split : true, expand : false, block_expand : true, deep : true},\n\t\t\t\t\t{selector : 'span', attributes : ['style', 'class'], remove : 'empty', split : true, expand : false, deep : true},\n\t\t\t\t\t{selector : '*', attributes : ['style', 'class'], split : false, expand : false, deep : true}\n\t\t\t\t]\n\t\t\t});\n\n\t\t\t// Register default block formats\n\t\t\teach('p h1 h2 h3 h4 h5 h6 div address pre div code dt dd samp'.split(/\\s/), function(name) {\n\t\t\t\tt.formatter.register(name, {block : name, remove : 'all'});\n\t\t\t});\n\n\t\t\t// Register user defined formats\n\t\t\tt.formatter.register(t.settings.formats);\n\n\t\t\tt.undoManager = new tinymce.UndoManager(t);\n\n\t\t\t// Pass through\n\t\t\tt.undoManager.onAdd.add(function(um, l) {\n\t\t\t\tif (um.hasUndo())\n\t\t\t\t\treturn t.onChange.dispatch(t, l, um);\n\t\t\t});\n\n\t\t\tt.undoManager.onUndo.add(function(um, l) {\n\t\t\t\treturn t.onUndo.dispatch(t, l, um);\n\t\t\t});\n\n\t\t\tt.undoManager.onRedo.add(function(um, l) {\n\t\t\t\treturn t.onRedo.dispatch(t, l, um);\n\t\t\t});\n\n\t\t\tt.forceBlocks = new tinymce.ForceBlocks(t, {\n\t\t\t\tforced_root_block : s.forced_root_block\n\t\t\t});\n\n\t\t\tt.editorCommands = new tinymce.EditorCommands(t);\n\n\t\t\t// Pass through\n\t\t\tt.serializer.onPreProcess.add(function(se, o) {\n\t\t\t\treturn t.onPreProcess.dispatch(t, o, se);\n\t\t\t});\n\n\t\t\tt.serializer.onPostProcess.add(function(se, o) {\n\t\t\t\treturn t.onPostProcess.dispatch(t, o, se);\n\t\t\t});\n\n\t\t\tt.onPreInit.dispatch(t);\n\n\t\t\tif (!s.gecko_spellcheck)\n\t\t\t\tt.getBody().spellcheck = 0;\n\n\t\t\tif (!s.readonly)\n\t\t\t\tt._addEvents();\n\n\t\t\tt.controlManager.onPostRender.dispatch(t, t.controlManager);\n\t\t\tt.onPostRender.dispatch(t);\n\n\t\t\tt.quirks = new tinymce.util.Quirks(this);\n\n\t\t\tif (s.directionality)\n\t\t\t\tt.getBody().dir = s.directionality;\n\n\t\t\tif (s.nowrap)\n\t\t\t\tt.getBody().style.whiteSpace = \"nowrap\";\n\n\t\t\tif (s.handle_node_change_callback) {\n\t\t\t\tt.onNodeChange.add(function(ed, cm, n) {\n\t\t\t\t\tt.execCallback('handle_node_change_callback', t.id, n, -1, -1, true, t.selection.isCollapsed());\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.save_callback) {\n\t\t\t\tt.onSaveContent.add(function(ed, o) {\n\t\t\t\t\tvar h = t.execCallback('save_callback', t.id, o.content, t.getBody());\n\n\t\t\t\t\tif (h)\n\t\t\t\t\t\to.content = h;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.onchange_callback) {\n\t\t\t\tt.onChange.add(function(ed, l) {\n\t\t\t\t\tt.execCallback('onchange_callback', t, l);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.protect) {\n\t\t\t\tt.onBeforeSetContent.add(function(ed, o) {\n\t\t\t\t\tif (s.protect) {\n\t\t\t\t\t\teach(s.protect, function(pattern) {\n\t\t\t\t\t\t\to.content = o.content.replace(pattern, function(str) {\n\t\t\t\t\t\t\t\treturn '<!--mce:protected ' + escape(str) + '-->';\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.convert_newlines_to_brs) {\n\t\t\t\tt.onBeforeSetContent.add(function(ed, o) {\n\t\t\t\t\tif (o.initial)\n\t\t\t\t\t\to.content = o.content.replace(/\\r?\\n/g, '<br />');\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.preformatted) {\n\t\t\t\tt.onPostProcess.add(function(ed, o) {\n\t\t\t\t\to.content = o.content.replace(/^\\s*<pre.*?>/, '');\n\t\t\t\t\to.content = o.content.replace(/<\\/pre>\\s*$/, '');\n\n\t\t\t\t\tif (o.set)\n\t\t\t\t\t\to.content = '<pre class=\"mceItemHidden\">' + o.content + '</pre>';\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.verify_css_classes) {\n\t\t\t\tt.serializer.attribValueFilter = function(n, v) {\n\t\t\t\t\tvar s, cl;\n\n\t\t\t\t\tif (n == 'class') {\n\t\t\t\t\t\t// Build regexp for classes\n\t\t\t\t\t\tif (!t.classesRE) {\n\t\t\t\t\t\t\tcl = t.dom.getClasses();\n\n\t\t\t\t\t\t\tif (cl.length > 0) {\n\t\t\t\t\t\t\t\ts = '';\n\n\t\t\t\t\t\t\t\teach (cl, function(o) {\n\t\t\t\t\t\t\t\t\ts += (s ? '|' : '') + o['class'];\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\tt.classesRE = new RegExp('(' + s + ')', 'gi');\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn !t.classesRE || /(\\bmceItem\\w+\\b|\\bmceTemp\\w+\\b)/g.test(v) || t.classesRE.test(v) ? v : '';\n\t\t\t\t\t}\n\n\t\t\t\t\treturn v;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (s.cleanup_callback) {\n\t\t\t\tt.onBeforeSetContent.add(function(ed, o) {\n\t\t\t\t\to.content = t.execCallback('cleanup_callback', 'insert_to_editor', o.content, o);\n\t\t\t\t});\n\n\t\t\t\tt.onPreProcess.add(function(ed, o) {\n\t\t\t\t\tif (o.set)\n\t\t\t\t\t\tt.execCallback('cleanup_callback', 'insert_to_editor_dom', o.node, o);\n\n\t\t\t\t\tif (o.get)\n\t\t\t\t\t\tt.execCallback('cleanup_callback', 'get_from_editor_dom', o.node, o);\n\t\t\t\t});\n\n\t\t\t\tt.onPostProcess.add(function(ed, o) {\n\t\t\t\t\tif (o.set)\n\t\t\t\t\t\to.content = t.execCallback('cleanup_callback', 'insert_to_editor', o.content, o);\n\n\t\t\t\t\tif (o.get)\n\t\t\t\t\t\to.content = t.execCallback('cleanup_callback', 'get_from_editor', o.content, o);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.save_callback) {\n\t\t\t\tt.onGetContent.add(function(ed, o) {\n\t\t\t\t\tif (o.save)\n\t\t\t\t\t\to.content = t.execCallback('save_callback', t.id, o.content, t.getBody());\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.handle_event_callback) {\n\t\t\t\tt.onEvent.add(function(ed, e, o) {\n\t\t\t\t\tif (t.execCallback('handle_event_callback', e, ed, o) === false)\n\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Add visual aids when new contents is added\n\t\t\tt.onSetContent.add(function() {\n\t\t\t\tt.addVisual(t.getBody());\n\t\t\t});\n\n\t\t\t// Remove empty contents\n\t\t\tif (s.padd_empty_editor) {\n\t\t\t\tt.onPostProcess.add(function(ed, o) {\n\t\t\t\t\to.content = o.content.replace(/^(<p[^>]*>(&nbsp;|&#160;|\\s|\\u00a0|)<\\/p>[\\r\\n]*|<br \\/>[\\r\\n]*)$/, '');\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (isGecko) {\n\t\t\t\t// Fix gecko link bug, when a link is placed at the end of block elements there is\n\t\t\t\t// no way to move the caret behind the link. This fix adds a bogus br element after the link\n\t\t\t\tfunction fixLinks(ed, o) {\n\t\t\t\t\teach(ed.dom.select('a'), function(n) {\n\t\t\t\t\t\tvar pn = n.parentNode;\n\n\t\t\t\t\t\tif (ed.dom.isBlock(pn) && pn.lastChild === n)\n\t\t\t\t\t\t\ted.dom.add(pn, 'br', {'data-mce-bogus' : 1});\n\t\t\t\t\t});\n\t\t\t\t};\n\n\t\t\t\tt.onExecCommand.add(function(ed, cmd) {\n\t\t\t\t\tif (cmd === 'CreateLink')\n\t\t\t\t\t\tfixLinks(ed);\n\t\t\t\t});\n\n\t\t\t\tt.onSetContent.add(t.selection.onSetContent.add(fixLinks));\n\t\t\t}\n\n\t\t\tt.load({initial : true, format : 'html'});\n\t\t\tt.startContent = t.getContent({format : 'raw'});\n\t\t\tt.undoManager.add();\n\t\t\tt.initialized = true;\n\n\t\t\tt.onInit.dispatch(t);\n\t\t\tt.execCallback('setupcontent_callback', t.id, t.getBody(), t.getDoc());\n\t\t\tt.execCallback('init_instance_callback', t);\n\t\t\tt.focus(true);\n\t\t\tt.nodeChanged({initial : 1});\n\n\t\t\t// Load specified content CSS last\n\t\t\teach(t.contentCSS, function(u) {\n\t\t\t\tt.dom.loadCSS(u);\n\t\t\t});\n\n\t\t\t// Handle auto focus\n\t\t\tif (s.auto_focus) {\n\t\t\t\tsetTimeout(function () {\n\t\t\t\t\tvar ed = tinymce.get(s.auto_focus);\n\n\t\t\t\t\ted.selection.select(ed.getBody(), 1);\n\t\t\t\t\ted.selection.collapse(1);\n\t\t\t\t\ted.getBody().focus();\n\t\t\t\t\ted.getWin().focus();\n\t\t\t\t}, 100);\n\t\t\t}\n\n\t\t\te = null;\n\t\t},\n\n\n\t\tfocus : function(sf) {\n\t\t\tvar oed, t = this, selection = t.selection, ce = t.settings.content_editable, ieRng, controlElm, doc = t.getDoc();\n\n\t\t\tif (!sf) {\n\t\t\t\t// Get selected control element\n\t\t\t\tieRng = selection.getRng();\n\t\t\t\tif (ieRng.item) {\n\t\t\t\t\tcontrolElm = ieRng.item(0);\n\t\t\t\t}\n\n\t\t\t\tt._refreshContentEditable();\n\t\t\t\tselection.normalize();\n\n\t\t\t\t// Is not content editable\n\t\t\t\tif (!ce)\n\t\t\t\t\tt.getWin().focus();\n\n\t\t\t\t// Focus the body as well since it's contentEditable\n\t\t\t\tif (tinymce.isGecko) {\n\t\t\t\t\tt.getBody().focus();\n\t\t\t\t}\n\n\t\t\t\t// Restore selected control element\n\t\t\t\t// This is needed when for example an image is selected within a\n\t\t\t\t// layer a call to focus will then remove the control selection\n\t\t\t\tif (controlElm && controlElm.ownerDocument == doc) {\n\t\t\t\t\tieRng = doc.body.createControlRange();\n\t\t\t\t\tieRng.addElement(controlElm);\n\t\t\t\t\tieRng.select();\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t\tif (tinymce.activeEditor != t) {\n\t\t\t\tif ((oed = tinymce.activeEditor) != null)\n\t\t\t\t\toed.onDeactivate.dispatch(oed, t);\n\n\t\t\t\tt.onActivate.dispatch(t, oed);\n\t\t\t}\n\n\t\t\ttinymce._setActive(t);\n\t\t},\n\n\t\texecCallback : function(n) {\n\t\t\tvar t = this, f = t.settings[n], s;\n\n\t\t\tif (!f)\n\t\t\t\treturn;\n\n\t\t\t// Look through lookup\n\t\t\tif (t.callbackLookup && (s = t.callbackLookup[n])) {\n\t\t\t\tf = s.func;\n\t\t\t\ts = s.scope;\n\t\t\t}\n\n\t\t\tif (is(f, 'string')) {\n\t\t\t\ts = f.replace(/\\.\\w+$/, '');\n\t\t\t\ts = s ? tinymce.resolve(s) : 0;\n\t\t\t\tf = tinymce.resolve(f);\n\t\t\t\tt.callbackLookup = t.callbackLookup || {};\n\t\t\t\tt.callbackLookup[n] = {func : f, scope : s};\n\t\t\t}\n\n\t\t\treturn f.apply(s || t, Array.prototype.slice.call(arguments, 1));\n\t\t},\n\n\t\ttranslate : function(s) {\n\t\t\tvar c = this.settings.language || 'en', i18n = tinymce.i18n;\n\n\t\t\tif (!s)\n\t\t\t\treturn '';\n\n\t\t\treturn i18n[c + '.' + s] || s.replace(/{\\#([^}]+)\\}/g, function(a, b) {\n\t\t\t\treturn i18n[c + '.' + b] || '{#' + b + '}';\n\t\t\t});\n\t\t},\n\n\t\tgetLang : function(n, dv) {\n\t\t\treturn tinymce.i18n[(this.settings.language || 'en') + '.' + n] || (is(dv) ? dv : '{#' + n + '}');\n\t\t},\n\n\t\tgetParam : function(n, dv, ty) {\n\t\t\tvar tr = tinymce.trim, v = is(this.settings[n]) ? this.settings[n] : dv, o;\n\n\t\t\tif (ty === 'hash') {\n\t\t\t\to = {};\n\n\t\t\t\tif (is(v, 'string')) {\n\t\t\t\t\teach(v.indexOf('=') > 0 ? v.split(/[;,](?![^=;,]*(?:[;,]|$))/) : v.split(','), function(v) {\n\t\t\t\t\t\tv = v.split('=');\n\n\t\t\t\t\t\tif (v.length > 1)\n\t\t\t\t\t\t\to[tr(v[0])] = tr(v[1]);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\to[tr(v[0])] = tr(v);\n\t\t\t\t\t});\n\t\t\t\t} else\n\t\t\t\t\to = v;\n\n\t\t\t\treturn o;\n\t\t\t}\n\n\t\t\treturn v;\n\t\t},\n\n\t\tnodeChanged : function(o) {\n\t\t\tvar t = this, s = t.selection, n = s.getStart() || t.getBody();\n\n\t\t\t// Fix for bug #1896577 it seems that this can not be fired while the editor is loading\n\t\t\tif (t.initialized) {\n\t\t\t\to = o || {};\n\t\t\t\tn = isIE && n.ownerDocument != t.getDoc() ? t.getBody() : n; // Fix for IE initial state\n\n\t\t\t\t// Get parents and add them to object\n\t\t\t\to.parents = [];\n\t\t\t\tt.dom.getParent(n, function(node) {\n\t\t\t\t\tif (node.nodeName == 'BODY')\n\t\t\t\t\t\treturn true;\n\n\t\t\t\t\to.parents.push(node);\n\t\t\t\t});\n\n\t\t\t\tt.onNodeChange.dispatch(\n\t\t\t\t\tt,\n\t\t\t\t\to ? o.controlManager || t.controlManager : t.controlManager,\n\t\t\t\t\tn,\n\t\t\t\t\ts.isCollapsed(),\n\t\t\t\t\to\n\t\t\t\t);\n\t\t\t}\n\t\t},\n\n\t\taddButton : function(n, s) {\n\t\t\tvar t = this;\n\n\t\t\tt.buttons = t.buttons || {};\n\t\t\tt.buttons[n] = s;\n\t\t},\n\n\t\taddCommand : function(name, callback, scope) {\n\t\t\tthis.execCommands[name] = {func : callback, scope : scope || this};\n\t\t},\n\n\t\taddQueryStateHandler : function(name, callback, scope) {\n\t\t\tthis.queryStateCommands[name] = {func : callback, scope : scope || this};\n\t\t},\n\n\t\taddQueryValueHandler : function(name, callback, scope) {\n\t\t\tthis.queryValueCommands[name] = {func : callback, scope : scope || this};\n\t\t},\n\n\t\taddShortcut : function(pa, desc, cmd_func, sc) {\n\t\t\tvar t = this, c;\n\n\t\t\tif (!t.settings.custom_shortcuts)\n\t\t\t\treturn false;\n\n\t\t\tt.shortcuts = t.shortcuts || {};\n\n\t\t\tif (is(cmd_func, 'string')) {\n\t\t\t\tc = cmd_func;\n\n\t\t\t\tcmd_func = function() {\n\t\t\t\t\tt.execCommand(c, false, null);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (is(cmd_func, 'object')) {\n\t\t\t\tc = cmd_func;\n\n\t\t\t\tcmd_func = function() {\n\t\t\t\t\tt.execCommand(c[0], c[1], c[2]);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\teach(explode(pa), function(pa) {\n\t\t\t\tvar o = {\n\t\t\t\t\tfunc : cmd_func,\n\t\t\t\t\tscope : sc || this,\n\t\t\t\t\tdesc : desc,\n\t\t\t\t\talt : false,\n\t\t\t\t\tctrl : false,\n\t\t\t\t\tshift : false\n\t\t\t\t};\n\n\t\t\t\teach(explode(pa, '+'), function(v) {\n\t\t\t\t\tswitch (v) {\n\t\t\t\t\t\tcase 'alt':\n\t\t\t\t\t\tcase 'ctrl':\n\t\t\t\t\t\tcase 'shift':\n\t\t\t\t\t\t\to[v] = true;\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tdefault:\n\t\t\t\t\t\t\to.charCode = v.charCodeAt(0);\n\t\t\t\t\t\t\to.keyCode = v.toUpperCase().charCodeAt(0);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tt.shortcuts[(o.ctrl ? 'ctrl' : '') + ',' + (o.alt ? 'alt' : '') + ',' + (o.shift ? 'shift' : '') + ',' + o.keyCode] = o;\n\t\t\t});\n\n\t\t\treturn true;\n\t\t},\n\n\t\texecCommand : function(cmd, ui, val, a) {\n\t\t\tvar t = this, s = 0, o, st;\n\n\t\t\tif (!/^(mceAddUndoLevel|mceEndUndoLevel|mceBeginUndoLevel|mceRepaint|SelectAll)$/.test(cmd) && (!a || !a.skip_focus))\n\t\t\t\tt.focus();\n\n\t\t\to = {};\n\t\t\tt.onBeforeExecCommand.dispatch(t, cmd, ui, val, o);\n\t\t\tif (o.terminate)\n\t\t\t\treturn false;\n\n\t\t\t// Command callback\n\t\t\tif (t.execCallback('execcommand_callback', t.id, t.selection.getNode(), cmd, ui, val)) {\n\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Registred commands\n\t\t\tif (o = t.execCommands[cmd]) {\n\t\t\t\tst = o.func.call(o.scope, ui, val);\n\n\t\t\t\t// Fall through on true\n\t\t\t\tif (st !== true) {\n\t\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\t\treturn st;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Plugin commands\n\t\t\teach(t.plugins, function(p) {\n\t\t\t\tif (p.execCommand && p.execCommand(cmd, ui, val)) {\n\t\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\t\ts = 1;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tif (s)\n\t\t\t\treturn true;\n\n\t\t\t// Theme commands\n\t\t\tif (t.theme && t.theme.execCommand && t.theme.execCommand(cmd, ui, val)) {\n\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Editor commands\n\t\t\tif (t.editorCommands.execCommand(cmd, ui, val)) {\n\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Browser commands\n\t\t\tt.getDoc().execCommand(cmd, ui, val);\n\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t},\n\n\t\tqueryCommandState : function(cmd) {\n\t\t\tvar t = this, o, s;\n\n\t\t\t// Is hidden then return undefined\n\t\t\tif (t._isHidden())\n\t\t\t\treturn;\n\n\t\t\t// Registred commands\n\t\t\tif (o = t.queryStateCommands[cmd]) {\n\t\t\t\ts = o.func.call(o.scope);\n\n\t\t\t\t// Fall though on true\n\t\t\t\tif (s !== true)\n\t\t\t\t\treturn s;\n\t\t\t}\n\n\t\t\t// Registred commands\n\t\t\to = t.editorCommands.queryCommandState(cmd);\n\t\t\tif (o !== -1)\n\t\t\t\treturn o;\n\n\t\t\t// Browser commands\n\t\t\ttry {\n\t\t\t\treturn this.getDoc().queryCommandState(cmd);\n\t\t\t} catch (ex) {\n\t\t\t\t// Fails sometimes see bug: 1896577\n\t\t\t}\n\t\t},\n\n\t\tqueryCommandValue : function(c) {\n\t\t\tvar t = this, o, s;\n\n\t\t\t// Is hidden then return undefined\n\t\t\tif (t._isHidden())\n\t\t\t\treturn;\n\n\t\t\t// Registred commands\n\t\t\tif (o = t.queryValueCommands[c]) {\n\t\t\t\ts = o.func.call(o.scope);\n\n\t\t\t\t// Fall though on true\n\t\t\t\tif (s !== true)\n\t\t\t\t\treturn s;\n\t\t\t}\n\n\t\t\t// Registred commands\n\t\t\to = t.editorCommands.queryCommandValue(c);\n\t\t\tif (is(o))\n\t\t\t\treturn o;\n\n\t\t\t// Browser commands\n\t\t\ttry {\n\t\t\t\treturn this.getDoc().queryCommandValue(c);\n\t\t\t} catch (ex) {\n\t\t\t\t// Fails sometimes see bug: 1896577\n\t\t\t}\n\t\t},\n\n\t\tshow : function() {\n\t\t\tvar t = this;\n\n\t\t\tDOM.show(t.getContainer());\n\t\t\tDOM.hide(t.id);\n\t\t\tt.load();\n\t\t},\n\n\t\thide : function() {\n\t\t\tvar t = this, d = t.getDoc();\n\n\t\t\t// Fixed bug where IE has a blinking cursor left from the editor\n\t\t\tif (isIE && d)\n\t\t\t\td.execCommand('SelectAll');\n\n\t\t\t// We must save before we hide so Safari doesn't crash\n\t\t\tt.save();\n\t\t\tDOM.hide(t.getContainer());\n\t\t\tDOM.setStyle(t.id, 'display', t.orgDisplay);\n\t\t},\n\n\t\tisHidden : function() {\n\t\t\treturn !DOM.isHidden(this.id);\n\t\t},\n\n\t\tsetProgressState : function(b, ti, o) {\n\t\t\tthis.onSetProgressState.dispatch(this, b, ti, o);\n\n\t\t\treturn b;\n\t\t},\n\n\t\tload : function(o) {\n\t\t\tvar t = this, e = t.getElement(), h;\n\n\t\t\tif (e) {\n\t\t\t\to = o || {};\n\t\t\t\to.load = true;\n\n\t\t\t\t// Double encode existing entities in the value\n\t\t\t\th = t.setContent(is(e.value) ? e.value : e.innerHTML, o);\n\t\t\t\to.element = e;\n\n\t\t\t\tif (!o.no_events)\n\t\t\t\t\tt.onLoadContent.dispatch(t, o);\n\n\t\t\t\to.element = e = null;\n\n\t\t\t\treturn h;\n\t\t\t}\n\t\t},\n\n\t\tsave : function(o) {\n\t\t\tvar t = this, e = t.getElement(), h, f;\n\n\t\t\tif (!e || !t.initialized)\n\t\t\t\treturn;\n\n\t\t\to = o || {};\n\t\t\to.save = true;\n\n\t\t\t// Add undo level will trigger onchange event\n\t\t\tif (!o.no_events) {\n\t\t\t\tt.undoManager.typing = false;\n\t\t\t\tt.undoManager.add();\n\t\t\t}\n\n\t\t\to.element = e;\n\t\t\th = o.content = t.getContent(o);\n\n\t\t\tif (!o.no_events)\n\t\t\t\tt.onSaveContent.dispatch(t, o);\n\n\t\t\th = o.content;\n\n\t\t\tif (!/TEXTAREA|INPUT/i.test(e.nodeName)) {\n\t\t\t\te.innerHTML = h;\n\n\t\t\t\t// Update hidden form element\n\t\t\t\tif (f = DOM.getParent(t.id, 'form')) {\n\t\t\t\t\teach(f.elements, function(e) {\n\t\t\t\t\t\tif (e.name == t.id) {\n\t\t\t\t\t\t\te.value = h;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t} else\n\t\t\t\te.value = h;\n\n\t\t\to.element = e = null;\n\n\t\t\treturn h;\n\t\t},\n\n\t\tsetContent : function(content, args) {\n\t\t\tvar self = this, rootNode, body = self.getBody(), forcedRootBlockName;\n\n\t\t\t// Setup args object\n\t\t\targs = args || {};\n\t\t\targs.format = args.format || 'html';\n\t\t\targs.set = true;\n\t\t\targs.content = content;\n\n\t\t\t// Do preprocessing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onBeforeSetContent.dispatch(self, args);\n\n\t\t\tcontent = args.content;\n\n\t\t\t// Padd empty content in Gecko and Safari. Commands will otherwise fail on the content\n\t\t\t// It will also be impossible to place the caret in the editor unless there is a BR element present\n\t\t\tif (!tinymce.isIE && (content.length === 0 || /^\\s+$/.test(content))) {\n\t\t\t\tforcedRootBlockName = self.settings.forced_root_block;\n\t\t\t\tif (forcedRootBlockName)\n\t\t\t\t\tcontent = '<' + forcedRootBlockName + '><br data-mce-bogus=\"1\"></' + forcedRootBlockName + '>';\n\t\t\t\telse\n\t\t\t\t\tcontent = '<br data-mce-bogus=\"1\">';\n\n\t\t\t\tbody.innerHTML = content;\n\t\t\t\tself.selection.select(body, true);\n\t\t\t\tself.selection.collapse(true);\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Parse and serialize the html\n\t\t\tif (args.format !== 'raw') {\n\t\t\t\tcontent = new tinymce.html.Serializer({}, self.schema).serialize(\n\t\t\t\t\tself.parser.parse(content)\n\t\t\t\t);\n\t\t\t}\n\n\t\t\t// Set the new cleaned contents to the editor\n\t\t\targs.content = tinymce.trim(content);\n\t\t\tself.dom.setHTML(body, args.content);\n\n\t\t\t// Do post processing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onSetContent.dispatch(self, args);\n\n\t\t\tself.selection.normalize();\n\n\t\t\treturn args.content;\n\t\t},\n\n\t\tgetContent : function(args) {\n\t\t\tvar self = this, content;\n\n\t\t\t// Setup args object\n\t\t\targs = args || {};\n\t\t\targs.format = args.format || 'html';\n\t\t\targs.get = true;\n\n\t\t\t// Do preprocessing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onBeforeGetContent.dispatch(self, args);\n\n\t\t\t// Get raw contents or by default the cleaned contents\n\t\t\tif (args.format == 'raw')\n\t\t\t\tcontent = self.getBody().innerHTML;\n\t\t\telse\n\t\t\t\tcontent = self.serializer.serialize(self.getBody(), args);\n\n\t\t\targs.content = tinymce.trim(content);\n\n\t\t\t// Do post processing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onGetContent.dispatch(self, args);\n\n\t\t\treturn args.content;\n\t\t},\n\n\t\tisDirty : function() {\n\t\t\tvar self = this;\n\n\t\t\treturn tinymce.trim(self.startContent) != tinymce.trim(self.getContent({format : 'raw', no_events : 1})) && !self.isNotDirty;\n\t\t},\n\n\t\tgetContainer : function() {\n\t\t\tvar t = this;\n\n\t\t\tif (!t.container)\n\t\t\t\tt.container = DOM.get(t.editorContainer || t.id + '_parent');\n\n\t\t\treturn t.container;\n\t\t},\n\n\t\tgetContentAreaContainer : function() {\n\t\t\treturn this.contentAreaContainer;\n\t\t},\n\n\t\tgetElement : function() {\n\t\t\treturn DOM.get(this.settings.content_element || this.id);\n\t\t},\n\n\t\tgetWin : function() {\n\t\t\tvar t = this, e;\n\n\t\t\tif (!t.contentWindow) {\n\t\t\t\te = DOM.get(t.id + \"_ifr\");\n\n\t\t\t\tif (e)\n\t\t\t\t\tt.contentWindow = e.contentWindow;\n\t\t\t}\n\n\t\t\treturn t.contentWindow;\n\t\t},\n\n\t\tgetDoc : function() {\n\t\t\tvar t = this, w;\n\n\t\t\tif (!t.contentDocument) {\n\t\t\t\tw = t.getWin();\n\n\t\t\t\tif (w)\n\t\t\t\t\tt.contentDocument = w.document;\n\t\t\t}\n\n\t\t\treturn t.contentDocument;\n\t\t},\n\n\t\tgetBody : function() {\n\t\t\treturn this.bodyElement || this.getDoc().body;\n\t\t},\n\n\t\tconvertURL : function(u, n, e) {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\t// Use callback instead\n\t\t\tif (s.urlconverter_callback)\n\t\t\t\treturn t.execCallback('urlconverter_callback', u, e, true, n);\n\n\t\t\t// Don't convert link href since thats the CSS files that gets loaded into the editor also skip local file URLs\n\t\t\tif (!s.convert_urls || (e && e.nodeName == 'LINK') || u.indexOf('file:') === 0)\n\t\t\t\treturn u;\n\n\t\t\t// Convert to relative\n\t\t\tif (s.relative_urls)\n\t\t\t\treturn t.documentBaseURI.toRelative(u);\n\n\t\t\t// Convert to absolute\n\t\t\tu = t.documentBaseURI.toAbsolute(u, s.remove_script_host);\n\n\t\t\treturn u;\n\t\t},\n\n\t\taddVisual : function(e) {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\te = e || t.getBody();\n\n\t\t\tif (!is(t.hasVisual))\n\t\t\t\tt.hasVisual = s.visual;\n\n\t\t\teach(t.dom.select('table,a', e), function(e) {\n\t\t\t\tvar v;\n\n\t\t\t\tswitch (e.nodeName) {\n\t\t\t\t\tcase 'TABLE':\n\t\t\t\t\t\tv = t.dom.getAttrib(e, 'border');\n\n\t\t\t\t\t\tif (!v || v == '0') {\n\t\t\t\t\t\t\tif (t.hasVisual)\n\t\t\t\t\t\t\t\tt.dom.addClass(e, s.visual_table_class);\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tt.dom.removeClass(e, s.visual_table_class);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tcase 'A':\n\t\t\t\t\t\tv = t.dom.getAttrib(e, 'name');\n\n\t\t\t\t\t\tif (v) {\n\t\t\t\t\t\t\tif (t.hasVisual)\n\t\t\t\t\t\t\t\tt.dom.addClass(e, 'mceItemAnchor');\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tt.dom.removeClass(e, 'mceItemAnchor');\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.onVisualAid.dispatch(t, e, t.hasVisual);\n\t\t},\n\n\t\tremove : function() {\n\t\t\tvar t = this, e = t.getContainer();\n\n\t\t\tt.removed = 1; // Cancels post remove event execution\n\t\t\tt.hide();\n\n\t\t\tt.execCallback('remove_instance_callback', t);\n\t\t\tt.onRemove.dispatch(t);\n\n\t\t\t// Clear all execCommand listeners this is required to avoid errors if the editor was removed inside another command\n\t\t\tt.onExecCommand.listeners = [];\n\n\t\t\ttinymce.remove(t);\n\t\t\tDOM.remove(e);\n\t\t},\n\n\t\tdestroy : function(s) {\n\t\t\tvar t = this;\n\n\t\t\t// One time is enough\n\t\t\tif (t.destroyed)\n\t\t\t\treturn;\n\n\t\t\tif (!s) {\n\t\t\t\ttinymce.removeUnload(t.destroy);\n\t\t\t\ttinyMCE.onBeforeUnload.remove(t._beforeUnload);\n\n\t\t\t\t// Manual destroy\n\t\t\t\tif (t.theme && t.theme.destroy)\n\t\t\t\t\tt.theme.destroy();\n\n\t\t\t\t// Destroy controls, selection and dom\n\t\t\t\tt.controlManager.destroy();\n\t\t\t\tt.selection.destroy();\n\t\t\t\tt.dom.destroy();\n\n\t\t\t\t// Remove all events\n\n\t\t\t\t// Don't clear the window or document if content editable\n\t\t\t\t// is enabled since other instances might still be present\n\t\t\t\tif (!t.settings.content_editable) {\n\t\t\t\t\tEvent.clear(t.getWin());\n\t\t\t\t\tEvent.clear(t.getDoc());\n\t\t\t\t}\n\n\t\t\t\tEvent.clear(t.getBody());\n\t\t\t\tEvent.clear(t.formElement);\n\t\t\t}\n\n\t\t\tif (t.formElement) {\n\t\t\t\tt.formElement.submit = t.formElement._mceOldSubmit;\n\t\t\t\tt.formElement._mceOldSubmit = null;\n\t\t\t}\n\n\t\t\tt.contentAreaContainer = t.formElement = t.container = t.settings.content_element = t.bodyElement = t.contentDocument = t.contentWindow = null;\n\n\t\t\tif (t.selection)\n\t\t\t\tt.selection = t.selection.win = t.selection.dom = t.selection.dom.doc = null;\n\n\t\t\tt.destroyed = 1;\n\t\t},\n\n\t\t// Internal functions\n\n\t\t_addEvents : function() {\n\t\t\t// 'focus', 'blur', 'dblclick', 'beforedeactivate', submit, reset\n\t\t\tvar t = this, i, s = t.settings, dom = t.dom, lo = {\n\t\t\t\tmouseup : 'onMouseUp',\n\t\t\t\tmousedown : 'onMouseDown',\n\t\t\t\tclick : 'onClick',\n\t\t\t\tkeyup : 'onKeyUp',\n\t\t\t\tkeydown : 'onKeyDown',\n\t\t\t\tkeypress : 'onKeyPress',\n\t\t\t\tsubmit : 'onSubmit',\n\t\t\t\treset : 'onReset',\n\t\t\t\tcontextmenu : 'onContextMenu',\n\t\t\t\tdblclick : 'onDblClick',\n\t\t\t\tpaste : 'onPaste' // Doesn't work in all browsers yet\n\t\t\t};\n\n\t\t\tfunction eventHandler(e, o) {\n\t\t\t\tvar ty = e.type;\n\n\t\t\t\t// Don't fire events when it's removed\n\t\t\t\tif (t.removed)\n\t\t\t\t\treturn;\n\n\t\t\t\t// Generic event handler\n\t\t\t\tif (t.onEvent.dispatch(t, e, o) !== false) {\n\t\t\t\t\t// Specific event handler\n\t\t\t\t\tt[lo[e.fakeType || e.type]].dispatch(t, e, o);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Add DOM events\n\t\t\teach(lo, function(v, k) {\n\t\t\t\tswitch (k) {\n\t\t\t\t\tcase 'contextmenu':\n\t\t\t\t\t\tdom.bind(t.getDoc(), k, eventHandler);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'paste':\n\t\t\t\t\t\tdom.bind(t.getBody(), k, function(e) {\n\t\t\t\t\t\t\teventHandler(e);\n\t\t\t\t\t\t});\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'submit':\n\t\t\t\t\tcase 'reset':\n\t\t\t\t\t\tdom.bind(t.getElement().form || DOM.getParent(t.id, 'form'), k, eventHandler);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tdefault:\n\t\t\t\t\t\tdom.bind(s.content_editable ? t.getBody() : t.getDoc(), k, eventHandler);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tdom.bind(s.content_editable ? t.getBody() : (isGecko ? t.getDoc() : t.getWin()), 'focus', function(e) {\n\t\t\t\tt.focus(true);\n\t\t\t});\n\n\n\t\t\t// Fixes bug where a specified document_base_uri could result in broken images\n\t\t\t// This will also fix drag drop of images in Gecko\n\t\t\tif (tinymce.isGecko) {\n\t\t\t\tdom.bind(t.getDoc(), 'DOMNodeInserted', function(e) {\n\t\t\t\t\tvar v;\n\n\t\t\t\t\te = e.target;\n\n\t\t\t\t\tif (e.nodeType === 1 && e.nodeName === 'IMG' && (v = e.getAttribute('data-mce-src')))\n\t\t\t\t\t\te.src = t.documentBaseURI.toAbsolute(v);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Set various midas options in Gecko\n\t\t\tif (isGecko) {\n\t\t\t\tfunction setOpts() {\n\t\t\t\t\tvar t = this, d = t.getDoc(), s = t.settings;\n\n\t\t\t\t\tif (isGecko && !s.readonly) {\n\t\t\t\t\t\tt._refreshContentEditable();\n\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t// Try new Gecko method\n\t\t\t\t\t\t\td.execCommand(\"styleWithCSS\", 0, false);\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\t// Use old method\n\t\t\t\t\t\t\tif (!t._isHidden())\n\t\t\t\t\t\t\t\ttry {d.execCommand(\"useCSS\", 0, true);} catch (ex) {}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (!s.table_inline_editing)\n\t\t\t\t\t\t\ttry {d.execCommand('enableInlineTableEditing', false, false);} catch (ex) {}\n\n\t\t\t\t\t\tif (!s.object_resizing)\n\t\t\t\t\t\t\ttry {d.execCommand('enableObjectResizing', false, false);} catch (ex) {}\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\tt.onBeforeExecCommand.add(setOpts);\n\t\t\t\tt.onMouseDown.add(setOpts);\n\t\t\t}\n\n\t\t\t// Add node change handlers\n\t\t\tt.onMouseUp.add(t.nodeChanged);\n\t\t\t//t.onClick.add(t.nodeChanged);\n\t\t\tt.onKeyUp.add(function(ed, e) {\n\t\t\t\tvar c = e.keyCode;\n\n\t\t\t\tif ((c >= 33 && c <= 36) || (c >= 37 && c <= 40) || c == 13 || c == 45 || c == 46 || c == 8 || (tinymce.isMac && (c == 91 || c == 93)) || e.ctrlKey)\n\t\t\t\t\tt.nodeChanged();\n\t\t\t});\n\n\n\t\t\t// Add block quote deletion handler\n\t\t\tt.onKeyDown.add(function(ed, e) {\n\t\t\t\t// Was the BACKSPACE key pressed?\n\t\t\t\tif (e.keyCode != 8)\n\t\t\t\t\treturn;\n\n\t\t\t\tvar n = ed.selection.getRng().startContainer;\n\t\t\t\tvar offset = ed.selection.getRng().startOffset;\n\n\t\t\t\twhile (n && n.nodeType && n.nodeType != 1 && n.parentNode)\n\t\t\t\t\tn = n.parentNode;\n\n\t\t\t\t// Is the cursor at the beginning of a blockquote?\n\t\t\t\tif (n && n.parentNode && n.parentNode.tagName === 'BLOCKQUOTE' && n.parentNode.firstChild == n && offset == 0) {\n\t\t\t\t\t// Remove the blockquote\n\t\t\t\t\ted.formatter.toggle('blockquote', null, n.parentNode);\n\n\t\t\t\t\t// Move the caret to the beginning of n\n\t\t\t\t\tvar rng = ed.selection.getRng();\n\t\t\t\t\trng.setStart(n, 0);\n\t\t\t\t\trng.setEnd(n, 0);\n\t\t\t\t\ted.selection.setRng(rng);\n\t\t\t\t\ted.selection.collapse(false);\n\t\t\t\t}\n\t\t\t});\n\n\n\n\t\t\t// Add reset handler\n\t\t\tt.onReset.add(function() {\n\t\t\t\tt.setContent(t.startContent, {format : 'raw'});\n\t\t\t});\n\n\t\t\t// Add shortcuts\n\t\t\tif (s.custom_shortcuts) {\n\t\t\t\tif (s.custom_undo_redo_keyboard_shortcuts) {\n\t\t\t\t\tt.addShortcut('ctrl+z', t.getLang('undo_desc'), 'Undo');\n\t\t\t\t\tt.addShortcut('ctrl+y', t.getLang('redo_desc'), 'Redo');\n\t\t\t\t}\n\n\t\t\t\t// Add default shortcuts for gecko\n\t\t\t\tt.addShortcut('ctrl+b', t.getLang('bold_desc'), 'Bold');\n\t\t\t\tt.addShortcut('ctrl+i', t.getLang('italic_desc'), 'Italic');\n\t\t\t\tt.addShortcut('ctrl+u', t.getLang('underline_desc'), 'Underline');\n\n\t\t\t\t// BlockFormat shortcuts keys\n\t\t\t\tfor (i=1; i<=6; i++)\n\t\t\t\t\tt.addShortcut('ctrl+' + i, '', ['FormatBlock', false, 'h' + i]);\n\n\t\t\t\tt.addShortcut('ctrl+7', '', ['FormatBlock', false, 'p']);\n\t\t\t\tt.addShortcut('ctrl+8', '', ['FormatBlock', false, 'div']);\n\t\t\t\tt.addShortcut('ctrl+9', '', ['FormatBlock', false, 'address']);\n\n\t\t\t\tfunction find(e) {\n\t\t\t\t\tvar v = null;\n\n\t\t\t\t\tif (!e.altKey && !e.ctrlKey && !e.metaKey)\n\t\t\t\t\t\treturn v;\n\n\t\t\t\t\teach(t.shortcuts, function(o) {\n\t\t\t\t\t\tif (tinymce.isMac && o.ctrl != e.metaKey)\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\telse if (!tinymce.isMac && o.ctrl != e.ctrlKey)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tif (o.alt != e.altKey)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tif (o.shift != e.shiftKey)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tif (e.keyCode == o.keyCode || (e.charCode && e.charCode == o.charCode)) {\n\t\t\t\t\t\t\tv = o;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\n\t\t\t\t\treturn v;\n\t\t\t\t};\n\n\t\t\t\tt.onKeyUp.add(function(ed, e) {\n\t\t\t\t\tvar o = find(e);\n\n\t\t\t\t\tif (o)\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t});\n\n\t\t\t\tt.onKeyPress.add(function(ed, e) {\n\t\t\t\t\tvar o = find(e);\n\n\t\t\t\t\tif (o)\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t});\n\n\t\t\t\tt.onKeyDown.add(function(ed, e) {\n\t\t\t\t\tvar o = find(e);\n\n\t\t\t\t\tif (o) {\n\t\t\t\t\t\to.func.call(o.scope);\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (tinymce.isIE) {\n\t\t\t\t// Fix so resize will only update the width and height attributes not the styles of an image\n\t\t\t\t// It will also block mceItemNoResize items\n\t\t\t\tdom.bind(t.getDoc(), 'controlselect', function(e) {\n\t\t\t\t\tvar re = t.resizeInfo, cb;\n\n\t\t\t\t\te = e.target;\n\n\t\t\t\t\t// Don't do this action for non image elements\n\t\t\t\t\tif (e.nodeName !== 'IMG')\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tif (re)\n\t\t\t\t\t\tdom.unbind(re.node, re.ev, re.cb);\n\n\t\t\t\t\tif (!dom.hasClass(e, 'mceItemNoResize')) {\n\t\t\t\t\t\tev = 'resizeend';\n\t\t\t\t\t\tcb = dom.bind(e, ev, function(e) {\n\t\t\t\t\t\t\tvar v;\n\n\t\t\t\t\t\t\te = e.target;\n\n\t\t\t\t\t\t\tif (v = dom.getStyle(e, 'width')) {\n\t\t\t\t\t\t\t\tdom.setAttrib(e, 'width', v.replace(/[^0-9%]+/g, ''));\n\t\t\t\t\t\t\t\tdom.setStyle(e, 'width', '');\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (v = dom.getStyle(e, 'height')) {\n\t\t\t\t\t\t\t\tdom.setAttrib(e, 'height', v.replace(/[^0-9%]+/g, ''));\n\t\t\t\t\t\t\t\tdom.setStyle(e, 'height', '');\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t} else {\n\t\t\t\t\t\tev = 'resizestart';\n\t\t\t\t\t\tcb = dom.bind(e, 'resizestart', Event.cancel, Event);\n\t\t\t\t\t}\n\n\t\t\t\t\tre = t.resizeInfo = {\n\t\t\t\t\t\tnode : e,\n\t\t\t\t\t\tev : ev,\n\t\t\t\t\t\tcb : cb\n\t\t\t\t\t};\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (tinymce.isOpera) {\n\t\t\t\tt.onClick.add(function(ed, e) {\n\t\t\t\t\tEvent.prevent(e);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Add custom undo/redo handlers\n\t\t\tif (s.custom_undo_redo) {\n\t\t\t\tfunction addUndo() {\n\t\t\t\t\tt.undoManager.typing = false;\n\t\t\t\t\tt.undoManager.add();\n\t\t\t\t};\n\n\t\t\t\tdom.bind(t.getDoc(), 'focusout', function(e) {\n\t\t\t\t\tif (!t.removed && t.undoManager.typing)\n\t\t\t\t\t\taddUndo();\n\t\t\t\t});\n\n\t\t\t\t// Add undo level when contents is drag/dropped within the editor\n\t\t\t\tt.dom.bind(t.dom.getRoot(), 'dragend', function(e) {\n\t\t\t\t\taddUndo();\n\t\t\t\t});\n\n\t\t\t\tt.onKeyUp.add(function(ed, e) {\n\t\t\t\t\tvar keyCode = e.keyCode;\n\n\t\t\t\t\tif ((keyCode >= 33 && keyCode <= 36) || (keyCode >= 37 && keyCode <= 40) || keyCode == 13 || keyCode == 45 || e.ctrlKey)\n\t\t\t\t\t\taddUndo();\n\t\t\t\t});\n\n\t\t\t\tt.onKeyDown.add(function(ed, e) {\n\t\t\t\t\tvar keyCode = e.keyCode, sel;\n\n\t\t\t\t\tif (keyCode == 8) {\n\t\t\t\t\t\tsel = t.getDoc().selection;\n\n\t\t\t\t\t\t// Fix IE control + backspace browser bug\n\t\t\t\t\t\tif (sel && sel.createRange && sel.createRange().item) {\n\t\t\t\t\t\t\tt.undoManager.beforeChange();\n\t\t\t\t\t\t\ted.dom.remove(sel.createRange().item(0));\n\t\t\t\t\t\t\taddUndo();\n\n\t\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Is caracter positon keys left,right,up,down,home,end,pgdown,pgup,enter\n\t\t\t\t\tif ((keyCode >= 33 && keyCode <= 36) || (keyCode >= 37 && keyCode <= 40) || keyCode == 13 || keyCode == 45) {\n\t\t\t\t\t\t// Add position before enter key is pressed, used by IE since it still uses the default browser behavior\n\t\t\t\t\t\t// Todo: Remove this once we normalize enter behavior on IE\n\t\t\t\t\t\tif (tinymce.isIE && keyCode == 13)\n\t\t\t\t\t\t\tt.undoManager.beforeChange();\n\n\t\t\t\t\t\tif (t.undoManager.typing)\n\t\t\t\t\t\t\taddUndo();\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// If key isn't shift,ctrl,alt,capslock,metakey\n\t\t\t\t\tif ((keyCode < 16 || keyCode > 20) && keyCode != 224 && keyCode != 91 && !t.undoManager.typing) {\n\t\t\t\t\t\tt.undoManager.beforeChange();\n\t\t\t\t\t\tt.undoManager.typing = true;\n\t\t\t\t\t\tt.undoManager.add();\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tt.onMouseDown.add(function() {\n\t\t\t\t\tif (t.undoManager.typing)\n\t\t\t\t\t\taddUndo();\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Bug fix for FireFox keeping styles from end of selection instead of start.\n\t\t\tif (tinymce.isGecko) {\n\t\t\t\tfunction getAttributeApplyFunction() {\n\t\t\t\t\tvar template = t.dom.getAttribs(t.selection.getStart().cloneNode(false));\n\n\t\t\t\t\treturn function() {\n\t\t\t\t\t\tvar target = t.selection.getStart();\n\n\t\t\t\t\t\tif (target !== t.getBody()) {\n\t\t\t\t\t\t\tt.dom.setAttrib(target, \"style\", null);\n\n\t\t\t\t\t\t\teach(template, function(attr) {\n\t\t\t\t\t\t\t\ttarget.setAttributeNode(attr.cloneNode(true));\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\tfunction isSelectionAcrossElements() {\n\t\t\t\t\tvar s = t.selection;\n\n\t\t\t\t\treturn !s.isCollapsed() && s.getStart() != s.getEnd();\n\t\t\t\t}\n\n\t\t\t\tt.onKeyPress.add(function(ed, e) {\n\t\t\t\t\tvar applyAttributes;\n\n\t\t\t\t\tif ((e.keyCode == 8 || e.keyCode == 46) && isSelectionAcrossElements()) {\n\t\t\t\t\t\tapplyAttributes = getAttributeApplyFunction();\n\t\t\t\t\t\tt.getDoc().execCommand('delete', false, null);\n\t\t\t\t\t\tapplyAttributes();\n\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tt.dom.bind(t.getDoc(), 'cut', function(e) {\n\t\t\t\t\tvar applyAttributes;\n\n\t\t\t\t\tif (isSelectionAcrossElements()) {\n\t\t\t\t\t\tapplyAttributes = getAttributeApplyFunction();\n\t\t\t\t\t\tt.onKeyUp.addToTop(Event.cancel, Event);\n\n\t\t\t\t\t\tsetTimeout(function() {\n\t\t\t\t\t\t\tapplyAttributes();\n\t\t\t\t\t\t\tt.onKeyUp.remove(Event.cancel, Event);\n\t\t\t\t\t\t}, 0);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\t_refreshContentEditable : function() {\n\t\t\tvar self = this, body, parent;\n\n\t\t\t// Check if the editor was hidden and the re-initalize contentEditable mode by removing and adding the body again\n\t\t\tif (self._isHidden()) {\n\t\t\t\tbody = self.getBody();\n\t\t\t\tparent = body.parentNode;\n\n\t\t\t\tparent.removeChild(body);\n\t\t\t\tparent.appendChild(body);\n\n\t\t\t\tbody.focus();\n\t\t\t}\n\t\t},\n\n\t\t_isHidden : function() {\n\t\t\tvar s;\n\n\t\t\tif (!isGecko)\n\t\t\t\treturn 0;\n\n\t\t\t// Weird, wheres that cursor selection?\n\t\t\ts = this.selection.getSel();\n\t\t\treturn (!s || !s.rangeCount || s.rangeCount == 0);\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\t// Added for compression purposes\n\tvar each = tinymce.each, undefined, TRUE = true, FALSE = false;\n\n\ttinymce.EditorCommands = function(editor) {\n\t\tvar dom = editor.dom,\n\t\t\tselection = editor.selection,\n\t\t\tcommands = {state: {}, exec : {}, value : {}},\n\t\t\tsettings = editor.settings,\n\t\t\tformatter = editor.formatter,\n\t\t\tbookmark;\n\n\t\tfunction execCommand(command, ui, value) {\n\t\t\tvar func;\n\n\t\t\tcommand = command.toLowerCase();\n\t\t\tif (func = commands.exec[command]) {\n\t\t\t\tfunc(command, ui, value);\n\t\t\t\treturn TRUE;\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\tfunction queryCommandState(command) {\n\t\t\tvar func;\n\n\t\t\tcommand = command.toLowerCase();\n\t\t\tif (func = commands.state[command])\n\t\t\t\treturn func(command);\n\n\t\t\treturn -1;\n\t\t};\n\n\t\tfunction queryCommandValue(command) {\n\t\t\tvar func;\n\n\t\t\tcommand = command.toLowerCase();\n\t\t\tif (func = commands.value[command])\n\t\t\t\treturn func(command);\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\tfunction addCommands(command_list, type) {\n\t\t\ttype = type || 'exec';\n\n\t\t\teach(command_list, function(callback, command) {\n\t\t\t\teach(command.toLowerCase().split(','), function(command) {\n\t\t\t\t\tcommands[type][command] = callback;\n\t\t\t\t});\n\t\t\t});\n\t\t};\n\n\t\t// Expose public methods\n\t\ttinymce.extend(this, {\n\t\t\texecCommand : execCommand,\n\t\t\tqueryCommandState : queryCommandState,\n\t\t\tqueryCommandValue : queryCommandValue,\n\t\t\taddCommands : addCommands\n\t\t});\n\n\t\t// Private methods\n\n\t\tfunction execNativeCommand(command, ui, value) {\n\t\t\tif (ui === undefined)\n\t\t\t\tui = FALSE;\n\n\t\t\tif (value === undefined)\n\t\t\t\tvalue = null;\n\n\t\t\treturn editor.getDoc().execCommand(command, ui, value);\n\t\t};\n\n\t\tfunction isFormatMatch(name) {\n\t\t\treturn formatter.match(name);\n\t\t};\n\n\t\tfunction toggleFormat(name, value) {\n\t\t\tformatter.toggle(name, value ? {value : value} : undefined);\n\t\t};\n\n\t\tfunction storeSelection(type) {\n\t\t\tbookmark = selection.getBookmark(type);\n\t\t};\n\n\t\tfunction restoreSelection() {\n\t\t\tselection.moveToBookmark(bookmark);\n\t\t};\n\n\t\t// Add execCommand overrides\n\t\taddCommands({\n\t\t\t// Ignore these, added for compatibility\n\t\t\t'mceResetDesignMode,mceBeginUndoLevel' : function() {},\n\n\t\t\t// Add undo manager logic\n\t\t\t'mceEndUndoLevel,mceAddUndoLevel' : function() {\n\t\t\t\teditor.undoManager.add();\n\t\t\t},\n\n\t\t\t'Cut,Copy,Paste' : function(command) {\n\t\t\t\tvar doc = editor.getDoc(), failed;\n\n\t\t\t\t// Try executing the native command\n\t\t\t\ttry {\n\t\t\t\t\texecNativeCommand(command);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Command failed\n\t\t\t\t\tfailed = TRUE;\n\t\t\t\t}\n\n\t\t\t\t// Present alert message about clipboard access not being available\n\t\t\t\tif (failed || !doc.queryCommandSupported(command)) {\n\t\t\t\t\tif (tinymce.isGecko) {\n\t\t\t\t\t\teditor.windowManager.confirm(editor.getLang('clipboard_msg'), function(state) {\n\t\t\t\t\t\t\tif (state)\n\t\t\t\t\t\t\t\topen('http://www.mozilla.org/editor/midasdemo/securityprefs.html', '_blank');\n\t\t\t\t\t\t});\n\t\t\t\t\t} else\n\t\t\t\t\t\teditor.windowManager.alert(editor.getLang('clipboard_no_support'));\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Override unlink command\n\t\t\tunlink : function(command) {\n\t\t\t\tif (selection.isCollapsed())\n\t\t\t\t\tselection.select(selection.getNode());\n\n\t\t\t\texecNativeCommand(command);\n\t\t\t\tselection.collapse(FALSE);\n\t\t\t},\n\n\t\t\t// Override justify commands to use the text formatter engine\n\t\t\t'JustifyLeft,JustifyCenter,JustifyRight,JustifyFull' : function(command) {\n\t\t\t\tvar align = command.substring(7);\n\n\t\t\t\t// Remove all other alignments first\n\t\t\t\teach('left,center,right,full'.split(','), function(name) {\n\t\t\t\t\tif (align != name)\n\t\t\t\t\t\tformatter.remove('align' + name);\n\t\t\t\t});\n\n\t\t\t\ttoggleFormat('align' + align);\n\t\t\t\texecCommand('mceRepaint');\n\t\t\t},\n\n\t\t\t// Override list commands to fix WebKit bug\n\t\t\t'InsertUnorderedList,InsertOrderedList' : function(command) {\n\t\t\t\tvar listElm, listParent;\n\n\t\t\t\texecNativeCommand(command);\n\n\t\t\t\t// WebKit produces lists within block elements so we need to split them\n\t\t\t\t// we will replace the native list creation logic to custom logic later on\n\t\t\t\t// TODO: Remove this when the list creation logic is removed\n\t\t\t\tlistElm = dom.getParent(selection.getNode(), 'ol,ul');\n\t\t\t\tif (listElm) {\n\t\t\t\t\tlistParent = listElm.parentNode;\n\n\t\t\t\t\t// If list is within a text block then split that block\n\t\t\t\t\tif (/^(H[1-6]|P|ADDRESS|PRE)$/.test(listParent.nodeName)) {\n\t\t\t\t\t\tstoreSelection();\n\t\t\t\t\t\tdom.split(listParent, listElm);\n\t\t\t\t\t\trestoreSelection();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Override commands to use the text formatter engine\n\t\t\t'Bold,Italic,Underline,Strikethrough,Superscript,Subscript' : function(command) {\n\t\t\t\ttoggleFormat(command);\n\t\t\t},\n\n\t\t\t// Override commands to use the text formatter engine\n\t\t\t'ForeColor,HiliteColor,FontName' : function(command, ui, value) {\n\t\t\t\ttoggleFormat(command, value);\n\t\t\t},\n\n\t\t\tFontSize : function(command, ui, value) {\n\t\t\t\tvar fontClasses, fontSizes;\n\n\t\t\t\t// Convert font size 1-7 to styles\n\t\t\t\tif (value >= 1 && value <= 7) {\n\t\t\t\t\tfontSizes = tinymce.explode(settings.font_size_style_values);\n\t\t\t\t\tfontClasses = tinymce.explode(settings.font_size_classes);\n\n\t\t\t\t\tif (fontClasses)\n\t\t\t\t\t\tvalue = fontClasses[value - 1] || value;\n\t\t\t\t\telse\n\t\t\t\t\t\tvalue = fontSizes[value - 1] || value;\n\t\t\t\t}\n\n\t\t\t\ttoggleFormat(command, value);\n\t\t\t},\n\n\t\t\tRemoveFormat : function(command) {\n\t\t\t\tformatter.remove(command);\n\t\t\t},\n\n\t\t\tmceBlockQuote : function(command) {\n\t\t\t\ttoggleFormat('blockquote');\n\t\t\t},\n\n\t\t\tFormatBlock : function(command, ui, value) {\n\t\t\t\treturn toggleFormat(value || 'p');\n\t\t\t},\n\n\t\t\tmceCleanup : function() {\n\t\t\t\tvar bookmark = selection.getBookmark();\n\n\t\t\t\teditor.setContent(editor.getContent({cleanup : TRUE}), {cleanup : TRUE});\n\n\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t},\n\n\t\t\tmceRemoveNode : function(command, ui, value) {\n\t\t\t\tvar node = value || selection.getNode();\n\n\t\t\t\t// Make sure that the body node isn't removed\n\t\t\t\tif (node != editor.getBody()) {\n\t\t\t\t\tstoreSelection();\n\t\t\t\t\teditor.dom.remove(node, TRUE);\n\t\t\t\t\trestoreSelection();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tmceSelectNodeDepth : function(command, ui, value) {\n\t\t\t\tvar counter = 0;\n\n\t\t\t\tdom.getParent(selection.getNode(), function(node) {\n\t\t\t\t\tif (node.nodeType == 1 && counter++ == value) {\n\t\t\t\t\t\tselection.select(node);\n\t\t\t\t\t\treturn FALSE;\n\t\t\t\t\t}\n\t\t\t\t}, editor.getBody());\n\t\t\t},\n\n\t\t\tmceSelectNode : function(command, ui, value) {\n\t\t\t\tselection.select(value);\n\t\t\t},\n\n\t\t\tmceInsertContent : function(command, ui, value) {\n\t\t\t\tvar parser, serializer, parentNode, rootNode, fragment, args,\n\t\t\t\t\tmarker, nodeRect, viewPortRect, rng, node, node2, bookmarkHtml, viewportBodyElement;\n\n\t\t\t\t// Setup parser and serializer\n\t\t\t\tparser = editor.parser;\n\t\t\t\tserializer = new tinymce.html.Serializer({}, editor.schema);\n\t\t\t\tbookmarkHtml = '<span id=\"mce_marker\" data-mce-type=\"bookmark\">\\uFEFF</span>';\n\n\t\t\t\t// Run beforeSetContent handlers on the HTML to be inserted\n\t\t\t\targs = {content: value, format: 'html'};\n\t\t\t\tselection.onBeforeSetContent.dispatch(selection, args);\n\t\t\t\tvalue = args.content;\n\n\t\t\t\t// Add caret at end of contents if it's missing\n\t\t\t\tif (value.indexOf('{$caret}') == -1)\n\t\t\t\t\tvalue += '{$caret}';\n\n\t\t\t\t// Replace the caret marker with a span bookmark element\n\t\t\t\tvalue = value.replace(/\\{\\$caret\\}/, bookmarkHtml);\n\n\t\t\t\t// Insert node maker where we will insert the new HTML and get it's parent\n\t\t\t\tif (!selection.isCollapsed())\n\t\t\t\t\teditor.getDoc().execCommand('Delete', false, null);\n\n\t\t\t\tparentNode = selection.getNode();\n\n\t\t\t\t// Parse the fragment within the context of the parent node\n\t\t\t\targs = {context : parentNode.nodeName.toLowerCase()};\n\t\t\t\tfragment = parser.parse(value, args);\n\n\t\t\t\t// Move the caret to a more suitable location\n\t\t\t\tnode = fragment.lastChild;\n\t\t\t\tif (node.attr('id') == 'mce_marker') {\n\t\t\t\t\tmarker = node;\n\n\t\t\t\t\tfor (node = node.prev; node; node = node.walk(true)) {\n\t\t\t\t\t\tif (node.type == 3 || !dom.isBlock(node.name)) {\n\t\t\t\t\t\t\tnode.parent.insert(marker, node, node.name === 'br');\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// If parser says valid we can insert the contents into that parent\n\t\t\t\tif (!args.invalid) {\n\t\t\t\t\tvalue = serializer.serialize(fragment);\n\n\t\t\t\t\t// Check if parent is empty or only has one BR element then set the innerHTML of that parent\n\t\t\t\t\tnode = parentNode.firstChild;\n\t\t\t\t\tnode2 = parentNode.lastChild;\n\t\t\t\t\tif (!node || (node === node2 && node.nodeName === 'BR'))\n\t\t\t\t\t\tdom.setHTML(parentNode, value);\n\t\t\t\t\telse\n\t\t\t\t\t\tselection.setContent(value);\n\t\t\t\t} else {\n\t\t\t\t\t// If the fragment was invalid within that context then we need\n\t\t\t\t\t// to parse and process the parent it's inserted into\n\n\t\t\t\t\t// Insert bookmark node and get the parent\n\t\t\t\t\tselection.setContent(bookmarkHtml);\n\t\t\t\t\tparentNode = editor.selection.getNode();\n\t\t\t\t\trootNode = editor.getBody();\n\n\t\t\t\t\t// Opera will return the document node when selection is in root\n\t\t\t\t\tif (parentNode.nodeType == 9)\n\t\t\t\t\t\tparentNode = node = rootNode;\n\t\t\t\t\telse\n\t\t\t\t\t\tnode = parentNode;\n\n\t\t\t\t\t// Find the ancestor just before the root element\n\t\t\t\t\twhile (node !== rootNode) {\n\t\t\t\t\t\tparentNode = node;\n\t\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Get the outer/inner HTML depending on if we are in the root and parser and serialize that\n\t\t\t\t\tvalue = parentNode == rootNode ? rootNode.innerHTML : dom.getOuterHTML(parentNode);\n\t\t\t\t\tvalue = serializer.serialize(\n\t\t\t\t\t\tparser.parse(\n\t\t\t\t\t\t\t// Need to replace by using a function since $ in the contents would otherwise be a problem\n\t\t\t\t\t\t\tvalue.replace(/<span (id=\"mce_marker\"|id=mce_marker).+?<\\/span>/i, function() {\n\t\t\t\t\t\t\t\treturn serializer.serialize(fragment);\n\t\t\t\t\t\t\t})\n\t\t\t\t\t\t)\n\t\t\t\t\t);\n\n\t\t\t\t\t// Set the inner/outer HTML depending on if we are in the root or not\n\t\t\t\t\tif (parentNode == rootNode)\n\t\t\t\t\t\tdom.setHTML(rootNode, value);\n\t\t\t\t\telse\n\t\t\t\t\t\tdom.setOuterHTML(parentNode, value);\n\t\t\t\t}\n\n\t\t\t\tmarker = dom.get('mce_marker');\n\n\t\t\t\t// Scroll range into view scrollIntoView on element can't be used since it will scroll the main view port as well\n\t\t\t\tnodeRect = dom.getRect(marker);\n\t\t\t\tviewPortRect = dom.getViewPort(editor.getWin());\n\n\t\t\t\t// Check if node is out side the viewport if it is then scroll to it\n\t\t\t\tif ((nodeRect.y + nodeRect.h > viewPortRect.y + viewPortRect.h || nodeRect.y < viewPortRect.y) ||\n\t\t\t\t\t(nodeRect.x > viewPortRect.x + viewPortRect.w || nodeRect.x < viewPortRect.x)) {\n\t\t\t\t\tviewportBodyElement = tinymce.isIE ? editor.getDoc().documentElement : editor.getBody();\n\t\t\t\t\tviewportBodyElement.scrollLeft = nodeRect.x;\n\t\t\t\t\tviewportBodyElement.scrollTop = nodeRect.y - viewPortRect.h + 25;\n\t\t\t\t}\n\n\t\t\t\t// Move selection before marker and remove it\n\t\t\t\trng = dom.createRng();\n\n\t\t\t\t// If previous sibling is a text node set the selection to the end of that node\n\t\t\t\tnode = marker.previousSibling;\n\t\t\t\tif (node && node.nodeType == 3) {\n\t\t\t\t\trng.setStart(node, node.nodeValue.length);\n\t\t\t\t} else {\n\t\t\t\t\t// If the previous sibling isn't a text node or doesn't exist set the selection before the marker node\n\t\t\t\t\trng.setStartBefore(marker);\n\t\t\t\t\trng.setEndBefore(marker);\n\t\t\t\t}\n\n\t\t\t\t// Remove the marker node and set the new range\n\t\t\t\tdom.remove(marker);\n\t\t\t\tselection.setRng(rng);\n\n\t\t\t\t// Dispatch after event and add any visual elements needed\n\t\t\t\tselection.onSetContent.dispatch(selection, args);\n\t\t\t\teditor.addVisual();\n\t\t\t},\n\n\t\t\tmceInsertRawHTML : function(command, ui, value) {\n\t\t\t\tselection.setContent('tiny_mce_marker');\n\t\t\t\teditor.setContent(editor.getContent().replace(/tiny_mce_marker/g, function() { return value }));\n\t\t\t},\n\n\t\t\tmceSetContent : function(command, ui, value) {\n\t\t\t\teditor.setContent(value);\n\t\t\t},\n\n\t\t\t'Indent,Outdent' : function(command) {\n\t\t\t\tvar intentValue, indentUnit, value;\n\n\t\t\t\t// Setup indent level\n\t\t\t\tintentValue = settings.indentation;\n\t\t\t\tindentUnit = /[a-z%]+$/i.exec(intentValue);\n\t\t\t\tintentValue = parseInt(intentValue);\n\n\t\t\t\tif (!queryCommandState('InsertUnorderedList') && !queryCommandState('InsertOrderedList')) {\n\t\t\t\t\teach(selection.getSelectedBlocks(), function(element) {\n\t\t\t\t\t\tif (command == 'outdent') {\n\t\t\t\t\t\t\tvalue = Math.max(0, parseInt(element.style.paddingLeft || 0) - intentValue);\n\t\t\t\t\t\t\tdom.setStyle(element, 'paddingLeft', value ? value + indentUnit : '');\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\tdom.setStyle(element, 'paddingLeft', (parseInt(element.style.paddingLeft || 0) + intentValue) + indentUnit);\n\t\t\t\t\t});\n\t\t\t\t} else\n\t\t\t\t\texecNativeCommand(command);\n\t\t\t},\n\n\t\t\tmceRepaint : function() {\n\t\t\t\tvar bookmark;\n\n\t\t\t\tif (tinymce.isGecko) {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tstoreSelection(TRUE);\n\n\t\t\t\t\t\tif (selection.getSel())\n\t\t\t\t\t\t\tselection.getSel().selectAllChildren(editor.getBody());\n\n\t\t\t\t\t\tselection.collapse(TRUE);\n\t\t\t\t\t\trestoreSelection();\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// Ignore\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tmceToggleFormat : function(command, ui, value) {\n\t\t\t\tformatter.toggle(value);\n\t\t\t},\n\n\t\t\tInsertHorizontalRule : function() {\n\t\t\t\teditor.execCommand('mceInsertContent', false, '<hr />');\n\t\t\t},\n\n\t\t\tmceToggleVisualAid : function() {\n\t\t\t\teditor.hasVisual = !editor.hasVisual;\n\t\t\t\teditor.addVisual();\n\t\t\t},\n\n\t\t\tmceReplaceContent : function(command, ui, value) {\n\t\t\t\teditor.execCommand('mceInsertContent', false, value.replace(/\\{\\$selection\\}/g, selection.getContent({format : 'text'})));\n\t\t\t},\n\n\t\t\tmceInsertLink : function(command, ui, value) {\n\t\t\t\tvar anchor;\n\n\t\t\t\tif (typeof(value) == 'string')\n\t\t\t\t\tvalue = {href : value};\n\n\t\t\t\tanchor = dom.getParent(selection.getNode(), 'a');\n\n\t\t\t\t// Spaces are never valid in URLs and it's a very common mistake for people to make so we fix it here.\n\t\t\t\tvalue.href = value.href.replace(' ', '%20');\n\n\t\t\t\t// Remove existing links if there could be child links or that the href isn't specified\n\t\t\t\tif (!anchor || !value.href) {\n\t\t\t\t\tformatter.remove('link');\n\t\t\t\t}\n\n\t\t\t\t// Apply new link to selection\n\t\t\t\tif (value.href) {\n\t\t\t\t\tformatter.apply('link', value, anchor);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tselectAll : function() {\n\t\t\t\tvar root = dom.getRoot(), rng = dom.createRng();\n\n\t\t\t\trng.setStart(root, 0);\n\t\t\t\trng.setEnd(root, root.childNodes.length);\n\n\t\t\t\teditor.selection.setRng(rng);\n\t\t\t}\n\t\t});\n\n\t\t// Add queryCommandState overrides\n\t\taddCommands({\n\t\t\t// Override justify commands\n\t\t\t'JustifyLeft,JustifyCenter,JustifyRight,JustifyFull' : function(command) {\n\t\t\t\treturn isFormatMatch('align' + command.substring(7));\n\t\t\t},\n\n\t\t\t'Bold,Italic,Underline,Strikethrough,Superscript,Subscript' : function(command) {\n\t\t\t\treturn isFormatMatch(command);\n\t\t\t},\n\n\t\t\tmceBlockQuote : function() {\n\t\t\t\treturn isFormatMatch('blockquote');\n\t\t\t},\n\n\t\t\tOutdent : function() {\n\t\t\t\tvar node;\n\n\t\t\t\tif (settings.inline_styles) {\n\t\t\t\t\tif ((node = dom.getParent(selection.getStart(), dom.isBlock)) && parseInt(node.style.paddingLeft) > 0)\n\t\t\t\t\t\treturn TRUE;\n\n\t\t\t\t\tif ((node = dom.getParent(selection.getEnd(), dom.isBlock)) && parseInt(node.style.paddingLeft) > 0)\n\t\t\t\t\t\treturn TRUE;\n\t\t\t\t}\n\n\t\t\t\treturn queryCommandState('InsertUnorderedList') || queryCommandState('InsertOrderedList') || (!settings.inline_styles && !!dom.getParent(selection.getNode(), 'BLOCKQUOTE'));\n\t\t\t},\n\n\t\t\t'InsertUnorderedList,InsertOrderedList' : function(command) {\n\t\t\t\treturn dom.getParent(selection.getNode(), command == 'insertunorderedlist' ? 'UL' : 'OL');\n\t\t\t}\n\t\t}, 'state');\n\n\t\t// Add queryCommandValue overrides\n\t\taddCommands({\n\t\t\t'FontSize,FontName' : function(command) {\n\t\t\t\tvar value = 0, parent;\n\n\t\t\t\tif (parent = dom.getParent(selection.getNode(), 'span')) {\n\t\t\t\t\tif (command == 'fontsize')\n\t\t\t\t\t\tvalue = parent.style.fontSize;\n\t\t\t\t\telse\n\t\t\t\t\t\tvalue = parent.style.fontFamily.replace(/, /g, ',').replace(/[\\'\\\"]/g, '').toLowerCase();\n\t\t\t\t}\n\n\t\t\t\treturn value;\n\t\t\t}\n\t\t}, 'value');\n\n\t\t// Add undo manager logic\n\t\tif (settings.custom_undo_redo) {\n\t\t\taddCommands({\n\t\t\t\tUndo : function() {\n\t\t\t\t\teditor.undoManager.undo();\n\t\t\t\t},\n\n\t\t\t\tRedo : function() {\n\t\t\t\t\teditor.undoManager.redo();\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t};\n})(tinymce);\n\n(function(tinymce) {\n\tvar Dispatcher = tinymce.util.Dispatcher;\n\n\ttinymce.UndoManager = function(editor) {\n\t\tvar self, index = 0, data = [], beforeBookmark;\n\n\t\tfunction getContent() {\n\t\t\treturn tinymce.trim(editor.getContent({format : 'raw', no_events : 1}));\n\t\t};\n\n\t\treturn self = {\n\t\t\ttyping : false,\n\n\t\t\tonAdd : new Dispatcher(self),\n\n\t\t\tonUndo : new Dispatcher(self),\n\n\t\t\tonRedo : new Dispatcher(self),\n\n\t\t\tbeforeChange : function() {\n\t\t\t\tbeforeBookmark = editor.selection.getBookmark(2, true);\n\t\t\t},\n\n\t\t\tadd : function(level) {\n\t\t\t\tvar i, settings = editor.settings, lastLevel;\n\n\t\t\t\tlevel = level || {};\n\t\t\t\tlevel.content = getContent();\n\n\t\t\t\t// Add undo level if needed\n\t\t\t\tlastLevel = data[index];\n\t\t\t\tif (lastLevel && lastLevel.content == level.content)\n\t\t\t\t\treturn null;\n\n\t\t\t\t// Set before bookmark on previous level\n\t\t\t\tif (data[index])\n\t\t\t\t\tdata[index].beforeBookmark = beforeBookmark;\n\n\t\t\t\t// Time to compress\n\t\t\t\tif (settings.custom_undo_redo_levels) {\n\t\t\t\t\tif (data.length > settings.custom_undo_redo_levels) {\n\t\t\t\t\t\tfor (i = 0; i < data.length - 1; i++)\n\t\t\t\t\t\t\tdata[i] = data[i + 1];\n\n\t\t\t\t\t\tdata.length--;\n\t\t\t\t\t\tindex = data.length;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Get a non intrusive normalized bookmark\n\t\t\t\tlevel.bookmark = editor.selection.getBookmark(2, true);\n\n\t\t\t\t// Crop array if needed\n\t\t\t\tif (index < data.length - 1)\n\t\t\t\t\tdata.length = index + 1;\n\n\t\t\t\tdata.push(level);\n\t\t\t\tindex = data.length - 1;\n\n\t\t\t\tself.onAdd.dispatch(self, level);\n\t\t\t\teditor.isNotDirty = 0;\n\n\t\t\t\treturn level;\n\t\t\t},\n\n\t\t\tundo : function() {\n\t\t\t\tvar level, i;\n\n\t\t\t\tif (self.typing) {\n\t\t\t\t\tself.add();\n\t\t\t\t\tself.typing = false;\n\t\t\t\t}\n\n\t\t\t\tif (index > 0) {\n\t\t\t\t\tlevel = data[--index];\n\n\t\t\t\t\teditor.setContent(level.content, {format : 'raw'});\n\t\t\t\t\teditor.selection.moveToBookmark(level.beforeBookmark);\n\n\t\t\t\t\tself.onUndo.dispatch(self, level);\n\t\t\t\t}\n\n\t\t\t\treturn level;\n\t\t\t},\n\n\t\t\tredo : function() {\n\t\t\t\tvar level;\n\n\t\t\t\tif (index < data.length - 1) {\n\t\t\t\t\tlevel = data[++index];\n\n\t\t\t\t\teditor.setContent(level.content, {format : 'raw'});\n\t\t\t\t\teditor.selection.moveToBookmark(level.bookmark);\n\n\t\t\t\t\tself.onRedo.dispatch(self, level);\n\t\t\t\t}\n\n\t\t\t\treturn level;\n\t\t\t},\n\n\t\t\tclear : function() {\n\t\t\t\tdata = [];\n\t\t\t\tindex = 0;\n\t\t\t\tself.typing = false;\n\t\t\t},\n\n\t\t\thasUndo : function() {\n\t\t\t\treturn index > 0 || this.typing;\n\t\t\t},\n\n\t\t\thasRedo : function() {\n\t\t\t\treturn index < data.length - 1 && !this.typing;\n\t\t\t}\n\t\t};\n\t};\n})(tinymce);\n\n(function(tinymce) {\n\t// Shorten names\n\tvar Event = tinymce.dom.Event,\n\t\tisIE = tinymce.isIE,\n\t\tisGecko = tinymce.isGecko,\n\t\tisOpera = tinymce.isOpera,\n\t\teach = tinymce.each,\n\t\textend = tinymce.extend,\n\t\tTRUE = true,\n\t\tFALSE = false;\n\n\tfunction cloneFormats(node) {\n\t\tvar clone, temp, inner;\n\n\t\tdo {\n\t\t\tif (/^(SPAN|STRONG|B|EM|I|FONT|STRIKE|U)$/.test(node.nodeName)) {\n\t\t\t\tif (clone) {\n\t\t\t\t\ttemp = node.cloneNode(false);\n\t\t\t\t\ttemp.appendChild(clone);\n\t\t\t\t\tclone = temp;\n\t\t\t\t} else {\n\t\t\t\t\tclone = inner = node.cloneNode(false);\n\t\t\t\t}\n\n\t\t\t\tclone.removeAttribute('id');\n\t\t\t}\n\t\t} while (node = node.parentNode);\n\n\t\tif (clone)\n\t\t\treturn {wrapper : clone, inner : inner};\n\t};\n\n\t// Checks if the selection/caret is at the end of the specified block element\n\tfunction isAtEnd(rng, par) {\n\t\tvar rng2 = par.ownerDocument.createRange();\n\n\t\trng2.setStart(rng.endContainer, rng.endOffset);\n\t\trng2.setEndAfter(par);\n\n\t\t// Get number of characters to the right of the cursor if it's zero then we are at the end and need to merge the next block element\n\t\treturn rng2.cloneContents().textContent.length == 0;\n\t};\n\n\tfunction splitList(selection, dom, li) {\n\t\tvar listBlock, block;\n\n\t\tif (dom.isEmpty(li)) {\n\t\t\tlistBlock = dom.getParent(li, 'ul,ol');\n\n\t\t\tif (!dom.getParent(listBlock.parentNode, 'ul,ol')) {\n\t\t\t\tdom.split(listBlock, li);\n\t\t\t\tblock = dom.create('p', 0, '<br data-mce-bogus=\"1\" />');\n\t\t\t\tdom.replace(block, li);\n\t\t\t\tselection.select(block, 1);\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t}\n\n\t\treturn TRUE;\n\t};\n\n\ttinymce.create('tinymce.ForceBlocks', {\n\t\tForceBlocks : function(ed) {\n\t\t\tvar t = this, s = ed.settings, elm;\n\n\t\t\tt.editor = ed;\n\t\t\tt.dom = ed.dom;\n\t\t\telm = (s.forced_root_block || 'p').toLowerCase();\n\t\t\ts.element = elm.toUpperCase();\n\n\t\t\ted.onPreInit.add(t.setup, t);\n\t\t},\n\n\t\tsetup : function() {\n\t\t\tvar t = this, ed = t.editor, s = ed.settings, dom = ed.dom, selection = ed.selection, blockElements = ed.schema.getBlockElements();\n\n\t\t\t// Force root blocks\n\t\t\tif (s.forced_root_block) {\n\t\t\t\tfunction addRootBlocks() {\n\t\t\t\t\tvar node = selection.getStart(), rootNode = ed.getBody(), rng, startContainer, startOffset, endContainer, endOffset, rootBlockNode, tempNode, offset = -0xFFFFFF;\n\n\t\t\t\t\tif (!node || node.nodeType !== 1)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Check if node is wrapped in block\n\t\t\t\t\twhile (node != rootNode) {\n\t\t\t\t\t\tif (blockElements[node.nodeName])\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Get current selection\n\t\t\t\t\trng = selection.getRng();\n\t\t\t\t\tif (rng.setStart) {\n\t\t\t\t\t\tstartContainer = rng.startContainer;\n\t\t\t\t\t\tstartOffset = rng.startOffset;\n\t\t\t\t\t\tendContainer = rng.endContainer;\n\t\t\t\t\t\tendOffset = rng.endOffset;\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Force control range into text range\n\t\t\t\t\t\tif (rng.item) {\n\t\t\t\t\t\t\trng = ed.getDoc().body.createTextRange();\n\t\t\t\t\t\t\trng.moveToElementText(rng.item(0));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\ttmpRng = rng.duplicate();\n\t\t\t\t\t\ttmpRng.collapse(true);\n\t\t\t\t\t\tstartOffset = tmpRng.move('character', offset) * -1;\n\n\t\t\t\t\t\tif (!tmpRng.collapsed) {\n\t\t\t\t\t\t\ttmpRng = rng.duplicate();\n\t\t\t\t\t\t\ttmpRng.collapse(false);\n\t\t\t\t\t\t\tendOffset = (tmpRng.move('character', offset) * -1) - startOffset;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Wrap non block elements and text nodes\n\t\t\t\t\tfor (node = rootNode.firstChild; node; node) {\n\t\t\t\t\t\tif (node.nodeType === 3 || (node.nodeType == 1 && !blockElements[node.nodeName])) {\n\t\t\t\t\t\t\tif (!rootBlockNode) {\n\t\t\t\t\t\t\t\trootBlockNode = dom.create(s.forced_root_block);\n\t\t\t\t\t\t\t\tnode.parentNode.insertBefore(rootBlockNode, node);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\ttempNode = node;\n\t\t\t\t\t\t\tnode = node.nextSibling;\n\t\t\t\t\t\t\trootBlockNode.appendChild(tempNode);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\trootBlockNode = null;\n\t\t\t\t\t\t\tnode = node.nextSibling;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tif (rng.setStart) {\n\t\t\t\t\t\trng.setStart(startContainer, startOffset);\n\t\t\t\t\t\trng.setEnd(endContainer, endOffset);\n\t\t\t\t\t\tselection.setRng(rng);\n\t\t\t\t\t} else {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\trng = ed.getDoc().body.createTextRange();\n\t\t\t\t\t\t\trng.moveToElementText(rootNode);\n\t\t\t\t\t\t\trng.collapse(true);\n\t\t\t\t\t\t\trng.moveStart('character', startOffset);\n\n\t\t\t\t\t\t\tif (endOffset > 0)\n\t\t\t\t\t\t\t\trng.moveEnd('character', endOffset);\n\n\t\t\t\t\t\t\trng.select();\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\t// Ignore\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\ted.nodeChanged();\n\t\t\t\t};\n\n\t\t\t\ted.onKeyUp.add(addRootBlocks);\n\t\t\t\ted.onClick.add(addRootBlocks);\n\t\t\t}\n\n\t\t\tif (s.force_br_newlines) {\n\t\t\t\t// Force IE to produce BRs on enter\n\t\t\t\tif (isIE) {\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tvar n;\n\n\t\t\t\t\t\tif (e.keyCode == 13 && selection.getNode().nodeName != 'LI') {\n\t\t\t\t\t\t\tselection.setContent('<br id=\"__\" /> ', {format : 'raw'});\n\t\t\t\t\t\t\tn = dom.get('__');\n\t\t\t\t\t\t\tn.removeAttribute('id');\n\t\t\t\t\t\t\tselection.select(n);\n\t\t\t\t\t\t\tselection.collapse();\n\t\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (s.force_p_newlines) {\n\t\t\t\tif (!isIE) {\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tif (e.keyCode == 13 && !e.shiftKey && !t.insertPara(e))\n\t\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\t// Ungly hack to for IE to preserve the formatting when you press\n\t\t\t\t\t// enter at the end of a block element with formatted contents\n\t\t\t\t\t// This logic overrides the browsers default logic with\n\t\t\t\t\t// custom logic that enables us to control the output\n\t\t\t\t\ttinymce.addUnload(function() {\n\t\t\t\t\t\tt._previousFormats = 0; // Fix IE leak\n\t\t\t\t\t});\n\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tt._previousFormats = 0;\n\n\t\t\t\t\t\t// Clone the current formats, this will later be applied to the new block contents\n\t\t\t\t\t\tif (e.keyCode == 13 && !e.shiftKey && ed.selection.isCollapsed() && s.keep_styles)\n\t\t\t\t\t\t\tt._previousFormats = cloneFormats(ed.selection.getStart());\n\t\t\t\t\t});\n\n\t\t\t\t\ted.onKeyUp.add(function(ed, e) {\n\t\t\t\t\t\t// Let IE break the element and the wrap the new caret location in the previous formats\n\t\t\t\t\t\tif (e.keyCode == 13 && !e.shiftKey) {\n\t\t\t\t\t\t\tvar parent = ed.selection.getStart(), fmt = t._previousFormats;\n\n\t\t\t\t\t\t\t// Parent is an empty block\n\t\t\t\t\t\t\tif (!parent.hasChildNodes() && fmt) {\n\t\t\t\t\t\t\t\tparent = dom.getParent(parent, dom.isBlock);\n\n\t\t\t\t\t\t\t\tif (parent && parent.nodeName != 'LI') {\n\t\t\t\t\t\t\t\t\tparent.innerHTML = '';\n\n\t\t\t\t\t\t\t\t\tif (t._previousFormats) {\n\t\t\t\t\t\t\t\t\t\tparent.appendChild(fmt.wrapper);\n\t\t\t\t\t\t\t\t\t\tfmt.inner.innerHTML = '\\uFEFF';\n\t\t\t\t\t\t\t\t\t} else\n\t\t\t\t\t\t\t\t\t\tparent.innerHTML = '\\uFEFF';\n\n\t\t\t\t\t\t\t\t\tselection.select(parent, 1);\n\t\t\t\t\t\t\t\t\tselection.collapse(true);\n\t\t\t\t\t\t\t\t\ted.getDoc().execCommand('Delete', false, null);\n\t\t\t\t\t\t\t\t\tt._previousFormats = 0;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif (isGecko) {\n\t\t\t\t\ted.onKeyDown.add(function(ed, e) {\n\t\t\t\t\t\tif ((e.keyCode == 8 || e.keyCode == 46) && !e.shiftKey)\n\t\t\t\t\t\t\tt.backspaceDelete(e, e.keyCode == 8);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Workaround for missing shift+enter support, http://bugs.webkit.org/show_bug.cgi?id=16973\n\t\t\tif (tinymce.isWebKit) {\n\t\t\t\tfunction insertBr(ed) {\n\t\t\t\t\tvar rng = selection.getRng(), br, div = dom.create('div', null, ' '), divYPos, vpHeight = dom.getViewPort(ed.getWin()).h;\n\n\t\t\t\t\t// Insert BR element\n\t\t\t\t\trng.insertNode(br = dom.create('br'));\n\n\t\t\t\t\t// Place caret after BR\n\t\t\t\t\trng.setStartAfter(br);\n\t\t\t\t\trng.setEndAfter(br);\n\t\t\t\t\tselection.setRng(rng);\n\n\t\t\t\t\t// Could not place caret after BR then insert an nbsp entity and move the caret\n\t\t\t\t\tif (selection.getSel().focusNode == br.previousSibling) {\n\t\t\t\t\t\tselection.select(dom.insertAfter(dom.doc.createTextNode('\\u00a0'), br));\n\t\t\t\t\t\tselection.collapse(TRUE);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Create a temporary DIV after the BR and get the position as it\n\t\t\t\t\t// seems like getPos() returns 0 for text nodes and BR elements.\n\t\t\t\t\tdom.insertAfter(div, br);\n\t\t\t\t\tdivYPos = dom.getPos(div).y;\n\t\t\t\t\tdom.remove(div);\n\n\t\t\t\t\t// Scroll to new position, scrollIntoView can't be used due to bug: http://bugs.webkit.org/show_bug.cgi?id=16117\n\t\t\t\t\tif (divYPos > vpHeight) // It is not necessary to scroll if the DIV is inside the view port.\n\t\t\t\t\t\ted.getWin().scrollTo(0, divYPos);\n\t\t\t\t};\n\n\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\tif (e.keyCode == 13 && (e.shiftKey || (s.force_br_newlines && !dom.getParent(selection.getNode(), 'h1,h2,h3,h4,h5,h6,ol,ul')))) {\n\t\t\t\t\t\tinsertBr(ed);\n\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// IE specific fixes\n\t\t\tif (isIE) {\n\t\t\t\t// Replaces IE:s auto generated paragraphs with the specified element name\n\t\t\t\tif (s.element != 'P') {\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tt.lastElm = selection.getNode().nodeName;\n\t\t\t\t\t});\n\n\t\t\t\t\ted.onKeyUp.add(function(ed, e) {\n\t\t\t\t\t\tvar bl, n = selection.getNode(), b = ed.getBody();\n\n\t\t\t\t\t\tif (b.childNodes.length === 1 && n.nodeName == 'P') {\n\t\t\t\t\t\t\tn = dom.rename(n, s.element);\n\t\t\t\t\t\t\tselection.select(n);\n\t\t\t\t\t\t\tselection.collapse();\n\t\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t\t} else if (e.keyCode == 13 && !e.shiftKey && t.lastElm != 'P') {\n\t\t\t\t\t\t\tbl = dom.getParent(n, 'p');\n\n\t\t\t\t\t\t\tif (bl) {\n\t\t\t\t\t\t\t\tdom.rename(bl, s.element);\n\t\t\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tgetParentBlock : function(n) {\n\t\t\tvar d = this.dom;\n\n\t\t\treturn d.getParent(n, d.isBlock);\n\t\t},\n\n\t\tinsertPara : function(e) {\n\t\t\tvar t = this, ed = t.editor, dom = ed.dom, d = ed.getDoc(), se = ed.settings, s = ed.selection.getSel(), r = s.getRangeAt(0), b = d.body;\n\t\t\tvar rb, ra, dir, sn, so, en, eo, sb, eb, bn, bef, aft, sc, ec, n, vp = dom.getViewPort(ed.getWin()), y, ch, car;\n\n\t\t\ted.undoManager.beforeChange();\n\n\t\t\t// If root blocks are forced then use Operas default behavior since it's really good\n// Removed due to bug: #1853816\n//\t\t\tif (se.forced_root_block && isOpera)\n//\t\t\t\treturn TRUE;\n\n\t\t\t// Setup before range\n\t\t\trb = d.createRange();\n\n\t\t\t// If is before the first block element and in body, then move it into first block element\n\t\t\trb.setStart(s.anchorNode, s.anchorOffset);\n\t\t\trb.collapse(TRUE);\n\n\t\t\t// Setup after range\n\t\t\tra = d.createRange();\n\n\t\t\t// If is before the first block element and in body, then move it into first block element\n\t\t\tra.setStart(s.focusNode, s.focusOffset);\n\t\t\tra.collapse(TRUE);\n\n\t\t\t// Setup start/end points\n\t\t\tdir = rb.compareBoundaryPoints(rb.START_TO_END, ra) < 0;\n\t\t\tsn = dir ? s.anchorNode : s.focusNode;\n\t\t\tso = dir ? s.anchorOffset : s.focusOffset;\n\t\t\ten = dir ? s.focusNode : s.anchorNode;\n\t\t\teo = dir ? s.focusOffset : s.anchorOffset;\n\n\t\t\t// If selection is in empty table cell\n\t\t\tif (sn === en && /^(TD|TH)$/.test(sn.nodeName)) {\n\t\t\t\tif (sn.firstChild.nodeName == 'BR')\n\t\t\t\t\tdom.remove(sn.firstChild); // Remove BR\n\n\t\t\t\t// Create two new block elements\n\t\t\t\tif (sn.childNodes.length == 0) {\n\t\t\t\t\ted.dom.add(sn, se.element, null, '<br />');\n\t\t\t\t\taft = ed.dom.add(sn, se.element, null, '<br />');\n\t\t\t\t} else {\n\t\t\t\t\tn = sn.innerHTML;\n\t\t\t\t\tsn.innerHTML = '';\n\t\t\t\t\ted.dom.add(sn, se.element, null, n);\n\t\t\t\t\taft = ed.dom.add(sn, se.element, null, '<br />');\n\t\t\t\t}\n\n\t\t\t\t// Move caret into the last one\n\t\t\t\tr = d.createRange();\n\t\t\t\tr.selectNodeContents(aft);\n\t\t\t\tr.collapse(1);\n\t\t\t\ted.selection.setRng(r);\n\n\t\t\t\treturn FALSE;\n\t\t\t}\n\n\t\t\t// If the caret is in an invalid location in FF we need to move it into the first block\n\t\t\tif (sn == b && en == b && b.firstChild && ed.dom.isBlock(b.firstChild)) {\n\t\t\t\tsn = en = sn.firstChild;\n\t\t\t\tso = eo = 0;\n\t\t\t\trb = d.createRange();\n\t\t\t\trb.setStart(sn, 0);\n\t\t\t\tra = d.createRange();\n\t\t\t\tra.setStart(en, 0);\n\t\t\t}\n\n\t\t\t// If the body is totally empty add a BR element this might happen on webkit\n\t\t\tif (!d.body.hasChildNodes()) {\n\t\t\t\td.body.appendChild(dom.create('br'));\n\t\t\t}\n\n\t\t\t// Never use body as start or end node\n\t\t\tsn = sn.nodeName == \"HTML\" ? d.body : sn; // Fix for Opera bug: https://bugs.opera.com/show_bug.cgi?id=273224&comments=yes\n\t\t\tsn = sn.nodeName == \"BODY\" ? sn.firstChild : sn;\n\t\t\ten = en.nodeName == \"HTML\" ? d.body : en; // Fix for Opera bug: https://bugs.opera.com/show_bug.cgi?id=273224&comments=yes\n\t\t\ten = en.nodeName == \"BODY\" ? en.firstChild : en;\n\n\t\t\t// Get start and end blocks\n\t\t\tsb = t.getParentBlock(sn);\n\t\t\teb = t.getParentBlock(en);\n\t\t\tbn = sb ? sb.nodeName : se.element; // Get block name to create\n\n\t\t\t// Return inside list use default browser behavior\n\t\t\tif (n = t.dom.getParent(sb, 'li,pre')) {\n\t\t\t\tif (n.nodeName == 'LI')\n\t\t\t\t\treturn splitList(ed.selection, t.dom, n);\n\n\t\t\t\treturn TRUE;\n\t\t\t}\n\n\t\t\t// If caption or absolute layers then always generate new blocks within\n\t\t\tif (sb && (sb.nodeName == 'CAPTION' || /absolute|relative|fixed/gi.test(dom.getStyle(sb, 'position', 1)))) {\n\t\t\t\tbn = se.element;\n\t\t\t\tsb = null;\n\t\t\t}\n\n\t\t\t// If caption or absolute layers then always generate new blocks within\n\t\t\tif (eb && (eb.nodeName == 'CAPTION' || /absolute|relative|fixed/gi.test(dom.getStyle(sb, 'position', 1)))) {\n\t\t\t\tbn = se.element;\n\t\t\t\teb = null;\n\t\t\t}\n\n\t\t\t// Use P instead\n\t\t\tif (/(TD|TABLE|TH|CAPTION)/.test(bn) || (sb && bn == \"DIV\" && /left|right/gi.test(dom.getStyle(sb, 'float', 1)))) {\n\t\t\t\tbn = se.element;\n\t\t\t\tsb = eb = null;\n\t\t\t}\n\n\t\t\t// Setup new before and after blocks\n\t\t\tbef = (sb && sb.nodeName == bn) ? sb.cloneNode(0) : ed.dom.create(bn);\n\t\t\taft = (eb && eb.nodeName == bn) ? eb.cloneNode(0) : ed.dom.create(bn);\n\n\t\t\t// Remove id from after clone\n\t\t\taft.removeAttribute('id');\n\n\t\t\t// Is header and cursor is at the end, then force paragraph under\n\t\t\tif (/^(H[1-6])$/.test(bn) && isAtEnd(r, sb))\n\t\t\t\taft = ed.dom.create(se.element);\n\n\t\t\t// Find start chop node\n\t\t\tn = sc = sn;\n\t\t\tdo {\n\t\t\t\tif (n == b || n.nodeType == 9 || t.dom.isBlock(n) || /(TD|TABLE|TH|CAPTION)/.test(n.nodeName))\n\t\t\t\t\tbreak;\n\n\t\t\t\tsc = n;\n\t\t\t} while ((n = n.previousSibling ? n.previousSibling : n.parentNode));\n\n\t\t\t// Find end chop node\n\t\t\tn = ec = en;\n\t\t\tdo {\n\t\t\t\tif (n == b || n.nodeType == 9 || t.dom.isBlock(n) || /(TD|TABLE|TH|CAPTION)/.test(n.nodeName))\n\t\t\t\t\tbreak;\n\n\t\t\t\tec = n;\n\t\t\t} while ((n = n.nextSibling ? n.nextSibling : n.parentNode));\n\n\t\t\t// Place first chop part into before block element\n\t\t\tif (sc.nodeName == bn)\n\t\t\t\trb.setStart(sc, 0);\n\t\t\telse\n\t\t\t\trb.setStartBefore(sc);\n\n\t\t\trb.setEnd(sn, so);\n\t\t\tbef.appendChild(rb.cloneContents() || d.createTextNode('')); // Empty text node needed for Safari\n\n\t\t\t// Place secnd chop part within new block element\n\t\t\ttry {\n\t\t\t\tra.setEndAfter(ec);\n\t\t\t} catch(ex) {\n\t\t\t\t//console.debug(s.focusNode, s.focusOffset);\n\t\t\t}\n\n\t\t\tra.setStart(en, eo);\n\t\t\taft.appendChild(ra.cloneContents() || d.createTextNode('')); // Empty text node needed for Safari\n\n\t\t\t// Create range around everything\n\t\t\tr = d.createRange();\n\t\t\tif (!sc.previousSibling && sc.parentNode.nodeName == bn) {\n\t\t\t\tr.setStartBefore(sc.parentNode);\n\t\t\t} else {\n\t\t\t\tif (rb.startContainer.nodeName == bn && rb.startOffset == 0)\n\t\t\t\t\tr.setStartBefore(rb.startContainer);\n\t\t\t\telse\n\t\t\t\t\tr.setStart(rb.startContainer, rb.startOffset);\n\t\t\t}\n\n\t\t\tif (!ec.nextSibling && ec.parentNode.nodeName == bn)\n\t\t\t\tr.setEndAfter(ec.parentNode);\n\t\t\telse\n\t\t\t\tr.setEnd(ra.endContainer, ra.endOffset);\n\n\t\t\t// Delete and replace it with new block elements\n\t\t\tr.deleteContents();\n\n\t\t\tif (isOpera)\n\t\t\t\ted.getWin().scrollTo(0, vp.y);\n\n\t\t\t// Never wrap blocks in blocks\n\t\t\tif (bef.firstChild && bef.firstChild.nodeName == bn)\n\t\t\t\tbef.innerHTML = bef.firstChild.innerHTML;\n\n\t\t\tif (aft.firstChild && aft.firstChild.nodeName == bn)\n\t\t\t\taft.innerHTML = aft.firstChild.innerHTML;\n\n\t\t\tfunction appendStyles(e, en) {\n\t\t\t\tvar nl = [], nn, n, i;\n\n\t\t\t\te.innerHTML = '';\n\n\t\t\t\t// Make clones of style elements\n\t\t\t\tif (se.keep_styles) {\n\t\t\t\t\tn = en;\n\t\t\t\t\tdo {\n\t\t\t\t\t\t// We only want style specific elements\n\t\t\t\t\t\tif (/^(SPAN|STRONG|B|EM|I|FONT|STRIKE|U)$/.test(n.nodeName)) {\n\t\t\t\t\t\t\tnn = n.cloneNode(FALSE);\n\t\t\t\t\t\t\tdom.setAttrib(nn, 'id', ''); // Remove ID since it needs to be unique\n\t\t\t\t\t\t\tnl.push(nn);\n\t\t\t\t\t\t}\n\t\t\t\t\t} while (n = n.parentNode);\n\t\t\t\t}\n\n\t\t\t\t// Append style elements to aft\n\t\t\t\tif (nl.length > 0) {\n\t\t\t\t\tfor (i = nl.length - 1, nn = e; i >= 0; i--)\n\t\t\t\t\t\tnn = nn.appendChild(nl[i]);\n\n\t\t\t\t\t// Padd most inner style element\n\t\t\t\t\tnl[0].innerHTML = isOpera ? '\\u00a0' : '<br />'; // Extra space for Opera so that the caret can move there\n\t\t\t\t\treturn nl[0]; // Move caret to most inner element\n\t\t\t\t} else\n\t\t\t\t\te.innerHTML = isOpera ? '\\u00a0' : '<br />'; // Extra space for Opera so that the caret can move there\n\t\t\t};\n\n\t\t\t// Padd empty blocks\n\t\t\tif (dom.isEmpty(bef))\n\t\t\t\tappendStyles(bef, sn);\n\n\t\t\t// Fill empty afterblook with current style\n\t\t\tif (dom.isEmpty(aft))\n\t\t\t\tcar = appendStyles(aft, en);\n\n\t\t\t// Opera needs this one backwards for older versions\n\t\t\tif (isOpera && parseFloat(opera.version()) < 9.5) {\n\t\t\t\tr.insertNode(bef);\n\t\t\t\tr.insertNode(aft);\n\t\t\t} else {\n\t\t\t\tr.insertNode(aft);\n\t\t\t\tr.insertNode(bef);\n\t\t\t}\n\n\t\t\t// Normalize\n\t\t\taft.normalize();\n\t\t\tbef.normalize();\n\n\t\t\t// Move cursor and scroll into view\n\t\t\ted.selection.select(aft, true);\n\t\t\ted.selection.collapse(true);\n\n\t\t\t// scrollIntoView seems to scroll the parent window in most browsers now including FF 3.0b4 so it's time to stop using it and do it our selfs\n\t\t\ty = ed.dom.getPos(aft).y;\n\t\t\t//ch = aft.clientHeight;\n\n\t\t\t// Is element within viewport\n\t\t\tif (y < vp.y || y + 25 > vp.y + vp.h) {\n\t\t\t\ted.getWin().scrollTo(0, y < vp.y ? y : y - vp.h + 25); // Needs to be hardcoded to roughly one line of text if a huge text block is broken into two blocks\n\n\t\t\t\t/*console.debug(\n\t\t\t\t\t'Element: y=' + y + ', h=' + ch + ', ' +\n\t\t\t\t\t'Viewport: y=' + vp.y + \", h=\" + vp.h + ', bottom=' + (vp.y + vp.h)\n\t\t\t\t);*/\n\t\t\t}\n\n\t\t\ted.undoManager.add();\n\n\t\t\treturn FALSE;\n\t\t},\n\n\t\tbackspaceDelete : function(e, bs) {\n\t\t\tvar t = this, ed = t.editor, b = ed.getBody(), dom = ed.dom, n, se = ed.selection, r = se.getRng(), sc = r.startContainer, n, w, tn, walker;\n\n\t\t\t// Delete when caret is behind a element doesn't work correctly on Gecko see #3011651\n\t\t\tif (!bs && r.collapsed && sc.nodeType == 1 && r.startOffset == sc.childNodes.length) {\n\t\t\t\twalker = new tinymce.dom.TreeWalker(sc.lastChild, sc);\n\n\t\t\t\t// Walk the dom backwards until we find a text node\n\t\t\t\tfor (n = sc.lastChild; n; n = walker.prev()) {\n\t\t\t\t\tif (n.nodeType == 3) {\n\t\t\t\t\t\tr.setStart(n, n.nodeValue.length);\n\t\t\t\t\t\tr.collapse(true);\n\t\t\t\t\t\tse.setRng(r);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// The caret sometimes gets stuck in Gecko if you delete empty paragraphs\n\t\t\t// This workaround removes the element by hand and moves the caret to the previous element\n\t\t\tif (sc && ed.dom.isBlock(sc) && !/^(TD|TH)$/.test(sc.nodeName) && bs) {\n\t\t\t\tif (sc.childNodes.length == 0 || (sc.childNodes.length == 1 && sc.firstChild.nodeName == 'BR')) {\n\t\t\t\t\t// Find previous block element\n\t\t\t\t\tn = sc;\n\t\t\t\t\twhile ((n = n.previousSibling) && !ed.dom.isBlock(n)) ;\n\n\t\t\t\t\tif (n) {\n\t\t\t\t\t\tif (sc != b.firstChild) {\n\t\t\t\t\t\t\t// Find last text node\n\t\t\t\t\t\t\tw = ed.dom.doc.createTreeWalker(n, NodeFilter.SHOW_TEXT, null, FALSE);\n\t\t\t\t\t\t\twhile (tn = w.nextNode())\n\t\t\t\t\t\t\t\tn = tn;\n\n\t\t\t\t\t\t\t// Place caret at the end of last text node\n\t\t\t\t\t\t\tr = ed.getDoc().createRange();\n\t\t\t\t\t\t\tr.setStart(n, n.nodeValue ? n.nodeValue.length : 0);\n\t\t\t\t\t\t\tr.setEnd(n, n.nodeValue ? n.nodeValue.length : 0);\n\t\t\t\t\t\t\tse.setRng(r);\n\n\t\t\t\t\t\t\t// Remove the target container\n\t\t\t\t\t\t\ted.dom.remove(sc);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\t// Shorten names\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each, extend = tinymce.extend;\n\n\ttinymce.create('tinymce.ControlManager', {\n\t\tControlManager : function(ed, s) {\n\t\t\tvar t = this, i;\n\n\t\t\ts = s || {};\n\t\t\tt.editor = ed;\n\t\t\tt.controls = {};\n\t\t\tt.onAdd = new tinymce.util.Dispatcher(t);\n\t\t\tt.onPostRender = new tinymce.util.Dispatcher(t);\n\t\t\tt.prefix = s.prefix || ed.id + '_';\n\t\t\tt._cls = {};\n\n\t\t\tt.onPostRender.add(function() {\n\t\t\t\teach(t.controls, function(c) {\n\t\t\t\t\tc.postRender();\n\t\t\t\t});\n\t\t\t});\n\t\t},\n\n\t\tget : function(id) {\n\t\t\treturn this.controls[this.prefix + id] || this.controls[id];\n\t\t},\n\n\t\tsetActive : function(id, s) {\n\t\t\tvar c = null;\n\n\t\t\tif (c = this.get(id))\n\t\t\t\tc.setActive(s);\n\n\t\t\treturn c;\n\t\t},\n\n\t\tsetDisabled : function(id, s) {\n\t\t\tvar c = null;\n\n\t\t\tif (c = this.get(id))\n\t\t\t\tc.setDisabled(s);\n\n\t\t\treturn c;\n\t\t},\n\n\t\tadd : function(c) {\n\t\t\tvar t = this;\n\n\t\t\tif (c) {\n\t\t\t\tt.controls[c.id] = c;\n\t\t\t\tt.onAdd.dispatch(c, t);\n\t\t\t}\n\n\t\t\treturn c;\n\t\t},\n\n\t\tcreateControl : function(n) {\n\t\t\tvar c, t = this, ed = t.editor;\n\n\t\t\teach(ed.plugins, function(p) {\n\t\t\t\tif (p.createControl) {\n\t\t\t\t\tc = p.createControl(n, t);\n\n\t\t\t\t\tif (c)\n\t\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tswitch (n) {\n\t\t\t\tcase \"|\":\n\t\t\t\tcase \"separator\":\n\t\t\t\t\treturn t.createSeparator();\n\t\t\t}\n\n\t\t\tif (!c && ed.buttons && (c = ed.buttons[n]))\n\t\t\t\treturn t.createButton(n, c);\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateDropMenu : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, c, bm, v, cls;\n\n\t\t\ts = extend({\n\t\t\t\t'class' : 'mceDropDown',\n\t\t\t\tconstrain : ed.settings.constrain_menus\n\t\t\t}, s);\n\n\t\t\ts['class'] = s['class'] + ' ' + ed.getParam('skin') + 'Skin';\n\t\t\tif (v = ed.getParam('skin_variant'))\n\t\t\t\ts['class'] += ' ' + ed.getParam('skin') + 'Skin' + v.substring(0, 1).toUpperCase() + v.substring(1);\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.dropmenu || tinymce.ui.DropMenu;\n\t\t\tc = t.controls[id] = new cls(id, s);\n\t\t\tc.onAddItem.add(function(c, o) {\n\t\t\t\tvar s = o.settings;\n\n\t\t\t\ts.title = ed.getLang(s.title, s.title);\n\n\t\t\t\tif (!s.onclick) {\n\t\t\t\t\ts.onclick = function(v) {\n\t\t\t\t\t\tif (s.cmd)\n\t\t\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, s.value);\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t});\n\n\t\t\ted.onRemove.add(function() {\n\t\t\t\tc.destroy();\n\t\t\t});\n\n\t\t\t// Fix for bug #1897785, #1898007\n\t\t\tif (tinymce.isIE) {\n\t\t\t\tc.onShowMenu.add(function() {\n\t\t\t\t\t// IE 8 needs focus in order to store away a range with the current collapsed caret location\n\t\t\t\t\ted.focus();\n\n\t\t\t\t\tbm = ed.selection.getBookmark(1);\n\t\t\t\t});\n\n\t\t\t\tc.onHideMenu.add(function() {\n\t\t\t\t\tif (bm) {\n\t\t\t\t\t\ted.selection.moveToBookmark(bm);\n\t\t\t\t\t\tbm = 0;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateListBox : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, cmd, c, cls;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onselect) {\n\t\t\t\ts.onselect = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\tscope : s.scope,\n\t\t\t\tcontrol_manager : t\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\n\n\t\t\tfunction useNativeListForAccessibility(ed) {\n\t\t\t\treturn ed.settings.use_accessible_selects && !tinymce.isGecko\n\t\t\t}\n\n\t\t\tif (ed.settings.use_native_selects || useNativeListForAccessibility(ed))\n\t\t\t\tc = new tinymce.ui.NativeListBox(id, s);\n\t\t\telse {\n\t\t\t\tcls = cc || t._cls.listbox || tinymce.ui.ListBox;\n\t\t\t\tc = new cls(id, s, ed);\n\t\t\t}\n\n\t\t\tt.controls[id] = c;\n\n\t\t\t// Fix focus problem in Safari\n\t\t\tif (tinymce.isWebKit) {\n\t\t\t\tc.onPostRender.add(function(c, n) {\n\t\t\t\t\t// Store bookmark on mousedown\n\t\t\t\t\tEvent.add(n, 'mousedown', function() {\n\t\t\t\t\t\ted.bookmark = ed.selection.getBookmark(1);\n\t\t\t\t\t});\n\n\t\t\t\t\t// Restore on focus, since it might be lost\n\t\t\t\t\tEvent.add(n, 'focus', function() {\n\t\t\t\t\t\ted.selection.moveToBookmark(ed.bookmark);\n\t\t\t\t\t\ted.bookmark = null;\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (c.hideMenu)\n\t\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateButton : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, o, c, cls;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.label = ed.translate(s.label);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onclick && !s.menu_button) {\n\t\t\t\ts.onclick = function() {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\tunavailable_prefix : ed.getLang('unavailable', ''),\n\t\t\t\tscope : s.scope,\n\t\t\t\tcontrol_manager : t\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\n\t\t\tif (s.menu_button) {\n\t\t\t\tcls = cc || t._cls.menubutton || tinymce.ui.MenuButton;\n\t\t\t\tc = new cls(id, s, ed);\n\t\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\t\t\t} else {\n\t\t\t\tcls = t._cls.button || tinymce.ui.Button;\n\t\t\t\tc = new cls(id, s, ed);\n\t\t\t}\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateMenuButton : function(id, s, cc) {\n\t\t\ts = s || {};\n\t\t\ts.menu_button = 1;\n\n\t\t\treturn this.createButton(id, s, cc);\n\t\t},\n\n\t\tcreateSplitButton : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, cmd, c, cls;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onclick) {\n\t\t\t\ts.onclick = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (!s.onselect) {\n\t\t\t\ts.onselect = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\tscope : s.scope,\n\t\t\t\tcontrol_manager : t\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.splitbutton || tinymce.ui.SplitButton;\n\t\t\tc = t.add(new cls(id, s, ed));\n\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\n\t\t\treturn c;\n\t\t},\n\n\t\tcreateColorSplitButton : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, cmd, c, cls, bm;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onclick) {\n\t\t\t\ts.onclick = function(v) {\n\t\t\t\t\tif (tinymce.isIE)\n\t\t\t\t\t\tbm = ed.selection.getBookmark(1);\n\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (!s.onselect) {\n\t\t\t\ts.onselect = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\t'menu_class' : ed.getParam('skin') + 'Skin',\n\t\t\t\tscope : s.scope,\n\t\t\t\tmore_colors_title : ed.getLang('more_colors')\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.colorsplitbutton || tinymce.ui.ColorSplitButton;\n\t\t\tc = new cls(id, s, ed);\n\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\n\t\t\t// Remove the menu element when the editor is removed\n\t\t\ted.onRemove.add(function() {\n\t\t\t\tc.destroy();\n\t\t\t});\n\n\t\t\t// Fix for bug #1897785, #1898007\n\t\t\tif (tinymce.isIE) {\n\t\t\t\tc.onShowMenu.add(function() {\n\t\t\t\t\t// IE 8 needs focus in order to store away a range with the current collapsed caret location\n\t\t\t\t\ted.focus();\n\t\t\t\t\tbm = ed.selection.getBookmark(1);\n\t\t\t\t});\n\n\t\t\t\tc.onHideMenu.add(function() {\n\t\t\t\t\tif (bm) {\n\t\t\t\t\t\ted.selection.moveToBookmark(bm);\n\t\t\t\t\t\tbm = 0;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateToolbar : function(id, s, cc) {\n\t\t\tvar c, t = this, cls;\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.toolbar || tinymce.ui.Toolbar;\n\t\t\tc = new cls(id, s, t.editor);\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateToolbarGroup : function(id, s, cc) {\n\t\t\tvar c, t = this, cls;\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || this._cls.toolbarGroup || tinymce.ui.ToolbarGroup;\n\t\t\tc = new cls(id, s, t.editor);\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateSeparator : function(cc) {\n\t\t\tvar cls = cc || this._cls.separator || tinymce.ui.Separator;\n\n\t\t\treturn new cls();\n\t\t},\n\n\t\tsetControlType : function(n, c) {\n\t\t\treturn this._cls[n.toLowerCase()] = c;\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\teach(this.controls, function(c) {\n\t\t\t\tc.destroy();\n\t\t\t});\n\n\t\t\tthis.controls = null;\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar Dispatcher = tinymce.util.Dispatcher, each = tinymce.each, isIE = tinymce.isIE, isOpera = tinymce.isOpera;\n\n\ttinymce.create('tinymce.WindowManager', {\n\t\tWindowManager : function(ed) {\n\t\t\tvar t = this;\n\n\t\t\tt.editor = ed;\n\t\t\tt.onOpen = new Dispatcher(t);\n\t\t\tt.onClose = new Dispatcher(t);\n\t\t\tt.params = {};\n\t\t\tt.features = {};\n\t\t},\n\n\t\topen : function(s, p) {\n\t\t\tvar t = this, f = '', x, y, mo = t.editor.settings.dialog_type == 'modal', w, sw, sh, vp = tinymce.DOM.getViewPort(), u;\n\n\t\t\t// Default some options\n\t\t\ts = s || {};\n\t\t\tp = p || {};\n\t\t\tsw = isOpera ? vp.w : screen.width; // Opera uses windows inside the Opera window\n\t\t\tsh = isOpera ? vp.h : screen.height;\n\t\t\ts.name = s.name || 'mc_' + new Date().getTime();\n\t\t\ts.width = parseInt(s.width || 320);\n\t\t\ts.height = parseInt(s.height || 240);\n\t\t\ts.resizable = true;\n\t\t\ts.left = s.left || parseInt(sw / 2.0) - (s.width / 2.0);\n\t\t\ts.top = s.top || parseInt(sh / 2.0) - (s.height / 2.0);\n\t\t\tp.inline = false;\n\t\t\tp.mce_width = s.width;\n\t\t\tp.mce_height = s.height;\n\t\t\tp.mce_auto_focus = s.auto_focus;\n\n\t\t\tif (mo) {\n\t\t\t\tif (isIE) {\n\t\t\t\t\ts.center = true;\n\t\t\t\t\ts.help = false;\n\t\t\t\t\ts.dialogWidth = s.width + 'px';\n\t\t\t\t\ts.dialogHeight = s.height + 'px';\n\t\t\t\t\ts.scroll = s.scrollbars || false;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Build features string\n\t\t\teach(s, function(v, k) {\n\t\t\t\tif (tinymce.is(v, 'boolean'))\n\t\t\t\t\tv = v ? 'yes' : 'no';\n\n\t\t\t\tif (!/^(name|url)$/.test(k)) {\n\t\t\t\t\tif (isIE && mo)\n\t\t\t\t\t\tf += (f ? ';' : '') + k + ':' + v;\n\t\t\t\t\telse\n\t\t\t\t\t\tf += (f ? ',' : '') + k + '=' + v;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.features = s;\n\t\t\tt.params = p;\n\t\t\tt.onOpen.dispatch(t, s, p);\n\n\t\t\tu = s.url || s.file;\n\t\t\tu = tinymce._addVer(u);\n\n\t\t\ttry {\n\t\t\t\tif (isIE && mo) {\n\t\t\t\t\tw = 1;\n\t\t\t\t\twindow.showModalDialog(u, window, f);\n\t\t\t\t} else\n\t\t\t\t\tw = window.open(u, s.name, f);\n\t\t\t} catch (ex) {\n\t\t\t\t// Ignore\n\t\t\t}\n\n\t\t\tif (!w)\n\t\t\t\talert(t.editor.getLang('popup_blocked'));\n\t\t},\n\n\t\tclose : function(w) {\n\t\t\tw.close();\n\t\t\tthis.onClose.dispatch(this);\n\t\t},\n\n\t\tcreateInstance : function(cl, a, b, c, d, e) {\n\t\t\tvar f = tinymce.resolve(cl);\n\n\t\t\treturn new f(a, b, c, d, e);\n\t\t},\n\n\t\tconfirm : function(t, cb, s, w) {\n\t\t\tw = w || window;\n\n\t\t\tcb.call(s || this, w.confirm(this._decode(this.editor.getLang(t, t))));\n\t\t},\n\n\t\talert : function(tx, cb, s, w) {\n\t\t\tvar t = this;\n\n\t\t\tw = w || window;\n\t\t\tw.alert(t._decode(t.editor.getLang(tx, tx)));\n\n\t\t\tif (cb)\n\t\t\t\tcb.call(s || t);\n\t\t},\n\n\t\tresizeBy : function(dw, dh, win) {\n\t\t\twin.resizeBy(dw, dh);\n\t\t},\n\n\t\t// Internal functions\n\n\t\t_decode : function(s) {\n\t\t\treturn tinymce.DOM.decode(s).replace(/\\\\n/g, '\\n');\n\t\t}\n\t});\n}(tinymce));\n(function(tinymce) {\n\ttinymce.Formatter = function(ed) {\n\t\tvar formats = {},\n\t\t\teach = tinymce.each,\n\t\t\tdom = ed.dom,\n\t\t\tselection = ed.selection,\n\t\t\tTreeWalker = tinymce.dom.TreeWalker,\n\t\t\trangeUtils = new tinymce.dom.RangeUtils(dom),\n\t\t\tisValid = ed.schema.isValidChild,\n\t\t\tisBlock = dom.isBlock,\n\t\t\tforcedRootBlock = ed.settings.forced_root_block,\n\t\t\tnodeIndex = dom.nodeIndex,\n\t\t\tINVISIBLE_CHAR = '\\uFEFF',\n\t\t\tMCE_ATTR_RE = /^(src|href|style)$/,\n\t\t\tFALSE = false,\n\t\t\tTRUE = true,\n\t\t\tundefined;\n\n\t\tfunction isArray(obj) {\n\t\t\treturn obj instanceof Array;\n\t\t};\n\n\t\tfunction getParents(node, selector) {\n\t\t\treturn dom.getParents(node, selector, dom.getRoot());\n\t\t};\n\n\t\tfunction isCaretNode(node) {\n\t\t\treturn node.nodeType === 1 && (node.face === 'mceinline' || node.style.fontFamily === 'mceinline');\n\t\t};\n\n\t\t// Public functions\n\n\t\tfunction get(name) {\n\t\t\treturn name ? formats[name] : formats;\n\t\t};\n\n\t\tfunction register(name, format) {\n\t\t\tif (name) {\n\t\t\t\tif (typeof(name) !== 'string') {\n\t\t\t\t\teach(name, function(format, name) {\n\t\t\t\t\t\tregister(name, format);\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\t// Force format into array and add it to internal collection\n\t\t\t\t\tformat = format.length ? format : [format];\n\n\t\t\t\t\teach(format, function(format) {\n\t\t\t\t\t\t// Set deep to false by default on selector formats this to avoid removing\n\t\t\t\t\t\t// alignment on images inside paragraphs when alignment is changed on paragraphs\n\t\t\t\t\t\tif (format.deep === undefined)\n\t\t\t\t\t\t\tformat.deep = !format.selector;\n\n\t\t\t\t\t\t// Default to true\n\t\t\t\t\t\tif (format.split === undefined)\n\t\t\t\t\t\t\tformat.split = !format.selector || format.inline;\n\n\t\t\t\t\t\t// Default to true\n\t\t\t\t\t\tif (format.remove === undefined && format.selector && !format.inline)\n\t\t\t\t\t\t\tformat.remove = 'none';\n\n\t\t\t\t\t\t// Mark format as a mixed format inline + block level\n\t\t\t\t\t\tif (format.selector && format.inline) {\n\t\t\t\t\t\t\tformat.mixed = true;\n\t\t\t\t\t\t\tformat.block_expand = true;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Split classes if needed\n\t\t\t\t\t\tif (typeof(format.classes) === 'string')\n\t\t\t\t\t\t\tformat.classes = format.classes.split(/\\s+/);\n\t\t\t\t\t});\n\n\t\t\t\t\tformats[name] = format;\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tvar getTextDecoration = function(node) {\n\t\t\tvar decoration;\n\n\t\t\ted.dom.getParent(node, function(n) {\n\t\t\t\tdecoration = ed.dom.getStyle(n, 'text-decoration');\n\t\t\t\treturn decoration && decoration !== 'none';\n\t\t\t});\n\n\t\t\treturn decoration;\n\t\t};\n\n\t\tvar processUnderlineAndColor = function(node) {\n\t\t\tvar textDecoration;\n\t\t\tif (node.nodeType === 1 && node.parentNode && node.parentNode.nodeType === 1) {\n\t\t\t\ttextDecoration = getTextDecoration(node.parentNode);\n\t\t\t\tif (ed.dom.getStyle(node, 'color') && textDecoration) {\n\t\t\t\t\ted.dom.setStyle(node, 'text-decoration', textDecoration);\n\t\t\t\t} else if (ed.dom.getStyle(node, 'textdecoration') === textDecoration) {\n\t\t\t\t\ted.dom.setStyle(node, 'text-decoration', null);\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction apply(name, vars, node) {\n\t\t\tvar formatList = get(name), format = formatList[0], bookmark, rng, i, isCollapsed = selection.isCollapsed();\n\n\t\t\tfunction moveStart(rng) {\n\t\t\t\tvar container = rng.startContainer,\n\t\t\t\t\toffset = rng.startOffset,\n\t\t\t\t\twalker, node;\n\n\t\t\t\t// Move startContainer/startOffset in to a suitable node\n\t\t\t\tif (container.nodeType == 1 || container.nodeValue === \"\") {\n\t\t\t\t\tcontainer = container.nodeType == 1 ? container.childNodes[offset] : container;\n\n\t\t\t\t\t// Might fail if the offset is behind the last element in it's container\n\t\t\t\t\tif (container) {\n\t\t\t\t\t\twalker = new TreeWalker(container, container.parentNode);\n\t\t\t\t\t\tfor (node = walker.current(); node; node = walker.next()) {\n\t\t\t\t\t\t\tif (node.nodeType == 3 && !isWhiteSpaceNode(node)) {\n\t\t\t\t\t\t\t\trng.setStart(node, 0);\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn rng;\n\t\t\t};\n\n\t\t\tfunction setElementFormat(elm, fmt) {\n\t\t\t\tfmt = fmt || format;\n\n\t\t\t\tif (elm) {\n\t\t\t\t\tif (fmt.onformat) {\n\t\t\t\t\t\tfmt.onformat(elm, fmt, vars, node);\n\t\t\t\t\t}\n\n\t\t\t\t\teach(fmt.styles, function(value, name) {\n\t\t\t\t\t\tdom.setStyle(elm, name, replaceVars(value, vars));\n\t\t\t\t\t});\n\n\t\t\t\t\teach(fmt.attributes, function(value, name) {\n\t\t\t\t\t\tdom.setAttrib(elm, name, replaceVars(value, vars));\n\t\t\t\t\t});\n\n\t\t\t\t\teach(fmt.classes, function(value) {\n\t\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\t\tif (!dom.hasClass(elm, value))\n\t\t\t\t\t\t\tdom.addClass(elm, value);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t};\n\t\t\tfunction adjustSelectionToVisibleSelection() {\n\t\t\t\tfunction findSelectionEnd(start, end) {\n\t\t\t\t\tvar walker = new TreeWalker(end);\n\t\t\t\t\tfor (node = walker.current(); node; node = walker.prev()) {\n\t\t\t\t\t\tif (node.childNodes.length > 1 || node == start) {\n\t\t\t\t\t\t\treturn node;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\t// Adjust selection so that a end container with a end offset of zero is not included in the selection\n\t\t\t\t// as this isn't visible to the user.\n\t\t\t\tvar rng = ed.selection.getRng();\n\t\t\t\tvar start = rng.startContainer;\n\t\t\t\tvar end = rng.endContainer;\n\n\t\t\t\tif (start != end && rng.endOffset == 0) {\n\t\t\t\t\tvar newEnd = findSelectionEnd(start, end);\n\t\t\t\t\tvar endOffset = newEnd.nodeType == 3 ? newEnd.length : newEnd.childNodes.length;\n\n\t\t\t\t\trng.setEnd(newEnd, endOffset);\n\t\t\t\t}\n\n\t\t\t\treturn rng;\n\t\t\t}\n\n\t\t\tfunction applyStyleToList(node, bookmark, wrapElm, newWrappers, process){\n\t\t\t\tvar nodes = [], listIndex = -1, list, startIndex = -1, endIndex = -1, currentWrapElm;\n\n\t\t\t\t// find the index of the first child list.\n\t\t\t\teach(node.childNodes, function(n, index) {\n\t\t\t\t\tif (n.nodeName === \"UL\" || n.nodeName === \"OL\") {\n\t\t\t\t\t\tlistIndex = index;\n\t\t\t\t\t\tlist = n;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// get the index of the bookmarks\n\t\t\t\teach(node.childNodes, function(n, index) {\n\t\t\t\t\tif (n.nodeName === \"SPAN\" && dom.getAttrib(n, \"data-mce-type\") == \"bookmark\") {\n\t\t\t\t\t\tif (n.id == bookmark.id + \"_start\") {\n\t\t\t\t\t\t\tstartIndex = index;\n\t\t\t\t\t\t} else if (n.id == bookmark.id + \"_end\") {\n\t\t\t\t\t\t\tendIndex = index;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// if the selection spans across an embedded list, or there isn't an embedded list - handle processing normally\n\t\t\t\tif (listIndex <= 0 || (startIndex < listIndex && endIndex > listIndex)) {\n\t\t\t\t\teach(tinymce.grep(node.childNodes), process);\n\t\t\t\t\treturn 0;\n\t\t\t\t} else {\n\t\t\t\t\tcurrentWrapElm = wrapElm.cloneNode(FALSE);\n\n\t\t\t\t\t// create a list of the nodes on the same side of the list as the selection\n\t\t\t\t\teach(tinymce.grep(node.childNodes), function(n, index) {\n\t\t\t\t\t\tif ((startIndex < listIndex && index < listIndex) || (startIndex > listIndex && index > listIndex)) {\n\t\t\t\t\t\t\tnodes.push(n);\n\t\t\t\t\t\t\tn.parentNode.removeChild(n);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\n\t\t\t\t\t// insert the wrapping element either before or after the list.\n\t\t\t\t\tif (startIndex < listIndex) {\n\t\t\t\t\t\tnode.insertBefore(currentWrapElm, list);\n\t\t\t\t\t} else if (startIndex > listIndex) {\n\t\t\t\t\t\tnode.insertBefore(currentWrapElm, list.nextSibling);\n\t\t\t\t\t}\n\n\t\t\t\t\t// add the new nodes to the list.\n\t\t\t\t\tnewWrappers.push(currentWrapElm);\n\n\t\t\t\t\teach(nodes, function(node) {\n\t\t\t\t\t\tcurrentWrapElm.appendChild(node);\n\t\t\t\t\t});\n\n\t\t\t\t\treturn currentWrapElm;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tfunction applyRngStyle(rng, bookmark, node_specific) {\n\t\t\t\tvar newWrappers = [], wrapName, wrapElm;\n\n\t\t\t\t// Setup wrapper element\n\t\t\t\twrapName = format.inline || format.block;\n\t\t\t\twrapElm = dom.create(wrapName);\n\t\t\t\tsetElementFormat(wrapElm);\n\n\t\t\t\trangeUtils.walk(rng, function(nodes) {\n\t\t\t\t\tvar currentWrapElm;\n\n\t\t\t\t\tfunction process(node) {\n\t\t\t\t\t\tvar nodeName = node.nodeName.toLowerCase(), parentName = node.parentNode.nodeName.toLowerCase(), found;\n\n\t\t\t\t\t\t// Stop wrapping on br elements\n\t\t\t\t\t\tif (isEq(nodeName, 'br')) {\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\n\t\t\t\t\t\t\t// Remove any br elements when we wrap things\n\t\t\t\t\t\t\tif (format.block)\n\t\t\t\t\t\t\t\tdom.remove(node);\n\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// If node is wrapper type\n\t\t\t\t\t\tif (format.wrapper && matchNode(node, name, vars)) {\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Can we rename the block\n\t\t\t\t\t\tif (format.block && !format.wrapper && isTextBlock(nodeName)) {\n\t\t\t\t\t\t\tnode = dom.rename(node, wrapName);\n\t\t\t\t\t\t\tsetElementFormat(node);\n\t\t\t\t\t\t\tnewWrappers.push(node);\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Handle selector patterns\n\t\t\t\t\t\tif (format.selector) {\n\t\t\t\t\t\t\t// Look for matching formats\n\t\t\t\t\t\t\teach(formatList, function(format) {\n\t\t\t\t\t\t\t\t// Check collapsed state if it exists\n\t\t\t\t\t\t\t\tif ('collapsed' in format && format.collapsed !== isCollapsed) {\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tif (dom.is(node, format.selector) && !isCaretNode(node)) {\n\t\t\t\t\t\t\t\t\tsetElementFormat(node, format);\n\t\t\t\t\t\t\t\t\tfound = true;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t// Continue processing if a selector match wasn't found and a inline element is defined\n\t\t\t\t\t\t\tif (!format.inline || found) {\n\t\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Is it valid to wrap this item\n\t\t\t\t\t\tif (isValid(wrapName, nodeName) && isValid(parentName, wrapName) &&\n\t\t\t\t\t\t\t\t!(!node_specific && node.nodeType === 3 && node.nodeValue.length === 1 && node.nodeValue.charCodeAt(0) === 65279) && node.id !== '_mce_caret') {\n\t\t\t\t\t\t\t// Start wrapping\n\t\t\t\t\t\t\tif (!currentWrapElm) {\n\t\t\t\t\t\t\t\t// Wrap the node\n\t\t\t\t\t\t\t\tcurrentWrapElm = wrapElm.cloneNode(FALSE);\n\t\t\t\t\t\t\t\tnode.parentNode.insertBefore(currentWrapElm, node);\n\t\t\t\t\t\t\t\tnewWrappers.push(currentWrapElm);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tcurrentWrapElm.appendChild(node);\n\t\t\t\t\t\t} else if (nodeName == 'li' && bookmark) {\n\t\t\t\t\t\t\t// Start wrapping - if we are in a list node and have a bookmark, then we will always begin by wrapping in a new element.\n\t\t\t\t\t\t\tcurrentWrapElm = applyStyleToList(node, bookmark, wrapElm, newWrappers, process);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Start a new wrapper for possible children\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\n\t\t\t\t\t\t\teach(tinymce.grep(node.childNodes), process);\n\n\t\t\t\t\t\t\t// End the last wrapper\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\t\t// Process siblings from range\n\t\t\t\t\teach(nodes, process);\n\t\t\t\t});\n\n\t\t\t\t// Wrap links inside as well, for example color inside a link when the wrapper is around the link\n\t\t\t\tif (format.wrap_links === false) {\n\t\t\t\t\teach(newWrappers, function(node) {\n\t\t\t\t\t\tfunction process(node) {\n\t\t\t\t\t\t\tvar i, currentWrapElm, children;\n\n\t\t\t\t\t\t\tif (node.nodeName === 'A') {\n\t\t\t\t\t\t\t\tcurrentWrapElm = wrapElm.cloneNode(FALSE);\n\t\t\t\t\t\t\t\tnewWrappers.push(currentWrapElm);\n\n\t\t\t\t\t\t\t\tchildren = tinymce.grep(node.childNodes);\n\t\t\t\t\t\t\t\tfor (i = 0; i < children.length; i++)\n\t\t\t\t\t\t\t\t\tcurrentWrapElm.appendChild(children[i]);\n\n\t\t\t\t\t\t\t\tnode.appendChild(currentWrapElm);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\teach(tinymce.grep(node.childNodes), process);\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tprocess(node);\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\t// Cleanup\n\t\t\t\teach(newWrappers, function(node) {\n\t\t\t\t\tvar childCount;\n\n\t\t\t\t\tfunction getChildCount(node) {\n\t\t\t\t\t\tvar count = 0;\n\n\t\t\t\t\t\teach(node.childNodes, function(node) {\n\t\t\t\t\t\t\tif (!isWhiteSpaceNode(node) && !isBookmarkNode(node))\n\t\t\t\t\t\t\t\tcount++;\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\treturn count;\n\t\t\t\t\t};\n\n\t\t\t\t\tfunction mergeStyles(node) {\n\t\t\t\t\t\tvar child, clone;\n\n\t\t\t\t\t\teach(node.childNodes, function(node) {\n\t\t\t\t\t\t\tif (node.nodeType == 1 && !isBookmarkNode(node) && !isCaretNode(node)) {\n\t\t\t\t\t\t\t\tchild = node;\n\t\t\t\t\t\t\t\treturn FALSE; // break loop\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\t// If child was found and of the same type as the current node\n\t\t\t\t\t\tif (child && matchName(child, format)) {\n\t\t\t\t\t\t\tclone = child.cloneNode(FALSE);\n\t\t\t\t\t\t\tsetElementFormat(clone);\n\n\t\t\t\t\t\t\tdom.replace(clone, node, TRUE);\n\t\t\t\t\t\t\tdom.remove(child, 1);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn clone || node;\n\t\t\t\t\t};\n\n\t\t\t\t\tchildCount = getChildCount(node);\n\n\t\t\t\t\t// Remove empty nodes but only if there is multiple wrappers and they are not block\n\t\t\t\t\t// elements so never remove single <h1></h1> since that would remove the current empty block element where the caret is at\n\t\t\t\t\tif ((newWrappers.length > 1 || !isBlock(node)) && childCount === 0) {\n\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (format.inline || format.wrapper) {\n\t\t\t\t\t\t// Merges the current node with it's children of similar type to reduce the number of elements\n\t\t\t\t\t\tif (!format.exact && childCount === 1)\n\t\t\t\t\t\t\tnode = mergeStyles(node);\n\n\t\t\t\t\t\t// Remove/merge children\n\t\t\t\t\t\teach(formatList, function(format) {\n\t\t\t\t\t\t\t// Merge all children of similar type will move styles from child to parent\n\t\t\t\t\t\t\t// this: <span style=\"color:red\"><b><span style=\"color:red; font-size:10px\">text</span></b></span>\n\t\t\t\t\t\t\t// will become: <span style=\"color:red\"><b><span style=\"font-size:10px\">text</span></b></span>\n\t\t\t\t\t\t\teach(dom.select(format.inline, node), function(child) {\n\t\t\t\t\t\t\t\tvar parent;\n\n\t\t\t\t\t\t\t\t// When wrap_links is set to false we don't want\n\t\t\t\t\t\t\t\t// to remove the format on children within links\n\t\t\t\t\t\t\t\tif (format.wrap_links === false) {\n\t\t\t\t\t\t\t\t\tparent = child.parentNode;\n\n\t\t\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\t\t\tif (parent.nodeName === 'A')\n\t\t\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t\t} while (parent = parent.parentNode);\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tremoveFormat(format, vars, child, format.exact ? child : null);\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\t// Remove child if direct parent is of same type\n\t\t\t\t\t\tif (matchNode(node.parentNode, name, vars)) {\n\t\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t\t\tnode = 0;\n\t\t\t\t\t\t\treturn TRUE;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Look for parent with similar style format\n\t\t\t\t\t\tif (format.merge_with_parents) {\n\t\t\t\t\t\t\tdom.getParent(node.parentNode, function(parent) {\n\t\t\t\t\t\t\t\tif (matchNode(parent, name, vars)) {\n\t\t\t\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t\t\t\t\tnode = 0;\n\t\t\t\t\t\t\t\t\treturn TRUE;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Merge next and previous siblings if they are similar <b>text</b><b>text</b> becomes <b>texttext</b>\n\t\t\t\t\t\tif (node && format.merge_siblings !== false) {\n\t\t\t\t\t\t\tnode = mergeSiblings(getNonWhiteSpaceSibling(node), node);\n\t\t\t\t\t\t\tnode = mergeSiblings(node, getNonWhiteSpaceSibling(node, TRUE));\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t};\n\n\t\t\tif (format) {\n\t\t\t\tif (node) {\n\t\t\t\t\tif (node.nodeType) {\n\t\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\t\trng.setEndAfter(node);\n\t\t\t\t\t\tapplyRngStyle(expandRng(rng, formatList), null, true);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tapplyRngStyle(node, null, true);\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tif (!isCollapsed || !format.inline || dom.select('td.mceSelected,th.mceSelected').length) {\n\t\t\t\t\t\t// Obtain selection node before selection is unselected by applyRngStyle()\n\t\t\t\t\t\tvar curSelNode = ed.selection.getNode();\n\n\t\t\t\t\t\t// Apply formatting to selection\n\t\t\t\t\t\ted.selection.setRng(adjustSelectionToVisibleSelection());\n\t\t\t\t\t\tbookmark = selection.getBookmark();\n\t\t\t\t\t\tapplyRngStyle(expandRng(selection.getRng(TRUE), formatList), bookmark);\n\n\t\t\t\t\t\t// Colored nodes should be underlined so that the color of the underline matches the text color.\n\t\t\t\t\t\tif (format.styles && (format.styles.color || format.styles.textDecoration)) {\n\t\t\t\t\t\t\ttinymce.walk(curSelNode, processUnderlineAndColor, 'childNodes');\n\t\t\t\t\t\t\tprocessUnderlineAndColor(curSelNode);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t\t\t\tselection.setRng(moveStart(selection.getRng(TRUE)));\n\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t} else\n\t\t\t\t\t\tperformCaretAction('apply', name, vars);\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction remove(name, vars, node) {\n\t\t\tvar formatList = get(name), format = formatList[0], bookmark, i, rng;\n\t\t\tfunction moveStart(rng) {\n\t\t\t\tvar container = rng.startContainer,\n\t\t\t\t\toffset = rng.startOffset,\n\t\t\t\t\twalker, node, nodes, tmpNode;\n\n\t\t\t\t// Convert text node into index if possible\n\t\t\t\tif (container.nodeType == 3 && offset >= container.nodeValue.length - 1) {\n\t\t\t\t\tcontainer = container.parentNode;\n\t\t\t\t\toffset = nodeIndex(container) + 1;\n\t\t\t\t}\n\n\t\t\t\t// Move startContainer/startOffset in to a suitable node\n\t\t\t\tif (container.nodeType == 1) {\n\t\t\t\t\tnodes = container.childNodes;\n\t\t\t\t\tcontainer = nodes[Math.min(offset, nodes.length - 1)];\n\t\t\t\t\twalker = new TreeWalker(container);\n\n\t\t\t\t\t// If offset is at end of the parent node walk to the next one\n\t\t\t\t\tif (offset > nodes.length - 1)\n\t\t\t\t\t\twalker.next();\n\n\t\t\t\t\tfor (node = walker.current(); node; node = walker.next()) {\n\t\t\t\t\t\tif (node.nodeType == 3 && !isWhiteSpaceNode(node)) {\n\t\t\t\t\t\t\t// IE has a \"neat\" feature where it moves the start node into the closest element\n\t\t\t\t\t\t\t// we can avoid this by inserting an element before it and then remove it after we set the selection\n\t\t\t\t\t\t\ttmpNode = dom.create('a', null, INVISIBLE_CHAR);\n\t\t\t\t\t\t\tnode.parentNode.insertBefore(tmpNode, node);\n\n\t\t\t\t\t\t\t// Set selection and remove tmpNode\n\t\t\t\t\t\t\trng.setStart(node, 0);\n\t\t\t\t\t\t\tselection.setRng(rng);\n\t\t\t\t\t\t\tdom.remove(tmpNode);\n\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Merges the styles for each node\n\t\t\tfunction process(node) {\n\t\t\t\tvar children, i, l;\n\n\t\t\t\t// Grab the children first since the nodelist might be changed\n\t\t\t\tchildren = tinymce.grep(node.childNodes);\n\n\t\t\t\t// Process current node\n\t\t\t\tfor (i = 0, l = formatList.length; i < l; i++) {\n\t\t\t\t\tif (removeFormat(formatList[i], vars, node, node))\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\t// Process the children\n\t\t\t\tif (format.deep) {\n\t\t\t\t\tfor (i = 0, l = children.length; i < l; i++)\n\t\t\t\t\t\tprocess(children[i]);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tfunction findFormatRoot(container) {\n\t\t\t\tvar formatRoot;\n\n\t\t\t\t// Find format root\n\t\t\t\teach(getParents(container.parentNode).reverse(), function(parent) {\n\t\t\t\t\tvar format;\n\n\t\t\t\t\t// Find format root element\n\t\t\t\t\tif (!formatRoot && parent.id != '_start' && parent.id != '_end') {\n\t\t\t\t\t\t// Is the node matching the format we are looking for\n\t\t\t\t\t\tformat = matchNode(parent, name, vars);\n\t\t\t\t\t\tif (format && format.split !== false)\n\t\t\t\t\t\t\tformatRoot = parent;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\treturn formatRoot;\n\t\t\t};\n\n\t\t\tfunction wrapAndSplit(format_root, container, target, split) {\n\t\t\t\tvar parent, clone, lastClone, firstClone, i, formatRootParent;\n\n\t\t\t\t// Format root found then clone formats and split it\n\t\t\t\tif (format_root) {\n\t\t\t\t\tformatRootParent = format_root.parentNode;\n\n\t\t\t\t\tfor (parent = container.parentNode; parent && parent != formatRootParent; parent = parent.parentNode) {\n\t\t\t\t\t\tclone = parent.cloneNode(FALSE);\n\n\t\t\t\t\t\tfor (i = 0; i < formatList.length; i++) {\n\t\t\t\t\t\t\tif (removeFormat(formatList[i], vars, clone, clone)) {\n\t\t\t\t\t\t\t\tclone = 0;\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Build wrapper node\n\t\t\t\t\t\tif (clone) {\n\t\t\t\t\t\t\tif (lastClone)\n\t\t\t\t\t\t\t\tclone.appendChild(lastClone);\n\n\t\t\t\t\t\t\tif (!firstClone)\n\t\t\t\t\t\t\t\tfirstClone = clone;\n\n\t\t\t\t\t\t\tlastClone = clone;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Never split block elements if the format is mixed\n\t\t\t\t\tif (split && (!format.mixed || !isBlock(format_root)))\n\t\t\t\t\t\tcontainer = dom.split(format_root, container);\n\n\t\t\t\t\t// Wrap container in cloned formats\n\t\t\t\t\tif (lastClone) {\n\t\t\t\t\t\ttarget.parentNode.insertBefore(lastClone, target);\n\t\t\t\t\t\tfirstClone.appendChild(target);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn container;\n\t\t\t};\n\n\t\t\tfunction splitToFormatRoot(container) {\n\t\t\t\treturn wrapAndSplit(findFormatRoot(container), container, container, true);\n\t\t\t};\n\n\t\t\tfunction unwrap(start) {\n\t\t\t\tvar node = dom.get(start ? '_start' : '_end'),\n\t\t\t\t\tout = node[start ? 'firstChild' : 'lastChild'];\n\n\t\t\t\t// If the end is placed within the start the result will be removed\n\t\t\t\t// So this checks if the out node is a bookmark node if it is it\n\t\t\t\t// checks for another more suitable node\n\t\t\t\tif (isBookmarkNode(out))\n\t\t\t\t\tout = out[start ? 'firstChild' : 'lastChild'];\n\n\t\t\t\tdom.remove(node, true);\n\n\t\t\t\treturn out;\n\t\t\t};\n\n\t\t\tfunction removeRngStyle(rng) {\n\t\t\t\tvar startContainer, endContainer;\n\n\t\t\t\trng = expandRng(rng, formatList, TRUE);\n\n\t\t\t\tif (format.split) {\n\t\t\t\t\tstartContainer = getContainer(rng, TRUE);\n\t\t\t\t\tendContainer = getContainer(rng);\n\n\t\t\t\t\tif (startContainer != endContainer) {\n\t\t\t\t\t\t// Wrap start/end nodes in span element since these might be cloned/moved\n\t\t\t\t\t\tstartContainer = wrap(startContainer, 'span', {id : '_start', 'data-mce-type' : 'bookmark'});\n\t\t\t\t\t\tendContainer = wrap(endContainer, 'span', {id : '_end', 'data-mce-type' : 'bookmark'});\n\n\t\t\t\t\t\t// Split start/end\n\t\t\t\t\t\tsplitToFormatRoot(startContainer);\n\t\t\t\t\t\tsplitToFormatRoot(endContainer);\n\n\t\t\t\t\t\t// Unwrap start/end to get real elements again\n\t\t\t\t\t\tstartContainer = unwrap(TRUE);\n\t\t\t\t\t\tendContainer = unwrap();\n\t\t\t\t\t} else\n\t\t\t\t\t\tstartContainer = endContainer = splitToFormatRoot(startContainer);\n\n\t\t\t\t\t// Update range positions since they might have changed after the split operations\n\t\t\t\t\trng.startContainer = startContainer.parentNode;\n\t\t\t\t\trng.startOffset = nodeIndex(startContainer);\n\t\t\t\t\trng.endContainer = endContainer.parentNode;\n\t\t\t\t\trng.endOffset = nodeIndex(endContainer) + 1;\n\t\t\t\t}\n\n\t\t\t\t// Remove items between start/end\n\t\t\t\trangeUtils.walk(rng, function(nodes) {\n\t\t\t\t\teach(nodes, function(node) {\n\t\t\t\t\t\tprocess(node);\n\n\t\t\t\t\t\t// Remove parent span if it only contains text-decoration: underline, yet a parent node is also underlined.\n\t\t\t\t\t\tif (node.nodeType === 1 && ed.dom.getStyle(node, 'text-decoration') === 'underline' && node.parentNode && getTextDecoration(node.parentNode) === 'underline') {\n\t\t\t\t\t\t\tremoveFormat({'deep': false, 'exact': true, 'inline': 'span', 'styles': {'textDecoration' : 'underline'}}, null, node);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t};\n\n\t\t\t// Handle node\n\t\t\tif (node) {\n\t\t\t\tif (node.nodeType) {\n\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\trng.setEndAfter(node);\n\t\t\t\t\tremoveRngStyle(rng);\n\t\t\t\t} else {\n\t\t\t\t\tremoveRngStyle(node);\n\t\t\t\t}\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif (!selection.isCollapsed() || !format.inline || dom.select('td.mceSelected,th.mceSelected').length) {\n\t\t\t\tbookmark = selection.getBookmark();\n\t\t\t\tremoveRngStyle(selection.getRng(TRUE));\n\t\t\t\tselection.moveToBookmark(bookmark);\n\n\t\t\t\t// Check if start element still has formatting then we are at: \"<b>text|</b>text\" and need to move the start into the next text node\n\t\t\t\tif (format.inline && match(name, vars, selection.getStart())) {\n\t\t\t\t\tmoveStart(selection.getRng(true));\n\t\t\t\t}\n\n\t\t\t\ted.nodeChanged();\n\t\t\t} else\n\t\t\t\tperformCaretAction('remove', name, vars);\n\n\t\t\t// When you remove formatting from a table cell in WebKit (cell, not the contents of a cell) there is a rendering issue with column width\n\t\t\tif (tinymce.isWebKit) {\n\t\t\t\ted.execCommand('mceCleanup');\n\t\t\t}\n\t\t};\n\n\t\tfunction toggle(name, vars, node) {\n\t\t\tvar fmt = get(name);\n\n\t\t\tif (match(name, vars, node) && (!('toggle' in fmt[0]) || fmt[0]['toggle']))\n\t\t\t\tremove(name, vars, node);\n\t\t\telse\n\t\t\t\tapply(name, vars, node);\n\t\t};\n\n\t\tfunction matchNode(node, name, vars, similar) {\n\t\t\tvar formatList = get(name), format, i, classes;\n\n\t\t\tfunction matchItems(node, format, item_name) {\n\t\t\t\tvar key, value, items = format[item_name], i;\n\n\t\t\t\t// Custom match\n\t\t\t\tif (format.onmatch) {\n\t\t\t\t\treturn format.onmatch(node, format, item_name);\n\t\t\t\t}\n\n\t\t\t\t// Check all items\n\t\t\t\tif (items) {\n\t\t\t\t\t// Non indexed object\n\t\t\t\t\tif (items.length === undefined) {\n\t\t\t\t\t\tfor (key in items) {\n\t\t\t\t\t\t\tif (items.hasOwnProperty(key)) {\n\t\t\t\t\t\t\t\tif (item_name === 'attributes')\n\t\t\t\t\t\t\t\t\tvalue = dom.getAttrib(node, key);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\tvalue = getStyle(node, key);\n\n\t\t\t\t\t\t\t\tif (similar && !value && !format.exact)\n\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\tif ((!similar || format.exact) && !isEq(value, replaceVars(items[key], vars)))\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Only one match needed for indexed arrays\n\t\t\t\t\t\tfor (i = 0; i < items.length; i++) {\n\t\t\t\t\t\t\tif (item_name === 'attributes' ? dom.getAttrib(node, items[i]) : getStyle(node, items[i]))\n\t\t\t\t\t\t\t\treturn format;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn format;\n\t\t\t};\n\n\t\t\tif (formatList && node) {\n\t\t\t\t// Check each format in list\n\t\t\t\tfor (i = 0; i < formatList.length; i++) {\n\t\t\t\t\tformat = formatList[i];\n\n\t\t\t\t\t// Name name, attributes, styles and classes\n\t\t\t\t\tif (matchName(node, format) && matchItems(node, format, 'attributes') && matchItems(node, format, 'styles')) {\n\t\t\t\t\t\t// Match classes\n\t\t\t\t\t\tif (classes = format.classes) {\n\t\t\t\t\t\t\tfor (i = 0; i < classes.length; i++) {\n\t\t\t\t\t\t\t\tif (!dom.hasClass(node, classes[i]))\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn format;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction match(name, vars, node) {\n\t\t\tvar startNode;\n\n\t\t\tfunction matchParents(node) {\n\t\t\t\t// Find first node with similar format settings\n\t\t\t\tnode = dom.getParent(node, function(node) {\n\t\t\t\t\treturn !!matchNode(node, name, vars, true);\n\t\t\t\t});\n\n\t\t\t\t// Do an exact check on the similar format element\n\t\t\t\treturn matchNode(node, name, vars);\n\t\t\t};\n\n\t\t\t// Check specified node\n\t\t\tif (node)\n\t\t\t\treturn matchParents(node);\n\n\t\t\t// Check selected node\n\t\t\tnode = selection.getNode();\n\t\t\tif (matchParents(node))\n\t\t\t\treturn TRUE;\n\n\t\t\t// Check start node if it's different\n\t\t\tstartNode = selection.getStart();\n\t\t\tif (startNode != node) {\n\t\t\t\tif (matchParents(startNode))\n\t\t\t\t\treturn TRUE;\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\tfunction matchAll(names, vars) {\n\t\t\tvar startElement, matchedFormatNames = [], checkedMap = {}, i, ni, name;\n\n\t\t\t// Check start of selection for formats\n\t\t\tstartElement = selection.getStart();\n\t\t\tdom.getParent(startElement, function(node) {\n\t\t\t\tvar i, name;\n\n\t\t\t\tfor (i = 0; i < names.length; i++) {\n\t\t\t\t\tname = names[i];\n\n\t\t\t\t\tif (!checkedMap[name] && matchNode(node, name, vars)) {\n\t\t\t\t\t\tcheckedMap[name] = true;\n\t\t\t\t\t\tmatchedFormatNames.push(name);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn matchedFormatNames;\n\t\t};\n\n\t\tfunction canApply(name) {\n\t\t\tvar formatList = get(name), startNode, parents, i, x, selector;\n\n\t\t\tif (formatList) {\n\t\t\t\tstartNode = selection.getStart();\n\t\t\t\tparents = getParents(startNode);\n\n\t\t\t\tfor (x = formatList.length - 1; x >= 0; x--) {\n\t\t\t\t\tselector = formatList[x].selector;\n\n\t\t\t\t\t// Format is not selector based, then always return TRUE\n\t\t\t\t\tif (!selector)\n\t\t\t\t\t\treturn TRUE;\n\n\t\t\t\t\tfor (i = parents.length - 1; i >= 0; i--) {\n\t\t\t\t\t\tif (dom.is(parents[i], selector))\n\t\t\t\t\t\t\treturn TRUE;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\t// Expose to public\n\t\ttinymce.extend(this, {\n\t\t\tget : get,\n\t\t\tregister : register,\n\t\t\tapply : apply,\n\t\t\tremove : remove,\n\t\t\ttoggle : toggle,\n\t\t\tmatch : match,\n\t\t\tmatchAll : matchAll,\n\t\t\tmatchNode : matchNode,\n\t\t\tcanApply : canApply\n\t\t});\n\n\t\t// Private functions\n\n\t\tfunction matchName(node, format) {\n\t\t\t// Check for inline match\n\t\t\tif (isEq(node, format.inline))\n\t\t\t\treturn TRUE;\n\n\t\t\t// Check for block match\n\t\t\tif (isEq(node, format.block))\n\t\t\t\treturn TRUE;\n\n\t\t\t// Check for selector match\n\t\t\tif (format.selector)\n\t\t\t\treturn dom.is(node, format.selector);\n\t\t};\n\n\t\tfunction isEq(str1, str2) {\n\t\t\tstr1 = str1 || '';\n\t\t\tstr2 = str2 || '';\n\n\t\t\tstr1 = '' + (str1.nodeName || str1);\n\t\t\tstr2 = '' + (str2.nodeName || str2);\n\n\t\t\treturn str1.toLowerCase() == str2.toLowerCase();\n\t\t};\n\n\t\tfunction getStyle(node, name) {\n\t\t\tvar styleVal = dom.getStyle(node, name);\n\n\t\t\t// Force the format to hex\n\t\t\tif (name == 'color' || name == 'backgroundColor')\n\t\t\t\tstyleVal = dom.toHex(styleVal);\n\n\t\t\t// Opera will return bold as 700\n\t\t\tif (name == 'fontWeight' && styleVal == 700)\n\t\t\t\tstyleVal = 'bold';\n\n\t\t\treturn '' + styleVal;\n\t\t};\n\n\t\tfunction replaceVars(value, vars) {\n\t\t\tif (typeof(value) != \"string\")\n\t\t\t\tvalue = value(vars);\n\t\t\telse if (vars) {\n\t\t\t\tvalue = value.replace(/%(\\w+)/g, function(str, name) {\n\t\t\t\t\treturn vars[name] || str;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn value;\n\t\t};\n\n\t\tfunction isWhiteSpaceNode(node) {\n\t\t\treturn node && node.nodeType === 3 && /^([\\t \\r\\n]+|)$/.test(node.nodeValue);\n\t\t};\n\n\t\tfunction wrap(node, name, attrs) {\n\t\t\tvar wrapper = dom.create(name, attrs);\n\n\t\t\tnode.parentNode.insertBefore(wrapper, node);\n\t\t\twrapper.appendChild(node);\n\n\t\t\treturn wrapper;\n\t\t};\n\n\t\tfunction expandRng(rng, format, remove) {\n\t\t\tvar startContainer = rng.startContainer,\n\t\t\t\tstartOffset = rng.startOffset,\n\t\t\t\tendContainer = rng.endContainer,\n\t\t\t\tendOffset = rng.endOffset, sibling, lastIdx, leaf, endPoint;\n\n\t\t\t// This function walks up the tree if there is no siblings before/after the node\n\t\t\tfunction findParentContainer(start) {\n\t\t\t\tvar container, parent, child, sibling, siblingName;\n\n\t\t\t\tcontainer = parent = start ? startContainer : endContainer;\n\t\t\t\tsiblingName = start ? 'previousSibling' : 'nextSibling';\n\t\t\t\troot = dom.getRoot();\n\n\t\t\t\t// If it's a text node and the offset is inside the text\n\t\t\t\tif (container.nodeType == 3 && !isWhiteSpaceNode(container)) {\n\t\t\t\t\tif (start ? startOffset > 0 : endOffset < container.nodeValue.length) {\n\t\t\t\t\t\treturn container;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor (;;) {\n\t\t\t\t\t// Stop expanding on block elements or root depending on format\n\t\t\t\t\tif (parent == root || (!format[0].block_expand && isBlock(parent)))\n\t\t\t\t\t\treturn parent;\n\n\t\t\t\t\t// Walk left/right\n\t\t\t\t\tfor (sibling = parent[siblingName]; sibling; sibling = sibling[siblingName]) {\n\t\t\t\t\t\tif (!isBookmarkNode(sibling) && !isWhiteSpaceNode(sibling)) {\n\t\t\t\t\t\t\treturn parent;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Check if we can move up are we at root level or body level\n\t\t\t\t\tparent = parent.parentNode;\n\t\t\t\t}\n\n\t\t\t\treturn container;\n\t\t\t};\n\n\t\t\t// This function walks down the tree to find the leaf at the selection.\n\t\t\t// The offset is also returned as if node initially a leaf, the offset may be in the middle of the text node.\n\t\t\tfunction findLeaf(node, offset) {\n\t\t\t\tif (offset === undefined)\n\t\t\t\t\toffset = node.nodeType === 3 ? node.length : node.childNodes.length;\n\t\t\t\twhile (node && node.hasChildNodes()) {\n\t\t\t\t\tnode = node.childNodes[offset];\n\t\t\t\t\tif (node)\n\t\t\t\t\t\toffset = node.nodeType === 3 ? node.length : node.childNodes.length;\n\t\t\t\t}\n\t\t\t\treturn { node: node, offset: offset };\n\t\t\t}\n\n\t\t\t// If index based start position then resolve it\n\t\t\tif (startContainer.nodeType == 1 && startContainer.hasChildNodes()) {\n\t\t\t\tlastIdx = startContainer.childNodes.length - 1;\n\t\t\t\tstartContainer = startContainer.childNodes[startOffset > lastIdx ? lastIdx : startOffset];\n\n\t\t\t\tif (startContainer.nodeType == 3)\n\t\t\t\t\tstartOffset = 0;\n\t\t\t}\n\n\t\t\t// If index based end position then resolve it\n\t\t\tif (endContainer.nodeType == 1 && endContainer.hasChildNodes()) {\n\t\t\t\tlastIdx = endContainer.childNodes.length - 1;\n\t\t\t\tendContainer = endContainer.childNodes[endOffset > lastIdx ? lastIdx : endOffset - 1];\n\n\t\t\t\tif (endContainer.nodeType == 3)\n\t\t\t\t\tendOffset = endContainer.nodeValue.length;\n\t\t\t}\n\n\t\t\t// Exclude bookmark nodes if possible\n\t\t\tif (isBookmarkNode(startContainer.parentNode) || isBookmarkNode(startContainer)) {\n\t\t\t\tstartContainer = isBookmarkNode(startContainer) ? startContainer : startContainer.parentNode;\n\t\t\t\tstartContainer = startContainer.nextSibling || startContainer;\n\n\t\t\t\tif (startContainer.nodeType == 3)\n\t\t\t\t\tstartOffset = 0;\n\t\t\t}\n\n\t\t\tif (isBookmarkNode(endContainer.parentNode) || isBookmarkNode(endContainer)) {\n\t\t\t\tendContainer = isBookmarkNode(endContainer) ? endContainer : endContainer.parentNode;\n\t\t\t\tendContainer = endContainer.previousSibling || endContainer;\n\n\t\t\t\tif (endContainer.nodeType == 3)\n\t\t\t\t\tendOffset = endContainer.length;\n\t\t\t}\n\n\t\t\tif (format[0].inline) {\n\t\t\t\tif (rng.collapsed) {\n\t\t\t\t\tfunction findWordEndPoint(container, offset, start) {\n\t\t\t\t\t\tvar walker, node, pos, lastTextNode;\n\n\t\t\t\t\t\tfunction findSpace(node, offset) {\n\t\t\t\t\t\t\tvar pos, pos2, str = node.nodeValue;\n\n\t\t\t\t\t\t\tif (typeof(offset) == \"undefined\") {\n\t\t\t\t\t\t\t\toffset = start ? str.length : 0;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (start) {\n\t\t\t\t\t\t\t\tpos = str.lastIndexOf(' ', offset);\n\t\t\t\t\t\t\t\tpos2 = str.lastIndexOf('\\u00a0', offset);\n\t\t\t\t\t\t\t\tpos = pos > pos2 ? pos : pos2;\n\n\t\t\t\t\t\t\t\t// Include the space on remove to avoid tag soup\n\t\t\t\t\t\t\t\tif (pos !== -1 && !remove) {\n\t\t\t\t\t\t\t\t\tpos++;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tpos = str.indexOf(' ', offset);\n\t\t\t\t\t\t\t\tpos2 = str.indexOf('\\u00a0', offset);\n\t\t\t\t\t\t\t\tpos = pos !== -1 && (pos2 === -1 || pos < pos2) ? pos : pos2;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn pos;\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tif (container.nodeType === 3) {\n\t\t\t\t\t\t\tpos = findSpace(container, offset);\n\n\t\t\t\t\t\t\tif (pos !== -1) {\n\t\t\t\t\t\t\t\treturn {container : container, offset : pos};\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tlastTextNode = container;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Walk the nodes inside the block\n\t\t\t\t\t\twalker = new TreeWalker(container, dom.getParent(container, isBlock) || ed.getBody());\n\t\t\t\t\t\twhile (node = walker[start ? 'prev' : 'next']()) {\n\t\t\t\t\t\t\tif (node.nodeType === 3) {\n\t\t\t\t\t\t\t\tlastTextNode = node;\n\t\t\t\t\t\t\t\tpos = findSpace(node);\n\n\t\t\t\t\t\t\t\tif (pos !== -1) {\n\t\t\t\t\t\t\t\t\treturn {container : node, offset : pos};\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else if (isBlock(node)) {\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (lastTextNode) {\n\t\t\t\t\t\t\tif (start) {\n\t\t\t\t\t\t\t\toffset = 0;\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\toffset = lastTextNode.length;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn {container: lastTextNode, offset: offset};\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Expand left to closest word boundery\n\t\t\t\t\tendPoint = findWordEndPoint(startContainer, startOffset, true);\n\t\t\t\t\tif (endPoint) {\n\t\t\t\t\t\tstartContainer = endPoint.container;\n\t\t\t\t\t\tstartOffset = endPoint.offset;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Expand right to closest word boundery\n\t\t\t\t\tendPoint = findWordEndPoint(endContainer, endOffset);\n\t\t\t\t\tif (endPoint) {\n\t\t\t\t\t\tendContainer = endPoint.container;\n\t\t\t\t\t\tendOffset = endPoint.offset;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Avoid applying formatting to a trailing space.\n\t\t\t\tleaf = findLeaf(endContainer, endOffset);\n\t\t\t\tif (leaf.node) {\n\t\t\t\t\twhile (leaf.node && leaf.offset === 0 && leaf.node.previousSibling)\n\t\t\t\t\t\tleaf = findLeaf(leaf.node.previousSibling);\n\n\t\t\t\t\tif (leaf.node && leaf.offset > 0 && leaf.node.nodeType === 3 &&\n\t\t\t\t\t\t\tleaf.node.nodeValue.charAt(leaf.offset - 1) === ' ') {\n\n\t\t\t\t\t\tif (leaf.offset > 1) {\n\t\t\t\t\t\t\tendContainer = leaf.node;\n\t\t\t\t\t\t\tendContainer.splitText(leaf.offset - 1);\n\t\t\t\t\t\t} else if (leaf.node.previousSibling) {\n\t\t\t\t\t\t\t// TODO: Figure out why this is in here\n\t\t\t\t\t\t\t//endContainer = leaf.node.previousSibling;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Move start/end point up the tree if the leaves are sharp and if we are in different containers\n\t\t\t// Example * becomes !: !<p><b><i>*text</i><i>text*</i></b></p>!\n\t\t\t// This will reduce the number of wrapper elements that needs to be created\n\t\t\t// Move start point up the tree\n\t\t\tif (format[0].inline || format[0].block_expand) {\n\t\t\t\tif (!format[0].inline || (startContainer.nodeType != 3 || startOffset === 0)) {\n\t\t\t\t\tstartContainer = findParentContainer(true);\n\t\t\t\t}\n\n\t\t\t\tif (!format[0].inline || (endContainer.nodeType != 3 || endOffset === endContainer.nodeValue.length)) {\n\t\t\t\t\tendContainer = findParentContainer();\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Expand start/end container to matching selector\n\t\t\tif (format[0].selector && format[0].expand !== FALSE && !format[0].inline) {\n\t\t\t\tfunction findSelectorEndPoint(container, sibling_name) {\n\t\t\t\t\tvar parents, i, y, curFormat;\n\n\t\t\t\t\tif (container.nodeType == 3 && container.nodeValue.length == 0 && container[sibling_name])\n\t\t\t\t\t\tcontainer = container[sibling_name];\n\n\t\t\t\t\tparents = getParents(container);\n\t\t\t\t\tfor (i = 0; i < parents.length; i++) {\n\t\t\t\t\t\tfor (y = 0; y < format.length; y++) {\n\t\t\t\t\t\t\tcurFormat = format[y];\n\n\t\t\t\t\t\t\t// If collapsed state is set then skip formats that doesn't match that\n\t\t\t\t\t\t\tif (\"collapsed\" in curFormat && curFormat.collapsed !== rng.collapsed)\n\t\t\t\t\t\t\t\tcontinue;\n\n\t\t\t\t\t\t\tif (dom.is(parents[i], curFormat.selector))\n\t\t\t\t\t\t\t\treturn parents[i];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn container;\n\t\t\t\t};\n\n\t\t\t\t// Find new startContainer/endContainer if there is better one\n\t\t\t\tstartContainer = findSelectorEndPoint(startContainer, 'previousSibling');\n\t\t\t\tendContainer = findSelectorEndPoint(endContainer, 'nextSibling');\n\t\t\t}\n\n\t\t\t// Expand start/end container to matching block element or text node\n\t\t\tif (format[0].block || format[0].selector) {\n\t\t\t\tfunction findBlockEndPoint(container, sibling_name, sibling_name2) {\n\t\t\t\t\tvar node;\n\n\t\t\t\t\t// Expand to block of similar type\n\t\t\t\t\tif (!format[0].wrapper)\n\t\t\t\t\t\tnode = dom.getParent(container, format[0].block);\n\n\t\t\t\t\t// Expand to first wrappable block element or any block element\n\t\t\t\t\tif (!node)\n\t\t\t\t\t\tnode = dom.getParent(container.nodeType == 3 ? container.parentNode : container, isBlock);\n\n\t\t\t\t\t// Exclude inner lists from wrapping\n\t\t\t\t\tif (node && format[0].wrapper)\n\t\t\t\t\t\tnode = getParents(node, 'ul,ol').reverse()[0] || node;\n\n\t\t\t\t\t// Didn't find a block element look for first/last wrappable element\n\t\t\t\t\tif (!node) {\n\t\t\t\t\t\tnode = container;\n\n\t\t\t\t\t\twhile (node[sibling_name] && !isBlock(node[sibling_name])) {\n\t\t\t\t\t\t\tnode = node[sibling_name];\n\n\t\t\t\t\t\t\t// Break on BR but include it will be removed later on\n\t\t\t\t\t\t\t// we can't remove it now since we need to check if it can be wrapped\n\t\t\t\t\t\t\tif (isEq(node, 'br'))\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn node || container;\n\t\t\t\t};\n\n\t\t\t\t// Find new startContainer/endContainer if there is better one\n\t\t\t\tstartContainer = findBlockEndPoint(startContainer, 'previousSibling');\n\t\t\t\tendContainer = findBlockEndPoint(endContainer, 'nextSibling');\n\n\t\t\t\t// Non block element then try to expand up the leaf\n\t\t\t\tif (format[0].block) {\n\t\t\t\t\tif (!isBlock(startContainer))\n\t\t\t\t\t\tstartContainer = findParentContainer(true);\n\n\t\t\t\t\tif (!isBlock(endContainer))\n\t\t\t\t\t\tendContainer = findParentContainer();\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Setup index for startContainer\n\t\t\tif (startContainer.nodeType == 1) {\n\t\t\t\tstartOffset = nodeIndex(startContainer);\n\t\t\t\tstartContainer = startContainer.parentNode;\n\t\t\t}\n\n\t\t\t// Setup index for endContainer\n\t\t\tif (endContainer.nodeType == 1) {\n\t\t\t\tendOffset = nodeIndex(endContainer) + 1;\n\t\t\t\tendContainer = endContainer.parentNode;\n\t\t\t}\n\n\t\t\t// Return new range like object\n\t\t\treturn {\n\t\t\t\tstartContainer : startContainer,\n\t\t\t\tstartOffset : startOffset,\n\t\t\t\tendContainer : endContainer,\n\t\t\t\tendOffset : endOffset\n\t\t\t};\n\t\t}\n\n\t\tfunction removeFormat(format, vars, node, compare_node) {\n\t\t\tvar i, attrs, stylesModified;\n\n\t\t\t// Check if node matches format\n\t\t\tif (!matchName(node, format))\n\t\t\t\treturn FALSE;\n\n\t\t\t// Should we compare with format attribs and styles\n\t\t\tif (format.remove != 'all') {\n\t\t\t\t// Remove styles\n\t\t\t\teach(format.styles, function(value, name) {\n\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\t// Indexed array\n\t\t\t\t\tif (typeof(name) === 'number') {\n\t\t\t\t\t\tname = value;\n\t\t\t\t\t\tcompare_node = 0;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!compare_node || isEq(getStyle(compare_node, name), value))\n\t\t\t\t\t\tdom.setStyle(node, name, '');\n\n\t\t\t\t\tstylesModified = 1;\n\t\t\t\t});\n\n\t\t\t\t// Remove style attribute if it's empty\n\t\t\t\tif (stylesModified && dom.getAttrib(node, 'style') == '') {\n\t\t\t\t\tnode.removeAttribute('style');\n\t\t\t\t\tnode.removeAttribute('data-mce-style');\n\t\t\t\t}\n\n\t\t\t\t// Remove attributes\n\t\t\t\teach(format.attributes, function(value, name) {\n\t\t\t\t\tvar valueOut;\n\n\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\t// Indexed array\n\t\t\t\t\tif (typeof(name) === 'number') {\n\t\t\t\t\t\tname = value;\n\t\t\t\t\t\tcompare_node = 0;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!compare_node || isEq(dom.getAttrib(compare_node, name), value)) {\n\t\t\t\t\t\t// Keep internal classes\n\t\t\t\t\t\tif (name == 'class') {\n\t\t\t\t\t\t\tvalue = dom.getAttrib(node, name);\n\t\t\t\t\t\t\tif (value) {\n\t\t\t\t\t\t\t\t// Build new class value where everything is removed except the internal prefixed classes\n\t\t\t\t\t\t\t\tvalueOut = '';\n\t\t\t\t\t\t\t\teach(value.split(/\\s+/), function(cls) {\n\t\t\t\t\t\t\t\t\tif (/mce\\w+/.test(cls))\n\t\t\t\t\t\t\t\t\t\tvalueOut += (valueOut ? ' ' : '') + cls;\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\t// We got some internal classes left\n\t\t\t\t\t\t\t\tif (valueOut) {\n\t\t\t\t\t\t\t\t\tdom.setAttrib(node, name, valueOut);\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// IE6 has a bug where the attribute doesn't get removed correctly\n\t\t\t\t\t\tif (name == \"class\")\n\t\t\t\t\t\t\tnode.removeAttribute('className');\n\n\t\t\t\t\t\t// Remove mce prefixed attributes\n\t\t\t\t\t\tif (MCE_ATTR_RE.test(name))\n\t\t\t\t\t\t\tnode.removeAttribute('data-mce-' + name);\n\n\t\t\t\t\t\tnode.removeAttribute(name);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// Remove classes\n\t\t\t\teach(format.classes, function(value) {\n\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\tif (!compare_node || dom.hasClass(compare_node, value))\n\t\t\t\t\t\tdom.removeClass(node, value);\n\t\t\t\t});\n\n\t\t\t\t// Check for non internal attributes\n\t\t\t\tattrs = dom.getAttribs(node);\n\t\t\t\tfor (i = 0; i < attrs.length; i++) {\n\t\t\t\t\tif (attrs[i].nodeName.indexOf('_') !== 0)\n\t\t\t\t\t\treturn FALSE;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Remove the inline child if it's empty for example <b> or <span>\n\t\t\tif (format.remove != 'none') {\n\t\t\t\tremoveNode(node, format);\n\t\t\t\treturn TRUE;\n\t\t\t}\n\t\t};\n\n\t\tfunction removeNode(node, format) {\n\t\t\tvar parentNode = node.parentNode, rootBlockElm;\n\n\t\t\tif (format.block) {\n\t\t\t\tif (!forcedRootBlock) {\n\t\t\t\t\tfunction find(node, next, inc) {\n\t\t\t\t\t\tnode = getNonWhiteSpaceSibling(node, next, inc);\n\n\t\t\t\t\t\treturn !node || (node.nodeName == 'BR' || isBlock(node));\n\t\t\t\t\t};\n\n\t\t\t\t\t// Append BR elements if needed before we remove the block\n\t\t\t\t\tif (isBlock(node) && !isBlock(parentNode)) {\n\t\t\t\t\t\tif (!find(node, FALSE) && !find(node.firstChild, TRUE, 1))\n\t\t\t\t\t\t\tnode.insertBefore(dom.create('br'), node.firstChild);\n\n\t\t\t\t\t\tif (!find(node, TRUE) && !find(node.lastChild, FALSE, 1))\n\t\t\t\t\t\t\tnode.appendChild(dom.create('br'));\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\t// Wrap the block in a forcedRootBlock if we are at the root of document\n\t\t\t\t\tif (parentNode == dom.getRoot()) {\n\t\t\t\t\t\tif (!format.list_block || !isEq(node, format.list_block)) {\n\t\t\t\t\t\t\teach(tinymce.grep(node.childNodes), function(node) {\n\t\t\t\t\t\t\t\tif (isValid(forcedRootBlock, node.nodeName.toLowerCase())) {\n\t\t\t\t\t\t\t\t\tif (!rootBlockElm)\n\t\t\t\t\t\t\t\t\t\trootBlockElm = wrap(node, forcedRootBlock);\n\t\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\t\trootBlockElm.appendChild(node);\n\t\t\t\t\t\t\t\t} else\n\t\t\t\t\t\t\t\t\trootBlockElm = 0;\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Never remove nodes that isn't the specified inline element if a selector is specified too\n\t\t\tif (format.selector && format.inline && !isEq(format.inline, node))\n\t\t\t\treturn;\n\n\t\t\tdom.remove(node, 1);\n\t\t};\n\n\t\tfunction getNonWhiteSpaceSibling(node, next, inc) {\n\t\t\tif (node) {\n\t\t\t\tnext = next ? 'nextSibling' : 'previousSibling';\n\n\t\t\t\tfor (node = inc ? node : node[next]; node; node = node[next]) {\n\t\t\t\t\tif (node.nodeType == 1 || !isWhiteSpaceNode(node))\n\t\t\t\t\t\treturn node;\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction isBookmarkNode(node) {\n\t\t\treturn node && node.nodeType == 1 && node.getAttribute('data-mce-type') == 'bookmark';\n\t\t};\n\n\t\tfunction mergeSiblings(prev, next) {\n\t\t\tvar marker, sibling, tmpSibling;\n\n\t\t\tfunction compareElements(node1, node2) {\n\t\t\t\t// Not the same name\n\t\t\t\tif (node1.nodeName != node2.nodeName)\n\t\t\t\t\treturn FALSE;\n\n\t\t\t\tfunction getAttribs(node) {\n\t\t\t\t\tvar attribs = {};\n\n\t\t\t\t\teach(dom.getAttribs(node), function(attr) {\n\t\t\t\t\t\tvar name = attr.nodeName.toLowerCase();\n\n\t\t\t\t\t\t// Don't compare internal attributes or style\n\t\t\t\t\t\tif (name.indexOf('_') !== 0 && name !== 'style')\n\t\t\t\t\t\t\tattribs[name] = dom.getAttrib(node, name);\n\t\t\t\t\t});\n\n\t\t\t\t\treturn attribs;\n\t\t\t\t};\n\n\t\t\t\tfunction compareObjects(obj1, obj2) {\n\t\t\t\t\tvar value, name;\n\n\t\t\t\t\tfor (name in obj1) {\n\t\t\t\t\t\t// Obj1 has item obj2 doesn't have\n\t\t\t\t\t\tif (obj1.hasOwnProperty(name)) {\n\t\t\t\t\t\t\tvalue = obj2[name];\n\n\t\t\t\t\t\t\t// Obj2 doesn't have obj1 item\n\t\t\t\t\t\t\tif (value === undefined)\n\t\t\t\t\t\t\t\treturn FALSE;\n\n\t\t\t\t\t\t\t// Obj2 item has a different value\n\t\t\t\t\t\t\tif (obj1[name] != value)\n\t\t\t\t\t\t\t\treturn FALSE;\n\n\t\t\t\t\t\t\t// Delete similar value\n\t\t\t\t\t\t\tdelete obj2[name];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Check if obj 2 has something obj 1 doesn't have\n\t\t\t\t\tfor (name in obj2) {\n\t\t\t\t\t\t// Obj2 has item obj1 doesn't have\n\t\t\t\t\t\tif (obj2.hasOwnProperty(name))\n\t\t\t\t\t\t\treturn FALSE;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn TRUE;\n\t\t\t\t};\n\n\t\t\t\t// Attribs are not the same\n\t\t\t\tif (!compareObjects(getAttribs(node1), getAttribs(node2)))\n\t\t\t\t\treturn FALSE;\n\n\t\t\t\t// Styles are not the same\n\t\t\t\tif (!compareObjects(dom.parseStyle(dom.getAttrib(node1, 'style')), dom.parseStyle(dom.getAttrib(node2, 'style'))))\n\t\t\t\t\treturn FALSE;\n\n\t\t\t\treturn TRUE;\n\t\t\t};\n\n\t\t\t// Check if next/prev exists and that they are elements\n\t\t\tif (prev && next) {\n\t\t\t\tfunction findElementSibling(node, sibling_name) {\n\t\t\t\t\tfor (sibling = node; sibling; sibling = sibling[sibling_name]) {\n\t\t\t\t\t\tif (sibling.nodeType == 3 && sibling.nodeValue.length !== 0)\n\t\t\t\t\t\t\treturn node;\n\n\t\t\t\t\t\tif (sibling.nodeType == 1 && !isBookmarkNode(sibling))\n\t\t\t\t\t\t\treturn sibling;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn node;\n\t\t\t\t};\n\n\t\t\t\t// If previous sibling is empty then jump over it\n\t\t\t\tprev = findElementSibling(prev, 'previousSibling');\n\t\t\t\tnext = findElementSibling(next, 'nextSibling');\n\n\t\t\t\t// Compare next and previous nodes\n\t\t\t\tif (compareElements(prev, next)) {\n\t\t\t\t\t// Append nodes between\n\t\t\t\t\tfor (sibling = prev.nextSibling; sibling && sibling != next;) {\n\t\t\t\t\t\ttmpSibling = sibling;\n\t\t\t\t\t\tsibling = sibling.nextSibling;\n\t\t\t\t\t\tprev.appendChild(tmpSibling);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove next node\n\t\t\t\t\tdom.remove(next);\n\n\t\t\t\t\t// Move children into prev node\n\t\t\t\t\teach(tinymce.grep(next.childNodes), function(node) {\n\t\t\t\t\t\tprev.appendChild(node);\n\t\t\t\t\t});\n\n\t\t\t\t\treturn prev;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn next;\n\t\t};\n\n\t\tfunction isTextBlock(name) {\n\t\t\treturn /^(h[1-6]|p|div|pre|address|dl|dt|dd)$/.test(name);\n\t\t};\n\n\t\tfunction getContainer(rng, start) {\n\t\t\tvar container, offset, lastIdx, walker;\n\n\t\t\tcontainer = rng[start ? 'startContainer' : 'endContainer'];\n\t\t\toffset = rng[start ? 'startOffset' : 'endOffset'];\n\n\t\t\tif (container.nodeType == 1) {\n\t\t\t\tlastIdx = container.childNodes.length - 1;\n\n\t\t\t\tif (!start && offset)\n\t\t\t\t\toffset--;\n\n\t\t\t\tcontainer = container.childNodes[offset > lastIdx ? lastIdx : offset];\n\t\t\t}\n\n\t\t\t// If start text node is excluded then walk to the next node\n\t\t\tif (container.nodeType === 3 && start && offset >= container.nodeValue.length) {\n\t\t\t\tcontainer = new TreeWalker(container, ed.getBody()).next() || container;\n\t\t\t}\n\n\t\t\t// If end text node is excluded then walk to the previous node\n\t\t\tif (container.nodeType === 3 && !start && offset == 0) {\n\t\t\t\tcontainer = new TreeWalker(container, ed.getBody()).prev() || container;\n\t\t\t}\n\n\t\t\treturn container;\n\t\t};\n\n\t\tfunction performCaretAction(type, name, vars) {\n\t\t\tvar invisibleChar, caretContainerId = '_mce_caret', debug = ed.settings.caret_debug;\n\n\t\t\t// Setup invisible character use zero width space on Gecko since it doesn't change the heigt of the container\n\t\t\tinvisibleChar = tinymce.isGecko ? '\\u200B' : INVISIBLE_CHAR;\n\n\t\t\t// Creates a caret container bogus element\n\t\t\tfunction createCaretContainer(fill) {\n\t\t\t\tvar caretContainer = dom.create('span', {id: caretContainerId, 'data-mce-bogus': true, style: debug ? 'color:red' : ''});\n\n\t\t\t\tif (fill) {\n\t\t\t\t\tcaretContainer.appendChild(ed.getDoc().createTextNode(invisibleChar));\n\t\t\t\t}\n\n\t\t\t\treturn caretContainer;\n\t\t\t};\n\n\t\t\tfunction isCaretContainerEmpty(node, nodes) {\n\t\t\t\twhile (node) {\n\t\t\t\t\tif ((node.nodeType === 3 && node.nodeValue !== invisibleChar) || node.childNodes.length > 1) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Collect nodes\n\t\t\t\t\tif (nodes && node.nodeType === 1) {\n\t\t\t\t\t\tnodes.push(node);\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = node.firstChild;\n\t\t\t\t}\n\n\t\t\t\treturn true;\n\t\t\t};\n\n\t\t\t// Returns any parent caret container element\n\t\t\tfunction getParentCaretContainer(node) {\n\t\t\t\twhile (node) {\n\t\t\t\t\tif (node.id === caretContainerId) {\n\t\t\t\t\t\treturn node;\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Finds the first text node in the specified node\n\t\t\tfunction findFirstTextNode(node) {\n\t\t\t\tvar walker;\n\n\t\t\t\tif (node) {\n\t\t\t\t\twalker = new TreeWalker(node, node);\n\n\t\t\t\t\tfor (node = walker.current(); node; node = walker.next()) {\n\t\t\t\t\t\tif (node.nodeType === 3) {\n\t\t\t\t\t\t\treturn node;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Removes the caret container for the specified node or all on the current document\n\t\t\tfunction removeCaretContainer(node, move_caret) {\n\t\t\t\tvar child, rng;\n\n\t\t\t\tif (!node) {\n\t\t\t\t\tnode = getParentCaretContainer(selection.getStart());\n\n\t\t\t\t\tif (!node) {\n\t\t\t\t\t\twhile (node = dom.get(caretContainerId)) {\n\t\t\t\t\t\t\tremoveCaretContainer(node, false);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\trng = selection.getRng(true);\n\n\t\t\t\t\tif (isCaretContainerEmpty(node)) {\n\t\t\t\t\t\tif (move_caret !== false) {\n\t\t\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\t\t\trng.setEndBefore(node);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tdom.remove(node);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tchild = findFirstTextNode(node);\n\t\t\t\t\t\tchild = child.deleteData(0, 1);\n\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t}\n\n\t\t\t\t\tselection.setRng(rng);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Applies formatting to the caret position\n\t\t\tfunction applyCaretFormat() {\n\t\t\t\tvar rng, caretContainer, textNode, offset, bookmark, container, text;\n\n\t\t\t\trng = selection.getRng(true);\n\t\t\t\toffset = rng.startOffset;\n\t\t\t\tcontainer = rng.startContainer;\n\t\t\t\ttext = container.nodeValue;\n\n\t\t\t\tcaretContainer = getParentCaretContainer(selection.getStart());\n\t\t\t\tif (caretContainer) {\n\t\t\t\t\ttextNode = findFirstTextNode(caretContainer);\n\t\t\t\t}\n\n\t\t\t\t// Expand to word is caret is in the middle of a text node and the char before/after is a alpha numeric character\n\t\t\t\tif (text && offset > 0 && offset < text.length && /\\w/.test(text.charAt(offset)) && /\\w/.test(text.charAt(offset - 1))) {\n\t\t\t\t\t// Get bookmark of caret position\n\t\t\t\t\tbookmark = selection.getBookmark();\n\n\t\t\t\t\t// Collapse bookmark range (WebKit)\n\t\t\t\t\trng.collapse(true);\n\n\t\t\t\t\t// Expand the range to the closest word and split it at those points\n\t\t\t\t\trng = expandRng(rng, get(name));\n\t\t\t\t\trng = rangeUtils.split(rng);\n\n\t\t\t\t\t// Apply the format to the range\n\t\t\t\t\tapply(name, vars, rng);\n\n\t\t\t\t\t// Move selection back to caret position\n\t\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t\t} else {\n\t\t\t\t\tif (!caretContainer || textNode.nodeValue !== invisibleChar) {\n\t\t\t\t\t\tcaretContainer = createCaretContainer(true);\n\t\t\t\t\t\ttextNode = caretContainer.firstChild;\n\n\t\t\t\t\t\trng.insertNode(caretContainer);\n\t\t\t\t\t\toffset = 1;\n\n\t\t\t\t\t\tapply(name, vars, caretContainer);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tapply(name, vars, caretContainer);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Move selection to text node\n\t\t\t\t\tselection.setCursorLocation(textNode, offset);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tfunction removeCaretFormat() {\n\t\t\t\tvar rng = selection.getRng(true), container, offset, bookmark,\n\t\t\t\t\thasContentAfter, node, formatNode, parents = [], i, caretContainer;\n\n\t\t\t\tcontainer = rng.startContainer;\n\t\t\t\toffset = rng.startOffset;\n\t\t\t\tnode = container;\n\n\t\t\t\tif (container.nodeType == 3) {\n\t\t\t\t\tif (offset != container.nodeValue.length || container.nodeValue === invisibleChar) {\n\t\t\t\t\t\thasContentAfter = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t}\n\n\t\t\t\twhile (node) {\n\t\t\t\t\tif (matchNode(node, name, vars)) {\n\t\t\t\t\t\tformatNode = node;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (node.nextSibling) {\n\t\t\t\t\t\thasContentAfter = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tparents.push(node);\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t}\n\n\t\t\t\t// Node doesn't have the specified format\n\t\t\t\tif (!formatNode) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Is there contents after the caret then remove the format on the element\n\t\t\t\tif (hasContentAfter) {\n\t\t\t\t\t// Get bookmark of caret position\n\t\t\t\t\tbookmark = selection.getBookmark();\n\n\t\t\t\t\t// Collapse bookmark range (WebKit)\n\t\t\t\t\trng.collapse(true);\n\n\t\t\t\t\t// Expand the range to the closest word and split it at those points\n\t\t\t\t\trng = expandRng(rng, get(name), true);\n\t\t\t\t\trng = rangeUtils.split(rng);\n\n\t\t\t\t\t// Remove the format from the range\n\t\t\t\t\tremove(name, vars, rng);\n\n\t\t\t\t\t// Move selection back to caret position\n\t\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t\t} else {\n\t\t\t\t\tcaretContainer = createCaretContainer();\n\n\t\t\t\t\tnode = caretContainer;\n\t\t\t\t\tfor (i = parents.length - 1; i >= 0; i--) {\n\t\t\t\t\t\tnode.appendChild(parents[i].cloneNode(false));\n\t\t\t\t\t\tnode = node.firstChild;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Insert invisible character into inner most format element\n\t\t\t\t\tnode.appendChild(dom.doc.createTextNode(invisibleChar));\n\t\t\t\t\tnode = node.firstChild;\n\n\t\t\t\t\t// Insert caret container after the formatted node\n\t\t\t\t\tdom.insertAfter(caretContainer, formatNode);\n\n\t\t\t\t\t// Move selection to text node\n\t\t\t\t\tselection.setCursorLocation(node, 1);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Mark current caret container elements as bogus when getting the contents so we don't end up with empty elements\n\t\t\ted.onBeforeGetContent.addToTop(function() {\n\t\t\t\tvar nodes = [], i;\n\n\t\t\t\tif (isCaretContainerEmpty(getParentCaretContainer(selection.getStart()), nodes)) {\n\t\t\t\t\t// Mark children\n\t\t\t\t\ti = nodes.length;\n\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\tdom.setAttrib(nodes[i], 'data-mce-bogus', '1');\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Remove caret container on mouse up and on key up\n\t\t\ttinymce.each('onMouseUp onKeyUp'.split(' '), function(name) {\n\t\t\t\ted[name].addToTop(function() {\n\t\t\t\t\tremoveCaretContainer();\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// Remove caret container on keydown and it's a backspace, enter or left/right arrow keys\n\t\t\ted.onKeyDown.addToTop(function(ed, e) {\n\t\t\t\tvar keyCode = e.keyCode;\n\n\t\t\t\tif (keyCode == 8 || keyCode == 37 || keyCode == 39) {\n\t\t\t\t\tremoveCaretContainer(getParentCaretContainer(selection.getStart()));\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Do apply or remove caret format\n\t\t\tif (type == \"apply\") {\n\t\t\t\tapplyCaretFormat();\n\t\t\t} else {\n\t\t\t\tremoveCaretFormat();\n\t\t\t}\n\t\t};\n\t};\n})(tinymce);\n\ntinymce.onAddEditor.add(function(tinymce, ed) {\n\tvar filters, fontSizes, dom, settings = ed.settings;\n\n\tif (settings.inline_styles) {\n\t\tfontSizes = tinymce.explode(settings.font_size_legacy_values);\n\n\t\tfunction replaceWithSpan(node, styles) {\n\t\t\ttinymce.each(styles, function(value, name) {\n\t\t\t\tif (value)\n\t\t\t\t\tdom.setStyle(node, name, value);\n\t\t\t});\n\n\t\t\tdom.rename(node, 'span');\n\t\t};\n\n\t\tfilters = {\n\t\t\tfont : function(dom, node) {\n\t\t\t\treplaceWithSpan(node, {\n\t\t\t\t\tbackgroundColor : node.style.backgroundColor,\n\t\t\t\t\tcolor : node.color,\n\t\t\t\t\tfontFamily : node.face,\n\t\t\t\t\tfontSize : fontSizes[parseInt(node.size) - 1]\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tu : function(dom, node) {\n\t\t\t\treplaceWithSpan(node, {\n\t\t\t\t\ttextDecoration : 'underline'\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tstrike : function(dom, node) {\n\t\t\t\treplaceWithSpan(node, {\n\t\t\t\t\ttextDecoration : 'line-through'\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\tfunction convert(editor, params) {\n\t\t\tdom = editor.dom;\n\n\t\t\tif (settings.convert_fonts_to_spans) {\n\t\t\t\ttinymce.each(dom.select('font,u,strike', params.node), function(node) {\n\t\t\t\t\tfilters[node.nodeName.toLowerCase()](ed.dom, node);\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\ted.onPreProcess.add(convert);\n\t\ted.onSetContent.add(convert);\n\n\t\ted.onInit.add(function() {\n\t\t\ted.selection.onSetContent.add(convert);\n\t\t});\n\t}\n});\n\n","Magento_Tinymce3/tiny_mce/jquery.tinymce.js":"(function(b){var e,d,a=[],c=window;b.fn.tinymce=function(j){var p=this,g,k,h,m,i,l=\"\",n=\"\";if(!p.length){return p}if(!j){return tinyMCE.get(p[0].id)}p.css(\"visibility\",\"hidden\");function o(){var r=[],q=0;if(f){f();f=null}p.each(function(t,u){var s,w=u.id,v=j.oninit;if(!w){u.id=w=tinymce.DOM.uniqueId()}s=new tinymce.Editor(w,j);r.push(s);s.onInit.add(function(){var x,y=v;p.css(\"visibility\",\"\");if(v){if(++q==r.length){if(tinymce.is(y,\"string\")){x=(y.indexOf(\".\")===-1)?null:tinymce.resolve(y.replace(/\\.\\w+$/,\"\"));y=tinymce.resolve(y)}y.apply(x||tinymce,r)}}})});b.each(r,function(t,s){s.render()})}if(!c.tinymce&&!d&&(g=j.script_url)){d=1;h=g.substring(0,g.lastIndexOf(\"/\"));if(/_(src|dev)\\.js/g.test(g)){n=\"_src\"}m=g.lastIndexOf(\"?\");if(m!=-1){l=g.substring(m+1)}c.tinyMCEPreInit=c.tinyMCEPreInit||{base:h,suffix:n,query:l};if(g.indexOf(\"gzip\")!=-1){i=j.language||\"en\";g=g+(/\\?/.test(g)?\"&\":\"?\")+\"js=true&core=true&suffix=\"+escape(n)+\"&themes=\"+escape(j.theme)+\"&plugins=\"+escape(j.plugins)+\"&languages=\"+i;if(!c.tinyMCE_GZ){tinyMCE_GZ={start:function(){tinymce.suffix=n;function q(r){tinymce.ScriptLoader.markDone(tinyMCE.baseURI.toAbsolute(r))}q(\"langs/\"+i+\".js\");q(\"themes/\"+j.theme+\"/editor_template\"+n+\".js\");q(\"themes/\"+j.theme+\"/langs/\"+i+\".js\");b.each(j.plugins.split(\",\"),function(s,r){if(r){q(\"plugins/\"+r+\"/editor_plugin\"+n+\".js\");q(\"plugins/\"+r+\"/langs/\"+i+\".js\")}})},end:function(){}}}}b.ajax({type:\"GET\",url:g,dataType:\"script\",cache:true,success:function(){tinymce.dom.Event.domLoaded=1;d=2;if(j.script_loaded){j.script_loaded()}o();b.each(a,function(q,r){r()})}})}else{if(d===1){a.push(o)}else{o()}}return p};b.extend(b.expr[\":\"],{tinymce:function(g){return g.id&&!!tinyMCE.get(g.id)}});function f(){function i(l){if(l===\"remove\"){this.each(function(n,o){var m=h(o);if(m){m.remove()}})}this.find(\"span.mceEditor,div.mceEditor\").each(function(n,o){var m=tinyMCE.get(o.id.replace(/_parent$/,\"\"));if(m){m.remove()}})}function k(n){var m=this,l;if(n!==e){i.call(m);m.each(function(p,q){var o;if(o=tinyMCE.get(q.id)){o.setContent(n)}})}else{if(m.length>0){if(l=tinyMCE.get(m[0].id)){return l.getContent()}}}}function h(m){var l=null;(m)&&(m.id)&&(c.tinymce)&&(l=tinyMCE.get(m.id));return l}function g(l){return !!((l)&&(l.length)&&(c.tinymce)&&(l.is(\":tinymce\")))}var j={};b.each([\"text\",\"html\",\"val\"],function(n,l){var o=j[l]=b.fn[l],m=(l===\"text\");b.fn[l]=function(s){var p=this;if(!g(p)){return o.apply(p,arguments)}if(s!==e){k.call(p.filter(\":tinymce\"),s);o.apply(p.not(\":tinymce\"),arguments);return p}else{var r=\"\";var q=arguments;(m?p:p.eq(0)).each(function(u,v){var t=h(v);r+=t?(m?t.getContent().replace(/<(?:\"[^\"]*\"|'[^']*'|[^'\">])*>/g,\"\"):t.getContent()):o.apply(b(v),q)});return r}}});b.each([\"append\",\"prepend\"],function(n,m){var o=j[m]=b.fn[m],l=(m===\"prepend\");b.fn[m]=function(q){var p=this;if(!g(p)){return o.apply(p,arguments)}if(q!==e){p.filter(\":tinymce\").each(function(s,t){var r=h(t);r&&r.setContent(l?q+r.getContent():r.getContent()+q)});o.apply(p.not(\":tinymce\"),arguments);return p}}});b.each([\"remove\",\"replaceWith\",\"replaceAll\",\"empty\"],function(m,l){var n=j[l]=b.fn[l];b.fn[l]=function(){i.call(this,l);return n.apply(this,arguments)}});j.attr=b.fn.attr;b.fn.attr=function(n,q,o){var m=this;if((!n)||(n!==\"value\")||(!g(m))){return j.attr.call(m,n,q,o)}if(q!==e){k.call(m.filter(\":tinymce\"),q);j.attr.call(m.not(\":tinymce\"),n,q,o);return m}else{var p=m[0],l=h(p);return l?l.getContent():j.attr.call(b(p),n,q,o)}}}})(jQuery);","Magento_Tinymce3/tiny_mce/tiny_mce_popup.js":"\n// Uncomment and change this document.domain value if you are loading the script cross subdomains\n// document.domain = 'moxiecode.com';\n\nvar tinymce=null,tinyMCEPopup,tinyMCE;tinyMCEPopup={init:function(){var b=this,a,c;a=b.getWin();tinymce=a.tinymce;tinyMCE=a.tinyMCE;b.editor=tinymce.EditorManager.activeEditor;b.params=b.editor.windowManager.params;b.features=b.editor.windowManager.features;b.dom=b.editor.windowManager.createInstance(\"tinymce.dom.DOMUtils\",document);if(b.features.popup_css!==false){b.dom.loadCSS(b.features.popup_css||b.editor.settings.popup_css)}b.listeners=[];b.onInit={add:function(e,d){b.listeners.push({func:e,scope:d})}};b.isWindow=!b.getWindowArg(\"mce_inline\");b.id=b.getWindowArg(\"mce_window_id\");b.editor.windowManager.onOpen.dispatch(b.editor.windowManager,window)},getWin:function(){return(!window.frameElement&&window.dialogArguments)||opener||parent||top},getWindowArg:function(c,b){var a=this.params[c];return tinymce.is(a)?a:b},getParam:function(b,a){return this.editor.getParam(b,a)},getLang:function(b,a){return this.editor.getLang(b,a)},execCommand:function(d,c,e,b){b=b||{};b.skip_focus=1;this.restoreSelection();return this.editor.execCommand(d,c,e,b)},resizeToInnerSize:function(){var a=this;setTimeout(function(){var b=a.dom.getViewPort(window);a.editor.windowManager.resizeBy(a.getWindowArg(\"mce_width\")-b.w,a.getWindowArg(\"mce_height\")-b.h,a.id||window)},10)},executeOnLoad:function(s){this.onInit.add(function(){eval(s)})},storeSelection:function(){this.editor.windowManager.bookmark=tinyMCEPopup.editor.selection.getBookmark(1)},restoreSelection:function(){var a=tinyMCEPopup;if(!a.isWindow&&tinymce.isIE){a.editor.selection.moveToBookmark(a.editor.windowManager.bookmark)}},requireLangPack:function(){var b=this,a=b.getWindowArg(\"plugin_url\")||b.getWindowArg(\"theme_url\");if(a&&b.editor.settings.language&&b.features.translate_i18n!==false&&b.editor.settings.language_load!==false){a+=\"/langs/\"+b.editor.settings.language+\"_dlg.js\";if(!tinymce.ScriptLoader.isDone(a)){document.write('<script type=\"text/javascript\" src=\"'+tinymce._addVer(a)+'\"><\\/script>');tinymce.ScriptLoader.markDone(a)}}},pickColor:function(b,a){this.execCommand(\"mceColorPicker\",true,{color:document.getElementById(a).value,func:function(e){document.getElementById(a).value=e;try{document.getElementById(a).onchange()}catch(d){}}})},openBrowser:function(a,c,b){tinyMCEPopup.restoreSelection();this.editor.execCallback(\"file_browser_callback\",a,document.getElementById(a).value,c,window)},confirm:function(b,a,c){this.editor.windowManager.confirm(b,a,c,window)},alert:function(b,a,c){this.editor.windowManager.alert(b,a,c,window)},close:function(){var a=this;function b(){a.editor.windowManager.close(window);tinymce=tinyMCE=a.editor=a.params=a.dom=a.dom.doc=null}if(tinymce.isOpera){a.getWin().setTimeout(b,0)}else{b()}},_restoreSelection:function(){var a=window.event.srcElement;if(a.nodeName==\"INPUT\"&&(a.type==\"submit\"||a.type==\"button\")){tinyMCEPopup.restoreSelection()}},_onDOMLoaded:function(){var b=tinyMCEPopup,d=document.title,e,c,a;if(b.domLoaded){return}b.domLoaded=1;if(b.features.translate_i18n!==false){c=document.body.innerHTML;if(tinymce.isIE){c=c.replace(/ (value|title|alt)=([^\"][^\\s>]+)/gi,' $1=\"$2\"')}document.dir=b.editor.getParam(\"directionality\",\"\");if((a=b.editor.translate(c))&&a!=c){document.body.innerHTML=a}if((a=b.editor.translate(d))&&a!=d){document.title=d=a}}if(!b.editor.getParam(\"browser_preferred_colors\",false)||!b.isWindow){b.dom.addClass(document.body,\"forceColors\")}document.body.style.display=\"\";if(tinymce.isIE){document.attachEvent(\"onmouseup\",tinyMCEPopup._restoreSelection);b.dom.add(b.dom.select(\"head\")[0],\"base\",{target:\"_self\"})}b.restoreSelection();b.resizeToInnerSize();if(!b.isWindow){b.editor.windowManager.setTitle(window,d)}else{window.focus()}if(!tinymce.isIE&&!b.isWindow){tinymce.dom.Event._add(document,\"focus\",function(){b.editor.windowManager.focus(b.id)})}tinymce.each(b.dom.select(\"select\"),function(f){f.onkeydown=tinyMCEPopup._accessHandler});tinymce.each(b.listeners,function(f){f.func.call(f.scope,b.editor)});if(b.getWindowArg(\"mce_auto_focus\",true)){window.focus();tinymce.each(document.forms,function(g){tinymce.each(g.elements,function(f){if(b.dom.hasClass(f,\"mceFocus\")&&!f.disabled){f.focus();return false}})})}document.onkeyup=tinyMCEPopup._closeWinKeyHandler},_accessHandler:function(a){a=a||window.event;if(a.keyCode==13||a.keyCode==32){a=a.target||a.srcElement;if(a.onchange){a.onchange()}return tinymce.dom.Event.cancel(a)}},_closeWinKeyHandler:function(a){a=a||window.event;if(a.keyCode==27){tinyMCEPopup.close()}},_wait:function(){if(document.attachEvent){document.attachEvent(\"onreadystatechange\",function(){if(document.readyState===\"complete\"){document.detachEvent(\"onreadystatechange\",arguments.callee);tinyMCEPopup._onDOMLoaded()}});if(document.documentElement.doScroll&&window==window.top){(function(){if(tinyMCEPopup.domLoaded){return}try{document.documentElement.doScroll(\"left\")}catch(a){setTimeout(arguments.callee,0);return}tinyMCEPopup._onDOMLoaded()})()}document.attachEvent(\"onload\",tinyMCEPopup._onDOMLoaded)}else{if(document.addEventListener){window.addEventListener(\"DOMContentLoaded\",tinyMCEPopup._onDOMLoaded,false);window.addEventListener(\"load\",tinyMCEPopup._onDOMLoaded,false)}}}};tinyMCEPopup.init();tinyMCEPopup._wait();","Magento_Tinymce3/tiny_mce/themes/advanced/editor_template_src.js":"/**\n * editor_template_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, extend = tinymce.extend, each = tinymce.each, Cookie = tinymce.util.Cookie, lastExtID, explode = tinymce.explode;\n\n\t// Tell it to load theme specific language pack(s)\n\ttinymce.ThemeManager.requireLangPack('advanced');\n\n\ttinymce.create('tinymce.themes.AdvancedTheme', {\n\t\tsizes : [8, 10, 12, 14, 18, 24, 36],\n\n\t\t// Control name lookup, format: title, command\n\t\tcontrols : {\n\t\t\tbold : ['bold_desc', 'Bold'],\n\t\t\titalic : ['italic_desc', 'Italic'],\n\t\t\tunderline : ['underline_desc', 'Underline'],\n\t\t\tstrikethrough : ['striketrough_desc', 'Strikethrough'],\n\t\t\tjustifyleft : ['justifyleft_desc', 'JustifyLeft'],\n\t\t\tjustifycenter : ['justifycenter_desc', 'JustifyCenter'],\n\t\t\tjustifyright : ['justifyright_desc', 'JustifyRight'],\n\t\t\tjustifyfull : ['justifyfull_desc', 'JustifyFull'],\n\t\t\tbullist : ['bullist_desc', 'InsertUnorderedList'],\n\t\t\tnumlist : ['numlist_desc', 'InsertOrderedList'],\n\t\t\toutdent : ['outdent_desc', 'Outdent'],\n\t\t\tindent : ['indent_desc', 'Indent'],\n\t\t\tcut : ['cut_desc', 'Cut'],\n\t\t\tcopy : ['copy_desc', 'Copy'],\n\t\t\tpaste : ['paste_desc', 'Paste'],\n\t\t\tundo : ['undo_desc', 'Undo'],\n\t\t\tredo : ['redo_desc', 'Redo'],\n\t\t\tlink : ['link_desc', 'mceLink'],\n\t\t\tunlink : ['unlink_desc', 'unlink'],\n\t\t\timage : ['image_desc', 'mceImage'],\n\t\t\tcleanup : ['cleanup_desc', 'mceCleanup'],\n\t\t\thelp : ['help_desc', 'mceHelp'],\n\t\t\tcode : ['code_desc', 'mceCodeEditor'],\n\t\t\thr : ['hr_desc', 'InsertHorizontalRule'],\n\t\t\tremoveformat : ['removeformat_desc', 'RemoveFormat'],\n\t\t\tsub : ['sub_desc', 'subscript'],\n\t\t\tsup : ['sup_desc', 'superscript'],\n\t\t\tforecolor : ['forecolor_desc', 'ForeColor'],\n\t\t\tforecolorpicker : ['forecolor_desc', 'mceForeColor'],\n\t\t\tbackcolor : ['backcolor_desc', 'HiliteColor'],\n\t\t\tbackcolorpicker : ['backcolor_desc', 'mceBackColor'],\n\t\t\tcharmap : ['charmap_desc', 'mceCharMap'],\n\t\t\tvisualaid : ['visualaid_desc', 'mceToggleVisualAid'],\n\t\t\tanchor : ['anchor_desc', 'mceInsertAnchor'],\n\t\t\tnewdocument : ['newdocument_desc', 'mceNewDocument'],\n\t\t\tblockquote : ['blockquote_desc', 'mceBlockQuote']\n\t\t},\n\n\t\tstateControls : ['bold', 'italic', 'underline', 'strikethrough', 'bullist', 'numlist', 'justifyleft', 'justifycenter', 'justifyright', 'justifyfull', 'sub', 'sup', 'blockquote'],\n\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this, s, v, o;\n\t\n\t\t\tt.editor = ed;\n\t\t\tt.url = url;\n\t\t\tt.onResolveName = new tinymce.util.Dispatcher(this);\n\n\t\t\ted.forcedHighContrastMode = ed.settings.detect_highcontrast && t._isHighContrast();\n\t\t\ted.settings.skin = ed.forcedHighContrastMode ? 'highcontrast' : ed.settings.skin;\n\n\t\t\t// Default settings\n\t\t\tt.settings = s = extend({\n\t\t\t\ttheme_advanced_path : true,\n\t\t\t\ttheme_advanced_toolbar_location : 'bottom',\n\t\t\t\ttheme_advanced_buttons1 : \"bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,styleselect,formatselect\",\n\t\t\t\ttheme_advanced_buttons2 : \"bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code\",\n\t\t\t\ttheme_advanced_buttons3 : \"hr,removeformat,visualaid,|,sub,sup,|,charmap\",\n\t\t\t\ttheme_advanced_blockformats : \"p,address,pre,h1,h2,h3,h4,h5,h6\",\n\t\t\t\ttheme_advanced_toolbar_align : \"center\",\n\t\t\t\ttheme_advanced_fonts : \"Andale Mono=andale mono,times;Arial=arial,helvetica,sans-serif;Arial Black=arial black,avant garde;Book Antiqua=book antiqua,palatino;Comic Sans MS=comic sans ms,sans-serif;Courier New=courier new,courier;Georgia=georgia,palatino;Helvetica=helvetica;Impact=impact,chicago;Symbol=symbol;Tahoma=tahoma,arial,helvetica,sans-serif;Terminal=terminal,monaco;Times New Roman=times new roman,times;Trebuchet MS=trebuchet ms,geneva;Verdana=verdana,geneva;Webdings=webdings;Wingdings=wingdings,zapf dingbats\",\n\t\t\t\ttheme_advanced_more_colors : 1,\n\t\t\t\ttheme_advanced_row_height : 23,\n\t\t\t\ttheme_advanced_resize_horizontal : 1,\n\t\t\t\ttheme_advanced_resizing_use_cookie : 1,\n\t\t\t\ttheme_advanced_font_sizes : \"1,2,3,4,5,6,7\",\n\t\t\t\ttheme_advanced_font_selector : \"span\",\n\t\t\t\ttheme_advanced_show_current_color: 0,\n\t\t\t\treadonly : ed.settings.readonly\n\t\t\t}, ed.settings);\n\n\t\t\t// Setup default font_size_style_values\n\t\t\tif (!s.font_size_style_values)\n\t\t\t\ts.font_size_style_values = \"8pt,10pt,12pt,14pt,18pt,24pt,36pt\";\n\n\t\t\tif (tinymce.is(s.theme_advanced_font_sizes, 'string')) {\n\t\t\t\ts.font_size_style_values = tinymce.explode(s.font_size_style_values);\n\t\t\t\ts.font_size_classes = tinymce.explode(s.font_size_classes || '');\n\n\t\t\t\t// Parse string value\n\t\t\t\to = {};\n\t\t\t\ted.settings.theme_advanced_font_sizes = s.theme_advanced_font_sizes;\n\t\t\t\teach(ed.getParam('theme_advanced_font_sizes', '', 'hash'), function(v, k) {\n\t\t\t\t\tvar cl;\n\n\t\t\t\t\tif (k == v && v >= 1 && v <= 7) {\n\t\t\t\t\t\tk = v + ' (' + t.sizes[v - 1] + 'pt)';\n\t\t\t\t\t\tcl = s.font_size_classes[v - 1];\n\t\t\t\t\t\tv = s.font_size_style_values[v - 1] || (t.sizes[v - 1] + 'pt');\n\t\t\t\t\t}\n\n\t\t\t\t\tif (/^\\s*\\./.test(v))\n\t\t\t\t\t\tcl = v.replace(/\\./g, '');\n\n\t\t\t\t\to[k] = cl ? {'class' : cl} : {fontSize : v};\n\t\t\t\t});\n\n\t\t\t\ts.theme_advanced_font_sizes = o;\n\t\t\t}\n\n\t\t\tif ((v = s.theme_advanced_path_location) && v != 'none')\n\t\t\t\ts.theme_advanced_statusbar_location = s.theme_advanced_path_location;\n\n\t\t\tif (s.theme_advanced_statusbar_location == 'none')\n\t\t\t\ts.theme_advanced_statusbar_location = 0;\n\n\t\t\tif (ed.settings.content_css !== false)\n\t\t\t\ted.contentCSS.push(ed.baseURI.toAbsolute(url + \"/skins/\" + ed.settings.skin + \"/content.css\"));\n\n\t\t\t// Init editor\n\t\t\ted.onInit.add(function() {\n\t\t\t\tif (!ed.settings.readonly) {\n\t\t\t\t\ted.onNodeChange.add(t._nodeChanged, t);\n\t\t\t\t\ted.onKeyUp.add(t._updateUndoStatus, t);\n\t\t\t\t\ted.onMouseUp.add(t._updateUndoStatus, t);\n\t\t\t\t\ted.dom.bind(ed.dom.getRoot(), 'dragend', function() {\n\t\t\t\t\t\tt._updateUndoStatus(ed);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t});\n\n\t\t\ted.onSetProgressState.add(function(ed, b, ti) {\n\t\t\t\tvar co, id = ed.id, tb;\n\n\t\t\t\tif (b) {\n\t\t\t\t\tt.progressTimer = setTimeout(function() {\n\t\t\t\t\t\tco = ed.getContainer();\n\t\t\t\t\t\tco = co.insertBefore(DOM.create('DIV', {style : 'position:relative'}), co.firstChild);\n\t\t\t\t\t\ttb = DOM.get(ed.id + '_tbl');\n\n\t\t\t\t\t\tDOM.add(co, 'div', {id : id + '_blocker', 'class' : 'mceBlocker', style : {width : tb.clientWidth + 2, height : tb.clientHeight + 2}});\n\t\t\t\t\t\tDOM.add(co, 'div', {id : id + '_progress', 'class' : 'mceProgress', style : {left : tb.clientWidth / 2, top : tb.clientHeight / 2}});\n\t\t\t\t\t}, ti || 0);\n\t\t\t\t} else {\n\t\t\t\t\tDOM.remove(id + '_blocker');\n\t\t\t\t\tDOM.remove(id + '_progress');\n\t\t\t\t\tclearTimeout(t.progressTimer);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tDOM.loadCSS(s.editor_css ? ed.documentBaseURI.toAbsolute(s.editor_css) : url + \"/skins/\" + ed.settings.skin + \"/ui.css\");\n\n\t\t\tif (s.skin_variant)\n\t\t\t\tDOM.loadCSS(url + \"/skins/\" + ed.settings.skin + \"/ui_\" + s.skin_variant + \".css\");\n\t\t},\n\n\t\t_isHighContrast : function() {\n\t\t\tvar actualColor, div = DOM.add(DOM.getRoot(), 'div', {'style': 'background-color: rgb(171,239,86);'});\n\n\t\t\tactualColor = (DOM.getStyle(div, 'background-color', true) + '').toLowerCase().replace(/ /g, '');\n\t\t\tDOM.remove(div);\n\n\t\t\treturn actualColor != 'rgb(171,239,86)' && actualColor != '#abef56';\n\t\t},\n\n\t\tcreateControl : function(n, cf) {\n\t\t\tvar cd, c;\n\n\t\t\tif (c = cf.createControl(n))\n\t\t\t\treturn c;\n\n\t\t\tswitch (n) {\n\t\t\t\tcase \"styleselect\":\n\t\t\t\t\treturn this._createStyleSelect();\n\n\t\t\t\tcase \"formatselect\":\n\t\t\t\t\treturn this._createBlockFormats();\n\n\t\t\t\tcase \"fontselect\":\n\t\t\t\t\treturn this._createFontSelect();\n\n\t\t\t\tcase \"fontsizeselect\":\n\t\t\t\t\treturn this._createFontSizeSelect();\n\n\t\t\t\tcase \"forecolor\":\n\t\t\t\t\treturn this._createForeColorMenu();\n\n\t\t\t\tcase \"backcolor\":\n\t\t\t\t\treturn this._createBackColorMenu();\n\t\t\t}\n\n\t\t\tif ((cd = this.controls[n]))\n\t\t\t\treturn cf.createButton(n, {title : \"advanced.\" + cd[0], cmd : cd[1], ui : cd[2], value : cd[3]});\n\t\t},\n\n\t\texecCommand : function(cmd, ui, val) {\n\t\t\tvar f = this['_' + cmd];\n\n\t\t\tif (f) {\n\t\t\t\tf.call(this, ui, val);\n\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\treturn false;\n\t\t},\n\n\t\t_importClasses : function(e) {\n\t\t\tvar ed = this.editor, ctrl = ed.controlManager.get('styleselect');\n\n\t\t\tif (ctrl.getLength() == 0) {\n\t\t\t\teach(ed.dom.getClasses(), function(o, idx) {\n\t\t\t\t\tvar name = 'style_' + idx;\n\n\t\t\t\t\ted.formatter.register(name, {\n\t\t\t\t\t\tinline : 'span',\n\t\t\t\t\t\tattributes : {'class' : o['class']},\n\t\t\t\t\t\tselector : '*'\n\t\t\t\t\t});\n\n\t\t\t\t\tctrl.add(o['class'], name);\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\t_createStyleSelect : function(n) {\n\t\t\tvar t = this, ed = t.editor, ctrlMan = ed.controlManager, ctrl;\n\n\t\t\t// Setup style select box\n\t\t\tctrl = ctrlMan.createListBox('styleselect', {\n\t\t\t\ttitle : 'advanced.style_select',\n\t\t\t\tonselect : function(name) {\n\t\t\t\t\tvar matches, formatNames = [];\n\n\t\t\t\t\teach(ctrl.items, function(item) {\n\t\t\t\t\t\tformatNames.push(item.value);\n\t\t\t\t\t});\n\n\t\t\t\t\ted.focus();\n\t\t\t\t\ted.undoManager.add();\n\n\t\t\t\t\t// Toggle off the current format\n\t\t\t\t\tmatches = ed.formatter.matchAll(formatNames);\n\t\t\t\t\tif (!name || matches[0] == name) {\n\t\t\t\t\t\tif (matches[0]) \n\t\t\t\t\t\t\ted.formatter.remove(matches[0]);\n\t\t\t\t\t} else\n\t\t\t\t\t\ted.formatter.apply(name);\n\n\t\t\t\t\ted.undoManager.add();\n\t\t\t\t\ted.nodeChanged();\n\n\t\t\t\t\treturn false; // No auto select\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Handle specified format\n\t\t\ted.onInit.add(function() {\n\t\t\t\tvar counter = 0, formats = ed.getParam('style_formats');\n\n\t\t\t\tif (formats) {\n\t\t\t\t\teach(formats, function(fmt) {\n\t\t\t\t\t\tvar name, keys = 0;\n\n\t\t\t\t\t\teach(fmt, function() {keys++;});\n\n\t\t\t\t\t\tif (keys > 1) {\n\t\t\t\t\t\t\tname = fmt.name = fmt.name || 'style_' + (counter++);\n\t\t\t\t\t\t\ted.formatter.register(name, fmt);\n\t\t\t\t\t\t\tctrl.add(fmt.title, name);\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\tctrl.add(fmt.title);\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\teach(ed.getParam('theme_advanced_styles', '', 'hash'), function(val, key) {\n\t\t\t\t\t\tvar name;\n\n\t\t\t\t\t\tif (val) {\n\t\t\t\t\t\t\tname = 'style_' + (counter++);\n\n\t\t\t\t\t\t\ted.formatter.register(name, {\n\t\t\t\t\t\t\t\tinline : 'span',\n\t\t\t\t\t\t\t\tclasses : val,\n\t\t\t\t\t\t\t\tselector : '*'\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\tctrl.add(t.editor.translate(key), name);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Auto import classes if the ctrl box is empty\n\t\t\tif (ctrl.getLength() == 0) {\n\t\t\t\tctrl.onPostRender.add(function(ed, n) {\n\t\t\t\t\tif (!ctrl.NativeListBox) {\n\t\t\t\t\t\tEvent.add(n.id + '_text', 'focus', t._importClasses, t);\n\t\t\t\t\t\tEvent.add(n.id + '_text', 'mousedown', t._importClasses, t);\n\t\t\t\t\t\tEvent.add(n.id + '_open', 'focus', t._importClasses, t);\n\t\t\t\t\t\tEvent.add(n.id + '_open', 'mousedown', t._importClasses, t);\n\t\t\t\t\t} else\n\t\t\t\t\t\tEvent.add(n.id, 'focus', t._importClasses, t);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn ctrl;\n\t\t},\n\n\t\t_createFontSelect : function() {\n\t\t\tvar c, t = this, ed = t.editor;\n\n\t\t\tc = ed.controlManager.createListBox('fontselect', {\n\t\t\t\ttitle : 'advanced.fontdefault',\n\t\t\t\tonselect : function(v) {\n\t\t\t\t\tvar cur = c.items[c.selectedIndex];\n\n\t\t\t\t\tif (!v && cur) {\n\t\t\t\t\t\ted.execCommand('FontName', false, cur.value);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\ted.execCommand('FontName', false, v);\n\n\t\t\t\t\t// Fake selection, execCommand will fire a nodeChange and update the selection\n\t\t\t\t\tc.select(function(sv) {\n\t\t\t\t\t\treturn v == sv;\n\t\t\t\t\t});\n\n\t\t\t\t\tif (cur && cur.value == v) {\n\t\t\t\t\t\tc.select(null);\n\t\t\t\t\t}\n\n\t\t\t\t\treturn false; // No auto select\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tif (c) {\n\t\t\t\teach(ed.getParam('theme_advanced_fonts', t.settings.theme_advanced_fonts, 'hash'), function(v, k) {\n\t\t\t\t\tc.add(ed.translate(k), v, {style : v.indexOf('dings') == -1 ? 'font-family:' + v : ''});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn c;\n\t\t},\n\n\t\t_createFontSizeSelect : function() {\n\t\t\tvar t = this, ed = t.editor, c, i = 0, cl = [];\n\n\t\t\tc = ed.controlManager.createListBox('fontsizeselect', {title : 'advanced.font_size', onselect : function(v) {\n\t\t\t\tvar cur = c.items[c.selectedIndex];\n\n\t\t\t\tif (!v && cur) {\n\t\t\t\t\tcur = cur.value;\n\n\t\t\t\t\tif (cur['class']) {\n\t\t\t\t\t\ted.formatter.toggle('fontsize_class', {value : cur['class']});\n\t\t\t\t\t\ted.undoManager.add();\n\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t} else {\n\t\t\t\t\t\ted.execCommand('FontSize', false, cur.fontSize);\n\t\t\t\t\t}\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (v['class']) {\n\t\t\t\t\ted.focus();\n\t\t\t\t\ted.undoManager.add();\n\t\t\t\t\ted.formatter.toggle('fontsize_class', {value : v['class']});\n\t\t\t\t\ted.undoManager.add();\n\t\t\t\t\ted.nodeChanged();\n\t\t\t\t} else\n\t\t\t\t\ted.execCommand('FontSize', false, v.fontSize);\n\n\t\t\t\t// Fake selection, execCommand will fire a nodeChange and update the selection\n\t\t\t\tc.select(function(sv) {\n\t\t\t\t\treturn v == sv;\n\t\t\t\t});\n\n\t\t\t\tif (cur && (cur.value.fontSize == v.fontSize || cur.value['class'] == v['class'])) {\n\t\t\t\t\tc.select(null);\n\t\t\t\t}\n\n\t\t\t\treturn false; // No auto select\n\t\t\t}});\n\n\t\t\tif (c) {\n\t\t\t\teach(t.settings.theme_advanced_font_sizes, function(v, k) {\n\t\t\t\t\tvar fz = v.fontSize;\n\n\t\t\t\t\tif (fz >= 1 && fz <= 7)\n\t\t\t\t\t\tfz = t.sizes[parseInt(fz) - 1] + 'pt';\n\n\t\t\t\t\tc.add(k, v, {'style' : 'font-size:' + fz, 'class' : 'mceFontSize' + (i++) + (' ' + (v['class'] || ''))});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn c;\n\t\t},\n\n\t\t_createBlockFormats : function() {\n\t\t\tvar c, fmts = {\n\t\t\t\tp : 'advanced.paragraph',\n\t\t\t\taddress : 'advanced.address',\n\t\t\t\tpre : 'advanced.pre',\n\t\t\t\th1 : 'advanced.h1',\n\t\t\t\th2 : 'advanced.h2',\n\t\t\t\th3 : 'advanced.h3',\n\t\t\t\th4 : 'advanced.h4',\n\t\t\t\th5 : 'advanced.h5',\n\t\t\t\th6 : 'advanced.h6',\n\t\t\t\tdiv : 'advanced.div',\n\t\t\t\tblockquote : 'advanced.blockquote',\n\t\t\t\tcode : 'advanced.code',\n\t\t\t\tdt : 'advanced.dt',\n\t\t\t\tdd : 'advanced.dd',\n\t\t\t\tsamp : 'advanced.samp'\n\t\t\t}, t = this;\n\n\t\t\tc = t.editor.controlManager.createListBox('formatselect', {title : 'advanced.block', onselect : function(v) {\n\t\t\t\tt.editor.execCommand('FormatBlock', false, v);\n\t\t\t\treturn false;\n\t\t\t}});\n\n\t\t\tif (c) {\n\t\t\t\teach(t.editor.getParam('theme_advanced_blockformats', t.settings.theme_advanced_blockformats, 'hash'), function(v, k) {\n\t\t\t\t\tc.add(t.editor.translate(k != v ? k : fmts[v]), v, {'class' : 'mce_formatPreview mce_' + v});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn c;\n\t\t},\n\n\t\t_createForeColorMenu : function() {\n\t\t\tvar c, t = this, s = t.settings, o = {}, v;\n\n\t\t\tif (s.theme_advanced_more_colors) {\n\t\t\t\to.more_colors_func = function() {\n\t\t\t\t\tt._mceColorPicker(0, {\n\t\t\t\t\t\tcolor : c.value,\n\t\t\t\t\t\tfunc : function(co) {\n\t\t\t\t\t\t\tc.setColor(co);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (v = s.theme_advanced_text_colors)\n\t\t\t\to.colors = v;\n\n\t\t\tif (s.theme_advanced_default_foreground_color)\n\t\t\t\to.default_color = s.theme_advanced_default_foreground_color;\n\n\t\t\to.title = 'advanced.forecolor_desc';\n\t\t\to.cmd = 'ForeColor';\n\t\t\to.scope = this;\n\n\t\t\tc = t.editor.controlManager.createColorSplitButton('forecolor', o);\n\n\t\t\treturn c;\n\t\t},\n\n\t\t_createBackColorMenu : function() {\n\t\t\tvar c, t = this, s = t.settings, o = {}, v;\n\n\t\t\tif (s.theme_advanced_more_colors) {\n\t\t\t\to.more_colors_func = function() {\n\t\t\t\t\tt._mceColorPicker(0, {\n\t\t\t\t\t\tcolor : c.value,\n\t\t\t\t\t\tfunc : function(co) {\n\t\t\t\t\t\t\tc.setColor(co);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (v = s.theme_advanced_background_colors)\n\t\t\t\to.colors = v;\n\n\t\t\tif (s.theme_advanced_default_background_color)\n\t\t\t\to.default_color = s.theme_advanced_default_background_color;\n\n\t\t\to.title = 'advanced.backcolor_desc';\n\t\t\to.cmd = 'HiliteColor';\n\t\t\to.scope = this;\n\n\t\t\tc = t.editor.controlManager.createColorSplitButton('backcolor', o);\n\n\t\t\treturn c;\n\t\t},\n\n\t\trenderUI : function(o) {\n\t\t\tvar n, ic, tb, t = this, ed = t.editor, s = t.settings, sc, p, nl;\n\n\t\t\tif (ed.settings) {\n\t\t\t\ted.settings.aria_label = s.aria_label + ed.getLang('advanced.help_shortcut');\n\t\t\t}\n\n\t\t\t// TODO: ACC Should have an aria-describedby attribute which is user-configurable to describe what this field is actually for.\n\t\t\t// Maybe actually inherit it from the original textara?\n\t\t\tn = p = DOM.create('span', {role : 'application', 'aria-labelledby' : ed.id + '_voice', id : ed.id + '_parent', 'class' : 'mceEditor ' + ed.settings.skin + 'Skin' + (s.skin_variant ? ' ' + ed.settings.skin + 'Skin' + t._ufirst(s.skin_variant) : '')});\n\t\t\tDOM.add(n, 'span', {'class': 'mceVoiceLabel', 'style': 'display:none;', id: ed.id + '_voice'}, s.aria_label);\n\n\t\t\tif (!DOM.boxModel)\n\t\t\t\tn = DOM.add(n, 'div', {'class' : 'mceOldBoxModel'});\n\n\t\t\tn = sc = DOM.add(n, 'table', {role : \"presentation\", id : ed.id + '_tbl', 'class' : 'mceLayout', cellSpacing : 0, cellPadding : 0});\n\t\t\tn = tb = DOM.add(n, 'tbody');\n\n\t\t\tswitch ((s.theme_advanced_layout_manager || '').toLowerCase()) {\n\t\t\t\tcase \"rowlayout\":\n\t\t\t\t\tic = t._rowLayout(s, tb, o);\n\t\t\t\t\tbreak;\n\n\t\t\t\tcase \"customlayout\":\n\t\t\t\t\tic = ed.execCallback(\"theme_advanced_custom_layout\", s, tb, o, p);\n\t\t\t\t\tbreak;\n\n\t\t\t\tdefault:\n\t\t\t\t\tic = t._simpleLayout(s, tb, o, p);\n\t\t\t}\n\n\t\t\tn = o.targetNode;\n\n\t\t\t// Add classes to first and last TRs\n\t\t\tnl = sc.rows;\n\t\t\tDOM.addClass(nl[0], 'mceFirst');\n\t\t\tDOM.addClass(nl[nl.length - 1], 'mceLast');\n\n\t\t\t// Add classes to first and last TDs\n\t\t\teach(DOM.select('tr', tb), function(n) {\n\t\t\t\tDOM.addClass(n.firstChild, 'mceFirst');\n\t\t\t\tDOM.addClass(n.childNodes[n.childNodes.length - 1], 'mceLast');\n\t\t\t});\n\n\t\t\tif (DOM.get(s.theme_advanced_toolbar_container))\n\t\t\t\tDOM.get(s.theme_advanced_toolbar_container).appendChild(p);\n\t\t\telse\n\t\t\t\tDOM.insertAfter(p, n);\n\n\t\t\tEvent.add(ed.id + '_path_row', 'click', function(e) {\n\t\t\t\te = e.target;\n\n\t\t\t\tif (e.nodeName == 'A') {\n\t\t\t\t\tt._sel(e.className.replace(/^.*mcePath_([0-9]+).*$/, '$1'));\n\n\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t}\n\t\t\t});\n/*\n\t\t\tif (DOM.get(ed.id + '_path_row')) {\n\t\t\t\tEvent.add(ed.id + '_tbl', 'mouseover', function(e) {\n\t\t\t\t\tvar re;\n\t\n\t\t\t\t\te = e.target;\n\n\t\t\t\t\tif (e.nodeName == 'SPAN' && DOM.hasClass(e.parentNode, 'mceButton')) {\n\t\t\t\t\t\tre = DOM.get(ed.id + '_path_row');\n\t\t\t\t\t\tt.lastPath = re.innerHTML;\n\t\t\t\t\t\tDOM.setHTML(re, e.parentNode.title);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tEvent.add(ed.id + '_tbl', 'mouseout', function(e) {\n\t\t\t\t\tif (t.lastPath) {\n\t\t\t\t\t\tDOM.setHTML(ed.id + '_path_row', t.lastPath);\n\t\t\t\t\t\tt.lastPath = 0;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n*/\n\n\t\t\tif (!ed.getParam('accessibility_focus'))\n\t\t\t\tEvent.add(DOM.add(p, 'a', {href : '#'}, '<!-- IE -->'), 'focus', function() {tinyMCE.get(ed.id).focus();});\n\n\t\t\tif (s.theme_advanced_toolbar_location == 'external')\n\t\t\t\to.deltaHeight = 0;\n\n\t\t\tt.deltaHeight = o.deltaHeight;\n\t\t\to.targetNode = null;\n\n\t\t\ted.onKeyDown.add(function(ed, evt) {\n\t\t\t\tvar DOM_VK_F10 = 121, DOM_VK_F11 = 122;\n\n\t\t\t\tif (evt.altKey) {\n\t\t \t\t\tif (evt.keyCode === DOM_VK_F10) {\n\t\t\t\t\t\t// Make sure focus is given to toolbar in Safari.\n\t\t\t\t\t\t// We can't do this in IE as it prevents giving focus to toolbar when editor is in a frame\n\t\t\t\t\t\tif (tinymce.isWebKit) {\n\t\t\t\t\t\t\twindow.focus();\n\t\t\t\t\t\t}\n\t\t\t\t\t\tt.toolbarGroup.focus();\n\t\t\t\t\t\treturn Event.cancel(evt);\n\t\t\t\t\t} else if (evt.keyCode === DOM_VK_F11) {\n\t\t\t\t\t\tDOM.get(ed.id + '_path_row').focus();\n\t\t\t\t\t\treturn Event.cancel(evt);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// alt+0 is the UK recommended shortcut for accessing the list of access controls.\n\t\t\ted.addShortcut('alt+0', '', 'mceShortcuts', t);\n\n\t\t\treturn {\n\t\t\t\tiframeContainer : ic,\n\t\t\t\teditorContainer : ed.id + '_parent',\n\t\t\t\tsizeContainer : sc,\n\t\t\t\tdeltaHeight : o.deltaHeight\n\t\t\t};\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Advanced theme',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t}\n\t\t},\n\n\t\tresizeBy : function(dw, dh) {\n\t\t\tvar e = DOM.get(this.editor.id + '_ifr');\n\n\t\t\tthis.resizeTo(e.clientWidth + dw, e.clientHeight + dh);\n\t\t},\n\n\t\tresizeTo : function(w, h, store) {\n\t\t\tvar ed = this.editor, s = this.settings, e = DOM.get(ed.id + '_tbl'), ifr = DOM.get(ed.id + '_ifr');\n\n\t\t\t// Boundery fix box\n\t\t\tw = Math.max(s.theme_advanced_resizing_min_width || 100, w);\n\t\t\th = Math.max(s.theme_advanced_resizing_min_height || 100, h);\n\t\t\tw = Math.min(s.theme_advanced_resizing_max_width || 0xFFFF, w);\n\t\t\th = Math.min(s.theme_advanced_resizing_max_height || 0xFFFF, h);\n\n\t\t\t// Resize iframe and container\n\t\t\tDOM.setStyle(e, 'height', '');\n\t\t\tDOM.setStyle(ifr, 'height', h);\n\n\t\t\tif (s.theme_advanced_resize_horizontal) {\n\t\t\t\tDOM.setStyle(e, 'width', '');\n\t\t\t\tDOM.setStyle(ifr, 'width', w);\n\n\t\t\t\t// Make sure that the size is never smaller than the over all ui\n\t\t\t\tif (w < e.clientWidth) {\n\t\t\t\t\tw = e.clientWidth;\n\t\t\t\t\tDOM.setStyle(ifr, 'width', e.clientWidth);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Store away the size\n\t\t\tif (store && s.theme_advanced_resizing_use_cookie) {\n\t\t\t\tCookie.setHash(\"TinyMCE_\" + ed.id + \"_size\", {\n\t\t\t\t\tcw : w,\n\t\t\t\t\tch : h\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tvar id = this.editor.id;\n\n\t\t\tEvent.clear(id + '_resize');\n\t\t\tEvent.clear(id + '_path_row');\n\t\t\tEvent.clear(id + '_external_close');\n\t\t},\n\n\t\t// Internal functions\n\n\t\t_simpleLayout : function(s, tb, o, p) {\n\t\t\tvar t = this, ed = t.editor, lo = s.theme_advanced_toolbar_location, sl = s.theme_advanced_statusbar_location, n, ic, etb, c;\n\n\t\t\tif (s.readonly) {\n\t\t\t\tn = DOM.add(tb, 'tr');\n\t\t\t\tn = ic = DOM.add(n, 'td', {'class' : 'mceIframeContainer'});\n\t\t\t\treturn ic;\n\t\t\t}\n\n\t\t\t// Create toolbar container at top\n\t\t\tif (lo == 'top')\n\t\t\t\tt._addToolbars(tb, o);\n\n\t\t\t// Create external toolbar\n\t\t\tif (lo == 'external') {\n\t\t\t\tn = c = DOM.create('div', {style : 'position:relative'});\n\t\t\t\tn = DOM.add(n, 'div', {id : ed.id + '_external', 'class' : 'mceExternalToolbar'});\n\t\t\t\tDOM.add(n, 'a', {id : ed.id + '_external_close', href : 'javascript:;', 'class' : 'mceExternalClose'});\n\t\t\t\tn = DOM.add(n, 'table', {id : ed.id + '_tblext', cellSpacing : 0, cellPadding : 0});\n\t\t\t\tetb = DOM.add(n, 'tbody');\n\n\t\t\t\tif (p.firstChild.className == 'mceOldBoxModel')\n\t\t\t\t\tp.firstChild.appendChild(c);\n\t\t\t\telse\n\t\t\t\t\tp.insertBefore(c, p.firstChild);\n\n\t\t\t\tt._addToolbars(etb, o);\n\n\t\t\t\ted.onMouseUp.add(function() {\n\t\t\t\t\tvar e = DOM.get(ed.id + '_external');\n\t\t\t\t\tDOM.show(e);\n\n\t\t\t\t\tDOM.hide(lastExtID);\n\n\t\t\t\t\tvar f = Event.add(ed.id + '_external_close', 'click', function() {\n\t\t\t\t\t\tDOM.hide(ed.id + '_external');\n\t\t\t\t\t\tEvent.remove(ed.id + '_external_close', 'click', f);\n\t\t\t\t\t});\n\n\t\t\t\t\tDOM.show(e);\n\t\t\t\t\tDOM.setStyle(e, 'top', 0 - DOM.getRect(ed.id + '_tblext').h - 1);\n\n\t\t\t\t\t// Fixes IE rendering bug\n\t\t\t\t\tDOM.hide(e);\n\t\t\t\t\tDOM.show(e);\n\t\t\t\t\te.style.filter = '';\n\n\t\t\t\t\tlastExtID = ed.id + '_external';\n\n\t\t\t\t\te = null;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (sl == 'top')\n\t\t\t\tt._addStatusBar(tb, o);\n\n\t\t\t// Create iframe container\n\t\t\tif (!s.theme_advanced_toolbar_container) {\n\t\t\t\tn = DOM.add(tb, 'tr');\n\t\t\t\tn = ic = DOM.add(n, 'td', {'class' : 'mceIframeContainer'});\n\t\t\t}\n\n\t\t\t// Create toolbar container at bottom\n\t\t\tif (lo == 'bottom')\n\t\t\t\tt._addToolbars(tb, o);\n\n\t\t\tif (sl == 'bottom')\n\t\t\t\tt._addStatusBar(tb, o);\n\n\t\t\treturn ic;\n\t\t},\n\n\t\t_rowLayout : function(s, tb, o) {\n\t\t\tvar t = this, ed = t.editor, dc, da, cf = ed.controlManager, n, ic, to, a;\n\n\t\t\tdc = s.theme_advanced_containers_default_class || '';\n\t\t\tda = s.theme_advanced_containers_default_align || 'center';\n\n\t\t\teach(explode(s.theme_advanced_containers || ''), function(c, i) {\n\t\t\t\tvar v = s['theme_advanced_container_' + c] || '';\n\n\t\t\t\tswitch (c.toLowerCase()) {\n\t\t\t\t\tcase 'mceeditor':\n\t\t\t\t\t\tn = DOM.add(tb, 'tr');\n\t\t\t\t\t\tn = ic = DOM.add(n, 'td', {'class' : 'mceIframeContainer'});\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'mceelementpath':\n\t\t\t\t\t\tt._addStatusBar(tb, o);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tdefault:\n\t\t\t\t\t\ta = (s['theme_advanced_container_' + c + '_align'] || da).toLowerCase();\n\t\t\t\t\t\ta = 'mce' + t._ufirst(a);\n\n\t\t\t\t\t\tn = DOM.add(DOM.add(tb, 'tr'), 'td', {\n\t\t\t\t\t\t\t'class' : 'mceToolbar ' + (s['theme_advanced_container_' + c + '_class'] || dc) + ' ' + a || da\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tto = cf.createToolbar(\"toolbar\" + i);\n\t\t\t\t\t\tt._addControls(v, to);\n\t\t\t\t\t\tDOM.setHTML(n, to.renderHTML());\n\t\t\t\t\t\to.deltaHeight -= s.theme_advanced_row_height;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn ic;\n\t\t},\n\n\t\t_addControls : function(v, tb) {\n\t\t\tvar t = this, s = t.settings, di, cf = t.editor.controlManager;\n\n\t\t\tif (s.theme_advanced_disable && !t._disabled) {\n\t\t\t\tdi = {};\n\n\t\t\t\teach(explode(s.theme_advanced_disable), function(v) {\n\t\t\t\t\tdi[v] = 1;\n\t\t\t\t});\n\n\t\t\t\tt._disabled = di;\n\t\t\t} else\n\t\t\t\tdi = t._disabled;\n\n\t\t\teach(explode(v), function(n) {\n\t\t\t\tvar c;\n\n\t\t\t\tif (di && di[n])\n\t\t\t\t\treturn;\n\n\t\t\t\t// Compatiblity with 2.x\n\t\t\t\tif (n == 'tablecontrols') {\n\t\t\t\t\teach([\"table\",\"|\",\"row_props\",\"cell_props\",\"|\",\"row_before\",\"row_after\",\"delete_row\",\"|\",\"col_before\",\"col_after\",\"delete_col\",\"|\",\"split_cells\",\"merge_cells\"], function(n) {\n\t\t\t\t\t\tn = t.createControl(n, cf);\n\n\t\t\t\t\t\tif (n)\n\t\t\t\t\t\t\ttb.add(n);\n\t\t\t\t\t});\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tc = t.createControl(n, cf);\n\n\t\t\t\tif (c)\n\t\t\t\t\ttb.add(c);\n\t\t\t});\n\t\t},\n\n\t\t_addToolbars : function(c, o) {\n\t\t\tvar t = this, i, tb, ed = t.editor, s = t.settings, v, cf = ed.controlManager, di, n, h = [], a, toolbarGroup;\n\n\t\t\ttoolbarGroup = cf.createToolbarGroup('toolbargroup', {\n\t\t\t\t'name': ed.getLang('advanced.toolbar'),\n\t\t\t\t'tab_focus_toolbar':ed.getParam('theme_advanced_tab_focus_toolbar')\n\t\t\t});\n\n\t\t\tt.toolbarGroup = toolbarGroup;\n\n\t\t\ta = s.theme_advanced_toolbar_align.toLowerCase();\n\t\t\ta = 'mce' + t._ufirst(a);\n\n\t\t\tn = DOM.add(DOM.add(c, 'tr', {role: 'presentation'}), 'td', {'class' : 'mceToolbar ' + a, \"role\":\"presentation\"});\n\n\t\t\t// Create toolbar and add the controls\n\t\t\tfor (i=1; (v = s['theme_advanced_buttons' + i]); i++) {\n\t\t\t\ttb = cf.createToolbar(\"toolbar\" + i, {'class' : 'mceToolbarRow' + i});\n\n\t\t\t\tif (s['theme_advanced_buttons' + i + '_add'])\n\t\t\t\t\tv += ',' + s['theme_advanced_buttons' + i + '_add'];\n\n\t\t\t\tif (s['theme_advanced_buttons' + i + '_add_before'])\n\t\t\t\t\tv = s['theme_advanced_buttons' + i + '_add_before'] + ',' + v;\n\n\t\t\t\tt._addControls(v, tb);\n\t\t\t\ttoolbarGroup.add(tb);\n\n\t\t\t\to.deltaHeight -= s.theme_advanced_row_height;\n\t\t\t}\n\t\t\th.push(toolbarGroup.renderHTML());\n\t\t\th.push(DOM.createHTML('a', {href : '#', accesskey : 'z', title : ed.getLang(\"advanced.toolbar_focus\"), onfocus : 'tinyMCE.getInstanceById(\\'' + ed.id + '\\').focus();'}, '<!-- IE -->'));\n\t\t\tDOM.setHTML(n, h.join(''));\n\t\t},\n\n\t\t_addStatusBar : function(tb, o) {\n\t\t\tvar n, t = this, ed = t.editor, s = t.settings, r, mf, me, td;\n\n\t\t\tn = DOM.add(tb, 'tr');\n\t\t\tn = td = DOM.add(n, 'td', {'class' : 'mceStatusbar'}); \n\t\t\tn = DOM.add(n, 'div', {id : ed.id + '_path_row', 'role': 'group', 'aria-labelledby': ed.id + '_path_voice'});\n\t\t\tif (s.theme_advanced_path) {\n\t\t\t\tDOM.add(n, 'span', {id: ed.id + '_path_voice'}, ed.translate('advanced.path'));\n\t\t\t\tDOM.add(n, 'span', {}, ': ');\n\t\t\t} else {\n\t\t\t\tDOM.add(n, 'span', {}, '&#160;');\n\t\t\t}\n\t\t\t\n\n\t\t\tif (s.theme_advanced_resizing) {\n\t\t\t\tDOM.add(td, 'a', {id : ed.id + '_resize', href : 'javascript:;', onclick : \"return false;\", 'class' : 'mceResize', tabIndex:\"-1\"});\n\n\t\t\t\tif (s.theme_advanced_resizing_use_cookie) {\n\t\t\t\t\ted.onPostRender.add(function() {\n\t\t\t\t\t\tvar o = Cookie.getHash(\"TinyMCE_\" + ed.id + \"_size\"), c = DOM.get(ed.id + '_tbl');\n\n\t\t\t\t\t\tif (!o)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tt.resizeTo(o.cw, o.ch);\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\ted.onPostRender.add(function() {\n\t\t\t\t\tEvent.add(ed.id + '_resize', 'click', function(e) {\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t});\n\n\t\t\t\t\tEvent.add(ed.id + '_resize', 'mousedown', function(e) {\n\t\t\t\t\t\tvar mouseMoveHandler1, mouseMoveHandler2,\n\t\t\t\t\t\t\tmouseUpHandler1, mouseUpHandler2,\n\t\t\t\t\t\t\tstartX, startY, startWidth, startHeight, width, height, ifrElm;\n\n\t\t\t\t\t\tfunction resizeOnMove(e) {\n\t\t\t\t\t\t\te.preventDefault();\n\n\t\t\t\t\t\t\twidth = startWidth + (e.screenX - startX);\n\t\t\t\t\t\t\theight = startHeight + (e.screenY - startY);\n\n\t\t\t\t\t\t\tt.resizeTo(width, height);\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tfunction endResize(e) {\n\t\t\t\t\t\t\t// Stop listening\n\t\t\t\t\t\t\tEvent.remove(DOM.doc, 'mousemove', mouseMoveHandler1);\n\t\t\t\t\t\t\tEvent.remove(ed.getDoc(), 'mousemove', mouseMoveHandler2);\n\t\t\t\t\t\t\tEvent.remove(DOM.doc, 'mouseup', mouseUpHandler1);\n\t\t\t\t\t\t\tEvent.remove(ed.getDoc(), 'mouseup', mouseUpHandler2);\n\n\t\t\t\t\t\t\twidth = startWidth + (e.screenX - startX);\n\t\t\t\t\t\t\theight = startHeight + (e.screenY - startY);\n\t\t\t\t\t\t\tt.resizeTo(width, height, true);\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\te.preventDefault();\n\n\t\t\t\t\t\t// Get the current rect size\n\t\t\t\t\t\tstartX = e.screenX;\n\t\t\t\t\t\tstartY = e.screenY;\n\t\t\t\t\t\tifrElm = DOM.get(t.editor.id + '_ifr');\n\t\t\t\t\t\tstartWidth = width = ifrElm.clientWidth;\n\t\t\t\t\t\tstartHeight = height = ifrElm.clientHeight;\n\n\t\t\t\t\t\t// Register envent handlers\n\t\t\t\t\t\tmouseMoveHandler1 = Event.add(DOM.doc, 'mousemove', resizeOnMove);\n\t\t\t\t\t\tmouseMoveHandler2 = Event.add(ed.getDoc(), 'mousemove', resizeOnMove);\n\t\t\t\t\t\tmouseUpHandler1 = Event.add(DOM.doc, 'mouseup', endResize);\n\t\t\t\t\t\tmouseUpHandler2 = Event.add(ed.getDoc(), 'mouseup', endResize);\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\to.deltaHeight -= 21;\n\t\t\tn = tb = null;\n\t\t},\n\n\t\t_updateUndoStatus : function(ed) {\n\t\t\tvar cm = ed.controlManager, um = ed.undoManager;\n\n\t\t\tcm.setDisabled('undo', !um.hasUndo() && !um.typing);\n\t\t\tcm.setDisabled('redo', !um.hasRedo());\n\t\t},\n\n\t\t_nodeChanged : function(ed, cm, n, co, ob) {\n\t\t\tvar t = this, p, de = 0, v, c, s = t.settings, cl, fz, fn, fc, bc, formatNames, matches;\n\n\t\t\ttinymce.each(t.stateControls, function(c) {\n\t\t\t\tcm.setActive(c, ed.queryCommandState(t.controls[c][1]));\n\t\t\t});\n\n\t\t\tfunction getParent(name) {\n\t\t\t\tvar i, parents = ob.parents, func = name;\n\n\t\t\t\tif (typeof(name) == 'string') {\n\t\t\t\t\tfunc = function(node) {\n\t\t\t\t\t\treturn node.nodeName == name;\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\tfor (i = 0; i < parents.length; i++) {\n\t\t\t\t\tif (func(parents[i]))\n\t\t\t\t\t\treturn parents[i];\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tcm.setActive('visualaid', ed.hasVisual);\n\t\t\tt._updateUndoStatus(ed);\n\t\t\tcm.setDisabled('outdent', !ed.queryCommandState('Outdent'));\n\n\t\t\tp = getParent('A');\n\t\t\tif (c = cm.get('link')) {\n\t\t\t\tif (!p || !p.name) {\n\t\t\t\t\tc.setDisabled(!p && co);\n\t\t\t\t\tc.setActive(!!p);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (c = cm.get('unlink')) {\n\t\t\t\tc.setDisabled(!p && co);\n\t\t\t\tc.setActive(!!p && !p.name);\n\t\t\t}\n\n\t\t\tif (c = cm.get('anchor')) {\n\t\t\t\tc.setActive(!co && !!p && p.name);\n\t\t\t}\n\n\t\t\tp = getParent('IMG');\n\t\t\tif (c = cm.get('image'))\n\t\t\t\tc.setActive(!co && !!p && n.className.indexOf('mceItem') == -1);\n\n\t\t\tif (c = cm.get('styleselect')) {\n\t\t\t\tt._importClasses();\n\n\t\t\t\tformatNames = [];\n\t\t\t\teach(c.items, function(item) {\n\t\t\t\t\tformatNames.push(item.value);\n\t\t\t\t});\n\n\t\t\t\tmatches = ed.formatter.matchAll(formatNames);\n\t\t\t\tc.select(matches[0]);\n\t\t\t}\n\n\t\t\tif (c = cm.get('formatselect')) {\n\t\t\t\tp = getParent(DOM.isBlock);\n\n\t\t\t\tif (p)\n\t\t\t\t\tc.select(p.nodeName.toLowerCase());\n\t\t\t}\n\n\t\t\t// Find out current fontSize, fontFamily and fontClass\n\t\t\tgetParent(function(n) {\n\t\t\t\tif (n.nodeName === 'SPAN') {\n\t\t\t\t\tif (!cl && n.className)\n\t\t\t\t\t\tcl = n.className;\n\t\t\t\t}\n\n\t\t\t\tif (ed.dom.is(n, s.theme_advanced_font_selector)) {\n\t\t\t\t\tif (!fz && n.style.fontSize)\n\t\t\t\t\t\tfz = n.style.fontSize;\n\n\t\t\t\t\tif (!fn && n.style.fontFamily)\n\t\t\t\t\t\tfn = n.style.fontFamily.replace(/[\\\"\\']+/g, '').replace(/^([^,]+).*/, '$1').toLowerCase();\n\t\t\t\t\t\n\t\t\t\t\tif (!fc && n.style.color)\n\t\t\t\t\t\tfc = n.style.color;\n\n\t\t\t\t\tif (!bc && n.style.backgroundColor)\n\t\t\t\t\t\tbc = n.style.backgroundColor;\n\t\t\t\t}\n\n\t\t\t\treturn false;\n\t\t\t});\n\n\t\t\tif (c = cm.get('fontselect')) {\n\t\t\t\tc.select(function(v) {\n\t\t\t\t\treturn v.replace(/^([^,]+).*/, '$1').toLowerCase() == fn;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Select font size\n\t\t\tif (c = cm.get('fontsizeselect')) {\n\t\t\t\t// Use computed style\n\t\t\t\tif (s.theme_advanced_runtime_fontsize && !fz && !cl)\n\t\t\t\t\tfz = ed.dom.getStyle(n, 'fontSize', true);\n\n\t\t\t\tc.select(function(v) {\n\t\t\t\t\tif (v.fontSize && v.fontSize === fz)\n\t\t\t\t\t\treturn true;\n\n\t\t\t\t\tif (v['class'] && v['class'] === cl)\n\t\t\t\t\t\treturn true;\n\t\t\t\t});\n\t\t\t}\n\t\t\t\n\t\t\tif (s.theme_advanced_show_current_color) {\n\t\t\t\tfunction updateColor(controlId, color) {\n\t\t\t\t\tif (c = cm.get(controlId)) {\n\t\t\t\t\t\tif (!color)\n\t\t\t\t\t\t\tcolor = c.settings.default_color;\n\t\t\t\t\t\tif (color !== c.value) {\n\t\t\t\t\t\t\tc.displayColor(color);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tupdateColor('forecolor', fc);\n\t\t\t\tupdateColor('backcolor', bc);\n\t\t\t}\n\n\t\t\tif (s.theme_advanced_show_current_color) {\n\t\t\t\tfunction updateColor(controlId, color) {\n\t\t\t\t\tif (c = cm.get(controlId)) {\n\t\t\t\t\t\tif (!color)\n\t\t\t\t\t\t\tcolor = c.settings.default_color;\n\t\t\t\t\t\tif (color !== c.value) {\n\t\t\t\t\t\t\tc.displayColor(color);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\tupdateColor('forecolor', fc);\n\t\t\t\tupdateColor('backcolor', bc);\n\t\t\t}\n\n\t\t\tif (s.theme_advanced_path && s.theme_advanced_statusbar_location) {\n\t\t\t\tp = DOM.get(ed.id + '_path') || DOM.add(ed.id + '_path_row', 'span', {id : ed.id + '_path'});\n\n\t\t\t\tif (t.statusKeyboardNavigation) {\n\t\t\t\t\tt.statusKeyboardNavigation.destroy();\n\t\t\t\t\tt.statusKeyboardNavigation = null;\n\t\t\t\t}\n\n\t\t\t\tDOM.setHTML(p, '');\n\n\t\t\t\tgetParent(function(n) {\n\t\t\t\t\tvar na = n.nodeName.toLowerCase(), u, pi, ti = '';\n\n\t\t\t\t\t// Ignore non element and bogus/hidden elements\n\t\t\t\t\tif (n.nodeType != 1 || na === 'br' || n.getAttribute('data-mce-bogus') || DOM.hasClass(n, 'mceItemHidden') || DOM.hasClass(n, 'mceItemRemoved'))\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Handle prefix\n\t\t\t\t\tif (tinymce.isIE && n.scopeName !== 'HTML')\n\t\t\t\t\t\tna = n.scopeName + ':' + na;\n\n\t\t\t\t\t// Remove internal prefix\n\t\t\t\t\tna = na.replace(/mce\\:/g, '');\n\n\t\t\t\t\t// Handle node name\n\t\t\t\t\tswitch (na) {\n\t\t\t\t\t\tcase 'b':\n\t\t\t\t\t\t\tna = 'strong';\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase 'i':\n\t\t\t\t\t\t\tna = 'em';\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase 'img':\n\t\t\t\t\t\t\tif (v = DOM.getAttrib(n, 'src'))\n\t\t\t\t\t\t\t\tti += 'src: ' + v + ' ';\n\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase 'a':\n\t\t\t\t\t\t\tif (v = DOM.getAttrib(n, 'name')) {\n\t\t\t\t\t\t\t\tti += 'name: ' + v + ' ';\n\t\t\t\t\t\t\t\tna += '#' + v;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (v = DOM.getAttrib(n, 'href'))\n\t\t\t\t\t\t\t\tti += 'href: ' + v + ' ';\n\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase 'font':\n\t\t\t\t\t\t\tif (v = DOM.getAttrib(n, 'face'))\n\t\t\t\t\t\t\t\tti += 'font: ' + v + ' ';\n\n\t\t\t\t\t\t\tif (v = DOM.getAttrib(n, 'size'))\n\t\t\t\t\t\t\t\tti += 'size: ' + v + ' ';\n\n\t\t\t\t\t\t\tif (v = DOM.getAttrib(n, 'color'))\n\t\t\t\t\t\t\t\tti += 'color: ' + v + ' ';\n\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase 'span':\n\t\t\t\t\t\t\tif (v = DOM.getAttrib(n, 'style'))\n\t\t\t\t\t\t\t\tti += 'style: ' + v + ' ';\n\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (v = DOM.getAttrib(n, 'id'))\n\t\t\t\t\t\tti += 'id: ' + v + ' ';\n\n\t\t\t\t\tif (v = n.className) {\n\t\t\t\t\t\tv = v.replace(/\\b\\s*(webkit|mce|Apple-)\\w+\\s*\\b/g, '')\n\n\t\t\t\t\t\tif (v) {\n\t\t\t\t\t\t\tti += 'class: ' + v + ' ';\n\n\t\t\t\t\t\t\tif (DOM.isBlock(n) || na == 'img' || na == 'span')\n\t\t\t\t\t\t\t\tna += '.' + v;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tna = na.replace(/(html:)/g, '');\n\t\t\t\t\tna = {name : na, node : n, title : ti};\n\t\t\t\t\tt.onResolveName.dispatch(t, na);\n\t\t\t\t\tti = na.title;\n\t\t\t\t\tna = na.name;\n\n\t\t\t\t\t//u = \"javascript:tinymce.EditorManager.get('\" + ed.id + \"').theme._sel('\" + (de++) + \"');\";\n\t\t\t\t\tpi = DOM.create('a', {'href' : \"javascript:;\", role: 'button', onmousedown : \"return false;\", title : ti, 'class' : 'mcePath_' + (de++)}, na);\n\n\t\t\t\t\tif (p.hasChildNodes()) {\n\t\t\t\t\t\tp.insertBefore(DOM.create('span', {'aria-hidden': 'true'}, '\\u00a0\\u00bb '), p.firstChild);\n\t\t\t\t\t\tp.insertBefore(pi, p.firstChild);\n\t\t\t\t\t} else\n\t\t\t\t\t\tp.appendChild(pi);\n\t\t\t\t}, ed.getBody());\n\n\t\t\t\tif (DOM.select('a', p).length > 0) {\n\t\t\t\t\tt.statusKeyboardNavigation = new tinymce.ui.KeyboardNavigation({\n\t\t\t\t\t\troot: ed.id + \"_path_row\",\n\t\t\t\t\t\titems: DOM.select('a', p),\n\t\t\t\t\t\texcludeFromTabOrder: true,\n\t\t\t\t\t\tonCancel: function() {\n\t\t\t\t\t\t\ted.focus();\n\t\t\t\t\t\t}\n\t\t\t\t\t}, DOM);\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t// Commands gets called by execCommand\n\n\t\t_sel : function(v) {\n\t\t\tthis.editor.execCommand('mceSelectNodeDepth', false, v);\n\t\t},\n\n\t\t_mceInsertAnchor : function(ui, v) {\n\t\t\tvar ed = this.editor;\n\n\t\t\ted.windowManager.open({\n\t\t\t\turl : this.url + '/anchor.htm',\n\t\t\t\twidth : 320 + parseInt(ed.getLang('advanced.anchor_delta_width', 0)),\n\t\t\t\theight : 90 + parseInt(ed.getLang('advanced.anchor_delta_height', 0)),\n\t\t\t\tinline : true\n\t\t\t}, {\n\t\t\t\ttheme_url : this.url\n\t\t\t});\n\t\t},\n\n\t\t_mceCharMap : function() {\n\t\t\tvar ed = this.editor;\n\n\t\t\ted.windowManager.open({\n\t\t\t\turl : this.url + '/charmap.htm',\n\t\t\t\twidth : 550 + parseInt(ed.getLang('advanced.charmap_delta_width', 0)),\n\t\t\t\theight : 260 + parseInt(ed.getLang('advanced.charmap_delta_height', 0)),\n\t\t\t\tinline : true\n\t\t\t}, {\n\t\t\t\ttheme_url : this.url\n\t\t\t});\n\t\t},\n\n\t\t_mceHelp : function() {\n\t\t\tvar ed = this.editor;\n\n\t\t\ted.windowManager.open({\n\t\t\t\turl : this.url + '/about.htm',\n\t\t\t\twidth : 480,\n\t\t\t\theight : 380,\n\t\t\t\tinline : true\n\t\t\t}, {\n\t\t\t\ttheme_url : this.url\n\t\t\t});\n\t\t},\n\n\t\t_mceShortcuts : function() {\n\t\t\tvar ed = this.editor;\n\t\t\ted.windowManager.open({\n\t\t\t\turl: this.url + '/shortcuts.htm',\n\t\t\t\twidth: 480,\n\t\t\t\theight: 380,\n\t\t\t\tinline: true\n\t\t\t}, {\n\t\t\t\ttheme_url: this.url\n\t\t\t});\n\t\t},\n\n\t\t_mceColorPicker : function(u, v) {\n\t\t\tvar ed = this.editor;\n\n\t\t\tv = v || {};\n\n\t\t\ted.windowManager.open({\n\t\t\t\turl : this.url + '/color_picker.htm',\n\t\t\t\twidth : 375 + parseInt(ed.getLang('advanced.colorpicker_delta_width', 0)),\n\t\t\t\theight : 250 + parseInt(ed.getLang('advanced.colorpicker_delta_height', 0)),\n\t\t\t\tclose_previous : false,\n\t\t\t\tinline : true\n\t\t\t}, {\n\t\t\t\tinput_color : v.color,\n\t\t\t\tfunc : v.func,\n\t\t\t\ttheme_url : this.url\n\t\t\t});\n\t\t},\n\n\t\t_mceCodeEditor : function(ui, val) {\n\t\t\tvar ed = this.editor;\n\n\t\t\ted.windowManager.open({\n\t\t\t\turl : this.url + '/source_editor.htm',\n\t\t\t\twidth : parseInt(ed.getParam(\"theme_advanced_source_editor_width\", 720)),\n\t\t\t\theight : parseInt(ed.getParam(\"theme_advanced_source_editor_height\", 580)),\n\t\t\t\tinline : true,\n\t\t\t\tresizable : true,\n\t\t\t\tmaximizable : true\n\t\t\t}, {\n\t\t\t\ttheme_url : this.url\n\t\t\t});\n\t\t},\n\n\t\t_mceImage : function(ui, val) {\n\t\t\tvar ed = this.editor;\n\n\t\t\t// Internal image object like a flash placeholder\n\t\t\tif (ed.dom.getAttrib(ed.selection.getNode(), 'class').indexOf('mceItem') != -1)\n\t\t\t\treturn;\n\n\t\t\ted.windowManager.open({\n\t\t\t\turl : this.url + '/image.htm',\n\t\t\t\twidth : 355 + parseInt(ed.getLang('advanced.image_delta_width', 0)),\n\t\t\t\theight : 275 + parseInt(ed.getLang('advanced.image_delta_height', 0)),\n\t\t\t\tinline : true\n\t\t\t}, {\n\t\t\t\ttheme_url : this.url\n\t\t\t});\n\t\t},\n\n\t\t_mceLink : function(ui, val) {\n\t\t\tvar ed = this.editor;\n\n\t\t\ted.windowManager.open({\n\t\t\t\turl : this.url + '/link.htm',\n\t\t\t\twidth : 310 + parseInt(ed.getLang('advanced.link_delta_width', 0)),\n\t\t\t\theight : 200 + parseInt(ed.getLang('advanced.link_delta_height', 0)),\n\t\t\t\tinline : true\n\t\t\t}, {\n\t\t\t\ttheme_url : this.url\n\t\t\t});\n\t\t},\n\n\t\t_mceNewDocument : function() {\n\t\t\tvar ed = this.editor;\n\n\t\t\ted.windowManager.confirm('advanced.newdocument', function(s) {\n\t\t\t\tif (s)\n\t\t\t\t\ted.execCommand('mceSetContent', false, '');\n\t\t\t});\n\t\t},\n\n\t\t_mceForeColor : function() {\n\t\t\tvar t = this;\n\n\t\t\tthis._mceColorPicker(0, {\n\t\t\t\tcolor: t.fgColor,\n\t\t\t\tfunc : function(co) {\n\t\t\t\t\tt.fgColor = co;\n\t\t\t\t\tt.editor.execCommand('ForeColor', false, co);\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\t_mceBackColor : function() {\n\t\t\tvar t = this;\n\n\t\t\tthis._mceColorPicker(0, {\n\t\t\t\tcolor: t.bgColor,\n\t\t\t\tfunc : function(co) {\n\t\t\t\t\tt.bgColor = co;\n\t\t\t\t\tt.editor.execCommand('HiliteColor', false, co);\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\t_ufirst : function(s) {\n\t\t\treturn s.substring(0, 1).toUpperCase() + s.substring(1);\n\t\t}\n\t});\n\n\ttinymce.ThemeManager.add('advanced', tinymce.themes.AdvancedTheme);\n}(tinymce));\n","Magento_Tinymce3/tiny_mce/themes/advanced/editor_template.js":"(function(e){var d=e.DOM,b=e.dom.Event,h=e.extend,f=e.each,a=e.util.Cookie,g,c=e.explode;e.ThemeManager.requireLangPack(\"advanced\");e.create(\"tinymce.themes.AdvancedTheme\",{sizes:[8,10,12,14,18,24,36],controls:{bold:[\"bold_desc\",\"Bold\"],italic:[\"italic_desc\",\"Italic\"],underline:[\"underline_desc\",\"Underline\"],strikethrough:[\"striketrough_desc\",\"Strikethrough\"],justifyleft:[\"justifyleft_desc\",\"JustifyLeft\"],justifycenter:[\"justifycenter_desc\",\"JustifyCenter\"],justifyright:[\"justifyright_desc\",\"JustifyRight\"],justifyfull:[\"justifyfull_desc\",\"JustifyFull\"],bullist:[\"bullist_desc\",\"InsertUnorderedList\"],numlist:[\"numlist_desc\",\"InsertOrderedList\"],outdent:[\"outdent_desc\",\"Outdent\"],indent:[\"indent_desc\",\"Indent\"],cut:[\"cut_desc\",\"Cut\"],copy:[\"copy_desc\",\"Copy\"],paste:[\"paste_desc\",\"Paste\"],undo:[\"undo_desc\",\"Undo\"],redo:[\"redo_desc\",\"Redo\"],link:[\"link_desc\",\"mceLink\"],unlink:[\"unlink_desc\",\"unlink\"],image:[\"image_desc\",\"mceImage\"],cleanup:[\"cleanup_desc\",\"mceCleanup\"],help:[\"help_desc\",\"mceHelp\"],code:[\"code_desc\",\"mceCodeEditor\"],hr:[\"hr_desc\",\"InsertHorizontalRule\"],removeformat:[\"removeformat_desc\",\"RemoveFormat\"],sub:[\"sub_desc\",\"subscript\"],sup:[\"sup_desc\",\"superscript\"],forecolor:[\"forecolor_desc\",\"ForeColor\"],forecolorpicker:[\"forecolor_desc\",\"mceForeColor\"],backcolor:[\"backcolor_desc\",\"HiliteColor\"],backcolorpicker:[\"backcolor_desc\",\"mceBackColor\"],charmap:[\"charmap_desc\",\"mceCharMap\"],visualaid:[\"visualaid_desc\",\"mceToggleVisualAid\"],anchor:[\"anchor_desc\",\"mceInsertAnchor\"],newdocument:[\"newdocument_desc\",\"mceNewDocument\"],blockquote:[\"blockquote_desc\",\"mceBlockQuote\"]},stateControls:[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"bullist\",\"numlist\",\"justifyleft\",\"justifycenter\",\"justifyright\",\"justifyfull\",\"sub\",\"sup\",\"blockquote\"],init:function(j,k){var l=this,m,i,n;l.editor=j;l.url=k;l.onResolveName=new e.util.Dispatcher(this);j.forcedHighContrastMode=j.settings.detect_highcontrast&&l._isHighContrast();j.settings.skin=j.forcedHighContrastMode?\"highcontrast\":j.settings.skin;l.settings=m=h({theme_advanced_path:true,theme_advanced_toolbar_location:\"bottom\",theme_advanced_buttons1:\"bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,styleselect,formatselect\",theme_advanced_buttons2:\"bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code\",theme_advanced_buttons3:\"hr,removeformat,visualaid,|,sub,sup,|,charmap\",theme_advanced_blockformats:\"p,address,pre,h1,h2,h3,h4,h5,h6\",theme_advanced_toolbar_align:\"center\",theme_advanced_fonts:\"Andale Mono=andale mono,times;Arial=arial,helvetica,sans-serif;Arial Black=arial black,avant garde;Book Antiqua=book antiqua,palatino;Comic Sans MS=comic sans ms,sans-serif;Courier New=courier new,courier;Georgia=georgia,palatino;Helvetica=helvetica;Impact=impact,chicago;Symbol=symbol;Tahoma=tahoma,arial,helvetica,sans-serif;Terminal=terminal,monaco;Times New Roman=times new roman,times;Trebuchet MS=trebuchet ms,geneva;Verdana=verdana,geneva;Webdings=webdings;Wingdings=wingdings,zapf dingbats\",theme_advanced_more_colors:1,theme_advanced_row_height:23,theme_advanced_resize_horizontal:1,theme_advanced_resizing_use_cookie:1,theme_advanced_font_sizes:\"1,2,3,4,5,6,7\",theme_advanced_font_selector:\"span\",theme_advanced_show_current_color:0,readonly:j.settings.readonly},j.settings);if(!m.font_size_style_values){m.font_size_style_values=\"8pt,10pt,12pt,14pt,18pt,24pt,36pt\"}if(e.is(m.theme_advanced_font_sizes,\"string\")){m.font_size_style_values=e.explode(m.font_size_style_values);m.font_size_classes=e.explode(m.font_size_classes||\"\");n={};j.settings.theme_advanced_font_sizes=m.theme_advanced_font_sizes;f(j.getParam(\"theme_advanced_font_sizes\",\"\",\"hash\"),function(q,p){var o;if(p==q&&q>=1&&q<=7){p=q+\" (\"+l.sizes[q-1]+\"pt)\";o=m.font_size_classes[q-1];q=m.font_size_style_values[q-1]||(l.sizes[q-1]+\"pt\")}if(/^\\s*\\./.test(q)){o=q.replace(/\\./g,\"\")}n[p]=o?{\"class\":o}:{fontSize:q}});m.theme_advanced_font_sizes=n}if((i=m.theme_advanced_path_location)&&i!=\"none\"){m.theme_advanced_statusbar_location=m.theme_advanced_path_location}if(m.theme_advanced_statusbar_location==\"none\"){m.theme_advanced_statusbar_location=0}if(j.settings.content_css!==false){j.contentCSS.push(j.baseURI.toAbsolute(k+\"/skins/\"+j.settings.skin+\"/content.css\"))}j.onInit.add(function(){if(!j.settings.readonly){j.onNodeChange.add(l._nodeChanged,l);j.onKeyUp.add(l._updateUndoStatus,l);j.onMouseUp.add(l._updateUndoStatus,l);j.dom.bind(j.dom.getRoot(),\"dragend\",function(){l._updateUndoStatus(j)})}});j.onSetProgressState.add(function(q,o,r){var s,t=q.id,p;if(o){l.progressTimer=setTimeout(function(){s=q.getContainer();s=s.insertBefore(d.create(\"DIV\",{style:\"position:relative\"}),s.firstChild);p=d.get(q.id+\"_tbl\");d.add(s,\"div\",{id:t+\"_blocker\",\"class\":\"mceBlocker\",style:{width:p.clientWidth+2,height:p.clientHeight+2}});d.add(s,\"div\",{id:t+\"_progress\",\"class\":\"mceProgress\",style:{left:p.clientWidth/2,top:p.clientHeight/2}})},r||0)}else{d.remove(t+\"_blocker\");d.remove(t+\"_progress\");clearTimeout(l.progressTimer)}});d.loadCSS(m.editor_css?j.documentBaseURI.toAbsolute(m.editor_css):k+\"/skins/\"+j.settings.skin+\"/ui.css\");if(m.skin_variant){d.loadCSS(k+\"/skins/\"+j.settings.skin+\"/ui_\"+m.skin_variant+\".css\")}},_isHighContrast:function(){var i,j=d.add(d.getRoot(),\"div\",{style:\"background-color: rgb(171,239,86);\"});i=(d.getStyle(j,\"background-color\",true)+\"\").toLowerCase().replace(/ /g,\"\");d.remove(j);return i!=\"rgb(171,239,86)\"&&i!=\"#abef56\"},createControl:function(l,i){var j,k;if(k=i.createControl(l)){return k}switch(l){case\"styleselect\":return this._createStyleSelect();case\"formatselect\":return this._createBlockFormats();case\"fontselect\":return this._createFontSelect();case\"fontsizeselect\":return this._createFontSizeSelect();case\"forecolor\":return this._createForeColorMenu();case\"backcolor\":return this._createBackColorMenu()}if((j=this.controls[l])){return i.createButton(l,{title:\"advanced.\"+j[0],cmd:j[1],ui:j[2],value:j[3]})}},execCommand:function(k,j,l){var i=this[\"_\"+k];if(i){i.call(this,j,l);return true}return false},_importClasses:function(k){var i=this.editor,j=i.controlManager.get(\"styleselect\");if(j.getLength()==0){f(i.dom.getClasses(),function(n,l){var m=\"style_\"+l;i.formatter.register(m,{inline:\"span\",attributes:{\"class\":n[\"class\"]},selector:\"*\"});j.add(n[\"class\"],m)})}},_createStyleSelect:function(m){var k=this,i=k.editor,j=i.controlManager,l;l=j.createListBox(\"styleselect\",{title:\"advanced.style_select\",onselect:function(o){var p,n=[];f(l.items,function(q){n.push(q.value)});i.focus();i.undoManager.add();p=i.formatter.matchAll(n);if(!o||p[0]==o){if(p[0]){i.formatter.remove(p[0])}}else{i.formatter.apply(o)}i.undoManager.add();i.nodeChanged();return false}});i.onInit.add(function(){var o=0,n=i.getParam(\"style_formats\");if(n){f(n,function(p){var q,r=0;f(p,function(){r++});if(r>1){q=p.name=p.name||\"style_\"+(o++);i.formatter.register(q,p);l.add(p.title,q)}else{l.add(p.title)}})}else{f(i.getParam(\"theme_advanced_styles\",\"\",\"hash\"),function(r,q){var p;if(r){p=\"style_\"+(o++);i.formatter.register(p,{inline:\"span\",classes:r,selector:\"*\"});l.add(k.editor.translate(q),p)}})}});if(l.getLength()==0){l.onPostRender.add(function(o,p){if(!l.NativeListBox){b.add(p.id+\"_text\",\"focus\",k._importClasses,k);b.add(p.id+\"_text\",\"mousedown\",k._importClasses,k);b.add(p.id+\"_open\",\"focus\",k._importClasses,k);b.add(p.id+\"_open\",\"mousedown\",k._importClasses,k)}else{b.add(p.id,\"focus\",k._importClasses,k)}})}return l},_createFontSelect:function(){var k,j=this,i=j.editor;k=i.controlManager.createListBox(\"fontselect\",{title:\"advanced.fontdefault\",onselect:function(l){var m=k.items[k.selectedIndex];if(!l&&m){i.execCommand(\"FontName\",false,m.value);return}i.execCommand(\"FontName\",false,l);k.select(function(n){return l==n});if(m&&m.value==l){k.select(null)}return false}});if(k){f(i.getParam(\"theme_advanced_fonts\",j.settings.theme_advanced_fonts,\"hash\"),function(m,l){k.add(i.translate(l),m,{style:m.indexOf(\"dings\")==-1?\"font-family:\"+m:\"\"})})}return k},_createFontSizeSelect:function(){var m=this,k=m.editor,n,l=0,j=[];n=k.controlManager.createListBox(\"fontsizeselect\",{title:\"advanced.font_size\",onselect:function(i){var o=n.items[n.selectedIndex];if(!i&&o){o=o.value;if(o[\"class\"]){k.formatter.toggle(\"fontsize_class\",{value:o[\"class\"]});k.undoManager.add();k.nodeChanged()}else{k.execCommand(\"FontSize\",false,o.fontSize)}return}if(i[\"class\"]){k.focus();k.undoManager.add();k.formatter.toggle(\"fontsize_class\",{value:i[\"class\"]});k.undoManager.add();k.nodeChanged()}else{k.execCommand(\"FontSize\",false,i.fontSize)}n.select(function(p){return i==p});if(o&&(o.value.fontSize==i.fontSize||o.value[\"class\"]==i[\"class\"])){n.select(null)}return false}});if(n){f(m.settings.theme_advanced_font_sizes,function(o,i){var p=o.fontSize;if(p>=1&&p<=7){p=m.sizes[parseInt(p)-1]+\"pt\"}n.add(i,o,{style:\"font-size:\"+p,\"class\":\"mceFontSize\"+(l++)+(\" \"+(o[\"class\"]||\"\"))})})}return n},_createBlockFormats:function(){var k,i={p:\"advanced.paragraph\",address:\"advanced.address\",pre:\"advanced.pre\",h1:\"advanced.h1\",h2:\"advanced.h2\",h3:\"advanced.h3\",h4:\"advanced.h4\",h5:\"advanced.h5\",h6:\"advanced.h6\",div:\"advanced.div\",blockquote:\"advanced.blockquote\",code:\"advanced.code\",dt:\"advanced.dt\",dd:\"advanced.dd\",samp:\"advanced.samp\"},j=this;k=j.editor.controlManager.createListBox(\"formatselect\",{title:\"advanced.block\",onselect:function(l){j.editor.execCommand(\"FormatBlock\",false,l);return false}});if(k){f(j.editor.getParam(\"theme_advanced_blockformats\",j.settings.theme_advanced_blockformats,\"hash\"),function(m,l){k.add(j.editor.translate(l!=m?l:i[m]),m,{\"class\":\"mce_formatPreview mce_\"+m})})}return k},_createForeColorMenu:function(){var m,j=this,k=j.settings,l={},i;if(k.theme_advanced_more_colors){l.more_colors_func=function(){j._mceColorPicker(0,{color:m.value,func:function(n){m.setColor(n)}})}}if(i=k.theme_advanced_text_colors){l.colors=i}if(k.theme_advanced_default_foreground_color){l.default_color=k.theme_advanced_default_foreground_color}l.title=\"advanced.forecolor_desc\";l.cmd=\"ForeColor\";l.scope=this;m=j.editor.controlManager.createColorSplitButton(\"forecolor\",l);return m},_createBackColorMenu:function(){var m,j=this,k=j.settings,l={},i;if(k.theme_advanced_more_colors){l.more_colors_func=function(){j._mceColorPicker(0,{color:m.value,func:function(n){m.setColor(n)}})}}if(i=k.theme_advanced_background_colors){l.colors=i}if(k.theme_advanced_default_background_color){l.default_color=k.theme_advanced_default_background_color}l.title=\"advanced.backcolor_desc\";l.cmd=\"HiliteColor\";l.scope=this;m=j.editor.controlManager.createColorSplitButton(\"backcolor\",l);return m},renderUI:function(k){var m,l,q,v=this,r=v.editor,w=v.settings,u,j,i;if(r.settings){r.settings.aria_label=w.aria_label+r.getLang(\"advanced.help_shortcut\")}m=j=d.create(\"span\",{role:\"application\",\"aria-labelledby\":r.id+\"_voice\",id:r.id+\"_parent\",\"class\":\"mceEditor \"+r.settings.skin+\"Skin\"+(w.skin_variant?\" \"+r.settings.skin+\"Skin\"+v._ufirst(w.skin_variant):\"\")});d.add(m,\"span\",{\"class\":\"mceVoiceLabel\",style:\"display:none;\",id:r.id+\"_voice\"},w.aria_label);if(!d.boxModel){m=d.add(m,\"div\",{\"class\":\"mceOldBoxModel\"})}m=u=d.add(m,\"table\",{role:\"presentation\",id:r.id+\"_tbl\",\"class\":\"mceLayout\",cellSpacing:0,cellPadding:0});m=q=d.add(m,\"tbody\");switch((w.theme_advanced_layout_manager||\"\").toLowerCase()){case\"rowlayout\":l=v._rowLayout(w,q,k);break;case\"customlayout\":l=r.execCallback(\"theme_advanced_custom_layout\",w,q,k,j);break;default:l=v._simpleLayout(w,q,k,j)}m=k.targetNode;i=u.rows;d.addClass(i[0],\"mceFirst\");d.addClass(i[i.length-1],\"mceLast\");f(d.select(\"tr\",q),function(o){d.addClass(o.firstChild,\"mceFirst\");d.addClass(o.childNodes[o.childNodes.length-1],\"mceLast\")});if(d.get(w.theme_advanced_toolbar_container)){d.get(w.theme_advanced_toolbar_container).appendChild(j)}else{d.insertAfter(j,m)}b.add(r.id+\"_path_row\",\"click\",function(n){n=n.target;if(n.nodeName==\"A\"){v._sel(n.className.replace(/^.*mcePath_([0-9]+).*$/,\"$1\"));return b.cancel(n)}});if(!r.getParam(\"accessibility_focus\")){b.add(d.add(j,\"a\",{href:\"#\"},\"<!-- IE -->\"),\"focus\",function(){tinyMCE.get(r.id).focus()})}if(w.theme_advanced_toolbar_location==\"external\"){k.deltaHeight=0}v.deltaHeight=k.deltaHeight;k.targetNode=null;r.onKeyDown.add(function(p,n){var s=121,o=122;if(n.altKey){if(n.keyCode===s){if(e.isWebKit){window.focus()}v.toolbarGroup.focus();return b.cancel(n)}else{if(n.keyCode===o){d.get(p.id+\"_path_row\").focus();return b.cancel(n)}}}});r.addShortcut(\"alt+0\",\"\",\"mceShortcuts\",v);return{iframeContainer:l,editorContainer:r.id+\"_parent\",sizeContainer:u,deltaHeight:k.deltaHeight}},getInfo:function(){return{longname:\"Advanced theme\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",version:e.majorVersion+\".\"+e.minorVersion}},resizeBy:function(i,j){var k=d.get(this.editor.id+\"_ifr\");this.resizeTo(k.clientWidth+i,k.clientHeight+j)},resizeTo:function(i,m,k){var j=this.editor,l=this.settings,n=d.get(j.id+\"_tbl\"),o=d.get(j.id+\"_ifr\");i=Math.max(l.theme_advanced_resizing_min_width||100,i);m=Math.max(l.theme_advanced_resizing_min_height||100,m);i=Math.min(l.theme_advanced_resizing_max_width||65535,i);m=Math.min(l.theme_advanced_resizing_max_height||65535,m);d.setStyle(n,\"height\",\"\");d.setStyle(o,\"height\",m);if(l.theme_advanced_resize_horizontal){d.setStyle(n,\"width\",\"\");d.setStyle(o,\"width\",i);if(i<n.clientWidth){i=n.clientWidth;d.setStyle(o,\"width\",n.clientWidth)}}if(k&&l.theme_advanced_resizing_use_cookie){a.setHash(\"TinyMCE_\"+j.id+\"_size\",{cw:i,ch:m})}},destroy:function(){var i=this.editor.id;b.clear(i+\"_resize\");b.clear(i+\"_path_row\");b.clear(i+\"_external_close\")},_simpleLayout:function(y,r,k,i){var x=this,u=x.editor,v=y.theme_advanced_toolbar_location,m=y.theme_advanced_statusbar_location,l,j,q,w;if(y.readonly){l=d.add(r,\"tr\");l=j=d.add(l,\"td\",{\"class\":\"mceIframeContainer\"});return j}if(v==\"top\"){x._addToolbars(r,k)}if(v==\"external\"){l=w=d.create(\"div\",{style:\"position:relative\"});l=d.add(l,\"div\",{id:u.id+\"_external\",\"class\":\"mceExternalToolbar\"});d.add(l,\"a\",{id:u.id+\"_external_close\",href:\"javascript:;\",\"class\":\"mceExternalClose\"});l=d.add(l,\"table\",{id:u.id+\"_tblext\",cellSpacing:0,cellPadding:0});q=d.add(l,\"tbody\");if(i.firstChild.className==\"mceOldBoxModel\"){i.firstChild.appendChild(w)}else{i.insertBefore(w,i.firstChild)}x._addToolbars(q,k);u.onMouseUp.add(function(){var o=d.get(u.id+\"_external\");d.show(o);d.hide(g);var n=b.add(u.id+\"_external_close\",\"click\",function(){d.hide(u.id+\"_external\");b.remove(u.id+\"_external_close\",\"click\",n)});d.show(o);d.setStyle(o,\"top\",0-d.getRect(u.id+\"_tblext\").h-1);d.hide(o);d.show(o);o.style.filter=\"\";g=u.id+\"_external\";o=null})}if(m==\"top\"){x._addStatusBar(r,k)}if(!y.theme_advanced_toolbar_container){l=d.add(r,\"tr\");l=j=d.add(l,\"td\",{\"class\":\"mceIframeContainer\"})}if(v==\"bottom\"){x._addToolbars(r,k)}if(m==\"bottom\"){x._addStatusBar(r,k)}return j},_rowLayout:function(w,m,k){var v=this,p=v.editor,u,x,i=p.controlManager,l,j,r,q;u=w.theme_advanced_containers_default_class||\"\";x=w.theme_advanced_containers_default_align||\"center\";f(c(w.theme_advanced_containers||\"\"),function(s,o){var n=w[\"theme_advanced_container_\"+s]||\"\";switch(s.toLowerCase()){case\"mceeditor\":l=d.add(m,\"tr\");l=j=d.add(l,\"td\",{\"class\":\"mceIframeContainer\"});break;case\"mceelementpath\":v._addStatusBar(m,k);break;default:q=(w[\"theme_advanced_container_\"+s+\"_align\"]||x).toLowerCase();q=\"mce\"+v._ufirst(q);l=d.add(d.add(m,\"tr\"),\"td\",{\"class\":\"mceToolbar \"+(w[\"theme_advanced_container_\"+s+\"_class\"]||u)+\" \"+q||x});r=i.createToolbar(\"toolbar\"+o);v._addControls(n,r);d.setHTML(l,r.renderHTML());k.deltaHeight-=w.theme_advanced_row_height}});return j},_addControls:function(j,i){var k=this,l=k.settings,m,n=k.editor.controlManager;if(l.theme_advanced_disable&&!k._disabled){m={};f(c(l.theme_advanced_disable),function(o){m[o]=1});k._disabled=m}else{m=k._disabled}f(c(j),function(p){var o;if(m&&m[p]){return}if(p==\"tablecontrols\"){f([\"table\",\"|\",\"row_props\",\"cell_props\",\"|\",\"row_before\",\"row_after\",\"delete_row\",\"|\",\"col_before\",\"col_after\",\"delete_col\",\"|\",\"split_cells\",\"merge_cells\"],function(q){q=k.createControl(q,n);if(q){i.add(q)}});return}o=k.createControl(p,n);if(o){i.add(o)}})},_addToolbars:function(x,k){var A=this,p,m,r=A.editor,B=A.settings,z,j=r.controlManager,u,l,q=[],y,w;w=j.createToolbarGroup(\"toolbargroup\",{name:r.getLang(\"advanced.toolbar\"),tab_focus_toolbar:r.getParam(\"theme_advanced_tab_focus_toolbar\")});A.toolbarGroup=w;y=B.theme_advanced_toolbar_align.toLowerCase();y=\"mce\"+A._ufirst(y);l=d.add(d.add(x,\"tr\",{role:\"presentation\"}),\"td\",{\"class\":\"mceToolbar \"+y,role:\"presentation\"});for(p=1;(z=B[\"theme_advanced_buttons\"+p]);p++){m=j.createToolbar(\"toolbar\"+p,{\"class\":\"mceToolbarRow\"+p});if(B[\"theme_advanced_buttons\"+p+\"_add\"]){z+=\",\"+B[\"theme_advanced_buttons\"+p+\"_add\"]}if(B[\"theme_advanced_buttons\"+p+\"_add_before\"]){z=B[\"theme_advanced_buttons\"+p+\"_add_before\"]+\",\"+z}A._addControls(z,m);w.add(m);k.deltaHeight-=B.theme_advanced_row_height}q.push(w.renderHTML());q.push(d.createHTML(\"a\",{href:\"#\",accesskey:\"z\",title:r.getLang(\"advanced.toolbar_focus\"),onfocus:\"tinyMCE.getInstanceById('\"+r.id+\"').focus();\"},\"<!-- IE -->\"));d.setHTML(l,q.join(\"\"))},_addStatusBar:function(m,j){var k,v=this,p=v.editor,w=v.settings,i,q,u,l;k=d.add(m,\"tr\");k=l=d.add(k,\"td\",{\"class\":\"mceStatusbar\"});k=d.add(k,\"div\",{id:p.id+\"_path_row\",role:\"group\",\"aria-labelledby\":p.id+\"_path_voice\"});if(w.theme_advanced_path){d.add(k,\"span\",{id:p.id+\"_path_voice\"},p.translate(\"advanced.path\"));d.add(k,\"span\",{},\": \")}else{d.add(k,\"span\",{},\"&#160;\")}if(w.theme_advanced_resizing){d.add(l,\"a\",{id:p.id+\"_resize\",href:\"javascript:;\",onclick:\"return false;\",\"class\":\"mceResize\",tabIndex:\"-1\"});if(w.theme_advanced_resizing_use_cookie){p.onPostRender.add(function(){var n=a.getHash(\"TinyMCE_\"+p.id+\"_size\"),r=d.get(p.id+\"_tbl\");if(!n){return}v.resizeTo(n.cw,n.ch)})}p.onPostRender.add(function(){b.add(p.id+\"_resize\",\"click\",function(n){n.preventDefault()});b.add(p.id+\"_resize\",\"mousedown\",function(D){var t,r,s,o,C,z,A,F,n,E,x;function y(G){G.preventDefault();n=A+(G.screenX-C);E=F+(G.screenY-z);v.resizeTo(n,E)}function B(G){b.remove(d.doc,\"mousemove\",t);b.remove(p.getDoc(),\"mousemove\",r);b.remove(d.doc,\"mouseup\",s);b.remove(p.getDoc(),\"mouseup\",o);n=A+(G.screenX-C);E=F+(G.screenY-z);v.resizeTo(n,E,true)}D.preventDefault();C=D.screenX;z=D.screenY;x=d.get(v.editor.id+\"_ifr\");A=n=x.clientWidth;F=E=x.clientHeight;t=b.add(d.doc,\"mousemove\",y);r=b.add(p.getDoc(),\"mousemove\",y);s=b.add(d.doc,\"mouseup\",B);o=b.add(p.getDoc(),\"mouseup\",B)})})}j.deltaHeight-=21;k=m=null},_updateUndoStatus:function(j){var i=j.controlManager,k=j.undoManager;i.setDisabled(\"undo\",!k.hasUndo()&&!k.typing);i.setDisabled(\"redo\",!k.hasRedo())},_nodeChanged:function(m,r,D,q,E){var y=this,C,F=0,x,G,z=y.settings,w,k,u,B,l,j,i;e.each(y.stateControls,function(n){r.setActive(n,m.queryCommandState(y.controls[n][1]))});function o(p){var s,n=E.parents,t=p;if(typeof(p)==\"string\"){t=function(v){return v.nodeName==p}}for(s=0;s<n.length;s++){if(t(n[s])){return n[s]}}}r.setActive(\"visualaid\",m.hasVisual);y._updateUndoStatus(m);r.setDisabled(\"outdent\",!m.queryCommandState(\"Outdent\"));C=o(\"A\");if(G=r.get(\"link\")){if(!C||!C.name){G.setDisabled(!C&&q);G.setActive(!!C)}}if(G=r.get(\"unlink\")){G.setDisabled(!C&&q);G.setActive(!!C&&!C.name)}if(G=r.get(\"anchor\")){G.setActive(!q&&!!C&&C.name)}C=o(\"IMG\");if(G=r.get(\"image\")){G.setActive(!q&&!!C&&D.className.indexOf(\"mceItem\")==-1)}if(G=r.get(\"styleselect\")){y._importClasses();j=[];f(G.items,function(n){j.push(n.value)});i=m.formatter.matchAll(j);G.select(i[0])}if(G=r.get(\"formatselect\")){C=o(d.isBlock);if(C){G.select(C.nodeName.toLowerCase())}}o(function(p){if(p.nodeName===\"SPAN\"){if(!w&&p.className){w=p.className}}if(m.dom.is(p,z.theme_advanced_font_selector)){if(!k&&p.style.fontSize){k=p.style.fontSize}if(!u&&p.style.fontFamily){u=p.style.fontFamily.replace(/[\\\"\\']+/g,\"\").replace(/^([^,]+).*/,\"$1\").toLowerCase()}if(!B&&p.style.color){B=p.style.color}if(!l&&p.style.backgroundColor){l=p.style.backgroundColor}}return false});if(G=r.get(\"fontselect\")){G.select(function(n){return n.replace(/^([^,]+).*/,\"$1\").toLowerCase()==u})}if(G=r.get(\"fontsizeselect\")){if(z.theme_advanced_runtime_fontsize&&!k&&!w){k=m.dom.getStyle(D,\"fontSize\",true)}G.select(function(n){if(n.fontSize&&n.fontSize===k){return true}if(n[\"class\"]&&n[\"class\"]===w){return true}})}if(z.theme_advanced_show_current_color){function A(p,n){if(G=r.get(p)){if(!n){n=G.settings.default_color}if(n!==G.value){G.displayColor(n)}}}A(\"forecolor\",B);A(\"backcolor\",l)}if(z.theme_advanced_show_current_color){function A(p,n){if(G=r.get(p)){if(!n){n=G.settings.default_color}if(n!==G.value){G.displayColor(n)}}}A(\"forecolor\",B);A(\"backcolor\",l)}if(z.theme_advanced_path&&z.theme_advanced_statusbar_location){C=d.get(m.id+\"_path\")||d.add(m.id+\"_path_row\",\"span\",{id:m.id+\"_path\"});if(y.statusKeyboardNavigation){y.statusKeyboardNavigation.destroy();y.statusKeyboardNavigation=null}d.setHTML(C,\"\");o(function(H){var p=H.nodeName.toLowerCase(),s,v,t=\"\";if(H.nodeType!=1||p===\"br\"||H.getAttribute(\"data-mce-bogus\")||d.hasClass(H,\"mceItemHidden\")||d.hasClass(H,\"mceItemRemoved\")){return}if(e.isIE&&H.scopeName!==\"HTML\"){p=H.scopeName+\":\"+p}p=p.replace(/mce\\:/g,\"\");switch(p){case\"b\":p=\"strong\";break;case\"i\":p=\"em\";break;case\"img\":if(x=d.getAttrib(H,\"src\")){t+=\"src: \"+x+\" \"}break;case\"a\":if(x=d.getAttrib(H,\"name\")){t+=\"name: \"+x+\" \";p+=\"#\"+x}if(x=d.getAttrib(H,\"href\")){t+=\"href: \"+x+\" \"}break;case\"font\":if(x=d.getAttrib(H,\"face\")){t+=\"font: \"+x+\" \"}if(x=d.getAttrib(H,\"size\")){t+=\"size: \"+x+\" \"}if(x=d.getAttrib(H,\"color\")){t+=\"color: \"+x+\" \"}break;case\"span\":if(x=d.getAttrib(H,\"style\")){t+=\"style: \"+x+\" \"}break}if(x=d.getAttrib(H,\"id\")){t+=\"id: \"+x+\" \"}if(x=H.className){x=x.replace(/\\b\\s*(webkit|mce|Apple-)\\w+\\s*\\b/g,\"\");if(x){t+=\"class: \"+x+\" \";if(d.isBlock(H)||p==\"img\"||p==\"span\"){p+=\".\"+x}}}p=p.replace(/(html:)/g,\"\");p={name:p,node:H,title:t};y.onResolveName.dispatch(y,p);t=p.title;p=p.name;v=d.create(\"a\",{href:\"javascript:;\",role:\"button\",onmousedown:\"return false;\",title:t,\"class\":\"mcePath_\"+(F++)},p);if(C.hasChildNodes()){C.insertBefore(d.create(\"span\",{\"aria-hidden\":\"true\"},\"\\u00a0\\u00bb \"),C.firstChild);C.insertBefore(v,C.firstChild)}else{C.appendChild(v)}},m.getBody());if(d.select(\"a\",C).length>0){y.statusKeyboardNavigation=new e.ui.KeyboardNavigation({root:m.id+\"_path_row\",items:d.select(\"a\",C),excludeFromTabOrder:true,onCancel:function(){m.focus()}},d)}}},_sel:function(i){this.editor.execCommand(\"mceSelectNodeDepth\",false,i)},_mceInsertAnchor:function(k,j){var i=this.editor;i.windowManager.open({url:this.url+\"/anchor.htm\",width:320+parseInt(i.getLang(\"advanced.anchor_delta_width\",0)),height:90+parseInt(i.getLang(\"advanced.anchor_delta_height\",0)),inline:true},{theme_url:this.url})},_mceCharMap:function(){var i=this.editor;i.windowManager.open({url:this.url+\"/charmap.htm\",width:550+parseInt(i.getLang(\"advanced.charmap_delta_width\",0)),height:260+parseInt(i.getLang(\"advanced.charmap_delta_height\",0)),inline:true},{theme_url:this.url})},_mceHelp:function(){var i=this.editor;i.windowManager.open({url:this.url+\"/about.htm\",width:480,height:380,inline:true},{theme_url:this.url})},_mceShortcuts:function(){var i=this.editor;i.windowManager.open({url:this.url+\"/shortcuts.htm\",width:480,height:380,inline:true},{theme_url:this.url})},_mceColorPicker:function(k,j){var i=this.editor;j=j||{};i.windowManager.open({url:this.url+\"/color_picker.htm\",width:375+parseInt(i.getLang(\"advanced.colorpicker_delta_width\",0)),height:250+parseInt(i.getLang(\"advanced.colorpicker_delta_height\",0)),close_previous:false,inline:true},{input_color:j.color,func:j.func,theme_url:this.url})},_mceCodeEditor:function(j,k){var i=this.editor;i.windowManager.open({url:this.url+\"/source_editor.htm\",width:parseInt(i.getParam(\"theme_advanced_source_editor_width\",720)),height:parseInt(i.getParam(\"theme_advanced_source_editor_height\",580)),inline:true,resizable:true,maximizable:true},{theme_url:this.url})},_mceImage:function(j,k){var i=this.editor;if(i.dom.getAttrib(i.selection.getNode(),\"class\").indexOf(\"mceItem\")!=-1){return}i.windowManager.open({url:this.url+\"/image.htm\",width:355+parseInt(i.getLang(\"advanced.image_delta_width\",0)),height:275+parseInt(i.getLang(\"advanced.image_delta_height\",0)),inline:true},{theme_url:this.url})},_mceLink:function(j,k){var i=this.editor;i.windowManager.open({url:this.url+\"/link.htm\",width:310+parseInt(i.getLang(\"advanced.link_delta_width\",0)),height:200+parseInt(i.getLang(\"advanced.link_delta_height\",0)),inline:true},{theme_url:this.url})},_mceNewDocument:function(){var i=this.editor;i.windowManager.confirm(\"advanced.newdocument\",function(j){if(j){i.execCommand(\"mceSetContent\",false,\"\")}})},_mceForeColor:function(){var i=this;this._mceColorPicker(0,{color:i.fgColor,func:function(j){i.fgColor=j;i.editor.execCommand(\"ForeColor\",false,j)}})},_mceBackColor:function(){var i=this;this._mceColorPicker(0,{color:i.bgColor,func:function(j){i.bgColor=j;i.editor.execCommand(\"HiliteColor\",false,j)}})},_ufirst:function(i){return i.substring(0,1).toUpperCase()+i.substring(1)}});e.ThemeManager.add(\"advanced\",e.themes.AdvancedTheme)}(tinymce));","Magento_Tinymce3/tiny_mce/themes/advanced/js/color_picker.js":"tinyMCEPopup.requireLangPack();\n\nvar detail = 50, strhex = \"0123456789abcdef\", i, isMouseDown = false, isMouseOver = false;\n\nvar colors = [\n\t\"#000000\",\"#000033\",\"#000066\",\"#000099\",\"#0000cc\",\"#0000ff\",\"#330000\",\"#330033\",\n\t\"#330066\",\"#330099\",\"#3300cc\",\"#3300ff\",\"#660000\",\"#660033\",\"#660066\",\"#660099\",\n\t\"#6600cc\",\"#6600ff\",\"#990000\",\"#990033\",\"#990066\",\"#990099\",\"#9900cc\",\"#9900ff\",\n\t\"#cc0000\",\"#cc0033\",\"#cc0066\",\"#cc0099\",\"#cc00cc\",\"#cc00ff\",\"#ff0000\",\"#ff0033\",\n\t\"#ff0066\",\"#ff0099\",\"#ff00cc\",\"#ff00ff\",\"#003300\",\"#003333\",\"#003366\",\"#003399\",\n\t\"#0033cc\",\"#0033ff\",\"#333300\",\"#333333\",\"#333366\",\"#333399\",\"#3333cc\",\"#3333ff\",\n\t\"#663300\",\"#663333\",\"#663366\",\"#663399\",\"#6633cc\",\"#6633ff\",\"#993300\",\"#993333\",\n\t\"#993366\",\"#993399\",\"#9933cc\",\"#9933ff\",\"#cc3300\",\"#cc3333\",\"#cc3366\",\"#cc3399\",\n\t\"#cc33cc\",\"#cc33ff\",\"#ff3300\",\"#ff3333\",\"#ff3366\",\"#ff3399\",\"#ff33cc\",\"#ff33ff\",\n\t\"#006600\",\"#006633\",\"#006666\",\"#006699\",\"#0066cc\",\"#0066ff\",\"#336600\",\"#336633\",\n\t\"#336666\",\"#336699\",\"#3366cc\",\"#3366ff\",\"#666600\",\"#666633\",\"#666666\",\"#666699\",\n\t\"#6666cc\",\"#6666ff\",\"#996600\",\"#996633\",\"#996666\",\"#996699\",\"#9966cc\",\"#9966ff\",\n\t\"#cc6600\",\"#cc6633\",\"#cc6666\",\"#cc6699\",\"#cc66cc\",\"#cc66ff\",\"#ff6600\",\"#ff6633\",\n\t\"#ff6666\",\"#ff6699\",\"#ff66cc\",\"#ff66ff\",\"#009900\",\"#009933\",\"#009966\",\"#009999\",\n\t\"#0099cc\",\"#0099ff\",\"#339900\",\"#339933\",\"#339966\",\"#339999\",\"#3399cc\",\"#3399ff\",\n\t\"#669900\",\"#669933\",\"#669966\",\"#669999\",\"#6699cc\",\"#6699ff\",\"#999900\",\"#999933\",\n\t\"#999966\",\"#999999\",\"#9999cc\",\"#9999ff\",\"#cc9900\",\"#cc9933\",\"#cc9966\",\"#cc9999\",\n\t\"#cc99cc\",\"#cc99ff\",\"#ff9900\",\"#ff9933\",\"#ff9966\",\"#ff9999\",\"#ff99cc\",\"#ff99ff\",\n\t\"#00cc00\",\"#00cc33\",\"#00cc66\",\"#00cc99\",\"#00cccc\",\"#00ccff\",\"#33cc00\",\"#33cc33\",\n\t\"#33cc66\",\"#33cc99\",\"#33cccc\",\"#33ccff\",\"#66cc00\",\"#66cc33\",\"#66cc66\",\"#66cc99\",\n\t\"#66cccc\",\"#66ccff\",\"#99cc00\",\"#99cc33\",\"#99cc66\",\"#99cc99\",\"#99cccc\",\"#99ccff\",\n\t\"#cccc00\",\"#cccc33\",\"#cccc66\",\"#cccc99\",\"#cccccc\",\"#ccccff\",\"#ffcc00\",\"#ffcc33\",\n\t\"#ffcc66\",\"#ffcc99\",\"#ffcccc\",\"#ffccff\",\"#00ff00\",\"#00ff33\",\"#00ff66\",\"#00ff99\",\n\t\"#00ffcc\",\"#00ffff\",\"#33ff00\",\"#33ff33\",\"#33ff66\",\"#33ff99\",\"#33ffcc\",\"#33ffff\",\n\t\"#66ff00\",\"#66ff33\",\"#66ff66\",\"#66ff99\",\"#66ffcc\",\"#66ffff\",\"#99ff00\",\"#99ff33\",\n\t\"#99ff66\",\"#99ff99\",\"#99ffcc\",\"#99ffff\",\"#ccff00\",\"#ccff33\",\"#ccff66\",\"#ccff99\",\n\t\"#ccffcc\",\"#ccffff\",\"#ffff00\",\"#ffff33\",\"#ffff66\",\"#ffff99\",\"#ffffcc\",\"#ffffff\"\n];\n\nvar named = {\n\t'#F0F8FF':'Alice Blue','#FAEBD7':'Antique White','#00FFFF':'Aqua','#7FFFD4':'Aquamarine','#F0FFFF':'Azure','#F5F5DC':'Beige',\n\t'#FFE4C4':'Bisque','#000000':'Black','#FFEBCD':'Blanched Almond','#0000FF':'Blue','#8A2BE2':'Blue Violet','#A52A2A':'Brown',\n\t'#DEB887':'Burly Wood','#5F9EA0':'Cadet Blue','#7FFF00':'Chartreuse','#D2691E':'Chocolate','#FF7F50':'Coral','#6495ED':'Cornflower Blue',\n\t'#FFF8DC':'Cornsilk','#DC143C':'Crimson','#00FFFF':'Cyan','#00008B':'Dark Blue','#008B8B':'Dark Cyan','#B8860B':'Dark Golden Rod',\n\t'#A9A9A9':'Dark Gray','#A9A9A9':'Dark Grey','#006400':'Dark Green','#BDB76B':'Dark Khaki','#8B008B':'Dark Magenta','#556B2F':'Dark Olive Green',\n\t'#FF8C00':'Darkorange','#9932CC':'Dark Orchid','#8B0000':'Dark Red','#E9967A':'Dark Salmon','#8FBC8F':'Dark Sea Green','#483D8B':'Dark Slate Blue',\n\t'#2F4F4F':'Dark Slate Gray','#2F4F4F':'Dark Slate Grey','#00CED1':'Dark Turquoise','#9400D3':'Dark Violet','#FF1493':'Deep Pink','#00BFFF':'Deep Sky Blue',\n\t'#696969':'Dim Gray','#696969':'Dim Grey','#1E90FF':'Dodger Blue','#B22222':'Fire Brick','#FFFAF0':'Floral White','#228B22':'Forest Green',\n\t'#FF00FF':'Fuchsia','#DCDCDC':'Gainsboro','#F8F8FF':'Ghost White','#FFD700':'Gold','#DAA520':'Golden Rod','#808080':'Gray','#808080':'Grey',\n\t'#008000':'Green','#ADFF2F':'Green Yellow','#F0FFF0':'Honey Dew','#FF69B4':'Hot Pink','#CD5C5C':'Indian Red','#4B0082':'Indigo','#FFFFF0':'Ivory',\n\t'#F0E68C':'Khaki','#E6E6FA':'Lavender','#FFF0F5':'Lavender Blush','#7CFC00':'Lawn Green','#FFFACD':'Lemon Chiffon','#ADD8E6':'Light Blue',\n\t'#F08080':'Light Coral','#E0FFFF':'Light Cyan','#FAFAD2':'Light Golden Rod Yellow','#D3D3D3':'Light Gray','#D3D3D3':'Light Grey','#90EE90':'Light Green',\n\t'#FFB6C1':'Light Pink','#FFA07A':'Light Salmon','#20B2AA':'Light Sea Green','#87CEFA':'Light Sky Blue','#778899':'Light Slate Gray','#778899':'Light Slate Grey',\n\t'#B0C4DE':'Light Steel Blue','#FFFFE0':'Light Yellow','#00FF00':'Lime','#32CD32':'Lime Green','#FAF0E6':'Linen','#FF00FF':'Magenta','#800000':'Maroon',\n\t'#66CDAA':'Medium Aqua Marine','#0000CD':'Medium Blue','#BA55D3':'Medium Orchid','#9370D8':'Medium Purple','#3CB371':'Medium Sea Green','#7B68EE':'Medium Slate Blue',\n\t'#00FA9A':'Medium Spring Green','#48D1CC':'Medium Turquoise','#C71585':'Medium Violet Red','#191970':'Midnight Blue','#F5FFFA':'Mint Cream','#FFE4E1':'Misty Rose','#FFE4B5':'Moccasin',\n\t'#FFDEAD':'Navajo White','#000080':'Navy','#FDF5E6':'Old Lace','#808000':'Olive','#6B8E23':'Olive Drab','#FFA500':'Orange','#FF4500':'Orange Red','#DA70D6':'Orchid',\n\t'#EEE8AA':'Pale Golden Rod','#98FB98':'Pale Green','#AFEEEE':'Pale Turquoise','#D87093':'Pale Violet Red','#FFEFD5':'Papaya Whip','#FFDAB9':'Peach Puff',\n\t'#CD853F':'Peru','#FFC0CB':'Pink','#DDA0DD':'Plum','#B0E0E6':'Powder Blue','#800080':'Purple','#FF0000':'Red','#BC8F8F':'Rosy Brown','#4169E1':'Royal Blue',\n\t'#8B4513':'Saddle Brown','#FA8072':'Salmon','#F4A460':'Sandy Brown','#2E8B57':'Sea Green','#FFF5EE':'Sea Shell','#A0522D':'Sienna','#C0C0C0':'Silver',\n\t'#87CEEB':'Sky Blue','#6A5ACD':'Slate Blue','#708090':'Slate Gray','#708090':'Slate Grey','#FFFAFA':'Snow','#00FF7F':'Spring Green',\n\t'#4682B4':'Steel Blue','#D2B48C':'Tan','#008080':'Teal','#D8BFD8':'Thistle','#FF6347':'Tomato','#40E0D0':'Turquoise','#EE82EE':'Violet',\n\t'#F5DEB3':'Wheat','#FFFFFF':'White','#F5F5F5':'White Smoke','#FFFF00':'Yellow','#9ACD32':'Yellow Green'\n};\n\nvar namedLookup = {};\n\nfunction init() {\n\tvar inputColor = convertRGBToHex(tinyMCEPopup.getWindowArg('input_color')), key, value;\n\n\ttinyMCEPopup.resizeToInnerSize();\n\n\tgeneratePicker();\n\tgenerateWebColors();\n\tgenerateNamedColors();\n\n\tif (inputColor) {\n\t\tchangeFinalColor(inputColor);\n\n\t\tcol = convertHexToRGB(inputColor);\n\n\t\tif (col)\n\t\t\tupdateLight(col.r, col.g, col.b);\n\t}\n\t\n\tfor (key in named) {\n\t\tvalue = named[key];\n\t\tnamedLookup[value.replace(/\\s+/, '').toLowerCase()] = key.replace(/#/, '').toLowerCase();\n\t}\n}\n\nfunction toHexColor(color) {\n\tvar matches, red, green, blue, toInt = parseInt;\n\n\tfunction hex(value) {\n\t\tvalue = parseInt(value).toString(16);\n\n\t\treturn value.length > 1 ? value : '0' + value; // Padd with leading zero\n\t};\n\n\tcolor = color.replace(/[\\s#]+/g, '').toLowerCase();\n\tcolor = namedLookup[color] || color;\n\tmatches = /^rgb\\((\\d{1,3}),(\\d{1,3}),(\\d{1,3})\\)|([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})|([a-f0-9])([a-f0-9])([a-f0-9])$/.exec(color);\n\n\tif (matches) {\n\t\tif (matches[1]) {\n\t\t\tred = toInt(matches[1]);\n\t\t\tgreen = toInt(matches[2]);\n\t\t\tblue = toInt(matches[3]);\n\t\t} else if (matches[4]) {\n\t\t\tred = toInt(matches[4], 16);\n\t\t\tgreen = toInt(matches[5], 16);\n\t\t\tblue = toInt(matches[6], 16);\n\t\t} else if (matches[7]) {\n\t\t\tred = toInt(matches[7] + matches[7], 16);\n\t\t\tgreen = toInt(matches[8] + matches[8], 16);\n\t\t\tblue = toInt(matches[9] + matches[9], 16);\n\t\t}\n\n\t\treturn '#' + hex(red) + hex(green) + hex(blue);\n\t}\n\n\treturn '';\n}\n\nfunction insertAction() {\n\tvar color = document.getElementById(\"color\").value, f = tinyMCEPopup.getWindowArg('func');\n\n\ttinyMCEPopup.restoreSelection();\n\n\tif (f)\n\t\tf(toHexColor(color));\n\n\ttinyMCEPopup.close();\n}\n\nfunction showColor(color, name) {\n\tif (name)\n\t\tdocument.getElementById(\"colorname\").innerHTML = name;\n\n\tdocument.getElementById(\"preview\").style.backgroundColor = color;\n\tdocument.getElementById(\"color\").value = color.toUpperCase();\n}\n\nfunction convertRGBToHex(col) {\n\tvar re = new RegExp(\"rgb\\\\s*\\\\(\\\\s*([0-9]+).*,\\\\s*([0-9]+).*,\\\\s*([0-9]+).*\\\\)\", \"gi\");\n\n\tif (!col)\n\t\treturn col;\n\n\tvar rgb = col.replace(re, \"$1,$2,$3\").split(',');\n\tif (rgb.length == 3) {\n\t\tr = parseInt(rgb[0]).toString(16);\n\t\tg = parseInt(rgb[1]).toString(16);\n\t\tb = parseInt(rgb[2]).toString(16);\n\n\t\tr = r.length == 1 ? '0' + r : r;\n\t\tg = g.length == 1 ? '0' + g : g;\n\t\tb = b.length == 1 ? '0' + b : b;\n\n\t\treturn \"#\" + r + g + b;\n\t}\n\n\treturn col;\n}\n\nfunction convertHexToRGB(col) {\n\tif (col.indexOf('#') != -1) {\n\t\tcol = col.replace(new RegExp('[^0-9A-F]', 'gi'), '');\n\n\t\tr = parseInt(col.substring(0, 2), 16);\n\t\tg = parseInt(col.substring(2, 4), 16);\n\t\tb = parseInt(col.substring(4, 6), 16);\n\n\t\treturn {r : r, g : g, b : b};\n\t}\n\n\treturn null;\n}\n\nfunction generatePicker() {\n\tvar el = document.getElementById('light'), h = '', i;\n\n\tfor (i = 0; i < detail; i++){\n\t\th += '<div id=\"gs'+i+'\" style=\"background-color:#000000; width:15px; height:3px; border-style:none; border-width:0px;\"'\n\t\t+ ' onclick=\"changeFinalColor(this.style.backgroundColor)\"'\n\t\t+ ' onmousedown=\"isMouseDown = true; return false;\"'\n\t\t+ ' onmouseup=\"isMouseDown = false;\"'\n\t\t+ ' onmousemove=\"if (isMouseDown && isMouseOver) changeFinalColor(this.style.backgroundColor); return false;\"'\n\t\t+ ' onmouseover=\"isMouseOver = true;\"'\n\t\t+ ' onmouseout=\"isMouseOver = false;\"'\n\t\t+ '></div>';\n\t}\n\n\tel.innerHTML = h;\n}\n\nfunction generateWebColors() {\n\tvar el = document.getElementById('webcolors'), h = '', i;\n\n\tif (el.className == 'generated')\n\t\treturn;\n\n\t// TODO: VoiceOver doesn't seem to support legend as a label referenced by labelledby.\n\th += '<div role=\"listbox\" aria-labelledby=\"webcolors_title\" tabindex=\"0\"><table role=\"presentation\" border=\"0\" cellspacing=\"1\" cellpadding=\"0\">'\n\t\t+ '<tr>';\n\n\tfor (i=0; i<colors.length; i++) {\n\t\th += '<td bgcolor=\"' + colors[i] + '\" width=\"10\" height=\"10\">'\n\t\t\t+ '<a href=\"javascript:insertAction();\" role=\"option\" tabindex=\"-1\" aria-labelledby=\"web_colors_' + i + '\" onfocus=\"showColor(\\'' + colors[i] + '\\');\" onmouseover=\"showColor(\\'' + colors[i] + '\\');\" style=\"display:block;width:10px;height:10px;overflow:hidden;\">';\n\t\tif (tinyMCEPopup.editor.forcedHighContrastMode) {\n\t\t\th += '<canvas class=\"mceColorSwatch\" height=\"10\" width=\"10\" data-color=\"' + colors[i] + '\"></canvas>';\n\t\t}\n\t\th += '<span class=\"mceVoiceLabel\" style=\"display:none;\" id=\"web_colors_' + i + '\">' + colors[i].toUpperCase() + '</span>';\n\t\th += '</a></td>';\n\t\tif ((i+1) % 18 == 0)\n\t\t\th += '</tr><tr>';\n\t}\n\n\th += '</table></div>';\n\n\tel.innerHTML = h;\n\tel.className = 'generated';\n\n\tpaintCanvas(el);\n\tenableKeyboardNavigation(el.firstChild);\n}\n\nfunction paintCanvas(el) {\n\ttinyMCEPopup.getWin().tinymce.each(tinyMCEPopup.dom.select('canvas.mceColorSwatch', el), function(canvas) {\n\t\tvar context;\n\t\tif (canvas.getContext && (context = canvas.getContext(\"2d\"))) {\n\t\t\tcontext.fillStyle = canvas.getAttribute('data-color');\n\t\t\tcontext.fillRect(0, 0, 10, 10);\n\t\t}\n\t});\n}\nfunction generateNamedColors() {\n\tvar el = document.getElementById('namedcolors'), h = '', n, v, i = 0;\n\n\tif (el.className == 'generated')\n\t\treturn;\n\n\tfor (n in named) {\n\t\tv = named[n];\n\t\th += '<a href=\"javascript:insertAction();\" role=\"option\" tabindex=\"-1\" aria-labelledby=\"named_colors_' + i + '\" onfocus=\"showColor(\\'' + n + '\\',\\'' + v + '\\');\" onmouseover=\"showColor(\\'' + n + '\\',\\'' + v + '\\');\" style=\"background-color: ' + n + '\">';\n\t\tif (tinyMCEPopup.editor.forcedHighContrastMode) {\n\t\t\th += '<canvas class=\"mceColorSwatch\" height=\"10\" width=\"10\" data-color=\"' + colors[i] + '\"></canvas>';\n\t\t}\n\t\th += '<span class=\"mceVoiceLabel\" style=\"display:none;\" id=\"named_colors_' + i + '\">' + v + '</span>';\n\t\th += '</a>';\n\t\ti++;\n\t}\n\n\tel.innerHTML = h;\n\tel.className = 'generated';\n\n\tpaintCanvas(el);\n\tenableKeyboardNavigation(el);\n}\n\nfunction enableKeyboardNavigation(el) {\n\ttinyMCEPopup.editor.windowManager.createInstance('tinymce.ui.KeyboardNavigation', {\n\t\troot: el,\n\t\titems: tinyMCEPopup.dom.select('a', el)\n\t}, tinyMCEPopup.dom);\n}\n\nfunction dechex(n) {\n\treturn strhex.charAt(Math.floor(n / 16)) + strhex.charAt(n % 16);\n}\n\nfunction computeColor(e) {\n\tvar x, y, partWidth, partDetail, imHeight, r, g, b, coef, i, finalCoef, finalR, finalG, finalB, pos = tinyMCEPopup.dom.getPos(e.target);\n\n\tx = e.offsetX ? e.offsetX : (e.target ? e.clientX - pos.x : 0);\n\ty = e.offsetY ? e.offsetY : (e.target ? e.clientY - pos.y : 0);\n\n\tpartWidth = document.getElementById('colors').width / 6;\n\tpartDetail = detail / 2;\n\timHeight = document.getElementById('colors').height;\n\n\tr = (x >= 0)*(x < partWidth)*255 + (x >= partWidth)*(x < 2*partWidth)*(2*255 - x * 255 / partWidth) + (x >= 4*partWidth)*(x < 5*partWidth)*(-4*255 + x * 255 / partWidth) + (x >= 5*partWidth)*(x < 6*partWidth)*255;\n\tg = (x >= 0)*(x < partWidth)*(x * 255 / partWidth) + (x >= partWidth)*(x < 3*partWidth)*255\t+ (x >= 3*partWidth)*(x < 4*partWidth)*(4*255 - x * 255 / partWidth);\n\tb = (x >= 2*partWidth)*(x < 3*partWidth)*(-2*255 + x * 255 / partWidth) + (x >= 3*partWidth)*(x < 5*partWidth)*255 + (x >= 5*partWidth)*(x < 6*partWidth)*(6*255 - x * 255 / partWidth);\n\n\tcoef = (imHeight - y) / imHeight;\n\tr = 128 + (r - 128) * coef;\n\tg = 128 + (g - 128) * coef;\n\tb = 128 + (b - 128) * coef;\n\n\tchangeFinalColor('#' + dechex(r) + dechex(g) + dechex(b));\n\tupdateLight(r, g, b);\n}\n\nfunction updateLight(r, g, b) {\n\tvar i, partDetail = detail / 2, finalCoef, finalR, finalG, finalB, color;\n\n\tfor (i=0; i<detail; i++) {\n\t\tif ((i>=0) && (i<partDetail)) {\n\t\t\tfinalCoef = i / partDetail;\n\t\t\tfinalR = dechex(255 - (255 - r) * finalCoef);\n\t\t\tfinalG = dechex(255 - (255 - g) * finalCoef);\n\t\t\tfinalB = dechex(255 - (255 - b) * finalCoef);\n\t\t} else {\n\t\t\tfinalCoef = 2 - i / partDetail;\n\t\t\tfinalR = dechex(r * finalCoef);\n\t\t\tfinalG = dechex(g * finalCoef);\n\t\t\tfinalB = dechex(b * finalCoef);\n\t\t}\n\n\t\tcolor = finalR + finalG + finalB;\n\n\t\tsetCol('gs' + i, '#'+color);\n\t}\n}\n\nfunction changeFinalColor(color) {\n\tif (color.indexOf('#') == -1)\n\t\tcolor = convertRGBToHex(color);\n\n\tsetCol('preview', color);\n\tdocument.getElementById('color').value = color;\n}\n\nfunction setCol(e, c) {\n\ttry {\n\t\tdocument.getElementById(e).style.backgroundColor = c;\n\t} catch (ex) {\n\t\t// Ignore IE warning\n\t}\n}\n\ntinyMCEPopup.onInit.add(init);\n","Magento_Tinymce3/tiny_mce/themes/advanced/js/about.js":"tinyMCEPopup.requireLangPack();\n\nfunction init() {\n\tvar ed, tcont;\n\n\ttinyMCEPopup.resizeToInnerSize();\n\ted = tinyMCEPopup.editor;\n\n\t// Give FF some time\n\twindow.setTimeout(insertHelpIFrame, 10);\n\n\ttcont = document.getElementById('plugintablecontainer');\n\tdocument.getElementById('plugins_tab').style.display = 'none';\n\n\tvar html = \"\";\n\thtml += '<table id=\"plugintable\">';\n\thtml += '<thead>';\n\thtml += '<tr>';\n\thtml += '<td>' + ed.getLang('advanced_dlg.about_plugin') + '</td>';\n\thtml += '<td>' + ed.getLang('advanced_dlg.about_author') + '</td>';\n\thtml += '<td>' + ed.getLang('advanced_dlg.about_version') + '</td>';\n\thtml += '</tr>';\n\thtml += '</thead>';\n\thtml += '<tbody>';\n\n\ttinymce.each(ed.plugins, function(p, n) {\n\t\tvar info;\n\n\t\tif (!p.getInfo)\n\t\t\treturn;\n\n\t\thtml += '<tr>';\n\n\t\tinfo = p.getInfo();\n\n\t\tif (info.infourl != null && info.infourl != '')\n\t\t\thtml += '<td width=\"50%\" title=\"' + n + '\"><a href=\"' + info.infourl + '\" target=\"_blank\">' + info.longname + '</a></td>';\n\t\telse\n\t\t\thtml += '<td width=\"50%\" title=\"' + n + '\">' + info.longname + '</td>';\n\n\t\tif (info.authorurl != null && info.authorurl != '')\n\t\t\thtml += '<td width=\"35%\"><a href=\"' + info.authorurl + '\" target=\"_blank\">' + info.author + '</a></td>';\n\t\telse\n\t\t\thtml += '<td width=\"35%\">' + info.author + '</td>';\n\n\t\thtml += '<td width=\"15%\">' + info.version + '</td>';\n\t\thtml += '</tr>';\n\n\t\tdocument.getElementById('plugins_tab').style.display = '';\n\n\t});\n\n\thtml += '</tbody>';\n\thtml += '</table>';\n\n\ttcont.innerHTML = html;\n\n\ttinyMCEPopup.dom.get('version').innerHTML = tinymce.majorVersion + \".\" + tinymce.minorVersion;\n\ttinyMCEPopup.dom.get('date').innerHTML = tinymce.releaseDate;\n}\n\nfunction insertHelpIFrame() {\n\tvar html;\n\n\tif (tinyMCEPopup.getParam('docs_url')) {\n\t\thtml = '<iframe width=\"100%\" height=\"300\" src=\"' + tinyMCEPopup.editor.baseURI.toAbsolute(tinyMCEPopup.getParam('docs_url')) + '\"></iframe>';\n\t\tdocument.getElementById('iframecontainer').innerHTML = html;\n\t\tdocument.getElementById('help_tab').style.display = 'block';\n\t\tdocument.getElementById('help_tab').setAttribute(\"aria-hidden\", \"false\");\n\t}\n}\n\ntinyMCEPopup.onInit.add(init);\n","Magento_Tinymce3/tiny_mce/themes/advanced/js/link.js":"tinyMCEPopup.requireLangPack();\n\nvar LinkDialog = {\n\tpreInit : function() {\n\t\tvar url;\n\n\t\tif (url = tinyMCEPopup.getParam(\"external_link_list_url\"))\n\t\t\tdocument.write('<script language=\"javascript\" type=\"text/javascript\" src=\"' + tinyMCEPopup.editor.documentBaseURI.toAbsolute(url) + '\"></script>');\n\t},\n\n\tinit : function() {\n\t\tvar f = document.forms[0], ed = tinyMCEPopup.editor;\n\n\t\t// Setup browse button\n\t\tdocument.getElementById('hrefbrowsercontainer').innerHTML = getBrowserHTML('hrefbrowser', 'href', 'file', 'theme_advanced_link');\n\t\tif (isVisible('hrefbrowser'))\n\t\t\tdocument.getElementById('href').style.width = '180px';\n\n\t\tthis.fillClassList('class_list');\n\t\tthis.fillFileList('link_list', 'tinyMCELinkList');\n\t\tthis.fillTargetList('target_list');\n\n\t\tif (e = ed.dom.getParent(ed.selection.getNode(), 'A')) {\n\t\t\tf.href.value = ed.dom.getAttrib(e, 'href');\n\t\t\tf.linktitle.value = ed.dom.getAttrib(e, 'title');\n\t\t\tf.insert.value = ed.getLang('update');\n\t\t\tselectByValue(f, 'link_list', f.href.value);\n\t\t\tselectByValue(f, 'target_list', ed.dom.getAttrib(e, 'target'));\n\t\t\tselectByValue(f, 'class_list', ed.dom.getAttrib(e, 'class'));\n\t\t}\n\t},\n\n\tupdate : function() {\n\t\tvar f = document.forms[0], ed = tinyMCEPopup.editor, e, b, href = f.href.value.replace(/ /g, '%20');\n\n\t\ttinyMCEPopup.restoreSelection();\n\t\te = ed.dom.getParent(ed.selection.getNode(), 'A');\n\n\t\t// Remove element if there is no href\n\t\tif (!f.href.value) {\n\t\t\tif (e) {\n\t\t\t\tb = ed.selection.getBookmark();\n\t\t\t\ted.dom.remove(e, 1);\n\t\t\t\ted.selection.moveToBookmark(b);\n\t\t\t\ttinyMCEPopup.execCommand(\"mceEndUndoLevel\");\n\t\t\t\ttinyMCEPopup.close();\n\t\t\t\treturn;\n\t\t\t}\n\t\t}\n\n\t\t// Create new anchor elements\n\t\tif (e == null) {\n\t\t\ted.getDoc().execCommand(\"unlink\", false, null);\n\t\t\ttinyMCEPopup.execCommand(\"mceInsertLink\", false, \"#mce_temp_url#\", {skip_undo : 1});\n\n\t\t\ttinymce.each(ed.dom.select(\"a\"), function(n) {\n\t\t\t\tif (ed.dom.getAttrib(n, 'href') == '#mce_temp_url#') {\n\t\t\t\t\te = n;\n\n\t\t\t\t\ted.dom.setAttribs(e, {\n\t\t\t\t\t\thref : href,\n\t\t\t\t\t\ttitle : f.linktitle.value,\n\t\t\t\t\t\ttarget : f.target_list ? getSelectValue(f, \"target_list\") : null,\n\t\t\t\t\t\t'class' : f.class_list ? getSelectValue(f, \"class_list\") : null\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t});\n\t\t} else {\n\t\t\ted.dom.setAttribs(e, {\n\t\t\t\thref : href,\n\t\t\t\ttitle : f.linktitle.value,\n\t\t\t\ttarget : f.target_list ? getSelectValue(f, \"target_list\") : null,\n\t\t\t\t'class' : f.class_list ? getSelectValue(f, \"class_list\") : null\n\t\t\t});\n\t\t}\n\n\t\t// Don't move caret if selection was image\n\t\tif (e.childNodes.length != 1 || e.firstChild.nodeName != 'IMG') {\n\t\t\ted.focus();\n\t\t\ted.selection.select(e);\n\t\t\ted.selection.collapse(0);\n\t\t\ttinyMCEPopup.storeSelection();\n\t\t}\n\n\t\ttinyMCEPopup.execCommand(\"mceEndUndoLevel\");\n\t\ttinyMCEPopup.close();\n\t},\n\n\tcheckPrefix : function(n) {\n\t\tif (n.value && Validator.isEmail(n) && !/^\\s*mailto:/i.test(n.value) && confirm(tinyMCEPopup.getLang('advanced_dlg.link_is_email')))\n\t\t\tn.value = 'mailto:' + n.value;\n\n\t\tif (/^\\s*www\\./i.test(n.value) && confirm(tinyMCEPopup.getLang('advanced_dlg.link_is_external')))\n\t\t\tn.value = 'http://' + n.value;\n\t},\n\n\tfillFileList : function(id, l) {\n\t\tvar dom = tinyMCEPopup.dom, lst = dom.get(id), v, cl;\n\n\t\tl = window[l];\n\n\t\tif (l && l.length > 0) {\n\t\t\tlst.options[lst.options.length] = new Option('', '');\n\n\t\t\ttinymce.each(l, function(o) {\n\t\t\t\tlst.options[lst.options.length] = new Option(o[0], o[1]);\n\t\t\t});\n\t\t} else\n\t\t\tdom.remove(dom.getParent(id, 'tr'));\n\t},\n\n\tfillClassList : function(id) {\n\t\tvar dom = tinyMCEPopup.dom, lst = dom.get(id), v, cl;\n\n\t\tif (v = tinyMCEPopup.getParam('theme_advanced_styles')) {\n\t\t\tcl = [];\n\n\t\t\ttinymce.each(v.split(';'), function(v) {\n\t\t\t\tvar p = v.split('=');\n\n\t\t\t\tcl.push({'title' : p[0], 'class' : p[1]});\n\t\t\t});\n\t\t} else\n\t\t\tcl = tinyMCEPopup.editor.dom.getClasses();\n\n\t\tif (cl.length > 0) {\n\t\t\tlst.options[lst.options.length] = new Option(tinyMCEPopup.getLang('not_set'), '');\n\n\t\t\ttinymce.each(cl, function(o) {\n\t\t\t\tlst.options[lst.options.length] = new Option(o.title || o['class'], o['class']);\n\t\t\t});\n\t\t} else\n\t\t\tdom.remove(dom.getParent(id, 'tr'));\n\t},\n\n\tfillTargetList : function(id) {\n\t\tvar dom = tinyMCEPopup.dom, lst = dom.get(id), v;\n\n\t\tlst.options[lst.options.length] = new Option(tinyMCEPopup.getLang('not_set'), '');\n\t\tlst.options[lst.options.length] = new Option(tinyMCEPopup.getLang('advanced_dlg.link_target_same'), '_self');\n\t\tlst.options[lst.options.length] = new Option(tinyMCEPopup.getLang('advanced_dlg.link_target_blank'), '_blank');\n\n\t\tif (v = tinyMCEPopup.getParam('theme_advanced_link_targets')) {\n\t\t\ttinymce.each(v.split(','), function(v) {\n\t\t\t\tv = v.split('=');\n\t\t\t\tlst.options[lst.options.length] = new Option(v[0], v[1]);\n\t\t\t});\n\t\t}\n\t}\n};\n\nLinkDialog.preInit();\ntinyMCEPopup.onInit.add(LinkDialog.init, LinkDialog);\n","Magento_Tinymce3/tiny_mce/themes/advanced/js/charmap.js":"/**\n * charmap.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\ntinyMCEPopup.requireLangPack();\n\nvar charmap = [\n\t['&nbsp;',    '&#160;',  true, 'no-break space'],\n\t['&amp;',     '&#38;',   true, 'ampersand'],\n\t['&quot;',    '&#34;',   true, 'quotation mark'],\n// finance\n\t['&cent;',    '&#162;',  true, 'cent sign'],\n\t['&euro;',    '&#8364;', true, 'euro sign'],\n\t['&pound;',   '&#163;',  true, 'pound sign'],\n\t['&yen;',     '&#165;',  true, 'yen sign'],\n// signs\n\t['&copy;',    '&#169;',  true, 'copyright sign'],\n\t['&reg;',     '&#174;',  true, 'registered sign'],\n\t['&trade;',   '&#8482;', true, 'trade mark sign'],\n\t['&permil;',  '&#8240;', true, 'per mille sign'],\n\t['&micro;',   '&#181;',  true, 'micro sign'],\n\t['&middot;',  '&#183;',  true, 'middle dot'],\n\t['&bull;',    '&#8226;', true, 'bullet'],\n\t['&hellip;',  '&#8230;', true, 'three dot leader'],\n\t['&prime;',   '&#8242;', true, 'minutes / feet'],\n\t['&Prime;',   '&#8243;', true, 'seconds / inches'],\n\t['&sect;',    '&#167;',  true, 'section sign'],\n\t['&para;',    '&#182;',  true, 'paragraph sign'],\n\t['&szlig;',   '&#223;',  true, 'sharp s / ess-zed'],\n// quotations\n\t['&lsaquo;',  '&#8249;', true, 'single left-pointing angle quotation mark'],\n\t['&rsaquo;',  '&#8250;', true, 'single right-pointing angle quotation mark'],\n\t['&laquo;',   '&#171;',  true, 'left pointing guillemet'],\n\t['&raquo;',   '&#187;',  true, 'right pointing guillemet'],\n\t['&lsquo;',   '&#8216;', true, 'left single quotation mark'],\n\t['&rsquo;',   '&#8217;', true, 'right single quotation mark'],\n\t['&ldquo;',   '&#8220;', true, 'left double quotation mark'],\n\t['&rdquo;',   '&#8221;', true, 'right double quotation mark'],\n\t['&sbquo;',   '&#8218;', true, 'single low-9 quotation mark'],\n\t['&bdquo;',   '&#8222;', true, 'double low-9 quotation mark'],\n\t['&lt;',      '&#60;',   true, 'less-than sign'],\n\t['&gt;',      '&#62;',   true, 'greater-than sign'],\n\t['&le;',      '&#8804;', true, 'less-than or equal to'],\n\t['&ge;',      '&#8805;', true, 'greater-than or equal to'],\n\t['&ndash;',   '&#8211;', true, 'en dash'],\n\t['&mdash;',   '&#8212;', true, 'em dash'],\n\t['&macr;',    '&#175;',  true, 'macron'],\n\t['&oline;',   '&#8254;', true, 'overline'],\n\t['&curren;',  '&#164;',  true, 'currency sign'],\n\t['&brvbar;',  '&#166;',  true, 'broken bar'],\n\t['&uml;',     '&#168;',  true, 'diaeresis'],\n\t['&iexcl;',   '&#161;',  true, 'inverted exclamation mark'],\n\t['&iquest;',  '&#191;',  true, 'turned question mark'],\n\t['&circ;',    '&#710;',  true, 'circumflex accent'],\n\t['&tilde;',   '&#732;',  true, 'small tilde'],\n\t['&deg;',     '&#176;',  true, 'degree sign'],\n\t['&minus;',   '&#8722;', true, 'minus sign'],\n\t['&plusmn;',  '&#177;',  true, 'plus-minus sign'],\n\t['&divide;',  '&#247;',  true, 'division sign'],\n\t['&frasl;',   '&#8260;', true, 'fraction slash'],\n\t['&times;',   '&#215;',  true, 'multiplication sign'],\n\t['&sup1;',    '&#185;',  true, 'superscript one'],\n\t['&sup2;',    '&#178;',  true, 'superscript two'],\n\t['&sup3;',    '&#179;',  true, 'superscript three'],\n\t['&frac14;',  '&#188;',  true, 'fraction one quarter'],\n\t['&frac12;',  '&#189;',  true, 'fraction one half'],\n\t['&frac34;',  '&#190;',  true, 'fraction three quarters'],\n// math / logical\n\t['&fnof;',    '&#402;',  true, 'function / florin'],\n\t['&int;',     '&#8747;', true, 'integral'],\n\t['&sum;',     '&#8721;', true, 'n-ary sumation'],\n\t['&infin;',   '&#8734;', true, 'infinity'],\n\t['&radic;',   '&#8730;', true, 'square root'],\n\t['&sim;',     '&#8764;', false,'similar to'],\n\t['&cong;',    '&#8773;', false,'approximately equal to'],\n\t['&asymp;',   '&#8776;', true, 'almost equal to'],\n\t['&ne;',      '&#8800;', true, 'not equal to'],\n\t['&equiv;',   '&#8801;', true, 'identical to'],\n\t['&isin;',    '&#8712;', false,'element of'],\n\t['&notin;',   '&#8713;', false,'not an element of'],\n\t['&ni;',      '&#8715;', false,'contains as member'],\n\t['&prod;',    '&#8719;', true, 'n-ary product'],\n\t['&and;',     '&#8743;', false,'logical and'],\n\t['&or;',      '&#8744;', false,'logical or'],\n\t['&not;',     '&#172;',  true, 'not sign'],\n\t['&cap;',     '&#8745;', true, 'intersection'],\n\t['&cup;',     '&#8746;', false,'union'],\n\t['&part;',    '&#8706;', true, 'partial differential'],\n\t['&forall;',  '&#8704;', false,'for all'],\n\t['&exist;',   '&#8707;', false,'there exists'],\n\t['&empty;',   '&#8709;', false,'diameter'],\n\t['&nabla;',   '&#8711;', false,'backward difference'],\n\t['&lowast;',  '&#8727;', false,'asterisk operator'],\n\t['&prop;',    '&#8733;', false,'proportional to'],\n\t['&ang;',     '&#8736;', false,'angle'],\n// undefined\n\t['&acute;',   '&#180;',  true, 'acute accent'],\n\t['&cedil;',   '&#184;',  true, 'cedilla'],\n\t['&ordf;',    '&#170;',  true, 'feminine ordinal indicator'],\n\t['&ordm;',    '&#186;',  true, 'masculine ordinal indicator'],\n\t['&dagger;',  '&#8224;', true, 'dagger'],\n\t['&Dagger;',  '&#8225;', true, 'double dagger'],\n// alphabetical special chars\n\t['&Agrave;',  '&#192;',  true, 'A - grave'],\n\t['&Aacute;',  '&#193;',  true, 'A - acute'],\n\t['&Acirc;',   '&#194;',  true, 'A - circumflex'],\n\t['&Atilde;',  '&#195;',  true, 'A - tilde'],\n\t['&Auml;',    '&#196;',  true, 'A - diaeresis'],\n\t['&Aring;',   '&#197;',  true, 'A - ring above'],\n\t['&AElig;',   '&#198;',  true, 'ligature AE'],\n\t['&Ccedil;',  '&#199;',  true, 'C - cedilla'],\n\t['&Egrave;',  '&#200;',  true, 'E - grave'],\n\t['&Eacute;',  '&#201;',  true, 'E - acute'],\n\t['&Ecirc;',   '&#202;',  true, 'E - circumflex'],\n\t['&Euml;',    '&#203;',  true, 'E - diaeresis'],\n\t['&Igrave;',  '&#204;',  true, 'I - grave'],\n\t['&Iacute;',  '&#205;',  true, 'I - acute'],\n\t['&Icirc;',   '&#206;',  true, 'I - circumflex'],\n\t['&Iuml;',    '&#207;',  true, 'I - diaeresis'],\n\t['&ETH;',     '&#208;',  true, 'ETH'],\n\t['&Ntilde;',  '&#209;',  true, 'N - tilde'],\n\t['&Ograve;',  '&#210;',  true, 'O - grave'],\n\t['&Oacute;',  '&#211;',  true, 'O - acute'],\n\t['&Ocirc;',   '&#212;',  true, 'O - circumflex'],\n\t['&Otilde;',  '&#213;',  true, 'O - tilde'],\n\t['&Ouml;',    '&#214;',  true, 'O - diaeresis'],\n\t['&Oslash;',  '&#216;',  true, 'O - slash'],\n\t['&OElig;',   '&#338;',  true, 'ligature OE'],\n\t['&Scaron;',  '&#352;',  true, 'S - caron'],\n\t['&Ugrave;',  '&#217;',  true, 'U - grave'],\n\t['&Uacute;',  '&#218;',  true, 'U - acute'],\n\t['&Ucirc;',   '&#219;',  true, 'U - circumflex'],\n\t['&Uuml;',    '&#220;',  true, 'U - diaeresis'],\n\t['&Yacute;',  '&#221;',  true, 'Y - acute'],\n\t['&Yuml;',    '&#376;',  true, 'Y - diaeresis'],\n\t['&THORN;',   '&#222;',  true, 'THORN'],\n\t['&agrave;',  '&#224;',  true, 'a - grave'],\n\t['&aacute;',  '&#225;',  true, 'a - acute'],\n\t['&acirc;',   '&#226;',  true, 'a - circumflex'],\n\t['&atilde;',  '&#227;',  true, 'a - tilde'],\n\t['&auml;',    '&#228;',  true, 'a - diaeresis'],\n\t['&aring;',   '&#229;',  true, 'a - ring above'],\n\t['&aelig;',   '&#230;',  true, 'ligature ae'],\n\t['&ccedil;',  '&#231;',  true, 'c - cedilla'],\n\t['&egrave;',  '&#232;',  true, 'e - grave'],\n\t['&eacute;',  '&#233;',  true, 'e - acute'],\n\t['&ecirc;',   '&#234;',  true, 'e - circumflex'],\n\t['&euml;',    '&#235;',  true, 'e - diaeresis'],\n\t['&igrave;',  '&#236;',  true, 'i - grave'],\n\t['&iacute;',  '&#237;',  true, 'i - acute'],\n\t['&icirc;',   '&#238;',  true, 'i - circumflex'],\n\t['&iuml;',    '&#239;',  true, 'i - diaeresis'],\n\t['&eth;',     '&#240;',  true, 'eth'],\n\t['&ntilde;',  '&#241;',  true, 'n - tilde'],\n\t['&ograve;',  '&#242;',  true, 'o - grave'],\n\t['&oacute;',  '&#243;',  true, 'o - acute'],\n\t['&ocirc;',   '&#244;',  true, 'o - circumflex'],\n\t['&otilde;',  '&#245;',  true, 'o - tilde'],\n\t['&ouml;',    '&#246;',  true, 'o - diaeresis'],\n\t['&oslash;',  '&#248;',  true, 'o slash'],\n\t['&oelig;',   '&#339;',  true, 'ligature oe'],\n\t['&scaron;',  '&#353;',  true, 's - caron'],\n\t['&ugrave;',  '&#249;',  true, 'u - grave'],\n\t['&uacute;',  '&#250;',  true, 'u - acute'],\n\t['&ucirc;',   '&#251;',  true, 'u - circumflex'],\n\t['&uuml;',    '&#252;',  true, 'u - diaeresis'],\n\t['&yacute;',  '&#253;',  true, 'y - acute'],\n\t['&thorn;',   '&#254;',  true, 'thorn'],\n\t['&yuml;',    '&#255;',  true, 'y - diaeresis'],\n\t['&Alpha;',   '&#913;',  true, 'Alpha'],\n\t['&Beta;',    '&#914;',  true, 'Beta'],\n\t['&Gamma;',   '&#915;',  true, 'Gamma'],\n\t['&Delta;',   '&#916;',  true, 'Delta'],\n\t['&Epsilon;', '&#917;',  true, 'Epsilon'],\n\t['&Zeta;',    '&#918;',  true, 'Zeta'],\n\t['&Eta;',     '&#919;',  true, 'Eta'],\n\t['&Theta;',   '&#920;',  true, 'Theta'],\n\t['&Iota;',    '&#921;',  true, 'Iota'],\n\t['&Kappa;',   '&#922;',  true, 'Kappa'],\n\t['&Lambda;',  '&#923;',  true, 'Lambda'],\n\t['&Mu;',      '&#924;',  true, 'Mu'],\n\t['&Nu;',      '&#925;',  true, 'Nu'],\n\t['&Xi;',      '&#926;',  true, 'Xi'],\n\t['&Omicron;', '&#927;',  true, 'Omicron'],\n\t['&Pi;',      '&#928;',  true, 'Pi'],\n\t['&Rho;',     '&#929;',  true, 'Rho'],\n\t['&Sigma;',   '&#931;',  true, 'Sigma'],\n\t['&Tau;',     '&#932;',  true, 'Tau'],\n\t['&Upsilon;', '&#933;',  true, 'Upsilon'],\n\t['&Phi;',     '&#934;',  true, 'Phi'],\n\t['&Chi;',     '&#935;',  true, 'Chi'],\n\t['&Psi;',     '&#936;',  true, 'Psi'],\n\t['&Omega;',   '&#937;',  true, 'Omega'],\n\t['&alpha;',   '&#945;',  true, 'alpha'],\n\t['&beta;',    '&#946;',  true, 'beta'],\n\t['&gamma;',   '&#947;',  true, 'gamma'],\n\t['&delta;',   '&#948;',  true, 'delta'],\n\t['&epsilon;', '&#949;',  true, 'epsilon'],\n\t['&zeta;',    '&#950;',  true, 'zeta'],\n\t['&eta;',     '&#951;',  true, 'eta'],\n\t['&theta;',   '&#952;',  true, 'theta'],\n\t['&iota;',    '&#953;',  true, 'iota'],\n\t['&kappa;',   '&#954;',  true, 'kappa'],\n\t['&lambda;',  '&#955;',  true, 'lambda'],\n\t['&mu;',      '&#956;',  true, 'mu'],\n\t['&nu;',      '&#957;',  true, 'nu'],\n\t['&xi;',      '&#958;',  true, 'xi'],\n\t['&omicron;', '&#959;',  true, 'omicron'],\n\t['&pi;',      '&#960;',  true, 'pi'],\n\t['&rho;',     '&#961;',  true, 'rho'],\n\t['&sigmaf;',  '&#962;',  true, 'final sigma'],\n\t['&sigma;',   '&#963;',  true, 'sigma'],\n\t['&tau;',     '&#964;',  true, 'tau'],\n\t['&upsilon;', '&#965;',  true, 'upsilon'],\n\t['&phi;',     '&#966;',  true, 'phi'],\n\t['&chi;',     '&#967;',  true, 'chi'],\n\t['&psi;',     '&#968;',  true, 'psi'],\n\t['&omega;',   '&#969;',  true, 'omega'],\n// symbols\n\t['&alefsym;', '&#8501;', false,'alef symbol'],\n\t['&piv;',     '&#982;',  false,'pi symbol'],\n\t['&real;',    '&#8476;', false,'real part symbol'],\n\t['&thetasym;','&#977;',  false,'theta symbol'],\n\t['&upsih;',   '&#978;',  false,'upsilon - hook symbol'],\n\t['&weierp;',  '&#8472;', false,'Weierstrass p'],\n\t['&image;',   '&#8465;', false,'imaginary part'],\n// arrows\n\t['&larr;',    '&#8592;', true, 'leftwards arrow'],\n\t['&uarr;',    '&#8593;', true, 'upwards arrow'],\n\t['&rarr;',    '&#8594;', true, 'rightwards arrow'],\n\t['&darr;',    '&#8595;', true, 'downwards arrow'],\n\t['&harr;',    '&#8596;', true, 'left right arrow'],\n\t['&crarr;',   '&#8629;', false,'carriage return'],\n\t['&lArr;',    '&#8656;', false,'leftwards double arrow'],\n\t['&uArr;',    '&#8657;', false,'upwards double arrow'],\n\t['&rArr;',    '&#8658;', false,'rightwards double arrow'],\n\t['&dArr;',    '&#8659;', false,'downwards double arrow'],\n\t['&hArr;',    '&#8660;', false,'left right double arrow'],\n\t['&there4;',  '&#8756;', false,'therefore'],\n\t['&sub;',     '&#8834;', false,'subset of'],\n\t['&sup;',     '&#8835;', false,'superset of'],\n\t['&nsub;',    '&#8836;', false,'not a subset of'],\n\t['&sube;',    '&#8838;', false,'subset of or equal to'],\n\t['&supe;',    '&#8839;', false,'superset of or equal to'],\n\t['&oplus;',   '&#8853;', false,'circled plus'],\n\t['&otimes;',  '&#8855;', false,'circled times'],\n\t['&perp;',    '&#8869;', false,'perpendicular'],\n\t['&sdot;',    '&#8901;', false,'dot operator'],\n\t['&lceil;',   '&#8968;', false,'left ceiling'],\n\t['&rceil;',   '&#8969;', false,'right ceiling'],\n\t['&lfloor;',  '&#8970;', false,'left floor'],\n\t['&rfloor;',  '&#8971;', false,'right floor'],\n\t['&lang;',    '&#9001;', false,'left-pointing angle bracket'],\n\t['&rang;',    '&#9002;', false,'right-pointing angle bracket'],\n\t['&loz;',     '&#9674;', true, 'lozenge'],\n\t['&spades;',  '&#9824;', true, 'black spade suit'],\n\t['&clubs;',   '&#9827;', true, 'black club suit'],\n\t['&hearts;',  '&#9829;', true, 'black heart suit'],\n\t['&diams;',   '&#9830;', true, 'black diamond suit'],\n\t['&ensp;',    '&#8194;', false,'en space'],\n\t['&emsp;',    '&#8195;', false,'em space'],\n\t['&thinsp;',  '&#8201;', false,'thin space'],\n\t['&zwnj;',    '&#8204;', false,'zero width non-joiner'],\n\t['&zwj;',     '&#8205;', false,'zero width joiner'],\n\t['&lrm;',     '&#8206;', false,'left-to-right mark'],\n\t['&rlm;',     '&#8207;', false,'right-to-left mark'],\n\t['&shy;',     '&#173;',  false,'soft hyphen']\n];\n\ntinyMCEPopup.onInit.add(function() {\n\ttinyMCEPopup.dom.setHTML('charmapView', renderCharMapHTML());\n\taddKeyboardNavigation();\n});\n\nfunction addKeyboardNavigation(){\n\tvar tableElm, cells, settings;\n\n\tcells = tinyMCEPopup.dom.select(\"a.charmaplink\", \"charmapgroup\");\n\n\tsettings ={\n\t\troot: \"charmapgroup\",\n\t\titems: cells\n\t};\n\tcells[0].tabindex=0;\n\ttinyMCEPopup.dom.addClass(cells[0], \"mceFocus\");\n\tif (tinymce.isGecko) {\n\t\tcells[0].focus();\t\t\n\t} else {\n\t\tsetTimeout(function(){\n\t\t\tcells[0].focus();\n\t\t}, 100);\n\t}\n\ttinyMCEPopup.editor.windowManager.createInstance('tinymce.ui.KeyboardNavigation', settings, tinyMCEPopup.dom);\n}\n\nfunction renderCharMapHTML() {\n\tvar charsPerRow = 20, tdWidth=20, tdHeight=20, i;\n\tvar html = '<div id=\"charmapgroup\" aria-labelledby=\"charmap_label\" tabindex=\"0\" role=\"listbox\">'+\n\t'<table role=\"presentation\" border=\"0\" cellspacing=\"1\" cellpadding=\"0\" width=\"' + (tdWidth*charsPerRow) + \n\t'\"><tr height=\"' + tdHeight + '\">';\n\tvar cols=-1;\n\n\tfor (i=0; i<charmap.length; i++) {\n\t\tvar previewCharFn;\n\n\t\tif (charmap[i][2]==true) {\n\t\t\tcols++;\n\t\t\tpreviewCharFn = 'previewChar(\\'' + charmap[i][1].substring(1,charmap[i][1].length) + '\\',\\'' + charmap[i][0].substring(1,charmap[i][0].length) + '\\',\\'' + charmap[i][3] + '\\');';\n\t\t\thtml += ''\n\t\t\t\t+ '<td class=\"charmap\">'\n\t\t\t\t+ '<a class=\"charmaplink\" role=\"button\" onmouseover=\"'+previewCharFn+'\" onfocus=\"'+previewCharFn+'\" href=\"javascript:void(0)\" onclick=\"insertChar(\\'' + charmap[i][1].substring(2,charmap[i][1].length-1) + '\\');\" onclick=\"return false;\" onmousedown=\"return false;\" title=\"' + charmap[i][3] + ' '+ tinyMCEPopup.editor.translate(\"advanced_dlg.charmap_usage\")+'\">'\n\t\t\t\t+ charmap[i][1]\n\t\t\t\t+ '</a></td>';\n\t\t\tif ((cols+1) % charsPerRow == 0)\n\t\t\t\thtml += '</tr><tr height=\"' + tdHeight + '\">';\n\t\t}\n\t }\n\n\tif (cols % charsPerRow > 0) {\n\t\tvar padd = charsPerRow - (cols % charsPerRow);\n\t\tfor (var i=0; i<padd-1; i++)\n\t\t\thtml += '<td width=\"' + tdWidth + '\" height=\"' + tdHeight + '\" class=\"charmap\">&nbsp;</td>';\n\t}\n\n\thtml += '</tr></table></div>';\n\thtml = html.replace(/<tr height=\"20\"><\\/tr>/g, '');\n\n\treturn html;\n}\n\nfunction insertChar(chr) {\n\ttinyMCEPopup.execCommand('mceInsertContent', false, '&#' + chr + ';');\n\n\t// Refocus in window\n\tif (tinyMCEPopup.isWindow)\n\t\twindow.focus();\n\n\ttinyMCEPopup.editor.focus();\n\ttinyMCEPopup.close();\n}\n\nfunction previewChar(codeA, codeB, codeN) {\n\tvar elmA = document.getElementById('codeA');\n\tvar elmB = document.getElementById('codeB');\n\tvar elmV = document.getElementById('codeV');\n\tvar elmN = document.getElementById('codeN');\n\n\tif (codeA=='#160;') {\n\t\telmV.innerHTML = '__';\n\t} else {\n\t\telmV.innerHTML = '&' + codeA;\n\t}\n\n\telmB.innerHTML = '&amp;' + codeA;\n\telmA.innerHTML = '&amp;' + codeB;\n\telmN.innerHTML = codeN;\n}\n","Magento_Tinymce3/tiny_mce/themes/advanced/js/anchor.js":"tinyMCEPopup.requireLangPack();\n\nvar AnchorDialog = {\n\tinit : function(ed) {\n\t\tvar action, elm, f = document.forms[0];\n\n\t\tthis.editor = ed;\n\t\telm = ed.dom.getParent(ed.selection.getNode(), 'A');\n\t\tv = ed.dom.getAttrib(elm, 'name');\n\n\t\tif (v) {\n\t\t\tthis.action = 'update';\n\t\t\tf.anchorName.value = v;\n\t\t}\n\n\t\tf.insert.value = ed.getLang(elm ? 'update' : 'insert');\n\t},\n\n\tupdate : function() {\n\t\tvar ed = this.editor, elm, name = document.forms[0].anchorName.value;\n\n\t\tif (!name || !/^[a-z][a-z0-9\\-\\_:\\.]*$/i.test(name)) {\n\t\t\ttinyMCEPopup.alert('advanced_dlg.anchor_invalid');\n\t\t\treturn;\n\t\t}\n\n\t\ttinyMCEPopup.restoreSelection();\n\n\t\tif (this.action != 'update')\n\t\t\ted.selection.collapse(1);\n\n\t\telm = ed.dom.getParent(ed.selection.getNode(), 'A');\n\t\tif (elm) {\n\t\t\telm.setAttribute('name', name);\n\t\t\telm.name = name;\n\t\t} else\n\t\t\ted.execCommand('mceInsertContent', 0, ed.dom.createHTML('a', {name : name, 'class' : 'mceItemAnchor'}, ''));\n\n\t\ttinyMCEPopup.close();\n\t}\n};\n\ntinyMCEPopup.onInit.add(AnchorDialog.init, AnchorDialog);\n","Magento_Tinymce3/tiny_mce/themes/advanced/js/image.js":"var ImageDialog = {\n\tpreInit : function() {\n\t\tvar url;\n\n\t\ttinyMCEPopup.requireLangPack();\n\n\t\tif (url = tinyMCEPopup.getParam(\"external_image_list_url\"))\n\t\t\tdocument.write('<script language=\"javascript\" type=\"text/javascript\" src=\"' + tinyMCEPopup.editor.documentBaseURI.toAbsolute(url) + '\"></script>');\n\t},\n\n\tinit : function() {\n\t\tvar f = document.forms[0], ed = tinyMCEPopup.editor;\n\n\t\t// Setup browse button\n\t\tdocument.getElementById('srcbrowsercontainer').innerHTML = getBrowserHTML('srcbrowser','src','image','theme_advanced_image');\n\t\tif (isVisible('srcbrowser'))\n\t\t\tdocument.getElementById('src').style.width = '180px';\n\n\t\te = ed.selection.getNode();\n\n\t\tthis.fillFileList('image_list', tinyMCEPopup.getParam('external_image_list', 'tinyMCEImageList'));\n\n\t\tif (e.nodeName == 'IMG') {\n\t\t\tf.src.value = ed.dom.getAttrib(e, 'src');\n\t\t\tf.alt.value = ed.dom.getAttrib(e, 'alt');\n\t\t\tf.border.value = this.getAttrib(e, 'border');\n\t\t\tf.vspace.value = this.getAttrib(e, 'vspace');\n\t\t\tf.hspace.value = this.getAttrib(e, 'hspace');\n\t\t\tf.width.value = ed.dom.getAttrib(e, 'width');\n\t\t\tf.height.value = ed.dom.getAttrib(e, 'height');\n\t\t\tf.insert.value = ed.getLang('update');\n\t\t\tthis.styleVal = ed.dom.getAttrib(e, 'style');\n\t\t\tselectByValue(f, 'image_list', f.src.value);\n\t\t\tselectByValue(f, 'align', this.getAttrib(e, 'align'));\n\t\t\tthis.updateStyle();\n\t\t}\n\t},\n\n\tfillFileList : function(id, l) {\n\t\tvar dom = tinyMCEPopup.dom, lst = dom.get(id), v, cl;\n\n\t\tl = typeof(l) === 'function' ? l() : window[l];\n\n\t\tif (l && l.length > 0) {\n\t\t\tlst.options[lst.options.length] = new Option('', '');\n\n\t\t\ttinymce.each(l, function(o) {\n\t\t\t\tlst.options[lst.options.length] = new Option(o[0], o[1]);\n\t\t\t});\n\t\t} else\n\t\t\tdom.remove(dom.getParent(id, 'tr'));\n\t},\n\n\tupdate : function() {\n\t\tvar f = document.forms[0], nl = f.elements, ed = tinyMCEPopup.editor, args = {}, el;\n\n\t\ttinyMCEPopup.restoreSelection();\n\n\t\tif (f.src.value === '') {\n\t\t\tif (ed.selection.getNode().nodeName == 'IMG') {\n\t\t\t\ted.dom.remove(ed.selection.getNode());\n\t\t\t\ted.execCommand('mceRepaint');\n\t\t\t}\n\n\t\t\ttinyMCEPopup.close();\n\t\t\treturn;\n\t\t}\n\n\t\tif (!ed.settings.inline_styles) {\n\t\t\targs = tinymce.extend(args, {\n\t\t\t\tvspace : nl.vspace.value,\n\t\t\t\thspace : nl.hspace.value,\n\t\t\t\tborder : nl.border.value,\n\t\t\t\talign : getSelectValue(f, 'align')\n\t\t\t});\n\t\t} else\n\t\t\targs.style = this.styleVal;\n\n\t\ttinymce.extend(args, {\n\t\t\tsrc : f.src.value.replace(/ /g, '%20'),\n\t\t\talt : f.alt.value,\n\t\t\twidth : f.width.value,\n\t\t\theight : f.height.value\n\t\t});\n\n\t\tel = ed.selection.getNode();\n\n\t\tif (el && el.nodeName == 'IMG') {\n\t\t\ted.dom.setAttribs(el, args);\n\t\t\ttinyMCEPopup.editor.execCommand('mceRepaint');\n\t\t\ttinyMCEPopup.editor.focus();\n\t\t} else {\n\t\t\ttinymce.each(args, function(value, name) {\n\t\t\t\tif (value === \"\") {\n\t\t\t\t\tdelete args[name];\n\t\t\t\t}\n\t\t\t});\n\n\t\t\ted.execCommand('mceInsertContent', false, tinyMCEPopup.editor.dom.createHTML('img', args), {skip_undo : 1});\n\t\t\ted.undoManager.add();\n\t\t}\n\n\t\ttinyMCEPopup.close();\n\t},\n\n\tupdateStyle : function() {\n\t\tvar dom = tinyMCEPopup.dom, st, v, f = document.forms[0];\n\n\t\tif (tinyMCEPopup.editor.settings.inline_styles) {\n\t\t\tst = tinyMCEPopup.dom.parseStyle(this.styleVal);\n\n\t\t\t// Handle align\n\t\t\tv = getSelectValue(f, 'align');\n\t\t\tif (v) {\n\t\t\t\tif (v == 'left' || v == 'right') {\n\t\t\t\t\tst['float'] = v;\n\t\t\t\t\tdelete st['vertical-align'];\n\t\t\t\t} else {\n\t\t\t\t\tst['vertical-align'] = v;\n\t\t\t\t\tdelete st['float'];\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tdelete st['float'];\n\t\t\t\tdelete st['vertical-align'];\n\t\t\t}\n\n\t\t\t// Handle border\n\t\t\tv = f.border.value;\n\t\t\tif (v || v == '0') {\n\t\t\t\tif (v == '0')\n\t\t\t\t\tst['border'] = '0';\n\t\t\t\telse\n\t\t\t\t\tst['border'] = v + 'px solid black';\n\t\t\t} else\n\t\t\t\tdelete st['border'];\n\n\t\t\t// Handle hspace\n\t\t\tv = f.hspace.value;\n\t\t\tif (v) {\n\t\t\t\tdelete st['margin'];\n\t\t\t\tst['margin-left'] = v + 'px';\n\t\t\t\tst['margin-right'] = v + 'px';\n\t\t\t} else {\n\t\t\t\tdelete st['margin-left'];\n\t\t\t\tdelete st['margin-right'];\n\t\t\t}\n\n\t\t\t// Handle vspace\n\t\t\tv = f.vspace.value;\n\t\t\tif (v) {\n\t\t\t\tdelete st['margin'];\n\t\t\t\tst['margin-top'] = v + 'px';\n\t\t\t\tst['margin-bottom'] = v + 'px';\n\t\t\t} else {\n\t\t\t\tdelete st['margin-top'];\n\t\t\t\tdelete st['margin-bottom'];\n\t\t\t}\n\n\t\t\t// Merge\n\t\t\tst = tinyMCEPopup.dom.parseStyle(dom.serializeStyle(st), 'img');\n\t\t\tthis.styleVal = dom.serializeStyle(st, 'img');\n\t\t}\n\t},\n\n\tgetAttrib : function(e, at) {\n\t\tvar ed = tinyMCEPopup.editor, dom = ed.dom, v, v2;\n\n\t\tif (ed.settings.inline_styles) {\n\t\t\tswitch (at) {\n\t\t\t\tcase 'align':\n\t\t\t\t\tif (v = dom.getStyle(e, 'float'))\n\t\t\t\t\t\treturn v;\n\n\t\t\t\t\tif (v = dom.getStyle(e, 'vertical-align'))\n\t\t\t\t\t\treturn v;\n\n\t\t\t\t\tbreak;\n\n\t\t\t\tcase 'hspace':\n\t\t\t\t\tv = dom.getStyle(e, 'margin-left')\n\t\t\t\t\tv2 = dom.getStyle(e, 'margin-right');\n\t\t\t\t\tif (v && v == v2)\n\t\t\t\t\t\treturn parseInt(v.replace(/[^0-9]/g, ''));\n\n\t\t\t\t\tbreak;\n\n\t\t\t\tcase 'vspace':\n\t\t\t\t\tv = dom.getStyle(e, 'margin-top')\n\t\t\t\t\tv2 = dom.getStyle(e, 'margin-bottom');\n\t\t\t\t\tif (v && v == v2)\n\t\t\t\t\t\treturn parseInt(v.replace(/[^0-9]/g, ''));\n\n\t\t\t\t\tbreak;\n\n\t\t\t\tcase 'border':\n\t\t\t\t\tv = 0;\n\n\t\t\t\t\ttinymce.each(['top', 'right', 'bottom', 'left'], function(sv) {\n\t\t\t\t\t\tsv = dom.getStyle(e, 'border-' + sv + '-width');\n\n\t\t\t\t\t\t// False or not the same as prev\n\t\t\t\t\t\tif (!sv || (sv != v && v !== 0)) {\n\t\t\t\t\t\t\tv = 0;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (sv)\n\t\t\t\t\t\t\tv = sv;\n\t\t\t\t\t});\n\n\t\t\t\t\tif (v)\n\t\t\t\t\t\treturn parseInt(v.replace(/[^0-9]/g, ''));\n\n\t\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\n\t\tif (v = dom.getAttrib(e, at))\n\t\t\treturn v;\n\n\t\treturn '';\n\t},\n\n\tresetImageData : function() {\n\t\tvar f = document.forms[0];\n\n\t\tf.width.value = f.height.value = \"\";\t\n\t},\n\n\tupdateImageData : function() {\n\t\tvar f = document.forms[0], t = ImageDialog;\n\n\t\tif (f.width.value == \"\")\n\t\t\tf.width.value = t.preloadImg.width;\n\n\t\tif (f.height.value == \"\")\n\t\t\tf.height.value = t.preloadImg.height;\n\t},\n\n\tgetImageData : function() {\n\t\tvar f = document.forms[0];\n\n\t\tthis.preloadImg = new Image();\n\t\tthis.preloadImg.onload = this.updateImageData;\n\t\tthis.preloadImg.onerror = this.resetImageData;\n\t\tthis.preloadImg.src = tinyMCEPopup.editor.documentBaseURI.toAbsolute(f.src.value);\n\t}\n};\n\nImageDialog.preInit();\ntinyMCEPopup.onInit.add(ImageDialog.init, ImageDialog);\n","Magento_Tinymce3/tiny_mce/themes/advanced/js/source_editor.js":"tinyMCEPopup.requireLangPack();\ntinyMCEPopup.onInit.add(onLoadInit);\n\nfunction saveContent() {\n\ttinyMCEPopup.editor.setContent(document.getElementById('htmlSource').value, {source_view : true});\n\ttinyMCEPopup.close();\n}\n\nfunction onLoadInit() {\n\ttinyMCEPopup.resizeToInnerSize();\n\n\t// Remove Gecko spellchecking\n\tif (tinymce.isGecko) {\n\t\tdocument.body.spellcheck = tinyMCEPopup.editor.getParam(\"gecko_spellcheck\", false);\n\t}\n\n\tdocument.getElementById('htmlSource').value = tinyMCEPopup.editor.getContent({source_view : true});\n\n\tif (tinyMCEPopup.editor.getParam(\"theme_advanced_source_editor_wrap\", true)) {\n\t\tsetWrap('soft');\n\t\tdocument.getElementById('wraped').checked = true;\n\t}\n\n\tresizeInputs();\n}\n\nfunction setWrap(val) {\n\tvar v, n, s = document.getElementById('htmlSource');\n\n\ts.wrap = val;\n\n\tif (!tinymce.isIE) {\n\t\tv = s.value;\n\t\tn = s.cloneNode(false);\n\t\tn.setAttribute(\"wrap\", val);\n\t\ts.parentNode.replaceChild(n, s);\n\t\tn.value = v;\n\t}\n}\n\nfunction toggleWordWrap(elm) {\n\tif (elm.checked)\n\t\tsetWrap('soft');\n\telse\n\t\tsetWrap('off');\n}\n\nfunction resizeInputs() {\n\tvar vp = tinyMCEPopup.dom.getViewPort(window), el;\n\n\tel = document.getElementById('htmlSource');\n\n\tif (el) {\n\t\tel.style.width = (vp.w - 20) + 'px';\n\t\tel.style.height = (vp.h - 65) + 'px';\n\t}\n}\n","Magento_Tinymce3/tiny_mce/themes/advanced/langs/en.js":"tinyMCE.addI18n('en.advanced',{\"underline_desc\":\"Underline (Ctrl+U)\",\"italic_desc\":\"Italic (Ctrl+I)\",\"bold_desc\":\"Bold (Ctrl+B)\",dd:\"Definition Description\",dt:\"Definition Term \",samp:\"Code Sample\",code:\"Code\",blockquote:\"Block Quote\",h6:\"Heading 6\",h5:\"Heading 5\",h4:\"Heading 4\",h3:\"Heading 3\",h2:\"Heading 2\",h1:\"Heading 1\",pre:\"Preformatted\",address:\"Address\",div:\"DIV\",paragraph:\"Paragraph\",block:\"Format\",fontdefault:\"Font Family\",\"font_size\":\"Font Size\",\"style_select\":\"Styles\",\"anchor_delta_height\":\"\",\"anchor_delta_width\":\"\",\"charmap_delta_height\":\"\",\"charmap_delta_width\":\"\",\"colorpicker_delta_height\":\"\",\"colorpicker_delta_width\":\"\",\"link_delta_height\":\"\",\"link_delta_width\":\"\",\"image_delta_height\":\"\",\"image_delta_width\":\"\",\"more_colors\":\"More Colors...\",\"toolbar_focus\":\"Jump to tool buttons - Alt+Q, Jump to editor - Alt-Z, Jump to element path - Alt-X\",newdocument:\"Are you sure you want clear all contents?\",path:\"Path\",\"clipboard_msg\":\"Copy/Cut/Paste is not available in Mozilla and Firefox.\\nDo you want more information about this issue?\",\"blockquote_desc\":\"Block Quote\",\"help_desc\":\"Help\",\"newdocument_desc\":\"New Document\",\"image_props_desc\":\"Image Properties\",\"paste_desc\":\"Paste (Ctrl+V)\",\"copy_desc\":\"Copy (Ctrl+C)\",\"cut_desc\":\"Cut (Ctrl+X)\",\"anchor_desc\":\"Insert/Edit Anchor\",\"visualaid_desc\":\"show/Hide Guidelines/Invisible Elements\",\"charmap_desc\":\"Insert Special Character\",\"backcolor_desc\":\"Select Background Color\",\"forecolor_desc\":\"Select Text Color\",\"custom1_desc\":\"Your Custom Description Here\",\"removeformat_desc\":\"Remove Formatting\",\"hr_desc\":\"Insert Horizontal Line\",\"sup_desc\":\"Superscript\",\"sub_desc\":\"Subscript\",\"code_desc\":\"Edit HTML Source\",\"cleanup_desc\":\"Cleanup Messy Code\",\"image_desc\":\"Insert/Edit Image\",\"unlink_desc\":\"Unlink\",\"link_desc\":\"Insert/Edit Link\",\"redo_desc\":\"Redo (Ctrl+Y)\",\"undo_desc\":\"Undo (Ctrl+Z)\",\"indent_desc\":\"Increase Indent\",\"outdent_desc\":\"Decrease Indent\",\"numlist_desc\":\"Insert/Remove Numbered List\",\"bullist_desc\":\"Insert/Remove Bulleted List\",\"justifyfull_desc\":\"Align Full\",\"justifyright_desc\":\"Align Right\",\"justifycenter_desc\":\"Align Center\",\"justifyleft_desc\":\"Align Left\",\"striketrough_desc\":\"Strikethrough\",\"help_shortcut\":\"Press ALT-F10 for toolbar. Press ALT-0 for help\",\"rich_text_area\":\"Rich Text Area\",\"shortcuts_desc\":\"Accessability Help\",toolbar:\"Toolbar\"});","Magento_Tinymce3/tiny_mce/themes/advanced/langs/en_dlg.js":"tinyMCE.addI18n('en.advanced_dlg', {\"link_list\":\"Link List\",\"link_is_external\":\"The URL you entered seems to be an external link. Do you want to add the required http:// prefix?\",\"link_is_email\":\"The URL you entered seems to be an email address. Do you want to add the required mailto: prefix?\",\"link_titlefield\":\"Title\",\"link_target_blank\":\"Open Link in a New Window\",\"link_target_same\":\"Open Link in the Same Window\",\"link_target\":\"Target\",\"link_url\":\"Link URL\",\"link_title\":\"Insert/Edit Link\",\"image_align_right\":\"Right\",\"image_align_left\":\"Left\",\"image_align_textbottom\":\"Text Bottom\",\"image_align_texttop\":\"Text Top\",\"image_align_bottom\":\"Bottom\",\"image_align_middle\":\"Middle\",\"image_align_top\":\"Top\",\"image_align_baseline\":\"Baseline\",\"image_align\":\"Alignment\",\"image_hspace\":\"Horizontal Space\",\"image_vspace\":\"Vertical Space\",\"image_dimensions\":\"Dimensions\",\"image_alt\":\"Image Description\",\"image_list\":\"Image List\",\"image_border\":\"Border\",\"image_src\":\"Image URL\",\"image_title\":\"Insert/Edit Image\",\"charmap_title\":\"Select Special Character\", \"charmap_usage\":\"Use left and right arrows to navigate.\",\"colorpicker_name\":\"Name:\",\"colorpicker_color\":\"Color:\",\"colorpicker_named_title\":\"Named Colors\",\"colorpicker_named_tab\":\"Named\",\"colorpicker_palette_title\":\"Palette Colors\",\"colorpicker_palette_tab\":\"Palette\",\"colorpicker_picker_title\":\"Color Picker\",\"colorpicker_picker_tab\":\"Picker\",\"colorpicker_title\":\"Select a Color\",\"code_wordwrap\":\"Word Wrap\",\"code_title\":\"HTML Source Editor\",\"anchor_name\":\"Anchor Name\",\"anchor_title\":\"Insert/Edit Anchor\",\"about_loaded\":\"Loaded Plugins\",\"about_version\":\"Version\",\"about_author\":\"Author\",\"about_plugin\":\"Plugin\",\"about_plugins\":\"Plugins\",\"about_license\":\"License\",\"about_help\":\"Help\",\"about_general\":\"About\",\"about_title\":\"About TinyMCE\",\"anchor_invalid\":\"Please specify a valid anchor name.\",\"accessibility_help\":\"Accessibility Help\",\"accessibility_usage_title\":\"General Usage\",\"\":\"\"});\n","Magento_Tinymce3/tiny_mce/themes/simple/editor_template_src.js":"/**\n * editor_template_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\tvar DOM = tinymce.DOM;\n\n\t// Tell it to load theme specific language pack(s)\n\ttinymce.ThemeManager.requireLangPack('simple');\n\n\ttinymce.create('tinymce.themes.SimpleTheme', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this, states = ['Bold', 'Italic', 'Underline', 'Strikethrough', 'InsertUnorderedList', 'InsertOrderedList'], s = ed.settings;\n\n\t\t\tt.editor = ed;\n\t\t\ted.contentCSS.push(url + \"/skins/\" + s.skin + \"/content.css\");\n\n\t\t\ted.onInit.add(function() {\n\t\t\t\ted.onNodeChange.add(function(ed, cm) {\n\t\t\t\t\ttinymce.each(states, function(c) {\n\t\t\t\t\t\tcm.get(c.toLowerCase()).setActive(ed.queryCommandState(c));\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t});\n\n\t\t\tDOM.loadCSS((s.editor_css ? ed.documentBaseURI.toAbsolute(s.editor_css) : '') || url + \"/skins/\" + s.skin + \"/ui.css\");\n\t\t},\n\n\t\trenderUI : function(o) {\n\t\t\tvar t = this, n = o.targetNode, ic, tb, ed = t.editor, cf = ed.controlManager, sc;\n\n\t\t\tn = DOM.insertAfter(DOM.create('span', {id : ed.id + '_container', 'class' : 'mceEditor ' + ed.settings.skin + 'SimpleSkin'}), n);\n\t\t\tn = sc = DOM.add(n, 'table', {cellPadding : 0, cellSpacing : 0, 'class' : 'mceLayout'});\n\t\t\tn = tb = DOM.add(n, 'tbody');\n\n\t\t\t// Create iframe container\n\t\t\tn = DOM.add(tb, 'tr');\n\t\t\tn = ic = DOM.add(DOM.add(n, 'td'), 'div', {'class' : 'mceIframeContainer'});\n\n\t\t\t// Create toolbar container\n\t\t\tn = DOM.add(DOM.add(tb, 'tr', {'class' : 'last'}), 'td', {'class' : 'mceToolbar mceLast', align : 'center'});\n\n\t\t\t// Create toolbar\n\t\t\ttb = t.toolbar = cf.createToolbar(\"tools1\");\n\t\t\ttb.add(cf.createButton('bold', {title : 'simple.bold_desc', cmd : 'Bold'}));\n\t\t\ttb.add(cf.createButton('italic', {title : 'simple.italic_desc', cmd : 'Italic'}));\n\t\t\ttb.add(cf.createButton('underline', {title : 'simple.underline_desc', cmd : 'Underline'}));\n\t\t\ttb.add(cf.createButton('strikethrough', {title : 'simple.striketrough_desc', cmd : 'Strikethrough'}));\n\t\t\ttb.add(cf.createSeparator());\n\t\t\ttb.add(cf.createButton('undo', {title : 'simple.undo_desc', cmd : 'Undo'}));\n\t\t\ttb.add(cf.createButton('redo', {title : 'simple.redo_desc', cmd : 'Redo'}));\n\t\t\ttb.add(cf.createSeparator());\n\t\t\ttb.add(cf.createButton('cleanup', {title : 'simple.cleanup_desc', cmd : 'mceCleanup'}));\n\t\t\ttb.add(cf.createSeparator());\n\t\t\ttb.add(cf.createButton('insertunorderedlist', {title : 'simple.bullist_desc', cmd : 'InsertUnorderedList'}));\n\t\t\ttb.add(cf.createButton('insertorderedlist', {title : 'simple.numlist_desc', cmd : 'InsertOrderedList'}));\n\t\t\ttb.renderTo(n);\n\n\t\t\treturn {\n\t\t\t\tiframeContainer : ic,\n\t\t\t\teditorContainer : ed.id + '_container',\n\t\t\t\tsizeContainer : sc,\n\t\t\t\tdeltaHeight : -20\n\t\t\t};\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Simple theme',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t}\n\t\t}\n\t});\n\n\ttinymce.ThemeManager.add('simple', tinymce.themes.SimpleTheme);\n})();","Magento_Tinymce3/tiny_mce/themes/simple/editor_template.js":"(function(){var a=tinymce.DOM;tinymce.ThemeManager.requireLangPack(\"simple\");tinymce.create(\"tinymce.themes.SimpleTheme\",{init:function(c,d){var e=this,b=[\"Bold\",\"Italic\",\"Underline\",\"Strikethrough\",\"InsertUnorderedList\",\"InsertOrderedList\"],f=c.settings;e.editor=c;c.contentCSS.push(d+\"/skins/\"+f.skin+\"/content.css\");c.onInit.add(function(){c.onNodeChange.add(function(h,g){tinymce.each(b,function(i){g.get(i.toLowerCase()).setActive(h.queryCommandState(i))})})});a.loadCSS((f.editor_css?c.documentBaseURI.toAbsolute(f.editor_css):\"\")||d+\"/skins/\"+f.skin+\"/ui.css\")},renderUI:function(h){var e=this,i=h.targetNode,b,c,d=e.editor,f=d.controlManager,g;i=a.insertAfter(a.create(\"span\",{id:d.id+\"_container\",\"class\":\"mceEditor \"+d.settings.skin+\"SimpleSkin\"}),i);i=g=a.add(i,\"table\",{cellPadding:0,cellSpacing:0,\"class\":\"mceLayout\"});i=c=a.add(i,\"tbody\");i=a.add(c,\"tr\");i=b=a.add(a.add(i,\"td\"),\"div\",{\"class\":\"mceIframeContainer\"});i=a.add(a.add(c,\"tr\",{\"class\":\"last\"}),\"td\",{\"class\":\"mceToolbar mceLast\",align:\"center\"});c=e.toolbar=f.createToolbar(\"tools1\");c.add(f.createButton(\"bold\",{title:\"simple.bold_desc\",cmd:\"Bold\"}));c.add(f.createButton(\"italic\",{title:\"simple.italic_desc\",cmd:\"Italic\"}));c.add(f.createButton(\"underline\",{title:\"simple.underline_desc\",cmd:\"Underline\"}));c.add(f.createButton(\"strikethrough\",{title:\"simple.striketrough_desc\",cmd:\"Strikethrough\"}));c.add(f.createSeparator());c.add(f.createButton(\"undo\",{title:\"simple.undo_desc\",cmd:\"Undo\"}));c.add(f.createButton(\"redo\",{title:\"simple.redo_desc\",cmd:\"Redo\"}));c.add(f.createSeparator());c.add(f.createButton(\"cleanup\",{title:\"simple.cleanup_desc\",cmd:\"mceCleanup\"}));c.add(f.createSeparator());c.add(f.createButton(\"insertunorderedlist\",{title:\"simple.bullist_desc\",cmd:\"InsertUnorderedList\"}));c.add(f.createButton(\"insertorderedlist\",{title:\"simple.numlist_desc\",cmd:\"InsertOrderedList\"}));c.renderTo(i);return{iframeContainer:b,editorContainer:d.id+\"_container\",sizeContainer:g,deltaHeight:-20}},getInfo:function(){return{longname:\"Simple theme\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.ThemeManager.add(\"simple\",tinymce.themes.SimpleTheme)})();","Magento_Tinymce3/tiny_mce/themes/simple/langs/en.js":"tinyMCE.addI18n('en.simple',{\"cleanup_desc\":\"Cleanup Messy Code\",\"redo_desc\":\"Redo (Ctrl+Y)\",\"undo_desc\":\"Undo (Ctrl+Z)\",\"numlist_desc\":\"Insert/Remove Numbered List\",\"bullist_desc\":\"Insert/Remove Bulleted List\",\"striketrough_desc\":\"Strikethrough\",\"underline_desc\":\"Underline (Ctrl+U)\",\"italic_desc\":\"Italic (Ctrl+I)\",\"bold_desc\":\"Bold (Ctrl+B)\"});","Magento_Tinymce3/tiny_mce/plugins/spellchecker/editor_plugin.js":"(function(){var a=tinymce.util.JSONRequest,c=tinymce.each,b=tinymce.DOM;tinymce.create(\"tinymce.plugins.SpellcheckerPlugin\",{getInfo:function(){return{longname:\"Spellchecker\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/spellchecker\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}},init:function(e,f){var g=this,d;g.url=f;g.editor=e;g.rpcUrl=e.getParam(\"spellchecker_rpc_url\",\"{backend}\");if(g.rpcUrl==\"{backend}\"){if(tinymce.isIE){return}g.hasSupport=true;e.onContextMenu.addToTop(function(h,i){if(g.active){return false}})}e.addCommand(\"mceSpellCheck\",function(){if(g.rpcUrl==\"{backend}\"){g.editor.getBody().spellcheck=g.active=!g.active;return}if(!g.active){e.setProgressState(1);g._sendRPC(\"checkWords\",[g.selectedLang,g._getWords()],function(h){if(h.length>0){g.active=1;g._markWords(h);e.setProgressState(0);e.nodeChanged()}else{e.setProgressState(0);if(e.getParam(\"spellchecker_report_no_misspellings\",true)){e.windowManager.alert(\"spellchecker.no_mpell\")}}})}else{g._done()}});if(e.settings.content_css!==false){e.contentCSS.push(f+\"/css/content.css\")}e.onClick.add(g._showMenu,g);e.onContextMenu.add(g._showMenu,g);e.onBeforeGetContent.add(function(){if(g.active){g._removeWords()}});e.onNodeChange.add(function(i,h){h.setActive(\"spellchecker\",g.active)});e.onSetContent.add(function(){g._done()});e.onBeforeGetContent.add(function(){g._done()});e.onBeforeExecCommand.add(function(h,i){if(i==\"mceFullScreen\"){g._done()}});g.languages={};c(e.getParam(\"spellchecker_languages\",\"+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv\",\"hash\"),function(i,h){if(h.indexOf(\"+\")===0){h=h.substring(1);g.selectedLang=i}g.languages[h]=i})},createControl:function(h,d){var f=this,g,e=f.editor;if(h==\"spellchecker\"){if(f.rpcUrl==\"{backend}\"){if(f.hasSupport){g=d.createButton(h,{title:\"spellchecker.desc\",cmd:\"mceSpellCheck\",scope:f})}return g}g=d.createSplitButton(h,{title:\"spellchecker.desc\",cmd:\"mceSpellCheck\",scope:f});g.onRenderMenu.add(function(j,i){i.add({title:\"spellchecker.langs\",\"class\":\"mceMenuItemTitle\"}).setDisabled(1);c(f.languages,function(n,m){var p={icon:1},l;p.onclick=function(){if(n==f.selectedLang){return}l.setSelected(1);f.selectedItem.setSelected(0);f.selectedItem=l;f.selectedLang=n};p.title=m;l=i.add(p);l.setSelected(n==f.selectedLang);if(n==f.selectedLang){f.selectedItem=l}})});return g}},_walk:function(i,g){var h=this.editor.getDoc(),e;if(h.createTreeWalker){e=h.createTreeWalker(i,NodeFilter.SHOW_TEXT,null,false);while((i=e.nextNode())!=null){g.call(this,i)}}else{tinymce.walk(i,g,\"childNodes\")}},_getSeparators:function(){var e=\"\",d,f=this.editor.getParam(\"spellchecker_word_separator_chars\",'\\\\s!\"#$%&()*+,-./:;<=>?@[]^_{|}????????????????\\u201d\\u201c');for(d=0;d<f.length;d++){e+=\"\\\\\"+f.charAt(d)}return e},_getWords:function(){var e=this.editor,g=[],d=\"\",f={},h=[];this._walk(e.getBody(),function(i){if(i.nodeType==3){d+=i.nodeValue+\" \"}});if(e.getParam(\"spellchecker_word_pattern\")){h=d.match(\"(\"+e.getParam(\"spellchecker_word_pattern\")+\")\",\"gi\")}else{d=d.replace(new RegExp(\"([0-9]|[\"+this._getSeparators()+\"])\",\"g\"),\" \");d=tinymce.trim(d.replace(/(\\s+)/g,\" \"));h=d.split(\" \")}c(h,function(i){if(!f[i]){g.push(i);f[i]=1}});return g},_removeWords:function(e){var f=this.editor,h=f.dom,g=f.selection,d=g.getBookmark();c(h.select(\"span\").reverse(),function(i){if(i&&(h.hasClass(i,\"mceItemHiddenSpellWord\")||h.hasClass(i,\"mceItemHidden\"))){if(!e||h.decode(i.innerHTML)==e){h.remove(i,1)}}});g.moveToBookmark(d)},_markWords:function(l){var g=this.editor,f=g.dom,j=g.getDoc(),h=g.selection,i=h.getBookmark(),d=[],k=l.join(\"|\"),m=this._getSeparators(),e=new RegExp(\"(^|[\"+m+\"])(\"+k+\")(?=[\"+m+\"]|$)\",\"g\");this._walk(g.getBody(),function(o){if(o.nodeType==3){d.push(o)}});c(d,function(t){var r,q,o,s,p=t.nodeValue;if(e.test(p)){p=f.encode(p);q=f.create(\"span\",{\"class\":\"mceItemHidden\"});if(tinymce.isIE){p=p.replace(e,\"$1<mcespell>$2</mcespell>\");while((s=p.indexOf(\"<mcespell>\"))!=-1){o=p.substring(0,s);if(o.length){r=j.createTextNode(f.decode(o));q.appendChild(r)}p=p.substring(s+10);s=p.indexOf(\"</mcespell>\");o=p.substring(0,s);p=p.substring(s+11);q.appendChild(f.create(\"span\",{\"class\":\"mceItemHiddenSpellWord\"},o))}if(p.length){r=j.createTextNode(f.decode(p));q.appendChild(r)}}else{q.innerHTML=p.replace(e,'$1<span class=\"mceItemHiddenSpellWord\">$2</span>')}f.replace(q,t)}});h.moveToBookmark(i)},_showMenu:function(h,j){var i=this,h=i.editor,d=i._menu,l,k=h.dom,g=k.getViewPort(h.getWin()),f=j.target;j=0;if(!d){d=h.controlManager.createDropMenu(\"spellcheckermenu\",{\"class\":\"mceNoIcons\"});i._menu=d}if(k.hasClass(f,\"mceItemHiddenSpellWord\")){d.removeAll();d.add({title:\"spellchecker.wait\",\"class\":\"mceMenuItemTitle\"}).setDisabled(1);i._sendRPC(\"getSuggestions\",[i.selectedLang,k.decode(f.innerHTML)],function(m){var e;d.removeAll();if(m.length>0){d.add({title:\"spellchecker.sug\",\"class\":\"mceMenuItemTitle\"}).setDisabled(1);c(m,function(n){d.add({title:n,onclick:function(){k.replace(h.getDoc().createTextNode(n),f);i._checkDone()}})});d.addSeparator()}else{d.add({title:\"spellchecker.no_sug\",\"class\":\"mceMenuItemTitle\"}).setDisabled(1)}if(h.getParam(\"show_ignore_words\",true)){e=i.editor.getParam(\"spellchecker_enable_ignore_rpc\",\"\");d.add({title:\"spellchecker.ignore_word\",onclick:function(){var n=f.innerHTML;k.remove(f,1);i._checkDone();if(e){h.setProgressState(1);i._sendRPC(\"ignoreWord\",[i.selectedLang,n],function(o){h.setProgressState(0)})}}});d.add({title:\"spellchecker.ignore_words\",onclick:function(){var n=f.innerHTML;i._removeWords(k.decode(n));i._checkDone();if(e){h.setProgressState(1);i._sendRPC(\"ignoreWords\",[i.selectedLang,n],function(o){h.setProgressState(0)})}}})}if(i.editor.getParam(\"spellchecker_enable_learn_rpc\")){d.add({title:\"spellchecker.learn_word\",onclick:function(){var n=f.innerHTML;k.remove(f,1);i._checkDone();h.setProgressState(1);i._sendRPC(\"learnWord\",[i.selectedLang,n],function(o){h.setProgressState(0)})}})}d.update()});l=b.getPos(h.getContentAreaContainer());d.settings.offset_x=l.x;d.settings.offset_y=l.y;h.selection.select(f);l=k.getPos(f);d.showMenu(l.x,l.y+f.offsetHeight-g.y);return tinymce.dom.Event.cancel(j)}else{d.hideMenu()}},_checkDone:function(){var e=this,d=e.editor,g=d.dom,f;c(g.select(\"span\"),function(h){if(h&&g.hasClass(h,\"mceItemHiddenSpellWord\")){f=true;return false}});if(!f){e._done()}},_done:function(){var d=this,e=d.active;if(d.active){d.active=0;d._removeWords();if(d._menu){d._menu.hideMenu()}if(e){d.editor.nodeChanged()}}},_sendRPC:function(e,g,d){var f=this;a.sendRPC({url:f.rpcUrl,method:e,params:g,success:d,error:function(i,h){f.editor.setProgressState(0);f.editor.windowManager.alert(i.errstr||(\"Error response: \"+h.responseText))}})}});tinymce.PluginManager.add(\"spellchecker\",tinymce.plugins.SpellcheckerPlugin)})();","Magento_Tinymce3/tiny_mce/plugins/spellchecker/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\tvar JSONRequest = tinymce.util.JSONRequest, each = tinymce.each, DOM = tinymce.DOM;\n\n\ttinymce.create('tinymce.plugins.SpellcheckerPlugin', {\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Spellchecker',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/spellchecker',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t},\n\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this, cm;\n\n\t\t\tt.url = url;\n\t\t\tt.editor = ed;\n\t\t\tt.rpcUrl = ed.getParam(\"spellchecker_rpc_url\", \"{backend}\");\n\n\t\t\tif (t.rpcUrl == '{backend}') {\n\t\t\t\t// Sniff if the browser supports native spellchecking (Don't know of a better way)\n\t\t\t\tif (tinymce.isIE)\n\t\t\t\t\treturn;\n\n\t\t\t\tt.hasSupport = true;\n\n\t\t\t\t// Disable the context menu when spellchecking is active\n\t\t\t\ted.onContextMenu.addToTop(function(ed, e) {\n\t\t\t\t\tif (t.active)\n\t\t\t\t\t\treturn false;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceSpellCheck', function() {\n\t\t\t\tif (t.rpcUrl == '{backend}') {\n\t\t\t\t\t// Enable/disable native spellchecker\n\t\t\t\t\tt.editor.getBody().spellcheck = t.active = !t.active;\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (!t.active) {\n\t\t\t\t\ted.setProgressState(1);\n\t\t\t\t\tt._sendRPC('checkWords', [t.selectedLang, t._getWords()], function(r) {\n\t\t\t\t\t\tif (r.length > 0) {\n\t\t\t\t\t\t\tt.active = 1;\n\t\t\t\t\t\t\tt._markWords(r);\n\t\t\t\t\t\t\ted.setProgressState(0);\n\t\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\ted.setProgressState(0);\n\n\t\t\t\t\t\t\tif (ed.getParam('spellchecker_report_no_misspellings', true))\n\t\t\t\t\t\t\t\ted.windowManager.alert('spellchecker.no_mpell');\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t} else\n\t\t\t\t\tt._done();\n\t\t\t});\n\n\t\t\tif (ed.settings.content_css !== false)\n\t\t\t\ted.contentCSS.push(url + '/css/content.css');\n\n\t\t\ted.onClick.add(t._showMenu, t);\n\t\t\ted.onContextMenu.add(t._showMenu, t);\n\t\t\ted.onBeforeGetContent.add(function() {\n\t\t\t\tif (t.active)\n\t\t\t\t\tt._removeWords();\n\t\t\t});\n\n\t\t\ted.onNodeChange.add(function(ed, cm) {\n\t\t\t\tcm.setActive('spellchecker', t.active);\n\t\t\t});\n\n\t\t\ted.onSetContent.add(function() {\n\t\t\t\tt._done();\n\t\t\t});\n\n\t\t\ted.onBeforeGetContent.add(function() {\n\t\t\t\tt._done();\n\t\t\t});\n\n\t\t\ted.onBeforeExecCommand.add(function(ed, cmd) {\n\t\t\t\tif (cmd == 'mceFullScreen')\n\t\t\t\t\tt._done();\n\t\t\t});\n\n\t\t\t// Find selected language\n\t\t\tt.languages = {};\n\t\t\teach(ed.getParam('spellchecker_languages', '+English=en,Danish=da,Dutch=nl,Finnish=fi,French=fr,German=de,Italian=it,Polish=pl,Portuguese=pt,Spanish=es,Swedish=sv', 'hash'), function(v, k) {\n\t\t\t\tif (k.indexOf('+') === 0) {\n\t\t\t\t\tk = k.substring(1);\n\t\t\t\t\tt.selectedLang = v;\n\t\t\t\t}\n\n\t\t\t\tt.languages[k] = v;\n\t\t\t});\n\t\t},\n\n\t\tcreateControl : function(n, cm) {\n\t\t\tvar t = this, c, ed = t.editor;\n\n\t\t\tif (n == 'spellchecker') {\n\t\t\t\t// Use basic button if we use the native spellchecker\n\t\t\t\tif (t.rpcUrl == '{backend}') {\n\t\t\t\t\t// Create simple toggle button if we have native support\n\t\t\t\t\tif (t.hasSupport)\n\t\t\t\t\t\tc = cm.createButton(n, {title : 'spellchecker.desc', cmd : 'mceSpellCheck', scope : t});\n\n\t\t\t\t\treturn c;\n\t\t\t\t}\n\n\t\t\t\tc = cm.createSplitButton(n, {title : 'spellchecker.desc', cmd : 'mceSpellCheck', scope : t});\n\n\t\t\t\tc.onRenderMenu.add(function(c, m) {\n\t\t\t\t\tm.add({title : 'spellchecker.langs', 'class' : 'mceMenuItemTitle'}).setDisabled(1);\n\t\t\t\t\teach(t.languages, function(v, k) {\n\t\t\t\t\t\tvar o = {icon : 1}, mi;\n\n\t\t\t\t\t\to.onclick = function() {\n\t\t\t\t\t\t\tif (v == t.selectedLang) {\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tmi.setSelected(1);\n\t\t\t\t\t\t\tt.selectedItem.setSelected(0);\n\t\t\t\t\t\t\tt.selectedItem = mi;\n\t\t\t\t\t\t\tt.selectedLang = v;\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\to.title = k;\n\t\t\t\t\t\tmi = m.add(o);\n\t\t\t\t\t\tmi.setSelected(v == t.selectedLang);\n\n\t\t\t\t\t\tif (v == t.selectedLang)\n\t\t\t\t\t\t\tt.selectedItem = mi;\n\t\t\t\t\t})\n\t\t\t\t});\n\n\t\t\t\treturn c;\n\t\t\t}\n\t\t},\n\n\t\t// Internal functions\n\n\t\t_walk : function(n, f) {\n\t\t\tvar d = this.editor.getDoc(), w;\n\n\t\t\tif (d.createTreeWalker) {\n\t\t\t\tw = d.createTreeWalker(n, NodeFilter.SHOW_TEXT, null, false);\n\n\t\t\t\twhile ((n = w.nextNode()) != null)\n\t\t\t\t\tf.call(this, n);\n\t\t\t} else\n\t\t\t\ttinymce.walk(n, f, 'childNodes');\n\t\t},\n\n\t\t_getSeparators : function() {\n\t\t\tvar re = '', i, str = this.editor.getParam('spellchecker_word_separator_chars', '\\\\s!\"#$%&()*+,-./:;<=>?@[\\]^_{|}\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\\u201d\\u201c');\n\n\t\t\t// Build word separator regexp\n\t\t\tfor (i=0; i<str.length; i++)\n\t\t\t\tre += '\\\\' + str.charAt(i);\n\n\t\t\treturn re;\n\t\t},\n\n\t\t_getWords : function() {\n\t\t\tvar ed = this.editor, wl = [], tx = '', lo = {}, rawWords = [];\n\n\t\t\t// Get area text\n\t\t\tthis._walk(ed.getBody(), function(n) {\n\t\t\t\tif (n.nodeType == 3)\n\t\t\t\t\ttx += n.nodeValue + ' ';\n\t\t\t});\n\n\t\t\t// split the text up into individual words\n\t\t\tif (ed.getParam('spellchecker_word_pattern')) {\n\t\t\t\t// look for words that match the pattern\n\t\t\t\trawWords = tx.match('(' + ed.getParam('spellchecker_word_pattern') + ')', 'gi');\n\t\t\t} else {\n\t\t\t\t// Split words by separator\n\t\t\t\ttx = tx.replace(new RegExp('([0-9]|[' + this._getSeparators() + '])', 'g'), ' ');\n\t\t\t\ttx = tinymce.trim(tx.replace(/(\\s+)/g, ' '));\n\t\t\t\trawWords = tx.split(' ');\n\t\t\t}\n\n\t\t\t// Build word array and remove duplicates\n\t\t\teach(rawWords, function(v) {\n\t\t\t\tif (!lo[v]) {\n\t\t\t\t\twl.push(v);\n\t\t\t\t\tlo[v] = 1;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn wl;\n\t\t},\n\n\t\t_removeWords : function(w) {\n\t\t\tvar ed = this.editor, dom = ed.dom, se = ed.selection, b = se.getBookmark();\n\n\t\t\teach(dom.select('span').reverse(), function(n) {\n\t\t\t\tif (n && (dom.hasClass(n, 'mceItemHiddenSpellWord') || dom.hasClass(n, 'mceItemHidden'))) {\n\t\t\t\t\tif (!w || dom.decode(n.innerHTML) == w)\n\t\t\t\t\t\tdom.remove(n, 1);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tse.moveToBookmark(b);\n\t\t},\n\n\t\t_markWords : function(wl) {\n\t\t\tvar ed = this.editor, dom = ed.dom, doc = ed.getDoc(), se = ed.selection, b = se.getBookmark(), nl = [],\n\t\t\t\tw = wl.join('|'), re = this._getSeparators(), rx = new RegExp('(^|[' + re + '])(' + w + ')(?=[' + re + ']|$)', 'g');\n\n\t\t\t// Collect all text nodes\n\t\t\tthis._walk(ed.getBody(), function(n) {\n\t\t\t\tif (n.nodeType == 3) {\n\t\t\t\t\tnl.push(n);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Wrap incorrect words in spans\n\t\t\teach(nl, function(n) {\n\t\t\t\tvar node, elem, txt, pos, v = n.nodeValue;\n\n\t\t\t\tif (rx.test(v)) {\n\t\t\t\t\t// Encode the content\n\t\t\t\t\tv = dom.encode(v);\n\t\t\t\t\t// Create container element\n\t\t\t\t\telem = dom.create('span', {'class' : 'mceItemHidden'});\n\n\t\t\t\t\t// Following code fixes IE issues by creating text nodes\n\t\t\t\t\t// using DOM methods instead of innerHTML.\n\t\t\t\t\t// Bug #3124: <PRE> elements content is broken after spellchecking.\n\t\t\t\t\t// Bug #1408: Preceding whitespace characters are removed\n\t\t\t\t\t// @TODO: I'm not sure that both are still issues on IE9.\n\t\t\t\t\tif (tinymce.isIE) {\n\t\t\t\t\t\t// Enclose mispelled words with temporal tag\n\t\t\t\t\t\tv = v.replace(rx, '$1<mcespell>$2</mcespell>');\n\t\t\t\t\t\t// Loop over the content finding mispelled words\n\t\t\t\t\t\twhile ((pos = v.indexOf('<mcespell>')) != -1) {\n\t\t\t\t\t\t\t// Add text node for the content before the word\n\t\t\t\t\t\t\ttxt = v.substring(0, pos);\n\t\t\t\t\t\t\tif (txt.length) {\n\t\t\t\t\t\t\t\tnode = doc.createTextNode(dom.decode(txt));\n\t\t\t\t\t\t\t\telem.appendChild(node);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tv = v.substring(pos+10);\n\t\t\t\t\t\t\tpos = v.indexOf('</mcespell>');\n\t\t\t\t\t\t\ttxt = v.substring(0, pos);\n\t\t\t\t\t\t\tv = v.substring(pos+11);\n\t\t\t\t\t\t\t// Add span element for the word\n\t\t\t\t\t\t\telem.appendChild(dom.create('span', {'class' : 'mceItemHiddenSpellWord'}, txt));\n\t\t\t\t\t\t}\n\t\t\t\t\t\t// Add text node for the rest of the content\n\t\t\t\t\t\tif (v.length) {\n\t\t\t\t\t\t\tnode = doc.createTextNode(dom.decode(v));\n\t\t\t\t\t\t\telem.appendChild(node);\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Other browsers preserve whitespace characters on innerHTML usage\n\t\t\t\t\t\telem.innerHTML = v.replace(rx, '$1<span class=\"mceItemHiddenSpellWord\">$2</span>');\n\t\t\t\t\t}\n\n\t\t\t\t\t// Finally, replace the node with the container\n\t\t\t\t\tdom.replace(elem, n);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tse.moveToBookmark(b);\n\t\t},\n\n\t\t_showMenu : function(ed, e) {\n\t\t\tvar t = this, ed = t.editor, m = t._menu, p1, dom = ed.dom, vp = dom.getViewPort(ed.getWin()), wordSpan = e.target;\n\n\t\t\te = 0; // Fixes IE memory leak\n\n\t\t\tif (!m) {\n\t\t\t\tm = ed.controlManager.createDropMenu('spellcheckermenu', {'class' : 'mceNoIcons'});\n\t\t\t\tt._menu = m;\n\t\t\t}\n\n\t\t\tif (dom.hasClass(wordSpan, 'mceItemHiddenSpellWord')) {\n\t\t\t\tm.removeAll();\n\t\t\t\tm.add({title : 'spellchecker.wait', 'class' : 'mceMenuItemTitle'}).setDisabled(1);\n\n\t\t\t\tt._sendRPC('getSuggestions', [t.selectedLang, dom.decode(wordSpan.innerHTML)], function(r) {\n\t\t\t\t\tvar ignoreRpc;\n\n\t\t\t\t\tm.removeAll();\n\n\t\t\t\t\tif (r.length > 0) {\n\t\t\t\t\t\tm.add({title : 'spellchecker.sug', 'class' : 'mceMenuItemTitle'}).setDisabled(1);\n\t\t\t\t\t\teach(r, function(v) {\n\t\t\t\t\t\t\tm.add({title : v, onclick : function() {\n\t\t\t\t\t\t\t\tdom.replace(ed.getDoc().createTextNode(v), wordSpan);\n\t\t\t\t\t\t\t\tt._checkDone();\n\t\t\t\t\t\t\t}});\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tm.addSeparator();\n\t\t\t\t\t} else\n\t\t\t\t\t\tm.add({title : 'spellchecker.no_sug', 'class' : 'mceMenuItemTitle'}).setDisabled(1);\n\n\t\t\t\t\tif (ed.getParam('show_ignore_words', true)) {\n\t\t\t\t\t\tignoreRpc = t.editor.getParam(\"spellchecker_enable_ignore_rpc\", '');\n\t\t\t\t\t\tm.add({\n\t\t\t\t\t\t\ttitle : 'spellchecker.ignore_word',\n\t\t\t\t\t\t\tonclick : function() {\n\t\t\t\t\t\t\t\tvar word = wordSpan.innerHTML;\n\n\t\t\t\t\t\t\t\tdom.remove(wordSpan, 1);\n\t\t\t\t\t\t\t\tt._checkDone();\n\n\t\t\t\t\t\t\t\t// tell the server if we need to\n\t\t\t\t\t\t\t\tif (ignoreRpc) {\n\t\t\t\t\t\t\t\t\ted.setProgressState(1);\n\t\t\t\t\t\t\t\t\tt._sendRPC('ignoreWord', [t.selectedLang, word], function(r) {\n\t\t\t\t\t\t\t\t\t\ted.setProgressState(0);\n\t\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tm.add({\n\t\t\t\t\t\t\ttitle : 'spellchecker.ignore_words',\n\t\t\t\t\t\t\tonclick : function() {\n\t\t\t\t\t\t\t\tvar word = wordSpan.innerHTML;\n\n\t\t\t\t\t\t\t\tt._removeWords(dom.decode(word));\n\t\t\t\t\t\t\t\tt._checkDone();\n\n\t\t\t\t\t\t\t\t// tell the server if we need to\n\t\t\t\t\t\t\t\tif (ignoreRpc) {\n\t\t\t\t\t\t\t\t\ted.setProgressState(1);\n\t\t\t\t\t\t\t\t\tt._sendRPC('ignoreWords', [t.selectedLang, word], function(r) {\n\t\t\t\t\t\t\t\t\t\ted.setProgressState(0);\n\t\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\n\t\t\t\t\tif (t.editor.getParam(\"spellchecker_enable_learn_rpc\")) {\n\t\t\t\t\t\tm.add({\n\t\t\t\t\t\t\ttitle : 'spellchecker.learn_word',\n\t\t\t\t\t\t\tonclick : function() {\n\t\t\t\t\t\t\t\tvar word = wordSpan.innerHTML;\n\n\t\t\t\t\t\t\t\tdom.remove(wordSpan, 1);\n\t\t\t\t\t\t\t\tt._checkDone();\n\n\t\t\t\t\t\t\t\ted.setProgressState(1);\n\t\t\t\t\t\t\t\tt._sendRPC('learnWord', [t.selectedLang, word], function(r) {\n\t\t\t\t\t\t\t\t\ted.setProgressState(0);\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\n\t\t\t\t\tm.update();\n\t\t\t\t});\n\n\t\t\t\tp1 = DOM.getPos(ed.getContentAreaContainer());\n\t\t\t\tm.settings.offset_x = p1.x;\n\t\t\t\tm.settings.offset_y = p1.y;\n\n\t\t\t\ted.selection.select(wordSpan);\n\t\t\t\tp1 = dom.getPos(wordSpan);\n\t\t\t\tm.showMenu(p1.x, p1.y + wordSpan.offsetHeight - vp.y);\n\n\t\t\t\treturn tinymce.dom.Event.cancel(e);\n\t\t\t} else\n\t\t\t\tm.hideMenu();\n\t\t},\n\n\t\t_checkDone : function() {\n\t\t\tvar t = this, ed = t.editor, dom = ed.dom, o;\n\n\t\t\teach(dom.select('span'), function(n) {\n\t\t\t\tif (n && dom.hasClass(n, 'mceItemHiddenSpellWord')) {\n\t\t\t\t\to = true;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tif (!o)\n\t\t\t\tt._done();\n\t\t},\n\n\t\t_done : function() {\n\t\t\tvar t = this, la = t.active;\n\n\t\t\tif (t.active) {\n\t\t\t\tt.active = 0;\n\t\t\t\tt._removeWords();\n\n\t\t\t\tif (t._menu)\n\t\t\t\t\tt._menu.hideMenu();\n\n\t\t\t\tif (la)\n\t\t\t\t\tt.editor.nodeChanged();\n\t\t\t}\n\t\t},\n\n\t\t_sendRPC : function(m, p, cb) {\n\t\t\tvar t = this;\n\n\t\t\tJSONRequest.sendRPC({\n\t\t\t\turl : t.rpcUrl,\n\t\t\t\tmethod : m,\n\t\t\t\tparams : p,\n\t\t\t\tsuccess : cb,\n\t\t\t\terror : function(e, x) {\n\t\t\t\t\tt.editor.setProgressState(0);\n\t\t\t\t\tt.editor.windowManager.alert(e.errstr || ('Error response: ' + x.responseText));\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('spellchecker', tinymce.plugins.SpellcheckerPlugin);\n})();\n","Magento_Tinymce3/tiny_mce/plugins/insertdatetime/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.InsertDateTime\",{init:function(a,b){var c=this;c.editor=a;a.addCommand(\"mceInsertDate\",function(){var d=c._getDateTime(new Date(),a.getParam(\"plugin_insertdate_dateFormat\",a.getLang(\"insertdatetime.date_fmt\")));a.execCommand(\"mceInsertContent\",false,d)});a.addCommand(\"mceInsertTime\",function(){var d=c._getDateTime(new Date(),a.getParam(\"plugin_insertdate_timeFormat\",a.getLang(\"insertdatetime.time_fmt\")));a.execCommand(\"mceInsertContent\",false,d)});a.addButton(\"insertdate\",{title:\"insertdatetime.insertdate_desc\",cmd:\"mceInsertDate\"});a.addButton(\"inserttime\",{title:\"insertdatetime.inserttime_desc\",cmd:\"mceInsertTime\"})},getInfo:function(){return{longname:\"Insert date/time\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/insertdatetime\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}},_getDateTime:function(e,a){var c=this.editor;function b(g,d){g=\"\"+g;if(g.length<d){for(var f=0;f<(d-g.length);f++){g=\"0\"+g}}return g}a=a.replace(\"%D\",\"%m/%d/%y\");a=a.replace(\"%r\",\"%I:%M:%S %p\");a=a.replace(\"%Y\",\"\"+e.getFullYear());a=a.replace(\"%y\",\"\"+e.getYear());a=a.replace(\"%m\",b(e.getMonth()+1,2));a=a.replace(\"%d\",b(e.getDate(),2));a=a.replace(\"%H\",\"\"+b(e.getHours(),2));a=a.replace(\"%M\",\"\"+b(e.getMinutes(),2));a=a.replace(\"%S\",\"\"+b(e.getSeconds(),2));a=a.replace(\"%I\",\"\"+((e.getHours()+11)%12+1));a=a.replace(\"%p\",\"\"+(e.getHours()<12?\"AM\":\"PM\"));a=a.replace(\"%B\",\"\"+c.getLang(\"insertdatetime.months_long\").split(\",\")[e.getMonth()]);a=a.replace(\"%b\",\"\"+c.getLang(\"insertdatetime.months_short\").split(\",\")[e.getMonth()]);a=a.replace(\"%A\",\"\"+c.getLang(\"insertdatetime.day_long\").split(\",\")[e.getDay()]);a=a.replace(\"%a\",\"\"+c.getLang(\"insertdatetime.day_short\").split(\",\")[e.getDay()]);a=a.replace(\"%%\",\"%\");return a}});tinymce.PluginManager.add(\"insertdatetime\",tinymce.plugins.InsertDateTime)})();","Magento_Tinymce3/tiny_mce/plugins/insertdatetime/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.InsertDateTime', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this;\n\n\t\t\tt.editor = ed;\n\n\t\t\ted.addCommand('mceInsertDate', function() {\n\t\t\t\tvar str = t._getDateTime(new Date(), ed.getParam(\"plugin_insertdate_dateFormat\", ed.getLang('insertdatetime.date_fmt')));\n\n\t\t\t\ted.execCommand('mceInsertContent', false, str);\n\t\t\t});\n\n\t\t\ted.addCommand('mceInsertTime', function() {\n\t\t\t\tvar str = t._getDateTime(new Date(), ed.getParam(\"plugin_insertdate_timeFormat\", ed.getLang('insertdatetime.time_fmt')));\n\n\t\t\t\ted.execCommand('mceInsertContent', false, str);\n\t\t\t});\n\n\t\t\ted.addButton('insertdate', {title : 'insertdatetime.insertdate_desc', cmd : 'mceInsertDate'});\n\t\t\ted.addButton('inserttime', {title : 'insertdatetime.inserttime_desc', cmd : 'mceInsertTime'});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Insert date/time',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/insertdatetime',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t},\n\n\t\t// Private methods\n\n\t\t_getDateTime : function(d, fmt) {\n\t\t\tvar ed = this.editor;\n\n\t\t\tfunction addZeros(value, len) {\n\t\t\t\tvalue = \"\" + value;\n\n\t\t\t\tif (value.length < len) {\n\t\t\t\t\tfor (var i=0; i<(len-value.length); i++)\n\t\t\t\t\t\tvalue = \"0\" + value;\n\t\t\t\t}\n\n\t\t\t\treturn value;\n\t\t\t};\n\n\t\t\tfmt = fmt.replace(\"%D\", \"%m/%d/%y\");\n\t\t\tfmt = fmt.replace(\"%r\", \"%I:%M:%S %p\");\n\t\t\tfmt = fmt.replace(\"%Y\", \"\" + d.getFullYear());\n\t\t\tfmt = fmt.replace(\"%y\", \"\" + d.getYear());\n\t\t\tfmt = fmt.replace(\"%m\", addZeros(d.getMonth()+1, 2));\n\t\t\tfmt = fmt.replace(\"%d\", addZeros(d.getDate(), 2));\n\t\t\tfmt = fmt.replace(\"%H\", \"\" + addZeros(d.getHours(), 2));\n\t\t\tfmt = fmt.replace(\"%M\", \"\" + addZeros(d.getMinutes(), 2));\n\t\t\tfmt = fmt.replace(\"%S\", \"\" + addZeros(d.getSeconds(), 2));\n\t\t\tfmt = fmt.replace(\"%I\", \"\" + ((d.getHours() + 11) % 12 + 1));\n\t\t\tfmt = fmt.replace(\"%p\", \"\" + (d.getHours() < 12 ? \"AM\" : \"PM\"));\n\t\t\tfmt = fmt.replace(\"%B\", \"\" + ed.getLang(\"insertdatetime.months_long\").split(',')[d.getMonth()]);\n\t\t\tfmt = fmt.replace(\"%b\", \"\" + ed.getLang(\"insertdatetime.months_short\").split(',')[d.getMonth()]);\n\t\t\tfmt = fmt.replace(\"%A\", \"\" + ed.getLang(\"insertdatetime.day_long\").split(',')[d.getDay()]);\n\t\t\tfmt = fmt.replace(\"%a\", \"\" + ed.getLang(\"insertdatetime.day_short\").split(',')[d.getDay()]);\n\t\t\tfmt = fmt.replace(\"%%\", \"%\");\n\n\t\t\treturn fmt;\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('insertdatetime', tinymce.plugins.InsertDateTime);\n})();","Magento_Tinymce3/tiny_mce/plugins/example/editor_plugin.js":"(function(){tinymce.PluginManager.requireLangPack(\"example\");tinymce.create(\"tinymce.plugins.ExamplePlugin\",{init:function(a,b){a.addCommand(\"mceExample\",function(){a.windowManager.open({file:b+\"/dialog.htm\",width:320+parseInt(a.getLang(\"example.delta_width\",0)),height:120+parseInt(a.getLang(\"example.delta_height\",0)),inline:1},{plugin_url:b,some_custom_arg:\"custom arg\"})});a.addButton(\"example\",{title:\"example.desc\",cmd:\"mceExample\",image:b+\"/img/example.gif\"});a.onNodeChange.add(function(d,c,e){c.setActive(\"example\",e.nodeName==\"IMG\")})},createControl:function(b,a){return null},getInfo:function(){return{longname:\"Example plugin\",author:\"Some author\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/example\",version:\"1.0\"}}});tinymce.PluginManager.add(\"example\",tinymce.plugins.ExamplePlugin)})();","Magento_Tinymce3/tiny_mce/plugins/example/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\t// Load plugin specific language pack\n\ttinymce.PluginManager.requireLangPack('example');\n\n\ttinymce.create('tinymce.plugins.ExamplePlugin', {\n\t\t/**\n\t\t * Initializes the plugin, this will be executed after the plugin has been created.\n\t\t * This call is done before the editor instance has finished it's initialization so use the onInit event\n\t\t * of the editor instance to intercept that event.\n\t\t *\n\t\t * @param {tinymce.Editor} ed Editor instance that the plugin is initialized in.\n\t\t * @param {string} url Absolute URL to where the plugin is located.\n\t\t */\n\t\tinit : function(ed, url) {\n\t\t\t// Register the command so that it can be invoked by using tinyMCE.activeEditor.execCommand('mceExample');\n\t\t\ted.addCommand('mceExample', function() {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/dialog.htm',\n\t\t\t\t\twidth : 320 + parseInt(ed.getLang('example.delta_width', 0)),\n\t\t\t\t\theight : 120 + parseInt(ed.getLang('example.delta_height', 0)),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url, // Plugin absolute URL\n\t\t\t\t\tsome_custom_arg : 'custom arg' // Custom argument\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// Register example button\n\t\t\ted.addButton('example', {\n\t\t\t\ttitle : 'example.desc',\n\t\t\t\tcmd : 'mceExample',\n\t\t\t\timage : url + '/img/example.gif'\n\t\t\t});\n\n\t\t\t// Add a node change handler, selects the button in the UI when a image is selected\n\t\t\ted.onNodeChange.add(function(ed, cm, n) {\n\t\t\t\tcm.setActive('example', n.nodeName == 'IMG');\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Creates control instances based in the incoming name. This method is normally not\n\t\t * needed since the addButton method of the tinymce.Editor class is a more easy way of adding buttons\n\t\t * but you sometimes need to create more complex controls like listboxes, split buttons etc then this\n\t\t * method can be used to create those.\n\t\t *\n\t\t * @param {String} n Name of the control to create.\n\t\t * @param {tinymce.ControlManager} cm Control manager to use inorder to create new control.\n\t\t * @return {tinymce.ui.Control} New control instance or null if no control was created.\n\t\t */\n\t\tcreateControl : function(n, cm) {\n\t\t\treturn null;\n\t\t},\n\n\t\t/**\n\t\t * Returns information about the plugin as a name/value array.\n\t\t * The current keys are longname, author, authorurl, infourl and version.\n\t\t *\n\t\t * @return {Object} Name/value array containing information about the plugin.\n\t\t */\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Example plugin',\n\t\t\t\tauthor : 'Some author',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/example',\n\t\t\t\tversion : \"1.0\"\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('example', tinymce.plugins.ExamplePlugin);\n})();","Magento_Tinymce3/tiny_mce/plugins/example/js/dialog.js":"tinyMCEPopup.requireLangPack();\n\nvar ExampleDialog = {\n\tinit : function() {\n\t\tvar f = document.forms[0];\n\n\t\t// Get the selected contents as text and place it in the input\n\t\tf.someval.value = tinyMCEPopup.editor.selection.getContent({format : 'text'});\n\t\tf.somearg.value = tinyMCEPopup.getWindowArg('some_custom_arg');\n\t},\n\n\tinsert : function() {\n\t\t// Insert the contents from the input into the document\n\t\ttinyMCEPopup.editor.execCommand('mceInsertContent', false, document.forms[0].someval.value);\n\t\ttinyMCEPopup.close();\n\t}\n};\n\ntinyMCEPopup.onInit.add(ExampleDialog.init, ExampleDialog);\n","Magento_Tinymce3/tiny_mce/plugins/example/langs/en.js":"tinyMCE.addI18n('en.example',{\n\tdesc : 'This is just a template button'\n});\n","Magento_Tinymce3/tiny_mce/plugins/example/langs/en_dlg.js":"tinyMCE.addI18n('en.example_dlg',{\n\ttitle : 'This is just a example title'\n});\n","Magento_Tinymce3/tiny_mce/plugins/lists/editor_plugin.js":"(function(){var e=tinymce.each,r=tinymce.dom.Event,g;function p(t,s){while(t&&(t.nodeType===8||(t.nodeType===3&&/^[ \\t\\n\\r]*$/.test(t.nodeValue)))){t=s(t)}return t}function b(s){return p(s,function(t){return t.previousSibling})}function i(s){return p(s,function(t){return t.nextSibling})}function d(s,u,t){return s.dom.getParent(u,function(v){return tinymce.inArray(t,v)!==-1})}function n(s){return s&&(s.tagName===\"OL\"||s.tagName===\"UL\")}function c(u,v){var t,w,s;t=b(u.lastChild);while(n(t)){w=t;t=b(w.previousSibling)}if(w){s=v.create(\"li\",{style:\"list-style-type: none;\"});v.split(u,w);v.insertAfter(s,w);s.appendChild(w);s.appendChild(w);u=s.previousSibling}return u}function m(t,s,u){t=a(t,s,u);return o(t,s,u)}function a(u,s,v){var t=b(u.previousSibling);if(t){return h(t,u,s?t:false,v)}else{return u}}function o(u,t,v){var s=i(u.nextSibling);if(s){return h(u,s,t?s:false,v)}else{return u}}function h(u,s,t,v){if(l(u,s,!!t,v)){return f(u,s,t)}else{if(u&&u.tagName===\"LI\"&&n(s)){u.appendChild(s)}}return s}function l(u,t,s,v){if(!u||!t){return false}else{if(u.tagName===\"LI\"&&t.tagName===\"LI\"){return t.style.listStyleType===\"none\"||j(t)}else{if(n(u)){return(u.tagName===t.tagName&&(s||u.style.listStyleType===t.style.listStyleType))||q(t)}else{return v&&u.tagName===\"P\"&&t.tagName===\"P\"}}}}function q(t){var s=i(t.firstChild),u=b(t.lastChild);return s&&u&&n(t)&&s===u&&(n(s)||s.style.listStyleType===\"none\"||j(s))}function j(u){var t=i(u.firstChild),s=b(u.lastChild);return t&&s&&t===s&&n(t)}function f(w,v,s){var u=b(w.lastChild),t=i(v.firstChild);if(w.tagName===\"P\"){w.appendChild(w.ownerDocument.createElement(\"br\"))}while(v.firstChild){w.appendChild(v.firstChild)}if(s){w.style.listStyleType=s.style.listStyleType}v.parentNode.removeChild(v);h(u,t,false);return w}function k(t,u){var s;if(!u.is(t,\"li,ol,ul\")){s=u.getParent(t,\"li\");if(s){t=s}}return t}tinymce.create(\"tinymce.plugins.Lists\",{init:function(y){var v=\"TABBING\";var s=\"EMPTY\";var I=\"ESCAPE\";var z=\"PARAGRAPH\";var M=\"UNKNOWN\";var x=M;function E(T){return T.keyCode===tinymce.VK.TAB&&!(T.altKey||T.ctrlKey)&&(y.queryCommandState(\"InsertUnorderedList\")||y.queryCommandState(\"InsertOrderedList\"))}function D(){var T=y.selection.getRng();var U=T.startContainer;if(U.nodeType==3){return(T.endOffset==U.nodeValue.length)}else{if(U.nodeType==1){return T.endOffset==U.childNodes.length}}return false}function N(){var U=y.selection.getNode();var T=U.tagName===\"P\"&&U.parentNode.tagName===\"LI\"&&U.parentNode.lastChild===U;return y.selection.isCollapsed()&&T&&D()}function w(){var T=B();var V=T.parentNode.parentNode;var U=T.parentNode.lastChild===T;return U&&!t(V)&&O(T)}function t(T){if(n(T)){return T.parentNode&&T.parentNode.tagName===\"LI\"}else{return T.tagName===\"LI\"}}function F(){return y.selection.isCollapsed()&&O(B())}function B(){var T=y.selection.getStart();return((T.tagName==\"BR\"||T.tagName==\"\")&&T.parentNode.tagName==\"LI\")?T.parentNode:T}function O(T){var U=T.childNodes.length;if(T.tagName===\"LI\"){return U==0?true:U==1&&(T.firstChild.tagName==\"\"||T.firstChild.tagName==\"BR\"||H(T))}return false}function H(T){var U=tinymce.grep(T.parentNode.childNodes,function(X){return X.tagName==\"LI\"});var V=T==U[U.length-1];var W=T.firstChild;return tinymce.isIE9&&V&&(W.nodeValue==String.fromCharCode(160)||W.nodeValue==String.fromCharCode(32))}function S(T){return T.keyCode===tinymce.VK.ENTER}function A(T){return S(T)&&!T.shiftKey}function L(T){if(E(T)){return v}else{if(A(T)&&w()){return I}else{if(A(T)&&F()){return s}else{if(A(T)&&N()){return z}else{return M}}}}}function C(T,U){if(x==v||x==s||tinymce.isGecko&&x==I){r.cancel(U)}}function J(V,X){if(x==z){var W=V.selection.getNode();var U=V.dom.create(\"li\");var T=V.dom.getParent(W,\"li\");V.dom.insertAfter(U,T);if(tinyMCE.isIE8){U.appendChild(V.dom.create(\"&nbsp;\"));V.selection.setCursorLocation(U,1)}else{if(tinyMCE.isGecko){setTimeout(function(){var Y=V.getDoc().createTextNode(\"\\uFEFF\");U.appendChild(Y);V.selection.setCursorLocation(U,0)},0)}else{V.selection.setCursorLocation(U,0)}}r.cancel(X)}}function u(W,Y){var ab;if(!tinymce.isGecko){return}var U=W.selection.getStart();if(Y.keyCode!=tinymce.VK.BACKSPACE||U.tagName!==\"IMG\"){return}function V(af){var ag=af.firstChild;var ae=null;do{if(!ag){break}if(ag.tagName===\"LI\"){ae=ag}}while(ag=ag.nextSibling);return ae}function ad(af,ae){while(af.childNodes.length>0){ae.appendChild(af.childNodes[0])}}ab=U.parentNode.previousSibling;if(!ab){return}var Z;if(ab.tagName===\"UL\"||ab.tagName===\"OL\"){Z=ab}else{if(ab.previousSibling&&(ab.previousSibling.tagName===\"UL\"||ab.previousSibling.tagName===\"OL\")){Z=ab.previousSibling}else{return}}var ac=V(Z);var T=W.dom.createRng();T.setStart(ac,1);T.setEnd(ac,1);W.selection.setRng(T);W.selection.collapse(true);var X=W.selection.getBookmark();var aa=U.parentNode.cloneNode(true);if(aa.tagName===\"P\"||aa.tagName===\"DIV\"){ad(aa,ac)}else{ac.appendChild(aa)}U.parentNode.parentNode.removeChild(U.parentNode);W.selection.moveToBookmark(X)}function G(T){var U=y.dom.getParent(T,\"ol,ul\");if(U!=null){var V=U.lastChild;V.appendChild(y.getDoc().createElement(\"\"));y.selection.setCursorLocation(V,0)}}this.ed=y;y.addCommand(\"Indent\",this.indent,this);y.addCommand(\"Outdent\",this.outdent,this);y.addCommand(\"InsertUnorderedList\",function(){this.applyList(\"UL\",\"OL\")},this);y.addCommand(\"InsertOrderedList\",function(){this.applyList(\"OL\",\"UL\")},this);y.onInit.add(function(){y.editorCommands.addCommands({outdent:function(){var U=y.selection,V=y.dom;function T(W){W=V.getParent(W,V.isBlock);return W&&(parseInt(y.dom.getStyle(W,\"margin-left\")||0,10)+parseInt(y.dom.getStyle(W,\"padding-left\")||0,10))>0}return T(U.getStart())||T(U.getEnd())||y.queryCommandState(\"InsertOrderedList\")||y.queryCommandState(\"InsertUnorderedList\")}},\"state\")});y.onKeyUp.add(function(U,V){if(x==v){U.execCommand(V.shiftKey?\"Outdent\":\"Indent\",true,null);x=M;return r.cancel(V)}else{if(x==s){var T=B();var X=U.settings.list_outdent_on_enter===true||V.shiftKey;U.execCommand(X?\"Outdent\":\"Indent\",true,null);if(tinymce.isIE){G(T)}return r.cancel(V)}else{if(x==I){if(tinymce.isIE8){var W=U.getDoc().createTextNode(\"\\uFEFF\");U.selection.getNode().appendChild(W)}else{if(tinymce.isIE9||tinymce.isGecko){U.execCommand(\"Outdent\");return r.cancel(V)}}}}}});function K(U,T){var V=y.getDoc().createTextNode(\"\\uFEFF\");U.insertBefore(V,T);y.selection.setCursorLocation(V,0);y.execCommand(\"mceRepaint\")}function Q(U,W){if(S(W)){var T=B();if(T){var V=T.parentNode;var X=V&&V.parentNode;if(X&&X.nodeName==\"LI\"&&X.firstChild==V&&T==V.firstChild){K(X,V)}}}}function R(U,W){if(S(W)){var T=B();if(U.dom.select(\"ul li\",T).length===1){var V=T.firstChild;K(T,V)}}}function P(U,Y){function V(ac,Z){var ab=[];var ad=new tinymce.dom.TreeWalker(Z,ac);for(var aa=ad.current();aa;aa=ad.next()){if(U.dom.is(aa,\"ol,ul,li\")){ab.push(aa)}}return ab}if(Y.keyCode==tinymce.VK.BACKSPACE){var T=B();if(T){var X=U.dom.getParent(T,\"ol,ul\");if(X&&X.firstChild===T){var W=V(X,T);U.execCommand(\"Outdent\",false,W);U.undoManager.add();return r.cancel(Y)}}}}y.onKeyDown.add(function(T,U){x=L(U)});y.onKeyDown.add(C);y.onKeyDown.add(u);y.onKeyDown.add(J);if(tinymce.isGecko){y.onKeyUp.add(Q)}if(tinymce.isIE8){y.onKeyUp.add(R)}if(tinymce.isGecko||tinymce.isWebKit){y.onKeyDown.add(P)}},applyList:function(y,v){var C=this,z=C.ed,I=z.dom,s=[],H=false,u=false,w=false,B,G=z.selection.getSelectedBlocks();function E(t){if(t&&t.tagName===\"BR\"){I.remove(t)}}function F(M){var N=I.create(y),t;function L(O){if(O.style.marginLeft||O.style.paddingLeft){C.adjustPaddingFunction(false)(O)}}if(M.tagName===\"LI\"){}else{if(M.tagName===\"P\"||M.tagName===\"DIV\"||M.tagName===\"BODY\"){K(M,function(P,O){J(P,O,M.tagName===\"BODY\"?null:P.parentNode);t=P.parentNode;L(t);E(O)});if(t){if(t.tagName===\"LI\"&&(M.tagName===\"P\"||G.length>1)){I.split(t.parentNode.parentNode,t.parentNode)}m(t.parentNode,true)}return}else{t=I.create(\"li\");I.insertAfter(t,M);t.appendChild(M);L(M);M=t}}I.insertAfter(N,M);N.appendChild(M);m(N,true);s.push(M)}function J(P,L,N){var t,O=P,M;while(!I.isBlock(P.parentNode)&&P.parentNode!==I.getRoot()){P=I.split(P.parentNode,P.previousSibling);P=P.nextSibling;O=P}if(N){t=N.cloneNode(true);P.parentNode.insertBefore(t,P);while(t.firstChild){I.remove(t.firstChild)}t=I.rename(t,\"li\")}else{t=I.create(\"li\");P.parentNode.insertBefore(t,P)}while(O&&O!=L){M=O.nextSibling;t.appendChild(O);O=M}if(t.childNodes.length===0){t.innerHTML='<br _mce_bogus=\"1\" />'}F(t)}function K(Q,T){var N,R,O=3,L=1,t=\"br,ul,ol,p,div,h1,h2,h3,h4,h5,h6,table,blockquote,address,pre,form,center,dl\";function P(X,U){var V=I.createRng(),W;g.keep=true;z.selection.moveToBookmark(g);g.keep=false;W=z.selection.getRng(true);if(!U){U=X.parentNode.lastChild}V.setStartBefore(X);V.setEndAfter(U);return !(V.compareBoundaryPoints(O,W)>0||V.compareBoundaryPoints(L,W)<=0)}function S(U){if(U.nextSibling){return U.nextSibling}if(!I.isBlock(U.parentNode)&&U.parentNode!==I.getRoot()){return S(U.parentNode)}}N=Q.firstChild;var M=false;e(I.select(t,Q),function(U){if(U.hasAttribute&&U.hasAttribute(\"_mce_bogus\")){return true}if(P(N,U)){I.addClass(U,\"_mce_tagged_br\");N=S(U)}});M=(N&&P(N,undefined));N=Q.firstChild;e(I.select(t,Q),function(V){var U=S(V);if(V.hasAttribute&&V.hasAttribute(\"_mce_bogus\")){return true}if(I.hasClass(V,\"_mce_tagged_br\")){T(N,V,R);R=null}else{R=V}N=U});if(M){T(N,undefined,R)}}function D(t){K(t,function(M,L,N){J(M,L);E(L);E(N)})}function A(t){if(tinymce.inArray(s,t)!==-1){return}if(t.parentNode.tagName===v){I.split(t.parentNode,t);F(t);o(t.parentNode,false)}s.push(t)}function x(M){var O,N,L,t;if(tinymce.inArray(s,M)!==-1){return}M=c(M,I);while(I.is(M.parentNode,\"ol,ul,li\")){I.split(M.parentNode,M)}s.push(M);M=I.rename(M,\"p\");L=m(M,false,z.settings.force_br_newlines);if(L===M){O=M.firstChild;while(O){if(I.isBlock(O)){O=I.split(O.parentNode,O);t=true;N=O.nextSibling&&O.nextSibling.firstChild}else{N=O.nextSibling;if(t&&O.tagName===\"BR\"){I.remove(O)}t=false}O=N}}}e(G,function(t){t=k(t,I);if(t.tagName===v||(t.tagName===\"LI\"&&t.parentNode.tagName===v)){u=true}else{if(t.tagName===y||(t.tagName===\"LI\"&&t.parentNode.tagName===y)){H=true}else{w=true}}});if(w&&!H||u||G.length===0){B={LI:A,H1:F,H2:F,H3:F,H4:F,H5:F,H6:F,P:F,BODY:F,DIV:G.length>1?F:D,defaultAction:D,elements:this.selectedBlocks()}}else{B={defaultAction:x,elements:this.selectedBlocks()}}this.process(B)},indent:function(){var u=this.ed,w=u.dom,x=[];function s(z){var y=w.create(\"li\",{style:\"list-style-type: none;\"});w.insertAfter(y,z);return y}function t(B){var y=s(B),D=w.getParent(B,\"ol,ul\"),C=D.tagName,E=w.getStyle(D,\"list-style-type\"),A={},z;if(E!==\"\"){A.style=\"list-style-type: \"+E+\";\"}z=w.create(C,A);y.appendChild(z);return z}function v(z){if(!d(u,z,x)){z=c(z,w);var y=t(z);y.appendChild(z);m(y.parentNode,false);m(y,false);x.push(z)}}this.process({LI:v,defaultAction:this.adjustPaddingFunction(true),elements:this.selectedBlocks()})},outdent:function(y,x){var w=this,u=w.ed,z=u.dom,s=[];function A(t){var C,B,D;if(!d(u,t,s)){if(z.getStyle(t,\"margin-left\")!==\"\"||z.getStyle(t,\"padding-left\")!==\"\"){return w.adjustPaddingFunction(false)(t)}D=z.getStyle(t,\"text-align\",true);if(D===\"center\"||D===\"right\"){z.setStyle(t,\"text-align\",\"left\");return}t=c(t,z);C=t.parentNode;B=t.parentNode.parentNode;if(B.tagName===\"P\"){z.split(B,t.parentNode)}else{z.split(C,t);if(B.tagName===\"LI\"){z.split(B,t)}else{if(!z.is(B,\"ol,ul\")){z.rename(t,\"p\")}}}s.push(t)}}var v=x&&tinymce.is(x,\"array\")?x:this.selectedBlocks();this.process({LI:A,defaultAction:this.adjustPaddingFunction(false),elements:v});e(s,m)},process:function(y){var F=this,w=F.ed.selection,z=F.ed.dom,E,u;function B(t){var s=tinymce.grep(t.childNodes,function(H){return !(H.nodeName===\"BR\"||H.nodeName===\"SPAN\"&&z.getAttrib(H,\"data-mce-type\")==\"bookmark\"||H.nodeType==3&&(H.nodeValue==String.fromCharCode(160)||H.nodeValue==\"\"))});return s.length===0}function x(s){z.removeClass(s,\"_mce_act_on\");if(!s||s.nodeType!==1||E.length>1&&B(s)){return}s=k(s,z);var t=y[s.tagName];if(!t){t=y.defaultAction}t(s)}function v(s){F.splitSafeEach(s.childNodes,x)}function C(s,t){return t>=0&&s.hasChildNodes()&&t<s.childNodes.length&&s.childNodes[t].tagName===\"BR\"}function D(){var t=w.getNode();var s=z.getParent(t,\"td\");return s!==null}E=y.elements;u=w.getRng(true);if(!u.collapsed){if(C(u.endContainer,u.endOffset-1)){u.setEnd(u.endContainer,u.endOffset-1);w.setRng(u)}if(C(u.startContainer,u.startOffset)){u.setStart(u.startContainer,u.startOffset+1);w.setRng(u)}}if(tinymce.isIE8){var G=F.ed.selection.getNode();if(G.tagName===\"LI\"&&!(G.parentNode.lastChild===G)){var A=F.ed.getDoc().createTextNode(\"\\uFEFF\");G.appendChild(A)}}g=w.getBookmark();y.OL=y.UL=v;F.splitSafeEach(E,x);w.moveToBookmark(g);g=null;if(!D()){F.ed.execCommand(\"mceRepaint\")}},splitSafeEach:function(t,s){if(tinymce.isGecko&&(/Firefox\\/[12]\\.[0-9]/.test(navigator.userAgent)||/Firefox\\/3\\.[0-4]/.test(navigator.userAgent))){this.classBasedEach(t,s)}else{e(t,s)}},classBasedEach:function(v,u){var w=this.ed.dom,s,t;e(v,function(x){w.addClass(x,\"_mce_act_on\")});s=w.select(\"._mce_act_on\");while(s.length>0){t=s.shift();w.removeClass(t,\"_mce_act_on\");u(t);s=w.select(\"._mce_act_on\")}},adjustPaddingFunction:function(u){var s,v,t=this.ed;s=t.settings.indentation;v=/[a-z%]+/i.exec(s);s=parseInt(s,10);return function(w){var y,x;y=parseInt(t.dom.getStyle(w,\"margin-left\")||0,10)+parseInt(t.dom.getStyle(w,\"padding-left\")||0,10);if(u){x=y+s}else{x=y-s}t.dom.setStyle(w,\"padding-left\",\"\");t.dom.setStyle(w,\"margin-left\",x>0?x+v:\"\")}},selectedBlocks:function(){var s=this.ed;var t=s.selection.getSelectedBlocks();return t.length==0?[s.dom.getRoot()]:t},getInfo:function(){return{longname:\"Lists\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/lists\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"lists\",tinymce.plugins.Lists)}());","Magento_Tinymce3/tiny_mce/plugins/lists/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2011, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\tvar each = tinymce.each, Event = tinymce.dom.Event, bookmark;\n\n\t// Skips text nodes that only contain whitespace since they aren't semantically important.\n\tfunction skipWhitespaceNodes(e, next) {\n\t\twhile (e && (e.nodeType === 8 || (e.nodeType === 3 && /^[ \\t\\n\\r]*$/.test(e.nodeValue)))) {\n\t\t\te = next(e);\n\t\t}\n\t\treturn e;\n\t}\n\n\tfunction skipWhitespaceNodesBackwards(e) {\n\t\treturn skipWhitespaceNodes(e, function(e) {\n\t\t\treturn e.previousSibling;\n\t\t});\n\t}\n\n\tfunction skipWhitespaceNodesForwards(e) {\n\t\treturn skipWhitespaceNodes(e, function(e) {\n\t\t\treturn e.nextSibling;\n\t\t});\n\t}\n\n\tfunction hasParentInList(ed, e, list) {\n\t\treturn ed.dom.getParent(e, function(p) {\n\t\t\treturn tinymce.inArray(list, p) !== -1;\n\t\t});\n\t}\n\n\tfunction isList(e) {\n\t\treturn e && (e.tagName === 'OL' || e.tagName === 'UL');\n\t}\n\n\tfunction splitNestedLists(element, dom) {\n\t\tvar tmp, nested, wrapItem;\n\t\ttmp = skipWhitespaceNodesBackwards(element.lastChild);\n\t\twhile (isList(tmp)) {\n\t\t\tnested = tmp;\n\t\t\ttmp = skipWhitespaceNodesBackwards(nested.previousSibling);\n\t\t}\n\t\tif (nested) {\n\t\t\twrapItem = dom.create('li', { style: 'list-style-type: none;'});\n\t\t\tdom.split(element, nested);\n\t\t\tdom.insertAfter(wrapItem, nested);\n\t\t\twrapItem.appendChild(nested);\n\t\t\twrapItem.appendChild(nested);\n\t\t\telement = wrapItem.previousSibling;\n\t\t}\n\t\treturn element;\n\t}\n\n\tfunction attemptMergeWithAdjacent(e, allowDifferentListStyles, mergeParagraphs) {\n\t\te = attemptMergeWithPrevious(e, allowDifferentListStyles, mergeParagraphs);\n\t\treturn attemptMergeWithNext(e, allowDifferentListStyles, mergeParagraphs);\n\t}\n\n\tfunction attemptMergeWithPrevious(e, allowDifferentListStyles, mergeParagraphs) {\n\t\tvar prev = skipWhitespaceNodesBackwards(e.previousSibling);\n\t\tif (prev) {\n\t\t\treturn attemptMerge(prev, e, allowDifferentListStyles ? prev : false, mergeParagraphs);\n\t\t} else {\n\t\t\treturn e;\n\t\t}\n\t}\n\n\tfunction attemptMergeWithNext(e, allowDifferentListStyles, mergeParagraphs) {\n\t\tvar next = skipWhitespaceNodesForwards(e.nextSibling);\n\t\tif (next) {\n\t\t\treturn attemptMerge(e, next, allowDifferentListStyles ? next : false, mergeParagraphs);\n\t\t} else {\n\t\t\treturn e;\n\t\t}\n\t}\n\n\tfunction attemptMerge(e1, e2, differentStylesMasterElement, mergeParagraphs) {\n\t\tif (canMerge(e1, e2, !!differentStylesMasterElement, mergeParagraphs)) {\n\t\t\treturn merge(e1, e2, differentStylesMasterElement);\n\t\t} else if (e1 && e1.tagName === 'LI' && isList(e2)) {\n\t\t\t// Fix invalidly nested lists.\n\t\t\te1.appendChild(e2);\n\t\t}\n\t\treturn e2;\n\t}\n\n\tfunction canMerge(e1, e2, allowDifferentListStyles, mergeParagraphs) {\n\t\tif (!e1 || !e2) {\n\t\t\treturn false;\n\t\t} else if (e1.tagName === 'LI' && e2.tagName === 'LI') {\n\t\t\treturn e2.style.listStyleType === 'none' || containsOnlyAList(e2);\n\t\t} else if (isList(e1)) {\n\t\t\treturn (e1.tagName === e2.tagName && (allowDifferentListStyles || e1.style.listStyleType === e2.style.listStyleType)) || isListForIndent(e2);\n\t\t} else return mergeParagraphs && e1.tagName === 'P' && e2.tagName === 'P';\n\t}\n\n\tfunction isListForIndent(e) {\n\t\tvar firstLI = skipWhitespaceNodesForwards(e.firstChild), lastLI = skipWhitespaceNodesBackwards(e.lastChild);\n\t\treturn firstLI && lastLI && isList(e) && firstLI === lastLI && (isList(firstLI) || firstLI.style.listStyleType === 'none' || containsOnlyAList(firstLI));\n\t}\n\n\tfunction containsOnlyAList(e) {\n\t\tvar firstChild = skipWhitespaceNodesForwards(e.firstChild), lastChild = skipWhitespaceNodesBackwards(e.lastChild);\n\t\treturn firstChild && lastChild && firstChild === lastChild && isList(firstChild);\n\t}\n\n\tfunction merge(e1, e2, masterElement) {\n\t\tvar lastOriginal = skipWhitespaceNodesBackwards(e1.lastChild), firstNew = skipWhitespaceNodesForwards(e2.firstChild);\n\t\tif (e1.tagName === 'P') {\n\t\t\te1.appendChild(e1.ownerDocument.createElement('br'));\n\t\t}\n\t\twhile (e2.firstChild) {\n\t\t\te1.appendChild(e2.firstChild);\n\t\t}\n\t\tif (masterElement) {\n\t\t\te1.style.listStyleType = masterElement.style.listStyleType;\n\t\t}\n\t\te2.parentNode.removeChild(e2);\n\t\tattemptMerge(lastOriginal, firstNew, false);\n\t\treturn e1;\n\t}\n\n\tfunction findItemToOperateOn(e, dom) {\n\t\tvar item;\n\t\tif (!dom.is(e, 'li,ol,ul')) {\n\t\t\titem = dom.getParent(e, 'li');\n\t\t\tif (item) {\n\t\t\t\te = item;\n\t\t\t}\n\t\t}\n\t\treturn e;\n\t}\n\n\ttinymce.create('tinymce.plugins.Lists', {\n\t\tinit: function(ed) {\n\t\t\tvar LIST_TABBING = 'TABBING';\n\t\t\tvar LIST_EMPTY_ITEM = 'EMPTY';\n\t\t\tvar LIST_ESCAPE = 'ESCAPE';\n\t\t\tvar LIST_PARAGRAPH = 'PARAGRAPH';\n\t\t\tvar LIST_UNKNOWN = 'UNKNOWN';\n\t\t\tvar state = LIST_UNKNOWN;\n\n\t\t\tfunction isTabInList(e) {\n                // Don't indent on Ctrl+Tab or Alt+Tab\n\t\t\t\treturn e.keyCode === tinymce.VK.TAB && !(e.altKey || e.ctrlKey) &&\n\t\t\t\t\t(ed.queryCommandState('InsertUnorderedList') || ed.queryCommandState('InsertOrderedList'));\n\t\t\t}\n\n            function isCursorAtEndOfContainer() {\n\t\t\t\tvar range = ed.selection.getRng();\n                var startContainer = range.startContainer;\n                if (startContainer.nodeType == 3) {\n                    return (range.endOffset == startContainer.nodeValue.length);\n                } else if (startContainer.nodeType == 1) {\n                    return range.endOffset == startContainer.childNodes.length;\n                }\n                return false;\n            }\n\t\t\t\n            // If we are at the end of a paragraph in a list item, pressing enter should create a new list item instead of a new paragraph.\n            function isEndOfParagraph() {\n\t\t\t\tvar node = ed.selection.getNode();\n\t\t\t\tvar isLastParagraphOfLi = node.tagName === 'P' && node.parentNode.tagName === 'LI' && node.parentNode.lastChild === node;\n\t\t\t\treturn ed.selection.isCollapsed() && isLastParagraphOfLi && isCursorAtEndOfContainer();\n\t\t\t}\n\n\t\t\tfunction isOnLastListItem() {\n\t\t\t\tvar li = getLi();\n\t\t\t\tvar grandParent = li.parentNode.parentNode;\n\t\t\t\tvar isLastItem = li.parentNode.lastChild === li;\n\t\t\t\treturn isLastItem && !isNestedList(grandParent) && isEmptyListItem(li);\n\t\t\t}\n\n\t\t\tfunction isNestedList(grandParent) {\n\t\t\t\tif (isList(grandParent)) {\n\t\t\t\t\treturn grandParent.parentNode && grandParent.parentNode.tagName === 'LI';\n\t\t\t\t} else {\n\t\t\t\t\treturn  grandParent.tagName === 'LI';\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfunction isInEmptyListItem() {\n\t\t\t\treturn ed.selection.isCollapsed() && isEmptyListItem(getLi());\n\t\t\t}\n\n\t\t\tfunction getLi() {\n\t\t\t\tvar n = ed.selection.getStart();\n\t\t\t\t// Get start will return BR if the LI only contains a BR or an empty element as we use these to fix caret position\n\t\t\t\treturn ((n.tagName == 'BR' || n.tagName == '') && n.parentNode.tagName == 'LI') ? n.parentNode : n;\n\t\t\t}\n\n\t\t\tfunction isEmptyListItem(li) {\n\t\t\t\tvar numChildren = li.childNodes.length;\n\t\t\t\tif (li.tagName === 'LI') {\n\t\t\t\t\treturn numChildren == 0 ? true : numChildren == 1 && (li.firstChild.tagName == '' || li.firstChild.tagName == 'BR' || isEmptyIE9Li(li));\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tfunction isEmptyIE9Li(li) {\n\t\t\t\t// only consider this to be last item if there is no list item content or that content is nbsp or space since IE9 creates these\n\t\t\t\tvar lis = tinymce.grep(li.parentNode.childNodes, function(n) {return n.tagName == 'LI'});\n\t\t\t\tvar isLastLi = li == lis[lis.length - 1];\n\t\t\t\tvar child = li.firstChild;\n\t\t\t\treturn tinymce.isIE9 && isLastLi && (child.nodeValue == String.fromCharCode(160) || child.nodeValue == String.fromCharCode(32));\n\t\t\t}\n\n\t\t\tfunction isEnter(e) {\n\t\t\t\treturn e.keyCode === tinymce.VK.ENTER;\n            }\n\n            function isEnterWithoutShift(e) {\n                return isEnter(e) && !e.shiftKey;\n            }\n\n\t\t\tfunction getListKeyState(e) {\n\t\t\t\tif (isTabInList(e)) {\n\t\t\t\t\treturn LIST_TABBING;\n\t\t\t\t} else if (isEnterWithoutShift(e) && isOnLastListItem()) {\n\t\t\t\t\treturn LIST_ESCAPE;\n\t\t\t\t} else if (isEnterWithoutShift(e) && isInEmptyListItem()) {\n\t\t\t\t\treturn LIST_EMPTY_ITEM;\n\t\t\t\t} else if (isEnterWithoutShift(e) && isEndOfParagraph()) {\n                    return LIST_PARAGRAPH;\n                } else {\n\t\t\t\t\treturn LIST_UNKNOWN;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfunction cancelDefaultEvents(ed, e) {\n\t\t\t\t// list escape is done manually using outdent as it does not create paragraphs correctly in td's\n\t\t\t\tif (state == LIST_TABBING || state == LIST_EMPTY_ITEM || tinymce.isGecko && state == LIST_ESCAPE) {\n\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t}\n\t\t\t}\n\t\t\t\n            // Creates a new list item after the current selection's list item parent\n            function createNewLi(ed, e) {\n                if (state == LIST_PARAGRAPH) {\n\t\t\t\t\tvar node = ed.selection.getNode();\n\t\t\t\t\tvar li = ed.dom.create(\"li\");\n\t\t\t\t\tvar parentLi = ed.dom.getParent(node, 'li');\n\t\t\t\t\ted.dom.insertAfter(li, parentLi);\n\n                    // Move caret to new list element.\n                    if (tinyMCE.isIE8) {\n                        li.appendChild(ed.dom.create(\"&nbsp;\")); // IE needs an element within the bullet point\n                        ed.selection.setCursorLocation(li, 1);\n                    } else if (tinyMCE.isGecko) {\n                        // This setTimeout is a hack as FF behaves badly if there is no content after the bullet point\n                        setTimeout(function () {\n\t\t\t\t\t\t\tvar n = ed.getDoc().createTextNode('\\uFEFF');\n                            li.appendChild(n);\n                            ed.selection.setCursorLocation(li, 0);\n                        }, 0);\n                    } else {\n                        ed.selection.setCursorLocation(li, 0);\n                    }\n\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t}\n            }\n\n\t\t\tfunction imageJoiningListItem(ed, e) {\n\t\t\t\tvar prevSibling;\n\n\t\t\t\tif (!tinymce.isGecko)\n\t\t\t\t\treturn;\n\n\t\t\t\tvar n = ed.selection.getStart();\n\t\t\t\tif (e.keyCode != tinymce.VK.BACKSPACE || n.tagName !== 'IMG')\n\t\t\t\t\treturn;\n\n\t\t\t\tfunction lastLI(node) {\n\t\t\t\t\tvar child = node.firstChild;\n\t\t\t\t\tvar li = null;\n\t\t\t\t\tdo {\n\t\t\t\t\t\tif (!child)\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tif (child.tagName === 'LI')\n\t\t\t\t\t\t\tli = child;\n\t\t\t\t\t} while (child = child.nextSibling);\n\n\t\t\t\t\treturn li;\n\t\t\t\t}\n\n\t\t\t\tfunction addChildren(parentNode, destination) {\n\t\t\t\t\twhile (parentNode.childNodes.length > 0)\n\t\t\t\t\t\tdestination.appendChild(parentNode.childNodes[0]);\n\t\t\t\t}\n\n\t\t\t\t// Check if there is a previous sibling\n\t\t\t\tprevSibling = n.parentNode.previousSibling;\n\t\t\t\tif (!prevSibling)\n\t\t\t\t\treturn;\n\n\t\t\t\tvar ul;\n\t\t\t\tif (prevSibling.tagName === 'UL' || prevSibling.tagName === 'OL')\n\t\t\t\t\tul = prevSibling;\n\t\t\t\telse if (prevSibling.previousSibling && (prevSibling.previousSibling.tagName === 'UL' || prevSibling.previousSibling.tagName === 'OL'))\n\t\t\t\t\tul = prevSibling.previousSibling;\n\t\t\t\telse\n\t\t\t\t\treturn;\n\n\t\t\t\tvar li = lastLI(ul);\n\n\t\t\t\t// move the caret to the end of the list item\n\t\t\t\tvar rng = ed.dom.createRng();\n\t\t\t\trng.setStart(li, 1);\n\t\t\t\trng.setEnd(li, 1);\n\t\t\t\ted.selection.setRng(rng);\n\t\t\t\ted.selection.collapse(true);\n\n\t\t\t\t// save a bookmark at the end of the list item\n\t\t\t\tvar bookmark = ed.selection.getBookmark();\n\n\t\t\t\t// copy the image an its text to the list item\n\t\t\t\tvar clone = n.parentNode.cloneNode(true);\n\t\t\t\tif (clone.tagName === 'P' || clone.tagName === 'DIV')\n\t\t\t\t\taddChildren(clone, li);\n\t\t\t\telse\n\t\t\t\t\tli.appendChild(clone);\n\n\t\t\t\t// remove the old copy of the image\n\t\t\t\tn.parentNode.parentNode.removeChild(n.parentNode);\n\n\t\t\t\t// move the caret where we saved the bookmark\n\t\t\t\ted.selection.moveToBookmark(bookmark);\n\t\t\t}\n\n\t\t\t// fix the cursor position to ensure it is correct in IE\n\t\t\tfunction setCursorPositionToOriginalLi(li) {\n\t\t\t\tvar list = ed.dom.getParent(li, 'ol,ul');\n\t\t\t\tif (list != null) {\n\t\t\t\t\tvar lastLi = list.lastChild;\n\t\t\t\t\tlastLi.appendChild(ed.getDoc().createElement(''));\n\t\t\t\t\ted.selection.setCursorLocation(lastLi, 0);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tthis.ed = ed;\n\t\t\ted.addCommand('Indent', this.indent, this);\n\t\t\ted.addCommand('Outdent', this.outdent, this);\n\t\t\ted.addCommand('InsertUnorderedList', function() {\n\t\t\t\tthis.applyList('UL', 'OL');\n\t\t\t}, this);\n\t\t\ted.addCommand('InsertOrderedList', function() {\n\t\t\t\tthis.applyList('OL', 'UL');\n\t\t\t}, this);\n\n\t\t\ted.onInit.add(function() {\n\t\t\t\ted.editorCommands.addCommands({\n\t\t\t\t\t'outdent': function() {\n\t\t\t\t\t\tvar sel = ed.selection, dom = ed.dom;\n\n\t\t\t\t\t\tfunction hasStyleIndent(n) {\n\t\t\t\t\t\t\tn = dom.getParent(n, dom.isBlock);\n\t\t\t\t\t\t\treturn n && (parseInt(ed.dom.getStyle(n, 'margin-left') || 0, 10) + parseInt(ed.dom.getStyle(n, 'padding-left') || 0, 10)) > 0;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn hasStyleIndent(sel.getStart()) || hasStyleIndent(sel.getEnd()) || ed.queryCommandState('InsertOrderedList') || ed.queryCommandState('InsertUnorderedList');\n\t\t\t\t\t}\n\t\t\t\t}, 'state');\n\t\t\t});\n\n\t\t\ted.onKeyUp.add(function(ed, e) {\n\t\t\t\tif (state == LIST_TABBING) {\n\t\t\t\t\ted.execCommand(e.shiftKey ? 'Outdent' : 'Indent', true, null);\n                    state = LIST_UNKNOWN;\n                    return Event.cancel(e);\n\t\t\t\t} else if (state == LIST_EMPTY_ITEM) {\n\t\t\t\t\tvar li = getLi();\n\t\t\t\t\tvar shouldOutdent =  ed.settings.list_outdent_on_enter === true || e.shiftKey;\n\t\t\t\t\ted.execCommand(shouldOutdent ? 'Outdent' : 'Indent', true, null);\n\t\t\t\t\tif (tinymce.isIE) {\n\t\t\t\t\t\tsetCursorPositionToOriginalLi(li);\n\t\t\t\t\t}\n\n\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t} else if (state == LIST_ESCAPE) {\n\t\t\t\t\tif (tinymce.isIE8) {\n\t\t\t\t\t\t// append a zero sized nbsp so that caret is positioned correctly in IE8 after escaping and applying formatting.\n\t\t\t\t\t\t// if there is no text then applying formatting for e.g a H1 to the P tag immediately following list after\n\t\t\t\t\t\t// escaping from it will cause the caret to be positioned on the last li instead of staying the in P tag.\n\t\t\t\t\t\tvar n = ed.getDoc().createTextNode('\\uFEFF');\n\t\t\t\t\t\ted.selection.getNode().appendChild(n);\n\t\t\t\t\t} else if (tinymce.isIE9 || tinymce.isGecko) {\n\t\t\t\t\t\t// IE9 does not escape the list so we use outdent to do this and cancel the default behaviour\n\t\t\t\t\t\t// Gecko does not create a paragraph outdenting inside a TD so default behaviour is cancelled and we outdent ourselves\n\t\t\t\t\t\ted.execCommand('Outdent');\n\t\t\t\t\t\treturn Event.cancel(e);\n                    }\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tfunction fixListItem(parent, reference) {\n\t\t\t\t// a zero-sized non-breaking space is placed in the empty list item so that the nested list is\n\t\t\t\t// displayed on the below line instead of next to it\n\t\t\t\tvar n = ed.getDoc().createTextNode('\\uFEFF');\n\t\t\t\tparent.insertBefore(n, reference);\n\t\t\t\ted.selection.setCursorLocation(n, 0);\n\t\t\t\t// repaint to remove rendering artifact. only visible when creating new list\n\t\t\t\ted.execCommand('mceRepaint');\n\t\t\t}\n\n\t\t\tfunction fixIndentedListItemForGecko(ed, e) {\n\t\t\t\tif (isEnter(e)) {\n\t\t\t\t\tvar li = getLi();\n\t\t\t\t\tif (li) {\n\t\t\t\t\t\tvar parent = li.parentNode;\n\t\t\t\t\t\tvar grandParent = parent && parent.parentNode;\n\t\t\t\t\t\tif (grandParent && grandParent.nodeName == 'LI' && grandParent.firstChild == parent && li == parent.firstChild) {\n\t\t\t\t\t\t\tfixListItem(grandParent, parent);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfunction fixIndentedListItemForIE8(ed, e) {\n\t\t\t\tif (isEnter(e)) {\n\t\t\t\t\tvar li = getLi();\n\t\t\t\t\tif (ed.dom.select('ul li', li).length === 1) {\n\t\t\t\t\t\tvar list = li.firstChild;\n\t\t\t\t\t\tfixListItem(li, list);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfunction fixDeletingFirstCharOfList(ed, e) {\n\t\t\t\tfunction listElements(list, li) {\n\t\t\t\t\tvar elements = [];\n\t\t\t\t\tvar walker = new tinymce.dom.TreeWalker(li, list);\n\t\t\t\t\tfor (var node = walker.current(); node; node = walker.next()) {\n\t\t\t\t\t\tif (ed.dom.is(node, 'ol,ul,li')) {\n\t\t\t\t\t\t\telements.push(node);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn elements;\n\t\t\t\t}\n\n\t\t\t\tif (e.keyCode == tinymce.VK.BACKSPACE) {\n\t\t\t\t\tvar li = getLi();\n\t\t\t\t\tif (li) {\n\t\t\t\t\t\tvar list = ed.dom.getParent(li, 'ol,ul');\n\t\t\t\t\t\tif (list && list.firstChild === li) {\n\t\t\t\t\t\t\tvar elements = listElements(list, li);\n\t\t\t\t\t\t\ted.execCommand(\"Outdent\", false, elements);\n\t\t\t\t\t\t\ted.undoManager.add();\n\t\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\ted.onKeyDown.add(function(_, e) { state = getListKeyState(e); });\n\t\t\ted.onKeyDown.add(cancelDefaultEvents);\n\t\t\ted.onKeyDown.add(imageJoiningListItem);\n            ed.onKeyDown.add(createNewLi);\n\n\t\t\tif (tinymce.isGecko) {\n\t\t\t\ted.onKeyUp.add(fixIndentedListItemForGecko);\n\t\t\t}\n\t\t\tif (tinymce.isIE8) {\n\t\t\t\ted.onKeyUp.add(fixIndentedListItemForIE8);\n\t\t\t}\n\t\t\tif (tinymce.isGecko || tinymce.isWebKit) {\n\t\t\t\ted.onKeyDown.add(fixDeletingFirstCharOfList);\n\t\t\t}\n\t\t},\n\n\t\tapplyList: function(targetListType, oppositeListType) {\n\t\t\tvar t = this, ed = t.ed, dom = ed.dom, applied = [], hasSameType = false, hasOppositeType = false, hasNonList = false, actions,\n\t\t\t\t\tselectedBlocks = ed.selection.getSelectedBlocks();\n\n\t\t\tfunction cleanupBr(e) {\n\t\t\t\tif (e && e.tagName === 'BR') {\n\t\t\t\t\tdom.remove(e);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfunction makeList(element) {\n\t\t\t\tvar list = dom.create(targetListType), li;\n\n\t\t\t\tfunction adjustIndentForNewList(element) {\n\t\t\t\t\t// If there's a margin-left, outdent one level to account for the extra list margin.\n\t\t\t\t\tif (element.style.marginLeft || element.style.paddingLeft) {\n\t\t\t\t\t\tt.adjustPaddingFunction(false)(element);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (element.tagName === 'LI') {\n\t\t\t\t\t// No change required.\n\t\t\t\t} else if (element.tagName === 'P' || element.tagName === 'DIV' || element.tagName === 'BODY') {\n\t\t\t\t\tprocessBrs(element, function(startSection, br) {\n\t\t\t\t\t\tdoWrapList(startSection, br, element.tagName === 'BODY' ? null : startSection.parentNode);\n\t\t\t\t\t\tli = startSection.parentNode;\n\t\t\t\t\t\tadjustIndentForNewList(li);\n\t\t\t\t\t\tcleanupBr(br);\n\t\t\t\t\t});\n\t\t\t\t\tif (li) {\n\t\t\t\t\t\tif (li.tagName === 'LI' && (element.tagName === 'P' || selectedBlocks.length > 1)) {\n\t\t\t\t\t\t\tdom.split(li.parentNode.parentNode, li.parentNode);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tattemptMergeWithAdjacent(li.parentNode, true);\n\t\t\t\t\t}\n\t\t\t\t\treturn;\n\t\t\t\t} else {\n\t\t\t\t\t// Put the list around the element.\n\t\t\t\t\tli = dom.create('li');\n\t\t\t\t\tdom.insertAfter(li, element);\n\t\t\t\t\tli.appendChild(element);\n\t\t\t\t\tadjustIndentForNewList(element);\n\t\t\t\t\telement = li;\n\t\t\t\t}\n\t\t\t\tdom.insertAfter(list, element);\n\t\t\t\tlist.appendChild(element);\n\t\t\t\tattemptMergeWithAdjacent(list, true);\n\t\t\t\tapplied.push(element);\n\t\t\t}\n\n\t\t\tfunction doWrapList(start, end, template) {\n\t\t\t\tvar li, n = start, tmp;\n\t\t\t\twhile (!dom.isBlock(start.parentNode) && start.parentNode !== dom.getRoot()) {\n\t\t\t\t\tstart = dom.split(start.parentNode, start.previousSibling);\n\t\t\t\t\tstart = start.nextSibling;\n\t\t\t\t\tn = start;\n\t\t\t\t}\n\t\t\t\tif (template) {\n\t\t\t\t\tli = template.cloneNode(true);\n\t\t\t\t\tstart.parentNode.insertBefore(li, start);\n\t\t\t\t\twhile (li.firstChild) dom.remove(li.firstChild);\n\t\t\t\t\tli = dom.rename(li, 'li');\n\t\t\t\t} else {\n\t\t\t\t\tli = dom.create('li');\n\t\t\t\t\tstart.parentNode.insertBefore(li, start);\n\t\t\t\t}\n                while (n && n != end) {\n\t\t\t\t\ttmp = n.nextSibling;\n\t\t\t\t\tli.appendChild(n);\n\t\t\t\t\tn = tmp;\n\t\t\t\t}\n\t\t\t\tif (li.childNodes.length === 0) {\n\t\t\t\t\tli.innerHTML = '<br _mce_bogus=\"1\" />';\n\t\t\t\t}\n\t\t\t\tmakeList(li);\n\t\t\t}\n\n\t\t\tfunction processBrs(element, callback) {\n\t\t\t\tvar startSection, previousBR, END_TO_START = 3, START_TO_END = 1,\n\t\t\t\t\t\tbreakElements = 'br,ul,ol,p,div,h1,h2,h3,h4,h5,h6,table,blockquote,address,pre,form,center,dl';\n\n\t\t\t\tfunction isAnyPartSelected(start, end) {\n\t\t\t\t\tvar r = dom.createRng(), sel;\n\t\t\t\t\tbookmark.keep = true;\n\t\t\t\t\ted.selection.moveToBookmark(bookmark);\n\t\t\t\t\tbookmark.keep = false;\n\t\t\t\t\tsel = ed.selection.getRng(true);\n\t\t\t\t\tif (!end) {\n\t\t\t\t\t\tend = start.parentNode.lastChild;\n\t\t\t\t\t}\n\t\t\t\t\tr.setStartBefore(start);\n\t\t\t\t\tr.setEndAfter(end);\n\t\t\t\t\treturn !(r.compareBoundaryPoints(END_TO_START, sel) > 0 || r.compareBoundaryPoints(START_TO_END, sel) <= 0);\n\t\t\t\t}\n\n\t\t\t\tfunction nextLeaf(br) {\n\t\t\t\t\tif (br.nextSibling)\n\t\t\t\t\t\treturn br.nextSibling;\n\t\t\t\t\tif (!dom.isBlock(br.parentNode) && br.parentNode !== dom.getRoot())\n\t\t\t\t\t\treturn nextLeaf(br.parentNode);\n\t\t\t\t}\n\n\t\t\t\t// Split on BRs within the range and process those.\n\t\t\t\tstartSection = element.firstChild;\n\t\t\t\t// First mark the BRs that have any part of the previous section selected.\n\t\t\t\tvar trailingContentSelected = false;\n\t\t\t\teach(dom.select(breakElements, element), function(br) {\n\t\t\t\t\tif (br.hasAttribute && br.hasAttribute('_mce_bogus')) {\n\t\t\t\t\t\treturn true; // Skip the bogus Brs that are put in to appease Firefox and Safari.\n\t\t\t\t\t}\n\t\t\t\t\tif (isAnyPartSelected(startSection, br)) {\n\t\t\t\t\t\tdom.addClass(br, '_mce_tagged_br');\n\t\t\t\t\t\tstartSection = nextLeaf(br);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t\ttrailingContentSelected = (startSection && isAnyPartSelected(startSection, undefined));\n\t\t\t\tstartSection = element.firstChild;\n\t\t\t\teach(dom.select(breakElements, element), function(br) {\n\t\t\t\t\t// Got a section from start to br.\n\t\t\t\t\tvar tmp = nextLeaf(br);\n\t\t\t\t\tif (br.hasAttribute && br.hasAttribute('_mce_bogus')) {\n\t\t\t\t\t\treturn true; // Skip the bogus Brs that are put in to appease Firefox and Safari.\n\t\t\t\t\t}\n\t\t\t\t\tif (dom.hasClass(br, '_mce_tagged_br')) {\n\t\t\t\t\t\tcallback(startSection, br, previousBR);\n\t\t\t\t\t\tpreviousBR = null;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tpreviousBR = br;\n\t\t\t\t\t}\n\t\t\t\t\tstartSection = tmp;\n\t\t\t\t});\n\t\t\t\tif (trailingContentSelected) {\n\t\t\t\t\tcallback(startSection, undefined, previousBR);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfunction wrapList(element) {\n\t\t\t\tprocessBrs(element, function(startSection, br, previousBR) {\n\t\t\t\t\t// Need to indent this part\n\t\t\t\t\tdoWrapList(startSection, br);\n\t\t\t\t\tcleanupBr(br);\n\t\t\t\t\tcleanupBr(previousBR);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tfunction changeList(element) {\n\t\t\t\tif (tinymce.inArray(applied, element) !== -1) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tif (element.parentNode.tagName === oppositeListType) {\n\t\t\t\t\tdom.split(element.parentNode, element);\n\t\t\t\t\tmakeList(element);\n\t\t\t\t\tattemptMergeWithNext(element.parentNode, false);\n\t\t\t\t}\n\t\t\t\tapplied.push(element);\n\t\t\t}\n\n\t\t\tfunction convertListItemToParagraph(element) {\n\t\t\t\tvar child, nextChild, mergedElement, splitLast;\n\t\t\t\tif (tinymce.inArray(applied, element) !== -1) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\telement = splitNestedLists(element, dom);\n\t\t\t\twhile (dom.is(element.parentNode, 'ol,ul,li')) {\n\t\t\t\t\tdom.split(element.parentNode, element);\n\t\t\t\t}\n\t\t\t\t// Push the original element we have from the selection, not the renamed one.\n\t\t\t\tapplied.push(element);\n\t\t\t\telement = dom.rename(element, 'p');\n\t\t\t\tmergedElement = attemptMergeWithAdjacent(element, false, ed.settings.force_br_newlines);\n\t\t\t\tif (mergedElement === element) {\n\t\t\t\t\t// Now split out any block elements that can't be contained within a P.\n\t\t\t\t\t// Manually iterate to ensure we handle modifications correctly (doesn't work with tinymce.each)\n\t\t\t\t\tchild = element.firstChild;\n\t\t\t\t\twhile (child) {\n\t\t\t\t\t\tif (dom.isBlock(child)) {\n\t\t\t\t\t\t\tchild = dom.split(child.parentNode, child);\n\t\t\t\t\t\t\tsplitLast = true;\n\t\t\t\t\t\t\tnextChild = child.nextSibling && child.nextSibling.firstChild;\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tnextChild = child.nextSibling;\n\t\t\t\t\t\t\tif (splitLast && child.tagName === 'BR') {\n\t\t\t\t\t\t\t\tdom.remove(child);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tsplitLast = false;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tchild = nextChild;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\teach(selectedBlocks, function(e) {\n\t\t\t\te = findItemToOperateOn(e, dom);\n\t\t\t\tif (e.tagName === oppositeListType || (e.tagName === 'LI' && e.parentNode.tagName === oppositeListType)) {\n\t\t\t\t\thasOppositeType = true;\n\t\t\t\t} else if (e.tagName === targetListType || (e.tagName === 'LI' && e.parentNode.tagName === targetListType)) {\n\t\t\t\t\thasSameType = true;\n\t\t\t\t} else {\n\t\t\t\t\thasNonList = true;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tif (hasNonList &&!hasSameType || hasOppositeType || selectedBlocks.length === 0) {\n\t\t\t\tactions = {\n\t\t\t\t\t'LI': changeList,\n\t\t\t\t\t'H1': makeList,\n\t\t\t\t\t'H2': makeList,\n\t\t\t\t\t'H3': makeList,\n\t\t\t\t\t'H4': makeList,\n\t\t\t\t\t'H5': makeList,\n\t\t\t\t\t'H6': makeList,\n\t\t\t\t\t'P': makeList,\n\t\t\t\t\t'BODY': makeList,\n\t\t\t\t\t'DIV': selectedBlocks.length > 1 ? makeList : wrapList,\n\t\t\t\t\tdefaultAction: wrapList,\n\t\t\t\t\telements: this.selectedBlocks()\n\t\t\t\t};\n\t\t\t} else {\n\t\t\t\tactions = {\n\t\t\t\t\tdefaultAction: convertListItemToParagraph,\n\t\t\t\t\telements: this.selectedBlocks()\n\t\t\t\t};\n\t\t\t}\n\t\t\tthis.process(actions);\n\t\t},\n\n\t\tindent: function() {\n\t\t\tvar ed = this.ed, dom = ed.dom, indented = [];\n\n\t\t\tfunction createWrapItem(element) {\n\t\t\t\tvar wrapItem = dom.create('li', { style: 'list-style-type: none;'});\n\t\t\t\tdom.insertAfter(wrapItem, element);\n\t\t\t\treturn wrapItem;\n\t\t\t}\n\n\t\t\tfunction createWrapList(element) {\n\t\t\t\tvar wrapItem = createWrapItem(element),\n\t\t\t\t\t\tlist = dom.getParent(element, 'ol,ul'),\n\t\t\t\t\t\tlistType = list.tagName,\n\t\t\t\t\t\tlistStyle = dom.getStyle(list, 'list-style-type'),\n\t\t\t\t\t\tattrs = {},\n\t\t\t\t\t\twrapList;\n\t\t\t\tif (listStyle !== '') {\n\t\t\t\t\tattrs.style = 'list-style-type: ' + listStyle + ';';\n\t\t\t\t}\n\t\t\t\twrapList = dom.create(listType, attrs);\n\t\t\t\twrapItem.appendChild(wrapList);\n\t\t\t\treturn wrapList;\n\t\t\t}\n\n\t\t\tfunction indentLI(element) {\n\t\t\t\tif (!hasParentInList(ed, element, indented)) {\n\t\t\t\t\telement = splitNestedLists(element, dom);\n\t\t\t\t\tvar wrapList = createWrapList(element);\n\t\t\t\t\twrapList.appendChild(element);\n\t\t\t\t\tattemptMergeWithAdjacent(wrapList.parentNode, false);\n\t\t\t\t\tattemptMergeWithAdjacent(wrapList, false);\n\t\t\t\t\tindented.push(element);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tthis.process({\n\t\t\t\t'LI': indentLI,\n\t\t\t\tdefaultAction: this.adjustPaddingFunction(true),\n\t\t\t\telements: this.selectedBlocks()\n\t\t\t});\n\n\t\t},\n\n\t\toutdent: function(ui, elements) {\n\t\t\tvar t = this, ed = t.ed, dom = ed.dom, outdented = [];\n\n\t\t\tfunction outdentLI(element) {\n\t\t\t\tvar listElement, targetParent, align;\n\t\t\t\tif (!hasParentInList(ed, element, outdented)) {\n\t\t\t\t\tif (dom.getStyle(element, 'margin-left') !== '' || dom.getStyle(element, 'padding-left') !== '') {\n\t\t\t\t\t\treturn t.adjustPaddingFunction(false)(element);\n\t\t\t\t\t}\n\t\t\t\t\talign = dom.getStyle(element, 'text-align', true);\n\t\t\t\t\tif (align === 'center' || align === 'right') {\n\t\t\t\t\t\tdom.setStyle(element, 'text-align', 'left');\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\telement = splitNestedLists(element, dom);\n\t\t\t\t\tlistElement = element.parentNode;\n\t\t\t\t\ttargetParent = element.parentNode.parentNode;\n\t\t\t\t\tif (targetParent.tagName === 'P') {\n\t\t\t\t\t\tdom.split(targetParent, element.parentNode);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tdom.split(listElement, element);\n\t\t\t\t\t\tif (targetParent.tagName === 'LI') {\n\t\t\t\t\t\t\t// Nested list, need to split the LI and go back out to the OL/UL element.\n\t\t\t\t\t\t\tdom.split(targetParent, element);\n\t\t\t\t\t\t} else if (!dom.is(targetParent, 'ol,ul')) {\n\t\t\t\t\t\t\tdom.rename(element, 'p');\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\toutdented.push(element);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tvar listElements = elements && tinymce.is(elements, 'array') ? elements : this.selectedBlocks();\n\t\t\tthis.process({\n\t\t\t\t'LI': outdentLI,\n\t\t\t\tdefaultAction: this.adjustPaddingFunction(false),\n\t\t\t\telements: listElements\n\t\t\t});\n\n\t\t\teach(outdented, attemptMergeWithAdjacent);\n\t\t},\n\n\t\tprocess: function(actions) {\n\t\t\tvar t = this, sel = t.ed.selection, dom = t.ed.dom, selectedBlocks, r;\n\n\t\t\tfunction isEmptyElement(element) {\n\t\t\t\tvar excludeBrsAndBookmarks = tinymce.grep(element.childNodes, function(n) {\n\t\t\t\t\treturn !(n.nodeName === 'BR' || n.nodeName === 'SPAN' && dom.getAttrib(n, 'data-mce-type') == 'bookmark'\n\t\t\t\t\t\t\t|| n.nodeType == 3 && (n.nodeValue == String.fromCharCode(160) || n.nodeValue == ''));\n\t\t\t\t});\n\t\t\t\treturn excludeBrsAndBookmarks.length === 0;\n\t\t\t}\n\n\t\t\tfunction processElement(element) {\n\t\t\t\tdom.removeClass(element, '_mce_act_on');\n\t\t\t\tif (!element || element.nodeType !== 1 || selectedBlocks.length > 1 && isEmptyElement(element)) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\telement = findItemToOperateOn(element, dom);\n\t\t\t\tvar action = actions[element.tagName];\n\t\t\t\tif (!action) {\n\t\t\t\t\taction = actions.defaultAction;\n\t\t\t\t}\n\t\t\t\taction(element);\n\t\t\t}\n\n\t\t\tfunction recurse(element) {\n\t\t\t\tt.splitSafeEach(element.childNodes, processElement);\n\t\t\t}\n\n\t\t\tfunction brAtEdgeOfSelection(container, offset) {\n\t\t\t\treturn offset >= 0 && container.hasChildNodes() && offset < container.childNodes.length &&\n\t\t\t\t\t\tcontainer.childNodes[offset].tagName === 'BR';\n\t\t\t}\n\n\t\t\tfunction isInTable() {\n\t\t\t\tvar n = sel.getNode();\n\t\t\t\tvar p = dom.getParent(n, 'td');\n\t\t\t\treturn p !== null;\n\t\t\t}\n\n\t\t\tselectedBlocks = actions.elements;\n\n\t\t\tr = sel.getRng(true);\n\t\t\tif (!r.collapsed) {\n\t\t\t\tif (brAtEdgeOfSelection(r.endContainer, r.endOffset - 1)) {\n\t\t\t\t\tr.setEnd(r.endContainer, r.endOffset - 1);\n\t\t\t\t\tsel.setRng(r);\n\t\t\t\t}\n\t\t\t\tif (brAtEdgeOfSelection(r.startContainer, r.startOffset)) {\n\t\t\t\t\tr.setStart(r.startContainer, r.startOffset + 1);\n\t\t\t\t\tsel.setRng(r);\n\t\t\t\t}\n\t\t\t}\n\n\n\t\t\tif (tinymce.isIE8) {\n\t\t\t\t// append a zero sized nbsp so that caret is restored correctly using bookmark\n\t\t\t\tvar s = t.ed.selection.getNode();\n\t\t\t\tif (s.tagName === 'LI' && !(s.parentNode.lastChild === s)) {\n\t\t\t\t\tvar i = t.ed.getDoc().createTextNode('\\uFEFF');\n\t\t\t\t\ts.appendChild(i);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tbookmark = sel.getBookmark();\n\t\t\tactions.OL = actions.UL = recurse;\n\t\t\tt.splitSafeEach(selectedBlocks, processElement);\n\t\t\tsel.moveToBookmark(bookmark);\n\t\t\tbookmark = null;\n\n\t\t\t// we avoid doing repaint in a table as this will move the caret out of the table in Firefox 3.6\n\t\t\tif (!isInTable()) {\n\t\t\t\t// Avoids table or image handles being left behind in Firefox.\n\t\t\t\tt.ed.execCommand('mceRepaint');\n\t\t\t}\n\t\t},\n\n\t\tsplitSafeEach: function(elements, f) {\n\t\t\tif (tinymce.isGecko && (/Firefox\\/[12]\\.[0-9]/.test(navigator.userAgent) ||\n\t\t\t\t\t/Firefox\\/3\\.[0-4]/.test(navigator.userAgent))) {\n\t\t\t\tthis.classBasedEach(elements, f);\n\t\t\t} else {\n\t\t\t\teach(elements, f);\n\t\t\t}\n\t\t},\n\n\t\tclassBasedEach: function(elements, f) {\n\t\t\tvar dom = this.ed.dom, nodes, element;\n\t\t\t// Mark nodes\n\t\t\teach(elements, function(element) {\n\t\t\t\tdom.addClass(element, '_mce_act_on');\n\t\t\t});\n\t\t\tnodes = dom.select('._mce_act_on');\n\t\t\twhile (nodes.length > 0) {\n\t\t\t\telement = nodes.shift();\n\t\t\t\tdom.removeClass(element, '_mce_act_on');\n\t\t\t\tf(element);\n\t\t\t\tnodes = dom.select('._mce_act_on');\n\t\t\t}\n\t\t},\n\n\t\tadjustPaddingFunction: function(isIndent) {\n\t\t\tvar indentAmount, indentUnits, ed = this.ed;\n\t\t\tindentAmount = ed.settings.indentation;\n\t\t\tindentUnits = /[a-z%]+/i.exec(indentAmount);\n\t\t\tindentAmount = parseInt(indentAmount, 10);\n\t\t\treturn function(element) {\n\t\t\t\tvar currentIndent, newIndentAmount;\n\t\t\t\tcurrentIndent = parseInt(ed.dom.getStyle(element, 'margin-left') || 0, 10) + parseInt(ed.dom.getStyle(element, 'padding-left') || 0, 10);\n\t\t\t\tif (isIndent) {\n\t\t\t\t\tnewIndentAmount = currentIndent + indentAmount;\n\t\t\t\t} else {\n\t\t\t\t\tnewIndentAmount = currentIndent - indentAmount;\n\t\t\t\t}\n\t\t\t\ted.dom.setStyle(element, 'padding-left', '');\n\t\t\t\ted.dom.setStyle(element, 'margin-left', newIndentAmount > 0 ? newIndentAmount + indentUnits : '');\n\t\t\t};\n\t\t},\n\n\t\tselectedBlocks: function() {\n\t\t\tvar ed = this.ed\n\t\t\tvar selectedBlocks = ed.selection.getSelectedBlocks();\n\t\t\treturn selectedBlocks.length == 0 ? [ ed.dom.getRoot() ] : selectedBlocks;\n\t\t},\n\n\t\tgetInfo: function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Lists',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/lists',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\ttinymce.PluginManager.add(\"lists\", tinymce.plugins.Lists);\n}());\n","Magento_Tinymce3/tiny_mce/plugins/pagebreak/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.PageBreakPlugin\",{init:function(b,d){var f='<img src=\"'+b.theme.url+'/img/trans.gif\" class=\"mcePageBreak mceItemNoResize\" />',a=\"mcePageBreak\",c=b.getParam(\"pagebreak_separator\",\"<!-- pagebreak -->\"),e;e=new RegExp(c.replace(/[\\?\\.\\*\\[\\]\\(\\)\\{\\}\\+\\^\\$\\:]/g,function(g){return\"\\\\\"+g}),\"g\");b.addCommand(\"mcePageBreak\",function(){b.execCommand(\"mceInsertContent\",0,f)});b.addButton(\"pagebreak\",{title:\"pagebreak.desc\",cmd:a});b.onInit.add(function(){if(b.theme.onResolveName){b.theme.onResolveName.add(function(g,h){if(h.node.nodeName==\"IMG\"&&b.dom.hasClass(h.node,a)){h.name=\"pagebreak\"}})}});b.onClick.add(function(g,h){h=h.target;if(h.nodeName===\"IMG\"&&g.dom.hasClass(h,a)){g.selection.select(h)}});b.onNodeChange.add(function(h,g,i){g.setActive(\"pagebreak\",i.nodeName===\"IMG\"&&h.dom.hasClass(i,a))});b.onBeforeSetContent.add(function(g,h){h.content=h.content.replace(e,f)});b.onPostProcess.add(function(g,h){if(h.get){h.content=h.content.replace(/<img[^>]+>/g,function(i){if(i.indexOf('class=\"mcePageBreak')!==-1){i=c}return i})}})},getInfo:function(){return{longname:\"PageBreak\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/pagebreak\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"pagebreak\",tinymce.plugins.PageBreakPlugin)})();","Magento_Tinymce3/tiny_mce/plugins/pagebreak/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.PageBreakPlugin', {\n\t\tinit : function(ed, url) {\n\t\t\tvar pb = '<img src=\"' + ed.theme.url + '/img/trans.gif\" class=\"mcePageBreak mceItemNoResize\" />', cls = 'mcePageBreak', sep = ed.getParam('pagebreak_separator', '<!-- pagebreak -->'), pbRE;\n\n\t\t\tpbRE = new RegExp(sep.replace(/[\\?\\.\\*\\[\\]\\(\\)\\{\\}\\+\\^\\$\\:]/g, function(a) {return '\\\\' + a;}), 'g');\n\n\t\t\t// Register commands\n\t\t\ted.addCommand('mcePageBreak', function() {\n\t\t\t\ted.execCommand('mceInsertContent', 0, pb);\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('pagebreak', {title : 'pagebreak.desc', cmd : cls});\n\n\t\t\ted.onInit.add(function() {\n\t\t\t\tif (ed.theme.onResolveName) {\n\t\t\t\t\ted.theme.onResolveName.add(function(th, o) {\n\t\t\t\t\t\tif (o.node.nodeName == 'IMG' && ed.dom.hasClass(o.node, cls))\n\t\t\t\t\t\t\to.name = 'pagebreak';\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t});\n\n\t\t\ted.onClick.add(function(ed, e) {\n\t\t\t\te = e.target;\n\n\t\t\t\tif (e.nodeName === 'IMG' && ed.dom.hasClass(e, cls))\n\t\t\t\t\ted.selection.select(e);\n\t\t\t});\n\n\t\t\ted.onNodeChange.add(function(ed, cm, n) {\n\t\t\t\tcm.setActive('pagebreak', n.nodeName === 'IMG' && ed.dom.hasClass(n, cls));\n\t\t\t});\n\n\t\t\ted.onBeforeSetContent.add(function(ed, o) {\n\t\t\t\to.content = o.content.replace(pbRE, pb);\n\t\t\t});\n\n\t\t\ted.onPostProcess.add(function(ed, o) {\n\t\t\t\tif (o.get)\n\t\t\t\t\to.content = o.content.replace(/<img[^>]+>/g, function(im) {\n\t\t\t\t\t\tif (im.indexOf('class=\"mcePageBreak') !== -1)\n\t\t\t\t\t\t\tim = sep;\n\n\t\t\t\t\t\treturn im;\n\t\t\t\t\t});\n\t\t\t});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'PageBreak',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/pagebreak',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('pagebreak', tinymce.plugins.PageBreakPlugin);\n})();","Magento_Tinymce3/tiny_mce/plugins/fullpage/editor_plugin.js":"(function(){var b=tinymce.each,a=tinymce.html.Node;tinymce.create(\"tinymce.plugins.FullPagePlugin\",{init:function(c,d){var e=this;e.editor=c;c.addCommand(\"mceFullPageProperties\",function(){c.windowManager.open({file:d+\"/fullpage.htm\",width:430+parseInt(c.getLang(\"fullpage.delta_width\",0)),height:495+parseInt(c.getLang(\"fullpage.delta_height\",0)),inline:1},{plugin_url:d,data:e._htmlToData()})});c.addButton(\"fullpage\",{title:\"fullpage.desc\",cmd:\"mceFullPageProperties\"});c.onBeforeSetContent.add(e._setContent,e);c.onGetContent.add(e._getContent,e)},getInfo:function(){return{longname:\"Fullpage\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/fullpage\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}},_htmlToData:function(){var f=this._parseHeader(),h={},c,i,g,e=this.editor;function d(l,j){var k=l.attr(j);return k||\"\"}h.fontface=e.getParam(\"fullpage_default_fontface\",\"\");h.fontsize=e.getParam(\"fullpage_default_fontsize\",\"\");i=f.firstChild;if(i.type==7){h.xml_pi=true;g=/encoding=\"([^\"]+)\"/.exec(i.value);if(g){h.docencoding=g[1]}}i=f.getAll(\"#doctype\")[0];if(i){h.doctype=\"<!DOCTYPE\"+i.value+\">\"}i=f.getAll(\"title\")[0];if(i&&i.firstChild){h.metatitle=i.firstChild.value}b(f.getAll(\"meta\"),function(m){var k=m.attr(\"name\"),j=m.attr(\"http-equiv\"),l;if(k){h[\"meta\"+k.toLowerCase()]=m.attr(\"content\")}else{if(j==\"Content-Type\"){l=/charset\\s*=\\s*(.*)\\s*/gi.exec(m.attr(\"content\"));if(l){h.docencoding=l[1]}}}});i=f.getAll(\"html\")[0];if(i){h.langcode=d(i,\"lang\")||d(i,\"xml:lang\")}i=f.getAll(\"link\")[0];if(i&&i.attr(\"rel\")==\"stylesheet\"){h.stylesheet=i.attr(\"href\")}i=f.getAll(\"body\")[0];if(i){h.langdir=d(i,\"dir\");h.style=d(i,\"style\");h.visited_color=d(i,\"vlink\");h.link_color=d(i,\"link\");h.active_color=d(i,\"alink\")}return h},_dataToHtml:function(g){var f,d,h,j,k,e=this.editor.dom;function c(n,l,m){n.attr(l,m?m:undefined)}function i(l){if(d.firstChild){d.insert(l,d.firstChild)}else{d.append(l)}}f=this._parseHeader();d=f.getAll(\"head\")[0];if(!d){j=f.getAll(\"html\")[0];d=new a(\"head\",1);if(j.firstChild){j.insert(d,j.firstChild,true)}else{j.append(d)}}j=f.firstChild;if(g.xml_pi){k='version=\"1.0\"';if(g.docencoding){k+=' encoding=\"'+g.docencoding+'\"'}if(j.type!=7){j=new a(\"xml\",7);f.insert(j,f.firstChild,true)}j.value=k}else{if(j&&j.type==7){j.remove()}}j=f.getAll(\"#doctype\")[0];if(g.doctype){if(!j){j=new a(\"#doctype\",10);if(g.xml_pi){f.insert(j,f.firstChild)}else{i(j)}}j.value=g.doctype.substring(9,g.doctype.length-1)}else{if(j){j.remove()}}j=f.getAll(\"title\")[0];if(g.metatitle){if(!j){j=new a(\"title\",1);j.append(new a(\"#text\",3)).value=g.metatitle;i(j)}}if(g.docencoding){j=null;b(f.getAll(\"meta\"),function(l){if(l.attr(\"http-equiv\")==\"Content-Type\"){j=l}});if(!j){j=new a(\"meta\",1);j.attr(\"http-equiv\",\"Content-Type\");j.shortEnded=true;i(j)}j.attr(\"content\",\"text/html; charset=\"+g.docencoding)}b(\"keywords,description,author,copyright,robots\".split(\",\"),function(m){var l=f.getAll(\"meta\"),n,p,o=g[\"meta\"+m];for(n=0;n<l.length;n++){p=l[n];if(p.attr(\"name\")==m){if(o){p.attr(\"content\",o)}else{p.remove()}return}}if(o){j=new a(\"meta\",1);j.attr(\"name\",m);j.attr(\"content\",o);j.shortEnded=true;i(j)}});j=f.getAll(\"link\")[0];if(j&&j.attr(\"rel\")==\"stylesheet\"){if(g.stylesheet){j.attr(\"href\",g.stylesheet)}else{j.remove()}}else{if(g.stylesheet){j=new a(\"link\",1);j.attr({rel:\"stylesheet\",text:\"text/css\",href:g.stylesheet});j.shortEnded=true;i(j)}}j=f.getAll(\"body\")[0];if(j){c(j,\"dir\",g.langdir);c(j,\"style\",g.style);c(j,\"vlink\",g.visited_color);c(j,\"link\",g.link_color);c(j,\"alink\",g.active_color);e.setAttribs(this.editor.getBody(),{style:g.style,dir:g.dir,vLink:g.visited_color,link:g.link_color,aLink:g.active_color})}j=f.getAll(\"html\")[0];if(j){c(j,\"lang\",g.langcode);c(j,\"xml:lang\",g.langcode)}h=new tinymce.html.Serializer({validate:false,indent:true,apply_source_formatting:true,indent_before:\"head,html,body,meta,title,script,link,style\",indent_after:\"head,html,body,meta,title,script,link,style\"}).serialize(f);this.head=h.substring(0,h.indexOf(\"</body>\"))},_parseHeader:function(){return new tinymce.html.DomParser({validate:false,root_name:\"#document\"}).parse(this.head)},_setContent:function(g,d){var m=this,i,c,h=d.content,f,l=\"\",e=m.editor.dom,j;function k(n){return n.replace(/<\\/?[A-Z]+/g,function(o){return o.toLowerCase()})}if(d.format==\"raw\"&&m.head){return}if(d.source_view&&g.getParam(\"fullpage_hide_in_source_view\")){return}h=h.replace(/<(\\/?)BODY/gi,\"<$1body\");i=h.indexOf(\"<body\");if(i!=-1){i=h.indexOf(\">\",i);m.head=k(h.substring(0,i+1));c=h.indexOf(\"</body\",i);if(c==-1){c=h.length}d.content=h.substring(i+1,c);m.foot=k(h.substring(c))}else{m.head=this._getDefaultHeader();m.foot=\"\\n</body>\\n</html>\"}f=m._parseHeader();b(f.getAll(\"style\"),function(n){if(n.firstChild){l+=n.firstChild.value}});j=f.getAll(\"body\")[0];if(j){e.setAttribs(m.editor.getBody(),{style:j.attr(\"style\")||\"\",dir:j.attr(\"dir\")||\"\",vLink:j.attr(\"vlink\")||\"\",link:j.attr(\"link\")||\"\",aLink:j.attr(\"alink\")||\"\"})}e.remove(\"fullpage_styles\");if(l){e.add(m.editor.getDoc().getElementsByTagName(\"head\")[0],\"style\",{id:\"fullpage_styles\"},l);j=e.get(\"fullpage_styles\");if(j.styleSheet){j.styleSheet.cssText=l}}},_getDefaultHeader:function(){var f=\"\",c=this.editor,e,d=\"\";if(c.getParam(\"fullpage_default_xml_pi\")){f+='<?xml version=\"1.0\" encoding=\"'+c.getParam(\"fullpage_default_encoding\",\"ISO-8859-1\")+'\" ?>\\n'}f+=c.getParam(\"fullpage_default_doctype\",'<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">');f+=\"\\n<html>\\n<head>\\n\";if(e=c.getParam(\"fullpage_default_title\")){f+=\"<title>\"+e+\"</title>\\n\"}if(e=c.getParam(\"fullpage_default_encoding\")){f+='<meta http-equiv=\"Content-Type\" content=\"text/html; charset='+e+'\" />\\n'}if(e=c.getParam(\"fullpage_default_font_family\")){d+=\"font-family: \"+e+\";\"}if(e=c.getParam(\"fullpage_default_font_size\")){d+=\"font-size: \"+e+\";\"}if(e=c.getParam(\"fullpage_default_text_color\")){d+=\"color: \"+e+\";\"}f+=\"</head>\\n<body\"+(d?' style=\"'+d+'\"':\"\")+\">\\n\";return f},_getContent:function(d,e){var c=this;if(!e.source_view||!d.getParam(\"fullpage_hide_in_source_view\")){e.content=tinymce.trim(c.head)+\"\\n\"+tinymce.trim(e.content)+\"\\n\"+tinymce.trim(c.foot)}}});tinymce.PluginManager.add(\"fullpage\",tinymce.plugins.FullPagePlugin)})();","Magento_Tinymce3/tiny_mce/plugins/fullpage/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\tvar each = tinymce.each, Node = tinymce.html.Node;\n\n\ttinymce.create('tinymce.plugins.FullPagePlugin', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this;\n\n\t\t\tt.editor = ed;\n\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceFullPageProperties', function() {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/fullpage.htm',\n\t\t\t\t\twidth : 430 + parseInt(ed.getLang('fullpage.delta_width', 0)),\n\t\t\t\t\theight : 495 + parseInt(ed.getLang('fullpage.delta_height', 0)),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url,\n\t\t\t\t\tdata : t._htmlToData()\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('fullpage', {title : 'fullpage.desc', cmd : 'mceFullPageProperties'});\n\n\t\t\ted.onBeforeSetContent.add(t._setContent, t);\n\t\t\ted.onGetContent.add(t._getContent, t);\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Fullpage',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/fullpage',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t},\n\n\t\t// Private plugin internal methods\n\n\t\t_htmlToData : function() {\n\t\t\tvar headerFragment = this._parseHeader(), data = {}, nodes, elm, matches, editor = this.editor;\n\n\t\t\tfunction getAttr(elm, name) {\n\t\t\t\tvar value = elm.attr(name);\n\n\t\t\t\treturn value || '';\n\t\t\t};\n\n\t\t\t// Default some values\n\t\t\tdata.fontface = editor.getParam(\"fullpage_default_fontface\", \"\");\n\t\t\tdata.fontsize = editor.getParam(\"fullpage_default_fontsize\", \"\");\n\n\t\t\t// Parse XML PI\n\t\t\telm = headerFragment.firstChild;\n\t\t\tif (elm.type == 7) {\n\t\t\t\tdata.xml_pi = true;\n\t\t\t\tmatches = /encoding=\"([^\"]+)\"/.exec(elm.value);\n\t\t\t\tif (matches)\n\t\t\t\t\tdata.docencoding = matches[1];\n\t\t\t}\n\n\t\t\t// Parse doctype\n\t\t\telm = headerFragment.getAll('#doctype')[0];\n\t\t\tif (elm)\n\t\t\t\tdata.doctype = '<!DOCTYPE' + elm.value + \">\"; \n\n\t\t\t// Parse title element\n\t\t\telm = headerFragment.getAll('title')[0];\n\t\t\tif (elm && elm.firstChild) {\n\t\t\t\tdata.metatitle = elm.firstChild.value;\n\t\t\t}\n\n\t\t\t// Parse meta elements\n\t\t\teach(headerFragment.getAll('meta'), function(meta) {\n\t\t\t\tvar name = meta.attr('name'), httpEquiv = meta.attr('http-equiv'), matches;\n\n\t\t\t\tif (name)\n\t\t\t\t\tdata['meta' + name.toLowerCase()] = meta.attr('content');\n\t\t\t\telse if (httpEquiv == \"Content-Type\") {\n\t\t\t\t\tmatches = /charset\\s*=\\s*(.*)\\s*/gi.exec(meta.attr('content'));\n\n\t\t\t\t\tif (matches)\n\t\t\t\t\t\tdata.docencoding = matches[1];\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Parse html attribs\n\t\t\telm = headerFragment.getAll('html')[0];\n\t\t\tif (elm)\n\t\t\t\tdata.langcode = getAttr(elm, 'lang') || getAttr(elm, 'xml:lang');\n\t\n\t\t\t// Parse stylesheet\n\t\t\telm = headerFragment.getAll('link')[0];\n\t\t\tif (elm && elm.attr('rel') == 'stylesheet')\n\t\t\t\tdata.stylesheet = elm.attr('href');\n\n\t\t\t// Parse body parts\n\t\t\telm = headerFragment.getAll('body')[0];\n\t\t\tif (elm) {\n\t\t\t\tdata.langdir = getAttr(elm, 'dir');\n\t\t\t\tdata.style = getAttr(elm, 'style');\n\t\t\t\tdata.visited_color = getAttr(elm, 'vlink');\n\t\t\t\tdata.link_color = getAttr(elm, 'link');\n\t\t\t\tdata.active_color = getAttr(elm, 'alink');\n\t\t\t}\n\n\t\t\treturn data;\n\t\t},\n\n\t\t_dataToHtml : function(data) {\n\t\t\tvar headerFragment, headElement, html, elm, value, dom = this.editor.dom;\n\n\t\t\tfunction setAttr(elm, name, value) {\n\t\t\t\telm.attr(name, value ? value : undefined);\n\t\t\t};\n\n\t\t\tfunction addHeadNode(node) {\n\t\t\t\tif (headElement.firstChild)\n\t\t\t\t\theadElement.insert(node, headElement.firstChild);\n\t\t\t\telse\n\t\t\t\t\theadElement.append(node);\n\t\t\t};\n\n\t\t\theaderFragment = this._parseHeader();\n\t\t\theadElement = headerFragment.getAll('head')[0];\n\t\t\tif (!headElement) {\n\t\t\t\telm = headerFragment.getAll('html')[0];\n\t\t\t\theadElement = new Node('head', 1);\n\n\t\t\t\tif (elm.firstChild)\n\t\t\t\t\telm.insert(headElement, elm.firstChild, true);\n\t\t\t\telse\n\t\t\t\t\telm.append(headElement);\n\t\t\t}\n\n\t\t\t// Add/update/remove XML-PI\n\t\t\telm = headerFragment.firstChild;\n\t\t\tif (data.xml_pi) {\n\t\t\t\tvalue = 'version=\"1.0\"';\n\n\t\t\t\tif (data.docencoding)\n\t\t\t\t\tvalue += ' encoding=\"' + data.docencoding + '\"';\n\n\t\t\t\tif (elm.type != 7) {\n\t\t\t\t\telm = new Node('xml', 7);\n\t\t\t\t\theaderFragment.insert(elm, headerFragment.firstChild, true);\n\t\t\t\t}\n\n\t\t\t\telm.value = value;\n\t\t\t} else if (elm && elm.type == 7)\n\t\t\t\telm.remove();\n\n\t\t\t// Add/update/remove doctype\n\t\t\telm = headerFragment.getAll('#doctype')[0];\n\t\t\tif (data.doctype) {\n\t\t\t\tif (!elm) {\n\t\t\t\t\telm = new Node('#doctype', 10);\n\n\t\t\t\t\tif (data.xml_pi)\n\t\t\t\t\t\theaderFragment.insert(elm, headerFragment.firstChild);\n\t\t\t\t\telse\n\t\t\t\t\t\taddHeadNode(elm);\n\t\t\t\t}\n\n\t\t\t\telm.value = data.doctype.substring(9, data.doctype.length - 1);\n\t\t\t} else if (elm)\n\t\t\t\telm.remove();\n\n\t\t\t// Add/update/remove title\n\t\t\telm = headerFragment.getAll('title')[0];\n\t\t\tif (data.metatitle) {\n\t\t\t\tif (!elm) {\n\t\t\t\t\telm = new Node('title', 1);\n\t\t\t\t\telm.append(new Node('#text', 3)).value = data.metatitle;\n\t\t\t\t\taddHeadNode(elm);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Add meta encoding\n\t\t\tif (data.docencoding) {\n\t\t\t\telm = null;\n\t\t\t\teach(headerFragment.getAll('meta'), function(meta) {\n\t\t\t\t\tif (meta.attr('http-equiv') == 'Content-Type')\n\t\t\t\t\t\telm = meta;\n\t\t\t\t});\n\n\t\t\t\tif (!elm) {\n\t\t\t\t\telm = new Node('meta', 1);\n\t\t\t\t\telm.attr('http-equiv', 'Content-Type');\n\t\t\t\t\telm.shortEnded = true;\n\t\t\t\t\taddHeadNode(elm);\n\t\t\t\t}\n\n\t\t\t\telm.attr('content', 'text/html; charset=' + data.docencoding);\n\t\t\t}\n\n\t\t\t// Add/update/remove meta\n\t\t\teach('keywords,description,author,copyright,robots'.split(','), function(name) {\n\t\t\t\tvar nodes = headerFragment.getAll('meta'), i, meta, value = data['meta' + name];\n\n\t\t\t\tfor (i = 0; i < nodes.length; i++) {\n\t\t\t\t\tmeta = nodes[i];\n\n\t\t\t\t\tif (meta.attr('name') == name) {\n\t\t\t\t\t\tif (value)\n\t\t\t\t\t\t\tmeta.attr('content', value);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tmeta.remove();\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (value) {\n\t\t\t\t\telm = new Node('meta', 1);\n\t\t\t\t\telm.attr('name', name);\n\t\t\t\t\telm.attr('content', value);\n\t\t\t\t\telm.shortEnded = true;\n\n\t\t\t\t\taddHeadNode(elm);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Add/update/delete link\n\t\t\telm = headerFragment.getAll('link')[0];\n\t\t\tif (elm && elm.attr('rel') == 'stylesheet') {\n\t\t\t\tif (data.stylesheet)\n\t\t\t\t\telm.attr('href', data.stylesheet);\n\t\t\t\telse\n\t\t\t\t\telm.remove();\n\t\t\t} else if (data.stylesheet) {\n\t\t\t\telm = new Node('link', 1);\n\t\t\t\telm.attr({\n\t\t\t\t\trel : 'stylesheet',\n\t\t\t\t\ttext : 'text/css',\n\t\t\t\t\thref : data.stylesheet\n\t\t\t\t});\n\t\t\t\telm.shortEnded = true;\n\n\t\t\t\taddHeadNode(elm);\n\t\t\t}\n\n\t\t\t// Update body attributes\n\t\t\telm = headerFragment.getAll('body')[0];\n\t\t\tif (elm) {\n\t\t\t\tsetAttr(elm, 'dir', data.langdir);\n\t\t\t\tsetAttr(elm, 'style', data.style);\n\t\t\t\tsetAttr(elm, 'vlink', data.visited_color);\n\t\t\t\tsetAttr(elm, 'link', data.link_color);\n\t\t\t\tsetAttr(elm, 'alink', data.active_color);\n\n\t\t\t\t// Update iframe body as well\n\t\t\t\tdom.setAttribs(this.editor.getBody(), {\n\t\t\t\t\tstyle : data.style,\n\t\t\t\t\tdir : data.dir,\n\t\t\t\t\tvLink : data.visited_color,\n\t\t\t\t\tlink : data.link_color,\n\t\t\t\t\taLink : data.active_color\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Set html attributes\n\t\t\telm = headerFragment.getAll('html')[0];\n\t\t\tif (elm) {\n\t\t\t\tsetAttr(elm, 'lang', data.langcode);\n\t\t\t\tsetAttr(elm, 'xml:lang', data.langcode);\n\t\t\t}\n\n\t\t\t// Serialize header fragment and crop away body part\n\t\t\thtml = new tinymce.html.Serializer({\n\t\t\t\tvalidate: false,\n\t\t\t\tindent: true,\n\t\t\t\tapply_source_formatting : true,\n\t\t\t\tindent_before: 'head,html,body,meta,title,script,link,style',\n\t\t\t\tindent_after: 'head,html,body,meta,title,script,link,style'\n\t\t\t}).serialize(headerFragment);\n\n\t\t\tthis.head = html.substring(0, html.indexOf('</body>'));\n\t\t},\n\n\t\t_parseHeader : function() {\n\t\t\t// Parse the contents with a DOM parser\n\t\t\treturn new tinymce.html.DomParser({\n\t\t\t\tvalidate: false,\n\t\t\t\troot_name: '#document'\n\t\t\t}).parse(this.head);\n\t\t},\n\n\t\t_setContent : function(ed, o) {\n\t\t\tvar self = this, startPos, endPos, content = o.content, headerFragment, styles = '', dom = self.editor.dom, elm;\n\n\t\t\tfunction low(s) {\n\t\t\t\treturn s.replace(/<\\/?[A-Z]+/g, function(a) {\n\t\t\t\t\treturn a.toLowerCase();\n\t\t\t\t})\n\t\t\t};\n\n\t\t\t// Ignore raw updated if we already have a head, this will fix issues with undo/redo keeping the head/foot separate\n\t\t\tif (o.format == 'raw' && self.head)\n\t\t\t\treturn;\n\n\t\t\tif (o.source_view && ed.getParam('fullpage_hide_in_source_view'))\n\t\t\t\treturn;\n\n\t\t\t// Parse out head, body and footer\n\t\t\tcontent = content.replace(/<(\\/?)BODY/gi, '<$1body');\n\t\t\tstartPos = content.indexOf('<body');\n\n\t\t\tif (startPos != -1) {\n\t\t\t\tstartPos = content.indexOf('>', startPos);\n\t\t\t\tself.head = low(content.substring(0, startPos + 1));\n\n\t\t\t\tendPos = content.indexOf('</body', startPos);\n\t\t\t\tif (endPos == -1)\n\t\t\t\t\tendPos = content.length;\n\n\t\t\t\to.content = content.substring(startPos + 1, endPos);\n\t\t\t\tself.foot = low(content.substring(endPos));\n\t\t\t} else {\n\t\t\t\tself.head = this._getDefaultHeader();\n\t\t\t\tself.foot = '\\n</body>\\n</html>';\n\t\t\t}\n\n\t\t\t// Parse header and update iframe\n\t\t\theaderFragment = self._parseHeader();\n\t\t\teach(headerFragment.getAll('style'), function(node) {\n\t\t\t\tif (node.firstChild)\n\t\t\t\t\tstyles += node.firstChild.value;\n\t\t\t});\n\n\t\t\telm = headerFragment.getAll('body')[0];\n\t\t\tif (elm) {\n\t\t\t\tdom.setAttribs(self.editor.getBody(), {\n\t\t\t\t\tstyle : elm.attr('style') || '',\n\t\t\t\t\tdir : elm.attr('dir') || '',\n\t\t\t\t\tvLink : elm.attr('vlink') || '',\n\t\t\t\t\tlink : elm.attr('link') || '',\n\t\t\t\t\taLink : elm.attr('alink') || ''\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tdom.remove('fullpage_styles');\n\n\t\t\tif (styles) {\n\t\t\t\tdom.add(self.editor.getDoc().getElementsByTagName('head')[0], 'style', {id : 'fullpage_styles'}, styles);\n\n\t\t\t\t// Needed for IE 6/7\n\t\t\t\telm = dom.get('fullpage_styles');\n\t\t\t\tif (elm.styleSheet)\n\t\t\t\t\telm.styleSheet.cssText = styles;\n\t\t\t}\n\t\t},\n\n\t\t_getDefaultHeader : function() {\n\t\t\tvar header = '', editor = this.editor, value, styles = '';\n\n\t\t\tif (editor.getParam('fullpage_default_xml_pi'))\n\t\t\t\theader += '<?xml version=\"1.0\" encoding=\"' + editor.getParam('fullpage_default_encoding', 'ISO-8859-1') + '\" ?>\\n';\n\n\t\t\theader += editor.getParam('fullpage_default_doctype', '<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">');\n\t\t\theader += '\\n<html>\\n<head>\\n';\n\n\t\t\tif (value = editor.getParam('fullpage_default_title'))\n\t\t\t\theader += '<title>' + value + '</title>\\n';\n\n\t\t\tif (value = editor.getParam('fullpage_default_encoding'))\n\t\t\t\theader += '<meta http-equiv=\"Content-Type\" content=\"text/html; charset=' + value + '\" />\\n';\n\n\t\t\tif (value = editor.getParam('fullpage_default_font_family'))\n\t\t\t\tstyles += 'font-family: ' + value + ';';\n\n\t\t\tif (value = editor.getParam('fullpage_default_font_size'))\n\t\t\t\tstyles += 'font-size: ' + value + ';';\n\n\t\t\tif (value = editor.getParam('fullpage_default_text_color'))\n\t\t\t\tstyles += 'color: ' + value + ';';\n\n\t\t\theader += '</head>\\n<body' + (styles ? ' style=\"' + styles + '\"' : '') + '>\\n';\n\n\t\t\treturn header;\n\t\t},\n\n\t\t_getContent : function(ed, o) {\n\t\t\tvar self = this;\n\n\t\t\tif (!o.source_view || !ed.getParam('fullpage_hide_in_source_view'))\n\t\t\t\to.content = tinymce.trim(self.head) + '\\n' + tinymce.trim(o.content) + '\\n' + tinymce.trim(self.foot);\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('fullpage', tinymce.plugins.FullPagePlugin);\n})();\n","Magento_Tinymce3/tiny_mce/plugins/fullpage/js/fullpage.js":"/**\n * fullpage.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinyMCEPopup.requireLangPack();\n\n\tvar defaultDocTypes = \n\t\t'XHTML 1.0 Transitional=<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">,' +\n\t\t'XHTML 1.0 Frameset=<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">,' +\n\t\t'XHTML 1.0 Strict=<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">,' +\n\t\t'XHTML 1.1=<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">,' +\n\t\t'HTML 4.01 Transitional=<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">,' +\n\t\t'HTML 4.01 Strict=<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">,' +\n\t\t'HTML 4.01 Frameset=<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">';\n\n\tvar defaultEncodings = \n\t\t'Western european (iso-8859-1)=iso-8859-1,' +\n\t\t'Central European (iso-8859-2)=iso-8859-2,' +\n\t\t'Unicode (UTF-8)=utf-8,' +\n\t\t'Chinese traditional (Big5)=big5,' +\n\t\t'Cyrillic (iso-8859-5)=iso-8859-5,' +\n\t\t'Japanese (iso-2022-jp)=iso-2022-jp,' +\n\t\t'Greek (iso-8859-7)=iso-8859-7,' +\n\t\t'Korean (iso-2022-kr)=iso-2022-kr,' +\n\t\t'ASCII (us-ascii)=us-ascii';\n\n\tvar defaultFontNames = 'Arial=arial,helvetica,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,times new roman,times,serif;Tahoma=tahoma,arial,helvetica,sans-serif;Times New Roman=times new roman,times,serif;Verdana=verdana,arial,helvetica,sans-serif;Impact=impact;WingDings=wingdings';\n\tvar defaultFontSizes = '10px,11px,12px,13px,14px,15px,16px';\n\n\tfunction setVal(id, value) {\n\t\tvar elm = document.getElementById(id);\n\n\t\tif (elm) {\n\t\t\tvalue = value || '';\n\n\t\t\tif (elm.nodeName == \"SELECT\")\n\t\t\t\tselectByValue(document.forms[0], id, value);\n\t\t\telse if (elm.type == \"checkbox\")\n\t\t\t\telm.checked = !!value;\n\t\t\telse\n\t\t\t\telm.value = value;\n\t\t}\n\t};\n\n\tfunction getVal(id) {\n\t\tvar elm = document.getElementById(id);\n\n\t\tif (elm.nodeName == \"SELECT\")\n\t\t\treturn elm.options[elm.selectedIndex].value;\n\n\t\tif (elm.type == \"checkbox\")\n\t\t\treturn elm.checked;\n\n\t\treturn elm.value;\n\t};\n\n\twindow.FullPageDialog = {\n\t\tchangedStyle : function() {\n\t\t\tvar val, styles = tinyMCEPopup.editor.dom.parseStyle(getVal('style'));\n\n\t\t\tsetVal('fontface', styles['font-face']);\n\t\t\tsetVal('fontsize', styles['font-size']);\n\t\t\tsetVal('textcolor', styles['color']);\n\n\t\t\tif (val = styles['background-image'])\n\t\t\t\tsetVal('bgimage', val.replace(new RegExp(\"url\\\\('?([^']*)'?\\\\)\", 'gi'), \"$1\"));\n\t\t\telse\n\t\t\t\tsetVal('bgimage', '');\n\n\t\t\tsetVal('bgcolor', styles['background-color']);\n\n\t\t\t// Reset margin form elements\n\t\t\tsetVal('topmargin', '');\n\t\t\tsetVal('rightmargin', '');\n\t\t\tsetVal('bottommargin', '');\n\t\t\tsetVal('leftmargin', '');\n\n\t\t\t// Expand margin\n\t\t\tif (val = styles['margin']) {\n\t\t\t\tval = val.split(' ');\n\t\t\t\tstyles['margin-top'] = val[0] || '';\n\t\t\t\tstyles['margin-right'] = val[1] || val[0] || '';\n\t\t\t\tstyles['margin-bottom'] = val[2] || val[0] || '';\n\t\t\t\tstyles['margin-left'] = val[3] || val[0] || '';\n\t\t\t}\n\n\t\t\tif (val = styles['margin-top'])\n\t\t\t\tsetVal('topmargin', val.replace(/px/, ''));\n\n\t\t\tif (val = styles['margin-right'])\n\t\t\t\tsetVal('rightmargin', val.replace(/px/, ''));\n\n\t\t\tif (val = styles['margin-bottom'])\n\t\t\t\tsetVal('bottommargin', val.replace(/px/, ''));\n\n\t\t\tif (val = styles['margin-left'])\n\t\t\t\tsetVal('leftmargin', val.replace(/px/, ''));\n\n\t\t\tupdateColor('bgcolor_pick', 'bgcolor');\n\t\t\tupdateColor('textcolor_pick', 'textcolor');\n\t\t},\n\n\t\tchangedStyleProp : function() {\n\t\t\tvar val, dom = tinyMCEPopup.editor.dom, styles = dom.parseStyle(getVal('style'));\n\t\n\t\t\tstyles['font-face'] = getVal('fontface');\n\t\t\tstyles['font-size'] = getVal('fontsize');\n\t\t\tstyles['color'] = getVal('textcolor');\n\t\t\tstyles['background-color'] = getVal('bgcolor');\n\n\t\t\tif (val = getVal('bgimage'))\n\t\t\t\tstyles['background-image'] = \"url('\" + val + \"')\";\n\t\t\telse\n\t\t\t\tstyles['background-image'] = '';\n\n\t\t\tdelete styles['margin'];\n\n\t\t\tif (val = getVal('topmargin'))\n\t\t\t\tstyles['margin-top'] = val + \"px\";\n\t\t\telse\n\t\t\t\tstyles['margin-top'] = '';\n\n\t\t\tif (val = getVal('rightmargin'))\n\t\t\t\tstyles['margin-right'] = val + \"px\";\n\t\t\telse\n\t\t\t\tstyles['margin-right'] = '';\n\n\t\t\tif (val = getVal('bottommargin'))\n\t\t\t\tstyles['margin-bottom'] = val + \"px\";\n\t\t\telse\n\t\t\t\tstyles['margin-bottom'] = '';\n\n\t\t\tif (val = getVal('leftmargin'))\n\t\t\t\tstyles['margin-left'] = val + \"px\";\n\t\t\telse\n\t\t\t\tstyles['margin-left'] = '';\n\n\t\t\t// Serialize, parse and reserialize this will compress redundant styles\n\t\t\tsetVal('style', dom.serializeStyle(dom.parseStyle(dom.serializeStyle(styles))));\n\t\t\tthis.changedStyle();\n\t\t},\n\t\t\n\t\tupdate : function() {\n\t\t\tvar data = {};\n\n\t\t\ttinymce.each(tinyMCEPopup.dom.select('select,input,textarea'), function(node) {\n\t\t\t\tdata[node.id] = getVal(node.id);\n\t\t\t});\n\n\t\t\ttinyMCEPopup.editor.plugins.fullpage._dataToHtml(data);\n\t\t\ttinyMCEPopup.close();\n\t\t}\n\t};\n\t\n\tfunction init() {\n\t\tvar form = document.forms[0], i, item, list, editor = tinyMCEPopup.editor;\n\n\t\t// Setup doctype select box\n\t\tlist = editor.getParam(\"fullpage_doctypes\", defaultDocTypes).split(',');\n\t\tfor (i = 0; i < list.length; i++) {\n\t\t\titem = list[i].split('=');\n\n\t\t\tif (item.length > 1)\n\t\t\t\taddSelectValue(form, 'doctype', item[0], item[1]);\n\t\t}\n\n\t\t// Setup fonts select box\n\t\tlist = editor.getParam(\"fullpage_fonts\", defaultFontNames).split(';');\n\t\tfor (i = 0; i < list.length; i++) {\n\t\t\titem = list[i].split('=');\n\n\t\t\tif (item.length > 1)\n\t\t\t\taddSelectValue(form, 'fontface', item[0], item[1]);\n\t\t}\n\n\t\t// Setup fontsize select box\n\t\tlist = editor.getParam(\"fullpage_fontsizes\", defaultFontSizes).split(',');\n\t\tfor (i = 0; i < list.length; i++)\n\t\t\taddSelectValue(form, 'fontsize', list[i], list[i]);\n\n\t\t// Setup encodings select box\n\t\tlist = editor.getParam(\"fullpage_encodings\", defaultEncodings).split(',');\n\t\tfor (i = 0; i < list.length; i++) {\n\t\t\titem = list[i].split('=');\n\n\t\t\tif (item.length > 1)\n\t\t\t\taddSelectValue(form, 'docencoding', item[0], item[1]);\n\t\t}\n\n\t\t// Setup color pickers\n\t\tdocument.getElementById('bgcolor_pickcontainer').innerHTML = getColorPickerHTML('bgcolor_pick','bgcolor');\n\t\tdocument.getElementById('link_color_pickcontainer').innerHTML = getColorPickerHTML('link_color_pick','link_color');\n\t\tdocument.getElementById('visited_color_pickcontainer').innerHTML = getColorPickerHTML('visited_color_pick','visited_color');\n\t\tdocument.getElementById('active_color_pickcontainer').innerHTML = getColorPickerHTML('active_color_pick','active_color');\n\t\tdocument.getElementById('textcolor_pickcontainer').innerHTML = getColorPickerHTML('textcolor_pick','textcolor');\n\t\tdocument.getElementById('stylesheet_browsercontainer').innerHTML = getBrowserHTML('stylesheetbrowser','stylesheet','file','fullpage');\n\t\tdocument.getElementById('bgimage_pickcontainer').innerHTML = getBrowserHTML('bgimage_browser','bgimage','image','fullpage');\n\n\t\t// Resize some elements\n\t\tif (isVisible('stylesheetbrowser'))\n\t\t\tdocument.getElementById('stylesheet').style.width = '220px';\n\n\t\tif (isVisible('link_href_browser'))\n\t\t\tdocument.getElementById('element_link_href').style.width = '230px';\n\n\t\tif (isVisible('bgimage_browser'))\n\t\t\tdocument.getElementById('bgimage').style.width = '210px';\n\n\t\t// Update form\n\t\ttinymce.each(tinyMCEPopup.getWindowArg('data'), function(value, key) {\n\t\t\tsetVal(key, value);\n\t\t});\n\n\t\tFullPageDialog.changedStyle();\n\n\t\t// Update colors\n\t\tupdateColor('textcolor_pick', 'textcolor');\n\t\tupdateColor('bgcolor_pick', 'bgcolor');\n\t\tupdateColor('visited_color_pick', 'visited_color');\n\t\tupdateColor('active_color_pick', 'active_color');\n\t\tupdateColor('link_color_pick', 'link_color');\n\t};\n\n\ttinyMCEPopup.onInit.add(init);\n})();\n","Magento_Tinymce3/tiny_mce/plugins/fullpage/langs/en_dlg.js":"tinyMCE.addI18n('en.fullpage_dlg',{title:\"Document Properties\",\"meta_tab\":\"General\",\"appearance_tab\":\"Appearance\",\"advanced_tab\":\"Advanced\",\"meta_props\":\"Meta Information\",langprops:\"Language and Encoding\",\"meta_title\":\"Title\",\"meta_keywords\":\"Keywords\",\"meta_description\":\"Description\",\"meta_robots\":\"Robots\",doctypes:\"Doctype\",langcode:\"Language Code\",langdir:\"Language Direction\",ltr:\"Left to Right\",rtl:\"Right to Left\",\"xml_pi\":\"XML Declaration\",encoding:\"Character Encoding\",\"appearance_bgprops\":\"Background Properties\",\"appearance_marginprops\":\"Body Margins\",\"appearance_linkprops\":\"Link Colors\",\"appearance_textprops\":\"Text Properties\",bgcolor:\"Background Color\",bgimage:\"Background Image\",\"left_margin\":\"Left Margin\",\"right_margin\":\"Right Margin\",\"top_margin\":\"Top Margin\",\"bottom_margin\":\"Bottom Margin\",\"text_color\":\"Text Color\",\"font_size\":\"Font Size\",\"font_face\":\"Font Face\",\"link_color\":\"Link Color\",\"hover_color\":\"Hover Color\",\"visited_color\":\"Visited Color\",\"active_color\":\"Active Color\",textcolor:\"Color\",fontsize:\"Font Size\",fontface:\"Font Family\",\"meta_index_follow\":\"Index and Follow the Links\",\"meta_index_nofollow\":\"Index and Don\\'t Follow the Links\",\"meta_noindex_follow\":\"Do Not Index but Follow the Links\",\"meta_noindex_nofollow\":\"Do Not Index and Don\\'t Follow the Links\",\"appearance_style\":\"Stylesheet and Style Properties\",stylesheet:\"Stylesheet\",style:\"Style\",author:\"Author\",copyright:\"Copyright\",add:\"Add New Element\",remove:\"Remove Selected Element\",moveup:\"Move Selected Element Up\",movedown:\"Move Selected Element Down\",\"head_elements\":\"Head Elements\",info:\"Information\",\"add_title\":\"Title Element\",\"add_meta\":\"Meta Element\",\"add_script\":\"Script Element\",\"add_style\":\"Style Element\",\"add_link\":\"Link Element\",\"add_base\":\"Base Element\",\"add_comment\":\"Comment Node\",\"title_element\":\"Title Element\",\"script_element\":\"Script Element\",\"style_element\":\"Style Element\",\"base_element\":\"Base Element\",\"link_element\":\"Link Element\",\"meta_element\":\"Meta Element\",\"comment_element\":\"Comment\",src:\"Source\",language:\"Language\",href:\"HREF\",target:\"Target\",type:\"Type\",charset:\"Charset\",defer:\"Defer\",media:\"Media\",properties:\"Properties\",name:\"Name\",value:\"Value\",content:\"Content\",rel:\"Rel\",rev:\"Rev\",hreflang:\"HREF Lang\",\"general_props\":\"General\",\"advanced_props\":\"Advanced\"});","Magento_Tinymce3/tiny_mce/plugins/xhtmlxtras/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.XHTMLXtrasPlugin\",{init:function(a,b){a.addCommand(\"mceCite\",function(){a.windowManager.open({file:b+\"/cite.htm\",width:350+parseInt(a.getLang(\"xhtmlxtras.cite_delta_width\",0)),height:250+parseInt(a.getLang(\"xhtmlxtras.cite_delta_height\",0)),inline:1},{plugin_url:b})});a.addCommand(\"mceAcronym\",function(){a.windowManager.open({file:b+\"/acronym.htm\",width:350+parseInt(a.getLang(\"xhtmlxtras.acronym_delta_width\",0)),height:250+parseInt(a.getLang(\"xhtmlxtras.acronym_delta_height\",0)),inline:1},{plugin_url:b})});a.addCommand(\"mceAbbr\",function(){a.windowManager.open({file:b+\"/abbr.htm\",width:350+parseInt(a.getLang(\"xhtmlxtras.abbr_delta_width\",0)),height:250+parseInt(a.getLang(\"xhtmlxtras.abbr_delta_height\",0)),inline:1},{plugin_url:b})});a.addCommand(\"mceDel\",function(){a.windowManager.open({file:b+\"/del.htm\",width:340+parseInt(a.getLang(\"xhtmlxtras.del_delta_width\",0)),height:310+parseInt(a.getLang(\"xhtmlxtras.del_delta_height\",0)),inline:1},{plugin_url:b})});a.addCommand(\"mceIns\",function(){a.windowManager.open({file:b+\"/ins.htm\",width:340+parseInt(a.getLang(\"xhtmlxtras.ins_delta_width\",0)),height:310+parseInt(a.getLang(\"xhtmlxtras.ins_delta_height\",0)),inline:1},{plugin_url:b})});a.addCommand(\"mceAttributes\",function(){a.windowManager.open({file:b+\"/attributes.htm\",width:380+parseInt(a.getLang(\"xhtmlxtras.attr_delta_width\",0)),height:370+parseInt(a.getLang(\"xhtmlxtras.attr_delta_height\",0)),inline:1},{plugin_url:b})});a.addButton(\"cite\",{title:\"xhtmlxtras.cite_desc\",cmd:\"mceCite\"});a.addButton(\"acronym\",{title:\"xhtmlxtras.acronym_desc\",cmd:\"mceAcronym\"});a.addButton(\"abbr\",{title:\"xhtmlxtras.abbr_desc\",cmd:\"mceAbbr\"});a.addButton(\"del\",{title:\"xhtmlxtras.del_desc\",cmd:\"mceDel\"});a.addButton(\"ins\",{title:\"xhtmlxtras.ins_desc\",cmd:\"mceIns\"});a.addButton(\"attribs\",{title:\"xhtmlxtras.attribs_desc\",cmd:\"mceAttributes\"});a.onNodeChange.add(function(d,c,f,e){f=d.dom.getParent(f,\"CITE,ACRONYM,ABBR,DEL,INS\");c.setDisabled(\"cite\",e);c.setDisabled(\"acronym\",e);c.setDisabled(\"abbr\",e);c.setDisabled(\"del\",e);c.setDisabled(\"ins\",e);c.setDisabled(\"attribs\",f&&f.nodeName==\"BODY\");c.setActive(\"cite\",0);c.setActive(\"acronym\",0);c.setActive(\"abbr\",0);c.setActive(\"del\",0);c.setActive(\"ins\",0);if(f){do{c.setDisabled(f.nodeName.toLowerCase(),0);c.setActive(f.nodeName.toLowerCase(),1)}while(f=f.parentNode)}});a.onPreInit.add(function(){a.dom.create(\"abbr\")})},getInfo:function(){return{longname:\"XHTML Xtras Plugin\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/xhtmlxtras\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"xhtmlxtras\",tinymce.plugins.XHTMLXtrasPlugin)})();","Magento_Tinymce3/tiny_mce/plugins/xhtmlxtras/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.XHTMLXtrasPlugin', {\n\t\tinit : function(ed, url) {\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceCite', function() {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/cite.htm',\n\t\t\t\t\twidth : 350 + parseInt(ed.getLang('xhtmlxtras.cite_delta_width', 0)),\n\t\t\t\t\theight : 250 + parseInt(ed.getLang('xhtmlxtras.cite_delta_height', 0)),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url\n\t\t\t\t});\n\t\t\t});\n\n\t\t\ted.addCommand('mceAcronym', function() {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/acronym.htm',\n\t\t\t\t\twidth : 350 + parseInt(ed.getLang('xhtmlxtras.acronym_delta_width', 0)),\n\t\t\t\t\theight : 250 + parseInt(ed.getLang('xhtmlxtras.acronym_delta_height', 0)),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url\n\t\t\t\t});\n\t\t\t});\n\n\t\t\ted.addCommand('mceAbbr', function() {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/abbr.htm',\n\t\t\t\t\twidth : 350 + parseInt(ed.getLang('xhtmlxtras.abbr_delta_width', 0)),\n\t\t\t\t\theight : 250 + parseInt(ed.getLang('xhtmlxtras.abbr_delta_height', 0)),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url\n\t\t\t\t});\n\t\t\t});\n\n\t\t\ted.addCommand('mceDel', function() {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/del.htm',\n\t\t\t\t\twidth : 340 + parseInt(ed.getLang('xhtmlxtras.del_delta_width', 0)),\n\t\t\t\t\theight : 310 + parseInt(ed.getLang('xhtmlxtras.del_delta_height', 0)),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url\n\t\t\t\t});\n\t\t\t});\n\n\t\t\ted.addCommand('mceIns', function() {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/ins.htm',\n\t\t\t\t\twidth : 340 + parseInt(ed.getLang('xhtmlxtras.ins_delta_width', 0)),\n\t\t\t\t\theight : 310 + parseInt(ed.getLang('xhtmlxtras.ins_delta_height', 0)),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url\n\t\t\t\t});\n\t\t\t});\n\n\t\t\ted.addCommand('mceAttributes', function() {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/attributes.htm',\n\t\t\t\t\twidth : 380 + parseInt(ed.getLang('xhtmlxtras.attr_delta_width', 0)),\n\t\t\t\t\theight : 370 + parseInt(ed.getLang('xhtmlxtras.attr_delta_height', 0)),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('cite', {title : 'xhtmlxtras.cite_desc', cmd : 'mceCite'});\n\t\t\ted.addButton('acronym', {title : 'xhtmlxtras.acronym_desc', cmd : 'mceAcronym'});\n\t\t\ted.addButton('abbr', {title : 'xhtmlxtras.abbr_desc', cmd : 'mceAbbr'});\n\t\t\ted.addButton('del', {title : 'xhtmlxtras.del_desc', cmd : 'mceDel'});\n\t\t\ted.addButton('ins', {title : 'xhtmlxtras.ins_desc', cmd : 'mceIns'});\n\t\t\ted.addButton('attribs', {title : 'xhtmlxtras.attribs_desc', cmd : 'mceAttributes'});\n\n\t\t\ted.onNodeChange.add(function(ed, cm, n, co) {\n\t\t\t\tn = ed.dom.getParent(n, 'CITE,ACRONYM,ABBR,DEL,INS');\n\n\t\t\t\tcm.setDisabled('cite', co);\n\t\t\t\tcm.setDisabled('acronym', co);\n\t\t\t\tcm.setDisabled('abbr', co);\n\t\t\t\tcm.setDisabled('del', co);\n\t\t\t\tcm.setDisabled('ins', co);\n\t\t\t\tcm.setDisabled('attribs', n && n.nodeName == 'BODY');\n\t\t\t\tcm.setActive('cite', 0);\n\t\t\t\tcm.setActive('acronym', 0);\n\t\t\t\tcm.setActive('abbr', 0);\n\t\t\t\tcm.setActive('del', 0);\n\t\t\t\tcm.setActive('ins', 0);\n\n\t\t\t\t// Activate all\n\t\t\t\tif (n) {\n\t\t\t\t\tdo {\n\t\t\t\t\t\tcm.setDisabled(n.nodeName.toLowerCase(), 0);\n\t\t\t\t\t\tcm.setActive(n.nodeName.toLowerCase(), 1);\n\t\t\t\t\t} while (n = n.parentNode);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\ted.onPreInit.add(function() {\n\t\t\t\t// Fixed IE issue where it can't handle these elements correctly\n\t\t\t\ted.dom.create('abbr');\n\t\t\t});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'XHTML Xtras Plugin',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/xhtmlxtras',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('xhtmlxtras', tinymce.plugins.XHTMLXtrasPlugin);\n})();","Magento_Tinymce3/tiny_mce/plugins/xhtmlxtras/js/acronym.js":"/**\n * acronym.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\nfunction init() {\n\tSXE.initElementDialog('acronym');\n\tif (SXE.currentAction == \"update\") {\n\t\tSXE.showRemoveButton();\n\t}\n}\n\nfunction insertAcronym() {\n\tSXE.insertElement('acronym');\n\ttinyMCEPopup.close();\n}\n\nfunction removeAcronym() {\n\tSXE.removeElement('acronym');\n\ttinyMCEPopup.close();\n}\n\ntinyMCEPopup.onInit.add(init);\n","Magento_Tinymce3/tiny_mce/plugins/xhtmlxtras/js/attributes.js":"/**\n * attributes.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\nfunction init() {\n\ttinyMCEPopup.resizeToInnerSize();\n\tvar inst = tinyMCEPopup.editor;\n\tvar dom = inst.dom;\n\tvar elm = inst.selection.getNode();\n\tvar f = document.forms[0];\n\tvar onclick = dom.getAttrib(elm, 'onclick');\n\n\tsetFormValue('title', dom.getAttrib(elm, 'title'));\n\tsetFormValue('id', dom.getAttrib(elm, 'id'));\n\tsetFormValue('style', dom.getAttrib(elm, \"style\"));\n\tsetFormValue('dir', dom.getAttrib(elm, 'dir'));\n\tsetFormValue('lang', dom.getAttrib(elm, 'lang'));\n\tsetFormValue('tabindex', dom.getAttrib(elm, 'tabindex', typeof(elm.tabindex) != \"undefined\" ? elm.tabindex : \"\"));\n\tsetFormValue('accesskey', dom.getAttrib(elm, 'accesskey', typeof(elm.accesskey) != \"undefined\" ? elm.accesskey : \"\"));\n\tsetFormValue('onfocus', dom.getAttrib(elm, 'onfocus'));\n\tsetFormValue('onblur', dom.getAttrib(elm, 'onblur'));\n\tsetFormValue('onclick', onclick);\n\tsetFormValue('ondblclick', dom.getAttrib(elm, 'ondblclick'));\n\tsetFormValue('onmousedown', dom.getAttrib(elm, 'onmousedown'));\n\tsetFormValue('onmouseup', dom.getAttrib(elm, 'onmouseup'));\n\tsetFormValue('onmouseover', dom.getAttrib(elm, 'onmouseover'));\n\tsetFormValue('onmousemove', dom.getAttrib(elm, 'onmousemove'));\n\tsetFormValue('onmouseout', dom.getAttrib(elm, 'onmouseout'));\n\tsetFormValue('onkeypress', dom.getAttrib(elm, 'onkeypress'));\n\tsetFormValue('onkeydown', dom.getAttrib(elm, 'onkeydown'));\n\tsetFormValue('onkeyup', dom.getAttrib(elm, 'onkeyup'));\n\tclassName = dom.getAttrib(elm, 'class');\n\n\taddClassesToList('classlist', 'advlink_styles');\n\tselectByValue(f, 'classlist', className, true);\n\n\tTinyMCE_EditableSelects.init();\n}\n\nfunction setFormValue(name, value) {\n\tif(value && document.forms[0].elements[name]){\n\t\tdocument.forms[0].elements[name].value = value;\n\t}\n}\n\nfunction insertAction() {\n\tvar inst = tinyMCEPopup.editor;\n\tvar elm = inst.selection.getNode();\n\n\tsetAllAttribs(elm);\n\ttinyMCEPopup.execCommand(\"mceEndUndoLevel\");\n\ttinyMCEPopup.close();\n}\n\nfunction setAttrib(elm, attrib, value) {\n\tvar formObj = document.forms[0];\n\tvar valueElm = formObj.elements[attrib.toLowerCase()];\n\tvar inst = tinyMCEPopup.editor;\n\tvar dom = inst.dom;\n\n\tif (typeof(value) == \"undefined\" || value == null) {\n\t\tvalue = \"\";\n\n\t\tif (valueElm)\n\t\t\tvalue = valueElm.value;\n\t}\n\n\tdom.setAttrib(elm, attrib.toLowerCase(), value);\n}\n\nfunction setAllAttribs(elm) {\n\tvar f = document.forms[0];\n\n\tsetAttrib(elm, 'title');\n\tsetAttrib(elm, 'id');\n\tsetAttrib(elm, 'style');\n\tsetAttrib(elm, 'class', getSelectValue(f, 'classlist'));\n\tsetAttrib(elm, 'dir');\n\tsetAttrib(elm, 'lang');\n\tsetAttrib(elm, 'tabindex');\n\tsetAttrib(elm, 'accesskey');\n\tsetAttrib(elm, 'onfocus');\n\tsetAttrib(elm, 'onblur');\n\tsetAttrib(elm, 'onclick');\n\tsetAttrib(elm, 'ondblclick');\n\tsetAttrib(elm, 'onmousedown');\n\tsetAttrib(elm, 'onmouseup');\n\tsetAttrib(elm, 'onmouseover');\n\tsetAttrib(elm, 'onmousemove');\n\tsetAttrib(elm, 'onmouseout');\n\tsetAttrib(elm, 'onkeypress');\n\tsetAttrib(elm, 'onkeydown');\n\tsetAttrib(elm, 'onkeyup');\n\n\t// Refresh in old MSIE\n//\tif (tinyMCE.isMSIE5)\n//\t\telm.outerHTML = elm.outerHTML;\n}\n\nfunction insertAttribute() {\n\ttinyMCEPopup.close();\n}\n\ntinyMCEPopup.onInit.add(init);\ntinyMCEPopup.requireLangPack();\n","Magento_Tinymce3/tiny_mce/plugins/xhtmlxtras/js/abbr.js":"/**\n * abbr.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\nfunction init() {\n\tSXE.initElementDialog('abbr');\n\tif (SXE.currentAction == \"update\") {\n\t\tSXE.showRemoveButton();\n\t}\n}\n\nfunction insertAbbr() {\n\tSXE.insertElement('abbr');\n\ttinyMCEPopup.close();\n}\n\nfunction removeAbbr() {\n\tSXE.removeElement('abbr');\n\ttinyMCEPopup.close();\n}\n\ntinyMCEPopup.onInit.add(init);\n","Magento_Tinymce3/tiny_mce/plugins/xhtmlxtras/js/ins.js":"/**\n * ins.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\nfunction init() {\n\tSXE.initElementDialog('ins');\n\tif (SXE.currentAction == \"update\") {\n\t\tsetFormValue('datetime', tinyMCEPopup.editor.dom.getAttrib(SXE.updateElement, 'datetime'));\n\t\tsetFormValue('cite', tinyMCEPopup.editor.dom.getAttrib(SXE.updateElement, 'cite'));\n\t\tSXE.showRemoveButton();\n\t}\n}\n\nfunction setElementAttribs(elm) {\n\tsetAllCommonAttribs(elm);\n\tsetAttrib(elm, 'datetime');\n\tsetAttrib(elm, 'cite');\n\telm.removeAttribute('data-mce-new');\n}\n\nfunction insertIns() {\n\tvar elm = tinyMCEPopup.editor.dom.getParent(SXE.focusElement, 'INS');\n\n\tif (elm == null) {\n\t\tvar s = SXE.inst.selection.getContent();\n\t\tif(s.length > 0) {\n\t\t\tinsertInlineElement('ins');\n\t\t\tvar elementArray = SXE.inst.dom.select('ins[data-mce-new]');\n\t\t\tfor (var i=0; i<elementArray.length; i++) {\n\t\t\t\tvar elm = elementArray[i];\n\t\t\t\tsetElementAttribs(elm);\n\t\t\t}\n\t\t}\n\t} else {\n\t\tsetElementAttribs(elm);\n\t}\n\ttinyMCEPopup.editor.nodeChanged();\n\ttinyMCEPopup.execCommand('mceEndUndoLevel');\n\ttinyMCEPopup.close();\n}\n\nfunction removeIns() {\n\tSXE.removeElement('ins');\n\ttinyMCEPopup.close();\n}\n\ntinyMCEPopup.onInit.add(init);\n","Magento_Tinymce3/tiny_mce/plugins/xhtmlxtras/js/del.js":"/**\n * del.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\nfunction init() {\n\tSXE.initElementDialog('del');\n\tif (SXE.currentAction == \"update\") {\n\t\tsetFormValue('datetime', tinyMCEPopup.editor.dom.getAttrib(SXE.updateElement, 'datetime'));\n\t\tsetFormValue('cite', tinyMCEPopup.editor.dom.getAttrib(SXE.updateElement, 'cite'));\n\t\tSXE.showRemoveButton();\n\t}\n}\n\nfunction setElementAttribs(elm) {\n\tsetAllCommonAttribs(elm);\n\tsetAttrib(elm, 'datetime');\n\tsetAttrib(elm, 'cite');\n\telm.removeAttribute('data-mce-new');\n}\n\nfunction insertDel() {\n\tvar elm = tinyMCEPopup.editor.dom.getParent(SXE.focusElement, 'DEL');\n\n\tif (elm == null) {\n\t\tvar s = SXE.inst.selection.getContent();\n\t\tif(s.length > 0) {\n\t\t\tinsertInlineElement('del');\n\t\t\tvar elementArray = SXE.inst.dom.select('del[data-mce-new]');\n\t\t\tfor (var i=0; i<elementArray.length; i++) {\n\t\t\t\tvar elm = elementArray[i];\n\t\t\t\tsetElementAttribs(elm);\n\t\t\t}\n\t\t}\n\t} else {\n\t\tsetElementAttribs(elm);\n\t}\n\ttinyMCEPopup.editor.nodeChanged();\n\ttinyMCEPopup.execCommand('mceEndUndoLevel');\n\ttinyMCEPopup.close();\n}\n\nfunction removeDel() {\n\tSXE.removeElement('del');\n\ttinyMCEPopup.close();\n}\n\ntinyMCEPopup.onInit.add(init);\n","Magento_Tinymce3/tiny_mce/plugins/xhtmlxtras/js/element_common.js":"/**\n * element_common.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\ntinyMCEPopup.requireLangPack();\n\nfunction initCommonAttributes(elm) {\n\tvar formObj = document.forms[0], dom = tinyMCEPopup.editor.dom;\n\n\t// Setup form data for common element attributes\n\tsetFormValue('title', dom.getAttrib(elm, 'title'));\n\tsetFormValue('id', dom.getAttrib(elm, 'id'));\n\tselectByValue(formObj, 'class', dom.getAttrib(elm, 'class'), true);\n\tsetFormValue('style', dom.getAttrib(elm, 'style'));\n\tselectByValue(formObj, 'dir', dom.getAttrib(elm, 'dir'));\n\tsetFormValue('lang', dom.getAttrib(elm, 'lang'));\n\tsetFormValue('onfocus', dom.getAttrib(elm, 'onfocus'));\n\tsetFormValue('onblur', dom.getAttrib(elm, 'onblur'));\n\tsetFormValue('onclick', dom.getAttrib(elm, 'onclick'));\n\tsetFormValue('ondblclick', dom.getAttrib(elm, 'ondblclick'));\n\tsetFormValue('onmousedown', dom.getAttrib(elm, 'onmousedown'));\n\tsetFormValue('onmouseup', dom.getAttrib(elm, 'onmouseup'));\n\tsetFormValue('onmouseover', dom.getAttrib(elm, 'onmouseover'));\n\tsetFormValue('onmousemove', dom.getAttrib(elm, 'onmousemove'));\n\tsetFormValue('onmouseout', dom.getAttrib(elm, 'onmouseout'));\n\tsetFormValue('onkeypress', dom.getAttrib(elm, 'onkeypress'));\n\tsetFormValue('onkeydown', dom.getAttrib(elm, 'onkeydown'));\n\tsetFormValue('onkeyup', dom.getAttrib(elm, 'onkeyup'));\n}\n\nfunction setFormValue(name, value) {\n\tif(document.forms[0].elements[name]) document.forms[0].elements[name].value = value;\n}\n\nfunction insertDateTime(id) {\n\tdocument.getElementById(id).value = getDateTime(new Date(), \"%Y-%m-%dT%H:%M:%S\");\n}\n\nfunction getDateTime(d, fmt) {\n\tfmt = fmt.replace(\"%D\", \"%m/%d/%y\");\n\tfmt = fmt.replace(\"%r\", \"%I:%M:%S %p\");\n\tfmt = fmt.replace(\"%Y\", \"\" + d.getFullYear());\n\tfmt = fmt.replace(\"%y\", \"\" + d.getYear());\n\tfmt = fmt.replace(\"%m\", addZeros(d.getMonth()+1, 2));\n\tfmt = fmt.replace(\"%d\", addZeros(d.getDate(), 2));\n\tfmt = fmt.replace(\"%H\", \"\" + addZeros(d.getHours(), 2));\n\tfmt = fmt.replace(\"%M\", \"\" + addZeros(d.getMinutes(), 2));\n\tfmt = fmt.replace(\"%S\", \"\" + addZeros(d.getSeconds(), 2));\n\tfmt = fmt.replace(\"%I\", \"\" + ((d.getHours() + 11) % 12 + 1));\n\tfmt = fmt.replace(\"%p\", \"\" + (d.getHours() < 12 ? \"AM\" : \"PM\"));\n\tfmt = fmt.replace(\"%%\", \"%\");\n\n\treturn fmt;\n}\n\nfunction addZeros(value, len) {\n\tvar i;\n\n\tvalue = \"\" + value;\n\n\tif (value.length < len) {\n\t\tfor (i=0; i<(len-value.length); i++)\n\t\t\tvalue = \"0\" + value;\n\t}\n\n\treturn value;\n}\n\nfunction selectByValue(form_obj, field_name, value, add_custom, ignore_case) {\n\tif (!form_obj || !form_obj.elements[field_name])\n\t\treturn;\n\n\tvar sel = form_obj.elements[field_name];\n\n\tvar found = false;\n\tfor (var i=0; i<sel.options.length; i++) {\n\t\tvar option = sel.options[i];\n\n\t\tif (option.value == value || (ignore_case && option.value.toLowerCase() == value.toLowerCase())) {\n\t\t\toption.selected = true;\n\t\t\tfound = true;\n\t\t} else\n\t\t\toption.selected = false;\n\t}\n\n\tif (!found && add_custom && value != '') {\n\t\tvar option = new Option('Value: ' + value, value);\n\t\toption.selected = true;\n\t\tsel.options[sel.options.length] = option;\n\t}\n\n\treturn found;\n}\n\nfunction setAttrib(elm, attrib, value) {\n\tvar formObj = document.forms[0];\n\tvar valueElm = formObj.elements[attrib.toLowerCase()];\n\ttinyMCEPopup.editor.dom.setAttrib(elm, attrib, value || valueElm.value);\n}\n\nfunction setAllCommonAttribs(elm) {\n\tsetAttrib(elm, 'title');\n\tsetAttrib(elm, 'id');\n\tsetAttrib(elm, 'class');\n\tsetAttrib(elm, 'style');\n\tsetAttrib(elm, 'dir');\n\tsetAttrib(elm, 'lang');\n\t/*setAttrib(elm, 'onfocus');\n\tsetAttrib(elm, 'onblur');\n\tsetAttrib(elm, 'onclick');\n\tsetAttrib(elm, 'ondblclick');\n\tsetAttrib(elm, 'onmousedown');\n\tsetAttrib(elm, 'onmouseup');\n\tsetAttrib(elm, 'onmouseover');\n\tsetAttrib(elm, 'onmousemove');\n\tsetAttrib(elm, 'onmouseout');\n\tsetAttrib(elm, 'onkeypress');\n\tsetAttrib(elm, 'onkeydown');\n\tsetAttrib(elm, 'onkeyup');*/\n}\n\nSXE = {\n\tcurrentAction : \"insert\",\n\tinst : tinyMCEPopup.editor,\n\tupdateElement : null\n}\n\nSXE.focusElement = SXE.inst.selection.getNode();\n\nSXE.initElementDialog = function(element_name) {\n\taddClassesToList('class', 'xhtmlxtras_styles');\n\tTinyMCE_EditableSelects.init();\n\n\telement_name = element_name.toLowerCase();\n\tvar elm = SXE.inst.dom.getParent(SXE.focusElement, element_name.toUpperCase());\n\tif (elm != null && elm.nodeName.toUpperCase() == element_name.toUpperCase()) {\n\t\tSXE.currentAction = \"update\";\n\t}\n\n\tif (SXE.currentAction == \"update\") {\n\t\tinitCommonAttributes(elm);\n\t\tSXE.updateElement = elm;\n\t}\n\n\tdocument.forms[0].insert.value = tinyMCEPopup.getLang(SXE.currentAction, 'Insert', true); \n}\n\nSXE.insertElement = function(element_name) {\n\tvar elm = SXE.inst.dom.getParent(SXE.focusElement, element_name.toUpperCase()), h, tagName;\n\n\tif (elm == null) {\n\t\tvar s = SXE.inst.selection.getContent();\n\t\tif(s.length > 0) {\n\t\t\ttagName = element_name;\n\n\t\t\tinsertInlineElement(element_name);\n\t\t\tvar elementArray = tinymce.grep(SXE.inst.dom.select(element_name));\n\t\t\tfor (var i=0; i<elementArray.length; i++) {\n\t\t\t\tvar elm = elementArray[i];\n\n\t\t\t\tif (SXE.inst.dom.getAttrib(elm, 'data-mce-new')) {\n\t\t\t\t\telm.id = '';\n\t\t\t\t\telm.setAttribute('id', '');\n\t\t\t\t\telm.removeAttribute('id');\n\t\t\t\t\telm.removeAttribute('data-mce-new');\n\n\t\t\t\t\tsetAllCommonAttribs(elm);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t} else {\n\t\tsetAllCommonAttribs(elm);\n\t}\n\tSXE.inst.nodeChanged();\n\ttinyMCEPopup.execCommand('mceEndUndoLevel');\n}\n\nSXE.removeElement = function(element_name){\n\telement_name = element_name.toLowerCase();\n\telm = SXE.inst.dom.getParent(SXE.focusElement, element_name.toUpperCase());\n\tif(elm && elm.nodeName.toUpperCase() == element_name.toUpperCase()){\n\t\ttinyMCE.execCommand('mceRemoveNode', false, elm);\n\t\tSXE.inst.nodeChanged();\n\t\ttinyMCEPopup.execCommand('mceEndUndoLevel');\n\t}\n}\n\nSXE.showRemoveButton = function() {\n\t\tdocument.getElementById(\"remove\").style.display = '';\n}\n\nSXE.containsClass = function(elm,cl) {\n\treturn (elm.className.indexOf(cl) > -1) ? true : false;\n}\n\nSXE.removeClass = function(elm,cl) {\n\tif(elm.className == null || elm.className == \"\" || !SXE.containsClass(elm,cl)) {\n\t\treturn true;\n\t}\n\tvar classNames = elm.className.split(\" \");\n\tvar newClassNames = \"\";\n\tfor (var x = 0, cnl = classNames.length; x < cnl; x++) {\n\t\tif (classNames[x] != cl) {\n\t\t\tnewClassNames += (classNames[x] + \" \");\n\t\t}\n\t}\n\telm.className = newClassNames.substring(0,newClassNames.length-1); //removes extra space at the end\n}\n\nSXE.addClass = function(elm,cl) {\n\tif(!SXE.containsClass(elm,cl)) elm.className ? elm.className += \" \" + cl : elm.className = cl;\n\treturn true;\n}\n\nfunction insertInlineElement(en) {\n\tvar ed = tinyMCEPopup.editor, dom = ed.dom;\n\n\ted.getDoc().execCommand('FontName', false, 'mceinline');\n\ttinymce.each(dom.select('span,font'), function(n) {\n\t\tif (n.style.fontFamily == 'mceinline' || n.face == 'mceinline')\n\t\t\tdom.replace(dom.create(en, {'data-mce-new' : 1}), n, 1);\n\t});\n}\n","Magento_Tinymce3/tiny_mce/plugins/xhtmlxtras/js/cite.js":"/**\n * cite.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\nfunction init() {\n\tSXE.initElementDialog('cite');\n\tif (SXE.currentAction == \"update\") {\n\t\tSXE.showRemoveButton();\n\t}\n}\n\nfunction insertCite() {\n\tSXE.insertElement('cite');\n\ttinyMCEPopup.close();\n}\n\nfunction removeCite() {\n\tSXE.removeElement('cite');\n\ttinyMCEPopup.close();\n}\n\ntinyMCEPopup.onInit.add(init);\n","Magento_Tinymce3/tiny_mce/plugins/xhtmlxtras/langs/en_dlg.js":"tinyMCE.addI18n('en.xhtmlxtras_dlg',{\"attribs_title\":\"Insert/Edit Attributes\",\"option_rtl\":\"Right to Left\",\"option_ltr\":\"Left to Right\",\"insert_date\":\"Insert Current Date/Time\",remove:\"Remove\",\"title_cite_element\":\"Citation Element\",\"title_abbr_element\":\"Abbreviation Element\",\"title_acronym_element\":\"Acronym Element\",\"title_del_element\":\"Deletion Element\",\"title_ins_element\":\"Insertion Element\",\"fieldset_events_tab\":\"Element Events\",\"fieldset_attrib_tab\":\"Element Attributes\",\"fieldset_general_tab\":\"General Settings\",\"events_tab\":\"Events\",\"attrib_tab\":\"Attributes\",\"general_tab\":\"General\",\"attribute_attrib_tab\":\"Attributes\",\"attribute_events_tab\":\"Events\",\"attribute_label_accesskey\":\"AccessKey\",\"attribute_label_tabindex\":\"TabIndex\",\"attribute_label_langcode\":\"Language\",\"attribute_option_rtl\":\"Right to Left\",\"attribute_option_ltr\":\"Left to Right\",\"attribute_label_langdir\":\"Text Direction\",\"attribute_label_datetime\":\"Date/Time\",\"attribute_label_cite\":\"Cite\",\"attribute_label_style\":\"Style\",\"attribute_label_class\":\"Class\",\"attribute_label_id\":\"ID\",\"attribute_label_title\":\"Title\"});","Magento_Tinymce3/tiny_mce/plugins/nonbreaking/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.Nonbreaking\",{init:function(a,b){var c=this;c.editor=a;a.addCommand(\"mceNonBreaking\",function(){a.execCommand(\"mceInsertContent\",false,(a.plugins.visualchars&&a.plugins.visualchars.state)?'<span data-mce-bogus=\"1\" class=\"mceItemHidden mceItemNbsp\">&nbsp;</span>':\"&nbsp;\")});a.addButton(\"nonbreaking\",{title:\"nonbreaking.nonbreaking_desc\",cmd:\"mceNonBreaking\"});if(a.getParam(\"nonbreaking_force_tab\")){a.onKeyDown.add(function(d,f){if(f.keyCode==9){f.preventDefault();d.execCommand(\"mceNonBreaking\");d.execCommand(\"mceNonBreaking\");d.execCommand(\"mceNonBreaking\")}})}},getInfo:function(){return{longname:\"Nonbreaking space\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/nonbreaking\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"nonbreaking\",tinymce.plugins.Nonbreaking)})();","Magento_Tinymce3/tiny_mce/plugins/nonbreaking/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.Nonbreaking', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this;\n\n\t\t\tt.editor = ed;\n\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceNonBreaking', function() {\n\t\t\t\ted.execCommand('mceInsertContent', false, (ed.plugins.visualchars && ed.plugins.visualchars.state) ? '<span data-mce-bogus=\"1\" class=\"mceItemHidden mceItemNbsp\">&nbsp;</span>' : '&nbsp;');\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('nonbreaking', {title : 'nonbreaking.nonbreaking_desc', cmd : 'mceNonBreaking'});\n\n\t\t\tif (ed.getParam('nonbreaking_force_tab')) {\n\t\t\t\ted.onKeyDown.add(function(ed, e) {\n\t\t\t\t\tif (e.keyCode == 9) {\n\t\t\t\t\t\te.preventDefault();\n\t\n\t\t\t\t\t\ted.execCommand('mceNonBreaking');\n\t\t\t\t\t\ted.execCommand('mceNonBreaking');\n\t\t\t\t\t\ted.execCommand('mceNonBreaking');\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Nonbreaking space',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/nonbreaking',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\n\t\t// Private methods\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('nonbreaking', tinymce.plugins.Nonbreaking);\n})();","Magento_Tinymce3/tiny_mce/plugins/bbcode/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.BBCodePlugin\",{init:function(a,b){var d=this,c=a.getParam(\"bbcode_dialect\",\"punbb\").toLowerCase();a.onBeforeSetContent.add(function(e,f){f.content=d[\"_\"+c+\"_bbcode2html\"](f.content)});a.onPostProcess.add(function(e,f){if(f.set){f.content=d[\"_\"+c+\"_bbcode2html\"](f.content)}if(f.get){f.content=d[\"_\"+c+\"_html2bbcode\"](f.content)}})},getInfo:function(){return{longname:\"BBCode Plugin\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/bbcode\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}},_punbb_html2bbcode:function(a){a=tinymce.trim(a);function b(c,d){a=a.replace(c,d)}b(/<a.*?href=\\\"(.*?)\\\".*?>(.*?)<\\/a>/gi,\"[url=$1]$2[/url]\");b(/<font.*?color=\\\"(.*?)\\\".*?class=\\\"codeStyle\\\".*?>(.*?)<\\/font>/gi,\"[code][color=$1]$2[/color][/code]\");b(/<font.*?color=\\\"(.*?)\\\".*?class=\\\"quoteStyle\\\".*?>(.*?)<\\/font>/gi,\"[quote][color=$1]$2[/color][/quote]\");b(/<font.*?class=\\\"codeStyle\\\".*?color=\\\"(.*?)\\\".*?>(.*?)<\\/font>/gi,\"[code][color=$1]$2[/color][/code]\");b(/<font.*?class=\\\"quoteStyle\\\".*?color=\\\"(.*?)\\\".*?>(.*?)<\\/font>/gi,\"[quote][color=$1]$2[/color][/quote]\");b(/<span style=\\\"color: ?(.*?);\\\">(.*?)<\\/span>/gi,\"[color=$1]$2[/color]\");b(/<font.*?color=\\\"(.*?)\\\".*?>(.*?)<\\/font>/gi,\"[color=$1]$2[/color]\");b(/<span style=\\\"font-size:(.*?);\\\">(.*?)<\\/span>/gi,\"[size=$1]$2[/size]\");b(/<font>(.*?)<\\/font>/gi,\"$1\");b(/<img.*?src=\\\"(.*?)\\\".*?\\/>/gi,\"[img]$1[/img]\");b(/<span class=\\\"codeStyle\\\">(.*?)<\\/span>/gi,\"[code]$1[/code]\");b(/<span class=\\\"quoteStyle\\\">(.*?)<\\/span>/gi,\"[quote]$1[/quote]\");b(/<strong class=\\\"codeStyle\\\">(.*?)<\\/strong>/gi,\"[code][b]$1[/b][/code]\");b(/<strong class=\\\"quoteStyle\\\">(.*?)<\\/strong>/gi,\"[quote][b]$1[/b][/quote]\");b(/<em class=\\\"codeStyle\\\">(.*?)<\\/em>/gi,\"[code][i]$1[/i][/code]\");b(/<em class=\\\"quoteStyle\\\">(.*?)<\\/em>/gi,\"[quote][i]$1[/i][/quote]\");b(/<u class=\\\"codeStyle\\\">(.*?)<\\/u>/gi,\"[code][u]$1[/u][/code]\");b(/<u class=\\\"quoteStyle\\\">(.*?)<\\/u>/gi,\"[quote][u]$1[/u][/quote]\");b(/<\\/(strong|b)>/gi,\"[/b]\");b(/<(strong|b)>/gi,\"[b]\");b(/<\\/(em|i)>/gi,\"[/i]\");b(/<(em|i)>/gi,\"[i]\");b(/<\\/u>/gi,\"[/u]\");b(/<span style=\\\"text-decoration: ?underline;\\\">(.*?)<\\/span>/gi,\"[u]$1[/u]\");b(/<u>/gi,\"[u]\");b(/<blockquote[^>]*>/gi,\"[quote]\");b(/<\\/blockquote>/gi,\"[/quote]\");b(/<br \\/>/gi,\"\\n\");b(/<br\\/>/gi,\"\\n\");b(/<br>/gi,\"\\n\");b(/<p>/gi,\"\");b(/<\\/p>/gi,\"\\n\");b(/&nbsp;|\\u00a0/gi,\" \");b(/&quot;/gi,'\"');b(/&lt;/gi,\"<\");b(/&gt;/gi,\">\");b(/&amp;/gi,\"&\");return a},_punbb_bbcode2html:function(a){a=tinymce.trim(a);function b(c,d){a=a.replace(c,d)}b(/\\n/gi,\"<br />\");b(/\\[b\\]/gi,\"<strong>\");b(/\\[\\/b\\]/gi,\"</strong>\");b(/\\[i\\]/gi,\"<em>\");b(/\\[\\/i\\]/gi,\"</em>\");b(/\\[u\\]/gi,\"<u>\");b(/\\[\\/u\\]/gi,\"</u>\");b(/\\[url=([^\\]]+)\\](.*?)\\[\\/url\\]/gi,'<a href=\"$1\">$2</a>');b(/\\[url\\](.*?)\\[\\/url\\]/gi,'<a href=\"$1\">$1</a>');b(/\\[img\\](.*?)\\[\\/img\\]/gi,'<img src=\"$1\" />');b(/\\[color=(.*?)\\](.*?)\\[\\/color\\]/gi,'<font color=\"$1\">$2</font>');b(/\\[code\\](.*?)\\[\\/code\\]/gi,'<span class=\"codeStyle\">$1</span>&nbsp;');b(/\\[quote.*?\\](.*?)\\[\\/quote\\]/gi,'<span class=\"quoteStyle\">$1</span>&nbsp;');return a}});tinymce.PluginManager.add(\"bbcode\",tinymce.plugins.BBCodePlugin)})();","Magento_Tinymce3/tiny_mce/plugins/bbcode/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.BBCodePlugin', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this, dialect = ed.getParam('bbcode_dialect', 'punbb').toLowerCase();\n\n\t\t\ted.onBeforeSetContent.add(function(ed, o) {\n\t\t\t\to.content = t['_' + dialect + '_bbcode2html'](o.content);\n\t\t\t});\n\n\t\t\ted.onPostProcess.add(function(ed, o) {\n\t\t\t\tif (o.set)\n\t\t\t\t\to.content = t['_' + dialect + '_bbcode2html'](o.content);\n\n\t\t\t\tif (o.get)\n\t\t\t\t\to.content = t['_' + dialect + '_html2bbcode'](o.content);\n\t\t\t});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'BBCode Plugin',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/bbcode',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t},\n\n\t\t// Private methods\n\n\t\t// HTML -> BBCode in PunBB dialect\n\t\t_punbb_html2bbcode : function(s) {\n\t\t\ts = tinymce.trim(s);\n\n\t\t\tfunction rep(re, str) {\n\t\t\t\ts = s.replace(re, str);\n\t\t\t};\n\n\t\t\t// example: <strong> to [b]\n\t\t\trep(/<a.*?href=\\\"(.*?)\\\".*?>(.*?)<\\/a>/gi,\"[url=$1]$2[/url]\");\n\t\t\trep(/<font.*?color=\\\"(.*?)\\\".*?class=\\\"codeStyle\\\".*?>(.*?)<\\/font>/gi,\"[code][color=$1]$2[/color][/code]\");\n\t\t\trep(/<font.*?color=\\\"(.*?)\\\".*?class=\\\"quoteStyle\\\".*?>(.*?)<\\/font>/gi,\"[quote][color=$1]$2[/color][/quote]\");\n\t\t\trep(/<font.*?class=\\\"codeStyle\\\".*?color=\\\"(.*?)\\\".*?>(.*?)<\\/font>/gi,\"[code][color=$1]$2[/color][/code]\");\n\t\t\trep(/<font.*?class=\\\"quoteStyle\\\".*?color=\\\"(.*?)\\\".*?>(.*?)<\\/font>/gi,\"[quote][color=$1]$2[/color][/quote]\");\n\t\t\trep(/<span style=\\\"color: ?(.*?);\\\">(.*?)<\\/span>/gi,\"[color=$1]$2[/color]\");\n\t\t\trep(/<font.*?color=\\\"(.*?)\\\".*?>(.*?)<\\/font>/gi,\"[color=$1]$2[/color]\");\n\t\t\trep(/<span style=\\\"font-size:(.*?);\\\">(.*?)<\\/span>/gi,\"[size=$1]$2[/size]\");\n\t\t\trep(/<font>(.*?)<\\/font>/gi,\"$1\");\n\t\t\trep(/<img.*?src=\\\"(.*?)\\\".*?\\/>/gi,\"[img]$1[/img]\");\n\t\t\trep(/<span class=\\\"codeStyle\\\">(.*?)<\\/span>/gi,\"[code]$1[/code]\");\n\t\t\trep(/<span class=\\\"quoteStyle\\\">(.*?)<\\/span>/gi,\"[quote]$1[/quote]\");\n\t\t\trep(/<strong class=\\\"codeStyle\\\">(.*?)<\\/strong>/gi,\"[code][b]$1[/b][/code]\");\n\t\t\trep(/<strong class=\\\"quoteStyle\\\">(.*?)<\\/strong>/gi,\"[quote][b]$1[/b][/quote]\");\n\t\t\trep(/<em class=\\\"codeStyle\\\">(.*?)<\\/em>/gi,\"[code][i]$1[/i][/code]\");\n\t\t\trep(/<em class=\\\"quoteStyle\\\">(.*?)<\\/em>/gi,\"[quote][i]$1[/i][/quote]\");\n\t\t\trep(/<u class=\\\"codeStyle\\\">(.*?)<\\/u>/gi,\"[code][u]$1[/u][/code]\");\n\t\t\trep(/<u class=\\\"quoteStyle\\\">(.*?)<\\/u>/gi,\"[quote][u]$1[/u][/quote]\");\n\t\t\trep(/<\\/(strong|b)>/gi,\"[/b]\");\n\t\t\trep(/<(strong|b)>/gi,\"[b]\");\n\t\t\trep(/<\\/(em|i)>/gi,\"[/i]\");\n\t\t\trep(/<(em|i)>/gi,\"[i]\");\n\t\t\trep(/<\\/u>/gi,\"[/u]\");\n\t\t\trep(/<span style=\\\"text-decoration: ?underline;\\\">(.*?)<\\/span>/gi,\"[u]$1[/u]\");\n\t\t\trep(/<u>/gi,\"[u]\");\n\t\t\trep(/<blockquote[^>]*>/gi,\"[quote]\");\n\t\t\trep(/<\\/blockquote>/gi,\"[/quote]\");\n\t\t\trep(/<br \\/>/gi,\"\\n\");\n\t\t\trep(/<br\\/>/gi,\"\\n\");\n\t\t\trep(/<br>/gi,\"\\n\");\n\t\t\trep(/<p>/gi,\"\");\n\t\t\trep(/<\\/p>/gi,\"\\n\");\n\t\t\trep(/&nbsp;|\\u00a0/gi,\" \");\n\t\t\trep(/&quot;/gi,\"\\\"\");\n\t\t\trep(/&lt;/gi,\"<\");\n\t\t\trep(/&gt;/gi,\">\");\n\t\t\trep(/&amp;/gi,\"&\");\n\n\t\t\treturn s; \n\t\t},\n\n\t\t// BBCode -> HTML from PunBB dialect\n\t\t_punbb_bbcode2html : function(s) {\n\t\t\ts = tinymce.trim(s);\n\n\t\t\tfunction rep(re, str) {\n\t\t\t\ts = s.replace(re, str);\n\t\t\t};\n\n\t\t\t// example: [b] to <strong>\n\t\t\trep(/\\n/gi,\"<br />\");\n\t\t\trep(/\\[b\\]/gi,\"<strong>\");\n\t\t\trep(/\\[\\/b\\]/gi,\"</strong>\");\n\t\t\trep(/\\[i\\]/gi,\"<em>\");\n\t\t\trep(/\\[\\/i\\]/gi,\"</em>\");\n\t\t\trep(/\\[u\\]/gi,\"<u>\");\n\t\t\trep(/\\[\\/u\\]/gi,\"</u>\");\n\t\t\trep(/\\[url=([^\\]]+)\\](.*?)\\[\\/url\\]/gi,\"<a href=\\\"$1\\\">$2</a>\");\n\t\t\trep(/\\[url\\](.*?)\\[\\/url\\]/gi,\"<a href=\\\"$1\\\">$1</a>\");\n\t\t\trep(/\\[img\\](.*?)\\[\\/img\\]/gi,\"<img src=\\\"$1\\\" />\");\n\t\t\trep(/\\[color=(.*?)\\](.*?)\\[\\/color\\]/gi,\"<font color=\\\"$1\\\">$2</font>\");\n\t\t\trep(/\\[code\\](.*?)\\[\\/code\\]/gi,\"<span class=\\\"codeStyle\\\">$1</span>&nbsp;\");\n\t\t\trep(/\\[quote.*?\\](.*?)\\[\\/quote\\]/gi,\"<span class=\\\"quoteStyle\\\">$1</span>&nbsp;\");\n\n\t\t\treturn s; \n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('bbcode', tinymce.plugins.BBCodePlugin);\n})();","Magento_Tinymce3/tiny_mce/plugins/contextmenu/editor_plugin.js":"(function(){var a=tinymce.dom.Event,c=tinymce.each,b=tinymce.DOM;tinymce.create(\"tinymce.plugins.ContextMenu\",{init:function(e){var h=this,f,d,i;h.editor=e;d=e.settings.contextmenu_never_use_native;h.onContextMenu=new tinymce.util.Dispatcher(this);f=e.onContextMenu.add(function(j,k){if((i!==0?i:k.ctrlKey)&&!d){return}a.cancel(k);if(k.target.nodeName==\"IMG\"){j.selection.select(k.target)}h._getMenu(j).showMenu(k.clientX||k.pageX,k.clientY||k.pageY);a.add(j.getDoc(),\"click\",function(l){g(j,l)});j.nodeChanged()});e.onRemove.add(function(){if(h._menu){h._menu.removeAll()}});function g(j,k){i=0;if(k&&k.button==2){i=k.ctrlKey;return}if(h._menu){h._menu.removeAll();h._menu.destroy();a.remove(j.getDoc(),\"click\",g)}}e.onMouseDown.add(g);e.onKeyDown.add(g);e.onKeyDown.add(function(j,k){if(k.shiftKey&&!k.ctrlKey&&!k.altKey&&k.keyCode===121){a.cancel(k);f(j,k)}})},getInfo:function(){return{longname:\"Contextmenu\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/contextmenu\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}},_getMenu:function(e){var g=this,d=g._menu,j=e.selection,f=j.isCollapsed(),h=j.getNode()||e.getBody(),i,k;if(d){d.removeAll();d.destroy()}k=b.getPos(e.getContentAreaContainer());d=e.controlManager.createDropMenu(\"contextmenu\",{offset_x:k.x+e.getParam(\"contextmenu_offset_x\",0),offset_y:k.y+e.getParam(\"contextmenu_offset_y\",0),constrain:1,keyboard_focus:true});g._menu=d;d.add({title:\"advanced.cut_desc\",icon:\"cut\",cmd:\"Cut\"}).setDisabled(f);d.add({title:\"advanced.copy_desc\",icon:\"copy\",cmd:\"Copy\"}).setDisabled(f);d.add({title:\"advanced.paste_desc\",icon:\"paste\",cmd:\"Paste\"});if((h.nodeName==\"A\"&&!e.dom.getAttrib(h,\"name\"))||!f){d.addSeparator();d.add({title:\"advanced.link_desc\",icon:\"link\",cmd:e.plugins.advlink?\"mceAdvLink\":\"mceLink\",ui:true});d.add({title:\"advanced.unlink_desc\",icon:\"unlink\",cmd:\"UnLink\"})}d.addSeparator();d.add({title:\"advanced.image_desc\",icon:\"image\",cmd:e.plugins.advimage?\"mceAdvImage\":\"mceImage\",ui:true});d.addSeparator();i=d.addMenu({title:\"contextmenu.align\"});i.add({title:\"contextmenu.left\",icon:\"justifyleft\",cmd:\"JustifyLeft\"});i.add({title:\"contextmenu.center\",icon:\"justifycenter\",cmd:\"JustifyCenter\"});i.add({title:\"contextmenu.right\",icon:\"justifyright\",cmd:\"JustifyRight\"});i.add({title:\"contextmenu.full\",icon:\"justifyfull\",cmd:\"JustifyFull\"});g.onContextMenu.dispatch(g,d,h,f);return d}});tinymce.PluginManager.add(\"contextmenu\",tinymce.plugins.ContextMenu)})();","Magento_Tinymce3/tiny_mce/plugins/contextmenu/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\tvar Event = tinymce.dom.Event, each = tinymce.each, DOM = tinymce.DOM;\n\n\t/**\n\t * This plugin a context menu to TinyMCE editor instances.\n\t *\n\t * @class tinymce.plugins.ContextMenu\n\t */\n\ttinymce.create('tinymce.plugins.ContextMenu', {\n\t\t/**\n\t\t * Initializes the plugin, this will be executed after the plugin has been created.\n\t\t * This call is done before the editor instance has finished it's initialization so use the onInit event\n\t\t * of the editor instance to intercept that event.\n\t\t *\n\t\t * @method init\n\t\t * @param {tinymce.Editor} ed Editor instance that the plugin is initialized in.\n\t\t * @param {string} url Absolute URL to where the plugin is located.\n\t\t */\n\t\tinit : function(ed) {\n\t\t\tvar t = this, showMenu, contextmenuNeverUseNative, realCtrlKey;\n\n\t\t\tt.editor = ed;\n\n\t\t\tcontextmenuNeverUseNative = ed.settings.contextmenu_never_use_native;\n\n\t\t\t/**\n\t\t\t * This event gets fired when the context menu is shown.\n\t\t\t *\n\t\t\t * @event onContextMenu\n\t\t\t * @param {tinymce.plugins.ContextMenu} sender Plugin instance sending the event.\n\t\t\t * @param {tinymce.ui.DropMenu} menu Drop down menu to fill with more items if needed.\n\t\t\t */\n\t\t\tt.onContextMenu = new tinymce.util.Dispatcher(this);\n\n\t\t\tshowMenu = ed.onContextMenu.add(function(ed, e) {\n\t\t\t\t// Block TinyMCE menu on ctrlKey and work around Safari issue\n\t\t\t\tif ((realCtrlKey !== 0 ? realCtrlKey : e.ctrlKey) && !contextmenuNeverUseNative)\n\t\t\t\t\treturn;\n\n\t\t\t\tEvent.cancel(e);\n\n\t\t\t\t// Select the image if it's clicked. WebKit would other wise expand the selection\n\t\t\t\tif (e.target.nodeName == 'IMG')\n\t\t\t\t\ted.selection.select(e.target);\n\n\t\t\t\tt._getMenu(ed).showMenu(e.clientX || e.pageX, e.clientY || e.pageY);\n\t\t\t\tEvent.add(ed.getDoc(), 'click', function(e) {\n\t\t\t\t\thide(ed, e);\n\t\t\t\t});\n\n\t\t\t\ted.nodeChanged();\n\t\t\t});\n\n\t\t\ted.onRemove.add(function() {\n\t\t\t\tif (t._menu)\n\t\t\t\t\tt._menu.removeAll();\n\t\t\t});\n\n\t\t\tfunction hide(ed, e) {\n\t\t\t\trealCtrlKey = 0;\n\n\t\t\t\t// Since the contextmenu event moves\n\t\t\t\t// the selection we need to store it away\n\t\t\t\tif (e && e.button == 2) {\n\t\t\t\t\trealCtrlKey = e.ctrlKey;\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (t._menu) {\n\t\t\t\t\tt._menu.removeAll();\n\t\t\t\t\tt._menu.destroy();\n\t\t\t\t\tEvent.remove(ed.getDoc(), 'click', hide);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\ted.onMouseDown.add(hide);\n\t\t\ted.onKeyDown.add(hide);\n\t\t\ted.onKeyDown.add(function(ed, e) {\n\t\t\t\tif (e.shiftKey && !e.ctrlKey && !e.altKey && e.keyCode === 121) {\n\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t\tshowMenu(ed, e);\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Returns information about the plugin as a name/value array.\n\t\t * The current keys are longname, author, authorurl, infourl and version.\n\t\t *\n\t\t * @method getInfo\n\t\t * @return {Object} Name/value array containing information about the plugin.\n\t\t */\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Contextmenu',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/contextmenu',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t},\n\n\t\t_getMenu : function(ed) {\n\t\t\tvar t = this, m = t._menu, se = ed.selection, col = se.isCollapsed(), el = se.getNode() || ed.getBody(), am, p;\n\n\t\t\tif (m) {\n\t\t\t\tm.removeAll();\n\t\t\t\tm.destroy();\n\t\t\t}\n\n\t\t\tp = DOM.getPos(ed.getContentAreaContainer());\n\n\t\t\tm = ed.controlManager.createDropMenu('contextmenu', {\n\t\t\t\toffset_x : p.x + ed.getParam('contextmenu_offset_x', 0),\n\t\t\t\toffset_y : p.y + ed.getParam('contextmenu_offset_y', 0),\n\t\t\t\tconstrain : 1,\n\t\t\t\tkeyboard_focus: true\n\t\t\t});\n\n\t\t\tt._menu = m;\n\n\t\t\tm.add({title : 'advanced.cut_desc', icon : 'cut', cmd : 'Cut'}).setDisabled(col);\n\t\t\tm.add({title : 'advanced.copy_desc', icon : 'copy', cmd : 'Copy'}).setDisabled(col);\n\t\t\tm.add({title : 'advanced.paste_desc', icon : 'paste', cmd : 'Paste'});\n\n\t\t\tif ((el.nodeName == 'A' && !ed.dom.getAttrib(el, 'name')) || !col) {\n\t\t\t\tm.addSeparator();\n\t\t\t\tm.add({title : 'advanced.link_desc', icon : 'link', cmd : ed.plugins.advlink ? 'mceAdvLink' : 'mceLink', ui : true});\n\t\t\t\tm.add({title : 'advanced.unlink_desc', icon : 'unlink', cmd : 'UnLink'});\n\t\t\t}\n\n\t\t\tm.addSeparator();\n\t\t\tm.add({title : 'advanced.image_desc', icon : 'image', cmd : ed.plugins.advimage ? 'mceAdvImage' : 'mceImage', ui : true});\n\n\t\t\tm.addSeparator();\n\t\t\tam = m.addMenu({title : 'contextmenu.align'});\n\t\t\tam.add({title : 'contextmenu.left', icon : 'justifyleft', cmd : 'JustifyLeft'});\n\t\t\tam.add({title : 'contextmenu.center', icon : 'justifycenter', cmd : 'JustifyCenter'});\n\t\t\tam.add({title : 'contextmenu.right', icon : 'justifyright', cmd : 'JustifyRight'});\n\t\t\tam.add({title : 'contextmenu.full', icon : 'justifyfull', cmd : 'JustifyFull'});\n\n\t\t\tt.onContextMenu.dispatch(t, m, el, col);\n\n\t\t\treturn m;\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('contextmenu', tinymce.plugins.ContextMenu);\n})();\n","Magento_Tinymce3/tiny_mce/plugins/fullscreen/editor_plugin.js":"(function(){var a=tinymce.DOM;tinymce.create(\"tinymce.plugins.FullScreenPlugin\",{init:function(d,e){var f=this,g={},c,b;f.editor=d;d.addCommand(\"mceFullScreen\",function(){var i,j=a.doc.documentElement;if(d.getParam(\"fullscreen_is_enabled\")){if(d.getParam(\"fullscreen_new_window\")){closeFullscreen()}else{a.win.setTimeout(function(){tinymce.dom.Event.remove(a.win,\"resize\",f.resizeFunc);tinyMCE.get(d.getParam(\"fullscreen_editor_id\")).setContent(d.getContent());tinyMCE.remove(d);a.remove(\"mce_fullscreen_container\");j.style.overflow=d.getParam(\"fullscreen_html_overflow\");a.setStyle(a.doc.body,\"overflow\",d.getParam(\"fullscreen_overflow\"));a.win.scrollTo(d.getParam(\"fullscreen_scrollx\"),d.getParam(\"fullscreen_scrolly\"));tinyMCE.settings=tinyMCE.oldSettings},10)}return}if(d.getParam(\"fullscreen_new_window\")){i=a.win.open(e+\"/fullscreen.htm\",\"mceFullScreenPopup\",\"fullscreen=yes,menubar=no,toolbar=no,scrollbars=no,resizable=yes,left=0,top=0,width=\"+screen.availWidth+\",height=\"+screen.availHeight);try{i.resizeTo(screen.availWidth,screen.availHeight)}catch(h){}}else{tinyMCE.oldSettings=tinyMCE.settings;g.fullscreen_overflow=a.getStyle(a.doc.body,\"overflow\",1)||\"auto\";g.fullscreen_html_overflow=a.getStyle(j,\"overflow\",1);c=a.getViewPort();g.fullscreen_scrollx=c.x;g.fullscreen_scrolly=c.y;if(tinymce.isOpera&&g.fullscreen_overflow==\"visible\"){g.fullscreen_overflow=\"auto\"}if(tinymce.isIE&&g.fullscreen_overflow==\"scroll\"){g.fullscreen_overflow=\"auto\"}if(tinymce.isIE&&(g.fullscreen_html_overflow==\"visible\"||g.fullscreen_html_overflow==\"scroll\")){g.fullscreen_html_overflow=\"auto\"}if(g.fullscreen_overflow==\"0px\"){g.fullscreen_overflow=\"\"}a.setStyle(a.doc.body,\"overflow\",\"hidden\");j.style.overflow=\"hidden\";c=a.getViewPort();a.win.scrollTo(0,0);if(tinymce.isIE){c.h-=1}if(tinymce.isIE6){b=\"absolute;top:\"+c.y}else{b=\"fixed;top:0\"}n=a.add(a.doc.body,\"div\",{id:\"mce_fullscreen_container\",style:\"position:\"+b+\";left:0;width:\"+c.w+\"px;height:\"+c.h+\"px;z-index:200000;\"});a.add(n,\"div\",{id:\"mce_fullscreen\"});tinymce.each(d.settings,function(k,l){g[l]=k});g.id=\"mce_fullscreen\";g.width=n.clientWidth;g.height=n.clientHeight-15;g.fullscreen_is_enabled=true;g.fullscreen_editor_id=d.id;g.theme_advanced_resizing=false;g.save_onsavecallback=function(){d.setContent(tinyMCE.get(g.id).getContent());d.execCommand(\"mceSave\")};tinymce.each(d.getParam(\"fullscreen_settings\"),function(m,l){g[l]=m});if(g.theme_advanced_toolbar_location===\"external\"){g.theme_advanced_toolbar_location=\"top\"}f.fullscreenEditor=new tinymce.Editor(\"mce_fullscreen\",g);f.fullscreenEditor.onInit.add(function(){f.fullscreenEditor.setContent(d.getContent());f.fullscreenEditor.focus()});f.fullscreenEditor.render();f.fullscreenElement=new tinymce.dom.Element(\"mce_fullscreen_container\");f.fullscreenElement.update();f.resizeFunc=tinymce.dom.Event.add(a.win,\"resize\",function(){var o=tinymce.DOM.getViewPort(),l=f.fullscreenEditor,k,m;k=l.dom.getSize(l.getContainer().firstChild);m=l.dom.getSize(l.getContainer().getElementsByTagName(\"iframe\")[0]);l.theme.resizeTo(o.w-k.w+m.w,o.h-k.h+m.h)})}});d.addButton(\"fullscreen\",{title:\"fullscreen.desc\",cmd:\"mceFullScreen\"});d.onNodeChange.add(function(i,h){h.setActive(\"fullscreen\",i.getParam(\"fullscreen_is_enabled\"))})},getInfo:function(){return{longname:\"Fullscreen\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/fullscreen\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"fullscreen\",tinymce.plugins.FullScreenPlugin)})();","Magento_Tinymce3/tiny_mce/plugins/fullscreen/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\tvar DOM = tinymce.DOM;\n\n\ttinymce.create('tinymce.plugins.FullScreenPlugin', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this, s = {}, vp, posCss;\n\n\t\t\tt.editor = ed;\n\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceFullScreen', function() {\n\t\t\t\tvar win, de = DOM.doc.documentElement;\n\n\t\t\t\tif (ed.getParam('fullscreen_is_enabled')) {\n\t\t\t\t\tif (ed.getParam('fullscreen_new_window'))\n\t\t\t\t\t\tcloseFullscreen(); // Call to close in new window\n\t\t\t\t\telse {\n\t\t\t\t\t\tDOM.win.setTimeout(function() {\n\t\t\t\t\t\t\ttinymce.dom.Event.remove(DOM.win, 'resize', t.resizeFunc);\n\t\t\t\t\t\t\ttinyMCE.get(ed.getParam('fullscreen_editor_id')).setContent(ed.getContent());\n\t\t\t\t\t\t\ttinyMCE.remove(ed);\n\t\t\t\t\t\t\tDOM.remove('mce_fullscreen_container');\n\t\t\t\t\t\t\tde.style.overflow = ed.getParam('fullscreen_html_overflow');\n\t\t\t\t\t\t\tDOM.setStyle(DOM.doc.body, 'overflow', ed.getParam('fullscreen_overflow'));\n\t\t\t\t\t\t\tDOM.win.scrollTo(ed.getParam('fullscreen_scrollx'), ed.getParam('fullscreen_scrolly'));\n\t\t\t\t\t\t\ttinyMCE.settings = tinyMCE.oldSettings; // Restore old settings\n\t\t\t\t\t\t}, 10);\n\t\t\t\t\t}\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (ed.getParam('fullscreen_new_window')) {\n\t\t\t\t\twin = DOM.win.open(url + \"/fullscreen.htm\", \"mceFullScreenPopup\", \"fullscreen=yes,menubar=no,toolbar=no,scrollbars=no,resizable=yes,left=0,top=0,width=\" + screen.availWidth + \",height=\" + screen.availHeight);\n\t\t\t\t\ttry {\n\t\t\t\t\t\twin.resizeTo(screen.availWidth, screen.availHeight);\n\t\t\t\t\t} catch (e) {\n\t\t\t\t\t\t// Ignore\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\ttinyMCE.oldSettings = tinyMCE.settings; // Store old settings\n\t\t\t\t\ts.fullscreen_overflow = DOM.getStyle(DOM.doc.body, 'overflow', 1) || 'auto';\n\t\t\t\t\ts.fullscreen_html_overflow = DOM.getStyle(de, 'overflow', 1);\n\t\t\t\t\tvp = DOM.getViewPort();\n\t\t\t\t\ts.fullscreen_scrollx = vp.x;\n\t\t\t\t\ts.fullscreen_scrolly = vp.y;\n\n\t\t\t\t\t// Fixes an Opera bug where the scrollbars doesn't reappear\n\t\t\t\t\tif (tinymce.isOpera && s.fullscreen_overflow == 'visible')\n\t\t\t\t\t\ts.fullscreen_overflow = 'auto';\n\n\t\t\t\t\t// Fixes an IE bug where horizontal scrollbars would appear\n\t\t\t\t\tif (tinymce.isIE && s.fullscreen_overflow == 'scroll')\n\t\t\t\t\t\ts.fullscreen_overflow = 'auto';\n\n\t\t\t\t\t// Fixes an IE bug where the scrollbars doesn't reappear\n\t\t\t\t\tif (tinymce.isIE && (s.fullscreen_html_overflow == 'visible' || s.fullscreen_html_overflow == 'scroll'))\n\t\t\t\t\t\ts.fullscreen_html_overflow = 'auto'; \n\n\t\t\t\t\tif (s.fullscreen_overflow == '0px')\n\t\t\t\t\t\ts.fullscreen_overflow = '';\n\n\t\t\t\t\tDOM.setStyle(DOM.doc.body, 'overflow', 'hidden');\n\t\t\t\t\tde.style.overflow = 'hidden'; //Fix for IE6/7\n\t\t\t\t\tvp = DOM.getViewPort();\n\t\t\t\t\tDOM.win.scrollTo(0, 0);\n\n\t\t\t\t\tif (tinymce.isIE)\n\t\t\t\t\t\tvp.h -= 1;\n\n\t\t\t\t\t// Use fixed position if it exists\n\t\t\t\t\tif (tinymce.isIE6)\n\t\t\t\t\t\tposCss = 'absolute;top:' + vp.y;\n\t\t\t\t\telse\n\t\t\t\t\t\tposCss = 'fixed;top:0';\n\n\t\t\t\t\tn = DOM.add(DOM.doc.body, 'div', {\n\t\t\t\t\t\tid : 'mce_fullscreen_container', \n\t\t\t\t\t\tstyle : 'position:' + posCss + ';left:0;width:' + vp.w + 'px;height:' + vp.h + 'px;z-index:200000;'});\n\t\t\t\t\tDOM.add(n, 'div', {id : 'mce_fullscreen'});\n\n\t\t\t\t\ttinymce.each(ed.settings, function(v, n) {\n\t\t\t\t\t\ts[n] = v;\n\t\t\t\t\t});\n\n\t\t\t\t\ts.id = 'mce_fullscreen';\n\t\t\t\t\ts.width = n.clientWidth;\n\t\t\t\t\ts.height = n.clientHeight - 15;\n\t\t\t\t\ts.fullscreen_is_enabled = true;\n\t\t\t\t\ts.fullscreen_editor_id = ed.id;\n\t\t\t\t\ts.theme_advanced_resizing = false;\n\t\t\t\t\ts.save_onsavecallback = function() {\n\t\t\t\t\t\ted.setContent(tinyMCE.get(s.id).getContent());\n\t\t\t\t\t\ted.execCommand('mceSave');\n\t\t\t\t\t};\n\n\t\t\t\t\ttinymce.each(ed.getParam('fullscreen_settings'), function(v, k) {\n\t\t\t\t\t\ts[k] = v;\n\t\t\t\t\t});\n\n\t\t\t\t\tif (s.theme_advanced_toolbar_location === 'external')\n\t\t\t\t\t\ts.theme_advanced_toolbar_location = 'top';\n\n\t\t\t\t\tt.fullscreenEditor = new tinymce.Editor('mce_fullscreen', s);\n\t\t\t\t\tt.fullscreenEditor.onInit.add(function() {\n\t\t\t\t\t\tt.fullscreenEditor.setContent(ed.getContent());\n\t\t\t\t\t\tt.fullscreenEditor.focus();\n\t\t\t\t\t});\n\n\t\t\t\t\tt.fullscreenEditor.render();\n\n\t\t\t\t\tt.fullscreenElement = new tinymce.dom.Element('mce_fullscreen_container');\n\t\t\t\t\tt.fullscreenElement.update();\n\t\t\t\t\t//document.body.overflow = 'hidden';\n\n\t\t\t\t\tt.resizeFunc = tinymce.dom.Event.add(DOM.win, 'resize', function() {\n\t\t\t\t\t\tvar vp = tinymce.DOM.getViewPort(), fed = t.fullscreenEditor, outerSize, innerSize;\n\n\t\t\t\t\t\t// Get outer/inner size to get a delta size that can be used to calc the new iframe size\n\t\t\t\t\t\touterSize = fed.dom.getSize(fed.getContainer().firstChild);\n\t\t\t\t\t\tinnerSize = fed.dom.getSize(fed.getContainer().getElementsByTagName('iframe')[0]);\n\n\t\t\t\t\t\tfed.theme.resizeTo(vp.w - outerSize.w + innerSize.w, vp.h - outerSize.h + innerSize.h);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('fullscreen', {title : 'fullscreen.desc', cmd : 'mceFullScreen'});\n\n\t\t\ted.onNodeChange.add(function(ed, cm) {\n\t\t\t\tcm.setActive('fullscreen', ed.getParam('fullscreen_is_enabled'));\n\t\t\t});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Fullscreen',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/fullscreen',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('fullscreen', tinymce.plugins.FullScreenPlugin);\n})();","Magento_Tinymce3/tiny_mce/plugins/inlinepopups/editor_plugin.js":"(function(){var d=tinymce.DOM,b=tinymce.dom.Element,a=tinymce.dom.Event,e=tinymce.each,c=tinymce.is;tinymce.create(\"tinymce.plugins.InlinePopups\",{init:function(f,g){f.onBeforeRenderUI.add(function(){f.windowManager=new tinymce.InlineWindowManager(f);d.loadCSS(g+\"/skins/\"+(f.settings.inlinepopups_skin||\"clearlooks2\")+\"/window.css\")})},getInfo:function(){return{longname:\"InlinePopups\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/inlinepopups\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.create(\"tinymce.InlineWindowManager:tinymce.WindowManager\",{InlineWindowManager:function(f){var g=this;g.parent(f);g.zIndex=1000;g.count=0;g.windows={}},open:function(s,j){var z=this,i,k=\"\",r=z.editor,g=0,v=0,h,m,o,q,l,x,y,n;s=s||{};j=j||{};if(!s.inline){return z.parent(s,j)}n=z._frontWindow();if(n&&d.get(n.id+\"_ifr\")){n.focussedElement=d.get(n.id+\"_ifr\").contentWindow.document.activeElement}if(!s.type){z.bookmark=r.selection.getBookmark(1)}i=d.uniqueId();h=d.getViewPort();s.width=parseInt(s.width||320);s.height=parseInt(s.height||240)+(tinymce.isIE?8:0);s.min_width=parseInt(s.min_width||150);s.min_height=parseInt(s.min_height||100);s.max_width=parseInt(s.max_width||2000);s.max_height=parseInt(s.max_height||2000);s.left=s.left||Math.round(Math.max(h.x,h.x+(h.w/2)-(s.width/2)));s.top=s.top||Math.round(Math.max(h.y,h.y+(h.h/2)-(s.height/2)));s.movable=s.resizable=true;j.mce_width=s.width;j.mce_height=s.height;j.mce_inline=true;j.mce_window_id=i;j.mce_auto_focus=s.auto_focus;z.features=s;z.params=j;z.onOpen.dispatch(z,s,j);if(s.type){k+=\" mceModal\";if(s.type){k+=\" mce\"+s.type.substring(0,1).toUpperCase()+s.type.substring(1)}s.resizable=false}if(s.statusbar){k+=\" mceStatusbar\"}if(s.resizable){k+=\" mceResizable\"}if(s.minimizable){k+=\" mceMinimizable\"}if(s.maximizable){k+=\" mceMaximizable\"}if(s.movable){k+=\" mceMovable\"}z._addAll(d.doc.body,[\"div\",{id:i,role:\"dialog\",\"aria-labelledby\":s.type?i+\"_content\":i+\"_title\",\"class\":(r.settings.inlinepopups_skin||\"clearlooks2\")+(tinymce.isIE&&window.getSelection?\" ie9\":\"\"),style:\"width:100px;height:100px\"},[\"div\",{id:i+\"_wrapper\",\"class\":\"mceWrapper\"+k},[\"div\",{id:i+\"_top\",\"class\":\"mceTop\"},[\"div\",{\"class\":\"mceLeft\"}],[\"div\",{\"class\":\"mceCenter\"}],[\"div\",{\"class\":\"mceRight\"}],[\"span\",{id:i+\"_title\"},s.title||\"\"]],[\"div\",{id:i+\"_middle\",\"class\":\"mceMiddle\"},[\"div\",{id:i+\"_left\",\"class\":\"mceLeft\",tabindex:\"0\"}],[\"span\",{id:i+\"_content\"}],[\"div\",{id:i+\"_right\",\"class\":\"mceRight\",tabindex:\"0\"}]],[\"div\",{id:i+\"_bottom\",\"class\":\"mceBottom\"},[\"div\",{\"class\":\"mceLeft\"}],[\"div\",{\"class\":\"mceCenter\"}],[\"div\",{\"class\":\"mceRight\"}],[\"span\",{id:i+\"_status\"},\"Content\"]],[\"a\",{\"class\":\"mceMove\",tabindex:\"-1\",href:\"javascript:;\"}],[\"a\",{\"class\":\"mceMin\",tabindex:\"-1\",href:\"javascript:;\",onmousedown:\"return false;\"}],[\"a\",{\"class\":\"mceMax\",tabindex:\"-1\",href:\"javascript:;\",onmousedown:\"return false;\"}],[\"a\",{\"class\":\"mceMed\",tabindex:\"-1\",href:\"javascript:;\",onmousedown:\"return false;\"}],[\"a\",{\"class\":\"mceClose\",tabindex:\"-1\",href:\"javascript:;\",onmousedown:\"return false;\"}],[\"a\",{id:i+\"_resize_n\",\"class\":\"mceResize mceResizeN\",tabindex:\"-1\",href:\"javascript:;\"}],[\"a\",{id:i+\"_resize_s\",\"class\":\"mceResize mceResizeS\",tabindex:\"-1\",href:\"javascript:;\"}],[\"a\",{id:i+\"_resize_w\",\"class\":\"mceResize mceResizeW\",tabindex:\"-1\",href:\"javascript:;\"}],[\"a\",{id:i+\"_resize_e\",\"class\":\"mceResize mceResizeE\",tabindex:\"-1\",href:\"javascript:;\"}],[\"a\",{id:i+\"_resize_nw\",\"class\":\"mceResize mceResizeNW\",tabindex:\"-1\",href:\"javascript:;\"}],[\"a\",{id:i+\"_resize_ne\",\"class\":\"mceResize mceResizeNE\",tabindex:\"-1\",href:\"javascript:;\"}],[\"a\",{id:i+\"_resize_sw\",\"class\":\"mceResize mceResizeSW\",tabindex:\"-1\",href:\"javascript:;\"}],[\"a\",{id:i+\"_resize_se\",\"class\":\"mceResize mceResizeSE\",tabindex:\"-1\",href:\"javascript:;\"}]]]);d.setStyles(i,{top:-10000,left:-10000});if(tinymce.isGecko){d.setStyle(i,\"overflow\",\"auto\")}if(!s.type){g+=d.get(i+\"_left\").clientWidth;g+=d.get(i+\"_right\").clientWidth;v+=d.get(i+\"_top\").clientHeight;v+=d.get(i+\"_bottom\").clientHeight}d.setStyles(i,{top:s.top,left:s.left,width:s.width+g,height:s.height+v});y=s.url||s.file;if(y){if(tinymce.relaxedDomain){y+=(y.indexOf(\"?\")==-1?\"?\":\"&\")+\"mce_rdomain=\"+tinymce.relaxedDomain}y=tinymce._addVer(y)}if(!s.type){d.add(i+\"_content\",\"iframe\",{id:i+\"_ifr\",src:'javascript:\"\"',frameBorder:0,style:\"border:0;width:10px;height:10px\"});d.setStyles(i+\"_ifr\",{width:s.width,height:s.height});d.setAttrib(i+\"_ifr\",\"src\",y)}else{d.add(i+\"_wrapper\",\"a\",{id:i+\"_ok\",\"class\":\"mceButton mceOk\",href:\"javascript:;\",onmousedown:\"return false;\"},\"Ok\");if(s.type==\"confirm\"){d.add(i+\"_wrapper\",\"a\",{\"class\":\"mceButton mceCancel\",href:\"javascript:;\",onmousedown:\"return false;\"},\"Cancel\")}d.add(i+\"_middle\",\"div\",{\"class\":\"mceIcon\"});d.setHTML(i+\"_content\",s.content.replace(\"\\n\",\"<br />\"));a.add(i,\"keyup\",function(f){var p=27;if(f.keyCode===p){s.button_func(false);return a.cancel(f)}});a.add(i,\"keydown\",function(f){var t,p=9;if(f.keyCode===p){t=d.select(\"a.mceCancel\",i+\"_wrapper\")[0];if(t&&t!==f.target){t.focus()}else{d.get(i+\"_ok\").focus()}return a.cancel(f)}})}o=a.add(i,\"mousedown\",function(t){var u=t.target,f,p;f=z.windows[i];z.focus(i);if(u.nodeName==\"A\"||u.nodeName==\"a\"){if(u.className==\"mceClose\"){z.close(null,i);return a.cancel(t)}else{if(u.className==\"mceMax\"){f.oldPos=f.element.getXY();f.oldSize=f.element.getSize();p=d.getViewPort();p.w-=2;p.h-=2;f.element.moveTo(p.x,p.y);f.element.resizeTo(p.w,p.h);d.setStyles(i+\"_ifr\",{width:p.w-f.deltaWidth,height:p.h-f.deltaHeight});d.addClass(i+\"_wrapper\",\"mceMaximized\")}else{if(u.className==\"mceMed\"){f.element.moveTo(f.oldPos.x,f.oldPos.y);f.element.resizeTo(f.oldSize.w,f.oldSize.h);f.iframeElement.resizeTo(f.oldSize.w-f.deltaWidth,f.oldSize.h-f.deltaHeight);d.removeClass(i+\"_wrapper\",\"mceMaximized\")}else{if(u.className==\"mceMove\"){return z._startDrag(i,t,u.className)}else{if(d.hasClass(u,\"mceResize\")){return z._startDrag(i,t,u.className.substring(13))}}}}}}});q=a.add(i,\"click\",function(f){var p=f.target;z.focus(i);if(p.nodeName==\"A\"||p.nodeName==\"a\"){switch(p.className){case\"mceClose\":z.close(null,i);return a.cancel(f);case\"mceButton mceOk\":case\"mceButton mceCancel\":s.button_func(p.className==\"mceButton mceOk\");return a.cancel(f)}}});a.add([i+\"_left\",i+\"_right\"],\"focus\",function(p){var t=d.get(i+\"_ifr\");if(t){var f=t.contentWindow.document.body;var u=d.select(\":input:enabled,*[tabindex=0]\",f);if(p.target.id===(i+\"_left\")){u[u.length-1].focus()}else{u[0].focus()}}else{d.get(i+\"_ok\").focus()}});x=z.windows[i]={id:i,mousedown_func:o,click_func:q,element:new b(i,{blocker:1,container:r.getContainer()}),iframeElement:new b(i+\"_ifr\"),features:s,deltaWidth:g,deltaHeight:v};x.iframeElement.on(\"focus\",function(){z.focus(i)});if(z.count==0&&z.editor.getParam(\"dialog_type\",\"modal\")==\"modal\"){d.add(d.doc.body,\"div\",{id:\"mceModalBlocker\",\"class\":(z.editor.settings.inlinepopups_skin||\"clearlooks2\")+\"_modalBlocker\",style:{zIndex:z.zIndex-1}});d.show(\"mceModalBlocker\");d.setAttrib(d.doc.body,\"aria-hidden\",\"true\")}else{d.setStyle(\"mceModalBlocker\",\"z-index\",z.zIndex-1)}if(tinymce.isIE6||/Firefox\\/2\\./.test(navigator.userAgent)||(tinymce.isIE&&!d.boxModel)){d.setStyles(\"mceModalBlocker\",{position:\"absolute\",left:h.x,top:h.y,width:h.w-2,height:h.h-2})}d.setAttrib(i,\"aria-hidden\",\"false\");z.focus(i);z._fixIELayout(i,1);if(d.get(i+\"_ok\")){d.get(i+\"_ok\").focus()}z.count++;return x},focus:function(h){var g=this,f;if(f=g.windows[h]){f.zIndex=this.zIndex++;f.element.setStyle(\"zIndex\",f.zIndex);f.element.update();h=h+\"_wrapper\";d.removeClass(g.lastId,\"mceFocus\");d.addClass(h,\"mceFocus\");g.lastId=h;if(f.focussedElement){f.focussedElement.focus()}else{if(d.get(h+\"_ok\")){d.get(f.id+\"_ok\").focus()}else{if(d.get(f.id+\"_ifr\")){d.get(f.id+\"_ifr\").focus()}}}}},_addAll:function(k,h){var g,l,f=this,j=tinymce.DOM;if(c(h,\"string\")){k.appendChild(j.doc.createTextNode(h))}else{if(h.length){k=k.appendChild(j.create(h[0],h[1]));for(g=2;g<h.length;g++){f._addAll(k,h[g])}}}},_startDrag:function(v,G,E){var o=this,u,z,C=d.doc,f,l=o.windows[v],h=l.element,y=h.getXY(),x,q,F,g,A,s,r,j,i,m,k,n,B;g={x:0,y:0};A=d.getViewPort();A.w-=2;A.h-=2;j=G.screenX;i=G.screenY;m=k=n=B=0;u=a.add(C,\"mouseup\",function(p){a.remove(C,\"mouseup\",u);a.remove(C,\"mousemove\",z);if(f){f.remove()}h.moveBy(m,k);h.resizeBy(n,B);q=h.getSize();d.setStyles(v+\"_ifr\",{width:q.w-l.deltaWidth,height:q.h-l.deltaHeight});o._fixIELayout(v,1);return a.cancel(p)});if(E!=\"Move\"){D()}function D(){if(f){return}o._fixIELayout(v,0);d.add(C.body,\"div\",{id:\"mceEventBlocker\",\"class\":\"mceEventBlocker \"+(o.editor.settings.inlinepopups_skin||\"clearlooks2\"),style:{zIndex:o.zIndex+1}});if(tinymce.isIE6||(tinymce.isIE&&!d.boxModel)){d.setStyles(\"mceEventBlocker\",{position:\"absolute\",left:A.x,top:A.y,width:A.w-2,height:A.h-2})}f=new b(\"mceEventBlocker\");f.update();x=h.getXY();q=h.getSize();s=g.x+x.x-A.x;r=g.y+x.y-A.y;d.add(f.get(),\"div\",{id:\"mcePlaceHolder\",\"class\":\"mcePlaceHolder\",style:{left:s,top:r,width:q.w,height:q.h}});F=new b(\"mcePlaceHolder\")}z=a.add(C,\"mousemove\",function(w){var p,H,t;D();p=w.screenX-j;H=w.screenY-i;switch(E){case\"ResizeW\":m=p;n=0-p;break;case\"ResizeE\":n=p;break;case\"ResizeN\":case\"ResizeNW\":case\"ResizeNE\":if(E==\"ResizeNW\"){m=p;n=0-p}else{if(E==\"ResizeNE\"){n=p}}k=H;B=0-H;break;case\"ResizeS\":case\"ResizeSW\":case\"ResizeSE\":if(E==\"ResizeSW\"){m=p;n=0-p}else{if(E==\"ResizeSE\"){n=p}}B=H;break;case\"mceMove\":m=p;k=H;break}if(n<(t=l.features.min_width-q.w)){if(m!==0){m+=n-t}n=t}if(B<(t=l.features.min_height-q.h)){if(k!==0){k+=B-t}B=t}n=Math.min(n,l.features.max_width-q.w);B=Math.min(B,l.features.max_height-q.h);m=Math.max(m,A.x-(s+A.x));k=Math.max(k,A.y-(r+A.y));m=Math.min(m,(A.w+A.x)-(s+q.w+A.x));k=Math.min(k,(A.h+A.y)-(r+q.h+A.y));if(m+k!==0){if(s+m<0){m=0}if(r+k<0){k=0}F.moveTo(s+m,r+k)}if(n+B!==0){F.resizeTo(q.w+n,q.h+B)}return a.cancel(w)});return a.cancel(G)},resizeBy:function(g,h,i){var f=this.windows[i];if(f){f.element.resizeBy(g,h);f.iframeElement.resizeBy(g,h)}},close:function(i,k){var g=this,f,j=d.doc,h,k;k=g._findId(k||i);if(!g.windows[k]){g.parent(i);return}g.count--;if(g.count==0){d.remove(\"mceModalBlocker\");d.setAttrib(d.doc.body,\"aria-hidden\",\"false\");g.editor.focus()}if(f=g.windows[k]){g.onClose.dispatch(g);a.remove(j,\"mousedown\",f.mousedownFunc);a.remove(j,\"click\",f.clickFunc);a.clear(k);a.clear(k+\"_ifr\");d.setAttrib(k+\"_ifr\",\"src\",'javascript:\"\"');f.element.remove();delete g.windows[k];h=g._frontWindow();if(h){g.focus(h.id)}}},_frontWindow:function(){var g,f=0;e(this.windows,function(h){if(h.zIndex>f){g=h;f=h.zIndex}});return g},setTitle:function(f,g){var h;f=this._findId(f);if(h=d.get(f+\"_title\")){h.innerHTML=d.encode(g)}},alert:function(g,f,j){var i=this,h;h=i.open({title:i,type:\"alert\",button_func:function(k){if(f){f.call(k||i,k)}i.close(null,h.id)},content:d.encode(i.editor.getLang(g,g)),inline:1,width:400,height:130})},confirm:function(g,f,j){var i=this,h;h=i.open({title:i,type:\"confirm\",button_func:function(k){if(f){f.call(k||i,k)}i.close(null,h.id)},content:d.encode(i.editor.getLang(g,g)),inline:1,width:400,height:130})},_findId:function(f){var g=this;if(typeof(f)==\"string\"){return f}e(g.windows,function(h){var i=d.get(h.id+\"_ifr\");if(i&&f==i.contentWindow){f=h.id;return false}});return f},_fixIELayout:function(i,h){var f,g;if(!tinymce.isIE6){return}e([\"n\",\"s\",\"w\",\"e\",\"nw\",\"ne\",\"sw\",\"se\"],function(j){var k=d.get(i+\"_resize_\"+j);d.setStyles(k,{width:h?k.clientWidth:\"\",height:h?k.clientHeight:\"\",cursor:d.getStyle(k,\"cursor\",1)});d.setStyle(i+\"_bottom\",\"bottom\",\"-1px\");k=0});if(f=this.windows[i]){f.element.hide();f.element.show();e(d.select(\"div,a\",i),function(k,j){if(k.currentStyle.backgroundImage!=\"none\"){g=new Image();g.src=k.currentStyle.backgroundImage.replace(/url\\(\\\"(.+)\\\"\\)/,\"$1\")}});d.get(i).style.filter=\"\"}}});tinymce.PluginManager.add(\"inlinepopups\",tinymce.plugins.InlinePopups)})();","Magento_Tinymce3/tiny_mce/plugins/inlinepopups/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\tvar DOM = tinymce.DOM, Element = tinymce.dom.Element, Event = tinymce.dom.Event, each = tinymce.each, is = tinymce.is;\n\n\ttinymce.create('tinymce.plugins.InlinePopups', {\n\t\tinit : function(ed, url) {\n\t\t\t// Replace window manager\n\t\t\ted.onBeforeRenderUI.add(function() {\n\t\t\t\ted.windowManager = new tinymce.InlineWindowManager(ed);\n\t\t\t\tDOM.loadCSS(url + '/skins/' + (ed.settings.inlinepopups_skin || 'clearlooks2') + \"/window.css\");\n\t\t\t});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'InlinePopups',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/inlinepopups',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\ttinymce.create('tinymce.InlineWindowManager:tinymce.WindowManager', {\n\t\tInlineWindowManager : function(ed) {\n\t\t\tvar t = this;\n\n\t\t\tt.parent(ed);\n\t\t\tt.zIndex = t.getMaxZIndex();\n\t\t\tt.count = 0;\n\t\t\tt.windows = {};\n\t\t},\n\n\t\topen : function(f, p) {\n\t\t\tvar t = this, id, opt = '', ed = t.editor, dw = 0, dh = 0, vp, po, mdf, clf, we, w, u, parentWindow;\n\n\t\t\tf = f || {};\n\t\t\tp = p || {};\n\n\t\t\t// Run native windows\n\t\t\tif (!f.inline)\n\t\t\t\treturn t.parent(f, p);\n\n\t\t\tparentWindow = t._frontWindow();\n\t\t\tif (parentWindow && DOM.get(parentWindow.id + '_ifr')) {\n\t\t\t\tparentWindow.focussedElement = DOM.get(parentWindow.id + '_ifr').contentWindow.document.activeElement;\n\t\t\t}\n\n\t\t\t// Only store selection if the type is a normal window\n\t\t\tif (!f.type)\n\t\t\t\tt.bookmark = ed.selection.getBookmark(1);\n\n\t\t\tid = DOM.uniqueId();\n\t\t\tvp = DOM.getViewPort();\n\t\t\tf.width = parseInt(f.width || 320);\n\t\t\tf.height = parseInt(f.height || 240) + (tinymce.isIE ? 8 : 0);\n\t\t\tf.min_width = parseInt(f.min_width || 150);\n\t\t\tf.min_height = parseInt(f.min_height || 100);\n\t\t\tf.max_width = parseInt(f.max_width || 2000);\n\t\t\tf.max_height = parseInt(f.max_height || 2000);\n\t\t\tf.left = f.left || Math.round(Math.max(vp.x, vp.x + (vp.w / 2.0) - (f.width / 2.0)));\n\t\t\tf.top = f.top || Math.round(Math.max(vp.y, vp.y + (vp.h / 2.0) - (f.height / 2.0)));\n\t\t\tf.movable = f.resizable = true;\n\t\t\tp.mce_width = f.width;\n\t\t\tp.mce_height = f.height;\n\t\t\tp.mce_inline = true;\n\t\t\tp.mce_window_id = id;\n\t\t\tp.mce_auto_focus = f.auto_focus;\n\n\t\t\t// Transpose\n//\t\t\tpo = DOM.getPos(ed.getContainer());\n//\t\t\tf.left -= po.x;\n//\t\t\tf.top -= po.y;\n\n\t\t\tt.features = f;\n\t\t\tt.params = p;\n\t\t\tt.onOpen.dispatch(t, f, p);\n\n\t\t\tif (f.type) {\n\t\t\t\topt += ' mceModal';\n\n\t\t\t\tif (f.type)\n\t\t\t\t\topt += ' mce' + f.type.substring(0, 1).toUpperCase() + f.type.substring(1);\n\n\t\t\t\tf.resizable = false;\n\t\t\t}\n\n\t\t\tif (f.statusbar)\n\t\t\t\topt += ' mceStatusbar';\n\n\t\t\tif (f.resizable)\n\t\t\t\topt += ' mceResizable';\n\n\t\t\tif (f.minimizable)\n\t\t\t\topt += ' mceMinimizable';\n\n\t\t\tif (f.maximizable)\n\t\t\t\topt += ' mceMaximizable';\n\n\t\t\tif (f.movable)\n\t\t\t\topt += ' mceMovable';\n\n\t\t\t// Create DOM objects\n\t\t\tt._addAll(DOM.doc.body,\n\t\t\t\t['div', {id : id, role : 'dialog', 'aria-labelledby': f.type ? id + '_content' : id + '_title', 'class' : (ed.settings.inlinepopups_skin || 'clearlooks2') + (tinymce.isIE && window.getSelection ? ' ie9' : ''), style : 'width:100px;height:100px'},\n\t\t\t\t\t['div', {id : id + '_wrapper', 'class' : 'mceWrapper' + opt},\n\t\t\t\t\t\t['div', {id : id + '_top', 'class' : 'mceTop'},\n\t\t\t\t\t\t\t['div', {'class' : 'mceLeft'}],\n\t\t\t\t\t\t\t['div', {'class' : 'mceCenter'}],\n\t\t\t\t\t\t\t['div', {'class' : 'mceRight'}],\n\t\t\t\t\t\t\t['span', {id : id + '_title'}, f.title || '']\n\t\t\t\t\t\t],\n\n\t\t\t\t\t\t['div', {id : id + '_middle', 'class' : 'mceMiddle'},\n\t\t\t\t\t\t\t['div', {id : id + '_left', 'class' : 'mceLeft', tabindex : '0'}],\n\t\t\t\t\t\t\t['span', {id : id + '_content'}],\n\t\t\t\t\t\t\t['div', {id : id + '_right', 'class' : 'mceRight', tabindex : '0'}]\n\t\t\t\t\t\t],\n\n\t\t\t\t\t\t['div', {id : id + '_bottom', 'class' : 'mceBottom'},\n\t\t\t\t\t\t\t['div', {'class' : 'mceLeft'}],\n\t\t\t\t\t\t\t['div', {'class' : 'mceCenter'}],\n\t\t\t\t\t\t\t['div', {'class' : 'mceRight'}],\n\t\t\t\t\t\t\t['span', {id : id + '_status'}, 'Content']\n\t\t\t\t\t\t],\n\n\t\t\t\t\t\t['a', {'class' : 'mceMove', tabindex : '-1', href : 'javascript:;'}],\n\t\t\t\t\t\t['a', {'class' : 'mceMin', tabindex : '-1', href : 'javascript:;', onmousedown : 'return false;'}],\n\t\t\t\t\t\t['a', {'class' : 'mceMax', tabindex : '-1', href : 'javascript:;', onmousedown : 'return false;'}],\n\t\t\t\t\t\t['a', {'class' : 'mceMed', tabindex : '-1', href : 'javascript:;', onmousedown : 'return false;'}],\n\t\t\t\t\t\t['a', {'class' : 'mceClose', tabindex : '-1', href : 'javascript:;', onmousedown : 'return false;'}],\n\t\t\t\t\t\t['a', {id : id + '_resize_n', 'class' : 'mceResize mceResizeN', tabindex : '-1', href : 'javascript:;'}],\n\t\t\t\t\t\t['a', {id : id + '_resize_s', 'class' : 'mceResize mceResizeS', tabindex : '-1', href : 'javascript:;'}],\n\t\t\t\t\t\t['a', {id : id + '_resize_w', 'class' : 'mceResize mceResizeW', tabindex : '-1', href : 'javascript:;'}],\n\t\t\t\t\t\t['a', {id : id + '_resize_e', 'class' : 'mceResize mceResizeE', tabindex : '-1', href : 'javascript:;'}],\n\t\t\t\t\t\t['a', {id : id + '_resize_nw', 'class' : 'mceResize mceResizeNW', tabindex : '-1', href : 'javascript:;'}],\n\t\t\t\t\t\t['a', {id : id + '_resize_ne', 'class' : 'mceResize mceResizeNE', tabindex : '-1', href : 'javascript:;'}],\n\t\t\t\t\t\t['a', {id : id + '_resize_sw', 'class' : 'mceResize mceResizeSW', tabindex : '-1', href : 'javascript:;'}],\n\t\t\t\t\t\t['a', {id : id + '_resize_se', 'class' : 'mceResize mceResizeSE', tabindex : '-1', href : 'javascript:;'}]\n\t\t\t\t\t]\n\t\t\t\t]\n\t\t\t);\n\n\t\t\tDOM.setStyles(id, {top : -10000, left : -10000});\n\n\t\t\t// Fix gecko rendering bug, where the editors iframe messed with window contents\n\t\t\tif (tinymce.isGecko)\n\t\t\t\tDOM.setStyle(id, 'overflow', 'auto');\n\n\t\t\t// Measure borders\n\t\t\tif (!f.type) {\n\t\t\t\tdw += DOM.get(id + '_left').clientWidth;\n\t\t\t\tdw += DOM.get(id + '_right').clientWidth;\n\t\t\t\tdh += DOM.get(id + '_top').clientHeight;\n\t\t\t\tdh += DOM.get(id + '_bottom').clientHeight;\n\t\t\t}\n\n\t\t\t// Resize window\n\t\t\tDOM.setStyles(id, {top : f.top, left : f.left, width : f.width + dw, height : f.height + dh});\n\n\t\t\tu = f.url || f.file;\n\t\t\tif (u) {\n\t\t\t\tif (tinymce.relaxedDomain)\n\t\t\t\t\tu += (u.indexOf('?') == -1 ? '?' : '&') + 'mce_rdomain=' + tinymce.relaxedDomain;\n\n\t\t\t\tu = tinymce._addVer(u);\n\t\t\t}\n\n\t\t\tif (!f.type) {\n\t\t\t\tDOM.add(id + '_content', 'iframe', {id : id + '_ifr', src : 'javascript:\"\"', frameBorder : 0, style : 'border:0;width:10px;height:10px'});\n\t\t\t\tDOM.setStyles(id + '_ifr', {width : f.width, height : f.height});\n\t\t\t\tDOM.setAttrib(id + '_ifr', 'src', u);\n\t\t\t} else {\n\t\t\t\tDOM.add(id + '_wrapper', 'a', {id : id + '_ok', 'class' : 'mceButton mceOk', href : 'javascript:;', onmousedown : 'return false;'}, 'Ok');\n\n\t\t\t\tif (f.type == 'confirm')\n\t\t\t\t\tDOM.add(id + '_wrapper', 'a', {'class' : 'mceButton mceCancel', href : 'javascript:;', onmousedown : 'return false;'}, 'Cancel');\n\n\t\t\t\tDOM.add(id + '_middle', 'div', {'class' : 'mceIcon'});\n\t\t\t\tDOM.setHTML(id + '_content', f.content.replace('\\n', '<br />'));\n\n\t\t\t\tEvent.add(id, 'keyup', function(evt) {\n\t\t\t\t\tvar VK_ESCAPE = 27;\n\t\t\t\t\tif (evt.keyCode === VK_ESCAPE) {\n\t\t\t\t\t\tf.button_func(false);\n\t\t\t\t\t\treturn Event.cancel(evt);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tEvent.add(id, 'keydown', function(evt) {\n\t\t\t\t\tvar cancelButton, VK_TAB = 9;\n\t\t\t\t\tif (evt.keyCode === VK_TAB) {\n\t\t\t\t\t\tcancelButton = DOM.select('a.mceCancel', id + '_wrapper')[0];\n\t\t\t\t\t\tif (cancelButton && cancelButton !== evt.target) {\n\t\t\t\t\t\t\tcancelButton.focus();\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tDOM.get(id + '_ok').focus();\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn Event.cancel(evt);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Register events\n\t\t\tmdf = Event.add(id, 'mousedown', function(e) {\n\t\t\t\tvar n = e.target, w, vp;\n\n\t\t\t\tw = t.windows[id];\n\t\t\t\tt.focus(id);\n\n\t\t\t\tif (n.nodeName == 'A' || n.nodeName == 'a') {\n\t\t\t\t\tif (n.className == 'mceClose') {\n\t\t\t\t\t\tt.close(null, id);\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t} else if (n.className == 'mceMax') {\n\t\t\t\t\t\tw.oldPos = w.element.getXY();\n\t\t\t\t\t\tw.oldSize = w.element.getSize();\n\n\t\t\t\t\t\tvp = DOM.getViewPort();\n\n\t\t\t\t\t\t// Reduce viewport size to avoid scrollbars\n\t\t\t\t\t\tvp.w -= 2;\n\t\t\t\t\t\tvp.h -= 2;\n\n\t\t\t\t\t\tw.element.moveTo(vp.x, vp.y);\n\t\t\t\t\t\tw.element.resizeTo(vp.w, vp.h);\n\t\t\t\t\t\tDOM.setStyles(id + '_ifr', {width : vp.w - w.deltaWidth, height : vp.h - w.deltaHeight});\n\t\t\t\t\t\tDOM.addClass(id + '_wrapper', 'mceMaximized');\n\t\t\t\t\t} else if (n.className == 'mceMed') {\n\t\t\t\t\t\t// Reset to old size\n\t\t\t\t\t\tw.element.moveTo(w.oldPos.x, w.oldPos.y);\n\t\t\t\t\t\tw.element.resizeTo(w.oldSize.w, w.oldSize.h);\n\t\t\t\t\t\tw.iframeElement.resizeTo(w.oldSize.w - w.deltaWidth, w.oldSize.h - w.deltaHeight);\n\n\t\t\t\t\t\tDOM.removeClass(id + '_wrapper', 'mceMaximized');\n\t\t\t\t\t} else if (n.className == 'mceMove')\n\t\t\t\t\t\treturn t._startDrag(id, e, n.className);\n\t\t\t\t\telse if (DOM.hasClass(n, 'mceResize'))\n\t\t\t\t\t\treturn t._startDrag(id, e, n.className.substring(13));\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tclf = Event.add(id, 'click', function(e) {\n\t\t\t\tvar n = e.target;\n\n\t\t\t\tt.focus(id);\n\n\t\t\t\tif (n.nodeName == 'A' || n.nodeName == 'a') {\n\t\t\t\t\tswitch (n.className) {\n\t\t\t\t\t\tcase 'mceClose':\n\t\t\t\t\t\t\tt.close(null, id);\n\t\t\t\t\t\t\treturn Event.cancel(e);\n\n\t\t\t\t\t\tcase 'mceButton mceOk':\n\t\t\t\t\t\tcase 'mceButton mceCancel':\n\t\t\t\t\t\t\tf.button_func(n.className == 'mceButton mceOk');\n\t\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Make sure the tab order loops within the dialog.\n\t\t\tEvent.add([id + '_left', id + '_right'], 'focus', function(evt) {\n\t\t\t\tvar iframe = DOM.get(id + '_ifr');\n\t\t\t\tif (iframe) {\n\t\t\t\t\tvar body = iframe.contentWindow.document.body;\n\t\t\t\t\tvar focusable = DOM.select(':input:enabled,*[tabindex=0]', body);\n\t\t\t\t\tif (evt.target.id === (id + '_left')) {\n\t\t\t\t\t\tfocusable[focusable.length - 1].focus();\n\t\t\t\t\t} else {\n\t\t\t\t\t\tfocusable[0].focus();\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tDOM.get(id + '_ok').focus();\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Add window\n\t\t\tw = t.windows[id] = {\n\t\t\t\tid : id,\n\t\t\t\tmousedown_func : mdf,\n\t\t\t\tclick_func : clf,\n\t\t\t\telement : new Element(id, {blocker : 1, container : ed.getContainer()}),\n\t\t\t\tiframeElement : new Element(id + '_ifr'),\n\t\t\t\tfeatures : f,\n\t\t\t\tdeltaWidth : dw,\n\t\t\t\tdeltaHeight : dh\n\t\t\t};\n\n\t\t\tw.iframeElement.on('focus', function() {\n\t\t\t\tt.focus(id);\n\t\t\t});\n\n\t\t\t// Setup blocker\n\t\t\tif (t.count == 0 && t.editor.getParam('dialog_type', 'modal') == 'modal') {\n\t\t\t\tDOM.add(DOM.doc.body, 'div', {\n\t\t\t\t\tid : 'mceModalBlocker',\n\t\t\t\t\t'class' : (t.editor.settings.inlinepopups_skin || 'clearlooks2') + '_modalBlocker',\n\t\t\t\t\tstyle : {zIndex : t.zIndex - 1}\n\t\t\t\t});\n\n\t\t\t\tDOM.show('mceModalBlocker'); // Reduces flicker in IE\n\t\t\t\tDOM.setAttrib(DOM.doc.body, 'aria-hidden', 'true');\n\t\t\t} else\n\t\t\t\tDOM.setStyle('mceModalBlocker', 'z-index', t.zIndex - 1);\n\n\t\t\tif (tinymce.isIE6 || /Firefox\\/2\\./.test(navigator.userAgent) || (tinymce.isIE && !DOM.boxModel))\n\t\t\t\tDOM.setStyles('mceModalBlocker', {position : 'absolute', left : vp.x, top : vp.y, width : vp.w - 2, height : vp.h - 2});\n\n\t\t\tDOM.setAttrib(id, 'aria-hidden', 'false');\n\t\t\tt.focus(id);\n\t\t\tt._fixIELayout(id, 1);\n\n\t\t\t// Focus ok button\n\t\t\tif (DOM.get(id + '_ok'))\n\t\t\t\tDOM.get(id + '_ok').focus();\n\t\t\tt.count++;\n\n\t\t\treturn w;\n\t\t},\n\n        getMaxZIndex: function() {\n            var max = 0, i;\n            var cn = document.body.childNodes;\n            for (i = 0; i < cn.length; i++) {\n                var el = cn[i];\n                var zIndex = el.nodeType == 1 ? parseInt(el.style.zIndex, 10) || 0 : 0;\n                if (zIndex < 10000) {\n                    max = Math.max(max, zIndex);\n                }\n            }\n            return max + 10;\n        },\n\n\t\tfocus : function(id) {\n\t\t\tvar t = this, w;\n\n\t\t\tif (w = t.windows[id]) {\n\t\t\t\tw.zIndex = t.getMaxZIndex();\n\t\t\t\tw.element.setStyle('zIndex', w.zIndex);\n\t\t\t\tw.element.update();\n\n\t\t\t\tid = id + '_wrapper';\n\t\t\t\tDOM.removeClass(t.lastId, 'mceFocus');\n\t\t\t\tDOM.addClass(id, 'mceFocus');\n\t\t\t\tt.lastId = id;\n\n\t\t\t\tif (w.focussedElement) {\n\t\t\t\t\tw.focussedElement.focus();\n\t\t\t\t} else if (DOM.get(id + '_ok')) {\n\t\t\t\t\tDOM.get(w.id + '_ok').focus();\n\t\t\t\t} else if (DOM.get(w.id + '_ifr')) {\n\t\t\t\t\tDOM.get(w.id + '_ifr').focus();\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t_addAll : function(te, ne) {\n\t\t\tvar i, n, t = this, dom = tinymce.DOM;\n\n\t\t\tif (is(ne, 'string'))\n\t\t\t\tte.appendChild(dom.doc.createTextNode(ne));\n\t\t\telse if (ne.length) {\n\t\t\t\tte = te.appendChild(dom.create(ne[0], ne[1]));\n\n\t\t\t\tfor (i=2; i<ne.length; i++)\n\t\t\t\t\tt._addAll(te, ne[i]);\n\t\t\t}\n\t\t},\n\n\t\t_startDrag : function(id, se, ac) {\n\t\t\tvar t = this, mu, mm, d = DOM.doc, eb, w = t.windows[id], we = w.element, sp = we.getXY(), p, sz, ph, cp, vp, sx, sy, sex, sey, dx, dy, dw, dh;\n\n\t\t\t// Get positons and sizes\n//\t\t\tcp = DOM.getPos(t.editor.getContainer());\n\t\t\tcp = {x : 0, y : 0};\n\t\t\tvp = DOM.getViewPort();\n\n\t\t\t// Reduce viewport size to avoid scrollbars while dragging\n\t\t\tvp.w -= 2;\n\t\t\tvp.h -= 2;\n\n\t\t\tsex = se.screenX;\n\t\t\tsey = se.screenY;\n\t\t\tdx = dy = dw = dh = 0;\n\n\t\t\t// Handle mouse up\n\t\t\tmu = Event.add(d, 'mouseup', function(e) {\n\t\t\t\tEvent.remove(d, 'mouseup', mu);\n\t\t\t\tEvent.remove(d, 'mousemove', mm);\n\n\t\t\t\tif (eb)\n\t\t\t\t\teb.remove();\n\n\t\t\t\twe.moveBy(dx, dy);\n\t\t\t\twe.resizeBy(dw, dh);\n\t\t\t\tsz = we.getSize();\n\t\t\t\tDOM.setStyles(id + '_ifr', {width : sz.w - w.deltaWidth, height : sz.h - w.deltaHeight});\n\t\t\t\tt._fixIELayout(id, 1);\n\n\t\t\t\treturn Event.cancel(e);\n\t\t\t});\n\n\t\t\tif (ac != 'Move')\n\t\t\t\tstartMove();\n\n\t\t\tfunction startMove() {\n\t\t\t\tif (eb)\n\t\t\t\t\treturn;\n\n\t\t\t\tt._fixIELayout(id, 0);\n\n\t\t\t\t// Setup event blocker\n\t\t\t\tDOM.add(d.body, 'div', {\n\t\t\t\t\tid : 'mceEventBlocker',\n\t\t\t\t\t'class' : 'mceEventBlocker ' + (t.editor.settings.inlinepopups_skin || 'clearlooks2'),\n\t\t\t\t\tstyle : {zIndex : t.zIndex + 1}\n\t\t\t\t});\n\n\t\t\t\tif (tinymce.isIE6 || (tinymce.isIE && !DOM.boxModel))\n\t\t\t\t\tDOM.setStyles('mceEventBlocker', {position : 'absolute', left : vp.x, top : vp.y, width : vp.w - 2, height : vp.h - 2});\n\n\t\t\t\teb = new Element('mceEventBlocker');\n\t\t\t\teb.update();\n\n\t\t\t\t// Setup placeholder\n\t\t\t\tp = we.getXY();\n\t\t\t\tsz = we.getSize();\n\t\t\t\tsx = cp.x + p.x - vp.x;\n\t\t\t\tsy = cp.y + p.y - vp.y;\n\t\t\t\tDOM.add(eb.get(), 'div', {id : 'mcePlaceHolder', 'class' : 'mcePlaceHolder', style : {left : sx, top : sy, width : sz.w, height : sz.h}});\n\t\t\t\tph = new Element('mcePlaceHolder');\n\t\t\t};\n\n\t\t\t// Handle mouse move/drag\n\t\t\tmm = Event.add(d, 'mousemove', function(e) {\n\t\t\t\tvar x, y, v;\n\n\t\t\t\tstartMove();\n\n\t\t\t\tx = e.screenX - sex;\n\t\t\t\ty = e.screenY - sey;\n\n\t\t\t\tswitch (ac) {\n\t\t\t\t\tcase 'ResizeW':\n\t\t\t\t\t\tdx = x;\n\t\t\t\t\t\tdw = 0 - x;\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'ResizeE':\n\t\t\t\t\t\tdw = x;\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'ResizeN':\n\t\t\t\t\tcase 'ResizeNW':\n\t\t\t\t\tcase 'ResizeNE':\n\t\t\t\t\t\tif (ac == \"ResizeNW\") {\n\t\t\t\t\t\t\tdx = x;\n\t\t\t\t\t\t\tdw = 0 - x;\n\t\t\t\t\t\t} else if (ac == \"ResizeNE\")\n\t\t\t\t\t\t\tdw = x;\n\n\t\t\t\t\t\tdy = y;\n\t\t\t\t\t\tdh = 0 - y;\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'ResizeS':\n\t\t\t\t\tcase 'ResizeSW':\n\t\t\t\t\tcase 'ResizeSE':\n\t\t\t\t\t\tif (ac == \"ResizeSW\") {\n\t\t\t\t\t\t\tdx = x;\n\t\t\t\t\t\t\tdw = 0 - x;\n\t\t\t\t\t\t} else if (ac == \"ResizeSE\")\n\t\t\t\t\t\t\tdw = x;\n\n\t\t\t\t\t\tdh = y;\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'mceMove':\n\t\t\t\t\t\tdx = x;\n\t\t\t\t\t\tdy = y;\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\t// Boundary check\n\t\t\t\tif (dw < (v = w.features.min_width - sz.w)) {\n\t\t\t\t\tif (dx !== 0)\n\t\t\t\t\t\tdx += dw - v;\n\n\t\t\t\t\tdw = v;\n\t\t\t\t}\n\n\t\t\t\tif (dh < (v = w.features.min_height - sz.h)) {\n\t\t\t\t\tif (dy !== 0)\n\t\t\t\t\t\tdy += dh - v;\n\n\t\t\t\t\tdh = v;\n\t\t\t\t}\n\n\t\t\t\tdw = Math.min(dw, w.features.max_width - sz.w);\n\t\t\t\tdh = Math.min(dh, w.features.max_height - sz.h);\n\t\t\t\tdx = Math.max(dx, vp.x - (sx + vp.x));\n\t\t\t\tdy = Math.max(dy, vp.y - (sy + vp.y));\n\t\t\t\tdx = Math.min(dx, (vp.w + vp.x) - (sx + sz.w + vp.x));\n\t\t\t\tdy = Math.min(dy, (vp.h + vp.y) - (sy + sz.h + vp.y));\n\n\t\t\t\t// Move if needed\n\t\t\t\tif (dx + dy !== 0) {\n\t\t\t\t\tif (sx + dx < 0)\n\t\t\t\t\t\tdx = 0;\n\n\t\t\t\t\tif (sy + dy < 0)\n\t\t\t\t\t\tdy = 0;\n\n\t\t\t\t\tph.moveTo(sx + dx, sy + dy);\n\t\t\t\t}\n\n\t\t\t\t// Resize if needed\n\t\t\t\tif (dw + dh !== 0)\n\t\t\t\t\tph.resizeTo(sz.w + dw, sz.h + dh);\n\n\t\t\t\treturn Event.cancel(e);\n\t\t\t});\n\n\t\t\treturn Event.cancel(se);\n\t\t},\n\n\t\tresizeBy : function(dw, dh, id) {\n\t\t\tvar w = this.windows[id];\n\n\t\t\tif (w) {\n\t\t\t\tw.element.resizeBy(dw, dh);\n\t\t\t\tw.iframeElement.resizeBy(dw, dh);\n\t\t\t}\n\t\t},\n\n\t\tclose : function(win, id) {\n\t\t\tvar t = this, w, d = DOM.doc, fw, id;\n\n\t\t\tid = t._findId(id || win);\n\n\t\t\t// Probably not inline\n\t\t\tif (!t.windows[id]) {\n\t\t\t\tt.parent(win);\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tt.count--;\n\n\t\t\tif (t.count == 0) {\n\t\t\t\tDOM.remove('mceModalBlocker');\n\t\t\t\tDOM.setAttrib(DOM.doc.body, 'aria-hidden', 'false');\n\t\t\t\tt.editor.focus();\n\t\t\t}\n\n\t\t\tif (w = t.windows[id]) {\n\t\t\t\tt.onClose.dispatch(t);\n\t\t\t\tEvent.remove(d, 'mousedown', w.mousedownFunc);\n\t\t\t\tEvent.remove(d, 'click', w.clickFunc);\n\t\t\t\tEvent.clear(id);\n\t\t\t\tEvent.clear(id + '_ifr');\n\n\t\t\t\tDOM.setAttrib(id + '_ifr', 'src', 'javascript:\"\"'); // Prevent leak\n\t\t\t\tw.element.remove();\n\t\t\t\tdelete t.windows[id];\n\n\t\t\t\tfw = t._frontWindow();\n\n\t\t\t\tif (fw)\n\t\t\t\t\tt.focus(fw.id);\n\t\t\t}\n\t\t},\n\n\t\t// Find front most window\n\t\t_frontWindow : function() {\n\t\t\tvar fw, ix = 0;\n\t\t\t// Find front most window and focus that\n\t\t\teach (this.windows, function(w) {\n\t\t\t\tif (w.zIndex > ix) {\n\t\t\t\t\tfw = w;\n\t\t\t\t\tix = w.zIndex;\n\t\t\t\t}\n\t\t\t});\n\t\t\treturn fw;\n\t\t},\n\n\t\tsetTitle : function(w, ti) {\n\t\t\tvar e;\n\n\t\t\tw = this._findId(w);\n\n\t\t\tif (e = DOM.get(w + '_title'))\n\t\t\t\te.innerHTML = DOM.encode(ti);\n\t\t},\n\n\t\talert : function(txt, cb, s) {\n\t\t\tvar t = this, w;\n\n\t\t\tw = t.open({\n\t\t\t\ttitle : t,\n\t\t\t\ttype : 'alert',\n\t\t\t\tbutton_func : function(s) {\n\t\t\t\t\tif (cb)\n\t\t\t\t\t\tcb.call(s || t, s);\n\n\t\t\t\t\tt.close(null, w.id);\n\t\t\t\t},\n\t\t\t\tcontent : DOM.encode(t.editor.getLang(txt, txt)),\n\t\t\t\tinline : 1,\n\t\t\t\twidth : 400,\n\t\t\t\theight : 130\n\t\t\t});\n\t\t},\n\n\t\tconfirm : function(txt, cb, s) {\n\t\t\tvar t = this, w;\n\n\t\t\tw = t.open({\n\t\t\t\ttitle : t,\n\t\t\t\ttype : 'confirm',\n\t\t\t\tbutton_func : function(s) {\n\t\t\t\t\tif (cb)\n\t\t\t\t\t\tcb.call(s || t, s);\n\n\t\t\t\t\tt.close(null, w.id);\n\t\t\t\t},\n\t\t\t\tcontent : DOM.encode(t.editor.getLang(txt, txt)),\n\t\t\t\tinline : 1,\n\t\t\t\twidth : 400,\n\t\t\t\theight : 130\n\t\t\t});\n\t\t},\n\n\t\t// Internal functions\n\n\t\t_findId : function(w) {\n\t\t\tvar t = this;\n\n\t\t\tif (typeof(w) == 'string')\n\t\t\t\treturn w;\n\n\t\t\teach(t.windows, function(wo) {\n\t\t\t\tvar ifr = DOM.get(wo.id + '_ifr');\n\n\t\t\t\tif (ifr && w == ifr.contentWindow) {\n\t\t\t\t\tw = wo.id;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn w;\n\t\t},\n\n\t\t_fixIELayout : function(id, s) {\n\t\t\tvar w, img;\n\n\t\t\tif (!tinymce.isIE6)\n\t\t\t\treturn;\n\n\t\t\t// Fixes the bug where hover flickers and does odd things in IE6\n\t\t\teach(['n','s','w','e','nw','ne','sw','se'], function(v) {\n\t\t\t\tvar e = DOM.get(id + '_resize_' + v);\n\n\t\t\t\tDOM.setStyles(e, {\n\t\t\t\t\twidth : s ? e.clientWidth : '',\n\t\t\t\t\theight : s ? e.clientHeight : '',\n\t\t\t\t\tcursor : DOM.getStyle(e, 'cursor', 1)\n\t\t\t\t});\n\n\t\t\t\tDOM.setStyle(id + \"_bottom\", 'bottom', '-1px');\n\n\t\t\t\te = 0;\n\t\t\t});\n\n\t\t\t// Fixes graphics glitch\n\t\t\tif (w = this.windows[id]) {\n\t\t\t\t// Fixes rendering bug after resize\n\t\t\t\tw.element.hide();\n\t\t\t\tw.element.show();\n\n\t\t\t\t// Forced a repaint of the window\n\t\t\t\t//DOM.get(id).style.filter = '';\n\n\t\t\t\t// IE has a bug where images used in CSS won't get loaded\n\t\t\t\t// sometimes when the cache in the browser is disabled\n\t\t\t\t// This fix tries to solve it by loading the images using the image object\n\t\t\t\teach(DOM.select('div,a', id), function(e, i) {\n\t\t\t\t\tif (e.currentStyle.backgroundImage != 'none') {\n\t\t\t\t\t\timg = new Image();\n\t\t\t\t\t\timg.src = e.currentStyle.backgroundImage.replace(/url\\(\\\"(.+)\\\"\\)/, '$1');\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tDOM.get(id).style.filter = '';\n\t\t\t}\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('inlinepopups', tinymce.plugins.InlinePopups);\n})();\n\n","Magento_Tinymce3/tiny_mce/plugins/template/editor_plugin.js":"(function(){var a=tinymce.each;tinymce.create(\"tinymce.plugins.TemplatePlugin\",{init:function(b,c){var d=this;d.editor=b;b.addCommand(\"mceTemplate\",function(e){b.windowManager.open({file:c+\"/template.htm\",width:b.getParam(\"template_popup_width\",750),height:b.getParam(\"template_popup_height\",600),inline:1},{plugin_url:c})});b.addCommand(\"mceInsertTemplate\",d._insertTemplate,d);b.addButton(\"template\",{title:\"template.desc\",cmd:\"mceTemplate\"});b.onPreProcess.add(function(e,g){var f=e.dom;a(f.select(\"div\",g.node),function(h){if(f.hasClass(h,\"mceTmpl\")){a(f.select(\"*\",h),function(i){if(f.hasClass(i,e.getParam(\"template_mdate_classes\",\"mdate\").replace(/\\s+/g,\"|\"))){i.innerHTML=d._getDateTime(new Date(),e.getParam(\"template_mdate_format\",e.getLang(\"template.mdate_format\")))}});d._replaceVals(h)}})})},getInfo:function(){return{longname:\"Template plugin\",author:\"Moxiecode Systems AB\",authorurl:\"http://www.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/template\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}},_insertTemplate:function(i,j){var k=this,g=k.editor,f,c,d=g.dom,b=g.selection.getContent();f=j.content;a(k.editor.getParam(\"template_replace_values\"),function(l,h){if(typeof(l)!=\"function\"){f=f.replace(new RegExp(\"\\\\{\\\\$\"+h+\"\\\\}\",\"g\"),l)}});c=d.create(\"div\",null,f);n=d.select(\".mceTmpl\",c);if(n&&n.length>0){c=d.create(\"div\",null);c.appendChild(n[0].cloneNode(true))}function e(l,h){return new RegExp(\"\\\\b\"+h+\"\\\\b\",\"g\").test(l.className)}a(d.select(\"*\",c),function(h){if(e(h,g.getParam(\"template_cdate_classes\",\"cdate\").replace(/\\s+/g,\"|\"))){h.innerHTML=k._getDateTime(new Date(),g.getParam(\"template_cdate_format\",g.getLang(\"template.cdate_format\")))}if(e(h,g.getParam(\"template_mdate_classes\",\"mdate\").replace(/\\s+/g,\"|\"))){h.innerHTML=k._getDateTime(new Date(),g.getParam(\"template_mdate_format\",g.getLang(\"template.mdate_format\")))}if(e(h,g.getParam(\"template_selected_content_classes\",\"selcontent\").replace(/\\s+/g,\"|\"))){h.innerHTML=b}});k._replaceVals(c);g.execCommand(\"mceInsertContent\",false,c.innerHTML);g.addVisual()},_replaceVals:function(c){var d=this.editor.dom,b=this.editor.getParam(\"template_replace_values\");a(d.select(\"*\",c),function(f){a(b,function(g,e){if(d.hasClass(f,e)){if(typeof(b[e])==\"function\"){b[e](f)}}})})},_getDateTime:function(e,b){if(!b){return\"\"}function c(g,d){var f;g=\"\"+g;if(g.length<d){for(f=0;f<(d-g.length);f++){g=\"0\"+g}}return g}b=b.replace(\"%D\",\"%m/%d/%y\");b=b.replace(\"%r\",\"%I:%M:%S %p\");b=b.replace(\"%Y\",\"\"+e.getFullYear());b=b.replace(\"%y\",\"\"+e.getYear());b=b.replace(\"%m\",c(e.getMonth()+1,2));b=b.replace(\"%d\",c(e.getDate(),2));b=b.replace(\"%H\",\"\"+c(e.getHours(),2));b=b.replace(\"%M\",\"\"+c(e.getMinutes(),2));b=b.replace(\"%S\",\"\"+c(e.getSeconds(),2));b=b.replace(\"%I\",\"\"+((e.getHours()+11)%12+1));b=b.replace(\"%p\",\"\"+(e.getHours()<12?\"AM\":\"PM\"));b=b.replace(\"%B\",\"\"+this.editor.getLang(\"template_months_long\").split(\",\")[e.getMonth()]);b=b.replace(\"%b\",\"\"+this.editor.getLang(\"template_months_short\").split(\",\")[e.getMonth()]);b=b.replace(\"%A\",\"\"+this.editor.getLang(\"template_day_long\").split(\",\")[e.getDay()]);b=b.replace(\"%a\",\"\"+this.editor.getLang(\"template_day_short\").split(\",\")[e.getDay()]);b=b.replace(\"%%\",\"%\");return b}});tinymce.PluginManager.add(\"template\",tinymce.plugins.TemplatePlugin)})();","Magento_Tinymce3/tiny_mce/plugins/template/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\tvar each = tinymce.each;\n\n\ttinymce.create('tinymce.plugins.TemplatePlugin', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this;\n\n\t\t\tt.editor = ed;\n\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceTemplate', function(ui) {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/template.htm',\n\t\t\t\t\twidth : ed.getParam('template_popup_width', 750),\n\t\t\t\t\theight : ed.getParam('template_popup_height', 600),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url\n\t\t\t\t});\n\t\t\t});\n\n\t\t\ted.addCommand('mceInsertTemplate', t._insertTemplate, t);\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('template', {title : 'template.desc', cmd : 'mceTemplate'});\n\n\t\t\ted.onPreProcess.add(function(ed, o) {\n\t\t\t\tvar dom = ed.dom;\n\n\t\t\t\teach(dom.select('div', o.node), function(e) {\n\t\t\t\t\tif (dom.hasClass(e, 'mceTmpl')) {\n\t\t\t\t\t\teach(dom.select('*', e), function(e) {\n\t\t\t\t\t\t\tif (dom.hasClass(e, ed.getParam('template_mdate_classes', 'mdate').replace(/\\s+/g, '|')))\n\t\t\t\t\t\t\t\te.innerHTML = t._getDateTime(new Date(), ed.getParam(\"template_mdate_format\", ed.getLang(\"template.mdate_format\")));\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tt._replaceVals(e);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Template plugin',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://www.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/template',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t},\n\n\t\t_insertTemplate : function(ui, v) {\n\t\t\tvar t = this, ed = t.editor, h, el, dom = ed.dom, sel = ed.selection.getContent();\n\n\t\t\th = v.content;\n\n\t\t\teach(t.editor.getParam('template_replace_values'), function(v, k) {\n\t\t\t\tif (typeof(v) != 'function')\n\t\t\t\t\th = h.replace(new RegExp('\\\\{\\\\$' + k + '\\\\}', 'g'), v);\n\t\t\t});\n\n\t\t\tel = dom.create('div', null, h);\n\n\t\t\t// Find template element within div\n\t\t\tn = dom.select('.mceTmpl', el);\n\t\t\tif (n && n.length > 0) {\n\t\t\t\tel = dom.create('div', null);\n\t\t\t\tel.appendChild(n[0].cloneNode(true));\n\t\t\t}\n\n\t\t\tfunction hasClass(n, c) {\n\t\t\t\treturn new RegExp('\\\\b' + c + '\\\\b', 'g').test(n.className);\n\t\t\t};\n\n\t\t\teach(dom.select('*', el), function(n) {\n\t\t\t\t// Replace cdate\n\t\t\t\tif (hasClass(n, ed.getParam('template_cdate_classes', 'cdate').replace(/\\s+/g, '|')))\n\t\t\t\t\tn.innerHTML = t._getDateTime(new Date(), ed.getParam(\"template_cdate_format\", ed.getLang(\"template.cdate_format\")));\n\n\t\t\t\t// Replace mdate\n\t\t\t\tif (hasClass(n, ed.getParam('template_mdate_classes', 'mdate').replace(/\\s+/g, '|')))\n\t\t\t\t\tn.innerHTML = t._getDateTime(new Date(), ed.getParam(\"template_mdate_format\", ed.getLang(\"template.mdate_format\")));\n\n\t\t\t\t// Replace selection\n\t\t\t\tif (hasClass(n, ed.getParam('template_selected_content_classes', 'selcontent').replace(/\\s+/g, '|')))\n\t\t\t\t\tn.innerHTML = sel;\n\t\t\t});\n\n\t\t\tt._replaceVals(el);\n\n\t\t\ted.execCommand('mceInsertContent', false, el.innerHTML);\n\t\t\ted.addVisual();\n\t\t},\n\n\t\t_replaceVals : function(e) {\n\t\t\tvar dom = this.editor.dom, vl = this.editor.getParam('template_replace_values');\n\n\t\t\teach(dom.select('*', e), function(e) {\n\t\t\t\teach(vl, function(v, k) {\n\t\t\t\t\tif (dom.hasClass(e, k)) {\n\t\t\t\t\t\tif (typeof(vl[k]) == 'function')\n\t\t\t\t\t\t\tvl[k](e);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t});\n\t\t},\n\n\t\t_getDateTime : function(d, fmt) {\n\t\t\t\tif (!fmt)\n\t\t\t\t\treturn \"\";\n\n\t\t\t\tfunction addZeros(value, len) {\n\t\t\t\t\tvar i;\n\n\t\t\t\t\tvalue = \"\" + value;\n\n\t\t\t\t\tif (value.length < len) {\n\t\t\t\t\t\tfor (i=0; i<(len-value.length); i++)\n\t\t\t\t\t\t\tvalue = \"0\" + value;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn value;\n\t\t\t\t}\n\n\t\t\t\tfmt = fmt.replace(\"%D\", \"%m/%d/%y\");\n\t\t\t\tfmt = fmt.replace(\"%r\", \"%I:%M:%S %p\");\n\t\t\t\tfmt = fmt.replace(\"%Y\", \"\" + d.getFullYear());\n\t\t\t\tfmt = fmt.replace(\"%y\", \"\" + d.getYear());\n\t\t\t\tfmt = fmt.replace(\"%m\", addZeros(d.getMonth()+1, 2));\n\t\t\t\tfmt = fmt.replace(\"%d\", addZeros(d.getDate(), 2));\n\t\t\t\tfmt = fmt.replace(\"%H\", \"\" + addZeros(d.getHours(), 2));\n\t\t\t\tfmt = fmt.replace(\"%M\", \"\" + addZeros(d.getMinutes(), 2));\n\t\t\t\tfmt = fmt.replace(\"%S\", \"\" + addZeros(d.getSeconds(), 2));\n\t\t\t\tfmt = fmt.replace(\"%I\", \"\" + ((d.getHours() + 11) % 12 + 1));\n\t\t\t\tfmt = fmt.replace(\"%p\", \"\" + (d.getHours() < 12 ? \"AM\" : \"PM\"));\n\t\t\t\tfmt = fmt.replace(\"%B\", \"\" + this.editor.getLang(\"template_months_long\").split(',')[d.getMonth()]);\n\t\t\t\tfmt = fmt.replace(\"%b\", \"\" + this.editor.getLang(\"template_months_short\").split(',')[d.getMonth()]);\n\t\t\t\tfmt = fmt.replace(\"%A\", \"\" + this.editor.getLang(\"template_day_long\").split(',')[d.getDay()]);\n\t\t\t\tfmt = fmt.replace(\"%a\", \"\" + this.editor.getLang(\"template_day_short\").split(',')[d.getDay()]);\n\t\t\t\tfmt = fmt.replace(\"%%\", \"%\");\n\n\t\t\t\treturn fmt;\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('template', tinymce.plugins.TemplatePlugin);\n})();","Magento_Tinymce3/tiny_mce/plugins/template/js/template.js":"tinyMCEPopup.requireLangPack();\n\nvar TemplateDialog = {\n\tpreInit : function() {\n\t\tvar url = tinyMCEPopup.getParam(\"template_external_list_url\");\n\n\t\tif (url != null)\n\t\t\tdocument.write('<sc'+'ript language=\"javascript\" type=\"text/javascript\" src=\"' + tinyMCEPopup.editor.documentBaseURI.toAbsolute(url) + '\"></sc'+'ript>');\n\t},\n\n\tinit : function() {\n\t\tvar ed = tinyMCEPopup.editor, tsrc, sel, x, u;\n\n \t\ttsrc = ed.getParam(\"template_templates\", false);\n \t\tsel = document.getElementById('tpath');\n\n\t\t// Setup external template list\n\t\tif (!tsrc && typeof(tinyMCETemplateList) != 'undefined') {\n\t\t\tfor (x=0, tsrc = []; x<tinyMCETemplateList.length; x++)\n\t\t\t\ttsrc.push({title : tinyMCETemplateList[x][0], src : tinyMCETemplateList[x][1], description : tinyMCETemplateList[x][2]});\n\t\t}\n\n\t\tfor (x=0; x<tsrc.length; x++)\n\t\t\tsel.options[sel.options.length] = new Option(tsrc[x].title, tinyMCEPopup.editor.documentBaseURI.toAbsolute(tsrc[x].src));\n\n\t\tthis.resize();\n\t\tthis.tsrc = tsrc;\n\t},\n\n\tresize : function() {\n\t\tvar w, h, e;\n\n\t\tif (!self.innerWidth) {\n\t\t\tw = document.body.clientWidth - 50;\n\t\t\th = document.body.clientHeight - 160;\n\t\t} else {\n\t\t\tw = self.innerWidth - 50;\n\t\t\th = self.innerHeight - 170;\n\t\t}\n\n\t\te = document.getElementById('templatesrc');\n\n\t\tif (e) {\n\t\t\te.style.height = Math.abs(h) + 'px';\n\t\t\te.style.width = Math.abs(w - 5) + 'px';\n\t\t}\n\t},\n\n\tloadCSSFiles : function(d) {\n\t\tvar ed = tinyMCEPopup.editor;\n\n\t\ttinymce.each(ed.getParam(\"content_css\", '').split(','), function(u) {\n\t\t\td.write('<link href=\"' + ed.documentBaseURI.toAbsolute(u) + '\" rel=\"stylesheet\" type=\"text/css\" />');\n\t\t});\n\t},\n\n\tselectTemplate : function(u, ti) {\n\t\tvar d = window.frames['templatesrc'].document, x, tsrc = this.tsrc;\n\n\t\tif (!u)\n\t\t\treturn;\n\n\t\td.body.innerHTML = this.templateHTML = this.getFileContents(u);\n\n\t\tfor (x=0; x<tsrc.length; x++) {\n\t\t\tif (tsrc[x].title == ti)\n\t\t\t\tdocument.getElementById('tmpldesc').innerHTML = tsrc[x].description || '';\n\t\t}\n\t},\n\n \tinsert : function() {\n\t\ttinyMCEPopup.execCommand('mceInsertTemplate', false, {\n\t\t\tcontent : this.templateHTML,\n\t\t\tselection : tinyMCEPopup.editor.selection.getContent()\n\t\t});\n\n\t\ttinyMCEPopup.close();\n\t},\n\n\tgetFileContents : function(u) {\n\t\tvar x, d, t = 'text/plain';\n\n\t\tfunction g(s) {\n\t\t\tx = 0;\n\n\t\t\ttry {\n\t\t\t\tx = new ActiveXObject(s);\n\t\t\t} catch (s) {\n\t\t\t}\n\n\t\t\treturn x;\n\t\t};\n\n\t\tx = window.ActiveXObject ? g('Msxml2.XMLHTTP') || g('Microsoft.XMLHTTP') : new XMLHttpRequest();\n\n\t\t// Synchronous AJAX load file\n\t\tx.overrideMimeType && x.overrideMimeType(t);\n\t\tx.open(\"GET\", u, false);\n\t\tx.send(null);\n\n\t\treturn x.responseText;\n\t}\n};\n\nTemplateDialog.preInit();\ntinyMCEPopup.onInit.add(TemplateDialog.init, TemplateDialog);\n","Magento_Tinymce3/tiny_mce/plugins/template/langs/en_dlg.js":"tinyMCE.addI18n('en.template_dlg',{title:\"Templates\",label:\"Template\",\"desc_label\":\"Description\",desc:\"Insert Predefined Template Content\",select:\"Select a Template\",preview:\"Preview\",warning:\"Warning: Updating a template with a different one may cause data loss.\",\"mdate_format\":\"%Y-%m-%d %H:%M:%S\",\"cdate_format\":\"%Y-%m-%d %H:%M:%S\",\"months_long\":\"January,February,March,April,May,June,July,August,September,October,November,December\",\"months_short\":\"Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec\",\"day_long\":\"Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday\",\"day_short\":\"Sun,Mon,Tue,Wed,Thu,Fri,Sat,Sun\"});","Magento_Tinymce3/tiny_mce/plugins/autosave/editor_plugin.js":"(function(e){var c=\"autosave\",g=\"restoredraft\",b=true,f,d,a=e.util.Dispatcher;e.create(\"tinymce.plugins.AutoSave\",{init:function(i,j){var h=this,l=i.settings;h.editor=i;function k(n){var m={s:1000,m:60000};n=/^(\\d+)([ms]?)$/.exec(\"\"+n);return(n[2]?m[n[2]]:1)*parseInt(n)}e.each({ask_before_unload:b,interval:\"30s\",retention:\"20m\",minlength:50},function(n,m){m=c+\"_\"+m;if(l[m]===f){l[m]=n}});l.autosave_interval=k(l.autosave_interval);l.autosave_retention=k(l.autosave_retention);i.addButton(g,{title:c+\".restore_content\",onclick:function(){if(i.getContent({draft:true}).replace(/\\s|&nbsp;|<\\/?p[^>]*>|<br[^>]*>/gi,\"\").length>0){i.windowManager.confirm(c+\".warning_message\",function(m){if(m){h.restoreDraft()}})}else{h.restoreDraft()}}});i.onNodeChange.add(function(){var m=i.controlManager;if(m.get(g)){m.setDisabled(g,!h.hasDraft())}});i.onInit.add(function(){if(i.controlManager.get(g)){h.setupStorage(i);setInterval(function(){h.storeDraft();i.nodeChanged()},l.autosave_interval)}});h.onStoreDraft=new a(h);h.onRestoreDraft=new a(h);h.onRemoveDraft=new a(h);if(!d){window.onbeforeunload=e.plugins.AutoSave._beforeUnloadHandler;d=b}},getInfo:function(){return{longname:\"Auto save\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/autosave\",version:e.majorVersion+\".\"+e.minorVersion}},getExpDate:function(){return new Date(new Date().getTime()+this.editor.settings.autosave_retention).toUTCString()},setupStorage:function(i){var h=this,k=c+\"_test\",j=\"OK\";h.key=c+i.id;e.each([function(){if(localStorage){localStorage.setItem(k,j);if(localStorage.getItem(k)===j){localStorage.removeItem(k);return localStorage}}},function(){if(sessionStorage){sessionStorage.setItem(k,j);if(sessionStorage.getItem(k)===j){sessionStorage.removeItem(k);return sessionStorage}}},function(){if(e.isIE){i.getElement().style.behavior=\"url('#default#userData')\";return{autoExpires:b,setItem:function(l,n){var m=i.getElement();m.setAttribute(l,n);m.expires=h.getExpDate();try{m.save(\"TinyMCE\")}catch(o){}},getItem:function(l){var m=i.getElement();try{m.load(\"TinyMCE\");return m.getAttribute(l)}catch(n){return null}},removeItem:function(l){i.getElement().removeAttribute(l)}}}},],function(l){try{h.storage=l();if(h.storage){return false}}catch(m){}})},storeDraft:function(){var i=this,l=i.storage,j=i.editor,h,k;if(l){if(!l.getItem(i.key)&&!j.isDirty()){return}k=j.getContent({draft:true});if(k.length>j.settings.autosave_minlength){h=i.getExpDate();if(!i.storage.autoExpires){i.storage.setItem(i.key+\"_expires\",h)}i.storage.setItem(i.key,k);i.onStoreDraft.dispatch(i,{expires:h,content:k})}}},restoreDraft:function(){var h=this,j=h.storage,i;if(j){i=j.getItem(h.key);if(i){h.editor.setContent(i);h.onRestoreDraft.dispatch(h,{content:i})}}},hasDraft:function(){var h=this,k=h.storage,i,j;if(k){j=!!k.getItem(h.key);if(j){if(!h.storage.autoExpires){i=new Date(k.getItem(h.key+\"_expires\"));if(new Date().getTime()<i.getTime()){return b}h.removeDraft()}else{return b}}}return false},removeDraft:function(){var h=this,k=h.storage,i=h.key,j;if(k){j=k.getItem(i);k.removeItem(i);k.removeItem(i+\"_expires\");if(j){h.onRemoveDraft.dispatch(h,{content:j})}}},\"static\":{_beforeUnloadHandler:function(h){var i;e.each(tinyMCE.editors,function(j){if(j.plugins.autosave){j.plugins.autosave.storeDraft()}if(j.getParam(\"fullscreen_is_enabled\")){return}if(!i&&j.isDirty()&&j.getParam(\"autosave_ask_before_unload\")){i=j.getLang(\"autosave.unload_msg\")}});return i}}});e.PluginManager.add(\"autosave\",e.plugins.AutoSave)})(tinymce);","Magento_Tinymce3/tiny_mce/plugins/autosave/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n *\n * Adds auto-save capability to the TinyMCE text editor to rescue content\n * inadvertently lost. This plugin was originally developed by Speednet\n * and that project can be found here: http://code.google.com/p/tinyautosave/\n *\n * TECHNOLOGY DISCUSSION:\n * \n * The plugin attempts to use the most advanced features available in the current browser to save\n * as much content as possible.  There are a total of four different methods used to autosave the\n * content.  In order of preference, they are:\n * \n * 1. localStorage - A new feature of HTML 5, localStorage can store megabytes of data per domain\n * on the client computer. Data stored in the localStorage area has no expiration date, so we must\n * manage expiring the data ourselves.  localStorage is fully supported by IE8, and it is supposed\n * to be working in Firefox 3 and Safari 3.2, but in reality it is flaky in those browsers.  As\n * HTML 5 gets wider support, the AutoSave plugin will use it automatically. In Windows Vista/7,\n * localStorage is stored in the following folder:\n * C:\\Users\\[username]\\AppData\\Local\\Microsoft\\Internet Explorer\\DOMStore\\[tempFolder]\n * \n * 2. sessionStorage - A new feature of HTML 5, sessionStorage works similarly to localStorage,\n * except it is designed to expire after a certain amount of time.  Because the specification\n * around expiration date/time is very loosely-described, it is preferable to use locaStorage and\n * manage the expiration ourselves.  sessionStorage has similar storage characteristics to\n * localStorage, although it seems to have better support by Firefox 3 at the moment.  (That will\n * certainly change as Firefox continues getting better at HTML 5 adoption.)\n * \n * 3. UserData - A very under-exploited feature of Microsoft Internet Explorer, UserData is a\n * way to store up to 128K of data per \"document\", or up to 1MB of data per domain, on the client\n * computer.  The feature is available for IE 5+, which makes it available for every version of IE\n * supported by TinyMCE.  The content is persistent across browser restarts and expires on the\n * date/time specified, just like a cookie.  However, the data is not cleared when the user clears\n * cookies on the browser, which makes it well-suited for rescuing autosaved content.  UserData,\n * like other Microsoft IE browser technologies, is implemented as a behavior attached to a\n * specific DOM object, so in this case we attach the behavior to the same DOM element that the\n * TinyMCE editor instance is attached to.\n */\n\n(function(tinymce) {\n\t// Setup constants to help the compressor to reduce script size\n\tvar PLUGIN_NAME = 'autosave',\n\t\tRESTORE_DRAFT = 'restoredraft',\n\t\tTRUE = true,\n\t\tundefined,\n\t\tunloadHandlerAdded,\n\t\tDispatcher = tinymce.util.Dispatcher;\n\n\t/**\n\t * This plugin adds auto-save capability to the TinyMCE text editor to rescue content\n\t * inadvertently lost. By using localStorage.\n\t *\n\t * @class tinymce.plugins.AutoSave\n\t */\n\ttinymce.create('tinymce.plugins.AutoSave', {\n\t\t/**\n\t\t * Initializes the plugin, this will be executed after the plugin has been created.\n\t\t * This call is done before the editor instance has finished it's initialization so use the onInit event\n\t\t * of the editor instance to intercept that event.\n\t\t *\n\t\t * @method init\n\t\t * @param {tinymce.Editor} ed Editor instance that the plugin is initialized in.\n\t\t * @param {string} url Absolute URL to where the plugin is located.\n\t\t */\n\t\tinit : function(ed, url) {\n\t\t\tvar self = this, settings = ed.settings;\n\n\t\t\tself.editor = ed;\n\n\t\t\t// Parses the specified time string into a milisecond number 10m, 10s etc.\n\t\t\tfunction parseTime(time) {\n\t\t\t\tvar multipels = {\n\t\t\t\t\ts : 1000,\n\t\t\t\t\tm : 60000\n\t\t\t\t};\n\n\t\t\t\ttime = /^(\\d+)([ms]?)$/.exec('' + time);\n\n\t\t\t\treturn (time[2] ? multipels[time[2]] : 1) * parseInt(time);\n\t\t\t};\n\n\t\t\t// Default config\n\t\t\ttinymce.each({\n\t\t\t\task_before_unload : TRUE,\n\t\t\t\tinterval : '30s',\n\t\t\t\tretention : '20m',\n\t\t\t\tminlength : 50\n\t\t\t}, function(value, key) {\n\t\t\t\tkey = PLUGIN_NAME + '_' + key;\n\n\t\t\t\tif (settings[key] === undefined)\n\t\t\t\t\tsettings[key] = value;\n\t\t\t});\n\n\t\t\t// Parse times\n\t\t\tsettings.autosave_interval = parseTime(settings.autosave_interval);\n\t\t\tsettings.autosave_retention = parseTime(settings.autosave_retention);\n\n\t\t\t// Register restore button\n\t\t\ted.addButton(RESTORE_DRAFT, {\n\t\t\t\ttitle : PLUGIN_NAME + \".restore_content\",\n\t\t\t\tonclick : function() {\n\t\t\t\t\tif (ed.getContent({draft: true}).replace(/\\s|&nbsp;|<\\/?p[^>]*>|<br[^>]*>/gi, \"\").length > 0) {\n\t\t\t\t\t\t// Show confirm dialog if the editor isn't empty\n\t\t\t\t\t\ted.windowManager.confirm(\n\t\t\t\t\t\t\tPLUGIN_NAME + \".warning_message\",\n\t\t\t\t\t\t\tfunction(ok) {\n\t\t\t\t\t\t\t\tif (ok)\n\t\t\t\t\t\t\t\t\tself.restoreDraft();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t);\n\t\t\t\t\t} else\n\t\t\t\t\t\tself.restoreDraft();\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Enable/disable restoredraft button depending on if there is a draft stored or not\n\t\t\ted.onNodeChange.add(function() {\n\t\t\t\tvar controlManager = ed.controlManager;\n\n\t\t\t\tif (controlManager.get(RESTORE_DRAFT))\n\t\t\t\t\tcontrolManager.setDisabled(RESTORE_DRAFT, !self.hasDraft());\n\t\t\t});\n\n\t\t\ted.onInit.add(function() {\n\t\t\t\t// Check if the user added the restore button, then setup auto storage logic\n\t\t\t\tif (ed.controlManager.get(RESTORE_DRAFT)) {\n\t\t\t\t\t// Setup storage engine\n\t\t\t\t\tself.setupStorage(ed);\n\n\t\t\t\t\t// Auto save contents each interval time\n\t\t\t\t\tsetInterval(function() {\n\t\t\t\t\t\tself.storeDraft();\n\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t}, settings.autosave_interval);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t/**\n\t\t\t * This event gets fired when a draft is stored to local storage.\n\t\t\t *\n\t\t\t * @event onStoreDraft\n\t\t\t * @param {tinymce.plugins.AutoSave} sender Plugin instance sending the event.\n\t\t\t * @param {Object} draft Draft object containing the HTML contents of the editor.\n\t\t\t */\n\t\t\tself.onStoreDraft = new Dispatcher(self);\n\n\t\t\t/**\n\t\t\t * This event gets fired when a draft is restored from local storage.\n\t\t\t *\n\t\t\t * @event onStoreDraft\n\t\t\t * @param {tinymce.plugins.AutoSave} sender Plugin instance sending the event.\n\t\t\t * @param {Object} draft Draft object containing the HTML contents of the editor.\n\t\t\t */\n\t\t\tself.onRestoreDraft = new Dispatcher(self);\n\n\t\t\t/**\n\t\t\t * This event gets fired when a draft removed/expired.\n\t\t\t *\n\t\t\t * @event onRemoveDraft\n\t\t\t * @param {tinymce.plugins.AutoSave} sender Plugin instance sending the event.\n\t\t\t * @param {Object} draft Draft object containing the HTML contents of the editor.\n\t\t\t */\n\t\t\tself.onRemoveDraft = new Dispatcher(self);\n\n\t\t\t// Add ask before unload dialog only add one unload handler\n\t\t\tif (!unloadHandlerAdded) {\n\t\t\t\twindow.onbeforeunload = tinymce.plugins.AutoSave._beforeUnloadHandler;\n\t\t\t\tunloadHandlerAdded = TRUE;\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Returns information about the plugin as a name/value array.\n\t\t * The current keys are longname, author, authorurl, infourl and version.\n\t\t *\n\t\t * @method getInfo\n\t\t * @return {Object} Name/value array containing information about the plugin.\n\t\t */\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Auto save',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/autosave',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t},\n\n\t\t/**\n\t\t * Returns an expiration date UTC string.\n\t\t *\n\t\t * @method getExpDate\n\t\t * @return {String} Expiration date UTC string.\n\t\t */\n\t\tgetExpDate : function() {\n\t\t\treturn new Date(\n\t\t\t\tnew Date().getTime() + this.editor.settings.autosave_retention\n\t\t\t).toUTCString();\n\t\t},\n\n\t\t/**\n\t\t * This method will setup the storage engine. If the browser has support for it.\n\t\t *\n\t\t * @method setupStorage\n\t\t */\n\t\tsetupStorage : function(ed) {\n\t\t\tvar self = this, testKey = PLUGIN_NAME + '_test', testVal = \"OK\";\n\n\t\t\tself.key = PLUGIN_NAME + ed.id;\n\n\t\t\t// Loop though each storage engine type until we find one that works\n\t\t\ttinymce.each([\n\t\t\t\tfunction() {\n\t\t\t\t\t// Try HTML5 Local Storage\n\t\t\t\t\tif (localStorage) {\n\t\t\t\t\t\tlocalStorage.setItem(testKey, testVal);\n\n\t\t\t\t\t\tif (localStorage.getItem(testKey) === testVal) {\n\t\t\t\t\t\t\tlocalStorage.removeItem(testKey);\n\n\t\t\t\t\t\t\treturn localStorage;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tfunction() {\n\t\t\t\t\t// Try HTML5 Session Storage\n\t\t\t\t\tif (sessionStorage) {\n\t\t\t\t\t\tsessionStorage.setItem(testKey, testVal);\n\n\t\t\t\t\t\tif (sessionStorage.getItem(testKey) === testVal) {\n\t\t\t\t\t\t\tsessionStorage.removeItem(testKey);\n\n\t\t\t\t\t\t\treturn sessionStorage;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tfunction() {\n\t\t\t\t\t// Try IE userData\n\t\t\t\t\tif (tinymce.isIE) {\n\t\t\t\t\t\ted.getElement().style.behavior = \"url('#default#userData')\";\n\n\t\t\t\t\t\t// Fake localStorage on old IE\n\t\t\t\t\t\treturn {\n\t\t\t\t\t\t\tautoExpires : TRUE,\n\n\t\t\t\t\t\t\tsetItem : function(key, value) {\n\t\t\t\t\t\t\t\tvar userDataElement = ed.getElement();\n\n\t\t\t\t\t\t\t\tuserDataElement.setAttribute(key, value);\n\t\t\t\t\t\t\t\tuserDataElement.expires = self.getExpDate();\n\n\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\tuserDataElement.save(\"TinyMCE\");\n\t\t\t\t\t\t\t\t} catch (e) {\n\t\t\t\t\t\t\t\t\t// Ignore, saving might fail if \"Userdata Persistence\" is disabled in IE\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t},\n\n\t\t\t\t\t\t\tgetItem : function(key) {\n\t\t\t\t\t\t\t\tvar userDataElement = ed.getElement();\n\n\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\tuserDataElement.load(\"TinyMCE\");\n\t\t\t\t\t\t\t\t\treturn userDataElement.getAttribute(key);\n\t\t\t\t\t\t\t\t} catch (e) {\n\t\t\t\t\t\t\t\t\t// Ignore, loading might fail if \"Userdata Persistence\" is disabled in IE\n\t\t\t\t\t\t\t\t\treturn null;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t},\n\n\t\t\t\t\t\t\tremoveItem : function(key) {\n\t\t\t\t\t\t\t\ted.getElement().removeAttribute(key);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t], function(setup) {\n\t\t\t\t// Try executing each function to find a suitable storage engine\n\t\t\t\ttry {\n\t\t\t\t\tself.storage = setup();\n\n\t\t\t\t\tif (self.storage)\n\t\t\t\t\t\treturn false;\n\t\t\t\t} catch (e) {\n\t\t\t\t\t// Ignore\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * This method will store the current contents in the storage engine.\n\t\t *\n\t\t * @method storeDraft\n\t\t */\n\t\tstoreDraft : function() {\n\t\t\tvar self = this, storage = self.storage, editor = self.editor, expires, content;\n\n\t\t\t// Is the contents dirty\n\t\t\tif (storage) {\n\t\t\t\t// If there is no existing key and the contents hasn't been changed since\n\t\t\t\t// it's original value then there is no point in saving a draft\n\t\t\t\tif (!storage.getItem(self.key) && !editor.isDirty())\n\t\t\t\t\treturn;\n\n\t\t\t\t// Store contents if the contents if longer than the minlength of characters\n\t\t\t\tcontent = editor.getContent({draft: true});\n\t\t\t\tif (content.length > editor.settings.autosave_minlength) {\n\t\t\t\t\texpires = self.getExpDate();\n\n\t\t\t\t\t// Store expiration date if needed IE userData has auto expire built in\n\t\t\t\t\tif (!self.storage.autoExpires)\n\t\t\t\t\t\tself.storage.setItem(self.key + \"_expires\", expires);\n\n\t\t\t\t\tself.storage.setItem(self.key, content);\n\t\t\t\t\tself.onStoreDraft.dispatch(self, {\n\t\t\t\t\t\texpires : expires,\n\t\t\t\t\t\tcontent : content\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * This method will restore the contents from the storage engine back to the editor.\n\t\t *\n\t\t * @method restoreDraft\n\t\t */\n\t\trestoreDraft : function() {\n\t\t\tvar self = this, storage = self.storage, content;\n\n\t\t\tif (storage) {\n\t\t\t\tcontent = storage.getItem(self.key);\n\n\t\t\t\tif (content) {\n\t\t\t\t\tself.editor.setContent(content);\n\t\t\t\t\tself.onRestoreDraft.dispatch(self, {\n\t\t\t\t\t\tcontent : content\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * This method will return true/false if there is a local storage draft available.\n\t\t *\n\t\t * @method hasDraft\n\t\t * @return {boolean} true/false state if there is a local draft.\n\t\t */\n\t\thasDraft : function() {\n\t\t\tvar self = this, storage = self.storage, expDate, exists;\n\n\t\t\tif (storage) {\n\t\t\t\t// Does the item exist at all\n\t\t\t\texists = !!storage.getItem(self.key);\n\t\t\t\tif (exists) {\n\t\t\t\t\t// Storage needs autoexpire\n\t\t\t\t\tif (!self.storage.autoExpires) {\n\t\t\t\t\t\texpDate = new Date(storage.getItem(self.key + \"_expires\"));\n\n\t\t\t\t\t\t// Contents hasn't expired\n\t\t\t\t\t\tif (new Date().getTime() < expDate.getTime())\n\t\t\t\t\t\t\treturn TRUE;\n\n\t\t\t\t\t\t// Remove it if it has\n\t\t\t\t\t\tself.removeDraft();\n\t\t\t\t\t} else\n\t\t\t\t\t\treturn TRUE;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn false;\n\t\t},\n\n\t\t/**\n\t\t * Removes the currently stored draft.\n\t\t *\n\t\t * @method removeDraft\n\t\t */\n\t\tremoveDraft : function() {\n\t\t\tvar self = this, storage = self.storage, key = self.key, content;\n\n\t\t\tif (storage) {\n\t\t\t\t// Get current contents and remove the existing draft\n\t\t\t\tcontent = storage.getItem(key);\n\t\t\t\tstorage.removeItem(key);\n\t\t\t\tstorage.removeItem(key + \"_expires\");\n\n\t\t\t\t// Dispatch remove event if we had any contents\n\t\t\t\tif (content) {\n\t\t\t\t\tself.onRemoveDraft.dispatch(self, {\n\t\t\t\t\t\tcontent : content\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t\"static\" : {\n\t\t\t// Internal unload handler will be called before the page is unloaded\n\t\t\t_beforeUnloadHandler : function(e) {\n\t\t\t\tvar msg;\n\n\t\t\t\ttinymce.each(tinyMCE.editors, function(ed) {\n\t\t\t\t\t// Store a draft for each editor instance\n\t\t\t\t\tif (ed.plugins.autosave)\n\t\t\t\t\t\ted.plugins.autosave.storeDraft();\n\n\t\t\t\t\t// Never ask in fullscreen mode\n\t\t\t\t\tif (ed.getParam(\"fullscreen_is_enabled\"))\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Setup a return message if the editor is dirty\n\t\t\t\t\tif (!msg && ed.isDirty() && ed.getParam(\"autosave_ask_before_unload\"))\n\t\t\t\t\t\tmsg = ed.getLang(\"autosave.unload_msg\");\n\t\t\t\t});\n\n\t\t\t\treturn msg;\n\t\t\t}\n\t\t}\n\t});\n\n\ttinymce.PluginManager.add('autosave', tinymce.plugins.AutoSave);\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/plugins/autosave/langs/en.js":"tinyMCE.addI18n('en.autosave',{\nrestore_content: \"Restore auto-saved content\",\nwarning_message: \"If you restore the saved content, you will lose all the content that is currently in the editor.\\n\\nAre you sure you want to restore the saved content?\"\n});","Magento_Tinymce3/tiny_mce/plugins/layer/editor_plugin.js":"(function(){function a(b){do{if(b.className&&b.className.indexOf(\"mceItemLayer\")!=-1){return b}}while(b=b.parentNode)}tinymce.create(\"tinymce.plugins.Layer\",{init:function(b,c){var d=this;d.editor=b;b.addCommand(\"mceInsertLayer\",d._insertLayer,d);b.addCommand(\"mceMoveForward\",function(){d._move(1)});b.addCommand(\"mceMoveBackward\",function(){d._move(-1)});b.addCommand(\"mceMakeAbsolute\",function(){d._toggleAbsolute()});b.addButton(\"moveforward\",{title:\"layer.forward_desc\",cmd:\"mceMoveForward\"});b.addButton(\"movebackward\",{title:\"layer.backward_desc\",cmd:\"mceMoveBackward\"});b.addButton(\"absolute\",{title:\"layer.absolute_desc\",cmd:\"mceMakeAbsolute\"});b.addButton(\"insertlayer\",{title:\"layer.insertlayer_desc\",cmd:\"mceInsertLayer\"});b.onInit.add(function(){var e=b.dom;if(tinymce.isIE){b.getDoc().execCommand(\"2D-Position\",false,true)}});b.onMouseUp.add(function(f,h){var g=a(h.target);if(g){f.dom.setAttrib(g,\"data-mce-style\",\"\")}});b.onMouseDown.add(function(f,j){var h=j.target,i=f.getDoc(),g;if(tinymce.isGecko){if(a(h)){if(i.designMode!==\"on\"){i.designMode=\"on\";h=i.body;g=h.parentNode;g.removeChild(h);g.appendChild(h)}}else{if(i.designMode==\"on\"){i.designMode=\"off\"}}}});b.onNodeChange.add(d._nodeChange,d);b.onVisualAid.add(d._visualAid,d)},getInfo:function(){return{longname:\"Layer\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/layer\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}},_nodeChange:function(c,b,f){var d,e;d=this._getParentLayer(f);e=c.dom.getParent(f,\"DIV,P,IMG\");if(!e){b.setDisabled(\"absolute\",1);b.setDisabled(\"moveforward\",1);b.setDisabled(\"movebackward\",1)}else{b.setDisabled(\"absolute\",0);b.setDisabled(\"moveforward\",!d);b.setDisabled(\"movebackward\",!d);b.setActive(\"absolute\",d&&d.style.position.toLowerCase()==\"absolute\")}},_visualAid:function(b,d,c){var f=b.dom;tinymce.each(f.select(\"div,p\",d),function(g){if(/^(absolute|relative|fixed)$/i.test(g.style.position)){if(c){f.addClass(g,\"mceItemVisualAid\")}else{f.removeClass(g,\"mceItemVisualAid\")}f.addClass(g,\"mceItemLayer\")}})},_move:function(j){var c=this.editor,g,h=[],f=this._getParentLayer(c.selection.getNode()),e=-1,k=-1,b;b=[];tinymce.walk(c.getBody(),function(d){if(d.nodeType==1&&/^(absolute|relative|static)$/i.test(d.style.position)){b.push(d)}},\"childNodes\");for(g=0;g<b.length;g++){h[g]=b[g].style.zIndex?parseInt(b[g].style.zIndex):0;if(e<0&&b[g]==f){e=g}}if(j<0){for(g=0;g<h.length;g++){if(h[g]<h[e]){k=g;break}}if(k>-1){b[e].style.zIndex=h[k];b[k].style.zIndex=h[e]}else{if(h[e]>0){b[e].style.zIndex=h[e]-1}}}else{for(g=0;g<h.length;g++){if(h[g]>h[e]){k=g;break}}if(k>-1){b[e].style.zIndex=h[k];b[k].style.zIndex=h[e]}else{b[e].style.zIndex=h[e]+1}}c.execCommand(\"mceRepaint\")},_getParentLayer:function(b){return this.editor.dom.getParent(b,function(c){return c.nodeType==1&&/^(absolute|relative|static)$/i.test(c.style.position)})},_insertLayer:function(){var c=this.editor,e=c.dom,d=e.getPos(e.getParent(c.selection.getNode(),\"*\")),b=c.getBody();c.dom.add(b,\"div\",{style:{position:\"absolute\",left:d.x,top:(d.y>20?d.y:20),width:100,height:100},\"class\":\"mceItemVisualAid mceItemLayer\"},c.selection.getContent()||c.getLang(\"layer.content\"));if(tinymce.isIE){e.setHTML(b,b.innerHTML)}},_toggleAbsolute:function(){var b=this.editor,c=this._getParentLayer(b.selection.getNode());if(!c){c=b.dom.getParent(b.selection.getNode(),\"DIV,P,IMG\")}if(c){if(c.style.position.toLowerCase()==\"absolute\"){b.dom.setStyles(c,{position:\"\",left:\"\",top:\"\",width:\"\",height:\"\"});b.dom.removeClass(c,\"mceItemVisualAid\");b.dom.removeClass(c,\"mceItemLayer\")}else{if(c.style.left==\"\"){c.style.left=20+\"px\"}if(c.style.top==\"\"){c.style.top=20+\"px\"}if(c.style.width==\"\"){c.style.width=c.width?(c.width+\"px\"):\"100px\"}if(c.style.height==\"\"){c.style.height=c.height?(c.height+\"px\"):\"100px\"}c.style.position=\"absolute\";b.dom.setAttrib(c,\"data-mce-style\",\"\");b.addVisual(b.getBody())}b.execCommand(\"mceRepaint\");b.nodeChanged()}}});tinymce.PluginManager.add(\"layer\",tinymce.plugins.Layer)})();","Magento_Tinymce3/tiny_mce/plugins/layer/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\tfunction findParentLayer(node) {\n\t\tdo {\n\t\t\tif (node.className && node.className.indexOf('mceItemLayer') != -1) {\n\t\t\t\treturn node;\n\t\t\t}\n\t\t} while (node = node.parentNode);\n\t};\n\n\ttinymce.create('tinymce.plugins.Layer', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this;\n\n\t\t\tt.editor = ed;\n\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceInsertLayer', t._insertLayer, t);\n\n\t\t\ted.addCommand('mceMoveForward', function() {\n\t\t\t\tt._move(1);\n\t\t\t});\n\n\t\t\ted.addCommand('mceMoveBackward', function() {\n\t\t\t\tt._move(-1);\n\t\t\t});\n\n\t\t\ted.addCommand('mceMakeAbsolute', function() {\n\t\t\t\tt._toggleAbsolute();\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('moveforward', {title : 'layer.forward_desc', cmd : 'mceMoveForward'});\n\t\t\ted.addButton('movebackward', {title : 'layer.backward_desc', cmd : 'mceMoveBackward'});\n\t\t\ted.addButton('absolute', {title : 'layer.absolute_desc', cmd : 'mceMakeAbsolute'});\n\t\t\ted.addButton('insertlayer', {title : 'layer.insertlayer_desc', cmd : 'mceInsertLayer'});\n\n\t\t\ted.onInit.add(function() {\n\t\t\t\tvar dom = ed.dom;\n\n\t\t\t\tif (tinymce.isIE)\n\t\t\t\t\ted.getDoc().execCommand('2D-Position', false, true);\n\t\t\t});\n\n\t\t\t// Remove serialized styles when selecting a layer since it might be changed by a drag operation\n\t\t\ted.onMouseUp.add(function(ed, e) {\n\t\t\t\tvar layer = findParentLayer(e.target);\n\t\n\t\t\t\tif (layer) {\n\t\t\t\t\ted.dom.setAttrib(layer, 'data-mce-style', '');\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Fixes edit focus issues with layers on Gecko\n\t\t\t// This will enable designMode while inside a layer and disable it when outside\n\t\t\ted.onMouseDown.add(function(ed, e) {\n\t\t\t\tvar node = e.target, doc = ed.getDoc(), parent;\n\n\t\t\t\tif (tinymce.isGecko) {\n\t\t\t\t\tif (findParentLayer(node)) {\n\t\t\t\t\t\tif (doc.designMode !== 'on') {\n\t\t\t\t\t\t\tdoc.designMode = 'on';\n\n\t\t\t\t\t\t\t// Repaint caret\n\t\t\t\t\t\t\tnode = doc.body;\n\t\t\t\t\t\t\tparent = node.parentNode;\n\t\t\t\t\t\t\tparent.removeChild(node);\n\t\t\t\t\t\t\tparent.appendChild(node);\n\t\t\t\t\t\t}\n\t\t\t\t\t} else if (doc.designMode == 'on') {\n\t\t\t\t\t\tdoc.designMode = 'off';\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\ted.onNodeChange.add(t._nodeChange, t);\n\t\t\ted.onVisualAid.add(t._visualAid, t);\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Layer',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/layer',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t},\n\n\t\t// Private methods\n\n\t\t_nodeChange : function(ed, cm, n) {\n\t\t\tvar le, p;\n\n\t\t\tle = this._getParentLayer(n);\n\t\t\tp = ed.dom.getParent(n, 'DIV,P,IMG');\n\n\t\t\tif (!p) {\n\t\t\t\tcm.setDisabled('absolute', 1);\n\t\t\t\tcm.setDisabled('moveforward', 1);\n\t\t\t\tcm.setDisabled('movebackward', 1);\n\t\t\t} else {\n\t\t\t\tcm.setDisabled('absolute', 0);\n\t\t\t\tcm.setDisabled('moveforward', !le);\n\t\t\t\tcm.setDisabled('movebackward', !le);\n\t\t\t\tcm.setActive('absolute', le && le.style.position.toLowerCase() == \"absolute\");\n\t\t\t}\n\t\t},\n\n\t\t// Private methods\n\n\t\t_visualAid : function(ed, e, s) {\n\t\t\tvar dom = ed.dom;\n\n\t\t\ttinymce.each(dom.select('div,p', e), function(e) {\n\t\t\t\tif (/^(absolute|relative|fixed)$/i.test(e.style.position)) {\n\t\t\t\t\tif (s)\n\t\t\t\t\t\tdom.addClass(e, 'mceItemVisualAid');\n\t\t\t\t\telse\n\t\t\t\t\t\tdom.removeClass(e, 'mceItemVisualAid');\n\n\t\t\t\t\tdom.addClass(e, 'mceItemLayer');\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\t_move : function(d) {\n\t\t\tvar ed = this.editor, i, z = [], le = this._getParentLayer(ed.selection.getNode()), ci = -1, fi = -1, nl;\n\n\t\t\tnl = [];\n\t\t\ttinymce.walk(ed.getBody(), function(n) {\n\t\t\t\tif (n.nodeType == 1 && /^(absolute|relative|static)$/i.test(n.style.position))\n\t\t\t\t\tnl.push(n); \n\t\t\t}, 'childNodes');\n\n\t\t\t// Find z-indexes\n\t\t\tfor (i=0; i<nl.length; i++) {\n\t\t\t\tz[i] = nl[i].style.zIndex ? parseInt(nl[i].style.zIndex) : 0;\n\n\t\t\t\tif (ci < 0 && nl[i] == le)\n\t\t\t\t\tci = i;\n\t\t\t}\n\n\t\t\tif (d < 0) {\n\t\t\t\t// Move back\n\n\t\t\t\t// Try find a lower one\n\t\t\t\tfor (i=0; i<z.length; i++) {\n\t\t\t\t\tif (z[i] < z[ci]) {\n\t\t\t\t\t\tfi = i;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (fi > -1) {\n\t\t\t\t\tnl[ci].style.zIndex = z[fi];\n\t\t\t\t\tnl[fi].style.zIndex = z[ci];\n\t\t\t\t} else {\n\t\t\t\t\tif (z[ci] > 0)\n\t\t\t\t\t\tnl[ci].style.zIndex = z[ci] - 1;\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Move forward\n\n\t\t\t\t// Try find a higher one\n\t\t\t\tfor (i=0; i<z.length; i++) {\n\t\t\t\t\tif (z[i] > z[ci]) {\n\t\t\t\t\t\tfi = i;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (fi > -1) {\n\t\t\t\t\tnl[ci].style.zIndex = z[fi];\n\t\t\t\t\tnl[fi].style.zIndex = z[ci];\n\t\t\t\t} else\n\t\t\t\t\tnl[ci].style.zIndex = z[ci] + 1;\n\t\t\t}\n\n\t\t\ted.execCommand('mceRepaint');\n\t\t},\n\n\t\t_getParentLayer : function(n) {\n\t\t\treturn this.editor.dom.getParent(n, function(n) {\n\t\t\t\treturn n.nodeType == 1 && /^(absolute|relative|static)$/i.test(n.style.position);\n\t\t\t});\n\t\t},\n\n\t\t_insertLayer : function() {\n\t\t\tvar ed = this.editor, dom = ed.dom, p = dom.getPos(dom.getParent(ed.selection.getNode(), '*')), body = ed.getBody();\n\n\t\t\ted.dom.add(body, 'div', {\n\t\t\t\tstyle : {\n\t\t\t\t\tposition : 'absolute',\n\t\t\t\t\tleft : p.x,\n\t\t\t\t\ttop : (p.y > 20 ? p.y : 20),\n\t\t\t\t\twidth : 100,\n\t\t\t\t\theight : 100\n\t\t\t\t},\n\t\t\t\t'class' : 'mceItemVisualAid mceItemLayer'\n\t\t\t}, ed.selection.getContent() || ed.getLang('layer.content'));\n\n\t\t\t// Workaround for IE where it messes up the JS engine if you insert a layer on IE 6,7\n\t\t\tif (tinymce.isIE)\n\t\t\t\tdom.setHTML(body, body.innerHTML);\n\t\t},\n\n\t\t_toggleAbsolute : function() {\n\t\t\tvar ed = this.editor, le = this._getParentLayer(ed.selection.getNode());\n\n\t\t\tif (!le)\n\t\t\t\tle = ed.dom.getParent(ed.selection.getNode(), 'DIV,P,IMG');\n\n\t\t\tif (le) {\n\t\t\t\tif (le.style.position.toLowerCase() == \"absolute\") {\n\t\t\t\t\ted.dom.setStyles(le, {\n\t\t\t\t\t\tposition : '',\n\t\t\t\t\t\tleft : '',\n\t\t\t\t\t\ttop : '',\n\t\t\t\t\t\twidth : '',\n\t\t\t\t\t\theight : ''\n\t\t\t\t\t});\n\n\t\t\t\t\ted.dom.removeClass(le, 'mceItemVisualAid');\n\t\t\t\t\ted.dom.removeClass(le, 'mceItemLayer');\n\t\t\t\t} else {\n\t\t\t\t\tif (le.style.left == \"\")\n\t\t\t\t\t\tle.style.left = 20 + 'px';\n\n\t\t\t\t\tif (le.style.top == \"\")\n\t\t\t\t\t\tle.style.top = 20 + 'px';\n\n\t\t\t\t\tif (le.style.width == \"\")\n\t\t\t\t\t\tle.style.width = le.width ? (le.width + 'px') : '100px';\n\n\t\t\t\t\tif (le.style.height == \"\")\n\t\t\t\t\t\tle.style.height = le.height ? (le.height + 'px') : '100px';\n\n\t\t\t\t\tle.style.position = \"absolute\";\n\n\t\t\t\t\ted.dom.setAttrib(le, 'data-mce-style', '');\n\t\t\t\t\ted.addVisual(ed.getBody());\n\t\t\t\t}\n\n\t\t\t\ted.execCommand('mceRepaint');\n\t\t\t\ted.nodeChanged();\n\t\t\t}\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('layer', tinymce.plugins.Layer);\n})();","Magento_Tinymce3/tiny_mce/plugins/table/editor_plugin.js":"(function(d){var e=d.each;function c(g,h){var j=h.ownerDocument,f=j.createRange(),k;f.setStartBefore(h);f.setEnd(g.endContainer,g.endOffset);k=j.createElement(\"body\");k.appendChild(f.cloneContents());return k.innerHTML.replace(/<(br|img|object|embed|input|textarea)[^>]*>/gi,\"-\").replace(/<[^>]+>/g,\"\").length==0}function a(g,f){return parseInt(g.getAttribute(f)||1)}function b(H,G,K){var g,L,D,o;t();o=G.getParent(K.getStart(),\"th,td\");if(o){L=F(o);D=I();o=z(L.x,L.y)}function A(N,M){N=N.cloneNode(M);N.removeAttribute(\"id\");return N}function t(){var M=0;g=[];e([\"thead\",\"tbody\",\"tfoot\"],function(N){var O=G.select(\"> \"+N+\" tr\",H);e(O,function(P,Q){Q+=M;e(G.select(\"> td, > th\",P),function(W,R){var S,T,U,V;if(g[Q]){while(g[Q][R]){R++}}U=a(W,\"rowspan\");V=a(W,\"colspan\");for(T=Q;T<Q+U;T++){if(!g[T]){g[T]=[]}for(S=R;S<R+V;S++){g[T][S]={part:N,real:T==Q&&S==R,elm:W,rowspan:U,colspan:V}}}})});M+=O.length})}function z(M,O){var N;N=g[O];if(N){return N[M]}}function s(O,M,N){if(O){N=parseInt(N);if(N===1){O.removeAttribute(M,1)}else{O.setAttribute(M,N,1)}}}function j(M){return M&&(G.hasClass(M.elm,\"mceSelected\")||M==o)}function k(){var M=[];e(H.rows,function(N){e(N.cells,function(O){if(G.hasClass(O,\"mceSelected\")||O==o.elm){M.push(N);return false}})});return M}function r(){var M=G.createRng();M.setStartAfter(H);M.setEndAfter(H);K.setRng(M);G.remove(H)}function f(M){var N;d.walk(M,function(P){var O;if(P.nodeType==3){e(G.getParents(P.parentNode,null,M).reverse(),function(Q){Q=A(Q,false);if(!N){N=O=Q}else{if(O){O.appendChild(Q)}}O=Q});if(O){O.innerHTML=d.isIE?\"&nbsp;\":'<br data-mce-bogus=\"1\" />'}return false}},\"childNodes\");M=A(M,false);s(M,\"rowSpan\",1);s(M,\"colSpan\",1);if(N){M.appendChild(N)}else{if(!d.isIE){M.innerHTML='<br data-mce-bogus=\"1\" />'}}return M}function q(){var M=G.createRng();e(G.select(\"tr\",H),function(N){if(N.cells.length==0){G.remove(N)}});if(G.select(\"tr\",H).length==0){M.setStartAfter(H);M.setEndAfter(H);K.setRng(M);G.remove(H);return}e(G.select(\"thead,tbody,tfoot\",H),function(N){if(N.rows.length==0){G.remove(N)}});t();row=g[Math.min(g.length-1,L.y)];if(row){K.select(row[Math.min(row.length-1,L.x)].elm,true);K.collapse(true)}}function u(S,Q,U,R){var P,N,M,O,T;P=g[Q][S].elm.parentNode;for(M=1;M<=U;M++){P=G.getNext(P,\"tr\");if(P){for(N=S;N>=0;N--){T=g[Q+M][N].elm;if(T.parentNode==P){for(O=1;O<=R;O++){G.insertAfter(f(T),T)}break}}if(N==-1){for(O=1;O<=R;O++){P.insertBefore(f(P.cells[0]),P.cells[0])}}}}}function C(){e(g,function(M,N){e(M,function(P,O){var S,R,T,Q;if(j(P)){P=P.elm;S=a(P,\"colspan\");R=a(P,\"rowspan\");if(S>1||R>1){s(P,\"rowSpan\",1);s(P,\"colSpan\",1);for(Q=0;Q<S-1;Q++){G.insertAfter(f(P),P)}u(O,N,R-1,S)}}})})}function p(V,S,Y){var P,O,X,W,U,R,T,M,V,N,Q;if(V){pos=F(V);P=pos.x;O=pos.y;X=P+(S-1);W=O+(Y-1)}else{P=L.x;O=L.y;X=D.x;W=D.y}T=z(P,O);M=z(X,W);if(T&&M&&T.part==M.part){C();t();T=z(P,O).elm;s(T,\"colSpan\",(X-P)+1);s(T,\"rowSpan\",(W-O)+1);for(R=O;R<=W;R++){for(U=P;U<=X;U++){if(!g[R]||!g[R][U]){continue}V=g[R][U].elm;if(V!=T){N=d.grep(V.childNodes);e(N,function(Z){T.appendChild(Z)});if(N.length){N=d.grep(T.childNodes);Q=0;e(N,function(Z){if(Z.nodeName==\"BR\"&&G.getAttrib(Z,\"data-mce-bogus\")&&Q++<N.length-1){T.removeChild(Z)}})}G.remove(V)}}}q()}}function l(Q){var M,S,P,R,T,U,N,V,O;e(g,function(W,X){e(W,function(Z,Y){if(j(Z)){Z=Z.elm;T=Z.parentNode;U=A(T,false);M=X;if(Q){return false}}});if(Q){return !M}});for(R=0;R<g[0].length;R++){if(!g[M][R]){continue}S=g[M][R].elm;if(S!=P){if(!Q){O=a(S,\"rowspan\");if(O>1){s(S,\"rowSpan\",O+1);continue}}else{if(M>0&&g[M-1][R]){V=g[M-1][R].elm;O=a(V,\"rowSpan\");if(O>1){s(V,\"rowSpan\",O+1);continue}}}N=f(S);s(N,\"colSpan\",S.colSpan);U.appendChild(N);P=S}}if(U.hasChildNodes()){if(!Q){G.insertAfter(U,T)}else{T.parentNode.insertBefore(U,T)}}}function h(N){var O,M;e(g,function(P,Q){e(P,function(S,R){if(j(S)){O=R;if(N){return false}}});if(N){return !O}});e(g,function(S,T){var P,Q,R;if(!S[O]){return}P=S[O].elm;if(P!=M){R=a(P,\"colspan\");Q=a(P,\"rowspan\");if(R==1){if(!N){G.insertAfter(f(P),P);u(O,T,Q-1,R)}else{P.parentNode.insertBefore(f(P),P);u(O,T,Q-1,R)}}else{s(P,\"colSpan\",P.colSpan+1)}M=P}})}function n(){var M=[];e(g,function(N,O){e(N,function(Q,P){if(j(Q)&&d.inArray(M,P)===-1){e(g,function(T){var R=T[P].elm,S;S=a(R,\"colSpan\");if(S>1){s(R,\"colSpan\",S-1)}else{G.remove(R)}});M.push(P)}})});q()}function m(){var N;function M(Q){var P,R,O;P=G.getNext(Q,\"tr\");e(Q.cells,function(S){var T=a(S,\"rowSpan\");if(T>1){s(S,\"rowSpan\",T-1);R=F(S);u(R.x,R.y,1,1)}});R=F(Q.cells[0]);e(g[R.y],function(S){var T;S=S.elm;if(S!=O){T=a(S,\"rowSpan\");if(T<=1){G.remove(S)}else{s(S,\"rowSpan\",T-1)}O=S}})}N=k();e(N.reverse(),function(O){M(O)});q()}function E(){var M=k();G.remove(M);q();return M}function J(){var M=k();e(M,function(O,N){M[N]=A(O,true)});return M}function B(O,N){var P=k(),M=P[N?0:P.length-1],Q=M.cells.length;e(g,function(S){var R;Q=0;e(S,function(U,T){if(U.real){Q+=U.colspan}if(U.elm.parentNode==M){R=1}});if(R){return false}});if(!N){O.reverse()}e(O,function(T){var S=T.cells.length,R;for(i=0;i<S;i++){R=T.cells[i];s(R,\"colSpan\",1);s(R,\"rowSpan\",1)}for(i=S;i<Q;i++){T.appendChild(f(T.cells[S-1]))}for(i=Q;i<S;i++){G.remove(T.cells[i])}if(N){M.parentNode.insertBefore(T,M)}else{G.insertAfter(T,M)}})}function F(M){var N;e(g,function(O,P){e(O,function(R,Q){if(R.elm==M){N={x:Q,y:P};return false}});return !N});return N}function w(M){L=F(M)}function I(){var O,N,M;N=M=0;e(g,function(P,Q){e(P,function(S,R){var U,T;if(j(S)){S=g[Q][R];if(R>N){N=R}if(Q>M){M=Q}if(S.real){U=S.colspan-1;T=S.rowspan-1;if(U){if(R+U>N){N=R+U}}if(T){if(Q+T>M){M=Q+T}}}}})});return{x:N,y:M}}function v(S){var P,O,U,T,N,M,Q,R;D=F(S);if(L&&D){P=Math.min(L.x,D.x);O=Math.min(L.y,D.y);U=Math.max(L.x,D.x);T=Math.max(L.y,D.y);N=U;M=T;for(y=O;y<=M;y++){S=g[y][P];if(!S.real){if(P-(S.colspan-1)<P){P-=S.colspan-1}}}for(x=P;x<=N;x++){S=g[O][x];if(!S.real){if(O-(S.rowspan-1)<O){O-=S.rowspan-1}}}for(y=O;y<=T;y++){for(x=P;x<=U;x++){S=g[y][x];if(S.real){Q=S.colspan-1;R=S.rowspan-1;if(Q){if(x+Q>N){N=x+Q}}if(R){if(y+R>M){M=y+R}}}}}G.removeClass(G.select(\"td.mceSelected,th.mceSelected\"),\"mceSelected\");for(y=O;y<=M;y++){for(x=P;x<=N;x++){if(g[y][x]){G.addClass(g[y][x].elm,\"mceSelected\")}}}}}d.extend(this,{deleteTable:r,split:C,merge:p,insertRow:l,insertCol:h,deleteCols:n,deleteRows:m,cutRows:E,copyRows:J,pasteRows:B,getPos:F,setStartCell:w,setEndCell:v})}d.create(\"tinymce.plugins.TablePlugin\",{init:function(g,h){var f,m,j=true;function l(p){var o=g.selection,n=g.dom.getParent(p||o.getNode(),\"table\");if(n){return new b(n,g.dom,o)}}function k(){g.getBody().style.webkitUserSelect=\"\";if(j){g.dom.removeClass(g.dom.select(\"td.mceSelected,th.mceSelected\"),\"mceSelected\");j=false}}e([[\"table\",\"table.desc\",\"mceInsertTable\",true],[\"delete_table\",\"table.del\",\"mceTableDelete\"],[\"delete_col\",\"table.delete_col_desc\",\"mceTableDeleteCol\"],[\"delete_row\",\"table.delete_row_desc\",\"mceTableDeleteRow\"],[\"col_after\",\"table.col_after_desc\",\"mceTableInsertColAfter\"],[\"col_before\",\"table.col_before_desc\",\"mceTableInsertColBefore\"],[\"row_after\",\"table.row_after_desc\",\"mceTableInsertRowAfter\"],[\"row_before\",\"table.row_before_desc\",\"mceTableInsertRowBefore\"],[\"row_props\",\"table.row_desc\",\"mceTableRowProps\",true],[\"cell_props\",\"table.cell_desc\",\"mceTableCellProps\",true],[\"split_cells\",\"table.split_cells_desc\",\"mceTableSplitCells\",true],[\"merge_cells\",\"table.merge_cells_desc\",\"mceTableMergeCells\",true]],function(n){g.addButton(n[0],{title:n[1],cmd:n[2],ui:n[3]})});if(!d.isIE){g.onClick.add(function(n,o){o=o.target;if(o.nodeName===\"TABLE\"){n.selection.select(o);n.nodeChanged()}})}g.onPreProcess.add(function(o,p){var n,q,r,t=o.dom,s;n=t.select(\"table\",p.node);q=n.length;while(q--){r=n[q];t.setAttrib(r,\"data-mce-style\",\"\");if((s=t.getAttrib(r,\"width\"))){t.setStyle(r,\"width\",s);t.setAttrib(r,\"width\",\"\")}if((s=t.getAttrib(r,\"height\"))){t.setStyle(r,\"height\",s);t.setAttrib(r,\"height\",\"\")}}});g.onNodeChange.add(function(q,o,s){var r;s=q.selection.getStart();r=q.dom.getParent(s,\"td,th,caption\");o.setActive(\"table\",s.nodeName===\"TABLE\"||!!r);if(r&&r.nodeName===\"CAPTION\"){r=0}o.setDisabled(\"delete_table\",!r);o.setDisabled(\"delete_col\",!r);o.setDisabled(\"delete_table\",!r);o.setDisabled(\"delete_row\",!r);o.setDisabled(\"col_after\",!r);o.setDisabled(\"col_before\",!r);o.setDisabled(\"row_after\",!r);o.setDisabled(\"row_before\",!r);o.setDisabled(\"row_props\",!r);o.setDisabled(\"cell_props\",!r);o.setDisabled(\"split_cells\",!r);o.setDisabled(\"merge_cells\",!r)});g.onInit.add(function(r){var p,t,q=r.dom,u;f=r.windowManager;r.onMouseDown.add(function(w,z){if(z.button!=2){k();t=q.getParent(z.target,\"td,th\");p=q.getParent(t,\"table\")}});q.bind(r.getDoc(),\"mouseover\",function(C){var A,z,B=C.target;if(t&&(u||B!=t)&&(B.nodeName==\"TD\"||B.nodeName==\"TH\")){z=q.getParent(B,\"table\");if(z==p){if(!u){u=l(z);u.setStartCell(t);r.getBody().style.webkitUserSelect=\"none\"}u.setEndCell(B);j=true}A=r.selection.getSel();try{if(A.removeAllRanges){A.removeAllRanges()}else{A.empty()}}catch(w){}C.preventDefault()}});r.onMouseUp.add(function(F,G){var z,B=F.selection,H,I=B.getSel(),w,C,A,E;if(t){if(u){F.getBody().style.webkitUserSelect=\"\"}function D(J,L){var K=new d.dom.TreeWalker(J,J);do{if(J.nodeType==3&&d.trim(J.nodeValue).length!=0){if(L){z.setStart(J,0)}else{z.setEnd(J,J.nodeValue.length)}return}if(J.nodeName==\"BR\"){if(L){z.setStartBefore(J)}else{z.setEndBefore(J)}return}}while(J=(L?K.next():K.prev()))}H=q.select(\"td.mceSelected,th.mceSelected\");if(H.length>0){z=q.createRng();C=H[0];E=H[H.length-1];z.setStartBefore(C);z.setEndAfter(C);D(C,1);w=new d.dom.TreeWalker(C,q.getParent(H[0],\"table\"));do{if(C.nodeName==\"TD\"||C.nodeName==\"TH\"){if(!q.hasClass(C,\"mceSelected\")){break}A=C}}while(C=w.next());D(A);B.setRng(z)}F.nodeChanged();t=u=p=null}});r.onKeyUp.add(function(w,z){k()});r.onKeyDown.add(function(w,z){n(w)});r.onMouseDown.add(function(w,z){if(z.button!=2){n(w)}});function o(D,z,A,F){var B=3,G=D.dom.getParent(z.startContainer,\"TABLE\"),C,w,E;if(G){C=G.parentNode}w=z.startContainer.nodeType==B&&z.startOffset==0&&z.endOffset==0&&F&&(A.nodeName==\"TR\"||A==C);E=(A.nodeName==\"TD\"||A.nodeName==\"TH\")&&!F;return w||E}function n(A){if(!d.isWebKit){return}var z=A.selection.getRng();var C=A.selection.getNode();var B=A.dom.getParent(z.startContainer,\"TD,TH\");if(!o(A,z,C,B)){return}if(!B){B=C}var w=B.lastChild;while(w.lastChild){w=w.lastChild}z.setEnd(w,w.nodeValue.length);A.selection.setRng(z)}r.plugins.table.fixTableCellSelection=n;if(r&&r.plugins.contextmenu){r.plugins.contextmenu.onContextMenu.add(function(A,w,C){var D,B=r.selection,z=B.getNode()||r.getBody();if(r.dom.getParent(C,\"td\")||r.dom.getParent(C,\"th\")||r.dom.select(\"td.mceSelected,th.mceSelected\").length){w.removeAll();if(z.nodeName==\"A\"&&!r.dom.getAttrib(z,\"name\")){w.add({title:\"advanced.link_desc\",icon:\"link\",cmd:r.plugins.advlink?\"mceAdvLink\":\"mceLink\",ui:true});w.add({title:\"advanced.unlink_desc\",icon:\"unlink\",cmd:\"UnLink\"});w.addSeparator()}if(z.nodeName==\"IMG\"&&z.className.indexOf(\"mceItem\")==-1){w.add({title:\"advanced.image_desc\",icon:\"image\",cmd:r.plugins.advimage?\"mceAdvImage\":\"mceImage\",ui:true});w.addSeparator()}w.add({title:\"table.desc\",icon:\"table\",cmd:\"mceInsertTable\",value:{action:\"insert\"}});w.add({title:\"table.props_desc\",icon:\"table_props\",cmd:\"mceInsertTable\"});w.add({title:\"table.del\",icon:\"delete_table\",cmd:\"mceTableDelete\"});w.addSeparator();D=w.addMenu({title:\"table.cell\"});D.add({title:\"table.cell_desc\",icon:\"cell_props\",cmd:\"mceTableCellProps\"});D.add({title:\"table.split_cells_desc\",icon:\"split_cells\",cmd:\"mceTableSplitCells\"});D.add({title:\"table.merge_cells_desc\",icon:\"merge_cells\",cmd:\"mceTableMergeCells\"});D=w.addMenu({title:\"table.row\"});D.add({title:\"table.row_desc\",icon:\"row_props\",cmd:\"mceTableRowProps\"});D.add({title:\"table.row_before_desc\",icon:\"row_before\",cmd:\"mceTableInsertRowBefore\"});D.add({title:\"table.row_after_desc\",icon:\"row_after\",cmd:\"mceTableInsertRowAfter\"});D.add({title:\"table.delete_row_desc\",icon:\"delete_row\",cmd:\"mceTableDeleteRow\"});D.addSeparator();D.add({title:\"table.cut_row_desc\",icon:\"cut\",cmd:\"mceTableCutRow\"});D.add({title:\"table.copy_row_desc\",icon:\"copy\",cmd:\"mceTableCopyRow\"});D.add({title:\"table.paste_row_before_desc\",icon:\"paste\",cmd:\"mceTablePasteRowBefore\"}).setDisabled(!m);D.add({title:\"table.paste_row_after_desc\",icon:\"paste\",cmd:\"mceTablePasteRowAfter\"}).setDisabled(!m);D=w.addMenu({title:\"table.col\"});D.add({title:\"table.col_before_desc\",icon:\"col_before\",cmd:\"mceTableInsertColBefore\"});D.add({title:\"table.col_after_desc\",icon:\"col_after\",cmd:\"mceTableInsertColAfter\"});D.add({title:\"table.delete_col_desc\",icon:\"delete_col\",cmd:\"mceTableDeleteCol\"})}else{w.add({title:\"table.desc\",icon:\"table\",cmd:\"mceInsertTable\"})}})}if(d.isWebKit){function v(C,N){var L=d.VK;var Q=N.keyCode;function O(Y,U,S){var T=Y?\"previousSibling\":\"nextSibling\";var Z=C.dom.getParent(U,\"tr\");var X=Z[T];if(X){z(C,U,X,Y);d.dom.Event.cancel(S);return true}else{var aa=C.dom.getParent(Z,\"table\");var W=Z.parentNode;var R=W.nodeName.toLowerCase();if(R===\"tbody\"||R===(Y?\"tfoot\":\"thead\")){var V=w(Y,aa,W,\"tbody\");if(V!==null){return K(Y,V,U,S)}}return M(Y,Z,T,aa,S)}}function w(V,T,U,X){var S=C.dom.select(\">\"+X,T);var R=S.indexOf(U);if(V&&R===0||!V&&R===S.length-1){return B(V,T)}else{if(R===-1){var W=U.tagName.toLowerCase()===\"thead\"?0:S.length-1;return S[W]}else{return S[R+(V?-1:1)]}}}function B(U,T){var S=U?\"thead\":\"tfoot\";var R=C.dom.select(\">\"+S,T);return R.length!==0?R[0]:null}function K(V,T,S,U){var R=J(T,V);R&&z(C,S,R,V);d.dom.Event.cancel(U);return true}function M(Y,U,R,X,W){var S=X[R];if(S){F(S);return true}else{var V=C.dom.getParent(X,\"td,th\");if(V){return O(Y,V,W)}else{var T=J(U,!Y);F(T);return d.dom.Event.cancel(W)}}}function J(S,R){return S&&S[R?\"lastChild\":\"firstChild\"]}function F(R){C.selection.setCursorLocation(R,0)}function A(){return Q==L.UP||Q==L.DOWN}function D(R){var T=R.selection.getNode();var S=R.dom.getParent(T,\"tr\");return S!==null}function P(S){var R=0;var T=S;while(T.previousSibling){T=T.previousSibling;R=R+a(T,\"colspan\")}return R}function E(T,R){var U=0;var S=0;e(T.children,function(V,W){U=U+a(V,\"colspan\");S=W;if(U>R){return false}});return S}function z(T,W,Y,V){var X=P(T.dom.getParent(W,\"td,th\"));var S=E(Y,X);var R=Y.childNodes[S];var U=J(R,V);F(U||R)}function H(R){var T=C.selection.getNode();var U=C.dom.getParent(T,\"td,th\");var S=C.dom.getParent(R,\"td,th\");return U&&U!==S&&I(U,S)}function I(S,R){return C.dom.getParent(S,\"TABLE\")===C.dom.getParent(R,\"TABLE\")}if(A()&&D(C)){var G=C.selection.getNode();setTimeout(function(){if(H(G)){O(!N.shiftKey&&Q===L.UP,G,N)}},0)}}r.onKeyDown.add(v)}if(!d.isIE){function s(){var w;for(w=r.getBody().lastChild;w&&w.nodeType==3&&!w.nodeValue.length;w=w.previousSibling){}if(w&&w.nodeName==\"TABLE\"){r.dom.add(r.getBody(),\"p\",null,'<br mce_bogus=\"1\" />')}}if(d.isGecko){r.onKeyDown.add(function(z,B){var w,A,C=z.dom;if(B.keyCode==37||B.keyCode==38){w=z.selection.getRng();A=C.getParent(w.startContainer,\"table\");if(A&&z.getBody().firstChild==A){if(c(w,A)){w=C.createRng();w.setStartBefore(A);w.setEndBefore(A);z.selection.setRng(w);B.preventDefault()}}}})}r.onKeyUp.add(s);r.onSetContent.add(s);r.onVisualAid.add(s);r.onPreProcess.add(function(w,A){var z=A.node.lastChild;if(z&&z.childNodes.length==1&&z.firstChild.nodeName==\"BR\"){w.dom.remove(z)}});s();r.startContent=r.getContent({format:\"raw\"})}});e({mceTableSplitCells:function(n){n.split()},mceTableMergeCells:function(o){var p,q,n;n=g.dom.getParent(g.selection.getNode(),\"th,td\");if(n){p=n.rowSpan;q=n.colSpan}if(!g.dom.select(\"td.mceSelected,th.mceSelected\").length){f.open({url:h+\"/merge_cells.htm\",width:240+parseInt(g.getLang(\"table.merge_cells_delta_width\",0)),height:110+parseInt(g.getLang(\"table.merge_cells_delta_height\",0)),inline:1},{rows:p,cols:q,onaction:function(r){o.merge(n,r.cols,r.rows)},plugin_url:h})}else{o.merge()}},mceTableInsertRowBefore:function(n){n.insertRow(true)},mceTableInsertRowAfter:function(n){n.insertRow()},mceTableInsertColBefore:function(n){n.insertCol(true)},mceTableInsertColAfter:function(n){n.insertCol()},mceTableDeleteCol:function(n){n.deleteCols()},mceTableDeleteRow:function(n){n.deleteRows()},mceTableCutRow:function(n){m=n.cutRows()},mceTableCopyRow:function(n){m=n.copyRows()},mceTablePasteRowBefore:function(n){n.pasteRows(m,true)},mceTablePasteRowAfter:function(n){n.pasteRows(m)},mceTableDelete:function(n){n.deleteTable()}},function(o,n){g.addCommand(n,function(){var p=l();if(p){o(p);g.execCommand(\"mceRepaint\");k()}})});e({mceInsertTable:function(n){f.open({url:h+\"/table.htm\",width:400+parseInt(g.getLang(\"table.table_delta_width\",0)),height:320+parseInt(g.getLang(\"table.table_delta_height\",0)),inline:1},{plugin_url:h,action:n?n.action:0})},mceTableRowProps:function(){f.open({url:h+\"/row.htm\",width:400+parseInt(g.getLang(\"table.rowprops_delta_width\",0)),height:295+parseInt(g.getLang(\"table.rowprops_delta_height\",0)),inline:1},{plugin_url:h})},mceTableCellProps:function(){f.open({url:h+\"/cell.htm\",width:400+parseInt(g.getLang(\"table.cellprops_delta_width\",0)),height:295+parseInt(g.getLang(\"table.cellprops_delta_height\",0)),inline:1},{plugin_url:h})}},function(o,n){g.addCommand(n,function(p,q){o(q)})})}});d.PluginManager.add(\"table\",d.plugins.TablePlugin)})(tinymce);","Magento_Tinymce3/tiny_mce/plugins/table/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\tvar each = tinymce.each;\n\n\t// Checks if the selection/caret is at the start of the specified block element\n\tfunction isAtStart(rng, par) {\n\t\tvar doc = par.ownerDocument, rng2 = doc.createRange(), elm;\n\n\t\trng2.setStartBefore(par);\n\t\trng2.setEnd(rng.endContainer, rng.endOffset);\n\n\t\telm = doc.createElement('body');\n\t\telm.appendChild(rng2.cloneContents());\n\n\t\t// Check for text characters of other elements that should be treated as content\n\t\treturn elm.innerHTML.replace(/<(br|img|object|embed|input|textarea)[^>]*>/gi, '-').replace(/<[^>]+>/g, '').length == 0;\n\t};\n\n\tfunction getSpanVal(td, name) {\n\t\treturn parseInt(td.getAttribute(name) || 1);\n\t}\n\n\t/**\n\t * Table Grid class.\n\t */\n\tfunction TableGrid(table, dom, selection) {\n\t\tvar grid, startPos, endPos, selectedCell;\n\n\t\tbuildGrid();\n\t\tselectedCell = dom.getParent(selection.getStart(), 'th,td');\n\t\tif (selectedCell) {\n\t\t\tstartPos = getPos(selectedCell);\n\t\t\tendPos = findEndPos();\n\t\t\tselectedCell = getCell(startPos.x, startPos.y);\n\t\t}\n\n\t\tfunction cloneNode(node, children) {\n\t\t\tnode = node.cloneNode(children);\n\t\t\tnode.removeAttribute('id');\n\n\t\t\treturn node;\n\t\t}\n\n\t\tfunction buildGrid() {\n\t\t\tvar startY = 0;\n\n\t\t\tgrid = [];\n\n\t\t\teach(['thead', 'tbody', 'tfoot'], function(part) {\n\t\t\t\tvar rows = dom.select('> ' + part + ' tr', table);\n\n\t\t\t\teach(rows, function(tr, y) {\n\t\t\t\t\ty += startY;\n\n\t\t\t\t\teach(dom.select('> td, > th', tr), function(td, x) {\n\t\t\t\t\t\tvar x2, y2, rowspan, colspan;\n\n\t\t\t\t\t\t// Skip over existing cells produced by rowspan\n\t\t\t\t\t\tif (grid[y]) {\n\t\t\t\t\t\t\twhile (grid[y][x])\n\t\t\t\t\t\t\t\tx++;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Get col/rowspan from cell\n\t\t\t\t\t\trowspan = getSpanVal(td, 'rowspan');\n\t\t\t\t\t\tcolspan = getSpanVal(td, 'colspan');\n\n\t\t\t\t\t\t// Fill out rowspan/colspan right and down\n\t\t\t\t\t\tfor (y2 = y; y2 < y + rowspan; y2++) {\n\t\t\t\t\t\t\tif (!grid[y2])\n\t\t\t\t\t\t\t\tgrid[y2] = [];\n\n\t\t\t\t\t\t\tfor (x2 = x; x2 < x + colspan; x2++) {\n\t\t\t\t\t\t\t\tgrid[y2][x2] = {\n\t\t\t\t\t\t\t\t\tpart : part,\n\t\t\t\t\t\t\t\t\treal : y2 == y && x2 == x,\n\t\t\t\t\t\t\t\t\telm : td,\n\t\t\t\t\t\t\t\t\trowspan : rowspan,\n\t\t\t\t\t\t\t\t\tcolspan : colspan\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t});\n\n\t\t\t\tstartY += rows.length;\n\t\t\t});\n\t\t};\n\n\t\tfunction getCell(x, y) {\n\t\t\tvar row;\n\n\t\t\trow = grid[y];\n\t\t\tif (row)\n\t\t\t\treturn row[x];\n\t\t};\n\n\t\tfunction setSpanVal(td, name, val) {\n\t\t\tif (td) {\n\t\t\t\tval = parseInt(val);\n\n\t\t\t\tif (val === 1)\n\t\t\t\t\ttd.removeAttribute(name, 1);\n\t\t\t\telse\n\t\t\t\t\ttd.setAttribute(name, val, 1);\n\t\t\t}\n\t\t}\n\n\t\tfunction isCellSelected(cell) {\n\t\t\treturn cell && (dom.hasClass(cell.elm, 'mceSelected') || cell == selectedCell);\n\t\t};\n\n\t\tfunction getSelectedRows() {\n\t\t\tvar rows = [];\n\n\t\t\teach(table.rows, function(row) {\n\t\t\t\teach(row.cells, function(cell) {\n\t\t\t\t\tif (dom.hasClass(cell, 'mceSelected') || cell == selectedCell.elm) {\n\t\t\t\t\t\trows.push(row);\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t});\n\n\t\t\treturn rows;\n\t\t};\n\n\t\tfunction deleteTable() {\n\t\t\tvar rng = dom.createRng();\n\n\t\t\trng.setStartAfter(table);\n\t\t\trng.setEndAfter(table);\n\n\t\t\tselection.setRng(rng);\n\n\t\t\tdom.remove(table);\n\t\t};\n\n\t\tfunction cloneCell(cell) {\n\t\t\tvar formatNode;\n\n\t\t\t// Clone formats\n\t\t\ttinymce.walk(cell, function(node) {\n\t\t\t\tvar curNode;\n\n\t\t\t\tif (node.nodeType == 3) {\n\t\t\t\t\teach(dom.getParents(node.parentNode, null, cell).reverse(), function(node) {\n\t\t\t\t\t\tnode = cloneNode(node, false);\n\n\t\t\t\t\t\tif (!formatNode)\n\t\t\t\t\t\t\tformatNode = curNode = node;\n\t\t\t\t\t\telse if (curNode)\n\t\t\t\t\t\t\tcurNode.appendChild(node);\n\n\t\t\t\t\t\tcurNode = node;\n\t\t\t\t\t});\n\n\t\t\t\t\t// Add something to the inner node\n\t\t\t\t\tif (curNode)\n\t\t\t\t\t\tcurNode.innerHTML = tinymce.isIE ? '&nbsp;' : '<br data-mce-bogus=\"1\" />';\n\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t}, 'childNodes');\n\n\t\t\tcell = cloneNode(cell, false);\n\t\t\tsetSpanVal(cell, 'rowSpan', 1);\n\t\t\tsetSpanVal(cell, 'colSpan', 1);\n\n\t\t\tif (formatNode) {\n\t\t\t\tcell.appendChild(formatNode);\n\t\t\t} else {\n\t\t\t\tif (!tinymce.isIE)\n\t\t\t\t\tcell.innerHTML = '<br data-mce-bogus=\"1\" />';\n\t\t\t}\n\n\t\t\treturn cell;\n\t\t};\n\n\t\tfunction cleanup() {\n\t\t\tvar rng = dom.createRng();\n\n\t\t\t// Empty rows\n\t\t\teach(dom.select('tr', table), function(tr) {\n\t\t\t\tif (tr.cells.length == 0)\n\t\t\t\t\tdom.remove(tr);\n\t\t\t});\n\n\t\t\t// Empty table\n\t\t\tif (dom.select('tr', table).length == 0) {\n\t\t\t\trng.setStartAfter(table);\n\t\t\t\trng.setEndAfter(table);\n\t\t\t\tselection.setRng(rng);\n\t\t\t\tdom.remove(table);\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Empty header/body/footer\n\t\t\teach(dom.select('thead,tbody,tfoot', table), function(part) {\n\t\t\t\tif (part.rows.length == 0)\n\t\t\t\t\tdom.remove(part);\n\t\t\t});\n\n\t\t\t// Restore selection to start position if it still exists\n\t\t\tbuildGrid();\n\n\t\t\t// Restore the selection to the closest table position\n\t\t\trow = grid[Math.min(grid.length - 1, startPos.y)];\n\t\t\tif (row) {\n\t\t\t\tselection.select(row[Math.min(row.length - 1, startPos.x)].elm, true);\n\t\t\t\tselection.collapse(true);\n\t\t\t}\n\t\t};\n\n\t\tfunction fillLeftDown(x, y, rows, cols) {\n\t\t\tvar tr, x2, r, c, cell;\n\n\t\t\ttr = grid[y][x].elm.parentNode;\n\t\t\tfor (r = 1; r <= rows; r++) {\n\t\t\t\ttr = dom.getNext(tr, 'tr');\n\n\t\t\t\tif (tr) {\n\t\t\t\t\t// Loop left to find real cell\n\t\t\t\t\tfor (x2 = x; x2 >= 0; x2--) {\n\t\t\t\t\t\tcell = grid[y + r][x2].elm;\n\n\t\t\t\t\t\tif (cell.parentNode == tr) {\n\t\t\t\t\t\t\t// Append clones after\n\t\t\t\t\t\t\tfor (c = 1; c <= cols; c++)\n\t\t\t\t\t\t\t\tdom.insertAfter(cloneCell(cell), cell);\n\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tif (x2 == -1) {\n\t\t\t\t\t\t// Insert nodes before first cell\n\t\t\t\t\t\tfor (c = 1; c <= cols; c++)\n\t\t\t\t\t\t\ttr.insertBefore(cloneCell(tr.cells[0]), tr.cells[0]);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction split() {\n\t\t\teach(grid, function(row, y) {\n\t\t\t\teach(row, function(cell, x) {\n\t\t\t\t\tvar colSpan, rowSpan, newCell, i;\n\n\t\t\t\t\tif (isCellSelected(cell)) {\n\t\t\t\t\t\tcell = cell.elm;\n\t\t\t\t\t\tcolSpan = getSpanVal(cell, 'colspan');\n\t\t\t\t\t\trowSpan = getSpanVal(cell, 'rowspan');\n\n\t\t\t\t\t\tif (colSpan > 1 || rowSpan > 1) {\n\t\t\t\t\t\t\tsetSpanVal(cell, 'rowSpan', 1);\n\t\t\t\t\t\t\tsetSpanVal(cell, 'colSpan', 1);\n\n\t\t\t\t\t\t\t// Insert cells right\n\t\t\t\t\t\t\tfor (i = 0; i < colSpan - 1; i++)\n\t\t\t\t\t\t\t\tdom.insertAfter(cloneCell(cell), cell);\n\n\t\t\t\t\t\t\tfillLeftDown(x, y, rowSpan - 1, colSpan);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t});\n\t\t};\n\n\t\tfunction merge(cell, cols, rows) {\n\t\t\tvar startX, startY, endX, endY, x, y, startCell, endCell, cell, children, count;\n\n\t\t\t// Use specified cell and cols/rows\n\t\t\tif (cell) {\n\t\t\t\tpos = getPos(cell);\n\t\t\t\tstartX = pos.x;\n\t\t\t\tstartY = pos.y;\n\t\t\t\tendX = startX + (cols - 1);\n\t\t\t\tendY = startY + (rows - 1);\n\t\t\t} else {\n\t\t\t\t// Use selection\n\t\t\t\tstartX = startPos.x;\n\t\t\t\tstartY = startPos.y;\n\t\t\t\tendX = endPos.x;\n\t\t\t\tendY = endPos.y;\n\t\t\t}\n\n\t\t\t// Find start/end cells\n\t\t\tstartCell = getCell(startX, startY);\n\t\t\tendCell = getCell(endX, endY);\n\n\t\t\t// Check if the cells exists and if they are of the same part for example tbody = tbody\n\t\t\tif (startCell && endCell && startCell.part == endCell.part) {\n\t\t\t\t// Split and rebuild grid\n\t\t\t\tsplit();\n\t\t\t\tbuildGrid();\n\n\t\t\t\t// Set row/col span to start cell\n\t\t\t\tstartCell = getCell(startX, startY).elm;\n\t\t\t\tsetSpanVal(startCell, 'colSpan', (endX - startX) + 1);\n\t\t\t\tsetSpanVal(startCell, 'rowSpan', (endY - startY) + 1);\n\n\t\t\t\t// Remove other cells and add it's contents to the start cell\n\t\t\t\tfor (y = startY; y <= endY; y++) {\n\t\t\t\t\tfor (x = startX; x <= endX; x++) {\n\t\t\t\t\t\tif (!grid[y] || !grid[y][x])\n\t\t\t\t\t\t\tcontinue;\n\n\t\t\t\t\t\tcell = grid[y][x].elm;\n\n\t\t\t\t\t\tif (cell != startCell) {\n\t\t\t\t\t\t\t// Move children to startCell\n\t\t\t\t\t\t\tchildren = tinymce.grep(cell.childNodes);\n\t\t\t\t\t\t\teach(children, function(node) {\n\t\t\t\t\t\t\t\tstartCell.appendChild(node);\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t// Remove bogus nodes if there is children in the target cell\n\t\t\t\t\t\t\tif (children.length) {\n\t\t\t\t\t\t\t\tchildren = tinymce.grep(startCell.childNodes);\n\t\t\t\t\t\t\t\tcount = 0;\n\t\t\t\t\t\t\t\teach(children, function(node) {\n\t\t\t\t\t\t\t\t\tif (node.nodeName == 'BR' && dom.getAttrib(node, 'data-mce-bogus') && count++ < children.length - 1)\n\t\t\t\t\t\t\t\t\t\tstartCell.removeChild(node);\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t// Remove cell\n\t\t\t\t\t\t\tdom.remove(cell);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Remove empty rows etc and restore caret location\n\t\t\t\tcleanup();\n\t\t\t}\n\t\t};\n\n\t\tfunction insertRow(before) {\n\t\t\tvar posY, cell, lastCell, x, rowElm, newRow, newCell, otherCell, rowSpan;\n\n\t\t\t// Find first/last row\n\t\t\teach(grid, function(row, y) {\n\t\t\t\teach(row, function(cell, x) {\n\t\t\t\t\tif (isCellSelected(cell)) {\n\t\t\t\t\t\tcell = cell.elm;\n\t\t\t\t\t\trowElm = cell.parentNode;\n\t\t\t\t\t\tnewRow = cloneNode(rowElm, false);\n\t\t\t\t\t\tposY = y;\n\n\t\t\t\t\t\tif (before)\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tif (before)\n\t\t\t\t\treturn !posY;\n\t\t\t});\n\n\t\t\tfor (x = 0; x < grid[0].length; x++) {\n\t\t\t\t// Cell not found could be because of an invalid table structure\n\t\t\t\tif (!grid[posY][x])\n\t\t\t\t\tcontinue;\n\n\t\t\t\tcell = grid[posY][x].elm;\n\n\t\t\t\tif (cell != lastCell) {\n\t\t\t\t\tif (!before) {\n\t\t\t\t\t\trowSpan = getSpanVal(cell, 'rowspan');\n\t\t\t\t\t\tif (rowSpan > 1) {\n\t\t\t\t\t\t\tsetSpanVal(cell, 'rowSpan', rowSpan + 1);\n\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Check if cell above can be expanded\n\t\t\t\t\t\tif (posY > 0 && grid[posY - 1][x]) {\n\t\t\t\t\t\t\totherCell = grid[posY - 1][x].elm;\n\t\t\t\t\t\t\trowSpan = getSpanVal(otherCell, 'rowSpan');\n\t\t\t\t\t\t\tif (rowSpan > 1) {\n\t\t\t\t\t\t\t\tsetSpanVal(otherCell, 'rowSpan', rowSpan + 1);\n\t\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Insert new cell into new row\n\t\t\t\t\tnewCell = cloneCell(cell);\n\t\t\t\t\tsetSpanVal(newCell, 'colSpan', cell.colSpan);\n\n\t\t\t\t\tnewRow.appendChild(newCell);\n\n\t\t\t\t\tlastCell = cell;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (newRow.hasChildNodes()) {\n\t\t\t\tif (!before)\n\t\t\t\t\tdom.insertAfter(newRow, rowElm);\n\t\t\t\telse\n\t\t\t\t\trowElm.parentNode.insertBefore(newRow, rowElm);\n\t\t\t}\n\t\t};\n\n\t\tfunction insertCol(before) {\n\t\t\tvar posX, lastCell;\n\n\t\t\t// Find first/last column\n\t\t\teach(grid, function(row, y) {\n\t\t\t\teach(row, function(cell, x) {\n\t\t\t\t\tif (isCellSelected(cell)) {\n\t\t\t\t\t\tposX = x;\n\n\t\t\t\t\t\tif (before)\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tif (before)\n\t\t\t\t\treturn !posX;\n\t\t\t});\n\n\t\t\teach(grid, function(row, y) {\n\t\t\t\tvar cell, rowSpan, colSpan;\n\n\t\t\t\tif (!row[posX])\n\t\t\t\t\treturn;\n\n\t\t\t\tcell = row[posX].elm;\n\t\t\t\tif (cell != lastCell) {\n\t\t\t\t\tcolSpan = getSpanVal(cell, 'colspan');\n\t\t\t\t\trowSpan = getSpanVal(cell, 'rowspan');\n\n\t\t\t\t\tif (colSpan == 1) {\n\t\t\t\t\t\tif (!before) {\n\t\t\t\t\t\t\tdom.insertAfter(cloneCell(cell), cell);\n\t\t\t\t\t\t\tfillLeftDown(posX, y, rowSpan - 1, colSpan);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tcell.parentNode.insertBefore(cloneCell(cell), cell);\n\t\t\t\t\t\t\tfillLeftDown(posX, y, rowSpan - 1, colSpan);\n\t\t\t\t\t\t}\n\t\t\t\t\t} else\n\t\t\t\t\t\tsetSpanVal(cell, 'colSpan', cell.colSpan + 1);\n\n\t\t\t\t\tlastCell = cell;\n\t\t\t\t}\n\t\t\t});\n\t\t};\n\n\t\tfunction deleteCols() {\n\t\t\tvar cols = [];\n\n\t\t\t// Get selected column indexes\n\t\t\teach(grid, function(row, y) {\n\t\t\t\teach(row, function(cell, x) {\n\t\t\t\t\tif (isCellSelected(cell) && tinymce.inArray(cols, x) === -1) {\n\t\t\t\t\t\teach(grid, function(row) {\n\t\t\t\t\t\t\tvar cell = row[x].elm, colSpan;\n\n\t\t\t\t\t\t\tcolSpan = getSpanVal(cell, 'colSpan');\n\n\t\t\t\t\t\t\tif (colSpan > 1)\n\t\t\t\t\t\t\t\tsetSpanVal(cell, 'colSpan', colSpan - 1);\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tdom.remove(cell);\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tcols.push(x);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t});\n\n\t\t\tcleanup();\n\t\t};\n\n\t\tfunction deleteRows() {\n\t\t\tvar rows;\n\n\t\t\tfunction deleteRow(tr) {\n\t\t\t\tvar nextTr, pos, lastCell;\n\n\t\t\t\tnextTr = dom.getNext(tr, 'tr');\n\n\t\t\t\t// Move down row spanned cells\n\t\t\t\teach(tr.cells, function(cell) {\n\t\t\t\t\tvar rowSpan = getSpanVal(cell, 'rowSpan');\n\n\t\t\t\t\tif (rowSpan > 1) {\n\t\t\t\t\t\tsetSpanVal(cell, 'rowSpan', rowSpan - 1);\n\t\t\t\t\t\tpos = getPos(cell);\n\t\t\t\t\t\tfillLeftDown(pos.x, pos.y, 1, 1);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// Delete cells\n\t\t\t\tpos = getPos(tr.cells[0]);\n\t\t\t\teach(grid[pos.y], function(cell) {\n\t\t\t\t\tvar rowSpan;\n\n\t\t\t\t\tcell = cell.elm;\n\n\t\t\t\t\tif (cell != lastCell) {\n\t\t\t\t\t\trowSpan = getSpanVal(cell, 'rowSpan');\n\n\t\t\t\t\t\tif (rowSpan <= 1)\n\t\t\t\t\t\t\tdom.remove(cell);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tsetSpanVal(cell, 'rowSpan', rowSpan - 1);\n\n\t\t\t\t\t\tlastCell = cell;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t};\n\n\t\t\t// Get selected rows and move selection out of scope\n\t\t\trows = getSelectedRows();\n\n\t\t\t// Delete all selected rows\n\t\t\teach(rows.reverse(), function(tr) {\n\t\t\t\tdeleteRow(tr);\n\t\t\t});\n\n\t\t\tcleanup();\n\t\t};\n\n\t\tfunction cutRows() {\n\t\t\tvar rows = getSelectedRows();\n\n\t\t\tdom.remove(rows);\n\t\t\tcleanup();\n\n\t\t\treturn rows;\n\t\t};\n\n\t\tfunction copyRows() {\n\t\t\tvar rows = getSelectedRows();\n\n\t\t\teach(rows, function(row, i) {\n\t\t\t\trows[i] = cloneNode(row, true);\n\t\t\t});\n\n\t\t\treturn rows;\n\t\t};\n\n\t\tfunction pasteRows(rows, before) {\n\t\t\tvar selectedRows = getSelectedRows(),\n\t\t\t\ttargetRow = selectedRows[before ? 0 : selectedRows.length - 1],\n\t\t\t\ttargetCellCount = targetRow.cells.length;\n\n\t\t\t// Calc target cell count\n\t\t\teach(grid, function(row) {\n\t\t\t\tvar match;\n\n\t\t\t\ttargetCellCount = 0;\n\t\t\t\teach(row, function(cell, x) {\n\t\t\t\t\tif (cell.real)\n\t\t\t\t\t\ttargetCellCount += cell.colspan;\n\n\t\t\t\t\tif (cell.elm.parentNode == targetRow)\n\t\t\t\t\t\tmatch = 1;\n\t\t\t\t});\n\n\t\t\t\tif (match)\n\t\t\t\t\treturn false;\n\t\t\t});\n\n\t\t\tif (!before)\n\t\t\t\trows.reverse();\n\n\t\t\teach(rows, function(row) {\n\t\t\t\tvar cellCount = row.cells.length, cell;\n\n\t\t\t\t// Remove col/rowspans\n\t\t\t\tfor (i = 0; i < cellCount; i++) {\n\t\t\t\t\tcell = row.cells[i];\n\t\t\t\t\tsetSpanVal(cell, 'colSpan', 1);\n\t\t\t\t\tsetSpanVal(cell, 'rowSpan', 1);\n\t\t\t\t}\n\n\t\t\t\t// Needs more cells\n\t\t\t\tfor (i = cellCount; i < targetCellCount; i++)\n\t\t\t\t\trow.appendChild(cloneCell(row.cells[cellCount - 1]));\n\n\t\t\t\t// Needs less cells\n\t\t\t\tfor (i = targetCellCount; i < cellCount; i++)\n\t\t\t\t\tdom.remove(row.cells[i]);\n\n\t\t\t\t// Add before/after\n\t\t\t\tif (before)\n\t\t\t\t\ttargetRow.parentNode.insertBefore(row, targetRow);\n\t\t\t\telse\n\t\t\t\t\tdom.insertAfter(row, targetRow);\n\t\t\t});\n\t\t};\n\n\t\tfunction getPos(target) {\n\t\t\tvar pos;\n\n\t\t\teach(grid, function(row, y) {\n\t\t\t\teach(row, function(cell, x) {\n\t\t\t\t\tif (cell.elm == target) {\n\t\t\t\t\t\tpos = {x : x, y : y};\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\treturn !pos;\n\t\t\t});\n\n\t\t\treturn pos;\n\t\t};\n\n\t\tfunction setStartCell(cell) {\n\t\t\tstartPos = getPos(cell);\n\t\t};\n\n\t\tfunction findEndPos() {\n\t\t\tvar pos, maxX, maxY;\n\n\t\t\tmaxX = maxY = 0;\n\n\t\t\teach(grid, function(row, y) {\n\t\t\t\teach(row, function(cell, x) {\n\t\t\t\t\tvar colSpan, rowSpan;\n\n\t\t\t\t\tif (isCellSelected(cell)) {\n\t\t\t\t\t\tcell = grid[y][x];\n\n\t\t\t\t\t\tif (x > maxX)\n\t\t\t\t\t\t\tmaxX = x;\n\n\t\t\t\t\t\tif (y > maxY)\n\t\t\t\t\t\t\tmaxY = y;\n\n\t\t\t\t\t\tif (cell.real) {\n\t\t\t\t\t\t\tcolSpan = cell.colspan - 1;\n\t\t\t\t\t\t\trowSpan = cell.rowspan - 1;\n\n\t\t\t\t\t\t\tif (colSpan) {\n\t\t\t\t\t\t\t\tif (x + colSpan > maxX)\n\t\t\t\t\t\t\t\t\tmaxX = x + colSpan;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (rowSpan) {\n\t\t\t\t\t\t\t\tif (y + rowSpan > maxY)\n\t\t\t\t\t\t\t\t\tmaxY = y + rowSpan;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t});\n\n\t\t\treturn {x : maxX, y : maxY};\n\t\t};\n\n\t\tfunction setEndCell(cell) {\n\t\t\tvar startX, startY, endX, endY, maxX, maxY, colSpan, rowSpan;\n\n\t\t\tendPos = getPos(cell);\n\n\t\t\tif (startPos && endPos) {\n\t\t\t\t// Get start/end positions\n\t\t\t\tstartX = Math.min(startPos.x, endPos.x);\n\t\t\t\tstartY = Math.min(startPos.y, endPos.y);\n\t\t\t\tendX = Math.max(startPos.x, endPos.x);\n\t\t\t\tendY = Math.max(startPos.y, endPos.y);\n\n\t\t\t\t// Expand end positon to include spans\n\t\t\t\tmaxX = endX;\n\t\t\t\tmaxY = endY;\n\n\t\t\t\t// Expand startX\n\t\t\t\tfor (y = startY; y <= maxY; y++) {\n\t\t\t\t\tcell = grid[y][startX];\n\n\t\t\t\t\tif (!cell.real) {\n\t\t\t\t\t\tif (startX - (cell.colspan - 1) < startX)\n\t\t\t\t\t\t\tstartX -= cell.colspan - 1;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Expand startY\n\t\t\t\tfor (x = startX; x <= maxX; x++) {\n\t\t\t\t\tcell = grid[startY][x];\n\n\t\t\t\t\tif (!cell.real) {\n\t\t\t\t\t\tif (startY - (cell.rowspan - 1) < startY)\n\t\t\t\t\t\t\tstartY -= cell.rowspan - 1;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Find max X, Y\n\t\t\t\tfor (y = startY; y <= endY; y++) {\n\t\t\t\t\tfor (x = startX; x <= endX; x++) {\n\t\t\t\t\t\tcell = grid[y][x];\n\n\t\t\t\t\t\tif (cell.real) {\n\t\t\t\t\t\t\tcolSpan = cell.colspan - 1;\n\t\t\t\t\t\t\trowSpan = cell.rowspan - 1;\n\n\t\t\t\t\t\t\tif (colSpan) {\n\t\t\t\t\t\t\t\tif (x + colSpan > maxX)\n\t\t\t\t\t\t\t\t\tmaxX = x + colSpan;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (rowSpan) {\n\t\t\t\t\t\t\t\tif (y + rowSpan > maxY)\n\t\t\t\t\t\t\t\t\tmaxY = y + rowSpan;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Remove current selection\n\t\t\t\tdom.removeClass(dom.select('td.mceSelected,th.mceSelected'), 'mceSelected');\n\n\t\t\t\t// Add new selection\n\t\t\t\tfor (y = startY; y <= maxY; y++) {\n\t\t\t\t\tfor (x = startX; x <= maxX; x++) {\n\t\t\t\t\t\tif (grid[y][x])\n\t\t\t\t\t\t\tdom.addClass(grid[y][x].elm, 'mceSelected');\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\t// Expose to public\n\t\ttinymce.extend(this, {\n\t\t\tdeleteTable : deleteTable,\n\t\t\tsplit : split,\n\t\t\tmerge : merge,\n\t\t\tinsertRow : insertRow,\n\t\t\tinsertCol : insertCol,\n\t\t\tdeleteCols : deleteCols,\n\t\t\tdeleteRows : deleteRows,\n\t\t\tcutRows : cutRows,\n\t\t\tcopyRows : copyRows,\n\t\t\tpasteRows : pasteRows,\n\t\t\tgetPos : getPos,\n\t\t\tsetStartCell : setStartCell,\n\t\t\tsetEndCell : setEndCell\n\t\t});\n\t};\n\n\ttinymce.create('tinymce.plugins.TablePlugin', {\n\t\tinit : function(ed, url) {\n\t\t\tvar winMan, clipboardRows, hasCellSelection = true; // Might be selected cells on reload\n\n\t\t\tfunction createTableGrid(node) {\n\t\t\t\tvar selection = ed.selection, tblElm = ed.dom.getParent(node || selection.getNode(), 'table');\n\n\t\t\t\tif (tblElm)\n\t\t\t\t\treturn new TableGrid(tblElm, ed.dom, selection);\n\t\t\t};\n\n\t\t\tfunction cleanup() {\n\t\t\t\t// Restore selection possibilities\n\t\t\t\ted.getBody().style.webkitUserSelect = '';\n\n\t\t\t\tif (hasCellSelection) {\n\t\t\t\t\ted.dom.removeClass(ed.dom.select('td.mceSelected,th.mceSelected'), 'mceSelected');\n\t\t\t\t\thasCellSelection = false;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Register buttons\n\t\t\teach([\n\t\t\t\t['table', 'table.desc', 'mceInsertTable', true],\n\t\t\t\t['delete_table', 'table.del', 'mceTableDelete'],\n\t\t\t\t['delete_col', 'table.delete_col_desc', 'mceTableDeleteCol'],\n\t\t\t\t['delete_row', 'table.delete_row_desc', 'mceTableDeleteRow'],\n\t\t\t\t['col_after', 'table.col_after_desc', 'mceTableInsertColAfter'],\n\t\t\t\t['col_before', 'table.col_before_desc', 'mceTableInsertColBefore'],\n\t\t\t\t['row_after', 'table.row_after_desc', 'mceTableInsertRowAfter'],\n\t\t\t\t['row_before', 'table.row_before_desc', 'mceTableInsertRowBefore'],\n\t\t\t\t['row_props', 'table.row_desc', 'mceTableRowProps', true],\n\t\t\t\t['cell_props', 'table.cell_desc', 'mceTableCellProps', true],\n\t\t\t\t['split_cells', 'table.split_cells_desc', 'mceTableSplitCells', true],\n\t\t\t\t['merge_cells', 'table.merge_cells_desc', 'mceTableMergeCells', true]\n\t\t\t], function(c) {\n\t\t\t\ted.addButton(c[0], {title : c[1], cmd : c[2], ui : c[3]});\n\t\t\t});\n\n\t\t\t// Select whole table is a table border is clicked\n\t\t\tif (!tinymce.isIE) {\n\t\t\t\ted.onClick.add(function(ed, e) {\n\t\t\t\t\te = e.target;\n\n\t\t\t\t\tif (e.nodeName === 'TABLE') {\n\t\t\t\t\t\ted.selection.select(e);\n\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\ted.onPreProcess.add(function(ed, args) {\n\t\t\t\tvar nodes, i, node, dom = ed.dom, value;\n\n\t\t\t\tnodes = dom.select('table', args.node);\n\t\t\t\ti = nodes.length;\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tdom.setAttrib(node, 'data-mce-style', '');\n\n\t\t\t\t\tif ((value = dom.getAttrib(node, 'width'))) {\n\t\t\t\t\t\tdom.setStyle(node, 'width', value);\n\t\t\t\t\t\tdom.setAttrib(node, 'width', '');\n\t\t\t\t\t}\n\n\t\t\t\t\tif ((value = dom.getAttrib(node, 'height'))) {\n\t\t\t\t\t\tdom.setStyle(node, 'height', value);\n\t\t\t\t\t\tdom.setAttrib(node, 'height', '');\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Handle node change updates\n\t\t\ted.onNodeChange.add(function(ed, cm, n) {\n\t\t\t\tvar p;\n\n\t\t\t\tn = ed.selection.getStart();\n\t\t\t\tp = ed.dom.getParent(n, 'td,th,caption');\n\t\t\t\tcm.setActive('table', n.nodeName === 'TABLE' || !!p);\n\n\t\t\t\t// Disable table tools if we are in caption\n\t\t\t\tif (p && p.nodeName === 'CAPTION')\n\t\t\t\t\tp = 0;\n\n\t\t\t\tcm.setDisabled('delete_table', !p);\n\t\t\t\tcm.setDisabled('delete_col', !p);\n\t\t\t\tcm.setDisabled('delete_table', !p);\n\t\t\t\tcm.setDisabled('delete_row', !p);\n\t\t\t\tcm.setDisabled('col_after', !p);\n\t\t\t\tcm.setDisabled('col_before', !p);\n\t\t\t\tcm.setDisabled('row_after', !p);\n\t\t\t\tcm.setDisabled('row_before', !p);\n\t\t\t\tcm.setDisabled('row_props', !p);\n\t\t\t\tcm.setDisabled('cell_props', !p);\n\t\t\t\tcm.setDisabled('split_cells', !p);\n\t\t\t\tcm.setDisabled('merge_cells', !p);\n\t\t\t});\n\n\t\t\ted.onInit.add(function(ed) {\n\t\t\t\tvar startTable, startCell, dom = ed.dom, tableGrid;\n\n\t\t\t\twinMan = ed.windowManager;\n\n\t\t\t\t// Add cell selection logic\n\t\t\t\ted.onMouseDown.add(function(ed, e) {\n\t\t\t\t\tif (e.button != 2) {\n\t\t\t\t\t\tcleanup();\n\n\t\t\t\t\t\tstartCell = dom.getParent(e.target, 'td,th');\n\t\t\t\t\t\tstartTable = dom.getParent(startCell, 'table');\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tdom.bind(ed.getDoc(), 'mouseover', function(e) {\n\t\t\t\t\tvar sel, table, target = e.target;\n\n\t\t\t\t\tif (startCell && (tableGrid || target != startCell) && (target.nodeName == 'TD' || target.nodeName == 'TH')) {\n\t\t\t\t\t\ttable = dom.getParent(target, 'table');\n\t\t\t\t\t\tif (table == startTable) {\n\t\t\t\t\t\t\tif (!tableGrid) {\n\t\t\t\t\t\t\t\ttableGrid = createTableGrid(table);\n\t\t\t\t\t\t\t\ttableGrid.setStartCell(startCell);\n\n\t\t\t\t\t\t\t\ted.getBody().style.webkitUserSelect = 'none';\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\ttableGrid.setEndCell(target);\n\t\t\t\t\t\t\thasCellSelection = true;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Remove current selection\n\t\t\t\t\t\tsel = ed.selection.getSel();\n\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tif (sel.removeAllRanges)\n\t\t\t\t\t\t\t\tsel.removeAllRanges();\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tsel.empty();\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\t// IE9 might throw errors here\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\ted.onMouseUp.add(function(ed, e) {\n\t\t\t\t\tvar rng, sel = ed.selection, selectedCells, nativeSel = sel.getSel(), walker, node, lastNode, endNode;\n\n\t\t\t\t\t// Move selection to startCell\n\t\t\t\t\tif (startCell) {\n\t\t\t\t\t\tif (tableGrid)\n\t\t\t\t\t\t\ted.getBody().style.webkitUserSelect = '';\n\n\t\t\t\t\t\tfunction setPoint(node, start) {\n\t\t\t\t\t\t\tvar walker = new tinymce.dom.TreeWalker(node, node);\n\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\t// Text node\n\t\t\t\t\t\t\t\tif (node.nodeType == 3 && tinymce.trim(node.nodeValue).length != 0) {\n\t\t\t\t\t\t\t\t\tif (start)\n\t\t\t\t\t\t\t\t\t\trng.setStart(node, 0);\n\t\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\t\trng.setEnd(node, node.nodeValue.length);\n\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// BR element\n\t\t\t\t\t\t\t\tif (node.nodeName == 'BR') {\n\t\t\t\t\t\t\t\t\tif (start)\n\t\t\t\t\t\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\t\trng.setEndBefore(node);\n\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} while (node = (start ? walker.next() : walker.prev()));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Try to expand text selection as much as we can only Gecko supports cell selection\n\t\t\t\t\t\tselectedCells = dom.select('td.mceSelected,th.mceSelected');\n\t\t\t\t\t\tif (selectedCells.length > 0) {\n\t\t\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\t\t\tnode = selectedCells[0];\n\t\t\t\t\t\t\tendNode = selectedCells[selectedCells.length - 1];\n\t\t\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\t\t\trng.setEndAfter(node);\n\n\t\t\t\t\t\t\tsetPoint(node, 1);\n\t\t\t\t\t\t\twalker = new tinymce.dom.TreeWalker(node, dom.getParent(selectedCells[0], 'table'));\n\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\tif (node.nodeName == 'TD' || node.nodeName == 'TH') {\n\t\t\t\t\t\t\t\t\tif (!dom.hasClass(node, 'mceSelected'))\n\t\t\t\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\t\t\t\tlastNode = node;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} while (node = walker.next());\n\n\t\t\t\t\t\t\tsetPoint(lastNode);\n\n\t\t\t\t\t\t\tsel.setRng(rng);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t\tstartCell = tableGrid = startTable = null;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\ted.onKeyUp.add(function(ed, e) {\n\t\t\t\t\tcleanup();\n\t\t\t\t});\n\n\t\t\t\ted.onKeyDown.add(function (ed, e) {\n\t\t\t\t\tfixTableCellSelection(ed);\n\t\t\t\t});\n\n\t\t\t\ted.onMouseDown.add(function (ed, e) {\n\t\t\t\t\tif (e.button != 2) {\n\t\t\t\t\t\tfixTableCellSelection(ed);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t\tfunction tableCellSelected(ed, rng, n, currentCell) {\n\t\t\t\t\t// The decision of when a table cell is selected is somewhat involved.  The fact that this code is\n\t\t\t\t\t// required is actually a pointer to the root cause of this bug. A cell is selected when the start \n\t\t\t\t\t// and end offsets are 0, the start container is a text, and the selection node is either a TR (most cases)\n\t\t\t\t\t// or the parent of the table (in the case of the selection containing the last cell of a table).\n\t\t\t\t\tvar TEXT_NODE = 3, table = ed.dom.getParent(rng.startContainer, 'TABLE'), \n\t\t\t\t\ttableParent, allOfCellSelected, tableCellSelection;\n\t\t\t\t\tif (table) \n\t\t\t\t\ttableParent = table.parentNode;\n\t\t\t\t\tallOfCellSelected =rng.startContainer.nodeType == TEXT_NODE && \n\t\t\t\t\t\trng.startOffset == 0 && \n\t\t\t\t\t\trng.endOffset == 0 && \n\t\t\t\t\t\tcurrentCell && \n\t\t\t\t\t\t(n.nodeName==\"TR\" || n==tableParent);\n\t\t\t\t\ttableCellSelection = (n.nodeName==\"TD\"||n.nodeName==\"TH\")&& !currentCell;\t   \n\t\t\t\t\treturn  allOfCellSelected || tableCellSelection;\n\t\t\t\t\t// return false;\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\t// this nasty hack is here to work around some WebKit selection bugs.\n\t\t\t\tfunction fixTableCellSelection(ed) {\n\t\t\t\t\tif (!tinymce.isWebKit)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tvar rng = ed.selection.getRng();\n\t\t\t\t\tvar n = ed.selection.getNode();\n\t\t\t\t\tvar currentCell = ed.dom.getParent(rng.startContainer, 'TD,TH');\n\t\t\t\t\n\t\t\t\t\tif (!tableCellSelected(ed, rng, n, currentCell))\n\t\t\t\t\t\treturn;\n\t\t\t\t\t\tif (!currentCell) {\n\t\t\t\t\t\t\tcurrentCell=n;\n\t\t\t\t\t\t}\n\t\t\t\t\t\n\t\t\t\t\t// Get the very last node inside the table cell\n\t\t\t\t\tvar end = currentCell.lastChild;\n\t\t\t\t\twhile (end.lastChild)\n\t\t\t\t\t\tend = end.lastChild;\n\t\t\t\t\t\n\t\t\t\t\t// Select the entire table cell. Nothing outside of the table cell should be selected.\n\t\t\t\t\trng.setEnd(end, end.nodeValue.length);\n\t\t\t\t\ted.selection.setRng(rng);\n\t\t\t\t}\n\t\t\t\ted.plugins.table.fixTableCellSelection=fixTableCellSelection;\n\n\t\t\t\t// Add context menu\n\t\t\t\tif (ed && ed.plugins.contextmenu) {\n\t\t\t\t\ted.plugins.contextmenu.onContextMenu.add(function(th, m, e) {\n\t\t\t\t\t\tvar sm, se = ed.selection, el = se.getNode() || ed.getBody();\n\n\t\t\t\t\t\tif (ed.dom.getParent(e, 'td') || ed.dom.getParent(e, 'th') || ed.dom.select('td.mceSelected,th.mceSelected').length) {\n\t\t\t\t\t\t\tm.removeAll();\n\n\t\t\t\t\t\t\tif (el.nodeName == 'A' && !ed.dom.getAttrib(el, 'name')) {\n\t\t\t\t\t\t\t\tm.add({title : 'advanced.link_desc', icon : 'link', cmd : ed.plugins.advlink ? 'mceAdvLink' : 'mceLink', ui : true});\n\t\t\t\t\t\t\t\tm.add({title : 'advanced.unlink_desc', icon : 'unlink', cmd : 'UnLink'});\n\t\t\t\t\t\t\t\tm.addSeparator();\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (el.nodeName == 'IMG' && el.className.indexOf('mceItem') == -1) {\n\t\t\t\t\t\t\t\tm.add({title : 'advanced.image_desc', icon : 'image', cmd : ed.plugins.advimage ? 'mceAdvImage' : 'mceImage', ui : true});\n\t\t\t\t\t\t\t\tm.addSeparator();\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tm.add({title : 'table.desc', icon : 'table', cmd : 'mceInsertTable', value : {action : 'insert'}});\n\t\t\t\t\t\t\tm.add({title : 'table.props_desc', icon : 'table_props', cmd : 'mceInsertTable'});\n\t\t\t\t\t\t\tm.add({title : 'table.del', icon : 'delete_table', cmd : 'mceTableDelete'});\n\t\t\t\t\t\t\tm.addSeparator();\n\n\t\t\t\t\t\t\t// Cell menu\n\t\t\t\t\t\t\tsm = m.addMenu({title : 'table.cell'});\n\t\t\t\t\t\t\tsm.add({title : 'table.cell_desc', icon : 'cell_props', cmd : 'mceTableCellProps'});\n\t\t\t\t\t\t\tsm.add({title : 'table.split_cells_desc', icon : 'split_cells', cmd : 'mceTableSplitCells'});\n\t\t\t\t\t\t\tsm.add({title : 'table.merge_cells_desc', icon : 'merge_cells', cmd : 'mceTableMergeCells'});\n\n\t\t\t\t\t\t\t// Row menu\n\t\t\t\t\t\t\tsm = m.addMenu({title : 'table.row'});\n\t\t\t\t\t\t\tsm.add({title : 'table.row_desc', icon : 'row_props', cmd : 'mceTableRowProps'});\n\t\t\t\t\t\t\tsm.add({title : 'table.row_before_desc', icon : 'row_before', cmd : 'mceTableInsertRowBefore'});\n\t\t\t\t\t\t\tsm.add({title : 'table.row_after_desc', icon : 'row_after', cmd : 'mceTableInsertRowAfter'});\n\t\t\t\t\t\t\tsm.add({title : 'table.delete_row_desc', icon : 'delete_row', cmd : 'mceTableDeleteRow'});\n\t\t\t\t\t\t\tsm.addSeparator();\n\t\t\t\t\t\t\tsm.add({title : 'table.cut_row_desc', icon : 'cut', cmd : 'mceTableCutRow'});\n\t\t\t\t\t\t\tsm.add({title : 'table.copy_row_desc', icon : 'copy', cmd : 'mceTableCopyRow'});\n\t\t\t\t\t\t\tsm.add({title : 'table.paste_row_before_desc', icon : 'paste', cmd : 'mceTablePasteRowBefore'}).setDisabled(!clipboardRows);\n\t\t\t\t\t\t\tsm.add({title : 'table.paste_row_after_desc', icon : 'paste', cmd : 'mceTablePasteRowAfter'}).setDisabled(!clipboardRows);\n\n\t\t\t\t\t\t\t// Column menu\n\t\t\t\t\t\t\tsm = m.addMenu({title : 'table.col'});\n\t\t\t\t\t\t\tsm.add({title : 'table.col_before_desc', icon : 'col_before', cmd : 'mceTableInsertColBefore'});\n\t\t\t\t\t\t\tsm.add({title : 'table.col_after_desc', icon : 'col_after', cmd : 'mceTableInsertColAfter'});\n\t\t\t\t\t\t\tsm.add({title : 'table.delete_col_desc', icon : 'delete_col', cmd : 'mceTableDeleteCol'});\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\tm.add({title : 'table.desc', icon : 'table', cmd : 'mceInsertTable'});\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\t// Fix to allow navigating up and down in a table in WebKit browsers.\n\t\t\t\tif (tinymce.isWebKit) {\n\t\t\t\t\tfunction moveSelection(ed, e) {\n\t\t\t\t\t\tvar VK = tinymce.VK;\n\t\t\t\t\t\tvar key = e.keyCode;\n\n\t\t\t\t\t\tfunction handle(upBool, sourceNode, event) {\n\t\t\t\t\t\t\tvar siblingDirection = upBool ? 'previousSibling' : 'nextSibling';\n\t\t\t\t\t\t\tvar currentRow = ed.dom.getParent(sourceNode, 'tr');\n\t\t\t\t\t\t\tvar siblingRow = currentRow[siblingDirection];\n\n\t\t\t\t\t\t\tif (siblingRow) {\n\t\t\t\t\t\t\t\tmoveCursorToRow(ed, sourceNode, siblingRow, upBool);\n\t\t\t\t\t\t\t\ttinymce.dom.Event.cancel(event);\n\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tvar tableNode = ed.dom.getParent(currentRow, 'table');\n\t\t\t\t\t\t\t\tvar middleNode = currentRow.parentNode;\n\t\t\t\t\t\t\t\tvar parentNodeName = middleNode.nodeName.toLowerCase();\n\t\t\t\t\t\t\t\tif (parentNodeName === 'tbody' || parentNodeName === (upBool ? 'tfoot' : 'thead')) {\n\t\t\t\t\t\t\t\t\tvar targetParent = getTargetParent(upBool, tableNode, middleNode, 'tbody');\n\t\t\t\t\t\t\t\t\tif (targetParent !== null) {\n\t\t\t\t\t\t\t\t\t\treturn moveToRowInTarget(upBool, targetParent, sourceNode, event);\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\treturn escapeTable(upBool, currentRow, siblingDirection, tableNode, event);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction getTargetParent(upBool, topNode, secondNode, nodeName) {\n\t\t\t\t\t\t\tvar tbodies = ed.dom.select('>' + nodeName, topNode);\n\t\t\t\t\t\t\tvar position = tbodies.indexOf(secondNode);\n\t\t\t\t\t\t\tif (upBool && position === 0 || !upBool && position === tbodies.length - 1) {\n\t\t\t\t\t\t\t\treturn getFirstHeadOrFoot(upBool, topNode);\n\t\t\t\t\t\t\t} else if (position === -1) {\n\t\t\t\t\t\t\t\tvar topOrBottom = secondNode.tagName.toLowerCase() === 'thead' ? 0 : tbodies.length - 1;\n\t\t\t\t\t\t\t\treturn tbodies[topOrBottom];\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\treturn tbodies[position + (upBool ? -1 : 1)];\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction getFirstHeadOrFoot(upBool, parent) {\n\t\t\t\t\t\t\tvar tagName = upBool ? 'thead' : 'tfoot';\n\t\t\t\t\t\t\tvar headOrFoot = ed.dom.select('>' + tagName, parent);\n\t\t\t\t\t\t\treturn headOrFoot.length !== 0 ? headOrFoot[0] : null;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction moveToRowInTarget(upBool, targetParent, sourceNode, event) {\n\t\t\t\t\t\t\tvar targetRow = getChildForDirection(targetParent, upBool);\n\t\t\t\t\t\t\ttargetRow && moveCursorToRow(ed, sourceNode, targetRow, upBool);\n\t\t\t\t\t\t\ttinymce.dom.Event.cancel(event);\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction escapeTable(upBool, currentRow, siblingDirection, table, event) {\n\t\t\t\t\t\t\tvar tableSibling = table[siblingDirection];\n\t\t\t\t\t\t\tif (tableSibling) {\n\t\t\t\t\t\t\t\tmoveCursorToStartOfElement(tableSibling);\n\t\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tvar parentCell = ed.dom.getParent(table, 'td,th');\n\t\t\t\t\t\t\t\tif (parentCell) {\n\t\t\t\t\t\t\t\t\treturn handle(upBool, parentCell, event);\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tvar backUpSibling = getChildForDirection(currentRow, !upBool);\n\t\t\t\t\t\t\t\t\tmoveCursorToStartOfElement(backUpSibling);\n\t\t\t\t\t\t\t\t\treturn tinymce.dom.Event.cancel(event);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction getChildForDirection(parent, up) {\n\t\t\t\t\t\t\treturn parent && parent[up ? 'lastChild' : 'firstChild'];\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction moveCursorToStartOfElement(n) {\n\t\t\t\t\t\t\ted.selection.setCursorLocation(n, 0);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction isVerticalMovement() {\n\t\t\t\t\t\t\treturn key == VK.UP || key == VK.DOWN;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction isInTable(ed) {\n\t\t\t\t\t\t\tvar node = ed.selection.getNode();\n\t\t\t\t\t\t\tvar currentRow = ed.dom.getParent(node, 'tr');\n\t\t\t\t\t\t\treturn currentRow !== null;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction columnIndex(column) {\n\t\t\t\t\t\t\tvar colIndex = 0;\n\t\t\t\t\t\t\tvar c = column;\n\t\t\t\t\t\t\twhile (c.previousSibling) {\n\t\t\t\t\t\t\t\tc = c.previousSibling;\n\t\t\t\t\t\t\t\tcolIndex = colIndex + getSpanVal(c, \"colspan\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn colIndex;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction findColumn(rowElement, columnIndex) {\n\t\t\t\t\t\t\tvar c = 0;\n\t\t\t\t\t\t\tvar r = 0;\n\t\t\t\t\t\t\teach(rowElement.children, function(cell, i) {\n\t\t\t\t\t\t\t\tc = c + getSpanVal(cell, \"colspan\");\n\t\t\t\t\t\t\t\tr = i;\n\t\t\t\t\t\t\t\tif (c > columnIndex)\n\t\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\treturn r;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction moveCursorToRow(ed, node, row, upBool) {\n\t\t\t\t\t\t\tvar srcColumnIndex = columnIndex(ed.dom.getParent(node, 'td,th'));\n\t\t\t\t\t\t\tvar tgtColumnIndex = findColumn(row, srcColumnIndex);\n\t\t\t\t\t\t\tvar tgtNode = row.childNodes[tgtColumnIndex];\n\t\t\t\t\t\t\tvar rowCellTarget = getChildForDirection(tgtNode, upBool);\n\t\t\t\t\t\t\tmoveCursorToStartOfElement(rowCellTarget || tgtNode);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction shouldFixCaret(preBrowserNode) {\n\t\t\t\t\t\t\tvar newNode = ed.selection.getNode();\n\t\t\t\t\t\t\tvar newParent = ed.dom.getParent(newNode, 'td,th');\n\t\t\t\t\t\t\tvar oldParent = ed.dom.getParent(preBrowserNode, 'td,th');\n\t\t\t\t\t\t\treturn newParent && newParent !== oldParent && checkSameParentTable(newParent, oldParent)\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfunction checkSameParentTable(nodeOne, NodeTwo) {\n\t\t\t\t\t\t\treturn ed.dom.getParent(nodeOne, 'TABLE') === ed.dom.getParent(NodeTwo, 'TABLE');\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (isVerticalMovement() && isInTable(ed)) {\n\t\t\t\t\t\t\tvar preBrowserNode = ed.selection.getNode();\n\t\t\t\t\t\t\tsetTimeout(function() {\n\t\t\t\t\t\t\t\tif (shouldFixCaret(preBrowserNode)) {\n\t\t\t\t\t\t\t\t\thandle(!e.shiftKey && key === VK.UP, preBrowserNode, e);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}, 0);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\ted.onKeyDown.add(moveSelection);\n\t\t\t\t}\n\t\t\t\t\t\t\t\t\n\t\t\t\t// Fixes an issue on Gecko where it's impossible to place the caret behind a table\n\t\t\t\t// This fix will force a paragraph element after the table but only when the forced_root_block setting is enabled\n\t\t\t\tif (!tinymce.isIE) {\n\t\t\t\t\tfunction fixTableCaretPos() {\n\t\t\t\t\t\tvar last;\n\n\t\t\t\t\t\t// Skip empty text nodes form the end\n\t\t\t\t\t\tfor (last = ed.getBody().lastChild; last && last.nodeType == 3 && !last.nodeValue.length; last = last.previousSibling) ;\n\n\t\t\t\t\t\tif (last && last.nodeName == 'TABLE')\n\t\t\t\t\t\t\ted.dom.add(ed.getBody(), 'p', null, '<br mce_bogus=\"1\" />');\n\t\t\t\t\t};\n\n\t\t\t\t\t// Fixes an bug where it's impossible to place the caret before a table in Gecko\n\t\t\t\t\t// this fix solves it by detecting when the caret is at the beginning of such a table\n\t\t\t\t\t// and then manually moves the caret infront of the table\n\t\t\t\t\tif (tinymce.isGecko) {\n\t\t\t\t\t\ted.onKeyDown.add(function(ed, e) {\n\t\t\t\t\t\t\tvar rng, table, dom = ed.dom;\n\n\t\t\t\t\t\t\t// On gecko it's not possible to place the caret before a table\n\t\t\t\t\t\t\tif (e.keyCode == 37 || e.keyCode == 38) {\n\t\t\t\t\t\t\t\trng = ed.selection.getRng();\n\t\t\t\t\t\t\t\ttable = dom.getParent(rng.startContainer, 'table');\n\n\t\t\t\t\t\t\t\tif (table && ed.getBody().firstChild == table) {\n\t\t\t\t\t\t\t\t\tif (isAtStart(rng, table)) {\n\t\t\t\t\t\t\t\t\t\trng = dom.createRng();\n\n\t\t\t\t\t\t\t\t\t\trng.setStartBefore(table);\n\t\t\t\t\t\t\t\t\t\trng.setEndBefore(table);\n\n\t\t\t\t\t\t\t\t\t\ted.selection.setRng(rng);\n\n\t\t\t\t\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\n\t\t\t\t\ted.onKeyUp.add(fixTableCaretPos);\n\t\t\t\t\ted.onSetContent.add(fixTableCaretPos);\n\t\t\t\t\ted.onVisualAid.add(fixTableCaretPos);\n\n\t\t\t\t\ted.onPreProcess.add(function(ed, o) {\n\t\t\t\t\t\tvar last = o.node.lastChild;\n\n\t\t\t\t\t\tif (last && last.childNodes.length == 1 && last.firstChild.nodeName == 'BR')\n\t\t\t\t\t\t\ted.dom.remove(last);\n\t\t\t\t\t});\n\n\t\t\t\t\tfixTableCaretPos();\n\t\t\t\t\ted.startContent = ed.getContent({format : 'raw'});\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Register action commands\n\t\t\teach({\n\t\t\t\tmceTableSplitCells : function(grid) {\n\t\t\t\t\tgrid.split();\n\t\t\t\t},\n\n\t\t\t\tmceTableMergeCells : function(grid) {\n\t\t\t\t\tvar rowSpan, colSpan, cell;\n\n\t\t\t\t\tcell = ed.dom.getParent(ed.selection.getNode(), 'th,td');\n\t\t\t\t\tif (cell) {\n\t\t\t\t\t\trowSpan = cell.rowSpan;\n\t\t\t\t\t\tcolSpan = cell.colSpan;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!ed.dom.select('td.mceSelected,th.mceSelected').length) {\n\t\t\t\t\t\twinMan.open({\n\t\t\t\t\t\t\turl : url + '/merge_cells.htm',\n\t\t\t\t\t\t\twidth : 240 + parseInt(ed.getLang('table.merge_cells_delta_width', 0)),\n\t\t\t\t\t\t\theight : 110 + parseInt(ed.getLang('table.merge_cells_delta_height', 0)),\n\t\t\t\t\t\t\tinline : 1\n\t\t\t\t\t\t}, {\n\t\t\t\t\t\t\trows : rowSpan,\n\t\t\t\t\t\t\tcols : colSpan,\n\t\t\t\t\t\t\tonaction : function(data) {\n\t\t\t\t\t\t\t\tgrid.merge(cell, data.cols, data.rows);\n\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\tplugin_url : url\n\t\t\t\t\t\t});\n\t\t\t\t\t} else\n\t\t\t\t\t\tgrid.merge();\n\t\t\t\t},\n\n\t\t\t\tmceTableInsertRowBefore : function(grid) {\n\t\t\t\t\tgrid.insertRow(true);\n\t\t\t\t},\n\n\t\t\t\tmceTableInsertRowAfter : function(grid) {\n\t\t\t\t\tgrid.insertRow();\n\t\t\t\t},\n\n\t\t\t\tmceTableInsertColBefore : function(grid) {\n\t\t\t\t\tgrid.insertCol(true);\n\t\t\t\t},\n\n\t\t\t\tmceTableInsertColAfter : function(grid) {\n\t\t\t\t\tgrid.insertCol();\n\t\t\t\t},\n\n\t\t\t\tmceTableDeleteCol : function(grid) {\n\t\t\t\t\tgrid.deleteCols();\n\t\t\t\t},\n\n\t\t\t\tmceTableDeleteRow : function(grid) {\n\t\t\t\t\tgrid.deleteRows();\n\t\t\t\t},\n\n\t\t\t\tmceTableCutRow : function(grid) {\n\t\t\t\t\tclipboardRows = grid.cutRows();\n\t\t\t\t},\n\n\t\t\t\tmceTableCopyRow : function(grid) {\n\t\t\t\t\tclipboardRows = grid.copyRows();\n\t\t\t\t},\n\n\t\t\t\tmceTablePasteRowBefore : function(grid) {\n\t\t\t\t\tgrid.pasteRows(clipboardRows, true);\n\t\t\t\t},\n\n\t\t\t\tmceTablePasteRowAfter : function(grid) {\n\t\t\t\t\tgrid.pasteRows(clipboardRows);\n\t\t\t\t},\n\n\t\t\t\tmceTableDelete : function(grid) {\n\t\t\t\t\tgrid.deleteTable();\n\t\t\t\t}\n\t\t\t}, function(func, name) {\n\t\t\t\ted.addCommand(name, function() {\n\t\t\t\t\tvar grid = createTableGrid();\n\n\t\t\t\t\tif (grid) {\n\t\t\t\t\t\tfunc(grid);\n\t\t\t\t\t\ted.execCommand('mceRepaint');\n\t\t\t\t\t\tcleanup();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// Register dialog commands\n\t\t\teach({\n\t\t\t\tmceInsertTable : function(val) {\n\t\t\t\t\twinMan.open({\n\t\t\t\t\t\turl : url + '/table.htm',\n\t\t\t\t\t\twidth : 400 + parseInt(ed.getLang('table.table_delta_width', 0)),\n\t\t\t\t\t\theight : 320 + parseInt(ed.getLang('table.table_delta_height', 0)),\n\t\t\t\t\t\tinline : 1\n\t\t\t\t\t}, {\n\t\t\t\t\t\tplugin_url : url,\n\t\t\t\t\t\taction : val ? val.action : 0\n\t\t\t\t\t});\n\t\t\t\t},\n\n\t\t\t\tmceTableRowProps : function() {\n\t\t\t\t\twinMan.open({\n\t\t\t\t\t\turl : url + '/row.htm',\n\t\t\t\t\t\twidth : 400 + parseInt(ed.getLang('table.rowprops_delta_width', 0)),\n\t\t\t\t\t\theight : 295 + parseInt(ed.getLang('table.rowprops_delta_height', 0)),\n\t\t\t\t\t\tinline : 1\n\t\t\t\t\t}, {\n\t\t\t\t\t\tplugin_url : url\n\t\t\t\t\t});\n\t\t\t\t},\n\n\t\t\t\tmceTableCellProps : function() {\n\t\t\t\t\twinMan.open({\n\t\t\t\t\t\turl : url + '/cell.htm',\n\t\t\t\t\t\twidth : 400 + parseInt(ed.getLang('table.cellprops_delta_width', 0)),\n\t\t\t\t\t\theight : 295 + parseInt(ed.getLang('table.cellprops_delta_height', 0)),\n\t\t\t\t\t\tinline : 1\n\t\t\t\t\t}, {\n\t\t\t\t\t\tplugin_url : url\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}, function(func, name) {\n\t\t\t\ted.addCommand(name, function(ui, val) {\n\t\t\t\t\tfunc(val);\n\t\t\t\t});\n\t\t\t});\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('table', tinymce.plugins.TablePlugin);\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/plugins/table/js/table.js":"tinyMCEPopup.requireLangPack();\n\nvar action, orgTableWidth, orgTableHeight, dom = tinyMCEPopup.editor.dom;\n\nfunction insertTable() {\n\tvar formObj = document.forms[0];\n\tvar inst = tinyMCEPopup.editor, dom = inst.dom;\n\tvar cols = 2, rows = 2, border = 0, cellpadding = -1, cellspacing = -1, align, width, height, className, caption, frame, rules;\n\tvar html = '', capEl, elm;\n\tvar cellLimit, rowLimit, colLimit;\n\n\ttinyMCEPopup.restoreSelection();\n\n\tif (!AutoValidator.validate(formObj)) {\n\t\ttinyMCEPopup.alert(AutoValidator.getErrorMessages(formObj).join('. ') + '.');\n\t\treturn false;\n\t}\n\n\telm = dom.getParent(inst.selection.getNode(), 'table');\n\n\t// Get form data\n\tcols = formObj.elements['cols'].value;\n\trows = formObj.elements['rows'].value;\n\tborder = formObj.elements['border'].value != \"\" ? formObj.elements['border'].value : 0;\n\tcellpadding = formObj.elements['cellpadding'].value != \"\" ? formObj.elements['cellpadding'].value : \"\";\n\tcellspacing = formObj.elements['cellspacing'].value != \"\" ? formObj.elements['cellspacing'].value : \"\";\n\talign = getSelectValue(formObj, \"align\");\n\tframe = getSelectValue(formObj, \"tframe\");\n\trules = getSelectValue(formObj, \"rules\");\n\twidth = formObj.elements['width'].value;\n\theight = formObj.elements['height'].value;\n\tbordercolor = formObj.elements['bordercolor'].value;\n\tbgcolor = formObj.elements['bgcolor'].value;\n\tclassName = getSelectValue(formObj, \"class\");\n\tid = formObj.elements['id'].value;\n\tsummary = formObj.elements['summary'].value;\n\tstyle = formObj.elements['style'].value;\n\tdir = formObj.elements['dir'].value;\n\tlang = formObj.elements['lang'].value;\n\tbackground = formObj.elements['backgroundimage'].value;\n\tcaption = formObj.elements['caption'].checked;\n\n\tcellLimit = tinyMCEPopup.getParam('table_cell_limit', false);\n\trowLimit = tinyMCEPopup.getParam('table_row_limit', false);\n\tcolLimit = tinyMCEPopup.getParam('table_col_limit', false);\n\n\t// Validate table size\n\tif (colLimit && cols > colLimit) {\n\t\ttinyMCEPopup.alert(inst.getLang('table_dlg.col_limit').replace(/\\{\\$cols\\}/g, colLimit));\n\t\treturn false;\n\t} else if (rowLimit && rows > rowLimit) {\n\t\ttinyMCEPopup.alert(inst.getLang('table_dlg.row_limit').replace(/\\{\\$rows\\}/g, rowLimit));\n\t\treturn false;\n\t} else if (cellLimit && cols * rows > cellLimit) {\n\t\ttinyMCEPopup.alert(inst.getLang('table_dlg.cell_limit').replace(/\\{\\$cells\\}/g, cellLimit));\n\t\treturn false;\n\t}\n\n\t// Update table\n\tif (action == \"update\") {\n\t\tdom.setAttrib(elm, 'cellPadding', cellpadding, true);\n\t\tdom.setAttrib(elm, 'cellSpacing', cellspacing, true);\n\n\t\tif (!isCssSize(border)) {\n\t\t\tdom.setAttrib(elm, 'border', border);\n\t\t} else {\n\t\t\tdom.setAttrib(elm, 'border', '');\n\t\t}\n\n\t\tif (border == '') {\n\t\t\tdom.setStyle(elm, 'border-width', '');\n\t\t\tdom.setStyle(elm, 'border', '');\n\t\t\tdom.setAttrib(elm, 'border', '');\n\t\t}\n\n\t\tdom.setAttrib(elm, 'align', align);\n\t\tdom.setAttrib(elm, 'frame', frame);\n\t\tdom.setAttrib(elm, 'rules', rules);\n\t\tdom.setAttrib(elm, 'class', className);\n\t\tdom.setAttrib(elm, 'style', style);\n\t\tdom.setAttrib(elm, 'id', id);\n\t\tdom.setAttrib(elm, 'summary', summary);\n\t\tdom.setAttrib(elm, 'dir', dir);\n\t\tdom.setAttrib(elm, 'lang', lang);\n\n\t\tcapEl = inst.dom.select('caption', elm)[0];\n\n\t\tif (capEl && !caption)\n\t\t\tcapEl.parentNode.removeChild(capEl);\n\n\t\tif (!capEl && caption) {\n\t\t\tcapEl = elm.ownerDocument.createElement('caption');\n\n\t\t\tif (!tinymce.isIE)\n\t\t\t\tcapEl.innerHTML = '<br data-mce-bogus=\"1\"/>';\n\n\t\t\telm.insertBefore(capEl, elm.firstChild);\n\t\t}\n\n\t\tif (width && inst.settings.inline_styles) {\n\t\t\tdom.setStyle(elm, 'width', width);\n\t\t\tdom.setAttrib(elm, 'width', '');\n\t\t} else {\n\t\t\tdom.setAttrib(elm, 'width', width, true);\n\t\t\tdom.setStyle(elm, 'width', '');\n\t\t}\n\n\t\t// Remove these since they are not valid XHTML\n\t\tdom.setAttrib(elm, 'borderColor', '');\n\t\tdom.setAttrib(elm, 'bgColor', '');\n\t\tdom.setAttrib(elm, 'background', '');\n\n\t\tif (height && inst.settings.inline_styles) {\n\t\t\tdom.setStyle(elm, 'height', height);\n\t\t\tdom.setAttrib(elm, 'height', '');\n\t\t} else {\n\t\t\tdom.setAttrib(elm, 'height', height, true);\n\t\t\tdom.setStyle(elm, 'height', '');\n \t\t}\n\n\t\tif (background != '')\n\t\t\telm.style.backgroundImage = \"url('\" + background + \"')\";\n\t\telse\n\t\t\telm.style.backgroundImage = '';\n\n/*\t\tif (tinyMCEPopup.getParam(\"inline_styles\")) {\n\t\t\tif (width != '')\n\t\t\t\telm.style.width = getCSSSize(width);\n\t\t}*/\n\n\t\tif (bordercolor != \"\") {\n\t\t\telm.style.borderColor = bordercolor;\n\t\t\telm.style.borderStyle = elm.style.borderStyle == \"\" ? \"solid\" : elm.style.borderStyle;\n\t\t\telm.style.borderWidth = cssSize(border);\n\t\t} else\n\t\t\telm.style.borderColor = '';\n\n\t\telm.style.backgroundColor = bgcolor;\n\t\telm.style.height = getCSSSize(height);\n\n\t\tinst.addVisual();\n\n\t\t// Fix for stange MSIE align bug\n\t\t//elm.outerHTML = elm.outerHTML;\n\n\t\tinst.nodeChanged();\n\t\tinst.execCommand('mceEndUndoLevel');\n\n\t\t// Repaint if dimensions changed\n\t\tif (formObj.width.value != orgTableWidth || formObj.height.value != orgTableHeight)\n\t\t\tinst.execCommand('mceRepaint');\n\n\t\ttinyMCEPopup.close();\n\t\treturn true;\n\t}\n\n\t// Create new table\n\thtml += '<table';\n\n\thtml += makeAttrib('id', id);\n\tif (!isCssSize(border)) {\n\t\thtml += makeAttrib('border', border);\n\t}\n\n\thtml += makeAttrib('cellpadding', cellpadding);\n\thtml += makeAttrib('cellspacing', cellspacing);\n\thtml += makeAttrib('data-mce-new', '1');\n\n\tif (width && inst.settings.inline_styles) {\n\t\tif (style)\n\t\t\tstyle += '; ';\n\n\t\t// Force px\n\t\tif (/^[0-9\\.]+$/.test(width))\n\t\t\twidth += 'px';\n\n\t\tstyle += 'width: ' + width;\n\t} else\n\t\thtml += makeAttrib('width', width);\n\n/*\tif (height) {\n\t\tif (style)\n\t\t\tstyle += '; ';\n\n\t\tstyle += 'height: ' + height;\n\t}*/\n\n\t//html += makeAttrib('height', height);\n\t//html += makeAttrib('bordercolor', bordercolor);\n\t//html += makeAttrib('bgcolor', bgcolor);\n\thtml += makeAttrib('align', align);\n\thtml += makeAttrib('frame', frame);\n\thtml += makeAttrib('rules', rules);\n\thtml += makeAttrib('class', className);\n\thtml += makeAttrib('style', style);\n\thtml += makeAttrib('summary', summary);\n\thtml += makeAttrib('dir', dir);\n\thtml += makeAttrib('lang', lang);\n\thtml += '>';\n\n\tif (caption) {\n\t\tif (!tinymce.isIE)\n\t\t\thtml += '<caption><br data-mce-bogus=\"1\"/></caption>';\n\t\telse\n\t\t\thtml += '<caption></caption>';\n\t}\n\n\tfor (var y=0; y<rows; y++) {\n\t\thtml += \"<tr>\";\n\n\t\tfor (var x=0; x<cols; x++) {\n\t\t\tif (!tinymce.isIE)\n\t\t\t\thtml += '<td><br data-mce-bogus=\"1\"/></td>';\n\t\t\telse\n\t\t\t\thtml += '<td></td>';\n\t\t}\n\n\t\thtml += \"</tr>\";\n\t}\n\n\thtml += \"</table>\";\n\n\t// Move table\n\tif (inst.settings.fix_table_elements) {\n\t\tvar patt = '';\n\n\t\tinst.focus();\n\t\tinst.selection.setContent('<br class=\"_mce_marker\" />');\n\n\t\ttinymce.each('h1,h2,h3,h4,h5,h6,p'.split(','), function(n) {\n\t\t\tif (patt)\n\t\t\t\tpatt += ',';\n\n\t\t\tpatt += n + ' ._mce_marker';\n\t\t});\n\n\t\ttinymce.each(inst.dom.select(patt), function(n) {\n\t\t\tinst.dom.split(inst.dom.getParent(n, 'h1,h2,h3,h4,h5,h6,p'), n);\n\t\t});\n\n\t\tdom.setOuterHTML(dom.select('br._mce_marker')[0], html);\n\t} else\n\t\tinst.execCommand('mceInsertContent', false, html);\n\n\ttinymce.each(dom.select('table[data-mce-new]'), function(node) {\n\t\tvar tdorth = dom.select('td,th', node);\n\n\t\ttry {\n\t\t\t// IE9 might fail to do this selection \n\t\t\tinst.selection.setCursorLocation(tdorth[0], 0);\n\t\t} catch (ex) {\n\t\t\t// Ignore\n\t\t}\n\n\t\tdom.setAttrib(node, 'data-mce-new', '');\n\t});\n\n\tinst.addVisual();\n\tinst.execCommand('mceEndUndoLevel');\n\n\ttinyMCEPopup.close();\n}\n\nfunction makeAttrib(attrib, value) {\n\tvar formObj = document.forms[0];\n\tvar valueElm = formObj.elements[attrib];\n\n\tif (typeof(value) == \"undefined\" || value == null) {\n\t\tvalue = \"\";\n\n\t\tif (valueElm)\n\t\t\tvalue = valueElm.value;\n\t}\n\n\tif (value == \"\")\n\t\treturn \"\";\n\n\t// XML encode it\n\tvalue = value.replace(/&/g, '&amp;');\n\tvalue = value.replace(/\\\"/g, '&quot;');\n\tvalue = value.replace(/</g, '&lt;');\n\tvalue = value.replace(/>/g, '&gt;');\n\n\treturn ' ' + attrib + '=\"' + value + '\"';\n}\n\nfunction init() {\n\ttinyMCEPopup.resizeToInnerSize();\n\n\tdocument.getElementById('backgroundimagebrowsercontainer').innerHTML = getBrowserHTML('backgroundimagebrowser','backgroundimage','image','table');\n\tdocument.getElementById('backgroundimagebrowsercontainer').innerHTML = getBrowserHTML('backgroundimagebrowser','backgroundimage','image','table');\n\tdocument.getElementById('bordercolor_pickcontainer').innerHTML = getColorPickerHTML('bordercolor_pick','bordercolor');\n\tdocument.getElementById('bgcolor_pickcontainer').innerHTML = getColorPickerHTML('bgcolor_pick','bgcolor');\n\n\tvar cols = 2, rows = 2, border = tinyMCEPopup.getParam('table_default_border', '0'), cellpadding = tinyMCEPopup.getParam('table_default_cellpadding', ''), cellspacing = tinyMCEPopup.getParam('table_default_cellspacing', '');\n\tvar align = \"\", width = \"\", height = \"\", bordercolor = \"\", bgcolor = \"\", className = \"\";\n\tvar id = \"\", summary = \"\", style = \"\", dir = \"\", lang = \"\", background = \"\", bgcolor = \"\", bordercolor = \"\", rules = \"\", frame = \"\";\n\tvar inst = tinyMCEPopup.editor, dom = inst.dom;\n\tvar formObj = document.forms[0];\n\tvar elm = dom.getParent(inst.selection.getNode(), \"table\");\n\n\taction = tinyMCEPopup.getWindowArg('action');\n\n\tif (!action)\n\t\taction = elm ? \"update\" : \"insert\";\n\n\tif (elm && action != \"insert\") {\n\t\tvar rowsAr = elm.rows;\n\t\tvar cols = 0;\n\t\tfor (var i=0; i<rowsAr.length; i++)\n\t\t\tif (rowsAr[i].cells.length > cols)\n\t\t\t\tcols = rowsAr[i].cells.length;\n\n\t\tcols = cols;\n\t\trows = rowsAr.length;\n\n\t\tst = dom.parseStyle(dom.getAttrib(elm, \"style\"));\n\t\tborder = trimSize(getStyle(elm, 'border', 'borderWidth'));\n\t\tcellpadding = dom.getAttrib(elm, 'cellpadding', \"\");\n\t\tcellspacing = dom.getAttrib(elm, 'cellspacing', \"\");\n\t\twidth = trimSize(getStyle(elm, 'width', 'width'));\n\t\theight = trimSize(getStyle(elm, 'height', 'height'));\n\t\tbordercolor = convertRGBToHex(getStyle(elm, 'bordercolor', 'borderLeftColor'));\n\t\tbgcolor = convertRGBToHex(getStyle(elm, 'bgcolor', 'backgroundColor'));\n\t\talign = dom.getAttrib(elm, 'align', align);\n\t\tframe = dom.getAttrib(elm, 'frame');\n\t\trules = dom.getAttrib(elm, 'rules');\n\t\tclassName = tinymce.trim(dom.getAttrib(elm, 'class').replace(/mceItem.+/g, ''));\n\t\tid = dom.getAttrib(elm, 'id');\n\t\tsummary = dom.getAttrib(elm, 'summary');\n\t\tstyle = dom.serializeStyle(st);\n\t\tdir = dom.getAttrib(elm, 'dir');\n\t\tlang = dom.getAttrib(elm, 'lang');\n\t\tbackground = getStyle(elm, 'background', 'backgroundImage').replace(new RegExp(\"url\\\\(['\\\"]?([^'\\\"]*)['\\\"]?\\\\)\", 'gi'), \"$1\");\n\t\tformObj.caption.checked = elm.getElementsByTagName('caption').length > 0;\n\n\t\torgTableWidth = width;\n\t\torgTableHeight = height;\n\n\t\taction = \"update\";\n\t\tformObj.insert.value = inst.getLang('update');\n\t}\n\n\taddClassesToList('class', \"table_styles\");\n\tTinyMCE_EditableSelects.init();\n\n\t// Update form\n\tselectByValue(formObj, 'align', align);\n\tselectByValue(formObj, 'tframe', frame);\n\tselectByValue(formObj, 'rules', rules);\n\tselectByValue(formObj, 'class', className, true, true);\n\tformObj.cols.value = cols;\n\tformObj.rows.value = rows;\n\tformObj.border.value = border;\n\tformObj.cellpadding.value = cellpadding;\n\tformObj.cellspacing.value = cellspacing;\n\tformObj.width.value = width;\n\tformObj.height.value = height;\n\tformObj.bordercolor.value = bordercolor;\n\tformObj.bgcolor.value = bgcolor;\n\tformObj.id.value = id;\n\tformObj.summary.value = summary;\n\tformObj.style.value = style;\n\tformObj.dir.value = dir;\n\tformObj.lang.value = lang;\n\tformObj.backgroundimage.value = background;\n\n\tupdateColor('bordercolor_pick', 'bordercolor');\n\tupdateColor('bgcolor_pick', 'bgcolor');\n\n\t// Resize some elements\n\tif (isVisible('backgroundimagebrowser'))\n\t\tdocument.getElementById('backgroundimage').style.width = '180px';\n\n\t// Disable some fields in update mode\n\tif (action == \"update\") {\n\t\tformObj.cols.disabled = true;\n\t\tformObj.rows.disabled = true;\n\t}\n}\n\nfunction changedSize() {\n\tvar formObj = document.forms[0];\n\tvar st = dom.parseStyle(formObj.style.value);\n\n/*\tvar width = formObj.width.value;\n\tif (width != \"\")\n\t\tst['width'] = tinyMCEPopup.getParam(\"inline_styles\") ? getCSSSize(width) : \"\";\n\telse\n\t\tst['width'] = \"\";*/\n\n\tvar height = formObj.height.value;\n\tif (height != \"\")\n\t\tst['height'] = getCSSSize(height);\n\telse\n\t\tst['height'] = \"\";\n\n\tformObj.style.value = dom.serializeStyle(st);\n}\n\nfunction isCssSize(value) {\n\treturn /^[0-9.]+(%|in|cm|mm|em|ex|pt|pc|px)$/.test(value);\n}\n\nfunction cssSize(value, def) {\n\tvalue = tinymce.trim(value || def);\n\n\tif (!isCssSize(value)) {\n\t\treturn parseInt(value, 10) + 'px';\n\t}\n\n\treturn value;\n}\n\nfunction changedBackgroundImage() {\n\tvar formObj = document.forms[0];\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\tst['background-image'] = \"url('\" + formObj.backgroundimage.value + \"')\";\n\n\tformObj.style.value = dom.serializeStyle(st);\n}\n\nfunction changedBorder() {\n\tvar formObj = document.forms[0];\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\t// Update border width if the element has a color\n\tif (formObj.border.value != \"\" && (isCssSize(formObj.border.value) || formObj.bordercolor.value != \"\"))\n\t\tst['border-width'] = cssSize(formObj.border.value);\n\telse {\n\t\tif (!formObj.border.value) {\n\t\t\tst['border'] = '';\n\t\t\tst['border-width'] = '';\n\t\t}\n\t}\n\n\tformObj.style.value = dom.serializeStyle(st);\n}\n\nfunction changedColor() {\n\tvar formObj = document.forms[0];\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\tst['background-color'] = formObj.bgcolor.value;\n\n\tif (formObj.bordercolor.value != \"\") {\n\t\tst['border-color'] = formObj.bordercolor.value;\n\n\t\t// Add border-width if it's missing\n\t\tif (!st['border-width'])\n\t\t\tst['border-width'] = cssSize(formObj.border.value, 1);\n\t}\n\n\tformObj.style.value = dom.serializeStyle(st);\n}\n\nfunction changedStyle() {\n\tvar formObj = document.forms[0];\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\tif (st['background-image'])\n\t\tformObj.backgroundimage.value = st['background-image'].replace(new RegExp(\"url\\\\(['\\\"]?([^'\\\"]*)['\\\"]?\\\\)\", 'gi'), \"$1\");\n\telse\n\t\tformObj.backgroundimage.value = '';\n\n\tif (st['width'])\n\t\tformObj.width.value = trimSize(st['width']);\n\n\tif (st['height'])\n\t\tformObj.height.value = trimSize(st['height']);\n\n\tif (st['background-color']) {\n\t\tformObj.bgcolor.value = st['background-color'];\n\t\tupdateColor('bgcolor_pick','bgcolor');\n\t}\n\n\tif (st['border-color']) {\n\t\tformObj.bordercolor.value = st['border-color'];\n\t\tupdateColor('bordercolor_pick','bordercolor');\n\t}\n}\n\ntinyMCEPopup.onInit.add(init);\n","Magento_Tinymce3/tiny_mce/plugins/table/js/row.js":"tinyMCEPopup.requireLangPack();\n\nfunction init() {\n\ttinyMCEPopup.resizeToInnerSize();\n\n\tdocument.getElementById('backgroundimagebrowsercontainer').innerHTML = getBrowserHTML('backgroundimagebrowser','backgroundimage','image','table');\n\tdocument.getElementById('bgcolor_pickcontainer').innerHTML = getColorPickerHTML('bgcolor_pick','bgcolor');\n\n\tvar inst = tinyMCEPopup.editor;\n\tvar dom = inst.dom;\n\tvar trElm = dom.getParent(inst.selection.getStart(), \"tr\");\n\tvar formObj = document.forms[0];\n\tvar st = dom.parseStyle(dom.getAttrib(trElm, \"style\"));\n\n\t// Get table row data\n\tvar rowtype = trElm.parentNode.nodeName.toLowerCase();\n\tvar align = dom.getAttrib(trElm, 'align');\n\tvar valign = dom.getAttrib(trElm, 'valign');\n\tvar height = trimSize(getStyle(trElm, 'height', 'height'));\n\tvar className = dom.getAttrib(trElm, 'class');\n\tvar bgcolor = convertRGBToHex(getStyle(trElm, 'bgcolor', 'backgroundColor'));\n\tvar backgroundimage = getStyle(trElm, 'background', 'backgroundImage').replace(new RegExp(\"url\\\\(['\\\"]?([^'\\\"]*)['\\\"]?\\\\)\", 'gi'), \"$1\");\n\tvar id = dom.getAttrib(trElm, 'id');\n\tvar lang = dom.getAttrib(trElm, 'lang');\n\tvar dir = dom.getAttrib(trElm, 'dir');\n\n\tselectByValue(formObj, 'rowtype', rowtype);\n\n\t// Any cells selected\n\tif (dom.select('td.mceSelected,th.mceSelected', trElm).length == 0) {\n\t\t// Setup form\n\t\taddClassesToList('class', 'table_row_styles');\n\t\tTinyMCE_EditableSelects.init();\n\n\t\tformObj.bgcolor.value = bgcolor;\n\t\tformObj.backgroundimage.value = backgroundimage;\n\t\tformObj.height.value = height;\n\t\tformObj.id.value = id;\n\t\tformObj.lang.value = lang;\n\t\tformObj.style.value = dom.serializeStyle(st);\n\t\tselectByValue(formObj, 'align', align);\n\t\tselectByValue(formObj, 'valign', valign);\n\t\tselectByValue(formObj, 'class', className, true, true);\n\t\tselectByValue(formObj, 'dir', dir);\n\n\t\t// Resize some elements\n\t\tif (isVisible('backgroundimagebrowser'))\n\t\t\tdocument.getElementById('backgroundimage').style.width = '180px';\n\n\t\tupdateColor('bgcolor_pick', 'bgcolor');\n\t} else\n\t\ttinyMCEPopup.dom.hide('action');\n}\n\nfunction updateAction() {\n\tvar inst = tinyMCEPopup.editor, dom = inst.dom, trElm, tableElm, formObj = document.forms[0];\n\tvar action = getSelectValue(formObj, 'action');\n\n\tif (!AutoValidator.validate(formObj)) {\n\t\ttinyMCEPopup.alert(AutoValidator.getErrorMessages(formObj).join('. ') + '.');\n\t\treturn false;\n\t}\n\n\ttinyMCEPopup.restoreSelection();\n\ttrElm = dom.getParent(inst.selection.getStart(), \"tr\");\n\ttableElm = dom.getParent(inst.selection.getStart(), \"table\");\n\n\t// Update all selected rows\n\tif (dom.select('td.mceSelected,th.mceSelected', trElm).length > 0) {\n\t\ttinymce.each(tableElm.rows, function(tr) {\n\t\t\tvar i;\n\n\t\t\tfor (i = 0; i < tr.cells.length; i++) {\n\t\t\t\tif (dom.hasClass(tr.cells[i], 'mceSelected')) {\n\t\t\t\t\tupdateRow(tr, true);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\tinst.addVisual();\n\t\tinst.nodeChanged();\n\t\tinst.execCommand('mceEndUndoLevel');\n\t\ttinyMCEPopup.close();\n\t\treturn;\n\t}\n\n\tswitch (action) {\n\t\tcase \"row\":\n\t\t\tupdateRow(trElm);\n\t\t\tbreak;\n\n\t\tcase \"all\":\n\t\t\tvar rows = tableElm.getElementsByTagName(\"tr\");\n\n\t\t\tfor (var i=0; i<rows.length; i++)\n\t\t\t\tupdateRow(rows[i], true);\n\n\t\t\tbreak;\n\n\t\tcase \"odd\":\n\t\tcase \"even\":\n\t\t\tvar rows = tableElm.getElementsByTagName(\"tr\");\n\n\t\t\tfor (var i=0; i<rows.length; i++) {\n\t\t\t\tif ((i % 2 == 0 && action == \"odd\") || (i % 2 != 0 && action == \"even\"))\n\t\t\t\t\tupdateRow(rows[i], true, true);\n\t\t\t}\n\n\t\t\tbreak;\n\t}\n\n\tinst.addVisual();\n\tinst.nodeChanged();\n\tinst.execCommand('mceEndUndoLevel');\n\ttinyMCEPopup.close();\n}\n\nfunction updateRow(tr_elm, skip_id, skip_parent) {\n\tvar inst = tinyMCEPopup.editor;\n\tvar formObj = document.forms[0];\n\tvar dom = inst.dom;\n\tvar curRowType = tr_elm.parentNode.nodeName.toLowerCase();\n\tvar rowtype = getSelectValue(formObj, 'rowtype');\n\tvar doc = inst.getDoc();\n\n\t// Update row element\n\tif (!skip_id)\n\t\tdom.setAttrib(tr_elm, 'id', formObj.id.value);\n\n\tdom.setAttrib(tr_elm, 'align', getSelectValue(formObj, 'align'));\n\tdom.setAttrib(tr_elm, 'vAlign', getSelectValue(formObj, 'valign'));\n\tdom.setAttrib(tr_elm, 'lang', formObj.lang.value);\n\tdom.setAttrib(tr_elm, 'dir', getSelectValue(formObj, 'dir'));\n\tdom.setAttrib(tr_elm, 'style', dom.serializeStyle(dom.parseStyle(formObj.style.value)));\n\tdom.setAttrib(tr_elm, 'class', getSelectValue(formObj, 'class'));\n\n\t// Clear deprecated attributes\n\tdom.setAttrib(tr_elm, 'background', '');\n\tdom.setAttrib(tr_elm, 'bgColor', '');\n\tdom.setAttrib(tr_elm, 'height', '');\n\n\t// Set styles\n\ttr_elm.style.height = getCSSSize(formObj.height.value);\n\ttr_elm.style.backgroundColor = formObj.bgcolor.value;\n\n\tif (formObj.backgroundimage.value != \"\")\n\t\ttr_elm.style.backgroundImage = \"url('\" + formObj.backgroundimage.value + \"')\";\n\telse\n\t\ttr_elm.style.backgroundImage = '';\n\n\t// Setup new rowtype\n\tif (curRowType != rowtype && !skip_parent) {\n\t\t// first, clone the node we are working on\n\t\tvar newRow = tr_elm.cloneNode(1);\n\n\t\t// next, find the parent of its new destination (creating it if necessary)\n\t\tvar theTable = dom.getParent(tr_elm, \"table\");\n\t\tvar dest = rowtype;\n\t\tvar newParent = null;\n\t\tfor (var i = 0; i < theTable.childNodes.length; i++) {\n\t\t\tif (theTable.childNodes[i].nodeName.toLowerCase() == dest)\n\t\t\t\tnewParent = theTable.childNodes[i];\n\t\t}\n\n\t\tif (newParent == null) {\n\t\t\tnewParent = doc.createElement(dest);\n\n\t\t\tif (theTable.firstChild.nodeName == 'CAPTION')\n\t\t\t\tinst.dom.insertAfter(newParent, theTable.firstChild);\n\t\t\telse\n\t\t\t\ttheTable.insertBefore(newParent, theTable.firstChild);\n\t\t}\n\n\t\t// append the row to the new parent\n\t\tnewParent.appendChild(newRow);\n\n\t\t// remove the original\n\t\ttr_elm.parentNode.removeChild(tr_elm);\n\n\t\t// set tr_elm to the new node\n\t\ttr_elm = newRow;\n\t}\n\n\tdom.setAttrib(tr_elm, 'style', dom.serializeStyle(dom.parseStyle(tr_elm.style.cssText)));\n}\n\nfunction changedBackgroundImage() {\n\tvar formObj = document.forms[0], dom = tinyMCEPopup.editor.dom;\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\tst['background-image'] = \"url('\" + formObj.backgroundimage.value + \"')\";\n\n\tformObj.style.value = dom.serializeStyle(st);\n}\n\nfunction changedStyle() {\n\tvar formObj = document.forms[0], dom = tinyMCEPopup.editor.dom;\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\tif (st['background-image'])\n\t\tformObj.backgroundimage.value = st['background-image'].replace(new RegExp(\"url\\\\('?([^']*)'?\\\\)\", 'gi'), \"$1\");\n\telse\n\t\tformObj.backgroundimage.value = '';\n\n\tif (st['height'])\n\t\tformObj.height.value = trimSize(st['height']);\n\n\tif (st['background-color']) {\n\t\tformObj.bgcolor.value = st['background-color'];\n\t\tupdateColor('bgcolor_pick','bgcolor');\n\t}\n}\n\nfunction changedSize() {\n\tvar formObj = document.forms[0], dom = tinyMCEPopup.editor.dom;\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\tvar height = formObj.height.value;\n\tif (height != \"\")\n\t\tst['height'] = getCSSSize(height);\n\telse\n\t\tst['height'] = \"\";\n\n\tformObj.style.value = dom.serializeStyle(st);\n}\n\nfunction changedColor() {\n\tvar formObj = document.forms[0], dom = tinyMCEPopup.editor.dom;\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\tst['background-color'] = formObj.bgcolor.value;\n\n\tformObj.style.value = dom.serializeStyle(st);\n}\n\ntinyMCEPopup.onInit.add(init);\n","Magento_Tinymce3/tiny_mce/plugins/table/js/cell.js":"tinyMCEPopup.requireLangPack();\n\nvar ed;\n\nfunction init() {\n\ted = tinyMCEPopup.editor;\n\ttinyMCEPopup.resizeToInnerSize();\n\n\tdocument.getElementById('backgroundimagebrowsercontainer').innerHTML = getBrowserHTML('backgroundimagebrowser','backgroundimage','image','table');\n\tdocument.getElementById('bordercolor_pickcontainer').innerHTML = getColorPickerHTML('bordercolor_pick','bordercolor');\n\tdocument.getElementById('bgcolor_pickcontainer').innerHTML = getColorPickerHTML('bgcolor_pick','bgcolor')\n\n\tvar inst = ed;\n\tvar tdElm = ed.dom.getParent(ed.selection.getStart(), \"td,th\");\n\tvar formObj = document.forms[0];\n\tvar st = ed.dom.parseStyle(ed.dom.getAttrib(tdElm, \"style\"));\n\n\t// Get table cell data\n\tvar celltype = tdElm.nodeName.toLowerCase();\n\tvar align = ed.dom.getAttrib(tdElm, 'align');\n\tvar valign = ed.dom.getAttrib(tdElm, 'valign');\n\tvar width = trimSize(getStyle(tdElm, 'width', 'width'));\n\tvar height = trimSize(getStyle(tdElm, 'height', 'height'));\n\tvar bordercolor = convertRGBToHex(getStyle(tdElm, 'bordercolor', 'borderLeftColor'));\n\tvar bgcolor = convertRGBToHex(getStyle(tdElm, 'bgcolor', 'backgroundColor'));\n\tvar className = ed.dom.getAttrib(tdElm, 'class');\n\tvar backgroundimage = getStyle(tdElm, 'background', 'backgroundImage').replace(new RegExp(\"url\\\\(['\\\"]?([^'\\\"]*)['\\\"]?\\\\)\", 'gi'), \"$1\");\n\tvar id = ed.dom.getAttrib(tdElm, 'id');\n\tvar lang = ed.dom.getAttrib(tdElm, 'lang');\n\tvar dir = ed.dom.getAttrib(tdElm, 'dir');\n\tvar scope = ed.dom.getAttrib(tdElm, 'scope');\n\n\t// Setup form\n\taddClassesToList('class', 'table_cell_styles');\n\tTinyMCE_EditableSelects.init();\n\n\tif (!ed.dom.hasClass(tdElm, 'mceSelected')) {\n\t\tformObj.bordercolor.value = bordercolor;\n\t\tformObj.bgcolor.value = bgcolor;\n\t\tformObj.backgroundimage.value = backgroundimage;\n\t\tformObj.width.value = width;\n\t\tformObj.height.value = height;\n\t\tformObj.id.value = id;\n\t\tformObj.lang.value = lang;\n\t\tformObj.style.value = ed.dom.serializeStyle(st);\n\t\tselectByValue(formObj, 'align', align);\n\t\tselectByValue(formObj, 'valign', valign);\n\t\tselectByValue(formObj, 'class', className, true, true);\n\t\tselectByValue(formObj, 'celltype', celltype);\n\t\tselectByValue(formObj, 'dir', dir);\n\t\tselectByValue(formObj, 'scope', scope);\n\n\t\t// Resize some elements\n\t\tif (isVisible('backgroundimagebrowser'))\n\t\t\tdocument.getElementById('backgroundimage').style.width = '180px';\n\n\t\tupdateColor('bordercolor_pick', 'bordercolor');\n\t\tupdateColor('bgcolor_pick', 'bgcolor');\n\t} else\n\t\ttinyMCEPopup.dom.hide('action');\n}\n\nfunction updateAction() {\n\tvar el, inst = ed, tdElm, trElm, tableElm, formObj = document.forms[0];\n\n\tif (!AutoValidator.validate(formObj)) {\n\t\ttinyMCEPopup.alert(AutoValidator.getErrorMessages(formObj).join('. ') + '.');\n\t\treturn false;\n\t}\n\n\ttinyMCEPopup.restoreSelection();\n\tel = ed.selection.getStart();\n\ttdElm = ed.dom.getParent(el, \"td,th\");\n\ttrElm = ed.dom.getParent(el, \"tr\");\n\ttableElm = ed.dom.getParent(el, \"table\");\n\n\t// Cell is selected\n\tif (ed.dom.hasClass(tdElm, 'mceSelected')) {\n\t\t// Update all selected sells\n\t\ttinymce.each(ed.dom.select('td.mceSelected,th.mceSelected'), function(td) {\n\t\t\tupdateCell(td);\n\t\t});\n\n\t\ted.addVisual();\n\t\ted.nodeChanged();\n\t\tinst.execCommand('mceEndUndoLevel');\n\t\ttinyMCEPopup.close();\n\t\treturn;\n\t}\n\n\tswitch (getSelectValue(formObj, 'action')) {\n\t\tcase \"cell\":\n\t\t\tvar celltype = getSelectValue(formObj, 'celltype');\n\t\t\tvar scope = getSelectValue(formObj, 'scope');\n\n\t\t\tfunction doUpdate(s) {\n\t\t\t\tif (s) {\n\t\t\t\t\tupdateCell(tdElm);\n\n\t\t\t\t\ted.addVisual();\n\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\tinst.execCommand('mceEndUndoLevel');\n\t\t\t\t\ttinyMCEPopup.close();\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tif (ed.getParam(\"accessibility_warnings\", 1)) {\n\t\t\t\tif (celltype == \"th\" && scope == \"\")\n\t\t\t\t\ttinyMCEPopup.confirm(ed.getLang('table_dlg.missing_scope', '', true), doUpdate);\n\t\t\t\telse\n\t\t\t\t\tdoUpdate(1);\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tupdateCell(tdElm);\n\t\t\tbreak;\n\n\t\tcase \"row\":\n\t\t\tvar cell = trElm.firstChild;\n\n\t\t\tif (cell.nodeName != \"TD\" && cell.nodeName != \"TH\")\n\t\t\t\tcell = nextCell(cell);\n\n\t\t\tdo {\n\t\t\t\tcell = updateCell(cell, true);\n\t\t\t} while ((cell = nextCell(cell)) != null);\n\n\t\t\tbreak;\n\n\t\tcase \"col\":\n\t\t\tvar curr, col = 0, cell = trElm.firstChild, rows = tableElm.getElementsByTagName(\"tr\");\n\n\t\t\tif (cell.nodeName != \"TD\" && cell.nodeName != \"TH\")\n\t\t\t\tcell = nextCell(cell);\n\n\t\t\tdo {\n\t\t\t\tif (cell == tdElm)\n\t\t\t\t\tbreak;\n\t\t\t\tcol += cell.getAttribute(\"colspan\");\n\t\t\t} while ((cell = nextCell(cell)) != null);\n\n\t\t\tfor (var i=0; i<rows.length; i++) {\n\t\t\t\tcell = rows[i].firstChild;\n\n\t\t\t\tif (cell.nodeName != \"TD\" && cell.nodeName != \"TH\")\n\t\t\t\t\tcell = nextCell(cell);\n\n\t\t\t\tcurr = 0;\n\t\t\t\tdo {\n\t\t\t\t\tif (curr == col) {\n\t\t\t\t\t\tcell = updateCell(cell, true);\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t\tcurr += cell.getAttribute(\"colspan\");\n\t\t\t\t} while ((cell = nextCell(cell)) != null);\n\t\t\t}\n\n\t\t\tbreak;\n\n\t\tcase \"all\":\n\t\t\tvar rows = tableElm.getElementsByTagName(\"tr\");\n\n\t\t\tfor (var i=0; i<rows.length; i++) {\n\t\t\t\tvar cell = rows[i].firstChild;\n\n\t\t\t\tif (cell.nodeName != \"TD\" && cell.nodeName != \"TH\")\n\t\t\t\t\tcell = nextCell(cell);\n\n\t\t\t\tdo {\n\t\t\t\t\tcell = updateCell(cell, true);\n\t\t\t\t} while ((cell = nextCell(cell)) != null);\n\t\t\t}\n\n\t\t\tbreak;\n\t}\n\n\ted.addVisual();\n\ted.nodeChanged();\n\tinst.execCommand('mceEndUndoLevel');\n\ttinyMCEPopup.close();\n}\n\nfunction nextCell(elm) {\n\twhile ((elm = elm.nextSibling) != null) {\n\t\tif (elm.nodeName == \"TD\" || elm.nodeName == \"TH\")\n\t\t\treturn elm;\n\t}\n\n\treturn null;\n}\n\nfunction updateCell(td, skip_id) {\n\tvar inst = ed;\n\tvar formObj = document.forms[0];\n\tvar curCellType = td.nodeName.toLowerCase();\n\tvar celltype = getSelectValue(formObj, 'celltype');\n\tvar doc = inst.getDoc();\n\tvar dom = ed.dom;\n\n\tif (!skip_id)\n\t\tdom.setAttrib(td, 'id', formObj.id.value);\n\n\tdom.setAttrib(td, 'align', formObj.align.value);\n\tdom.setAttrib(td, 'vAlign', formObj.valign.value);\n\tdom.setAttrib(td, 'lang', formObj.lang.value);\n\tdom.setAttrib(td, 'dir', getSelectValue(formObj, 'dir'));\n\tdom.setAttrib(td, 'style', ed.dom.serializeStyle(ed.dom.parseStyle(formObj.style.value)));\n\tdom.setAttrib(td, 'scope', formObj.scope.value);\n\tdom.setAttrib(td, 'class', getSelectValue(formObj, 'class'));\n\n\t// Clear deprecated attributes\n\ted.dom.setAttrib(td, 'width', '');\n\ted.dom.setAttrib(td, 'height', '');\n\ted.dom.setAttrib(td, 'bgColor', '');\n\ted.dom.setAttrib(td, 'borderColor', '');\n\ted.dom.setAttrib(td, 'background', '');\n\n\t// Set styles\n\ttd.style.width = getCSSSize(formObj.width.value);\n\ttd.style.height = getCSSSize(formObj.height.value);\n\tif (formObj.bordercolor.value != \"\") {\n\t\ttd.style.borderColor = formObj.bordercolor.value;\n\t\ttd.style.borderStyle = td.style.borderStyle == \"\" ? \"solid\" : td.style.borderStyle;\n\t\ttd.style.borderWidth = td.style.borderWidth == \"\" ? \"1px\" : td.style.borderWidth;\n\t} else\n\t\ttd.style.borderColor = '';\n\n\ttd.style.backgroundColor = formObj.bgcolor.value;\n\n\tif (formObj.backgroundimage.value != \"\")\n\t\ttd.style.backgroundImage = \"url('\" + formObj.backgroundimage.value + \"')\";\n\telse\n\t\ttd.style.backgroundImage = '';\n\n\tif (curCellType != celltype) {\n\t\t// changing to a different node type\n\t\tvar newCell = doc.createElement(celltype);\n\n\t\tfor (var c=0; c<td.childNodes.length; c++)\n\t\t\tnewCell.appendChild(td.childNodes[c].cloneNode(1));\n\n\t\tfor (var a=0; a<td.attributes.length; a++)\n\t\t\ted.dom.setAttrib(newCell, td.attributes[a].name, ed.dom.getAttrib(td, td.attributes[a].name));\n\n\t\ttd.parentNode.replaceChild(newCell, td);\n\t\ttd = newCell;\n\t}\n\n\tdom.setAttrib(td, 'style', dom.serializeStyle(dom.parseStyle(td.style.cssText)));\n\n\treturn td;\n}\n\nfunction changedBackgroundImage() {\n\tvar formObj = document.forms[0];\n\tvar st = ed.dom.parseStyle(formObj.style.value);\n\n\tst['background-image'] = \"url('\" + formObj.backgroundimage.value + \"')\";\n\n\tformObj.style.value = ed.dom.serializeStyle(st);\n}\n\nfunction changedSize() {\n\tvar formObj = document.forms[0];\n\tvar st = ed.dom.parseStyle(formObj.style.value);\n\n\tvar width = formObj.width.value;\n\tif (width != \"\")\n\t\tst['width'] = getCSSSize(width);\n\telse\n\t\tst['width'] = \"\";\n\n\tvar height = formObj.height.value;\n\tif (height != \"\")\n\t\tst['height'] = getCSSSize(height);\n\telse\n\t\tst['height'] = \"\";\n\n\tformObj.style.value = ed.dom.serializeStyle(st);\n}\n\nfunction changedColor() {\n\tvar formObj = document.forms[0];\n\tvar st = ed.dom.parseStyle(formObj.style.value);\n\n\tst['background-color'] = formObj.bgcolor.value;\n\tst['border-color'] = formObj.bordercolor.value;\n\n\tformObj.style.value = ed.dom.serializeStyle(st);\n}\n\nfunction changedStyle() {\n\tvar formObj = document.forms[0];\n\tvar st = ed.dom.parseStyle(formObj.style.value);\n\n\tif (st['background-image'])\n\t\tformObj.backgroundimage.value = st['background-image'].replace(new RegExp(\"url\\\\('?([^']*)'?\\\\)\", 'gi'), \"$1\");\n\telse\n\t\tformObj.backgroundimage.value = '';\n\n\tif (st['width'])\n\t\tformObj.width.value = trimSize(st['width']);\n\n\tif (st['height'])\n\t\tformObj.height.value = trimSize(st['height']);\n\n\tif (st['background-color']) {\n\t\tformObj.bgcolor.value = st['background-color'];\n\t\tupdateColor('bgcolor_pick','bgcolor');\n\t}\n\n\tif (st['border-color']) {\n\t\tformObj.bordercolor.value = st['border-color'];\n\t\tupdateColor('bordercolor_pick','bordercolor');\n\t}\n}\n\ntinyMCEPopup.onInit.add(init);\n","Magento_Tinymce3/tiny_mce/plugins/table/js/merge_cells.js":"tinyMCEPopup.requireLangPack();\n\nvar MergeCellsDialog = {\n\tinit : function() {\n\t\tvar f = document.forms[0];\n\n\t\tf.numcols.value = tinyMCEPopup.getWindowArg('cols', 1);\n\t\tf.numrows.value = tinyMCEPopup.getWindowArg('rows', 1);\n\t},\n\n\tmerge : function() {\n\t\tvar func, f = document.forms[0];\n\n\t\ttinyMCEPopup.restoreSelection();\n\n\t\tfunc = tinyMCEPopup.getWindowArg('onaction');\n\n\t\tfunc({\n\t\t\tcols : f.numcols.value,\n\t\t\trows : f.numrows.value\n\t\t});\n\n\t\ttinyMCEPopup.close();\n\t}\n};\n\ntinyMCEPopup.onInit.add(MergeCellsDialog.init, MergeCellsDialog);\n","Magento_Tinymce3/tiny_mce/plugins/table/langs/en_dlg.js":"tinyMCE.addI18n('en.table_dlg',{\"rules_border\":\"border\",\"rules_box\":\"box\",\"rules_vsides\":\"vsides\",\"rules_rhs\":\"rhs\",\"rules_lhs\":\"lhs\",\"rules_hsides\":\"hsides\",\"rules_below\":\"below\",\"rules_above\":\"above\",\"rules_void\":\"void\",rules:\"Rules\",\"frame_all\":\"all\",\"frame_cols\":\"cols\",\"frame_rows\":\"rows\",\"frame_groups\":\"groups\",\"frame_none\":\"none\",frame:\"Frame\",caption:\"Table Caption\",\"missing_scope\":\"Are you sure you want to continue without specifying a scope for this table header cell. Without it, it may be difficult for some users with disabilities to understand the content or data displayed of the table.\",\"cell_limit\":\"You\\'ve exceeded the maximum number of cells of {$cells}.\",\"row_limit\":\"You\\'ve exceeded the maximum number of rows of {$rows}.\",\"col_limit\":\"You\\'ve exceeded the maximum number of columns of {$cols}.\",colgroup:\"Col Group\",rowgroup:\"Row Group\",scope:\"Scope\",tfoot:\"Footer\",tbody:\"Body\",thead:\"Header\",\"row_all\":\"Update All Rows in Table\",\"row_even\":\"Update Even Rows in Table\",\"row_odd\":\"Update Odd Rows in Table\",\"row_row\":\"Update Current Row\",\"cell_all\":\"Update All Cells in Table\",\"cell_row\":\"Update All Cells in Row\",\"cell_cell\":\"Update Current Cell\",th:\"Header\",td:\"Data\",summary:\"Summary\",bgimage:\"Background Image\",rtl:\"Right to Left\",ltr:\"Left to Right\",mime:\"Target MIME Type\",langcode:\"Language Code\",langdir:\"Language Direction\",style:\"Style\",id:\"ID\",\"merge_cells_title\":\"Merge Table Cells\",bgcolor:\"Background Color\",bordercolor:\"Border Color\",\"align_bottom\":\"Bottom\",\"align_top\":\"Top\",valign:\"Vertical Alignment\",\"cell_type\":\"Cell Type\",\"cell_title\":\"Table Cell Properties\",\"row_title\":\"Table Row Properties\",\"align_middle\":\"Center\",\"align_right\":\"Right\",\"align_left\":\"Left\",\"align_default\":\"Default\",align:\"Alignment\",border:\"Border\",cellpadding:\"Cell Padding\",cellspacing:\"Cell Spacing\",rows:\"Rows\",cols:\"Columns\",height:\"Height\",width:\"Width\",title:\"Insert/Edit Table\",rowtype:\"Row Type\",\"advanced_props\":\"Advanced Properties\",\"general_props\":\"General Properties\",\"advanced_tab\":\"Advanced\",\"general_tab\":\"General\",\"cell_col\":\"Update all cells in column\"});","Magento_Tinymce3/tiny_mce/plugins/emotions/editor_plugin.js":"(function(a){a.create(\"tinymce.plugins.EmotionsPlugin\",{init:function(b,c){b.addCommand(\"mceEmotion\",function(){b.windowManager.open({file:c+\"/emotions.htm\",width:250+parseInt(b.getLang(\"emotions.delta_width\",0)),height:160+parseInt(b.getLang(\"emotions.delta_height\",0)),inline:1},{plugin_url:c})});b.addButton(\"emotions\",{title:\"emotions.emotions_desc\",cmd:\"mceEmotion\"})},getInfo:function(){return{longname:\"Emotions\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/emotions\",version:a.majorVersion+\".\"+a.minorVersion}}});a.PluginManager.add(\"emotions\",a.plugins.EmotionsPlugin)})(tinymce);","Magento_Tinymce3/tiny_mce/plugins/emotions/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\ttinymce.create('tinymce.plugins.EmotionsPlugin', {\n\t\tinit : function(ed, url) {\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceEmotion', function() {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/emotions.htm',\n\t\t\t\t\twidth : 250 + parseInt(ed.getLang('emotions.delta_width', 0)),\n\t\t\t\t\theight : 160 + parseInt(ed.getLang('emotions.delta_height', 0)),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('emotions', {title : 'emotions.emotions_desc', cmd : 'mceEmotion'});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Emotions',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/emotions',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('emotions', tinymce.plugins.EmotionsPlugin);\n})(tinymce);","Magento_Tinymce3/tiny_mce/plugins/emotions/js/emotions.js":"tinyMCEPopup.requireLangPack();\n\nvar EmotionsDialog = {\n\taddKeyboardNavigation: function(){\n\t\tvar tableElm, cells, settings;\n\t\t\t\n\t\tcells = tinyMCEPopup.dom.select(\"a.emoticon_link\", \"emoticon_table\");\n\t\t\t\n\t\tsettings ={\n\t\t\troot: \"emoticon_table\",\n\t\t\titems: cells\n\t\t};\n\t\tcells[0].tabindex=0;\n\t\ttinyMCEPopup.dom.addClass(cells[0], \"mceFocus\");\n\t\tif (tinymce.isGecko) {\n\t\t\tcells[0].focus();\t\t\n\t\t} else {\n\t\t\tsetTimeout(function(){\n\t\t\t\tcells[0].focus();\n\t\t\t}, 100);\n\t\t}\n\t\ttinyMCEPopup.editor.windowManager.createInstance('tinymce.ui.KeyboardNavigation', settings, tinyMCEPopup.dom);\n\t}, \n\tinit : function(ed) {\n\t\ttinyMCEPopup.resizeToInnerSize();\n\t\tthis.addKeyboardNavigation();\n\t},\n\n\tinsert : function(file, title) {\n\t\tvar ed = tinyMCEPopup.editor, dom = ed.dom;\n\n\t\ttinyMCEPopup.execCommand('mceInsertContent', false, dom.createHTML('img', {\n\t\t\tsrc : tinyMCEPopup.getWindowArg('plugin_url') + '/img/' + file,\n\t\t\talt : ed.getLang(title),\n\t\t\ttitle : ed.getLang(title),\n\t\t\tborder : 0\n\t\t}));\n\n\t\ttinyMCEPopup.close();\n\t}\n};\n\ntinyMCEPopup.onInit.add(EmotionsDialog.init, EmotionsDialog);\n","Magento_Tinymce3/tiny_mce/plugins/emotions/langs/en_dlg.js":"tinyMCE.addI18n('en.emotions_dlg',{cry:\"Cry\",cool:\"Cool\",desc:\"Emotions\",title:\"Insert Emotion\",usage:\"Use left and right arrows to navigate.\",yell:\"Yell\",wink:\"Wink\",undecided:\"Undecided\",\"tongue_out\":\"Tongue Out\",surprised:\"Surprised\",smile:\"Smile\",sealed:\"Sealed\",\"money_mouth\":\"Money Mouth\",laughing:\"Laughing\",kiss:\"Kiss\",innocent:\"Innocent\",frown:\"Frown\",\"foot_in_mouth\":\"Foot in Mouth\",embarassed:\"Embarassed\"});\n","Magento_Tinymce3/tiny_mce/plugins/iespell/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.IESpell\",{init:function(a,b){var c=this,d;if(!tinymce.isIE){return}c.editor=a;a.addCommand(\"mceIESpell\",function(){try{d=new ActiveXObject(\"ieSpell.ieSpellExtension\");d.CheckDocumentNode(a.getDoc().documentElement)}catch(f){if(f.number==-2146827859){a.windowManager.confirm(a.getLang(\"iespell.download\"),function(e){if(e){window.open(\"http://www.iespell.com/download.php\",\"ieSpellDownload\",\"\")}})}else{a.windowManager.alert(\"Error Loading ieSpell: Exception \"+f.number)}}});a.addButton(\"iespell\",{title:\"iespell.iespell_desc\",cmd:\"mceIESpell\"})},getInfo:function(){return{longname:\"IESpell (IE Only)\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/iespell\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"iespell\",tinymce.plugins.IESpell)})();","Magento_Tinymce3/tiny_mce/plugins/iespell/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.IESpell', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this, sp;\n\n\t\t\tif (!tinymce.isIE)\n\t\t\t\treturn;\n\n\t\t\tt.editor = ed;\n\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceIESpell', function() {\n\t\t\t\ttry {\n\t\t\t\t\tsp = new ActiveXObject(\"ieSpell.ieSpellExtension\");\n\t\t\t\t\tsp.CheckDocumentNode(ed.getDoc().documentElement);\n\t\t\t\t} catch (e) {\n\t\t\t\t\tif (e.number == -2146827859) {\n\t\t\t\t\t\ted.windowManager.confirm(ed.getLang(\"iespell.download\"), function(s) {\n\t\t\t\t\t\t\tif (s)\n\t\t\t\t\t\t\t\twindow.open('http://www.iespell.com/download.php', 'ieSpellDownload', '');\n\t\t\t\t\t\t});\n\t\t\t\t\t} else\n\t\t\t\t\t\ted.windowManager.alert(\"Error Loading ieSpell: Exception \" + e.number);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('iespell', {title : 'iespell.iespell_desc', cmd : 'mceIESpell'});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'IESpell (IE Only)',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/iespell',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('iespell', tinymce.plugins.IESpell);\n})();","Magento_Tinymce3/tiny_mce/plugins/preview/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.Preview\",{init:function(a,b){var d=this,c=tinymce.explode(a.settings.content_css);d.editor=a;tinymce.each(c,function(f,e){c[e]=a.documentBaseURI.toAbsolute(f)});a.addCommand(\"mcePreview\",function(){a.windowManager.open({file:a.getParam(\"plugin_preview_pageurl\",b+\"/preview.html\"),width:parseInt(a.getParam(\"plugin_preview_width\",\"550\")),height:parseInt(a.getParam(\"plugin_preview_height\",\"600\")),resizable:\"yes\",scrollbars:\"yes\",popup_css:c?c.join(\",\"):a.baseURI.toAbsolute(\"themes/\"+a.settings.theme+\"/skins/\"+a.settings.skin+\"/content.css\"),inline:a.getParam(\"plugin_preview_inline\",1)},{base:a.documentBaseURI.getURI()})});a.addButton(\"preview\",{title:\"preview.preview_desc\",cmd:\"mcePreview\"})},getInfo:function(){return{longname:\"Preview\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/preview\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"preview\",tinymce.plugins.Preview)})();","Magento_Tinymce3/tiny_mce/plugins/preview/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.Preview', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this, css = tinymce.explode(ed.settings.content_css);\n\n\t\t\tt.editor = ed;\n\n\t\t\t// Force absolute CSS urls\t\n\t\t\ttinymce.each(css, function(u, k) {\n\t\t\t\tcss[k] = ed.documentBaseURI.toAbsolute(u);\n\t\t\t});\n\n\t\t\ted.addCommand('mcePreview', function() {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : ed.getParam(\"plugin_preview_pageurl\", url + \"/preview.html\"),\n\t\t\t\t\twidth : parseInt(ed.getParam(\"plugin_preview_width\", \"550\")),\n\t\t\t\t\theight : parseInt(ed.getParam(\"plugin_preview_height\", \"600\")),\n\t\t\t\t\tresizable : \"yes\",\n\t\t\t\t\tscrollbars : \"yes\",\n\t\t\t\t\tpopup_css : css ? css.join(',') : ed.baseURI.toAbsolute(\"themes/\" + ed.settings.theme + \"/skins/\" + ed.settings.skin + \"/content.css\"),\n\t\t\t\t\tinline : ed.getParam(\"plugin_preview_inline\", 1)\n\t\t\t\t}, {\n\t\t\t\t\tbase : ed.documentBaseURI.getURI()\n\t\t\t\t});\n\t\t\t});\n\n\t\t\ted.addButton('preview', {title : 'preview.preview_desc', cmd : 'mcePreview'});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Preview',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/preview',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('preview', tinymce.plugins.Preview);\n})();","Magento_Tinymce3/tiny_mce/plugins/preview/jscripts/embed.js":"/**\n * This script contains embed functions for common plugins. This scripts are complety free to use for any purpose.\n */\n\nfunction writeFlash(p) {\n\twriteEmbed(\n\t\t'D27CDB6E-AE6D-11cf-96B8-444553540000',\n\t\t'http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0',\n\t\t'application/x-shockwave-flash',\n\t\tp\n\t);\n}\n\nfunction writeShockWave(p) {\n\twriteEmbed(\n\t'166B1BCA-3F9C-11CF-8075-444553540000',\n\t'http://download.macromedia.com/pub/shockwave/cabs/director/sw.cab#version=8,5,1,0',\n\t'application/x-director',\n\t\tp\n\t);\n}\n\nfunction writeQuickTime(p) {\n\twriteEmbed(\n\t\t'02BF25D5-8C17-4B23-BC80-D3488ABDDC6B',\n\t\t'http://www.apple.com/qtactivex/qtplugin.cab#version=6,0,2,0',\n\t\t'video/quicktime',\n\t\tp\n\t);\n}\n\nfunction writeRealMedia(p) {\n\twriteEmbed(\n\t\t'CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA',\n\t\t'http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0',\n\t\t'audio/x-pn-realaudio-plugin',\n\t\tp\n\t);\n}\n\nfunction writeWindowsMedia(p) {\n\tp.url = p.src;\n\twriteEmbed(\n\t\t'6BF52A52-394A-11D3-B153-00C04F79FAA6',\n\t\t'http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=5,1,52,701',\n\t\t'application/x-mplayer2',\n\t\tp\n\t);\n}\n\nfunction writeEmbed(cls, cb, mt, p) {\n\tvar h = '', n;\n\n\th += '<object classid=\"clsid:' + cls + '\" codebase=\"' + cb + '\"';\n\th += typeof(p.id) != \"undefined\" ? 'id=\"' + p.id + '\"' : '';\n\th += typeof(p.name) != \"undefined\" ? 'name=\"' + p.name + '\"' : '';\n\th += typeof(p.width) != \"undefined\" ? 'width=\"' + p.width + '\"' : '';\n\th += typeof(p.height) != \"undefined\" ? 'height=\"' + p.height + '\"' : '';\n\th += typeof(p.align) != \"undefined\" ? 'align=\"' + p.align + '\"' : '';\n\th += '>';\n\n\tfor (n in p)\n\t\th += '<param name=\"' + n + '\" value=\"' + p[n] + '\">';\n\n\th += '<embed type=\"' + mt + '\"';\n\n\tfor (n in p)\n\t\th += n + '=\"' + p[n] + '\" ';\n\n\th += '></embed></object>';\n\n\tdocument.write(h);\n}\n","Magento_Tinymce3/tiny_mce/plugins/paste/editor_plugin.js":"(function(){var c=tinymce.each,a={paste_auto_cleanup_on_paste:true,paste_e