require.config({"config": {
        "jsbuild":{"Magento_Ui/js/form/element/image-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Base64 */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/lib/validation/validator',\n    'Magento_Ui/js/form/element/file-uploader',\n    'mage/adminhtml/browser'\n], function ($, _, utils, uiAlert, validator, Element, browser) {\n    'use strict';\n\n    return Element.extend({\n        /**\n         * {@inheritDoc}\n         */\n        initialize: function () {\n            this._super();\n\n            // Listen for file deletions from the media browser\n            $(window).on('fileDeleted.mediabrowser', this.onDeleteFile.bind(this));\n        },\n\n        /**\n         * Assign uid for media gallery\n         *\n         * @return {ImageUploader} Chainable.\n         */\n        initConfig: function () {\n            var mediaGalleryUid = utils.uniqueid();\n\n            this._super();\n\n            _.extend(this, {\n                mediaGalleryUid: mediaGalleryUid\n            });\n\n            return this;\n        },\n\n        /**\n         * Add file event callback triggered from media gallery\n         *\n         * @param {ImageUploader} imageUploader - UI Class\n         * @param {Event} e\n         */\n        addFileFromMediaGallery: function (imageUploader, e) {\n            var $buttonEl = $(e.target),\n                fileSize = $buttonEl.data('size'),\n                fileMimeType = $buttonEl.data('mime-type'),\n                filePathname = $buttonEl.val(),\n                fileBasename = filePathname.split('/').pop();\n\n            this.addFile({\n                type: fileMimeType,\n                name: fileBasename,\n                size: fileSize,\n                url: filePathname\n            });\n        },\n\n        /**\n         * Open the media browser dialog\n         *\n         * @param {ImageUploader} imageUploader - UI Class\n         * @param {Event} e\n         */\n        openMediaBrowserDialog: function (imageUploader, e) {\n            var $buttonEl = $(e.target),\n                openDialogUrl = this.mediaGallery.openDialogUrl +\n                'target_element_id/' + $buttonEl.attr('id') +\n                '/store/' + this.mediaGallery.storeId +\n                '/type/image/?isAjax=true';\n\n            if (this.mediaGallery.initialOpenSubpath) {\n                openDialogUrl += '&current_tree_path=' + Base64.mageEncode(this.mediaGallery.initialOpenSubpath);\n            }\n\n            browser.openDialog(openDialogUrl, null, null, this.mediaGallery.openDialogTitle);\n        },\n\n        /**\n         * @param {jQuery.event} e\n         * @param {Object} data\n         * @returns {Object} Chainables\n         */\n        onDeleteFile: function (e, data) {\n            var fileId = this.getFileId(),\n                deletedFileIds = data.ids;\n\n            if (fileId && $.inArray(fileId, deletedFileIds) > -1) {\n                this.clear();\n            }\n\n            return this;\n        },\n\n        /**\n         * {@inheritDoc}\n         */\n        clear: function () {\n            this.value([]);\n\n            return this;\n        },\n\n        /**\n         * Gets the ID of the file used if set\n         *\n         * @return {String|Null} ID\n         */\n        getFileId: function () {\n            return this.hasData() ? this.value()[0].id : null;\n        },\n\n        /**\n         * Trigger native browser file upload UI via clicking on 'Upload' button\n         *\n         * @param {ImageUploader} imageUploader - UI Class\n         * @param {Event} e\n         */\n        triggerImageUpload: function (imageUploader, e) {\n            $(e.target).closest('.file-uploader').find('input[type=\"file\"]').click();\n        },\n\n        /**\n         * Get list of file extensions allowed in comma delimited format\n         *\n         * @return {String}\n         */\n        getAllowedFileExtensionsInCommaDelimitedFormat: function () {\n            var allowedExtensions = this.allowedExtensions.toUpperCase().split(' ');\n\n            // if jpg and jpeg in allowed extensions, remove jpeg from list\n            if (allowedExtensions.indexOf('JPG') !== -1 && allowedExtensions.indexOf('JPEG') !== -1) {\n                allowedExtensions.splice(allowedExtensions.indexOf('JPEG'), 1);\n            }\n\n            return allowedExtensions.join(', ');\n        }\n    });\n});\n","Magento_Ui/js/form/element/single-checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'underscore',\n    'mage/translate'\n], function (AbstractField, _, $t) {\n    'use strict';\n\n    return AbstractField.extend({\n        defaults: {\n            template: 'ui/form/components/single/field',\n            checked: false,\n            initialChecked: false,\n            multiple: false,\n            prefer: 'checkbox', // 'radio' | 'checkbox' | 'toggle'\n            valueMap: {},\n\n            templates: {\n                radio: 'ui/form/components/single/radio',\n                checkbox: 'ui/form/components/single/checkbox',\n                toggle: 'ui/form/components/single/switcher'\n            },\n\n            listens: {\n                'checked': 'onCheckedChanged',\n                'value': 'onExtendedValueChanged'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initConfig: function (config) {\n            this._super();\n\n            if (!config.elementTmpl) {\n                if (!this.prefer && !this.multiple) {\n                    this.elementTmpl = this.templates.radio;\n                } else if (this.prefer === 'radio') {\n                    this.elementTmpl = this.templates.radio;\n                } else if (this.prefer === 'checkbox') {\n                    this.elementTmpl = this.templates.checkbox;\n                } else if (this.prefer === 'toggle') {\n                    this.elementTmpl = this.templates.toggle;\n                } else {\n                    this.elementTmpl = this.templates.checkbox;\n                }\n            }\n\n            if (this.prefer === 'toggle' && _.isEmpty(this.toggleLabels)) {\n                this.toggleLabels = {\n                    'on': $t('Yes'),\n                    'off': $t('No')\n                };\n            }\n\n            if (typeof this.default === 'undefined' || this.default === null) {\n                this.default = '';\n            }\n\n            if (typeof this.value === 'undefined' || this.value === null) {\n                this.value = _.isEmpty(this.valueMap) || this.default !== '' ? this.default : this.valueMap.false;\n                this.initialValue = this.value;\n            } else {\n                this.initialValue = this.value;\n            }\n\n            if (this.multiple && !_.isArray(this.value)) {\n                this.value = []; // needed for correct observable assignment\n            }\n\n            this.initialChecked = this.checked;\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe('checked');\n        },\n\n        /**\n         * Get true/false key from valueMap by value.\n         *\n         * @param {*} value\n         * @returns {Boolean|undefined}\n         */\n        getReverseValueMap: function getReverseValueMap(value) {\n            var bool = false;\n\n            _.some(this.valueMap, function (iValue, iBool) {\n                if (iValue === value) {\n                    bool = iBool === 'true';\n\n                    return true;\n                }\n            });\n\n            return bool;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        setInitialValue: function () {\n            if (_.isEmpty(this.valueMap)) {\n                this.on('value', this.onUpdate.bind(this));\n            } else {\n                this._super();\n                this.checked(this.getReverseValueMap(this.value()));\n            }\n\n            return this;\n        },\n\n        /**\n         * Handle dataScope changes for checkbox / radio button.\n         *\n         * @param {*} newExportedValue\n         */\n        onExtendedValueChanged: function (newExportedValue) {\n            var isMappedUsed = !_.isEmpty(this.valueMap),\n                oldChecked = this.checked.peek(),\n                oldValue = this.initialValue,\n                newChecked;\n\n            if (this.multiple) {\n                newChecked = newExportedValue.indexOf(oldValue) !== -1;\n            } else if (isMappedUsed) {\n                newChecked = this.getReverseValueMap(newExportedValue);\n            } else if (typeof newExportedValue === 'boolean') {\n                newChecked = newExportedValue;\n            } else {\n                newChecked = newExportedValue === oldValue;\n            }\n\n            if (newChecked !== oldChecked) {\n                this.checked(newChecked);\n            }\n        },\n\n        /**\n         * Handle checked state changes for checkbox / radio button.\n         *\n         * @param {Boolean} newChecked\n         */\n        onCheckedChanged: function (newChecked) {\n            var isMappedUsed = !_.isEmpty(this.valueMap),\n                oldValue = this.initialValue,\n                newValue;\n\n            if (isMappedUsed) {\n                newValue = this.valueMap[newChecked];\n            } else {\n                newValue = oldValue;\n            }\n\n            if (!this.multiple && newChecked) {\n                this.value(newValue);\n            } else if (!this.multiple && !newChecked) {\n                if (typeof newValue === 'boolean') {\n                    this.value(newChecked);\n                } else if (newValue === this.value.peek()) {\n                    this.value('');\n                }\n\n                if (isMappedUsed) {\n                    this.value(newValue);\n                }\n            } else if (this.multiple && newChecked && this.value.indexOf(newValue) === -1) {\n                this.value.push(newValue);\n            } else if (this.multiple && !newChecked && this.value.indexOf(newValue) !== -1) {\n                this.value.splice(this.value.indexOf(newValue), 1);\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onUpdate: function () {\n            if (this.hasUnique) {\n                this.setUnique();\n            }\n\n            return this._super();\n        },\n\n        /**\n         * @inheritdoc\n         */\n        reset: function () {\n            if (this.multiple && this.initialChecked) {\n                this.value.push(this.initialValue);\n            } else if (this.multiple && !this.initialChecked) {\n                this.value.splice(this.value.indexOf(this.initialValue), 1);\n            } else {\n                this.value(this.initialValue);\n            }\n\n            this.error(false);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        clear: function () {\n            if (this.multiple) {\n                this.value([]);\n            } else {\n                this.value('');\n            }\n\n            this.error(false);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/region.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    './select',\n    'Magento_Checkout/js/model/default-post-code-resolver'\n], function (_, registry, Select, defaultPostCodeResolver) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            skipValidation: false,\n            imports: {\n                update: '${ $.parentName }.country_id:value'\n            }\n        },\n\n        /**\n         * @param {String} value\n         */\n        update: function (value) {\n            var country = registry.get(this.parentName + '.' + 'country_id'),\n                options = country.indexedOptions,\n                isRegionRequired,\n                option;\n\n            if (!value) {\n                return;\n            }\n            option = options[value];\n\n            if (typeof option === 'undefined') {\n                return;\n            }\n\n            defaultPostCodeResolver.setUseDefaultPostCode(!option['is_zipcode_optional']);\n\n            if (this.skipValidation) {\n                this.validation['required-entry'] = false;\n                this.required(false);\n            } else {\n                if (option && !option['is_region_required']) {\n                    this.error(false);\n                    this.validation = _.omit(this.validation, 'required-entry');\n                    registry.get(this.customName, function (input) {\n                        input.validation['required-entry'] = false;\n                        input.required(false);\n                    });\n                } else {\n                    this.validation['required-entry'] = true;\n                }\n\n                if (option && !this.options().length) {\n                    registry.get(this.customName, function (input) {\n                        isRegionRequired = !!option['is_region_required'];\n                        input.validation['required-entry'] = isRegionRequired;\n                        input.validation['validate-not-number-first'] = true;\n                        input.required(isRegionRequired);\n                    });\n                }\n\n                this.required(!!option['is_region_required']);\n            }\n        },\n\n        /**\n         * Filters 'initialOptions' property by 'field' and 'value' passed,\n         * calls 'setOptions' passing the result to it\n         *\n         * @param {*} value\n         * @param {String} field\n         */\n        filter: function (value, field) {\n            var superFn = this._super;\n\n            registry.get(this.parentName + '.' + 'country_id', function (country) {\n                var option = country.indexedOptions[value];\n\n                superFn.call(this, value, field);\n\n                if (option && option['is_region_visible'] === false) {\n                    // hide select and corresponding text input field if region must not be shown for selected country\n                    this.setVisible(false);\n\n                    if (this.customEntry) {// eslint-disable-line max-depth\n                        this.toggleInput(false);\n                    }\n                }\n            }.bind(this));\n        }\n    });\n});\n\n","Magento_Ui/js/form/element/boolean.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    './abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            checked: false,\n            links: {\n                checked: 'value'\n            }\n        },\n\n        /**\n         * @returns {*|void|Element}\n         */\n        initObservable: function () {\n            return this._super()\n                    .observe('checked');\n        },\n\n        /**\n         * Converts provided value to boolean.\n         *\n         * @returns {Boolean}\n         */\n        normalizeData: function () {\n            return !!+this._super();\n        },\n\n        /**\n         * Calls 'onUpdate' method of parent, if value is defined and instance's\n         *     'unique' property set to true, calls 'setUnique' method\n         *\n         * @return {Object} - reference to instance\n         */\n        onUpdate: function () {\n            if (this.hasUnique) {\n                this.setUnique();\n            }\n\n            return this._super();\n        }\n    });\n});\n","Magento_Ui/js/form/element/color-picker.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_Ui/js/form/element/color-picker-palette'\n], function ($t, Abstract, palette) {\n    'use strict';\n\n    return Abstract.extend({\n\n        defaults: {\n            colorPickerConfig: {\n                chooseText: $t('Apply'),\n                cancelText: $t('Cancel'),\n                maxSelectionSize: 8,\n                clickoutFiresChange: true,\n                allowEmpty: true,\n                localStorageKey: 'magento.spectrum',\n                palette: palette\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super();\n\n            this.colorPickerConfig.value = this.value;\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/textarea.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    './abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            cols: 15,\n            rows: 2,\n            elementTmpl: 'ui/form/element/textarea'\n        }\n    });\n});\n","Magento_Ui/js/form/element/url-input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiLayout',\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, layout, $t, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            linkedElement: {},\n            settingTemplate: 'ui/form/element/urlInput/setting',\n            typeSelectorTemplate: 'ui/form/element/urlInput/typeSelector',\n            options: [],\n            linkedElementInstances: {},\n            //checkbox\n            isDisplayAdditionalSettings: true,\n            settingValue: false,\n            settingLabel: $t('Open in new tab'),\n            tracks: {\n                linkedElement: true\n            },\n            baseLinkSetting: {\n                namePrefix: '${$.name}.',\n                dataScopePrefix: '${$.dataScope}.',\n                provider: '${$.provider}'\n            },\n            urlTypes: {},\n            listens: {\n                settingValue: 'checked',\n                disabled: 'hideLinkedElement',\n                linkType: 'createChildUrlInputComponent'\n            },\n            links: {\n                linkType: '${$.provider}:${$.dataScope}.type',\n                settingValue: '${$.provider}:${$.dataScope}.setting'\n            }\n        },\n\n        /** @inheritdoc */\n        initConfig: function (config) {\n            var processedLinkTypes = {},\n                baseLinkType = this.constructor.defaults.baseLinkSetting;\n\n            _.each(config.urlTypes, function (linkSettingsArray, linkName) {\n                //add link name by link type\n                linkSettingsArray.name = baseLinkType.namePrefix + linkName;\n                linkSettingsArray.dataScope = baseLinkType.dataScopePrefix + linkName;\n                linkSettingsArray.type = linkName;\n                linkSettingsArray.disabled = config.disabled;\n                linkSettingsArray.visible = config.visible;\n                processedLinkTypes[linkName] = {};\n                _.extend(processedLinkTypes[linkName], baseLinkType, linkSettingsArray);\n            });\n            _.extend(this.constructor.defaults.urlTypes, processedLinkTypes);\n\n            this._super();\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('componentTemplate options value linkType settingValue checked isDisplayAdditionalSettings')\n                .setOptions();\n\n            return this;\n        },\n\n        /**\n         * Set options to select based on link types configuration\n         *\n         * @return {Object}\n         */\n        setOptions: function () {\n            var result = [];\n\n            _.each(this.urlTypes, function (option, key) {\n                result.push({\n                    value: key,\n                    label: option.label,\n                    sortOrder: option.sortOrder || 0\n                });\n            });\n\n            //sort options by sortOrder\n            result.sort(function (a, b) {\n                return a.sortOrder > b.sortOrder ? 1 : -1;\n            });\n\n            this.options(result);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        setPreview: function (visible) {\n            this.linkedElement().visible(visible);\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @param {Boolean} disabled\n         */\n        hideLinkedElement: function (disabled) {\n            this.linkedElement().disabled(disabled);\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            _.each(this.linkedElementInstances, function (value) {\n                value().destroy();\n            });\n            this._super();\n        },\n\n        /**\n         * Create child component by value\n         *\n         * @param {String} value\n         * @return void\n         */\n        createChildUrlInputComponent: function (value) {\n            var elementConfig;\n\n            if (!_.isEmpty(value) && _.isUndefined(this.linkedElementInstances[value])) {\n                elementConfig = this.urlTypes[value];\n                layout([elementConfig]);\n                this.linkedElementInstances[value] = this.requestModule(elementConfig.name);\n            }\n            this.linkedElement = this.linkedElementInstances[value];\n\n        },\n\n        /**\n         * Returns linked element to display related field in template\n         * @return String\n         */\n        getLinkedElementName: function () {\n            return this.linkedElement;\n        },\n\n        /**\n         * Add ability to choose check box by clicking on label\n         */\n        checkboxClick: function () {\n            if (!this.disabled()) {\n                this.settingValue(!this.settingValue());\n            }\n        }\n    });\n});\n","Magento_Ui/js/form/element/checkbox-set.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    './abstract'\n], function (_, utils, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            template: 'ui/form/element/checkbox-set',\n            multiple: false,\n            multipleScopeValue: null\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initConfig: function () {\n            this._super();\n\n            this.value = this.normalizeData(this.value);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initLinks: function () {\n            var scope = this.source.get(this.dataScope);\n\n            this.multipleScopeValue = this.multiple && _.isArray(scope) ? utils.copy(scope) : undefined;\n\n            return this._super();\n        },\n\n        /**\n         * @inheritdoc\n         */\n        reset: function () {\n            this.value(utils.copy(this.initialValue));\n            this.error(false);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        clear: function () {\n            var value = this.multiple ? [] : '';\n\n            this.value(value);\n            this.error(false);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        normalizeData: function (value) {\n            if (!this.multiple) {\n                return this._super();\n            }\n\n            return _.isArray(value) ? utils.copy(value) : [];\n        },\n\n        /**\n         * @inheritdoc\n         */\n        setInitialValue: function () {\n            this._super();\n\n            this.initialValue = utils.copy(this.initialValue);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        getInitialValue: function () {\n            var values = [this.multipleScopeValue, this.default, this.value.peek(), []],\n                value;\n\n            if (!this.multiple) {\n                return this._super();\n            }\n\n            values.some(function (v) {\n                return _.isArray(v) && (value = utils.copy(v));\n            });\n\n            return value;\n        },\n\n        /**\n         * Returns labels which matches current value.\n         *\n         * @returns {String|Array}\n         */\n        getPreview: function () {\n            var option;\n\n            if (!this.multiple) {\n                option = this.getOption(this.value());\n\n                return option ? option.label : '';\n            }\n\n            return this.value.map(function (value) {\n                return this.getOption(value).label;\n            }, this);\n        },\n\n        /**\n         * Returns option object associated with provided value.\n         *\n         * @param {String} value\n         * @returns {Object}\n         */\n        getOption: function (value) {\n            return _.findWhere(this.options, {\n                value: value\n            });\n        },\n\n        /**\n         * @inheritdoc\n         */\n        hasChanged: function () {\n            var value = this.value(),\n                initial = this.initialValue;\n\n            return this.multiple ?\n                !utils.equalArrays(value, initial) :\n                this._super();\n        }\n    });\n});\n","Magento_Ui/js/form/element/abstract.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'uiElement',\n    'Magento_Ui/js/lib/validation/validator'\n], function (_, utils, layout, Element, validator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            visible: true,\n            preview: '',\n            focused: false,\n            required: false,\n            disabled: false,\n            valueChangedByUser: false,\n            elementTmpl: 'ui/form/element/input',\n            tooltipTpl: 'ui/form/element/helper/tooltip',\n            fallbackResetTpl: 'ui/form/element/helper/fallback-reset',\n            'input_type': 'input',\n            placeholder: false,\n            description: '',\n            labelVisible: true,\n            label: '',\n            error: '',\n            warn: '',\n            notice: '',\n            customScope: '',\n            default: '',\n            isDifferedFromDefault: false,\n            showFallbackReset: false,\n            additionalClasses: {},\n            isUseDefault: '',\n            serviceDisabled: false,\n            valueUpdate: false, // ko binding valueUpdate\n\n            switcherConfig: {\n                component: 'Magento_Ui/js/form/switcher',\n                name: '${ $.name }_switcher',\n                target: '${ $.name }',\n                property: 'value'\n            },\n            listens: {\n                visible: 'setPreview',\n                value: 'setDifferedFromDefault',\n                '${ $.provider }:data.reset': 'reset',\n                '${ $.provider }:data.overload': 'overload',\n                '${ $.provider }:${ $.customScope ? $.customScope + \".\" : \"\"}data.validate': 'validate',\n                'isUseDefault': 'toggleUseDefault'\n            },\n            ignoreTmpls: {\n                value: true\n            },\n\n            links: {\n                value: '${ $.provider }:${ $.dataScope }'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            _.bindAll(this, 'reset');\n\n            this._super()\n                .setInitialValue()\n                ._setClasses()\n                .initSwitcher();\n\n            return this;\n        },\n\n        /**\n         * Checks if component has error.\n         *\n         * @returns {Object}\n         */\n        checkInvalid: function () {\n            return this.error() && this.error().length ? this : null;\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initObservable: function () {\n            var rules = this.validation = this.validation || {};\n\n            this._super();\n\n            this.observe('error disabled focused preview visible value warn notice isDifferedFromDefault')\n                .observe('isUseDefault serviceDisabled')\n                .observe({\n                    'required': !!rules['required-entry']\n                });\n\n            return this;\n        },\n\n        /**\n         * Initializes regular properties of instance.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initConfig: function () {\n            var uid = utils.uniqueid(),\n                name,\n                valueUpdate,\n                scope;\n\n            this._super();\n\n            scope = this.dataScope.split('.');\n            name = scope.length > 1 ? scope.slice(1) : scope;\n\n            valueUpdate = this.showFallbackReset ? 'afterkeydown' : this.valueUpdate;\n\n            _.extend(this, {\n                uid: uid,\n                noticeId: 'notice-' + uid,\n                errorId: 'error-' + uid,\n                inputName: utils.serializeName(name.join('.')),\n                valueUpdate: valueUpdate\n            });\n\n            return this;\n        },\n\n        /**\n         * Initializes switcher element instance.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initSwitcher: function () {\n            if (this.switcherConfig.enabled) {\n                layout([this.switcherConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets initial value of the element and subscribes to it's changes.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        setInitialValue: function () {\n            this.initialValue = this.getInitialValue();\n\n            if (this.value.peek() !== this.initialValue) {\n                this.value(this.initialValue);\n            }\n\n            this.on('value', this.onUpdate.bind(this));\n            this.isUseDefault(this.disabled());\n\n            return this;\n        },\n\n        /**\n         * Extends 'additionalClasses' object.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        _setClasses: function () {\n            var additional = this.additionalClasses;\n\n            if (_.isString(additional)) {\n                this.additionalClasses = {};\n\n                if (additional.trim().length) {\n                    additional = additional.trim().split(' ');\n\n                    additional.forEach(function (name) {\n                        if (name.length) {\n                            this.additionalClasses[name] = true;\n                        }\n                    }, this);\n                }\n            }\n\n            _.extend(this.additionalClasses, {\n                _required: this.required,\n                _error: this.error,\n                _warn: this.warn,\n                _disabled: this.disabled\n            });\n\n            return this;\n        },\n\n        /**\n         * Gets initial value of element\n         *\n         * @returns {*} Elements' value.\n         */\n        getInitialValue: function () {\n            var values = [this.value(), this.default],\n                value;\n\n            values.some(function (v) {\n                if (v !== null && v !== undefined) {\n                    value = v;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return this.normalizeData(value);\n        },\n\n        /**\n         * Sets 'value' as 'hidden' property's value, triggers 'toggle' event,\n         * sets instance's hidden identifier in params storage based on\n         * 'value'.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        setVisible: function (isVisible) {\n            this.visible(isVisible);\n\n            return this;\n        },\n\n        /**\n         * Show element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        show: function () {\n            this.visible(true);\n\n            return this;\n        },\n\n        /**\n         * Hide element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        hide: function () {\n            this.visible(false);\n\n            return this;\n        },\n\n        /**\n         * Disable element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        disable: function () {\n            this.disabled(true);\n\n            return this;\n        },\n\n        /**\n         * Enable element.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        enable: function () {\n            this.disabled(false);\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {(String|Object)} rule\n         * @param {(Object|Boolean)} [options]\n         * @returns {Abstract} Chainable.\n         */\n        setValidation: function (rule, options) {\n            var rules = utils.copy(this.validation),\n                changed;\n\n            if (_.isObject(rule)) {\n                _.extend(this.validation, rule);\n            } else {\n                this.validation[rule] = options;\n            }\n\n            changed = !utils.compare(rules, this.validation).equal;\n\n            if (changed) {\n                this.required(!!rules['required-entry']);\n                this.validate();\n            }\n\n            return this;\n        },\n\n        /**\n         * Returns unwrapped preview observable.\n         *\n         * @returns {String} Value of the preview observable.\n         */\n        getPreview: function () {\n            return this.value();\n        },\n\n        /**\n         * Checks if element has addons\n         *\n         * @returns {Boolean}\n         */\n        hasAddons: function () {\n            return this.addbefore || this.addafter;\n        },\n\n        /**\n         * Checks if element has service setting\n         *\n         * @returns {Boolean}\n         */\n        hasService: function () {\n            return this.service && this.service.template;\n        },\n\n        /**\n         * Defines if value has changed.\n         *\n         * @returns {Boolean}\n         */\n        hasChanged: function () {\n            var notEqual = this.value() !== this.initialValue;\n\n            return !this.visible() ? false : notEqual;\n        },\n\n        /**\n         * Checks if 'value' is not empty.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return !utils.isEmpty(this.value());\n        },\n\n        /**\n         * Sets value observable to initialValue property.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        reset: function () {\n            this.value(this.initialValue);\n            this.error(false);\n\n            return this;\n        },\n\n        /**\n         * Sets current state as initial.\n         */\n        overload: function () {\n            this.setInitialValue();\n            this.bubble('update', this.hasChanged());\n        },\n\n        /**\n         * Clears 'value' property.\n         *\n         * @returns {Abstract} Chainable.\n         */\n        clear: function () {\n            this.value('');\n\n            return this;\n        },\n\n        /**\n         * Converts values like 'null' or 'undefined' to an empty string.\n         *\n         * @param {*} value - Value to be processed.\n         * @returns {*}\n         */\n        normalizeData: function (value) {\n            return utils.isEmpty(value) ? '' : value;\n        },\n\n        /**\n         * Validates itself by it's validation rules using validator object.\n         * If validation of a rule did not pass, writes it's message to\n         * 'error' observable property.\n         *\n         * @returns {Object} Validate information.\n         */\n        validate: function () {\n            var value = this.value(),\n                result = validator(this.validation, value, this.validationParams),\n                message = !this.disabled() && this.visible() ? result.message : '',\n                isValid = this.disabled() || !this.visible() || result.passed;\n\n            this.error(message);\n            this.error.valueHasMutated();\n            this.bubble('error', message);\n\n            //TODO: Implement proper result propagation for form\n            if (this.source && !isValid) {\n                this.source.set('params.invalid', true);\n            }\n\n            return {\n                valid: isValid,\n                target: this\n            };\n        },\n\n        /**\n         * Callback that fires when 'value' property is updated.\n         */\n        onUpdate: function () {\n            this.bubble('update', this.hasChanged());\n\n            this.validate();\n        },\n\n        /**\n         * Restore value to default\n         */\n        restoreToDefault: function () {\n            this.value(this.default);\n            this.focused(true);\n        },\n\n        /**\n         * Update whether value differs from default value\n         */\n        setDifferedFromDefault: function () {\n            var value = typeof this.value() != 'undefined' && this.value() !== null ? this.value() : '',\n                defaultValue = typeof this.default != 'undefined' && this.default !== null ? this.default : '';\n\n            this.isDifferedFromDefault(value !== defaultValue);\n        },\n\n        /**\n         * @param {Boolean} state\n         */\n        toggleUseDefault: function (state) {\n            this.disabled(state);\n\n            if (this.source && this.hasService()) {\n                this.source.set('data.use_default.' + this.index, Number(state));\n            }\n        },\n\n        /**\n         *  Callback when value is changed by user\n         */\n        userChanges: function () {\n            this.valueChangedByUser = true;\n        },\n\n        /**\n         * Returns correct id for 'aria-describedby' accessibility attribute\n         *\n         * @returns {Boolean|String}\n         */\n        getDescriptionId: function () {\n            var id = false;\n\n            if (this.error()) {\n                id = this.errorId;\n            } else if (this.notice()) {\n                id = this.noticeId;\n            }\n\n            return id;\n        }\n    });\n});\n","Magento_Ui/js/form/element/text.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiElement',\n    'mageUtils'\n], function (Element, utils) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            visible: true,\n            label: '',\n            error: '',\n            uid: utils.uniqueid(),\n            disabled: false,\n            links: {\n                value: '${ $.provider }:${ $.dataScope }'\n            }\n        },\n\n        /**\n         * Has service\n         *\n         * @returns {Boolean} false.\n         */\n        hasService: function () {\n            return false;\n        },\n\n        /**\n         * Has addons\n         *\n         * @returns {Boolean} false.\n         */\n        hasAddons: function () {\n            return false;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('disabled visible value');\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/color-picker-palette.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    return [\n        [\n            'rgb(0,0,0)', 'rgb(52,52,52)', 'rgb(83,83,83)', 'rgb(135,135,135)', 'rgb(193,193,193)',\n            'rgb(234,234,234)', 'rgb(240,240,240)', 'rgb(255,255,255)'\n        ],\n        [\n            'rgb(252,0,9)', 'rgb(253,135,10)', 'rgb(255,255,13)', 'rgb(35,255,9)', 'rgb(33,255,255)',\n            'rgb(0,0,254)', 'rgb(132,0,254)', 'rgb(251,0,255)'\n        ],\n        [\n            'rgb(240,192,194)', 'rgb(251,223,194)', 'rgb(255,241,193)', 'rgb(210,230,201)',\n            'rgb(199,217,220)', 'rgb(197,219,240)', 'rgb(208,200,227)', 'rgb(229,199,212)'\n        ],\n        [\n            'rgb(228,133,135)', 'rgb(246,193,139)', 'rgb(254,225,136)', 'rgb(168,208,152)',\n            'rgb(146,184,190)', 'rgb(143,184,227)', 'rgb(165,148,204)', 'rgb(202,147,175)'\n        ],\n        [\n            'rgb(214,78,83)', 'rgb(243,163,88)', 'rgb(254,211,83)', 'rgb(130,187,106)',\n            'rgb(99,149,159)', 'rgb(93,150,211)', 'rgb(123,100,182)', 'rgb(180,100,142)'\n        ],\n        [\n            'rgb(190,0,5)', 'rgb(222,126,44)', 'rgb(236,183,39)', 'rgb(89,155,61)', 'rgb(55,110,123)',\n            'rgb(49,112,185)', 'rgb(83,55,150)', 'rgb(147,55,101)'\n        ],\n        [\n            'rgb(133,0,3)', 'rgb(163,74,10)', 'rgb(177,127,7)', 'rgb(45,101,23)', 'rgb(18,62,74)',\n            'rgb(14,62,129)', 'rgb(40,15,97)', 'rgb(95,16,55)'\n        ],\n        [\n            'rgb(81,0,1)', 'rgb(100,48,7)', 'rgb(107,78,3)', 'rgb(31,63,16)',\n            'rgb(13,39,46)', 'rgb(10,40,79)', 'rgb(24,12,59)', 'rgb(59,10,36)'\n        ]\n    ];\n});\n","Magento_Ui/js/form/element/media.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mageUtils',\n    './abstract'\n], function (utils, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            links: {\n                value: ''\n            }\n        },\n\n        /**\n         * Initializes file component.\n         *\n         * @returns {Media} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initFormId();\n\n            return this;\n        },\n\n        /**\n         * Defines form ID with which file input will be associated.\n         *\n         * @returns {Media} Chainable.\n         */\n        initFormId: function () {\n            var namespace;\n\n            if (this.formId) {\n                return this;\n            }\n\n            namespace   = this.name.split('.');\n            this.formId = namespace[0];\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'moment',\n    'mageUtils',\n    './abstract',\n    'moment-timezone-with-data'\n], function (moment, utils, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            options: {},\n\n            storeTimeZone: 'UTC',\n\n            validationParams: {\n                dateFormat: '${ $.outputDateFormat }'\n            },\n\n            /**\n             * Format of date that comes from the\n             * server (ICU Date Format).\n             *\n             * Used only in date picker mode\n             * (this.options.showsTime == false).\n             *\n             * @type {String}\n             */\n            inputDateFormat: 'y-MM-dd',\n\n            /**\n             * Format of date that should be sent to the\n             * server (ICU Date Format).\n             *\n             * Used only in date picker mode\n             * (this.options.showsTime == false).\n             *\n             * @type {String}\n             */\n            outputDateFormat: 'MM/dd/y',\n\n            /**\n             * Date/time format that is used to display date in\n             * the input field.\n             *\n             * @type {String}\n             */\n            pickerDateTimeFormat: '',\n\n            pickerDefaultDateFormat: 'MM/dd/y', // ICU Date Format\n            pickerDefaultTimeFormat: 'h:mm a', // ICU Time Format\n\n            elementTmpl: 'ui/form/element/date',\n\n            /**\n             * Format needed by moment timezone for conversion\n             */\n            timezoneFormat: 'YYYY-MM-DD HH:mm',\n\n            listens: {\n                'value': 'onValueChange',\n                'shiftedValue': 'onShiftedValueChange'\n            },\n\n            /**\n             * Date/time value shifted to corresponding timezone\n             * according to this.storeTimeZone property. This value\n             * will be sent to the server.\n             *\n             * @type {String}\n             */\n            shiftedValue: ''\n        },\n\n        /**\n         * Initializes regular properties of instance.\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            if (!this.options.dateFormat) {\n                this.options.dateFormat = this.pickerDefaultDateFormat;\n            }\n\n            if (!this.options.timeFormat) {\n                this.options.timeFormat = this.pickerDefaultTimeFormat;\n            }\n\n            this.prepareDateTimeFormats();\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this._super().observe(['shiftedValue']);\n        },\n\n        /**\n         * Prepares and sets date/time value that will be displayed\n         * in the input field.\n         *\n         * @param {String} value\n         */\n        onValueChange: function (value) {\n            var shiftedValue;\n\n            if (value) {\n                if (this.options.showsTime) {\n                    shiftedValue = moment.tz(value, 'UTC').tz(this.storeTimeZone);\n                } else {\n                    shiftedValue = moment(value, this.outputDateFormat);\n                }\n\n                if (!shiftedValue.isValid()) {\n                    shiftedValue = moment(value, this.inputDateFormat);\n                }\n                shiftedValue = shiftedValue.format(this.pickerDateTimeFormat);\n            } else {\n                shiftedValue = '';\n            }\n\n            if (shiftedValue !== this.shiftedValue()) {\n                this.shiftedValue(shiftedValue);\n            }\n        },\n\n        /**\n         * Prepares and sets date/time value that will be sent\n         * to the server.\n         *\n         * @param {String} shiftedValue\n         */\n        onShiftedValueChange: function (shiftedValue) {\n            var value,\n                formattedValue,\n                momentValue;\n\n            if (shiftedValue) {\n                momentValue = moment(shiftedValue, this.pickerDateTimeFormat);\n\n                if (this.options.showsTime) {\n                    formattedValue = moment(momentValue).format(this.timezoneFormat);\n                    value = moment.tz(formattedValue, this.storeTimeZone).tz('UTC').toISOString();\n                } else {\n                    value = momentValue.format(this.outputDateFormat);\n                }\n            } else {\n                value = '';\n            }\n\n            if (value !== this.value()) {\n                this.value(value);\n            }\n        },\n\n        /**\n         * Prepares and converts all date/time formats to be compatible\n         * with moment.js library.\n         */\n        prepareDateTimeFormats: function () {\n            this.pickerDateTimeFormat = this.options.dateFormat;\n\n            if (this.options.showsTime) {\n                this.pickerDateTimeFormat += ' ' + this.options.timeFormat;\n            }\n\n            this.pickerDateTimeFormat = utils.convertToMomentFormat(this.pickerDateTimeFormat);\n\n            if (this.options.dateFormat) {\n                this.outputDateFormat = this.options.dateFormat;\n            }\n\n            this.inputDateFormat = utils.convertToMomentFormat(this.inputDateFormat);\n            this.outputDateFormat = utils.convertToMomentFormat(this.outputDateFormat);\n\n            this.validationParams.dateFormat = this.outputDateFormat;\n        }\n    });\n});\n","Magento_Ui/js/form/adapter/buttons.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(function () {\n    'use strict';\n\n    return {\n        'reset': '#reset',\n        'save': '#save',\n        'saveAndContinue': '#save_and_continue'\n    };\n});\n","Magento_Ui/js/form/components/fieldset.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/lib/collapsible',\n    'underscore'\n], function (Collapsible, _) {\n    'use strict';\n\n    return Collapsible.extend({\n        defaults: {\n            template: 'ui/form/fieldset',\n            collapsible: false,\n            changed: false,\n            loading: false,\n            error: false,\n            opened: false,\n            level: 0,\n            visible: true,\n            initializeFieldsetDataByDefault: false, /* Data in some fieldsets should be initialized before open */\n            disabled: false,\n            listens: {\n                'opened': 'onVisibilityChange'\n            },\n            additionalClasses: {}\n        },\n\n        /**\n         * Extends instance with defaults. Invokes parent initialize method.\n         * Calls initListeners and pushParams methods.\n         */\n        initialize: function () {\n            _.bindAll(this, 'onChildrenUpdate', 'onChildrenError', 'onContentLoading');\n\n            return this._super()\n                ._setClasses();\n        },\n\n        /**\n         * Initializes components' configuration.\n         *\n         * @returns {Fieldset} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n            this._wasOpened = this.opened || !this.collapsible;\n\n            return this;\n        },\n\n        /**\n         * Calls initObservable of parent class.\n         * Defines observable properties of instance.\n         *\n         * @returns {Object} Reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe('changed loading error visible');\n\n            return this;\n        },\n\n        /**\n         * Calls parent's initElement method.\n         * Assigns callbacks on various events of incoming element.\n         *\n         * @param  {Object} elem\n         * @return {Object} - reference to instance\n         */\n        initElement: function (elem) {\n            elem.initContainer(this);\n\n            elem.on({\n                'update': this.onChildrenUpdate,\n                'loading': this.onContentLoading,\n                'error': this.onChildrenError\n            });\n\n            if (this.disabled) {\n                try {\n                    elem.disabled(true);\n                }\n                catch (e) {\n\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Is being invoked on children update.\n         * Sets changed property to one incoming.\n         *\n         * @param  {Boolean} hasChanged\n         */\n        onChildrenUpdate: function (hasChanged) {\n            if (!hasChanged) {\n                hasChanged = _.some(this.delegate('hasChanged'));\n            }\n\n            this.bubble('update', hasChanged);\n            this.changed(hasChanged);\n        },\n\n        /**\n         * Extends 'additionalClasses' object.\n         *\n         * @returns {Group} Chainable.\n         */\n        _setClasses: function () {\n            var additional = this.additionalClasses,\n                classes;\n\n            if (_.isString(additional)) {\n                additional = this.additionalClasses.split(' ');\n                classes = this.additionalClasses = {};\n\n                additional.forEach(function (name) {\n                    classes[name] = true;\n                }, this);\n            }\n\n            _.extend(this.additionalClasses, {\n                'admin__collapsible-block-wrapper': this.collapsible,\n                _show: this.opened,\n                _hide: !this.opened,\n                _disabled: this.disabled\n            });\n\n            return this;\n        },\n\n        /**\n         * Handler of the \"opened\" property changes.\n         *\n         * @param {Boolean} isOpened\n         */\n        onVisibilityChange: function (isOpened) {\n            if (!this._wasOpened) {\n                this._wasOpened = isOpened;\n            }\n        },\n\n        /**\n         * Is being invoked on children validation error.\n         * Sets error property to one incoming.\n         *\n         * @param {String} message - error message.\n         */\n        onChildrenError: function (message) {\n            var hasErrors = false;\n\n            if (!message) {\n                hasErrors = this._isChildrenHasErrors(hasErrors, this);\n            }\n\n            this.error(hasErrors || message);\n\n            if (hasErrors || message) {\n                this.open();\n            }\n        },\n\n        /**\n         * Returns errors of children if exist\n         *\n         * @param {Boolean} hasErrors\n         * @param {*} container\n         * @return {Boolean}\n         * @private\n         */\n        _isChildrenHasErrors: function (hasErrors, container) {\n            var self = this;\n\n            if (hasErrors === false && container.hasOwnProperty('elems')) {\n                hasErrors = container.elems.some('error');\n\n                if (hasErrors === false && container.hasOwnProperty('_elems')) {\n                    container._elems.forEach(function (child) {\n\n                        if (hasErrors === false) {\n                            hasErrors = self._isChildrenHasErrors(hasErrors, child);\n                        }\n                    });\n                }\n            }\n\n            return hasErrors;\n        },\n\n        /**\n         * Callback that sets loading property to true.\n         */\n        onContentLoading: function (isLoading) {\n            this.loading(isLoading);\n        }\n    });\n});\n","Magento_Ui/js/form/components/area.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './tab'\n], function (_, Tab) {\n    'use strict';\n\n    return Tab.extend({\n        defaults: {\n            uniqueNs:   'params.activeArea',\n            template:   'ui/area',\n            changed:    false,\n            loading:    false\n        },\n\n        /**\n         * Extends instance with defaults. Invokes parent initialize method.\n         * Calls initListeners and pushParams methods.\n         */\n        initialize: function () {\n            _.bindAll(this, 'onChildrenUpdate', 'onContentLoading');\n\n            return this._super();\n        },\n\n        /**\n         * Calls initObservable of parent class.\n         * Defines observable properties of instance.\n         * @return {Object} - reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe('changed loading');\n\n            return this;\n        },\n\n        /**\n         * Calls parent's initElement method.\n         * Assigns callbacks on various events of incoming element.\n         * @param  {Object} elem\n         * @return {Object} - reference to instance\n         */\n        initElement: function (elem) {\n            this._super();\n\n            elem.on({\n                'update':   this.onChildrenUpdate,\n                'loading':  this.onContentLoading\n            });\n\n            return this;\n        },\n\n        /**\n         * Is being invoked on children update.\n         * Sets changed property to one incoming.\n         * Invokes setActive method if settings\n         * contain makeVisible property set to true.\n         *\n         * @param  {Boolean} hasChanged\n         */\n        onChildrenUpdate: function (hasChanged) {\n            if (!hasChanged) {\n                hasChanged = _.some(this.delegate('hasChanged'));\n            }\n\n            this.changed(hasChanged);\n        },\n\n        /**\n         * Callback that sets loading property to true.\n         */\n        onContentLoading: function (isLoading) {\n            this.loading(isLoading);\n        }\n    });\n});\n","Magento_Ui/js/form/components/insert-listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    './insert',\n    'mageUtils',\n    'underscore'\n], function ($, Insert, utils, _) {\n    'use strict';\n\n    return Insert.extend({\n        defaults: {\n            externalListingName: '${ $.ns }.${ $.ns }',\n            behaviourType: 'simple',\n            externalFilterMode: false,\n            requestConfig: {\n                method: 'POST'\n            },\n            externalCondition: 'nin',\n            settings: {\n                edit: {\n                    imports: {\n                        'onChangeRecord': '${ $.editorProvider }:changed'\n                    }\n                },\n                filter: {\n                    exports: {\n                        'requestConfig': '${ $.externalProvider }:requestConfig'\n                    }\n                }\n            },\n            imports: {\n                onSelectedChange: '${ $.selectionsProvider }:selected',\n                'update_url': '${ $.externalProvider }:update_url',\n                'indexField': '${ $.selectionsProvider }:indexField'\n            },\n            exports: {\n                externalFiltersModifier: '${ $.externalProvider }:params.filters_modifier'\n            },\n            listens: {\n                externalValue: 'updateExternalFiltersModifier updateSelections',\n                indexField: 'initialUpdateListing'\n            },\n            modules: {\n                selections: '${ $.selectionsProvider }',\n                externalListing: '${ $.externalListingName }'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super();\n            _.bindAll(this, 'updateValue', 'updateExternalValueByEditableData');\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initConfig: function (config) {\n            var defaults = this.constructor.defaults;\n\n            if (config.behaviourType === 'edit') {\n                defaults.editableData = {};\n                _.map(defaults.settings.edit.imports, function (value, key) {\n                    this.imports[key] = value;\n                }, defaults);\n            }\n\n            if (config.externalFilterMode === true) {\n                _.map(defaults.settings.filter.exports, function (value, key) {\n                    this.exports[key] = value;\n                }, defaults);\n            }\n\n            return this._super();\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe([\n                    'externalValue'\n                ]);\n        },\n\n        /** @inheritdoc */\n        destroyInserted: function () {\n            if (this.isRendered && this.externalListing()) {\n                this.externalListing().source.storage().clearRequests();\n                this.externalListing().delegate('destroy');\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Store data from edited record\n         *\n         * @param {Object} record\n         */\n        onChangeRecord: function (record) {\n            this.updateEditableData(record);\n\n            if (!this.dataLinks.imports) {\n                return;\n            }\n\n            this.updateExternalValueByEditableData();\n        },\n\n        /**\n         * Updates externalValue every time row is selected,\n         * if it is configured by 'dataLinks.imports'\n         * Also suppress dataLinks so import/export of selections will not activate each other in circle\n         *\n         */\n        onSelectedChange: function () {\n            if (!this.dataLinks.imports ||\n                this.suppressDataLinks ||\n                _.isBoolean(this.initialExportDone) && !this.initialExportDone\n            ) {\n                this.suppressDataLinks = false;\n\n                return;\n            }\n\n            this.suppressDataLinks = true;\n            this.updateExternalValue();\n        },\n\n        /**\n         * Stores data from editor in editableData\n         * @param {Object} record\n         *\n         */\n        updateEditableData: function (record) {\n            var id = _.keys(record[0])[0];\n\n            this.editableData[id] = record[0][id];\n        },\n\n        /**\n         * Updates externalValue by data from editor (already stored in editableData)\n         *\n         */\n        updateExternalValueByEditableData: function () {\n            var updatedExtValue;\n\n            if (!this.behaviourType === 'edit' || _.isEmpty(this.editableData) || _.isEmpty(this.externalValue())) {\n                return;\n            }\n\n            updatedExtValue = this.externalValue();\n            updatedExtValue.map(function (item) {\n                _.extend(item, this.editableData[item[this.indexField]]);\n            }, this);\n            this.setExternalValue(updatedExtValue);\n        },\n\n        /**\n         * Updates externalValue, from selectionsProvider data (if it is enough)\n         * or ajax request to server\n         *\n         * @returns {Object} result - deferred that will be resolved when value is updated\n         */\n        updateExternalValue: function () {\n            var result = $.Deferred(),\n                provider = this.selections(),\n                selections,\n                totalSelected,\n                itemsType,\n                rows;\n\n            if (!provider) {\n                return result;\n            }\n\n            selections = provider && provider.getSelections();\n            totalSelected = provider.totalSelected();\n            itemsType = selections && selections.excludeMode ? 'excluded' : 'selected';\n            rows = provider && provider.rows();\n\n            if (this.canUpdateFromClientData(totalSelected, selections.selected, rows)) {\n                this.updateFromClientData(selections.selected, rows);\n                this.updateExternalValueByEditableData();\n                result.resolve();\n            } else {\n                this.updateFromServerData(selections, itemsType).done(function () {\n                    this.updateExternalValueByEditableData();\n                    result.resolve();\n                }.bind(this));\n            }\n\n            return result;\n        },\n\n        /**\n         * Check if the selected rows data can be taken from selectionsProvider data\n         * (which only stores data of the current page rows)\n         *  + from already saved data\n         *\n         * @param {Boolean} totalSelected - total rows selected (include rows that were filtered out)\n         * @param {Array} selected - ids of selected rows\n         * @param {Object} rows\n         */\n        canUpdateFromClientData: function (totalSelected, selected, rows) {\n            var alreadySavedSelectionsIds = _.pluck(this.externalValue(), this.indexField),\n                rowsOnCurrentPageIds = _.pluck(rows, this.indexField);\n\n            return totalSelected === selected.length &&\n                _.intersection(_.union(alreadySavedSelectionsIds, rowsOnCurrentPageIds), selected).length ===\n                selected.length;\n        },\n\n        /**\n         * Updates externalValue, from selectionsProvider data\n         * (which only stores data of the current page rows)\n         *  + from already saved data\n         *  so we can avoid request to server\n         *\n         * @param {Array} selected - ids of selected rows\n         * @param {Object} rows\n         */\n        updateFromClientData: function (selected, rows) {\n            var value,\n                rowIds,\n                valueIds;\n\n            if (!selected || !selected.length) {\n                this.setExternalValue([]);\n\n                return;\n            }\n\n            value = this.externalValue();\n            rowIds = _.pluck(rows, this.indexField);\n            valueIds = _.pluck(value, this.indexField);\n\n            value = _.map(selected, function (item) {\n                if (_.contains(rowIds, item)) {\n                    return _.find(rows, function (row) {\n                        return row[this.indexField] === item;\n                    }, this);\n                } else if (_.contains(valueIds, item)) {\n                    return _.find(value, function (row) {\n                        return row[this.indexField] === item;\n                    }, this);\n                }\n            }, this);\n\n            this.setExternalValue(value);\n        },\n\n        /**\n         * Updates externalValue, from ajax request to grab selected rows data\n         *\n         * @param {Object} selections\n         * @param {String} itemsType\n         *\n         * @returns {Object} request - deferred that will be resolved when ajax is done\n         */\n        updateFromServerData: function (selections, itemsType) {\n            var filterType = selections && selections.excludeMode ? 'nin' : 'in',\n                selectionsData = {},\n                request;\n\n            _.extend(selectionsData, this.params || {}, selections.params);\n\n            if (selections[itemsType] && selections[itemsType].length) {\n                selectionsData.filters = {};\n                selectionsData['filters_modifier'] = {};\n                selectionsData['filters_modifier'][this.indexField] = {\n                    'condition_type': filterType,\n                    value: selections[itemsType]\n                };\n            }\n\n            selectionsData.paging = {\n                notLimits: 1\n            };\n\n            request = this.requestData(selectionsData, {\n                method: this.requestConfig.method\n            });\n            request\n                .done(function (data) {\n                    this.setExternalValue(data.items || data);\n                    this.loading(false);\n                }.bind(this))\n                .fail(this.onError);\n\n            return request;\n        },\n\n        /**\n         * Set listing rows data to the externalValue,\n         * or if externalData is configured with the names of particular columns,\n         * filter rows data to have only these columns, and then set to the externalValue\n         *\n         * @param {Object} newValue - rows data\n         *\n         */\n        setExternalValue: function (newValue) {\n            var keys = this.externalData,\n                value = this.externalValue(),\n                selectedIds = _.pluck(newValue, this.indexField);\n\n            if (_.isArray(keys) && !_.isEmpty(keys)) {\n                newValue = _.map(newValue, function (item) {\n                    return _.pick(item, keys);\n                }, this);\n            } else if (keys && _.isString(keys) && !_.isEmpty(newValue)) {\n                newValue = newValue[0][keys];\n            }\n\n            if (this.externalFilterMode) {\n                newValue = _.union(newValue, _.filter(value,\n                    function (item) {\n                        return !_.contains(selectedIds, item[this.indexField]);\n                    }, this));\n            }\n\n            this.set('externalValue', newValue);\n        },\n\n        /**\n         * Updates external filter (if externalFilterMode is on)\n         * every time, when value is updated,\n         * so grid is re-filtered to exclude or include selected rows only\n         *\n         * @param {Object} items\n         */\n        updateExternalFiltersModifier: function (items) {\n            var provider,\n                filter = {};\n\n            if (!this.externalFilterMode) {\n                return;\n            }\n\n            provider = this.selections();\n\n            if (!provider) {\n                this.needInitialListingUpdate = true;\n\n                return;\n            }\n\n            filter[this.indexField] = {\n                'condition_type': this.externalCondition,\n                value: _.pluck(items, this.indexField)\n            };\n            this.set('externalFiltersModifier', filter);\n        },\n\n        /**\n         * Updates grid selections\n         * every time, when extenalValue is updated,\n         * so grid is re-selected according to externalValue updated\n         * Also suppress dataLinks so import/export of selections will not activate each other in circle\n         *\n         * @param {Object} items\n         */\n        updateSelections: function (items) {\n            var provider,\n                ids;\n\n            if (!this.dataLinks.exports || this.suppressDataLinks) {\n                this.suppressDataLinks = false;\n                this.initialExportDone = true;\n\n                return;\n            }\n\n            provider = this.selections();\n\n            if (!provider) {\n                this.needInitialListingUpdate = true;\n\n                return;\n            }\n\n            this.suppressDataLinks = true;\n            provider.deselectAll();\n\n            if (_.isString(items)) {\n                provider.selected([items] || []);\n            } else {\n                ids = _.pluck(items || [], this.indexField)\n                    .map(function (item) {\n                        return item.toString();\n                    });\n\n                provider.selected(ids || []);\n            }\n            this.initialExportDone = true;\n        },\n\n        /**\n         * initial update of the listing\n         * with rows that must be checked/filtered\n         * by the indexes\n         */\n        initialUpdateListing: function () {\n            var items = this.externalValue();\n\n            if (this.needInitialListingUpdate && items) {\n                this.updateExternalFiltersModifier(items);\n                this.updateSelections(items);\n                this.needInitialListingUpdate = false;\n            }\n        },\n\n        /**\n         * Reload source\n         */\n        reload: function () {\n            this.externalSource().set('params.t', new Date().getTime());\n        },\n\n        /**\n         * Updates value from external value\n         *\n         */\n        updateValue: function () {\n            this.set('value', this.externalValue());\n        },\n\n        /**\n         * Updates external value, then updates value from external value\n         *\n         */\n        save: function () {\n            this.updateExternalValue().done(\n                function () {\n                    if (!this.realTimeLink) {\n                        this.updateValue();\n                    }\n                }.bind(this)\n            );\n        }\n    });\n});\n","Magento_Ui/js/form/components/insert.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiElement',\n    'jquery',\n    'mage/translate',\n    'mageUtils',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/lib/view/utils/bindings',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (Element, $, $t, utils, _, alert) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            content: '',\n            template: 'ui/form/insert',\n            showSpinner: true,\n            loading: false,\n            autoRender: true,\n            visible: true,\n            contentSelector: '${$.name}',\n            externalData: [],\n            params: {\n                namespace: '${ $.ns }'\n            },\n            renderSettings: {\n                url: '${ $.render_url }',\n                dataType: 'html'\n            },\n            updateSettings: {\n                url: '${ $.update_url }',\n                dataType: 'json'\n            },\n            imports: {},\n            exports: {},\n            listens: {},\n            links: {\n                value: '${ $.provider }:${ $.dataScope}'\n            },\n            modules: {\n                externalSource: '${ $.externalProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            _.bindAll(this, 'onRender', 'onUpdate');\n\n            if (this.autoRender) {\n                this.render();\n            }\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe([\n                    'visible',\n                    'content',\n                    'value',\n                    'loading'\n                ]);\n        },\n\n        /** @inheritdoc */\n        initConfig: function (config) {\n            this.initDataLink(config)._super();\n            this.contentSelector = this.contentSelector.replace(/\\./g, '_');\n\n            return this;\n        },\n\n        /**\n         * Sync data with external provider.\n         *\n         * @param {Object} config\n         * @returns {Object}\n         */\n        initDataLink: function (config) {\n            var key, value;\n\n            if (config.dataLinks) {\n                _.each(config.externalData, function (val) {\n                    value = val;\n                    key = 'externalValue.' + val.replace('data.', '');\n\n                    if (config.dataLinks.imports) {\n                        this.imports[key] = '${ $.externalProvider }:' + value;\n                    }\n\n                    if (config.dataLinks.exports) {\n                        this.exports[key] = '${ $.externalProvider }:' + value;\n                    }\n                    this.links[key] = '${ $.externalProvider }:' + value;\n                }, this.constructor.defaults);\n            }\n\n            if (config.realTimeLink) {\n                this.constructor.defaults.links.externalValue = 'value';\n            }\n\n            return this;\n        },\n\n        /**\n         * Request for render content.\n         *\n         * @returns {Object}\n         */\n        render: function (params) {\n            var self = this,\n                request;\n\n            if (this.isRendered) {\n                return this;\n            }\n\n            self.previousParams = params || {};\n\n            $.async({\n                component: this.name,\n                ctx: '.' + this.contentSelector\n            }, function (el) {\n                self.contentEl = $(el);\n                self.startRender = true;\n                params = _.extend({}, self.params, params || {});\n                request = self.requestData(params, self.renderSettings);\n                request\n                    .done(self.onRender)\n                    .fail(self.onError);\n            });\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this.destroyInserted()\n                ._super();\n        },\n\n        /**\n         * Destroy inserted components.\n         *\n         * @returns {Object}\n         */\n        destroyInserted: function () {\n            if (this.isRendered) {\n                this.isRendered = false;\n                this.content('');\n\n                if (this.externalSource()) {\n                    this.externalSource().destroy();\n                }\n                this.initExternalLinks();\n            }\n\n            return this;\n        },\n\n        /**\n         * Initialize links on external components.\n         *\n         * @returns {Object}\n         */\n        initExternalLinks: function () {\n            var imports = this.filterExternalLinks(this.imports, this.ns),\n                exports = this.filterExternalLinks(this.exports, this.ns),\n                links = this.filterExternalLinks(this.links, this.ns);\n\n            this.setLinks(links, 'imports')\n                .setLinks(links, 'exports');\n\n            _.each({\n                exports: exports,\n                imports: imports\n            }, this.setLinks, this);\n\n            return this;\n        },\n\n        /**\n         * Filter external links.\n         *\n         * @param {Object} data\n         * @param {String }ns\n         * @returns {Object}\n         */\n        filterExternalLinks: function (data, ns) {\n            var links  = {};\n\n            _.each(data, function (value, key) {\n                if (value.split('.')[0] === ns) {\n                    links[key] = value;\n                }\n            });\n\n            return links;\n        },\n\n        /**\n         * Request with configurable params and settings.\n         *\n         * @param {Object} params\n         * @param {Object} ajaxSettings\n         * @returns {Object}\n         */\n        requestData: function (params, ajaxSettings) {\n            var query = utils.copy(params);\n\n            ajaxSettings = _.extend({\n                url: this['update_url'],\n                method: 'GET',\n                data: query,\n                dataType: 'json'\n            }, ajaxSettings);\n\n            this.loading(true);\n\n            return $.ajax(ajaxSettings);\n        },\n\n        /**\n         * Callback that render content.\n         *\n         * @param {*} data\n         */\n        onRender: function (data) {\n            var resp;\n\n            this.loading(false);\n\n            try {\n                resp = JSON.parse(data);\n\n                if (resp.ajaxExpired) {\n                    window.location.href = resp.ajaxRedirect;\n                }\n            } catch (e) {\n                this.set('content', data);\n                this.isRendered = true;\n                this.startRender = false;\n            }\n        },\n\n        /**\n         * Error callback.\n         *\n         * @param {Object} xhr\n         */\n        onError: function (xhr) {\n            if (xhr.statusText === 'abort') {\n                return;\n            }\n\n            alert({\n                content: $t('Something went wrong.')\n            });\n        },\n\n        /**\n         * Getter for external data.\n         *\n         * @returns {Object}\n         */\n        getExternalData: function () {\n            var data = {};\n\n            _.each(this.externalData, function (path) {\n                utils.nested(data, path.replace('data.', ''), this.externalSource().get(path));\n            }, this);\n\n            return data;\n        },\n\n        /**\n         * Request for update data.\n         *\n         * @returns {*|Object}\n         */\n        updateData: function (params) {\n            var request;\n\n            params = _.extend(params || {}, this.params);\n\n            if (!this.startRender && !this.isRendered) {\n                return this.render(params);\n            }\n\n            request = this.requestData(params, this.updateSettings);\n            request\n                .done(this.onUpdate)\n                .fail(this.onError);\n\n            return request;\n        },\n\n        /**\n         * Set data to external provider, clear changes.\n         *\n         * @param {*} data\n         */\n        onUpdate: function (data) {\n            this.externalSource().set('data', data);\n            this.externalSource().trigger('data.overload');\n            this.loading(false);\n        }\n    });\n});\n","Magento_Ui/js/form/components/tab_group.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/lib/collapsible'\n], function (_, Collapsible) {\n    'use strict';\n\n    return Collapsible.extend({\n        defaults: {\n            listens: {\n                '${ $.provider }:data.validate': 'onValidate'\n            },\n            collapsible: false,\n            opened: true\n        },\n\n        /**\n         * Invokes initElement method of parent class, calls 'initActivation' method\n         * passing element to it.\n         * @param {Object} elem\n         * @returns {Object} - reference to instance\n         */\n        initElement: function (elem) {\n            this._super()\n                .initActivation(elem);\n\n            return this;\n        },\n\n        /**\n         * Activates element if one is first or if one has 'active' propert\n         * set to true.\n         *\n         * @param  {Object} elem\n         * @returns {Object} - reference to instance\n         */\n        initActivation: function (elem) {\n            var elems   = this.elems(),\n                isFirst = !elems.indexOf(elem);\n\n            if (isFirst || elem.active()) {\n                elem.activate();\n            }\n\n            return this;\n        },\n\n        /**\n         * Delegates 'validate' method on element, then reads 'invalid' property\n         * of params storage, and if defined, activates element, sets\n         * 'allValid' property of instance to false and sets invalid's\n         * 'focused' property to true.\n         *\n         * @param {Object} elem\n         */\n        validate: function (elem) {\n            var result  = elem.delegate('validate'),\n                invalid;\n\n            invalid = _.find(result, function (item) {\n                return typeof item !== 'undefined' && !item.valid;\n            });\n\n            if (invalid) {\n                elem.activate();\n                invalid.target.focused(true);\n            }\n\n            return invalid;\n        },\n\n        /**\n         * Sets 'allValid' property of instance to true, then calls 'validate' method\n         * of instance for each element.\n         */\n        onValidate: function () {\n            this.elems.sortBy(function (elem) {\n                return !elem.active();\n            }).some(this.validate, this);\n        }\n    });\n});\n","Magento_Ui/js/form/components/group.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiCollection'\n], function (_, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            visible: true,\n            label: '',\n            showLabel: true,\n            required: false,\n            template: 'ui/group/group',\n            fieldTemplate: 'ui/form/field',\n            breakLine: true,\n            validateWholeGroup: false,\n            additionalClasses: {}\n        },\n\n        /**\n         * Extends this with defaults and config.\n         * Then calls initObservable, iniListenes and extractData methods.\n         */\n        initialize: function () {\n            this._super()\n                ._setClasses();\n\n            return this;\n        },\n\n        /**\n         * Calls initObservable of parent class.\n         * Defines observable properties of instance.\n         *\n         * @return {Object} - reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe('visible')\n                .observe({\n                    required: !!+this.required\n                });\n\n            return this;\n        },\n\n        /**\n         * Extends 'additionalClasses' object.\n         *\n         * @returns {Group} Chainable.\n         */\n        _setClasses: function () {\n            var additional = this.additionalClasses,\n                classes;\n\n            if (_.isString(additional)) {\n                additional = this.additionalClasses.split(' ');\n                classes = this.additionalClasses = {};\n\n                additional.forEach(function (name) {\n                    classes[name] = true;\n                }, this);\n            }\n\n            _.extend(this.additionalClasses, {\n                'admin__control-grouped': !this.breakLine,\n                'admin__control-fields': this.breakLine,\n                required:   this.required,\n                _error:     this.error,\n                _disabled:  this.disabled\n            });\n\n            return this;\n        },\n\n        /**\n         * Defines if group has only one element.\n         * @return {Boolean}\n         */\n        isSingle: function () {\n            return this.elems.getLength() === 1;\n        },\n\n        /**\n         * Defines if group has multiple elements.\n         * @return {Boolean}\n         */\n        isMultiple: function () {\n            return this.elems.getLength() > 1;\n        },\n\n        /**\n         * Returns an array of child components previews.\n         *\n         * @returns {Array}\n         */\n        getPreview: function () {\n            return this.elems.map('getPreview');\n        }\n    });\n});\n","Magento_Ui/js/form/components/button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiElement',\n    'uiRegistry',\n    'uiLayout',\n    'mageUtils',\n    'underscore'\n], function (Element, registry, layout, utils, _) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            buttonClasses: {},\n            additionalClasses: {},\n            displayArea: 'outsideGroup',\n            displayAsLink: false,\n            elementTmpl: 'ui/form/element/button',\n            template: 'ui/form/components/button/simple',\n            visible: true,\n            disabled: false,\n            title: ''\n        },\n\n        /**\n         * Initializes component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            return this._super()\n                ._setClasses()\n                ._setButtonClasses();\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe([\n                    'visible',\n                    'disabled',\n                    'title',\n                    'childError'\n                ]);\n        },\n\n        /**\n         * Performs configured actions\n         */\n        action: function () {\n            this.actions.forEach(this.applyAction, this);\n        },\n\n        /**\n         * Apply action on target component,\n         * but previously create this component from template if it is not existed\n         *\n         * @param {Object} action - action configuration\n         */\n        applyAction: function (action) {\n            var targetName = action.targetName,\n                params = utils.copy(action.params) || [],\n                actionName = action.actionName,\n                target;\n\n            if (!registry.has(targetName)) {\n                this.getFromTemplate(targetName);\n            }\n            target = registry.async(targetName);\n\n            if (target && typeof target === 'function' && actionName) {\n                params.unshift(actionName);\n                target.apply(target, params);\n            }\n        },\n\n        /**\n         * Create target component from template\n         *\n         * @param {Object} targetName - name of component,\n         * that supposed to be a template and need to be initialized\n         */\n        getFromTemplate: function (targetName) {\n            var parentName = targetName.split('.'),\n                index = parentName.pop(),\n                child;\n\n            parentName = parentName.join('.');\n            child = utils.template({\n                parent: parentName,\n                name: index,\n                nodeTemplate: targetName\n            });\n            layout([child]);\n        },\n\n        /**\n         * Extends 'additionalClasses' object.\n         *\n         * @returns {Object} Chainable.\n         */\n        _setClasses: function () {\n            if (typeof this.additionalClasses === 'string') {\n                if (this.additionalClasses === '') {\n                    this.additionalClasses = {};\n\n                    return this;\n                }\n\n                this.additionalClasses = this.additionalClasses\n                    .trim()\n                    .split(' ')\n                    .reduce(function (classes, name) {\n                        classes[name] = true;\n\n                        return classes;\n                    }, {}\n                );\n            }\n\n            return this;\n        },\n\n        /**\n         * Extends 'buttonClasses' object.\n         *\n         * @returns {Object} Chainable.\n         */\n        _setButtonClasses: function () {\n            var additional = this.buttonClasses;\n\n            if (_.isString(additional)) {\n                this.buttonClasses = {};\n\n                if (additional.trim().length) {\n                    additional = additional.trim().split(' ');\n\n                    additional.forEach(function (name) {\n                        if (name.length) {\n                            this.buttonClasses[name] = true;\n                        }\n                    }, this);\n                }\n            }\n\n            _.extend(this.buttonClasses, {\n                'action-basic': !this.displayAsLink,\n                'action-additional': this.displayAsLink\n            });\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/components/insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    './insert',\n    'mageUtils',\n    'jquery'\n], function (Insert, utils, $) {\n    'use strict';\n\n    /**\n     * Get page actions element.\n     *\n     * @param {String} elem\n     * @param {String} actionsClass\n     * @returns {String}\n     */\n    function getPageActions(elem, actionsClass) {\n        var el = document.createElement('div');\n\n        el.innerHTML = elem;\n\n        return el.getElementsByClassName(actionsClass)[0];\n    }\n\n    /**\n     * Return element without page actions toolbar\n     *\n     * @param {String} elem\n     * @param {String} actionsClass\n     * @returns {String}\n     */\n    function removePageActions(elem, actionsClass) {\n        var el = document.createElement('div'),\n            actions;\n\n        el.innerHTML = elem;\n        actions = el.getElementsByClassName(actionsClass)[0];\n\n        if (actions) {\n            el.removeChild(actions);\n        }\n\n        return el.innerHTML;\n    }\n\n    return Insert.extend({\n        defaults: {\n            externalFormName: '${ $.ns }.${ $.ns }',\n            pageActionsClass: 'page-actions',\n            actionsContainerClass: 'page-main-actions',\n            exports: {\n                prefix: '${ $.externalFormName }:selectorPrefix'\n            },\n            imports: {\n                toolbarSection: '${ $.toolbarContainer }:toolbarSection',\n                prefix: '${ $.toolbarContainer }:rootSelector',\n                messagesClass: '${ $.externalFormName }:messagesClass'\n            },\n            settings: {\n                ajax: {\n                    ajaxSave: true,\n                    exports: {\n                        ajaxSave: '${ $.externalFormName }:ajaxSave'\n                    },\n                    imports: {\n                        responseStatus: '${ $.externalFormName }:responseStatus',\n                        responseData: '${ $.externalFormName }:responseData'\n                    }\n                }\n            },\n            modules: {\n                externalForm: '${ $.externalFormName }'\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe('responseStatus');\n        },\n\n        /** @inheritdoc */\n        initConfig: function (config) {\n            var defaults = this.constructor.defaults;\n\n            utils.extend(defaults, defaults.settings[config.formSubmitType] || {});\n\n            return this._super();\n        },\n\n        /** @inheritdoc*/\n        destroyInserted: function () {\n            if (this.isRendered && this.externalForm()) {\n                this.externalForm().delegate('destroy');\n                this.removeActions();\n                this.responseStatus(undefined);\n                this.responseData = {};\n            }\n\n            return this._super();\n        },\n\n        /** @inheritdoc */\n        onRender: function (data) {\n            var actions = getPageActions(data, this.pageActionsClass);\n\n            if (!data.length) {\n                return this;\n            }\n            data = removePageActions(data, this.pageActionsClass);\n            this.renderActions(actions);\n            this._super(data);\n        },\n\n        /**\n         * Insert actions in toolbar.\n         *\n         * @param {String} actions\n         */\n        renderActions: function (actions) {\n            var $container = $('<div/>');\n\n            $container\n                .addClass(this.actionsContainerClass)\n                .append(actions);\n\n            this.formHeader = $container;\n\n            $(this.toolbarSection).append(this.formHeader);\n        },\n\n        /**\n         * Remove actions toolbar.\n         */\n        removeActions: function () {\n            $(this.formHeader).siblings('.' + this.messagesClass).remove();\n            $(this.formHeader).remove();\n            this.formHeader = $();\n        },\n\n        /**\n         * Reset external form data.\n         */\n        resetForm: function () {\n            if (this.externalSource()) {\n                this.externalSource().trigger('data.reset');\n                this.responseStatus(undefined);\n            }\n        }\n    });\n});\n","Magento_Ui/js/form/components/html.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent'\n], function ($, _, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            content:        '',\n            showSpinner:    false,\n            loading:        false,\n            visible:        true,\n            template:       'ui/content/content',\n            additionalClasses: {},\n            ignoreTmpls: {\n                content: true\n            }\n        },\n\n        /**\n         * Extends instance with default config, calls 'initialize' method of\n         *     parent, calls 'initAjaxConfig'\n         */\n        initialize: function () {\n            _.bindAll(this, 'onContainerToggle', 'onDataLoaded');\n\n            this._super()\n                ._setClasses()\n                .initAjaxConfig();\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' method of parent, initializes observable\n         * properties of instance\n         *\n         * @return {Object} - reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe('content loading visible');\n\n            return this;\n        },\n\n        /**\n         * Extends 'additionalClasses' object.\n         *\n         * @returns {Group} Chainable.\n         */\n        _setClasses: function () {\n            var additional = this.additionalClasses,\n                classes;\n\n            if (_.isString(additional)) {\n                additional = this.additionalClasses.split(' ');\n                classes = this.additionalClasses = {};\n\n                additional.forEach(function (name) {\n                    classes[name] = true;\n                }, this);\n            }\n\n            _.extend(this.additionalClasses, {\n                'admin__scope-old': !!additional\n            });\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initContainer: function (parent) {\n            this._super();\n\n            parent.on('active', this.onContainerToggle);\n\n            return this;\n        },\n\n        /**\n         * Initializes default ajax config on instance\n         *\n         * @return {Object} - reference to instance\n         */\n        initAjaxConfig: function () {\n            this.ajaxConfig = {\n                url: this.url,\n                data: {\n                    FORM_KEY: window.FORM_KEY\n                },\n                success:    this.onDataLoaded\n            };\n\n            return this;\n        },\n\n        /**\n         * Calls 'loadData' if both 'active' variable and 'shouldLoad'\n         * property are truthy\n         *\n         * @param  {Boolean} active\n         */\n        onContainerToggle: function (active) {\n            if (active && this.shouldLoad()) {\n                this.loadData();\n            }\n        },\n\n        /**\n         * Defines if instance has 'content' property defined.\n         *\n         * @return {Boolean} [description]\n         */\n        hasData: function () {\n            return !!this.content();\n        },\n\n        /**\n         * Defines if instance should load external data\n         *\n         * @return {Boolean}\n         */\n        shouldLoad: function () {\n            return this.url && !this.hasData() && !this.loading();\n        },\n\n        /**\n         * Sets loading property to true, makes ajax call\n         *\n         * @return {Object} - reference to instance\n         */\n        loadData: function () {\n            this.loading(true);\n\n            $.ajax(this.ajaxConfig);\n\n            return this;\n        },\n\n        /**\n         * Ajax's request success handler. Calls 'updateContent' passing 'data'\n         * to it, then sets 'loading' property to false.\n         *\n         * @param  {String} data\n         */\n        onDataLoaded: function (data) {\n            this.updateContent(data)\n                .loading(false);\n        },\n\n        /**\n         * Sets incoming data 'content' property's value\n         *\n         * @param  {String} content\n         * @return {Object} - reference to instance\n         */\n        updateContent: function (content) {\n            this.content(content);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/components/collection.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Ui/js/modal/confirm'\n], function (_, utils, registry, Component, layout, confirm) {\n    'use strict';\n\n    var childTemplate = {\n        parent: '${ $.$data.name }',\n        name: '${ $.$data.childIndex }',\n        dataScope: '${ $.name }',\n        nodeTemplate: '${ $.$data.name }.${ $.$data.itemTemplate }'\n    };\n\n    return Component.extend({\n        defaults: {\n            lastIndex: 0,\n            template: 'ui/form/components/collection'\n        },\n\n        /**\n         * Extends instance with default config, calls initialize of parent\n         * class, calls initChildren method.\n         */\n        initialize: function () {\n            this._super()\n                .initChildren();\n\n            return this;\n        },\n\n        /**\n         * Activates the incoming child and triggers the update event.\n         *\n         * @param {Object} elem - Incoming child.\n         */\n        initElement: function (elem) {\n            this._super();\n\n            elem.activate();\n\n            this.bubble('update');\n\n            return this;\n        },\n\n        /**\n         * Loops over corresponding data in data storage,\n         * creates child for each and pushes it's identifier to initialItems array.\n         *\n         * @returns {Collection} Chainable.\n         */\n        initChildren: function () {\n            var children = this.source.get(this.dataScope),\n                initial = this.initialItems = [];\n\n            _.each(children, function (item, index) {\n                initial.push(index);\n                this.addChild(index);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Creates new item of collection, based on incoming 'index'.\n         * If not passed creates one with 'new_' prefix.\n         *\n         * @param {String|Object} [index] - Index of a child.\n         * @returns {Collection} Chainable.\n         */\n        addChild: function (index) {\n            this.childIndex = !_.isString(index) ?\n                'new_' + this.lastIndex++ :\n                index;\n\n            layout([utils.template(childTemplate, this)]);\n\n            return this;\n        },\n\n        /**\n         * Returns true if current set of items differ from initial one,\n         * or if some child has been changed.\n         *\n         * @returns {Boolean}\n         */\n        hasChanged: function () {\n            var initial = this.initialItems,\n                current = this.elems.pluck('index'),\n                changed = !utils.equalArrays(initial, current);\n\n            return changed || this.elems.some(function (elem) {\n                return _.some(elem.delegate('hasChanged'));\n            });\n        },\n\n        /**\n         * Initiates validation of its' children components.\n         *\n         * @returns {Array} An array of validation results.\n         */\n        validate: function () {\n            var elems;\n\n            this.allValid = true;\n\n            elems = this.elems.sortBy(function (elem) {\n                return !elem.active();\n            });\n\n            elems = elems.map(this._validate, this);\n\n            return _.flatten(elems);\n        },\n\n        /**\n         * Iterator function for components validation.\n         * Activates first invalid child component.\n         *\n         * @param {Object} elem - Element to run validation on.\n         * @returns {Array} An array of validation results.\n         */\n        _validate: function (elem) {\n            var result = elem.delegate('validate'),\n                invalid;\n\n            invalid = _.some(result, function (item) {\n                return !item.valid;\n            });\n\n            if (this.allValid && invalid) {\n                this.allValid = false;\n\n                elem.activate();\n            }\n\n            return result;\n        },\n\n        /**\n         * Creates function that removes element\n         * from collection using '_removeChild' method.\n         * @param  {Object} elem - Element that should be removed.\n         * @deprecated Not used anymore\n         */\n        removeAddress: function (elem) {\n            var self = this;\n\n            confirm({\n                content: this.removeMessage,\n                actions: {\n                    /** @inheritdoc */\n                    confirm: function () {\n                        self._removeAddress(elem);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Removes element from both collection and data storage,\n         * activates first element if removed one was active,\n         * triggers 'update' event.\n         *\n         * @param {Object} elem - Element to remove.\n         */\n        _removeAddress: function (elem) {\n            var isActive = elem.active(),\n                first;\n\n            elem.destroy();\n\n            first = this.elems.first();\n\n            if (first && isActive) {\n                first.activate();\n            }\n\n            this.bubble('update');\n        }\n    });\n});\n","Magento_Ui/js/form/components/tab.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiCollection'\n], function (Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            uniqueProp:     'active',\n            active:         false,\n            wasActivated:   false\n        },\n\n        /**\n         * Extends instance with defaults. Invokes parent initialize method.\n         * Calls initListeners and pushParams methods.\n         */\n        initialize: function () {\n            this._super()\n                .setUnique();\n        },\n\n        /**\n         * Calls initObservable of parent class.\n         * Defines observable properties of instance.\n         * @return {Object} - reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe('active wasActivated');\n\n            return this;\n        },\n\n        /**\n         * Sets active property to true, then invokes pushParams method.\n         */\n        activate: function () {\n            this.active(true);\n            this.wasActivated(true);\n\n            this.setUnique();\n\n            return true;\n        }\n    });\n});\n","Magento_Ui/js/form/components/collection/item.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    '../tab'\n], function (_, utils, Tab) {\n    'use strict';\n\n    var previewConfig = {\n        separator: ' ',\n        prefix: ''\n    };\n\n    /**\n     * Parses incoming data and returns result merged with default preview config\n     *\n     * @param  {Object|String} data\n     * @return {Object}\n     */\n    function parsePreview(data) {\n        if (typeof data == 'string') {\n            data = {\n                items: data\n            };\n        }\n\n        data.items = utils.stringToArray(data.items);\n\n        return _.defaults(data, previewConfig);\n    }\n\n    return Tab.extend({\n        defaults: {\n            label: '',\n            uniqueNs: 'activeCollectionItem',\n            previewTpl: 'ui/form/components/collection/preview'\n        },\n\n        /**\n         * Extends instance with default config, calls initializes of parent class\n         */\n        initialize: function () {\n            _.bindAll(this, 'buildPreview', 'hasPreview');\n\n            return this._super();\n        },\n\n        /**\n         * Calls initProperties of parent class, initializes properties\n         * of instance.\n         *\n         * @return {Object} - reference to instance\n         */\n        initConfig: function () {\n            this._super();\n\n            this.displayed = [];\n\n            return this;\n        },\n\n        /**\n         * Calls initObservable of parent class, initializes observable\n         * properties of instance.\n         *\n         * @return {Object} - reference to instance\n         */\n        initObservable: function () {\n            this._super()\n                .observe({\n                    noPreview: true,\n                    indexed: {}\n                });\n\n            return this;\n        },\n\n        /**\n         * Is being called when child element has been initialized,\n         *     calls initElement of parent class, binds to element's update event,\n         *     calls insertToArea and insertToIndexed methods passing element to it\n         *\n         * @param  {Object} elem\n         */\n        initElement: function (elem) {\n            this._super()\n                .insertToIndexed(elem);\n\n            return this;\n        },\n\n        /**\n         * Adds element to observable indexed object of instance\n         *\n         * @param  {Object} elem\n         * @return {Object} - reference to instance\n         */\n        insertToIndexed: function (elem) {\n            var indexed = this.indexed();\n\n            indexed[elem.index] = elem;\n\n            this.indexed(indexed);\n\n            return this;\n        },\n\n        /**\n         * Destroys current instance along with all of its' children.\n         * Overrides base method to clear data when this method is called.\n         */\n        destroy: function () {\n            this._super();\n            this._clearData();\n        },\n\n        /**\n         * Clears all data associated with component.\n         * @private\n         *\n         * @returns {Item} Chainable.\n         */\n        _clearData: function () {\n            this.source.remove(this.dataScope);\n\n            return this;\n        },\n\n        /**\n         * Formats incoming previews array via parsePreview function.\n         *\n         * @param  {Array} previews\n         * @return {Array} - formatted previews\n         */\n        formatPreviews: function (previews) {\n            return previews.map(parsePreview);\n        },\n\n        /**\n         * Creates string view of previews\n         *\n         * @param  {Object} data\n         * @return {Strict} - formatted preview string\n         */\n        buildPreview: function (data) {\n            var preview = this.getPreview(data.items),\n                prefix = data.prefix;\n\n            return prefix + preview.join(data.separator);\n        },\n\n        /**\n         * Defines if instance has preview for incoming data\n         *\n         * @param  {Object}  data\n         * @return {Boolean}\n         */\n        hasPreview: function (data) {\n            return !!this.getPreview(data.items).length;\n        },\n\n        /**\n         * Creates an array of previews for elements specified in incoming\n         * items array, calls updatePreview afterwards.\n         *\n         * @param  {Array} items - An array of element's indexes.\n         * @returns {Array} An array of previews.\n         */\n        getPreview: function (items) {\n            var elems = this.indexed(),\n                displayed = this.displayed,\n                preview;\n\n            items = items.map(function (index) {\n                var elem = elems[index];\n\n                preview = elem && elem.visible() ? elem.getPreview() : '';\n\n                preview = Array.isArray(preview) ?\n                    _.compact(preview).join(', ') :\n                    preview;\n\n                utils.toggle(displayed, index, !!preview);\n\n                return preview;\n            });\n\n            this.noPreview(!displayed.length);\n\n            return _.compact(items);\n        }\n    });\n});\n","Magento_Ui/js/core/app.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    './renderer/types',\n    './renderer/layout',\n    '../lib/knockout/bootstrap'\n], function (types, layout) {\n    'use strict';\n\n    return function (data, merge) {\n        types.set(data.types);\n        layout(data.components, undefined, true, merge);\n    };\n});\n","Magento_Ui/js/core/renderer/layout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'mageUtils',\n    'uiRegistry',\n    './types',\n    '../../lib/logger/console-logger'\n], function (_, $, utils, registry, types, consoleLogger) {\n    'use strict';\n\n    var templates = registry.create(),\n        layout = {},\n        cachedConfig = {};\n\n    /**\n     * Build name from parent name and node name\n     *\n     * @param {Object} parent\n     * @param {Object} node\n     * @param {String} [name]\n     * @returns {String}\n     */\n    function getNodeName(parent, node, name) {\n        var parentName = parent && parent.name;\n\n        if (typeof name !== 'string') {\n            name = node.name || name;\n        }\n\n        return utils.fullPath(parentName, name);\n    }\n\n    /**\n     * Get node type from node or parent.\n     *\n     * @param {Object} parent\n     * @param {Object} node\n     * @returns {String}\n     */\n    function getNodeType(parent, node) {\n        return node.type || parent && parent.childType;\n    }\n\n    /**\n     * Get data scope based on parent data scope and node data scope.\n     *\n     * @param {Object} parent\n     * @param {Object} node\n     * @returns {String}\n     */\n    function getDataScope(parent, node) {\n        var dataScope = node.dataScope,\n            parentScope = parent && parent.dataScope;\n\n        return !utils.isEmpty(parentScope) ?\n            !utils.isEmpty(dataScope) ?\n                parentScope + '.' + dataScope :\n                parentScope :\n            dataScope || '';\n    }\n\n    /**\n     * Load node dependencies on other instances.\n     *\n     * @param {Object} node\n     * @returns {jQueryPromise}\n     */\n    function loadDeps(node) {\n        var loaded = $.Deferred(),\n            loggerUtils = consoleLogger.utils;\n\n        if (node.deps) {\n            consoleLogger.utils.asyncLog(\n                loaded,\n                {\n                    data: {\n                        component: node.name,\n                        deps: node.deps\n                    },\n                    messages: loggerUtils.createMessages(\n                        'depsStartRequesting',\n                        'depsFinishRequesting',\n                        'depsLoadingFail'\n                    )\n                }\n            );\n        }\n\n        registry.get(node.deps, function (deps) {\n            node.provider = node.extendProvider ? deps && deps.name : node.provider;\n            loaded.resolve(node);\n        });\n\n        return loaded.promise();\n    }\n\n    /**\n     * Load node component file via requirejs.\n     *\n     * @param {Object} node\n     * @returns {jQueryPromise}\n     */\n    function loadSource(node) {\n        var loaded = $.Deferred(),\n            source = node.component;\n\n        consoleLogger.info('componentStartLoading', {\n            component: node.component\n        });\n\n        require([source], function (constr) {\n            consoleLogger.info('componentFinishLoading', {\n                component: node.component\n            });\n            loaded.resolve(node, constr);\n        }, function () {\n            consoleLogger.error('componentLoadingFail', {\n                component: node.component\n            });\n        });\n\n        return loaded.promise();\n    }\n\n    /**\n     * Create a new component instance and set it to the registry.\n     *\n     * @param {Object} node\n     * @param {Function} Constr\n     */\n    function initComponent(node, Constr) {\n        var component = new Constr(_.omit(node, 'children'));\n\n        consoleLogger.info('componentStartInitialization', {\n            component: node.component,\n            componentName: node.name\n        });\n\n        registry.set(node.name, component);\n    }\n\n    /**\n     * Application entry point.\n     *\n     * @param {Object} nodes\n     * @param {Object} parent\n     * @param {Boolean} cached\n     * @param {Boolean} merge\n     * @returns {Boolean|undefined}\n     */\n    function run(nodes, parent, cached, merge) {\n        if (_.isBoolean(merge) && merge) {\n            layout.merge(nodes);\n\n            return false;\n        }\n\n        if (cached) {\n            cachedConfig[_.keys(nodes)[0]] = JSON.parse(JSON.stringify(nodes));\n        }\n\n        _.each(nodes || [], layout.iterator.bind(layout, parent));\n    }\n\n    _.extend(layout, {\n        /**\n         * Determines if node ready to be added or process it.\n         *\n         * @param {Object} parent\n         * @param {Object|String} node\n         */\n        iterator: function (parent, node) {\n            var action = _.isString(node) ?\n                this.addChild :\n                this.process;\n\n            action.apply(this, arguments);\n        },\n\n        /**\n         * Prepare component.\n         *\n         * @param {Object} parent\n         * @param {Object} node\n         * @param {String} name\n         * @returns {Object}\n         */\n        process: function (parent, node, name) {\n            if (!parent && node.parent) {\n                return this.waitParent(node, name);\n            }\n\n            if (node.nodeTemplate) {\n                return this.waitTemplate.apply(this, arguments);\n            }\n\n            node = this.build.apply(this, arguments);\n\n            if (!registry.has(node.name)) {\n                this.addChild(parent, node)\n                    .manipulate(node)\n                    .initComponent(node);\n            }\n\n            if (node) {\n                run(node.children, node);\n            }\n\n            return this;\n        },\n\n        /**\n         * Detailed processing of component config.\n         *\n         * @param {Object} parent\n         * @param {Object} node\n         * @param {String} name\n         * @returns {Boolean|Object}\n         */\n        build: function (parent, node, name) {\n            var defaults    = parent && parent.childDefaults || {},\n                children    = this.filterDisabledChildren(node.children),\n                type        = getNodeType(parent, node),\n                dataScope   = getDataScope(parent, node),\n                component,\n                extendDeps  = true,\n                nodeName;\n\n            node.children = false;\n            node.extendProvider = true;\n\n            if (node.config && node.config.provider || node.provider) {\n                node.extendProvider = false;\n            }\n\n            if (node.config && node.config.deps || node.deps) {\n                extendDeps = false;\n            }\n\n            node = utils.extend({\n            }, types.get(type), defaults, node);\n\n            nodeName = getNodeName(parent, node, name);\n\n            if (registry.has(nodeName)) {\n                component = registry.get(nodeName);\n                component.children = children;\n\n                return component;\n            }\n\n            if (extendDeps && parent && parent.deps && type) {\n                node.deps = parent.deps;\n            }\n\n            _.extend(node, node.config || {}, {\n                index: node.name || name,\n                name: nodeName,\n                dataScope: dataScope,\n                parentName: utils.getPart(nodeName, -2),\n                parentScope: utils.getPart(dataScope, -2)\n            });\n\n            node.children = children;\n            node.componentType = node.type;\n\n            delete node.type;\n            delete node.config;\n\n            if (children) {\n                node.initChildCount = _.size(children);\n            }\n\n            if (node.isTemplate) {\n                node.isTemplate = false;\n\n                templates.set(node.name, node);\n                registry.get(node.parentName, function (parentComp) {\n                    parentComp.childTemplate = node;\n                });\n\n                return false;\n            }\n\n            if (node.componentDisabled === true) {\n                return false;\n            }\n\n            return node;\n        },\n\n        /**\n         * Filter out all disabled components.\n         *\n         * @param {Object} children\n         * @returns {*}\n         */\n        filterDisabledChildren: function (children) {\n            var cIds;\n\n            //cleanup children config.componentDisabled = true\n            if (children && typeof children === 'object') {\n                cIds = Object.keys(children);\n\n                if (cIds) {\n                    _.each(cIds, function (cId) {\n                        if (typeof children[cId] === 'object' &&\n                            children[cId].hasOwnProperty('config') &&\n                            typeof children[cId].config === 'object' &&\n                            children[cId].config.hasOwnProperty('componentDisabled') &&\n                            children[cId].config.componentDisabled === true) {\n                            delete children[cId];\n                        }\n                    });\n                }\n            }\n\n            return children;\n        },\n\n        /**\n         * Init component.\n         *\n         * @param {Object} node\n         * @returns {Object}\n         */\n        initComponent: function (node) {\n            if (!node.component) {\n                return this;\n            }\n\n            loadDeps(node)\n                .then(loadSource)\n                .done(initComponent);\n\n            return this;\n        }\n    });\n\n    _.extend(layout, {\n        /**\n         * Loading component marked as isTemplate.\n         *\n         * @param {Object} parent\n         * @param {Object} node\n         * @returns {Object}\n         */\n        waitTemplate: function (parent, node) {\n            var args = _.toArray(arguments);\n\n            templates.get(node.nodeTemplate, function () {\n                this.applyTemplate.apply(this, args);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Waiting for parent component and process provided component.\n         *\n         * @param {Object} node\n         * @param {String} name\n         * @returns {Object}\n         */\n        waitParent: function (node, name) {\n            var process = this.process.bind(this);\n\n            registry.get(node.parent, function (parent) {\n                process(parent, node, name);\n            });\n\n            return this;\n        },\n\n        /**\n         * Processing component marked as isTemplate.\n         *\n         * @param {Object} parent\n         * @param {Object} node\n         * @param {String} name\n         */\n        applyTemplate: function (parent, node, name) {\n            var template = templates.get(node.nodeTemplate);\n\n            node = utils.extend({}, template, node);\n\n            delete node.nodeTemplate;\n\n            this.process(parent, node, name);\n        }\n    });\n\n    _.extend(layout, {\n        /**\n         * Determines inserting strategy.\n         *\n         * @param {Object} node\n         * @returns {Object}\n         */\n        manipulate: function (node) {\n            var name = node.name;\n\n            if (node.appendTo) {\n                this.insert(name, node.appendTo, -1);\n            }\n\n            if (node.prependTo) {\n                this.insert(name, node.prependTo, 0);\n            }\n\n            if (node.insertTo) {\n                this.insertTo(name, node.insertTo);\n            }\n\n            return this;\n        },\n\n        /**\n         * Insert component to provide target and position.\n         *\n         * @param {Object|String} item\n         * @param {Object} target\n         * @param {Number} position\n         * @returns {Object}\n         */\n        insert: function (item, target, position) {\n            registry.get(target, function (container) {\n                container.insertChild(item, position);\n            });\n\n            return this;\n        },\n\n        /**\n         * Insert component into multiple targets.\n         *\n         * @param {Object} item\n         * @param {Array} targets\n         * @returns {Object}\n         */\n        insertTo: function (item, targets) {\n            _.each(targets, function (info, target) {\n                this.insert(item, target, info.position);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Add provided child to parent.\n         *\n         * @param {Object} parent\n         * @param {Object|String} child\n         * @returns {Object}\n         */\n        addChild: function (parent, child) {\n            var name;\n\n            if (parent && parent.component) {\n                name = child.name || child;\n\n                this.insert(name, parent.name, child.sortOrder);\n            }\n\n            return this;\n        },\n\n        /**\n         * Merge components configuration with cached configuration.\n         *\n         * @param {Array} components\n         */\n        merge: function (components) {\n            var cachedKey = _.keys(components)[0],\n                compared = utils.compare(cachedConfig[cachedKey], components),\n                remove = this.filterComponents(this.getByProperty(compared.changes, 'type', 'remove'), true),\n                update = this.getByProperty(compared.changes, 'type', 'update'),\n                dataSources = this.getDataSources(components),\n                names, index, name, component;\n\n            _.each(dataSources, function (val, key) {\n                name = key.replace(/\\.children|\\.config/g, '');\n                component = registry.get(name);\n\n                component.cacheData();\n                component.updateConfig(\n                    true,\n                    this.getFullConfig(key, components),\n                    this.getFullConfig(key, cachedConfig[cachedKey])\n                );\n            }, this);\n\n            _.each(remove, function (val) {\n                component = registry.get(val.path);\n\n                if (component) {\n                    component.cleanData().destroy();\n                }\n            });\n\n            update = _.compact(_.filter(update, function (val) {\n                return !_.isEqual(val.oldValue, val.value);\n            }));\n\n            _.each(update, function (val) {\n                names = val.path.split('.');\n                index = Math.max(_.lastIndexOf(names, 'config'), _.lastIndexOf(names, 'children') + 2);\n                name = _.without(names.splice(0, index), 'children', 'config').join('.');\n                component = registry.get(name);\n\n                if (val.name === 'sortOrder' && component) {\n                    registry.get(component.parentName).insertChild(component, val.value);\n                } else if (component) {\n                    component.updateConfig(\n                        val.oldValue,\n                        val.value,\n                        val.path\n                    );\n                }\n            }, this);\n\n            run(components, undefined, true);\n        },\n\n        /**\n         * Recursive dataSource assignment.\n         *\n         * @param {Object} config\n         * @param {String} parentPath\n         * @returns {Object}\n         */\n        getDataSources: function (config, parentPath) {\n            var dataSources = {},\n                key, obj;\n\n            /* eslint-disable no-loop-func, max-depth */\n            for (key in config) {\n                if (config.hasOwnProperty(key)) {\n                    if (\n                        key === 'type' &&\n                        config[key] === 'dataSource' &&\n                        config.hasOwnProperty('config')\n                    ) {\n                        dataSources[parentPath + '.config'] = config.config;\n                    } else if (_.isObject(config[key])) {\n                        obj = this.getDataSources(config[key], utils.fullPath(parentPath, key));\n\n                        _.each(obj, function (value, path) {\n                            dataSources[path] = value;\n                        });\n                    }\n                }\n            }\n\n            /* eslint-enable no-loop-func, max-depth */\n\n            return dataSources;\n        },\n\n        /**\n         * Configuration getter.\n         *\n         * @param {String} path\n         * @param {Object} config\n         * @returns {Boolean|Object}\n         */\n        getFullConfig: function (path, config) {\n            var index;\n\n            path = path.split('.');\n            index = _.lastIndexOf(path, 'config');\n\n            if (!~index) {\n                return false;\n            }\n            path = path.splice(0, index);\n\n            _.each(path, function (val) {\n                config = config[val];\n            });\n\n            return config.config;\n        },\n\n        /**\n         * Filter data by property and value.\n         *\n         * @param {Object} data\n         * @param {String} prop\n         * @param {*} propValue\n         */\n        getByProperty: function (data, prop, propValue) {\n            return _.filter(data, function (value) {\n                return value[prop] === propValue;\n            });\n        },\n\n        /**\n         * Filter components.\n         *\n         * @param {Array} data\n         * @param {Boolean} splitPath\n         * @param {Number} index\n         * @param {String} separator\n         * @param {String} keyName\n         * @returns {Array}\n         */\n        filterComponents: function (data, splitPath, index, separator, keyName) {\n            var result = [],\n                names, length;\n\n            index = -2;\n            separator = '.' || separator;\n            keyName = 'children' || keyName;\n\n            _.each(data, function (val) {\n                names = val.path.split(separator);\n                length  = names.length;\n\n                if (names[length + index] === keyName) {\n                    val.path = splitPath ? _.without(names, keyName).join(separator) : val.path;\n                    result.push(val);\n                }\n            });\n\n            return result;\n        }\n    });\n\n    return run;\n});\n","Magento_Ui/js/core/renderer/types.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mageUtils'\n], function (_, utils) {\n    'use strict';\n\n    var store = {};\n\n    /**\n     * Flatten a nested data.\n     *\n     * @param {Object} data\n     * @returns {Object}\n     */\n    function flatten(data) {\n        var extender = data.extends || [],\n            result = {};\n\n        extender = utils.stringToArray(extender);\n\n        extender.push(data);\n\n        extender.forEach(function (item) {\n            if (_.isString(item)) {\n                item = store[item] || {};\n            }\n\n            utils.extend(result, item);\n        });\n\n        delete result.extends;\n\n        return result;\n    }\n\n    return {\n        /**\n         * Set types to store object.\n         *\n         * @param {Object} types\n         */\n        set: function (types) {\n            types = types || {};\n\n            utils.extend(store, types);\n\n            _.each(types, function (data, type) {\n                store[type] = flatten(data);\n            });\n        },\n\n        /**\n         * Get type from store object.\n         *\n         * @param {String} type\n         * @returns {*|{}}\n         */\n        get: function (type) {\n            return store[type] || {};\n        }\n    };\n});\n","Magento_Ui/js/modal/modal-component.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'uiCollection',\n    'uiRegistry',\n    'underscore',\n    './modal'\n], function ($, Collection, registry, _) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/modal/modal-component',\n            title: '',\n            subTitle: '',\n            options: {\n                modalClass: '',\n                title: '',\n                subTitle: '',\n                buttons: [],\n                keyEventHandlers: {}\n            },\n            valid: true,\n            links: {\n                title: 'options.title',\n                subTitle: 'options.subTitle'\n            },\n            listens: {\n                state: 'onState',\n                title: 'setTitle',\n                'options.subTitle': 'setSubTitle'\n            },\n            modalClass: 'modal-component',\n            onCancel: 'closeModal'\n        },\n\n        /**\n         * Initializes component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super();\n            _.bindAll(this,\n                'initModal',\n                'openModal',\n                'closeModal',\n                'toggleModal',\n                'setPrevValues',\n                'validate');\n            this.initializeContent();\n\n            return this;\n        },\n\n        /**\n         * Initializes modal configuration\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            return this._super()\n                .initSelector()\n                .initModalEvents();\n        },\n\n        /**\n         * Configure modal selector\n         *\n         * @returns {Object} Chainable.\n         */\n        initSelector: function () {\n            var modalClass = this.name.replace(/\\./g, '_');\n\n            this.contentSelector = '.' + this.modalClass;\n            this.options.modalClass = this.options.modalClass + ' ' + modalClass;\n            this.rootSelector = '.' + modalClass;\n\n            return this;\n        },\n\n        /**\n         * Configure modal keyboard handlers\n         * and outer click\n         *\n         * @returns {Object} Chainable.\n         */\n        initModalEvents: function () {\n            this.options.keyEventHandlers.escapeKey = this.options.outerClickHandler = this[this.onCancel].bind(this);\n\n            return this;\n        },\n\n        /**\n         * Initialize modal's content components\n         */\n        initializeContent: function () {\n            $.async({\n                component: this.name\n            }, this.initModal);\n        },\n\n        /**\n         * Init toolbar section so other components will be able to place something in it\n         */\n        initToolbarSection: function () {\n            this.set('toolbarSection', this.modal.data('mage-modal').modal.find('header').get(0));\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n            this.observe(['state', 'focused']);\n\n            return this;\n        },\n\n        /**\n         * Wrap content in a modal of certain type\n         *\n         * @param {HTMLElement} element\n         * @returns {Object} Chainable.\n         */\n        initModal: function (element) {\n            if (!this.modal) {\n                this.overrideModalButtonCallback();\n                this.options.modalCloseBtnHandler = this[this.onCancel].bind(this);\n                this.modal = $(element).modal(this.options);\n                this.initToolbarSection();\n\n                if (this.waitCbk) {\n                    this.waitCbk();\n                    this.waitCbk = null;\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Open modal\n         */\n        openModal: function () {\n            if (this.modal) {\n                this.state(true);\n            } else {\n                this.waitCbk = this.openModal;\n            }\n        },\n\n        /**\n         * Close modal\n         */\n        closeModal: function () {\n            if (this.modal) {\n                this.state(false);\n            } else {\n                this.waitCbk = this.closeModal;\n            }\n        },\n\n        /**\n         * Toggle modal\n         */\n        toggleModal: function () {\n            if (this.modal) {\n                this.state(!this.state());\n            } else {\n                this.waitCbk = this.toggleModal;\n            }\n        },\n\n        /**\n         * Sets title for modal\n         *\n         * @param {String} title\n         */\n        setTitle: function (title) {\n            if (this.title !== title) {\n                this.title = title;\n            }\n\n            if (this.modal) {\n                this.modal.modal('setTitle', title);\n            }\n        },\n\n        /**\n         * Sets subTitle for modal\n         *\n         * @param {String} subTitle\n         */\n        setSubTitle: function (subTitle) {\n            if (this.subTitle !== subTitle) {\n                this.subTitle = subTitle;\n            }\n\n            if (this.modal) {\n                this.modal.modal('setSubTitle', subTitle);\n            }\n        },\n\n        /**\n         * Wrap content in a modal of certain type\n         *\n         * @param {Boolean} state\n         */\n        onState: function (state) {\n            if (state) {\n                this.modal.modal('openModal');\n                this.applyData();\n            } else {\n                this.modal.modal('closeModal');\n            }\n        },\n\n        /**\n         * Validate everything validatable in modal\n         */\n        validate: function (elem) {\n            if (typeof elem === 'undefined') {\n                return;\n            }\n\n            if (typeof elem.validate === 'function') {\n                this.valid = this.valid & elem.validate().valid;\n            } else if (elem.elems) {\n                elem.elems().forEach(this.validate, this);\n            }\n        },\n\n        /**\n         * Reset data from provider\n         */\n        resetData: function () {\n            this.elems().forEach(this.resetValue, this);\n        },\n\n        /**\n         * Update 'applied' property with data from modal content\n         */\n        applyData: function () {\n            var applied = {};\n\n            this.elems().forEach(this.gatherValues.bind(this, applied), this);\n            this.applied = applied;\n        },\n\n        /**\n         * Gather values from modal content\n         *\n         * @param {Array} applied\n         * @param {HTMLElement} elem\n         */\n        gatherValues: function (applied, elem) {\n            if (typeof elem.value === 'function') {\n                applied[elem.name] = elem.value();\n            } else if (elem.elems) {\n                elem.elems().forEach(this.gatherValues.bind(this, applied), this);\n            }\n        },\n\n        /**\n         * Set to previous values from modal content\n         *\n         * @param {HTMLElement} elem\n         */\n        setPrevValues: function (elem) {\n            if (typeof elem.value === 'function') {\n                this.modal.focus();\n                elem.value(this.applied[elem.name]);\n            } else if (elem.elems) {\n                elem.elems().forEach(this.setPrevValues, this);\n            }\n        },\n\n        /**\n         * Triggers some method in every modal child elem, if this method is defined\n         *\n         * @param {Object} action - action configuration,\n         * must contain actionName and targetName and\n         * can contain params\n         */\n        triggerAction: function (action) {\n            var targetName = action.targetName,\n                params = action.params || [],\n                actionName = action.actionName,\n                target;\n\n            target = registry.async(targetName);\n\n            if (target && typeof target === 'function' && actionName) {\n                params.unshift(actionName);\n                target.apply(target, params);\n            }\n        },\n\n        /**\n         * Override modal buttons callback placeholders with real callbacks\n         */\n        overrideModalButtonCallback: function () {\n            var buttons = this.options.buttons;\n\n            if (buttons && buttons.length) {\n                buttons.forEach(function (button) {\n                    button.click = this.getButtonClickHandler(button.actions);\n                }, this);\n            }\n        },\n\n        /**\n         * Generate button click handler based on button's 'actions' configuration\n         */\n        getButtonClickHandler: function (actionsConfig) {\n            var actions = actionsConfig.map(\n                function (actionConfig) {\n                    if (_.isObject(actionConfig)) {\n                        return this.triggerAction.bind(this, actionConfig);\n                    }\n\n                    return this[actionConfig] ? this[actionConfig].bind(this) : function () {};\n                }, this);\n\n            return function () {\n                actions.forEach(\n                    function (action) {\n                        action();\n                    }\n                );\n            };\n        },\n\n        /**\n         * Cancels changes in modal:\n         * returning elems values to the previous state,\n         * and close modal\n         */\n        actionCancel: function () {\n            this.elems().forEach(this.setPrevValues, this);\n            this.closeModal();\n        },\n\n        /**\n         * Accept changes in modal by not preventing them.\n         * Can be extended by exporting 'gatherValues' result somewhere\n         */\n        actionDone: function () {\n            this.valid = true;\n            this.elems().forEach(this.validate, this);\n\n            if (this.valid) {\n                this.closeModal();\n            }\n        }\n    });\n});\n","Magento_Ui/js/modal/alert.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'Magento_Ui/js/modal/confirm',\n    'mage/translate'\n], function ($, _) {\n    'use strict';\n\n    $.widget('mage.alert', $.mage.confirm, {\n        options: {\n            modalClass: 'confirm',\n            title: $.mage.__('Attention'),\n            actions: {\n\n                /**\n                 * Callback always - called on all actions.\n                 */\n                always: function () {}\n            },\n            buttons: [{\n                text: $.mage.__('OK'),\n                class: 'action-primary action-accept',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.closeModal(true);\n                }\n            }]\n        },\n\n        /**\n         * Create widget.\n         */\n        _create: function () {\n            this.options.actions.always();\n            this._super();\n        },\n\n        /**\n         * Close modal window.\n         */\n        closeModal: function () {\n            this.element.bind('alertclosed', _.bind(this._remove, this));\n\n            return this._super();\n        }\n    });\n\n    return function (config) {\n        return $('<div></div>').html(config.content).alert(config);\n    };\n});\n","Magento_Ui/js/modal/modalToggle.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal'\n], function ($) {\n    'use strict';\n\n    return function (config, el) {\n        var widget,\n            content;\n\n        if (config.contentSelector) {\n            content = $(config.contentSelector);\n        } else if (config.content) {\n            content = $('<div />').html(config.content);\n        } else {\n            content = $('<div />');\n        }\n\n        widget = content.modal(config);\n\n        $(el).on(config.toggleEvent, function () {\n            var state = widget.data('mage-modal').options.isOpen;\n\n            if (state) {\n                widget.modal('closeModal');\n            } else {\n                widget.modal('openModal');\n            }\n\n            return false;\n        });\n\n        return widget;\n    };\n});\n","Magento_Ui/js/modal/prompt.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'text!ui/template/modal/modal-prompt-content.html',\n    'jquery-ui-modules/widget',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, _, template, promptContentTmpl) {\n    'use strict';\n\n    $.widget('mage.prompt', $.mage.modal, {\n        options: {\n            modalClass: 'prompt',\n            promptContentTmpl: promptContentTmpl,\n            promptField: '[data-role=\"promptField\"]',\n            attributesForm: {},\n            attributesField: {},\n            value: '',\n            validation: false,\n            validationRules: [],\n            actions: {\n\n                /**\n                 * Callback always - called on all actions.\n                 */\n                always: function () {},\n\n                /**\n                 * Callback confirm.\n                 */\n                confirm: function () {},\n\n                /**\n                 * Callback cancel.\n                 */\n                cancel: function () {}\n            },\n            buttons: [{\n                text: $.mage.__('Cancel'),\n                class: 'action-secondary action-dismiss',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }, {\n                text: $.mage.__('OK'),\n                class: 'action-primary action-accept',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.closeModal(true);\n                }\n            }]\n        },\n\n        /**\n         * Create widget.\n         */\n        _create: function () {\n            this.options.focus = this.options.promptField;\n            this.options.validation = this.options.validation && this.options.validationRules.length;\n            this._super();\n            this.modal.find(this.options.modalContent).append(this.getFormTemplate());\n            this.modal.find(this.options.modalCloseBtn).off().on('click',  _.bind(this.closeModal, this, false));\n\n            if (this.options.validation) {\n                this.setValidationClasses();\n            }\n\n            this.openModal();\n        },\n\n        /**\n         * Form template getter.\n         *\n         * @returns {Object} Form template.\n         */\n        getFormTemplate: function () {\n            var formTemplate,\n                formAttr = '',\n                inputAttr = '',\n                attributeName;\n\n            for (attributeName in this.options.attributesForm) {\n                if (this.options.attributesForm.hasOwnProperty(attributeName)) {\n                    formAttr = formAttr + ' ' + attributeName + '=\"' +\n                        this.options.attributesForm[attributeName] + '\"';\n                }\n            }\n\n            for (attributeName in this.options.attributesField) {\n                if (this.options.attributesField.hasOwnProperty(attributeName)) {\n                    inputAttr = inputAttr + ' ' + attributeName + '=\"' +\n                        this.options.attributesField[attributeName] + '\"';\n                }\n            }\n\n            formTemplate = $(template(this.options.promptContentTmpl, {\n                data: this.options,\n                formAttr: formAttr,\n                inputAttr: inputAttr\n            }));\n\n            return formTemplate;\n        },\n\n        /**\n         * Remove widget\n         */\n        _remove: function () {\n            this.modal.remove();\n        },\n\n        /**\n         * Validate prompt field\n         */\n        validate: function () {\n            return $.validator.validateSingleElement(this.options.promptField);\n        },\n\n        /**\n         * Add validation classes to prompt field\n         */\n        setValidationClasses: function () {\n            this.modal.find(this.options.promptField).attr('class', $.proxy(function (i, val) {\n                return val + ' ' + this.options.validationRules.join(' ');\n            }, this));\n        },\n\n        /**\n         * Open modal window\n         */\n        openModal: function () {\n            this._super();\n            this.modal.find(this.options.promptField).val(this.options.value);\n        },\n\n        /**\n         * Close modal window\n         */\n        closeModal: function (result) {\n            var value;\n\n            if (result) {\n                if (this.options.validation && !this.validate()) {\n                    return false;\n                }\n\n                value = this.modal.find(this.options.promptField).val();\n                this.options.actions.confirm.call(this, value);\n            } else {\n                this.options.actions.cancel.call(this, result);\n            }\n\n            this.options.actions.always();\n            this.element.bind('promptclosed', _.bind(this._remove, this));\n\n            return this._super();\n        }\n    });\n\n    return function (config) {\n        return $('<div class=\"prompt-message\"></div>').html(config.content).prompt(config);\n    };\n});\n","Magento_Ui/js/modal/confirm.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/translate',\n    'jquery-ui-modules/widget',\n    'Magento_Ui/js/modal/modal'\n], function ($, _, $t) {\n    'use strict';\n\n    $.widget('mage.confirm', $.mage.modal, {\n        options: {\n            modalClass: 'confirm',\n            title: '',\n            focus: '.action-accept',\n            actions: {\n\n                /**\n                 * Callback always - called on all actions.\n                 */\n                always: function () {},\n\n                /**\n                 * Callback confirm.\n                 */\n                confirm: function () {},\n\n                /**\n                 * Callback cancel.\n                 */\n                cancel: function () {}\n            },\n            buttons: [{\n                text: $t('Cancel'),\n                class: 'action-secondary action-dismiss',\n\n                /**\n                 * Click handler.\n                 */\n                click: function (event) {\n                    this.closeModal(event);\n                }\n            }, {\n                text: $t('OK'),\n                class: 'action-primary action-accept',\n\n                /**\n                 * Click handler.\n                 */\n                click: function (event) {\n                    this.closeModal(event, true);\n                }\n            }]\n        },\n\n        /**\n         * Create widget.\n         */\n        _create: function () {\n            this._super();\n            this.modal.find(this.options.modalCloseBtn).off().on('click', _.bind(this.closeModal, this));\n            this.openModal();\n        },\n\n        /**\n         * Remove modal window.\n         */\n        _remove: function () {\n            this.modal.remove();\n        },\n\n        /**\n         * Open modal window.\n         */\n        openModal: function () {\n            return this._super();\n        },\n\n        /**\n         * Close modal window.\n         */\n        closeModal: function (event, result) {\n            result = result || false;\n\n            if (result) {\n                this.options.actions.confirm(event);\n            } else {\n                this.options.actions.cancel(event);\n            }\n            this.options.actions.always(event);\n            this.element.bind('confirmclosed', _.bind(this._remove, this));\n\n            return this._super();\n        }\n    });\n\n    return function (config) {\n        return $('<div></div>').html(config.content).confirm(config);\n    };\n});\n","Magento_Ui/js/modal/modal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'text!ui/template/modal/modal-popup.html',\n    'text!ui/template/modal/modal-slide.html',\n    'text!ui/template/modal/modal-custom.html',\n    'Magento_Ui/js/lib/key-codes',\n    'jquery-ui-modules/widget',\n    'mage/translate'\n], function ($, _, template, popupTpl, slideTpl, customTpl, keyCodes) {\n    'use strict';\n\n    /**\n     * Detect browser transition end event.\n     * @return {String|undefined} - transition event.\n     */\n    var transitionEvent =  (function () {\n        var transition,\n            elementStyle = document.createElement('div').style,\n            transitions = {\n                'transition': 'transitionend',\n                'OTransition': 'oTransitionEnd',\n                'MozTransition': 'transitionend',\n                'WebkitTransition': 'webkitTransitionEnd'\n            };\n\n        for (transition in transitions) {\n            if (elementStyle[transition] !== undefined && transitions.hasOwnProperty(transition)) {\n                return transitions[transition];\n            }\n        }\n    })();\n\n    /**\n     * Modal Window Widget\n     */\n    $.widget('mage.modal', {\n        options: {\n            id: null,\n            type: 'popup',\n            title: '',\n            subTitle: '',\n            modalClass: '',\n            focus: '[data-role=\"closeBtn\"]',\n            autoOpen: false,\n            clickableOverlay: true,\n            popupTpl: popupTpl,\n            slideTpl: slideTpl,\n            customTpl: customTpl,\n            modalVisibleClass: '_show',\n            parentModalClass: '_has-modal',\n            innerScrollClass: '_inner-scroll',\n            responsive: false,\n            innerScroll: false,\n            modalTitle: '[data-role=\"title\"]',\n            modalSubTitle: '[data-role=\"subTitle\"]',\n            modalBlock: '[data-role=\"modal\"]',\n            modalCloseBtn: '[data-role=\"closeBtn\"]',\n            modalContent: '[data-role=\"content\"]',\n            modalAction: '[data-role=\"action\"]',\n            focusableScope: '[data-role=\"focusable-scope\"]',\n            focusableStart: '[data-role=\"focusable-start\"]',\n            focusableEnd: '[data-role=\"focusable-end\"]',\n            appendTo: 'body',\n            wrapperClass: 'modals-wrapper',\n            overlayClass: 'modals-overlay',\n            responsiveClass: 'modal-slide',\n            trigger: '',\n            modalLeftMargin: 45,\n            closeText: $.mage.__('Close'),\n            buttons: [{\n                text: $.mage.__('Ok'),\n                class: '',\n                attr: {},\n\n                /**\n                 * Default action on button click\n                 */\n                click: function (event) {\n                    this.closeModal(event);\n                }\n            }],\n            keyEventHandlers: {\n\n                /**\n                 * Tab key press handler,\n                 * set focus to elements\n                 */\n                tabKey: function () {\n                    if (document.activeElement === this.modal[0]) {\n                        this._setFocus('start');\n                    }\n                },\n\n                /**\n                 * Escape key press handler,\n                 * close modal window\n                 * @param {Object} event - event\n                 */\n                escapeKey: function (event) {\n                    if (this.options.isOpen && this.modal.find(document.activeElement).length ||\n                        this.options.isOpen && this.modal[0] === document.activeElement) {\n                        this.closeModal(event);\n                    }\n                }\n            }\n        },\n\n        /**\n         * Creates modal widget.\n         */\n        _create: function () {\n            _.bindAll(\n                this,\n                'keyEventSwitcher',\n                '_tabSwitcher',\n                'closeModal'\n            );\n\n            this.options.id = this.uuid;\n            this.options.transitionEvent = transitionEvent;\n            this._createWrapper();\n            this._renderModal();\n            this._createButtons();\n            $(this.options.trigger).on('click', _.bind(this.toggleModal, this));\n            this._on(this.modal.find(this.options.modalCloseBtn), {\n                'click': this.options.modalCloseBtnHandler ? this.options.modalCloseBtnHandler : this.closeModal\n            });\n            this._on(this.element, {\n                'openModal': this.openModal,\n                'closeModal': this.closeModal\n            });\n            this.options.autoOpen ? this.openModal() : false;\n        },\n\n        /**\n         * Returns element from modal node.\n         * @return {Object} - element.\n         */\n        _getElem: function (elem) {\n            return this.modal.find(elem);\n        },\n\n        /**\n         * Gets visible modal count.\n         * * @return {Number} - visible modal count.\n         */\n        _getVisibleCount: function () {\n            var modals = this.modalWrapper.find(this.options.modalBlock);\n\n            return modals.filter('.' + this.options.modalVisibleClass).length;\n        },\n\n        /**\n         * Gets count of visible modal by slide type.\n         * * @return {Number} - visible modal count.\n         */\n        _getVisibleSlideCount: function () {\n            var elems = this.modalWrapper.find('[data-type=\"slide\"]');\n\n            return elems.filter('.' + this.options.modalVisibleClass).length;\n        },\n\n        /**\n         * Listener key events.\n         * Call handler function if it exists\n         */\n        keyEventSwitcher: function (event) {\n            var key = keyCodes[event.keyCode];\n\n            if (this.options.keyEventHandlers.hasOwnProperty(key)) {\n                this.options.keyEventHandlers[key].apply(this, arguments);\n            }\n        },\n\n        /**\n         * Set title for modal.\n         *\n         * @param {String} title\n         */\n        setTitle: function (title) {\n            var $title = $(this.options.modalTitle),\n                $subTitle = this.modal.find(this.options.modalSubTitle);\n\n            $title.text(title);\n            $title.append($subTitle);\n        },\n\n        /**\n         * Set sub title for modal.\n         *\n         * @param {String} subTitle\n         */\n        setSubTitle: function (subTitle) {\n            this.options.subTitle = subTitle;\n            this.modal.find(this.options.modalSubTitle).html(subTitle);\n        },\n\n        /**\n         * Toggle modal.\n         * * @return {Element} - current element.\n         */\n        toggleModal: function () {\n            if (this.options.isOpen === true) {\n                this.closeModal();\n            } else {\n                this.openModal();\n            }\n        },\n\n        /**\n         * Open modal.\n         * * @return {Element} - current element.\n         */\n        openModal: function () {\n            this.options.isOpen = true;\n            this.focussedElement = document.activeElement;\n            this._createOverlay();\n            this._setActive();\n            this._setKeyListener();\n            this.modal.one(this.options.transitionEvent, _.bind(this._setFocus, this, 'end', 'opened'));\n            this.modal.one(this.options.transitionEvent, _.bind(this._trigger, this, 'opened'));\n            this.modal.addClass(this.options.modalVisibleClass);\n\n            if (!this.options.transitionEvent) {\n                this._trigger('opened');\n            }\n\n            return this.element;\n        },\n\n        /**\n         * Set focus to element.\n         * @param {String} position - can be \"start\" and \"end\"\n         *      positions.\n         *      If position is \"end\" - sets focus to first\n         *      focusable element in modal window scope.\n         *      If position is \"start\" - sets focus to last\n         *      focusable element in modal window scope\n         *\n         *  @param {String} type - can be \"opened\" or false\n         *      If type is \"opened\" - looks to \"this.options.focus\"\n         *      property and sets focus\n         */\n        _setFocus: function (position, type) {\n            var focusableElements,\n                infelicity;\n\n            if (type === 'opened' && this.options.focus) {\n                this.modal.find($(this.options.focus)).focus();\n            } else if (type === 'opened' && !this.options.focus) {\n                this.modal.find(this.options.focusableScope).focus();\n            } else if (position === 'end') {\n                this.modal.find(this.options.modalCloseBtn).focus();\n            } else if (position === 'start') {\n                infelicity = 2; //Constant for find last focusable element\n                focusableElements = this.modal.find(':focusable');\n                focusableElements.eq(focusableElements.length - infelicity).focus();\n            }\n        },\n\n        /**\n         * Set events listener when modal is opened.\n         */\n        _setKeyListener: function () {\n            this.modal.find(this.options.focusableStart).bind('focusin', this._tabSwitcher);\n            this.modal.find(this.options.focusableEnd).bind('focusin', this._tabSwitcher);\n            this.modal.bind('keydown', this.keyEventSwitcher);\n        },\n\n        /**\n         * Remove events listener when modal is closed.\n         */\n        _removeKeyListener: function () {\n            this.modal.find(this.options.focusableStart).unbind('focusin', this._tabSwitcher);\n            this.modal.find(this.options.focusableEnd).unbind('focusin', this._tabSwitcher);\n            this.modal.unbind('keydown', this.keyEventSwitcher);\n        },\n\n        /**\n         * Switcher for focus event.\n         * @param {Object} e - event\n         */\n        _tabSwitcher: function (e) {\n            var target = $(e.target);\n\n            if (target.is(this.options.focusableStart)) {\n                this._setFocus('start');\n            } else if (target.is(this.options.focusableEnd)) {\n                this._setFocus('end');\n            }\n        },\n\n        /**\n         * Close modal.\n         * * @return {Element} - current element.\n         */\n        closeModal: function () {\n            var that = this;\n\n            this._removeKeyListener();\n            this.options.isOpen = false;\n            this.modal.one(this.options.transitionEvent, function () {\n                that._close();\n            });\n            this.modal.removeClass(this.options.modalVisibleClass);\n\n            if (!this.options.transitionEvent) {\n                that._close();\n            }\n\n            return this.element;\n        },\n\n        /**\n         * Helper for closeModal function.\n         */\n        _close: function () {\n            var trigger = _.bind(this._trigger, this, 'closed', this.modal);\n\n            $(this.focussedElement).focus();\n            this._destroyOverlay();\n            this._unsetActive();\n            _.defer(trigger, this);\n        },\n\n        /**\n         * Set z-index and margin for modal and overlay.\n         */\n        _setActive: function () {\n            var zIndex = this.modal.zIndex(),\n                baseIndex = zIndex + this._getVisibleCount();\n\n            if (this.modal.data('active')) {\n                return;\n            }\n\n            this.modal.data('active', true);\n\n            this.overlay.zIndex(++baseIndex);\n            this.prevOverlayIndex = this.overlay.zIndex();\n            this.modal.zIndex(this.overlay.zIndex() + 1);\n\n            if (this._getVisibleSlideCount()) {\n                this.modal.css('marginLeft', this.options.modalLeftMargin * this._getVisibleSlideCount());\n            }\n        },\n\n        /**\n         * Unset styles for modal and set z-index for previous modal.\n         */\n        _unsetActive: function () {\n            this.modal.removeAttr('style');\n            this.modal.data('active', false);\n\n            if (this.overlay) {\n                this.overlay.zIndex(this.prevOverlayIndex - 1);\n            }\n        },\n\n        /**\n         * Creates wrapper to hold all modals.\n         */\n        _createWrapper: function () {\n            this.modalWrapper = $(this.options.appendTo).find('.' + this.options.wrapperClass);\n\n            if (!this.modalWrapper.length) {\n                this.modalWrapper = $('<div></div>')\n                    .addClass(this.options.wrapperClass)\n                    .appendTo(this.options.appendTo);\n            }\n        },\n\n        /**\n         * Compile template and append to wrapper.\n         */\n        _renderModal: function () {\n            $(template(\n                this.options[this.options.type + 'Tpl'],\n                {\n                    data: this.options\n                })).appendTo(this.modalWrapper);\n            this.modal = this.modalWrapper.find(this.options.modalBlock).last();\n            this.element.appendTo(this._getElem(this.options.modalContent));\n\n            if (this.element.is(':hidden')) {\n                this.element.show();\n            }\n        },\n\n        /**\n         * Creates buttons pane.\n         */\n        _createButtons: function () {\n            this.buttons = this._getElem(this.options.modalAction);\n            _.each(this.options.buttons, function (btn, key) {\n                var button = this.buttons[key];\n\n                if (btn.attr) {\n                    $(button).attr(btn.attr);\n                }\n\n                if (btn.class) {\n                    $(button).addClass(btn.class);\n                }\n\n                if (!btn.click) {\n                    btn.click = this.closeModal;\n                }\n                $(button).on('click', _.bind(btn.click, this));\n            }, this);\n        },\n\n        /**\n         * Creates overlay, append it to wrapper, set previous click event on overlay.\n         */\n        _createOverlay: function () {\n            var events,\n                outerClickHandler = this.options.outerClickHandler || this.closeModal;\n\n            this.overlay = $('.' + this.options.overlayClass);\n\n            if (!this.overlay.length) {\n                $(this.options.appendTo).addClass(this.options.parentModalClass);\n                this.overlay = $('<div></div>')\n                    .addClass(this.options.overlayClass)\n                    .appendTo(this.modalWrapper);\n            }\n            events = $._data(this.overlay.get(0), 'events');\n            events ? this.prevOverlayHandler = events.click[0].handler : false;\n            this.options.clickableOverlay ? this.overlay.unbind().on('click', outerClickHandler) : false;\n        },\n\n        /**\n         * Destroy overlay.\n         */\n        _destroyOverlay: function () {\n            if (this._getVisibleCount()) {\n                this.overlay.unbind().on('click', this.prevOverlayHandler);\n            } else {\n                $(this.options.appendTo).removeClass(this.options.parentModalClass);\n                this.overlay.remove();\n                this.overlay = null;\n            }\n        }\n    });\n\n    return $.mage.modal;\n});\n","Magento_Ui/js/grid/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'rjsResolver',\n    'uiLayout',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate',\n    'uiElement'\n], function ($, _, utils, resolver, layout, alert, $t, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            firstLoad: true,\n            lastError: false,\n            storageConfig: {\n                component: 'Magento_Ui/js/grid/data-storage',\n                provider: '${ $.storageConfig.name }',\n                name: '${ $.name }_storage',\n                updateUrl: '${ $.update_url }'\n            },\n            listens: {\n                params: 'onParamsChange',\n                requestConfig: 'updateRequestConfig'\n            },\n            ignoreTmpls: {\n                data: true\n            }\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initialize: function () {\n            utils.limit(this, 'onParamsChange', 5);\n            _.bindAll(this, 'onReload');\n\n            this._super()\n                .initStorage()\n                .clearData();\n\n            // Load data when there will\n            // be no more pending assets.\n            resolver(this.reload, this);\n\n            return this;\n        },\n\n        /**\n         * Initializes storage component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initStorage: function () {\n            layout([this.storageConfig]);\n\n            return this;\n        },\n\n        /**\n         * Clears provider's data properties.\n         *\n         * @returns {Provider} Chainable.\n         */\n        clearData: function () {\n            this.setData({\n                items: [],\n                totalRecords: 0\n            });\n\n            return this;\n        },\n\n        /**\n         * Overrides current data with a provided one.\n         *\n         * @param {Object} data - New data object.\n         * @returns {Provider} Chainable.\n         */\n        setData: function (data) {\n            data = this.processData(data);\n\n            this.set('data', data);\n\n            return this;\n        },\n\n        /**\n         * Processes data before applying it.\n         *\n         * @param {Object} data - Data to be processed.\n         * @returns {Object}\n         */\n        processData: function (data) {\n            var items = data.items;\n\n            _.each(items, function (record, index) {\n                record._rowIndex = index;\n            });\n\n            return data;\n        },\n\n        /**\n         * Reloads data with current parameters.\n         *\n         * @returns {Promise} Reload promise object.\n         */\n        reload: function (options) {\n            var request = this.storage().getData(this.params, options);\n\n            this.trigger('reload');\n\n            request\n                .done(this.onReload)\n                .fail(this.onError.bind(this));\n\n            return request;\n        },\n\n        /**\n         * Handles changes of 'params' object.\n         */\n        onParamsChange: function () {\n            // It's necessary to make a reload only\n            // after the initial loading has been made.\n            if (!this.firstLoad) {\n                this.reload();\n            }\n        },\n\n        /**\n         * Handles reload error.\n         */\n        onError: function (xhr) {\n            if (xhr.statusText === 'abort') {\n                return;\n            }\n\n            this.set('lastError', true);\n\n            this.firstLoad = false;\n\n            alert({\n                content: $t('Something went wrong.')\n            });\n        },\n\n        /**\n         * Handles successful data reload.\n         *\n         * @param {Object} data - Retrieved data object.\n         */\n        onReload: function (data) {\n            this.firstLoad = false;\n\n            this.set('lastError', false);\n\n            this.setData(data)\n                .trigger('reloaded');\n        },\n\n        /**\n         * Updates storage's request configuration\n         *\n         * @param {Object} requestConfig\n         */\n        updateRequestConfig: function (requestConfig) {\n            if (this.storage()) {\n                _.extend(this.storage().requestConfig, requestConfig);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/resize.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'Magento_Ui/js/lib/knockout/extender/bound-nodes',\n    'uiElement'\n], function ($, ko, _, utils, registry, boundedNodes, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            rootSelector: '${ $.columnsProvider }:.admin__data-grid-wrap',\n            tableSelector: '${ $.rootSelector } -> table.data-grid',\n            mainTableSelector: '[data-role=\"grid\"]',\n            columnSelector: '${ $.tableSelector } thead tr th',\n            fieldSelector: '${ $.tableSelector } tbody tr td',\n\n            imports: {\n                storageColumnsData: '${ $.storageConfig.path }.storageColumnsData'\n            },\n            storageColumnsData: {},\n            columnsElements: {},\n            tableWidth: 0,\n            sumColumnsWidth: 0,\n            showLines: 4,\n            resizableElementClass: 'shadow-div',\n            resizingColumnClass: '_resizing',\n            fixedLayoutClass: '_layout-fixed',\n            inResizeClass: '_in-resize',\n            visibleClass: '_resize-visible',\n            cellContentElement: 'div.data-grid-cell-content',\n            minColumnWidth: 40,\n            layoutFixedPolyfillIterator: 0,\n            windowResize: false,\n            resizable: false,\n            resizeConfig: {\n                maxRowsHeight: [],\n                curResizeElem: {},\n                depResizeElem: {},\n                previousWidth: null\n            }\n        },\n\n        /**\n         * Initialize application -\n         * binding functions context,\n         * set handlers for table elements\n         *\n         * @returns {Object} Chainable\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'initTable',\n                'initColumn',\n                'mousedownHandler',\n                'mousemoveHandler',\n                'mouseupHandler',\n                'refreshLastColumn',\n                'refreshMaxRowHeight',\n                'preprocessingWidth',\n                '_eventProxy',\n                'checkAfterResize'\n            );\n\n            this._super();\n            this.observe(['maxRowsHeight']);\n            this.maxRowsHeight([]);\n\n            $.async(this.tableSelector, this.initTable);\n            $.async(this.columnSelector, this.initColumn);\n\n            return this;\n        },\n\n        /**\n         * Set table element and adds handler to mousedown on headers\n         *\n         * @returns {Object} Chainable\n         */\n        initTable: function (table) {\n            if ($(table).is(this.mainTableSelector)) {\n                this.table = table;\n                this.tableWidth = $(table).outerWidth();\n                $(window).resize(this.checkAfterResize);\n            }\n\n            //TODO - Must be deleted when Firefox fixed problem with table-layout: fixed\n            //ticket to Firefox: https://bugs.webkit.org/show_bug.cgi?id=90068\n            if (navigator.userAgent.search(/Firefox/) > -1) {\n                this._layoutFixedPolyfill();\n            }\n\n            $(table).addClass(this.fixedLayoutClass);\n\n            return this;\n        },\n\n        /**\n         * Window resize handler,\n         * check changes on table width and\n         * set new width to variable\n         * after window resize start preprocessingWidth method\n         */\n        checkAfterResize: function () {\n            var tableWidth,\n                self = this;\n\n            setTimeout(function () {\n                tableWidth = $(self.table).outerWidth();\n\n                if (self.tableWidth !== tableWidth) {\n                    self.tableWidth = tableWidth;\n                } else {\n                    self.preprocessingWidth();\n                }\n            }, 300);\n        },\n\n        /**\n         * Check conditions to set minimal width\n         */\n        checkSumColumnsWidth: function () {\n            var table = $(this.table),\n                elems = table.find('th:not([style*=\"width: auto\"]):visible'),\n                elemsWidthMin = table.find('th[style*=\"width: ' + (this.minColumnWidth - 1) + 'px\"]:visible'),\n                elemsWidthAuto = table.find('th[style*=\"width: auto\"]:visible'),\n                model;\n\n            this.sumColumnsWidth = 0;\n            _.each(elems, function (elem) {\n                model = ko.dataFor(elem);\n                model.width && model.width !== 'auto' ? this.sumColumnsWidth += model.width : false;\n            }, this);\n\n            if (\n                    this.sumColumnsWidth + elemsWidthAuto.length *\n                    this.minColumnWidth + elemsWidthMin.length *\n                    this.minColumnWidth > this.tableWidth\n            ) {\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Set minimal width to element with \"auto\" width\n         */\n        setWidthToColumnsWidthAuto: function () {\n            var elemsWidthAuto = $(this.table).find('th[style*=\"width: auto\"]:visible');\n\n            _.each(elemsWidthAuto, function (elem) {\n                $(elem).outerWidth(this.minColumnWidth - 1);\n            }, this);\n        },\n\n        /**\n         * Check conditions to set auto width\n         */\n        hasMinimal: function () {\n            var table = $(this.table),\n                elemsWidthMin = table.find('th[style*=\"width: ' + (this.minColumnWidth - 1) + 'px\"]:visible'),\n                elemsWidthAuto = table.find('th[style*=\"width: auto\"]:visible');\n\n            if (\n                    elemsWidthAuto && this.sumColumnsWidth + elemsWidthAuto.length *\n                    this.minColumnWidth + elemsWidthMin.length * this.minColumnWidth + 5 < this.tableWidth\n            ) {\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Set \"auto\" width to element with minimal width\n         */\n        setAuto: function () {\n            var elemsWidthAuto = $(this.table).find('th[style*=\"width: ' + (this.minColumnWidth - 1) + 'px\"]:visible');\n\n            _.each(elemsWidthAuto, function (elem) {\n                $(elem).outerWidth('auto');\n            }, this);\n        },\n\n        /**\n         * Check columns width and preprocessing\n         */\n        preprocessingWidth: function () {\n            if (this.checkSumColumnsWidth()) {\n                this.setWidthToColumnsWidthAuto();\n            } else if (this.hasMinimal()) {\n                this.setAuto();\n            }\n        },\n\n        /**\n         * Init columns elements,\n         * set width to current column element,\n         * add resizable element to columns header,\n         * check and add no-resize class to last column,\n         * stop parents events,\n         * add handler to visibility column\n         *\n         * @param {Object} column - columns header element (th)\n         */\n        initColumn: function (column) {\n            var model = ko.dataFor(column),\n                ctxIndex = this.getCtxIndex(ko.contextFor(column));\n\n            model.width = this.getDefaultWidth(column);\n\n            if (!this.hasColumn(model, ctxIndex, false)) {\n                this.columnsElements[model.index] = this.columnsElements[model.index] || {};\n                this.columnsElements[model.index][ctxIndex] = column;\n                this.initResizableElement(column);\n                this.setStopPropagationHandler(column);\n                $(column).outerWidth(model.width);\n            }\n\n            this.refreshLastColumn(column);\n            this.preprocessingWidth();\n\n            model.on('visible', this.refreshLastColumn.bind(this, column));\n            model.on('visible', this.preprocessingWidth.bind(this));\n        },\n\n        /**\n         * Hack for mozilla firefox\n         */\n        _layoutFixedPolyfill: function () {\n            var self = this;\n\n            setTimeout(function () {\n                if (self.layoutFixedPolyfillIterator < 20) {\n                    $(window).resize();\n                    self.layoutFixedPolyfillIterator++;\n                    self._layoutFixedPolyfill();\n                } else {\n                    return false;\n                }\n            }, 500);\n        },\n\n        /**\n         * Check element is resizable or not\n         * and append resizable element to DOM\n         *\n         * @param {Object} column - columns header element (th)\n         * @returns {Boolean}\n         */\n        initResizableElement: function (column) {\n            var model = ko.dataFor(column),\n                templateDragElement = '<div class=\"' + this.resizableElementClass + '\"></div>';\n\n            if (_.isUndefined(model.resizeEnabled) || model.resizeEnabled) {\n                $(column).append(templateDragElement);\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Check event target and if need stop parents event,\n         *\n         * @param {Object} column - columns header element (th)\n         * @returns {Boolean}\n         */\n        setStopPropagationHandler: function (column) {\n            var events,\n                click,\n                mousedown;\n\n            $(column).on('click', this._eventProxy);\n            $(column).on('mousedown', this._eventProxy);\n\n            events = $._data(column, 'events');\n\n            click = events.click;\n            mousedown = events.mousedown;\n            click.unshift(click.pop());\n            mousedown.unshift(mousedown.pop());\n\n            return this;\n        },\n\n        /**\n         * Check event target and stop event if need\n         *\n         * @param {Object} event\n         */\n        _eventProxy: function (event) {\n            if ($(event.target).is('.' + this.resizableElementClass)) {\n\n                if (event.type === 'click') {\n                    event.stopImmediatePropagation();\n                } else if (event.type === 'mousedown') {\n                    this.mousedownHandler(event);\n                }\n            }\n        },\n\n        /**\n         * Check visible columns and set disable class to resizable elements,\n         *\n         * @param {Object} column - columns header element (th)\n         */\n        refreshLastColumn: function (column) {\n            var i = 0,\n                columns = $(column).parent().children().not(':hidden'),\n                length = columns.length;\n\n            $('.' + this.visibleClass).removeClass(this.visibleClass);\n\n            $(column).parent().children().not(':hidden').last().addClass(this.visibleClass);\n\n            for (i; i < length; i++) {\n\n                if (!columns.eq(i).find('.' + this.resizableElementClass).length && i) {\n                    columns.eq(i - 1).addClass(this.visibleClass);\n                }\n            }\n\n        },\n\n        /**\n         * Refresh max height to row elements,\n         *\n         * @param {Object} elem - (td)\n         */\n        refreshMaxRowHeight: function (elem) {\n            var rowsH = this.maxRowsHeight(),\n                curEL = $(elem).find('div'),\n                height,\n                obj = this.hasRow($(elem).parent()[0], true);\n\n            curEL.css('white-space', 'nowrap');\n            height = curEL.height() * this.showLines;\n            curEL.css('white-space', 'normal');\n\n            if (obj) {\n                if (obj.maxHeight < height) {\n                    rowsH[_.indexOf(rowsH, obj)].maxHeight = height;\n                } else {\n                    return false;\n                }\n            } else {\n                rowsH.push({\n                    elem: $(elem).parent()[0],\n                    maxHeight: height\n                });\n            }\n\n            $(elem).parent().children().find(this.cellContentElement).css('max-height', height + 'px');\n            this.maxRowsHeight(rowsH);\n        },\n\n        /**\n         * Set resize class to elements when resizable\n         */\n        _setResizeClass: function () {\n            var rowElements = $(this.table).find('tr');\n\n            rowElements\n                .find('td:eq(' + this.resizeConfig.curResizeElem.ctx.$index() + ')')\n                .addClass(this.resizingColumnClass);\n            rowElements\n                .find('td:eq(' + this.resizeConfig.depResizeElem.ctx.$index() + ')')\n                .addClass(this.resizingColumnClass);\n        },\n\n        /**\n         * Remove resize class to elements when resizable\n         */\n        _removeResizeClass: function () {\n            var rowElements = $(this.table).find('tr');\n\n            rowElements\n                .find('td:eq(' + this.resizeConfig.curResizeElem.ctx.$index() + ')')\n                .removeClass(this.resizingColumnClass);\n            rowElements\n                .find('td:eq(' + this.resizeConfig.depResizeElem.ctx.$index() + ')')\n                .removeClass(this.resizingColumnClass);\n        },\n\n        /**\n         * Check conditions to resize\n         *\n         * @returns {Boolean}\n         */\n        _canResize: function (column) {\n            if (\n                $(column).hasClass(this.visibleClass) ||\n                !$(this.resizeConfig.depResizeElem.elems[0]).find('.' + this.resizableElementClass).length\n            ) {\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Mouse down event handler,\n         * find current and dep column to resize\n         *\n         * @param {Object} event\n         */\n        mousedownHandler: function (event) {\n            var target = event.target,\n                column = $(target).parent()[0],\n                cfg = this.resizeConfig,\n                body = $('body');\n\n            event.stopImmediatePropagation();\n            cfg.curResizeElem.model = ko.dataFor(column);\n            cfg.curResizeElem.ctx = ko.contextFor(column);\n            cfg.curResizeElem.elems = this.hasColumn(cfg.curResizeElem.model, false, true);\n            cfg.curResizeElem.position = event.pageX;\n            cfg.depResizeElem.elems = this.getNextElements(cfg.curResizeElem.elems[0]);\n            cfg.depResizeElem.model = ko.dataFor(cfg.depResizeElem.elems[0]);\n            cfg.depResizeElem.ctx = ko.contextFor(cfg.depResizeElem.elems[0]);\n\n            this._setResizeClass();\n\n            if (!this._canResize(column)) {\n                return false;\n            }\n\n            event.stopPropagation();\n            this.resizable = true;\n            cfg.curResizeElem.model.width = $(cfg.curResizeElem.elems[0]).outerWidth();\n            cfg.depResizeElem.model.width = $(cfg.depResizeElem.elems[0]).outerWidth();\n            body.addClass(this.inResizeClass);\n            body.bind('mousemove', this.mousemoveHandler);\n            $(window).bind('mouseup', this.mouseupHandler);\n        },\n\n        /**\n         * Mouse move event handler,\n         * change columns width\n         *\n         * @param {Object} event\n         */\n        mousemoveHandler: function (event) {\n            var cfg = this.resizeConfig,\n                width = event.pageX - cfg.curResizeElem.position,\n                self = this;\n\n            event.stopPropagation();\n            event.preventDefault();\n\n            if (\n                this.resizable &&\n                this.minColumnWidth < cfg.curResizeElem.model.width + width &&\n                this.minColumnWidth < cfg.depResizeElem.model.width - width &&\n                cfg.previousWidth !== width\n            ) {\n                cfg.curResizeElem.model.width += width;\n                cfg.depResizeElem.model.width -= width;\n\n                cfg.curResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(cfg.curResizeElem.model.width);\n                });\n                cfg.depResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(cfg.depResizeElem.model.width);\n                });\n\n                cfg.previousWidth = width;\n                cfg.curResizeElem.position = event.pageX;\n            } else if (width <= -(cfg.curResizeElem.model.width - this.minColumnWidth)) {\n\n                cfg.curResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(self.minColumnWidth);\n                });\n                cfg.depResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(\n                    cfg.depResizeElem.model.width +\n                    cfg.curResizeElem.model.width -\n                    self.minColumnWidth);\n                });\n\n            } else if (width >= cfg.depResizeElem.model.width - this.minColumnWidth) {\n\n                cfg.depResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(self.minColumnWidth);\n                });\n                cfg.curResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(\n                        cfg.curResizeElem.model.width +\n                        cfg.depResizeElem.model.width -\n                        self.minColumnWidth\n                    );\n                });\n            }\n        },\n\n        /**\n         * Mouse up event handler,\n         * change columns width\n         *\n         * @param {Object} event\n         */\n        mouseupHandler: function (event) {\n            var cfg = this.resizeConfig,\n                body = $('body');\n\n            event.stopPropagation();\n            event.preventDefault();\n\n            this._removeResizeClass();\n            this.storageColumnsData[cfg.curResizeElem.model.index] = cfg.curResizeElem.model.width;\n            this.storageColumnsData[cfg.depResizeElem.model.index] = cfg.depResizeElem.model.width;\n            this.resizable = false;\n\n            this.store('storageColumnsData');\n\n            body.removeClass(this.inResizeClass);\n            body.unbind('mousemove', this.mousemoveHandler);\n            $(window).unbind('mouseup', this.mouseupHandler);\n        },\n\n        /**\n         * Find dependency element\n         *\n         * @param {Object} element - current element\n         * @returns {Object} next element data\n         */\n        getNextElements: function (element) {\n            var nextElem = $(element).next()[0],\n                nextElemModel = ko.dataFor(nextElem),\n                nextElemData = this.hasColumn(nextElemModel, false, true);\n\n            if (nextElemData) {\n                if (nextElemModel.visible) {\n                    return nextElemData;\n                }\n\n                return this.getNextElements(nextElem);\n            }\n        },\n\n        /**\n         * Get default width\n         *\n         * @param {Object} column - (th) element\n         * @return {String} width for current column\n         */\n        getDefaultWidth: function (column) {\n            var model = ko.dataFor(column);\n\n            if (this.storageColumnsData[model.index]) {\n                return this.storageColumnsData[model.index];\n            }\n\n            if (model.resizeDefaultWidth) {\n                return parseInt(model.resizeDefaultWidth, 10);\n            }\n\n            return 'auto';\n        },\n\n        /**\n         * Check column is render or not\n         *\n         * @param {Object} model - cur column model\n         * @param {String|Boolean} ctxIndex - index of context, or false, if want to get cols from all ctx\n         * @param {Boolean} returned - need return column object or not\n         * @return {Boolean} if returned param is false, returned boolean value, else return current object data\n         */\n        hasColumn: function (model, ctxIndex, returned) {\n            var colElem = this.columnsElements[model.index] || {},\n                getFromAllCtx = ctxIndex === false;\n\n            if (colElem && (getFromAllCtx || colElem.hasOwnProperty(ctxIndex))) {\n\n                if (returned) {\n                    return getFromAllCtx ?\n                        _.values(colElem) :\n                        colElem[ctxIndex];\n                }\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Check row is render or not\n         *\n         * @param {Object} elem - cur column element\n         * @param {Boolean} returned - need return column object or not\n         * @return {Boolean|Object} if returned param is false, returned boolean value, else return current object data\n         */\n        hasRow: function (elem, returned) {\n            var i = 0,\n                el = this.maxRowsHeight(),\n                length = el.length;\n\n            for (i; i < length; i++) {\n                if (this.maxRowsHeight()[i].elem === elem) {\n                    if (returned) {//eslint-disable-line max-depth\n                        return this.maxRowsHeight()[i];\n                    }\n\n                    return true;\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * Generate index that will identify context\n         *\n         * @param {Object} ctx\n         * @return {String}\n         */\n        getCtxIndex: function (ctx) {\n            return ctx ? ctx.$parents.reduce(function (pv, cv) {\n                return (pv.index || pv) + (cv || {}).index;\n            }) : ctx;\n        }\n    });\n});\n","Magento_Ui/js/grid/massactions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'Magento_Ui/js/lib/collapsible',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate'\n], function (_, registry, utils, Collapsible, confirm, alert, $t) {\n    'use strict';\n\n    return Collapsible.extend({\n        defaults: {\n            template: 'ui/grid/actions',\n            stickyTmpl: 'ui/grid/sticky/actions',\n            selectProvider: 'ns = ${ $.ns }, index = ids',\n            actions: [],\n            noItemsMsg: $t('You haven\\'t selected any items!'),\n            modules: {\n                selections: '${ $.selectProvider }'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Massactions} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('actions');\n\n            return this;\n        },\n\n        /**\n         * Applies specified action.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @returns {Massactions} Chainable.\n         */\n        applyAction: function (actionIndex) {\n            var data = this.getSelections(),\n                action,\n                callback;\n\n            if (!data.total) {\n                alert({\n                    content: this.noItemsMsg\n                });\n\n                return this;\n            }\n\n            action   = this.getAction(actionIndex);\n            callback = this._getCallback(action, data);\n\n            action.confirm ?\n                this._confirm(action, callback) :\n                callback();\n\n            return this;\n        },\n\n        /**\n         * Retrieves selections data from the selections provider.\n         *\n         * @returns {Object|Undefined}\n         */\n        getSelections: function () {\n            var provider = this.selections(),\n                selections = provider && provider.getSelections();\n\n            return selections;\n        },\n\n        /**\n         * Retrieves action object associated with a specified index.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @returns {Object} Action object.\n         */\n        getAction: function (actionIndex) {\n            return _.findWhere(this.actions(), {\n                type: actionIndex\n            });\n        },\n\n        /**\n         * Adds new action. If action with a specified identifier\n         * already exists, than the original one will be overrided.\n         *\n         * @param {Object} action - Action object.\n         * @returns {Massactions} Chainable.\n         */\n        addAction: function (action) {\n            var actions = this.actions(),\n                index = _.findIndex(actions, {\n                    type: action.type\n                });\n\n            ~index ?\n                actions[index] = action :\n                actions.push(action);\n\n            this.actions(actions);\n\n            return this;\n        },\n\n        /**\n         * Creates action callback based on its' data. If action doesn't spicify\n         * a callback function than the default one will be used.\n         *\n         * @private\n         * @param {Object} action - Actions' object.\n         * @param {Object} selections - Selections data.\n         * @returns {Function} Callback function.\n         */\n        _getCallback: function (action, selections) {\n            var callback = action.callback,\n                args     = [action, selections];\n\n            if (utils.isObject(callback)) {\n                args.unshift(callback.target);\n\n                callback = registry.async(callback.provider);\n            } else if (typeof callback != 'function') {\n                callback = this.defaultCallback.bind(this);\n            }\n\n            return function () {\n                callback.apply(null, args);\n            };\n        },\n\n        /**\n         * Default action callback. Sends selections data\n         * via POST request.\n         *\n         * @param {Object} action - Action data.\n         * @param {Object} data - Selections data.\n         */\n        defaultCallback: function (action, data) {\n            var itemsType = data.excludeMode ? 'excluded' : 'selected',\n                selections = {};\n\n            selections[itemsType] = data[itemsType];\n\n            if (!selections[itemsType].length) {\n                selections[itemsType] = false;\n            }\n\n            _.extend(selections, data.params || {});\n\n            utils.submit({\n                url: action.url,\n                data: selections\n            });\n        },\n\n        /**\n         * Shows actions' confirmation window.\n         *\n         * @param {Object} action - Actions' data.\n         * @param {Function} callback - Callback that will be\n         *      invoked if action is confirmed.\n         */\n        _confirm: function (action, callback) {\n            var confirmData = action.confirm,\n                data = this.getSelections(),\n                total = data.total ? data.total : 0,\n                confirmMessage = confirmData.message + ' (' + total + ' record' + (total > 1 ? 's' : '') + ')';\n\n            confirm({\n                title: confirmData.title,\n                content: confirmMessage,\n                actions: {\n                    confirm: callback\n                }\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/tree-massactions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/massactions'\n], function (ko, _, Massactions) {\n    'use strict';\n\n    return Massactions.extend({\n        defaults: {\n            template: 'ui/grid/tree-massactions',\n            submenuTemplate: 'ui/grid/submenu',\n            listens: {\n                opened: 'hideSubmenus'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Massactions} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .recursiveObserveActions(this.actions());\n\n            return this;\n        },\n\n        /**\n         * Recursive initializes observable actions.\n         *\n         * @param {Array} actions - Action objects.\n         * @param {String} [prefix] - An optional string that will be prepended\n         *      to the \"type\" field of all child actions.\n         * @returns {Massactions} Chainable.\n         */\n        recursiveObserveActions: function (actions, prefix) {\n            _.each(actions, function (action) {\n                if (prefix) {\n                    action.type = prefix + '.' + action.type;\n                }\n\n                if (action.actions) {\n                    action.visible = ko.observable(false);\n                    action.parent = actions;\n                    this.recursiveObserveActions(action.actions, action.type);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Applies specified action.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @returns {Massactions} Chainable.\n         */\n        applyAction: function (actionIndex) {\n            var action = this.getAction(actionIndex),\n                visibility;\n\n            if (action.visible) {\n                visibility = action.visible();\n\n                this.hideSubmenus(action.parent);\n                action.visible(!visibility);\n\n                return this;\n            }\n\n            return this._super(actionIndex);\n        },\n\n        /**\n         * Retrieves action object associated with a specified index.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @param {Array} actions - Action objects.\n         * @returns {Object} Action object.\n         */\n        getAction: function (actionIndex, actions) {\n            var currentActions = actions || this.actions(),\n                result = false;\n\n            _.find(currentActions, function (action) {\n                if (action.type === actionIndex) {\n                    result = action;\n\n                    return true;\n                }\n\n                if (action.actions) {\n                    result = this.getAction(actionIndex, action.actions);\n\n                    return result;\n                }\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Recursive hide all sub folders in given array.\n         *\n         * @param {Array} actions - Action objects.\n         * @returns {Massactions} Chainable.\n         */\n        hideSubmenus: function (actions) {\n            var currentActions = actions || this.actions();\n\n            _.each(currentActions, function (action) {\n                if (action.visible && action.visible()) {\n                    action.visible(false);\n                }\n\n                if (action.actions) {\n                    this.hideSubmenus(action.actions);\n                }\n            }, this);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/export.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'uiElement'\n], function ($, _, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/exportButton',\n            selectProvider: 'ns = ${ $.ns }, index = ids',\n            checked: '',\n            additionalParams: [],\n            modules: {\n                selections: '${ $.selectProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super()\n                .initChecked();\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            this._super();\n\n            _.each(this.additionalParams, function (value, key) {\n                key = 'additionalParams.' + key;\n                this.imports[key] = value;\n            }, this);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('checked');\n\n            return this;\n        },\n\n        /**\n         * Checks first option if checked not defined.\n         *\n         * @returns {Object}\n         */\n        initChecked: function () {\n            if (!this.checked()) {\n                this.checked(\n                    this.options[0].value\n                );\n            }\n\n            return this;\n        },\n\n        /**\n         * Compose params object that will be added to request.\n         *\n         * @returns {Object}\n         */\n        getParams: function () {\n            var selections = this.selections(),\n                data = selections ? selections.getSelections() : null,\n                itemsType,\n                result = {};\n\n            if (data) {\n                itemsType = data.excludeMode ? 'excluded' : 'selected';\n                result.filters = data.params.filters;\n                result.search = data.params.search;\n                result.namespace = data.params.namespace;\n                result[itemsType] = data[itemsType];\n                _.each(this.additionalParams, function (param, key) {\n                    result[key] = param;\n                });\n\n                if (!result[itemsType].length) {\n                    result[itemsType] = false;\n                }\n            }\n\n            return result;\n        },\n\n        /**\n         * Find checked option.\n         *\n         * @returns {Object}\n         */\n        getActiveOption: function () {\n            return _.findWhere(this.options, {\n                value: this.checked()\n            });\n        },\n\n        /**\n         * Build option url.\n         *\n         * @param {Object} option\n         * @returns {String}\n         */\n        buildOptionUrl: function (option) {\n            var params = this.getParams();\n\n            if (!params) {\n                return 'javascript:void(0);';\n            }\n\n            return option.url + '?' + $.param(params);\n            //TODO: MAGETWO-40250\n        },\n\n        /**\n         * Redirect to built option url.\n         */\n        applyOption: function () {\n            var option = this.getActiveOption(),\n                url = this.buildOptionUrl(option);\n\n            location.href = url;\n\n        }\n    });\n});\n","Magento_Ui/js/grid/toolbar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/async',\n    'Magento_Ui/js/lib/view/utils/raf',\n    'rjsResolver',\n    'uiCollection'\n], function (_, $, raf, resolver, Collection) {\n    'use strict';\n\n    var transformProp;\n\n    /**\n     * Defines supported css 'transform' property.\n     *\n     * @returns {String|Undefined}\n     */\n    transformProp = (function () {\n        var style = document.documentElement.style,\n            base = 'Transform',\n            vendors = ['webkit', 'moz', 'ms', 'o'],\n            vi = vendors.length,\n            property;\n\n        if (typeof style.transform != 'undefined') {\n            return 'transform';\n        }\n\n        while (vi--) {\n            property = vendors[vi] + base;\n\n            if (typeof style[property] != 'undefined') {\n                return property;\n            }\n        }\n    })();\n\n    /**\n     * Moves specified DOM element to the x and y coordinates.\n     *\n     * @param {HTMLElement} elem - Element to be relocated.\n     * @param {Number} x - X coordinate.\n     * @param {Number} y - Y coordinate.\n     */\n    function locate(elem, x, y) {\n        var value = 'translate(' + x + 'px,' + y + 'px)';\n\n        elem.style[transformProp] = value;\n    }\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/toolbar',\n            stickyTmpl: 'ui/grid/sticky/sticky',\n            tableSelector: 'table',\n            columnsProvider: 'ns = ${ $.ns }, componentType = columns',\n            refreshFPS: 15,\n            sticky: false,\n            visible: false,\n            _resized: true,\n            _scrolled: true,\n            _tableScrolled: true,\n            _requiredNodes: {\n                '$stickyToolbar': true,\n                '$stickyTable': true,\n                '$table': true,\n                '$sticky': true\n            },\n            stickyClass: {\n                'sticky-header': true\n            }\n        },\n\n        /**\n         * Initializes sticky toolbar component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super();\n\n            if (this.sticky) {\n                this.waitDOMElements()\n                    .then(this.run.bind(this));\n            }\n\n            return this;\n        },\n\n        /**\n         * Establishes DOM elements wait process.\n         *\n         * @returns {jQueryPromise} Promise which will be resolved\n         *      when all of the required DOM elements are defined.\n         */\n        waitDOMElements: function () {\n            var _domPromise = $.Deferred();\n\n            _.bindAll(this, 'setStickyTable', 'setTableNode');\n\n            $.async({\n                ctx: ':not([data-role=\"sticky-el-root\"])',\n                component: this.columnsProvider,\n                selector: this.tableSelector\n            }, this.setTableNode);\n\n            $.async({\n                ctx: '[data-role=\"sticky-el-root\"]',\n                component: this.columnsProvider,\n                selector: this.tableSelector\n            }, this.setStickyTable);\n\n            this._domPromise = _domPromise;\n\n            return _domPromise.promise();\n        },\n\n        /**\n         * Defines left caption element.\n         *\n         * @param {HTMLElement} node\n         */\n        setLeftCap: function (node) {\n            this.$leftCap = node;\n        },\n\n        /**\n         * Defines right caption element.\n         *\n         * @param {HTMLElement} node\n         */\n        setRightCap: function (node) {\n            this.$rightCap = node;\n        },\n\n        /**\n         * Defines original table element.\n         *\n         * @param {HTMLTableElement} node\n         */\n        setTableNode: function (node) {\n            this.$cols = node.tHead.children[0].cells;\n            this.$tableContainer = node.parentNode;\n\n            this.setNode('$table', node);\n        },\n\n        /**\n         * Defines sticky table element.\n         *\n         * @param {HTMLTableElement} node\n         */\n        setStickyTable: function (node) {\n            this.$stickyCols = node.tHead.children[0].cells;\n\n            this.setNode('$stickyTable', node);\n        },\n\n        /**\n         * Defines sticky toolbar node.\n         *\n         * @param {HTMLElement} node\n         */\n        setStickyToolbarNode: function (node) {\n            this.setNode('$stickyToolbar', node);\n        },\n\n        /**\n         * Defines sticky element container.\n         *\n         * @param {HTMLElement} node\n         */\n        setStickyNode: function (node) {\n            this.setNode('$sticky', node);\n        },\n\n        /**\n         * Defines toolbar element container.\n         *\n         * @param {HTMLElement} node\n         */\n        setToolbarNode: function (node) {\n            this.$toolbar = node;\n        },\n\n        /**\n         * Sets provided node as a value of 'key' property and\n         * performs check for required DOM elements.\n         *\n         * @param {String} key - Properties key.\n         * @param {HTMLElement} node - DOM element.\n         */\n        setNode: function (key, node) {\n            var nodes = this._requiredNodes,\n                promise = this._domPromise,\n                defined;\n\n            this[key] = node;\n\n            defined = _.every(nodes, function (enabled, name) {\n                return enabled ? this[name] : true;\n            }, this);\n\n            if (defined) {\n                resolver(promise.resolve, promise);\n            }\n        },\n\n        /**\n         * Starts refresh process of the sticky element\n         * and assigns DOM elements events handlers.\n         */\n        run: function () {\n            _.bindAll(\n                this,\n                'refresh',\n                '_onWindowResize',\n                '_onWindowScroll',\n                '_onTableScroll'\n            );\n\n            $(window).on({\n                scroll: this._onWindowScroll,\n                resize: this._onWindowResize\n            });\n\n            $(this.$tableContainer).on('scroll', this._onTableScroll);\n\n            this.refresh();\n            this.checkTableWidth();\n        },\n\n        /**\n         * Refreshes state of the sticky element and\n         * invokes DOM elements events handlers\n         * if corresponding event has been triggered.\n         */\n        refresh: function () {\n            if (!raf(this.refresh, this.refreshFPS)) {\n                return;\n            }\n\n            if (this._scrolled) {\n                this.onWindowScroll();\n            }\n\n            if (this._tableScrolled) {\n                this.onTableScroll();\n            }\n\n            if (this._resized) {\n                this.onWindowResize();\n            }\n\n            if (this.visible) {\n                this.checkTableWidth();\n            }\n        },\n\n        /**\n         * Shows sticky toolbar.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        show: function () {\n            this.visible = true;\n            //Check admin grid button has addedr not\n            if ($('.page-main-actions').length === 0) {\n                this.$sticky.style.top = 0;\n            }\n            this.$sticky.style.display = '';\n            this.$toolbar.style.visibility = 'hidden';\n\n            return this;\n        },\n\n        /**\n         * Hides sticky toolbar.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        hide: function () {\n            this.visible = false;\n\n            this.$sticky.style.display = 'none';\n            this.$toolbar.style.visibility = '';\n\n            return this;\n        },\n\n        /**\n         * Checks if sticky toolbar covers original elements.\n         *\n         * @returns {Boolean}\n         */\n        isCovered: function () {\n            var stickyTop = this._stickyTableTop + this._wScrollTop;\n\n            return stickyTop > this._tableTop;\n        },\n\n        /**\n         * Updates offset of the sticky table element.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateStickyTableOffset: function () {\n            var style,\n                top;\n\n            if (this.visible) {\n                top = this.$stickyTable.getBoundingClientRect().top;\n            } else {\n                style = this.$sticky.style;\n\n                style.visibility = 'hidden';\n                style.display = '';\n\n                top = this.$stickyTable.getBoundingClientRect().top;\n\n                style.display = 'none';\n                style.visibility = '';\n            }\n\n            this._stickyTableTop = top;\n\n            return this;\n        },\n\n        /**\n         * Updates offset of the original table element.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateTableOffset: function () {\n            var box = this.$table.getBoundingClientRect(),\n                top = box.top + this._wScrollTop;\n\n            if (this._tableTop !== top) {\n                this._tableTop = top;\n\n                this.onTableTopChange(top);\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks if width of the table or it's columns has changed.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        checkTableWidth: function () {\n            var cols        = this.$cols,\n                total       = cols.length,\n                rightBorder = cols[total - 2].offsetLeft,\n                tableWidth  = this.$table.offsetWidth;\n\n            if (this._tableWidth !== tableWidth) {\n                this._tableWidth = tableWidth;\n\n                this.onTableWidthChange(tableWidth);\n            }\n\n            if (this._rightBorder !== rightBorder) {\n                this._rightBorder = rightBorder;\n\n                this.onColumnsWidthChange();\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates width of the sticky table.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateTableWidth: function () {\n            this.$stickyTable.style.width = this._tableWidth + 'px';\n\n            if (this._tableWidth < this._toolbarWidth) {\n                this.checkToolbarSize();\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates width of the sticky columns.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateColumnsWidth: function () {\n            var cols        = this.$cols,\n                index       = cols.length,\n                stickyCols  = this.$stickyCols;\n\n            while (index--) {\n                stickyCols[index].width = cols[index].offsetWidth;\n            }\n\n            return this;\n        },\n\n        /**\n         * Upadates size of the sticky toolbar element\n         * and invokes corresponding 'change' event handlers.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        checkToolbarSize: function () {\n            var width = this.$tableContainer.offsetWidth;\n\n            if (this._toolbarWidth !== width) {\n                this._toolbarWidth = width;\n\n                this.onToolbarWidthChange(width);\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggles sticky toolbar visibility if it's necessary.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateVisibility: function () {\n            if (this.visible !== this.isCovered()) {\n                this.visible ? this.hide() : this.show();\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates position of the left cover area.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateLeftCap: function () {\n            locate(this.$leftCap, -this._wScrollLeft, 0);\n\n            return this;\n        },\n\n        /**\n         * Updates position of the right cover area.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateRightCap: function () {\n            var left = this._toolbarWidth - this._wScrollLeft;\n\n            locate(this.$rightCap, left, 0);\n\n            return this;\n        },\n\n        /**\n         * Updates position of the sticky table.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateTableScroll: function () {\n            var container = this.$tableContainer,\n                left = container.scrollLeft + this._wScrollLeft;\n\n            locate(this.$stickyTable, -left, 0);\n\n            return this;\n        },\n\n        /**\n         * Updates width of the toolbar element.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateToolbarWidth: function () {\n            this.$stickyToolbar.style.width = this._toolbarWidth + 'px';\n\n            return this;\n        },\n\n        /**\n         * Handles changes of the toolbar element's width.\n         */\n        onToolbarWidthChange: function () {\n            this.updateToolbarWidth()\n                .updateRightCap();\n        },\n\n        /**\n         * Handles changes of the table top position.\n         */\n        onTableTopChange: function () {\n            this.updateStickyTableOffset();\n        },\n\n        /**\n         * Handles change of the table width.\n         */\n        onTableWidthChange: function () {\n            this.updateTableWidth();\n        },\n\n        /**\n         * Handles change of the table columns width.\n         */\n        onColumnsWidthChange: function () {\n            this.updateColumnsWidth();\n        },\n\n        /**\n         * Handles changes of the window's size.\n         */\n        onWindowResize: function () {\n            this.checkToolbarSize();\n\n            this._resized = false;\n        },\n\n        /**\n         * Handles changes of the original table scroll position.\n         */\n        onTableScroll: function () {\n            this.updateTableScroll();\n\n            this._tableScrolled = false;\n        },\n\n        /**\n         * Handles changes of window's scroll position.\n         */\n        onWindowScroll: function () {\n            var scrollTop = window.pageYOffset,\n                scrollLeft = window.pageXOffset;\n\n            if (this._wScrollTop !== scrollTop) {\n                this._wScrollTop = scrollTop;\n\n                this.onWindowScrollTop(scrollTop);\n            }\n\n            if (this._wScrollLeft !== scrollLeft) {\n                this._wScrollLeft = scrollLeft;\n\n                this.onWindowScrollLeft(scrollLeft);\n            }\n\n            this._scrolled = false;\n        },\n\n        /**\n         * Handles changes of windows' top scroll position.\n         */\n        onWindowScrollTop: function () {\n            this.updateTableOffset()\n                .updateVisibility();\n        },\n\n        /**\n         * Handles changes of windows' left scroll position.\n         */\n        onWindowScrollLeft: function () {\n            this.updateRightCap()\n                .updateLeftCap()\n                .updateTableScroll();\n        },\n\n        /**\n         * Original window 'scroll' event handler.\n         * Sets 'scrolled' flag to 'true'.\n         *\n         * @private\n         */\n        _onWindowScroll: function () {\n            this._scrolled = true;\n        },\n\n        /**\n         * Original window 'resize' event handler.\n         * Sets 'resized' flag to 'true'.\n         *\n         * @private\n         */\n        _onWindowResize: function () {\n            this._resized = true;\n        },\n\n        /**\n         * Original table 'scroll' event handler.\n         * Sets '_tableScrolled' flag to 'true'.\n         *\n         * @private\n         */\n        _onTableScroll: function () {\n            this._tableScrolled = true;\n        }\n    });\n});\n","Magento_Ui/js/grid/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/lib/spinner',\n    'rjsResolver',\n    'uiLayout',\n    'uiCollection'\n], function (ko, _, loader, resolver, layout, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/listing',\n            listTemplate: 'ui/list/listing',\n            stickyTmpl: 'ui/grid/sticky/listing',\n            viewSwitcherTmpl: 'ui/grid/view-switcher',\n            positions: false,\n            displayMode: 'grid',\n            displayModes: {\n                grid: {\n                    value: 'grid',\n                    label: 'Grid',\n                    template: '${ $.template }'\n                },\n                list: {\n                    value: 'list',\n                    label: 'List',\n                    template: '${ $.listTemplate }'\n                }\n            },\n            dndConfig: {\n                name: '${ $.name }_dnd',\n                component: 'Magento_Ui/js/grid/dnd',\n                columnsProvider: '${ $.name }',\n                enabled: true\n            },\n            editorConfig: {\n                name: '${ $.name }_editor',\n                component: 'Magento_Ui/js/grid/editing/editor',\n                columnsProvider: '${ $.name }',\n                dataProvider: '${ $.provider }',\n                enabled: false\n            },\n            resizeConfig: {\n                name: '${ $.name }_resize',\n                columnsProvider: '${ $.name }',\n                component: 'Magento_Ui/js/grid/resize',\n                enabled: false\n            },\n            imports: {\n                rows: '${ $.provider }:data.items'\n            },\n            listens: {\n                elems: 'updatePositions updateVisible',\n                '${ $.provider }:reload': 'onBeforeReload',\n                '${ $.provider }:reloaded': 'onDataReloaded'\n            },\n            modules: {\n                dnd: '${ $.dndConfig.name }',\n                resize: '${ $.resizeConfig.name }'\n            },\n            tracks: {\n                displayMode: true\n            },\n            statefull: {\n                displayMode: true\n            }\n        },\n\n        /**\n         * Initializes Listing component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'updateVisible');\n\n            this._super()\n                .initDnd()\n                .initEditor()\n                .initResize();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    rows: [],\n                    visibleColumns: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Creates drag&drop widget instance.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initDnd: function () {\n            if (this.dndConfig.enabled) {\n                layout([this.dndConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes resize component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initResize: function () {\n            if (this.resizeConfig.enabled) {\n                layout([this.resizeConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates inline editing component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initEditor: function () {\n            if (this.editorConfig.enabled) {\n                layout([this.editorConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Called when another element was added to current component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initElement: function (element) {\n            var currentCount = this.elems().length,\n                totalCount = this.initChildCount;\n\n            if (totalCount === currentCount) {\n                this.initPositions();\n            }\n\n            element.on('visible', this.updateVisible);\n\n            return this._super();\n        },\n\n        /**\n         * Defines initial order of child elements.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initPositions: function () {\n            this.on('positions', this.applyPositions.bind(this));\n\n            this.setStatefull('positions');\n\n            return this;\n        },\n\n        /**\n         * Updates current state of child positions.\n         *\n         * @returns {Listing} Chainable.\n         */\n        updatePositions: function () {\n            var positions = {};\n\n            this.elems.each(function (elem, index) {\n                positions[elem.index] = index;\n            });\n\n            this.set('positions', positions);\n\n            return this;\n        },\n\n        /**\n         * Resorts child elements array according to provided positions.\n         *\n         * @param {Object} positions - Object where key represents child\n         *      index and value is its' position.\n         * @returns {Listing} Chainable.\n         */\n        applyPositions: function (positions) {\n            var sorting;\n\n            sorting = this.elems.map(function (elem) {\n                return {\n                    elem: elem,\n                    position: positions[elem.index]\n                };\n            });\n\n            this.insertChild(sorting);\n\n            return this;\n        },\n\n        /**\n         * Returns reference to 'visibleColumns' array.\n         *\n         * @returns {Array}\n         */\n        getVisible: function () {\n            var observable = ko.getObservable(this, 'visibleColumns');\n\n            return observable || this.visibleColumns;\n        },\n\n        /**\n         * Returns path to the template\n         * defined for a current display mode.\n         *\n         * @returns {String} Path to the template.\n         */\n        getTemplate: function () {\n            var mode = this.displayModes[this.displayMode];\n\n            return mode.template;\n        },\n\n        /**\n         * Returns an array of available display modes.\n         *\n         * @returns {Array<Object>}\n         */\n        getDisplayModes: function () {\n            var modes = this.displayModes;\n\n            return _.values(modes);\n        },\n\n        /**\n         * Sets display mode to provided value.\n         *\n         * @param {String} index\n         * @returns {Listing} Chainable\n         */\n        setDisplayMode: function (index) {\n            this.displayMode = index;\n\n            return this;\n        },\n\n        /**\n         * Returns total number of displayed columns in grid.\n         *\n         * @returns {Number}\n         */\n        countVisible: function () {\n            return this.visibleColumns.length;\n        },\n\n        /**\n         * Updates array of visible columns.\n         *\n         * @returns {Listing} Chainable.\n         */\n        updateVisible: function () {\n            this.visibleColumns = this.elems.filter('visible');\n\n            return this;\n        },\n\n        /**\n         * Checks if grid has data.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return !!this.rows && !!this.rows.length;\n        },\n\n        /**\n         * Hides loader.\n         */\n        hideLoader: function () {\n            loader.get(this.name).hide();\n        },\n\n        /**\n         * Shows loader.\n         */\n        showLoader: function () {\n            loader.get(this.name).show();\n        },\n\n        /**\n         * Handler of the data providers' 'reload' event.\n         */\n        onBeforeReload: function () {\n            this.showLoader();\n        },\n\n        /**\n         * Handler of the data providers' 'reloaded' event.\n         */\n        onDataReloaded: function () {\n            resolver(this.hideLoader, this);\n        }\n    });\n});\n","Magento_Ui/js/grid/dnd.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'uiRegistry',\n    'uiClass'\n], function (ko, $, _, registry, Class) {\n    'use strict';\n\n    var isTouchDevice = typeof document.ontouchstart !== 'undefined',\n        transformProp;\n\n    /**\n     * Defines supported css 'transform' property.\n     *\n     * @returns {String|Undefined}\n     */\n    transformProp = (function () {\n        var style = document.body.style,\n            base = 'Transform',\n            vendors = ['webkit', 'moz', 'ms', 'o'],\n            vi = vendors.length,\n            property;\n\n        if (typeof style.transform != 'undefined') {\n            return 'transform';\n        }\n\n        while (vi--) {\n            property = vendors[vi] + base;\n\n            if (typeof style[property] != 'undefined') {\n                return property;\n            }\n        }\n    })();\n\n    /**\n     * Returns first touch data if it's available.\n     *\n     * @param {(MouseEvent|TouchEvent)} e - Event object.\n     * @returns {Object}\n     */\n    function getTouch(e) {\n        return e.touches ? e.touches[0] : e;\n    }\n\n    /**\n     * Moves specified DOM element to the x and y coordinates.\n     *\n     * @param {HTMLElement} elem - Element to be relocated.\n     * @param {Number} x - X coordinate.\n     * @param {Number} y - Y coordinate.\n     */\n    function locate(elem, x, y) {\n        var value = 'translate(' + x + 'px,' + y + 'px)';\n\n        elem.style[transformProp] = value;\n    }\n\n    /*eslint-disable no-extra-parens*/\n    /**\n     * Checks if specified coordinate is inside of the provided area.\n     *\n     * @param {Number} x - X coordinate.\n     * @param {Number} y - Y coordinate.\n     * @param {Object} area - Object which represents area.\n     * @returns {Boolean}\n     */\n    function isInside(x, y, area) {\n        return (\n            area &&\n            x >= area.left && x <= area.right &&\n            y >= area.top && y <= area.bottom\n        );\n    }\n\n    /*eslint-enable no-extra-parens*/\n\n    /**\n     * Calculates distance between two points.\n     *\n     * @param {Number} x1 - X coordinate of a first point.\n     * @param {Number} y1 - Y coordinate of a first point.\n     * @param {Number} x2 - X coordinate of a second point.\n     * @param {Number} y2 - Y coordinate of a second point.\n     * @returns {Number} Distance between points.\n     */\n    function distance(x1, y1, x2, y2) {\n        var dx = x2 - x1,\n            dy = y2 - y1;\n\n        dx *= dx;\n        dy *= dy;\n\n        return Math.sqrt(dx + dy);\n    }\n\n    /**\n     * Returns viewModel associated with a provided DOM element.\n     *\n     * @param {HTMLElement} elem\n     * @returns {Object|Array}\n     */\n    function getModel(elem) {\n        return ko.dataFor(elem);\n    }\n\n    /**\n     * Checks whether cols are identical\n     *\n     * @param {HTMLElement} c1\n     * @param {HTMLElement} c2\n     * @returns {Boolean}\n     */\n    function compareCols(c1, c2) {\n        return c1.cellIndex === c2.cellIndex;\n    }\n\n    return Class.extend({\n        defaults: {\n            rootSelector: '${ $.columnsProvider }:.admin__data-grid-wrap',\n            tableSelector: '${ $.rootSelector } -> table.data-grid',\n            mainTableSelector: '[data-role=\"grid\"]',\n            columnSelector: '${ $.tableSelector } thead tr th',\n            noSelectClass: '_no-select',\n            hiddenClass: '_hidden',\n            fixedX: false,\n            fixedY: true,\n            minDistance: 2,\n            columns: []\n        },\n\n        /**\n         * Initializes Dnd component.\n         *\n         * @returns {Dnd} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'initTable',\n                'initColumn',\n                'removeColumn',\n                'onMouseMove',\n                'onMouseUp',\n                'onMouseDown'\n            );\n\n            this.$body = $('body');\n\n            this._super()\n                .initListeners();\n\n            $.async(this.tableSelector, this.initTable);\n            $.async(this.columnSelector, this.initColumn);\n\n            return this;\n        },\n\n        /**\n         * Binds necessary events listeners.\n         *\n         * @returns {Dnd} Chainbale.\n         */\n        initListeners: function () {\n            if (isTouchDevice) {\n                $(document).on({\n                    touchmove: this.onMouseMove,\n                    touchend: this.onMouseUp,\n                    touchleave: this.onMouseUp\n                });\n            } else {\n                $(document).on({\n                    mousemove: this.onMouseMove,\n                    mouseup: this.onMouseUp\n                });\n            }\n\n            return this;\n        },\n\n        /**\n         * Defines specified table element as a main container.\n         *\n         * @param {HTMLTableElement} table\n         * @returns {Dnd} Chainable.\n         */\n        initTable: function (table) {\n            this.table =  $(table).is(this.mainTableSelector) ?  table : this.table;\n\n            $(table).addClass('data-grid-draggable');\n\n            return this;\n        },\n\n        /**\n         * Sets specified column as a draggable element.\n         *\n         * @param {HTMLTableHeaderCellElement} column - Columns header element.\n         * @returns {Dnd} Chainable.\n         */\n        initColumn: function (column) {\n            var model = getModel(column),\n                eventName;\n\n            if (!model || !model.draggable) {\n                return this;\n            }\n\n            if (!ko.es5.isTracked(model, 'dragover')) {\n                model.track('dragover');\n            }\n\n            this.columns.push(column);\n\n            $(column).bindings({\n                css: {\n                    '_dragover-left': ko.computed(function () {\n                        return model.dragover === 'right';\n                    }),\n                    '_dragover-right': ko.computed(function () {\n                        return model.dragover === 'left';\n                    })\n                }\n            });\n\n            eventName = isTouchDevice ?\n                'touchstart' :\n                'mousedown';\n\n            $(column).on(eventName, this.onMouseDown);\n            $.async.remove(column, this.removeColumn);\n\n            return this;\n        },\n\n        /**\n         * Removes specified column element from the columns array.\n         *\n         * @param {HTMLTableHeaderCellElement} column - Columns header element.\n         * @returns {Dnd} Chainable.\n         */\n        removeColumn: function (column) {\n            var columns = this.columns,\n                index = columns.indexOf(column);\n\n            if (~index) {\n                columns.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Returns index of column.\n         *\n         * @param {HTMLTableHeaderCellElement} elem\n         * @returns {Number}\n         */\n        _getColumnIndex: function (elem) {\n            return _.toArray(elem.parentNode.cells).indexOf(elem);\n        },\n\n        /**\n         * Calculates coordinates of draggable elements.\n         *\n         * @returns {Dnd} Chainbale.\n         */\n        _cacheCoords: function () {\n            var container   = this.table.getBoundingClientRect(),\n                bodyRect    = document.body.getBoundingClientRect(),\n                grabbed     = this.grabbed,\n                dragElem    = grabbed.elem,\n                cells       = _.toArray(dragElem.parentNode.cells),\n                rect;\n\n            this.coords = this.columns.map(function (column) {\n                var data,\n                    colIndex = _.findIndex(cells, function (cell) {\n                        return compareCols(cell, column);\n                    });\n\n                rect = column.getBoundingClientRect();\n\n                data = {\n                    index: colIndex,\n                    target: column,\n                    orig: rect,\n                    left: rect.left - bodyRect.left,\n                    right: rect.right - bodyRect.left,\n                    top: rect.top - bodyRect.top,\n                    bottom: container.bottom - bodyRect.top\n                };\n\n                if (column === dragElem) {\n                    this.dragArea = data;\n\n                    grabbed.shiftX = rect.left - grabbed.x;\n                    grabbed.shiftY = rect.top - grabbed.y;\n                }\n\n                return data;\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Creates clone of a target table with only specified column visible.\n         *\n         * @param {HTMLTableHeaderCellElement} elem - Dragging column.\n         * @returns {Dnd} Chainbale.\n         */\n        _cloneTable: function (elem) {\n            var clone       = this.table.cloneNode(true),\n                columnIndex = this._getColumnIndex(elem),\n                headRow     = clone.tHead.firstElementChild,\n                headCells   = _.toArray(headRow.cells),\n                tableBody   = clone.tBodies[0],\n                bodyRows    = _.toArray(tableBody.children),\n                origTrs     = this.table.tBodies[0].children;\n\n            clone.style.width = elem.offsetWidth + 'px';\n\n            headCells.forEach(function (th, index) {\n                if (index !== columnIndex) {\n                    headRow.removeChild(th);\n                }\n            });\n\n            headRow.cells[0].style.height = elem.offsetHeight + 'px';\n\n            bodyRows.forEach(function (row, rowIndex) {\n                var cells = row.cells,\n                    cell;\n\n                if (cells.length !== headCells.length) {\n                    tableBody.removeChild(row);\n\n                    return;\n                }\n\n                cell = row.cells[columnIndex].cloneNode(true);\n\n                while (row.firstElementChild) {\n                    row.removeChild(row.firstElementChild);\n                }\n\n                cell.style.height = origTrs[rowIndex].cells[columnIndex].offsetHeight + 'px';\n\n                row.appendChild(cell);\n            });\n\n            this.dragTable = clone;\n\n            $(clone)\n                .addClass('_dragging-copy')\n                .appendTo('body');\n\n            return this;\n        },\n\n        /**\n         * Matches provided coordinates to available areas.\n         *\n         * @param {Number} x - X coordinate of a mouse pointer.\n         * @param {Number} y - Y coordinate of a mouse pointer.\n         * @returns {Object|Undefined} Matched area.\n         */\n        _getDropArea: function (x, y) {\n            return _.find(this.coords, function (area) {\n                return isInside(x, y, area);\n            });\n        },\n\n        /**\n         * Updates state of hovered areas.\n         *\n         * @param {Number} x - X coordinate of a mouse pointer.\n         * @param {Number} y - Y coordinate of a mouse pointer.\n         */\n        _updateAreas: function (x, y) {\n            var leavedArea = this.dropArea,\n                area = this.dropArea = this._getDropArea(x, y);\n\n            if (leavedArea) {\n                this.dragleave(leavedArea);\n            }\n\n            if (area && !compareCols(area.target, this.dragArea.target)) {\n                this.dragenter(area);\n            }\n        },\n\n        /**\n         * Grab action handler.\n         *\n         * @param {Number} x - X coordinate of a grabbed point.\n         * @param {Number} y - Y coordinate of a grabbed point.\n         * @param {HTMLElement} elem - Grabbed element.\n         */\n        grab: function (x, y, elem) {\n            this.initDrag = true;\n\n            this.grabbed = {\n                x: x,\n                y: y,\n                elem: elem\n            };\n\n            this.$body.addClass(this.noSelectClass);\n        },\n\n        /**\n         * Dragstart action handler.\n         *\n         * @param {HTMLTableHeaderCellElement} elem - Element which is dragging.\n         */\n        dragstart: function (elem) {\n            this.initDrag = false;\n            this.dropArea = false;\n            this.dragging = true;\n\n            getModel(elem).dragging(true);\n\n            this._cacheCoords()\n                ._cloneTable(elem);\n        },\n\n        /**\n         * Drag action handler. Locates draggable\n         * grid at a specified coordinates.\n         *\n         * @param {Number} x - X coordinate.\n         * @param {Number} y - Y coordinate.\n         */\n        drag: function (x, y) {\n            var grabbed  = this.grabbed,\n                dragArea = this.dragArea,\n                posX     = x + grabbed.shiftX,\n                posY     = y + grabbed.shiftY;\n\n            if (this.fixedX) {\n                x    = dragArea.left;\n                posX = dragArea.orig.left;\n            }\n\n            if (this.fixedY) {\n                y    = dragArea.top;\n                posY = dragArea.orig.top;\n            }\n\n            locate(this.dragTable, posX, posY);\n\n            if (!isInside(x, y, this.dropArea)) {\n                this._updateAreas(x, y);\n            }\n        },\n\n        /**\n         * Dragenter action handler.\n         *\n         * @param {Object} dropArea\n         */\n        dragenter: function (dropArea) {\n            var direction = this.dragArea.index < dropArea.index ?\n                'left' :\n                'right';\n\n            getModel(dropArea.target).dragover = direction;\n        },\n\n        /**\n         * Dragleave action handler.\n         *\n         * @param {Object} dropArea\n         */\n        dragleave: function (dropArea) {\n            getModel(dropArea.target).dragover = false;\n        },\n\n        /**\n         * Dragend action handler.\n         *\n         * @param {Object} dragArea\n         */\n        dragend: function (dragArea) {\n            var dropArea = this.dropArea,\n                dragElem = dragArea.target;\n\n            this.dragging = false;\n\n            document.body.removeChild(this.dragTable);\n\n            getModel(dragElem).dragging(false);\n\n            if (dropArea && !compareCols(dropArea.target, dragElem)) {\n                this.drop(dropArea, dragArea);\n            }\n        },\n\n        /**\n         * Drop action handler.\n         *\n         * @param {Object} dropArea\n         * @param {Object} dragArea\n         */\n        drop: function (dropArea, dragArea) {\n            var dropModel = getModel(dropArea.target),\n                dragModel = getModel(dragArea.target);\n\n            getModel(this.table).insertChild(dragModel, dropModel);\n            dropModel.dragover = false;\n        },\n\n        /**\n         * Documents' 'mousemove' event handler.\n         *\n         * @param {(MouseEvent|TouchEvent)} e - Event object.\n         */\n        onMouseMove: function (e) {\n            var grab    = this.grabbed,\n                touch   = getTouch(e),\n                x       = touch.pageX,\n                y       = touch.pageY;\n\n            if (this.initDrag || this.dragging) {\n                e.preventDefault();\n            }\n\n            if (this.initDrag && distance(x, y, grab.x, grab.y) >= this.minDistance) {\n                this.dragstart(grab.elem);\n            }\n\n            if (this.dragging) {\n                this.drag(x, y);\n            }\n        },\n\n        /**\n         * Documents' 'mouseup' event handler.\n         */\n        onMouseUp: function () {\n            if (this.initDrag || this.dragging) {\n                this.initDrag = false;\n                this.$body.removeClass(this.noSelectClass);\n            }\n\n            if (this.dragging) {\n                this.dragend(this.dragArea);\n            }\n        },\n\n        /**\n         * Columns' 'mousedown' event handler.\n         *\n         * @param {(MouseEvent|TouchEvent)} e - Event object.\n         */\n        onMouseDown: function (e) {\n            var touch = getTouch(e);\n\n            this.grab(touch.pageX, touch.pageY, e.currentTarget);\n        }\n    });\n});\n","Magento_Ui/js/grid/data-storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'uiClass'\n], function ($, _, utils, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            cacheRequests: true,\n            cachedRequestDelay: 50,\n            indexField: 'entity_id',\n            requestConfig: {\n                url: '${ $.updateUrl }',\n                method: 'GET',\n                dataType: 'json'\n            },\n            dataScope: '',\n            data: {}\n        },\n\n        /**\n         * Initializes dataStorage configuration.\n         *\n         * @returns {DataStorage} Chainable.\n         */\n        initConfig: function () {\n            var scope;\n\n            this._super();\n\n            scope = this.dataScope;\n\n            if (typeof scope === 'string') {\n                this.dataScope = scope ? [scope] : [];\n            }\n\n            this._requests = [];\n\n            return this;\n        },\n\n        /**\n         * Extracts data which matches specified set of identifiers.\n         *\n         * @param {Array} ids - Records identifiers.\n         * @returns {Array|Boolean}\n         */\n        getByIds: function (ids) {\n            var result = [],\n                hasData;\n\n            hasData = ids.every(function (id) {\n                var item = this.data[id];\n\n                return item ? result.push(item) : false;\n            }, this);\n\n            return hasData ? result : false;\n        },\n\n        /**\n         * Extracts identifiers of provided records.\n         * If no records were provided then full list of\n         * current data id's will be returned.\n         *\n         * @param {Object|Array} [data=this.data]\n         * @returns {Array}\n         */\n        getIds: function (data) {\n            data = data || this.data;\n\n            return _.pluck(data, this.indexField);\n        },\n\n        /**\n         * Extracts data which matches specified parameters.\n         *\n         * @param {Object} params - Request parameters.\n         * @param {Object} [options={}]\n         * @returns {jQueryPromise}\n         */\n        getData: function (params, options) {\n            var cachedRequest;\n\n            if (this.hasScopeChanged(params)) {\n                this.clearRequests();\n            } else {\n                cachedRequest = this.getRequest(params);\n            }\n\n            options = options || {};\n\n            return !options.refresh && cachedRequest ?\n                this.getRequestData(cachedRequest) :\n                this.requestData(params);\n        },\n\n        /**\n         * Tells whether one of the parameters defined in the \"dataScope\" has\n         * changed since the last request.\n         *\n         * @param {Object} params - Request parameters.\n         * @returns {Boolean}\n         */\n        hasScopeChanged: function (params) {\n            var lastRequest = _.last(this._requests),\n                keys,\n                diff;\n\n            if (!lastRequest) {\n                return false;\n            }\n\n            diff = utils.compare(lastRequest.params, params);\n\n            keys = _.pluck(diff.changes, 'path');\n            keys = keys.concat(Object.keys(diff.containers));\n\n            return _.intersection(this.dataScope, keys).length > 0;\n        },\n\n        /**\n         * Extends records of current data object\n         * with the provided records collection.\n         *\n         * @param {Array} data - An array of records.\n         * @returns {DataStorage} Chainable.\n         */\n        updateData: function (data) {\n            var records = _.indexBy(data || [], this.indexField);\n\n            _.extend(this.data, records);\n\n            return this;\n        },\n\n        /**\n         * Sends request to the server with provided parameters.\n         *\n         * @param {Object} params - Request parameters.\n         * @returns {jQueryPromise}\n         */\n        requestData: function (params) {\n            var query = utils.copy(params),\n                handler = this.onRequestComplete.bind(this, query),\n                request;\n\n            this.requestConfig.data = query;\n            request = $.ajax(this.requestConfig).done(handler);\n\n            return request;\n        },\n\n        /**\n         * Returns request's instance which\n         * contains provided parameters.\n         *\n         * @param {Object} params - Request parameters.\n         * @returns {Object} Instance of request.\n         */\n        getRequest: function (params) {\n            return _.find(this._requests, function (request) {\n                return _.isEqual(params, request.params);\n            }, this);\n        },\n\n        /**\n         * Forms data object associated with provided request.\n         *\n         * @param {Object} request - Request object.\n         * @returns {jQueryPromise}\n         */\n        getRequestData: function (request) {\n            var defer = $.Deferred(),\n                resolve = defer.resolve.bind(defer),\n                delay = this.cachedRequestDelay,\n                result;\n\n            result = {\n                items: this.getByIds(request.ids),\n                totalRecords: request.totalRecords\n            };\n\n            delay ?\n                _.delay(resolve, delay, result) :\n                resolve(result);\n\n            return defer.promise();\n        },\n\n        /**\n         * Caches requests object with provided parameters\n         * and data object associated with it.\n         *\n         * @param {Object} data - Data associated with request.\n         * @param {Object} params - Request parameters.\n         * @returns {DataStorage} Chainable.\n         */\n        cacheRequest: function (data, params) {\n            var cached = this.getRequest(params);\n\n            if (cached) {\n                this.removeRequest(cached);\n            }\n\n            this._requests.push({\n                ids: this.getIds(data.items),\n                params: params,\n                totalRecords: data.totalRecords\n            });\n\n            return this;\n        },\n\n        /**\n         * Clears all cached requests.\n         *\n         * @returns {DataStorage} Chainable.\n         */\n        clearRequests: function () {\n            this._requests.splice(0);\n\n            return this;\n        },\n\n        /**\n         * Removes provided request object from cached requests list.\n         *\n         * @param {Object} request - Request object.\n         * @returns {DataStorage} Chainable.\n         */\n        removeRequest: function (request) {\n            var requests = this._requests,\n                index = requests.indexOf(request);\n\n            if (~index) {\n                requests.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks if request with a specified parameters was cached.\n         *\n         * @param {Object} params - Parameters of the request.\n         * @returns {Boolean}\n         */\n        wasRequested: function (params) {\n            return !!this.getRequest(params);\n        },\n\n        /**\n         * Handles successful data request.\n         *\n         * @param {Object} params - Request parameters.\n         * @param {Object} data - Response data.\n         */\n        onRequestComplete: function (params, data) {\n            this.updateData(data.items);\n\n            if (this.cacheRequests) {\n                this.cacheRequest(data, params);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/search/search.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiLayout',\n    'mage/translate',\n    'mageUtils',\n    'uiElement',\n    'jquery'\n], function (_, layout, $t, utils, Element, $) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/search/search',\n            placeholder: 'Search by keyword',\n            label: $t('Keyword'),\n            value: '',\n            previews: [],\n            chipsProvider: 'componentType = filtersChips, ns = ${ $.ns }',\n            statefull: {\n                value: true\n            },\n            tracks: {\n                value: true,\n                previews: true,\n                inputValue: true,\n                focused: true\n            },\n            imports: {\n                inputValue: 'value',\n                updatePreview: 'value',\n                focused: false\n            },\n            exports: {\n                value: '${ $.provider }:params.search'\n            },\n            modules: {\n                chips: '${ $.chipsProvider }'\n            }\n        },\n\n        /**\n         * Initializes search component.\n         *\n         * @returns {Search} Chainable.\n         */\n        initialize: function () {\n            var urlParams = window.location.href.slice(window.location.href.search('[\\&\\?](search=)')).split('&'),\n                searchTerm = [];\n\n            this._super()\n                .initChips();\n\n            if (urlParams[0]) {\n                searchTerm = urlParams[0].split('=');\n\n                if (searchTerm[1]) {\n                    this.apply(decodeURIComponent(searchTerm[1]));\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes chips component.\n         *\n         * @returns {Search} Chainbale.\n         */\n        initChips: function () {\n            this.chips('insertChild', this, 0);\n\n            return this;\n        },\n\n        /**\n         * Clears search.\n         *\n         * @returns {Search} Chainable.\n         */\n        clear: function () {\n            this.value = '';\n\n            return this;\n        },\n\n        /**\n         * Click To ScrollTop.\n         */\n        scrollTo: function ($data) {\n            $('html, body').animate({\n                scrollTop: 0\n            }, 'slow', function () {\n                $data.focused = false;\n                $data.focused = true;\n            });\n        },\n\n        /**\n         * Resets input value to the last applied state.\n         *\n         * @returns {Search} Chainable.\n         */\n        cancel: function () {\n            this.inputValue = this.value;\n\n            return this;\n        },\n\n        /**\n         * Applies search query.\n         *\n         * @param {String} [value=inputValue] - If not specified, then\n         *      value of the input field will be used.\n         * @returns {Search} Chainable.\n         */\n        apply: function (value) {\n            value = value || this.inputValue;\n\n            this.value = this.inputValue = value.trim();\n\n            return this;\n        },\n\n        /**\n         * Updates preview data.\n         *\n         * @returns {Search} Chainable.\n         */\n        updatePreview: function () {\n            var preview = [];\n\n            if (this.value) {\n                preview.push({\n                    elem: this,\n                    label: this.label,\n                    preview: this.value\n                });\n            }\n\n            this.previews = preview;\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/sticky/sticky.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'uiComponent',\n    'Magento_Ui/js/lib/view/utils/raf'\n], function ($, _, Component, raf) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            listingSelector: '${ $.listingProvider }::not([data-role = \"sticky-el-root\"])',\n            toolbarSelector: '${ $.toolbarProvider }::not([data-role = \"sticky-el-root\"])',\n            bulkRowSelector: '[data-role = \"data-grid-bulk-row\"]',\n            bulkRowHeaderSelector: '.data-grid-info-panel:visible',\n            tableSelector: 'table',\n            columnSelector: 'thead tr th',\n            rowSelector: 'tbody tr',\n            toolbarCollapsiblesSelector: '[data-role=\"toolbar-menu-item\"]',\n            toolbarCollapsiblesActiveClass: '_active',\n            template: 'ui/grid/sticky/sticky',\n            stickyContainerSelector: '.sticky-header',\n            stickyElementSelector: '[data-role = \"sticky-el-root\"]',\n            leftDataGridCapSelector: '.data-grid-cap-left',\n            rightDataGridCapSelector: '.data-grid-cap-right',\n            visible: false,\n            enableToolbar: true,\n            enableHeader: true,\n            modules: {\n                toolbar: '${ $.toolbarProvider }',\n                listing: '${ $.listingProvider }'\n            },\n            otherStickyElsSize: 77,\n            containerNode: null,\n            listingNode: null,\n            toolbarNode: null,\n            stickyListingNode: null,\n            stickyToolbarNode: null,\n            storedOriginalToolbarElements: [],\n            cache: {},\n            flags: {},\n            dirtyFlag: 'dirty'\n        },\n\n        /**\n         * Initializes Sticky component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super();\n            _.bindAll(this,\n                'adjustStickyElems',\n                'initListingNode',\n                'initToolbarNode',\n                'initContainerNode',\n                'initColumns',\n                'initStickyListingNode',\n                'initStickyToolbarNode',\n                'initLeftDataGridCap',\n                'initRightDataGridCap'\n            );\n\n            $.async(this.listingSelector,\n                this.initListingNode);\n            $.async(this.toolbarSelector,\n                this.initToolbarNode);\n\n            $.async(this.stickyContainerSelector,\n                this,\n                this.initContainerNode);\n\n            return this;\n        },\n\n        /**\n         * Init observables\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('visible');\n\n            return this;\n        },\n\n        /**\n         * Init original listing node\n         *\n         * @param {HTMLElement} node\n         */\n        initListingNode: function (node) {\n            if ($(node).is(this.stickyElementSelector)) {\n                return;\n            }\n            this.listingNode = $(node);\n            $.async(this.columnSelector, node, this.initColumns);\n        },\n\n        /**\n         * Init original toolbar node\n         *\n         * @param {HTMLElement} node\n         */\n        initToolbarNode: function (node) {\n            if ($(node).is(this.stickyElementSelector)) {\n                return;\n            }\n            this.toolbarNode = $(node);\n        },\n\n        /**\n         * Init sticky listing node\n         *\n         * @param {HTMLElement} node\n         */\n        initStickyListingNode: function (node) {\n            this.stickyListingNode = $(node);\n            this.checkPos();\n            this.initListeners();\n        },\n\n        /**\n         * Init sticky toolbar node\n         *\n         * @param {HTMLElement} node\n         */\n        initStickyToolbarNode: function (node) {\n            this.stickyToolbarNode = $(node);\n        },\n\n        /**\n         * Init sticky header container node\n         *\n         * @param {HTMLElement} node\n         */\n        initContainerNode: function (node) {\n            this.containerNode = $(node);\n\n            $.async(this.leftDataGridCapSelector,\n                node,\n                this.initLeftDataGridCap);\n            $.async(this.rightDataGridCapSelector,\n                node,\n                this.initRightDataGridCap);\n\n            $.async(this.stickyElementSelector,\n                this.listing(),\n                this.initStickyListingNode);\n            $.async(this.stickyElementSelector,\n                this.toolbar(),\n                this.initStickyToolbarNode);\n        },\n\n        /**\n         * Init columns (each time when amount of columns is changed)\n         *\n         */\n        initColumns: function () {\n            this.columns = this.listingNode.find(this.columnSelector);\n        },\n\n        /**\n         * Init left DataGridCap\n         *\n         * @param {HTMLElement} node\n         */\n        initLeftDataGridCap: function (node) {\n            this.leftDataGridCap = $(node);\n        },\n\n        /**\n         * Init right DataGridCap\n         *\n         * @param {HTMLElement} node\n         */\n        initRightDataGridCap: function (node) {\n            this.rightDataGridCap = $(node);\n        },\n\n        /**\n         * Init listeners\n         *\n         * @returns {Object} Chainable.\n         */\n        initListeners: function () {\n            this.adjustStickyElems();\n            this.initOnResize()\n                .initOnScroll()\n                .initOnListingScroll();\n\n            return this;\n        },\n\n        /**\n         * Start to listen to window scroll event\n         *\n         * @returns {Object} Chainable.\n         */\n        initOnScroll: function () {\n            this.lastHorizontalScrollPos = $(window).scrollLeft();\n            document.addEventListener('scroll', function () {\n                this.flags.scrolled = true;\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Start to listen to original listing scroll event\n         *\n         * @returns {Object} Chainable.\n         */\n        initOnListingScroll: function () {\n            $(this.listingNode).scroll(function (e) {\n                this.flags.listingScrolled = true;\n                this.flags.listingScrolledValue = $(e.target).scrollLeft();\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Start to listen to window resize event\n         *\n         * @returns {Object} Chainable.\n         */\n        initOnResize: function () {\n            $(window).resize(function () {\n                this.flags.resized = true;\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Adjust sticky header elements according to flags of the events that have happened in the endless RAF loop\n         */\n        adjustStickyElems: function () {\n            if (this.flags.resized ||\n                this.flags.scrolled) {\n                this.checkPos();\n            }\n\n            if (this.visible) {\n                this.checkTableElemsWidth();\n\n                if (this.flags.originalWidthChanged) {\n                    this.adjustContainerElemsWidth();\n                }\n\n                if (this.flags.resized) {\n                    this.onResize();\n                }\n\n                if (this.flags.scrolled) {\n                    this.onWindowScroll();\n                }\n\n                if (this.flags.listingScrolled) {\n                    this.onListingScroll(this.flags.listingScrolledValue);\n                }\n            }\n            _.each(this.flags, function (val, key) {\n                if (val === this.dirtyFlag) {\n                    this.flags[key] = false;\n                } else if (val) {\n                    this.flags[key] = this.dirtyFlag;\n                }\n            }, this);\n\n            raf(this.adjustStickyElems);\n        },\n\n        /**\n         * Handles window scroll\n         */\n        onWindowScroll: function () {\n            var scrolled = $(window).scrollLeft(),\n                horizontal = this.lastHorizontalScrollPos !== scrolled;\n\n            if (horizontal) {\n                this.adjustOffset()\n                    .adjustDataGridCapPositions();\n                this.lastHorizontalScrollPos = scrolled;\n            } else {\n                this.checkPos();\n            }\n        },\n\n        /**\n         * Handles original listing scroll\n         *\n         * @param {Number} scrolled\n         */\n        onListingScroll: function (scrolled) {\n            this.adjustOffset(scrolled);\n        },\n\n        /**\n         * Handles window resize\n         */\n        onResize: function () {\n            this.checkPos();\n            this.adjustContainerElemsWidth()\n                .adjustDataGridCapPositions();\n        },\n\n        /**\n         * Check if original table or columns change it dimensions and sets appropriate flag\n         */\n        checkTableElemsWidth: function () {\n            var newWidth = this.getTableWidth();\n\n            if (this.cache.tableWidth !== newWidth) {\n                this.cache.tableWidth = newWidth;\n                this.flags.originalWidthChanged = true;\n            } else if (this.cache.colChecksum !== this.getColsChecksum()) {\n                this.cache.colChecksum = this.getColsChecksum();\n                this.flags.originalWidthChanged = true;\n            }\n        },\n\n        /**\n         * Get the checksum of original columns width\n         *\n         * @returns {Number}.\n         */\n        getColsChecksum: function () {\n            return _.reduce(this.columns,\n            function (pv, cv) {\n                return ($(pv).width() || pv) + '' + $(cv).width();\n            });\n        },\n\n        /**\n         * Get the width of the sticky table wrapper\n         *\n         * @returns {Number}.\n         */\n        getListingWidth: function () {\n            return this.listingNode.width();\n        },\n\n        /**\n         * Get the width of the original table\n         *\n         * @returns {Number}.\n         */\n        getTableWidth: function () {\n            return this.listingNode.find(this.tableSelector).width();\n        },\n\n        /**\n         * Get the top elem: header or toolbar\n         *\n         * @returns {HTMLElement}.\n         */\n        getTopElement: function () {\n            return this.toolbarNode || this.listingNode;\n        },\n\n        /**\n         * Get the height of the other sticky elem (Page header)\n         *\n         * @returns {Number}.\n         */\n        getOtherStickyElementsSize: function () {\n            return this.otherStickyElsSize;\n        },\n\n        /**\n         * Get original bulk row height, if is visible\n         *\n         * @returns {Number}.\n         */\n        getBulkRowHeight: function () {\n            return this.listingNode.find(this.bulkRowSelector).filter(':visible').height();\n        },\n\n        /**\n         * Get top Y coord of the sticky header\n         *\n         * @returns {Number}.\n         */\n        getListingTopYCoord: function () {\n            var bulkRowHeight = this.getBulkRowHeight();\n\n            return this.listingNode.find('tbody').offset().top -\n                this.containerNode.height() -\n                $(window).scrollTop() +\n                bulkRowHeight;\n        },\n\n        /**\n         * Check if sticky header must be visible\n         *\n         * @returns {Boolean}.\n         */\n        getMustBeSticky: function () {\n            var stickyTopCondition = this.getListingTopYCoord() - this.getOtherStickyElementsSize(),\n                stickyBottomCondition = this.listingNode.offset().top +\n                    this.listingNode.height() -\n                    $(window).scrollTop() +\n                    this.getBulkRowHeight() -\n                    this.getOtherStickyElementsSize();\n\n            return stickyTopCondition < 0 && stickyBottomCondition > 0;\n        },\n\n        /**\n         * Resize sticky header and cols\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustContainerElemsWidth: function () {\n            this.resizeContainer()\n                .resizeCols()\n                .resizeBulk();\n\n            return this;\n        },\n\n        /**\n         * Resize sticky header\n         *\n         * @returns {Object} Chainable.\n         */\n        resizeContainer: function () {\n            var listingWidth = this.getListingWidth();\n\n            this.stickyListingNode.innerWidth(listingWidth);\n            this.stickyListingNode.find(this.tableSelector).innerWidth(this.getTableWidth());\n\n            if (this.stickyToolbarNode) {\n                this.stickyToolbarNode.innerWidth(listingWidth);\n            }\n\n            return this;\n        },\n\n        /**\n         * Resize sticky cols\n         *\n         * @returns {Object} Chainable.\n         */\n        resizeCols: function () {\n            var cols = this.listingNode.find(this.columnSelector);\n\n            this.stickyListingNode.find(this.columnSelector).each(function (ind) {\n                var originalColWidth =  $(cols[ind]).width();\n\n                $(this).width(originalColWidth);\n            });\n\n            return this;\n        },\n\n        /**\n         * Resize bulk row header\n         *\n         * @returns {Object} Chainable.\n         */\n        resizeBulk: function () {\n            var bulk = this.containerNode.find(this.bulkRowHeaderSelector)[0];\n\n            if (bulk) {\n                $(bulk).innerWidth(this.getListingWidth());\n            }\n\n            return this;\n        },\n\n        /**\n         * Reset viewport to the top of listing\n         */\n        resetToTop: function () {\n            var posOfTopEl = this.getTopElement().offset().top - this.getOtherStickyElementsSize() || 0;\n\n            $(window).scrollTop(posOfTopEl);\n        },\n\n        /**\n         * Adjust sticky header offset\n         *\n         * @param {Number} val\n         * @returns {Object} Chainable.\n         */\n        adjustOffset: function (val) {\n            val = val || this.listingNode.scrollLeft();\n            this.stickyListingNode.offset({\n                left: this.listingNode.offset().left - val\n            });\n\n            return this;\n        },\n\n        /**\n         * Adjust both DataGridCap position\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustDataGridCapPositions: function () {\n            this.adjustLeftDataGridCapPos()\n                .adjustRightDataGridCapPos();\n\n            return this;\n        },\n\n        /**\n         * Adjust left DataGridCap position\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustLeftDataGridCapPos: function () {\n            this.leftDataGridCap.offset({\n                left: this.listingNode.offset().left - this.leftDataGridCap.width()\n            });\n\n            return this;\n        },\n\n        /**\n         * Adjust right DataGridCap position\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustRightDataGridCapPos: function () {\n            this.rightDataGridCap.offset({\n                left: this.listingNode.offset().left + this.listingNode.width()\n            });\n\n            return this;\n        },\n\n        /**\n         * Hides the oiginal toolbar opened dropdowns/collapsibles etc\n         */\n        collapseOriginalElements: function () {\n            this.toolbarNode\n                .find(this.toolbarCollapsiblesSelector)\n                .css('visibility', 'hidden');\n            $(this.listingNode.find(this.bulkRowSelector)[0]).css('visibility', 'hidden');\n        },\n\n        /**\n         * Restores the oiginal toolbar opened dropdowns/collapsibles etc\n         */\n        restoreOriginalElements: function () {\n            this.toolbarNode\n                .find(this.toolbarCollapsiblesSelector)\n                .css('visibility', 'visible');\n            $(this.listingNode.find(this.bulkRowSelector)[0]).css('visibility', 'visible');\n        },\n\n        /**\n         * Toggle the visibility of sticky header\n         *\n         * @returns {Object} Chainable.\n         */\n        toggleContainerVisibility: function () {\n            this.visible = !this.visible;\n\n            return this;\n        },\n\n        /**\n         * Checks position of the listing to know if need to show/hide sticky header\n         *\n         * @returns {Boolean} whether the visibility of the sticky header was toggled.\n         */\n        checkPos: function () {\n            var isSticky = this.visible,\n                mustBeSticky = this.getMustBeSticky(),\n                needChange = isSticky !== mustBeSticky;\n\n            if (needChange) {\n                if (mustBeSticky) {\n                    this.collapseOriginalElements();\n                    this.toggleContainerVisibility();\n                    this.adjustContainerElemsWidth()\n                        .adjustOffset()\n                        .adjustDataGridCapPositions();\n\n                } else {\n                    this.toggleContainerVisibility();\n                    this.restoreOriginalElements();\n                }\n            }\n\n            return needChange;\n        }\n    });\n});\n","Magento_Ui/js/grid/controls/columns.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'mage/translate',\n    'uiCollection'\n], function (_, utils, $t, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/controls/columns',\n            minVisible: 1,\n            maxVisible: 30,\n            viewportSize: 18,\n            displayArea: 'dataGridActions',\n            columnsProvider: 'ns = ${ $.ns }, componentType = columns',\n            imports: {\n                addColumns: '${ $.columnsProvider }:elems'\n            },\n            templates: {\n                headerMsg: $t('${ $.visible } out of ${ $.total } visible')\n            }\n        },\n\n        /**\n         * Resets columns visibility to theirs default state.\n         *\n         * @returns {Columns} Chainable.\n         */\n        reset: function () {\n            this.elems.each('applyState', 'default', 'visible');\n\n            return this;\n        },\n\n        /**\n         * Applies last saved state of columns visibility.\n         *\n         * @returns {Columns} Chainable.\n         */\n        cancel: function () {\n            this.elems.each('applyState', '', 'visible');\n\n            return this;\n        },\n\n        /**\n         * Adds columns whose visibility can be controlled to the component.\n         *\n         * @param {Array} columns - Elements array that will be added to component.\n         * @returns {Columns} Chainable.\n         */\n        addColumns: function (columns) {\n            columns = _.where(columns, {\n                controlVisibility: true\n            });\n\n            this.insertChild(columns);\n\n            return this;\n        },\n\n        /**\n         * Defines whether child elements array length\n         * is greater than the 'viewportSize' property.\n         *\n         * @returns {Boolean}\n         */\n        hasOverflow: function () {\n            return this.elems().length > this.viewportSize;\n        },\n\n        /**\n         * Helper, checks\n         *  - if less than one item choosen\n         *  - if more then viewportMaxSize choosen\n         *\n         * @param {Object} elem\n         * @returns {Boolean}\n         */\n        isDisabled: function (elem) {\n            var visible = this.countVisible();\n\n            return elem.visible ?\n                    visible === this.minVisible :\n                    visible === this.maxVisible;\n        },\n\n        /**\n         * Counts number of visible columns.\n         *\n         * @returns {Number}\n         */\n        countVisible: function () {\n            return this.elems.filter('visible').length;\n        },\n\n        /**\n         * Compile header message from headerMessage setting.\n         *\n         * @returns {String}\n         */\n        getHeaderMessage: function () {\n            return utils.template(this.templates.headerMsg, {\n                visible: this.countVisible(),\n                total: this.elems().length\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/controls/bookmarks/bookmarks.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'mage/translate',\n    'rjsResolver',\n    'uiLayout',\n    'uiCollection'\n], function (_, utils, $t, resolver, layout, Collection) {\n    'use strict';\n\n    /**\n     * Removes 'current' namespace from a 'path' string.\n     *\n     * @param {String} path\n     * @returns {String} Path without namespace.\n     */\n    function removeStateNs(path) {\n        path = typeof path == 'string' ? path.split('.') : [];\n\n        if (path[0] === 'current') {\n            path.shift();\n        }\n\n        return path.join('.');\n    }\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/controls/bookmarks/bookmarks',\n            viewTmpl: 'ui/grid/controls/bookmarks/view',\n            newViewLabel: $t('New View'),\n            defaultIndex: 'default',\n            activeIndex: 'default',\n            viewsArray: [],\n            storageConfig: {\n                provider: '${ $.storageConfig.name }',\n                name: '${ $.name }_storage',\n                component: 'Magento_Ui/js/grid/controls/bookmarks/storage'\n            },\n            views: {\n                default: {\n                    label: $t('Default View'),\n                    index: 'default',\n                    editable: false\n                }\n            },\n            tracks: {\n                editing: true,\n                viewsArray: true,\n                activeView: true,\n                hasChanges: true,\n                customLabel: true,\n                customVisible: true\n            },\n            listens: {\n                activeIndex: 'onActiveIndexChange',\n                activeView: 'checkState',\n                current: 'onStateChange'\n            }\n        },\n\n        /**\n         * Initializes bookmarks component.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        initialize: function () {\n            utils.limit(this, 'checkState', 5);\n            utils.limit(this, 'saveState', 2000);\n\n            this._super()\n                .restore()\n                .initStorage()\n                .initViews();\n\n            return this;\n        },\n\n        /**\n         * Creates custom storage instance.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        initStorage: function () {\n            layout([this.storageConfig]);\n\n            return this;\n        },\n\n        /**\n         * Defines default data if it wasn't gathered previously.\n         *\n         * @private\n         * @returns {Bookmarks} Chainbale.\n         */\n        initDefaultView: function () {\n            var data = this.getViewData(this.defaultIndex);\n\n            if (!_.size(data)) {\n                this.setViewData(this.defaultIndex, this.current)\n                    .saveView(this.defaultIndex);\n            }\n\n            this.defaultDefined = true;\n\n            return this;\n        },\n\n        /**\n         * Creates instances of a previously saved views.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        initViews: function () {\n            _.each(this.views, function (config) {\n                this.addView(config);\n            }, this);\n\n            this.activeView = this.getActiveView();\n\n            return this;\n        },\n\n        /**\n         * Creates complete configuration for a view.\n         *\n         * @param {Object} [config] - Additional configuration object.\n         * @returns {Object}\n         */\n        buildView: function (config) {\n            var view = {\n                label: this.newViewLabel,\n                index: '_' + Date.now(),\n                editable: true\n            };\n\n            utils.extend(view, config || {});\n\n            view.data   = view.data || utils.copy(this.current);\n            view.value  = view.label;\n\n            this.observe.call(view, true, 'label value');\n\n            return view;\n        },\n\n        /**\n         * Creates instance of a view with a provided configuration.\n         *\n         * @param {Object} [config] - View configuration.\n         * @param {Boolean} [saveView=false] - Whether to save created view automatically or not.\n         * @param {Boolean} [applyView=false] - Whether to apply created view automatically or not.\n         * @returns {View} Created view.\n         */\n        addView: function (config, saveView, applyView) {\n            var view    = this.buildView(config),\n                index   = view.index;\n\n            this.views[index] = view;\n\n            if (saveView) {\n                this.saveView(index);\n            }\n\n            if (applyView) {\n                this.applyView(index);\n            }\n\n            this.updateArray();\n\n            return view;\n        },\n\n        /**\n         * Removes specified view.\n         *\n         * @param {String} index - Index of a view to be removed.\n         * @returns {Bookmarks} Chainable.\n         */\n        removeView: function (index) {\n            var viewPath = this.getViewPath(index);\n\n            if (this.isViewActive(index)) {\n                this.applyView(this.defaultIndex);\n            }\n\n            this.endEdit(index)\n                .remove(viewPath)\n                .removeStored(viewPath)\n                .updateArray();\n\n            return this;\n        },\n\n        /**\n         * Saves data of a specified view.\n         *\n         * @param {String} index - Index of a view to be saved.\n         * @returns {Bookmarks} Chainable.\n         */\n        saveView: function (index) {\n            var viewPath = this.getViewPath(index);\n\n            this.updateViewLabel(index)\n                .endEdit(index)\n                .store(viewPath)\n                .checkState();\n\n            return this;\n        },\n\n        /**\n         * Sets specified view as active\n         * and applies its' state.\n         *\n         * @param {String} index - Index of a view to be applied.\n         * @returns {Bookmarks} Chainable.\n         */\n        applyView: function (index) {\n            this.applyStateOf(index)\n                .set('activeIndex', index);\n\n            return this;\n        },\n\n        /**\n         * Updates data of a specified view if it's\n         * currently active and saves its' data.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {Bookmarks} Chainable.\n         */\n        updateAndSave: function (index) {\n            if (this.isViewActive(index)) {\n                this.updateActiveView(index);\n            }\n\n            this.saveView(index);\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a specified view.\n         *\n         * @param {String} index - Index of a view to be retrieved.\n         * @returns {View}\n         */\n        getView: function (index) {\n            return this.views[index];\n        },\n\n        /**\n         * Returns instance of an active view.\n         *\n         * @returns {View}\n         */\n        getActiveView: function () {\n            return this.views[this.activeIndex];\n        },\n\n        /**\n         * Checks if specified view is active.\n         *\n         * @param {String} index - Index of a view to be checked.\n         * @returns {Boolean}\n         */\n        isViewActive: function (index) {\n            return this.activeView === this.getView(index);\n        },\n\n        /**\n         * Sets current state as a data of an active view.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        updateActiveView: function () {\n            this.setViewData(this.activeIndex, this.current);\n\n            return this;\n        },\n\n        /**\n         * Replaces label a view with a provided one.\n         * If new label is not specified, then views'\n         * 'value' property will be taken.\n         *\n         * @param {String} index - Index of a view.\n         * @param {String} [label=view.value] - New labels' value.\n         * @returns {Bookmarks} Chainable.\n         */\n        updateViewLabel: function (index, label) {\n            var view    = this.getView(index),\n                current = view.label;\n\n            label = (label || view.value).trim() || current;\n            label = this.uniqueLabel(label, current);\n\n            view.label = view.value = label;\n\n            return this;\n        },\n\n        /**\n         * Retrieves data of a specified view.\n         *\n         * @param {String} index - Index of a view whose data should be retrieved.\n         * @param {String} [property] - If not specified then whole views' data will be retrieved.\n         * @returns {Object} Views' data.\n         */\n        getViewData: function (index, property) {\n            var view = this.getView(index),\n                data = view.data;\n\n            if (property) {\n                data = utils.nested(data, property);\n            }\n\n            return utils.copy(data);\n        },\n\n        /**\n         * Sets data to the specified view.\n         *\n         * @param {String} index - Index of a view whose data will be replaced.\n         * @param {Object} data - New view data.\n         * @returns {Bookmarks} Chainable.\n         */\n        setViewData: function (index, data) {\n            var path = this.getViewPath(index) + '.data';\n\n            this.set(path, utils.copy(data));\n\n            return this;\n        },\n\n        /**\n         * Starts editing of a specified view.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {Bookmarks} Chainable.\n         */\n        editView: function (index) {\n            this.editing = index;\n\n            return this;\n        },\n\n        /**\n         * Ends editing of specified view\n         * and restores its' label.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {Bookmarks} Chainable.\n         */\n        endEdit: function (index) {\n            var view;\n\n            if (!this.isEditing(index)) {\n                return this;\n            }\n\n            index   = index || this.editing;\n            view    = this.getView(index);\n\n            view.value = view.label;\n\n            this.editing = false;\n\n            return this;\n        },\n\n        /**\n         * Checks if specified view is in editing state.\n         *\n         * @param {String} index - Index of a view to be checked.\n         * @returns {Boolean}\n         */\n        isEditing: function (index) {\n            return this.editing === index;\n        },\n\n        /**\n         * Generates label unique among present views, based\n         * on the incoming label pattern.\n         *\n         * @param {String} [label=this.newViewLabel] - Label pattern.\n         * @param {String} [exclude]\n         * @returns {String}\n         */\n        uniqueLabel: function (label, exclude) {\n            var labels      = _.pluck(this.views, 'label'),\n                hasParenth  = _.last(label) === ')',\n                index       = 2,\n                result,\n                suffix;\n\n            labels = _.without(labels, exclude);\n            result = label = label || this.newViewLabel;\n\n            for (index = 2; _.contains(labels, result); index++) {\n                suffix = '(' + index + ')';\n\n                if (!hasParenth) {\n                    suffix = ' ' + suffix;\n                }\n\n                result = label + suffix;\n            }\n\n            return result;\n        },\n\n        /**\n         * Applies state of a specified view, without\n         * making it active.\n         *\n         * @param {String} [state=this.activeIndex]\n         * @param {String} [property]\n         * @returns {Bookmarks} Chainable.\n         */\n        applyStateOf: function (state, property) {\n            var index    = state || this.activeIndex,\n                dataPath = removeStateNs(property),\n                viewData = this.getViewData(index, dataPath);\n\n            dataPath = dataPath ?\n                'current.' + dataPath :\n                'current';\n\n            this.set(dataPath, viewData);\n\n            return this;\n        },\n\n        /**\n         * Saves current state.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        saveState: function () {\n            this.store('current');\n\n            return this;\n        },\n\n        /**\n         * Applies state of an active view.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        resetState: function () {\n            this.applyStateOf(this.activeIndex);\n\n            return this;\n        },\n\n        /**\n         * Checks if current state is different\n         * from the state of an active view.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        checkState: function () {\n            var viewData = this.getViewData(this.activeIndex),\n                diff     = utils.compare(viewData, this.current);\n\n            this.hasChanges = !diff.equal;\n\n            return this;\n        },\n\n        /**\n         * Returns path to the view instance,\n         * based on a provided index.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {String}\n         */\n        getViewPath: function (index) {\n            return 'views.' + index;\n        },\n\n        /**\n         * Updates the array of views.\n         *\n         * @returns {Bookmarks} Chainable\n         */\n        updateArray: function () {\n            this.viewsArray = _.values(this.views);\n\n            return this;\n        },\n\n        /**\n         * Shows custom view field and creates unique label for it.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        showCustom: function () {\n            this.customLabel    = this.uniqueLabel();\n            this.customVisible  = true;\n\n            return this;\n        },\n\n        /**\n         * Hides custom view field.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        hideCustom: function () {\n            this.customVisible = false;\n\n            return this;\n        },\n\n        /**\n         * Checks if custom view field is visible.\n         *\n         * @returns {Boolean}\n         */\n        isCustomVisible: function () {\n            return this.customVisible;\n        },\n\n        /**\n         * Creates new view instance with a label specified\n         * in a custom view field.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        applyCustom: function () {\n            var label = this.customLabel.trim();\n\n            this.hideCustom()\n                .addView({\n                    label: this.uniqueLabel(label)\n                }, true, true);\n\n            return this;\n        },\n\n        /**\n         * Listener of the activeIndex property.\n         */\n        onActiveIndexChange: function () {\n            this.activeView = this.getActiveView();\n\n            this.store('activeIndex');\n        },\n\n        /**\n         * Listener of the activeIndex property.\n         */\n        onStateChange: function () {\n            this.checkState();\n            this.saveState();\n\n            if (!this.defaultDefined) {\n                resolver(this.initDefaultView, this);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/controls/bookmarks/storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mageUtils',\n    'Magento_Ui/js/lib/core/storage/local',\n    'uiClass'\n], function ($, utils, storage, Class) {\n    'use strict';\n\n    /**\n     * Removes ns prefix for path.\n     *\n     * @param {String} ns\n     * @param {String} path\n     * @returns {String}\n     */\n    function removeNs(ns, path) {\n        return path.replace(ns + '.', '');\n    }\n\n    return Class.extend({\n        defaults: {\n            ajaxSettings: {\n                method: 'POST',\n                data: {\n                    namespace: '${ $.namespace }'\n                }\n            }\n        },\n\n        /**\n         * Delegates call to the localStorage adapter.\n         */\n        get: function () {\n            return {};\n        },\n\n        /**\n         * Sends request to store specified data.\n         *\n         * @param {String} path - Path by which data should be stored.\n         * @param {*} value - Value to be sent.\n         */\n        set: function (path, value) {\n            var property = removeNs(this.namespace, path),\n                data = {},\n                config;\n\n            utils.nested(data, property, value);\n\n            config = utils.extend({\n                url: this.saveUrl,\n                data: {\n                    data: JSON.stringify(data)\n                }\n            }, this.ajaxSettings);\n\n            $.ajax(config);\n        },\n\n        /**\n         * Sends request to remove specified data.\n         *\n         * @param {String} path - Path to the property to be removed.\n         */\n        remove: function (path) {\n            var property = removeNs(this.namespace, path),\n                config;\n\n            config = utils.extend({\n                url: this.deleteUrl,\n                data: {\n                    data: property\n                }\n            }, this.ajaxSettings);\n\n            $.ajax(config);\n        }\n    });\n});\n","Magento_Ui/js/grid/controls/button/split.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (data, element) {\n\n        $(element).on('click.splitDefault', '.action-default', function () {\n            $(this).siblings('.dropdown-menu').find('.item-default').trigger('click');\n        });\n    };\n});\n","Magento_Ui/js/grid/paging/sizes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiElement'\n], function (ko, _, utils, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/paging/sizes',\n            minSize: 1,\n            maxSize: 999,\n            statefull: {\n                options: true,\n                value: true\n            },\n            listens: {\n                value: 'onValueChange',\n                options: 'onSizesChange'\n            }\n        },\n\n        /**\n         * Initializes sizes component.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .updateArray();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'value',\n                    'editing',\n                    'customVisible',\n                    'customValue'\n                ])\n                .track({\n                    optionsArray: []\n                });\n\n            this._value = ko.pureComputed({\n                read: ko.getObservable(this, 'value'),\n\n                /**\n                 * Validates input field prior to updating 'value' property.\n                 */\n                write: function (value) {\n                    value = this.normalize(value);\n\n                    this.value = value;\n                    this._value.notifySubscribers(value);\n                },\n\n                owner: this\n            });\n\n            return this;\n        },\n\n        /**\n         * Starts editing of the specified size.\n         *\n         * @param {Number} value - Value of the size.\n         * @returns {Sizes} Chainable.\n         */\n        edit: function (value) {\n            this.editing = value;\n\n            return this;\n        },\n\n        /**\n         * Discards changes made to the currently editable size.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        discardEditing: function () {\n            var value = this.editing;\n\n            if (value) {\n                this.updateSize(value, value);\n            }\n\n            return this;\n        },\n\n        /**\n         * Invokes 'discardEditing' and 'discardCustom' actions.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        discardAll: function () {\n            this.discardEditing()\n                .discardCustom();\n\n            return this;\n        },\n\n        /**\n         * Returns value of the first size.\n         *\n         * @returns {Number}\n         */\n        getFirst: function () {\n            return this.optionsArray[0].value;\n        },\n\n        /**\n         * Returns size which matches specified value.\n         *\n         * @param {Number} value - Value of the item.\n         * @returns {Object|Undefined}\n         */\n        getSize: function (value) {\n            return this.options[value];\n        },\n\n        /**\n         * Sets current size to the specified value.\n         *\n         * @param {Number} value - Value of the size.\n         * @returns {Sizes} Chainable.\n         */\n        setSize: function (value) {\n            this.value = value;\n\n            return this;\n        },\n\n        /**\n         * Adds a new value to sizes list.\n         *\n         * @param {Number} value - Value to be added.\n         * @returns {Sizes} Chainable.\n         */\n        addSize: function (value) {\n            var size;\n\n            if (!this.hasSize(value)) {\n                size = this.createSize(value);\n\n                this.set('options.' + value, size);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes provided value from the sizes list.\n         *\n         * @param {Number} value - Value to be removed.\n         * @returns {Sizes} Chainable.\n         */\n        removeSize: function (value) {\n            if (!this.hasSize(value)) {\n                return this;\n            }\n\n            this.remove('options.' + value);\n\n            if (this.isSelected(value)) {\n                this.setSize(this.getFirst());\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates existing value to the provided one. If new value\n         * is not specified, then sizes' '_value' property will be taken.\n         *\n         * @param {Number} value - Existing value that should be updated.\n         * @param {(Number|String)} [newValue=size._value] - New size value.\n         * @returns {Sizes} Chainable.\n         */\n        updateSize: function (value, newValue) {\n            var size = this.getSize(value);\n\n            if (!size) {\n                return this;\n            }\n\n            newValue = newValue || size._value;\n\n            if (isNaN(+newValue)) {\n                this.discardEditing();\n\n                return this;\n            }\n\n            newValue = this.normalize(newValue);\n\n            this.remove('options.' + value)\n                .addSize(newValue);\n\n            if (this.isSelected(value)) {\n                this.setSize(newValue);\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates new editable size instance with the provided value.\n         *\n         * @param {Number} value - Value of the size.\n         * @returns {Object}\n         */\n        createSize: function (value) {\n            return {\n                value: value,\n                label: value,\n                _value: value,\n                editable: true\n            };\n        },\n\n        /**\n         * Checks if provided value exists in the sizes list.\n         *\n         * @param {Number} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        hasSize: function (value) {\n            return !!this.getSize(value);\n        },\n\n        /**\n         * Hides and clears custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        discardCustom: function () {\n            this.hideCustom()\n                .clearCustom();\n\n            return this;\n        },\n\n        /**\n         * Shows custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        showCustom: function () {\n            this.customVisible = true;\n\n            return this;\n        },\n\n        /**\n         * Hides custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        hideCustom: function () {\n            this.customVisible = false;\n\n            return this;\n        },\n\n        /**\n         * Empties value of the custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        clearCustom: function () {\n            this.customValue = '';\n\n            return this;\n        },\n\n        /**\n         * Adds a new size specified in the custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        applyCustom: function () {\n            var value = this.customValue;\n\n            value = this.normalize(value);\n\n            this.addSize(value)\n                .setSize(value)\n                .discardCustom();\n\n            return this;\n        },\n\n        /**\n         * Checks if custom field is visible.\n         *\n         * @returns {Boolean}\n         */\n        isCustomVisible: function () {\n            return this.customVisible;\n        },\n\n        /**\n         * Converts provided value to a number and puts\n         * it in range between 'minSize' and 'maxSize' properties.\n         *\n         * @param {(Number|String)} value - Value to be normalized.\n         * @returns {Number}\n         */\n        normalize: function (value) {\n            value = +value;\n\n            if (isNaN(value)) {\n                return this.getFirst();\n            }\n\n            return utils.inRange(Math.round(value), this.minSize, this.maxSize);\n        },\n\n        /**\n         * Updates the array of options.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        updateArray: function () {\n            var array = _.values(this.options);\n\n            this.optionsArray = _.sortBy(array, 'value');\n\n            return this;\n        },\n\n        /**\n         * Checks if provided value is in editing state.\n         *\n         * @param {Number} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        isEditing: function (value) {\n            return this.editing === value;\n        },\n\n        /**\n         * Checks if provided value is selected.\n         *\n         * @param {Number} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        isSelected: function (value) {\n            return this.value === value;\n        },\n\n        /**\n         * Listener of the 'value' property changes.\n         */\n        onValueChange: function () {\n            this.discardAll()\n                .trigger('close');\n        },\n\n        /**\n         * Listener of the 'options' object changes.\n         */\n        onSizesChange: function () {\n            this.editing = false;\n\n            this.updateArray();\n        }\n    });\n});\n","Magento_Ui/js/grid/paging/paging.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'uiElement'\n], function (ko, _, utils, layout, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/paging/paging',\n            totalTmpl: 'ui/grid/paging-total',\n            totalRecords: 0,\n            pages: 1,\n            current: 1,\n            selectProvider: 'ns = ${ $.ns }, index = ids',\n\n            sizesConfig: {\n                component: 'Magento_Ui/js/grid/paging/sizes',\n                name: '${ $.name }_sizes',\n                storageConfig: {\n                    provider: '${ $.storageConfig.provider }',\n                    namespace: '${ $.storageConfig.namespace }'\n                }\n            },\n\n            imports: {\n                totalSelected: '${ $.selectProvider }:totalSelected',\n                totalRecords: '${ $.provider }:data.totalRecords',\n                filters: '${ $.provider }:params.filters'\n            },\n\n            exports: {\n                pageSize: '${ $.provider }:params.paging.pageSize',\n                current: '${ $.provider }:params.paging.current'\n            },\n\n            links: {\n                options: '${ $.sizesConfig.name }:options',\n                pageSize: '${ $.sizesConfig.name }:value'\n            },\n\n            statefull: {\n                pageSize: true,\n                current: true\n            },\n\n            listens: {\n                'pages': 'onPagesChange',\n                'pageSize': 'onPageSizeChange',\n                'totalRecords': 'updateCounter',\n                '${ $.provider }:params.filters': 'goFirst'\n            },\n\n            modules: {\n                sizes: '${ $.sizesConfig.name }'\n            }\n        },\n\n        /**\n         * Initializes paging component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initSizes()\n                .updateCounter();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'totalSelected',\n                    'totalRecords',\n                    'pageSize',\n                    'pages',\n                    'current'\n                ]);\n\n            this._current = ko.pureComputed({\n                read: ko.getObservable(this, 'current'),\n\n                /**\n                 * Validates page change according to user's input.\n                 * Sets current observable to result of validation.\n                 * Calls reload method then.\n                 */\n                write: function (value) {\n                    this.setPage(value)\n                        ._current.notifySubscribers(this.current);\n                },\n\n                owner: this\n            });\n\n            return this;\n        },\n\n        /**\n         * Initializes sizes component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initSizes: function () {\n            layout([this.sizesConfig]);\n\n            return this;\n        },\n\n        /**\n         * Gets first item index on current page.\n         *\n         * @returns {Number}\n         */\n        getFirstItemIndex: function () {\n            return this.pageSize * (this.current - 1) + 1;\n        },\n\n        /**\n         * Gets last item index on current page.\n         *\n         * @returns {Number}\n         */\n        getLastItemIndex: function () {\n            var lastItem = this.getFirstItemIndex() + this.pageSize - 1;\n\n            return this.totalRecords < lastItem ? this.totalRecords : lastItem;\n        },\n\n        /**\n         * Sets cursor to the provied value.\n         *\n         * @param {(Number|String)} value - New value of the cursor.\n         * @returns {Paging} Chainable.\n         */\n        setPage: function (value) {\n            this.current = this.normalize(value);\n\n            return this;\n        },\n\n        /**\n         * Increments current page value.\n         *\n         * @returns {Paging} Chainable.\n         */\n        next: function () {\n            this.setPage(this.current + 1);\n\n            return this;\n        },\n\n        /**\n         * Decrements current page value.\n         *\n         * @returns {Paging} Chainable.\n         */\n        prev: function () {\n            this.setPage(this.current - 1);\n\n            return this;\n        },\n\n        /**\n         * Goes to the first page.\n         *\n         * @returns {Paging} Chainable.\n         */\n        goFirst: function () {\n            if (!_.isUndefined(this.filters)) {\n                this.current = 1;\n            }\n\n            return this;\n        },\n\n        /**\n         * Goes to the last page.\n         *\n         * @returns {Paging} Chainable.\n         */\n        goLast: function () {\n            this.current = this.pages;\n\n            return this;\n        },\n\n        /**\n         * Checks if current page is the first one.\n         *\n         * @returns {Boolean}\n         */\n        isFirst: function () {\n            return this.current === 1;\n        },\n\n        /**\n         * Checks if current page is the last one.\n         *\n         * @returns {Boolean}\n         */\n        isLast: function () {\n            return this.current === this.pages;\n        },\n\n        /**\n         * Updates number of pages.\n         */\n        updateCounter: function () {\n            this.pages = Math.ceil(this.totalRecords / this.pageSize) || 1;\n\n            return this;\n        },\n\n        /**\n         * Calculates new page cursor based on the\n         * previous and current page size values.\n         */\n        updateCursor: function () {\n            var cursor = this.current - 1,\n                size = this.pageSize,\n                oldSize = _.isUndefined(this.previousSize) ? this.pageSize : this.previousSize,\n                delta = cursor * (oldSize - size) / size;\n\n            delta = size > oldSize ?\n                Math.ceil(delta) :\n                Math.floor(delta);\n\n            cursor += delta + 1;\n\n            this.previousSize = size;\n\n            this.setPage(cursor);\n\n            return this;\n        },\n\n        /**\n         * Converts provided value to a number and puts\n         * it in range between 1 and total amount of pages.\n         *\n         * @param {(Number|String)} value - Value to be normalized.\n         * @returns {Number}\n         */\n        normalize: function (value) {\n            value = +value;\n\n            if (isNaN(value)) {\n                return 1;\n            }\n\n            return utils.inRange(Math.round(value), 1, this.pages);\n        },\n\n        /**\n         * Handles changes of the page size.\n         */\n        onPageSizeChange: function () {\n            this.updateCounter()\n                .updateCursor();\n        },\n\n        /**\n         * Handles changes of the pages amount.\n         */\n        onPagesChange: function () {\n            this.updateCursor();\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/editor-view.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'uiRegistry',\n    'uiClass'\n], function (ko, $, _, registry, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            rootSelector: '${ $.columnsProvider }:.admin__data-grid-wrap',\n            tableSelector: '${ $.rootSelector } -> table',\n            rowSelector: '${ $.tableSelector } tbody tr.data-row',\n            headerButtonsTmpl:\n                '<!-- ko template: headerButtonsTmpl --><!-- /ko -->',\n            bulkTmpl:\n                '<!-- ko scope: bulk -->' +\n                    '<!-- ko template: getTemplate() --><!-- /ko -->' +\n                '<!-- /ko -->',\n            rowTmpl:\n                '<!-- ko with: _editor -->' +\n                    '<!-- ko if: isActive($row()._rowIndex, true) -->' +\n                        '<!-- ko with: getRecord($row()._rowIndex, true) -->' +\n                            '<!-- ko template: rowTmpl --><!-- /ko -->' +\n                        '<!-- /ko -->' +\n                        '<!-- ko if: isSingleEditing && singleEditingButtons -->' +\n                            '<!-- ko template: rowButtonsTmpl --><!-- /ko -->' +\n                        '<!-- /ko -->' +\n                    '<!-- /ko -->' +\n               '<!-- /ko -->'\n        },\n\n        /**\n         * Initializes view component.\n         *\n         * @returns {View} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'initRoot',\n                'initTable',\n                'initRow',\n                'rowBindings',\n                'tableBindings'\n            );\n\n            this._super();\n\n            this.model = registry.get(this.model);\n\n            $.async(this.rootSelector, this.initRoot);\n            $.async(this.tableSelector, this.initTable);\n            $.async(this.rowSelector, this.initRow);\n\n            return this;\n        },\n\n        /**\n         * Initializes columns root container.\n         *\n         * @param {HTMLElement} node\n         * @returns {View} Chainable.\n         */\n        initRoot: function (node) {\n            $(this.headerButtonsTmpl)\n                .insertBefore(node)\n                .applyBindings(this.model);\n\n            return this;\n        },\n\n        /**\n         * Initializes table element.\n         *\n         * @param {HTMLTableElement} table\n         * @returns {View} Chainable.\n         */\n        initTable: function (table) {\n            $(table).bindings(this.tableBindings);\n\n            this.initBulk(table);\n\n            return this;\n        },\n\n        /**\n         * Initializes bulk editor element\n         * for the provided table.\n         *\n         * @param {HTMLTableElement} table\n         * @returns {View} Chainable.\n         */\n        initBulk: function (table) {\n            var tableBody = $('tbody', table)[0];\n\n            $(this.bulkTmpl)\n                .prependTo(tableBody)\n                .applyBindings(this.model);\n\n            return this;\n        },\n\n        /**\n         * Initializes table row.\n         *\n         * @param {HTMLTableRowElement} row\n         * @returns {View} Chainable.\n         */\n        initRow: function (row) {\n            var $editingRow;\n\n            $(row).extendCtx({\n                    _editor: this.model\n                }).bindings(this.rowBindings);\n\n            $editingRow = $(this.rowTmpl)\n                .insertBefore(row)\n                .applyBindings(row);\n\n            ko.utils.domNodeDisposal.addDisposeCallback(row, this.removeEditingRow.bind(this, $editingRow));\n\n            return this;\n        },\n\n        /**\n         * Returns row bindings.\n         *\n         * @param {Object} ctx - Current context of a row.\n         * @returns {Object}\n         */\n        rowBindings: function (ctx) {\n            var model = this.model;\n\n            return {\n                visible: ko.computed(function () {\n                    var record = ctx.$row(),\n                        index = record && record._rowIndex;\n\n                    return !model.isActive(index, true);\n                })\n            };\n        },\n\n        /**\n         * Returns table bindings.\n         *\n         * @returns {Object}\n         */\n        tableBindings: function () {\n            var model = this.model;\n\n            return {\n                css: {\n                    '_in-edit': ko.computed(function () {\n                        return model.hasActive() && !model.permanentlyActive;\n                    })\n                }\n            };\n        },\n\n        /**\n         * Removes specified array of nodes.\n         *\n         * @param {ArrayLike} row\n         */\n        removeEditingRow: function (row) {\n            _.toArray(row).forEach(ko.removeNode);\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/client.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'uiClass'\n], function ($, _, utils, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            validateBeforeSave: true,\n            requestConfig: {\n                dataType: 'json',\n                type: 'POST'\n            }\n        },\n\n        /**\n         * Initializes client instance.\n         *\n         * @returns {Client} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'onSuccess', 'onError');\n\n            return this._super();\n        },\n\n        /**\n         * Sends XMLHttpRequest with a provided configuration.\n         *\n         * @param {Object} config - Configuration of request.\n         * @returns {jQueryPromise}\n         */\n        send: function (config) {\n            var deffer  = $.Deferred();\n\n            config = utils.extend({}, this.requestConfig, config);\n\n            $.ajax(config)\n                .done(_.partial(this.onSuccess, deffer))\n                .fail(_.partial(this.onError, deffer));\n\n            return deffer.promise();\n        },\n\n        /**\n         * Proxy save method which might invoke\n         * data validation prior to its' saving.\n         *\n         * @param {Object} data - Data to be processed.\n         * @returns {jQueryPromise}\n         */\n        save: function (data) {\n            var save = this._save.bind(this, data);\n\n            return this.validateBeforeSave ?\n                this.validate(data).pipe(save) :\n                save();\n        },\n\n        /**\n         * Sends request to validate provided data.\n         *\n         * @param {Object} data - Data to be validated.\n         * @returns {jQueryPromise}\n         */\n        validate: function (data) {\n            return this.send({\n                url: this.validateUrl,\n                data: data\n            });\n        },\n\n        /**\n         * Sends request to save provided data.\n         *\n         * @private\n         * @param {Object} data - Data to be validated.\n         * @returns {jQueryPromise}\n         */\n        _save: function (data) {\n            return this.send({\n                url: this.saveUrl,\n                data: data\n            });\n        },\n\n        /**\n         * Creates error object with a provided message.\n         *\n         * @param {String} msg - Errors' message.\n         * @returns {Object}\n         */\n        createError: function (msg) {\n            return {\n                type: 'error',\n                message: msg\n            };\n        },\n\n        /**\n         * Handles ajax error callback.\n         *\n         * @param {jQueryPromise} promise - Promise to be rejected.\n         * @param {jQueryXHR} xhr - See 'jquery' ajax error callback.\n         * @param {String} status - See 'jquery' ajax error callback.\n         * @param {(String|Object)} err - See 'jquery' ajax error callback.\n         */\n        onError: function (promise, xhr, status, err) {\n            var msg;\n\n            msg = xhr.status !== 200 ?\n                xhr.status + ' (' + xhr.statusText + ')' :\n                err;\n\n            promise.reject(this.createError(msg));\n        },\n\n        /**\n         * Handles ajax success callback.\n         *\n         * @param {jQueryPromise} promise - Promise to be resolved.\n         * @param {*} data - See 'jquery' ajax success callback.\n         */\n        onSuccess: function (promise, data) {\n            var errors;\n\n            if (data.error) {\n                errors = _.map(data.messages, this.createError, this);\n\n                promise.reject(errors);\n            } else {\n                promise.resolve(data);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/editor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'mage/translate',\n    'uiCollection'\n], function (_, utils, layout, $t, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            rowButtonsTmpl: 'ui/grid/editing/row-buttons',\n            headerButtonsTmpl: 'ui/grid/editing/header-buttons',\n            successMsg: $t('You have successfully saved your edits.'),\n            errorsCount: 0,\n            bulkEnabled: true,\n            multiEditingButtons: true,\n            singleEditingButtons: true,\n            isMultiEditing: false,\n            isSingleEditing: false,\n            permanentlyActive: false,\n            rowsData: [],\n            fields: {},\n\n            templates: {\n                record: {\n                    parent: '${ $.$data.editor.name }',\n                    name: '${ $.$data.recordId }',\n                    component: 'Magento_Ui/js/grid/editing/record',\n                    columnsProvider: '${ $.$data.editor.columnsProvider }',\n                    editorProvider: '${ $.$data.editor.name }',\n                    preserveFields: {\n                        '${ $.$data.editor.indexField }': true\n                    }\n                }\n            },\n            bulkConfig: {\n                component: 'Magento_Ui/js/grid/editing/bulk',\n                name: '${ $.name }_bulk',\n                editorProvider: '${ $.name }',\n                columnsProvider: '${ $.columnsProvider }'\n            },\n            clientConfig: {\n                component: 'Magento_Ui/js/grid/editing/client',\n                name: '${ $.name }_client'\n            },\n            viewConfig: {\n                component: 'Magento_Ui/js/grid/editing/editor-view',\n                name: '${ $.name }_view',\n                model: '${ $.name }',\n                columnsProvider: '${ $.columnsProvider }'\n            },\n            imports: {\n                rowsData: '${ $.dataProvider }:data.items'\n            },\n            listens: {\n                '${ $.dataProvider }:reloaded': 'cancel',\n                '${ $.selectProvider }:selected': 'onSelectionsChange'\n            },\n            modules: {\n                source: '${ $.dataProvider }',\n                client: '${ $.clientConfig.name }',\n                columns: '${ $.columnsProvider }',\n                bulk: '${ $.bulkConfig.name }',\n                selections: '${ $.selectProvider }'\n            }\n        },\n\n        /**\n         * Initializes editor component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'updateState', 'countErrors', 'onDataSaved', 'onSaveError');\n\n            this._super()\n                .initBulk()\n                .initClient()\n                .initView();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'errorsCount',\n                    'isMultiEditing',\n                    'isSingleEditing',\n                    'isSingleColumnEditing',\n                    'changed'\n                ])\n                .observe({\n                    canSave: true,\n                    activeRecords: [],\n                    messages: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Initializes bulk editing component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initBulk: function () {\n            if (this.bulkEnabled) {\n                layout([this.bulkConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes editors' view component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initView: function () {\n            layout([this.viewConfig]);\n\n            return this;\n        },\n\n        /**\n         * Initializes client component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initClient: function () {\n            layout([this.clientConfig]);\n\n            return this;\n        },\n\n        /**\n         * Creates instance of a new record.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        initRecord: function (id, isIndex) {\n            var record = this.buildRecord(id, isIndex);\n\n            layout([record]);\n\n            return this;\n        },\n\n        /**\n         * Adds listeners on a new record.\n         *\n         * @param {Record} record\n         * @returns {Editor} Chainable.\n         */\n        initElement: function (record) {\n            record.on({\n                'active': this.updateState,\n                'errorsCount': this.countErrors\n            });\n\n            this.updateState();\n\n            return this._super();\n        },\n\n        /**\n         * Creates configuration for a new record associated with a row data.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Object} Record configuration.\n         */\n        buildRecord: function (id, isIndex) {\n            var recordId = this.getId(id, isIndex),\n                recordTmpl = this.templates.record,\n                record;\n\n            if (this.getRecord(recordId)) {\n                return this;\n            }\n\n            record = utils.template(recordTmpl, {\n                editor: this,\n                recordId: id\n            });\n\n            record.recordId = id;\n            record.data     = this.getRowData(id);\n\n            return record;\n        },\n\n        /**\n         * Starts editing of a specified record. If records'\n         * instance doesn't exist, than it will be created.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        edit: function (id, isIndex) {\n            var recordId = this.getId(id, isIndex),\n                record   = this.getRecord(recordId);\n\n            record ?\n                record.active(true) :\n                this.initRecord(recordId);\n\n            return this;\n        },\n\n        /**\n         * Drops list of selections while activating only the specified record.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        startEdit: function (id, isIndex) {\n            var recordId = this.getId(id, isIndex);\n\n            this.selections()\n                .deselectAll()\n                .select(recordId);\n\n            return this.edit(recordId);\n        },\n\n        /**\n         * Hides records and resets theirs data.\n         *\n         * @returns {Editor} Chainable.\n         */\n        cancel: function () {\n            this.reset()\n                .hide()\n                .clearMessages()\n                .bulk('clear');\n\n            return this;\n        },\n\n        /**\n         * Hides records.\n         *\n         * @returns {Editor} Chainable.\n         */\n        hide: function () {\n            this.activeRecords.each('active', false);\n\n            return this;\n        },\n\n        /**\n         * Resets active records.\n         *\n         * @returns {Editor} Chainable.\n         */\n        reset: function () {\n            this.elems.each(function (record) {\n                this.resetRecord(record.recordId);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Validates and saves data of active records.\n         *\n         * @returns {Editor} Chainable.\n         */\n        save: function () {\n            var data;\n\n            if (!this.isValid()) {\n                return this;\n            }\n\n            data = {\n                items: this.getData()\n            };\n\n            this.clearMessages()\n                .columns('showLoader');\n\n            this.client()\n                .save(data)\n                .done(this.onDataSaved)\n                .fail(this.onSaveError);\n\n            return this;\n        },\n\n        /**\n         * Validates all active records.\n         *\n         * @returns {Array} An array of records and theirs validation results.\n         */\n        validate: function () {\n            return this.activeRecords.map(function (record) {\n                return {\n                    target: record,\n                    valid: record.isValid()\n                };\n            });\n        },\n\n        /**\n         * Checks if all active records are valid.\n         *\n         * @returns {Boolean}\n         */\n        isValid: function () {\n            return _.every(this.validate(), 'valid');\n        },\n\n        /**\n         * Returns active records data, indexed by a theirs ids.\n         *\n         * @returns {Object} Collection of records data.\n         */\n        getData: function () {\n            var data = this.activeRecords.map('getData');\n\n            return _.indexBy(data, this.indexField);\n        },\n\n        /**\n         * Sets provided data to all active records.\n         *\n         * @param {Object} data - See 'setData' method of a 'Record'.\n         * @param {Boolean} partial - See 'setData' method of a 'Record'.\n         * @returns {Editor} Chainable.\n         */\n        setData: function (data, partial) {\n            this.activeRecords.each('setData', data, partial);\n\n            return this;\n        },\n\n        /**\n         * Resets specific records' data\n         * to the data present in associated row.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        resetRecord: function (id, isIndex) {\n            var record  = this.getRecord(id, isIndex),\n                data    = this.getRowData(id, isIndex);\n\n            if (record && data) {\n                record.setData(data);\n            }\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a specified record.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Record}\n         */\n        getRecord: function (id, isIndex) {\n            return this.elems.findWhere({\n                recordId: this.getId(id, isIndex)\n            });\n        },\n\n        /**\n         * Creates record name based on a provided id.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {String}\n         */\n        formRecordName: function (id, isIndex) {\n            id = this.getId(id, isIndex);\n\n            return this.name + '.' + id;\n        },\n\n        /**\n         * Disables editing of specified fields.\n         *\n         * @param {Array} fields - An array of fields indexes to be disabled.\n         * @returns {Editor} Chainable.\n         */\n        disableFields: function (fields) {\n            var columns = this.columns().elems(),\n                data    = utils.copy(this.fields);\n\n            columns.forEach(function (column) {\n                var index = column.index,\n                    field = data[index] = data[index] || {};\n\n                field.disabled = _.contains(fields, index);\n            });\n\n            this.set('fields', data);\n\n            return this;\n        },\n\n        /**\n         * Converts index of a row into the record id.\n         *\n         * @param {(Number|String)} id - Records' identifier or its' index in the rows array.\n         * @param {Boolean} [isIndex=false] - Flag that indicates if first\n         *      parameter is an index or identifier.\n         * @returns {String} Records' id.\n         */\n        getId: function (id, isIndex) {\n            var rowsData = this.rowsData,\n                record;\n\n            if (isIndex === true) {\n                record  = rowsData[id];\n                id      = record ? record[this.indexField] : false;\n            }\n\n            return id;\n        },\n\n        /**\n         * Returns data of a specified row.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Object}\n         */\n        getRowData: function (id, isIndex) {\n            id = this.getId(id, isIndex);\n\n            return _.find(this.rowsData, function (row) {\n                return row[this.indexField] === id;\n            }, this);\n        },\n\n        /**\n         * Checks if specified record is active.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See'getId' method.\n         * @returns {Boolean}\n         */\n        isActive: function (id, isIndex) {\n            var record = this.getRecord(id, isIndex);\n\n            return _.contains(this.activeRecords(), record);\n        },\n\n        /**\n         * Checks if editor has active records.\n         *\n         * @returns {Boolean}\n         */\n        hasActive: function () {\n            return !!this.activeRecords().length || this.permanentlyActive;\n        },\n\n        /**\n         * Counts number of active records.\n         *\n         * @returns {Number}\n         */\n        countActive: function () {\n            return this.activeRecords().length;\n        },\n\n        /**\n         * Counts number of invalid fields across all active records.\n         *\n         * @returns {Number}\n         */\n        countErrors: function () {\n            var errorsCount = 0;\n\n            this.activeRecords.each(function (record) {\n                errorsCount += record.errorsCount;\n            });\n\n            this.errorsCount = errorsCount;\n\n            return errorsCount;\n        },\n\n        /**\n         * Translatable error message text.\n         *\n         * @returns {String}\n         */\n        countErrorsMessage: function () {\n            return $t('There are {placeholder} messages requires your attention.')\n                .replace('{placeholder}', this.countErrors());\n        },\n\n        /**\n         * Checks if editor has any errors.\n         *\n         * @returns {Boolean}\n         */\n        hasErrors: function () {\n            return !!this.countErrors();\n        },\n\n        /**\n         * Handles changes of the records 'active' property.\n         *\n         * @returns {Editor} Chainable.\n         */\n        updateState: function () {\n            var active      = this.elems.filter('active'),\n                activeCount = active.length,\n                columns     = this.columns().elems;\n\n            columns.each('disableAction', !!activeCount);\n\n            this.isMultiEditing = activeCount > 1;\n            this.isSingleEditing = activeCount === 1;\n\n            this.activeRecords(active);\n\n            return this;\n        },\n\n        /**\n         * Returns list of selections from a current page.\n         *\n         * @returns {Array}\n         */\n        getSelections: function () {\n            return this.selections().getPageSelections();\n        },\n\n        /**\n         * Starts editing of selected records. If record\n         * is not in the selections list, then it will get hidden.\n         *\n         * @returns {Editor} Chainable.\n         */\n        editSelected: function () {\n            var selections = this.getSelections();\n\n            this.elems.each(function (record) {\n                if (!_.contains(selections, record.recordId)) {\n                    record.active(false);\n                }\n            });\n\n            selections.forEach(function (id) {\n                this.edit(id);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Checks if there is any additional messages.\n         *\n         * @returns {Boolean}\n         */\n        hasMessages: function () {\n            return this.messages().length;\n        },\n\n        /**\n         * Adds new additional message or a set of messages.\n         *\n         * @param {(Object|Array)} message - Messages to be added.\n         * @returns {Editor} Chainable.\n         */\n        addMessage: function (message) {\n            var messages = this.messages();\n\n            Array.isArray(message) ?\n                messages.push.apply(messages, message) :\n                messages.push(message);\n\n            this.messages(messages);\n\n            return this;\n        },\n\n        /**\n         * Removes all additional messages.\n         *\n         * @returns {Editor} Chainable.\n         */\n        clearMessages: function () {\n            this.messages.removeAll();\n\n            return this;\n        },\n\n        /**\n         * Listener of the selections data changes.\n         */\n        onSelectionsChange: function () {\n            if (this.hasActive()) {\n                this.editSelected();\n            }\n        },\n\n        /**\n         * Handles successful save request.\n         */\n        onDataSaved: function () {\n            var msg = {\n                type: 'success',\n                message: this.successMsg\n            };\n\n            this.addMessage(msg)\n                .source('reload', {\n                    refresh: true\n                });\n        },\n\n        /**\n         * Handles failed save request.\n         *\n         * @param {(Array|Object)} errors - List of errors or a single error object.\n         */\n        onSaveError: function (errors) {\n            this.addMessage(errors)\n                .columns('hideLoader');\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/bulk.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    './record'\n], function (_, utils, Record) {\n    'use strict';\n\n    /**\n     * Removes empty properties from the provided object.\n     *\n     * @param {Object} data - Object to be processed.\n     * @returns {Object}\n     */\n    function removeEmpty(data) {\n        data = utils.flatten(data);\n        data = _.omit(data, utils.isEmpty);\n\n        return utils.unflatten(data);\n    }\n\n    return Record.extend({\n        defaults: {\n            template: 'ui/grid/editing/bulk',\n            active: false,\n            templates: {\n                fields: {\n                    select: {\n                        caption: ' '\n                    }\n                }\n            },\n            imports: {\n                active: '${ $.editorProvider }:isMultiEditing'\n            },\n            listens: {\n                data: 'updateState',\n                active: 'updateState'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Bulk} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    hasData: false\n                });\n\n            return this;\n        },\n\n        /**\n         * Extends original method to disable possible\n         * 'required-entry' validation rule.\n         *\n         * @returns {Object} Columns' field definition.\n         */\n        buildField: function () {\n            var field = this._super(),\n                rules = field.validation;\n\n            if (rules) {\n                delete rules['required-entry'];\n            }\n\n            return field;\n        },\n\n        /**\n         * Applies current data to all active records.\n         *\n         * @returns {Bulk} Chainable.\n         */\n        apply: function () {\n            if (this.isValid()) {\n                this.applyData()\n                    .clear();\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets available data to all active records.\n         *\n         * @param {Object} [data] -  If not specified, then current fields data will be used.\n         * @returns {Bulk} Chainable.\n         */\n        applyData: function (data) {\n            data = data || this.getData();\n\n            this.editor('setData', data, true);\n\n            return this;\n        },\n\n        /**\n         * Returns data of all non-empty fields.\n         *\n         * @returns {Object} Fields data without empty values.\n         */\n        getData: function () {\n            return removeEmpty(this._super());\n        },\n\n        /**\n         * Updates own 'hasData' property and defines\n         * whether regular rows editing can be resumed.\n         *\n         * @returns {Bulk} Chainable.\n         */\n        updateState: function () {\n            var fields  = _.keys(this.getData()),\n                hasData = !!fields.length;\n\n            this.hasData = hasData;\n\n            if (!this.active()) {\n                fields = [];\n            }\n\n            this.editor('disableFields', fields);\n            this.editor('canSave', !fields.length);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/record.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'uiCollection'\n], function (_, utils, layout, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            active: true,\n            hasChanges: false,\n            fields: [],\n            errorsCount: 0,\n            fieldTmpl: 'ui/grid/editing/field',\n            rowTmpl: 'ui/grid/editing/row',\n            templates: {\n                fields: {\n                    base: {\n                        parent: '${ $.$data.record.name }',\n                        name: '${ $.$data.column.index }',\n                        provider: '${ $.$data.record.name }',\n                        dataScope: 'data.${ $.$data.column.index }',\n                        imports: {\n                            disabled: '${ $.$data.record.parentName }:fields.${ $.$data.column.index }.disabled'\n                        },\n                        isEditor: true\n                    },\n                    text: {\n                        component: 'Magento_Ui/js/form/element/abstract',\n                        template: 'ui/form/element/input'\n                    },\n                    date: {\n                        component: 'Magento_Ui/js/form/element/date',\n                        template: 'ui/form/element/date',\n                        dateFormat: 'MMM d, y h:mm:ss a'\n                    },\n                    select: {\n                        component: 'Magento_Ui/js/form/element/select',\n                        template: 'ui/form/element/select',\n                        options: '${ JSON.stringify($.$data.column.options) }'\n                    }\n                }\n            },\n            ignoreTmpls: {\n                data: true\n            },\n            listens: {\n                elems: 'updateFields',\n                data: 'updateState'\n            },\n            imports: {\n                onColumnsUpdate: '${ $.columnsProvider }:elems'\n            },\n            modules: {\n                columns: '${ $.columnsProvider }',\n                editor: '${ $.editorProvider }'\n            }\n        },\n\n        /**\n         * Initializes record component.\n         *\n         * @returns {Record} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'countErrors');\n            utils.limit(this, 'updateState', 10);\n\n            return this._super();\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Record} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('errorsCount hasChanges')\n                .observe('active fields');\n\n            return this;\n        },\n\n        /**\n         * Adds listeners on a field.\n         *\n         * @returns {Record} Chainable.\n         */\n        initElement: function (field) {\n            field.on('error', this.countErrors);\n\n            return this._super();\n        },\n\n        /**\n         * Creates new instance of a field.\n         *\n         * @param {Column} column - Column instance which contains field definition.\n         * @returns {Record} Chainable.\n         */\n        initField: function (column) {\n            var field = this.buildField(column);\n\n            layout([field]);\n\n            return this;\n        },\n\n        /**\n         * Builds fields' configuration described in a provided column.\n         *\n         * @param {Column} column - Column instance which contains field definition.\n         * @returns {Object} Complete fields' configuration.\n         */\n        buildField: function (column) {\n            var fields = this.templates.fields,\n                field  = column.editor;\n\n            if (_.isObject(field) && field.editorType) {\n                field = utils.extend({}, fields[field.editorType], field);\n            } else if (_.isString(field)) {\n                field = fields[field];\n            }\n\n            field = utils.extend({}, fields.base, field);\n\n            return utils.template(field, {\n                record: this,\n                column: column\n            }, true, true);\n        },\n\n        /**\n         * Creates fields for the specified columns.\n         *\n         * @param {Array} columns - An array of column instances.\n         * @returns {Record} Chainable.\n         */\n        createFields: function (columns) {\n            columns.forEach(function (column) {\n                if (column.editor && !this.hasChild(column.index)) {\n                    this.initField(column);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a column found by provided index.\n         *\n         * @param {String} index - Index of a column (e.g. 'title').\n         * @returns {Column}\n         */\n        getColumn: function (index) {\n            return this.columns().getChild(index);\n        },\n\n        /**\n         * Returns records' current data object.\n         *\n         * @returns {Object}\n         */\n        getData: function () {\n            return this.filterData(this.data);\n        },\n\n        /**\n         * Returns saved records' data. Data will be processed\n         * with a 'filterData' and 'normalizeData' methods.\n         *\n         * @returns {Object} Saved records' data.\n         */\n        getSavedData: function () {\n            var editor      = this.editor(),\n                savedData   = editor.getRowData(this.index);\n\n            savedData = this.filterData(savedData);\n\n            return this.normalizeData(savedData);\n        },\n\n        /**\n         * Replaces current records' data with the provided one.\n         *\n         * @param {Object} data - New records data.\n         * @param {Boolean} [partial=false] - Flag that defines whether\n         *      to completely replace current data or to extend it.\n         * @returns {Record} Chainable.\n         */\n        setData: function (data, partial) {\n            var currentData = partial ? this.data : {};\n\n            data = this.normalizeData(data);\n            data = utils.extend({}, currentData, data);\n\n            this.set('data', data)\n                .updateState();\n\n            return this;\n        },\n\n        /**\n         * Filters provided object extracting from it values\n         * that can be matched with an existing fields.\n         *\n         * @param {Object} data - Object to be processed.\n         * @returns {Object}\n         */\n        filterData: function (data) {\n            var fields = _.pluck(this.elems(), 'index');\n\n            _.each(this.preserveFields, function (enabled, field) {\n                if (enabled && !_.contains(fields, field)) {\n                    fields.push(field);\n                }\n            });\n\n            return _.pick(data, fields);\n        },\n\n        /**\n         * Parses values of a provided object with\n         * a 'normalizeData' method of a corresponding field.\n         *\n         * @param {Object} data - Data to be processed.\n         * @returns {Object}\n         */\n        normalizeData: function (data) {\n            var index;\n\n            this.elems.each(function (elem) {\n                index = elem.index;\n\n                if (data.hasOwnProperty(index)) {\n                    data[index] = elem.normalizeData(data[index]);\n                }\n            });\n\n            return data;\n        },\n\n        /**\n         * Clears values of all fields.\n         *\n         * @returns {Record} Chainable.\n         */\n        clear: function () {\n            this.elems.each('clear');\n\n            return this;\n        },\n\n        /**\n         * Validates all of the available fields.\n         *\n         * @returns {Array} An array with validation results.\n         */\n        validate: function () {\n            return this.elems.map('validate');\n        },\n\n        /**\n         * Checks if all fields are valid.\n         *\n         * @returns {Boolean}\n         */\n        isValid: function () {\n            return _.every(this.validate(), 'valid');\n        },\n\n        /**\n         * Counts total errors amount across all fields.\n         *\n         * @returns {Number}\n         */\n        countErrors: function () {\n            var errorsCount = this.elems.filter('error').length;\n\n            this.errorsCount = errorsCount;\n\n            return errorsCount;\n        },\n\n        /**\n         * Returns difference between current data and its'\n         * initial state, retrieved from the records collection.\n         *\n         * @returns {Object} Object with changes descriptions.\n         */\n        checkChanges: function () {\n            var savedData   = this.getSavedData(),\n                data        = this.normalizeData(this.getData());\n\n            return utils.compare(savedData, data);\n        },\n\n        /**\n         * Updates 'fields' array filling it with available editors\n         * or with column instances if associated field is not present.\n         *\n         * @returns {Record} Chainable.\n         */\n        updateFields: function () {\n            var fields;\n\n            fields = this.columns().elems.map(function (column) {\n                return this.getChild(column.index) || column;\n            }, this);\n\n            this.fields(fields);\n\n            return this;\n        },\n\n        /**\n         * Updates state of a 'hasChanges' property.\n         *\n         * @returns {Record} Chainable.\n         */\n        updateState: function () {\n            var diff = this.checkChanges(),\n                changed = {};\n\n            this.hasChanges = !diff.equal;\n            changed[this.index] = this.data;\n            this.editor().set('changed', [changed]);\n\n            return this;\n        },\n\n        /**\n         * Checks if provided column is an actions column.\n         *\n         * @param {Column} column - Column to be checked.\n         * @returns {Boolean}\n         */\n        isActionsColumn: function (column) {\n            return column.dataType === 'actions';\n        },\n\n        /**\n         * Listener of columns provider child array changes.\n         *\n         * @param {Array} columns - Modified child elements array.\n         */\n        onColumnsUpdate: function (columns) {\n            this.createFields(columns)\n                .updateFields();\n        }\n    });\n});\n","Magento_Ui/js/grid/filters/range.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiLayout',\n    'mageUtils',\n    'Magento_Ui/js/form/components/group',\n    'mage/translate'\n], function (_, layout, utils, Group, $t) {\n    'use strict';\n\n    return Group.extend({\n        defaults: {\n            template: 'ui/grid/filters/elements/group',\n            isRange: true,\n            templates: {\n                base: {\n                    parent: '${ $.$data.group.name }',\n                    provider: '${ $.$data.group.provider }',\n                    template: 'ui/grid/filters/field'\n                },\n                date: {\n                    component: 'Magento_Ui/js/form/element/date',\n                    dateFormat: 'MM/dd/YYYY',\n                    shiftedValue: 'filter'\n                },\n                text: {\n                    component: 'Magento_Ui/js/form/element/abstract'\n                },\n                ranges: {\n                    from: {\n                        label: $t('from'),\n                        dataScope: 'from'\n                    },\n                    to: {\n                        label: $t('to'),\n                        dataScope: 'to'\n                    }\n                }\n            }\n        },\n\n        /**\n         * Initializes range component.\n         *\n         * @returns {Range} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initChildren();\n\n            return this;\n        },\n\n        /**\n         * Creates instances of child components.\n         *\n         * @returns {Range} Chainable.\n         */\n        initChildren: function () {\n            var children = this.buildChildren();\n\n            layout(children);\n\n            return this;\n        },\n\n        /**\n         * Creates configuration for the child components.\n         *\n         * @returns {Object}\n         */\n        buildChildren: function () {\n            var templates   = this.templates,\n                typeTmpl    = templates[this.rangeType],\n                tmpl        = utils.extend({}, templates.base, typeTmpl),\n                children    = {};\n\n            _.each(templates.ranges, function (range, key) {\n                children[key] = utils.extend({}, tmpl, range);\n            });\n\n            return utils.template(children, {\n                group: this\n            }, true, true);\n        },\n\n        /**\n         * Clears childrens data.\n         *\n         * @returns {Range} Chainable.\n         */\n        clear: function () {\n            this.elems.each('clear');\n\n            return this;\n        },\n\n        /**\n         * Checks if some children has data.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return this.elems.some('hasData');\n        }\n    });\n});\n","Magento_Ui/js/grid/filters/filters.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'uiCollection',\n    'mage/translate',\n    'jquery'\n], function (_, utils, layout, Collection, $t, $) {\n    'use strict';\n\n    /**\n     * Extracts and formats preview of an element.\n     *\n     * @param {Object} elem - Element whose preview should be extracted.\n     * @returns {Object} Formatted data.\n     */\n    function extractPreview(elem) {\n        return {\n            label: elem.label,\n            preview: elem.getPreview(),\n            elem: elem\n        };\n    }\n\n    /**\n     * Removes empty properties from the provided object.\n     *\n     * @param {Object} data - Object to be processed.\n     * @returns {Object}\n     */\n    function removeEmpty(data) {\n        var result = utils.mapRecursive(data, utils.removeEmptyValues.bind(utils));\n\n        return utils.mapRecursive(result, function (value) {\n            return _.isString(value) ? value.trim() : value;\n        });\n    }\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/filters/filters',\n            stickyTmpl: 'ui/grid/sticky/filters',\n            _processed: [],\n            columnsProvider: 'ns = ${ $.ns }, componentType = columns',\n            bookmarksProvider: 'ns = ${ $.ns }, componentType = bookmark',\n            applied: {\n                placeholder: true\n            },\n            filters: {\n                placeholder: true\n            },\n            templates: {\n                filters: {\n                    base: {\n                        parent: '${ $.$data.filters.name }',\n                        name: '${ $.$data.column.index }',\n                        provider: '${ $.$data.filters.name }',\n                        dataScope: '${ $.$data.column.index }',\n                        label: '${ $.$data.column.label }',\n                        imports: {\n                            visible: '${ $.$data.column.name }:visible'\n                        }\n                    },\n                    text: {\n                        component: 'Magento_Ui/js/form/element/abstract',\n                        template: 'ui/grid/filters/field'\n                    },\n                    select: {\n                        component: 'Magento_Ui/js/form/element/select',\n                        template: 'ui/grid/filters/field',\n                        options: '${ JSON.stringify($.$data.column.options) }',\n                        caption: ' '\n                    },\n                    dateRange: {\n                        component: 'Magento_Ui/js/grid/filters/range',\n                        rangeType: 'date'\n                    },\n                    textRange: {\n                        component: 'Magento_Ui/js/grid/filters/range',\n                        rangeType: 'text'\n                    }\n                }\n            },\n            chipsConfig: {\n                name: '${ $.name }_chips',\n                provider: '${ $.chipsConfig.name }',\n                component: 'Magento_Ui/js/grid/filters/chips'\n            },\n            listens: {\n                active: 'updatePreviews',\n                applied: 'cancel updateActive'\n            },\n            statefull: {\n                applied: true\n            },\n            exports: {\n                applied: '${ $.provider }:params.filters'\n            },\n            imports: {\n                onColumnsUpdate: '${ $.columnsProvider }:elems',\n                onBackendError: '${ $.provider }:lastError',\n                bookmarksActiveIndex: '${ $.bookmarksProvider }:activeIndex'\n            },\n            modules: {\n                columns: '${ $.columnsProvider }',\n                chips: '${ $.chipsConfig.provider }'\n            }\n        },\n\n        /**\n         * Initializes filters component.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'updateActive');\n\n            this._super()\n                .initChips()\n                .cancel();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    active: [],\n                    previews: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Initializes chips component.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initChips: function () {\n            layout([this.chipsConfig]);\n\n            this.chips('insertChild', this.name);\n\n            return this;\n        },\n\n        /**\n         * Called when another element was added to filters collection.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initElement: function (elem) {\n            this._super();\n\n            elem.on('elems', this.updateActive);\n\n            this.updateActive();\n\n            return this;\n        },\n\n        /**\n         * Clears filters data.\n         *\n         * @param {Object} [filter] - If provided, then only specified\n         *      filter will be cleared. Otherwise, clears all data.\n         * @returns {Filters} Chainable.\n         */\n        clear: function (filter) {\n            filter ?\n                filter.clear() :\n                _.invoke(this.active, 'clear');\n\n            this.apply();\n\n            return this;\n        },\n\n        /**\n         * Sets filters data to the applied state.\n         *\n         * @returns {Filters} Chainable.\n         */\n        apply: function () {\n            this.set('applied', removeEmpty(this.filters));\n\n            return this;\n        },\n\n        /**\n         * Resets filters to the last applied state.\n         *\n         * @returns {Filters} Chainable.\n         */\n        cancel: function () {\n            this.set('filters', utils.copy(this.applied));\n\n            return this;\n        },\n\n        /**\n         * Sets provided data to filter components (without applying it).\n         *\n         * @param {Object} data - Filters data.\n         * @param {Boolean} [partial=false] - Flag that defines whether\n         *      to completely replace current filters data or to extend it.\n         * @returns {Filters} Chainable.\n         */\n        setData: function (data, partial) {\n            var filters = partial ? this.filters : {};\n\n            data = utils.extend({}, filters, data);\n\n            this.set('filters', data);\n\n            return this;\n        },\n\n        /**\n         * Creates instance of a filter associated with the provided column.\n         *\n         * @param {Column} column - Column component for which to create a filter.\n         * @returns {Filters} Chainable.\n         */\n        addFilter: function (column) {\n            var index       = column.index,\n                processed   = this._processed,\n                filter;\n\n            if (!column.filter || _.contains(processed, index)) {\n                return this;\n            }\n\n            filter = this.buildFilter(column);\n\n            processed.push(index);\n\n            layout([filter]);\n\n            return this;\n        },\n\n        /**\n         * Creates filter component configuration associated with the provided column.\n         *\n         * @param {Column} column - Column component with a basic filter declaration.\n         * @returns {Object} Filters' configuration.\n         */\n        buildFilter: function (column) {\n            var filters = this.templates.filters,\n                filter  = column.filter,\n                type    = filters[filter.filterType];\n\n            if (_.isObject(filter) && type) {\n                filter = utils.extend({}, type, filter);\n            } else if (_.isString(filter)) {\n                filter = filters[filter];\n            }\n\n            filter = utils.extend({}, filters.base, filter);\n            //Accepting labels as is.\n            filter.__disableTmpl = {\n                label: 1,\n                options: 1\n            };\n\n            filter = utils.template(filter, {\n                filters: this,\n                column: column\n            }, true, true);\n\n            filter.__disableTmpl = {\n                label: true\n            };\n\n            return filter;\n        },\n\n        /**\n         * Returns an array of range filters.\n         *\n         * @returns {Array}\n         */\n        getRanges: function () {\n            return this.elems.filter(function (filter) {\n                return filter.isRange;\n            });\n        },\n\n        /**\n         * Returns an array of non-range filters.\n         *\n         * @returns {Array}\n         */\n        getPlain: function () {\n            return this.elems.filter(function (filter) {\n                return !filter.isRange;\n            });\n        },\n\n        /**\n         * Tells wether specified filter should be visible.\n         *\n         * @param {Object} filter\n         * @returns {Boolean}\n         */\n        isFilterVisible: function (filter) {\n            return filter.visible() || this.isFilterActive(filter);\n        },\n\n        /**\n         * Checks if specified filter is active.\n         *\n         * @param {Object} filter\n         * @returns {Boolean}\n         */\n        isFilterActive: function (filter) {\n            return _.contains(this.active, filter);\n        },\n\n        /**\n         * Checks if collection has visible filters.\n         *\n         * @returns {Boolean}\n         */\n        hasVisible: function () {\n            return this.elems.some(this.isFilterVisible, this);\n        },\n\n        /**\n         * Finds filters with a not empty data\n         * and sets them to the 'active' filters array.\n         *\n         * @returns {Filters} Chainable.\n         */\n        updateActive: function () {\n            var applied = _.keys(this.applied);\n\n            this.active = this.elems.filter(function (elem) {\n                return _.contains(applied, elem.index);\n            });\n\n            return this;\n        },\n\n        /**\n         * Returns number of applied filters.\n         *\n         * @returns {Number}\n         */\n        countActive: function () {\n            return this.active.length;\n        },\n\n        /**\n         * Extract previews of a specified filters.\n         *\n         * @param {Array} filters - Filters to be processed.\n         * @returns {Filters} Chainable.\n         */\n        updatePreviews: function (filters) {\n            var previews = filters.map(extractPreview);\n\n            this.previews = _.compact(previews);\n\n            return this;\n        },\n\n        /**\n         * Listener of the columns provider children array changes.\n         *\n         * @param {Array} columns - Current columns list.\n         */\n        onColumnsUpdate: function (columns) {\n            columns.forEach(this.addFilter, this);\n        },\n\n        /**\n         * Provider ajax error listener.\n         *\n         * @param {bool} isError - Selected index of the filter.\n         */\n        onBackendError: function (isError) {\n            var defaultMessage = 'Something went wrong with processing the default view and we have restored the ' +\n                    'filter to its original state.',\n                customMessage  = 'Something went wrong with processing current custom view and filters have been ' +\n                    'reset to its original state. Please edit filters then click apply.';\n\n            if (isError) {\n                this.clear();\n\n                $('body').notification('clear')\n                    .notification('add', {\n                        error: true,\n                        message: $.mage.__(this.bookmarksActiveIndex !== 'default' ? customMessage : defaultMessage),\n\n                        /**\n                         * @param {String} message\n                         */\n                        insertMethod: function (message) {\n                            var $wrapper = $('<div/>').html(message);\n\n                            $('.page-main-actions').after($wrapper);\n                        }\n                    });\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/filters/chips.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiCollection'\n], function (_, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/filters/chips',\n            componentType: 'filtersChips'\n        },\n\n        /**\n         * Defines if some of components' children has available previews.\n         *\n         * @returns {Boolean}\n         */\n        hasPreviews: function () {\n            return this.elems().some(function (elem) {\n                return !!elem.previews.length;\n            });\n        },\n\n        /**\n         * Calls clear method on all of its' children.\n         *\n         * @returns {Chips} Chainable.\n         */\n        clear: function () {\n            _.invoke(this.elems(), 'clear');\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/link.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    './column',\n    'mageUtils'\n], function (Column, utils) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            link: 'link',\n            bodyTmpl: 'ui/grid/cells/link'\n        },\n\n        /**\n         * Returns link to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getLink: function (record) {\n            return utils.nested(record, this.link);\n        },\n\n        /**\n         * Check if link parameter exist in record.\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Boolean}\n         */\n        isLink: function (record) {\n            return !!utils.nested(record, this.link);\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/multiselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mage/translate',\n    './column'\n], function (_, $t, Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/multiselect',\n            bodyTmpl: 'ui/grid/cells/multiselect',\n            controlVisibility: false,\n            sortable: false,\n            draggable: false,\n            menuVisible: false,\n            excludeMode: false,\n            allSelected: false,\n            indetermine: false,\n            preserveSelectionsOnFilter: false,\n            disabled: [],\n            selected: [],\n            excluded: [],\n            fieldClass: {\n                'data-grid-checkbox-cell': true\n            },\n            actions: [{\n                value: 'selectAll',\n                label: $t('Select All')\n            }, {\n                value: 'deselectAll',\n                label: $t('Deselect All')\n            }, {\n                value: 'selectPage',\n                label: $t('Select All on This Page')\n            }, {\n                value: 'deselectPage',\n                label: $t('Deselect All on This Page')\n            }],\n\n            imports: {\n                totalRecords: '${ $.provider }:data.totalRecords',\n                rows: '${ $.provider }:data.items'\n            },\n\n            listens: {\n                '${ $.provider }:params.filters': 'onFilter',\n                selected: 'onSelectedChange',\n                rows: 'onRowsChange'\n            },\n\n            modules: {\n                source: '${ $.provider }'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'disabled',\n                    'selected',\n                    'excluded',\n                    'excludeMode',\n                    'totalSelected',\n                    'allSelected',\n                    'indetermine',\n                    'totalRecords',\n                    'rows'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Selects specified record.\n         *\n         * @param {*} id - See definition of 'getId' method.\n         * @param {Boolean} [isIndex=false] - See definition of 'getId' method.\n         * @returns {Multiselect} Chainable.\n         */\n        select: function (id, isIndex) {\n            this._setSelection(id, isIndex, true);\n\n            return this;\n        },\n\n        /**\n         * Deselects specified record.\n         *\n         * @param {*} id - See definition of 'getId' method.\n         * @param {Boolean} [isIndex=false] - See definition of 'getId' method.\n         * @returns {Multiselect} Chainable.\n         */\n        deselect: function (id, isIndex) {\n            this._setSelection(id, isIndex, false);\n\n            return this;\n        },\n\n        /**\n         * Toggles selection of a specified record.\n         *\n         * @param {*} id - See definition of 'getId' method.\n         * @param {Boolean} [isIndex=false] - See definition of 'getId' method.\n         * @returns {Multiselect} Chainable.\n         */\n        toggleSelect: function (id, isIndex) {\n            this._setSelection(id, isIndex, !this.isSelected(id, isIndex));\n\n            return this;\n        },\n\n        /**\n         * Checks if specified record is selected.\n         *\n         * @param {*} id - See definition of 'getId' method.\n         * @param {Boolean} [isIndex=false] - See definition of 'getId' method.\n         * @returns {Boolean}\n         */\n        isSelected: function (id, isIndex) {\n            id = this.getId(id, isIndex);\n\n            return this.selected.contains(id);\n        },\n\n        /**\n         * Selects/deselects specified record base on a 'select' parameter value.\n         *\n         * @param {*} id - See definition of 'getId' method.\n         * @param {Boolean} [isIndex=false] - See definition of 'getId' method.\n         * @param {Boolean} select - Whether to select/deselect record.\n         * @returns {Multiselect} Chainable.\n         */\n        _setSelection: function (id, isIndex, select) {\n            var selected = this.selected;\n\n            id = this.getId(id, isIndex);\n\n            if (!select && this.isSelected(id)) {\n                selected.remove(id);\n            } else if (select) {\n                selected.push(id);\n            }\n\n            return this;\n        },\n\n        /**\n         * Selects all records, even those that\n         * are not visible on the page.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        selectAll: function () {\n            this.excludeMode(true);\n\n            this.clearExcluded()\n                .selectPage();\n\n            return this;\n        },\n\n        /**\n         * Deselects all records.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        deselectAll: function () {\n            this.excludeMode(false);\n\n            this.clearExcluded();\n            this.selected.removeAll();\n\n            return this;\n        },\n\n        /**\n         * Selects or deselects all records.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        toggleSelectAll: function () {\n            this.allSelected() ?\n                this.deselectAll() :\n                this.selectAll();\n\n            return this;\n        },\n\n        /**\n         * Selects all records on the current page.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        selectPage: function () {\n            var selected = _.union(this.selected(), this.getIds());\n\n            selected = _.difference(selected, this.disabled());\n\n            this.selected(selected);\n\n            return this;\n        },\n\n        /**\n         * Deselects all records on the current page.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        deselectPage: function () {\n            var pageIds = this.getIds();\n\n            this.selected.remove(function (value) {\n                return !!~pageIds.indexOf(value);\n            });\n\n            return this;\n        },\n\n        /**\n        * Selects or deselects all records on the current page.\n        *\n        * @returns {Multiselect} Chainable.\n        */\n        togglePage: function () {\n            return this.isPageSelected() ? this.deselectPage() : this.selectPage();\n        },\n\n        /**\n         * Clears the array of not selected records.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        clearExcluded: function () {\n            this.excluded.removeAll();\n\n            return this;\n        },\n\n        /**\n         * Retrieve all id's from available records.\n         *\n         * @param {Boolean} [exclude] - Whether to exclude not selected ids' from result.\n         * @returns {Array} An array of ids'.\n         */\n        getIds: function (exclude) {\n            var items = this.rows(),\n                ids = _.pluck(items, this.indexField);\n\n            return exclude ?\n                _.difference(ids, this.excluded()) :\n                ids;\n        },\n\n        /**\n         * Returns identifier of a record.\n         *\n         * @param {*} id - Id of a record or its' index in a rows array.\n         * @param {Boolean} [isIndex=false] - Flag that specifies with what\n         *      kind of identifier we are dealing with.\n         * @returns {*}\n         */\n        getId: function (id, isIndex) {\n            var record = this.rows()[id];\n\n            if (isIndex && record) {\n                id = record[this.indexField];\n            }\n\n            return id;\n        },\n\n        /**\n         * Recalculates list of the excluded records.\n         * Changes value of `excluded`.\n         *\n         * @param {Array} selected - List of the currently selected records.\n         * @returns {Multiselect} Chainable.\n         */\n        updateExcluded: function (selected) {\n            var excluded = this.excluded(),\n                fromPage = _.difference(this.getIds(), selected);\n\n            excluded = _.union(excluded, fromPage);\n            excluded = _.difference(excluded, selected);\n\n            this.excluded(excluded);\n\n            return this;\n        },\n\n        /**\n         * Calculates number of selected records and\n         * updates 'totalSelected' property.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        countSelected: function () {\n            var total = this.totalRecords(),\n                excluded = this.excluded().length,\n                selected = this.selected().length;\n\n            if (this.excludeMode()) {\n                selected = total - excluded;\n            }\n\n            this.totalSelected(selected);\n\n            return this;\n        },\n\n        /**\n         * Returns selected items on a current page.\n         *\n         * @returns {Array}\n         */\n        getPageSelections: function () {\n            var ids = this.getIds();\n\n            return this.selected.filter(function (id) {\n                return _.contains(ids, id);\n            });\n        },\n\n        /**\n         * Returns selections data.\n         *\n         * @returns {Object}\n         */\n        getSelections: function () {\n            return {\n                excluded: this.excluded(),\n                selected: this.selected(),\n                total: this.totalSelected(),\n                excludeMode: this.excludeMode(),\n                params: this.getFiltering()\n            };\n        },\n\n        /**\n         * Extracts filtering data from data provider.\n         *\n         * @returns {Object} Current filters state.\n         */\n        getFiltering: function () {\n            var source = this.source(),\n                keys = ['filters', 'search', 'namespace'];\n\n            if (!source) {\n                return {};\n            }\n\n            return _.pick(source.get('params'), keys);\n        },\n\n        /**\n         * Defines if provided select/deselect actions is relevant.\n         * E.g. there is no need in a 'select page' action if only one\n         * page is available.\n         *\n         * @param {String} actionId - Id of the action to be checked.\n         * @returns {Boolean}\n         */\n        isActionRelevant: function (actionId) {\n            var pageIds         = this.getIds().length,\n                multiplePages   = pageIds < this.totalRecords(),\n                relevant        = true;\n\n            switch (actionId) {\n                case 'selectPage':\n                    relevant = multiplePages && !this.isPageSelected(true);\n                    break;\n\n                case 'deselectPage':\n                    relevant =  multiplePages && this.isPageSelected();\n                    break;\n\n                case 'selectAll':\n                    relevant = !this.allSelected();\n                    break;\n\n                case 'deselectAll':\n                    relevant = this.totalSelected() > 0;\n            }\n\n            return relevant;\n        },\n\n        /**\n         * Checks if current page has selected records.\n         *\n         * @param {Boolean} [all=false] - If set to 'true' checks that every\n         *      record on the page is selected. Otherwise checks that\n         *      page has some selected records.\n         * @returns {Boolean}\n         */\n        isPageSelected: function (all) {\n            var pageIds = this.getIds(),\n                selected = this.selected(),\n                excluded = this.excluded(),\n                iterator = all ? 'every' : 'some';\n\n            if (this.allSelected()) {\n                return true;\n            }\n\n            if (this.excludeMode()) {\n                return pageIds[iterator](function (id) {\n                    return !~excluded.indexOf(id);\n                });\n            }\n\n            return pageIds[iterator](function (id) {\n                return !!~selected.indexOf(id);\n            });\n        },\n\n        /**\n         * Updates values of the 'allSelected'\n         * and 'indetermine' properties.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        updateState: function () {\n            var selected        = this.selected().length,\n                excluded        = this.excluded().length,\n                totalSelected   = this.totalSelected(),\n                totalRecords    = this.totalRecords(),\n                allSelected     = totalRecords && totalSelected === totalRecords;\n\n            if (this.excludeMode()) {\n                if (excluded === totalRecords && !this.preserveSelectionsOnFilter) {\n                    this.deselectAll();\n                }\n            } else if (totalRecords && selected === totalRecords && !this.preserveSelectionsOnFilter) {\n                this.selectAll();\n            }\n\n            this.allSelected(allSelected);\n            this.indetermine(totalSelected && !allSelected);\n\n            return this;\n        },\n\n        /**\n         * Overrides base method, because this component\n         * can't have global field action.\n         *\n         * @returns {Boolean} False.\n         */\n        hasFieldAction: function () {\n            return false;\n        },\n\n        /**\n         * Callback method to handle changes of selected items.\n         *\n         * @param {Array} selected - An array of currently selected items.\n         */\n        onSelectedChange: function (selected) {\n            this.updateExcluded(selected)\n                .countSelected()\n                .updateState();\n        },\n\n        /**\n         * Is invoked when rows has changed. Recalculates selected items\n         * based on \"selectMode\" property.\n         */\n        onRowsChange: function () {\n            var newSelections;\n\n            if (this.excludeMode()) {\n                newSelections = _.union(this.getIds(true), this.selected());\n\n                this.selected(newSelections);\n            }\n        },\n\n        /**\n         * Is invoked when filtration is applied or removed\n         */\n        onFilter: function () {\n            if (!this.preserveSelectionsOnFilter) {\n                this.deselectAll();\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    './column',\n    'Magento_Ui/js/modal/confirm',\n    'mage/dataPost'\n], function (_, utils, registry, Column, confirm, dataPost) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/cells/actions',\n            sortable: false,\n            draggable: false,\n            actions: [],\n            rows: [],\n            rowsProvider: '${ $.parentName }',\n            fieldClass: {\n                'data-grid-actions-cell': true\n            },\n            templates: {\n                actions: {}\n            },\n            imports: {\n                rows: '${ $.rowsProvider }:rows'\n            },\n            listens: {\n                rows: 'updateActions'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {ActionsColumn} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('actions');\n\n            return this;\n        },\n\n        /**\n         * Returns specific action of a specified row\n         * or all action objects associated with it.\n         *\n         * @param {Number} rowIndex - Index of a row.\n         * @param {String} [actionIndex] - Action identifier.\n         * @returns {Array|Object}\n         */\n        getAction: function (rowIndex, actionIndex) {\n            var rowActions = this.actions[rowIndex];\n\n            return rowActions && actionIndex ?\n                rowActions[actionIndex] :\n                rowActions;\n        },\n\n        /**\n         * Returns visible actions for a specified row.\n         *\n         * @param {Number} rowIndex - Index of a row.\n         * @returns {Array} Visible actions.\n         */\n        getVisibleActions: function (rowIndex) {\n            var rowActions = this.getAction(rowIndex);\n\n            return _.filter(rowActions, this.isActionVisible, this);\n        },\n\n        /**\n         * Adds new action. If an action with the specified identifier\n         * already exists, then the original will be overridden.\n         *\n         * @param {String} index - Actions' identifier.\n         * @param {Object} action - Actions' data.\n         * @returns {ActionsColumn} Chainable.\n         */\n        addAction: function (index, action) {\n            var actionTmpls = this.templates.actions;\n\n            actionTmpls[index] = action;\n\n            this.updateActions();\n\n            return this;\n        },\n\n        /**\n         * Recreates actions for each row.\n         *\n         * @returns {ActionsColumn} Chainable.\n         */\n        updateActions: function () {\n            this.actions = this.rows.map(this._formatActions, this);\n\n            return this;\n        },\n\n        /**\n         * Processes actions, setting additional information to them and\n         * evaluating their properties as string templates.\n         *\n         * @private\n         * @param {Object} row - Row object.\n         * @param {Number} rowIndex - Index of a row.\n         * @returns {Array}\n         */\n        _formatActions: function (row, rowIndex) {\n            var rowActions      = row[this.index] || {},\n                recordId        = row[this.indexField],\n                customActions   = this.templates.actions;\n\n            /**\n             * Actions iterator.\n             */\n            function iterate(action, index) {\n                action = utils.extend({\n                    index: index,\n                    rowIndex: rowIndex,\n                    recordId: recordId\n                }, action);\n\n                return utils.template(action, row, true);\n            }\n\n            rowActions      = _.mapObject(rowActions, iterate);\n            customActions   = _.map(customActions, iterate);\n\n            customActions.forEach(function (action) {\n                rowActions[action.index] = action;\n            });\n\n            return rowActions;\n        },\n\n        /**\n         * Applies specified action.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @param {Number} rowIndex - Index of a row.\n         * @returns {ActionsColumn} Chainable.\n         */\n        applyAction: function (actionIndex, rowIndex) {\n            var action = this.getAction(rowIndex, actionIndex),\n                callback = this._getCallback(action);\n\n            action.confirm ?\n                this._confirm(action, callback) :\n                callback();\n\n            return this;\n        },\n\n        /**\n         * Creates handler for the provided action if it's required.\n         *\n         * @param {Object} action - Action object.\n         * @returns {Function|Undefined}\n         */\n        getActionHandler: function (action) {\n            var index = action.index,\n                rowIndex = action.rowIndex;\n\n            if (this.isHandlerRequired(index, rowIndex)) {\n                return this.applyAction.bind(this, index, rowIndex);\n            }\n        },\n\n        /**\n         * Returns target of action if it's been set.\n         *\n         * @param {Object} action - Action object.\n         * @returns {String}\n         */\n        getTarget: function (action) {\n            if (action.target) {\n                return action.target;\n            }\n\n            return '_self';\n        },\n\n        /**\n         * Checks if specified action requires a handler function.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @param {Number} rowIndex - Index of a row.\n         * @returns {Boolean}\n         */\n        isHandlerRequired: function (actionIndex, rowIndex) {\n            var action = this.getAction(rowIndex, actionIndex);\n\n            return _.isObject(action.callback) || action.confirm || !action.href;\n        },\n\n        /**\n         * Creates action callback based on it's data. If the action doesn't specify\n         * a callback function than the default one will be used.\n         *\n         * @private\n         * @param {Object} action - Action's object.\n         * @returns {Function} Callback function.\n         */\n        _getCallback: function (action) {\n            var args = [action.index, action.recordId, action],\n                callback = action.callback;\n\n            if (utils.isObject(callback)) {\n                args.unshift(callback.target);\n\n                callback = registry.async(callback.provider);\n            } else if (_.isArray(callback)) {\n                return this._getCallbacks(action);\n            } else if (!_.isFunction(callback)) {\n                callback = this.defaultCallback.bind(this);\n            }\n\n            return function () {\n                callback.apply(callback, args);\n            };\n        },\n\n        /**\n         * Creates action callback for multiple actions.\n         *\n         * @private\n         * @param {Object} action - Action's object.\n         * @returns {Function} Callback function.\n         */\n        _getCallbacks: function (action) {\n            var callback = action.callback,\n                callbacks = [],\n                tmpCallback;\n\n            _.each(callback, function (cb) {\n                tmpCallback = {\n                    action: registry.async(cb.provider),\n                    args: _.compact([cb.target, cb.params])\n                };\n                callbacks.push(tmpCallback);\n            });\n\n            return function () {\n                _.each(callbacks, function (cb) {\n                    cb.action.apply(cb.action, cb.args);\n                });\n            };\n        },\n\n        /**\n         * Default action callback. Redirects to\n         * the specified in action's data url.\n         *\n         * @param {String} actionIndex - Action's identifier.\n         * @param {(Number|String)} recordId - Id of the record associated\n         *      with a specified action.\n         * @param {Object} action - Action's data.\n         */\n        defaultCallback: function (actionIndex, recordId, action) {\n            if (action.post) {\n                dataPost().postData({\n                    action: action.href,\n                    data: {}\n                });\n            } else {\n                window.location.href = action.href;\n            }\n        },\n\n        /**\n         * Shows actions' confirmation window.\n         *\n         * @param {Object} action - Action's data.\n         * @param {Function} callback - Callback that will be\n         *      invoked if action is confirmed.\n         */\n        _confirm: function (action, callback) {\n            var confirmData = action.confirm;\n\n            confirm({\n                title: confirmData.title,\n                content: confirmData.message,\n                actions: {\n                    confirm: callback\n                }\n            });\n        },\n\n        /**\n         * Checks if row has only one visible action.\n         *\n         * @param {Number} rowIndex - Row index.\n         * @returns {Boolean}\n         */\n        isSingle: function (rowIndex) {\n            return this.getVisibleActions(rowIndex).length === 1;\n        },\n\n        /**\n         * Checks if row has more than one visible action.\n         *\n         * @param {Number} rowIndex - Row index.\n         * @returns {Boolean}\n         */\n        isMultiple: function (rowIndex) {\n            return this.getVisibleActions(rowIndex).length > 1;\n        },\n\n        /**\n         * Checks if action should be displayed.\n         *\n         * @param {Object} action - Action object.\n         * @returns {Boolean}\n         */\n        isActionVisible: function (action) {\n            return action.hidden !== true;\n        },\n\n        /**\n         * Overrides base method, because this component\n         * can't have global field action.\n         *\n         * @returns {Boolean} False.\n         */\n        hasFieldAction: function () {\n            return false;\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/thumbnail.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    './column',\n    'jquery',\n    'mage/template',\n    'text!Magento_Ui/templates/grid/cells/thumbnail/preview.html',\n    'underscore',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function (Column, $, mageTemplate, thumbnailPreviewTemplate, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/cells/thumbnail',\n            fieldClass: {\n                'data-grid-thumbnail-cell': true\n            }\n        },\n\n        /**\n         * Get image source data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getSrc: function (row) {\n            return row[this.index + '_src'];\n        },\n\n        /**\n         * Get original image source data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getOrigSrc: function (row) {\n            return row[this.index + '_orig_src'];\n        },\n\n        /**\n         * Get link data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getLink: function (row) {\n            return row[this.index + '_link'];\n        },\n\n        /**\n         * Get alternative text data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getAlt: function (row) {\n            return _.escape(row[this.index + '_alt']);\n        },\n\n        /**\n         * Check if preview available.\n         *\n         * @returns {Boolean}\n         */\n        isPreviewAvailable: function () {\n            return this['has_preview'] || false;\n        },\n\n        /**\n         * Build preview.\n         *\n         * @param {Object} row\n         */\n        preview: function (row) {\n            var modalHtml = mageTemplate(\n                    thumbnailPreviewTemplate,\n                    {\n                        src: this.getOrigSrc(row), alt: this.getAlt(row), link: this.getLink(row),\n                        linkText: $.mage.__('Go to Details Page')\n                    }\n                ),\n                previewPopup = $('<div/>').html(modalHtml);\n\n            previewPopup.modal({\n                title: this.getAlt(row),\n                innerScroll: true,\n                modalClass: '_image-box',\n                buttons: []\n            }).trigger('openModal');\n        },\n\n        /**\n         * Get field handler per row.\n         *\n         * @param {Object} row\n         * @returns {Function}\n         */\n        getFieldHandler: function (row) {\n            if (this.isPreviewAvailable()) {\n                return this.preview.bind(this, row);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/column.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiElement'\n], function (_, registry, utils, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'ui/grid/cells/text',\n            disableAction: false,\n            controlVisibility: true,\n            sortable: true,\n            sorting: false,\n            visible: true,\n            draggable: true,\n            fieldClass: {},\n            ignoreTmpls: {\n                fieldAction: true\n            },\n            statefull: {\n                visible: true,\n                sorting: true\n            },\n            imports: {\n                exportSorting: 'sorting'\n            },\n            listens: {\n                '${ $.provider }:params.sorting.field': 'onSortChange'\n            },\n            modules: {\n                source: '${ $.provider }'\n            }\n        },\n\n        /**\n         * Initializes column component.\n         *\n         * @returns {Column} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initFieldClass();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Column} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'visible',\n                    'sorting',\n                    'disableAction'\n                ])\n                .observe([\n                    'dragging'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Extends list of field classes.\n         *\n         * @returns {Column} Chainable.\n         */\n        initFieldClass: function () {\n            _.extend(this.fieldClass, {\n                _dragging: this.dragging\n            });\n\n            return this;\n        },\n\n        /**\n         * Applies specified stored state of a column or one of its' properties.\n         *\n         * @param {String} state - Defines what state should be used: saved or default.\n         * @param {String} [property] - Defines what columns' property should be applied.\n         *      If not specified, then all columns stored properties will be used.\n         * @returns {Column} Chainable.\n         */\n        applyState: function (state, property) {\n            var namespace = this.storageConfig.root;\n\n            if (property) {\n                namespace += '.' + property;\n            }\n\n            this.storage('applyStateOf', state, namespace);\n\n            return this;\n        },\n\n        /**\n         * Sets columns' sorting. If column is currently sorted,\n         * than its' direction will be toggled.\n         *\n         * @param {*} [enable=true] - If false, than sorting will\n         *      be removed from a column.\n         * @returns {Column} Chainable.\n         */\n        sort: function (enable) {\n            if (!this.sortable) {\n                return this;\n            }\n\n            enable !== false ?\n                this.toggleSorting() :\n                this.sorting = false;\n\n            return this;\n        },\n\n        /**\n         * Sets descending columns' sorting.\n         *\n         * @returns {Column} Chainable.\n         */\n        sortDescending: function () {\n            if (this.sortable) {\n                this.sorting = 'desc';\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets ascending columns' sorting.\n         *\n         * @returns {Column} Chainable.\n         */\n        sortAscending: function () {\n            if (this.sortable) {\n                this.sorting = 'asc';\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggles sorting direction.\n         *\n         * @returns {Column} Chainable.\n         */\n        toggleSorting: function () {\n            this.sorting === 'asc' ?\n                this.sortDescending() :\n                this.sortAscending();\n\n            return this;\n        },\n\n        /**\n         * Checks if column is sorted.\n         *\n         * @returns {Boolean}\n         */\n        isSorted: function () {\n            return !!this.sorting;\n        },\n\n        /**\n         * Exports sorting data to the dataProvider if\n         * sorting of a column is enabled.\n         */\n        exportSorting: function () {\n            if (!this.sorting) {\n                return;\n            }\n\n            this.source('set', 'params.sorting', {\n                field: this.index,\n                direction: this.sorting\n            });\n        },\n\n        /**\n         * Checks if column has an assigned action that will\n         * be performed when clicking on one of its' fields.\n         *\n         * @returns {Boolean}\n         */\n        hasFieldAction: function () {\n            return !!this.fieldAction || !!this.fieldActions;\n        },\n\n        /**\n         * Applies action described in a 'fieldAction' property\n         * or actions described in 'fieldActions' property.\n         *\n         * @param {Number} rowIndex - Index of a row which initiates action.\n         * @returns {Column} Chainable.\n         *\n         * @example Example of fieldAction definition, which is equivalent to\n         *      referencing to external component named 'listing.multiselect'\n         *      and calling its' method 'toggleSelect' with params [rowIndex, true] =>\n         *\n         *      {\n         *          provider: 'listing.multiselect',\n         *          target: 'toggleSelect',\n         *          params: ['${ $.$data.rowIndex }', true]\n         *      }\n         */\n        applyFieldAction: function (rowIndex) {\n            if (!this.hasFieldAction() || this.disableAction) {\n                return this;\n            }\n\n            if (this.fieldActions) {\n                this.fieldActions.forEach(this.applySingleAction.bind(this, rowIndex), this);\n            } else {\n                this.applySingleAction(rowIndex);\n            }\n\n            return this;\n        },\n\n        /**\n         * Applies single action\n         *\n         * @param {Number} rowIndex - Index of a row which initiates action.\n         * @param {Object} action - Action (fieldAction) to be applied\n         *\n         */\n        applySingleAction: function (rowIndex, action) {\n            var callback;\n\n            action = action || this.fieldAction;\n            action = utils.template(action, {\n                column: this,\n                rowIndex: rowIndex\n            }, true);\n\n            callback = this._getFieldCallback(action);\n\n            if (_.isFunction(callback)) {\n                callback();\n            }\n        },\n\n        /**\n         * Returns field action handler if it was specified.\n         *\n         * @param {Object} record - Record object with which action is associated.\n         * @returns {Function|Undefined}\n         */\n        getFieldHandler: function (record) {\n            if (this.hasFieldAction()) {\n                return this.applyFieldAction.bind(this, record._rowIndex);\n            }\n        },\n\n        /**\n         * Creates action callback based on its' data.\n         *\n         * @param {Object} action - Actions' object.\n         * @returns {Function|Boolean} Callback function or false\n         *      value if it was impossible create a callback.\n         */\n        _getFieldCallback: function (action) {\n            var args     = action.params || [],\n                callback = action.target;\n\n            if (action.provider && action.target) {\n                args.unshift(action.target);\n\n                callback = registry.async(action.provider);\n            }\n\n            if (!_.isFunction(callback)) {\n                return false;\n            }\n\n            return function () {\n                callback.apply(callback, args);\n            };\n        },\n\n        /**\n         * Ment to preprocess data associated with a current columns' field.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getLabel: function (record) {\n            return record[this.index];\n        },\n\n        /**\n         * Returns list of classes that should be applied to a field.\n         *\n         * @returns {Object}\n         */\n        getFieldClass: function () {\n            return this.fieldClass;\n        },\n\n        /**\n         * Returns path to the columns' header template.\n         *\n         * @returns {String}\n         */\n        getHeader: function () {\n            return this.headerTmpl;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Listener of the providers' sorting state changes.\n         *\n         * @param {Srting} field - Field by which current sorting is performed.\n         */\n        onSortChange: function (field) {\n            if (field !== this.index) {\n                this.sort(false);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './column'\n], function (_, Column) {\n    'use strict';\n\n    return Column.extend({\n        /**\n         * Retrieves label associated with a provided value.\n         *\n         * @returns {String}\n         */\n        getLabel: function () {\n            var options = this.options || [],\n                values = this._super(),\n                label = [];\n\n            if (_.isString(values)) {\n                values = values.split(',');\n            }\n\n            if (!_.isArray(values)) {\n                values = [values];\n            }\n\n            values = values.map(function (value) {\n                return value + '';\n            });\n\n            options = this.flatOptions(options);\n\n            options.forEach(function (item) {\n                if (_.contains(values, item.value + '')) {\n                    label.push(item.label);\n                }\n            });\n\n            return label.join(', ');\n        },\n\n        /**\n         * Transformation tree options structure to liner array.\n         *\n         * @param {Array} options\n         * @returns {Array}\n         */\n        flatOptions: function (options) {\n            var self = this;\n\n            if (!_.isArray(options)) {\n                options = _.values(options);\n            }\n\n            return options.reduce(function (opts, option) {\n                if (_.isArray(option.value)) {\n                    opts = opts.concat(self.flatOptions(option.value));\n                } else {\n                    opts.push(option);\n                }\n\n                return opts;\n            }, []);\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/onoff.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mage/translate',\n    './multiselect',\n    'uiRegistry'\n], function (_, $t, Column, registry) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/onoff',\n            bodyTmpl: 'ui/grid/cells/onoff',\n            fieldClass: {\n                'admin__scope-old': true,\n                'data-grid-onoff-cell': true,\n                'data-grid-checkbox-cell': false\n            },\n            imports: {\n                selectedData: '${ $.provider }:data.selectedData'\n            },\n            listens: {\n                '${ $.provider }:reloaded': 'setDefaultSelections'\n            }\n        },\n\n        /**\n         * @param {Number} id\n         * @returns {*}\n         */\n        getLabel: function (id) {\n            return this.selected.indexOf(id) !== -1 ? $t('On') : $t('Off');\n        },\n\n        /**\n         * Sets the ids for preselected elements\n         * @returns void\n         */\n        setDefaultSelections: function () {\n            var positionCacheValid = registry.get('position_cache_valid'),\n                selectedFromCache = registry.get('selected_cache'),\n                key,\n                i;\n\n            if (positionCacheValid && this.selected().length === 0) {\n                // Check selected data\n                selectedFromCache = JSON.parse(selectedFromCache);\n\n                for (i = 0; i < selectedFromCache.length; i++) {\n                    this.selected.push(selectedFromCache[i]);\n                }\n\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify(this.selected()));\n\n                return;\n            }\n\n            if (positionCacheValid && this.selected().length > 0) {\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify(this.selected()));\n\n                return;\n            }\n\n            if (this.selectedData.length === 0) {\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify([]));\n\n                return;\n            }\n\n            // Check selected data\n            for (key in this.selectedData) {\n                if (this.selectedData.hasOwnProperty(key) && this.selected().indexOf(key) === -1) {\n                    this.selected.push(key);\n                }\n            }\n            // Uncheck unselected data\n            for (i = 0; i < this.selected().length; i++) {\n                key = this.selected()[i];\n                this.selectedData.hasOwnProperty(key) || this.selected.splice(this.selected().indexOf(key), 1);\n                this.selectedData.hasOwnProperty(key) || i--;\n            }\n            registry.set('position_cache_valid', true);\n            registry.set('selected_cache', JSON.stringify(this.selected()));\n        },\n\n        /**\n         * Show/hide action in the massaction menu\n         * @param {Number} actionId\n         * @returns {Boolean}\n         */\n        isActionRelevant: function (actionId) {\n            var relevant = true;\n\n            switch (actionId) {\n                case 'selectPage':\n                    relevant = !this.isPageSelected(true);\n                    break;\n\n                case 'deselectPage':\n                    relevant =  this.isPageSelected();\n                    break;\n            }\n\n            return relevant;\n        },\n\n        /**\n         * Updates values of the 'allSelected'\n         * and 'indetermine' properties.\n         *\n         * @returns {Object} Chainable.\n         */\n        updateState: function () {\n            var positionCacheValid = registry.get('position_cache_valid'),\n                totalRecords    = this.totalRecords(),\n                selected        = this.selected().length,\n                excluded        = this.excluded().length,\n                totalSelected   = this.totalSelected(),\n                allSelected;\n\n            if (positionCacheValid && this.selected().length > 0) {\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify(this.selected()));\n            }\n\n            // When filters are enabled then totalRecords is unknown\n            if (this.getFiltering()) {\n                if (this.getFiltering().search !== '') {\n                    totalRecords = -1;\n                }\n            }\n\n            allSelected = totalRecords && totalSelected === totalRecords;\n\n            if (this.excludeMode()) {\n                if (excluded === totalRecords) {\n                    this.deselectAll();\n                }\n            } else if (totalRecords && selected === totalRecords) {\n                this.selectAll();\n            }\n\n            this.allSelected(allSelected);\n            this.indetermine(totalSelected && !allSelected);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mageUtils',\n    'moment',\n    './column'\n], function (utils, moment, Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            dateFormat: 'MMM d, YYYY h:mm:ss A',\n            calendarConfig: []\n        },\n\n        /**\n         * Overrides base method to normalize date format.\n         *\n         * @returns {DateColumn} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.dateFormat = utils.normalizeDate(this.dateFormat ? this.dateFormat : this.options.dateFormat);\n\n            return this;\n        },\n\n        /**\n         * Formats incoming date based on the 'dateFormat' property.\n         *\n         * @returns {String} Formatted date.\n         */\n        getLabel: function (value, format) {\n            var date;\n\n            if (this.storeLocale !== undefined) {\n                moment.locale(this.storeLocale, utils.extend({}, this.calendarConfig));\n            }\n            date = moment(this._super());\n\n            date = date.isValid() && value[this.index] ?\n                date.format(format || this.dateFormat) :\n                '';\n\n            return date;\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/expandable.js":"/**\n * Copyright \u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    './column',\n    'underscore'\n], function (Column, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/cells/expandable',\n            tooltipTmpl: 'ui/grid/cells/expandable/content',\n            visibeItemsLimit: 5,\n            tooltipTitle: ''\n        },\n\n        /**\n         * Gets label from full options array.\n         *\n         * @param {Object} record - Record object.\n         * @returns {String}\n         */\n        getFullLabel: function (record) {\n            return this.getLabelsArray(record).join(', ');\n        },\n\n        /**\n         * Gets label from options array limited by 'visibeItemsLimit'.\n         *\n         * @param {Object} record - Record object.\n         * @returns {String}\n         */\n        getShortLabel: function (record) {\n            return this.getLabelsArray(record).slice(0, this.visibeItemsLimit).join(', ');\n        },\n\n        /**\n         * Extracts array of labels associated with provided values and sort it alphabetically.\n         *\n         * @param {Object} record - Record object.\n         * @returns {Array}\n         */\n        getLabelsArray: function (record) {\n            var values = this.getLabel(record),\n                options = this.options || [],\n                labels = [];\n\n            if (_.isString(values)) {\n                values = values.split(',');\n            }\n\n            if (!Array.isArray(values)) {\n                values = [values];\n            }\n\n            values = values.map(function (value) {\n                return value + '';\n            });\n\n            options = this.flatOptions(options);\n\n            options.forEach(function (item) {\n                if (_.contains(values, item.value + '')) {\n                    labels.push(item.label);\n                }\n            });\n\n            return labels.sort(\n                function (labelFirst, labelSecond) {\n                    return labelFirst.toLowerCase().localeCompare(labelSecond.toLowerCase());\n                }\n            );\n        },\n\n        /**\n         * Transformation tree options structure to liner array.\n         *\n         * @param {Array} options\n         * @returns {Array}\n         */\n        flatOptions: function (options) {\n            var self = this;\n\n            return options.reduce(function (opts, option) {\n                if (_.isArray(option.value)) {\n                    opts = opts.concat(self.flatOptions(option.value));\n                } else {\n                    opts.push(option);\n                }\n\n                return opts;\n            }, []);\n        },\n\n        /**\n         * Checks if amount of options is more than limit value.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Boolean}\n         */\n        isExpandable: function (record) {\n            return this.getLabel(record).length > this.visibeItemsLimit;\n        }\n    });\n});\n","Magento_Ui/js/timeline/timeline.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'moment',\n    'uiLayout',\n    'Magento_Ui/js/grid/listing'\n], function (_, moment, layout, Listing) {\n    'use strict';\n\n    var ONE_DAY = 86400000;\n\n    return Listing.extend({\n        defaults: {\n            recordTmpl: 'ui/timeline/record',\n            dateFormat: 'YYYY-MM-DD HH:mm:ss',\n            headerFormat: 'ddd MM/DD',\n            detailsFormat: 'DD/MM/YYYY HH:mm:ss',\n            scale: 7,\n            scaleStep: 1,\n            minScale: 7,\n            maxScale: 28,\n            minDays: 28,\n            displayMode: 'timeline',\n            displayModes: {\n                timeline: {\n                    label: 'Timeline',\n                    value: 'timeline',\n                    template: 'ui/timeline/timeline'\n                }\n            },\n            viewConfig: {\n                component: 'Magento_Ui/js/timeline/timeline-view',\n                name: '${ $.name }_view',\n                model: '${ $.name }'\n            },\n            tracks: {\n                scale: true\n            },\n            statefull: {\n                scale: true\n            },\n            range: {}\n        },\n\n        /**\n         * Initializes Timeline component.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initView()\n                .updateRange();\n\n            return this;\n        },\n\n        /**\n         * Initializes components configuration.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.maxScale = Math.min(this.minDays, this.maxScale);\n            this.minScale = Math.min(this.maxScale, this.minScale);\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe.call(this.range, true, 'hasToday');\n\n            return this;\n        },\n\n        /**\n         * Initializes TimelineView component.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initView: function () {\n            layout([this.viewConfig]);\n\n            return this;\n        },\n\n        /**\n         * Checks if provided event record is active,\n         * i.e. it has already started.\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isActive: function (record) {\n            return Number(record.status) === 1;\n        },\n\n        /**\n         * Checks if provided event record is upcoming,\n         * i.e. it will start later on.\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isUpcoming: function (record) {\n            return Number(record.status) === 2;\n        },\n\n        /**\n         * Checks if provided event record is permanent,\n         * i.e. it has no ending time.\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isPermanent: function (record) {\n            return !this.getEndDate(record);\n        },\n\n        /**\n         * Checks if provided date indicates current day.\n         *\n         * @param {(Number|Moment)} date\n         * @returns {Boolenan}\n         */\n        isToday: function (date) {\n            return moment().isSame(date, 'day');\n        },\n\n        /**\n         * Checks if range object contains todays date.\n         *\n         * @returns {Boolean}\n         */\n        hasToday: function () {\n            return this.range.hasToday;\n        },\n\n        /**\n         * Returns start date of provided record.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getStartDate: function (record) {\n            return record['start_time'];\n        },\n\n        /**\n         * Returns end date of provided record.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getEndDate: function (record) {\n            return record['end_time'];\n        },\n\n        /**\n         * Returns difference in days between records' start date\n         * and a first day of a range.\n         *\n         * @param {Object} record\n         * @returns {Number}\n         */\n        getStartDelta: function (record) {\n            var start    = this.createDate(this.getStartDate(record)),\n                firstDay = this.range.firstDay;\n\n            return start.diff(firstDay, 'days', true);\n        },\n\n        /**\n         * Calculates the amount of days that provided event lasts.\n         *\n         * @param {Object} record\n         * @returns {Number}\n         */\n        getDaysLength: function (record) {\n            var start   = this.createDate(this.getStartDate(record)),\n                end     = this.createDate(this.getEndDate(record));\n\n            if (!end.isValid()) {\n                end = this.range.lastDay.endOf('day');\n            }\n\n            return end.diff(start, 'days', true);\n        },\n\n        /**\n         * Creates new date object based on provided date string value.\n         *\n         * @param {String} dateStr\n         * @returns {Moment}\n         */\n        createDate: function (dateStr) {\n            return moment(dateStr, this.dateFormat);\n        },\n\n        /**\n         * Converts days to weeks.\n         *\n         * @param {Number} days\n         * @returns {Number}\n         */\n        daysToWeeks: function (days) {\n            var weeks = days / 7;\n\n            if (weeks % 1) {\n                weeks = weeks.toFixed(1);\n            }\n\n            return weeks;\n        },\n\n        /**\n         * Updates data of a range object,\n         * e.g. total days, first day and last day, etc.\n         *\n         * @returns {Object} Range instance.\n         */\n        updateRange: function () {\n            var firstDay    = this._getFirstDay(),\n                lastDay     = this._getLastDay(),\n                totalDays   = lastDay.diff(firstDay, 'days'),\n                days        = [],\n                i           = -1;\n\n            if (totalDays < this.minDays) {\n                totalDays += this.minDays - totalDays - 1;\n            }\n\n            while (++i <= totalDays) {\n                days.push(+firstDay + ONE_DAY * i);\n            }\n\n            return _.extend(this.range, {\n                days:       days,\n                totalDays:  totalDays,\n                firstDay:   firstDay,\n                lastDay:    moment(_.last(days)),\n                hasToday:   this.isToday(firstDay)\n            });\n        },\n\n        /**\n         *\n         * @private\n         * @param {String} key\n         * @returns {Array<Moment>}\n         */\n        _getDates: function (key) {\n            var dates = [];\n\n            this.rows.forEach(function (record) {\n                if (record[key]) {\n                    dates.push(this.createDate(record[key]));\n                }\n            }, this);\n\n            return dates;\n        },\n\n        /**\n         * Returns date which is closest to the current day.\n         *\n         * @private\n         * @returns {Moment}\n         */\n        _getFirstDay: function () {\n            var dates = this._getDates('start_time'),\n                first = moment.min(dates).subtract(1, 'day'),\n                today = moment();\n\n            if (!first.isValid() || first < today) {\n                first = today;\n            }\n\n            return first.startOf('day');\n        },\n\n        /**\n         * Returns the most distant date\n         * specified in available records.\n         *\n         * @private\n         * @returns {Moment}\n         */\n        _getLastDay: function () {\n            var startDates  = this._getDates('start_time'),\n                endDates    = this._getDates('end_time'),\n                last        = moment.max(startDates.concat(endDates));\n\n            return last.add(1, 'day').startOf('day');\n        },\n\n        /**\n         * TODO: remove after integration with date binding.\n         *\n         * @param {Number} timestamp\n         * @returns {String}\n         */\n        formatHeader: function (timestamp) {\n            return moment(timestamp).format(this.headerFormat);\n        },\n\n        /**\n         * TODO: remove after integration with date binding.\n         *\n         * @param {String} date\n         * @returns {String}\n         */\n        formatDetails: function (date) {\n            return moment(date).format(this.detailsFormat);\n        }\n    });\n});\n","Magento_Ui/js/timeline/timeline-view.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/raf',\n    'uiRegistry',\n    'uiClass'\n], function (ko, $, _, raf, registry, Class) {\n    'use strict';\n\n    var hasClassList = (function () {\n        var list = document.createElement('_').classList;\n\n        return !!list && !list.toggle('_test', false);\n    })();\n\n    /**\n     * Polyfill of the 'classList.toggle' method.\n     *\n     * @param {HTMLElement} elem\n     */\n    function toggleClass(elem) {\n        var classList   = elem.classList,\n            args        = Array.prototype.slice.call(arguments, 1),\n            $elem;\n\n        if (hasClassList) {\n            classList.toggle.apply(classList, args);\n        } else {\n            $elem = $(elem);\n            $elem.toggleClass.apply($elem, args);\n        }\n    }\n\n    return Class.extend({\n        defaults: {\n            selectors: {\n                content: '.timeline-content',\n                timeUnit: '.timeline-unit',\n                item: '.timeline-item:not([data-role=no-data-msg])',\n                event: '.timeline-event'\n            }\n        },\n\n        /**\n         * Initializes TimelineView component.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'refresh',\n                'initContent',\n                'initItem',\n                'initTimeUnit',\n                'getItemBindings',\n                'updateItemsPosition',\n                'onScaleChange',\n                'onEventElementRender',\n                'onWindowResize',\n                'onContentScroll',\n                'onDataReloaded',\n                'onToStartClick',\n                'onToEndClick'\n            );\n\n            this._super()\n                .initModel()\n                .waitContent();\n\n            return this;\n        },\n\n        /**\n         * Applies listeners for the model properties changes.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        initModel: function () {\n            var model = registry.get(this.model);\n\n            model.on('scale', this.onScaleChange);\n            model.source.on('reloaded', this.onDataReloaded);\n\n            this.model = model;\n\n            return this;\n        },\n\n        /**\n         * Applies DOM watcher for the\n         * content element rendering.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        waitContent: function () {\n            $.async({\n                selector: this.selectors.content,\n                component: this.model\n            }, this.initContent);\n\n            return this;\n        },\n\n        /**\n         * Initializes timelines' content element.\n         *\n         * @param {HTMLElement} content\n         * @returns {TimelineView} Chainable.\n         */\n        initContent: function (content) {\n            this.$content = content;\n\n            $(content).on('scroll', this.onContentScroll);\n            $(window).on('resize', this.onWindowResize);\n\n            $.async(this.selectors.item, content, this.initItem);\n            $.async(this.selectors.event, content, this.onEventElementRender);\n            $.async(this.selectors.timeUnit, content, this.initTimeUnit);\n\n            this.refresh();\n\n            return this;\n        },\n\n        /**\n         * Initializes timeline item element,\n         * e.g. establishes event listeners and applies data bindings.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView} Chainable.\n         */\n        initItem: function (elem) {\n            $(elem)\n                .bindings(this.getItemBindings)\n                .on('click', '._toend', this.onToEndClick)\n                .on('click', '._tostart', this.onToStartClick);\n\n            return this;\n        },\n\n        /**\n         * Initializes timeline unit element.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView} Chainable.\n         */\n        initTimeUnit: function (elem) {\n            $(elem).bindings(this.getTimeUnitBindings());\n\n            return this;\n        },\n\n        /**\n         * Updates items positions in a\n         * loop if state of a view has changed.\n         */\n        refresh: function () {\n            raf(this.refresh);\n\n            if (this._update) {\n                this._update = false;\n\n                this.updateItemsPosition();\n            }\n        },\n\n        /**\n         * Returns object width additional bindings\n         * for a timeline unit element.\n         *\n         * @returns {Object}\n         */\n        getTimeUnitBindings: function () {\n            return {\n                style: {\n                    width: ko.computed(function () {\n                        return this.getTimeUnitWidth() + '%';\n                    }.bind(this))\n                }\n            };\n        },\n\n        /**\n         * Returns object with additional\n         * bindings for a timeline item element.\n         *\n         * @param {Object} ctx\n         * @returns {Object}\n         */\n        getItemBindings: function (ctx) {\n            return {\n                style: {\n                    width: ko.computed(function () {\n                        return this.getItemWidth(ctx.$row()) + '%';\n                    }.bind(this)),\n\n                    'margin-left': ko.computed(function () {\n                        return this.getItemMargin(ctx.$row()) + '%';\n                    }.bind(this))\n                }\n            };\n        },\n\n        /**\n         * Calculates width in percents of a timeline unit element.\n         *\n         * @returns {Number}\n         */\n        getTimeUnitWidth: function () {\n            return 100 / this.model.scale;\n        },\n\n        /**\n         * Calculates width of a record in percents.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getItemWidth: function (record) {\n            var days = 0;\n\n            if (record) {\n                days = this.model.getDaysLength(record);\n            }\n\n            return this.getTimeUnitWidth()  * days;\n        },\n\n        /**\n         * Calculates left margin value for provided record.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getItemMargin: function (record) {\n            var offset = 0;\n\n            if (record) {\n                offset = this.model.getStartDelta(record);\n            }\n\n            return this.getTimeUnitWidth() * offset;\n        },\n\n        /**\n         * Returns collection of currently available\n         * timeline item elements.\n         *\n         * @returns {Array<HTMLElement>}\n         */\n        getItems: function () {\n            var items = this.$content.querySelectorAll(this.selectors.item);\n\n            return _.toArray(items);\n        },\n\n        /**\n         * Updates positions of timeline elements.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        updateItemsPosition: function () {\n            this.getItems()\n                .forEach(this.updatePositionFor, this);\n\n            return this;\n        },\n\n        /**\n         * Updates position of provided timeline element.\n         *\n         * @param {HTMLElement} $elem\n         * @returns {TimelineView} Chainable.\n         */\n        updatePositionFor: function ($elem) {\n            var $event      = $elem.querySelector(this.selectors.event),\n                leftEdge    = this.getLeftEdgeFor($elem),\n                rightEdge   = this.getRightEdgeFor($elem);\n\n            if ($event) {\n                $event.style.left = Math.max(-leftEdge, 0) + 'px';\n                $event.style.right = Math.max(rightEdge, 0) + 'px';\n            }\n\n            toggleClass($elem, '_scroll-start', leftEdge < 0);\n            toggleClass($elem, '_scroll-end', rightEdge > 0);\n\n            return this;\n        },\n\n        /**\n         * Scrolls content area to the start of provided element.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView}\n         */\n        toStartOf: function (elem) {\n            var leftEdge = this.getLeftEdgeFor(elem);\n\n            this.$content.scrollLeft += leftEdge;\n\n            return this;\n        },\n\n        /**\n         * Scrolls content area to the end of provided element.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView}\n         */\n        toEndOf: function (elem) {\n            var rightEdge = this.getRightEdgeFor(elem);\n\n            this.$content.scrollLeft += rightEdge + 1;\n\n            return this;\n        },\n\n        /**\n         * Calculates location of the left edge of an element\n         * relative to the contents' left edge.\n         *\n         * @param {HTMLElement} elem\n         * @returns {Number}\n         */\n        getLeftEdgeFor: function (elem) {\n            var leftOffset = elem.getBoundingClientRect().left;\n\n            return leftOffset - this.$content.getBoundingClientRect().left;\n        },\n\n        /**\n         * Calculates location of the right edge of an element\n         * relative to the contents' right edge.\n         *\n         * @param {HTMLElement} elem\n         * @returns {Number}\n         */\n        getRightEdgeFor: function (elem) {\n            var elemWidth   = elem.offsetWidth,\n                leftEdge    = this.getLeftEdgeFor(elem);\n\n            return leftEdge + elemWidth - this.$content.offsetWidth;\n        },\n\n        /**\n         * 'To Start' button 'click' event handler.\n         *\n         * @param {jQueryEvent} event\n         */\n        onToStartClick: function (event) {\n            var elem = event.originalEvent.currentTarget;\n\n            event.stopPropagation();\n\n            this.toStartOf(elem);\n        },\n\n        /**\n         * 'To End' button 'click' event handler.\n         *\n         * @param {jQueryEvent} event\n         */\n        onToEndClick: function (event) {\n            var elem = event.originalEvent.currentTarget;\n\n            event.stopPropagation();\n\n            this.toEndOf(elem);\n        },\n\n        /**\n         * Handler of the scale value 'change' event.\n         */\n        onScaleChange: function () {\n            this._update = true;\n        },\n\n        /**\n         * Callback function which is invoked\n         * when event element was rendered.\n         */\n        onEventElementRender: function () {\n            this._update = true;\n        },\n\n        /**\n         * Window 'resize' event handler.\n         */\n        onWindowResize: function () {\n            this._update = true;\n        },\n\n        /**\n         * Content container 'scroll' event handler.\n         */\n        onContentScroll: function () {\n            this._update = true;\n        },\n\n        /**\n         * Data 'reload' event handler.\n         */\n        onDataReloaded: function () {\n            this._update = true;\n        }\n    });\n});\n","Magento_SalesRule/js/form/element/manage-coupon-codes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/components/fieldset',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (_, uiRegistry, fieldset, async) {\n    'use strict';\n\n    return fieldset.extend({\n\n        /*eslint-disable no-unused-vars*/\n        /**\n         * Initialize element\n         *\n         * @returns {Abstract} Chainable\n         */\n        initialize: function (elems, position) {\n            var obj = this;\n\n            this._super();\n\n            async.async('#sales-rule-form-tab-coupons', document.getElementById('container'), function (node) {\n                var useAutoGeneration = uiRegistry.get(\n                    'sales_rule_form.sales_rule_form.rule_information.use_auto_generation'\n                );\n\n                useAutoGeneration.on('checked', function () {\n                    obj.enableDisableFields();\n                });\n                obj.enableDisableFields();\n            });\n\n            return this;\n        },\n\n        /*eslint-enable no-unused-vars*/\n        /*eslint-disable lines-around-comment*/\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            /**\n             * \\Magento\\Rule\\Model\\AbstractModel::COUPON_TYPE_AUTO\n             */\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Magento_SalesRule/js/form/element/apply_to_shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox-toggle-notice'\n], function (Checkbox) {\n    'use strict';\n\n    return Checkbox.extend({\n        defaults: {\n            imports: {\n                toggleDisabled: '${ $.parentName }.simple_action:value'\n            }\n        },\n\n        /**\n         * Toggle element disabled state according to simple action value.\n         *\n         * @param {String} action\n         */\n        toggleDisabled: function (action) {\n            switch (action) {\n                case 'cart_fixed':\n                    this.disabled(true);\n                    break;\n                default:\n                    this.disabled(false);\n            }\n\n            if (this.disabled()) {\n                this.checked(false);\n            }\n        }\n    });\n});\n","Magento_SalesRule/js/form/element/coupon-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/select'\n], function (_, uiRegistry, select) {\n    'use strict';\n\n    return select.extend({\n\n        /**\n         * Hide fields on coupon tab\n         */\n        onUpdate: function () {\n\n            /* eslint-disable eqeqeq */\n            if (this.value() != this.displayOnlyForCouponType) {\n                uiRegistry.get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation').checked(false);\n            }\n\n            this.enableDisableFields();\n        },\n\n        /**\n         * Enable/disable fields on Coupons tab\n         */\n        enableDisableFields: function () {\n            var selector,\n                isUseAutoGenerationChecked,\n                couponType,\n                disableAuto;\n\n            selector = '[id=sales-rule-form-tab-coupons] input, [id=sales-rule-form-tab-coupons] select, ' +\n                    '[id=sales-rule-form-tab-coupons] button';\n            isUseAutoGenerationChecked = uiRegistry\n                    .get('sales_rule_form.sales_rule_form.rule_information.use_auto_generation')\n                    .checked();\n            couponType = uiRegistry\n                .get('sales_rule_form.sales_rule_form.rule_information.coupon_type')\n                .value();\n            disableAuto = couponType === 3 || isUseAutoGenerationChecked;\n            _.each(\n                document.querySelectorAll(selector),\n                function (element) {\n                    element.disabled = !disableAuto;\n                }\n            );\n        }\n    });\n});\n","Magento_Downloadable/downloadable-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/product/weight-handler',\n    'Magento_Catalog/catalog/type-events'\n], function ($, weight, productType) {\n    'use strict';\n\n    return {\n        $checkbox: $('[data-action=change-type-product-downloadable]'),\n        $items: $('#product_info_tabs_downloadable_items'),\n        $tab: null,\n        isDownloadable: false,\n\n        /**\n         * Show\n         */\n        show: function () {\n            this.$checkbox.prop('checked', true);\n            this.$items.show();\n        },\n\n        /**\n         * Hide\n         */\n        hide: function () {\n            this.$checkbox.prop('checked', false);\n            this.$items.hide();\n        },\n\n        /**\n         * Constructor component\n         * @param {Object} data - this backend data\n         */\n        'Magento_Downloadable/downloadable-type-handler': function (data) {\n            this.$tab = $('[data-tab=' + data.tabId + ']');\n            this.isDownloadable = data.isDownloadable;\n            this.bindAll();\n            this._initType();\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            this.$checkbox.on('change', function (event) {\n                $(document).trigger('setTypeProduct', $(event.target).prop('checked') ?\n                    'downloadable' :\n                    productType.type.init === 'downloadable' ? 'virtual' : productType.type.init\n                );\n            });\n\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n        },\n\n        /**\n         * Init type\n         * @private\n         */\n        _initType: function () {\n            if (productType.type.current === 'downloadable') {\n                weight.change(false);\n                weight.$weightSwitcher().one('change', function () {\n                    $(document).trigger(\n                        'setTypeProduct',\n                        productType.type.init === 'downloadable' ? 'virtual' : productType.type.init\n                    );\n                });\n                this.show();\n            } else {\n                this.hide();\n            }\n        }\n    };\n});\n","Magento_Downloadable/js/components/upload-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'uiRegistry'\n], function (Select, registry) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            listens: {\n                value: 'changeTypeUpload'\n            },\n            typeUrl: 'file',\n            typeFile: 'link_url',\n            filterPlaceholder: 'ns = ${ $.ns }, parentScope = ${ $.parentScope }'\n        },\n\n        /**\n         * Initialize component.\n         * @returns {Element}\n         */\n        initialize: function () {\n            return this\n                ._super()\n                .changeTypeUpload(this.initialValue);\n        },\n\n        /**\n         * Callback that fires when 'value' property is updated.\n         *\n         * @param {String} currentValue\n         * @returns {*}\n         */\n        onUpdate: function (currentValue) {\n            this.changeTypeUpload(currentValue);\n\n            return this._super();\n        },\n\n        /**\n         * Change visibility for typeUrl/typeFile based on current value.\n         *\n         * @param {String} currentValue\n         */\n        changeTypeUpload: function (currentValue) {\n            var componentFile = this.filterPlaceholder + ', index=' + this.typeFile,\n                componentUrl = this.filterPlaceholder + ', index=' + this.typeUrl;\n\n            switch (currentValue) {\n\n                case 'file':\n                    this.changeVisible(componentFile, true);\n                    this.changeVisible(componentUrl, false);\n                    break;\n\n                case 'url':\n                    this.changeVisible(componentFile, false);\n                    this.changeVisible(componentUrl, true);\n                    break;\n            }\n        },\n\n        /**\n         * Change visible\n         *\n         * @param {String} filter\n         * @param {Boolean} visible\n         */\n        changeVisible: function (filter, visible) {\n            registry.async(filter)(\n                function (currentComponent) {\n                    currentComponent.visible(visible);\n                }\n            );\n        }\n    });\n});\n","Magento_Downloadable/js/components/is-downloadable-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            listens: {\n                disabled: 'changeVisibility'\n            },\n            modules: {\n                samplesFieldset: '${ $.samplesFieldset }',\n                linksFieldset: '${ $.linksFieldset}'\n            }\n        },\n\n        /**\n         * Change visibility for samplesFieldset & linksFieldset based on current statuses of checkbox.\n         */\n        changeVisibility: function () {\n            if (this.samplesFieldset() && this.linksFieldset()) {\n                if (this.checked() && !this.disabled()) {\n                    this.samplesFieldset().visible(true);\n                    this.linksFieldset().visible(true);\n                } else {\n                    this.samplesFieldset().visible(false);\n                    this.linksFieldset().visible(false);\n                }\n            }\n        },\n\n        /**\n         * Handle checked state changes for checkbox / radio button.\n         *\n         * @param {Boolean} newChecked\n         */\n        onCheckedChanged: function (newChecked) {\n            this.changeVisibility();\n            this._super(newChecked);\n        }\n    });\n});\n","Magento_Downloadable/js/components/file-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/file-uploader'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            fileInputName: ''\n        },\n\n        /**\n         * Adds provided file to the files list.\n         *\n         * @param {Object} file\n         * @returns {FileUploder} Chainable.\n         */\n        addFile: function (file) {\n            var processedFile = this.processFile(file),\n                tmpFile = [],\n                resultFile = {\n                'file': processedFile.file,\n                'name': processedFile.name,\n                'size': processedFile.size,\n                'status': processedFile.status ? processedFile.status : 'new'\n            };\n\n            tmpFile[0] = resultFile;\n\n            this.isMultipleFiles ?\n                this.value.push(tmpFile) :\n                this.value(tmpFile);\n\n            return this;\n        }\n    });\n});\n","Magento_Downloadable/js/components/use-price-default-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            linksPurchasedSeparately: '0',\n            listens: {\n                linksPurchasedSeparately: 'changeVisibleStatus'\n            }\n        },\n\n        /**\n         * Change visibility of checkbox\n         */\n        changeVisibleStatus: function () {\n            if (this.linksPurchasedSeparately === '1') {\n                this.visible(true);\n            } else {\n                this.visible(false);\n            }\n        }\n    });\n});\n","Magento_Downloadable/js/components/price-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            linksPurchasedSeparately: '0',\n            useDefaultPrice: false,\n            listens: {\n                linksPurchasedSeparately: 'changeDisabledStatus',\n                useDefaultPrice: 'changeDisabledStatus'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super();\n            this.changeDisabledStatus();\n\n            return this;\n        },\n\n        /**\n         * Disable/enable price field\n         */\n        changeDisabledStatus: function () {\n            if (this.linksPurchasedSeparately === '1') {\n                if (this.useDefaultPrice) {\n                    this.disabled(true);\n                } else {\n                    this.disabled(false);\n                }\n            } else {\n                this.disabled(true);\n            }\n        }\n    });\n});\n","Magento_Signifyd/js/request-send.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'mageUtils',\n    'Magento_Ui/js/form/components/button'\n], function (utils, Button) {\n    'use strict';\n\n    return Button.extend({\n\n        /**\n         * Creates and submits form for Guarantee create/cancel\n         */\n        sendRequest: function () {\n            utils.submit({\n                url: this.requestURL,\n                data: this.data\n            });\n        }\n    });\n});\n","Magento_AdvancedSearch/js/testconnection.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui'\n], function ($, alert) {\n    'use strict';\n\n    $.widget('mage.testConnection', {\n        options: {\n            url: '',\n            elementId: '',\n            successText: '',\n            failedText: '',\n            fieldMapping: ''\n        },\n\n        /**\n         * Bind handlers to events\n         */\n        _create: function () {\n            this._on({\n                'click': $.proxy(this._connect, this)\n            });\n        },\n\n        /**\n         * Method triggers an AJAX request to check search engine connection\n         * @private\n         */\n        _connect: function () {\n            var result = this.options.failedText,\n                element =  $('#' + this.options.elementId),\n                self = this,\n                params = {},\n                msg = '',\n                fieldToCheck = this.options.fieldToCheck || 'success';\n\n            element.removeClass('success').addClass('fail');\n            $.each($.parseJSON(this.options.fieldMapping), function (key, el) {\n                params[key] = $('#' + el).val();\n            });\n            $.ajax({\n                url: this.options.url,\n                showLoader: true,\n                data: params,\n                headers: this.options.headers || {}\n            }).done(function (response) {\n                if (response[fieldToCheck]) {\n                    element.removeClass('fail').addClass('success');\n                    result = self.options.successText;\n                } else {\n                    msg = response.errorMessage;\n\n                    if (msg) {\n                        alert({\n                            content: msg\n                        });\n                    }\n                }\n            }).always(function () {\n                $('#' + self.options.elementId + '_result').text(result);\n            });\n        }\n    });\n\n    return $.mage.testConnection;\n});\n","MSP_TwoFactorAuth/js/trust_device.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n    'uiComponent',\n    'MSP_TwoFactorAuth/js/registry'\n], function (Component, registry) {\n    return Component.extend({\n        checked: registry.trustThisDevice,\n\n        defaults: {\n            template: 'MSP_TwoFactorAuth/trust_device'\n        }\n    });\n});\n","MSP_TwoFactorAuth/js/registry.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n    'ko'\n], function (ko) {\n    return {\n        trustThisDevice: ko.observable(false)\n    };\n});\n","MSP_TwoFactorAuth/js/error.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate'\n], function ($, alert) {\n    return {\n        /**\n         * Display an error message\n         * @param {String} message\n         */\n        display: function (message) {\n            alert({\n                title: $.mage.__('Error'),\n                content: message\n            });\n        }\n    };\n});\n","MSP_TwoFactorAuth/js/change_provider.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n    'uiComponent',\n    'ko'\n], function (Component, ko) {\n    return Component.extend({\n        showChangeMethod: ko.observable(false),\n\n        providers: [],\n        switchIcon: '',\n\n        defaults: {\n            template: 'MSP_TwoFactorAuth/change_provider'\n        },\n\n        /**\n         * Get switch icon URL\n         * @returns {String}\n         */\n        getSwitchIconUrl: function () {\n            return this.switchIcon;\n        },\n\n        /**\n         * Show available alternative 2FA providers\n         */\n        displayChangeMethod: function () {\n            this.showChangeMethod(true);\n        },\n\n        /**\n         * Return a list of alternative providers\n         * @returns {Array}\n         */\n        getProviders: function () {\n            return this.providers;\n        }\n    });\n});\n","MSP_TwoFactorAuth/js/form/provider.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n    'Magento_Ui/js/form/provider'\n], function (Provider) {\n    return Provider.extend({\n        /**\n         * @see Magento_Ui/js/form/provider\n         * @returns {Element}\n         */\n        save: function () {\n            // Disable independent save (we have a parent form with own validation)\n            return this;\n        }\n    });\n});\n","MSP_TwoFactorAuth/js/form/element/trusted_devices.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    return Abstract.extend({\n        /**\n         * Get a list of trusted devices\n         * @returns {Array}\n         */\n        getTrustedDevices: function () {\n            return this.source.data['trusted_devices'] ? this.source.data['trusted_devices'] : [];\n        },\n\n        /**\n         * Revoke a trusted device\n         * @param {Object} item\n         */\n        revokeDevice: function (item) {\n            self.location.href = item['revoke_url'];\n        }\n    });\n});\n","MSP_TwoFactorAuth/js/form/element/providers.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine(['Magento_Ui/js/form/element/abstract'], function (Abstract) {\n    return Abstract.extend({\n        /**\n         * Get a list of forced providers\n         * @returns {Array}\n         */\n        getForcedProviders: function () {\n            return this.forced_providers;\n        },\n\n        /**\n         * Get a list of enabled providers\n         * @returns {Array}\n         */\n        getEnabledProviders: function () {\n            return this.enabled_providers;\n        },\n\n        /**\n         * Return true if a provider is selected\n         * @param {String} provider\n         * @returns {Boolean}\n         */\n        isSelected: function (provider) {\n            var i, providers = this.value();\n\n            for (i = 0; i < providers.length; i++) {\n                if (providers[i] === provider) {\n                    return true;\n                }\n            }\n\n            return false;\n        }\n    });\n});\n","MSP_TwoFactorAuth/js/form/element/reset_providers.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n  'Magento_Ui/js/form/element/abstract',\n  'Magento_Ui/js/modal/confirm'\n], function (Abstract, confirm) {\n    return Abstract.extend({\n        /**\n         * Get a list of providers with reset option\n         * @returns {Array}\n         */\n        getResetProviders: function () {\n            return this.source.data['reset_providers'] ? this.source.data['reset_providers'] : [];\n        },\n\n        /**\n         * Reset a provider\n         * @param {Object} item\n         */\n        resetProvider: function (item) {\n            confirm({\n                title: 'Confirm',\n                content: 'Are you sure you want to reset ' + item.label + ' provider?',\n                actions: {\n                    confirm: function () { // jscs:ignore jsDoc\n                        self.location.href = item.url;\n                    }\n                }\n            });\n        }\n    });\n});\n","MSP_TwoFactorAuth/js/duo/auth.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n    'ko',\n    'uiComponent',\n    'MSP_TwoFactorAuth/js/duo/api'\n], function (ko, Component, duo) {\n    return Component.extend({\n        currentStep: ko.observable('register'),\n\n        defaults: {\n            template: 'MSP_TwoFactorAuth/duo/auth'\n        },\n\n        signature: '',\n        apiHost: '',\n        postUrl: '',\n        authenticateData: {},\n\n        /**\n         * Start waiting loop\n         */\n        onAfterRender: function () {\n            window.setTimeout(function () {\n                duo.init();\n            }, 100);\n        },\n\n        /**\n         * Get POST URL\n         * @returns {String}\n         */\n        getPostUrl: function () {\n            return this.postUrl;\n        },\n\n        /**\n         * Get signature\n         * @returns {String}\n         */\n        getSignature: function () {\n            return this.signature;\n        },\n\n        /**\n         * Get API host\n         * @returns {String}\n         */\n        getApiHost: function () {\n            return this.apiHost;\n        }\n    });\n});\n","MSP_TwoFactorAuth/js/duo/api.js":"/**\n * Duo Web SDK v2\n * Copyright 2017, Duo Security\n */\n\n/* eslint-disable */\n// jscs:disable\n\n(function (root, factory) {\n/*eslint-disable */\nif (typeof define === 'function' && define.amd) {\n    // AMD. Register as an anonymous module.\n    define([], factory);\n    /*eslint-enable */\n} else if (typeof module === 'object' && module.exports) {\n    // Node. Does not work with strict CommonJS, but\n    // only CommonJS-like environments that support module.exports,\n    // like Node.\n    module.exports = factory();\n} else {\n    // Browser globals (root is window)\n    var Duo = factory();\n    // If the Javascript was loaded via a script tag, attempt to autoload\n    // the frame.\n\n    Duo._onReady(Duo.init);\n\n    // Attach Duo to the `window` object\n    root.Duo = Duo;\n}\n}(this, function () {\n    var DUO_MESSAGE_FORMAT = /^(?:AUTH|ENROLL)+\\|[A-Za-z0-9\\+\\/=]+\\|[A-Za-z0-9\\+\\/=]+$/;\n    var DUO_ERROR_FORMAT = /^ERR\\|[\\w\\s\\.\\(\\)]+$/;\n    var DUO_OPEN_WINDOW_FORMAT = /^DUO_OPEN_WINDOW\\|/;\n    var VALID_OPEN_WINDOW_DOMAINS = [\n      'duo.com',\n      'duosecurity.com',\n      'duomobile.s3-us-west-1.amazonaws.com'\n    ];\n\n    var iframeId = 'duo_iframe',\n      postAction = '',\n      postArgument = 'sig_response',\n      host,\n      sigRequest,\n      duoSig,\n      appSig,\n      iframe,\n      submitCallback;\n\n    function throwError(message, url) {\n        throw new Error(\n          'Duo Web SDK error: ' + message +\n          (url ? '\\n' + 'See ' + url + ' for more information' : '')\n        );\n    }\n\n    function hyphenize(str) {\n        return str.replace(/([a-z])([A-Z])/, '$1-$2').toLowerCase();\n    }\n\n    // cross-browser data attributes\n    function getDataAttribute(element, name) {\n        if ('dataset' in element) {\n            return element.dataset[name];\n        }\n\n        return element.getAttribute('data-' + hyphenize(name));\n\n    }\n\n    // cross-browser event binding/unbinding\n    function on(context, event, fallbackEvent, callback) {\n        if ('addEventListener' in window) {\n            context.addEventListener(event, callback, false);\n        } else {\n            context.attachEvent(fallbackEvent, callback);\n        }\n    }\n\n    function off(context, event, fallbackEvent, callback) {\n        if ('removeEventListener' in window) {\n            context.removeEventListener(event, callback, false);\n        } else {\n            context.detachEvent(fallbackEvent, callback);\n        }\n    }\n\n    function onReady(callback) {\n        on(document, 'DOMContentLoaded', 'onreadystatechange', callback);\n    }\n\n    function offReady(callback) {\n        off(document, 'DOMContentLoaded', 'onreadystatechange', callback);\n    }\n\n    function onMessage(callback) {\n        on(window, 'message', 'onmessage', callback);\n    }\n\n    function offMessage(callback) {\n        off(window, 'message', 'onmessage', callback);\n    }\n\n    /**\n     * Parse the sig_request parameter, throwing errors if the token contains\n     * a server error or if the token is invalid.\n     *\n     * @param {String} sig Request token\n     */\n    function parseSigRequest(sig) {\n        if (!sig) {\n            // nothing to do\n            return;\n        }\n\n        // see if the token contains an error, throwing it if it does\n        if (sig.indexOf('ERR|') === 0) {\n            throwError(sig.split('|')[1]);\n        }\n\n        // validate the token\n        if (sig.indexOf(':') === -1 || sig.split(':').length !== 2) {\n            throwError(\n              'Duo was given a bad token.  This might indicate a configuration ' +\n              'problem with one of Duo\\'s client libraries.',\n              'https://www.duosecurity.com/docs/duoweb#first-steps'\n            );\n        }\n\n        var sigParts = sig.split(':');\n\n        // hang on to the token, and the parsed duo and app sigs\n        sigRequest = sig;\n        duoSig = sigParts[0];\n        appSig = sigParts[1];\n\n        return {\n            sigRequest: sig,\n            duoSig: sigParts[0],\n            appSig: sigParts[1]\n        };\n    }\n\n    /**\n     * This function is set up to run when the DOM is ready, if the iframe was\n     * not available during `init`.\n     */\n    function onDOMReady() {\n        iframe = document.getElementById(iframeId);\n\n        if (!iframe) {\n            throw new Error(\n              'This page does not contain an iframe for Duo to use.' +\n              'Add an element like <iframe id=\"duo_iframe\"></iframe> ' +\n              'to this page.  ' +\n              'See https://www.duosecurity.com/docs/duoweb#3.-show-the-iframe ' +\n              'for more information.'\n            );\n        }\n\n        // we've got an iframe, away we go!\n        ready();\n\n        // always clean up after yourself\n        offReady(onDOMReady);\n    }\n\n    /**\n     * Validate that a MessageEvent came from the Duo service, and that it\n     * is a properly formatted payload.\n     *\n     * The Google Chrome sign-in page injects some JS into pages that also\n     * make use of postMessage, so we need to do additional validation above\n     * and beyond the origin.\n     *\n     * @param {MessageEvent} event Message received via postMessage\n     */\n    function isDuoMessage(event) {\n        return Boolean(\n          event.origin === 'https://' + host &&\n          typeof event.data === 'string' &&\n          (\n            event.data.match(DUO_MESSAGE_FORMAT) ||\n            event.data.match(DUO_ERROR_FORMAT) ||\n            event.data.match(DUO_OPEN_WINDOW_FORMAT)\n          )\n        );\n    }\n\n    /**\n     * Validate the request token and prepare for the iframe to become ready.\n     *\n     * All options below can be passed into an options hash to `Duo.init`, or\n     * specified on the iframe using `data-` attributes.\n     *\n     * Options specified using the options hash will take precedence over\n     * `data-` attributes.\n     *\n     * Example using options hash:\n     * ```javascript\n     * Duo.init({\n       *     iframe: \"some_other_id\",\n       *     host: \"api-main.duo.test\",\n       *     sig_request: \"...\",\n       *     post_action: \"/auth\",\n       *     post_argument: \"resp\"\n       * });\n     * ```\n     *\n     * Example using `data-` attributes:\n     * ```\n     * <iframe id=\"duo_iframe\"\n     *         data-host=\"api-main.duo.test\"\n     *         data-sig-request=\"...\"\n     *         data-post-action=\"/auth\"\n     *         data-post-argument=\"resp\"\n     *         >\n     * </iframe>\n     * ```\n     *\n     * @param {Object} options\n     * @param {String} options.iframe                         The iframe, or id of an iframe to set up\n     * @param {String} options.host                           Hostname\n     * @param {String} options.sig_request                    Request token\n     * @param {String} [options.post_action='']               URL to POST back to after successful auth\n     * @param {String} [options.post_argument='sig_response'] Parameter name to use for response token\n     * @param {Function} [options.submit_callback]            If provided, duo will not submit the form instead execute\n     *                                                        the callback function with reference to the \"duo_form\" form object\n     *                                                        submit_callback can be used to prevent the webpage from reloading.\n     */\n    function init(options) {\n        if (options) {\n            if (options.host) {\n                host = options.host;\n            }\n\n            if (options.sig_request) {\n                parseSigRequest(options.sig_request);\n            }\n\n            if (options.post_action) {\n                postAction = options.post_action;\n            }\n\n            if (options.post_argument) {\n                postArgument = options.post_argument;\n            }\n\n            if (options.iframe) {\n                if (options.iframe.tagName) {\n                    iframe = options.iframe;\n                } else if (typeof options.iframe === 'string') {\n                    iframeId = options.iframe;\n                }\n            }\n\n            if (typeof options.submit_callback === 'function') {\n                submitCallback = options.submit_callback;\n            }\n        }\n\n        // if we were given an iframe, no need to wait for the rest of the DOM\n        if (iframe) {\n            ready();\n        } else {\n            // try to find the iframe in the DOM\n            iframe = document.getElementById(iframeId);\n\n            // iframe is in the DOM, away we go!\n            if (iframe) {\n                ready();\n            } else {\n                // wait until the DOM is ready, then try again\n                onReady(onDOMReady);\n            }\n        }\n\n        // always clean up after yourself!\n        offReady(init);\n    }\n\n    /**\n     * This function is called when a message was received from another domain\n     * using the `postMessage` API.  Check that the event came from the Duo\n     * service domain, and that the message is a properly formatted payload,\n     * then perform the post back to the primary service.\n     *\n     * @param event Event object (contains origin and data)\n     */\n    function onReceivedMessage(event) {\n        if (isDuoMessage(event)) {\n            if (event.data.match(DUO_OPEN_WINDOW_FORMAT)) {\n                var url = event.data.substring('DUO_OPEN_WINDOW|'.length);\n\n                if (isValidUrlToOpen(url)) {\n                    // Open the URL that comes after the DUO_WINDOW_OPEN token.\n                    window.open(url, '_self');\n                }\n            } else {\n                // the event came from duo, do the post back\n                doPostBack(event.data);\n\n                // always clean up after yourself!\n                offMessage(onReceivedMessage);\n            }\n        }\n    }\n\n    /**\n     * Validate that this passed in URL is one that we will actually allow to\n     * be opened.\n     * @param url String URL that the message poster wants to open\n     * @returns {boolean} true if we allow this url to be opened in the window\n     */\n    function isValidUrlToOpen(url) {\n        if (!url) {\n            return false;\n        }\n\n        var parser = document.createElement('a');\n\n        parser.href = url;\n\n        if (parser.protocol === 'duotrustedendpoints:') {\n            return true;\n        } else if (parser.protocol !== 'https:') {\n            return false;\n        }\n\n        for (var i = 0; i < VALID_OPEN_WINDOW_DOMAINS.length; i++) {\n            if (parser.hostname.endsWith('.' + VALID_OPEN_WINDOW_DOMAINS[i]) ||\n              parser.hostname === VALID_OPEN_WINDOW_DOMAINS[i]) {\n                return true;\n            }\n        }\n\n        return false;\n    }\n\n    /**\n     * Point the iframe at Duo, then wait for it to postMessage back to us.\n     */\n    function ready() {\n        if (!host) {\n            host = getDataAttribute(iframe, 'host');\n\n            if (!host) {\n                throwError(\n                  'No API hostname is given for Duo to use.  Be sure to pass ' +\n                  'a `host` parameter to Duo.init, or through the `data-host` ' +\n                  'attribute on the iframe element.',\n                  'https://www.duosecurity.com/docs/duoweb#3.-show-the-iframe'\n                );\n            }\n        }\n\n        if (!duoSig || !appSig) {\n            parseSigRequest(getDataAttribute(iframe, 'sigRequest'));\n\n            if (!duoSig || !appSig) {\n                throwError(\n                  'No valid signed request is given.  Be sure to give the ' +\n                  '`sig_request` parameter to Duo.init, or use the ' +\n                  '`data-sig-request` attribute on the iframe element.',\n                  'https://www.duosecurity.com/docs/duoweb#3.-show-the-iframe'\n                );\n            }\n        }\n\n        // if postAction/Argument are defaults, see if they are specified\n        // as data attributes on the iframe\n        if (postAction === '') {\n            postAction = getDataAttribute(iframe, 'postAction') || postAction;\n        }\n\n        if (postArgument === 'sig_response') {\n            postArgument = getDataAttribute(iframe, 'postArgument') || postArgument;\n        }\n\n        // point the iframe at Duo\n        iframe.src = [\n          'https://', host, '/frame/web/v1/auth?tx=', duoSig,\n          '&parent=', encodeURIComponent(document.location.href),\n          '&v=2.6'\n        ].join('');\n\n        // listen for the 'message' event\n        onMessage(onReceivedMessage);\n    }\n\n    /**\n     * We received a postMessage from Duo.  POST back to the primary service\n     * with the response token, and any additional user-supplied parameters\n     * given in form#duo_form.\n     */\n    function doPostBack(response) {\n        // create a hidden input to contain the response token\n        var input = document.createElement('input');\n\n        input.type = 'hidden';\n        input.name = postArgument;\n        input.value = response + ':' + appSig;\n\n        // user may supply their own form with additional inputs\n        var form = document.getElementById('duo_form');\n\n        // if the form doesn't exist, create one\n        if (!form) {\n            form = document.createElement('form');\n\n            // insert the new form after the iframe\n            iframe.parentElement.insertBefore(form, iframe.nextSibling);\n        }\n\n        // make sure we are actually posting to the right place\n        form.method = 'POST';\n        form.action = postAction;\n\n        // add the response token input to the form\n        form.appendChild(input);\n\n        // away we go!\n        if (typeof submitCallback === 'function') {\n            submitCallback.call(null, form);\n        } else {\n            form.submit();\n        }\n    }\n\n    return {\n        init: init,\n        _onReady: onReady,\n        _parseSigRequest: parseSigRequest,\n        _isDuoMessage: isDuoMessage,\n        _doPostBack: doPostBack\n    };\n}));\n\n/* eslint-enable */\n","MSP_TwoFactorAuth/js/google/auth.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n    'jquery',\n    'ko',\n    'uiComponent',\n    'MSP_TwoFactorAuth/js/error',\n    'MSP_TwoFactorAuth/js/registry'\n], function ($, ko, Component, error, registry) {\n    return Component.extend({\n        currentStep: ko.observable('register'),\n        waitText: ko.observable(''),\n        verifyCode: ko.observable(''),\n        defaults: {\n            template: 'MSP_TwoFactorAuth/google/auth'\n        },\n\n        trustThisDevice: registry.trustThisDevice,\n\n        qrCodeUrl: '',\n        postUrl: '',\n        successUrl: '',\n        secretCode: '',\n\n        /**\n         * Get QR code URL\n         * @returns {String}\n         */\n        getQrCodeUrl: function () {\n            return this.qrCodeUrl;\n        },\n\n        /**\n         * Get POST URL\n         * @returns {String}\n         */\n        getPostUrl: function () {\n            return this.postUrl;\n        },\n\n        /**\n         * Get plain Secret Code\n         * @returns {string}\n         * @author Konrad Skrzynski <konrad.skrzynski@accenture.com>\n         */\n        getSecretCode: function() {\n            return this.secretCode;\n        },\n\n        /**\n         * Go to next step\n         */\n        nextStep: function () {\n            this.currentStep('login');\n            self.location.href = this.successUrl;\n        },\n\n        /**\n         * Verify auth code\n         */\n        doVerify: function () {\n            var me = this;\n\n            this.waitText('Please wait...');\n            $.post(this.getPostUrl(), {\n                'tfa_code': this.verifyCode(),\n                'tfa_trust_device': me.trustThisDevice() ? 1 : 0\n            })\n                .done(function (res) {\n                    if (res.success) {\n                        me.nextStep();\n                    } else {\n                        error.display(res.message);\n                        me.verifyCode('');\n                    }\n                    me.waitText('');\n                })\n                .fail(function () {\n                    error.display('There was an internal error trying to verify your code');\n                    me.waitText('');\n                });\n        }\n    });\n});\n","MSP_TwoFactorAuth/js/authy/auth.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n    'jquery',\n    'ko',\n    'uiComponent',\n    'MSP_TwoFactorAuth/js/error',\n    'MSP_TwoFactorAuth/js/registry',\n    'mage/translate'\n], function ($, ko, Component, error, registry) {\n    return Component.extend({\n        selectedMethod: ko.observable(''),\n        waitingText: ko.observable(''),\n        success: ko.observable(false),\n        tokenCode: ko.observable(''),\n\n        trustThisDevice: registry.trustThisDevice,\n\n        defaults: {\n            template: 'MSP_TwoFactorAuth/authy/auth'\n        },\n\n        waitForOneTouchApprovalTimeout: 0,\n\n        postUrl: '',\n        tokenRequestUrl: '',\n        oneTouchUrl: '',\n        verifyOneTouchUrl: '',\n\n        /**\n         * Get auth post URL\n         * @returns {String}\n         */\n        getPostUrl: function () {\n            return this.postUrl;\n        },\n\n        /**\n         * Get token request URL\n         * @returns {String}\n         */\n        getTokenRequestUrl: function () {\n            return this.tokenRequestUrl;\n        },\n\n        /**\n         * Get one touch request URL\n         * @returns {String}\n         */\n        getOneTouchUrl: function () {\n            return this.oneTouchUrl;\n        },\n\n        /**\n         * Get one touch verification URL\n         * @returns {String}\n         */\n        getVerifyOneTouchUrl: function () {\n            return this.verifyOneTouchUrl;\n        },\n\n        /**\n         * Get success URL\n         * @returns {String}\n         */\n        getSuccessUrl: function () {\n            return this.successUrl;\n        },\n\n        /**\n         * Go to login page\n         */\n        login: function () {\n            this.success(true);\n            self.location.href = this.getSuccessUrl();\n        },\n\n        /**\n         * Stop onetouch approval background approval\n         */\n        stopWaitingOnetouchApproval: function () {\n            if (this.waitForOneTouchApprovalTimeout) {\n                window.clearTimeout(this.waitForOneTouchApprovalTimeout);\n                this.waitForOneTouchApprovalTimeout = 0;\n            }\n        },\n\n        /**\n         * Switch to authy code validation\n         * @param {String} via\n         */\n        runSendCode: function (via) {\n            var me = this;\n\n            this.selectedMethod('code');\n\n            if (via !== 'token') {\n                $.getJSON(\n                    this.getTokenRequestUrl() + '?via=' +\n                    via + '&tfa_trust_device=' + (me.trustThisDevice() ? 1 : 0)\n                )\n                    .fail(function () {\n                        error.display('There was an error trying to contact Authy services');\n                        me.switchAnotherMethod();\n                    });\n            }\n        },\n\n        /**\n         * Switch to authy token code validation\n         */\n        runSendCodeToken: function () {\n            this.runSendCode('token');\n        },\n\n        /**\n         * Switch to authy sms code validation\n         */\n        runSendCodeSms: function () {\n            this.runSendCode('sms');\n        },\n\n        /**\n         * Switch to authy call code validation\n         */\n        runSendCodeCall: function () {\n            this.runSendCode('call');\n        },\n\n        /**\n         * Switch to one touch validation\n         */\n        runOneTouch: function () {\n            var me = this;\n\n            this.selectedMethod('onetouch');\n            this.waitingText('Sending push notification...');\n            this.success(false);\n\n            this.stopWaitingOnetouchApproval();\n\n            $.getJSON(this.getOneTouchUrl() + '?tfa_trust_device=' + (me.trustThisDevice() ? 1 : 0))\n                .done(function () {\n                    me.waitForOneTouchApproval();\n                })\n                .fail(function () {\n                    error.display('There was an error trying to contact Authy services');\n                    me.switchAnotherMethod();\n                });\n        },\n\n        /**\n         * Start background one touch approval check\n         */\n        waitForOneTouchApproval: function () {\n            var me = this;\n\n            this.waitingText('Waiting for approval...');\n\n            $.getJSON(this.getVerifyOneTouchUrl())\n                .done(function (res) {\n                    if (res.status === 'retry') {\n                        me.waitForOneTouchApprovalTimeout = window.setTimeout(function () {\n                            me.waitForOneTouchApproval();\n                        }, 1000);\n                    } else if (res.status === 'expired') {\n                        error.display($.mage.__('Your request has been expired'));\n                        me.switchAnotherMethod();\n                    } else if (res.status === 'denied') {\n                        error.display($.mage.__('Your request has been rejected'));\n                        me.switchAnotherMethod();\n                    } else if (res.status === 'approved') {\n                        me.login();\n                    }\n                })\n                .fail(function () {\n                    error.display('There was an error trying to contact Authy services');\n                    this.switchAnotherMethod();\n                });\n        },\n\n        /**\n         * Switch back to method selection\n         */\n        switchAnotherMethod: function () {\n            this.selectedMethod('');\n            this.waitingText('');\n            this.success(false);\n        },\n\n        /**\n         * Verify authy code\n         */\n        verifyCode: function () {\n            var me = this;\n\n            this.waitingText('Please wait...');\n\n            $.post(this.getPostUrl(), {\n                'tfa_code': this.tokenCode\n            })\n                .done(function (res) {\n                    if (res.success) {\n                        me.login();\n                    } else {\n                        error.display(res.message);\n                        me.waitingText('');\n                        me.tokenCode('');\n                    }\n                })\n                .fail(function () {\n                    error.display('There was an internal error trying to verify your code');\n                });\n        }\n    });\n});\n","MSP_TwoFactorAuth/js/authy/configure.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n    'ko',\n    'uiComponent',\n    'MSP_TwoFactorAuth/js/authy/configure/registry'\n], function (ko, Component, registry) {\n    return Component.extend({\n        currentStep: registry.currentStep,\n        defaults: {\n            template: 'MSP_TwoFactorAuth/authy/configure'\n        }\n    });\n});\n","MSP_TwoFactorAuth/js/authy/configure/registry.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n    'ko'\n], function (ko) {\n    return {\n        currentStep: ko.observable('register'),\n        messageText: ko.observable(''),\n        secondsToExpire: ko.observable(0)\n    };\n});\n","MSP_TwoFactorAuth/js/authy/configure/register.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n    'jquery',\n    'ko',\n    'uiComponent',\n    'MSP_TwoFactorAuth/js/error',\n    'MSP_TwoFactorAuth/js/authy/configure/registry',\n    'mage/translate'\n], function ($, ko, Component, error, registry) {\n    return Component.extend({\n        configurePostUrl: '',\n        countries: [],\n\n        country: ko.observable(''),\n        phone: ko.observable(''),\n        method: ko.observable(''),\n\n        waitText: ko.observable(''),\n\n        defaults: {\n            template: 'MSP_TwoFactorAuth/authy/configure/register'\n        },\n\n        /**\n         * Get configure POST url\n         * @returns {String}\n         */\n        getConfigurePostUrl: function () {\n            return this.configurePostUrl;\n        },\n\n        /**\n         * Get a list of available countries\n         * @returns {Array}\n         */\n        getCountries: function () {\n            return this.countries;\n        },\n\n        /**\n         * Go to next step\n         */\n        nextStep: function () {\n            registry.currentStep('verify');\n            window.setTimeout(function () {\n                registry.currentStep('register');\n            }, registry.secondsToExpire() * 1000);\n        },\n\n        /**\n         * Start Authy registration procedure\n         */\n        doRegister: function () {\n            var me = this;\n\n            this.waitText('Please wait...');\n            $.post(this.getConfigurePostUrl(), {\n                'tfa_country': this.country(),\n                'tfa_phone': this.phone(),\n                'tfa_method': this.method()\n\n            })\n                .done(function (res) {\n                    if (res.success) {\n                        registry.messageText(res.message);\n                        registry.secondsToExpire(res['seconds_to_expire']);\n                        me.nextStep();\n                    } else {\n                        error.display(res.message);\n                    }\n                    me.waitText('');\n                })\n                .fail(function () {\n                    error.display('There was an internal error trying to verify your code');\n                    me.waitText('');\n                });\n        }\n    });\n});\n","MSP_TwoFactorAuth/js/authy/configure/verify.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n    'jquery',\n    'ko',\n    'uiComponent',\n    'MSP_TwoFactorAuth/js/error',\n    'MSP_TwoFactorAuth/js/authy/configure/registry',\n    'mage/translate'\n], function ($, ko, Component, error, registry) {\n    return Component.extend({\n        verifyCode: ko.observable(''),\n        messageText: registry.messageText,\n        waitText: ko.observable(''),\n\n        verifyPostUrl: '',\n        successUrl: '',\n\n        defaults: {\n            template: 'MSP_TwoFactorAuth/authy/configure/verify'\n        },\n\n        /**\n         * Get verification post URL\n         * @returns {String}\n         */\n        getVerifyPostUrl: function () {\n            return this.verifyPostUrl;\n        },\n\n        /**\n         * Go to next step\n         */\n        nextStep: function () {\n            registry.currentStep('login');\n            self.location.href = this.successUrl;\n        },\n\n        /**\n         * Verify auth code\n         */\n        doVerify: function () {\n            var me = this;\n\n            this.waitText('Please wait...');\n            $.post(this.getVerifyPostUrl(), {\n                'tfa_verify': this.verifyCode()\n            })\n                .done(function (res) {\n                    if (res.success) {\n                        me.nextStep();\n                    } else {\n                        error.display(res.message);\n                    }\n                    me.waitText('');\n                })\n                .fail(function () {\n                    error.display('There was an internal error trying to verify your code');\n                    me.waitText('');\n                });\n        },\n\n        /**\n         * Go to previous step to change phone number\n         */\n        changePhoneNumber: function () {\n            registry.currentStep('register');\n        }\n    });\n});\n","MSP_TwoFactorAuth/js/u2fkey/auth.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n    'jquery',\n    'ko',\n    'uiComponent',\n    'MSP_TwoFactorAuth/js/error',\n    'MSP_TwoFactorAuth/js/registry',\n    'MSP_TwoFactorAuth/js/u2fkey/api'\n], function ($, ko, Component, error, registry) {\n    return Component.extend({\n        currentStep: ko.observable('register'),\n        trustThisDevice: registry.trustThisDevice,\n\n        defaults: {\n            template: 'MSP_TwoFactorAuth/u2fkey/auth'\n        },\n\n        postUrl: '',\n        successUrl: '',\n        touchImageUrl: '',\n        authenticateData: {},\n\n        /**\n         * Start waiting loop\n         */\n        onAfterRender: function () {\n            this.waitForTouch();\n        },\n\n        /**\n         * Get touch image URL\n         * @returns {String}\n         */\n        getTouchImageUrl: function () {\n            return this.touchImageUrl;\n        },\n\n        /**\n         * Get POST URL\n         * @returns {String}\n         */\n        getPostUrl: function () {\n            return this.postUrl;\n        },\n\n        /**\n         * Get success URL\n         * @returns {String}\n         */\n        getSuccessUrl: function () {\n            return this.successUrl;\n        },\n        /**\n         * Wait for key touch\n         */\n        waitForTouch: function () {\n            var requestData = this.authenticateData,\n                me = this;\n\n            // eslint-disable-next-line no-undef\n            u2f.sign(\n                requestData,\n                function (signResponse) {\n                    $.post(me.getPostUrl(), {\n                        'request': requestData,\n                        'response': signResponse,\n                        'tfa_trust_device': me.trustThisDevice() ? 1 : 0\n                    }).done(function (res) {\n                        if (res.success) {\n                            me.currentStep('login');\n                            self.location.href = me.getSuccessUrl();\n                        } else {\n                            me.waitForTouch();\n                        }\n                    }).fail(function () {\n                        error.display('Invalid device');\n                    });\n                }, 120\n            );\n        }\n    });\n});\n","MSP_TwoFactorAuth/js/u2fkey/configure.js":"/**\n * MageSpecialist\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the Open Software License (OSL 3.0)\n * that is bundled with this package in the file LICENSE.txt.\n * It is also available through the world-wide-web at this URL:\n * http://opensource.org/licenses/osl-3.0.php\n * If you did not receive a copy of the license and are unable to\n * obtain it through the world-wide-web, please send an email\n * to info@magespecialist.it so we can send you a copy immediately.\n *\n * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)\n * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)\n */\n\n'use strict';\n\ndefine([\n    'jquery',\n    'ko',\n    'uiComponent',\n    'MSP_TwoFactorAuth/js/error',\n    'MSP_TwoFactorAuth/js/u2fkey/api'\n], function ($, ko, Component, error) {\n    return Component.extend({\n        currentStep: ko.observable('register'),\n\n        defaults: {\n            template: 'MSP_TwoFactorAuth/u2fkey/configure'\n        },\n\n        postUrl: '',\n        successUrl: '',\n        touchImageUrl: '',\n        registerData: {},\n\n        /**\n         * Start waiting loop\n         */\n        onAfterRender: function () {\n            this.waitForTouch();\n        },\n\n        /**\n         * Get touch image URL\n         * @returns {String}\n         */\n        getTouchImageUrl: function () {\n            return this.touchImageUrl;\n        },\n\n        /**\n         * Get POST URL\n         * @returns {String}\n         */\n        getPostUrl: function () {\n            return this.postUrl;\n        },\n\n        /**\n         * Get success URL\n         * @returns {String}\n         */\n        getSuccessUrl: function () {\n            return this.successUrl;\n        },\n\n        /**\n         * Wait for key touch\n         */\n        waitForTouch: function () {\n            var requestData = this.registerData[0],\n                signs = this.registerData[1],\n                me = this;\n\n            // eslint-disable-next-line no-undef\n            u2f.register(\n                [requestData],\n                signs,\n                function (registerResponse) {\n                    $.post(me.getPostUrl(), {\n                        'request': requestData,\n                        'response': registerResponse\n                    }).done(function (res) {\n                        if (res.success) {\n                            me.currentStep('login');\n                            self.location.href = me.getSuccessUrl();\n                        } else {\n                            me.waitForTouch();\n                        }\n                    }).fail(function () {\n                        error.display('Unable to register your device');\n                    });\n                }, 120\n            );\n        }\n    });\n});\n","MSP_TwoFactorAuth/js/u2fkey/api.js":"// Copyright 2014-2015 Google Inc. All rights reserved.\n//\n// Use of this source code is governed by a BSD-style\n// license that can be found in the LICENSE file or at\n// https://developers.google.com/open-source/licenses/bsd\n\n/* eslint-disable */\n// jscs:disable\n\n/**\n * @fileoverview The U2F api.\n */\n\n'use strict';\n\n/** Namespace for the U2F api.\n * @type {Object}\n */\nvar u2f = u2f || {};\n\n/**\n * The U2F extension id\n * @type {String}\n * @const\n */\nu2f.EXTENSION_ID = 'kmendfapggjehodndflmmgagdbamhnfd';\n\n/**\n * Message types for messsages to/from the extension\n * @const\n * @enum {String}\n */\nu2f.MessageTypes = {\n    'U2F_REGISTER_REQUEST': 'u2f_register_request',\n    'U2F_SIGN_REQUEST': 'u2f_sign_request',\n    'U2F_REGISTER_RESPONSE': 'u2f_register_response',\n    'U2F_SIGN_RESPONSE': 'u2f_sign_response'\n};\n\n/**\n * Response status codes\n * @const\n * @enum {number}\n */\nu2f.ErrorCodes = {\n    'OK': 0,\n    'OTHER_ERROR': 1,\n    'BAD_REQUEST': 2,\n    'CONFIGURATION_UNSUPPORTED': 3,\n    'DEVICE_INELIGIBLE': 4,\n    'TIMEOUT': 5\n};\n\n/**\n * A message type for registration requests\n * @typedef {{\n *   type: u2f.MessageTypes,\n *   signRequests: Array<u2f.SignRequest>,\n *   registerRequests: ?Array<u2f.RegisterRequest>,\n *   timeoutSeconds: ?number,\n *   requestId: ?number\n * }}\n */\nu2f.Request;\n\n/**\n * A message for registration responses\n * @typedef {{\n *   type: u2f.MessageTypes,\n *   responseData: (u2f.Error | u2f.RegisterResponse | u2f.SignResponse),\n *   requestId: ?number\n * }}\n */\nu2f.Response;\n\n/**\n * An error object for responses\n * @typedef {{\n *   errorCode: u2f.ErrorCodes,\n *   errorMessage: ?string\n * }}\n */\nu2f.Error;\n\n/**\n * Data object for a single sign request.\n * @typedef {{\n *   version: string,\n *   challenge: string,\n *   keyHandle: string,\n *   appId: string\n * }}\n */\nu2f.SignRequest;\n\n/**\n * Data object for a sign response.\n * @typedef {{\n *   keyHandle: string,\n *   signatureData: string,\n *   clientData: string\n * }}\n */\nu2f.SignResponse;\n\n/**\n * Data object for a registration request.\n * @typedef {{\n *   version: string,\n *   challenge: string,\n *   appId: string\n * }}\n */\nu2f.RegisterRequest;\n\n/**\n * Data object for a registration response.\n * @typedef {{\n *   registrationData: string,\n *   clientData: string\n * }}\n */\nu2f.RegisterResponse;\n\n\n// Low level MessagePort API support\n\n/**\n * Sets up a MessagePort to the U2F extension using the\n * available mechanisms.\n * @param {function((MessagePort|u2f.WrappedChromeRuntimePort_))} callback\n */\nu2f.getMessagePort = function (callback) {\n    if (typeof chrome != 'undefined' && chrome.runtime) {\n        // The actual message here does not matter, but we need to get a reply\n        // for the callback to run. Thus, send an empty signature request\n        // in order to get a failure response.\n        var msg = {\n            type: u2f.MessageTypes.U2F_SIGN_REQUEST,\n            signRequests: []\n        };\n\n        chrome.runtime.sendMessage(u2f.EXTENSION_ID, msg, function () {\n            if (!chrome.runtime.lastError) {\n                // We are on a whitelisted origin and can talk directly\n                // with the extension.\n                u2f.getChromeRuntimePort_(callback);\n            } else {\n                // chrome.runtime was available, but we couldn't message\n                // the extension directly, use iframe\n                u2f.getIframePort_(callback);\n            }\n        });\n    } else if (u2f.isAndroidChrome_()) {\n        u2f.getAuthenticatorPort_(callback);\n    } else {\n        // chrome.runtime was not available at all, which is normal\n        // when this origin doesn't have access to any extensions.\n        u2f.getIframePort_(callback);\n    }\n};\n\n/**\n * Detect chrome running on android based on the browser's useragent.\n * @private\n */\nu2f.isAndroidChrome_ = function () {\n    var userAgent = navigator.userAgent;\n\n    return userAgent.indexOf('Chrome') != -1 &&\n        userAgent.indexOf('Android') != -1;\n};\n\n/**\n * Connects directly to the extension via chrome.runtime.connect\n * @param {function(u2f.WrappedChromeRuntimePort_)} callback\n * @private\n */\nu2f.getChromeRuntimePort_ = function (callback) {\n    var port = chrome.runtime.connect(u2f.EXTENSION_ID,\n        {\n        'includeTlsChannelId': true\n    });\n\n    setTimeout(function () {\n        callback(new u2f.WrappedChromeRuntimePort_(port));\n    }, 0);\n};\n\n/**\n * Return a 'port' abstraction to the Authenticator app.\n * @param {function(u2f.WrappedAuthenticatorPort_)} callback\n * @private\n */\nu2f.getAuthenticatorPort_ = function (callback) {\n    setTimeout(function () {\n        callback(new u2f.WrappedAuthenticatorPort_());\n    }, 0);\n};\n\n/**\n * A wrapper for chrome.runtime.Port that is compatible with MessagePort.\n * @param {Port} port\n * @constructor\n * @private\n */\nu2f.WrappedChromeRuntimePort_ = function (port) {\n    this.port_ = port;\n};\n\n/**\n * Format a return a sign request.\n * @param {Array<u2f.SignRequest>} signRequests\n * @param {number} timeoutSeconds\n * @param {number} reqId\n * @return {Object}\n */\nu2f.WrappedChromeRuntimePort_.prototype.formatSignRequest_ =\n    function (signRequests, timeoutSeconds, reqId) {\n        return {\n            type: u2f.MessageTypes.U2F_SIGN_REQUEST,\n            signRequests: signRequests,\n            timeoutSeconds: timeoutSeconds,\n            requestId: reqId\n        };\n    };\n\n/**\n * Format a return a register request.\n * @param {Array<u2f.SignRequest>} signRequests\n * @param {Array<u2f.RegisterRequest>} signRequests\n * @param {number} timeoutSeconds\n * @param {number} reqId\n * @return {Object}\n */\nu2f.WrappedChromeRuntimePort_.prototype.formatRegisterRequest_ =\n    function (signRequests, registerRequests, timeoutSeconds, reqId) {\n        return {\n            type: u2f.MessageTypes.U2F_REGISTER_REQUEST,\n            signRequests: signRequests,\n            registerRequests: registerRequests,\n            timeoutSeconds: timeoutSeconds,\n            requestId: reqId\n        };\n    };\n\n/**\n * Posts a message on the underlying channel.\n * @param {Object} message\n */\nu2f.WrappedChromeRuntimePort_.prototype.postMessage = function (message) {\n    this.port_.postMessage(message);\n};\n\n/**\n * Emulates the HTML 5 addEventListener interface. Works only for the\n * onmessage event, which is hooked up to the chrome.runtime.Port.onMessage.\n * @param {String} eventName\n * @param {function({data: Object})} handler\n */\nu2f.WrappedChromeRuntimePort_.prototype.addEventListener =\n    function (eventName, handler) {\n        var name = eventName.toLowerCase();\n\n        if (name == 'message' || name == 'onmessage') {\n            this.port_.onMessage.addListener(function (message) {\n                // Emulate a minimal MessageEvent object\n                handler({\n                    'data': message\n                });\n            });\n        } else {\n            console.error('WrappedChromeRuntimePort only supports onMessage');\n        }\n    };\n\n/**\n * Wrap the Authenticator app with a MessagePort interface.\n * @constructor\n * @private\n */\nu2f.WrappedAuthenticatorPort_ = function () {\n    this.requestId_ = -1;\n    this.requestObject_ = null;\n};\n\n/**\n * Launch the Authenticator intent.\n * @param {Object} message\n */\nu2f.WrappedAuthenticatorPort_.prototype.postMessage = function (message) {\n    var intentLocation = /** @type {String} */ message;\n\n    document.location = intentLocation;\n};\n\n/**\n * Emulates the HTML 5 addEventListener interface.\n * @param {String} eventName\n * @param {function({data: Object})} handler\n */\nu2f.WrappedAuthenticatorPort_.prototype.addEventListener =\n    function (eventName, handler) {\n        var name = eventName.toLowerCase();\n\n        if (name == 'message') {\n            var self = this;\n\n            /* Register a callback to that executes when\n             * chrome injects the response. */\n\n            window.addEventListener(\n                'message', self.onRequestUpdate_.bind(self, handler), false);\n        } else {\n            console.error('WrappedAuthenticatorPort only supports message');\n        }\n    };\n\n/**\n * Callback invoked  when a response is received from the Authenticator.\n * @param function({data: Object}) callback\n * @param {Object} message message Object\n */\nu2f.WrappedAuthenticatorPort_.prototype.onRequestUpdate_ =\n    function (callback, message) {\n        var messageObject = JSON.parse(message.data);\n        var intentUrl = messageObject['intentURL'];\n\n        var errorCode = messageObject['errorCode'];\n        var responseObject = null;\n\n        if (messageObject.hasOwnProperty('data')) {\n            responseObject = /** @type {Object} */\n                JSON.parse(messageObject['data']);\n            responseObject['requestId'] = this.requestId_;\n        }\n\n        /* Sign responses from the authenticator do not conform to U2F,\n         * convert to U2F here. */\n        responseObject = this.doResponseFixups_(responseObject);\n        callback({\n            'data': responseObject\n        });\n    };\n\n/**\n * Fixup the response provided by the Authenticator to conform with\n * the U2F spec.\n * @param {Object} responseData\n * @return {Object} the U2F compliant response object\n */\nu2f.WrappedAuthenticatorPort_.prototype.doResponseFixups_ =\n    function (responseObject) {\n        if (responseObject.hasOwnProperty('responseData')) {\n            return responseObject;\n        } else if (this.requestObject_['type'] != u2f.MessageTypes.U2F_SIGN_REQUEST) {\n            // Only sign responses require fixups.  If this is not a response\n            // to a sign request, then an internal error has occurred.\n            return {\n                'type': u2f.MessageTypes.U2F_REGISTER_RESPONSE,\n                'responseData': {\n                    'errorCode': u2f.ErrorCodes.OTHER_ERROR,\n                    'errorMessage': 'Internal error: invalid response from Authenticator'\n                }\n            };\n        }\n\n        /* Non-conformant sign response, do fixups. */\n        var encodedChallengeObject = responseObject['challenge'];\n\n        if (typeof encodedChallengeObject !== 'undefined') {\n            var challengeObject = JSON.parse(atob(encodedChallengeObject));\n            var serverChallenge = challengeObject['challenge'];\n            var challengesList = this.requestObject_['signData'];\n            var requestChallengeObject = null;\n\n            for (var i = 0; i < challengesList.length; i++) {\n                var challengeObject = challengesList[i];\n\n                if (challengeObject['keyHandle'] == responseObject['keyHandle']) {\n                    requestChallengeObject = challengeObject;\n                    break;\n                }\n            }\n        }\n        var responseData = {\n            'errorCode': responseObject['resultCode'],\n            'keyHandle': responseObject['keyHandle'],\n            'signatureData': responseObject['signature'],\n            'clientData': encodedChallengeObject\n        };\n\n        return {\n            'type': u2f.MessageTypes.U2F_SIGN_RESPONSE,\n            'responseData': responseData,\n            'requestId': responseObject['requestId']\n        };\n    };\n\n/**\n * Base URL for intents to Authenticator.\n * @const\n * @private\n */\nu2f.WrappedAuthenticatorPort_.INTENT_URL_BASE_ =\n    'intent:#Intent;action=com.google.android.apps.authenticator.AUTHENTICATE';\n\n/**\n * Format a return a sign request.\n * @param {Array<u2f.SignRequest>} signRequests\n * @param {number} timeoutSeconds (ignored for now)\n * @param {number} reqId\n * @return {String}\n */\nu2f.WrappedAuthenticatorPort_.prototype.formatSignRequest_ =\n    function (signRequests, timeoutSeconds, reqId) {\n        if (!signRequests || signRequests.length == 0) {\n            return null;\n        }\n\n        /* TODO(fixme): stash away requestId, as the authenticator app does\n         * not return it for sign responses. */\n        this.requestId_ = reqId;\n\n        /* TODO(fixme): stash away the signRequests, to deal with the legacy\n         * response format returned by the Authenticator app. */\n        this.requestObject_ = {\n            'type': u2f.MessageTypes.U2F_SIGN_REQUEST,\n            'signData': signRequests,\n            'requestId': reqId,\n            'timeout': timeoutSeconds\n        };\n\n        var appId = signRequests[0]['appId'];\n        var intentUrl =\n            u2f.WrappedAuthenticatorPort_.INTENT_URL_BASE_ +\n            ';S.appId=' + encodeURIComponent(appId) +\n            ';S.eventId=' + reqId +\n            ';S.challenges=' +\n            encodeURIComponent(\n                JSON.stringify(this.getBrowserDataList_(signRequests))) + ';end';\n\n        return intentUrl;\n    };\n\n/**\n * Get the browser data objects from the challenge list\n * @param {Array} challenges list of challenges\n * @return {Array} list of browser data objects\n * @private\n */\nu2f.WrappedAuthenticatorPort_\n    .prototype.getBrowserDataList_ = function (challenges) {\n    return challenges\n        .map(function (challenge) {\n            var browserData = {\n                'typ': 'navigator.id.getAssertion',\n                'challenge': challenge['challenge']\n            };\n            var challengeObject = {\n                'challenge': browserData,\n                'keyHandle': challenge['keyHandle']\n            };\n\n            return challengeObject;\n        });\n};\n\n/**\n * Format a return a register request.\n * @param {Array<u2f.SignRequest>} signRequests\n * @param {Array<u2f.RegisterRequest>} enrollChallenges\n * @param {number} timeoutSeconds (ignored for now)\n * @param {number} reqId\n * @return {Object}\n */\nu2f.WrappedAuthenticatorPort_.prototype.formatRegisterRequest_ =\n    function (signRequests, enrollChallenges, timeoutSeconds, reqId) {\n        if (!enrollChallenges || enrollChallenges.length == 0) {\n            return null;\n        }\n        // Assume the appId is the same for all enroll challenges.\n        var appId = enrollChallenges[0]['appId'];\n        var registerRequests = [];\n\n        for (var i = 0; i < enrollChallenges.length; i++) {\n            var registerRequest = {\n                'challenge': enrollChallenges[i]['challenge'],\n                'version': enrollChallenges[i]['version']\n            };\n\n            if (enrollChallenges[i]['appId'] != appId) {\n                // Only include the appId when it differs from the first appId.\n                registerRequest['appId'] = enrollChallenges[i]['appId'];\n            }\n            registerRequests.push(registerRequest);\n        }\n        var registeredKeys = [];\n\n        if (signRequests) {\n            for (i = 0; i < signRequests.length; i++) {\n                var key = {\n                    'keyHandle': signRequests[i]['keyHandle'],\n                    'version': signRequests[i]['version']\n                };\n                // Only include the appId when it differs from the appId that's\n                // being registered now.\n\n                if (signRequests[i]['appId'] != appId) {\n                    key['appId'] = signRequests[i]['appId'];\n                }\n                registeredKeys.push(key);\n            }\n        }\n        var request = {\n            'type': u2f.MessageTypes.U2F_REGISTER_REQUEST,\n            'appId': appId,\n            'registerRequests': registerRequests,\n            'registeredKeys': registeredKeys,\n            'requestId': reqId,\n            'timeoutSeconds': timeoutSeconds\n        };\n        var intentUrl =\n            u2f.WrappedAuthenticatorPort_.INTENT_URL_BASE_ +\n            ';S.request=' + encodeURIComponent(JSON.stringify(request)) +\n            ';end';\n\n        /* TODO(fixme): stash away requestId, this is is not necessary for\n         * register requests, but here to keep parity with sign.\n         */\n\n        this.requestId_ = reqId;\n\n        return intentUrl;\n    };\n\n\n/**\n * Sets up an embedded trampoline iframe, sourced from the extension.\n * @param {function(MessagePort)} callback\n * @private\n */\nu2f.getIframePort_ = function (callback) {\n    // Create the iframe\n    var iframeOrigin = 'chrome-extension://' + u2f.EXTENSION_ID;\n    var iframe = document.createElement('iframe');\n\n    iframe.src = iframeOrigin + '/u2f-comms.html';\n    iframe.setAttribute('style', 'display:none');\n    document.body.appendChild(iframe);\n\n    var channel = new MessageChannel();\n    var ready = function (message) {\n        if (message.data == 'ready') {\n            channel.port1.removeEventListener('message', ready);\n            callback(channel.port1);\n        } else {\n            console.error('First event on iframe port was not \"ready\"');\n        }\n    };\n\n    channel.port1.addEventListener('message', ready);\n    channel.port1.start();\n\n    iframe.addEventListener('load', function () {\n        // Deliver the port to the iframe and initialize\n        iframe.contentWindow.postMessage('init', iframeOrigin, [channel.port2]);\n    });\n};\n\n\n// High-level JS API\n\n/**\n * Default extension response timeout in seconds.\n * @const\n */\nu2f.EXTENSION_TIMEOUT_SEC = 30;\n\n/**\n * A singleton instance for a MessagePort to the extension.\n * @type {MessagePort|u2f.WrappedChromeRuntimePort_}\n * @private\n */\nu2f.port_ = null;\n\n/**\n * Callbacks waiting for a port\n * @type {Array<function((MessagePort|u2f.WrappedChromeRuntimePort_))>}\n * @private\n */\nu2f.waitingForPort_ = [];\n\n/**\n * A counter for requestIds.\n * @type {number}\n * @private\n */\nu2f.reqCounter_ = 0;\n\n/**\n * A map from requestIds to client callbacks\n * @type {Object.<number,(function((u2f.Error|u2f.RegisterResponse))\n *                       |function((u2f.Error|u2f.SignResponse)))>}\n * @private\n */\nu2f.callbackMap_ = {};\n\n/**\n * Creates or retrieves the MessagePort singleton to use.\n * @param {function((MessagePort|u2f.WrappedChromeRuntimePort_))} callback\n * @private\n */\nu2f.getPortSingleton_ = function (callback) {\n    if (u2f.port_) {\n        callback(u2f.port_);\n    } else {\n        if (u2f.waitingForPort_.length == 0) {\n            u2f.getMessagePort(function (port) {\n                u2f.port_ = port;\n                u2f.port_.addEventListener('message',\n                    /** @type {function(Event)} */ u2f.responseHandler_);\n\n                // Careful, here be async callbacks. Maybe.\n                while (u2f.waitingForPort_.length)\n                    u2f.waitingForPort_.shift()(u2f.port_);\n            });\n        }\n        u2f.waitingForPort_.push(callback);\n    }\n};\n\n/**\n * Handles response messages from the extension.\n * @param {MessageEvent.<u2f.Response>} message\n * @private\n */\nu2f.responseHandler_ = function (message) {\n    var response = message.data;\n    var reqId = response['requestId'];\n\n    if (!reqId || !u2f.callbackMap_[reqId]) {\n        console.error('Unknown or missing requestId in response.');\n\n        return;\n    }\n    var cb = u2f.callbackMap_[reqId];\n\n    delete u2f.callbackMap_[reqId];\n    cb(response['responseData']);\n};\n\n/**\n * Dispatches an array of sign requests to available U2F tokens.\n * @param {Array<u2f.SignRequest>} signRequests\n * @param {function((u2f.Error|u2f.SignResponse))} callback\n * @param {number=} opt_timeoutSeconds\n */\nu2f.sign = function (signRequests, callback, opt_timeoutSeconds) {\n    u2f.getPortSingleton_(function (port) {\n        var reqId = ++u2f.reqCounter_;\n\n        u2f.callbackMap_[reqId] = callback;\n        var timeoutSeconds = typeof opt_timeoutSeconds !== 'undefined' ?\n            opt_timeoutSeconds : u2f.EXTENSION_TIMEOUT_SEC;\n        var req = port.formatSignRequest_(signRequests, timeoutSeconds, reqId);\n\n        port.postMessage(req);\n    });\n};\n\n/**\n * Dispatches register requests to available U2F tokens. An array of sign\n * requests identifies already registered tokens.\n * @param {Array<u2f.RegisterRequest>} registerRequests\n * @param {Array<u2f.SignRequest>} signRequests\n * @param {function((u2f.Error|u2f.RegisterResponse))} callback\n * @param {number=} opt_timeoutSeconds\n */\nu2f.register = function (registerRequests, signRequests,\n                        callback, opt_timeoutSeconds) {\n    u2f.getPortSingleton_(function (port) {\n        var reqId = ++u2f.reqCounter_;\n\n        u2f.callbackMap_[reqId] = callback;\n        var timeoutSeconds = typeof opt_timeoutSeconds !== 'undefined' ?\n            opt_timeoutSeconds : u2f.EXTENSION_TIMEOUT_SEC;\n        var req = port.formatRegisterRequest_(\n            signRequests, registerRequests, timeoutSeconds, reqId);\n\n        port.postMessage(req);\n    });\n};\n\n/* eslint-enable */\n","Magento_Braintree/js/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/alert'\n], function ($, Class, alert) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            $selector: null,\n            selector: 'edit_form',\n            $container: null\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            self.$selector = $('#' + self.selector);\n            self.$container =  $('#' + self.container);\n            self.$selector.on(\n                'setVaultNotActive.' + self.getCode(),\n                function () {\n                    self.$selector.off('submitOrder.' + self.getCode());\n                }\n            );\n            self._super();\n\n            self.initEventHandlers();\n\n            return self;\n        },\n\n        /**\n         * Get payment code\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        },\n\n        /**\n         * Init event handlers\n         */\n        initEventHandlers: function () {\n            $(this.$container).find('[name=\"payment[token_switcher]\"]')\n                .on('click', this.selectPaymentMethod.bind(this));\n        },\n\n        /**\n         * Select current payment token\n         */\n        selectPaymentMethod: function () {\n            this.disableEventListeners();\n            this.enableEventListeners();\n        },\n\n        /**\n         * Enable form event listeners\n         */\n        enableEventListeners: function () {\n            this.$selector.on('submitOrder.' + this.getCode(), this.submitOrder.bind(this));\n        },\n\n        /**\n         * Disable form event listeners\n         */\n        disableEventListeners: function () {\n            this.$selector.off('submitOrder');\n        },\n\n        /**\n         * Pre submit for order\n         * @returns {Boolean}\n         */\n        submitOrder: function () {\n            this.$selector.validate().form();\n            this.$selector.trigger('afterValidate.beforeSubmit');\n            $('body').trigger('processStop');\n\n            // validate parent form\n            if (this.$selector.validate().errorList.length) {\n                return false;\n            }\n            this.getPaymentMethodNonce();\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            this.$selector.trigger('realOrder');\n        },\n\n        /**\n         * Send request to get payment method nonce\n         */\n        getPaymentMethodNonce: function () {\n            var self = this;\n\n            $('body').trigger('processStart');\n\n            $.getJSON(self.nonceUrl, {\n                'public_hash': self.publicHash\n            }).done(function (response) {\n                self.setPaymentDetails(response.paymentMethodNonce);\n                self.placeOrder();\n            }).fail(function (response) {\n                var failed = JSON.parse(response.responseText);\n\n                self.error(failed.message);\n            }).always(function () {\n                $('body').trigger('processStop');\n            });\n        },\n\n        /**\n         * Store payment details\n         * @param {String} nonce\n         */\n        setPaymentDetails: function (nonce) {\n            this.createPublicHashSelector();\n\n            this.$selector.find('[name=\"payment[public_hash]\"]').val(this.publicHash);\n            this.$container.find('#' + this.getNonceSelectorName()).val(nonce);\n        },\n\n        /**\n         * Creates public hash selector\n         */\n        createPublicHashSelector: function () {\n            var $input;\n\n            if (this.$container.find('#' + this.getNonceSelectorName()).size() === 0) {\n                $input = $('<input>').attr(\n                    {\n                        type: 'hidden',\n                        id: this.getNonceSelectorName(),\n                        name: 'payment[payment_method_nonce]'\n                    }\n                );\n\n                $input.appendTo(this.$container);\n                $input.prop('disabled', false);\n            }\n        },\n\n        /**\n         * Show alert message\n         * @param {String} message\n         */\n        error: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Get selector name for nonce input\n         * @returns {String}\n         */\n        getNonceSelectorName: function () {\n            return 'nonce_' + this.getCode();\n        }\n    });\n});\n","Magento_Braintree/js/validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        config: {},\n\n        /**\n         * Set configuration\n         * @param {Object} config\n         */\n        setConfig: function (config) {\n            this.config = config;\n        },\n\n        /**\n         * Get List of available card types\n         * @returns {*|exports.defaults.availableCardTypes|{}}\n         */\n        getAvailableCardTypes: function () {\n            return this.config.availableCardTypes;\n        },\n\n        /**\n         * Get list of card types\n         * @returns {Object}\n         */\n        getCcTypesMapper: function () {\n            return this.config.ccTypesMapper;\n        },\n\n        /**\n         * Find mage card type by Braintree type\n         * @param {String} type\n         * @param {Object} availableTypes\n         * @returns {*}\n         */\n        getMageCardType: function (type, availableTypes) {\n            var storedCardType = null,\n                mapper = this.getCcTypesMapper();\n\n            if (type && typeof mapper[type] !== 'undefined') {\n                storedCardType = mapper[type];\n\n                if (_.indexOf(availableTypes, storedCardType) !== -1) {\n                    return storedCardType;\n                }\n            }\n\n            return null;\n        },\n\n        /**\n         * Filter list of available card types\n         * @param {Object} availableTypes\n         * @param {Object} countrySpecificCardTypes\n         * @returns {Object}\n         */\n        collectTypes: function (availableTypes, countrySpecificCardTypes) {\n            var key,\n                filteredTypes = [];\n\n            for (key in availableTypes) {\n                if (_.indexOf(countrySpecificCardTypes, availableTypes[key]) !== -1) {\n                    filteredTypes.push(availableTypes[key]);\n                }\n            }\n\n            return filteredTypes;\n        },\n\n        /**\n         * Get list of card types for country\n         * @param {String} countryId\n         * @returns {*}\n         */\n        getCountrySpecificCardTypes: function (countryId) {\n            if (typeof this.config.countrySpecificCardTypes[countryId] !== 'undefined') {\n                return this.config.countrySpecificCardTypes[countryId];\n            }\n\n            return false;\n        }\n    };\n});\n","Magento_Braintree/js/braintree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/lib/view/utils/dom-observer',\n    'mage/translate',\n    'Magento_Braintree/js/validator'\n], function ($, Class, alert, domObserver, $t, validator) {\n    'use strict';\n\n    return Class.extend({\n\n        defaults: {\n            $selector: null,\n            selector: 'edit_form',\n            container: 'payment_form_braintree',\n            active: false,\n            scriptLoaded: false,\n            braintreeClient: null,\n            braintreeHostedFields: null,\n            hostedFieldsInstance: null,\n            selectedCardType: null,\n            selectorsMapper: {\n                'expirationMonth': 'expirationMonth',\n                'expirationYear': 'expirationYear',\n                'number': 'cc_number',\n                'cvv': 'cc_cid'\n            },\n            imports: {\n                onActiveChange: 'active'\n            }\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            validator.setConfig(this);\n\n            self.$selector = $('#' + self.selector);\n            this._super()\n                .observe([\n                    'active',\n                    'scriptLoaded',\n                    'selectedCardType'\n                ]);\n\n            // re-init payment method events\n            self.$selector.off('changePaymentMethod.' + this.code)\n                .on('changePaymentMethod.' + this.code, this.changePaymentMethod.bind(this));\n\n            // listen block changes\n            domObserver.get('#' + self.container, function () {\n                if (self.scriptLoaded()) {\n                    self.$selector.off('submit');\n                    self.initBraintree();\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Enable/disable current payment method\n         * @param {Object} event\n         * @param {String} method\n         * @returns {exports.changePaymentMethod}\n         */\n        changePaymentMethod: function (event, method) {\n            this.active(method === this.code);\n\n            return this;\n        },\n\n        /**\n         * Triggered when payment changed\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                this.$selector.off('submitOrder.braintree');\n\n                return;\n            }\n            this.disableEventListeners();\n            window.order.addExcludedPaymentMethod(this.code);\n\n            if (!this.clientToken) {\n                this.error($.mage.__('This payment is not available'));\n\n                return;\n            }\n\n            this.enableEventListeners();\n\n            if (!this.scriptLoaded()) {\n                this.loadScript();\n            }\n        },\n\n        /**\n         * Load external Braintree SDK\n         */\n        loadScript: function () {\n            var self = this,\n                state = self.scriptLoaded;\n\n            $('body').trigger('processStart');\n            require([this.sdkUrl, this.hostedFieldsSdkUrl], function (client, hostedFields) {\n                state(true);\n                self.braintreeClient = client;\n                self.braintreeHostedFields = hostedFields;\n                self.initBraintree();\n                $('body').trigger('processStop');\n            });\n        },\n\n        /**\n         * Retrieves client token and setup Braintree SDK\n         */\n        initBraintree: function () {\n            var self = this;\n\n            try {\n                $('body').trigger('processStart');\n\n                $.getJSON(self.clientTokenUrl).done(function (response) {\n                    self.clientToken = response.clientToken;\n                    self._initBraintree();\n                }).fail(function (response) {\n                    var failed = JSON.parse(response.responseText);\n\n                    $('body').trigger('processStop');\n                    self.error(failed.message);\n                });\n            } catch (e) {\n                $('body').trigger('processStop');\n                self.error(e.message);\n            }\n        },\n\n        /**\n         * Setup Braintree SDK\n         */\n        _initBraintree: function () {\n            var self = this;\n\n            self.disableEventListeners();\n\n            self.braintreeClient.create({\n                authorization: self.clientToken\n            })\n                .then(function (clientInstance) {\n                    return self.braintreeHostedFields.create({\n                        client: clientInstance,\n                        fields: self.getHostedFields()\n                    });\n                })\n                .then(function (hostedFieldsInstance) {\n                    self.hostedFieldsInstance = hostedFieldsInstance;\n                    self.enableEventListeners();\n                    self.fieldEventHandler(hostedFieldsInstance);\n                    $('body').trigger('processStop');\n                })\n                .catch(function () {\n                    self.error($t('Braintree can\\'t be initialized.'));\n                });\n        },\n\n        /**\n         * Get hosted fields configuration\n         * @returns {Object}\n         */\n        getHostedFields: function () {\n            var self = this,\n                fields = {\n                    number: {\n                        selector: self.getSelector('cc_number')\n                    },\n                    expirationMonth: {\n                        selector: self.getSelector('cc_exp_month'),\n                        placeholder: $t('MM')\n                    },\n                    expirationYear: {\n                        selector: self.getSelector('cc_exp_year'),\n                        placeholder: $t('YY')\n                    }\n                };\n\n            if (self.useCvv) {\n                fields.cvv = {\n                    selector: self.getSelector('cc_cid')\n                };\n            }\n\n            return fields;\n        },\n\n        /**\n         * Function to handle hosted fields events\n         * @param {Object} hostedFieldsInstance\n         */\n        fieldEventHandler: function (hostedFieldsInstance) {\n            var self = this,\n                $cardType = $('#' + self.container).find('.icon-type');\n\n            hostedFieldsInstance.on('empty', function (event) {\n                if (event.emittedBy === 'number') {\n                    $cardType.attr('class', 'icon-type');\n                    self.selectedCardType(null);\n                }\n\n            });\n\n            hostedFieldsInstance.on('validityChange', function (event) {\n                var field = event.fields[event.emittedBy],\n                    fieldKey = event.emittedBy;\n\n                if (fieldKey === 'number') {\n                    $cardType.addClass('icon-type-' + event.cards[0].type);\n                }\n\n                if (fieldKey in self.selectorsMapper && field.isValid === false) {\n                    self.addInvalidClass(self.selectorsMapper[fieldKey]);\n                }\n            });\n\n            hostedFieldsInstance.on('blur', function (event) {\n                if (event.emittedBy === 'number') {\n                    self.validateCardType();\n                }\n            });\n\n            hostedFieldsInstance.on('cardTypeChange', function (event) {\n                if (event.cards.length !== 1) {\n                    return;\n                }\n\n                $cardType.addClass('icon-type-' + event.cards[0].type);\n                self.selectedCardType(\n                    validator.getMageCardType(event.cards[0].type, self.getCcAvailableTypes())\n                );\n            });\n        },\n\n        /**\n         * Show alert message\n         * @param {String} message\n         */\n        error: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Enable form event listeners\n         */\n        enableEventListeners: function () {\n            this.$selector.on('submitOrder.braintree', this.submitOrder.bind(this));\n        },\n\n        /**\n         * Disable form event listeners\n         */\n        disableEventListeners: function () {\n            this.$selector.off('submitOrder');\n            this.$selector.off('submit');\n        },\n\n        /**\n         * Store payment details\n         * @param {String} nonce\n         */\n        setPaymentDetails: function (nonce) {\n            var $container = $('#' + this.container);\n\n            $container.find('[name=\"payment[payment_method_nonce]\"]').val(nonce);\n        },\n\n        /**\n         * Trigger order submit\n         */\n        submitOrder: function () {\n            var self = this;\n\n            self.$selector.validate().form();\n            self.$selector.trigger('afterValidate.beforeSubmit');\n\n            // validate parent form\n            if (self.$selector.validate().errorList.length) {\n                $('body').trigger('processStop');\n\n                return false;\n            }\n\n            if (!self.validateCardType()) {\n                return false;\n            }\n\n            self.hostedFieldsInstance.tokenize(function (err, payload) {\n                if (err) {\n                    self.error($t('Some payment input fields are invalid.'));\n\n                    return false;\n                }\n\n                self.setPaymentDetails(payload.nonce);\n                $('#' + self.container).find('[type=\"submit\"]').trigger('click');\n            });\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            $('#' + this.selector).trigger('realOrder');\n        },\n\n        /**\n         * Get list of currently available card types\n         * @returns {Array}\n         */\n        getCcAvailableTypes: function () {\n            var types = [],\n                $options = $(this.getSelector('cc_type')).find('option');\n\n            $.map($options, function (option) {\n                types.push($(option).val());\n            });\n\n            return types;\n        },\n\n        /**\n         * Validate current entered card type\n         * @returns {Boolean}\n         */\n        validateCardType: function () {\n            this.removeInvalidClass('cc_number');\n\n            if (!this.selectedCardType()) {\n                this.addInvalidClass('cc_number');\n\n                return false;\n            }\n            $(this.getSelector('cc_type')).val(this.selectedCardType());\n\n            return true;\n        },\n\n        /**\n         * Get jQuery selector\n         * @param {String} field\n         * @returns {String}\n         */\n        getSelector: function (field) {\n            return '#' + this.code + '_' + field;\n        },\n\n        /**\n         * Add invalid class to field.\n         *\n         * @param {String} field\n         * @returns void\n         * @private\n         */\n        addInvalidClass: function (field) {\n            $(this.getSelector(field)).addClass('braintree-hosted-fields-invalid');\n        },\n\n        /**\n         * Remove invalid class from field.\n         *\n         * @param {String} field\n         * @returns void\n         * @private\n         */\n        removeInvalidClass: function (field) {\n            $(this.getSelector(field)).removeClass('braintree-hosted-fields-invalid');\n        }\n    });\n});\n","Magento_Braintree/js/grid/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/grid/provider'\n], function (_, Provider) {\n    'use strict';\n\n    return Provider.extend({\n\n        /**\n         * Reload grid\n         * @returns {exports}\n         */\n        reload: function () {\n            if (this.hasFilters()) {\n                this._super();\n\n                return this;\n            }\n\n            this.trigger('reload');\n\n            this.onReload({\n                items: [],\n                totalRecords: 0\n            });\n\n            return this;\n        },\n\n        /**\n         * Has filters checker\n         * @returns {Boolean}\n         */\n        hasFilters: function () {\n            var params = this.params,\n                filters = params.filters || {};\n\n            return _.keys(filters).length > 1;\n        }\n    });\n});\n","Magento_InventoryGroupedProductAdminUi/js/form/element/grid-column-quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/grid/columns/column'\n], function ($t, Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryGroupedProductAdminUi/grid/column/quantity-per-source',\n            itemsToDisplay: 3,\n            showFullListDescription: $t('Show more...')\n        },\n\n        /**\n         * Get source items from product data.\n         *\n         * @param {Object} rowData\n         * @returns {Array}\n         */\n        getSourceItemsData: function (rowData) {\n            return rowData['quantity_per_source'];\n        }\n    });\n});\n","Magento_InventoryGroupedProductAdminUi/js/form/element/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract'\n], function ($t, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_InventoryGroupedProductAdminUi/dynamic-rows/cells/cell-source',\n            itemsToDisplay: 3,\n            isFullList: true,\n            showFullListDescription: $t('Show more...'),\n            listens: {\n                value: 'updateItems'\n            }\n        },\n\n        /**\n         * Observe elements.\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['items', 'isFullList']);\n\n            return this;\n        },\n\n        /**\n         * Prepare data to use.\n         *\n         * @param {Object} data\n         * @private\n         */\n        updateItems: function (data) {\n            this.isFullList(data.length > this.itemsToDisplay);\n            this.isFullList() ? this.items(data.slice(0, this.itemsToDisplay)) : this.items(data);\n        }\n    });\n});\n","Magento_Swatches/js/product-attributes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/prompt',\n    'uiRegistry',\n    'collapsable'\n], function ($, alert, prompt, rg) {\n    'use strict';\n\n    return function (optionConfig) {\n        var activePanelClass = 'selected-type-options',\n            swatchProductAttributes = {\n                frontendInput: $('#frontend_input'),\n                isFilterable: $('#is_filterable'),\n                isFilterableInSearch: $('#is_filterable_in_search'),\n                backendType: $('#backend_type'),\n                usedForSortBy: $('#used_for_sort_by'),\n                frontendClass: $('#frontend_class'),\n                isWysiwygEnabled: $('#is_wysiwyg_enabled'),\n                isHtmlAllowedOnFront: $('#is_html_allowed_on_front'),\n                isRequired: $('#is_required'),\n                isUnique: $('#is_unique'),\n                defaultValueText: $('#default_value_text'),\n                defaultValueTextarea: $('#default_value_textarea'),\n                defaultValueDate: $('#default_value_date'),\n                defaultValueYesno: $('#default_value_yesno'),\n                isGlobal: $('#is_global'),\n                useProductImageForSwatch: $('#use_product_image_for_swatch'),\n                updateProductPreviewImage: $('#update_product_preview_image'),\n                usedInProductListing: $('#used_in_product_listing'),\n                isVisibleOnFront: $('#is_visible_on_front'),\n                position: $('#position'),\n                attrTabsFront: $('#product_attribute_tabs_front'),\n\n                /**\n                 * @returns {*|jQuery|HTMLElement}\n                 */\n                get tabsFront() {\n                    return this.attrTabsFront.length ? this.attrTabsFront.closest('li') : $('#front_fieldset-wrapper');\n                },\n                selectFields: ['boolean', 'select', 'multiselect', 'price', 'swatch_text', 'swatch_visual'],\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                toggleApplyVisibility: function (select) {\n                    if ($(select).val() === 1) {\n                        $(select).next('select').removeClass('no-display');\n                        $(select).next('select').removeClass('ignore-validate');\n                    } else {\n                        $(select).next('select').addClass('no-display');\n                        $(select).next('select').addClass('ignore-validate');\n                        $(select).next('select option:selected').each(function () {\n                            this.selected = false;\n                        });\n                    }\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                checkOptionsPanelVisibility: function () {\n                    var selectOptionsPanel = $('#manage-options-panel'),\n                        visualOptionsPanel = $('#swatch-visual-options-panel'),\n                        textOptionsPanel = $('#swatch-text-options-panel');\n\n                    this._hidePanel(selectOptionsPanel);\n                    this._hidePanel(visualOptionsPanel);\n                    this._hidePanel(textOptionsPanel);\n\n                    switch (this.frontendInput.val()) {\n                        case 'swatch_visual':\n                            this._showPanel(visualOptionsPanel);\n                            break;\n\n                        case 'swatch_text':\n                            this._showPanel(textOptionsPanel);\n                            break;\n\n                        case 'select':\n                        case 'multiselect':\n                            this._showPanel(selectOptionsPanel);\n                            break;\n                    }\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                bindAttributeInputType: function () {\n                    this.checkOptionsPanelVisibility();\n                    this.switchDefaultValueField();\n\n                    if (!~$.inArray(this.frontendInput.val(), this.selectFields)) {\n                        // not in array\n                        this.isFilterable.selectedIndex = 0;\n                        this._disable(this.isFilterable);\n                        this._disable(this.isFilterableInSearch);\n                    } else {\n                        // in array\n                        this._enable(this.isFilterable);\n                        this._enable(this.isFilterableInSearch);\n                        this.backendType.val('int');\n                    }\n\n                    if (this.frontendInput.val() === 'multiselect' ||\n                        this.frontendInput.val() === 'gallery' ||\n                        this.frontendInput.val() === 'textarea'\n                    ) {\n                        this._disable(this.usedForSortBy);\n                    } else {\n                        this._enable(this.usedForSortBy);\n                    }\n\n                    if (this.frontendInput.val() === 'swatch_text') {\n                        $('.swatch-text-field-0').addClass('required-option');\n                    } else {\n                        $('.swatch-text-field-0').removeClass('required-option');\n                    }\n\n                    this.setRowVisibility(this.isWysiwygEnabled, false);\n                    this.setRowVisibility(this.isHtmlAllowedOnFront, false);\n\n                    switch (this.frontendInput.val()) {\n                        case 'textarea':\n                            this.setRowVisibility(this.isWysiwygEnabled, true);\n\n                            if (this.isWysiwygEnabled.val() === '0') {\n                                this._enable(this.isHtmlAllowedOnFront);\n                            }\n                            this.frontendClass.val('');\n                            this._disable(this.frontendClass);\n                            break;\n\n                        case 'text':\n                            this.setRowVisibility(this.isHtmlAllowedOnFront, true);\n                            this._enable(this.frontendClass);\n                            break;\n\n                        case 'select':\n                        case 'multiselect':\n                            this.setRowVisibility(this.isHtmlAllowedOnFront, true);\n                            this.frontendClass.val('');\n                            this._disable(this.frontendClass);\n                            break;\n                        default:\n                            this.frontendClass.val('');\n                            this._disable(this.frontendClass);\n                    }\n\n                    this.switchIsFilterable();\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                switchIsFilterable: function () {\n                    if (this.isFilterable.selectedIndex === 0) {\n                        this._disable(this.position);\n                    } else {\n                        this._enable(this.position);\n                    }\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                switchDefaultValueField: function () {\n                    var currentValue = this.frontendInput.val(),\n                        defaultValueTextVisibility = false,\n                        defaultValueTextareaVisibility = false,\n                        defaultValueDateVisibility = false,\n                        defaultValueYesnoVisibility = false,\n                        scopeVisibility = true,\n                        useProductImageForSwatch = false,\n                        defaultValueUpdateImage = false,\n                        optionDefaultInputType = '',\n                        isFrontTabHidden = false,\n                        thing = this;\n\n                    if (!this.frontendInput.length) {\n                        return;\n                    }\n\n                    switch (currentValue) {\n                        case 'select':\n                            optionDefaultInputType = 'radio';\n                            break;\n\n                        case 'multiselect':\n                            optionDefaultInputType = 'checkbox';\n                            break;\n\n                        case 'date':\n                            defaultValueDateVisibility = true;\n                            break;\n\n                        case 'boolean':\n                            defaultValueYesnoVisibility = true;\n                            break;\n\n                        case 'textarea':\n                        case 'texteditor':\n                            defaultValueTextareaVisibility = true;\n                            break;\n\n                        case 'media_image':\n                            defaultValueTextVisibility = false;\n                            break;\n\n                        case 'price':\n                            scopeVisibility = false;\n                            break;\n\n                        case 'swatch_visual':\n                            useProductImageForSwatch = true;\n                            defaultValueUpdateImage = true;\n                            defaultValueTextVisibility = false;\n                            break;\n\n                        case 'swatch_text':\n                            useProductImageForSwatch = false;\n                            defaultValueUpdateImage = true;\n                            defaultValueTextVisibility = false;\n                            break;\n                        default:\n                            defaultValueTextVisibility = true;\n                            break;\n                    }\n\n                    delete optionConfig.hiddenFields['swatch_visual'];\n                    delete optionConfig.hiddenFields['swatch_text'];\n\n                    if (currentValue === 'media_image') {\n                        this.tabsFront.hide();\n                        this.setRowVisibility(this.isRequired, false);\n                        this.setRowVisibility(this.isUnique, false);\n                        this.setRowVisibility(this.frontendClass, false);\n                    } else if (optionConfig.hiddenFields[currentValue]) {\n                        $.each(optionConfig.hiddenFields[currentValue], function (key, option) {\n                            switch (option) {\n                                case '_front_fieldset':\n                                    thing.tabsFront.hide();\n                                    isFrontTabHidden = true;\n                                    break;\n\n                                case '_default_value':\n                                    defaultValueTextVisibility = false;\n                                    defaultValueTextareaVisibility = false;\n                                    defaultValueDateVisibility = false;\n                                    defaultValueYesnoVisibility = false;\n                                    break;\n\n                                case '_scope':\n                                    scopeVisibility = false;\n                                    break;\n                                default:\n                                    thing.setRowVisibility($('#' + option), false);\n                            }\n                        });\n\n                        if (!isFrontTabHidden) {\n                            thing.tabsFront.show();\n                        }\n\n                    } else {\n                        this.tabsFront.show();\n                        this.showDefaultRows();\n                    }\n\n                    this.setRowVisibility(this.defaultValueText, defaultValueTextVisibility);\n                    this.setRowVisibility(this.defaultValueTextarea, defaultValueTextareaVisibility);\n                    this.setRowVisibility(this.defaultValueDate, defaultValueDateVisibility);\n                    this.setRowVisibility(this.defaultValueYesno, defaultValueYesnoVisibility);\n                    this.setRowVisibility(this.isGlobal, scopeVisibility);\n\n                    /* swatch attributes */\n                    this.setRowVisibility(this.useProductImageForSwatch, useProductImageForSwatch);\n                    this.setRowVisibility(this.updateProductPreviewImage, defaultValueUpdateImage);\n\n                    $('input[name=\\'default[]\\']').each(function () {\n                        $(this).attr('type', optionDefaultInputType);\n                    });\n                },\n\n                /**\n                 * @this {swatchProductAttributes}\n                 */\n                showDefaultRows: function () {\n                    this.setRowVisibility(this.isRequired, true);\n                    this.setRowVisibility(this.isUnique, true);\n                    this.setRowVisibility(this.frontendClass, true);\n                },\n\n                /**\n                 * @param {Object} el\n                 * @param {Boolean} isVisible\n                 * @this {swatchProductAttributes}\n                 */\n                setRowVisibility: function (el, isVisible) {\n                    if (isVisible) {\n                        el.show();\n                        el.closest('.field').show();\n                    } else {\n                        el.hide();\n                        el.closest('.field').hide();\n                    }\n                },\n\n                /**\n                 * @param {Object} el\n                 * @this {swatchProductAttributes}\n                 */\n                _disable: function (el) {\n                    el.attr('disabled', 'disabled');\n                },\n\n                /**\n                 * @param {Object} el\n                 * @this {swatchProductAttributes}\n                 */\n                _enable: function (el) {\n                    if (!el.attr('readonly')) {\n                        el.removeAttr('disabled');\n                    }\n                },\n\n                /**\n                 * @param {Object} el\n                 * @this {swatchProductAttributes}\n                 */\n                _showPanel: function (el) {\n                    el.closest('.fieldset').show();\n                    el.addClass(activePanelClass);\n                    this._render(el.attr('id'));\n                },\n\n                /**\n                 * @param {Object} el\n                 * @this {swatchProductAttributes}\n                 */\n                _hidePanel: function (el) {\n                    el.closest('.fieldset').hide();\n                    el.removeClass(activePanelClass);\n                },\n\n                /**\n                 * @param {String} id\n                 * @this {swatchProductAttributes}\n                 */\n                _render: function (id) {\n                    rg.get(id, function () {\n                        $('#' + id).trigger('render');\n                    });\n                },\n\n                /**\n                 * @param {String} promptMessage\n                 * @this {swatchProductAttributes}\n                 */\n                saveAttributeInNewSet: function (promptMessage) {\n\n                    prompt({\n                        content: promptMessage,\n                        actions: {\n\n                            /**\n                             * @param {String} val\n                             * @this {actions}\n                             */\n                            confirm: function (val) {\n                                var rules = ['required-entry', 'validate-no-html-tags'],\n                                    newAttributeSetNameInputId = $('#new_attribute_set_name'),\n                                    editForm = $('#edit_form'),\n                                    newAttributeSetName = val,\n                                    i;\n\n                                if (!newAttributeSetName) {\n                                    return;\n                                }\n\n                                for (i = 0; i < rules.length; i++) {\n                                    if (!$.validator.methods[rules[i]](newAttributeSetName)) {\n                                        alert({\n                                            content: $.validator.messages[rules[i]]\n                                        });\n\n                                        return;\n                                    }\n                                }\n\n                                if (newAttributeSetNameInputId.length) {\n                                    newAttributeSetNameInputId.val(newAttributeSetName);\n                                } else {\n                                    editForm.append(new Element('input', {\n                                            type: 'hidden',\n                                            id: newAttributeSetNameInputId,\n                                            name: 'new_attribute_set_name',\n                                            value: newAttributeSetName\n                                        })\n                                    );\n                                }\n                                // Temporary solution will replaced after refactoring of attributes functionality\n                                editForm.triggerHandler('save');\n                            }\n                        }\n                    });\n                }\n            };\n\n        $(function () {\n            var editForm = $('#edit_form'),\n                swatchVisualPanel = $('#swatch-visual-options-panel'),\n                swatchTextPanel = $('#swatch-text-options-panel'),\n                tableBody = $(),\n                activePanel = $();\n\n            $('#frontend_input').bind('change', function () {\n                swatchProductAttributes.bindAttributeInputType();\n            });\n            $('#is_filterable').bind('change', function () {\n                swatchProductAttributes.switchIsFilterable();\n            });\n\n            swatchProductAttributes.bindAttributeInputType();\n\n            // @todo: refactor collapsible component\n            $('.attribute-popup .collapse, [data-role=\"advanced_fieldset-content\"]')\n                .collapsable()\n                .collapse('hide');\n\n            editForm.on('beforeSubmit', function () {\n                var optionContainer, optionsValues;\n\n                activePanel = swatchTextPanel.hasClass(activePanelClass) ? swatchTextPanel : swatchVisualPanel;\n                optionContainer = activePanel.find('table tbody');\n\n                if (activePanel.hasClass(activePanelClass)) {\n                    optionsValues = $.map(\n                        optionContainer.find('tr'),\n                        function (row) {\n                            return $(row).find('input, select, textarea').serialize();\n                        }\n                    );\n                    $('<input>')\n                        .attr({\n                            type: 'hidden',\n                            name: 'serialized_options'\n                        })\n                        .val(JSON.stringify(optionsValues))\n                        .prependTo(editForm);\n                }\n\n                tableBody = optionContainer.detach();\n            });\n\n            editForm.on('afterValidate.error highlight.validate', function () {\n                if (activePanel.hasClass(activePanelClass)) {\n                    activePanel.find('table').append(tableBody);\n                    $('input[name=\"serialized_options\"]').remove();\n                }\n            });\n        });\n\n        window.saveAttributeInNewSet = swatchProductAttributes.saveAttributeInNewSet;\n        window.toggleApplyVisibility = swatchProductAttributes.toggleApplyVisibility;\n    };\n});\n","Magento_Swatches/js/visual.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global $break $ $$ FORM_KEY */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'uiRegistry',\n    'jquery/colorpicker/js/colorpicker',\n    'prototype',\n    'jquery/ui'\n], function (jQuery, mageTemplate, rg) {\n    'use strict';\n\n    return function (config) {\n        var swatchOptionVisualDefaultInputType = 'radio',\n            swatchVisualOption = {\n                table: $('swatch-visual-options-table'),\n                itemCount: 0,\n                totalItems: 0,\n                rendered: 0,\n                isReadOnly: config.isReadOnly,\n                template: mageTemplate('#swatch-visual-row-template'),\n\n                /**\n                 * Add new option using template\n                 *\n                 * @param {Object} data\n                 * @param {Object} render\n                 */\n                add: function (data, render) {\n                    var isNewOption = false,\n                        element;\n\n                    if (typeof data.id == 'undefined') {\n                        data = {\n                            'id': 'option_' + this.itemCount,\n                            'sort_order': this.itemCount + 1,\n                            'empty_class': 'unavailable'\n                        };\n                        isNewOption = true;\n                    } else if (data.defaultswatch0 === '') {\n                        data['empty_class'] = 'unavailable';\n                    }\n\n                    if (!data.intype) {\n                        data.intype = swatchOptionVisualDefaultInputType;\n                    }\n\n                    element = this.template({\n                        data: data\n                    });\n\n                    if (isNewOption && !this.isReadOnly) {\n                        this.enableNewOptionDeleteButton(data.id);\n                    }\n                    this.itemCount++;\n                    this.totalItems++;\n                    this.elements += element;\n\n                    if (render) {\n                        this.render();\n                    }\n                },\n\n                /**\n                 * ColorPicker initialization process\n                 */\n                initColorPicker: function () {\n                    var element = this,\n                        hiddenColorPicker = !jQuery(element).data('colorpickerId');\n\n                    jQuery(this).ColorPicker({\n\n                        /**\n                         * ColorPicker onShow action\n                         */\n                        onShow: function () {\n                            var color = jQuery(element).parent().parent().prev().prev('input').val(),\n                                menu = jQuery(this).parents('.swatch_sub-menu_container');\n\n                            menu.hide();\n                            jQuery(element).ColorPickerSetColor(color);\n                        },\n\n                        /**\n                         * ColorPicker onSubmit action\n                         *\n                         * @param {String} hsb\n                         * @param {String} hex\n                         * @param {String} rgb\n                         * @param {String} el\n                         */\n                        onSubmit: function (hsb, hex, rgb, el) {\n                            var container = jQuery(el).parent().parent().prev();\n\n                            jQuery(el).ColorPickerHide();\n                            container.parent().removeClass('unavailable');\n                            container.prev('input').val('#' + hex);\n                            container.css('background', '#' + hex);\n                        }\n                    });\n\n                    if (hiddenColorPicker) {\n                        jQuery(this).ColorPickerShow();\n                    }\n                },\n\n                /**\n                 * Remove action\n                 *\n                 * @param {Object} event\n                 */\n                remove: function (event) {\n                    var element = $(Event.findElement(event, 'tr')),\n                        elementFlags; // !!! Button already have table parent in safari\n\n                    // Safari workaround\n                    element.ancestors().each(function (parentItem) {\n                        if (parentItem.hasClassName('option-row')) {\n                            element = parentItem;\n                            throw $break;\n                        } else if (parentItem.hasClassName('box')) {\n                            throw $break;\n                        }\n                    });\n\n                    if (element) {\n                        elementFlags = element.getElementsByClassName('delete-flag');\n\n                        if (elementFlags[0]) {\n                            elementFlags[0].value = 1;\n                        }\n\n                        element.addClassName('no-display');\n                        element.addClassName('template');\n                        element.hide();\n                        this.totalItems--;\n                        this.updateItemsCountField();\n                    }\n                },\n\n                /**\n                 * Update items count field\n                 */\n                updateItemsCountField: function () {\n                    $('swatch-visual-option-count-check').value = this.totalItems > 0 ? '1' : '';\n                },\n\n                /**\n                 * Enable delete button for new option\n                 *\n                 * @param {String} id\n                 */\n                enableNewOptionDeleteButton: function (id) {\n                    $$('#delete_button_swatch_container_' + id + ' button').each(function (button) {\n                        button.enable();\n                        button.removeClassName('disabled');\n                    });\n                },\n\n                /**\n                 * Bind remove button\n                 */\n                bindRemoveButtons: function () {\n                    jQuery('#swatch-visual-options-panel').on('click', '.delete-option', this.remove.bind(this));\n                },\n\n                /**\n                 * Render options\n                 */\n                render: function () {\n                    Element.insert($$('[data-role=swatch-visual-options-container]')[0], this.elements);\n                    this.elements = '';\n                },\n\n                /**\n                 * Render elements with delay (performance fix)\n                 *\n                 * @param {Object} data\n                 * @param {Number} from\n                 * @param {Number} step\n                 * @param {Number} delay\n                 * @returns {Boolean}\n                 */\n                renderWithDelay: function (data, from, step, delay) {\n                    var arrayLength = data.length,\n                        len;\n\n                    for (len = from + step; from < len && from < arrayLength; from++) {\n                        this.add(data[from]);\n                    }\n                    this.render();\n\n                    if (from === arrayLength) {\n                        this.updateItemsCountField();\n                        this.rendered = 1;\n                        jQuery('body').trigger('processStop');\n\n                        return true;\n                    }\n                    setTimeout(this.renderWithDelay.bind(this, data, from, step, delay), delay);\n                },\n\n                /**\n                 * Ignore validate action\n                 */\n                ignoreValidate: function () {\n                    var ignore = '.ignore-validate input, ' +\n                        '.ignore-validate select, ' +\n                        '.ignore-validate textarea';\n\n                    jQuery('#edit_form').data('validator').settings.forceIgnore = ignore;\n                }\n            };\n\n        if ($('add_new_swatch_visual_option_button')) {\n            Event.observe(\n                'add_new_swatch_visual_option_button',\n                'click',\n                swatchVisualOption.add.bind(swatchVisualOption, {}, true)\n            );\n        }\n\n        jQuery('#swatch-visual-options-panel').on('render', function () {\n            swatchVisualOption.ignoreValidate();\n\n            if (swatchVisualOption.rendered) {\n                return false;\n            }\n            jQuery('body').trigger('processStart');\n            swatchVisualOption.renderWithDelay(config.attributesData, 0, 100, 300);\n            swatchVisualOption.bindRemoveButtons();\n            jQuery('#swatch-visual-options-panel').on(\n                'click',\n                '.colorpicker_handler',\n                swatchVisualOption.initColorPicker\n            );\n        });\n        jQuery('body').on('click', function (event) {\n            var element = jQuery(event.target);\n\n            if (\n                element.parents('.swatch_sub-menu_container').length === 1 ||\n                element.next('div.swatch_sub-menu_container').length === 1\n            ) {\n                return true;\n            }\n            jQuery('.swatch_sub-menu_container').hide();\n        });\n\n        if (config.isSortable) {\n            jQuery(function ($) {\n                $('[data-role=swatch-visual-options-container]').sortable({\n                    distance: 8,\n                    tolerance: 'pointer',\n                    cancel: 'input, button',\n                    axis: 'y',\n\n                    /**\n                     * Update component\n                     */\n                    update: function () {\n                        $('[data-role=swatch-visual-options-container] [data-role=order]').each(\n                            function (index, element) {\n                                $(element).val(index + 1);\n                            }\n                        );\n                    }\n                });\n            });\n        }\n\n        window.swatchVisualOption = swatchVisualOption;\n        window.swatchOptionVisualDefaultInputType = swatchOptionVisualDefaultInputType;\n\n        rg.set('swatch-visual-options-panel', swatchVisualOption);\n\n        jQuery(function ($) {\n\n            var swatchComponents = {\n\n                /**\n                 * div wrapper for to hide all evement\n                 */\n                wrapper: null,\n\n                /**\n                 * iframe component to perform file upload without page reload\n                 */\n                iframe: null,\n\n                /**\n                 * form component for upload image\n                 */\n                form: null,\n\n                /**\n                 * Input file component for upload image\n                 */\n                inputFile: null,\n\n                /**\n                 * Create swatch component for upload files\n                 *\n                 * @this {swatchComponents}\n                 * @public\n                 */\n                create: function () {\n                    this.wrapper = $('<div>').css({\n                        display: 'none'\n                    }).appendTo($('body'));\n\n                    this.iframe = $('<iframe />', {\n                        id:  'upload_iframe',\n                        name: 'upload_iframe'\n                    }).appendTo(this.wrapper);\n\n                    this.form = $('<form />', {\n                        id: 'swatch_form_image_upload',\n                        name: 'swatch_form_image_upload',\n                        target: 'upload_iframe',\n                        method: 'post',\n                        enctype: 'multipart/form-data',\n                        class: 'ignore-validate',\n                        action: config.uploadActionUrl\n                    }).appendTo(this.wrapper);\n\n                    this.inputFile = $('<input />', {\n                        type: 'file',\n                        name: 'datafile',\n                        class: 'swatch_option_file'\n                    }).appendTo(this.form);\n\n                    $('<input />', {\n                        type: 'hidden',\n                        name: 'form_key',\n                        value: FORM_KEY\n                    }).appendTo(this.form);\n                }\n            };\n\n            /**\n             * Create swatch components\n             */\n            swatchComponents.create();\n\n            /**\n             * Register event for swatch input[type=file] change\n             */\n            swatchComponents.inputFile.change(function () {\n                var container = $('#' + $(this).attr('data-called-by')).parents().eq(2).children('.swatch_window'),\n\n                    /**\n                     * @this {iframe}\n                     */\n                    iframeHandler = function () {\n                        var imageParams = $.parseJSON($(this).contents().find('body').html()),\n                            fullMediaUrl = imageParams['swatch_path'] + imageParams['file_path'];\n\n                        container.prev('input').val(imageParams['file_path']);\n                        container.css({\n                            'background-image': 'url(' + fullMediaUrl + ')',\n                            'background-size': 'cover'\n                        });\n                        container.parent().removeClass('unavailable');\n                    };\n\n                swatchComponents.iframe.off('load');\n                swatchComponents.iframe.load(iframeHandler);\n                swatchComponents.form.submit();\n                $(this).val('');\n            });\n\n            /**\n             * Register event for choose \"upload image\" option\n             */\n            $(document).on('click', '.btn_choose_file_upload', function () {\n                swatchComponents.inputFile.attr('data-called-by', $(this).attr('id'));\n                swatchComponents.inputFile.click();\n            });\n\n            /**\n             * Register event for remove option\n             */\n            $(document).on('click', '.btn_remove_swatch', function () {\n                var optionPanel = $(this).parents().eq(2);\n\n                optionPanel.children('input').val('');\n                optionPanel.children('.swatch_window').css('background', '');\n\n                optionPanel.addClass('unavailable');\n\n                jQuery('.swatch_sub-menu_container').hide();\n            });\n\n            /**\n             * Toggle color upload chooser\n             */\n            $(document).on('click', '.swatch_window', function () {\n                $(this).next('div').toggle();\n            });\n        });\n    };\n});\n","Magento_Swatches/js/text.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global $break $ $$ */\n\n/**\n *  @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'uiRegistry',\n    'jquery/ui',\n    'prototype'\n], function (jQuery, mageTemplate, rg) {\n    'use strict';\n\n    return function (config) {\n        var swatchOptionTextDefaultInputType = 'radio',\n            swatchTextOption = {\n                table: $('swatch-text-options-table'),\n                itemCount: 0,\n                totalItems: 0,\n                rendered: 0,\n                isReadOnly: config.isReadOnly,\n                template: mageTemplate('#swatch-text-row-template'),\n\n                /**\n                 * Add option\n                 *\n                 * @param {Object} data\n                 * @param {Object} render\n                 */\n                add: function (data, render) {\n                    var isNewOption = false,\n                        element;\n\n                    if (typeof data.id == 'undefined') {\n                        data = {\n                            'id': 'option_' + this.itemCount,\n                            'sort_order': this.itemCount + 1\n                        };\n                        isNewOption = true;\n                    }\n\n                    if (!data.intype) {\n                        data.intype = swatchOptionTextDefaultInputType;\n                    }\n\n                    element = this.template({\n                        data: data\n                    });\n\n                    if (isNewOption && !this.isReadOnly) {\n                        this.enableNewOptionDeleteButton(data.id);\n                    }\n                    this.itemCount++;\n                    this.totalItems++;\n                    this.elements += element;\n\n                    if (render) {\n                        this.render();\n                    }\n                },\n\n                /**\n                 * Remove option\n                 *\n                 * @param {Object} event\n                 */\n                remove: function (event) {\n                    var element = $(Event.findElement(event, 'tr')),\n                        elementFlags; // !!! Button already have table parent in safari\n\n                    // Safari workaround\n                    element.ancestors().each(function (parentItem) {\n                        if (parentItem.hasClassName('option-row')) {\n                            element = parentItem;\n                            throw $break;\n                        } else if (parentItem.hasClassName('box')) {\n                            throw $break;\n                        }\n                    });\n\n                    if (element) {\n                        elementFlags = element.getElementsByClassName('delete-flag');\n\n                        if (elementFlags[0]) {\n                            elementFlags[0].value = 1;\n                        }\n\n                        element.addClassName('no-display');\n                        element.addClassName('template');\n                        element.hide();\n                        this.totalItems--;\n                        this.updateItemsCountField();\n                    }\n                },\n\n                /**\n                 * Update items count field\n                 */\n                updateItemsCountField: function () {\n                    $('swatch-text-option-count-check').value = this.totalItems > 0 ? '1' : '';\n                },\n\n                /**\n                 * Enable delete button for new option\n                 *\n                 * @param {String} id\n                 */\n                enableNewOptionDeleteButton: function (id) {\n                    $$('#delete_button_swatch_container_' + id + ' button').each(function (button) {\n                        button.enable();\n                        button.removeClassName('disabled');\n                    });\n                },\n\n                /**\n                 * Bind remove button\n                 */\n                bindRemoveButtons: function () {\n                    jQuery('#swatch-text-options-panel').on('click', '.delete-option', this.remove.bind(this));\n                },\n\n                /**\n                 * Render action\n                 */\n                render: function () {\n                    Element.insert($$('[data-role=swatch-text-options-container]')[0], this.elements);\n                    this.elements = '';\n                },\n\n                /**\n                 * Render action with delay (performance fix)\n                 *\n                 * @param {Object} data\n                 * @param {Number} from\n                 * @param {Number} step\n                 * @param {Number} delay\n                 * @returns {Boolean}\n                 */\n                renderWithDelay: function (data, from, step, delay) {\n                    var arrayLength = data.length,\n                        len;\n\n                    for (len = from + step; from < len && from < arrayLength; from++) {\n                        this.add(data[from]);\n                    }\n                    this.render();\n\n                    if (from === arrayLength) {\n                        this.updateItemsCountField();\n                        this.rendered = 1;\n                        jQuery('body').trigger('processStop');\n\n                        return true;\n                    }\n                    setTimeout(this.renderWithDelay.bind(this, data, from, step, delay), delay);\n                },\n\n                /**\n                 * Ignore validate action\n                 */\n                ignoreValidate: function () {\n                    var ignore = '.ignore-validate input, ' +\n                        '.ignore-validate select, ' +\n                        '.ignore-validate textarea';\n\n                    jQuery('#edit_form').data('validator').settings.forceIgnore = ignore;\n                }\n            };\n\n        if ($('add_new_swatch_text_option_button')) {\n            Event.observe(\n                'add_new_swatch_text_option_button',\n                'click',\n                swatchTextOption.add.bind(swatchTextOption, true)\n            );\n        }\n        jQuery('#swatch-text-options-panel').on('render', function () {\n            swatchTextOption.ignoreValidate();\n\n            if (swatchTextOption.rendered) {\n                return false;\n            }\n            jQuery('body').trigger('processStart');\n            swatchTextOption.renderWithDelay(config.attributesData, 0, 100, 300);\n            swatchTextOption.bindRemoveButtons();\n        });\n\n        if (config.isSortable) {\n            jQuery(function ($) {\n                $('[data-role=swatch-text-options-container]').sortable({\n                    distance: 8,\n                    tolerance: 'pointer',\n                    cancel: 'input, button',\n                    axis: 'y',\n\n                    /**\n                     * Update components\n                     */\n                    update: function () {\n                        $('[data-role=swatch-text-options-container] [data-role=order]').each(\n                            function (index, element) {\n                                $(element).val(index + 1);\n                            }\n                        );\n                    }\n                });\n            });\n        }\n\n        jQuery(document).ready(function () {\n            if (jQuery('#frontend_input').val() !== 'swatch_text') {\n                jQuery('.swatch-text-field-0').removeClass('required-option');\n            }\n        });\n\n        window.swatchTextOption = swatchTextOption;\n        window.swatchOptionTextDefaultInputType = swatchOptionTextDefaultInputType;\n\n        rg.set('swatch-text-options-panel', swatchTextOption);\n    };\n});\n","Magento_Swatches/js/form/element/swatch-visual.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global $break $ FORM_KEY */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/async',\n    'mage/template',\n    'uiRegistry',\n    'prototype',\n    'Magento_Ui/js/form/element/abstract',\n    'jquery/colorpicker/js/colorpicker',\n    'jquery/ui'\n], function (_, jQuery, mageTemplate, rg, prototype, Abstract) {\n    'use strict';\n\n    /**\n     * Former implementation.\n     *\n     * @param {*} value\n     * @param {Object} container\n     * @param {String} uploadUrl\n     * @param {String} elementName\n     */\n    function oldCode(value, container, uploadUrl, elementName) {\n        var swatchVisualOption = {\n            itemCount: 0,\n            totalItems: 0,\n            rendered: 0,\n            isReadOnly: false,\n\n            /**\n             * Initialize.\n             */\n            initialize: function () {\n                if (_.isEmpty(value)) {\n                    container.addClassName('unavailable');\n                }\n\n                jQuery(container).on(\n                    'click',\n                    '.colorpicker_handler',\n                    this.initColorPicker\n                );\n            },\n\n            /**\n             * ColorPicker initialization process\n             */\n            initColorPicker: function () {\n                var element = this,\n                    hiddenColorPicker = !jQuery(element).data('colorpickerId');\n\n                jQuery(this).ColorPicker({\n\n                    /**\n                     * ColorPicker onShow action\n                     */\n                    onShow: function () {\n                        var color = jQuery(element).parent().parent().prev().prev('input').val(),\n                            menu = jQuery(this).parents('.swatch_sub-menu_container');\n\n                        menu.hide();\n                        jQuery(element).ColorPickerSetColor(color);\n                    },\n\n                    /**\n                     * ColorPicker onSubmit action\n                     *\n                     * @param {String} hsb\n                     * @param {String} hex\n                     * @param {String} rgb\n                     * @param {String} el\n                     */\n                    onSubmit: function (hsb, hex, rgb, el) {\n                        var localContainer = jQuery(el).parent().parent().prev();\n\n                        jQuery(el).ColorPickerHide();\n                        localContainer.parent().removeClass('unavailable');\n                        localContainer.prev('input').val('#' + hex).trigger('change');\n                        localContainer.css('background', '#' + hex);\n                    }\n                });\n\n                if (hiddenColorPicker) {\n                    jQuery(this).ColorPickerShow();\n                }\n            },\n\n            /**\n             * Remove action\n             *\n             * @param {Object} event\n             */\n            remove: function (event) {\n                var element = $(Event.findElement(event, 'tr')),\n                    elementFlags; // !!! Button already have table parent in safari\n\n                // Safari workaround\n                element.ancestors().each(function (parentItem) {\n                    if (parentItem.hasClassName('option-row')) {\n                        element = parentItem;\n                        throw $break;\n                    } else if (parentItem.hasClassName('box')) {\n                        throw $break;\n                    }\n                });\n\n                if (element) {\n                    elementFlags = element.getElementsByClassName('delete-flag');\n\n                    if (elementFlags[0]) {\n                        elementFlags[0].value = 1;\n                    }\n\n                    element.addClassName('no-display');\n                    element.addClassName('template');\n                    element.hide();\n                    this.totalItems--;\n                    this.updateItemsCountField();\n                }\n            },\n\n            /**\n             * Update items count field\n             */\n            updateItemsCountField: function () {\n                $('swatch-visual-option-count-check').value = this.totalItems > 0 ? '1' : '';\n            }\n        };\n\n        //swatchVisualOption.initColorPicker();\n\n        jQuery('body').on('click', function (event) {\n            var element = jQuery(event.target);\n\n            if (\n                element.parents('.swatch_sub-menu_container').length === 1 ||\n                element.next('div.swatch_sub-menu_container').length === 1\n            ) {\n                return true;\n            }\n            jQuery('.swatch_sub-menu_container').hide();\n        });\n\n        jQuery(function ($) {\n\n            var swatchComponents = {\n\n                /**\n                 * div wrapper for to hide all evement\n                 */\n                wrapper: null,\n\n                /**\n                 * iframe component to perform file upload without page reload\n                 */\n                iframe: null,\n\n                /**\n                 * form component for upload image\n                 */\n                form: null,\n\n                /**\n                 * Input file component for upload image\n                 */\n                inputFile: null,\n\n                /**\n                 * Create swatch component for upload files\n                 *\n                 * @this {swatchComponents}\n                 * @public\n                 */\n                create: function () {\n                    this.wrapper = $('<div>').css({\n                        display: 'none'\n                    }).appendTo($('body'));\n\n                    this.iframe = $('<iframe />', {\n                        name: 'upload_iframe_' + elementName\n                    }).appendTo(this.wrapper);\n\n                    this.form = $('<form />', {\n                        name: 'swatch_form_image_upload_' + elementName,\n                        target: 'upload_iframe_' + elementName,\n                        method: 'post',\n                        enctype: 'multipart/form-data',\n                        class: 'ignore-validate',\n                        action: uploadUrl\n                    }).appendTo(this.wrapper);\n\n                    this.inputFile = $('<input />', {\n                        type: 'file',\n                        name: 'datafile',\n                        class: 'swatch_option_file'\n                    }).appendTo(this.form);\n\n                    $('<input />', {\n                        type: 'hidden',\n                        name: 'form_key',\n                        value: FORM_KEY\n                    }).appendTo(this.form);\n                }\n            };\n\n            swatchVisualOption.initialize();\n\n            /**\n             * Create swatch components\n             */\n            swatchComponents.create();\n\n            /**\n             * Register event for swatch input[type=file] change\n             */\n            swatchComponents.inputFile.change(function () {\n                var localContainer = $('.' + $(this).attr('data-called-by')).parents().eq(2).children('.swatch_window'),\n\n                    /**\n                     * @this {iframe}\n                     */\n                    iframeHandler = function () {\n                        var imageParams = $.parseJSON($(this).contents().find('body').html()),\n                            fullMediaUrl = imageParams['swatch_path'] + imageParams['file_path'];\n\n                        localContainer.prev('input').val(imageParams['file_path']).trigger('change');\n                        localContainer.css({\n                            'background-image': 'url(' + fullMediaUrl + ')',\n                            'background-size': 'cover'\n                        });\n                        localContainer.parent().removeClass('unavailable');\n                    };\n\n                swatchComponents.iframe.off('load');\n                swatchComponents.iframe.load(iframeHandler);\n                swatchComponents.form.submit();\n                $(this).val('');\n            });\n\n            /**\n             * Register event for choose \"upload image\" option\n             */\n            $(container).on('click', '.btn_choose_file_upload', function () {\n                swatchComponents.inputFile.attr('data-called-by', $(this).data('class'));\n                swatchComponents.inputFile.click();\n            });\n\n            /**\n             * Register event for remove option\n             */\n            $(container).on('click', '.btn_remove_swatch', function () {\n                var optionPanel = $(this).parents().eq(2);\n\n                optionPanel.children('input').val('').trigger('change');\n                optionPanel.children('.swatch_window').css('background', '');\n                optionPanel.addClass('unavailable');\n                jQuery('.swatch_sub-menu_container').hide();\n            });\n\n            /**\n             * Toggle color upload chooser\n             */\n            $(container).on('click', '.swatch_window', function () {\n                jQuery('.swatch_sub-menu_container').hide();\n                $(this).next('div').toggle();\n            });\n        });\n    }\n\n    return Abstract.extend({\n        defaults: {\n            elementId: 0,\n            prefixName: '',\n            prefixElementName: '',\n            elementName: '',\n            value: '',\n            uploadUrl: ''\n        },\n\n        /**\n         * Parses options and merges the result with instance\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.configureDataScope();\n\n            return this;\n        },\n\n        /**\n         * Initialize.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initOldCode()\n                .on('value', this.onChangeColor.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Handler function that execute when color changes.\n         *\n         * @param {String} data - color\n         */\n        onChangeColor: function (data) {\n            if (!data) {\n                jQuery('.' + this.elementName).parent().removeClass('unavailable');\n            }\n        },\n\n        /**\n         * Initialize wrapped former implementation.\n         *\n         * @returns {Object} Chainable.\n         */\n        initOldCode: function () {\n            jQuery.async('.' + this.elementName, this.name, function (elem) {\n                oldCode(this.value(), elem.parentElement, this.uploadUrl, this.elementName);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Configure data scope.\n         */\n        configureDataScope: function () {\n            var recordId, prefixName;\n\n            // Get recordId\n            recordId = this.parentName.split('.').last();\n\n            prefixName = this.dataScopeToHtmlArray(this.prefixName);\n            this.elementName = this.prefixElementName + recordId;\n\n            this.inputName = prefixName + '[' + this.elementName + ']';\n            this.exportDataLink = 'data.' + this.prefixName + '.' + this.elementName;\n            this.exports.value = this.provider + ':' + this.exportDataLink;\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this._super();\n\n            this.source.remove(this.exportDataLink);\n        },\n\n        /**\n         * Get HTML array from data scope.\n         *\n         * @param {String} dataScopeString\n         * @returns {String}\n         */\n        dataScopeToHtmlArray: function (dataScopeString) {\n            var dataScopeArray, dataScope, reduceFunction;\n\n            /**\n             * Add new level of nesting.\n             *\n             * @param {String} prev\n             * @param {String} curr\n             * @returns {String}\n             */\n            reduceFunction = function (prev, curr) {\n                return prev + '[' + curr + ']';\n            };\n\n            dataScopeArray = dataScopeString.split('.');\n\n            dataScope = dataScopeArray.shift();\n            dataScope += dataScopeArray.reduce(reduceFunction, '');\n\n            return dataScope;\n        }\n    });\n});\n","Magento_Marketplace/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (configFromPage) {\n        var url = configFromPage.url;\n\n        $.ajax({\n            method: 'GET',\n            url: url\n        }).done(function (data) {\n            $('div[data-role=partners-block]').html(data);\n        });\n    };\n});\n","Vertex_Tax/js/allowed-countries.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine(['jquery', 'jquery/ui'], function ($) {\n    'use strict';\n\n    $.widget('vertex.allowedCountries', {\n        /**\n         * Bind all optgroups under the attached element to mass-select/mass-deselect their children on click\n         *\n         * @private\n         */\n        _create: function () {\n            $(this.element).on('click', 'optgroup', this.filterClick.bind(this));\n        },\n\n        /**\n         * Filter out any clicks where the target was not explicitly the optgroup\n         *\n         * @param {Event} event\n         * @return void\n         */\n        filterClick: function (event) {\n            if (!$(event.target).is('optgroup')) {\n                return;\n            }\n\n            this._processClick(event);\n        },\n\n        /**\n         * Decide to select or unselect all child elements and execute the chosen task\n         *\n         * @private\n         * @param {Event} event\n         * @return void\n         */\n        _processClick: function (event) {\n            var optgroup = $(event.target),\n                select = optgroup.closest('select'),\n                scrollTop = select.scrollTop();\n\n            if (optgroup.children('option:not(:selected)').length === 0) {\n                optgroup.children('option').prop('selected', false);\n            } else {\n                optgroup.children('option').prop('selected', true);\n            }\n\n            //  Maintain current scroll position\n            // Default behavior, in chrome at least, is to jump to some other selected option\n            setTimeout(function () {\n                select.scrollTop(scrollTop);\n            }, 0);\n        }\n    });\n\n    return $.vertex.allowedCountries;\n});\n","Vertex_Tax/js/form/flex-field-select.js":"/*\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine(['underscore', 'Magento_Ui/js/form/element/ui-select'], function (_, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            presets: {\n                optgroup: {\n                    openLevelsAction: true,\n                    showOpenLevelsActionIcon: true\n                }\n            }\n        },\n\n        /**\n         * Set Caption\n         */\n        setCaption: function () {\n            var length,\n                label = '',\n                selected;\n\n            if (!_.isArray(this.value()) && this.value()) {\n                length = 1;\n            } else if (this.value()) {\n                length = this.value().length;\n            } else {\n                this.value([]);\n                length = 0;\n            }\n\n            if (length && this.getSelected().length) {\n                selected = this.getSelected()[0];\n\n                if (selected.parent) {\n                    label = selected.parent + ' - ';\n                }\n                label += selected.label;\n                this.placeholder(label);\n            } else {\n                this.placeholder(this.selectedPlaceholders.defaultPlaceholder);\n            }\n\n            return this.placeholder();\n        }\n    });\n});\n","Vertex_Tax/js/form/element/custom-option-flex-field-select.js":"/*\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine(['underscore', 'Magento_Ui/js/form/element/select'], function (_, Select) {\n    'use strict';\n\n    return Select.extend({\n        /**\n         * Overwrites the parent's filter to allow for checking if a value is\n         * in an array and for allowing the value of \"unmapped\" through all\n         * filters\n         *\n         * @param {String} value\n         * @param {String} field\n         */\n        filter: function (value, field) {\n            var source = this.initialOptions,\n                result;\n\n            field = field || this.filterBy.field;\n\n            result = _.filter(source, function (item) {\n                return Array.isArray(item[field]) && item[field].includes(value) ||\n                    item[field] === value ||\n                    item.value === '' ||\n                    item.value === 'unmapped';\n            });\n\n            this.setOptions(result);\n        }\n    });\n});\n","Vertex_Tax/js/model/flex-field-table.js":"/**\n * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/\n * @author     Mediotype                     https://www.mediotype.com/\n */\n\ndefine(['uiComponent', 'ko', 'uiLayout'], function (Component, ko, layout) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            elementName: '', // Prefix to use for input elements\n            fieldType: '', // One of code, numeric, or date\n            tableId: '',\n            template: 'Vertex_Tax/flex-field-table',\n            selectOptions: [\n                {\n                    label: 'No Data',\n                    value: 'none'\n                }\n            ]\n        },\n        retrieveFields: [],\n\n        /**\n         * Initializes the table\n         * @returns {FlexFieldTable} Chainable.\n         */\n        initialize: function () {\n            this._super();\n\n            this.retrieveFields = ko.observableArray();\n            this.initializeFields();\n\n            return this;\n        },\n\n        /**\n         * Initialize the select components and link them to the form values\n         */\n        initializeFields: function () {\n            var i, name, toLayOut = [];\n\n            for (i in this.values) {\n                if (this.values.hasOwnProperty(i)) {\n                    name = this.fieldType + 'FlexField' + this.values[i]['field_id'];\n\n                    toLayOut.push({\n                        component: 'Vertex_Tax/js/form/flex-field-select',\n                        template: 'ui/grid/filters/elements/ui-select',\n                        parent: this.name,\n                        name: name,\n                        dataScope: '',\n                        multiple: false,\n                        selectType: 'optgroup',\n                        selectedPlaceholders: {\n                            defaultPlaceholder: 'No Data'\n                        },\n                        showOpenLevelsActionIcon: true,\n                        presets: {\n                            optgroup: {\n                                showOpenLevelsActionIcon: true\n                            }\n                        },\n                        filterOptions: true,\n                        isDisplayMissingValuePlaceholder: true,\n                        options: this.selectOptions,\n                        value: this.values[i]['field_source']\n                    });\n\n                    this.retrieveFields.push({\n                        fieldId: this.values[i]['field_id'],\n                        childName: name\n                    });\n                }\n            }\n\n            layout(toLayOut);\n        },\n\n        /**\n         * Retrieve the name for a Field ID input\n         *\n         * @param {String} fieldId\n         * @returns {String}\n         */\n        getFieldIdInputName: function (fieldId) {\n            return this.elementName + '[' + fieldId + '][field_id]';\n        },\n\n        /**\n         * Retrieve the name for a Field Value input\n         * @param {String} fieldId\n         * @returns {String}\n         */\n        getFieldValueInputName: function (fieldId) {\n            return this.elementName + '[' + fieldId + '][field_source]';\n        },\n\n        /**\n         * Retrieve the name for the empty input\n         * @returns {String}\n         */\n        getEmptyName: function () {\n            return this.elementName + '[__empty]';\n        }\n    });\n});\n","jquery/jquery.tabs.js":"/* ========================================================\n * bootstrap-tab.js v2.0.4\n * http://twitter.github.com/bootstrap/javascript.html#tabs\n * ========================================================\n * Copyright 2012 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ======================================================== */\n\ndefine([\n  \"jquery\"\n], function(jQuery){\n\n\n!function ($) {\n\n  \"use strict\"; // jshint ;_;\n\n\n /* TAB CLASS DEFINITION\n  * ==================== */\n\n  var Tab = function ( element ) {\n    this.element = $(element)\n  };\n\n  Tab.prototype = {\n\n    constructor: Tab\n\n  , show: function () {\n      var $this = this.element\n        , $ul = $this.closest('ul:not(.dropdown-menu)')\n        , selector = $this.attr('data-target')\n        , previous\n        , $target\n        , e;\n\n      if (!selector) {\n        selector = $this.attr('href');\n        selector = selector && selector.replace(/.*(?=#[^\\s]*$)/, ''); //strip for ie7\n      }\n\n      if ( $this.parent('li').hasClass('active') ) return;\n\n      previous = $ul.find('.active a').last()[0];\n\n      e = $.Event('show', {\n        relatedTarget: previous\n      });\n\n      $this.trigger(e);\n\n      if (e.isDefaultPrevented()) return;\n\n      $target = $(selector);\n\n      this.activate($this.parent('li'), $ul);\n      this.activate($target, $target.parent(), function () {\n        $this.trigger({\n          type: 'shown'\n        , relatedTarget: previous\n        })\n      })\n    }\n\n  , activate: function ( element, container, callback) {\n      var $active = container.find('> .active')\n        , transition = callback\n            && $.support.transition\n            && $active.hasClass('fade');\n\n      function next() {\n        $active\n          .removeClass('active')\n          .find('> .dropdown-menu > .active')\n          .removeClass('active');\n\n        element.addClass('active');\n\n        if (transition) {\n          element[0].offsetWidth; // reflow for transition\n          element.addClass('in');\n        } else {\n          element.removeClass('fade')\n        }\n\n        if ( element.parent('.dropdown-menu') ) {\n          element.closest('li.dropdown').addClass('active')\n        }\n\n        callback && callback()\n      }\n\n      transition ?\n        $active.one($.support.transition.end, next) :\n        next();\n\n      $active.removeClass('in')\n    }\n  };\n\n\n /* TAB PLUGIN DEFINITION\n  * ===================== */\n\n  $.fn.tab = function ( option ) {\n    return this.each(function () {\n      var $this = $(this)\n        , data = $this.data('tab');\n      if (!data) $this.data('tab', (data = new Tab(this)));\n      if (typeof option == 'string') data[option]()\n    })\n  };\n\n  $.fn.tab.Constructor = Tab;\n\n\n /* TAB DATA-API\n  * ============ */\n\n  $(function () {\n    $('body').on('click.tab.data-api', '[data-toggle=\"tab\"], [data-toggle=\"pill\"]', function (e) {\n      e.preventDefault();\n      $(this).tab('show')\n    })\n  })\n\n}(jQuery);\n\n/* =============================================================\n * bootstrap-collapse.js v2.0.4\n * http://twitter.github.com/bootstrap/javascript.html#collapse\n * =============================================================\n * Copyright 2012 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ============================================================ */\n\n\n!function ($) {\n\n  \"use strict\"; // jshint ;_;\n\n\n /* COLLAPSE PUBLIC CLASS DEFINITION\n  * ================================ */\n\n  var Collapse = function (element, options) {\n    this.$element = $(element);\n    this.options = $.extend({}, $.fn.collapse.defaults, options);\n\n    if (this.options.parent) {\n      this.$parent = $(this.options.parent)\n    }\n\n    this.options.toggle && this.toggle()\n  };\n\n  Collapse.prototype = {\n\n    constructor: Collapse\n\n  , dimension: function () {\n      var hasWidth = this.$element.hasClass('width');\n      return hasWidth ? 'width' : 'height'\n    }\n\n  , show: function () {\n      var dimension\n        , scroll\n        , actives\n        , hasData;\n\n      if (this.transitioning) return;\n\n      dimension = this.dimension();\n      scroll = $.camelCase(['scroll', dimension].join('-'));\n      actives = this.$parent && this.$parent.find('> .accordion-group > .in');\n\n      if (actives && actives.length) {\n        hasData = actives.data('collapse');\n        if (hasData && hasData.transitioning) return;\n        actives.collapse('hide');\n        hasData || actives.data('collapse', null)\n      }\n\n      this.$element[dimension](0);\n      this.transition('addClass', $.Event('show'), 'shown');\n      this.$element[dimension](this.$element[0][scroll]);\n    }\n\n  , hide: function () {\n      var dimension;\n      if (this.transitioning) return;\n      dimension = this.dimension();\n      this.reset(this.$element[dimension]());\n      this.transition('removeClass', $.Event('hide'), 'hidden');\n      this.$element[dimension](0)\n    }\n\n  , reset: function (size) {\n      var dimension = this.dimension();\n\n      this.$element\n        .removeClass('collapse')\n        [dimension](size || 'auto')\n        [0].offsetWidth;\n\n      this.$element[size !== null ? 'addClass' : 'removeClass']('collapse');\n\n      return this\n    }\n\n  , transition: function (method, startEvent, completeEvent) {\n      var that = this\n        , complete = function () {\n            if (startEvent.type == 'show') that.reset();\n            that.transitioning = 0;\n            that.$element.trigger(completeEvent)\n          };\n\n      this.$element.trigger(startEvent);\n\n      if (startEvent.isDefaultPrevented()) return;\n\n      this.transitioning = 1;\n\n      this.$element[method]('in');\n\n      $.support.transition && this.$element.hasClass('collapse') ?\n        this.$element.one($.support.transition.end, complete) :\n        complete()\n    }\n\n  , toggle: function () {\n      this[this.$element.hasClass('in') ? 'hide' : 'show']();\n    }\n\n  };\n\n\n /* COLLAPSIBLE PLUGIN DEFINITION\n  * ============================== */\n\n  $.fn.collapse = function (option) {\n    return this.each(function () {\n      var $this = $(this)\n        , data = $this.data('collapse')\n        , options = typeof option == 'object' && option;\n      if (!data) $this.data('collapse', (data = new Collapse(this, options)));\n      if (typeof option == 'string') data[option]()\n    })\n  };\n\n  $.fn.collapse.defaults = {\n    toggle: true\n  };\n\n  $.fn.collapse.Constructor = Collapse;\n\n\n /* COLLAPSIBLE DATA-API\n  * ==================== */\n\n  $(function () {\n    $('body').on('click.collapse.data-api', '[data-toggle=collapse]', function ( e ) {\n      var $this = $(this), href\n        , target = $this.attr('data-target')\n          || e.preventDefault()\n          || (href = $this.attr('href')) && href.replace(/.*(?=#[^\\s]+$)/, '') //strip for ie7\n        , option = $(target).data('collapse') ? 'toggle' : $this.data();\n      $(target).collapse(option);\n        $(this).toggleClass('active');\n    })\n  })\n\n}(jQuery);\n\n});","jquery/jquery.details.js":"/*! http://mths.be/details v0.0.6 by @mathias | includes http://mths.be/noselect v1.0.3 */\ndefine([\n    \"jquery\",\n    \"modernizr/modernizr.details\"\n], function($){\n\n    var proto = $.fn,\n        details,\n        // :'(\n        isOpera = Object.prototype.toString.call(window.opera) == '[object Opera]',\n        // Feature test for native `<details>` support\n        isDetailsSupported = $('html').hasClass('details'),\n        toggleOpen = function($details, $detailsSummary, $detailsNotSummary, toggle) {\n            var isOpen = typeof $details.attr('open') == 'string',\n                close = isOpen && toggle || !isOpen && !toggle;\n            if (close) {\n                $details.removeClass('open').prop('open', false).triggerHandler('close.details');\n                $detailsSummary.attr('aria-expanded', false);\n                $detailsNotSummary.hide();\n            } else {\n                $details.addClass('open').prop('open', true).triggerHandler('open.details');\n                $detailsSummary.attr('aria-expanded', true);\n                $detailsNotSummary.show();\n            }\n        };\n\n    /* http://mths.be/noselect v1.0.3 */\n    proto.noSelect = function() {\n\n        // Since the string 'none' is used three times, storing it in a variable gives better results after minification\n        var none = 'none';\n\n        // onselectstart and ondragstart for WebKit & IE\n        // onmousedown for WebKit & Opera\n        return this.bind('selectstart dragstart mousedown', function() {\n            return false;\n        }).css({\n            'MozUserSelect': none,\n            'msUserSelect': none,\n            'webkitUserSelect': none,\n            'userSelect': none\n        });\n\n    };\n\n    // Execute the fallback only if there\u2019s no native `details` support\n    if (isDetailsSupported) {\n        details = proto.details = function() {\n\n            return this.each(function() {\n                var $details = $(this),\n                    $summary = $('summary', $details).first();\n                $summary.attr({\n                    'role': 'button',\n                    'aria-expanded': $details.prop('open')\n                }).on('click.xxx', function() {\n                    // the value of the `open` property is the old value\n                    var close = $details.prop('open');\n                    $summary.attr('aria-expanded', !close);\n                    $details.triggerHandler((close ? 'close' : 'open') + '.details');\n                });\n            });\n\n        };\n\n        details.support = isDetailsSupported;\n\n    } else {\n        details = proto.details = function() {\n\n            // Loop through all `details` elements\n            return this.each(function() {\n\n                // Store a reference to the current `details` element in a variable\n                var $details = $(this),\n                    // Store a reference to the `summary` element of the current `details` element (if any) in a variable\n                    $detailsSummary = $('summary', $details).first(),\n                    // Do the same for the info within the `details` element\n                    $detailsNotSummary = $details.children(':not(summary)'),\n                    // This will be used later to look for direct child text nodes\n                    $detailsNotSummaryContents = $details.contents(':not(summary)');\n\n                // If there is no `summary` in the current `details` element\u2026\n                if (!$detailsSummary.length) {\n                    // \u2026create one with default text\n                    $detailsSummary = $('<summary>').text($.mage.__('Details')).prependTo($details);\n                }\n\n                // Look for direct child text nodes\n                if ($detailsNotSummary.length != $detailsNotSummaryContents.length) {\n                    // Wrap child text nodes in a `span` element\n                    $detailsNotSummaryContents.filter(function() {\n                        // Only keep the node in the collection if it\u2019s a text node containing more than only whitespace\n                        // http://www.whatwg.org/specs/web-apps/current-work/multipage/common-microsyntaxes.html#space-character\n                        return this.nodeType == 3 && /[^ \\t\\n\\f\\r]/.test(this.data);\n                    }).wrap('<span>');\n                    // There are now no direct child text nodes anymore \u2014 they\u2019re wrapped in `span` elements\n                    $detailsNotSummary = $details.children(':not(summary)');\n                }\n\n                // Hide content unless there\u2019s an `open` attribute\n                toggleOpen($details, $detailsSummary, $detailsNotSummary);\n\n                // Add `role=button` and set the `tabindex` of the `summary` element to `0` to make it keyboard accessible\n                $detailsSummary.attr('role', 'button').noSelect().prop('tabIndex', 0).off('click').on('click.details', function() {\n                    // Focus on the `summary` element\n                    $detailsSummary.focus();\n                    // Toggle the `open` and `aria-expanded` attributes and the `open` property of the `details` element and display the additional info\n                    toggleOpen($details, $detailsSummary, $detailsNotSummary, true);\n                }).keyup(function(event) {\n                    if (32 == event.keyCode || (13 == event.keyCode && !isOpera)) {\n                        // Space or Enter is pressed \u2014 trigger the `click` event on the `summary` element\n                        // Opera already seems to trigger the `click` event when Enter is pressed\n                        event.preventDefault();\n                        $detailsSummary.click();\n                    }\n                });\n\n            });\n\n        };\n\n        details.support = isDetailsSupported;\n\n    }\n\n});\n","jquery/jquery-migrate.js":"/*!\n * jQuery Migrate - v1.4.1 - 2016-05-19\n * Copyright jQuery Foundation and other contributors\n */\n(function( jQuery, window, undefined ) {\n// See http://bugs.jquery.com/ticket/13335\n// \"use strict\";\n\n\njQuery.migrateVersion = \"1.4.1\";\n\n\nvar warnedAbout = {};\n\n// List of warnings already given; public read only\njQuery.migrateWarnings = [];\n\n// Set to true to prevent console output; migrateWarnings still maintained\n// jQuery.migrateMute = false;\n\n// Show a message on the console so devs know we're active\nif ( window.console && window.console.log ) {\n\twindow.console.log( \"JQMIGRATE: Migrate is installed\" +\n\t\t( jQuery.migrateMute ? \"\" : \" with logging active\" ) +\n\t\t\", version \" + jQuery.migrateVersion );\n}\n\n// Set to false to disable traces that appear with warnings\nif ( jQuery.migrateTrace === undefined ) {\n\tjQuery.migrateTrace = true;\n}\n\n// Forget any warnings we've already given; public\njQuery.migrateReset = function() {\n\twarnedAbout = {};\n\tjQuery.migrateWarnings.length = 0;\n};\n\nfunction migrateWarn( msg) {\n\tvar console = window.console;\n\tif ( !warnedAbout[ msg ] ) {\n\t\twarnedAbout[ msg ] = true;\n\t\tjQuery.migrateWarnings.push( msg );\n\t\tif ( console && console.warn && !jQuery.migrateMute ) {\n\t\t\tconsole.warn( \"JQMIGRATE: \" + msg );\n\t\t\tif ( jQuery.migrateTrace && console.trace ) {\n\t\t\t\tconsole.trace();\n\t\t\t}\n\t\t}\n\t}\n}\n\nfunction migrateWarnProp( obj, prop, value, msg ) {\n\tif ( Object.defineProperty ) {\n\t\t// On ES5 browsers (non-oldIE), warn if the code tries to get prop;\n\t\t// allow property to be overwritten in case some other plugin wants it\n\t\ttry {\n\t\t\tObject.defineProperty( obj, prop, {\n\t\t\t\tconfigurable: true,\n\t\t\t\tenumerable: true,\n\t\t\t\tget: function() {\n\t\t\t\t\tmigrateWarn( msg );\n\t\t\t\t\treturn value;\n\t\t\t\t},\n\t\t\t\tset: function( newValue ) {\n\t\t\t\t\tmigrateWarn( msg );\n\t\t\t\t\tvalue = newValue;\n\t\t\t\t}\n\t\t\t});\n\t\t\treturn;\n\t\t} catch( err ) {\n\t\t\t// IE8 is a dope about Object.defineProperty, can't warn there\n\t\t}\n\t}\n\n\t// Non-ES5 (or broken) browser; just set the property\n\tjQuery._definePropertyBroken = true;\n\tobj[ prop ] = value;\n}\n\nif ( document.compatMode === \"BackCompat\" ) {\n\t// jQuery has never supported or tested Quirks Mode\n\tmigrateWarn( \"jQuery is not compatible with Quirks Mode\" );\n}\n\n\nvar attrFn = jQuery( \"<input/>\", { size: 1 } ).attr(\"size\") && jQuery.attrFn,\n\toldAttr = jQuery.attr,\n\tvalueAttrGet = jQuery.attrHooks.value && jQuery.attrHooks.value.get ||\n\t\tfunction() { return null; },\n\tvalueAttrSet = jQuery.attrHooks.value && jQuery.attrHooks.value.set ||\n\t\tfunction() { return undefined; },\n\trnoType = /^(?:input|button)$/i,\n\trnoAttrNodeType = /^[238]$/,\n\trboolean = /^(?:autofocus|autoplay|async|checked|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped|selected)$/i,\n\truseDefault = /^(?:checked|selected)$/i;\n\n// jQuery.attrFn\nmigrateWarnProp( jQuery, \"attrFn\", attrFn || {}, \"jQuery.attrFn is deprecated\" );\n\njQuery.attr = function( elem, name, value, pass ) {\n\tvar lowerName = name.toLowerCase(),\n\t\tnType = elem && elem.nodeType;\n\n\tif ( pass ) {\n\t\t// Since pass is used internally, we only warn for new jQuery\n\t\t// versions where there isn't a pass arg in the formal params\n\t\tif ( oldAttr.length < 4 ) {\n\t\t\tmigrateWarn(\"jQuery.fn.attr( props, pass ) is deprecated\");\n\t\t}\n\t\tif ( elem && !rnoAttrNodeType.test( nType ) &&\n\t\t\t(attrFn ? name in attrFn : jQuery.isFunction(jQuery.fn[name])) ) {\n\t\t\treturn jQuery( elem )[ name ]( value );\n\t\t}\n\t}\n\n\t// Warn if user tries to set `type`, since it breaks on IE 6/7/8; by checking\n\t// for disconnected elements we don't warn on $( \"<button>\", { type: \"button\" } ).\n\tif ( name === \"type\" && value !== undefined && rnoType.test( elem.nodeName ) && elem.parentNode ) {\n\t\tmigrateWarn(\"Can't change the 'type' of an input or button in IE 6/7/8\");\n\t}\n\n\t// Restore boolHook for boolean property/attribute synchronization\n\tif ( !jQuery.attrHooks[ lowerName ] && rboolean.test( lowerName ) ) {\n\t\tjQuery.attrHooks[ lowerName ] = {\n\t\t\tget: function( elem, name ) {\n\t\t\t\t// Align boolean attributes with corresponding properties\n\t\t\t\t// Fall back to attribute presence where some booleans are not supported\n\t\t\t\tvar attrNode,\n\t\t\t\t\tproperty = jQuery.prop( elem, name );\n\t\t\t\treturn property === true || typeof property !== \"boolean\" &&\n\t\t\t\t\t( attrNode = elem.getAttributeNode(name) ) && attrNode.nodeValue !== false ?\n\n\t\t\t\t\tname.toLowerCase() :\n\t\t\t\t\tundefined;\n\t\t\t},\n\t\t\tset: function( elem, value, name ) {\n\t\t\t\tvar propName;\n\t\t\t\tif ( value === false ) {\n\t\t\t\t\t// Remove boolean attributes when set to false\n\t\t\t\t\tjQuery.removeAttr( elem, name );\n\t\t\t\t} else {\n\t\t\t\t\t// value is true since we know at this point it's type boolean and not false\n\t\t\t\t\t// Set boolean attributes to the same name and set the DOM property\n\t\t\t\t\tpropName = jQuery.propFix[ name ] || name;\n\t\t\t\t\tif ( propName in elem ) {\n\t\t\t\t\t\t// Only set the IDL specifically if it already exists on the element\n\t\t\t\t\t\telem[ propName ] = true;\n\t\t\t\t\t}\n\n\t\t\t\t\telem.setAttribute( name, name.toLowerCase() );\n\t\t\t\t}\n\t\t\t\treturn name;\n\t\t\t}\n\t\t};\n\n\t\t// Warn only for attributes that can remain distinct from their properties post-1.9\n\t\tif ( ruseDefault.test( lowerName ) ) {\n\t\t\tmigrateWarn( \"jQuery.fn.attr('\" + lowerName + \"') might use property instead of attribute\" );\n\t\t}\n\t}\n\n\treturn oldAttr.call( jQuery, elem, name, value );\n};\n\n// attrHooks: value\njQuery.attrHooks.value = {\n\tget: function( elem, name ) {\n\t\tvar nodeName = ( elem.nodeName || \"\" ).toLowerCase();\n\t\tif ( nodeName === \"button\" ) {\n\t\t\treturn valueAttrGet.apply( this, arguments );\n\t\t}\n\t\tif ( nodeName !== \"input\" && nodeName !== \"option\" ) {\n\t\t\tmigrateWarn(\"jQuery.fn.attr('value') no longer gets properties\");\n\t\t}\n\t\treturn name in elem ?\n\t\t\telem.value :\n\t\t\tnull;\n\t},\n\tset: function( elem, value ) {\n\t\tvar nodeName = ( elem.nodeName || \"\" ).toLowerCase();\n\t\tif ( nodeName === \"button\" ) {\n\t\t\treturn valueAttrSet.apply( this, arguments );\n\t\t}\n\t\tif ( nodeName !== \"input\" && nodeName !== \"option\" ) {\n\t\t\tmigrateWarn(\"jQuery.fn.attr('value', val) no longer sets properties\");\n\t\t}\n\t\t// Does not return so that setAttribute is also used\n\t\telem.value = value;\n\t}\n};\n\n\nvar matched, browser,\n\toldInit = jQuery.fn.init,\n\toldFind = jQuery.find,\n\toldParseJSON = jQuery.parseJSON,\n\trspaceAngle = /^\\s*</,\n\trattrHashTest = /\\[(\\s*[-\\w]+\\s*)([~|^$*]?=)\\s*([-\\w#]*?#[-\\w#]*)\\s*\\]/,\n\trattrHashGlob = /\\[(\\s*[-\\w]+\\s*)([~|^$*]?=)\\s*([-\\w#]*?#[-\\w#]*)\\s*\\]/g,\n\t// Note: XSS check is done below after string is trimmed\n\trquickExpr = /^([^<]*)(<[\\w\\W]+>)([^>]*)$/;\n\n// $(html) \"looks like html\" rule change\njQuery.fn.init = function( selector, context, rootjQuery ) {\n\tvar match, ret;\n\n\tif ( selector && typeof selector === \"string\" ) {\n\t\tif ( !jQuery.isPlainObject( context ) &&\n\t\t\t\t(match = rquickExpr.exec( jQuery.trim( selector ) )) && match[ 0 ] ) {\n\n\t\t\t// This is an HTML string according to the \"old\" rules; is it still?\n\t\t\tif ( !rspaceAngle.test( selector ) ) {\n\t\t\t\tmigrateWarn(\"$(html) HTML strings must start with '<' character\");\n\t\t\t}\n\t\t\tif ( match[ 3 ] ) {\n\t\t\t\tmigrateWarn(\"$(html) HTML text after last tag is ignored\");\n\t\t\t}\n\n\t\t\t// Consistently reject any HTML-like string starting with a hash (gh-9521)\n\t\t\t// Note that this may break jQuery 1.6.x code that otherwise would work.\n\t\t\tif ( match[ 0 ].charAt( 0 ) === \"#\" ) {\n\t\t\t\tmigrateWarn(\"HTML string cannot start with a '#' character\");\n\t\t\t\tjQuery.error(\"JQMIGRATE: Invalid selector string (XSS)\");\n\t\t\t}\n\n\t\t\t// Now process using loose rules; let pre-1.8 play too\n\t\t\t// Is this a jQuery context? parseHTML expects a DOM element (#178)\n\t\t\tif ( context && context.context && context.context.nodeType ) {\n\t\t\t\tcontext = context.context;\n\t\t\t}\n\n\t\t\tif ( jQuery.parseHTML ) {\n\t\t\t\treturn oldInit.call( this,\n\t\t\t\t\t\tjQuery.parseHTML( match[ 2 ], context && context.ownerDocument ||\n\t\t\t\t\t\t\tcontext || document, true ), context, rootjQuery );\n\t\t\t}\n\t\t}\n\t}\n\n\tret = oldInit.apply( this, arguments );\n\n\t// Fill in selector and context properties so .live() works\n\tif ( selector && selector.selector !== undefined ) {\n\t\t// A jQuery object, copy its properties\n\t\tret.selector = selector.selector;\n\t\tret.context = selector.context;\n\n\t} else {\n\t\tret.selector = typeof selector === \"string\" ? selector : \"\";\n\t\tif ( selector ) {\n\t\t\tret.context = selector.nodeType? selector : context || document;\n\t\t}\n\t}\n\n\treturn ret;\n};\njQuery.fn.init.prototype = jQuery.fn;\n\njQuery.find = function( selector ) {\n\tvar args = Array.prototype.slice.call( arguments );\n\n\t// Support: PhantomJS 1.x\n\t// String#match fails to match when used with a //g RegExp, only on some strings\n\tif ( typeof selector === \"string\" && rattrHashTest.test( selector ) ) {\n\n\t\t// The nonstandard and undocumented unquoted-hash was removed in jQuery 1.12.0\n\t\t// First see if qS thinks it's a valid selector, if so avoid a false positive\n\t\ttry {\n\t\t\tdocument.querySelector( selector );\n\t\t} catch ( err1 ) {\n\n\t\t\t// Didn't *look* valid to qSA, warn and try quoting what we think is the value\n\t\t\tselector = selector.replace( rattrHashGlob, function( _, attr, op, value ) {\n\t\t\t\treturn \"[\" + attr + op + \"\\\"\" + value + \"\\\"]\";\n\t\t\t} );\n\n\t\t\t// If the regexp *may* have created an invalid selector, don't update it\n\t\t\t// Note that there may be false alarms if selector uses jQuery extensions\n\t\t\ttry {\n\t\t\t\tdocument.querySelector( selector );\n\t\t\t\tmigrateWarn( \"Attribute selector with '#' must be quoted: \" + args[ 0 ] );\n\t\t\t\targs[ 0 ] = selector;\n\t\t\t} catch ( err2 ) {\n\t\t\t\tmigrateWarn( \"Attribute selector with '#' was not fixed: \" + args[ 0 ] );\n\t\t\t}\n\t\t}\n\t}\n\n\treturn oldFind.apply( this, args );\n};\n\n// Copy properties attached to original jQuery.find method (e.g. .attr, .isXML)\nvar findProp;\nfor ( findProp in oldFind ) {\n\tif ( Object.prototype.hasOwnProperty.call( oldFind, findProp ) ) {\n\t\tjQuery.find[ findProp ] = oldFind[ findProp ];\n\t}\n}\n\n// Let $.parseJSON(falsy_value) return null\njQuery.parseJSON = function( json ) {\n\tif ( !json ) {\n\t\tmigrateWarn(\"jQuery.parseJSON requires a valid JSON string\");\n\t\treturn null;\n\t}\n\treturn oldParseJSON.apply( this, arguments );\n};\n\njQuery.uaMatch = function( ua ) {\n\tua = ua.toLowerCase();\n\n\tvar match = /(chrome)[ \\/]([\\w.]+)/.exec( ua ) ||\n\t\t/(webkit)[ \\/]([\\w.]+)/.exec( ua ) ||\n\t\t/(opera)(?:.*version|)[ \\/]([\\w.]+)/.exec( ua ) ||\n\t\t/(msie) ([\\w.]+)/.exec( ua ) ||\n\t\tua.indexOf(\"compatible\") < 0 && /(mozilla)(?:.*? rv:([\\w.]+)|)/.exec( ua ) ||\n\t\t[];\n\n\treturn {\n\t\tbrowser: match[ 1 ] || \"\",\n\t\tversion: match[ 2 ] || \"0\"\n\t};\n};\n\n// Don't clobber any existing jQuery.browser in case it's different\nif ( !jQuery.browser ) {\n\tmatched = jQuery.uaMatch( navigator.userAgent );\n\tbrowser = {};\n\n\tif ( matched.browser ) {\n\t\tbrowser[ matched.browser ] = true;\n\t\tbrowser.version = matched.version;\n\t}\n\n\t// Chrome is Webkit, but Webkit is also Safari.\n\tif ( browser.chrome ) {\n\t\tbrowser.webkit = true;\n\t} else if ( browser.webkit ) {\n\t\tbrowser.safari = true;\n\t}\n\n\tjQuery.browser = browser;\n}\n\n// Warn if the code tries to get jQuery.browser\nmigrateWarnProp( jQuery, \"browser\", jQuery.browser, \"jQuery.browser is deprecated\" );\n\n// jQuery.boxModel deprecated in 1.3, jQuery.support.boxModel deprecated in 1.7\njQuery.boxModel = jQuery.support.boxModel = (document.compatMode === \"CSS1Compat\");\nmigrateWarnProp( jQuery, \"boxModel\", jQuery.boxModel, \"jQuery.boxModel is deprecated\" );\nmigrateWarnProp( jQuery.support, \"boxModel\", jQuery.support.boxModel, \"jQuery.support.boxModel is deprecated\" );\n\njQuery.sub = function() {\n\tfunction jQuerySub( selector, context ) {\n\t\treturn new jQuerySub.fn.init( selector, context );\n\t}\n\tjQuery.extend( true, jQuerySub, this );\n\tjQuerySub.superclass = this;\n\tjQuerySub.fn = jQuerySub.prototype = this();\n\tjQuerySub.fn.constructor = jQuerySub;\n\tjQuerySub.sub = this.sub;\n\tjQuerySub.fn.init = function init( selector, context ) {\n\t\tvar instance = jQuery.fn.init.call( this, selector, context, rootjQuerySub );\n\t\treturn instance instanceof jQuerySub ?\n\t\t\tinstance :\n\t\t\tjQuerySub( instance );\n\t};\n\tjQuerySub.fn.init.prototype = jQuerySub.fn;\n\tvar rootjQuerySub = jQuerySub(document);\n\tmigrateWarn( \"jQuery.sub() is deprecated\" );\n\treturn jQuerySub;\n};\n\n// The number of elements contained in the matched element set\njQuery.fn.size = function() {\n\tmigrateWarn( \"jQuery.fn.size() is deprecated; use the .length property\" );\n\treturn this.length;\n};\n\n\nvar internalSwapCall = false;\n\n// If this version of jQuery has .swap(), don't false-alarm on internal uses\nif ( jQuery.swap ) {\n\tjQuery.each( [ \"height\", \"width\", \"reliableMarginRight\" ], function( _, name ) {\n\t\tvar oldHook = jQuery.cssHooks[ name ] && jQuery.cssHooks[ name ].get;\n\n\t\tif ( oldHook ) {\n\t\t\tjQuery.cssHooks[ name ].get = function() {\n\t\t\t\tvar ret;\n\n\t\t\t\tinternalSwapCall = true;\n\t\t\t\tret = oldHook.apply( this, arguments );\n\t\t\t\tinternalSwapCall = false;\n\t\t\t\treturn ret;\n\t\t\t};\n\t\t}\n\t});\n}\n\njQuery.swap = function( elem, options, callback, args ) {\n\tvar ret, name,\n\t\told = {};\n\n\tif ( !internalSwapCall ) {\n\t\tmigrateWarn( \"jQuery.swap() is undocumented and deprecated\" );\n\t}\n\n\t// Remember the old values, and insert the new ones\n\tfor ( name in options ) {\n\t\told[ name ] = elem.style[ name ];\n\t\telem.style[ name ] = options[ name ];\n\t}\n\n\tret = callback.apply( elem, args || [] );\n\n\t// Revert the old values\n\tfor ( name in options ) {\n\t\telem.style[ name ] = old[ name ];\n\t}\n\n\treturn ret;\n};\n\n\n// Ensure that $.ajax gets the new parseJSON defined in core.js\njQuery.ajaxSetup({\n\tconverters: {\n\t\t\"text json\": jQuery.parseJSON\n\t}\n});\n\n\nvar oldFnData = jQuery.fn.data;\n\njQuery.fn.data = function( name ) {\n\tvar ret, evt,\n\t\telem = this[0];\n\n\t// Handles 1.7 which has this behavior and 1.8 which doesn't\n\tif ( elem && name === \"events\" && arguments.length === 1 ) {\n\t\tret = jQuery.data( elem, name );\n\t\tevt = jQuery._data( elem, name );\n\t\tif ( ( ret === undefined || ret === evt ) && evt !== undefined ) {\n\t\t\tmigrateWarn(\"Use of jQuery.fn.data('events') is deprecated\");\n\t\t\treturn evt;\n\t\t}\n\t}\n\treturn oldFnData.apply( this, arguments );\n};\n\n\nvar rscriptType = /\\/(java|ecma)script/i;\n\n// Since jQuery.clean is used internally on older versions, we only shim if it's missing\nif ( !jQuery.clean ) {\n\tjQuery.clean = function( elems, context, fragment, scripts ) {\n\t\t// Set context per 1.8 logic\n\t\tcontext = context || document;\n\t\tcontext = !context.nodeType && context[0] || context;\n\t\tcontext = context.ownerDocument || context;\n\n\t\tmigrateWarn(\"jQuery.clean() is deprecated\");\n\n\t\tvar i, elem, handleScript, jsTags,\n\t\t\tret = [];\n\n\t\tjQuery.merge( ret, jQuery.buildFragment( elems, context ).childNodes );\n\n\t\t// Complex logic lifted directly from jQuery 1.8\n\t\tif ( fragment ) {\n\t\t\t// Special handling of each script element\n\t\t\thandleScript = function( elem ) {\n\t\t\t\t// Check if we consider it executable\n\t\t\t\tif ( !elem.type || rscriptType.test( elem.type ) ) {\n\t\t\t\t\t// Detach the script and store it in the scripts array (if provided) or the fragment\n\t\t\t\t\t// Return truthy to indicate that it has been handled\n\t\t\t\t\treturn scripts ?\n\t\t\t\t\t\tscripts.push( elem.parentNode ? elem.parentNode.removeChild( elem ) : elem ) :\n\t\t\t\t\t\tfragment.appendChild( elem );\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tfor ( i = 0; (elem = ret[i]) != null; i++ ) {\n\t\t\t\t// Check if we're done after handling an executable script\n\t\t\t\tif ( !( jQuery.nodeName( elem, \"script\" ) && handleScript( elem ) ) ) {\n\t\t\t\t\t// Append to fragment and handle embedded scripts\n\t\t\t\t\tfragment.appendChild( elem );\n\t\t\t\t\tif ( typeof elem.getElementsByTagName !== \"undefined\" ) {\n\t\t\t\t\t\t// handleScript alters the DOM, so use jQuery.merge to ensure snapshot iteration\n\t\t\t\t\t\tjsTags = jQuery.grep( jQuery.merge( [], elem.getElementsByTagName(\"script\") ), handleScript );\n\n\t\t\t\t\t\t// Splice the scripts into ret after their former ancestor and advance our index beyond them\n\t\t\t\t\t\tret.splice.apply( ret, [i + 1, 0].concat( jsTags ) );\n\t\t\t\t\t\ti += jsTags.length;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn ret;\n\t};\n}\n\nvar eventAdd = jQuery.event.add,\n\teventRemove = jQuery.event.remove,\n\teventTrigger = jQuery.event.trigger,\n\toldToggle = jQuery.fn.toggle,\n\toldLive = jQuery.fn.live,\n\toldDie = jQuery.fn.die,\n\toldLoad = jQuery.fn.load,\n\tajaxEvents = \"ajaxStart|ajaxStop|ajaxSend|ajaxComplete|ajaxError|ajaxSuccess\",\n\trajaxEvent = new RegExp( \"\\\\b(?:\" + ajaxEvents + \")\\\\b\" ),\n\trhoverHack = /(?:^|\\s)hover(\\.\\S+|)\\b/,\n\thoverHack = function( events ) {\n\t\tif ( typeof( events ) !== \"string\" || jQuery.event.special.hover ) {\n\t\t\treturn events;\n\t\t}\n\t\tif ( rhoverHack.test( events ) ) {\n\t\t\tmigrateWarn(\"'hover' pseudo-event is deprecated, use 'mouseenter mouseleave'\");\n\t\t}\n\t\treturn events && events.replace( rhoverHack, \"mouseenter$1 mouseleave$1\" );\n\t};\n\n// Event props removed in 1.9, put them back if needed; no practical way to warn them\nif ( jQuery.event.props && jQuery.event.props[ 0 ] !== \"attrChange\" ) {\n\tjQuery.event.props.unshift( \"attrChange\", \"attrName\", \"relatedNode\", \"srcElement\" );\n}\n\n// Undocumented jQuery.event.handle was \"deprecated\" in jQuery 1.7\nif ( jQuery.event.dispatch ) {\n\tmigrateWarnProp( jQuery.event, \"handle\", jQuery.event.dispatch, \"jQuery.event.handle is undocumented and deprecated\" );\n}\n\n// Support for 'hover' pseudo-event and ajax event warnings\njQuery.event.add = function( elem, types, handler, data, selector ){\n\tif ( elem !== document && rajaxEvent.test( types ) ) {\n\t\tmigrateWarn( \"AJAX events should be attached to document: \" + types );\n\t}\n\teventAdd.call( this, elem, hoverHack( types || \"\" ), handler, data, selector );\n};\njQuery.event.remove = function( elem, types, handler, selector, mappedTypes ){\n\teventRemove.call( this, elem, hoverHack( types ) || \"\", handler, selector, mappedTypes );\n};\n\njQuery.each( [ \"load\", \"unload\", \"error\" ], function( _, name ) {\n\n\tjQuery.fn[ name ] = function() {\n\t\tvar args = Array.prototype.slice.call( arguments, 0 );\n\n\t\t// If this is an ajax load() the first arg should be the string URL;\n\t\t// technically this could also be the \"Anything\" arg of the event .load()\n\t\t// which just goes to show why this dumb signature has been deprecated!\n\t\t// jQuery custom builds that exclude the Ajax module justifiably die here.\n\t\tif ( name === \"load\" && typeof args[ 0 ] === \"string\" ) {\n\t\t\treturn oldLoad.apply( this, args );\n\t\t}\n\n\t\tmigrateWarn( \"jQuery.fn.\" + name + \"() is deprecated\" );\n\n\t\targs.splice( 0, 0, name );\n\t\tif ( arguments.length ) {\n\t\t\treturn this.bind.apply( this, args );\n\t\t}\n\n\t\t// Use .triggerHandler here because:\n\t\t// - load and unload events don't need to bubble, only applied to window or image\n\t\t// - error event should not bubble to window, although it does pre-1.7\n\t\t// See http://bugs.jquery.com/ticket/11820\n\t\tthis.triggerHandler.apply( this, args );\n\t\treturn this;\n\t};\n\n});\n\njQuery.fn.toggle = function( fn, fn2 ) {\n\n\t// Don't mess with animation or css toggles\n\tif ( !jQuery.isFunction( fn ) || !jQuery.isFunction( fn2 ) ) {\n\t\treturn oldToggle.apply( this, arguments );\n\t}\n\tmigrateWarn(\"jQuery.fn.toggle(handler, handler...) is deprecated\");\n\n\t// Save reference to arguments for access in closure\n\tvar args = arguments,\n\t\tguid = fn.guid || jQuery.guid++,\n\t\ti = 0,\n\t\ttoggler = function( event ) {\n\t\t\t// Figure out which function to execute\n\t\t\tvar lastToggle = ( jQuery._data( this, \"lastToggle\" + fn.guid ) || 0 ) % i;\n\t\t\tjQuery._data( this, \"lastToggle\" + fn.guid, lastToggle + 1 );\n\n\t\t\t// Make sure that clicks stop\n\t\t\tevent.preventDefault();\n\n\t\t\t// and execute the function\n\t\t\treturn args[ lastToggle ].apply( this, arguments ) || false;\n\t\t};\n\n\t// link all the functions, so any of them can unbind this click handler\n\ttoggler.guid = guid;\n\twhile ( i < args.length ) {\n\t\targs[ i++ ].guid = guid;\n\t}\n\n\treturn this.click( toggler );\n};\n\njQuery.fn.live = function( types, data, fn ) {\n\tmigrateWarn(\"jQuery.fn.live() is deprecated\");\n\tif ( oldLive ) {\n\t\treturn oldLive.apply( this, arguments );\n\t}\n\tjQuery( this.context ).on( types, this.selector, data, fn );\n\treturn this;\n};\n\njQuery.fn.die = function( types, fn ) {\n\tmigrateWarn(\"jQuery.fn.die() is deprecated\");\n\tif ( oldDie ) {\n\t\treturn oldDie.apply( this, arguments );\n\t}\n\tjQuery( this.context ).off( types, this.selector || \"**\", fn );\n\treturn this;\n};\n\n// Turn global events into document-triggered events\njQuery.event.trigger = function( event, data, elem, onlyHandlers  ){\n\tif ( !elem && !rajaxEvent.test( event ) ) {\n\t\tmigrateWarn( \"Global events are undocumented and deprecated\" );\n\t}\n\treturn eventTrigger.call( this,  event, data, elem || document, onlyHandlers  );\n};\njQuery.each( ajaxEvents.split(\"|\"),\n\tfunction( _, name ) {\n\t\tjQuery.event.special[ name ] = {\n\t\t\tsetup: function() {\n\t\t\t\tvar elem = this;\n\n\t\t\t\t// The document needs no shimming; must be !== for oldIE\n\t\t\t\tif ( elem !== document ) {\n\t\t\t\t\tjQuery.event.add( document, name + \".\" + jQuery.guid, function() {\n\t\t\t\t\t\tjQuery.event.trigger( name, Array.prototype.slice.call( arguments, 1 ), elem, true );\n\t\t\t\t\t});\n\t\t\t\t\tjQuery._data( this, name, jQuery.guid++ );\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tteardown: function() {\n\t\t\t\tif ( this !== document ) {\n\t\t\t\t\tjQuery.event.remove( document, name + \".\" + jQuery._data( this, name ) );\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t}\n\t\t};\n\t}\n);\n\njQuery.event.special.ready = {\n\tsetup: function() {\n\t\tif ( this === document ) {\n\t\t\tmigrateWarn( \"'ready' event is deprecated\" );\n\t\t}\n\t}\n};\n\nvar oldSelf = jQuery.fn.andSelf || jQuery.fn.addBack,\n\toldFnFind = jQuery.fn.find;\n\njQuery.fn.andSelf = function() {\n\tmigrateWarn(\"jQuery.fn.andSelf() replaced by jQuery.fn.addBack()\");\n\treturn oldSelf.apply( this, arguments );\n};\n\njQuery.fn.find = function( selector ) {\n\tvar ret = oldFnFind.apply( this, arguments );\n\tret.context = this.context;\n\tret.selector = this.selector ? this.selector + \" \" + selector : selector;\n\treturn ret;\n};\n\n\n// jQuery 1.6 did not support Callbacks, do not warn there\nif ( jQuery.Callbacks ) {\n\n\tvar oldDeferred = jQuery.Deferred,\n\t\ttuples = [\n\t\t\t// action, add listener, callbacks, .then handlers, final state\n\t\t\t[ \"resolve\", \"done\", jQuery.Callbacks(\"once memory\"),\n\t\t\t\tjQuery.Callbacks(\"once memory\"), \"resolved\" ],\n\t\t\t[ \"reject\", \"fail\", jQuery.Callbacks(\"once memory\"),\n\t\t\t\tjQuery.Callbacks(\"once memory\"), \"rejected\" ],\n\t\t\t[ \"notify\", \"progress\", jQuery.Callbacks(\"memory\"),\n\t\t\t\tjQuery.Callbacks(\"memory\") ]\n\t\t];\n\n\tjQuery.Deferred = function( func ) {\n\t\tvar deferred = oldDeferred(),\n\t\t\tpromise = deferred.promise();\n\n\t\tdeferred.pipe = promise.pipe = function( /* fnDone, fnFail, fnProgress */ ) {\n\t\t\tvar fns = arguments;\n\n\t\t\tmigrateWarn( \"deferred.pipe() is deprecated\" );\n\n\t\t\treturn jQuery.Deferred(function( newDefer ) {\n\t\t\t\tjQuery.each( tuples, function( i, tuple ) {\n\t\t\t\t\tvar fn = jQuery.isFunction( fns[ i ] ) && fns[ i ];\n\t\t\t\t\t// deferred.done(function() { bind to newDefer or newDefer.resolve })\n\t\t\t\t\t// deferred.fail(function() { bind to newDefer or newDefer.reject })\n\t\t\t\t\t// deferred.progress(function() { bind to newDefer or newDefer.notify })\n\t\t\t\t\tdeferred[ tuple[1] ](function() {\n\t\t\t\t\t\tvar returned = fn && fn.apply( this, arguments );\n\t\t\t\t\t\tif ( returned && jQuery.isFunction( returned.promise ) ) {\n\t\t\t\t\t\t\treturned.promise()\n\t\t\t\t\t\t\t\t.done( newDefer.resolve )\n\t\t\t\t\t\t\t\t.fail( newDefer.reject )\n\t\t\t\t\t\t\t\t.progress( newDefer.notify );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tnewDefer[ tuple[ 0 ] + \"With\" ](\n\t\t\t\t\t\t\t\tthis === promise ? newDefer.promise() : this,\n\t\t\t\t\t\t\t\tfn ? [ returned ] : arguments\n\t\t\t\t\t\t\t);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t\tfns = null;\n\t\t\t}).promise();\n\n\t\t};\n\n\t\tdeferred.isResolved = function() {\n\t\t\tmigrateWarn( \"deferred.isResolved is deprecated\" );\n\t\t\treturn deferred.state() === \"resolved\";\n\t\t};\n\n\t\tdeferred.isRejected = function() {\n\t\t\tmigrateWarn( \"deferred.isRejected is deprecated\" );\n\t\t\treturn deferred.state() === \"rejected\";\n\t\t};\n\n\t\tif ( func ) {\n\t\t\tfunc.call( deferred, deferred );\n\t\t}\n\n\t\treturn deferred;\n\t};\n\n}\n\n})( jQuery, window );\n\n","jquery/jquery.validate.js":"/**\n * jQuery Validation Plugin @VERSION\n *\n * http://bassistance.de/jquery-plugins/jquery-plugin-validation/\n * http://docs.jquery.com/Plugins/Validation\n *\n * Copyright (c) 2012 J\u00f6rn Zaefferer\n *\n * Dual licensed under the MIT and GPL licenses:\n *   http://www.opensource.org/licenses/mit-license.php\n *   http://www.gnu.org/licenses/gpl.html\n */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"jquery/jquery.metadata\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function (jQuery) {\n\n(function ($) {\n\n    $.extend($.fn, {\n        // http://docs.jquery.com/Plugins/Validation/validate\n        validate: function (options) {\n\n            // if nothing is selected, return nothing; can't chain anyway\n            if (!this.length) {\n                if (options && options.debug && window.console) {\n                    console.warn(\"nothing selected, can't validate, returning nothing\");\n                }\n                return;\n            }\n\n            // check if a validator for this form was already created\n            var validator = $.data(this[0], 'validator');\n            if (validator) {\n                return validator;\n            }\n\n            // Add novalidate tag if HTML5.\n            this.attr('novalidate', 'novalidate');\n\n            validator = new $.validator(options, this[0]);\n            $.data(this[0], 'validator', validator);\n\n            if (validator.settings.onsubmit) {\n\n                this.validateDelegate(\":submit\", \"click\", function (ev) {\n                    if (validator.settings.submitHandler) {\n                        validator.submitButton = ev.target;\n                    }\n                    // allow suppressing validation by adding a cancel class to the submit button\n                    if ($(ev.target).hasClass('cancel')) {\n                        validator.cancelSubmit = true;\n                    }\n                });\n\n                // validate the form on submit\n                this.submit(function (event) {\n                    if (validator.settings.debug) {\n                        // prevent form submit to be able to see console output\n                        event.preventDefault();\n                    }\n                    function handle() {\n                        var hidden;\n                        if (validator.settings.submitHandler) {\n                            if (validator.submitButton) {\n                                // insert a hidden input as a replacement for the missing submit button\n                                hidden = $(\"<input type='hidden'/>\").attr(\"name\", validator.submitButton.name).val(validator.submitButton.value).appendTo(validator.currentForm);\n                            }\n                            validator.settings.submitHandler.call(validator, validator.currentForm, event);\n                            if (validator.submitButton) {\n                                // and clean up afterwards; thanks to no-block-scope, hidden can be referenced\n                                hidden.remove();\n                            }\n                            return false;\n                        }\n                        return true;\n                    }\n\n                    // prevent submit for invalid forms or custom submit handlers\n                    if (validator.cancelSubmit) {\n                        validator.cancelSubmit = false;\n                        return handle();\n                    }\n                    if (validator.form()) {\n                        if (validator.pendingRequest) {\n                            validator.formSubmitted = true;\n                            return false;\n                        }\n                        return handle();\n                    } else {\n                        validator.focusInvalid();\n                        return false;\n                    }\n                });\n            }\n\n            return validator;\n        },\n        // http://docs.jquery.com/Plugins/Validation/valid\n        valid: function () {\n            if ($(this[0]).is('form')) {\n                return this.validate().form();\n            } else {\n                var valid = true;\n                var validator = $(this[0].form).validate();\n                this.each(function () {\n                    valid &= validator.element(this);\n                });\n                return valid;\n            }\n        },\n        // attributes: space seperated list of attributes to retrieve and remove\n        removeAttrs: function (attributes) {\n            var result = {},\n                $element = this;\n            $.each(attributes.split(/\\s/), function (index, value) {\n                result[value] = $element.attr(value);\n                $element.removeAttr(value);\n            });\n            return result;\n        },\n        // http://docs.jquery.com/Plugins/Validation/rules\n        rules: function (command, argument) {\n            var element = this[0];\n\n            if (command) {\n                var settings = $.data(element.form, 'validator').settings;\n                var staticRules = settings.rules;\n                var existingRules = $.validator.staticRules(element);\n                switch (command) {\n                    case \"add\":\n                        $.extend(existingRules, $.validator.normalizeRule(argument));\n                        staticRules[element.name] = existingRules;\n                        if (argument.messages) {\n                            settings.messages[element.name] = $.extend(settings.messages[element.name], argument.messages);\n                        }\n                        break;\n                    case \"remove\":\n                        if (!argument) {\n                            delete staticRules[element.name];\n                            return existingRules;\n                        }\n                        var filtered = {};\n                        $.each(argument.split(/\\s/), function (index, method) {\n                            filtered[method] = existingRules[method];\n                            delete existingRules[method];\n                        });\n                        return filtered;\n                }\n            }\n\n            var data = $.validator.normalizeRules(\n                $.extend(\n                    {},\n                    $.validator.metadataRules(element),\n                    $.validator.classRules(element),\n                    $.validator.attributeRules(element),\n                    $.validator.staticRules(element)\n                ), element);\n\n            // make sure required is at front\n            if (data.required) {\n                var param = data.required;\n                delete data.required;\n                data = $.extend({required: param}, data);\n            }\n\n            return data;\n        }\n    });\n\n// Custom selectors\n    $.extend($.expr[\":\"], {\n        // http://docs.jquery.com/Plugins/Validation/blank\n        blank: function (a) {\n            return !$.trim(\"\" + a.value);\n        },\n        // http://docs.jquery.com/Plugins/Validation/filled\n        filled: function (a) {\n            return !!$.trim(\"\" + a.value);\n        },\n        // http://docs.jquery.com/Plugins/Validation/unchecked\n        unchecked: function (a) {\n            return !a.checked;\n        }\n    });\n\n// constructor for validator\n    $.validator = function (options, form) {\n        this.settings = $.extend(true, {}, $.validator.defaults, options);\n        this.currentForm = form;\n        this.init();\n    };\n\n    $.validator.format = function (source, params) {\n        if (arguments.length === 1) {\n            return function () {\n                var args = $.makeArray(arguments);\n                args.unshift(source);\n                return $.validator.format.apply(this, args);\n            };\n        }\n        if (arguments.length > 2 && params.constructor !== Array) {\n            params = $.makeArray(arguments).slice(1);\n        }\n        if (params.constructor !== Array) {\n            params = [ params ];\n        }\n        $.each(params, function (i, n) {\n            source = source.replace(new RegExp(\"\\\\{\" + i + \"\\\\}\", \"g\"), n);\n        });\n        return source;\n    };\n\n    $.extend($.validator, {\n\n        defaults: {\n            messages: {},\n            groups: {},\n            rules: {},\n            errorClass: \"error\",\n            validClass: \"valid\",\n            errorElement: \"label\",\n            focusInvalid: true,\n            errorContainer: $([]),\n            errorLabelContainer: $([]),\n            onsubmit: true,\n            ignore: \":hidden\",\n            ignoreTitle: false,\n            onfocusin: function (element, event) {\n                this.lastActive = element;\n\n                // hide error label and remove error class on focus if enabled\n                if (this.settings.focusCleanup && !this.blockFocusCleanup) {\n                    if (this.settings.unhighlight) {\n                        this.settings.unhighlight.call(this, element, this.settings.errorClass, this.settings.validClass);\n                    }\n                    this.addWrapper(this.errorsFor(element)).hide();\n                }\n            },\n            onfocusout: function (element, event) {\n                if (!this.checkable(element) && (element.name in this.submitted || !this.optional(element))) {\n                    this.element(element);\n                }\n            },\n            onkeyup: function (element, event) {\n                if (event.which == 9 && this.elementValue(element) === '') {\n                    return;\n                } else if (element.name in this.submitted || element === this.lastActive) {\n                    this.element(element);\n                }\n            },\n            onclick: function (element, event) {\n                // click on selects, radiobuttons and checkboxes\n                if (element.name in this.submitted) {\n                    this.element(element);\n                }\n                // or option elements, check parent select in that case\n                else if (element.parentNode.name in this.submitted) {\n                    this.element(element.parentNode);\n                }\n            },\n            highlight: function (element, errorClass, validClass) {\n                if (element.type === 'radio') {\n                    this.findByName(element.name).addClass(errorClass).removeClass(validClass);\n                } else {\n                    $(element).addClass(errorClass).removeClass(validClass);\n                }\n            },\n            unhighlight: function (element, errorClass, validClass) {\n                if (element.type === 'radio') {\n                    this.findByName(element.name).removeClass(errorClass).addClass(validClass);\n                } else {\n                    $(element).removeClass(errorClass).addClass(validClass);\n                }\n            }\n        },\n\n        // http://docs.jquery.com/Plugins/Validation/Validator/setDefaults\n        setDefaults: function (settings) {\n            $.extend($.validator.defaults, settings);\n        },\n\n        messages: {\n            required: \"This field is required.\",\n            remote: \"Please fix this field.\",\n            email: \"Please enter a valid email address.\",\n            url: \"Please enter a valid URL.\",\n            date: \"Please enter a valid date.\",\n            dateISO: \"Please enter a valid date (ISO).\",\n            number: \"Please enter a valid number.\",\n            digits: \"Please enter only digits.\",\n            creditcard: \"Please enter a valid credit card number.\",\n            equalTo: \"Please enter the same value again.\",\n            maxlength: $.validator.format(\"Please enter no more than {0} characters.\"),\n            minlength: $.validator.format(\"Please enter at least {0} characters.\"),\n            rangelength: $.validator.format(\"Please enter a value between {0} and {1} characters long.\"),\n            range: $.validator.format(\"Please enter a value between {0} and {1}.\"),\n            max: $.validator.format(\"Please enter a value less than or equal to {0}.\"),\n            min: $.validator.format(\"Please enter a value greater than or equal to {0}.\")\n        },\n\n        autoCreateRanges: false,\n\n        prototype: {\n\n            init: function () {\n                this.labelContainer = $(this.settings.errorLabelContainer);\n                this.errorContext = this.labelContainer.length && this.labelContainer || $(this.currentForm);\n                this.containers = $(this.settings.errorContainer).add(this.settings.errorLabelContainer);\n                this.submitted = {};\n                this.valueCache = {};\n                this.pendingRequest = 0;\n                this.pending = {};\n                this.invalid = {};\n                this.reset();\n\n                var groups = (this.groups = {});\n                $.each(this.settings.groups, function (key, value) {\n                    $.each(value.split(/\\s/), function (index, name) {\n                        groups[name] = key;\n                    });\n                });\n                var rules = this.settings.rules;\n                $.each(rules, function (key, value) {\n                    rules[key] = $.validator.normalizeRule(value);\n                });\n\n                function delegate(event) {\n                    var validator = $.data(this[0].form, \"validator\"),\n                        eventType = \"on\" + event.type.replace(/^validate/, \"\");\n                    if (validator.settings[eventType]) {\n                        validator.settings[eventType].call(validator, this[0], event);\n                    }\n                }\n\n                $(this.currentForm)\n                    .validateDelegate(\":text, [type='password'], [type='file'], select, textarea, \" +\n                    \"[type='number'], [type='search'], input.search, [type='tel'], [type='url'], \" +\n                    \"[type='email'], [type='datetime'], [type='date'], [type='month'], \" +\n                    \"[type='week'], [type='time'], [type='datetime-local'], \" +\n                    \"[type='range'], [type='color'] \",\n                    \"focusin focusout keyup\", delegate)\n                    .validateDelegate(\"[type='radio'], [type='checkbox'], select, option\", \"click\", delegate);\n\n                if (this.settings.invalidHandler) {\n                    $(this.currentForm).bind(\"invalid-form.validate\", this.settings.invalidHandler);\n                }\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Validator/form\n            form: function () {\n                this.checkForm();\n                $.extend(this.submitted, this.errorMap);\n                this.invalid = $.extend({}, this.errorMap);\n                if (!this.valid()) {\n                    $(this.currentForm).triggerHandler(\"invalid-form\", [this]);\n                }\n                this.showErrors();\n                return this.valid();\n            },\n\n            checkForm: function () {\n                this.prepareForm();\n                for (var i = 0, elements = (this.currentElements = this.elements()); elements[i]; i++) {\n                    this.check(elements[i]);\n                }\n                return this.valid();\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Validator/element\n            element: function (element) {\n                element = this.validationTargetFor(this.clean(element));\n                this.lastElement = element;\n                this.prepareElement(element);\n                this.currentElements = $(element);\n                var result = this.check(element) !== false;\n                if (result) {\n                    delete this.invalid[element.name];\n                } else {\n                    this.invalid[element.name] = true;\n                }\n                if (!this.numberOfInvalids()) {\n                    // Hide error containers on last error\n                    this.toHide = this.toHide.add(this.containers);\n                }\n                this.showErrors();\n                return result;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Validator/showErrors\n            showErrors: function (errors) {\n                if (errors) {\n                    // add items to error list and map\n                    $.extend(this.errorMap, errors);\n                    this.errorList = [];\n                    for (var name in errors) {\n                        this.errorList.push({\n                            message: errors[name],\n                            element: this.findByName(name)[0]\n                        });\n                    }\n                    // remove items from success list\n                    this.successList = $.grep(this.successList, function (element) {\n                        return !(element.name in errors);\n                    });\n                }\n                if (this.settings.showErrors) {\n                    this.settings.showErrors.call(this, this.errorMap, this.errorList);\n                } else {\n                    this.defaultShowErrors();\n                }\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Validator/resetForm\n            resetForm: function () {\n                if ($.fn.resetForm) {\n                    $(this.currentForm).resetForm();\n                }\n                this.submitted = {};\n                this.lastElement = null;\n                this.prepareForm();\n                this.hideErrors();\n                this.elements().removeClass(this.settings.errorClass).removeData(\"previousValue\");\n            },\n\n            numberOfInvalids: function () {\n                return this.objectLength(this.invalid);\n            },\n\n            objectLength: function (obj) {\n                var count = 0;\n                for (var i in obj) {\n                    count++;\n                }\n                return count;\n            },\n\n            hideErrors: function () {\n                this.addWrapper(this.toHide).hide();\n            },\n\n            valid: function () {\n                return this.size() === 0;\n            },\n\n            size: function () {\n                return this.errorList.length;\n            },\n\n            focusInvalid: function () {\n                if (this.settings.focusInvalid) {\n                    try {\n                        $(this.findLastActive() || this.errorList.length && this.errorList[0].element || [])\n                            .filter(\":visible\")\n                            .focus()\n                            // manually trigger focusin event; without it, focusin handler isn't called, findLastActive won't have anything to find\n                            .trigger(\"focusin\");\n                    } catch (e) {\n                        // ignore IE throwing errors when focusing hidden elements\n                    }\n                }\n            },\n\n            findLastActive: function () {\n                var lastActive = this.lastActive;\n                return lastActive && $.grep(this.errorList,function (n) {\n                    return n.element.name === lastActive.name;\n                }).length === 1 && lastActive;\n            },\n\n            elements: function () {\n                var validator = this,\n                    rulesCache = {};\n\n                // select all valid inputs inside the form (no submit or reset buttons)\n                return $(this.currentForm)\n                    .find(\"input, select, textarea\")\n                    .not(\":submit, :reset, :image, [disabled]\")\n                    .not(this.settings.ignore)\n                    .filter(function () {\n                        if (!this.name && validator.settings.debug && window.console) {\n                            console.error(\"%o has no name assigned\", this);\n                        }\n\n                        // select only the first element for each name, and only those with rules specified\n                        if (this.name in rulesCache || !validator.objectLength($(this).rules())) {\n                            return false;\n                        }\n\n                        rulesCache[this.name] = true;\n                        return true;\n                    });\n            },\n\n            clean: function (selector) {\n                return $(selector)[0];\n            },\n\n            errors: function () {\n                var errorClass = this.settings.errorClass.replace(' ', '.');\n                return $(this.settings.errorElement + \".\" + errorClass, this.errorContext);\n            },\n\n            reset: function () {\n                this.successList = [];\n                this.errorList = [];\n                this.errorMap = {};\n                this.toShow = $([]);\n                this.toHide = $([]);\n                this.currentElements = $([]);\n            },\n\n            prepareForm: function () {\n                this.reset();\n                this.toHide = this.errors().add(this.containers);\n            },\n\n            prepareElement: function (element) {\n                this.reset();\n                this.toHide = this.errorsFor(element);\n            },\n\n            elementValue: function (element) {\n                var type = $(element).attr('type'),\n                    val = $(element).val();\n\n                if (type === 'radio' || type === 'checkbox') {\n                    return $('input[name=\"' + $(element).attr('name') + '\"]:checked').val();\n                }\n\n                if (typeof val === 'string') {\n                    return val.replace(/\\r/g, \"\");\n                }\n                return val;\n            },\n\n            check: function (element) {\n                element = this.validationTargetFor(this.clean(element));\n\n                var rules = $(element).rules();\n                var dependencyMismatch = false;\n                var val = this.elementValue(element);\n                var result;\n\n                for (var method in rules) {\n                    var rule = { method: method, parameters: rules[method] };\n                    try {\n\n                        result = $.validator.methods[method].call(this, val, element, rule.parameters);\n\n                        // if a method indicates that the field is optional and therefore valid,\n                        // don't mark it as valid when there are no other rules\n                        if (result === \"dependency-mismatch\") {\n                            dependencyMismatch = true;\n                            continue;\n                        }\n                        dependencyMismatch = false;\n\n                        if (result === \"pending\") {\n                            this.toHide = this.toHide.not(this.errorsFor(element));\n                            return;\n                        }\n\n                        if (!result) {\n                            this.formatAndAdd(element, rule);\n                            return false;\n                        }\n                    } catch (e) {\n                        if (this.settings.debug && window.console) {\n                            console.log(\"exception occurred when checking element \" + element.id + \", check the '\" + rule.method + \"' method\", e);\n                        }\n                        throw e;\n                    }\n                }\n                if (dependencyMismatch) {\n                    return;\n                }\n                if (this.objectLength(rules)) {\n                    this.successList.push(element);\n                }\n                return true;\n            },\n\n            // return the custom message for the given element and validation method\n            // specified in the element's \"messages\" metadata\n            customMetaMessage: function (element, method) {\n                if (!$.metadata) {\n                    return;\n                }\n                var meta = this.settings.meta ? $(element).metadata()[this.settings.meta] : $(element).metadata();\n                return meta && meta.messages && meta.messages[method];\n            },\n\n            // return the custom message for the given element and validation method\n            // specified in the element's HTML5 data attribute\n            customDataMessage: function (element, method) {\n                return $(element).data('msg-' + method.toLowerCase()) || (element.attributes && $(element).attr('data-msg-' + method.toLowerCase()));\n            },\n\n            // return the custom message for the given element name and validation method\n            customMessage: function (name, method) {\n                var m = this.settings.messages[name];\n                return m && (m.constructor === String ? m : m[method]);\n            },\n\n            // return the first defined argument, allowing empty strings\n            findDefined: function () {\n                for (var i = 0; i < arguments.length; i++) {\n                    if (arguments[i] !== undefined) {\n                        return arguments[i];\n                    }\n                }\n                return undefined;\n            },\n\n            defaultMessage: function (element, method) {\n                var noMessage = $.mage.__(\"Warning: No message defined for %s\");\n                return this.findDefined(\n                    this.customMessage(element.name, method),\n                    this.customDataMessage(element, method),\n                    this.customMetaMessage(element, method),\n                    // title is never undefined, so handle empty string as undefined\n                    !this.settings.ignoreTitle && element.title || undefined,\n                    $.validator.messages[method],\n                    \"<strong>\" + noMessage.replace('%s', element.name) + \"</strong>\"\n                );\n            },\n\n            formatAndAdd: function (element, rule) {\n                var message = this.defaultMessage(element, rule.method),\n                    theregex = /\\$?\\{(\\d+)\\}/g;\n                if (typeof message === \"function\") {\n                    message = message.call(this, rule.parameters, element);\n                } else if (theregex.test(message)) {\n                    message = $.validator.format(message.replace(theregex, '{$1}'), rule.parameters);\n                }\n                this.errorList.push({\n                    message: message,\n                    element: element\n                });\n\n                this.errorMap[element.name] = message;\n                this.submitted[element.name] = message;\n            },\n\n            addWrapper: function (toToggle) {\n                if (this.settings.wrapper) {\n                    toToggle = toToggle.add(toToggle.parent(this.settings.wrapper));\n                }\n                return toToggle;\n            },\n\n            defaultShowErrors: function () {\n                var i, elements;\n                for (i = 0; this.errorList[i]; i++) {\n                    var error = this.errorList[i];\n                    if (this.settings.highlight) {\n                        this.settings.highlight.call(this, error.element, this.settings.errorClass, this.settings.validClass);\n                    }\n                    this.showLabel(error.element, error.message);\n                }\n                if (this.errorList.length) {\n                    this.toShow = this.toShow.add(this.containers);\n                }\n                if (this.settings.success) {\n                    for (i = 0; this.successList[i]; i++) {\n                        this.showLabel(this.successList[i]);\n                    }\n                }\n                if (this.settings.unhighlight) {\n                    for (i = 0, elements = this.validElements(); elements[i]; i++) {\n                        this.settings.unhighlight.call(this, elements[i], this.settings.errorClass, this.settings.validClass);\n                    }\n                }\n                this.toHide = this.toHide.not(this.toShow);\n                this.hideErrors();\n                this.addWrapper(this.toShow).show();\n            },\n\n            validElements: function () {\n                return this.currentElements.not(this.invalidElements());\n            },\n\n            invalidElements: function () {\n                return $(this.errorList).map(function () {\n                    return this.element;\n                });\n            },\n\n            showLabel: function (element, message) {\n                var label = this.errorsFor(element);\n                if (label.length) {\n                    // refresh error/success class\n                    label.removeClass(this.settings.validClass).addClass(this.settings.errorClass);\n\n                    // check if we have a generated label, replace the message then\n                    if (label.attr(\"generated\")) {\n                        label.hide().html(message);\n                    }\n                } else {\n                    // create label\n                    label = $(\"<\" + this.settings.errorElement + \"/>\")\n                        .attr({\"for\": this.idOrName(element), generated: true})\n                        .addClass(this.settings.errorClass)\n                        .html(message || \"\");\n                    if (this.settings.wrapper) {\n                        // make sure the element is visible, even in IE\n                        // actually showing the wrapped element is handled elsewhere\n                        label = label.hide().show().wrap(\"<\" + this.settings.wrapper + \"/>\").parent();\n                    }\n                    if (!this.labelContainer.append(label).length) {\n                        if (this.settings.errorPlacement) {\n                            this.settings.errorPlacement(label, $(element));\n                        } else {\n                            label.insertAfter(element);\n                        }\n                    }\n                }\n                if (!message && this.settings.success) {\n                    label.text(\"\");\n                    if (typeof this.settings.success === \"string\") {\n                        label.addClass(this.settings.success);\n                    } else {\n                        this.settings.success(label, element);\n                    }\n                }\n                this.toShow = this.toShow.add(label);\n            },\n\n            errorsFor: function (element) {\n                var name = this.idOrName(element);\n                return this.errors().filter(function () {\n                    return $(this).attr('for') === name;\n                });\n            },\n\n            idOrName: function (element) {\n                return this.groups[element.name] || (this.checkable(element) ? element.name : element.id || element.name);\n            },\n\n            validationTargetFor: function (element) {\n                // if radio/checkbox, validate first element in group instead\n                if (this.checkable(element)) {\n                    element = this.findByName(element.name).not(this.settings.ignore)[0];\n                }\n                return element;\n            },\n\n            checkable: function (element) {\n                return (/radio|checkbox/i).test(element.type);\n            },\n\n            findByName: function (name) {\n                return $(this.currentForm).find('[name=\"' + name + '\"]');\n            },\n\n            getLength: function (value, element) {\n                switch (element.nodeName.toLowerCase()) {\n                    case 'select':\n                        return $(\"option:selected\", element).length;\n                    case 'input':\n                        if (this.checkable(element)) {\n                            return this.findByName(element.name).filter(':checked').length;\n                        }\n                }\n                return value.length;\n            },\n\n            depend: function (param, element) {\n                return this.dependTypes[typeof param] ? this.dependTypes[typeof param](param, element) : true;\n            },\n\n            dependTypes: {\n                \"boolean\": function (param, element) {\n                    return param;\n                },\n                \"string\": function (param, element) {\n                    return !!$(param, element.form).length;\n                },\n                \"function\": function (param, element) {\n                    return param(element);\n                }\n            },\n\n            optional: function (element) {\n                var val = this.elementValue(element);\n                return !$.validator.methods.required.call(this, val, element) && \"dependency-mismatch\";\n            },\n\n            startRequest: function (element) {\n                if (!this.pending[element.name]) {\n                    this.pendingRequest++;\n                    this.pending[element.name] = true;\n                }\n            },\n\n            stopRequest: function (element, valid) {\n                this.pendingRequest--;\n                // sometimes synchronization fails, make sure pendingRequest is never < 0\n                if (this.pendingRequest < 0) {\n                    this.pendingRequest = 0;\n                }\n                delete this.pending[element.name];\n                if (valid && this.pendingRequest === 0 && this.formSubmitted && this.form()) {\n                    $(this.currentForm).submit();\n                    this.formSubmitted = false;\n                } else if (!valid && this.pendingRequest === 0 && this.formSubmitted) {\n                    $(this.currentForm).triggerHandler(\"invalid-form\", [this]);\n                    this.formSubmitted = false;\n                }\n            },\n\n            previousValue: function (element) {\n                return $.data(element, \"previousValue\") || $.data(element, \"previousValue\", {\n                    old: null,\n                    valid: true,\n                    message: this.defaultMessage(element, \"remote\")\n                });\n            }\n\n        },\n\n        classRuleSettings: {\n            required: {required: true},\n            email: {email: true},\n            url: {url: true},\n            date: {date: true},\n            dateISO: {dateISO: true},\n            number: {number: true},\n            digits: {digits: true},\n            creditcard: {creditcard: true}\n        },\n\n        addClassRules: function (className, rules) {\n            if (className.constructor === String) {\n                this.classRuleSettings[className] = rules;\n            } else {\n                $.extend(this.classRuleSettings, className);\n            }\n        },\n\n        classRules: function (element) {\n            var rules = {};\n            var classes = $(element).attr('class');\n            if (classes) {\n                $.each(classes.split(' '), function () {\n                    if (this in $.validator.classRuleSettings) {\n                        $.extend(rules, $.validator.classRuleSettings[this]);\n                    }\n                });\n            }\n            return rules;\n        },\n\n        attributeRules: function (element) {\n            var rules = {};\n            var $element = $(element);\n\n            for (var method in $.validator.methods) {\n                var value;\n\n                // support for <input required> in both html5 and older browsers\n                if (method === 'required') {\n                    value = $element.get(0).getAttribute(method);\n                    // Some browsers return an empty string for the required attribute\n                    // and non-HTML5 browsers might have required=\"\" markup\n                    if (value === \"\") {\n                        value = true;\n                    }\n                    // force non-HTML5 browsers to return bool\n                    value = !!value;\n                } else {\n                    value = $element.attr(method);\n                }\n\n                if (value) {\n                    rules[method] = value;\n                } else if ($element[0].getAttribute(\"type\") === method) {\n                    rules[method] = true;\n                }\n            }\n\n            // maxlength may be returned as -1, 2147483647 (IE) and 524288 (safari) for text inputs\n            if (rules.maxlength && /-1|2147483647|524288/.test(rules.maxlength)) {\n                delete rules.maxlength;\n            }\n\n            return rules;\n        },\n\n        metadataRules: function (element) {\n            if (!$.metadata) {\n                return {};\n            }\n\n            var meta = $.data(element.form, 'validator').settings.meta;\n            return meta ?\n                $(element).metadata()[meta] :\n                $(element).metadata();\n        },\n\n        staticRules: function (element) {\n            var rules = {};\n            var validator = $.data(element.form, 'validator');\n            if (validator.settings.rules) {\n                rules = $.validator.normalizeRule(validator.settings.rules[element.name]) || {};\n            }\n            return rules;\n        },\n\n        normalizeRules: function (rules, element) {\n            // handle dependency check\n            $.each(rules, function (prop, val) {\n                // ignore rule when param is explicitly false, eg. required:false\n                if (val === false) {\n                    delete rules[prop];\n                    return;\n                }\n                if (val.param || val.depends) {\n                    var keepRule = true;\n                    switch (typeof val.depends) {\n                        case \"string\":\n                            keepRule = !!$(val.depends, element.form).length;\n                            break;\n                        case \"function\":\n                            keepRule = val.depends.call(element, element);\n                            break;\n                    }\n                    if (keepRule) {\n                        rules[prop] = val.param !== undefined ? val.param : true;\n                    } else {\n                        delete rules[prop];\n                    }\n                }\n            });\n\n            // evaluate parameters\n            $.each(rules, function (rule, parameter) {\n                rules[rule] = $.isFunction(parameter) ? parameter(element) : parameter;\n            });\n\n            // clean number parameters\n            $.each(['minlength', 'maxlength', 'min', 'max'], function () {\n                if (rules[this]) {\n                    rules[this] = Number(rules[this]);\n                }\n            });\n            $.each(['rangelength', 'range'], function () {\n                if (rules[this]) {\n                    rules[this] = [Number(rules[this][0]), Number(rules[this][1])];\n                }\n            });\n\n            if ($.validator.autoCreateRanges) {\n                // auto-create ranges\n                if (rules.min && rules.max) {\n                    rules.range = [rules.min, rules.max];\n                    delete rules.min;\n                    delete rules.max;\n                }\n                if (rules.minlength && rules.maxlength) {\n                    rules.rangelength = [rules.minlength, rules.maxlength];\n                    delete rules.minlength;\n                    delete rules.maxlength;\n                }\n            }\n\n            // To support custom messages in metadata ignore rule methods titled \"messages\"\n            if (rules.messages) {\n                delete rules.messages;\n            }\n\n            return rules;\n        },\n\n        // Converts a simple string to a {string: true} rule, e.g., \"required\" to {required:true}\n        normalizeRule: function (data) {\n            if (typeof data === \"string\") {\n                var transformed = {};\n                $.each(data.split(/\\s/), function () {\n                    transformed[this] = true;\n                });\n                data = transformed;\n            }\n            return data;\n        },\n\n        // http://docs.jquery.com/Plugins/Validation/Validator/addMethod\n        addMethod: function (name, method, message) {\n            $.validator.methods[name] = method;\n            $.validator.messages[name] = message !== undefined ? message : $.validator.messages[name];\n            if (method.length < 3) {\n                $.validator.addClassRules(name, $.validator.normalizeRule(name));\n            }\n        },\n\n        methods: {\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/required\n            required: function (value, element, param) {\n                // check if dependency is met\n                if (!this.depend(param, element)) {\n                    return \"dependency-mismatch\";\n                }\n                if (element.nodeName.toLowerCase() === \"select\") {\n                    // could be an array for select-multiple or a string, both are fine this way\n                    var val = $(element).val();\n                    return val && val.length > 0;\n                }\n                if (this.checkable(element)) {\n                    return this.getLength(value, element) > 0;\n                }\n                return $.trim(value).length > 0;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/remote\n            remote: function (value, element, param) {\n                if (this.optional(element)) {\n                    return \"dependency-mismatch\";\n                }\n\n                var previous = this.previousValue(element);\n                if (!this.settings.messages[element.name]) {\n                    this.settings.messages[element.name] = {};\n                }\n                previous.originalMessage = this.settings.messages[element.name].remote;\n                this.settings.messages[element.name].remote = previous.message;\n\n                param = typeof param === \"string\" && {url: param} || param;\n\n                if (this.pending[element.name]) {\n                    return \"pending\";\n                }\n                if (previous.old === value) {\n                    return previous.valid;\n                }\n\n                previous.old = value;\n                var validator = this;\n                this.startRequest(element);\n                var data = {};\n                data[element.name] = value;\n                $.ajax($.extend(true, {\n                    url: param,\n                    mode: \"abort\",\n                    port: \"validate\" + element.name,\n                    dataType: \"json\",\n                    data: data,\n                    success: function (response) {\n                        validator.settings.messages[element.name].remote = previous.originalMessage;\n                        var valid = response === true || response === \"true\";\n                        if (valid) {\n                            var submitted = validator.formSubmitted;\n                            validator.prepareElement(element);\n                            validator.formSubmitted = submitted;\n                            validator.successList.push(element);\n                            delete validator.invalid[element.name];\n                            validator.showErrors();\n                        } else {\n                            var errors = {};\n                            var message = response || validator.defaultMessage(element, \"remote\");\n                            errors[element.name] = previous.message = $.isFunction(message) ? message(value) : message;\n                            validator.invalid[element.name] = true;\n                            validator.showErrors(errors);\n                        }\n                        previous.valid = valid;\n                        validator.stopRequest(element, valid);\n                    }\n                }, param));\n                return \"pending\";\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/minlength\n            minlength: function (value, element, param) {\n                var length = $.isArray(value) ? value.length : this.getLength($.trim(value), element);\n                return this.optional(element) || length >= param;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/maxlength\n            maxlength: function (value, element, param) {\n                var length = $.isArray(value) ? value.length : this.getLength($.trim(value), element);\n                return this.optional(element) || length <= param;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/rangelength\n            rangelength: function (value, element, param) {\n                var length = $.isArray(value) ? value.length : this.getLength($.trim(value), element);\n                return this.optional(element) || ( length >= param[0] && length <= param[1] );\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/min\n            min: function (value, element, param) {\n                return this.optional(element) || value >= param;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/max\n            max: function (value, element, param) {\n                return this.optional(element) || value <= param;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/range\n            range: function (value, element, param) {\n                return this.optional(element) || ( value >= param[0] && value <= param[1] );\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/email\n            email: function (value, element) {\n                // contributed by Scott Gonzalez: http://projects.scottsplayground.com/email_address_validation/\n                return this.optional(element) || /^((([a-z]|\\d|[!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z]|\\d|[!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*)|((\\x22)((((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(([\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x7f]|\\x21|[\\x23-\\x5b]|[\\x5d-\\x7e]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(\\\\([\\x01-\\x09\\x0b\\x0c\\x0d-\\x7f]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]))))*(((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(\\x22)))@((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)+(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))$/i.test(value);\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/url\n            url: function (value, element) {\n                // contributed by Scott Gonzalez: http://projects.scottsplayground.com/iri/\n                return this.optional(element) || /^(https?|ftp):\\/\\/(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:)*@)?(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)+(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?)(:\\d*)?)(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)*)*)?)?(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?$/i.test(value);\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/date\n            date: function (value, element) {\n                return this.optional(element) || !/Invalid|NaN/.test(new Date(value));\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/dateISO\n            dateISO: function (value, element) {\n                return this.optional(element) || /^\\d{4}[\\/\\-]\\d{1,2}[\\/\\-]\\d{1,2}$/.test(value);\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/number\n            number: function (value, element) {\n                return this.optional(element) || /^-?(?:\\d+|\\d{1,3}(?:,\\d{3})+)?(?:\\.\\d+)?$/.test(value);\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/digits\n            digits: function (value, element) {\n                return this.optional(element) || /^\\d+$/.test(value);\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/creditcard\n            // based on http://en.wikipedia.org/wiki/Luhn\n            creditcard: function (value, element) {\n                if (this.optional(element)) {\n                    return \"dependency-mismatch\";\n                }\n                // accept only spaces, digits and dashes\n                if (/[^0-9 \\-]+/.test(value)) {\n                    return false;\n                }\n                var nCheck = 0,\n                    nDigit = 0,\n                    bEven = false;\n\n                value = value.replace(/\\D/g, \"\");\n\n                for (var n = value.length - 1; n >= 0; n--) {\n                    var cDigit = value.charAt(n);\n                    nDigit = parseInt(cDigit, 10);\n                    if (bEven) {\n                        if ((nDigit *= 2) > 9) {\n                            nDigit -= 9;\n                        }\n                    }\n                    nCheck += nDigit;\n                    bEven = !bEven;\n                }\n\n                return (nCheck % 10) === 0;\n            },\n\n            // http://docs.jquery.com/Plugins/Validation/Methods/equalTo\n            equalTo: function (value, element, param) {\n                // bind to the blur event of the target in order to revalidate whenever the target field is updated\n                // TODO find a way to bind the event just once, avoiding the unbind-rebind overhead\n                var target = $(param);\n                if (this.settings.onfocusout) {\n                    target.unbind(\".validate-equalTo\").bind(\"blur.validate-equalTo\", function () {\n                        $(element).valid();\n                    });\n                }\n                return value === target.val();\n            }\n\n        }\n\n    });\n\n// deprecated, use $.validator.format instead\n    $.format = $.validator.format;\n\n}(jQuery));\n\n// ajax mode: abort\n// usage: $.ajax({ mode: \"abort\"[, port: \"uniqueport\"]});\n// if mode:\"abort\" is used, the previous request on that port (port can be undefined) is aborted via XMLHttpRequest.abort()\n(function ($) {\n    var pendingRequests = {};\n    // Use a prefilter if available (1.5+)\n    if ($.ajaxPrefilter) {\n        $.ajaxPrefilter(function (settings, _, xhr) {\n            var port = settings.port;\n            if (settings.mode === \"abort\") {\n                if (pendingRequests[port]) {\n                    pendingRequests[port].abort();\n                }\n                pendingRequests[port] = xhr;\n            }\n        });\n    } else {\n        // Proxy ajax\n        var ajax = $.ajax;\n        $.ajax = function (settings) {\n            var mode = ( \"mode\" in settings ? settings : $.ajaxSettings ).mode,\n                port = ( \"port\" in settings ? settings : $.ajaxSettings ).port;\n            if (mode === \"abort\") {\n                if (pendingRequests[port]) {\n                    pendingRequests[port].abort();\n                }\n                return (pendingRequests[port] = ajax.apply(this, arguments));\n            }\n            return ajax.apply(this, arguments);\n        };\n    }\n}(jQuery));\n\n// provides cross-browser focusin and focusout events\n// IE has native support, in other browsers, use event caputuring (neither bubbles)\n\n// provides delegate(type: String, delegate: Selector, handler: Callback) plugin for easier event delegation\n// handler is only called when $(event.target).is(delegate), in the scope of the jquery-object for event.target\n(function ($) {\n    // only implement if not provided by jQuery core (since 1.4)\n    // TODO verify if jQuery 1.4's implementation is compatible with older jQuery special-event APIs\n    if (!jQuery.event.special.focusin && !jQuery.event.special.focusout && document.addEventListener) {\n        $.each({\n            focus: 'focusin',\n            blur: 'focusout'\n        }, function (original, fix) {\n            $.event.special[fix] = {\n                setup: function () {\n                    this.addEventListener(original, handler, true);\n                },\n                teardown: function () {\n                    this.removeEventListener(original, handler, true);\n                },\n                handler: function (e) {\n                    var args = arguments;\n                    args[0] = $.event.fix(e);\n                    args[0].type = fix;\n                    return $.event.handle.apply(this, args);\n                }\n            };\n            function handler(e) {\n                e = $.event.fix(e);\n                e.type = fix;\n                return $.event.handle.call(this, e);\n            }\n        });\n    }\n    $.extend($.fn, {\n        validateDelegate: function (delegate, type, handler) {\n            return this.bind(type, function (event) {\n                var target = $(event.target);\n                if (target.is(delegate)) {\n                    return handler.apply(target, arguments);\n                }\n            });\n        }\n    });\n}(jQuery));\n\n}));","jquery/jquery.hoverIntent.js":"/**\n * hoverIntent is similar to jQuery's built-in \"hover\" function except that\n * instead of firing the onMouseOver event immediately, hoverIntent checks\n * to see if the user's mouse has slowed down (beneath the sensitivity\n * threshold) before firing the onMouseOver event.\n *\n * hoverIntent r6 // 2011.02.26 // jQuery 1.5.1+\n * <http://cherne.net/brian/resources/jquery.hoverIntent.html>\n *\n * hoverIntent is currently available for use in all personal or commercial\n * projects under both MIT and GPL licenses. This means that you can choose\n * the license that best suits your project, and use it accordingly.\n *\n * // basic usage (just like .hover) receives onMouseOver and onMouseOut functions\n * $(\"ul li\").hoverIntent( showNav , hideNav );\n *\n * // advanced usage receives configuration object only\n * $(\"ul li\").hoverIntent({\n*\tsensitivity: 7, // number = sensitivity threshold (must be 1 or higher)\n*\tinterval: 100,   // number = milliseconds of polling interval\n*\tover: showNav,  // function = onMouseOver callback (required)\n*\ttimeout: 0,   // number = milliseconds delay before onMouseOut function call\n*\tout: hideNav    // function = onMouseOut callback (required)\n* });\n *\n * @param  f  onMouseOver function || An object with configuration options\n * @param  g  onMouseOut function  || Nothing (use configuration options object)\n * @author    Brian Cherne brian(at)cherne(dot)net\n */\n(function ($) {\n    $.fn.hoverIntent = function (f, g) {\n        // default configuration options\n        var cfg = {\n            sensitivity:7,\n            interval:100,\n            timeout:0\n        };\n        // override configuration options with user supplied object\n        cfg = $.extend(cfg, g ? { over:f, out:g } : f);\n\n        // instantiate variables\n        // cX, cY = current X and Y position of mouse, updated by mousemove event\n        // pX, pY = previous X and Y position of mouse, set by mouseover and polling interval\n        var cX, cY, pX, pY;\n\n        // A private function for getting mouse position\n        var track = function (ev) {\n            cX = ev.pageX;\n            cY = ev.pageY;\n        };\n\n        // A private function for comparing current and previous mouse position\n        var compare = function (ev, ob) {\n            ob.hoverIntent_t = clearTimeout(ob.hoverIntent_t);\n            // compare mouse positions to see if they've crossed the threshold\n            if (( Math.abs(pX - cX) + Math.abs(pY - cY) ) < cfg.sensitivity) {\n                $(ob).unbind(\"mousemove\", track);\n                // set hoverIntent state to true (so mouseOut can be called)\n                ob.hoverIntent_s = 1;\n                return cfg.over.apply(ob, [ev]);\n            } else {\n                // set previous coordinates for next time\n                pX = cX;\n                pY = cY;\n                // use self-calling timeout, guarantees intervals are spaced out properly (avoids JavaScript timer bugs)\n                ob.hoverIntent_t = setTimeout(function () {\n                    compare(ev, ob);\n                }, cfg.interval);\n            }\n        };\n\n        // A private function for delaying the mouseOut function\n        var delay = function (ev, ob) {\n            ob.hoverIntent_t = clearTimeout(ob.hoverIntent_t);\n            ob.hoverIntent_s = 0;\n            return cfg.out.apply(ob, [ev]);\n        };\n\n        // A private function for handling mouse 'hovering'\n        var handleHover = function (e) {\n            // copy objects to be passed into t (required for event object to be passed in IE)\n            var ev = jQuery.extend({}, e);\n            var ob = this;\n\n            // cancel hoverIntent timer if it exists\n            if (ob.hoverIntent_t) {\n                ob.hoverIntent_t = clearTimeout(ob.hoverIntent_t);\n            }\n\n            // if e.type == \"mouseenter\"\n            if (e.type == \"mouseenter\") {\n                // set \"previous\" X and Y position based on initial entry point\n                pX = ev.pageX;\n                pY = ev.pageY;\n                // update \"current\" X and Y position based on mousemove\n                $(ob).bind(\"mousemove\", track);\n                // start polling interval (self-calling timeout) to compare mouse coordinates over time\n                if (ob.hoverIntent_s != 1) {\n                    ob.hoverIntent_t = setTimeout(function () {\n                        compare(ev, ob);\n                    }, cfg.interval);\n                }\n\n                // else e.type == \"mouseleave\"\n            } else {\n                // unbind expensive mousemove event\n                $(ob).unbind(\"mousemove\", track);\n                // if hoverIntent state is true, then call the mouseOut function after the specified delay\n                if (ob.hoverIntent_s == 1) {\n                    ob.hoverIntent_t = setTimeout(function () {\n                        delay(ev, ob);\n                    }, cfg.timeout);\n                }\n            }\n        };\n\n        // bind the function to the two event listeners\n        return this.bind('mouseenter', handleHover).bind('mouseleave', handleHover);\n    };\n})(jQuery);"}
}});
