require.config({"config": {
        "jsbuild":{"Magento_Catalog/js/components/attributes-insert-listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'uiRegistry',\n    'underscore',\n    'Magento_Ui/js/form/components/insert-listing'\n], function ($, registry, _, InsertListing) {\n    'use strict';\n\n    return InsertListing.extend({\n        defaults: {\n            addAttributeUrl: '',\n            attributeSetId: '',\n            attributeIds: '',\n            groupCode: '',\n            groupName: '',\n            groupSortOrder: 0,\n            productId: 0,\n            formProvider: '',\n            modules: {\n                form: '${ $.formProvider }',\n                modal: '${ $.parentName }'\n            },\n            productType: ''\n        },\n\n        /**\n         * Render attribute\n         */\n        render: function () {\n            this._super();\n        },\n\n        /**\n         * Save attribute\n         */\n        save: function () {\n            this.addSelectedAttributes();\n            this._super();\n        },\n\n        /**\n         * Add selected attributes\n         */\n        addSelectedAttributes: function () {\n            $.ajax({\n                url: this.addAttributeUrl,\n                type: 'POST',\n                dataType: 'json',\n                data: {\n                    attributeIds: this.selections().getSelections(),\n                    templateId: this.attributeSetId,\n                    groupCode: this.groupCode,\n                    groupName: this.groupName,\n                    groupSortOrder: this.groupSortOrder,\n                    productId: this.productId,\n                    componentJson: 1\n                },\n                success: function () {\n                    this.form().params = {\n                        set: this.attributeSetId,\n                        id: this.productId,\n                        type: this.productType\n                    };\n                    this.form().reload();\n                    this.modal().state(false);\n                    this.reload();\n                }.bind(this)\n            });\n        }\n    });\n});\n","Magento_Catalog/js/components/dynamic-rows-import-custom-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid',\n    'underscore',\n    'mageUtils'\n], function (DynamicRows, _, utils) {\n    'use strict';\n\n    return DynamicRows.extend({\n        defaults: {\n            mappingSettings: {\n                enabled: false,\n                distinct: false\n            },\n            update: true,\n            map: {\n                'option_id': 'option_id'\n            },\n            identificationProperty: 'option_id',\n            identificationDRProperty: 'option_id'\n        },\n\n        /** @inheritdoc */\n        processingInsertData: function (data) {\n            var options = [],\n                currentOption,\n                generalContext = this;\n\n            if (!data) {\n                return;\n            }\n            _.each(data, function (item) {\n                if (!item.options) {\n                    return;\n                }\n                _.each(item.options, function (option) {\n                    currentOption = utils.copy(option);\n\n                    if (currentOption.hasOwnProperty('sort_order')) {\n                        delete currentOption['sort_order'];\n                    }\n\n                    if (currentOption.hasOwnProperty('option_id')) {\n                        delete currentOption['option_id'];\n                    }\n\n                    if (currentOption.values.length > 0) {\n                        generalContext.removeOptionsIds(currentOption.values);\n                    }\n                    options.push(currentOption);\n                });\n            });\n\n            if (!options.length) {\n                return;\n            }\n            this.cacheGridData = options;\n            _.each(options, function (opt) {\n                this.mappingValue(opt);\n            }, this);\n\n            this.insertData([]);\n        },\n\n        /**\n         * Removes option_id and option_type_id from every option\n         *\n         * @param {Array} options\n         */\n        removeOptionsIds: function (options) {\n            _.each(options, function (optionValue) {\n                delete optionValue['option_id'];\n                delete optionValue['option_type_id'];\n            });\n        },\n\n        /** @inheritdoc */\n        processingAddChild: function (ctx, index, prop) {\n            if (!ctx) {\n                this.showSpinner(true);\n                this.addChild(ctx, index, prop);\n\n                return;\n            }\n\n            this._super(ctx, index, prop);\n        },\n\n        /**\n         * Set empty array to dataProvider\n         */\n        clearDataProvider: function () {\n            this.source.set(this.dataProvider, []);\n        },\n\n        /**\n         * Mutes parent method\n         */\n        updateInsertData: function () {\n            return false;\n        }\n    });\n});\n","Magento_Catalog/js/components/disable-on-option/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'Magento_Catalog/js/components/disable-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/disable-on-option/input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_Catalog/js/components/disable-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/disable-on-option/yesno.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'Magento_Catalog/js/components/disable-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    var comp = Element.extend(strategy).extend({\n\n        defaults: {\n            listens: {\n                disabled: 'updateValueForDisabledField',\n                visible: 'updateValueForDisabledField'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super();\n            this.updateValueForDisabledField();\n\n            return this;\n        },\n\n        /**\n         * Set element value to O(No) if element is invisible and disabled\n         * Set element value to initialValue if element becomes visible and enable\n         */\n        updateValueForDisabledField: function () {\n            if (!this.disabled() && this.visible()) {\n                this.set('value', this.initialValue);\n            } else {\n                this.set('value', 0);\n            }\n        }\n    });\n\n    return comp.extend(strategy);\n});\n","Magento_Catalog/js/components/disable-on-option/strategy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function () {\n    'use strict';\n\n    return {\n        defaults: {\n            valuesForEnable: [],\n            disabled: true,\n            imports: {\n                toggleDisable:\n                    'product_attribute_add_form.product_attribute_add_form.base_fieldset.frontend_input:value'\n            }\n        },\n\n        /**\n         * Toggle disabled state.\n         *\n         * @param {Number} selected\n         */\n        toggleDisable: function (selected) {\n            this.disabled(!(selected in this.valuesForEnable));\n        }\n    };\n});\n","Magento_Catalog/js/components/use-parent-settings/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Component) {\n    'use strict';\n\n    return Component;\n});\n","Magento_Catalog/js/components/use-parent-settings/single-checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Component) {\n    'use strict';\n\n    return Component;\n});\n","Magento_Catalog/js/components/use-parent-settings/textarea.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/textarea'\n], function (Component) {\n    'use strict';\n\n    return Component;\n});\n","Magento_Catalog/js/components/use-parent-settings/toggle-disabled-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var mixin = {\n        defaults: {\n            imports: {\n                toggleDisabled: '${ $.parentName }.custom_use_parent_settings:checked'\n            },\n            useParent: false,\n            useDefaults: false\n        },\n\n        /**\n         * Disable form input if settings for parent section is used\n         * or default value is applied.\n         *\n         * @param {Boolean} isUseParent\n         */\n        toggleDisabled: function (isUseParent) {\n            var disabled = this.useParent = isUseParent;\n\n            if (!disabled && !_.isUndefined(this.service)) {\n                disabled = !!this.isUseDefault();\n            }\n\n            this.saveUseDefaults();\n            this.disabled(disabled);\n        },\n\n        /**\n         * Stores original state of the field.\n         */\n        saveUseDefaults: function () {\n            this.useDefaults = this.disabled();\n        },\n\n        /** @inheritdoc */\n        setInitialValue: function () {\n            this._super();\n            this.isUseDefault(this.useDefaults);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        toggleUseDefault: function (state) {\n            this._super();\n            this.disabled(state || this.useParent);\n        }\n    };\n\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n","Magento_Catalog/js/components/visible-on-option/fieldset.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Fieldset, strategy) {\n    'use strict';\n\n    return Fieldset.extend(strategy).extend(\n        {\n            defaults: {\n                openOnShow: true\n            },\n\n            /**\n             * Toggle visibility state.\n             */\n            toggleVisibility: function () {\n                this._super();\n\n                if (this.openOnShow) {\n                    this.opened(this.inverseVisibility ? !this.isShown : this.isShown);\n                }\n            }\n        }\n    );\n});\n","Magento_Catalog/js/components/visible-on-option/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/textarea.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/textarea',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/yesno.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/date',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/strategy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function () {\n    'use strict';\n\n    return {\n        defaults: {\n            valuesForOptions: [],\n            imports: {\n                toggleVisibility:\n                    'product_attribute_add_form.product_attribute_add_form.base_fieldset.frontend_input:value'\n            },\n            isShown: false,\n            inverseVisibility: false\n        },\n\n        /**\n         * Toggle visibility state.\n         *\n         * @param {Number} selected\n         */\n        toggleVisibility: function (selected) {\n            this.isShown = selected in this.valuesForOptions;\n            this.visible(this.inverseVisibility ? !this.isShown : this.isShown);\n        }\n    };\n});\n","Magento_Catalog/js/tier-price/percentage-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiElement',\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/async',\n    'Magento_Catalog/js/utils/percentage-price-calculator'\n], function (Element, _, $, percentagePriceCalculator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            priceElem: '${ $.parentName }.price',\n            selector: 'input',\n            imports: {\n                priceValue: '${ $.priceElem }:priceValue'\n            },\n            exports: {\n                calculatedVal: '${ $.priceElem }:value'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super();\n\n            _.bindAll(this, 'initPriceListener', 'onInput');\n\n            $.async({\n                component: this.priceElem,\n                selector: this.selector\n            }, this.initPriceListener);\n\n            return this;\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initObservable: function () {\n            return this._super()\n                .observe(['visible']);\n        },\n\n        /**\n         * Handles keyup event on price input.\n         *\n         * {@param} HTMLElement elem\n         */\n        initPriceListener: function (elem) {\n            $(elem).on('keyup.priceCalc', this.onInput);\n        },\n\n        /**\n         * Delegates calculation of the price input value to percentagePriceCalculator.\n         *\n         * {@param} object event\n         */\n        onInput: function (event) {\n            var value = event.currentTarget.value;\n\n            if (value.slice(-1) === '%') {\n                value = percentagePriceCalculator(this.priceValue, value);\n                this.set('calculatedVal', value);\n            }\n        }\n    });\n});\n","Magento_Catalog/js/tier-price/value-type-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'uiRegistry',\n    'underscore'\n], function (Select, uiRegistry, _) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            prices: {}\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super()\n                .prepareForm();\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        setInitialValue: function () {\n            this.initialValue = this.getInitialValue();\n\n            if (this.value.peek() !== this.initialValue) {\n                this.value(this.initialValue);\n            }\n\n            this.isUseDefault(this.disabled());\n\n            return this;\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        prepareForm: function () {\n            var elements = this.getElementsByPrices(),\n                prices = this.prices,\n                currencyType = _.keys(prices)[0],\n                select = this;\n\n            uiRegistry.get(elements, function () {\n                _.each(arguments, function (currentValue) {\n                    if (parseFloat(currentValue.value()) > 0) {\n                        _.each(prices, function (priceValue, priceKey) {\n                            if (priceValue === currentValue.name) {\n                                currencyType = priceKey;\n                            }\n                        });\n                    }\n                });\n                select.value(currencyType);\n                select.on('value', select.onUpdate.bind(select));\n                select.onUpdate();\n            });\n        },\n\n        /**\n         * @returns {Array}\n         */\n        getElementsByPrices: function () {\n            var elements = [];\n\n            _.each(this.prices, function (currentValue) {\n                elements.push(currentValue);\n            });\n\n            return elements;\n        },\n\n        /**\n         * Callback that fires when 'value' property is updated\n         */\n        onUpdate: function () {\n            var value = this.value(),\n                prices = this.prices,\n                select = this,\n                parentDataScopeArr = this.dataScope.split('.'),\n                parentDataScope,\n                elements = this.getElementsByPrices();\n\n            parentDataScopeArr.pop();\n            parentDataScope = parentDataScopeArr.join('.');\n\n            uiRegistry.get(elements, function () {\n                var sourceData = select.source.get(parentDataScope);\n\n                _.each(arguments, function (currentElement) {\n                    var index;\n\n                    _.each(prices, function (priceValue, priceKey) {\n                        if (priceValue === currentElement.name) {\n                            index = priceKey;\n                        }\n                    });\n\n                    if (value === index) {\n                        currentElement.visible(true);\n                        sourceData[currentElement.index] = currentElement.value();\n                    } else {\n                        currentElement.value('');\n                        currentElement.visible(false);\n                        delete sourceData[currentElement.index];\n                    }\n                });\n                select.source.set(parentDataScope, sourceData);\n            });\n        }\n    });\n});\n","Magento_Catalog/component/file-type-field.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if (value === 'file') {\n                this.disabled(false);\n                this.visible(true);\n\n                return true;\n            }\n\n            this.reset();\n            this.disabled(true);\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/component/image-size-field.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/lib/validation/utils',\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_Ui/js/lib/validation/validator',\n    'mage/translate'\n], function ($, utils, Abstract, validator) {\n    'use strict';\n\n    validator.addRule(\n        'validate-image-size-range',\n        function (value) {\n            var dataAttrRange = /^(\\d+)x(\\d+)$/,\n                m;\n\n            if (utils.isEmptyNoTrim(value)) {\n                return true;\n            }\n\n            m = dataAttrRange.exec(value);\n\n            return !!(m &&  m[1] > 0 && m[2] > 0);\n        },\n        $.mage.__('This value does not follow the specified format (for example, 200X300).')\n    );\n\n    return Abstract.extend({\n\n        /**\n         * Checks for relevant value\n         *\n         * @returns {Boolean}\n         */\n        isRangeCorrect: function () {\n            return validator('validate-image-size-range', this.value()).passed;\n        }\n    });\n});\n","Magento_Catalog/component/static-type-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/element/select'\n], function ($, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if (!value || $.inArray(value, ['drop_down', 'radio', 'checkbox', 'multiple']) !== -1) {\n                this.reset();\n                this.disabled(true);\n\n                return false;\n            }\n\n            this.disabled(false);\n\n            return true;\n        }\n    });\n});\n","Magento_Catalog/component/static-type-container.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/components/group'\n], function ($, Group) {\n    'use strict';\n\n    return Group.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if ($.inArray(value, ['field', 'area', 'file', 'date', 'date_time', 'time']) !== -1) {\n                this.visible(true);\n\n                return true;\n            }\n\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/component/text-type-field.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/element/abstract'\n], function ($, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks for relevant value\n         *\n         * @param {*} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if ($.inArray(value, ['field', 'area']) !== -1) {\n                this.disabled(false);\n                this.visible(true);\n\n                return true;\n            }\n\n            this.reset();\n            this.disabled(true);\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/component/select-type-grid.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows'\n], function ($, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if ($.inArray(value, ['drop_down', 'radio', 'checkbox', 'multiple']) !== -1) {\n                this.disabled(false);\n                this.visible(true);\n\n                return true;\n            }\n\n            this.reset();\n            this.disabled(true);\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/component/static-type-input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiRegistry',\n    'Magento_Ui/js/form/element/abstract'\n], function (registry, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            parentOption: null\n        },\n\n        /**\n         * Initialize component.\n         *\n         * @returns {Element}\n         */\n        initialize: function () {\n            return this\n                ._super()\n                .initLinkToParent();\n        },\n\n        /**\n         * Cache link to parent component - option holder.\n         *\n         * @returns {Element}\n         */\n        initLinkToParent: function () {\n            var pathToParent = this.parentName.replace(/(\\.[^.]*){2}$/, '');\n\n            this.parentOption = registry.async(pathToParent);\n            this.value() && this.parentOption('label', this.value());\n\n            return this;\n        },\n\n        /**\n         * On value change handler.\n         *\n         * @param {String} value\n         */\n        onUpdate: function (value) {\n            this.parentOption(function (component) {\n                component.set('label', value ? value : component.get('headerLabel'));\n            });\n\n            return this._super();\n        }\n    });\n});\n","Magento_Catalog/catalog/apply-to-type-switcher.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events'\n], function ($, productType) {\n    'use strict';\n\n    return {\n\n        /**\n         * Bind event\n         */\n        bindAll: function () {\n            $('[data-form=edit-product] [data-role=tabs]').on(\n                'contentUpdated',\n                this._switchToTypeByApplyAttr.bind(this)\n            );\n\n            $('#product_info_tabs').on(\n                'beforePanelsMove tabscreate tabsactivate',\n                this._switchToTypeByApplyAttr.bind(this)\n            );\n\n            $(document).on('changeTypeProduct', this._switchToTypeByApplyAttr.bind(this));\n        },\n\n        /**\n         * Constructor component\n         */\n        'Magento_Catalog/catalog/apply-to-type-switcher': function () {\n            this.bindAll();\n            this._switchToTypeByApplyAttr();\n        },\n\n        /**\n         * Show/hide elements based on type\n         *\n         * @private\n         */\n        _switchToTypeByApplyAttr: function () {\n            $('[data-apply-to]:not(.removed)').each(function (index, element) {\n                var attrContainer = $(element),\n                    applyTo = attrContainer.data('applyTo') || [],\n                    $inputs = attrContainer.find('select, input, textarea');\n\n                if (applyTo.length === 0 || $.inArray(productType.type.current, applyTo) !== -1) {\n                    attrContainer.removeClass('not-applicable-attribute');\n                    $inputs.removeClass('ignore-validate');\n                } else {\n                    attrContainer.addClass('not-applicable-attribute');\n                    $inputs.addClass('ignore-validate');\n                }\n            });\n        }\n    };\n});\n","Magento_Catalog/catalog/product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    window.Product = {};\n\n    /**\n     * @param {String} id\n     * @return {*|jQuery|HTMLElement}\n     */\n    function byId(id) {\n        return $('#' + id);\n    }\n\n    /**\n     * @param {String} fieldId\n     */\n    function disableFieldEditMode(fieldId) {\n        var field = byId(fieldId);\n\n        field.prop('disabled', true);\n\n        if (field.next().hasClass('addafter')) {\n            field.parent().addClass('_update-attributes-disabled');\n        }\n\n        if (byId(fieldId + '_hidden').length) {\n            byId(fieldId + '_hidden').prop('disabled', true);\n        }\n    }\n\n    /**\n     * @param {String} fieldId\n     */\n    function enableFieldEditMode(fieldId) {\n        var field = byId(fieldId);\n\n        field.prop('disabled', false);\n\n        if (field.parent().hasClass('_update-attributes-disabled')) {\n            field.parent().removeClass('_update-attributes-disabled');\n        }\n\n        if (byId(fieldId + '_hidden').length) {\n            byId(fieldId + '_hidden').prop('disabled', false);\n        }\n    }\n\n    /**\n     * @param {String} toogleIdentifier\n     * @param {String} fieldId\n     */\n    function toogleFieldEditMode(toogleIdentifier, fieldId) {\n        if ($(toogleIdentifier).is(':checked')) {\n            enableFieldEditMode(fieldId);\n        } else {\n            disableFieldEditMode(fieldId);\n        }\n    }\n\n    /**\n     * On complete disable.\n     */\n    function onCompleteDisableInited() {\n        var item;\n\n        $.each($('[data-disable]'), function () {\n            item = $(this).data('disable');\n            disableFieldEditMode(item);\n        });\n    }\n\n    /**\n     * @param {String} urlKey\n     */\n    function onUrlkeyChanged(urlKey) {\n        var hidden, chbx, oldValue;\n\n        urlKey = byId(urlKey);\n        hidden = urlKey.siblings('input[type=hidden]');\n        chbx = urlKey.siblings('input[type=checkbox]');\n        oldValue = chbx.val();\n\n        chbx.prop('disabled', oldValue === urlKey.val());\n        hidden.prop('disabled', chbx.prop('disabled'));\n    }\n\n    /**\n     * @param {HTMLElement} element\n     */\n    function onCustomUseParentChanged(element) {\n        var useParent, parent;\n\n        element = $(element);\n        useParent = element.val() == 1; //eslint-disable-line eqeqeq\n        parent = element.offsetParent().parent();\n\n        parent.find('input, select, textarea').each(function (i, el) {\n            el = $(el);\n\n            if (element.prop('id') !== el.prop('id')) {\n                el.prop('disabled', useParent);\n            }\n        });\n\n        parent.find('img').each(function (i, el) {\n            if (useParent) {\n                $(el).hide();\n            } else {\n                $(el).show();\n            }\n        });\n    }\n\n    window.onCustomUseParentChanged = onCustomUseParentChanged;\n    window.onUrlkeyChanged = onUrlkeyChanged;\n    window.toogleFieldEditMode = toogleFieldEditMode;\n\n    $(onCompleteDisableInited);\n});\n","Magento_Catalog/catalog/type-events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return {\n        $type: $('#product_type_id'),\n\n        /**\n         * Init\n         */\n        init: function () {\n            this.type = {\n                init: this.$type.val(),\n                current: this.$type.val()\n            };\n\n            this.bindAll();\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            $(document).on('setTypeProduct', function (event, type) {\n                this.setType(type);\n            }.bind(this));\n\n            //direct change type input\n            this.$type.on('change', function () {\n                this.type.current = this.$type.val();\n                this._notifyType();\n            }.bind(this));\n        },\n\n        /**\n         * Set type\n         * @param {String} type - type product (downloadable, simple, virtual ...)\n         * @returns {*}\n         */\n        setType: function (type) {\n            return this.$type.val(type || this.type.init).trigger('change');\n        },\n\n        /**\n         * Notify type\n         * @private\n         */\n        _notifyType: function () {\n            $(document).trigger('changeTypeProduct', this.type);\n        }\n    };\n});\n","Magento_Catalog/catalog/base-image-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*global alert:true*/\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'jquery/file-uploader',\n    'mage/translate',\n    'mage/backend/notification'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.baseImage', {\n        /**\n         * Button creation\n         * @protected\n         */\n        options: {\n            maxImageUploadCount: 10\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var $container = this.element,\n                imageTmpl = mageTemplate(this.element.find('[data-template=image]').html()),\n                $dropPlaceholder = this.element.find('.image-placeholder'),\n                $galleryContainer = $('#media_gallery_content'),\n                mainClass = 'base-image',\n                maximumImageCount = 5,\n                $fieldCheckBox = $container.closest('[data-attribute-code=image]').find(':checkbox'),\n                isDefaultChecked = $fieldCheckBox.is(':checked'),\n                findElement, updateVisibility;\n\n            if (isDefaultChecked) {\n                $fieldCheckBox.trigger('click');\n            }\n\n            /**\n             * @param {Object} data\n             * @return {HTMLElement}\n             */\n            findElement = function (data) {\n                return $container.find('.image:not(.image-placeholder)').filter(function () {\n                    if (!$(this).data('image')) {\n                        return false;\n                    }\n\n                    return $(this).data('image').file === data.file;\n                }).first();\n            };\n\n            /** Update image visibility. */\n            updateVisibility = function () {\n                var elementsList = $container.find('.image:not(.removed-item)');\n\n                elementsList.each(function (index) {\n                    $(this)[index < maximumImageCount ? 'show' : 'hide']();\n                });\n                $dropPlaceholder[elementsList.length > maximumImageCount ? 'hide' : 'show']();\n            };\n\n            $galleryContainer.on('setImageType', function (event, data) {\n                if (data.type === 'image') {\n                    $container.find('.' + mainClass).removeClass(mainClass);\n\n                    if (data.imageData) {\n                        findElement(data.imageData).addClass(mainClass);\n                    }\n                }\n            });\n\n            $galleryContainer.on('addItem', function (event, data) {\n                var tmpl = imageTmpl({\n                    data: data\n                });\n\n                $(tmpl).data('image', data).insertBefore($dropPlaceholder);\n\n                updateVisibility();\n            });\n\n            $galleryContainer.on('removeItem', function (event, image) {\n                findElement(image).addClass('removed-item').hide();\n                updateVisibility();\n            });\n\n            $galleryContainer.on('moveElement', function (event, data) {\n                var $element = findElement(data.imageData),\n                    $after;\n\n                if (data.position === 0) {\n                    $container.prepend($element);\n                } else {\n                    $after = $container.find('.image').eq(data.position);\n\n                    if (!$element.is($after)) {\n                        $element.insertAfter($after);\n                    }\n                }\n                updateVisibility();\n            });\n\n            $container.on('click', '[data-role=make-base-button]', function (event) {\n                var data;\n\n                event.preventDefault();\n                data = $(event.target).closest('.image').data('image');\n                $galleryContainer.productGallery('setBase', data);\n            });\n\n            $container.on('click', '[data-role=delete-button]', function (event) {\n                event.preventDefault();\n                $galleryContainer.trigger('removeItem', $(event.target).closest('.image').data('image'));\n            });\n\n            $container.sortable({\n                axis: 'x',\n                items: '.image:not(.image-placeholder)',\n                distance: 8,\n                tolerance: 'pointer',\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {Object} data\n                 */\n                stop: function (event, data) {\n                    $galleryContainer.trigger('setPosition', {\n                        imageData: data.item.data('image'),\n                        position: $container.find('.image').index(data.item)\n                    });\n                    $galleryContainer.trigger('resort');\n                }\n            }).disableSelection();\n\n            this.element.find('input[type=\"file\"]').fileupload({\n                dataType: 'json',\n                dropZone: $dropPlaceholder.closest('[data-attribute-code]'),\n                acceptFileTypes: /(\\.|\\/)(gif|jpe?g|png)$/i,\n                maxFileSize: this.element.data('maxFileSize'),\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {Object} data\n                 */\n                done: function (event, data) {\n                    $dropPlaceholder.find('.progress-bar').text('').removeClass('in-progress');\n\n                    if (!data.result) {\n                        return;\n                    }\n\n                    if (!data.result.error) {\n                        $galleryContainer.trigger('addItem', data.result);\n                    } else {\n                        alert({\n                            content: $.mage.__('We don\\'t recognize or support this file extension type.')\n                        });\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} data\n                 */\n                change: function (e, data) {\n                    if (data.files.length > this.options.maxImageUploadCount) {\n                        $('body').notification('clear').notification('add', {\n                            error: true,\n                            message: $.mage.__('You can\\'t upload more than ' + this.options.maxImageUploadCount +\n                                ' images in one time'),\n\n                            /**\n                             * @param {*} message\n                             */\n                            insertMethod: function (message) {\n                                $('.page-main-actions').after(message);\n                            }\n                        });\n\n                        return false;\n                    }\n                }.bind(this),\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {*} data\n                 */\n                add: function (event, data) {\n                    $(this).fileupload('process', data).done(function () {\n                        data.submit();\n                    });\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} data\n                 */\n                progress: function (e, data) {\n                    var progress = parseInt(data.loaded / data.total * 100, 10);\n\n                    $dropPlaceholder.find('.progress-bar').addClass('in-progress').text(progress + '%');\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                start: function (event) {\n                    var uploaderContainer = $(event.target).closest('.image-placeholder');\n\n                    uploaderContainer.addClass('loading');\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                stop: function (event) {\n                    var uploaderContainer = $(event.target).closest('.image-placeholder');\n\n                    uploaderContainer.removeClass('loading');\n                }\n            });\n        }\n    });\n\n    return $.mage.baseImage;\n});\n","Magento_Catalog/catalog/product-attributes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    'jquery/ui',\n    'mage/translate'\n], function ($, _, registry) {\n    'use strict';\n\n    $.widget('mage.productAttributes', {\n        /** @inheritdoc */\n        _create: function () {\n            this._on({\n                'click': '_showPopup'\n            });\n        },\n\n        /**\n         * @private\n         */\n        _initModal: function () {\n            var self = this;\n\n            this.modal = $('<div id=\"create_new_attribute\"/>').modal({\n                title: $.mage.__('New Attribute'),\n                type: 'slide',\n                buttons: [],\n\n                /** @inheritdoc */\n                opened: function () {\n                    $(this).parent().addClass('modal-content-new-attribute');\n                    self.iframe = $('<iframe id=\"create_new_attribute_container\">').attr({\n                        src: self._prepareUrl(),\n                        frameborder: 0\n                    });\n                    self.modal.append(self.iframe);\n                    self._changeIframeSize();\n                    $(window).off().on('resize.modal', _.debounce(self._changeIframeSize.bind(self), 400));\n                },\n\n                /** @inheritdoc */\n                closed: function () {\n                    var doc = self.iframe.get(0).document;\n\n                    if (doc && $.isFunction(doc.execCommand)) {\n                        //IE9 break script loading but not execution on iframe removing\n                        doc.execCommand('stop');\n                        self.iframe.remove();\n                    }\n                    self.modal.data('modal').modal.remove();\n                    $(window).off('resize.modal');\n                }\n            });\n        },\n\n        /**\n         * @return {Number}\n         * @private\n         */\n        _getHeight: function () {\n            var modal = this.modal.data('modal').modal,\n                modalHead = modal.find('header'),\n                modalHeadHeight = modalHead.outerHeight(),\n                modalHeight = modal.outerHeight(),\n                modalContentPadding = this.modal.parent().outerHeight() - this.modal.parent().height();\n\n            return modalHeight - modalHeadHeight - modalContentPadding;\n        },\n\n        /**\n         * @return {Number}\n         * @private\n         */\n        _getWidth: function () {\n            return this.modal.width();\n        },\n\n        /**\n         * @private\n         */\n        _changeIframeSize: function () {\n            this.modal.parent().outerHeight(this._getHeight());\n            this.iframe.outerHeight(this._getHeight());\n            this.iframe.outerWidth(this._getWidth());\n\n        },\n\n        /**\n         * @return {String}\n         * @private\n         */\n        _prepareUrl: function () {\n            var productSource,\n                attributeSetId = '';\n\n            if (this.options.dataProvider) {\n                try {\n                    productSource = registry.get(this.options.dataProvider);\n                    attributeSetId = productSource.data.product['attribute_set_id'];\n                } catch (e) {}\n            }\n\n            return this.options.url +\n                (/\\?/.test(this.options.url) ? '&' : '?') +\n                'set=' + attributeSetId;\n        },\n\n        /**\n         * @private\n         */\n        _showPopup: function () {\n            this._initModal();\n            this.modal.modal('openModal');\n        }\n    });\n\n    return $.mage.productAttributes;\n});\n","Magento_Catalog/catalog/category/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert'\n], function ($, alert) {\n    'use strict';\n\n    return function (config) {\n        var categoryForm = {\n            options: {\n                categoryIdSelector: 'input[name=\"id\"]',\n                categoryPathSelector: 'input[name=\"path\"]',\n                categoryParentSelector: 'input[name=\"parent\"]',\n                categoryLevelSelector: 'input[name=\"level\"]',\n                refreshUrl: config.refreshUrl\n            },\n\n            /**\n             * Sending ajax to server to refresh field 'path'\n             * @protected\n             */\n            refreshPath: function () {\n                if (!$(this.options.categoryIdSelector)) {\n                    return false;\n                }\n                $.ajax({\n                    url: this.options.refreshUrl,\n                    method: 'GET',\n                    showLoader: true\n                }).done(this._refreshPathSuccess.bind(this));\n            },\n\n            /**\n             * Refresh field 'path' on ajax success\n             * @param {Object} data\n             * @private\n             */\n            _refreshPathSuccess: function (data) {\n                if (data.error) {\n                    alert({\n                        content: data.message\n                    });\n                } else {\n                    $(this.options.categoryIdSelector).val(data.id).change();\n                    $(this.options.categoryPathSelector).val(data.path).change();\n                    $(this.options.categoryParentSelector).val(data.parentId).change();\n                    $(this.options.categoryLevelSelector).val(data.level).change();\n                }\n            }\n        };\n\n        $('body').on('categoryMove.tree', $.proxy(categoryForm.refreshPath.bind(categoryForm), this));\n    };\n});\n","Magento_Catalog/catalog/category/assign-products.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global $, $H */\n\ndefine([\n    'mage/adminhtml/grid'\n], function () {\n    'use strict';\n\n    return function (config) {\n        var selectedProducts = config.selectedProducts,\n            categoryProducts = $H(selectedProducts),\n            gridJsObject = window[config.gridJsObjectName],\n            tabIndex = 1000;\n\n        $('in_category_products').value = Object.toJSON(categoryProducts);\n\n        /**\n         * Register Category Product\n         *\n         * @param {Object} grid\n         * @param {Object} element\n         * @param {Boolean} checked\n         */\n        function registerCategoryProduct(grid, element, checked) {\n            if (checked) {\n                if (element.positionElement) {\n                    element.positionElement.disabled = false;\n                    categoryProducts.set(element.value, element.positionElement.value);\n                }\n            } else {\n                if (element.positionElement) {\n                    element.positionElement.disabled = true;\n                }\n                categoryProducts.unset(element.value);\n            }\n            $('in_category_products').value = Object.toJSON(categoryProducts);\n            grid.reloadParams = {\n                'selected_products[]': categoryProducts.keys()\n            };\n        }\n\n        /**\n         * Click on product row\n         *\n         * @param {Object} grid\n         * @param {String} event\n         */\n        function categoryProductRowClick(grid, event) {\n            var trElement = Event.findElement(event, 'tr'),\n                isInput = Event.element(event).tagName === 'INPUT',\n                checked = false,\n                checkbox = null;\n\n            if (trElement) {\n                checkbox = Element.getElementsBySelector(trElement, 'input');\n\n                if (checkbox[0]) {\n                    checked = isInput ? checkbox[0].checked : !checkbox[0].checked;\n                    gridJsObject.setCheckboxChecked(checkbox[0], checked);\n                }\n            }\n        }\n\n        /**\n         * Change product position\n         *\n         * @param {String} event\n         */\n        function positionChange(event) {\n            var element = Event.element(event);\n\n            if (element && element.checkboxElement && element.checkboxElement.checked) {\n                categoryProducts.set(element.checkboxElement.value, element.value);\n                $('in_category_products').value = Object.toJSON(categoryProducts);\n            }\n        }\n\n        /**\n         * Initialize category product row\n         *\n         * @param {Object} grid\n         * @param {String} row\n         */\n        function categoryProductRowInit(grid, row) {\n            var checkbox = $(row).getElementsByClassName('checkbox')[0],\n                position = $(row).getElementsByClassName('input-text')[0];\n\n            if (checkbox && position) {\n                checkbox.positionElement = position;\n                position.checkboxElement = checkbox;\n                position.disabled = !checkbox.checked;\n                position.tabIndex = tabIndex++;\n                Event.observe(position, 'keyup', positionChange);\n            }\n        }\n\n        gridJsObject.rowClickCallback = categoryProductRowClick;\n        gridJsObject.initRowCallback = categoryProductRowInit;\n        gridJsObject.checkboxCheckCallback = registerCategoryProduct;\n\n        if (gridJsObject.rows) {\n            gridJsObject.rows.each(function (row) {\n                categoryProductRowInit(gridJsObject, row);\n            });\n        }\n    };\n});\n","Magento_Catalog/catalog/category/edit.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Create/edit some category\n * @deprecated since version 2.2.0\n */\n\n/* global tree */\ndefine([\n    'jquery',\n    'prototype'\n], function (jQuery) {\n    'use strict';\n\n    /** Category submit. */\n    var categorySubmit = function () {\n        var activeTab = $('active_tab_id'),\n            params = {},\n            fields, i,categoryId, isCreating, path, parentId, currentNode, oldClass, newClass;\n\n        if (activeTab) {\n            if (activeTab.tabsJsObject && activeTab.tabsJsObject.tabs('activeAnchor')) {\n                activeTab.value = activeTab.tabsJsObject.tabs('activeAnchor').prop('id');\n            }\n        }\n\n        fields = $('category_edit_form').getElementsBySelector('input', 'select');\n\n        for (i = 0; i < fields.length; i++) {\n            if (!fields[i].name) {\n                continue;//jscs:ignore\n            }\n            params[fields[i].name] = fields[i].getValue();\n        }\n\n        // Get info about what we're submitting - to properly update tree nodes\n        categoryId = params['general[id]'] ? params['general[id]'] : 0;\n        isCreating = categoryId == 0; // eslint-disable-line eqeqeq\n        path = params['general[path]'].split('/');\n        parentId = path.pop();\n\n        if (parentId == categoryId) { // eslint-disable-line eqeqeq\n            parentId = path.pop();\n        }\n\n        // Make operations with category tree\n        if (isCreating) {\n            /* Some specific tasks for creating category */\n            if (!tree.currentNodeId) {\n                // First submit of form - select some node to be current\n                tree.currentNodeId = parentId;\n            }\n            tree.addNodeTo = parentId;\n        } else {\n            /* Some specific tasks for editing category */\n            // Maybe change category enabled/disabled style\n            if (tree && tree.storeId == 0) {// eslint-disable-line eqeqeq, no-lonely-if\n                currentNode = tree.getNodeById(categoryId);\n\n                if (currentNode) {//eslint-disable-line max-depth\n                    if (parseInt(params['general[is_active]'])) {//eslint-disable-line radix, max-depth\n                        oldClass = 'no-active-category';\n                        newClass = 'active-category';\n                    } else {\n                        oldClass = 'active-category';\n                        newClass = 'no-active-category';\n                    }\n\n                    Element.removeClassName(currentNode.ui.wrap.firstChild, oldClass);\n                    Element.addClassName(currentNode.ui.wrap.firstChild, newClass);\n                }\n            }\n        }\n\n        // Submit form\n        jQuery('#category_edit_form').trigger('submit');\n    };\n\n    return function (config, element) {\n        config = config || {};\n        jQuery(element).on('click', function () {\n            categorySubmit();\n        });\n    };\n});\n","Magento_Catalog/catalog/product/composite/configure.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/lib/view/utils/async',\n    'jquery/ui',\n    'mage/translate',\n    'prototype',\n    'Magento_Ui/js/modal/modal'\n], function (jQuery) {\n\n    window.ProductConfigure = Class.create();\n\n    ProductConfigure.prototype = {\n\n        listTypes:                  $H({}),\n        current:                    $H({}),\n        itemsFilter:                $H({}),\n        blockWindow:                null,\n        blockForm:                  null,\n        blockFormFields:            null,\n        blockFormAdd:               null,\n        blockFormConfirmed:         null,\n        blockConfirmed:             null,\n        blockIFrame:                null,\n        blockCancelBtn:             null,\n        blockMask:                  null,\n        blockMsg:                   null,\n        blockMsgError:              null,\n        windowHeight:               null,\n        confirmedCurrentId:         null,\n        confirmCallback:            {},\n        cancelCallback:             {},\n        onLoadIFrameCallback:       {},\n        showWindowCallback:         {},\n        beforeSubmitCallback:       {},\n        iFrameJSVarname:            null,\n        _listTypeId:                1,\n\n        /**\n         * Initialize object\n         */\n        initialize: function () {\n            var self = this;\n\n            this._initWindowElements();\n            jQuery.async('#product_composite_configure', function (el) {\n                self.dialog = jQuery(el).modal({\n                    title: jQuery.mage.__('Configure Product'),\n                    type: 'slide',\n                    buttons: [{\n                        text: jQuery.mage.__('OK'),\n                        'class': 'action-primary',\n                        click: function () {\n                            self.onConfirmBtn();\n                        }\n                    }]\n                });\n            });\n        },\n\n        /**\n         * Initialize window elements\n         */\n        _initWindowElements: function () {\n            this.blockWindow                = $('product_composite_configure');\n            this.blockForm                  = $('product_composite_configure_form');\n            this.blockFormFields            = $('product_composite_configure_form_fields');\n            this.blockFormAdd               = $('product_composite_configure_form_additional');\n            this.blockFormConfirmed         = $('product_composite_configure_form_confirmed');\n            this.blockConfirmed             = $('product_composite_configure_confirmed');\n            this.blockIFrame                = $('product_composite_configure_iframe');\n            this.blockCancelBtn             = $('product_composite_configure_form_cancel');\n            this.blockMsg                   = $('product_composite_configure_messages');\n            this.blockMsgError              = this.blockMsg.select('.message.error div')[0];\n            this.iFrameJSVarname            = this.blockForm.select('input[name=\"as_js_varname\"]')[0].value;\n        },\n\n        /**\n         * Returns next unique list type id\n         */\n        _generateListTypeId: function () {\n            return '_internal_lt_' + this._listTypeId++;\n        },\n\n        /**\n         * Add product list types as scope and their urls\n         * example: addListType('product_to_add', {urlFetch: 'http://magento...'})\n         * example: addListType('wishlist', {urlSubmit: 'http://magento...'})\n         *\n         * @param type types as scope\n         * @param urls obj can be\n         *             - {urlFetch: 'http://magento...'} for fetching configuration fields through ajax\n         *             - {urlConfirm: 'http://magento...'} for submit configured data through iFrame when clicked confirm button\n         *             - {urlSubmit: 'http://magento...'} for submit configured data through iFrame\n         */\n        addListType: function (type, urls) {\n            if ('undefined' == typeof this.listTypes[type]) {\n                this.listTypes[type] = {};\n            }\n            Object.extend(this.listTypes[type], urls);\n\n            return this;\n        },\n\n        /**\n         * Adds complex list type - that is used to submit several list types at once\n         * Only urlSubmit is possible for this list type\n         * example: addComplexListType(['wishlist', 'product_list'], 'http://magento...')\n         *\n         * @param type types as scope\n         * @param urls obj can be\n         *             - {urlSubmit: 'http://magento...'} for submit configured data through iFrame\n         * @return type string\n         */\n        addComplexListType: function (types, urlSubmit) {\n            var type = this._generateListTypeId();\n\n            this.listTypes[type] = {};\n            this.listTypes[type].complexTypes = types;\n            this.listTypes[type].urlSubmit = urlSubmit;\n\n            return type;\n        },\n\n        /**\n         * Add filter of items\n         *\n         * @param listType scope name\n         * @param itemsFilter\n         */\n        addItemsFilter: function (listType, itemsFilter) {\n            if (!listType || !itemsFilter) {\n                return false;\n            }\n\n            if ('undefined' == typeof this.itemsFilter[listType]) {\n                this.itemsFilter[listType] = [];\n            }\n            this.itemsFilter[listType] = this.itemsFilter[listType].concat(itemsFilter);\n\n            return this;\n        },\n\n        /**\n         * Returns id of block where configuration for an item is stored\n         *\n         * @param listType scope name\n         * @param itemId\n         * @return string\n         */\n        _getConfirmedBlockId: function (listType, itemId) {\n            return this.blockConfirmed.id + '[' + listType + '][' + itemId + ']';\n        },\n\n        /**\n         * Checks whether item has some configuration fields\n         *\n         * @param listType scope name\n         * @param itemId\n         * @return bool\n         */\n        itemConfigured: function (listType, itemId) {\n            var confirmedBlockId = this._getConfirmedBlockId(listType, itemId);\n            var itemBlock = $(confirmedBlockId);\n\n            return !!(itemBlock && itemBlock.innerHTML);\n        },\n\n        /**\n         * Show configuration fields of item, if it not found then get it through ajax\n         *\n         * @param listType scope name\n         * @param itemId\n         */\n        showItemConfiguration: function (listType, itemId) {\n            if (!listType || !itemId) {\n                return false;\n            }\n\n            this.initialize();\n            this.current.listType = listType;\n            this.current.itemId = itemId;\n            this.confirmedCurrentId = this._getConfirmedBlockId(listType, itemId);\n\n            if (!this.itemConfigured(listType, itemId)) {\n                this._requestItemConfiguration(listType, itemId);\n            } else {\n                this._processFieldsData('item_restore');\n                this._showWindow();\n            }\n        },\n\n        /**\n         * Get configuration fields of product through ajax and show them\n         *\n         * @param listType scope name\n         * @param itemId\n         */\n        _requestItemConfiguration: function (listType, itemId) {\n            if (!this.listTypes[listType].urlFetch) {\n                return false;\n            }\n            var url = this.listTypes[listType].urlFetch;\n\n            if (url) {\n                new Ajax.Request(url, {\n                    parameters: {\n                        id: itemId\n                    },\n                    onSuccess: function (transport) {\n                        var response = transport.responseText;\n\n                        if (response.isJSON()) {\n                            response = response.evalJSON();\n\n                            if (response.error) {\n                                this.blockMsg.show();\n                                this.blockMsgError.innerHTML = response.message;\n                                this.blockCancelBtn.hide();\n                                this.setConfirmCallback(listType, null);\n                                this._showWindow();\n                            }\n                        } else if (response) {\n                            response += '';\n                            this.blockFormFields.update(response);\n\n                            // Add special div to hold mage data, e.g. scripts to execute on every popup show\n                            var mageData = {};\n                            var scripts = response.extractScripts();\n\n                            mageData.scripts = scripts;\n\n                            var scriptHolder = new Element('div', {\n                                'style': 'display:none'\n                            });\n\n                            scriptHolder.mageData = mageData;\n                            this.blockFormFields.insert(scriptHolder);\n\n                            // Show window\n                            this._showWindow();\n                        }\n                    }.bind(this)\n                });\n            }\n        },\n\n        /**\n         * Triggered on confirm button click\n         * Do submit configured data through iFrame if needed\n         */\n        onConfirmBtn: function () {\n            if (jQuery(this.blockForm).valid()) {\n                if (this.listTypes[this.current.listType].urlConfirm) {\n                    this.submit();\n                } else {\n                    this._processFieldsData('item_confirm');\n                    this._closeWindow();\n\n                    if (Object.isFunction(this.confirmCallback[this.current.listType])) {\n                        this.confirmCallback[this.current.listType]();\n                    }\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Triggered on cancel button click\n         */\n        onCancelBtn: function () {\n            this._closeWindow();\n\n            if (Object.isFunction(this.cancelCallback[this.current.listType])) {\n                this.cancelCallback[this.current.listType]();\n            }\n\n            return this;\n        },\n\n        /**\n         * Submit configured data through iFrame\n         *\n         * @param listType scope name\n         */\n        submit: function (listType) {\n            // prepare data\n            if (listType) {\n                this.current.listType = listType;\n                this.current.itemId = null;\n            }\n            var urlConfirm = this.listTypes[this.current.listType].urlConfirm;\n            var urlSubmit = this.listTypes[this.current.listType].urlSubmit;\n\n            if (!urlConfirm && !urlSubmit) {\n                return false;\n            }\n\n            if (urlConfirm) {\n                this.blockForm.action = urlConfirm;\n                this.addFields([new Element('input', {\n                    type: 'hidden', name: 'id', value: this.current.itemId\n                })]);\n            } else {\n                this.blockForm.action = urlSubmit;\n\n                var complexTypes = this.listTypes[this.current.listType].complexTypes;\n\n                if (complexTypes) {\n                    this.addFields([new Element('input', {\n                        type: 'hidden', name: 'configure_complex_list_types', value: complexTypes.join(',')\n                    })]);\n                }\n\n                this._processFieldsData('current_confirmed_to_form');\n\n                // Disable item controls that duplicate added fields (e.g. sometimes qty controls can intersect)\n                // so they won't be submitted\n                var tagNames = ['input', 'select', 'textarea'];\n\n                var names = {}; // Map of added field names\n\n                for (var i = 0, len = tagNames.length; i < len; i++) {\n                    var tagName = tagNames[i];\n                    var elements = this.blockFormAdd.getElementsByTagName(tagName);\n\n                    for (var index = 0, elLen = elements.length; index < elLen; index++) {\n                        names[elements[index].name] = true;\n                    }\n                }\n\n                for (var i = 0, len = tagNames.length; i < len; i++) {\n                    var tagName = tagNames[i];\n                    var elements = this.blockFormConfirmed.getElementsByTagName(tagName);\n\n                    for (var index = 0, elLen = elements.length; index < elLen; index++) {\n                        var element = elements[index];\n\n                        if (names[element.name]) {\n                            element.setAttribute('configure_disabled', 1);\n                            element.setAttribute('configure_prev_disabled', element.disabled ? 1 : 0);\n                            element.disabled = true;\n                        } else {\n                            element.setAttribute('configure_disabled', 0);\n                        }\n                    }\n                }\n            }\n            // do submit\n            if (Object.isFunction(this.beforeSubmitCallback[this.current.listType])) {\n                this.beforeSubmitCallback[this.current.listType]();\n            }\n            this.blockForm.submit();\n\n            // Show loader\n            jQuery(this.blockForm).trigger('processStart');\n\n            return this;\n        },\n\n        /**\n         * Add dynamically additional fields for form\n         *\n         * @param fields\n         */\n        addFields: function (fields) {\n            fields.each(function (elm) {\n                this.blockFormAdd.insert(elm);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Triggered when form was submitted and iFrame was loaded. Get response from iFrame and handle it\n         */\n        onLoadIFrame: function () {\n            this.blockFormConfirmed.select('[configure_disabled=1]').each(function (element) {\n                element.disabled = element.getAttribute('configure_prev_disabled') == '1';\n            });\n\n            this._processFieldsData('form_confirmed_to_confirmed');\n\n            var response = this.blockIFrame.contentWindow[this.iFrameJSVarname];\n\n            if (response && 'object' == typeof response) {\n                if (this.listTypes[this.current.listType].urlConfirm) {\n                    if (response.ok) {\n                        this._closeWindow();\n                        this.clean('current');\n                    } else if (response.error) {\n                        this.showItemConfiguration(this.current.listType, this.current.itemId);\n                        this.blockMsg.show();\n                        this.blockMsgError.innerHTML = response.message;\n                        this._showWindow();\n\n                        return false;\n                    }\n                }\n\n                if (Object.isFunction(this.onLoadIFrameCallback[this.current.listType])) {\n                    this.onLoadIFrameCallback[this.current.listType](response);\n                }\n                document.fire(this.current.listType + ':afterIFrameLoaded');\n            }\n            // Hide loader\n            jQuery(this.blockForm).trigger('processStop');\n\n            this.clean('current');\n            this.initialize();\n        },\n\n        /**\n         * Helper for fetching content from iFrame\n         */\n        _getIFrameContent: function () {\n            var content = this.blockIFrame.contentWindow || this.blockIFrame.contentDocument;\n\n            if (content.document) {\n                content = content.document;\n            }\n\n            return content;\n        },\n\n        /**\n         * Helper to find qty of currently confirmed item\n         */\n        getCurrentConfirmedQtyElement: function () {\n            var elms = $(this.confirmedCurrentId).getElementsByTagName('input');\n\n            for (var i = 0; i < elms.length; i++) {\n                if (elms[i].name == 'qty') {\n                    return elms[i];\n                }\n            }\n        },\n\n        /**\n         * Helper to find qty of active form\n         */\n        getCurrentFormQtyElement: function () {\n            var elms = this.blockFormFields.getElementsByTagName('input');\n\n            for (var i = 0; i < elms.length; i++) {\n                if (elms[i].name == 'qty') {\n                    return elms[i];\n                }\n            }\n        },\n\n        /**\n         * Show configuration window\n         */\n        _showWindow: function () {\n            this.dialog.modal('openModal');\n            //this._toggleSelectsExceptBlock(false);\n\n            if (Object.isFunction(this.showWindowCallback[this.current.listType])) {\n                this.showWindowCallback[this.current.listType]();\n            }\n        },\n\n        /**\n         * Close configuration window\n         */\n        _closeWindow: function () {\n            this.dialog.modal('closeModal');\n            //this.blockWindow.style.display = 'none';\n            //this.clean('window');\n        },\n\n        /**\n         * Attach callback function triggered when confirm button was clicked\n         *\n         * @param confirmCallback\n         */\n        setConfirmCallback: function (listType, confirmCallback) {\n            this.confirmCallback[listType] = confirmCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered when cancel button was clicked\n         *\n         * @param cancelCallback\n         */\n        setCancelCallback: function (listType, cancelCallback) {\n            this.cancelCallback[listType] = cancelCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered when iFrame was loaded\n         *\n         * @param onLoadIFrameCallback\n         */\n        setOnLoadIFrameCallback: function (listType, onLoadIFrameCallback) {\n            this.onLoadIFrameCallback[listType] = onLoadIFrameCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered when iFrame was loaded\n         *\n         * @param showWindowCallback\n         */\n        setShowWindowCallback: function (listType, showWindowCallback) {\n            this.showWindowCallback[listType] = showWindowCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered before submitting form\n         *\n         * @param beforeSubmitCallback\n         */\n        setBeforeSubmitCallback: function (listType, beforeSubmitCallback) {\n            this.beforeSubmitCallback[listType] = beforeSubmitCallback;\n\n            return this;\n        },\n\n        /**\n         * Clean object data\n         *\n         * @param method can be 'all' or 'current'\n         */\n        clean: function (method) {\n            var listInfo = null;\n            var listTypes = null;\n            var removeConfirmed = function (listTypes) {\n                this.blockConfirmed.childElements().each(function (elm) {\n                    for (var i = 0, len = listTypes.length; i < len; i++) {\n                        var pattern = this.blockConfirmed.id + '[' + listTypes[i] + ']';\n\n                        if (elm.id.indexOf(pattern) == 0) {\n                            elm.remove();\n                            break;\n                        }\n                    }\n                }.bind(this));\n            }.bind(this);\n\n            switch (method) {\n                case 'current':\n                    listInfo = this.listTypes[this.current.listType];\n                    listTypes = [this.current.listType];\n\n                    if (listInfo && listInfo.complexTypes) {\n                        listTypes = listTypes.concat(listInfo.complexTypes);\n                    }\n                    removeConfirmed(listTypes);\n                    break;\n\n                case 'window':\n                    this.blockFormFields.update();\n                    this.blockMsg.hide();\n                    this.blockMsgError.update();\n                    this.blockCancelBtn.show();\n                    break;\n                default:\n                    // search in list types for its cleaning\n                    if (this.listTypes[method]) {\n                        listInfo = this.listTypes[method];\n                        listTypes = [method];\n\n                        if (listInfo.complexTypes) {\n                            listTypes = listTypes.concat(listInfo.complexTypes);\n                        }\n                        removeConfirmed(listTypes);\n                        // clean all\n                    } else if (!method) {\n                        this.current = $H({});\n                        this.blockConfirmed.update();\n                        this.blockFormFields.update();\n                        this.blockMsg.hide();\n                        this.blockMsgError.update();\n                        this.blockCancelBtn.show();\n                    }\n                    break;\n            }\n            this._getIFrameContent().body.innerHTML = '';\n            this.blockIFrame.contentWindow[this.iFrameJSVarname] = {};\n            this.blockFormAdd.update();\n            this.blockFormConfirmed.update();\n            this.blockForm.action = '';\n\n            return this;\n        },\n\n        /**\n         * Process fields data: save, restore, move saved to form and back\n         *\n         * @param method can be 'item_confirm', 'item_restore', 'current_confirmed_to_form', 'form_confirmed_to_confirmed'\n         */\n        _processFieldsData: function (method) {\n\n            /**\n             * Internal function for rename fields names of some list type\n             * if listType is not specified, then it won't be added as prefix to all names\n             *\n             * @param method can be 'current_confirmed_to_form', 'form_confirmed_to_confirmed'\n             * @param blockItem\n             */\n            var _renameFields = function (method, blockItem, listType) {\n                var pattern         = null;\n                var patternFlat     = null;\n                var replacement     = null;\n                var replacementFlat = null;\n                var scopeArr        = blockItem.id.match(/.*\\[\\w+\\]\\[([^\\]]+)\\]$/);\n                var itemId          = scopeArr[1];\n\n                if (method == 'current_confirmed_to_form') {\n                    pattern         = RegExp('(\\\\w+)(\\\\[?)');\n                    patternFlat     = RegExp('(\\\\w+)');\n                    replacement     = 'item[' + itemId + '][$1]$2';\n                    replacementFlat = 'item_' + itemId + '_$1';\n\n                    if (listType) {\n                        replacement = 'list[' + listType + '][item][' + itemId + '][$1]$2';\n                        replacementFlat = 'list_' + listType + '_' + replacementFlat;\n                    }\n                } else if (method == 'form_confirmed_to_confirmed') {\n                    var stPattern = 'item\\\\[' + itemId + '\\\\]\\\\[(\\\\w+)\\\\](.*)';\n                    var stPatternFlat = 'item_' + itemId + '_(\\\\w+)';\n\n                    if (listType) {\n                        stPattern = 'list\\\\[' + listType + '\\\\]\\\\[item\\\\]\\\\[' + itemId + '\\\\]\\\\[(\\\\w+)\\\\](.*)';\n                        stPatternFlat = 'list_' + listType + '_' + stPatternFlat;\n                    }\n                    pattern         = new RegExp(stPattern);\n                    patternFlat     = new RegExp(stPatternFlat);\n                    replacement     = '$1$2';\n                    replacementFlat = '$1';\n                } else {\n                    return false;\n                }\n                var rename = function (elms) {\n                    for (var i = 0; i < elms.length; i++) {\n                        if (elms[i].name && elms[i].type == 'file') {\n                            elms[i].name = elms[i].name.replace(patternFlat, replacementFlat);\n                        } else if (elms[i].name) {\n                            elms[i].name = elms[i].name.replace(pattern, replacement);\n                        }\n                    }\n                };\n\n                rename(blockItem.getElementsByTagName('input'));\n                rename(blockItem.getElementsByTagName('select'));\n                rename(blockItem.getElementsByTagName('textarea'));\n            };\n\n            switch (method) {\n                case 'item_confirm':\n                    if (!$(this.confirmedCurrentId)) {\n                        this.blockConfirmed.insert(new Element('div', {\n                            id: this.confirmedCurrentId\n                        }));\n                    } else {\n                        $(this.confirmedCurrentId).update();\n                    }\n                    this.blockFormFields.childElements().each(function (elm) {\n                        $(this.confirmedCurrentId).insert(elm);\n                    }.bind(this));\n                    break;\n\n                case 'item_restore':\n                    this.blockFormFields.update();\n\n                    // clone confirmed to form\n                    var mageData = null;\n\n                    $(this.confirmedCurrentId).childElements().each(function (elm) {\n                        var cloned = elm.cloneNode(true);\n\n                        if (elm.mageData) {\n                            cloned.mageData = elm.mageData;\n                            mageData = elm.mageData;\n                        }\n                        this.blockFormFields.insert(cloned);\n                    }.bind(this));\n\n                    // get confirmed values\n                    var fieldsValue = {};\n                    var getConfirmedValues = function (elms) {\n                        for (var i = 0; i < elms.length; i++) {\n                            if (elms[i].name) {\n                                if ('undefined' == typeof fieldsValue[elms[i].name]) {\n                                    fieldsValue[elms[i].name] = {};\n                                }\n\n                                if (elms[i].type == 'checkbox') {\n                                    fieldsValue[elms[i].name][elms[i].value] = elms[i].checked;\n                                } else if (elms[i].type == 'radio') {\n                                    if (elms[i].checked) {\n                                        fieldsValue[elms[i].name] = elms[i].value;\n                                    }\n                                } else {\n                                    fieldsValue[elms[i].name] = Form.Element.getValue(elms[i]);\n                                }\n                            }\n                        }\n                    };\n\n                    getConfirmedValues($(this.confirmedCurrentId).getElementsByTagName('input'));\n                    getConfirmedValues($(this.confirmedCurrentId).getElementsByTagName('select'));\n                    getConfirmedValues($(this.confirmedCurrentId).getElementsByTagName('textarea'));\n\n                    // restore confirmed values\n                    var restoreConfirmedValues = function (elms) {\n                        for (var i = 0; i < elms.length; i++) {\n                            if ('undefined' != typeof fieldsValue[elms[i].name]) {\n                                if (elms[i].type != 'file') {\n                                    if (elms[i].type == 'checkbox') {\n                                        elms[i].checked = fieldsValue[elms[i].name][elms[i].value];\n                                    } else if (elms[i].type == 'radio') {\n                                        if (elms[i].value == fieldsValue[elms[i].name]) {\n                                            elms[i].checked = true;\n                                        }\n                                    } else {\n                                        elms[i].setValue(fieldsValue[elms[i].name]);\n                                    }\n                                }\n                            }\n                        }\n                    };\n\n                    restoreConfirmedValues(this.blockFormFields.getElementsByTagName('input'));\n                    restoreConfirmedValues(this.blockFormFields.getElementsByTagName('select'));\n                    restoreConfirmedValues(this.blockFormFields.getElementsByTagName('textarea'));\n\n                    // Execute scripts\n                    if (mageData && mageData.scripts) {\n                        this.restorePhase = true;\n\n                        try {\n                            mageData.scripts.map(function (script) {\n                                return eval(script);\n                            });\n                        } catch (e) {\n\n                        }\n                        this.restorePhase = false;\n                    }\n                    break;\n\n                case 'current_confirmed_to_form':\n                    var allowedListTypes = {};\n\n                    allowedListTypes[this.current.listType] = true;\n                    var listInfo = this.listTypes[this.current.listType];\n\n                    if (listInfo.complexTypes) {\n                        for (var i = 0, len = listInfo.complexTypes.length; i < len; i++) {\n                            allowedListTypes[listInfo.complexTypes[i]] = true;\n                        }\n                    }\n\n                    this.blockFormConfirmed.update();\n                    this.blockConfirmed.childElements().each(function (blockItem) {\n                        var scopeArr    = blockItem.id.match(/.*\\[(\\w+)\\]\\[([^\\]]+)\\]$/);\n                        var listType    = scopeArr[1];\n                        var itemId    = scopeArr[2];\n\n                        if (allowedListTypes[listType] && (!this.itemsFilter[listType] ||\n                            this.itemsFilter[listType].indexOf(itemId) != -1)) {\n                            _renameFields(method, blockItem, listInfo.complexTypes ? listType : null);\n                            this.blockFormConfirmed.insert(blockItem);\n                        }\n                    }.bind(this));\n                    break;\n\n                case 'form_confirmed_to_confirmed':\n                    var listInfo = this.listTypes[this.current.listType];\n\n                    this.blockFormConfirmed.childElements().each(function (blockItem) {\n                        var scopeArr = blockItem.id.match(/.*\\[(\\w+)\\]\\[([^\\]]+)\\]$/);\n                        var listType = scopeArr[1];\n\n                        _renameFields(method, blockItem, listInfo.complexTypes ? listType : null);\n                        this.blockConfirmed.insert(blockItem);\n                    }.bind(this));\n                    break;\n            }\n        },\n\n        /**\n         * Check if qty selected correctly\n         *\n         * @param object element\n         * @param object event\n         */\n        changeOptionQty: function (element, event) {\n            var checkQty = true;\n\n            if ('undefined' != typeof event) {\n                if (event.keyCode == 8 || event.keyCode == 46) {\n                    checkQty = false;\n                }\n            }\n\n            if (checkQty && (Number(element.value) <= 0 || isNaN(Number(element.value)))) {\n                element.value = 1;\n            }\n        }\n    };\n\n    productConfigure = new ProductConfigure();\n    jQuery(document).trigger('productConfigure:inited');\n    jQuery(document).data('productConfigureInited', true);\n});\n","Magento_Catalog/catalog/product/edit/attribute.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/mage',\n    'validation'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).mage('form').validation({\n            validationUrl: config.validationUrl\n        });\n    };\n});\n","Magento_Catalog/catalog/product/attribute/unique-validate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/backend/validation'\n], function (jQuery) {\n    'use strict';\n\n    return function (config) {\n        var msg = '',\n            _config = jQuery.extend({\n                element: null,\n                message: '',\n                uniqueClass: 'required-unique'\n            }, config),\n\n            /** @inheritdoc */\n            messager = function () {\n                return msg;\n            };\n\n        if (typeof _config.element === 'string') {\n            jQuery.validator.addMethod(\n                _config.element,\n\n                function (value, element) {\n                    var inputs = jQuery(element)\n                            .closest('table')\n                            .find('.' + _config.uniqueClass + ':visible'),\n                        valuesHash = {},\n                        isValid = true,\n                        duplicates = [];\n\n                    inputs.each(function (el) {\n                        var inputValue = inputs[el].value;\n\n                        if (typeof valuesHash[inputValue] !== 'undefined') {\n                            isValid = false;\n                            duplicates.push(inputValue);\n                        }\n                        valuesHash[inputValue] = el;\n                    });\n\n                    if (!isValid) {\n                        msg = _config.message + ' (' + duplicates.join(', ') + ')';\n                    }\n\n                    return isValid;\n                },\n\n                messager\n            );\n        }\n    };\n});\n","Magento_Vault/js/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\n/* @api */\ndefine([\n    'jquery',\n    'uiComponent'\n], function ($, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            $selector: null,\n            selector: 'edit_form',\n            fieldset: '',\n            active: false,\n            imports: {\n                onActiveChange: 'active'\n            }\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            self.$selector = $('#' + self.selector);\n            this._super()\n                .observe(['active']);\n\n            // re-init payment method events\n            self.$selector.off('changePaymentMethod.' + this.getCode())\n                .on('changePaymentMethod.' + this.getCode(), this.changePaymentMethod.bind(this));\n\n            if (this.active()) {\n                $('#' + this.fieldset + ' input:radio:first').trigger('click');\n            }\n\n            return this;\n        },\n\n        /**\n         * Enable/disable current payment method\n         * @param {Object} event\n         * @param {String} method\n         * @returns {exports.changePaymentMethod}\n         */\n        changePaymentMethod: function (event, method) {\n            this.active(method === this.getCode());\n\n            return this;\n        },\n\n        /**\n         * Triggered when payment changed\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                this.$selector.trigger('setVaultNotActive.' + this.getCode());\n\n                return;\n            }\n\n            $('#' + this.fieldset + ' input:radio:first').trigger('click');\n            window.order.addExcludedPaymentMethod(this.getCode());\n        },\n\n        /**\n         * Get payment method code\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        }\n    });\n});\n","Magento_Bundle/js/bundle-product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*global FORM_KEY*/\n/*global bSelection*/\n/*global $H*/\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/product/weight-handler',\n    'Magento_Ui/js/modal/modal',\n    'jquery/ui',\n    'mage/translate',\n    'Magento_Theme/js/sortable',\n    'prototype'\n], function ($, weightHandler) {\n    'use strict';\n\n    $.widget('mage.bundleProduct', {\n        /** @inheritdoc */\n        _create: function () {\n            this._initOptionBoxes()\n                ._initSortableSelections()\n                ._bindCheckboxHandlers()\n                ._initCheckboxState()\n                ._bindAddSelectionDialog()\n                ._hideProductTypeSwitcher();\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _initOptionBoxes: function () {\n            var syncOptionTitle;\n\n            this.element.sortable({\n                axis: 'y',\n                handle: '[data-role=draggable-handle]',\n                items: '.option-box',\n                update: this._updateOptionBoxPositions,\n                tolerance: 'pointer'\n            });\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            syncOptionTitle = function (event) {\n                var originalValue = $(event.target).attr('data-original-value'),\n                    currentValue = $(event.target).val(),\n                    optionBoxTitle = $('.title > span', $(event.target).closest('.option-box')),\n                    newOptionTitle = $.mage.__('New Option');\n\n                optionBoxTitle.text(currentValue === '' && !originalValue.length ? newOptionTitle : currentValue);\n            };\n            this._on({\n                'change .field-option-title input[name$=\"[title]\"]': syncOptionTitle,\n                'keyup .field-option-title input[name$=\"[title]\"]': syncOptionTitle,\n                'paste .field-option-title input[name$=\"[title]\"]': syncOptionTitle\n            });\n\n            return this;\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _initSortableSelections: function () {\n            this.element.find('.option-box .form-list tbody').sortable({\n                axis: 'y',\n                handle: '[data-role=draggable-handle]',\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {jQuery} ui\n                 * @return {jQuery}\n                 */\n                helper: function (event, ui) {\n                    ui.children().each(function () {\n                        $(this).width($(this).width());\n                    });\n\n                    return ui;\n                },\n                update: this._updateSelectionsPositions,\n                tolerance: 'pointer'\n            });\n\n            return this;\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _initCheckboxState: function () {\n            this.element.find('.is-required').each(function () {\n                $(this).prop('checked', $(this).closest('.option-box').find('[name$=\"[required]\"]').val() > 0);\n            });\n\n            this.element.find('.is-user-defined-qty').each(function () {\n                $(this).prop('checked', $(this).closest('.qty-box').find('.select').val() > 0);\n            });\n\n            return this;\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _bindAddSelectionDialog: function () {\n            var widget = this;\n\n            this._on({\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'click .add-selection': function (event) {\n                    var $optionBox = $(event.target).closest('.option-box'),\n                        $selectionGrid = $optionBox.find('.selection-search').clone(),\n                        optionIndex = $optionBox.attr('id').replace('bundle_option_', ''),\n                        productIds = [],\n                        productSkus = [],\n                        selectedProductList = {};\n\n                    $optionBox.find('[name$=\"[product_id]\"]').each(function () {\n                        if (!$(this).closest('tr').find('[name$=\"[delete]\"]').val()) {\n                            productIds.push($(this).val());\n                            productSkus.push($(this).closest('tr').find('.col-sku').text());\n                        }\n                    });\n\n                    bSelection.gridSelection.set(optionIndex, $H({}));\n                    bSelection.gridRemoval = $H({});\n                    bSelection.gridSelectedProductSkus = productSkus;\n\n                    $selectionGrid.on('contentUpdated', bSelection.gridUpdateCallback);\n                    $selectionGrid.on('change', '.col-id input', function () {\n                        var tr = $(this).closest('tr');\n\n                        if ($(this).is(':checked')) {\n                            selectedProductList[$(this).val()] = {\n                                name: $.trim(tr.find('.col-name').html()),\n                                sku: $.trim(tr.find('.col-sku').html()),\n                                'product_id': $(this).val(),\n                                'option_id': $('bundle_selection_id_' + optionIndex).val(),\n                                'selection_price_value': 0,\n                                'selection_qty': 1\n                            };\n                        } else {\n                            delete selectedProductList[$(this).val()];\n                        }\n                    });\n\n                    $selectionGrid.modal({\n                        title: $optionBox.find('input[name$=\"[title]\"]').val() === '' ?\n                            $.mage.__('Add Products to New Option') :\n                            $.mage.__('Add Products to Option \"%1\"').replace(\n                                '%1',\n                                $('<div>').text($optionBox.find('input[name$=\"[title]\"]').val()).html()\n                            ),\n                        modalClass: 'bundle',\n                        type: 'slide',\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} modalWindow\n                         */\n                        closed: function (e, modalWindow) {\n                            modalWindow.modal.remove();\n                        },\n                        buttons: [{\n                            text: $.mage.__('Add Selected Products'),\n                            'class': 'action-primary action-add',\n\n                            /** Click action. */\n                            click: function () {\n                                $.each(selectedProductList, function () {\n                                    window.bSelection.addRow(optionIndex, this);\n                                });\n                                bSelection.gridRemoval.each(function (pair) {\n                                    $optionBox.find('.col-sku').filter(function () {\n                                        return $.trim($(this).text()) === pair.key; // find row by SKU\n                                    }).closest('tr').find('button.delete').trigger('click');\n                                });\n                                widget.refreshSortableElements();\n                                widget._updateSelectionsPositions.apply(widget.element);\n                                $selectionGrid.modal('closeModal');\n                            }\n                        }]\n                    });\n                    $.ajax({\n                        url: bSelection.selectionSearchUrl,\n                        dataType: 'html',\n                        data: {\n                            index: optionIndex,\n                            products: productIds,\n                            'selected_products': productIds,\n                            'form_key': FORM_KEY\n                        },\n\n                        /**\n                         * @param {*} data\n                         */\n                        success: function (data) {\n                            $selectionGrid.html(data).modal('openModal');\n                        },\n                        context: $('body'),\n                        showLoader: true\n                    });\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * @private\n         */\n        _hideProductTypeSwitcher: function () {\n            weightHandler.hideWeightSwitcher();\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _bindCheckboxHandlers: function () {\n            this._on({\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'change .is-required': function (event) {\n                    var $this = $(event.target);\n\n                    $this.closest('.option-box').find('[name$=\"[required]\"]').val($this.is(':checked') ? 1 : 0);\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'change .is-user-defined-qty': function (event) {\n                    var $this = $(event.target);\n\n                    $this.closest('.qty-box').find('.select').val($this.is(':checked') ? 1 : 0);\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _updateOptionBoxPositions: function () {\n            $(this).find('[name^=bundle_options][name$=\"[position]\"]').each(function (index) {\n                $(this).val(index);\n            });\n\n            return this;\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _updateSelectionsPositions: function () {\n            $(this).find('[name^=bundle_selections][name$=\"[position]\"]').each(function (index) {\n                $(this).val(index);\n            });\n\n            return this;\n        },\n\n        /**\n         *\n         * @return {Object}\n         */\n        refreshSortableElements: function () {\n            this.element.sortable('refresh');\n            this._updateOptionBoxPositions.apply(this.element);\n            this._initSortableSelections();\n            this._initCheckboxState();\n\n            return this;\n        }\n    });\n\n});\n","Magento_Bundle/js/bundle-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events',\n    'Magento_Catalog/js/product/weight-handler'\n], function ($, productType, weight) {\n    'use strict';\n\n    return {\n\n        /**\n         * Constructor component\n         */\n        'Magento_Bundle/js/bundle-type-handler': function () {\n            this.bindAll();\n            this._initType();\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n        },\n\n        /**\n         * Init type\n         * @private\n         */\n        _initType: function () {\n            if (\n                productType.type.init === 'bundle' &&\n                productType.type.current !== 'bundle' &&\n                !weight.isLocked()\n            ) {\n                weight.switchWeight();\n            }\n        }\n    };\n});\n","Magento_Bundle/js/price-bundle.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        optionConfig: null,\n        productBundleSelector: 'input.bundle.option, select.bundle.option, textarea.bundle.option',\n        qtyFieldSelector: 'input.qty',\n        priceBoxSelector: '.price-box',\n        optionHandlers: {},\n        optionTemplate: '<%- data.label %>' +\n        '<% if (data.finalPrice.value) { %>' +\n        ' +<%- data.finalPrice.formatted %>' +\n        '<% } %>',\n        controlContainer: 'dd', // should be eliminated\n        priceFormat: {},\n        isFixedPrice: false,\n        optionTierPricesBlocksSelector: '#option-tier-prices-{1} [data-role=\"selection-tier-prices\"]'\n    };\n\n    $.widget('mage.priceBundle', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle() {\n            var form = this.element,\n                options = $(this.options.productBundleSelector, form);\n\n            options.trigger('change');\n        },\n\n        /**\n         * @private\n         */\n        _create: function createPriceBundle() {\n            var form = this.element,\n                options = $(this.options.productBundleSelector, form),\n                priceBox = $(this.options.priceBoxSelector, form),\n                qty = $(this.options.qtyFieldSelector, form);\n\n            if (priceBox.data('magePriceBox') &&\n                priceBox.priceBox('option') &&\n                priceBox.priceBox('option').priceConfig\n            ) {\n                if (priceBox.priceBox('option').priceConfig.optionTemplate) {\n                    this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                }\n                this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n                priceBox.priceBox('setDefault', this.options.optionConfig.prices);\n            }\n            this._applyOptionNodeFix(options);\n\n            options.on('change', this._onBundleOptionChanged.bind(this));\n            qty.on('change', this._onQtyFieldChanged.bind(this));\n        },\n\n        /**\n         * Handle change on bundle option inputs\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _onBundleOptionChanged: function onBundleOptionChanged(event) {\n            var changes,\n                bundleOption = $(event.target),\n                priceBox = $(this.options.priceBoxSelector, this.element),\n                handler = this.options.optionHandlers[bundleOption.data('role')];\n\n            bundleOption.data('optionContainer', bundleOption.closest(this.options.controlContainer));\n            bundleOption.data('qtyField', bundleOption.data('optionContainer').find(this.options.qtyFieldSelector));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(bundleOption, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(bundleOption, this.options.optionConfig);//eslint-disable-line\n            }\n\n            if (changes) {\n                priceBox.trigger('updatePrice', changes);\n            }\n\n            this._displayTierPriceBlock(bundleOption);\n            this.updateProductSummary();\n        },\n\n        /**\n         * Handle change on qty inputs near bundle option\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _onQtyFieldChanged: function onQtyFieldChanged(event) {\n            var field = $(event.target),\n                optionInstance,\n                optionConfig;\n\n            if (field.data('optionId') && field.data('optionValueId')) {\n                optionInstance = field.data('option');\n                optionConfig = this.options.optionConfig\n                    .options[field.data('optionId')]\n                    .selections[field.data('optionValueId')];\n                optionConfig.qty = field.val();\n\n                optionInstance.trigger('change');\n            }\n        },\n\n        /**\n         * Helper to fix backend behavior:\n         *  - if default qty large than 1 then backend multiply price in config\n         *\n         * @deprecated\n         * @private\n         */\n        _applyQtyFix: function applyQtyFix() {\n            var config = this.options.optionConfig;\n\n            if (config.isFixedPrice) {\n                _.each(config.options, function (option) {\n                    _.each(option.selections, function (item) {\n                        if (item.qty && item.qty !== 1) {\n                            _.each(item.prices, function (price) {\n                                price.amount /= item.qty;\n                            });\n                        }\n                    });\n                });\n            }\n        },\n\n        /**\n         * Helper to fix issue with option nodes:\n         *  - you can't place any html in option ->\n         *    so you can't style it via CSS\n         * @param {jQuery} options\n         * @private\n         */\n        _applyOptionNodeFix: function applyOptionNodeFix(options) {\n            var config = this.options,\n                format = config.priceFormat,\n                template = config.optionTemplate;\n\n            template = mageTemplate(template);\n            options.filter('select').each(function (index, element) {\n                var $element = $(element),\n                    optionId = utils.findOptionId($element),\n                    optionConfig = config.optionConfig && config.optionConfig.options[optionId].selections,\n                    value;\n\n                $element.find('option').each(function (idx, option) {\n                    var $option,\n                        optionValue,\n                        toTemplate,\n                        prices;\n\n                    $option = $(option);\n                    optionValue = $option.val();\n\n                    if (!optionValue && optionValue !== 0) {\n                        return;\n                    }\n\n                    toTemplate = {\n                        data: {\n                            label: optionConfig[optionValue] && optionConfig[optionValue].name\n                        }\n                    };\n                    prices = optionConfig[optionValue].prices;\n\n                    _.each(prices, function (price, type) {\n                        value = +price.amount;\n                        value += _.reduce(price.adjustments, function (sum, x) {//eslint-disable-line\n                            return sum + x;\n                        }, 0);\n                        toTemplate.data[type] = {\n                            value: value,\n                            formatted: utils.formatPrice(value, format)\n                        };\n                    });\n\n                    $option.html(template(toTemplate));\n                });\n            });\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge accepted configuration with instance options.\n         * @param  {Object}  options\n         * @return {$.Widget}\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n\n            this._super(options);\n\n            return this;\n        },\n\n        /**\n         * Show or hide option tier prices block\n         *\n         * @param {Object} optionElement\n         * @private\n         */\n        _displayTierPriceBlock: function (optionElement) {\n            var optionType = optionElement.prop('type'),\n                optionId,\n                optionValue,\n                optionTierPricesElements;\n\n            if (optionType === 'select-one') {\n                optionId = utils.findOptionId(optionElement[0]);\n                optionValue = optionElement.val() || null;\n                optionTierPricesElements = $(this.options.optionTierPricesBlocksSelector.replace('{1}', optionId));\n\n                _.each(optionTierPricesElements, function (tierPriceElement) {\n                    var selectionId = $(tierPriceElement).data('selection-id') + '';\n\n                    if (selectionId === optionValue) {\n                        $(tierPriceElement).show();\n                    } else {\n                        $(tierPriceElement).hide();\n                    }\n                });\n            }\n        },\n\n        /**\n         * Handler to update productSummary box\n         */\n        updateProductSummary: function updateProductSummary() {\n            this.element.trigger('updateProductSummary', {\n                config: this.options.optionConfig\n            });\n        }\n    });\n\n    return $.mage.priceBundle;\n\n    /**\n     * Converts option value to priceBox object\n     *\n     * @param   {jQuery} element\n     * @param   {Object} config\n     * @returns {Object|null} - priceBox object with additional prices\n     */\n    function defaultGetOptionValue(element, config) {\n        var changes = {},\n            optionHash,\n            tempChanges,\n            qtyField,\n            optionId = utils.findOptionId(element[0]),\n            optionValue = element.val() || null,\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = config.options[optionId].selections,\n            optionQty = 0,\n            canQtyCustomize = false,\n            selectedIds = config.selected;\n\n        switch (optionType) {\n            case 'radio':\n            case 'select-one':\n\n                if (optionType === 'radio' && !element.is(':checked')) {\n                    return null;\n                }\n\n                qtyField = element.data('qtyField');\n                qtyField.data('option', element);\n\n                if (optionValue) {\n                    optionQty = optionConfig[optionValue].qty || 0;\n                    canQtyCustomize = optionConfig[optionValue].customQty === '1';\n                    toggleQtyField(qtyField, optionQty, optionId, optionValue, canQtyCustomize);//eslint-disable-line\n                    tempChanges = utils.deepClone(optionConfig[optionValue].prices);\n                    tempChanges = applyTierPrice(//eslint-disable-line\n                        tempChanges,\n                        optionQty,\n                        optionConfig[optionValue]\n                    );\n                    tempChanges = applyQty(tempChanges, optionQty);//eslint-disable-line\n                } else {\n                    tempChanges = {};\n                    toggleQtyField(qtyField, '0', optionId, optionValue, false);//eslint-disable-line\n                }\n                optionHash = 'bundle-option-' + optionName;\n                changes[optionHash] = tempChanges;\n                selectedIds[optionId] = [optionValue];\n                break;\n\n            case 'select-multiple':\n                optionValue = _.compact(optionValue);\n\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = 'bundle-option-' + optionName + '##' + optionValueCode;\n                    optionQty = row.qty || 0;\n                    tempChanges = utils.deepClone(row.prices);\n                    tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig);//eslint-disable-line\n                    tempChanges = applyQty(tempChanges, optionQty);//eslint-disable-line\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? tempChanges : {};\n                });\n\n                selectedIds[optionId] = optionValue || [];\n                break;\n\n            case 'checkbox':\n                optionHash = 'bundle-option-' + optionName + '##' + optionValue;\n                optionQty = optionConfig[optionValue].qty || 0;\n                tempChanges = utils.deepClone(optionConfig[optionValue].prices);\n                tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig);//eslint-disable-line\n                tempChanges = applyQty(tempChanges, optionQty);//eslint-disable-line\n                changes[optionHash] = element.is(':checked') ? tempChanges : {};\n\n                selectedIds[optionId] = selectedIds[optionId] || [];\n\n                if (!_.contains(selectedIds[optionId], optionValue) && element.is(':checked')) {\n                    selectedIds[optionId].push(optionValue);\n                } else if (!element.is(':checked')) {\n                    selectedIds[optionId] = _.without(selectedIds[optionId], optionValue);\n                }\n                break;\n\n            case 'hidden':\n                optionHash = 'bundle-option-' + optionName + '##' + optionValue;\n                optionQty = optionConfig[optionValue].qty || 0;\n                canQtyCustomize = optionConfig[optionValue].customQty === '1';\n                qtyField = element.data('qtyField');\n                qtyField.data('option', element);\n                toggleQtyField(qtyField, optionQty, optionId, optionValue, canQtyCustomize);//eslint-disable-line\n                tempChanges = utils.deepClone(optionConfig[optionValue].prices);\n                tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig);//eslint-disable-line\n                tempChanges = applyQty(tempChanges, optionQty);//eslint-disable-line\n\n                optionHash = 'bundle-option-' + optionName;\n                changes[optionHash] = tempChanges;\n                selectedIds[optionId] = [optionValue];\n                break;\n        }\n\n        return changes;\n    }\n\n    /**\n     * Helper to toggle qty field\n     * @param {jQuery} element\n     * @param {String|Number} value\n     * @param {String|Number} optionId\n     * @param {String|Number} optionValueId\n     * @param {Boolean} canEdit\n     */\n    function toggleQtyField(element, value, optionId, optionValueId, canEdit) {\n        element\n            .val(value)\n            .data('optionId', optionId)\n            .data('optionValueId', optionValueId)\n            .attr('disabled', !canEdit);\n\n        if (canEdit) {\n            element.removeClass('qty-disabled');\n        } else {\n            element.addClass('qty-disabled');\n        }\n    }\n\n    /**\n     * Helper to multiply on qty\n     *\n     * @param   {Object} prices\n     * @param   {Number} qty\n     * @returns {Object}\n     */\n    function applyQty(prices, qty) {\n        _.each(prices, function (everyPrice) {\n            everyPrice.amount *= qty;\n            _.each(everyPrice.adjustments, function (el, index) {\n                everyPrice.adjustments[index] *= qty;\n            });\n        });\n\n        return prices;\n    }\n\n    /**\n     * Helper to limit price with tier price\n     *\n     * @param {Object} oneItemPrice\n     * @param {Number} qty\n     * @param {Object} optionConfig\n     * @returns {Object}\n     */\n    function applyTierPrice(oneItemPrice, qty, optionConfig) {\n        var tiers = optionConfig.tierPrice,\n            magicKey = _.keys(oneItemPrice)[0],\n            tiersFirstKey = _.keys(optionConfig)[0],\n            lowest = false;\n\n        if (!tiers) {//tiers is undefined when options has only one option\n            tiers = optionConfig[tiersFirstKey].tierPrice;\n        }\n\n        tiers.sort(function (a, b) {//sorting based on \"price_qty\"\n            return a['price_qty'] - b['price_qty'];\n        });\n\n        _.each(tiers, function (tier, index) {\n            if (tier['price_qty'] > qty) {\n                return;\n            }\n\n            if (tier.prices[magicKey].amount < oneItemPrice[magicKey].amount) {\n                lowest = index;\n            }\n        });\n\n        if (lowest !== false) {\n            oneItemPrice = utils.deepClone(tiers[lowest].prices);\n        }\n\n        return oneItemPrice;\n    }\n});\n","Magento_Bundle/js/components/bundle-user-defined-checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Checkbox) {\n    'use strict';\n\n    return Checkbox.extend({\n        defaults: {\n            listens: {\n                inputType: 'onInputTypeChange'\n            }\n        },\n\n        /**\n         * Handler for \"inputType\" property\n         *\n         * @param {String} data\n         */\n        onInputTypeChange: function (data) {\n            data === 'checkbox' || data === 'multi' ?\n                this.clear()\n                    .visible(false) :\n                this.visible(true);\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-input-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated Not used anymore\n * @see Magento_Bundle/js/components/bundle-record\n * @see Magento_Bundle/js/components/bundle-checkbox\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'uiRegistry'\n], function (Select, registry) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            previousType: '',\n            parentContainer: '',\n            selections: '',\n            targetIndex: '',\n            typeMap: {}\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onUpdate: function () {\n            var type = this.typeMap[this.value()];\n\n            if (type !== this.previousType) {\n                this.previousType = type;\n                this.processSelections(type === 'radio');\n            }\n\n            this._super();\n        },\n\n        /**\n         * Toggle 'User Defined' column and clears values\n         * @param {Boolean} isRadio\n         */\n        processSelections: function (isRadio) {\n            var records = registry.get(this.retrieveParentName(this.parentContainer) + '.' + this.selections),\n                checkedFound = false;\n\n            records.elems.each(function (record) {\n                record.elems.filter(function (comp) {\n                    return comp.index === this.userDefinedIndex;\n                }, this).each(function (comp) {\n                    comp.visible(isRadio);\n                });\n\n                if (isRadio) {\n                    record.elems.filter(function (comp) {\n                        return comp.index === this.isDefaultIndex;\n                    }, this).each(function (comp) {\n                        if (comp.checked()) {\n                            if (checkedFound) {\n                                comp.clearing = true;\n                                comp.clear();\n                                comp.clearing = false;\n                            }\n\n                            checkedFound = true;\n                        }\n                    });\n                }\n            }, this);\n        },\n\n        /**\n         * Retrieve name for the most global parent with provided index.\n         *\n         * @param {String} parent - parent name.\n         * @returns {String}\n         */\n        retrieveParentName: function (parent) {\n            return this.name.replace(new RegExp('^(.+?\\\\.)?' + parent + '\\\\..+'), '$1' + parent);\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-dynamic-rows.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows'\n], function (_, utils, registry, dynamicRows) {\n    'use strict';\n\n    return dynamicRows.extend({\n        defaults: {\n            label: '',\n            collapsibleHeader: true,\n            columnsHeader: false,\n            deleteProperty: false,\n            addButton: false\n        },\n\n        /**\n         * Set new data to dataSource,\n         * delete element\n         *\n         * @param {Array} data - record data\n         */\n        _updateData: function (data) {\n            var elems = _.clone(this.elems()),\n                path,\n                dataArr,\n                optionBaseData;\n\n            dataArr = this.recordData.splice(this.startIndex, this.recordData().length - this.startIndex);\n            dataArr.splice(0, this.pageSize);\n            elems = _.sortBy(this.elems(), function (elem) {\n                return ~~elem.index;\n            });\n\n            data.concat(dataArr).forEach(function (rec, idx) {\n                if (elems[idx]) {\n                    elems[idx].recordId = rec[this.identificationProperty];\n                }\n\n                if (!rec.position) {\n                    rec.position = this.maxPosition;\n                    this.setMaxPosition();\n                }\n\n                path = this.dataScope + '.' + this.index + '.' + (this.startIndex + idx);\n                optionBaseData = _.pick(rec, function (value) {\n                    return !_.isObject(value);\n                });\n                this.source.set(path, optionBaseData);\n                this.source.set(path + '.bundle_button_proxy', []);\n                this.source.set(path + '.bundle_selections', []);\n                this.removeBundleItemsFromOption(idx);\n                _.each(rec['bundle_selections'], function (obj, index) {\n                    this.source.set(path + '.bundle_button_proxy' + '.' + index, rec['bundle_button_proxy'][index]);\n                    this.source.set(path + '.bundle_selections' + '.' + index, obj);\n                }, this);\n            }, this);\n\n            this.elems(elems);\n        },\n\n        /**\n         *  Removes nested dynamic-rows-grid rendered records from option\n         *\n         * @param {Number|String} index - element index\n         */\n        removeBundleItemsFromOption: function (index) {\n            var bundleSelections = registry.get(this.name + '.' + index + '.' + this.bundleSelectionsName),\n                bundleSelectionsLength = (bundleSelections.elems() || []).length,\n                i;\n\n            if (bundleSelectionsLength) {\n                for (i = 0; i < bundleSelectionsLength; i++) {\n                    bundleSelections.elems()[0].destroy();\n                }\n            }\n        },\n\n        /**\n        * {@inheritdoc}\n        */\n        processingAddChild: function (ctx, index, prop) {\n            var recordIds = _.map(this.recordData(), function (rec) {\n                return parseInt(rec['record_id'], 10);\n            }),\n            maxRecordId = _.max(recordIds);\n\n            prop = maxRecordId > -1 ? maxRecordId + 1 : prop;\n            this._super(ctx, index, prop);\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-dynamic-rows-grid.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid'\n], function (_, dynamicRowsGrid) {\n    'use strict';\n\n    return dynamicRowsGrid.extend({\n        defaults: {\n            label: '',\n            columnsHeader: false,\n            columnsHeaderAfterRender: true,\n            addButton: false,\n            isDefaultFieldScope: 'is_default',\n            defaultRecords: {\n                use: [],\n                moreThanOne: false,\n                state: {}\n            },\n            listens: {\n                inputType: 'onInputTypeChange',\n                isDefaultValue: 'onIsDefaultValue'\n            }\n        },\n\n        /**\n         * Handler for type select.\n         *\n         * @param {String} inputType - changed.\n         */\n        onInputTypeChange: function (inputType) {\n            if (this.defaultRecords.moreThanOne && (inputType === 'radio' || inputType === 'select')) {\n                _.each(this.defaultRecords.use, function (index, counter) {\n                    this.source.set(\n                        this.dataScope + '.bundle_selections.' + index + '.' + this.isDefaultFieldScope,\n                        counter ? '0' : '1'\n                    );\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Handler for is_default field.\n         *\n         * @param {Object} data - changed data.\n         */\n        onIsDefaultValue: function (data) {\n            var cb,\n                use = 0;\n\n            this.defaultRecords.use = [];\n\n            cb = function (elem, key) {\n\n                if (~~elem) {\n                    this.defaultRecords.use.push(key);\n                    use++;\n                }\n\n                this.defaultRecords.moreThanOne = use > 1;\n            }.bind(this);\n\n            _.each(data, cb);\n        },\n\n        /**\n         * Initialize elements from grid\n         *\n         * @param {Array} data\n         *\n         * @returns {Object} Chainable.\n         */\n        initElements: function (data) {\n            var newData = this.getNewData(data),\n                recordIndex;\n\n            this.parsePagesData(data);\n\n            if (newData.length) {\n                if (this.insertData().length) {\n                    recordIndex = data.length - newData.length - 1;\n\n                    _.each(newData, function (newRecord) {\n                        this.processingAddChild(newRecord, ++recordIndex, newRecord[this.identificationProperty]);\n                    }, this);\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Mapping value from grid\n         *\n         * @param {Array} data\n         */\n        mappingValue: function (data) {\n            if (_.isEmpty(data)) {\n                return;\n            }\n\n            this._super();\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'uiRegistry'\n], function (Checkbox, registry) {\n    'use strict';\n\n    return Checkbox.extend({\n        defaults: {\n            clearing: false,\n            parentContainer: '',\n            parentSelections: '',\n            changer: '',\n            exports: {\n                value: '${$.parentName}:isDefaultValue'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            this._super().\n                observe('elementTmpl');\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initConfig: function () {\n            this._super();\n            this.imports.changeType = this.retrieveParentName(this.parentContainer) + '.' + this.changer + ':value';\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onUpdate: function () {\n            if (this.prefer === 'radio' && this.checked() && !this.clearing) {\n                this.clearValues();\n            }\n\n            this._super();\n        },\n\n        /**\n         * Checkbox to radio type changer.\n         *\n         * @param {String} type - type to change.\n         */\n        changeType: function (type) {\n            var typeMap = registry.get(this.retrieveParentName(this.parentContainer) + '.' + this.changer).typeMap;\n\n            this.prefer = typeMap[type];\n            this.elementTmpl(this.templates[typeMap[type]]);\n        },\n\n        /**\n         * Clears values in components like this.\n         */\n        clearValues: function () {\n            var records = registry.get(this.retrieveParentName(this.parentSelections)),\n                index = this.index,\n                uid = this.uid;\n\n            records.elems.each(function (record) {\n                record.elems.filter(function (comp) {\n                    return comp.index === index && comp.uid !== uid;\n                }).each(function (comp) {\n                    comp.clearing = true;\n                    comp.clear();\n                    comp.clearing = false;\n                });\n            });\n        },\n\n        /**\n         * Retrieve name for the most global parent with provided index.\n         *\n         * @param {String} parent - parent name.\n         * @returns {String}\n         */\n        retrieveParentName: function (parent) {\n            return this.name.replace(new RegExp('^(.+?\\\\.)?' + parent + '\\\\..+'), '$1' + parent);\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-record.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/dynamic-rows/record',\n    'uiRegistry'\n], function (Record, registry) {\n    'use strict';\n\n    return Record.extend({\n        /**\n         * @param {String} val - type of Input Type\n         */\n        onTypeChanged: function (val) {\n            var columnVisibility  = !(val === 'multi' || val === 'checkbox');\n\n            registry.async(this.name + '.' + 'selection_can_change_qty')(function (elem) {\n                elem.visible(columnVisibility);\n            });\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-option-qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            valueUpdate: 'input',\n            isInteger: true,\n            validation: {\n                'validate-number': true\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onUpdate: function () {\n            this.validation['validate-digits'] = this.isInteger;\n            this._super();\n        },\n\n        /**\n         * @inheritdoc\n         */\n        hasChanged: function () {\n            var notEqual = this.value() !== this.initialValue.toString();\n\n            return !this.visible() ? false : notEqual;\n        }\n\n    });\n});\n","mage/translate-inline.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'mage/template',\n            'jquery-ui-modules/dialog',\n            'mage/translate'\n        ], factory);\n    } else {\n        factory(root.jQuery, root.mageTemplate);\n    }\n}(this, function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.translateInline', $.ui.dialog, {\n        options: {\n            translateForm: {\n                template: '#translate-form-template',\n                data: {\n                    id: 'translate-inline-form',\n                    message: 'Please refresh the page to see your changes after submitting this form.'\n                }\n            },\n            autoOpen: false,\n            translateArea: null,\n            modal: true,\n            dialogClass: 'popup-window',\n            width: '75%',\n            title: $.mage.__('Translate'),\n            height: 470,\n            position: {\n                my: 'left top',\n                at: 'center top',\n                of: 'body'\n            },\n            buttons: [{\n                text: $.mage.__('Submit'),\n                'class': 'action-primary',\n\n                /**\n                 * Click\n                 */\n                click: function () {\n                    $(this).translateInline('submit');\n                }\n            },\n            {\n                text: $.mage.__('Close'),\n                'class': 'action-close',\n\n                /**\n                 * Click.\n                 */\n                click: function () {\n                    $(this).translateInline('close');\n                }\n            }],\n\n            /**\n             * Open.\n             */\n            open: function () {\n                var topMargin;\n\n                $(this).closest('.ui-dialog').addClass('ui-dialog-active');\n                topMargin = jQuery(this).closest('.ui-dialog').children('.ui-dialog-titlebar').outerHeight() + 45;\n                jQuery(this).closest('.ui-dialog').css('margin-top', topMargin);\n            },\n\n            /**\n             * Close.\n             */\n            close: function () {\n                $(this).closest('.ui-dialog').removeClass('ui-dialog-active');\n            }\n        },\n\n        /**\n         * Translate Inline creation\n         * @protected\n         */\n        _create: function () {\n            this.tmpl = mageTemplate(this.options.translateForm.template);\n            (this.options.translateArea && $(this.options.translateArea).length ?\n                $(this.options.translateArea) :\n                this.element.closest('body'))\n                    .on('edit.editTrigger', $.proxy(this._onEdit, this));\n            this._super();\n        },\n\n        /**\n         * @param {*} templateData\n         * @return {*|jQuery|HTMLElement}\n         * @private\n         */\n        _prepareContent: function (templateData) {\n            var data = $.extend({\n                items: templateData,\n                escape: $.mage.escapeHTML\n            }, this.options.translateForm.data);\n\n            this.data = data;\n\n            return $(this.tmpl({\n                data: data\n            }));\n        },\n\n        /**\n         * Render translation form and open dialog\n         * @param {Object} e - object\n         * @protected\n         */\n        _onEdit: function (e) {\n            this.target = e.target;\n            this.element.html(this._prepareContent($(e.target).data('translate')));\n            this.open(e);\n        },\n\n        /**\n         * Submit.\n         */\n        submit: function () {\n            if (this.formIsSubmitted) {\n                return;\n            }\n            this._formSubmit();\n        },\n\n        /**\n         * Send ajax request on form submit\n         * @protected\n         */\n        _formSubmit: function () {\n            var parameters;\n\n            this.formIsSubmitted = true;\n            parameters = $.param({\n                area: this.options.area\n            }) + '&' + $('#' + this.options.translateForm.data.id).serialize();\n\n            $.ajax({\n                url: this.options.ajaxUrl,\n                type: 'POST',\n                data: parameters,\n                loaderContext: this.element,\n                showLoader: true\n            }).complete($.proxy(this._formSubmitComplete, this));\n        },\n\n        /**\n         * @param {Object} response\n         * @private\n         */\n        _formSubmitComplete: function (response) {\n            this.close();\n            this.formIsSubmitted = false;\n            this._updatePlaceholder(response.responseJSON[this.data.items[0].original]);\n        },\n\n        /**\n         * @param {*} newValue\n         * @private\n         */\n        _updatePlaceholder: function (newValue) {\n            var target = jQuery(this.target);\n\n            target.data('translate')[0].shown = newValue;\n            target.data('translate')[0].translated = newValue;\n            target.html(newValue);\n        },\n\n        /**\n         * Destroy translateInline\n         */\n        destroy: function () {\n            this.element.off('.editTrigger');\n            this._super();\n        }\n    });\n    // @TODO move the \"escapeHTML\" method into the file with global utility functions\n    $.extend(true, $, {\n        mage: {\n            /**\n             * @param {String} str\n             * @return {Boolean}\n             */\n            escapeHTML: function (str) {\n                return str ?\n                    jQuery('<div/>').text(str).html().replace(/\"/g, '&quot;') :\n                    false;\n            }\n        }\n    });\n\n    return $.mage.translateInline;\n}));\n","mage/multiselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'text!mage/multiselect.html',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'jquery/editableMultiselect/js/jquery.multiselect'\n], function (_, $, searchTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.multiselect2', {\n        options: {\n            mselectContainer: 'section.mselect-list',\n            mselectItemsWrapperClass: 'mselect-items-wrapper',\n            mselectCheckedClass: 'mselect-checked',\n            containerClass: 'paginated',\n            searchInputClass: 'admin__action-multiselect-search',\n            selectedItemsCountClass: 'admin__action-multiselect-items-selected',\n            currentPage: 1,\n            lastAppendValue: 0,\n            updateDelay: 1000,\n            optionsLoaded: false\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            $.fn.multiselect.call(this.element, this.options);\n        },\n\n        /** @inheritdoc */\n        _init: function () {\n            this.domElement = this.element.get(0);\n\n            this.$container = $(this.options.mselectContainer);\n            this.$wrapper = this.$container.find('.' + this.options.mselectItemsWrapperClass);\n            this.$item = this.$wrapper.find('div').first();\n            this.selectedValues = [];\n            this.values = {};\n\n            this.$container.addClass(this.options.containerClass).prepend(searchTemplate);\n            this.$input = this.$container.find('.' + this.options.searchInputClass);\n            this.$selectedCounter = this.$container.find('.' + this.options.selectedItemsCountClass);\n            this.filter = '';\n\n            if (this.domElement.options.length) {\n                this._setLastAppendOption(this.domElement.options[this.domElement.options.length - 1].value);\n            }\n\n            this._initElement();\n            this._events();\n        },\n\n        /**\n         * Leave only saved/selected options in select element.\n         *\n         * @private\n         */\n        _initElement: function () {\n            this.element.empty();\n            _.each(this.options.selectedValues, function (value) {\n                this._createSelectedOption({\n                    value: value,\n                    label: value\n                });\n            }, this);\n        },\n\n        /**\n         * Attach required events.\n         *\n         * @private\n         */\n        _events: function () {\n            var onKeyUp = _.debounce(this.onKeyUp, this.options.updateDelay);\n\n            _.bindAll(this, 'onScroll', 'onCheck', 'onOptionsChange');\n\n            this.$wrapper.on('scroll', this.onScroll);\n            this.$wrapper.on('change.mselectCheck', '[type=checkbox]', this.onCheck);\n            this.$input.on('keyup', _.bind(onKeyUp, this));\n            this.element.on('change.hiddenSelect', this.onOptionsChange);\n        },\n\n        /**\n         * Behaves multiselect scroll.\n         */\n        onScroll: function () {\n            var height = this.$wrapper.height(),\n                scrollHeight = this.$wrapper.prop('scrollHeight'),\n                scrollTop = Math.ceil(this.$wrapper.prop('scrollTop'));\n\n            if (!this.options.optionsLoaded && scrollHeight - height <= scrollTop) {\n                this.loadOptions();\n            }\n        },\n\n        /**\n         * Behaves keyup event on input search\n         */\n        onKeyUp: function () {\n            if (this.getSearchCriteria() === this.filter) {\n                return false;\n            }\n\n            this.setFilter();\n            this.clearMultiselectOptions();\n            this.setCurrentPage(0);\n            this.loadOptions();\n        },\n\n        /**\n         * Callback for select change event\n         */\n        onOptionsChange: function () {\n            this.selectedValues = _.map(this.domElement.options, function (option) {\n                this.values[option.value] = true;\n\n                return option.value;\n            }, this);\n\n            this._updateSelectedCounter();\n        },\n\n        /**\n         * Overrides native check behaviour.\n         *\n         * @param {Event} event\n         */\n        onCheck: function (event) {\n            var checkbox = event.target,\n                option = {\n                    value: checkbox.value,\n                    label: $(checkbox).parent('label').text()\n                };\n\n            checkbox.checked ? this._createSelectedOption(option) : this._removeSelectedOption(option);\n            event.stopPropagation();\n        },\n\n        /**\n         * Show error message.\n         *\n         * @param {String} message\n         */\n        onError: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Updates current filter state.\n         */\n        setFilter: function () {\n            this.filter = this.getSearchCriteria() || '';\n        },\n\n        /**\n         * Reads search input value.\n         *\n         * @return {String}\n         */\n        getSearchCriteria: function () {\n            return $.trim(this.$input.val());\n        },\n\n        /**\n         * Load options data.\n         */\n        loadOptions: function () {\n            var nextPage = this.getCurrentPage() + 1;\n\n            this.$wrapper.trigger('processStart');\n            this.$input.prop('disabled', true);\n\n            $.get(this.options.nextPageUrl, {\n                p: nextPage,\n                s: this.filter\n            })\n            .done(function (response) {\n                if (response.success) {\n                    this.appendOptions(response.result);\n                    this.setCurrentPage(nextPage);\n                } else {\n                    this.onError(response.errorMessage);\n                }\n            }.bind(this))\n            .always(function () {\n                this.$wrapper.trigger('processStop');\n                this.$input.prop('disabled', false);\n\n                if (this.filter) {\n                    this.$input.focus();\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Append loaded options\n         *\n         * @param {Array} options\n         */\n        appendOptions: function (options) {\n            var divOptions = [];\n\n            if (!options.length) {\n                return false;\n            }\n\n            if (this.isOptionsLoaded(options)) {\n                return;\n            }\n\n            options.forEach(function (option) {\n                if (!this.values[option.value]) {\n                    this.values[option.value] = true;\n                    option.selected = this._isOptionSelected(option);\n                    divOptions.push(this._createMultiSelectOption(option));\n                    this._setLastAppendOption(option.value);\n                }\n            }, this);\n\n            this.$wrapper.append(divOptions);\n        },\n\n        /**\n         * Clear multiselect options\n         */\n        clearMultiselectOptions: function () {\n            this._setLastAppendOption(0);\n            this.values = {};\n            this.$wrapper.empty();\n        },\n\n        /**\n         * Checks if all options are already loaded\n         *\n         * @return {Boolean}\n         */\n        isOptionsLoaded: function (options) {\n            this.options.optionsLoaded = this.options.lastAppendValue === options[options.length - 1].value;\n\n            return this.options.optionsLoaded;\n        },\n\n        /**\n         * Setter for current page.\n         *\n         * @param {Number} page\n         */\n        setCurrentPage: function (page) {\n            this.options.currentPage = page;\n        },\n\n        /**\n         * Getter for current page.\n         *\n         * @return {Number}\n         */\n        getCurrentPage: function () {\n            return this.options.currentPage;\n        },\n\n        /**\n         * Creates new selected option for select element\n         *\n         * @param {Object} option - option object\n         * @param {String} option.value - option value\n         * @param {String} option.label - option label\n         * @private\n         */\n        _createSelectedOption: function (option) {\n            var selectOption = new Option(option.label, option.value, false, true);\n\n            this.element.append(selectOption);\n            this.selectedValues.push(option.value);\n            this._updateSelectedCounter();\n\n            return selectOption;\n        },\n\n        /**\n         * Remove passed option from select element\n         *\n         * @param {Object} option - option object\n         * @param {String} option.value - option value\n         * @param {String} option.label - option label\n         * @return {Object} option\n         * @private\n         */\n        _removeSelectedOption: function (option) {\n            var unselectedOption = _.findWhere(this.domElement.options, {\n                value: option.value\n            });\n\n            if (!_.isUndefined(unselectedOption)) {\n                this.domElement.remove(unselectedOption.index);\n                this.selectedValues.splice(_.indexOf(this.selectedValues, option.value), 1);\n                this._updateSelectedCounter();\n            }\n\n            return unselectedOption;\n        },\n\n        /**\n         * Creates new DIV option for multiselect widget\n         *\n         * @param {Object} option - option object\n         * @param {String} option.value - option value\n         * @param {String} option.label - option label\n         * @param {Boolean} option.selected - is option selected\n         * @private\n         */\n        _createMultiSelectOption: function (option) {\n            var item = this.$item.clone(),\n                checkbox = item.find('input'),\n                isSelected = !!option.selected;\n\n            checkbox.val(option.value)\n                .prop('checked', isSelected)\n                .toggleClass(this.options.mselectCheckedClass, isSelected);\n\n            item.find('label > span').text(option.label);\n\n            return item;\n        },\n\n        /**\n         * Checks if passed option should be selected\n         *\n         * @param {Object} option - option object\n         * @param {String} option.value - option value\n         * @param {String} option.label - option label\n         * @param {Boolean} option.selected - is option selected\n         * @return {Boolean}\n         * @private\n         */\n        _isOptionSelected: function (option) {\n            return !!~this.selectedValues.indexOf(option.value);\n        },\n\n        /**\n         * Saves last added option value.\n         *\n         * @param {Number} value\n         * @private\n         */\n        _setLastAppendOption: function (value) {\n            this.options.lastAppendValue = value;\n        },\n\n        /**\n         * Updates counter of selected items.\n         *\n         * @private\n         */\n        _updateSelectedCounter: function () {\n            this.$selectedCounter.text(this.selectedValues.length);\n        }\n    });\n\n    return $.mage.multiselect2;\n});\n","mage/bootstrap.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/apply/main',\n    'Magento_Ui/js/lib/knockout/bootstrap'\n], function ($, mage) {\n    'use strict';\n\n    $.ajaxSetup({\n        cache: false\n    });\n\n    /**\n     * Init all components defined via data-mage-init attribute.\n     */\n    $(mage.apply);\n});\n","mage/layout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\n/* eslint-disable strict */\ndefine(['underscore'], function (_) {\n    return {\n        /**\n         * @param {Object} config\n         */\n        build: function (config) {\n            var types = _.map(_.flatten(config), function (item) {\n                return item.type;\n            });\n\n            require(types, function () {});\n        }\n    };\n});\n","mage/dropdown_old.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var ESC_KEY_CODE = '27';\n\n    $(document)\n        .on('click.dropdown', function (event) {\n            if (!$(event.target).is('[data-toggle=dropdown].active, ' +\n                '[data-toggle=dropdown].active *, ' +\n                '[data-toggle=dropdown].active + .dropdown-menu, ' +\n                '[data-toggle=dropdown].active + .dropdown-menu *,' +\n                '[data-toggle=dropdown].active + [data-target=\"dropdown\"],' +\n                '[data-toggle=dropdown].active + [data-target=\"dropdown\"] *')\n            ) {\n                $('[data-toggle=dropdown].active').trigger('close.dropdown');\n            }\n        })\n        .on('keyup.dropdown', function (event) {\n            if (event.keyCode == ESC_KEY_CODE) { //eslint-disable-line eqeqeq\n                $('[data-toggle=dropdown].active').trigger('close.dropdown');\n            }\n        });\n\n    /**\n     * @param {Object} options\n     */\n    $.fn.dropdown = function (options) {\n        options = $.extend({\n            parent: null,\n            btnArrow: '.arrow',\n            activeClass: 'active'\n        }, options);\n\n        return this.each(function () {\n            var elem = $(this);\n\n            elem.off('open.dropdown, close.dropdown, click.dropdown');\n            elem.on('open.dropdown', function () {\n                elem\n                    .addClass(options.activeClass)\n                    .parent()\n                    .addClass(options.activeClass);\n                elem.find(options.btnArrow).text('\\u25b2'); // arrow up\n            });\n\n            elem.on('close.dropdown', function () {\n                elem\n                    .removeClass(options.activeClass)\n                    .parent()\n                    .removeClass(options.activeClass);\n                elem.find(options.btnArrow).text('\\u25bc'); // arrow down\n            });\n\n            elem.on('click.dropdown', function () {\n                var isActive = elem.hasClass('active');\n\n                $('[data-toggle=dropdown].active').trigger('close.dropdown');\n                elem.trigger(isActive ? 'close.dropdown' : 'open.dropdown');\n\n                return false;\n            });\n        });\n    };\n\n    return function (data, el) {\n        $(el).dropdown(data);\n    };\n});\n","mage/ie-class-fixer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable strict */\n(function () {\n    var userAgent = navigator.userAgent, // user agent identifier\n        html = document.documentElement, // html tag\n        gap = ''; // gap between classes\n\n    if (html.className) { // check if neighbour class exist in html tag\n        gap = ' ';\n    } // end if\n\n    if (userAgent.match(/Trident.*rv[ :]*11\\./)) { // Special case for IE11\n        html.className += gap + 'ie11';\n    } // end if\n\n})();\n","mage/accordion.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/tabs'\n], function ($, tabs) {\n    'use strict';\n\n    $.widget('mage.accordion', tabs, {\n        options: {\n            active: [0],\n            multipleCollapsible: false,\n            openOnFocus: false\n        },\n\n        /**\n         * @private\n         */\n        _callCollapsible: function () {\n            var self = this,\n                disabled = false,\n                active = false;\n\n            if (typeof this.options.active === 'string') {\n                this.options.active = this.options.active.split(' ').map(function (item) {\n                    return parseInt(item, 10);\n                });\n            }\n\n            $.each(this.collapsibles, function (i) {\n                disabled = active = false;\n\n                if ($.inArray(i, self.options.disabled) !== -1) {\n                    disabled = true;\n                }\n\n                if ($.inArray(i, self.options.active) !== -1) {\n                    active = true;\n                }\n                self._instantiateCollapsible(this, i, active, disabled);\n            });\n        },\n\n        /**\n         * Overwrites default functionality to provide the option to activate/deactivate multiple sections simultaneous\n         * @param {*} action\n         * @param {*} index\n         * @private\n         */\n        _toggleActivate: function (action, index) {\n            var self = this;\n\n            if ($.isArray(index && this.options.multipleCollapsible)) {\n                $.each(index, function () {\n                    self.collapsibles.eq(this).collapsible(action);\n                });\n            } else if (index === undefined && this.options.multipleCollapsible) {\n                this.collapsibles.collapsible(action);\n            } else {\n                this._super(action, index);\n            }\n        },\n\n        /**\n         * If the Accordion allows multiple section to be active at the same time, if deep linking is used\n         * sections that don't contain the id from anchor shouldn't be closed, otherwise the accordion uses the\n         * tabs behavior\n         * @private\n         */\n        _handleDeepLinking: function () {\n            if (!this.options.multipleCollapsible) {\n                this._super();\n            }\n        },\n\n        /**\n         * Prevent default behavior that closes the other sections when one gets activated if the Accordion allows\n         * multiple sections simultaneous\n         * @private\n         */\n        _closeOthers: function () {\n            if (!this.options.multipleCollapsible) {\n                this._super();\n            }\n            $.each(this.collapsibles, function () {\n                $(this).on('beforeOpen', function () {\n                    var section = $(this);\n\n                    section.addClass('allow').prevAll().addClass('allow');\n                    section.nextAll().removeClass('allow');\n                });\n            });\n        }\n    });\n\n    return $.mage.accordion;\n});\n","mage/loader_old.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'mage/template',\n            'jquery-ui-modules/widget',\n            'mage/translate'\n        ], factory);\n    } else {\n        factory(root.jQuery, root.mageTemplate);\n    }\n}(this, function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.loader', {\n        loaderStarted: 0,\n        spinner: $(undefined),\n        options: {\n            icon: '',\n            texts: {\n                loaderText: $.mage.__('Please wait...'),\n                imgAlt: $.mage.__('Loading...')\n            },\n            template: '<div class=\"loading-mask\" data-role=\"loader\">' +\n                '<div class=\"popup popup-loading\">' +\n                '<div class=\"popup-inner\">' +\n                '<% if (data.icon) { %>' +\n                    '<img ' +\n                        '<% if (data.texts.imgAlt) { %>alt=\"<%- data.texts.imgAlt %>\"<% } %> ' +\n                        'src=\"<%- data.icon %>\"><% } %>' +\n                '<% if (data.texts.loaderText) { %><%- data.texts.loaderText %><% } %>' +\n                '</div>' +\n                '</div>' +\n                '</div>'\n        },\n\n        /**\n         * Loader creation\n         * @protected\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * Bind on ajax events\n         * @protected\n         */\n        _bind: function () {\n            this._on({\n                'processStop': 'hide',\n                'processStart': 'show',\n                'show.loader': 'show',\n                'hide.loader': 'hide',\n                'contentUpdated.loader': '_contentUpdated'\n            });\n        },\n\n        /**\n         * Verify loader present after content updated\n         *\n         * This will be cleaned up by the task MAGETWO-11070\n         *\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _contentUpdated: function (e) {\n            this.show(e);\n        },\n\n        /**\n         * Show loader\n         */\n        show: function (e, ctx) {\n            this._render();\n            this.loaderStarted++;\n            this.spinner.show();\n\n            if (ctx) {\n                this.spinner\n                    .css({\n                        width: ctx.outerWidth(),\n                        height: ctx.outerHeight(),\n                        position: 'absolute'\n                    })\n                    .position({\n                        my: 'top left',\n                        at: 'top left',\n                        of: ctx\n                    });\n            }\n\n            return false;\n        },\n\n        /**\n         * Hide loader\n         */\n        hide: function () {\n            if (this.loaderStarted > 0) {\n                this.loaderStarted--;\n\n                if (this.loaderStarted === 0) {\n                    this.spinner.hide();\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * Render loader\n         * @protected\n         */\n        _render: function () {\n            var tmpl;\n\n            if (this.spinner.length === 0) {\n                tmpl = mageTemplate(this.options.template, {\n                    data: this.options\n                });\n\n                this.spinner = $(tmpl);\n            }\n\n            this.element.prepend(this.spinner);\n        },\n\n        /**\n         * Destroy loader\n         */\n        _destroy: function () {\n            this.spinner.remove();\n        }\n    });\n\n    /**\n     * This widget takes care of registering the needed loader listeners on the body\n     */\n    $.widget('mage.loaderAjax', {\n        options: {\n            defaultContainer: '[data-container=body]'\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this._bind();\n            // There should only be one instance of this widget, and it should be attached\n            // to the body only. Having it on the page twice will trigger multiple processStarts.\n            if (window.console && !this.element.is(this.options.defaultContainer) && $.mage.isDevMode(undefined)) {\n                console.warn('This widget is intended to be attached to the body, not below.');\n            }\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            $(document).on({\n                'ajaxSend': this._onAjaxSend.bind(this),\n                'ajaxComplete': this._onAjaxComplete.bind(this)\n            });\n        },\n\n        /**\n         * @param {Object} loaderContext\n         * @return {*}\n         * @private\n         */\n        _getJqueryObj: function (loaderContext) {\n            var ctx;\n\n            // Check to see if context is jQuery object or not.\n            if (loaderContext) {\n                if (loaderContext.jquery) {\n                    ctx = loaderContext;\n                } else {\n                    ctx = $(loaderContext);\n                }\n            } else {\n                ctx = $('[data-container=\"body\"]');\n            }\n\n            return ctx;\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @param {Object} jqxhr\n         * @param {Object} settings\n         * @private\n         */\n        _onAjaxSend: function (e, jqxhr, settings) {\n            var ctx;\n\n            if (settings && settings.showLoader) {\n                ctx = this._getJqueryObj(settings.loaderContext);\n                ctx.trigger('processStart');\n\n                // Check to make sure the loader is there on the page if not report it on the console.\n                // NOTE that this check should be removed before going live. It is just an aid to help\n                // in finding the uses of the loader that maybe broken.\n                if (window.console && !ctx.parents('[data-role=\"loader\"]').length) {\n                    console.warn('Expected to start loader but did not find one in the dom');\n                }\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @param {Object} jqxhr\n         * @param {Object} settings\n         * @private\n         */\n        _onAjaxComplete: function (e, jqxhr, settings) {\n            if (settings && settings.showLoader && !settings.dontHide) {\n                this._getJqueryObj(settings.loaderContext).trigger('processStop');\n            }\n        }\n    });\n\n    return {\n        loader: $.mage.loader,\n        loaderAjax: $.mage.loaderAjax\n    };\n}));\n","mage/trim-input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.trimInput', {\n        options: {\n            cache: {}\n        },\n\n        /**\n         * Widget initialization\n         * @private\n         */\n        _create: function () {\n            this.options.cache.input = $(this.element);\n            this._bind();\n        },\n\n        /**\n         * Event binding, will monitor change, keyup and paste events.\n         * @private\n         */\n        _bind: function () {\n            if (this.options.cache.input.length) {\n                this._on(this.options.cache.input, {\n                    'change': this._trimInput,\n                    'keyup': this._trimInput,\n                    'paste': this._trimInput\n                });\n            }\n        },\n\n        /**\n         * Trim value\n         * @private\n         */\n        _trimInput: function () {\n            // Safari caret position workaround: storing carter position\n            var caretStart, caretEnd, input;\n\n            caretStart = this.options.cache.input.get(0).selectionStart;\n            caretEnd = this.options.cache.input.get(0).selectionEnd;\n\n            input = this._getInputValue().trim();\n\n            this.options.cache.input.val(input);\n\n            // Safari caret position workaround: setting caret position to previously stored values\n            if (caretStart !== null && caretEnd !== null) {\n                this.options.cache.input.get(0).setSelectionRange(caretStart, caretEnd);\n            }\n        },\n\n        /**\n         * Get input value\n         * @returns {*}\n         * @private\n         */\n        _getInputValue: function () {\n            return this.options.cache.input.val();\n        }\n    });\n\n    return $.mage.trimInput;\n});\n","mage/calendar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*eslint max-depth: 0*/\n(function (factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'jquery-ui-modules/widget',\n            'jquery-ui-modules/datepicker',\n            'jquery-ui-modules/timepicker'\n        ], factory);\n    } else {\n        factory(window.jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    var calendarBasePrototype,\n        datepickerPrototype = $.datepicker.constructor.prototype;\n\n    $.datepicker.markerClassName = '_has-datepicker';\n\n    /**\n     * Extend JQuery date picker prototype with store local time methods\n     */\n    $.extend(datepickerPrototype, {\n        /**\n         * Get date/time according to store settings.\n         * We use serverTimezoneOffset (in seconds) instead of serverTimezoneSeconds\n         * in order to have ability to know actual store time even if page hadn't been reloaded\n         * @returns {Date}\n         */\n        _getTimezoneDate: function (options) {\n            // local time in ms\n            var ms = Date.now();\n\n            options = options || $.calendarConfig || {};\n\n            // Adjust milliseconds according to store timezone offset,\n            // mind the GMT zero offset\n            if (typeof options.serverTimezoneOffset !== 'undefined') {\n                // Make UTC time and add store timezone offset in seconds\n                ms += new Date().getTimezoneOffset() * 60 * 1000 + options.serverTimezoneOffset * 1000;\n            } else if (typeof options.serverTimezoneSeconds !== 'undefined') {\n                //Set milliseconds according to client local timezone offset\n                ms = (options.serverTimezoneSeconds + new Date().getTimezoneOffset() * 60) * 1000;\n            }\n\n            return new Date(ms);\n        },\n\n        /**\n         * Set date/time according to store settings.\n         * @param {String|Object} target - the target input field or division or span\n         */\n        _setTimezoneDateDatepicker: function (target) {\n            this._setDateDatepicker(target, this._getTimezoneDate());\n        }\n    });\n\n    /**\n     * Widget calendar\n     */\n    $.widget('mage.calendar', {\n        options: {\n            autoComplete: true\n        },\n\n        /**\n         * Merge global options with options passed to widget invoke\n         * @protected\n         */\n        _create: function () {\n            this._enableAMPM();\n            this.options = $.extend(\n                {},\n                $.calendarConfig ? $.calendarConfig : {},\n                this.options.showsTime ? {\n                    showTime: true,\n                    showHour: true,\n                    showMinute: true\n                } : {},\n                this.options\n            );\n            this._initPicker(this.element);\n            this._overwriteGenerateHtml();\n        },\n\n        /**\n         * Get picker name\n         * @protected\n         */\n        _picker: function () {\n            return this.options.showsTime ? 'datetimepicker' : 'datepicker';\n        },\n\n        /**\n         * Fix for Timepicker - Set ampm option for Timepicker if timeformat contains string 'tt'\n         * @protected\n         */\n        _enableAMPM: function () {\n            if (this.options.timeFormat && this.options.timeFormat.indexOf('tt') >= 0) {\n                this.options.ampm = true;\n            }\n        },\n\n        /**\n         * Wrapper for overwrite jQuery UI datepicker function.\n         */\n        _overwriteGenerateHtml: function () {\n            /**\n             * Overwrite jQuery UI datepicker function.\n             * Reason: magento date could be set before calendar show\n             * but local date will be styled as current in original _generateHTML\n             *\n             * @param {Object} inst - instance datepicker.\n             * @return {String} html template\n             */\n            $.datepicker.constructor.prototype._generateHTML = function (inst) {\n                var today = this._getTimezoneDate(),\n                    isRTL = this._get(inst, 'isRTL'),\n                    showButtonPanel = this._get(inst, 'showButtonPanel'),\n                    hideIfNoPrevNext = this._get(inst, 'hideIfNoPrevNext'),\n                    navigationAsDateFormat = this._get(inst, 'navigationAsDateFormat'),\n                    numMonths = this._getNumberOfMonths(inst),\n                    showCurrentAtPos = this._get(inst, 'showCurrentAtPos'),\n                    stepMonths = this._get(inst, 'stepMonths'),\n                    isMultiMonth = parseInt(numMonths[0], 10) !== 1 || parseInt(numMonths[1], 10) !== 1,\n                    currentDate = this._daylightSavingAdjust(!inst.currentDay ? new Date(9999, 9, 9) :\n                        new Date(inst.currentYear, inst.currentMonth, inst.currentDay)),\n                    minDate = this._getMinMaxDate(inst, 'min'),\n                    maxDate = this._getMinMaxDate(inst, 'max'),\n                    drawMonth = inst.drawMonth - showCurrentAtPos,\n                    drawYear = inst.drawYear,\n                    maxDraw,\n                    prevText = this._get(inst, 'prevText'),\n                    prev,\n                    nextText = this._get(inst, 'nextText'),\n                    next,\n                    currentText = this._get(inst, 'currentText'),\n                    gotoDate,\n                    controls,\n                    buttonPanel,\n                    firstDay,\n                    showWeek = this._get(inst, 'showWeek'),\n                    dayNames = this._get(inst, 'dayNames'),\n                    dayNamesMin = this._get(inst, 'dayNamesMin'),\n                    monthNames = this._get(inst, 'monthNames'),\n                    monthNamesShort =  this._get(inst, 'monthNamesShort'),\n                    beforeShowDay = this._get(inst, 'beforeShowDay'),\n                    showOtherMonths = this._get(inst, 'showOtherMonths'),\n                    selectOtherMonths = this._get(inst, 'selectOtherMonths'),\n                    defaultDate = this._getDefaultDate(inst),\n                    html = '',\n                    row = 0,\n                    col = 0,\n                    selectedDate,\n                    cornerClass = ' ui-corner-all',\n                    group = '',\n                    calender = '',\n                    dow = 0,\n                    thead,\n                    day,\n                    daysInMonth,\n                    leadDays,\n                    curRows,\n                    numRows,\n                    printDate,\n                    dRow = 0,\n                    tbody,\n                    daySettings,\n                    otherMonth,\n                    unselectable;\n\n                if (drawMonth < 0) {\n                    drawMonth += 12;\n                    drawYear--;\n                }\n\n                if (maxDate) {\n                    maxDraw = this._daylightSavingAdjust(new Date(maxDate.getFullYear(),\n                        maxDate.getMonth() - numMonths[0] * numMonths[1] + 1, maxDate.getDate()));\n                    maxDraw = minDate && maxDraw < minDate ? minDate : maxDraw;\n\n                    while (this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1)) > maxDraw) {\n                        drawMonth--;\n\n                        if (drawMonth < 0) {\n                            drawMonth = 11;\n                            drawYear--;\n\n                        }\n                    }\n                }\n                inst.drawMonth = drawMonth;\n                inst.drawYear = drawYear;\n                prevText = !navigationAsDateFormat ? prevText : this.formatDate(prevText,\n                    this._daylightSavingAdjust(new Date(drawYear, drawMonth - stepMonths, 1)),\n                    this._getFormatConfig(inst));\n                prev = this._canAdjustMonth(inst, -1, drawYear, drawMonth) ?\n                    '<a class=\"ui-datepicker-prev ui-corner-all\" data-handler=\"prev\" data-event=\"click\"' +\n                    ' title=\"' + prevText + '\">' +\n                    '<span class=\"ui-icon ui-icon-circle-triangle-' + (isRTL ? 'e' : 'w') + '\">' +\n                    '' + prevText + '</span></a>'\n                    : hideIfNoPrevNext ? ''\n                        :   '<a class=\"ui-datepicker-prev ui-corner-all ui-state-disabled\" title=\"' +\n                            '' + prevText + '\"><span class=\"ui-icon ui-icon-circle-triangle-' +\n                            '' + (isRTL ? 'e' : 'w') + '\">' + prevText + '</span></a>';\n                nextText = !navigationAsDateFormat ?\n                    nextText\n                    :   this.formatDate(nextText,\n                        this._daylightSavingAdjust(new Date(drawYear, drawMonth + stepMonths, 1)),\n                        this._getFormatConfig(inst));\n                next = this._canAdjustMonth(inst, +1, drawYear, drawMonth) ?\n                    '<a class=\"ui-datepicker-next ui-corner-all\" data-handler=\"next\" data-event=\"click\"' +\n                    'title=\"' + nextText + '\"><span class=\"ui-icon ui-icon-circle-triangle-' +\n                    '' + (isRTL ? 'w' : 'e') + '\">' + nextText + '</span></a>'\n                    : hideIfNoPrevNext ? ''\n                        :   '<a class=\"ui-datepicker-next ui-corner-all ui-state-disabled\" title=\"' + nextText + '\">' +\n                            '<span class=\"ui-icon ui-icon-circle-triangle-' + (isRTL ? 'w' : 'e') + '\">' + nextText +\n                            '</span></a>';\n                gotoDate = this._get(inst, 'gotoCurrent') && inst.currentDay ? currentDate : today;\n                currentText = !navigationAsDateFormat ? currentText :\n                    this.formatDate(currentText, gotoDate, this._getFormatConfig(inst));\n                controls = !inst.inline ?\n                    '<button type=\"button\" class=\"ui-datepicker-close ui-state-default ui-priority-primary ' +\n                    'ui-corner-all\" data-handler=\"hide\" data-event=\"click\">' +\n                    this._get(inst, 'closeText') + '</button>'\n                    : '';\n                buttonPanel = showButtonPanel ?\n                    '<div class=\"ui-datepicker-buttonpane ui-widget-content\">' + (isRTL ? controls : '') +\n                    (this._isInRange(inst, gotoDate) ? '<button type=\"button\" class=\"ui-datepicker-current ' +\n                    'ui-state-default ui-priority-secondary ui-corner-all\" data-handler=\"today\" data-event=\"click\"' +\n                    '>' + currentText + '</button>' : '') + (isRTL ? '' : controls) + '</div>' : '';\n                firstDay = parseInt(this._get(inst, 'firstDay'), 10);\n                firstDay = isNaN(firstDay) ? 0 : firstDay;\n\n                for (row = 0; row < numMonths[0]; row++) {\n                    this.maxRows = 4;\n\n                    for (col = 0; col < numMonths[1]; col++) {\n                        selectedDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, inst.selectedDay));\n\n                        calender = '';\n\n                        if (isMultiMonth) {\n                            calender += '<div class=\"ui-datepicker-group';\n\n                            if (numMonths[1] > 1) {\n                                switch (col) {\n                                    case 0: calender += ' ui-datepicker-group-first';\n                                        cornerClass = ' ui-corner-' + (isRTL ? 'right' : 'left');\n                                        break;\n\n                                    case numMonths[1] - 1: calender += ' ui-datepicker-group-last';\n                                        cornerClass = ' ui-corner-' + (isRTL ? 'left' : 'right');\n                                        break;\n\n                                    default: calender += ' ui-datepicker-group-middle'; cornerClass = '';\n                                }\n                            }\n                            calender += '\">';\n                        }\n                        calender += '<div class=\"ui-datepicker-header ' +\n                            'ui-widget-header ui-helper-clearfix' + cornerClass + '\">' +\n                            (/all|left/.test(cornerClass) && parseInt(row, 10) === 0 ? isRTL ? next : prev : '') +\n                            (/all|right/.test(cornerClass) && parseInt(row, 10) === 0 ? isRTL ? prev : next : '') +\n                            this._generateMonthYearHeader(inst, drawMonth, drawYear, minDate, maxDate,\n                            row > 0 || col > 0, monthNames, monthNamesShort) + // draw month headers\n                            '</div><table class=\"ui-datepicker-calendar\"><thead>' +\n                            '<tr>';\n                        thead = showWeek ?\n                            '<th class=\"ui-datepicker-week-col\">' + this._get(inst, 'weekHeader') + '</th>' : '';\n\n                        for (dow = 0; dow < 7; dow++) { // days of the week\n                            day = (dow + firstDay) % 7;\n                            thead += '<th' + ((dow + firstDay + 6) % 7 >= 5 ?\n                                ' class=\"ui-datepicker-week-end\"' : '') + '>' +\n                                '<span title=\"' + dayNames[day] + '\">' + dayNamesMin[day] + '</span></th>';\n                        }\n                        calender += thead + '</tr></thead><tbody>';\n                        daysInMonth = this._getDaysInMonth(drawYear, drawMonth);\n\n                        if (drawYear === inst.selectedYear && drawMonth === inst.selectedMonth) {\n                            inst.selectedDay = Math.min(inst.selectedDay, daysInMonth);\n                        }\n                        leadDays = (this._getFirstDayOfMonth(drawYear, drawMonth) - firstDay + 7) % 7;\n                        curRows = Math.ceil((leadDays + daysInMonth) / 7); // calculate the number of rows to generate\n                        numRows = isMultiMonth ? this.maxRows > curRows ? this.maxRows : curRows : curRows;\n                        this.maxRows = numRows;\n                        printDate = this._daylightSavingAdjust(new Date(drawYear, drawMonth, 1 - leadDays));\n\n                        for (dRow = 0; dRow < numRows; dRow++) { // create date picker rows\n                            calender += '<tr>';\n                            tbody = !showWeek ? '' : '<td class=\"ui-datepicker-week-col\">' +\n                            this._get(inst, 'calculateWeek')(printDate) + '</td>';\n\n                            for (dow = 0; dow < 7; dow++) { // create date picker days\n                                daySettings = beforeShowDay ?\n                                    beforeShowDay.apply(inst.input ? inst.input[0] : null, [printDate]) : [true, ''];\n                                otherMonth = printDate.getMonth() !== drawMonth;\n                                unselectable = otherMonth && !selectOtherMonths || !daySettings[0] ||\n                                minDate && printDate < minDate || maxDate && printDate > maxDate;\n                                tbody += '<td class=\"' +\n                                ((dow + firstDay + 6) % 7 >= 5 ? ' ui-datepicker-week-end' : '') + // highlight weekends\n                                (otherMonth ? ' ui-datepicker-other-month' : '') + // highlight days from other months\n                                (printDate.getTime() === selectedDate.getTime() &&\n                                drawMonth === inst.selectedMonth && inst._keyEvent || // user pressed key\n                                defaultDate.getTime() === printDate.getTime() &&\n                                defaultDate.getTime() === selectedDate.getTime() ?\n                                    // or defaultDate is current printedDate and defaultDate is selectedDate\n                                ' ' + this._dayOverClass : '') + // highlight selected day\n                                (unselectable ? ' ' + this._unselectableClass + ' ui-state-disabled' : '') +\n                                (otherMonth && !showOtherMonths ? '' : ' ' + daySettings[1] + // highlight custom dates\n                                (printDate.getTime() === currentDate.getTime() ? ' ' + this._currentClass : '') +\n                                (printDate.getDate() === today.getDate() && printDate.getMonth() === today.getMonth() &&\n                                printDate.getYear() === today.getYear() ? ' ui-datepicker-today' : '')) + '\"' +\n                                ((!otherMonth || showOtherMonths) && daySettings[2] ?\n                                ' title=\"' + daySettings[2] + '\"' : '') + // cell title\n                                (unselectable ? '' : ' data-handler=\"selectDay\" data-event=\"click\" data-month=\"' +\n                                '' + printDate.getMonth() + '\" data-year=\"' + printDate.getFullYear() + '\"') + '>' +\n                                (otherMonth && !showOtherMonths ? '&#xa0;' : // display for other months\n                                    unselectable ? '<span class=\"ui-state-default\">' + printDate.getDate() + '</span>'\n                                        : '<a class=\"ui-state-default' +\n                                    (printDate.getTime() === today.getTime() ? ' ' : '') +\n                                    (printDate.getTime() === currentDate.getTime() ? ' ui-state-active' : '') +\n                                    (otherMonth ? ' ui-priority-secondary' : '') +\n                                    '\" href=\"#\">' + printDate.getDate() + '</a>') + '</td>';\n                                printDate.setDate(printDate.getDate() + 1);\n                                printDate = this._daylightSavingAdjust(printDate);\n                            }\n                            calender += tbody + '</tr>';\n                        }\n                        drawMonth++;\n\n                        if (drawMonth > 11) {\n                            drawMonth = 0;\n                            drawYear++;\n                        }\n                        calender += '</tbody></table>' + (isMultiMonth ? '</div>' +\n                        (numMonths[0] > 0 && col === numMonths[1] - 1 ? '<div class=\"ui-datepicker-row-break\"></div>'\n                            : '') : '');\n                        group += calender;\n                    }\n                    html += group;\n                }\n                html += buttonPanel + ($.ui.ie6 && !inst.inline ?\n                    '<iframe src=\"javascript:false;\" class=\"ui-datepicker-cover\" frameborder=\"0\"></iframe>' : '');\n                inst._keyEvent = false;\n\n                return html;\n            };\n        },\n\n        /**\n         * Set current date if the date is not set\n         * @protected\n         * @param {Object} element\n         */\n        _setCurrentDate: function (element) {\n            if (!element.val()) {\n                element[this._picker()]('setTimezoneDate').val('');\n            }\n        },\n\n        /**\n         * Init Datetimepicker\n         * @protected\n         * @param {Object} element\n         */\n        _initPicker: function (element) {\n            var picker = element[this._picker()](this.options),\n                pickerButtonText = picker.next('.ui-datepicker-trigger')\n                    .find('img')\n                    .attr('title');\n\n            picker.next('.ui-datepicker-trigger')\n                .addClass('v-middle')\n                .text('') // Remove jQuery UI datepicker generated image\n                .append('<span>' + pickerButtonText + '</span>');\n\n            $(element).attr('autocomplete', this.options.autoComplete ? 'on' : 'off');\n\n            this._setCurrentDate(element);\n        },\n\n        /**\n         * destroy instance of datetimepicker\n         */\n        _destroy: function () {\n            this.element[this._picker()]('destroy');\n            this._super();\n        },\n\n        /**\n         * Method is kept for backward compatibility and unit-tests acceptance\n         * see \\mage\\calendar\\calendar-test.js\n         * @return {Object} date\n         */\n        getTimezoneDate: function () {\n            return datepickerPrototype._getTimezoneDate.call(this, this.options);\n        }\n    });\n\n    calendarBasePrototype = $.mage.calendar.prototype;\n\n    /**\n     * Extension for Calendar - date and time format convert functionality\n     * @var {Object}\n     */\n    $.widget('mage.calendar', $.extend({}, calendarBasePrototype,\n            /** @lends {$.mage.calendar.prototype} */ {\n                /**\n                 * key - backend format, value - jquery format\n                 * @type {Object}\n                 * @private\n                 */\n                dateTimeFormat: {\n                    date: {\n                        'EEEE': 'DD',\n                        'EEE': 'D',\n                        'EE': 'D',\n                        'E': 'D',\n                        'D': 'o',\n                        'MMMM': 'MM',\n                        'MMM': 'M',\n                        'MM': 'mm',\n                        'M': 'mm',\n                        'yyyy': 'yy',\n                        'y': 'yy',\n                        'Y': 'yy',\n                        'yy': 'yy' // Always long year format on frontend\n                    },\n                    time: {\n                        'a': 'TT'\n                    }\n                },\n\n                /**\n                 * Add Date and Time converting to _create method\n                 * @protected\n                 */\n                _create: function () {\n                    if (this.options.dateFormat) {\n                        this.options.dateFormat = this._convertFormat(this.options.dateFormat, 'date');\n                    }\n\n                    if (this.options.timeFormat) {\n                        this.options.timeFormat = this._convertFormat(this.options.timeFormat, 'time');\n                    }\n                    calendarBasePrototype._create.apply(this, arguments);\n                },\n\n                /**\n                 * Converting date or time format\n                 * @protected\n                 * @param {String} format\n                 * @param {String} type\n                 * @return {String}\n                 */\n                _convertFormat: function (format, type) {\n                    var symbols = format.match(/([a-z]+)/ig),\n                        separators = format.match(/([^a-z]+)/ig),\n                        self = this,\n                        convertedFormat = '';\n\n                    if (symbols) {\n                        $.each(symbols, function (key, val) {\n                            convertedFormat +=\n                                (self.dateTimeFormat[type][val] || val) +\n                                (separators[key] || '');\n                        });\n                    }\n\n                    return convertedFormat;\n                }\n            })\n    );\n\n    /**\n     * Widget dateRange\n     * @extends $.mage.calendar\n     */\n    $.widget('mage.dateRange', $.mage.calendar, {\n\n        /**\n         * creates two instances of datetimepicker for date range selection\n         * @protected\n         */\n        _initPicker: function () {\n            var from,\n                to;\n\n            if (this.options.from && this.options.to) {\n                from = this.element.find('#' + this.options.from.id);\n                to = this.element.find('#' + this.options.to.id);\n                this.options.onSelect = $.proxy(function (selectedDate) {\n                    to[this._picker()]('option', 'minDate', selectedDate);\n                }, this);\n                $.mage.calendar.prototype._initPicker.call(this, from);\n                from.on('change', $.proxy(function () {\n                    to[this._picker()]('option', 'minDate', from[this._picker()]('getDate'));\n                }, this));\n                this.options.onSelect = $.proxy(function (selectedDate) {\n                    from[this._picker()]('option', 'maxDate', selectedDate);\n                }, this);\n                $.mage.calendar.prototype._initPicker.call(this, to);\n                to.on('change', $.proxy(function () {\n                    from[this._picker()]('option', 'maxDate', to[this._picker()]('getDate'));\n                }, this));\n            }\n        },\n\n        /**\n         * destroy two instances of datetimepicker\n         */\n        _destroy: function () {\n            if (this.options.from) {\n                this.element.find('#' + this.options.from.id)[this._picker()]('destroy');\n            }\n\n            if (this.options.to) {\n                this.element.find('#' + this.options.to.id)[this._picker()]('destroy');\n            }\n            this._super();\n        }\n    });\n\n    // Overrides the \"today\" button functionality to select today's date when clicked.\n    $.datepicker._gotoTodayOriginal = $.datepicker._gotoToday;\n\n    /**\n     * overwrite jQuery UI _showDatepicker function for proper HTML generation conditions.\n     *\n     */\n    $.datepicker._showDatepickerOriginal = $.datepicker._showDatepicker;\n\n    /**\n     * Triggers original method showDataPicker for rendering calendar\n     * @param {HTMLObject} input\n     * @private\n     */\n    $.datepicker._showDatepicker = function (input) {\n        if (!input.disabled) {\n            $.datepicker._showDatepickerOriginal.call(this, input);\n        }\n    };\n\n    /**\n     * _gotoToday\n     * @param {Object} el\n     */\n    $.datepicker._gotoToday = function (el) {\n        //Set date/time according to timezone offset\n        $(el).datepicker('setTimezoneDate')\n            // To ensure that user can re-select date field without clicking outside it first.\n            .blur().trigger('change');\n    };\n\n    return {\n        dateRange:  $.mage.dateRange,\n        calendar:   $.mage.calendar\n    };\n}));\n","mage/template.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'underscore'\n        ], factory);\n    } else {\n        root.mageTemplate = factory(root._);\n    }\n}(this, function (_) {\n    'use strict';\n\n    /**\n     * Checks if provided string is a valid DOM selector.\n     *\n     * @param {String} selector - Selector to be checked.\n     * @returns {Boolean}\n     */\n    function isSelector(selector) {\n        try {\n            document.querySelector(selector);\n\n            return true;\n        } catch (e) {\n            return false;\n        }\n    }\n\n    /**\n     * Unescapes characters used in underscore templates.\n     *\n     * @param {String} str - String to be processed.\n     * @returns {String}\n     */\n    function unescape(str) {\n        return str.replace(/&lt;%|%3C%/g, '<%').replace(/%&gt;|%%3E/g, '%>');\n    }\n\n    /**\n     * If 'tmpl' is a valid selector, returns target node's innerHTML if found.\n     * Else, returns empty string and emits console warning.\n     * If 'tmpl' is not a selector, returns 'tmpl' as is.\n     *\n     * @param {String} tmpl\n     * @returns {String}\n     */\n    function getTmplString(tmpl) {\n        if (isSelector(tmpl)) {\n            tmpl = document.querySelector(tmpl);\n\n            if (tmpl) {\n                tmpl = tmpl.innerHTML.trim();\n            } else {\n                console.warn('No template was found by selector: ' + tmpl);\n\n                tmpl = '';\n            }\n        }\n\n        return unescape(tmpl);\n    }\n\n    /**\n     * Compiles or renders template provided either\n     * by selector or by the template string.\n     *\n     * @param {String} tmpl - Template string or selector.\n     * @param {(Object|Array|Function)} [data] - Data object with which to render template.\n     * @returns {String|Function}\n     */\n    return function (tmpl, data) {\n        var render;\n\n        tmpl   = getTmplString(tmpl);\n        render = _.template(tmpl);\n\n        return !_.isUndefined(data) ?\n            render(data) :\n            render;\n    };\n}));\n","mage/polyfill.js":"try {\n    if (!window.localStorage || !window.sessionStorage) {\n        throw new Error();\n    }\n\n    localStorage.setItem('storage_test', 1);\n    localStorage.removeItem('storage_test');\n} catch (e) {\n    (function () {\n        'use strict';\n\n        /**\n         * Returns a storage object to shim local or sessionStorage\n         * @param {String} type - either 'local' or 'session'\n         */\n        var Storage = function (type) {\n            var data;\n\n            /**\n             * Creates a cookie\n             * @param {String} name\n             * @param {String} value\n             * @param {Integer} days\n             */\n            function createCookie(name, value, days) {\n                var date, expires;\n\n                if (days) {\n                    date = new Date();\n                    date.setTime(date.getTime() + days * 24 * 60 * 60 * 1000);\n                    expires = '; expires=' + date.toGMTString();\n                } else {\n                    expires = '';\n                }\n                document.cookie = name + '=' + value + expires + '; path=/';\n            }\n\n            /**\n             * Reads value of a cookie\n             * @param {String} name\n             */\n            function readCookie(name) {\n                var nameEQ = name + '=',\n                    ca = document.cookie.split(';'),\n                    i = 0,\n                    c;\n\n                for (i = 0; i < ca.length; i++) {\n                    c = ca[i];\n\n                    while (c.charAt(0) === ' ') {\n                        c = c.substring(1, c.length);\n                    }\n\n                    if (c.indexOf(nameEQ) === 0) {\n                        return c.substring(nameEQ.length, c.length);\n                    }\n                }\n\n                return null;\n            }\n\n            /**\n             * Returns cookie name based upon the storage type.\n             * If this is session storage, the function returns a unique cookie per tab\n             */\n            function getCookieName() {\n\n                if (type !== 'session') {\n                    return 'localstorage';\n                }\n\n                if (!window.name) {\n                    window.name = new Date().getTime();\n                }\n\n                return 'sessionStorage' + window.name;\n            }\n\n            /**\n             * Sets storage cookie to a data object\n             * @param {Object} dataObject\n             */\n            function setData(dataObject) {\n                data = encodeURIComponent(JSON.stringify(dataObject));\n                createCookie(getCookieName(), data, 365);\n            }\n\n            /**\n             * Clears value of cookie data\n             */\n            function clearData() {\n                createCookie(getCookieName(), '', 365);\n            }\n\n            /**\n             * @returns value of cookie data\n             */\n            function getData() {\n                var dataResponse = readCookie(getCookieName());\n\n                return dataResponse ? JSON.parse(decodeURIComponent(dataResponse)) : {};\n            }\n\n            data = getData();\n\n            return {\n                length: 0,\n\n                /**\n                 * Clears data from storage\n                 */\n                clear: function () {\n                    data = {};\n                    this.length = 0;\n                    clearData();\n                },\n\n                /**\n                 * Gets an item from storage\n                 * @param {String} key\n                 */\n                getItem: function (key) {\n                    return data[key] === undefined ? null : data[key];\n                },\n\n                /**\n                 * Gets an item by index from storage\n                 * @param {Integer} i\n                 */\n                key: function (i) {\n                    var ctr = 0,\n                        k;\n\n                    for (k in data) {\n\n                        if (data.hasOwnProperty(k)) {\n\n                            // eslint-disable-next-line max-depth\n                            if (ctr.toString() === i.toString()) {\n                                return k;\n                            }\n                            ctr++;\n                        }\n                    }\n\n                    return null;\n                },\n\n                /**\n                 * Removes an item from storage\n                 * @param {String} key\n                 */\n                removeItem: function (key) {\n                    delete data[key];\n                    this.length--;\n                    setData(data);\n                },\n\n                /**\n                 * Sets an item from storage\n                 * @param {String} key\n                 * @param {String} value\n                 */\n                setItem: function (key, value) {\n                    data[key] = value.toString();\n                    this.length++;\n                    setData(data);\n                }\n            };\n        };\n\n        window.localStorage.prototype = window.localStorage = new Storage('local');\n        window.sessionStorage.prototype = window.sessionStorage = new Storage('session');\n    })();\n}\n","mage/smart-keyboard-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * @return {Object}\n     * @constructor\n     */\n    function KeyboardHandler() {\n        var body = $('body'),\n            focusState = false,\n            tabFocusClass = '_keyfocus',\n            productsGrid = '[data-container=\"product-grid\"]',\n            catalogProductsGrid = $(productsGrid),\n            CODE_TAB = 9;\n\n        /**\n         * Handle logic, when onTabKeyPress fired at first.\n         * Then it changes state.\n         */\n        function onFocusInHandler() {\n            focusState = true;\n            body.addClass(tabFocusClass)\n                .off('focusin.keyboardHandler', onFocusInHandler);\n        }\n\n        /**\n         * Handle logic to remove state after onTabKeyPress to normal.\n         */\n        function onClickHandler() {\n            focusState = false;\n            body.removeClass(tabFocusClass)\n                .off('click', onClickHandler);\n        }\n\n        /**\n         * Tab key onKeypress handler. Apply main logic:\n         *  - call differ actions onTabKeyPress and onClick\n         */\n        function smartKeyboardFocus() {\n            $(document).on('keydown keypress', function (event) {\n                if (event.which === CODE_TAB && !focusState) {\n                    body\n                        .on('focusin.keyboardHandler', onFocusInHandler)\n                        .on('click', onClickHandler);\n                }\n            });\n\n            // ARIA support for catalog grid products\n            if (catalogProductsGrid.length) {\n                body.on('focusin.gridProducts', productsGrid, function () {\n                    if (body.hasClass(tabFocusClass)) {\n                        $(this).addClass('active');\n                    }\n                });\n                body.on('focusout.gridProducts', productsGrid, function () {\n                    $(this).removeClass('active');\n                });\n            }\n        }\n\n        /**\n         * Attach smart focus on specific element.\n         * @param {jQuery} element\n         */\n        function handleFocus(element) {\n            element.on('focusin.emulateTabFocus', function () {\n                focusState = true;\n                body.addClass(tabFocusClass);\n                element.off();\n            });\n\n            element.on('focusout.emulateTabFocus', function () {\n                focusState = false;\n                body.removeClass(tabFocusClass);\n                element.off();\n            });\n        }\n\n        return {\n            apply: smartKeyboardFocus,\n            focus: handleFocus\n        };\n    }\n\n    return new KeyboardHandler;\n});\n","mage/popup-window.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.popupWindow', {\n        options: {\n            centerBrowser: 0, // center window over browser window? {1 (YES) or 0 (NO)}. overrides top and left\n            centerScreen: 0, // center window over entire screen? {1 (YES) or 0 (NO)}. overrides top and left\n            height: 500, // sets the height in pixels of the window.\n            left: 0, // left position when the window appears.\n            location: 0, // determines whether the address bar is displayed {1 (YES) or 0 (NO)}.\n            menubar: 0, // determines whether the menu bar is displayed {1 (YES) or 0 (NO)}.\n            resizable: 0, // whether the window can be resized {1 (YES) or 0 (NO)}.\n            scrollbars: 0, // determines whether scrollbars appear on the window {1 (YES) or 0 (NO)}.\n            status: 0, // whether a status line appears at the bottom of the window {1 (YES) or 0 (NO)}.\n            width: 500, // sets the width in pixels of the window.\n            windowName: null, // name of window set from the name attribute of the element that invokes the click\n            windowURL: null, // url used for the popup\n            top: 0, // top position when the window appears.\n            toolbar: 0 // determines whether a toolbar is displayed {1 (YES) or 0 (NO)}.\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', $.proxy(this._openPopupWindow, this));\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _openPopupWindow: function (event) {\n            var element = $(event.target),\n                settings = this.options,\n                windowFeatures =\n                    'height=' + settings.height +\n                        ',width=' + settings.width +\n                        ',toolbar=' + settings.toolbar +\n                        ',scrollbars=' + settings.scrollbars +\n                        ',status=' + settings.status +\n                        ',resizable=' + settings.resizable +\n                        ',location=' + settings.location +\n                        ',menuBar=' + settings.menubar,\n                centeredX,\n                centeredY;\n\n            settings.windowName = settings.windowName || element.attr('name');\n            settings.windowURL = settings.windowURL || element.attr('href');\n\n            if (settings.centerBrowser) {\n                centeredY = window.screenY + ((window.outerHeight / 2 - settings.height / 2));\n                centeredX = window.screenX + ((window.outerWidth / 2 - settings.width / 2));\n                windowFeatures += ',left=' + centeredX + ',top=' + centeredY;\n            } else if (settings.centerScreen) {\n                centeredY = (screen.height - settings.height) / 2;\n                centeredX = (screen.width - settings.width) / 2;\n                windowFeatures += ',left=' + centeredX + ',top=' + centeredY;\n            } else {\n                windowFeatures += ',left=' + settings.left + ',top=' + settings.top;\n            }\n\n            window.open(settings.windowURL, settings.windowName, windowFeatures).focus();\n            event.preventDefault();\n        }\n    });\n\n    return $.mage.popupWindow;\n});\n","mage/tabs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'jquery-ui-modules/core',\n    'mage/mage',\n    'mage/collapsible'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.tabs', {\n        options: {\n            active: 0,\n            disabled: [],\n            openOnFocus: true,\n            collapsible: false,\n            collapsibleElement: '[data-role=collapsible]',\n            header: '[data-role=title]',\n            content: '[data-role=content]',\n            trigger: '[data-role=trigger]',\n            closedState: null,\n            openedState: null,\n            disabledState: null,\n            ajaxUrlElement: '[data-ajax=true]',\n            ajaxContent: false,\n            loadingClass: null,\n            saveState: false,\n            animate: false,\n            icons: {\n                activeHeader: null,\n                header: null\n            }\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            if (typeof this.options.disabled === 'string') {\n                this.options.disabled = this.options.disabled.split(' ').map(function (item) {\n                    return parseInt(item, 10);\n                });\n            }\n            this._processPanels();\n            this._handleDeepLinking();\n            this._processTabIndex();\n            this._closeOthers();\n            this._bind();\n        },\n\n        /**\n         * @private\n         */\n        _destroy: function () {\n            $.each(this.collapsibles, function () {\n                $(this).collapsible('destroy');\n            });\n        },\n\n        /**\n         * If deep linking is used, all sections must be closed but the one that contains the anchor.\n         * @private\n         */\n        _handleDeepLinking: function () {\n            var self = this,\n                anchor = window.location.hash,\n                isValid = $.mage.isValidSelector(anchor),\n                anchorId = anchor.replace('#', '');\n\n            if (anchor && isValid) {\n                $.each(self.contents, function (i) {\n                    if ($(this).attr('id') === anchorId || $(this).find('#' + anchorId).length) {\n                        self.collapsibles.not(self.collapsibles.eq(i)).collapsible('forceDeactivate');\n\n                        return false;\n                    }\n                });\n            }\n        },\n\n        /**\n         * When the widget gets instantiated, the first tab that is not disabled receive focusable property\n         * All tabs receive tabIndex 0\n         * @private\n         */\n        _processTabIndex: function () {\n            var self = this;\n\n            self.triggers.attr('tabIndex', 0);\n            $.each(this.collapsibles, function (i) {\n                self.triggers.attr('tabIndex', 0);\n                self.triggers.eq(i).attr('tabIndex', 0);\n            });\n        },\n\n        /**\n         * Prepare the elements for instantiating the collapsible widget\n         * @private\n         */\n        _processPanels: function () {\n            this.contents = this.element.find(this.options.content);\n\n            this.collapsibles = this.element.find(this.options.collapsibleElement);\n\n            this.collapsibles\n                .attr('role', 'presentation')\n                .parent()\n                .attr('role', 'tablist');\n\n            this.headers = this.element.find(this.options.header);\n\n            if (this.headers.length === 0) {\n                this.headers = this.collapsibles;\n            }\n            this.triggers = this.element.find(this.options.trigger);\n\n            if (this.triggers.length === 0) {\n                this.triggers = this.headers;\n            }\n            this._callCollapsible();\n        },\n\n        /**\n         * Setting the disabled and active tabs and calling instantiation of collapsible\n         * @private\n         */\n        _callCollapsible: function () {\n            var self = this,\n                disabled = false,\n                active = false;\n\n            $.each(this.collapsibles, function (i) {\n                disabled = active = false;\n\n                if ($.inArray(i, self.options.disabled) !== -1) {\n                    disabled = true;\n                }\n\n                if (i === self.options.active) {\n                    active = true;\n                }\n                self._instantiateCollapsible(this, i, active, disabled);\n            });\n        },\n\n        /**\n         * Instantiate collapsible.\n         *\n         * @param {HTMLElement} element\n         * @param {Number} index\n         * @param {*} active\n         * @param {*} disabled\n         * @private\n         */\n        _instantiateCollapsible: function (element, index, active, disabled) {\n            $(element).collapsible(\n                $.extend({}, this.options, {\n                    active: active,\n                    disabled: disabled,\n                    header: this.headers.eq(index),\n                    content: this.contents.eq(index),\n                    trigger: this.triggers.eq(index)\n                })\n            );\n        },\n\n        /**\n         * Adding callback to close others tabs when one gets opened\n         * @private\n         */\n        _closeOthers: function () {\n            var self = this;\n\n            $.each(this.collapsibles, function () {\n                $(this).on('beforeOpen', function () {\n                    self.collapsibles.not(this).collapsible('forceDeactivate');\n                });\n            });\n        },\n\n        /**\n         * @param {*} index\n         */\n        activate: function (index) {\n            this._toggleActivate('activate', index);\n        },\n\n        /**\n         * @param {*} index\n         */\n        deactivate: function (index) {\n            this._toggleActivate('deactivate', index);\n        },\n\n        /**\n         * @param {*} action\n         * @param {*} index\n         * @private\n         */\n        _toggleActivate: function (action, index) {\n            this.collapsibles.eq(index).collapsible(action);\n        },\n\n        /**\n         * @param {*} index\n         */\n        disable: function (index) {\n            this._toggleEnable('disable', index);\n        },\n\n        /**\n         * @param {*} index\n         */\n        enable: function (index) {\n            this._toggleEnable('enable', index);\n        },\n\n        /**\n         * @param {*} action\n         * @param {*} index\n         * @private\n         */\n        _toggleEnable: function (action, index) {\n            var self = this;\n\n            if ($.isArray(index)) {\n                $.each(index, function () {\n                    self.collapsibles.eq(this).collapsible(action);\n                });\n            } else if (index === undefined) {\n                this.collapsibles.collapsible(action);\n            } else {\n                this.collapsibles.eq(index).collapsible(action);\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _keydown: function (event) {\n            var self = this,\n                keyCode, toFocus, toFocusIndex, enabledTriggers, length, currentIndex, nextToFocus;\n\n            if (event.altKey || event.ctrlKey) {\n                return;\n            }\n            keyCode = $.ui.keyCode;\n            toFocus = false;\n            enabledTriggers = [];\n\n            $.each(this.triggers, function () {\n                if (!self.collapsibles.eq(self.triggers.index($(this))).collapsible('option', 'disabled')) {\n                    enabledTriggers.push(this);\n                }\n            });\n            length = $(enabledTriggers).length;\n            currentIndex = $(enabledTriggers).index(event.target);\n\n            /**\n             * @param {String} direction\n             * @return {*}\n             */\n            nextToFocus = function (direction) {\n                if (length > 0) {\n                    if (direction === 'right') {\n                        toFocusIndex = (currentIndex + 1) % length;\n                    } else {\n                        toFocusIndex = (currentIndex + length - 1) % length;\n                    }\n\n                    return enabledTriggers[toFocusIndex];\n                }\n\n                return event.target;\n            };\n\n            switch (event.keyCode) {\n                case keyCode.RIGHT:\n                case keyCode.DOWN:\n                    toFocus = nextToFocus('right');\n                    break;\n\n                case keyCode.LEFT:\n                case keyCode.UP:\n                    toFocus = nextToFocus('left');\n                    break;\n\n                case keyCode.HOME:\n                    toFocus = enabledTriggers[0];\n                    break;\n\n                case keyCode.END:\n                    toFocus = enabledTriggers[length - 1];\n                    break;\n            }\n\n            if (toFocus) {\n                toFocusIndex = this.triggers.index(toFocus);\n                $(event.target).attr('tabIndex', -1);\n                $(toFocus).attr('tabIndex', 0);\n                toFocus.focus();\n\n                if (this.options.openOnFocus) {\n                    this.activate(toFocusIndex);\n                }\n                event.preventDefault();\n            }\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            var events = {\n                keydown: '_keydown'\n            };\n\n            this._off(this.triggers);\n            this._on(this.triggers, events);\n        }\n    });\n\n    return $.mage.tabs;\n});\n","mage/url.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable strict */\ndefine([], function () {\n    var baseUrl = '';\n\n    return {\n        /**\n         * @param {String} url\n         */\n        setBaseUrl: function (url) {\n            baseUrl = url;\n        },\n\n        /**\n         * @param {String} path\n         * @return {*}\n         */\n        build: function (path) {\n            if (path.indexOf(baseUrl) !== -1) {\n                return path;\n            }\n\n            return baseUrl + path;\n        }\n    };\n});\n","mage/storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery', 'mage/url'], function ($, urlBuilder) {\n    'use strict';\n\n    return {\n        /**\n         * Perform asynchronous GET request to server.\n         * @param {String} url\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        get: function (url, global, contentType) {\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'GET',\n                global: global,\n                contentType: contentType\n            });\n        },\n\n        /**\n         * Perform asynchronous POST request to server.\n         * @param {String} url\n         * @param {String} data\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        post: function (url, data, global, contentType) {\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'POST',\n                data: data,\n                global: global,\n                contentType: contentType\n            });\n        },\n\n        /**\n         * Perform asynchronous PUT request to server.\n         * @param {String} url\n         * @param {String} data\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        put: function (url, data, global, contentType, headers) {\n            var ajaxSettings = {};\n\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n            ajaxSettings.url = urlBuilder.build(url);\n            ajaxSettings.type = 'PUT';\n            ajaxSettings.data = data;\n            ajaxSettings.global = global;\n            ajaxSettings.contentType = contentType;\n\n            if (headers) {\n                ajaxSettings.headers = headers;\n            }\n\n            return $.ajax(ajaxSettings);\n        },\n\n        /**\n         * Perform asynchronous DELETE request to server.\n         * @param {String} url\n         * @param {Boolean} global\n         * @param {String} contentType\n         * @returns {Deferred}\n         */\n        delete: function (url, global, contentType) {\n            global = global === undefined ? true : global;\n            contentType = contentType || 'application/json';\n\n            return $.ajax({\n                url: urlBuilder.build(url),\n                type: 'DELETE',\n                global: global,\n                contentType: contentType\n            });\n        }\n    };\n});\n","mage/collapsible.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'jquery-ui-modules/core',\n    'jquery/jquery-storageapi',\n    'mage/mage'\n], function ($) {\n    'use strict';\n\n    var hideProps = {},\n        showProps = {};\n\n    hideProps.height =  'hide';\n    showProps.height =  'show';\n\n    $.widget('mage.collapsible', {\n        options: {\n            active: false,\n            disabled: false,\n            collapsible: true,\n            header: '[data-role=title]',\n            content: '[data-role=content]',\n            trigger: '[data-role=trigger]',\n            closedState: null,\n            openedState: null,\n            disabledState: null,\n            ajaxUrlElement: '[data-ajax=true]',\n            ajaxContent: false,\n            loadingClass: null,\n            saveState: false,\n            animate: false,\n            icons: {\n                activeHeader: null,\n                header: null\n            },\n            collateral: {\n                element: null,\n                openedState: null\n            }\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this.storage = $.localStorage;\n            this.icons = false;\n\n            if (typeof this.options.icons === 'string') {\n                this.options.icons = $.parseJSON(this.options.icons);\n            }\n\n            this._processPanels();\n            this._processState();\n            this._refresh();\n\n            if (this.options.icons.header && this.options.icons.activeHeader) {\n                this._createIcons();\n                this.icons = true;\n            }\n\n            this.element.on('dimensionsChanged', function (e) {\n                if (e.target && e.target.classList.contains('active')) {\n                    this._scrollToTopIfVisible(e.target);\n                }\n            }.bind(this));\n\n            this._bind('click');\n            this._trigger('created');\n        },\n\n        /**\n         * @private\n         */\n        _refresh: function () {\n            this.trigger.attr('tabIndex', 0);\n\n            if (this.options.active && !this.options.disabled) {\n                if (this.options.openedState) {\n                    this.element.addClass(this.options.openedState);\n                }\n\n                if (this.options.collateral.element && this.options.collateral.openedState) {\n                    $(this.options.collateral.element).addClass(this.options.collateral.openedState);\n                }\n\n                if (this.options.ajaxContent) {\n                    this._loadContent();\n                }\n                // ARIA (updates aria attributes)\n                this.header.attr({\n                    'aria-selected': false\n                });\n            } else if (this.options.disabled) {\n                this.disable();\n            } else {\n                this.content.hide();\n\n                if (this.options.closedState) {\n                    this.element.addClass(this.options.closedState);\n                }\n            }\n        },\n\n        /**\n         * Processing the state:\n         *     If deep linking is used and the anchor is the id of the content or the content contains this id,\n         *     and the collapsible element is a nested one having collapsible parents, in order to see the content,\n         *     all the parents must be expanded.\n         * @private\n         */\n        _processState: function () {\n            var anchor = window.location.hash,\n                isValid = $.mage.isValidSelector(anchor),\n                urlPath = window.location.pathname.replace(/\\./g, ''),\n                state;\n\n            this.stateKey = encodeURIComponent(urlPath + this.element.attr('id'));\n\n            if (isValid &&\n                ($(this.content.find(anchor)).length > 0 || this.content.attr('id') === anchor.replace('#', ''))\n            ) {\n                this.element.parents('[data-collapsible=true]').collapsible('forceActivate');\n\n                if (!this.options.disabled) {\n                    this.options.active = true;\n\n                    if (this.options.saveState) { //eslint-disable-line max-depth\n                        this.storage.set(this.stateKey, true);\n                    }\n                }\n            } else if (this.options.saveState && !this.options.disabled) {\n                state = this.storage.get(this.stateKey);\n\n                if (typeof state === 'undefined' || state === null) {\n                    this.storage.set(this.stateKey, this.options.active);\n                } else if (state === true) {\n                    this.options.active = true;\n                } else if (state === false) {\n                    this.options.active = false;\n                }\n            }\n        },\n\n        /**\n         * @private\n         */\n        _createIcons: function () {\n            var icons = this.options.icons;\n\n            if (icons) {\n                $('<span>')\n                    .addClass(icons.header)\n                    .attr('data-role', 'icons')\n                    .prependTo(this.header);\n\n                if (this.options.active && !this.options.disabled) {\n                    this.header.children('[data-role=icons]')\n                        .removeClass(icons.header)\n                        .addClass(icons.activeHeader);\n                }\n            }\n        },\n\n        /**\n         * @private\n         */\n        _destroyIcons: function () {\n            this.header\n                .children('[data-role=icons]')\n                .remove();\n        },\n\n        /**\n         * @private\n         */\n        _destroy: function () {\n            var options = this.options;\n\n            this.element.removeAttr('data-collapsible');\n\n            this.trigger.removeAttr('tabIndex');\n\n            if (options.openedState) {\n                this.element.removeClass(options.openedState);\n            }\n\n            if (this.options.collateral.element && this.options.collateral.openedState) {\n                $(this.options.collateral.element).removeClass(this.options.collateral.openedState);\n            }\n\n            if (options.closedState) {\n                this.element.removeClass(options.closedState);\n            }\n\n            if (options.disabledState) {\n                this.element.removeClass(options.disabledState);\n            }\n\n            if (this.icons) {\n                this._destroyIcons();\n            }\n        },\n\n        /**\n         * @private\n         */\n        _processPanels: function () {\n            var headers, triggers;\n\n            this.element.attr('data-collapsible', 'true');\n\n            if (typeof this.options.header === 'object') {\n                this.header = this.options.header;\n            } else {\n                headers = this.element.find(this.options.header);\n\n                if (headers.length > 0) {\n                    this.header = headers.eq(0);\n                } else {\n                    this.header = this.element;\n                }\n            }\n\n            if (typeof this.options.content === 'object') {\n                this.content = this.options.content;\n            } else {\n                this.content = this.header.next(this.options.content).eq(0);\n            }\n\n            // ARIA (init aria attributes)\n            if (this.header.attr('id')) {\n                this.content.attr('aria-labelledby', this.header.attr('id'));\n            }\n\n            if (this.content.attr('id')) {\n                this.header.attr('aria-controls', this.content.attr('id'));\n            }\n\n            this.header\n                .attr({\n                    'role': 'tab',\n                    'aria-selected': this.options.active,\n                    'aria-expanded': this.options.active\n                });\n\n            // For collapsible widget only (not tabs or accordion)\n            if (this.header.parent().attr('role') !== 'presentation') {\n                this.header\n                    .parent()\n                    .attr('role', 'tablist');\n            }\n\n            this.content.attr({\n                'role': 'tabpanel',\n                'aria-hidden': !this.options.active\n            });\n\n            if (typeof this.options.trigger === 'object') {\n                this.trigger = this.options.trigger;\n            } else {\n                triggers = this.header.find(this.options.trigger);\n\n                if (triggers.length > 0) {\n                    this.trigger = triggers.eq(0);\n                } else {\n                    this.trigger = this.header;\n                }\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _keydown: function (event) {\n            var keyCode;\n\n            if (event.altKey || event.ctrlKey) {\n                return;\n            }\n\n            keyCode = $.ui.keyCode;\n\n            switch (event.keyCode) {\n                case keyCode.SPACE:\n                case keyCode.ENTER:\n                    this._eventHandler(event);\n                    break;\n            }\n\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _bind: function (event) {\n            var self = this;\n\n            this.events = {\n                keydown: '_keydown'\n            };\n\n            if (event) {\n                $.each(event.split(' '), function (index, eventName) {\n                    self.events[ eventName ] = '_eventHandler';\n                });\n            }\n            this._off(this.trigger);\n\n            if (!this.options.disabled) {\n                this._on(this.trigger, this.events);\n            }\n        },\n\n        /**\n         * Disable.\n         */\n        disable: function () {\n            this.options.disabled = true;\n            this._off(this.trigger);\n            this.forceDeactivate();\n\n            if (this.options.disabledState) {\n                this.element.addClass(this.options.disabledState);\n            }\n            this.trigger.attr('tabIndex', -1);\n        },\n\n        /**\n         * Enable.\n         */\n        enable: function () {\n            this.options.disabled = false;\n            this._on(this.trigger, this.events);\n            this.forceActivate();\n\n            if (this.options.disabledState) {\n                this.element.removeClass(this.options.disabledState);\n            }\n            this.trigger.attr('tabIndex', 0);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _eventHandler: function (event) {\n\n            if (this.options.active && this.options.collapsible) {\n                this.deactivate();\n            } else {\n                this.activate();\n\n            }\n            event.preventDefault();\n\n        },\n\n        /**\n         * @param {*} prop\n         * @private\n         */\n        _animate: function (prop) {\n            var duration,\n                easing,\n                animate = this.options.animate;\n\n            if (typeof animate === 'number') {\n                duration = animate;\n            }\n\n            if (typeof animate === 'string') {\n                animate = $.parseJSON(animate);\n            }\n            duration = duration || animate.duration;\n            easing = animate.easing;\n            this.content.animate(prop, duration, easing);\n        },\n\n        /**\n         * Deactivate.\n         */\n        deactivate: function () {\n            if (this.options.animate) {\n                this._animate(hideProps);\n            } else {\n                this.content.hide();\n            }\n            this._close();\n        },\n\n        /**\n         * Force deactivate.\n         */\n        forceDeactivate: function () {\n            this.content.hide();\n            this._close();\n\n        },\n\n        /**\n         * @private\n         */\n        _close: function () {\n            this.options.active = false;\n\n            if (this.options.saveState) {\n                this.storage.set(this.stateKey, false);\n            }\n\n            if (this.options.openedState) {\n                this.element.removeClass(this.options.openedState);\n            }\n\n            if (this.options.collateral.element && this.options.collateral.openedState) {\n                $(this.options.collateral.element).removeClass(this.options.collateral.openedState);\n            }\n\n            if (this.options.closedState) {\n                this.element.addClass(this.options.closedState);\n            }\n\n            if (this.icons) {\n                this.header.children('[data-role=icons]')\n                    .removeClass(this.options.icons.activeHeader)\n                    .addClass(this.options.icons.header);\n            }\n\n            // ARIA (updates aria attributes)\n            this.header.attr({\n                'aria-selected': 'false',\n                'aria-expanded': 'false'\n            });\n            this.content.attr({\n                'aria-hidden': 'true'\n            });\n\n            this.element.trigger('dimensionsChanged', {\n                opened: false\n            });\n        },\n\n        /**\n         * Activate.\n         *\n         * @return void;\n         */\n        activate: function () {\n            if (this.options.disabled) {\n                return;\n            }\n\n            if (this.options.animate) {\n                this._animate(showProps);\n            } else {\n                this.content.show();\n            }\n            this._open();\n        },\n\n        /**\n         * Force activate.\n         */\n        forceActivate: function () {\n            if (!this.options.disabled) {\n                this.content.show();\n                this._open();\n            }\n        },\n\n        /**\n         * @private\n         */\n        _open: function () {\n            this.element.trigger('beforeOpen');\n            this.options.active = true;\n\n            if (this.options.ajaxContent) {\n                this._loadContent();\n            }\n\n            if (this.options.saveState) {\n                this.storage.set(this.stateKey, true);\n            }\n\n            if (this.options.openedState) {\n                this.element.addClass(this.options.openedState);\n            }\n\n            if (this.options.collateral.element && this.options.collateral.openedState) {\n                $(this.options.collateral.element).addClass(this.options.collateral.openedState);\n            }\n\n            if (this.options.closedState) {\n                this.element.removeClass(this.options.closedState);\n            }\n\n            if (this.icons) {\n                this.header.children('[data-role=icons]')\n                    .removeClass(this.options.icons.header)\n                    .addClass(this.options.icons.activeHeader);\n            }\n\n            // ARIA (updates aria attributes)\n            this.header.attr({\n                'aria-selected': 'true',\n                'aria-expanded': 'true'\n            });\n            this.content.attr({\n                'aria-hidden': 'false'\n            });\n\n            this.element.trigger('dimensionsChanged', {\n                opened: true\n            });\n        },\n\n        /**\n         * @private\n         */\n        _loadContent: function () {\n            var url = this.element.find(this.options.ajaxUrlElement).attr('href'),\n                that = this;\n\n            if (url) {\n                that.xhr = $.get({\n                    url: url,\n                    dataType: 'html'\n                }, function () {\n                });\n            }\n\n            if (that.xhr && that.xhr.statusText !== 'canceled') {\n                if (that.options.loadingClass) {\n                    that.element.addClass(that.options.loadingClass);\n                }\n                that.content.attr('aria-busy', 'true');\n                that.xhr.done(function (response) {\n                    setTimeout(function () {\n                        that.content.html(response);\n                    }, 1);\n                });\n                that.xhr.always(function (jqXHR, status) {\n                    setTimeout(function () {\n                        if (status === 'abort') {\n                            that.content.stop(false, true);\n                        }\n\n                        if (that.options.loadingClass) {\n                            that.element.removeClass(that.options.loadingClass);\n                        }\n                        that.content.removeAttr('aria-busy');\n\n                        if (jqXHR === that.xhr) {\n                            delete that.xhr;\n                        }\n                    }, 1);\n                });\n            }\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         */\n        _scrollToTopIfVisible: function (elem) {\n            if (!this._isElementOutOfViewport(elem)) {\n                elem.scrollIntoView();\n            }\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @private\n         * @return {Boolean}\n         */\n        _isElementOutOfViewport: function (elem) {\n            var rect = elem.getBoundingClientRect();\n\n            return rect.bottom < 0 || rect.right < 0 || rect.left > window.innerWidth || rect.top > window.innerHeight;\n        }\n    });\n\n    return $.mage.collapsible;\n});\n","mage/translate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable strict */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'mage/mage'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    $.extend(true, $, {\n        mage: {\n            translate: (function () {\n                /**\n                 * Key-value translations storage\n                 * @type {Object}\n                 * @private\n                 */\n                var _data = {};\n\n                /**\n                 * Add new translation (two string parameters) or several translations (object)\n                 */\n                this.add = function () {\n                    if (arguments.length > 1) {\n                        _data[arguments[0]] = arguments[1];\n                    } else if (typeof arguments[0] === 'object') {\n                        $.extend(_data, arguments[0]);\n                    }\n                };\n\n                /**\n                 * Make a translation with parsing (to handle case when _data represents tuple)\n                 * @param {String} text\n                 * @return {String}\n                 */\n                this.translate = function (text) {\n                    return _data[text] ? _data[text] : text;\n                };\n\n                return this;\n            }())\n        }\n    });\n    $.mage.__ = $.proxy($.mage.translate.translate, $.mage.translate);\n\n    return $.mage.__;\n}));\n","mage/mage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'mage/apply/main'\n        ], factory);\n    } else {\n        factory(root.jQuery);\n    }\n}(this, function ($, mage) {\n    'use strict';\n\n    /**\n     * Main namespace for Magento extensions\n     * @type {Object}\n     */\n    $.mage = $.mage || {};\n\n    /**\n     * Plugin mage, initialize components on elements\n     * @param {String} name - Components' path.\n     * @param {Object} config - Components' config.\n     * @returns {JQuery} Chainable.\n     */\n    $.fn.mage = function (name, config) {\n        config = config || {};\n\n        this.each(function (index, el) {\n            mage.applyFor(el, config, name);\n        });\n\n        return this;\n    };\n\n    $.extend($.mage, {\n        /**\n         * Handle all components declared via data attribute\n         * @return {Object} $.mage\n         */\n        init: function () {\n            mage.apply();\n\n            return this;\n        },\n\n        /**\n         * Method handling redirects and page refresh\n         * @param {String} url - redirect URL\n         * @param {(undefined|String)} type - 'assign', 'reload', 'replace'\n         * @param {(undefined|Number)} timeout - timeout in milliseconds before processing the redirect or reload\n         * @param {(undefined|Boolean)} forced - true|false used for 'reload' only\n         */\n        redirect: function (url, type, timeout, forced) {\n            var _redirect;\n\n            forced  = !!forced;\n            timeout = timeout || 0;\n            type    = type || 'assign';\n\n            /**\n             * @private\n             */\n            _redirect = function () {\n                window.location[type](type === 'reload' ? forced : url);\n            };\n\n            timeout ? setTimeout(_redirect, timeout) : _redirect();\n        },\n\n        /**\n         * Checks if provided string is a valid selector.\n         * @param {String} selector - Selector to check.\n         * @returns {Boolean}\n         */\n        isValidSelector: function (selector) {\n            try {\n                document.querySelector(selector);\n\n                return true;\n            } catch (e) {\n                return false;\n            }\n        }\n    });\n\n    /**\n     * Init components inside of dynamically updated elements\n     */\n    $('body').on('contentUpdated', function () {\n        if (mage) {\n            mage.apply();\n        }\n    });\n\n    return $.mage;\n}));\n","mage/edit-trigger.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'mage/template',\n            'jquery-ui-modules/widget'\n        ], factory);\n    } else {\n        factory(root.jQuery, root.mageTemplate);\n    }\n}(this, function ($, mageTemplate) {\n    'use strict';\n\n    var editTriggerPrototype;\n\n    $.widget('mage.editTrigger', {\n        options: {\n            img: '',\n            alt: '[TR]',\n            template: '#translate-inline-icon',\n            zIndex: 2000,\n            editSelector: '[data-translate]',\n            delay: 2000,\n            offsetTop: -3,\n            singleElement: true\n        },\n\n        /**\n         * editTriger creation\n         * @protected\n         */\n        _create: function () {\n            this.tmpl = mageTemplate(this.options.template);\n            this._initTrigger();\n            this._bind();\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _getCss: function () {\n            return {\n                position: 'absolute',\n                cursor: 'pointer',\n                display: 'none',\n                'z-index': this.options.zIndex\n            };\n        },\n\n        /**\n         * @param {*} appendTo\n         * @return {*|jQuery}\n         * @private\n         */\n        _createTrigger: function (appendTo) {\n            var tmpl = this.tmpl({\n                data: this.options\n            });\n\n            return $(tmpl)\n                .css(this._getCss())\n                .data('role', 'edit-trigger-element')\n                .appendTo(appendTo);\n        },\n\n        /**\n         * @private\n         */\n        _initTrigger: function () {\n            this.trigger = this._createTrigger($('body'));\n        },\n\n        /**\n         * Bind on mousemove event\n         * @protected\n         */\n        _bind: function () {\n            this.trigger.on('click.' + this.widgetName, $.proxy(this._onClick, this));\n            this.element.on('mousemove.' + this.widgetName, $.proxy(this._onMouseMove, this));\n        },\n\n        /**\n         * Show editTriger\n         */\n        show: function () {\n            if (this.trigger.is(':hidden')) {\n                this.trigger.show();\n            }\n        },\n\n        /**\n         * Hide editTriger\n         */\n        hide: function () {\n            this.currentTarget = null;\n\n            if (this.trigger && this.trigger.is(':visible')) {\n                this.trigger.hide();\n            }\n        },\n\n        /**\n         * Set editTriger position\n         * @protected\n         */\n        _setPosition: function (el) {\n            var offset = el.offset();\n\n            this.trigger.css({\n                top: offset.top + el.outerHeight() + this.options.offsetTop,\n                left: offset.left\n            });\n        },\n\n        /**\n         * Show/hide trigger on mouse move.\n         *\n         * @param {jQuery.Event} e\n         * @protected\n         */\n        _onMouseMove: function (e) {\n            var target = $(e.target),\n                inner = target.find(this.options.editSelector);\n\n            if ($(e.target).is('button') && inner.length) {\n                target = inner;\n            } else if (!target.is(this.trigger) && !target.is(this.options.editSelector)) {\n                target = target.parents(this.options.editSelector).first();\n            }\n\n            if (target.length) {\n                if (!target.is(this.trigger)) {\n                    this._setPosition(target);\n                    this.currentTarget = target;\n                }\n                this.show();\n            } else {\n                this.hide();\n            }\n        },\n\n        /**\n         * Trigger event \"edit\" on element for translate.\n         *\n         * @param {jQuery.Event} e\n         * @protected\n         */\n        _onClick: function (e) {\n            e.preventDefault();\n            e.stopImmediatePropagation();\n            $(this.currentTarget).trigger('edit.' + this.widgetName);\n            this.hide(true);\n        },\n\n        /**\n         * Destroy editTriger\n         */\n        destroy: function () {\n            this.trigger.remove();\n            this.element.off('.' + this.widgetName);\n\n            return $.Widget.prototype.destroy.call(this);\n        }\n    });\n\n    /**\n     * Extention for widget editTrigger - hide trigger with delay\n     */\n    editTriggerPrototype = $.mage.editTrigger.prototype;\n\n    $.widget('mage.editTrigger', $.extend({}, editTriggerPrototype, {\n        /**\n         * Added clear timeout on trigger show\n         */\n        show: function () {\n            editTriggerPrototype.show.apply(this, arguments);\n\n            if (this.options.delay) {\n                this._clearTimer();\n            }\n        },\n\n        /**\n         * Added setTimeout on trigger hide\n         */\n        hide: function (immediate) {\n            if (!immediate && this.options.delay) {\n                if (!this.timer) {\n                    this.timer = setTimeout($.proxy(function () {\n                        editTriggerPrototype.hide.apply(this, arguments);\n                        this._clearTimer();\n                    }, this), this.options.delay);\n                }\n            } else {\n                editTriggerPrototype.hide.apply(this, arguments);\n            }\n        },\n\n        /**\n         * Clear timer\n         * @protected\n         */\n        _clearTimer: function () {\n            if (this.timer) {\n                clearTimeout(this.timer);\n                this.timer = null;\n            }\n        }\n    }));\n\n    return $.mage.editTrigger;\n}));\n","mage/validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function (factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'moment',\n            'jquery-ui-modules/widget',\n            'jquery/validate',\n            'mage/translate'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($, moment) {\n    'use strict';\n\n    var creditCartTypes, rules, showLabel, originValidateDelegate;\n\n    $.extend(true, $, {\n        // @TODO: Move methods 'isEmpty', 'isEmptyNoTrim', 'parseNumber', 'stripHtml' in file with utility functions\n        mage: {\n            /**\n             * Check if string is empty with trim\n             * @param {String} value\n             */\n            isEmpty: function (value) {\n                return value === '' || value === undefined ||\n                    value == null || value.length === 0 || /^\\s+$/.test(value);\n            },\n\n            /**\n             * Check if string is empty no trim\n             * @param {String} value\n             */\n            isEmptyNoTrim: function (value) {\n                return value === '' || value == null || value.length === 0;\n            },\n\n            /**\n             * Checks if {value} is between numbers {from} and {to}\n             * @param {String} value\n             * @param {String} from\n             * @param {String} to\n             * @returns {Boolean}\n             */\n            isBetween: function (value, from, to) {\n                return ($.mage.isEmpty(from) || value >= $.mage.parseNumber(from)) &&\n                    ($.mage.isEmpty(to) || value <= $.mage.parseNumber(to));\n            },\n\n            /**\n             * Parse price string\n             * @param {String} value\n             */\n            parseNumber: function (value) {\n                var isDot, isComa;\n\n                if (typeof value !== 'string') {\n                    return parseFloat(value);\n                }\n                isDot = value.indexOf('.');\n                isComa = value.indexOf(',');\n\n                if (isDot !== -1 && isComa !== -1) {\n                    if (isComa > isDot) {\n                        value = value.replace('.', '').replace(',', '.');\n                    } else {\n                        value = value.replace(',', '');\n                    }\n                } else if (isComa !== -1) {\n                    value = value.replace(',', '.');\n                }\n\n                return parseFloat(value);\n            },\n\n            /**\n             * Removes HTML tags and space characters, numbers and punctuation.\n             *\n             * @param {String} value - Value being stripped.\n             * @return {String}\n             */\n            stripHtml: function (value) {\n                return value.replace(/<.[^<>]*?>/g, ' ').replace(/&nbsp;|&#160;/gi, ' ')\n                    .replace(/[0-9.(),;:!?%#$'\"_+=\\/-]*/g, '');\n            }\n        }\n    });\n\n    /**\n     * @param {String} name\n     * @param {*} method\n     * @param {*} message\n     * @param {*} dontSkip\n     */\n    $.validator.addMethod = function (name, method, message, dontSkip) {\n        $.validator.methods[name] = method;\n        $.validator.messages[name] = message !== undefined ? message : $.validator.messages[name];\n\n        if (method.length < 3 || dontSkip) {\n            $.validator.addClassRules(name, $.validator.normalizeRule(name));\n        }\n    };\n\n    /**\n     * Javascript object with credit card types\n     * 0 - regexp for card number\n     * 1 - regexp for cvn\n     * 2 - check or not credit card number trough Luhn algorithm by\n     */\n    creditCartTypes = {\n        'SO': [\n            new RegExp('^(6334[5-9]([0-9]{11}|[0-9]{13,14}))|(6767([0-9]{12}|[0-9]{14,15}))$'),\n            new RegExp('^([0-9]{3}|[0-9]{4})?$'),\n            true\n        ],\n        'SM': [\n            new RegExp('(^(5[0678])[0-9]{11,18}$)|(^(6[^05])[0-9]{11,18}$)|' +\n                '(^(601)[^1][0-9]{9,16}$)|(^(6011)[0-9]{9,11}$)|(^(6011)[0-9]{13,16}$)|' +\n                '(^(65)[0-9]{11,13}$)|(^(65)[0-9]{15,18}$)|(^(49030)[2-9]([0-9]{10}$|[0-9]{12,13}$))|' +\n                '(^(49033)[5-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49110)[1-2]([0-9]{10}$|[0-9]{12,13}$))|' +\n                '(^(49117)[4-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49118)[0-2]([0-9]{10}$|[0-9]{12,13}$))|' +\n                '(^(4936)([0-9]{12}$|[0-9]{14,15}$))'), new RegExp('^([0-9]{3}|[0-9]{4})?$'),\n            true\n        ],\n        'VI': [new RegExp('^4[0-9]{12}([0-9]{3})?$'), new RegExp('^[0-9]{3}$'), true],\n        'MC': [\n            new RegExp('^(?:5[1-5][0-9]{2}|222[1-9]|22[3-9][0-9]|2[3-6][0-9]{2}|27[01][0-9]|2720)[0-9]{12}$'),\n            new RegExp('^[0-9]{3}$'),\n            true\n        ],\n        'AE': [new RegExp('^3[47][0-9]{13}$'), new RegExp('^[0-9]{4}$'), true],\n        'DI': [new RegExp('^(6011(0|[2-4]|74|7[7-9]|8[6-9]|9)|6(4[4-9]|5))\\\\d*$'), new RegExp('^[0-9]{3}$'), true],\n        'JCB': [new RegExp('^35(2[8-9]|[3-8])\\\\d*$'), new RegExp('^[0-9]{3}$'), true],\n        'DN': [new RegExp('^(3(0[0-5]|095|6|[8-9]))\\\\d*$'), new RegExp('^[0-9]{3}$'), true],\n        'UN': [\n            new RegExp('^(622(1(2[6-9]|[3-9])|[3-8]|9([[0-1]|2[0-5]))|62[4-6]|628([2-8]))\\\\d*?$'),\n            new RegExp('^[0-9]{3}$'),\n            true\n        ],\n        'MI': [new RegExp('^(5(0|[6-9])|63|67(?!59|6770|6774))\\\\d*$'), new RegExp('^[0-9]{3}$'), true],\n        'MD': [new RegExp('^6759(?!24|38|40|6[3-9]|70|76)|676770|676774\\\\d*$'), new RegExp('^[0-9]{3}$'), true]\n    };\n\n    /**\n     * validate credit card number using mod10\n     * @param {String} s\n     * @return {Boolean}\n     */\n    function validateCreditCard(s) {\n        // remove non-numerics\n        var v = '0123456789',\n            w = '',\n            i, j, k, m, c, a, x;\n\n        for (i = 0; i < s.length; i++) {\n            x = s.charAt(i);\n\n            if (v.indexOf(x, 0) !== -1) {\n                w += x;\n            }\n        }\n        // validate number\n        j = w.length / 2;\n        k = Math.floor(j);\n        m = Math.ceil(j) - k;\n        c = 0;\n\n        for (i = 0; i < k; i++) {\n            a = w.charAt(i * 2 + m) * 2;\n            c += a > 9 ? Math.floor(a / 10 + a % 10) : a;\n        }\n\n        for (i = 0; i < k + m; i++) {\n            c += w.charAt(i * 2 + 1 - m) * 1;\n        }\n\n        return c % 10 === 0;\n    }\n\n    /**\n     * validate all table required inputs at once, using single hidden input\n     * @param {String} value\n     * @param {HTMLElement} element\n     *\n     * @return {Boolean}\n     */\n    function tableSingleValidation(value, element) {\n        var empty = $(element).closest('table')\n            .find('input.required-option:visible')\n            .filter(function (i, el) {\n                if ($(el).is('disabled')) {\n                    return $.mage.isEmpty(el.value);\n                }\n            })\n            .length;\n\n        return empty === 0;\n    }\n\n    /**\n     *\n     * @param {float} qty\n     * @param {float} qtyIncrements\n     * @returns {float}\n     */\n    function resolveModulo(qty, qtyIncrements) {\n        while (qtyIncrements < 1) {\n            qty *= 10;\n            qtyIncrements *= 10;\n        }\n\n        return qty % qtyIncrements;\n    }\n\n    /**\n     * Collection of validation rules including rules from additional-methods.js\n     * @type {Object}\n     */\n    rules = {\n        'max-words': [\n            function (value, element, params) {\n                return this.optional(element) || $.mage.stripHtml(value).match(/\\b\\w+\\b/g).length <= params;\n            },\n            $.mage.__('Please enter {0} words or less.')\n        ],\n        'min-words': [\n            function (value, element, params) {\n                return this.optional(element) || $.mage.stripHtml(value).match(/\\b\\w+\\b/g).length >= params;\n            },\n            $.mage.__('Please enter at least {0} words.')\n        ],\n        'range-words': [\n            function (value, element, params) {\n                return this.optional(element) ||\n                    $.mage.stripHtml(value).match(/\\b\\w+\\b/g).length >= params[0] &&\n                    value.match(/bw+b/g).length < params[1];\n            },\n            $.mage.__('Please enter between {0} and {1} words.')\n        ],\n        'letters-with-basic-punc': [\n            function (value, element) {\n                return this.optional(element) || /^[a-z\\-.,()'\\\"\\s]+$/i.test(value);\n            },\n            $.mage.__('Letters or punctuation only please')\n        ],\n        'alphanumeric': [\n            function (value, element) {\n                return this.optional(element) || /^\\w+$/i.test(value);\n            },\n            $.mage.__('Letters, numbers, spaces or underscores only please')\n        ],\n        'letters-only': [\n            function (value, element) {\n                return this.optional(element) || /^[a-z]+$/i.test(value);\n            },\n            $.mage.__('Letters only please')\n        ],\n        'no-whitespace': [\n            function (value, element) {\n                return this.optional(element) || /^\\S+$/i.test(value);\n            },\n            $.mage.__('No white space please')\n        ],\n        'no-marginal-whitespace': [\n            function (value, element) {\n                return this.optional(element) || !/^\\s+|\\s+$/i.test(value);\n            },\n            $.mage.__('No marginal white space please')\n        ],\n        'zip-range': [\n            function (value, element) {\n                return this.optional(element) || /^90[2-5]-\\d{2}-\\d{4}$/.test(value);\n            },\n            $.mage.__('Your ZIP-code must be in the range 902xx-xxxx to 905-xx-xxxx')\n        ],\n        'integer': [\n            function (value, element) {\n                return this.optional(element) || /^-?\\d+$/.test(value);\n            },\n            $.mage.__('A positive or negative non-decimal number please')\n        ],\n        'vinUS': [\n            function (v) {\n                var i, n, d, f, cd, cdv, LL, VL, FL, rs;\n\n                /* eslint-disable max-depth */\n                if (v.length !== 17) {\n                    return false;\n                }\n\n                LL = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L',\n                    'M', 'N', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];\n                VL = [1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 7, 9, 2, 3, 4, 5, 6, 7, 8, 9];\n                FL = [8, 7, 6, 5, 4, 3, 2, 10, 0, 9, 8, 7, 6, 5, 4, 3, 2];\n                rs = 0;\n\n                for (i = 0; i < 17; i++) {\n                    f = FL[i];\n                    d = v.slice(i, i + 1);\n\n                    if (i === 8) {\n                        cdv = d;\n                    }\n\n                    if (!isNaN(d)) {\n                        d *= f;\n                    } else {\n                        for (n = 0; n < LL.length; n++) {\n                            if (d.toUpperCase() === LL[n]) {\n                                d = VL[n];\n                                d *= f;\n\n                                if (isNaN(cdv) && n === 8) {\n                                    cdv = LL[n];\n                                }\n                                break;\n                            }\n                        }\n                    }\n                    rs += d;\n                }\n\n                /* eslint-enable max-depth */\n                cd = rs % 11;\n\n                if (cd === 10) {\n                    cd = 'X';\n                }\n\n                if (cd === cdv) {\n                    return true;\n                }\n\n                return false;\n            },\n            $.mage.__('The specified vehicle identification number (VIN) is invalid.')\n        ],\n        'dateITA': [\n            function (value, element) {\n                var check = false,\n                    re = /^\\d{1,2}\\/\\d{1,2}\\/\\d{4}$/,\n                    adata, gg, mm, aaaa, xdata;\n\n                if (re.test(value)) {\n                    adata = value.split('/');\n                    gg = parseInt(adata[0], 10);\n                    mm = parseInt(adata[1], 10);\n                    aaaa = parseInt(adata[2], 10);\n                    xdata = new Date(aaaa, mm - 1, gg);\n\n                    if (xdata.getFullYear() === aaaa &&\n                        xdata.getMonth() === mm - 1 &&\n                        xdata.getDate() === gg\n                    ) {\n                        check = true;\n                    } else {\n                        check = false;\n                    }\n                } else {\n                    check = false;\n                }\n\n                return this.optional(element) || check;\n            },\n            $.mage.__('Please enter a correct date')\n        ],\n        'dateNL': [\n            function (value, element) {\n                return this.optional(element) || /^\\d\\d?[\\.\\/-]\\d\\d?[\\.\\/-]\\d\\d\\d?\\d?$/.test(value);\n            },\n            'Vul hier een geldige datum in.'\n        ],\n        'time': [\n            function (value, element) {\n                return this.optional(element) || /^([01]\\d|2[0-3])(:[0-5]\\d){0,2}$/.test(value);\n            },\n            $.mage.__('Please enter a valid time, between 00:00 and 23:59')\n        ],\n        'time12h': [\n            function (value, element) {\n                return this.optional(element) || /^((0?[1-9]|1[012])(:[0-5]\\d){0,2}(\\s[AP]M))$/i.test(value);\n            },\n            $.mage.__('Please enter a valid time, between 00:00 am and 12:00 pm')\n        ],\n        'phoneUS': [\n            function (phoneNumber, element) {\n                phoneNumber = phoneNumber.replace(/\\s+/g, '');\n\n                return this.optional(element) || phoneNumber.length > 9 &&\n                    phoneNumber.match(/^(1-?)?(\\([2-9]\\d{2}\\)|[2-9]\\d{2})-?[2-9]\\d{2}-?\\d{4}$/);\n            },\n            $.mage.__('Please specify a valid phone number')\n        ],\n        'phoneUK': [\n            function (phoneNumber, element) {\n                return this.optional(element) || phoneNumber.length > 9 &&\n                    phoneNumber.match(/^(\\(?(0|\\+44)[1-9]{1}\\d{1,4}?\\)?\\s?\\d{3,4}\\s?\\d{3,4})$/);\n            },\n            $.mage.__('Please specify a valid phone number')\n        ],\n        'mobileUK': [\n            function (phoneNumber, element) {\n                return this.optional(element) || phoneNumber.length > 9 &&\n                    phoneNumber.match(/^((0|\\+44)7\\d{3}\\s?\\d{6})$/);\n            },\n            $.mage.__('Please specify a valid mobile number')\n        ],\n        'stripped-min-length': [\n            function (value, element, param) {\n                return value.length >= param;\n            },\n            $.mage.__('Please enter at least {0} characters')\n        ],\n\n        /* detect chars that would require more than 3 bytes */\n        'validate-no-utf8mb4-characters': [\n            function (value) {\n                var validator = this,\n                    message = $.mage.__('Please remove invalid characters: {0}.'),\n                    matches = value.match(/(?:[\\uD800-\\uDBFF][\\uDC00-\\uDFFF])/g),\n                    result = matches === null;\n\n                if (!result) {\n                    validator.charErrorMessage = message.replace('{0}', matches.join());\n                }\n\n                return result;\n            }, function () {\n                return this.charErrorMessage;\n            }\n        ],\n\n        /* eslint-disable max-len */\n        'email2': [\n            function (value, element) {\n                return this.optional(element) ||\n                    /^((([a-z]|\\d|[!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z]|\\d|[!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*)|((\\x22)((((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(([\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x7f]|\\x21|[\\x23-\\x5b]|[\\x5d-\\x7e]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(\\\\([\\x01-\\x09\\x0b\\x0c\\x0d-\\x7f]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]))))*(((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(\\x22)))@((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?$/i.test(value);\n            },\n            $.validator.messages.email\n        ],\n        'url2': [\n            function (value, element) {\n                return this.optional(element) || /^(https?|ftp):\\/\\/(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:)*@)?(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?)(:\\d*)?)(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)*)*)?)?(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?$/i.test(value);\n            },\n            $.validator.messages.url\n        ],\n\n        /* eslint-enable max-len */\n        'credit-card-types': [\n            function (value, element, param) {\n                var validTypes;\n\n                if (/[^0-9-]+/.test(value)) {\n                    return false;\n                }\n                value = value.replace(/\\D/g, '');\n\n                validTypes = 0x0000;\n\n                if (param.mastercard) {\n                    validTypes |= 0x0001;\n                }\n\n                if (param.visa) {\n                    validTypes |= 0x0002;\n                }\n\n                if (param.amex) {\n                    validTypes |= 0x0004;\n                }\n\n                if (param.dinersclub) {\n                    validTypes |= 0x0008;\n                }\n\n                if (param.enroute) {\n                    validTypes |= 0x0010;\n                }\n\n                if (param.discover) {\n                    validTypes |= 0x0020;\n                }\n\n                if (param.jcb) {\n                    validTypes |= 0x0040;\n                }\n\n                if (param.unknown) {\n                    validTypes |= 0x0080;\n                }\n\n                if (param.all) {\n                    validTypes = 0x0001 | 0x0002 | 0x0004 | 0x0008 | 0x0010 | 0x0020 | 0x0040 | 0x0080;\n                }\n\n                if (validTypes & 0x0001 && /^(51|52|53|54|55)/.test(value)) { //mastercard\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0002 && /^(4)/.test(value)) { //visa\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0004 && /^(34|37)/.test(value)) { //amex\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0008 && /^(300|301|302|303|304|305|36|38)/.test(value)) { //dinersclub\n                    return value.length === 14;\n                }\n\n                if (validTypes & 0x0010 && /^(2014|2149)/.test(value)) { //enroute\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0020 && /^(6011)/.test(value)) { //discover\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0040 && /^(3)/.test(value)) { //jcb\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0040 && /^(2131|1800)/.test(value)) { //jcb\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0080) { //unknown\n                    return true;\n                }\n\n                return false;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n\n        /* eslint-disable max-len */\n        'ipv4': [\n            function (value, element) {\n                return this.optional(element) ||\n                    /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/i.test(value);\n            },\n            $.mage.__('Please enter a valid IP v4 address.')\n        ],\n        'ipv6': [\n            function (value, element) {\n                return this.optional(element) || /^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(([0-9A-Fa-f]{1,4}:){0,5}:((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(::([0-9A-Fa-f]{1,4}:){0,5}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))$/i.test(value);\n            },\n            $.mage.__('Please enter a valid IP v6 address.')\n        ],\n\n        /* eslint-enable max-len */\n        'pattern': [\n            function (value, element, param) {\n                return this.optional(element) || param.test(value);\n            },\n            $.mage.__('Invalid format.')\n        ],\n        'allow-container-className': [\n            function (element) {\n                if (element.type === 'radio' || element.type === 'checkbox') {\n                    return $(element).hasClass('change-container-classname');\n                }\n            },\n            ''\n        ],\n        'validate-no-html-tags': [\n            function (value) {\n                return !/<(\\/)?\\w+/.test(value);\n            },\n            $.mage.__('HTML tags are not allowed.')\n        ],\n        'validate-select': [\n            function (value) {\n                return value !== 'none' && value != null && value.length !== 0;\n            },\n            $.mage.__('Please select an option.')\n        ],\n        'validate-no-empty': [\n            function (value) {\n                return !$.mage.isEmpty(value);\n            },\n            $.mage.__('Empty Value.')\n        ],\n        'validate-alphanum-with-spaces': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-zA-Z0-9 ]+$/.test(v);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or spaces only in this field.')\n        ],\n        'validate-data': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[A-Za-z]+[A-Za-z0-9_]+$/.test(v);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.') //eslint-disable-line max-len\n        ],\n        'validate-street': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[ \\w]{3,}([A-Za-z]\\.)?([ \\w]*\\#\\d+)?(\\r\\n| )[ \\w]{3,}/.test(v);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9), spaces and \"#\" in this field.')\n        ],\n        'validate-phoneStrict': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(v);\n            },\n            $.mage.__('Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.')\n        ],\n        'validate-phoneLax': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) ||\n                    /^((\\d[\\-. ]?)?((\\(\\d{3}\\))|\\d{3}))?[\\-. ]?\\d{3}[\\-. ]?\\d{4}$/.test(v);\n            },\n            $.mage.__('Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.')\n        ],\n        'validate-fax': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(v);\n            },\n            $.mage.__('Please enter a valid fax number (Ex: 123-456-7890).')\n        ],\n        'validate-email': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*@([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*\\.(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]){2,})$/i.test(v); //eslint-disable-line max-len\n            },\n            $.mage.__('Please enter a valid email address (Ex: johndoe@domain.com).')\n        ],\n        'validate-emailSender': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[\\S ]+$/.test(v);\n            },\n            $.mage.__('Please enter a valid email address (Ex: johndoe@domain.com).')\n        ],\n        'validate-password': [\n            function (v) {\n                var pass;\n\n                if (v == null) {\n                    return false;\n                }\n                //strip leading and trailing spaces\n                pass = $.trim(v);\n\n                if (!pass.length) {\n                    return true;\n                }\n\n                return !(pass.length > 0 && pass.length < 6);\n            },\n            $.mage.__('Please enter 6 or more characters. Leading and trailing spaces will be ignored.')\n        ],\n        'validate-admin-password': [\n            function (v) {\n                var pass;\n\n                if (v == null) {\n                    return false;\n                }\n                pass = $.trim(v);\n                // strip leading and trailing spaces\n                if (pass.length === 0) {\n                    return true;\n                }\n\n                if (!/[a-z]/i.test(v) || !/[0-9]/.test(v)) {\n                    return false;\n                }\n\n                if (pass.length < 7) {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter 7 or more characters, using both numeric and alphabetic.')\n        ],\n        'validate-customer-password': [\n            function (v, elm) {\n                var validator = this,\n                    counter = 0,\n                    passwordMinLength = $(elm).data('password-min-length'),\n                    passwordMinCharacterSets = $(elm).data('password-min-character-sets'),\n                    pass = $.trim(v),\n                    result = pass.length >= passwordMinLength;\n\n                if (result === false) {\n                    validator.passwordErrorMessage = $.mage.__('Minimum length of this field must be equal or greater than %1 symbols. Leading and trailing spaces will be ignored.').replace('%1', passwordMinLength); //eslint-disable-line max-len\n\n                    return result;\n                }\n\n                if (pass.match(/\\d+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[a-z]+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[A-Z]+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[^a-zA-Z0-9]+/)) {\n                    counter++;\n                }\n\n                if (counter < passwordMinCharacterSets) {\n                    result = false;\n                    validator.passwordErrorMessage = $.mage.__('Minimum of different classes of characters in password is %1. Classes of characters: Lower Case, Upper Case, Digits, Special Characters.').replace('%1', passwordMinCharacterSets); //eslint-disable-line max-len\n                }\n\n                return result;\n            }, function () {\n                return this.passwordErrorMessage;\n            }\n        ],\n        'validate-url': [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = (v || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n\n                return (/^(http|https|ftp):\\/\\/(([A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))(\\.[A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))*)(:(\\d+))?(\\/[A-Z0-9~](([A-Z0-9_~-]|\\.)*[A-Z0-9~]|))*\\/?(.*)?$/i).test(v); //eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid URL. Protocol is required (http://, https:// or ftp://).')\n        ],\n        'validate-clean-url': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^(http|https|ftp):\\/\\/(([A-Z0-9][A-Z0-9_-]*)(\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(v) || /^(www)((\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(v); //eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid URL. For example http://www.example.com or www.example.com.')\n        ],\n        'validate-xml-identifier': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[A-Z][A-Z0-9_\\/-]*$/i.test(v);\n\n            },\n            $.mage.__('Please enter a valid XML-identifier (Ex: something_1, block5, id-4).')\n        ],\n        'validate-ssn': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^\\d{3}-?\\d{2}-?\\d{4}$/.test(v);\n\n            },\n            $.mage.__('Please enter a valid social security number (Ex: 123-45-6789).')\n        ],\n        'validate-zip-us': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /(^\\d{5}$)|(^\\d{5}-\\d{4}$)/.test(v);\n\n            },\n            $.mage.__('Please enter a valid zip code (Ex: 90602 or 90602-1234).')\n        ],\n        'validate-date-au': [\n            function (v) {\n                var regex, d;\n\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                regex = /^(\\d{2})\\/(\\d{2})\\/(\\d{4})$/;\n\n                if ($.mage.isEmpty(v) || !regex.test(v)) {\n                    return false;\n                }\n                d = new Date(v.replace(regex, '$2/$1/$3'));\n\n                return parseInt(RegExp.$2, 10) === 1 + d.getMonth() &&\n                    parseInt(RegExp.$1, 10) === d.getDate() &&\n                    parseInt(RegExp.$3, 10) === d.getFullYear();\n\n            },\n            $.mage.__('Please use this date format: dd/mm/yyyy. For example 17/03/2006 for the 17th of March, 2006.')\n        ],\n        'validate-currency-dollar': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^\\$?\\-?([1-9]{1}[0-9]{0,2}(\\,[0-9]{3})*(\\.[0-9]{0,2})?|[1-9]{1}\\d*(\\.[0-9]{0,2})?|0(\\.[0-9]{0,2})?|(\\.[0-9]{1,2})?)$/.test(v); //eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid $ amount. For example $100.00.')\n        ],\n        'validate-not-negative-number': [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = $.mage.parseNumber(v);\n\n                return !isNaN(v) && v >= 0;\n\n            },\n            $.mage.__('Please enter a number 0 or greater in this field.')\n        ],\n        // validate-not-negative-number should be replaced in all places with this one and then removed\n        'validate-zero-or-greater': [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = $.mage.parseNumber(v);\n\n                return !isNaN(v) && v >= 0;\n\n            },\n            $.mage.__('Please enter a number 0 or greater in this field.')\n        ],\n        'validate-greater-than-zero': [\n            function (v) {\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n                v = $.mage.parseNumber(v);\n\n                return !isNaN(v) && v > 0;\n            },\n            $.mage.__('Please enter a number greater than 0 in this field.')\n        ],\n        'validate-css-length': [\n            function (v) {\n                if (v !== '') {\n                    return (/^[0-9]*\\.*[0-9]+(px|pc|pt|ex|em|mm|cm|in|%)?$/).test(v);\n                }\n\n                return true;\n            },\n            $.mage.__('Please input a valid CSS-length (Ex: 100px, 77pt, 20em, .5ex or 50%).')\n        ],\n        // Additional methods\n        'validate-number': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || !isNaN($.mage.parseNumber(v)) && /^\\s*-?\\d*(\\.\\d*)?\\s*$/.test(v);\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        'required-number': [\n            function (v) {\n                return !!v.length;\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        'validate-number-range': [\n            function (v, elm, param) {\n                var numValue, dataAttrRange, classNameRange, result, range, m, classes, ii;\n\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n\n                numValue = $.mage.parseNumber(v);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                dataAttrRange = /^(-?[\\d.,]+)?-(-?[\\d.,]+)?$/;\n                classNameRange = /^number-range-(-?[\\d.,]+)?-(-?[\\d.,]+)?$/;\n                result = true;\n                range = param;\n\n                if (typeof range === 'string') {\n                    m = dataAttrRange.exec(range);\n\n                    if (m) {\n                        result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                    } else {\n                        result = false;\n                    }\n                } else if (elm && elm.className) {\n                    classes = elm.className.split(' ');\n                    ii = classes.length;\n\n                    while (ii--) {\n                        range = classes[ii];\n                        m = classNameRange.exec(range);\n\n                        if (m) { //eslint-disable-line max-depth\n                            result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                            break;\n                        }\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.'),\n            true\n        ],\n        'validate-digits': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || !/[^\\d]/.test(v);\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        'validate-forbidden-extensions': [\n            function (v, elem) {\n                var forbiddenExtensions = $(elem).attr('data-validation-params'),\n                    forbiddenExtensionsArray = forbiddenExtensions.split(','),\n                    extensionsArray = v.split(','),\n                    result = true;\n\n                this.validateExtensionsMessage = $.mage.__('Forbidden extensions has been used. Avoid usage of ') +\n                    forbiddenExtensions;\n\n                $.each(extensionsArray, function (key, extension) {\n                    if (forbiddenExtensionsArray.indexOf(extension) !== -1) {\n                        result = false;\n                    }\n                });\n\n                return result;\n            }, function () {\n                return this.validateExtensionsMessage;\n            }\n        ],\n        'validate-digits-range': [\n            function (v, elm, param) {\n                var numValue, dataAttrRange, classNameRange, result, range, m, classes, ii;\n\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n\n                numValue = $.mage.parseNumber(v);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                dataAttrRange = /^(-?\\d+)?-(-?\\d+)?$/;\n                classNameRange = /^digits-range-(-?\\d+)?-(-?\\d+)?$/;\n                result = true;\n                range = param;\n\n                if (typeof range === 'string') {\n                    m = dataAttrRange.exec(range);\n\n                    if (m) {\n                        result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                    } else {\n                        result = false;\n                    }\n                } else if (elm && elm.className) {\n                    classes = elm.className.split(' ');\n                    ii = classes.length;\n\n                    while (ii--) {\n                        range = classes[ii];\n                        m = classNameRange.exec(range);\n\n                        if (m) { //eslint-disable-line max-depth\n                            result = result && $.mage.isBetween(numValue, m[1], m[2]);\n                            break;\n                        }\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.'),\n            true\n        ],\n        'validate-range': [\n            function (v, elm) {\n                var minValue, maxValue, ranges, reRange, result, values,\n                    i, name, validRange, minValidRange, maxValidRange;\n\n                if ($.mage.isEmptyNoTrim(v)) {\n                    return true;\n                } else if ($.validator.methods['validate-digits'] && $.validator.methods['validate-digits'](v)) {\n                    minValue = maxValue = $.mage.parseNumber(v);\n                } else {\n                    ranges = /^(-?\\d+)?-(-?\\d+)?$/.exec(v);\n\n                    if (ranges) {\n                        minValue = $.mage.parseNumber(ranges[1]);\n                        maxValue = $.mage.parseNumber(ranges[2]);\n\n                        if (minValue > maxValue) { //eslint-disable-line max-depth\n                            return false;\n                        }\n                    } else {\n                        return false;\n                    }\n                }\n                reRange = /^range-(-?\\d+)?-(-?\\d+)?$/;\n                result = true;\n                values = $(elm).prop('class').split(' ');\n\n                for (i = values.length - 1; i >= 0; i--) {\n                    name = values[i];\n                    validRange = reRange.exec(name);\n\n                    if (validRange) {\n                        minValidRange = $.mage.parseNumber(validRange[1]);\n                        maxValidRange = $.mage.parseNumber(validRange[2]);\n                        result = result &&\n                            (isNaN(minValidRange) || minValue >= minValidRange) &&\n                            (isNaN(maxValidRange) || maxValue <= maxValidRange);\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        'validate-alpha': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-zA-Z]+$/.test(v);\n            },\n            $.mage.__('Please use letters only (a-z or A-Z) in this field.')\n        ],\n        'validate-code': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-zA-Z]+[a-zA-Z0-9_]+$/.test(v);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.') //eslint-disable-line max-len\n        ],\n        'validate-alphanum': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-zA-Z0-9]+$/.test(v);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z) or numbers (0-9) in this field. No spaces or other characters are allowed.') //eslint-disable-line max-len\n        ],\n        'validate-not-number-first': [\n            function (value) {\n                return $.mage.isEmptyNoTrim(value) || /^[^0-9-\\.].*$/.test(value.trim());\n            },\n            $.mage.__('First character must be letter.')\n        ],\n        'validate-date': [\n            function (value, params, additionalParams) {\n                var test = moment(value, additionalParams.dateFormat);\n\n                return $.mage.isEmptyNoTrim(value) || test.isValid();\n            },\n            $.mage.__('Please enter a valid date.')\n\n        ],\n        'validate-date-range': [\n            function (v, elm) {\n                var m = /\\bdate-range-(\\w+)-(\\w+)\\b/.exec(elm.className),\n                    currentYear, normalizedTime, dependentElements;\n\n                if (!m || m[2] === 'to' || $.mage.isEmptyNoTrim(v)) {\n                    return true;\n                }\n\n                currentYear = new Date().getFullYear() + '';\n\n                /**\n                 * @param {String} vd\n                 * @return {Number}\n                 */\n                normalizedTime = function (vd) {\n                    vd = vd.split(/[.\\/]/);\n\n                    if (vd[2] && vd[2].length < 4) {\n                        vd[2] = currentYear.substr(0, vd[2].length) + vd[2];\n                    }\n\n                    return new Date(vd.join('/')).getTime();\n                };\n\n                dependentElements = $(elm.form).find('.validate-date-range.date-range-' + m[1] + '-to');\n\n                return !dependentElements.length || $.mage.isEmptyNoTrim(dependentElements[0].value) ||\n                    normalizedTime(v) <= normalizedTime(dependentElements[0].value);\n            },\n            $.mage.__('Make sure the To Date is later than or the same as the From Date.')\n        ],\n        'validate-cpassword': [\n            function () {\n                var conf = $('#confirmation').length > 0 ? $('#confirmation') : $($('.validate-cpassword')[0]),\n                    pass = false,\n                    passwordElements, i, passwordElement;\n\n                if ($('#password')) {\n                    pass = $('#password');\n                }\n                passwordElements = $('.validate-password');\n\n                for (i = 0; i < passwordElements.length; i++) {\n                    passwordElement = $(passwordElements[i]);\n\n                    if (passwordElement.closest('form').attr('id') === conf.closest('form').attr('id')) {\n                        pass = passwordElement;\n                    }\n                }\n\n                if ($('.validate-admin-password').length) {\n                    pass = $($('.validate-admin-password')[0]);\n                }\n\n                return pass.val() === conf.val();\n            },\n            $.mage.__('Please make sure your passwords match.')\n        ],\n        'validate-identifier': [\n            function (v) {\n                return $.mage.isEmptyNoTrim(v) || /^[a-z0-9][a-z0-9_\\/-]+(\\.[a-z0-9_-]+)?$/.test(v);\n            },\n            $.mage.__('Please enter a valid URL Key (Ex: \"example-page\", \"example-page.html\" or \"anotherlevel/example-page\").') //eslint-disable-line max-len\n        ],\n        'validate-zip-international': [\n\n            /*function(v) {\n             // @TODO: Cleanup\n             return Validation.get('IsEmpty').test(v) ||\n             /(^[A-z0-9]{2,10}([\\s]{0,1}|[\\-]{0,1})[A-z0-9]{2,10}$)/.test(v);\n             }*/\n            function () {\n                return true;\n            },\n            $.mage.__('Please enter a valid zip code.')\n        ],\n        'validate-one-required': [\n            function (v, elm) {\n                var p = $(elm).parent(),\n                    options = p.find('input');\n\n                return options.map(function (el) {\n                    return $(el).val();\n                }).length > 0;\n            },\n            $.mage.__('Please select one of the options above.')\n        ],\n        'validate-state': [\n            function (v) {\n                return v !== 0 || v === '';\n            },\n            $.mage.__('Please select State/Province.')\n        ],\n        'required-file': [\n            function (v, elm) {\n                var result = !$.mage.isEmptyNoTrim(v),\n                    ovId;\n\n                if (!result) {\n                    ovId = $('#' + $(elm).attr('id') + '_value');\n\n                    if (ovId.length > 0) {\n                        result = !$.mage.isEmptyNoTrim(ovId.val());\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('Please select a file.')\n        ],\n        'validate-ajax-error': [\n            function (v, element) {\n                element = $(element);\n                element.on('change.ajaxError', function () {\n                    element.removeClass('validate-ajax-error');\n                    element.off('change.ajaxError');\n                });\n\n                return !element.hasClass('validate-ajax-error');\n            },\n            ''\n        ],\n        'validate-optional-datetime': [\n            function (v, elm, param) {\n                var dateTimeParts = $('.datetime-picker[id^=\"options_' + param + '\"]'),\n                    hasWithValue = false,\n                    hasWithNoValue = false,\n                    pattern = /day_part$/i,\n                    i;\n\n                for (i = 0; i < dateTimeParts.length; i++) {\n                    if (!pattern.test($(dateTimeParts[i]).attr('id'))) {\n                        if ($(dateTimeParts[i]).val() === 's') { //eslint-disable-line max-depth\n                            hasWithValue = true;\n                        } else {\n                            hasWithNoValue = true;\n                        }\n                    }\n                }\n\n                return hasWithValue ^ hasWithNoValue;\n            },\n            $.mage.__('The field isn\\'t complete.')\n        ],\n        'validate-required-datetime': [\n            function (v, elm, param) {\n                var dateTimeParts = $('.datetime-picker[id^=\"options_' + param + '\"]'),\n                    i;\n\n                for (i = 0; i < dateTimeParts.length; i++) {\n                    if (dateTimeParts[i].value === '') {\n                        return false;\n                    }\n                }\n\n                return true;\n            },\n            $.mage.__('This is a required field.')\n        ],\n        'validate-one-required-by-name': [\n            function (v, elm, selector) {\n                var name = elm.name.replace(/([\\\\\"])/g, '\\\\$1'),\n                    container = this.currentForm;\n\n                selector = selector === true ? 'input[name=\"' + name + '\"]:checked' : selector;\n\n                return !!container.querySelectorAll(selector).length;\n            },\n            $.mage.__('Please select one of the options.')\n        ],\n        'less-than-equals-to': [\n            function (value, element, params) {\n                if ($.isNumeric($(params).val()) && $.isNumeric(value)) {\n                    this.lteToVal = $(params).val();\n\n                    return parseFloat(value) <= parseFloat($(params).val());\n                }\n\n                return true;\n            },\n            function () {\n                var message = $.mage.__('Please enter a value less than or equal to %s.');\n\n                return message.replace('%s', this.lteToVal);\n            }\n        ],\n        'greater-than-equals-to': [\n            function (value, element, params) {\n                if ($.isNumeric($(params).val()) && $.isNumeric(value)) {\n                    this.gteToVal = $(params).val();\n\n                    return parseFloat(value) >= parseFloat($(params).val());\n                }\n\n                return true;\n            },\n            function () {\n                var message = $.mage.__('Please enter a value greater than or equal to %s.');\n\n                return message.replace('%s', this.gteToVal);\n            }\n        ],\n        'validate-emails': [\n            function (value) {\n                var validRegexp, emails, i;\n\n                if ($.mage.isEmpty(value)) {\n                    return true;\n                }\n                validRegexp = /^([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*@([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*\\.(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]){2,})$/i; //eslint-disable-line max-len\n                emails = value.split(/[\\s\\n\\,]+/g);\n\n                for (i = 0; i < emails.length; i++) {\n                    if (!validRegexp.test(emails[i].trim())) {\n                        return false;\n                    }\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter valid email addresses, separated by commas. For example, johndoe@domain.com, johnsmith@domain.com.') //eslint-disable-line max-len\n        ],\n\n        'validate-cc-type-select': [\n\n            /**\n             * Validate credit card type matches credit card number\n             * @param {*} value - select credit card type\n             * @param {*} element - element contains the select box for credit card types\n             * @param {*} params - selector for credit card number\n             * @return {Boolean}\n             */\n            function (value, element, params) {\n                if (value && params && creditCartTypes[value]) {\n                    return creditCartTypes[value][0].test($(params).val().replace(/\\s+/g, ''));\n                }\n\n                return false;\n            },\n            $.mage.__('Card type does not match credit card number.')\n        ],\n        'validate-cc-number': [\n\n            /**\n             * Validate credit card number based on mod 10.\n             *\n             * @param {*} value - credit card number\n             * @return {Boolean}\n             */\n            function (value) {\n                if (value) {\n                    return validateCreditCard(value);\n                }\n\n                return false;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n        'validate-cc-type': [\n\n            /**\n             * Validate credit card number is for the correct credit card type.\n             *\n             * @param {String} value - credit card number\n             * @param {*} element - element contains credit card number\n             * @param {*} params - selector for credit card type\n             * @return {Boolean}\n             */\n            function (value, element, params) {\n                var ccType;\n\n                if (value && params) {\n                    ccType = $(params).val();\n                    value = value.replace(/\\s/g, '').replace(/\\-/g, '');\n\n                    if (creditCartTypes[ccType] && creditCartTypes[ccType][0]) {\n                        return creditCartTypes[ccType][0].test(value);\n                    } else if (creditCartTypes[ccType] && !creditCartTypes[ccType][0]) {\n                        return true;\n                    }\n                }\n\n                return false;\n            },\n            $.mage.__('Credit card number does not match credit card type.')\n        ],\n        'validate-cc-exp': [\n\n            /**\n             * Validate credit card expiration date, make sure it's within the year and not before current month.\n             *\n             * @param {*} value - month\n             * @param {*} element - element contains month\n             * @param {*} params - year selector\n             * @return {Boolean}\n             */\n            function (value, element, params) {\n                var isValid = false,\n                    month, year, currentTime, currentMonth, currentYear;\n\n                if (value && params) {\n                    month = value;\n                    year = $(params).val();\n                    currentTime = new Date();\n                    currentMonth = currentTime.getMonth() + 1;\n                    currentYear = currentTime.getFullYear();\n\n                    isValid = !year || year > currentYear || year == currentYear && month >= currentMonth; //eslint-disable-line\n                }\n\n                return isValid;\n            },\n            $.mage.__('Incorrect credit card expiration date.')\n        ],\n        'validate-cc-cvn': [\n\n            /**\n             * Validate credit card cvn based on credit card type.\n             *\n             * @param {*} value - credit card cvn\n             * @param {*} element - element contains credit card cvn\n             * @param {*} params - credit card type selector\n             * @return {*}\n             */\n            function (value, element, params) {\n                var ccType;\n\n                if (value && params) {\n                    ccType = $(params).val();\n\n                    if (creditCartTypes[ccType] && creditCartTypes[ccType][0]) {\n                        return creditCartTypes[ccType][1].test(value);\n                    }\n                }\n\n                return false;\n            },\n            $.mage.__('Please enter a valid credit card verification number.')\n        ],\n        'validate-cc-ukss': [\n\n            /**\n             * Validate Switch/Solo/Maestro issue number and start date is filled.\n             *\n             * @param {*} value - input field value\n             * @return {*}\n             */\n            function (value) {\n                return value;\n            },\n            $.mage.__('Please enter issue number or start date for switch/solo card type.')\n        ],\n        'validate-length': [\n            function (v, elm) {\n                var reMax = new RegExp(/^maximum-length-[0-9]+$/),\n                    reMin = new RegExp(/^minimum-length-[0-9]+$/),\n                    validator = this,\n                    result = true,\n                    length = 0;\n\n                $.each(elm.className.split(' '), function (index, name) {\n                    if (name.match(reMax) && result) {\n                        length = name.split('-')[2];\n                        result = v.length <= length;\n                        validator.validateMessage =\n                            $.mage.__('Please enter less or equal than %1 symbols.').replace('%1', length);\n                    }\n\n                    if (name.match(reMin) && result && !$.mage.isEmpty(v)) {\n                        length = name.split('-')[2];\n                        result = v.length >= length;\n                        validator.validateMessage =\n                            $.mage.__('Please enter more or equal than %1 symbols.').replace('%1', length);\n                    }\n                });\n\n                return result;\n            }, function () {\n                return this.validateMessage;\n            }\n        ],\n        'required-entry': [\n            function (value) {\n                return !$.mage.isEmpty(value);\n            }, $.mage.__('This is a required field.')\n        ],\n        'not-negative-amount': [\n            function (v) {\n                if (v.length) {\n                    return (/^\\s*\\d+([,.]\\d+)*\\s*%?\\s*$/).test(v);\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter positive number in this field.')\n        ],\n        'validate-per-page-value-list': [\n            function (v) {\n                var isValid = true,\n                    values = v.split(','),\n                    i;\n\n                if ($.mage.isEmpty(v)) {\n                    return isValid;\n                }\n\n                for (i = 0; i < values.length; i++) {\n                    if (!/^[0-9]+$/.test(values[i])) {\n                        isValid = false;\n                    }\n                }\n\n                return isValid;\n            },\n            $.mage.__('Please enter a valid value, ex: 10,20,30')\n        ],\n        'validate-per-page-value': [\n            function (v, elm) {\n                var values;\n\n                if ($.mage.isEmpty(v)) {\n                    return false;\n                }\n                values = $('#' + elm.id + '_values').val().split(',');\n\n                return values.indexOf(v) !== -1;\n            },\n            $.mage.__('Please enter a valid value from list')\n        ],\n        'validate-new-password': [\n            function (v) {\n                if ($.validator.methods['validate-password'] && !$.validator.methods['validate-password'](v)) {\n                    return false;\n                }\n\n                if ($.mage.isEmpty(v) && v !== '') {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter 6 or more characters. Leading and trailing spaces will be ignored.')\n        ],\n        'required-if-not-specified': [\n            function (value, element, params) {\n                var valid = false,\n                    alternate = $(params),\n                    alternateValue;\n\n                if (alternate.length > 0) {\n                    valid = this.check(alternate);\n                    // if valid, it may be blank, so check for that\n                    if (valid) {\n                        alternateValue = alternate.val();\n\n                        if (typeof alternateValue == 'undefined' || alternateValue.length === 0) { //eslint-disable-line\n                            valid = false;\n                        }\n                    }\n                }\n\n                if (!valid) {\n                    valid = !this.optional(element);\n                }\n\n                return valid;\n            },\n            $.mage.__('This is a required field.')\n        ],\n        'required-if-all-sku-empty-and-file-not-loaded': [\n            function (value, element, params) {\n                var valid = false,\n                    alternate = $(params.specifiedId),\n                    alternateValue;\n\n                if (alternate.length > 0) {\n                    valid = this.check(alternate);\n                    // if valid, it may be blank, so check for that\n                    if (valid) {\n                        alternateValue = alternate.val();\n\n                        if (typeof alternateValue == 'undefined' || alternateValue.length === 0) { //eslint-disable-line\n                            valid = false;\n                        }\n                    }\n                }\n\n                if (!valid) {\n                    valid = !this.optional(element);\n                }\n\n                $('input[' + params.dataSku + '=true]').each(function () {\n                    if ($(this).val() !== '') {\n                        valid = true;\n                    }\n                });\n\n                return valid;\n            },\n            $.mage.__('Please enter valid SKU key.')\n        ],\n        'required-if-specified': [\n            function (value, element, params) {\n                var valid = true,\n                    dependent = $(params),\n                    dependentValue;\n\n                if (dependent.length > 0) {\n                    valid = this.check(dependent);\n                    // if valid, it may be blank, so check for that\n                    if (valid) {\n                        dependentValue = dependent.val();\n                        valid = typeof dependentValue != 'undefined' && dependentValue.length > 0;\n                    }\n                }\n\n                if (valid) {\n                    valid = !this.optional(element);\n                } else {\n                    valid = true; // dependent was not valid, so don't even check\n                }\n\n                return valid;\n            },\n            $.mage.__('This is a required field.')\n        ],\n        'required-number-if-specified': [\n            function (value, element, params) {\n                var valid = true,\n                    dependent = $(params),\n                    depeValue;\n\n                if (dependent.length) {\n                    valid = this.check(dependent);\n\n                    if (valid) {\n                        depeValue = dependent[0].value;\n                        valid = !!(depeValue && depeValue.length);\n                    }\n                }\n\n                return valid ? !!value.length : true;\n            },\n            $.mage.__('Please enter a valid number.')\n        ],\n        'datetime-validation': [\n            function (value, element) {\n                var isValid = true;\n\n                if ($(element).val().length === 0) {\n                    isValid = false;\n                    $(element).addClass('mage-error');\n                }\n\n                return isValid;\n            },\n            $.mage.__('This is required field')\n        ],\n        'required-text-swatch-entry': [\n            tableSingleValidation,\n            $.mage.__('Admin is a required field in each row.')\n        ],\n        'required-visual-swatch-entry': [\n            tableSingleValidation,\n            $.mage.__('Admin is a required field in each row.')\n        ],\n        'required-dropdown-attribute-entry': [\n            tableSingleValidation,\n            $.mage.__('Admin is a required field in each row.')\n        ],\n        'validate-item-quantity': [\n            function (value, element, params) {\n                var validator = this,\n                    result = false,\n                    // obtain values for validation\n                    qty = $.mage.parseNumber(value),\n                    isMinAllowedValid = typeof params.minAllowed === 'undefined' ||\n                        qty >= $.mage.parseNumber(params.minAllowed),\n                    isMaxAllowedValid = typeof params.maxAllowed === 'undefined' ||\n                        qty <= $.mage.parseNumber(params.maxAllowed),\n                    isQtyIncrementsValid = typeof params.qtyIncrements === 'undefined' ||\n                        resolveModulo(qty, $.mage.parseNumber(params.qtyIncrements)) === 0.0;\n\n                result = qty > 0;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('Please enter a quantity greater than 0.');//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isMinAllowedValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('The fewest you may purchase is %1.').replace('%1', params.minAllowed);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isMaxAllowedValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('The maximum you may purchase is %1.').replace('%1', params.maxAllowed);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isQtyIncrementsValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('You can buy this product only in quantities of %1 at a time.').replace('%1', params.qtyIncrements);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                return result;\n            }, function () {\n                return this.itemQtyErrorMessage;\n            }\n        ],\n        'password-not-equal-to-user-name': [\n            function (value, element, params) {\n                if (typeof params === 'string') {\n                    return value.toLowerCase() !== params.toLowerCase();\n                }\n\n                return true;\n            },\n            $.mage.__('The password can\\'t be the same as the email address. Create a new password and try again.')\n        ]\n    };\n\n    $.each(rules, function (i, rule) {\n        rule.unshift(i);\n        $.validator.addMethod.apply($.validator, rule);\n    });\n    $.validator.addClassRules({\n        'required-option': {\n            required: true\n        },\n        'required-options-count': {\n            required: true\n        },\n        'validate-both-passwords': {\n            'validate-cpassword': true\n        }\n    });\n    $.validator.messages = $.extend($.validator.messages, {\n        required: $.mage.__('This is a required field.'),\n        remote: $.mage.__('Please fix this field.'),\n        email: $.mage.__('Please enter a valid email address.'),\n        url: $.mage.__('Please enter a valid URL.'),\n        date: $.mage.__('Please enter a valid date.'),\n        dateISO: $.mage.__('Please enter a valid date (ISO).'),\n        number: $.mage.__('Please enter a valid number.'),\n        digits: $.mage.__('Please enter only digits.'),\n        creditcard: $.mage.__('Please enter a valid credit card number.'),\n        equalTo: $.mage.__('Please enter the same value again.'),\n        maxlength: $.validator.format($.mage.__('Please enter no more than {0} characters.')),\n        minlength: $.validator.format($.mage.__('Please enter at least {0} characters.')),\n        rangelength: $.validator.format($.mage.__('Please enter a value between {0} and {1} characters long.')),\n        range: $.validator.format($.mage.__('Please enter a value between {0} and {1}.')),\n        max: $.validator.format($.mage.__('Please enter a value less than or equal to {0}.')),\n        min: $.validator.format($.mage.__('Please enter a value greater than or equal to {0}.'))\n    });\n\n    if ($.metadata) {\n        // Setting the type as html5 to enable data-validate attribute\n        $.metadata.setType('html5');\n    }\n\n    showLabel = $.validator.prototype.showLabel;\n    $.extend(true, $.validator.prototype, {\n        /**\n         * @param {*} element\n         * @param {*} message\n         */\n        showLabel: function (element, message) {\n            var label, elem;\n\n            showLabel.call(this, element, message);\n\n            // ARIA (adding aria-invalid & aria-describedby)\n            label = this.errorsFor(element);\n            elem = $(element);\n\n            if (!label.attr('id')) {\n                label.attr('id', this.idOrName(element) + '-error');\n            }\n            elem.attr('aria-invalid', 'true')\n                .attr('aria-describedby', label.attr('id'));\n        }\n    });\n\n    /**\n     * Validate form field without instantiating validate plug-in.\n     *\n     * @param {Element|String} element - DOM element or selector\n     * @return {Boolean} validation result\n     */\n    $.validator.validateElement = function (element) {\n        var form, validator, valid, classes;\n\n        element = $(element);\n        form = element.get(0).form;\n        validator = form ? $(form).data('validator') : null;\n\n        if (validator) {\n            return validator.element(element.get(0));\n        }\n        valid = true;\n        classes = element.prop('class').split(' ');\n        $.each(classes, $.proxy(function (i, className) {\n            if (this.methods[className] && !this.methods[className](element.val(), element.get(0))) {\n                valid = false;\n\n                return valid;\n            }\n        }, this));\n\n        return valid;\n    };\n\n    originValidateDelegate = $.fn.validateDelegate;\n\n    /**\n     * @return {*}\n     */\n    $.fn.validateDelegate = function () {\n        if (!this[0].form) {\n            return this;\n        }\n\n        return originValidateDelegate.apply(this, arguments);\n    };\n\n    /**\n     * Validate single element.\n     *\n     * @param {Element} element\n     * @param {Object} config\n     * @returns {*}\n     */\n    $.validator.validateSingleElement = function (element, config) {\n        var errors = {},\n            valid = true,\n            validateConfig = {\n                errorElement: 'label',\n                ignore: '.ignore-validate',\n                hideError: false\n            },\n            form, validator, classes, elementValue;\n\n        $.extend(validateConfig, config);\n        element = $(element).not(validateConfig.ignore);\n\n        if (!element.length) {\n            return true;\n        }\n\n        form = element.get(0).form;\n        validator = form ? $(form).data('validator') : null;\n\n        if (validator) {\n            return validator.element(element.get(0));\n        }\n\n        classes = element.prop('class').split(' ');\n        validator = element.parent().data('validator') ||\n            $.mage.validation(validateConfig, element.parent()).validate;\n\n        element.removeClass(validator.settings.errorClass);\n        validator.toHide = validator.toShow;\n        validator.hideErrors();\n        validator.toShow = validator.toHide = $([]);\n\n        $.each(classes, $.proxy(function (i, className) {\n            elementValue = element.val();\n\n            if (element.is(':checkbox') || element.is(':radio')) {\n                elementValue = element.is(':checked') || null;\n            }\n\n            if (this.methods[className] && !this.methods[className](elementValue, element.get(0))) {\n                valid = false;\n                errors[element.get(0).name] = this.messages[className];\n                validator.invalid[element.get(0).name] = true;\n\n                if (!validateConfig.hideError) {\n                    validator.showErrors(errors);\n                }\n\n                return valid;\n            }\n        }, this));\n\n        return valid;\n    };\n\n    $.widget('mage.validation', {\n        options: {\n            meta: 'validate',\n            onfocusout: false,\n            onkeyup: false,\n            onclick: false,\n            ignoreTitle: true,\n            errorClass: 'mage-error',\n            errorElement: 'div',\n\n            /**\n             * @param {*} error\n             * @param {*} element\n             */\n            errorPlacement: function (error, element) {\n                var errorPlacement = element,\n                    fieldWrapper;\n\n                // logic for date-picker error placement\n                if (element.hasClass('_has-datepicker')) {\n                    errorPlacement = element.siblings('button');\n                }\n                // logic for field wrapper\n                fieldWrapper = element.closest('.addon');\n\n                if (fieldWrapper.length) {\n                    errorPlacement = fieldWrapper.after(error);\n                }\n                //logic for checkboxes/radio\n                if (element.is(':checkbox') || element.is(':radio')) {\n                    errorPlacement = element.parents('.control').children().last();\n\n                    //fallback if group does not have .control parent\n                    if (!errorPlacement.length) {\n                        errorPlacement = element.siblings('label').last();\n                    }\n                }\n                //logic for control with tooltip\n                if (element.siblings('.tooltip').length) {\n                    errorPlacement = element.siblings('.tooltip');\n                }\n                //logic for select with tooltip in after element\n                if (element.next().find('.tooltip').length) {\n                    errorPlacement = element.next();\n                }\n                errorPlacement.after(error);\n            }\n        },\n\n        /**\n         * Check if form pass validation rules without submit.\n         *\n         * @return boolean\n         */\n        isValid: function () {\n            return this.element.valid();\n        },\n\n        /**\n         * Remove validation error messages\n         */\n        clearError: function () {\n            if (arguments.length) {\n                $.each(arguments, $.proxy(function (index, item) {\n                    this.validate.prepareElement(item);\n                    this.validate.hideErrors();\n                }, this));\n            } else {\n                this.validate.resetForm();\n            }\n        },\n\n        /**\n         * Validation creation.\n         *\n         * @protected\n         */\n        _create: function () {\n            this.validate = this.element.validate(this.options);\n\n            // ARIA (adding aria-required attribute)\n            this.element\n                .find('.field.required')\n                .find('.control')\n                .find('input, select, textarea')\n                .attr('aria-required', 'true');\n\n            this._listenFormValidate();\n        },\n\n        /**\n         * Validation listening.\n         *\n         * @protected\n         */\n        _listenFormValidate: function () {\n            $('form').on('invalid-form.validate', this.listenFormValidateHandler);\n        },\n\n        /**\n         * Handle form validation. Focus on first invalid form field.\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} validation\n         */\n        listenFormValidateHandler: function (event, validation) {\n            var firstActive = $(validation.errorList[0].element || []),\n                lastActive = $(validation.findLastActive() ||\n                    validation.errorList.length && validation.errorList[0].element || []),\n                windowHeight = $(window).height(),\n                parent, successList;\n\n            if (lastActive.is(':hidden')) {\n                parent = lastActive.parent();\n                $('html, body').animate({\n                    scrollTop: parent.offset().top - windowHeight / 2\n                });\n            }\n\n            // ARIA (removing aria attributes if success)\n            successList = validation.successList;\n\n            if (successList.length) {\n                $.each(successList, function () {\n                    $(this)\n                        .removeAttr('aria-describedby')\n                        .removeAttr('aria-invalid');\n                });\n            }\n\n            if (firstActive.length) {\n                $('body').stop().animate({\n                    scrollTop: firstActive.offset().top - windowHeight / 2\n                });\n                firstActive.focus();\n            }\n        }\n    });\n\n    return $.mage.validation;\n}));\n","mage/app/config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\n/* eslint-disable strict */\ndefine([], function () {\n    return {\n        /**\n         * Get base url.\n         */\n        getBaseUrl: function () {\n            return this.values.baseUrl;\n        },\n\n        /**\n         * Get form key.\n         */\n        getFormKey: function () {\n            return this.values.formKey;\n        }\n    };\n});\n","mage/adminhtml/browser.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global MediabrowserUtility, FORM_KEY, tinyMceEditors */\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'wysiwygAdapter',\n    'Magento_Ui/js/modal/prompt',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/modal',\n    'jquery/ui',\n    'jquery/jstree/jquery.jstree',\n    'mage/mage'\n], function ($, wysiwyg, prompt, confirm, alert) {\n    window.MediabrowserUtility = {\n        windowId: 'modal_dialog_message',\n\n        /**\n         * @return {Number}\n         */\n        getMaxZIndex: function () {\n            var max = 0,\n                cn = document.body.childNodes,\n                i, el, zIndex;\n\n            for (i = 0; i < cn.length; i++) {\n                el = cn[i];\n                zIndex = el.nodeType == 1 ? parseInt(el.style.zIndex, 10) || 0 : 0; //eslint-disable-line eqeqeq\n\n                if (zIndex < 10000) {\n                    max = Math.max(max, zIndex);\n                }\n            }\n\n            return max + 10;\n        },\n\n        /**\n         * @param {*} url\n         * @param {*} width\n         * @param {*} height\n         * @param {*} title\n         * @param {Object} options\n         */\n        openDialog: function (url, width, height, title, options) {\n            var windowId = this.windowId,\n                content = '<div class=\"popup-window\" id=\"' + windowId + '\"></div>',\n                self = this;\n\n            if (this.modal) {\n                this.modal.html($(content).html());\n\n                if (options && typeof options.closed !== 'undefined') {\n                    this.modal.modal('option', 'closed', options.closed);\n                }\n            } else {\n                this.modal = $(content).modal($.extend({\n                    title:  title || 'Insert File...',\n                    modalClass: 'magento',\n                    type: 'slide',\n                    buttons: []\n                }, options));\n            }\n            this.modal.modal('openModal');\n            $.ajax({\n                url: url,\n                type: 'get',\n                context: $(this),\n                showLoader: true\n\n            }).done(function (data) {\n                self.modal.html(data).trigger('contentUpdated');\n            });\n        },\n\n        /**\n         * Close dialog.\n         */\n        closeDialog: function () {\n            this.modal.modal('closeModal');\n        }\n    };\n\n    $.widget('mage.mediabrowser', {\n        eventPrefix: 'mediabrowser',\n        options: {\n            targetElementId: null,\n            contentsUrl: null,\n            onInsertUrl: null,\n            newFolderUrl: null,\n            deleteFolderUrl: null,\n            deleteFilesUrl: null,\n            headerText: null,\n            tree: null,\n            currentNode: null,\n            storeId: null,\n            showBreadcrumbs: null,\n            hidden: 'no-display'\n        },\n\n        /**\n         * Proxy creation\n         * @protected\n         */\n        _create: function () {\n            this._on({\n                'click [data-row=file]': 'selectFile',\n                'dblclick [data-row=file]': 'insert',\n                'click #new_folder': 'newFolder',\n                'click #delete_folder': 'deleteFolder',\n                'click #delete_files': 'deleteFiles',\n                'click #insert_files': 'insertSelectedFiles',\n                'fileuploaddone': '_uploadDone',\n                'click [data-row=breadcrumb]': 'selectFolder'\n            });\n            this.activeNode = null;\n            //tree dont use event bubbling\n            this.tree = this.element.find('[data-role=tree]');\n            this.tree.on('select_node.jstree', $.proxy(this._selectNode, this));\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _selectNode: function (event, data) {\n            var node = data.rslt.obj.data('node');\n\n            this.activeNode = node;\n            this.element.find('#delete_files, #insert_files').toggleClass(this.options.hidden, true);\n            this.element.find('#contents').toggleClass(this.options.hidden, false);\n            this.element.find('#delete_folder')\n                .toggleClass(this.options.hidden, node.id == 'root'); //eslint-disable-line eqeqeq\n            this.element.find('#content_header_text')\n                .html(node.id == 'root' ? this.headerText : node.text); //eslint-disable-line eqeqeq\n\n            this.drawBreadcrumbs(data);\n            this.loadFileList(node);\n        },\n\n        /**\n         * @return {*}\n         */\n        reload: function (uploaded) {\n            return this.loadFileList(this.activeNode, uploaded);\n        },\n\n        /**\n         * @param {Object} element\n         * @param {*} value\n         */\n        insertAtCursor: function (element, value) {\n            var sel, startPos, endPos, scrollTop;\n\n            if ('selection' in document) {\n                //For browsers like Internet Explorer\n                element.focus();\n                sel = document.selection.createRange();\n                sel.text = value;\n                element.focus();\n            } else if (element.selectionStart || element.selectionStart == '0') { //eslint-disable-line eqeqeq\n                //For browsers like Firefox and Webkit based\n                startPos = element.selectionStart;\n                endPos = element.selectionEnd;\n                scrollTop = element.scrollTop;\n                element.value = element.value.substring(0, startPos) + value +\n                    element.value.substring(startPos, endPos) + element.value.substring(endPos, element.value.length);\n                element.focus();\n                element.selectionStart = startPos + value.length;\n                element.selectionEnd = startPos + value.length + element.value.substring(startPos, endPos).length;\n                element.scrollTop = scrollTop;\n            } else {\n                element.value += value;\n                element.focus();\n            }\n        },\n\n        /**\n         * @param {Object} node\n         */\n        loadFileList: function (node, uploaded) {\n            var contentBlock = this.element.find('#contents');\n\n            return $.ajax({\n                url: this.options.contentsUrl,\n                type: 'GET',\n                dataType: 'html',\n                data: {\n                    'form_key': FORM_KEY,\n                    node: node.id\n                },\n                context: contentBlock,\n                showLoader: true\n            }).done(function (data) {\n                contentBlock.html(data).trigger('contentUpdated');\n\n                if (uploaded) {\n                    contentBlock.find('.filecnt:last').click();\n                }\n            });\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        selectFolder: function (event) {\n            this.element.find('[data-id=\"' + $(event.currentTarget).data('node').id + '\"]>a').click();\n        },\n\n        /**\n         * Insert selected files.\n         */\n        insertSelectedFiles: function () {\n            this.element.find('[data-row=file].selected').trigger('dblclick');\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        selectFile: function (event) {\n            var fileRow = $(event.currentTarget);\n\n            fileRow.toggleClass('selected');\n            this.element.find('[data-row=file]').not(fileRow).removeClass('selected');\n            this.element.find('#delete_files, #insert_files')\n                .toggleClass(this.options.hidden, !fileRow.is('.selected'));\n            fileRow.trigger('selectfile');\n        },\n\n        /**\n         * @private\n         */\n        _uploadDone: function () {\n            this.element.find('.file-row').remove();\n            this.reload(true);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @return {Boolean}\n         */\n        insert: function (event) {\n            var fileRow = $(event.currentTarget),\n                targetEl;\n\n            if (!fileRow.prop('id')) {\n                return false;\n            }\n            targetEl = this.getTargetElement();\n\n            if (!targetEl.length) {\n                MediabrowserUtility.closeDialog();\n                throw 'Target element not found for content update';\n            }\n\n            return $.ajax({\n                url: this.options.onInsertUrl,\n                data: {\n                    filename: fileRow.attr('id'),\n                    node: this.activeNode.id,\n                    store: this.options.storeId,\n                    'as_is': targetEl.is('textarea') ? 1 : 0,\n                    'force_static_path': targetEl.data('force_static_path') ? 1 : 0,\n                    'form_key': FORM_KEY\n                },\n                context: this,\n                showLoader: true\n            }).done($.proxy(function (data) {\n                if (targetEl.is('textarea')) {\n                    this.insertAtCursor(targetEl.get(0), data);\n                } else {\n                    targetEl\n                        .val(data)\n                        .data('size', fileRow.data('size'))\n                        .data('mime-type', fileRow.data('mime-type'))\n                        .trigger('change');\n                }\n                MediabrowserUtility.closeDialog();\n                targetEl.focus();\n                jQuery(targetEl).change();\n            }, this));\n        },\n\n        /**\n         * Find document target element in next order:\n         *  in acive file browser opener:\n         *  - input field with ID: \"src\" in opener window\n         *  - input field with ID: \"href\" in opener window\n         *  in document:\n         *  - element with target ID\n         *\n         * return {HTMLElement|null}\n         */\n        getTargetElement: function () {\n            var opener, targetElementId;\n\n            if (typeof wysiwyg != 'undefined' && wysiwyg.get(this.options.targetElementId)) {\n                opener = this.getMediaBrowserOpener() || window;\n                targetElementId = tinyMceEditors.get(this.options.targetElementId).getMediaBrowserTargetElementId();\n\n                return $(opener.document.getElementById(targetElementId));\n            }\n\n            return $('#' + this.options.targetElementId);\n        },\n\n        /**\n         * Return opener Window object if it exists, not closed and editor is active\n         *\n         * return {Object|null}\n         */\n        getMediaBrowserOpener: function () {\n            if (typeof wysiwyg != 'undefined' &&\n                wysiwyg.get(this.options.targetElementId) &&\n                typeof tinyMceEditors != 'undefined' &&\n                !tinyMceEditors.get(this.options.targetElementId).getMediaBrowserOpener().closed\n            ) {\n                return tinyMceEditors.get(this.options.targetElementId).getMediaBrowserOpener();\n            }\n\n            return null;\n        },\n\n        /**\n         * New folder.\n         */\n        newFolder: function () {\n            var self = this;\n\n            prompt({\n                title: this.options.newFolderPrompt,\n                actions: {\n                    /**\n                     * @param {*} folderName\n                     */\n                    confirm: function (folderName) {\n                        return $.ajax({\n                            url: self.options.newFolderUrl,\n                            dataType: 'json',\n                            data: {\n                                name: folderName,\n                                node: self.activeNode.id,\n                                store: self.options.storeId,\n                                'form_key': FORM_KEY\n                            },\n                            context: self.element,\n                            showLoader: true\n                        }).done($.proxy(function (data) {\n                            if (data.error) {\n                                alert({\n                                    content: data.message\n                                });\n                            } else {\n                                self.tree.jstree(\n                                    'refresh',\n                                    self.element.find('[data-id=\"' + self.activeNode.id + '\"]')\n                                );\n                            }\n                        }, this));\n                    }\n                }\n            });\n        },\n\n        /**\n         * Delete folder.\n         */\n        deleteFolder: function () {\n            var self = this;\n\n            confirm({\n                content: this.options.deleteFolderConfirmationMessage,\n                actions: {\n                    /**\n                     * Confirm.\n                     */\n                    confirm: function () {\n                        return $.ajax({\n                            url: self.options.deleteFolderUrl,\n                            dataType: 'json',\n                            data: {\n                                node: self.activeNode.id,\n                                store: self.options.storeId,\n                                'form_key': FORM_KEY\n                            },\n                            context: self.element,\n                            showLoader: true\n                        }).done($.proxy(function () {\n                            self.tree.jstree('refresh', self.activeNode.id);\n                        }, this));\n                    },\n\n                    /**\n                     * @return {Boolean}\n                     */\n                    cancel: function () {\n                        return false;\n                    }\n                }\n            });\n        },\n\n        /**\n         * Delete files.\n         */\n        deleteFiles: function () {\n            var self = this;\n\n            confirm({\n                content: this.options.deleteFileConfirmationMessage,\n                actions: {\n                    /**\n                     * Confirm.\n                     */\n                    confirm: function () {\n                        var selectedFiles = self.element.find('[data-row=file].selected'),\n                            ids = selectedFiles.map(function () {\n                                return $(this).attr('id');\n                            }).toArray();\n\n                        return $.ajax({\n                            url: self.options.deleteFilesUrl,\n                            data: {\n                                files: ids,\n                                store: self.options.storeId,\n                                'form_key': FORM_KEY\n                            },\n                            context: self.element,\n                            showLoader: true\n                        }).done($.proxy(function () {\n                            self.reload();\n                            self.element.find('#delete_files, #insert_files').toggleClass(self.options.hidden, true);\n\n                            $(window).trigger('fileDeleted.mediabrowser', {\n                                ids: ids\n                            });\n                        }, this));\n                    },\n\n                    /**\n                     * @return {Boolean}\n                     */\n                    cancel: function () {\n                        return false;\n                    }\n                }\n            });\n        },\n\n        /**\n         * @param {Object} data\n         */\n        drawBreadcrumbs: function (data) {\n            var node, breadcrumbs;\n\n            if (this.element.find('#breadcrumbs').length) {\n                this.element.find('#breadcrumbs').remove();\n            }\n            node = data.rslt.obj.data('node');\n\n            if (node.id == 'root') { //eslint-disable-line eqeqeq\n                return;\n            }\n            breadcrumbs = $('<ul class=\"breadcrumbs\" id=\"breadcrumbs\" />');\n            $(data.rslt.obj.parents('[data-id]').get().reverse()).add(data.rslt.obj).each(function (index, element) {\n                var nodeData = $(element).data('node');\n\n                if (index > 0) {\n                    breadcrumbs.append($('<li>\\/</li>'));\n                }\n                breadcrumbs.append($('<li />')\n                    .data('node', nodeData).attr('data-row', 'breadcrumb').text(nodeData.text));\n\n            });\n\n            breadcrumbs.insertAfter(this.element.find('#content_header'));\n        }\n    });\n\n    return window.MediabrowserUtility;\n});\n","mage/adminhtml/globals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global setLocation */\ndefine([\n    'Magento_Ui/js/modal/confirm',\n    'mage/dataPost'\n], function (confirm, dataPost) {\n    'use strict';\n\n    /**\n     * Set of a temporary methods used to provide\n     * backward compatibility with a legacy code.\n     */\n    window.setLocation = function (url) {\n        window.location.href = url;\n    };\n\n    /**\n     * Helper for onclick action.\n     * @param {String} message\n     * @param {String} url\n     * @param {Object} postData\n     * @returns {Boolean}\n     */\n    window.deleteConfirm = function (message, url, postData) {\n        confirm({\n            content: message,\n            actions: {\n                /**\n                 * Confirm action.\n                 */\n                confirm: function () {\n                    if (postData !== undefined) {\n                        postData.action = url;\n                        dataPost().postData(postData);\n                    } else {\n                        setLocation(url);\n                    }\n                }\n            }\n        });\n\n        return false;\n    };\n\n    /**\n     * Helper for onclick action.\n     * @param {String} message\n     * @param {String} url\n     * @returns {Boolean}\n     */\n    window.confirmSetLocation = window.deleteConfirm;\n});\n","mage/adminhtml/grid.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n// also depends on a mage/adminhtml/tools.js for Base64 encoding\n/* global varienGrid, setLocation, varienGlobalEvents, FORM_KEY,\n    BASE_URL, Base64, varienGridMassaction, varienStringArray, serializerController\n*/\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'mage/mage',\n    'prototype',\n    'mage/adminhtml/form',\n    'mage/adminhtml/events'\n], function (jQuery, mageTemplate, alert, confirm) {\n    /**\n     * @param {*} grid\n     * @param {*} event\n     */\n    function openGridRow(grid, event) {\n        var element = Event.findElement(event, 'tr');\n\n        if (['a', 'input', 'select', 'option'].indexOf(Event.element(event).tagName.toLowerCase()) !== -1) {\n            return;\n        }\n\n        if (element.title) {\n            setLocation(element.title);\n        }\n    }\n    window.openGridRow = openGridRow;\n\n    window.varienGrid = new Class.create();\n\n    varienGrid.prototype = {\n        /**\n         * @param {String} containerId\n         * @param {String} url\n         * @param {*} pageVar\n         * @param {*} sortVar\n         * @param {*} dirVar\n         * @param {*} filterVar\n         */\n        initialize: function (containerId, url, pageVar, sortVar, dirVar, filterVar) {\n            this.containerId = containerId;\n            jQuery('#' + containerId).data('gridObject', this);\n            this.url = url;\n            this.pageVar = pageVar || false;\n            this.sortVar = sortVar || false;\n            this.dirVar = dirVar || false;\n            this.filterVar = filterVar || false;\n            this.tableSufix = '_table';\n            this.useAjax = false;\n            this.rowClickCallback = false;\n            this.checkboxCheckCallback = false;\n            this.preInitCallback = false;\n            this.initCallback = false;\n            this.initRowCallback = false;\n            this.doFilterCallback = false;\n            this.sortableUpdateCallback = false;\n\n            this.reloadParams = false;\n\n            this.trOnMouseOver = this.rowMouseOver.bindAsEventListener(this);\n            this.trOnMouseOut = this.rowMouseOut.bindAsEventListener(this);\n            this.trOnClick = this.rowMouseClick.bindAsEventListener(this);\n            this.trOnDblClick = this.rowMouseDblClick.bindAsEventListener(this);\n            this.trOnKeyPress = this.keyPress.bindAsEventListener(this);\n\n            this.thLinkOnClick = this.doSort.bindAsEventListener(this);\n            this.initGrid();\n        },\n\n        /**\n         * Init grid.\n         */\n        initGrid: function () {\n            var row, columns, col;\n\n            if (this.preInitCallback) {\n                this.preInitCallback(this);\n            }\n\n            if ($(this.containerId + this.tableSufix)) {\n                this.rows = $$('#' + this.containerId + this.tableSufix + ' tbody tr');\n\n                for (row = 0; row < this.rows.length; row++) {\n                    if (row % 2 == 0) { //eslint-disable-line eqeqeq, max-depth\n                        Element.addClassName(this.rows[row], 'even');\n                    }\n\n                    Event.observe(this.rows[row], 'mouseover', this.trOnMouseOver);\n                    Event.observe(this.rows[row], 'mouseout', this.trOnMouseOut);\n                    Event.observe(this.rows[row], 'click', this.trOnClick);\n                    Event.observe(this.rows[row], 'dblclick', this.trOnDblClick);\n                }\n            }\n\n            if (this.sortVar && this.dirVar) {\n                columns = $$('#' + this.containerId + this.tableSufix + ' thead [data-sort]');\n\n                for (col = 0; col < columns.length; col++) {\n                    Event.observe(columns[col], 'click', this.thLinkOnClick);\n                }\n            }\n            this.bindFilterFields();\n            this.bindFieldsChange();\n\n            if (this.initCallback) {\n                try {\n                    this.initCallback(this);\n                }\n                catch (e) {\n                    if (window.console) { //eslint-disable-line max-depth\n                        console.log(e);\n                    }\n                }\n            }\n            jQuery('#' + this.containerId).trigger('gridinit', this);\n        },\n\n        /**\n         * Init grid ajax.\n         */\n        initGridAjax: function () {\n            this.initGrid();\n            this.initGridRows();\n        },\n\n        /**\n         * Init grid rows.\n         */\n        initGridRows: function () {\n            var row;\n\n            if (this.initRowCallback) {\n                for (row = 0; row < this.rows.length; row++) {\n                    try { //eslint-disable-line max-depth\n                        this.initRowCallback(this, this.rows[row]);\n                    } catch (e) {\n                        if (window.console) { //eslint-disable-line max-depth\n                            console.log(e);\n                        }\n                    }\n                }\n            }\n        },\n\n        /**\n         * @param {*} event\n         */\n        rowMouseOver: function (event) {\n            var element = Event.findElement(event, 'tr');\n\n            if (!element.title) {\n                return;\n            }\n\n            Element.addClassName(element, 'on-mouse');\n\n            if (!Element.hasClassName('_clickable') && (this.rowClickCallback !== openGridRow || element.title)) {\n                if (element.title) {\n                    Element.addClassName(element, '_clickable');\n                }\n            }\n        },\n\n        /**\n         * @param {*} event\n         */\n        rowMouseOut: function (event) {\n            var element = Event.findElement(event, 'tr');\n\n            Element.removeClassName(element, 'on-mouse');\n        },\n\n        /**\n         * @param {*} event\n         */\n        rowMouseClick: function (event) {\n            if (this.rowClickCallback) {\n                try {\n                    this.rowClickCallback(this, event);\n                }\n                catch (e) {\n                }\n            }\n            varienGlobalEvents.fireEvent('gridRowClick', event);\n        },\n\n        /**\n         * @param {*} event\n         */\n        rowMouseDblClick: function (event) {\n            varienGlobalEvents.fireEvent('gridRowDblClick', event);\n        },\n\n        /**\n         * Key press.\n         */\n        keyPress: function () {},\n\n        /**\n         * @param {*} event\n         * @return {Boolean}\n         */\n        doSort: function (event) {\n            var element = Event.findElement(event, 'th');\n\n            if (element.readAttribute('data-sort') && element.readAttribute('data-direction')) {\n                this.addVarToUrl(this.sortVar, element.readAttribute('data-sort'));\n                this.addVarToUrl(this.dirVar, element.readAttribute('data-direction'));\n                this.reload(this.url);\n            }\n            Event.stop(event);\n\n            return false;\n        },\n\n        /**\n         * @param {Object} element\n         */\n        loadByElement: function (element) {\n            if (element && element.name) {\n                this.reload(this.addVarToUrl(element.name, element.value));\n            }\n        },\n\n        /**\n         * @param {*} data\n         * @param {*} textStatus\n         * @param {*} transport\n         * @private\n         */\n        _onAjaxSeccess: function (data, textStatus, transport) {\n            var responseText, response, divId;\n\n            /* eslint-disable max-depth */\n            try {\n                responseText = transport.responseText;\n\n                if (transport.responseText.isJSON()) {\n                    response = transport.responseText.evalJSON();\n\n                    if (response.error) {\n                        alert({\n                            content: response.message\n                        });\n                    }\n\n                    if (response.ajaxExpired && response.ajaxRedirect) {\n                        setLocation(response.ajaxRedirect);\n                    }\n                } else {\n\n                    /*eslint-disable max-len*/\n                    /**\n                     * For IE <= 7.\n                     * If there are two elements, and first has name, that equals id of second.\n                     * In this case, IE will choose one that is above\n                     *\n                     * @see https://prototype.lighthouseapp.com/projects/8886/tickets/994-id-selector-finds-elements-by-name-attribute-in-ie7\n                     */\n\n                    /*eslint-enable max-len*/\n                    divId = $(this.containerId);\n\n                    if (divId.id == this.containerId) { //eslint-disable-line eqeqeq\n                        divId.update(responseText);\n                    } else {\n                        $$('div[id=\"' + this.containerId + '\"]')[0].update(responseText);\n                    }\n                }\n            } catch (e) {\n                divId = $(this.containerId);\n\n                if (divId.id == this.containerId) { //eslint-disable-line eqeqeq\n                    divId.update(responseText);\n                } else {\n                    $$('div[id=\"' + this.containerId + '\"]')[0].update(responseText);\n                }\n            }\n\n            /* eslint-enable max-depth */\n            jQuery('#' + this.containerId).trigger('contentUpdated');\n        },\n\n        /**\n         * @param {*} url\n         * @param {Function} onSuccessCallback\n         * @return {*}\n         */\n        reload: function (url, onSuccessCallback) {\n            var ajaxSettings, ajaxRequest;\n\n            this.reloadParams = this.reloadParams || {};\n            this.reloadParams['form_key'] = FORM_KEY;\n            url = url || this.url;\n\n            if (this.useAjax) {\n                ajaxSettings = {\n                    url: url + (url.match(new RegExp('\\\\?')) ? '&ajax=true' : '?ajax=true'),\n                    showLoader: true,\n                    method: 'post',\n                    context: jQuery('#' + this.containerId),\n                    data: this.reloadParams,\n                    error: this._processFailure.bind(this),\n                    complete: this.initGridAjax.bind(this),\n                    dataType: 'html',\n\n                    /**\n                     * Success callback.\n                     */\n                    success: function (data, textStatus, transport) {\n                        this._onAjaxSeccess(data, textStatus, transport);\n\n                        if (onSuccessCallback && typeof onSuccessCallback === 'function') {\n                            // execute the callback, passing parameters as necessary\n                            onSuccessCallback();\n                        }\n                    }.bind(this)\n                };\n                jQuery('#' + this.containerId).trigger('gridajaxsettings', ajaxSettings);\n                ajaxRequest = jQuery.ajax(ajaxSettings);\n                jQuery('#' + this.containerId).trigger('gridajax', ajaxRequest);\n\n                return ajaxRequest;\n            }\n\n            if (this.reloadParams) {\n                $H(this.reloadParams).each(function (pair) {\n                    url = this.addVarToUrl(pair.key, pair.value);\n                }.bind(this));\n            }\n            location.href = url;\n        },\n\n        /**\n         * @private\n         */\n        _processFailure: function () {\n            location.href = BASE_URL;\n        },\n\n        /**\n         * @param {*} url\n         * @param {*} varName\n         * @param {*} varValue\n         * @return {String|*}\n         * @private\n         */\n        _addVarToUrl: function (url, varName, varValue) {\n            var re = new RegExp('\\/(' + varName + '\\/.*?\\/)'),\n                parts = url.split(new RegExp('\\\\?'));\n\n            url = parts[0].replace(re, '/');\n            url += varName + '/' + varValue + '/';\n\n            if (parts.size() > 1) {\n                url += '?' + parts[1];\n            }\n\n            return url;\n        },\n\n        /**\n         * Builds the form with fields containing the and submits\n         *\n         * @param {String} url\n         * @param {String} varName\n         * @param {String} varValue\n         * @private\n         */\n        _buildFormAndSubmit: function (url, varName, varValue) {\n            var re = new RegExp('\\/(' + varName + '\\/.*?\\/)'),\n                parts = url.split(new RegExp('\\\\?')),\n                form = jQuery('<form/>'),\n                inputProps = [\n                    {\n                        name: varName,\n                        value: varValue\n                    },\n                    {\n                        name: 'form_key',\n                        value: window.FORM_KEY\n                    }\n                ],\n                input;\n\n            url = parts[0].replace(re, '/');\n\n            if (parts.size() > 1) {\n                url += '?' + parts[1];\n            }\n\n            form.attr('action', url);\n            form.attr('method', 'POST');\n\n            inputProps.forEach(function (item) {\n                input = jQuery('<input/>');\n                input.attr('name', item.name);\n                input.attr('type', 'hidden');\n                input.val(item.value);\n                form.append(input);\n            });\n            jQuery('[data-container=\"body\"]').append(form);\n            form.submit();\n            form.remove();\n        },\n\n        /**\n         * @param {*} varName\n         * @param {*} varValue\n         * @return {*|String}\n         */\n        addVarToUrl: function (varName, varValue) {\n            this.url = this._addVarToUrl(this.url, varName, varValue);\n\n            return this.url;\n        },\n\n        /**\n         * Do export.\n         */\n        doExport: function () {\n            var exportUrl;\n\n            if ($(this.containerId + '_export')) {\n                exportUrl = $(this.containerId + '_export').value;\n\n                if (this.massaction && this.massaction.checkedString) {\n                    this._buildFormAndSubmit(\n                        exportUrl,\n                        this.massaction.formFieldNameInternal,\n                        this.massaction.checkedString\n                    );\n                } else {\n                    location.href = exportUrl;\n                }\n            }\n        },\n\n        /**\n         * Bind filter fields.\n         */\n        bindFilterFields: function () {\n            var filters = $$(\n                    '#' + this.containerId + ' [data-role=\"filter-form\"] input',\n                    '#' + this.containerId + ' [data-role=\"filter-form\"] select'\n                ),\n                i;\n\n            for (i = 0; i < filters.length; i++) {\n                Event.observe(filters[i], 'keypress', this.filterKeyPress.bind(this));\n            }\n        },\n\n        /**\n         * Bind field change.\n         */\n        bindFieldsChange: function () {\n            var dataElements, i;\n\n            if (!$(this.containerId)) {\n                return;\n            }\n            //var dataElements = $(this.containerId+this.tableSufix).down('.data tbody').select('input', 'select');\n            dataElements = $(this.containerId + this.tableSufix).down('tbody').select('input', 'select');\n\n            for (i = 0; i < dataElements.length; i++) {\n                Event.observe(dataElements[i], 'change', dataElements[i].setHasChanges.bind(dataElements[i]));\n            }\n        },\n\n        /**\n         * Bind sortable.\n         */\n        bindSortable: function () {\n            if (jQuery('#' + this.containerId).find('.draggable-handle').length) {\n                jQuery('#' + this.containerId).find('tbody').sortable({\n                    axis: 'y',\n                    handle: '.draggable-handle',\n\n                    /**\n                     * @param {*} event\n                     * @param {*} ui\n                     * @return {*}\n                     */\n                    helper: function (event, ui) {\n                        ui.children().each(function () {\n                            jQuery(this).width(jQuery(this).width());\n                        });\n\n                        return ui;\n                    },\n                    update: this.sortableUpdateCallback ? this.sortableUpdateCallback : function () {},\n                    tolerance: 'pointer'\n                });\n            }\n        },\n\n        /**\n         * @param {Object} event\n         */\n        filterKeyPress: function (event) {\n            if (event.keyCode == Event.KEY_RETURN) { //eslint-disable-line eqeqeq\n                this.doFilter();\n            }\n        },\n\n        /**\n         * @param {Function} callback\n         */\n        doFilter: function (callback) {\n            var filters = $$(\n                    '#' + this.containerId + ' [data-role=\"filter-form\"] input',\n                    '#' + this.containerId + ' [data-role=\"filter-form\"] select'\n                ),\n                elements = [],\n                i;\n\n            for (i in filters) {\n                if (filters[i].value && filters[i].value.length) {\n                    elements.push(filters[i]);\n                }\n            }\n\n            if (!this.doFilterCallback || this.doFilterCallback && this.doFilterCallback()) {\n                this.reload(\n                    this.addVarToUrl(this.filterVar, Base64.encode(Form.serializeElements(elements))),\n                    callback\n                );\n            }\n        },\n\n        /**\n         * @param {Function} callback\n         */\n        resetFilter: function (callback) {\n            this.reload(this.addVarToUrl(this.filterVar, ''), callback);\n        },\n\n        /**\n         * @param {Object} element\n         */\n        checkCheckboxes: function (element) {\n            var elements = Element.select($(this.containerId), 'input[name=\"' + element.name + '\"]'),\n                i;\n\n            for (i = 0; i < elements.length; i++) {\n                this.setCheckboxChecked(elements[i], element.checked);\n            }\n\n            /*eslint-enable no-undef*/\n        },\n\n        /**\n         *\n         * @param {HTMLElement} element\n         * @param {*} checked\n         */\n        setCheckboxChecked: function (element, checked) {\n            element.checked = checked;\n            jQuery(element).trigger('change');\n            element.setHasChanges({});\n\n            if (this.checkboxCheckCallback) {\n                this.checkboxCheckCallback(this, element, checked);\n            }\n        },\n\n        /**\n         * @param {Object} event\n         * @param {*} lastId\n         */\n        inputPage: function (event, lastId) {\n            var element = Event.element(event),\n                keyCode = event.keyCode || event.which,\n                enteredValue = parseInt(element.value, 10),\n                pageId = parseInt(lastId, 10);\n\n            if (keyCode == Event.KEY_RETURN) { //eslint-disable-line eqeqeq\n                if (enteredValue > pageId) {\n                    this.setPage(pageId);\n                } else {\n                    this.setPage(enteredValue);\n                }\n            }\n\n            /*if(keyCode>47 && keyCode<58){\n\n             }\n             else{\n             Event.stop(event);\n             }*/\n        },\n\n        /**\n         * @param {*} pageNumber\n         */\n        setPage: function (pageNumber) {\n            this.reload(this.addVarToUrl(this.pageVar, pageNumber));\n        }\n    };\n\n    window.varienGridMassaction = Class.create();\n    varienGridMassaction.prototype = {\n        /* Predefined vars */\n        checkedValues: $H({}),\n        checkedString: '',\n        oldCallbacks: {},\n        errorText: '',\n        items: {},\n        gridIds: [],\n        useSelectAll: false,\n        currentItem: false,\n        lastChecked: {\n            left: false,\n            top: false,\n            checkbox: false\n        },\n        fieldTemplate: mageTemplate('<input type=\"hidden\" name=\"<%- name %>\" value=\"<%- value %>\" />'),\n\n        /**\n         * @param {*} containerId\n         * @param {*} grid\n         * @param {*} checkedValues\n         * @param {*} formFieldNameInternal\n         * @param {*} formFieldName\n         */\n        initialize: function (containerId, grid, checkedValues, formFieldNameInternal, formFieldName) {\n            this.setOldCallback('row_click', grid.rowClickCallback);\n            this.setOldCallback('init',      grid.initCallback);\n            this.setOldCallback('init_row',  grid.initRowCallback);\n            this.setOldCallback('pre_init',  grid.preInitCallback);\n\n            this.useAjax        = false;\n            this.grid           = grid;\n            this.grid.massaction = this;\n            this.containerId    = containerId;\n            this.initMassactionElements();\n\n            this.checkedString          = checkedValues;\n            this.formFieldName          = formFieldName;\n            this.formFieldNameInternal  = formFieldNameInternal;\n\n            this.grid.initCallback      = this.onGridInit.bind(this);\n            this.grid.preInitCallback   = this.onGridPreInit.bind(this);\n            this.grid.initRowCallback   = this.onGridRowInit.bind(this);\n            this.grid.rowClickCallback  = this.onGridRowClick.bind(this);\n            this.initCheckboxes();\n            this.checkCheckboxes();\n        },\n\n        /**\n         * @param {*} flag\n         */\n        setUseAjax: function (flag) {\n            this.useAjax = flag;\n        },\n\n        /**\n         * @param {*} flag\n         */\n        setUseSelectAll: function (flag) {\n            this.useSelectAll = flag;\n        },\n\n        /**\n         * Init massaction elements.\n         */\n        initMassactionElements: function () {\n            this.container      = $(this.containerId);\n            this.multiselect    = $(this.containerId + '-mass-select');\n            this.count          = $(this.containerId + '-count');\n            this.formHiddens    = $(this.containerId + '-form-hiddens');\n            this.formAdditional = $(this.containerId + '-form-additional');\n            this.select         = $(this.containerId + '-select');\n            this.form           = this.prepareForm();\n            jQuery(this.form).mage('validation');\n            this.select.observe('change', this.onSelectChange.bindAsEventListener(this));\n            this.lastChecked    = {\n                left: false,\n                top: false,\n                checkbox: false\n            };\n            this.select.addClassName(this.select.value ? '_selected' : '');\n            this.initMassSelect();\n        },\n\n        /**\n         * @return {jQuery|*|HTMLElement}\n         */\n        prepareForm: function () {\n            var form = $(this.containerId + '-form'),\n                formPlace = null,\n                formElement = this.formHiddens || this.formAdditional;\n\n            if (!formElement) {\n                formElement = this.container.getElementsByTagName('button')[0];\n                formElement && formElement.parentNode;\n            }\n\n            if (!form && formElement) {\n                /* fix problem with rendering form in FF through innerHTML property */\n                form = document.createElement('form');\n                form.setAttribute('method', 'post');\n                form.setAttribute('action', '');\n                form.id = this.containerId + '-form';\n                formPlace = formElement.parentNode;\n                formPlace.parentNode.appendChild(form);\n                form.appendChild(formPlace);\n            }\n\n            return form;\n        },\n\n        /**\n         * @param {Array} gridIds\n         */\n        setGridIds: function (gridIds) {\n            this.gridIds = gridIds;\n            this.updateCount();\n        },\n\n        /**\n         * @return {Array}\n         */\n        getGridIds: function () {\n            return this.gridIds;\n        },\n\n        /**\n         * @param {*} items\n         */\n        setItems: function (items) {\n            this.items = items;\n            this.updateCount();\n        },\n\n        /**\n         * @return {Object}\n         */\n        getItems: function () {\n            return this.items;\n        },\n\n        /**\n         * @param {*} itemId\n         * @return {*}\n         */\n        getItem: function (itemId) {\n            if (this.items[itemId]) {\n                return this.items[itemId];\n            }\n\n            return false;\n        },\n\n        /**\n         * @param {String} callbackName\n         * @return {Function}\n         */\n        getOldCallback: function (callbackName) {\n            return this.oldCallbacks[callbackName] ? this.oldCallbacks[callbackName] : Prototype.emptyFunction;\n        },\n\n        /**\n         * @param {String} callbackName\n         * @param {Function} callback\n         */\n        setOldCallback: function (callbackName, callback) {\n            this.oldCallbacks[callbackName] = callback;\n        },\n\n        /**\n         * @param {*} grid\n         */\n        onGridPreInit: function (grid) {\n            this.initMassactionElements();\n            this.getOldCallback('pre_init')(grid);\n        },\n\n        /**\n         * @param {*} grid\n         */\n        onGridInit: function (grid) {\n            this.initCheckboxes();\n            this.checkCheckboxes();\n            this.updateCount();\n            this.getOldCallback('init')(grid);\n        },\n\n        /**\n         * @param {*} grid\n         * @param {*} row\n         */\n        onGridRowInit: function (grid, row) {\n            this.getOldCallback('init_row')(grid, row);\n        },\n\n        /**\n         * @param {Object} evt\n         */\n        isDisabled: function (evt) {\n            var target = jQuery(evt.target),\n                tr,\n                checkbox;\n\n            tr = target.is('tr') ? target : target.closest('tr');\n            checkbox = tr.find('input[type=\"checkbox\"]');\n\n            return checkbox.is(':disabled');\n        },\n\n        /**\n         * @param {*} grid\n         * @param {*} evt\n         * @return {*}\n         */\n        onGridRowClick: function (grid, evt) {\n            var tdElement = Event.findElement(evt, 'td'),\n                trElement = Event.findElement(evt, 'tr'),\n                checkbox, isInput, checked;\n\n            if (this.isDisabled(evt)) {\n                return false;\n            }\n\n            if (!$(tdElement).down('input')) {\n                if ($(tdElement).down('a') || $(tdElement).down('select')) {\n                    return; //eslint-disable-line\n                }\n\n                if (trElement.title && trElement.title.strip() != '#') { //eslint-disable-line eqeqeq\n                    this.getOldCallback('row_click')(grid, evt);\n                } else {\n                    checkbox = Element.select(trElement, 'input');\n                    isInput  = Event.element(evt).tagName == 'input'; //eslint-disable-line eqeqeq\n                    checked = isInput ? checkbox[0].checked : !checkbox[0].checked;\n\n                    if (checked) { //eslint-disable-line max-depth\n                        this.checkedString = varienStringArray.add(checkbox[0].value, this.checkedString);\n                    } else {\n                        this.checkedString = varienStringArray.remove(checkbox[0].value, this.checkedString);\n                    }\n                    this.grid.setCheckboxChecked(checkbox[0], checked);\n                    this.updateCount();\n                }\n\n                return; //eslint-disable-line\n            }\n\n            if (Event.element(evt).isMassactionCheckbox) {\n                this.setCheckbox(Event.element(evt));\n            } else if (checkbox = this.findCheckbox(evt)) { //eslint-disable-line no-cond-assign\n                checkbox.checked = !checkbox.checked;\n                jQuery(checkbox).trigger('change');\n                this.setCheckbox(checkbox);\n            }\n        },\n\n        /**\n         * @param {Object} evt\n         */\n        onSelectChange: function (evt) {\n            var item = this.getSelectedItem();\n\n            if (item) {\n                this.formAdditional.update($(this.containerId + '-item-' + item.id + '-block').innerHTML);\n                evt.target.addClassName('_selected');\n            } else {\n                this.formAdditional.update('');\n                evt.target.removeClassName('_selected');\n            }\n            jQuery(this.form).data('validator').resetForm();\n        },\n\n        /**\n         * @param {Object} evt\n         * @return {*}\n         */\n        findCheckbox: function (evt) {\n            if (['a', 'input', 'select'].indexOf(Event.element(evt).tagName.toLowerCase()) !== -1) {\n                return false;\n            }\n            checkbox = false; //eslint-disable-line no-undef\n            Event.findElement(evt, 'tr').select('[data-role=\"select-row\"]').each(function (element) { //eslint-disable-line\n                if (element.isMassactionCheckbox) {\n                    checkbox = element; //eslint-disable-line no-undef\n                }\n            });\n\n            return checkbox; //eslint-disable-line no-undef\n        },\n\n        /**\n         * Init checkobox.\n         */\n        initCheckboxes: function () {\n            this.getCheckboxes().each(function (checkbox) { //eslint-disable-line no-extra-bind\n                checkbox.isMassactionCheckbox = true; //eslint-disable-line no-undef\n            });\n        },\n\n        /**\n         * Check checkbox.\n         */\n        checkCheckboxes: function () {\n            this.getCheckboxes().each(function (checkbox) {\n                checkbox.checked = varienStringArray.has(checkbox.value, this.checkedString);\n                jQuery(checkbox).trigger('change');\n            }.bind(this));\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        selectAll: function () {\n            this.setCheckedValues(this.useSelectAll ? this.getGridIds() : this.getCheckboxesValuesAsString());\n            this.checkCheckboxes();\n            this.updateCount();\n            this.clearLastChecked();\n\n            return false;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        unselectAll: function () {\n            this.setCheckedValues('');\n            this.checkCheckboxes();\n            this.updateCount();\n            this.clearLastChecked();\n\n            return false;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        selectVisible: function () {\n            this.setCheckedValues(this.getCheckboxesValuesAsString());\n            this.checkCheckboxes();\n            this.updateCount();\n            this.clearLastChecked();\n\n            return false;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        unselectVisible: function () {\n            this.getCheckboxesValues().each(function (key) {\n                this.checkedString = varienStringArray.remove(key, this.checkedString);\n            }.bind(this));\n            this.checkCheckboxes();\n            this.updateCount();\n            this.clearLastChecked();\n\n            return false;\n        },\n\n        /**\n         * @param {*} values\n         */\n        setCheckedValues: function (values) {\n            this.checkedString = values;\n        },\n\n        /**\n         * @return {String}\n         */\n        getCheckedValues: function () {\n            return this.checkedString;\n        },\n\n        /**\n         * @return {Array}\n         */\n        getCheckboxes: function () {\n            var result = [];\n\n            this.grid.rows.each(function (row) {\n                var checkboxes = row.select('[data-role=\"select-row\"]');\n\n                checkboxes.each(function (checkbox) {\n                    result.push(checkbox);\n                });\n            });\n\n            return result;\n        },\n\n        /**\n         * @return {Array}\n         */\n        getCheckboxesValues: function () {\n            var result = [];\n\n            this.getCheckboxes().each(function (checkbox) { //eslint-disable-line no-extra-bind\n                result.push(checkbox.value);\n            });\n\n            return result;\n        },\n\n        /**\n         * @return {String}\n         */\n        getCheckboxesValuesAsString: function () {\n            return this.getCheckboxesValues().join(',');\n        },\n\n        /**\n         * @param {Object} checkbox\n         */\n        setCheckbox: function (checkbox) {\n            if (checkbox.checked) {\n                this.checkedString = varienStringArray.add(checkbox.value, this.checkedString);\n            } else {\n                this.checkedString = varienStringArray.remove(checkbox.value, this.checkedString);\n            }\n            this.updateCount();\n        },\n\n        /**\n         * Update count.\n         */\n        updateCount: function () {\n            var checkboxesTotal = varienStringArray.count(\n                this.useSelectAll ? this.getGridIds() : this.getCheckboxesValuesAsString()\n                ),\n                checkboxesChecked = varienStringArray.count(this.checkedString);\n\n            jQuery('[data-role=\"counter\"]', this.count).html(checkboxesChecked);\n\n            if (!checkboxesTotal) {\n                this.multiselect.addClassName('_disabled');\n            } else {\n                this.multiselect.removeClassName('_disabled');\n            }\n\n            if (checkboxesChecked == checkboxesTotal && checkboxesTotal != 0) { //eslint-disable-line eqeqeq\n                this.count.removeClassName('_empty');\n                this.multiselect.addClassName('_checked').removeClassName('_indeterminate');\n            } else if (checkboxesChecked == 0) { //eslint-disable-line eqeqeq\n                this.count.addClassName('_empty');\n                this.multiselect.removeClassName('_checked').removeClassName('_indeterminate');\n            } else {\n                this.count.removeClassName('_empty');\n                this.multiselect.addClassName('_checked').addClassName('_indeterminate');\n            }\n\n            if (!this.grid.reloadParams) {\n                this.grid.reloadParams = {};\n            }\n            this.grid.reloadParams[this.formFieldNameInternal] = this.checkedString;\n        },\n\n        /**\n         * @return {*}\n         */\n        getSelectedItem: function () {\n            if (this.getItem(this.select.value)) {\n                return this.getItem(this.select.value);\n            }\n\n            return false;\n        },\n\n        /**\n         * Apply.\n         */\n        apply: function () {\n            var item, fieldName;\n\n            if (varienStringArray.count(this.checkedString) == 0) { //eslint-disable-line eqeqeq\n                alert({\n                    content: this.errorText\n                });\n\n                return;\n            }\n\n            item = this.getSelectedItem();\n\n            if (!item) {\n                jQuery(this.form).valid();\n\n                return;\n            }\n            this.currentItem = item;\n            fieldName = item.field ? item.field : this.formFieldName;\n\n            if (this.currentItem.confirm) {\n                confirm({\n                    content: this.currentItem.confirm,\n                    actions: {\n                        confirm: this.onConfirm.bind(this, fieldName, item)\n                    }\n                });\n            } else {\n                this.onConfirm(fieldName, item);\n            }\n        },\n\n        /**\n         * @param {*} fieldName\n         * @param {*} item\n         */\n        onConfirm: function (fieldName, item) {\n            this.formHiddens.update('');\n            new Insertion.Bottom(this.formHiddens, this.fieldTemplate({\n                name: fieldName,\n                value: this.checkedString\n            }));\n            new Insertion.Bottom(this.formHiddens, this.fieldTemplate({\n                name: 'massaction_prepare_key',\n                value: fieldName\n            }));\n\n            if (!jQuery(this.form).valid()) {\n                return;\n            }\n\n            if (this.useAjax && item.url) {\n                new Ajax.Request(item.url, {\n                    'method': 'post',\n                    'parameters': this.form.serialize(true),\n                    'onComplete': this.onMassactionComplete.bind(this)\n                });\n            } else if (item.url) {\n                this.form.action = item.url;\n                this.form.submit();\n            }\n        },\n\n        /**\n         * @param {*} transport\n         */\n        onMassactionComplete: function (transport) {\n            var listener;\n\n            if (this.currentItem.complete) {\n                try {\n                    listener = this.getListener(this.currentItem.complete) || Prototype.emptyFunction;\n                    listener(this.grid, this, transport);\n                } catch (e) {}\n            }\n        },\n\n        /**\n         * @param {*} strValue\n         * @return {Object}\n         */\n        getListener: function (strValue) {\n            return eval(strValue); //eslint-disable-line no-eval\n        },\n\n        /**\n         * Init mass select.\n         */\n        initMassSelect: function () {\n            $$('input[data-role=\"select-row\"]').each(function (element) {\n                element.observe('click', this.massSelect.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Clear last checked.\n         */\n        clearLastChecked: function () {\n            this.lastChecked = {\n                left: false,\n                top: false,\n                checkbox: false\n            };\n        },\n\n        /**\n         * @param {Object} evt\n         */\n        massSelect: function (evt) {\n            var currentCheckbox, lastCheckbox, start, finish;\n\n            if (this.lastChecked.left !== false &&\n                this.lastChecked.top !== false &&\n                evt.button === 0 &&\n                evt.shiftKey === true\n            ) {\n                currentCheckbox = Event.element(evt);\n                lastCheckbox = this.lastChecked.checkbox;\n\n                if (lastCheckbox != currentCheckbox) { //eslint-disable-line eqeqeq\n                    start = this.getCheckboxOrder(lastCheckbox);\n                    finish = this.getCheckboxOrder(currentCheckbox);\n\n                    if (start !== false && finish !== false) { //eslint-disable-line max-depth\n                        this.selectCheckboxRange(\n                            Math.min(start, finish),\n                            Math.max(start, finish),\n                            currentCheckbox.checked\n                        );\n                    }\n                }\n            }\n\n            this.lastChecked = {\n                left: Event.element(evt).viewportOffset().left,\n                top: Event.element(evt).viewportOffset().top,\n                checkbox: Event.element(evt) // \"boundary\" checkbox\n            };\n        },\n\n        /**\n         * @param {*} curCheckbox\n         * @return {Boolean}\n         */\n        getCheckboxOrder: function (curCheckbox) {\n            var order = false;\n\n            this.getCheckboxes().each(function (checkbox, key) {\n                if (curCheckbox == checkbox) { //eslint-disable-line eqeqeq\n                    order = key;\n                }\n            });\n\n            return order;\n        },\n\n        /**\n         * @param {*} start\n         * @param {*} finish\n         * @param {*} isChecked\n         */\n        selectCheckboxRange: function (start, finish, isChecked) {\n            this.getCheckboxes().each(function (checkbox, key) {\n                if (key >= start && key <= finish) {\n                    checkbox.checked = isChecked;\n                    this.setCheckbox(checkbox);\n                }\n            }.bind(this));\n        }\n    };\n\n    window.varienGridAction = {\n        /**\n         * @param {Object} select\n         */\n        execute: function (select) {\n            var config, win;\n\n            if (!select.value || !select.value.isJSON()) {\n                return;\n            }\n\n            config = select.value.evalJSON();\n\n            if (config.confirm && !window.confirm(config.confirm)) { //eslint-disable-line no-alert\n                select.options[0].selected = true;\n\n                return;\n            }\n\n            if (config.popup) {\n                win = window.open(config.href, 'action_window', 'width=500,height=600,resizable=1,scrollbars=1');\n                win.focus();\n                select.options[0].selected = true;\n            } else {\n                setLocation(config.href);\n            }\n        }\n    };\n\n    window.varienStringArray = {\n        /**\n         * @param {*} str\n         * @param {*} haystack\n         * @return {*}\n         */\n        remove: function (str, haystack) {\n            haystack = ',' + haystack + ',';\n            haystack = haystack.replace(new RegExp(',' + str + ',', 'g'), ',');\n\n            return this.trimComma(haystack);\n        },\n\n        /**\n         * @param {*} str\n         * @param {*} haystack\n         * @return {*}\n         */\n        add: function (str, haystack) {\n            haystack = ',' + haystack + ',';\n\n            if (haystack.search(new RegExp(',' + str + ',', 'g'), haystack) === -1) {\n                haystack += str + ',';\n            }\n\n            return this.trimComma(haystack);\n        },\n\n        /**\n         * @param {*} str\n         * @param {*} haystack\n         * @return {Boolean}\n         */\n        has: function (str, haystack) {\n            haystack = ',' + haystack + ',';\n\n            if (haystack.search(new RegExp(',' + str + ',', 'g'), haystack) === -1) {\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * @param {*} haystack\n         * @return {*}\n         */\n        count: function (haystack) {\n            var match;\n\n            if (typeof haystack != 'string') {\n                return 0;\n            }\n\n            /* eslint-disable no-undef, no-cond-assign, eqeqeq */\n            if (match = haystack.match(new RegExp(',', 'g'))) {\n                return match.length + 1;\n            } else if (haystack.length != 0) {\n                return 1;\n            }\n\n            /* eslint-enable no-undef, no-cond-assign, eqeqeq */\n            return 0;\n        },\n\n        /**\n         * @param {*} haystack\n         * @param {*} fnc\n         */\n        each: function (haystack, fnc) {\n            var i;\n\n            haystack = haystack.split(',');\n\n            for (i = 0; i < haystack.length; i++) {\n                fnc(haystack[i]);\n            }\n        },\n\n        /**\n         * @param {String} string\n         * @return {String}\n         */\n        trimComma: function (string) {\n            string = string.replace(new RegExp('^(,+)','i'), '');\n            string = string.replace(new RegExp('(,+)$','i'), '');\n\n            return string;\n        }\n    };\n\n    window.serializerController = Class.create();\n    serializerController.prototype = {\n        oldCallbacks: {},\n\n        /**\n         * @param {*} hiddenDataHolder\n         * @param {*} predefinedData\n         * @param {*} inputsToManage\n         * @param {*} grid\n         * @param {*} reloadParamName\n         */\n        initialize: function (hiddenDataHolder, predefinedData, inputsToManage, grid, reloadParamName) {\n            //Grid inputs\n            this.tabIndex = 1000;\n            this.inputsToManage       = inputsToManage;\n            this.multidimensionalMode = inputsToManage.length > 0;\n\n            //Hash with grid data\n            this.gridData             = this.getGridDataHash(predefinedData);\n\n            //Hidden input data holder\n            this.hiddenDataHolder     = $(hiddenDataHolder);\n            this.hiddenDataHolder.value = this.serializeObject();\n\n            this.grid = grid;\n\n            // Set old callbacks\n            this.setOldCallback('row_click', this.grid.rowClickCallback);\n            this.setOldCallback('init_row', this.grid.initRowCallback);\n            this.setOldCallback('checkbox_check', this.grid.checkboxCheckCallback);\n\n            //Grid\n            this.reloadParamName = reloadParamName;\n            this.grid.reloadParams = {};\n            this.grid.reloadParams[this.reloadParamName + '[]'] = this.getDataForReloadParam();\n            this.grid.rowClickCallback = this.rowClick.bind(this);\n            this.grid.initRowCallback = this.rowInit.bind(this);\n            this.grid.checkboxCheckCallback = this.registerData.bind(this);\n            this.grid.rows.each(this.eachRow.bind(this));\n        },\n\n        /**\n         * @param {String} callbackName\n         * @param {Function} callback\n         */\n        setOldCallback: function (callbackName, callback) {\n            this.oldCallbacks[callbackName] = callback;\n        },\n\n        /**\n         * @param {String} callbackName\n         * @return {Prototype.emptyFunction}\n         */\n        getOldCallback: function (callbackName) {\n            return this.oldCallbacks[callbackName] ? this.oldCallbacks[callbackName] : Prototype.emptyFunction;\n        },\n\n        /**\n         * @param {*} grid\n         * @param {*} element\n         * @param {*} checked\n         */\n        registerData: function (grid, element, checked) {\n            var i;\n\n            if (this.multidimensionalMode) {\n                if (checked) {\n                    /*eslint-disable max-depth*/\n                    if (element.inputElements) {\n                        this.gridData.set(element.value, {});\n\n                        for (i = 0; i < element.inputElements.length; i++) {\n                            element.inputElements[i].disabled = false;\n                            this.gridData.get(element.value)[element.inputElements[i].name] =\n                                element.inputElements[i].value;\n                        }\n                    }\n                } else {\n                    if (element.inputElements) {\n                        for (i = 0; i < element.inputElements.length; i++) {\n                            element.inputElements[i].disabled = true;\n                        }\n                    }\n                    this.gridData.unset(element.value);\n                }\n            } else {\n                if (checked) { //eslint-disable-line no-lonely-if\n                    this.gridData.set(element.value, element.value);\n                } else {\n                    this.gridData.unset(element.value);\n                }\n            }\n\n            this.hiddenDataHolder.value = this.serializeObject();\n            this.grid.reloadParams = {};\n            this.grid.reloadParams[this.reloadParamName + '[]'] = this.getDataForReloadParam();\n            this.getOldCallback('checkbox_check')(grid, element, checked);\n\n            /*eslint-enable max-depth*/\n        },\n\n        /**\n         * @param {*} row\n         */\n        eachRow: function (row) {\n            this.rowInit(this.grid, row);\n        },\n\n        /**\n         * @param {*} grid\n         * @param {*} event\n         */\n        rowClick: function (grid, event) {\n            var trElement = Event.findElement(event, 'tr'),\n                isInput   = Event.element(event).tagName == 'INPUT', //eslint-disable-line eqeqeq\n                checkbox, checked;\n\n            if (trElement) {\n                checkbox = Element.select(trElement, 'input');\n\n                if (checkbox[0] && !checkbox[0].disabled) {\n                    checked = isInput ? checkbox[0].checked : !checkbox[0].checked;\n                    this.grid.setCheckboxChecked(checkbox[0], checked);\n                }\n            }\n            this.getOldCallback('row_click')(grid, event);\n        },\n\n        /**\n         * @param {*} event\n         */\n        inputChange: function (event) {\n            var element = Event.element(event);\n\n            if (element && element.checkboxElement && element.checkboxElement.checked) {\n                this.gridData.get(element.checkboxElement.value)[element.name] = element.value;\n                this.hiddenDataHolder.value = this.serializeObject();\n            }\n        },\n\n        /**\n         * @param {*} grid\n         * @param {*} row\n         */\n        rowInit: function (grid, row) {\n            var checkbox, selectors, inputs, i;\n\n            if (this.multidimensionalMode) {\n                checkbox = $(row).select('.checkbox')[0];\n                selectors = this.inputsToManage.map(function (name) {\n                    return ['input[name=\"' + name + '\"]', 'select[name=\"' + name + '\"]'];\n                });\n                inputs = $(row).select.apply($(row), selectors.flatten());\n\n                if (checkbox && inputs.length > 0) {\n                    checkbox.inputElements = inputs;\n\n                    /* eslint-disable max-depth */\n                    for (i = 0; i < inputs.length; i++) {\n                        inputs[i].checkboxElement = checkbox;\n\n                        if (this.gridData.get(checkbox.value) && this.gridData.get(checkbox.value)[inputs[i].name]) {\n                            inputs[i].value = this.gridData.get(checkbox.value)[inputs[i].name];\n                        }\n                        inputs[i].disabled = !checkbox.checked;\n                        inputs[i].tabIndex = this.tabIndex++;\n                        Event.observe(inputs[i], 'keyup', this.inputChange.bind(this));\n                        Event.observe(inputs[i], 'change', this.inputChange.bind(this));\n                    }\n                }\n            }\n\n            /* eslint-enable max-depth */\n            this.getOldCallback('init_row')(grid, row);\n        },\n\n        /**\n         * Stuff methods.\n         *\n         * @param {*} _object\n         * @return {*}\n         */\n        getGridDataHash: function (_object) {\n            return $H(this.multidimensionalMode ? _object : this.convertArrayToObject(_object));\n        },\n\n        /**\n         * @return {*}\n         */\n        getDataForReloadParam: function () {\n            return this.multidimensionalMode ? this.gridData.keys() : this.gridData.values();\n        },\n\n        /**\n         * @return {*}\n         */\n        serializeObject: function () {\n            var clone;\n\n            if (this.multidimensionalMode) {\n                clone = this.gridData.clone();\n                clone.each(function (pair) {\n                    clone.set(pair.key, Base64.encode(Object.toQueryString(pair.value)));\n                });\n\n                return clone.toQueryString();\n            }\n\n            return this.gridData.values().join('&');\n        },\n\n        /**\n         * @param {Array} _array\n         * @return {Object}\n         */\n        convertArrayToObject: function (_array) {\n            var _object = {},\n                i, l;\n\n            for (i = 0, l = _array.length; i < l; i++) {\n                _object[_array[i]] = _array[i];\n            }\n\n            return _object;\n        }\n    };\n});\n","mage/adminhtml/events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global varienEvents */\n/* eslint-disable strict */\ndefine([\n    'Magento_Ui/js/modal/alert',\n    'prototype'\n], function (alert) {\n    // from http://www.someelement.com/2007/03/eventpublisher-custom-events-la-pubsub.html\n    window.varienEvents = Class.create();\n\n    varienEvents.prototype = {\n        /**\n         * Initialize.\n         */\n        initialize: function () {\n            this.arrEvents = {};\n            this.eventPrefix = '';\n        },\n\n        /**\n        * Attaches a {handler} function to the publisher's {eventName} event for execution upon the event firing\n        * @param {String} eventName\n        * @param {Function} handler\n        * @param {Boolean} [asynchFlag] - Defaults to false if omitted.\n        * Indicates whether to execute {handler} asynchronously (true) or not (false).\n        */\n        attachEventHandler: function (eventName, handler) {\n            var asynchVar, handlerObj;\n\n            if (typeof handler == 'undefined' || handler == null) {\n                return;\n            }\n            eventName += this.eventPrefix;\n            // using an event cache array to track all handlers for proper cleanup\n            if (this.arrEvents[eventName] == null) {\n                this.arrEvents[eventName] = [];\n            }\n            //create a custom object containing the handler method and the asynch flag\n            asynchVar = arguments.length > 2 ? arguments[2] : false;\n            handlerObj = {\n                method: handler,\n                asynch: asynchVar\n            };\n            this.arrEvents[eventName].push(handlerObj);\n        },\n\n        /**\n        * Removes a single handler from a specific event\n        * @param {String} eventName - The event name to clear the handler from\n        * @param {Function} handler - A reference to the handler function to un-register from the event\n        */\n        removeEventHandler: function (eventName, handler) {\n            eventName += this.eventPrefix;\n\n            if (this.arrEvents[eventName] != null) {\n                this.arrEvents[eventName] = this.arrEvents[eventName].reject(function (obj) {\n                    return obj.method == handler; //eslint-disable-line eqeqeq\n                });\n            }\n        },\n\n        /**\n        * Removes all handlers from a single event\n        * @param {String} eventName - The event name to clear handlers from\n        */\n        clearEventHandlers: function (eventName) {\n            eventName += this.eventPrefix;\n            this.arrEvents[eventName] = null;\n        },\n\n        /**\n        * Removes all handlers from ALL events\n        */\n        clearAllEventHandlers: function () {\n            this.arrEvents = {};\n        },\n\n        /**\n         * Collect and modify value of arg synchronously in succession and return its new value.\n         * In order to use, call attachEventHandler and add function handlers with eventName.\n         * Then call fireEventReducer with eventName and any argument to have its value accumulatively modified.\n         * Event handlers will be applied to argument in order of first attached to last attached.\n         * @param {String} eventName\n         * @param {*} arg\n         */\n        fireEventReducer: function (eventName, arg) {\n            var evtName = eventName + this.eventPrefix,\n                result = arg,\n                len,\n                i;\n\n            if (!this.arrEvents[evtName]) {\n                return result;\n            }\n\n            len = this.arrEvents[evtName].length; //optimization\n\n            for (i = 0; i < len; i++) {\n                /* eslint-disable max-depth */\n                try {\n                    result = this.arrEvents[evtName][i].method(result);\n                } catch (e) {\n                    if (this.id) {\n                        alert({\n                            content: 'error: error in ' + this.id + '.fireEventReducer():\\n\\nevent name: ' +\n                            eventName + '\\n\\nerror message: ' + e.message\n                        });\n                    } else {\n                        alert({\n                            content: 'error: error in [unknown object].fireEventReducer():\\n\\nevent name: ' +\n                            eventName + '\\n\\nerror message: ' + e.message\n                        });\n                    }\n                }\n                /* eslint-disable max-depth */\n            }\n\n            return result;\n        },\n\n        /**\n        * Fires the event {eventName}, resulting in all registered handlers to be executed.\n        * It also collects and returns results of all non-asynchronous handlers\n        * @param {String} eventName - The name of the event to fire\n        * @param {Object} [args] - Any object, will be passed into the handler function as the only argument\n        * @return {Array}\n        */\n        fireEvent: function (eventName) {\n            var evtName = eventName + this.eventPrefix,\n                results = [],\n                result, len, i, eventArgs, method, eventHandler;\n\n            if (this.arrEvents[evtName] != null) {\n                len = this.arrEvents[evtName].length; //optimization\n\n                for (i = 0; i < len; i++) {\n                    /* eslint-disable max-depth */\n                    try {\n                        if (arguments.length > 1) {\n                            if (this.arrEvents[evtName][i].asynch) {\n                                eventArgs = arguments[1];\n                                method = this.arrEvents[evtName][i].method.bind(this);\n                                setTimeout(function () { //eslint-disable-line no-loop-func\n                                    method(eventArgs);\n                                }, 10);\n                            } else {\n                                result = this.arrEvents[evtName][i].method(arguments[1]);\n                            }\n                        } else {\n                            if (this.arrEvents[evtName][i].asynch) { //eslint-disable-line no-lonely-if\n                                eventHandler = this.arrEvents[evtName][i].method;\n                                setTimeout(eventHandler, 1);\n                            } else if (\n                                this.arrEvents &&\n                                this.arrEvents[evtName] &&\n                                this.arrEvents[evtName][i] &&\n                                this.arrEvents[evtName][i].method\n                            ) {\n                                result = this.arrEvents[evtName][i].method();\n                            }\n                        }\n                        results.push(result);\n                    }\n                    catch (e) {\n                        if (this.id) {\n                            alert({\n                                content: 'error: error in ' + this.id + '.fireEvent():\\n\\nevent name: ' +\n                                eventName + '\\n\\nerror message: ' + e.message\n                            });\n                        } else {\n                            alert({\n                                content: 'error: error in [unknown object].fireEvent():\\n\\nevent name: ' +\n                                eventName + '\\n\\nerror message: ' + e.message\n                            });\n                        }\n                    }\n\n                    /* eslint-enable max-depth */\n                }\n            }\n\n            return results;\n        }\n    };\n\n    window.varienGlobalEvents = new varienEvents(); //jscs:ignore requireCapitalizedConstructors\n\n    return window.varienGlobalEvents;\n});\n","mage/adminhtml/backup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\n/* global  AdminBackup, setLocation */\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal',\n    'mage/mage',\n    'prototype'\n], function (jQuery) {\n    window.AdminBackup = new Class.create();\n\n    AdminBackup.prototype = {\n        /**\n         * Initialize.\n         */\n        initialize: function () {\n            this.reset();\n            this.rollbackUrl = this.backupUrl = '';\n        },\n\n        /**\n         * reset.\n         */\n        reset: function () {\n            this.time = 0;\n            this.type = '';\n        },\n\n        /**\n         * @param {*} type\n         * @return {Boolean}\n         */\n        backup: function (type) {\n            this.reset();\n            this.type = type;\n            this.requestBackupOptions();\n\n            return false;\n        },\n\n        /**\n         * @param {*} type\n         * @param {*} time\n         * @return {Boolean}\n         */\n        rollback: function (type, time) {\n            this.reset();\n            this.time = time;\n            this.type = type;\n            this.showRollbackWarning();\n\n            return false;\n        },\n\n        /**\n         * Show rollback warning.\n         */\n        showRollbackWarning: function () {\n            this.showPopup('rollback-warning');\n        },\n\n        /**\n         * request backup options.\n         */\n        requestBackupOptions: function () {\n            var action;\n\n            this.hidePopups();\n            action = this.type != 'snapshot' ? 'hide' : 'show'; //eslint-disable-line eqeqeq\n            this.showPopup('backup-options');\n\n            $$('#exclude-media-checkbox-container').invoke(action);\n        },\n\n        /**\n         * Request password.\n         */\n        requestPassword: function () {\n            this.hidePopups();\n\n            this.showPopup('rollback-request-password');\n\n            this.type != 'db' ? //eslint-disable-line eqeqeq\n                $('use-ftp-checkbox-row').show() :\n                $('use-ftp-checkbox-row').hide();\n        },\n\n        /**\n         * Toggle Ftp Credentials Form.\n         */\n        toggleFtpCredentialsForm: function () {\n            $('use_ftp').checked ? $('ftp-credentials-container').show()\n                : $('ftp-credentials-container').hide();\n\n            $$('#ftp-credentials-container input').each(function (item) {\n                if (item.name == 'ftp_path') { //eslint-disable-line eqeqeq\n                    return;\n                }\n                $('use_ftp').checked ? item.addClassName('required-entry') : item.removeClassName('required-entry');\n            });\n        },\n\n        /**\n         * Submit backup.\n         */\n        submitBackup: function () {\n            var data = {\n                'type': this.type,\n                'maintenance_mode': $('backup_maintenance_mode').checked ? 1 : 0,\n                'backup_name': $('backup_name').value,\n                'exclude_media': $('exclude_media').checked ? 1 : 0\n            };\n\n            new Ajax.Request(this.backupUrl, {\n                onSuccess: function (transport) {\n                    this.processResponse(transport, 'backup-options');\n                }.bind(this),\n                method: 'post',\n                parameters: data\n            });\n\n            this.modal.modal('closeModal');\n        },\n\n        /**\n         * Submit rollback.\n         */\n        submitRollback: function () {\n            var data = this.getPostData();\n\n            new Ajax.Request(this.rollbackUrl, {\n                onSuccess: function (transport) {\n                    this.processResponse(transport, 'rollback-request-password');\n                }.bind(this),\n                method: 'post',\n                parameters: data\n            });\n\n            this.modal.modal('closeModal');\n        },\n\n        /**\n         * @param {Object} transport\n         * @param {*} popupId\n         */\n        processResponse: function (transport, popupId) {\n            var json;\n\n            if (!transport.responseText.isJSON()) {\n                return;\n            }\n\n            json = transport.responseText.evalJSON();\n\n            if (json.error) {\n                this.showPopup(popupId);\n                this.displayError(popupId, json.error);\n\n                return;\n            }\n\n            if (json['redirect_url']) {\n                setLocation(json['redirect_url']);\n            }\n        },\n\n        /**\n         * @param {*} parentContainer\n         * @param {*} message\n         */\n        displayError: function (parentContainer, message) {\n            var messageHtml = this.getErrorMessageHtml(message);\n\n            $$('#' + parentContainer + ' .backup-messages .messages').invoke('update', messageHtml);\n            $$('#' + parentContainer + ' .backup-messages').invoke('show');\n        },\n\n        /**\n         * @param {*} message\n         * @return {String}\n         */\n        getErrorMessageHtml: function (message) {\n            return '<div class=\"message message-error error\"><div>' + message + '</div></div>';\n        },\n\n        /**\n         * @return {*|jQuery}\n         */\n        getPostData: function () {\n            var data = $('rollback-form').serialize(true);\n\n            data.time = this.time;\n            data.type = this.type;\n\n            return data;\n        },\n        backupConfig: {\n            'backup-options': {\n                title: jQuery.mage.__('Backup options'),\n\n                /**\n                 * @return {String}\n                 */\n                content: function () {\n                    return document.getElementById('backup-options-template').textContent;\n                },\n\n                /**\n                 * Action Ok.\n                 */\n                actionOk: function () {\n                    this.modal.find('#backup-form').validation({\n                        submitHandler: jQuery.proxy(this.submitBackup, this)\n                    });\n                    this.modal.find('#backup-form').submit();\n                }\n            },\n            'rollback-warning': {\n                title: jQuery.mage.__('Warning'),\n\n                /**\n                 * @return {String}\n                 */\n                content: function () {\n                    return document.getElementById('rollback-warning-template').textContent;\n                },\n\n                /**\n                 * Action Ok.\n                 */\n                actionOk: function () {\n                    this.modal.modal('closeModal');\n                    this.requestPassword();\n                }\n            },\n            'rollback-request-password': {\n                title: jQuery.mage.__('Backup options'),\n\n                /**\n                 * @return {String}\n                 */\n                content: function () {\n                    return document.getElementById('rollback-request-password-template').textContent;\n                },\n\n                /**\n                 * Action Ok.\n                 */\n                actionOk: function () {\n                    this.modal.find('#rollback-form').validation({\n                        submitHandler: jQuery.proxy(this.submitRollback, this)\n                    });\n                    this.modal.find('#rollback-form').submit();\n                },\n\n                /**\n                 * Opened.\n                 */\n                opened: function () {\n                    this.toggleFtpCredentialsForm();\n                }\n            }\n        },\n\n        /**\n         * @param {*} divId\n         */\n        showPopup: function (divId) {\n            var self = this;\n\n            this.modal = jQuery('<div/>').attr({\n                id: divId\n            }).html(this.backupConfig[divId].content()).modal({\n                modalClass: 'magento',\n                title: this.backupConfig[divId].title,\n                type: 'slide',\n\n                /**\n                 * @param {juery.Event} e\n                 * @param {Object} modal\n                 */\n                closed: function (e, modal) {\n                    modal.modal.remove();\n                },\n\n                /**\n                 * Opened.\n                 */\n                opened: function () {\n                    if (self.backupConfig[divId].opened) {\n                        self.backupConfig[divId].opened.call(self);\n                    }\n                },\n                buttons: [{\n                    text: jQuery.mage.__('Cancel'),\n                    'class': 'action cancel',\n\n                    /**\n                     * Click action.\n                     */\n                    click: function () {\n                        this.closeModal();\n                    }\n                }, {\n                    text: jQuery.mage.__('Ok'),\n                    'class': 'action primary',\n\n                    /**\n                     * Click action.\n                     */\n                    click: function () {\n                        self.backupConfig[divId].actionOk.call(self);\n                    }\n                }]\n            });\n            this.modal.modal('openModal');\n        },\n\n        /**\n         * Hide Popups.\n         */\n        hidePopups: function () {\n            var mask;\n\n            $$('.backup-dialog').each(Element.hide);\n            mask = $('popup-window-mask');\n\n            if (mask) {\n                mask.hide();\n            }\n        }\n    };\n});\n","mage/adminhtml/accordion.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global varienAccordion, varienLoader, Cookie */\n/* eslint-disable strict */\ndefine([\n    'prototype'\n], function () {\n    window.varienAccordion = new Class.create(); //eslint-disable-line\n    varienAccordion.prototype = {\n        /**\n         * @param {*} containerId\n         * @param {*} activeOnlyOne\n         */\n        initialize: function (containerId, activeOnlyOne) {\n            var links, i;\n\n            this.containerId = containerId;\n            this.activeOnlyOne = activeOnlyOne || false;\n            this.container = $(this.containerId);\n            this.items = $$('#' + this.containerId + ' dt');\n            this.loader = new varienLoader(true); //jscs:ignore requireCapitalizedConstructors\n\n            links = $$('#' + this.containerId + ' dt a');\n\n            for (i in links) {\n                if (links[i].href) {\n                    Event.observe(links[i], 'click', this.clickItem.bind(this));\n                    this.items[i].dd = this.items[i].next('dd');\n                    this.items[i].link = links[i];\n                }\n            }\n\n            this.initFromCookie();\n        },\n\n        /**\n         * Init from cookie.\n         */\n        initFromCookie: function () {\n            var activeItemId, visibility;\n\n            if (this.activeOnlyOne &&\n                (activeItemId = Cookie.read(this.cookiePrefix() + 'active-item')) !== null) {\n                this.hideAllItems();\n                this.showItem(this.getItemById(activeItemId));\n            } else if (!this.activeOnlyOne) {\n                this.items.each(function (item) {\n                    if ((visibility = Cookie.read(this.cookiePrefix() + item.id)) !== null) {\n                        if (visibility == 0) { //eslint-disable-line eqeqeq\n                            this.hideItem(item);\n                        } else {\n                            this.showItem(item);\n                        }\n                    }\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @return {String}\n         */\n        cookiePrefix: function () {\n            return 'accordion-' + this.containerId + '-';\n        },\n\n        /**\n         * @param {*} itemId\n         * @return {*}\n         */\n        getItemById: function (itemId) {\n            var result = null;\n\n            this.items.each(function (item) {\n                if (item.id == itemId) { //eslint-disable-line\n                    result = item;\n                    throw $break;\n                }\n            });\n\n            return result;\n        },\n\n        /**\n         * @param {*} event\n         */\n        clickItem: function (event) {\n            var item = Event.findElement(event, 'dt');\n\n            if (this.activeOnlyOne) {\n                this.hideAllItems();\n                this.showItem(item);\n                Cookie.write(this.cookiePrefix() + 'active-item', item.id, 30 * 24 * 60 * 60);\n            } else {\n                if (this.isItemVisible(item)) { //eslint-disable-line no-lonely-if\n                    this.hideItem(item);\n                    Cookie.write(this.cookiePrefix() + item.id, 0, 30 * 24 * 60 * 60);\n                } else {\n                    this.showItem(item);\n                    Cookie.write(this.cookiePrefix() + item.id, 1, 30 * 24 * 60 * 60);\n                }\n            }\n            Event.stop(event);\n        },\n\n        /**\n         * @param {Object} item\n         */\n        showItem: function (item) {\n            if (item && item.link) {\n                if (item.link.href) {\n                    this.loadContent(item);\n                }\n\n                Element.addClassName(item, 'open');\n                Element.addClassName(item.dd, 'open');\n            }\n        },\n\n        /**\n         * @param {Object} item\n         */\n        hideItem: function (item) {\n            Element.removeClassName(item, 'open');\n            Element.removeClassName(item.dd, 'open');\n        },\n\n        /**\n         * @param {*} item\n         * @return {*}\n         */\n        isItemVisible: function (item) {\n            return Element.hasClassName(item, 'open');\n        },\n\n        /**\n         * @param {*} item\n         */\n        loadContent: function (item) {\n            if (item.link.href.indexOf('#') == item.link.href.length - 1) { //eslint-disable-line eqeqeq\n                return;\n            }\n\n            if (Element.hasClassName(item.link, 'ajax')) {\n                this.loadingItem = item;\n                this.loader.load(item.link.href, {\n                    updaterId: this.loadingItem.dd.id\n                }, this.setItemContent.bind(this));\n\n                return;\n            }\n            location.href = item.link.href;\n        },\n\n        /**\n         * @param {Object} content\n         */\n        setItemContent: function (content) {\n            if (content.isJSON) {\n                return;\n            }\n            this.loadingItem.dd.innerHTML = content;\n        },\n\n        /**\n         * Hide all items\n         */\n        hideAllItems: function () {\n            var i;\n\n            for (i in this.items) {\n                if (this.items[i].id) {\n                    Element.removeClassName(this.items[i], 'open');\n                    Element.removeClassName(this.items[i].dd, 'open');\n                }\n            }\n        }\n    };\n});\n","mage/adminhtml/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global varienGlobalEvents, varienWindowOnloadCache, RegionUpdater, FormElementDependenceController */\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'prototype',\n    'mage/adminhtml/events'\n], function (jQuery) {\n    var varienElementMethods;\n\n    /*\n     * @TODO Need to be removed after refactoring all dependent of the form the components\n     */\n    (function ($) {\n        $(document).ready(function () {\n            $(document).on('beforeSubmit', function (e) { //eslint-disable-line max-nested-callbacks\n                if (typeof varienGlobalEvents !== 'undefined') {\n                    varienGlobalEvents.fireEvent('formSubmit', $(e.target).attr('id'));\n                }\n            });\n        });\n    })(jQuery);\n\n    /**\n     *  Additional elements methods\n     */\n    varienElementMethods = {\n        /**\n         * @param {HTMLElement} element\n         */\n        setHasChanges: function (element) {\n            var elm;\n\n            if ($(element) && $(element).hasClassName('no-changes')) {\n                return;\n            }\n            elm = element;\n\n            while (elm && elm.tagName != 'BODY') { //eslint-disable-line eqeqeq\n                if (elm.statusBar) {\n                    Element.addClassName($(elm.statusBar), 'changed');\n                }\n                elm = elm.parentNode;\n            }\n        },\n\n        /**\n         * @param {HTMLElement} element\n         * @param {*} flag\n         * @param {Object} form\n         */\n        setHasError: function (element, flag, form) {\n            var elm = element;\n\n            while (elm && elm.tagName != 'BODY') { //eslint-disable-line eqeqeq\n                if (elm.statusBar) {\n                    /* eslint-disable max-depth */\n                    if (form.errorSections.keys().indexOf(elm.statusBar.id) < 0) {\n                        form.errorSections.set(elm.statusBar.id, flag);\n                    }\n\n                    if (flag) {\n                        Element.addClassName($(elm.statusBar), 'error');\n\n                        if (form.canShowError && $(elm.statusBar).show) {\n                            form.canShowError = false;\n                            $(elm.statusBar).show();\n                        }\n                        form.errorSections.set(elm.statusBar.id, flag);\n                    } else if (!form.errorSections.get(elm.statusBar.id)) {\n                        Element.removeClassName($(elm.statusBar), 'error');\n                    }\n\n                    /* eslint-enable max-depth */\n                }\n                elm = elm.parentNode;\n            }\n            this.canShowElement = false;\n        }\n    };\n\n    Element.addMethods(varienElementMethods);\n\n    // Global bind changes\n    window.varienWindowOnloadCache = {};\n\n    /**\n     * @param {*} useCache\n     */\n    function varienWindowOnload(useCache) {\n        var dataElements = $$('input', 'select', 'textarea'),\n            i;\n\n        for (i = 0; i < dataElements.length; i++) {\n            if (dataElements[i] && dataElements[i].id) {\n\n                /* eslint-disable max-depth */\n                if (!useCache || !varienWindowOnloadCache[dataElements[i].id]) {\n                    Event.observe(dataElements[i], 'change', dataElements[i].setHasChanges.bind(dataElements[i]));\n\n                    if (useCache) {\n                        varienWindowOnloadCache[dataElements[i].id] = true;\n                    }\n                }\n\n                /* eslint-disable max-depth */\n            }\n        }\n    }\n    Event.observe(window, 'load', varienWindowOnload);\n\n    window.RegionUpdater = Class.create();\n    RegionUpdater.prototype = {\n        /**\n         * @param {HTMLElement} countryEl\n         * @param {HTMLElement} regionTextEl\n         * @param {HTMLElement}regionSelectEl\n         * @param {Object} regions\n         * @param {*} disableAction\n         * @param {*} clearRegionValueOnDisable\n         */\n        initialize: function (\n            countryEl, regionTextEl, regionSelectEl, regions, disableAction, clearRegionValueOnDisable\n        ) {\n            this.isRegionRequired = true;\n            this.countryEl = $(countryEl);\n            this.regionTextEl = $(regionTextEl);\n            this.regionSelectEl = $(regionSelectEl);\n            this.config = regions.config;\n            delete regions.config;\n            this.regions = regions;\n            this.disableAction = typeof disableAction === 'undefined' ? 'hide' : disableAction;\n            this.clearRegionValueOnDisable = typeof clearRegionValueOnDisable === 'undefined' ?\n                false : clearRegionValueOnDisable;\n\n            if (this.regionSelectEl.options.length <= 1) {\n                this.update();\n            } else {\n                this.lastCountryId = this.countryEl.value;\n            }\n\n            this.countryEl.changeUpdater = this.update.bind(this);\n\n            Event.observe(this.countryEl, 'change', this.update.bind(this));\n        },\n\n        /**\n         * @private\n         */\n        _checkRegionRequired: function () {\n            var label, wildCard, elements, that, regionRequired;\n\n            if (!this.isRegionRequired) {\n                return;\n            }\n\n            elements = [this.regionTextEl, this.regionSelectEl];\n            that = this;\n\n            if (typeof this.config == 'undefined') {\n                return;\n            }\n            regionRequired = this.config['regions_required'].indexOf(this.countryEl.value) >= 0;\n\n            elements.each(function (currentElement) {\n                var form, validationInstance, field, topElement;\n\n                if (!currentElement) {\n                    return;\n                }\n                form = currentElement.form;\n                validationInstance = form ? jQuery(form).data('validation') : null;\n                field = currentElement.up('.field') || new Element('div');\n\n                if (validationInstance) {\n                    validationInstance.clearError(currentElement);\n                }\n                label = $$('label[for=\"' + currentElement.id + '\"]')[0];\n\n                if (label) {\n                    wildCard = label.down('em') || label.down('span.required');\n                    topElement = label.up('tr') || label.up('li');\n\n                    if (!that.config['show_all_regions'] && topElement) {\n                        if (regionRequired) {\n                            topElement.show();\n                        } else {\n                            topElement.hide();\n                        }\n                    }\n                }\n\n                if (label && wildCard) {\n                    if (!regionRequired) {\n                        wildCard.hide();\n                    } else {\n                        wildCard.show();\n                    }\n                }\n\n                //compute the need for the required fields\n                if (!regionRequired || !currentElement.visible()) {\n                    if (field.hasClassName('required')) {\n                        field.removeClassName('required');\n                    }\n\n                    if (currentElement.hasClassName('required-entry')) {\n                        currentElement.removeClassName('required-entry');\n                    }\n\n                    if (currentElement.tagName.toLowerCase() == 'select' && //eslint-disable-line eqeqeq\n                        currentElement.hasClassName('validate-select')\n                    ) {\n                        currentElement.removeClassName('validate-select');\n                    }\n                } else {\n                    if (!field.hasClassName('required')) {\n                        field.addClassName('required');\n                    }\n\n                    if (!currentElement.hasClassName('required-entry')) {\n                        currentElement.addClassName('required-entry');\n                    }\n\n                    if (currentElement.tagName.toLowerCase() == 'select' && //eslint-disable-line eqeqeq\n                        !currentElement.hasClassName('validate-select')\n                    ) {\n                        currentElement.addClassName('validate-select');\n                    }\n                }\n            });\n        },\n\n        /**\n         * Disable region validation.\n         */\n        disableRegionValidation: function () {\n            this.isRegionRequired = false;\n        },\n\n        /**\n         * Update.\n         */\n        update: function () {\n            var option, region, def, regionId;\n\n            if (this.regions[this.countryEl.value]) {\n                if (this.lastCountryId != this.countryEl.value) { //eslint-disable-line eqeqeq\n                    def = this.regionSelectEl.getAttribute('defaultValue');\n\n                    if (this.regionTextEl) {\n                        if (!def) {\n                            def = this.regionTextEl.value.toLowerCase();\n                        }\n                        this.regionTextEl.value = '';\n                    }\n\n                    this.regionSelectEl.options.length = 1;\n\n                    for (regionId in this.regions[this.countryEl.value]) { //eslint-disable-line guard-for-in\n                        region = this.regions[this.countryEl.value][regionId];\n\n                        option = document.createElement('OPTION');\n                        option.value = regionId;\n                        option.text = region.name.stripTags();\n                        option.title = region.name;\n\n                        if (this.regionSelectEl.options.add) {\n                            this.regionSelectEl.options.add(option);\n                        } else {\n                            this.regionSelectEl.appendChild(option);\n                        }\n\n                        if (regionId == def || region.name.toLowerCase() == def || region.code.toLowerCase() == def) { //eslint-disable-line\n                            this.regionSelectEl.value = regionId;\n                        }\n                    }\n                }\n\n                if (this.disableAction == 'hide') { //eslint-disable-line eqeqeq\n                    if (this.regionTextEl) {\n                        this.regionTextEl.style.display = 'none';\n                        this.regionTextEl.style.disabled = true;\n                    }\n                    this.regionSelectEl.style.display = '';\n                    this.regionSelectEl.disabled = false;\n                } else if (this.disableAction == 'disable') { //eslint-disable-line eqeqeq\n                    if (this.regionTextEl) {\n                        this.regionTextEl.disabled = true;\n                    }\n                    this.regionSelectEl.disabled = false;\n                }\n                this.setMarkDisplay(this.regionSelectEl, true);\n\n                this.lastCountryId = this.countryEl.value;\n            } else {\n                if (this.disableAction == 'hide') { //eslint-disable-line eqeqeq\n                    if (this.regionTextEl) {\n                        this.regionTextEl.style.display = '';\n                        this.regionTextEl.style.disabled = false;\n                    }\n                    this.regionSelectEl.style.display = 'none';\n                    this.regionSelectEl.disabled = true;\n                } else if (this.disableAction == 'disable') { //eslint-disable-line eqeqeq\n                    if (this.regionTextEl) {\n                        this.regionTextEl.disabled = false;\n                    }\n                    this.regionSelectEl.disabled = true;\n\n                    if (this.clearRegionValueOnDisable) {\n                        this.regionSelectEl.value = '';\n                    }\n                } else if (this.disableAction == 'nullify') { //eslint-disable-line eqeqeq\n                    this.regionSelectEl.options.length = 1;\n                    this.regionSelectEl.value = '';\n                    this.regionSelectEl.selectedIndex = 0;\n                    this.lastCountryId = '';\n                }\n                this.setMarkDisplay(this.regionSelectEl, false);\n            }\n            varienGlobalEvents.fireEvent('address_country_changed', this.countryEl);\n            this._checkRegionRequired();\n        },\n\n        /**\n         * @param {HTMLElement} elem\n         * @param {*} display\n         */\n        setMarkDisplay: function (elem, display) {\n            var marks;\n\n            if (elem.parentNode.parentNode) {\n                marks = Element.select(elem.parentNode.parentNode, '.required');\n\n                if (marks[0]) {\n                    display ? marks[0].show() : marks[0].hide();\n                }\n            }\n        }\n    };\n\n    window.regionUpdater = RegionUpdater;\n\n    /**\n     * Fix errorrs in IE\n     */\n    Event.pointerX = function (event) {\n        try {\n            return event.pageX || (event.clientX + (document.documentElement.scrollLeft || document.body.scrollLeft)); //eslint-disable-line\n        }\n        catch (e) {}\n    };\n\n    /**\n     * @param {jQuery.Event} event\n     * @return {*}\n     */\n    Event.pointerY = function (event) {\n        try {\n            return event.pageY || (event.clientY + (document.documentElement.scrollTop || document.body.scrollTop)); //eslint-disable-line\n        }\n        catch (e) {}\n    };\n\n    /**\n     * Observer that watches for dependent form elements\n     * If an element depends on 1 or more of other elements,\n     * it should show up only when all of them gain specified values\n     */\n    window.FormElementDependenceController = Class.create();\n    FormElementDependenceController.prototype = {\n        /**\n         * Structure of elements: {\n         *     'id_of_dependent_element' : {\n         *         'id_of_master_element_1' : 'reference_value',\n         *         'id_of_master_element_2' : 'reference_value'\n         *         'id_of_master_element_3' : ['reference_value1', 'reference_value2']\n         *         ...\n         *     }\n         * }\n         * @param {Object} elementsMap\n         * @param {Object} config\n         */\n        initialize: function (elementsMap, config) {\n            var idTo, idFrom, values, fromId, radioFrom;\n\n            if (config) {\n                this._config = jQuery.extend(this._config, config);\n            }\n\n            for (idTo in elementsMap) { //eslint-disable-line guard-for-in\n                for (idFrom in elementsMap[idTo]) { //eslint-disable-line guard-for-in\n                    if ($(idFrom)) {\n                        Event.observe(\n                            $(idFrom),\n                            'change',\n                            this.trackChange.bindAsEventListener(this, idTo, elementsMap[idTo])\n                        );\n                    } else {\n                        // Check if radio button\n                        values = elementsMap[idTo][idFrom].values;\n                        fromId = $(idFrom + values[0]);\n                        radioFrom = fromId ? $$('[name=\"' + fromId.name + '\"]') : false;\n\n                        if (radioFrom) {\n                            radioFrom.invoke(\n                                'on',\n                                'change',\n                                this.trackChange.bindAsEventListener(this, idTo, elementsMap[idTo])\n                            );\n                        }\n                    }\n                    this.trackChange(null, idTo, elementsMap[idTo]);\n                }\n            }\n        },\n\n        /**\n         * Misc. config options\n         * Keys are underscored intentionally\n         */\n        _config: {\n            'levels_up': 1 // how many levels up to travel when toggling element\n        },\n\n        /**\n         * Define whether target element should be toggled and show/hide its row\n         *\n         * @param {Object} e - event\n         * @param {String} idTo - id of target element\n         * @param {Object} valuesFrom - ids of master elements and reference values\n         * @return\n         */\n        trackChange: function (e, idTo, valuesFrom) {\n            // define whether the target should show up\n            var shouldShowUp = true,\n                idFrom, from, values, isInArray, isNegative, headElement, isInheritCheckboxChecked, target, inputs,\n                isAnInputOrSelect, currentConfig, rowElement, fromId, radioFrom;\n\n            for (idFrom in valuesFrom) { //eslint-disable-line guard-for-in\n                from = $(idFrom);\n\n                if (from) {\n                    values = valuesFrom[idFrom].values;\n                    isInArray = values.indexOf(from.value) != -1; //eslint-disable-line\n                    isNegative = valuesFrom[idFrom].negative;\n\n                    if (!from || isInArray && isNegative || !isInArray && !isNegative) {\n                        shouldShowUp = false;\n                    }\n                // Check if radio button\n                } else {\n                    values = valuesFrom[idFrom].values;\n                    fromId = $(idFrom + values[0]);\n\n                    if (fromId) {\n                        radioFrom = $$('[name=\"' + fromId.name + '\"]:checked');\n                        isInArray = radioFrom.length > 0 && values.indexOf(radioFrom[0].value) !== -1;\n                        isNegative = valuesFrom[idFrom].negative;\n\n                        if (!radioFrom || isInArray && isNegative || !isInArray && !isNegative) {\n                            shouldShowUp = false;\n                        }\n                    }\n                }\n            }\n\n            // toggle target row\n            headElement = $(idTo + '-head');\n            isInheritCheckboxChecked = $(idTo + '_inherit') && $(idTo + '_inherit').checked;\n            target = $(idTo);\n\n            // Target won't always exist (for example, if field type is \"label\")\n            if (target) {\n                inputs = target.up(this._config['levels_up']).select('input', 'select', 'td');\n                isAnInputOrSelect = ['input', 'select'].indexOf(target.tagName.toLowerCase()) != -1; //eslint-disable-line\n\n                if (target.type === 'fieldset') {\n                    inputs = target.select('input', 'select', 'td');\n                }\n            } else {\n                inputs = false;\n                isAnInputOrSelect = false;\n            }\n\n            if (shouldShowUp) {\n                currentConfig = this._config;\n\n                if (inputs) {\n                    inputs.each(function (item) {\n                        // don't touch hidden inputs (and Use Default inputs too), bc they may have custom logic\n                        if ((!item.type || item.type != 'hidden') && !($(item.id + '_inherit') && $(item.id + '_inherit').checked) && //eslint-disable-line\n                            !(currentConfig['can_edit_price'] != undefined && !currentConfig['can_edit_price']) //eslint-disable-line\n                        ) {\n                            item.disabled = false;\n                            jQuery(item).removeClass('ignore-validate');\n                        }\n                    });\n                }\n\n                if (headElement) {\n                    headElement.show();\n\n                    if (headElement.hasClassName('open') && target) {\n                        target.show();\n                    } else if (target) {\n                        target.hide();\n                    }\n                } else {\n                    if (target) {\n                        target.show();\n                    }\n\n                    if (isAnInputOrSelect && !isInheritCheckboxChecked) {\n                        if (target) {\n                            if (target.getAttribute('readonly')) {\n                                target.disabled = true;\n                            } else {\n                                target.disabled = false;\n                            }\n                        }\n\n                        jQuery('#' + idTo).removeClass('ignore-validate');\n                    }\n                }\n            } else {\n                if (inputs) {\n                    inputs.each(function (item) {\n                        // don't touch hidden inputs (and Use Default inputs too), bc they may have custom logic\n                        if ((!item.type || item.type != 'hidden') && //eslint-disable-line eqeqeq\n                            !($(item.id + '_inherit') && $(item.id + '_inherit').checked)\n                        ) {\n                            item.disabled = true;\n                            jQuery(item).addClass('ignore-validate');\n                        }\n                    });\n                }\n\n                if (headElement) {\n                    headElement.hide();\n                }\n\n                if (target) {\n                    target.hide();\n                }\n\n                if (isAnInputOrSelect && !isInheritCheckboxChecked) {\n                    if (target) {\n                        target.disabled = true;\n                    }\n                    jQuery('#' + idTo).addClass('ignore-validate');\n                }\n\n            }\n            rowElement = $('row_' + idTo);\n\n            if (rowElement == undefined && target) { //eslint-disable-line eqeqeq\n                rowElement = target.up(this._config['levels_up']);\n\n                if (target.type === 'fieldset') {\n                    rowElement = target;\n                }\n            }\n\n            if (rowElement) {\n                if (shouldShowUp) {\n                    rowElement.show();\n                } else {\n                    rowElement.hide();\n                }\n            }\n        }\n    };\n\n    window.varienWindowOnload = varienWindowOnload;\n    window.varienElementMethods = varienElementMethods;\n});\n","mage/adminhtml/wysiwyg/events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        afterInitialization: 'afterInitialization',\n        afterChangeContent: 'afterChangeContent',\n        afterUndo: 'afterUndo',\n        afterPaste: 'afterPaste',\n        beforeSetContent: 'beforeSetContent',\n        afterSetContent: 'afterSetContent',\n        afterSave: 'afterSave',\n        afterOpenFileBrowser: 'afterOpenFileBrowser',\n        afterFormSubmit: 'afterFormSubmit',\n        afterBlur: 'afterBlur',\n        afterFocus: 'afterFocus'\n    };\n});\n","mage/adminhtml/wysiwyg/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global setLocation, Base64, updateElementAtCursor, varienGlobalEvents */\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'wysiwygAdapter',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'mage/translate',\n    'mage/mage',\n    'mage/validation',\n    'mage/adminhtml/events',\n    'prototype',\n    'Magento_Ui/js/modal/modal'\n], function (jQuery, wysiwyg, alert) {\n    var widgetTools = {\n\n        /**\n         * Sets the widget to be active and is the scope of the slide out if the value is set\n         */\n        activeSelectedNode: null,\n        editMode: false,\n        cursorLocation: 0,\n\n        /**\n         * Set active selected node.\n         *\n         * @param {Object} activeSelectedNode\n         */\n        setActiveSelectedNode: function (activeSelectedNode) {\n            this.activeSelectedNode = activeSelectedNode;\n        },\n\n        /**\n         * Get active selected node.\n         *\n         * @returns {null}\n         */\n        getActiveSelectedNode: function () {\n            return this.activeSelectedNode;\n        },\n\n        /**\n         *\n         * @param {Boolean} editMode\n         */\n        setEditMode: function (editMode) {\n            this.editMode = editMode;\n        },\n\n        /**\n         * @param {*} id\n         * @param {*} html\n         * @return {String}\n         */\n        getDivHtml: function (id, html) {\n\n            if (!html) {\n                html = '';\n            }\n\n            return '<div id=\"' + id + '\">' + html + '</div>';\n        },\n\n        /**\n         * @param {Object} transport\n         */\n        onAjaxSuccess: function (transport) {\n            var response;\n\n            if (transport.responseText.isJSON()) {\n                response = transport.responseText.evalJSON();\n\n                if (response.error) {\n                    throw response;\n                } else if (response.ajaxExpired && response.ajaxRedirect) {\n                    setLocation(response.ajaxRedirect);\n                }\n            }\n        },\n\n        dialogOpened: false,\n\n        /**\n         * @return {Number}\n         */\n        getMaxZIndex: function () {\n            var max = 0,\n                cn = document.body.childNodes,\n                i, el, zIndex;\n\n            for (i = 0; i < cn.length; i++) {\n                el = cn[i];\n                zIndex = el.nodeType == 1 ? parseInt(el.style.zIndex, 10) || 0 : 0; //eslint-disable-line eqeqeq\n\n                if (zIndex < 10000) {\n                    max = Math.max(max, zIndex);\n                }\n            }\n\n            return max + 10;\n        },\n\n        /**\n         * @param {String} widgetUrl\n         */\n        openDialog: function (widgetUrl) {\n            var oThis = this,\n                title = 'Insert Widget',\n                mode = 'new',\n                dialog;\n\n            if (this.editMode) {\n                title = 'Edit Widget';\n                mode = 'edit';\n            }\n\n            if (this.dialogOpened) {\n                return;\n            }\n\n            this.dialogWindow = jQuery('<div/>').modal({\n\n                title: jQuery.mage.__(title),\n                type: 'slide',\n                buttons: [],\n\n                /**\n                 * Opened.\n                 */\n                opened: function () {\n                    dialog = jQuery(this).addClass('loading magento-message');\n\n                    widgetUrl += 'mode/' + mode;\n\n                    new Ajax.Updater($(this), widgetUrl, {\n                        evalScripts: true,\n\n                        /**\n                         * On complete.\n                         */\n                        onComplete: function () {\n                            dialog.removeClass('loading');\n                        }\n                    });\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} modal\n                 */\n                closed: function (e, modal) {\n                    modal.modal.remove();\n                    oThis.dialogOpened = false;\n                }\n            });\n\n            this.dialogOpened = true;\n            this.dialogWindow.modal('openModal');\n        }\n    },\n    WysiwygWidget = {};\n\n    WysiwygWidget.Widget = Class.create();\n    WysiwygWidget.Widget.prototype = {\n        /**\n         * @param {HTMLElement} formEl\n         * @param {HTMLElement} widgetEl\n         * @param {*} widgetOptionsEl\n         * @param {*} optionsSourceUrl\n         * @param {*} widgetTargetId\n         */\n        initialize: function (formEl, widgetEl, widgetOptionsEl, optionsSourceUrl, widgetTargetId) {\n            $(formEl).insert({\n                bottom: widgetTools.getDivHtml(widgetOptionsEl)\n            });\n\n            this.formEl = formEl;\n            this.widgetEl = $(widgetEl);\n            this.widgetOptionsEl = $(widgetOptionsEl);\n            this.optionsUrl = optionsSourceUrl;\n            this.optionValues = new Hash({});\n            this.widgetTargetId = widgetTargetId;\n\n            if (typeof wysiwyg != 'undefined' && wysiwyg.activeEditor()) { //eslint-disable-line eqeqeq\n                this.bMark = wysiwyg.activeEditor().selection.getBookmark();\n            }\n\n            // disable -- Please Select -- option from being re-selected\n            this.widgetEl.querySelector('option').setAttribute('disabled', 'disabled');\n\n            Event.observe(this.widgetEl, 'change', this.loadOptions.bind(this));\n\n            this.initOptionValues();\n        },\n\n        /**\n         * @return {String}\n         */\n        getOptionsContainerId: function () {\n            return this.widgetOptionsEl.id + '_' + this.widgetEl.value.gsub(/\\//, '_');\n        },\n\n        /**\n         * @param {*} containerId\n         */\n        switchOptionsContainer: function (containerId) {\n            $$('#' + this.widgetOptionsEl.id + ' div[id^=' + this.widgetOptionsEl.id + ']').each(function (e) {\n                this.disableOptionsContainer(e.id);\n            }.bind(this));\n\n            if (containerId != undefined) { //eslint-disable-line eqeqeq\n                this.enableOptionsContainer(containerId);\n            }\n            this._showWidgetDescription();\n        },\n\n        /**\n         * @param {*} containerId\n         */\n        enableOptionsContainer: function (containerId) {\n            $$('#' + containerId + ' .widget-option').each(function (e) {\n                e.removeClassName('skip-submit');\n\n                if (e.hasClassName('obligatory')) {\n                    e.removeClassName('obligatory');\n                    e.addClassName('required-entry');\n                }\n            });\n            $(containerId).removeClassName('no-display');\n        },\n\n        /**\n         * @param {*} containerId\n         */\n        disableOptionsContainer: function (containerId) {\n\n            if ($(containerId).hasClassName('no-display')) {\n                return;\n            }\n            $$('#' + containerId + ' .widget-option').each(function (e) {\n                // Avoid submitting fields of unactive container\n                if (!e.hasClassName('skip-submit')) {\n                    e.addClassName('skip-submit');\n                }\n                // Form validation workaround for unactive container\n                if (e.hasClassName('required-entry')) {\n                    e.removeClassName('required-entry');\n                    e.addClassName('obligatory');\n                }\n            });\n            $(containerId).addClassName('no-display');\n        },\n\n        /**\n         * Assign widget options values when existing widget selected in WYSIWYG.\n         *\n         * @return {Boolean}\n         */\n        initOptionValues: function () {\n            var e, widgetCode;\n\n            if (!this.wysiwygExists()) {\n                return false;\n            }\n\n            e = this.getWysiwygNode();\n\n            if (e.localName === 'span') {\n                e = e.firstElementChild;\n            }\n\n            if (e != undefined && e.id) { //eslint-disable-line eqeqeq\n                // attempt to Base64-decode id on selected node; exception is thrown if it is in fact not a widget node\n                try {\n                    widgetCode = Base64.idDecode(e.id);\n                } catch (ex) {\n                    return false;\n                }\n\n                if (widgetCode.indexOf('{{widget') !== -1) {\n                    this.optionValues = new Hash({});\n                    widgetCode.gsub(/([a-z0-9\\_]+)\\s*\\=\\s*[\\\"]{1}([^\\\"]+)[\\\"]{1}/i, function (match) {\n\n                        if (match[1] == 'type') { //eslint-disable-line eqeqeq\n                            this.widgetEl.value = match[2];\n                        } else {\n                            this.optionValues.set(match[1], match[2]);\n                        }\n\n                    }.bind(this));\n\n                    this.loadOptions();\n                }\n            }\n        },\n\n        /**\n         * Load options.\n         */\n        loadOptions: function () {\n            var optionsContainerId,\n                params,\n                msg,\n                msgTmpl,\n                $wrapper,\n                typeName = this.optionValues.get('type_name');\n\n            if (!this.widgetEl.value) {\n                if (typeName) {\n                    msgTmpl = jQuery.mage.__('The widget %1 is no longer available. Select a different widget.');\n                    msg = jQuery.mage.__(msgTmpl).replace('%1', typeName);\n\n                    jQuery('body').notification('clear').notification('add', {\n                        error: true,\n                        message: msg,\n\n                        /**\n                         * @param {String} message\n                         */\n                        insertMethod: function (message) {\n                            $wrapper = jQuery('<div/>').html(message);\n\n                            $wrapper.insertAfter('.modal-slide .page-main-actions');\n                        }\n                    });\n                }\n                this.switchOptionsContainer();\n\n                return;\n            }\n\n            optionsContainerId = this.getOptionsContainerId();\n\n            if ($(optionsContainerId) != undefined) { //eslint-disable-line eqeqeq\n                this.switchOptionsContainer(optionsContainerId);\n\n                return;\n            }\n\n            this._showWidgetDescription();\n\n            params = {\n                'widget_type': this.widgetEl.value,\n                values: this.optionValues\n            };\n            new Ajax.Request(this.optionsUrl, {\n                parameters: {\n                    widget: Object.toJSON(params)\n                },\n\n                /**\n                 * On success.\n                 */\n                onSuccess: function (transport) {\n                    try {\n                        widgetTools.onAjaxSuccess(transport);\n                        this.switchOptionsContainer();\n\n                        if ($(optionsContainerId) == undefined) { //eslint-disable-line eqeqeq\n                            this.widgetOptionsEl.insert({\n                                bottom: widgetTools.getDivHtml(optionsContainerId, transport.responseText)\n                            });\n                        } else {\n                            this.switchOptionsContainer(optionsContainerId);\n                        }\n                    } catch (e) {\n                        alert({\n                            content: e.message\n                        });\n                    }\n                }.bind(this)\n            });\n        },\n\n        /**\n         * @private\n         */\n        _showWidgetDescription: function () {\n            var noteCnt = this.widgetEl.next().down('small'),\n                descrCnt = $('widget-description-' + this.widgetEl.selectedIndex),\n                description;\n\n            if (noteCnt != undefined) { //eslint-disable-line eqeqeq\n                description = descrCnt != undefined ? descrCnt.innerHTML : ''; //eslint-disable-line eqeqeq\n                noteCnt.update(description);\n            }\n        },\n\n        /**\n         * Validate field.\n         */\n        validateField: function () {\n            jQuery(this.widgetEl).valid();\n            jQuery('#insert_button').removeClass('disabled');\n        },\n\n        /**\n         * Closes the modal\n         */\n        closeModal: function () {\n            widgetTools.dialogWindow.modal('closeModal');\n        },\n\n        /* eslint-disable max-depth*/\n        /**\n         * Insert widget.\n         */\n        insertWidget: function () {\n            var validationResult,\n                $form = jQuery('#' + this.formEl),\n                formElements,\n                i,\n                params,\n                editor,\n                activeNode;\n\n            // remove cached validator instance, which caches elements to validate\n            jQuery.data($form[0], 'validator', null);\n\n            $form.validate({\n                /**\n                 * Ignores elements with .skip-submit, .no-display ancestor elements\n                 */\n                ignore: function () {\n                    return jQuery(this).closest('.skip-submit, .no-display').length;\n                },\n                errorClass: 'mage-error'\n            });\n\n            validationResult = $form.valid();\n\n            if (validationResult) {\n                formElements = [];\n                i = 0;\n                Form.getElements($(this.formEl)).each(function (e) {\n\n                    if (!e.hasClassName('skip-submit')) {\n                        formElements[i] = e;\n                        i++;\n                    }\n                });\n\n                // Add as_is flag to parameters if wysiwyg editor doesn't exist\n                params = Form.serializeElements(formElements);\n\n                if (!this.wysiwygExists()) {\n                    params += '&as_is=1';\n                }\n\n                new Ajax.Request($(this.formEl).action, {\n                    parameters: params,\n                    onComplete: function (transport) {\n                        try {\n                            editor = wysiwyg.get(this.widgetTargetId);\n\n                            widgetTools.onAjaxSuccess(transport);\n                            widgetTools.dialogWindow.modal('closeModal');\n\n                            if (editor) {\n                                editor.focus();\n                                activeNode = widgetTools.getActiveSelectedNode();\n\n                                if (activeNode) {\n                                    editor.selection.select(activeNode);\n                                    editor.selection.setContent(transport.responseText);\n                                    editor.fire('Change');\n                                } else if (this.bMark) {\n                                    editor.selection.moveToBookmark(this.bMark);\n                                }\n                            }\n\n                            if (!activeNode) {\n                                this.updateContent(transport.responseText);\n                            }\n                        } catch (e) {\n                            alert({\n                                content: e.message\n                            });\n                        }\n                    }.bind(this)\n                });\n            }\n        },\n\n        /**\n         * @param {Object} content\n         */\n        updateContent: function (content) {\n            var textarea;\n\n            if (this.wysiwygExists()) {\n                wysiwyg.insertContent(content, false);\n            } else {\n                textarea = document.getElementById(this.widgetTargetId);\n                updateElementAtCursor(textarea, content);\n                varienGlobalEvents.fireEvent('tinymceChange');\n                jQuery(textarea).change();\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        wysiwygExists: function () {\n            return typeof wysiwyg != 'undefined' && wysiwyg.get(this.widgetTargetId);\n        },\n\n        /**\n         * @return {null|wysiwyg.Editor|*}\n         */\n        getWysiwyg: function () {\n            return wysiwyg.get(this.widgetTargetId);\n        },\n\n        /**\n         * @return {*|Element}\n         */\n        getWysiwygNode: function () {\n            return widgetTools.getActiveSelectedNode() || wysiwyg.activeEditor().selection.getNode();\n        }\n    };\n\n    WysiwygWidget.chooser = Class.create();\n    WysiwygWidget.chooser.prototype = {\n\n        // HTML element A, on which click event fired when choose a selection\n        chooserId: null,\n\n        // Source URL for Ajax requests\n        chooserUrl: null,\n\n        // Chooser config\n        config: null,\n\n        // Chooser dialog window\n        dialogWindow: null,\n\n        // Chooser content for dialog window\n        dialogContent: null,\n\n        overlayShowEffectOptions: null,\n        overlayHideEffectOptions: null,\n\n        /**\n         * @param {*} chooserId\n         * @param {*} chooserUrl\n         * @param {*} config\n         */\n        initialize: function (chooserId, chooserUrl, config) {\n            this.chooserId = chooserId;\n            this.chooserUrl = chooserUrl;\n            this.config = config;\n        },\n\n        /**\n         * @return {String}\n         */\n        getResponseContainerId: function () {\n            return 'responseCnt' + this.chooserId;\n        },\n\n        /**\n         * @return {jQuery|*|HTMLElement}\n         */\n        getChooserControl: function () {\n            return $(this.chooserId + 'control');\n        },\n\n        /**\n         * @return {jQuery|*|HTMLElement}\n         */\n        getElement: function () {\n            return $(this.chooserId + 'value');\n        },\n\n        /**\n         * @return {jQuery|*|HTMLElement}\n         */\n        getElementLabel: function () {\n            return $(this.chooserId + 'label');\n        },\n\n        /**\n         * Open.\n         */\n        open: function () {\n            $(this.getResponseContainerId()).show();\n        },\n\n        /**\n         * Close.\n         */\n        close: function () {\n            $(this.getResponseContainerId()).hide();\n            this.closeDialogWindow();\n        },\n\n        /**\n         * Choose.\n         */\n        choose: function () {\n            // Open dialog window with previously loaded dialog content\n            var responseContainerId;\n\n            if (this.dialogContent) {\n                this.openDialogWindow(this.dialogContent);\n\n                return;\n            }\n            // Show or hide chooser content if it was already loaded\n            responseContainerId = this.getResponseContainerId();\n\n            // Otherwise load content from server\n            new Ajax.Request(this.chooserUrl, {\n                parameters: {\n                    'element_value': this.getElementValue(),\n                    'element_label': this.getElementLabelText()\n                },\n\n                /**\n                 * On success.\n                 */\n                onSuccess: function (transport) {\n                    try {\n                        widgetTools.onAjaxSuccess(transport);\n                        this.dialogContent = widgetTools.getDivHtml(responseContainerId, transport.responseText);\n                        this.openDialogWindow(this.dialogContent);\n                    } catch (e) {\n                        alert({\n                            content: e.message\n                        });\n                    }\n                }.bind(this)\n            });\n        },\n\n        /**\n         * Open dialog winodw.\n         *\n         * @param {*} content\n         */\n        openDialogWindow: function (content) {\n            this.dialogWindow = jQuery('<div/>').modal({\n                title: this.config.buttons.open,\n                type: 'slide',\n                buttons: [],\n\n                /**\n                 * Opened.\n                 */\n                opened: function () {\n                    jQuery(this).addClass('magento-message');\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} modal\n                 */\n                closed: function (e, modal) {\n                    modal.modal.remove();\n                    this.dialogWindow = null;\n                }\n            });\n\n            this.dialogWindow.modal('openModal').append(content);\n        },\n\n        /**\n         * Close dialog window.\n         */\n        closeDialogWindow: function () {\n            this.dialogWindow.modal('closeModal').remove();\n        },\n\n        /**\n         * @return {*|Number}\n         */\n        getElementValue: function () {\n            return this.getElement().value;\n        },\n\n        /**\n         * @return {String}\n         */\n        getElementLabelText: function () {\n            return this.getElementLabel().innerHTML;\n        },\n\n        /**\n         * @param {*} value\n         */\n        setElementValue: function (value) {\n            this.getElement().value = value;\n        },\n\n        /**\n         * @param {*} value\n         */\n        setElementLabel: function (value) {\n            this.getElementLabel().innerHTML = value;\n        }\n    };\n\n    window.WysiwygWidget = WysiwygWidget;\n    window.widgetTools = widgetTools;\n});\n","mage/adminhtml/wysiwyg/tiny_mce/tinymce4Adapter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global popups, tinyMceEditors, MediabrowserUtility, Base64 */\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'underscore',\n    'tinymce4',\n    'mage/adminhtml/events',\n    'mage/adminhtml/wysiwyg/events',\n    'mage/translate',\n    'prototype',\n    'jquery/ui'\n], function (jQuery, _, tinyMCE4, varienGlobalEvents, wysiwygEvents) {\n    'use strict';\n\n    var tinyMce4Wysiwyg = Class.create();\n\n    tinyMce4Wysiwyg.prototype = {\n        mediaBrowserOpener: null,\n        mediaBrowserTargetElementId: null,\n        magentoVariablesPlugin: null,\n        mode: 'exact',\n\n        /**\n         * @param {*} htmlId\n         * @param {Object} config\n         */\n        initialize: function (htmlId, config) {\n            this.id = htmlId;\n            this.config = config;\n\n            _.bindAll(\n                this,\n                'beforeSetContent',\n                'saveContent',\n                'onChangeContent',\n                'openFileBrowser',\n                'updateTextArea',\n                'onUndo',\n                'removeEvents'\n            );\n\n            varienGlobalEvents.attachEventHandler('tinymceChange', this.onChangeContent);\n            varienGlobalEvents.attachEventHandler('tinymceBeforeSetContent', this.beforeSetContent);\n            varienGlobalEvents.attachEventHandler('tinymceSetContent', this.updateTextArea);\n            varienGlobalEvents.attachEventHandler('tinymceSaveContent', this.saveContent);\n            varienGlobalEvents.attachEventHandler('tinymceUndo', this.onUndo);\n\n            if (typeof tinyMceEditors === 'undefined') {\n                window.tinyMceEditors = $H({});\n            }\n\n            tinyMceEditors.set(this.id, this);\n        },\n\n        /**\n         * Ensures the undo operation works properly\n         */\n        onUndo: function () {\n            this.addContentEditableAttributeBackToNonEditableNodes();\n        },\n\n        /**\n         * Setup TinyMCE4 editor\n         */\n        setup: function (mode) {\n            var deferreds = [],\n                settings,\n                self = this;\n\n            this.turnOff();\n\n            if (this.config.plugins) {\n                this.config.plugins.forEach(function (plugin) {\n                    var deferred;\n\n                    self.addPluginToToolbar(plugin.name, '|');\n\n                    if (!plugin.src) {\n                        return;\n                    }\n\n                    deferred = jQuery.Deferred();\n                    deferreds.push(deferred);\n\n                    require([plugin.src], function (factoryFn) {\n                        if (typeof factoryFn === 'function') {\n                            factoryFn(plugin.options);\n                        }\n\n                        tinyMCE4.PluginManager.load(plugin.name, plugin.src);\n                        deferred.resolve();\n                    });\n                });\n            }\n\n            if (jQuery.isReady) {\n                tinyMCE4.dom.Event.domLoaded = true;\n            }\n\n            settings = this.getSettings();\n\n            if (mode === 'inline') {\n                settings.inline = true;\n\n                if (!isNaN(settings.toolbarZIndex)) {\n                    tinyMCE4.ui.FloatPanel.zIndex = settings.toolbarZIndex;\n                }\n\n                this.removeEvents(self.id);\n            }\n\n            jQuery.when.apply(jQuery, deferreds).done(function () {\n                tinyMCE4.init(settings);\n                this.getPluginButtons().hide();\n                this.eventBus.attachEventHandler('open_browser_callback', tinyMceEditors.get(self.id).openFileBrowser);\n            }.bind(this));\n        },\n\n        /**\n         * Remove events from instance.\n         *\n         * @param {String} wysiwygId\n         */\n        removeEvents: function (wysiwygId) {\n            var editor;\n\n            if (typeof tinyMceEditors !== 'undefined' && tinyMceEditors.get(wysiwygId)) {\n                editor = tinyMceEditors.get(wysiwygId);\n                varienGlobalEvents.removeEventHandler('tinymceChange', editor.onChangeContent);\n            }\n        },\n\n        /**\n         * Add plugin to the toolbar if not added.\n         *\n         * @param {String} plugin\n         * @param {String} separator\n         */\n        addPluginToToolbar: function (plugin, separator) {\n            var plugins = this.config.tinymce4.plugins.split(' '),\n                toolbar = this.config.tinymce4.toolbar.split(' ');\n\n            if (plugins.indexOf(plugin) === -1) {\n                plugins.push(plugin);\n            }\n\n            if (toolbar.indexOf(plugin) === -1) {\n                toolbar.push(separator || '', plugin);\n            }\n\n            this.config.tinymce4.plugins = plugins.join(' ');\n            this.config.tinymce4.toolbar = toolbar.join(' ');\n        },\n\n        /**\n         * Set the status of the toolbar to disabled or enabled (true for enabled, false for disabled)\n         * @param {Boolean} enabled\n         */\n        setToolbarStatus: function (enabled) {\n            var controlIds = this.get(this.getId()).theme.panel.rootControl.controlIdLookup;\n\n            _.each(controlIds, function (controlId) {\n                controlId.disabled(!enabled);\n                controlId.canFocus = enabled;\n\n                if (controlId.tooltip) {\n                    controlId.tooltip().state.set('rendered', enabled);\n\n                    if (enabled) {\n                        jQuery(controlId.getEl()).children('button').andSelf().removeAttr('style');\n                    } else {\n                        jQuery(controlId.getEl()).children('button').andSelf().attr('style', 'color: inherit;' +\n                            'background-color: inherit;' +\n                            'border-color: transparent;'\n                        );\n                    }\n                }\n            });\n        },\n\n        /**\n         * @return {Object}\n         */\n        getSettings: function () {\n            var settings,\n                eventBus = this.eventBus;\n\n            settings = {\n                selector: '#' + this.getId(),\n                theme: 'modern',\n                skin: 'magento',\n                'entity_encoding': 'raw',\n                'convert_urls': false,\n                'content_css': this.config.tinymce4['content_css'],\n                'relative_urls': true,\n                menubar: false,\n                plugins: this.config.tinymce4.plugins,\n                toolbar: this.config.tinymce4.toolbar,\n                adapter: this,\n\n                /**\n                 * @param {Object} editor\n                 */\n                setup: function (editor) {\n                    var onChange;\n\n                    editor.on('BeforeSetContent', function (evt) {\n                        varienGlobalEvents.fireEvent('tinymceBeforeSetContent', evt);\n                        eventBus.fireEvent(wysiwygEvents.beforeSetContent);\n                    });\n\n                    editor.on('SaveContent', function (evt) {\n                        varienGlobalEvents.fireEvent('tinymceSaveContent', evt);\n                        eventBus.fireEvent(wysiwygEvents.afterSave);\n                    });\n\n                    editor.on('paste', function (evt) {\n                        varienGlobalEvents.fireEvent('tinymcePaste', evt);\n                        eventBus.fireEvent(wysiwygEvents.afterPaste);\n                    });\n\n                    editor.on('PostProcess', function (evt) {\n                        varienGlobalEvents.fireEvent('tinymceSaveContent', evt);\n                        eventBus.fireEvent(wysiwygEvents.afterSave);\n                    });\n\n                    editor.on('undo', function (evt) {\n                        varienGlobalEvents.fireEvent('tinymceUndo', evt);\n                        eventBus.fireEvent(wysiwygEvents.afterUndo);\n                    });\n\n                    editor.on('focus', function () {\n                        eventBus.fireEvent(wysiwygEvents.afterFocus);\n                    });\n\n                    editor.on('blur', function () {\n                        eventBus.fireEvent(wysiwygEvents.afterBlur);\n                    });\n\n                    /**\n                     * @param {*} evt\n                     */\n                    onChange = function (evt) {\n                        varienGlobalEvents.fireEvent('tinymceChange', evt);\n                        eventBus.fireEvent(wysiwygEvents.afterChangeContent);\n                    };\n\n                    editor.on('Change', onChange);\n                    editor.on('keyup', onChange);\n\n                    editor.on('ExecCommand', function (cmd) {\n                        varienGlobalEvents.fireEvent('tinymceExecCommand', cmd);\n                    });\n\n                    editor.on('init', function (args) {\n                        varienGlobalEvents.fireEvent('wysiwygEditorInitialized', args.target);\n                        eventBus.fireEvent(wysiwygEvents.afterInitialization);\n                    });\n                }\n            };\n\n            if (this.config.skin) {\n                settings.skin = this.config.skin;\n            }\n\n            if (this.config.baseStaticUrl && this.config.baseStaticDefaultUrl) {\n                settings['document_base_url'] = this.config.baseStaticUrl;\n            }\n            // Set the document base URL\n            if (this.config['document_base_url']) {\n                settings['document_base_url'] = this.config['document_base_url'];\n            }\n\n            if (this.config['files_browser_window_url']) {\n                /**\n                 * @param {*} fieldName\n                 * @param {*} url\n                 * @param {*} objectType\n                 * @param {*} w\n                 */\n                settings['file_browser_callback'] = function (fieldName, url, objectType, w) {\n                    var payload = {\n                        win: w,\n                        type: objectType,\n                        field: fieldName\n                    };\n\n                    varienGlobalEvents.fireEvent('open_browser_callback', payload);\n                    this.eventBus.fireEvent('open_browser_callback', payload);\n                }.bind(this);\n            }\n\n            if (this.config.width) {\n                settings.width = this.config.width;\n            }\n\n            if (this.config.height) {\n                settings.height = this.config.height;\n            }\n\n            if (this.config.plugins) {\n                settings.magentoPluginsOptions = {};\n\n                _.each(this.config.plugins, function (plugin) {\n                    settings.magentoPluginsOptions[plugin.name] = plugin.options;\n                });\n            }\n\n            if (this.config.settings) {\n                Object.extend(settings, this.config.settings);\n            }\n\n            return settings;\n        },\n\n        /**\n         * @param {String} id\n         */\n        get: function (id) {\n            return tinyMCE4.get(id);\n        },\n\n        /**\n         * @return {String|null}\n         */\n        getId: function () {\n            return this.id || (this.activeEditor() ? this.activeEditor().id : null) || tinyMceEditors.values()[0].id;\n        },\n\n        /**\n         * @return {Object}\n         */\n        activeEditor: function () {\n            return tinyMCE4.activeEditor;\n        },\n\n        /**\n         * Insert content to active editor.\n         *\n         * @param {String} content\n         * @param {Boolean} ui\n         */\n        insertContent: function (content, ui) {\n            this.activeEditor().execCommand('mceInsertContent', typeof ui !== 'undefined' ? ui : false, content);\n        },\n\n        /**\n         * Replace entire contents of wysiwyg with string content parameter\n         *\n         * @param {String} content\n         */\n        setContent: function (content) {\n            this.get(this.getId()).setContent(content);\n        },\n\n        /**\n         * Set caret location in WYSIWYG editor.\n         *\n         * @param {Object} targetElement\n         */\n        setCaretOnElement: function (targetElement) {\n            this.activeEditor().selection.select(targetElement);\n            this.activeEditor().selection.collapse();\n        },\n\n        /**\n         * @param {Object} o\n         */\n        openFileBrowser: function (o) {\n            var typeTitle = this.translate('Select Images'),\n                storeId = this.config['store_id'] !== null ? this.config['store_id'] : 0,\n                frameDialog = jQuery('div.mce-container[role=\"dialog\"]'),\n                wUrl = this.config['files_browser_window_url'] +\n                    'target_element_id/' + this.getId() + '/' +\n                    'store/' + storeId + '/';\n\n            this.mediaBrowserOpener = o.win;\n            this.mediaBrowserTargetElementId = o.field;\n\n            if (typeof o.type !== 'undefined' && o.type !== '') { //eslint-disable-line eqeqeq\n                wUrl = wUrl + 'type/' + o.type + '/';\n            }\n\n            frameDialog.hide();\n            jQuery('#mce-modal-block').hide();\n\n            require(['mage/adminhtml/browser'], function () {\n                MediabrowserUtility.openDialog(wUrl, false, false, typeTitle, {\n                    /**\n                     * Closed.\n                     */\n                    closed: function () {\n                        frameDialog.show();\n                        jQuery('#mce-modal-block').show();\n                    }\n                });\n            });\n        },\n\n        /**\n         * @param {String} string\n         * @return {String}\n         */\n        translate: function (string) {\n            return jQuery.mage.__ ? jQuery.mage.__(string) : string;\n        },\n\n        /**\n         * @return {null}\n         */\n        getMediaBrowserOpener: function () {\n            return this.mediaBrowserOpener;\n        },\n\n        /**\n         * @return {null}\n         */\n        getMediaBrowserTargetElementId: function () {\n            return this.mediaBrowserTargetElementId;\n        },\n\n        /**\n         * @return {jQuery|*|HTMLElement}\n         */\n        getToggleButton: function () {\n            return $('toggle' + this.getId());\n        },\n\n        /**\n         * Get plugins button.\n         */\n        getPluginButtons: function () {\n            return jQuery('#buttons' + this.getId() + ' > button.plugin');\n        },\n\n        /**\n         * @param {*} mode\n         * @return {wysiwygSetup}\n         */\n        turnOn: function (mode) {\n            this.closePopups();\n\n            this.setup(mode);\n\n            this.getPluginButtons().hide();\n\n            tinyMCE4.execCommand('mceAddControl', false, this.getId());\n\n            return this;\n        },\n\n        /**\n         * @param {String} name\n         */\n        closeEditorPopup: function (name) {\n            if (typeof popups !== 'undefined' && popups[name] !== undefined && !popups[name].closed) {\n                popups[name].close();\n            }\n        },\n\n        /**\n         * @return {wysiwygSetup}\n         */\n        turnOff: function () {\n            this.closePopups();\n\n            this.getPluginButtons().show();\n\n            tinyMCE4.execCommand('mceRemoveEditor', false, this.getId());\n\n            return this;\n        },\n\n        /**\n         * Close popups.\n         */\n        closePopups: function () {\n            // close all popups to avoid problems with updating parent content area\n            varienGlobalEvents.fireEvent('wysiwygClosePopups');\n            this.closeEditorPopup('browser_window' + this.getId());\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        toggle: function () {\n            var content;\n\n            if (!tinyMCE4.get(this.getId())) {\n                this.turnOn();\n\n                return true;\n            }\n\n            content = this.get(this.getId()) ? this.get(this.getId()).getContent() : this.getTextArea().val();\n\n            this.turnOff();\n\n            if (content.match(/{{.+?}}/g)) {\n                this.getTextArea().val(content.replace(/&quot;/g, '\"'));\n            }\n\n            return false;\n        },\n\n        /**\n         * On form validation.\n         */\n        onFormValidation: function () {\n            if (tinyMCE4.get(this.getId())) {\n                $(this.getId()).value = tinyMCE4.get(this.getId()).getContent();\n            }\n        },\n\n        /**\n         * On change content.\n         */\n        onChangeContent: function () {\n            // Add \"changed\" to tab class if it exists\n            var tab;\n\n            this.updateTextArea();\n\n            if (this.config['tab_id']) {\n                tab = $$('a[id$=' + this.config['tab_id'] + ']')[0];\n\n                if ($(tab) != undefined && $(tab).hasClassName('tab-item-link')) { //eslint-disable-line eqeqeq\n                    $(tab).addClassName('changed');\n                }\n            }\n        },\n\n        /**\n         * @param {Object} o\n         */\n        beforeSetContent: function (o) {\n            o.content = this.encodeContent(o.content);\n        },\n\n        /**\n         * @param {Object} o\n         */\n        saveContent: function (o) {\n            o.content = this.decodeContent(o.content);\n        },\n\n        /**\n         * Return the content stored in the WYSIWYG field\n         * @param {String} id\n         * @return {String}\n         */\n        getContent: function (id) {\n            return id ? this.get(id).getContent() : this.get(this.getId()).getContent();\n        },\n\n        /**\n         * @returns {Object}\n         */\n        getAdapterPrototype: function () {\n            return tinyMce4Wysiwyg;\n        },\n\n        /**\n         * Fix range selection placement when typing.  This fixes MAGETWO-84769\n         * @param {Object} editor\n         */\n        fixRangeSelection: function (editor) {\n            var selection = editor.selection,\n                dom = editor.dom,\n                rng = dom.createRng(),\n                doc = editor.getDoc(),\n                markerHtml,\n                marker;\n\n            // Validate the range we're trying to fix is contained within the current editors document\n            if (!selection.getContent().length && jQuery.contains(doc, selection.getRng().startContainer)) {\n                markerHtml = '<span id=\"mce_marker\" data-mce-type=\"bookmark\">\\uFEFF</span>';\n                selection.setContent(markerHtml);\n                marker = dom.get('mce_marker');\n                rng.setStartBefore(marker);\n                rng.setEndBefore(marker);\n                dom.remove(marker);\n                selection.setRng(rng);\n            }\n        },\n\n        /**\n         * Update text area.\n         */\n        updateTextArea: function () {\n            var editor = this.get(this.getId()),\n                content;\n\n            if (!editor || editor.id !== this.activeEditor().id) {\n                return;\n            }\n\n            this.addContentEditableAttributeBackToNonEditableNodes();\n            this.fixRangeSelection(editor);\n\n            content = editor.getContent();\n            content = this.decodeContent(content);\n\n            this.getTextArea().val(content).trigger('change');\n        },\n\n        /**\n         * @return {Object} jQuery textarea element\n         */\n        getTextArea: function () {\n            return jQuery('#' + this.getId());\n        },\n\n        /**\n         * Set the status of the editor and toolbar\n         *\n         * @param {Boolean} enabled\n         */\n        setEnabledStatus: function (enabled) {\n            if (this.activeEditor()) {\n                this.activeEditor().getBody().setAttribute('contenteditable', enabled);\n                this.activeEditor().readonly = !enabled;\n                this.setToolbarStatus(enabled);\n            }\n\n            if (enabled) {\n                this.getTextArea().removeProp('disabled');\n            } else {\n                this.getTextArea().prop('disabled', 'disabled');\n            }\n        },\n\n        /**\n         * Retrieve directives URL with substituted directive value.\n         *\n         * @param {String} directive\n         */\n        makeDirectiveUrl: function (directive) {\n            return this.config['directives_url']\n                .replace(/directive/, 'directive/___directive/' + directive)\n                .replace(/\\/$/, '');\n        },\n\n        /**\n         * Convert {{directive}} style attributes syntax to absolute URLs\n         * @param {Object} content\n         * @return {*}\n         */\n        encodeDirectives: function (content) {\n            // collect all HTML tags with attributes that contain directives\n            return content.gsub(/<([a-z0-9\\-\\_]+[^>]+?)([a-z0-9\\-\\_]+=\"[^\"]*?\\{\\{.+?\\}\\}.*?\".*?)>/i, function (match) {\n                var attributesString = match[2],\n                    decodedDirectiveString;\n\n                // process tag attributes string\n                attributesString = attributesString.gsub(/([a-z0-9\\-\\_]+)=\"(.*?)(\\{\\{.+?\\}\\})(.*?)\"/i, function (m) {\n                    decodedDirectiveString = encodeURIComponent(Base64.mageEncode(m[3].replace(/&quot;/g, '\"') + m[4]));\n\n                    return m[1] + '=\"' + m[2] + this.makeDirectiveUrl(decodedDirectiveString) + '\"';\n                }.bind(this));\n\n                return '<' + match[1] + attributesString + '>';\n            }.bind(this));\n        },\n\n        /**\n         * Convert absolute URLs to {{directive}} style attributes syntax\n         * @param {Object} content\n         * @return {*}\n         */\n        decodeDirectives: function (content) {\n            var directiveUrl = this.makeDirectiveUrl('%directive%').split('?')[0], // remove query string from directive\n                // escape special chars in directives url to use in regular expression\n                regexEscapedDirectiveUrl = directiveUrl.replace(/([$^.?*!+:=()\\[\\]{}|\\\\])/g, '\\\\$1'),\n                regexDirectiveUrl = regexEscapedDirectiveUrl\n                    .replace(\n                        '%directive%',\n                        '([a-zA-Z0-9,_-]+(?:%2[A-Z]|)+\\/?)(?:(?!\").)*'\n                    ) + '/?(\\\\\\\\?[^\"]*)?', // allow optional query string\n                reg = new RegExp(regexDirectiveUrl);\n\n            return content.gsub(reg, function (match) {\n                return Base64.mageDecode(decodeURIComponent(match[1]).replace(/\\/$/, '')).replace(/\"/g, '&quot;');\n            });\n        },\n\n        /**\n         * @param {Object} attributes\n         * @return {Object}\n         */\n        parseAttributesString: function (attributes) {\n            var result = {};\n\n            // Decode &quot; entity, as regex below does not support encoded quote\n            attributes = attributes.replace(/&quot;/g, '\"');\n\n            attributes.gsub(\n                /(\\w+)(?:\\s*=\\s*(?:(?:\"((?:\\\\.|[^\"])*)\")|(?:'((?:\\\\.|[^'])*)')|([^>\\s]+)))?/,\n                function (match) {\n                    result[match[1]] = match[2];\n                }\n            );\n\n            return result;\n        },\n\n        /**\n         * @param {Object} content\n         * @return {*}\n         */\n        decodeContent: function (content) {\n            if (this.config['add_directives']) {\n                content = this.decodeDirectives(content);\n            }\n\n            content = varienGlobalEvents.fireEventReducer('wysiwygDecodeContent', content);\n\n            return content;\n        },\n\n        /**\n         * @param {Object} content\n         * @return {*}\n         */\n        encodeContent: function (content) {\n            if (this.config['add_directives']) {\n                content = this.encodeDirectives(content);\n            }\n\n            content = varienGlobalEvents.fireEventReducer('wysiwygEncodeContent', content);\n\n            return content;\n        },\n\n        /**\n         * Reinstate contenteditable attributes on .mceNonEditable nodes\n         */\n        addContentEditableAttributeBackToNonEditableNodes: function () {\n            jQuery('.mceNonEditable', this.activeEditor().getDoc()).attr('contenteditable', false);\n        }\n    };\n\n    return tinyMce4Wysiwyg.prototype;\n});\n","mage/adminhtml/wysiwyg/tiny_mce/html5-schema.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    /* eslint-disable max-len */\n\n    var schema = {\n        blockContent: [\n            'address', 'article', 'aside', 'blockquote', 'details', 'dialog', 'div', 'dl', 'fieldset',\n            'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hgroup', 'hr',\n            'menu', 'nav', 'ol', 'p', 'pre', 'section', 'table', 'ul'\n        ],\n        phrasingContent: [\n            '#comment', '#text', 'a', 'abbr', 'audio', 'b', 'bdi', 'bdo', 'br', 'button', 'canvas',\n            'cite','code', 'command', 'datalist', 'del', 'dfn', 'em', 'embed', 'i', 'iframe', 'img',\n            'input', 'ins', 'kbd', 'keygen', 'label', 'map', 'mark', 'meter', 'noscript', 'object',\n            'output', 'picture', 'progress', 'q', 'ruby', 's', 'samp', 'script', 'select', 'small',\n            'span', 'strong', 'sub', 'sup', 'textarea', 'time', 'u', 'var', 'video', 'wbr'\n        ],\n        blockElements: [\n            'address', 'article', 'aside', 'blockquote', 'caption', 'center', 'datalist', 'dd', 'dir', 'div',\n            'dl', 'dt', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6',\n            'header', 'hgroup', 'hr', 'isindex', 'li', 'menu', 'nav', 'noscript', 'ol', 'optgroup', 'option',\n            'p', 'pre', 'section', 'select', 'table', 'tbody', 'td', 'tfoot', 'th', 'thead', 'tr', 'ul'\n        ],\n        boolAttrs: [\n            'autoplay', 'checked', 'compact', 'controls', 'declare', 'defer', 'disabled', 'ismap', 'loop',\n            'multiple', 'nohref', 'noresize', 'noshade', 'nowrap', 'readonly', 'selected'\n        ],\n        shortEnded: [\n            'area', 'base', 'basefont', 'br', 'col', 'embed', 'frame', 'hr', 'img', 'input', 'isindex',\n            'link', 'meta', 'param', 'source', 'track', 'wbr'\n        ],\n        whiteSpace: [\n            'audio', 'iframe', 'noscript', 'object', 'pre', 'script', 'style', 'textarea', 'video'\n        ],\n        selfClosing: [\n            'colgroup', 'dd', 'dt', 'li', 'option', 'p', 'td', 'tfoot', 'th', 'thead', 'tr'\n        ]\n    };\n\n    schema.flowContent = schema.blockContent.concat(schema.phrasingContent, ['style']);\n    schema.nonEmpty = ['td', 'th', 'iframe', 'video', 'audio', 'object', 'script', 'i', 'em', 'span'].concat(schema.shortEnded);\n\n    _.extend(schema, (function (phrasingContent, flowContent) {\n        var validElements   = [],\n            validChildren   = [],\n            compiled        = {},\n            globalAttrs,\n            rawData;\n\n        globalAttrs = [\n            'id', 'dir', 'lang', 'class', 'style', 'title', 'hidden', 'onclick', 'onkeyup',\n            'tabindex', 'dropzone', 'accesskey', 'draggable', 'translate', 'onmouseup',\n            'onkeydown', 'spellcheck', 'ondblclick', 'onmouseout', 'onkeypress', 'contextmenu',\n            'onmousedown', 'onmouseover', 'onmousemove', 'contenteditable'\n        ];\n\n        rawData = [\n            ['html', 'manifest', 'head body'],\n            ['head', '', 'base command link meta noscript script style title'],\n            ['title hr noscript br'],\n            ['base', 'href target'],\n            ['link', 'href rel media hreflang type sizes hreflang'],\n            ['meta', 'name http-equiv content charset'],\n            ['style', 'media type scoped'],\n            ['script', 'src async defer type charset'],\n            ['body', 'onafterprint onbeforeprint onbeforeunload onblur onerror onfocus ' +\n                'onhashchange onload onmessage onoffline ononline onpagehide onpageshow ' +\n                'onpopstate onresize onscroll onstorage onunload background bgcolor text link vlink alink', flowContent\n            ],\n            ['caption', '', _.without(flowContent, 'table')],\n            ['address dt dd div', '', flowContent],\n            ['h1 h2 h3 h4 h5 h6 pre p abbr code var samp kbd sub sup i b u bdo span legend em strong small s cite dfn', '', phrasingContent],\n            ['blockquote', 'cite', flowContent],\n            ['ol', 'reversed start type', 'li'],\n            ['ul', 'type compact', 'li'],\n            ['li', 'value type', flowContent],\n            ['dl', '', 'dt dd'],\n            ['a', 'href target rel media hreflang type charset name rev shape coords download', phrasingContent],\n            ['q', 'cite', phrasingContent],\n            ['ins del', 'cite datetime', flowContent],\n            ['img', 'src sizes srcset alt usemap ismap width height name longdesc align border hspace vspace'],\n            ['iframe', 'src name width height longdesc frameborder marginwidth marginheight scrolling align sandbox seamless allowfullscreen', flowContent],\n            ['embed', 'src type width height'],\n            ['object', 'data type typemustmatch name usemap form width height declare classid code codebase codetype archive standby align border hspace vspace', flowContent.concat(['param'])],\n            ['param', 'name value valuetype type'],\n            ['map', 'name', flowContent.concat(['area'])],\n            ['area', 'alt coords shape href target rel media hreflang type nohref'],\n            ['table', 'border summary width frame rules cellspacing cellpadding align bgcolor', 'caption colgroup thead tfoot tbody tr col'],\n            ['colgroup', 'span width align char charoff valign', 'col'],\n            ['col', 'span'],\n            ['tbody thead tfoot', 'align char charoff valign', 'tr'],\n            ['tr', 'align char charoff valign bgcolor', 'td th'],\n            ['td', 'colspan rowspan headers abbr axis scope align char charoff valign nowrap bgcolor width height', flowContent],\n            ['th', 'colspan rowspan headers scope abbr axis align char charoff valign nowrap bgcolor width height accept', flowContent],\n            ['form', 'accept-charset action autocomplete enctype method name novalidate target onsubmit onreset', flowContent],\n            ['fieldset', 'disabled form name', flowContent.concat(['legend'])],\n            ['label', 'form for', phrasingContent],\n            ['input', 'accept alt autocomplete checked dirname disabled form formaction formenctype formmethod formnovalidate ' +\n                'formtarget height list max maxlength min multiple name pattern readonly required size src step type value width usemap align'\n            ],\n            ['button', 'disabled form formaction formenctype formmethod formnovalidate formtarget name type value', phrasingContent],\n            ['select', 'disabled form multiple name required size onfocus onblur onchange', 'option optgroup'],\n            ['optgroup', 'disabled label', 'option'],\n            ['option', 'disabled label selected value'],\n            ['textarea', 'cols dirname disabled form maxlength name readonly required rows wrap'],\n            ['menu', 'type label', flowContent.concat(['li'])],\n            ['noscript', '', flowContent],\n            ['wbr'],\n            ['ruby', '', phrasingContent.concat(['rt', 'rp'])],\n            ['figcaption', '', flowContent],\n            ['mark rt rp summary bdi', '', phrasingContent],\n            ['canvas', 'width height', flowContent],\n            ['video', 'src crossorigin poster preload autoplay mediagroup loop muted controls width height buffered', flowContent.concat(['track', 'source'])],\n            ['audio', 'src crossorigin preload autoplay mediagroup loop muted controls buffered volume', flowContent.concat(['track', 'source'])],\n            ['picture', '', 'img source'],\n            ['source', 'src srcset type media sizes'],\n            ['track', 'kind src srclang label default'],\n            ['datalist', '', phrasingContent.concat(['option'])],\n            ['article section nav aside header footer', '', flowContent],\n            ['hgroup', '', 'h1 h2 h3 h4 h5 h6'],\n            ['figure', '', flowContent.concat(['figcaption'])],\n            ['time', 'datetime', phrasingContent],\n            ['dialog', 'open', flowContent],\n            ['command', 'type label icon disabled checked radiogroup command'],\n            ['output', 'for form name', phrasingContent],\n            ['progress', 'value max', phrasingContent],\n            ['meter', 'value min max low high optimum', phrasingContent],\n            ['details', 'open', flowContent.concat(['summary'])],\n            ['keygen', 'autofocus challenge disabled form keytype name'],\n            ['script', 'language xml:space'],\n            ['style', 'xml:space'],\n            ['embed', 'align name hspace vspace'],\n            ['br', 'clear'],\n            ['applet', 'codebase archive code object alt name width height align hspace vspace'],\n            ['font basefont', 'size color face'],\n            ['h1 h2 h3 h4 h5 h6 div p legend caption', 'align'],\n            ['ol dl menu dir', 'compact'],\n            ['pre', 'width xml:space'],\n            ['hr', 'align noshade size width'],\n            ['isindex', 'prompt'],\n            ['col', 'width align char charoff valign'],\n            ['input button select textarea', 'autofocus'],\n            ['input textarea', 'placeholder onselect onchange onfocus onblur'],\n            ['link script img', 'crossorigin']\n        ];\n\n        rawData.forEach(function (data) {\n            var nodes       = data[0].split(' '),\n                attributes  = data[1] || [],\n                children    = data[2] || [],\n                ni          = nodes.length,\n                nodeName,\n                schemaData;\n\n            if (typeof attributes === 'string') {\n                attributes = attributes.split(' ');\n            }\n\n            if (typeof children === 'string') {\n                children = children.split(' ');\n            }\n\n            while (ni--) {\n                nodeName    = nodes[ni];\n                schemaData  = compiled[nodeName] || {};\n\n                compiled[nodeName] = {\n                    attributes: _.union(schemaData.attributes, globalAttrs, attributes),\n                    children: _.union(schemaData.children, children)\n                };\n            }\n        });\n\n        ['a', 'dfn', 'form', 'meter', 'progress'].forEach(function (nodeName) {\n            var node = compiled[nodeName];\n\n            node.children = _.without(node.children, nodeName);\n        });\n\n        _.each(compiled, function (node, nodeName) {\n            var filteredAttributes = [];\n\n            _.each(node.attributes, function (attribute) { //eslint-disable-line max-nested-callbacks\n                // Disallowing usage of 'on*' attributes.\n                if (!/^on/.test(attribute)) {\n                    filteredAttributes.push(attribute);\n                }\n            });\n\n            node.attributes = filteredAttributes;\n\n            validElements.push(nodeName + '[' + node.attributes.join('|') + ']');\n            validChildren.push(nodeName + '[' + node.children.join('|') + ']');\n        });\n\n        return {\n            nodes: compiled,\n            validElements: validElements,\n            validChildren: validChildren\n        };\n    })(schema.phrasingContent, schema.flowContent));\n\n    return schema;\n});\n","mage/adminhtml/wysiwyg/tiny_mce/setup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'underscore',\n    'wysiwygAdapter',\n    'module',\n    'mage/translate',\n    'prototype',\n    'mage/adminhtml/events',\n    'mage/adminhtml/browser'\n], function (jQuery, _, wysiwygAdapter, module) {\n    var baseConfig = module.config().config || {},\n        wysiwygSetup = Class.create({\n        wysiwygInstance: null\n    });\n\n    wysiwygSetup.prototype = {\n\n        /**\n         * @param {*} htmlId\n         * @param {Object} config\n         */\n        initialize: function (htmlId, config) {\n            var WysiwygInstancePrototype = new wysiwygAdapter.getAdapterPrototype();\n\n            _.bindAll(this, 'openFileBrowser');\n\n            config = _.extend({}, baseConfig, config || {});\n            this.wysiwygInstance = new WysiwygInstancePrototype(htmlId, config);\n            this.wysiwygInstance.eventBus = this.eventBus = new window.varienEvents();\n        },\n\n        /**\n         * @param {*} mode\n         */\n        setup: function (mode) {\n            this.wysiwygInstance.setup(mode);\n        },\n\n        /**\n         * @param {Object} o\n         */\n        openFileBrowser: function (o) {\n            this.wysiwygInstance.openFileBrowser(o);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        toggle: function () {\n            return this.wysiwygInstance.toggle();\n        },\n\n        /**\n         * On form validation.\n         */\n        onFormValidation: function () {\n            this.wysiwygInstance.onFormValidation();\n        },\n\n        /**\n         * Encodes the content so it can be inserted into the wysiwyg\n         * @param {String} content - The content to be encoded\n         *\n         * @returns {*} - The encoded content\n         */\n        updateContent: function (content) {\n            return this.wysiwygInstance.encodeContent(content);\n        }\n\n    };\n    window.wysiwygSetup = wysiwygSetup;\n\n    return wysiwygSetup;\n});\n","mage/adminhtml/wysiwyg/tiny_mce/plugins/magentovariable/editor_plugin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global tinymce, MagentovariablePlugin, varienGlobalEvents, Base64 */\n/* eslint-disable strict */\ndefine([\n    'Magento_Variable/js/config-directive-generator',\n    'Magento_Variable/js/custom-directive-generator',\n    'wysiwygAdapter',\n    'jquery',\n    'mage/adminhtml/tools'\n], function (configDirectiveGenerator, customDirectiveGenerator, wysiwyg, jQuery) {\n    return function (config) {\n        tinymce.create('tinymce.plugins.magentovariable', {\n\n            /**\n             * Initialize editor plugin.\n             *\n             * @param {tinymce.editor} editor - Editor instance that the plugin is initialized in.\n             * @param {String} url - Absolute URL to where the plugin is located.\n             */\n            init: function (editor, url) {\n                var self = this;\n\n                /**\n                 * Add new command to open variables selector slideout.\n                 */\n                editor.addCommand('openVariablesSlideout', function (commandConfig) {\n                    var selectedElement;\n\n                    if (commandConfig) {\n                        selectedElement = commandConfig.selectedElement;\n                    } else {\n                        selectedElement = tinymce.activeEditor.selection.getNode();\n                    }\n                    MagentovariablePlugin.setEditor(editor);\n                    MagentovariablePlugin.loadChooser(\n                        config.url,\n                        wysiwyg.getId(),\n                        selectedElement\n                    );\n                });\n\n                /**\n                 * Add button to the editor toolbar.\n                 */\n                editor.addButton('magentovariable', {\n                    title: jQuery.mage.__('Insert Variable'),\n                    tooltip: jQuery.mage.__('Insert Variable'),\n                    cmd: 'openVariablesSlideout',\n                    image: url + '/img/icon.png',\n\n                    /**\n                     * Highlight or dismiss Insert Variable button when variable is selected or deselected.\n                     */\n                    onPostRender: function () {\n                        var _this = this,\n\n                        /**\n                         * Toggle active state of Insert Variable button.\n                         *\n                         * @param {Object} e\n                         */\n                        toggleVariableButton = function (e) {\n                            _this.active(false);\n\n                            if (jQuery(e.target).hasClass('magento-variable')) {\n                                _this.active(true);\n                            }\n                        };\n\n                        editor.on('click', toggleVariableButton);\n                        editor.on('change', toggleVariableButton);\n                    }\n                });\n\n                /**\n                 * Double click handler on the editor to handle dbl click on variable placeholder.\n                 */\n                editor.on('dblclick', function (evt) {\n                    if (jQuery(evt.target).hasClass('magento-variable')) {\n                        editor.selection.collapse(false);\n                        editor.execCommand('openVariablesSlideout', {\n                            ui: true,\n                            selectedElement: evt.target\n                        });\n                    }\n                });\n\n                /**\n                 * Attach event handler for when wysiwyg editor is about to encode its content\n                 */\n                varienGlobalEvents.attachEventHandler('wysiwygEncodeContent', function (content) {\n                    content = self.encodeVariables(content);\n\n                    return content;\n                });\n\n                /**\n                 * Attach event handler for when wysiwyg editor is about to decode its content\n                 */\n                varienGlobalEvents.attachEventHandler('wysiwygDecodeContent', function (content) {\n                    content = self.decodeVariables(content);\n\n                    return content;\n                });\n            },\n\n            /**\n             * Encode variables in content\n             *\n             * @param {String} content\n             * @returns {*}\n             */\n            encodeVariables: function (content) {\n                content = content.gsub(/\\{\\{config path=\\\"([^\\\"]+)\\\"\\}\\}/i, function (match) {\n                    var path = match[1],\n                        magentoVariables,\n                        imageHtml;\n\n                    magentoVariables = JSON.parse(config.placeholders);\n\n                    if (magentoVariables[match[1]] && magentoVariables[match[1]]['variable_type'] === 'default') {\n                        imageHtml = '<span id=\"%id\" class=\"magento-variable magento-placeholder mceNonEditable\">' +\n                            '%s</span>';\n                        imageHtml = imageHtml.replace('%s', magentoVariables[match[1]]['variable_name']);\n                    } else {\n                        imageHtml = '<span id=\"%id\" class=\"' +\n                            'magento-variable magento-placeholder magento-placeholder-error ' +\n                            'mceNonEditable' +\n                            '\">' +\n                            'Not found' +\n                            '</span>';\n                    }\n\n                    return imageHtml.replace('%id', Base64.idEncode(path));\n                });\n\n                content = content.gsub(/\\{\\{customVar code=([^\\}\\\"]+)\\}\\}/i, function (match) {\n                    var path = match[1],\n                        magentoVariables,\n                        imageHtml;\n\n                    magentoVariables = JSON.parse(config.placeholders);\n\n                    if (magentoVariables[match[1]] && magentoVariables[match[1]]['variable_type'] === 'custom') {\n                        imageHtml = '<span id=\"%id\" class=\"magento-variable magento-custom-var magento-placeholder ' +\n                            'mceNonEditable\">%s</span>';\n                        imageHtml = imageHtml.replace('%s', magentoVariables[match[1]]['variable_name']);\n                    } else {\n                        imageHtml = '<span id=\"%id\" class=\"' +\n                            'magento-variable magento-custom-var magento-placeholder ' +\n                            'magento-placeholder-error mceNonEditable' +\n                            '\">' +\n                            match[1] +\n                            '</span>';\n                    }\n\n                    return imageHtml.replace('%id', Base64.idEncode(path));\n                });\n\n                return content;\n            },\n\n            /**\n             * Decode variables in content.\n             *\n             * @param {String} content\n             * @returns {String}\n             */\n            decodeVariables: function (content) {\n                var doc = (new DOMParser()).parseFromString(content.replace(/&quot;/g, '&amp;quot;'), 'text/html');\n\n                [].forEach.call(doc.querySelectorAll('span.magento-variable'), function (el) {\n                    var $el = jQuery(el);\n\n                    if ($el.hasClass('magento-custom-var')) {\n                        $el.replaceWith(\n                            customDirectiveGenerator.processConfig(\n                                Base64.idDecode(\n                                    $el.attr('id')\n                                )\n                            )\n                        );\n                    } else {\n                        $el.replaceWith(\n                            configDirectiveGenerator.processConfig(\n                                Base64.idDecode(\n                                    $el.attr('id')\n                                )\n                            )\n                        );\n                    }\n                });\n\n                return doc.body ? doc.body.innerHTML.replace(/&amp;quot;/g, '&quot;') : content;\n            },\n\n            /**\n             * @return {Object}\n             */\n            getInfo: function () {\n                return {\n                    longname: 'Magento Variable Manager Plugin',\n                    author: 'Magento Core Team',\n                    authorurl: 'http://magentocommerce.com',\n                    infourl: 'http://magentocommerce.com',\n                    version: '1.0'\n                };\n            }\n        });\n\n        /**\n         * Register plugin\n         */\n        tinymce.PluginManager.add('magentovariable', tinymce.plugins.magentovariable);\n    };\n});\n","mage/adminhtml/wysiwyg/tiny_mce/plugins/magentowidget/editor_plugin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global tinymce, widgetTools, jQuery, Base64 */\n/* eslint-disable strict */\ndefine([\n    'wysiwygAdapter',\n    'mage/adminhtml/events',\n    'mage/adminhtml/wysiwyg/widget'\n], function (wysiwyg, varienGlobalEvents) {\n    return function (config) {\n        tinymce.create('tinymce.plugins.magentowidget', {\n\n            /**\n             * @param {tinymce.Editor} editor - Editor instance that the plugin is initialized in.\n             * @param {String} url - Absolute URL to where the plugin is located.\n             */\n            init: function (editor, url) {\n                var self = this;\n\n                this.activePlaceholder = null;\n\n                editor.addCommand('mceMagentowidget', function (img) {\n                    if (self.activePlaceholder) {\n                        img = self.activePlaceholder;\n                    }\n\n                    widgetTools.setActiveSelectedNode(img);\n                    widgetTools.openDialog(\n                        config['window_url'] + 'widget_target_id/' + editor.getElement().id + '/'\n                    );\n                });\n\n                // Register Widget plugin button\n                editor.addButton('magentowidget', {\n                    title: jQuery.mage.__('Insert Widget'),\n                    cmd: 'mceMagentowidget',\n                    image: url + '/img/icon.png',\n\n                    /**\n                     * Fires after the rendering has completed. This ensures the editor will be instantiated\n                     */\n                    onPostRender: function () {\n                        var ctrl = this;\n\n                        // Add a node change handler, selects the button in the UI when a image is selected\n                        editor.on('nodeChange', function (e) {\n                            var placeholder = e.element;\n\n                            if (self.isWidgetPlaceholderSelected(placeholder)) {\n                                widgetTools.setEditMode(true);\n                                ctrl.active(true);\n                            } else {\n                                widgetTools.setEditMode(false);\n                                ctrl.active(false);\n                            }\n                        });\n                    }\n                });\n\n                // Add a widget placeholder image double click callback\n                editor.on('dblClick', function (e) {\n                    var placeholder = e.target;\n\n                    if (self.isWidgetPlaceholderSelected(placeholder)) {\n                        widgetTools.setEditMode(true);\n                        this.execCommand('mceMagentowidget', null);\n                    }\n                });\n\n                /**\n                 * Attach event handler for when wysiwyg editor is about to encode its content\n                 */\n                varienGlobalEvents.attachEventHandler('wysiwygEncodeContent', function (content) {\n                    content = self.encodeWidgets(self.decodeWidgets(content));\n                    content = self.removeDuplicateAncestorWidgetSpanElement(content);\n\n                    return content;\n                });\n\n                /**\n                 * Attach event handler for when wysiwyg editor is about to decode its content\n                 */\n                varienGlobalEvents.attachEventHandler('wysiwygDecodeContent', function (content) {\n                    content = self.decodeWidgets(content);\n\n                    return content;\n                });\n\n                /**\n                 * Attach event handler for when popups associated with wysiwyg are about to be closed\n                 */\n                varienGlobalEvents.attachEventHandler('wysiwygClosePopups', function () {\n                    wysiwyg.closeEditorPopup('widget_window' + wysiwyg.getId());\n                });\n            },\n\n            /**\n             * @param {Object} placeholder - Contains the selected node\n             * @returns {Boolean}\n             */\n            isWidgetPlaceholderSelected: function (placeholder) {\n                var isSelected = false;\n\n                if (placeholder.nodeName &&\n                    (placeholder.nodeName === 'SPAN' || placeholder.nodeName === 'IMG') &&\n                    placeholder.className && placeholder.className.indexOf('magento-widget') !== -1\n                ) {\n                    this.activePlaceholder = placeholder;\n                    isSelected = true;\n                } else {\n                    this.activePlaceholder = null;\n                }\n\n                return isSelected;\n            },\n\n            /**\n             * Convert {{widget}} style syntax to image placeholder HTML\n             * @param {String} content\n             * @return {*}\n             */\n            encodeWidgets: function (content) {\n                return content.gsub(/\\{\\{widget(.*?)\\}\\}/i, function (match) {\n                    var attributes = wysiwyg.parseAttributesString(match[1]),\n                        imageSrc,\n                        imageHtml = '';\n\n                    if (attributes.type) {\n                        attributes.type = attributes.type.replace(/\\\\\\\\/g, '\\\\');\n                        imageSrc = config.placeholders[attributes.type];\n\n                        if (imageSrc) {\n                            imageHtml += '<span class=\"magento-placeholder magento-widget mceNonEditable\" ' +\n                                'contenteditable=\"false\">';\n                        } else {\n                            imageSrc = config['error_image_url'];\n                            imageHtml += '<span ' +\n                                'class=\"magento-placeholder magento-placeholder-error magento-widget mceNonEditable\" ' +\n                                'contenteditable=\"false\">';\n                        }\n\n                        imageHtml += '<img';\n                        imageHtml += ' id=\"' + Base64.idEncode(match[0]) + '\"';\n                        imageHtml += ' src=\"' + imageSrc + '\"';\n                        imageHtml += ' />';\n\n                        if (config.types[attributes.type]) {\n                            imageHtml += config.types[attributes.type];\n                        }\n\n                        imageHtml += '</span>';\n\n                        return imageHtml;\n                    }\n                });\n            },\n\n            /**\n             * Convert image placeholder HTML to {{widget}} style syntax\n             * @param {String} content\n             * @return {*}\n             */\n            decodeWidgets: function (content) {\n                return content.gsub(\n                    /(<span class=\"[^\"]*magento-widget[^\"]*\"[^>]*>)?<img([^>]+id=\"[^>]+)>(([^>]*)<\\/span>)?/i,\n                    function (match) {\n                        var attributes = wysiwyg.parseAttributesString(match[2]),\n                            widgetCode;\n\n                        if (attributes.id) {\n                            widgetCode = Base64.idDecode(attributes.id);\n\n                            if (widgetCode.indexOf('{{widget') !== -1) {\n                                return widgetCode;\n                            }\n                        }\n\n                        return match[0];\n                    }\n                );\n            },\n\n            /**\n             * Tinymce has strange behavior with html and this removes one of its side-effects\n             * @param {String} content\n             * @return {String}\n             */\n            removeDuplicateAncestorWidgetSpanElement: function (content) {\n                var parser, doc;\n\n                if (!window.DOMParser) {\n                    return content;\n                }\n\n                parser = new DOMParser();\n                doc = parser.parseFromString(content.replace(/&quot;/g, '&amp;quot;'), 'text/html');\n\n                [].forEach.call(doc.querySelectorAll('.magento-widget'), function (widgetEl) {\n                    var widgetChildEl = widgetEl.querySelector('.magento-widget');\n\n                    if (!widgetChildEl) {\n                        return;\n                    }\n\n                    [].forEach.call(widgetEl.childNodes, function (el) {\n                        widgetEl.parentNode.insertBefore(el, widgetEl);\n                    });\n\n                    widgetEl.parentNode.removeChild(widgetEl);\n                });\n\n                return doc.body ? doc.body.innerHTML.replace(/&amp;quot;/g, '&quot;') : content;\n            },\n\n            /**\n             * @return {Object}\n             */\n            getInfo: function () {\n                return {\n                    longname: 'Magento Widget Manager Plugin',\n                    author: 'Magento Core Team',\n                    authorurl: 'http://magentocommerce.com',\n                    infourl: 'http://magentocommerce.com',\n                    version: '1.0'\n                };\n            }\n        });\n\n        // Register plugin\n        tinymce.PluginManager.add('magentowidget', tinymce.plugins.magentowidget);\n    };\n});\n","mage/backend/action-link.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.actionLink', {\n        /**\n         * Button creation\n         * @protected\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * Bind handler on button click\n         * @protected\n         */\n        _bind: function () {\n            var keyCode = $.ui.keyCode;\n\n            this._on({\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                mousedown: function (e) {\n                    this._stopPropogation(e);\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                mouseup: function (e) {\n                    this._stopPropogation(e);\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                click: function (e) {\n                    this._stopPropogation(e);\n                    this._triggerEvent();\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                keydown: function (e) {\n                    switch (e.keyCode) {\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            this._stopPropogation(e);\n                            this._triggerEvent();\n                            break;\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                keyup: function (e) {\n                    switch (e.keyCode) {\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            this._stopPropogation(e);\n                            break;\n                    }\n                }\n            });\n        },\n\n        /**\n         * @param {Object} e - event object\n         * @private\n         */\n        _stopPropogation: function (e) {\n            e.stopImmediatePropagation();\n            e.preventDefault();\n        },\n\n        /**\n         * @private\n         */\n        _triggerEvent: function () {\n            $(this.options.related || this.element)\n                .trigger(this.options.event, this.options.eventData ? [this.options.eventData] : [{}]);\n        }\n    });\n\n    return $.mage.actionLink;\n});\n","mage/backend/bootstrap.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY */\ndefine([\n    'jquery',\n    'mage/apply/main',\n    'mage/backend/notification',\n    'Magento_Ui/js/lib/knockout/bootstrap',\n    'mage/mage',\n    'mage/translate'\n], function ($, mage, notification) {\n    'use strict';\n\n    var bootstrap;\n\n    $.ajaxSetup({\n        /*\n         * @type {string}\n         */\n        type: 'POST',\n\n        /**\n         * Ajax before send callback.\n         *\n         * @param {Object} jqXHR - The jQuery XMLHttpRequest object returned by $.ajax()\n         * @param {Object} settings\n         */\n        beforeSend: function (jqXHR, settings) {\n            var formKey = typeof FORM_KEY !== 'undefined' ? FORM_KEY : null;\n\n            if (!settings.url.match(new RegExp('[?&]isAjax=true',''))) {\n                settings.url = settings.url.match(\n                    new RegExp('\\\\?', 'g')) ?\n                    settings.url + '&isAjax=true' :\n                    settings.url + '?isAjax=true';\n            }\n\n            if (!settings.data) {\n                settings.data = {\n                    'form_key': formKey\n                };\n            } else if ($.type(settings.data) === 'string' &&\n                settings.data.indexOf('form_key=') === -1) {\n                settings.data += '&' + $.param({\n                    'form_key': formKey\n                });\n            } else if ($.isPlainObject(settings.data) && !settings.data['form_key']) {\n                settings.data['form_key'] = formKey;\n            }\n        },\n\n        /**\n         * Ajax complete callback.\n         *\n         * @param {Object} jqXHR - The jQuery XMLHttpRequest object returned by $.ajax()\n         */\n        complete: function (jqXHR) {\n            var jsonObject;\n\n            if (jqXHR.readyState === 4) {\n                try {\n                    jsonObject = $.parseJSON(jqXHR.responseText);\n\n                    if (jsonObject.ajaxExpired && jsonObject.ajaxRedirect) { //eslint-disable-line max-depth\n                        window.location.replace(jsonObject.ajaxRedirect);\n                    }\n                } catch (e) {}\n            }\n        },\n\n        /**\n         * Error callback.\n         */\n        error: function () {\n            $('body').notification('clear')\n                .notification('add', {\n                    error: true,\n                    message: $.mage.__(\n                        'A technical problem with the server created an error. ' +\n                        'Try again to continue what you were doing. If the problem persists, try again later.'\n                    ),\n\n                    /**\n                     * @param {String} message\n                     */\n                    insertMethod: function (message) {\n                        var $wrapper = $('<div/>').html(message);\n\n                        $('.page-main-actions').after($wrapper);\n                    }\n                });\n        }\n    });\n\n    /**\n     * Bootstrap application.\n     */\n    bootstrap = function () {\n        /**\n         * Init all components defined via data-mage-init attribute\n         * and subscribe init action on contentUpdated event\n         */\n        mage.apply();\n\n        /*\n         * Initialization of notification widget\n         */\n        notification({}, $('body'));\n    };\n\n    $(bootstrap);\n});\n","mage/backend/editablemultiselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\n/* global EditableMultiselect */\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'jquery/editableMultiselect/js/jquery.editable',\n    'jquery/editableMultiselect/js/jquery.multiselect'\n], function ($, alert, confirm) {\n    /**\n     * Editable multiselect wrapper for multiselects\n     * This class is defined in global scope ('var' is not needed).\n     *\n     *  @param {Object} settings - settings object.\n     *  @param {String} settings.add_button_caption - caption of the 'Add New Value' button\n     *  @param {String} settings.new_url - URL to which new request has to be submitted\n     *  @param {String} settings.save_url - URL to which save request has to be submitted\n     *  @param {String} settings.delete_url - URL to which delete request has to be submitted\n     *  @param {String} settings.delete_confirm_message - confirmation message that is shown to user during\n     *      delete operation\n     *  @param {String} settings.target_select_id - HTML ID of target select element\n     *  @param {Hash} settings.submit_data - extra parameters to send with new/edit/delete requests\n     *  @param {String} settings.entity_value_name - name of the request parameter that represents select option text\n     *  @param {String} settings.entity_id_name - name of the request parameter that represents select option value\n     *  @param {Boolean} settings.is_entry_editable - flag that shows if user can add/edit/remove data\n     *\n     * @constructor\n     */\n    window.EditableMultiselect = function (settings) {\n\n        this.settings = settings || {};\n        this.addButtonCaption = this.settings['add_button_caption'] || 'Add new value';\n        this.newUrl = this.settings['new_url'];\n        this.saveUrl = this.settings['save_url'];\n        this.deleteUrl = this.settings['delete_url'];\n        this.deleteConfirmMessage = this.settings['delete_confirm_message'];\n        this.targetSelectId = this.settings['target_select_id'];\n        this.submitData = this.settings['submit_data'] || {};\n        this.entityIdName = this.settings['entity_id_name'] || 'entity_id';\n        this.entityValueName = this.settings['entity_value_name'] || 'entity_value';\n        this.isEntityEditable = this.settings['is_entity_editable'] || false;\n\n        /**\n         * Initialize editable multiselect (make it visible in UI)\n         */\n        EditableMultiselect.prototype.init = function () {\n            var self = this,\n                mselectOptions = {\n                    addText: this.addButtonCaption,\n\n                    /**\n                     * @param {*} value\n                     * @param {*} options\n                     */\n                    mselectInputSubmitCallback: function (value, options) {\n                        self.createEntity(value, options);\n                    }\n                },\n                mselectList;\n\n            if (!this.isEntityEditable) {\n                // Override default layout of editable multiselect\n                mselectOptions.layout = '<section class=\"block %mselectListClass%\">' +\n                    '<div class=\"block-content\"><div class=\"%mselectItemsWrapperClass%\">' +\n                    '%items%' +\n                    '</div></div>' +\n                    '<div class=\"%mselectInputContainerClass%\">' +\n                    '<input type=\"text\" class=\"%mselectInputClass%\" title=\"%inputTitle%\"/>' +\n                    '<span class=\"%mselectButtonCancelClass%\" title=\"%cancelText%\"></span>' +\n                    '<span class=\"%mselectButtonSaveClass%\" title=\"Add\"></span>' +\n                    '</div>' +\n                    '</section>';\n            }\n\n            $('#' + this.targetSelectId).multiselect(mselectOptions);\n\n            // Make multiselect editable if needed\n            if (this.isEntityEditable) {\n                this.makeMultiselectEditable();\n\n                // Root element of HTML markup that represents select element in UI\n                mselectList = $('#' + this.targetSelectId).next();\n                this.attachEventsToControls(mselectList);\n            }\n        };\n\n        /**\n         * Attach required event handlers to control elements of editable multiselect\n         *\n         * @param {Object} mselectList\n         */\n        EditableMultiselect.prototype.attachEventsToControls = function (mselectList) {\n            mselectList.on('click.mselect-delete', '.mselect-delete', {\n                container: this\n            }, function (event) {\n                // Pass the clicked button to container\n                event.data.container.deleteEntity({\n                    'delete_button': this\n                });\n            });\n\n            mselectList.on('click.mselect-checked', '.mselect-list-item input', {\n                container: this\n            }, function (event) {\n                var el = $(this),\n                    checkedClassName = 'mselect-checked';\n\n                el[el.is(':checked') ? 'addClass' : 'removeClass'](checkedClassName);\n                event.data.container.makeMultiselectEditable();\n            });\n\n            mselectList.on('click.mselect-edit', '.mselect-edit', {\n                container: this\n            }, function (event) {\n                event.data.container.makeMultiselectEditable();\n                $(this).parent().find('label span').trigger('dblclick');\n            });\n        };\n\n        /**\n         * Make multiselect editable\n         */\n        EditableMultiselect.prototype.makeMultiselectEditable = function () {\n            var entityIdName = this.entityIdName,\n                entityValueName = this.entityValueName,\n                selectList = $('#' + this.targetSelectId).next();\n\n            selectList.find('.mselect-list-item:not(.mselect-list-item-not-editable) label span').editable(this.saveUrl,\n            {\n                type: 'text',\n                submit: '<button class=\"mselect-save\" title=\"Save\" type=\"submit\" />',\n                cancel: '<span class=\"mselect-cancel\" title=\"Cancel\"></span>',\n                event: 'dblclick',\n                placeholder: '',\n\n                /**\n                 * Is checked.\n                 */\n                isChecked: function () {\n                    var that = $(this),\n                        checked;\n\n                    if (!that.closest('.mselect-list-item').hasClass('mselect-disabled')) {\n                        checked = that.parent().find('[type=checkbox]').prop('disabled');\n                        that.parent().find('[type=checkbox]').prop({\n                            disabled: !checked\n                        });\n                    }\n                },\n\n                /**\n                 * @param {*} value\n                 * @param {Object} sett\n                 * @return {*}\n                 */\n                data: function (value, sett) {\n                    var retval;\n\n                    sett.isChecked.apply(this, [sett]);\n\n                    if (typeof value === 'string') {\n                        retval = value.unescapeHTML();\n\n                        return retval;\n                    }\n\n                    return value;\n                },\n                submitdata: this.submitData,\n                onblur: 'cancel',\n                name: entityValueName,\n                ajaxoptions: {\n                    dataType: 'json'\n                },\n\n                /**\n                 * @param {Object} sett\n                 * @param {*} original\n                 */\n                onsubmit: function (sett, original) {\n                    var select = $(original).closest('.mselect-list').prev(),\n                        current = $(original).closest('.mselect-list-item').index(),\n                        entityId = select.find('option').eq(current).val(),\n                        entityInfo = {};\n\n                    entityInfo[entityIdName] = entityId;\n                    sett.submitdata = $.extend(sett.submitdata || {}, entityInfo);\n                },\n\n                /**\n                 * @param {Object} result\n                 * @param {Object} sett\n                 */\n                callback: function (result, sett) {\n                    var select, current;\n\n                    sett.isChecked.apply(this, [sett]);\n                    select = $(this).closest('.mselect-list').prev();\n                    current = $(this).closest('.mselect-list-item').index();\n\n                    if (result.success) {\n                        if (typeof result[entityValueName] === 'string') {\n                            select.find('option').eq(current).val(result[entityIdName]).text(result[entityValueName]);\n                            $(this).html(result[entityValueName].escapeHTML());\n                        }\n                    } else {\n                        alert({\n                            content: result['error_message']\n                        });\n                    }\n                }\n            });\n        };\n\n        /**\n         * Callback function that is called when admin adds new value to select\n         *\n         * @param {*} value\n         * @param {Object} options - list of settings of multiselect\n         */\n        EditableMultiselect.prototype.createEntity = function (value, options) {\n            var select, entityIdName, entityValueName, entityInfo, postData, ajaxOptions;\n\n            if (!value) {\n                return;\n            }\n\n            select = $('#' + this.targetSelectId),\n            entityIdName = this.entityIdName,\n            entityValueName = this.entityValueName,\n            entityInfo = {};\n            entityInfo[entityIdName] = null;\n            entityInfo[entityValueName] = value;\n\n            postData = $.extend(entityInfo, this.submitData);\n\n            ajaxOptions = {\n                type: 'POST',\n                data: postData,\n                dataType: 'json',\n                url: this.newUrl,\n\n                /**\n                 * @param {Object} result\n                 */\n                success: function (result) {\n                    var resultEntityValueName, mselectItemHtml, sectionBlock, itemsWrapper, inputSelector;\n\n                    if (result.success) {\n                        resultEntityValueName = '';\n\n                        if (typeof result[entityValueName] === 'string') {\n                            resultEntityValueName = result[entityValueName].escapeHTML();\n                        } else {\n                            resultEntityValueName = result[entityValueName];\n                        }\n                        // Add item to initial select element\n                        select.append('<option value=\"' + result[entityIdName] + '\" selected=\"selected\">' +\n                        resultEntityValueName + '</option>');\n                        // Add editable multiselect item\n                        mselectItemHtml = $(options.item.replace(/%value%|%label%/gi, resultEntityValueName)\n                                .replace(/%mselectDisabledClass%|%iseditable%|%isremovable%/gi, '')\n                                .replace(/%mselectListItemClass%/gi, options.mselectListItemClass))\n                                .find('[type=checkbox]')\n                                .attr('checked', true)\n                                .addClass(options.mselectCheckedClass)\n                                .end();\n                        sectionBlock = select.nextAll('section.block:first');\n                        itemsWrapper = sectionBlock.find('.' + options.mselectItemsWrapperClass + '');\n\n                        if (itemsWrapper.children('.' + options.mselectListItemClass + '').length) {\n                            itemsWrapper.children('.' + options.mselectListItemClass + ':last').after(mselectItemHtml);\n                        } else {\n                            itemsWrapper.prepend(mselectItemHtml);\n                        }\n                        // Trigger blur event on input field, that is used to add new value, to hide it\n                        inputSelector = '.' + options.mselectInputContainerClass + ' [type=text].' +\n                            options.mselectInputClass + '';\n                        sectionBlock.find(inputSelector).trigger('blur');\n                    } else {\n                        alert({\n                            content: result['error_message']\n                        });\n                    }\n                }\n            };\n            $.ajax(ajaxOptions);\n        };\n\n        /**\n         * Callback function that is called when user tries to delete value from select\n         *\n         * @param {Object} options\n         */\n        EditableMultiselect.prototype.deleteEntity = function (options) {\n            var self = this;\n\n            if (options['delete_button']) {\n                confirm({\n                    content: this.deleteConfirmMessage,\n                    actions: {\n                        /**\n                         * Confirm.\n                         */\n                        confirm: function () {\n                            // Button that has been clicked\n                            var deleteButton = $(options['delete_button']),\n                                index = deleteButton.parent().index(),\n                                select = deleteButton.closest('.mselect-list').prev(),\n                                entityId = select.find('option').eq(index).val(),\n                                entityInfo = {},\n                                postData, ajaxOptions;\n\n                            entityInfo[self.entityIdName] = entityId;\n                            postData = $.extend(entityInfo, self.submitData);\n\n                            ajaxOptions = {\n                                type: 'POST',\n                                data: postData,\n                                dataType: 'json',\n                                url: self.deleteUrl,\n\n                                /**\n                                 * @param {Object} result\n                                 */\n                                success: function (result) {\n                                    if (result.success) {\n                                        deleteButton.parent().remove();\n                                        select.find('option').eq(index).remove();\n                                    } else {\n                                        alert({\n                                            content: result['error_message']\n                                        });\n                                    }\n                                }\n                            };\n                            $.ajax(ajaxOptions);\n                        }\n                    }\n                });\n            }\n        };\n    };\n});\n","mage/backend/tree-suggest.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'jquery/ui',\n            'jquery/jstree/jquery.jstree',\n            'mage/backend/suggest'\n        ], factory);\n    } else {\n        factory(root.jQuery);\n    }\n}(this, function ($) {\n    'use strict';\n\n    /* jscs:disable requireCamelCaseOrUpperCaseIdentifiers */\n    var hover_node, dehover_node, select_node, init;\n\n    $.extend(true, $, {\n        // @TODO: Move method 'treeToList' in file with utility functions\n        mage: {\n            /**\n             * @param {Array} list\n             * @param {Object} nodes\n             * @param {*} level\n             * @param {*} path\n             * @return {*}\n             */\n            treeToList: function (list, nodes, level, path) {\n                $.each(nodes, function () {\n                    if ($.type(this) === 'object') {\n                        list.push({\n                            label: this.label,\n                            id: this.id,\n                            level: level,\n                            item: this,\n                            path: path + this.label\n                        });\n\n                        if (this.children) {\n                            $.mage.treeToList(list, this.children, level + 1, path + this.label + ' / ');\n                        }\n                    }\n                });\n\n                return list;\n            }\n        }\n    });\n\n    hover_node = $.jstree._instance.prototype.hover_node;\n    dehover_node = $.jstree._instance.prototype.dehover_node;\n    select_node = $.jstree._instance.prototype.select_node;\n    init = $.jstree._instance.prototype.init;\n\n    $.extend(true, $.jstree._instance.prototype, {\n        /**\n         * @override\n         */\n        init: function () {\n            this.get_container()\n                .show()\n                .on('keydown', $.proxy(function (e) {\n                    var o;\n\n                    if (e.keyCode === $.ui.keyCode.ENTER) {\n                        o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n                        this.select_node(o, true);\n                    }\n                }, this));\n            init.call(this);\n        },\n\n        /**\n         * @override\n         */\n        hover_node: function (obj) {\n            hover_node.apply(this, arguments);\n            obj = this._get_node(obj);\n\n            if (!obj.length) {\n                return false;\n            }\n            this.get_container().trigger('hover_node', [{\n                item: obj.find('a:first')\n            }]);\n        },\n\n        /**\n         * @override\n         */\n        dehover_node: function () {\n            dehover_node.call(this);\n            this.get_container().trigger('dehover_node');\n        },\n\n        /**\n         * @override\n         */\n        select_node: function (o) {\n            var node;\n\n            select_node.apply(this, arguments);\n            node = this._get_node(o);\n\n            (node ? $(node) : this.data.ui.last_selected)\n                .trigger('select_tree_node');\n        }\n    });\n\n    $.widget('mage.treeSuggest', $.mage.suggest, {\n        widgetEventPrefix: 'suggest',\n        options: {\n            template:\n                '<% if (data.items.length) { %>' +\n                    '<% if (data.allShown()) { %>' +\n                        '<% if (typeof data.nested === \"undefined\") { %>' +\n                            '<div style=\"display:none;\" data-mage-init=\"{&quot;jstree&quot;:{&quot;plugins&quot;:[&quot;themes&quot;,&quot;html_data&quot;,&quot;ui&quot;,&quot;hotkeys&quot;],&quot;themes&quot;:{&quot;theme&quot;:&quot;default&quot;,&quot;dots&quot;:false,&quot;icons&quot;:false}}}\">' + //eslint-disable-line max-len\n                        '<% } %>' +\n                        '<ul>' +\n                            '<% _.each(data.items, function(value) { %>' +\n                                '<li class=\"<% if (data.itemSelected(value)) { %>mage-suggest-selected<% } %>' +\n                '                   <% if (value.is_active == 0) { %> mage-suggest-not-active<% } %>\">' +\n                                    '<a href=\"#\" <%= data.optionData(value) %>><%- value.label %></a>' +\n                                    '<% if (value.children && value.children.length) { %>' +\n                                        '<%= data.renderTreeLevel(value.children) %>' +\n                                    '<% } %>' +\n                                '</li>' +\n                            '<% }); %>' +\n                        '</ul>' +\n                        '<% if (typeof data.nested === \"undefined\") { %>' +\n                            '</div>' +\n                        '<% } %>' +\n                    '<% } else { %>' +\n                        '<ul data-mage-init=\"{&quot;menu&quot;:[]}\">' +\n                            '<% _.each(data.items, function(value) { %>' +\n                                '<% if (!data.itemSelected(value)) {%>' +\n                                    '<li <%= data.optionData(value) %>>' +\n                                        '<a href=\"#\">' +\n                                            '<span class=\"category-label\"><%- value.label %></span>' +\n                                            '<span class=\"category-path\"><%- value.path %></span>' +\n                                        '</a>' +\n                                    '</li>' +\n                                '<% } %>' +\n                            '<% }); %>' +\n                        '</ul>' +\n                    '<% } %>' +\n                '<% } else { %>' +\n                    '<span class=\"mage-suggest-no-records\"><%- data.noRecordsText %></span>' +\n                '<% } %>',\n            controls: {\n                selector: ':ui-menu, :mage-menu, .jstree',\n                eventsMap: {\n                    focus: ['menufocus', 'hover_node'],\n                    blur: ['menublur', 'dehover_node'],\n                    select: ['menuselect', 'select_tree_node']\n                }\n            }\n        },\n\n        /**\n         * @override\n         */\n        _bind: function () {\n            this._super();\n            this._on({\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                keydown: function (event) {\n                    var keyCode = $.ui.keyCode;\n\n                    switch (event.keyCode) {\n                        case keyCode.LEFT:\n                        case keyCode.RIGHT:\n\n                            if (this.isDropdownShown()) {\n                                event.preventDefault();\n                                this._proxyEvents(event);\n                            }\n                            break;\n                    }\n                }\n            });\n        },\n\n        /**\n         * @override\n         */\n        close: function (e) {\n            var eType = e ? e.type : null;\n\n            if (eType === 'select_tree_node') {\n                this.element.focus();\n            } else {\n                this._superApply(arguments);\n            }\n        },\n\n        /**\n         * @override\n         */\n        _filterSelected: function (items, context) {\n            if (context._allShown) {\n                return items;\n            }\n\n            return this._superApply(arguments);\n        },\n\n        /**\n         * @override\n         */\n        _prepareDropdownContext: function () {\n            var context = this._superApply(arguments),\n                optionData = context.optionData,\n                templates = this.templates,\n                tmplName = this.templateName;\n\n            /**\n             * @param {Object} item\n             * @return {*|String}\n             */\n            context.optionData = function (item) {\n                item = $.extend({}, item);\n                delete item.children;\n\n                return optionData(item);\n            };\n\n            return $.extend(context, {\n                /**\n                 * @param {*} children\n                 * @return {*|jQuery}\n                 */\n                renderTreeLevel: function (children) {\n                    var _context = $.extend({}, this, {\n                        items: children,\n                        nested: true\n                    }),\n                    tmpl = templates[tmplName];\n\n                    tmpl = tmpl({\n                        data: _context\n                    });\n\n                    return $('<div>').append($(tmpl)).html();\n                }\n            });\n        },\n\n        /**\n         * @override\n         */\n        _processResponse: function (e, items, context) {\n            var control;\n\n            if (context && !context._allShown) {\n                items = this.filter($.mage.treeToList([], items, 0, ''), this._term);\n            }\n            control = this.dropdown.find(this._control.selector);\n\n            if (control.length && control.hasClass('jstree')) {\n                control.jstree('destroy');\n            }\n            this._superApply([e, items, context]);\n        }\n    });\n\n    return $.mage.treeSuggest;\n}));\n","mage/backend/menu.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function (factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'jquery/ui'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    $.widget('mage.menu', {\n        widgetEventPrefix: 'menu',\n        version: '1.10.1',\n        defaultElement: '<ul>',\n        delay: 300,\n        options: {\n            icons: {\n                submenu: 'ui-icon-carat-1-e'\n            },\n            menus: 'ul',\n            position: {\n                my: 'left top',\n                at: 'right top'\n            },\n            role: 'menu',\n\n            // callbacks\n            blur: null,\n            focus: null,\n            select: null\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this.activeMenu = this.element;\n            // flag used to prevent firing of the click handler\n            // as the event bubbles up through nested menus\n            this.mouseHandled = false;\n            this.element\n                .uniqueId()\n                .addClass('ui-menu ui-widget ui-widget-content ui-corner-all')\n                .toggleClass('ui-menu-icons', !!this.element.find('.ui-icon').length)\n                .attr({\n                    role: this.options.role,\n                    tabIndex: 0\n                })\n                // need to catch all clicks on disabled menu\n                // not possible through _on\n                .bind('click' + this.eventNamespace, $.proxy(function (event) {\n                    if (this.options.disabled) {\n                        event.preventDefault();\n                    }\n                }, this));\n\n            if (this.options.disabled) {\n                this.element\n                    .addClass('ui-state-disabled')\n                    .attr('aria-disabled', 'true');\n            }\n\n            this._on({\n                /**\n                 * Prevent focus from sticking to links inside menu after clicking\n                 * them (focus should always stay on UL during navigation).\n                 */\n                'mousedown .ui-menu-item > a': function (event) {\n                    event.preventDefault();\n                },\n\n                /**\n                 * Prevent focus from sticking to links inside menu after clicking\n                 * them (focus should always stay on UL during navigation).\n                 */\n                'click .ui-state-disabled > a': function (event) {\n                    event.preventDefault();\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'click .ui-menu-item:has(a)': function (event) {\n                    var target = $(event.target).closest('.ui-menu-item');\n\n                    if (!this.mouseHandled && target.not('.ui-state-disabled').length) {\n                        this.mouseHandled = true;\n\n                        this.select(event);\n                        // Open submenu on click\n                        if (target.has('.ui-menu').length) {\n                            this.expand(event);\n                        } else if (!this.element.is(':focus')) {\n                            // Redirect focus to the menu\n                            this.element.trigger('focus', [true]);\n\n                            // If the active item is on the top level, let it stay active.\n                            // Otherwise, blur the active item since it is no longer visible.\n                            if (this.active && this.active.parents('.ui-menu').length === 1) { //eslint-disable-line\n                                clearTimeout(this.timer);\n                            }\n                        }\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'mouseenter .ui-menu-item': function (event) {\n                    var target = $(event.currentTarget);\n\n                    // Remove ui-state-active class from siblings of the newly focused menu item\n                    // to avoid a jump caused by adjacent elements both having a class with a border\n                    target.siblings().children('.ui-state-active').removeClass('ui-state-active');\n                    this.focus(event, target);\n                },\n                mouseleave: 'collapseAll',\n                'mouseleave .ui-menu': 'collapseAll',\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {*} keepActiveItem\n                 */\n                focus: function (event, keepActiveItem) {\n                    // If there's already an active item, keep it active\n                    // If not, activate the first item\n                    var item = this.active || this.element.children('.ui-menu-item').eq(0);\n\n                    if (!keepActiveItem) {\n                        this.focus(event, item);\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                blur: function (event) {\n                    this._delay(function () {\n                        if (!$.contains(this.element[0], this.document[0].activeElement)) {\n                            this.collapseAll(event);\n                        }\n                    });\n                },\n                keydown: '_keydown'\n            });\n\n            this.refresh();\n\n            // Clicks outside of a menu collapse any open menus\n            this._on(this.document, {\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                click: function (event) {\n                    if (!$(event.target).closest('.ui-menu').length) {\n                        this.collapseAll(event);\n                    }\n\n                    // Reset the mouseHandled flag\n                    this.mouseHandled = false;\n                }\n            });\n        },\n\n        /**\n         * @private\n         */\n        _destroy: function () {\n            // Destroy (sub)menus\n            this.element\n                .removeAttr('aria-activedescendant')\n                .find('.ui-menu').addBack()\n                .removeClass('ui-menu ui-widget ui-widget-content ui-corner-all ui-menu-icons')\n                .removeAttr('role')\n                .removeAttr('tabIndex')\n                .removeAttr('aria-labelledby')\n                .removeAttr('aria-expanded')\n                .removeAttr('aria-hidden')\n                .removeAttr('aria-disabled')\n                .removeUniqueId()\n                .show();\n\n            // Destroy menu items\n            this.element.find('.ui-menu-item')\n                .removeClass('ui-menu-item')\n                .removeAttr('role')\n                .removeAttr('aria-disabled')\n                .children('a')\n                .removeUniqueId()\n                .removeClass('ui-corner-all ui-state-hover')\n                .removeAttr('tabIndex')\n                .removeAttr('role')\n                .removeAttr('aria-haspopup')\n                .children().each(function () {\n                    var elem = $(this);\n\n                    if (elem.data('ui-menu-submenu-carat')) {\n                        elem.remove();\n                    }\n                });\n\n            // Destroy menu dividers\n            this.element.find('.ui-menu-divider').removeClass('ui-menu-divider ui-widget-content');\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _keydown: function (event) {\n            var match, prev, character, skip, regex,\n                preventDefault = true;\n\n            /**\n             * @param {String} value\n             */\n            function escape(value) {\n                return value.replace(/[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, '\\\\$&');\n            }\n\n            switch (event.keyCode) {\n                case $.ui.keyCode.PAGE_UP:\n                    this.previousPage(event);\n                    break;\n\n                case $.ui.keyCode.PAGE_DOWN:\n                    this.nextPage(event);\n                    break;\n\n                case $.ui.keyCode.HOME:\n                    this._move('first', 'first', event);\n                    break;\n\n                case $.ui.keyCode.END:\n                    this._move('last', 'last', event);\n                    break;\n\n                case $.ui.keyCode.UP:\n                    this.previous(event);\n                    break;\n\n                case $.ui.keyCode.DOWN:\n                    this.next(event);\n                    break;\n\n                case $.ui.keyCode.LEFT:\n                    this.collapse(event);\n                    break;\n\n                case $.ui.keyCode.RIGHT:\n                    if (this.active && !this.active.is('.ui-state-disabled')) {\n                        this.expand(event);\n                    }\n                    break;\n\n                case $.ui.keyCode.ENTER:\n                case $.ui.keyCode.SPACE:\n                    this._activate(event);\n                    break;\n\n                case $.ui.keyCode.ESCAPE:\n                    this.collapse(event);\n                    break;\n\n                default:\n                    preventDefault = false;\n                    prev = this.previousFilter || '';\n                    character = String.fromCharCode(event.keyCode);\n                    skip = false;\n\n                    clearTimeout(this.filterTimer);\n\n                    if (character === prev) {\n                        skip = true;\n                    } else {\n                        character = prev + character;\n                    }\n\n                    regex = new RegExp('^' + escape(character), 'i');\n                    match = this.activeMenu.children('.ui-menu-item').filter(function () {\n                        return regex.test($(this).children('a').text());\n                    });\n                    match = skip && match.index(this.active.next()) !== -1 ?\n                        this.active.nextAll('.ui-menu-item') :\n                        match;\n\n                    // If no matches on the current filter, reset to the last character pressed\n                    // to move down the menu to the first item that starts with that character\n                    if (!match.length) {\n                        character = String.fromCharCode(event.keyCode);\n                        regex = new RegExp('^' + escape(character), 'i');\n                        match = this.activeMenu.children('.ui-menu-item').filter(function () {\n                            return regex.test($(this).children('a').text());\n                        });\n                    }\n\n                    if (match.length) {\n                        this.focus(event, match);\n\n                        if (match.length > 1) { //eslint-disable-line max-depth\n                            this.previousFilter = character;\n                            this.filterTimer = this._delay(function () {\n                                delete this.previousFilter;\n                            }, 1000);\n                        } else {\n                            delete this.previousFilter;\n                        }\n                    } else {\n                        delete this.previousFilter;\n                    }\n            }\n\n            if (preventDefault) {\n                event.preventDefault();\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _activate: function (event) {\n            if (!this.active.is('.ui-state-disabled')) {\n                if (this.active.children('a[aria-haspopup=\"true\"]').length) {\n                    this.expand(event);\n                } else {\n                    this.select(event);\n                }\n            }\n        },\n\n        /**\n         * Refresh.\n         */\n        refresh: function () {\n            var menus,\n                icon = this.options.icons.submenu,\n                submenus = this.element.find(this.options.menus);\n\n            // Initialize nested menus\n            submenus.filter(':not(.ui-menu)')\n                .addClass('ui-menu ui-widget ui-widget-content ui-corner-all')\n                .hide()\n                .attr({\n                    role: this.options.role,\n                    'aria-hidden': 'true',\n                    'aria-expanded': 'false'\n                })\n                .each(function () {\n                    var menu = $(this),\n                        item = menu.prev('a'),\n                        submenuCarat = $('<span>')\n                            .addClass('ui-menu-icon ui-icon ' + icon)\n                            .data('ui-menu-submenu-carat', true);\n\n                    item\n                        .attr('aria-haspopup', 'true')\n                        .prepend(submenuCarat);\n                    menu.attr('aria-labelledby', item.attr('id'));\n                });\n\n            menus = submenus.add(this.element);\n\n            // Don't refresh list items that are already adapted\n            menus.children(':not(.ui-menu-item):has(a)')\n                .addClass('ui-menu-item')\n                .attr('role', 'presentation')\n                .children('a')\n                .uniqueId()\n                .addClass('ui-corner-all')\n                .attr({\n                    tabIndex: -1,\n                    role: this._itemRole()\n                });\n\n            // Initialize unlinked menu-items containing spaces and/or dashes only as dividers\n            menus.children(':not(.ui-menu-item)').each(function () {\n                var item = $(this);\n\n                // hyphen, em dash, en dash\n                if (!/[^\\-\\u2014\\u2013\\s]/.test(item.text())) {\n                    item.addClass('ui-widget-content ui-menu-divider');\n                }\n            });\n\n            // Add aria-disabled attribute to any disabled menu item\n            menus.children('.ui-state-disabled').attr('aria-disabled', 'true');\n\n            // If the active item has been removed, blur the menu\n            if (this.active && !$.contains(this.element[0], this.active[0])) {\n                this.blur();\n            }\n        },\n\n        /**\n         * @return {*}\n         * @private\n         */\n        _itemRole: function () {\n            return {\n                menu: 'menuitem',\n                listbox: 'option'\n            }[this.options.role];\n        },\n\n        /**\n         * @param {String} key\n         * @param {*} value\n         * @private\n         */\n        _setOption: function (key, value) {\n            if (key === 'icons') {\n                this.element.find('.ui-menu-icon')\n                    .removeClass(this.options.icons.submenu)\n                    .addClass(value.submenu);\n            }\n            this._super(key, value);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} item\n         */\n        focus: function (event, item) {\n            var nested, focused;\n\n            this.blur(event, event && event.type === 'focus');\n\n            this._scrollIntoView(item);\n\n            this.active = item.first();\n            focused = this.active.children('a').addClass('ui-state-focus');\n            // Only update aria-activedescendant if there's a role\n            // otherwise we assume focus is managed elsewhere\n            if (this.options.role) {\n                this.element.attr('aria-activedescendant', focused.attr('id'));\n            }\n\n            // Highlight active parent menu item, if any\n            this.active\n                .parent()\n                .closest('.ui-menu-item')\n                .children('a:first')\n                .addClass('ui-state-active');\n\n            if (event && event.type === 'keydown') {\n                this._close();\n            } else {\n                this.timer = this._delay(function () {\n                    this._close();\n                }, this.delay);\n            }\n\n            nested = item.children('.ui-menu');\n\n            if (nested.length && /^mouse/.test(event.type)) {\n                this._startOpening(nested);\n            }\n            this.activeMenu = item.parent();\n\n            this._trigger('focus', event, {\n                item: item\n            });\n        },\n\n        /**\n         * @param {Object} item\n         * @private\n         */\n        _scrollIntoView: function (item) {\n            var borderTop, paddingTop, offset, scroll, elementHeight, itemHeight;\n\n            if (this._hasScroll()) {\n                borderTop = parseFloat($.css(this.activeMenu[0], 'borderTopWidth')) || 0;\n                paddingTop = parseFloat($.css(this.activeMenu[0], 'paddingTop')) || 0;\n                offset = item.offset().top - this.activeMenu.offset().top - borderTop - paddingTop;\n                scroll = this.activeMenu.scrollTop();\n                elementHeight = this.activeMenu.height();\n                itemHeight = item.height();\n\n                if (offset < 0) {\n                    this.activeMenu.scrollTop(scroll + offset);\n                } else if (offset + itemHeight > elementHeight) {\n                    this.activeMenu.scrollTop(scroll + offset - elementHeight + itemHeight);\n                }\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {*} fromFocus\n         */\n        blur: function (event, fromFocus) {\n            if (!fromFocus) {\n                clearTimeout(this.timer);\n            }\n\n            if (!this.active) {\n                return;\n            }\n\n            this.active.children('a').removeClass('ui-state-focus');\n            this.active = null;\n\n            this._trigger('blur', event, {\n                item: this.active\n            });\n        },\n\n        /**\n         * @param {*} submenu\n         * @private\n         */\n        _startOpening: function (submenu) {\n            clearTimeout(this.timer);\n\n            // Don't open if already open fixes a Firefox bug that caused a .5 pixel\n            // shift in the submenu position when mousing over the carat icon\n            if (submenu.attr('aria-hidden') !== 'true') {\n                return;\n            }\n\n            this.timer = this._delay(function () {\n                this._close();\n                this._open(submenu);\n            }, this.delay);\n        },\n\n        /**\n         * @param {*} submenu\n         * @private\n         */\n        _open: function (submenu) {\n            var position = $.extend({\n                of: this.active\n            }, this.options.position);\n\n            clearTimeout(this.timer);\n            this.element.find('.ui-menu').not(submenu.parents('.ui-menu'))\n                .hide()\n                .attr('aria-hidden', 'true');\n\n            submenu\n                .show()\n                .removeAttr('aria-hidden')\n                .attr('aria-expanded', 'true')\n                .position(position);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {*} all\n         */\n        collapseAll: function (event, all) {\n            clearTimeout(this.timer);\n            this.timer = this._delay(function () {\n                // If we were passed an event, look for the submenu that contains the event\n                var currentMenu = all ? this.element :\n                    $(event && event.target).closest(this.element.find('.ui-menu'));\n\n                // If we found no valid submenu ancestor, use the main menu to close all sub menus anyway\n                if (!currentMenu.length) {\n                    currentMenu = this.element;\n                }\n\n                this._close(currentMenu);\n\n                this.blur(event);\n                this.activeMenu = currentMenu;\n            }, this.delay);\n        },\n\n        // With no arguments, closes the currently active menu - if nothing is active\n        // it closes all menus.  If passed an argument, it will search for menus BELOW\n        /**\n         * With no arguments, closes the currently active menu - if nothing is active\n         * it closes all menus.  If passed an argument, it will search for menus BELOW.\n         *\n         * @param {*} startMenu\n         * @private\n         */\n        _close: function (startMenu) {\n            if (!startMenu) {\n                startMenu = this.active ? this.active.parent() : this.element;\n            }\n\n            startMenu\n                .find('.ui-menu')\n                .hide()\n                .attr('aria-hidden', 'true')\n                .attr('aria-expanded', 'false')\n                .end()\n                .find('a.ui-state-active')\n                .removeClass('ui-state-active');\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        collapse: function (event) {\n            var newItem = this.active &&\n                this.active.parent().closest('.ui-menu-item', this.element);\n\n            if (newItem && newItem.length) {\n                this._close();\n                this.focus(event, newItem);\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        expand: function (event) {\n            var newItem = this.active &&\n                this.active\n                    .children('.ui-menu ')\n                    .children('.ui-menu-item')\n                    .first();\n\n            if (newItem && newItem.length) {\n                this._open(newItem.parent());\n\n                // Delay so Firefox will not hide activedescendant change in expanding submenu from AT\n                this._delay(function () {\n                    this.focus(event, newItem);\n                });\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        next: function (event) {\n            this._move('next', 'first', event);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        previous: function (event) {\n            this._move('prev', 'last', event);\n        },\n\n        /**\n         * @return {null|Boolean}\n         */\n        isFirstItem: function () {\n            return this.active && !this.active.prevAll('.ui-menu-item').length;\n        },\n\n        /**\n         * @return {null|Boolean}\n         */\n        isLastItem: function () {\n            return this.active && !this.active.nextAll('.ui-menu-item').length;\n        },\n\n        /**\n         * @param {*} direction\n         * @param {*} filter\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _move: function (direction, filter, event) {\n            var next;\n\n            if (this.active) {\n                if (direction === 'first' || direction === 'last') {\n                    next = this.active\n                        [direction === 'first' ? 'prevAll' : 'nextAll']('.ui-menu-item')\n                        .eq(-1);\n                } else {\n                    next = this.active\n                        [direction + 'All']('.ui-menu-item')\n                        .eq(0);\n                }\n            }\n\n            if (!next || !next.length || !this.active) {\n                next = this.activeMenu.children('.ui-menu-item')[filter]();\n            }\n\n            this.focus(event, next);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        nextPage: function (event) {\n            var item, base, height;\n\n            if (!this.active) {\n                this.next(event);\n\n                return;\n            }\n\n            if (this.isLastItem()) {\n                return;\n            }\n\n            if (this._hasScroll()) {\n                base = this.active.offset().top;\n                height = this.element.height();\n                this.active.nextAll('.ui-menu-item').each(function () {\n                    item = $(this);\n\n                    return item.offset().top - base - height < 0;\n                });\n\n                this.focus(event, item);\n            } else {\n                this.focus(event, this.activeMenu.children('.ui-menu-item')\n                    [!this.active ? 'first' : 'last']());\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        previousPage: function (event) {\n            var item, base, height;\n\n            if (!this.active) {\n                this.next(event);\n\n                return;\n            }\n\n            if (this.isFirstItem()) {\n                return;\n            }\n\n            if (this._hasScroll()) {\n                base = this.active.offset().top;\n                height = this.element.height();\n                this.active.prevAll('.ui-menu-item').each(function () {\n                    item = $(this);\n\n                    return item.offset().top - base + height > 0;\n                });\n\n                this.focus(event, item);\n            } else {\n                this.focus(event, this.activeMenu.children('.ui-menu-item').first());\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         * @private\n         */\n        _hasScroll: function () {\n            return this.element.outerHeight() < this.element.prop('scrollHeight');\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        select: function (event) {\n            // TODO: It should never be possible to not have an active item at this\n            // point, but the tests don't trigger mouseenter before click.\n            var ui;\n\n            this.active = this.active || $(event.target).closest('.ui-menu-item');\n            ui = {\n                item: this.active\n            };\n\n            if (!this.active.has('.ui-menu').length) {\n                this.collapseAll(event, true);\n            }\n            this._trigger('select', event, ui);\n        }\n    });\n\n    return $.mage.menu;\n}));\n","mage/backend/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n(function (factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'jquery/ui'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    $.widget('mage.form', {\n        options: {\n            handlersData: {\n                save: {},\n                saveAndContinueEdit: {\n                    action: {\n                        args: {\n                            back: 'edit'\n                        }\n                    }\n                },\n                preview: {\n                    target: '_blank'\n                }\n            }\n        },\n\n        /**\n         * Form creation\n         * @protected\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * Set form attributes to initial state\n         * @protected\n         */\n        _rollback: function () {\n            if (this.oldAttributes) {\n                this.element.prop(this.oldAttributes);\n            }\n        },\n\n        /**\n         * Check if field value is changed\n         * @protected\n         * @param {Object} e - event object\n         */\n        _changesObserver: function (e) {\n            var target = $(e.target),\n                changed;\n\n            if (e.type === 'focus' || e.type === 'focusin') {\n                this.currentField = {\n                    statuses: {\n                        checked: target.is(':checked'),\n                        selected: target.is(':selected')\n                    },\n                    val: target.val()\n                };\n\n            } else {\n                if (this.currentField) { //eslint-disable-line no-lonely-if\n                    changed = target.val() !== this.currentField.val ||\n                        target.is(':checked') !== this.currentField.statuses.checked ||\n                        target.is(':selected') !== this.currentField.statuses.selected;\n\n                    if (changed) { //eslint-disable-line max-depth\n                        target.trigger('changed');\n                    }\n                }\n            }\n        },\n\n        /**\n         * Get array with handler names\n         * @protected\n         * @return {Array} Array of handler names\n         */\n        _getHandlers: function () {\n            var handlers = [];\n\n            $.each(this.options.handlersData, function (key) {\n                handlers.push(key);\n            });\n\n            return handlers;\n        },\n\n        /**\n         * Store initial value of form attribute\n         * @param {String} attrName - name of attribute\n         * @protected\n         */\n        _storeAttribute: function (attrName) {\n            var prop;\n\n            this.oldAttributes = this.oldAttributes || {};\n\n            if (!this.oldAttributes[attrName]) {\n                prop = this.element.attr(attrName);\n                this.oldAttributes[attrName] = prop ? prop : '';\n            }\n        },\n\n        /**\n         * Bind handlers\n         * @protected\n         */\n        _bind: function () {\n            this.element\n                .on(this._getHandlers().join(' '), $.proxy(this._submit, this))\n                .on('focus blur focusin focusout', $.proxy(this._changesObserver, this));\n        },\n\n        /**\n         * Get action url for form\n         * @param {Object|String} data - object with parameters for action url or url string\n         * @return {String} action url\n         */\n        _getActionUrl: function (data) {\n            if ($.type(data) === 'object') {\n                return this._buildURL(this.oldAttributes.action, data.args);\n            }\n\n            return $.type(data) === 'string' ? data : this.oldAttributes.action;\n        },\n\n        /**\n         * Add additional parameters into URL\n         * @param {String} url - original url\n         * @param {Object} params - object with parameters for action url\n         * @return {String} action url\n         * @private\n         */\n        _buildURL: function (url, params) {\n            var concat = /\\?/.test(url) ? ['&', '='] : ['/', '/'];\n\n            url = url.replace(/[\\/&]+$/, '');\n            $.each(params, function (key, value) {\n                url += concat[0] + key + concat[1] + window.encodeURIComponent(value);\n            });\n\n            return url + (concat[0] === '/' ? '/' : '');\n        },\n\n        /**\n         * Prepare data for form attributes\n         * @protected\n         * @param {Object} data\n         * @return {Object}\n         */\n        _processData: function (data) {\n            $.each(data, $.proxy(function (attrName, attrValue) {\n                this._storeAttribute(attrName);\n\n                if (attrName === 'action') {\n                    data[attrName] = this._getActionUrl(attrValue);\n                }\n            }, this));\n\n            return data;\n        },\n\n        /**\n         * Get additional data before form submit\n         * @protected\n         * @param {String} handlerName\n         * @param {Object} data\n         */\n        _beforeSubmit: function (handlerName, data) {\n            var submitData = {},\n                event = new $.Event('beforeSubmit');\n\n            this.element.trigger(event, [submitData, handlerName]);\n            data = $.extend(\n                true, {},\n                this.options.handlersData[handlerName] || {},\n                submitData,\n                data\n            );\n            this.element.prop(this._processData(data));\n\n            return !event.isDefaultPrevented();\n        },\n\n        /**\n         * Submit the form\n         * @param {Object} e - event object\n         * @param {Object} data - event data object\n         */\n        _submit: function (e, data) {\n            this._rollback();\n\n            if (this._beforeSubmit(e.type, data) !== false) {\n                this.element.trigger('submit', e);\n            }\n        }\n    });\n\n    return $.mage.form;\n}));\n","mage/backend/floating-header.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.floatingHeader', {\n        options: {\n            placeholderAttrs: {\n                'class': 'page-actions-placeholder'\n            },\n            fixedClass: '_fixed',\n            hiddenClass: '_hidden',\n            title: '.page-title-wrapper .page-title',\n            pageMainActions: '.page-main-actions',\n            contains: '[data-role=modal]'\n        },\n\n        /**\n         * Widget initialization\n         * @private\n         */\n        _create: function () {\n            var title = $(this.options.title).text(),\n                wrapped = this.element.find('.page-actions-buttons').children();\n\n            if (this.element.parents(this.options.contains).length) {\n                return this;\n            }\n\n            this._setVars();\n            this._bind();\n            this.element.find('script').remove();\n\n            if (wrapped.length) {\n                wrapped\n                    .unwrap()   // .page-actions-buttons\n                    .unwrap();  // .page-actions-inner\n            }\n            this.element.wrapInner($('<div/>', {\n                'class': 'page-actions-buttons'\n            }));\n            this.element.wrapInner($('<div/>', {\n                'class': 'page-actions-inner', 'data-title': title\n            }));\n            this.element.removeClass('floating-header');\n        },\n\n        /**\n         * Set privat variables on load, for performance purposes\n         * @private\n         */\n        _setVars: function () {\n            this._placeholder = this.element.before($('<div/>', this.options.placeholderAttrs)).prev();\n            this._offsetTop = this._placeholder.offset().top;\n            this._height = this.element\n                .parents(this.options.pageMainActions)\n                .outerHeight();\n        },\n\n        /**\n         * Event binding, will monitor scroll and resize events (resize events left for backward compat)\n         * @private\n         */\n        _bind: function () {\n            this._on(window, {\n                scroll: this._handlePageScroll,\n                resize: this._handlePageScroll\n            });\n        },\n\n        /**\n         * Event handler for setting fixed positioning\n         * @private\n         */\n        _handlePageScroll: function () {\n            var isActive = $(window).scrollTop() > this._offsetTop;\n\n            if (isActive) {\n                this.element\n                    .addClass(this.options.fixedClass)\n                    .parents(this.options.pageMainActions)\n                    .addClass(this.options.hiddenClass);\n            } else {\n                this.element\n                    .removeClass(this.options.fixedClass)\n                    .parents(this.options.pageMainActions)\n                    .removeClass(this.options.hiddenClass);\n            }\n\n            this._placeholder.height(isActive ? this._height : '');\n        },\n\n        /**\n         * Widget destroy functionality\n         * @private\n         */\n        _destroy: function () {\n            this._placeholder.remove();\n            this._off($(window));\n        }\n    });\n\n    return $.mage.floatingHeader;\n});\n","mage/backend/button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function (factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'jquery/ui'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    $.widget('ui.button', $.ui.button, {\n        options: {\n            eventData: {},\n            waitTillResolved: true\n        },\n\n        /**\n         * Button creation.\n         * @protected\n         */\n        _create: function () {\n            if (this.options.event) {\n                this.options.target = this.options.target || this.element;\n                this._bind();\n            }\n\n            this._super();\n        },\n\n        /**\n         * Bind handler on button click.\n         * @protected\n         */\n        _bind: function () {\n            this.element\n                .off('click.button')\n                .on('click.button', $.proxy(this._click, this));\n        },\n\n        /**\n         * Button click handler.\n         * @protected\n         */\n        _click: function () {\n            var options = this.options;\n\n            $(options.target).trigger(options.event, [options.eventData]);\n        }\n    });\n\n    return $.ui.button;\n}));\n","mage/backend/jstree-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function () {\n        $.jstree._themes = require.s.contexts._.config.baseUrl + 'jquery/jstree/themes/';\n    };\n});\n","mage/backend/notification.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.notification', {\n        options: {\n            templates: {\n                global: '<div data-role=\"messages\" id=\"messages\">' +\n                    '<div class=\"message <% if (data.error) { %>error<% } %>\"><div><%- data.message %></div></div>' +\n                '</div>',\n                error: '<div data-role=\"messages\" id=\"messages\">' +\n                    '<div class=\"messages\"><div class=\"message message-error error\">' +\n                        '<div data-ui-id=\"messages-message-error\"><%- data.message %></div></div>' +\n                    '</div></div>'\n            }\n        },\n        placeholder: '[data-role=messages]',\n\n        /**\n         * Notification creation\n         * @protected\n         */\n        _create: function () {\n            $(document).on('ajaxComplete ajaxError', $.proxy(this._add, this));\n        },\n\n        /**\n         * Add new message\n         * @protected\n         * @param {Object} event - object\n         * @param {Object} jqXHR - The jQuery XMLHttpRequest object returned by $.ajax()\n         */\n        _add: function (event, jqXHR) {\n            var response;\n\n            try {\n                response = JSON.parse(jqXHR.responseText);\n\n                if (response && response.error && response['html_message']) {\n                    $(this.placeholder).html(response['html_message']);\n                }\n            } catch (e) {}\n        },\n\n        /**\n         * Adds new message.\n         *\n         * @param {Object} data - Data with a message to be displayed.\n         */\n        add: function (data) {\n            var template = data.error ? this.options.templates.error : this.options.templates.global,\n                message = mageTemplate(template, {\n                    data: data\n                }),\n                messageContainer;\n\n            if (typeof data.insertMethod === 'function') {\n                data.insertMethod(message);\n            } else {\n                messageContainer = data.messageContainer || this.placeholder;\n                $(messageContainer).prepend(message);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes error messages.\n         */\n        clear: function () {\n            $(this.placeholder).html('');\n        }\n    });\n\n    return $.mage.notification;\n});\n","mage/backend/tabs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY */\n(function (factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'jquery/ui'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n    'use strict';\n\n    var rhash, isLocal;\n\n    // mage.tabs base functionality\n    $.widget('mage.tabs', $.ui.tabs, {\n        options: {\n            spinner: false,\n            groups: null,\n            tabPanelClass: '',\n            excludedPanel: ''\n        },\n\n        /**\n         * Tabs creation\n         * @protected\n         */\n        _create: function () {\n            var activeIndex = this._getTabIndex(this.options.active);\n\n            this.options.active = activeIndex >= 0 ? activeIndex : 0;\n            this._super();\n        },\n\n        /**\n         * @override\n         * @private\n         * @return {Array} Array of DOM-elements\n         */\n        _getList: function () {\n            if (this.options.groups) {\n                return this.element.find(this.options.groups);\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Get active anchor\n         * @return {Element}\n         */\n        activeAnchor: function () {\n            return this.anchors.eq(this.option('active'));\n        },\n\n        /**\n         * Get tab index by tab id\n         * @protected\n         * @param {String} id - id of tab\n         * @return {Number}\n         */\n        _getTabIndex: function (id) {\n            var anchors = this.anchors ?\n                this.anchors :\n                this._getList().find('> li > a[href]');\n\n            return anchors.index($('#' + id));\n        },\n\n        /**\n         * Switch between tabs\n         * @protected\n         * @param {Object} event - event object\n         * @param {undefined|Object} eventData\n         */\n        _toggle: function (event, eventData) {\n            var anchor = $(eventData.newTab).find('a');\n\n            if ($(eventData.newTab).find('a').data().tabType === 'link') {\n                location.href = anchor.prop('href');\n            } else {\n                this._superApply(arguments);\n            }\n        }\n    });\n\n    rhash = /#.*$/;\n\n    /**\n     * @param {*} anchor\n     * @return {Boolean}\n     */\n    isLocal = function (anchor) {\n        return anchor.hash.length > 1 &&\n            anchor.href.replace(rhash, '') ===\n                location.href.replace(rhash, '')\n                    // support: Safari 5.1\n                    // Safari 5.1 doesn't encode spaces in window.location\n                    // but it does encode spaces from anchors (#8777)\n                    .replace(/\\s/g, '%20');\n    };\n\n    // Extension for mage.tabs - Move panels in destination element\n    $.widget('mage.tabs', $.mage.tabs, {\n        /**\n         * Move panels in destination element on creation\n         * @protected\n         * @override\n         */\n        _create: function () {\n            this._super();\n            this._movePanelsInDestination(this.panels);\n        },\n\n        /**\n         * Get panel for tab. If panel no exist in tabs container, then find panel in destination element\n         * @protected\n         * @override\n         * @param {Element} tab - tab \"li\" DOM-element\n         * @return {Element}\n         */\n        _getPanelForTab: function (tab) {\n            var panel = this._superApply(arguments),\n                id;\n\n            if (!panel.length) {\n                id = $(tab).attr('aria-controls');\n                panel = $(this.options.destination).find(this._sanitizeSelector('#' + id));\n            }\n\n            return panel;\n        },\n\n        /**\n         * @private\n         */\n        _processTabs: function () {\n            var that = this;\n\n            this.tablist = this._getList()\n                .addClass('ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all')\n                .attr('role', 'tablist');\n\n            this.tabs = this.tablist.find('> li:has(a[href])')\n                .addClass('ui-state-default ui-corner-top')\n                .attr({\n                    role: 'tab',\n                    tabIndex: -1\n                });\n\n            this.anchors = this.tabs.map(function () {\n                return $('a', this)[ 0 ];\n            })\n                .addClass('ui-tabs-anchor')\n                .attr({\n                    role: 'presentation',\n                    tabIndex: -1\n                });\n\n            this.panels = $();\n\n            this.anchors.each(function (i, anchor) {\n                var selector, panel, panelId,\n                    anchorId = $(anchor).uniqueId().attr('id'),\n                    tab = $(anchor).closest('li'),\n                    originalAriaControls = tab.attr('aria-controls');\n\n                // inline tab\n                if (isLocal(anchor)) {\n                    selector = anchor.hash;\n                    panel = that.document.find(that._sanitizeSelector(selector));\n                    // remote tab\n                } else {\n                    panelId = that._tabId(tab);\n                    selector = '#' + panelId;\n                    panel = that.document.find(selector);\n\n                    if (!panel.length) {\n                        panel = that._createPanel(panelId);\n                        panel.insertAfter(that.panels[ i - 1 ] || that.tablist);\n                    }\n                    panel.attr('aria-live', 'polite');\n                }\n\n                if (panel.length) {\n                    that.panels = that.panels.add(panel);\n                }\n\n                if (originalAriaControls) {\n                    tab.data('ui-tabs-aria-controls', originalAriaControls);\n                }\n                tab.attr({\n                    'aria-controls': selector.substring(1),\n                    'aria-labelledby': anchorId\n                });\n                panel.attr('aria-labelledby', anchorId);\n\n                if (that.options.excludedPanel.indexOf(anchorId + '_content') < 0) {\n                    panel.addClass(that.options.tabPanelClass);\n                }\n            });\n\n            this.panels\n                .addClass('ui-tabs-panel ui-widget-content ui-corner-bottom')\n                .attr('role', 'tabpanel');\n        },\n\n        /**\n         * Move panels in destination element\n         * @protected\n         * @override\n         */\n        _movePanelsInDestination: function (panels) {\n            if (this.options.destination && !panels.parents(this.options.destination).length) {\n                this.element.trigger('beforePanelsMove', panels);\n\n                panels.find('script:not([type]), script[type=\"text/javascript\"]').remove();\n\n                panels.appendTo(this.options.destination)\n                    .each($.proxy(function (i, panel) {\n                        $(panel).trigger('move.tabs', this.anchors.eq(i));\n                    }, this));\n            }\n        },\n\n        /**\n         * Move panels in destination element on tabs switching\n         * @protected\n         * @override\n         * @param {Object} event - event object\n         * @param {Object} eventData\n         */\n        _toggle: function (event, eventData) {\n            this._movePanelsInDestination(eventData.newPanel);\n            this._superApply(arguments);\n        }\n    });\n\n    // Extension for mage.tabs - Ajax functionality for tabs\n    $.widget('mage.tabs', $.mage.tabs, {\n        options: {\n            ajaxOptions: {\n                data: {\n                    isAjax: true,\n                    'form_key': typeof FORM_KEY !== 'undefined' ? FORM_KEY : null\n                }\n            },\n\n            /**\n             * Replacing href attribute with loaded panel id\n             * @param {Object} event - event object\n             * @param {Object} ui\n             */\n            load: function (event, ui) {\n                var panel = $(ui.panel);\n\n                $(ui.tab).prop('href', '#' + panel.prop('id'));\n                panel.trigger('contentUpdated');\n            }\n        }\n    });\n\n    // Extension for mage.tabs - Attach event handlers to tabs\n    $.widget('mage.tabs', $.mage.tabs, {\n        options: {\n            tabIdArgument: 'tab',\n            tabsBlockPrefix: null\n        },\n\n        /**\n         * Attach event handlers to tabs, on creation\n         * @protected\n         * @override\n         */\n        _refresh: function () {\n            this._super();\n            $.each(this.tabs, $.proxy(function (i, tab) {\n                $(this._getPanelForTab(tab))\n                    .off('changed' + this.eventNamespace)\n                    .off('highlight.validate' + this.eventNamespace)\n                    .off('focusin' + this.eventNamespace)\n\n                    .on('changed' + this.eventNamespace, {\n                        index: i\n                    }, $.proxy(this._onContentChange, this))\n                    .on('highlight.validate' + this.eventNamespace, {\n                        index: i\n                    }, $.proxy(this._onInvalid, this))\n                    .on('focusin' + this.eventNamespace, {\n                        index: i\n                    }, $.proxy(this._onFocus, this));\n            }, this));\n\n            ($(this.options.destination).is('form') ?\n                $(this.options.destination) :\n                $(this.options.destination).closest('form'))\n                    .off('beforeSubmit' + this.eventNamespace)\n                    .on('beforeSubmit' + this.eventNamespace, $.proxy(this._onBeforeSubmit, this));\n        },\n\n        /**\n         * Mark tab as changed if some field inside tab panel is changed\n         * @protected\n         * @param {Object} e - event object\n         */\n        _onContentChange: function (e) {\n            var cssChanged = '_changed';\n\n            this.anchors.eq(e.data.index).addClass(cssChanged);\n            this._updateNavTitleMessages(e, cssChanged);\n        },\n\n        /**\n         * Clone messages (tooltips) from anchor to parent element\n         * @protected\n         * @param {Object} e - event object\n         * @param {String} messageType - changed or error\n         */\n        _updateNavTitleMessages: function (e, messageType) {\n            var curAnchor = this.anchors.eq(e.data.index),\n                curItem = curAnchor.parents('[data-role=\"container\"]').find('[data-role=\"title\"]'),\n                curItemMessages = curItem.find('[data-role=\"title-messages\"]'),\n                activeClass = '_active';\n\n            if (curItemMessages.is(':empty')) {\n                curAnchor\n                    .find('[data-role=\"item-messages\"]')\n                    .clone()\n                    .appendTo(curItemMessages);\n            }\n\n            curItemMessages.find('.' + messageType).addClass(activeClass);\n        },\n\n        /**\n         * Mark tab as error if some field inside tab panel is not passed validation\n         * @param {Object} e - event object\n         * @protected\n         */\n        _onInvalid: function (e) {\n            var cssError = '_error',\n                fakeEvent = e;\n\n            fakeEvent.currentTarget = $(this.anchors).eq(e.data.index);\n            this._eventHandler(fakeEvent);\n            this.anchors.eq(e.data.index).addClass(cssError).find('.' + cssError).show();\n            this._updateNavTitleMessages(e, cssError);\n        },\n\n        /**\n         * Show tab panel if focus event triggered of some field inside tab panel\n         * @param {Object} e - event object\n         * @protected\n         */\n        _onFocus: function (e) {\n            this.option('_active', e.data.index);\n        },\n\n        /**\n         * Add active tab id in data object when \"beforeSubmit\" event is triggered\n         * @param {Object} e - event object\n         * @param {Object} data - event data object\n         * @protected\n         */\n        _onBeforeSubmit: function (e, data) { //eslint-disable-line no-unused-vars\n            var activeAnchor = this.activeAnchor(),\n                activeTabId = activeAnchor.prop('id'),\n                options;\n\n            if (this.options.tabsBlockPrefix) {\n                if (activeAnchor.is('[id*=\"' + this.options.tabsBlockPrefix + '\"]')) {\n                    activeTabId = activeAnchor.prop('id').substr(this.options.tabsBlockPrefix.length);\n                }\n            }\n            $(this.anchors).removeClass('error');\n            options = {\n                action: {\n                    args: {}\n                }\n            };\n            options.action.args[this.options.tabIdArgument] = activeTabId;\n            data = data ? $.extend(data, options) : options;\n        }\n    });\n\n    // Extension for mage.tabs - Shadow tabs functionality\n    $.widget('mage.tabs', $.mage.tabs, {\n        /**\n         * Add shadow tabs functionality on creation\n         * @protected\n         * @override\n         */\n        _refresh: function () {\n            var anchors, shadowTabs, tabs;\n\n            this._super();\n            anchors = this.anchors;\n            shadowTabs = this.options.shadowTabs;\n            tabs = this.tabs;\n\n            if (shadowTabs) {\n                anchors.each($.proxy(function (i, anchor) {\n                    var anchorId = $(anchor).prop('id');\n\n                    if (shadowTabs[anchorId]) {\n                        $(anchor).parents('li').on('click', $.proxy(function () {\n                            $.each(shadowTabs[anchorId], $.proxy(function (key, id) {\n                                this.load($(tabs).index($('#' + id).parents('li')), {});\n                            }, this));\n                        }, this));\n                    }\n                }, this));\n            }\n        }\n    });\n\n    return $.mage.tabs;\n}));\n","mage/backend/suggest.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function (root, factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'mage/template',\n            'mage/mage',\n            'jquery/ui',\n            'mage/backend/menu',\n            'mage/translate'\n        ], factory);\n    } else {\n        factory(root.jQuery, root.mageTemplate);\n    }\n}(this, function ($, mageTemplate) {\n    'use strict';\n\n    /**\n     * Implement base functionality\n     */\n    $.widget('mage.suggest', {\n        widgetEventPrefix: 'suggest',\n        options: {\n            template: '<% if (data.items.length) { %>' +\n                '<% if (!data.term && !data.allShown() && data.recentShown()) { %>' +\n                '<h5 class=\"title\"><%- data.recentTitle %></h5>' +\n                '<% } %>' +\n                '<ul data-mage-init=\\'{\"menu\":[]}\\'>' +\n                '<% _.each(data.items, function(value){ %>' +\n                '<% if (!data.itemSelected(value)) { %><li <%= data.optionData(value) %>>' +\n                '<a href=\"#\"><%- value.label %></a></li><% } %>' +\n                '<% }); %>' +\n                '<% if (!data.term && !data.allShown() && data.recentShown()) { %>' +\n                '<li data-mage-init=\\'{\"actionLink\":{\"event\":\"showAll\"}}\\' class=\"show-all\">' +\n                '<a href=\"#\"><%- data.showAllTitle %></a></li>' +\n                '<% } %>' +\n                '</ul><% } else { %><span class=\"mage-suggest-no-records\"><%- data.noRecordsText %></span><% } %>',\n            minLength: 1,\n\n            /**\n             * @type {(String|Array)}\n             */\n            source: null,\n            delay: 500,\n            loadingClass: 'mage-suggest-state-loading',\n            events: {},\n            appendMethod: 'after',\n            controls: {\n                selector: ':ui-menu, :mage-menu',\n                eventsMap: {\n                    focus: ['menufocus'],\n                    blur: ['menublur'],\n                    select: ['menuselect']\n                }\n            },\n            termAjaxArgument: 'label_part',\n            filterProperty: 'label',\n            className: null,\n            inputWrapper: '<div class=\"mage-suggest\"><div class=\"mage-suggest-inner\"></div></div>',\n            dropdownWrapper: '<div class=\"mage-suggest-dropdown\"></div>',\n            preventClickPropagation: true,\n            currentlySelected: null,\n            submitInputOnEnter: true\n        },\n\n        /**\n         * Component's constructor\n         * @private\n         */\n        _create: function () {\n            this._term = null;\n            this._nonSelectedItem = {\n                id: '',\n                label: ''\n            };\n            this.templates = {};\n            this._renderedContext = null;\n            this._selectedItem = this._nonSelectedItem;\n            this._control = this.options.controls || {};\n            this._setTemplate();\n            this._prepareValueField();\n            this._render();\n            this._bind();\n        },\n\n        /**\n         * Render base elements for suggest component\n         * @private\n         */\n        _render: function () {\n            var wrapper;\n\n            this.dropdown = $(this.options.dropdownWrapper).hide();\n            wrapper = this.options.className ?\n                $(this.options.inputWrapper).addClass(this.options.className) :\n                $(this.options.inputWrapper);\n            this.element\n                .wrap(wrapper)[this.options.appendMethod](this.dropdown)\n                .attr('autocomplete', 'off');\n        },\n\n        /**\n         * Define a field for storing item id (find in DOM or create a new one)\n         * @private\n         */\n        _prepareValueField: function () {\n            if (this.options.valueField) {\n                this.valueField = $(this.options.valueField);\n            } else {\n                this.valueField = this._createValueField()\n                    .insertBefore(this.element)\n                    .attr('name', this.element.attr('name'));\n                this.element.removeAttr('name');\n            }\n        },\n\n        /**\n         * Create value field which keeps a id for selected option\n         * can be overridden in descendants\n         * @return {jQuery}\n         * @private\n         */\n        _createValueField: function () {\n            return $('<input/>', {\n                type: 'hidden'\n            });\n        },\n\n        /**\n         * Component's destructor\n         * @private\n         */\n        _destroy: function () {\n            this.element\n                .unwrap()\n                .removeAttr('autocomplete');\n\n            if (!this.options.valueField) {\n                this.element.attr('name', this.valueField.attr('name'));\n                this.valueField.remove();\n            }\n\n            this.dropdown.remove();\n            this._off(this.element, 'keydown keyup blur');\n        },\n\n        /**\n         * Return actual value of an \"input\"-element\n         * @return {String}\n         * @private\n         */\n        _value: function () {\n            return $.trim(this.element[this.element.is(':input') ? 'val' : 'text']());\n        },\n\n        /**\n         * Pass original event to a control component for handling it as it's own event\n         * @param {Object} event - event object\n         * @private\n         */\n        _proxyEvents: function (event) {\n            var fakeEvent = $.extend({}, $.Event(event.type), {\n                    ctrlKey: event.ctrlKey,\n                    keyCode: event.keyCode,\n                    which: event.keyCode\n                }),\n                target = this._control.selector ? this.dropdown.find(this._control.selector) : this.dropdown;\n\n            target.trigger(fakeEvent);\n        },\n\n        /**\n         * Bind handlers on specific events\n         * @private\n         */\n        _bind: function () {\n            this._on($.extend({\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                keydown: function (event) {\n                    var keyCode = $.ui.keyCode,\n                        suggestList,\n                        hasSuggestedItems,\n                        hasSelectedItems,\n                        selectedItem;\n\n                    switch (event.keyCode) {\n                        case keyCode.PAGE_UP:\n                        case keyCode.UP:\n                            if (!event.shiftKey) {\n                                event.preventDefault();\n                                this._proxyEvents(event);\n                            }\n\n                            suggestList = event.currentTarget.parentNode.getElementsByTagName('ul')[0];\n                            hasSuggestedItems = event.currentTarget\n                                    .parentNode.getElementsByTagName('ul')[0].children.length >= 0;\n\n                            if (hasSuggestedItems) {\n                                selectedItem =  $(suggestList.getElementsByClassName('_active')[0])\n                                    .removeClass('_active').prev().addClass('_active');\n                                event.currentTarget.value = selectedItem.find('a').text();\n                            }\n\n                            break;\n\n                        case keyCode.PAGE_DOWN:\n                        case keyCode.DOWN:\n                            if (!event.shiftKey) {\n                                event.preventDefault();\n                                this._proxyEvents(event);\n                            }\n\n                            suggestList = event.currentTarget.parentNode.getElementsByTagName('ul')[0];\n                            hasSuggestedItems = event.currentTarget\n                                .parentNode.getElementsByTagName('ul')[0].children.length >= 0;\n\n                            if (hasSuggestedItems) {\n                                hasSelectedItems = suggestList.getElementsByClassName('_active').length === 0;\n\n                                if (hasSelectedItems) { //eslint-disable-line max-depth\n                                    selectedItem = $(suggestList.children[0]).addClass('_active');\n                                    event.currentTarget.value = selectedItem.find('a').text();\n                                } else {\n                                    selectedItem = $(suggestList.getElementsByClassName('_active')[0])\n                                        .removeClass('_active').next().addClass('_active');\n                                    event.currentTarget.value = selectedItem.find('a').text();\n                                }\n                            }\n                            break;\n\n                        case keyCode.TAB:\n                            if (this.isDropdownShown()) {\n                                this._onSelectItem(event, null);\n                                event.preventDefault();\n                            }\n                            break;\n\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            this._toggleEnter(event);\n\n                            if (this.isDropdownShown() && this._focused) {\n                                this._proxyEvents(event);\n                                event.preventDefault();\n                            }\n                            break;\n\n                        case keyCode.ESCAPE:\n                            if (this.isDropdownShown()) {\n                                event.stopPropagation();\n                            }\n                            this.close(event);\n                            this._blurItem();\n                            break;\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                keyup: function (event) {\n                    var keyCode = $.ui.keyCode;\n\n                    switch (event.keyCode) {\n                        case keyCode.HOME:\n                        case keyCode.END:\n                        case keyCode.PAGE_UP:\n                        case keyCode.PAGE_DOWN:\n                        case keyCode.ESCAPE:\n                        case keyCode.UP:\n                        case keyCode.DOWN:\n                        case keyCode.LEFT:\n                        case keyCode.RIGHT:\n                        case keyCode.TAB:\n                            break;\n\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            if (this.isDropdownShown()) {\n                                event.preventDefault();\n                            }\n                            break;\n                        default:\n                            this.search(event);\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                blur: function (event) {\n                    if (!this.preventBlur) {\n                        this._abortSearch();\n                        this.close(event);\n                        this._change(event);\n                    } else {\n                        this.element.trigger('focus');\n                    }\n                },\n                cut: this.search,\n                paste: this.search,\n                input: this.search,\n                selectItem: this._onSelectItem,\n                click: this.search\n            }, this.options.events));\n\n            this._bindSubmit();\n            this._bindDropdown();\n        },\n\n        /**\n         * @param {Object} event\n         * @private\n         */\n        _toggleEnter: function (event) {\n            var suggestList,\n                activeItems,\n                selectedItem;\n\n            if (!this.options.submitInputOnEnter) {\n                event.preventDefault();\n            }\n\n            suggestList = $(event.currentTarget.parentNode).find('ul').first();\n            activeItems = suggestList.find('._active');\n\n            if (activeItems.length >= 0) {\n                selectedItem = activeItems.first();\n\n                if (selectedItem.find('a') && selectedItem.find('a').attr('href') !== undefined) {\n                    window.location = selectedItem.find('a').attr('href');\n                    event.preventDefault();\n                }\n            }\n        },\n\n        /**\n         * Bind handlers for submit on enter\n         * @private\n         */\n        _bindSubmit: function () {\n            this.element.parents('form').on('submit', function (event) {\n                if (!this.submitInputOnEnter) {\n                    event.preventDefault();\n                }\n            });\n        },\n\n        /**\n         * @param {Object} e - event object\n         * @private\n         */\n        _change: function (e) {\n            if (this._term !== this._value()) {\n                this._trigger('change', e);\n            }\n        },\n\n        /**\n         * Bind handlers for dropdown element on specific events\n         * @private\n         */\n        _bindDropdown: function () {\n            var events = {\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                click: function (e) {\n                    // prevent default browser's behavior of changing location by anchor href\n                    e.preventDefault();\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                mousedown: function (e) {\n                    e.preventDefault();\n                }\n            };\n\n            $.each(this._control.eventsMap, $.proxy(function (suggestEvent, controlEvents) {\n                $.each(controlEvents, $.proxy(function (i, handlerName) {\n                    switch (suggestEvent) {\n                        case 'select':\n                            events[handlerName] = this._onSelectItem;\n                            break;\n\n                        case 'focus':\n                            events[handlerName] = this._focusItem;\n                            break;\n\n                        case 'blur':\n                            events[handlerName] = this._blurItem;\n                            break;\n                    }\n                }, this));\n            }, this));\n\n            if (this.options.preventClickPropagation) {\n                this._on(this.dropdown, events);\n            }\n            // Fix for IE 8\n            this._on(this.dropdown, {\n                /**\n                 * Mousedown.\n                 */\n                mousedown: function () {\n                    this.preventBlur = true;\n                },\n\n                /**\n                 * Mouseup.\n                 */\n                mouseup: function () {\n                    this.preventBlur = false;\n                }\n            });\n        },\n\n        /**\n         * @override\n         */\n        _trigger: function (type, event) {\n            var result = this._superApply(arguments);\n\n            if (result === false && event) {\n                event.stopImmediatePropagation();\n                event.preventDefault();\n            }\n\n            return result;\n        },\n\n        /**\n         * Handle focus event of options item\n         * @param {Object} e - event object\n         * @param {Object} ui - object that can contain information about focused item\n         * @private\n         */\n        _focusItem: function (e, ui) {\n            if (ui && ui.item) {\n                this._focused = $(ui.item).prop('tagName') ?\n                    this._readItemData(ui.item) :\n                    ui.item;\n\n                this.element.val(this._focused.label);\n                this._trigger('focus', e, {\n                    item: this._focused\n                });\n            }\n        },\n\n        /**\n         * Handle blur event of options item\n         * @private\n         */\n        _blurItem: function () {\n            this._focused = null;\n            this.element.val(this._term);\n        },\n\n        /**\n         * @param {Object} e - event object\n         * @param {Object} item\n         * @private\n         */\n        _onSelectItem: function (e, item) {\n            if (item && $.type(item) === 'object' && $(e.target).is(this.element)) {\n                this._focusItem(e, {\n                    item: item\n                });\n            }\n\n            if (this._trigger('beforeselect', e || null, {\n                    item: this._focused\n                }) === false) {\n                return;\n            }\n            this._selectItem(e);\n            this._blurItem();\n            this._trigger('select', e || null, {\n                item: this._selectedItem\n            });\n        },\n\n        /**\n         * Save selected item and hide dropdown\n         * @private\n         * @param {Object} e - event object\n         */\n        _selectItem: function (e) {\n            if (this._focused) {\n                this._selectedItem = this._focused;\n\n                if (this._selectedItem !== this._nonSelectedItem) {\n                    this._term = this._selectedItem.label;\n                    this.valueField.val(this._selectedItem.id);\n                    this.close(e);\n                }\n            }\n        },\n\n        /**\n         * Read option data from item element\n         * @param {Element} element\n         * @return {Object}\n         * @private\n         */\n        _readItemData: function (element) {\n            return element.data('suggestOption') || this._nonSelectedItem;\n        },\n\n        /**\n         * Check if dropdown is shown\n         * @return {Boolean}\n         */\n        isDropdownShown: function () {\n            return this.dropdown.is(':visible');\n        },\n\n        /**\n         * Open dropdown\n         * @private\n         * @param {Object} e - event object\n         */\n        open: function (e) {\n            if (!this.isDropdownShown()) {\n                this.element.addClass('_suggest-dropdown-open');\n                this.dropdown.show();\n                this._trigger('open', e);\n            }\n        },\n\n        /**\n         * Close and clear dropdown content\n         * @private\n         * @param {Object} e - event object\n         */\n        close: function (e) {\n            this._renderedContext = null;\n\n            if (this.dropdown.length) {\n                this.element.removeClass('_suggest-dropdown-open');\n                this.dropdown.hide().empty();\n            }\n\n            this._trigger('close', e);\n        },\n\n        /**\n         * Acquire content template\n         * @private\n         */\n        _setTemplate: function () {\n            this.templateName = 'suggest' + Math.random().toString(36).substr(2);\n\n            this.templates[this.templateName] = mageTemplate(this.options.template);\n        },\n\n        /**\n         * Execute search process\n         * @public\n         * @param {Object} e - event object\n         */\n        search: function (e) {\n            var term = this._value();\n\n            if ((this._term !== term || term.length === 0) && !this.preventBlur) {\n                this._term = term;\n\n                if ($.type(term) === 'string' && term.length >= this.options.minLength) {\n                    if (this._trigger('search', e) === false) { //eslint-disable-line max-depth\n                        return;\n                    }\n                    this._search(e, term, {});\n                } else {\n                    this._selectedItem = this._nonSelectedItem;\n                    this._resetSuggestValue();\n                }\n            }\n        },\n\n        /**\n         * Clear suggest hidden input\n         * @private\n         */\n        _resetSuggestValue: function () {\n            this.valueField.val(this._nonSelectedItem.id);\n        },\n\n        /**\n         * Actual search method, can be overridden in descendants\n         * @param {Object} e - event object\n         * @param {String} term - search phrase\n         * @param {Object} context - search context\n         * @private\n         */\n        _search: function (e, term, context) {\n            var response = $.proxy(function (items) {\n                return this._processResponse(e, items, context || {});\n            }, this);\n\n            this.element.addClass(this.options.loadingClass);\n\n            if (this.options.delay) {\n                if ($.type(this.options.data) !== 'undefined') {\n                    response(this.filter(this.options.data, term));\n                }\n                clearTimeout(this._searchTimeout);\n                this._searchTimeout = this._delay(function () {\n                    this._source(term, response);\n                }, this.options.delay);\n            } else {\n                this._source(term, response);\n            }\n        },\n\n        /**\n         * Extend basic context with additional data (search results, search term)\n         * @param {Object} context\n         * @return {Object}\n         * @private\n         */\n        _prepareDropdownContext: function (context) {\n            return $.extend(context, {\n                items: this._items,\n                term: this._term,\n\n                /**\n                 * @param {Object} item\n                 * @return {String}\n                 */\n                optionData: function (item) {\n                    return 'data-suggest-option=\"' +\n                        $('<div>').text(JSON.stringify(item)).html().replace(/\"/g, '&quot;') + '\"';\n                },\n                itemSelected: $.proxy(this._isItemSelected, this),\n                noRecordsText: $.mage.__('No records found.')\n            });\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Boolean}\n         * @private\n         */\n        _isItemSelected: function (item) {\n            return item.id == (this._selectedItem && this._selectedItem.id ? //eslint-disable-line eqeqeq\n                this._selectedItem.id :\n                this.options.currentlySelected);\n        },\n\n        /**\n         * Render content of suggest's dropdown\n         * @param {Object} e - event object\n         * @param {Array} items - list of label+id objects\n         * @param {Object} context - template's context\n         * @private\n         */\n        _renderDropdown: function (e, items, context) {\n            var tmpl = this.templates[this.templateName];\n\n            this._items = items;\n\n            tmpl = tmpl({\n                data: this._prepareDropdownContext(context)\n            });\n\n            $(tmpl).appendTo(this.dropdown.empty());\n\n            this.dropdown.trigger('contentUpdated')\n                .find(this._control.selector).on('focus', function (event) {\n                    event.preventDefault();\n                });\n\n            this._renderedContext = context;\n            this.element.removeClass(this.options.loadingClass);\n            this.open(e);\n        },\n\n        /**\n         * @param {Object} e\n         * @param {Object} items\n         * @param {Object} context\n         * @private\n         */\n        _processResponse: function (e, items, context) {\n            var renderer = $.proxy(function (i) {\n                return this._renderDropdown(e, i, context || {});\n            }, this);\n\n            if (this._trigger('response', e, [items, renderer]) === false) {\n                return;\n            }\n            this._renderDropdown(e, items, context);\n        },\n\n        /**\n         * Implement search process via spesific source\n         * @param {String} term - search phrase\n         * @param {Function} response - search results handler, process search result\n         * @private\n         */\n        _source: function (term, response) {\n            var o = this.options,\n                ajaxData;\n\n            if ($.isArray(o.source)) {\n                response(this.filter(o.source, term));\n            } else if ($.type(o.source) === 'string') {\n                ajaxData = {};\n                ajaxData[this.options.termAjaxArgument] = term;\n\n                this._xhr = $.ajax($.extend(true, {\n                    url: o.source,\n                    type: 'POST',\n                    dataType: 'json',\n                    data: ajaxData,\n                    success: $.proxy(function (items) {\n                        this.options.data = items;\n                        response.apply(response, arguments);\n                    }, this)\n                }, o.ajaxOptions || {}));\n            } else if ($.type(o.source) === 'function') {\n                o.source.apply(o.source, arguments);\n            }\n        },\n\n        /**\n         * Abort search process\n         * @private\n         */\n        _abortSearch: function () {\n            this.element.removeClass(this.options.loadingClass);\n            clearTimeout(this._searchTimeout);\n        },\n\n        /**\n         * Perform filtering in advance loaded items and returns search result\n         * @param {Array} items - all available items\n         * @param {String} term - search phrase\n         * @return {Object}\n         */\n        filter: function (items, term) {\n            var matcher = new RegExp(term.replace(/[\\-\\/\\\\\\^$*+?.()|\\[\\]{}]/g, '\\\\$&'), 'i'),\n                itemsArray = $.isArray(items) ? items : $.map(items, function (element) {\n                    return element;\n                }),\n                property = this.options.filterProperty;\n\n            return $.grep(\n                itemsArray,\n                function (value) {\n                    return matcher.test(value[property] || value.id || value);\n                }\n            );\n        }\n    });\n\n    /**\n     * Implement show all functionality and storing and display recent searches\n     */\n    $.widget('mage.suggest', $.mage.suggest, {\n        options: {\n            showRecent: false,\n            showAll: false,\n            storageKey: 'suggest',\n            storageLimit: 10\n        },\n\n        /**\n         * @override\n         */\n        _create: function () {\n            var recentItems;\n\n            if (this.options.showRecent && window.localStorage) {\n                recentItems = JSON.parse(localStorage.getItem(this.options.storageKey));\n\n                /**\n                 * @type {Array} - list of recently searched items\n                 * @private\n                 */\n                this._recentItems = $.isArray(recentItems) ? recentItems : [];\n            }\n            this._super();\n        },\n\n        /**\n         * @override\n         */\n        _bind: function () {\n            this._super();\n            this._on(this.dropdown, {\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                showAll: function (e) {\n                    e.stopImmediatePropagation();\n                    e.preventDefault();\n                    this.element.trigger('showAll');\n                }\n            });\n\n            if (this.options.showRecent || this.options.showAll) {\n                this._on({\n                    /**\n                     * @param {jQuery.Event} e\n                     */\n                    focus: function (e) {\n                        if (!this.isDropdownShown()) {\n                            this.search(e);\n                        }\n                    },\n                    showAll: this._showAll\n                });\n            }\n        },\n\n        /**\n         * @private\n         * @param {Object} e - event object\n         */\n        _showAll: function (e) {\n            this._abortSearch();\n            this._search(e, '', {\n                _allShown: true\n            });\n        },\n\n        /**\n         * @override\n         */\n        search: function (e) {\n            if (!this._value()) {\n\n                if (this.options.showRecent) {\n\n                    if (this._recentItems.length) { //eslint-disable-line max-depth\n                        this._processResponse(e, this._recentItems, {});\n                    } else {\n                        this._showAll(e);\n                    }\n                } else if (this.options.showAll) {\n                    this._showAll(e);\n                }\n            }\n            this._superApply(arguments);\n        },\n\n        /**\n         * @override\n         */\n        _selectItem: function () {\n            this._superApply(arguments);\n\n            if (this._selectedItem && this._selectedItem.id && this.options.showRecent) {\n                this._addRecent(this._selectedItem);\n            }\n        },\n\n        /**\n         * @override\n         */\n        _prepareDropdownContext: function () {\n            var context = this._superApply(arguments);\n\n            return $.extend(context, {\n                recentShown: $.proxy(function () {\n                    return this.options.showRecent;\n                }, this),\n                recentTitle: $.mage.__('Recent items'),\n                showAllTitle: $.mage.__('Show all...'),\n\n                /**\n                 * @return {Boolean}\n                 */\n                allShown: function () {\n                    return !!context._allShown;\n                }\n            });\n        },\n\n        /**\n         * Add selected item of search result into storage of recents\n         * @param {Object} item - label+id object\n         * @private\n         */\n        _addRecent: function (item) {\n            this._recentItems = $.grep(this._recentItems, function (obj) {\n                return obj.id !== item.id;\n            });\n            this._recentItems.unshift(item);\n            this._recentItems = this._recentItems.slice(0, this.options.storageLimit);\n            localStorage.setItem(this.options.storageKey, JSON.stringify(this._recentItems));\n        }\n    });\n\n    /**\n     * Implement multi suggest functionality\n     */\n    $.widget('mage.suggest', $.mage.suggest, {\n        options: {\n            multiSuggestWrapper: '<ul class=\"mage-suggest-choices\">' +\n                '<li class=\"mage-suggest-search-field\" data-role=\"parent-choice-element\"><' +\n                'label class=\"mage-suggest-search-label\"></label></li></ul>',\n            choiceTemplate: '<li class=\"mage-suggest-choice button\"><div><%- text %></div>' +\n            '<span class=\"mage-suggest-choice-close\" tabindex=\"-1\" ' +\n            'data-mage-init=\\'{\"actionLink\":{\"event\":\"removeOption\"}}\\'></span></li>',\n            selectedClass: 'mage-suggest-selected'\n        },\n\n        /**\n         * @override\n         */\n        _create: function () {\n            this.choiceTmpl = mageTemplate(this.options.choiceTemplate);\n\n            this._super();\n\n            if (this.options.multiselect) {\n                this.valueField.hide();\n            }\n        },\n\n        /**\n         * @override\n         */\n        _render: function () {\n            this._super();\n\n            if (this.options.multiselect) {\n                this._renderMultiselect();\n            }\n        },\n\n        /**\n         * Render selected options\n         * @private\n         */\n        _renderMultiselect: function () {\n            var that = this;\n\n            this.element.wrap(this.options.multiSuggestWrapper);\n            this.elementWrapper = this.element.closest('[data-role=\"parent-choice-element\"]');\n            $(function () {\n                that._getOptions()\n                    .each(function (i, option) {\n                        option = $(option);\n                        that._createOption({\n                            id: option.val(),\n                            label: option.text()\n                        });\n                    });\n            });\n        },\n\n        /**\n         * @return {Array} array of DOM-elements\n         * @private\n         */\n        _getOptions: function () {\n            return this.valueField.find('option');\n        },\n\n        /**\n         * @override\n         */\n        _bind: function () {\n            this._super();\n\n            if (this.options.multiselect) {\n                this._on({\n                    /**\n                     * @param {jQuery.Event} event\n                     */\n                    keydown: function (event) {\n                        if (event.keyCode === $.ui.keyCode.BACKSPACE) {\n                            if (!this._value()) {\n                                this._removeLastAdded(event);\n                            }\n                        }\n                    },\n                    removeOption: this.removeOption\n                });\n            }\n        },\n\n        /**\n         * @param {Array} items\n         * @return {Array}\n         * @private\n         */\n        _filterSelected: function (items) {\n            var options = this._getOptions();\n\n            return $.grep(items, function (value) {\n                var itemSelected = false;\n\n                $.each(options, function () {\n                    if (value.id == $(this).val()) { //eslint-disable-line eqeqeq\n                        itemSelected = true;\n                    }\n                });\n\n                return !itemSelected;\n            });\n        },\n\n        /**\n         * @override\n         */\n        _processResponse: function (e, items, context) {\n            if (this.options.multiselect) {\n                items = this._filterSelected(items, context);\n            }\n            this._superApply([e, items, context]);\n        },\n\n        /**\n         * @override\n         */\n        _prepareValueField: function () {\n            this._super();\n\n            if (this.options.multiselect && !this.options.valueField && this.options.selectedItems) {\n                $.each(this.options.selectedItems, $.proxy(function (i, item) {\n                    this._addOption(item);\n                }, this));\n            }\n        },\n\n        /**\n         * If \"multiselect\" option is set, then do not need to clear value for hidden select, to avoid losing of\n         *      previously selected items\n         * @override\n         */\n        _resetSuggestValue: function () {\n            if (!this.options.multiselect) {\n                this._super();\n            }\n        },\n\n        /**\n         * @override\n         */\n        _createValueField: function () {\n            if (this.options.multiselect) {\n                return $('<select/>', {\n                    type: 'hidden',\n                    multiple: 'multiple'\n                });\n            }\n\n            return this._super();\n        },\n\n        /**\n         * @override\n         */\n        _selectItem: function (e) {\n            if (this.options.multiselect) {\n                if (this._focused) {\n                    this._selectedItem = this._focused;\n\n                    /* eslint-disable max-depth */\n                    if (this._selectedItem !== this._nonSelectedItem) {\n                        this._term = '';\n                        this.element.val(this._term);\n\n                        if (this._isItemSelected(this._selectedItem)) {\n                            $(e.target).removeClass(this.options.selectedClass);\n                            this.removeOption(e, this._selectedItem);\n                            this._selectedItem = this._nonSelectedItem;\n                        } else {\n                            $(e.target).addClass(this.options.selectedClass);\n                            this._addOption(e, this._selectedItem);\n                        }\n                    }\n\n                    /* eslint-enable max-depth */\n                }\n                this.close(e);\n            } else {\n                this._superApply(arguments);\n            }\n        },\n\n        /**\n         * @override\n         */\n        _isItemSelected: function (item) {\n            if (this.options.multiselect) {\n                return this.valueField.find('option[value=' + item.id + ']').length > 0;\n            }\n\n            return this._superApply(arguments);\n        },\n\n        /**\n         *\n         * @param {Object} item\n         * @return {Element}\n         * @private\n         */\n        _createOption: function (item) {\n            var option = this._getOption(item);\n\n            if (!option.length) {\n                option = $('<option>', {\n                    value: item.id,\n                    selected: true\n                }).text(item.label);\n            }\n\n            return option.data('renderedOption', this._renderOption(item));\n        },\n\n        /**\n         * Add selected item in to select options\n         * @param {Object} e - event object\n         * @param {*} item\n         * @private\n         */\n        _addOption: function (e, item) {\n            this.valueField.append(this._createOption(item).data('selectTarget', $(e.target)));\n        },\n\n        /**\n         * @param {Object|Element} item\n         * @return {Element}\n         * @private\n         */\n        _getOption: function (item) {\n            return $(item).prop('tagName') ?\n                $(item) :\n                this.valueField.find('option[value=' + item.id + ']');\n        },\n\n        /**\n         * Remove last added option\n         * @private\n         * @param {Object} e - event object\n         */\n        _removeLastAdded: function (e) {\n            var lastAdded = this._getOptions().last();\n\n            if (lastAdded.length) {\n                this.removeOption(e, lastAdded);\n            }\n        },\n\n        /**\n         * Remove item from select options\n         * @param {Object} e - event object\n         * @param {Object} item\n         * @private\n         */\n        removeOption: function (e, item) {\n            var option = this._getOption(item),\n                selectTarget = option.data('selectTarget');\n\n            if (selectTarget && selectTarget.length) {\n                selectTarget.removeClass(this.options.selectedClass);\n            }\n\n            option.data('renderedOption').remove();\n            option.remove();\n        },\n\n        /**\n         * Render visual element of selected item\n         * @param {Object} item - selected item\n         * @private\n         */\n        _renderOption: function (item) {\n            var tmpl = this.choiceTmpl({\n                text: item.label\n            });\n\n            return $(tmpl)\n                .insertBefore(this.elementWrapper)\n                .trigger('contentUpdated')\n                .on('removeOption', $.proxy(function (e) {\n                    this.removeOption(e, item);\n                }, this));\n        }\n    });\n\n    return $.mage.suggest;\n}));\n","mage/backend/validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global BASE_URL, alertAlreadyDisplayed */\n(function (factory) {\n    'use strict';\n\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'underscore',\n            'Magento_Ui/js/modal/alert',\n            'jquery/ui',\n            'jquery/validate',\n            'mage/translate',\n            'mage/validation'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($, _, alert) {\n    'use strict';\n\n    $.extend(true, $.validator.prototype, {\n        /**\n         * Focus invalid fields\n         */\n        focusInvalid: function () {\n            if (this.settings.focusInvalid) {\n                try {\n                    $(this.errorList.length && this.errorList[0].element || [])\n                        .focus()\n                        .trigger('focusin');\n                } catch (e) {\n                    // ignore IE throwing errors when focusing hidden elements\n                }\n            }\n        },\n\n        /**\n         * Elements.\n         */\n        elements: function () {\n            var validator = this,\n                rulesCache = {};\n\n            // select all valid inputs inside the form (no submit or reset buttons)\n            return $(this.currentForm)\n                .find('input, select, textarea')\n                .not(this.settings.forceIgnore)\n                .not(':submit, :reset, :image, [disabled]')\n                .not(this.settings.ignore)\n                .filter(function () {\n                    if (!this.name && validator.settings.debug && window.console) {\n                        console.error('%o has no name assigned', this);\n                    }\n\n                    // select only the first element for each name, and only those with rules specified\n                    if (this.name in rulesCache || !validator.objectLength($(this).rules())) {\n                        return false;\n                    }\n\n                    rulesCache[this.name] = true;\n\n                    return true;\n                });\n        }\n    });\n\n    $.extend($.fn, {\n        /**\n         * ValidationDelegate overridden for those cases where the form is located in another form,\n         *     to avoid not correct working of validate plug-in\n         * @override\n         * @param {String} delegate - selector, if event target matched against this selector,\n         *     then event will be delegated\n         * @param {String} type - event type\n         * @param {Function} handler - event handler\n         * @return {Element}\n         */\n        validateDelegate: function (delegate, type, handler) {\n            return this.on(type, $.proxy(function (event) {\n                var target = $(event.target),\n                    form = target[0].form;\n\n                if (form && $(form).is(this) && $.data(form, 'validator') && target.is(delegate)) {\n                    return handler.apply(target, arguments);\n                }\n            }, this));\n        }\n    });\n\n    $.widget('mage.validation', $.mage.validation, {\n        options: {\n            messagesId: 'messages',\n            forceIgnore: '',\n            ignore: ':disabled, .ignore-validate, .no-display.template, ' +\n                ':disabled input, .ignore-validate input, .no-display.template input, ' +\n                ':disabled select, .ignore-validate select, .no-display.template select, ' +\n                ':disabled textarea, .ignore-validate textarea, .no-display.template textarea',\n            errorElement: 'label',\n            errorUrl: typeof BASE_URL !== 'undefined' ? BASE_URL : null,\n\n            /**\n             * @param {HTMLElement} element\n             */\n            highlight: function (element) {\n                if ($.validator.defaults.highlight && $.isFunction($.validator.defaults.highlight)) {\n                    $.validator.defaults.highlight.apply(this, arguments);\n                }\n                $(element).trigger('highlight.validate');\n            },\n\n            /**\n             * @param {HTMLElement} element\n             */\n            unhighlight: function (element) {\n                if ($.validator.defaults.unhighlight && $.isFunction($.validator.defaults.unhighlight)) {\n                    $.validator.defaults.unhighlight.apply(this, arguments);\n                }\n                $(element).trigger('unhighlight.validate');\n            }\n        },\n\n        /**\n         * Validation creation\n         * @protected\n         */\n        _create: function () {\n            if (!this.options.submitHandler && $.type(this.options.submitHandler) !== 'function') {\n                if (!this.options.frontendOnly && this.options.validationUrl) {\n                    this.options.submitHandler = $.proxy(this._ajaxValidate, this);\n                } else {\n                    this.options.submitHandler = $.proxy(this._submit, this);\n                }\n            }\n            this.element.on('resetElement', function (e) {\n                $(e.target).rules('remove');\n            });\n            this._super('_create');\n        },\n\n        /**\n         * ajax validation\n         * @protected\n         */\n        _ajaxValidate: function () {\n            $.ajax({\n                url: this.options.validationUrl,\n                type: 'POST',\n                dataType: 'json',\n                data: this.element.serialize(),\n                context: $('body'),\n                success: $.proxy(this._onSuccess, this),\n                error: $.proxy(this._onError, this),\n                showLoader: true,\n                dontHide: false\n            });\n        },\n\n        /**\n         * Process ajax success.\n         *\n         * @protected\n         * @param {Object} response\n         */\n        _onSuccess: function (response) {\n            if (!response.error) {\n                this._submit();\n            } else {\n                this._showErrors(response);\n                $(this.element[0]).trigger('afterValidate.error');\n                $('body').trigger('processStop');\n            }\n        },\n\n        /**\n         * Submitting a form.\n         * @private\n         */\n        _submit: function () {\n            $(this.element[0]).trigger('afterValidate.beforeSubmit');\n            this.element[0].submit();\n        },\n\n        /**\n         * Displays errors after backend validation.\n         *\n         * @param {Object} data - Data that came from backend.\n         */\n        _showErrors: function (data) {\n            $('body').notification('clear')\n                .notification('add', {\n                    error: data.error,\n                    message: data.message,\n\n                    /**\n                     * @param {*} message\n                     */\n                    insertMethod: function (message) {\n                        $('.messages:first').html(message);\n                    }\n                });\n        },\n\n        /**\n         * Tries to retrieve element either by id or by inputs' name property.\n         * @param {String} code - String to search by.\n         * @returns {jQuery} jQuery element.\n         */\n        _getByCode: function (code) {\n            var parent = this.element[0],\n                element;\n\n            element = parent.querySelector('#' + code) || parent.querySelector('input[name=' + code + ']');\n\n            return $(element);\n        },\n\n        /**\n         * Process ajax error\n         * @protected\n         */\n        _onError: function () {\n            $(this.element[0]).trigger('afterValidate.error');\n            $('body').trigger('processStop');\n\n            if (this.options.errorUrl) {\n                location.href = this.options.errorUrl;\n            }\n        }\n    });\n\n    _.each({\n        'validate-greater-zero-based-on-option': [\n            function (v, el) {\n                var optionType = $(el)\n                    .closest('.form-list')\n                    .prev('.fieldset-alt')\n                    .find('select.select-product-option-type'),\n                    optionTypeVal = optionType.val();\n\n                v = Number(v) || 0;\n\n                if (optionType && (optionTypeVal == 'checkbox' || optionTypeVal == 'multi') && v <= 0) { //eslint-disable-line\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter a number greater 0 in this field.')\n        ],\n        'validate-rating': [\n            function () {\n                var ratings = $('#detailed_rating').find('.field-rating'),\n                    noError = true;\n\n                ratings.each(function (index, rating) {\n                    noError = noError && $(rating).find('input:checked').length > 0;\n                });\n\n                return noError;\n            },\n            $.mage.__('Please select one of each ratings above.')\n        ],\n        'validate-downloadable-file': [\n            function (v, element) {\n                var elmParent = $(element).parent(),\n                    linkType = elmParent.find('input[value=\"file\"]'),\n                    newFileContainer;\n\n                if (linkType.is(':checked') && (v === '' || v === '[]')) {\n                    newFileContainer = elmParent.find('.new-file');\n\n                    if (!alertAlreadyDisplayed && (newFileContainer.empty() || newFileContainer.is(':visible'))) {\n                        window.alertAlreadyDisplayed = true;\n                        alert({\n                            content: $.mage.__('There are files that were selected but not uploaded yet. ' +\n                            'Please upload or remove them first')\n                        });\n                    }\n\n                    return false;\n                }\n\n                return true;\n            },\n            'Please upload a file.'\n        ],\n        'validate-downloadable-url': [\n            function (v, element) {\n                var linkType = $(element).parent().find('input[value=\"url\"]');\n\n                if (linkType.is(':checked') && v === '') {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please specify Url.')\n        ]\n    }, function (rule, i) {\n        rule.unshift(i);\n        $.validator.addMethod.apply($.validator, rule);\n    });\n\n    return $.mage.validation;\n}));\n","mage/requirejs/baseUrlResolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Sample configuration:\n *\n require.config({\n        \"config\": {\n            \"baseUrlInterceptor\": {\n                \"Magento_Ui/js/lib/knockout/bindings/collapsible.js\": \"../../../../frontend/Magento/luma/en_US/\"\n            }\n        }\n    });\n */\n\n/* global jsSuffixRegExp */\n/* eslint-disable max-depth */\ndefine('baseUrlInterceptor', [\n    'module'\n], function (module) {\n    'use strict';\n\n    /**\n     * RequireJS Context object\n     */\n    var ctx = require.s.contexts._,\n\n        /**\n         * Original function\n         *\n         * @type {Function}\n         */\n        origNameToUrl = ctx.nameToUrl,\n\n        /**\n         * Original function\n         *\n         * @type {Function}\n         */\n        newContextConstr = require.s.newContext;\n\n    /**\n     * Remove dots from URL\n     *\n     * @param {Array} ary\n     */\n    function trimDots(ary) {\n        var i, part, length = ary.length;\n\n        for (i = 0; i < length; i++) {\n            part = ary[i];\n\n            if (part === '.') {\n                ary.splice(i, 1);\n                i -= 1;\n            } else if (part === '..') {\n                if (i === 1 && (ary[2] === '..' || ary[0] === '..')) {\n                    //End of the line. Keep at least one non-dot\n                    //path segment at the front so it can be mapped\n                    //correctly to disk. Otherwise, there is likely\n                    //no path mapping for a path starting with '..'.\n                    //This can still fail, but catches the most reasonable\n                    //uses of ..\n                    break;\n                } else if (i > 0) {\n                    ary.splice(i - 1, 2);\n                    i -= 2;\n                }\n            }\n        }\n    }\n\n    /**\n     * Normalize URL string (remove '/../')\n     *\n     * @param {String} name\n     * @param {String} baseName\n     * @param {Object} applyMap\n     * @param {Object} localContext\n     * @returns {*}\n     */\n    function normalize(name, baseName, applyMap, localContext) {\n        var lastIndex,\n            baseParts = baseName && baseName.split('/'),\n            normalizedBaseParts = baseParts;\n\n        //Adjust any relative paths.\n        if (name && name.charAt(0) === '.') {\n            //If have a base name, try to normalize against it,\n            //otherwise, assume it is a top-level require that will\n            //be relative to baseUrl in the end.\n            if (baseName) {\n                //Convert baseName to array, and lop off the last part,\n                //so that . matches that 'directory' and not name of the baseName's\n                //module. For instance, baseName of 'one/two/three', maps to\n                //'one/two/three.js', but we want the directory, 'one/two' for\n                //this normalization.\n                normalizedBaseParts = baseParts.slice(0, baseParts.length - 1);\n                name = name.split('/');\n                lastIndex = name.length - 1;\n\n                // If wanting node ID compatibility, strip .js from end\n                // of IDs. Have to do this here, and not in nameToUrl\n                // because node allows either .js or non .js to map\n                // to same file.\n                if (localContext.nodeIdCompat && jsSuffixRegExp.test(name[lastIndex])) {\n                    name[lastIndex] = name[lastIndex].replace(jsSuffixRegExp, '');\n                }\n\n                name = normalizedBaseParts.concat(name);\n                trimDots(name);\n                name = name.join('/');\n            } else if (name.indexOf('./') === 0) {\n                // No baseName, so this is ID is resolved relative\n                // to baseUrl, pull off the leading dot.\n                name = name.substring(2);\n            }\n        }\n\n        return name;\n    }\n\n    /**\n     * Get full url.\n     *\n     * @param {Object} context\n     * @param {String} url\n     * @return {String}\n     */\n    function getUrl(context, url) {\n        var baseUrl = context.config.baseUrl,\n            newConfig = context.config,\n            modulePath = url.replace(baseUrl, ''),\n            newBaseUrl,\n            rewrite = module.config()[modulePath];\n\n        if (!rewrite) {\n            return url;\n        }\n\n        newBaseUrl = normalize(rewrite, baseUrl, undefined, newConfig);\n\n        return newBaseUrl + modulePath;\n    }\n\n    /**\n     * Replace original function.\n     *\n     * @returns {*}\n     */\n    ctx.nameToUrl = function () {\n        return getUrl(ctx, origNameToUrl.apply(ctx, arguments));\n    };\n\n    /**\n     * Replace original function.\n     *\n     * @return {*}\n     */\n    require.s.newContext = function () {\n        var newCtx = newContextConstr.apply(require.s, arguments),\n            newOrigNameToUrl = newCtx.nameToUrl;\n\n        /**\n         * New implementation of native function.\n         *\n         * @returns {String}\n         */\n        newCtx.nameToUrl = function () {\n            return getUrl(newCtx, newOrigNameToUrl.apply(newCtx, arguments));\n        };\n\n        return newCtx;\n    };\n});\n\nrequire(['baseUrlInterceptor'], function () {\n    'use strict';\n\n});\n","mage/requirejs/resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'domReady!'\n], function (_) {\n    'use strict';\n\n    var context = require.s.contexts._,\n        execCb = context.execCb,\n        registry = context.registry,\n        callbacks = [],\n        retries = 10,\n        updateDelay = 1,\n        ready,\n        update;\n\n    /**\n     * Checks if provided callback already exists in the callbacks list.\n     *\n     * @param {Object} callback - Callback object to be checked.\n     * @returns {Boolean}\n     */\n    function isSubscribed(callback) {\n        return !!_.findWhere(callbacks, callback);\n    }\n\n    /**\n     * Checks if provided module is rejected during load.\n     *\n     * @param {Object} module - Module to be checked.\n     * @return {Boolean}\n     */\n    function isRejected(module) {\n        return registry[module.id] && (registry[module.id].inited || registry[module.id].error);\n    }\n\n    /**\n     * Checks if provided module has unresolved dependencies.\n     *\n     * @param {Object} module - Module to be checked.\n     * @returns {Boolean}\n     */\n    function isPending(module) {\n        if (!module.depCount) {\n            return false;\n        }\n\n        return module.depCount > _.filter(module.depMaps, isRejected).length;\n    }\n\n    /**\n     * Checks if requirejs's registry object contains pending modules.\n     *\n     * @returns {Boolean}\n     */\n    function hasPending() {\n        return _.some(registry, isPending);\n    }\n\n    /**\n     * Checks if 'resolver' module is in ready\n     * state and that there are no pending modules.\n     *\n     * @returns {Boolean}\n     */\n    function isReady() {\n        return ready && !hasPending();\n    }\n\n    /**\n     * Invokes provided callback handler.\n     *\n     * @param {Object} callback\n     */\n    function invoke(callback) {\n        callback.handler.call(callback.ctx);\n    }\n\n    /**\n     * Sets 'resolver' module to a ready state\n     * and invokes pending callbacks.\n     */\n    function resolve() {\n        ready = true;\n\n        callbacks.splice(0).forEach(invoke);\n    }\n\n    /**\n     * Drops 'ready' flag and runs the update process.\n     */\n    function tick() {\n        ready = false;\n\n        update(retries);\n    }\n\n    /**\n     * Adds callback which will be invoked\n     * when all of the pending modules are initiated.\n     *\n     * @param {Function} handler - 'Ready' event handler function.\n     * @param {Object} [ctx] - Optional context with which handler\n     *      will be invoked.\n     */\n    function subscribe(handler, ctx) {\n        var callback = {\n            handler: handler,\n            ctx: ctx\n        };\n\n        if (!isSubscribed(callback)) {\n            callbacks.push(callback);\n\n            if (isReady()) {\n                _.defer(tick);\n            }\n        }\n    }\n\n    /**\n     * Checks for all modules to be initiated\n     * and invokes pending callbacks if it's so.\n     *\n     * @param {Number} [retry] - Number of retries\n     *      that will be used to repeat the 'update' function\n     *      invokation in case if there are no pending requests.\n     */\n    update = _.debounce(function (retry) {\n        if (!hasPending()) {\n            retry ? update(--retry) : resolve();\n        }\n    }, updateDelay);\n\n    /**\n     * Overrides requirejs's original 'execCb' method\n     * in order to track pending modules.\n     *\n     * @returns {*} Result of original method call.\n     */\n    context.execCb = function () {\n        var exported = execCb.apply(context, arguments);\n\n        tick();\n\n        return exported;\n    };\n\n    return subscribe;\n});\n","mage/requirejs/text.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* inspired by http://github.com/requirejs/text */\n/*global XMLHttpRequest, XDomainRequest */\n\ndefine(['module'], function (module) {\n    'use strict';\n\n    var xmlRegExp = /^\\s*<\\?xml(\\s)+version=[\\'\\\"](\\d)*.(\\d)*[\\'\\\"](\\s)*\\?>/im,\n        bodyRegExp = /<body[^>]*>\\s*([\\s\\S]+)\\s*<\\/body>/im,\n        stripReg = /!strip$/i,\n        defaultConfig = module.config && module.config() || {};\n\n    /**\n     * Strips <?xml ...?> declarations so that external SVG and XML documents can be\n     * added to a document without worry.\n     * Also, if the string is an HTML document, only the part inside the body tag is returned.\n     *\n     * @param {String} external\n     * @returns {String}\n     */\n    function stripContent(external) {\n        var matches;\n\n        if (!external) {\n            return '';\n        }\n\n        matches = external.match(bodyRegExp);\n        external = matches ?\n            matches[1] :\n            external.replace(xmlRegExp, '');\n\n        return external;\n    }\n\n    /**\n     * Checks that url match current location\n     *\n     * @param {String} url\n     * @returns {Boolean}\n     */\n    function sameDomain(url) {\n        var uProtocol, uHostName, uPort,\n            xdRegExp = /^([\\w:]+)?\\/\\/([^\\/\\\\]+)/i,\n            location = window.location,\n            match = xdRegExp.exec(url);\n\n        if (!match) {\n            return true;\n        }\n        uProtocol = match[1];\n        uHostName = match[2];\n\n        uHostName = uHostName.split(':');\n        uPort = uHostName[1] || '';\n        uHostName = uHostName[0];\n\n        return (!uProtocol || uProtocol === location.protocol) &&\n            (!uHostName || uHostName.toLowerCase() === location.hostname.toLowerCase()) &&\n            (!uPort && !uHostName || uPort === location.port);\n    }\n\n    /**\n     * @returns {XMLHttpRequest|XDomainRequest|null}\n     */\n    function createRequest(url) {\n        var xhr = new XMLHttpRequest();\n\n        if (!sameDomain(url) && typeof XDomainRequest !== 'undefined') {\n            xhr = new XDomainRequest();\n        }\n\n        return xhr;\n    }\n\n    /**\n     * XHR requester. Returns value to callback.\n     *\n     * @param {String} url\n     * @param {Function} callback\n     * @param {Function} fail\n     * @param {Object} headers\n     */\n    function getContent(url, callback, fail, headers) {\n        var xhr = createRequest(url),\n            header;\n\n        xhr.open('GET', url);\n\n        /*eslint-disable max-depth */\n        if ('setRequestHeader' in xhr && headers) {\n            for (header in headers) {\n                if (headers.hasOwnProperty(header)) {\n                    xhr.setRequestHeader(header.toLowerCase(), headers[header]);\n                }\n            }\n        }\n\n        /**\n         * @inheritdoc\n         */\n        xhr.onreadystatechange = function () {\n            var status, err;\n\n            //Do not explicitly handle errors, those should be\n            //visible via console output in the browser.\n            if (xhr.readyState === 4) {\n                status = xhr.status || 0;\n\n                if (status > 399 && status < 600) {\n                    //An http 4xx or 5xx error. Signal an error.\n                    err = new Error(url + ' HTTP status: ' + status);\n                    err.xhr = xhr;\n\n                    if (fail) {\n                        fail(err);\n                    }\n                } else {\n                    callback(xhr.responseText);\n\n                    if (defaultConfig.onXhrComplete) {\n                        defaultConfig.onXhrComplete(xhr, url);\n                    }\n                }\n            }\n        };\n\n        /*eslint-enable max-depth */\n\n        if (defaultConfig.onXhr) {\n            defaultConfig.onXhr(xhr, url);\n        }\n\n        xhr.send();\n    }\n\n    /**\n     * Main method used by RequireJs.\n     *\n     * @param {String} name - has format: some.module.filext!strip\n     * @param {Function} req\n     * @param {Function|undefined} onLoad\n     */\n    function loadContent(name, req, onLoad) {\n\n        var toStrip = stripReg.test(name),\n            url = req.toUrl(name.replace(stripReg, '')),\n            headers = defaultConfig.headers;\n\n        getContent(url, function (content) {\n                content = toStrip ? stripContent(content) : content;\n                onLoad(content);\n            }, onLoad.error, headers);\n    }\n\n    return {\n        load: loadContent,\n        get: getContent\n    };\n});\n","mage/apply/main.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    './scripts'\n], function (_, $, processScripts) {\n    'use strict';\n\n    var dataAttr = 'data-mage-init',\n        nodeSelector = '[' + dataAttr + ']';\n\n    /**\n     * Initializes components assigned to a specified element via data-* attribute.\n     *\n     * @param {HTMLElement} el - Element to initialize components with.\n     * @param {Object|String} config - Initial components' config.\n     * @param {String} component - Components' path.\n     */\n    function init(el, config, component) {\n        require([component], function (fn) {\n\n            if (typeof fn === 'object') {\n                fn = fn[component].bind(fn);\n            }\n\n            if (_.isFunction(fn)) {\n                fn(config, el);\n            } else if ($(el)[component]) {\n                $(el)[component](config);\n            }\n        }, function (error) {\n            if ('console' in window && typeof window.console.error === 'function') {\n                console.error(error);\n            }\n\n            return true;\n        });\n    }\n\n    /**\n     * Parses elements 'data-mage-init' attribute as a valid JSON data.\n     * Note: data-mage-init attribute will be removed.\n     *\n     * @param {HTMLElement} el - Element whose attribute should be parsed.\n     * @returns {Object}\n     */\n    function getData(el) {\n        var data = el.getAttribute(dataAttr);\n\n        el.removeAttribute(dataAttr);\n\n        return {\n            el: el,\n            data: JSON.parse(data)\n        };\n    }\n\n    return {\n        /**\n         * Initializes components assigned to HTML elements via [data-mage-init].\n         *\n         * @example Sample 'data-mage-init' declaration.\n         *      data-mage-init='{\"path/to/component\": {\"foo\": \"bar\"}}'\n         */\n        apply: function (context) {\n            var virtuals = processScripts(!context ? document : context),\n                nodes = document.querySelectorAll(nodeSelector);\n\n            _.toArray(nodes)\n                .map(getData)\n                .concat(virtuals)\n                .forEach(function (itemContainer) {\n                    var element = itemContainer.el;\n\n                    _.each(itemContainer.data, function (obj, key) {\n                            if (obj.mixins) {\n                                require(obj.mixins, function () { //eslint-disable-line max-nested-callbacks\n                                    var i, len;\n\n                                    for (i = 0, len = arguments.length; i < len; i++) {\n                                        $.extend(\n                                            true,\n                                            itemContainer.data[key],\n                                            arguments[i](itemContainer.data[key], element)\n                                        );\n                                    }\n\n                                    delete obj.mixins;\n                                    init.call(null, element, obj, key);\n                                });\n                            } else {\n                                init.call(null, element, obj, key);\n                            }\n\n                        }\n                    );\n\n                });\n        },\n        applyFor: init\n    };\n});\n","mage/apply/scripts.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery'\n], function (_, $) {\n    'use strict';\n\n    var scriptSelector = 'script[type=\"text/x-magento-init\"]',\n        dataAttr = 'data-mage-init',\n        virtuals = [];\n\n    /**\n     * Adds components to the virtual list.\n     *\n     * @param {Object} components\n     */\n    function addVirtual(components) {\n        virtuals.push({\n            el: false,\n            data: components\n        });\n    }\n\n    /**\n     * Merges provided data with a current data\n     * of a elements' \"data-mage-init\" attribute.\n     *\n     * @param {Object} components - Object with components and theirs configuration.\n     * @param {HTMLElement} elem - Element whose data should be modified.\n     */\n    function setData(components, elem) {\n        var data = elem.getAttribute(dataAttr);\n\n        data = data ? JSON.parse(data) : {};\n        _.each(components, function (obj, key) {\n            if (_.has(obj, 'mixins')) {\n                data[key] = data[key] || {};\n                data[key].mixins = data[key].mixins || [];\n                data[key].mixins = data[key].mixins.concat(obj.mixins);\n                delete obj.mixins;\n            }\n        });\n\n        data = $.extend(true, data, components);\n        data = JSON.stringify(data);\n        elem.setAttribute(dataAttr, data);\n    }\n\n    /**\n     * Search for the elements by privded selector and extends theirs data.\n     *\n     * @param {Object} components - Object with components and theirs configuration.\n     * @param {String} selector - Selector for the elements.\n     */\n    function processElems(components, selector) {\n        var elems,\n            iterator;\n\n        if (selector === '*') {\n            addVirtual(components);\n\n            return;\n        }\n\n        elems = document.querySelectorAll(selector);\n        iterator = setData.bind(null, components);\n\n        _.toArray(elems).forEach(iterator);\n    }\n\n    /**\n     * Parses content of a provided script node.\n     * Note: node will be removed from DOM.\n     *\n     * @param {HTMLScriptElement} node - Node to be processed.\n     * @returns {Object}\n     */\n    function getNodeData(node) {\n        var data = node.textContent;\n\n        node.parentNode.removeChild(node);\n\n        return JSON.parse(data);\n    }\n\n    /**\n     * Parses 'script' tags with a custom type attribute and moves it's data\n     * to a 'data-mage-init' attribute of an element found by provided selector.\n     * Note: All found script nodes will be removed from DOM.\n     *\n     * @returns {Array} An array of components not assigned to the specific element.\n     *\n     * @example Sample declaration.\n     *      <script type=\"text/x-magento-init\">\n     *          {\n     *              \"body\": {\n     *                  \"path/to/component\": {\"foo\": \"bar\"}\n     *              }\n     *          }\n     *      </script>\n     *\n     * @example Providing data without selector.\n     *      {\n     *          \"*\": {\n     *              \"path/to/component\": {\"bar\": \"baz\"}\n     *          }\n     *      }\n     */\n    return function () {\n        var nodes = document.querySelectorAll(scriptSelector);\n\n        _.toArray(nodes)\n            .map(getNodeData)\n            .forEach(function (item) {\n                _.each(item, processElems);\n            });\n\n        return virtuals.splice(0, virtuals.length);\n    };\n});\n","mage/utils/compare.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'mage/utils/objects'\n], function (_, utils) {\n    'use strict';\n\n    var result = [];\n\n    /**\n     * Checks if all of the provided arrays contains equal values.\n     *\n     * @param {(Boolean|Array)} [keepOrder=false]\n     * @param {Array} target\n     * @returns {Boolean}\n     */\n    function equalArrays(keepOrder, target) {\n        var args = _.toArray(arguments),\n            arrays;\n\n        if (!Array.isArray(keepOrder)) {\n            arrays      = args.slice(2);\n        } else {\n            target      = keepOrder;\n            keepOrder   = false;\n            arrays      = args.slice(1);\n        }\n\n        if (!arrays.length) {\n            return true;\n        }\n\n        return arrays.every(function (array) {\n            if (array === target) {\n                return true;\n            } else if (array.length !== target.length) {\n                return false;\n            } else if (!keepOrder) {\n                return !_.difference(target, array).length;\n            }\n\n            return array.every(function (value, index) {\n                return target[index] === value;\n            });\n        });\n    }\n\n    /**\n     * Checks if two values are different.\n     *\n     * @param {*} a - First value.\n     * @param {*} b - Second value.\n     * @returns {Boolean}\n     */\n    function isDifferent(a, b) {\n        var oldIsPrimitive = utils.isPrimitive(a);\n\n        if (Array.isArray(a) && Array.isArray(b)) {\n            return !equalArrays(true, a, b);\n        }\n\n        return oldIsPrimitive ? a !== b : true;\n    }\n\n    /**\n     * @param {String} prefix\n     * @param {String} part\n     */\n    function getPath(prefix, part) {\n        return prefix ? prefix + '.' + part : part;\n    }\n\n    /**\n     * Checks if object has own specified property.\n     *\n     * @param {*} obj - Value to be checked.\n     * @param {String} key - Key of the property.\n     * @returns {Boolean}\n     */\n    function hasOwn(obj, key) {\n        return Object.prototype.hasOwnProperty.call(obj, key);\n    }\n\n    /**\n     * @param {Array} changes\n     */\n    function getContainers(changes) {\n        var containers  = {},\n            indexed     = _.indexBy(changes, 'path');\n\n        _.each(indexed, function (change, name) {\n            var path;\n\n            name.split('.').forEach(function (part) {\n                path = getPath(path, part);\n\n                if (path in indexed) {\n                    return;\n                }\n\n                (containers[path] = containers[path] || []).push(change);\n            });\n        });\n\n        return containers;\n    }\n\n    /**\n     * @param {String} path\n     * @param {String} name\n     * @param {String} type\n     * @param {String} newValue\n     * @param {String} oldValue\n     */\n    function addChange(path, name, type, newValue, oldValue) {\n        var data;\n\n        data = {\n            path: path,\n            name: name,\n            type: type\n        };\n\n        if (type !== 'remove') {\n            data.value = newValue;\n            data.oldValue = oldValue;\n        } else {\n            data.oldValue = newValue;\n        }\n\n        result.push(data);\n    }\n\n    /**\n     * @param {String} ns\n     * @param {String} name\n     * @param {String} type\n     * @param {String} iterator\n     * @param {String} placeholder\n     */\n    function setAll(ns, name, type, iterator, placeholder) {\n        var key;\n\n        if (arguments.length > 4) {\n            type === 'add' ?\n                addChange(ns, name, 'update', iterator, placeholder) :\n                addChange(ns, name, 'update', placeholder, iterator);\n        } else {\n            addChange(ns, name, type, iterator);\n        }\n\n        if (!utils.isObject(iterator)) {\n            return;\n        }\n\n        for (key in iterator) {\n            if (hasOwn(iterator, key)) {\n                setAll(getPath(ns, key), key, type, iterator[key]);\n            }\n        }\n    }\n\n    /*eslint-disable max-depth*/\n    /**\n     * @param {Object} old\n     * @param {Object} current\n     * @param {String} ns\n     * @param {String} name\n     */\n    function compare(old, current, ns, name) {\n        var key,\n            oldIsObj = utils.isObject(old),\n            newIsObj = utils.isObject(current);\n\n        if (oldIsObj && newIsObj) {\n            for (key in old) {\n                if (hasOwn(old, key) && !hasOwn(current, key)) {\n                    setAll(getPath(ns, key), key, 'remove', old[key]);\n                }\n            }\n\n            for (key in current) {\n                if (hasOwn(current, key)) {\n                    hasOwn(old, key) ?\n                        compare(old[key], current[key], getPath(ns, key), key) :\n                        setAll(getPath(ns, key), key, 'add', current[key]);\n                }\n            }\n        } else if (oldIsObj) {\n            setAll(ns, name, 'remove', old, current);\n        } else if (newIsObj) {\n            setAll(ns, name, 'add', current, old);\n        } else if (isDifferent(old, current)) {\n            addChange(ns, name, 'update', current, old);\n        }\n    }\n\n    /*eslint-enable max-depth*/\n\n    return {\n\n        /**\n         *\n         * @returns {Object}\n         */\n        compare: function () {\n            var changes;\n\n            compare.apply(null, arguments);\n\n            changes = result.splice(0);\n\n            return {\n                containers: getContainers(changes),\n                changes: changes,\n                equal: !changes.length\n            };\n        },\n\n        equalArrays: equalArrays\n    };\n});\n","mage/utils/arrays.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    './strings'\n], function (_, utils) {\n    'use strict';\n\n    /**\n     * Defines index of an item in a specified container.\n     *\n     * @param {*} item - Item whose index should be defined.\n     * @param {Array} container - Container upon which to perform search.\n     * @returns {Number}\n     */\n    function getIndex(item, container) {\n        var index = container.indexOf(item);\n\n        if (~index) {\n            return index;\n        }\n\n        return _.findIndex(container, function (value) {\n            return value && value.name === item;\n        });\n    }\n\n    return {\n        /**\n         * Facade method to remove/add value from/to array\n         * without creating a new instance.\n         *\n         * @param {Array} arr - Array to be modified.\n         * @param {*} value - Value to add/remove.\n         * @param {Boolean} add - Flag that specfies operation.\n         * @returns {Utils} Chainable.\n         */\n        toggle: function (arr, value, add) {\n            return add ?\n                this.add(arr, value) :\n                this.remove(arr, value);\n        },\n\n        /**\n         * Removes the incoming value from array in case\n         * without creating a new instance of it.\n         *\n         * @param {Array} arr - Array to be modified.\n         * @param {*} value - Value to be removed.\n         * @returns {Utils} Chainable.\n         */\n        remove: function (arr, value) {\n            var index = arr.indexOf(value);\n\n            if (~index) {\n                arr.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds the incoming value to array if\n         * it's not alredy present in there.\n         *\n         * @param {Array} arr - Array to be modifed.\n         * @param {...*} arguments - Values to be added.\n         * @returns {Utils} Chainable.\n         */\n        add: function (arr) {\n            var values = _.toArray(arguments).slice(1);\n\n            values.forEach(function (value) {\n                if (!~arr.indexOf(value)) {\n                    arr.push(value);\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Inserts specified item into container at a specified position.\n         *\n         * @param {*} item - Item to be inserted into container.\n         * @param {Array} container - Container of items.\n         * @param {*} [position=-1] - Position at which item should be inserted.\n         *      Position can represent:\n         *          - specific index in container\n         *          - item which might already be present in container\n         *          - structure with one of these properties: after, before\n         * @returns {Boolean|*}\n         *      - true if element has changed its' position\n         *      - false if nothing has changed\n         *      - inserted value if it wasn't present in container\n         */\n        insert: function (item, container, position) {\n            var currentIndex = getIndex(item, container),\n                newIndex,\n                target;\n\n            if (typeof position === 'undefined') {\n                position = -1;\n            } else if (typeof position === 'string') {\n                position = isNaN(+position) ? position : +position;\n            }\n\n            newIndex = position;\n\n            if (~currentIndex) {\n                target = container.splice(currentIndex, 1)[0];\n\n                if (typeof item === 'string') {\n                    item = target;\n                }\n            }\n\n            if (typeof position !== 'number') {\n                target = position.after || position.before || position;\n\n                newIndex = getIndex(target, container);\n\n                if (~newIndex && (position.after || newIndex >= currentIndex)) {\n                    newIndex++;\n                }\n            }\n\n            if (newIndex < 0) {\n                newIndex += container.length + 1;\n            }\n\n            container[newIndex] ?\n                container.splice(newIndex, 0, item) :\n                container[newIndex] = item;\n\n            return !~currentIndex ? item : currentIndex !== newIndex;\n        },\n\n        /**\n         * @param {Array} elems\n         * @param {Number} offset\n         * @return {Number|*}\n         */\n        formatOffset: function (elems, offset) {\n            if (utils.isEmpty(offset)) {\n                offset = -1;\n            }\n\n            offset = +offset;\n\n            if (offset < 0) {\n                offset += elems.length + 1;\n            }\n\n            return offset;\n        }\n    };\n});\n","mage/utils/template.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-shadow */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/utils/objects',\n    'mage/utils/strings'\n], function ($, _, utils, stringUtils) {\n    'use strict';\n\n    var tmplSettings = _.templateSettings,\n        interpolate = /\\$\\{([\\s\\S]+?)\\}/g,\n        opener = '${',\n        template,\n        hasStringTmpls;\n\n    /**\n     * Identifies whether ES6 templates are supported.\n     */\n    hasStringTmpls = (function () {\n        var testString = 'var foo = \"bar\"; return `${ foo }` === foo';\n\n        try {\n            return Function(testString)();\n        } catch (e) {\n            return false;\n        }\n    })();\n\n    /**\n     * Objects can specify how to use templating for their properties - getting that configuration.\n     *\n     * To disable rendering for all properties of your object add __disableTmpl: true.\n     * To disable for specific property add __disableTmpl: {propertyName: true}.\n     * To limit recursion for a specific property add __disableTmpl: {propertyName: numberOfCycles}.\n     *\n     * @param {String} tmpl\n     * @param {Object | undefined} target\n     * @returns {Boolean|Object}\n     */\n    function isTmplIgnored(tmpl, target) {\n        var parsedTmpl;\n\n        try {\n            parsedTmpl = JSON.parse(tmpl);\n\n            if (typeof parsedTmpl === 'object') {\n                return tmpl.includes('__disableTmpl');\n            }\n        } catch (e) {\n        }\n\n        if (typeof target !== 'undefined') {\n            if (typeof target === 'object' && target.hasOwnProperty('__disableTmpl')) {\n                return target.__disableTmpl;\n            }\n        }\n\n        return false;\n\n    }\n\n    if (hasStringTmpls) {\n\n        /*eslint-disable no-unused-vars, no-eval*/\n        /**\n         * Evaluates template string using ES6 templates.\n         *\n         * @param {String} tmpl - Template string.\n         * @param {Object} $ - Data object used in a template.\n         * @returns {String} Compiled template.\n         */\n        template = function (tmpl, $) {\n            return eval('`' + tmpl + '`');\n        };\n\n        /*eslint-enable no-unused-vars, no-eval*/\n    } else {\n\n        /**\n         * Fallback function used when ES6 templates are not supported.\n         * Uses underscore templates renderer.\n         *\n         * @param {String} tmpl - Template string.\n         * @param {Object} data - Data object used in a template.\n         * @returns {String} Compiled template.\n         */\n        template = function (tmpl, data) {\n            var cached = tmplSettings.interpolate;\n\n            tmplSettings.interpolate = interpolate;\n\n            tmpl = _.template(tmpl, {\n                variable: '$'\n            })(data);\n\n            tmplSettings.interpolate = cached;\n\n            return tmpl;\n        };\n    }\n\n    /**\n     * Checks if provided value contains template syntax.\n     *\n     * @param {*} value - Value to be checked.\n     * @returns {Boolean}\n     */\n    function isTemplate(value) {\n        return typeof value === 'string' &&\n            value.indexOf(opener) !== -1 &&\n            // the below pattern almost always indicates an accident which should not cause template evaluation\n            // refuse to evaluate\n            value.indexOf('${{') === -1;\n    }\n\n    /**\n     * Iteratively processes provided string\n     * until no templates syntax will be found.\n     *\n     * @param {String} tmpl - Template string.\n     * @param {Object} data - Data object used in a template.\n     * @param {Boolean} [castString=false] - Flag that indicates whether template\n     *      should be casted after evaluation to a value of another type or\n     *      that it should be leaved as a string.\n     * @param {Number|undefined} maxCycles - Maximum number of rendering cycles, can be 0.\n     * @returns {*} Compiled template.\n     */\n    function render(tmpl, data, castString, maxCycles) {\n        var last = tmpl,\n            cycles = 0;\n\n        while (~tmpl.indexOf(opener) && (typeof maxCycles === 'undefined' || cycles < maxCycles)) {\n            if (!isTmplIgnored(tmpl)) {\n                tmpl = template(tmpl, data);\n            }\n\n            if (tmpl === last) {\n                break;\n            }\n\n            last = tmpl;\n            cycles++;\n        }\n\n        return castString ?\n            stringUtils.castString(tmpl) :\n            tmpl;\n    }\n\n    return {\n\n        /**\n         * Applies provided data to the template.\n         *\n         * @param {Object|String} tmpl\n         * @param {Object} [data] - Data object to match with template.\n         * @param {Boolean} [castString=false] - Flag that indicates whether template\n         *      should be casted after evaluation to a value of another type or\n         *      that it should be leaved as a string.\n         * @returns {*}\n         *\n         * @example Template defined as a string.\n         *      var source = { foo: 'Random Stuff', bar: 'Some' };\n         *\n         *      utils.template('${ $.bar } ${ $.foo }', source);\n         *      => 'Some Random Stuff';\n         *\n         * @example Template defined as an object.\n         *      var tmpl = {\n         *              key: {'${ $.$data.bar }': '${ $.$data.foo }'},\n         *              foo: 'bar',\n         *              x1: 2, x2: 5,\n         *              delta: '${ $.x2 - $.x1 }',\n         *              baz: 'Upper ${ $.foo.toUpperCase() }'\n         *      };\n         *\n         *      utils.template(tmpl, source);\n         *      => {\n         *          key: {'Some': 'Random Stuff'},\n         *          foo: 'bar',\n         *          x1: 2, x2: 5,\n         *          delta: 3,\n         *          baz: 'Upper BAR'\n         *      };\n         */\n        template: function (tmpl, data, castString, dontClone) {\n            if (typeof tmpl === 'string') {\n                return render(tmpl, data, castString);\n            }\n\n            if (!dontClone) {\n                tmpl = utils.copy(tmpl);\n            }\n\n            tmpl.$data = data || {};\n\n            /**\n             * Template iterator function.\n             */\n            _.each(tmpl, function iterate(value, key, list) {\n                var disabled,\n                    maxCycles;\n\n                if (key === '$data') {\n                    return;\n                }\n\n                if (isTemplate(key)) {\n                    delete list[key];\n\n                    key = render(key, tmpl);\n                    list[key] = value;\n                }\n\n                if (isTemplate(value)) {\n                    //Getting template disabling settings, can be true for all disabled and separate settings\n                    //for each property.\n                    disabled = isTmplIgnored(value, list);\n\n                    if (typeof disabled === 'object' && disabled.hasOwnProperty(key) && disabled[key] !== false) {\n                        //Checking if specific settings for a property provided.\n                        maxCycles = disabled[key];\n                    }\n\n                    if (disabled === true || maxCycles === true) {\n                        //Rendering for all properties is disabled.\n                        maxCycles = 0;\n                    }\n\n                    list[key] = render(value, tmpl, castString, maxCycles);\n                } else if ($.isPlainObject(value) || Array.isArray(value)) {\n                    _.each(value, iterate);\n                }\n            });\n\n            delete tmpl.$data;\n\n            return tmpl;\n        }\n    };\n});\n","mage/utils/wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Utility methods used to wrap and extend functions.\n *\n * @example Usage of a 'wrap' method with arguments delegation.\n *      var multiply = function (a, b) {\n *          return a * b;\n *      };\n *\n *      multiply = module.wrap(multiply, function (orig) {\n *          return 'Result is: ' + orig();\n *      });\n *\n *      multiply(2, 2);\n *      => 'Result is: 4'\n *\n * @example Usage of 'wrapSuper' method.\n *      var multiply = function (a, b) {\n *         return a * b;\n *      };\n *\n *      var obj = {\n *          multiply: module.wrapSuper(multiply, function () {\n *              return 'Result is: ' + this._super();\n *          });\n *      };\n *\n *      obj.multiply(2, 2);\n *      => 'Result is: 4'\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    /**\n     * Checks if string has a '_super' substring.\n     */\n    var superReg = /\\b_super\\b/;\n\n    return {\n\n        /**\n         * Wraps target function with a specified wrapper, which will receive\n         * reference to the original function as a first argument.\n         *\n         * @param {Function} target - Function to be wrapped.\n         * @param {Function} wrapper - Wrapper function.\n         * @returns {Function} Wrapper function.\n         */\n        wrap: function (target, wrapper) {\n            if (!_.isFunction(target) || !_.isFunction(wrapper)) {\n                return wrapper;\n            }\n\n            return function () {\n                var args    = _.toArray(arguments),\n                    ctx     = this,\n                    _super;\n\n                /**\n                 * Function that will be passed to the wrapper.\n                 * If no arguments will be passed to it, then the original\n                 * function will be called with an arguments of a wrapper function.\n                 */\n                _super = function () {\n                    var superArgs = arguments.length ? arguments : args.slice(1);\n\n                    return target.apply(ctx, superArgs);\n                };\n\n                args.unshift(_super);\n\n                return wrapper.apply(ctx, args);\n            };\n        },\n\n        /**\n         * Wraps the incoming function to implement support of the '_super' method.\n         *\n         * @param {Function} target - Function to be wrapped.\n         * @param {Function} wrapper - Wrapper function.\n         * @returns {Function} Wrapped function.\n         */\n        wrapSuper: function (target, wrapper) {\n            if (!this.hasSuper(wrapper) || !_.isFunction(target)) {\n                return wrapper;\n            }\n\n            return function () {\n                var _super  = this._super,\n                    args    = arguments,\n                    result;\n\n                /**\n                 * Temporary define '_super' method which\n                 * contains call to the original function.\n                 */\n                this._super = function () {\n                    var superArgs = arguments.length ? arguments : args;\n\n                    return target.apply(this, superArgs);\n                };\n\n                result = wrapper.apply(this, args);\n\n                this._super = _super;\n\n                return result;\n            };\n        },\n\n        /**\n         * Checks wether the incoming method contains calls of the '_super' method.\n         *\n         * @param {Function} fn - Function to be checked.\n         * @returns {Boolean}\n         */\n        hasSuper: function (fn) {\n            return _.isFunction(fn) && superReg.test(fn);\n        },\n\n        /**\n         * Extends target object with provided extenders.\n         * If property in target and extender objects is a function,\n         * then it will be wrapped using 'wrap' method.\n         *\n         * @param {Object} target - Object to be extended.\n         * @param {...Object} extenders - Multiple extenders objects.\n         * @returns {Object} Modified target object.\n         */\n        extend: function (target) {\n            var extenders = _.toArray(arguments).slice(1),\n                iterator = this._extend.bind(this, target);\n\n            extenders.forEach(iterator);\n\n            return target;\n        },\n\n        /**\n         * Same as the 'extend' method, but operates only on one extender object.\n         *\n         * @private\n         * @param {Object} target\n         * @param {Object} extender\n         */\n        _extend: function (target, extender) {\n            _.each(extender, function (value, key) {\n                target[key] = this.wrap(target[key], extender[key]);\n            }, this);\n        }\n    };\n});\n","mage/utils/main.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function (require) {\n    'use strict';\n\n    var utils = {},\n        _ = require('underscore');\n\n    return _.extend(\n        utils,\n        require('./arrays'),\n        require('./compare'),\n        require('./misc'),\n        require('./objects'),\n        require('./strings'),\n        require('./template')\n    );\n});\n","mage/utils/strings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var jsonRe = /^(?:\\{[\\w\\W]*\\}|\\[[\\w\\W]*\\])$/;\n\n    return {\n\n        /**\n         * Attempts to convert string to one of the primitive values,\n         * or to parse it as a valid json object.\n         *\n         * @param {String} str - String to be processed.\n         * @returns {*}\n         */\n        castString: function (str) {\n            try {\n                str = str === 'true' ? true :\n                    str === 'false' ? false :\n                        str === 'null' ? null :\n                            +str + '' === str ? +str :\n                                jsonRe.test(str) ? JSON.parse(str) :\n                                    str;\n            } catch (e) {\n            }\n\n            return str;\n        },\n\n        /**\n         * Splits string by separator if it's possible,\n         * otherwise returns the incoming value.\n         *\n         * @param {(String|Array|*)} str - String to split.\n         * @param {String} [separator=' '] - Seperator based on which to split the string.\n         * @returns {Array|*} Splitted string or the incoming value.\n         */\n        stringToArray: function (str, separator) {\n            separator = separator || ' ';\n\n            return typeof str === 'string' ?\n                str.split(separator) :\n                str;\n        },\n\n        /**\n         * Converts the incoming string which consists\n         * of a specified delimiters into a format commonly used in form elements.\n         *\n         * @param {String} name - The incoming string.\n         * @param {String} [separator='.']\n         * @returns {String} Serialized string.\n         *\n         * @example\n         *      utils.serializeName('one.two.three');\n         *      => 'one[two][three]';\n         */\n        serializeName: function (name, separator) {\n            var result;\n\n            separator = separator || '.';\n            name = name.split(separator);\n\n            result = name.shift();\n\n            name.forEach(function (part) {\n                result += '[' + part + ']';\n            });\n\n            return result;\n        },\n\n        /**\n         * Checks wether the incoming value is not empty,\n         * e.g. not 'null' or 'undefined'\n         *\n         * @param {*} value - Value to check.\n         * @returns {Boolean}\n         */\n        isEmpty: function (value) {\n            return value === '' || _.isUndefined(value) || _.isNull(value);\n        },\n\n        /**\n         * Adds 'prefix' to the 'part' value if it was provided.\n         *\n         * @param {String} prefix\n         * @param {String} part\n         * @returns {String}\n         */\n        fullPath: function (prefix, part) {\n            return prefix ? prefix + '.' + part : part;\n        },\n\n        /**\n         * Splits incoming string and returns its' part specified by offset.\n         *\n         * @param {String} parts\n         * @param {Number} [offset]\n         * @param {String} [delimiter=.]\n         * @returns {String}\n         */\n        getPart: function (parts, offset, delimiter) {\n            delimiter = delimiter || '.';\n            parts = parts.split(delimiter);\n            offset = this.formatOffset(parts, offset);\n\n            parts.splice(offset, 1);\n\n            return parts.join(delimiter) || '';\n        },\n\n        /**\n         * Converts nameThroughCamelCase to name-through-minus\n         *\n         * @param {String} string\n         * @returns {String}\n         */\n        camelCaseToMinus: function camelCaseToMinus(string) {\n            return ('' + string)\n                .split('')\n                .map(function (symbol, index) {\n                    return index ?\n                        symbol.toUpperCase() === symbol ?\n                        '-' + symbol.toLowerCase() :\n                            symbol :\n                        symbol.toLowerCase();\n                })\n                .join('');\n        },\n\n        /**\n         * Converts name-through-minus to nameThroughCamelCase\n         *\n         * @param {String} string\n         * @returns {String}\n         */\n        minusToCamelCase: function minusToCamelCase(string) {\n            return ('' + string)\n                .split('-')\n                .map(function (part, index) {\n                    return index ? part.charAt(0).toUpperCase() + part.slice(1) : part;\n                })\n                .join('');\n        }\n    };\n});\n","mage/utils/objects.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore'\n], function (ko, $, _) {\n    'use strict';\n\n    var primitives = [\n        'undefined',\n        'boolean',\n        'number',\n        'string'\n    ];\n\n    /**\n     * Sets nested property of a specified object.\n     * @private\n     *\n     * @param {Object} parent - Object to look inside for the properties.\n     * @param {Array} path - Splitted path the property.\n     * @param {*} value - Value of the last property in 'path' array.\n     * returns {*} New value for the property.\n     */\n    function setNested(parent, path, value) {\n        var last = path.pop(),\n            len = path.length,\n            pi = 0,\n            part = path[pi];\n\n        for (; pi < len; part = path[++pi]) {\n            if (!_.isObject(parent[part])) {\n                parent[part] = {};\n            }\n\n            parent = parent[part];\n        }\n\n        if (typeof parent[last] === 'function') {\n            parent[last](value);\n        } else {\n            parent[last] = value;\n        }\n\n        return value;\n    }\n\n    /**\n     * Retrieves value of a nested property.\n     * @private\n     *\n     * @param {Object} parent - Object to look inside for the properties.\n     * @param {Array} path - Splitted path the property.\n     * @returns {*} Value of the property.\n     */\n    function getNested(parent, path) {\n        var exists = true,\n            len = path.length,\n            pi = 0;\n\n        for (; pi < len && exists; pi++) {\n            parent = parent[path[pi]];\n\n            if (typeof parent === 'undefined') {\n                exists = false;\n            }\n        }\n\n        if (exists) {\n            if (ko.isObservable(parent)) {\n                parent = parent();\n            }\n\n            return parent;\n        }\n    }\n\n    /**\n     * Removes property from a specified object.\n     * @private\n     *\n     * @param {Object} parent - Object from which to remove property.\n     * @param {Array} path - Splitted path to the property.\n     */\n    function removeNested(parent, path) {\n        var field = path.pop();\n\n        parent = getNested(parent, path);\n\n        if (_.isObject(parent)) {\n            delete parent[field];\n        }\n    }\n\n    return {\n\n        /**\n         * Retrieves or defines objects' property by a composite path.\n         *\n         * @param {Object} data - Container for the properties specified in path.\n         * @param {String} path - Objects' properties divided by dots.\n         * @param {*} [value] - New value for the last property.\n         * @returns {*} Returns value of the last property in chain.\n         *\n         * @example\n         *      utils.nested({}, 'one.two', 3);\n         *      => { one: {two: 3} }\n         */\n        nested: function (data, path, value) {\n            var action = arguments.length > 2 ? setNested : getNested;\n\n            path = path ? path.split('.') : [];\n\n            return action(data, path, value);\n        },\n\n        /**\n         * Removes nested property from an object.\n         *\n         * @param {Object} data - Data source.\n         * @param {String} path - Path to the property e.g. 'one.two.three'\n         */\n        nestedRemove: function (data, path) {\n            path = path.split('.');\n\n            removeNested(data, path);\n        },\n\n        /**\n         * Flattens objects' nested properties.\n         *\n         * @param {Object} data - Object to flatten.\n         * @param {String} [separator='.'] - Objects' keys separator.\n         * @returns {Object} Flattened object.\n         *\n         * @example Example with a default separator.\n         *      utils.flatten({one: { two: { three: 'value'} }});\n         *      => { 'one.two.three': 'value' };\n         *\n         * @example Example with a custom separator.\n         *      utils.flatten({one: { two: { three: 'value'} }}, '=>');\n         *      => {'one=>two=>three': 'value'};\n         */\n        flatten: function (data, separator, parent, result) {\n            separator = separator || '.';\n            result = result || {};\n\n            _.each(data, function (node, name) {\n                if (parent) {\n                    name = parent + separator + name;\n                }\n\n                typeof node === 'object' ?\n                    this.flatten(node, separator, name, result) :\n                    result[name] = node;\n\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Opposite operation of the 'flatten' method.\n         *\n         * @param {Object} data - Previously flattened object.\n         * @param {String} [separator='.'] - Keys separator.\n         * @returns {Object} Object with nested properties.\n         *\n         * @example Example using custom separator.\n         *      utils.unflatten({'one=>two': 'value'}, '=>');\n         *      => {\n         *          one: { two: 'value' }\n         *      };\n         */\n        unflatten: function (data, separator) {\n            var result = {};\n\n            separator = separator || '.';\n\n            _.each(data, function (value, nodes) {\n                nodes = nodes.split(separator);\n\n                setNested(result, nodes, value);\n            });\n\n            return result;\n        },\n\n        /**\n         * Same operation as 'flatten' method,\n         * but returns objects' keys wrapped in '[]'.\n         *\n         * @param {Object} data - Object that should be serialized.\n         * @returns {Object} Serialized data.\n         *\n         * @example\n         *      utils.serialize({one: { two: { three: 'value'} }});\n         *      => { 'one[two][three]': 'value' }\n         */\n        serialize: function (data) {\n            var result = {};\n\n            data = this.flatten(data);\n\n            _.each(data, function (value, keys) {\n                keys = this.serializeName(keys);\n                value = _.isUndefined(value) ? '' : value;\n\n                result[keys] = value;\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Performs deep extend of specified objects.\n         *\n         * @returns {Object|Array} Extended object.\n         */\n        extend: function () {\n            var args = _.toArray(arguments);\n\n            args.unshift(true);\n\n            return $.extend.apply($, args);\n        },\n\n        /**\n         * Performs a deep clone of a specified object.\n         *\n         * @param {(Object|Array)} data - Data that should be copied.\n         * @returns {Object|Array} Cloned object.\n         */\n        copy: function (data) {\n            var result = data,\n                isArray = Array.isArray(data),\n                placeholder;\n\n            if (this.isObject(data) || isArray) {\n                placeholder = isArray ? [] : {};\n                result = this.extend(placeholder, data);\n            }\n\n            return result;\n        },\n\n        /**\n         * Performs a deep clone of a specified object.\n         * Doesn't save links to original object.\n         *\n         * @param {*} original - Object to clone\n         * @returns {*}\n         */\n        hardCopy: function (original) {\n            if (original === null || typeof original !== 'object') {\n                return original;\n            }\n\n            return JSON.parse(JSON.stringify(original));\n        },\n\n        /**\n         * Removes specified nested properties from the target object.\n         *\n         * @param {Object} target - Object whose properties should be removed.\n         * @param {(...String|Array|Object)} list - List that specifies properties to be removed.\n         * @returns {Object} Modified object.\n         *\n         * @example Basic usage\n         *      var obj = {a: {b: 2}, c: 'a'};\n         *\n         *      omit(obj, 'a.b');\n         *      => {'a.b': 2};\n         *      obj => {a: {}, c: 'a'};\n         *\n         * @example Various syntaxes that would return same result\n         *      omit(obj, ['a.b', 'c']);\n         *      omit(obj, 'a.b', 'c');\n         *      omit(obj, {'a.b': true, 'c': true});\n         */\n        omit: function (target, list) {\n            var removed = {},\n                ignored = list;\n\n            if (this.isObject(list)) {\n                ignored = [];\n\n                _.each(list, function (value, key) {\n                    if (value) {\n                        ignored.push(key);\n                    }\n                });\n            } else if (_.isString(list)) {\n                ignored = _.toArray(arguments).slice(1);\n            }\n\n            _.each(ignored, function (path) {\n                var value = this.nested(target, path);\n\n                if (!_.isUndefined(value)) {\n                    removed[path] = value;\n\n                    this.nestedRemove(target, path);\n                }\n            }, this);\n\n            return removed;\n        },\n\n        /**\n         * Checks if provided value is a plain object.\n         *\n         * @param {*} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        isObject: function (value) {\n            var objProto = Object.prototype;\n\n            return typeof value == 'object' ?\n            objProto.toString.call(value) === '[object Object]' :\n                false;\n        },\n\n        /**\n         *\n         * @param {*} value\n         * @returns {Boolean}\n         */\n        isPrimitive: function (value) {\n            return value === null || ~primitives.indexOf(typeof value);\n        },\n\n        /**\n         * Iterates over obj props/array elems recursively, applying action to each one\n         *\n         * @param {Object|Array} data - Data to be iterated.\n         * @param {Function} action - Callback to be called with each item as an argument.\n         * @param {Number} [maxDepth=7] - Max recursion depth.\n         */\n        forEachRecursive: function (data, action, maxDepth) {\n            maxDepth = typeof maxDepth === 'number' && !isNaN(maxDepth) ? maxDepth - 1 : 7;\n\n            if (!_.isFunction(action) || _.isFunction(data) || maxDepth < 0) {\n                return;\n            }\n\n            if (!_.isObject(data)) {\n                action(data);\n\n                return;\n            }\n\n            _.each(data, function (value) {\n                this.forEachRecursive(value, action, maxDepth);\n            }, this);\n\n            action(data);\n        },\n\n        /**\n         * Maps obj props/array elems recursively\n         *\n         * @param {Object|Array} data - Data to be iterated.\n         * @param {Function} action - Callback to transform each item.\n         * @param {Number} [maxDepth=7] - Max recursion depth.\n         *\n         * @returns {Object|Array}\n         */\n        mapRecursive: function (data, action, maxDepth) {\n            var newData;\n\n            maxDepth = typeof maxDepth === 'number' && !isNaN(maxDepth) ? maxDepth - 1 : 7;\n\n            if (!_.isFunction(action) || _.isFunction(data) || maxDepth < 0) {\n                return data;\n            }\n\n            if (!_.isObject(data)) {\n                return action(data);\n            }\n\n            if (_.isArray(data)) {\n                newData = _.map(data, function (item) {\n                    return this.mapRecursive(item, action, maxDepth);\n                }, this);\n\n                return action(newData);\n            }\n\n            newData = _.mapObject(data, function (val, key) {\n                if (data.hasOwnProperty(key)) {\n                    return this.mapRecursive(val, action, maxDepth);\n                }\n\n                return val;\n            }, this);\n\n            return action(newData);\n        },\n\n        /**\n         * Removes empty(in common sence) obj props/array elems\n         *\n         * @param {*} data - Data to be cleaned.\n         * @returns {*}\n         */\n        removeEmptyValues: function (data) {\n            if (!_.isObject(data)) {\n                return data;\n            }\n\n            if (_.isArray(data)) {\n                return data.filter(function (item) {\n                    return !this.isEmptyObj(item);\n                }, this);\n            }\n\n            return _.omit(data, this.isEmptyObj.bind(this));\n        },\n\n        /**\n         * Checks that argument of any type is empty in common sence:\n         * empty string, string with spaces only, object without own props, empty array, null or undefined\n         *\n         * @param {*} val - Value to be checked.\n         * @returns {Boolean}\n         */\n        isEmptyObj: function (val) {\n\n            return _.isObject(val) && _.isEmpty(val) ||\n            this.isEmpty(val) ||\n            val && val.trim && this.isEmpty(val.trim());\n        }\n    };\n});\n","mage/utils/misc.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'FormData'\n], function (_, $) {\n    'use strict';\n\n    var defaultAttributes,\n        ajaxSettings,\n        map;\n\n    defaultAttributes = {\n        method: 'post',\n        enctype: 'multipart/form-data'\n    };\n\n    ajaxSettings = {\n        default: {\n            method: 'POST',\n            cache: false,\n            processData: false,\n            contentType: false\n        },\n        simple: {\n            method: 'POST',\n            dataType: 'json'\n        }\n    };\n\n    map = {\n        'D': 'DDD',\n        'dd': 'DD',\n        'd': 'D',\n        'EEEE': 'dddd',\n        'EEE': 'ddd',\n        'e': 'd',\n        'yyyy': 'YYYY',\n        'yy': 'YY',\n        'y': 'YYYY',\n        'a': 'A'\n    };\n\n    return {\n\n        /**\n         * Generates a unique identifier.\n         *\n         * @param {Number} [size=7] - Length of a resulting identifier.\n         * @returns {String}\n         */\n        uniqueid: function (size) {\n            var code = Math.random() * 25 + 65 | 0,\n                idstr = String.fromCharCode(code);\n\n            size = size || 7;\n\n            while (idstr.length < size) {\n                code = Math.floor(Math.random() * 42 + 48);\n\n                if (code < 58 || code > 64) {\n                    idstr += String.fromCharCode(code);\n                }\n            }\n\n            return idstr;\n        },\n\n        /**\n         * Limits function call.\n         *\n         * @param {Object} owner\n         * @param {String} target\n         * @param {Number} limit\n         */\n        limit: function (owner, target, limit) {\n            var fn = owner[target];\n\n            owner[target] = _.debounce(fn.bind(owner), limit);\n        },\n\n        /**\n         * Converts mage date format to a moment.js format.\n         *\n         * @param {String} mageFormat\n         * @returns {String}\n         */\n        normalizeDate: function (mageFormat) {\n            var result = mageFormat;\n\n            _.each(map, function (moment, mage) {\n                result = result.replace(mage, moment);\n            });\n\n            return result;\n        },\n\n        /**\n         * Puts provided value in range of min and max parameters.\n         *\n         * @param {Number} value - Value to be located.\n         * @param {Number} min - Min value.\n         * @param {Number} max - Max value.\n         * @returns {Number}\n         */\n        inRange: function (value, min, max) {\n            return Math.min(Math.max(min, value), max);\n        },\n\n        /**\n         * Serializes and sends data via POST request.\n         *\n         * @param {Object} options - Options object that consists of\n         *      a 'url' and 'data' properties.\n         * @param {Object} attrs - Attributes that will be added to virtual form.\n         */\n        submit: function (options, attrs) {\n            var form        = document.createElement('form'),\n                data        = this.serialize(options.data),\n                attributes  = _.extend({}, defaultAttributes, attrs || {});\n\n            if (!attributes.action) {\n                attributes.action = options.url;\n            }\n\n            data['form_key'] = window.FORM_KEY;\n\n            _.each(attributes, function (value, name) {\n                form.setAttribute(name, value);\n            });\n\n            data = _.map(\n                data,\n                function (value, name) {\n                    return '<input type=\"hidden\" ' +\n                        'name=\"' + _.escape(name) + '\" ' +\n                        'value=\"' + _.escape(value) + '\"' +\n                        ' />';\n                }\n            ).join('');\n\n            form.insertAdjacentHTML('afterbegin', data);\n            document.body.appendChild(form);\n\n            form.submit();\n        },\n\n        /**\n         * Serializes and sends data via AJAX POST request.\n         *\n         * @param {Object} options - Options object that consists of\n         *      a 'url' and 'data' properties.\n         * @param {Object} config\n         */\n        ajaxSubmit: function (options, config) {\n            var t = new Date().getTime(),\n                settings;\n\n            options.data['form_key'] = window.FORM_KEY;\n            options.data = this.prepareFormData(options.data, config.ajaxSaveType);\n            settings = _.extend({}, ajaxSettings[config.ajaxSaveType], options || {});\n\n            if (!config.ignoreProcessEvents) {\n                $('body').trigger('processStart');\n            }\n\n            return $.ajax(settings)\n                .done(function (data) {\n                    if (config.response) {\n                        data.t = t;\n                        config.response.data(data);\n                        config.response.status(undefined);\n                        config.response.status(!data.error);\n                    }\n                })\n                .fail(function () {\n                    config.response.status(undefined);\n                    config.response.status(false);\n                    config.response.data({\n                        error: true,\n                        messages: 'Something went wrong.',\n                        t: t\n                    });\n                })\n                .always(function () {\n                    if (!config.ignoreProcessEvents) {\n                        $('body').trigger('processStop');\n                    }\n                });\n        },\n\n        /**\n         * Creates FormData object and append this data.\n         *\n         * @param {Object} data\n         * @param {String} type\n         * @returns {FormData}\n         */\n        prepareFormData: function (data, type) {\n            var formData;\n\n            if (type === 'default') {\n                formData = new FormData();\n                _.each(this.serialize(data), function (val, name) {\n                    formData.append(name, val);\n                });\n            } else if (type === 'simple') {\n                formData = this.serialize(data);\n            }\n\n            return formData;\n        },\n\n        /**\n         * Filters data object. Finds properties with suffix\n         * and sets their values to properties with the same name without suffix.\n         *\n         * @param {Object} data - The data object that should be filtered\n         * @param {String} suffix - The string by which data object should be filtered\n         * @param {String} separator - The string that is separator between property and suffix\n         *\n         * @returns {Object} Filtered data object\n         */\n        filterFormData: function (data, suffix, separator) {\n            data = data || {};\n            suffix = suffix || 'prepared-for-send';\n            separator = separator || '-';\n\n            _.each(data, function (value, key) {\n                if (_.isObject(value) && !value.length) {\n                    this.filterFormData(value, suffix, separator);\n                } else if (_.isString(key) && ~key.indexOf(suffix)) {\n                    data[key.split(separator)[0]] = value;\n                    delete data[key];\n                }\n            }, this);\n\n            return data;\n        },\n\n        /**\n         * Replaces symbol codes with their unescaped counterparts.\n         *\n         * @param {String} data\n         *\n         * @returns {String}\n         */\n        unescape: function (data) {\n            var unescaped = _.unescape(data),\n                mapCharacters = {\n                    '&#039;': '\\''\n                };\n\n            _.each(mapCharacters, function (value, key) {\n                unescaped = unescaped.replace(key, value);\n            });\n\n            return unescaped;\n        },\n\n        /**\n         * Converts PHP IntlFormatter format to moment format.\n         *\n         * @param {String} format - PHP format\n         * @returns {String} - moment compatible formatting\n         */\n        convertToMomentFormat: function (format) {\n            var newFormat;\n\n            newFormat = format.replace(/yyyy|yy|y/, 'YYYY'); // replace the year\n            newFormat = newFormat.replace(/dd|d/g, 'DD'); // replace the date\n\n            return newFormat;\n        },\n\n        /**\n         * Get Url Parameters.\n         *\n         * @param {String} url - Url string\n         * @returns {Object}\n         */\n        getUrlParameters: function (url) {\n            var params = {},\n                queries = url.split('?'),\n                temp,\n                i,\n                l;\n\n            if (!queries[1]) {\n                return params;\n            }\n\n            queries = queries[1].split('&');\n\n            for (i = 0, l = queries.length; i < l; i++) {\n                temp = queries[i].split('=');\n\n                if (temp[1]) {\n                    params[temp[0]] = decodeURIComponent(temp[1].replace(/\\+/g, '%20'));\n                } else {\n                    params[temp[0]] = '';\n                }\n            }\n\n            return params;\n        }\n    };\n});\n","mage/view/composite.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\n/* eslint-disable strict */\ndefine(['jquery'], function ($) {\n    return function () {\n        var renderedChildren = {},\n            children = {};\n\n        return {\n            /**\n             * @param {*} child\n             * @param {String} key\n             */\n            addChild: function (child, key) {\n                children[key] = child;\n            },\n\n            /**\n             * @param {*} root\n             */\n            render: function (root) {\n                $.each(children, function (key, child) {\n                    var childRoot = $('<div>');\n\n                    renderedChildren[key] = child.render(childRoot);\n                    root.append(childRoot);\n                });\n            }\n        };\n    };\n});\n","mage/validation/url.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n\n        /**\n         * Redirects to the url if it is considered safe\n         *\n         * @param {String} path - url to be redirected to\n         */\n        redirect: function (path) {\n            path = this.sanitize(path);\n\n            if (this.validate(path)) {\n                window.location.href = path;\n            }\n        },\n\n        /**\n         * Validates url\n         *\n         * @param {Object} path - url to be validated\n         * @returns {Boolean}\n         */\n        validate: function (path) {\n            var hostname = window.location.hostname;\n\n            if (path.indexOf(hostname) === -1 ||\n                path.indexOf('javascript:') !== -1 ||\n                path.indexOf('vbscript:') !== -1) {\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Sanitize url, replacing disallowed chars\n         *\n         * @param {String} path - url to be normalized\n         * @returns {String}\n         */\n        sanitize: function (path) {\n            return path.replace('[^-A-Za-z0-9+&@#/%?=~_|!:,.;\\(\\)]', '');\n        }\n    };\n});\n","mage/msie/file-reader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * Init \"readAsBinaryString\" function for FileReader class.\n     * It need for IE11\n     * @param {Blob} fileData\n     */\n    var readAsBinaryStringIEFunc = function (fileData) {\n        var binary = '',\n            self = this,\n            reader = new FileReader();\n\n        /**\n         * Read file as binary string\n         */\n        reader.onload = function () {\n            var bytes, length, index;\n\n            /* eslint-disable no-undef */\n            bytes = new Uint8Array(reader.result);\n            /* eslint-enable */\n            length = bytes.length;\n\n            for (index = 0; index < length; index++) {\n                binary += String.fromCharCode(bytes[index]);\n            }\n            //self.result  - readonly so assign binary\n            self.content = binary;\n            $(self).trigger('onload');\n        };\n        reader.readAsArrayBuffer(fileData);\n    };\n\n    if (typeof FileReader.prototype.readAsBinaryString === 'undefined') {\n        FileReader.prototype.readAsBinaryString = readAsBinaryStringIEFunc;\n    }\n});\n","Magento_AuthorizenetAcceptjs/js/authorizenet.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/alert',\n    'Magento_AuthorizenetAcceptjs/js/view/payment/acceptjs-client'\n], function ($, Class, alert, AcceptjsClient) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            acceptjsClient: null,\n            $selector: null,\n            selector: 'edit_form',\n            container: 'payment_form_authorizenet_acceptjs',\n            active: false,\n            imports: {\n                onActiveChange: 'active'\n            }\n        },\n\n        /**\n         * @{inheritdoc}\n         */\n        initConfig: function (config) {\n            this._super();\n\n            this.acceptjsClient = AcceptjsClient({\n                environment: config.environment\n            });\n\n            return this;\n        },\n\n        /**\n         * @{inheritdoc}\n         */\n        initObservable: function () {\n            this.$selector = $('#' + this.selector);\n            this._super()\n                .observe('active');\n\n            // re-init payment method events\n            this.$selector.off('changePaymentMethod.' + this.code)\n                .on('changePaymentMethod.' + this.code, this.changePaymentMethod.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Enable/disable current payment method\n         *\n         * @param {Object} event\n         * @param {String} method\n         * @returns {Object}\n         */\n        changePaymentMethod: function (event, method) {\n            this.active(method === this.code);\n\n            return this;\n        },\n\n        /**\n         * Triggered when payment changed\n         *\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n\n                return;\n            }\n\n            this.disableEventListeners();\n\n            window.order.addExcludedPaymentMethod(this.code);\n\n            this.enableEventListeners();\n        },\n\n        /**\n         * Sets the payment details on the form\n         *\n         * @param {Object} tokens\n         */\n        setPaymentDetails: function (tokens) {\n            var $ccNumber = $(this.getSelector('cc_number')),\n                ccLast4 = $ccNumber.val().replace(/[^\\d]/g, '').substr(-4);\n\n            $(this.getSelector('opaque_data_descriptor')).val(tokens.opaqueDataDescriptor);\n            $(this.getSelector('opaque_data_value')).val(tokens.opaqueDataValue);\n            $(this.getSelector('cc_last_4')).val(ccLast4);\n            $ccNumber.val('');\n            $(this.getSelector('cc_exp_month')).val('');\n            $(this.getSelector('cc_exp_year')).val('');\n\n            if (this.useCvv) {\n                $(this.getSelector('cc_cid')).val('');\n            }\n        },\n\n        /**\n         * Trigger order submit\n         */\n        submitOrder: function () {\n            var authData = {},\n                cardData = {},\n                secureData = {};\n\n            this.$selector.validate().form();\n            this.$selector.trigger('afterValidate.beforeSubmit');\n\n            authData.clientKey = this.clientKey;\n            authData.apiLoginID = this.apiLoginID;\n\n            cardData.cardNumber = $(this.getSelector('cc_number')).val();\n            cardData.month = $(this.getSelector('cc_exp_month')).val();\n            cardData.year = $(this.getSelector('cc_exp_year')).val();\n\n            if (this.useCvv) {\n                cardData.cardCode = $(this.getSelector('cc_cid')).val();\n            }\n\n            secureData.authData = authData;\n            secureData.cardData = cardData;\n\n            this.disableEventListeners();\n\n            this.acceptjsClient.createTokens(secureData)\n                .always(function () {\n                    $('body').trigger('processStop');\n                    this.enableEventListeners();\n                }.bind(this))\n                .done(function (tokens) {\n                    this.setPaymentDetails(tokens);\n                    this.placeOrder();\n                }.bind(this))\n                .fail(function (messages) {\n                    this.tokens = null;\n\n                    if (messages.length > 0) {\n                        this._showError(messages[0]);\n                    }\n                }.bind(this));\n\n            return false;\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            this.$selector.trigger('realOrder');\n        },\n\n        /**\n         * Get jQuery selector\n         *\n         * @param {String} field\n         * @returns {String}\n         */\n        getSelector: function (field) {\n            return '#' + this.code + '_' + field;\n        },\n\n        /**\n         * Show alert message\n         *\n         * @param {String} message\n         */\n        _showError: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Enable form event listeners\n         */\n        enableEventListeners: function () {\n            this.$selector.on('submitOrder.authorizenetacceptjs', this.submitOrder.bind(this));\n        },\n\n        /**\n         * Disable form event listeners\n         */\n        disableEventListeners: function () {\n            this.$selector.off('submitOrder');\n            this.$selector.off('submit');\n        }\n\n    });\n});\n","Magento_AuthorizenetAcceptjs/js/payment-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_AuthorizenetAcceptjs/js/authorizenet',\n    'jquery'\n], function (AuthorizenetAcceptjs, $) {\n    'use strict';\n\n    return function (config, element) {\n        var $form = $(element);\n\n        config.active = $form.length > 0 && !$form.is(':hidden');\n        new AuthorizenetAcceptjs(config);\n    };\n});\n","Magento_AuthorizenetAcceptjs/js/view/payment/validator-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_AuthorizenetAcceptjs/js/view/payment/response-validator'\n], function ($, responseValidator) {\n    'use strict';\n\n    return {\n        validators: [],\n\n        /**\n         * Init list of validators\n         */\n        initialize: function () {\n            this.add(responseValidator);\n        },\n\n        /**\n         * Add new validator\n         * @param {Object} validator\n         */\n        add: function (validator) {\n            this.validators.push(validator);\n        },\n\n        /**\n         * Run pull of validators\n         * @param {Object} context\n         * @param {Function} callback\n         */\n        validate: function (context, callback) {\n            var self = this,\n                deferred;\n\n            // no available validators\n            if (!self.validators.length) {\n                callback(true);\n\n                return;\n            }\n\n            // get list of deferred validators\n            deferred = $.map(self.validators, function (current) {\n                return current.validate(context);\n            });\n\n            $.when.apply($, deferred)\n                .done(function () {\n                    callback(true);\n                }).fail(function (error) {\n                    callback(false, error);\n                });\n        }\n    };\n});\n","Magento_AuthorizenetAcceptjs/js/view/payment/response-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($, $t) {\n    'use strict';\n\n    return {\n        /**\n         * Validate Authorizenet-Acceptjs response\n         *\n         * @param {Object} context\n         * @returns {jQuery.Deferred}\n         */\n        validate: function (context) {\n            var state = $.Deferred(),\n                messages = [];\n\n            if (context.messages.resultCode === 'Ok') {\n                state.resolve();\n            } else {\n                if (context.messages.message.length > 0) {\n                    $.each(context.messages.message, function (index, element) {\n                        messages.push($t(element.text));\n                    });\n                }\n                state.reject(messages);\n            }\n\n            return state.promise();\n        }\n    };\n});\n\n","Magento_AuthorizenetAcceptjs/js/view/payment/acceptjs-client.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiClass',\n    'Magento_AuthorizenetAcceptjs/js/view/payment/acceptjs-factory',\n    'Magento_AuthorizenetAcceptjs/js/view/payment/validator-handler'\n], function ($, Class, acceptjsFactory, validatorHandler) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            environment: 'production'\n        },\n\n        /**\n         * @{inheritdoc}\n         */\n        initialize: function () {\n            validatorHandler.initialize();\n\n            this._super();\n\n            return this;\n        },\n\n        /**\n         * Creates the token pair with the provided data\n         *\n         * @param {Object} data\n         * @return {jQuery.Deferred}\n         */\n        createTokens: function (data) {\n            var deferred = $.Deferred();\n\n            if (this.acceptjsClient) {\n                this._createTokens(deferred, data);\n            } else {\n                acceptjsFactory(this.environment)\n                    .done(function (client) {\n                        this.acceptjsClient = client;\n                        this._createTokens(deferred, data);\n                    }.bind(this));\n            }\n\n            return deferred.promise();\n        },\n\n        /**\n         * Creates a token from the payment information in the form\n         *\n         * @param {jQuery.Deferred} deferred\n         * @param {Object} data\n         */\n        _createTokens: function (deferred, data) {\n            this.acceptjsClient.dispatchData(data, function (response) {\n                validatorHandler.validate(response, function (valid, messages) {\n                    if (valid) {\n                        deferred.resolve({\n                            opaqueDataDescriptor: response.opaqueData.dataDescriptor,\n                            opaqueDataValue: response.opaqueData.dataValue\n                        });\n                    } else {\n                        deferred.reject(messages);\n                    }\n                });\n            });\n        }\n    });\n});\n","Magento_AuthorizenetAcceptjs/js/view/payment/acceptjs-factory.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (environment) {\n        var deferred = $.Deferred(),\n            dependency = 'acceptjs';\n\n        if (environment === 'sandbox') {\n            dependency = 'acceptjssandbox';\n        }\n\n        require([dependency], function (accept) {\n                var $body = $('body');\n\n                /*\n                 * Acceptjs doesn't safely load dependent files which leads to a race condition when trying to use\n                 * the sdk right away.\n                 * @see https://community.developer.authorize.net/t5/Integration-and-Testing/\n                 * Dynamically-loading-Accept-js-E-WC-03-Accept-js-is-not-loaded/td-p/63283\n                 */\n                $body.on('handshake.acceptjs', function () {\n                    deferred.resolve(accept);\n                    $body.off('handshake.acceptjs');\n                });\n            },\n            deferred.reject\n        );\n\n        return deferred.promise();\n    };\n});\n","Magento_Cms/js/folder-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui',\n    'jquery/jstree/jquery.jstree'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.folderTree', {\n        options: {\n            root: 'root',\n            rootName: 'Root',\n            url: '',\n            currentPath: ['root'],\n            tree: {\n                'plugins': ['themes', 'json_data', 'ui', 'hotkeys'],\n                'themes': {\n                    'theme': 'default',\n                    'dots': false,\n                    'icons': true\n                }\n            }\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var options = this.options,\n                treeOptions = $.extend(\n                    true,\n                    {},\n                    options.tree,\n                    {\n                        'json_data': {\n                            data: {\n                                data: options.rootName,\n                                state: 'closed',\n                                metadata: {\n                                    node: {\n                                        id: options.root,\n                                        text: options.rootName\n                                    }\n                                },\n                                attr: {\n                                    'data-id': options.root,\n                                    id: options.root\n                                }\n                            },\n                            ajax: {\n                                url: options.url,\n\n                                /**\n                                 * @param {Object} node\n                                 * @return {Object}\n                                 */\n                                data: function (node) {\n                                    return {\n                                        node: node.data('id'),\n                                        'form_key': window.FORM_KEY\n                                    };\n                                },\n                                success: this._convertData\n                            }\n                        }\n                    }\n                );\n\n            this.element.jstree(treeOptions).on('loaded.jstree', $.proxy(this.treeLoaded, this));\n        },\n\n        /**\n         * Tree loaded.\n         */\n        treeLoaded: function () {\n            var path = this.options.currentPath,\n                tree = this.element,\n                lastExistentFolderEl,\n\n                /**\n                 * Recursively open folders specified in path array.\n                 */\n                recursiveOpen = function () {\n                    var folderEl = $('[data-id=\"' + path.pop() + '\"]');\n\n                    // if folder doesn't exist, select the last opened folder\n                    if (!folderEl.length) {\n                        tree.jstree('select_node', lastExistentFolderEl);\n\n                        return;\n                    }\n\n                    lastExistentFolderEl = folderEl;\n\n                    if (path.length) {\n                        tree.jstree('open_node', folderEl, recursiveOpen);\n                    } else {\n                        tree.jstree('open_node', folderEl, function () {\n                            tree.jstree('select_node', folderEl);\n                        });\n                    }\n                };\n\n            recursiveOpen();\n        },\n\n        /**\n         * @param {*} data\n         * @return {*}\n         * @private\n         */\n        _convertData: function (data) {\n            return $.map(data, function (node) {\n                var codeCopy = $.extend({}, node);\n\n                return {\n                    data: node.text,\n                    attr: {\n                        'data-id': node.id,\n                        id: node.id\n                    },\n                    metadata: {\n                        node: codeCopy\n                    },\n                    state: node.state || 'closed'\n                };\n            });\n        }\n    });\n\n    return $.mage.folderTree;\n});\n","Magento_CatalogInventory/js/components/use-config-settings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (checkbox) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: '',\n            linkedValue: ''\n        },\n\n        /**\n         * @returns {Element}\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig', 'linkedValue']);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        'onCheckedChanged': function (newChecked) {\n            if (newChecked) {\n                this.linkedValue(this.valueFromConfig());\n            }\n\n            this._super(newChecked);\n        }\n    });\n});\n","Magento_CatalogInventory/js/components/use-config-min-sale-qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'underscore',\n    'uiRegistry'\n], function (checkbox, _, registry) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: ''\n        },\n\n        /**\n         * @returns {Element}\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig']);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super();\n            this.onCheckedChanged(this.checked());\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        'onCheckedChanged': function (newChecked) {\n            var valueFromConfig = this.valueFromConfig();\n\n            if (newChecked && (_.isArray(valueFromConfig) && valueFromConfig.length === 0 || valueFromConfig === 1)) {\n                this.changeVisibleDisabled(this.inputField, true, true, 1);\n            } else if (newChecked && _.isObject(valueFromConfig)) {\n                this.changeVisibleDisabled(this.inputField, false, true, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, true, true, null);\n            } else if (newChecked && _.isNumber(valueFromConfig)) {\n                this.changeVisibleDisabled(this.inputField, true, true, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, false, true, null);\n            } else {\n                this.changeVisibleDisabled(this.inputField, true, false, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, false, true, null);\n            }\n\n            this._super(newChecked);\n        },\n\n        /**\n         * Change visible and disabled\n         *\n         * @param {String} filter\n         * @param {Boolean} visible\n         * @param {Boolean} disabled\n         * @param {Null|Number} valueFromConfig\n         */\n        changeVisibleDisabled: function (filter, visible, disabled, valueFromConfig) {\n            registry.async(filter)(\n                function (currentComponent) {\n                    var initialValue = currentComponent.initialValue;\n\n                    if (_.isString(initialValue) || initialValue === 0 || valueFromConfig === 1) {\n                        currentComponent.value(1);\n                    } else if (initialValue) {\n                        currentComponent.value(initialValue);\n                    }\n\n                    currentComponent.visible(visible);\n                    currentComponent.disabled(disabled);\n                }\n            );\n        }\n    });\n});\n","Magento_CatalogInventory/js/components/qty-validator-changer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            valueUpdate: 'input'\n        },\n\n        /**\n         * Change validator\n         */\n        handleChanges: function (value) {\n            var isDigits = value !== 1;\n\n            this.validation['validate-integer'] = isDigits;\n            this.validation['less-than-equals-to'] = isDigits ? 99999999 : 99999999.9999;\n            this.validate();\n        }\n    });\n});\n","Dotdigitalgroup_Email/js/dashboard.js":"define(['jquery', 'domReady!'], function ($) {\n    'use strict';\n\n    /**\n     * @param {String} id\n     * @param {String} link\n     */\n    function bind(id, link) {\n        $('#' + id).click(function () {\n            window.location.assign(link);\n        });\n    }\n\n    /**\n     * export/return\n     */\n    return function (dasboard) {\n        bind('contact_sync', dasboard.contactLink);\n        bind('importer_sync', dasboard.importerLink);\n    };\n});\n","Dotdigitalgroup_Email/js/datePickerInit.js":"require(['jquery', 'jquery/ui', 'domReady!'], function ($) {\n    'use strict';\n\n    var el = $('.ddg-datepicker');\n\n    el.datepicker({\n        dateFormat: 'yy-mm-dd'\n    });\n    el.addClass('datepicker');\n});\n","Dotdigitalgroup_Email/js/addressBook.js":"define(['jquery','domReady!'], function ($) {\n    'use strict';\n\n    /**\n     * Initializer\n     * @param {String} url\n     */\n    function init(url) {\n        $('#sync_settings_dynamic_addressbook_addressbook_button').click(function () {\n            var name = $('#sync_settings_dynamic_addressbook_addressbook_name').val(),\n                visibility = $('#sync_settings_dynamic_addressbook_visibility').val();\n\n            if (name && visibility) {\n                $.post(url, {\n                    name: name, visibility: visibility\n                }, function () {\n                    window.location.reload();\n                });\n            }\n        });\n    }\n\n    /**\n     * Export/return addressBook\n     * @param {Object} addressBook\n     */\n    return function (addressBook) {\n        init(addressBook.url);\n    };\n});\n","Dotdigitalgroup_Email/js/daterange.js":"require(['jquery', 'domReady!'], function ($) {\n    'use strict';\n\n    $(document).ready(function () {\n\n        /**\n         * Update url params\n         * @param {String} uri\n         * @param {String} key\n         * @param {String} value\n         * @returns {String}\n         */\n        function updateUrlParameter(uri, key, value) {\n            var re = new RegExp('([?&])' + key + '=.*?(&|$)', 'i'),\n                separator = uri.indexOf('?') !== -1 ? '&' : '?';\n\n            if (uri.match(re)) {\n                uri = uri.replace(re, '$1' + key + '=' + value + '$2');\n            } else {\n                uri = uri + separator + key + '=' + value;\n            }\n\n            return uri;\n        }\n\n        /**\n         * Change urls\n         * @param {String} value\n         */\n        function changeUrls(value) {\n            var elmToChange =\n                [\n                    '#connector_developer_settings_sync_settings_reset_orders',\n                    '#connector_developer_settings_sync_settings_reset_reviews',\n                    '#connector_developer_settings_sync_settings_reset_wishlists',\n                    '#connector_developer_settings_sync_settings_reset_catalog'\n                ];\n\n            $.each(elmToChange, function (k, v) {\n                var str = $(v).attr('onclick'),\n                    updatedUrl = updateUrlParameter(str, value, encodeURIComponent($('#' + value).val()));\n\n                $(v).attr('onclick', updatedUrl);\n            });\n        }\n\n        /**\n         * Observe change on given element\n         * @param {String} value\n         */\n        function observeChange(value) {\n            $('#' + value).change(function () {\n                changeUrls(value);\n            });\n        }\n\n        /**\n         * Init\n         */\n        function start() {\n            var elmToObserve = ['from', 'to'];\n\n            $.each(elmToObserve, function (key, value) {\n                observeChange(value);\n            });\n        }\n\n        start();\n    });\n});\n","Dotdigitalgroup_Email/js/dataFields.js":"define(['jquery', 'domReady!'], function ($) {\n    'use strict';\n\n    /**\n     * Initializer\n     * @param {String} url\n     */\n    function init(url) {\n        $('#connector_data_mapping_dynamic_datafield_datafield_button').click(function () {\n            var name = $('#connector_data_mapping_dynamic_datafield_datafield_name').val(),\n                type = $('#connector_data_mapping_dynamic_datafield_datafield_type').val(),\n                defaultVal = $('#connector_data_mapping_dynamic_datafield_datafield_default').val(),\n                access = $('#connector_data_mapping_dynamic_datafield_datafield_access').val();\n\n            if (name && type && access) {\n                $.post(url, {\n                    name: name, type: type, default: defaultVal, visibility: access\n                }, function () {\n                    window.location.reload();\n                });\n            }\n        });\n    }\n\n    /**\n     * Export/return dataFields\n     * @param {Object} dataFields\n     */\n    return function (dataFields) {\n        init(dataFields.url);\n    };\n});\n","Dotdigitalgroup_Email/js/preview.js":"require(['jquery', 'domReady!'], function ($j) {\n    'use strict';\n\n    /**\n     * Apply styles\n     * @param {String} styles\n     * @param {Object} element\n     */\n    function applyStyle(styles, element) {\n        element.css({\n            'font-weight': 'normal', 'font-style': 'normal', 'text-decoration': 'none'\n        });\n        $j.each(styles, function (index, style) {\n            switch (style) {\n                case 'nostyle':\n                    element.css({\n                        'font-weight': 'normal', 'font-style': 'normal', 'text-decoration': 'none'\n                    });\n                    break;\n\n                case 'bold':\n                    element.css('font-weight', 'bold');\n                    break;\n\n                case 'italic':\n                    element.css('font-style', 'italic');\n                    break;\n\n                case 'underline':\n                    element.css('text-decoration', 'underline');\n                    break;\n            }\n        });\n    }\n\n    /**\n     * Filter styles\n     * @param {String} id\n     * @param {String} value\n     */\n    function updateStyle(id, value) {\n        var link = $j('#' + 'connector_configuration_dynamic_content_style_link-preview'),\n            name = $j('#' + 'connector_configuration_dynamic_content_style_name-preview'),\n            doc = $j('#' + 'connector_configuration_dynamic_content_style_doc-preview'),\n            price = $j('#' + 'connector_configuration_dynamic_content_style_price-preview'),\n            coupon = $j('#' + 'connector_configuration_dynamic_content_style_coupon-preview');\n\n        switch (id) {\n            case 'connector_configuration_dynamic_content_style_font_color':\n                name.css('color', value);\n                break;\n\n            case 'connector_configuration_dynamic_content_style_font_size':\n                name.css('font-size', value);\n                break;\n\n            case 'connector_configuration_dynamic_content_style_font_style':\n                applyStyle(value, name);\n                break;\n\n            case 'connector_configuration_dynamic_content_style_price_color':\n                price.css('color', value);\n                break;\n\n            case 'connector_configuration_dynamic_content_style_price_font_size':\n                price.css('font-size', value);\n                break;\n\n            case 'connector_configuration_dynamic_content_style_price_font_style':\n                applyStyle(value, price);\n                break;\n\n            case 'connector_configuration_dynamic_content_style_product_link_color':\n                link.css('color', value);\n                break;\n\n            case 'connector_configuration_dynamic_content_style_product_link_font_size':\n                link.css('font-size', value);\n                break;\n\n            case 'connector_configuration_dynamic_content_style_product_link_style':\n                applyStyle(value, link);\n                break;\n\n            case 'connector_configuration_dynamic_content_style_font':\n                doc.css('font-family', value);\n                break;\n\n            case 'connector_configuration_dynamic_content_style_color':\n                doc.css('background-color', value);\n                break;\n\n            case 'connector_configuration_dynamic_content_style_coupon_font_color':\n                coupon.css('color', value);\n                break;\n\n            case 'connector_configuration_dynamic_content_style_coupon_font_size':\n                coupon.css('font-size', value);\n                break;\n\n            case 'connector_configuration_dynamic_content_style_coupon_font_picker':\n                coupon.css('font-family', value);\n                break;\n\n            case 'connector_configuration_dynamic_content_style_coupon_background_color':\n                coupon.css('background-color', value);\n                break;\n\n            case 'connector_configuration_dynamic_content_style_coupon_font_style':\n                applyStyle(value, coupon);\n                break;\n        }\n    }\n\n    /**\n     * Initial function\n     */\n    function init() {\n        var s = $j('#ddg-edc-preview'),\n            pos = s.position(),\n            elementsA = [\n                $j('#connector_configuration_dynamic_content_style_font_color'),\n                $j('#connector_configuration_dynamic_content_style_font_size'),\n                $j('#connector_configuration_dynamic_content_style_price_color'),\n                $j('#connector_configuration_dynamic_content_style_price_font_size'),\n                $j('#connector_configuration_dynamic_content_style_product_link_color'),\n                $j('#connector_configuration_dynamic_content_style_product_link_font_size'),\n                $j('#connector_configuration_dynamic_content_style_font'),\n                $j('#connector_configuration_dynamic_content_style_color'),\n                $j('#connector_configuration_dynamic_content_style_coupon_font_color'),\n                $j('#connector_configuration_dynamic_content_style_coupon_font_size'),\n                $j('#connector_configuration_dynamic_content_style_coupon_font_picker'),\n                $j('#connector_configuration_dynamic_content_style_coupon_background_color')\n            ],\n            elementsB = [\n                $j('#connector_configuration_dynamic_content_style_font_style'),\n                $j('#connector_configuration_dynamic_content_style_price_font_style'),\n                $j('#connector_configuration_dynamic_content_style_product_link_style'),\n                $j('#connector_configuration_dynamic_content_style_coupon_font_style')\n            ];\n\n        $j(window).scroll(function () {\n            var windowpos = $j(window).scrollTop();\n\n            if (windowpos >= pos.top &&\n                windowpos <\n                $j('#connector_configuration_dynamic_content_style_coupon_font_style').position().top - 350) {\n                s.attr('style', ''); //kill absolute positioning\n                s.css({\n                    position: 'fixed', top: '80px', left: $j(document).innerWidth() - 250\n                });\n            } else if (windowpos >=\n                $j('#connector_configuration_dynamic_content_style_coupon_font_style').position().top - 350) {\n                s.css({\n                    position: 'absolute',\n                    top:\n                    $j('#connector_configuration_dynamic_content_style_coupon_font_style').position().top - 350 + 'px',\n                    left: $j(document).innerWidth() - 250\n                });\n            } else {\n                s.css({\n                    position: 'absolute',\n                    top: pos.top + 'px',\n                    left: $j(document).innerWidth() - 250\n                });\n            }\n        });\n\n        $j(window).resize(function () {\n            $j('#ddg-edc-preview').css({\n                left: $j(document).innerWidth() - 250\n            });\n        });\n\n        $j.each(elementsA, function (index, element) {\n            var id = element.attr('id'),\n                value = element.val();\n\n            updateStyle(id, value);\n            $j(element).on('change keyup blur input', function () {\n                id = element.attr('id');\n                value = element.val();\n                updateStyle(id, value);\n            });\n        });\n        $j.each(elementsB, function (index, element) {\n            var id = element.attr('id'),\n                value = element.val();\n\n            updateStyle(id, value);\n            $j(element).on('change', function () {\n                id = element.attr('id');\n                value = element.val();\n                updateStyle(id, value);\n            });\n        });\n    }\n\n    //initialise\n    init();\n});\n","Dotdigitalgroup_Email/js/switcher.js":"define([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'domReady!'\n], function (jQuery, confirm) {\n    'use strict';\n\n    /**\n     * Init\n     * @param {Int} useConfirm\n     * @param {String} getContent\n     * @param {Int} objVal\n     * @param {Boolean} isIframe\n     * @param {String} switchUrl\n     */\n    function init(useConfirm, getContent, objVal, isIframe, switchUrl) {\n        var scopeSwitcherHandler;\n\n        (function ($) {\n            var $storesList = $('[data-role=stores-list]');\n\n            $storesList.on('click', '[data-value]', function (event) {\n                var val = $(event.target).data('value'),\n                    role = $(event.target).data('role'),\n                    switcher = $('[data-role=' + role + ']');\n\n                event.preventDefault();\n\n                if (!switcher.val() || val !== switcher.val()) {\n                    switcher.val(val).trigger('change'); // Set the value & trigger event\n                }\n            });\n        })(jQuery);\n\n        /**\n         * Switch scope\n         * @param {Object} obj\n         */\n        function switchScope(obj) {\n            var switcher = jQuery(obj),\n                scopeId = switcher.val(),\n                scopeParams = '',\n                switcherParams;\n\n            /**\n             * Reload\n             */\n            function reload() {\n                var url;\n\n                if (!isIframe) {\n                    url = switchUrl + scopeParams;\n                    window.location.href = url;\n                } else {\n                    jQuery('#preview_selected_store').val(scopeId);\n                    jQuery('#preview_form').submit();\n\n                    jQuery('.store-switcher .dropdown-menu li a').each(function () {\n                        var $this = jQuery(this);\n\n                        if ($this.data('role') === 'store-view-id' && $this.data('value') === scopeId) {\n                            jQuery('#store-change-button').html($this.text());\n                        }\n                    });\n\n                    jQuery('#store-change-button').click();\n                }\n            }\n\n            if (scopeId) {\n                scopeParams = switcher.data('param') + '/' + scopeId + '/';\n            }\n\n            if (obj.switchParams) {\n                scopeParams += obj.switchParams;\n            }\n\n            if (typeof scopeSwitcherHandler !== 'undefined') {\n                switcherParams = {\n                    scopeId: scopeId,\n                    scopeParams: scopeParams,\n                    useConfirm: useConfirm\n                };\n                scopeSwitcherHandler(switcherParams);\n            } else if (useConfirm) {\n                confirm({\n                    content: getContent,\n                    actions: {\n\n                        /**\n                         * Confirm\n                         */\n                        confirm: function () {\n                            reload();\n                        },\n\n                        /**\n                         * Cancel\n                         */\n                        cancel: function () {\n                            obj.value = objVal;\n                        }\n                    }\n                });\n            } else {\n                reload();\n            }\n        }\n\n        window.scopeSwitcherHandler = scopeSwitcherHandler;\n        window.switchScope = switchScope;\n    }\n\n    /**\n     *\n     * @param {Object} switcher\n     */\n    return function (switcher) {\n        init(\n            switcher.getUseConfirm,\n            switcher.getContent,\n            switcher.objVal,\n            switcher.isUsingIframe,\n            switcher.getSwitchUrl\n        );\n    };\n});\n","Dotdigitalgroup_Email/js/confirm.js":"require([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'mage/translate',\n    'domReady!'\n], function ($, confirmation, $t) {\n    'use strict';\n\n    /**\n     * Show confirmation widget\n     * @param {Object} element\n     */\n    function showConfirmation(element) {\n        var content;\n\n        if (element.attr('id') === 'sync_settings_addressbook_allow_non_subscribers') {\n            content = $t('You are about to allow dotdigital to import customers that haven\\'t explicitly opted into your emails. This means Customers and Guests address book will contain contacts that you might not be able to reach out, depending on the applicable regulations. Do you wish to continue?');\n        } else {\n            content = $t('You are about to enable this feature for customers that haven\\'t explicitly opted into your emails. Do you wish to continue?');\n        }\n\n        confirmation({\n            title: $('label[for=' + element.attr('id') + '] span').text(),\n            content: content,\n            actions: {\n                /**\n                 * Confirm.\n                 */\n                confirm: function () {\n                    element.val(1);\n                },\n                /**\n                 * Reset.\n                 */\n                cancel: function () {\n                    element.val(0);\n                }\n            }\n        });\n    }\n\n    /**\n     * Init function\n     */\n    function init() {\n        var elements = [\n            $('#connector_automation_review_settings_allow_non_subscribers'),\n            $('#connector_configuration_abandoned_carts_allow_non_subscribers'),\n            $('#sync_settings_addressbook_allow_non_subscribers')\n        ];\n\n        $.each(elements, function (index, element) {\n            $(element).on('change', function () {\n                if (element.val() === '1') {\n                    showConfirmation(element);\n                }\n            });\n        });\n    }\n\n    //initialise\n    init();\n});\n","Dotdigitalgroup_Email/js/colorPickerInit.js":"require(['jquery', 'domReady!'], function ($) {\n    'use strict';\n\n    $('.ddg-colpicker').colpick({\n        /**\n         * @param {String} hsb\n         * @param {String} hex\n         * @param {String} rgb\n         * @param {String} el\n         */\n        onChange: function (hsb, hex, rgb, el) {\n            $(el).val('#' + hex);\n        }\n    });\n});\n","Dotdigitalgroup_Email/js/fancyBoxInit.js":"require(['jquery', 'fancybox', 'domReady!'], function ($) {\n    'use strict';\n\n    var fb = $('.ddg-fancyBox');\n\n    if (fb && fb !== null) {\n        fb.fancybox({\n            width: 508,\n            height: 670,\n            scrolling: 'no',\n            hideOnOverlayClick: false,\n            helpers: {\n                overlay: {\n                    closeClick: false\n                }\n            }\n        });\n\n        $(document).on('click', 'a.fancybox-close', function () {\n            location.reload();\n        });\n\n        window.addEventListener('message', function (event) {\n            if (event.origin !== 'https://magentosignup.dotmailer.com') {\n                return;\n            }\n\n            if (event.data === 'close') {\n                location.reload();\n            }\n        });\n    }\n});\n","Dotdigitalgroup_Email/js/logUpdater.js":"define(['jquery', 'domReady!'], function ($) {\n    'use strict';\n\n    /**\n     * scroll to the bottom of text\n     */\n    function consoleScroll() {\n        var logData = document.getElementById('log_data'),\n            dh = logData.scrollHeight,\n            ch = logData.clientHeight;\n\n        if (dh > ch) {\n            logData.scrollTop = dh - ch;\n        }\n    }\n\n    /**\n     * Update elements\n     * @param {String} log\n     * @param {String} url\n     */\n    function doUpdate(log, url) {\n        $.post(url, {\n            log: log\n        }, function (json) {\n            $('#log_data').html(json.content);\n            $('#connector-log-header').html(json.header);\n            consoleScroll();\n        });\n    }\n\n    /**\n     * Export/return log updater\n     * @param {Object} logUpdater\n     */\n    return function (logUpdater) {\n        consoleScroll();\n\n        //Observer select\n        $('#connector-log-selector').change(function () {\n            doUpdate($('#connector-log-selector').val(), logUpdater.url);\n        });\n\n        //Observe button click for reload\n        $('#connector-log-reloader').click(function () {\n            doUpdate($('#connector-log-selector').val(), logUpdater.url);\n        });\n    };\n});\n","Dotdigitalgroup_Email/js/rulesDatafields.js":"define(['prototype', 'domReady!'], function () {\n    'use strict';\n\n    /**\n     * Do update for condition\n     * @param {Object} item\n     * @param {String} url\n     */\n    function doUpdateForCondition(item, url) {\n        var attribute = item.up(1).down(),\n            attributeValue = attribute.down().value,\n            value = item.up().next(),\n            valueName = value.down().readAttribute('name'),\n            condValue = item.value;\n\n        new Ajax.Request(url, {\n            method: 'post',\n            parameters: {\n                attributeValue: attributeValue,\n                value: valueName,\n                condValue: condValue\n            },\n\n            /**\n             * @param {Object} transport\n             */\n            onSuccess: function (transport) {\n                var json = transport.responseJSON;\n\n                value.update(json.cvalue);\n            }\n        });\n    }\n\n    /**\n     * @param {Object} item\n     * @param {String} url\n     * @param {String} valueAjaxUrl\n     */\n    function doUpdate(item, url, valueAjaxUrl) {\n        var cond = item.up(1).down().next(),\n            condName = cond.down().readAttribute('name'),\n            value = item.up(1).down().next(1),\n            valueName = value.down().readAttribute('name'),\n            attribute = item.value;\n\n        new Ajax.Request(url, {\n            method: 'post',\n            parameters: {\n                attribute: attribute,\n                condition: condName,\n                value: valueName\n            },\n\n            /**\n             * @param {Object} transport\n             */\n            onSuccess: function (transport) {\n                var json = transport.responseJSON;\n\n                cond.update(json.condition);\n                value.update(json.cvalue);\n\n                $$('.admin__control-table tr td select').each(function (itemToObserve) {\n                    Event.observe(itemToObserve, 'change', function () {\n                        if (itemToObserve.readAttribute('title') === 'conditions') {\n                            doUpdateForCondition(itemToObserve, valueAjaxUrl);\n                        }\n                    });\n                });\n            }\n        });\n    }\n\n    /**\n     * Do update with values\n     * @param {Object} item\n     * @param {String} url\n     * @param {String} valueAjaxUrl\n     */\n    function doUpdateWithValues(item, url, valueAjaxUrl) {\n        var arrayKey = item.up(1).readAttribute('id'),\n            cond = item.up(1).down().next(),\n            condName = cond.down().readAttribute('name'),\n            value = item.up(1).down().next(1),\n            valueName = value.down().readAttribute('name'),\n            attribute = item.value,\n            ruleId = $('rule_id').value;\n\n        new Ajax.Request(url, {\n            method: 'post',\n            parameters: {\n                attribute: attribute,\n                condition: condName,\n                value: valueName,\n                arraykey: arrayKey,\n                ruleid: ruleId\n            },\n\n            /**\n             * @param {Object} transport\n             */\n            onSuccess: function (transport) {\n                var json = transport.responseJSON;\n\n                cond.update(json.condition);\n                value.update(json.cvalue);\n\n                $$('.admin__control-table tr td select').each(function (itemToObserve) {\n                    Event.observe(itemToObserve, 'change', function () {\n                        if (itemToObserve.readAttribute('title') === 'conditions') {\n                            doUpdateForCondition(itemToObserve, valueAjaxUrl);\n                        }\n                    });\n                });\n            }\n        });\n    }\n\n    /**\n     * Observe on click add new condition\n     * @param {String} ajaxUrl\n     * @param {String} valueAjaxUrl\n     */\n    function observeOnClickAddNewCondition(ajaxUrl, valueAjaxUrl) {\n        $$('.admin__control-table tr td:first-child select').each(function (item) {\n            Event.observe(item, 'change', function () {\n                doUpdate(item, ajaxUrl, valueAjaxUrl);\n            });\n        });\n        $$('.admin__control-table tr td select').each(function (item) {\n            Event.observe(item, 'change', function () {\n                if (item.readAttribute('title') === 'conditions') {\n                    doUpdateForCondition(item, valueAjaxUrl);\n                }\n            });\n        });\n    }\n\n    /**\n     * init\n     * @param {String} ajaxUrl\n     * @param {String} selectAjaxUrl\n     * @param {String} valueAjaxUrl\n     */\n    function init(ajaxUrl, selectAjaxUrl, valueAjaxUrl) {\n        $$('.admin__control-table tr td:first-child select').each(function (item) {\n            doUpdateWithValues(item, selectAjaxUrl, valueAjaxUrl);\n        });\n\n        $$('.admin__control-table tr td:first-child select').each(function (item) {\n            Event.observe(item, 'change', function () {\n                doUpdate(item, ajaxUrl, valueAjaxUrl);\n            });\n        });\n\n        $$('.admin__control-table button.action-add').each(function (item) {\n            Event.observe(item, 'click', function () {\n                observeOnClickAddNewCondition(ajaxUrl, valueAjaxUrl);\n            });\n        });\n    }\n\n    /**\n     * export/return\n     * @param {Object} rules\n     */\n    return function (rules) {\n        init(\n            rules.ajaxUrl,\n            rules.selectAjaxUrl,\n            rules.valueAjaxUrl\n        );\n    };\n});\n","Dotdigitalgroup_Email/js/clickToCopy.js":"require(['jquery',\r\n    'jquery/ui',\r\n    'domReady!',\r\n    'mage/translate'], function ($) {\r\n    'use strict';\r\n    \r\n    function removeTooltip(element)\r\n    {\r\n        element.css('position','');\r\n        $('.ddg-tooltip').remove();\r\n    }\r\n\r\n    function addTooltip(toolTipText,element)\r\n    {\r\n        element.attr('data-title', toolTipText);\r\n        element.parent().append(\"<div class='ddg-tooltip'>\" + toolTipText + \"</div>\");\r\n        element.parent().css('position','relative');\r\n    }\r\n\r\n    $('.ddg-dynamic-content').click(function(){\r\n        var toolTipText = $.mage.__('Copied!');\r\n\r\n        $(this).select();\r\n        removeTooltip($(this));\r\n        addTooltip(toolTipText,$(this));\r\n        setTimeout(function() {\r\n\r\n            removeTooltip($(this));\r\n        }, 850);\r\n        document.execCommand(\"copy\");\r\n    });\r\n\r\n    $('.ddg-dynamic-content').hover( function() {\r\n            var toolTipText = $.mage.__('Click to copy URL');\r\n\r\n            addTooltip(toolTipText,$(this));\r\n        }\r\n        ,function() {\r\n            removeTooltip($(this));\r\n        }\r\n    );\r\n\r\n});\r\n\r\n","Dotdigitalgroup_Email/js/node_modules/colpick/colpick.js":"/*!\n * colpick Color Picker\n * https://github.com/mrgrain/colpick\n *\n * Copyright 2013, 2015 Moritz Kornher, Jose Vargas, Stefan Petre\n * Released under the MIT license and GPLv2 license\n * https://github.com/mrgrain/colpick/blob/master/LICENSE\n */\nrequire(['jquery'], (function ($) {\n    var colpick = function () {\n        var\n            tpl = '<div class=\"colpick\"><div class=\"colpick_color\"><div class=\"colpick_color_overlay1\"><div class=\"colpick_color_overlay2\"><div class=\"colpick_selector_outer\"><div class=\"colpick_selector_inner\"></div></div></div></div></div><div class=\"colpick_hue\"><div class=\"colpick_hue_arrs\"><div class=\"colpick_hue_larr\"></div><div class=\"colpick_hue_rarr\"></div></div></div><div class=\"colpick_new_color\"></div><div class=\"colpick_current_color\"></div><div class=\"colpick_hex_field\"><div class=\"colpick_field_letter\">#</div><input type=\"text\" maxlength=\"6\" size=\"6\" /></div><div class=\"colpick_rgb_r colpick_field\"><div class=\"colpick_field_letter\">R</div><input type=\"text\" maxlength=\"3\" size=\"3\" /><div class=\"colpick_field_arrs\"><div class=\"colpick_field_uarr\"></div><div class=\"colpick_field_darr\"></div></div></div><div class=\"colpick_rgb_g colpick_field\"><div class=\"colpick_field_letter\">G</div><input type=\"text\" maxlength=\"3\" size=\"3\" /><div class=\"colpick_field_arrs\"><div class=\"colpick_field_uarr\"></div><div class=\"colpick_field_darr\"></div></div></div><div class=\"colpick_rgb_b colpick_field\"><div class=\"colpick_field_letter\">B</div><input type=\"text\" maxlength=\"3\" size=\"3\" /><div class=\"colpick_field_arrs\"><div class=\"colpick_field_uarr\"></div><div class=\"colpick_field_darr\"></div></div></div><div class=\"colpick_hsb_h colpick_field\"><div class=\"colpick_field_letter\">H</div><input type=\"text\" maxlength=\"3\" size=\"3\" /><div class=\"colpick_field_arrs\"><div class=\"colpick_field_uarr\"></div><div class=\"colpick_field_darr\"></div></div></div><div class=\"colpick_hsb_s colpick_field\"><div class=\"colpick_field_letter\">S</div><input type=\"text\" maxlength=\"3\" size=\"3\" /><div class=\"colpick_field_arrs\"><div class=\"colpick_field_uarr\"></div><div class=\"colpick_field_darr\"></div></div></div><div class=\"colpick_hsb_b colpick_field\"><div class=\"colpick_field_letter\">B</div><input type=\"text\" maxlength=\"3\" size=\"3\" /><div class=\"colpick_field_arrs\"><div class=\"colpick_field_uarr\"></div><div class=\"colpick_field_darr\"></div></div></div><div class=\"colpick_submit\"></div></div>',\n            defaults = {\n                showEvent: 'click',\n                onShow: function () {\n                },\n                onBeforeShow: function () {\n                },\n                onHide: function () {\n                },\n                onChange: function () {\n                },\n                onSubmit: function () {\n                },\n                colorScheme: 'light',\n                color: 'auto',\n                livePreview: true,\n                flat: false,\n                layout: 'full',\n                submit: 1,\n                submitText: 'OK',\n                height: 156,\n                polyfill: false,\n                styles: false\n            },\n        //Fill the inputs of the plugin\n            fillRGBFields = function (hsb, cal) {\n                var rgb = hsbToRgb(hsb);\n                $(cal).data('colpick').fields\n                    .eq(1).val(rgb.r).end()\n                    .eq(2).val(rgb.g).end()\n                    .eq(3).val(rgb.b).end();\n            },\n            fillHSBFields = function (hsb, cal) {\n                $(cal).data('colpick').fields\n                    .eq(4).val(Math.round(hsb.h)).end()\n                    .eq(5).val(Math.round(hsb.s)).end()\n                    .eq(6).val(Math.round(hsb.b)).end();\n            },\n            fillHexFields = function (hsb, cal) {\n                $(cal).data('colpick').fields.eq(0).val(hsbToHex(hsb));\n            },\n        //Set the round selector position\n            setSelector = function (hsb, cal) {\n                $(cal).data('colpick').selector.css('backgroundColor', '#' + hsbToHex({h: hsb.h, s: 100, b: 100}));\n                $(cal).data('colpick').selectorIndic.css({\n                    left: parseInt($(cal).data('colpick').height * hsb.s / 100, 10),\n                    top: parseInt($(cal).data('colpick').height * (100 - hsb.b) / 100, 10)\n                });\n            },\n        //Set the hue selector position\n            setHue = function (hsb, cal) {\n                $(cal).data('colpick').hue.css('top', parseInt($(cal).data('colpick').height - $(cal).data('colpick').height * hsb.h / 360, 10));\n            },\n        //Set current and new colors\n            setCurrentColor = function (hsb, cal) {\n                $(cal).data('colpick').currentColor.css('backgroundColor', '#' + hsbToHex(hsb));\n            },\n            setNewColor = function (hsb, cal) {\n                $(cal).data('colpick').newColor.css('backgroundColor', '#' + hsbToHex(hsb));\n            },\n        //Called when the new color is changed\n            change = function () {\n                var cal = $(this).parent().parent(), col;\n                if (this.parentNode.className.indexOf('_hex') > 0) {\n                    cal.data('colpick').color = col = hexToHsb(fixHex(this.value));\n                    fillRGBFields(col, cal.get(0));\n                    fillHSBFields(col, cal.get(0));\n                } else if (this.parentNode.className.indexOf('_hsb') > 0) {\n                    cal.data('colpick').color = col = fixHSB({\n                        h: parseInt(cal.data('colpick').fields.eq(4).val(), 10),\n                        s: parseInt(cal.data('colpick').fields.eq(5).val(), 10),\n                        b: parseInt(cal.data('colpick').fields.eq(6).val(), 10)\n                    });\n                    fillRGBFields(col, cal.get(0));\n                    fillHexFields(col, cal.get(0));\n                } else {\n                    cal.data('colpick').color = col = rgbToHsb(fixRGB({\n                        r: parseInt(cal.data('colpick').fields.eq(1).val(), 10),\n                        g: parseInt(cal.data('colpick').fields.eq(2).val(), 10),\n                        b: parseInt(cal.data('colpick').fields.eq(3).val(), 10)\n                    }));\n                    fillHexFields(col, cal.get(0));\n                    fillHSBFields(col, cal.get(0));\n                }\n                setSelector(col, cal.get(0));\n                setHue(col, cal.get(0));\n                setNewColor(col, cal.get(0));\n                cal.data('colpick').onChange.apply(cal.parent(), [col, hsbToHex(col), hsbToRgb(col), cal.data('colpick').el, 0]);\n            },\n        //Change style on blur and on focus of inputs\n            blur = function () {\n                $(this).parent().removeClass('colpick_focus');\n            },\n            focus = function () {\n                $(this).parent().parent().data('colpick').fields.parent().removeClass('colpick_focus');\n                $(this).parent().addClass('colpick_focus');\n            },\n        //Increment/decrement arrows functions\n            downIncrement = function (ev) {\n                ev.preventDefault ? ev.preventDefault() : ev.returnValue = false;\n                var field = $(this).parent().find('input').focus();\n                var current = {\n                    el: $(this).parent().addClass('colpick_slider'),\n                    max: this.parentNode.className.indexOf('_hsb_h') > 0 ? 360 : (this.parentNode.className.indexOf('_hsb') > 0 ? 100 : 255),\n                    y: ev.pageY,\n                    field: field,\n                    val: parseInt(field.val(), 10),\n                    preview: $(this).parent().parent().data('colpick').livePreview\n                };\n                $(document).mouseup(current, upIncrement);\n                $(document).mousemove(current, moveIncrement);\n            },\n            moveIncrement = function (ev) {\n                ev.data.field.val(Math.max(0, Math.min(ev.data.max, parseInt(ev.data.val - ev.pageY + ev.data.y, 10))));\n                if (ev.data.preview) {\n                    change.apply(ev.data.field.get(0), [true]);\n                }\n                return false;\n            },\n            upIncrement = function (ev) {\n                change.apply(ev.data.field.get(0), [true]);\n                ev.data.el.removeClass('colpick_slider').find('input').focus();\n                $(document).off('mouseup', upIncrement);\n                $(document).off('mousemove', moveIncrement);\n                return false;\n            },\n        //Hue slider functions\n            downHue = function (ev) {\n                ev.preventDefault ? ev.preventDefault() : ev.returnValue = false;\n                var current = {\n                    cal: $(this).parent(),\n                    y: $(this).offset().top\n                };\n                $(document).on('mouseup touchend', current, upHue);\n                $(document).on('mousemove touchmove', current, moveHue);\n\n                var pageY = ((ev.type == 'touchstart') ? ev.originalEvent.changedTouches[0].pageY : ev.pageY );\n                change.apply(\n                    current.cal.data('colpick')\n                        .fields.eq(4).val(parseInt(360 * (current.cal.data('colpick').height - (pageY - current.y)) / current.cal.data('colpick').height, 10))\n                        .get(0),\n                    [current.cal.data('colpick').livePreview]\n                );\n                return false;\n            },\n            moveHue = function (ev) {\n                var pageY = ((ev.type == 'touchmove') ? ev.originalEvent.changedTouches[0].pageY : ev.pageY );\n                change.apply(\n                    ev.data.cal.data('colpick')\n                        .fields.eq(4).val(parseInt(360 * (ev.data.cal.data('colpick').height - Math.max(0, Math.min(ev.data.cal.data('colpick').height, (pageY - ev.data.y)))) / ev.data.cal.data('colpick').height, 10))\n                        .get(0),\n                    [ev.data.preview]\n                );\n                return false;\n            },\n            upHue = function (ev) {\n                fillRGBFields(ev.data.cal.data('colpick').color, ev.data.cal.get(0));\n                fillHexFields(ev.data.cal.data('colpick').color, ev.data.cal.get(0));\n                $(document).off('mouseup touchend', upHue);\n                $(document).off('mousemove touchmove', moveHue);\n                return false;\n            },\n        //Color selector functions\n            downSelector = function (ev) {\n                ev.preventDefault ? ev.preventDefault() : ev.returnValue = false;\n                var current = {\n                    cal: $(this).parent(),\n                    pos: $(this).offset()\n                };\n                current.preview = current.cal.data('colpick').livePreview;\n\n                $(document).on('mouseup touchend', current, upSelector);\n                $(document).on('mousemove touchmove', current, moveSelector);\n\n                var pageX, pageY;\n                if (ev.type == 'touchstart') {\n                    pageX = ev.originalEvent.changedTouches[0].pageX;\n                    pageY = ev.originalEvent.changedTouches[0].pageY;\n                } else {\n                    pageX = ev.pageX;\n                    pageY = ev.pageY;\n                }\n\n                change.apply(\n                    current.cal.data('colpick').fields\n                        .eq(6).val(parseInt(100 * (current.cal.data('colpick').height - (pageY - current.pos.top)) / current.cal.data('colpick').height, 10)).end()\n                        .eq(5).val(parseInt(100 * (pageX - current.pos.left) / current.cal.data('colpick').height, 10))\n                        .get(0),\n                    [current.preview]\n                );\n                return false;\n            },\n            moveSelector = function (ev) {\n                var pageX, pageY;\n                if (ev.type == 'touchmove') {\n                    pageX = ev.originalEvent.changedTouches[0].pageX;\n                    pageY = ev.originalEvent.changedTouches[0].pageY;\n                } else {\n                    pageX = ev.pageX;\n                    pageY = ev.pageY;\n                }\n\n                change.apply(\n                    ev.data.cal.data('colpick').fields\n                        .eq(6).val(parseInt(100 * (ev.data.cal.data('colpick').height - Math.max(0, Math.min(ev.data.cal.data('colpick').height, (pageY - ev.data.pos.top)))) / ev.data.cal.data('colpick').height, 10)).end()\n                        .eq(5).val(parseInt(100 * (Math.max(0, Math.min(ev.data.cal.data('colpick').height, (pageX - ev.data.pos.left)))) / ev.data.cal.data('colpick').height, 10))\n                        .get(0),\n                    [ev.data.preview]\n                );\n                return false;\n            },\n            upSelector = function (ev) {\n                fillRGBFields(ev.data.cal.data('colpick').color, ev.data.cal.get(0));\n                fillHexFields(ev.data.cal.data('colpick').color, ev.data.cal.get(0));\n                $(document).off('mouseup touchend', upSelector);\n                $(document).off('mousemove touchmove', moveSelector);\n                return false;\n            },\n        //Submit button\n            clickSubmit = function () {\n                var cal = $(this).parent();\n                var col = cal.data('colpick').color;\n                cal.data('colpick').origColor = col;\n                setCurrentColor(col, cal.get(0));\n                cal.data('colpick').onSubmit(col, hsbToHex(col), hsbToRgb(col), cal.data('colpick').el);\n            },\n        //Show/hide the color picker\n            show = function (ev) {\n                if (ev) {\n                    // Prevent the trigger of any direct parent\n                    ev.stopPropagation();\n                }\n                var cal = $('#' + $(this).data('colpickId'));\n                if (ev && !cal.data('colpick').polyfill) {\n                    ev.preventDefault();\n                }\n                cal.data('colpick').onBeforeShow.apply(this, [cal.get(0)]);\n                var pos = $(this).offset();\n                var top = pos.top + this.offsetHeight;\n                var left = pos.left;\n                var viewPort = getViewport();\n                var calW = cal.width();\n                if (left + calW > viewPort.l + viewPort.w) {\n                    left -= calW;\n                }\n                cal.css({left: left + 'px', top: top + 'px'});\n                if (cal.data('colpick').onShow.apply(this, [cal.get(0)]) != false) {\n                    cal.show();\n                }\n                //Hide when user clicks outside\n                $('html').mousedown({cal: cal}, hide);\n                cal.mousedown(function (ev) {\n                    ev.stopPropagation();\n                })\n            },\n            hide = function (ev) {\n                var cal = $('#' + $(this).data('colpickId'));\n                if (ev) {\n                    cal = ev.data.cal;\n                }\n                if (cal.data('colpick').onHide.apply(this, [cal.get(0)]) != false) {\n                    cal.hide();\n                }\n                $('html').off('mousedown', hide);\n            },\n            getViewport = function () {\n                var m = document.compatMode == 'CSS1Compat';\n                return {\n                    l: window.pageXOffset || (m ? document.documentElement.scrollLeft : document.body.scrollLeft),\n                    w: window.innerWidth || (m ? document.documentElement.clientWidth : document.body.clientWidth)\n                };\n            },\n        //Fix the values if the user enters a negative or high value\n            fixHSB = function (hsb) {\n                return {\n                    h: Math.min(360, Math.max(0, hsb.h)),\n                    s: Math.min(100, Math.max(0, hsb.s)),\n                    b: Math.min(100, Math.max(0, hsb.b))\n                };\n            },\n            fixRGB = function (rgb) {\n                return {\n                    r: Math.min(255, Math.max(0, rgb.r)),\n                    g: Math.min(255, Math.max(0, rgb.g)),\n                    b: Math.min(255, Math.max(0, rgb.b))\n                };\n            },\n            fixHex = function (hex) {\n                var len = 6 - hex.length;\n                if (len == 3) {\n                    var e = [];\n                    for (var j = 0; j < len; j++) {\n                        e.push(hex[j]);\n                        e.push(hex[j]);\n                    }\n                    hex = e.join('');\n                } else {\n                    if (len > 0) {\n                        var o = [];\n                        for (var i = 0; i < len; i++) {\n                            o.push('0');\n                        }\n                        o.push(hex);\n                        hex = o.join('');\n                    }\n                }\n                return hex;\n            },\n            restoreOriginal = function () {\n                var cal = $(this).parent();\n                var col = cal.data('colpick').origColor;\n                cal.data('colpick').color = col;\n                fillRGBFields(col, cal.get(0));\n                fillHexFields(col, cal.get(0));\n                fillHSBFields(col, cal.get(0));\n                setSelector(col, cal.get(0));\n                setHue(col, cal.get(0));\n                setNewColor(col, cal.get(0));\n            };\n        return {\n            init: function (opt) {\n                opt = $.extend({}, defaults, opt || {});\n                //Set color\n                if (opt.color === 'auto') {\n                } else if (typeof opt.color == 'string') {\n                    opt.color = hexToHsb(opt.color);\n                } else if (opt.color.r != undefined && opt.color.g != undefined && opt.color.b != undefined) {\n                    opt.color = rgbToHsb(opt.color);\n                } else if (opt.color.h != undefined && opt.color.s != undefined && opt.color.b != undefined) {\n                    opt.color = fixHSB(opt.color);\n                } else {\n                    return this;\n                }\n\n                //For each selected DOM element\n                return this.each(function () {\n                    //If the element does not have an ID\n                    if (!$(this).data('colpickId')) {\n                        var options = $.extend({}, opt);\n                        //Color\n                        if (opt.color === 'auto') {\n                            options.color = $(this).val() ? hexToHsb($(this).val()) : {h: 0, s: 0, b: 0};\n                        }\n                        options.origColor = options.color;\n\n                        //Polyfill\n                        if (typeof opt.polyfill == 'function') {\n                            options.polyfill = opt.polyfill(this);\n                        }\n                        if (options.polyfill && $(this).is('input') && this.type === \"color\") {\n                            return;\n                        }\n\n                        //Generate and assign a random ID\n                        var id = 'collorpicker_' + parseInt(Math.random() * 1000);\n                        $(this).data('colpickId', id);\n                        //Set the tpl's ID and get the HTML\n                        var cal = $(tpl).attr('id', id);\n                        //Add class according to layout\n                        cal.addClass('colpick_' + options.layout + (options.submit ? '' : ' colpick_' + options.layout + '_ns'));\n                        //Add class if the color scheme is not default\n                        if (options.colorScheme != 'light') {\n                            cal.addClass('colpick_' + options.colorScheme);\n                        }\n                        //Setup submit button\n                        cal.find('div.colpick_submit').html(options.submitText).click(clickSubmit);\n                        //Setup input fields\n                        options.fields = cal.find('input').change(change).blur(blur).focus(focus);\n                        cal.find('div.colpick_field_arrs').mousedown(downIncrement).end().find('div.colpick_current_color').click(restoreOriginal);\n                        //Setup hue selector\n                        options.selector = cal.find('div.colpick_color').on('mousedown touchstart', downSelector);\n                        options.selectorIndic = options.selector.find('div.colpick_selector_outer');\n                        //Store parts of the plugin\n                        options.el = this;\n                        options.hue = cal.find('div.colpick_hue_arrs');\n                        var huebar = options.hue.parent();\n                        //Paint the hue bar\n                        var UA = navigator.userAgent.toLowerCase();\n                        var isIE = navigator.appName === 'Microsoft Internet Explorer';\n                        var IEver = isIE ? parseFloat(UA.match(/msie ([0-9]*[\\.0-9]+)/)[1]) : 0;\n                        var ngIE = ( isIE && IEver < 10 );\n                        var stops = ['#ff0000', '#ff0080', '#ff00ff', '#8000ff', '#0000ff', '#0080ff', '#00ffff', '#00ff80', '#00ff00', '#80ff00', '#ffff00', '#ff8000', '#ff0000'];\n                        if (ngIE) {\n                            var i, div;\n                            for (i = 0; i <= 11; i++) {\n                                div = $('<div></div>').attr('style', 'height:8.333333%; filter:progid:DXImageTransform.Microsoft.gradient(GradientType=0,startColorstr=' + stops[i] + ', endColorstr=' + stops[i + 1] + '); -ms-filter: \"progid:DXImageTransform.Microsoft.gradient(GradientType=0,startColorstr=' + stops[i] + ', endColorstr=' + stops[i + 1] + ')\";');\n                                huebar.append(div);\n                            }\n                        } else {\n                            var stopList = stops.join(',');\n                            huebar.attr('style', 'background:-webkit-linear-gradient(top,' + stopList + '); background: -o-linear-gradient(top,' + stopList + '); background: -ms-linear-gradient(top,' + stopList + '); background:-moz-linear-gradient(top,' + stopList + '); -webkit-linear-gradient(top,' + stopList + '); background:linear-gradient(to bottom,' + stopList + '); ');\n                        }\n                        cal.find('div.colpick_hue').on('mousedown touchstart', downHue);\n                        options.newColor = cal.find('div.colpick_new_color');\n                        options.currentColor = cal.find('div.colpick_current_color');\n                        //Store options and fill with default color\n                        cal.data('colpick', options);\n                        fillRGBFields(options.color, cal.get(0));\n                        fillHSBFields(options.color, cal.get(0));\n                        fillHexFields(options.color, cal.get(0));\n                        setHue(options.color, cal.get(0));\n                        setSelector(options.color, cal.get(0));\n                        setCurrentColor(options.color, cal.get(0));\n                        setNewColor(options.color, cal.get(0));\n                        //Append to body if flat=false, else show in place\n                        if (options.flat) {\n                            cal.appendTo(options.appendTo || this).show();\n                            cal.css(options.styles || {\n                                position: 'relative',\n                                display: 'block'\n                            });\n                        } else {\n                            cal.appendTo(options.appendTo || document.body);\n                            $(this).on(options.showEvent, show);\n                            cal.css(options.styles || {\n                                position: 'absolute'\n                            });\n                        }\n                    }\n                });\n            },\n            //Shows the picker\n            showPicker: function () {\n                return this.each(function () {\n                    if ($(this).data('colpickId')) {\n                        show.apply(this);\n                    }\n                });\n            },\n            //Hides the picker\n            hidePicker: function () {\n                return this.each(function () {\n                    if ($(this).data('colpickId')) {\n                        hide.apply(this);\n                    }\n                });\n            },\n            //Sets a color as new and current (default)\n            setColor: function (col, setCurrent) {\n                setCurrent = (typeof setCurrent === \"undefined\") ? 1 : setCurrent;\n                if (typeof col == 'string') {\n                    col = hexToHsb(col);\n                } else if (col.r != undefined && col.g != undefined && col.b != undefined) {\n                    col = rgbToHsb(col);\n                } else if (col.h != undefined && col.s != undefined && col.b != undefined) {\n                    col = fixHSB(col);\n                } else {\n                    return this;\n                }\n                return this.each(function () {\n                    if ($(this).data('colpickId')) {\n                        var cal = $('#' + $(this).data('colpickId'));\n                        cal.data('colpick').color = col;\n                        cal.data('colpick').origColor = col;\n                        fillRGBFields(col, cal.get(0));\n                        fillHSBFields(col, cal.get(0));\n                        fillHexFields(col, cal.get(0));\n                        setHue(col, cal.get(0));\n                        setSelector(col, cal.get(0));\n\n                        setNewColor(col, cal.get(0));\n                        cal.data('colpick').onChange.apply(cal.parent(), [col, hsbToHex(col), hsbToRgb(col), cal.data('colpick').el, 1]);\n                        if (setCurrent) {\n                            setCurrentColor(col, cal.get(0));\n                        }\n                    }\n                });\n            },\n            destroy: function () {\n                $('#' + $(this).data('colpickId')).remove();\n            }\n        };\n    }();\n    //Color space conversions\n    var hexToRgb = function (hex) {\n        hex = parseInt(((hex.indexOf('#') > -1) ? hex.substring(1) : hex), 16);\n        return {r: hex >> 16, g: (hex & 0x00FF00) >> 8, b: (hex & 0x0000FF)};\n    };\n    var hexToHsb = function (hex) {\n        return rgbToHsb(hexToRgb(hex));\n    };\n    var rgbToHsb = function (rgb) {\n        var hsb = {h: 0, s: 0, b: 0};\n        var min = Math.min(rgb.r, rgb.g, rgb.b);\n        var max = Math.max(rgb.r, rgb.g, rgb.b);\n        var delta = max - min;\n        hsb.b = max;\n        hsb.s = max != 0 ? 255 * delta / max : 0;\n        if (hsb.s != 0) {\n            if (rgb.r == max) {\nhsb.h = (rgb.g - rgb.b) / delta;\n            } else if (rgb.g == max) {\nhsb.h = 2 + (rgb.b - rgb.r) / delta;\n            } else {\nhsb.h = 4 + (rgb.r - rgb.g) / delta;\n            }\n        } else {\nhsb.h = -1;\n        }\n        hsb.h *= 60;\n        if (hsb.h < 0) {\nhsb.h += 360;\n        }\n        hsb.s *= 100 / 255;\n        hsb.b *= 100 / 255;\n        return hsb;\n    };\n    var hsbToRgb = function (hsb) {\n        var rgb = {};\n        var h = hsb.h;\n        var s = hsb.s * 255 / 100;\n        var v = hsb.b * 255 / 100;\n        if (s == 0) {\n            rgb.r = rgb.g = rgb.b = v;\n        } else {\n            var t1 = v;\n            var t2 = (255 - s) * v / 255;\n            var t3 = (t1 - t2) * (h % 60) / 60;\n            if (h == 360) {\nh = 0;\n            }\n            if (h < 60) {\n                rgb.r = t1;\n                rgb.b = t2;\n                rgb.g = t2 + t3\n            } else if (h < 120) {\n                rgb.g = t1;\n                rgb.b = t2;\n                rgb.r = t1 - t3\n            } else if (h < 180) {\n                rgb.g = t1;\n                rgb.r = t2;\n                rgb.b = t2 + t3\n            } else if (h < 240) {\n                rgb.b = t1;\n                rgb.r = t2;\n                rgb.g = t1 - t3\n            } else if (h < 300) {\n                rgb.b = t1;\n                rgb.g = t2;\n                rgb.r = t2 + t3\n            } else if (h < 360) {\n                rgb.r = t1;\n                rgb.g = t2;\n                rgb.b = t1 - t3\n            } else {\n                rgb.r = 0;\n                rgb.g = 0;\n                rgb.b = 0\n            }\n        }\n        return {r: Math.round(rgb.r), g: Math.round(rgb.g), b: Math.round(rgb.b)};\n    };\n    var rgbToHex = function (rgb) {\n        var hex = [\n            rgb.r.toString(16),\n            rgb.g.toString(16),\n            rgb.b.toString(16)\n        ];\n        $.each(hex, function (nr, val) {\n            if (val.length == 1) {\n                hex[nr] = '0' + val;\n            }\n        });\n        return hex.join('');\n    };\n    var hsbToHex = function (hsb) {\n        return rgbToHex(hsbToRgb(hsb));\n    };\n    $.fn.extend({\n        colpick: colpick.init,\n        colpickHide: colpick.hidePicker,\n        colpickShow: colpick.showPicker,\n        colpickSetColor: colpick.setColor,\n        colpickDestroy: colpick.destroy\n    });\n    $.extend({\n        colpick: {\n            rgbToHex: rgbToHex,\n            rgbToHsb: rgbToHsb,\n            hsbToHex: hsbToHex,\n            hsbToRgb: hsbToRgb,\n            hexToHsb: hexToHsb,\n            hexToRgb: hexToRgb\n        }\n    });\n}));\n","Dotdigitalgroup_Email/js/node_modules/fancybox/jquery.fancybox.pack.js":"/*! fancyBox v2.1.5 fancyapps.com | fancyapps.com/fancybox/#license */\n(function (r, G, f, v) {\n    var J = f(\"html\"), n = f(r), p = f(G), b = f.fancybox = function () {\n        b.open.apply(this, arguments)\n    }, I = navigator.userAgent.match(/msie/i), B = null, s = G.createTouch !== v, t = function (a) {\n        return a && a.hasOwnProperty && a instanceof f\n    }, q = function (a) {\n        return a && \"string\" === f.type(a)\n    }, E = function (a) {\n        return q(a) && 0 < a.indexOf(\"%\")\n    }, l = function (a, d) {\n        var e = parseInt(a, 10) || 0;\n        d && E(a) && (e *= b.getViewport()[d] / 100);\n        return Math.ceil(e)\n    }, w = function (a, b) {\n        return l(a, b) + \"px\"\n    };\n    f.extend(b, {\n        version: \"2.1.5\",\n        defaults: {\n            padding: 15,\n            margin: 20,\n            width: 800,\n            height: 600,\n            minWidth: 100,\n            minHeight: 100,\n            maxWidth: 9999,\n            maxHeight: 9999,\n            pixelRatio: 1,\n            autoSize: !0,\n            autoHeight: !1,\n            autoWidth: !1,\n            autoResize: !0,\n            autoCenter: !s,\n            fitToView: !0,\n            aspectRatio: !1,\n            topRatio: 0.5,\n            leftRatio: 0.5,\n            scrolling: \"auto\",\n            wrapCSS: \"\",\n            arrows: !0,\n            closeBtn: !0,\n            closeClick: !1,\n            nextClick: !1,\n            mouseWheel: !0,\n            autoPlay: !1,\n            playSpeed: 3E3,\n            preload: 3,\n            modal: !1,\n            loop: !0,\n            ajax: {dataType: \"html\", headers: {\"X-fancyBox\": !0}},\n            iframe: {scrolling: \"auto\", preload: !0},\n            swf: {wmode: \"transparent\", allowfullscreen: \"true\", allowscriptaccess: \"always\"},\n            keys: {\n                next: {13: \"left\", 34: \"up\", 39: \"left\", 40: \"up\"},\n                prev: {8: \"right\", 33: \"down\", 37: \"right\", 38: \"down\"},\n                close: [27],\n                play: [32],\n                toggle: [70]\n            },\n            direction: {next: \"left\", prev: \"right\"},\n            scrollOutside: !0,\n            index: 0,\n            type: null,\n            href: null,\n            content: null,\n            title: null,\n            tpl: {\n                wrap: '<div class=\"fancybox-wrap\" tabIndex=\"-1\"><div class=\"fancybox-skin\"><div class=\"fancybox-outer\"><div class=\"fancybox-inner\"></div></div></div></div>',\n                image: '<img class=\"fancybox-image\" src=\"{href}\" alt=\"\" />',\n                iframe: '<iframe id=\"fancybox-frame{rnd}\" name=\"fancybox-frame{rnd}\" class=\"fancybox-iframe\" frameborder=\"0\" vspace=\"0\" hspace=\"0\" webkitAllowFullScreen mozallowfullscreen allowFullScreen' +\n                (I ? ' allowtransparency=\"true\"' : \"\") + \"></iframe>\",\n                error: '<p class=\"fancybox-error\">The requested content cannot be loaded.<br/>Please try again later.</p>',\n                closeBtn: '<a title=\"Close\" class=\"fancybox-item fancybox-close\" href=\"javascript:;\"></a>',\n                next: '<a title=\"Next\" class=\"fancybox-nav fancybox-next\" href=\"javascript:;\"><span></span></a>',\n                prev: '<a title=\"Previous\" class=\"fancybox-nav fancybox-prev\" href=\"javascript:;\"><span></span></a>'\n            },\n            openEffect: \"fade\",\n            openSpeed: 250,\n            openEasing: \"swing\",\n            openOpacity: !0,\n            openMethod: \"zoomIn\",\n            closeEffect: \"fade\",\n            closeSpeed: 250,\n            closeEasing: \"swing\",\n            closeOpacity: !0,\n            closeMethod: \"zoomOut\",\n            nextEffect: \"elastic\",\n            nextSpeed: 250,\n            nextEasing: \"swing\",\n            nextMethod: \"changeIn\",\n            prevEffect: \"elastic\",\n            prevSpeed: 250,\n            prevEasing: \"swing\",\n            prevMethod: \"changeOut\",\n            helpers: {overlay: !0, title: !0},\n            onCancel: f.noop,\n            beforeLoad: f.noop,\n            afterLoad: f.noop,\n            beforeShow: f.noop,\n            afterShow: f.noop,\n            beforeChange: f.noop,\n            beforeClose: f.noop,\n            afterClose: f.noop\n        },\n        group: {},\n        opts: {},\n        previous: null,\n        coming: null,\n        current: null,\n        isActive: !1,\n        isOpen: !1,\n        isOpened: !1,\n        wrap: null,\n        skin: null,\n        outer: null,\n        inner: null,\n        player: {timer: null, isActive: !1},\n        ajaxLoad: null,\n        imgPreload: null,\n        transitions: {},\n        helpers: {},\n        open: function (a, d) {\n            if (a && (f.isPlainObject(d) || (d = {}), !1 !== b.close(!0)))return f.isArray(a) || (a = t(a) ? f(a).get() : [a]), f.each(a, function (e, c) {\n                var k = {}, g, h, j, m, l;\n                \"object\" === f.type(c) && (c.nodeType && (c = f(c)), t(c) ? (k = {\n                    href: c.data(\"fancybox-href\") || c.attr(\"href\"),\n                    title: c.data(\"fancybox-title\") || c.attr(\"title\"),\n                    isDom: !0,\n                    element: c\n                }, f.metadata && f.extend(!0, k,\n                    c.metadata())) : k = c);\n                g = d.href || k.href || (q(c) ? c : null);\n                h = d.title !== v ? d.title : k.title || \"\";\n                m = (j = d.content || k.content) ? \"html\" : d.type || k.type;\n                !m && k.isDom && (m = c.data(\"fancybox-type\"), m || (m = (m = c.prop(\"class\").match(/fancybox\\.(\\w+)/)) ? m[1] : null));\n                q(g) && (m || (b.isImage(g) ? m = \"image\" : b.isSWF(g) ? m = \"swf\" : \"#\" === g.charAt(0) ? m = \"inline\" : q(c) && (m = \"html\", j = c)), \"ajax\" === m && (l = g.split(/\\s+/, 2), g = l.shift(), l = l.shift()));\n                j || (\"inline\" === m ? g ? j = f(q(g) ? g.replace(/.*(?=#[^\\s]+$)/, \"\") : g) : k.isDom && (j = c) : \"html\" === m ? j = g : !m && (!g &&\n                k.isDom) && (m = \"inline\", j = c));\n                f.extend(k, {href: g, type: m, content: j, title: h, selector: l});\n                a[e] = k\n            }), b.opts = f.extend(!0, {}, b.defaults, d), d.keys !== v && (b.opts.keys = d.keys ? f.extend({}, b.defaults.keys, d.keys) : !1), b.group = a, b._start(b.opts.index)\n        },\n        cancel: function () {\n            var a = b.coming;\n            a && !1 !== b.trigger(\"onCancel\") && (b.hideLoading(), b.ajaxLoad && b.ajaxLoad.abort(), b.ajaxLoad = null, b.imgPreload && (b.imgPreload.onload = b.imgPreload.onerror = null), a.wrap && a.wrap.stop(!0, !0).trigger(\"onReset\").remove(), b.coming = null, b.current ||\n            b._afterZoomOut(a))\n        },\n        close: function (a) {\n            b.cancel();\n            !1 !== b.trigger(\"beforeClose\") && (b.unbindEvents(), b.isActive && (!b.isOpen || !0 === a ? (f(\".fancybox-wrap\").stop(!0).trigger(\"onReset\").remove(), b._afterZoomOut()) : (b.isOpen = b.isOpened = !1, b.isClosing = !0, f(\".fancybox-item, .fancybox-nav\").remove(), b.wrap.stop(!0, !0).removeClass(\"fancybox-opened\"), b.transitions[b.current.closeMethod]())))\n        },\n        play: function (a) {\n            var d = function () {\n                clearTimeout(b.player.timer)\n            }, e = function () {\n                d();\n                b.current && b.player.isActive && (b.player.timer =\n                    setTimeout(b.next, b.current.playSpeed))\n            }, c = function () {\n                d();\n                p.unbind(\".player\");\n                b.player.isActive = !1;\n                b.trigger(\"onPlayEnd\")\n            };\n            if (!0 === a || !b.player.isActive && !1 !== a) {\n                if (b.current && (b.current.loop || b.current.index < b.group.length - 1))b.player.isActive = !0, p.bind({\n                    \"onCancel.player beforeClose.player\": c,\n                    \"onUpdate.player\": e,\n                    \"beforeLoad.player\": d\n                }), e(), b.trigger(\"onPlayStart\")\n            } else c()\n        },\n        next: function (a) {\n            var d = b.current;\n            d && (q(a) || (a = d.direction.next), b.jumpto(d.index + 1, a, \"next\"))\n        },\n        prev: function (a) {\n            var d = b.current;\n            d && (q(a) || (a = d.direction.prev), b.jumpto(d.index - 1, a, \"prev\"))\n        },\n        jumpto: function (a, d, e) {\n            var c = b.current;\n            c && (a = l(a), b.direction = d || c.direction[a >= c.index ? \"next\" : \"prev\"], b.router = e || \"jumpto\", c.loop && (0 > a && (a = c.group.length + a % c.group.length), a %= c.group.length), c.group[a] !== v && (b.cancel(), b._start(a)))\n        },\n        reposition: function (a, d) {\n            var e = b.current, c = e ? e.wrap : null, k;\n            c && (k = b._getPosition(d), a && \"scroll\" === a.type ? (delete k.position, c.stop(!0, !0).animate(k, 200)) : (c.css(k), e.pos = f.extend({}, e.dim, k)))\n        },\n        update: function (a) {\n            var d =\n                a && a.type, e = !d || \"orientationchange\" === d;\n            e && (clearTimeout(B), B = null);\n            b.isOpen && !B && (B = setTimeout(function () {\n                var c = b.current;\n                c && !b.isClosing && (b.wrap.removeClass(\"fancybox-tmp\"), (e || \"load\" === d || \"resize\" === d && c.autoResize) && b._setDimension(), \"scroll\" === d && c.canShrink || b.reposition(a), b.trigger(\"onUpdate\"), B = null)\n            }, e && !s ? 0 : 300))\n        },\n        toggle: function (a) {\n            b.isOpen && (b.current.fitToView = \"boolean\" === f.type(a) ? a : !b.current.fitToView, s && (b.wrap.removeAttr(\"style\").addClass(\"fancybox-tmp\"), b.trigger(\"onUpdate\")),\n                b.update())\n        },\n        hideLoading: function () {\n            p.unbind(\".loading\");\n            f(\"#fancybox-loading\").remove()\n        },\n        showLoading: function () {\n            var a, d;\n            b.hideLoading();\n            a = f('<div id=\"fancybox-loading\"><div></div></div>').click(b.cancel).appendTo(\"body\");\n            p.bind(\"keydown.loading\", function (a) {\n                if (27 === (a.which || a.keyCode))a.preventDefault(), b.cancel()\n            });\n            b.defaults.fixed || (d = b.getViewport(), a.css({\n                position: \"absolute\",\n                top: 0.5 * d.h + d.y,\n                left: 0.5 * d.w + d.x\n            }))\n        },\n        getViewport: function () {\n            var a = b.current && b.current.locked || !1, d = {\n                x: n.scrollLeft(),\n                y: n.scrollTop()\n            };\n            a ? (d.w = a[0].clientWidth, d.h = a[0].clientHeight) : (d.w = s && r.innerWidth ? r.innerWidth : n.width(), d.h = s && r.innerHeight ? r.innerHeight : n.height());\n            return d\n        },\n        unbindEvents: function () {\n            b.wrap && t(b.wrap) && b.wrap.unbind(\".fb\");\n            p.unbind(\".fb\");\n            n.unbind(\".fb\")\n        },\n        bindEvents: function () {\n            var a = b.current, d;\n            a && (n.bind(\"orientationchange.fb\" + (s ? \"\" : \" resize.fb\") + (a.autoCenter && !a.locked ? \" scroll.fb\" : \"\"), b.update), (d = a.keys) && p.bind(\"keydown.fb\", function (e) {\n                var c = e.which || e.keyCode, k = e.target || e.srcElement;\n                if (27 === c && b.coming)return !1;\n                !e.ctrlKey && (!e.altKey && !e.shiftKey && !e.metaKey && (!k || !k.type && !f(k).is(\"[contenteditable]\"))) && f.each(d, function (d, k) {\n                    if (1 < a.group.length && k[c] !== v)return b[d](k[c]), e.preventDefault(), !1;\n                    if (-1 < f.inArray(c, k))return b[d](), e.preventDefault(), !1\n                })\n            }), f.fn.mousewheel && a.mouseWheel && b.wrap.bind(\"mousewheel.fb\", function (d, c, k, g) {\n                for (var h = f(d.target || null), j = !1; h.length && !j && !h.is(\".fancybox-skin\") && !h.is(\".fancybox-wrap\");)j = h[0] && !(h[0].style.overflow && \"hidden\" === h[0].style.overflow) &&\n                    (h[0].clientWidth && h[0].scrollWidth > h[0].clientWidth || h[0].clientHeight && h[0].scrollHeight > h[0].clientHeight), h = f(h).parent();\n                if (0 !== c && !j && 1 < b.group.length && !a.canShrink) {\n                    if (0 < g || 0 < k)b.prev(0 < g ? \"down\" : \"left\"); else if (0 > g || 0 > k)b.next(0 > g ? \"up\" : \"right\");\n                    d.preventDefault()\n                }\n            }))\n        },\n        trigger: function (a, d) {\n            var e, c = d || b.coming || b.current;\n            if (c) {\n                f.isFunction(c[a]) && (e = c[a].apply(c, Array.prototype.slice.call(arguments, 1)));\n                if (!1 === e)return !1;\n                c.helpers && f.each(c.helpers, function (d, e) {\n                    if (e && b.helpers[d] && f.isFunction(b.helpers[d][a]))b.helpers[d][a](f.extend(!0,\n                        {}, b.helpers[d].defaults, e), c)\n                });\n                p.trigger(a)\n            }\n        },\n        isImage: function (a) {\n            return q(a) && a.match(/(^data:image\\/.*,)|(\\.(jp(e|g|eg)|gif|png|bmp|webp|svg)((\\?|#).*)?$)/i)\n        },\n        isSWF: function (a) {\n            return q(a) && a.match(/\\.(swf)((\\?|#).*)?$/i)\n        },\n        _start: function (a) {\n            var d = {}, e, c;\n            a = l(a);\n            e = b.group[a] || null;\n            if (!e)return !1;\n            d = f.extend(!0, {}, b.opts, e);\n            e = d.margin;\n            c = d.padding;\n            \"number\" === f.type(e) && (d.margin = [e, e, e, e]);\n            \"number\" === f.type(c) && (d.padding = [c, c, c, c]);\n            d.modal && f.extend(!0, d, {\n                closeBtn: !1, closeClick: !1, nextClick: !1, arrows: !1,\n                mouseWheel: !1, keys: null, helpers: {overlay: {closeClick: !1}}\n            });\n            d.autoSize && (d.autoWidth = d.autoHeight = !0);\n            \"auto\" === d.width && (d.autoWidth = !0);\n            \"auto\" === d.height && (d.autoHeight = !0);\n            d.group = b.group;\n            d.index = a;\n            b.coming = d;\n            if (!1 === b.trigger(\"beforeLoad\"))b.coming = null; else {\n                c = d.type;\n                e = d.href;\n                if (!c)return b.coming = null, b.current && b.router && \"jumpto\" !== b.router ? (b.current.index = a, b[b.router](b.direction)) : !1;\n                b.isActive = !0;\n                if (\"image\" === c || \"swf\" === c)d.autoHeight = d.autoWidth = !1, d.scrolling = \"visible\";\n                \"image\" === c && (d.aspectRatio = !0);\n                \"iframe\" === c && s && (d.scrolling = \"scroll\");\n                d.wrap = f(d.tpl.wrap).addClass(\"fancybox-\" + (s ? \"mobile\" : \"desktop\") + \" fancybox-type-\" + c + \" fancybox-tmp \" + d.wrapCSS).appendTo(d.parent || \"body\");\n                f.extend(d, {\n                    skin: f(\".fancybox-skin\", d.wrap),\n                    outer: f(\".fancybox-outer\", d.wrap),\n                    inner: f(\".fancybox-inner\", d.wrap)\n                });\n                f.each([\"Top\", \"Right\", \"Bottom\", \"Left\"], function (a, b) {\n                    d.skin.css(\"padding\" + b, w(d.padding[a]))\n                });\n                b.trigger(\"onReady\");\n                if (\"inline\" === c || \"html\" === c) {\n                    if (!d.content || !d.content.length)return b._error(\"content\")\n                } else if (!e)return b._error(\"href\");\n                \"image\" === c ? b._loadImage() : \"ajax\" === c ? b._loadAjax() : \"iframe\" === c ? b._loadIframe() : b._afterLoad()\n            }\n        },\n        _error: function (a) {\n            f.extend(b.coming, {\n                type: \"html\",\n                autoWidth: !0,\n                autoHeight: !0,\n                minWidth: 0,\n                minHeight: 0,\n                scrolling: \"no\",\n                hasError: a,\n                content: b.coming.tpl.error\n            });\n            b._afterLoad()\n        },\n        _loadImage: function () {\n            var a = b.imgPreload = new Image;\n            a.onload = function () {\n                this.onload = this.onerror = null;\n                b.coming.width = this.width / b.opts.pixelRatio;\n                b.coming.height = this.height / b.opts.pixelRatio;\n                b._afterLoad()\n            };\n            a.onerror = function () {\n                this.onload =\n                    this.onerror = null;\n                b._error(\"image\")\n            };\n            a.src = b.coming.href;\n            !0 !== a.complete && b.showLoading()\n        },\n        _loadAjax: function () {\n            var a = b.coming;\n            b.showLoading();\n            b.ajaxLoad = f.ajax(f.extend({}, a.ajax, {\n                url: a.href, error: function (a, e) {\n                    b.coming && \"abort\" !== e ? b._error(\"ajax\", a) : b.hideLoading()\n                }, success: function (d, e) {\n                    \"success\" === e && (a.content = d, b._afterLoad())\n                }\n            }))\n        },\n        _loadIframe: function () {\n            var a = b.coming, d = f(a.tpl.iframe.replace(/\\{rnd\\}/g, (new Date).getTime())).attr(\"scrolling\", s ? \"auto\" : a.iframe.scrolling).attr(\"src\", a.href);\n            f(a.wrap).bind(\"onReset\", function () {\n                try {\n                    f(this).find(\"iframe\").hide().attr(\"src\", \"//about:blank\").end().empty()\n                } catch (a) {\n                }\n            });\n            a.iframe.preload && (b.showLoading(), d.one(\"load\", function () {\n                f(this).data(\"ready\", 1);\n                s || f(this).bind(\"load.fb\", b.update);\n                f(this).parents(\".fancybox-wrap\").width(\"100%\").removeClass(\"fancybox-tmp\").show();\n                b._afterLoad()\n            }));\n            a.content = d.appendTo(a.inner);\n            a.iframe.preload || b._afterLoad()\n        },\n        _preloadImages: function () {\n            var a = b.group, d = b.current, e = a.length, c = d.preload ? Math.min(d.preload,\n                e - 1) : 0, f, g;\n            for (g = 1; g <= c; g += 1)f = a[(d.index + g) % e], \"image\" === f.type && f.href && ((new Image).src = f.href)\n        },\n        _afterLoad: function () {\n            var a = b.coming, d = b.current, e, c, k, g, h;\n            b.hideLoading();\n            if (a && !1 !== b.isActive)if (!1 === b.trigger(\"afterLoad\", a, d))a.wrap.stop(!0).trigger(\"onReset\").remove(), b.coming = null; else {\n                d && (b.trigger(\"beforeChange\", d), d.wrap.stop(!0).removeClass(\"fancybox-opened\").find(\".fancybox-item, .fancybox-nav\").remove());\n                b.unbindEvents();\n                e = a.content;\n                c = a.type;\n                k = a.scrolling;\n                f.extend(b, {\n                    wrap: a.wrap, skin: a.skin,\n                    outer: a.outer, inner: a.inner, current: a, previous: d\n                });\n                g = a.href;\n                switch (c) {\n                    case \"inline\":\n                    case \"ajax\":\n                    case \"html\":\n                        a.selector ? e = f(\"<div>\").html(e).find(a.selector) : t(e) && (e.data(\"fancybox-placeholder\") || e.data(\"fancybox-placeholder\", f('<div class=\"fancybox-placeholder\"></div>').insertAfter(e).hide()), e = e.show().detach(), a.wrap.bind(\"onReset\", function () {\n                            f(this).find(e).length && e.hide().replaceAll(e.data(\"fancybox-placeholder\")).data(\"fancybox-placeholder\", !1)\n                        }));\n                        break;\n                    case \"image\":\n                        e = a.tpl.image.replace(\"{href}\",\n                            g);\n                        break;\n                    case \"swf\":\n                        e = '<object id=\"fancybox-swf\" classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" width=\"100%\" height=\"100%\"><param name=\"movie\" value=\"' + g + '\"></param>', h = \"\", f.each(a.swf, function (a, b) {\n                            e += '<param name=\"' + a + '\" value=\"' + b + '\"></param>';\n                            h += \" \" + a + '=\"' + b + '\"'\n                        }), e += '<embed src=\"' + g + '\" type=\"application/x-shockwave-flash\" width=\"100%\" height=\"100%\"' + h + \"></embed></object>\"\n                }\n                (!t(e) || !e.parent().is(a.inner)) && a.inner.append(e);\n                b.trigger(\"beforeShow\");\n                a.inner.css(\"overflow\", \"yes\" === k ? \"scroll\" :\n                    \"no\" === k ? \"hidden\" : k);\n                b._setDimension();\n                b.reposition();\n                b.isOpen = !1;\n                b.coming = null;\n                b.bindEvents();\n                if (b.isOpened) {\n                    if (d.prevMethod)b.transitions[d.prevMethod]()\n                } else f(\".fancybox-wrap\").not(a.wrap).stop(!0).trigger(\"onReset\").remove();\n                b.transitions[b.isOpened ? a.nextMethod : a.openMethod]();\n                b._preloadImages()\n            }\n        },\n        _setDimension: function () {\n            var a = b.getViewport(), d = 0, e = !1, c = !1, e = b.wrap, k = b.skin, g = b.inner, h = b.current, c = h.width, j = h.height, m = h.minWidth, u = h.minHeight, n = h.maxWidth, p = h.maxHeight, s = h.scrolling, q = h.scrollOutside ?\n                h.scrollbarWidth : 0, x = h.margin, y = l(x[1] + x[3]), r = l(x[0] + x[2]), v, z, t, C, A, F, B, D, H;\n            e.add(k).add(g).width(\"auto\").height(\"auto\").removeClass(\"fancybox-tmp\");\n            x = l(k.outerWidth(!0) - k.width());\n            v = l(k.outerHeight(!0) - k.height());\n            z = y + x;\n            t = r + v;\n            C = E(c) ? (a.w - z) * l(c) / 100 : c;\n            A = E(j) ? (a.h - t) * l(j) / 100 : j;\n            if (\"iframe\" === h.type) {\n                if (H = h.content, h.autoHeight && 1 === H.data(\"ready\"))try {\n                    H[0].contentWindow.document.location && (g.width(C).height(9999), F = H.contents().find(\"body\"), q && F.css(\"overflow-x\", \"hidden\"), A = F.outerHeight(!0))\n                } catch (G) {\n                }\n            } else if (h.autoWidth ||\n                h.autoHeight)g.addClass(\"fancybox-tmp\"), h.autoWidth || g.width(C), h.autoHeight || g.height(A), h.autoWidth && (C = g.width()), h.autoHeight && (A = g.height()), g.removeClass(\"fancybox-tmp\");\n            c = l(C);\n            j = l(A);\n            D = C / A;\n            m = l(E(m) ? l(m, \"w\") - z : m);\n            n = l(E(n) ? l(n, \"w\") - z : n);\n            u = l(E(u) ? l(u, \"h\") - t : u);\n            p = l(E(p) ? l(p, \"h\") - t : p);\n            F = n;\n            B = p;\n            h.fitToView && (n = Math.min(a.w - z, n), p = Math.min(a.h - t, p));\n            z = a.w - y;\n            r = a.h - r;\n            h.aspectRatio ? (c > n && (c = n, j = l(c / D)), j > p && (j = p, c = l(j * D)), c < m && (c = m, j = l(c / D)), j < u && (j = u, c = l(j * D))) : (c = Math.max(m, Math.min(c, n)), h.autoHeight &&\n            \"iframe\" !== h.type && (g.width(c), j = g.height()), j = Math.max(u, Math.min(j, p)));\n            if (h.fitToView)if (g.width(c).height(j), e.width(c + x), a = e.width(), y = e.height(), h.aspectRatio)for (; (a > z || y > r) && (c > m && j > u) && !(19 < d++);)j = Math.max(u, Math.min(p, j - 10)), c = l(j * D), c < m && (c = m, j = l(c / D)), c > n && (c = n, j = l(c / D)), g.width(c).height(j), e.width(c + x), a = e.width(), y = e.height(); else c = Math.max(m, Math.min(c, c - (a - z))), j = Math.max(u, Math.min(j, j - (y - r)));\n            q && (\"auto\" === s && j < A && c + x + q < z) && (c += q);\n            g.width(c).height(j);\n            e.width(c + x);\n            a = e.width();\n            y = e.height();\n            e = (a > z || y > r) && c > m && j > u;\n            c = h.aspectRatio ? c < F && j < B && c < C && j < A : (c < F || j < B) && (c < C || j < A);\n            f.extend(h, {\n                dim: {width: w(a), height: w(y)},\n                origWidth: C,\n                origHeight: A,\n                canShrink: e,\n                canExpand: c,\n                wPadding: x,\n                hPadding: v,\n                wrapSpace: y - k.outerHeight(!0),\n                skinSpace: k.height() - j\n            });\n            !H && (h.autoHeight && j > u && j < p && !c) && g.height(\"auto\")\n        },\n        _getPosition: function (a) {\n            var d = b.current, e = b.getViewport(), c = d.margin, f = b.wrap.width() + c[1] + c[3], g = b.wrap.height() + c[0] + c[2], c = {\n                position: \"absolute\",\n                top: c[0],\n                left: c[3]\n            };\n            d.autoCenter && d.fixed && !a && g <= e.h && f <= e.w ? c.position = \"fixed\" : d.locked || (c.top += e.y, c.left += e.x);\n            c.top = w(Math.max(c.top, c.top + (e.h - g) * d.topRatio));\n            c.left = w(Math.max(c.left, c.left + (e.w - f) * d.leftRatio));\n            return c\n        },\n        _afterZoomIn: function () {\n            var a = b.current;\n            a && (b.isOpen = b.isOpened = !0, b.wrap.css(\"overflow\", \"visible\").addClass(\"fancybox-opened\"), b.update(), (a.closeClick || a.nextClick && 1 < b.group.length) && b.inner.css(\"cursor\", \"pointer\").bind(\"click.fb\", function (d) {\n                !f(d.target).is(\"a\") && !f(d.target).parent().is(\"a\") && (d.preventDefault(),\n                    b[a.closeClick ? \"close\" : \"next\"]())\n            }), a.closeBtn && f(a.tpl.closeBtn).appendTo(b.skin).bind(\"click.fb\", function (a) {\n                a.preventDefault();\n                b.close()\n            }), a.arrows && 1 < b.group.length && ((a.loop || 0 < a.index) && f(a.tpl.prev).appendTo(b.outer).bind(\"click.fb\", b.prev), (a.loop || a.index < b.group.length - 1) && f(a.tpl.next).appendTo(b.outer).bind(\"click.fb\", b.next)), b.trigger(\"afterShow\"), !a.loop && a.index === a.group.length - 1 ? b.play(!1) : b.opts.autoPlay && !b.player.isActive && (b.opts.autoPlay = !1, b.play()))\n        },\n        _afterZoomOut: function (a) {\n            a =\n                a || b.current;\n            f(\".fancybox-wrap\").trigger(\"onReset\").remove();\n            f.extend(b, {\n                group: {},\n                opts: {},\n                router: !1,\n                current: null,\n                isActive: !1,\n                isOpened: !1,\n                isOpen: !1,\n                isClosing: !1,\n                wrap: null,\n                skin: null,\n                outer: null,\n                inner: null\n            });\n            b.trigger(\"afterClose\", a)\n        }\n    });\n    b.transitions = {\n        getOrigPosition: function () {\n            var a = b.current, d = a.element, e = a.orig, c = {}, f = 50, g = 50, h = a.hPadding, j = a.wPadding, m = b.getViewport();\n            !e && (a.isDom && d.is(\":visible\")) && (e = d.find(\"img:first\"), e.length || (e = d));\n            t(e) ? (c = e.offset(), e.is(\"img\") && (f = e.outerWidth(), g = e.outerHeight())) :\n                (c.top = m.y + (m.h - g) * a.topRatio, c.left = m.x + (m.w - f) * a.leftRatio);\n            if (\"fixed\" === b.wrap.css(\"position\") || a.locked)c.top -= m.y, c.left -= m.x;\n            return c = {\n                top: w(c.top - h * a.topRatio),\n                left: w(c.left - j * a.leftRatio),\n                width: w(f + j),\n                height: w(g + h)\n            }\n        }, step: function (a, d) {\n            var e, c, f = d.prop;\n            c = b.current;\n            var g = c.wrapSpace, h = c.skinSpace;\n            if (\"width\" === f || \"height\" === f)e = d.end === d.start ? 1 : (a - d.start) / (d.end - d.start), b.isClosing && (e = 1 - e), c = \"width\" === f ? c.wPadding : c.hPadding, c = a - c, b.skin[f](l(\"width\" === f ? c : c - g * e)), b.inner[f](l(\"width\" ===\n            f ? c : c - g * e - h * e))\n        }, zoomIn: function () {\n            var a = b.current, d = a.pos, e = a.openEffect, c = \"elastic\" === e, k = f.extend({opacity: 1}, d);\n            delete k.position;\n            c ? (d = this.getOrigPosition(), a.openOpacity && (d.opacity = 0.1)) : \"fade\" === e && (d.opacity = 0.1);\n            b.wrap.css(d).animate(k, {\n                duration: \"none\" === e ? 0 : a.openSpeed,\n                easing: a.openEasing,\n                step: c ? this.step : null,\n                complete: b._afterZoomIn\n            })\n        }, zoomOut: function () {\n            var a = b.current, d = a.closeEffect, e = \"elastic\" === d, c = {opacity: 0.1};\n            e && (c = this.getOrigPosition(), a.closeOpacity && (c.opacity = 0.1));\n            b.wrap.animate(c,\n                {\n                    duration: \"none\" === d ? 0 : a.closeSpeed,\n                    easing: a.closeEasing,\n                    step: e ? this.step : null,\n                    complete: b._afterZoomOut\n                })\n        }, changeIn: function () {\n            var a = b.current, d = a.nextEffect, e = a.pos, c = {opacity: 1}, f = b.direction, g;\n            e.opacity = 0.1;\n            \"elastic\" === d && (g = \"down\" === f || \"up\" === f ? \"top\" : \"left\", \"down\" === f || \"right\" === f ? (e[g] = w(l(e[g]) - 200), c[g] = \"+=200px\") : (e[g] = w(l(e[g]) + 200), c[g] = \"-=200px\"));\n            \"none\" === d ? b._afterZoomIn() : b.wrap.css(e).animate(c, {\n                duration: a.nextSpeed,\n                easing: a.nextEasing,\n                complete: b._afterZoomIn\n            })\n        }, changeOut: function () {\n            var a =\n                b.previous, d = a.prevEffect, e = {opacity: 0.1}, c = b.direction;\n            \"elastic\" === d && (e[\"down\" === c || \"up\" === c ? \"top\" : \"left\"] = (\"up\" === c || \"left\" === c ? \"-\" : \"+\") + \"=200px\");\n            a.wrap.animate(e, {\n                duration: \"none\" === d ? 0 : a.prevSpeed, easing: a.prevEasing, complete: function () {\n                    f(this).trigger(\"onReset\").remove()\n                }\n            })\n        }\n    };\n    b.helpers.overlay = {\n        defaults: {closeClick: !0, speedOut: 200, showEarly: !0, css: {}, locked: !s, fixed: !0},\n        overlay: null,\n        fixed: !1,\n        el: f(\"html\"),\n        create: function (a) {\n            a = f.extend({}, this.defaults, a);\n            this.overlay && this.close();\n            this.overlay =\n                f('<div class=\"fancybox-overlay\"></div>').appendTo(b.coming ? b.coming.parent : a.parent);\n            this.fixed = !1;\n            a.fixed && b.defaults.fixed && (this.overlay.addClass(\"fancybox-overlay-fixed\"), this.fixed = !0)\n        },\n        open: function (a) {\n            var d = this;\n            a = f.extend({}, this.defaults, a);\n            this.overlay ? this.overlay.unbind(\".overlay\").width(\"auto\").height(\"auto\") : this.create(a);\n            this.fixed || (n.bind(\"resize.overlay\", f.proxy(this.update, this)), this.update());\n            a.closeClick && this.overlay.bind(\"click.overlay\", function (a) {\n                if (f(a.target).hasClass(\"fancybox-overlay\"))return b.isActive ?\n                    b.close() : d.close(), !1\n            });\n            this.overlay.css(a.css).show()\n        },\n        close: function () {\n            var a, b;\n            n.unbind(\"resize.overlay\");\n            this.el.hasClass(\"fancybox-lock\") && (f(\".fancybox-margin\").removeClass(\"fancybox-margin\"), a = n.scrollTop(), b = n.scrollLeft(), this.el.removeClass(\"fancybox-lock\"), n.scrollTop(a).scrollLeft(b));\n            f(\".fancybox-overlay\").remove().hide();\n            f.extend(this, {overlay: null, fixed: !1})\n        },\n        update: function () {\n            var a = \"100%\", b;\n            this.overlay.width(a).height(\"100%\");\n            I ? (b = Math.max(G.documentElement.offsetWidth, G.body.offsetWidth),\n            p.width() > b && (a = p.width())) : p.width() > n.width() && (a = p.width());\n            this.overlay.width(a).height(p.height())\n        },\n        onReady: function (a, b) {\n            var e = this.overlay;\n            f(\".fancybox-overlay\").stop(!0, !0);\n            e || this.create(a);\n            a.locked && (this.fixed && b.fixed) && (e || (this.margin = p.height() > n.height() ? f(\"html\").css(\"margin-right\").replace(\"px\", \"\") : !1), b.locked = this.overlay.append(b.wrap), b.fixed = !1);\n            !0 === a.showEarly && this.beforeShow.apply(this, arguments)\n        },\n        beforeShow: function (a, b) {\n            var e, c;\n            b.locked && (!1 !== this.margin && (f(\"*\").filter(function () {\n                return \"fixed\" ===\n                    f(this).css(\"position\") && !f(this).hasClass(\"fancybox-overlay\") && !f(this).hasClass(\"fancybox-wrap\")\n            }).addClass(\"fancybox-margin\"), this.el.addClass(\"fancybox-margin\")), e = n.scrollTop(), c = n.scrollLeft(), this.el.addClass(\"fancybox-lock\"), n.scrollTop(e).scrollLeft(c));\n            this.open(a)\n        },\n        onUpdate: function () {\n            this.fixed || this.update()\n        },\n        afterClose: function (a) {\n            this.overlay && !b.coming && this.overlay.fadeOut(a.speedOut, f.proxy(this.close, this))\n        }\n    };\n    b.helpers.title = {\n        defaults: {type: \"float\", position: \"bottom\"}, beforeShow: function (a) {\n            var d =\n                b.current, e = d.title, c = a.type;\n            f.isFunction(e) && (e = e.call(d.element, d));\n            if (q(e) && \"\" !== f.trim(e)) {\n                d = f('<div class=\"fancybox-title fancybox-title-' + c + '-wrap\">' + e + \"</div>\");\n                switch (c) {\n                    case \"inside\":\n                        c = b.skin;\n                        break;\n                    case \"outside\":\n                        c = b.wrap;\n                        break;\n                    case \"over\":\n                        c = b.inner;\n                        break;\n                    default:\n                        c = b.skin, d.appendTo(\"body\"), I && d.width(d.width()), d.wrapInner('<span class=\"child\"></span>'), b.current.margin[2] += Math.abs(l(d.css(\"margin-bottom\")))\n                }\n                d[\"top\" === a.position ? \"prependTo\" : \"appendTo\"](c)\n            }\n        }\n    };\n    f.fn.fancybox = function (a) {\n        var d,\n            e = f(this), c = this.selector || \"\", k = function (g) {\n                var h = f(this).blur(), j = d, k, l;\n                !g.ctrlKey && (!g.altKey && !g.shiftKey && !g.metaKey) && !h.is(\".fancybox-wrap\") && (k = a.groupAttr || \"data-fancybox-group\", l = h.attr(k), l || (k = \"rel\", l = h.get(0)[k]), l && (\"\" !== l && \"nofollow\" !== l) && (h = c.length ? f(c) : e, h = h.filter(\"[\" + k + '=\"' + l + '\"]'), j = h.index(this)), a.index = j, !1 !== b.open(h, a) && g.preventDefault())\n            };\n        a = a || {};\n        d = a.index || 0;\n        !c || !1 === a.live ? e.unbind(\"click.fb-start\").bind(\"click.fb-start\", k) : p.undelegate(c, \"click.fb-start\").delegate(c +\n            \":not('.fancybox-item, .fancybox-nav')\", \"click.fb-start\", k);\n        this.filter(\"[data-fancybox-start=1]\").trigger(\"click\");\n        return this\n    };\n    p.ready(function () {\n        var a, d;\n        f.scrollbarWidth === v && (f.scrollbarWidth = function () {\n            var a = f('<div style=\"width:50px;height:50px;overflow:auto\"><div/></div>').appendTo(\"body\"), b = a.children(), b = b.innerWidth() - b.height(99).innerWidth();\n            a.remove();\n            return b\n        });\n        if (f.support.fixedPosition === v) {\n            a = f.support;\n            d = f('<div style=\"position:fixed;top:20px;\"></div>').appendTo(\"body\");\n            var e = 20 ===\n                d[0].offsetTop || 15 === d[0].offsetTop;\n            d.remove();\n            a.fixedPosition = e\n        }\n        f.extend(b.defaults, {\n            scrollbarWidth: f.scrollbarWidth(),\n            fixed: f.support.fixedPosition,\n            parent: f(\"body\")\n        });\n        a = f(r).width();\n        J.addClass(\"fancybox-lock-test\");\n        d = f(r).width();\n        J.removeClass(\"fancybox-lock-test\");\n        f(\"<style type='text/css'>.fancybox-margin{margin-right:\" + (d - a) + \"px;}</style>\").appendTo(\"head\")\n    })\n})(window, document, jQuery);","Magento_Authorizenet/js/direct-post.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            'jquery',\n            'mage/backend/validation',\n            'prototype'\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function (jQuery) {\n\n    window.directPost = Class.create();\n    directPost.prototype = {\n        initialize: function (methodCode, iframeId, controller, orderSaveUrl, cgiUrl, nativeAction) {\n            var prepare = function (event, method) {\n                if (method === 'authorizenet_directpost') {\n                    this.preparePayment();\n                } else {\n                    jQuery('#edit_form')\n                        .off('submitOrder.authorizenet');\n                }\n            };\n\n            this.iframeId = iframeId;\n            this.controller = controller;\n            this.orderSaveUrl = orderSaveUrl;\n            this.nativeAction = nativeAction;\n            this.cgiUrl = cgiUrl;\n            this.code = methodCode;\n            this.inputs = ['cc_type', 'cc_number', 'expiration', 'expiration_yr', 'cc_cid'];\n            this.headers = [];\n            this.isValid = true;\n            this.paymentRequestSent = false;\n            this.orderIncrementId = false;\n            this.successUrl = false;\n            this.hasError = false;\n            this.tmpForm = false;\n\n            this.onLoadIframe = this.loadIframe.bindAsEventListener(this);\n            this.onLoadOrderIframe = this.loadOrderIframe.bindAsEventListener(this);\n            this.onSubmitAdminOrder = this.submitAdminOrder.bindAsEventListener(this);\n\n            jQuery('#edit_form').on('changePaymentMethod', prepare.bind(this));\n\n            jQuery('#edit_form').trigger(\n                'changePaymentMethod',\n                [\n                    jQuery('#edit_form').find(':radio[name=\"payment[method]\"]:checked').val()\n                ]\n            );\n        },\n\n        validate: function () {\n            this.isValid = true;\n            this.inputs.each(function (elemIndex) {\n                if ($(this.code + '_' + elemIndex)) {\n                    if (!jQuery.validator.validateElement($(this.code + '_' + elemIndex))) {\n                        this.isValid = false;\n                    }\n                }\n            }, this);\n\n            return this.isValid;\n        },\n\n        changeInputOptions: function (param, value) {\n            this.inputs.each(function (elemIndex) {\n                if ($(this.code + '_' + elemIndex)) {\n                    $(this.code + '_' + elemIndex).writeAttribute(param, value);\n                }\n            }, this);\n        },\n\n        preparePayment: function () {\n            this.changeInputOptions('autocomplete', 'off');\n            jQuery('#edit_form')\n                .off('submitOrder')\n                .on('submitOrder.authorizenet', this.submitAdminOrder.bind(this));\n\n            if ($(this.iframeId)) {\n                // Temporary solution will be removed after refactoring Authorize.Net (sales) functionality\n                jQuery('.scalable.save:not(disabled)').removeAttr('onclick');\n                jQuery(document).off('click.directPost');\n                jQuery(document).on(\n                    'click.directPost',\n                    '.scalable.save:not(disabled)',\n                    jQuery.proxy(this.onSubmitAdminOrder, this)\n                );\n                $('order-' + this.iframeId).observe('load', this.onLoadOrderIframe);\n                $(this.iframeId).observe('load', this.onLoadIframe);\n            }\n        },\n\n        loadIframe: function () {\n            if (this.paymentRequestSent) {\n                if (!this.orderRequestSent) {\n                    this.paymentRequestSent = false;\n\n                    if (!this.hasError) {\n                        this.returnQuote();\n                    } else {\n                        this.changeInputOptions('disabled', false);\n                        jQuery('body').trigger('processStop');\n                        enableElements('save');\n                    }\n                }\n\n                if (this.tmpForm) {\n                    document.body.removeChild(this.tmpForm);\n                }\n            }\n        },\n\n        loadOrderIframe: function () {\n            if (this.orderRequestSent) {\n                $(this.iframeId).hide();\n                var data = $('order-' + this.iframeId).contentWindow.document.body.getElementsByTagName('pre')[0].innerHTML;\n\n                this.saveAdminOrderSuccess(data);\n                this.orderRequestSent = false;\n            }\n        },\n\n        showError: function (msg) {\n            this.hasError = true;\n\n            if (this.controller == 'onepage') {\n                $(this.iframeId).hide();\n                this.resetLoadWaiting();\n            }\n            alert(msg);\n        },\n\n        returnQuote: function () {\n            var url = this.orderSaveUrl.replace('place', 'returnQuote');\n\n            new Ajax.Request(url, {\n                onSuccess: function (transport) {\n                    try {\n                        response = transport.responseText.evalJSON(true);\n                    } catch (e) {\n                        response = {};\n                    }\n\n                    if (response.error_message) {\n                        alert(response.error_message);\n                    }\n                    $(this.iframeId).show();\n                    this.changeInputOptions('disabled', false);\n                    jQuery('body').trigger('processStop');\n                    enableElements('save');\n                }.bind(this)\n            });\n        },\n\n        setLoadWaiting: function () {\n            this.headers.each(function (header) {\n                header.removeClassName('allow');\n            });\n            checkout.setLoadWaiting('review');\n        },\n\n        resetLoadWaiting: function () {\n            this.headers.each(function (header) {\n                header.addClassName('allow');\n            });\n            checkout.setLoadWaiting(false);\n        },\n\n        submitAdminOrder: function () {\n            // Temporary solution will be removed after refactoring Authorize.Net (sales) functionality\n            var editForm = jQuery('#edit_form');\n\n            if (editForm.valid()) {\n                // Temporary solution will be removed after refactoring Authorize.Net (sales) functionality\n                paymentMethodEl = editForm.find(':radio[name=\"payment[method]\"]:checked');\n                this.hasError = false;\n\n                if (paymentMethodEl.val() == this.code) {\n                    jQuery('body').trigger('processStart');\n                    setLoaderPosition();\n                    this.changeInputOptions('disabled', 'disabled');\n                    this.paymentRequestSent = true;\n                    this.orderRequestSent = true;\n                    // Temporary solutions will be removed after refactoring Authorize.Net (sales) functionality\n                    editForm.attr('action', this.orderSaveUrl);\n                    editForm.attr('target',\n                            jQuery('#order-' + this.iframeId).attr('name'));\n                    editForm.append(this.createHiddenElement('controller', this.controller));\n                    disableElements('save');\n                    // Temporary solutions will be removed after refactoring Authorize.Net (sales) functionality\n                    order._realSubmit();\n                } else {\n                    editForm.attr('action', this.nativeAction);\n                    editForm.attr('target', '_top');\n                    disableElements('save');\n                    // Temporary solutions will be removed after refactoring Authorize.Net (sales) functionality\n                    order._realSubmit();\n                }\n            }\n        },\n\n        recollectQuote: function () {\n            var area = ['sidebar', 'items', 'shipping_method', 'billing_method', 'totals', 'giftmessage'];\n\n            area = order.prepareArea(area);\n            var url = order.loadBaseUrl + 'block/' + area;\n            var info = $('order-items_grid').select('input', 'select', 'textarea');\n            var data = {};\n\n            for (var i = 0; i < info.length; i++) {\n                if (!info[i].disabled && (info[i].type != 'checkbox' || info[i].checked)) {\n                    data[info[i].name] = info[i].getValue();\n                }\n            }\n            data.reset_shipping = true;\n            data.update_items = true;\n\n            if ($('coupons:code') && $F('coupons:code')) {\n                data['order[coupon][code]'] = $F('coupons:code');\n            }\n            data.json = true;\n            new Ajax.Request(url, {\n                parameters: data,\n                loaderArea: 'html-body',\n                onSuccess: function (transport) {\n                    jQuery('#edit_form').submit();\n                }\n            });\n\n        },\n\n        saveAdminOrderSuccess: function (data) {\n            try {\n                response = data.evalJSON(true);\n            } catch (e) {\n                response = {};\n            }\n\n            if (response.directpost) {\n                this.orderIncrementId = response.directpost.fields.x_invoice_num;\n                var paymentData = {};\n\n                for (var key in response.directpost.fields) {\n                    paymentData[key] = response.directpost.fields[key];\n                }\n                var preparedData = this.preparePaymentRequest(paymentData);\n\n                this.sendPaymentRequest(preparedData);\n            } else {\n                if (response.redirect) {\n                    window.location = response.redirect;\n                }\n\n                if (response.error_messages) {\n                    var msg = response.error_messages;\n\n                    if (typeof msg == 'object') {\n                        msg = msg.join('\\n');\n                    }\n\n                    if (msg) {\n                        alert(msg);\n                    }\n                }\n            }\n        },\n\n        preparePaymentRequest: function (data) {\n            if ($(this.code + '_cc_cid')) {\n                data.x_card_code = $(this.code + '_cc_cid').value;\n            }\n            var year = $(this.code + '_expiration_yr').value;\n\n            if (year.length > 2) {\n                year = year.substring(2);\n            }\n            var month = parseInt($(this.code + '_expiration').value, 10);\n\n            if (month < 10) {\n                month = '0' + month;\n            }\n\n            data.x_exp_date = month + '/' + year;\n            data.x_card_num = $(this.code + '_cc_number').value;\n\n            return data;\n        },\n\n        sendPaymentRequest: function (preparedData) {\n            this.recreateIframe();\n            this.tmpForm = document.createElement('form');\n            this.tmpForm.style.display = 'none';\n            this.tmpForm.enctype = 'application/x-www-form-urlencoded';\n            this.tmpForm.method = 'POST';\n            document.body.appendChild(this.tmpForm);\n            this.tmpForm.action = this.cgiUrl;\n            this.tmpForm.target = $(this.iframeId).readAttribute('name');\n            this.tmpForm.setAttribute('target', $(this.iframeId).readAttribute('name'));\n\n            for (var param in preparedData) {\n                this.tmpForm.appendChild(this.createHiddenElement(param, preparedData[param]));\n            }\n\n            this.paymentRequestSent = true;\n            this.tmpForm.submit();\n        },\n\n        createHiddenElement: function (name, value) {\n            var field;\n\n            if (isIE) {\n                field = document.createElement('input');\n                field.setAttribute('type', 'hidden');\n                field.setAttribute('name', name);\n                field.setAttribute('value', value);\n            } else {\n                field = document.createElement('input');\n                field.type = 'hidden';\n                field.name = name;\n                field.value = value;\n            }\n\n            return field;\n        },\n\n        recreateIframe: function () {\n            if ($(this.iframeId)) {\n                var nextElement = $(this.iframeId).next();\n                var src = $(this.iframeId).readAttribute('src');\n                var name = $(this.iframeId).readAttribute('name');\n\n                $(this.iframeId).stopObserving();\n                $(this.iframeId).remove();\n                var iframe = '<iframe id=\"' + this.iframeId +\n                    '\" allowtransparency=\"true\" frameborder=\"0\"  name=\"' + name +\n                    '\" style=\"display:none;width:100%;background-color:transparent\" src=\"' + src + '\" />';\n\n                Element.insert(nextElement, {\n                    'before': iframe\n                });\n                $(this.iframeId).observe('load', this.onLoadIframe);\n            }\n        }\n    };\n}));\n","Magento_InventoryCatalogAdminUi/js/product/form/stock-status.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            links: {\n                linkedValue: false\n            }\n        },\n\n        /** @inheritdoc */\n        getInitialValue: function () {\n            var values = [this.source.get(this.dataScope), this.default],\n                value;\n\n            values.some(function (v) {\n                if (v !== null && v !== undefined) {\n                    value = v;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return this.normalizeData(value);\n        },\n\n        /** @inheritdoc */\n        setDifferedFromDefault: function () {\n            this._super();\n\n            if (parseFloat(this.initialValue) !== parseFloat(this.value())) {\n                this.source.set(this.dataScope, this.value());\n            } else {\n                this.source.remove(this.dataScope);\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_CatalogInventory/js/components/qty-validator-changer'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            links: {\n                value: false\n            }\n        },\n\n        /** @inheritdoc */\n        getInitialValue: function () {\n            var values = [this.source.get(this.dataScope), this.default],\n                value;\n\n            values.some(function (v) {\n                if (v !== null && v !== undefined) {\n                    value = v;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return this.normalizeData(value);\n        },\n\n        /** @inheritdoc */\n        setDifferedFromDefault: function () {\n            this._super();\n\n            if (this.value() && parseFloat(this.initialValue) !== parseFloat(this.value())) {\n                this.source.set(this.dataScope, this.value());\n            } else {\n                this.source.remove(this.dataScope);\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/source-items.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'uiRegistry',\n    'underscore'\n], function (Fieldset, registry, _) {\n    'use strict';\n\n    return Fieldset.extend({\n        defaults: {\n            advancedInventoryButtonIndex: '',\n            imports: {\n                onStockChange: '${ $.provider }:data.product.stock_data.manage_stock'\n            }\n        },\n\n        /**\n         * \"Advanced Inventory\" button should stay active in any case.\n         *\n         * @param {Integer} canManageStock\n         */\n        onStockChange: function (canManageStock) {\n            var advancedInventoryButton = registry.get('index = ' + this.advancedInventoryButtonIndex);\n\n            if (canManageStock === 0) {\n                if (!_.isUndefined(advancedInventoryButton)) {\n                    advancedInventoryButton.disabled(false);\n                }\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/grid/cell/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryCatalogAdminUi/product/grid/cell/source-items.html',\n            itemsToDisplay: 5\n        },\n\n        /**\n         * Get source items data (source name and qty)\n         *\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSourceItemsData: function (record) {\n            return record[this.index] ? record[this.index] : [];\n        },\n\n        /**\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSourceItemsDataCut: function (record) {\n            return this.getSourceItemsData(record).slice(0, this.itemsToDisplay);\n        }\n    });\n});\n","Magento_Sales/js/bootstrap/order-create-index.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'Magento_Sales/order/create/giftmessage'\n]);\n","Magento_Sales/js/bootstrap/order-post-action.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'Magento_Sales/order/view/post-wrapper'\n]);\n","Magento_Sales/order/giftoptions_tooltip.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'prototype'\n], function () {\n    'use strict';\n\n    var GiftOptionsTooltip = Class.create();\n\n    GiftOptionsTooltip.prototype = {\n        _tooltipLines: [],\n        _tooltipWindow: null,\n        _tooltipWindowContent: null,\n        _targetLinks: [],\n        _eventMouseOver: null,\n        _eventMouseOut: null,\n        _styleOptions: null,\n        _tooltipContentLoaderFunction: null,\n\n        /**\n         * Initialize tooltip object\n         */\n        initialize: function () {\n            var options = Object.extend({\n                'delta_x': 30,\n                'delta_y': 0,\n                zindex: 1000\n            });\n\n            this._styleOptions = options;\n            this._eventMouseOver = this.showTooltip.bindAsEventListener(this);\n            this._eventMouseOut = this.hideTooltip.bindAsEventListener(this);\n        },\n\n        /**\n         * Set gift options tooltip window\n         *\n         * @param {String} windowId\n         * @param {String} contentId\n         *\n         * @return boolean success\n         */\n        setTooltipWindow: function (windowId, contentId) {\n            if (!$(windowId) || !$(contentId)) {\n                return false;\n            }\n            this._tooltipWindow = $(windowId);\n            this._tooltipWindowContent = $(contentId);\n            $(document.body).insert({\n                bottom: this._tooltipWindow\n            });\n            this.hideTooltip();\n\n            return true;\n        },\n\n        /**\n         * Add tooltip to specified link\n         *\n         * @param {String} linkId\n         * @param {String} itemId - identifier of the item related to link\n         *\n         * @return boolean success\n         */\n        addTargetLink: function (linkId, itemId) {\n            if ($(linkId)) {\n                this._targetLinks[linkId] = [];\n                this._targetLinks[linkId].object = $(linkId);\n                this._targetLinks[linkId].itemId = itemId;\n                this._registerEvents(this._targetLinks[linkId].object);\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Detach event listeners from target links when tooltip is destroyed\n         */\n        destroy: function () {\n            var linkId;\n\n            for (linkId in this._targetLinks) { //eslint-disable-line guard-for-in\n                Event.stopObserving(this._targetLinks[linkId].object, 'mouseover', this._eventMouseOver);\n                Event.stopObserving(this._targetLinks[linkId].object, 'mouseout', this._eventMouseOut);\n            }\n        },\n\n        /**\n         *  Register event listeners\n         *\n         *  @param {HTMLElement} element\n         */\n        _registerEvents: function (element) {\n            Event.observe(element, 'mouseover', this._eventMouseOver);\n            Event.observe(element, 'mouseout', this._eventMouseOut);\n        },\n\n        /**\n         * Move tooltip to mouse position\n         *\n         * @param {Prototype.Event} event\n         */\n        _moveTooltip: function (event) {\n            var mouseX, mouseY;\n\n            Event.stop(event);\n            mouseX = Event.pointerX(event);\n            mouseY = Event.pointerY(event);\n\n            this.setStyles(mouseX, mouseY);\n        },\n\n        /**\n         * Show tooltip\n         *\n         * @param {Object} event\n         *\n         * @return boolean success\n         */\n        showTooltip: function (event) {\n            var link, itemId, tooltipContent;\n\n            Event.stop(event);\n\n            if (this._tooltipWindow) {\n                link = Event.element(event);\n                itemId = this._targetLinks[link.id].itemId;\n                tooltipContent = '';\n\n                if (Object.isFunction(this._tooltipContentLoaderFunction)) {\n                    tooltipContent = this._tooltipContentLoaderFunction(itemId);\n                }\n\n                if (tooltipContent != '') { //eslint-disable-line eqeqeq\n                    this._updateTooltipWindowContent(tooltipContent);\n                    this._moveTooltip(event);\n                    new Element.show(this._tooltipWindow);\n\n                    return true;\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * Set tooltip window styles\n         *\n         * @param {Number} x\n         * @param {Number} y\n         */\n        setStyles: function (x, y) {\n            Element.setStyle(this._tooltipWindow, {\n                position: 'absolute',\n                top: y + this._styleOptions['delta_y'] + 'px',\n                left: x + this._styleOptions['delta_x'] + 'px',\n                zindex: this._styleOptions.zindex\n            });\n        },\n\n        /**\n         * Hide tooltip\n         */\n        hideTooltip: function () {\n            if (this._tooltipWindow) {\n                new Element.hide(this._tooltipWindow);\n            }\n        },\n\n        /**\n         * Set gift options tooltip content loader function\n         * This function should accept at least one parameter that will serve as an item ID\n         *\n         * @param {Function} loaderFunction - loader function\n         */\n        setTooltipContentLoaderFunction: function (loaderFunction) {\n            this._tooltipContentLoaderFunction = loaderFunction;\n        },\n\n        /**\n         * Update tooltip window content\n         *\n         * @param {String} content\n         */\n        _updateTooltipWindowContent: function (content) {\n            this._tooltipWindowContent.update(content);\n        }\n    };\n\n    window.giftOptionsTooltip = new GiftOptionsTooltip();\n});\n","Magento_Sales/order/edit/message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.orderEditDialog', {\n        options: {\n            url:     null,\n            message: null,\n            modal:  null\n        },\n\n        /**\n         * @protected\n         */\n        _create: function () {\n            this._prepareDialog();\n        },\n\n        /**\n         * Show modal\n         */\n        showDialog: function () {\n            this.options.dialog.html(this.options.message).modal('openModal');\n        },\n\n        /**\n         * Redirect to edit page\n         */\n        redirect: function () {\n            window.location = this.options.url;\n        },\n\n        /**\n         * Prepare modal\n         * @protected\n         */\n        _prepareDialog: function () {\n            var self = this;\n\n            this.options.dialog = $('<div class=\"ui-dialog-content ui-widget-content\"></div>').modal({\n                type: 'popup',\n                modalClass: 'edit-order-popup',\n                title: $.mage.__('Edit Order'),\n                buttons: [{\n                    text: $.mage.__('Ok'),\n                    'class': 'action-primary',\n\n                    /** @inheritdoc */\n                    click: function () {\n                        self.redirect();\n                    }\n                }]\n            });\n        }\n    });\n\n    return $.mage.orderEditDialog;\n});\n","Magento_Sales/order/edit/address/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * Currently Magento App stores both  region_id and region (as text) values.\n     * To prevent missing region (as text) we need to copy it in hidden field.\n     * @param {Array} config\n     * @param {String} element\n     */\n    return function (config, element) {\n        var form = $(element),\n            regionId = form.find('#region_id'),\n\n            /**\n             * Set region callback\n             */\n            setRegion = function () {\n                form.find('#region').val(regionId.filter(':visible').find(':selected').text());\n            };\n\n        if (regionId.is('visible')) {\n            setRegion();\n        }\n\n        regionId.on('change', setRegion);\n        form.find('#country_id').on('change', setRegion);\n    };\n});\n","Magento_Sales/order/create/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global AdminOrder */\ndefine([\n    'jquery',\n    'Magento_Sales/order/create/scripts'\n], function (jQuery) {\n    'use strict';\n\n    var $el = jQuery('#edit_form'),\n        config,\n        baseUrl,\n        order,\n        payment;\n\n    if (!$el.length || !$el.data('order-config')) {\n        return;\n    }\n\n    config = $el.data('order-config');\n    baseUrl = $el.data('load-base-url');\n\n    order = new AdminOrder(config);\n    order.setLoadBaseUrl(baseUrl);\n\n    payment = {\n        switchMethod: order.switchPaymentMethod.bind(order)\n    };\n\n    window.order = order;\n    window.payment = payment;\n});\n","Magento_Sales/order/create/giftmessage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/********************* GIFT OPTIONS POPUP ***********************/\n/********************* GIFT OPTIONS SET ***********************/\n\ndefine([\n    'jquery',\n    'jquery/ui',\n    'mage/translate',\n    'mage/validation',\n    'prototype'\n], function (jQuery) {\n\n    window.giftMessagesController = {\n        toogleRequired: function (source, objects) {\n            if (!$(source).value.blank()) {\n                objects.each(function (item) {\n                    $(item).addClassName('required-entry');\n                    var label = findFieldLabel($(item));\n\n                    if (label) {\n                        var span = label.down('span');\n\n                        if (!span) {\n                            Element.insert(label, {\n                                bottom: '&nbsp;<span class=\"required\">*</span>'\n                            });\n                        }\n                    }\n                });\n            } else {\n                objects.each(function (item) {\n                    if ($(source).formObj && $(source).formObj.validator) {\n                        $(source).formObj.validator.reset(item);\n                    }\n                    $(item).removeClassName('required-entry');\n                    var label = findFieldLabel($(item));\n\n                    if (label) {\n                        var span = label.down('span');\n\n                        if (span) {\n                            Element.remove(span);\n                        }\n                    }\n                    // Hide validation advices if exist\n                    if ($(item) && $(item).advices) {\n                        $(item).advices.each(function (pair) {\n                            if (pair.value != null) pair.value.hide();\n                        });\n                    }\n                });\n            }\n        },\n        toogleGiftMessage: function (container) {\n            if (!$(container).toogleGiftMessage) {\n                $(container).toogleGiftMessage = true;\n                $(this.getFieldId(container, 'edit')).show();\n                $(container).down('.action-link').addClassName('open');\n                $(container).down('.default-text').hide();\n                $(container).down('.close-text').show();\n            } else {\n                $(container).toogleGiftMessage = false;\n                $(this.getFieldId(container, 'message')).formObj = $(this.getFieldId(container, 'form'));\n                var form = jQuery('#' + this.getFieldId(container, 'form'));\n\n                jQuery('#' + this.getFieldId(container, 'form')).validate({\n                    errorClass: 'mage-error'\n                });\n\n                if (!form.valid()) {\n                    return false;\n                }\n\n                new Ajax.Request($(this.getFieldId(container, 'form')).action, {\n                    parameters: Form.serialize($(this.getFieldId(container, 'form')), true),\n                    loaderArea: container,\n                    onComplete: function (transport) {\n\n                        $(container).down('.action-link').removeClassName('open');\n                        $(container).down('.default-text').show();\n                        $(container).down('.close-text').hide();\n                        $(this.getFieldId(container, 'edit')).hide();\n\n                        if (transport.responseText.match(/YES/g)) {\n                            $(container).down('.default-text').down('.edit').show();\n                            $(container).down('.default-text').down('.add').hide();\n                        } else {\n                            $(container).down('.default-text').down('.add').show();\n                            $(container).down('.default-text').down('.edit').hide();\n                        }\n\n                    }.bind(this)\n                });\n            }\n\n            return false;\n        },\n        saveGiftMessage: function (container) {\n            $(this.getFieldId(container, 'message')).formObj = $(this.getFieldId(container, 'form'));\n\n            var form = jQuery('#' + this.getFieldId(container, 'form'));\n\n            form.validate({\n                errorClass: 'mage-error'\n            });\n\n            if (!form.valid()) {\n                return;\n            }\n\n            new Ajax.Request($(this.getFieldId(container, 'form')).action, {\n                parameters: Form.serialize($(this.getFieldId(container, 'form')), true),\n                loaderArea: container,\n                onSuccess: function (response) {\n                    var message = '<div class=\"messages\"><div class=\"message message-success success\">' +\n                        response.responseText +\n                        '<div data-ui-id=\"messages-message-success\"></div></div></div>';\n\n                    jQuery('#messages').html(message);\n                    jQuery(document).scrollTop(0);\n                }\n            });\n        },\n        getFieldId: function (container, name) {\n            return container + '_' + name;\n        }\n    };\n\n    function findFieldLabel(field) {\n        var tdField = $(field).up('td');\n\n        if (tdField) {\n            var tdLabel = tdField.previous('td');\n\n            if (tdLabel) {\n                var label = tdLabel.down('label');\n\n                if (label) {\n                    return label;\n                }\n            }\n        }\n\n        return false;\n    }\n\n    window.findFieldLabel = findFieldLabel;\n\n    window.GiftOptionsPopup = Class.create();\n    GiftOptionsPopup.prototype = {\n        //giftOptionsWindowMask: null,\n        giftOptionsWindow: null,\n\n        initialize: function () {\n            $$('.action-link').each(function (el) {\n                Event.observe(el, 'click', this.showItemGiftOptions.bind(this));\n            }, this);\n\n            // Move gift options popup to start of body, because soon it will contain FORM tag that can break DOM layout if within other FORM\n            var oldPopupContainer = $('gift_options_configure');\n\n            if (oldPopupContainer) {\n                oldPopupContainer.remove();\n            }\n\n            var newPopupContainer = $('gift_options_configure_new');\n\n            $(document.body).insert({\n                top: newPopupContainer\n            });\n            newPopupContainer.id = 'gift_options_configure';\n\n            // Put controls container inside a FORM tag so we can use Validator\n            var form = new Element('form', {\n                action: '#', id: 'gift_options_configuration_form', method: 'post'\n            });\n            var formContents = $('gift_options_form_contents');\n\n            if (formContents) {\n                formContents.parentNode.appendChild(form);\n                form.appendChild(formContents);\n            }\n\n            this.giftOptionsWindow = $('gift_options_configure');\n\n            jQuery(this.giftOptionsWindow).dialog({\n                autoOpen:   false,\n                modal:      true,\n                resizable:  false,\n                dialogClass: 'gift-options-popup',\n                minWidth:   500,\n                width:      '75%',\n                position: {\n                    my: 'left+12.5% top',\n                    at: 'center top',\n                    of: 'body'\n                },\n                open: function () {\n                    jQuery(this).closest('.ui-dialog').addClass('ui-dialog-active');\n\n                    var topMargin = jQuery(this).closest('.ui-dialog').children('.ui-dialog-titlebar').outerHeight() + 30;\n\n                    jQuery(this).closest('.ui-dialog').css('margin-top', topMargin);\n                },\n                close: function () {\n                    jQuery(this).closest('.ui-dialog').removeClass('ui-dialog-active');\n                }\n            });\n        },\n\n        showItemGiftOptions: function (event) {\n            var element = Event.element(event).id;\n            var itemId = element.sub('gift_options_link_', '');\n\n            jQuery(this.giftOptionsWindow).dialog('open');\n\n            this.setTitle(itemId);\n\n            Event.observe($('gift_options_cancel_button'), 'click', this.onCloseButton.bind(this));\n            Event.observe($('gift_options_ok_button'), 'click', this.onOkButton.bind(this));\n            Event.stop(event);\n        },\n\n        setTitle: function (itemId) {\n            var productTitleElement = $('order_item_' + itemId + '_title');\n            var productTitle = '';\n\n            if (productTitleElement) {\n                productTitle = productTitleElement.innerHTML;\n            }\n            jQuery(this.giftOptionsWindow).dialog({\n                title: jQuery.mage.__('Gift Options for ') + productTitle\n            });\n        },\n\n        onOkButton: function () {\n            var giftOptionsForm = jQuery('#gift_options_configuration_form');\n\n            if (!giftOptionsForm.validate({\n                errorClass: 'mage-error'\n            }).valid()) {\n                return false;\n            }\n\n            if (jQuery.isFunction(giftOptionsForm[0].reset)) {\n                giftOptionsForm[0].reset();\n            }\n            this.closeWindow();\n\n            return true;\n        },\n\n        onCloseButton: function () {\n            this.closeWindow();\n        },\n\n        closeWindow: function () {\n            jQuery(this.giftOptionsWindow).dialog('close');\n        }\n    };\n\n    window.GiftMessageSet = Class.create();\n\n    GiftMessageSet.prototype = {\n        destPrefix: 'current_item_giftmessage_',\n        sourcePrefix: 'giftmessage_',\n        fields: ['sender', 'recipient', 'message'],\n        isObserved: false,\n        callback: null,\n\n        initialize: function () {\n            $$('.action-link').each(function (el) {\n                Event.observe(el, 'click', this.setData.bind(this));\n            }, this);\n        },\n\n        setData: function (event) {\n            var element = Event.element(event).id;\n\n            this.id = element.sub('gift_options_link_', '');\n\n            if ($('gift-message-form-data-' + this.id)) {\n                this.fields.each(function (el) {\n                    if ($(this.sourcePrefix + this.id + '_' + el) && $(this.destPrefix + el)) {\n                        $(this.destPrefix + el).value = $(this.sourcePrefix + this.id + '_' + el).value;\n                    }\n                }, this);\n                $('gift_options_giftmessage').show();\n            } else if ($('gift_options_giftmessage')) {\n                $('gift_options_giftmessage').hide();\n            }\n\n            if (!this.isObserved) {\n                Event.observe('gift_options_ok_button', 'click', this.saveData.bind(this));\n                this.isObserved = true;\n            }\n        },\n\n        prepareSaveData: function () {\n            var hash = $H();\n\n            $$('div[id^=gift_options_data_]').each(function (el) {\n                var fields = el.select('input', 'select', 'textarea');\n                var data = Form.serializeElements(fields, true);\n\n                hash.update(data);\n            });\n\n            return hash;\n        },\n\n        setSaveCallback: function (callback) {\n            if (typeof callback == 'function') {\n                this.callback = callback;\n            }\n        },\n\n        saveData: function (event) {\n            this.fields.each(function (el) {\n                if ($(this.sourcePrefix + this.id + '_' + el) && $(this.destPrefix + el)) {\n                    $(this.sourcePrefix + this.id + '_' + el).value = $(this.destPrefix + el).value;\n                }\n            }, this);\n\n            if ($(this.sourcePrefix + this.id + '_form')) {\n                $(this.sourcePrefix + this.id + '_form').request();\n            } else if (typeof order != 'undefined') {\n                var data = this.prepareSaveData();\n                var self = this;\n\n                jQuery.when(order.loadArea(['items'], true, data.toObject())).done(function () {\n                    if (self.callback !== null) {\n                        self.callback();\n                    }\n                });\n            }\n        }\n    };\n\n});\n","Magento_Sales/order/create/scripts.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'mage/template',\n    'text!Magento_Sales/templates/order/create/shipping/reload.html',\n    'text!Magento_Sales/templates/order/create/payment/reload.html',\n    'mage/translate',\n    'prototype',\n    'Magento_Catalog/catalog/product/composite/configure',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (jQuery, confirm, alert, template, shippingTemplate, paymentTemplate) {\n\n    window.AdminOrder = new Class.create();\n\n    AdminOrder.prototype = {\n        initialize : function(data){\n            if(!data) data = {};\n            this.loadBaseUrl    = false;\n            this.customerId     = data.customer_id ? data.customer_id : false;\n            this.storeId        = data.store_id ? data.store_id : false;\n            this.quoteId        = data['quote_id'] ? data['quote_id'] : false;\n            this.currencyId     = false;\n            this.currencySymbol = data.currency_symbol ? data.currency_symbol : '';\n            this.addresses      = data.addresses ? data.addresses : $H({});\n            this.shippingAsBilling = data.shippingAsBilling ? data.shippingAsBilling : false;\n            this.gridProducts   = $H({});\n            this.gridProductsGift = $H({});\n            this.billingAddressContainer = '';\n            this.shippingAddressContainer = '';\n            this.isShippingMethodReseted = data.shipping_method_reseted ? data.shipping_method_reseted : false;\n            this.overlayData = $H({});\n            this.giftMessageDataChanged = false;\n            this.productConfigureAddFields = {};\n            this.productPriceBase = {};\n            this.collectElementsValue = true;\n            this.isOnlyVirtualProduct = false;\n            this.excludedPaymentMethods = [];\n            this.summarizePrice = true;\n            this.selectAddressEvent = false;\n            this.shippingTemplate = template(shippingTemplate, {\n                data: {\n                    title: jQuery.mage.__('Shipping Method'),\n                    linkText: jQuery.mage.__('Get shipping methods and rates')\n                }\n            });\n            this.paymentTemplate = template(paymentTemplate, {\n                data: {\n                    title: jQuery.mage.__('Payment Method'),\n                    linkText: jQuery.mage.__('Get available payment methods')\n                }\n            });\n\n            jQuery.async('#order-items', (function(){\n                this.dataArea = new OrderFormArea('data', $(this.getAreaId('data')), this);\n                this.itemsArea = Object.extend(new OrderFormArea('items', $(this.getAreaId('items')), this), {\n                    addControlButton: function(button){\n                        var controlButtonArea = $(this.node).select('.actions')[0];\n                        if (typeof controlButtonArea != 'undefined') {\n                            var buttons = controlButtonArea.childElements();\n                            for (var i = 0; i < buttons.length; i++) {\n                                if (buttons[i].innerHTML.include(button.getLabel())) {\n                                    return;\n                                }\n                            }\n                            button.insertIn(controlButtonArea, 'top');\n                        }\n                    }\n                });\n\n                var searchButtonId = 'add_products',\n                    searchButton = new ControlButton(jQuery.mage.__('Add Products'), searchButtonId),\n                    searchAreaId = this.getAreaId('search');\n                searchButton.onClick = function() {\n                    $(searchAreaId).show();\n                    var el = this;\n                    window.setTimeout(function () {\n                        el.remove();\n                    }, 10);\n                };\n\n                if (jQuery('#' + this.getAreaId('items')).is(':visible')) {\n                    this.dataArea.onLoad = this.dataArea.onLoad.wrap(function(proceed) {\n                        proceed();\n                        this._parent.itemsArea.setNode($(this._parent.getAreaId('items')));\n                        this._parent.itemsArea.onLoad();\n                    });\n\n                    this.itemsArea.onLoad = this.itemsArea.onLoad.wrap(function(proceed) {\n                        proceed();\n                        if ($(searchAreaId) && !$(searchAreaId).visible() && !$(searchButtonId)) {\n                            this.addControlButton(searchButton);\n                        }\n                    });\n                    this.areasLoaded();\n                    this.itemsArea.onLoad();\n                }\n            }).bind(this));\n\n            jQuery('#edit_form')\n                .on('submitOrder', function(){\n                    jQuery(this).trigger('realOrder');\n                })\n                .on('realOrder', this._realSubmit.bind(this));\n        },\n\n        areasLoaded: function(){\n        },\n\n        itemsLoaded: function(){\n        },\n\n        dataLoaded: function(){\n            this.dataShow();\n        },\n\n        setLoadBaseUrl : function(url){\n            this.loadBaseUrl = url;\n        },\n\n        setAddresses : function(addresses){\n            this.addresses = addresses;\n        },\n\n        addExcludedPaymentMethod : function(method){\n            this.excludedPaymentMethods.push(method);\n        },\n\n        setCustomerId : function(id){\n            this.customerId = id;\n            this.loadArea('header', true);\n            $(this.getAreaId('header')).callback = 'setCustomerAfter';\n            $('back_order_top_button').hide();\n            $('reset_order_top_button').show();\n        },\n\n        setCustomerAfter : function () {\n            this.customerSelectorHide();\n            if (this.storeId) {\n                $(this.getAreaId('data')).callback = 'dataLoaded';\n                this.loadArea(['data'], true);\n            }\n            else {\n                this.storeSelectorShow();\n            }\n        },\n\n        setStoreId : function(id){\n            this.storeId = id;\n            this.storeSelectorHide();\n            this.sidebarShow();\n            //this.loadArea(['header', 'sidebar','data'], true);\n            this.dataShow();\n            this.loadArea(['header', 'data'], true);\n        },\n\n        setCurrencyId : function(id){\n            this.currencyId = id;\n            //this.loadArea(['sidebar', 'data'], true);\n            this.loadArea(['data'], true);\n        },\n\n        setCurrencySymbol : function(symbol){\n            this.currencySymbol = symbol;\n        },\n\n        selectAddress : function(el, container){\n\n            id = el.value;\n            if (id.length == 0) {\n                id = '0';\n            }\n\n            this.selectAddressEvent = true;\n            if (this.addresses[id]) {\n                this.fillAddressFields(container, this.addresses[id]);\n            } else {\n                this.fillAddressFields(container, {});\n            }\n            this.selectAddressEvent = false;\n\n            var data = this.serializeData(container);\n            data[el.name] = id;\n\n            this.resetPaymentMethod();\n            if (this.isShippingField(container) && !this.isShippingMethodReseted) {\n                this.resetShippingMethod(data);\n            } else{\n                this.saveData(data);\n            }\n\n        },\n\n        /**\n         * Checks if the field belongs to the shipping address.\n         *\n         * @param {String} fieldId\n         * @return {Boolean}\n         */\n        isShippingField: function (fieldId) {\n            if (this.shippingAsBilling) {\n                return fieldId.include('billing');\n            }\n\n            return fieldId.include('shipping');\n        },\n\n        /**\n         * Checks if the field belongs to the billing address.\n         *\n         * @param {String} fieldId\n         * @return {Boolean}\n         */\n        isBillingField: function (fieldId) {\n            return fieldId.include('billing');\n        },\n\n        /**\n         * Binds events on container form fields.\n         *\n         * @param {String} container\n         */\n        bindAddressFields: function (container) {\n            var fields = $(container).select('input', 'select', 'textarea'),\n                i;\n\n            for (i = 0; i < fields.length; i++) {\n                jQuery(fields[i]).change(this.changeAddressField.bind(this));\n            }\n        },\n\n        /**\n         * Triggers on each form's element changes.\n         *\n         * @param {Event} event\n         */\n        changeAddressField: function (event) {\n            var field = Event.element(event),\n                re = /[^\\[]*\\[([^\\]]*)_address\\]\\[([^\\]]*)\\](\\[(\\d)\\])?/,\n                matchRes = field.name.match(re),\n                type,\n                name,\n                data,\n                resetShipping = false;\n\n            if (!matchRes) {\n                return;\n            }\n\n            type = matchRes[1];\n            name = matchRes[2];\n\n            if (this.isBillingField(field.id)) {\n                data = this.serializeData(this.billingAddressContainer);\n            } else {\n                data = this.serializeData(this.shippingAddressContainer);\n            }\n            data = data.toObject();\n\n            if (type === 'billing' && this.shippingAsBilling) {\n                this.syncAddressField(this.shippingAddressContainer, field.name, field);\n                resetShipping = true;\n            }\n\n            if (type === 'shipping' && !this.shippingAsBilling) {\n                resetShipping = true;\n            }\n\n            if (resetShipping) {\n                data['reset_shipping'] = true;\n            }\n\n            data['order[' + type + '_address][customer_address_id]'] = null;\n            data['shipping_as_billing'] = +this.shippingAsBilling;\n\n            if (name === 'customer_address_id') {\n                data['order[' + type + '_address][customer_address_id]'] =\n                    $('order-' + type + '_address_customer_address_id').value;\n            }\n\n            if (name === 'country_id' && this.selectAddressEvent === false) {\n                $('order-' + type + '_address_customer_address_id').value = '';\n            }\n\n            this.resetPaymentMethod();\n\n            if (data['reset_shipping']) {\n                this.resetShippingMethod();\n            } else {\n                this.saveData(data);\n\n                if (name === 'country_id' || name === 'customer_address_id') {\n                    this.loadArea(['shipping_method', 'billing_method', 'totals', 'items'], true, data);\n                }\n            }\n        },\n\n        /**\n         * Set address container form field value.\n         *\n         * @param {String} container - container ID\n         * @param {String} fieldName - form field name\n         * @param {*} fieldValue - form field value\n         */\n        syncAddressField: function (container, fieldName, fieldValue) {\n            var syncName;\n\n            if (this.isBillingField(fieldName)) {\n                syncName = fieldName.replace('billing', 'shipping');\n            }\n\n            $(container).select('[name=\"' + syncName + '\"]').each(function (element) {\n                if (~['input', 'textarea', 'select'].indexOf(element.tagName.toLowerCase())) {\n                    if (element.type === \"checkbox\") {\n                        element.checked = fieldValue.checked;\n                    } else {\n                        element.value = fieldValue.value;\n                    }\n                }\n            });\n        },\n\n        fillAddressFields: function(container, data){\n            var regionIdElem = false;\n            var regionIdElemValue = false;\n\n            var fields = $(container).select('input', 'select', 'textarea');\n            var re = /[^\\[]*\\[[^\\]]*\\]\\[([^\\]]*)\\](\\[(\\d)\\])?/;\n            for(var i=0;i<fields.length;i++){\n                // skip input type file @Security error code: 1000\n                if (fields[i].tagName.toLowerCase() == 'input' && fields[i].type.toLowerCase() == 'file') {\n                    continue;\n                }\n                var matchRes = fields[i].name.match(re);\n                if (matchRes === null) {\n                    continue;\n                }\n                var name = matchRes[1];\n                var index = matchRes[3];\n\n                if (index){\n                    // multiply line\n                    if (data[name]){\n                        var values = data[name].split(\"\\n\");\n                        fields[i].value = values[index] ? values[index] : '';\n                    } else {\n                        fields[i].value = '';\n                    }\n                } else if (fields[i].tagName.toLowerCase() == 'select' && fields[i].multiple) {\n                    // multiselect\n                    if (data[name]) {\n                        values = [''];\n                        if (Object.isString(data[name])) {\n                            values = data[name].split(',');\n                        } else if (Object.isArray(data[name])) {\n                            values = data[name];\n                        }\n                        fields[i].setValue(values);\n                    }\n                } else {\n                    fields[i].setValue(data[name] ? data[name] : '');\n                }\n\n                if (fields[i].changeUpdater) {\n                    fields[i].changeUpdater();\n                }\n\n                if (name == 'region' && data['region_id'] && !data['region']){\n                    fields[i].value = data['region_id'];\n                }\n\n                jQuery(fields[i]).trigger('change');\n            }\n        },\n\n        disableShippingAddress : function(flag) {\n            this.shippingAsBilling = flag;\n            if ($('order-shipping_address_customer_address_id')) {\n                $('order-shipping_address_customer_address_id').disabled = flag;\n            }\n            if ($(this.shippingAddressContainer)) {\n                var dataFields = $(this.shippingAddressContainer).select('input', 'select', 'textarea');\n                for (var i = 0; i < dataFields.length; i++) {\n                    dataFields[i].disabled = flag;\n\n                    if(this.isOnlyVirtualProduct) {\n                        dataFields[i].setValue('');\n                    }\n                }\n                var buttons = $(this.shippingAddressContainer).select('button');\n                // Add corresponding class to buttons while disabling them\n                for (i = 0; i < buttons.length; i++) {\n                    buttons[i].disabled = flag;\n                    if (flag) {\n                        buttons[i].addClassName('disabled');\n                    } else {\n                        buttons[i].removeClassName('disabled');\n                    }\n                }\n            }\n        },\n\n        /**\n         * Equals shipping and billing addresses.\n         *\n         * @param {Boolean} flag\n         */\n        setShippingAsBilling: function (flag) {\n            var data,\n                areasToLoad = ['billing_method', 'shipping_address', 'shipping_method', 'totals', 'giftmessage'];\n\n            this.disableShippingAddress(flag);\n            data = this.serializeData(flag ? this.billingAddressContainer : this.shippingAddressContainer);\n            data = data.toObject();\n            data['shipping_as_billing'] = flag ? 1 : 0;\n            data['reset_shipping'] = 1;\n            this.loadArea(areasToLoad, true, data);\n        },\n\n        /**\n         * Replace shipping method area.\n         */\n        resetShippingMethod: function () {\n            if (!this.isOnlyVirtualProduct) {\n                $(this.getAreaId('shipping_method')).update(this.shippingTemplate);\n            }\n        },\n\n        /**\n         * Replace payment method area.\n         */\n        resetPaymentMethod: function () {\n            $(this.getAreaId('billing_method')).update(this.paymentTemplate);\n        },\n\n        /**\n         * Loads shipping options according to address data.\n         *\n         * @return {Boolean}\n         */\n        loadShippingRates: function () {\n            var addressContainer = this.shippingAsBilling ?\n                    'billingAddressContainer' :\n                    'shippingAddressContainer',\n                data = this.serializeData(this[addressContainer]).toObject();\n\n            data['collect_shipping_rates'] = 1;\n            this.isShippingMethodReseted = false;\n            this.loadArea(['shipping_method', 'totals'], true, data);\n\n            return false;\n        },\n\n        setShippingMethod: function(method) {\n            var data = {};\n\n            data['order[shipping_method]'] = method;\n            this.loadArea([\n                'shipping_method',\n                'totals',\n                'billing_method'\n            ], true, data);\n        },\n\n        /**\n         * Updates available payment\n         * methods list according to order data.\n         *\n         * @return boolean\n         */\n        loadPaymentMethods: function() {\n            var data = this.serializeData(this.billingAddressContainer).toObject();\n\n            this.loadArea(['billing_method','totals'], true, data);\n\n            return false;\n        },\n\n        switchPaymentMethod: function(method){\n            jQuery('#edit_form')\n                .off('submitOrder')\n                .on('submitOrder', function(){\n                    jQuery(this).trigger('realOrder');\n                });\n            jQuery('#edit_form').trigger('changePaymentMethod', [method]);\n            this.setPaymentMethod(method);\n            var data = {};\n            data['order[payment_method]'] = method;\n            this.loadArea(['card_validation'], true, data);\n        },\n\n        setPaymentMethod : function(method){\n            if (this.paymentMethod && $('payment_form_'+this.paymentMethod)) {\n                var form = 'payment_form_'+this.paymentMethod;\n                [form + '_before', form, form + '_after'].each(function(el) {\n                    var block = $(el);\n                    if (block) {\n                        block.hide();\n                        block.select('input', 'select', 'textarea').each(function(field) {\n                            field.disabled = true;\n                        });\n                    }\n                });\n            }\n\n            if(!this.paymentMethod || method){\n                $('order-billing_method_form').select('input', 'select', 'textarea').each(function(elem){\n                    if(elem.type != 'radio') elem.disabled = true;\n                })\n            }\n\n            if ($('payment_form_'+method)){\n                jQuery('#' + this.getAreaId('billing_method')).trigger('contentUpdated');\n                this.paymentMethod = method;\n                var form = 'payment_form_'+method;\n                [form + '_before', form, form + '_after'].each(function(el) {\n                    var block = $(el);\n                    if (block) {\n                        block.show();\n                        block.select('input', 'select', 'textarea').each(function(field) {\n                            field.disabled = false;\n                            if (!el.include('_before') && !el.include('_after') && !field.bindChange) {\n                                field.bindChange = true;\n                                field.paymentContainer = form;\n                                field.method = method;\n                                field.observe('change', this.changePaymentData.bind(this))\n                            }\n                        },this);\n                    }\n                },this);\n            }\n        },\n\n        changePaymentData : function(event){\n            var elem = Event.element(event);\n            if(elem && elem.method){\n                var data = this.getPaymentData(elem.method);\n                if (data) {\n                    this.loadArea(['card_validation'], true, data);\n                } else {\n                    return;\n                }\n            }\n        },\n\n        getPaymentData : function(currentMethod){\n            if (typeof(currentMethod) == 'undefined') {\n                if (this.paymentMethod) {\n                    currentMethod = this.paymentMethod;\n                } else {\n                    return false;\n                }\n            }\n            if (this.isPaymentValidationAvailable() == false) {\n                return false;\n            }\n            var data = {};\n            var fields = $('payment_form_' + currentMethod).select('input', 'select');\n            for(var i=0;i<fields.length;i++){\n                data[fields[i].name] = fields[i].getValue();\n            }\n            if ((typeof data['payment[cc_type]']) != 'undefined' && (!data['payment[cc_type]'] || !data['payment[cc_number]'])) {\n                return false;\n            }\n            return data;\n        },\n\n        applyCoupon : function(code){\n            this.loadArea(['items', 'shipping_method', 'totals', 'billing_method'], true, {'order[coupon][code]':code, reset_shipping: 0});\n            this.orderItemChanged = false;\n            jQuery('html, body').animate({\n                scrollTop: 0\n            });\n        },\n\n        addProduct : function(id){\n            this.loadArea(['items', 'shipping_method', 'totals', 'billing_method'], true, {add_product:id, reset_shipping: true});\n        },\n\n        removeQuoteItem : function(id){\n            this.loadArea(['items', 'shipping_method', 'totals', 'billing_method'], true,\n                {remove_item:id, from:'quote',reset_shipping: true});\n        },\n\n        moveQuoteItem : function(id, to){\n            this.loadArea(['sidebar_'+to, 'items', 'shipping_method', 'totals', 'billing_method'], this.getAreaId('items'),\n                {move_item:id, to:to, reset_shipping: true});\n        },\n\n        productGridShow : function(buttonElement){\n            this.productGridShowButton = buttonElement;\n            Element.hide(buttonElement);\n            this.showArea('search');\n        },\n\n        productGridRowInit : function(grid, row){\n            var checkbox = $(row).select('.checkbox')[0];\n            var inputs = $(row).select('.input-text');\n            if (checkbox && inputs.length > 0) {\n                checkbox.inputElements = inputs;\n                for (var i = 0; i < inputs.length; i++) {\n                    var input = inputs[i];\n                    input.checkboxElement = checkbox;\n\n                    var product = this.gridProducts.get(checkbox.value);\n                    if (product) {\n                        var defaultValue = product[input.name];\n                        if (defaultValue) {\n                            if (input.name == 'giftmessage') {\n                                input.checked = true;\n                            } else {\n                                input.value = defaultValue;\n                            }\n                        }\n                    }\n\n                    input.disabled = !checkbox.checked || input.hasClassName('input-inactive');\n\n                    Event.observe(input,'keyup', this.productGridRowInputChange.bind(this));\n                    Event.observe(input,'change',this.productGridRowInputChange.bind(this));\n                }\n            }\n        },\n\n        productGridRowInputChange : function(event){\n            var element = Event.element(event);\n            if (element && element.checkboxElement && element.checkboxElement.checked){\n                if (element.name!='giftmessage' || element.checked) {\n                    this.gridProducts.get(element.checkboxElement.value)[element.name] = element.value;\n                } else if (element.name=='giftmessage' && this.gridProducts.get(element.checkboxElement.value)[element.name]) {\n                    delete(this.gridProducts.get(element.checkboxElement.value)[element.name]);\n                }\n            }\n        },\n\n        productGridRowClick : function(grid, event){\n            var trElement = Event.findElement(event, 'tr');\n            var qtyElement = trElement.select('input[name=\"qty\"]')[0];\n            var eventElement = Event.element(event);\n            var isInputCheckbox = eventElement.tagName == 'INPUT' && eventElement.type == 'checkbox';\n            var isInputQty = eventElement.tagName == 'INPUT' && eventElement.name == 'qty';\n            if (trElement && !isInputQty) {\n                var checkbox = Element.select(trElement, 'input[type=\"checkbox\"]')[0];\n                var confLink = Element.select(trElement, 'a')[0];\n                var priceColl = Element.select(trElement, '.price')[0];\n                if (checkbox) {\n                    // processing non composite product\n                    if (confLink.readAttribute('disabled')) {\n                        var checked = isInputCheckbox ? checkbox.checked : !checkbox.checked;\n                        grid.setCheckboxChecked(checkbox, checked);\n                        // processing composite product\n                    } else if (isInputCheckbox && !checkbox.checked) {\n                        grid.setCheckboxChecked(checkbox, false);\n                        // processing composite product\n                    } else if (!isInputCheckbox || (isInputCheckbox && checkbox.checked)) {\n                        var listType = confLink.readAttribute('list_type');\n                        var productId = confLink.readAttribute('product_id');\n                        if (typeof this.productPriceBase[productId] == 'undefined') {\n                            var priceBase = priceColl.innerHTML.match(/.*?([\\d,]+\\.?\\d*)/);\n                            if (!priceBase) {\n                                this.productPriceBase[productId] = 0;\n                            } else {\n                                this.productPriceBase[productId] = parseFloat(priceBase[1].replace(/,/g,''));\n                            }\n                        }\n                        productConfigure.setConfirmCallback(listType, function() {\n                            // sync qty of popup and qty of grid\n                            var confirmedCurrentQty = productConfigure.getCurrentConfirmedQtyElement();\n                            if (qtyElement && confirmedCurrentQty && !isNaN(confirmedCurrentQty.value)) {\n                                qtyElement.value = confirmedCurrentQty.value;\n                            }\n                            // calc and set product price\n                            var productPrice = this._calcProductPrice();\n                            if (this._isSummarizePrice()) {\n                                productPrice += this.productPriceBase[productId];\n                            }\n                            productPrice = parseFloat(Math.round(productPrice + \"e+2\") + \"e-2\");\n                            priceColl.innerHTML = this.currencySymbol + productPrice.toFixed(2);\n                            // and set checkbox checked\n                            grid.setCheckboxChecked(checkbox, true);\n                        }.bind(this));\n                        productConfigure.setCancelCallback(listType, function() {\n                            if (!$(productConfigure.confirmedCurrentId) || !$(productConfigure.confirmedCurrentId).innerHTML) {\n                                grid.setCheckboxChecked(checkbox, false);\n                            }\n                        });\n                        productConfigure.setShowWindowCallback(listType, function() {\n                            // sync qty of grid and qty of popup\n                            var formCurrentQty = productConfigure.getCurrentFormQtyElement();\n                            if (formCurrentQty && qtyElement && !isNaN(qtyElement.value)) {\n                                formCurrentQty.value = qtyElement.value;\n                            }\n                        }.bind(this));\n                        productConfigure.showItemConfiguration(listType, productId);\n                    }\n                }\n            }\n        },\n\n        /**\n         * Is need to summarize price\n         */\n        _isSummarizePrice: function(elm) {\n            if (elm && elm.hasAttribute('summarizePrice')) {\n                this.summarizePrice = parseInt(elm.readAttribute('summarizePrice'));\n            }\n            return this.summarizePrice;\n        },\n        /**\n         * Calc product price through its options\n         */\n        _calcProductPrice: function () {\n            var productPrice = 0;\n            var getPriceFields = function (elms) {\n                var productPrice = 0;\n                var getPrice = function (elm) {\n                    var optQty = 1;\n                    if (elm.hasAttribute('qtyId')) {\n                        if (!$(elm.getAttribute('qtyId')).value) {\n                            return 0;\n                        } else {\n                            optQty = parseFloat($(elm.getAttribute('qtyId')).value);\n                        }\n                    }\n                    if (elm.hasAttribute('price') && !elm.disabled) {\n                        return parseFloat(elm.readAttribute('price')) * optQty;\n                    }\n                    return 0;\n                };\n                for(var i = 0; i < elms.length; i++) {\n                    if (elms[i].type == 'select-one' || elms[i].type == 'select-multiple') {\n                        for(var ii = 0; ii < elms[i].options.length; ii++) {\n                            if (elms[i].options[ii].selected) {\n                                if (this._isSummarizePrice(elms[i].options[ii])) {\n                                    productPrice += getPrice(elms[i].options[ii]);\n                                } else {\n                                    productPrice = getPrice(elms[i].options[ii]);\n                                }\n                            }\n                        }\n                    }\n                    else if (((elms[i].type == 'checkbox' || elms[i].type == 'radio') && elms[i].checked)\n                        || ((elms[i].type == 'file' || elms[i].type == 'text' || elms[i].type == 'textarea' || elms[i].type == 'hidden')\n                            && Form.Element.getValue(elms[i]))\n                    ) {\n                        if (this._isSummarizePrice(elms[i])) {\n                            productPrice += getPrice(elms[i]);\n                        } else {\n                            productPrice = getPrice(elms[i]);\n                        }\n                    }\n                }\n                return productPrice;\n            }.bind(this);\n            productPrice += getPriceFields($(productConfigure.confirmedCurrentId).getElementsByTagName('input'));\n            productPrice += getPriceFields($(productConfigure.confirmedCurrentId).getElementsByTagName('select'));\n            productPrice += getPriceFields($(productConfigure.confirmedCurrentId).getElementsByTagName('textarea'));\n            return productPrice;\n        },\n\n        productGridCheckboxCheck : function(grid, element, checked){\n            if (checked) {\n                if(element.inputElements) {\n                    this.gridProducts.set(element.value, {});\n                    var product = this.gridProducts.get(element.value);\n                    for (var i = 0; i < element.inputElements.length; i++) {\n                        var input = element.inputElements[i];\n                        if (!input.hasClassName('input-inactive')) {\n                            input.disabled = false;\n                            if (input.name == 'qty' && !input.value) {\n                                input.value = 1;\n                            }\n                        }\n\n                        if (input.checked || input.name != 'giftmessage') {\n                            product[input.name] = input.value;\n                        } else if (product[input.name]) {\n                            delete(product[input.name]);\n                        }\n                    }\n                }\n            } else {\n                if(element.inputElements){\n                    for(var i = 0; i < element.inputElements.length; i++) {\n                        element.inputElements[i].disabled = true;\n                    }\n                }\n                this.gridProducts.unset(element.value);\n            }\n            grid.reloadParams = {'products[]':this.gridProducts.keys()};\n        },\n\n        /**\n         * Submit configured products to quote\n         */\n        productGridAddSelected : function(){\n            if(this.productGridShowButton) Element.show(this.productGridShowButton);\n            var area = ['search', 'items', 'shipping_method', 'totals', 'giftmessage','billing_method'];\n            // prepare additional fields and filtered items of products\n            var fieldsPrepare = {};\n            var itemsFilter = [];\n            var products = this.gridProducts.toObject();\n            for (var productId in products) {\n                itemsFilter.push(productId);\n                var paramKey = 'item['+productId+']';\n                for (var productParamKey in products[productId]) {\n                    paramKey += '['+productParamKey+']';\n                    fieldsPrepare[paramKey] = products[productId][productParamKey];\n                }\n            }\n            this.productConfigureSubmit('product_to_add', area, fieldsPrepare, itemsFilter);\n            productConfigure.clean('quote_items');\n            this.hideArea('search');\n            this.gridProducts = $H({});\n        },\n\n        selectCustomer : function(grid, event){\n            var element = Event.findElement(event, 'tr');\n            if (element.title){\n                this.setCustomerId(element.title);\n            }\n        },\n\n        customerSelectorHide : function(){\n            this.hideArea('customer-selector');\n        },\n\n        customerSelectorShow : function(){\n            this.showArea('customer-selector');\n        },\n\n        storeSelectorHide : function(){\n            this.hideArea('store-selector');\n        },\n\n        storeSelectorShow : function(){\n            this.showArea('store-selector');\n        },\n\n        dataHide : function(){\n            this.hideArea('data');\n        },\n\n        dataShow : function(){\n            if ($('submit_order_top_button')) {\n                $('submit_order_top_button').show();\n            }\n            this.showArea('data');\n        },\n\n        clearShoppingCart : function(confirmMessage){\n            var self = this;\n\n            confirm({\n                content: confirmMessage,\n                actions: {\n                    confirm: function() {\n                        self.collectElementsValue = false;\n                        order.sidebarApplyChanges({'sidebar[empty_customer_cart]': 1});\n                        self.collectElementsValue = true;\n                    }\n                }\n            });\n        },\n\n        sidebarApplyChanges : function(auxiliaryParams) {\n            if ($(this.getAreaId('sidebar'))) {\n                var data = {};\n                if (this.collectElementsValue) {\n                    var elems = $(this.getAreaId('sidebar')).select('input');\n                    for (var i=0; i < elems.length; i++) {\n                        if (elems[i].getValue()) {\n                            data[elems[i].name] = elems[i].getValue();\n                        }\n                    }\n                }\n                if (auxiliaryParams instanceof Object) {\n                    for (var paramName in auxiliaryParams) {\n                        data[paramName] = String(auxiliaryParams[paramName]);\n                    }\n                }\n                data.reset_shipping = true;\n                this.loadArea(['sidebar', 'items', 'shipping_method', 'billing_method','totals', 'giftmessage'], true, data);\n            }\n        },\n\n        sidebarHide : function(){\n            if(this.storeId === false && $('page:left') && $('page:container')){\n                $('page:left').hide();\n                $('page:container').removeClassName('container');\n                $('page:container').addClassName('container-collapsed');\n            }\n        },\n\n        sidebarShow : function(){\n            if($('page:left') && $('page:container')){\n                $('page:left').show();\n                $('page:container').removeClassName('container-collapsed');\n                $('page:container').addClassName('container');\n            }\n        },\n\n        /**\n         * Show configuration of product and add handlers on submit form\n         *\n         * @param productId\n         */\n        sidebarConfigureProduct: function (listType, productId, itemId) {\n            // create additional fields\n            var params = {};\n            params.reset_shipping = true;\n            params.add_product = productId;\n            this.prepareParams(params);\n            for (var i in params) {\n                if (params[i] === null) {\n                    unset(params[i]);\n                } else if (typeof(params[i]) == 'boolean') {\n                    params[i] = params[i] ? 1 : 0;\n                }\n            }\n            var fields = [];\n            for (var name in params) {\n                fields.push(new Element('input', {type: 'hidden', name: name, value: params[name]}));\n            }\n            // add additional fields before triggered submit\n            productConfigure.setBeforeSubmitCallback(listType, function() {\n                productConfigure.addFields(fields);\n            }.bind(this));\n            // response handler\n            productConfigure.setOnLoadIFrameCallback(listType, function(response) {\n                if (!response.ok) {\n                    return;\n                }\n                this.loadArea(['items', 'shipping_method', 'billing_method','totals', 'giftmessage'], true);\n            }.bind(this));\n            // show item configuration\n            itemId = itemId ? itemId : productId;\n            productConfigure.showItemConfiguration(listType, itemId);\n            return false;\n        },\n\n        removeSidebarItem : function(id, from){\n            this.loadArea(['sidebar_'+from], 'sidebar_data_'+from, {remove_item:id, from:from});\n        },\n\n        itemsUpdate : function(){\n            var area = ['sidebar', 'items', 'shipping_method', 'billing_method','totals', 'giftmessage'];\n            // prepare additional fields\n            var fieldsPrepare = {update_items: 1};\n            var info = $('order-items_grid').select('input', 'select', 'textarea');\n            for(var i=0; i<info.length; i++){\n                if(!info[i].disabled && (info[i].type != 'checkbox' || info[i].checked)) {\n                    fieldsPrepare[info[i].name] = info[i].getValue();\n                }\n            }\n            fieldsPrepare = Object.extend(fieldsPrepare, this.productConfigureAddFields);\n            this.productConfigureSubmit('quote_items', area, fieldsPrepare);\n            this.orderItemChanged = false;\n        },\n\n        itemsOnchangeBind : function(){\n            var elems = $('order-items_grid').select('input', 'select', 'textarea');\n            for(var i=0; i<elems.length; i++){\n                if(!elems[i].bindOnchange){\n                    elems[i].bindOnchange = true;\n                    elems[i].observe('change', this.itemChange.bind(this))\n                }\n            }\n        },\n\n        itemChange : function(event){\n            this.giftmessageOnItemChange(event);\n            this.orderItemChanged = true;\n        },\n\n        /**\n         * Submit batch of configured products\n         *\n         * @param listType\n         * @param area\n         * @param fieldsPrepare\n         * @param itemsFilter\n         */\n        productConfigureSubmit : function(listType, area, fieldsPrepare, itemsFilter) {\n            // prepare loading areas and build url\n            area = this.prepareArea(area);\n            this.loadingAreas = area;\n            var url = this.loadBaseUrl + 'block/' + area + '?isAjax=true';\n\n            // prepare additional fields\n            fieldsPrepare = this.prepareParams(fieldsPrepare);\n            fieldsPrepare.reset_shipping = 1;\n            fieldsPrepare.json = 1;\n\n            // create fields\n            var fields = [];\n            for (var name in fieldsPrepare) {\n                fields.push(new Element('input', {type: 'hidden', name: name, value: fieldsPrepare[name]}));\n            }\n            productConfigure.addFields(fields);\n\n            // filter items\n            if (itemsFilter) {\n                productConfigure.addItemsFilter(listType, itemsFilter);\n            }\n\n            // prepare and do submit\n            productConfigure.addListType(listType, {urlSubmit: url});\n            productConfigure.setOnLoadIFrameCallback(listType, function(response){\n                this.loadAreaResponseHandler(response);\n            }.bind(this));\n            productConfigure.submit(listType);\n            // clean\n            this.productConfigureAddFields = {};\n        },\n\n        /**\n         * Show configuration of quote item\n         *\n         * @param itemId\n         */\n        showQuoteItemConfiguration: function(itemId){\n            var listType = 'quote_items';\n            var qtyElement = $('order-items_grid').select('input[name=\"item\\['+itemId+'\\]\\[qty\\]\"]')[0];\n            productConfigure.setConfirmCallback(listType, function() {\n                // sync qty of popup and qty of grid\n                var confirmedCurrentQty = productConfigure.getCurrentConfirmedQtyElement();\n                if (qtyElement && confirmedCurrentQty && !isNaN(confirmedCurrentQty.value)) {\n                    qtyElement.value = confirmedCurrentQty.value;\n                }\n                this.productConfigureAddFields['item['+itemId+'][configured]'] = 1;\n                this.itemsUpdate();\n\n            }.bind(this));\n            productConfigure.setShowWindowCallback(listType, function() {\n                // sync qty of grid and qty of popup\n                var formCurrentQty = productConfigure.getCurrentFormQtyElement();\n                if (formCurrentQty && qtyElement && !isNaN(qtyElement.value)) {\n                    formCurrentQty.value = qtyElement.value;\n                }\n            }.bind(this));\n            productConfigure.showItemConfiguration(listType, itemId);\n        },\n\n        accountFieldsBind : function(container){\n            if($(container)){\n                var fields = $(container).select('input', 'select', 'textarea');\n                for(var i=0; i<fields.length; i++){\n                    if(fields[i].id == 'group_id'){\n                        fields[i].observe('change', this.accountGroupChange.bind(this))\n                    }\n                    else{\n                        fields[i].observe('change', this.accountFieldChange.bind(this))\n                    }\n                }\n            }\n        },\n\n        accountGroupChange : function(){\n            this.loadArea(['data'], true, this.serializeData('order-form_account').toObject());\n        },\n\n        accountFieldChange : function(){\n            this.saveData(this.serializeData('order-form_account'));\n        },\n\n        commentFieldsBind : function(container){\n            if($(container)){\n                var fields = $(container).select('input', 'textarea');\n                for(var i=0; i<fields.length; i++)\n                    fields[i].observe('change', this.commentFieldChange.bind(this))\n            }\n        },\n\n        commentFieldChange : function(){\n            this.saveData(this.serializeData('order-comment'));\n        },\n\n        giftmessageFieldsBind : function(container){\n            if($(container)){\n                var fields = $(container).select('input', 'textarea');\n                for(var i=0; i<fields.length; i++)\n                    fields[i].observe('change', this.giftmessageFieldChange.bind(this))\n            }\n        },\n\n        giftmessageFieldChange : function(){\n            this.giftMessageDataChanged = true;\n        },\n\n        giftmessageOnItemChange : function(event) {\n            var element = Event.element(event);\n            if(element.name.indexOf(\"giftmessage\") != -1 && element.type == \"checkbox\" && !element.checked) {\n                var messages = $(\"order-giftmessage\").select('textarea');\n                var name;\n                for(var i=0; i<messages.length; i++) {\n                    name = messages[i].id.split(\"_\");\n                    if(name.length < 2) continue;\n                    if (element.name.indexOf(\"[\" + name[1] + \"]\") != -1 && messages[i].value != \"\") {\n                        alert({\n                            content: \"First, clean the Message field in Gift Message form\"\n                        });\n                        element.checked = true;\n                    }\n                }\n            }\n        },\n\n        loadArea : function(area, indicator, params){\n            var deferred = new jQuery.Deferred();\n            var url = this.loadBaseUrl;\n            if (area) {\n                area = this.prepareArea(area);\n                url += 'block/' + area;\n            }\n            if (indicator === true) indicator = 'html-body';\n            params = this.prepareParams(params);\n            params.json = true;\n            if (!this.loadingAreas) this.loadingAreas = [];\n            if (indicator) {\n                this.loadingAreas = area;\n                new Ajax.Request(url, {\n                    parameters:params,\n                    loaderArea: indicator,\n                    onSuccess: function(transport) {\n                        var response = transport.responseText.evalJSON();\n                        this.loadAreaResponseHandler(response);\n                        deferred.resolve();\n                    }.bind(this)\n                });\n            }\n            else {\n                new Ajax.Request(url, {\n                    parameters:params,\n                    loaderArea: indicator,\n                    onSuccess: function(transport) {\n                        deferred.resolve();\n                    }\n                });\n            }\n            if (typeof productConfigure != 'undefined' && area instanceof Array && area.indexOf('items') != -1) {\n                productConfigure.clean('quote_items');\n            }\n            return deferred.promise();\n        },\n\n        loadAreaResponseHandler : function (response) {\n            if (response.error) {\n                alert({\n                    content: response.message\n                });\n            }\n            if (response.ajaxExpired && response.ajaxRedirect) {\n                setLocation(response.ajaxRedirect);\n            }\n            if (!this.loadingAreas) {\n                this.loadingAreas = [];\n            }\n            if (typeof this.loadingAreas == 'string') {\n                this.loadingAreas = [this.loadingAreas];\n            }\n            if (this.loadingAreas.indexOf('message') == -1) {\n                this.loadingAreas.push('message');\n            }\n            if (response.header) {\n                jQuery('.page-actions-inner').attr('data-title', response.header);\n            }\n\n            for (var i = 0; i < this.loadingAreas.length; i++) {\n                var id = this.loadingAreas[i];\n                if ($(this.getAreaId(id))) {\n                    if ('message' != id || response[id]) {\n                        $(this.getAreaId(id)).update(response[id]);\n                    }\n                    if ($(this.getAreaId(id)).callback) {\n                        this[$(this.getAreaId(id)).callback]();\n                    }\n                }\n            }\n        },\n\n        prepareArea : function(area) {\n            if (this.giftMessageDataChanged) {\n                return area.without('giftmessage');\n            }\n            return area;\n        },\n\n        saveData : function(data){\n            this.loadArea(false, false, data);\n        },\n\n        showArea : function(area){\n            var id = this.getAreaId(area);\n            if($(id)) {\n                $(id).show();\n                this.areaOverlay();\n            }\n        },\n\n        hideArea : function(area){\n            var id = this.getAreaId(area);\n            if($(id)) {\n                $(id).hide();\n                this.areaOverlay();\n            }\n        },\n\n        areaOverlay : function()\n        {\n            $H(order.overlayData).each(function(e){\n                e.value.fx();\n            });\n        },\n\n        getAreaId : function(area){\n            return 'order-'+area;\n        },\n\n        prepareParams : function(params){\n            if (!params) {\n                params = {};\n            }\n            if (!params.customer_id) {\n                params.customer_id = this.customerId;\n            }\n            if (!params.store_id) {\n                params.store_id = this.storeId;\n            }\n            if (!params.currency_id) {\n                params.currency_id = this.currencyId;\n            }\n            if (!params.form_key) {\n                params.form_key = FORM_KEY;\n            }\n\n            if (this.isPaymentValidationAvailable()) {\n                var data = this.serializeData('order-billing_method');\n                if (data) {\n                    data.each(function(value) {\n                        params[value[0]] = value[1];\n                    });\n                }\n            } else {\n                params['payment[method]'] = this.paymentMethod;\n            }\n            return params;\n        },\n\n        /**\n         * Prevent from sending credit card information to server for some payment methods\n         *\n         * @returns {boolean}\n         */\n        isPaymentValidationAvailable : function(){\n            return ((typeof this.paymentMethod) == 'undefined'\n                || this.excludedPaymentMethods.indexOf(this.paymentMethod) == -1);\n        },\n\n        /**\n         * Serializes container form elements data.\n         *\n         * @param {String} container\n         * @return {Object}\n         */\n        serializeData: function (container) {\n            var fields = $(container).select('input', 'select', 'textarea'),\n                data = Form.serializeElements(fields, true);\n\n            return $H(data);\n        },\n\n        toggleCustomPrice: function(checkbox, elemId, tierBlock) {\n            if (checkbox.checked) {\n                $(elemId).disabled = false;\n                $(elemId).show();\n                if($(tierBlock)) $(tierBlock).hide();\n            }\n            else {\n                $(elemId).disabled = true;\n                $(elemId).hide();\n                if($(tierBlock)) $(tierBlock).show();\n            }\n        },\n\n        submit : function()\n        {\n            var $editForm = jQuery('#edit_form');\n\n            if ($editForm.valid()) {\n                $editForm.trigger('processStart');\n                $editForm.trigger('submitOrder');\n            }\n        },\n\n        _realSubmit: function () {\n            var disableAndSave = function() {\n                disableElements('save');\n                jQuery('#edit_form').on('invalid-form.validate', function() {\n                    enableElements('save');\n                    jQuery('#edit_form').trigger('processStop');\n                    jQuery('#edit_form').off('invalid-form.validate');\n                });\n                jQuery('#edit_form').triggerHandler('save');\n            }\n            if (this.orderItemChanged) {\n                var self = this;\n\n                jQuery('#edit_form').trigger('processStop');\n\n                confirm({\n                    content: jQuery.mage.__('You have item changes'),\n                    actions: {\n                        confirm: function() {\n                            jQuery('#edit_form').trigger('processStart');\n                            disableAndSave();\n                        },\n                        cancel: function() {\n                            self.itemsUpdate();\n                        }\n                    }\n                });\n            } else {\n                disableAndSave();\n            }\n        },\n\n        overlay : function(elId, show, observe) {\n            if (typeof(show) == 'undefined') { show = true; }\n\n            var orderObj = this;\n            var obj = this.overlayData.get(elId);\n            if (!obj) {\n                obj = {\n                    show: show,\n                    el: elId,\n                    order: orderObj,\n                    fx: function(event) {\n                        this.order.processOverlay(this.el, this.show);\n                    }\n                };\n                obj.bfx = obj.fx.bindAsEventListener(obj);\n                this.overlayData.set(elId, obj);\n            } else {\n                obj.show = show;\n                Event.stopObserving(window, 'resize', obj.bfx);\n            }\n\n            Event.observe(window, 'resize', obj.bfx);\n\n            this.processOverlay(elId, show);\n        },\n\n        processOverlay : function(elId, show) {\n            var el = $(elId);\n\n            if (!el) {\n                return;\n            }\n\n            var parentEl = el.up(1);\n            if (show) {\n                parentEl.removeClassName('ignore-validate');\n            } else {\n                parentEl.addClassName('ignore-validate');\n            }\n\n            if (Prototype.Browser.IE) {\n                parentEl.select('select').each(function (elem) {\n                    if (show) {\n                        elem.needShowOnSuccess = false;\n                        elem.style.visibility = '';\n                    } else {\n                        elem.style.visibility = 'hidden';\n                        elem.needShowOnSuccess = true;\n                    }\n                });\n            }\n\n            parentEl.setStyle({position: 'relative'});\n            el.setStyle({\n                display: show ? 'none' : ''\n            });\n        },\n\n        validateVat: function(parameters)\n        {\n            var params = {\n                country: $(parameters.countryElementId).value,\n                vat: $(parameters.vatElementId).value\n            };\n\n            if (this.storeId !== false) {\n                params.store_id = this.storeId;\n            }\n\n            var currentCustomerGroupId = $(parameters.groupIdHtmlId)\n                ? $(parameters.groupIdHtmlId).value : '';\n\n            new Ajax.Request(parameters.validateUrl, {\n                parameters: params,\n                onSuccess: function(response) {\n                    var message = '';\n                    var groupActionRequired = null;\n                    try {\n                        response = response.responseText.evalJSON();\n\n                        if (null === response.group) {\n                            if (true === response.valid) {\n                                message = parameters.vatValidMessage;\n                            } else if (true === response.success) {\n                                message = parameters.vatInvalidMessage.replace(/%s/, params.vat);\n                            } else {\n                                message = parameters.vatValidationFailedMessage;\n                            }\n                        } else {\n                            if (true === response.valid) {\n                                message = parameters.vatValidAndGroupValidMessage;\n                                if (0 === response.group) {\n                                    message = parameters.vatValidAndGroupInvalidMessage;\n                                    groupActionRequired = 'inform';\n                                } else if (currentCustomerGroupId != response.group) {\n                                    message = parameters.vatValidAndGroupChangeMessage;\n                                    groupActionRequired = 'change';\n                                }\n                            } else if (response.success) {\n                                message = parameters.vatInvalidMessage.replace(/%s/, params.vat);\n                                groupActionRequired = 'inform';\n                            } else {\n                                message = parameters.vatValidationFailedMessage;\n                                groupActionRequired = 'inform';\n                            }\n                        }\n                    } catch (e) {\n                        message = parameters.vatValidationFailedMessage;\n                    }\n                    if (null === groupActionRequired) {\n                        alert({\n                            content: message\n                        });\n                    }\n                    else {\n                        this.processCustomerGroupChange(\n                            parameters.groupIdHtmlId,\n                            message,\n                            parameters.vatCustomerGroupMessage,\n                            parameters.vatGroupErrorMessage,\n                            response.group,\n                            groupActionRequired\n                        );\n                    }\n                }.bind(this)\n            });\n        },\n\n        processCustomerGroupChange: function(groupIdHtmlId, message, customerGroupMessage, errorMessage, groupId, action)\n        {\n            var groupMessage = '';\n            try {\n                var currentCustomerGroupId = $(groupIdHtmlId).value;\n                var currentCustomerGroupTitle =\n                    $$('#' + groupIdHtmlId + ' > option[value=' + currentCustomerGroupId + ']')[0].text;\n                var customerGroupOption = $$('#' + groupIdHtmlId + ' > option[value=' + groupId + ']')[0];\n                groupMessage = customerGroupMessage.replace(/%s/, customerGroupOption.text);\n            } catch (e) {\n                groupMessage = errorMessage;\n                if (action === 'change') {\n                    message = '';\n                    action = 'inform';\n                }\n            }\n\n            if (action === 'change') {\n                var confirmText = message.replace(/%s/, customerGroupOption.text);\n                confirmText = confirmText.replace(/%s/, currentCustomerGroupTitle);\n                if (confirm(confirmText)) {\n                    $$('#' + groupIdHtmlId + ' option').each(function (o) {\n                        o.selected = o.readAttribute('value') == groupId;\n                    });\n                    this.accountGroupChange();\n                }\n            } else if (action === 'inform') {\n                alert({\n                    content: message + '\\n' + groupMessage\n                });\n            }\n        }\n    };\n\n    window.OrderFormArea = Class.create();\n    OrderFormArea.prototype = {\n        _name: null,\n        _node: null,\n        _parent: null,\n        _callbackName: null,\n\n        initialize: function(name, node, parent){\n            if(!node)\n                return;\n            this._name = name;\n            this._parent = parent;\n            this._callbackName = node.callback;\n            if (typeof this._callbackName == 'undefined') {\n                this._callbackName = name + 'Loaded';\n                node.callback = this._callbackName;\n            }\n            parent[this._callbackName] = parent[this._callbackName].wrap((function (proceed){\n                proceed();\n                this.onLoad();\n            }).bind(this));\n\n            this.setNode(node);\n        },\n\n        setNode: function(node){\n            if (!node.callback) {\n                node.callback = this._callbackName;\n            }\n            this.node = node;\n        },\n\n        onLoad: function(){\n        }\n    };\n\n    window.ControlButton = Class.create();\n\n    ControlButton.prototype = {\n        _label: '',\n        _node: null,\n\n        initialize: function(label, id){\n            this._label = label;\n            this._node = new Element('button', {\n                'class': 'action-secondary action-add',\n                'type':  'button'\n            });\n            if (typeof id !== 'undefined') {\n                this._node.setAttribute('id', id)\n            }\n        },\n\n        onClick: function(){\n        },\n\n        insertIn: function(element, position){\n            var node = Object.extend(this._node),\n                content = {};\n            node.observe('click', this.onClick);\n            node.update('<span>' + this._label + '</span>');\n            content[position] = node;\n            Element.insert(element, content);\n        },\n\n        getLabel: function(){\n            return this._label;\n        }\n    };\n});\n","Magento_Sales/order/view/post-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'mage/translate'\n], function ($, confirm) {\n    'use strict';\n\n    /**\n     * @param {String} url\n     * @returns {Object}\n     */\n    function getForm(url) {\n        return $('<form>', {\n            'action': url,\n            'method': 'POST'\n        }).append($('<input>', {\n            'name': 'form_key',\n            'value': window.FORM_KEY,\n            'type': 'hidden'\n        }));\n    }\n\n    $('#order-view-cancel-button').click(function () {\n        var msg = $.mage.__('Are you sure you want to cancel this order?'),\n            url = $('#order-view-cancel-button').data('url');\n\n        confirm({\n            'content': msg,\n            'actions': {\n\n                /**\n                 * 'Confirm' action handler.\n                 */\n                confirm: function () {\n                    getForm(url).appendTo('body').submit();\n                }\n            }\n        });\n\n        return false;\n    });\n\n    $('#order-view-hold-button').click(function () {\n        var url = $('#order-view-hold-button').data('url');\n\n        getForm(url).appendTo('body').submit();\n    });\n\n    $('#order-view-unhold-button').click(function () {\n        var url = $('#order-view-unhold-button').data('url');\n\n        getForm(url).appendTo('body').submit();\n    });\n});\n","Magento_InventoryAdminUi/js/form/element/region.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/region'\n], function (Region) {\n    'use strict';\n\n    return Region.extend({\n        defaults: {\n            regionScope: 'data.general.region'\n        },\n\n        /**\n         * Set region to source form\n         *\n         * @param {String} value - region\n         */\n        setDifferedFromDefault: function (value) {\n            this._super();\n\n            if (parseFloat(value)) {\n                this.source.set(this.regionScope, this.indexedOptions[value].label);\n            }\n        }\n    });\n});\n","Magento_InventoryAdminUi/js/stock/grid/cell/assigned-sources.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryAdminUi/stock/grid/cell/assigned-sources-cell.html',\n            itemsToDisplay: 5\n        },\n\n        /**\n         *\n         * @param {Array} record\n         * @returns {Array}\n         */\n        getTooltipData: function (record) {\n            return record[this.index].map(function (source) {\n                return {\n                    sourceCode: source.sourceCode,\n                    name: source.name\n                };\n            });\n        },\n\n        /**\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSourcesAssignedToStockOrderedByPriority: function (record) {\n            return this.getTooltipData(record).slice(0, this.itemsToDisplay);\n        }\n    });\n});\n","Magento_AsynchronousOperations/js/insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form',\n    'uiRegistry'\n], function (Insert, registry) {\n    'use strict';\n\n    return Insert.extend({\n        defaults: {\n            modalProvider: '${ $.parentName }',\n            titlePrefix: '',\n            imports: {\n                changeModalTitle: '${ $.modalProvider }:state'\n            },\n            listens: {\n                responseData: 'afterRetry'\n            },\n            modules: {\n                modal: '${ $.modalProvider }',\n                notificationListing: '${ $.columnsProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            var modalTitleProvider;\n\n            this._super();\n            modalTitleProvider = this.modalTitleProvider.split(':');\n            this.modalTitleTarget = modalTitleProvider[0];\n            this.modalTitlePath = modalTitleProvider[1];\n        },\n\n        /**\n         * Change modal title.\n         *\n         * @param {Boolean} change\n         */\n        changeModalTitle: function (change) {\n            if (change) {\n                registry.get(this.modalTitleTarget, function (target) {\n                    this.modal().setTitle(this.titlePrefix + target.get(this.modalTitlePath));\n                }.bind(this));\n            } else {\n                this.modal().setTitle('');\n            }\n        },\n\n        /**\n         * Action after retry operation.\n         *\n         * @param {Object} data\n         */\n        afterRetry: function (data) {\n            if (!data.error) {\n                this.modal().closeModal();\n                this.notificationListing().reload();\n            }\n        }\n    });\n});\n","Magento_AsynchronousOperations/js/form/error.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        /** @inheritdoc */\n        onUpdate: function () {\n            this.bubble('update', this.hasChanged());\n        }\n    });\n});\n","Magento_AsynchronousOperations/js/grid/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_AdminNotification/js/grid/listing',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate',\n    'underscore',\n    'jquery'\n], function (Listing, uiAlert, $t, _, $) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            isAllowed: true,\n            ajaxSettings: {\n                method: 'POST',\n                data: {},\n                url: '${ $.dismissUrl }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            _.bindAll(this, 'reload', 'onError');\n\n            return this._super();\n        },\n\n        /**\n         * Dismiss all items.\n         */\n        dismissAll: function () {\n            var toDismiss = [];\n\n            _.each(this.rows, function (row) {\n                if (row.dismiss) {\n                    toDismiss.push(row.uuid);\n                }\n            });\n            toDismiss.length && this.dismiss(toDismiss);\n        },\n\n        /**\n         * Dismiss action.\n         *\n         * @param {Array} items\n         */\n        dismiss: function (items) {\n            var config = _.extend({}, this.ajaxSettings);\n\n            config.data.uuid = items;\n            this.showLoader();\n\n            $.ajax(config)\n                .done(this.reload)\n                .fail(this.onError);\n        },\n\n        /**\n         * Success callback for dismiss request.\n         */\n        reload: function () {\n            this.source.reload({\n                refresh: true\n            });\n        },\n\n        /**\n         * Error callback for dismiss request.\n         *\n         * @param {Object} xhr\n         */\n        onError: function (xhr) {\n            this.hideLoader();\n\n            if (xhr.statusText === 'abort') {\n                return;\n            }\n\n            uiAlert({\n                content: $t('Something went wrong.')\n            });\n        }\n    });\n});\n","Magento_AdminNotification/toolbar_entry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery/ui',\n    'domReady!'\n], function ($) {\n    'use strict';\n\n    /**\n     * Mark notification as read via AJAX call.\n     *\n     * @param {String} notificationId\n     */\n    var markNotificationAsRead = function (notificationId) {\n            var requestUrl = $('.notifications-wrapper .admin__action-dropdown-menu').attr('data-mark-as-read-url');\n\n            $.ajax({\n                url: requestUrl,\n                type: 'POST',\n                dataType: 'json',\n                data: {\n                    id: notificationId\n                },\n                showLoader: false\n            });\n        },\n        notificationCount = $('.notifications-wrapper').attr('data-notification-count'),\n\n        /**\n         * Remove notification from the list.\n         *\n         * @param {jQuery} notificationEntry\n         */\n        removeNotificationFromList = function (notificationEntry) {\n            var notificationIcon, actionElement;\n\n            notificationEntry.remove();\n            notificationCount--;\n            $('.notifications-wrapper').attr('data-notification-count', notificationCount);\n\n            if (notificationCount == 0) {// eslint-disable-line eqeqeq\n                // Change appearance of the bubble and its behavior when the last notification is removed\n                $('.notifications-wrapper .admin__action-dropdown-menu').remove();\n                notificationIcon = $('.notifications-wrapper .notifications-icon');\n                notificationIcon.removeAttr('data-toggle');\n                notificationIcon.off('click.dropdown');\n                $('.notifications-action .notifications-counter').text('').hide();\n            } else {\n                // Change top counter only for allowable range\n                if (notificationCount <= 99) {\n                    $('.notifications-action .notifications-counter').text(notificationCount);\n                }\n                $('.notifications-entry-last .notifications-counter').text(notificationCount);\n                // Modify caption of the 'See All' link\n                actionElement = $('.notifications-wrapper .admin__action-dropdown-menu .last .action-more');\n                actionElement.text(actionElement.text().replace(/\\d+/, notificationCount));\n            }\n        },\n\n        /**\n         * Show notification details.\n         *\n         * @param {jQuery} notificationEntry\n         */\n        showNotificationDetails = function (notificationEntry) {\n            var notificationDescription = notificationEntry.find('.notifications-entry-description'),\n                notificationDescriptionEnd = notificationEntry.find('.notifications-entry-description-end');\n\n            if (notificationDescriptionEnd.length > 0) {\n                notificationDescriptionEnd.addClass('_show');\n            }\n\n            if (notificationDescription.hasClass('_cutted')) {\n                notificationDescription.removeClass('_cutted');\n            }\n        };\n\n    // Show notification description when corresponding item is clicked\n    $('.notifications-wrapper .admin__action-dropdown-menu .notifications-entry').on(\n        'click.showNotification',\n        function (event) {\n            // hide notification dropdown\n            $('.notifications-wrapper .notifications-icon').trigger('click.dropdown');\n\n            showNotificationDetails($(this));\n            event.stopPropagation();\n        }\n    );\n\n    // Remove corresponding notification from the list and mark it as read\n    $('.notifications-close').on('click.removeNotification', function (event) {\n        var notificationEntry = $(this).closest('.notifications-entry'),\n            notificationId = notificationEntry.attr('data-notification-id');\n\n        markNotificationAsRead(notificationId);\n        removeNotificationFromList(notificationEntry);\n\n        // Checking for last unread notification to hide dropdown\n        if (notificationCount == 0) {// eslint-disable-line eqeqeq\n            $('.notifications-wrapper').removeClass('active')\n                .find('.notifications-action')\n                .removeAttr('data-toggle')\n                .off('click.dropdown');\n        }\n        event.stopPropagation();\n    });\n\n    // Hide notifications bubble\n    if (notificationCount == 0) {// eslint-disable-line eqeqeq\n        $('.notifications-action .notifications-counter').hide();\n    } else {\n        $('.notifications-action .notifications-counter').show();\n    }\n});\n","Magento_AdminNotification/js/system/messages/popup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal'\n], function ($, modal) {\n    'use strict';\n\n    return function (data, element) {\n\n        if (modal.modal) {\n            modal.modal.html($(element).html());\n        } else {\n            modal.modal = $(element).modal({\n                modalClass: data.class,\n                type: 'popup',\n                buttons: []\n            });\n        }\n\n        modal.modal.modal('openModal');\n    };\n});\n","Magento_AdminNotification/js/grid/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/grid/listing',\n    'Magento_Ui/js/lib/spinner',\n    'jquery'\n], function (Listing, loader, $) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            imports: {\n                totalRecords: '${ $.provider }:data.totalRecords'\n            },\n            selectors: {\n                collapsible: '.message-system-collapsible',\n                messages: '.message-system'\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .track({\n                    totalRecords: 0\n                });\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        showLoader: function () {\n            if (!this.source.firstLoad) {\n                this.fixLoaderHeight();\n                this._super();\n            }\n        },\n\n        /**\n         * Calculates loader height\n         *\n         * @param {Boolean} [closed]\n         */\n        fixLoaderHeight: function (closed) {\n            var $messagesBlock = $(this.selectors.messages),\n                $collapsibleBlock = $(this.selectors.collapsible),\n                resultHeight = 0;\n\n            if ($messagesBlock.length) {\n                resultHeight += $messagesBlock.outerHeight();\n            }\n\n            if ($collapsibleBlock.length && $collapsibleBlock.is(':visible') && !closed) {\n                resultHeight += $collapsibleBlock.outerHeight();\n            }\n\n            loader.get(this.name).height(resultHeight);\n        }\n    });\n});\n","Magento_AdminNotification/js/grid/columns/message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'underscore'\n], function (Column, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_AdminNotification/grid/cells/message',\n            messageIndex: 'text',\n            fieldClass: {\n                message: true,\n                'message-warning': false,\n                'message-progress': false,\n                'message-success': false,\n                'message-error': false\n            },\n            statusMap: {\n                0: 'info',\n                1: 'progress',\n                2: 'success',\n                3: 'error'\n            }\n        },\n\n        /** @inheritdoc */\n        getLabel: function (record) {\n            return record[this.messageIndex];\n        },\n\n        /** @inheritdoc */\n        getFieldClass: function ($row) {\n            var status = this.statusMap[$row.status] || 'warning',\n                result = {};\n\n            result['message-' + status] = true;\n            result = _.extend({}, this.fieldClass, result);\n\n            return result;\n        }\n    });\n});\n","Magento_AdminNotification/system/notification.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.systemMessageDialog', $.mage.modal, {\n        options: {\n            modalClass: 'modal-system-messages',\n            systemMessageTemplate:\n                '<% _.each(data.items, function(item) { %>' +\n                    '<li class=\"message message-warning' +\n                        '<% if (item.severity == 1) { %>error<% } else { %>warning<% } %>\">' +\n                        '<%= item.text %>' +\n                    '</li>' +\n                '<% }); %>'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.options.title = $('#message-system-all').attr('title');\n            this._super();\n        },\n\n        /** @inheritdoc */\n        openModal: function (severity) {\n            var superMethod = $.proxy(this._super, this);\n\n            $.ajax({\n                url: this.options.ajaxUrl,\n                type: 'GET',\n                data: {\n                    severity: severity\n                }\n            }).done($.proxy(function (data) {\n                var tmpl = mageTemplate(this.options.systemMessageTemplate, {\n                    data: {\n                        items: data\n                    }\n                });\n\n                tmpl = $(tmpl);\n\n                this.element.html(\n                    $('<ul />', {\n                        'class': 'message-system-list'\n                    }).append(tmpl)\n                ).trigger('contentUpdated');\n\n                superMethod();\n            }, this));\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        closeModal: function () {\n            this._super();\n        }\n    });\n\n    $(document).ready(function () {\n        $('#system_messages .message-system-short .error').on('click', function () {\n            $('#message-system-all').systemMessageDialog('openModal', 1);\n        });\n\n        $('#system_messages .message-system-short .warning').on('click', function () {\n            $('#message-system-all').systemMessageDialog('openModal', 2);\n        });\n    });\n\n    return $.mage.systemMessageDialog;\n});\n","Magento_Rule/rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate',\n    'prototype'\n], function (jQuery) {\n    'use strict';\n\n    var VarienRulesForm = new Class.create();\n\n    VarienRulesForm.prototype = {\n        initialize: function (parent, newChildUrl) {\n            this.parent = $(parent);\n            this.newChildUrl  = newChildUrl;\n            this.shownElement = null;\n            this.updateElement = null;\n            this.chooserSelectedItems = $H({});\n            this.readOnly = false;\n\n            var elems = this.parent.getElementsByClassName('rule-param');\n\n            for (var i = 0; i < elems.length; i++) {\n                this.initParam(elems[i]);\n            }\n        },\n\n        setReadonly: function (readonly) {\n            this.readOnly = readonly;\n            var elems = this.parent.getElementsByClassName('rule-param-remove');\n\n            for (var i = 0; i < elems.length; i++) {\n                var element = elems[i];\n\n                if (this.readOnly) {\n                    element.hide();\n                } else {\n                    element.show();\n                }\n            }\n\n            var elems = this.parent.getElementsByClassName('rule-param-new-child');\n\n            for (var i = 0; i < elems.length; i++) {\n                var element = elems[i];\n\n                if (this.readOnly) {\n                    element.hide();\n                } else {\n                    element.show();\n                }\n            }\n\n            var elems = this.parent.getElementsByClassName('rule-param');\n\n            for (var i = 0; i < elems.length; i++) {\n                var container = elems[i];\n                var label = Element.down(container, '.label');\n\n                if (label) {\n                    if (this.readOnly) {\n                        label.addClassName('label-disabled');\n                    } else {\n                        label.removeClassName('label-disabled');\n                    }\n                }\n            }\n        },\n\n        initParam: function (container) {\n            container.rulesObject = this;\n            var label = Element.down(container, '.label');\n\n            if (label) {\n                Event.observe(label, 'click', this.showParamInputField.bind(this, container));\n            }\n\n            var elem = Element.down(container, '.element');\n\n            if (elem) {\n                var trig = elem.down('.rule-chooser-trigger');\n\n                if (trig) {\n                    Event.observe(trig, 'click', this.toggleChooser.bind(this, container));\n                }\n\n                var apply = elem.down('.rule-param-apply');\n\n                if (apply) {\n                    Event.observe(apply, 'click', this.hideParamInputField.bind(this, container));\n                } else {\n                    elem = elem.down('.element-value-changer');\n                    elem.container = container;\n\n                    if (!elem.multiple) {\n                        Event.observe(elem, 'change', this.hideParamInputField.bind(this, container));\n\n                        this.changeVisibilityForValueRuleParam(elem);\n\n                    }\n                    Event.observe(elem, 'blur', this.hideParamInputField.bind(this, container));\n                }\n            }\n\n            var remove = Element.down(container, '.rule-param-remove');\n\n            if (remove) {\n                Event.observe(remove, 'click', this.removeRuleEntry.bind(this, container));\n            }\n        },\n\n        showChooserElement: function (chooser) {\n            this.chooserSelectedItems = $H({});\n\n            if (chooser.hasClassName('no-split')) {\n                this.chooserSelectedItems.set(this.updateElement.value, 1);\n            } else {\n                var values = this.updateElement.value.split(','),\n s = '';\n\n                for (var i = 0; i < values.length; i++) {\n                    s = values[i].strip();\n\n                    if (s != '') {\n                        this.chooserSelectedItems.set(s, 1);\n                    }\n                }\n            }\n            new Ajax.Request(chooser.getAttribute('url'), {\n                evalScripts: true,\n                parameters: {\n                    'form_key': FORM_KEY, 'selected[]': this.chooserSelectedItems.keys()\n                },\n                onSuccess: function (transport) {\n                    if (this._processSuccess(transport)) {\n                        jQuery(chooser).html(transport.responseText);\n                        this.showChooserLoaded(chooser, transport);\n                        jQuery(chooser).trigger('contentUpdated');\n                    }\n                }.bind(this),\n                onFailure: this._processFailure.bind(this)\n            });\n        },\n\n        showChooserLoaded: function (chooser, transport) {\n            chooser.style.display = 'block';\n        },\n\n        showChooser: function (container, event) {\n            var chooser = container.up('li');\n\n            if (!chooser) {\n                return;\n            }\n            chooser = chooser.down('.rule-chooser');\n\n            if (!chooser) {\n                return;\n            }\n            this.showChooserElement(chooser);\n        },\n\n        hideChooser: function (container, event) {\n            var chooser = container.up('li');\n\n            if (!chooser) {\n                return;\n            }\n            chooser = chooser.down('.rule-chooser');\n\n            if (!chooser) {\n                return;\n            }\n            chooser.style.display = 'none';\n        },\n\n        toggleChooser: function (container, event) {\n            if (this.readOnly) {\n                return false;\n            }\n\n            var chooser = container.up('li').down('.rule-chooser');\n\n            if (!chooser) {\n                return;\n            }\n\n            if (chooser.style.display == 'block') {\n                chooser.style.display = 'none';\n                this.cleanChooser(container, event);\n            } else {\n                this.showChooserElement(chooser);\n            }\n        },\n\n        cleanChooser: function (container, event) {\n            var chooser = container.up('li').down('.rule-chooser');\n\n            if (!chooser) {\n                return;\n            }\n            chooser.innerHTML = '';\n        },\n\n        showParamInputField: function (container, event) {\n            if (this.readOnly) {\n                return false;\n            }\n\n            if (this.shownElement) {\n                this.hideParamInputField(this.shownElement, event);\n            }\n\n            Element.addClassName(container, 'rule-param-edit');\n            var elemContainer = Element.down(container, '.element');\n\n            var elem = Element.down(elemContainer, 'input.input-text');\n\n            jQuery(elem).trigger('contentUpdated');\n\n            if (elem) {\n                elem.focus();\n\n                if (elem && elem.id && elem.id.match(/__value$/)) {\n                    this.updateElement = elem;\n                }\n\n            }\n\n            var elem = Element.down(elemContainer, '.element-value-changer');\n\n            if (elem) {\n                elem.focus();\n            }\n\n            this.shownElement = container;\n        },\n\n        hideParamInputField: function (container, event) {\n            Element.removeClassName(container, 'rule-param-edit');\n            var label = Element.down(container, '.label'),\n elem;\n\n            if (!container.hasClassName('rule-param-new-child')) {\n                elem = Element.down(container, '.element-value-changer');\n\n                if (elem && elem.options) {\n                    var selectedOptions = [];\n\n                    for (var i = 0; i < elem.options.length; i++) {\n                        if (elem.options[i].selected) {\n                            selectedOptions.push(elem.options[i].text);\n                        }\n                    }\n\n                    var str = selectedOptions.join(', ');\n\n                    label.innerHTML = str != '' ? str : '...';\n                }\n\n                this.changeVisibilityForValueRuleParam(elem);\n\n                elem = Element.down(container, 'input.input-text');\n\n                if (elem) {\n                    var str = elem.value.replace(/(^\\s+|\\s+$)/g, '');\n\n                    elem.value = str;\n\n                    if (str == '') {\n                        str = '...';\n                    } else if (str.length > 30) {\n                        str = str.substr(0, 30) + '...';\n                    }\n                    label.innerHTML = str.escapeHTML();\n                }\n            } else {\n                elem = container.down('.element-value-changer');\n\n                if (elem.value) {\n                    this.addRuleNewChild(elem);\n                }\n                elem.value = '';\n            }\n\n            if (elem && elem.id && elem.id.match(/__value$/)) {\n                this.hideChooser(container, event);\n                this.updateElement = null;\n            }\n\n            this.shownElement = null;\n        },\n\n        changeVisibilityForValueRuleParam: function(elem) {\n            var parsedElementId = elem.id.split('__');\n            if (parsedElementId[2] !== 'operator') {\n                return false;\n            }\n\n            var valueElement = jQuery('#' + parsedElementId[0] + '__' + parsedElementId[1] + '__value');\n\n            if(elem.value === '<=>') {\n                valueElement.closest('.rule-param').hide();\n            } else {\n                valueElement.closest('.rule-param').show();\n            }\n\n            return true;\n        },\n\n        addRuleNewChild: function (elem) {\n            var parent_id = elem.id.replace(/^.*__(.*)__.*$/, '$1');\n            var children_ul_id = elem.id.replace(/__/g, ':').replace(/[^:]*$/, 'children').replace(/:/g, '__');\n            var children_ul = $(this.parent).select('#' + children_ul_id)[0];\n            var max_id = 0,\n i;\n            var children_inputs = Selector.findChildElements(children_ul, $A(['input.hidden']));\n\n            if (children_inputs.length) {\n                children_inputs.each(function (el) {\n                    if (el.id.match(/__type$/)) {\n                        i = 1 * el.id.replace(/^.*__.*?([0-9]+)__.*$/, '$1');\n                        max_id = i > max_id ? i : max_id;\n                    }\n                });\n            }\n            var new_id = parent_id + '--' + (max_id + 1);\n            var new_type = elem.value;\n            var new_elem = document.createElement('LI');\n\n            new_elem.className = 'rule-param-wait';\n            new_elem.innerHTML = jQuery.mage.__('This won\\'t take long . . .');\n            children_ul.insertBefore(new_elem, $(elem).up('li'));\n\n            new Ajax.Request(this.newChildUrl, {\n                evalScripts: true,\n                parameters: {\n                    form_key: FORM_KEY, type: new_type.replace('/', '-'), id: new_id\n                },\n                onComplete: this.onAddNewChildComplete.bind(this, new_elem),\n                onSuccess: function (transport) {\n                    if (this._processSuccess(transport)) {\n                        $(new_elem).update(transport.responseText);\n                    }\n                }.bind(this),\n                onFailure: this._processFailure.bind(this)\n            });\n        },\n\n        _processSuccess: function (transport) {\n            if (transport.responseText.isJSON()) {\n                var response = transport.responseText.evalJSON();\n\n                if (response.error) {\n                    alert(response.message);\n                }\n\n                if (response.ajaxExpired && response.ajaxRedirect) {\n                    setLocation(response.ajaxRedirect);\n                }\n\n                return false;\n            }\n\n            return true;\n        },\n\n        _processFailure: function (transport) {\n            location.href = BASE_URL;\n        },\n\n        onAddNewChildComplete: function (new_elem) {\n            if (this.readOnly) {\n                return false;\n            }\n\n            $(new_elem).removeClassName('rule-param-wait');\n            var elems = new_elem.getElementsByClassName('rule-param');\n\n            for (var i = 0; i < elems.length; i++) {\n                this.initParam(elems[i]);\n            }\n        },\n\n        removeRuleEntry: function (container, event) {\n            var li = Element.up(container, 'li');\n\n            li.parentNode.removeChild(li);\n        },\n\n        chooserGridInit: function (grid) {\n            //grid.reloadParams = {'selected[]':this.chooserSelectedItems.keys()};\n        },\n\n        chooserGridRowInit: function (grid, row) {\n            if (!grid.reloadParams) {\n                grid.reloadParams = {\n                    'selected[]': this.chooserSelectedItems.keys()\n                };\n            }\n        },\n\n        chooserGridRowClick: function (grid, event) {\n            var trElement = Event.findElement(event, 'tr');\n            var isInput = Event.element(event).tagName == 'INPUT';\n\n            if (trElement) {\n                var checkbox = Element.select(trElement, 'input');\n\n                if (checkbox[0]) {\n                    var checked = isInput ? checkbox[0].checked : !checkbox[0].checked;\n\n                    grid.setCheckboxChecked(checkbox[0], checked);\n\n                }\n            }\n        },\n\n        chooserGridCheckboxCheck: function (grid, element, checked) {\n            if (checked) {\n                if (!element.up('th')) {\n                    this.chooserSelectedItems.set(element.value, 1);\n                }\n            } else {\n                this.chooserSelectedItems.unset(element.value);\n            }\n            grid.reloadParams = {\n                'selected[]': this.chooserSelectedItems.keys()\n            };\n            this.updateElement.value = this.chooserSelectedItems.keys().join(', ');\n        }\n    };\n\n    return VarienRulesForm;\n});\n","Magento_Rule/conditions-data-normalizer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    /**\n     * @constructor\n     */\n    var ConditionsDataNormalizer = function () {\n        this.patterns = {\n            validate: /^[a-z0-9_.-][a-z0-9_.-]*(?:\\[(?:\\d*|[a-z0-9_.-]+)\\])*$/i,\n            key: /[a-z0-9_.-]+|(?=\\[\\])/gi,\n            push: /^$/,\n            fixed: /^\\d+$/,\n            named: /^[a-z0-9_.-]+$/i\n        };\n    };\n\n    ConditionsDataNormalizer.prototype = {\n        /**\n         * Will convert an object:\n         * {\n         *   \"foo[bar][1][baz]\": 123,\n         *   \"foo[bar][1][blah]\": 321\n         *   \"foo[bar][1--1][ah]\": 456\n         * }\n         *\n         * to\n         * {\n         *   \"foo\": {\n         *     \"bar\": {\n         *       \"1\": {\n         *         \"baz\": 123,\n         *         \"blah\": 321\n         *       },\n         *       \"1--1\": {\n         *         \"ah\": 456\n         *       }\n         *     }\n         *   }\n         * }\n         */\n        normalize: function normalize(value) {\n            var el, _this = this;\n\n            this.pushes = {};\n            this.data = {};\n\n            _.each(value, function (e, i) {\n                el = {};\n                el[i] = e;\n\n                _this._addPair({\n                    name: i,\n                    value: e\n                });\n            });\n\n            return this.data;\n        },\n\n        /**\n         * @param {Object} base\n         * @param {String} key\n         * @param {String} value\n         * @return {Object}\n         * @private\n         */\n        _build: function build(base, key, value) {\n            base[key] = value;\n\n            return base;\n        },\n\n        /**\n         * @param {Object} root\n         * @param {String} value\n         * @return {*}\n         * @private\n         */\n        _makeObject: function makeObject(root, value) {\n            var keys = root.match(this.patterns.key),\n                k, idx; // nest, nest, ..., nest\n\n            while ((k = keys.pop()) !== undefined) {\n                // foo[]\n                if (this.patterns.push.test(k)) {\n                    idx = this._incrementPush(root.replace(/\\[\\]$/, ''));\n                    value = this._build([], idx, value);\n                } // foo[n]\n                else if (this.patterns.fixed.test(k)) {\n                    value = this._build({}, k, value);\n                } // foo; foo[bar]\n                else if (this.patterns.named.test(k)) {\n                    value = this._build({}, k, value);\n                }\n            }\n\n            return value;\n        },\n\n        /**\n         * @param {String} key\n         * @return {Number}\n         * @private\n         */\n        _incrementPush: function incrementPush(key) {\n            if (this.pushes[key] === undefined) {\n                this.pushes[key] = 0;\n            }\n\n            return this.pushes[key]++;\n        },\n\n        /**\n         * @param {Object} pair\n         * @return {Object}\n         * @private\n         */\n        _addPair: function addPair(pair) {\n            var obj = this._makeObject(pair.name, pair.value);\n\n            if (!this.patterns.validate.test(pair.name)) {\n                return this;\n            }\n\n            this.data = $.extend(true, this.data, obj);\n\n            return this;\n        }\n    };\n\n    return ConditionsDataNormalizer;\n});\n","Magento_Checkout/js/model/default-post-code-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Define necessity of using default post code value\n     */\n    var useDefaultPostCode;\n\n    return {\n        /**\n         * Resolve default post code\n         *\n         * @returns {String|null}\n         */\n        resolve: function () {\n            return useDefaultPostCode ?  window.checkoutConfig.defaultPostcode : null;\n        },\n\n        /**\n         * Set state to useDefaultPostCode variable\n         *\n         * @param {Boolean} shouldUseDefaultPostCode\n         * @returns {underscore}\n         */\n        setUseDefaultPostCode: function (shouldUseDefaultPostCode) {\n            useDefaultPostCode = shouldUseDefaultPostCode;\n\n            return this;\n        }\n    };\n});\n","Magento_Email/js/variables.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Variables, updateElementAtCursor */\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Ui/js/modal/modal',\n    'jquery/ui',\n    'prototype'\n], function (jQuery, $t) {\n    'use strict';\n\n    window.Variables = {\n        textareaElementId: null,\n        variablesContent: null,\n        dialogWindow: null,\n        dialogWindowId: 'variables-chooser',\n        overlayShowEffectOptions: null,\n        overlayHideEffectOptions: null,\n        insertFunction: 'Variables.insertVariable',\n        variablesValue: [],\n\n        /**\n         * @param {*} textareaElementId\n         * @param {Function} insertFunction\n         */\n        init: function (textareaElementId, insertFunction) {\n            if ($(textareaElementId)) {\n                this.textareaElementId = textareaElementId;\n            }\n\n            if (insertFunction) {\n                this.insertFunction = insertFunction;\n            }\n        },\n\n        /**\n         * reset data.\n         */\n        resetData: function () {\n            this.variablesContent = null;\n            this.dialogWindow = null;\n        },\n\n        /**\n         * @param {Object} variables\n         */\n        openVariableChooser: function (variables) {\n            if (this.variablesContent == null && variables) {\n                this.variablesContent = '<ul class=\"insert-variable\">';\n                variables.each(function (variableGroup) {\n                    if (variableGroup.label && variableGroup.value) {\n                        this.variablesContent += '<li><b>' + variableGroup.label.escapeHTML() + '</b></li>';\n                        variableGroup.value.each(function (variable) {\n                            if (variable.value && variable.label) {\n                                this.variablesValue.push(variable.value);\n                                this.variablesContent += '<li>' +\n                                    this.prepareVariableRow(this.variablesValue.length, variable.label) + '</li>';\n                            }\n                        }.bind(this));\n                    }\n                }.bind(this));\n                this.variablesContent += '</ul>';\n            }\n\n            if (this.variablesContent) {\n                this.openDialogWindow(this.variablesContent);\n            }\n        },\n\n        /**\n         * @param {*} variablesContent\n         */\n        openDialogWindow: function (variablesContent) {\n            var windowId = this.dialogWindowId;\n\n            jQuery('<div id=\"' + windowId + '\">' + variablesContent + '</div>').modal({\n                title: $t('Insert Variable...'),\n                type: 'slide',\n                buttons: [],\n\n                /** @inheritdoc */\n                closed: function (e, modal) {\n                    modal.modal.remove();\n                }\n            });\n\n            jQuery('#' + windowId).modal('openModal');\n        },\n\n        /**\n         * Close dialog window.\n         */\n        closeDialogWindow: function () {\n            jQuery('#' + this.dialogWindowId).modal('closeModal');\n        },\n\n        /**\n         * @param {Number} index\n         * @param {*} varLabel\n         * @return {String}\n         */\n        prepareVariableRow: function (index, varLabel) {\n            return '<a href=\"#\" onclick=\"' +\n                this.insertFunction +\n                '(' +\n                index +\n                ');return false;\">' +\n                varLabel.escapeHTML() +\n                '</a>';\n        },\n\n        /**\n         * @param {*} variable\n         */\n        insertVariable: function (variable) {\n            var windowId = this.dialogWindowId,\n                textareaElm, scrollPos;\n\n            jQuery('#