require.config({"config": {
        "jsbuild":{"jquery/ui-modules/dialog.js":"/*!\n * jQuery UI Dialog - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/dialog/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/button',\n    'jquery-ui-modules/draggable',\n    'jquery-ui-modules/position',\n    'jquery-ui-modules/resizable'\n], function ($, undefined) {\n\n    var sizeRelatedOptions = {\n            buttons: true,\n            height: true,\n            maxHeight: true,\n            maxWidth: true,\n            minHeight: true,\n            minWidth: true,\n            width: true\n        },\n        resizableRelatedOptions = {\n            maxHeight: true,\n            maxWidth: true,\n            minHeight: true,\n            minWidth: true\n        };\n\n    $.widget(\"ui.dialog\", {\n        version: \"1.10.4\",\n        options: {\n            appendTo: \"body\",\n            autoOpen: true,\n            buttons: [],\n            closeOnEscape: true,\n            closeText: \"close\",\n            dialogClass: \"\",\n            draggable: true,\n            hide: null,\n            height: \"auto\",\n            maxHeight: null,\n            maxWidth: null,\n            minHeight: 150,\n            minWidth: 150,\n            modal: false,\n            position: {\n                my: \"center\",\n                at: \"center\",\n                of: window,\n                collision: \"fit\",\n                // Ensure the titlebar is always visible\n                using: function (pos) {\n                    var topOffset = $(this).css(pos).offset().top;\n                    if (topOffset < 0) {\n                        $(this).css(\"top\", pos.top - topOffset);\n                    }\n                }\n            },\n            resizable: true,\n            show: null,\n            title: null,\n            width: 300,\n\n            // callbacks\n            beforeClose: null,\n            close: null,\n            drag: null,\n            dragStart: null,\n            dragStop: null,\n            focus: null,\n            open: null,\n            resize: null,\n            resizeStart: null,\n            resizeStop: null\n        },\n\n        _create: function () {\n            this.originalCss = {\n                display: this.element[0].style.display,\n                width: this.element[0].style.width,\n                minHeight: this.element[0].style.minHeight,\n                maxHeight: this.element[0].style.maxHeight,\n                height: this.element[0].style.height\n            };\n            this.originalPosition = {\n                parent: this.element.parent(),\n                index: this.element.parent().children().index(this.element)\n            };\n            this.originalTitle = this.element.attr(\"title\");\n            this.options.title = this.options.title || this.originalTitle;\n\n            this._createWrapper();\n\n            this.element\n                .show()\n                .removeAttr(\"title\")\n                .addClass(\"ui-dialog-content ui-widget-content\")\n                .appendTo(this.uiDialog);\n\n            this._createTitlebar();\n            this._createButtonPane();\n\n            if (this.options.draggable && $.fn.draggable) {\n                this._makeDraggable();\n            }\n            if (this.options.resizable && $.fn.resizable) {\n                this._makeResizable();\n            }\n\n            this._isOpen = false;\n        },\n\n        _init: function () {\n            if (this.options.autoOpen) {\n                this.open();\n            }\n        },\n\n        _appendTo: function () {\n            var element = this.options.appendTo;\n            if (element && (element.jquery || element.nodeType)) {\n                return $(element);\n            }\n            return this.document.find(element || \"body\").eq(0);\n        },\n\n        _destroy: function () {\n            var next,\n                originalPosition = this.originalPosition;\n\n            this._destroyOverlay();\n\n            this.element\n                .removeUniqueId()\n                .removeClass(\"ui-dialog-content ui-widget-content\")\n                .css(this.originalCss)\n                // Without detaching first, the following becomes really slow\n                .detach();\n\n            this.uiDialog.stop(true, true).remove();\n\n            if (this.originalTitle) {\n                this.element.attr(\"title\", this.originalTitle);\n            }\n\n            next = originalPosition.parent.children().eq(originalPosition.index);\n            // Don't try to place the dialog next to itself (#8613)\n            if (next.length && next[0] !== this.element[0]) {\n                next.before(this.element);\n            } else {\n                originalPosition.parent.append(this.element);\n            }\n        },\n\n        widget: function () {\n            return this.uiDialog;\n        },\n\n        disable: $.noop,\n        enable: $.noop,\n\n        close: function (event) {\n            var activeElement,\n                that = this;\n\n            if (!this._isOpen || this._trigger(\"beforeClose\", event) === false) {\n                return;\n            }\n\n            this._isOpen = false;\n            this._destroyOverlay();\n\n            if (!this.opener.filter(\":focusable\").focus().length) {\n\n                // support: IE9\n                // IE9 throws an \"Unspecified error\" accessing document.activeElement from an <iframe>\n                try {\n                    activeElement = this.document[0].activeElement;\n\n                    // Support: IE9, IE10\n                    // If the <body> is blurred, IE will switch windows, see #4520\n                    if (activeElement && activeElement.nodeName.toLowerCase() !== \"body\") {\n\n                        // Hiding a focused element doesn't trigger blur in WebKit\n                        // so in case we have nothing to focus on, explicitly blur the active element\n                        // https://bugs.webkit.org/show_bug.cgi?id=47182\n                        $(activeElement).blur();\n                    }\n                } catch (error) {\n                }\n            }\n\n            this._hide(this.uiDialog, this.options.hide, function () {\n                that._trigger(\"close\", event);\n            });\n        },\n\n        isOpen: function () {\n            return this._isOpen;\n        },\n\n        moveToTop: function () {\n            this._moveToTop();\n        },\n\n        _moveToTop: function (event, silent) {\n            var moved = !!this.uiDialog.nextAll(\":visible\").insertBefore(this.uiDialog).length;\n            if (moved && !silent) {\n                this._trigger(\"focus\", event);\n            }\n            return moved;\n        },\n\n        open: function () {\n            var that = this;\n            if (this._isOpen) {\n                if (this._moveToTop()) {\n                    this._focusTabbable();\n                }\n                return;\n            }\n\n            this._isOpen = true;\n            this.opener = $(this.document[0].activeElement);\n\n            this._size();\n            this._position();\n            this._createOverlay();\n            this._moveToTop(null, true);\n            this._show(this.uiDialog, this.options.show, function () {\n                that._focusTabbable();\n                that._trigger(\"focus\");\n            });\n\n            this._trigger(\"open\");\n        },\n\n        _focusTabbable: function () {\n            // Set focus to the first match:\n            // 1. First element inside the dialog matching [autofocus]\n            // 2. Tabbable element inside the content element\n            // 3. Tabbable element inside the buttonpane\n            // 4. The close button\n            // 5. The dialog itself\n            var hasFocus = this.element.find(\"[autofocus]\");\n            if (!hasFocus.length) {\n                hasFocus = this.element.find(\":tabbable\");\n            }\n            if (!hasFocus.length) {\n                hasFocus = this.uiDialogButtonPane.find(\":tabbable\");\n            }\n            if (!hasFocus.length) {\n                hasFocus = this.uiDialogTitlebarClose.filter(\":tabbable\");\n            }\n            if (!hasFocus.length) {\n                hasFocus = this.uiDialog;\n            }\n            hasFocus.eq(0).focus();\n        },\n\n        _keepFocus: function (event) {\n            function checkFocus() {\n                var activeElement = this.document[0].activeElement,\n                    isActive = this.uiDialog[0] === activeElement ||\n                        $.contains(this.uiDialog[0], activeElement);\n                if (!isActive) {\n                    this._focusTabbable();\n                }\n            }\n\n            event.preventDefault();\n            checkFocus.call(this);\n            // support: IE\n            // IE <= 8 doesn't prevent moving focus even with event.preventDefault()\n            // so we check again later\n            this._delay(checkFocus);\n        },\n\n        _createWrapper: function () {\n            this.uiDialog = $(\"<div>\")\n                .addClass(\"ui-dialog ui-widget ui-widget-content ui-corner-all ui-front \" +\n                    this.options.dialogClass)\n                .hide()\n                .attr({\n                    // Setting tabIndex makes the div focusable\n                    tabIndex: -1,\n                    role: \"dialog\"\n                })\n                .appendTo(this._appendTo());\n\n            this._on(this.uiDialog, {\n                keydown: function (event) {\n                    if (this.options.closeOnEscape && !event.isDefaultPrevented() && event.keyCode &&\n                        event.keyCode === $.ui.keyCode.ESCAPE) {\n                        event.preventDefault();\n                        this.close(event);\n                        return;\n                    }\n\n                    // prevent tabbing out of dialogs\n                    if (event.keyCode !== $.ui.keyCode.TAB) {\n                        return;\n                    }\n                    var tabbables = this.uiDialog.find(\":tabbable\"),\n                        first = tabbables.filter(\":first\"),\n                        last = tabbables.filter(\":last\");\n\n                    if ((event.target === last[0] || event.target === this.uiDialog[0]) && !event.shiftKey) {\n                        first.focus(1);\n                        event.preventDefault();\n                    } else if ((event.target === first[0] || event.target === this.uiDialog[0]) && event.shiftKey) {\n                        last.focus(1);\n                        event.preventDefault();\n                    }\n                },\n                mousedown: function (event) {\n                    if (this._moveToTop(event)) {\n                        this._focusTabbable();\n                    }\n                }\n            });\n\n            // We assume that any existing aria-describedby attribute means\n            // that the dialog content is marked up properly\n            // otherwise we brute force the content as the description\n            if (!this.element.find(\"[aria-describedby]\").length) {\n                this.uiDialog.attr({\n                    \"aria-describedby\": this.element.uniqueId().attr(\"id\")\n                });\n            }\n        },\n\n        _createTitlebar: function () {\n            var uiDialogTitle;\n\n            this.uiDialogTitlebar = $(\"<div>\")\n                .addClass(\"ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix\")\n                .prependTo(this.uiDialog);\n            this._on(this.uiDialogTitlebar, {\n                mousedown: function (event) {\n                    // Don't prevent click on close button (#8838)\n                    // Focusing a dialog that is partially scrolled out of view\n                    // causes the browser to scroll it into view, preventing the click event\n                    if (!$(event.target).closest(\".ui-dialog-titlebar-close\")) {\n                        // Dialog isn't getting focus when dragging (#8063)\n                        this.uiDialog.focus();\n                    }\n                }\n            });\n\n            // support: IE\n            // Use type=\"button\" to prevent enter keypresses in textboxes from closing the\n            // dialog in IE (#9312)\n            this.uiDialogTitlebarClose = $(\"<button type='button'></button>\")\n                .button({\n                    label: this.options.closeText,\n                    icons: {\n                        primary: \"ui-icon-closethick\"\n                    },\n                    text: false\n                })\n                .addClass(\"ui-dialog-titlebar-close\")\n                .appendTo(this.uiDialogTitlebar);\n            this._on(this.uiDialogTitlebarClose, {\n                click: function (event) {\n                    event.preventDefault();\n                    this.close(event);\n                }\n            });\n\n            uiDialogTitle = $(\"<span>\")\n                .uniqueId()\n                .addClass(\"ui-dialog-title\")\n                .prependTo(this.uiDialogTitlebar);\n            this._title(uiDialogTitle);\n\n            this.uiDialog.attr({\n                \"aria-labelledby\": uiDialogTitle.attr(\"id\")\n            });\n        },\n\n        _title: function (title) {\n            if (!this.options.title) {\n                title.html(\"&#160;\");\n            }\n            title.text(this.options.title);\n        },\n\n        _createButtonPane: function () {\n            this.uiDialogButtonPane = $(\"<div>\")\n                .addClass(\"ui-dialog-buttonpane ui-widget-content ui-helper-clearfix\");\n\n            this.uiButtonSet = $(\"<div>\")\n                .addClass(\"ui-dialog-buttonset\")\n                .appendTo(this.uiDialogButtonPane);\n\n            this._createButtons();\n        },\n\n        _createButtons: function () {\n            var that = this,\n                buttons = this.options.buttons;\n\n            // if we already have a button pane, remove it\n            this.uiDialogButtonPane.remove();\n            this.uiButtonSet.empty();\n\n            if ($.isEmptyObject(buttons) || ($.isArray(buttons) && !buttons.length)) {\n                this.uiDialog.removeClass(\"ui-dialog-buttons\");\n                return;\n            }\n\n            $.each(buttons, function (name, props) {\n                var click, buttonOptions;\n                props = $.isFunction(props) ?\n                    {click: props, text: name} :\n                    props;\n                // Default to a non-submitting button\n                props = $.extend({type: \"button\"}, props);\n                // Change the context for the click callback to be the main element\n                click = props.click;\n                props.click = function () {\n                    click.apply(that.element[0], arguments);\n                };\n                buttonOptions = {\n                    icons: props.icons,\n                    text: props.showText\n                };\n                delete props.icons;\n                delete props.showText;\n                $(\"<button></button>\", props)\n                    .button(buttonOptions)\n                    .appendTo(that.uiButtonSet);\n            });\n            this.uiDialog.addClass(\"ui-dialog-buttons\");\n            this.uiDialogButtonPane.appendTo(this.uiDialog);\n        },\n\n        _makeDraggable: function () {\n            var that = this,\n                options = this.options;\n\n            function filteredUi(ui) {\n                return {\n                    position: ui.position,\n                    offset: ui.offset\n                };\n            }\n\n            this.uiDialog.draggable({\n                cancel: \".ui-dialog-content, .ui-dialog-titlebar-close\",\n                handle: \".ui-dialog-titlebar\",\n                containment: \"document\",\n                start: function (event, ui) {\n                    $(this).addClass(\"ui-dialog-dragging\");\n                    that._blockFrames();\n                    that._trigger(\"dragStart\", event, filteredUi(ui));\n                },\n                drag: function (event, ui) {\n                    that._trigger(\"drag\", event, filteredUi(ui));\n                },\n                stop: function (event, ui) {\n                    options.position = [\n                        ui.position.left - that.document.scrollLeft(),\n                        ui.position.top - that.document.scrollTop()\n                    ];\n                    $(this).removeClass(\"ui-dialog-dragging\");\n                    that._unblockFrames();\n                    that._trigger(\"dragStop\", event, filteredUi(ui));\n                }\n            });\n        },\n\n        _makeResizable: function () {\n            var that = this,\n                options = this.options,\n                handles = options.resizable,\n                // .ui-resizable has position: relative defined in the stylesheet\n                // but dialogs have to use absolute or fixed positioning\n                position = this.uiDialog.css(\"position\"),\n                resizeHandles = typeof handles === \"string\" ?\n                    handles :\n                    \"n,e,s,w,se,sw,ne,nw\";\n\n            function filteredUi(ui) {\n                return {\n                    originalPosition: ui.originalPosition,\n                    originalSize: ui.originalSize,\n                    position: ui.position,\n                    size: ui.size\n                };\n            }\n\n            this.uiDialog.resizable({\n                cancel: \".ui-dialog-content\",\n                containment: \"document\",\n                alsoResize: this.element,\n                maxWidth: options.maxWidth,\n                maxHeight: options.maxHeight,\n                minWidth: options.minWidth,\n                minHeight: this._minHeight(),\n                handles: resizeHandles,\n                start: function (event, ui) {\n                    $(this).addClass(\"ui-dialog-resizing\");\n                    that._blockFrames();\n                    that._trigger(\"resizeStart\", event, filteredUi(ui));\n                },\n                resize: function (event, ui) {\n                    that._trigger(\"resize\", event, filteredUi(ui));\n                },\n                stop: function (event, ui) {\n                    options.height = $(this).height();\n                    options.width = $(this).width();\n                    $(this).removeClass(\"ui-dialog-resizing\");\n                    that._unblockFrames();\n                    that._trigger(\"resizeStop\", event, filteredUi(ui));\n                }\n            })\n                .css(\"position\", position);\n        },\n\n        _minHeight: function () {\n            var options = this.options;\n\n            return options.height === \"auto\" ?\n                options.minHeight :\n                Math.min(options.minHeight, options.height);\n        },\n\n        _position: function () {\n            // Need to show the dialog to get the actual offset in the position plugin\n            var isVisible = this.uiDialog.is(\":visible\");\n            if (!isVisible) {\n                this.uiDialog.show();\n            }\n            this.uiDialog.position(this.options.position);\n            if (!isVisible) {\n                this.uiDialog.hide();\n            }\n        },\n\n        _setOptions: function (options) {\n            var that = this,\n                resize = false,\n                resizableOptions = {};\n\n            $.each(options, function (key, value) {\n                that._setOption(key, value);\n\n                if (key in sizeRelatedOptions) {\n                    resize = true;\n                }\n                if (key in resizableRelatedOptions) {\n                    resizableOptions[key] = value;\n                }\n            });\n\n            if (resize) {\n                this._size();\n                this._position();\n            }\n            if (this.uiDialog.is(\":data(ui-resizable)\")) {\n                this.uiDialog.resizable(\"option\", resizableOptions);\n            }\n        },\n\n        _setOption: function (key, value) {\n            var isDraggable, isResizable,\n                uiDialog = this.uiDialog;\n\n            if (key === \"dialogClass\") {\n                uiDialog\n                    .removeClass(this.options.dialogClass)\n                    .addClass(value);\n            }\n\n            if (key === \"disabled\") {\n                return;\n            }\n\n            this._super(key, value);\n\n            if (key === \"appendTo\") {\n                this.uiDialog.appendTo(this._appendTo());\n            }\n\n            if (key === \"buttons\") {\n                this._createButtons();\n            }\n\n            if (key === \"closeText\") {\n                this.uiDialogTitlebarClose.button({\n                    // Ensure that we always pass a string\n                    label: \"\" + value\n                });\n            }\n\n            if (key === \"draggable\") {\n                isDraggable = uiDialog.is(\":data(ui-draggable)\");\n                if (isDraggable && !value) {\n                    uiDialog.draggable(\"destroy\");\n                }\n\n                if (!isDraggable && value) {\n                    this._makeDraggable();\n                }\n            }\n\n            if (key === \"position\") {\n                this._position();\n            }\n\n            if (key === \"resizable\") {\n                // currently resizable, becoming non-resizable\n                isResizable = uiDialog.is(\":data(ui-resizable)\");\n                if (isResizable && !value) {\n                    uiDialog.resizable(\"destroy\");\n                }\n\n                // currently resizable, changing handles\n                if (isResizable && typeof value === \"string\") {\n                    uiDialog.resizable(\"option\", \"handles\", value);\n                }\n\n                // currently non-resizable, becoming resizable\n                if (!isResizable && value !== false) {\n                    this._makeResizable();\n                }\n            }\n\n            if (key === \"title\") {\n                this._title(this.uiDialogTitlebar.find(\".ui-dialog-title\"));\n            }\n        },\n\n        _size: function () {\n            // If the user has resized the dialog, the .ui-dialog and .ui-dialog-content\n            // divs will both have width and height set, so we need to reset them\n            var nonContentHeight, minContentHeight, maxContentHeight,\n                options = this.options;\n\n            // Reset content sizing\n            this.element.show().css({\n                width: \"auto\",\n                minHeight: 0,\n                maxHeight: \"none\",\n                height: 0\n            });\n\n            if (options.minWidth > options.width) {\n                options.width = options.minWidth;\n            }\n\n            // reset wrapper sizing\n            // determine the height of all the non-content elements\n            nonContentHeight = this.uiDialog.css({\n                height: \"auto\",\n                width: options.width\n            })\n                .outerHeight();\n            minContentHeight = Math.max(0, options.minHeight - nonContentHeight);\n            maxContentHeight = typeof options.maxHeight === \"number\" ?\n                Math.max(0, options.maxHeight - nonContentHeight) :\n                \"none\";\n\n            if (options.height === \"auto\") {\n                this.element.css({\n                    minHeight: minContentHeight,\n                    maxHeight: maxContentHeight,\n                    height: \"auto\"\n                });\n            } else {\n                this.element.height(Math.max(0, options.height - nonContentHeight));\n            }\n\n            if (this.uiDialog.is(\":data(ui-resizable)\")) {\n                this.uiDialog.resizable(\"option\", \"minHeight\", this._minHeight());\n            }\n        },\n\n        _blockFrames: function () {\n            this.iframeBlocks = this.document.find(\"iframe\").map(function () {\n                var iframe = $(this);\n\n                return $(\"<div>\")\n                    .css({\n                        position: \"absolute\",\n                        width: iframe.outerWidth(),\n                        height: iframe.outerHeight()\n                    })\n                    .appendTo(iframe.parent())\n                    .offset(iframe.offset())[0];\n            });\n        },\n\n        _unblockFrames: function () {\n            if (this.iframeBlocks) {\n                this.iframeBlocks.remove();\n                delete this.iframeBlocks;\n            }\n        },\n\n        _allowInteraction: function (event) {\n            if ($(event.target).closest(\".ui-dialog\").length) {\n                return true;\n            }\n\n            // TODO: Remove hack when datepicker implements\n            // the .ui-front logic (#8989)\n            return !!$(event.target).closest(\".ui-datepicker\").length;\n        },\n\n        _createOverlay: function () {\n            if (!this.options.modal) {\n                return;\n            }\n\n            var that = this,\n                widgetFullName = this.widgetFullName;\n            if (!$.ui.dialog.overlayInstances) {\n                // Prevent use of anchors and inputs.\n                // We use a delay in case the overlay is created from an\n                // event that we're going to be cancelling. (#2804)\n                this._delay(function () {\n                    // Handle .dialog().dialog(\"close\") (#4065)\n                    if ($.ui.dialog.overlayInstances) {\n                        this.document.bind(\"focusin.dialog\", function (event) {\n                            if (!that._allowInteraction(event)) {\n                                event.preventDefault();\n                                $(\".ui-dialog:visible:last .ui-dialog-content\")\n                                    .data(widgetFullName)._focusTabbable();\n                            }\n                        });\n                    }\n                });\n            }\n\n            this.overlay = $(\"<div>\")\n                .addClass(\"ui-widget-overlay ui-front\")\n                .appendTo(this._appendTo());\n            this._on(this.overlay, {\n                mousedown: \"_keepFocus\"\n            });\n            $.ui.dialog.overlayInstances++;\n        },\n\n        _destroyOverlay: function () {\n            if (!this.options.modal) {\n                return;\n            }\n\n            if (this.overlay) {\n                $.ui.dialog.overlayInstances--;\n\n                if (!$.ui.dialog.overlayInstances) {\n                    this.document.unbind(\"focusin.dialog\");\n                }\n                this.overlay.remove();\n                this.overlay = null;\n            }\n        }\n    });\n\n    $.ui.dialog.overlayInstances = 0;\n\n// DEPRECATED\n    if ($.uiBackCompat !== false) {\n        // position option with array notation\n        // just override with old implementation\n        $.widget(\"ui.dialog\", $.ui.dialog, {\n            _position: function () {\n                var position = this.options.position,\n                    myAt = [],\n                    offset = [0, 0],\n                    isVisible;\n\n                if (position) {\n                    if (typeof position === \"string\" || (typeof position === \"object\" && \"0\" in position)) {\n                        myAt = position.split ? position.split(\" \") : [position[0], position[1]];\n                        if (myAt.length === 1) {\n                            myAt[1] = myAt[0];\n                        }\n\n                        $.each([\"left\", \"top\"], function (i, offsetPosition) {\n                            if (+myAt[i] === myAt[i]) {\n                                offset[i] = myAt[i];\n                                myAt[i] = offsetPosition;\n                            }\n                        });\n\n                        position = {\n                            my: myAt[0] + (offset[0] < 0 ? offset[0] : \"+\" + offset[0]) + \" \" +\n                                myAt[1] + (offset[1] < 0 ? offset[1] : \"+\" + offset[1]),\n                            at: myAt.join(\" \")\n                        };\n                    }\n\n                    position = $.extend({}, $.ui.dialog.prototype.options.position, position);\n                } else {\n                    position = $.ui.dialog.prototype.options.position;\n                }\n\n                // need to show the dialog to get the actual offset in the position plugin\n                isVisible = this.uiDialog.is(\":visible\");\n                if (!isVisible) {\n                    this.uiDialog.show();\n                }\n                this.uiDialog.position(position);\n                if (!isVisible) {\n                    this.uiDialog.hide();\n                }\n            }\n        });\n    }\n\n});\n","jquery/ui-modules/core.js":"/*!\n * jQuery UI Core - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/category/ui-core/\n */\ndefine([\n    'jquery'\n], function ($, undefined) {\n\n    var uuid = 0,\n        runiqueId = /^ui-id-\\d+$/;\n\n// $.ui might exist from components with no dependencies, e.g., $.ui.position\n    $.ui = $.ui || {};\n\n    $.extend($.ui, {\n        version: \"1.10.4\",\n\n        keyCode: {\n            BACKSPACE: 8,\n            COMMA: 188,\n            DELETE: 46,\n            DOWN: 40,\n            END: 35,\n            ENTER: 13,\n            ESCAPE: 27,\n            HOME: 36,\n            LEFT: 37,\n            NUMPAD_ADD: 107,\n            NUMPAD_DECIMAL: 110,\n            NUMPAD_DIVIDE: 111,\n            NUMPAD_ENTER: 108,\n            NUMPAD_MULTIPLY: 106,\n            NUMPAD_SUBTRACT: 109,\n            PAGE_DOWN: 34,\n            PAGE_UP: 33,\n            PERIOD: 190,\n            RIGHT: 39,\n            SPACE: 32,\n            TAB: 9,\n            UP: 38\n        }\n    });\n\n// plugins\n    $.fn.extend({\n        focus: (function (orig) {\n            return function (delay, fn) {\n                return typeof delay === \"number\" ?\n                    this.each(function () {\n                        var elem = this;\n                        setTimeout(function () {\n                            $(elem).focus();\n                            if (fn) {\n                                fn.call(elem);\n                            }\n                        }, delay);\n                    }) :\n                    orig.apply(this, arguments);\n            };\n        })($.fn.focus),\n\n        scrollParent: function () {\n            var scrollParent;\n            if (($.ui.ie && (/(static|relative)/).test(this.css(\"position\"))) || (/absolute/).test(this.css(\"position\"))) {\n                scrollParent = this.parents().filter(function () {\n                    return (/(relative|absolute|fixed)/).test($.css(this, \"position\")) && (/(auto|scroll)/).test($.css(this, \"overflow\") + $.css(this, \"overflow-y\") + $.css(this, \"overflow-x\"));\n                }).eq(0);\n            } else {\n                scrollParent = this.parents().filter(function () {\n                    return (/(auto|scroll)/).test($.css(this, \"overflow\") + $.css(this, \"overflow-y\") + $.css(this, \"overflow-x\"));\n                }).eq(0);\n            }\n\n            return (/fixed/).test(this.css(\"position\")) || !scrollParent.length ? $(document) : scrollParent;\n        },\n\n        zIndex: function (zIndex) {\n            if (zIndex !== undefined) {\n                return this.css(\"zIndex\", zIndex);\n            }\n\n            if (this.length) {\n                var elem = $(this[0]), position, value;\n                while (elem.length && elem[0] !== document) {\n                    // Ignore z-index if position is set to a value where z-index is ignored by the browser\n                    // This makes behavior of this function consistent across browsers\n                    // WebKit always returns auto if the element is positioned\n                    position = elem.css(\"position\");\n                    if (position === \"absolute\" || position === \"relative\" || position === \"fixed\") {\n                        // IE returns 0 when zIndex is not specified\n                        // other browsers return a string\n                        // we ignore the case of nested elements with an explicit value of 0\n                        // <div style=\"z-index: -10;\"><div style=\"z-index: 0;\"></div></div>\n                        value = parseInt(elem.css(\"zIndex\"), 10);\n                        if (!isNaN(value) && value !== 0) {\n                            return value;\n                        }\n                    }\n                    elem = elem.parent();\n                }\n            }\n\n            return 0;\n        },\n\n        uniqueId: function () {\n            return this.each(function () {\n                if (!this.id) {\n                    this.id = \"ui-id-\" + (++uuid);\n                }\n            });\n        },\n\n        removeUniqueId: function () {\n            return this.each(function () {\n                if (runiqueId.test(this.id)) {\n                    $(this).removeAttr(\"id\");\n                }\n            });\n        }\n    });\n\n// selectors\n    function focusable(element, isTabIndexNotNaN) {\n        var map, mapName, img,\n            nodeName = element.nodeName.toLowerCase();\n        if (\"area\" === nodeName) {\n            map = element.parentNode;\n            mapName = map.name;\n            if (!element.href || !mapName || map.nodeName.toLowerCase() !== \"map\") {\n                return false;\n            }\n            img = $(\"img[usemap=#\" + mapName + \"]\")[0];\n            return !!img && visible(img);\n        }\n        return (/input|select|textarea|button|object/.test(nodeName) ?\n            !element.disabled :\n            \"a\" === nodeName ?\n                element.href || isTabIndexNotNaN :\n                isTabIndexNotNaN) &&\n            // the element and all of its ancestors must be visible\n            visible(element);\n    }\n\n    function visible(element) {\n        return $.expr.filters.visible(element) &&\n            !$(element).parents().addBack().filter(function () {\n                return $.css(this, \"visibility\") === \"hidden\";\n            }).length;\n    }\n\n    $.extend($.expr[\":\"], {\n        data: $.expr.createPseudo ?\n            $.expr.createPseudo(function (dataName) {\n                return function (elem) {\n                    return !!$.data(elem, dataName);\n                };\n            }) :\n            // support: jQuery <1.8\n            function (elem, i, match) {\n                return !!$.data(elem, match[3]);\n            },\n\n        focusable: function (element) {\n            return focusable(element, !isNaN($.attr(element, \"tabindex\")));\n        },\n\n        tabbable: function (element) {\n            var tabIndex = $.attr(element, \"tabindex\"),\n                isTabIndexNaN = isNaN(tabIndex);\n            return (isTabIndexNaN || tabIndex >= 0) && focusable(element, !isTabIndexNaN);\n        }\n    });\n\n// support: jQuery <1.8\n    if (!$(\"<a>\").outerWidth(1).jquery) {\n        $.each([\"Width\", \"Height\"], function (i, name) {\n            var side = name === \"Width\" ? [\"Left\", \"Right\"] : [\"Top\", \"Bottom\"],\n                type = name.toLowerCase(),\n                orig = {\n                    innerWidth: $.fn.innerWidth,\n                    innerHeight: $.fn.innerHeight,\n                    outerWidth: $.fn.outerWidth,\n                    outerHeight: $.fn.outerHeight\n                };\n\n            function reduce(elem, size, border, margin) {\n                $.each(side, function () {\n                    size -= parseFloat($.css(elem, \"padding\" + this)) || 0;\n                    if (border) {\n                        size -= parseFloat($.css(elem, \"border\" + this + \"Width\")) || 0;\n                    }\n                    if (margin) {\n                        size -= parseFloat($.css(elem, \"margin\" + this)) || 0;\n                    }\n                });\n                return size;\n            }\n\n            $.fn[\"inner\" + name] = function (size) {\n                if (size === undefined) {\n                    return orig[\"inner\" + name].call(this);\n                }\n\n                return this.each(function () {\n                    $(this).css(type, reduce(this, size) + \"px\");\n                });\n            };\n\n            $.fn[\"outer\" + name] = function (size, margin) {\n                if (typeof size !== \"number\") {\n                    return orig[\"outer\" + name].call(this, size);\n                }\n\n                return this.each(function () {\n                    $(this).css(type, reduce(this, size, true, margin) + \"px\");\n                });\n            };\n        });\n    }\n\n// support: jQuery <1.8\n    if (!$.fn.addBack) {\n        $.fn.addBack = function (selector) {\n            return this.add(selector == null ?\n                this.prevObject : this.prevObject.filter(selector)\n            );\n        };\n    }\n\n// support: jQuery 1.6.1, 1.6.2 (http://bugs.jquery.com/ticket/9413)\n    if ($(\"<a>\").data(\"a-b\", \"a\").removeData(\"a-b\").data(\"a-b\")) {\n        $.fn.removeData = (function (removeData) {\n            return function (key) {\n                if (arguments.length) {\n                    return removeData.call(this, $.camelCase(key));\n                } else {\n                    return removeData.call(this);\n                }\n            };\n        })($.fn.removeData);\n    }\n\n\n// deprecated\n    $.ui.ie = !!/msie [\\w.]+/.exec(navigator.userAgent.toLowerCase());\n\n    $.support.selectstart = \"onselectstart\" in document.createElement(\"div\");\n    $.fn.extend({\n        disableSelection: function () {\n            return this.bind(($.support.selectstart ? \"selectstart\" : \"mousedown\") +\n                \".ui-disableSelection\", function (event) {\n                event.preventDefault();\n            });\n        },\n\n        enableSelection: function () {\n            return this.unbind(\".ui-disableSelection\");\n        }\n    });\n\n    $.extend($.ui, {\n        // $.ui.plugin is deprecated. Use $.widget() extensions instead.\n        plugin: {\n            add: function (module, option, set) {\n                var i,\n                    proto = $.ui[module].prototype;\n                for (i in set) {\n                    proto.plugins[i] = proto.plugins[i] || [];\n                    proto.plugins[i].push([option, set[i]]);\n                }\n            },\n            call: function (instance, name, args) {\n                var i,\n                    set = instance.plugins[name];\n                if (!set || !instance.element[0].parentNode || instance.element[0].parentNode.nodeType === 11) {\n                    return;\n                }\n\n                for (i = 0; i < set.length; i++) {\n                    if (instance.options[set[i][0]]) {\n                        set[i][1].apply(instance.element, args);\n                    }\n                }\n            }\n        },\n\n        // only used by resizable\n        hasScroll: function (el, a) {\n\n            //If overflow is hidden, the element might have extra content, but the user wants to hide it\n            if ($(el).css(\"overflow\") === \"hidden\") {\n                return false;\n            }\n\n            var scroll = (a && a === \"left\") ? \"scrollLeft\" : \"scrollTop\",\n                has = false;\n\n            if (el[scroll] > 0) {\n                return true;\n            }\n\n            // TODO: determine which cases actually cause this to happen\n            // if the element doesn't have the scroll set, see if it's possible to\n            // set the scroll\n            el[scroll] = 1;\n            has = (el[scroll] > 0);\n            el[scroll] = 0;\n            return has;\n        }\n    });\n\n});\n","jquery/ui-modules/effect-pulsate.js":"/*!\n * jQuery UI Effects Pulsate - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/pulsate-effect/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.pulsate = function (o, done) {\n        var elem = $(this),\n            mode = $.effects.setMode(elem, o.mode || \"show\"),\n            show = mode === \"show\",\n            hide = mode === \"hide\",\n            showhide = (show || mode === \"hide\"),\n\n            // showing or hiding leaves of the \"last\" animation\n            anims = ((o.times || 5) * 2) + (showhide ? 1 : 0),\n            duration = o.duration / anims,\n            animateTo = 0,\n            queue = elem.queue(),\n            queuelen = queue.length,\n            i;\n\n        if (show || !elem.is(\":visible\")) {\n            elem.css(\"opacity\", 0).show();\n            animateTo = 1;\n        }\n\n        // anims - 1 opacity \"toggles\"\n        for (i = 1; i < anims; i++) {\n            elem.animate({\n                opacity: animateTo\n            }, duration, o.easing);\n            animateTo = 1 - animateTo;\n        }\n\n        elem.animate({\n            opacity: animateTo\n        }, duration, o.easing);\n\n        elem.queue(function () {\n            if (hide) {\n                elem.hide();\n            }\n            done();\n        });\n\n        // We just queued up \"anims\" animations, we need to put them next in the queue\n        if (queuelen > 1) {\n            queue.splice.apply(queue,\n                [1, 0].concat(queue.splice(queuelen, anims + 1)));\n        }\n        elem.dequeue();\n    };\n\n});\n","jquery/ui-modules/spinner.js":"/*!\n * jQuery UI Spinner - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/spinner/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/button'\n], function ($) {\n\n    function modifier(fn) {\n        return function () {\n            var previous = this.element.val();\n            fn.apply(this, arguments);\n            this._refresh();\n            if (previous !== this.element.val()) {\n                this._trigger(\"change\");\n            }\n        };\n    }\n\n    $.widget(\"ui.spinner\", {\n        version: \"1.10.4\",\n        defaultElement: \"<input>\",\n        widgetEventPrefix: \"spin\",\n        options: {\n            culture: null,\n            icons: {\n                down: \"ui-icon-triangle-1-s\",\n                up: \"ui-icon-triangle-1-n\"\n            },\n            incremental: true,\n            max: null,\n            min: null,\n            numberFormat: null,\n            page: 10,\n            step: 1,\n\n            change: null,\n            spin: null,\n            start: null,\n            stop: null\n        },\n\n        _create: function () {\n            // handle string values that need to be parsed\n            this._setOption(\"max\", this.options.max);\n            this._setOption(\"min\", this.options.min);\n            this._setOption(\"step\", this.options.step);\n\n            // Only format if there is a value, prevents the field from being marked\n            // as invalid in Firefox, see #9573.\n            if (this.value() !== \"\") {\n                // Format the value, but don't constrain.\n                this._value(this.element.val(), true);\n            }\n\n            this._draw();\n            this._on(this._events);\n            this._refresh();\n\n            // turning off autocomplete prevents the browser from remembering the\n            // value when navigating through history, so we re-enable autocomplete\n            // if the page is unloaded before the widget is destroyed. #7790\n            this._on(this.window, {\n                beforeunload: function () {\n                    this.element.removeAttr(\"autocomplete\");\n                }\n            });\n        },\n\n        _getCreateOptions: function () {\n            var options = {},\n                element = this.element;\n\n            $.each([\"min\", \"max\", \"step\"], function (i, option) {\n                var value = element.attr(option);\n                if (value !== undefined && value.length) {\n                    options[option] = value;\n                }\n            });\n\n            return options;\n        },\n\n        _events: {\n            keydown: function (event) {\n                if (this._start(event) && this._keydown(event)) {\n                    event.preventDefault();\n                }\n            },\n            keyup: \"_stop\",\n            focus: function () {\n                this.previous = this.element.val();\n            },\n            blur: function (event) {\n                if (this.cancelBlur) {\n                    delete this.cancelBlur;\n                    return;\n                }\n\n                this._stop();\n                this._refresh();\n                if (this.previous !== this.element.val()) {\n                    this._trigger(\"change\", event);\n                }\n            },\n            mousewheel: function (event, delta) {\n                if (!delta) {\n                    return;\n                }\n                if (!this.spinning && !this._start(event)) {\n                    return false;\n                }\n\n                this._spin((delta > 0 ? 1 : -1) * this.options.step, event);\n                clearTimeout(this.mousewheelTimer);\n                this.mousewheelTimer = this._delay(function () {\n                    if (this.spinning) {\n                        this._stop(event);\n                    }\n                }, 100);\n                event.preventDefault();\n            },\n            \"mousedown .ui-spinner-button\": function (event) {\n                var previous;\n\n                // We never want the buttons to have focus; whenever the user is\n                // interacting with the spinner, the focus should be on the input.\n                // If the input is focused then this.previous is properly set from\n                // when the input first received focus. If the input is not focused\n                // then we need to set this.previous based on the value before spinning.\n                previous = this.element[0] === this.document[0].activeElement ?\n                    this.previous : this.element.val();\n\n                function checkFocus() {\n                    var isActive = this.element[0] === this.document[0].activeElement;\n                    if (!isActive) {\n                        this.element.focus();\n                        this.previous = previous;\n                        // support: IE\n                        // IE sets focus asynchronously, so we need to check if focus\n                        // moved off of the input because the user clicked on the button.\n                        this._delay(function () {\n                            this.previous = previous;\n                        });\n                    }\n                }\n\n                // ensure focus is on (or stays on) the text field\n                event.preventDefault();\n                checkFocus.call(this);\n\n                // support: IE\n                // IE doesn't prevent moving focus even with event.preventDefault()\n                // so we set a flag to know when we should ignore the blur event\n                // and check (again) if focus moved off of the input.\n                this.cancelBlur = true;\n                this._delay(function () {\n                    delete this.cancelBlur;\n                    checkFocus.call(this);\n                });\n\n                if (this._start(event) === false) {\n                    return;\n                }\n\n                this._repeat(null, $(event.currentTarget).hasClass(\"ui-spinner-up\") ? 1 : -1, event);\n            },\n            \"mouseup .ui-spinner-button\": \"_stop\",\n            \"mouseenter .ui-spinner-button\": function (event) {\n                // button will add ui-state-active if mouse was down while mouseleave and kept down\n                if (!$(event.currentTarget).hasClass(\"ui-state-active\")) {\n                    return;\n                }\n\n                if (this._start(event) === false) {\n                    return false;\n                }\n                this._repeat(null, $(event.currentTarget).hasClass(\"ui-spinner-up\") ? 1 : -1, event);\n            },\n            // TODO: do we really want to consider this a stop?\n            // shouldn't we just stop the repeater and wait until mouseup before\n            // we trigger the stop event?\n            \"mouseleave .ui-spinner-button\": \"_stop\"\n        },\n\n        _draw: function () {\n            var uiSpinner = this.uiSpinner = this.element\n                .addClass(\"ui-spinner-input\")\n                .attr(\"autocomplete\", \"off\")\n                .wrap(this._uiSpinnerHtml())\n                .parent()\n                // add buttons\n                .append(this._buttonHtml());\n\n            this.element.attr(\"role\", \"spinbutton\");\n\n            // button bindings\n            this.buttons = uiSpinner.find(\".ui-spinner-button\")\n                .attr(\"tabIndex\", -1)\n                .button()\n                .removeClass(\"ui-corner-all\");\n\n            // IE 6 doesn't understand height: 50% for the buttons\n            // unless the wrapper has an explicit height\n            if (this.buttons.height() > Math.ceil(uiSpinner.height() * 0.5) &&\n                uiSpinner.height() > 0) {\n                uiSpinner.height(uiSpinner.height());\n            }\n\n            // disable spinner if element was already disabled\n            if (this.options.disabled) {\n                this.disable();\n            }\n        },\n\n        _keydown: function (event) {\n            var options = this.options,\n                keyCode = $.ui.keyCode;\n\n            switch (event.keyCode) {\n                case keyCode.UP:\n                    this._repeat(null, 1, event);\n                    return true;\n                case keyCode.DOWN:\n                    this._repeat(null, -1, event);\n                    return true;\n                case keyCode.PAGE_UP:\n                    this._repeat(null, options.page, event);\n                    return true;\n                case keyCode.PAGE_DOWN:\n                    this._repeat(null, -options.page, event);\n                    return true;\n            }\n\n            return false;\n        },\n\n        _uiSpinnerHtml: function () {\n            return \"<span class='ui-spinner ui-widget ui-widget-content ui-corner-all'></span>\";\n        },\n\n        _buttonHtml: function () {\n            return \"\" +\n                \"<a class='ui-spinner-button ui-spinner-up ui-corner-tr'>\" +\n                \"<span class='ui-icon \" + this.options.icons.up + \"'>&#9650;</span>\" +\n                \"</a>\" +\n                \"<a class='ui-spinner-button ui-spinner-down ui-corner-br'>\" +\n                \"<span class='ui-icon \" + this.options.icons.down + \"'>&#9660;</span>\" +\n                \"</a>\";\n        },\n\n        _start: function (event) {\n            if (!this.spinning && this._trigger(\"start\", event) === false) {\n                return false;\n            }\n\n            if (!this.counter) {\n                this.counter = 1;\n            }\n            this.spinning = true;\n            return true;\n        },\n\n        _repeat: function (i, steps, event) {\n            i = i || 500;\n\n            clearTimeout(this.timer);\n            this.timer = this._delay(function () {\n                this._repeat(40, steps, event);\n            }, i);\n\n            this._spin(steps * this.options.step, event);\n        },\n\n        _spin: function (step, event) {\n            var value = this.value() || 0;\n\n            if (!this.counter) {\n                this.counter = 1;\n            }\n\n            value = this._adjustValue(value + step * this._increment(this.counter));\n\n            if (!this.spinning || this._trigger(\"spin\", event, {value: value}) !== false) {\n                this._value(value);\n                this.counter++;\n            }\n        },\n\n        _increment: function (i) {\n            var incremental = this.options.incremental;\n\n            if (incremental) {\n                return $.isFunction(incremental) ?\n                    incremental(i) :\n                    Math.floor(i * i * i / 50000 - i * i / 500 + 17 * i / 200 + 1);\n            }\n\n            return 1;\n        },\n\n        _precision: function () {\n            var precision = this._precisionOf(this.options.step);\n            if (this.options.min !== null) {\n                precision = Math.max(precision, this._precisionOf(this.options.min));\n            }\n            return precision;\n        },\n\n        _precisionOf: function (num) {\n            var str = num.toString(),\n                decimal = str.indexOf(\".\");\n            return decimal === -1 ? 0 : str.length - decimal - 1;\n        },\n\n        _adjustValue: function (value) {\n            var base, aboveMin,\n                options = this.options;\n\n            // make sure we're at a valid step\n            // - find out where we are relative to the base (min or 0)\n            base = options.min !== null ? options.min : 0;\n            aboveMin = value - base;\n            // - round to the nearest step\n            aboveMin = Math.round(aboveMin / options.step) * options.step;\n            // - rounding is based on 0, so adjust back to our base\n            value = base + aboveMin;\n\n            // fix precision from bad JS floating point math\n            value = parseFloat(value.toFixed(this._precision()));\n\n            // clamp the value\n            if (options.max !== null && value > options.max) {\n                return options.max;\n            }\n            if (options.min !== null && value < options.min) {\n                return options.min;\n            }\n\n            return value;\n        },\n\n        _stop: function (event) {\n            if (!this.spinning) {\n                return;\n            }\n\n            clearTimeout(this.timer);\n            clearTimeout(this.mousewheelTimer);\n            this.counter = 0;\n            this.spinning = false;\n            this._trigger(\"stop\", event);\n        },\n\n        _setOption: function (key, value) {\n            if (key === \"culture\" || key === \"numberFormat\") {\n                var prevValue = this._parse(this.element.val());\n                this.options[key] = value;\n                this.element.val(this._format(prevValue));\n                return;\n            }\n\n            if (key === \"max\" || key === \"min\" || key === \"step\") {\n                if (typeof value === \"string\") {\n                    value = this._parse(value);\n                }\n            }\n            if (key === \"icons\") {\n                this.buttons.first().find(\".ui-icon\")\n                    .removeClass(this.options.icons.up)\n                    .addClass(value.up);\n                this.buttons.last().find(\".ui-icon\")\n                    .removeClass(this.options.icons.down)\n                    .addClass(value.down);\n            }\n\n            this._super(key, value);\n\n            if (key === \"disabled\") {\n                if (value) {\n                    this.element.prop(\"disabled\", true);\n                    this.buttons.button(\"disable\");\n                } else {\n                    this.element.prop(\"disabled\", false);\n                    this.buttons.button(\"enable\");\n                }\n            }\n        },\n\n        _setOptions: modifier(function (options) {\n            this._super(options);\n            this._value(this.element.val());\n        }),\n\n        _parse: function (val) {\n            if (typeof val === \"string\" && val !== \"\") {\n                val = window.Globalize && this.options.numberFormat ?\n                    Globalize.parseFloat(val, 10, this.options.culture) : +val;\n            }\n            return val === \"\" || isNaN(val) ? null : val;\n        },\n\n        _format: function (value) {\n            if (value === \"\") {\n                return \"\";\n            }\n            return window.Globalize && this.options.numberFormat ?\n                Globalize.format(value, this.options.numberFormat, this.options.culture) :\n                value;\n        },\n\n        _refresh: function () {\n            this.element.attr({\n                \"aria-valuemin\": this.options.min,\n                \"aria-valuemax\": this.options.max,\n                // TODO: what should we do with values that can't be parsed?\n                \"aria-valuenow\": this._parse(this.element.val())\n            });\n        },\n\n        // update the value without triggering change\n        _value: function (value, allowAny) {\n            var parsed;\n            if (value !== \"\") {\n                parsed = this._parse(value);\n                if (parsed !== null) {\n                    if (!allowAny) {\n                        parsed = this._adjustValue(parsed);\n                    }\n                    value = this._format(parsed);\n                }\n            }\n            this.element.val(value);\n            this._refresh();\n        },\n\n        _destroy: function () {\n            this.element\n                .removeClass(\"ui-spinner-input\")\n                .prop(\"disabled\", false)\n                .removeAttr(\"autocomplete\")\n                .removeAttr(\"role\")\n                .removeAttr(\"aria-valuemin\")\n                .removeAttr(\"aria-valuemax\")\n                .removeAttr(\"aria-valuenow\");\n            this.uiSpinner.replaceWith(this.element);\n        },\n\n        stepUp: modifier(function (steps) {\n            this._stepUp(steps);\n        }),\n        _stepUp: function (steps) {\n            if (this._start()) {\n                this._spin((steps || 1) * this.options.step);\n                this._stop();\n            }\n        },\n\n        stepDown: modifier(function (steps) {\n            this._stepDown(steps);\n        }),\n        _stepDown: function (steps) {\n            if (this._start()) {\n                this._spin((steps || 1) * -this.options.step);\n                this._stop();\n            }\n        },\n\n        pageUp: modifier(function (pages) {\n            this._stepUp((pages || 1) * this.options.page);\n        }),\n\n        pageDown: modifier(function (pages) {\n            this._stepDown((pages || 1) * this.options.page);\n        }),\n\n        value: function (newVal) {\n            if (!arguments.length) {\n                return this._parse(this.element.val());\n            }\n            modifier(this._value).call(this, newVal);\n        },\n\n        widget: function () {\n            return this.uiSpinner;\n        }\n    });\n\n});\n","jquery/ui-modules/effect.js":"/*!\n * jQuery UI Effects - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/category/effects-core/\n */\n\ndefine([\n    'jquery'\n], function ($, undefined) {\n\n    var dataSpace = \"ui-effects-\";\n\n    $.effects = {\n        effect: {}\n    };\n\n    /*!\n     * jQuery Color Animations v2.1.2\n     * https://github.com/jquery/jquery-color\n     *\n     * Copyright 2013 jQuery Foundation and other contributors\n     * Released under the MIT license.\n     * http://jquery.org/license\n     *\n     * Date: Wed Jan 16 08:47:09 2013 -0600\n     */\n    (function (jQuery, undefined) {\n\n        var stepHooks = \"backgroundColor borderBottomColor borderLeftColor borderRightColor borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor\",\n\n            // plusequals test for += 100 -= 100\n            rplusequals = /^([\\-+])=\\s*(\\d+\\.?\\d*)/,\n            // a set of RE's that can match strings and generate color tuples.\n            stringParsers = [{\n                re: /rgba?\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,\n                parse: function (execResult) {\n                    return [\n                        execResult[1],\n                        execResult[2],\n                        execResult[3],\n                        execResult[4]\n                    ];\n                }\n            }, {\n                re: /rgba?\\(\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,\n                parse: function (execResult) {\n                    return [\n                        execResult[1] * 2.55,\n                        execResult[2] * 2.55,\n                        execResult[3] * 2.55,\n                        execResult[4]\n                    ];\n                }\n            }, {\n                // this regex ignores A-F because it's compared against an already lowercased string\n                re: /#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})/,\n                parse: function (execResult) {\n                    return [\n                        parseInt(execResult[1], 16),\n                        parseInt(execResult[2], 16),\n                        parseInt(execResult[3], 16)\n                    ];\n                }\n            }, {\n                // this regex ignores A-F because it's compared against an already lowercased string\n                re: /#([a-f0-9])([a-f0-9])([a-f0-9])/,\n                parse: function (execResult) {\n                    return [\n                        parseInt(execResult[1] + execResult[1], 16),\n                        parseInt(execResult[2] + execResult[2], 16),\n                        parseInt(execResult[3] + execResult[3], 16)\n                    ];\n                }\n            }, {\n                re: /hsla?\\(\\s*(\\d+(?:\\.\\d+)?)\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,\n                space: \"hsla\",\n                parse: function (execResult) {\n                    return [\n                        execResult[1],\n                        execResult[2] / 100,\n                        execResult[3] / 100,\n                        execResult[4]\n                    ];\n                }\n            }],\n\n            // jQuery.Color( )\n            color = jQuery.Color = function (color, green, blue, alpha) {\n                return new jQuery.Color.fn.parse(color, green, blue, alpha);\n            },\n            spaces = {\n                rgba: {\n                    props: {\n                        red: {\n                            idx: 0,\n                            type: \"byte\"\n                        },\n                        green: {\n                            idx: 1,\n                            type: \"byte\"\n                        },\n                        blue: {\n                            idx: 2,\n                            type: \"byte\"\n                        }\n                    }\n                },\n\n                hsla: {\n                    props: {\n                        hue: {\n                            idx: 0,\n                            type: \"degrees\"\n                        },\n                        saturation: {\n                            idx: 1,\n                            type: \"percent\"\n                        },\n                        lightness: {\n                            idx: 2,\n                            type: \"percent\"\n                        }\n                    }\n                }\n            },\n            propTypes = {\n                \"byte\": {\n                    floor: true,\n                    max: 255\n                },\n                \"percent\": {\n                    max: 1\n                },\n                \"degrees\": {\n                    mod: 360,\n                    floor: true\n                }\n            },\n            support = color.support = {},\n\n            // element for support tests\n            supportElem = jQuery(\"<p>\")[0],\n\n            // colors = jQuery.Color.names\n            colors,\n\n            // local aliases of functions called often\n            each = jQuery.each;\n\n// determine rgba support immediately\n        supportElem.style.cssText = \"background-color:rgba(1,1,1,.5)\";\n        support.rgba = supportElem.style.backgroundColor.indexOf(\"rgba\") > -1;\n\n// define cache name and alpha properties\n// for rgba and hsla spaces\n        each(spaces, function (spaceName, space) {\n            space.cache = \"_\" + spaceName;\n            space.props.alpha = {\n                idx: 3,\n                type: \"percent\",\n                def: 1\n            };\n        });\n\n        function clamp(value, prop, allowEmpty) {\n            var type = propTypes[prop.type] || {};\n\n            if (value == null) {\n                return (allowEmpty || !prop.def) ? null : prop.def;\n            }\n\n            // ~~ is an short way of doing floor for positive numbers\n            value = type.floor ? ~~value : parseFloat(value);\n\n            // IE will pass in empty strings as value for alpha,\n            // which will hit this case\n            if (isNaN(value)) {\n                return prop.def;\n            }\n\n            if (type.mod) {\n                // we add mod before modding to make sure that negatives values\n                // get converted properly: -10 -> 350\n                return (value + type.mod) % type.mod;\n            }\n\n            // for now all property types without mod have min and max\n            return 0 > value ? 0 : type.max < value ? type.max : value;\n        }\n\n        function stringParse(string) {\n            var inst = color(),\n                rgba = inst._rgba = [];\n\n            string = string.toLowerCase();\n\n            each(stringParsers, function (i, parser) {\n                var parsed,\n                    match = parser.re.exec(string),\n                    values = match && parser.parse(match),\n                    spaceName = parser.space || \"rgba\";\n\n                if (values) {\n                    parsed = inst[spaceName](values);\n\n                    // if this was an rgba parse the assignment might happen twice\n                    // oh well....\n                    inst[spaces[spaceName].cache] = parsed[spaces[spaceName].cache];\n                    rgba = inst._rgba = parsed._rgba;\n\n                    // exit each( stringParsers ) here because we matched\n                    return false;\n                }\n            });\n\n            // Found a stringParser that handled it\n            if (rgba.length) {\n\n                // if this came from a parsed string, force \"transparent\" when alpha is 0\n                // chrome, (and maybe others) return \"transparent\" as rgba(0,0,0,0)\n                if (rgba.join() === \"0,0,0,0\") {\n                    jQuery.extend(rgba, colors.transparent);\n                }\n                return inst;\n            }\n\n            // named colors\n            return colors[string];\n        }\n\n        color.fn = jQuery.extend(color.prototype, {\n            parse: function (red, green, blue, alpha) {\n                if (red === undefined) {\n                    this._rgba = [null, null, null, null];\n                    return this;\n                }\n                if (red.jquery || red.nodeType) {\n                    red = jQuery(red).css(green);\n                    green = undefined;\n                }\n\n                var inst = this,\n                    type = jQuery.type(red),\n                    rgba = this._rgba = [];\n\n                // more than 1 argument specified - assume ( red, green, blue, alpha )\n                if (green !== undefined) {\n                    red = [red, green, blue, alpha];\n                    type = \"array\";\n                }\n\n                if (type === \"string\") {\n                    return this.parse(stringParse(red) || colors._default);\n                }\n\n                if (type === \"array\") {\n                    each(spaces.rgba.props, function (key, prop) {\n                        rgba[prop.idx] = clamp(red[prop.idx], prop);\n                    });\n                    return this;\n                }\n\n                if (type === \"object\") {\n                    if (red instanceof color) {\n                        each(spaces, function (spaceName, space) {\n                            if (red[space.cache]) {\n                                inst[space.cache] = red[space.cache].slice();\n                            }\n                        });\n                    } else {\n                        each(spaces, function (spaceName, space) {\n                            var cache = space.cache;\n                            each(space.props, function (key, prop) {\n\n                                // if the cache doesn't exist, and we know how to convert\n                                if (!inst[cache] && space.to) {\n\n                                    // if the value was null, we don't need to copy it\n                                    // if the key was alpha, we don't need to copy it either\n                                    if (key === \"alpha\" || red[key] == null) {\n                                        return;\n                                    }\n                                    inst[cache] = space.to(inst._rgba);\n                                }\n\n                                // this is the only case where we allow nulls for ALL properties.\n                                // call clamp with alwaysAllowEmpty\n                                inst[cache][prop.idx] = clamp(red[key], prop, true);\n                            });\n\n                            // everything defined but alpha?\n                            if (inst[cache] && jQuery.inArray(null, inst[cache].slice(0, 3)) < 0) {\n                                // use the default of 1\n                                inst[cache][3] = 1;\n                                if (space.from) {\n                                    inst._rgba = space.from(inst[cache]);\n                                }\n                            }\n                        });\n                    }\n                    return this;\n                }\n            },\n            is: function (compare) {\n                var is = color(compare),\n                    same = true,\n                    inst = this;\n\n                each(spaces, function (_, space) {\n                    var localCache,\n                        isCache = is[space.cache];\n                    if (isCache) {\n                        localCache = inst[space.cache] || space.to && space.to(inst._rgba) || [];\n                        each(space.props, function (_, prop) {\n                            if (isCache[prop.idx] != null) {\n                                same = (isCache[prop.idx] === localCache[prop.idx]);\n                                return same;\n                            }\n                        });\n                    }\n                    return same;\n                });\n                return same;\n            },\n            _space: function () {\n                var used = [],\n                    inst = this;\n                each(spaces, function (spaceName, space) {\n                    if (inst[space.cache]) {\n                        used.push(spaceName);\n                    }\n                });\n                return used.pop();\n            },\n            transition: function (other, distance) {\n                var end = color(other),\n                    spaceName = end._space(),\n                    space = spaces[spaceName],\n                    startColor = this.alpha() === 0 ? color(\"transparent\") : this,\n                    start = startColor[space.cache] || space.to(startColor._rgba),\n                    result = start.slice();\n\n                end = end[space.cache];\n                each(space.props, function (key, prop) {\n                    var index = prop.idx,\n                        startValue = start[index],\n                        endValue = end[index],\n                        type = propTypes[prop.type] || {};\n\n                    // if null, don't override start value\n                    if (endValue === null) {\n                        return;\n                    }\n                    // if null - use end\n                    if (startValue === null) {\n                        result[index] = endValue;\n                    } else {\n                        if (type.mod) {\n                            if (endValue - startValue > type.mod / 2) {\n                                startValue += type.mod;\n                            } else if (startValue - endValue > type.mod / 2) {\n                                startValue -= type.mod;\n                            }\n                        }\n                        result[index] = clamp((endValue - startValue) * distance + startValue, prop);\n                    }\n                });\n                return this[spaceName](result);\n            },\n            blend: function (opaque) {\n                // if we are already opaque - return ourself\n                if (this._rgba[3] === 1) {\n                    return this;\n                }\n\n                var rgb = this._rgba.slice(),\n                    a = rgb.pop(),\n                    blend = color(opaque)._rgba;\n\n                return color(jQuery.map(rgb, function (v, i) {\n                    return (1 - a) * blend[i] + a * v;\n                }));\n            },\n            toRgbaString: function () {\n                var prefix = \"rgba(\",\n                    rgba = jQuery.map(this._rgba, function (v, i) {\n                        return v == null ? (i > 2 ? 1 : 0) : v;\n                    });\n\n                if (rgba[3] === 1) {\n                    rgba.pop();\n                    prefix = \"rgb(\";\n                }\n\n                return prefix + rgba.join() + \")\";\n            },\n            toHslaString: function () {\n                var prefix = \"hsla(\",\n                    hsla = jQuery.map(this.hsla(), function (v, i) {\n                        if (v == null) {\n                            v = i > 2 ? 1 : 0;\n                        }\n\n                        // catch 1 and 2\n                        if (i && i < 3) {\n                            v = Math.round(v * 100) + \"%\";\n                        }\n                        return v;\n                    });\n\n                if (hsla[3] === 1) {\n                    hsla.pop();\n                    prefix = \"hsl(\";\n                }\n                return prefix + hsla.join() + \")\";\n            },\n            toHexString: function (includeAlpha) {\n                var rgba = this._rgba.slice(),\n                    alpha = rgba.pop();\n\n                if (includeAlpha) {\n                    rgba.push(~~(alpha * 255));\n                }\n\n                return \"#\" + jQuery.map(rgba, function (v) {\n\n                    // default to 0 when nulls exist\n                    v = (v || 0).toString(16);\n                    return v.length === 1 ? \"0\" + v : v;\n                }).join(\"\");\n            },\n            toString: function () {\n                return this._rgba[3] === 0 ? \"transparent\" : this.toRgbaString();\n            }\n        });\n        color.fn.parse.prototype = color.fn;\n\n// hsla conversions adapted from:\n// https://code.google.com/p/maashaack/source/browse/packages/graphics/trunk/src/graphics/colors/HUE2RGB.as?r=5021\n\n        function hue2rgb(p, q, h) {\n            h = (h + 1) % 1;\n            if (h * 6 < 1) {\n                return p + (q - p) * h * 6;\n            }\n            if (h * 2 < 1) {\n                return q;\n            }\n            if (h * 3 < 2) {\n                return p + (q - p) * ((2 / 3) - h) * 6;\n            }\n            return p;\n        }\n\n        spaces.hsla.to = function (rgba) {\n            if (rgba[0] == null || rgba[1] == null || rgba[2] == null) {\n                return [null, null, null, rgba[3]];\n            }\n            var r = rgba[0] / 255,\n                g = rgba[1] / 255,\n                b = rgba[2] / 255,\n                a = rgba[3],\n                max = Math.max(r, g, b),\n                min = Math.min(r, g, b),\n                diff = max - min,\n                add = max + min,\n                l = add * 0.5,\n                h, s;\n\n            if (min === max) {\n                h = 0;\n            } else if (r === max) {\n                h = (60 * (g - b) / diff) + 360;\n            } else if (g === max) {\n                h = (60 * (b - r) / diff) + 120;\n            } else {\n                h = (60 * (r - g) / diff) + 240;\n            }\n\n            // chroma (diff) == 0 means greyscale which, by definition, saturation = 0%\n            // otherwise, saturation is based on the ratio of chroma (diff) to lightness (add)\n            if (diff === 0) {\n                s = 0;\n            } else if (l <= 0.5) {\n                s = diff / add;\n            } else {\n                s = diff / (2 - add);\n            }\n            return [Math.round(h) % 360, s, l, a == null ? 1 : a];\n        };\n\n        spaces.hsla.from = function (hsla) {\n            if (hsla[0] == null || hsla[1] == null || hsla[2] == null) {\n                return [null, null, null, hsla[3]];\n            }\n            var h = hsla[0] / 360,\n                s = hsla[1],\n                l = hsla[2],\n                a = hsla[3],\n                q = l <= 0.5 ? l * (1 + s) : l + s - l * s,\n                p = 2 * l - q;\n\n            return [\n                Math.round(hue2rgb(p, q, h + (1 / 3)) * 255),\n                Math.round(hue2rgb(p, q, h) * 255),\n                Math.round(hue2rgb(p, q, h - (1 / 3)) * 255),\n                a\n            ];\n        };\n\n\n        each(spaces, function (spaceName, space) {\n            var props = space.props,\n                cache = space.cache,\n                to = space.to,\n                from = space.from;\n\n            // makes rgba() and hsla()\n            color.fn[spaceName] = function (value) {\n\n                // generate a cache for this space if it doesn't exist\n                if (to && !this[cache]) {\n                    this[cache] = to(this._rgba);\n                }\n                if (value === undefined) {\n                    return this[cache].slice();\n                }\n\n                var ret,\n                    type = jQuery.type(value),\n                    arr = (type === \"array\" || type === \"object\") ? value : arguments,\n                    local = this[cache].slice();\n\n                each(props, function (key, prop) {\n                    var val = arr[type === \"object\" ? key : prop.idx];\n                    if (val == null) {\n                        val = local[prop.idx];\n                    }\n                    local[prop.idx] = clamp(val, prop);\n                });\n\n                if (from) {\n                    ret = color(from(local));\n                    ret[cache] = local;\n                    return ret;\n                } else {\n                    return color(local);\n                }\n            };\n\n            // makes red() green() blue() alpha() hue() saturation() lightness()\n            each(props, function (key, prop) {\n                // alpha is included in more than one space\n                if (color.fn[key]) {\n                    return;\n                }\n                color.fn[key] = function (value) {\n                    var vtype = jQuery.type(value),\n                        fn = (key === \"alpha\" ? (this._hsla ? \"hsla\" : \"rgba\") : spaceName),\n                        local = this[fn](),\n                        cur = local[prop.idx],\n                        match;\n\n                    if (vtype === \"undefined\") {\n                        return cur;\n                    }\n\n                    if (vtype === \"function\") {\n                        value = value.call(this, cur);\n                        vtype = jQuery.type(value);\n                    }\n                    if (value == null && prop.empty) {\n                        return this;\n                    }\n                    if (vtype === \"string\") {\n                        match = rplusequals.exec(value);\n                        if (match) {\n                            value = cur + parseFloat(match[2]) * (match[1] === \"+\" ? 1 : -1);\n                        }\n                    }\n                    local[prop.idx] = value;\n                    return this[fn](local);\n                };\n            });\n        });\n\n// add cssHook and .fx.step function for each named hook.\n// accept a space separated string of properties\n        color.hook = function (hook) {\n            var hooks = hook.split(\" \");\n            each(hooks, function (i, hook) {\n                jQuery.cssHooks[hook] = {\n                    set: function (elem, value) {\n                        var parsed, curElem,\n                            backgroundColor = \"\";\n\n                        if (value !== \"transparent\" && (jQuery.type(value) !== \"string\" || (parsed = stringParse(value)))) {\n                            value = color(parsed || value);\n                            if (!support.rgba && value._rgba[3] !== 1) {\n                                curElem = hook === \"backgroundColor\" ? elem.parentNode : elem;\n                                while (\n                                    (backgroundColor === \"\" || backgroundColor === \"transparent\") &&\n                                    curElem && curElem.style\n                                    ) {\n                                    try {\n                                        backgroundColor = jQuery.css(curElem, \"backgroundColor\");\n                                        curElem = curElem.parentNode;\n                                    } catch (e) {\n                                    }\n                                }\n\n                                value = value.blend(backgroundColor && backgroundColor !== \"transparent\" ?\n                                    backgroundColor :\n                                    \"_default\");\n                            }\n\n                            value = value.toRgbaString();\n                        }\n                        try {\n                            elem.style[hook] = value;\n                        } catch (e) {\n                            // wrapped to prevent IE from throwing errors on \"invalid\" values like 'auto' or 'inherit'\n                        }\n                    }\n                };\n                jQuery.fx.step[hook] = function (fx) {\n                    if (!fx.colorInit) {\n                        fx.start = color(fx.elem, hook);\n                        fx.end = color(fx.end);\n                        fx.colorInit = true;\n                    }\n                    jQuery.cssHooks[hook].set(fx.elem, fx.start.transition(fx.end, fx.pos));\n                };\n            });\n\n        };\n\n        color.hook(stepHooks);\n\n        jQuery.cssHooks.borderColor = {\n            expand: function (value) {\n                var expanded = {};\n\n                each([\"Top\", \"Right\", \"Bottom\", \"Left\"], function (i, part) {\n                    expanded[\"border\" + part + \"Color\"] = value;\n                });\n                return expanded;\n            }\n        };\n\n// Basic color names only.\n// Usage of any of the other color names requires adding yourself or including\n// jquery.color.svg-names.js.\n        colors = jQuery.Color.names = {\n            // 4.1. Basic color keywords\n            aqua: \"#00ffff\",\n            black: \"#000000\",\n            blue: \"#0000ff\",\n            fuchsia: \"#ff00ff\",\n            gray: \"#808080\",\n            green: \"#008000\",\n            lime: \"#00ff00\",\n            maroon: \"#800000\",\n            navy: \"#000080\",\n            olive: \"#808000\",\n            purple: \"#800080\",\n            red: \"#ff0000\",\n            silver: \"#c0c0c0\",\n            teal: \"#008080\",\n            white: \"#ffffff\",\n            yellow: \"#ffff00\",\n\n            // 4.2.3. \"transparent\" color keyword\n            transparent: [null, null, null, 0],\n\n            _default: \"#ffffff\"\n        };\n\n    })(jQuery);\n\n\n    /******************************************************************************/\n    /****************************** CLASS ANIMATIONS ******************************/\n    /******************************************************************************/\n    (function () {\n\n        var classAnimationActions = [\"add\", \"remove\", \"toggle\"],\n            shorthandStyles = {\n                border: 1,\n                borderBottom: 1,\n                borderColor: 1,\n                borderLeft: 1,\n                borderRight: 1,\n                borderTop: 1,\n                borderWidth: 1,\n                margin: 1,\n                padding: 1\n            };\n\n        $.each([\"borderLeftStyle\", \"borderRightStyle\", \"borderBottomStyle\", \"borderTopStyle\"], function (_, prop) {\n            $.fx.step[prop] = function (fx) {\n                if (fx.end !== \"none\" && !fx.setAttr || fx.pos === 1 && !fx.setAttr) {\n                    jQuery.style(fx.elem, prop, fx.end);\n                    fx.setAttr = true;\n                }\n            };\n        });\n\n        function getElementStyles(elem) {\n            var key, len,\n                style = elem.ownerDocument.defaultView ?\n                    elem.ownerDocument.defaultView.getComputedStyle(elem, null) :\n                    elem.currentStyle,\n                styles = {};\n\n            if (style && style.length && style[0] && style[style[0]]) {\n                len = style.length;\n                while (len--) {\n                    key = style[len];\n                    if (typeof style[key] === \"string\") {\n                        styles[$.camelCase(key)] = style[key];\n                    }\n                }\n                // support: Opera, IE <9\n            } else {\n                for (key in style) {\n                    if (typeof style[key] === \"string\") {\n                        styles[key] = style[key];\n                    }\n                }\n            }\n\n            return styles;\n        }\n\n\n        function styleDifference(oldStyle, newStyle) {\n            var diff = {},\n                name, value;\n\n            for (name in newStyle) {\n                value = newStyle[name];\n                if (oldStyle[name] !== value) {\n                    if (!shorthandStyles[name]) {\n                        if ($.fx.step[name] || !isNaN(parseFloat(value))) {\n                            diff[name] = value;\n                        }\n                    }\n                }\n            }\n\n            return diff;\n        }\n\n// support: jQuery <1.8\n        if (!$.fn.addBack) {\n            $.fn.addBack = function (selector) {\n                return this.add(selector == null ?\n                    this.prevObject : this.prevObject.filter(selector)\n                );\n            };\n        }\n\n        $.effects.animateClass = function (value, duration, easing, callback) {\n            var o = $.speed(duration, easing, callback);\n\n            return this.queue(function () {\n                var animated = $(this),\n                    baseClass = animated.attr(\"class\") || \"\",\n                    applyClassChange,\n                    allAnimations = o.children ? animated.find(\"*\").addBack() : animated;\n\n                // map the animated objects to store the original styles.\n                allAnimations = allAnimations.map(function () {\n                    var el = $(this);\n                    return {\n                        el: el,\n                        start: getElementStyles(this)\n                    };\n                });\n\n                // apply class change\n                applyClassChange = function () {\n                    $.each(classAnimationActions, function (i, action) {\n                        if (value[action]) {\n                            animated[action + \"Class\"](value[action]);\n                        }\n                    });\n                };\n                applyClassChange();\n\n                // map all animated objects again - calculate new styles and diff\n                allAnimations = allAnimations.map(function () {\n                    this.end = getElementStyles(this.el[0]);\n                    this.diff = styleDifference(this.start, this.end);\n                    return this;\n                });\n\n                // apply original class\n                animated.attr(\"class\", baseClass);\n\n                // map all animated objects again - this time collecting a promise\n                allAnimations = allAnimations.map(function () {\n                    var styleInfo = this,\n                        dfd = $.Deferred(),\n                        opts = $.extend({}, o, {\n                            queue: false,\n                            complete: function () {\n                                dfd.resolve(styleInfo);\n                            }\n                        });\n\n                    this.el.animate(this.diff, opts);\n                    return dfd.promise();\n                });\n\n                // once all animations have completed:\n                $.when.apply($, allAnimations.get()).done(function () {\n\n                    // set the final class\n                    applyClassChange();\n\n                    // for each animated element,\n                    // clear all css properties that were animated\n                    $.each(arguments, function () {\n                        var el = this.el;\n                        $.each(this.diff, function (key) {\n                            el.css(key, \"\");\n                        });\n                    });\n\n                    // this is guarnteed to be there if you use jQuery.speed()\n                    // it also handles dequeuing the next anim...\n                    o.complete.call(animated[0]);\n                });\n            });\n        };\n\n        $.fn.extend({\n            addClass: (function (orig) {\n                return function (classNames, speed, easing, callback) {\n                    return speed ?\n                        $.effects.animateClass.call(this,\n                            {add: classNames}, speed, easing, callback) :\n                        orig.apply(this, arguments);\n                };\n            })($.fn.addClass),\n\n            removeClass: (function (orig) {\n                return function (classNames, speed, easing, callback) {\n                    return arguments.length > 1 ?\n                        $.effects.animateClass.call(this,\n                            {remove: classNames}, speed, easing, callback) :\n                        orig.apply(this, arguments);\n                };\n            })($.fn.removeClass),\n\n            toggleClass: (function (orig) {\n                return function (classNames, force, speed, easing, callback) {\n                    if (typeof force === \"boolean\" || force === undefined) {\n                        if (!speed) {\n                            // without speed parameter\n                            return orig.apply(this, arguments);\n                        } else {\n                            return $.effects.animateClass.call(this,\n                                (force ? {add: classNames} : {remove: classNames}),\n                                speed, easing, callback);\n                        }\n                    } else {\n                        // without force parameter\n                        return $.effects.animateClass.call(this,\n                            {toggle: classNames}, force, speed, easing);\n                    }\n                };\n            })($.fn.toggleClass),\n\n            switchClass: function (remove, add, speed, easing, callback) {\n                return $.effects.animateClass.call(this, {\n                    add: add,\n                    remove: remove\n                }, speed, easing, callback);\n            }\n        });\n\n    })();\n\n    /******************************************************************************/\n    /*********************************** EFFECTS **********************************/\n    /******************************************************************************/\n\n    (function () {\n\n        $.extend($.effects, {\n            version: \"1.10.4\",\n\n            // Saves a set of properties in a data storage\n            save: function (element, set) {\n                for (var i = 0; i < set.length; i++) {\n                    if (set[i] !== null) {\n                        element.data(dataSpace + set[i], element[0].style[set[i]]);\n                    }\n                }\n            },\n\n            // Restores a set of previously saved properties from a data storage\n            restore: function (element, set) {\n                var val, i;\n                for (i = 0; i < set.length; i++) {\n                    if (set[i] !== null) {\n                        val = element.data(dataSpace + set[i]);\n                        // support: jQuery 1.6.2\n                        // http://bugs.jquery.com/ticket/9917\n                        // jQuery 1.6.2 incorrectly returns undefined for any falsy value.\n                        // We can't differentiate between \"\" and 0 here, so we just assume\n                        // empty string since it's likely to be a more common value...\n                        if (val === undefined) {\n                            val = \"\";\n                        }\n                        element.css(set[i], val);\n                    }\n                }\n            },\n\n            setMode: function (el, mode) {\n                if (mode === \"toggle\") {\n                    mode = el.is(\":hidden\") ? \"show\" : \"hide\";\n                }\n                return mode;\n            },\n\n            // Translates a [top,left] array into a baseline value\n            // this should be a little more flexible in the future to handle a string & hash\n            getBaseline: function (origin, original) {\n                var y, x;\n                switch (origin[0]) {\n                    case \"top\":\n                        y = 0;\n                        break;\n                    case \"middle\":\n                        y = 0.5;\n                        break;\n                    case \"bottom\":\n                        y = 1;\n                        break;\n                    default:\n                        y = origin[0] / original.height;\n                }\n                switch (origin[1]) {\n                    case \"left\":\n                        x = 0;\n                        break;\n                    case \"center\":\n                        x = 0.5;\n                        break;\n                    case \"right\":\n                        x = 1;\n                        break;\n                    default:\n                        x = origin[1] / original.width;\n                }\n                return {\n                    x: x,\n                    y: y\n                };\n            },\n\n            // Wraps the element around a wrapper that copies position properties\n            createWrapper: function (element) {\n\n                // if the element is already wrapped, return it\n                if (element.parent().is(\".ui-effects-wrapper\")) {\n                    return element.parent();\n                }\n\n                // wrap the element\n                var props = {\n                        width: element.outerWidth(true),\n                        height: element.outerHeight(true),\n                        \"float\": element.css(\"float\")\n                    },\n                    wrapper = $(\"<div></div>\")\n                        .addClass(\"ui-effects-wrapper\")\n                        .css({\n                            fontSize: \"100%\",\n                            background: \"transparent\",\n                            border: \"none\",\n                            margin: 0,\n                            padding: 0\n                        }),\n                    // Store the size in case width/height are defined in % - Fixes #5245\n                    size = {\n                        width: element.width(),\n                        height: element.height()\n                    },\n                    active = document.activeElement;\n\n                // support: Firefox\n                // Firefox incorrectly exposes anonymous content\n                // https://bugzilla.mozilla.org/show_bug.cgi?id=561664\n                try {\n                    active.id;\n                } catch (e) {\n                    active = document.body;\n                }\n\n                element.wrap(wrapper);\n\n                // Fixes #7595 - Elements lose focus when wrapped.\n                if (element[0] === active || $.contains(element[0], active)) {\n                    $(active).focus();\n                }\n\n                wrapper = element.parent(); //Hotfix for jQuery 1.4 since some change in wrap() seems to actually lose the reference to the wrapped element\n\n                // transfer positioning properties to the wrapper\n                if (element.css(\"position\") === \"static\") {\n                    wrapper.css({position: \"relative\"});\n                    element.css({position: \"relative\"});\n                } else {\n                    $.extend(props, {\n                        position: element.css(\"position\"),\n                        zIndex: element.css(\"z-index\")\n                    });\n                    $.each([\"top\", \"left\", \"bottom\", \"right\"], function (i, pos) {\n                        props[pos] = element.css(pos);\n                        if (isNaN(parseInt(props[pos], 10))) {\n                            props[pos] = \"auto\";\n                        }\n                    });\n                    element.css({\n                        position: \"relative\",\n                        top: 0,\n                        left: 0,\n                        right: \"auto\",\n                        bottom: \"auto\"\n                    });\n                }\n                element.css(size);\n\n                return wrapper.css(props).show();\n            },\n\n            removeWrapper: function (element) {\n                var active = document.activeElement;\n\n                if (element.parent().is(\".ui-effects-wrapper\")) {\n                    element.parent().replaceWith(element);\n\n                    // Fixes #7595 - Elements lose focus when wrapped.\n                    if (element[0] === active || $.contains(element[0], active)) {\n                        $(active).focus();\n                    }\n                }\n\n\n                return element;\n            },\n\n            setTransition: function (element, list, factor, value) {\n                value = value || {};\n                $.each(list, function (i, x) {\n                    var unit = element.cssUnit(x);\n                    if (unit[0] > 0) {\n                        value[x] = unit[0] * factor + unit[1];\n                    }\n                });\n                return value;\n            }\n        });\n\n// return an effect options object for the given parameters:\n        function _normalizeArguments(effect, options, speed, callback) {\n\n            // allow passing all options as the first parameter\n            if ($.isPlainObject(effect)) {\n                options = effect;\n                effect = effect.effect;\n            }\n\n            // convert to an object\n            effect = {effect: effect};\n\n            // catch (effect, null, ...)\n            if (options == null) {\n                options = {};\n            }\n\n            // catch (effect, callback)\n            if ($.isFunction(options)) {\n                callback = options;\n                speed = null;\n                options = {};\n            }\n\n            // catch (effect, speed, ?)\n            if (typeof options === \"number\" || $.fx.speeds[options]) {\n                callback = speed;\n                speed = options;\n                options = {};\n            }\n\n            // catch (effect, options, callback)\n            if ($.isFunction(speed)) {\n                callback = speed;\n                speed = null;\n            }\n\n            // add options to effect\n            if (options) {\n                $.extend(effect, options);\n            }\n\n            speed = speed || options.duration;\n            effect.duration = $.fx.off ? 0 :\n                typeof speed === \"number\" ? speed :\n                    speed in $.fx.speeds ? $.fx.speeds[speed] :\n                        $.fx.speeds._default;\n\n            effect.complete = callback || options.complete;\n\n            return effect;\n        }\n\n        function standardAnimationOption(option) {\n            // Valid standard speeds (nothing, number, named speed)\n            if (!option || typeof option === \"number\" || $.fx.speeds[option]) {\n                return true;\n            }\n\n            // Invalid strings - treat as \"normal\" speed\n            if (typeof option === \"string\" && !$.effects.effect[option]) {\n                return true;\n            }\n\n            // Complete callback\n            if ($.isFunction(option)) {\n                return true;\n            }\n\n            // Options hash (but not naming an effect)\n            if (typeof option === \"object\" && !option.effect) {\n                return true;\n            }\n\n            // Didn't match any standard API\n            return false;\n        }\n\n        $.fn.extend({\n            effect: function ( /* effect, options, speed, callback */) {\n                var args = _normalizeArguments.apply(this, arguments),\n                    mode = args.mode,\n                    queue = args.queue,\n                    effectMethod = $.effects.effect[args.effect];\n\n                if ($.fx.off || !effectMethod) {\n                    // delegate to the original method (e.g., .show()) if possible\n                    if (mode) {\n                        return this[mode](args.duration, args.complete);\n                    } else {\n                        return this.each(function () {\n                            if (args.complete) {\n                                args.complete.call(this);\n                            }\n                        });\n                    }\n                }\n\n                function run(next) {\n                    var elem = $(this),\n                        complete = args.complete,\n                        mode = args.mode;\n\n                    function done() {\n                        if ($.isFunction(complete)) {\n                            complete.call(elem[0]);\n                        }\n                        if ($.isFunction(next)) {\n                            next();\n                        }\n                    }\n\n                    // If the element already has the correct final state, delegate to\n                    // the core methods so the internal tracking of \"olddisplay\" works.\n                    if (elem.is(\":hidden\") ? mode === \"hide\" : mode === \"show\") {\n                        elem[mode]();\n                        done();\n                    } else {\n                        effectMethod.call(elem[0], args, done);\n                    }\n                }\n\n                return queue === false ? this.each(run) : this.queue(queue || \"fx\", run);\n            },\n\n            show: (function (orig) {\n                return function (option) {\n                    if (standardAnimationOption(option)) {\n                        return orig.apply(this, arguments);\n                    } else {\n                        var args = _normalizeArguments.apply(this, arguments);\n                        args.mode = \"show\";\n                        return this.effect.call(this, args);\n                    }\n                };\n            })($.fn.show),\n\n            hide: (function (orig) {\n                return function (option) {\n                    if (standardAnimationOption(option)) {\n                        return orig.apply(this, arguments);\n                    } else {\n                        var args = _normalizeArguments.apply(this, arguments);\n                        args.mode = \"hide\";\n                        return this.effect.call(this, args);\n                    }\n                };\n            })($.fn.hide),\n\n            toggle: (function (orig) {\n                return function (option) {\n                    if (standardAnimationOption(option) || typeof option === \"boolean\") {\n                        return orig.apply(this, arguments);\n                    } else {\n                        var args = _normalizeArguments.apply(this, arguments);\n                        args.mode = \"toggle\";\n                        return this.effect.call(this, args);\n                    }\n                };\n            })($.fn.toggle),\n\n            // helper functions\n            cssUnit: function (key) {\n                var style = this.css(key),\n                    val = [];\n\n                $.each([\"em\", \"px\", \"%\", \"pt\"], function (i, unit) {\n                    if (style.indexOf(unit) > 0) {\n                        val = [parseFloat(style), unit];\n                    }\n                });\n                return val;\n            }\n        });\n\n    })();\n\n    /******************************************************************************/\n    /*********************************** EASING ***********************************/\n    /******************************************************************************/\n\n    (function () {\n\n// based on easing equations from Robert Penner (http://www.robertpenner.com/easing)\n\n        var baseEasings = {};\n\n        $.each([\"Quad\", \"Cubic\", \"Quart\", \"Quint\", \"Expo\"], function (i, name) {\n            baseEasings[name] = function (p) {\n                return Math.pow(p, i + 2);\n            };\n        });\n\n        $.extend(baseEasings, {\n            Sine: function (p) {\n                return 1 - Math.cos(p * Math.PI / 2);\n            },\n            Circ: function (p) {\n                return 1 - Math.sqrt(1 - p * p);\n            },\n            Elastic: function (p) {\n                return p === 0 || p === 1 ? p :\n                    -Math.pow(2, 8 * (p - 1)) * Math.sin(((p - 1) * 80 - 7.5) * Math.PI / 15);\n            },\n            Back: function (p) {\n                return p * p * (3 * p - 2);\n            },\n            Bounce: function (p) {\n                var pow2,\n                    bounce = 4;\n\n                while (p < ((pow2 = Math.pow(2, --bounce)) - 1) / 11) {\n                }\n                return 1 / Math.pow(4, 3 - bounce) - 7.5625 * Math.pow((pow2 * 3 - 2) / 22 - p, 2);\n            }\n        });\n\n        $.each(baseEasings, function (name, easeIn) {\n            $.easing[\"easeIn\" + name] = easeIn;\n            $.easing[\"easeOut\" + name] = function (p) {\n                return 1 - easeIn(1 - p);\n            };\n            $.easing[\"easeInOut\" + name] = function (p) {\n                return p < 0.5 ?\n                    easeIn(p * 2) / 2 :\n                    1 - easeIn(p * -2 + 2) / 2;\n            };\n        });\n\n    })();\n\n});\n","jquery/ui-modules/timepicker.js":"/*! jQuery Timepicker Addon - v1.4.3 - 2013-11-30\n* http://trentrichardson.com/examples/timepicker\n* Copyright (c) 2013 Trent Richardson; Licensed MIT */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"jquery-ui-modules/datepicker\",\n            \"jquery-ui-modules/slider\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n\n    /*\n    * Lets not redefine timepicker, Prevent \"Uncaught RangeError: Maximum call stack size exceeded\"\n    */\n    $.ui.timepicker = $.ui.timepicker || {};\n    if ($.ui.timepicker.version) {\n        return;\n    }\n\n    /*\n    * Extend jQueryUI, get it started with our version number\n    */\n    $.extend($.ui, {\n        timepicker: {\n            version: \"1.4.3\"\n        }\n    });\n\n    /*\n    * Timepicker manager.\n    * Use the singleton instance of this class, $.timepicker, to interact with the time picker.\n    * Settings for (groups of) time pickers are maintained in an instance object,\n    * allowing multiple different settings on the same page.\n    */\n    var Timepicker = function () {\n        this.regional = []; // Available regional settings, indexed by language code\n        this.regional[''] = { // Default regional settings\n            currentText: 'Now',\n            closeText: 'Done',\n            amNames: ['AM', 'A'],\n            pmNames: ['PM', 'P'],\n            timeFormat: 'HH:mm',\n            timeSuffix: '',\n            timeOnlyTitle: 'Choose Time',\n            timeText: 'Time',\n            hourText: 'Hour',\n            minuteText: 'Minute',\n            secondText: 'Second',\n            millisecText: 'Millisecond',\n            microsecText: 'Microsecond',\n            timezoneText: 'Time Zone',\n            isRTL: false\n        };\n        this._defaults = { // Global defaults for all the datetime picker instances\n            showButtonPanel: true,\n            timeOnly: false,\n            showHour: null,\n            showMinute: null,\n            showSecond: null,\n            showMillisec: null,\n            showMicrosec: null,\n            showTimezone: null,\n            showTime: true,\n            stepHour: 1,\n            stepMinute: 1,\n            stepSecond: 1,\n            stepMillisec: 1,\n            stepMicrosec: 1,\n            hour: 0,\n            minute: 0,\n            second: 0,\n            millisec: 0,\n            microsec: 0,\n            timezone: null,\n            hourMin: 0,\n            minuteMin: 0,\n            secondMin: 0,\n            millisecMin: 0,\n            microsecMin: 0,\n            hourMax: 23,\n            minuteMax: 59,\n            secondMax: 59,\n            millisecMax: 999,\n            microsecMax: 999,\n            minDateTime: null,\n            maxDateTime: null,\n            onSelect: null,\n            hourGrid: 0,\n            minuteGrid: 0,\n            secondGrid: 0,\n            millisecGrid: 0,\n            microsecGrid: 0,\n            alwaysSetTime: true,\n            separator: ' ',\n            altFieldTimeOnly: true,\n            altTimeFormat: null,\n            altSeparator: null,\n            altTimeSuffix: null,\n            pickerTimeFormat: null,\n            pickerTimeSuffix: null,\n            showTimepicker: true,\n            timezoneList: null,\n            addSliderAccess: false,\n            sliderAccessArgs: null,\n            controlType: 'slider',\n            defaultValue: null,\n            parse: 'strict'\n        };\n        $.extend(this._defaults, this.regional['']);\n    };\n\n    $.extend(Timepicker.prototype, {\n        $input: null,\n        $altInput: null,\n        $timeObj: null,\n        inst: null,\n        hour_slider: null,\n        minute_slider: null,\n        second_slider: null,\n        millisec_slider: null,\n        microsec_slider: null,\n        timezone_select: null,\n        hour: 0,\n        minute: 0,\n        second: 0,\n        millisec: 0,\n        microsec: 0,\n        timezone: null,\n        hourMinOriginal: null,\n        minuteMinOriginal: null,\n        secondMinOriginal: null,\n        millisecMinOriginal: null,\n        microsecMinOriginal: null,\n        hourMaxOriginal: null,\n        minuteMaxOriginal: null,\n        secondMaxOriginal: null,\n        millisecMaxOriginal: null,\n        microsecMaxOriginal: null,\n        ampm: '',\n        formattedDate: '',\n        formattedTime: '',\n        formattedDateTime: '',\n        timezoneList: null,\n        units: ['hour', 'minute', 'second', 'millisec', 'microsec'],\n        support: {},\n        control: null,\n\n        /*\n        * Override the default settings for all instances of the time picker.\n        * @param  {Object} settings  object - the new settings to use as defaults (anonymous object)\n        * @return {Object} the manager object\n        */\n        setDefaults: function (settings) {\n            extendRemove(this._defaults, settings || {});\n            return this;\n        },\n\n        /*\n        * Create a new Timepicker instance\n        */\n        _newInst: function ($input, opts) {\n            var tp_inst = new Timepicker(),\n                inlineSettings = {},\n                fns = {},\n                overrides, i;\n\n            for (var attrName in this._defaults) {\n                if (this._defaults.hasOwnProperty(attrName)) {\n                    var attrValue = $input.attr('time:' + attrName);\n                    if (attrValue) {\n                        try {\n                            inlineSettings[attrName] = eval(attrValue);\n                        } catch (err) {\n                            inlineSettings[attrName] = attrValue;\n                        }\n                    }\n                }\n            }\n\n            overrides = {\n                beforeShow: function (input, dp_inst) {\n                    if ($.isFunction(tp_inst._defaults.evnts.beforeShow)) {\n                        return tp_inst._defaults.evnts.beforeShow.call($input[0], input, dp_inst, tp_inst);\n                    }\n                },\n                onChangeMonthYear: function (year, month, dp_inst) {\n                    // Update the time as well : this prevents the time from disappearing from the $input field.\n                    tp_inst._updateDateTime(dp_inst);\n                    if ($.isFunction(tp_inst._defaults.evnts.onChangeMonthYear)) {\n                        tp_inst._defaults.evnts.onChangeMonthYear.call($input[0], year, month, dp_inst, tp_inst);\n                    }\n                },\n                onClose: function (dateText, dp_inst) {\n                    if (tp_inst.timeDefined === true && $input.val() !== '') {\n                        tp_inst._updateDateTime(dp_inst);\n                    }\n                    if ($.isFunction(tp_inst._defaults.evnts.onClose)) {\n                        tp_inst._defaults.evnts.onClose.call($input[0], dateText, dp_inst, tp_inst);\n                    }\n                }\n            };\n            for (i in overrides) {\n                if (overrides.hasOwnProperty(i)) {\n                    fns[i] = opts[i] || null;\n                }\n            }\n\n            tp_inst._defaults = $.extend({}, this._defaults, inlineSettings, opts, overrides, {\n                evnts: fns,\n                timepicker: tp_inst // add timepicker as a property of datepicker: $.datepicker._get(dp_inst, 'timepicker');\n            });\n            tp_inst.amNames = $.map(tp_inst._defaults.amNames, function (val) {\n                return val.toUpperCase();\n            });\n            tp_inst.pmNames = $.map(tp_inst._defaults.pmNames, function (val) {\n                return val.toUpperCase();\n            });\n\n            // detect which units are supported\n            tp_inst.support = detectSupport(\n                tp_inst._defaults.timeFormat +\n                (tp_inst._defaults.pickerTimeFormat ? tp_inst._defaults.pickerTimeFormat : '') +\n                (tp_inst._defaults.altTimeFormat ? tp_inst._defaults.altTimeFormat : ''));\n\n            // controlType is string - key to our this._controls\n            if (typeof (tp_inst._defaults.controlType) === 'string') {\n                if (tp_inst._defaults.controlType === 'slider' && typeof ($.ui.slider) === 'undefined') {\n                    tp_inst._defaults.controlType = 'select';\n                }\n                tp_inst.control = tp_inst._controls[tp_inst._defaults.controlType];\n            }\n            // controlType is an object and must implement create, options, value methods\n            else {\n                tp_inst.control = tp_inst._defaults.controlType;\n            }\n\n            // prep the timezone options\n            var timezoneList = [-720, -660, -600, -570, -540, -480, -420, -360, -300, -270, -240, -210, -180, -120, -60,\n                0, 60, 120, 180, 210, 240, 270, 300, 330, 345, 360, 390, 420, 480, 525, 540, 570, 600, 630, 660, 690, 720, 765, 780, 840];\n            if (tp_inst._defaults.timezoneList !== null) {\n                timezoneList = tp_inst._defaults.timezoneList;\n            }\n            var tzl = timezoneList.length, tzi = 0, tzv = null;\n            if (tzl > 0 && typeof timezoneList[0] !== 'object') {\n                for (; tzi < tzl; tzi++) {\n                    tzv = timezoneList[tzi];\n                    timezoneList[tzi] = {\n                        value: tzv,\n                        label: $.timepicker.timezoneOffsetString(tzv, tp_inst.support.iso8601)\n                    };\n                }\n            }\n            tp_inst._defaults.timezoneList = timezoneList;\n\n            // set the default units\n            tp_inst.timezone = tp_inst._defaults.timezone !== null ? $.timepicker.timezoneOffsetNumber(tp_inst._defaults.timezone) :\n                ((new Date()).getTimezoneOffset() * -1);\n            tp_inst.hour = tp_inst._defaults.hour < tp_inst._defaults.hourMin ? tp_inst._defaults.hourMin :\n                tp_inst._defaults.hour > tp_inst._defaults.hourMax ? tp_inst._defaults.hourMax : tp_inst._defaults.hour;\n            tp_inst.minute = tp_inst._defaults.minute < tp_inst._defaults.minuteMin ? tp_inst._defaults.minuteMin :\n                tp_inst._defaults.minute > tp_inst._defaults.minuteMax ? tp_inst._defaults.minuteMax : tp_inst._defaults.minute;\n            tp_inst.second = tp_inst._defaults.second < tp_inst._defaults.secondMin ? tp_inst._defaults.secondMin :\n                tp_inst._defaults.second > tp_inst._defaults.secondMax ? tp_inst._defaults.secondMax : tp_inst._defaults.second;\n            tp_inst.millisec = tp_inst._defaults.millisec < tp_inst._defaults.millisecMin ? tp_inst._defaults.millisecMin :\n                tp_inst._defaults.millisec > tp_inst._defaults.millisecMax ? tp_inst._defaults.millisecMax : tp_inst._defaults.millisec;\n            tp_inst.microsec = tp_inst._defaults.microsec < tp_inst._defaults.microsecMin ? tp_inst._defaults.microsecMin :\n                tp_inst._defaults.microsec > tp_inst._defaults.microsecMax ? tp_inst._defaults.microsecMax : tp_inst._defaults.microsec;\n            tp_inst.ampm = '';\n            tp_inst.$input = $input;\n\n            if (tp_inst._defaults.altField) {\n                tp_inst.$altInput = $(tp_inst._defaults.altField).css({\n                    cursor: 'pointer'\n                }).focus(function () {\n                    $input.trigger(\"focus\");\n                });\n            }\n\n            if (tp_inst._defaults.minDate === 0 || tp_inst._defaults.minDateTime === 0) {\n                tp_inst._defaults.minDate = new Date();\n            }\n            if (tp_inst._defaults.maxDate === 0 || tp_inst._defaults.maxDateTime === 0) {\n                tp_inst._defaults.maxDate = new Date();\n            }\n\n            // datepicker needs minDate/maxDate, timepicker needs minDateTime/maxDateTime..\n            if (tp_inst._defaults.minDate !== undefined && tp_inst._defaults.minDate instanceof Date) {\n                tp_inst._defaults.minDateTime = new Date(tp_inst._defaults.minDate.getTime());\n            }\n            if (tp_inst._defaults.minDateTime !== undefined && tp_inst._defaults.minDateTime instanceof Date) {\n                tp_inst._defaults.minDate = new Date(tp_inst._defaults.minDateTime.getTime());\n            }\n            if (tp_inst._defaults.maxDate !== undefined && tp_inst._defaults.maxDate instanceof Date) {\n                tp_inst._defaults.maxDateTime = new Date(tp_inst._defaults.maxDate.getTime());\n            }\n            if (tp_inst._defaults.maxDateTime !== undefined && tp_inst._defaults.maxDateTime instanceof Date) {\n                tp_inst._defaults.maxDate = new Date(tp_inst._defaults.maxDateTime.getTime());\n            }\n            tp_inst.$input.bind('focus', function () {\n                tp_inst._onFocus();\n            });\n\n            return tp_inst;\n        },\n\n        /*\n        * add our sliders to the calendar\n        */\n        _addTimePicker: function (dp_inst) {\n            var currDT = (this.$altInput && this._defaults.altFieldTimeOnly) ? this.$input.val() + ' ' + this.$altInput.val() : this.$input.val();\n\n            this.timeDefined = this._parseTime(currDT);\n            this._limitMinMaxDateTime(dp_inst, false);\n            this._injectTimePicker();\n        },\n\n        /*\n        * parse the time string from input value or _setTime\n        */\n        _parseTime: function (timeString, withDate) {\n            if (!this.inst) {\n                this.inst = $.datepicker._getInst(this.$input[0]);\n            }\n\n            if (withDate || !this._defaults.timeOnly) {\n                var dp_dateFormat = $.datepicker._get(this.inst, 'dateFormat');\n                try {\n                    var parseRes = parseDateTimeInternal(dp_dateFormat, this._defaults.timeFormat, timeString, $.datepicker._getFormatConfig(this.inst), this._defaults);\n                    if (!parseRes.timeObj) {\n                        return false;\n                    }\n                    $.extend(this, parseRes.timeObj);\n                } catch (err) {\n                    $.timepicker.log(\"Error parsing the date/time string: \" + err +\n                        \"\\ndate/time string = \" + timeString +\n                        \"\\ntimeFormat = \" + this._defaults.timeFormat +\n                        \"\\ndateFormat = \" + dp_dateFormat);\n                    return false;\n                }\n                return true;\n            } else {\n                var timeObj = $.datepicker.parseTime(this._defaults.timeFormat, timeString, this._defaults);\n                if (!timeObj) {\n                    return false;\n                }\n                $.extend(this, timeObj);\n                return true;\n            }\n        },\n\n        /*\n        * generate and inject html for timepicker into ui datepicker\n        */\n        _injectTimePicker: function () {\n            var $dp = this.inst.dpDiv,\n                o = this.inst.settings,\n                tp_inst = this,\n                litem = '',\n                uitem = '',\n                show = null,\n                max = {},\n                gridSize = {},\n                size = null,\n                i = 0,\n                l = 0;\n\n            // Prevent displaying twice\n            if ($dp.find(\"div.ui-timepicker-div\").length === 0 && o.showTimepicker) {\n                var noDisplay = ' style=\"display:none;\"',\n                    html = '<div class=\"ui-timepicker-div' + (o.isRTL ? ' ui-timepicker-rtl' : '') + '\"><dl>' + '<dt class=\"ui_tpicker_time_label\"' + ((o.showTime) ? '' : noDisplay) + '>' + o.timeText + '</dt>' +\n                        '<dd class=\"ui_tpicker_time\"' + ((o.showTime) ? '' : noDisplay) + '></dd>';\n\n                // Create the markup\n                for (i = 0, l = this.units.length; i < l; i++) {\n                    litem = this.units[i];\n                    uitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n                    show = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n                    // Added by Peter Medeiros:\n                    // - Figure out what the hour/minute/second max should be based on the step values.\n                    // - Example: if stepMinute is 15, then minMax is 45.\n                    max[litem] = parseInt((o[litem + 'Max'] - ((o[litem + 'Max'] - o[litem + 'Min']) % o['step' + uitem])), 10);\n                    gridSize[litem] = 0;\n\n                    html += '<dt class=\"ui_tpicker_' + litem + '_label\"' + (show ? '' : noDisplay) + '>' + o[litem + 'Text'] + '</dt>' +\n                        '<dd class=\"ui_tpicker_' + litem + '\"><div class=\"ui_tpicker_' + litem + '_slider\"' + (show ? '' : noDisplay) + '></div>';\n\n                    if (show && o[litem + 'Grid'] > 0) {\n                        html += '<div style=\"padding-left: 1px\"><table class=\"ui-tpicker-grid-label\"><tr>';\n\n                        if (litem === 'hour') {\n                            for (var h = o[litem + 'Min']; h <= max[litem]; h += parseInt(o[litem + 'Grid'], 10)) {\n                                gridSize[litem]++;\n                                var tmph = $.datepicker.formatTime(this.support.ampm ? 'hht' : 'HH', {hour: h}, o);\n                                html += '<td data-for=\"' + litem + '\">' + tmph + '</td>';\n                            }\n                        } else {\n                            for (var m = o[litem + 'Min']; m <= max[litem]; m += parseInt(o[litem + 'Grid'], 10)) {\n                                gridSize[litem]++;\n                                html += '<td data-for=\"' + litem + '\">' + ((m < 10) ? '0' : '') + m + '</td>';\n                            }\n                        }\n\n                        html += '</tr></table></div>';\n                    }\n                    html += '</dd>';\n                }\n\n                // Timezone\n                var showTz = o.showTimezone !== null ? o.showTimezone : this.support.timezone;\n                html += '<dt class=\"ui_tpicker_timezone_label\"' + (showTz ? '' : noDisplay) + '>' + o.timezoneText + '</dt>';\n                html += '<dd class=\"ui_tpicker_timezone\" ' + (showTz ? '' : noDisplay) + '></dd>';\n\n                // Create the elements from string\n                html += '</dl></div>';\n                var $tp = $(html);\n\n                // if we only want time picker...\n                if (o.timeOnly === true) {\n                    $tp.prepend('<div class=\"ui-widget-header ui-helper-clearfix ui-corner-all\">' + '<div class=\"ui-datepicker-title\">' + o.timeOnlyTitle + '</div>' + '</div>');\n                    $dp.find('.ui-datepicker-header, .ui-datepicker-calendar').hide();\n                }\n\n                // add sliders, adjust grids, add events\n                for (i = 0, l = tp_inst.units.length; i < l; i++) {\n                    litem = tp_inst.units[i];\n                    uitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n                    show = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n                    // add the slider\n                    tp_inst[litem + '_slider'] = tp_inst.control.create(tp_inst, $tp.find('.ui_tpicker_' + litem + '_slider'), litem, tp_inst[litem], o[litem + 'Min'], max[litem], o['step' + uitem]);\n\n                    // adjust the grid and add click event\n                    if (show && o[litem + 'Grid'] > 0) {\n                        size = 100 * gridSize[litem] * o[litem + 'Grid'] / (max[litem] - o[litem + 'Min']);\n                        $tp.find('.ui_tpicker_' + litem + ' table').css({\n                            width: size + \"%\",\n                            marginLeft: o.isRTL ? '0' : ((size / (-2 * gridSize[litem])) + \"%\"),\n                            marginRight: o.isRTL ? ((size / (-2 * gridSize[litem])) + \"%\") : '0',\n                            borderCollapse: 'collapse'\n                        }).find(\"td\").click(function (e) {\n                            var $t = $(this),\n                                h = $t.html(),\n                                n = parseInt(h.replace(/[^0-9]/g), 10),\n                                ap = h.replace(/[^apm]/ig),\n                                f = $t.data('for'); // loses scope, so we use data-for\n\n                            if (f === 'hour') {\n                                if (ap.indexOf('p') !== -1 && n < 12) {\n                                    n += 12;\n                                } else {\n                                    if (ap.indexOf('a') !== -1 && n === 12) {\n                                        n = 0;\n                                    }\n                                }\n                            }\n\n                            tp_inst.control.value(tp_inst, tp_inst[f + '_slider'], litem, n);\n\n                            tp_inst._onTimeChange();\n                            tp_inst._onSelectHandler();\n                        }).css({\n                            cursor: 'pointer',\n                            width: (100 / gridSize[litem]) + '%',\n                            textAlign: 'center',\n                            overflow: 'hidden'\n                        });\n                    } // end if grid > 0\n                } // end for loop\n\n                // Add timezone options\n                this.timezone_select = $tp.find('.ui_tpicker_timezone').append('<select></select>').find(\"select\");\n                $.fn.append.apply(this.timezone_select,\n                    $.map(o.timezoneList, function (val, idx) {\n                        return $(\"<option />\").val(typeof val === \"object\" ? val.value : val).text(typeof val === \"object\" ? val.label : val);\n                    }));\n                if (typeof (this.timezone) !== \"undefined\" && this.timezone !== null && this.timezone !== \"\") {\n                    var local_timezone = (new Date(this.inst.selectedYear, this.inst.selectedMonth, this.inst.selectedDay, 12)).getTimezoneOffset() * -1;\n                    if (local_timezone === this.timezone) {\n                        selectLocalTimezone(tp_inst);\n                    } else {\n                        this.timezone_select.val(this.timezone);\n                    }\n                } else {\n                    if (typeof (this.hour) !== \"undefined\" && this.hour !== null && this.hour !== \"\") {\n                        this.timezone_select.val(o.timezone);\n                    } else {\n                        selectLocalTimezone(tp_inst);\n                    }\n                }\n                this.timezone_select.change(function () {\n                    tp_inst._onTimeChange();\n                    tp_inst._onSelectHandler();\n                });\n                // End timezone options\n\n                // inject timepicker into datepicker\n                var $buttonPanel = $dp.find('.ui-datepicker-buttonpane');\n                if ($buttonPanel.length) {\n                    $buttonPanel.before($tp);\n                } else {\n                    $dp.append($tp);\n                }\n\n                this.$timeObj = $tp.find('.ui_tpicker_time');\n\n                if (this.inst !== null) {\n                    var timeDefined = this.timeDefined;\n                    this._onTimeChange();\n                    this.timeDefined = timeDefined;\n                }\n\n                // slideAccess integration: http://trentrichardson.com/2011/11/11/jquery-ui-sliders-and-touch-accessibility/\n                if (this._defaults.addSliderAccess) {\n                    var sliderAccessArgs = this._defaults.sliderAccessArgs,\n                        rtl = this._defaults.isRTL;\n                    sliderAccessArgs.isRTL = rtl;\n\n                    setTimeout(function () { // fix for inline mode\n                        if ($tp.find('.ui-slider-access').length === 0) {\n                            $tp.find('.ui-slider:visible').sliderAccess(sliderAccessArgs);\n\n                            // fix any grids since sliders are shorter\n                            var sliderAccessWidth = $tp.find('.ui-slider-access:eq(0)').outerWidth(true);\n                            if (sliderAccessWidth) {\n                                $tp.find('table:visible').each(function () {\n                                    var $g = $(this),\n                                        oldWidth = $g.outerWidth(),\n                                        oldMarginLeft = $g.css(rtl ? 'marginRight' : 'marginLeft').toString().replace('%', ''),\n                                        newWidth = oldWidth - sliderAccessWidth,\n                                        newMarginLeft = ((oldMarginLeft * newWidth) / oldWidth) + '%',\n                                        css = {width: newWidth, marginRight: 0, marginLeft: 0};\n                                    css[rtl ? 'marginRight' : 'marginLeft'] = newMarginLeft;\n                                    $g.css(css);\n                                });\n                            }\n                        }\n                    }, 10);\n                }\n                // end slideAccess integration\n\n                tp_inst._limitMinMaxDateTime(this.inst, true);\n            }\n        },\n\n        /*\n        * This function tries to limit the ability to go outside the\n        * min/max date range\n        */\n        _limitMinMaxDateTime: function (dp_inst, adjustSliders) {\n            var o = this._defaults,\n                dp_date = new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay);\n\n            if (!this._defaults.showTimepicker) {\n                return;\n            } // No time so nothing to check here\n\n            if ($.datepicker._get(dp_inst, 'minDateTime') !== null && $.datepicker._get(dp_inst, 'minDateTime') !== undefined && dp_date) {\n                var minDateTime = $.datepicker._get(dp_inst, 'minDateTime'),\n                    minDateTimeDate = new Date(minDateTime.getFullYear(), minDateTime.getMonth(), minDateTime.getDate(), 0, 0, 0, 0);\n\n                if (this.hourMinOriginal === null || this.minuteMinOriginal === null || this.secondMinOriginal === null || this.millisecMinOriginal === null || this.microsecMinOriginal === null) {\n                    this.hourMinOriginal = o.hourMin;\n                    this.minuteMinOriginal = o.minuteMin;\n                    this.secondMinOriginal = o.secondMin;\n                    this.millisecMinOriginal = o.millisecMin;\n                    this.microsecMinOriginal = o.microsecMin;\n                }\n\n                if (dp_inst.settings.timeOnly || minDateTimeDate.getTime() === dp_date.getTime()) {\n                    this._defaults.hourMin = minDateTime.getHours();\n                    if (this.hour <= this._defaults.hourMin) {\n                        this.hour = this._defaults.hourMin;\n                        this._defaults.minuteMin = minDateTime.getMinutes();\n                        if (this.minute <= this._defaults.minuteMin) {\n                            this.minute = this._defaults.minuteMin;\n                            this._defaults.secondMin = minDateTime.getSeconds();\n                            if (this.second <= this._defaults.secondMin) {\n                                this.second = this._defaults.secondMin;\n                                this._defaults.millisecMin = minDateTime.getMilliseconds();\n                                if (this.millisec <= this._defaults.millisecMin) {\n                                    this.millisec = this._defaults.millisecMin;\n                                    this._defaults.microsecMin = minDateTime.getMicroseconds();\n                                } else {\n                                    if (this.microsec < this._defaults.microsecMin) {\n                                        this.microsec = this._defaults.microsecMin;\n                                    }\n                                    this._defaults.microsecMin = this.microsecMinOriginal;\n                                }\n                            } else {\n                                this._defaults.millisecMin = this.millisecMinOriginal;\n                                this._defaults.microsecMin = this.microsecMinOriginal;\n                            }\n                        } else {\n                            this._defaults.secondMin = this.secondMinOriginal;\n                            this._defaults.millisecMin = this.millisecMinOriginal;\n                            this._defaults.microsecMin = this.microsecMinOriginal;\n                        }\n                    } else {\n                        this._defaults.minuteMin = this.minuteMinOriginal;\n                        this._defaults.secondMin = this.secondMinOriginal;\n                        this._defaults.millisecMin = this.millisecMinOriginal;\n                        this._defaults.microsecMin = this.microsecMinOriginal;\n                    }\n                } else {\n                    this._defaults.hourMin = this.hourMinOriginal;\n                    this._defaults.minuteMin = this.minuteMinOriginal;\n                    this._defaults.secondMin = this.secondMinOriginal;\n                    this._defaults.millisecMin = this.millisecMinOriginal;\n                    this._defaults.microsecMin = this.microsecMinOriginal;\n                }\n            }\n\n            if ($.datepicker._get(dp_inst, 'maxDateTime') !== null && $.datepicker._get(dp_inst, 'maxDateTime') !== undefined && dp_date) {\n                var maxDateTime = $.datepicker._get(dp_inst, 'maxDateTime'),\n                    maxDateTimeDate = new Date(maxDateTime.getFullYear(), maxDateTime.getMonth(), maxDateTime.getDate(), 0, 0, 0, 0);\n\n                if (this.hourMaxOriginal === null || this.minuteMaxOriginal === null || this.secondMaxOriginal === null || this.millisecMaxOriginal === null) {\n                    this.hourMaxOriginal = o.hourMax;\n                    this.minuteMaxOriginal = o.minuteMax;\n                    this.secondMaxOriginal = o.secondMax;\n                    this.millisecMaxOriginal = o.millisecMax;\n                    this.microsecMaxOriginal = o.microsecMax;\n                }\n\n                if (dp_inst.settings.timeOnly || maxDateTimeDate.getTime() === dp_date.getTime()) {\n                    this._defaults.hourMax = maxDateTime.getHours();\n                    if (this.hour >= this._defaults.hourMax) {\n                        this.hour = this._defaults.hourMax;\n                        this._defaults.minuteMax = maxDateTime.getMinutes();\n                        if (this.minute >= this._defaults.minuteMax) {\n                            this.minute = this._defaults.minuteMax;\n                            this._defaults.secondMax = maxDateTime.getSeconds();\n                            if (this.second >= this._defaults.secondMax) {\n                                this.second = this._defaults.secondMax;\n                                this._defaults.millisecMax = maxDateTime.getMilliseconds();\n                                if (this.millisec >= this._defaults.millisecMax) {\n                                    this.millisec = this._defaults.millisecMax;\n                                    this._defaults.microsecMax = maxDateTime.getMicroseconds();\n                                } else {\n                                    if (this.microsec > this._defaults.microsecMax) {\n                                        this.microsec = this._defaults.microsecMax;\n                                    }\n                                    this._defaults.microsecMax = this.microsecMaxOriginal;\n                                }\n                            } else {\n                                this._defaults.millisecMax = this.millisecMaxOriginal;\n                                this._defaults.microsecMax = this.microsecMaxOriginal;\n                            }\n                        } else {\n                            this._defaults.secondMax = this.secondMaxOriginal;\n                            this._defaults.millisecMax = this.millisecMaxOriginal;\n                            this._defaults.microsecMax = this.microsecMaxOriginal;\n                        }\n                    } else {\n                        this._defaults.minuteMax = this.minuteMaxOriginal;\n                        this._defaults.secondMax = this.secondMaxOriginal;\n                        this._defaults.millisecMax = this.millisecMaxOriginal;\n                        this._defaults.microsecMax = this.microsecMaxOriginal;\n                    }\n                } else {\n                    this._defaults.hourMax = this.hourMaxOriginal;\n                    this._defaults.minuteMax = this.minuteMaxOriginal;\n                    this._defaults.secondMax = this.secondMaxOriginal;\n                    this._defaults.millisecMax = this.millisecMaxOriginal;\n                    this._defaults.microsecMax = this.microsecMaxOriginal;\n                }\n            }\n\n            if (adjustSliders !== undefined && adjustSliders === true) {\n                var hourMax = parseInt((this._defaults.hourMax - ((this._defaults.hourMax - this._defaults.hourMin) % this._defaults.stepHour)), 10),\n                    minMax = parseInt((this._defaults.minuteMax - ((this._defaults.minuteMax - this._defaults.minuteMin) % this._defaults.stepMinute)), 10),\n                    secMax = parseInt((this._defaults.secondMax - ((this._defaults.secondMax - this._defaults.secondMin) % this._defaults.stepSecond)), 10),\n                    millisecMax = parseInt((this._defaults.millisecMax - ((this._defaults.millisecMax - this._defaults.millisecMin) % this._defaults.stepMillisec)), 10),\n                    microsecMax = parseInt((this._defaults.microsecMax - ((this._defaults.microsecMax - this._defaults.microsecMin) % this._defaults.stepMicrosec)), 10);\n\n                if (this.hour_slider) {\n                    this.control.options(this, this.hour_slider, 'hour', {min: this._defaults.hourMin, max: hourMax});\n                    this.control.value(this, this.hour_slider, 'hour', this.hour - (this.hour % this._defaults.stepHour));\n                }\n                if (this.minute_slider) {\n                    this.control.options(this, this.minute_slider, 'minute', {\n                        min: this._defaults.minuteMin,\n                        max: minMax\n                    });\n                    this.control.value(this, this.minute_slider, 'minute', this.minute - (this.minute % this._defaults.stepMinute));\n                }\n                if (this.second_slider) {\n                    this.control.options(this, this.second_slider, 'second', {\n                        min: this._defaults.secondMin,\n                        max: secMax\n                    });\n                    this.control.value(this, this.second_slider, 'second', this.second - (this.second % this._defaults.stepSecond));\n                }\n                if (this.millisec_slider) {\n                    this.control.options(this, this.millisec_slider, 'millisec', {\n                        min: this._defaults.millisecMin,\n                        max: millisecMax\n                    });\n                    this.control.value(this, this.millisec_slider, 'millisec', this.millisec - (this.millisec % this._defaults.stepMillisec));\n                }\n                if (this.microsec_slider) {\n                    this.control.options(this, this.microsec_slider, 'microsec', {\n                        min: this._defaults.microsecMin,\n                        max: microsecMax\n                    });\n                    this.control.value(this, this.microsec_slider, 'microsec', this.microsec - (this.microsec % this._defaults.stepMicrosec));\n                }\n            }\n\n        },\n\n        /*\n        * when a slider moves, set the internal time...\n        * on time change is also called when the time is updated in the text field\n        */\n        _onTimeChange: function () {\n            if (!this._defaults.showTimepicker) {\n                return;\n            }\n            var hour = (this.hour_slider) ? this.control.value(this, this.hour_slider, 'hour') : false,\n                minute = (this.minute_slider) ? this.control.value(this, this.minute_slider, 'minute') : false,\n                second = (this.second_slider) ? this.control.value(this, this.second_slider, 'second') : false,\n                millisec = (this.millisec_slider) ? this.control.value(this, this.millisec_slider, 'millisec') : false,\n                microsec = (this.microsec_slider) ? this.control.value(this, this.microsec_slider, 'microsec') : false,\n                timezone = (this.timezone_select) ? this.timezone_select.val() : false,\n                o = this._defaults,\n                pickerTimeFormat = o.pickerTimeFormat || o.timeFormat,\n                pickerTimeSuffix = o.pickerTimeSuffix || o.timeSuffix;\n\n            if (typeof (hour) === 'object') {\n                hour = false;\n            }\n            if (typeof (minute) === 'object') {\n                minute = false;\n            }\n            if (typeof (second) === 'object') {\n                second = false;\n            }\n            if (typeof (millisec) === 'object') {\n                millisec = false;\n            }\n            if (typeof (microsec) === 'object') {\n                microsec = false;\n            }\n            if (typeof (timezone) === 'object') {\n                timezone = false;\n            }\n\n            if (hour !== false) {\n                hour = parseInt(hour, 10);\n            }\n            if (minute !== false) {\n                minute = parseInt(minute, 10);\n            }\n            if (second !== false) {\n                second = parseInt(second, 10);\n            }\n            if (millisec !== false) {\n                millisec = parseInt(millisec, 10);\n            }\n            if (microsec !== false) {\n                microsec = parseInt(microsec, 10);\n            }\n            if (timezone !== false) {\n                timezone = timezone.toString();\n            }\n\n            var ampm = o[hour < 12 ? 'amNames' : 'pmNames'][0];\n\n            // If the update was done in the input field, the input field should not be updated.\n            // If the update was done using the sliders, update the input field.\n            var hasChanged = (\n                hour !== parseInt(this.hour, 10) || // sliders should all be numeric\n                minute !== parseInt(this.minute, 10) ||\n                second !== parseInt(this.second, 10) ||\n                millisec !== parseInt(this.millisec, 10) ||\n                microsec !== parseInt(this.microsec, 10) ||\n                (this.ampm.length > 0 && (hour < 12) !== ($.inArray(this.ampm.toUpperCase(), this.amNames) !== -1)) ||\n                (this.timezone !== null && timezone !== this.timezone.toString()) // could be numeric or \"EST\" format, so use toString()\n            );\n\n            if (hasChanged) {\n\n                if (hour !== false) {\n                    this.hour = hour;\n                }\n                if (minute !== false) {\n                    this.minute = minute;\n                }\n                if (second !== false) {\n                    this.second = second;\n                }\n                if (millisec !== false) {\n                    this.millisec = millisec;\n                }\n                if (microsec !== false) {\n                    this.microsec = microsec;\n                }\n                if (timezone !== false) {\n                    this.timezone = timezone;\n                }\n\n                if (!this.inst) {\n                    this.inst = $.datepicker._getInst(this.$input[0]);\n                }\n\n                this._limitMinMaxDateTime(this.inst, true);\n            }\n            if (this.support.ampm) {\n                this.ampm = ampm;\n            }\n\n            // Updates the time within the timepicker\n            this.formattedTime = $.datepicker.formatTime(o.timeFormat, this, o);\n            if (this.$timeObj) {\n                if (pickerTimeFormat === o.timeFormat) {\n                    this.$timeObj.text(this.formattedTime + pickerTimeSuffix);\n                } else {\n                    this.$timeObj.text($.datepicker.formatTime(pickerTimeFormat, this, o) + pickerTimeSuffix);\n                }\n            }\n\n            this.timeDefined = true;\n            if (hasChanged) {\n                this._updateDateTime();\n                this.$input.focus();\n            }\n        },\n\n        /*\n        * call custom onSelect.\n        * bind to sliders slidestop, and grid click.\n        */\n        _onSelectHandler: function () {\n            var onSelect = this._defaults.onSelect || this.inst.settings.onSelect;\n            var inputEl = this.$input ? this.$input[0] : null;\n            if (onSelect && inputEl) {\n                onSelect.apply(inputEl, [this.formattedDateTime, this]);\n            }\n        },\n\n        /*\n        * update our input with the new date time..\n        */\n        _updateDateTime: function (dp_inst) {\n            dp_inst = this.inst || dp_inst;\n            var dtTmp = (dp_inst.currentYear > 0 ?\n                new Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay) :\n                new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n                dt = $.datepicker._daylightSavingAdjust(dtTmp),\n                //dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n                //dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay)),\n                dateFmt = $.datepicker._get(dp_inst, 'dateFormat'),\n                formatCfg = $.datepicker._getFormatConfig(dp_inst),\n                timeAvailable = dt !== null && this.timeDefined;\n            this.formattedDate = $.datepicker.formatDate(dateFmt, (dt === null ? new Date() : dt), formatCfg);\n            var formattedDateTime = this.formattedDate;\n\n            // if a slider was changed but datepicker doesn't have a value yet, set it\n            if (dp_inst.lastVal === \"\") {\n                dp_inst.currentYear = dp_inst.selectedYear;\n                dp_inst.currentMonth = dp_inst.selectedMonth;\n                dp_inst.currentDay = dp_inst.selectedDay;\n            }\n\n            /*\n            * remove following lines to force every changes in date picker to change the input value\n            * Bug descriptions: when an input field has a default value, and click on the field to pop up the date picker.\n            * If the user manually empty the value in the input field, the date picker will never change selected value.\n            */\n            //if (dp_inst.lastVal !== undefined && (dp_inst.lastVal.length > 0 && this.$input.val().length === 0)) {\n            //\treturn;\n            //}\n\n            if (this._defaults.timeOnly === true) {\n                formattedDateTime = this.formattedTime;\n            } else if (this._defaults.timeOnly !== true && (this._defaults.alwaysSetTime || timeAvailable)) {\n                formattedDateTime += this._defaults.separator + this.formattedTime + this._defaults.timeSuffix;\n            }\n\n            this.formattedDateTime = formattedDateTime;\n\n            if (!this._defaults.showTimepicker) {\n                this.$input.val(this.formattedDate);\n            } else if (this.$altInput && this._defaults.timeOnly === false && this._defaults.altFieldTimeOnly === true) {\n                this.$altInput.val(this.formattedTime);\n                this.$input.val(this.formattedDate);\n            } else if (this.$altInput) {\n                this.$input.val(formattedDateTime);\n                var altFormattedDateTime = '',\n                    altSeparator = this._defaults.altSeparator ? this._defaults.altSeparator : this._defaults.separator,\n                    altTimeSuffix = this._defaults.altTimeSuffix ? this._defaults.altTimeSuffix : this._defaults.timeSuffix;\n\n                if (!this._defaults.timeOnly) {\n                    if (this._defaults.altFormat) {\n                        altFormattedDateTime = $.datepicker.formatDate(this._defaults.altFormat, (dt === null ? new Date() : dt), formatCfg);\n                    } else {\n                        altFormattedDateTime = this.formattedDate;\n                    }\n\n                    if (altFormattedDateTime) {\n                        altFormattedDateTime += altSeparator;\n                    }\n                }\n\n                if (this._defaults.altTimeFormat) {\n                    altFormattedDateTime += $.datepicker.formatTime(this._defaults.altTimeFormat, this, this._defaults) + altTimeSuffix;\n                } else {\n                    altFormattedDateTime += this.formattedTime + altTimeSuffix;\n                }\n                this.$altInput.val(altFormattedDateTime);\n            } else {\n                this.$input.val(formattedDateTime);\n            }\n\n            this.$input.trigger(\"change\");\n        },\n\n        _onFocus: function () {\n            if (!this.$input.val() && this._defaults.defaultValue) {\n                this.$input.val(this._defaults.defaultValue);\n                var inst = $.datepicker._getInst(this.$input.get(0)),\n                    tp_inst = $.datepicker._get(inst, 'timepicker');\n                if (tp_inst) {\n                    if (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n                        try {\n                            $.datepicker._updateDatepicker(inst);\n                        } catch (err) {\n                            $.timepicker.log(err);\n                        }\n                    }\n                }\n            }\n        },\n\n        /*\n        * Small abstraction to control types\n        * We can add more, just be sure to follow the pattern: create, options, value\n        */\n        _controls: {\n            // slider methods\n            slider: {\n                create: function (tp_inst, obj, unit, val, min, max, step) {\n                    var rtl = tp_inst._defaults.isRTL; // if rtl go -60->0 instead of 0->60\n                    return obj.prop('slide', null).slider({\n                        orientation: \"horizontal\",\n                        value: rtl ? val * -1 : val,\n                        min: rtl ? max * -1 : min,\n                        max: rtl ? min * -1 : max,\n                        step: step,\n                        slide: function (event, ui) {\n                            tp_inst.control.value(tp_inst, $(this), unit, rtl ? ui.value * -1 : ui.value);\n                            tp_inst._onTimeChange();\n                        },\n                        stop: function (event, ui) {\n                            tp_inst._onSelectHandler();\n                        }\n                    });\n                },\n                options: function (tp_inst, obj, unit, opts, val) {\n                    if (tp_inst._defaults.isRTL) {\n                        if (typeof (opts) === 'string') {\n                            if (opts === 'min' || opts === 'max') {\n                                if (val !== undefined) {\n                                    return obj.slider(opts, val * -1);\n                                }\n                                return Math.abs(obj.slider(opts));\n                            }\n                            return obj.slider(opts);\n                        }\n                        var min = opts.min,\n                            max = opts.max;\n                        opts.min = opts.max = null;\n                        if (min !== undefined) {\n                            opts.max = min * -1;\n                        }\n                        if (max !== undefined) {\n                            opts.min = max * -1;\n                        }\n                        return obj.slider(opts);\n                    }\n                    if (typeof (opts) === 'string' && val !== undefined) {\n                        return obj.slider(opts, val);\n                    }\n                    return obj.slider(opts);\n                },\n                value: function (tp_inst, obj, unit, val) {\n                    if (tp_inst._defaults.isRTL) {\n                        if (val !== undefined) {\n                            return obj.slider('value', val * -1);\n                        }\n                        return Math.abs(obj.slider('value'));\n                    }\n                    if (val !== undefined) {\n                        return obj.slider('value', val);\n                    }\n                    return obj.slider('value');\n                }\n            },\n            // select methods\n            select: {\n                create: function (tp_inst, obj, unit, val, min, max, step) {\n                    var sel = '<select class=\"ui-timepicker-select\" data-unit=\"' + unit + '\" data-min=\"' + min + '\" data-max=\"' + max + '\" data-step=\"' + step + '\">',\n                        format = tp_inst._defaults.pickerTimeFormat || tp_inst._defaults.timeFormat;\n\n                    for (var i = min; i <= max; i += step) {\n                        sel += '<option value=\"' + i + '\"' + (i === val ? ' selected' : '') + '>';\n                        if (unit === 'hour') {\n                            sel += $.datepicker.formatTime($.trim(format.replace(/[^ht ]/ig, '')), {hour: i}, tp_inst._defaults);\n                        } else if (unit === 'millisec' || unit === 'microsec' || i >= 10) {\n                            sel += i;\n                        } else {\n                            sel += '0' + i.toString();\n                        }\n                        sel += '</option>';\n                    }\n                    sel += '</select>';\n\n                    obj.children('select').remove();\n\n                    $(sel).appendTo(obj).change(function (e) {\n                        tp_inst._onTimeChange();\n                        tp_inst._onSelectHandler();\n                    });\n\n                    return obj;\n                },\n                options: function (tp_inst, obj, unit, opts, val) {\n                    var o = {},\n                        $t = obj.children('select');\n                    if (typeof (opts) === 'string') {\n                        if (val === undefined) {\n                            return $t.data(opts);\n                        }\n                        o[opts] = val;\n                    } else {\n                        o = opts;\n                    }\n                    return tp_inst.control.create(tp_inst, obj, $t.data('unit'), $t.val(), o.min || $t.data('min'), o.max || $t.data('max'), o.step || $t.data('step'));\n                },\n                value: function (tp_inst, obj, unit, val) {\n                    var $t = obj.children('select');\n                    if (val !== undefined) {\n                        return $t.val(val);\n                    }\n                    return $t.val();\n                }\n            }\n        } // end _controls\n\n    });\n\n    $.fn.extend({\n        /*\n        * shorthand just to use timepicker.\n        */\n        timepicker: function (o) {\n            o = o || {};\n            var tmp_args = Array.prototype.slice.call(arguments);\n\n            if (typeof o === 'object') {\n                tmp_args[0] = $.extend(o, {\n                    timeOnly: true\n                });\n            }\n\n            return $(this).each(function () {\n                $.fn.datetimepicker.apply($(this), tmp_args);\n            });\n        },\n\n        /*\n        * extend timepicker to datepicker\n        */\n        datetimepicker: function (o) {\n            o = o || {};\n            var tmp_args = arguments;\n\n            if (typeof (o) === 'string') {\n                if (o === 'getDate') {\n                    return $.fn.datepicker.apply($(this[0]), tmp_args);\n                } else {\n                    return this.each(function () {\n                        var $t = $(this);\n                        $t.datepicker.apply($t, tmp_args);\n                    });\n                }\n            } else {\n                return this.each(function () {\n                    var $t = $(this);\n                    $t.datepicker($.timepicker._newInst($t, o)._defaults);\n                });\n            }\n        }\n    });\n\n    /*\n    * Public Utility to parse date and time\n    */\n    $.datepicker.parseDateTime = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n        var parseRes = parseDateTimeInternal(dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings);\n        if (parseRes.timeObj) {\n            var t = parseRes.timeObj;\n            parseRes.date.setHours(t.hour, t.minute, t.second, t.millisec);\n            parseRes.date.setMicroseconds(t.microsec);\n        }\n\n        return parseRes.date;\n    };\n\n    /*\n    * Public utility to parse time\n    */\n    $.datepicker.parseTime = function (timeFormat, timeString, options) {\n        var o = extendRemove(extendRemove({}, $.timepicker._defaults), options || {}),\n            iso8601 = (timeFormat.replace(/\\'.*?\\'/g, '').indexOf('Z') !== -1);\n\n        // Strict parse requires the timeString to match the timeFormat exactly\n        var strictParse = function (f, s, o) {\n\n            // pattern for standard and localized AM/PM markers\n            var getPatternAmpm = function (amNames, pmNames) {\n                var markers = [];\n                if (amNames) {\n                    $.merge(markers, amNames);\n                }\n                if (pmNames) {\n                    $.merge(markers, pmNames);\n                }\n                markers = $.map(markers, function (val) {\n                    return val.replace(/[.*+?|()\\[\\]{}\\\\]/g, '\\\\$&');\n                });\n                return '(' + markers.join('|') + ')?';\n            };\n\n            // figure out position of time elements.. cause js cant do named captures\n            var getFormatPositions = function (timeFormat) {\n                var finds = timeFormat.toLowerCase().match(/(h{1,2}|m{1,2}|s{1,2}|l{1}|c{1}|t{1,2}|z|'.*?')/g),\n                    orders = {\n                        h: -1,\n                        m: -1,\n                        s: -1,\n                        l: -1,\n                        c: -1,\n                        t: -1,\n                        z: -1\n                    };\n\n                if (finds) {\n                    for (var i = 0; i < finds.length; i++) {\n                        if (orders[finds[i].toString().charAt(0)] === -1) {\n                            orders[finds[i].toString().charAt(0)] = i + 1;\n                        }\n                    }\n                }\n                return orders;\n            };\n\n            var regstr = '^' + f.toString()\n                    .replace(/([hH]{1,2}|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n                        var ml = match.length;\n                        switch (match.charAt(0).toLowerCase()) {\n                            case 'h':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 'm':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 's':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 'l':\n                                return '(\\\\d?\\\\d?\\\\d)';\n                            case 'c':\n                                return '(\\\\d?\\\\d?\\\\d)';\n                            case 'z':\n                                return '(z|[-+]\\\\d\\\\d:?\\\\d\\\\d|\\\\S+)?';\n                            case 't':\n                                return getPatternAmpm(o.amNames, o.pmNames);\n                            default:    // literal escaped in quotes\n                                return '(' + match.replace(/\\'/g, \"\").replace(/(\\.|\\$|\\^|\\\\|\\/|\\(|\\)|\\[|\\]|\\?|\\+|\\*)/g, function (m) {\n                                    return \"\\\\\" + m;\n                                }) + ')?';\n                        }\n                    })\n                    .replace(/\\s/g, '\\\\s?') +\n                o.timeSuffix + '$',\n                order = getFormatPositions(f),\n                ampm = '',\n                treg;\n\n            treg = s.match(new RegExp(regstr, 'i'));\n\n            var resTime = {\n                hour: 0,\n                minute: 0,\n                second: 0,\n                millisec: 0,\n                microsec: 0\n            };\n\n            if (treg) {\n                if (order.t !== -1) {\n                    if (treg[order.t] === undefined || treg[order.t].length === 0) {\n                        ampm = '';\n                        resTime.ampm = '';\n                    } else {\n                        ampm = $.inArray(treg[order.t].toUpperCase(), o.amNames) !== -1 ? 'AM' : 'PM';\n                        resTime.ampm = o[ampm === 'AM' ? 'amNames' : 'pmNames'][0];\n                    }\n                }\n\n                if (order.h !== -1) {\n                    if (ampm === 'AM' && treg[order.h] === '12') {\n                        resTime.hour = 0; // 12am = 0 hour\n                    } else {\n                        if (ampm === 'PM' && treg[order.h] !== '12') {\n                            resTime.hour = parseInt(treg[order.h], 10) + 12; // 12pm = 12 hour, any other pm = hour + 12\n                        } else {\n                            resTime.hour = Number(treg[order.h]);\n                        }\n                    }\n                }\n\n                if (order.m !== -1) {\n                    resTime.minute = Number(treg[order.m]);\n                }\n                if (order.s !== -1) {\n                    resTime.second = Number(treg[order.s]);\n                }\n                if (order.l !== -1) {\n                    resTime.millisec = Number(treg[order.l]);\n                }\n                if (order.c !== -1) {\n                    resTime.microsec = Number(treg[order.c]);\n                }\n                if (order.z !== -1 && treg[order.z] !== undefined) {\n                    resTime.timezone = $.timepicker.timezoneOffsetNumber(treg[order.z]);\n                }\n\n\n                return resTime;\n            }\n            return false;\n        };// end strictParse\n\n        // First try JS Date, if that fails, use strictParse\n        var looseParse = function (f, s, o) {\n            try {\n                var d = new Date('2012-01-01 ' + s);\n                if (isNaN(d.getTime())) {\n                    d = new Date('2012-01-01T' + s);\n                    if (isNaN(d.getTime())) {\n                        d = new Date('01/01/2012 ' + s);\n                        if (isNaN(d.getTime())) {\n                            throw \"Unable to parse time with native Date: \" + s;\n                        }\n                    }\n                }\n\n                return {\n                    hour: d.getHours(),\n                    minute: d.getMinutes(),\n                    second: d.getSeconds(),\n                    millisec: d.getMilliseconds(),\n                    microsec: d.getMicroseconds(),\n                    timezone: d.getTimezoneOffset() * -1\n                };\n            } catch (err) {\n                try {\n                    return strictParse(f, s, o);\n                } catch (err2) {\n                    $.timepicker.log(\"Unable to parse \\ntimeString: \" + s + \"\\ntimeFormat: \" + f);\n                }\n            }\n            return false;\n        }; // end looseParse\n\n        if (typeof o.parse === \"function\") {\n            return o.parse(timeFormat, timeString, o);\n        }\n        if (o.parse === 'loose') {\n            return looseParse(timeFormat, timeString, o);\n        }\n        return strictParse(timeFormat, timeString, o);\n    };\n\n    /**\n     * Public utility to format the time\n     * @param {string} format format of the time\n     * @param {Object} time Object not a Date for timezones\n     * @param {Object} [options] essentially the regional[].. amNames, pmNames, ampm\n     * @returns {string} the formatted time\n     */\n    $.datepicker.formatTime = function (format, time, options) {\n        options = options || {};\n        options = $.extend({}, $.timepicker._defaults, options);\n        time = $.extend({\n            hour: 0,\n            minute: 0,\n            second: 0,\n            millisec: 0,\n            microsec: 0,\n            timezone: null\n        }, time);\n\n        var tmptime = format,\n            ampmName = options.amNames[0],\n            hour = parseInt(time.hour, 10);\n\n        if (hour > 11) {\n            ampmName = options.pmNames[0];\n        }\n\n        tmptime = tmptime.replace(/(?:HH?|hh?|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n            switch (match) {\n                case 'HH':\n                    return ('0' + hour).slice(-2);\n                case 'H':\n                    return hour;\n                case 'hh':\n                    return ('0' + convert24to12(hour)).slice(-2);\n                case 'h':\n                    return convert24to12(hour);\n                case 'mm':\n                    return ('0' + time.minute).slice(-2);\n                case 'm':\n                    return time.minute;\n                case 'ss':\n                    return ('0' + time.second).slice(-2);\n                case 's':\n                    return time.second;\n                case 'l':\n                    return ('00' + time.millisec).slice(-3);\n                case 'c':\n                    return ('00' + time.microsec).slice(-3);\n                case 'z':\n                    return $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, false);\n                case 'Z':\n                    return $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, true);\n                case 'T':\n                    return ampmName.charAt(0).toUpperCase();\n                case 'TT':\n                    return ampmName.toUpperCase();\n                case 't':\n                    return ampmName.charAt(0).toLowerCase();\n                case 'tt':\n                    return ampmName.toLowerCase();\n                default:\n                    return match.replace(/'/g, \"\");\n            }\n        });\n\n        return tmptime;\n    };\n\n    /*\n    * the bad hack :/ override datepicker so it doesn't close on select\n    // inspired: http://stackoverflow.com/questions/1252512/jquery-datepicker-prevent-closing-picker-when-clicking-a-date/1762378#1762378\n    */\n    $.datepicker._base_selectDate = $.datepicker._selectDate;\n    $.datepicker._selectDate = function (id, dateStr) {\n        var inst = this._getInst($(id)[0]),\n            tp_inst = this._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            tp_inst._limitMinMaxDateTime(inst, true);\n            inst.inline = inst.stay_open = true;\n            //This way the onSelect handler called from calendarpicker get the full dateTime\n            this._base_selectDate(id, dateStr);\n            inst.inline = inst.stay_open = false;\n            this._notifyChange(inst);\n            this._updateDatepicker(inst);\n        } else {\n            this._base_selectDate(id, dateStr);\n        }\n    };\n\n    /*\n    * second bad hack :/ override datepicker so it triggers an event when changing the input field\n    * and does not redraw the datepicker on every selectDate event\n    */\n    $.datepicker._base_updateDatepicker = $.datepicker._updateDatepicker;\n    $.datepicker._updateDatepicker = function (inst) {\n\n        // don't popup the datepicker if there is another instance already opened\n        var input = inst.input[0];\n        if ($.datepicker._curInst && $.datepicker._curInst !== inst && $.datepicker._datepickerShowing && $.datepicker._lastInput !== input) {\n            return;\n        }\n\n        if (typeof (inst.stay_open) !== 'boolean' || inst.stay_open === false) {\n\n            this._base_updateDatepicker(inst);\n\n            // Reload the time control when changing something in the input text field.\n            var tp_inst = this._get(inst, 'timepicker');\n            if (tp_inst) {\n                tp_inst._addTimePicker(inst);\n            }\n        }\n    };\n\n    /*\n    * third bad hack :/ override datepicker so it allows spaces and colon in the input field\n    */\n    $.datepicker._base_doKeyPress = $.datepicker._doKeyPress;\n    $.datepicker._doKeyPress = function (event) {\n        var inst = $.datepicker._getInst(event.target),\n            tp_inst = $.datepicker._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            if ($.datepicker._get(inst, 'constrainInput')) {\n                var ampm = tp_inst.support.ampm,\n                    tz = tp_inst._defaults.showTimezone !== null ? tp_inst._defaults.showTimezone : tp_inst.support.timezone,\n                    dateChars = $.datepicker._possibleChars($.datepicker._get(inst, 'dateFormat')),\n                    datetimeChars = tp_inst._defaults.timeFormat.toString()\n                            .replace(/[hms]/g, '')\n                            .replace(/TT/g, ampm ? 'APM' : '')\n                            .replace(/Tt/g, ampm ? 'AaPpMm' : '')\n                            .replace(/tT/g, ampm ? 'AaPpMm' : '')\n                            .replace(/T/g, ampm ? 'AP' : '')\n                            .replace(/tt/g, ampm ? 'apm' : '')\n                            .replace(/t/g, ampm ? 'ap' : '') +\n                        \" \" + tp_inst._defaults.separator +\n                        tp_inst._defaults.timeSuffix +\n                        (tz ? tp_inst._defaults.timezoneList.join('') : '') +\n                        (tp_inst._defaults.amNames.join('')) + (tp_inst._defaults.pmNames.join('')) +\n                        dateChars,\n                    chr = String.fromCharCode(event.charCode === undefined ? event.keyCode : event.charCode);\n                return event.ctrlKey || (chr < ' ' || !dateChars || datetimeChars.indexOf(chr) > -1);\n            }\n        }\n\n        return $.datepicker._base_doKeyPress(event);\n    };\n\n    /*\n    * Fourth bad hack :/ override _updateAlternate function used in inline mode to init altField\n    * Update any alternate field to synchronise with the main field.\n    */\n    $.datepicker._base_updateAlternate = $.datepicker._updateAlternate;\n    $.datepicker._updateAlternate = function (inst) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var altField = tp_inst._defaults.altField;\n            if (altField) { // update alternate field too\n                var altFormat = tp_inst._defaults.altFormat || tp_inst._defaults.dateFormat,\n                    date = this._getDate(inst),\n                    formatCfg = $.datepicker._getFormatConfig(inst),\n                    altFormattedDateTime = '',\n                    altSeparator = tp_inst._defaults.altSeparator ? tp_inst._defaults.altSeparator : tp_inst._defaults.separator,\n                    altTimeSuffix = tp_inst._defaults.altTimeSuffix ? tp_inst._defaults.altTimeSuffix : tp_inst._defaults.timeSuffix,\n                    altTimeFormat = tp_inst._defaults.altTimeFormat !== null ? tp_inst._defaults.altTimeFormat : tp_inst._defaults.timeFormat;\n\n                altFormattedDateTime += $.datepicker.formatTime(altTimeFormat, tp_inst, tp_inst._defaults) + altTimeSuffix;\n                if (!tp_inst._defaults.timeOnly && !tp_inst._defaults.altFieldTimeOnly && date !== null) {\n                    if (tp_inst._defaults.altFormat) {\n                        altFormattedDateTime = $.datepicker.formatDate(tp_inst._defaults.altFormat, date, formatCfg) + altSeparator + altFormattedDateTime;\n                    } else {\n                        altFormattedDateTime = tp_inst.formattedDate + altSeparator + altFormattedDateTime;\n                    }\n                }\n                $(altField).val(altFormattedDateTime);\n            }\n        } else {\n            $.datepicker._base_updateAlternate(inst);\n        }\n    };\n\n    /*\n    * Override key up event to sync manual input changes.\n    */\n    $.datepicker._base_doKeyUp = $.datepicker._doKeyUp;\n    $.datepicker._doKeyUp = function (event) {\n        var inst = $.datepicker._getInst(event.target),\n            tp_inst = $.datepicker._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            if (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n                try {\n                    $.datepicker._updateDatepicker(inst);\n                } catch (err) {\n                    $.timepicker.log(err);\n                }\n            }\n        }\n\n        return $.datepicker._base_doKeyUp(event);\n    };\n\n    /*\n    * override \"Today\" button to also grab the time.\n    */\n    $.datepicker._base_gotoToday = $.datepicker._gotoToday;\n    $.datepicker._gotoToday = function (id) {\n        var inst = this._getInst($(id)[0]),\n            $dp = inst.dpDiv;\n        this._base_gotoToday(id);\n        var tp_inst = this._get(inst, 'timepicker');\n        selectLocalTimezone(tp_inst);\n        var now = new Date();\n        this._setTime(inst, now);\n        $('.ui-datepicker-today', $dp).click();\n    };\n\n    /*\n    * Disable & enable the Time in the datetimepicker\n    */\n    $.datepicker._disableTimepickerDatepicker = function (target) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        $(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n        if (tp_inst) {\n            inst.settings.showTimepicker = false;\n            tp_inst._defaults.showTimepicker = false;\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    $.datepicker._enableTimepickerDatepicker = function (target) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        $(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n        if (tp_inst) {\n            inst.settings.showTimepicker = true;\n            tp_inst._defaults.showTimepicker = true;\n            tp_inst._addTimePicker(inst); // Could be disabled on page load\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    /*\n    * Create our own set time function\n    */\n    $.datepicker._setTime = function (inst, date) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var defaults = tp_inst._defaults;\n\n            // calling _setTime with no date sets time to defaults\n            tp_inst.hour = date ? date.getHours() : defaults.hour;\n            tp_inst.minute = date ? date.getMinutes() : defaults.minute;\n            tp_inst.second = date ? date.getSeconds() : defaults.second;\n            tp_inst.millisec = date ? date.getMilliseconds() : defaults.millisec;\n            tp_inst.microsec = date ? date.getMicroseconds() : defaults.microsec;\n\n            //check if within min/max times..\n            tp_inst._limitMinMaxDateTime(inst, true);\n\n            tp_inst._onTimeChange();\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    /*\n    * Create new public method to set only time, callable as $().datepicker('setTime', date)\n    */\n    $.datepicker._setTimeDatepicker = function (target, date, withDate) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            this._setDateFromField(inst);\n            var tp_date;\n            if (date) {\n                if (typeof date === \"string\") {\n                    tp_inst._parseTime(date, withDate);\n                    tp_date = new Date();\n                    tp_date.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n                    tp_date.setMicroseconds(tp_inst.microsec);\n                } else {\n                    tp_date = new Date(date.getTime());\n                    tp_date.setMicroseconds(date.getMicroseconds());\n                }\n                if (tp_date.toString() === 'Invalid Date') {\n                    tp_date = undefined;\n                }\n                this._setTime(inst, tp_date);\n            }\n        }\n\n    };\n\n    /*\n    * override setDate() to allow setting time too within Date object\n    */\n    $.datepicker._base_setDateDatepicker = $.datepicker._setDateDatepicker;\n    $.datepicker._setDateDatepicker = function (target, date) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        if (typeof (date) === 'string') {\n            date = new Date(date);\n            if (!date.getTime()) {\n                $.timepicker.log(\"Error creating Date object from string.\");\n            }\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        var tp_date;\n        if (date instanceof Date) {\n            tp_date = new Date(date.getTime());\n            tp_date.setMicroseconds(date.getMicroseconds());\n        } else {\n            tp_date = date;\n        }\n\n        // This is important if you are using the timezone option, javascript's Date\n        // object will only return the timezone offset for the current locale, so we\n        // adjust it accordingly.  If not using timezone option this won't matter..\n        // If a timezone is different in tp, keep the timezone as is\n        if (tp_inst && tp_date) {\n            // look out for DST if tz wasn't specified\n            if (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n                tp_inst.timezone = tp_date.getTimezoneOffset() * -1;\n            }\n            date = $.timepicker.timezoneAdjust(date, tp_inst.timezone);\n            tp_date = $.timepicker.timezoneAdjust(tp_date, tp_inst.timezone);\n        }\n\n        this._updateDatepicker(inst);\n        this._base_setDateDatepicker.apply(this, arguments);\n        this._setTimeDatepicker(target, tp_date, true);\n    };\n\n    /*\n    * override getDate() to allow getting time too within Date object\n    */\n    $.datepicker._base_getDateDatepicker = $.datepicker._getDateDatepicker;\n    $.datepicker._getDateDatepicker = function (target, noDefault) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            // if it hasn't yet been defined, grab from field\n            if (inst.lastVal === undefined) {\n                this._setDateFromField(inst, noDefault);\n            }\n\n            var date = this._getDate(inst);\n            if (date && tp_inst._parseTime($(target).val(), tp_inst.timeOnly)) {\n                date.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n                date.setMicroseconds(tp_inst.microsec);\n\n                // This is important if you are using the timezone option, javascript's Date\n                // object will only return the timezone offset for the current locale, so we\n                // adjust it accordingly.  If not using timezone option this won't matter..\n                if (tp_inst.timezone != null) {\n                    // look out for DST if tz wasn't specified\n                    if (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n                        tp_inst.timezone = date.getTimezoneOffset() * -1;\n                    }\n                    date = $.timepicker.timezoneAdjust(date, tp_inst.timezone);\n                }\n            }\n            return date;\n        }\n        return this._base_getDateDatepicker(target, noDefault);\n    };\n\n    /*\n    * override parseDate() because UI 1.8.14 throws an error about \"Extra characters\"\n    * An option in datapicker to ignore extra format characters would be nicer.\n    */\n    $.datepicker._base_parseDate = $.datepicker.parseDate;\n    $.datepicker.parseDate = function (format, value, settings) {\n        var date;\n        try {\n            date = this._base_parseDate(format, value, settings);\n        } catch (err) {\n            // Hack!  The error message ends with a colon, a space, and\n            // the \"extra\" characters.  We rely on that instead of\n            // attempting to perfectly reproduce the parsing algorithm.\n            if (err.indexOf(\":\") >= 0) {\n                date = this._base_parseDate(format, value.substring(0, value.length - (err.length - err.indexOf(':') - 2)), settings);\n                $.timepicker.log(\"Error parsing the date string: \" + err + \"\\ndate string = \" + value + \"\\ndate format = \" + format);\n            } else {\n                throw err;\n            }\n        }\n        return date;\n    };\n\n    /*\n    * override formatDate to set date with time to the input\n    */\n    $.datepicker._base_formatDate = $.datepicker._formatDate;\n    $.datepicker._formatDate = function (inst, day, month, year) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            tp_inst._updateDateTime(inst);\n            return tp_inst.$input.val();\n        }\n        return this._base_formatDate(inst);\n    };\n\n    /*\n    * override options setter to add time to maxDate(Time) and minDate(Time). MaxDate\n    */\n    $.datepicker._base_optionDatepicker = $.datepicker._optionDatepicker;\n    $.datepicker._optionDatepicker = function (target, name, value) {\n        var inst = this._getInst(target),\n            name_clone;\n        if (!inst) {\n            return null;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var min = null,\n                max = null,\n                onselect = null,\n                overrides = tp_inst._defaults.evnts,\n                fns = {},\n                prop;\n            if (typeof name === 'string') { // if min/max was set with the string\n                if (name === 'minDate' || name === 'minDateTime') {\n                    min = value;\n                } else if (name === 'maxDate' || name === 'maxDateTime') {\n                    max = value;\n                } else if (name === 'onSelect') {\n                    onselect = value;\n                } else if (overrides.hasOwnProperty(name)) {\n                    if (typeof (value) === 'undefined') {\n                        return overrides[name];\n                    }\n                    fns[name] = value;\n                    name_clone = {}; //empty results in exiting function after overrides updated\n                }\n            } else if (typeof name === 'object') { //if min/max was set with the JSON\n                if (name.minDate) {\n                    min = name.minDate;\n                } else if (name.minDateTime) {\n                    min = name.minDateTime;\n                } else if (name.maxDate) {\n                    max = name.maxDate;\n                } else if (name.maxDateTime) {\n                    max = name.maxDateTime;\n                }\n                for (prop in overrides) {\n                    if (overrides.hasOwnProperty(prop) && name[prop]) {\n                        fns[prop] = name[prop];\n                    }\n                }\n            }\n            for (prop in fns) {\n                if (fns.hasOwnProperty(prop)) {\n                    overrides[prop] = fns[prop];\n                    if (!name_clone) {\n                        name_clone = $.extend({}, name);\n                    }\n                    delete name_clone[prop];\n                }\n            }\n            if (name_clone && isEmptyObject(name_clone)) {\n                return;\n            }\n            if (min) { //if min was set\n                if (min === 0) {\n                    min = new Date();\n                } else {\n                    min = new Date(min);\n                }\n                tp_inst._defaults.minDate = min;\n                tp_inst._defaults.minDateTime = min;\n            } else if (max) { //if max was set\n                if (max === 0) {\n                    max = new Date();\n                } else {\n                    max = new Date(max);\n                }\n                tp_inst._defaults.maxDate = max;\n                tp_inst._defaults.maxDateTime = max;\n            } else if (onselect) {\n                tp_inst._defaults.onSelect = onselect;\n            }\n        }\n        if (value === undefined) {\n            return this._base_optionDatepicker.call($.datepicker, target, name);\n        }\n        return this._base_optionDatepicker.call($.datepicker, target, name_clone || name, value);\n    };\n\n    /*\n    * jQuery isEmptyObject does not check hasOwnProperty - if someone has added to the object prototype,\n    * it will return false for all objects\n    */\n    var isEmptyObject = function (obj) {\n        var prop;\n        for (prop in obj) {\n            if (obj.hasOwnProperty(prop)) {\n                return false;\n            }\n        }\n        return true;\n    };\n\n    /*\n    * jQuery extend now ignores nulls!\n    */\n    var extendRemove = function (target, props) {\n        $.extend(target, props);\n        for (var name in props) {\n            if (props[name] === null || props[name] === undefined) {\n                target[name] = props[name];\n            }\n        }\n        return target;\n    };\n\n    /*\n    * Determine by the time format which units are supported\n    * Returns an object of booleans for each unit\n    */\n    var detectSupport = function (timeFormat) {\n        var tf = timeFormat.replace(/'.*?'/g, '').toLowerCase(), // removes literals\n            isIn = function (f, t) { // does the format contain the token?\n                return f.indexOf(t) !== -1 ? true : false;\n            };\n        return {\n            hour: isIn(tf, 'h'),\n            minute: isIn(tf, 'm'),\n            second: isIn(tf, 's'),\n            millisec: isIn(tf, 'l'),\n            microsec: isIn(tf, 'c'),\n            timezone: isIn(tf, 'z'),\n            ampm: isIn(tf, 't') && isIn(timeFormat, 'h'),\n            iso8601: isIn(timeFormat, 'Z')\n        };\n    };\n\n    /*\n    * Converts 24 hour format into 12 hour\n    * Returns 12 hour without leading 0\n    */\n    var convert24to12 = function (hour) {\n        hour %= 12;\n\n        if (hour === 0) {\n            hour = 12;\n        }\n\n        return String(hour);\n    };\n\n    var computeEffectiveSetting = function (settings, property) {\n        return settings && settings[property] ? settings[property] : $.timepicker._defaults[property];\n    };\n\n    /*\n    * Splits datetime string into date and time substrings.\n    * Throws exception when date can't be parsed\n    * Returns {dateString: dateString, timeString: timeString}\n    */\n    var splitDateTime = function (dateTimeString, timeSettings) {\n        // The idea is to get the number separator occurrences in datetime and the time format requested (since time has\n        // fewer unknowns, mostly numbers and am/pm). We will use the time pattern to split.\n        var separator = computeEffectiveSetting(timeSettings, 'separator'),\n            format = computeEffectiveSetting(timeSettings, 'timeFormat'),\n            timeParts = format.split(separator), // how many occurrences of separator may be in our format?\n            timePartsLen = timeParts.length,\n            allParts = dateTimeString.split(separator),\n            allPartsLen = allParts.length;\n\n        if (allPartsLen > 1) {\n            return {\n                dateString: allParts.splice(0, allPartsLen - timePartsLen).join(separator),\n                timeString: allParts.splice(0, timePartsLen).join(separator)\n            };\n        }\n\n        return {\n            dateString: dateTimeString,\n            timeString: ''\n        };\n    };\n\n    /*\n    * Internal function to parse datetime interval\n    * Returns: {date: Date, timeObj: Object}, where\n    *   date - parsed date without time (type Date)\n    *   timeObj = {hour: , minute: , second: , millisec: , microsec: } - parsed time. Optional\n    */\n    var parseDateTimeInternal = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n        var date,\n            parts,\n            parsedTime;\n\n        parts = splitDateTime(dateTimeString, timeSettings);\n        date = $.datepicker._base_parseDate(dateFormat, parts.dateString, dateSettings);\n\n        if (parts.timeString === '') {\n            return {\n                date: date\n            };\n        }\n\n        parsedTime = $.datepicker.parseTime(timeFormat, parts.timeString, timeSettings);\n\n        if (!parsedTime) {\n            throw 'Wrong time format';\n        }\n\n        return {\n            date: date,\n            timeObj: parsedTime\n        };\n    };\n\n    /*\n    * Internal function to set timezone_select to the local timezone\n    */\n    var selectLocalTimezone = function (tp_inst, date) {\n        if (tp_inst && tp_inst.timezone_select) {\n            var now = date || new Date();\n            tp_inst.timezone_select.val(-now.getTimezoneOffset());\n        }\n    };\n\n    /*\n    * Create a Singleton Instance\n    */\n    $.timepicker = new Timepicker();\n\n    /**\n     * Get the timezone offset as string from a date object (eg '+0530' for UTC+5.5)\n     * @param {number} tzMinutes if not a number, less than -720 (-1200), or greater than 840 (+1400) this value is returned\n     * @param {boolean} iso8601 if true formats in accordance to iso8601 \"+12:45\"\n     * @return {string}\n     */\n    $.timepicker.timezoneOffsetString = function (tzMinutes, iso8601) {\n        if (isNaN(tzMinutes) || tzMinutes > 840 || tzMinutes < -720) {\n            return tzMinutes;\n        }\n\n        var off = tzMinutes,\n            minutes = off % 60,\n            hours = (off - minutes) / 60,\n            iso = iso8601 ? ':' : '',\n            tz = (off >= 0 ? '+' : '-') + ('0' + Math.abs(hours)).slice(-2) + iso + ('0' + Math.abs(minutes)).slice(-2);\n\n        if (tz === '+00:00') {\n            return 'Z';\n        }\n        return tz;\n    };\n\n    /**\n     * Get the number in minutes that represents a timezone string\n     * @param  {string} tzString formatted like \"+0500\", \"-1245\", \"Z\"\n     * @return {number} the offset minutes or the original string if it doesn't match expectations\n     */\n    $.timepicker.timezoneOffsetNumber = function (tzString) {\n        var normalized = tzString.toString().replace(':', ''); // excuse any iso8601, end up with \"+1245\"\n\n        if (normalized.toUpperCase() === 'Z') { // if iso8601 with Z, its 0 minute offset\n            return 0;\n        }\n\n        if (!/^(\\-|\\+)\\d{4}$/.test(normalized)) { // possibly a user defined tz, so just give it back\n            return tzString;\n        }\n\n        return ((normalized.substr(0, 1) === '-' ? -1 : 1) * // plus or minus\n            ((parseInt(normalized.substr(1, 2), 10) * 60) + // hours (converted to minutes)\n                parseInt(normalized.substr(3, 2), 10))); // minutes\n    };\n\n    /**\n     * No way to set timezone in js Date, so we must adjust the minutes to compensate. (think setDate, getDate)\n     * @param  {Date} date\n     * @param  {string} toTimezone formatted like \"+0500\", \"-1245\"\n     * @return {Date}\n     */\n    $.timepicker.timezoneAdjust = function (date, toTimezone) {\n        var toTz = $.timepicker.timezoneOffsetNumber(toTimezone);\n        if (!isNaN(toTz)) {\n            date.setMinutes(date.getMinutes() + -date.getTimezoneOffset() - toTz);\n        }\n        return date;\n    };\n\n    /**\n     * Calls `timepicker()` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * n.b. The input value must be correctly formatted (reformatting is not supported)\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the timepicker() call\n     * @return {jQuery}\n     */\n    $.timepicker.timeRange = function (startTime, endTime, options) {\n        return $.timepicker.handleRange('timepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `datetimepicker` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @param  {string} method Can be used to specify the type of picker to be added\n     * @return {jQuery}\n     */\n    $.timepicker.datetimeRange = function (startTime, endTime, options) {\n        $.timepicker.handleRange('datetimepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `datepicker` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @return {jQuery}\n     */\n    $.timepicker.dateRange = function (startTime, endTime, options) {\n        $.timepicker.handleRange('datepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `method` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {string} method Can be used to specify the type of picker to be added\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @return {jQuery}\n     */\n    $.timepicker.handleRange = function (method, startTime, endTime, options) {\n        options = $.extend({}, {\n            minInterval: 0, // min allowed interval in milliseconds\n            maxInterval: 0, // max allowed interval in milliseconds\n            start: {},      // options for start picker\n            end: {}         // options for end picker\n        }, options);\n\n        function checkDates(changed, other) {\n            var startdt = startTime[method]('getDate'),\n                enddt = endTime[method]('getDate'),\n                changeddt = changed[method]('getDate');\n\n            if (startdt !== null) {\n                var minDate = new Date(startdt.getTime()),\n                    maxDate = new Date(startdt.getTime());\n\n                minDate.setMilliseconds(minDate.getMilliseconds() + options.minInterval);\n                maxDate.setMilliseconds(maxDate.getMilliseconds() + options.maxInterval);\n\n                if (options.minInterval > 0 && minDate > enddt) { // minInterval check\n                    endTime[method]('setDate', minDate);\n                } else if (options.maxInterval > 0 && maxDate < enddt) { // max interval check\n                    endTime[method]('setDate', maxDate);\n                } else if (startdt > enddt) {\n                    other[method]('setDate', changeddt);\n                }\n            }\n        }\n\n        function selected(changed, other, option) {\n            if (!changed.val()) {\n                return;\n            }\n            var date = changed[method].call(changed, 'getDate');\n            if (date !== null && options.minInterval > 0) {\n                if (option === 'minDate') {\n                    date.setMilliseconds(date.getMilliseconds() + options.minInterval);\n                }\n                if (option === 'maxDate') {\n                    date.setMilliseconds(date.getMilliseconds() - options.minInterval);\n                }\n            }\n            if (date.getTime) {\n                other[method].call(other, 'option', option, date);\n            }\n        }\n\n        $.fn[method].call(startTime, $.extend({\n            onClose: function (dateText, inst) {\n                checkDates($(this), endTime);\n            },\n            onSelect: function (selectedDateTime) {\n                selected($(this), endTime, 'minDate');\n            }\n        }, options, options.start));\n        $.fn[method].call(endTime, $.extend({\n            onClose: function (dateText, inst) {\n                checkDates($(this), startTime);\n            },\n            onSelect: function (selectedDateTime) {\n                selected($(this), startTime, 'maxDate');\n            }\n        }, options, options.end));\n\n        checkDates(startTime, endTime);\n        selected(startTime, endTime, 'minDate');\n        selected(endTime, startTime, 'maxDate');\n        return $([startTime.get(0), endTime.get(0)]);\n    };\n\n    /**\n     * Log error or data to the console during error or debugging\n     * @param  {Object} err pass any type object to log to the console during error or debugging\n     * @return {void}\n     */\n    $.timepicker.log = function (err) {\n        if (window.console) {\n            window.console.log(err);\n        }\n    };\n\n    /*\n     * Add util object to allow access to private methods for testability.\n     */\n    $.timepicker._util = {\n        _extendRemove: extendRemove,\n        _isEmptyObject: isEmptyObject,\n        _convert24to12: convert24to12,\n        _detectSupport: detectSupport,\n        _selectLocalTimezone: selectLocalTimezone,\n        _computeEffectiveSetting: computeEffectiveSetting,\n        _splitDateTime: splitDateTime,\n        _parseDateTimeInternal: parseDateTimeInternal\n    };\n\n    /*\n    * Microsecond support\n    */\n    if (!Date.prototype.getMicroseconds) {\n        Date.prototype.microseconds = 0;\n        Date.prototype.getMicroseconds = function () {\n            return this.microseconds;\n        };\n        Date.prototype.setMicroseconds = function (m) {\n            this.setMilliseconds(this.getMilliseconds() + Math.floor(m / 1000));\n            this.microseconds = m % 1000;\n            return this;\n        };\n    }\n\n    /*\n    * Keep up with the version\n    */\n    $.timepicker.version = \"1.4.3\";\n\n}));\n","jquery/ui-modules/tooltip.js":"/*!\n * jQuery UI Tooltip - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/tooltip/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/widget',\n    'jquery-ui-modules/position'\n], function ($) {\n\n    var increments = 0;\n\n    function addDescribedBy(elem, id) {\n        var describedby = (elem.attr(\"aria-describedby\") || \"\").split(/\\s+/);\n        describedby.push(id);\n        elem\n            .data(\"ui-tooltip-id\", id)\n            .attr(\"aria-describedby\", $.trim(describedby.join(\" \")));\n    }\n\n    function removeDescribedBy(elem) {\n        var id = elem.data(\"ui-tooltip-id\"),\n            describedby = (elem.attr(\"aria-describedby\") || \"\").split(/\\s+/),\n            index = $.inArray(id, describedby);\n        if (index !== -1) {\n            describedby.splice(index, 1);\n        }\n\n        elem.removeData(\"ui-tooltip-id\");\n        describedby = $.trim(describedby.join(\" \"));\n        if (describedby) {\n            elem.attr(\"aria-describedby\", describedby);\n        } else {\n            elem.removeAttr(\"aria-describedby\");\n        }\n    }\n\n    $.widget(\"ui.tooltip\", {\n        version: \"1.10.4\",\n        options: {\n            content: function () {\n                // support: IE<9, Opera in jQuery <1.7\n                // .text() can't accept undefined, so coerce to a string\n                var title = $(this).attr(\"title\") || \"\";\n                // Escape title, since we're going from an attribute to raw HTML\n                return $(\"<a>\").text(title).html();\n            },\n            hide: true,\n            // Disabled elements have inconsistent behavior across browsers (#8661)\n            items: \"[title]:not([disabled])\",\n            position: {\n                my: \"left top+15\",\n                at: \"left bottom\",\n                collision: \"flipfit flip\"\n            },\n            show: true,\n            tooltipClass: null,\n            track: false,\n\n            // callbacks\n            close: null,\n            open: null\n        },\n\n        _create: function () {\n            this._on({\n                mouseover: \"open\",\n                focusin: \"open\"\n            });\n\n            // IDs of generated tooltips, needed for destroy\n            this.tooltips = {};\n            // IDs of parent tooltips where we removed the title attribute\n            this.parents = {};\n\n            if (this.options.disabled) {\n                this._disable();\n            }\n        },\n\n        _setOption: function (key, value) {\n            var that = this;\n\n            if (key === \"disabled\") {\n                this[value ? \"_disable\" : \"_enable\"]();\n                this.options[key] = value;\n                // disable element style changes\n                return;\n            }\n\n            this._super(key, value);\n\n            if (key === \"content\") {\n                $.each(this.tooltips, function (id, element) {\n                    that._updateContent(element);\n                });\n            }\n        },\n\n        _disable: function () {\n            var that = this;\n\n            // close open tooltips\n            $.each(this.tooltips, function (id, element) {\n                var event = $.Event(\"blur\");\n                event.target = event.currentTarget = element[0];\n                that.close(event, true);\n            });\n\n            // remove title attributes to prevent native tooltips\n            this.element.find(this.options.items).addBack().each(function () {\n                var element = $(this);\n                if (element.is(\"[title]\")) {\n                    element\n                        .data(\"ui-tooltip-title\", element.attr(\"title\"))\n                        .attr(\"title\", \"\");\n                }\n            });\n        },\n\n        _enable: function () {\n            // restore title attributes\n            this.element.find(this.options.items).addBack().each(function () {\n                var element = $(this);\n                if (element.data(\"ui-tooltip-title\")) {\n                    element.attr(\"title\", element.data(\"ui-tooltip-title\"));\n                }\n            });\n        },\n\n        open: function (event) {\n            var that = this,\n                target = $(event ? event.target : this.element)\n                // we need closest here due to mouseover bubbling,\n                // but always pointing at the same event target\n                    .closest(this.options.items);\n\n            // No element to show a tooltip for or the tooltip is already open\n            if (!target.length || target.data(\"ui-tooltip-id\")) {\n                return;\n            }\n\n            if (target.attr(\"title\")) {\n                target.data(\"ui-tooltip-title\", target.attr(\"title\"));\n            }\n\n            target.data(\"ui-tooltip-open\", true);\n\n            // kill parent tooltips, custom or native, for hover\n            if (event && event.type === \"mouseover\") {\n                target.parents().each(function () {\n                    var parent = $(this),\n                        blurEvent;\n                    if (parent.data(\"ui-tooltip-open\")) {\n                        blurEvent = $.Event(\"blur\");\n                        blurEvent.target = blurEvent.currentTarget = this;\n                        that.close(blurEvent, true);\n                    }\n                    if (parent.attr(\"title\")) {\n                        parent.uniqueId();\n                        that.parents[this.id] = {\n                            element: this,\n                            title: parent.attr(\"title\")\n                        };\n                        parent.attr(\"title\", \"\");\n                    }\n                });\n            }\n\n            this._updateContent(target, event);\n        },\n\n        _updateContent: function (target, event) {\n            var content,\n                contentOption = this.options.content,\n                that = this,\n                eventType = event ? event.type : null;\n\n            if (typeof contentOption === \"string\") {\n                return this._open(event, target, contentOption);\n            }\n\n            content = contentOption.call(target[0], function (response) {\n                // ignore async response if tooltip was closed already\n                if (!target.data(\"ui-tooltip-open\")) {\n                    return;\n                }\n                // IE may instantly serve a cached response for ajax requests\n                // delay this call to _open so the other call to _open runs first\n                that._delay(function () {\n                    // jQuery creates a special event for focusin when it doesn't\n                    // exist natively. To improve performance, the native event\n                    // object is reused and the type is changed. Therefore, we can't\n                    // rely on the type being correct after the event finished\n                    // bubbling, so we set it back to the previous value. (#8740)\n                    if (event) {\n                        event.type = eventType;\n                    }\n                    this._open(event, target, response);\n                });\n            });\n            if (content) {\n                this._open(event, target, content);\n            }\n        },\n\n        _open: function (event, target, content) {\n            var tooltip, events, delayedShow,\n                positionOption = $.extend({}, this.options.position);\n\n            if (!content) {\n                return;\n            }\n\n            // Content can be updated multiple times. If the tooltip already\n            // exists, then just update the content and bail.\n            tooltip = this._find(target);\n            if (tooltip.length) {\n                tooltip.find(\".ui-tooltip-content\").html(content);\n                return;\n            }\n\n            // if we have a title, clear it to prevent the native tooltip\n            // we have to check first to avoid defining a title if none exists\n            // (we don't want to cause an element to start matching [title])\n            //\n            // We use removeAttr only for key events, to allow IE to export the correct\n            // accessible attributes. For mouse events, set to empty string to avoid\n            // native tooltip showing up (happens only when removing inside mouseover).\n            if (target.is(\"[title]\")) {\n                if (event && event.type === \"mouseover\") {\n                    target.attr(\"title\", \"\");\n                } else {\n                    target.removeAttr(\"title\");\n                }\n            }\n\n            tooltip = this._tooltip(target);\n            addDescribedBy(target, tooltip.attr(\"id\"));\n            tooltip.find(\".ui-tooltip-content\").html(content);\n\n            function position(event) {\n                positionOption.of = event;\n                if (tooltip.is(\":hidden\")) {\n                    return;\n                }\n                tooltip.position(positionOption);\n            }\n\n            if (this.options.track && event && /^mouse/.test(event.type)) {\n                this._on(this.document, {\n                    mousemove: position\n                });\n                // trigger once to override element-relative positioning\n                position(event);\n            } else {\n                tooltip.position($.extend({\n                    of: target\n                }, this.options.position));\n            }\n\n            tooltip.hide();\n\n            this._show(tooltip, this.options.show);\n            // Handle tracking tooltips that are shown with a delay (#8644). As soon\n            // as the tooltip is visible, position the tooltip using the most recent\n            // event.\n            if (this.options.show && this.options.show.delay) {\n                delayedShow = this.delayedShow = setInterval(function () {\n                    if (tooltip.is(\":visible\")) {\n                        position(positionOption.of);\n                        clearInterval(delayedShow);\n                    }\n                }, $.fx.interval);\n            }\n\n            this._trigger(\"open\", event, {tooltip: tooltip});\n\n            events = {\n                keyup: function (event) {\n                    if (event.keyCode === $.ui.keyCode.ESCAPE) {\n                        var fakeEvent = $.Event(event);\n                        fakeEvent.currentTarget = target[0];\n                        this.close(fakeEvent, true);\n                    }\n                },\n                remove: function () {\n                    this._removeTooltip(tooltip);\n                }\n            };\n            if (!event || event.type === \"mouseover\") {\n                events.mouseleave = \"close\";\n            }\n            if (!event || event.type === \"focusin\") {\n                events.focusout = \"close\";\n            }\n            this._on(true, target, events);\n        },\n\n        close: function (event) {\n            var that = this,\n                target = $(event ? event.currentTarget : this.element),\n                tooltip = this._find(target);\n\n            // disabling closes the tooltip, so we need to track when we're closing\n            // to avoid an infinite loop in case the tooltip becomes disabled on close\n            if (this.closing) {\n                return;\n            }\n\n            // Clear the interval for delayed tracking tooltips\n            clearInterval(this.delayedShow);\n\n            // only set title if we had one before (see comment in _open())\n            if (target.data(\"ui-tooltip-title\")) {\n                target.attr(\"title\", target.data(\"ui-tooltip-title\"));\n            }\n\n            removeDescribedBy(target);\n\n            tooltip.stop(true);\n            this._hide(tooltip, this.options.hide, function () {\n                that._removeTooltip($(this));\n            });\n\n            target.removeData(\"ui-tooltip-open\");\n            this._off(target, \"mouseleave focusout keyup\");\n            // Remove 'remove' binding only on delegated targets\n            if (target[0] !== this.element[0]) {\n                this._off(target, \"remove\");\n            }\n            this._off(this.document, \"mousemove\");\n\n            if (event && event.type === \"mouseleave\") {\n                $.each(this.parents, function (id, parent) {\n                    $(parent.element).attr(\"title\", parent.title);\n                    delete that.parents[id];\n                });\n            }\n\n            this.closing = true;\n            this._trigger(\"close\", event, {tooltip: tooltip});\n            this.closing = false;\n        },\n\n        _tooltip: function (element) {\n            var id = \"ui-tooltip-\" + increments++,\n                tooltip = $(\"<div>\")\n                    .attr({\n                        id: id,\n                        role: \"tooltip\"\n                    })\n                    .addClass(\"ui-tooltip ui-widget ui-corner-all ui-widget-content \" +\n                        (this.options.tooltipClass || \"\"));\n            $(\"<div>\")\n                .addClass(\"ui-tooltip-content\")\n                .appendTo(tooltip);\n            tooltip.appendTo(this.document[0].body);\n            this.tooltips[id] = element;\n            return tooltip;\n        },\n\n        _find: function (target) {\n            var id = target.data(\"ui-tooltip-id\");\n            return id ? $(\"#\" + id) : $();\n        },\n\n        _removeTooltip: function (tooltip) {\n            tooltip.remove();\n            delete this.tooltips[tooltip.attr(\"id\")];\n        },\n\n        _destroy: function () {\n            var that = this;\n\n            // close open tooltips\n            $.each(this.tooltips, function (id, element) {\n                // Delegate to close method to handle common cleanup\n                var event = $.Event(\"blur\");\n                event.target = event.currentTarget = element[0];\n                that.close(event, true);\n\n                // Remove immediately; destroying an open tooltip doesn't use the\n                // hide animation\n                $(\"#\" + id).remove();\n\n                // Restore the title\n                if (element.data(\"ui-tooltip-title\")) {\n                    element.attr(\"title\", element.data(\"ui-tooltip-title\"));\n                    element.removeData(\"ui-tooltip-title\");\n                }\n            });\n        }\n    });\n\n});\n","jquery/ui-modules/droppable.js":"/*!\n * jQuery UI Droppable - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/droppable/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/draggable'\n], function ($, undefined) {\n\n    function isOverAxis(x, reference, size) {\n        return (x > reference) && (x < (reference + size));\n    }\n\n    $.widget(\"ui.droppable\", {\n        version: \"1.10.4\",\n        widgetEventPrefix: \"drop\",\n        options: {\n            accept: \"*\",\n            activeClass: false,\n            addClasses: true,\n            greedy: false,\n            hoverClass: false,\n            scope: \"default\",\n            tolerance: \"intersect\",\n\n            // callbacks\n            activate: null,\n            deactivate: null,\n            drop: null,\n            out: null,\n            over: null\n        },\n        _create: function () {\n\n            var proportions,\n                o = this.options,\n                accept = o.accept;\n\n            this.isover = false;\n            this.isout = true;\n\n            this.accept = $.isFunction(accept) ? accept : function (d) {\n                return d.is(accept);\n            };\n\n            this.proportions = function ( /* valueToWrite */) {\n                if (arguments.length) {\n                    // Store the droppable's proportions\n                    proportions = arguments[0];\n                } else {\n                    // Retrieve or derive the droppable's proportions\n                    return proportions ?\n                        proportions :\n                        proportions = {\n                            width: this.element[0].offsetWidth,\n                            height: this.element[0].offsetHeight\n                        };\n                }\n            };\n\n            // Add the reference and positions to the manager\n            $.ui.ddmanager.droppables[o.scope] = $.ui.ddmanager.droppables[o.scope] || [];\n            $.ui.ddmanager.droppables[o.scope].push(this);\n\n            (o.addClasses && this.element.addClass(\"ui-droppable\"));\n\n        },\n\n        _destroy: function () {\n            var i = 0,\n                drop = $.ui.ddmanager.droppables[this.options.scope];\n\n            for (; i < drop.length; i++) {\n                if (drop[i] === this) {\n                    drop.splice(i, 1);\n                }\n            }\n\n            this.element.removeClass(\"ui-droppable ui-droppable-disabled\");\n        },\n\n        _setOption: function (key, value) {\n\n            if (key === \"accept\") {\n                this.accept = $.isFunction(value) ? value : function (d) {\n                    return d.is(value);\n                };\n            }\n            $.Widget.prototype._setOption.apply(this, arguments);\n        },\n\n        _activate: function (event) {\n            var draggable = $.ui.ddmanager.current;\n            if (this.options.activeClass) {\n                this.element.addClass(this.options.activeClass);\n            }\n            if (draggable) {\n                this._trigger(\"activate\", event, this.ui(draggable));\n            }\n        },\n\n        _deactivate: function (event) {\n            var draggable = $.ui.ddmanager.current;\n            if (this.options.activeClass) {\n                this.element.removeClass(this.options.activeClass);\n            }\n            if (draggable) {\n                this._trigger(\"deactivate\", event, this.ui(draggable));\n            }\n        },\n\n        _over: function (event) {\n\n            var draggable = $.ui.ddmanager.current;\n\n            // Bail if draggable and droppable are same element\n            if (!draggable || (draggable.currentItem || draggable.element)[0] === this.element[0]) {\n                return;\n            }\n\n            if (this.accept.call(this.element[0], (draggable.currentItem || draggable.element))) {\n                if (this.options.hoverClass) {\n                    this.element.addClass(this.options.hoverClass);\n                }\n                this._trigger(\"over\", event, this.ui(draggable));\n            }\n\n        },\n\n        _out: function (event) {\n\n            var draggable = $.ui.ddmanager.current;\n\n            // Bail if draggable and droppable are same element\n            if (!draggable || (draggable.currentItem || draggable.element)[0] === this.element[0]) {\n                return;\n            }\n\n            if (this.accept.call(this.element[0], (draggable.currentItem || draggable.element))) {\n                if (this.options.hoverClass) {\n                    this.element.removeClass(this.options.hoverClass);\n                }\n                this._trigger(\"out\", event, this.ui(draggable));\n            }\n\n        },\n\n        _drop: function (event, custom) {\n\n            var draggable = custom || $.ui.ddmanager.current,\n                childrenIntersection = false;\n\n            // Bail if draggable and droppable are same element\n            if (!draggable || (draggable.currentItem || draggable.element)[0] === this.element[0]) {\n                return false;\n            }\n\n            this.element.find(\":data(ui-droppable)\").not(\".ui-draggable-dragging\").each(function () {\n                var inst = $.data(this, \"ui-droppable\");\n                if (\n                    inst.options.greedy &&\n                    !inst.options.disabled &&\n                    inst.options.scope === draggable.options.scope &&\n                    inst.accept.call(inst.element[0], (draggable.currentItem || draggable.element)) &&\n                    $.ui.intersect(draggable, $.extend(inst, {offset: inst.element.offset()}), inst.options.tolerance)\n                ) {\n                    childrenIntersection = true;\n                    return false;\n                }\n            });\n            if (childrenIntersection) {\n                return false;\n            }\n\n            if (this.accept.call(this.element[0], (draggable.currentItem || draggable.element))) {\n                if (this.options.activeClass) {\n                    this.element.removeClass(this.options.activeClass);\n                }\n                if (this.options.hoverClass) {\n                    this.element.removeClass(this.options.hoverClass);\n                }\n                this._trigger(\"drop\", event, this.ui(draggable));\n                return this.element;\n            }\n\n            return false;\n\n        },\n\n        ui: function (c) {\n            return {\n                draggable: (c.currentItem || c.element),\n                helper: c.helper,\n                position: c.position,\n                offset: c.positionAbs\n            };\n        }\n\n    });\n\n    $.ui.intersect = function (draggable, droppable, toleranceMode) {\n\n        if (!droppable.offset) {\n            return false;\n        }\n\n        var draggableLeft, draggableTop,\n            x1 = (draggable.positionAbs || draggable.position.absolute).left,\n            y1 = (draggable.positionAbs || draggable.position.absolute).top,\n            x2 = x1 + draggable.helperProportions.width,\n            y2 = y1 + draggable.helperProportions.height,\n            l = droppable.offset.left,\n            t = droppable.offset.top,\n            r = l + droppable.proportions().width,\n            b = t + droppable.proportions().height;\n\n        switch (toleranceMode) {\n            case \"fit\":\n                return (l <= x1 && x2 <= r && t <= y1 && y2 <= b);\n            case \"intersect\":\n                return (l < x1 + (draggable.helperProportions.width / 2) && // Right Half\n                    x2 - (draggable.helperProportions.width / 2) < r && // Left Half\n                    t < y1 + (draggable.helperProportions.height / 2) && // Bottom Half\n                    y2 - (draggable.helperProportions.height / 2) < b); // Top Half\n            case \"pointer\":\n                draggableLeft = ((draggable.positionAbs || draggable.position.absolute).left + (draggable.clickOffset || draggable.offset.click).left);\n                draggableTop = ((draggable.positionAbs || draggable.position.absolute).top + (draggable.clickOffset || draggable.offset.click).top);\n                return isOverAxis(draggableTop, t, droppable.proportions().height) && isOverAxis(draggableLeft, l, droppable.proportions().width);\n            case \"touch\":\n                return (\n                    (y1 >= t && y1 <= b) ||\t// Top edge touching\n                    (y2 >= t && y2 <= b) ||\t// Bottom edge touching\n                    (y1 < t && y2 > b)\t\t// Surrounded vertically\n                ) && (\n                    (x1 >= l && x1 <= r) ||\t// Left edge touching\n                    (x2 >= l && x2 <= r) ||\t// Right edge touching\n                    (x1 < l && x2 > r)\t\t// Surrounded horizontally\n                );\n            default:\n                return false;\n        }\n\n    };\n\n    /*\n        This manager tracks offsets of draggables and droppables\n    */\n    $.ui.ddmanager = {\n        current: null,\n        droppables: {\"default\": []},\n        prepareOffsets: function (t, event) {\n\n            var i, j,\n                m = $.ui.ddmanager.droppables[t.options.scope] || [],\n                type = event ? event.type : null, // workaround for #2317\n                list = (t.currentItem || t.element).find(\":data(ui-droppable)\").addBack();\n\n            droppablesLoop: for (i = 0; i < m.length; i++) {\n\n                //No disabled and non-accepted\n                if (m[i].options.disabled || (t && !m[i].accept.call(m[i].element[0], (t.currentItem || t.element)))) {\n                    continue;\n                }\n\n                // Filter out elements in the current dragged item\n                for (j = 0; j < list.length; j++) {\n                    if (list[j] === m[i].element[0]) {\n                        m[i].proportions().height = 0;\n                        continue droppablesLoop;\n                    }\n                }\n\n                m[i].visible = m[i].element.css(\"display\") !== \"none\";\n                if (!m[i].visible) {\n                    continue;\n                }\n\n                //Activate the droppable if used directly from draggables\n                if (type === \"mousedown\") {\n                    m[i]._activate.call(m[i], event);\n                }\n\n                m[i].offset = m[i].element.offset();\n                m[i].proportions({width: m[i].element[0].offsetWidth, height: m[i].element[0].offsetHeight});\n\n            }\n\n        },\n        drop: function (draggable, event) {\n\n            var dropped = false;\n            // Create a copy of the droppables in case the list changes during the drop (#9116)\n            $.each(($.ui.ddmanager.droppables[draggable.options.scope] || []).slice(), function () {\n\n                if (!this.options) {\n                    return;\n                }\n                if (!this.options.disabled && this.visible && $.ui.intersect(draggable, this, this.options.tolerance)) {\n                    dropped = this._drop.call(this, event) || dropped;\n                }\n\n                if (!this.options.disabled && this.visible && this.accept.call(this.element[0], (draggable.currentItem || draggable.element))) {\n                    this.isout = true;\n                    this.isover = false;\n                    this._deactivate.call(this, event);\n                }\n\n            });\n            return dropped;\n\n        },\n        dragStart: function (draggable, event) {\n            //Listen for scrolling so that if the dragging causes scrolling the position of the droppables can be recalculated (see #5003)\n            draggable.element.parentsUntil(\"body\").bind(\"scroll.droppable\", function () {\n                if (!draggable.options.refreshPositions) {\n                    $.ui.ddmanager.prepareOffsets(draggable, event);\n                }\n            });\n        },\n        drag: function (draggable, event) {\n\n            //If you have a highly dynamic page, you might try this option. It renders positions every time you move the mouse.\n            if (draggable.options.refreshPositions) {\n                $.ui.ddmanager.prepareOffsets(draggable, event);\n            }\n\n            //Run through all droppables and check their positions based on specific tolerance options\n            $.each($.ui.ddmanager.droppables[draggable.options.scope] || [], function () {\n\n                if (this.options.disabled || this.greedyChild || !this.visible) {\n                    return;\n                }\n\n                var parentInstance, scope, parent,\n                    intersects = $.ui.intersect(draggable, this, this.options.tolerance),\n                    c = !intersects && this.isover ? \"isout\" : (intersects && !this.isover ? \"isover\" : null);\n                if (!c) {\n                    return;\n                }\n\n                if (this.options.greedy) {\n                    // find droppable parents with same scope\n                    scope = this.options.scope;\n                    parent = this.element.parents(\":data(ui-droppable)\").filter(function () {\n                        return $.data(this, \"ui-droppable\").options.scope === scope;\n                    });\n\n                    if (parent.length) {\n                        parentInstance = $.data(parent[0], \"ui-droppable\");\n                        parentInstance.greedyChild = (c === \"isover\");\n                    }\n                }\n\n                // we just moved into a greedy child\n                if (parentInstance && c === \"isover\") {\n                    parentInstance.isover = false;\n                    parentInstance.isout = true;\n                    parentInstance._out.call(parentInstance, event);\n                }\n\n                this[c] = true;\n                this[c === \"isout\" ? \"isover\" : \"isout\"] = false;\n                this[c === \"isover\" ? \"_over\" : \"_out\"].call(this, event);\n\n                // we just moved out of a greedy child\n                if (parentInstance && c === \"isout\") {\n                    parentInstance.isout = false;\n                    parentInstance.isover = true;\n                    parentInstance._over.call(parentInstance, event);\n                }\n            });\n\n        },\n        dragStop: function (draggable, event) {\n            draggable.element.parentsUntil(\"body\").unbind(\"scroll.droppable\");\n            //Call prepareOffsets one final time since IE does not fire return scroll events when overflow was caused by drag (see #5003)\n            if (!draggable.options.refreshPositions) {\n                $.ui.ddmanager.prepareOffsets(draggable, event);\n            }\n        }\n    };\n\n});\n","jquery/ui-modules/button.js":"/*!\n * jQuery UI Button - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/button/\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/widget'\n], function ($, undefined) {\n\n    var lastActive,\n        baseClasses = \"ui-button ui-widget ui-state-default ui-corner-all\",\n        typeClasses = \"ui-button-icons-only ui-button-icon-only ui-button-text-icons ui-button-text-icon-primary ui-button-text-icon-secondary ui-button-text-only\",\n        formResetHandler = function () {\n            var form = $(this);\n            setTimeout(function () {\n                form.find(\":ui-button\").button(\"refresh\");\n            }, 1);\n        },\n        radioGroup = function (radio) {\n            var name = radio.name,\n                form = radio.form,\n                radios = $([]);\n            if (name) {\n                name = name.replace(/'/g, \"\\\\'\");\n                if (form) {\n                    radios = $(form).find(\"[name='\" + name + \"']\");\n                } else {\n                    radios = $(\"[name='\" + name + \"']\", radio.ownerDocument)\n                        .filter(function () {\n                            return !this.form;\n                        });\n                }\n            }\n            return radios;\n        };\n\n    $.widget(\"ui.button\", {\n        version: \"1.10.4\",\n        defaultElement: \"<button>\",\n        options: {\n            disabled: null,\n            text: true,\n            label: null,\n            icons: {\n                primary: null,\n                secondary: null\n            }\n        },\n        _create: function () {\n            this.element.closest(\"form\")\n                .unbind(\"reset\" + this.eventNamespace)\n                .bind(\"reset\" + this.eventNamespace, formResetHandler);\n\n            if (typeof this.options.disabled !== \"boolean\") {\n                this.options.disabled = !!this.element.prop(\"disabled\");\n            } else {\n                this.element.prop(\"disabled\", this.options.disabled);\n            }\n\n            this._determineButtonType();\n            this.hasTitle = !!this.buttonElement.attr(\"title\");\n\n            var that = this,\n                options = this.options,\n                toggleButton = this.type === \"checkbox\" || this.type === \"radio\",\n                activeClass = !toggleButton ? \"ui-state-active\" : \"\";\n\n            if (options.label === null) {\n                options.label = (this.type === \"input\" ? this.buttonElement.val() : this.buttonElement.html());\n            }\n\n            this._hoverable(this.buttonElement);\n\n            this.buttonElement\n                .addClass(baseClasses)\n                .attr(\"role\", \"button\")\n                .bind(\"mouseenter\" + this.eventNamespace, function () {\n                    if (options.disabled) {\n                        return;\n                    }\n                    if (this === lastActive) {\n                        $(this).addClass(\"ui-state-active\");\n                    }\n                })\n                .bind(\"mouseleave\" + this.eventNamespace, function () {\n                    if (options.disabled) {\n                        return;\n                    }\n                    $(this).removeClass(activeClass);\n                })\n                .bind(\"click\" + this.eventNamespace, function (event) {\n                    if (options.disabled) {\n                        event.preventDefault();\n                        event.stopImmediatePropagation();\n                    }\n                });\n\n            // Can't use _focusable() because the element that receives focus\n            // and the element that gets the ui-state-focus class are different\n            this._on({\n                focus: function () {\n                    this.buttonElement.addClass(\"ui-state-focus\");\n                },\n                blur: function () {\n                    this.buttonElement.removeClass(\"ui-state-focus\");\n                }\n            });\n\n            if (toggleButton) {\n                this.element.bind(\"change\" + this.eventNamespace, function () {\n                    that.refresh();\n                });\n            }\n\n            if (this.type === \"checkbox\") {\n                this.buttonElement.bind(\"click\" + this.eventNamespace, function () {\n                    if (options.disabled) {\n                        return false;\n                    }\n                });\n            } else if (this.type === \"radio\") {\n                this.buttonElement.bind(\"click\" + this.eventNamespace, function () {\n                    if (options.disabled) {\n                        return false;\n                    }\n                    $(this).addClass(\"ui-state-active\");\n                    that.buttonElement.attr(\"aria-pressed\", \"true\");\n\n                    var radio = that.element[0];\n                    radioGroup(radio)\n                        .not(radio)\n                        .map(function () {\n                            return $(this).button(\"widget\")[0];\n                        })\n                        .removeClass(\"ui-state-active\")\n                        .attr(\"aria-pressed\", \"false\");\n                });\n            } else {\n                this.buttonElement\n                    .bind(\"mousedown\" + this.eventNamespace, function () {\n                        if (options.disabled) {\n                            return false;\n                        }\n                        $(this).addClass(\"ui-state-active\");\n                        lastActive = this;\n                        that.document.one(\"mouseup\", function () {\n                            lastActive = null;\n                        });\n                    })\n                    .bind(\"mouseup\" + this.eventNamespace, function () {\n                        if (options.disabled) {\n                            return false;\n                        }\n                        $(this).removeClass(\"ui-state-active\");\n                    })\n                    .bind(\"keydown\" + this.eventNamespace, function (event) {\n                        if (options.disabled) {\n                            return false;\n                        }\n                        if (event.keyCode === $.ui.keyCode.SPACE || event.keyCode === $.ui.keyCode.ENTER) {\n                            $(this).addClass(\"ui-state-active\");\n                        }\n                    })\n                    // see #8559, we bind to blur here in case the button element loses\n                    // focus between keydown and keyup, it would be left in an \"active\" state\n                    .bind(\"keyup\" + this.eventNamespace + \" blur\" + this.eventNamespace, function () {\n                        $(this).removeClass(\"ui-state-active\");\n                    });\n\n                if (this.buttonElement.is(\"a\")) {\n                    this.buttonElement.keyup(function (event) {\n                        if (event.keyCode === $.ui.keyCode.SPACE) {\n                            // TODO pass through original event correctly (just as 2nd argument doesn't work)\n                            $(this).click();\n                        }\n                    });\n                }\n            }\n\n            // TODO: pull out $.Widget's handling for the disabled option into\n            // $.Widget.prototype._setOptionDisabled so it's easy to proxy and can\n            // be overridden by individual plugins\n            this._setOption(\"disabled\", options.disabled);\n            this._resetButton();\n        },\n\n        _determineButtonType: function () {\n            var ancestor, labelSelector, checked;\n\n            if (this.element.is(\"[type=checkbox]\")) {\n                this.type = \"checkbox\";\n            } else if (this.element.is(\"[type=radio]\")) {\n                this.type = \"radio\";\n            } else if (this.element.is(\"input\")) {\n                this.type = \"input\";\n            } else {\n                this.type = \"button\";\n            }\n\n            if (this.type === \"checkbox\" || this.type === \"radio\") {\n                // we don't search against the document in case the element\n                // is disconnected from the DOM\n                ancestor = this.element.parents().last();\n                labelSelector = \"label[for='\" + this.element.attr(\"id\") + \"']\";\n                this.buttonElement = ancestor.find(labelSelector);\n                if (!this.buttonElement.length) {\n                    ancestor = ancestor.length ? ancestor.siblings() : this.element.siblings();\n                    this.buttonElement = ancestor.filter(labelSelector);\n                    if (!this.buttonElement.length) {\n                        this.buttonElement = ancestor.find(labelSelector);\n                    }\n                }\n                this.element.addClass(\"ui-helper-hidden-accessible\");\n\n                checked = this.element.is(\":checked\");\n                if (checked) {\n                    this.buttonElement.addClass(\"ui-state-active\");\n                }\n                this.buttonElement.prop(\"aria-pressed\", checked);\n            } else {\n                this.buttonElement = this.element;\n            }\n        },\n\n        widget: function () {\n            return this.buttonElement;\n        },\n\n        _destroy: function () {\n            this.element\n                .removeClass(\"ui-helper-hidden-accessible\");\n            this.buttonElement\n                .removeClass(baseClasses + \" ui-state-active \" + typeClasses)\n                .removeAttr(\"role\")\n                .removeAttr(\"aria-pressed\")\n                .html(this.buttonElement.find(\".ui-button-text\").html());\n\n            if (!this.hasTitle) {\n                this.buttonElement.removeAttr(\"title\");\n            }\n        },\n\n        _setOption: function (key, value) {\n            this._super(key, value);\n            if (key === \"disabled\") {\n                this.element.prop(\"disabled\", !!value);\n                if (value) {\n                    this.buttonElement.removeClass(\"ui-state-focus\");\n                }\n                return;\n            }\n            this._resetButton();\n        },\n\n        refresh: function () {\n            //See #8237 & #8828\n            var isDisabled = this.element.is(\"input, button\") ? this.element.is(\":disabled\") : this.element.hasClass(\"ui-button-disabled\");\n\n            if (isDisabled !== this.options.disabled) {\n                this._setOption(\"disabled\", isDisabled);\n            }\n            if (this.type === \"radio\") {\n                radioGroup(this.element[0]).each(function () {\n                    if ($(this).is(\":checked\")) {\n                        $(this).button(\"widget\")\n                            .addClass(\"ui-state-active\")\n                            .attr(\"aria-pressed\", \"true\");\n                    } else {\n                        $(this).button(\"widget\")\n                            .removeClass(\"ui-state-active\")\n                            .attr(\"aria-pressed\", \"false\");\n                    }\n                });\n            } else if (this.type === \"checkbox\") {\n                if (this.element.is(\":checked\")) {\n                    this.buttonElement\n                        .addClass(\"ui-state-active\")\n                        .attr(\"aria-pressed\", \"true\");\n                } else {\n                    this.buttonElement\n                        .removeClass(\"ui-state-active\")\n                        .attr(\"aria-pressed\", \"false\");\n                }\n            }\n        },\n\n        _resetButton: function () {\n            if (this.type === \"input\") {\n                if (this.options.label) {\n                    this.element.val(this.options.label);\n                }\n                return;\n            }\n            var buttonElement = this.buttonElement.removeClass(typeClasses),\n                buttonText = $(\"<span></span>\", this.document[0])\n                    .addClass(\"ui-button-text\")\n                    .html(this.options.label)\n                    .appendTo(buttonElement.empty())\n                    .text(),\n                icons = this.options.icons,\n                multipleIcons = icons.primary && icons.secondary,\n                buttonClasses = [];\n\n            if (icons.primary || icons.secondary) {\n                if (this.options.text) {\n                    buttonClasses.push(\"ui-button-text-icon\" + (multipleIcons ? \"s\" : (icons.primary ? \"-primary\" : \"-secondary\")));\n                }\n\n                if (icons.primary) {\n                    buttonElement.prepend(\"<span class='ui-button-icon-primary ui-icon \" + icons.primary + \"'></span>\");\n                }\n\n                if (icons.secondary) {\n                    buttonElement.append(\"<span class='ui-button-icon-secondary ui-icon \" + icons.secondary + \"'></span>\");\n                }\n\n                if (!this.options.text) {\n                    buttonClasses.push(multipleIcons ? \"ui-button-icons-only\" : \"ui-button-icon-only\");\n\n                    if (!this.hasTitle) {\n                        buttonElement.attr(\"title\", $.trim(buttonText));\n                    }\n                }\n            } else {\n                buttonClasses.push(\"ui-button-text-only\");\n            }\n            buttonElement.addClass(buttonClasses.join(\" \"));\n        }\n    });\n\n    $.widget(\"ui.buttonset\", {\n        version: \"1.10.4\",\n        options: {\n            items: \"button, input[type=button], input[type=submit], input[type=reset], input[type=checkbox], input[type=radio], a, :data(ui-button)\"\n        },\n\n        _create: function () {\n            this.element.addClass(\"ui-buttonset\");\n        },\n\n        _init: function () {\n            this.refresh();\n        },\n\n        _setOption: function (key, value) {\n            if (key === \"disabled\") {\n                this.buttons.button(\"option\", key, value);\n            }\n\n            this._super(key, value);\n        },\n\n        refresh: function () {\n            var rtl = this.element.css(\"direction\") === \"rtl\";\n\n            this.buttons = this.element.find(this.options.items)\n                .filter(\":ui-button\")\n                .button(\"refresh\")\n                .end()\n                .not(\":ui-button\")\n                .button()\n                .end()\n                .map(function () {\n                    return $(this).button(\"widget\")[0];\n                })\n                .removeClass(\"ui-corner-all ui-corner-left ui-corner-right\")\n                .filter(\":first\")\n                .addClass(rtl ? \"ui-corner-right\" : \"ui-corner-left\")\n                .end()\n                .filter(\":last\")\n                .addClass(rtl ? \"ui-corner-left\" : \"ui-corner-right\")\n                .end()\n                .end();\n        },\n\n        _destroy: function () {\n            this.element.removeClass(\"ui-buttonset\");\n            this.buttons\n                .map(function () {\n                    return $(this).button(\"widget\")[0];\n                })\n                .removeClass(\"ui-corner-left ui-corner-right\")\n                .end()\n                .button(\"destroy\");\n        }\n    });\n\n});\n","jquery/ui-modules/effect-explode.js":"/*!\n * jQuery UI Effects Explode - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/explode-effect/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.explode = function (o, done) {\n\n        var rows = o.pieces ? Math.round(Math.sqrt(o.pieces)) : 3,\n            cells = rows,\n            el = $(this),\n            mode = $.effects.setMode(el, o.mode || \"hide\"),\n            show = mode === \"show\",\n\n            // show and then visibility:hidden the element before calculating offset\n            offset = el.show().css(\"visibility\", \"hidden\").offset(),\n\n            // width and height of a piece\n            width = Math.ceil(el.outerWidth() / cells),\n            height = Math.ceil(el.outerHeight() / rows),\n            pieces = [],\n\n            // loop\n            i, j, left, top, mx, my;\n\n        // children animate complete:\n        function childComplete() {\n            pieces.push(this);\n            if (pieces.length === rows * cells) {\n                animComplete();\n            }\n        }\n\n        // clone the element for each row and cell.\n        for (i = 0; i < rows; i++) { // ===>\n            top = offset.top + i * height;\n            my = i - (rows - 1) / 2;\n\n            for (j = 0; j < cells; j++) { // |||\n                left = offset.left + j * width;\n                mx = j - (cells - 1) / 2;\n\n                // Create a clone of the now hidden main element that will be absolute positioned\n                // within a wrapper div off the -left and -top equal to size of our pieces\n                el\n                    .clone()\n                    .appendTo(\"body\")\n                    .wrap(\"<div></div>\")\n                    .css({\n                        position: \"absolute\",\n                        visibility: \"visible\",\n                        left: -j * width,\n                        top: -i * height\n                    })\n\n                    // select the wrapper - make it overflow: hidden and absolute positioned based on\n                    // where the original was located +left and +top equal to the size of pieces\n                    .parent()\n                    .addClass(\"ui-effects-explode\")\n                    .css({\n                        position: \"absolute\",\n                        overflow: \"hidden\",\n                        width: width,\n                        height: height,\n                        left: left + (show ? mx * width : 0),\n                        top: top + (show ? my * height : 0),\n                        opacity: show ? 0 : 1\n                    }).animate({\n                    left: left + (show ? 0 : mx * width),\n                    top: top + (show ? 0 : my * height),\n                    opacity: show ? 1 : 0\n                }, o.duration || 500, o.easing, childComplete);\n            }\n        }\n\n        function animComplete() {\n            el.css({\n                visibility: \"visible\"\n            });\n            $(pieces).remove();\n            if (!show) {\n                el.hide();\n            }\n            done();\n        }\n    };\n\n});\n","jquery/ui-modules/widget.js":"/*!\n * jQuery UI Widget - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/jQuery.widget/\n */\n\ndefine([\n    'jquery'\n], function ($, undefined) {\n\n    var uuid = 0,\n        slice = Array.prototype.slice,\n        _cleanData = $.cleanData;\n    $.cleanData = function (elems) {\n        for (var i = 0, elem; (elem = elems[i]) != null; i++) {\n            try {\n                $(elem).triggerHandler(\"remove\");\n                // http://bugs.jquery.com/ticket/8235\n            } catch (e) {\n            }\n        }\n        _cleanData(elems);\n    };\n\n    $.widget = function (name, base, prototype) {\n        var fullName, existingConstructor, constructor, basePrototype,\n            // proxiedPrototype allows the provided prototype to remain unmodified\n            // so that it can be used as a mixin for multiple widgets (#8876)\n            proxiedPrototype = {},\n            namespace = name.split(\".\")[0];\n\n        name = name.split(\".\")[1];\n        fullName = namespace + \"-\" + name;\n\n        if (!prototype) {\n            prototype = base;\n            base = $.Widget;\n        }\n\n        // create selector for plugin\n        $.expr[\":\"][fullName.toLowerCase()] = function (elem) {\n            return !!$.data(elem, fullName);\n        };\n\n        $[namespace] = $[namespace] || {};\n        existingConstructor = $[namespace][name];\n        constructor = $[namespace][name] = function (options, element) {\n            // allow instantiation without \"new\" keyword\n            if (!this._createWidget) {\n                return new constructor(options, element);\n            }\n\n            // allow instantiation without initializing for simple inheritance\n            // must use \"new\" keyword (the code above always passes args)\n            if (arguments.length) {\n                this._createWidget(options, element);\n            }\n        };\n        // extend with the existing constructor to carry over any static properties\n        $.extend(constructor, existingConstructor, {\n            version: prototype.version,\n            // copy the object used to create the prototype in case we need to\n            // redefine the widget later\n            _proto: $.extend({}, prototype),\n            // track widgets that inherit from this widget in case this widget is\n            // redefined after a widget inherits from it\n            _childConstructors: []\n        });\n\n        basePrototype = new base();\n        // we need to make the options hash a property directly on the new instance\n        // otherwise we'll modify the options hash on the prototype that we're\n        // inheriting from\n        basePrototype.options = $.widget.extend({}, basePrototype.options);\n        $.each(prototype, function (prop, value) {\n            if (!$.isFunction(value)) {\n                proxiedPrototype[prop] = value;\n                return;\n            }\n            proxiedPrototype[prop] = (function () {\n                var _super = function () {\n                        return base.prototype[prop].apply(this, arguments);\n                    },\n                    _superApply = function (args) {\n                        return base.prototype[prop].apply(this, args);\n                    };\n                return function () {\n                    var __super = this._super,\n                        __superApply = this._superApply,\n                        returnValue;\n\n                    this._super = _super;\n                    this._superApply = _superApply;\n\n                    returnValue = value.apply(this, arguments);\n\n                    this._super = __super;\n                    this._superApply = __superApply;\n\n                    return returnValue;\n                };\n            })();\n        });\n        constructor.prototype = $.widget.extend(basePrototype, {\n            // TODO: remove support for widgetEventPrefix\n            // always use the name + a colon as the prefix, e.g., draggable:start\n            // don't prefix for widgets that aren't DOM-based\n            widgetEventPrefix: existingConstructor ? (basePrototype.widgetEventPrefix || name) : name\n        }, proxiedPrototype, {\n            constructor: constructor,\n            namespace: namespace,\n            widgetName: name,\n            widgetFullName: fullName\n        });\n\n        // If this widget is being redefined then we need to find all widgets that\n        // are inheriting from it and redefine all of them so that they inherit from\n        // the new version of this widget. We're essentially trying to replace one\n        // level in the prototype chain.\n        if (existingConstructor) {\n            $.each(existingConstructor._childConstructors, function (i, child) {\n                var childPrototype = child.prototype;\n\n                // redefine the child widget using the same prototype that was\n                // originally used, but inherit from the new version of the base\n                $.widget(childPrototype.namespace + \".\" + childPrototype.widgetName, constructor, child._proto);\n            });\n            // remove the list of existing child constructors from the old constructor\n            // so the old child constructors can be garbage collected\n            delete existingConstructor._childConstructors;\n        } else {\n            base._childConstructors.push(constructor);\n        }\n\n        $.widget.bridge(name, constructor);\n    };\n\n    $.widget.extend = function (target) {\n        var input = slice.call(arguments, 1),\n            inputIndex = 0,\n            inputLength = input.length,\n            key,\n            value;\n        for (; inputIndex < inputLength; inputIndex++) {\n            for (key in input[inputIndex]) {\n                value = input[inputIndex][key];\n                if (input[inputIndex].hasOwnProperty(key) && value !== undefined) {\n                    // Clone objects\n                    if ($.isPlainObject(value)) {\n                        target[key] = $.isPlainObject(target[key]) ?\n                            $.widget.extend({}, target[key], value) :\n                            // Don't extend strings, arrays, etc. with objects\n                            $.widget.extend({}, value);\n                        // Copy everything else by reference\n                    } else {\n                        target[key] = value;\n                    }\n                }\n            }\n        }\n        return target;\n    };\n\n    $.widget.bridge = function (name, object) {\n        var fullName = object.prototype.widgetFullName || name;\n        $.fn[name] = function (options) {\n            var isMethodCall = typeof options === \"string\",\n                args = slice.call(arguments, 1),\n                returnValue = this;\n\n            // allow multiple hashes to be passed on init\n            options = !isMethodCall && args.length ?\n                $.widget.extend.apply(null, [options].concat(args)) :\n                options;\n\n            if (isMethodCall) {\n                this.each(function () {\n                    var methodValue,\n                        instance = $.data(this, fullName);\n                    if (!instance) {\n                        return $.error(\"cannot call methods on \" + name + \" prior to initialization; \" +\n                            \"attempted to call method '\" + options + \"'\");\n                    }\n                    if (!$.isFunction(instance[options]) || options.charAt(0) === \"_\") {\n                        return $.error(\"no such method '\" + options + \"' for \" + name + \" widget instance\");\n                    }\n                    methodValue = instance[options].apply(instance, args);\n                    if (methodValue !== instance && methodValue !== undefined) {\n                        returnValue = methodValue && methodValue.jquery ?\n                            returnValue.pushStack(methodValue.get()) :\n                            methodValue;\n                        return false;\n                    }\n                });\n            } else {\n                this.each(function () {\n                    var instance = $.data(this, fullName);\n                    if (instance) {\n                        instance.option(options || {})._init();\n                    } else {\n                        $.data(this, fullName, new object(options, this));\n                    }\n                });\n            }\n\n            return returnValue;\n        };\n    };\n\n    $.Widget = function ( /* options, element */) {\n    };\n    $.Widget._childConstructors = [];\n\n    $.Widget.prototype = {\n        widgetName: \"widget\",\n        widgetEventPrefix: \"\",\n        defaultElement: \"<div>\",\n        options: {\n            disabled: false,\n\n            // callbacks\n            create: null\n        },\n        _createWidget: function (options, element) {\n            element = $(element || this.defaultElement || this)[0];\n            this.element = $(element);\n            this.uuid = uuid++;\n            this.eventNamespace = \".\" + this.widgetName + this.uuid;\n            this.options = $.widget.extend({},\n                this.options,\n                this._getCreateOptions(),\n                options);\n\n            this.bindings = $();\n            this.hoverable = $();\n            this.focusable = $();\n\n            if (element !== this) {\n                $.data(element, this.widgetFullName, this);\n                this._on(true, this.element, {\n                    remove: function (event) {\n                        if (event.target === element) {\n                            this.destroy();\n                        }\n                    }\n                });\n                this.document = $(element.style ?\n                    // element within the document\n                    element.ownerDocument :\n                    // element is window or document\n                    element.document || element);\n                this.window = $(this.document[0].defaultView || this.document[0].parentWindow);\n            }\n\n            this._create();\n            this._trigger(\"create\", null, this._getCreateEventData());\n            this._init();\n        },\n        _getCreateOptions: $.noop,\n        _getCreateEventData: $.noop,\n        _create: $.noop,\n        _init: $.noop,\n\n        destroy: function () {\n            this._destroy();\n            // we can probably remove the unbind calls in 2.0\n            // all event bindings should go through this._on()\n            this.element\n                .unbind(this.eventNamespace)\n                // 1.9 BC for #7810\n                // TODO remove dual storage\n                .removeData(this.widgetName)\n                .removeData(this.widgetFullName)\n                // support: jquery <1.6.3\n                // http://bugs.jquery.com/ticket/9413\n                .removeData($.camelCase(this.widgetFullName));\n            this.widget()\n                .unbind(this.eventNamespace)\n                .removeAttr(\"aria-disabled\")\n                .removeClass(\n                    this.widgetFullName + \"-disabled \" +\n                    \"ui-state-disabled\");\n\n            // clean up events and states\n            this.bindings.unbind(this.eventNamespace);\n            this.hoverable.removeClass(\"ui-state-hover\");\n            this.focusable.removeClass(\"ui-state-focus\");\n        },\n        _destroy: $.noop,\n\n        widget: function () {\n            return this.element;\n        },\n\n        option: function (key, value) {\n            var options = key,\n                parts,\n                curOption,\n                i;\n\n            if (arguments.length === 0) {\n                // don't return a reference to the internal hash\n                return $.widget.extend({}, this.options);\n            }\n\n            if (typeof key === \"string\") {\n                // handle nested keys, e.g., \"foo.bar\" => { foo: { bar: ___ } }\n                options = {};\n                parts = key.split(\".\");\n                key = parts.shift();\n                if (parts.length) {\n                    curOption = options[key] = $.widget.extend({}, this.options[key]);\n                    for (i = 0; i < parts.length - 1; i++) {\n                        curOption[parts[i]] = curOption[parts[i]] || {};\n                        curOption = curOption[parts[i]];\n                    }\n                    key = parts.pop();\n                    if (arguments.length === 1) {\n                        return curOption[key] === undefined ? null : curOption[key];\n                    }\n                    curOption[key] = value;\n                } else {\n                    if (arguments.length === 1) {\n                        return this.options[key] === undefined ? null : this.options[key];\n                    }\n                    options[key] = value;\n                }\n            }\n\n            this._setOptions(options);\n\n            return this;\n        },\n        _setOptions: function (options) {\n            var key;\n\n            for (key in options) {\n                this._setOption(key, options[key]);\n            }\n\n            return this;\n        },\n        _setOption: function (key, value) {\n            this.options[key] = value;\n\n            if (key === \"disabled\") {\n                this.widget()\n                    .toggleClass(this.widgetFullName + \"-disabled ui-state-disabled\", !!value)\n                    .attr(\"aria-disabled\", value);\n                this.hoverable.removeClass(\"ui-state-hover\");\n                this.focusable.removeClass(\"ui-state-focus\");\n            }\n\n            return this;\n        },\n\n        enable: function () {\n            return this._setOption(\"disabled\", false);\n        },\n        disable: function () {\n            return this._setOption(\"disabled\", true);\n        },\n\n        _on: function (suppressDisabledCheck, element, handlers) {\n            var delegateElement,\n                instance = this;\n\n            // no suppressDisabledCheck flag, shuffle arguments\n            if (typeof suppressDisabledCheck !== \"boolean\") {\n                handlers = element;\n                element = suppressDisabledCheck;\n                suppressDisabledCheck = false;\n            }\n\n            // no element argument, shuffle and use this.element\n            if (!handlers) {\n                handlers = element;\n                element = this.element;\n                delegateElement = this.widget();\n            } else {\n                // accept selectors, DOM elements\n                element = delegateElement = $(element);\n                this.bindings = this.bindings.add(element);\n            }\n\n            $.each(handlers, function (event, handler) {\n                function handlerProxy() {\n                    // allow widgets to customize the disabled handling\n                    // - disabled as an array instead of boolean\n                    // - disabled class as method for disabling individual parts\n                    if (!suppressDisabledCheck &&\n                        (instance.options.disabled === true ||\n                            $(this).hasClass(\"ui-state-disabled\"))) {\n                        return;\n                    }\n                    return (typeof handler === \"string\" ? instance[handler] : handler)\n                        .apply(instance, arguments);\n                }\n\n                // copy the guid so direct unbinding works\n                if (typeof handler !== \"string\") {\n                    handlerProxy.guid = handler.guid =\n                        handler.guid || handlerProxy.guid || $.guid++;\n                }\n\n                var match = event.match(/^(\\w+)\\s*(.*)$/),\n                    eventName = match[1] + instance.eventNamespace,\n                    selector = match[2];\n                if (selector) {\n                    delegateElement.delegate(selector, eventName, handlerProxy);\n                } else {\n                    element.bind(eventName, handlerProxy);\n                }\n            });\n        },\n\n        _off: function (element, eventName) {\n            eventName = (eventName || \"\").split(\" \").join(this.eventNamespace + \" \") + this.eventNamespace;\n            element.unbind(eventName).undelegate(eventName);\n        },\n\n        _delay: function (handler, delay) {\n            function handlerProxy() {\n                return (typeof handler === \"string\" ? instance[handler] : handler)\n                    .apply(instance, arguments);\n            }\n\n            var instance = this;\n            return setTimeout(handlerProxy, delay || 0);\n        },\n\n        _hoverable: function (element) {\n            this.hoverable = this.hoverable.add(element);\n            this._on(element, {\n                mouseenter: function (event) {\n                    $(event.currentTarget).addClass(\"ui-state-hover\");\n                },\n                mouseleave: function (event) {\n                    $(event.currentTarget).removeClass(\"ui-state-hover\");\n                }\n            });\n        },\n\n        _focusable: function (element) {\n            this.focusable = this.focusable.add(element);\n            this._on(element, {\n                focusin: function (event) {\n                    $(event.currentTarget).addClass(\"ui-state-focus\");\n                },\n                focusout: function (event) {\n                    $(event.currentTarget).removeClass(\"ui-state-focus\");\n                }\n            });\n        },\n\n        _trigger: function (type, event, data) {\n            var prop, orig,\n                callback = this.options[type];\n\n            data = data || {};\n            event = $.Event(event);\n            event.type = (type === this.widgetEventPrefix ?\n                type :\n                this.widgetEventPrefix + type).toLowerCase();\n            // the original event may come from any element\n            // so we need to reset the target on the new event\n            event.target = this.element[0];\n\n            // copy original event properties over to the new event\n            orig = event.originalEvent;\n            if (orig) {\n                for (prop in orig) {\n                    if (!(prop in event)) {\n                        event[prop] = orig[prop];\n                    }\n                }\n            }\n\n            this.element.trigger(event, data);\n            return !($.isFunction(callback) &&\n                callback.apply(this.element[0], [event].concat(data)) === false ||\n                event.isDefaultPrevented());\n        }\n    };\n\n    $.each({show: \"fadeIn\", hide: \"fadeOut\"}, function (method, defaultEffect) {\n        $.Widget.prototype[\"_\" + method] = function (element, options, callback) {\n            if (typeof options === \"string\") {\n                options = {effect: options};\n            }\n            var hasOptions,\n                effectName = !options ?\n                    method :\n                    options === true || typeof options === \"number\" ?\n                        defaultEffect :\n                        options.effect || defaultEffect;\n            options = options || {};\n            if (typeof options === \"number\") {\n                options = {duration: options};\n            }\n            hasOptions = !$.isEmptyObject(options);\n            options.complete = callback;\n            if (options.delay) {\n                element.delay(options.delay);\n            }\n            if (hasOptions && $.effects && $.effects.effect[effectName]) {\n                element[method](options);\n            } else if (effectName !== method && element[effectName]) {\n                element[effectName](options.duration, options.easing, callback);\n            } else {\n                element.queue(function (next) {\n                    $(this)[method]();\n                    if (callback) {\n                        callback.call(element[0]);\n                    }\n                    next();\n                });\n            }\n        };\n    });\n\n});\n","jquery/ui-modules/effect-bounce.js":"/*!\n * jQuery UI Effects Bounce - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/bounce-effect/\n *\n * Depends:\n *\tjquery.ui.effect.js\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.bounce = function (o, done) {\n        var el = $(this),\n            props = [\"position\", \"top\", \"bottom\", \"left\", \"right\", \"height\", \"width\"],\n\n            // defaults:\n            mode = $.effects.setMode(el, o.mode || \"effect\"),\n            hide = mode === \"hide\",\n            show = mode === \"show\",\n            direction = o.direction || \"up\",\n            distance = o.distance,\n            times = o.times || 5,\n\n            // number of internal animations\n            anims = times * 2 + (show || hide ? 1 : 0),\n            speed = o.duration / anims,\n            easing = o.easing,\n\n            // utility:\n            ref = (direction === \"up\" || direction === \"down\") ? \"top\" : \"left\",\n            motion = (direction === \"up\" || direction === \"left\"),\n            i,\n            upAnim,\n            downAnim,\n\n            // we will need to re-assemble the queue to stack our animations in place\n            queue = el.queue(),\n            queuelen = queue.length;\n\n        // Avoid touching opacity to prevent clearType and PNG issues in IE\n        if (show || hide) {\n            props.push(\"opacity\");\n        }\n\n        $.effects.save(el, props);\n        el.show();\n        $.effects.createWrapper(el); // Create Wrapper\n\n        // default distance for the BIGGEST bounce is the outer Distance / 3\n        if (!distance) {\n            distance = el[ref === \"top\" ? \"outerHeight\" : \"outerWidth\"]() / 3;\n        }\n\n        if (show) {\n            downAnim = {opacity: 1};\n            downAnim[ref] = 0;\n\n            // if we are showing, force opacity 0 and set the initial position\n            // then do the \"first\" animation\n            el.css(\"opacity\", 0)\n                .css(ref, motion ? -distance * 2 : distance * 2)\n                .animate(downAnim, speed, easing);\n        }\n\n        // start at the smallest distance if we are hiding\n        if (hide) {\n            distance = distance / Math.pow(2, times - 1);\n        }\n\n        downAnim = {};\n        downAnim[ref] = 0;\n        // Bounces up/down/left/right then back to 0 -- times * 2 animations happen here\n        for (i = 0; i < times; i++) {\n            upAnim = {};\n            upAnim[ref] = (motion ? \"-=\" : \"+=\") + distance;\n\n            el.animate(upAnim, speed, easing)\n                .animate(downAnim, speed, easing);\n\n            distance = hide ? distance * 2 : distance / 2;\n        }\n\n        // Last Bounce when Hiding\n        if (hide) {\n            upAnim = {opacity: 0};\n            upAnim[ref] = (motion ? \"-=\" : \"+=\") + distance;\n\n            el.animate(upAnim, speed, easing);\n        }\n\n        el.queue(function () {\n            if (hide) {\n                el.hide();\n            }\n            $.effects.restore(el, props);\n            $.effects.removeWrapper(el);\n            done();\n        });\n\n        // inject all the animations we just queued to be first in line (after \"inprogress\")\n        if (queuelen > 1) {\n            queue.splice.apply(queue,\n                [1, 0].concat(queue.splice(queuelen, anims + 1)));\n        }\n        el.dequeue();\n\n    };\n\n});\n","jquery/ui-modules/slider.js":"/*!\n * jQuery UI Slider - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/slider/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/mouse'\n], function ($, undefined) {\n\n// number of pages in a slider\n// (how many times can you page up/down to go through the whole range)\n    var numPages = 5;\n\n    $.widget(\"ui.slider\", $.ui.mouse, {\n        version: \"1.10.4\",\n        widgetEventPrefix: \"slide\",\n\n        options: {\n            animate: false,\n            distance: 0,\n            max: 100,\n            min: 0,\n            orientation: \"horizontal\",\n            range: false,\n            step: 1,\n            value: 0,\n            values: null,\n\n            // callbacks\n            change: null,\n            slide: null,\n            start: null,\n            stop: null\n        },\n\n        _create: function () {\n            this._keySliding = false;\n            this._mouseSliding = false;\n            this._animateOff = true;\n            this._handleIndex = null;\n            this._detectOrientation();\n            this._mouseInit();\n\n            this.element\n                .addClass(\"ui-slider\" +\n                    \" ui-slider-\" + this.orientation +\n                    \" ui-widget\" +\n                    \" ui-widget-content\" +\n                    \" ui-corner-all\");\n\n            this._refresh();\n            this._setOption(\"disabled\", this.options.disabled);\n\n            this._animateOff = false;\n        },\n\n        _refresh: function () {\n            this._createRange();\n            this._createHandles();\n            this._setupEvents();\n            this._refreshValue();\n        },\n\n        _createHandles: function () {\n            var i, handleCount,\n                options = this.options,\n                existingHandles = this.element.find(\".ui-slider-handle\").addClass(\"ui-state-default ui-corner-all\"),\n                handle = \"<a class='ui-slider-handle ui-state-default ui-corner-all' href='#'></a>\",\n                handles = [];\n\n            handleCount = (options.values && options.values.length) || 1;\n\n            if (existingHandles.length > handleCount) {\n                existingHandles.slice(handleCount).remove();\n                existingHandles = existingHandles.slice(0, handleCount);\n            }\n\n            for (i = existingHandles.length; i < handleCount; i++) {\n                handles.push(handle);\n            }\n\n            this.handles = existingHandles.add($(handles.join(\"\")).appendTo(this.element));\n\n            this.handle = this.handles.eq(0);\n\n            this.handles.each(function (i) {\n                $(this).data(\"ui-slider-handle-index\", i);\n            });\n        },\n\n        _createRange: function () {\n            var options = this.options,\n                classes = \"\";\n\n            if (options.range) {\n                if (options.range === true) {\n                    if (!options.values) {\n                        options.values = [this._valueMin(), this._valueMin()];\n                    } else if (options.values.length && options.values.length !== 2) {\n                        options.values = [options.values[0], options.values[0]];\n                    } else if ($.isArray(options.values)) {\n                        options.values = options.values.slice(0);\n                    }\n                }\n\n                if (!this.range || !this.range.length) {\n                    this.range = $(\"<div></div>\")\n                        .appendTo(this.element);\n\n                    classes = \"ui-slider-range\" +\n                        // note: this isn't the most fittingly semantic framework class for this element,\n                        // but worked best visually with a variety of themes\n                        \" ui-widget-header ui-corner-all\";\n                } else {\n                    this.range.removeClass(\"ui-slider-range-min ui-slider-range-max\")\n                    // Handle range switching from true to min/max\n                        .css({\n                            \"left\": \"\",\n                            \"bottom\": \"\"\n                        });\n                }\n\n                this.range.addClass(classes +\n                    ((options.range === \"min\" || options.range === \"max\") ? \" ui-slider-range-\" + options.range : \"\"));\n            } else {\n                if (this.range) {\n                    this.range.remove();\n                }\n                this.range = null;\n            }\n        },\n\n        _setupEvents: function () {\n            var elements = this.handles.add(this.range).filter(\"a\");\n            this._off(elements);\n            this._on(elements, this._handleEvents);\n            this._hoverable(elements);\n            this._focusable(elements);\n        },\n\n        _destroy: function () {\n            this.handles.remove();\n            if (this.range) {\n                this.range.remove();\n            }\n\n            this.element\n                .removeClass(\"ui-slider\" +\n                    \" ui-slider-horizontal\" +\n                    \" ui-slider-vertical\" +\n                    \" ui-widget\" +\n                    \" ui-widget-content\" +\n                    \" ui-corner-all\");\n\n            this._mouseDestroy();\n        },\n\n        _mouseCapture: function (event) {\n            var position, normValue, distance, closestHandle, index, allowed, offset, mouseOverHandle,\n                that = this,\n                o = this.options;\n\n            if (o.disabled) {\n                return false;\n            }\n\n            this.elementSize = {\n                width: this.element.outerWidth(),\n                height: this.element.outerHeight()\n            };\n            this.elementOffset = this.element.offset();\n\n            position = {x: event.pageX, y: event.pageY};\n            normValue = this._normValueFromMouse(position);\n            distance = this._valueMax() - this._valueMin() + 1;\n            this.handles.each(function (i) {\n                var thisDistance = Math.abs(normValue - that.values(i));\n                if ((distance > thisDistance) ||\n                    (distance === thisDistance &&\n                        (i === that._lastChangedValue || that.values(i) === o.min))) {\n                    distance = thisDistance;\n                    closestHandle = $(this);\n                    index = i;\n                }\n            });\n\n            allowed = this._start(event, index);\n            if (allowed === false) {\n                return false;\n            }\n            this._mouseSliding = true;\n\n            this._handleIndex = index;\n\n            closestHandle\n                .addClass(\"ui-state-active\")\n                .focus();\n\n            offset = closestHandle.offset();\n            mouseOverHandle = !$(event.target).parents().addBack().is(\".ui-slider-handle\");\n            this._clickOffset = mouseOverHandle ? {left: 0, top: 0} : {\n                left: event.pageX - offset.left - (closestHandle.width() / 2),\n                top: event.pageY - offset.top -\n                    (closestHandle.height() / 2) -\n                    (parseInt(closestHandle.css(\"borderTopWidth\"), 10) || 0) -\n                    (parseInt(closestHandle.css(\"borderBottomWidth\"), 10) || 0) +\n                    (parseInt(closestHandle.css(\"marginTop\"), 10) || 0)\n            };\n\n            if (!this.handles.hasClass(\"ui-state-hover\")) {\n                this._slide(event, index, normValue);\n            }\n            this._animateOff = true;\n            return true;\n        },\n\n        _mouseStart: function () {\n            return true;\n        },\n\n        _mouseDrag: function (event) {\n            var position = {x: event.pageX, y: event.pageY},\n                normValue = this._normValueFromMouse(position);\n\n            this._slide(event, this._handleIndex, normValue);\n\n            return false;\n        },\n\n        _mouseStop: function (event) {\n            this.handles.removeClass(\"ui-state-active\");\n            this._mouseSliding = false;\n\n            this._stop(event, this._handleIndex);\n            this._change(event, this._handleIndex);\n\n            this._handleIndex = null;\n            this._clickOffset = null;\n            this._animateOff = false;\n\n            return false;\n        },\n\n        _detectOrientation: function () {\n            this.orientation = (this.options.orientation === \"vertical\") ? \"vertical\" : \"horizontal\";\n        },\n\n        _normValueFromMouse: function (position) {\n            var pixelTotal,\n                pixelMouse,\n                percentMouse,\n                valueTotal,\n                valueMouse;\n\n            if (this.orientation === \"horizontal\") {\n                pixelTotal = this.elementSize.width;\n                pixelMouse = position.x - this.elementOffset.left - (this._clickOffset ? this._clickOffset.left : 0);\n            } else {\n                pixelTotal = this.elementSize.height;\n                pixelMouse = position.y - this.elementOffset.top - (this._clickOffset ? this._clickOffset.top : 0);\n            }\n\n            percentMouse = (pixelMouse / pixelTotal);\n            if (percentMouse > 1) {\n                percentMouse = 1;\n            }\n            if (percentMouse < 0) {\n                percentMouse = 0;\n            }\n            if (this.orientation === \"vertical\") {\n                percentMouse = 1 - percentMouse;\n            }\n\n            valueTotal = this._valueMax() - this._valueMin();\n            valueMouse = this._valueMin() + percentMouse * valueTotal;\n\n            return this._trimAlignValue(valueMouse);\n        },\n\n        _start: function (event, index) {\n            var uiHash = {\n                handle: this.handles[index],\n                value: this.value()\n            };\n            if (this.options.values && this.options.values.length) {\n                uiHash.value = this.values(index);\n                uiHash.values = this.values();\n            }\n            return this._trigger(\"start\", event, uiHash);\n        },\n\n        _slide: function (event, index, newVal) {\n            var otherVal,\n                newValues,\n                allowed;\n\n            if (this.options.values && this.options.values.length) {\n                otherVal = this.values(index ? 0 : 1);\n\n                if ((this.options.values.length === 2 && this.options.range === true) &&\n                    ((index === 0 && newVal > otherVal) || (index === 1 && newVal < otherVal))\n                ) {\n                    newVal = otherVal;\n                }\n\n                if (newVal !== this.values(index)) {\n                    newValues = this.values();\n                    newValues[index] = newVal;\n                    // A slide can be canceled by returning false from the slide callback\n                    allowed = this._trigger(\"slide\", event, {\n                        handle: this.handles[index],\n                        value: newVal,\n                        values: newValues\n                    });\n                    otherVal = this.values(index ? 0 : 1);\n                    if (allowed !== false) {\n                        this.values(index, newVal);\n                    }\n                }\n            } else {\n                if (newVal !== this.value()) {\n                    // A slide can be canceled by returning false from the slide callback\n                    allowed = this._trigger(\"slide\", event, {\n                        handle: this.handles[index],\n                        value: newVal\n                    });\n                    if (allowed !== false) {\n                        this.value(newVal);\n                    }\n                }\n            }\n        },\n\n        _stop: function (event, index) {\n            var uiHash = {\n                handle: this.handles[index],\n                value: this.value()\n            };\n            if (this.options.values && this.options.values.length) {\n                uiHash.value = this.values(index);\n                uiHash.values = this.values();\n            }\n\n            this._trigger(\"stop\", event, uiHash);\n        },\n\n        _change: function (event, index) {\n            if (!this._keySliding && !this._mouseSliding) {\n                var uiHash = {\n                    handle: this.handles[index],\n                    value: this.value()\n                };\n                if (this.options.values && this.options.values.length) {\n                    uiHash.value = this.values(index);\n                    uiHash.values = this.values();\n                }\n\n                //store the last changed value index for reference when handles overlap\n                this._lastChangedValue = index;\n\n                this._trigger(\"change\", event, uiHash);\n            }\n        },\n\n        value: function (newValue) {\n            if (arguments.length) {\n                this.options.value = this._trimAlignValue(newValue);\n                this._refreshValue();\n                this._change(null, 0);\n                return;\n            }\n\n            return this._value();\n        },\n\n        values: function (index, newValue) {\n            var vals,\n                newValues,\n                i;\n\n            if (arguments.length > 1) {\n                this.options.values[index] = this._trimAlignValue(newValue);\n                this._refreshValue();\n                this._change(null, index);\n                return;\n            }\n\n            if (arguments.length) {\n                if ($.isArray(arguments[0])) {\n                    vals = this.options.values;\n                    newValues = arguments[0];\n                    for (i = 0; i < vals.length; i += 1) {\n                        vals[i] = this._trimAlignValue(newValues[i]);\n                        this._change(null, i);\n                    }\n                    this._refreshValue();\n                } else {\n                    if (this.options.values && this.options.values.length) {\n                        return this._values(index);\n                    } else {\n                        return this.value();\n                    }\n                }\n            } else {\n                return this._values();\n            }\n        },\n\n        _setOption: function (key, value) {\n            var i,\n                valsLength = 0;\n\n            if (key === \"range\" && this.options.range === true) {\n                if (value === \"min\") {\n                    this.options.value = this._values(0);\n                    this.options.values = null;\n                } else if (value === \"max\") {\n                    this.options.value = this._values(this.options.values.length - 1);\n                    this.options.values = null;\n                }\n            }\n\n            if ($.isArray(this.options.values)) {\n                valsLength = this.options.values.length;\n            }\n\n            $.Widget.prototype._setOption.apply(this, arguments);\n\n            switch (key) {\n                case \"orientation\":\n                    this._detectOrientation();\n                    this.element\n                        .removeClass(\"ui-slider-horizontal ui-slider-vertical\")\n                        .addClass(\"ui-slider-\" + this.orientation);\n                    this._refreshValue();\n                    break;\n                case \"value\":\n                    this._animateOff = true;\n                    this._refreshValue();\n                    this._change(null, 0);\n                    this._animateOff = false;\n                    break;\n                case \"values\":\n                    this._animateOff = true;\n                    this._refreshValue();\n                    for (i = 0; i < valsLength; i += 1) {\n                        this._change(null, i);\n                    }\n                    this._animateOff = false;\n                    break;\n                case \"min\":\n                case \"max\":\n                    this._animateOff = true;\n                    this._refreshValue();\n                    this._animateOff = false;\n                    break;\n                case \"range\":\n                    this._animateOff = true;\n                    this._refresh();\n                    this._animateOff = false;\n                    break;\n            }\n        },\n\n        //internal value getter\n        // _value() returns value trimmed by min and max, aligned by step\n        _value: function () {\n            var val = this.options.value;\n            val = this._trimAlignValue(val);\n\n            return val;\n        },\n\n        //internal values getter\n        // _values() returns array of values trimmed by min and max, aligned by step\n        // _values( index ) returns single value trimmed by min and max, aligned by step\n        _values: function (index) {\n            var val,\n                vals,\n                i;\n\n            if (arguments.length) {\n                val = this.options.values[index];\n                val = this._trimAlignValue(val);\n\n                return val;\n            } else if (this.options.values && this.options.values.length) {\n                // .slice() creates a copy of the array\n                // this copy gets trimmed by min and max and then returned\n                vals = this.options.values.slice();\n                for (i = 0; i < vals.length; i += 1) {\n                    vals[i] = this._trimAlignValue(vals[i]);\n                }\n\n                return vals;\n            } else {\n                return [];\n            }\n        },\n\n        // returns the step-aligned value that val is closest to, between (inclusive) min and max\n        _trimAlignValue: function (val) {\n            if (val <= this._valueMin()) {\n                return this._valueMin();\n            }\n            if (val >= this._valueMax()) {\n                return this._valueMax();\n            }\n            var step = (this.options.step > 0) ? this.options.step : 1,\n                valModStep = (val - this._valueMin()) % step,\n                alignValue = val - valModStep;\n\n            if (Math.abs(valModStep) * 2 >= step) {\n                alignValue += (valModStep > 0) ? step : (-step);\n            }\n\n            // Since JavaScript has problems with large floats, round\n            // the final value to 5 digits after the decimal point (see #4124)\n            return parseFloat(alignValue.toFixed(5));\n        },\n\n        _valueMin: function () {\n            return this.options.min;\n        },\n\n        _valueMax: function () {\n            return this.options.max;\n        },\n\n        _refreshValue: function () {\n            var lastValPercent, valPercent, value, valueMin, valueMax,\n                oRange = this.options.range,\n                o = this.options,\n                that = this,\n                animate = (!this._animateOff) ? o.animate : false,\n                _set = {};\n\n            if (this.options.values && this.options.values.length) {\n                this.handles.each(function (i) {\n                    valPercent = (that.values(i) - that._valueMin()) / (that._valueMax() - that._valueMin()) * 100;\n                    _set[that.orientation === \"horizontal\" ? \"left\" : \"bottom\"] = valPercent + \"%\";\n                    $(this).stop(1, 1)[animate ? \"animate\" : \"css\"](_set, o.animate);\n                    if (that.options.range === true) {\n                        if (that.orientation === \"horizontal\") {\n                            if (i === 0) {\n                                that.range.stop(1, 1)[animate ? \"animate\" : \"css\"]({left: valPercent + \"%\"}, o.animate);\n                            }\n                            if (i === 1) {\n                                that.range[animate ? \"animate\" : \"css\"]({width: (valPercent - lastValPercent) + \"%\"}, {\n                                    queue: false,\n                                    duration: o.animate\n                                });\n                            }\n                        } else {\n                            if (i === 0) {\n                                that.range.stop(1, 1)[animate ? \"animate\" : \"css\"]({bottom: (valPercent) + \"%\"}, o.animate);\n                            }\n                            if (i === 1) {\n                                that.range[animate ? \"animate\" : \"css\"]({height: (valPercent - lastValPercent) + \"%\"}, {\n                                    queue: false,\n                                    duration: o.animate\n                                });\n                            }\n                        }\n                    }\n                    lastValPercent = valPercent;\n                });\n            } else {\n                value = this.value();\n                valueMin = this._valueMin();\n                valueMax = this._valueMax();\n                valPercent = (valueMax !== valueMin) ?\n                    (value - valueMin) / (valueMax - valueMin) * 100 :\n                    0;\n                _set[this.orientation === \"horizontal\" ? \"left\" : \"bottom\"] = valPercent + \"%\";\n                this.handle.stop(1, 1)[animate ? \"animate\" : \"css\"](_set, o.animate);\n\n                if (oRange === \"min\" && this.orientation === \"horizontal\") {\n                    this.range.stop(1, 1)[animate ? \"animate\" : \"css\"]({width: valPercent + \"%\"}, o.animate);\n                }\n                if (oRange === \"max\" && this.orientation === \"horizontal\") {\n                    this.range[animate ? \"animate\" : \"css\"]({width: (100 - valPercent) + \"%\"}, {\n                        queue: false,\n                        duration: o.animate\n                    });\n                }\n                if (oRange === \"min\" && this.orientation === \"vertical\") {\n                    this.range.stop(1, 1)[animate ? \"animate\" : \"css\"]({height: valPercent + \"%\"}, o.animate);\n                }\n                if (oRange === \"max\" && this.orientation === \"vertical\") {\n                    this.range[animate ? \"animate\" : \"css\"]({height: (100 - valPercent) + \"%\"}, {\n                        queue: false,\n                        duration: o.animate\n                    });\n                }\n            }\n        },\n\n        _handleEvents: {\n            keydown: function (event) {\n                var allowed, curVal, newVal, step,\n                    index = $(event.target).data(\"ui-slider-handle-index\");\n\n                switch (event.keyCode) {\n                    case $.ui.keyCode.HOME:\n                    case $.ui.keyCode.END:\n                    case $.ui.keyCode.PAGE_UP:\n                    case $.ui.keyCode.PAGE_DOWN:\n                    case $.ui.keyCode.UP:\n                    case $.ui.keyCode.RIGHT:\n                    case $.ui.keyCode.DOWN:\n                    case $.ui.keyCode.LEFT:\n                        event.preventDefault();\n                        if (!this._keySliding) {\n                            this._keySliding = true;\n                            $(event.target).addClass(\"ui-state-active\");\n                            allowed = this._start(event, index);\n                            if (allowed === false) {\n                                return;\n                            }\n                        }\n                        break;\n                }\n\n                step = this.options.step;\n                if (this.options.values && this.options.values.length) {\n                    curVal = newVal = this.values(index);\n                } else {\n                    curVal = newVal = this.value();\n                }\n\n                switch (event.keyCode) {\n                    case $.ui.keyCode.HOME:\n                        newVal = this._valueMin();\n                        break;\n                    case $.ui.keyCode.END:\n                        newVal = this._valueMax();\n                        break;\n                    case $.ui.keyCode.PAGE_UP:\n                        newVal = this._trimAlignValue(curVal + ((this._valueMax() - this._valueMin()) / numPages));\n                        break;\n                    case $.ui.keyCode.PAGE_DOWN:\n                        newVal = this._trimAlignValue(curVal - ((this._valueMax() - this._valueMin()) / numPages));\n                        break;\n                    case $.ui.keyCode.UP:\n                    case $.ui.keyCode.RIGHT:\n                        if (curVal === this._valueMax()) {\n                            return;\n                        }\n                        newVal = this._trimAlignValue(curVal + step);\n                        break;\n                    case $.ui.keyCode.DOWN:\n                    case $.ui.keyCode.LEFT:\n                        if (curVal === this._valueMin()) {\n                            return;\n                        }\n                        newVal = this._trimAlignValue(curVal - step);\n                        break;\n                }\n\n                this._slide(event, index, newVal);\n            },\n            click: function (event) {\n                event.preventDefault();\n            },\n            keyup: function (event) {\n                var index = $(event.target).data(\"ui-slider-handle-index\");\n\n                if (this._keySliding) {\n                    this._keySliding = false;\n                    this._stop(event, index);\n                    this._change(event, index);\n                    $(event.target).removeClass(\"ui-state-active\");\n                }\n            }\n        }\n\n    });\n\n});\n","jquery/ui-modules/autocomplete.js":"/*!\n * jQuery UI Autocomplete - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/autocomplete/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/menu'\n], function ($, undefined) {\n\n    $.widget(\"ui.autocomplete\", {\n        version: \"1.10.4\",\n        defaultElement: \"<input>\",\n        options: {\n            appendTo: null,\n            autoFocus: false,\n            delay: 300,\n            minLength: 1,\n            position: {\n                my: \"left top\",\n                at: \"left bottom\",\n                collision: \"none\"\n            },\n            source: null,\n\n            // callbacks\n            change: null,\n            close: null,\n            focus: null,\n            open: null,\n            response: null,\n            search: null,\n            select: null\n        },\n\n        requestIndex: 0,\n        pending: 0,\n\n        _create: function () {\n            // Some browsers only repeat keydown events, not keypress events,\n            // so we use the suppressKeyPress flag to determine if we've already\n            // handled the keydown event. #7269\n            // Unfortunately the code for & in keypress is the same as the up arrow,\n            // so we use the suppressKeyPressRepeat flag to avoid handling keypress\n            // events when we know the keydown event was used to modify the\n            // search term. #7799\n            var suppressKeyPress, suppressKeyPressRepeat, suppressInput,\n                nodeName = this.element[0].nodeName.toLowerCase(),\n                isTextarea = nodeName === \"textarea\",\n                isInput = nodeName === \"input\";\n\n            this.isMultiLine =\n                // Textareas are always multi-line\n                isTextarea ? true :\n                    // Inputs are always single-line, even if inside a contentEditable element\n                    // IE also treats inputs as contentEditable\n                    isInput ? false :\n                        // All other element types are determined by whether or not they're contentEditable\n                        this.element.prop(\"isContentEditable\");\n\n            this.valueMethod = this.element[isTextarea || isInput ? \"val\" : \"text\"];\n            this.isNewMenu = true;\n\n            this.element\n                .addClass(\"ui-autocomplete-input\")\n                .attr(\"autocomplete\", \"off\");\n\n            this._on(this.element, {\n                keydown: function (event) {\n                    if (this.element.prop(\"readOnly\")) {\n                        suppressKeyPress = true;\n                        suppressInput = true;\n                        suppressKeyPressRepeat = true;\n                        return;\n                    }\n\n                    suppressKeyPress = false;\n                    suppressInput = false;\n                    suppressKeyPressRepeat = false;\n                    var keyCode = $.ui.keyCode;\n                    switch (event.keyCode) {\n                        case keyCode.PAGE_UP:\n                            suppressKeyPress = true;\n                            this._move(\"previousPage\", event);\n                            break;\n                        case keyCode.PAGE_DOWN:\n                            suppressKeyPress = true;\n                            this._move(\"nextPage\", event);\n                            break;\n                        case keyCode.UP:\n                            suppressKeyPress = true;\n                            this._keyEvent(\"previous\", event);\n                            break;\n                        case keyCode.DOWN:\n                            suppressKeyPress = true;\n                            this._keyEvent(\"next\", event);\n                            break;\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            // when menu is open and has focus\n                            if (this.menu.active) {\n                                // #6055 - Opera still allows the keypress to occur\n                                // which causes forms to submit\n                                suppressKeyPress = true;\n                                event.preventDefault();\n                                this.menu.select(event);\n                            }\n                            break;\n                        case keyCode.TAB:\n                            if (this.menu.active) {\n                                this.menu.select(event);\n                            }\n                            break;\n                        case keyCode.ESCAPE:\n                            if (this.menu.element.is(\":visible\")) {\n                                this._value(this.term);\n                                this.close(event);\n                                // Different browsers have different default behavior for escape\n                                // Single press can mean undo or clear\n                                // Double press in IE means clear the whole form\n                                event.preventDefault();\n                            }\n                            break;\n                        default:\n                            suppressKeyPressRepeat = true;\n                            // search timeout should be triggered before the input value is changed\n                            this._searchTimeout(event);\n                            break;\n                    }\n                },\n                keypress: function (event) {\n                    if (suppressKeyPress) {\n                        suppressKeyPress = false;\n                        if (!this.isMultiLine || this.menu.element.is(\":visible\")) {\n                            event.preventDefault();\n                        }\n                        return;\n                    }\n                    if (suppressKeyPressRepeat) {\n                        return;\n                    }\n\n                    // replicate some key handlers to allow them to repeat in Firefox and Opera\n                    var keyCode = $.ui.keyCode;\n                    switch (event.keyCode) {\n                        case keyCode.PAGE_UP:\n                            this._move(\"previousPage\", event);\n                            break;\n                        case keyCode.PAGE_DOWN:\n                            this._move(\"nextPage\", event);\n                            break;\n                        case keyCode.UP:\n                            this._keyEvent(\"previous\", event);\n                            break;\n                        case keyCode.DOWN:\n                            this._keyEvent(\"next\", event);\n                            break;\n                    }\n                },\n                input: function (event) {\n                    if (suppressInput) {\n                        suppressInput = false;\n                        event.preventDefault();\n                        return;\n                    }\n                    this._searchTimeout(event);\n                },\n                focus: function () {\n                    this.selectedItem = null;\n                    this.previous = this._value();\n                },\n                blur: function (event) {\n                    if (this.cancelBlur) {\n                        delete this.cancelBlur;\n                        return;\n                    }\n\n                    clearTimeout(this.searching);\n                    this.close(event);\n                    this._change(event);\n                }\n            });\n\n            this._initSource();\n            this.menu = $(\"<ul>\")\n                .addClass(\"ui-autocomplete ui-front\")\n                .appendTo(this._appendTo())\n                .menu({\n                    // disable ARIA support, the live region takes care of that\n                    role: null\n                })\n                .hide()\n                .data(\"ui-menu\");\n\n            this._on(this.menu.element, {\n                mousedown: function (event) {\n                    // prevent moving focus out of the text field\n                    event.preventDefault();\n\n                    // IE doesn't prevent moving focus even with event.preventDefault()\n                    // so we set a flag to know when we should ignore the blur event\n                    this.cancelBlur = true;\n                    this._delay(function () {\n                        delete this.cancelBlur;\n                    });\n\n                    // clicking on the scrollbar causes focus to shift to the body\n                    // but we can't detect a mouseup or a click immediately afterward\n                    // so we have to track the next mousedown and close the menu if\n                    // the user clicks somewhere outside of the autocomplete\n                    var menuElement = this.menu.element[0];\n                    if (!$(event.target).closest(\".ui-menu-item\").length) {\n                        this._delay(function () {\n                            var that = this;\n                            this.document.one(\"mousedown\", function (event) {\n                                if (event.target !== that.element[0] &&\n                                    event.target !== menuElement &&\n                                    !$.contains(menuElement, event.target)) {\n                                    that.close();\n                                }\n                            });\n                        });\n                    }\n                },\n                menufocus: function (event, ui) {\n                    // support: Firefox\n                    // Prevent accidental activation of menu items in Firefox (#7024 #9118)\n                    if (this.isNewMenu) {\n                        this.isNewMenu = false;\n                        if (event.originalEvent && /^mouse/.test(event.originalEvent.type)) {\n                            this.menu.blur();\n\n                            this.document.one(\"mousemove\", function () {\n                                $(event.target).trigger(event.originalEvent);\n                            });\n\n                            return;\n                        }\n                    }\n\n                    var item = ui.item.data(\"ui-autocomplete-item\");\n                    if (false !== this._trigger(\"focus\", event, {item: item})) {\n                        // use value to match what will end up in the input, if it was a key event\n                        if (event.originalEvent && /^key/.test(event.originalEvent.type)) {\n                            this._value(item.value);\n                        }\n                    } else {\n                        // Normally the input is populated with the item's value as the\n                        // menu is navigated, causing screen readers to notice a change and\n                        // announce the item. Since the focus event was canceled, this doesn't\n                        // happen, so we update the live region so that screen readers can\n                        // still notice the change and announce it.\n                        this.liveRegion.text(item.value);\n                    }\n                },\n                menuselect: function (event, ui) {\n                    var item = ui.item.data(\"ui-autocomplete-item\"),\n                        previous = this.previous;\n\n                    // only trigger when focus was lost (click on menu)\n                    if (this.element[0] !== this.document[0].activeElement) {\n                        this.element.focus();\n                        this.previous = previous;\n                        // #6109 - IE triggers two focus events and the second\n                        // is asynchronous, so we need to reset the previous\n                        // term synchronously and asynchronously :-(\n                        this._delay(function () {\n                            this.previous = previous;\n                            this.selectedItem = item;\n                        });\n                    }\n\n                    if (false !== this._trigger(\"select\", event, {item: item})) {\n                        this._value(item.value);\n                    }\n                    // reset the term after the select event\n                    // this allows custom select handling to work properly\n                    this.term = this._value();\n\n                    this.close(event);\n                    this.selectedItem = item;\n                }\n            });\n\n            this.liveRegion = $(\"<span>\", {\n                role: \"status\",\n                \"aria-live\": \"polite\"\n            })\n                .addClass(\"ui-helper-hidden-accessible\")\n                .insertBefore(this.element);\n\n            // turning off autocomplete prevents the browser from remembering the\n            // value when navigating through history, so we re-enable autocomplete\n            // if the page is unloaded before the widget is destroyed. #7790\n            this._on(this.window, {\n                beforeunload: function () {\n                    this.element.removeAttr(\"autocomplete\");\n                }\n            });\n        },\n\n        _destroy: function () {\n            clearTimeout(this.searching);\n            this.element\n                .removeClass(\"ui-autocomplete-input\")\n                .removeAttr(\"autocomplete\");\n            this.menu.element.remove();\n            this.liveRegion.remove();\n        },\n\n        _setOption: function (key, value) {\n            this._super(key, value);\n            if (key === \"source\") {\n                this._initSource();\n            }\n            if (key === \"appendTo\") {\n                this.menu.element.appendTo(this._appendTo());\n            }\n            if (key === \"disabled\" && value && this.xhr) {\n                this.xhr.abort();\n            }\n        },\n\n        _appendTo: function () {\n            var element = this.options.appendTo;\n\n            if (element) {\n                element = element.jquery || element.nodeType ?\n                    $(element) :\n                    this.document.find(element).eq(0);\n            }\n\n            if (!element) {\n                element = this.element.closest(\".ui-front\");\n            }\n\n            if (!element.length) {\n                element = this.document[0].body;\n            }\n\n            return element;\n        },\n\n        _initSource: function () {\n            var array, url,\n                that = this;\n            if ($.isArray(this.options.source)) {\n                array = this.options.source;\n                this.source = function (request, response) {\n                    response($.ui.autocomplete.filter(array, request.term));\n                };\n            } else if (typeof this.options.source === \"string\") {\n                url = this.options.source;\n                this.source = function (request, response) {\n                    if (that.xhr) {\n                        that.xhr.abort();\n                    }\n                    that.xhr = $.ajax({\n                        url: url,\n                        data: request,\n                        dataType: \"json\",\n                        success: function (data) {\n                            response(data);\n                        },\n                        error: function () {\n                            response([]);\n                        }\n                    });\n                };\n            } else {\n                this.source = this.options.source;\n            }\n        },\n\n        _searchTimeout: function (event) {\n            clearTimeout(this.searching);\n            this.searching = this._delay(function () {\n                // only search if the value has changed\n                if (this.term !== this._value()) {\n                    this.selectedItem = null;\n                    this.search(null, event);\n                }\n            }, this.options.delay);\n        },\n\n        search: function (value, event) {\n            value = value != null ? value : this._value();\n\n            // always save the actual value, not the one passed as an argument\n            this.term = this._value();\n\n            if (value.length < this.options.minLength) {\n                return this.close(event);\n            }\n\n            if (this._trigger(\"search\", event) === false) {\n                return;\n            }\n\n            return this._search(value);\n        },\n\n        _search: function (value) {\n            this.pending++;\n            this.element.addClass(\"ui-autocomplete-loading\");\n            this.cancelSearch = false;\n\n            this.source({term: value}, this._response());\n        },\n\n        _response: function () {\n            var index = ++this.requestIndex;\n\n            return $.proxy(function (content) {\n                if (index === this.requestIndex) {\n                    this.__response(content);\n                }\n\n                this.pending--;\n                if (!this.pending) {\n                    this.element.removeClass(\"ui-autocomplete-loading\");\n                }\n            }, this);\n        },\n\n        __response: function (content) {\n            if (content) {\n                content = this._normalize(content);\n            }\n            this._trigger(\"response\", null, {content: content});\n            if (!this.options.disabled && content && content.length && !this.cancelSearch) {\n                this._suggest(content);\n                this._trigger(\"open\");\n            } else {\n                // use ._close() instead of .close() so we don't cancel future searches\n                this._close();\n            }\n        },\n\n        close: function (event) {\n            this.cancelSearch = true;\n            this._close(event);\n        },\n\n        _close: function (event) {\n            if (this.menu.element.is(\":visible\")) {\n                this.menu.element.hide();\n                this.menu.blur();\n                this.isNewMenu = true;\n                this._trigger(\"close\", event);\n            }\n        },\n\n        _change: function (event) {\n            if (this.previous !== this._value()) {\n                this._trigger(\"change\", event, {item: this.selectedItem});\n            }\n        },\n\n        _normalize: function (items) {\n            // assume all items have the right format when the first item is complete\n            if (items.length && items[0].label && items[0].value) {\n                return items;\n            }\n            return $.map(items, function (item) {\n                if (typeof item === \"string\") {\n                    return {\n                        label: item,\n                        value: item\n                    };\n                }\n                return $.extend({\n                    label: item.label || item.value,\n                    value: item.value || item.label\n                }, item);\n            });\n        },\n\n        _suggest: function (items) {\n            var ul = this.menu.element.empty();\n            this._renderMenu(ul, items);\n            this.isNewMenu = true;\n            this.menu.refresh();\n\n            // size and position menu\n            ul.show();\n            this._resizeMenu();\n            ul.position($.extend({\n                of: this.element\n            }, this.options.position));\n\n            if (this.options.autoFocus) {\n                this.menu.next();\n            }\n        },\n\n        _resizeMenu: function () {\n            var ul = this.menu.element;\n            ul.outerWidth(Math.max(\n                // Firefox wraps long text (possibly a rounding bug)\n                // so we add 1px to avoid the wrapping (#7513)\n                ul.width(\"\").outerWidth() + 1,\n                this.element.outerWidth()\n            ));\n        },\n\n        _renderMenu: function (ul, items) {\n            var that = this;\n            $.each(items, function (index, item) {\n                that._renderItemData(ul, item);\n            });\n        },\n\n        _renderItemData: function (ul, item) {\n            return this._renderItem(ul, item).data(\"ui-autocomplete-item\", item);\n        },\n\n        _renderItem: function (ul, item) {\n            return $(\"<li>\")\n                .append($(\"<a>\").text(item.label))\n                .appendTo(ul);\n        },\n\n        _move: function (direction, event) {\n            if (!this.menu.element.is(\":visible\")) {\n                this.search(null, event);\n                return;\n            }\n            if (this.menu.isFirstItem() && /^previous/.test(direction) ||\n                this.menu.isLastItem() && /^next/.test(direction)) {\n                this._value(this.term);\n                this.menu.blur();\n                return;\n            }\n            this.menu[direction](event);\n        },\n\n        widget: function () {\n            return this.menu.element;\n        },\n\n        _value: function () {\n            return this.valueMethod.apply(this.element, arguments);\n        },\n\n        _keyEvent: function (keyEvent, event) {\n            if (!this.isMultiLine || this.menu.element.is(\":visible\")) {\n                this._move(keyEvent, event);\n\n                // prevents moving cursor to beginning/end of the text field in some browsers\n                event.preventDefault();\n            }\n        }\n    });\n\n    $.extend($.ui.autocomplete, {\n        escapeRegex: function (value) {\n            return value.replace(/[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, \"\\\\$&\");\n        },\n        filter: function (array, term) {\n            var matcher = new RegExp($.ui.autocomplete.escapeRegex(term), \"i\");\n            return $.grep(array, function (value) {\n                return matcher.test(value.label || value.value || value);\n            });\n        }\n    });\n\n\n    // live region extension, adding a `messages` option\n    // NOTE: This is an experimental API. We are still investigating\n    // a full solution for string manipulation and internationalization.\n    $.widget(\"ui.autocomplete\", $.ui.autocomplete, {\n        options: {\n            messages: {\n                noResults: \"No search results.\",\n                results: function (amount) {\n                    return amount + (amount > 1 ? \" results are\" : \" result is\") +\n                        \" available, use up and down arrow keys to navigate.\";\n                }\n            }\n        },\n\n        __response: function (content) {\n            var message;\n            this._superApply(arguments);\n            if (this.options.disabled || this.cancelSearch) {\n                return;\n            }\n            if (content && content.length) {\n                message = this.options.messages.results(content.length);\n            } else {\n                message = this.options.messages.noResults;\n            }\n            this.liveRegion.text(message);\n        }\n    });\n});\n","jquery/ui-modules/effect-fold.js":"/*!\n * jQuery UI Effects Fold - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/fold-effect/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.fold = function (o, done) {\n\n        // Create element\n        var el = $(this),\n            props = [\"position\", \"top\", \"bottom\", \"left\", \"right\", \"height\", \"width\"],\n            mode = $.effects.setMode(el, o.mode || \"hide\"),\n            show = mode === \"show\",\n            hide = mode === \"hide\",\n            size = o.size || 15,\n            percent = /([0-9]+)%/.exec(size),\n            horizFirst = !!o.horizFirst,\n            widthFirst = show !== horizFirst,\n            ref = widthFirst ? [\"width\", \"height\"] : [\"height\", \"width\"],\n            duration = o.duration / 2,\n            wrapper, distance,\n            animation1 = {},\n            animation2 = {};\n\n        $.effects.save(el, props);\n        el.show();\n\n        // Create Wrapper\n        wrapper = $.effects.createWrapper(el).css({\n            overflow: \"hidden\"\n        });\n        distance = widthFirst ?\n            [wrapper.width(), wrapper.height()] :\n            [wrapper.height(), wrapper.width()];\n\n        if (percent) {\n            size = parseInt(percent[1], 10) / 100 * distance[hide ? 0 : 1];\n        }\n        if (show) {\n            wrapper.css(horizFirst ? {\n                height: 0,\n                width: size\n            } : {\n                height: size,\n                width: 0\n            });\n        }\n\n        // Animation\n        animation1[ref[0]] = show ? distance[0] : size;\n        animation2[ref[1]] = show ? distance[1] : 0;\n\n        // Animate\n        wrapper\n            .animate(animation1, duration, o.easing)\n            .animate(animation2, duration, o.easing, function () {\n                if (hide) {\n                    el.hide();\n                }\n                $.effects.restore(el, props);\n                $.effects.removeWrapper(el);\n                done();\n            });\n    };\n\n});\n","jquery/ui-modules/draggable.js":"/*!\n * jQuery UI Draggable - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/draggable/\n *\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/mouse'\n], function ($, undefined) {\n\n    $.widget(\"ui.draggable\", $.ui.mouse, {\n        version: \"1.10.4\",\n        widgetEventPrefix: \"drag\",\n        options: {\n            addClasses: true,\n            appendTo: \"parent\",\n            axis: false,\n            connectToSortable: false,\n            containment: false,\n            cursor: \"auto\",\n            cursorAt: false,\n            grid: false,\n            handle: false,\n            helper: \"original\",\n            iframeFix: false,\n            opacity: false,\n            refreshPositions: false,\n            revert: false,\n            revertDuration: 500,\n            scope: \"default\",\n            scroll: true,\n            scrollSensitivity: 20,\n            scrollSpeed: 20,\n            snap: false,\n            snapMode: \"both\",\n            snapTolerance: 20,\n            stack: false,\n            zIndex: false,\n\n            // callbacks\n            drag: null,\n            start: null,\n            stop: null\n        },\n        _create: function () {\n\n            if (this.options.helper === \"original\" && !(/^(?:r|a|f)/).test(this.element.css(\"position\"))) {\n                this.element[0].style.position = \"relative\";\n            }\n            if (this.options.addClasses) {\n                this.element.addClass(\"ui-draggable\");\n            }\n            if (this.options.disabled) {\n                this.element.addClass(\"ui-draggable-disabled\");\n            }\n\n            this._mouseInit();\n\n        },\n\n        _destroy: function () {\n            this.element.removeClass(\"ui-draggable ui-draggable-dragging ui-draggable-disabled\");\n            this._mouseDestroy();\n        },\n\n        _mouseCapture: function (event) {\n\n            var o = this.options;\n\n            // among others, prevent a drag on a resizable-handle\n            if (this.helper || o.disabled || $(event.target).closest(\".ui-resizable-handle\").length > 0) {\n                return false;\n            }\n\n            //Quit if we're not on a valid handle\n            this.handle = this._getHandle(event);\n            if (!this.handle) {\n                return false;\n            }\n\n            $(o.iframeFix === true ? \"iframe\" : o.iframeFix).each(function () {\n                $(\"<div class='ui-draggable-iframeFix' style='background: #fff;'></div>\")\n                    .css({\n                        width: this.offsetWidth + \"px\", height: this.offsetHeight + \"px\",\n                        position: \"absolute\", opacity: \"0.001\", zIndex: 1000\n                    })\n                    .css($(this).offset())\n                    .appendTo(\"body\");\n            });\n\n            return true;\n\n        },\n\n        _mouseStart: function (event) {\n\n            var o = this.options;\n\n            //Create and append the visible helper\n            this.helper = this._createHelper(event);\n\n            this.helper.addClass(\"ui-draggable-dragging\");\n\n            //Cache the helper size\n            this._cacheHelperProportions();\n\n            //If ddmanager is used for droppables, set the global draggable\n            if ($.ui.ddmanager) {\n                $.ui.ddmanager.current = this;\n            }\n\n            /*\n             * - Position generation -\n             * This block generates everything position related - it's the core of draggables.\n             */\n\n            //Cache the margins of the original element\n            this._cacheMargins();\n\n            //Store the helper's css position\n            this.cssPosition = this.helper.css(\"position\");\n            this.scrollParent = this.helper.scrollParent();\n            this.offsetParent = this.helper.offsetParent();\n            this.offsetParentCssPosition = this.offsetParent.css(\"position\");\n\n            //The element's absolute position on the page minus margins\n            this.offset = this.positionAbs = this.element.offset();\n            this.offset = {\n                top: this.offset.top - this.margins.top,\n                left: this.offset.left - this.margins.left\n            };\n\n            //Reset scroll cache\n            this.offset.scroll = false;\n\n            $.extend(this.offset, {\n                click: { //Where the click happened, relative to the element\n                    left: event.pageX - this.offset.left,\n                    top: event.pageY - this.offset.top\n                },\n                parent: this._getParentOffset(),\n                relative: this._getRelativeOffset() //This is a relative to absolute position minus the actual position calculation - only used for relative positioned helper\n            });\n\n            //Generate the original position\n            this.originalPosition = this.position = this._generatePosition(event);\n            this.originalPageX = event.pageX;\n            this.originalPageY = event.pageY;\n\n            //Adjust the mouse offset relative to the helper if \"cursorAt\" is supplied\n            (o.cursorAt && this._adjustOffsetFromHelper(o.cursorAt));\n\n            //Set a containment if given in the options\n            this._setContainment();\n\n            //Trigger event + callbacks\n            if (this._trigger(\"start\", event) === false) {\n                this._clear();\n                return false;\n            }\n\n            //Recache the helper size\n            this._cacheHelperProportions();\n\n            //Prepare the droppable offsets\n            if ($.ui.ddmanager && !o.dropBehaviour) {\n                $.ui.ddmanager.prepareOffsets(this, event);\n            }\n\n\n            this._mouseDrag(event, true); //Execute the drag once - this causes the helper not to be visible before getting its correct position\n\n            //If the ddmanager is used for droppables, inform the manager that dragging has started (see #5003)\n            if ($.ui.ddmanager) {\n                $.ui.ddmanager.dragStart(this, event);\n            }\n\n            return true;\n        },\n\n        _mouseDrag: function (event, noPropagation) {\n            // reset any necessary cached properties (see #5009)\n            if (this.offsetParentCssPosition === \"fixed\") {\n                this.offset.parent = this._getParentOffset();\n            }\n\n            //Compute the helpers position\n            this.position = this._generatePosition(event);\n            this.positionAbs = this._convertPositionTo(\"absolute\");\n\n            //Call plugins and callbacks and use the resulting position if something is returned\n            if (!noPropagation) {\n                var ui = this._uiHash();\n                if (this._trigger(\"drag\", event, ui) === false) {\n                    this._mouseUp({});\n                    return false;\n                }\n                this.position = ui.position;\n            }\n\n            if (!this.options.axis || this.options.axis !== \"y\") {\n                this.helper[0].style.left = this.position.left + \"px\";\n            }\n            if (!this.options.axis || this.options.axis !== \"x\") {\n                this.helper[0].style.top = this.position.top + \"px\";\n            }\n            if ($.ui.ddmanager) {\n                $.ui.ddmanager.drag(this, event);\n            }\n\n            return false;\n        },\n\n        _mouseStop: function (event) {\n\n            //If we are using droppables, inform the manager about the drop\n            var that = this,\n                dropped = false;\n            if ($.ui.ddmanager && !this.options.dropBehaviour) {\n                dropped = $.ui.ddmanager.drop(this, event);\n            }\n\n            //if a drop comes from outside (a sortable)\n            if (this.dropped) {\n                dropped = this.dropped;\n                this.dropped = false;\n            }\n\n            //if the original element is no longer in the DOM don't bother to continue (see #8269)\n            if (this.options.helper === \"original\" && !$.contains(this.element[0].ownerDocument, this.element[0])) {\n                return false;\n            }\n\n            if ((this.options.revert === \"invalid\" && !dropped) || (this.options.revert === \"valid\" && dropped) || this.options.revert === true || ($.isFunction(this.options.revert) && this.options.revert.call(this.element, dropped))) {\n                $(this.helper).animate(this.originalPosition, parseInt(this.options.revertDuration, 10), function () {\n                    if (that._trigger(\"stop\", event) !== false) {\n                        that._clear();\n                    }\n                });\n            } else {\n                if (this._trigger(\"stop\", event) !== false) {\n                    this._clear();\n                }\n            }\n\n            return false;\n        },\n\n        _mouseUp: function (event) {\n            //Remove frame helpers\n            $(\"div.ui-draggable-iframeFix\").each(function () {\n                this.parentNode.removeChild(this);\n            });\n\n            //If the ddmanager is used for droppables, inform the manager that dragging has stopped (see #5003)\n            if ($.ui.ddmanager) {\n                $.ui.ddmanager.dragStop(this, event);\n            }\n\n            return $.ui.mouse.prototype._mouseUp.call(this, event);\n        },\n\n        cancel: function () {\n\n            if (this.helper.is(\".ui-draggable-dragging\")) {\n                this._mouseUp({});\n            } else {\n                this._clear();\n            }\n\n            return this;\n\n        },\n\n        _getHandle: function (event) {\n            return this.options.handle ?\n                !!$(event.target).closest(this.element.find(this.options.handle)).length :\n                true;\n        },\n\n        _createHelper: function (event) {\n\n            var o = this.options,\n                helper = $.isFunction(o.helper) ? $(o.helper.apply(this.element[0], [event])) : (o.helper === \"clone\" ? this.element.clone().removeAttr(\"id\") : this.element);\n\n            if (!helper.parents(\"body\").length) {\n                helper.appendTo((o.appendTo === \"parent\" ? this.element[0].parentNode : o.appendTo));\n            }\n\n            if (helper[0] !== this.element[0] && !(/(fixed|absolute)/).test(helper.css(\"position\"))) {\n                helper.css(\"position\", \"absolute\");\n            }\n\n            return helper;\n\n        },\n\n        _adjustOffsetFromHelper: function (obj) {\n            if (typeof obj === \"string\") {\n                obj = obj.split(\" \");\n            }\n            if ($.isArray(obj)) {\n                obj = {left: +obj[0], top: +obj[1] || 0};\n            }\n            if (\"left\" in obj) {\n                this.offset.click.left = obj.left + this.margins.left;\n            }\n            if (\"right\" in obj) {\n                this.offset.click.left = this.helperProportions.width - obj.right + this.margins.left;\n            }\n            if (\"top\" in obj) {\n                this.offset.click.top = obj.top + this.margins.top;\n            }\n            if (\"bottom\" in obj) {\n                this.offset.click.top = this.helperProportions.height - obj.bottom + this.margins.top;\n            }\n        },\n\n        _getParentOffset: function () {\n\n            //Get the offsetParent and cache its position\n            var po = this.offsetParent.offset();\n\n            // This is a special case where we need to modify a offset calculated on start, since the following happened:\n            // 1. The position of the helper is absolute, so it's position is calculated based on the next positioned parent\n            // 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't the document, which means that\n            //    the scroll is included in the initial calculation of the offset of the parent, and never recalculated upon drag\n            if (this.cssPosition === \"absolute\" && this.scrollParent[0] !== document && $.contains(this.scrollParent[0], this.offsetParent[0])) {\n                po.left += this.scrollParent.scrollLeft();\n                po.top += this.scrollParent.scrollTop();\n            }\n\n            //This needs to be actually done for all browsers, since pageX/pageY includes this information\n            //Ugly IE fix\n            if ((this.offsetParent[0] === document.body) ||\n                (this.offsetParent[0].tagName && this.offsetParent[0].tagName.toLowerCase() === \"html\" && $.ui.ie)) {\n                po = {top: 0, left: 0};\n            }\n\n            return {\n                top: po.top + (parseInt(this.offsetParent.css(\"borderTopWidth\"), 10) || 0),\n                left: po.left + (parseInt(this.offsetParent.css(\"borderLeftWidth\"), 10) || 0)\n            };\n\n        },\n\n        _getRelativeOffset: function () {\n\n            if (this.cssPosition === \"relative\") {\n                var p = this.element.position();\n                return {\n                    top: p.top - (parseInt(this.helper.css(\"top\"), 10) || 0) + this.scrollParent.scrollTop(),\n                    left: p.left - (parseInt(this.helper.css(\"left\"), 10) || 0) + this.scrollParent.scrollLeft()\n                };\n            } else {\n                return {top: 0, left: 0};\n            }\n\n        },\n\n        _cacheMargins: function () {\n            this.margins = {\n                left: (parseInt(this.element.css(\"marginLeft\"), 10) || 0),\n                top: (parseInt(this.element.css(\"marginTop\"), 10) || 0),\n                right: (parseInt(this.element.css(\"marginRight\"), 10) || 0),\n                bottom: (parseInt(this.element.css(\"marginBottom\"), 10) || 0)\n            };\n        },\n\n        _cacheHelperProportions: function () {\n            this.helperProportions = {\n                width: this.helper.outerWidth(),\n                height: this.helper.outerHeight()\n            };\n        },\n\n        _setContainment: function () {\n\n            var over, c, ce,\n                o = this.options;\n\n            if (!o.containment) {\n                this.containment = null;\n                return;\n            }\n\n            if (o.containment === \"window\") {\n                this.containment = [\n                    $(window).scrollLeft() - this.offset.relative.left - this.offset.parent.left,\n                    $(window).scrollTop() - this.offset.relative.top - this.offset.parent.top,\n                    $(window).scrollLeft() + $(window).width() - this.helperProportions.width - this.margins.left,\n                    $(window).scrollTop() + ($(window).height() || document.body.parentNode.scrollHeight) - this.helperProportions.height - this.margins.top\n                ];\n                return;\n            }\n\n            if (o.containment === \"document\") {\n                this.containment = [\n                    0,\n                    0,\n                    $(document).width() - this.helperProportions.width - this.margins.left,\n                    ($(document).height() || document.body.parentNode.scrollHeight) - this.helperProportions.height - this.margins.top\n                ];\n                return;\n            }\n\n            if (o.containment.constructor === Array) {\n                this.containment = o.containment;\n                return;\n            }\n\n            if (o.containment === \"parent\") {\n                o.containment = this.helper[0].parentNode;\n            }\n\n            c = $(o.containment);\n            ce = c[0];\n\n            if (!ce) {\n                return;\n            }\n\n            over = c.css(\"overflow\") !== \"hidden\";\n\n            this.containment = [\n                (parseInt(c.css(\"borderLeftWidth\"), 10) || 0) + (parseInt(c.css(\"paddingLeft\"), 10) || 0),\n                (parseInt(c.css(\"borderTopWidth\"), 10) || 0) + (parseInt(c.css(\"paddingTop\"), 10) || 0),\n                (over ? Math.max(ce.scrollWidth, ce.offsetWidth) : ce.offsetWidth) - (parseInt(c.css(\"borderRightWidth\"), 10) || 0) - (parseInt(c.css(\"paddingRight\"), 10) || 0) - this.helperProportions.width - this.margins.left - this.margins.right,\n                (over ? Math.max(ce.scrollHeight, ce.offsetHeight) : ce.offsetHeight) - (parseInt(c.css(\"borderBottomWidth\"), 10) || 0) - (parseInt(c.css(\"paddingBottom\"), 10) || 0) - this.helperProportions.height - this.margins.top - this.margins.bottom\n            ];\n            this.relative_container = c;\n        },\n\n        _convertPositionTo: function (d, pos) {\n\n            if (!pos) {\n                pos = this.position;\n            }\n\n            var mod = d === \"absolute\" ? 1 : -1,\n                scroll = this.cssPosition === \"absolute\" && !(this.scrollParent[0] !== document && $.contains(this.scrollParent[0], this.offsetParent[0])) ? this.offsetParent : this.scrollParent;\n\n            //Cache the scroll\n            if (!this.offset.scroll) {\n                this.offset.scroll = {top: scroll.scrollTop(), left: scroll.scrollLeft()};\n            }\n\n            return {\n                top: (\n                    pos.top +\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n                    this.offset.relative.top * mod +\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.parent.top * mod -\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n                    ((this.cssPosition === \"fixed\" ? -this.scrollParent.scrollTop() : this.offset.scroll.top) * mod)\n                ),\n                left: (\n                    pos.left +\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n                    this.offset.relative.left * mod +\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.parent.left * mod -\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n                    ((this.cssPosition === \"fixed\" ? -this.scrollParent.scrollLeft() : this.offset.scroll.left) * mod)\n                )\n            };\n\n        },\n\n        _generatePosition: function (event) {\n\n            var containment, co, top, left,\n                o = this.options,\n                scroll = this.cssPosition === \"absolute\" && !(this.scrollParent[0] !== document && $.contains(this.scrollParent[0], this.offsetParent[0])) ? this.offsetParent : this.scrollParent,\n                pageX = event.pageX,\n                pageY = event.pageY;\n\n            //Cache the scroll\n            if (!this.offset.scroll) {\n                this.offset.scroll = {top: scroll.scrollTop(), left: scroll.scrollLeft()};\n            }\n\n            /*\n             * - Position constraining -\n             * Constrain the position to a mix of grid, containment.\n             */\n\n            // If we are not dragging yet, we won't check for options\n            if (this.originalPosition) {\n                if (this.containment) {\n                    if (this.relative_container) {\n                        co = this.relative_container.offset();\n                        containment = [\n                            this.containment[0] + co.left,\n                            this.containment[1] + co.top,\n                            this.containment[2] + co.left,\n                            this.containment[3] + co.top\n                        ];\n                    } else {\n                        containment = this.containment;\n                    }\n\n                    if (event.pageX - this.offset.click.left < containment[0]) {\n                        pageX = containment[0] + this.offset.click.left;\n                    }\n                    if (event.pageY - this.offset.click.top < containment[1]) {\n                        pageY = containment[1] + this.offset.click.top;\n                    }\n                    if (event.pageX - this.offset.click.left > containment[2]) {\n                        pageX = containment[2] + this.offset.click.left;\n                    }\n                    if (event.pageY - this.offset.click.top > containment[3]) {\n                        pageY = containment[3] + this.offset.click.top;\n                    }\n                }\n\n                if (o.grid) {\n                    //Check for grid elements set to 0 to prevent divide by 0 error causing invalid argument errors in IE (see ticket #6950)\n                    top = o.grid[1] ? this.originalPageY + Math.round((pageY - this.originalPageY) / o.grid[1]) * o.grid[1] : this.originalPageY;\n                    pageY = containment ? ((top - this.offset.click.top >= containment[1] || top - this.offset.click.top > containment[3]) ? top : ((top - this.offset.click.top >= containment[1]) ? top - o.grid[1] : top + o.grid[1])) : top;\n\n                    left = o.grid[0] ? this.originalPageX + Math.round((pageX - this.originalPageX) / o.grid[0]) * o.grid[0] : this.originalPageX;\n                    pageX = containment ? ((left - this.offset.click.left >= containment[0] || left - this.offset.click.left > containment[2]) ? left : ((left - this.offset.click.left >= containment[0]) ? left - o.grid[0] : left + o.grid[0])) : left;\n                }\n\n            }\n\n            return {\n                top: (\n                    pageY -\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n                    this.offset.click.top -\t\t\t\t\t\t\t\t\t\t\t\t// Click offset (relative to the element)\n                    this.offset.relative.top -\t\t\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.parent.top +\t\t\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n                    (this.cssPosition === \"fixed\" ? -this.scrollParent.scrollTop() : this.offset.scroll.top)\n                ),\n                left: (\n                    pageX -\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n                    this.offset.click.left -\t\t\t\t\t\t\t\t\t\t\t\t// Click offset (relative to the element)\n                    this.offset.relative.left -\t\t\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.parent.left +\t\t\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n                    (this.cssPosition === \"fixed\" ? -this.scrollParent.scrollLeft() : this.offset.scroll.left)\n                )\n            };\n\n        },\n\n        _clear: function () {\n            this.helper.removeClass(\"ui-draggable-dragging\");\n            if (this.helper[0] !== this.element[0] && !this.cancelHelperRemoval) {\n                this.helper.remove();\n            }\n            this.helper = null;\n            this.cancelHelperRemoval = false;\n        },\n\n        // From now on bulk stuff - mainly helpers\n\n        _trigger: function (type, event, ui) {\n            ui = ui || this._uiHash();\n            $.ui.plugin.call(this, type, [event, ui]);\n            //The absolute position has to be recalculated after plugins\n            if (type === \"drag\") {\n                this.positionAbs = this._convertPositionTo(\"absolute\");\n            }\n            return $.Widget.prototype._trigger.call(this, type, event, ui);\n        },\n\n        plugins: {},\n\n        _uiHash: function () {\n            return {\n                helper: this.helper,\n                position: this.position,\n                originalPosition: this.originalPosition,\n                offset: this.positionAbs\n            };\n        }\n\n    });\n\n    $.ui.plugin.add(\"draggable\", \"connectToSortable\", {\n        start: function (event, ui) {\n\n            var inst = $(this).data(\"ui-draggable\"), o = inst.options,\n                uiSortable = $.extend({}, ui, {item: inst.element});\n            inst.sortables = [];\n            $(o.connectToSortable).each(function () {\n                var sortable = $.data(this, \"ui-sortable\");\n                if (sortable && !sortable.options.disabled) {\n                    inst.sortables.push({\n                        instance: sortable,\n                        shouldRevert: sortable.options.revert\n                    });\n                    sortable.refreshPositions();\t// Call the sortable's refreshPositions at drag start to refresh the containerCache since the sortable container cache is used in drag and needs to be up to date (this will ensure it's initialised as well as being kept in step with any changes that might have happened on the page).\n                    sortable._trigger(\"activate\", event, uiSortable);\n                }\n            });\n\n        },\n        stop: function (event, ui) {\n\n            //If we are still over the sortable, we fake the stop event of the sortable, but also remove helper\n            var inst = $(this).data(\"ui-draggable\"),\n                uiSortable = $.extend({}, ui, {item: inst.element});\n\n            $.each(inst.sortables, function () {\n                if (this.instance.isOver) {\n\n                    this.instance.isOver = 0;\n\n                    inst.cancelHelperRemoval = true; //Don't remove the helper in the draggable instance\n                    this.instance.cancelHelperRemoval = false; //Remove it in the sortable instance (so sortable plugins like revert still work)\n\n                    //The sortable revert is supported, and we have to set a temporary dropped variable on the draggable to support revert: \"valid/invalid\"\n                    if (this.shouldRevert) {\n                        this.instance.options.revert = this.shouldRevert;\n                    }\n\n                    //Trigger the stop of the sortable\n                    this.instance._mouseStop(event);\n\n                    this.instance.options.helper = this.instance.options._helper;\n\n                    //If the helper has been the original item, restore properties in the sortable\n                    if (inst.options.helper === \"original\") {\n                        this.instance.currentItem.css({top: \"auto\", left: \"auto\"});\n                    }\n\n                } else {\n                    this.instance.cancelHelperRemoval = false; //Remove the helper in the sortable instance\n                    this.instance._trigger(\"deactivate\", event, uiSortable);\n                }\n\n            });\n\n        },\n        drag: function (event, ui) {\n\n            var inst = $(this).data(\"ui-draggable\"), that = this;\n\n            $.each(inst.sortables, function () {\n\n                var innermostIntersecting = false,\n                    thisSortable = this;\n\n                //Copy over some variables to allow calling the sortable's native _intersectsWith\n                this.instance.positionAbs = inst.positionAbs;\n                this.instance.helperProportions = inst.helperProportions;\n                this.instance.offset.click = inst.offset.click;\n\n                if (this.instance._intersectsWith(this.instance.containerCache)) {\n                    innermostIntersecting = true;\n                    $.each(inst.sortables, function () {\n                        this.instance.positionAbs = inst.positionAbs;\n                        this.instance.helperProportions = inst.helperProportions;\n                        this.instance.offset.click = inst.offset.click;\n                        if (this !== thisSortable &&\n                            this.instance._intersectsWith(this.instance.containerCache) &&\n                            $.contains(thisSortable.instance.element[0], this.instance.element[0])\n                        ) {\n                            innermostIntersecting = false;\n                        }\n                        return innermostIntersecting;\n                    });\n                }\n\n\n                if (innermostIntersecting) {\n                    //If it intersects, we use a little isOver variable and set it once, so our move-in stuff gets fired only once\n                    if (!this.instance.isOver) {\n\n                        this.instance.isOver = 1;\n                        //Now we fake the start of dragging for the sortable instance,\n                        //by cloning the list group item, appending it to the sortable and using it as inst.currentItem\n                        //We can then fire the start event of the sortable with our passed browser event, and our own helper (so it doesn't create a new one)\n                        this.instance.currentItem = $(that).clone().removeAttr(\"id\").appendTo(this.instance.element).data(\"ui-sortable-item\", true);\n                        this.instance.options._helper = this.instance.options.helper; //Store helper option to later restore it\n                        this.instance.options.helper = function () {\n                            return ui.helper[0];\n                        };\n\n                        event.target = this.instance.currentItem[0];\n                        this.instance._mouseCapture(event, true);\n                        this.instance._mouseStart(event, true, true);\n\n                        //Because the browser event is way off the new appended portlet, we modify a couple of variables to reflect the changes\n                        this.instance.offset.click.top = inst.offset.click.top;\n                        this.instance.offset.click.left = inst.offset.click.left;\n                        this.instance.offset.parent.left -= inst.offset.parent.left - this.instance.offset.parent.left;\n                        this.instance.offset.parent.top -= inst.offset.parent.top - this.instance.offset.parent.top;\n\n                        inst._trigger(\"toSortable\", event);\n                        inst.dropped = this.instance.element; //draggable revert needs that\n                        //hack so receive/update callbacks work (mostly)\n                        inst.currentItem = inst.element;\n                        this.instance.fromOutside = inst;\n\n                    }\n\n                    //Provided we did all the previous steps, we can fire the drag event of the sortable on every draggable drag, when it intersects with the sortable\n                    if (this.instance.currentItem) {\n                        this.instance._mouseDrag(event);\n                    }\n\n                } else {\n\n                    //If it doesn't intersect with the sortable, and it intersected before,\n                    //we fake the drag stop of the sortable, but make sure it doesn't remove the helper by using cancelHelperRemoval\n                    if (this.instance.isOver) {\n\n                        this.instance.isOver = 0;\n                        this.instance.cancelHelperRemoval = true;\n\n                        //Prevent reverting on this forced stop\n                        this.instance.options.revert = false;\n\n                        // The out event needs to be triggered independently\n                        this.instance._trigger(\"out\", event, this.instance._uiHash(this.instance));\n\n                        this.instance._mouseStop(event, true);\n                        this.instance.options.helper = this.instance.options._helper;\n\n                        //Now we remove our currentItem, the list group clone again, and the placeholder, and animate the helper back to it's original size\n                        this.instance.currentItem.remove();\n                        if (this.instance.placeholder) {\n                            this.instance.placeholder.remove();\n                        }\n\n                        inst._trigger(\"fromSortable\", event);\n                        inst.dropped = false; //draggable revert needs that\n                    }\n\n                }\n\n            });\n\n        }\n    });\n\n    $.ui.plugin.add(\"draggable\", \"cursor\", {\n        start: function () {\n            var t = $(\"body\"), o = $(this).data(\"ui-draggable\").options;\n            if (t.css(\"cursor\")) {\n                o._cursor = t.css(\"cursor\");\n            }\n            t.css(\"cursor\", o.cursor);\n        },\n        stop: function () {\n            var o = $(this).data(\"ui-draggable\").options;\n            if (o._cursor) {\n                $(\"body\").css(\"cursor\", o._cursor);\n            }\n        }\n    });\n\n    $.ui.plugin.add(\"draggable\", \"opacity\", {\n        start: function (event, ui) {\n            var t = $(ui.helper), o = $(this).data(\"ui-draggable\").options;\n            if (t.css(\"opacity\")) {\n                o._opacity = t.css(\"opacity\");\n            }\n            t.css(\"opacity\", o.opacity);\n        },\n        stop: function (event, ui) {\n            var o = $(this).data(\"ui-draggable\").options;\n            if (o._opacity) {\n                $(ui.helper).css(\"opacity\", o._opacity);\n            }\n        }\n    });\n\n    $.ui.plugin.add(\"draggable\", \"scroll\", {\n        start: function () {\n            var i = $(this).data(\"ui-draggable\");\n            if (i.scrollParent[0] !== document && i.scrollParent[0].tagName !== \"HTML\") {\n                i.overflowOffset = i.scrollParent.offset();\n            }\n        },\n        drag: function (event) {\n\n            var i = $(this).data(\"ui-draggable\"), o = i.options, scrolled = false;\n\n            if (i.scrollParent[0] !== document && i.scrollParent[0].tagName !== \"HTML\") {\n\n                if (!o.axis || o.axis !== \"x\") {\n                    if ((i.overflowOffset.top + i.scrollParent[0].offsetHeight) - event.pageY < o.scrollSensitivity) {\n                        i.scrollParent[0].scrollTop = scrolled = i.scrollParent[0].scrollTop + o.scrollSpeed;\n                    } else if (event.pageY - i.overflowOffset.top < o.scrollSensitivity) {\n                        i.scrollParent[0].scrollTop = scrolled = i.scrollParent[0].scrollTop - o.scrollSpeed;\n                    }\n                }\n\n                if (!o.axis || o.axis !== \"y\") {\n                    if ((i.overflowOffset.left + i.scrollParent[0].offsetWidth) - event.pageX < o.scrollSensitivity) {\n                        i.scrollParent[0].scrollLeft = scrolled = i.scrollParent[0].scrollLeft + o.scrollSpeed;\n                    } else if (event.pageX - i.overflowOffset.left < o.scrollSensitivity) {\n                        i.scrollParent[0].scrollLeft = scrolled = i.scrollParent[0].scrollLeft - o.scrollSpeed;\n                    }\n                }\n\n            } else {\n\n                if (!o.axis || o.axis !== \"x\") {\n                    if (event.pageY - $(document).scrollTop() < o.scrollSensitivity) {\n                        scrolled = $(document).scrollTop($(document).scrollTop() - o.scrollSpeed);\n                    } else if ($(window).height() - (event.pageY - $(document).scrollTop()) < o.scrollSensitivity) {\n                        scrolled = $(document).scrollTop($(document).scrollTop() + o.scrollSpeed);\n                    }\n                }\n\n                if (!o.axis || o.axis !== \"y\") {\n                    if (event.pageX - $(document).scrollLeft() < o.scrollSensitivity) {\n                        scrolled = $(document).scrollLeft($(document).scrollLeft() - o.scrollSpeed);\n                    } else if ($(window).width() - (event.pageX - $(document).scrollLeft()) < o.scrollSensitivity) {\n                        scrolled = $(document).scrollLeft($(document).scrollLeft() + o.scrollSpeed);\n                    }\n                }\n\n            }\n\n            if (scrolled !== false && $.ui.ddmanager && !o.dropBehaviour) {\n                $.ui.ddmanager.prepareOffsets(i, event);\n            }\n\n        }\n    });\n\n    $.ui.plugin.add(\"draggable\", \"snap\", {\n        start: function () {\n\n            var i = $(this).data(\"ui-draggable\"),\n                o = i.options;\n\n            i.snapElements = [];\n\n            $(o.snap.constructor !== String ? (o.snap.items || \":data(ui-draggable)\") : o.snap).each(function () {\n                var $t = $(this),\n                    $o = $t.offset();\n                if (this !== i.element[0]) {\n                    i.snapElements.push({\n                        item: this,\n                        width: $t.outerWidth(), height: $t.outerHeight(),\n                        top: $o.top, left: $o.left\n                    });\n                }\n            });\n\n        },\n        drag: function (event, ui) {\n\n            var ts, bs, ls, rs, l, r, t, b, i, first,\n                inst = $(this).data(\"ui-draggable\"),\n                o = inst.options,\n                d = o.snapTolerance,\n                x1 = ui.offset.left, x2 = x1 + inst.helperProportions.width,\n                y1 = ui.offset.top, y2 = y1 + inst.helperProportions.height;\n\n            for (i = inst.snapElements.length - 1; i >= 0; i--) {\n\n                l = inst.snapElements[i].left;\n                r = l + inst.snapElements[i].width;\n                t = inst.snapElements[i].top;\n                b = t + inst.snapElements[i].height;\n\n                if (x2 < l - d || x1 > r + d || y2 < t - d || y1 > b + d || !$.contains(inst.snapElements[i].item.ownerDocument, inst.snapElements[i].item)) {\n                    if (inst.snapElements[i].snapping) {\n                        (inst.options.snap.release && inst.options.snap.release.call(inst.element, event, $.extend(inst._uiHash(), {snapItem: inst.snapElements[i].item})));\n                    }\n                    inst.snapElements[i].snapping = false;\n                    continue;\n                }\n\n                if (o.snapMode !== \"inner\") {\n                    ts = Math.abs(t - y2) <= d;\n                    bs = Math.abs(b - y1) <= d;\n                    ls = Math.abs(l - x2) <= d;\n                    rs = Math.abs(r - x1) <= d;\n                    if (ts) {\n                        ui.position.top = inst._convertPositionTo(\"relative\", {\n                            top: t - inst.helperProportions.height,\n                            left: 0\n                        }).top - inst.margins.top;\n                    }\n                    if (bs) {\n                        ui.position.top = inst._convertPositionTo(\"relative\", {top: b, left: 0}).top - inst.margins.top;\n                    }\n                    if (ls) {\n                        ui.position.left = inst._convertPositionTo(\"relative\", {\n                            top: 0,\n                            left: l - inst.helperProportions.width\n                        }).left - inst.margins.left;\n                    }\n                    if (rs) {\n                        ui.position.left = inst._convertPositionTo(\"relative\", {\n                            top: 0,\n                            left: r\n                        }).left - inst.margins.left;\n                    }\n                }\n\n                first = (ts || bs || ls || rs);\n\n                if (o.snapMode !== \"outer\") {\n                    ts = Math.abs(t - y1) <= d;\n                    bs = Math.abs(b - y2) <= d;\n                    ls = Math.abs(l - x1) <= d;\n                    rs = Math.abs(r - x2) <= d;\n                    if (ts) {\n                        ui.position.top = inst._convertPositionTo(\"relative\", {top: t, left: 0}).top - inst.margins.top;\n                    }\n                    if (bs) {\n                        ui.position.top = inst._convertPositionTo(\"relative\", {\n                            top: b - inst.helperProportions.height,\n                            left: 0\n                        }).top - inst.margins.top;\n                    }\n                    if (ls) {\n                        ui.position.left = inst._convertPositionTo(\"relative\", {\n                            top: 0,\n                            left: l\n                        }).left - inst.margins.left;\n                    }\n                    if (rs) {\n                        ui.position.left = inst._convertPositionTo(\"relative\", {\n                            top: 0,\n                            left: r - inst.helperProportions.width\n                        }).left - inst.margins.left;\n                    }\n                }\n\n                if (!inst.snapElements[i].snapping && (ts || bs || ls || rs || first)) {\n                    (inst.options.snap.snap && inst.options.snap.snap.call(inst.element, event, $.extend(inst._uiHash(), {snapItem: inst.snapElements[i].item})));\n                }\n                inst.snapElements[i].snapping = (ts || bs || ls || rs || first);\n\n            }\n\n        }\n    });\n\n    $.ui.plugin.add(\"draggable\", \"stack\", {\n        start: function () {\n            var min,\n                o = this.data(\"ui-draggable\").options,\n                group = $.makeArray($(o.stack)).sort(function (a, b) {\n                    return (parseInt($(a).css(\"zIndex\"), 10) || 0) - (parseInt($(b).css(\"zIndex\"), 10) || 0);\n                });\n\n            if (!group.length) {\n                return;\n            }\n\n            min = parseInt($(group[0]).css(\"zIndex\"), 10) || 0;\n            $(group).each(function (i) {\n                $(this).css(\"zIndex\", min + i);\n            });\n            this.css(\"zIndex\", (min + group.length));\n        }\n    });\n\n    $.ui.plugin.add(\"draggable\", \"zIndex\", {\n        start: function (event, ui) {\n            var t = $(ui.helper), o = $(this).data(\"ui-draggable\").options;\n            if (t.css(\"zIndex\")) {\n                o._zIndex = t.css(\"zIndex\");\n            }\n            t.css(\"zIndex\", o.zIndex);\n        },\n        stop: function (event, ui) {\n            var o = $(this).data(\"ui-draggable\").options;\n            if (o._zIndex) {\n                $(ui.helper).css(\"zIndex\", o._zIndex);\n            }\n        }\n    });\n\n});\n","jquery/ui-modules/effect-blind.js":"/*!\n * jQuery UI Effects Blind - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/blind-effect/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    var rvertical = /up|down|vertical/,\n        rpositivemotion = /up|left|vertical|horizontal/;\n\n    $.effects.effect.blind = function (o, done) {\n        // Create element\n        var el = $(this),\n            props = [\"position\", \"top\", \"bottom\", \"left\", \"right\", \"height\", \"width\"],\n            mode = $.effects.setMode(el, o.mode || \"hide\"),\n            direction = o.direction || \"up\",\n            vertical = rvertical.test(direction),\n            ref = vertical ? \"height\" : \"width\",\n            ref2 = vertical ? \"top\" : \"left\",\n            motion = rpositivemotion.test(direction),\n            animation = {},\n            show = mode === \"show\",\n            wrapper, distance, margin;\n\n        // if already wrapped, the wrapper's properties are my property. #6245\n        if (el.parent().is(\".ui-effects-wrapper\")) {\n            $.effects.save(el.parent(), props);\n        } else {\n            $.effects.save(el, props);\n        }\n        el.show();\n        wrapper = $.effects.createWrapper(el).css({\n            overflow: \"hidden\"\n        });\n\n        distance = wrapper[ref]();\n        margin = parseFloat(wrapper.css(ref2)) || 0;\n\n        animation[ref] = show ? distance : 0;\n        if (!motion) {\n            el\n                .css(vertical ? \"bottom\" : \"right\", 0)\n                .css(vertical ? \"top\" : \"left\", \"auto\")\n                .css({position: \"absolute\"});\n\n            animation[ref2] = show ? margin : distance + margin;\n        }\n\n        // start at 0 if we are showing\n        if (show) {\n            wrapper.css(ref, 0);\n            if (!motion) {\n                wrapper.css(ref2, margin + distance);\n            }\n        }\n\n        // Animate\n        wrapper.animate(animation, {\n            duration: o.duration,\n            easing: o.easing,\n            queue: false,\n            complete: function () {\n                if (mode === \"hide\") {\n                    el.hide();\n                }\n                $.effects.restore(el, props);\n                $.effects.removeWrapper(el);\n                done();\n            }\n        });\n\n    };\n\n});\n","jquery/ui-modules/effect-fade.js":"/*!\n * jQuery UI Effects Fade - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/fade-effect/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.fade = function (o, done) {\n        var el = $(this),\n            mode = $.effects.setMode(el, o.mode || \"toggle\");\n\n        el.animate({\n            opacity: mode\n        }, {\n            queue: false,\n            duration: o.duration,\n            easing: o.easing,\n            complete: done\n        });\n    };\n\n});\n","jquery/ui-modules/effect-clip.js":"/*!\n * jQuery UI Effects Clip - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/clip-effect/\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.clip = function (o, done) {\n        // Create element\n        var el = $(this),\n            props = [\"position\", \"top\", \"bottom\", \"left\", \"right\", \"height\", \"width\"],\n            mode = $.effects.setMode(el, o.mode || \"hide\"),\n            show = mode === \"show\",\n            direction = o.direction || \"vertical\",\n            vert = direction === \"vertical\",\n            size = vert ? \"height\" : \"width\",\n            position = vert ? \"top\" : \"left\",\n            animation = {},\n            wrapper, animate, distance;\n\n        // Save & Show\n        $.effects.save(el, props);\n        el.show();\n\n        // Create Wrapper\n        wrapper = $.effects.createWrapper(el).css({\n            overflow: \"hidden\"\n        });\n        animate = (el[0].tagName === \"IMG\") ? wrapper : el;\n        distance = animate[size]();\n\n        // Shift\n        if (show) {\n            animate.css(size, 0);\n            animate.css(position, distance / 2);\n        }\n\n        // Create Animation Object:\n        animation[size] = show ? distance : 0;\n        animation[position] = show ? 0 : distance / 2;\n\n        // Animate\n        animate.animate(animation, {\n            queue: false,\n            duration: o.duration,\n            easing: o.easing,\n            complete: function () {\n                if (!show) {\n                    el.hide();\n                }\n                $.effects.restore(el, props);\n                $.effects.removeWrapper(el);\n                done();\n            }\n        });\n\n    };\n\n});\n","jquery/ui-modules/tabs.js":"/*!\n * jQuery UI Tabs - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/tabs/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/widget'\n], function ($, undefined) {\n\n    var tabId = 0,\n        rhash = /#.*$/;\n\n    function getNextTabId() {\n        return ++tabId;\n    }\n\n    function isLocal(anchor) {\n        // support: IE7\n        // IE7 doesn't normalize the href property when set via script (#9317)\n        anchor = anchor.cloneNode(false);\n\n        return anchor.hash.length > 1 &&\n            decodeURIComponent(anchor.href.replace(rhash, \"\")) ===\n            decodeURIComponent(location.href.replace(rhash, \"\"));\n    }\n\n    $.widget(\"ui.tabs\", {\n        version: \"1.10.4\",\n        delay: 300,\n        options: {\n            active: null,\n            collapsible: false,\n            event: \"click\",\n            heightStyle: \"content\",\n            hide: null,\n            show: null,\n\n            // callbacks\n            activate: null,\n            beforeActivate: null,\n            beforeLoad: null,\n            load: null\n        },\n\n        _create: function () {\n            var that = this,\n                options = this.options;\n\n            this.running = false;\n\n            this.element\n                .addClass(\"ui-tabs ui-widget ui-widget-content ui-corner-all\")\n                .toggleClass(\"ui-tabs-collapsible\", options.collapsible)\n                // Prevent users from focusing disabled tabs via click\n                .delegate(\".ui-tabs-nav > li\", \"mousedown\" + this.eventNamespace, function (event) {\n                    if ($(this).is(\".ui-state-disabled\")) {\n                        event.preventDefault();\n                    }\n                })\n                // support: IE <9\n                // Preventing the default action in mousedown doesn't prevent IE\n                // from focusing the element, so if the anchor gets focused, blur.\n                // We don't have to worry about focusing the previously focused\n                // element since clicking on a non-focusable element should focus\n                // the body anyway.\n                .delegate(\".ui-tabs-anchor\", \"focus\" + this.eventNamespace, function () {\n                    if ($(this).closest(\"li\").is(\".ui-state-disabled\")) {\n                        this.blur();\n                    }\n                });\n\n            this._processTabs();\n            options.active = this._initialActive();\n\n            // Take disabling tabs via class attribute from HTML\n            // into account and update option properly.\n            if ($.isArray(options.disabled)) {\n                options.disabled = $.unique(options.disabled.concat(\n                    $.map(this.tabs.filter(\".ui-state-disabled\"), function (li) {\n                        return that.tabs.index(li);\n                    })\n                )).sort();\n            }\n\n            // check for length avoids error when initializing empty list\n            if (this.options.active !== false && this.anchors.length) {\n                this.active = this._findActive(options.active);\n            } else {\n                this.active = $();\n            }\n\n            this._refresh();\n\n            if (this.active.length) {\n                this.load(options.active);\n            }\n        },\n\n        _initialActive: function () {\n            var active = this.options.active,\n                collapsible = this.options.collapsible,\n                locationHash = location.hash.substring(1);\n\n            if (active === null) {\n                // check the fragment identifier in the URL\n                if (locationHash) {\n                    this.tabs.each(function (i, tab) {\n                        if ($(tab).attr(\"aria-controls\") === locationHash) {\n                            active = i;\n                            return false;\n                        }\n                    });\n                }\n\n                // check for a tab marked active via a class\n                if (active === null) {\n                    active = this.tabs.index(this.tabs.filter(\".ui-tabs-active\"));\n                }\n\n                // no active tab, set to false\n                if (active === null || active === -1) {\n                    active = this.tabs.length ? 0 : false;\n                }\n            }\n\n            // handle numbers: negative, out of range\n            if (active !== false) {\n                active = this.tabs.index(this.tabs.eq(active));\n                if (active === -1) {\n                    active = collapsible ? false : 0;\n                }\n            }\n\n            // don't allow collapsible: false and active: false\n            if (!collapsible && active === false && this.anchors.length) {\n                active = 0;\n            }\n\n            return active;\n        },\n\n        _getCreateEventData: function () {\n            return {\n                tab: this.active,\n                panel: !this.active.length ? $() : this._getPanelForTab(this.active)\n            };\n        },\n\n        _tabKeydown: function (event) {\n            var focusedTab = $(this.document[0].activeElement).closest(\"li\"),\n                selectedIndex = this.tabs.index(focusedTab),\n                goingForward = true;\n\n            if (this._handlePageNav(event)) {\n                return;\n            }\n\n            switch (event.keyCode) {\n                case $.ui.keyCode.RIGHT:\n                case $.ui.keyCode.DOWN:\n                    selectedIndex++;\n                    break;\n                case $.ui.keyCode.UP:\n                case $.ui.keyCode.LEFT:\n                    goingForward = false;\n                    selectedIndex--;\n                    break;\n                case $.ui.keyCode.END:\n                    selectedIndex = this.anchors.length - 1;\n                    break;\n                case $.ui.keyCode.HOME:\n                    selectedIndex = 0;\n                    break;\n                case $.ui.keyCode.SPACE:\n                    // Activate only, no collapsing\n                    event.preventDefault();\n                    clearTimeout(this.activating);\n                    this._activate(selectedIndex);\n                    return;\n                case $.ui.keyCode.ENTER:\n                    // Toggle (cancel delayed activation, allow collapsing)\n                    event.preventDefault();\n                    clearTimeout(this.activating);\n                    // Determine if we should collapse or activate\n                    this._activate(selectedIndex === this.options.active ? false : selectedIndex);\n                    return;\n                default:\n                    return;\n            }\n\n            // Focus the appropriate tab, based on which key was pressed\n            event.preventDefault();\n            clearTimeout(this.activating);\n            selectedIndex = this._focusNextTab(selectedIndex, goingForward);\n\n            // Navigating with control key will prevent automatic activation\n            if (!event.ctrlKey) {\n                // Update aria-selected immediately so that AT think the tab is already selected.\n                // Otherwise AT may confuse the user by stating that they need to activate the tab,\n                // but the tab will already be activated by the time the announcement finishes.\n                focusedTab.attr(\"aria-selected\", \"false\");\n                this.tabs.eq(selectedIndex).attr(\"aria-selected\", \"true\");\n\n                this.activating = this._delay(function () {\n                    this.option(\"active\", selectedIndex);\n                }, this.delay);\n            }\n        },\n\n        _panelKeydown: function (event) {\n            if (this._handlePageNav(event)) {\n                return;\n            }\n\n            // Ctrl+up moves focus to the current tab\n            if (event.ctrlKey && event.keyCode === $.ui.keyCode.UP) {\n                event.preventDefault();\n                this.active.focus();\n            }\n        },\n\n        // Alt+page up/down moves focus to the previous/next tab (and activates)\n        _handlePageNav: function (event) {\n            if (event.altKey && event.keyCode === $.ui.keyCode.PAGE_UP) {\n                this._activate(this._focusNextTab(this.options.active - 1, false));\n                return true;\n            }\n            if (event.altKey && event.keyCode === $.ui.keyCode.PAGE_DOWN) {\n                this._activate(this._focusNextTab(this.options.active + 1, true));\n                return true;\n            }\n        },\n\n        _findNextTab: function (index, goingForward) {\n            var lastTabIndex = this.tabs.length - 1;\n\n            function constrain() {\n                if (index > lastTabIndex) {\n                    index = 0;\n                }\n                if (index < 0) {\n                    index = lastTabIndex;\n                }\n                return index;\n            }\n\n            while ($.inArray(constrain(), this.options.disabled) !== -1) {\n                index = goingForward ? index + 1 : index - 1;\n            }\n\n            return index;\n        },\n\n        _focusNextTab: function (index, goingForward) {\n            index = this._findNextTab(index, goingForward);\n            this.tabs.eq(index).focus();\n            return index;\n        },\n\n        _setOption: function (key, value) {\n            if (key === \"active\") {\n                // _activate() will handle invalid values and update this.options\n                this._activate(value);\n                return;\n            }\n\n            if (key === \"disabled\") {\n                // don't use the widget factory's disabled handling\n                this._setupDisabled(value);\n                return;\n            }\n\n            this._super(key, value);\n\n            if (key === \"collapsible\") {\n                this.element.toggleClass(\"ui-tabs-collapsible\", value);\n                // Setting collapsible: false while collapsed; open first panel\n                if (!value && this.options.active === false) {\n                    this._activate(0);\n                }\n            }\n\n            if (key === \"event\") {\n                this._setupEvents(value);\n            }\n\n            if (key === \"heightStyle\") {\n                this._setupHeightStyle(value);\n            }\n        },\n\n        _tabId: function (tab) {\n            return tab.attr(\"aria-controls\") || \"ui-tabs-\" + getNextTabId();\n        },\n\n        _sanitizeSelector: function (hash) {\n            return hash ? hash.replace(/[!\"$%&'()*+,.\\/:;<=>?@\\[\\]\\^`{|}~]/g, \"\\\\$&\") : \"\";\n        },\n\n        refresh: function () {\n            var options = this.options,\n                lis = this.tablist.children(\":has(a[href])\");\n\n            // get disabled tabs from class attribute from HTML\n            // this will get converted to a boolean if needed in _refresh()\n            options.disabled = $.map(lis.filter(\".ui-state-disabled\"), function (tab) {\n                return lis.index(tab);\n            });\n\n            this._processTabs();\n\n            // was collapsed or no tabs\n            if (options.active === false || !this.anchors.length) {\n                options.active = false;\n                this.active = $();\n                // was active, but active tab is gone\n            } else if (this.active.length && !$.contains(this.tablist[0], this.active[0])) {\n                // all remaining tabs are disabled\n                if (this.tabs.length === options.disabled.length) {\n                    options.active = false;\n                    this.active = $();\n                    // activate previous tab\n                } else {\n                    this._activate(this._findNextTab(Math.max(0, options.active - 1), false));\n                }\n                // was active, active tab still exists\n            } else {\n                // make sure active index is correct\n                options.active = this.tabs.index(this.active);\n            }\n\n            this._refresh();\n        },\n\n        _refresh: function () {\n            this._setupDisabled(this.options.disabled);\n            this._setupEvents(this.options.event);\n            this._setupHeightStyle(this.options.heightStyle);\n\n            this.tabs.not(this.active).attr({\n                \"aria-selected\": \"false\",\n                tabIndex: -1\n            });\n            this.panels.not(this._getPanelForTab(this.active))\n                .hide()\n                .attr({\n                    \"aria-expanded\": \"false\",\n                    \"aria-hidden\": \"true\"\n                });\n\n            // Make sure one tab is in the tab order\n            if (!this.active.length) {\n                this.tabs.eq(0).attr(\"tabIndex\", 0);\n            } else {\n                this.active\n                    .addClass(\"ui-tabs-active ui-state-active\")\n                    .attr({\n                        \"aria-selected\": \"true\",\n                        tabIndex: 0\n                    });\n                this._getPanelForTab(this.active)\n                    .show()\n                    .attr({\n                        \"aria-expanded\": \"true\",\n                        \"aria-hidden\": \"false\"\n                    });\n            }\n        },\n\n        _processTabs: function () {\n            var that = this;\n\n            this.tablist = this._getList()\n                .addClass(\"ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all\")\n                .attr(\"role\", \"tablist\");\n\n            this.tabs = this.tablist.find(\"> li:has(a[href])\")\n                .addClass(\"ui-state-default ui-corner-top\")\n                .attr({\n                    role: \"tab\",\n                    tabIndex: -1\n                });\n\n            this.anchors = this.tabs.map(function () {\n                return $(\"a\", this)[0];\n            })\n                .addClass(\"ui-tabs-anchor\")\n                .attr({\n                    role: \"presentation\",\n                    tabIndex: -1\n                });\n\n            this.panels = $();\n\n            this.anchors.each(function (i, anchor) {\n                var selector, panel, panelId,\n                    anchorId = $(anchor).uniqueId().attr(\"id\"),\n                    tab = $(anchor).closest(\"li\"),\n                    originalAriaControls = tab.attr(\"aria-controls\");\n\n                // inline tab\n                if (isLocal(anchor)) {\n                    selector = anchor.hash;\n                    panel = that.element.find(that._sanitizeSelector(selector));\n                    // remote tab\n                } else {\n                    panelId = that._tabId(tab);\n                    selector = \"#\" + panelId;\n                    panel = that.element.find(selector);\n                    if (!panel.length) {\n                        panel = that._createPanel(panelId);\n                        panel.insertAfter(that.panels[i - 1] || that.tablist);\n                    }\n                    panel.attr(\"aria-live\", \"polite\");\n                }\n\n                if (panel.length) {\n                    that.panels = that.panels.add(panel);\n                }\n                if (originalAriaControls) {\n                    tab.data(\"ui-tabs-aria-controls\", originalAriaControls);\n                }\n                tab.attr({\n                    \"aria-controls\": selector.substring(1),\n                    \"aria-labelledby\": anchorId\n                });\n                panel.attr(\"aria-labelledby\", anchorId);\n            });\n\n            this.panels\n                .addClass(\"ui-tabs-panel ui-widget-content ui-corner-bottom\")\n                .attr(\"role\", \"tabpanel\");\n        },\n\n        // allow overriding how to find the list for rare usage scenarios (#7715)\n        _getList: function () {\n            return this.tablist || this.element.find(\"ol,ul\").eq(0);\n        },\n\n        _createPanel: function (id) {\n            return $(\"<div>\")\n                .attr(\"id\", id)\n                .addClass(\"ui-tabs-panel ui-widget-content ui-corner-bottom\")\n                .data(\"ui-tabs-destroy\", true);\n        },\n\n        _setupDisabled: function (disabled) {\n            if ($.isArray(disabled)) {\n                if (!disabled.length) {\n                    disabled = false;\n                } else if (disabled.length === this.anchors.length) {\n                    disabled = true;\n                }\n            }\n\n            // disable tabs\n            for (var i = 0, li; (li = this.tabs[i]); i++) {\n                if (disabled === true || $.inArray(i, disabled) !== -1) {\n                    $(li)\n                        .addClass(\"ui-state-disabled\")\n                        .attr(\"aria-disabled\", \"true\");\n                } else {\n                    $(li)\n                        .removeClass(\"ui-state-disabled\")\n                        .removeAttr(\"aria-disabled\");\n                }\n            }\n\n            this.options.disabled = disabled;\n        },\n\n        _setupEvents: function (event) {\n            var events = {\n                click: function (event) {\n                    event.preventDefault();\n                }\n            };\n            if (event) {\n                $.each(event.split(\" \"), function (index, eventName) {\n                    events[eventName] = \"_eventHandler\";\n                });\n            }\n\n            this._off(this.anchors.add(this.tabs).add(this.panels));\n            this._on(this.anchors, events);\n            this._on(this.tabs, {keydown: \"_tabKeydown\"});\n            this._on(this.panels, {keydown: \"_panelKeydown\"});\n\n            this._focusable(this.tabs);\n            this._hoverable(this.tabs);\n        },\n\n        _setupHeightStyle: function (heightStyle) {\n            var maxHeight,\n                parent = this.element.parent();\n\n            if (heightStyle === \"fill\") {\n                maxHeight = parent.height();\n                maxHeight -= this.element.outerHeight() - this.element.height();\n\n                this.element.siblings(\":visible\").each(function () {\n                    var elem = $(this),\n                        position = elem.css(\"position\");\n\n                    if (position === \"absolute\" || position === \"fixed\") {\n                        return;\n                    }\n                    maxHeight -= elem.outerHeight(true);\n                });\n\n                this.element.children().not(this.panels).each(function () {\n                    maxHeight -= $(this).outerHeight(true);\n                });\n\n                this.panels.each(function () {\n                    $(this).height(Math.max(0, maxHeight -\n                        $(this).innerHeight() + $(this).height()));\n                })\n                    .css(\"overflow\", \"auto\");\n            } else if (heightStyle === \"auto\") {\n                maxHeight = 0;\n                this.panels.each(function () {\n                    maxHeight = Math.max(maxHeight, $(this).height(\"\").height());\n                }).height(maxHeight);\n            }\n        },\n\n        _eventHandler: function (event) {\n            var options = this.options,\n                active = this.active,\n                anchor = $(event.currentTarget),\n                tab = anchor.closest(\"li\"),\n                clickedIsActive = tab[0] === active[0],\n                collapsing = clickedIsActive && options.collapsible,\n                toShow = collapsing ? $() : this._getPanelForTab(tab),\n                toHide = !active.length ? $() : this._getPanelForTab(active),\n                eventData = {\n                    oldTab: active,\n                    oldPanel: toHide,\n                    newTab: collapsing ? $() : tab,\n                    newPanel: toShow\n                };\n\n            event.preventDefault();\n\n            if (tab.hasClass(\"ui-state-disabled\") ||\n                // tab is already loading\n                tab.hasClass(\"ui-tabs-loading\") ||\n                // can't switch durning an animation\n                this.running ||\n                // click on active header, but not collapsible\n                (clickedIsActive && !options.collapsible) ||\n                // allow canceling activation\n                (this._trigger(\"beforeActivate\", event, eventData) === false)) {\n                return;\n            }\n\n            options.active = collapsing ? false : this.tabs.index(tab);\n\n            this.active = clickedIsActive ? $() : tab;\n            if (this.xhr) {\n                this.xhr.abort();\n            }\n\n            if (!toHide.length && !toShow.length) {\n                $.error(\"jQuery UI Tabs: Mismatching fragment identifier.\");\n            }\n\n            if (toShow.length) {\n                this.load(this.tabs.index(tab), event);\n            }\n            this._toggle(event, eventData);\n        },\n\n        // handles show/hide for selecting tabs\n        _toggle: function (event, eventData) {\n            var that = this,\n                toShow = eventData.newPanel,\n                toHide = eventData.oldPanel;\n\n            this.running = true;\n\n            function complete() {\n                that.running = false;\n                that._trigger(\"activate\", event, eventData);\n            }\n\n            function show() {\n                eventData.newTab.closest(\"li\").addClass(\"ui-tabs-active ui-state-active\");\n\n                if (toShow.length && that.options.show) {\n                    that._show(toShow, that.options.show, complete);\n                } else {\n                    toShow.show();\n                    complete();\n                }\n            }\n\n            // start out by hiding, then showing, then completing\n            if (toHide.length && this.options.hide) {\n                this._hide(toHide, this.options.hide, function () {\n                    eventData.oldTab.closest(\"li\").removeClass(\"ui-tabs-active ui-state-active\");\n                    show();\n                });\n            } else {\n                eventData.oldTab.closest(\"li\").removeClass(\"ui-tabs-active ui-state-active\");\n                toHide.hide();\n                show();\n            }\n\n            toHide.attr({\n                \"aria-expanded\": \"false\",\n                \"aria-hidden\": \"true\"\n            });\n            eventData.oldTab.attr(\"aria-selected\", \"false\");\n            // If we're switching tabs, remove the old tab from the tab order.\n            // If we're opening from collapsed state, remove the previous tab from the tab order.\n            // If we're collapsing, then keep the collapsing tab in the tab order.\n            if (toShow.length && toHide.length) {\n                eventData.oldTab.attr(\"tabIndex\", -1);\n            } else if (toShow.length) {\n                this.tabs.filter(function () {\n                    return $(this).attr(\"tabIndex\") === 0;\n                })\n                    .attr(\"tabIndex\", -1);\n            }\n\n            toShow.attr({\n                \"aria-expanded\": \"true\",\n                \"aria-hidden\": \"false\"\n            });\n            eventData.newTab.attr({\n                \"aria-selected\": \"true\",\n                tabIndex: 0\n            });\n        },\n\n        _activate: function (index) {\n            var anchor,\n                active = this._findActive(index);\n\n            // trying to activate the already active panel\n            if (active[0] === this.active[0]) {\n                return;\n            }\n\n            // trying to collapse, simulate a click on the current active header\n            if (!active.length) {\n                active = this.active;\n            }\n\n            anchor = active.find(\".ui-tabs-anchor\")[0];\n            this._eventHandler({\n                target: anchor,\n                currentTarget: anchor,\n                preventDefault: $.noop\n            });\n        },\n\n        _findActive: function (index) {\n            return index === false ? $() : this.tabs.eq(index);\n        },\n\n        _getIndex: function (index) {\n            // meta-function to give users option to provide a href string instead of a numerical index.\n            if (typeof index === \"string\") {\n                index = this.anchors.index(this.anchors.filter(\"[href$='\" + index + \"']\"));\n            }\n\n            return index;\n        },\n\n        _destroy: function () {\n            if (this.xhr) {\n                this.xhr.abort();\n            }\n\n            this.element.removeClass(\"ui-tabs ui-widget ui-widget-content ui-corner-all ui-tabs-collapsible\");\n\n            this.tablist\n                .removeClass(\"ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all\")\n                .removeAttr(\"role\");\n\n            this.anchors\n                .removeClass(\"ui-tabs-anchor\")\n                .removeAttr(\"role\")\n                .removeAttr(\"tabIndex\")\n                .removeUniqueId();\n\n            this.tabs.add(this.panels).each(function () {\n                if ($.data(this, \"ui-tabs-destroy\")) {\n                    $(this).remove();\n                } else {\n                    $(this)\n                        .removeClass(\"ui-state-default ui-state-active ui-state-disabled \" +\n                            \"ui-corner-top ui-corner-bottom ui-widget-content ui-tabs-active ui-tabs-panel\")\n                        .removeAttr(\"tabIndex\")\n                        .removeAttr(\"aria-live\")\n                        .removeAttr(\"aria-busy\")\n                        .removeAttr(\"aria-selected\")\n                        .removeAttr(\"aria-labelledby\")\n                        .removeAttr(\"aria-hidden\")\n                        .removeAttr(\"aria-expanded\")\n                        .removeAttr(\"role\");\n                }\n            });\n\n            this.tabs.each(function () {\n                var li = $(this),\n                    prev = li.data(\"ui-tabs-aria-controls\");\n                if (prev) {\n                    li\n                        .attr(\"aria-controls\", prev)\n                        .removeData(\"ui-tabs-aria-controls\");\n                } else {\n                    li.removeAttr(\"aria-controls\");\n                }\n            });\n\n            this.panels.show();\n\n            if (this.options.heightStyle !== \"content\") {\n                this.panels.css(\"height\", \"\");\n            }\n        },\n\n        enable: function (index) {\n            var disabled = this.options.disabled;\n            if (disabled === false) {\n                return;\n            }\n\n            if (index === undefined) {\n                disabled = false;\n            } else {\n                index = this._getIndex(index);\n                if ($.isArray(disabled)) {\n                    disabled = $.map(disabled, function (num) {\n                        return num !== index ? num : null;\n                    });\n                } else {\n                    disabled = $.map(this.tabs, function (li, num) {\n                        return num !== index ? num : null;\n                    });\n                }\n            }\n            this._setupDisabled(disabled);\n        },\n\n        disable: function (index) {\n            var disabled = this.options.disabled;\n            if (disabled === true) {\n                return;\n            }\n\n            if (index === undefined) {\n                disabled = true;\n            } else {\n                index = this._getIndex(index);\n                if ($.inArray(index, disabled) !== -1) {\n                    return;\n                }\n                if ($.isArray(disabled)) {\n                    disabled = $.merge([index], disabled).sort();\n                } else {\n                    disabled = [index];\n                }\n            }\n            this._setupDisabled(disabled);\n        },\n\n        load: function (index, event) {\n            index = this._getIndex(index);\n            var that = this,\n                tab = this.tabs.eq(index),\n                anchor = tab.find(\".ui-tabs-anchor\"),\n                panel = this._getPanelForTab(tab),\n                eventData = {\n                    tab: tab,\n                    panel: panel\n                };\n\n            // not remote\n            if (isLocal(anchor[0])) {\n                return;\n            }\n\n            this.xhr = $.ajax(this._ajaxSettings(anchor, event, eventData));\n\n            // support: jQuery <1.8\n            // jQuery <1.8 returns false if the request is canceled in beforeSend,\n            // but as of 1.8, $.ajax() always returns a jqXHR object.\n            if (this.xhr && this.xhr.statusText !== \"canceled\") {\n                tab.addClass(\"ui-tabs-loading\");\n                panel.attr(\"aria-busy\", \"true\");\n\n                this.xhr\n                    .success(function (response) {\n                        // support: jQuery <1.8\n                        // http://bugs.jquery.com/ticket/11778\n                        setTimeout(function () {\n                            panel.html(response);\n                            that._trigger(\"load\", event, eventData);\n                        }, 1);\n                    })\n                    .complete(function (jqXHR, status) {\n                        // support: jQuery <1.8\n                        // http://bugs.jquery.com/ticket/11778\n                        setTimeout(function () {\n                            if (status === \"abort\") {\n                                that.panels.stop(false, true);\n                            }\n\n                            tab.removeClass(\"ui-tabs-loading\");\n                            panel.removeAttr(\"aria-busy\");\n\n                            if (jqXHR === that.xhr) {\n                                delete that.xhr;\n                            }\n                        }, 1);\n                    });\n            }\n        },\n\n        _ajaxSettings: function (anchor, event, eventData) {\n            var that = this;\n            return {\n                url: anchor.attr(\"href\"),\n                beforeSend: function (jqXHR, settings) {\n                    return that._trigger(\"beforeLoad\", event,\n                        $.extend({jqXHR: jqXHR, ajaxSettings: settings}, eventData));\n                }\n            };\n        },\n\n        _getPanelForTab: function (tab) {\n            var id = $(tab).attr(\"aria-controls\");\n            return this.element.find(this._sanitizeSelector(\"#\" + id));\n        }\n    });\n\n});\n","jquery/ui-modules/position.js":"/*!\n * jQuery UI Position - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\ndefine([\n    'jquery'\n], function ($, undefined) {\n\n    $.ui = $.ui || {};\n\n    var cachedScrollbarWidth,\n        max = Math.max,\n        abs = Math.abs,\n        round = Math.round,\n        rhorizontal = /left|center|right/,\n        rvertical = /top|center|bottom/,\n        roffset = /[\\+\\-]\\d+(\\.[\\d]+)?%?/,\n        rposition = /^\\w+/,\n        rpercent = /%$/,\n        _position = $.fn.position;\n\n    function getOffsets(offsets, width, height) {\n        return [\n            parseFloat(offsets[0]) * (rpercent.test(offsets[0]) ? width / 100 : 1),\n            parseFloat(offsets[1]) * (rpercent.test(offsets[1]) ? height / 100 : 1)\n        ];\n    }\n\n    function parseCss(element, property) {\n        return parseInt($.css(element, property), 10) || 0;\n    }\n\n    function getDimensions(elem) {\n        var raw = elem[0];\n        if (raw.nodeType === 9) {\n            return {\n                width: elem.width(),\n                height: elem.height(),\n                offset: {top: 0, left: 0}\n            };\n        }\n        if ($.isWindow(raw)) {\n            return {\n                width: elem.width(),\n                height: elem.height(),\n                offset: {top: elem.scrollTop(), left: elem.scrollLeft()}\n            };\n        }\n        if (raw.preventDefault) {\n            return {\n                width: 0,\n                height: 0,\n                offset: {top: raw.pageY, left: raw.pageX}\n            };\n        }\n        return {\n            width: elem.outerWidth(),\n            height: elem.outerHeight(),\n            offset: elem.offset()\n        };\n    }\n\n    $.position = {\n        scrollbarWidth: function () {\n            if (cachedScrollbarWidth !== undefined) {\n                return cachedScrollbarWidth;\n            }\n            var w1, w2,\n                div = $(\"<div style='display:block;position:absolute;width:50px;height:50px;overflow:hidden;'><div style='height:100px;width:auto;'></div></div>\"),\n                innerDiv = div.children()[0];\n\n            $(\"body\").append(div);\n            w1 = innerDiv.offsetWidth;\n            div.css(\"overflow\", \"scroll\");\n\n            w2 = innerDiv.offsetWidth;\n\n            if (w1 === w2) {\n                w2 = div[0].clientWidth;\n            }\n\n            div.remove();\n\n            return (cachedScrollbarWidth = w1 - w2);\n        },\n        getScrollInfo: function (within) {\n            var overflowX = within.isWindow || within.isDocument ? \"\" :\n                within.element.css(\"overflow-x\"),\n                overflowY = within.isWindow || within.isDocument ? \"\" :\n                    within.element.css(\"overflow-y\"),\n                hasOverflowX = overflowX === \"scroll\" ||\n                    (overflowX === \"auto\" && within.width < within.element[0].scrollWidth),\n                hasOverflowY = overflowY === \"scroll\" ||\n                    (overflowY === \"auto\" && within.height < within.element[0].scrollHeight);\n            return {\n                width: hasOverflowY ? $.position.scrollbarWidth() : 0,\n                height: hasOverflowX ? $.position.scrollbarWidth() : 0\n            };\n        },\n        getWithinInfo: function (element) {\n            var withinElement = $(element || window),\n                isWindow = $.isWindow(withinElement[0]),\n                isDocument = !!withinElement[0] && withinElement[0].nodeType === 9;\n            return {\n                element: withinElement,\n                isWindow: isWindow,\n                isDocument: isDocument,\n                offset: withinElement.offset() || {left: 0, top: 0},\n                scrollLeft: withinElement.scrollLeft(),\n                scrollTop: withinElement.scrollTop(),\n                width: isWindow ? withinElement.width() : withinElement.outerWidth(),\n                height: isWindow ? withinElement.height() : withinElement.outerHeight()\n            };\n        }\n    };\n\n    $.fn.position = function (options) {\n        if (!options || !options.of) {\n            return _position.apply(this, arguments);\n        }\n\n        // make a copy, we don't want to modify arguments\n        options = $.extend({}, options);\n\n        var atOffset, targetWidth, targetHeight, targetOffset, basePosition, dimensions,\n            target = $(options.of),\n            within = $.position.getWithinInfo(options.within),\n            scrollInfo = $.position.getScrollInfo(within),\n            collision = (options.collision || \"flip\").split(\" \"),\n            offsets = {};\n\n        dimensions = getDimensions(target);\n        if (target[0].preventDefault) {\n            // force left top to allow flipping\n            options.at = \"left top\";\n        }\n        targetWidth = dimensions.width;\n        targetHeight = dimensions.height;\n        targetOffset = dimensions.offset;\n        // clone to reuse original targetOffset later\n        basePosition = $.extend({}, targetOffset);\n\n        // force my and at to have valid horizontal and vertical positions\n        // if a value is missing or invalid, it will be converted to center\n        $.each([\"my\", \"at\"], function () {\n            var pos = (options[this] || \"\").split(\" \"),\n                horizontalOffset,\n                verticalOffset;\n\n            if (pos.length === 1) {\n                pos = rhorizontal.test(pos[0]) ?\n                    pos.concat([\"center\"]) :\n                    rvertical.test(pos[0]) ?\n                        [\"center\"].concat(pos) :\n                        [\"center\", \"center\"];\n            }\n            pos[0] = rhorizontal.test(pos[0]) ? pos[0] : \"center\";\n            pos[1] = rvertical.test(pos[1]) ? pos[1] : \"center\";\n\n            // calculate offsets\n            horizontalOffset = roffset.exec(pos[0]);\n            verticalOffset = roffset.exec(pos[1]);\n            offsets[this] = [\n                horizontalOffset ? horizontalOffset[0] : 0,\n                verticalOffset ? verticalOffset[0] : 0\n            ];\n\n            // reduce to just the positions without the offsets\n            options[this] = [\n                rposition.exec(pos[0])[0],\n                rposition.exec(pos[1])[0]\n            ];\n        });\n\n        // normalize collision option\n        if (collision.length === 1) {\n            collision[1] = collision[0];\n        }\n\n        if (options.at[0] === \"right\") {\n            basePosition.left += targetWidth;\n        } else if (options.at[0] === \"center\") {\n            basePosition.left += targetWidth / 2;\n        }\n\n        if (options.at[1] === \"bottom\") {\n            basePosition.top += targetHeight;\n        } else if (options.at[1] === \"center\") {\n            basePosition.top += targetHeight / 2;\n        }\n\n        atOffset = getOffsets(offsets.at, targetWidth, targetHeight);\n        basePosition.left += atOffset[0];\n        basePosition.top += atOffset[1];\n\n        return this.each(function () {\n            var collisionPosition, using,\n                elem = $(this),\n                elemWidth = elem.outerWidth(),\n                elemHeight = elem.outerHeight(),\n                marginLeft = parseCss(this, \"marginLeft\"),\n                marginTop = parseCss(this, \"marginTop\"),\n                collisionWidth = elemWidth + marginLeft + parseCss(this, \"marginRight\") + scrollInfo.width,\n                collisionHeight = elemHeight + marginTop + parseCss(this, \"marginBottom\") + scrollInfo.height,\n                position = $.extend({}, basePosition),\n                myOffset = getOffsets(offsets.my, elem.outerWidth(), elem.outerHeight());\n\n            if (options.my[0] === \"right\") {\n                position.left -= elemWidth;\n            } else if (options.my[0] === \"center\") {\n                position.left -= elemWidth / 2;\n            }\n\n            if (options.my[1] === \"bottom\") {\n                position.top -= elemHeight;\n            } else if (options.my[1] === \"center\") {\n                position.top -= elemHeight / 2;\n            }\n\n            position.left += myOffset[0];\n            position.top += myOffset[1];\n\n            // if the browser doesn't support fractions, then round for consistent results\n            if (!$.support.offsetFractions) {\n                position.left = round(position.left);\n                position.top = round(position.top);\n            }\n\n            collisionPosition = {\n                marginLeft: marginLeft,\n                marginTop: marginTop\n            };\n\n            $.each([\"left\", \"top\"], function (i, dir) {\n                if ($.ui.position[collision[i]]) {\n                    $.ui.position[collision[i]][dir](position, {\n                        targetWidth: targetWidth,\n                        targetHeight: targetHeight,\n                        elemWidth: elemWidth,\n                        elemHeight: elemHeight,\n                        collisionPosition: collisionPosition,\n                        collisionWidth: collisionWidth,\n                        collisionHeight: collisionHeight,\n                        offset: [atOffset[0] + myOffset[0], atOffset [1] + myOffset[1]],\n                        my: options.my,\n                        at: options.at,\n                        within: within,\n                        elem: elem\n                    });\n                }\n            });\n\n            if (options.using) {\n                // adds feedback as second argument to using callback, if present\n                using = function (props) {\n                    var left = targetOffset.left - position.left,\n                        right = left + targetWidth - elemWidth,\n                        top = targetOffset.top - position.top,\n                        bottom = top + targetHeight - elemHeight,\n                        feedback = {\n                            target: {\n                                element: target,\n                                left: targetOffset.left,\n                                top: targetOffset.top,\n                                width: targetWidth,\n                                height: targetHeight\n                            },\n                            element: {\n                                element: elem,\n                                left: position.left,\n                                top: position.top,\n                                width: elemWidth,\n                                height: elemHeight\n                            },\n                            horizontal: right < 0 ? \"left\" : left > 0 ? \"right\" : \"center\",\n                            vertical: bottom < 0 ? \"top\" : top > 0 ? \"bottom\" : \"middle\"\n                        };\n                    if (targetWidth < elemWidth && abs(left + right) < targetWidth) {\n                        feedback.horizontal = \"center\";\n                    }\n                    if (targetHeight < elemHeight && abs(top + bottom) < targetHeight) {\n                        feedback.vertical = \"middle\";\n                    }\n                    if (max(abs(left), abs(right)) > max(abs(top), abs(bottom))) {\n                        feedback.important = \"horizontal\";\n                    } else {\n                        feedback.important = \"vertical\";\n                    }\n                    options.using.call(this, props, feedback);\n                };\n            }\n\n            elem.offset($.extend(position, {using: using}));\n        });\n    };\n\n    $.ui.position = {\n        fit: {\n            left: function (position, data) {\n                var within = data.within,\n                    withinOffset = within.isWindow ? within.scrollLeft : within.offset.left,\n                    outerWidth = within.width,\n                    collisionPosLeft = position.left - data.collisionPosition.marginLeft,\n                    overLeft = withinOffset - collisionPosLeft,\n                    overRight = collisionPosLeft + data.collisionWidth - outerWidth - withinOffset,\n                    newOverRight;\n\n                // element is wider than within\n                if (data.collisionWidth > outerWidth) {\n                    // element is initially over the left side of within\n                    if (overLeft > 0 && overRight <= 0) {\n                        newOverRight = position.left + overLeft + data.collisionWidth - outerWidth - withinOffset;\n                        position.left += overLeft - newOverRight;\n                        // element is initially over right side of within\n                    } else if (overRight > 0 && overLeft <= 0) {\n                        position.left = withinOffset;\n                        // element is initially over both left and right sides of within\n                    } else {\n                        if (overLeft > overRight) {\n                            position.left = withinOffset + outerWidth - data.collisionWidth;\n                        } else {\n                            position.left = withinOffset;\n                        }\n                    }\n                    // too far left -> align with left edge\n                } else if (overLeft > 0) {\n                    position.left += overLeft;\n                    // too far right -> align with right edge\n                } else if (overRight > 0) {\n                    position.left -= overRight;\n                    // adjust based on position and margin\n                } else {\n                    position.left = max(position.left - collisionPosLeft, position.left);\n                }\n            },\n            top: function (position, data) {\n                var within = data.within,\n                    withinOffset = within.isWindow ? within.scrollTop : within.offset.top,\n                    outerHeight = data.within.height,\n                    collisionPosTop = position.top - data.collisionPosition.marginTop,\n                    overTop = withinOffset - collisionPosTop,\n                    overBottom = collisionPosTop + data.collisionHeight - outerHeight - withinOffset,\n                    newOverBottom;\n\n                // element is taller than within\n                if (data.collisionHeight > outerHeight) {\n                    // element is initially over the top of within\n                    if (overTop > 0 && overBottom <= 0) {\n                        newOverBottom = position.top + overTop + data.collisionHeight - outerHeight - withinOffset;\n                        position.top += overTop - newOverBottom;\n                        // element is initially over bottom of within\n                    } else if (overBottom > 0 && overTop <= 0) {\n                        position.top = withinOffset;\n                        // element is initially over both top and bottom of within\n                    } else {\n                        if (overTop > overBottom) {\n                            position.top = withinOffset + outerHeight - data.collisionHeight;\n                        } else {\n                            position.top = withinOffset;\n                        }\n                    }\n                    // too far up -> align with top\n                } else if (overTop > 0) {\n                    position.top += overTop;\n                    // too far down -> align with bottom edge\n                } else if (overBottom > 0) {\n                    position.top -= overBottom;\n                    // adjust based on position and margin\n                } else {\n                    position.top = max(position.top - collisionPosTop, position.top);\n                }\n            }\n        },\n        flip: {\n            left: function (position, data) {\n                var within = data.within,\n                    withinOffset = within.offset.left + within.scrollLeft,\n                    outerWidth = within.width,\n                    offsetLeft = within.isWindow ? within.scrollLeft : within.offset.left,\n                    collisionPosLeft = position.left - data.collisionPosition.marginLeft,\n                    overLeft = collisionPosLeft - offsetLeft,\n                    overRight = collisionPosLeft + data.collisionWidth - outerWidth - offsetLeft,\n                    myOffset = data.my[0] === \"left\" ?\n                        -data.elemWidth :\n                        data.my[0] === \"right\" ?\n                            data.elemWidth :\n                            0,\n                    atOffset = data.at[0] === \"left\" ?\n                        data.targetWidth :\n                        data.at[0] === \"right\" ?\n                            -data.targetWidth :\n                            0,\n                    offset = -2 * data.offset[0],\n                    newOverRight,\n                    newOverLeft;\n\n                if (overLeft < 0) {\n                    newOverRight = position.left + myOffset + atOffset + offset + data.collisionWidth - outerWidth - withinOffset;\n                    if (newOverRight < 0 || newOverRight < abs(overLeft)) {\n                        position.left += myOffset + atOffset + offset;\n                    }\n                } else if (overRight > 0) {\n                    newOverLeft = position.left - data.collisionPosition.marginLeft + myOffset + atOffset + offset - offsetLeft;\n                    if (newOverLeft > 0 || abs(newOverLeft) < overRight) {\n                        position.left += myOffset + atOffset + offset;\n                    }\n                }\n            },\n            top: function (position, data) {\n                var within = data.within,\n                    withinOffset = within.offset.top + within.scrollTop,\n                    outerHeight = within.height,\n                    offsetTop = within.isWindow ? within.scrollTop : within.offset.top,\n                    collisionPosTop = position.top - data.collisionPosition.marginTop,\n                    overTop = collisionPosTop - offsetTop,\n                    overBottom = collisionPosTop + data.collisionHeight - outerHeight - offsetTop,\n                    top = data.my[1] === \"top\",\n                    myOffset = top ?\n                        -data.elemHeight :\n                        data.my[1] === \"bottom\" ?\n                            data.elemHeight :\n                            0,\n                    atOffset = data.at[1] === \"top\" ?\n                        data.targetHeight :\n                        data.at[1] === \"bottom\" ?\n                            -data.targetHeight :\n                            0,\n                    offset = -2 * data.offset[1],\n                    newOverTop,\n                    newOverBottom;\n                if (overTop < 0) {\n                    newOverBottom = position.top + myOffset + atOffset + offset + data.collisionHeight - outerHeight - withinOffset;\n                    if ((position.top + myOffset + atOffset + offset) > overTop && (newOverBottom < 0 || newOverBottom < abs(overTop))) {\n                        position.top += myOffset + atOffset + offset;\n                    }\n                } else if (overBottom > 0) {\n                    newOverTop = position.top - data.collisionPosition.marginTop + myOffset + atOffset + offset - offsetTop;\n                    if ((position.top + myOffset + atOffset + offset) > overBottom && (newOverTop > 0 || abs(newOverTop) < overBottom)) {\n                        position.top += myOffset + atOffset + offset;\n                    }\n                }\n            }\n        },\n        flipfit: {\n            left: function () {\n                $.ui.position.flip.left.apply(this, arguments);\n                $.ui.position.fit.left.apply(this, arguments);\n            },\n            top: function () {\n                $.ui.position.flip.top.apply(this, arguments);\n                $.ui.position.fit.top.apply(this, arguments);\n            }\n        }\n    };\n\n// fraction support test\n    (function () {\n        var testElement, testElementParent, testElementStyle, offsetLeft, i,\n            body = document.getElementsByTagName(\"body\")[0],\n            div = document.createElement(\"div\");\n\n        //Create a \"fake body\" for testing based on method used in jQuery.support\n        testElement = document.createElement(body ? \"div\" : \"body\");\n        testElementStyle = {\n            visibility: \"hidden\",\n            width: 0,\n            height: 0,\n            border: 0,\n            margin: 0,\n            background: \"none\"\n        };\n        if (body) {\n            $.extend(testElementStyle, {\n                position: \"absolute\",\n                left: \"-1000px\",\n                top: \"-1000px\"\n            });\n        }\n        for (i in testElementStyle) {\n            testElement.style[i] = testElementStyle[i];\n        }\n        testElement.appendChild(div);\n        testElementParent = body || document.documentElement;\n        testElementParent.insertBefore(testElement, testElementParent.firstChild);\n\n        div.style.cssText = \"position: absolute; left: 10.7432222px;\";\n\n        offsetLeft = $(div).offset().left;\n        $.support.offsetFractions = offsetLeft > 10 && offsetLeft < 11;\n\n        testElement.innerHTML = \"\";\n        testElementParent.removeChild(testElement);\n    })();\n\n});\n","jquery/ui-modules/selectable.js":"/*!\n * jQuery UI Selectable - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/selectable/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/mouse'\n], function ($, undefined) {\n\n    $.widget(\"ui.selectable\", $.ui.mouse, {\n        version: \"1.10.4\",\n        options: {\n            appendTo: \"body\",\n            autoRefresh: true,\n            distance: 0,\n            filter: \"*\",\n            tolerance: \"touch\",\n\n            // callbacks\n            selected: null,\n            selecting: null,\n            start: null,\n            stop: null,\n            unselected: null,\n            unselecting: null\n        },\n        _create: function () {\n            var selectees,\n                that = this;\n\n            this.element.addClass(\"ui-selectable\");\n\n            this.dragged = false;\n\n            // cache selectee children based on filter\n            this.refresh = function () {\n                selectees = $(that.options.filter, that.element[0]);\n                selectees.addClass(\"ui-selectee\");\n                selectees.each(function () {\n                    var $this = $(this),\n                        pos = $this.offset();\n                    $.data(this, \"selectable-item\", {\n                        element: this,\n                        $element: $this,\n                        left: pos.left,\n                        top: pos.top,\n                        right: pos.left + $this.outerWidth(),\n                        bottom: pos.top + $this.outerHeight(),\n                        startselected: false,\n                        selected: $this.hasClass(\"ui-selected\"),\n                        selecting: $this.hasClass(\"ui-selecting\"),\n                        unselecting: $this.hasClass(\"ui-unselecting\")\n                    });\n                });\n            };\n            this.refresh();\n\n            this.selectees = selectees.addClass(\"ui-selectee\");\n\n            this._mouseInit();\n\n            this.helper = $(\"<div class='ui-selectable-helper'></div>\");\n        },\n\n        _destroy: function () {\n            this.selectees\n                .removeClass(\"ui-selectee\")\n                .removeData(\"selectable-item\");\n            this.element\n                .removeClass(\"ui-selectable ui-selectable-disabled\");\n            this._mouseDestroy();\n        },\n\n        _mouseStart: function (event) {\n            var that = this,\n                options = this.options;\n\n            this.opos = [event.pageX, event.pageY];\n\n            if (this.options.disabled) {\n                return;\n            }\n\n            this.selectees = $(options.filter, this.element[0]);\n\n            this._trigger(\"start\", event);\n\n            $(options.appendTo).append(this.helper);\n            // position helper (lasso)\n            this.helper.css({\n                \"left\": event.pageX,\n                \"top\": event.pageY,\n                \"width\": 0,\n                \"height\": 0\n            });\n\n            if (options.autoRefresh) {\n                this.refresh();\n            }\n\n            this.selectees.filter(\".ui-selected\").each(function () {\n                var selectee = $.data(this, \"selectable-item\");\n                selectee.startselected = true;\n                if (!event.metaKey && !event.ctrlKey) {\n                    selectee.$element.removeClass(\"ui-selected\");\n                    selectee.selected = false;\n                    selectee.$element.addClass(\"ui-unselecting\");\n                    selectee.unselecting = true;\n                    // selectable UNSELECTING callback\n                    that._trigger(\"unselecting\", event, {\n                        unselecting: selectee.element\n                    });\n                }\n            });\n\n            $(event.target).parents().addBack().each(function () {\n                var doSelect,\n                    selectee = $.data(this, \"selectable-item\");\n                if (selectee) {\n                    doSelect = (!event.metaKey && !event.ctrlKey) || !selectee.$element.hasClass(\"ui-selected\");\n                    selectee.$element\n                        .removeClass(doSelect ? \"ui-unselecting\" : \"ui-selected\")\n                        .addClass(doSelect ? \"ui-selecting\" : \"ui-unselecting\");\n                    selectee.unselecting = !doSelect;\n                    selectee.selecting = doSelect;\n                    selectee.selected = doSelect;\n                    // selectable (UN)SELECTING callback\n                    if (doSelect) {\n                        that._trigger(\"selecting\", event, {\n                            selecting: selectee.element\n                        });\n                    } else {\n                        that._trigger(\"unselecting\", event, {\n                            unselecting: selectee.element\n                        });\n                    }\n                    return false;\n                }\n            });\n\n        },\n\n        _mouseDrag: function (event) {\n\n            this.dragged = true;\n\n            if (this.options.disabled) {\n                return;\n            }\n\n            var tmp,\n                that = this,\n                options = this.options,\n                x1 = this.opos[0],\n                y1 = this.opos[1],\n                x2 = event.pageX,\n                y2 = event.pageY;\n\n            if (x1 > x2) {\n                tmp = x2;\n                x2 = x1;\n                x1 = tmp;\n            }\n            if (y1 > y2) {\n                tmp = y2;\n                y2 = y1;\n                y1 = tmp;\n            }\n            this.helper.css({left: x1, top: y1, width: x2 - x1, height: y2 - y1});\n\n            this.selectees.each(function () {\n                var selectee = $.data(this, \"selectable-item\"),\n                    hit = false;\n\n                //prevent helper from being selected if appendTo: selectable\n                if (!selectee || selectee.element === that.element[0]) {\n                    return;\n                }\n\n                if (options.tolerance === \"touch\") {\n                    hit = (!(selectee.left > x2 || selectee.right < x1 || selectee.top > y2 || selectee.bottom < y1));\n                } else if (options.tolerance === \"fit\") {\n                    hit = (selectee.left > x1 && selectee.right < x2 && selectee.top > y1 && selectee.bottom < y2);\n                }\n\n                if (hit) {\n                    // SELECT\n                    if (selectee.selected) {\n                        selectee.$element.removeClass(\"ui-selected\");\n                        selectee.selected = false;\n                    }\n                    if (selectee.unselecting) {\n                        selectee.$element.removeClass(\"ui-unselecting\");\n                        selectee.unselecting = false;\n                    }\n                    if (!selectee.selecting) {\n                        selectee.$element.addClass(\"ui-selecting\");\n                        selectee.selecting = true;\n                        // selectable SELECTING callback\n                        that._trigger(\"selecting\", event, {\n                            selecting: selectee.element\n                        });\n                    }\n                } else {\n                    // UNSELECT\n                    if (selectee.selecting) {\n                        if ((event.metaKey || event.ctrlKey) && selectee.startselected) {\n                            selectee.$element.removeClass(\"ui-selecting\");\n                            selectee.selecting = false;\n                            selectee.$element.addClass(\"ui-selected\");\n                            selectee.selected = true;\n                        } else {\n                            selectee.$element.removeClass(\"ui-selecting\");\n                            selectee.selecting = false;\n                            if (selectee.startselected) {\n                                selectee.$element.addClass(\"ui-unselecting\");\n                                selectee.unselecting = true;\n                            }\n                            // selectable UNSELECTING callback\n                            that._trigger(\"unselecting\", event, {\n                                unselecting: selectee.element\n                            });\n                        }\n                    }\n                    if (selectee.selected) {\n                        if (!event.metaKey && !event.ctrlKey && !selectee.startselected) {\n                            selectee.$element.removeClass(\"ui-selected\");\n                            selectee.selected = false;\n\n                            selectee.$element.addClass(\"ui-unselecting\");\n                            selectee.unselecting = true;\n                            // selectable UNSELECTING callback\n                            that._trigger(\"unselecting\", event, {\n                                unselecting: selectee.element\n                            });\n                        }\n                    }\n                }\n            });\n\n            return false;\n        },\n\n        _mouseStop: function (event) {\n            var that = this;\n\n            this.dragged = false;\n\n            $(\".ui-unselecting\", this.element[0]).each(function () {\n                var selectee = $.data(this, \"selectable-item\");\n                selectee.$element.removeClass(\"ui-unselecting\");\n                selectee.unselecting = false;\n                selectee.startselected = false;\n                that._trigger(\"unselected\", event, {\n                    unselected: selectee.element\n                });\n            });\n            $(\".ui-selecting\", this.element[0]).each(function () {\n                var selectee = $.data(this, \"selectable-item\");\n                selectee.$element.removeClass(\"ui-selecting\").addClass(\"ui-selected\");\n                selectee.selecting = false;\n                selectee.selected = true;\n                selectee.startselected = true;\n                that._trigger(\"selected\", event, {\n                    selected: selectee.element\n                });\n            });\n            this._trigger(\"stop\", event);\n\n            this.helper.remove();\n\n            return false;\n        }\n\n    });\n\n});\n","jquery/ui-modules/effect-shake.js":"/*!\n * jQuery UI Effects Shake - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/shake-effect/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.shake = function (o, done) {\n\n        var el = $(this),\n            props = [\"position\", \"top\", \"bottom\", \"left\", \"right\", \"height\", \"width\"],\n            mode = $.effects.setMode(el, o.mode || \"effect\"),\n            direction = o.direction || \"left\",\n            distance = o.distance || 20,\n            times = o.times || 3,\n            anims = times * 2 + 1,\n            speed = Math.round(o.duration / anims),\n            ref = (direction === \"up\" || direction === \"down\") ? \"top\" : \"left\",\n            positiveMotion = (direction === \"up\" || direction === \"left\"),\n            animation = {},\n            animation1 = {},\n            animation2 = {},\n            i,\n\n            // we will need to re-assemble the queue to stack our animations in place\n            queue = el.queue(),\n            queuelen = queue.length;\n\n        $.effects.save(el, props);\n        el.show();\n        $.effects.createWrapper(el);\n\n        // Animation\n        animation[ref] = (positiveMotion ? \"-=\" : \"+=\") + distance;\n        animation1[ref] = (positiveMotion ? \"+=\" : \"-=\") + distance * 2;\n        animation2[ref] = (positiveMotion ? \"-=\" : \"+=\") + distance * 2;\n\n        // Animate\n        el.animate(animation, speed, o.easing);\n\n        // Shakes\n        for (i = 1; i < times; i++) {\n            el.animate(animation1, speed, o.easing).animate(animation2, speed, o.easing);\n        }\n        el\n            .animate(animation1, speed, o.easing)\n            .animate(animation, speed / 2, o.easing)\n            .queue(function () {\n                if (mode === \"hide\") {\n                    el.hide();\n                }\n                $.effects.restore(el, props);\n                $.effects.removeWrapper(el);\n                done();\n            });\n\n        // inject all the animations we just queued to be first in line (after \"inprogress\")\n        if (queuelen > 1) {\n            queue.splice.apply(queue,\n                [1, 0].concat(queue.splice(queuelen, anims + 1)));\n        }\n        el.dequeue();\n\n    };\n\n});\n","jquery/ui-modules/progressbar.js":"/*!\n * jQuery UI Progressbar - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/progressbar/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/widget'\n], function ($, undefined) {\n\n    $.widget(\"ui.progressbar\", {\n        version: \"1.10.4\",\n        options: {\n            max: 100,\n            value: 0,\n\n            change: null,\n            complete: null\n        },\n\n        min: 0,\n\n        _create: function () {\n            // Constrain initial value\n            this.oldValue = this.options.value = this._constrainedValue();\n\n            this.element\n                .addClass(\"ui-progressbar ui-widget ui-widget-content ui-corner-all\")\n                .attr({\n                    // Only set static values, aria-valuenow and aria-valuemax are\n                    // set inside _refreshValue()\n                    role: \"progressbar\",\n                    \"aria-valuemin\": this.min\n                });\n\n            this.valueDiv = $(\"<div class='ui-progressbar-value ui-widget-header ui-corner-left'></div>\")\n                .appendTo(this.element);\n\n            this._refreshValue();\n        },\n\n        _destroy: function () {\n            this.element\n                .removeClass(\"ui-progressbar ui-widget ui-widget-content ui-corner-all\")\n                .removeAttr(\"role\")\n                .removeAttr(\"aria-valuemin\")\n                .removeAttr(\"aria-valuemax\")\n                .removeAttr(\"aria-valuenow\");\n\n            this.valueDiv.remove();\n        },\n\n        value: function (newValue) {\n            if (newValue === undefined) {\n                return this.options.value;\n            }\n\n            this.options.value = this._constrainedValue(newValue);\n            this._refreshValue();\n        },\n\n        _constrainedValue: function (newValue) {\n            if (newValue === undefined) {\n                newValue = this.options.value;\n            }\n\n            this.indeterminate = newValue === false;\n\n            // sanitize value\n            if (typeof newValue !== \"number\") {\n                newValue = 0;\n            }\n\n            return this.indeterminate ? false :\n                Math.min(this.options.max, Math.max(this.min, newValue));\n        },\n\n        _setOptions: function (options) {\n            // Ensure \"value\" option is set after other values (like max)\n            var value = options.value;\n            delete options.value;\n\n            this._super(options);\n\n            this.options.value = this._constrainedValue(value);\n            this._refreshValue();\n        },\n\n        _setOption: function (key, value) {\n            if (key === \"max\") {\n                // Don't allow a max less than min\n                value = Math.max(this.min, value);\n            }\n\n            this._super(key, value);\n        },\n\n        _percentage: function () {\n            return this.indeterminate ? 100 : 100 * (this.options.value - this.min) / (this.options.max - this.min);\n        },\n\n        _refreshValue: function () {\n            var value = this.options.value,\n                percentage = this._percentage();\n\n            this.valueDiv\n                .toggle(this.indeterminate || value > this.min)\n                .toggleClass(\"ui-corner-right\", value === this.options.max)\n                .width(percentage.toFixed(0) + \"%\");\n\n            this.element.toggleClass(\"ui-progressbar-indeterminate\", this.indeterminate);\n\n            if (this.indeterminate) {\n                this.element.removeAttr(\"aria-valuenow\");\n                if (!this.overlayDiv) {\n                    this.overlayDiv = $(\"<div class='ui-progressbar-overlay'></div>\").appendTo(this.valueDiv);\n                }\n            } else {\n                this.element.attr({\n                    \"aria-valuemax\": this.options.max,\n                    \"aria-valuenow\": value\n                });\n                if (this.overlayDiv) {\n                    this.overlayDiv.remove();\n                    this.overlayDiv = null;\n                }\n            }\n\n            if (this.oldValue !== value) {\n                this.oldValue = value;\n                this._trigger(\"change\");\n            }\n            if (value === this.options.max) {\n                this._trigger(\"complete\");\n            }\n        }\n    });\n\n});\n","jquery/ui-modules/mouse.js":"/*!\n * jQuery UI Mouse - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/mouse/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($, undefined) {\n\n    var mouseHandled = false;\n    $(document).mouseup(function () {\n        mouseHandled = false;\n    });\n\n    $.widget(\"ui.mouse\", {\n        version: \"1.10.4\",\n        options: {\n            cancel: \"input,textarea,button,select,option\",\n            distance: 1,\n            delay: 0\n        },\n        _mouseInit: function () {\n            var that = this;\n\n            this.element\n                .bind(\"mousedown.\" + this.widgetName, function (event) {\n                    return that._mouseDown(event);\n                })\n                .bind(\"click.\" + this.widgetName, function (event) {\n                    if (true === $.data(event.target, that.widgetName + \".preventClickEvent\")) {\n                        $.removeData(event.target, that.widgetName + \".preventClickEvent\");\n                        event.stopImmediatePropagation();\n                        return false;\n                    }\n                });\n\n            this.started = false;\n        },\n\n        // TODO: make sure destroying one instance of mouse doesn't mess with\n        // other instances of mouse\n        _mouseDestroy: function () {\n            this.element.unbind(\".\" + this.widgetName);\n            if (this._mouseMoveDelegate) {\n                $(document)\n                    .unbind(\"mousemove.\" + this.widgetName, this._mouseMoveDelegate)\n                    .unbind(\"mouseup.\" + this.widgetName, this._mouseUpDelegate);\n            }\n        },\n\n        _mouseDown: function (event) {\n            // don't let more than one widget handle mouseStart\n            if (mouseHandled) {\n                return;\n            }\n\n            // we may have missed mouseup (out of window)\n            (this._mouseStarted && this._mouseUp(event));\n\n            this._mouseDownEvent = event;\n\n            var that = this,\n                btnIsLeft = (event.which === 1),\n                // event.target.nodeName works around a bug in IE 8 with\n                // disabled inputs (#7620)\n                elIsCancel = (typeof this.options.cancel === \"string\" && event.target.nodeName ? $(event.target).closest(this.options.cancel).length : false);\n            if (!btnIsLeft || elIsCancel || !this._mouseCapture(event)) {\n                return true;\n            }\n\n            this.mouseDelayMet = !this.options.delay;\n            if (!this.mouseDelayMet) {\n                this._mouseDelayTimer = setTimeout(function () {\n                    that.mouseDelayMet = true;\n                }, this.options.delay);\n            }\n\n            if (this._mouseDistanceMet(event) && this._mouseDelayMet(event)) {\n                this._mouseStarted = (this._mouseStart(event) !== false);\n                if (!this._mouseStarted) {\n                    event.preventDefault();\n                    return true;\n                }\n            }\n\n            // Click event may never have fired (Gecko & Opera)\n            if (true === $.data(event.target, this.widgetName + \".preventClickEvent\")) {\n                $.removeData(event.target, this.widgetName + \".preventClickEvent\");\n            }\n\n            // these delegates are required to keep context\n            this._mouseMoveDelegate = function (event) {\n                return that._mouseMove(event);\n            };\n            this._mouseUpDelegate = function (event) {\n                return that._mouseUp(event);\n            };\n            $(document)\n                .bind(\"mousemove.\" + this.widgetName, this._mouseMoveDelegate)\n                .bind(\"mouseup.\" + this.widgetName, this._mouseUpDelegate);\n\n            event.preventDefault();\n\n            mouseHandled = true;\n            return true;\n        },\n\n        _mouseMove: function (event) {\n            // IE mouseup check - mouseup happened when mouse was out of window\n            if ($.ui.ie && (!document.documentMode || document.documentMode < 9) && !event.button) {\n                return this._mouseUp(event);\n            }\n\n            if (this._mouseStarted) {\n                this._mouseDrag(event);\n                return event.preventDefault();\n            }\n\n            if (this._mouseDistanceMet(event) && this._mouseDelayMet(event)) {\n                this._mouseStarted =\n                    (this._mouseStart(this._mouseDownEvent, event) !== false);\n                (this._mouseStarted ? this._mouseDrag(event) : this._mouseUp(event));\n            }\n\n            return !this._mouseStarted;\n        },\n\n        _mouseUp: function (event) {\n            $(document)\n                .unbind(\"mousemove.\" + this.widgetName, this._mouseMoveDelegate)\n                .unbind(\"mouseup.\" + this.widgetName, this._mouseUpDelegate);\n\n            if (this._mouseStarted) {\n                this._mouseStarted = false;\n\n                if (event.target === this._mouseDownEvent.target) {\n                    $.data(event.target, this.widgetName + \".preventClickEvent\", true);\n                }\n\n                this._mouseStop(event);\n            }\n\n            return false;\n        },\n\n        _mouseDistanceMet: function (event) {\n            return (Math.max(\n                    Math.abs(this._mouseDownEvent.pageX - event.pageX),\n                    Math.abs(this._mouseDownEvent.pageY - event.pageY)\n                ) >= this.options.distance\n            );\n        },\n\n        _mouseDelayMet: function (/* event */) {\n            return this.mouseDelayMet;\n        },\n\n        // These are placeholder methods, to be overridden by extending plugin\n        _mouseStart: function (/* event */) {\n        },\n        _mouseDrag: function (/* event */) {\n        },\n        _mouseStop: function (/* event */) {\n        },\n        _mouseCapture: function (/* event */) {\n            return true;\n        }\n    });\n\n});\n","jquery/ui-modules/effect-drop.js":"/*!\n * jQuery UI Effects Drop - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/drop-effect/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.drop = function (o, done) {\n\n        var el = $(this),\n            props = [\"position\", \"top\", \"bottom\", \"left\", \"right\", \"opacity\", \"height\", \"width\"],\n            mode = $.effects.setMode(el, o.mode || \"hide\"),\n            show = mode === \"show\",\n            direction = o.direction || \"left\",\n            ref = (direction === \"up\" || direction === \"down\") ? \"top\" : \"left\",\n            motion = (direction === \"up\" || direction === \"left\") ? \"pos\" : \"neg\",\n            animation = {\n                opacity: show ? 1 : 0\n            },\n            distance;\n\n        // Adjust\n        $.effects.save(el, props);\n        el.show();\n        $.effects.createWrapper(el);\n\n        distance = o.distance || el[ref === \"top\" ? \"outerHeight\" : \"outerWidth\"](true) / 2;\n\n        if (show) {\n            el\n                .css(\"opacity\", 0)\n                .css(ref, motion === \"pos\" ? -distance : distance);\n        }\n\n        // Animation\n        animation[ref] = (show ?\n            (motion === \"pos\" ? \"+=\" : \"-=\") :\n            (motion === \"pos\" ? \"-=\" : \"+=\")) +\n            distance;\n\n        // Animate\n        el.animate(animation, {\n            queue: false,\n            duration: o.duration,\n            easing: o.easing,\n            complete: function () {\n                if (mode === \"hide\") {\n                    el.hide();\n                }\n                $.effects.restore(el, props);\n                $.effects.removeWrapper(el);\n                done();\n            }\n        });\n    };\n\n});\n","jquery/ui-modules/resizable.js":"/*!\n * jQuery UI Resizable - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/resizable/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/mouse'\n], function ($, undefined) {\n\n    function num(v) {\n        return parseInt(v, 10) || 0;\n    }\n\n    function isNumber(value) {\n        return !isNaN(parseInt(value, 10));\n    }\n\n    $.widget(\"ui.resizable\", $.ui.mouse, {\n        version: \"1.10.4\",\n        widgetEventPrefix: \"resize\",\n        options: {\n            alsoResize: false,\n            animate: false,\n            animateDuration: \"slow\",\n            animateEasing: \"swing\",\n            aspectRatio: false,\n            autoHide: false,\n            containment: false,\n            ghost: false,\n            grid: false,\n            handles: \"e,s,se\",\n            helper: false,\n            maxHeight: null,\n            maxWidth: null,\n            minHeight: 10,\n            minWidth: 10,\n            // See #7960\n            zIndex: 90,\n\n            // callbacks\n            resize: null,\n            start: null,\n            stop: null\n        },\n        _create: function () {\n\n            var n, i, handle, axis, hname,\n                that = this,\n                o = this.options;\n            this.element.addClass(\"ui-resizable\");\n\n            $.extend(this, {\n                _aspectRatio: !!(o.aspectRatio),\n                aspectRatio: o.aspectRatio,\n                originalElement: this.element,\n                _proportionallyResizeElements: [],\n                _helper: o.helper || o.ghost || o.animate ? o.helper || \"ui-resizable-helper\" : null\n            });\n\n            //Wrap the element if it cannot hold child nodes\n            if (this.element[0].nodeName.match(/canvas|textarea|input|select|button|img/i)) {\n\n                //Create a wrapper element and set the wrapper to the new current internal element\n                this.element.wrap(\n                    $(\"<div class='ui-wrapper' style='overflow: hidden;'></div>\").css({\n                        position: this.element.css(\"position\"),\n                        width: this.element.outerWidth(),\n                        height: this.element.outerHeight(),\n                        top: this.element.css(\"top\"),\n                        left: this.element.css(\"left\")\n                    })\n                );\n\n                //Overwrite the original this.element\n                this.element = this.element.parent().data(\n                    \"ui-resizable\", this.element.data(\"ui-resizable\")\n                );\n\n                this.elementIsWrapper = true;\n\n                //Move margins to the wrapper\n                this.element.css({\n                    marginLeft: this.originalElement.css(\"marginLeft\"),\n                    marginTop: this.originalElement.css(\"marginTop\"),\n                    marginRight: this.originalElement.css(\"marginRight\"),\n                    marginBottom: this.originalElement.css(\"marginBottom\")\n                });\n                this.originalElement.css({marginLeft: 0, marginTop: 0, marginRight: 0, marginBottom: 0});\n\n                //Prevent Safari textarea resize\n                this.originalResizeStyle = this.originalElement.css(\"resize\");\n                this.originalElement.css(\"resize\", \"none\");\n\n                //Push the actual element to our proportionallyResize internal array\n                this._proportionallyResizeElements.push(this.originalElement.css({\n                    position: \"static\",\n                    zoom: 1,\n                    display: \"block\"\n                }));\n\n                // avoid IE jump (hard set the margin)\n                this.originalElement.css({margin: this.originalElement.css(\"margin\")});\n\n                // fix handlers offset\n                this._proportionallyResize();\n\n            }\n\n            this.handles = o.handles || (!$(\".ui-resizable-handle\", this.element).length ? \"e,s,se\" : {\n                n: \".ui-resizable-n\",\n                e: \".ui-resizable-e\",\n                s: \".ui-resizable-s\",\n                w: \".ui-resizable-w\",\n                se: \".ui-resizable-se\",\n                sw: \".ui-resizable-sw\",\n                ne: \".ui-resizable-ne\",\n                nw: \".ui-resizable-nw\"\n            });\n            if (this.handles.constructor === String) {\n\n                if (this.handles === \"all\") {\n                    this.handles = \"n,e,s,w,se,sw,ne,nw\";\n                }\n\n                n = this.handles.split(\",\");\n                this.handles = {};\n\n                for (i = 0; i < n.length; i++) {\n\n                    handle = $.trim(n[i]);\n                    hname = \"ui-resizable-\" + handle;\n                    axis = $(\"<div class='ui-resizable-handle \" + hname + \"'></div>\");\n\n                    // Apply zIndex to all handles - see #7960\n                    axis.css({zIndex: o.zIndex});\n\n                    //TODO : What's going on here?\n                    if (\"se\" === handle) {\n                        axis.addClass(\"ui-icon ui-icon-gripsmall-diagonal-se\");\n                    }\n\n                    //Insert into internal handles object and append to element\n                    this.handles[handle] = \".ui-resizable-\" + handle;\n                    this.element.append(axis);\n                }\n\n            }\n\n            this._renderAxis = function (target) {\n\n                var i, axis, padPos, padWrapper;\n\n                target = target || this.element;\n\n                for (i in this.handles) {\n\n                    if (this.handles[i].constructor === String) {\n                        this.handles[i] = $(this.handles[i], this.element).show();\n                    }\n\n                    //Apply pad to wrapper element, needed to fix axis position (textarea, inputs, scrolls)\n                    if (this.elementIsWrapper && this.originalElement[0].nodeName.match(/textarea|input|select|button/i)) {\n\n                        axis = $(this.handles[i], this.element);\n\n                        //Checking the correct pad and border\n                        padWrapper = /sw|ne|nw|se|n|s/.test(i) ? axis.outerHeight() : axis.outerWidth();\n\n                        //The padding type i have to apply...\n                        padPos = [\"padding\",\n                            /ne|nw|n/.test(i) ? \"Top\" :\n                                /se|sw|s/.test(i) ? \"Bottom\" :\n                                    /^e$/.test(i) ? \"Right\" : \"Left\"].join(\"\");\n\n                        target.css(padPos, padWrapper);\n\n                        this._proportionallyResize();\n\n                    }\n\n                    //TODO: What's that good for? There's not anything to be executed left\n                    if (!$(this.handles[i]).length) {\n                        continue;\n                    }\n                }\n            };\n\n            //TODO: make renderAxis a prototype function\n            this._renderAxis(this.element);\n\n            this._handles = $(\".ui-resizable-handle\", this.element)\n                .disableSelection();\n\n            //Matching axis name\n            this._handles.mouseover(function () {\n                if (!that.resizing) {\n                    if (this.className) {\n                        axis = this.className.match(/ui-resizable-(se|sw|ne|nw|n|e|s|w)/i);\n                    }\n                    //Axis, default = se\n                    that.axis = axis && axis[1] ? axis[1] : \"se\";\n                }\n            });\n\n            //If we want to auto hide the elements\n            if (o.autoHide) {\n                this._handles.hide();\n                $(this.element)\n                    .addClass(\"ui-resizable-autohide\")\n                    .mouseenter(function () {\n                        if (o.disabled) {\n                            return;\n                        }\n                        $(this).removeClass(\"ui-resizable-autohide\");\n                        that._handles.show();\n                    })\n                    .mouseleave(function () {\n                        if (o.disabled) {\n                            return;\n                        }\n                        if (!that.resizing) {\n                            $(this).addClass(\"ui-resizable-autohide\");\n                            that._handles.hide();\n                        }\n                    });\n            }\n\n            //Initialize the mouse interaction\n            this._mouseInit();\n\n        },\n\n        _destroy: function () {\n\n            this._mouseDestroy();\n\n            var wrapper,\n                _destroy = function (exp) {\n                    $(exp).removeClass(\"ui-resizable ui-resizable-disabled ui-resizable-resizing\")\n                        .removeData(\"resizable\").removeData(\"ui-resizable\").unbind(\".resizable\").find(\".ui-resizable-handle\").remove();\n                };\n\n            //TODO: Unwrap at same DOM position\n            if (this.elementIsWrapper) {\n                _destroy(this.element);\n                wrapper = this.element;\n                this.originalElement.css({\n                    position: wrapper.css(\"position\"),\n                    width: wrapper.outerWidth(),\n                    height: wrapper.outerHeight(),\n                    top: wrapper.css(\"top\"),\n                    left: wrapper.css(\"left\")\n                }).insertAfter(wrapper);\n                wrapper.remove();\n            }\n\n            this.originalElement.css(\"resize\", this.originalResizeStyle);\n            _destroy(this.originalElement);\n\n            return this;\n        },\n\n        _mouseCapture: function (event) {\n            var i, handle,\n                capture = false;\n\n            for (i in this.handles) {\n                handle = $(this.handles[i])[0];\n                if (handle === event.target || $.contains(handle, event.target)) {\n                    capture = true;\n                }\n            }\n\n            return !this.options.disabled && capture;\n        },\n\n        _mouseStart: function (event) {\n\n            var curleft, curtop, cursor,\n                o = this.options,\n                iniPos = this.element.position(),\n                el = this.element;\n\n            this.resizing = true;\n\n            // bugfix for http://dev.jquery.com/ticket/1749\n            if ((/absolute/).test(el.css(\"position\"))) {\n                el.css({position: \"absolute\", top: el.css(\"top\"), left: el.css(\"left\")});\n            } else if (el.is(\".ui-draggable\")) {\n                el.css({position: \"absolute\", top: iniPos.top, left: iniPos.left});\n            }\n\n            this._renderProxy();\n\n            curleft = num(this.helper.css(\"left\"));\n            curtop = num(this.helper.css(\"top\"));\n\n            if (o.containment) {\n                curleft += $(o.containment).scrollLeft() || 0;\n                curtop += $(o.containment).scrollTop() || 0;\n            }\n\n            //Store needed variables\n            this.offset = this.helper.offset();\n            this.position = {left: curleft, top: curtop};\n            this.size = this._helper ? {width: this.helper.width(), height: this.helper.height()} : {\n                width: el.width(),\n                height: el.height()\n            };\n            this.originalSize = this._helper ? {width: el.outerWidth(), height: el.outerHeight()} : {\n                width: el.width(),\n                height: el.height()\n            };\n            this.originalPosition = {left: curleft, top: curtop};\n            this.sizeDiff = {width: el.outerWidth() - el.width(), height: el.outerHeight() - el.height()};\n            this.originalMousePosition = {left: event.pageX, top: event.pageY};\n\n            //Aspect Ratio\n            this.aspectRatio = (typeof o.aspectRatio === \"number\") ? o.aspectRatio : ((this.originalSize.width / this.originalSize.height) || 1);\n\n            cursor = $(\".ui-resizable-\" + this.axis).css(\"cursor\");\n            $(\"body\").css(\"cursor\", cursor === \"auto\" ? this.axis + \"-resize\" : cursor);\n\n            el.addClass(\"ui-resizable-resizing\");\n            this._propagate(\"start\", event);\n            return true;\n        },\n\n        _mouseDrag: function (event) {\n\n            //Increase performance, avoid regex\n            var data,\n                el = this.helper, props = {},\n                smp = this.originalMousePosition,\n                a = this.axis,\n                prevTop = this.position.top,\n                prevLeft = this.position.left,\n                prevWidth = this.size.width,\n                prevHeight = this.size.height,\n                dx = (event.pageX - smp.left) || 0,\n                dy = (event.pageY - smp.top) || 0,\n                trigger = this._change[a];\n\n            if (!trigger) {\n                return false;\n            }\n\n            // Calculate the attrs that will be change\n            data = trigger.apply(this, [event, dx, dy]);\n\n            // Put this in the mouseDrag handler since the user can start pressing shift while resizing\n            this._updateVirtualBoundaries(event.shiftKey);\n            if (this._aspectRatio || event.shiftKey) {\n                data = this._updateRatio(data, event);\n            }\n\n            data = this._respectSize(data, event);\n\n            this._updateCache(data);\n\n            // plugins callbacks need to be called first\n            this._propagate(\"resize\", event);\n\n            if (this.position.top !== prevTop) {\n                props.top = this.position.top + \"px\";\n            }\n            if (this.position.left !== prevLeft) {\n                props.left = this.position.left + \"px\";\n            }\n            if (this.size.width !== prevWidth) {\n                props.width = this.size.width + \"px\";\n            }\n            if (this.size.height !== prevHeight) {\n                props.height = this.size.height + \"px\";\n            }\n            el.css(props);\n\n            if (!this._helper && this._proportionallyResizeElements.length) {\n                this._proportionallyResize();\n            }\n\n            // Call the user callback if the element was resized\n            if (!$.isEmptyObject(props)) {\n                this._trigger(\"resize\", event, this.ui());\n            }\n\n            return false;\n        },\n\n        _mouseStop: function (event) {\n\n            this.resizing = false;\n            var pr, ista, soffseth, soffsetw, s, left, top,\n                o = this.options, that = this;\n\n            if (this._helper) {\n\n                pr = this._proportionallyResizeElements;\n                ista = pr.length && (/textarea/i).test(pr[0].nodeName);\n                soffseth = ista && $.ui.hasScroll(pr[0], \"left\") /* TODO - jump height */ ? 0 : that.sizeDiff.height;\n                soffsetw = ista ? 0 : that.sizeDiff.width;\n\n                s = {width: (that.helper.width() - soffsetw), height: (that.helper.height() - soffseth)};\n                left = (parseInt(that.element.css(\"left\"), 10) + (that.position.left - that.originalPosition.left)) || null;\n                top = (parseInt(that.element.css(\"top\"), 10) + (that.position.top - that.originalPosition.top)) || null;\n\n                if (!o.animate) {\n                    this.element.css($.extend(s, {top: top, left: left}));\n                }\n\n                that.helper.height(that.size.height);\n                that.helper.width(that.size.width);\n\n                if (this._helper && !o.animate) {\n                    this._proportionallyResize();\n                }\n            }\n\n            $(\"body\").css(\"cursor\", \"auto\");\n\n            this.element.removeClass(\"ui-resizable-resizing\");\n\n            this._propagate(\"stop\", event);\n\n            if (this._helper) {\n                this.helper.remove();\n            }\n\n            return false;\n\n        },\n\n        _updateVirtualBoundaries: function (forceAspectRatio) {\n            var pMinWidth, pMaxWidth, pMinHeight, pMaxHeight, b,\n                o = this.options;\n\n            b = {\n                minWidth: isNumber(o.minWidth) ? o.minWidth : 0,\n                maxWidth: isNumber(o.maxWidth) ? o.maxWidth : Infinity,\n                minHeight: isNumber(o.minHeight) ? o.minHeight : 0,\n                maxHeight: isNumber(o.maxHeight) ? o.maxHeight : Infinity\n            };\n\n            if (this._aspectRatio || forceAspectRatio) {\n                // We want to create an enclosing box whose aspect ration is the requested one\n                // First, compute the \"projected\" size for each dimension based on the aspect ratio and other dimension\n                pMinWidth = b.minHeight * this.aspectRatio;\n                pMinHeight = b.minWidth / this.aspectRatio;\n                pMaxWidth = b.maxHeight * this.aspectRatio;\n                pMaxHeight = b.maxWidth / this.aspectRatio;\n\n                if (pMinWidth > b.minWidth) {\n                    b.minWidth = pMinWidth;\n                }\n                if (pMinHeight > b.minHeight) {\n                    b.minHeight = pMinHeight;\n                }\n                if (pMaxWidth < b.maxWidth) {\n                    b.maxWidth = pMaxWidth;\n                }\n                if (pMaxHeight < b.maxHeight) {\n                    b.maxHeight = pMaxHeight;\n                }\n            }\n            this._vBoundaries = b;\n        },\n\n        _updateCache: function (data) {\n            this.offset = this.helper.offset();\n            if (isNumber(data.left)) {\n                this.position.left = data.left;\n            }\n            if (isNumber(data.top)) {\n                this.position.top = data.top;\n            }\n            if (isNumber(data.height)) {\n                this.size.height = data.height;\n            }\n            if (isNumber(data.width)) {\n                this.size.width = data.width;\n            }\n        },\n\n        _updateRatio: function (data) {\n\n            var cpos = this.position,\n                csize = this.size,\n                a = this.axis;\n\n            if (isNumber(data.height)) {\n                data.width = (data.height * this.aspectRatio);\n            } else if (isNumber(data.width)) {\n                data.height = (data.width / this.aspectRatio);\n            }\n\n            if (a === \"sw\") {\n                data.left = cpos.left + (csize.width - data.width);\n                data.top = null;\n            }\n            if (a === \"nw\") {\n                data.top = cpos.top + (csize.height - data.height);\n                data.left = cpos.left + (csize.width - data.width);\n            }\n\n            return data;\n        },\n\n        _respectSize: function (data) {\n\n            var o = this._vBoundaries,\n                a = this.axis,\n                ismaxw = isNumber(data.width) && o.maxWidth && (o.maxWidth < data.width),\n                ismaxh = isNumber(data.height) && o.maxHeight && (o.maxHeight < data.height),\n                isminw = isNumber(data.width) && o.minWidth && (o.minWidth > data.width),\n                isminh = isNumber(data.height) && o.minHeight && (o.minHeight > data.height),\n                dw = this.originalPosition.left + this.originalSize.width,\n                dh = this.position.top + this.size.height,\n                cw = /sw|nw|w/.test(a), ch = /nw|ne|n/.test(a);\n            if (isminw) {\n                data.width = o.minWidth;\n            }\n            if (isminh) {\n                data.height = o.minHeight;\n            }\n            if (ismaxw) {\n                data.width = o.maxWidth;\n            }\n            if (ismaxh) {\n                data.height = o.maxHeight;\n            }\n\n            if (isminw && cw) {\n                data.left = dw - o.minWidth;\n            }\n            if (ismaxw && cw) {\n                data.left = dw - o.maxWidth;\n            }\n            if (isminh && ch) {\n                data.top = dh - o.minHeight;\n            }\n            if (ismaxh && ch) {\n                data.top = dh - o.maxHeight;\n            }\n\n            // fixing jump error on top/left - bug #2330\n            if (!data.width && !data.height && !data.left && data.top) {\n                data.top = null;\n            } else if (!data.width && !data.height && !data.top && data.left) {\n                data.left = null;\n            }\n\n            return data;\n        },\n\n        _proportionallyResize: function () {\n\n            if (!this._proportionallyResizeElements.length) {\n                return;\n            }\n\n            var i, j, borders, paddings, prel,\n                element = this.helper || this.element;\n\n            for (i = 0; i < this._proportionallyResizeElements.length; i++) {\n\n                prel = this._proportionallyResizeElements[i];\n\n                if (!this.borderDif) {\n                    this.borderDif = [];\n                    borders = [prel.css(\"borderTopWidth\"), prel.css(\"borderRightWidth\"), prel.css(\"borderBottomWidth\"), prel.css(\"borderLeftWidth\")];\n                    paddings = [prel.css(\"paddingTop\"), prel.css(\"paddingRight\"), prel.css(\"paddingBottom\"), prel.css(\"paddingLeft\")];\n\n                    for (j = 0; j < borders.length; j++) {\n                        this.borderDif[j] = (parseInt(borders[j], 10) || 0) + (parseInt(paddings[j], 10) || 0);\n                    }\n                }\n\n                prel.css({\n                    height: (element.height() - this.borderDif[0] - this.borderDif[2]) || 0,\n                    width: (element.width() - this.borderDif[1] - this.borderDif[3]) || 0\n                });\n\n            }\n\n        },\n\n        _renderProxy: function () {\n\n            var el = this.element, o = this.options;\n            this.elementOffset = el.offset();\n\n            if (this._helper) {\n\n                this.helper = this.helper || $(\"<div style='overflow:hidden;'></div>\");\n\n                this.helper.addClass(this._helper).css({\n                    width: this.element.outerWidth() - 1,\n                    height: this.element.outerHeight() - 1,\n                    position: \"absolute\",\n                    left: this.elementOffset.left + \"px\",\n                    top: this.elementOffset.top + \"px\",\n                    zIndex: ++o.zIndex //TODO: Don't modify option\n                });\n\n                this.helper\n                    .appendTo(\"body\")\n                    .disableSelection();\n\n            } else {\n                this.helper = this.element;\n            }\n\n        },\n\n        _change: {\n            e: function (event, dx) {\n                return {width: this.originalSize.width + dx};\n            },\n            w: function (event, dx) {\n                var cs = this.originalSize, sp = this.originalPosition;\n                return {left: sp.left + dx, width: cs.width - dx};\n            },\n            n: function (event, dx, dy) {\n                var cs = this.originalSize, sp = this.originalPosition;\n                return {top: sp.top + dy, height: cs.height - dy};\n            },\n            s: function (event, dx, dy) {\n                return {height: this.originalSize.height + dy};\n            },\n            se: function (event, dx, dy) {\n                return $.extend(this._change.s.apply(this, arguments), this._change.e.apply(this, [event, dx, dy]));\n            },\n            sw: function (event, dx, dy) {\n                return $.extend(this._change.s.apply(this, arguments), this._change.w.apply(this, [event, dx, dy]));\n            },\n            ne: function (event, dx, dy) {\n                return $.extend(this._change.n.apply(this, arguments), this._change.e.apply(this, [event, dx, dy]));\n            },\n            nw: function (event, dx, dy) {\n                return $.extend(this._change.n.apply(this, arguments), this._change.w.apply(this, [event, dx, dy]));\n            }\n        },\n\n        _propagate: function (n, event) {\n            $.ui.plugin.call(this, n, [event, this.ui()]);\n            (n !== \"resize\" && this._trigger(n, event, this.ui()));\n        },\n\n        plugins: {},\n\n        ui: function () {\n            return {\n                originalElement: this.originalElement,\n                element: this.element,\n                helper: this.helper,\n                position: this.position,\n                size: this.size,\n                originalSize: this.originalSize,\n                originalPosition: this.originalPosition\n            };\n        }\n\n    });\n\n    /*\n     * Resizable Extensions\n     */\n\n    $.ui.plugin.add(\"resizable\", \"animate\", {\n\n        stop: function (event) {\n            var that = $(this).data(\"ui-resizable\"),\n                o = that.options,\n                pr = that._proportionallyResizeElements,\n                ista = pr.length && (/textarea/i).test(pr[0].nodeName),\n                soffseth = ista && $.ui.hasScroll(pr[0], \"left\") /* TODO - jump height */ ? 0 : that.sizeDiff.height,\n                soffsetw = ista ? 0 : that.sizeDiff.width,\n                style = {width: (that.size.width - soffsetw), height: (that.size.height - soffseth)},\n                left = (parseInt(that.element.css(\"left\"), 10) + (that.position.left - that.originalPosition.left)) || null,\n                top = (parseInt(that.element.css(\"top\"), 10) + (that.position.top - that.originalPosition.top)) || null;\n\n            that.element.animate(\n                $.extend(style, top && left ? {top: top, left: left} : {}), {\n                    duration: o.animateDuration,\n                    easing: o.animateEasing,\n                    step: function () {\n\n                        var data = {\n                            width: parseInt(that.element.css(\"width\"), 10),\n                            height: parseInt(that.element.css(\"height\"), 10),\n                            top: parseInt(that.element.css(\"top\"), 10),\n                            left: parseInt(that.element.css(\"left\"), 10)\n                        };\n\n                        if (pr && pr.length) {\n                            $(pr[0]).css({width: data.width, height: data.height});\n                        }\n\n                        // propagating resize, and updating values for each animation step\n                        that._updateCache(data);\n                        that._propagate(\"resize\", event);\n\n                    }\n                }\n            );\n        }\n\n    });\n\n    $.ui.plugin.add(\"resizable\", \"containment\", {\n\n        start: function () {\n            var element, p, co, ch, cw, width, height,\n                that = $(this).data(\"ui-resizable\"),\n                o = that.options,\n                el = that.element,\n                oc = o.containment,\n                ce = (oc instanceof $) ? oc.get(0) : (/parent/.test(oc)) ? el.parent().get(0) : oc;\n\n            if (!ce) {\n                return;\n            }\n\n            that.containerElement = $(ce);\n\n            if (/document/.test(oc) || oc === document) {\n                that.containerOffset = {left: 0, top: 0};\n                that.containerPosition = {left: 0, top: 0};\n\n                that.parentData = {\n                    element: $(document), left: 0, top: 0,\n                    width: $(document).width(), height: $(document).height() || document.body.parentNode.scrollHeight\n                };\n            }\n\n            // i'm a node, so compute top, left, right, bottom\n            else {\n                element = $(ce);\n                p = [];\n                $([\"Top\", \"Right\", \"Left\", \"Bottom\"]).each(function (i, name) {\n                    p[i] = num(element.css(\"padding\" + name));\n                });\n\n                that.containerOffset = element.offset();\n                that.containerPosition = element.position();\n                that.containerSize = {height: (element.innerHeight() - p[3]), width: (element.innerWidth() - p[1])};\n\n                co = that.containerOffset;\n                ch = that.containerSize.height;\n                cw = that.containerSize.width;\n                width = ($.ui.hasScroll(ce, \"left\") ? ce.scrollWidth : cw);\n                height = ($.ui.hasScroll(ce) ? ce.scrollHeight : ch);\n\n                that.parentData = {\n                    element: ce, left: co.left, top: co.top, width: width, height: height\n                };\n            }\n        },\n\n        resize: function (event) {\n            var woset, hoset, isParent, isOffsetRelative,\n                that = $(this).data(\"ui-resizable\"),\n                o = that.options,\n                co = that.containerOffset, cp = that.position,\n                pRatio = that._aspectRatio || event.shiftKey,\n                cop = {top: 0, left: 0}, ce = that.containerElement;\n\n            if (ce[0] !== document && (/static/).test(ce.css(\"position\"))) {\n                cop = co;\n            }\n\n            if (cp.left < (that._helper ? co.left : 0)) {\n                that.size.width = that.size.width + (that._helper ? (that.position.left - co.left) : (that.position.left - cop.left));\n                if (pRatio) {\n                    that.size.height = that.size.width / that.aspectRatio;\n                }\n                that.position.left = o.helper ? co.left : 0;\n            }\n\n            if (cp.top < (that._helper ? co.top : 0)) {\n                that.size.height = that.size.height + (that._helper ? (that.position.top - co.top) : that.position.top);\n                if (pRatio) {\n                    that.size.width = that.size.height * that.aspectRatio;\n                }\n                that.position.top = that._helper ? co.top : 0;\n            }\n\n            that.offset.left = that.parentData.left + that.position.left;\n            that.offset.top = that.parentData.top + that.position.top;\n\n            woset = Math.abs((that._helper ? that.offset.left - cop.left : (that.offset.left - cop.left)) + that.sizeDiff.width);\n            hoset = Math.abs((that._helper ? that.offset.top - cop.top : (that.offset.top - co.top)) + that.sizeDiff.height);\n\n            isParent = that.containerElement.get(0) === that.element.parent().get(0);\n            isOffsetRelative = /relative|absolute/.test(that.containerElement.css(\"position\"));\n\n            if (isParent && isOffsetRelative) {\n                woset -= Math.abs(that.parentData.left);\n            }\n\n            if (woset + that.size.width >= that.parentData.width) {\n                that.size.width = that.parentData.width - woset;\n                if (pRatio) {\n                    that.size.height = that.size.width / that.aspectRatio;\n                }\n            }\n\n            if (hoset + that.size.height >= that.parentData.height) {\n                that.size.height = that.parentData.height - hoset;\n                if (pRatio) {\n                    that.size.width = that.size.height * that.aspectRatio;\n                }\n            }\n        },\n\n        stop: function () {\n            var that = $(this).data(\"ui-resizable\"),\n                o = that.options,\n                co = that.containerOffset,\n                cop = that.containerPosition,\n                ce = that.containerElement,\n                helper = $(that.helper),\n                ho = helper.offset(),\n                w = helper.outerWidth() - that.sizeDiff.width,\n                h = helper.outerHeight() - that.sizeDiff.height;\n\n            if (that._helper && !o.animate && (/relative/).test(ce.css(\"position\"))) {\n                $(this).css({left: ho.left - cop.left - co.left, width: w, height: h});\n            }\n\n            if (that._helper && !o.animate && (/static/).test(ce.css(\"position\"))) {\n                $(this).css({left: ho.left - cop.left - co.left, width: w, height: h});\n            }\n\n        }\n    });\n\n    $.ui.plugin.add(\"resizable\", \"alsoResize\", {\n\n        start: function () {\n            var that = $(this).data(\"ui-resizable\"),\n                o = that.options,\n                _store = function (exp) {\n                    $(exp).each(function () {\n                        var el = $(this);\n                        el.data(\"ui-resizable-alsoresize\", {\n                            width: parseInt(el.width(), 10), height: parseInt(el.height(), 10),\n                            left: parseInt(el.css(\"left\"), 10), top: parseInt(el.css(\"top\"), 10)\n                        });\n                    });\n                };\n\n            if (typeof (o.alsoResize) === \"object\" && !o.alsoResize.parentNode) {\n                if (o.alsoResize.length) {\n                    o.alsoResize = o.alsoResize[0];\n                    _store(o.alsoResize);\n                } else {\n                    $.each(o.alsoResize, function (exp) {\n                        _store(exp);\n                    });\n                }\n            } else {\n                _store(o.alsoResize);\n            }\n        },\n\n        resize: function (event, ui) {\n            var that = $(this).data(\"ui-resizable\"),\n                o = that.options,\n                os = that.originalSize,\n                op = that.originalPosition,\n                delta = {\n                    height: (that.size.height - os.height) || 0, width: (that.size.width - os.width) || 0,\n                    top: (that.position.top - op.top) || 0, left: (that.position.left - op.left) || 0\n                },\n\n                _alsoResize = function (exp, c) {\n                    $(exp).each(function () {\n                        var el = $(this), start = $(this).data(\"ui-resizable-alsoresize\"), style = {},\n                            css = c && c.length ? c : el.parents(ui.originalElement[0]).length ? [\"width\", \"height\"] : [\"width\", \"height\", \"top\", \"left\"];\n\n                        $.each(css, function (i, prop) {\n                            var sum = (start[prop] || 0) + (delta[prop] || 0);\n                            if (sum && sum >= 0) {\n                                style[prop] = sum || null;\n                            }\n                        });\n\n                        el.css(style);\n                    });\n                };\n\n            if (typeof (o.alsoResize) === \"object\" && !o.alsoResize.nodeType) {\n                $.each(o.alsoResize, function (exp, c) {\n                    _alsoResize(exp, c);\n                });\n            } else {\n                _alsoResize(o.alsoResize);\n            }\n        },\n\n        stop: function () {\n            $(this).removeData(\"resizable-alsoresize\");\n        }\n    });\n\n    $.ui.plugin.add(\"resizable\", \"ghost\", {\n\n        start: function () {\n\n            var that = $(this).data(\"ui-resizable\"), o = that.options, cs = that.size;\n\n            that.ghost = that.originalElement.clone();\n            that.ghost\n                .css({\n                    opacity: 0.25,\n                    display: \"block\",\n                    position: \"relative\",\n                    height: cs.height,\n                    width: cs.width,\n                    margin: 0,\n                    left: 0,\n                    top: 0\n                })\n                .addClass(\"ui-resizable-ghost\")\n                .addClass(typeof o.ghost === \"string\" ? o.ghost : \"\");\n\n            that.ghost.appendTo(that.helper);\n\n        },\n\n        resize: function () {\n            var that = $(this).data(\"ui-resizable\");\n            if (that.ghost) {\n                that.ghost.css({position: \"relative\", height: that.size.height, width: that.size.width});\n            }\n        },\n\n        stop: function () {\n            var that = $(this).data(\"ui-resizable\");\n            if (that.ghost && that.helper) {\n                that.helper.get(0).removeChild(that.ghost.get(0));\n            }\n        }\n\n    });\n\n    $.ui.plugin.add(\"resizable\", \"grid\", {\n\n        resize: function () {\n            var that = $(this).data(\"ui-resizable\"),\n                o = that.options,\n                cs = that.size,\n                os = that.originalSize,\n                op = that.originalPosition,\n                a = that.axis,\n                grid = typeof o.grid === \"number\" ? [o.grid, o.grid] : o.grid,\n                gridX = (grid[0] || 1),\n                gridY = (grid[1] || 1),\n                ox = Math.round((cs.width - os.width) / gridX) * gridX,\n                oy = Math.round((cs.height - os.height) / gridY) * gridY,\n                newWidth = os.width + ox,\n                newHeight = os.height + oy,\n                isMaxWidth = o.maxWidth && (o.maxWidth < newWidth),\n                isMaxHeight = o.maxHeight && (o.maxHeight < newHeight),\n                isMinWidth = o.minWidth && (o.minWidth > newWidth),\n                isMinHeight = o.minHeight && (o.minHeight > newHeight);\n\n            o.grid = grid;\n\n            if (isMinWidth) {\n                newWidth = newWidth + gridX;\n            }\n            if (isMinHeight) {\n                newHeight = newHeight + gridY;\n            }\n            if (isMaxWidth) {\n                newWidth = newWidth - gridX;\n            }\n            if (isMaxHeight) {\n                newHeight = newHeight - gridY;\n            }\n\n            if (/^(se|s|e)$/.test(a)) {\n                that.size.width = newWidth;\n                that.size.height = newHeight;\n            } else if (/^(ne)$/.test(a)) {\n                that.size.width = newWidth;\n                that.size.height = newHeight;\n                that.position.top = op.top - oy;\n            } else if (/^(sw)$/.test(a)) {\n                that.size.width = newWidth;\n                that.size.height = newHeight;\n                that.position.left = op.left - ox;\n            } else {\n                if (newHeight - gridY > 0) {\n                    that.size.height = newHeight;\n                    that.position.top = op.top - oy;\n                } else {\n                    that.size.height = gridY;\n                    that.position.top = op.top + os.height - gridY;\n                }\n                if (newWidth - gridX > 0) {\n                    that.size.width = newWidth;\n                    that.position.left = op.left - ox;\n                } else {\n                    that.size.width = gridX;\n                    that.position.left = op.left + os.width - gridX;\n                }\n            }\n        }\n\n    });\n\n});\n","jquery/ui-modules/effect-slide.js":"/*!\n * jQuery UI Effects Slide - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/slide-effect/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.slide = function (o, done) {\n\n        // Create element\n        var el = $(this),\n            props = [\"position\", \"top\", \"bottom\", \"left\", \"right\", \"width\", \"height\"],\n            mode = $.effects.setMode(el, o.mode || \"show\"),\n            show = mode === \"show\",\n            direction = o.direction || \"left\",\n            ref = (direction === \"up\" || direction === \"down\") ? \"top\" : \"left\",\n            positiveMotion = (direction === \"up\" || direction === \"left\"),\n            distance,\n            animation = {};\n\n        // Adjust\n        $.effects.save(el, props);\n        el.show();\n        distance = o.distance || el[ref === \"top\" ? \"outerHeight\" : \"outerWidth\"](true);\n\n        $.effects.createWrapper(el).css({\n            overflow: \"hidden\"\n        });\n\n        if (show) {\n            el.css(ref, positiveMotion ? (isNaN(distance) ? \"-\" + distance : -distance) : distance);\n        }\n\n        // Animation\n        animation[ref] = (show ?\n            (positiveMotion ? \"+=\" : \"-=\") :\n            (positiveMotion ? \"-=\" : \"+=\")) +\n            distance;\n\n        // Animate\n        el.animate(animation, {\n            queue: false,\n            duration: o.duration,\n            easing: o.easing,\n            complete: function () {\n                if (mode === \"hide\") {\n                    el.hide();\n                }\n                $.effects.restore(el, props);\n                $.effects.removeWrapper(el);\n                done();\n            }\n        });\n    };\n\n});\n","jquery/jstree/jquery.hotkeys.js":"/*\n * jQuery Hotkeys Plugin\n * Copyright 2010, John Resig\n * Dual licensed under the MIT or GPL Version 2 licenses.\n *\n * Based upon the plugin by Tzury Bar Yochay:\n * http://github.com/tzuryby/hotkeys\n *\n * Original idea by:\n * Binny V A, http://www.openjs.com/scripts/events/keyboard_shortcuts/\n*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\"jquery\"], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function (jQuery) {\n\n\tjQuery.hotkeys = {\n\t\tversion: \"0.8\",\n\n\t\tspecialKeys: {\n\t\t\t8: \"backspace\", 9: \"tab\", 13: \"return\", 16: \"shift\", 17: \"ctrl\", 18: \"alt\", 19: \"pause\",\n\t\t\t20: \"capslock\", 27: \"esc\", 32: \"space\", 33: \"pageup\", 34: \"pagedown\", 35: \"end\", 36: \"home\",\n\t\t\t37: \"left\", 38: \"up\", 39: \"right\", 40: \"down\", 45: \"insert\", 46: \"del\", \n\t\t\t96: \"0\", 97: \"1\", 98: \"2\", 99: \"3\", 100: \"4\", 101: \"5\", 102: \"6\", 103: \"7\",\n\t\t\t104: \"8\", 105: \"9\", 106: \"*\", 107: \"+\", 109: \"-\", 110: \".\", 111 : \"/\", \n\t\t\t112: \"f1\", 113: \"f2\", 114: \"f3\", 115: \"f4\", 116: \"f5\", 117: \"f6\", 118: \"f7\", 119: \"f8\", \n\t\t\t120: \"f9\", 121: \"f10\", 122: \"f11\", 123: \"f12\", 144: \"numlock\", 145: \"scroll\", 191: \"/\", 224: \"meta\"\n\t\t},\n\t\n\t\tshiftNums: {\n\t\t\t\"`\": \"~\", \"1\": \"!\", \"2\": \"@\", \"3\": \"#\", \"4\": \"$\", \"5\": \"%\", \"6\": \"^\", \"7\": \"&\", \n\t\t\t\"8\": \"*\", \"9\": \"(\", \"0\": \")\", \"-\": \"_\", \"=\": \"+\", \";\": \": \", \"'\": \"\\\"\", \",\": \"<\", \n\t\t\t\".\": \">\",  \"/\": \"?\",  \"\\\\\": \"|\"\n\t\t}\n\t};\n\n\tfunction keyHandler( handleObj ) {\n\t\t// Only care when a possible input has been specified\n\t\tif ( typeof handleObj.data !== \"string\" ) {\n\t\t\treturn;\n\t\t}\n\t\t\n\t\tvar origHandler = handleObj.handler,\n\t\t\tkeys = handleObj.data.toLowerCase().split(\" \");\n\t\n\t\thandleObj.handler = function( event ) {\n\t\t\t// Don't fire in text-accepting inputs that we didn't directly bind to\n            /**\n             * Modified by Magento to ensure it doesn't fire on any content editable areas. This library is no\n             * longer maintained by its author however we require content editable to behave as expected.\n             */\n\t\t\tif ( this !== event.target && (/textarea|select/i.test( event.target.nodeName ) ||\n\t\t\t\t event.target.type === \"text\" || jQuery(event.target).attr('contenteditable')) ) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\t\n\t\t\t// Keypress represents characters, not special keys\n\t\t\tvar special = event.type !== \"keypress\" && jQuery.hotkeys.specialKeys[ event.which ],\n\t\t\t\tcharacter = String.fromCharCode( event.which ).toLowerCase(),\n\t\t\t\tkey, modif = \"\", possible = {};\n\n\t\t\t// check combinations (alt|ctrl|shift+anything)\n\t\t\tif ( event.altKey && special !== \"alt\" ) {\n\t\t\t\tmodif += \"alt+\";\n\t\t\t}\n\n\t\t\tif ( event.ctrlKey && special !== \"ctrl\" ) {\n\t\t\t\tmodif += \"ctrl+\";\n\t\t\t}\n\t\t\t\n\t\t\t// TODO: Need to make sure this works consistently across platforms\n\t\t\tif ( event.metaKey && !event.ctrlKey && special !== \"meta\" ) {\n\t\t\t\tmodif += \"meta+\";\n\t\t\t}\n\n\t\t\tif ( event.shiftKey && special !== \"shift\" ) {\n\t\t\t\tmodif += \"shift+\";\n\t\t\t}\n\n\t\t\tif ( special ) {\n\t\t\t\tpossible[ modif + special ] = true;\n\n\t\t\t} else {\n\t\t\t\tpossible[ modif + character ] = true;\n\t\t\t\tpossible[ modif + jQuery.hotkeys.shiftNums[ character ] ] = true;\n\n\t\t\t\t// \"$\" can be triggered as \"Shift+4\" or \"Shift+$\" or just \"$\"\n\t\t\t\tif ( modif === \"shift+\" ) {\n\t\t\t\t\tpossible[ jQuery.hotkeys.shiftNums[ character ] ] = true;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfor ( var i = 0, l = keys.length; i < l; i++ ) {\n\t\t\t\tif ( possible[ keys[i] ] ) {\n\t\t\t\t\treturn origHandler.apply( this, arguments );\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n\n\tjQuery.each([ \"keydown\", \"keyup\", \"keypress\" ], function() {\n\t\tjQuery.event.special[ this ] = { add: keyHandler };\n\t});\n\n}));","jquery/jstree/jquery.jstree.js":"/*\n * jsTree 1.0-rc3\n * http://jstree.com/\n *\n * Copyright (c) 2010 Ivan Bozhanov (vakata.com)\n *\n * Licensed same as jquery - under the terms of either the MIT License or the GPL Version 2 License\n *   http://www.opensource.org/licenses/mit-license.php\n *   http://www.gnu.org/licenses/gpl.html\n *\n * $Date: 2011-02-09 01:17:14 +0200 (\u0441\u0440, 09 \u0444\u0435\u0432\u0440 2011) $\n * $Revision: 236 $\n */\n\n/*jslint browser: true, onevar: true, undef: true, bitwise: true, strict: true */\n/*global window : false, clearInterval: false, clearTimeout: false, document: false, setInterval: false, setTimeout: false, jQuery: false, navigator: false, XSLTProcessor: false, DOMParser: false, XMLSerializer: false*/\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\n            \"jquery\",\n            \"jquery/jquery.cookie\",\n            \"jquery/jstree/jquery.hotkeys\"\n        ], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n\"use strict\";\n\n// top wrapper to prevent multiple inclusion (is this OK?)\n(function () {\n\tvar is_ie6 = false, is_ie7 = false, is_ff2 = false;\n\n/*\n * jsTree core\n */\n(function ($) {\n\t// Common functions not related to jsTree\n\t// decided to move them to a `vakata` \"namespace\"\n\t$.vakata = {};\n\t// CSS related functions\n\t$.vakata.css = {\n\t\tget_css : function(rule_name, delete_flag, sheet) {\n\t\t\trule_name = rule_name.toLowerCase();\n\t\t\tvar css_rules = sheet.cssRules || sheet.rules,\n\t\t\t\tj = 0;\n\t\t\tdo {\n\t\t\t\tif(css_rules.length && j > css_rules.length + 5) { return false; }\n\t\t\t\tif(css_rules[j].selectorText && css_rules[j].selectorText.toLowerCase() == rule_name) {\n\t\t\t\t\tif(delete_flag === true) {\n\t\t\t\t\t\tif(sheet.removeRule) { sheet.removeRule(j); }\n\t\t\t\t\t\tif(sheet.deleteRule) { sheet.deleteRule(j); }\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\t\t\t\t\telse { return css_rules[j]; }\n\t\t\t\t}\n\t\t\t}\n\t\t\twhile (css_rules[++j]);\n\t\t\treturn false;\n\t\t},\n\t\tadd_css : function(rule_name, sheet) {\n\t\t\tif($.jstree.css.get_css(rule_name, false, sheet)) { return false; }\n\t\t\tif(sheet.insertRule) { sheet.insertRule(rule_name + ' { }', 0); } else { sheet.addRule(rule_name, null, 0); }\n\t\t\treturn $.vakata.css.get_css(rule_name);\n\t\t},\n\t\tremove_css : function(rule_name, sheet) {\n\t\t\treturn $.vakata.css.get_css(rule_name, true, sheet);\n\t\t},\n\t\tadd_sheet : function(opts) {\n\t\t\tvar tmp = false, is_new = true;\n\t\t\tif(opts.str) {\n\t\t\t\tif(opts.title) { tmp = $(\"style[id='\" + opts.title + \"-stylesheet']\")[0]; }\n\t\t\t\tif(tmp) { is_new = false; }\n\t\t\t\telse {\n\t\t\t\t\ttmp = document.createElement(\"style\");\n\t\t\t\t\ttmp.setAttribute('type',\"text/css\");\n\t\t\t\t\tif(opts.title) { tmp.setAttribute(\"id\", opts.title + \"-stylesheet\"); }\n\t\t\t\t}\n\t\t\t\tif(tmp.styleSheet) {\n\t\t\t\t\tif(is_new) {\n\t\t\t\t\t\tdocument.getElementsByTagName(\"head\")[0].appendChild(tmp);\n\t\t\t\t\t\ttmp.styleSheet.cssText = opts.str;\n\t\t\t\t\t}\n\t\t\t\t\telse {\n\t\t\t\t\t\ttmp.styleSheet.cssText = tmp.styleSheet.cssText + \" \" + opts.str;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\ttmp.appendChild(document.createTextNode(opts.str));\n\t\t\t\t\tdocument.getElementsByTagName(\"head\")[0].appendChild(tmp);\n\t\t\t\t}\n\t\t\t\treturn tmp.sheet || tmp.styleSheet;\n\t\t\t}\n\t\t\tif(opts.url) {\n\t\t\t\tif(document.createStyleSheet) {\n\t\t\t\t\ttry { tmp = document.createStyleSheet(opts.url); } catch (e) { }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\ttmp\t\t\t= document.createElement('link');\n\t\t\t\t\ttmp.rel\t\t= 'stylesheet';\n\t\t\t\t\ttmp.type\t= 'text/css';\n\t\t\t\t\ttmp.media\t= \"all\";\n\t\t\t\t\ttmp.href\t= opts.url;\n\t\t\t\t\tdocument.getElementsByTagName(\"head\")[0].appendChild(tmp);\n\t\t\t\t\treturn tmp.styleSheet;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t};\n\n\t// private variables\n\tvar instances = [],\t\t\t// instance array (used by $.jstree.reference/create/focused)\n\t\tfocused_instance = -1,\t// the index in the instance array of the currently focused instance\n\t\tplugins = {},\t\t\t// list of included plugins\n\t\tprepared_move = {};\t\t// for the move_node function\n\n\t// jQuery plugin wrapper (thanks to jquery UI widget function)\n\t$.fn.jstree = function (settings) {\n\t\tvar isMethodCall = (typeof settings == 'string'), // is this a method call like $().jstree(\"open_node\")\n\t\t\targs = Array.prototype.slice.call(arguments, 1),\n\t\t\treturnValue = this;\n\n\t\t// if a method call execute the method on all selected instances\n\t\tif(isMethodCall) {\n\t\t\tif(settings.substring(0, 1) == '_') { return returnValue; }\n\t\t\tthis.each(function() {\n\t\t\t\tvar instance = instances[$.data(this, \"jstree_instance_id\")],\n\t\t\t\t\tmethodValue = (instance && $.isFunction(instance[settings])) ? instance[settings].apply(instance, args) : instance;\n\t\t\t\t\tif(typeof methodValue !== \"undefined\" && (settings.indexOf(\"is_\") === 0 || (methodValue !== true && methodValue !== false))) { returnValue = methodValue; return false; }\n\t\t\t});\n\t\t}\n\t\telse {\n\t\t\tthis.each(function() {\n\t\t\t\t// extend settings and allow for multiple hashes and $.data\n\t\t\t\tvar instance_id = $.data(this, \"jstree_instance_id\"),\n\t\t\t\t\ta = [],\n\t\t\t\t\tb = settings ? $.extend({}, true, settings) : {},\n\t\t\t\t\tc = $(this),\n\t\t\t\t\ts = false,\n\t\t\t\t\tt = [];\n\t\t\t\ta = a.concat(args);\n\t\t\t\tif(c.data(\"jstree\")) { a.push(c.data(\"jstree\")); }\n\t\t\t\tb = a.length ? $.extend.apply(null, [true, b].concat(a)) : b;\n\n\t\t\t\t// if an instance already exists, destroy it first\n\t\t\t\tif(typeof instance_id !== \"undefined\" && instances[instance_id]) { instances[instance_id].destroy(); }\n\t\t\t\t// push a new empty object to the instances array\n\t\t\t\tinstance_id = parseInt(instances.push({}),10) - 1;\n\t\t\t\t// store the jstree instance id to the container element\n\t\t\t\t$.data(this, \"jstree_instance_id\", instance_id);\n\t\t\t\t// clean up all plugins\n\t\t\t\tb.plugins = $.isArray(b.plugins) ? b.plugins : $.jstree.defaults.plugins.slice();\n\t\t\t\tb.plugins.unshift(\"core\");\n\t\t\t\t// only unique plugins\n\t\t\t\tb.plugins = b.plugins.sort().join(\",,\").replace(/(,|^)([^,]+)(,,\\2)+(,|$)/g,\"$1$2$4\").replace(/,,+/g,\",\").replace(/,$/,\"\").split(\",\");\n\n\t\t\t\t// extend defaults with passed data\n\t\t\t\ts = $.extend(true, {}, $.jstree.defaults, b);\n\t\t\t\ts.plugins = b.plugins;\n\t\t\t\t$.each(plugins, function (i, val) {\n\t\t\t\t\tif($.inArray(i, s.plugins) === -1) { s[i] = null; delete s[i]; }\n\t\t\t\t\telse { t.push(i); }\n\t\t\t\t});\n\t\t\t\ts.plugins = t;\n\n\t\t\t\t// push the new object to the instances array (at the same time set the default classes to the container) and init\n\t\t\t\tinstances[instance_id] = new $.jstree._instance(instance_id, $(this).addClass(\"jstree jstree-\" + instance_id), s);\n\t\t\t\t// init all activated plugins for this instance\n\t\t\t\t$.each(instances[instance_id]._get_settings().plugins, function (i, val) { instances[instance_id].data[val] = {}; });\n\t\t\t\t$.each(instances[instance_id]._get_settings().plugins, function (i, val) { if(plugins[val]) { plugins[val].__init.apply(instances[instance_id]); } });\n\t\t\t\t// initialize the instance\n\t\t\t\tsetTimeout(function() { if(instances[instance_id]) { instances[instance_id].init(); } }, 0);\n\t\t\t});\n\t\t}\n\t\t// return the jquery selection (or if it was a method call that returned a value - the returned value)\n\t\treturn returnValue;\n\t};\n\t// object to store exposed functions and objects\n\t$.jstree = {\n\t\tdefaults : {\n\t\t\tplugins : []\n\t\t},\n\t\t_focused : function () { return instances[focused_instance] || null; },\n\t\t_reference : function (needle) {\n\t\t\t// get by instance id\n\t\t\tif(instances[needle]) { return instances[needle]; }\n\t\t\t// get by DOM (if still no luck - return null\n\t\t\tvar o = $(needle);\n\t\t\tif(!o.length && typeof needle === \"string\") { o = $(\"#\" + needle); }\n\t\t\tif(!o.length) { return null; }\n\t\t\treturn instances[o.closest(\".jstree\").data(\"jstree_instance_id\")] || null;\n\t\t},\n\t\t_instance : function (index, container, settings) {\n\t\t\t// for plugins to store data in\n\t\t\tthis.data = { core : {} };\n\t\t\tthis.get_settings\t= function () { return $.extend(true, {}, settings); };\n\t\t\tthis._get_settings\t= function () { return settings; };\n\t\t\tthis.get_index\t\t= function () { return index; };\n\t\t\tthis.get_container\t= function () { return container; };\n\t\t\tthis.get_container_ul = function () { return container.children(\"ul:eq(0)\"); };\n\t\t\tthis._set_settings\t= function (s) {\n\t\t\t\tsettings = $.extend(true, {}, settings, s);\n\t\t\t};\n\t\t},\n\t\t_fn : { },\n\t\tplugin : function (pname, pdata) {\n\t\t\tpdata = $.extend({}, {\n\t\t\t\t__init\t\t: $.noop,\n\t\t\t\t__destroy\t: $.noop,\n\t\t\t\t_fn\t\t\t: {},\n\t\t\t\tdefaults\t: false\n\t\t\t}, pdata);\n\t\t\tplugins[pname] = pdata;\n\n\t\t\t$.jstree.defaults[pname] = pdata.defaults;\n\t\t\t$.each(pdata._fn, function (i, val) {\n\t\t\t\tval.plugin\t\t= pname;\n\t\t\t\tval.old\t\t\t= $.jstree._fn[i];\n\t\t\t\t$.jstree._fn[i] = function () {\n\t\t\t\t\tvar rslt,\n\t\t\t\t\t\tfunc = val,\n\t\t\t\t\t\targs = Array.prototype.slice.call(arguments),\n\t\t\t\t\t\tevnt = new $.Event(\"before.jstree\"),\n\t\t\t\t\t\trlbk = false;\n\n\t\t\t\t\tif(this.data.core.locked === true && i !== \"unlock\" && i !== \"is_locked\") { return; }\n\n\t\t\t\t\t// Check if function belongs to the included plugins of this instance\n\t\t\t\t\tdo {\n\t\t\t\t\t\tif(func && func.plugin && $.inArray(func.plugin, this._get_settings().plugins) !== -1) { break; }\n\t\t\t\t\t\tfunc = func.old;\n\t\t\t\t\t} while(func);\n\t\t\t\t\tif(!func) { return; }\n\n\t\t\t\t\t// context and function to trigger events, then finally call the function\n\t\t\t\t\tif(i.indexOf(\"_\") === 0) {\n\t\t\t\t\t\trslt = func.apply(this, args);\n\t\t\t\t\t}\n\t\t\t\t\telse {\n\t\t\t\t\t\trslt = this.get_container().triggerHandler(evnt, { \"func\" : i, \"inst\" : this, \"args\" : args, \"plugin\" : func.plugin });\n\t\t\t\t\t\tif(rslt === false) { return; }\n\t\t\t\t\t\tif(typeof rslt !== \"undefined\") { args = rslt; }\n\n\t\t\t\t\t\trslt = func.apply(\n\t\t\t\t\t\t\t$.extend({}, this, {\n\t\t\t\t\t\t\t\t__callback : function (data) {\n\t\t\t\t\t\t\t\t\tthis.get_container().triggerHandler( i + '.jstree', { \"inst\" : this, \"args\" : args, \"rslt\" : data, \"rlbk\" : rlbk });\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t__rollback : function () {\n\t\t\t\t\t\t\t\t\trlbk = this.get_rollback();\n\t\t\t\t\t\t\t\t\treturn rlbk;\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t__call_old : function (replace_arguments) {\n\t\t\t\t\t\t\t\t\treturn func.old.apply(this, (replace_arguments ? Array.prototype.slice.call(arguments, 1) : args ) );\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}), args);\n\t\t\t\t\t}\n\n\t\t\t\t\t// return the result\n\t\t\t\t\treturn rslt;\n\t\t\t\t};\n\t\t\t\t$.jstree._fn[i].old = val.old;\n\t\t\t\t$.jstree._fn[i].plugin = pname;\n\t\t\t});\n\t\t},\n\t\trollback : function (rb) {\n\t\t\tif(rb) {\n\t\t\t\tif(!$.isArray(rb)) { rb = [ rb ]; }\n\t\t\t\t$.each(rb, function (i, val) {\n\t\t\t\t\tinstances[val.i].set_rollback(val.h, val.d);\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t};\n\t// set the prototype for all instances\n\t$.jstree._fn = $.jstree._instance.prototype = {};\n\n\t// load the css when DOM is ready\n\t$(function() {\n\t\t// code is copied from jQuery ($.browser is deprecated + there is a bug in IE)\n\t\tvar u = navigator.userAgent.toLowerCase(),\n\t\t\tv = (u.match( /.+?(?:rv|it|ra|ie)[\\/: ]([\\d.]+)/ ) || [0,'0'])[1],\n\t\t\tcss_string = '' +\n\t\t\t\t'.jstree ul, .jstree li { display:block; margin:0 0 0 0; padding:0 0 0 0; list-style-type:none; } ' +\n\t\t\t\t'.jstree li { display:block; min-height:18px; line-height:18px; white-space:nowrap; margin-left:18px; min-width:18px; } ' +\n\t\t\t\t'.jstree-rtl li { margin-left:0; margin-right:18px; } ' +\n\t\t\t\t'.jstree > ul > li { margin-left:0px; } ' +\n\t\t\t\t'.jstree-rtl > ul > li { margin-right:0px; } ' +\n\t\t\t\t'.jstree ins { display:inline-block; text-decoration:none; width:18px; height:18px; margin:0 0 0 0; padding:0; } ' +\n\t\t\t\t'.jstree a { display:inline-block; line-height:16px; height:16px; color:black; white-space:nowrap; text-decoration:none; padding:1px 2px; margin:0; } ' +\n\t\t\t\t'.jstree a:focus { outline: none; } ' +\n\t\t\t\t'.jstree a > ins { height:16px; width:16px; } ' +\n\t\t\t\t'.jstree a > .jstree-icon { margin-right:3px; } ' +\n\t\t\t\t'.jstree-rtl a > .jstree-icon { margin-left:3px; margin-right:0; } ' +\n\t\t\t\t'li.jstree-open > ul { display:block; } ' +\n\t\t\t\t'li.jstree-closed > ul { display:none; } ';\n\t\t// Correct IE 6 (does not support the > CSS selector)\n\t\tif(/msie/.test(u) && parseInt(v, 10) == 6) {\n\t\t\tis_ie6 = true;\n\n\t\t\t// fix image flicker and lack of caching\n\t\t\ttry {\n\t\t\t\tdocument.execCommand(\"BackgroundImageCache\", false, true);\n\t\t\t} catch (err) { }\n\n\t\t\tcss_string += '' +\n\t\t\t\t'.jstree li { height:18px; margin-left:0; margin-right:0; } ' +\n\t\t\t\t'.jstree li li { margin-left:18px; } ' +\n\t\t\t\t'.jstree-rtl li li { margin-left:0px; margin-right:18px; } ' +\n\t\t\t\t'li.jstree-open ul { display:block; } ' +\n\t\t\t\t'li.jstree-closed ul { display:none !important; } ' +\n\t\t\t\t'.jstree li a { display:inline; border-width:0 !important; padding:0px 2px !important; } ' +\n\t\t\t\t'.jstree li a ins { height:16px; width:16px; margin-right:3px; } ' +\n\t\t\t\t'.jstree-rtl li a ins { margin-right:0px; margin-left:3px; } ';\n\t\t}\n\t\t// Correct IE 7 (shifts anchor nodes onhover)\n\t\tif(/msie/.test(u) && parseInt(v, 10) == 7) {\n\t\t\tis_ie7 = true;\n\t\t\tcss_string += '.jstree li a { border-width:0 !important; padding:0px 2px !important; } ';\n\t\t}\n\t\t// correct ff2 lack of display:inline-block\n\t\tif(!/compatible/.test(u) && /mozilla/.test(u) && parseFloat(v, 10) < 1.9) {\n\t\t\tis_ff2 = true;\n\t\t\tcss_string += '' +\n\t\t\t\t'.jstree ins { display:-moz-inline-box; } ' +\n\t\t\t\t'.jstree li { line-height:12px; } ' + // WHY??\n\t\t\t\t'.jstree a { display:-moz-inline-box; } ' +\n\t\t\t\t'.jstree .jstree-no-icons .jstree-checkbox { display:-moz-inline-stack !important; } ';\n\t\t\t\t/* this shouldn't be here as it is theme specific */\n\t\t}\n\t\t// the default stylesheet\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n\t});\n\n\t// core functions (open, close, create, update, delete)\n\t$.jstree.plugin(\"core\", {\n\t\t__init : function () {\n\t\t\tthis.data.core.locked = false;\n\t\t\tthis.data.core.to_open = this.get_settings().core.initially_open;\n\t\t\tthis.data.core.to_load = this.get_settings().core.initially_load;\n\t\t},\n\t\tdefaults : {\n\t\t\thtml_titles\t: false,\n\t\t\tanimation\t: 500,\n\t\t\tinitially_open : [],\n\t\t\tinitially_load : [],\n\t\t\topen_parents : true,\n\t\t\tnotify_plugins : true,\n\t\t\trtl\t\t\t: false,\n\t\t\tload_open\t: false,\n\t\t\tstrings\t\t: {\n\t\t\t\tloading\t\t: \"Loading ...\",\n\t\t\t\tnew_node\t: \"New node\",\n\t\t\t\tmultiple_selection : \"Multiple selection\"\n\t\t\t}\n\t\t},\n\t\t_fn : {\n\t\t\tinit\t: function () {\n\t\t\t\tthis.set_focus();\n\t\t\t\tif(this._get_settings().core.rtl) {\n\t\t\t\t\tthis.get_container().addClass(\"jstree-rtl\").css(\"direction\", \"rtl\");\n\t\t\t\t}\n\t\t\t\tthis.get_container().html(\"<ul><li class='jstree-last jstree-leaf'><ins>&#160;</ins><a class='jstree-loading' href='#'><ins class='jstree-icon'>&#160;</ins>\" + this._get_string(\"loading\") + \"</a></li></ul>\");\n\t\t\t\tthis.data.core.li_height = this.get_container_ul().find(\"li.jstree-closed, li.jstree-leaf\").eq(0).height() || 18;\n\n\t\t\t\tthis.get_container()\n\t\t\t\t\t.delegate(\"li > ins\", \"click.jstree\", $.proxy(function (event) {\n\t\t\t\t\t\t\tvar trgt = $(event.target);\n\t\t\t\t\t\t\t// if(trgt.is(\"ins\") && event.pageY - trgt.offset().top < this.data.core.li_height) { this.toggle_node(trgt); }\n\t\t\t\t\t\t\tthis.toggle_node(trgt);\n\t\t\t\t\t\t}, this))\n\t\t\t\t\t.bind(\"mousedown.jstree\", $.proxy(function () {\n\t\t\t\t\t\t\tthis.set_focus(); // This used to be setTimeout(set_focus,0) - why?\n\t\t\t\t\t\t}, this))\n\t\t\t\t\t.bind(\"dblclick.jstree\", function (event) {\n\t\t\t\t\t\tvar sel;\n\t\t\t\t\t\tif(document.selection && document.selection.empty) { document.selection.empty(); }\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif(window.getSelection) {\n\t\t\t\t\t\t\t\tsel = window.getSelection();\n\t\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\t\tsel.removeAllRanges();\n\t\t\t\t\t\t\t\t\tsel.collapse();\n\t\t\t\t\t\t\t\t} catch (err) { }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\tif(this._get_settings().core.notify_plugins) {\n\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t.bind(\"load_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\t\t\tvar o = this._get_node(data.rslt.obj),\n\t\t\t\t\t\t\t\t\tt = this;\n\t\t\t\t\t\t\t\tif(o === -1) { o = this.get_container_ul(); }\n\t\t\t\t\t\t\t\tif(!o.length) { return; }\n\t\t\t\t\t\t\t\to.find(\"li\").each(function () {\n\t\t\t\t\t\t\t\t\tvar th = $(this);\n\t\t\t\t\t\t\t\t\tif(th.data(\"jstree\")) {\n\t\t\t\t\t\t\t\t\t\t$.each(th.data(\"jstree\"), function (plugin, values) {\n\t\t\t\t\t\t\t\t\t\t\tif(t.data[plugin] && $.isFunction(t[\"_\" + plugin + \"_notify\"])) {\n\t\t\t\t\t\t\t\t\t\t\t\tt[\"_\" + plugin + \"_notify\"].call(t, th, values);\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t}\n\t\t\t\tif(this._get_settings().core.load_open) {\n\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t.bind(\"load_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\t\t\tvar o = this._get_node(data.rslt.obj),\n\t\t\t\t\t\t\t\t\tt = this;\n\t\t\t\t\t\t\t\tif(o === -1) { o = this.get_container_ul(); }\n\t\t\t\t\t\t\t\tif(!o.length) { return; }\n\t\t\t\t\t\t\t\to.find(\"li.jstree-open:not(:has(ul))\").each(function () {\n\t\t\t\t\t\t\t\t\tt.load_node(this, $.noop, $.noop);\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t}\n\t\t\t\tthis.__callback();\n\t\t\t\tthis.load_node(-1, function () { this.loaded(); this.reload_nodes(); });\n\t\t\t},\n\t\t\tdestroy\t: function () {\n\t\t\t\tvar i,\n\t\t\t\t\tn = this.get_index(),\n\t\t\t\t\ts = this._get_settings(),\n\t\t\t\t\t_this = this;\n\n\t\t\t\t$.each(s.plugins, function (i, val) {\n\t\t\t\t\ttry { plugins[val].__destroy.apply(_this); } catch(err) { }\n\t\t\t\t});\n\t\t\t\tthis.__callback();\n\t\t\t\t// set focus to another instance if this one is focused\n\t\t\t\tif(this.is_focused()) {\n\t\t\t\t\tfor(i in instances) {\n\t\t\t\t\t\tif(instances.hasOwnProperty(i) && i != n) {\n\t\t\t\t\t\t\tinstances[i].set_focus();\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\t// if no other instance found\n\t\t\t\tif(n === focused_instance) { focused_instance = -1; }\n\t\t\t\t// remove all traces of jstree in the DOM (only the ones set using jstree*) and cleans all events\n\t\t\t\tthis.get_container()\n\t\t\t\t\t.unbind(\".jstree\")\n\t\t\t\t\t.undelegate(\".jstree\")\n\t\t\t\t\t.removeData(\"jstree_instance_id\")\n\t\t\t\t\t.find(\"[class^='jstree']\")\n\t\t\t\t\t\t.addBack()\n\t\t\t\t\t\t.attr(\"class\", function () { return this.className.replace(/jstree[^ ]*|$/ig,''); });\n\t\t\t\t$(document)\n\t\t\t\t\t.unbind(\".jstree-\" + n)\n\t\t\t\t\t.undelegate(\".jstree-\" + n);\n\t\t\t\t// remove the actual data\n\t\t\t\tinstances[n] = null;\n\t\t\t\tdelete instances[n];\n\t\t\t},\n\n\t\t\t_core_notify : function (n, data) {\n\t\t\t\tif(data.opened) {\n\t\t\t\t\tthis.open_node(n, false, true);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tlock : function () {\n\t\t\t\tthis.data.core.locked = true;\n\t\t\t\tthis.get_container().children(\"ul\").addClass(\"jstree-locked\").css(\"opacity\",\"0.7\");\n\t\t\t\tthis.__callback({});\n\t\t\t},\n\t\t\tunlock : function () {\n\t\t\t\tthis.data.core.locked = false;\n\t\t\t\tthis.get_container().children(\"ul\").removeClass(\"jstree-locked\").css(\"opacity\",\"1\");\n\t\t\t\tthis.__callback({});\n\t\t\t},\n\t\t\tis_locked : function () { return this.data.core.locked; },\n\t\t\tsave_opened : function () {\n\t\t\t\tvar _this = this;\n\t\t\t\tthis.data.core.to_open = [];\n\t\t\t\tthis.get_container_ul().find(\"li.jstree-open\").each(function () {\n\t\t\t\t\tif(this.id) { _this.data.core.to_open.push(\"#\" + this.id.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\")); }\n\t\t\t\t});\n\t\t\t\tthis.__callback(_this.data.core.to_open);\n\t\t\t},\n\t\t\tsave_loaded : function () { },\n\t\t\treload_nodes : function (is_callback) {\n\t\t\t\tvar _this = this,\n\t\t\t\t\tdone = true,\n\t\t\t\t\tcurrent = [],\n\t\t\t\t\tremaining = [];\n\t\t\t\tif(!is_callback) {\n\t\t\t\t\tthis.data.core.reopen = false;\n\t\t\t\t\tthis.data.core.refreshing = true;\n\t\t\t\t\tthis.data.core.to_open = $.map($.makeArray(this.data.core.to_open), function (n) { return \"#\" + n.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\"); });\n\t\t\t\t\tthis.data.core.to_load = $.map($.makeArray(this.data.core.to_load), function (n) { return \"#\" + n.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\"); });\n\t\t\t\t\tif(this.data.core.to_open.length) {\n\t\t\t\t\t\tthis.data.core.to_load = this.data.core.to_load.concat(this.data.core.to_open);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(this.data.core.to_load.length) {\n\t\t\t\t\t$.each(this.data.core.to_load, function (i, val) {\n\t\t\t\t\t\tif(val == \"#\") { return true; }\n\t\t\t\t\t\tif($(val).length) { current.push(val); }\n\t\t\t\t\t\telse { remaining.push(val); }\n\t\t\t\t\t});\n\t\t\t\t\tif(current.length) {\n\t\t\t\t\t\tthis.data.core.to_load = remaining;\n\t\t\t\t\t\t$.each(current, function (i, val) {\n\t\t\t\t\t\t\tif(!_this._is_loaded(val)) {\n\t\t\t\t\t\t\t\t_this.load_node(val, function () { _this.reload_nodes(true); }, function () { _this.reload_nodes(true); });\n\t\t\t\t\t\t\t\tdone = false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(this.data.core.to_open.length) {\n\t\t\t\t\t$.each(this.data.core.to_open, function (i, val) {\n\t\t\t\t\t\t_this.open_node(val, false, true);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\tif(done) {\n\t\t\t\t\t// TODO: find a more elegant approach to syncronizing returning requests\n\t\t\t\t\tif(this.data.core.reopen) { clearTimeout(this.data.core.reopen); }\n\t\t\t\t\tthis.data.core.reopen = setTimeout(function () { _this.__callback({}, _this); }, 50);\n\t\t\t\t\tthis.data.core.refreshing = false;\n\t\t\t\t\tthis.reopen();\n\t\t\t\t}\n\t\t\t},\n\t\t\treopen : function () {\n\t\t\t\tvar _this = this;\n\t\t\t\tif(this.data.core.to_open.length) {\n\t\t\t\t\t$.each(this.data.core.to_open, function (i, val) {\n\t\t\t\t\t\t_this.open_node(val, false, true);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\tthis.__callback({});\n\t\t\t},\n\t\t\trefresh : function (obj) {\n\t\t\t\tvar _this = this;\n\t\t\t\tthis.save_opened();\n\t\t\t\tif(!obj) { obj = -1; }\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj) { obj = -1; }\n\t\t\t\tif(obj !== -1) { obj.children(\"UL\").remove(); }\n\t\t\t\telse { this.get_container_ul().empty(); }\n\t\t\t\tthis.load_node(obj, function () { _this.__callback({ \"obj\" : obj}); _this.reload_nodes(); });\n\t\t\t},\n\t\t\t// Dummy function to fire after the first load (so that there is a jstree.loaded event)\n\t\t\tloaded\t: function () {\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\t// deal with focus\n\t\t\tset_focus\t: function () {\n\t\t\t\tif(this.is_focused()) { return; }\n\t\t\t\tvar f = $.jstree._focused();\n\t\t\t\tif(f) { f.unset_focus(); }\n\n\t\t\t\tthis.get_container().addClass(\"jstree-focused\");\n\t\t\t\tfocused_instance = this.get_index();\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\tis_focused\t: function () {\n\t\t\t\treturn focused_instance == this.get_index();\n\t\t\t},\n\t\t\tunset_focus\t: function () {\n\t\t\t\tif(this.is_focused()) {\n\t\t\t\t\tthis.get_container().removeClass(\"jstree-focused\");\n\t\t\t\t\tfocused_instance = -1;\n\t\t\t\t}\n\t\t\t\tthis.__callback();\n\t\t\t},\n\n\t\t\t// traverse\n\t\t\t_get_node\t\t: function (obj) {\n\t\t\t\tvar $obj = $(obj, this.get_container());\n\t\t\t\tif($obj.is(\".jstree\") || obj == -1) { return -1; }\n\t\t\t\t$obj = $obj.closest(\"li\", this.get_container());\n\t\t\t\treturn $obj.length ? $obj : false;\n\t\t\t},\n\t\t\t_get_next\t\t: function (obj, strict) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj === -1) { return this.get_container().find(\"> ul > li:first-child\"); }\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tif(strict) { return (obj.nextAll(\"li\").size() > 0) ? obj.nextAll(\"li:eq(0)\") : false; }\n\n\t\t\t\tif(obj.hasClass(\"jstree-open\")) { return obj.find(\"li:eq(0)\"); }\n\t\t\t\telse if(obj.nextAll(\"li\").size() > 0) { return obj.nextAll(\"li:eq(0)\"); }\n\t\t\t\telse { return obj.parentsUntil(\".jstree\",\"li\").next(\"li\").eq(0); }\n\t\t\t},\n\t\t\t_get_prev\t\t: function (obj, strict) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj === -1) { return this.get_container().find(\"> ul > li:last-child\"); }\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tif(strict) { return (obj.prevAll(\"li\").length > 0) ? obj.prevAll(\"li:eq(0)\") : false; }\n\n\t\t\t\tif(obj.prev(\"li\").length) {\n\t\t\t\t\tobj = obj.prev(\"li\").eq(0);\n\t\t\t\t\twhile(obj.hasClass(\"jstree-open\")) { obj = obj.children(\"ul:eq(0)\").children(\"li:last\"); }\n\t\t\t\t\treturn obj;\n\t\t\t\t}\n\t\t\t\telse { var o = obj.parentsUntil(\".jstree\",\"li:eq(0)\"); return o.length ? o : false; }\n\t\t\t},\n\t\t\t_get_parent\t\t: function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj == -1 || !obj.length) { return false; }\n\t\t\t\tvar o = obj.parentsUntil(\".jstree\", \"li:eq(0)\");\n\t\t\t\treturn o.length ? o : -1;\n\t\t\t},\n\t\t\t_get_children\t: function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj === -1) { return this.get_container().children(\"ul:eq(0)\").children(\"li\"); }\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\treturn obj.children(\"ul:eq(0)\").children(\"li\");\n\t\t\t},\n\t\t\tget_path\t\t: function (obj, id_mode) {\n\t\t\t\tvar p = [],\n\t\t\t\t\t_this = this;\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj === -1 || !obj || !obj.length) { return false; }\n\t\t\t\tobj.parentsUntil(\".jstree\", \"li\").each(function () {\n\t\t\t\t\tp.push( id_mode ? this.id : _this.get_text(this) );\n\t\t\t\t});\n\t\t\t\tp.reverse();\n\t\t\t\tp.push( id_mode ? obj.attr(\"id\") : this.get_text(obj) );\n\t\t\t\treturn p;\n\t\t\t},\n\n\t\t\t// string functions\n\t\t\t_get_string : function (key) {\n\t\t\t\treturn this._get_settings().core.strings[key] || key;\n\t\t\t},\n\n\t\t\tis_open\t\t: function (obj) { obj = this._get_node(obj); return obj && obj !== -1 && obj.hasClass(\"jstree-open\"); },\n\t\t\tis_closed\t: function (obj) { obj = this._get_node(obj); return obj && obj !== -1 && obj.hasClass(\"jstree-closed\"); },\n\t\t\tis_leaf\t\t: function (obj) { obj = this._get_node(obj); return obj && obj !== -1 && obj.hasClass(\"jstree-leaf\"); },\n\t\t\tcorrect_state\t: function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj || obj === -1) { return false; }\n\t\t\t\tobj.removeClass(\"jstree-closed jstree-open\").addClass(\"jstree-leaf\").children(\"ul\").remove();\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\t// open/close\n\t\t\topen_node\t: function (obj, callback, skip_animation) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tif(!obj.hasClass(\"jstree-closed\")) { if(callback) { callback.call(); } return false; }\n\t\t\t\tvar s = skip_animation || is_ie6 ? 0 : this._get_settings().core.animation,\n\t\t\t\t\tt = this;\n\t\t\t\tif(!this._is_loaded(obj)) {\n\t\t\t\t\tobj.children(\"a\").addClass(\"jstree-loading\");\n\t\t\t\t\tthis.load_node(obj, function () { t.open_node(obj, callback, skip_animation); }, callback);\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(this._get_settings().core.open_parents) {\n\t\t\t\t\t\tobj.parentsUntil(\".jstree\",\".jstree-closed\").each(function () {\n\t\t\t\t\t\t\tt.open_node(this, false, true);\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t\tif(s) { obj.children(\"ul\").css(\"display\",\"none\"); }\n\t\t\t\t\tobj.removeClass(\"jstree-closed\").addClass(\"jstree-open\").children(\"a\").removeClass(\"jstree-loading\");\n\t\t\t\t\tif(s) { obj.children(\"ul\").stop(true, true).slideDown(s, function () { this.style.display = \"\"; t.after_open(obj); }); }\n\t\t\t\t\telse { t.after_open(obj); }\n\t\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t\t\tif(callback) { callback.call(); }\n\t\t\t\t}\n\t\t\t},\n\t\t\tafter_open\t: function (obj) { this.__callback({ \"obj\" : obj }); },\n\t\t\tclose_node\t: function (obj, skip_animation) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar s = skip_animation || is_ie6 ? 0 : this._get_settings().core.animation,\n\t\t\t\t\tt = this;\n\t\t\t\tif(!obj.length || !obj.hasClass(\"jstree-open\")) { return false; }\n\t\t\t\tif(s) { obj.children(\"ul\").attr(\"style\",\"display:block !important\"); }\n\t\t\t\tobj.removeClass(\"jstree-open\").addClass(\"jstree-closed\");\n\t\t\t\tif(s) { obj.children(\"ul\").stop(true, true).slideUp(s, function () { this.style.display = \"\"; t.after_close(obj); }); }\n\t\t\t\telse { t.after_close(obj); }\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tafter_close\t: function (obj) { this.__callback({ \"obj\" : obj }); },\n\t\t\ttoggle_node\t: function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj.hasClass(\"jstree-closed\")) { return this.open_node(obj); }\n\t\t\t\tif(obj.hasClass(\"jstree-open\")) { return this.close_node(obj); }\n\t\t\t},\n\t\t\topen_all\t: function (obj, do_animation, original_obj) {\n\t\t\t\tobj = obj ? this._get_node(obj) : -1;\n\t\t\t\tif(!obj || obj === -1) { obj = this.get_container_ul(); }\n\t\t\t\tif(original_obj) {\n\t\t\t\t\tobj = obj.find(\"li.jstree-closed\");\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\toriginal_obj = obj;\n\t\t\t\t\tif(obj.is(\".jstree-closed\")) { obj = obj.find(\"li.jstree-closed\").addBack(); }\n\t\t\t\t\telse { obj = obj.find(\"li.jstree-closed\"); }\n\t\t\t\t}\n\t\t\t\tvar _this = this;\n\t\t\t\tobj.each(function () {\n\t\t\t\t\tvar __this = this;\n\t\t\t\t\tif(!_this._is_loaded(this)) { _this.open_node(this, function() { _this.open_all(__this, do_animation, original_obj); }, !do_animation); }\n\t\t\t\t\telse { _this.open_node(this, false, !do_animation); }\n\t\t\t\t});\n\t\t\t\t// so that callback is fired AFTER all nodes are open\n\t\t\t\tif(original_obj.find('li.jstree-closed').length === 0) { this.__callback({ \"obj\" : original_obj }); }\n\t\t\t},\n\t\t\tclose_all\t: function (obj, do_animation) {\n\t\t\t\tvar _this = this;\n\t\t\t\tobj = obj ? this._get_node(obj) : this.get_container();\n\t\t\t\tif(!obj || obj === -1) { obj = this.get_container_ul(); }\n\t\t\t\tobj.find(\"li.jstree-open\").addBack().each(function () { _this.close_node(this, !do_animation); });\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tclean_node\t: function (obj) {\n\t\t\t\tobj = obj && obj != -1 ? $(obj) : this.get_container_ul();\n\t\t\t\tobj = obj.is(\"li\") ? obj.find(\"li\").addBack() : obj.find(\"li\");\n\t\t\t\tobj.removeClass(\"jstree-last\")\n\t\t\t\t\t.filter(\"li:last-child\").addClass(\"jstree-last\").end()\n\t\t\t\t\t.filter(\":has(li)\")\n\t\t\t\t\t\t.not(\".jstree-open\").removeClass(\"jstree-leaf\").addClass(\"jstree-closed\");\n\t\t\t\tobj.not(\".jstree-open, .jstree-closed\").addClass(\"jstree-leaf\").children(\"ul\").remove();\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\t// rollback\n\t\t\tget_rollback : function () {\n\t\t\t\tthis.__callback();\n\t\t\t\treturn { i : this.get_index(), h : this.get_container().children(\"ul\").clone(true), d : this.data };\n\t\t\t},\n\t\t\tset_rollback : function (html, data) {\n\t\t\t\tthis.get_container().empty().append(html);\n\t\t\t\tthis.data = data;\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\t// Dummy functions to be overwritten by any datastore plugin included\n\t\t\tload_node\t: function (obj, s_call, e_call) { this.__callback({ \"obj\" : obj }); },\n\t\t\t_is_loaded\t: function (obj) { return true; },\n\n\t\t\t// Basic operations: create\n\t\t\tcreate_node\t: function (obj, position, js, callback, is_loaded) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tposition = typeof position === \"undefined\" ? \"last\" : position;\n\t\t\t\tvar d = $(\"<li />\"),\n\t\t\t\t\ts = this._get_settings().core,\n\t\t\t\t\ttmp;\n\n\t\t\t\tif(obj !== -1 && !obj.length) { return false; }\n\t\t\t\tif(!is_loaded && !this._is_loaded(obj)) { this.load_node(obj, function () { this.create_node(obj, position, js, callback, true); }); return false; }\n\n\t\t\t\tthis.__rollback();\n\n\t\t\t\tif(typeof js === \"string\") { js = { \"data\" : js }; }\n\t\t\t\tif(!js) { js = {}; }\n\t\t\t\tif(js.attr) { d.attr(js.attr); }\n\t\t\t\tif(js.metadata) { d.data(js.metadata); }\n\t\t\t\tif(js.state) { d.addClass(\"jstree-\" + js.state); }\n\t\t\t\tif(!js.data) { js.data = this._get_string(\"new_node\"); }\n\t\t\t\tif(!$.isArray(js.data)) { tmp = js.data; js.data = []; js.data.push(tmp); }\n\t\t\t\t$.each(js.data, function (i, m) {\n\t\t\t\t\ttmp = $(\"<a />\");\n\t\t\t\t\tif($.isFunction(m)) { m = m.call(this, js); }\n\t\t\t\t\tif(typeof m == \"string\") { tmp.attr('href','#')[ s.html_titles ? \"html\" : \"text\" ](m); }\n\t\t\t\t\telse {\n\t\t\t\t\t\tif(!m.attr) { m.attr = {}; }\n\t\t\t\t\t\tif(!m.attr.href) { m.attr.href = '#'; }\n\t\t\t\t\t\ttmp.attr(m.attr)[ s.html_titles ? \"html\" : \"text\" ](m.title);\n\t\t\t\t\t\tif(m.language) { tmp.addClass(m.language); }\n\t\t\t\t\t}\n\t\t\t\t\ttmp.prepend(\"<ins class='jstree-icon'>&#160;</ins>\");\n\t\t\t\t\tif(!m.icon && js.icon) { m.icon = js.icon; }\n\t\t\t\t\tif(m.icon) {\n\t\t\t\t\t\tif(m.icon.indexOf(\"/\") === -1) { tmp.children(\"ins\").addClass(m.icon); }\n\t\t\t\t\t\telse { tmp.children(\"ins\").css(\"background\",\"url('\" + m.icon + \"') center center no-repeat\"); }\n\t\t\t\t\t}\n\t\t\t\t\td.append(tmp);\n\t\t\t\t});\n\t\t\t\td.prepend(\"<ins class='jstree-icon'>&#160;</ins>\");\n\t\t\t\tif(obj === -1) {\n\t\t\t\t\tobj = this.get_container();\n\t\t\t\t\tif(position === \"before\") { position = \"first\"; }\n\t\t\t\t\tif(position === \"after\") { position = \"last\"; }\n\t\t\t\t}\n\t\t\t\tswitch(position) {\n\t\t\t\t\tcase \"before\": obj.before(d); tmp = this._get_parent(obj); break;\n\t\t\t\t\tcase \"after\" : obj.after(d);  tmp = this._get_parent(obj); break;\n\t\t\t\t\tcase \"inside\":\n\t\t\t\t\tcase \"first\" :\n\t\t\t\t\t\tif(!obj.children(\"ul\").length) { obj.append(\"<ul />\"); }\n\t\t\t\t\t\tobj.children(\"ul\").prepend(d);\n\t\t\t\t\t\ttmp = obj;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"last\":\n\t\t\t\t\t\tif(!obj.children(\"ul\").length) { obj.append(\"<ul />\"); }\n\t\t\t\t\t\tobj.children(\"ul\").append(d);\n\t\t\t\t\t\ttmp = obj;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tdefault:\n\t\t\t\t\t\tif(!obj.children(\"ul\").length) { obj.append(\"<ul />\"); }\n\t\t\t\t\t\tif(!position) { position = 0; }\n\t\t\t\t\t\ttmp = obj.children(\"ul\").children(\"li\").eq(position);\n\t\t\t\t\t\tif(tmp.length) { tmp.before(d); }\n\t\t\t\t\t\telse { obj.children(\"ul\").append(d); }\n\t\t\t\t\t\ttmp = obj;\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tif(tmp === -1 || tmp.get(0) === this.get_container().get(0)) { tmp = -1; }\n\t\t\t\tthis.clean_node(tmp);\n\t\t\t\tthis.__callback({ \"obj\" : d, \"parent\" : tmp });\n\t\t\t\tif(callback) { callback.call(this, d); }\n\t\t\t\treturn d;\n\t\t\t},\n\t\t\t// Basic operations: rename (deal with text)\n\t\t\tget_text\t: function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tvar s = this._get_settings().core.html_titles;\n\t\t\t\tobj = obj.children(\"a:eq(0)\");\n\t\t\t\tif(s) {\n\t\t\t\t\tobj = obj.clone();\n\t\t\t\t\tobj.children(\"INS\").remove();\n\t\t\t\t\treturn obj.html();\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tobj = obj.contents().filter(function() { return this.nodeType == 3; })[0];\n\t\t\t\t\treturn obj.nodeValue;\n\t\t\t\t}\n\t\t\t},\n\t\t\tset_text\t: function (obj, val) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tobj = obj.children(\"a:eq(0)\");\n\t\t\t\tif(this._get_settings().core.html_titles) {\n\t\t\t\t\tvar tmp = obj.children(\"INS\").clone();\n\t\t\t\t\tobj.html(val).prepend(tmp);\n\t\t\t\t\tthis.__callback({ \"obj\" : obj, \"name\" : val });\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tobj = obj.contents().filter(function() { return this.nodeType == 3; })[0];\n\t\t\t\t\tthis.__callback({ \"obj\" : obj, \"name\" : val });\n\t\t\t\t\treturn (obj.nodeValue = val);\n\t\t\t\t}\n\t\t\t},\n\t\t\trename_node : function (obj, val) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tthis.__rollback();\n\t\t\t\tif(obj && obj.length && this.set_text.apply(this, Array.prototype.slice.call(arguments))) { this.__callback({ \"obj\" : obj, \"name\" : val }); }\n\t\t\t},\n\t\t\t// Basic operations: deleting nodes\n\t\t\tdelete_node : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tthis.__rollback();\n\t\t\t\tvar p = this._get_parent(obj), prev = $([]), t = this;\n\t\t\t\tobj.each(function () {\n\t\t\t\t\tprev = prev.add(t._get_prev(this));\n\t\t\t\t});\n\t\t\t\tobj = obj.detach();\n\t\t\t\tif(p !== -1 && p.find(\"> ul > li\").length === 0) {\n\t\t\t\t\tp.removeClass(\"jstree-open jstree-closed\").addClass(\"jstree-leaf\");\n\t\t\t\t}\n\t\t\t\tthis.clean_node(p);\n\t\t\t\tthis.__callback({ \"obj\" : obj, \"prev\" : prev, \"parent\" : p });\n\t\t\t\treturn obj;\n\t\t\t},\n\t\t\tprepare_move : function (o, r, pos, cb, is_cb) {\n\t\t\t\tvar p = {};\n\n\t\t\t\tp.ot = $.jstree._reference(o) || this;\n\t\t\t\tp.o = p.ot._get_node(o);\n\t\t\t\tp.r = r === - 1 ? -1 : this._get_node(r);\n\t\t\t\tp.p = (typeof pos === \"undefined\" || pos === false) ? \"last\" : pos; // TODO: move to a setting\n\t\t\t\tif(!is_cb && prepared_move.o && prepared_move.o[0] === p.o[0] && prepared_move.r[0] === p.r[0] && prepared_move.p === p.p) {\n\t\t\t\t\tthis.__callback(prepared_move);\n\t\t\t\t\tif(cb) { cb.call(this, prepared_move); }\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tp.ot = $.jstree._reference(p.o) || this;\n\t\t\t\tp.rt = $.jstree._reference(p.r) || this; // r === -1 ? p.ot : $.jstree._reference(p.r) || this\n\t\t\t\tif(p.r === -1 || !p.r) {\n\t\t\t\t\tp.cr = -1;\n\t\t\t\t\tswitch(p.p) {\n\t\t\t\t\t\tcase \"first\":\n\t\t\t\t\t\tcase \"before\":\n\t\t\t\t\t\tcase \"inside\":\n\t\t\t\t\t\t\tp.cp = 0;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"after\":\n\t\t\t\t\t\tcase \"last\":\n\t\t\t\t\t\t\tp.cp = p.rt.get_container().find(\" > ul > li\").length;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tdefault:\n\t\t\t\t\t\t\tp.cp = p.p;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(!/^(before|after)$/.test(p.p) && !this._is_loaded(p.r)) {\n\t\t\t\t\t\treturn this.load_node(p.r, function () { this.prepare_move(o, r, pos, cb, true); });\n\t\t\t\t\t}\n\t\t\t\t\tswitch(p.p) {\n\t\t\t\t\t\tcase \"before\":\n\t\t\t\t\t\t\tp.cp = p.r.index();\n\t\t\t\t\t\t\tp.cr = p.rt._get_parent(p.r);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"after\":\n\t\t\t\t\t\t\tp.cp = p.r.index() + 1;\n\t\t\t\t\t\t\tp.cr = p.rt._get_parent(p.r);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"inside\":\n\t\t\t\t\t\tcase \"first\":\n\t\t\t\t\t\t\tp.cp = 0;\n\t\t\t\t\t\t\tp.cr = p.r;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"last\":\n\t\t\t\t\t\t\tp.cp = p.r.find(\" > ul > li\").length;\n\t\t\t\t\t\t\tp.cr = p.r;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tdefault:\n\t\t\t\t\t\t\tp.cp = p.p;\n\t\t\t\t\t\t\tp.cr = p.r;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tp.np = p.cr == -1 ? p.rt.get_container() : p.cr;\n\t\t\t\tp.op = p.ot._get_parent(p.o);\n\t\t\t\tp.cop = p.o.index();\n\t\t\t\tif(p.op === -1) { p.op = p.ot ? p.ot.get_container() : this.get_container(); }\n\t\t\t\tif(!/^(before|after)$/.test(p.p) && p.op && p.np && p.op[0] === p.np[0] && p.o.index() < p.cp) { p.cp++; }\n\t\t\t\t//if(p.p === \"before\" && p.op && p.np && p.op[0] === p.np[0] && p.o.index() < p.cp) { p.cp--; }\n\t\t\t\tp.or = p.np.find(\" > ul > li:nth-child(\" + (p.cp + 1) + \")\");\n\t\t\t\tprepared_move = p;\n\t\t\t\tthis.__callback(prepared_move);\n\t\t\t\tif(cb) { cb.call(this, prepared_move); }\n\t\t\t},\n\t\t\tcheck_move : function () {\n\t\t\t\tvar obj = prepared_move, ret = true, r = obj.r === -1 ? this.get_container() : obj.r;\n\t\t\t\tif(!obj || !obj.o || obj.or[0] === obj.o[0]) { return false; }\n\t\t\t\tif(obj.op && obj.np && obj.op[0] === obj.np[0] && obj.cp - 1 === obj.o.index()) { return false; }\n\t\t\t\tobj.o.each(function () {\n\t\t\t\t\tif(r.parentsUntil(\".jstree\", \"li\").addBack().index(this) !== -1) { ret = false; return false; }\n\t\t\t\t});\n\t\t\t\treturn ret;\n\t\t\t},\n\t\t\tmove_node : function (obj, ref, position, is_copy, is_prepared, skip_check) {\n\t\t\t\tif(!is_prepared) {\n\t\t\t\t\treturn this.prepare_move(obj, ref, position, function (p) {\n\t\t\t\t\t\tthis.move_node(p, false, false, is_copy, true, skip_check);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\tif(is_copy) {\n\t\t\t\t\tprepared_move.cy = true;\n\t\t\t\t}\n\t\t\t\tif(!skip_check && !this.check_move()) { return false; }\n\n\t\t\t\tthis.__rollback();\n\t\t\t\tvar o = false;\n\t\t\t\tif(is_copy) {\n\t\t\t\t\to = obj.o.clone(true);\n\t\t\t\t\to.find(\"*[id]\").addBack().each(function () {\n\t\t\t\t\t\tif(this.id) { this.id = \"copy_\" + this.id; }\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\telse { o = obj.o; }\n\n\t\t\t\tif(obj.or.length) { obj.or.before(o); }\n\t\t\t\telse {\n\t\t\t\t\tif(!obj.np.children(\"ul\").length) { $(\"<ul />\").appendTo(obj.np); }\n\t\t\t\t\tobj.np.children(\"ul:eq(0)\").append(o);\n\t\t\t\t}\n\n\t\t\t\ttry {\n\t\t\t\t\tobj.ot.clean_node(obj.op);\n\t\t\t\t\tobj.rt.clean_node(obj.np);\n\t\t\t\t\tif(!obj.op.find(\"> ul > li\").length) {\n\t\t\t\t\t\tobj.op.removeClass(\"jstree-open jstree-closed\").addClass(\"jstree-leaf\").children(\"ul\").remove();\n\t\t\t\t\t}\n\t\t\t\t} catch (e) { }\n\n\t\t\t\tif(is_copy) {\n\t\t\t\t\tprepared_move.cy = true;\n\t\t\t\t\tprepared_move.oc = o;\n\t\t\t\t}\n\t\t\t\tthis.__callback(prepared_move);\n\t\t\t\treturn prepared_move;\n\t\t\t},\n\t\t\t_get_move : function () { return prepared_move; }\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree ui plugin\n * This plugins handles selecting/deselecting/hovering/dehovering nodes\n */\n(function ($) {\n\tvar scrollbar_width, e1, e2;\n\t$(function() {\n\t\tif (/msie/.test(navigator.userAgent.toLowerCase())) {\n\t\t\te1 = $('<textarea cols=\"10\" rows=\"2\"></textarea>').css({ position: 'absolute', top: -1000, left: 0 }).appendTo('body');\n\t\t\te2 = $('<textarea cols=\"10\" rows=\"2\" style=\"overflow: hidden;\"></textarea>').css({ position: 'absolute', top: -1000, left: 0 }).appendTo('body');\n\t\t\tscrollbar_width = e1.width() - e2.width();\n\t\t\te1.add(e2).remove();\n\t\t}\n\t\telse {\n\t\t\te1 = $('<div />').css({ width: 100, height: 100, overflow: 'auto', position: 'absolute', top: -1000, left: 0 })\n\t\t\t\t\t.prependTo('body').append('<div />').find('div').css({ width: '100%', height: 200 });\n\t\t\tscrollbar_width = 100 - e1.width();\n\t\t\te1.parent().remove();\n\t\t}\n\t});\n\t$.jstree.plugin(\"ui\", {\n\t\t__init : function () {\n\t\t\tthis.data.ui.selected = $();\n\t\t\tthis.data.ui.last_selected = false;\n\t\t\tthis.data.ui.hovered = null;\n\t\t\tthis.data.ui.to_select = this.get_settings().ui.initially_select;\n\n\t\t\tthis.get_container()\n\t\t\t\t.delegate(\"a\", \"click.jstree\", $.proxy(function (event) {\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t\tevent.currentTarget.blur();\n\t\t\t\t\t\tif(!$(event.currentTarget).hasClass(\"jstree-loading\")) {\n\t\t\t\t\t\t\tthis.select_node(event.currentTarget, true, event);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mouseenter.jstree\", $.proxy(function (event) {\n\t\t\t\t\t\tif(!$(event.currentTarget).hasClass(\"jstree-loading\")) {\n\t\t\t\t\t\t\tthis.hover_node(event.target);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mouseleave.jstree\", $.proxy(function (event) {\n\t\t\t\t\t\tif(!$(event.currentTarget).hasClass(\"jstree-loading\")) {\n\t\t\t\t\t\t\tthis.dehover_node(event.target);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"reopen.jstree\", $.proxy(function () {\n\t\t\t\t\t\tthis.reselect();\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"get_rollback.jstree\", $.proxy(function () {\n\t\t\t\t\t\tthis.dehover_node();\n\t\t\t\t\t\tthis.save_selected();\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"set_rollback.jstree\", $.proxy(function () {\n\t\t\t\t\t\tthis.reselect();\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"close_node.jstree\", $.proxy(function (event, data) {\n\t\t\t\t\t\tvar s = this._get_settings().ui,\n\t\t\t\t\t\t\tobj = this._get_node(data.rslt.obj),\n\t\t\t\t\t\t\tclk = (obj && obj.length) ? obj.children(\"ul\").find(\"a.jstree-clicked\") : $(),\n\t\t\t\t\t\t\t_this = this;\n\t\t\t\t\t\tif(s.selected_parent_close === false || !clk.length) { return; }\n\t\t\t\t\t\tclk.each(function () {\n\t\t\t\t\t\t\t_this.deselect_node(this);\n\t\t\t\t\t\t\tif(s.selected_parent_close === \"select_parent\") { _this.select_node(obj); }\n\t\t\t\t\t\t});\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"delete_node.jstree\", $.proxy(function (event, data) {\n\t\t\t\t\t\tvar s = this._get_settings().ui.select_prev_on_delete,\n\t\t\t\t\t\t\tobj = this._get_node(data.rslt.obj),\n\t\t\t\t\t\t\tclk = (obj && obj.length) ? obj.find(\"a.jstree-clicked\") : [],\n\t\t\t\t\t\t\t_this = this;\n\t\t\t\t\t\tclk.each(function () { _this.deselect_node(this); });\n\t\t\t\t\t\tif(s && clk.length) {\n\t\t\t\t\t\t\tdata.rslt.prev.each(function () {\n\t\t\t\t\t\t\t\tif(this.parentNode) { _this.select_node(this); return false; /* if return false is removed all prev nodes will be selected */}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"move_node.jstree\", $.proxy(function (event, data) {\n\t\t\t\t\t\tif(data.rslt.cy) {\n\t\t\t\t\t\t\tdata.rslt.oc.find(\"a.jstree-clicked\").removeClass(\"jstree-clicked\");\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\tselect_limit : -1, // 0, 1, 2 ... or -1 for unlimited\n\t\t\tselect_multiple_modifier : \"ctrl\", // on, or ctrl, shift, alt\n\t\t\tselect_range_modifier : \"shift\",\n\t\t\tselected_parent_close : \"select_parent\", // false, \"deselect\", \"select_parent\"\n\t\t\tselected_parent_open : true,\n\t\t\tselect_prev_on_delete : true,\n\t\t\tdisable_selecting_children : false,\n\t\t\tinitially_select : []\n\t\t},\n\t\t_fn : {\n\t\t\t_get_node : function (obj, allow_multiple) {\n\t\t\t\tif(typeof obj === \"undefined\" || obj === null) { return allow_multiple ? this.data.ui.selected : this.data.ui.last_selected; }\n\t\t\t\tvar $obj = $(obj, this.get_container());\n\t\t\t\tif($obj.is(\".jstree\") || obj == -1) { return -1; }\n\t\t\t\t$obj = $obj.closest(\"li\", this.get_container());\n\t\t\t\treturn $obj.length ? $obj : false;\n\t\t\t},\n\t\t\t_ui_notify : function (n, data) {\n\t\t\t\tif(data.selected) {\n\t\t\t\t\tthis.select_node(n, false);\n\t\t\t\t}\n\t\t\t},\n\t\t\tsave_selected : function () {\n\t\t\t\tvar _this = this;\n\t\t\t\tthis.data.ui.to_select = [];\n\t\t\t\tthis.data.ui.selected.each(function () { if(this.id) { _this.data.ui.to_select.push(\"#\" + this.id.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\")); } });\n\t\t\t\tthis.__callback(this.data.ui.to_select);\n\t\t\t},\n\t\t\treselect : function () {\n\t\t\t\tvar _this = this,\n\t\t\t\t\ts = this.data.ui.to_select;\n\t\t\t\ts = $.map($.makeArray(s), function (n) { return \"#\" + n.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\"); });\n\t\t\t\t// this.deselect_all(); WHY deselect, breaks plugin state notifier?\n\t\t\t\t$.each(s, function (i, val) { if(val && val !== \"#\") { _this.select_node(val); } });\n\t\t\t\tthis.data.ui.selected = this.data.ui.selected.filter(function () { return this.parentNode; });\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\trefresh : function (obj) {\n\t\t\t\tthis.save_selected();\n\t\t\t\treturn this.__call_old();\n\t\t\t},\n\t\t\thover_node : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\t//if(this.data.ui.hovered && obj.get(0) === this.data.ui.hovered.get(0)) { return; }\n\t\t\t\tif(!obj.hasClass(\"jstree-hovered\")) { this.dehover_node(); }\n\t\t\t\tthis.data.ui.hovered = obj.children(\"a\").addClass(\"jstree-hovered\").parent();\n\t\t\t\tthis._fix_scroll(obj);\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tdehover_node : function () {\n\t\t\t\tvar obj = this.data.ui.hovered, p;\n\t\t\t\tif(!obj || !obj.length) { return false; }\n\t\t\t\tp = obj.children(\"a\").removeClass(\"jstree-hovered\").parent();\n\t\t\t\tif(this.data.ui.hovered[0] === p[0]) { this.data.ui.hovered = null; }\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tselect_node : function (obj, check, e) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj == -1 || !obj || !obj.length) { return false; }\n\t\t\t\tvar s = this._get_settings().ui,\n\t\t\t\t\tis_multiple = (s.select_multiple_modifier == \"on\" || (s.select_multiple_modifier !== false && e && e[s.select_multiple_modifier + \"Key\"])),\n\t\t\t\t\tis_range = (s.select_range_modifier !== false && e && e[s.select_range_modifier + \"Key\"] && this.data.ui.last_selected && this.data.ui.last_selected[0] !== obj[0] && this.data.ui.last_selected.parent()[0] === obj.parent()[0]),\n\t\t\t\t\tis_selected = this.is_selected(obj),\n\t\t\t\t\tproceed = true,\n\t\t\t\t\tt = this;\n\t\t\t\tif(check) {\n\t\t\t\t\tif(s.disable_selecting_children && is_multiple &&\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\t(obj.parentsUntil(\".jstree\",\"li\").children(\"a.jstree-clicked\").length) ||\n\t\t\t\t\t\t\t(obj.children(\"ul\").find(\"a.jstree-clicked:eq(0)\").length)\n\t\t\t\t\t\t)\n\t\t\t\t\t) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t\tproceed = false;\n\t\t\t\t\tswitch(!0) {\n\t\t\t\t\t\tcase (is_range):\n\t\t\t\t\t\t\tthis.data.ui.last_selected.addClass(\"jstree-last-selected\");\n\t\t\t\t\t\t\tobj = obj[ obj.index() < this.data.ui.last_selected.index() ? \"nextUntil\" : \"prevUntil\" ](\".jstree-last-selected\").addBack();\n\t\t\t\t\t\t\tif(s.select_limit == -1 || obj.length < s.select_limit) {\n\t\t\t\t\t\t\t\tthis.data.ui.last_selected.removeClass(\"jstree-last-selected\");\n\t\t\t\t\t\t\t\tthis.data.ui.selected.each(function () {\n\t\t\t\t\t\t\t\t\tif(this !== t.data.ui.last_selected[0]) { t.deselect_node(this); }\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\tis_selected = false;\n\t\t\t\t\t\t\t\tproceed = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tproceed = false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase (is_selected && !is_multiple):\n\t\t\t\t\t\t\tthis.deselect_all();\n\t\t\t\t\t\t\tis_selected = false;\n\t\t\t\t\t\t\tproceed = true;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase (!is_selected && !is_multiple):\n\t\t\t\t\t\t\tif(s.select_limit == -1 || s.select_limit > 0) {\n\t\t\t\t\t\t\t\tthis.deselect_all();\n\t\t\t\t\t\t\t\tproceed = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase (is_selected && is_multiple):\n\t\t\t\t\t\t\tthis.deselect_node(obj);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase (!is_selected && is_multiple):\n\t\t\t\t\t\t\tif(s.select_limit == -1 || this.data.ui.selected.length + 1 <= s.select_limit) {\n\t\t\t\t\t\t\t\tproceed = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(proceed && !is_selected) {\n\t\t\t\t\tif(!is_range) { this.data.ui.last_selected = obj; }\n\t\t\t\t\tobj.children(\"a\").addClass(\"jstree-clicked\");\n\t\t\t\t\tif(s.selected_parent_open) {\n\t\t\t\t\t\tobj.parents(\".jstree-closed\").each(function () { t.open_node(this, false, true); });\n\t\t\t\t\t}\n\t\t\t\t\tthis.data.ui.selected = this.data.ui.selected.add(obj);\n\t\t\t\t\tthis._fix_scroll(obj.eq(0));\n\t\t\t\t\tthis.__callback({ \"obj\" : obj, \"e\" : e });\n\t\t\t\t}\n\t\t\t},\n\t\t\t_fix_scroll : function (obj) {\n\t\t\t\tvar c = this.get_container()[0], t;\n\t\t\t\tif(c.scrollHeight > c.offsetHeight) {\n\t\t\t\t\tobj = this._get_node(obj);\n\t\t\t\t\tif(!obj || obj === -1 || !obj.length || !obj.is(\":visible\")) { return; }\n\t\t\t\t\tt = obj.offset().top - this.get_container().offset().top;\n\t\t\t\t\tif(t < 0) {\n\t\t\t\t\t\tc.scrollTop = c.scrollTop + t - 1;\n\t\t\t\t\t}\n\t\t\t\t\tif(t + this.data.core.li_height + (c.scrollWidth > c.offsetWidth ? scrollbar_width : 0) > c.offsetHeight) {\n\t\t\t\t\t\tc.scrollTop = c.scrollTop + (t - c.offsetHeight + this.data.core.li_height + 1 + (c.scrollWidth > c.offsetWidth ? scrollbar_width : 0));\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\tdeselect_node : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tif(this.is_selected(obj)) {\n\t\t\t\t\tobj.children(\"a\").removeClass(\"jstree-clicked\");\n\t\t\t\t\tthis.data.ui.selected = this.data.ui.selected.not(obj);\n\t\t\t\t\tif(this.data.ui.last_selected.get(0) === obj.get(0)) { this.data.ui.last_selected = this.data.ui.selected.eq(0); }\n\t\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t\t}\n\t\t\t},\n\t\t\ttoggle_select : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return false; }\n\t\t\t\tif(this.is_selected(obj)) { this.deselect_node(obj); }\n\t\t\t\telse { this.select_node(obj); }\n\t\t\t},\n\t\t\tis_selected : function (obj) { return this.data.ui.selected.index(this._get_node(obj)) >= 0; },\n\t\t\tget_selected : function (context) {\n\t\t\t\treturn context ? $(context).find(\"a.jstree-clicked\").parent() : this.data.ui.selected;\n\t\t\t},\n\t\t\tdeselect_all : function (context) {\n\t\t\t\tvar ret = context ? $(context).find(\"a.jstree-clicked\").parent() : this.get_container().find(\"a.jstree-clicked\").parent();\n\t\t\t\tret.children(\"a.jstree-clicked\").removeClass(\"jstree-clicked\");\n\t\t\t\tthis.data.ui.selected = $([]);\n\t\t\t\tthis.data.ui.last_selected = false;\n\t\t\t\tthis.__callback({ \"obj\" : ret });\n\t\t\t}\n\t\t}\n\t});\n\t// include the selection plugin by default\n\t$.jstree.defaults.plugins.push(\"ui\");\n})(jQuery);\n//*/\n\n/*\n * jsTree CRRM plugin\n * Handles creating/renaming/removing/moving nodes by user interaction.\n */\n(function ($) {\n\t$.jstree.plugin(\"crrm\", {\n\t\t__init : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"move_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\tif(this._get_settings().crrm.move.open_onmove) {\n\t\t\t\t\t\tvar t = this;\n\t\t\t\t\t\tdata.rslt.np.parentsUntil(\".jstree\").addBack().filter(\".jstree-closed\").each(function () {\n\t\t\t\t\t\t\tt.open_node(this, false, true);\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\tinput_width_limit : 200,\n\t\t\tmove : {\n\t\t\t\talways_copy\t\t\t: false, // false, true or \"multitree\"\n\t\t\t\topen_onmove\t\t\t: true,\n\t\t\t\tdefault_position\t: \"last\",\n\t\t\t\tcheck_move\t\t\t: function (m) { return true; }\n\t\t\t}\n\t\t},\n\t\t_fn : {\n\t\t\t_show_input : function (obj, callback) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar rtl = this._get_settings().core.rtl,\n\t\t\t\t\tw = this._get_settings().crrm.input_width_limit,\n\t\t\t\t\tw1 = obj.children(\"ins\").width(),\n\t\t\t\t\tw2 = obj.find(\"> a:visible > ins\").width() * obj.find(\"> a:visible > ins\").length,\n\t\t\t\t\tt = this.get_text(obj),\n\t\t\t\t\th1 = $(\"<div />\", { css : { \"position\" : \"absolute\", \"top\" : \"-200px\", \"left\" : (rtl ? \"0px\" : \"-1000px\"), \"visibility\" : \"hidden\" } }).appendTo(\"body\"),\n\t\t\t\t\th2 = obj.css(\"position\",\"relative\").append(\n\t\t\t\t\t$(\"<input />\", {\n\t\t\t\t\t\t\"value\" : t,\n\t\t\t\t\t\t\"class\" : \"jstree-rename-input\",\n\t\t\t\t\t\t// \"size\" : t.length,\n\t\t\t\t\t\t\"css\" : {\n\t\t\t\t\t\t\t\"padding\" : \"0\",\n\t\t\t\t\t\t\t\"border\" : \"1px solid silver\",\n\t\t\t\t\t\t\t\"position\" : \"absolute\",\n\t\t\t\t\t\t\t\"left\"  : (rtl ? \"auto\" : (w1 + w2 + 4) + \"px\"),\n\t\t\t\t\t\t\t\"right\" : (rtl ? (w1 + w2 + 4) + \"px\" : \"auto\"),\n\t\t\t\t\t\t\t\"top\" : \"0px\",\n\t\t\t\t\t\t\t\"height\" : (this.data.core.li_height - 2) + \"px\",\n\t\t\t\t\t\t\t\"lineHeight\" : (this.data.core.li_height - 2) + \"px\",\n\t\t\t\t\t\t\t\"width\" : \"150px\" // will be set a bit further down\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"blur\" : $.proxy(function () {\n\t\t\t\t\t\t\tvar i = obj.children(\".jstree-rename-input\"),\n\t\t\t\t\t\t\t\tv = i.val();\n\t\t\t\t\t\t\tif(v === \"\") { v = t; }\n\t\t\t\t\t\t\th1.remove();\n\t\t\t\t\t\t\ti.remove(); // rollback purposes\n\t\t\t\t\t\t\tthis.set_text(obj,t); // rollback purposes\n\t\t\t\t\t\t\tthis.rename_node(obj, v);\n\t\t\t\t\t\t\tcallback.call(this, obj, v, t);\n\t\t\t\t\t\t\tobj.css(\"position\",\"\");\n\t\t\t\t\t\t}, this),\n\t\t\t\t\t\t\"keyup\" : function (event) {\n\t\t\t\t\t\t\tvar key = event.keyCode || event.which;\n\t\t\t\t\t\t\tif(key == 27) { this.value = t; this.blur(); return; }\n\t\t\t\t\t\t\telse if(key == 13) { this.blur(); return; }\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\th2.width(Math.min(h1.text(\"pW\" + this.value).width(),w));\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"keypress\" : function(event) {\n\t\t\t\t\t\t\tvar key = event.keyCode || event.which;\n\t\t\t\t\t\t\tif(key == 13) { return false; }\n\t\t\t\t\t\t}\n\t\t\t\t\t})\n\t\t\t\t).children(\".jstree-rename-input\");\n\t\t\t\tthis.set_text(obj, \"\");\n\t\t\t\th1.css({\n\t\t\t\t\t\tfontFamily\t\t: h2.css('fontFamily')\t\t|| '',\n\t\t\t\t\t\tfontSize\t\t: h2.css('fontSize')\t\t|| '',\n\t\t\t\t\t\tfontWeight\t\t: h2.css('fontWeight')\t\t|| '',\n\t\t\t\t\t\tfontStyle\t\t: h2.css('fontStyle')\t\t|| '',\n\t\t\t\t\t\tfontStretch\t\t: h2.css('fontStretch')\t\t|| '',\n\t\t\t\t\t\tfontVariant\t\t: h2.css('fontVariant')\t\t|| '',\n\t\t\t\t\t\tletterSpacing\t: h2.css('letterSpacing')\t|| '',\n\t\t\t\t\t\twordSpacing\t\t: h2.css('wordSpacing')\t\t|| ''\n\t\t\t\t});\n\t\t\t\th2.width(Math.min(h1.text(\"pW\" + h2[0].value).width(),w))[0].select();\n\t\t\t},\n\t\t\trename : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tthis.__rollback();\n\t\t\t\tvar f = this.__callback;\n\t\t\t\tthis._show_input(obj, function (obj, new_name, old_name) {\n\t\t\t\t\tf.call(this, { \"obj\" : obj, \"new_name\" : new_name, \"old_name\" : old_name });\n\t\t\t\t});\n\t\t\t},\n\t\t\tcreate : function (obj, position, js, callback, skip_rename) {\n\t\t\t\tvar t, _this = this;\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj) { obj = -1; }\n\t\t\t\tthis.__rollback();\n\t\t\t\tt = this.create_node(obj, position, js, function (t) {\n\t\t\t\t\tvar p = this._get_parent(t),\n\t\t\t\t\t\tpos = $(t).index();\n\t\t\t\t\tif(callback) { callback.call(this, t); }\n\t\t\t\t\tif(p.length && p.hasClass(\"jstree-closed\")) { this.open_node(p, false, true); }\n\t\t\t\t\tif(!skip_rename) {\n\t\t\t\t\t\tthis._show_input(t, function (obj, new_name, old_name) {\n\t\t\t\t\t\t\t_this.__callback({ \"obj\" : obj, \"name\" : new_name, \"parent\" : p, \"position\" : pos });\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t\telse { _this.__callback({ \"obj\" : t, \"name\" : this.get_text(t), \"parent\" : p, \"position\" : pos }); }\n\t\t\t\t});\n\t\t\t\treturn t;\n\t\t\t},\n\t\t\tremove : function (obj) {\n\t\t\t\tobj = this._get_node(obj, true);\n\t\t\t\tvar p = this._get_parent(obj), prev = this._get_prev(obj);\n\t\t\t\tthis.__rollback();\n\t\t\t\tobj = this.delete_node(obj);\n\t\t\t\tif(obj !== false) { this.__callback({ \"obj\" : obj, \"prev\" : prev, \"parent\" : p }); }\n\t\t\t},\n\t\t\tcheck_move : function () {\n\t\t\t\tif(!this.__call_old()) { return false; }\n\t\t\t\tvar s = this._get_settings().crrm.move;\n\t\t\t\tif(!s.check_move.call(this, this._get_move())) { return false; }\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\tmove_node : function (obj, ref, position, is_copy, is_prepared, skip_check) {\n\t\t\t\tvar s = this._get_settings().crrm.move;\n\t\t\t\tif(!is_prepared) {\n\t\t\t\t\tif(typeof position === \"undefined\") { position = s.default_position; }\n\t\t\t\t\tif(position === \"inside\" && !s.default_position.match(/^(before|after)$/)) { position = s.default_position; }\n\t\t\t\t\treturn this.__call_old(true, obj, ref, position, is_copy, false, skip_check);\n\t\t\t\t}\n\t\t\t\t// if the move is already prepared\n\t\t\t\tif(s.always_copy === true || (s.always_copy === \"multitree\" && obj.rt.get_index() !== obj.ot.get_index() )) {\n\t\t\t\t\tis_copy = true;\n\t\t\t\t}\n\t\t\t\tthis.__call_old(true, obj, ref, position, is_copy, true, skip_check);\n\t\t\t},\n\n\t\t\tcut : function (obj) {\n\t\t\t\tobj = this._get_node(obj, true);\n\t\t\t\tif(!obj || !obj.length) { return false; }\n\t\t\t\tthis.data.crrm.cp_nodes = false;\n\t\t\t\tthis.data.crrm.ct_nodes = obj;\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tcopy : function (obj) {\n\t\t\t\tobj = this._get_node(obj, true);\n\t\t\t\tif(!obj || !obj.length) { return false; }\n\t\t\t\tthis.data.crrm.ct_nodes = false;\n\t\t\t\tthis.data.crrm.cp_nodes = obj;\n\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t},\n\t\t\tpaste : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj || !obj.length) { return false; }\n\t\t\t\tvar nodes = this.data.crrm.ct_nodes ? this.data.crrm.ct_nodes : this.data.crrm.cp_nodes;\n\t\t\t\tif(!this.data.crrm.ct_nodes && !this.data.crrm.cp_nodes) { return false; }\n\t\t\t\tif(this.data.crrm.ct_nodes) { this.move_node(this.data.crrm.ct_nodes, obj); this.data.crrm.ct_nodes = false; }\n\t\t\t\tif(this.data.crrm.cp_nodes) { this.move_node(this.data.crrm.cp_nodes, obj, false, true); }\n\t\t\t\tthis.__callback({ \"obj\" : obj, \"nodes\" : nodes });\n\t\t\t}\n\t\t}\n\t});\n\t// include the crr plugin by default\n\t// $.jstree.defaults.plugins.push(\"crrm\");\n})(jQuery);\n//*/\n\n/*\n * jsTree themes plugin\n * Handles loading and setting themes, as well as detecting path to themes, etc.\n */\n(function ($) {\n\tvar themes_loaded = [];\n\t// this variable stores the path to the themes folder - if left as false - it will be autodetected\n\t$.jstree._themes = false;\n\t$.jstree.plugin(\"themes\", {\n\t\t__init : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"init.jstree\", $.proxy(function () {\n\t\t\t\t\t\tvar s = this._get_settings().themes;\n\t\t\t\t\t\tthis.data.themes.dots = s.dots;\n\t\t\t\t\t\tthis.data.themes.icons = s.icons;\n\t\t\t\t\t\tthis.set_theme(s.theme, s.url);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"loaded.jstree\", $.proxy(function () {\n\t\t\t\t\t\t// bound here too, as simple HTML tree's won't honor dots & icons otherwise\n\t\t\t\t\t\tif(!this.data.themes.dots) { this.hide_dots(); }\n\t\t\t\t\t\telse { this.show_dots(); }\n\t\t\t\t\t\tif(!this.data.themes.icons) { this.hide_icons(); }\n\t\t\t\t\t\telse { this.show_icons(); }\n\t\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\ttheme : \"default\",\n\t\t\turl : false,\n\t\t\tdots : false,\n\t\t\ticons : true\n\t\t},\n\t\t_fn : {\n\t\t\tset_theme : function (theme_name, theme_url) {\n\t\t\t\tif(!theme_name) { return false; }\n\t\t\t\tif(!theme_url) { theme_url = $.jstree._themes + theme_name + '/style.css'; }\n\t\t\t\tif($.inArray(theme_url, themes_loaded) == -1) {\n\t\t\t\t\t// $.vakata.css.add_sheet({ \"url\" : theme_url });\n\t\t\t\t\tthemes_loaded.push(theme_url);\n\t\t\t\t}\n\t\t\t\tif(this.data.themes.theme != theme_name) {\n\t\t\t\t\tthis.get_container().removeClass('jstree-' + this.data.themes.theme);\n\t\t\t\t\tthis.data.themes.theme = theme_name;\n\t\t\t\t}\n\t\t\t\tthis.get_container().addClass('jstree-' + theme_name);\n\t\t\t\tif(!this.data.themes.dots) { this.hide_dots(); }\n\t\t\t\telse { this.show_dots(); }\n\t\t\t\tif(!this.data.themes.icons) { this.hide_icons(); }\n\t\t\t\telse { this.show_icons(); }\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\tget_theme\t: function () { return this.data.themes.theme; },\n\n\t\t\tshow_dots\t: function () { this.data.themes.dots = true; this.get_container().children(\"ul\").removeClass(\"jstree-no-dots\"); },\n\t\t\thide_dots\t: function () { this.data.themes.dots = false; this.get_container().children(\"ul\").addClass(\"jstree-no-dots\"); },\n\t\t\ttoggle_dots\t: function () { if(this.data.themes.dots) { this.hide_dots(); } else { this.show_dots(); } },\n\n\t\t\tshow_icons\t: function () { this.data.themes.icons = true; this.get_container().children(\"ul\").removeClass(\"jstree-no-icons\"); },\n\t\t\thide_icons\t: function () { this.data.themes.icons = false; this.get_container().children(\"ul\").addClass(\"jstree-no-icons\"); },\n\t\t\ttoggle_icons: function () { if(this.data.themes.icons) { this.hide_icons(); } else { this.show_icons(); } }\n\t\t}\n\t});\n\t// autodetect themes path\n\t$(function () {\n\t\tif($.jstree._themes === false) {\n\t\t\t$(\"script\").each(function () {\n\t\t\t\tif(this.src.toString().match(/jquery\\.jstree[^\\/]*?\\.js(\\?.*)?$/)) {\n\t\t\t\t\t$.jstree._themes = this.src.toString().replace(/jquery\\.jstree[^\\/]*?\\.js(\\?.*)?$/, \"\") + 'themes/';\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t\tif($.jstree._themes === false) { $.jstree._themes = \"themes/\"; }\n\t});\n\t// include the themes plugin by default\n\t$.jstree.defaults.plugins.push(\"themes\");\n})(jQuery);\n//*/\n\n/*\n * jsTree hotkeys plugin\n * Enables keyboard navigation for all tree instances\n * Depends on the jstree ui & jquery hotkeys plugins\n */\n(function ($) {\n\tvar bound = [];\n\tfunction exec(i, event) {\n\t\tvar f = $.jstree._focused(), tmp;\n\t\tif(f && f.data && f.data.hotkeys && f.data.hotkeys.enabled) {\n\t\t\ttmp = f._get_settings().hotkeys[i];\n\t\t\tif(tmp) { return tmp.call(f, event); }\n\t\t}\n\t}\n\t$.jstree.plugin(\"hotkeys\", {\n\t\t__init : function () {\n\t\t\tif(typeof $.hotkeys === \"undefined\") { throw \"jsTree hotkeys: jQuery hotkeys plugin not included.\"; }\n\t\t\tif(!this.data.ui) { throw \"jsTree hotkeys: jsTree UI plugin not included.\"; }\n\t\t\t$.each(this._get_settings().hotkeys, function (i, v) {\n\t\t\t\tif(v !== false && $.inArray(i, bound) == -1) {\n\t\t\t\t\t$(document).bind(\"keydown\", i, function (event) { return exec(i, event); });\n\t\t\t\t\tbound.push(i);\n\t\t\t\t}\n\t\t\t});\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"lock.jstree\", $.proxy(function () {\n\t\t\t\t\t\tif(this.data.hotkeys.enabled) { this.data.hotkeys.enabled = false; this.data.hotkeys.revert = true; }\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"unlock.jstree\", $.proxy(function () {\n\t\t\t\t\t\tif(this.data.hotkeys.revert) { this.data.hotkeys.enabled = true; }\n\t\t\t\t\t}, this));\n\t\t\tthis.enable_hotkeys();\n\t\t},\n\t\tdefaults : {\n\t\t\t\"up\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_prev(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"ctrl+up\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_prev(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"shift+up\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_prev(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"down\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_next(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"ctrl+down\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_next(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"shift+down\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n\t\t\t\tthis.hover_node(this._get_next(o));\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"left\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o) {\n\t\t\t\t\tif(o.hasClass(\"jstree-open\")) { this.close_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_prev(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"ctrl+left\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o) {\n\t\t\t\t\tif(o.hasClass(\"jstree-open\")) { this.close_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_prev(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"shift+left\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o) {\n\t\t\t\t\tif(o.hasClass(\"jstree-open\")) { this.close_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_prev(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"right\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o && o.length) {\n\t\t\t\t\tif(o.hasClass(\"jstree-closed\")) { this.open_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_next(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"ctrl+right\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o && o.length) {\n\t\t\t\t\tif(o.hasClass(\"jstree-closed\")) { this.open_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_next(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"shift+right\" : function () {\n\t\t\t\tvar o = this.data.ui.hovered || this.data.ui.last_selected;\n\t\t\t\tif(o && o.length) {\n\t\t\t\t\tif(o.hasClass(\"jstree-closed\")) { this.open_node(o); }\n\t\t\t\t\telse { this.hover_node(this._get_next(o)); }\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"space\" : function () {\n\t\t\t\tif(this.data.ui.hovered) { this.data.ui.hovered.children(\"a:eq(0)\").click(); }\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"ctrl+space\" : function (event) {\n\t\t\t\tevent.type = \"click\";\n\t\t\t\tif(this.data.ui.hovered) { this.data.ui.hovered.children(\"a:eq(0)\").trigger(event); }\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"shift+space\" : function (event) {\n\t\t\t\tevent.type = \"click\";\n\t\t\t\tif(this.data.ui.hovered) { this.data.ui.hovered.children(\"a:eq(0)\").trigger(event); }\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\t\"f2\" : function () { this.rename(this.data.ui.hovered || this.data.ui.last_selected); },\n\t\t\t\"del\" : function () { this.remove(this.data.ui.hovered || this._get_node(null)); }\n\t\t},\n\t\t_fn : {\n\t\t\tenable_hotkeys : function () {\n\t\t\t\tthis.data.hotkeys.enabled = true;\n\t\t\t},\n\t\t\tdisable_hotkeys : function () {\n\t\t\t\tthis.data.hotkeys.enabled = false;\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree JSON plugin\n * The JSON data store. Datastores are build by overriding the `load_node` and `_is_loaded` functions.\n */\n(function ($) {\n\t$.jstree.plugin(\"json_data\", {\n\t\t__init : function() {\n\t\t\tvar s = this._get_settings().json_data;\n\t\t\tif(s.progressive_unload) {\n\t\t\t\tthis.get_container().bind(\"after_close.jstree\", function (e, data) {\n\t\t\t\t\tdata.rslt.obj.children(\"ul\").remove();\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t\t// `data` can be a function:\n\t\t\t//  * accepts two arguments - node being loaded and a callback to pass the result to\n\t\t\t//  * will be executed in the current tree's scope & ajax won't be supported\n\t\t\tdata : false,\n\t\t\tajax : false,\n\t\t\tcorrect_state : true,\n\t\t\tprogressive_render : false,\n\t\t\tprogressive_unload : false\n\t\t},\n\t\t_fn : {\n\t\t\tload_node : function (obj, s_call, e_call) { var _this = this; this.load_node_json(obj, function () { _this.__callback({ \"obj\" : _this._get_node(obj) }); s_call.call(this); }, e_call); },\n\t\t\t_is_loaded : function (obj) {\n\t\t\t\tvar s = this._get_settings().json_data;\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\treturn obj == -1 || !obj || (!s.ajax && !s.progressive_render && !$.isFunction(s.data)) || obj.is(\".jstree-open, .jstree-leaf\") || obj.children(\"ul\").children(\"li\").length > 0;\n\t\t\t},\n\t\t\trefresh : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar s = this._get_settings().json_data;\n\t\t\t\tif(obj && obj !== -1 && s.progressive_unload && ($.isFunction(s.data) || !!s.ajax)) {\n\t\t\t\t\tobj.removeData(\"jstree_children\");\n\t\t\t\t}\n\t\t\t\treturn this.__call_old();\n\t\t\t},\n\t\t\tload_node_json : function (obj, s_call, e_call) {\n\t\t\t\tvar s = this.get_settings().json_data, d,\n\t\t\t\t\terror_func = function () {},\n\t\t\t\t\tsuccess_func = function () {};\n\t\t\t\tobj = this._get_node(obj);\n\n\t\t\t\tif(obj && obj !== -1 && (s.progressive_render || s.progressive_unload) && !obj.is(\".jstree-open, .jstree-leaf\") && obj.children(\"ul\").children(\"li\").length === 0 && obj.data(\"jstree_children\")) {\n\t\t\t\t\td = this._parse_json(obj.data(\"jstree_children\"), obj);\n\t\t\t\t\tif(d) {\n\t\t\t\t\t\tobj.append(d);\n\t\t\t\t\t\tif(!s.progressive_unload) { obj.removeData(\"jstree_children\"); }\n\t\t\t\t\t}\n\t\t\t\t\tthis.clean_node(obj);\n\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\tif(obj.data(\"jstree_is_loading\")) { return; }\n\t\t\t\t\telse { obj.data(\"jstree_is_loading\",true); }\n\t\t\t\t}\n\t\t\t\tswitch(!0) {\n\t\t\t\t\tcase (!s.data && !s.ajax): throw \"Neither data nor ajax settings supplied.\";\n\t\t\t\t\t// function option added here for easier model integration (also supporting async - see callback)\n\t\t\t\t\tcase ($.isFunction(s.data)):\n\t\t\t\t\t\ts.data.call(this, obj, $.proxy(function (d) {\n\t\t\t\t\t\t\td = this._parse_json(d, obj);\n\t\t\t\t\t\t\tif(!d) {\n\t\t\t\t\t\t\t\tif(obj === -1 || !obj) {\n\t\t\t\t\t\t\t\t\tif(s.correct_state) { this.get_container().children(\"ul\").empty(); }\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\tif(s.correct_state) { this.correct_state(obj); }\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif(e_call) { e_call.call(this); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(obj === -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()); }\n\t\t\t\t\t\t\t\telse { obj.append(d).children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\tthis.clean_node(obj);\n\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, this));\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!!s.data && !s.ajax) || (!!s.data && !!s.ajax && (!obj || obj === -1)):\n\t\t\t\t\t\tif(!obj || obj == -1) {\n\t\t\t\t\t\t\td = this._parse_json(s.data, obj);\n\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty().append(d.children());\n\t\t\t\t\t\t\t\tthis.clean_node();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(s.correct_state) { this.get_container().children(\"ul\").empty(); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!s.data && !!s.ajax) || (!!s.data && !!s.ajax && obj && obj !== -1):\n\t\t\t\t\t\terror_func = function (x, t, e) {\n\t\t\t\t\t\t\tvar ef = this.get_settings().json_data.ajax.error;\n\t\t\t\t\t\t\tif(ef) { ef.call(this, x, t, e); }\n\t\t\t\t\t\t\tif(obj != -1 && obj.length) {\n\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.correct_state(obj); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.get_container().children(\"ul\").empty(); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(e_call) { e_call.call(this); }\n\t\t\t\t\t\t};\n\t\t\t\t\t\tsuccess_func = function (d, t, x) {\n\t\t\t\t\t\t\tvar sf = this.get_settings().json_data.ajax.success;\n\t\t\t\t\t\t\tif(sf) { d = sf.call(this,d,t,x) || d; }\n\t\t\t\t\t\t\tif(d === \"\" || (d && d.toString && d.toString().replace(/^[\\s\\n]+$/,\"\") === \"\") || (!$.isArray(d) && !$.isPlainObject(d))) {\n\t\t\t\t\t\t\t\treturn error_func.call(this, x, t, \"\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\td = this._parse_json(d, obj);\n\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\tif(obj === -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()); }\n\t\t\t\t\t\t\t\telse { obj.append(d).children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\tthis.clean_node(obj);\n\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(obj === -1 || !obj) {\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.correct_state(obj);\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\t\t\t\t\t\ts.ajax.context = this;\n\t\t\t\t\t\ts.ajax.error = error_func;\n\t\t\t\t\t\ts.ajax.success = success_func;\n\t\t\t\t\t\tif(!s.ajax.dataType) { s.ajax.dataType = \"json\"; }\n\t\t\t\t\t\tif($.isFunction(s.ajax.url)) { s.ajax.url = s.ajax.url.call(this, obj); }\n\t\t\t\t\t\tif($.isFunction(s.ajax.data)) { s.ajax.data = s.ajax.data.call(this, obj); }\n\t\t\t\t\t\t$.ajax(s.ajax);\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t},\n\t\t\t_parse_json : function (js, obj, is_callback) {\n\t\t\t\tvar d = false,\n\t\t\t\t\tp = this._get_settings(),\n\t\t\t\t\ts = p.json_data,\n\t\t\t\t\tt = p.core.html_titles,\n\t\t\t\t\ttmp, i, j, ul1, ul2;\n\n\t\t\t\tif(!js) { return d; }\n\t\t\t\tif(s.progressive_unload && obj && obj !== -1) {\n\t\t\t\t\tobj.data(\"jstree_children\", d);\n\t\t\t\t}\n\t\t\t\tif($.isArray(js)) {\n\t\t\t\t\td = $();\n\t\t\t\t\tif(!js.length) { return false; }\n\t\t\t\t\tfor(i = 0, j = js.length; i < j; i++) {\n\t\t\t\t\t\ttmp = this._parse_json(js[i], obj, true);\n\t\t\t\t\t\tif(tmp.length) { d = d.add(tmp); }\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(typeof js == \"string\") { js = { data : js }; }\n\t\t\t\t\tif(!js.data && js.data !== \"\") { return d; }\n\t\t\t\t\td = $(\"<li />\");\n\t\t\t\t\tif(js.attr) { d.attr(js.attr); }\n\t\t\t\t\tif(js.metadata) { d.data(js.metadata); }\n\t\t\t\t\tif(js.state) { d.addClass(\"jstree-\" + js.state); }\n\t\t\t\t\tif(!$.isArray(js.data)) { tmp = js.data; js.data = []; js.data.push(tmp); }\n\t\t\t\t\t$.each(js.data, function (i, m) {\n\t\t\t\t\t\ttmp = $(\"<a />\");\n\t\t\t\t\t\tif($.isFunction(m)) { m = m.call(this, js); }\n\t\t\t\t\t\tif(typeof m == \"string\") { tmp.attr('href','#')[ t ? \"html\" : \"text\" ](m); }\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif(!m.attr) { m.attr = {}; }\n\t\t\t\t\t\t\tif(!m.attr.href) { m.attr.href = '#'; }\n\t\t\t\t\t\t\ttmp.attr(m.attr)[ t ? \"html\" : \"text\" ](m.title);\n\t\t\t\t\t\t\tif(m.language) { tmp.addClass(m.language); }\n\t\t\t\t\t\t}\n\t\t\t\t\t\ttmp.prepend(\"<ins class='jstree-icon'>&#160;</ins>\");\n\t\t\t\t\t\tif(!m.icon && js.icon) { m.icon = js.icon; }\n\t\t\t\t\t\tif(m.icon) {\n\t\t\t\t\t\t\tif(m.icon.indexOf(\"/\") === -1) { tmp.children(\"ins\").addClass(m.icon); }\n\t\t\t\t\t\t\telse { tmp.children(\"ins\").css(\"background\",\"url('\" + m.icon + \"') center center no-repeat\"); }\n\t\t\t\t\t\t}\n\t\t\t\t\t\td.append(tmp);\n\t\t\t\t\t});\n\t\t\t\t\td.prepend(\"<ins class='jstree-icon'>&#160;</ins>\");\n\t\t\t\t\tif(js.children) {\n\t\t\t\t\t\tif(s.progressive_render && js.state !== \"open\") {\n\t\t\t\t\t\t\td.addClass(\"jstree-closed\").data(\"jstree_children\", js.children);\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif(s.progressive_unload) { d.data(\"jstree_children\", js.children); }\n\t\t\t\t\t\t\tif($.isArray(js.children) && js.children.length) {\n\t\t\t\t\t\t\t\ttmp = this._parse_json(js.children, obj, true);\n\t\t\t\t\t\t\t\tif(tmp.length) {\n\t\t\t\t\t\t\t\t\tul2 = $(\"<ul />\");\n\t\t\t\t\t\t\t\t\tul2.append(tmp);\n\t\t\t\t\t\t\t\t\td.append(ul2);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(!is_callback) {\n\t\t\t\t\tul1 = $(\"<ul />\");\n\t\t\t\t\tul1.append(d);\n\t\t\t\t\td = ul1;\n\t\t\t\t}\n\t\t\t\treturn d;\n\t\t\t},\n\t\t\tget_json : function (obj, li_attr, a_attr, is_callback) {\n\t\t\t\tvar result = [],\n\t\t\t\t\ts = this._get_settings(),\n\t\t\t\t\t_this = this,\n\t\t\t\t\ttmp1, tmp2, li, a, t, lang;\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj || obj === -1) { obj = this.get_container().find(\"> ul > li\"); }\n\t\t\t\tli_attr = $.isArray(li_attr) ? li_attr : [ \"id\", \"class\" ];\n\t\t\t\tif(!is_callback && this.data.types) { li_attr.push(s.types.type_attr); }\n\t\t\t\ta_attr = $.isArray(a_attr) ? a_attr : [ ];\n\n\t\t\t\tobj.each(function () {\n\t\t\t\t\tli = $(this);\n\t\t\t\t\ttmp1 = { data : [] };\n\t\t\t\t\tif(li_attr.length) { tmp1.attr = { }; }\n\t\t\t\t\t$.each(li_attr, function (i, v) {\n\t\t\t\t\t\ttmp2 = li.attr(v);\n\t\t\t\t\t\tif(tmp2 && tmp2.length && tmp2.replace(/jstree[^ ]*/ig,'').length) {\n\t\t\t\t\t\t\ttmp1.attr[v] = (\" \" + tmp2).replace(/ jstree[^ ]*/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\");\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tif(li.hasClass(\"jstree-open\")) { tmp1.state = \"open\"; }\n\t\t\t\t\tif(li.hasClass(\"jstree-closed\")) { tmp1.state = \"closed\"; }\n\t\t\t\t\tif(li.data()) { tmp1.metadata = li.data(); }\n\t\t\t\t\ta = li.children(\"a\");\n\t\t\t\t\ta.each(function () {\n\t\t\t\t\t\tt = $(this);\n\t\t\t\t\t\tif(\n\t\t\t\t\t\t\ta_attr.length ||\n\t\t\t\t\t\t\t$.inArray(\"languages\", s.plugins) !== -1 ||\n\t\t\t\t\t\t\tt.children(\"ins\").get(0).style.backgroundImage.length ||\n\t\t\t\t\t\t\t(t.children(\"ins\").get(0).className && t.children(\"ins\").get(0).className.replace(/jstree[^ ]*|$/ig,'').length)\n\t\t\t\t\t\t) {\n\t\t\t\t\t\t\tlang = false;\n\t\t\t\t\t\t\tif($.inArray(\"languages\", s.plugins) !== -1 && $.isArray(s.languages) && s.languages.length) {\n\t\t\t\t\t\t\t\t$.each(s.languages, function (l, lv) {\n\t\t\t\t\t\t\t\t\tif(t.hasClass(lv)) {\n\t\t\t\t\t\t\t\t\t\tlang = lv;\n\t\t\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\ttmp2 = { attr : { }, title : _this.get_text(t, lang) };\n\t\t\t\t\t\t\t$.each(a_attr, function (k, z) {\n\t\t\t\t\t\t\t\ttmp2.attr[z] = (\" \" + (t.attr(z) || \"\")).replace(/ jstree[^ ]*/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\");\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\tif($.inArray(\"languages\", s.plugins) !== -1 && $.isArray(s.languages) && s.languages.length) {\n\t\t\t\t\t\t\t\t$.each(s.languages, function (k, z) {\n\t\t\t\t\t\t\t\t\tif(t.hasClass(z)) { tmp2.language = z; return true; }\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(t.children(\"ins\").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/^\\s+$/ig,\"\").length) {\n\t\t\t\t\t\t\t\ttmp2.icon = t.children(\"ins\").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(t.children(\"ins\").get(0).style.backgroundImage.length) {\n\t\t\t\t\t\t\t\ttmp2.icon = t.children(\"ins\").get(0).style.backgroundImage.replace(\"url(\",\"\").replace(\")\",\"\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\ttmp2 = _this.get_text(t);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(a.length > 1) { tmp1.data.push(tmp2); }\n\t\t\t\t\t\telse { tmp1.data = tmp2; }\n\t\t\t\t\t});\n\t\t\t\t\tli = li.find(\"> ul > li\");\n\t\t\t\t\tif(li.length) { tmp1.children = _this.get_json(li, li_attr, a_attr, true); }\n\t\t\t\t\tresult.push(tmp1);\n\t\t\t\t});\n\t\t\t\treturn result;\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree languages plugin\n * Adds support for multiple language versions in one tree\n * This basically allows for many titles coexisting in one node, but only one of them being visible at any given time\n * This is useful for maintaining the same structure in many languages (hence the name of the plugin)\n */\n(function ($) {\n\t$.jstree.plugin(\"languages\", {\n\t\t__init : function () { this._load_css();  },\n\t\tdefaults : [],\n\t\t_fn : {\n\t\t\tset_lang : function (i) {\n\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\tst = false,\n\t\t\t\t\tselector = \".jstree-\" + this.get_index() + ' a';\n\t\t\t\tif(!$.isArray(langs) || langs.length === 0) { return false; }\n\t\t\t\tif($.inArray(i,langs) == -1) {\n\t\t\t\t\tif(!!langs[i]) { i = langs[i]; }\n\t\t\t\t\telse { return false; }\n\t\t\t\t}\n\t\t\t\tif(i == this.data.languages.current_language) { return true; }\n\t\t\t\tst = $.vakata.css.get_css(selector + \".\" + this.data.languages.current_language, false, this.data.languages.language_css);\n\t\t\t\tif(st !== false) { st.style.display = \"none\"; }\n\t\t\t\tst = $.vakata.css.get_css(selector + \".\" + i, false, this.data.languages.language_css);\n\t\t\t\tif(st !== false) { st.style.display = \"\"; }\n\t\t\t\tthis.data.languages.current_language = i;\n\t\t\t\tthis.__callback(i);\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\tget_lang : function () {\n\t\t\t\treturn this.data.languages.current_language;\n\t\t\t},\n\t\t\t_get_string : function (key, lang) {\n\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\ts = this._get_settings().core.strings;\n\t\t\t\tif($.isArray(langs) && langs.length) {\n\t\t\t\t\tlang = (lang && $.inArray(lang,langs) != -1) ? lang : this.data.languages.current_language;\n\t\t\t\t}\n\t\t\t\tif(s[lang] && s[lang][key]) { return s[lang][key]; }\n\t\t\t\tif(s[key]) { return s[key]; }\n\t\t\t\treturn key;\n\t\t\t},\n\t\t\tget_text : function (obj, lang) {\n\t\t\t\tobj = this._get_node(obj) || this.data.ui.last_selected;\n\t\t\t\tif(!obj.size()) { return false; }\n\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\ts = this._get_settings().core.html_titles;\n\t\t\t\tif($.isArray(langs) && langs.length) {\n\t\t\t\t\tlang = (lang && $.inArray(lang,langs) != -1) ? lang : this.data.languages.current_language;\n\t\t\t\t\tobj = obj.children(\"a.\" + lang);\n\t\t\t\t}\n\t\t\t\telse { obj = obj.children(\"a:eq(0)\"); }\n\t\t\t\tif(s) {\n\t\t\t\t\tobj = obj.clone();\n\t\t\t\t\tobj.children(\"INS\").remove();\n\t\t\t\t\treturn obj.html();\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tobj = obj.contents().filter(function() { return this.nodeType == 3; })[0];\n\t\t\t\t\treturn obj.nodeValue;\n\t\t\t\t}\n\t\t\t},\n\t\t\tset_text : function (obj, val, lang) {\n\t\t\t\tobj = this._get_node(obj) || this.data.ui.last_selected;\n\t\t\t\tif(!obj.size()) { return false; }\n\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\ts = this._get_settings().core.html_titles,\n\t\t\t\t\ttmp;\n\t\t\t\tif($.isArray(langs) && langs.length) {\n\t\t\t\t\tlang = (lang && $.inArray(lang,langs) != -1) ? lang : this.data.languages.current_language;\n\t\t\t\t\tobj = obj.children(\"a.\" + lang);\n\t\t\t\t}\n\t\t\t\telse { obj = obj.children(\"a:eq(0)\"); }\n\t\t\t\tif(s) {\n\t\t\t\t\ttmp = obj.children(\"INS\").clone();\n\t\t\t\t\tobj.html(val).prepend(tmp);\n\t\t\t\t\tthis.__callback({ \"obj\" : obj, \"name\" : val, \"lang\" : lang });\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tobj = obj.contents().filter(function() { return this.nodeType == 3; })[0];\n\t\t\t\t\tthis.__callback({ \"obj\" : obj, \"name\" : val, \"lang\" : lang });\n\t\t\t\t\treturn (obj.nodeValue = val);\n\t\t\t\t}\n\t\t\t},\n\t\t\t_load_css : function () {\n\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\tstr = \"/* languages css */\",\n\t\t\t\t\tselector = \".jstree-\" + this.get_index() + ' a',\n\t\t\t\t\tln;\n\t\t\t\tif($.isArray(langs) && langs.length) {\n\t\t\t\t\tthis.data.languages.current_language = langs[0];\n\t\t\t\t\tfor(ln = 0; ln < langs.length; ln++) {\n\t\t\t\t\t\tstr += selector + \".\" + langs[ln] + \" {\";\n\t\t\t\t\t\tif(langs[ln] != this.data.languages.current_language) { str += \" display:none; \"; }\n\t\t\t\t\t\tstr += \" } \";\n\t\t\t\t\t}\n\t\t\t\t\tthis.data.languages.language_css = $.vakata.css.add_sheet({ 'str' : str, 'title' : \"jstree-languages\" });\n\t\t\t\t}\n\t\t\t},\n\t\t\tcreate_node : function (obj, position, js, callback) {\n\t\t\t\tvar t = this.__call_old(true, obj, position, js, function (t) {\n\t\t\t\t\tvar langs = this._get_settings().languages,\n\t\t\t\t\t\ta = t.children(\"a\"),\n\t\t\t\t\t\tln;\n\t\t\t\t\tif($.isArray(langs) && langs.length) {\n\t\t\t\t\t\tfor(ln = 0; ln < langs.length; ln++) {\n\t\t\t\t\t\t\tif(!a.is(\".\" + langs[ln])) {\n\t\t\t\t\t\t\t\tt.append(a.eq(0).clone().removeClass(langs.join(\" \")).addClass(langs[ln]));\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\ta.not(\".\" + langs.join(\", .\")).remove();\n\t\t\t\t\t}\n\t\t\t\t\tif(callback) { callback.call(this, t); }\n\t\t\t\t});\n\t\t\t\treturn t;\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree cookies plugin\n * Stores the currently opened/selected nodes in a cookie and then restores them\n * Depends on the jquery.cookie plugin\n */\n(function ($) {\n\t$.jstree.plugin(\"cookies\", {\n\t\t__init : function () {\n\t\t\tif(typeof $.cookie === \"undefined\") { throw \"jsTree cookie: jQuery cookie plugin not included.\"; }\n\n\t\t\tvar s = this._get_settings().cookies,\n\t\t\t\ttmp;\n\t\t\tif(!!s.save_loaded) {\n\t\t\t\ttmp = $.cookie(s.save_loaded);\n\t\t\t\tif(tmp && tmp.length) { this.data.core.to_load = tmp.split(\",\"); }\n\t\t\t}\n\t\t\tif(!!s.save_opened) {\n\t\t\t\ttmp = $.cookie(s.save_opened);\n\t\t\t\tif(tmp && tmp.length) { this.data.core.to_open = tmp.split(\",\"); }\n\t\t\t}\n\t\t\tif(!!s.save_selected) {\n\t\t\t\ttmp = $.cookie(s.save_selected);\n\t\t\t\tif(tmp && tmp.length && this.data.ui) { this.data.ui.to_select = tmp.split(\",\"); }\n\t\t\t}\n\t\t\tthis.get_container()\n\t\t\t\t.one( ( this.data.ui ? \"reselect\" : \"reopen\" ) + \".jstree\", $.proxy(function () {\n\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t.bind(\"open_node.jstree close_node.jstree select_node.jstree deselect_node.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\t\t\tif(this._get_settings().cookies.auto_save) { this.save_cookie((e.handleObj.namespace + e.handleObj.type).replace(\"jstree\",\"\")); }\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\tsave_loaded\t\t: \"jstree_load\",\n\t\t\tsave_opened\t\t: \"jstree_open\",\n\t\t\tsave_selected\t: \"jstree_select\",\n\t\t\tauto_save\t\t: true,\n\t\t\tcookie_options\t: {}\n\t\t},\n\t\t_fn : {\n\t\t\tsave_cookie : function (c) {\n\t\t\t\tif(this.data.core.refreshing) { return; }\n\t\t\t\tvar s = this._get_settings().cookies;\n\t\t\t\tif(!c) { // if called manually and not by event\n\t\t\t\t\tif(s.save_loaded) {\n\t\t\t\t\t\tthis.save_loaded();\n\t\t\t\t\t\t$.cookie(s.save_loaded, this.data.core.to_load.join(\",\"), s.cookie_options);\n\t\t\t\t\t}\n\t\t\t\t\tif(s.save_opened) {\n\t\t\t\t\t\tthis.save_opened();\n\t\t\t\t\t\t$.cookie(s.save_opened, this.data.core.to_open.join(\",\"), s.cookie_options);\n\t\t\t\t\t}\n\t\t\t\t\tif(s.save_selected && this.data.ui) {\n\t\t\t\t\t\tthis.save_selected();\n\t\t\t\t\t\t$.cookie(s.save_selected, this.data.ui.to_select.join(\",\"), s.cookie_options);\n\t\t\t\t\t}\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tswitch(c) {\n\t\t\t\t\tcase \"open_node\":\n\t\t\t\t\tcase \"close_node\":\n\t\t\t\t\t\tif(!!s.save_opened) {\n\t\t\t\t\t\t\tthis.save_opened();\n\t\t\t\t\t\t\t$.cookie(s.save_opened, this.data.core.to_open.join(\",\"), s.cookie_options);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(!!s.save_loaded) {\n\t\t\t\t\t\t\tthis.save_loaded();\n\t\t\t\t\t\t\t$.cookie(s.save_loaded, this.data.core.to_load.join(\",\"), s.cookie_options);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"select_node\":\n\t\t\t\t\tcase \"deselect_node\":\n\t\t\t\t\t\tif(!!s.save_selected && this.data.ui) {\n\t\t\t\t\t\t\tthis.save_selected();\n\t\t\t\t\t\t\t$.cookie(s.save_selected, this.data.ui.to_select.join(\",\"), s.cookie_options);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\t// include cookies by default\n\t// $.jstree.defaults.plugins.push(\"cookies\");\n})(jQuery);\n//*/\n\n/*\n * jsTree sort plugin\n * Sorts items alphabetically (or using any other function)\n */\n(function ($) {\n\t$.jstree.plugin(\"sort\", {\n\t\t__init : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"load_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tvar obj = this._get_node(data.rslt.obj);\n\t\t\t\t\t\tobj = obj === -1 ? this.get_container().children(\"ul\") : obj.children(\"ul\");\n\t\t\t\t\t\tthis.sort(obj);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"rename_node.jstree create_node.jstree create.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis.sort(data.rslt.obj.parent());\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"move_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tvar m = data.rslt.np == -1 ? this.get_container() : data.rslt.np;\n\t\t\t\t\t\tthis.sort(m.children(\"ul\"));\n\t\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : function (a, b) { return this.get_text(a) > this.get_text(b) ? 1 : -1; },\n\t\t_fn : {\n\t\t\tsort : function (obj) {\n\t\t\t\tvar s = this._get_settings().sort,\n\t\t\t\t\tt = this;\n\t\t\t\tobj.append($.makeArray(obj.children(\"li\")).sort($.proxy(s, t)));\n\t\t\t\tobj.find(\"> li > ul\").each(function() { t.sort($(this)); });\n\t\t\t\tthis.clean_node(obj);\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree DND plugin\n * Drag and drop plugin for moving/copying nodes\n */\n(function ($) {\n\tvar o = false,\n\t\tr = false,\n\t\tm = false,\n\t\tml = false,\n\t\tsli = false,\n\t\tsti = false,\n\t\tdir1 = false,\n\t\tdir2 = false,\n\t\tlast_pos = false;\n\t$.vakata.dnd = {\n\t\tis_down : false,\n\t\tis_drag : false,\n\t\thelper : false,\n\t\tscroll_spd : 10,\n\t\tinit_x : 0,\n\t\tinit_y : 0,\n\t\tthreshold : 5,\n\t\thelper_left : 5,\n\t\thelper_top : 10,\n\t\tuser_data : {},\n\n\t\tdrag_start : function (e, data, html) {\n\t\t\tif($.vakata.dnd.is_drag) { $.vakata.drag_stop({}); }\n\t\t\ttry {\n\t\t\t\te.currentTarget.unselectable = \"on\";\n\t\t\t\te.currentTarget.onselectstart = function() { return false; };\n\t\t\t\tif(e.currentTarget.style) { e.currentTarget.style.MozUserSelect = \"none\"; }\n\t\t\t} catch(err) { }\n\t\t\t$.vakata.dnd.init_x = e.pageX;\n\t\t\t$.vakata.dnd.init_y = e.pageY;\n\t\t\t$.vakata.dnd.user_data = data;\n\t\t\t$.vakata.dnd.is_down = true;\n\t\t\t$.vakata.dnd.helper = $(\"<div id='vakata-dragged' />\").html(html); //.fadeTo(10,0.25);\n\t\t\t$(document).bind(\"mousemove\", $.vakata.dnd.drag);\n\t\t\t$(document).bind(\"mouseup\", $.vakata.dnd.drag_stop);\n\t\t\treturn false;\n\t\t},\n\t\tdrag : function (e) {\n\t\t\tif(!$.vakata.dnd.is_down) { return; }\n\t\t\tif(!$.vakata.dnd.is_drag) {\n\t\t\t\tif(Math.abs(e.pageX - $.vakata.dnd.init_x) > 5 || Math.abs(e.pageY - $.vakata.dnd.init_y) > 5) {\n\t\t\t\t\t$.vakata.dnd.helper.appendTo(\"body\");\n\t\t\t\t\t$.vakata.dnd.is_drag = true;\n\t\t\t\t\t$(document).triggerHandler(\"drag_start.vakata\", { \"event\" : e, \"data\" : $.vakata.dnd.user_data });\n\t\t\t\t}\n\t\t\t\telse { return; }\n\t\t\t}\n\n\t\t\t// maybe use a scrolling parent element instead of document?\n\t\t\tif(e.type === \"mousemove\") { // thought of adding scroll in order to move the helper, but mouse poisition is n/a\n\t\t\t\tvar d = $(document), t = d.scrollTop(), l = d.scrollLeft();\n\t\t\t\tif(e.pageY - t < 20) {\n\t\t\t\t\tif(sti && dir1 === \"down\") { clearInterval(sti); sti = false; }\n\t\t\t\t\tif(!sti) { dir1 = \"up\"; sti = setInterval(function () { $(document).scrollTop($(document).scrollTop() - $.vakata.dnd.scroll_spd); }, 150); }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(sti && dir1 === \"up\") { clearInterval(sti); sti = false; }\n\t\t\t\t}\n\t\t\t\tif($(window).height() - (e.pageY - t) < 20) {\n\t\t\t\t\tif(sti && dir1 === \"up\") { clearInterval(sti); sti = false; }\n\t\t\t\t\tif(!sti) { dir1 = \"down\"; sti = setInterval(function () { $(document).scrollTop($(document).scrollTop() + $.vakata.dnd.scroll_spd); }, 150); }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(sti && dir1 === \"down\") { clearInterval(sti); sti = false; }\n\t\t\t\t}\n\n\t\t\t\tif(e.pageX - l < 20) {\n\t\t\t\t\tif(sli && dir2 === \"right\") { clearInterval(sli); sli = false; }\n\t\t\t\t\tif(!sli) { dir2 = \"left\"; sli = setInterval(function () { $(document).scrollLeft($(document).scrollLeft() - $.vakata.dnd.scroll_spd); }, 150); }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(sli && dir2 === \"left\") { clearInterval(sli); sli = false; }\n\t\t\t\t}\n\t\t\t\tif($(window).width() - (e.pageX - l) < 20) {\n\t\t\t\t\tif(sli && dir2 === \"left\") { clearInterval(sli); sli = false; }\n\t\t\t\t\tif(!sli) { dir2 = \"right\"; sli = setInterval(function () { $(document).scrollLeft($(document).scrollLeft() + $.vakata.dnd.scroll_spd); }, 150); }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(sli && dir2 === \"right\") { clearInterval(sli); sli = false; }\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t$.vakata.dnd.helper.css({ left : (e.pageX + $.vakata.dnd.helper_left) + \"px\", top : (e.pageY + $.vakata.dnd.helper_top) + \"px\" });\n\t\t\t$(document).triggerHandler(\"drag.vakata\", { \"event\" : e, \"data\" : $.vakata.dnd.user_data });\n\t\t},\n\t\tdrag_stop : function (e) {\n\t\t\tif(sli) { clearInterval(sli); }\n\t\t\tif(sti) { clearInterval(sti); }\n\t\t\t$(document).unbind(\"mousemove\", $.vakata.dnd.drag);\n\t\t\t$(document).unbind(\"mouseup\", $.vakata.dnd.drag_stop);\n\t\t\t$(document).triggerHandler(\"drag_stop.vakata\", { \"event\" : e, \"data\" : $.vakata.dnd.user_data });\n\t\t\t$.vakata.dnd.helper.remove();\n\t\t\t$.vakata.dnd.init_x = 0;\n\t\t\t$.vakata.dnd.init_y = 0;\n\t\t\t$.vakata.dnd.user_data = {};\n\t\t\t$.vakata.dnd.is_down = false;\n\t\t\t$.vakata.dnd.is_drag = false;\n\t\t}\n\t};\n\t$(function() {\n\t\tvar css_string = '#vakata-dragged { display:block; margin:0 0 0 0; padding:4px 4px 4px 24px; position:absolute; top:-2000px; line-height:16px; z-index:10000; } ';\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"vakata\" });\n\t});\n\n\t$.jstree.plugin(\"dnd\", {\n\t\t__init : function () {\n\t\t\tthis.data.dnd = {\n\t\t\t\tactive : false,\n\t\t\t\tafter : false,\n\t\t\t\tinside : false,\n\t\t\t\tbefore : false,\n\t\t\t\toff : false,\n\t\t\t\tprepared : false,\n\t\t\t\tw : 0,\n\t\t\t\tto1 : false,\n\t\t\t\tto2 : false,\n\t\t\t\tcof : false,\n\t\t\t\tcw : false,\n\t\t\t\tch : false,\n\t\t\t\ti1 : false,\n\t\t\t\ti2 : false,\n\t\t\t\tmto : false\n\t\t\t};\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"mouseenter.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tif(this.data.themes) {\n\t\t\t\t\t\t\t\tm.attr(\"class\", \"jstree-\" + this.data.themes.theme);\n\t\t\t\t\t\t\t\tif(ml) { ml.attr(\"class\", \"jstree-\" + this.data.themes.theme); }\n\t\t\t\t\t\t\t\t$.vakata.dnd.helper.attr(\"class\", \"jstree-dnd-helper jstree-\" + this.data.themes.theme);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t//if($(e.currentTarget).find(\"> ul > li\").length === 0) {\n\t\t\t\t\t\t\tif(e.currentTarget === e.target && $.vakata.dnd.user_data.obj && $($.vakata.dnd.user_data.obj).length && $($.vakata.dnd.user_data.obj).parents(\".jstree:eq(0)\")[0] !== e.target) { // node should not be from the same tree\n\t\t\t\t\t\t\t\tvar tr = $.jstree._reference(e.target), dc;\n\t\t\t\t\t\t\t\tif(tr.data.dnd.foreign) {\n\t\t\t\t\t\t\t\t\tdc = tr._get_settings().dnd.drag_check.call(this, { \"o\" : o, \"r\" : tr.get_container(), is_root : true });\n\t\t\t\t\t\t\t\t\tif(dc === true || dc.inside === true || dc.before === true || dc.after === true) {\n\t\t\t\t\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-ok\");\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\ttr.prepare_move(o, tr.get_container(), \"last\");\n\t\t\t\t\t\t\t\t\tif(tr.check_move()) {\n\t\t\t\t\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-ok\");\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"mouseup.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\t//if($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree && $(e.currentTarget).find(\"> ul > li\").length === 0) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree && e.currentTarget === e.target && $.vakata.dnd.user_data.obj && $($.vakata.dnd.user_data.obj).length && $($.vakata.dnd.user_data.obj).parents(\".jstree:eq(0)\")[0] !== e.target) { // node should not be from the same tree\n\t\t\t\t\t\t\tvar tr = $.jstree._reference(e.currentTarget), dc;\n\t\t\t\t\t\t\tif(tr.data.dnd.foreign) {\n\t\t\t\t\t\t\t\tdc = tr._get_settings().dnd.drag_check.call(this, { \"o\" : o, \"r\" : tr.get_container(), is_root : true });\n\t\t\t\t\t\t\t\tif(dc === true || dc.inside === true || dc.before === true || dc.after === true) {\n\t\t\t\t\t\t\t\t\ttr._get_settings().dnd.drag_finish.call(this, { \"o\" : o, \"r\" : tr.get_container(), is_root : true });\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\ttr.move_node(o, tr.get_container(), \"last\", e[tr._get_settings().dnd.copy_modifier + \"Key\"]);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"mouseleave.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif(e.relatedTarget && e.relatedTarget.id && e.relatedTarget.id === \"jstree-marker-line\") {\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tif(this.data.dnd.i1) { clearInterval(this.data.dnd.i1); }\n\t\t\t\t\t\t\tif(this.data.dnd.i2) { clearInterval(this.data.dnd.i2); }\n\t\t\t\t\t\t\tif(this.data.dnd.to1) { clearTimeout(this.data.dnd.to1); }\n\t\t\t\t\t\t\tif(this.data.dnd.to2) { clearTimeout(this.data.dnd.to2); }\n\t\t\t\t\t\t\tif($.vakata.dnd.helper.children(\"ins\").hasClass(\"jstree-ok\")) {\n\t\t\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-invalid\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"mousemove.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tvar cnt = this.get_container()[0];\n\n\t\t\t\t\t\t\t// Horizontal scroll\n\t\t\t\t\t\t\tif(e.pageX + 24 > this.data.dnd.cof.left + this.data.dnd.cw) {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i1) { clearInterval(this.data.dnd.i1); }\n\t\t\t\t\t\t\t\tthis.data.dnd.i1 = setInterval($.proxy(function () { this.scrollLeft += $.vakata.dnd.scroll_spd; }, cnt), 100);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse if(e.pageX - 24 < this.data.dnd.cof.left) {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i1) { clearInterval(this.data.dnd.i1); }\n\t\t\t\t\t\t\t\tthis.data.dnd.i1 = setInterval($.proxy(function () { this.scrollLeft -= $.vakata.dnd.scroll_spd; }, cnt), 100);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i1) { clearInterval(this.data.dnd.i1); }\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Vertical scroll\n\t\t\t\t\t\t\tif(e.pageY + 24 > this.data.dnd.cof.top + this.data.dnd.ch) {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i2) { clearInterval(this.data.dnd.i2); }\n\t\t\t\t\t\t\t\tthis.data.dnd.i2 = setInterval($.proxy(function () { this.scrollTop += $.vakata.dnd.scroll_spd; }, cnt), 100);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse if(e.pageY - 24 < this.data.dnd.cof.top) {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i2) { clearInterval(this.data.dnd.i2); }\n\t\t\t\t\t\t\t\tthis.data.dnd.i2 = setInterval($.proxy(function () { this.scrollTop -= $.vakata.dnd.scroll_spd; }, cnt), 100);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(this.data.dnd.i2) { clearInterval(this.data.dnd.i2); }\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"scroll.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree && m && ml) {\n\t\t\t\t\t\t\tm.hide();\n\t\t\t\t\t\t\tml.hide();\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mousedown.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif(e.which === 1) {\n\t\t\t\t\t\t\tthis.start_drag(e.currentTarget, e);\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mouseenter.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tthis.dnd_enter(e.currentTarget);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mousemove.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tif(!r || !r.length || r.children(\"a\")[0] !== e.currentTarget) {\n\t\t\t\t\t\t\t\tthis.dnd_enter(e.currentTarget);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(typeof this.data.dnd.off.top === \"undefined\") { this.data.dnd.off = $(e.target).offset(); }\n\t\t\t\t\t\t\tthis.data.dnd.w = (e.pageY - (this.data.dnd.off.top || 0)) % this.data.core.li_height;\n\t\t\t\t\t\t\tif(this.data.dnd.w < 0) { this.data.dnd.w += this.data.core.li_height; }\n\t\t\t\t\t\t\tthis.dnd_show();\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mouseleave.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tif(e.relatedTarget && e.relatedTarget.id && e.relatedTarget.id === \"jstree-marker-line\") {\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif(m) { m.hide(); }\n\t\t\t\t\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t\t\t\t\t/*\n\t\t\t\t\t\t\tvar ec = $(e.currentTarget).closest(\"li\"),\n\t\t\t\t\t\t\t\ter = $(e.relatedTarget).closest(\"li\");\n\t\t\t\t\t\t\tif(er[0] !== ec.prev()[0] && er[0] !== ec.next()[0]) {\n\t\t\t\t\t\t\t\tif(m) { m.hide(); }\n\t\t\t\t\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t*/\n\t\t\t\t\t\t\tthis.data.dnd.mto = setTimeout(\n\t\t\t\t\t\t\t\t(function (t) { return function () { t.dnd_leave(e); }; })(this),\n\t\t\t\t\t\t\t0);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"mouseup.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree) {\n\t\t\t\t\t\t\tthis.dnd_finish(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\n\t\t\t$(document)\n\t\t\t\t.bind(\"drag_stop.vakata\", $.proxy(function () {\n\t\t\t\t\t\tif(this.data.dnd.to1) { clearTimeout(this.data.dnd.to1); }\n\t\t\t\t\t\tif(this.data.dnd.to2) { clearTimeout(this.data.dnd.to2); }\n\t\t\t\t\t\tif(this.data.dnd.i1) { clearInterval(this.data.dnd.i1); }\n\t\t\t\t\t\tif(this.data.dnd.i2) { clearInterval(this.data.dnd.i2); }\n\t\t\t\t\t\tthis.data.dnd.after\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.before\t= false;\n\t\t\t\t\t\tthis.data.dnd.inside\t= false;\n\t\t\t\t\t\tthis.data.dnd.off\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.prepared\t= false;\n\t\t\t\t\t\tthis.data.dnd.w\t\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.to1\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.to2\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.i1\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.i2\t\t= false;\n\t\t\t\t\t\tthis.data.dnd.active\t= false;\n\t\t\t\t\t\tthis.data.dnd.foreign\t= false;\n\t\t\t\t\t\tif(m) { m.css({ \"top\" : \"-2000px\" }); }\n\t\t\t\t\t\tif(ml) { ml.css({ \"top\" : \"-2000px\" }); }\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"drag_start.vakata\", $.proxy(function (e, data) {\n\t\t\t\t\t\tif(data.data.jstree) {\n\t\t\t\t\t\t\tvar et = $(data.event.target);\n\t\t\t\t\t\t\tif(et.closest(\".jstree\").hasClass(\"jstree-\" + this.get_index())) {\n\t\t\t\t\t\t\t\tthis.dnd_enter(et);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t\t\t/*\n\t\t\t\t.bind(\"keydown.jstree-\" + this.get_index() + \" keyup.jstree-\" + this.get_index(), $.proxy(function(e) {\n\t\t\t\t\t\tif($.vakata.dnd.is_drag && $.vakata.dnd.user_data.jstree && !this.data.dnd.foreign) {\n\t\t\t\t\t\t\tvar h = $.vakata.dnd.helper.children(\"ins\");\n\t\t\t\t\t\t\tif(e[this._get_settings().dnd.copy_modifier + \"Key\"] && h.hasClass(\"jstree-ok\")) {\n\t\t\t\t\t\t\t\th.parent().html(h.parent().html().replace(/ \\(Copy\\)$/, \"\") + \" (Copy)\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\th.parent().html(h.parent().html().replace(/ \\(Copy\\)$/, \"\"));\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this)); */\n\n\n\n\t\t\tvar s = this._get_settings().dnd;\n\t\t\tif(s.drag_target) {\n\t\t\t\t$(document)\n\t\t\t\t\t.delegate(s.drag_target, \"mousedown.jstree-\" + this.get_index(), $.proxy(function (e) {\n\t\t\t\t\t\to = e.target;\n\t\t\t\t\t\t$.vakata.dnd.drag_start(e, { jstree : true, obj : e.target }, \"<ins class='jstree-icon'></ins>\" + $(e.target).text() );\n\t\t\t\t\t\tif(this.data.themes) {\n\t\t\t\t\t\t\tif(m) { m.attr(\"class\", \"jstree-\" + this.data.themes.theme); }\n\t\t\t\t\t\t\tif(ml) { ml.attr(\"class\", \"jstree-\" + this.data.themes.theme); }\n\t\t\t\t\t\t\t$.vakata.dnd.helper.attr(\"class\", \"jstree-dnd-helper jstree-\" + this.data.themes.theme);\n\t\t\t\t\t\t}\n\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-invalid\");\n\t\t\t\t\t\tvar cnt = this.get_container();\n\t\t\t\t\t\tthis.data.dnd.cof = cnt.offset();\n\t\t\t\t\t\tthis.data.dnd.cw = parseInt(cnt.width(),10);\n\t\t\t\t\t\tthis.data.dnd.ch = parseInt(cnt.height(),10);\n\t\t\t\t\t\tthis.data.dnd.foreign = true;\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}, this));\n\t\t\t}\n\t\t\tif(s.drop_target) {\n\t\t\t\t$(document)\n\t\t\t\t\t.delegate(s.drop_target, \"mouseenter.jstree-\" + this.get_index(), $.proxy(function (e) {\n\t\t\t\t\t\t\tif(this.data.dnd.active && this._get_settings().dnd.drop_check.call(this, { \"o\" : o, \"r\" : $(e.target), \"e\" : e })) {\n\t\t\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-ok\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, this))\n\t\t\t\t\t.delegate(s.drop_target, \"mouseleave.jstree-\" + this.get_index(), $.proxy(function (e) {\n\t\t\t\t\t\t\tif(this.data.dnd.active) {\n\t\t\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-invalid\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, this))\n\t\t\t\t\t.delegate(s.drop_target, \"mouseup.jstree-\" + this.get_index(), $.proxy(function (e) {\n\t\t\t\t\t\t\tif(this.data.dnd.active && $.vakata.dnd.helper.children(\"ins\").hasClass(\"jstree-ok\")) {\n\t\t\t\t\t\t\t\tthis._get_settings().dnd.drop_finish.call(this, { \"o\" : o, \"r\" : $(e.target), \"e\" : e });\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, this));\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t\tcopy_modifier\t: \"ctrl\",\n\t\t\tcheck_timeout\t: 100,\n\t\t\topen_timeout\t: 500,\n\t\t\tdrop_target\t\t: \".jstree-drop\",\n\t\t\tdrop_check\t\t: function (data) { return true; },\n\t\t\tdrop_finish\t\t: $.noop,\n\t\t\tdrag_target\t\t: \".jstree-draggable\",\n\t\t\tdrag_finish\t\t: $.noop,\n\t\t\tdrag_check\t\t: function (data) { return { after : false, before : false, inside : true }; }\n\t\t},\n\t\t_fn : {\n\t\t\tdnd_prepare : function () {\n\t\t\t\tif(!r || !r.length) { return; }\n\t\t\t\tthis.data.dnd.off = r.offset();\n\t\t\t\tif(this._get_settings().core.rtl) {\n\t\t\t\t\tthis.data.dnd.off.right = this.data.dnd.off.left + r.width();\n\t\t\t\t}\n\t\t\t\tif(this.data.dnd.foreign) {\n\t\t\t\t\tvar a = this._get_settings().dnd.drag_check.call(this, { \"o\" : o, \"r\" : r });\n\t\t\t\t\tthis.data.dnd.after = a.after;\n\t\t\t\t\tthis.data.dnd.before = a.before;\n\t\t\t\t\tthis.data.dnd.inside = a.inside;\n\t\t\t\t\tthis.data.dnd.prepared = true;\n\t\t\t\t\treturn this.dnd_show();\n\t\t\t\t}\n\t\t\t\tthis.prepare_move(o, r, \"before\");\n\t\t\t\tthis.data.dnd.before = this.check_move();\n\t\t\t\tthis.prepare_move(o, r, \"after\");\n\t\t\t\tthis.data.dnd.after = this.check_move();\n\t\t\t\tif(this._is_loaded(r)) {\n\t\t\t\t\tthis.prepare_move(o, r, \"inside\");\n\t\t\t\t\tthis.data.dnd.inside = this.check_move();\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.data.dnd.inside = false;\n\t\t\t\t}\n\t\t\t\tthis.data.dnd.prepared = true;\n\t\t\t\treturn this.dnd_show();\n\t\t\t},\n\t\t\tdnd_show : function () {\n\t\t\t\tif(!this.data.dnd.prepared) { return; }\n\t\t\t\tvar o = [\"before\",\"inside\",\"after\"],\n\t\t\t\t\tr = false,\n\t\t\t\t\trtl = this._get_settings().core.rtl,\n\t\t\t\t\tpos;\n\t\t\t\tif(this.data.dnd.w < this.data.core.li_height/3) { o = [\"before\",\"inside\",\"after\"]; }\n\t\t\t\telse if(this.data.dnd.w <= this.data.core.li_height*2/3) {\n\t\t\t\t\to = this.data.dnd.w < this.data.core.li_height/2 ? [\"inside\",\"before\",\"after\"] : [\"inside\",\"after\",\"before\"];\n\t\t\t\t}\n\t\t\t\telse { o = [\"after\",\"inside\",\"before\"]; }\n\t\t\t\t$.each(o, $.proxy(function (i, val) {\n\t\t\t\t\tif(this.data.dnd[val]) {\n\t\t\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-ok\");\n\t\t\t\t\t\tr = val;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}, this));\n\t\t\t\tif(r === false) { $.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-invalid\"); }\n\n\t\t\t\tpos = rtl ? (this.data.dnd.off.right - 18) : (this.data.dnd.off.left + 10);\n\t\t\t\tswitch(r) {\n\t\t\t\t\tcase \"before\":\n\t\t\t\t\t\tm.css({ \"left\" : pos + \"px\", \"top\" : (this.data.dnd.off.top - 6) + \"px\" }).show();\n\t\t\t\t\t\tif(ml) { ml.css({ \"left\" : (pos + 8) + \"px\", \"top\" : (this.data.dnd.off.top - 1) + \"px\" }).show(); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"after\":\n\t\t\t\t\t\tm.css({ \"left\" : pos + \"px\", \"top\" : (this.data.dnd.off.top + this.data.core.li_height - 6) + \"px\" }).show();\n\t\t\t\t\t\tif(ml) { ml.css({ \"left\" : (pos + 8) + \"px\", \"top\" : (this.data.dnd.off.top + this.data.core.li_height - 1) + \"px\" }).show(); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"inside\":\n\t\t\t\t\t\tm.css({ \"left\" : pos + ( rtl ? -4 : 4) + \"px\", \"top\" : (this.data.dnd.off.top + this.data.core.li_height/2 - 5) + \"px\" }).show();\n\t\t\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tdefault:\n\t\t\t\t\t\tm.hide();\n\t\t\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tlast_pos = r;\n\t\t\t\treturn r;\n\t\t\t},\n\t\t\tdnd_open : function () {\n\t\t\t\tthis.data.dnd.to2 = false;\n\t\t\t\tthis.open_node(r, $.proxy(this.dnd_prepare,this), true);\n\t\t\t},\n\t\t\tdnd_finish : function (e) {\n\t\t\t\tif(this.data.dnd.foreign) {\n\t\t\t\t\tif(this.data.dnd.after || this.data.dnd.before || this.data.dnd.inside) {\n\t\t\t\t\t\tthis._get_settings().dnd.drag_finish.call(this, { \"o\" : o, \"r\" : r, \"p\" : last_pos });\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.dnd_prepare();\n\t\t\t\t\tthis.move_node(o, r, last_pos, e[this._get_settings().dnd.copy_modifier + \"Key\"]);\n\t\t\t\t}\n\t\t\t\to = false;\n\t\t\t\tr = false;\n\t\t\t\tm.hide();\n\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t},\n\t\t\tdnd_enter : function (obj) {\n\t\t\t\tif(this.data.dnd.mto) {\n\t\t\t\t\tclearTimeout(this.data.dnd.mto);\n\t\t\t\t\tthis.data.dnd.mto = false;\n\t\t\t\t}\n\t\t\t\tvar s = this._get_settings().dnd;\n\t\t\t\tthis.data.dnd.prepared = false;\n\t\t\t\tr = this._get_node(obj);\n\t\t\t\tif(s.check_timeout) {\n\t\t\t\t\t// do the calculations after a minimal timeout (users tend to drag quickly to the desired location)\n\t\t\t\t\tif(this.data.dnd.to1) { clearTimeout(this.data.dnd.to1); }\n\t\t\t\t\tthis.data.dnd.to1 = setTimeout($.proxy(this.dnd_prepare, this), s.check_timeout);\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.dnd_prepare();\n\t\t\t\t}\n\t\t\t\tif(s.open_timeout) {\n\t\t\t\t\tif(this.data.dnd.to2) { clearTimeout(this.data.dnd.to2); }\n\t\t\t\t\tif(r && r.length && r.hasClass(\"jstree-closed\")) {\n\t\t\t\t\t\t// if the node is closed - open it, then recalculate\n\t\t\t\t\t\tthis.data.dnd.to2 = setTimeout($.proxy(this.dnd_open, this), s.open_timeout);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(r && r.length && r.hasClass(\"jstree-closed\")) {\n\t\t\t\t\t\tthis.dnd_open();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\tdnd_leave : function (e) {\n\t\t\t\tthis.data.dnd.after\t\t= false;\n\t\t\t\tthis.data.dnd.before\t= false;\n\t\t\t\tthis.data.dnd.inside\t= false;\n\t\t\t\t$.vakata.dnd.helper.children(\"ins\").attr(\"class\",\"jstree-invalid\");\n\t\t\t\tm.hide();\n\t\t\t\tif(ml) { ml.hide(); }\n\t\t\t\tif(r && r[0] === e.target.parentNode) {\n\t\t\t\t\tif(this.data.dnd.to1) {\n\t\t\t\t\t\tclearTimeout(this.data.dnd.to1);\n\t\t\t\t\t\tthis.data.dnd.to1 = false;\n\t\t\t\t\t}\n\t\t\t\t\tif(this.data.dnd.to2) {\n\t\t\t\t\t\tclearTimeout(this.data.dnd.to2);\n\t\t\t\t\t\tthis.data.dnd.to2 = false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\tstart_drag : function (obj, e) {\n\t\t\t\to = this._get_node(obj);\n\t\t\t\tif(this.data.ui && this.is_selected(o)) { o = this._get_node(null, true); }\n\t\t\t\tvar dt = o.length > 1 ? this._get_string(\"multiple_selection\") : this.get_text(o),\n\t\t\t\t\tcnt = this.get_container();\n\t\t\t\tif(!this._get_settings().core.html_titles) { dt = dt.replace(/</ig,\"&lt;\").replace(/>/ig,\"&gt;\"); }\n\t\t\t\t$.vakata.dnd.drag_start(e, { jstree : true, obj : o }, \"<ins class='jstree-icon'></ins>\" + dt );\n\t\t\t\tif(this.data.themes) {\n\t\t\t\t\tif(m) { m.attr(\"class\", \"jstree-\" + this.data.themes.theme); }\n\t\t\t\t\tif(ml) { ml.attr(\"class\", \"jstree-\" + this.data.themes.theme); }\n\t\t\t\t\t$.vakata.dnd.helper.attr(\"class\", \"jstree-dnd-helper jstree-\" + this.data.themes.theme);\n\t\t\t\t}\n\t\t\t\tthis.data.dnd.cof = cnt.offset();\n\t\t\t\tthis.data.dnd.cw = parseInt(cnt.width(),10);\n\t\t\t\tthis.data.dnd.ch = parseInt(cnt.height(),10);\n\t\t\t\tthis.data.dnd.active = true;\n\t\t\t}\n\t\t}\n\t});\n\t$(function() {\n\t\tvar css_string = '' +\n\t\t\t'#vakata-dragged ins { display:block; text-decoration:none; width:16px; height:16px; margin:0 0 0 0; padding:0; position:absolute; top:4px; left:4px; ' +\n\t\t\t' -moz-border-radius:4px; border-radius:4px; -webkit-border-radius:4px; ' +\n\t\t\t'} ' +\n\t\t\t'#vakata-dragged .jstree-ok { background:green; } ' +\n\t\t\t'#vakata-dragged .jstree-invalid { background:red; } ' +\n\t\t\t'#jstree-marker { padding:0; margin:0; font-size:12px; overflow:hidden; height:12px; width:8px; position:absolute; top:-30px; z-index:10001; background-repeat:no-repeat; display:none; background-color:transparent; text-shadow:1px 1px 1px white; color:black; line-height:10px; } ' +\n\t\t\t'#jstree-marker-line { padding:0; margin:0; line-height:0%; font-size:1px; overflow:hidden; height:1px; width:100px; position:absolute; top:-30px; z-index:10000; background-repeat:no-repeat; display:none; background-color:#456c43; ' +\n\t\t\t' cursor:pointer; border:1px solid #eeeeee; border-left:0; -moz-box-shadow: 0px 0px 2px #666; -webkit-box-shadow: 0px 0px 2px #666; box-shadow: 0px 0px 2px #666; ' +\n\t\t\t' -moz-border-radius:1px; border-radius:1px; -webkit-border-radius:1px; ' +\n\t\t\t'}' +\n\t\t\t'';\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n\t\tm = $(\"<div />\").attr({ id : \"jstree-marker\" }).hide().html(\"&raquo;\")\n\t\t\t.bind(\"mouseleave mouseenter\", function (e) {\n\t\t\t\tm.hide();\n\t\t\t\tml.hide();\n\t\t\t\te.preventDefault();\n\t\t\t\te.stopImmediatePropagation();\n\t\t\t\treturn false;\n\t\t\t})\n\t\t\t.appendTo(\"body\");\n\t\tml = $(\"<div />\").attr({ id : \"jstree-marker-line\" }).hide()\n\t\t\t.bind(\"mouseup\", function (e) {\n\t\t\t\tif(r && r.length) {\n\t\t\t\t\tr.children(\"a\").trigger(e);\n\t\t\t\t\te.preventDefault();\n\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t})\n\t\t\t.bind(\"mouseleave\", function (e) {\n\t\t\t\tvar rt = $(e.relatedTarget);\n\t\t\t\tif(rt.is(\".jstree\") || rt.closest(\".jstree\").length === 0) {\n\t\t\t\t\tif(r && r.length) {\n\t\t\t\t\t\tr.children(\"a\").trigger(e);\n\t\t\t\t\t\tm.hide();\n\t\t\t\t\t\tml.hide();\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t})\n\t\t\t.appendTo(\"body\");\n\t\t$(document).bind(\"drag_start.vakata\", function (e, data) {\n\t\t\tif(data.data.jstree) { m.show(); if(ml) { ml.show(); } }\n\t\t});\n\t\t$(document).bind(\"drag_stop.vakata\", function (e, data) {\n\t\t\tif(data.data.jstree) { m.hide(); if(ml) { ml.hide(); } }\n\t\t});\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree checkbox plugin\n * Inserts checkboxes in front of every node\n * Depends on the ui plugin\n * DOES NOT WORK NICELY WITH MULTITREE DRAG'N'DROP\n */\n(function ($) {\n\t$.jstree.plugin(\"checkbox\", {\n\t\t__init : function () {\n\t\t\tthis.data.checkbox.noui = this._get_settings().checkbox.override_ui;\n\t\t\tif(this.data.ui && this.data.checkbox.noui) {\n\t\t\t\tthis.select_node = this.deselect_node = this.deselect_all = $.noop;\n\t\t\t\tthis.get_selected = this.get_checked;\n\t\t\t}\n\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"open_node.jstree create_node.jstree clean_node.jstree refresh.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._prepare_checkboxes(data.rslt.obj);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"loaded.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tthis._prepare_checkboxes();\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate( (this.data.ui && this.data.checkbox.noui ? \"a\" : \"ins.jstree-checkbox\") , \"click.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\tif(this._get_node(e.target).hasClass(\"jstree-checked\")) { this.uncheck_node(e.target); }\n\t\t\t\t\t\telse { this.check_node(e.target); }\n\t\t\t\t\t\tif(this.data.ui && this.data.checkbox.noui) {\n\t\t\t\t\t\t\tthis.save_selected();\n\t\t\t\t\t\t\tif(this.data.cookies) { this.save_cookie(\"select_node\"); }\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\toverride_ui : false,\n\t\t\ttwo_state : false,\n\t\t\treal_checkboxes : false,\n\t\t\tchecked_parent_open : true,\n\t\t\treal_checkboxes_names : function (n) { return [ (\"check_\" + (n[0].id || Math.ceil(Math.random() * 10000))) , 1]; }\n\t\t},\n\t\t__destroy : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.find(\"input.jstree-real-checkbox\").removeClass(\"jstree-real-checkbox\").end()\n\t\t\t\t.find(\"ins.jstree-checkbox\").remove();\n\t\t},\n\t\t_fn : {\n\t\t\t_checkbox_notify : function (n, data) {\n\t\t\t\tif(data.checked) {\n\t\t\t\t\tthis.check_node(n, false);\n\t\t\t\t}\n\t\t\t},\n\t\t\t_prepare_checkboxes : function (obj) {\n\t\t\t\tobj = !obj || obj == -1 ? this.get_container().find(\"> ul > li\") : this._get_node(obj);\n\t\t\t\tif(obj === false) { return; } // added for removing root nodes\n\t\t\t\tvar c, _this = this, t, ts = this._get_settings().checkbox.two_state, rc = this._get_settings().checkbox.real_checkboxes, rcn = this._get_settings().checkbox.real_checkboxes_names;\n\t\t\t\tobj.each(function () {\n\t\t\t\t\tt = $(this);\n\t\t\t\t\tc = t.is(\"li\") && (t.hasClass(\"jstree-checked\") || (rc && t.children(\":checked\").length)) ? \"jstree-checked\" : \"jstree-unchecked\";\n\t\t\t\t\tt.find(\"li\").addBack().each(function () {\n\t\t\t\t\t\tvar $t = $(this), nm;\n\t\t\t\t\t\t$t.children(\"a\" + (_this.data.languages ? \"\" : \":eq(0)\") ).not(\":has(.jstree-checkbox)\").prepend(\"<ins class='jstree-checkbox'>&#160;</ins>\").parent().not(\".jstree-checked, .jstree-unchecked\").addClass( ts ? \"jstree-unchecked\" : c );\n\t\t\t\t\t\tif(rc) {\n\t\t\t\t\t\t\tif(!$t.children(\":checkbox\").length) {\n\t\t\t\t\t\t\t\tnm = rcn.call(_this, $t);\n\t\t\t\t\t\t\t\t$t.prepend(\"<input type='checkbox' class='jstree-real-checkbox' id='\" + nm[0] + \"' name='\" + nm[0] + \"' value='\" + nm[1] + \"' />\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t$t.children(\":checkbox\").addClass(\"jstree-real-checkbox\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(!ts) {\n\t\t\t\t\t\t\tif(c === \"jstree-checked\" || $t.hasClass(\"jstree-checked\") || $t.children(':checked').length) {\n\t\t\t\t\t\t\t\t$t.find(\"li\").addBack().addClass(\"jstree-checked\").children(\":checkbox\").prop(\"checked\", true);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif($t.hasClass(\"jstree-checked\") || $t.children(':checked').length) {\n\t\t\t\t\t\t\t\t$t.addClass(\"jstree-checked\").children(\":checkbox\").prop(\"checked\", true);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t\tif(!ts) {\n\t\t\t\t\tobj.find(\".jstree-checked\").parent().parent().each(function () { _this._repair_state(this); });\n\t\t\t\t}\n\t\t\t},\n\t\t\tchange_state : function (obj, state) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar coll = false, rc = this._get_settings().checkbox.real_checkboxes;\n\t\t\t\tif(!obj || obj === -1) { return false; }\n\t\t\t\tstate = (state === false || state === true) ? state : obj.hasClass(\"jstree-checked\");\n\t\t\t\tif(this._get_settings().checkbox.two_state) {\n\t\t\t\t\tif(state) {\n\t\t\t\t\t\tobj.removeClass(\"jstree-checked\").addClass(\"jstree-unchecked\");\n\t\t\t\t\t\tif(rc) { obj.children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t\t}\n\t\t\t\t\telse {\n\t\t\t\t\t\tobj.removeClass(\"jstree-unchecked\").addClass(\"jstree-checked\");\n\t\t\t\t\t\tif(rc) { obj.children(\":checkbox\").prop(\"checked\", true); }\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(state) {\n\t\t\t\t\t\tcoll = obj.find(\"li\").addBack();\n\t\t\t\t\t\tif(!coll.filter(\".jstree-checked, .jstree-undetermined\").length) { return false; }\n\t\t\t\t\t\tcoll.removeClass(\"jstree-checked jstree-undetermined\").addClass(\"jstree-unchecked\");\n\t\t\t\t\t\tif(rc) { coll.children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t\t}\n\t\t\t\t\telse {\n\t\t\t\t\t\tcoll = obj.find(\"li\").addBack();\n\t\t\t\t\t\tif(!coll.filter(\".jstree-unchecked, .jstree-undetermined\").length) { return false; }\n\t\t\t\t\t\tcoll.removeClass(\"jstree-unchecked jstree-undetermined\").addClass(\"jstree-checked\");\n\t\t\t\t\t\tif(rc) { coll.children(\":checkbox\").prop(\"checked\", true); }\n\t\t\t\t\t\tif(this.data.ui) { this.data.ui.last_selected = obj; }\n\t\t\t\t\t\tthis.data.checkbox.last_selected = obj;\n\t\t\t\t\t}\n\t\t\t\t\tobj.parentsUntil(\".jstree\", \"li\").each(function () {\n\t\t\t\t\t\tvar $this = $(this);\n\t\t\t\t\t\tif(state) {\n\t\t\t\t\t\t\tif($this.children(\"ul\").children(\"li.jstree-checked, li.jstree-undetermined\").length) {\n\t\t\t\t\t\t\t\t$this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n\t\t\t\t\t\t\t\tif(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t$this.removeClass(\"jstree-checked jstree-undetermined\").addClass(\"jstree-unchecked\");\n\t\t\t\t\t\t\t\tif(rc) { $this.children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif($this.children(\"ul\").children(\"li.jstree-unchecked, li.jstree-undetermined\").length) {\n\t\t\t\t\t\t\t\t$this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n\t\t\t\t\t\t\t\tif(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t$this.removeClass(\"jstree-unchecked jstree-undetermined\").addClass(\"jstree-checked\");\n\t\t\t\t\t\t\t\tif(rc) { $this.children(\":checkbox\").prop(\"checked\", true); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\tif(this.data.ui && this.data.checkbox.noui) { this.data.ui.selected = this.get_checked(); }\n\t\t\t\tthis.__callback(obj);\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\tcheck_node : function (obj) {\n\t\t\t\tif(this.change_state(obj, false)) {\n\t\t\t\t\tobj = this._get_node(obj);\n\t\t\t\t\tif(this._get_settings().checkbox.checked_parent_open) {\n\t\t\t\t\t\tvar t = this;\n\t\t\t\t\t\tobj.parents(\".jstree-closed\").each(function () { t.open_node(this, false, true); });\n\t\t\t\t\t}\n\t\t\t\t\tthis.__callback({ \"obj\" : obj });\n\t\t\t\t}\n\t\t\t},\n\t\t\tuncheck_node : function (obj) {\n\t\t\t\tif(this.change_state(obj, true)) { this.__callback({ \"obj\" : this._get_node(obj) }); }\n\t\t\t},\n\t\t\tcheck_all : function () {\n\t\t\t\tvar _this = this,\n\t\t\t\t\tcoll = this._get_settings().checkbox.two_state ? this.get_container_ul().find(\"li\") : this.get_container_ul().children(\"li\");\n\t\t\t\tcoll.each(function () {\n\t\t\t\t\t_this.change_state(this, false);\n\t\t\t\t});\n\t\t\t\tthis.__callback();\n\t\t\t},\n\t\t\tuncheck_all : function () {\n\t\t\t\tvar _this = this,\n\t\t\t\t\tcoll = this._get_settings().checkbox.two_state ? this.get_container_ul().find(\"li\") : this.get_container_ul().children(\"li\");\n\t\t\t\tcoll.each(function () {\n\t\t\t\t\t_this.change_state(this, true);\n\t\t\t\t});\n\t\t\t\tthis.__callback();\n\t\t\t},\n\n\t\t\tis_checked : function(obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\treturn obj.length ? obj.is(\".jstree-checked\") : false;\n\t\t\t},\n\t\t\tget_checked : function (obj, get_all) {\n\t\t\t\tobj = !obj || obj === -1 ? this.get_container() : this._get_node(obj);\n\t\t\t\treturn get_all || this._get_settings().checkbox.two_state ? obj.find(\".jstree-checked\") : obj.find(\"> ul > .jstree-checked, .jstree-undetermined > ul > .jstree-checked\");\n\t\t\t},\n\t\t\tget_unchecked : function (obj, get_all) {\n\t\t\t\tobj = !obj || obj === -1 ? this.get_container() : this._get_node(obj);\n\t\t\t\treturn get_all || this._get_settings().checkbox.two_state ? obj.find(\".jstree-unchecked\") : obj.find(\"> ul > .jstree-unchecked, .jstree-undetermined > ul > .jstree-unchecked\");\n\t\t\t},\n\n\t\t\tshow_checkboxes : function () { this.get_container().children(\"ul\").removeClass(\"jstree-no-checkboxes\"); },\n\t\t\thide_checkboxes : function () { this.get_container().children(\"ul\").addClass(\"jstree-no-checkboxes\"); },\n\n\t\t\t_repair_state : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj.length) { return; }\n\t\t\t\tif(this._get_settings().checkbox.two_state) {\n\t\t\t\t\tobj.find('li').addBack().not('.jstree-checked').removeClass('jstree-undetermined').addClass('jstree-unchecked').children(':checkbox').prop('checked', true);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tvar rc = this._get_settings().checkbox.real_checkboxes,\n\t\t\t\t\ta = obj.find(\"> ul > .jstree-checked\").length,\n\t\t\t\t\tb = obj.find(\"> ul > .jstree-undetermined\").length,\n\t\t\t\t\tc = obj.find(\"> ul > li\").length;\n\t\t\t\tif(c === 0) { if(obj.hasClass(\"jstree-undetermined\")) { this.change_state(obj, false); } }\n\t\t\t\telse if(a === 0 && b === 0) { this.change_state(obj, true); }\n\t\t\t\telse if(a === c) { this.change_state(obj, false); }\n\t\t\t\telse {\n\t\t\t\t\tobj.parentsUntil(\".jstree\",\"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n\t\t\t\t\tif(rc) { obj.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n\t\t\t\t}\n\t\t\t},\n\t\t\treselect : function () {\n\t\t\t\tif(this.data.ui && this.data.checkbox.noui) {\n\t\t\t\t\tvar _this = this,\n\t\t\t\t\t\ts = this.data.ui.to_select;\n\t\t\t\t\ts = $.map($.makeArray(s), function (n) { return \"#\" + n.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\"); });\n\t\t\t\t\tthis.deselect_all();\n\t\t\t\t\t$.each(s, function (i, val) { _this.check_node(val); });\n\t\t\t\t\tthis.__callback();\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.__call_old();\n\t\t\t\t}\n\t\t\t},\n\t\t\tsave_loaded : function () {\n\t\t\t\tvar _this = this;\n\t\t\t\tthis.data.core.to_load = [];\n\t\t\t\tthis.get_container_ul().find(\"li.jstree-closed.jstree-undetermined\").each(function () {\n\t\t\t\t\tif(this.id) { _this.data.core.to_load.push(\"#\" + this.id); }\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t});\n\t$(function() {\n\t\tvar css_string = '.jstree .jstree-real-checkbox { display:none; } ';\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree XML plugin\n * The XML data store. Datastores are build by overriding the `load_node` and `_is_loaded` functions.\n */\n(function ($) {\n\t$.vakata.xslt = function (xml, xsl, callback) {\n\t\tvar rs = \"\", xm, xs, processor, support;\n\t\t// TODO: IE9 no XSLTProcessor, no document.recalc\n\t\tif(document.recalc) {\n\t\t\txm = document.createElement('xml');\n\t\t\txs = document.createElement('xml');\n\t\t\txm.innerHTML = xml;\n\t\t\txs.innerHTML = xsl;\n\t\t\t$(\"body\").append(xm).append(xs);\n\t\t\tsetTimeout( (function (xm, xs, callback) {\n\t\t\t\treturn function () {\n\t\t\t\t\tcallback.call(null, xm.transformNode(xs.XMLDocument));\n\t\t\t\t\tsetTimeout( (function (xm, xs) { return function () { $(xm).remove(); $(xs).remove(); }; })(xm, xs), 200);\n\t\t\t\t};\n\t\t\t})(xm, xs, callback), 100);\n\t\t\treturn true;\n\t\t}\n\t\tif(typeof window.DOMParser !== \"undefined\" && typeof window.XMLHttpRequest !== \"undefined\" && typeof window.XSLTProcessor === \"undefined\") {\n\t\t\txml = new DOMParser().parseFromString(xml, \"text/xml\");\n\t\t\txsl = new DOMParser().parseFromString(xsl, \"text/xml\");\n\t\t\t// alert(xml.transformNode());\n\t\t\t// callback.call(null, new XMLSerializer().serializeToString(rs));\n\n\t\t}\n\t\tif(typeof window.DOMParser !== \"undefined\" && typeof window.XMLHttpRequest !== \"undefined\" && typeof window.XSLTProcessor !== \"undefined\") {\n\t\t\tprocessor = new XSLTProcessor();\n\t\t\tsupport = $.isFunction(processor.transformDocument) ? (typeof window.XMLSerializer !== \"undefined\") : true;\n\t\t\tif(!support) { return false; }\n\t\t\txml = new DOMParser().parseFromString(xml, \"text/xml\");\n\t\t\txsl = new DOMParser().parseFromString(xsl, \"text/xml\");\n\t\t\tif($.isFunction(processor.transformDocument)) {\n\t\t\t\trs = document.implementation.createDocument(\"\", \"\", null);\n\t\t\t\tprocessor.transformDocument(xml, xsl, rs, null);\n\t\t\t\tcallback.call(null, new XMLSerializer().serializeToString(rs));\n\t\t\t\treturn true;\n\t\t\t}\n\t\t\telse {\n\t\t\t\tprocessor.importStylesheet(xsl);\n\t\t\t\trs = processor.transformToFragment(xml, document);\n\t\t\t\tcallback.call(null, $(\"<div />\").append(rs).html());\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t};\n\tvar xsl = {\n\t\t'nest' : '<' + '?xml version=\"1.0\" encoding=\"utf-8\" ?>' +\n\t\t\t'<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" >' +\n\t\t\t'<xsl:output method=\"html\" encoding=\"utf-8\" omit-xml-declaration=\"yes\" standalone=\"no\" indent=\"no\" media-type=\"text/html\" />' +\n\t\t\t'<xsl:template match=\"/\">' +\n\t\t\t'\t<xsl:call-template name=\"nodes\">' +\n\t\t\t'\t\t<xsl:with-param name=\"node\" select=\"/root\" />' +\n\t\t\t'\t</xsl:call-template>' +\n\t\t\t'</xsl:template>' +\n\t\t\t'<xsl:template name=\"nodes\">' +\n\t\t\t'\t<xsl:param name=\"node\" />' +\n\t\t\t'\t<ul>' +\n\t\t\t'\t<xsl:for-each select=\"$node/item\">' +\n\t\t\t'\t\t<xsl:variable name=\"children\" select=\"count(./item) &gt; 0\" />' +\n\t\t\t'\t\t<li>' +\n\t\t\t'\t\t\t<xsl:attribute name=\"class\">' +\n\t\t\t'\t\t\t\t<xsl:if test=\"position() = last()\">jstree-last </xsl:if>' +\n\t\t\t'\t\t\t\t<xsl:choose>' +\n\t\t\t'\t\t\t\t\t<xsl:when test=\"@state = \\'open\\'\">jstree-open </xsl:when>' +\n\t\t\t'\t\t\t\t\t<xsl:when test=\"$children or @hasChildren or @state = \\'closed\\'\">jstree-closed </xsl:when>' +\n\t\t\t'\t\t\t\t\t<xsl:otherwise>jstree-leaf </xsl:otherwise>' +\n\t\t\t'\t\t\t\t</xsl:choose>' +\n\t\t\t'\t\t\t\t<xsl:value-of select=\"@class\" />' +\n\t\t\t'\t\t\t</xsl:attribute>' +\n\t\t\t'\t\t\t<xsl:for-each select=\"@*\">' +\n\t\t\t'\t\t\t\t<xsl:if test=\"name() != \\'class\\' and name() != \\'state\\' and name() != \\'hasChildren\\'\">' +\n\t\t\t'\t\t\t\t\t<xsl:attribute name=\"{name()}\"><xsl:value-of select=\".\" /></xsl:attribute>' +\n\t\t\t'\t\t\t\t</xsl:if>' +\n\t\t\t'\t\t\t</xsl:for-each>' +\n\t\t\t'\t<ins class=\"jstree-icon\"><xsl:text>&#xa0;</xsl:text></ins>' +\n\t\t\t'\t\t\t<xsl:for-each select=\"content/name\">' +\n\t\t\t'\t\t\t\t<a>' +\n\t\t\t'\t\t\t\t<xsl:attribute name=\"href\">' +\n\t\t\t'\t\t\t\t\t<xsl:choose>' +\n\t\t\t'\t\t\t\t\t<xsl:when test=\"@href\"><xsl:value-of select=\"@href\" /></xsl:when>' +\n\t\t\t'\t\t\t\t\t<xsl:otherwise>#</xsl:otherwise>' +\n\t\t\t'\t\t\t\t\t</xsl:choose>' +\n\t\t\t'\t\t\t\t</xsl:attribute>' +\n\t\t\t'\t\t\t\t<xsl:attribute name=\"class\"><xsl:value-of select=\"@lang\" /> <xsl:value-of select=\"@class\" /></xsl:attribute>' +\n\t\t\t'\t\t\t\t<xsl:attribute name=\"style\"><xsl:value-of select=\"@style\" /></xsl:attribute>' +\n\t\t\t'\t\t\t\t<xsl:for-each select=\"@*\">' +\n\t\t\t'\t\t\t\t\t<xsl:if test=\"name() != \\'style\\' and name() != \\'class\\' and name() != \\'href\\'\">' +\n\t\t\t'\t\t\t\t\t\t<xsl:attribute name=\"{name()}\"><xsl:value-of select=\".\" /></xsl:attribute>' +\n\t\t\t'\t\t\t\t\t</xsl:if>' +\n\t\t\t'\t\t\t\t</xsl:for-each>' +\n\t\t\t'\t\t\t\t\t<ins>' +\n\t\t\t'\t\t\t\t\t\t<xsl:attribute name=\"class\">jstree-icon ' +\n\t\t\t'\t\t\t\t\t\t\t<xsl:if test=\"string-length(attribute::icon) > 0 and not(contains(@icon,\\'/\\'))\"><xsl:value-of select=\"@icon\" /></xsl:if>' +\n\t\t\t'\t\t\t\t\t\t</xsl:attribute>' +\n\t\t\t'\t\t\t\t\t\t<xsl:if test=\"string-length(attribute::icon) > 0 and contains(@icon,\\'/\\')\"><xsl:attribute name=\"style\">background:url(<xsl:value-of select=\"@icon\" />) center center no-repeat;</xsl:attribute></xsl:if>' +\n\t\t\t'\t\t\t\t\t\t<xsl:text>&#xa0;</xsl:text>' +\n\t\t\t'\t\t\t\t\t</ins>' +\n\t\t\t'\t\t\t\t\t<xsl:copy-of select=\"./child::node()\" />' +\n\t\t\t'\t\t\t\t</a>' +\n\t\t\t'\t\t\t</xsl:for-each>' +\n\t\t\t'\t\t\t<xsl:if test=\"$children or @hasChildren\"><xsl:call-template name=\"nodes\"><xsl:with-param name=\"node\" select=\"current()\" /></xsl:call-template></xsl:if>' +\n\t\t\t'\t\t</li>' +\n\t\t\t'\t</xsl:for-each>' +\n\t\t\t'\t</ul>' +\n\t\t\t'</xsl:template>' +\n\t\t\t'</xsl:stylesheet>',\n\n\t\t'flat' : '<' + '?xml version=\"1.0\" encoding=\"utf-8\" ?>' +\n\t\t\t'<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" >' +\n\t\t\t'<xsl:output method=\"html\" encoding=\"utf-8\" omit-xml-declaration=\"yes\" standalone=\"no\" indent=\"no\" media-type=\"text/xml\" />' +\n\t\t\t'<xsl:template match=\"/\">' +\n\t\t\t'\t<ul>' +\n\t\t\t'\t<xsl:for-each select=\"//item[not(@parent_id) or @parent_id=0 or not(@parent_id = //item/@id)]\">' + /* the last `or` may be removed */\n\t\t\t'\t\t<xsl:call-template name=\"nodes\">' +\n\t\t\t'\t\t\t<xsl:with-param name=\"node\" select=\".\" />' +\n\t\t\t'\t\t\t<xsl:with-param name=\"is_last\" select=\"number(position() = last())\" />' +\n\t\t\t'\t\t</xsl:call-template>' +\n\t\t\t'\t</xsl:for-each>' +\n\t\t\t'\t</ul>' +\n\t\t\t'</xsl:template>' +\n\t\t\t'<xsl:template name=\"nodes\">' +\n\t\t\t'\t<xsl:param name=\"node\" />' +\n\t\t\t'\t<xsl:param name=\"is_last\" />' +\n\t\t\t'\t<xsl:variable name=\"children\" select=\"count(//item[@parent_id=$node/attribute::id]) &gt; 0\" />' +\n\t\t\t'\t<li>' +\n\t\t\t'\t<xsl:attribute name=\"class\">' +\n\t\t\t'\t\t<xsl:if test=\"$is_last = true()\">jstree-last </xsl:if>' +\n\t\t\t'\t\t<xsl:choose>' +\n\t\t\t'\t\t\t<xsl:when test=\"@state = \\'open\\'\">jstree-open </xsl:when>' +\n\t\t\t'\t\t\t<xsl:when test=\"$children or @hasChildren or @state = \\'closed\\'\">jstree-closed </xsl:when>' +\n\t\t\t'\t\t\t<xsl:otherwise>jstree-leaf </xsl:otherwise>' +\n\t\t\t'\t\t</xsl:choose>' +\n\t\t\t'\t\t<xsl:value-of select=\"@class\" />' +\n\t\t\t'\t</xsl:attribute>' +\n\t\t\t'\t<xsl:for-each select=\"@*\">' +\n\t\t\t'\t\t<xsl:if test=\"name() != \\'parent_id\\' and name() != \\'hasChildren\\' and name() != \\'class\\' and name() != \\'state\\'\">' +\n\t\t\t'\t\t<xsl:attribute name=\"{name()}\"><xsl:value-of select=\".\" /></xsl:attribute>' +\n\t\t\t'\t\t</xsl:if>' +\n\t\t\t'\t</xsl:for-each>' +\n\t\t\t'\t<ins class=\"jstree-icon\"><xsl:text>&#xa0;</xsl:text></ins>' +\n\t\t\t'\t<xsl:for-each select=\"content/name\">' +\n\t\t\t'\t\t<a>' +\n\t\t\t'\t\t<xsl:attribute name=\"href\">' +\n\t\t\t'\t\t\t<xsl:choose>' +\n\t\t\t'\t\t\t<xsl:when test=\"@href\"><xsl:value-of select=\"@href\" /></xsl:when>' +\n\t\t\t'\t\t\t<xsl:otherwise>#</xsl:otherwise>' +\n\t\t\t'\t\t\t</xsl:choose>' +\n\t\t\t'\t\t</xsl:attribute>' +\n\t\t\t'\t\t<xsl:attribute name=\"class\"><xsl:value-of select=\"@lang\" /> <xsl:value-of select=\"@class\" /></xsl:attribute>' +\n\t\t\t'\t\t<xsl:attribute name=\"style\"><xsl:value-of select=\"@style\" /></xsl:attribute>' +\n\t\t\t'\t\t<xsl:for-each select=\"@*\">' +\n\t\t\t'\t\t\t<xsl:if test=\"name() != \\'style\\' and name() != \\'class\\' and name() != \\'href\\'\">' +\n\t\t\t'\t\t\t\t<xsl:attribute name=\"{name()}\"><xsl:value-of select=\".\" /></xsl:attribute>' +\n\t\t\t'\t\t\t</xsl:if>' +\n\t\t\t'\t\t</xsl:for-each>' +\n\t\t\t'\t\t\t<ins>' +\n\t\t\t'\t\t\t\t<xsl:attribute name=\"class\">jstree-icon ' +\n\t\t\t'\t\t\t\t\t<xsl:if test=\"string-length(attribute::icon) > 0 and not(contains(@icon,\\'/\\'))\"><xsl:value-of select=\"@icon\" /></xsl:if>' +\n\t\t\t'\t\t\t\t</xsl:attribute>' +\n\t\t\t'\t\t\t\t<xsl:if test=\"string-length(attribute::icon) > 0 and contains(@icon,\\'/\\')\"><xsl:attribute name=\"style\">background:url(<xsl:value-of select=\"@icon\" />) center center no-repeat;</xsl:attribute></xsl:if>' +\n\t\t\t'\t\t\t\t<xsl:text>&#xa0;</xsl:text>' +\n\t\t\t'\t\t\t</ins>' +\n\t\t\t'\t\t\t<xsl:copy-of select=\"./child::node()\" />' +\n\t\t\t'\t\t</a>' +\n\t\t\t'\t</xsl:for-each>' +\n\t\t\t'\t<xsl:if test=\"$children\">' +\n\t\t\t'\t\t<ul>' +\n\t\t\t'\t\t<xsl:for-each select=\"//item[@parent_id=$node/attribute::id]\">' +\n\t\t\t'\t\t\t<xsl:call-template name=\"nodes\">' +\n\t\t\t'\t\t\t\t<xsl:with-param name=\"node\" select=\".\" />' +\n\t\t\t'\t\t\t\t<xsl:with-param name=\"is_last\" select=\"number(position() = last())\" />' +\n\t\t\t'\t\t\t</xsl:call-template>' +\n\t\t\t'\t\t</xsl:for-each>' +\n\t\t\t'\t\t</ul>' +\n\t\t\t'\t</xsl:if>' +\n\t\t\t'\t</li>' +\n\t\t\t'</xsl:template>' +\n\t\t\t'</xsl:stylesheet>'\n\t},\n\tescape_xml = function(string) {\n\t\treturn string\n\t\t\t.toString()\n\t\t\t.replace(/&/g, '&amp;')\n\t\t\t.replace(/</g, '&lt;')\n\t\t\t.replace(/>/g, '&gt;')\n\t\t\t.replace(/\"/g, '&quot;')\n\t\t\t.replace(/'/g, '&apos;');\n\t};\n\t$.jstree.plugin(\"xml_data\", {\n\t\tdefaults : {\n\t\t\tdata : false,\n\t\t\tajax : false,\n\t\t\txsl : \"flat\",\n\t\t\tclean_node : false,\n\t\t\tcorrect_state : true,\n\t\t\tget_skip_empty : false,\n\t\t\tget_include_preamble : true\n\t\t},\n\t\t_fn : {\n\t\t\tload_node : function (obj, s_call, e_call) { var _this = this; this.load_node_xml(obj, function () { _this.__callback({ \"obj\" : _this._get_node(obj) }); s_call.call(this); }, e_call); },\n\t\t\t_is_loaded : function (obj) {\n\t\t\t\tvar s = this._get_settings().xml_data;\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\treturn obj == -1 || !obj || (!s.ajax && !$.isFunction(s.data)) || obj.is(\".jstree-open, .jstree-leaf\") || obj.children(\"ul\").children(\"li\").size() > 0;\n\t\t\t},\n\t\t\tload_node_xml : function (obj, s_call, e_call) {\n\t\t\t\tvar s = this.get_settings().xml_data,\n\t\t\t\t\terror_func = function () {},\n\t\t\t\t\tsuccess_func = function () {};\n\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\tif(obj.data(\"jstree_is_loading\")) { return; }\n\t\t\t\t\telse { obj.data(\"jstree_is_loading\",true); }\n\t\t\t\t}\n\t\t\t\tswitch(!0) {\n\t\t\t\t\tcase (!s.data && !s.ajax): throw \"Neither data nor ajax settings supplied.\";\n\t\t\t\t\tcase ($.isFunction(s.data)):\n\t\t\t\t\t\ts.data.call(this, obj, $.proxy(function (d) {\n\t\t\t\t\t\t\tthis.parse_xml(d, $.proxy(function (d) {\n\t\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\t\td = d.replace(/ ?xmlns=\"[^\"]*\"/ig, \"\");\n\t\t\t\t\t\t\t\t\tif(d.length > 10) {\n\t\t\t\t\t\t\t\t\t\td = $(d);\n\t\t\t\t\t\t\t\t\t\tif(obj === -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()); }\n\t\t\t\t\t\t\t\t\t\telse { obj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.append(d); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\t\t\tif(s.clean_node) { this.clean_node(obj); }\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\t\t\tthis.correct_state(obj);\n\t\t\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t\t\t}, this));\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!!s.data && !s.ajax) || (!!s.data && !!s.ajax && (!obj || obj === -1)):\n\t\t\t\t\t\tif(!obj || obj == -1) {\n\t\t\t\t\t\t\tthis.parse_xml(s.data, $.proxy(function (d) {\n\t\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\t\td = d.replace(/ ?xmlns=\"[^\"]*\"/ig, \"\");\n\t\t\t\t\t\t\t\t\tif(d.length > 10) {\n\t\t\t\t\t\t\t\t\t\td = $(d);\n\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty().append(d.children());\n\t\t\t\t\t\t\t\t\t\tif(s.clean_node) { this.clean_node(obj); }\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!s.data && !!s.ajax) || (!!s.data && !!s.ajax && obj && obj !== -1):\n\t\t\t\t\t\terror_func = function (x, t, e) {\n\t\t\t\t\t\t\tvar ef = this.get_settings().xml_data.ajax.error;\n\t\t\t\t\t\t\tif(ef) { ef.call(this, x, t, e); }\n\t\t\t\t\t\t\tif(obj !== -1 && obj.length) {\n\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.correct_state(obj); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.get_container().children(\"ul\").empty(); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(e_call) { e_call.call(this); }\n\t\t\t\t\t\t};\n\t\t\t\t\t\tsuccess_func = function (d, t, x) {\n\t\t\t\t\t\t\td = x.responseText;\n\t\t\t\t\t\t\tvar sf = this.get_settings().xml_data.ajax.success;\n\t\t\t\t\t\t\tif(sf) { d = sf.call(this,d,t,x) || d; }\n\t\t\t\t\t\t\tif(d === \"\" || (d && d.toString && d.toString().replace(/^[\\s\\n]+$/,\"\") === \"\")) {\n\t\t\t\t\t\t\t\treturn error_func.call(this, x, t, \"\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tthis.parse_xml(d, $.proxy(function (d) {\n\t\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\t\td = d.replace(/ ?xmlns=\"[^\"]*\"/ig, \"\");\n\t\t\t\t\t\t\t\t\tif(d.length > 10) {\n\t\t\t\t\t\t\t\t\t\td = $(d);\n\t\t\t\t\t\t\t\t\t\tif(obj === -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()); }\n\t\t\t\t\t\t\t\t\t\telse { obj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.append(d); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\t\t\tif(s.clean_node) { this.clean_node(obj); }\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\t\t\tthis.correct_state(obj);\n\t\t\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}, this));\n\t\t\t\t\t\t};\n\t\t\t\t\t\ts.ajax.context = this;\n\t\t\t\t\t\ts.ajax.error = error_func;\n\t\t\t\t\t\ts.ajax.success = success_func;\n\t\t\t\t\t\tif(!s.ajax.dataType) { s.ajax.dataType = \"xml\"; }\n\t\t\t\t\t\tif($.isFunction(s.ajax.url)) { s.ajax.url = s.ajax.url.call(this, obj); }\n\t\t\t\t\t\tif($.isFunction(s.ajax.data)) { s.ajax.data = s.ajax.data.call(this, obj); }\n\t\t\t\t\t\t$.ajax(s.ajax);\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t},\n\t\t\tparse_xml : function (xml, callback) {\n\t\t\t\tvar s = this._get_settings().xml_data;\n\t\t\t\t$.vakata.xslt(xml, xsl[s.xsl], callback);\n\t\t\t},\n\t\t\tget_xml : function (tp, obj, li_attr, a_attr, is_callback) {\n\t\t\t\tvar result = \"\",\n\t\t\t\t\ts = this._get_settings(),\n\t\t\t\t\t_this = this,\n\t\t\t\t\ttmp1, tmp2, li, a, lang;\n\t\t\t\tif(!tp) { tp = \"flat\"; }\n\t\t\t\tif(!is_callback) { is_callback = 0; }\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(!obj || obj === -1) { obj = this.get_container().find(\"> ul > li\"); }\n\t\t\t\tli_attr = $.isArray(li_attr) ? li_attr : [ \"id\", \"class\" ];\n\t\t\t\tif(!is_callback && this.data.types && $.inArray(s.types.type_attr, li_attr) === -1) { li_attr.push(s.types.type_attr); }\n\n\t\t\t\ta_attr = $.isArray(a_attr) ? a_attr : [ ];\n\n\t\t\t\tif(!is_callback) {\n\t\t\t\t\tif(s.xml_data.get_include_preamble) {\n\t\t\t\t\t\tresult += '<' + '?xml version=\"1.0\" encoding=\"UTF-8\"?' + '>';\n\t\t\t\t\t}\n\t\t\t\t\tresult += \"<root>\";\n\t\t\t\t}\n\t\t\t\tobj.each(function () {\n\t\t\t\t\tresult += \"<item\";\n\t\t\t\t\tli = $(this);\n\t\t\t\t\t$.each(li_attr, function (i, v) {\n\t\t\t\t\t\tvar t = li.attr(v);\n\t\t\t\t\t\tif(!s.xml_data.get_skip_empty || typeof t !== \"undefined\") {\n\t\t\t\t\t\t\tresult += \" \" + v + \"=\\\"\" + escape_xml((\" \" + (t || \"\")).replace(/ jstree[^ ]*/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\")) + \"\\\"\";\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tif(li.hasClass(\"jstree-open\")) { result += \" state=\\\"open\\\"\"; }\n\t\t\t\t\tif(li.hasClass(\"jstree-closed\")) { result += \" state=\\\"closed\\\"\"; }\n\t\t\t\t\tif(tp === \"flat\") { result += \" parent_id=\\\"\" + escape_xml(is_callback) + \"\\\"\"; }\n\t\t\t\t\tresult += \">\";\n\t\t\t\t\tresult += \"<content>\";\n\t\t\t\t\ta = li.children(\"a\");\n\t\t\t\t\ta.each(function () {\n\t\t\t\t\t\ttmp1 = $(this);\n\t\t\t\t\t\tlang = false;\n\t\t\t\t\t\tresult += \"<name\";\n\t\t\t\t\t\tif($.inArray(\"languages\", s.plugins) !== -1) {\n\t\t\t\t\t\t\t$.each(s.languages, function (k, z) {\n\t\t\t\t\t\t\t\tif(tmp1.hasClass(z)) { result += \" lang=\\\"\" + escape_xml(z) + \"\\\"\"; lang = z; return false; }\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(a_attr.length) {\n\t\t\t\t\t\t\t$.each(a_attr, function (k, z) {\n\t\t\t\t\t\t\t\tvar t = tmp1.attr(z);\n\t\t\t\t\t\t\t\tif(!s.xml_data.get_skip_empty || typeof t !== \"undefined\") {\n\t\t\t\t\t\t\t\t\tresult += \" \" + z + \"=\\\"\" + escape_xml((\" \" + t || \"\").replace(/ jstree[^ ]*/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\")) + \"\\\"\";\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(tmp1.children(\"ins\").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/^\\s+$/ig,\"\").length) {\n\t\t\t\t\t\t\tresult += ' icon=\"' + escape_xml(tmp1.children(\"ins\").get(0).className.replace(/jstree[^ ]*|$/ig,'').replace(/\\s+$/ig,\" \").replace(/^ /,\"\").replace(/ $/,\"\")) + '\"';\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(tmp1.children(\"ins\").get(0).style.backgroundImage.length) {\n\t\t\t\t\t\t\tresult += ' icon=\"' + escape_xml(tmp1.children(\"ins\").get(0).style.backgroundImage.replace(\"url(\",\"\").replace(\")\",\"\").replace(/'/ig,\"\").replace(/\"/ig,\"\")) + '\"';\n\t\t\t\t\t\t}\n\t\t\t\t\t\tresult += \">\";\n\t\t\t\t\t\tresult += \"<![CDATA[\" + _this.get_text(tmp1, lang) + \"]]>\";\n\t\t\t\t\t\tresult += \"</name>\";\n\t\t\t\t\t});\n\t\t\t\t\tresult += \"</content>\";\n\t\t\t\t\ttmp2 = li[0].id || true;\n\t\t\t\t\tli = li.find(\"> ul > li\");\n\t\t\t\t\tif(li.length) { tmp2 = _this.get_xml(tp, li, li_attr, a_attr, tmp2); }\n\t\t\t\t\telse { tmp2 = \"\"; }\n\t\t\t\t\tif(tp == \"nest\") { result += tmp2; }\n\t\t\t\t\tresult += \"</item>\";\n\t\t\t\t\tif(tp == \"flat\") { result += tmp2; }\n\t\t\t\t});\n\t\t\t\tif(!is_callback) { result += \"</root>\"; }\n\t\t\t\treturn result;\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree search plugin\n * Enables both sync and async search on the tree\n * DOES NOT WORK WITH JSON PROGRESSIVE RENDER\n */\n(function ($) {\n\t$.expr[':'].jstree_contains = function(a,i,m){\n\t\treturn (a.textContent || a.innerText || \"\").toLowerCase().indexOf(m[3].toLowerCase())>=0;\n\t};\n\t$.expr[':'].jstree_title_contains = function(a,i,m) {\n\t\treturn (a.getAttribute(\"title\") || \"\").toLowerCase().indexOf(m[3].toLowerCase())>=0;\n\t};\n\t$.jstree.plugin(\"search\", {\n\t\t__init : function () {\n\t\t\tthis.data.search.str = \"\";\n\t\t\tthis.data.search.result = $();\n\t\t\tif(this._get_settings().search.show_only_matches) {\n\t\t\t\tthis.get_container()\n\t\t\t\t\t.bind(\"search.jstree\", function (e, data) {\n\t\t\t\t\t\t$(this).children(\"ul\").find(\"li\").hide().removeClass(\"jstree-last\");\n\t\t\t\t\t\tdata.rslt.nodes.parentsUntil(\".jstree\").addBack().show()\n\t\t\t\t\t\t\t.filter(\"ul\").each(function () { $(this).children(\"li:visible\").eq(-1).addClass(\"jstree-last\"); });\n\t\t\t\t\t})\n\t\t\t\t\t.bind(\"clear_search.jstree\", function () {\n\t\t\t\t\t\t$(this).children(\"ul\").find(\"li\").css(\"display\",\"\").end().end().jstree(\"clean_node\", -1);\n\t\t\t\t\t});\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t\tajax : false,\n\t\t\tsearch_method : \"jstree_contains\", // for case insensitive - jstree_contains\n\t\t\tshow_only_matches : false\n\t\t},\n\t\t_fn : {\n\t\t\tsearch : function (str, skip_async) {\n\t\t\t\tif($.trim(str) === \"\") { this.clear_search(); return; }\n\t\t\t\tvar s = this.get_settings().search,\n\t\t\t\t\tt = this,\n\t\t\t\t\terror_func = function () { },\n\t\t\t\t\tsuccess_func = function () { };\n\t\t\t\tthis.data.search.str = str;\n\n\t\t\t\tif(!skip_async && s.ajax !== false && this.get_container_ul().find(\"li.jstree-closed:not(:has(ul)):eq(0)\").length > 0) {\n\t\t\t\t\tthis.search.supress_callback = true;\n\t\t\t\t\terror_func = function () { };\n\t\t\t\t\tsuccess_func = function (d, t, x) {\n\t\t\t\t\t\tvar sf = this.get_settings().search.ajax.success;\n\t\t\t\t\t\tif(sf) { d = sf.call(this,d,t,x) || d; }\n\t\t\t\t\t\tthis.data.search.to_open = d;\n\t\t\t\t\t\tthis._search_open();\n\t\t\t\t\t};\n\t\t\t\t\ts.ajax.context = this;\n\t\t\t\t\ts.ajax.error = error_func;\n\t\t\t\t\ts.ajax.success = success_func;\n\t\t\t\t\tif($.isFunction(s.ajax.url)) { s.ajax.url = s.ajax.url.call(this, str); }\n\t\t\t\t\tif($.isFunction(s.ajax.data)) { s.ajax.data = s.ajax.data.call(this, str); }\n\t\t\t\t\tif(!s.ajax.data) { s.ajax.data = { \"search_string\" : str }; }\n\t\t\t\t\tif(!s.ajax.dataType || /^json/.exec(s.ajax.dataType)) { s.ajax.dataType = \"json\"; }\n\t\t\t\t\t$.ajax(s.ajax);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tif(this.data.search.result.length) { this.clear_search(); }\n\t\t\t\tthis.data.search.result = this.get_container().find(\"a\" + (this.data.languages ? \".\" + this.get_lang() : \"\" ) + \":\" + (s.search_method) + \"(\" + this.data.search.str + \")\");\n\t\t\t\tthis.data.search.result.addClass(\"jstree-search\").parent().parents(\".jstree-closed\").each(function () {\n\t\t\t\t\tt.open_node(this, false, true);\n\t\t\t\t});\n\t\t\t\tthis.__callback({ nodes : this.data.search.result, str : str });\n\t\t\t},\n\t\t\tclear_search : function (str) {\n\t\t\t\tthis.data.search.result.removeClass(\"jstree-search\");\n\t\t\t\tthis.__callback(this.data.search.result);\n\t\t\t\tthis.data.search.result = $();\n\t\t\t},\n\t\t\t_search_open : function (is_callback) {\n\t\t\t\tvar _this = this,\n\t\t\t\t\tdone = true,\n\t\t\t\t\tcurrent = [],\n\t\t\t\t\tremaining = [];\n\t\t\t\tif(this.data.search.to_open.length) {\n\t\t\t\t\t$.each(this.data.search.to_open, function (i, val) {\n\t\t\t\t\t\tif(val == \"#\") { return true; }\n\t\t\t\t\t\tif($(val).length && $(val).is(\".jstree-closed\")) { current.push(val); }\n\t\t\t\t\t\telse { remaining.push(val); }\n\t\t\t\t\t});\n\t\t\t\t\tif(current.length) {\n\t\t\t\t\t\tthis.data.search.to_open = remaining;\n\t\t\t\t\t\t$.each(current, function (i, val) {\n\t\t\t\t\t\t\t_this.open_node(val, function () { _this._search_open(true); });\n\t\t\t\t\t\t});\n\t\t\t\t\t\tdone = false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(done) { this.search(this.data.search.str, true); }\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree contextmenu plugin\n */\n(function ($) {\n\t$.vakata.context = {\n\t\thide_on_mouseleave : false,\n\n\t\tcnt\t\t: $(\"<div id='vakata-contextmenu' />\"),\n\t\tvis\t\t: false,\n\t\ttgt\t\t: false,\n\t\tpar\t\t: false,\n\t\tfunc\t: false,\n\t\tdata\t: false,\n\t\trtl\t\t: false,\n\t\tshow\t: function (s, t, x, y, d, p, rtl) {\n\t\t\t$.vakata.context.rtl = !!rtl;\n\t\t\tvar html = $.vakata.context.parse(s), h, w;\n\t\t\tif(!html) { return; }\n\t\t\t$.vakata.context.vis = true;\n\t\t\t$.vakata.context.tgt = t;\n\t\t\t$.vakata.context.par = p || t || null;\n\t\t\t$.vakata.context.data = d || null;\n\t\t\t$.vakata.context.cnt\n\t\t\t\t.html(html)\n\t\t\t\t.css({ \"visibility\" : \"hidden\", \"display\" : \"block\", \"left\" : 0, \"top\" : 0 });\n\n\t\t\tif($.vakata.context.hide_on_mouseleave) {\n\t\t\t\t$.vakata.context.cnt\n\t\t\t\t\t.one(\"mouseleave\", function(e) { $.vakata.context.hide(); });\n\t\t\t}\n\n\t\t\th = $.vakata.context.cnt.height();\n\t\t\tw = $.vakata.context.cnt.width();\n\t\t\tif(x + w > $(document).width()) {\n\t\t\t\tx = $(document).width() - (w + 5);\n\t\t\t\t$.vakata.context.cnt.find(\"li > ul\").addClass(\"right\");\n\t\t\t}\n\t\t\tif(y + h > $(document).height()) {\n\t\t\t\ty = y - (h + t[0].offsetHeight);\n\t\t\t\t$.vakata.context.cnt.find(\"li > ul\").addClass(\"bottom\");\n\t\t\t}\n\n\t\t\t$.vakata.context.cnt\n\t\t\t\t.css({ \"left\" : x, \"top\" : y })\n\t\t\t\t.find(\"li:has(ul)\")\n\t\t\t\t\t.bind(\"mouseenter\", function (e) {\n\t\t\t\t\t\tvar w = $(document).width(),\n\t\t\t\t\t\t\th = $(document).height(),\n\t\t\t\t\t\t\tul = $(this).children(\"ul\").show();\n\t\t\t\t\t\tif(w !== $(document).width()) { ul.toggleClass(\"right\"); }\n\t\t\t\t\t\tif(h !== $(document).height()) { ul.toggleClass(\"bottom\"); }\n\t\t\t\t\t})\n\t\t\t\t\t.bind(\"mouseleave\", function (e) {\n\t\t\t\t\t\t$(this).children(\"ul\").hide();\n\t\t\t\t\t})\n\t\t\t\t\t.end()\n\t\t\t\t.css({ \"visibility\" : \"visible\" })\n\t\t\t\t.show();\n\t\t\t$(document).triggerHandler(\"context_show.vakata\");\n\t\t},\n\t\thide\t: function () {\n\t\t\t$.vakata.context.vis = false;\n\t\t\t$.vakata.context.cnt.attr(\"class\",\"\").css({ \"visibility\" : \"hidden\" });\n\t\t\t$(document).triggerHandler(\"context_hide.vakata\");\n\t\t},\n\t\tparse\t: function (s, is_callback) {\n\t\t\tif(!s) { return false; }\n\t\t\tvar str = \"\",\n\t\t\t\ttmp = false,\n\t\t\t\twas_sep = true;\n\t\t\tif(!is_callback) { $.vakata.context.func = {}; }\n\t\t\tstr += \"<ul>\";\n\t\t\t$.each(s, function (i, val) {\n\t\t\t\tif(!val) { return true; }\n\t\t\t\t$.vakata.context.func[i] = val.action;\n\t\t\t\tif(!was_sep && val.separator_before) {\n\t\t\t\t\tstr += \"<li class='vakata-separator vakata-separator-before'></li>\";\n\t\t\t\t}\n\t\t\t\twas_sep = false;\n\t\t\t\tstr += \"<li class='\" + (val._class || \"\") + (val._disabled ? \" jstree-contextmenu-disabled \" : \"\") + \"'><ins \";\n\t\t\t\tif(val.icon && val.icon.indexOf(\"/\") === -1) { str += \" class='\" + val.icon + \"' \"; }\n\t\t\t\tif(val.icon && val.icon.indexOf(\"/\") !== -1) { str += \" style='background:url(\" + val.icon + \") center center no-repeat;' \"; }\n\t\t\t\tstr += \">&#160;</ins><a href='#' rel='\" + i + \"'>\";\n\t\t\t\tif(val.submenu) {\n\t\t\t\t\tstr += \"<span style='float:\" + ($.vakata.context.rtl ? \"left\" : \"right\") + \";'>&raquo;</span>\";\n\t\t\t\t}\n\t\t\t\tstr += val.label + \"</a>\";\n\t\t\t\tif(val.submenu) {\n\t\t\t\t\ttmp = $.vakata.context.parse(val.submenu, true);\n\t\t\t\t\tif(tmp) { str += tmp; }\n\t\t\t\t}\n\t\t\t\tstr += \"</li>\";\n\t\t\t\tif(val.separator_after) {\n\t\t\t\t\tstr += \"<li class='vakata-separator vakata-separator-after'></li>\";\n\t\t\t\t\twas_sep = true;\n\t\t\t\t}\n\t\t\t});\n\t\t\tstr = str.replace(/<li class\\='vakata-separator vakata-separator-after'\\><\\/li\\>$/,\"\");\n\t\t\tstr += \"</ul>\";\n\t\t\t$(document).triggerHandler(\"context_parse.vakata\");\n\t\t\treturn str.length > 10 ? str : false;\n\t\t},\n\t\texec\t: function (i) {\n\t\t\tif($.isFunction($.vakata.context.func[i])) {\n\t\t\t\t// if is string - eval and call it!\n\t\t\t\t$.vakata.context.func[i].call($.vakata.context.data, $.vakata.context.par);\n\t\t\t\treturn true;\n\t\t\t}\n\t\t\telse { return false; }\n\t\t}\n\t};\n\t$(function () {\n\t\tvar css_string = '' +\n\t\t\t'#vakata-contextmenu { display:block; visibility:hidden; left:0; top:-200px; position:absolute; margin:0; padding:0; min-width:180px; background:#ebebeb; border:1px solid silver; z-index:10000; *width:180px; } ' +\n\t\t\t'#vakata-contextmenu ul { min-width:180px; *width:180px; } ' +\n\t\t\t'#vakata-contextmenu ul, #vakata-contextmenu li { margin:0; padding:0; list-style-type:none; display:block; } ' +\n\t\t\t'#vakata-contextmenu li { line-height:20px; min-height:20px; position:relative; padding:0px; } ' +\n\t\t\t'#vakata-contextmenu li a { padding:1px 6px; line-height:17px; display:block; text-decoration:none; margin:1px 1px 0 1px; } ' +\n\t\t\t'#vakata-contextmenu li ins { float:left; width:16px; height:16px; text-decoration:none; margin-right:2px; } ' +\n\t\t\t'#vakata-contextmenu li a:hover, #vakata-contextmenu li.vakata-hover > a { background:gray; color:white; } ' +\n\t\t\t'#vakata-contextmenu li ul { display:none; position:absolute; top:-2px; left:100%; background:#ebebeb; border:1px solid gray; } ' +\n\t\t\t'#vakata-contextmenu .right { right:100%; left:auto; } ' +\n\t\t\t'#vakata-contextmenu .bottom { bottom:-1px; top:auto; } ' +\n\t\t\t'#vakata-contextmenu li.vakata-separator { min-height:0; height:1px; line-height:1px; font-size:1px; overflow:hidden; margin:0 2px; background:silver; /* border-top:1px solid #fefefe; */ padding:0; } ';\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"vakata\" });\n\t\t$.vakata.context.cnt\n\t\t\t.delegate(\"a\",\"click\", function (e) { e.preventDefault(); })\n\t\t\t.delegate(\"a\",\"mouseup\", function (e) {\n\t\t\t\tif(!$(this).parent().hasClass(\"jstree-contextmenu-disabled\") && $.vakata.context.exec($(this).attr(\"rel\"))) {\n\t\t\t\t\t$.vakata.context.hide();\n\t\t\t\t}\n\t\t\t\telse { $(this).blur(); }\n\t\t\t})\n\t\t\t.delegate(\"a\",\"mouseover\", function () {\n\t\t\t\t$.vakata.context.cnt.find(\".vakata-hover\").removeClass(\"vakata-hover\");\n\t\t\t})\n\t\t\t.appendTo(\"body\");\n\t\t$(document).bind(\"mousedown\", function (e) { if($.vakata.context.vis && !$.contains($.vakata.context.cnt[0], e.target)) { $.vakata.context.hide(); } });\n\t\tif(typeof $.hotkeys !== \"undefined\") {\n\t\t\t$(document)\n\t\t\t\t.bind(\"keydown\", \"up\", function (e) {\n\t\t\t\t\tif($.vakata.context.vis) {\n\t\t\t\t\t\tvar o = $.vakata.context.cnt.find(\"ul:visible\").last().children(\".vakata-hover\").removeClass(\"vakata-hover\").prevAll(\"li:not(.vakata-separator)\").first();\n\t\t\t\t\t\tif(!o.length) { o = $.vakata.context.cnt.find(\"ul:visible\").last().children(\"li:not(.vakata-separator)\").last(); }\n\t\t\t\t\t\to.addClass(\"vakata-hover\");\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.bind(\"keydown\", \"down\", function (e) {\n\t\t\t\t\tif($.vakata.context.vis) {\n\t\t\t\t\t\tvar o = $.vakata.context.cnt.find(\"ul:visible\").last().children(\".vakata-hover\").removeClass(\"vakata-hover\").nextAll(\"li:not(.vakata-separator)\").first();\n\t\t\t\t\t\tif(!o.length) { o = $.vakata.context.cnt.find(\"ul:visible\").last().children(\"li:not(.vakata-separator)\").first(); }\n\t\t\t\t\t\to.addClass(\"vakata-hover\");\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.bind(\"keydown\", \"right\", function (e) {\n\t\t\t\t\tif($.vakata.context.vis) {\n\t\t\t\t\t\t$.vakata.context.cnt.find(\".vakata-hover\").children(\"ul\").show().children(\"li:not(.vakata-separator)\").removeClass(\"vakata-hover\").first().addClass(\"vakata-hover\");\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.bind(\"keydown\", \"left\", function (e) {\n\t\t\t\t\tif($.vakata.context.vis) {\n\t\t\t\t\t\t$.vakata.context.cnt.find(\".vakata-hover\").children(\"ul\").hide().children(\".vakata-separator\").removeClass(\"vakata-hover\");\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.bind(\"keydown\", \"esc\", function (e) {\n\t\t\t\t\t$.vakata.context.hide();\n\t\t\t\t\te.preventDefault();\n\t\t\t\t})\n\t\t\t\t.bind(\"keydown\", \"space\", function (e) {\n\t\t\t\t\t$.vakata.context.cnt.find(\".vakata-hover\").last().children(\"a\").click();\n\t\t\t\t\te.preventDefault();\n\t\t\t\t});\n\t\t}\n\t});\n\n\t$.jstree.plugin(\"contextmenu\", {\n\t\t__init : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.delegate(\"a\", \"contextmenu.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\tif(!$(e.currentTarget).hasClass(\"jstree-loading\")) {\n\t\t\t\t\t\t\tthis.show_contextmenu(e.currentTarget, e.pageX, e.pageY);\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"a\", \"click.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif(this.data.contextmenu) {\n\t\t\t\t\t\t\t$.vakata.context.hide();\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"destroy.jstree\", $.proxy(function () {\n\t\t\t\t\t\t// TODO: move this to descruct method\n\t\t\t\t\t\tif(this.data.contextmenu) {\n\t\t\t\t\t\t\t$.vakata.context.hide();\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t\t$(document).bind(\"context_hide.vakata\", $.proxy(function () { this.data.contextmenu = false; }, this));\n\t\t},\n\t\tdefaults : {\n\t\t\tselect_node : false, // requires UI plugin\n\t\t\tshow_at_node : true,\n\t\t\titems : { // Could be a function that should return an object like this one\n\t\t\t\t\"create\" : {\n\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\"separator_after\"\t: true,\n\t\t\t\t\t\"label\"\t\t\t\t: \"Create\",\n\t\t\t\t\t\"action\"\t\t\t: function (obj) { this.create(obj); }\n\t\t\t\t},\n\t\t\t\t\"rename\" : {\n\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\"label\"\t\t\t\t: \"Rename\",\n\t\t\t\t\t\"action\"\t\t\t: function (obj) { this.rename(obj); }\n\t\t\t\t},\n\t\t\t\t\"remove\" : {\n\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\"icon\"\t\t\t\t: false,\n\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\"label\"\t\t\t\t: \"Delete\",\n\t\t\t\t\t\"action\"\t\t\t: function (obj) { if(this.is_selected(obj)) { this.remove(); } else { this.remove(obj); } }\n\t\t\t\t},\n\t\t\t\t\"ccp\" : {\n\t\t\t\t\t\"separator_before\"\t: true,\n\t\t\t\t\t\"icon\"\t\t\t\t: false,\n\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\"label\"\t\t\t\t: \"Edit\",\n\t\t\t\t\t\"action\"\t\t\t: false,\n\t\t\t\t\t\"submenu\" : {\n\t\t\t\t\t\t\"cut\" : {\n\t\t\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\t\t\"label\"\t\t\t\t: \"Cut\",\n\t\t\t\t\t\t\t\"action\"\t\t\t: function (obj) { this.cut(obj); }\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"copy\" : {\n\t\t\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\t\t\"icon\"\t\t\t\t: false,\n\t\t\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\t\t\"label\"\t\t\t\t: \"Copy\",\n\t\t\t\t\t\t\t\"action\"\t\t\t: function (obj) { this.copy(obj); }\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"paste\" : {\n\t\t\t\t\t\t\t\"separator_before\"\t: false,\n\t\t\t\t\t\t\t\"icon\"\t\t\t\t: false,\n\t\t\t\t\t\t\t\"separator_after\"\t: false,\n\t\t\t\t\t\t\t\"label\"\t\t\t\t: \"Paste\",\n\t\t\t\t\t\t\t\"action\"\t\t\t: function (obj) { this.paste(obj); }\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t_fn : {\n\t\t\tshow_contextmenu : function (obj, x, y) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar s = this.get_settings().contextmenu,\n\t\t\t\t\ta = obj.children(\"a:visible:eq(0)\"),\n\t\t\t\t\to = false,\n\t\t\t\t\ti = false;\n\t\t\t\tif(s.select_node && this.data.ui && !this.is_selected(obj)) {\n\t\t\t\t\tthis.deselect_all();\n\t\t\t\t\tthis.select_node(obj, true);\n\t\t\t\t}\n\t\t\t\tif(s.show_at_node || typeof x === \"undefined\" || typeof y === \"undefined\") {\n\t\t\t\t\to = a.offset();\n\t\t\t\t\tx = o.left;\n\t\t\t\t\ty = o.top + this.data.core.li_height;\n\t\t\t\t}\n\t\t\t\ti = obj.data(\"jstree\") && obj.data(\"jstree\").contextmenu ? obj.data(\"jstree\").contextmenu : s.items;\n\t\t\t\tif($.isFunction(i)) { i = i.call(this, obj); }\n\t\t\t\tthis.data.contextmenu = true;\n\t\t\t\t$.vakata.context.show(i, a, x, y, this, obj, this._get_settings().core.rtl);\n\t\t\t\tif(this.data.themes) { $.vakata.context.cnt.attr(\"class\", \"jstree-\" + this.data.themes.theme + \"-context\"); }\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree types plugin\n * Adds support types of nodes\n * You can set an attribute on each li node, that represents its type.\n * According to the type setting the node may get custom icon/validation rules\n */\n(function ($) {\n\t$.jstree.plugin(\"types\", {\n\t\t__init : function () {\n\t\t\tvar s = this._get_settings().types;\n\t\t\tthis.data.types.attach_to = [];\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"init.jstree\", $.proxy(function () {\n\t\t\t\t\t\tvar types = s.types,\n\t\t\t\t\t\t\tattr  = s.type_attr,\n\t\t\t\t\t\t\ticons_css = \"\",\n\t\t\t\t\t\t\t_this = this;\n\n\t\t\t\t\t\t$.each(types, function (i, tp) {\n\t\t\t\t\t\t\t$.each(tp, function (k, v) {\n\t\t\t\t\t\t\t\tif(!/^(max_depth|max_children|icon|valid_children)$/.test(k)) { _this.data.types.attach_to.push(k); }\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\tif(!tp.icon) { return true; }\n\t\t\t\t\t\t\tif( tp.icon.image || tp.icon.position) {\n\t\t\t\t\t\t\t\tif(i == \"default\")\t{ icons_css += '.jstree-' + _this.get_index() + ' a > .jstree-icon { '; }\n\t\t\t\t\t\t\t\telse\t\t\t\t{ icons_css += '.jstree-' + _this.get_index() + ' li[' + attr + '=\"' + i + '\"] > a > .jstree-icon { '; }\n\t\t\t\t\t\t\t\tif(tp.icon.image)\t{ icons_css += ' background-image:url(' + tp.icon.image + '); '; }\n\t\t\t\t\t\t\t\tif(tp.icon.position){ icons_css += ' background-position:' + tp.icon.position + '; '; }\n\t\t\t\t\t\t\t\telse\t\t\t\t{ icons_css += ' background-position:0 0; '; }\n\t\t\t\t\t\t\t\ticons_css += '} ';\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t\tif(icons_css !== \"\") { $.vakata.css.add_sheet({ 'str' : icons_css, title : \"jstree-types\" }); }\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"before.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tvar s, t,\n\t\t\t\t\t\t\to = this._get_settings().types.use_data ? this._get_node(data.args[0]) : false,\n\t\t\t\t\t\t\td = o && o !== -1 && o.length ? o.data(\"jstree\") : false;\n\t\t\t\t\t\tif(d && d.types && d.types[data.func] === false) { e.stopImmediatePropagation(); return false; }\n\t\t\t\t\t\tif($.inArray(data.func, this.data.types.attach_to) !== -1) {\n\t\t\t\t\t\t\tif(!data.args[0] || (!data.args[0].tagName && !data.args[0].jquery)) { return; }\n\t\t\t\t\t\t\ts = this._get_settings().types.types;\n\t\t\t\t\t\t\tt = this._get_type(data.args[0]);\n\t\t\t\t\t\t\tif(\n\t\t\t\t\t\t\t\t(\n\t\t\t\t\t\t\t\t\t(s[t] && typeof s[t][data.func] !== \"undefined\") ||\n\t\t\t\t\t\t\t\t\t(s[\"default\"] && typeof s[\"default\"][data.func] !== \"undefined\")\n\t\t\t\t\t\t\t\t) && this._check(data.func, data.args[0]) === false\n\t\t\t\t\t\t\t) {\n\t\t\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t\tif(is_ie6) {\n\t\t\t\tthis.get_container()\n\t\t\t\t\t.bind(\"load_node.jstree set_type.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\t\tvar r = data && data.rslt && data.rslt.obj && data.rslt.obj !== -1 ? this._get_node(data.rslt.obj).parent() : this.get_container_ul(),\n\t\t\t\t\t\t\t\tc = false,\n\t\t\t\t\t\t\t\ts = this._get_settings().types;\n\t\t\t\t\t\t\t$.each(s.types, function (i, tp) {\n\t\t\t\t\t\t\t\tif(tp.icon && (tp.icon.image || tp.icon.position)) {\n\t\t\t\t\t\t\t\t\tc = i === \"default\" ? r.find(\"li > a > .jstree-icon\") : r.find(\"li[\" + s.type_attr + \"='\" + i + \"'] > a > .jstree-icon\");\n\t\t\t\t\t\t\t\t\tif(tp.icon.image) { c.css(\"backgroundImage\",\"url(\" + tp.icon.image + \")\"); }\n\t\t\t\t\t\t\t\t\tc.css(\"backgroundPosition\", tp.icon.position || \"0 0\");\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}, this));\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t\t// defines maximum number of root nodes (-1 means unlimited, -2 means disable max_children checking)\n\t\t\tmax_children\t\t: -1,\n\t\t\t// defines the maximum depth of the tree (-1 means unlimited, -2 means disable max_depth checking)\n\t\t\tmax_depth\t\t\t: -1,\n\t\t\t// defines valid node types for the root nodes\n\t\t\tvalid_children\t\t: \"all\",\n\n\t\t\t// whether to use $.data\n\t\t\tuse_data : false,\n\t\t\t// where is the type stores (the rel attribute of the LI element)\n\t\t\ttype_attr : \"rel\",\n\t\t\t// a list of types\n\t\t\ttypes : {\n\t\t\t\t// the default type\n\t\t\t\t\"default\" : {\n\t\t\t\t\t\"max_children\"\t: -1,\n\t\t\t\t\t\"max_depth\"\t\t: -1,\n\t\t\t\t\t\"valid_children\": \"all\"\n\n\t\t\t\t\t// Bound functions - you can bind any other function here (using boolean or function)\n\t\t\t\t\t//\"select_node\"\t: true\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t_fn : {\n\t\t\t_types_notify : function (n, data) {\n\t\t\t\tif(data.type && this._get_settings().types.use_data) {\n\t\t\t\t\tthis.set_type(data.type, n);\n\t\t\t\t}\n\t\t\t},\n\t\t\t_get_type : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\treturn (!obj || !obj.length) ? false : obj.attr(this._get_settings().types.type_attr) || \"default\";\n\t\t\t},\n\t\t\tset_type : function (str, obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar ret = (!obj.length || !str) ? false : obj.attr(this._get_settings().types.type_attr, str);\n\t\t\t\tif(ret) { this.__callback({ obj : obj, type : str}); }\n\t\t\t\treturn ret;\n\t\t\t},\n\t\t\t_check : function (rule, obj, opts) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tvar v = false, t = this._get_type(obj), d = 0, _this = this, s = this._get_settings().types, data = false;\n\t\t\t\tif(obj === -1) {\n\t\t\t\t\tif(!!s[rule]) { v = s[rule]; }\n\t\t\t\t\telse { return; }\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tif(t === false) { return; }\n\t\t\t\t\tdata = s.use_data ? obj.data(\"jstree\") : false;\n\t\t\t\t\tif(data && data.types && typeof data.types[rule] !== \"undefined\") { v = data.types[rule]; }\n\t\t\t\t\telse if(!!s.types[t] && typeof s.types[t][rule] !== \"undefined\") { v = s.types[t][rule]; }\n\t\t\t\t\telse if(!!s.types[\"default\"] && typeof s.types[\"default\"][rule] !== \"undefined\") { v = s.types[\"default\"][rule]; }\n\t\t\t\t}\n\t\t\t\tif($.isFunction(v)) { v = v.call(this, obj); }\n\t\t\t\tif(rule === \"max_depth\" && obj !== -1 && opts !== false && s.max_depth !== -2 && v !== 0) {\n\t\t\t\t\t// also include the node itself - otherwise if root node it is not checked\n\t\t\t\t\tobj.children(\"a:eq(0)\").parentsUntil(\".jstree\",\"li\").each(function (i) {\n\t\t\t\t\t\t// check if current depth already exceeds global tree depth\n\t\t\t\t\t\tif(s.max_depth !== -1 && s.max_depth - (i + 1) <= 0) { v = 0; return false; }\n\t\t\t\t\t\td = (i === 0) ? v : _this._check(rule, this, false);\n\t\t\t\t\t\t// check if current node max depth is already matched or exceeded\n\t\t\t\t\t\tif(d !== -1 && d - (i + 1) <= 0) { v = 0; return false; }\n\t\t\t\t\t\t// otherwise - set the max depth to the current value minus current depth\n\t\t\t\t\t\tif(d >= 0 && (d - (i + 1) < v || v < 0) ) { v = d - (i + 1); }\n\t\t\t\t\t\t// if the global tree depth exists and it minus the nodes calculated so far is less than `v` or `v` is unlimited\n\t\t\t\t\t\tif(s.max_depth >= 0 && (s.max_depth - (i + 1) < v || v < 0) ) { v = s.max_depth - (i + 1); }\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t\treturn v;\n\t\t\t},\n\t\t\tcheck_move : function () {\n\t\t\t\tif(!this.__call_old()) { return false; }\n\t\t\t\tvar m  = this._get_move(),\n\t\t\t\t\ts  = m.rt._get_settings().types,\n\t\t\t\t\tmc = m.rt._check(\"max_children\", m.cr),\n\t\t\t\t\tmd = m.rt._check(\"max_depth\", m.cr),\n\t\t\t\t\tvc = m.rt._check(\"valid_children\", m.cr),\n\t\t\t\t\tch = 0, d = 1, t;\n\n\t\t\t\tif(vc === \"none\") { return false; }\n\t\t\t\tif($.isArray(vc) && m.ot && m.ot._get_type) {\n\t\t\t\t\tm.o.each(function () {\n\t\t\t\t\t\tif($.inArray(m.ot._get_type(this), vc) === -1) { d = false; return false; }\n\t\t\t\t\t});\n\t\t\t\t\tif(d === false) { return false; }\n\t\t\t\t}\n\t\t\t\tif(s.max_children !== -2 && mc !== -1) {\n\t\t\t\t\tch = m.cr === -1 ? this.get_container().find(\"> ul > li\").not(m.o).length : m.cr.find(\"> ul > li\").not(m.o).length;\n\t\t\t\t\tif(ch + m.o.length > mc) { return false; }\n\t\t\t\t}\n\t\t\t\tif(s.max_depth !== -2 && md !== -1) {\n\t\t\t\t\td = 0;\n\t\t\t\t\tif(md === 0) { return false; }\n\t\t\t\t\tif(typeof m.o.d === \"undefined\") {\n\t\t\t\t\t\t// TODO: deal with progressive rendering and async when checking max_depth (how to know the depth of the moved node)\n\t\t\t\t\t\tt = m.o;\n\t\t\t\t\t\twhile(t.length > 0) {\n\t\t\t\t\t\t\tt = t.find(\"> ul > li\");\n\t\t\t\t\t\t\td ++;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tm.o.d = d;\n\t\t\t\t\t}\n\t\t\t\t\tif(md - m.o.d < 0) { return false; }\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\tcreate_node : function (obj, position, js, callback, is_loaded, skip_check) {\n\t\t\t\tif(!skip_check && (is_loaded || this._is_loaded(obj))) {\n\t\t\t\t\tvar p  = (typeof position == \"string\" && position.match(/^before|after$/i) && obj !== -1) ? this._get_parent(obj) : this._get_node(obj),\n\t\t\t\t\t\ts  = this._get_settings().types,\n\t\t\t\t\t\tmc = this._check(\"max_children\", p),\n\t\t\t\t\t\tmd = this._check(\"max_depth\", p),\n\t\t\t\t\t\tvc = this._check(\"valid_children\", p),\n\t\t\t\t\t\tch;\n\t\t\t\t\tif(typeof js === \"string\") { js = { data : js }; }\n\t\t\t\t\tif(!js) { js = {}; }\n\t\t\t\t\tif(vc === \"none\") { return false; }\n\t\t\t\t\tif($.isArray(vc)) {\n\t\t\t\t\t\tif(!js.attr || !js.attr[s.type_attr]) {\n\t\t\t\t\t\t\tif(!js.attr) { js.attr = {}; }\n\t\t\t\t\t\t\tjs.attr[s.type_attr] = vc[0];\n\t\t\t\t\t\t}\n\t\t\t\t\t\telse {\n\t\t\t\t\t\t\tif($.inArray(js.attr[s.type_attr], vc) === -1) { return false; }\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tif(s.max_children !== -2 && mc !== -1) {\n\t\t\t\t\t\tch = p === -1 ? this.get_container().find(\"> ul > li\").length : p.find(\"> ul > li\").length;\n\t\t\t\t\t\tif(ch + 1 > mc) { return false; }\n\t\t\t\t\t}\n\t\t\t\t\tif(s.max_depth !== -2 && md !== -1 && (md - 1) < 0) { return false; }\n\t\t\t\t}\n\t\t\t\treturn this.__call_old(true, obj, position, js, callback, is_loaded, skip_check);\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree HTML plugin\n * The HTML data store. Datastores are build by replacing the `load_node` and `_is_loaded` functions.\n */\n(function ($) {\n\t$.jstree.plugin(\"html_data\", {\n\t\t__init : function () {\n\t\t\t// this used to use html() and clean the whitespace, but this way any attached data was lost\n\t\t\tthis.data.html_data.original_container_html = this.get_container().find(\" > ul > li\").clone(true);\n\t\t\t// remove white space from LI node - otherwise nodes appear a bit to the right\n\t\t\tthis.data.html_data.original_container_html.find(\"li\").addBack().contents().filter(function() { return this.nodeType == 3; }).remove();\n\t\t},\n\t\tdefaults : {\n\t\t\tdata : false,\n\t\t\tajax : false,\n\t\t\tcorrect_state : true\n\t\t},\n\t\t_fn : {\n\t\t\tload_node : function (obj, s_call, e_call) { var _this = this; this.load_node_html(obj, function () { _this.__callback({ \"obj\" : _this._get_node(obj) }); s_call.call(this); }, e_call); },\n\t\t\t_is_loaded : function (obj) {\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\treturn obj == -1 || !obj || (!this._get_settings().html_data.ajax && !$.isFunction(this._get_settings().html_data.data)) || obj.is(\".jstree-open, .jstree-leaf\") || obj.children(\"ul\").children(\"li\").size() > 0;\n\t\t\t},\n\t\t\tload_node_html : function (obj, s_call, e_call) {\n\t\t\t\tvar d,\n\t\t\t\t\ts = this.get_settings().html_data,\n\t\t\t\t\terror_func = function () {},\n\t\t\t\t\tsuccess_func = function () {};\n\t\t\t\tobj = this._get_node(obj);\n\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\tif(obj.data(\"jstree_is_loading\")) { return; }\n\t\t\t\t\telse { obj.data(\"jstree_is_loading\",true); }\n\t\t\t\t}\n\t\t\t\tswitch(!0) {\n\t\t\t\t\tcase ($.isFunction(s.data)):\n\t\t\t\t\t\ts.data.call(this, obj, $.proxy(function (d) {\n\t\t\t\t\t\t\tif(d && d !== \"\" && d.toString && d.toString().replace(/^[\\s\\n]+$/,\"\") !== \"\") {\n\t\t\t\t\t\t\t\td = $(d);\n\t\t\t\t\t\t\t\tif(!d.is(\"ul\")) { d = $(\"<ul />\").append(d); }\n\t\t\t\t\t\t\t\tif(obj == -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()).find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end().filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\"); }\n\t\t\t\t\t\t\t\telse { obj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.append(d).children(\"ul\").find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end().filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\"); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\tthis.clean_node(obj);\n\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.correct_state(obj);\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, this));\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!s.data && !s.ajax):\n\t\t\t\t\t\tif(!obj || obj == -1) {\n\t\t\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t\t\t.children(\"ul\").empty()\n\t\t\t\t\t\t\t\t.append(this.data.html_data.original_container_html)\n\t\t\t\t\t\t\t\t.find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end()\n\t\t\t\t\t\t\t\t.filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\");\n\t\t\t\t\t\t\tthis.clean_node();\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!!s.data && !s.ajax) || (!!s.data && !!s.ajax && (!obj || obj === -1)):\n\t\t\t\t\t\tif(!obj || obj == -1) {\n\t\t\t\t\t\t\td = $(s.data);\n\t\t\t\t\t\t\tif(!d.is(\"ul\")) { d = $(\"<ul />\").append(d); }\n\t\t\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t\t\t.children(\"ul\").empty().append(d.children())\n\t\t\t\t\t\t\t\t.find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end()\n\t\t\t\t\t\t\t\t.filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\");\n\t\t\t\t\t\t\tthis.clean_node();\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase (!s.data && !!s.ajax) || (!!s.data && !!s.ajax && obj && obj !== -1):\n\t\t\t\t\t\tobj = this._get_node(obj);\n\t\t\t\t\t\terror_func = function (x, t, e) {\n\t\t\t\t\t\t\tvar ef = this.get_settings().html_data.ajax.error;\n\t\t\t\t\t\t\tif(ef) { ef.call(this, x, t, e); }\n\t\t\t\t\t\t\tif(obj != -1 && obj.length) {\n\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.correct_state(obj); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(t === \"success\" && s.correct_state) { this.get_container().children(\"ul\").empty(); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(e_call) { e_call.call(this); }\n\t\t\t\t\t\t};\n\t\t\t\t\t\tsuccess_func = function (d, t, x) {\n\t\t\t\t\t\t\tvar sf = this.get_settings().html_data.ajax.success;\n\t\t\t\t\t\t\tif(sf) { d = sf.call(this,d,t,x) || d; }\n\t\t\t\t\t\t\tif(d === \"\" || (d && d.toString && d.toString().replace(/^[\\s\\n]+$/,\"\") === \"\")) {\n\t\t\t\t\t\t\t\treturn error_func.call(this, x, t, \"\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(d) {\n\t\t\t\t\t\t\t\td = $(d);\n\t\t\t\t\t\t\t\tif(!d.is(\"ul\")) { d = $(\"<ul />\").append(d); }\n\t\t\t\t\t\t\t\tif(obj == -1 || !obj) { this.get_container().children(\"ul\").empty().append(d.children()).find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end().filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\"); }\n\t\t\t\t\t\t\t\telse { obj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\"); obj.append(d).children(\"ul\").find(\"li, a\").filter(function () { return !this.firstChild || !this.firstChild.tagName || this.firstChild.tagName !== \"INS\"; }).prepend(\"<ins class='jstree-icon'>&#160;</ins>\").end().filter(\"a\").children(\"ins:first-child\").not(\".jstree-icon\").addClass(\"jstree-icon\"); obj.removeData(\"jstree_is_loading\"); }\n\t\t\t\t\t\t\t\tthis.clean_node(obj);\n\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\tif(obj && obj !== -1) {\n\t\t\t\t\t\t\t\t\tobj.children(\"a.jstree-loading\").removeClass(\"jstree-loading\");\n\t\t\t\t\t\t\t\t\tobj.removeData(\"jstree_is_loading\");\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.correct_state(obj);\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\tif(s.correct_state) {\n\t\t\t\t\t\t\t\t\t\tthis.get_container().children(\"ul\").empty();\n\t\t\t\t\t\t\t\t\t\tif(s_call) { s_call.call(this); }\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t};\n\t\t\t\t\t\ts.ajax.context = this;\n\t\t\t\t\t\ts.ajax.error = error_func;\n\t\t\t\t\t\ts.ajax.success = success_func;\n\t\t\t\t\t\tif(!s.ajax.dataType) { s.ajax.dataType = \"html\"; }\n\t\t\t\t\t\tif($.isFunction(s.ajax.url)) { s.ajax.url = s.ajax.url.call(this, obj); }\n\t\t\t\t\t\tif($.isFunction(s.ajax.data)) { s.ajax.data = s.ajax.data.call(this, obj); }\n\t\t\t\t\t\t$.ajax(s.ajax);\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\t// include the HTML data plugin by default\n\t$.jstree.defaults.plugins.push(\"html_data\");\n})(jQuery);\n//*/\n\n/*\n * jsTree themeroller plugin\n * Adds support for jQuery UI themes. Include this at the end of your plugins list, also make sure \"themes\" is not included.\n */\n(function ($) {\n\t$.jstree.plugin(\"themeroller\", {\n\t\t__init : function () {\n\t\t\tvar s = this._get_settings().themeroller;\n\t\t\tthis.get_container()\n\t\t\t\t.addClass(\"ui-widget-content\")\n\t\t\t\t.addClass(\"jstree-themeroller\")\n\t\t\t\t.delegate(\"a\",\"mouseenter.jstree\", function (e) {\n\t\t\t\t\tif(!$(e.currentTarget).hasClass(\"jstree-loading\")) {\n\t\t\t\t\t\t$(this).addClass(s.item_h);\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t\t\t.delegate(\"a\",\"mouseleave.jstree\", function () {\n\t\t\t\t\t$(this).removeClass(s.item_h);\n\t\t\t\t})\n\t\t\t\t.bind(\"init.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tdata.inst.get_container().find(\"> ul > li > .jstree-loading > ins\").addClass(\"ui-icon-refresh\");\n\t\t\t\t\t\tthis._themeroller(data.inst.get_container().find(\"> ul > li\"));\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"open_node.jstree create_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._themeroller(data.rslt.obj);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"loaded.jstree refresh.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tthis._themeroller();\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"close_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._themeroller(data.rslt.obj);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"delete_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._themeroller(data.rslt.parent);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"correct_state.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tdata.rslt.obj\n\t\t\t\t\t\t\t.children(\"ins.jstree-icon\").removeClass(s.opened + \" \" + s.closed + \" ui-icon\").end()\n\t\t\t\t\t\t\t.find(\"> a > ins.ui-icon\")\n\t\t\t\t\t\t\t\t.filter(function() {\n\t\t\t\t\t\t\t\t\treturn this.className.toString()\n\t\t\t\t\t\t\t\t\t\t.replace(s.item_clsd,\"\").replace(s.item_open,\"\").replace(s.item_leaf,\"\")\n\t\t\t\t\t\t\t\t\t\t.indexOf(\"ui-icon-\") === -1;\n\t\t\t\t\t\t\t\t}).removeClass(s.item_open + \" \" + s.item_clsd).addClass(s.item_leaf || \"jstree-no-icon\");\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"select_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tdata.rslt.obj.children(\"a\").addClass(s.item_a);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"deselect_node.jstree deselect_all.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t\t.find(\"a.\" + s.item_a).removeClass(s.item_a).end()\n\t\t\t\t\t\t\t.find(\"a.jstree-clicked\").addClass(s.item_a);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"dehover_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tdata.rslt.obj.children(\"a\").removeClass(s.item_h);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"hover_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis.get_container()\n\t\t\t\t\t\t\t.find(\"a.\" + s.item_h).not(data.rslt.obj).removeClass(s.item_h);\n\t\t\t\t\t\tdata.rslt.obj.children(\"a\").addClass(s.item_h);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"move_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._themeroller(data.rslt.o);\n\t\t\t\t\t\tthis._themeroller(data.rslt.op);\n\t\t\t\t\t}, this));\n\t\t},\n\t\t__destroy : function () {\n\t\t\tvar s = this._get_settings().themeroller,\n\t\t\t\tc = [ \"ui-icon\" ];\n\t\t\t$.each(s, function (i, v) {\n\t\t\t\tv = v.split(\" \");\n\t\t\t\tif(v.length) { c = c.concat(v); }\n\t\t\t});\n\t\t\tthis.get_container()\n\t\t\t\t.removeClass(\"ui-widget-content\")\n\t\t\t\t.find(\".\" + c.join(\", .\")).removeClass(c.join(\" \"));\n\t\t},\n\t\t_fn : {\n\t\t\t_themeroller : function (obj) {\n\t\t\t\tvar s = this._get_settings().themeroller;\n\t\t\t\tobj = !obj || obj == -1 ? this.get_container_ul() : this._get_node(obj).parent();\n\t\t\t\tobj\n\t\t\t\t\t.find(\"li.jstree-closed\")\n\t\t\t\t\t\t.children(\"ins.jstree-icon\").removeClass(s.opened).addClass(\"ui-icon \" + s.closed).end()\n\t\t\t\t\t\t.children(\"a\").addClass(s.item)\n\t\t\t\t\t\t\t.children(\"ins.jstree-icon\").addClass(\"ui-icon\")\n\t\t\t\t\t\t\t\t.filter(function() {\n\t\t\t\t\t\t\t\t\treturn this.className.toString()\n\t\t\t\t\t\t\t\t\t\t.replace(s.item_clsd,\"\").replace(s.item_open,\"\").replace(s.item_leaf,\"\")\n\t\t\t\t\t\t\t\t\t\t.indexOf(\"ui-icon-\") === -1;\n\t\t\t\t\t\t\t\t}).removeClass(s.item_leaf + \" \" + s.item_open).addClass(s.item_clsd || \"jstree-no-icon\")\n\t\t\t\t\t\t\t\t.end()\n\t\t\t\t\t\t\t.end()\n\t\t\t\t\t\t.end()\n\t\t\t\t\t.end()\n\t\t\t\t\t.find(\"li.jstree-open\")\n\t\t\t\t\t\t.children(\"ins.jstree-icon\").removeClass(s.closed).addClass(\"ui-icon \" + s.opened).end()\n\t\t\t\t\t\t.children(\"a\").addClass(s.item)\n\t\t\t\t\t\t\t.children(\"ins.jstree-icon\").addClass(\"ui-icon\")\n\t\t\t\t\t\t\t\t.filter(function() {\n\t\t\t\t\t\t\t\t\treturn this.className.toString()\n\t\t\t\t\t\t\t\t\t\t.replace(s.item_clsd,\"\").replace(s.item_open,\"\").replace(s.item_leaf,\"\")\n\t\t\t\t\t\t\t\t\t\t.indexOf(\"ui-icon-\") === -1;\n\t\t\t\t\t\t\t\t}).removeClass(s.item_leaf + \" \" + s.item_clsd).addClass(s.item_open || \"jstree-no-icon\")\n\t\t\t\t\t\t\t\t.end()\n\t\t\t\t\t\t\t.end()\n\t\t\t\t\t\t.end()\n\t\t\t\t\t.end()\n\t\t\t\t\t.find(\"li.jstree-leaf\")\n\t\t\t\t\t\t.children(\"ins.jstree-icon\").removeClass(s.closed + \" ui-icon \" + s.opened).end()\n\t\t\t\t\t\t.children(\"a\").addClass(s.item)\n\t\t\t\t\t\t\t.children(\"ins.jstree-icon\").addClass(\"ui-icon\")\n\t\t\t\t\t\t\t\t.filter(function() {\n\t\t\t\t\t\t\t\t\treturn this.className.toString()\n\t\t\t\t\t\t\t\t\t\t.replace(s.item_clsd,\"\").replace(s.item_open,\"\").replace(s.item_leaf,\"\")\n\t\t\t\t\t\t\t\t\t\t.indexOf(\"ui-icon-\") === -1;\n\t\t\t\t\t\t\t\t}).removeClass(s.item_clsd + \" \" + s.item_open).addClass(s.item_leaf || \"jstree-no-icon\");\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t\t\"opened\"\t: \"ui-icon-triangle-1-se\",\n\t\t\t\"closed\"\t: \"ui-icon-triangle-1-e\",\n\t\t\t\"item\"\t\t: \"ui-state-default\",\n\t\t\t\"item_h\"\t: \"ui-state-hover\",\n\t\t\t\"item_a\"\t: \"ui-state-active\",\n\t\t\t\"item_open\"\t: \"ui-icon-folder-open\",\n\t\t\t\"item_clsd\"\t: \"ui-icon-folder-collapsed\",\n\t\t\t\"item_leaf\"\t: \"ui-icon-document\"\n\t\t}\n\t});\n\t$(function() {\n\t\tvar css_string = '' +\n\t\t\t'.jstree-themeroller .ui-icon { overflow:visible; } ' +\n\t\t\t'.jstree-themeroller a { padding:0 2px; } ' +\n\t\t\t'.jstree-themeroller .jstree-no-icon { display:none; }';\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree unique plugin\n * Forces different names amongst siblings (still a bit experimental)\n * NOTE: does not check language versions (it will not be possible to have nodes with the same title, even in different languages)\n */\n(function ($) {\n\t$.jstree.plugin(\"unique\", {\n\t\t__init : function () {\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"before.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tvar nms = [], res = true, p, t;\n\t\t\t\t\t\tif(data.func == \"move_node\") {\n\t\t\t\t\t\t\t// obj, ref, position, is_copy, is_prepared, skip_check\n\t\t\t\t\t\t\tif(data.args[4] === true) {\n\t\t\t\t\t\t\t\tif(data.args[0].o && data.args[0].o.length) {\n\t\t\t\t\t\t\t\t\tdata.args[0].o.children(\"a\").each(function () { nms.push($(this).text().replace(/^\\s+/g,\"\")); });\n\t\t\t\t\t\t\t\t\tres = this._check_unique(nms, data.args[0].np.find(\"> ul > li\").not(data.args[0].o), \"move_node\");\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(data.func == \"create_node\") {\n\t\t\t\t\t\t\t// obj, position, js, callback, is_loaded\n\t\t\t\t\t\t\tif(data.args[4] || this._is_loaded(data.args[0])) {\n\t\t\t\t\t\t\t\tp = this._get_node(data.args[0]);\n\t\t\t\t\t\t\t\tif(data.args[1] && (data.args[1] === \"before\" || data.args[1] === \"after\")) {\n\t\t\t\t\t\t\t\t\tp = this._get_parent(data.args[0]);\n\t\t\t\t\t\t\t\t\tif(!p || p === -1) { p = this.get_container(); }\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\tif(typeof data.args[2] === \"string\") { nms.push(data.args[2]); }\n\t\t\t\t\t\t\t\telse if(!data.args[2] || !data.args[2].data) { nms.push(this._get_string(\"new_node\")); }\n\t\t\t\t\t\t\t\telse { nms.push(data.args[2].data); }\n\t\t\t\t\t\t\t\tres = this._check_unique(nms, p.find(\"> ul > li\"), \"create_node\");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(data.func == \"rename_node\") {\n\t\t\t\t\t\t\t// obj, val\n\t\t\t\t\t\t\tnms.push(data.args[1]);\n\t\t\t\t\t\t\tt = this._get_node(data.args[0]);\n\t\t\t\t\t\t\tp = this._get_parent(t);\n\t\t\t\t\t\t\tif(!p || p === -1) { p = this.get_container(); }\n\t\t\t\t\t\t\tres = this._check_unique(nms, p.find(\"> ul > li\").not(t), \"rename_node\");\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif(!res) {\n\t\t\t\t\t\t\te.stopPropagation();\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this));\n\t\t},\n\t\tdefaults : {\n\t\t\terror_callback : $.noop\n\t\t},\n\t\t_fn : {\n\t\t\t_check_unique : function (nms, p, func) {\n\t\t\t\tvar cnms = [];\n\t\t\t\tp.children(\"a\").each(function () { cnms.push($(this).text().replace(/^\\s+/g,\"\")); });\n\t\t\t\tif(!cnms.length || !nms.length) { return true; }\n\t\t\t\tcnms = cnms.sort().join(\",,\").replace(/(,|^)([^,]+)(,,\\2)+(,|$)/g,\"$1$2$4\").replace(/,,+/g,\",\").replace(/,$/,\"\").split(\",\");\n\t\t\t\tif((cnms.length + nms.length) != cnms.concat(nms).sort().join(\",,\").replace(/(,|^)([^,]+)(,,\\2)+(,|$)/g,\"$1$2$4\").replace(/,,+/g,\",\").replace(/,$/,\"\").split(\",\").length) {\n\t\t\t\t\tthis._get_settings().unique.error_callback.call(null, nms, p, func);\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t},\n\t\t\tcheck_move : function () {\n\t\t\t\tif(!this.__call_old()) { return false; }\n\t\t\t\tvar p = this._get_move(), nms = [];\n\t\t\t\tif(p.o && p.o.length) {\n\t\t\t\t\tp.o.children(\"a\").each(function () { nms.push($(this).text().replace(/^\\s+/g,\"\")); });\n\t\t\t\t\treturn this._check_unique(nms, p.np.find(\"> ul > li\").not(p.o), \"check_move\");\n\t\t\t\t}\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n/*\n * jsTree wholerow plugin\n * Makes select and hover work on the entire width of the node\n * MAY BE HEAVY IN LARGE DOM\n */\n(function ($) {\n\t$.jstree.plugin(\"wholerow\", {\n\t\t__init : function () {\n\t\t\tif(!this.data.ui) { throw \"jsTree wholerow: jsTree UI plugin not included.\"; }\n\t\t\tthis.data.wholerow.html = false;\n\t\t\tthis.data.wholerow.to = false;\n\t\t\tthis.get_container()\n\t\t\t\t.bind(\"init.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._get_settings().core.animation = 0;\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"open_node.jstree create_node.jstree clean_node.jstree loaded.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis._prepare_wholerow_span( data && data.rslt && data.rslt.obj ? data.rslt.obj : -1 );\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"search.jstree clear_search.jstree reopen.jstree after_open.jstree after_close.jstree create_node.jstree delete_node.jstree clean_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tif(this.data.to) { clearTimeout(this.data.to); }\n\t\t\t\t\t\tthis.data.to = setTimeout( (function (t, o) { return function() { t._prepare_wholerow_ul(o); }; })(this,  data && data.rslt && data.rslt.obj ? data.rslt.obj : -1), 0);\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"deselect_all.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis.get_container().find(\" > .jstree-wholerow .jstree-clicked\").removeClass(\"jstree-clicked \" + (this.data.themeroller ? this._get_settings().themeroller.item_a : \"\" ));\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"select_node.jstree deselect_node.jstree \", $.proxy(function (e, data) {\n\t\t\t\t\t\tdata.rslt.obj.each(function () {\n\t\t\t\t\t\t\tvar ref = data.inst.get_container().find(\" > .jstree-wholerow li:visible:eq(\" + ( parseInt((($(this).offset().top - data.inst.get_container().offset().top + data.inst.get_container()[0].scrollTop) / data.inst.data.core.li_height),10)) + \")\");\n\t\t\t\t\t\t\t// ref.children(\"a\")[e.type === \"select_node\" ? \"addClass\" : \"removeClass\"](\"jstree-clicked\");\n\t\t\t\t\t\t\tref.children(\"a\").attr(\"class\",data.rslt.obj.children(\"a\").attr(\"class\"));\n\t\t\t\t\t\t});\n\t\t\t\t\t}, this))\n\t\t\t\t.bind(\"hover_node.jstree dehover_node.jstree\", $.proxy(function (e, data) {\n\t\t\t\t\t\tthis.get_container().find(\" > .jstree-wholerow .jstree-hovered\").removeClass(\"jstree-hovered \" + (this.data.themeroller ? this._get_settings().themeroller.item_h : \"\" ));\n\t\t\t\t\t\tif(e.type === \"hover_node\") {\n\t\t\t\t\t\t\tvar ref = this.get_container().find(\" > .jstree-wholerow li:visible:eq(\" + ( parseInt(((data.rslt.obj.offset().top - this.get_container().offset().top + this.get_container()[0].scrollTop) / this.data.core.li_height),10)) + \")\");\n\t\t\t\t\t\t\t// ref.children(\"a\").addClass(\"jstree-hovered\");\n\t\t\t\t\t\t\tref.children(\"a\").attr(\"class\",data.rslt.obj.children(\".jstree-hovered\").attr(\"class\"));\n\t\t\t\t\t\t}\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\".jstree-wholerow-span, ins.jstree-icon, li\", \"click.jstree\", function (e) {\n\t\t\t\t\t\tvar n = $(e.currentTarget);\n\t\t\t\t\t\tif(e.target.tagName === \"A\" || (e.target.tagName === \"INS\" && n.closest(\"li\").is(\".jstree-open, .jstree-closed\"))) { return; }\n\t\t\t\t\t\tn.closest(\"li\").children(\"a:visible:eq(0)\").click();\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t})\n\t\t\t\t.delegate(\"li\", \"mouseover.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\te.stopImmediatePropagation();\n\t\t\t\t\t\tif($(e.currentTarget).children(\".jstree-hovered, .jstree-clicked\").length) { return false; }\n\t\t\t\t\t\tthis.hover_node(e.currentTarget);\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}, this))\n\t\t\t\t.delegate(\"li\", \"mouseleave.jstree\", $.proxy(function (e) {\n\t\t\t\t\t\tif($(e.currentTarget).children(\"a\").hasClass(\"jstree-hovered\").length) { return; }\n\t\t\t\t\t\tthis.dehover_node(e.currentTarget);\n\t\t\t\t\t}, this));\n\t\t\tif(is_ie7 || is_ie6) {\n\t\t\t\t$.vakata.css.add_sheet({ str : \".jstree-\" + this.get_index() + \" { position:relative; } \", title : \"jstree\" });\n\t\t\t}\n\t\t},\n\t\tdefaults : {\n\t\t},\n\t\t__destroy : function () {\n\t\t\tthis.get_container().children(\".jstree-wholerow\").remove();\n\t\t\tthis.get_container().find(\".jstree-wholerow-span\").remove();\n\t\t},\n\t\t_fn : {\n\t\t\t_prepare_wholerow_span : function (obj) {\n\t\t\t\tobj = !obj || obj == -1 ? this.get_container().find(\"> ul > li\") : this._get_node(obj);\n\t\t\t\tif(obj === false) { return; } // added for removing root nodes\n\t\t\t\tobj.each(function () {\n\t\t\t\t\t$(this).find(\"li\").addBack().each(function () {\n\t\t\t\t\t\tvar $t = $(this);\n\t\t\t\t\t\tif($t.children(\".jstree-wholerow-span\").length) { return true; }\n\t\t\t\t\t\t$t.prepend(\"<span class='jstree-wholerow-span' style='width:\" + ($t.parentsUntil(\".jstree\",\"li\").length * 18) + \"px;'>&#160;</span>\");\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t},\n\t\t\t_prepare_wholerow_ul : function () {\n\t\t\t\tvar o = this.get_container().children(\"ul\").eq(0), h = o.html();\n\t\t\t\to.addClass(\"jstree-wholerow-real\");\n\t\t\t\tif(this.data.wholerow.last_html !== h) {\n\t\t\t\t\tthis.data.wholerow.last_html = h;\n\t\t\t\t\tthis.get_container().children(\".jstree-wholerow\").remove();\n\t\t\t\t\tthis.get_container().append(\n\t\t\t\t\t\to.clone().removeClass(\"jstree-wholerow-real\")\n\t\t\t\t\t\t\t.wrapAll(\"<div class='jstree-wholerow' />\").parent()\n\t\t\t\t\t\t\t.width(o.parent()[0].scrollWidth)\n\t\t\t\t\t\t\t.css(\"top\", (o.height() + ( is_ie7 ? 5 : 0)) * -1 )\n\t\t\t\t\t\t\t.find(\"li[id]\").each(function () { this.removeAttribute(\"id\"); }).end()\n\t\t\t\t\t);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n\t$(function() {\n\t\tvar css_string = '' +\n\t\t\t'.jstree .jstree-wholerow-real { position:relative; z-index:1; } ' +\n\t\t\t'.jstree .jstree-wholerow-real li { cursor:pointer; } ' +\n\t\t\t'.jstree .jstree-wholerow-real a { border-left-color:transparent !important; border-right-color:transparent !important; } ' +\n\t\t\t'.jstree .jstree-wholerow { position:relative; z-index:0; height:0; } ' +\n\t\t\t'.jstree .jstree-wholerow ul, .jstree .jstree-wholerow li { width:100%; } ' +\n\t\t\t'.jstree .jstree-wholerow, .jstree .jstree-wholerow ul, .jstree .jstree-wholerow li, .jstree .jstree-wholerow a { margin:0 !important; padding:0 !important; } ' +\n\t\t\t'.jstree .jstree-wholerow, .jstree .jstree-wholerow ul, .jstree .jstree-wholerow li { background:transparent !important; }' +\n\t\t\t'.jstree .jstree-wholerow ins, .jstree .jstree-wholerow span, .jstree .jstree-wholerow input { display:none !important; }' +\n\t\t\t'.jstree .jstree-wholerow a, .jstree .jstree-wholerow a:hover { text-indent:-9999px; !important; width:100%; padding:0 !important; border-right-width:0px !important; border-left-width:0px !important; } ' +\n\t\t\t'.jstree .jstree-wholerow-span { position:absolute; left:0; margin:0px; padding:0; height:18px; border-width:0; padding:0; z-index:0; }';\n\t\tif(is_ff2) {\n\t\t\tcss_string += '' +\n\t\t\t\t'.jstree .jstree-wholerow a { display:block; height:18px; margin:0; padding:0; border:0; } ' +\n\t\t\t\t'.jstree .jstree-wholerow-real a { border-color:transparent !important; } ';\n\t\t}\n\t\tif(is_ie7 || is_ie6) {\n\t\t\tcss_string += '' +\n\t\t\t\t'.jstree .jstree-wholerow, .jstree .jstree-wholerow li, .jstree .jstree-wholerow ul, .jstree .jstree-wholerow a { margin:0; padding:0; line-height:18px; } ' +\n\t\t\t\t'.jstree .jstree-wholerow a { display:block; height:18px; line-height:18px; overflow:hidden; } ';\n\t\t}\n\t\t$.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n\t});\n})(jQuery);\n//*/\n\n/*\n* jsTree model plugin\n* This plugin gets jstree to use a class model to retrieve data, creating great dynamism\n*/\n(function ($) {\n\tvar nodeInterface = [\"getChildren\",\"getChildrenCount\",\"getAttr\",\"getName\",\"getProps\"],\n\t\tvalidateInterface = function(obj, inter) {\n\t\t\tvar valid = true;\n\t\t\tobj = obj || {};\n\t\t\tinter = [].concat(inter);\n\t\t\t$.each(inter, function (i, v) {\n\t\t\t\tif(!$.isFunction(obj[v])) { valid = false; return false; }\n\t\t\t});\n\t\t\treturn valid;\n\t\t};\n\t$.jstree.plugin(\"model\", {\n\t\t__init : function () {\n\t\t\tif(!this.data.json_data) { throw \"jsTree model: jsTree json_data plugin not included.\"; }\n\t\t\tthis._get_settings().json_data.data = function (n, b) {\n\t\t\t\tvar obj = (n == -1) ? this._get_settings().model.object : n.data(\"jstree_model\");\n\t\t\t\tif(!validateInterface(obj, nodeInterface)) { return b.call(null, false); }\n\t\t\t\tif(this._get_settings().model.async) {\n\t\t\t\t\tobj.getChildren($.proxy(function (data) {\n\t\t\t\t\t\tthis.model_done(data, b);\n\t\t\t\t\t}, this));\n\t\t\t\t}\n\t\t\t\telse {\n\t\t\t\t\tthis.model_done(obj.getChildren(), b);\n\t\t\t\t}\n\t\t\t};\n\t\t},\n\t\tdefaults : {\n\t\t\tobject : false,\n\t\t\tid_prefix : false,\n\t\t\tasync : false\n\t\t},\n\t\t_fn : {\n\t\t\tmodel_done : function (data, callback) {\n\t\t\t\tvar ret = [],\n\t\t\t\t\ts = this._get_settings(),\n\t\t\t\t\t_this = this;\n\n\t\t\t\tif(!$.isArray(data)) { data = [data]; }\n\t\t\t\t$.each(data, function (i, nd) {\n\t\t\t\t\tvar r = nd.getProps() || {};\n\t\t\t\t\tr.attr = nd.getAttr() || {};\n\t\t\t\t\tif(nd.getChildrenCount()) { r.state = \"closed\"; }\n\t\t\t\t\tr.data = nd.getName();\n\t\t\t\t\tif(!$.isArray(r.data)) { r.data = [r.data]; }\n\t\t\t\t\tif(_this.data.types && $.isFunction(nd.getType)) {\n\t\t\t\t\t\tr.attr[s.types.type_attr] = nd.getType();\n\t\t\t\t\t}\n\t\t\t\t\tif(r.attr.id && s.model.id_prefix) { r.attr.id = s.model.id_prefix + r.attr.id; }\n\t\t\t\t\tif(!r.metadata) { r.metadata = { }; }\n\t\t\t\t\tr.metadata.jstree_model = nd;\n\t\t\t\t\tret.push(r);\n\t\t\t\t});\n\t\t\t\tcallback.call(null, ret);\n\t\t\t}\n\t\t}\n\t});\n})(jQuery);\n//*/\n\n\n/*\n * jsTree checkbox plugin copy-paste\n * change_state method was modified\n * refactoring is needed after update to a newer version of jstree, that supports plugin extending\n */\n(function ($) {\n    $.jstree.plugin(\"vcheckbox\", {\n        __init : function () {\n            this.data.vcheckbox.noui = this._get_settings().vcheckbox.override_ui;\n            if(this.data.ui && this.data.vcheckbox.noui) {\n                this.select_node = this.deselect_node = this.deselect_all = $.noop;\n                this.get_selected = this.get_checked;\n            }\n\n            this.get_container()\n                .bind(\"open_node.jstree create_node.jstree clean_node.jstree refresh.jstree\", $.proxy(function (e, data) {\n                    this._prepare_checkboxes(data.rslt.obj);\n                }, this))\n                .bind(\"loaded.jstree\", $.proxy(function (e) {\n                    this._prepare_checkboxes();\n                }, this))\n                .delegate( (this.data.ui && this.data.vcheckbox.noui ? \"a\" : \"ins.jstree-checkbox\") , \"click.jstree\", $.proxy(function (e) {\n                    e.preventDefault();\n                    if(this._get_node(e.target).hasClass(\"jstree-checked\")) { this.uncheck_node(e.target); }\n                    else { this.check_node(e.target); }\n                    if(this.data.ui && this.data.vcheckbox.noui) {\n                        this.save_selected();\n                        if(this.data.cookies) { this.save_cookie(\"select_node\"); }\n                    }\n                    else {\n                        e.stopImmediatePropagation();\n                        return false;\n                    }\n                }, this));\n        },\n        defaults : {\n            override_ui : false,\n            two_state : false,\n            real_checkboxes : false,\n            checked_parent_open : true,\n            real_checkboxes_names : function (n) { return [ (\"check_\" + (n[0].id || Math.ceil(Math.random() * 10000))) , 1]; }\n        },\n        __destroy : function () {\n            this.get_container()\n                .find(\"input.jstree-real-checkbox\").removeClass(\"jstree-real-checkbox\").end()\n                .find(\"ins.jstree-checkbox\").remove();\n        },\n        _fn : {\n            _checkbox_notify : function (n, data) {\n                if(data.checked) {\n                    this.check_node(n, false);\n                }\n            },\n            _prepare_checkboxes : function (obj) {\n                obj = !obj || obj == -1 ? this.get_container().find(\"> ul > li\") : this._get_node(obj);\n                if(obj === false) { return; } // added for removing root nodes\n                var c, _this = this, t, ts = this._get_settings().vcheckbox.two_state, rc = this._get_settings().vcheckbox.real_checkboxes, rcn = this._get_settings().vcheckbox.real_checkboxes_names;\n                obj.each(function () {\n                    t = $(this);\n                    c = t.is(\"li\") && (t.hasClass(\"jstree-checked\") || (rc && t.children(\":checked\").length)) ? \"jstree-checked\" : \"jstree-unchecked\";\n                    t.find(\"li\").addBack().each(function () {\n                        var $t = $(this), nm;\n                        $t.children(\"a\" + (_this.data.languages ? \"\" : \":eq(0)\") ).not(\":has(.jstree-checkbox)\").prepend(\"<ins class='jstree-checkbox'>&#160;</ins>\").parent().not(\".jstree-checked, .jstree-unchecked\").addClass( ts ? \"jstree-unchecked\" : c );\n                        if(rc) {\n                            if(!$t.children(\":checkbox\").length) {\n                                nm = rcn.call(_this, $t);\n                                $t.prepend(\"<input type='checkbox' class='jstree-real-checkbox' id='\" + nm[0] + \"' name='\" + nm[0] + \"' value='\" + nm[1] + \"' />\");\n                            }\n                            else {\n                                $t.children(\":checkbox\").addClass(\"jstree-real-checkbox\");\n                            }\n                        }\n                        if(!ts) {\n                            if(c === \"jstree-checked\" || $t.hasClass(\"jstree-checked\") || $t.children(':checked').length) {\n                                $t.find(\"li\").addBack().addClass(\"jstree-checked\").children(\":checkbox\").prop(\"checked\", true);\n                            }\n                        }\n                        else {\n                            if($t.hasClass(\"jstree-checked\") || $t.children(':checked').length) {\n                                $t.addClass(\"jstree-checked\").children(\":checkbox\").prop(\"checked\", true);\n                            }\n                        }\n                    });\n                });\n                if(!ts) {\n                    obj.find(\".jstree-checked\").parent().parent().each(function () { _this._repair_state(this); });\n                }\n            },\n            change_state : function (obj, state) {\n                obj = this._get_node(obj);\n                var coll = false, rc = this._get_settings().vcheckbox.real_checkboxes;\n                if(!obj || obj === -1) { return false; }\n                state = (state === false || state === true) ? state : obj.hasClass(\"jstree-checked\");\n                if(this._get_settings().vcheckbox.two_state) {\n                    if(state) {\n                        coll = obj.find(\"li\").addBack();\n                        if(!coll.filter(\".jstree-checked\").length) { return false; }\n                        coll.removeClass(\"jstree-checked\").addClass(\"jstree-unchecked\");\n                        if(rc) { coll.children(\":checkbox\").prop(\"checked\", false); }\n                    }\n                    else {\n                        coll = obj.find(\"li\").addBack();\n                        if(!coll.filter(\".jstree-unchecked\").length) { return false; }\n                        coll.removeClass(\"jstree-unchecked\").addClass(\"jstree-checked\");\n                        if(rc) { coll.children(\":checkbox\").prop(\"checked\", true); }\n                        if(this.data.ui) { this.data.ui.last_selected = obj; }\n                        this.data.vcheckbox.last_selected = obj;\n                    }\n                    obj.parentsUntil(\".jstree\", \"li\").each(function () {\n                        var $this = $(this);\n                        if(state) {\n                            if($this.children(\"ul\").children(\"li.jstree-checked\").length) {\n                                $this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-unchecked\").addClass(\"jstree-checked\");\n                                if(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", true); }\n                                return false;\n                            }\n                        }\n                        else {\n                            if($this.children(\"ul\").children(\"li.jstree-unchecked\").length) {\n                                $this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-unchecked\").addClass(\"jstree-checked\");\n                                if(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", true); }\n                                return false;\n                            }\n                            else {\n                                $this.removeClass(\"jstree-unchecked\").addClass(\"jstree-checked\");\n                                if(rc) { $this.children(\":checkbox\").prop(\"checked\", true); }\n                            }\n                        }\n                    });\n                }\n                else {\n                    if(state) {\n                        coll = obj.find(\"li\").addBack();\n                        if(!coll.filter(\".jstree-checked, .jstree-undetermined\").length) { return false; }\n                        coll.removeClass(\"jstree-checked jstree-undetermined\").addClass(\"jstree-unchecked\");\n                        if(rc) { coll.children(\":checkbox\").prop(\"checked\", false); }\n                    }\n                    else {\n                        coll = obj.find(\"li\").addBack();\n                        if(!coll.filter(\".jstree-unchecked, .jstree-undetermined\").length) { return false; }\n                        coll.removeClass(\"jstree-unchecked jstree-undetermined\").addClass(\"jstree-checked\");\n                        if(rc) { coll.children(\":checkbox\").prop(\"checked\", true); }\n                        if(this.data.ui) { this.data.ui.last_selected = obj; }\n                        this.data.vcheckbox.last_selected = obj;\n                    }\n                    obj.parentsUntil(\".jstree\", \"li\").each(function () {\n                        var $this = $(this);\n                        if(state) {\n                            if($this.children(\"ul\").children(\"li.jstree-checked, li.jstree-undetermined\").length) {\n                                $this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n                                if(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n                                return false;\n                            }\n                            else {\n                                $this.removeClass(\"jstree-checked jstree-undetermined\").addClass(\"jstree-unchecked\");\n                                if(rc) { $this.children(\":checkbox\").prop(\"checked\", false); }\n                            }\n                        }\n                        else {\n                            if($this.children(\"ul\").children(\"li.jstree-unchecked, li.jstree-undetermined\").length) {\n                                $this.parentsUntil(\".jstree\", \"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n                                if(rc) { $this.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n                                return false;\n                            }\n                            else {\n                                $this.removeClass(\"jstree-unchecked jstree-undetermined\").addClass(\"jstree-checked\");\n                                if(rc) { $this.children(\":checkbox\").prop(\"checked\", true); }\n                            }\n                        }\n                    });\n                }\n                if(this.data.ui && this.data.vcheckbox.noui) { this.data.ui.selected = this.get_checked(); }\n                this.__callback(obj);\n                return true;\n            },\n            check_node : function (obj) {\n                if(this.change_state(obj, false)) {\n                    obj = this._get_node(obj);\n                    if(this._get_settings().vcheckbox.checked_parent_open) {\n                        var t = this;\n                        obj.parents(\".jstree-closed\").each(function () { t.open_node(this, false, true); });\n                    }\n                    this.__callback({ \"obj\" : obj });\n                }\n            },\n            uncheck_node : function (obj) {\n                if(this.change_state(obj, true)) { this.__callback({ \"obj\" : this._get_node(obj) }); }\n            },\n            check_all : function () {\n                var _this = this,\n                    coll = this._get_settings().vcheckbox.two_state ? this.get_container_ul().find(\"li\") : this.get_container_ul().children(\"li\");\n                coll.each(function () {\n                    _this.change_state(this, false);\n                });\n                this.__callback();\n            },\n            uncheck_all : function () {\n                var _this = this,\n                    coll = this._get_settings().vcheckbox.two_state ? this.get_container_ul().find(\"li\") : this.get_container_ul().children(\"li\");\n                coll.each(function () {\n                    _this.change_state(this, true);\n                });\n                this.__callback();\n            },\n\n            is_checked : function(obj) {\n                obj = this._get_node(obj);\n                return obj.length ? obj.is(\".jstree-checked\") : false;\n            },\n            get_checked : function (obj, get_all) {\n                obj = !obj || obj === -1 ? this.get_container() : this._get_node(obj);\n                return get_all || this._get_settings().vcheckbox.two_state ? obj.find(\".jstree-checked\") : obj.find(\"> ul > .jstree-checked, .jstree-undetermined > ul > .jstree-checked\");\n            },\n            get_unchecked : function (obj, get_all) {\n                obj = !obj || obj === -1 ? this.get_container() : this._get_node(obj);\n                return get_all || this._get_settings().vcheckbox.two_state ? obj.find(\".jstree-unchecked\") : obj.find(\"> ul > .jstree-unchecked, .jstree-undetermined > ul > .jstree-unchecked\");\n            },\n\n            show_checkboxes : function () { this.get_container().children(\"ul\").removeClass(\"jstree-no-checkboxes\"); },\n            hide_checkboxes : function () { this.get_container().children(\"ul\").addClass(\"jstree-no-checkboxes\"); },\n\n            _repair_state : function (obj) {\n                obj = this._get_node(obj);\n                if(!obj.length) { return; }\n                if(this._get_settings().vcheckbox.two_state) {\n                    obj.find('li').addBack().not('.jstree-checked').removeClass('jstree-undetermined').addClass('jstree-unchecked').children(':checkbox').prop('checked', true);\n                    return;\n                }\n                var rc = this._get_settings().vcheckbox.real_checkboxes,\n                    a = obj.find(\"> ul > .jstree-checked\").length,\n                    b = obj.find(\"> ul > .jstree-undetermined\").length,\n                    c = obj.find(\"> ul > li\").length;\n                if(c === 0) { if(obj.hasClass(\"jstree-undetermined\")) { this.change_state(obj, false); } }\n                else if(a === 0 && b === 0) { this.change_state(obj, true); }\n                else if(a === c) { this.change_state(obj, false); }\n                else {\n                    obj.parentsUntil(\".jstree\",\"li\").addBack().removeClass(\"jstree-checked jstree-unchecked\").addClass(\"jstree-undetermined\");\n                    if(rc) { obj.parentsUntil(\".jstree\", \"li\").addBack().children(\":checkbox\").prop(\"checked\", false); }\n                }\n            },\n            reselect : function () {\n                if(this.data.ui && this.data.vcheckbox.noui) {\n                    var _this = this,\n                        s = this.data.ui.to_select;\n                    s = $.map($.makeArray(s), function (n) { return \"#\" + n.toString().replace(/^#/,\"\").replace(/\\\\\\//g,\"/\").replace(/\\//g,\"\\\\\\/\").replace(/\\\\\\./g,\".\").replace(/\\./g,\"\\\\.\").replace(/\\:/g,\"\\\\:\"); });\n                    this.deselect_all();\n                    $.each(s, function (i, val) { _this.check_node(val); });\n                    this.__callback();\n                }\n                else {\n                    this.__call_old();\n                }\n            },\n            save_loaded : function () {\n                var _this = this;\n                this.data.core.to_load = [];\n                this.get_container_ul().find(\"li.jstree-closed.jstree-undetermined\").each(function () {\n                    if(this.id) { _this.data.core.to_load.push(\"#\" + this.id); }\n                });\n            }\n        }\n    });\n    $(function() {\n        var css_string = '.jstree .jstree-real-checkbox { display:none; } ';\n        $.vakata.css.add_sheet({ str : css_string, title : \"jstree\" });\n    });\n})(jQuery);\n\n\n})();\n\n}));","Magento_Integration/js/integration.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * jQuery plugin is added.\n *\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'mage/translate',\n    'Magento_Ui/js/modal/modal'\n], function ($, alert) {\n    'use strict';\n\n    $.widget('mage.integration', {\n        /**\n         * Options common to all instances of this widget.\n         * @type {Object}\n         */\n        options: {\n            /**\n             * URL of the integration grid.\n             * @type {String}\n             */\n            gridUrl: ''\n        },\n\n        /**\n         * Bind event handler for the action when admin clicks \"Save & Activate\" button.\n         * @private\n         */\n        _create: function () {\n            if ($('#save-split-button-activate').length) {\n                // We're on the \"New integration\" page - bind related handler\n                this._form = $('#edit_form');\n                this._form.on('saveAndActivate', $.proxy(this._saveAndActivate, this));\n            }\n        },\n\n        /**\n         * Save new integration, then kick off the activate dialog.\n         * @private\n         */\n        _saveAndActivate: function () {\n            if (this._form.validation && !this._form.validation('isValid')) {\n                return false;\n            }\n\n            $.ajax({\n                url: this._form.prop('action'),\n                type: 'post',\n                data: this._form.serialize(),\n                dataType: 'json',\n                context: this,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    $('body').trigger('processStart');\n                },\n\n                /** @inheritdoc */\n                success: function (data) {\n                    var integrationName, that;\n\n                    if (data._redirect) {\n                        window.location.href = data._redirect;\n                    } else if (data.integrationId) {\n                        integrationName = $('#integration_properties_name').val();\n                        window.integration.popup.show($('<span>').attr({\n                            'data-row-dialog': 'permissions',\n                            'data-row-id': data.integrationId,\n                            // We do escaping here instead of the place of actual output because _showPopup()\n                            // actually receives dialog window title from couple of places: from here and from the grid.\n                            // The issue is we always should escape values in the grid, so that value is already\n                            // escaped. To avoid double escaping we do it here instead of the output.\n                            'data-row-name': $('<div>').text(integrationName).html(),\n                            'data-row-is-reauthorize': '0',\n                            'data-row-is-token-exchange': data.isTokenExchange\n                        }));\n                        that = this;\n                        $('#integration-popup-container').on('dialogclose', function () {\n                            $('body').trigger('processStart');\n                            window.location.href = that.options.gridUrl;\n\n                            return false;\n                        });\n                    }\n                },\n\n                /** @inheritdoc */\n                error: function (jqXHR, status, error) {\n                    alert({\n                        content: $.mage.__('Sorry, something went wrong. Please try again later.')\n                    });\n                    window.console && console.log(status + ': ' + error + '\\nResponse text:\\n' + jqXHR.responseText);\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    $('body').trigger('processStop');\n                }\n            });\n\n            return true;\n        }\n    });\n\n    /**\n     * @param {*} permissionsDialogUrl\n     * @param {*} tokensDialogUrl\n     * @param {*} tokensExchangeUrl\n     * @param {*} gridUrl\n     * @param {*} successCallbackUrl\n     * @return {Object}\n     * @constructor\n     */\n    window.Integration = function (\n        permissionsDialogUrl,\n        tokensDialogUrl,\n        tokensExchangeUrl,\n        gridUrl,\n        successCallbackUrl\n    ) {\n        var url = {\n            permissions: permissionsDialogUrl,\n            tokens: tokensDialogUrl,\n            tokensExchange: tokensExchangeUrl,\n            grid: gridUrl\n        },\n        IdentityLogin = {\n            win: null,\n            strLocation: null,\n            checker: null,\n            isCalledBack: false,\n            //Info popup dialog. Should be hidden when login window is closed\n            jqInfoDialog: $('#integration-popup-container'),\n            successCallbackUrl: successCallbackUrl,\n            Constants: {\n                /*\n                 This interval is set such that it adjusts to the child window closing timeout of 1000 ms. This will\n                 give the checker function enough time to detect if the successCallback has been invoked\n                 */\n                CHECKER_INTERVAL: 500,\n                //Login screen size plus some buffer\n                WIDTH: 680,\n                HEIGHT: 510,\n                // subtract pixels(30) and width(680) from screen width to move popup from extreme left\n                LEFT: screen.width - 680 - 30,\n                // subtract pixels(300) and height(300) from screen height to move from top\n                TOP: screen.height - 510 - 300\n            },\n\n            /**\n             * @param {*} identityCallbackUrl\n             * @param {*} consumerKey\n             * @param {*} jqInfoDialog\n             */\n            invokePopup: function (identityCallbackUrl, consumerKey, jqInfoDialog) {\n                var param;\n\n                // Callback should be invoked only once. Reset callback flag on subsequent invocations.\n                IdentityLogin.isCalledBack = false;\n                IdentityLogin.jqInfoDialog = jqInfoDialog;\n                param = $.param({\n                    'oauth_consumer_key': consumerKey,\n                    'success_call_back': IdentityLogin.successCallbackUrl\n                });\n                IdentityLogin.win = window.open(identityCallbackUrl + '?' + param, '',\n                    'top=' + IdentityLogin.Constants.TOP +\n                        ', left=' + IdentityLogin.Constants.LEFT +\n                        ', width=' + IdentityLogin.Constants.WIDTH +\n                        ', height=' + IdentityLogin.Constants.HEIGHT + ',scrollbars=no');\n\n                if (IdentityLogin.checker != null) {\n                    //Clear any previous check\n                    clearInterval(IdentityLogin.checker);\n                }\n                //Polling to detect url of the child window.\n                IdentityLogin.checker = setInterval(\n                    IdentityLogin.fnCheckLocation, IdentityLogin.Constants.CHECKER_INTERVAL\n                );\n            },\n\n            /**\n             * Function to check the location of the child popup window.\n             * Once detected if the callback is successful, parent window will be reloaded\n             */\n            fnCheckLocation: function () {\n                if (IdentityLogin.win == null) {\n                    return;\n                }\n                // Check to see if the location has changed.\n                try {\n                    //Is the success callback invoked\n                    if (IdentityLogin.win.closed ||\n                        IdentityLogin.win.location.href == IdentityLogin.successCallbackUrl //eslint-disable-line eqeqeq\n                    ) {\n                        //Stop the polling\n                        clearInterval(IdentityLogin.checker);\n                        $('body').trigger('processStart');\n                        //Check for window closed\n                        window.location.href = url.grid;\n                        IdentityLogin.jqInfoDialog.modal('closeModal');\n                    }\n                } catch (e) {\n                    //squash. In case Window closed without success callback, clear polling\n                    if (IdentityLogin.win.closed) {\n                        IdentityLogin.jqInfoDialog.modal('closeModal');\n                        clearInterval(IdentityLogin.checker);\n                    }\n\n                    return;\n                }\n            }\n        },\n\n        /**\n         * @param {Object} popupWindow\n         * @return {Boolean}\n         */\n        isPopupBlocked = function (popupWindow) {\n            try {\n                popupWindow.focus();\n            } catch (e) {\n                alert({\n                    content: $.mage.__('Popup Blocker is enabled! Please add this site to your exception list.')\n                });\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * @param {*} dialog\n         * @param {*} title\n         * @param {*} okButton\n         * @param {*} ajaxUrl\n         * @private\n         */\n        _showPopup = function (dialog, title, okButton, ajaxUrl) {\n            $.ajax({\n                url: ajaxUrl,\n                cache: false,\n                data: {\n                    'form_key': window.FORM_KEY\n                },\n                method: 'GET',\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    // Show the spinner\n                    $('body').trigger('processStart');\n                },\n\n                /** @inheritdoc */\n                success: function (result) {\n                    var redirect = result._redirect,\n                        identityLinkUrl, consumerKey, popupHtml, popup, resultObj, buttons, dialogProperties;\n\n                    if (redirect) {\n                        window.location.href = redirect;\n\n                        return;\n                    }\n\n                    identityLinkUrl = null;\n                    consumerKey = null;\n                    popupHtml = null;\n                    popup = $('#integration-popup-container');\n\n                    try {\n                        resultObj = typeof result === 'string' ?\n                            JSON.parse(result) :\n                            result;\n\n                        identityLinkUrl = resultObj['identity_link_url'];\n                        consumerKey      = resultObj['oauth_consumer_key'];\n                        popupHtml       = resultObj['popup_content'];\n\n                    } catch (e) {\n                        //This is expected if result is not json. Do nothing.\n                    }\n\n                    if (identityLinkUrl && consumerKey && popupHtml) {\n                        IdentityLogin.invokePopup(identityLinkUrl, consumerKey, popup);\n\n                        if (isPopupBlocked(IdentityLogin.win)) {\n                            return;\n                        }\n                    } else {\n                        popupHtml = result;\n                    }\n\n                    if (popup.length === 0) {\n                        popup = $('<div/>');\n                    }\n                    popup.html(popupHtml);\n\n                    buttons = [];\n                    dialogProperties = {\n                        title: title,\n                        type: 'slide',\n                        dialogClass: dialog == 'permissions' ? 'integration-dialog' : 'integration-dialog no-close' //eslint-disable-line\n                    };\n\n                    // Add confirmation button to the list of dialog buttons. okButton not set for tokenExchange dialog\n                    if (okButton) {\n                        buttons.push(okButton);\n                    }\n                    // Add button only if its not empty\n                    if (buttons.length > 0) {\n                        dialogProperties.buttons = buttons;\n                    }\n                    popup.modal(dialogProperties);\n                    popup.modal('openModal');\n                },\n\n                /** @inheritdoc */\n                error: function (jqXHR, status, error) {\n                    alert({\n                        content: $.mage.__('Sorry, something went wrong. Please try again later.')\n                    });\n                    window.console && console.log(status + ': ' + error + '\\nResponse text:\\n' + jqXHR.responseText);\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    // Hide the spinner\n                    $('body').trigger('processStop');\n                }\n            });\n        };\n\n        return {\n            popup: {\n                /**\n                 * @param {*} ctx\n                 */\n                show: function (ctx) {\n                    var dialog = $(ctx).attr('data-row-dialog'),\n                        isReauthorize = $(ctx).attr('data-row-is-reauthorize'),\n                        isTokenExchange = $(ctx).attr('data-row-is-token-exchange'),\n                        integrationId, ajaxUrl, integrationName, okButton;\n\n                    if (!url.hasOwnProperty(dialog)) {\n                        throw 'Invalid dialog type';\n                    }\n\n                    integrationId = $(ctx).attr('data-row-id');\n\n                    if (!integrationId) {\n                        throw 'Unable to find integration ID';\n                    }\n\n                    // Replace placeholders in URL\n                    ajaxUrl = url[dialog].replace(':id', integrationId).replace(':isReauthorize', isReauthorize);\n\n                    try {\n                        // Get integration name either from current element or from neighbor column\n                        integrationName = $(ctx).attr('data-row-name') ||\n                            $(ctx).parents('tr').find('.col-name').html().trim();\n\n                        if (integrationName.indexOf('<span') > -1) {\n                            // Remove unsecure URL warning from popup window title if it is present\n                            integrationName = integrationName.substring(0, integrationName.indexOf('<span'));\n                        }\n                    } catch (e) {\n                        throw 'Unable to find integration name';\n                    }\n\n                    okButton = {\n                        permissions: {\n                            text: isReauthorize == '1' ? $.mage.__('Reauthorize') : $.mage.__('Allow'), //eslint-disable-line\n                            'class': 'action-primary',\n                            attr: {\n                                'data-row-id': integrationId,\n                                'data-row-name': integrationName,\n                                'data-row-dialog': isTokenExchange == '1' ? 'tokensExchange' : 'tokens', //eslint-disable-line\n                                'data-row-is-reauthorize': isReauthorize,\n                                'data-row-is-token-exchange': isTokenExchange\n                            },\n\n                            /**\n                             * Click.\n                             */\n                            click: function () {\n                                // Find the 'Allow' button and clone - it has all necessary data, but is going to be\n                                // destroyed along with the current dialog\n                                var context = this.modal.find('button.action-primary').clone(true);\n\n                                this.closeModal();\n                                this.modal.remove();\n                                // Make popup out of data we saved from 'Allow' button\n                                window.integration.popup.show(context);\n                            }\n                        },\n                        tokens: {\n                            text: $.mage.__('Done'),\n                            'class': 'action-primary',\n\n                            /**\n                             * Click.\n                             */\n                            click: function () {\n                                // Integration has been activated at the point of generating tokens\n                                window.location.href = url.grid;\n                            }\n                        }\n                    };\n\n                    _showPopup(dialog, integrationName, okButton[dialog], ajaxUrl);\n                }\n            }\n        };\n    };\n\n    return $.mage.integration;\n});\n","js/theme.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine('globalNavigationScroll', [\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var win = $(window),\n        subMenuClass = '.submenu',\n        fixedClassName = '_fixed',\n        menu = $('.menu-wrapper'),\n        content = $('.page-wrapper'),\n        menuItems = $('#nav').children('li'),\n        winHeight,\n        menuHeight = menu.height(),\n        menuScrollMax = 0,\n        submenuHeight = 0,\n        contentHeight,\n        winTop = 0,\n        winTopLast = 0,\n        scrollStep = 0,\n        nextTop = 0;\n\n    /**\n     * Check if menu is fixed\n     * @returns {Boolean}\n     */\n    function isMenuFixed() {\n        return menuHeight < contentHeight && contentHeight > winHeight;\n    }\n\n    /**\n     * Check if class exist than add or do nothing\n     * @param {jQuery} el\n     * @param {String} $class\n     */\n    function checkAddClass(el, $class) {\n        if (!el.hasClass($class)) {\n            el.addClass($class);\n        }\n    }\n\n    /**\n     * Check if class exist than remove or do nothing\n     * @param {jQuery} el\n     * @param {String} $class\n     */\n    function checkRemoveClass(el, $class) {\n        if (el.hasClass($class)) {\n            el.removeClass($class);\n        }\n    }\n\n    /**\n     * Calculate and apply menu position\n     */\n    function positionMenu() {\n\n        //  Spotting positions and heights\n        winHeight = win.height();\n        contentHeight = content.height();\n        winTop = win.scrollTop();\n        scrollStep = winTop - winTopLast;\n\n        if (isMenuFixed()) { // fixed menu cases\n\n            checkAddClass(menu, fixedClassName);\n\n            if (menuHeight > winHeight) { // smart scroll cases\n\n                if (winTop > winTopLast) { //eslint-disable-line max-depth\n\n                    menuScrollMax = menuHeight - winHeight;\n\n                    nextTop < menuScrollMax - scrollStep ?\n                        nextTop += scrollStep : nextTop = menuScrollMax;\n\n                    menu.css('top', -nextTop);\n\n                } else if (winTop <= winTopLast) { // scroll up\n\n                    nextTop > -scrollStep ?\n                        nextTop += scrollStep : nextTop = 0;\n\n                    menu.css('top', -nextTop);\n\n                }\n\n            }\n\n        } else { // static menu cases\n            checkRemoveClass(menu, fixedClassName);\n        }\n\n        //  Save previous window scrollTop\n        winTopLast = winTop;\n\n    }\n\n    positionMenu(); // page start calculation\n\n    //  Change position on scroll\n    win.on('scroll', function () {\n        positionMenu();\n    });\n\n    win.on('resize', function () {\n\n        winHeight = win.height();\n\n        //  Reset position if fixed and out of smart scroll\n        if (menuHeight < contentHeight && menuHeight <= winHeight) {\n            menu.removeAttr('style');\n            menuItems.off();\n        }\n\n    });\n\n    //  Add event to menuItems to check submenu overlap\n    menuItems.on('click', function () {\n\n        var submenu = $(this).children(subMenuClass),\n            delta,\n            logo = $('.logo')[0].offsetHeight;\n\n        submenuHeight = submenu.height();\n\n        if (submenuHeight > menuHeight && menuHeight + logo > winHeight) {\n            menu.height(submenuHeight - logo);\n            delta = -menu.position().top;\n            window.scrollTo(0, 0);\n            positionMenu();\n            window.scrollTo(0, delta);\n            positionMenu();\n            menuHeight = submenuHeight;\n        }\n    });\n\n});\n\ndefine('globalNavigation', [\n    'jquery',\n    'jquery/ui',\n    'globalNavigationScroll'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.globalNavigation', {\n        options: {\n            selectors: {\n                menu: '#nav',\n                currentItem: '._current',\n                topLevelItem: '.level-0',\n                topLevelHref: '> a',\n                subMenu: '> .submenu',\n                closeSubmenuBtn: '[data-role=\"close-submenu\"]'\n            },\n            overlayTmpl: '<div class=\"admin__menu-overlay\"></div>'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var selectors = this.options.selectors;\n\n            this.menu = this.element;\n            this.menuLinks = $(selectors.topLevelHref, selectors.topLevelItem);\n            this.closeActions = $(selectors.closeSubmenuBtn);\n\n            this._initOverlay()\n                ._bind();\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _initOverlay: function () {\n            this.overlay = $(this.options.overlayTmpl).appendTo('body').hide(0);\n\n            return this;\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            var focus = this._focus.bind(this),\n                open = this._open.bind(this),\n                blur = this._blur.bind(this),\n                keyboard = this._keyboard.bind(this);\n\n            this.menuLinks\n                .on('focus', focus)\n                .on('click', open);\n\n            this.menuLinks.last().on('blur', blur);\n\n            this.closeActions.on('keydown', keyboard);\n        },\n\n        /**\n         * Remove active class from current menu item\n         * Turn back active class to current page menu item\n         */\n        _blur: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = $(e.target).closest(selectors.topLevelItem),\n                currentItem = $(selectors.menu).find(selectors.currentItem);\n\n            menuItem.removeClass('_active');\n            currentItem.addClass('_active');\n        },\n\n        /**\n         * Add focus to active menu item\n         */\n        _keyboard: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = $(e.target).closest(selectors.topLevelItem);\n\n            if (e.which === 13) {\n                this._close(e);\n                $(selectors.topLevelHref, menuItem).focus();\n            }\n        },\n\n        /**\n         * Toggle active state on focus\n         */\n        _focus: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = $(e.target).closest(selectors.topLevelItem);\n\n            menuItem.addClass('_active')\n                .siblings(selectors.topLevelItem)\n                .removeClass('_active');\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _closeSubmenu: function (e) {\n            var selectors = this.options.selectors,\n                currentItem = $(selectors.menu).find(selectors.currentItem);\n\n            this._close(e);\n\n            currentItem.addClass('_active');\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _open: function (e) {\n            var selectors = this.options.selectors,\n                menuItemSelector = selectors.topLevelItem,\n                menuItem = $(e.target).closest(menuItemSelector),\n                subMenu = $(selectors.subMenu, menuItem),\n                close = this._closeSubmenu.bind(this),\n                closeBtn = subMenu.find(selectors.closeSubmenuBtn);\n\n            if (subMenu.length) {\n                e.preventDefault();\n            }\n\n            menuItem.addClass('_show')\n                .siblings(menuItemSelector)\n                .removeClass('_show');\n\n            subMenu.attr('aria-expanded', 'true');\n\n            closeBtn.on('click', close);\n\n            this.overlay.show(0).on('click', close);\n            this.menuLinks.last().off('blur');\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _close: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = this.menu.find(selectors.topLevelItem + '._show'),\n                subMenu = $(selectors.subMenu, menuItem),\n                closeBtn = subMenu.find(selectors.closeSubmenuBtn),\n                blur = this._blur.bind(this);\n\n            e.preventDefault();\n\n            this.overlay.hide(0).off('click');\n\n            this.menuLinks.last().on('blur', blur);\n\n            closeBtn.off('click');\n\n            subMenu.attr('aria-expanded', 'false');\n\n            menuItem.removeClass('_show _active');\n        }\n    });\n\n    return $.mage.globalNavigation;\n});\n\ndefine('globalSearch', [\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.globalSearch', {\n        options: {\n            field: '.search-global-field',\n            fieldActiveClass: '_active',\n            input: '#search-global'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.field = $(this.options.field);\n            this.input = $(this.options.input);\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.input.on('blur.resetGlobalSearchForm', function () {\n                if (!self.input.val()) {\n                    self.field.removeClass(self.options.fieldActiveClass);\n                }\n            });\n\n            this.input.on('focus.activateGlobalSearchForm', function () {\n                self.field.addClass(self.options.fieldActiveClass);\n            });\n        }\n    });\n\n    return $.mage.globalSearch;\n});\n\ndefine('modalPopup', [\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.modalPopup', {\n        options: {\n            popup: '.popup',\n            btnDismiss: '[data-dismiss=\"popup\"]',\n            btnHide: '[data-hide=\"popup\"]'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.fade = this.element;\n            this.popup = $(this.options.popup, this.fade);\n            this.btnDismiss = $(this.options.btnDismiss, this.popup);\n            this.btnHide = $(this.options.btnHide, this.popup);\n\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.btnDismiss\n                .on('click.dismissModalPopup', function () {\n                    self.fade.remove();\n                });\n\n            this.btnHide\n                .on('click.hideModalPopup', function () {\n                    self.fade.hide();\n                });\n        }\n    });\n\n    return $.mage.modalPopup;\n});\n\ndefine('useDefault', [\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.useDefault', {\n        options: {\n            field: '.field',\n            useDefault: '.use-default',\n            checkbox: '.use-default-control',\n            label: '.use-default-label'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.el = this.element;\n            this.field = $(this.el).closest(this.options.field);\n            this.useDefault = $(this.options.useDefault, this.field);\n            this.checkbox = $(this.options.checkbox, this.useDefault);\n            this.label = $(this.options.label, this.useDefault);\n            this.origValue = this.el.attr('data-store-label');\n\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.el.on(\n                    'change.toggleUseDefaultVisibility keyup.toggleUseDefaultVisibility',\n                    $.proxy(this._toggleUseDefaultVisibility, this)\n                ).trigger('change.toggleUseDefaultVisibility');\n\n            this.checkboxon('change.setOrigValue', function () {\n                if ($(this).prop('checked')) {\n                    self.el\n                        .val(self.origValue)\n                        .trigger('change.toggleUseDefaultVisibility');\n\n                    $(this).prop('checked', false);\n                }\n            });\n        },\n\n        /**\n         * @private\n         */\n        _toggleUseDefaultVisibility: function () {\n            var curValue = this.el.val(),\n                origValue = this.origValue;\n\n            this[curValue != origValue ? '_show' : '_hide'](); //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @private\n         */\n        _show: function () {\n            this.useDefault.show();\n        },\n\n        /**\n         * @private\n         */\n        _hide: function () {\n            this.useDefault.hide();\n        }\n    });\n\n    return $.mage.useDefault;\n});\n\ndefine('loadingPopup', [\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.loadingPopup', {\n        options: {\n            message: 'Please wait...',\n            timeout: 5000,\n            timeoutId: null,\n            callback: null,\n            template: null\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.template =\n                '<div class=\"popup popup-loading\">' +\n                '<div class=\"popup-inner\">' + this.options.message + '</div>' +\n                '</div>';\n\n            this.popup = $(this.template);\n\n            this._show();\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.element\n                .on('showLoadingPopup', function () {\n                    self._show();\n                })\n                .on('hideLoadingPopup', function () {\n                    self._hide();\n                });\n        },\n\n        /**\n         * @private\n         */\n        _show: function () {\n            var options = this.options,\n                timeout = options.timeout;\n\n            $('body').trigger('processStart');\n\n            if (timeout) {\n                options.timeoutId = setTimeout(this._delayedHide.bind(this), timeout);\n            }\n        },\n\n        /**\n         * @private\n         */\n        _hide: function () {\n            $('body').trigger('processStop');\n        },\n\n        /**\n         * @private\n         */\n        _delayedHide: function () {\n            this._hide();\n\n            this.options.callback && this.options.callback();\n\n            this.options.timeoutId && clearTimeout(this.options.timeoutId);\n        }\n    });\n\n    return $.mage.loadingPopup;\n});\n\ndefine('collapsable', [\n    'jquery',\n    'jquery/ui',\n    'jquery/jquery.tabs'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.collapsable', {\n        options: {\n            parent: null,\n            openedClass: 'opened',\n            wrapper: '.fieldset-wrapper'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._events();\n        },\n\n        /** @inheritdoc */\n        _events: function () {\n            var self = this;\n\n            this.element\n                .on('show', function (e) {\n                    var fieldsetWrapper = $(this).closest(self.options.wrapper);\n\n                    fieldsetWrapper.addClass(self.options.openedClass);\n                    e.stopPropagation();\n                })\n                .on('hide', function (e) {\n                    var fieldsetWrapper = $(this).closest(self.options.wrapper);\n\n                    fieldsetWrapper.removeClass(self.options.openedClass);\n                    e.stopPropagation();\n                });\n        }\n    });\n\n    return $.mage.collapsable;\n});\n\ndefine('js/theme', [\n    'jquery',\n    'mage/smart-keyboard-handler',\n    'mage/ie-class-fixer',\n    'collapsable',\n    'domReady!'\n], function ($, keyboardHandler) {\n    'use strict';\n\n    /* @TODO refactor collapsible as widget and avoid logic binding with such a general selectors */\n    $('.collapse').collapsable();\n\n    $.each($('.entry-edit'), function (i, entry) {\n        $('.collapse:first', entry).filter(function () {\n            return $(this).data('collapsed') !== true;\n        }).collapse('show');\n    });\n\n    keyboardHandler.apply();\n});\n","Magento_Msrp/js/msrp.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'mage/dropdown',\n    'mage/template'\n], function ($, priceUtils, _) {\n    'use strict';\n\n    $.widget('mage.addToCart', {\n        options: {\n            showAddToCart: true,\n            submitUrl: '',\n            cartButtonId: '',\n            singleOpenDropDown: true,\n            dialog: {}, // Options for mage/dropdown\n            dialogDelay: 500, // Delay in ms after resize dropdown shown again\n            origin: '', //Required, type of popup: 'msrp', 'tier' or 'info' popup\n\n            // Selectors\n            cartForm: '.form.map.checkout',\n            msrpLabelId: '#map-popup-msrp',\n            msrpPriceElement: '#map-popup-msrp .price-wrapper',\n            priceLabelId: '#map-popup-price',\n            priceElement: '#map-popup-price .price',\n            mapInfoLinks: '.map-show-info',\n            displayPriceElement: '.old-price.map-old-price .price-wrapper',\n            fallbackPriceElement: '.normal-price.map-fallback-price .price-wrapper',\n            displayPriceContainer: '.old-price.map-old-price',\n            fallbackPriceContainer: '.normal-price.map-fallback-price',\n            popUpAttr: '[data-role=msrp-popup-template]',\n            popupCartButtonId: '#map-popup-button',\n            paypalCheckoutButons: '[data-action=checkout-form-submit]',\n            popupId: '',\n            realPrice: '',\n            isSaleable: '',\n            msrpPrice: '',\n            helpLinkId: '',\n            addToCartButton: '',\n\n            // Text options\n            productName: '',\n            addToCartUrl: ''\n        },\n\n        openDropDown: null,\n        triggerClass: 'dropdown-active',\n\n        popUpOptions: {\n            appendTo: 'body',\n            dialogContentClass: 'active',\n            closeOnMouseLeave: false,\n            autoPosition: true,\n            closeOnClickOutside: false,\n            'dialogClass': 'popup map-popup-wrapper',\n            position: {\n                my: 'left top',\n                collision: 'fit none',\n                at: 'left bottom',\n                within: 'body'\n            },\n            shadowHinter: 'popup popup-pointer'\n        },\n        popupOpened: false,\n        wasOpened: false,\n\n        /**\n         * Creates widget instance\n         *\n         * @private\n         */\n        _create: function () {\n            if (this.options.origin === 'msrp') {\n                this.initMsrpPopup();\n            } else if (this.options.origin === 'info') {\n                this.initInfoPopup();\n            } else if (this.options.origin === 'tier') {\n                this.initTierPopup();\n            }\n            $(this.options.cartButtonId).on('click', this._addToCartSubmit.bind(this));\n            $(document).on('updateMsrpPriceBlock', this.onUpdateMsrpPrice.bind(this));\n            $(this.options.cartForm).on('submit', this._onSubmitForm.bind(this));\n        },\n\n        /**\n         * Init msrp popup\n         *\n         * @private\n         */\n        initMsrpPopup: function () {\n            var popupDOM = $(this.options.popUpAttr)[0],\n                $msrpPopup = $(popupDOM.innerHTML.trim());\n\n            $msrpPopup.find(this.options.productIdInput).val(this.options.productId);\n            $('body').append($msrpPopup);\n            $msrpPopup.trigger('contentUpdated');\n\n            $msrpPopup.find('button')\n                .on('click',\n                    this.handleMsrpAddToCart.bind(this))\n                .filter(this.options.popupCartButtonId)\n                .text($(this.options.addToCartButton).text());\n\n            $msrpPopup.find(this.options.paypalCheckoutButons).on('click',\n                this.handleMsrpPaypalCheckout.bind(this));\n\n            $(this.options.popupId).on('click',\n                this.openPopup.bind(this));\n\n            this.$popup = $msrpPopup;\n        },\n\n        /**\n         * Init info popup\n         *\n         * @private\n         */\n        initInfoPopup: function () {\n            var infoPopupDOM = $('[data-role=msrp-info-template]')[0],\n                $infoPopup = $(infoPopupDOM.innerHTML.trim());\n\n            $('body').append($infoPopup);\n\n            $(this.options.helpLinkId).on('click', function (e) {\n                this.popUpOptions.position.of = $(e.target);\n                $infoPopup.dropdownDialog(this.popUpOptions).dropdownDialog('open');\n                this._toggle($infoPopup);\n            }.bind(this));\n\n            this.$popup = $infoPopup;\n        },\n\n        /**\n         * Init tier price popup\n         * @private\n         */\n        initTierPopup: function () {\n            var popupDOM = $(this.options.popUpAttr)[0],\n                $tierPopup = $(popupDOM.innerHTML.trim());\n\n            $('body').append($tierPopup);\n            $tierPopup.find(this.options.productIdInput).val(this.options.productId);\n            this.popUpOptions.position.of = $(this.options.helpLinkId);\n\n            $tierPopup.find('button').on('click',\n                this.handleTierAddToCart.bind(this))\n                .filter(this.options.popupCartButtonId)\n                .text($(this.options.addToCartButton).text());\n\n            $tierPopup.find(this.options.paypalCheckoutButons).on('click',\n                this.handleTierPaypalCheckout.bind(this));\n\n            $(this.options.attr).on('click', function (e) {\n                this.$popup = $tierPopup;\n                this.tierOptions = $(e.target).data('tier-price');\n                this.openPopup(e);\n            }.bind(this));\n        },\n\n        /**\n         * handle 'AddToCart' click on Msrp popup\n         * @param {Object} ev\n         *\n         * @private\n         */\n        handleMsrpAddToCart: function (ev) {\n            ev.preventDefault();\n\n            if (this.options.addToCartButton) {\n                $(this.options.addToCartButton).click();\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * handle 'paypal checkout buttons' click on Msrp popup\n         *\n         * @private\n         */\n        handleMsrpPaypalCheckout: function () {\n            this.closePopup(this.$popup);\n        },\n\n        /**\n         * handle 'AddToCart' click on Tier popup\n         *\n         * @param {Object} ev\n         * @private\n         */\n        handleTierAddToCart: function (ev) {\n            ev.preventDefault();\n\n            if (this.options.addToCartButton &&\n                this.options.inputQty && !isNaN(this.tierOptions.qty)\n            ) {\n                $(this.options.inputQty).val(this.tierOptions.qty);\n                $(this.options.addToCartButton).click();\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * handle 'paypal checkout buttons' click on Tier popup\n         *\n         * @private\n         */\n        handleTierPaypalCheckout: function () {\n            if (this.options.inputQty && !isNaN(this.tierOptions.qty)\n            ) {\n                $(this.options.inputQty).val(this.tierOptions.qty);\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * Open and set up popup\n         *\n         * @param {Object} event\n         */\n        openPopup: function (event) {\n            var options = this.tierOptions || this.options;\n\n            this.popUpOptions.position.of = $(event.target);\n\n            if (!this.wasOpened) {\n                this.$popup.find(this.options.msrpLabelId).html(options.msrpPrice);\n                this.$popup.find(this.options.priceLabelId).html(options.realPrice);\n                this.wasOpened = true;\n            }\n            this.$popup.dropdownDialog(this.popUpOptions).dropdownDialog('open');\n            this._toggle(this.$popup);\n\n            if (!this.options.isSaleable) {\n                this.$popup.find('form').hide();\n            }\n        },\n\n        /**\n         * Toggle MAP popup visibility\n         *\n         * @param {HTMLElement} $elem\n         * @private\n         */\n        _toggle: function ($elem) {\n            $(document).on('mouseup.msrp touchend.msrp', function (e) {\n                if (!$elem.is(e.target) && $elem.has(e.target).length === 0) {\n                    this.closePopup($elem);\n                }\n            }.bind(this));\n            $(window).on('resize', function () {\n                this.closePopup($elem);\n            }.bind(this));\n        },\n\n        /**\n         * Close MAP information popup\n         *\n         * @param {HTMLElement} $elem\n         */\n        closePopup: function ($elem) {\n            $elem.dropdownDialog('close');\n            $(document).off('mouseup.msrp touchend.msrp');\n        },\n\n        /**\n         * Handler for addToCart action\n         *\n         * @param {Object} e\n         */\n        _addToCartSubmit: function (e) {\n            this.element.trigger('addToCart', this.element);\n\n            if (this.element.data('stop-processing')) {\n                return false;\n            }\n\n            if (this.options.addToCartButton) {\n                $(this.options.addToCartButton).click();\n\n                return false;\n            }\n\n            if (this.options.addToCartUrl) {\n                $('.mage-dropdown-dialog > .ui-dialog-content').dropdownDialog('close');\n            }\n\n            e.preventDefault();\n            $(this.options.cartForm).submit();\n        },\n\n        /**\n         * Call on event updatePrice. Proxy to updateMsrpPrice method.\n         *\n         * @param {Event} event\n         * @param {mixed} priceIndex\n         * @param {Object} prices\n         */\n        onUpdateMsrpPrice: function onUpdateMsrpPrice(event, priceIndex, prices) {\n\n            var defaultMsrp,\n                defaultPrice,\n                msrpPrice,\n                finalPrice;\n\n            defaultMsrp = _.chain(prices).map(function (price) {\n                return price.msrpPrice.amount;\n            }).reject(function (p) {\n                return p === null;\n            }).max().value();\n\n            defaultPrice = _.chain(prices).map(function (p) {\n                return p.finalPrice.amount;\n            }).min().value();\n\n            if (typeof priceIndex !== 'undefined') {\n                msrpPrice = prices[priceIndex].msrpPrice.amount;\n                finalPrice = prices[priceIndex].finalPrice.amount;\n\n                if (msrpPrice === null || msrpPrice <= finalPrice) {\n                    this.updateNonMsrpPrice(priceUtils.formatPrice(finalPrice));\n                } else {\n                    this.updateMsrpPrice(\n                        priceUtils.formatPrice(finalPrice),\n                        priceUtils.formatPrice(msrpPrice),\n                        false);\n                }\n            } else {\n                this.updateMsrpPrice(\n                    priceUtils.formatPrice(defaultPrice),\n                    priceUtils.formatPrice(defaultMsrp),\n                    true);\n            }\n        },\n\n        /**\n         * Update prices for configurable product with MSRP enabled\n         *\n         * @param {String} finalPrice\n         * @param {String} msrpPrice\n         * @param {Boolean} useDefaultPrice\n         */\n        updateMsrpPrice: function (finalPrice, msrpPrice, useDefaultPrice) {\n            var options = this.tierOptions || this.options;\n\n            $(this.options.fallbackPriceContainer).hide();\n            $(this.options.displayPriceContainer).show();\n            $(this.options.mapInfoLinks).show();\n\n            if (useDefaultPrice || !this.wasOpened) {\n                this.$popup.find(this.options.msrpLabelId).html(options.msrpPrice);\n                this.$popup.find(this.options.priceLabelId).html(options.realPrice);\n                $(this.options.displayPriceElement).html(msrpPrice);\n                this.wasOpened = true;\n            }\n\n            if (!useDefaultPrice) {\n                this.$popup.find(this.options.msrpPriceElement).html(msrpPrice);\n                this.$popup.find(this.options.priceElement).html(finalPrice);\n                $(this.options.displayPriceElement).html(msrpPrice);\n            }\n        },\n\n        /**\n         * Display non MAP price for irrelevant products\n         *\n         * @param {String} price\n         */\n        updateNonMsrpPrice: function (price) {\n            $(this.options.fallbackPriceElement).html(price);\n            $(this.options.displayPriceContainer).hide();\n            $(this.options.mapInfoLinks).hide();\n            $(this.options.fallbackPriceContainer).show();\n        },\n\n        /**\n         * Handler for submit form\n         *\n         * @private\n         */\n        _onSubmitForm: function () {\n            if ($(this.options.cartForm).valid()) {\n                $(this.options.cartButtonId).prop('disabled', true);\n            }\n        }\n\n    });\n\n    return $.mage.addToCart;\n});\n","Magento_Review/js/rating.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('marketing.ratingControl', {\n        options: {\n            colorFilled: '#333',\n            colorUnfilled: '#CCCCCC',\n            colorHover: '#f30'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._labels = this.element.find('label');\n            this._bind();\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            this._labels.on({\n                click: $.proxy(function (e) {\n                    $(e.currentTarget).prev().prop('checked', true);\n                    this._updateRating();\n                }, this),\n\n                hover: $.proxy(function (e) {\n                    this._updateHover($(e.currentTarget), this.options.colorHover);\n                }, this),\n\n                mouseleave: $.proxy(function (e) {\n                    this._updateHover($(e.currentTarget), this.options.colorUnfilled);\n                }, this)\n            });\n\n            this._updateRating();\n        },\n\n        /**\n         * @param {jQuery} elem\n         * @param {String} color\n         * @private\n         */\n        _updateHover: function (elem, color) {\n            elem.nextAll('label').addBack().filter(function () {\n                return !$(this).data('checked');\n            }).css('color', color);\n        },\n\n        /**\n         * @private\n         */\n        _updateRating: function () {\n            var checkedInputs = this.element.find('input[type=\"radio\"]:checked');\n\n            checkedInputs.nextAll('label').addBack().css('color', this.options.colorFilled).data('checked', true);\n            checkedInputs.prevAll('label').css('color', this.options.colorUnfilled).data('checked', false);\n        }\n    });\n\n});\n","Magento_Tax/js/bootstrap.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'mage/backend/editablemultiselect'\n]);\n","Magento_Tax/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'mage/translate'\n], function (Element, $t) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Tax/price/adjustment',\n            taxPriceType: 'final_price',\n            taxPriceCssClass: 'price-including-tax',\n            bothPrices: 3,\n            inclTax: 2,\n            exclTax: 1,\n            modules: {\n                price: '${ $.parentName }'\n            },\n            listens: {\n                price: 'initializePriceAttributes'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super()\n                .initializePriceAttributes();\n\n            return this;\n        },\n\n        /**\n         * Update parent price.\n         *\n         * @returns {Object} Chainable.\n         */\n        initializePriceAttributes: function () {\n            if (this.displayBothPrices && this.price()) {\n                this.price().priceWrapperCssClasses = this.taxPriceCssClass;\n                this.price().priceWrapperAttr = {\n                    'data-label': $t('Incl. Tax')\n                };\n            }\n\n            return this;\n        },\n\n        /**\n         * Get price tax adjustment.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} tax html\n         */\n        getTax: function (row) {\n            return row['price_info']['extension_attributes']['tax_adjustments']['formatted_prices'][this.taxPriceType];\n        },\n\n        /**\n         * Set price tax type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPrices: function () {\n            return +this.source.data.displayTaxes === this.bothPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceIncludeTax: function () {\n            return +this.source.data.displayTaxes === this.inclTax;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.exclTax;\n        }\n    });\n});\n","Magento_ProductVideo/js/get-video-information.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'mage/translate'\n], function ($, alert) {\n        'use strict';\n\n        var videoRegister = {\n            _register: {},\n\n            /**\n             * Checks, if api is already registered\n             *\n             * @param {String} api\n             * @returns {bool}\n             */\n            isRegistered: function (api) {\n                return this._register[api] !== undefined;\n            },\n\n            /**\n             * Checks, if api is loaded\n             *\n             * @param {String} api\n             * @returns {bool}\n             */\n            isLoaded: function (api) {\n                return this._register[api] !== undefined && this._register[api] === true;\n            },\n\n            /**\n             * Register new video api\n             * @param {String} api\n             * @param {bool} loaded\n             */\n            register: function (api, loaded) {\n                loaded = loaded || false;\n                this._register[api] = loaded;\n            }\n        };\n\n        $.widget('mage.productVideoLoader', {\n\n            /**\n             * @private\n             */\n            _create: function () {\n                switch (this.element.data('type')) {\n                    case 'youtube':\n                        this.element.videoYoutube();\n                        this._player = this.element.data('mageVideoYoutube');\n                        break;\n\n                    case 'vimeo':\n                        this.element.videoVimeo();\n                        this._player = this.element.data('mageVideoVimeo');\n                        break;\n                    default:\n                        throw {\n                            name: $.mage.__('Video Error'),\n                            message: $.mage.__('Unknown video type'),\n\n                            /**\n                             * Return string\n                             */\n                            toString: function () {\n                                return this.name + ': ' + this.message;\n                            }\n                        };\n                }\n            },\n\n            /**\n             * Initializes variables\n             * @private\n             */\n            _initialize: function () {\n                this._params = this.element.data('params') || {};\n                this._code = this.element.data('code');\n                this._width = this.element.data('width');\n                this._height = this.element.data('height');\n                this._autoplay = !!this.element.data('autoplay');\n                this._playing = this._autoplay || false;\n                this.useYoutubeNocookie = this.element.data('youtubenocookie') || false;\n\n                this._responsive = this.element.data('responsive') !== false;\n\n                if (this._responsive === true) {\n                    this.element.addClass('responsive');\n                }\n\n                this._calculateRatio();\n            },\n\n            /**\n             * Abstract play command\n             */\n            play: function () {\n                this._player.play();\n            },\n\n            /**\n             * Abstract pause command\n             */\n            pause: function () {\n                this._player.pause();\n            },\n\n            /**\n             * Abstract stop command\n             */\n            stop: function () {\n                this._player.stop();\n            },\n\n            /**\n             * Abstract playing command\n             */\n            playing: function () {\n                return this._player.playing();\n            },\n\n            /**\n             * Abstract destroying command\n             */\n            destroy: function () {\n                this._player.destroy();\n            },\n\n            /**\n             * Calculates ratio for responsive videos\n             * @private\n             */\n            _calculateRatio: function () {\n                if (!this._responsive) {\n                    return;\n                }\n                this.element.css('paddingBottom', this._height / this._width * 100 + '%');\n            }\n        });\n\n        $.widget('mage.videoYoutube', $.mage.productVideoLoader, {\n\n            /**\n             * Initialization of the Youtube widget\n             * @private\n             */\n            _create: function () {\n                var self = this;\n\n                this._initialize();\n\n                this.element.append('<div/>');\n\n                this._on(window, {\n\n                    /**\n                     * Youtube state check\n                     * @private\n                     */\n                    'youtubeapiready': function () {\n                        var host = 'https://www.youtube.com';\n\n                        if (self.useYoutubeNocookie) {\n                            host = 'https://www.youtube-nocookie.com';\n                        }\n\n                        if (self._player !== undefined) {\n                            return;\n                        }\n\n                        if (self._autoplay) {\n                            self._params.autoplay = 1;\n                        }\n                        self._params.rel = 0;\n\n                        self._player = new window.YT.Player(self.element.children(':first')[0], {\n                            height: self._height,\n                            width: self._width,\n                            videoId: self._code,\n                            playerVars: self._params,\n                            host: host,\n                            events: {\n\n                                /**\n                                 * @private\n                                 */\n                                'onReady': function onPlayerReady() {\n                                    self._player.getDuration();\n                                },\n\n                                /**\n                                 * State change flag init\n                                 */\n                                onStateChange: function (data) {\n                                    switch (window.parseInt(data.data, 10)) {\n                                        case 1:\n                                            self._playing = true;\n                                            break;\n                                        default:\n                                            self._playing = false;\n                                            break;\n                                    }\n\n                                    self._trigger('statechange', {}, data);\n                                }\n                            }\n\n                        });\n                    }\n                });\n\n                this._loadApi();\n            },\n\n            /**\n             * Loads Youtube API and triggers event, when loaded\n             * @private\n             */\n            _loadApi: function () {\n                var element,\n                    scriptTag;\n\n                if (videoRegister.isRegistered('youtube')) {\n                    if (videoRegister.isLoaded('youtube')) {\n                        $(window).trigger('youtubeapiready');\n                    }\n\n                    return;\n                }\n                videoRegister.register('youtube');\n\n                element = document.createElement('script');\n                scriptTag = document.getElementsByTagName('script')[0];\n\n                element.async = true;\n                element.src = 'https://www.youtube.com/iframe_api';\n                scriptTag.parentNode.insertBefore(element, scriptTag);\n\n                /**\n                 * Trigger youtube api ready event\n                 */\n                window.onYouTubeIframeAPIReady = function () {\n                    $(window).trigger('youtubeapiready');\n                    videoRegister.register('youtube', true);\n                };\n            },\n\n            /**\n             * Play command for Youtube\n             */\n            play: function () {\n                this._player.playVideo();\n                this._playing = true;\n            },\n\n            /**\n             * Pause command for Youtube\n             */\n            pause: function () {\n                this._player.pauseVideo();\n                this._playing = false;\n            },\n\n            /**\n             * Stop command for Youtube\n             */\n            stop: function () {\n                this._player.stopVideo();\n                this._playing = false;\n            },\n\n            /**\n             * Playing command for Youtube\n             */\n            playing: function () {\n                return this._playing;\n            },\n\n            /**\n             * stops and unloads player\n             * @private\n             */\n            destroy: function () {\n                this.stop();\n                this._player.destroy();\n            }\n        });\n\n        $.widget('mage.videoVimeo', $.mage.productVideoLoader, {\n\n            /**\n             * Initialize the Vimeo widget\n             * @private\n             */\n            _create: function () {\n                var timestamp,\n                    src,\n                    additionalParams;\n\n                this._initialize();\n                timestamp = new Date().getTime();\n\n                if (this._autoplay) {\n                    additionalParams += '&autoplay=1';\n                }\n\n                src = 'https://player.vimeo.com/video/' +\n                    this._code + '?api=1&player_id=vimeo' +\n                    this._code +\n                    timestamp +\n                    additionalParams;\n                this.element.append(\n                    $('<iframe/>')\n                        .attr('frameborder', 0)\n                        .attr('id', 'vimeo' + this._code + timestamp)\n                        .attr('width', this._width)\n                        .attr('height', this._height)\n                        .attr('src', src)\n                );\n\n            }\n        });\n\n        $.widget('mage.videoData', {\n            options: {\n                youtubeKey: '',\n                eventSource: '' //where is data going from - focus out or click on button\n            },\n\n            _REQUEST_VIDEO_INFORMATION_TRIGGER: 'request_video_information',\n\n            _UPDATE_VIDEO_INFORMATION_TRIGGER: 'updated_video_information',\n\n            _START_UPDATE_INFORMATION_TRIGGER: 'update_video_information',\n\n            _ERROR_UPDATE_INFORMATION_TRIGGER: 'error_updated_information',\n\n            _FINISH_UPDATE_INFORMATION_TRIGGER: 'finish_update_information',\n\n            _VIDEO_URL_VALIDATE_TRIGGER: 'validate_video_url',\n\n            _videoInformation: null,\n\n            _currentVideoUrl: null,\n\n            /**\n             * @private\n             */\n            _init: function () {\n                this.element.on(this._START_UPDATE_INFORMATION_TRIGGER, $.proxy(this._onRequestHandler, this));\n                this.element.on(this._ERROR_UPDATE_INFORMATION_TRIGGER, $.proxy(this._onVideoInvalid, this));\n                this.element.on(this._FINISH_UPDATE_INFORMATION_TRIGGER, $.proxy(\n                    function () {\n                        this._currentVideoUrl = null;\n                    }, this\n                ));\n                this.element.on(this._VIDEO_URL_VALIDATE_TRIGGER, $.proxy(this._onUrlValidateHandler, this));\n            },\n\n            /**\n             * @private\n             */\n            _onUrlValidateHandler: function (event, callback, forceVideo) {\n                var url = this.element.val(),\n                    videoInfo;\n\n                videoInfo = this._validateURL(url, forceVideo);\n\n                if (videoInfo) {\n                    callback();\n                } else {\n                    this._onRequestError($.mage.__('Invalid video url'));\n                }\n            },\n\n            /**\n             * @private\n             */\n            _onRequestHandler: function () {\n                var url = this.element.val(),\n                    self = this,\n                    videoInfo,\n                    type,\n                    id,\n                    googleapisUrl;\n\n                if (this._currentVideoUrl === url) {\n                    return;\n                }\n\n                this._currentVideoUrl = url;\n\n                this.element.trigger(this._REQUEST_VIDEO_INFORMATION_TRIGGER, {\n                    url: url\n                });\n\n                if (!url) {\n                    return;\n                }\n\n                videoInfo = this._validateURL(url);\n\n                if (!videoInfo) {\n                    this._onRequestError($.mage.__('Invalid video url'));\n\n                    return;\n                }\n\n                /**\n                 *\n                 * @param {Object} data\n                 * @private\n                 */\n                function _onYouTubeLoaded(data) {\n                    var tmp,\n                        uploadedFormatted,\n                        respData,\n                        createErrorMessage;\n\n                    /**\n                     * Create errors message\n                     *\n                     * @returns {String}\n                     */\n                    createErrorMessage = function () {\n                        var error = data.error,\n                            errors = error.errors,\n                            i,\n                            errLength = errors.length,\n                            tmpError,\n                            errReason,\n                            errorsMessage = [];\n\n                        for (i = 0; i < errLength; i++) {\n                            tmpError = errors[i];\n                            errReason = tmpError.reason;\n\n                            if (['keyInvalid'].indexOf(errReason) !== -1) {\n                                errorsMessage.push($.mage.__('Youtube API key is invalid'));\n\n                                break;\n                            }\n\n                            errorsMessage.push(tmpError.message);\n                        }\n\n                        return $.mage.__('Video cant be shown due to the following reason: ') +\n                            $.unique(errorsMessage).join(', ');\n                    };\n\n                    if (data.error && [400, 402, 403].indexOf(data.error.code) !== -1) {\n                        this._onRequestError(createErrorMessage());\n\n                        return;\n                    }\n\n                    if (!data.items || data.items.length < 1) {\n                        this._onRequestError($.mage.__('Video not found'));\n\n                        return;\n                    }\n\n                    tmp = data.items[0];\n                    uploadedFormatted = tmp.snippet.publishedAt.replace('T', ' ').replace(/\\..+/g, '');\n                    respData = {\n                        duration: this._formatYoutubeDuration(tmp.contentDetails.duration),\n                        channel: tmp.snippet.channelTitle,\n                        channelId: tmp.snippet.channelId,\n                        uploaded: uploadedFormatted,\n                        title: tmp.snippet.localized.title,\n                        description: tmp.snippet.description,\n                        thumbnail: tmp.snippet.thumbnails.high.url,\n                        videoId: videoInfo.id,\n                        videoProvider: videoInfo.type,\n                        useYoutubeNocookie: videoInfo.useYoutubeNocookie\n                    };\n                    this._videoInformation = respData;\n                    this.element.trigger(this._UPDATE_VIDEO_INFORMATION_TRIGGER, respData);\n                    this.element.trigger(this._FINISH_UPDATE_INFORMATION_TRIGGER, true);\n                }\n\n                /**\n                 * @private\n                 */\n                function _onVimeoLoaded(data) {\n                    var tmp,\n                        respData;\n\n                    if (data.length < 1) {\n                        this._onRequestError($.mage.__('Video not found'));\n\n                        return null;\n                    }\n                    tmp = data[0];\n                    respData = {\n                        duration: this._formatVimeoDuration(tmp.duration),\n                        channel: tmp['user_name'],\n                        channelId: tmp['user_url'],\n                        uploaded: tmp['upload_date'],\n                        title: tmp.title,\n                        description: tmp.description.replace(/(&nbsp;|<([^>]+)>)/ig, ''),\n                        thumbnail: tmp['thumbnail_large'],\n                        videoId: videoInfo.id,\n                        videoProvider: videoInfo.type\n                    };\n                    this._videoInformation = respData;\n                    this.element.trigger(this._UPDATE_VIDEO_INFORMATION_TRIGGER, respData);\n                    this.element.trigger(this._FINISH_UPDATE_INFORMATION_TRIGGER, true);\n                }\n\n                type = videoInfo.type;\n                id = videoInfo.id;\n\n                if (type === 'youtube') {\n                    googleapisUrl = 'https://www.googleapis.com/youtube/v3/videos?id=' +\n                        id +\n                        '&part=snippet,contentDetails,statistics,status&key=' +\n                        this.options.youtubeKey + '&alt=json&callback=?';\n                    $.getJSON(googleapisUrl,\n                        {\n                            format: 'json'\n                        },\n                        $.proxy(_onYouTubeLoaded, self)\n                    ).fail(\n                        function () {\n                            self._onRequestError('Video not found');\n                        }\n                    );\n                } else if (type === 'vimeo') {\n                    $.ajax({\n                        url: 'https://www.vimeo.com/api/v2/video/' + id + '.json',\n                        dataType: 'jsonp',\n                        data: {\n                            format: 'json'\n                        },\n                        timeout: 5000,\n                        success:  $.proxy(_onVimeoLoaded, self),\n\n                        /**\n                         * @private\n                         */\n                        error: function () {\n                            self._onRequestError($.mage.__('Video not found'));\n                        }\n                    });\n                }\n            },\n\n            /**\n             * @private\n             */\n            _onVideoInvalid: function (event, data) {\n                this._videoInformation = null;\n                this.element.val('');\n                alert({\n                    content: 'Error: \"' + data + '\"'\n                });\n            },\n\n            /**\n             * @private\n             */\n            _onRequestError: function (error) {\n                this.element.trigger(this._ERROR_UPDATE_INFORMATION_TRIGGER, error);\n                this.element.trigger(this._FINISH_UPDATE_INFORMATION_TRIGGER, false);\n                this._currentVideoUrl = null;\n            },\n\n            /**\n             * @private\n             */\n            _formatYoutubeDuration: function (duration) {\n                var match = duration.match(/PT(\\d+H)?(\\d+M)?(\\d+S)?/),\n                    hours = parseInt(match[1], 10) || 0,\n                    minutes = parseInt(match[2], 10) || 0,\n                    seconds = parseInt(match[3], 10) || 0;\n\n                return this._formatVimeoDuration(hours * 3600 + minutes * 60 + seconds);\n            },\n\n            /**\n             * @private\n             */\n            _formatVimeoDuration: function (seconds) {\n                return (new Date(seconds * 1000)).toUTCString().match(/(\\d\\d:\\d\\d:\\d\\d)/)[0];\n            },\n\n            /**\n             * @private\n             */\n            _parseHref: function (href) {\n                var a = document.createElement('a');\n\n                a.href = href;\n\n                return a;\n            },\n\n            /**\n             * @private\n             */\n            _validateURL: function (href, forceVideo) {\n                var id,\n                    type,\n                    ampersandPosition,\n                    vimeoRegex,\n                    useYoutubeNocookie = false;\n\n                if (typeof href !== 'string') {\n                    return href;\n                }\n                href = this._parseHref(href);\n\n                if (href.host.match(/youtube\\.com/) && href.search) {\n\n                    id = href.search.split('v=')[1];\n\n                    if (id) {\n                        ampersandPosition = id.indexOf('&');\n                        type = 'youtube';\n                    }\n\n                    if (id && ampersandPosition !== -1) {\n                        id = id.substring(0, ampersandPosition);\n                    }\n\n                } else if (href.host.match(/youtube\\.com|youtu\\.be|youtube-nocookie.com/)) {\n                    id = href.pathname.replace(/^\\/(embed\\/|v\\/)?/, '').replace(/\\/.*/, '');\n                    type = 'youtube';\n\n                    if (href.host.match(/youtube-nocookie.com/)) {\n                        useYoutubeNocookie = true;\n                    }\n                } else if (href.host.match(/vimeo\\.com/)) {\n                    type = 'vimeo';\n                    vimeoRegex = new RegExp(['https?:\\\\/\\\\/(?:www\\\\.|player\\\\.)?vimeo.com\\\\/(?:channels\\\\/(?:\\\\w+\\\\/)',\n                        '?|groups\\\\/([^\\\\/]*)\\\\/videos\\\\/|album\\\\/(\\\\d+)\\\\/video\\\\/|video\\\\/|)(\\\\d+)(?:$|\\\\/|\\\\?)'\n                    ].join(''));\n\n                    if (href.href.match(vimeoRegex) != null) {\n                        id = href.href.match(vimeoRegex)[3];\n                    }\n                }\n\n                if ((!id || !type) && forceVideo) {\n                    id = href.href;\n                    type = 'custom';\n                }\n\n                return id ? {\n                    id: id, type: type, s: href.search.replace(/^\\?/, ''), useYoutubeNocookie: useYoutubeNocookie\n                } : false;\n            }\n        });\n    });\n","Magento_ProductVideo/js/new-video-dialog.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'mage/backend/tree-suggest',\n    'mage/backend/validation',\n    'Magento_ProductVideo/js/get-video-information'\n], function ($, _) {\n    'use strict';\n\n    $.widget('mage.createVideoPlayer', {\n        options: {\n            videoId: '',\n            videoProvider: '',\n            container: '.video-player-container',\n            videoClass: 'product-video',\n            reset: false,\n            useYoutubeNocookie: false,\n            metaData: {\n                DOM: {\n                    title: '.video-information.title span',\n                    uploaded: '.video-information.uploaded span',\n                    uploader: '.video-information.uploader span',\n                    duration: '.video-information.duration span',\n                    all: '.video-information span',\n                    wrapper: '.video-information'\n                },\n                data: {\n                    title: '',\n                    uploaded: '',\n                    uploader: '',\n                    uploaderUrl: '',\n                    duration: ''\n                }\n            }\n        },\n\n        _FINISH_CREATE_VIDEO_TRIGGER: 'finish_create_video',\n\n        _FINISH_UPDATE_VIDEO_TRIGGER: 'finish_update_video',\n\n        /**\n         * @private\n         */\n        _init: function () {\n            if (this.options.reset) {\n                this.reset();\n            } else {\n                this.update();\n            }\n\n            this.element.on('reset', $.proxy(this.reset, this));\n\n        },\n\n        /**\n         * @returns {Boolean}\n         */\n        update: function () {\n            var checkVideoID = this.element.find(this.options.container).find(\n                    '.' + this.options.videoClass\n                ).data('code'),\n                eventVideoData = {\n                    oldVideoId: checkVideoID ? checkVideoID.toString() : checkVideoID,\n                    newVideoId: this.options.videoId ? this.options.videoId.toString() : this.options.videoId\n                };\n\n            if (checkVideoID && checkVideoID !== this.options.videoId) {\n                this._doUpdate();\n                this.element.trigger(this._FINISH_UPDATE_VIDEO_TRIGGER, eventVideoData);\n            } else if (checkVideoID && checkVideoID === this.options.videoId) {\n                return false;\n            } else if (!checkVideoID) {\n                this._doUpdate();\n                this.element.trigger(this._FINISH_CREATE_VIDEO_TRIGGER, eventVideoData);\n            }\n\n        },\n\n        /**\n         * @private\n         */\n        _doUpdate: function () {\n            var uploaderLinkUrl,\n                uploaderLink;\n\n            this.reset();\n            this.element.find(this.options.container).append(\n                '<div class=\"' +\n                this.options.videoClass +\n                '\" data-type=\"' +\n                this.options.videoProvider +\n                '\" data-code=\"' +\n                this.options.videoId +\n                '\" data-youtubenocookie=\"' +\n                this.options.useYoutubeNocookie +\n                '\" data-width=\"100%\" data-height=\"100%\"></div>'\n            );\n            this.element.find(this.options.metaData.DOM.wrapper).show();\n            this.element.find(this.options.metaData.DOM.title).text(this.options.metaData.data.title);\n            this.element.find(this.options.metaData.DOM.uploaded).text(this.options.metaData.data.uploaded);\n            this.element.find(this.options.metaData.DOM.duration).text(this.options.metaData.data.duration);\n\n            if (this.options.videoProvider === 'youtube') {\n                uploaderLinkUrl = 'https://youtube.com/channel/' + this.options.metaData.data.uploaderUrl;\n            } else if (this.options.videoProvider === 'vimeo') {\n                uploaderLinkUrl = this.options.metaData.data.uploaderUrl;\n            }\n            uploaderLink = document.createElement('a');\n            uploaderLink.setAttribute('href', uploaderLinkUrl);\n            uploaderLink.setAttribute('target', '_blank');\n            uploaderLink.innerText = this.options.metaData.data.uploader;\n            this.element.find(this.options.metaData.DOM.uploader)[0].appendChild(uploaderLink);\n            this.element.find('.' + this.options.videoClass).productVideoLoader();\n\n        },\n\n        /**\n         * Reset\n         */\n        reset: function () {\n            this.element.find(this.options.container).find('.' + this.options.videoClass).remove();\n            this.element.find(this.options.metaData.DOM.wrapper).hide();\n            this.element.find(this.options.metaData.DOM.all).text('');\n\n        }\n    });\n\n    $.widget('mage.updateInputFields', {\n        options: {\n            reset: false,\n            DOM: {\n                urlField: 'input[name=\"video_url\"]',\n                titleField: 'input[name=\"video_title\"]',\n                fileField: '#file_name',\n                descriptionField: 'textarea[name=\"video_description\"]',\n                thumbnailLocation: '.field-new_video_screenshot_preview .admin__field-control'\n            },\n            data: {\n                url: '',\n                title: '',\n                description: '',\n                thumbnail: ''\n            }\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            if (this.options.reset) {\n                this.reset();\n            } else {\n                this.update();\n            }\n        },\n\n        /**\n         * Update\n         */\n        update: function () {\n            $(this.options.DOM.titleField).val(this.options.data.title);\n            $(this.options.DOM.descriptionField).val(this.options.data.description);\n        },\n\n        /**\n         * Reset\n         */\n        reset: function () {\n            $(this.options.DOM.fileField).val('');\n            $(this.options.DOM.urlField).val('');\n            $(this.options.DOM.titleField).val('');\n            $(this.options.DOM.descriptionField).val('');\n        }\n    });\n\n    /**\n     */\n    $.widget('mage.newVideoDialog', {\n\n        _previewImage: null,\n\n        clickedElement: '',\n\n        _images: {},\n\n        _imageTypes: [\n            '.jpeg',\n            '.pjpeg',\n            '.jpeg',\n            '.jpg',\n            '.pjpeg',\n            '.png',\n            '.gif'\n        ],\n\n        _imageProductGalleryWrapperSelector: '#image-container',\n\n        _videoPreviewInputSelector: '#new_video_screenshot',\n\n        _videoPreviewRemoteSelector: '',\n\n        _videoDisableinputSelector: '#new_video_disabled',\n\n        _videoPreviewImagePointer: '#new_video_screenshot_preview',\n\n        _videoFormSelector: '#new_video_form',\n\n        _itemIdSelector: '#item_id',\n\n        _videoUrlSelector: '[name=\"video_url\"]',\n\n        _videoImageFilenameselector: '#file_name',\n\n        _videoUrlWidget: null,\n\n        _videoInformationBtnSelector: '[name=\"new_video_get\"]',\n\n        _editVideoBtnSelector: '.image',\n\n        _deleteGalleryVideoSelector: '[data-role=delete-button]',\n\n        _deleteGalleryVideoSelectorBtn: null,\n\n        _videoInformationGetBtn: null,\n\n        _videoInformationGetUrlField: null,\n\n        _videoInformationGetEditBtn: null,\n\n        _isEditPage: false,\n\n        _onlyVideoPlayer: false,\n\n        _tempPreviewImageData: null,\n\n        _videoPlayerSelector: '.mage-new-video-dialog',\n\n        _videoRequestComplete: null,\n\n        _gallery: null,\n\n        /**\n         * Bind events\n         * @private\n         */\n        _bind: function () {\n            var events = {\n                'setImage': '_onSetImage'\n            };\n\n            this._on(events);\n\n            this._videoUrlWidget = this.element.find(this._videoUrlSelector).videoData({\n                youtubeKey: this.options.youTubeApiKey,\n                eventSource: 'focusout'\n            });\n\n            this._videoInformationGetBtn = this.element.find(this._videoInformationBtnSelector);\n            this._videoInformationGetUrlField = this.element.find(this._videoUrlSelector);\n            this._videoInformationGetEditBtn = this._gallery.find(this._editVideoBtnSelector);\n\n            this._videoInformationGetBtn.on('click', $.proxy(this._onGetVideoInformationClick, this));\n            this._videoInformationGetUrlField.on('focusout', $.proxy(this._onGetVideoInformationFocusOut, this));\n\n            this._videoUrlWidget.on('updated_video_information', $.proxy(this._onGetVideoInformationSuccess, this));\n            this._videoUrlWidget.on('error_updated_information', $.proxy(this._onGetVideoInformationError, this));\n            this._videoUrlWidget.on(\n                'request_video_information',\n                $.proxy(this._onGetVideoInformationStartRequest, this)\n            );\n        },\n\n        /**\n         * Fired when user click on button \"Get video information\"\n         * @private\n         */\n        _onGetVideoInformationClick: function () {\n            this._onlyVideoPlayer = false;\n            this._isEditPage = false;\n            this._videoUrlWidget.trigger('update_video_information');\n        },\n\n        /**\n         * Fired when user do focus out from url field\n         * @private\n         */\n        _onGetVideoInformationFocusOut: function () {\n            this._videoUrlWidget.trigger('update_video_information');\n        },\n\n        /**\n         * @private\n         */\n        _onGetVideoInformationStartRequest: function () {\n            this._videoRequestComplete = false;\n        },\n\n        /**\n         * Fired when user click Edit Video button\n         * @private\n         */\n        _onGetVideoInformationEditClick: function () {\n            this._onlyVideoPlayer = true;\n            this._isEditPage = true;\n            this._videoUrlWidget.trigger('update_video_information');\n        },\n\n        /**\n         * Fired when successfully received information about the video.\n         * @param {Object} e\n         * @param {Object} data\n         * @private\n         */\n        _onGetVideoInformationSuccess: function (e, data) {\n            var self = this;\n\n            self.element.on('finish_update_video finish_create_video', $.proxy(function (element, playerData) {\n                    if (!self._onlyVideoPlayer ||\n                        !self._isEditPage && playerData.oldVideoId !== playerData.newVideoId ||\n                        playerData.oldVideoId && playerData.oldVideoId !== playerData.newVideoId\n                    ) {\n                        self.element.updateInputFields({\n                            reset: false,\n                            data: {\n                                title: data.title,\n                                description: data.description\n                            }\n                        });\n                        this._loadRemotePreview(data.thumbnail);\n                    }\n                    self._onlyVideoPlayer = true;\n                }, this))\n                .createVideoPlayer({\n                    videoId: data.videoId,\n                    videoProvider: data.videoProvider,\n                    useYoutubeNocookie: data.useYoutubeNocookie,\n                    reset: false,\n                    metaData: {\n                        DOM: {\n                            title: '.video-information.title span',\n                            uploaded: '.video-information.uploaded span',\n                            uploader: '.video-information.uploader span',\n                            duration: '.video-information.duration span',\n                            all: '.video-information span',\n                            wrapper: '.video-information'\n                        },\n                        data: {\n                            title: data.title,\n                            uploaded: data.uploaded,\n                            uploader: data.channel,\n                            duration: data.duration,\n                            uploaderUrl: data.channelId\n                        }\n                    }\n                })\n                .off('finish_update_video finish_create_video');\n\n            this._videoRequestComplete = true;\n        },\n\n        /**\n         * Load preview from youtube/vimeo\n         * @param {String} sourceUrl\n         * @private\n         */\n        _loadRemotePreview: function (sourceUrl) {\n            var url = this.options.saveRemoteVideoUrl,\n                self = this;\n\n            this._getPreviewImage().attr('src', sourceUrl).hide();\n            this._blockActionButtons(true, true);\n            $.ajax({\n                url: url,\n                data: 'remote_image=' + sourceUrl,\n                type: 'post',\n                success: $.proxy(function (result) {\n                    this._tempPreviewImageData = result;\n                    this._getPreviewImage().attr('src', sourceUrl).show();\n                    this._blockActionButtons(false, true);\n                }, self)\n            });\n        },\n\n        /**\n         * Fired when receiving information about the video ended with error\n         * @private\n         */\n        _onGetVideoInformationError: function () {\n        },\n\n        /**\n         * Remove \".tmp\"\n         * @param {String} name\n         * @returns {*}\n         * @private\n         */\n        __prepareFilename: function (name) {\n            var tmppost = '.tmp';\n\n            if (!name) {\n                return name;\n            }\n\n            if (name.endsWith(tmppost)) {\n                name = name.slice(0, name.length - tmppost.length);\n            }\n\n            return name;\n        },\n\n        /**\n         * Set image data\n         * @param {String} file\n         * @param {Object} imageData\n         * @private\n         */\n        _setImage: function (file, imageData) {\n            file = this.__prepareFilename(file);\n            this._images[file] = imageData;\n            this._gallery.trigger('addItem', imageData);\n            this.element.trigger('setImage', imageData);\n            this._addVideoClass(imageData.url);\n        },\n\n        /**\n         * Get image data\n         *\n         * @param {String} file\n         * @returns {*}\n         * @private\n         */\n        _getImage: function (file) {\n            file = this.__prepareFilename(file);\n\n            return this._images[file];\n        },\n\n        /**\n         * Replace image (update)\n         * @param {String} oldFile\n         * @param {String} newFile\n         * @param {Object} imageData\n         * @private\n         */\n        _replaceImage: function (oldFile, newFile, imageData) {\n            var tmpNewFile = newFile,\n                tmpOldImage,\n                newImageId,\n                oldNewFilePosition,\n                fc,\n                suff,\n                searchsuff,\n                key,\n                oldValIdElem;\n\n            oldFile = this.__prepareFilename(oldFile);\n            newFile = this.__prepareFilename(newFile);\n            tmpOldImage = this._images[oldFile];\n\n            if (newFile === oldFile) {\n                this._images[newFile] = imageData;\n                this.saveImageRoles(imageData);\n                this._updateVisibility(imageData);\n                this._updateImageTitle(imageData);\n\n                return null;\n            }\n\n            this._removeImage(oldFile);\n            this._setImage(newFile, imageData);\n\n            if (!oldFile || !imageData.oldFile) {\n                return null;\n            }\n\n            newImageId = this.findElementId(tmpNewFile);\n            fc = this.element.find(this._itemIdSelector).val();\n\n            suff = 'product[media_gallery][images]' + fc;\n\n            searchsuff = 'input[name=\"' + suff + '[value_id]\"]';\n            key = this._gallery.find(searchsuff).val();\n\n            if (!key) {\n                return null;\n            }\n\n            oldValIdElem = document.createElement('input');\n            this._gallery.find('form[data-form=\"edit-product\"]').append(oldValIdElem);\n            $(oldValIdElem).attr({\n                type: 'hidden',\n                name: 'product[media_gallery][images][' + newImageId + '][save_data_from]'\n            }).val(key);\n\n            oldNewFilePosition = parseInt(tmpOldImage.position, 10);\n            imageData.position = oldNewFilePosition;\n\n            this._gallery.trigger('setPosition', {\n                imageData: imageData,\n                position: oldNewFilePosition\n            });\n        },\n\n        /**\n         * Remove image data\n         * @param {String} file\n         * @private\n         */\n        _removeImage: function (file) {\n            var imageData = this._getImage(file);\n\n            if (!imageData) {\n                return null;\n            }\n\n            this._gallery.trigger('removeItem', imageData);\n            this.element.trigger('removeImage', imageData);\n            delete this._images[file];\n        },\n\n        /**\n         * Fired when image setted\n         * @param {Event} event\n         * @param {Object} imageData\n         * @private\n         */\n        _onSetImage: function (event, imageData) {\n            this.saveImageRoles(imageData);\n        },\n\n        /**\n         *\n         * Wrap _uploadFile\n         * @param {String} file\n         * @param {String} oldFile\n         * @param {Function} callback\n         * @private\n         */\n        _uploadImage: function (file, oldFile, callback) {\n            var url = this.options.saveVideoUrl,\n                data = {\n                    files: file,\n                    url: url\n                };\n\n            this._blockActionButtons(true, true);\n            this._uploadFile(data, $.proxy(function (result) {\n                this._onImageLoaded(result, file, oldFile, callback);\n                this._blockActionButtons(false);\n            }, this));\n\n        },\n\n        /**\n         * @param {String} result\n         * @param {String} file\n         * @param {String} oldFile\n         * @param {Function} callback\n         * @private\n         */\n        _onImageLoaded: function (result, file, oldFile, callback) {\n            var data = JSON.parse(result);\n\n            if (this.element.find('#video_url').parent().find('.image-upload-error').length > 0) {\n                this.element.find('.image-upload-error').remove();\n            }\n\n            if (data.errorcode || data.error) {\n                this.element.find('#video_url').parent().append('<div class=\"image-upload-error\">' +\n                '<div class=\"image-upload-error-cross\"></div><span>' + data.error + '</span></div>');\n\n                return;\n            }\n            $.each(this.element.find(this._videoFormSelector).serializeArray(), function (i, field) {\n                data[field.name] = field.value;\n            });\n            data.disabled = this.element.find(this._videoDisableinputSelector).attr('checked') ? 1 : 0;\n            data['media_type'] = 'external-video';\n            data.oldFile = oldFile;\n\n            oldFile ?\n                this._replaceImage(oldFile, data.file, data) :\n                this._setImage(data.file, data);\n            callback.call(0, data);\n        },\n\n        /**\n         * File uploader\n         * @private\n         */\n        _uploadFile: function (data, callback) {\n            var fu = this.element.find(this._videoPreviewInputSelector),\n                tmpInput = document.createElement('input'),\n                fileUploader = null;\n\n            $(tmpInput).attr({\n                'name': fu.attr('name'),\n                'value': fu.val(),\n                'type': 'file',\n                'data-ui-ud': fu.attr('data-ui-ud')\n            }).css('display', 'none');\n            fu.parent().append(tmpInput);\n            fileUploader = $(tmpInput).fileupload();\n            fileUploader.fileupload('send', data).success(function (result, textStatus, jqXHR) {\n                tmpInput.remove();\n                callback.call(null, result, textStatus, jqXHR);\n            });\n        },\n\n        /**\n         * Update style\n         * @param {String} url\n         * @private\n         */\n        _addVideoClass: function (url) {\n            var classVideo = 'video-item';\n\n            this._gallery.find('img[src=\"' + url + '\"]').addClass(classVideo);\n        },\n\n        /**\n         * Build widget\n         * @private\n         */\n        _create: function () {\n            var imgs = _.values(this.element.closest(this.options.videoSelector).data('images')) || [],\n                widget,\n                uploader,\n                tmp,\n                i;\n\n            this._gallery =  this.element.closest(this.options.videoSelector);\n\n            for (i = 0; i < imgs.length; i++) {\n                tmp = imgs[i];\n                this._images[tmp.file] = tmp;\n\n                if (tmp['media_type'] === 'external-video') {\n                    tmp.subclass = 'video-item';\n                    this._addVideoClass(tmp.url);\n                }\n            }\n\n            this._gallery.on('openDialog', $.proxy(this._onOpenDialog, this));\n            this._bind();\n            this.createVideoItemIcons();\n            widget = this;\n            uploader = this.element.find(this._videoPreviewInputSelector);\n            uploader.on('change', this._onImageInputChange.bind(this));\n            uploader.attr('accept', this._imageTypes.join(','));\n\n            this.element.modal({\n                type: 'slide',\n                //appendTo: this._gallery,\n                modalClass: 'mage-new-video-dialog form-inline',\n                title: $.mage.__('New Video'),\n                buttons: [\n                    {\n                        text: $.mage.__('Save'),\n                        class: 'action-primary video-create-button',\n                        click: $.proxy(widget._onCreate, widget)\n                    },\n                    {\n                        text: $.mage.__('Cancel'),\n                        class: 'video-cancel-button',\n                        click: $.proxy(widget._onCancel, widget)\n                    },\n                    {\n                        text: $.mage.__('Delete'),\n                        class: 'video-delete-button',\n                        click: $.proxy(widget._onDelete, widget)\n                    },\n                    {\n                        text: $.mage.__('Save'),\n                        class: 'action-primary video-edit',\n                        click: $.proxy(widget._onUpdate, widget)\n                    }\n                ],\n\n                /**\n                 * @returns {null}\n                 */\n                opened: function () {\n                    var roles,\n                        file,\n                        modalTitleElement,\n                        imageData,\n                        modal = widget.element.closest('.mage-new-video-dialog');\n\n                    widget.element.find('#video_url').focus();\n                    roles = widget.element.find('.video_image_role');\n                    roles.prop('disabled', false);\n                    file = widget.element.find('#file_name').val();\n                    widget._onGetVideoInformationEditClick();\n                    modalTitleElement = modal.find('.modal-title');\n\n                    if (!file) {\n                        widget._blockActionButtons(true);\n\n                        modal.find('.video-delete-button').hide();\n                        modal.find('.video-edit').hide();\n                        modal.find('.video-create-button').show();\n                        roles.prop('checked', widget._gallery.find('.image.item:not(.removed)').length < 1);\n                        modalTitleElement.text($.mage.__('New Video'));\n                        widget._isEditPage = false;\n\n                        return null;\n                    }\n                    widget._blockActionButtons(false);\n                    modalTitleElement.text($.mage.__('Edit Video'));\n                    widget._isEditPage = true;\n                    imageData = widget._getImage(file);\n\n                    if (!imageData) {\n                        imageData = {\n                            url: _.find(widget._gallery.find('.product-image'), function (image) {\n                                return image.src.indexOf(file) > -1;\n                            }).src\n                        };\n                    }\n\n                    widget._onPreview(null, imageData.url, false);\n                },\n\n                /**\n                 * Closed\n                 */\n                closed: function () {\n                    widget._onClose();\n                    widget.createVideoItemIcons();\n                }\n            });\n            this.toggleButtons();\n        },\n\n        /**\n         * @param {String} status\n         * @private\n         */\n        _blockActionButtons: function (status) {\n            this.element\n                .closest('.mage-new-video-dialog')\n                .find('.page-actions-buttons button.video-create-button, .page-actions-buttons button.video-edit')\n                .attr('disabled', status);\n        },\n\n        /**\n         * Check form\n         * @param {Function} callback\n         */\n        isValid: function (callback) {\n            var videoForm = this.element.find(this._videoFormSelector),\n                videoLoaded = true;\n\n            this._blockActionButtons(true);\n\n            this._videoUrlWidget.trigger('validate_video_url', $.proxy(function () {\n\n                videoForm.mage('validation', {\n\n                    /**\n                     * @param {jQuery} error\n                     * @param {jQuery} element\n                     */\n                    errorPlacement: function (error, element) {\n                        error.insertAfter(element);\n                    }\n                }).on('highlight.validate', function () {\n                    $(this).validation('option');\n                });\n\n                videoForm.validation();\n\n                if (this._videoRequestComplete === false) {\n                    videoLoaded = false;\n                }\n\n                callback(videoForm.valid() && videoLoaded);\n            }, this));\n\n            this._blockActionButtons(false);\n        },\n\n        /**\n         * Create video item icons\n         */\n        createVideoItemIcons: function () {\n            var $imageWidget = this._gallery.find('.product-image.video-item'),\n                $productGalleryWrapper = $(this._imageProductGalleryWrapperSelector).find('.product-image.video-item');\n\n            $imageWidget.parent().addClass('video-item');\n            $productGalleryWrapper.parent().addClass('video-item');\n            $imageWidget.removeClass('video-item');\n            $productGalleryWrapper.removeClass('video-item');\n            $('.video-item .action-delete').attr('title', $.mage.__('Delete video'));\n            $('.video-item .action-delete span').html($.mage.__('Delete video'));\n        },\n\n        /**\n         * Fired when click on create video\n         * @private\n         */\n        _onCreate: function () {\n            var nvs = this.element.find(this._videoPreviewInputSelector),\n                file = nvs.get(0),\n                reqClass = 'required-entry _required';\n\n            if (file && file.files && file.files.length) {\n                file = file.files[0];\n            } else {\n                file = null;\n            }\n\n            if (!file && !this._tempPreviewImageData) {\n                nvs.addClass(reqClass);\n            }\n\n            this.isValid($.proxy(\n                function (videoValidStatus) {\n\n                    if (!videoValidStatus) {\n                        return;\n                    }\n\n                    if (this._tempPreviewImageData) {\n                        this._onImageLoaded(this._tempPreviewImageData, null, null, $.proxy(this.close, this));\n                    } else {\n                        this._uploadImage(file, null, $.proxy(function () {\n                            this.close();\n                        }, this));\n                    }\n\n                    nvs.removeClass(reqClass);\n                }, this\n            ));\n        },\n\n        /**\n         * Fired when click on update video\n         * @private\n         */\n        _onUpdate: function () {\n            var inputFile, itemId, _inputSelector, mediaFields, imageData, flagChecked, fileName, callback;\n\n            this.isValid($.proxy(\n                function (videoValidStatus) {\n\n                    if (!videoValidStatus) {\n                        return;\n                    }\n\n                    imageData = this.imageData || {};\n                    inputFile = this.element.find(this._videoPreviewInputSelector);\n                    itemId = this.element.find(this._itemIdSelector).val();\n                    itemId = itemId.slice(1, itemId.length - 1);\n                    _inputSelector = '[name*=\"[' + itemId + ']\"]';\n                    mediaFields = this._gallery.find('input' + _inputSelector);\n                    $.each(mediaFields, function (i, el) {\n                        var elName = el.name,\n                            start = elName.indexOf(itemId) + itemId.length + 2,\n                            fieldName = elName.substring(start, el.name.length - 1),\n                            _field = this.element.find('#' + fieldName),\n                            _tmp;\n\n                        if (_field.length > 0) {\n                            _tmp = _inputSelector.slice(0, _inputSelector.length - 2) + '[' + fieldName + ']\"]';\n                            this._gallery.find(_tmp).val(_field.val());\n                            imageData[fieldName] = _field.val();\n                        }\n                    }.bind(this));\n                    flagChecked = this.element.find(this._videoDisableinputSelector).attr('checked') ? 1 : 0;\n                    this._gallery.find('input[name*=\"' + itemId + '][disabled]\"]').val(flagChecked);\n                    this._gallery.find(_inputSelector).siblings('.image-fade').css(\n                        'visibility', flagChecked ? 'visible' : 'hidden'\n                    );\n                    imageData.disabled = flagChecked;\n\n                    if (this._tempPreviewImageData) {\n                        this._onImageLoaded(\n                            this._tempPreviewImageData,\n                            null,\n                            imageData.file,\n                            $.proxy(this.close, this)\n                        );\n\n                        return;\n                    }\n                    fileName = inputFile.get(0).files;\n\n                    if (!fileName || !fileName.length) {\n                        fileName = null;\n                    }\n                    inputFile.replaceWith(inputFile);\n\n                    callback = $.proxy(function () {\n                        this.close();\n                    }, this);\n\n                    if (fileName) {\n                        this._uploadImage(fileName, imageData.file, callback);\n                    } else {\n                        this._replaceImage(imageData.file, imageData.file, imageData);\n                        callback(0, imageData);\n                    }\n                }, this\n            ));\n        },\n\n        /**\n         * Delegates call to producwt gallery to update video visibility.\n         *\n         * @param {Object} imageData\n         */\n        _updateVisibility: function (imageData) {\n            this._gallery.trigger('updateVisibility', {\n                disabled: imageData.disabled,\n                imageData: imageData\n            });\n        },\n\n        /**\n         * Delegates call to product gallery to update video title.\n         *\n         * @param {Object} imageData\n         */\n        _updateImageTitle: function (imageData) {\n            this._gallery.trigger('updateImageTitle', {\n                imageData: imageData\n            });\n        },\n\n        /**\n         * Fired when clicked on cancel\n         * @private\n         */\n        _onCancel: function () {\n            this.close();\n        },\n\n        /**\n         * Fired when clicked on delete\n         * @private\n         */\n        _onDelete: function () {\n            var filename = this.element.find(this._videoImageFilenameselector).val();\n\n            this._removeImage(filename);\n            this.close();\n        },\n\n        /**\n         * @param {String} file\n         * @param {Function} callback\n         * @private\n         */\n        _readPreviewLocal: function (file, callback) {\n            var fr = new FileReader;\n\n            if (!window.FileReader) {\n                return;\n            }\n\n            /**\n             * On load end\n             */\n            fr.onloadend = function () {\n                callback(fr.result);\n            };\n            fr.readAsDataURL(file);\n        },\n\n        /**\n         *  Image file input handler\n         * @private\n         */\n        _onImageInputChange: function () {\n            var jFile = this.element.find(this._videoPreviewInputSelector),\n                file = jFile[0],\n                val = jFile.val(),\n                prev = this._getPreviewImage(),\n                ext = '.' + val.split('.').pop();\n\n            if (!val) {\n                return;\n            }\n            ext = ext ? ext.toLowerCase() : '';\n\n            if (\n                ext.length < 2 ||\n                this._imageTypes.indexOf(ext.toLowerCase()) === -1 || !file.files || !file.files.length\n            ) {\n                prev.remove();\n                this._previewImage = null;\n                jFile.val('');\n\n                return;\n            } // end if\n            file = file.files[0];\n            this._tempPreviewImageData = null;\n            this._onPreview(null, file, true);\n        },\n\n        /**\n         * Change Preview\n         * @param {String} error\n         * @param {String} src\n         * @param {Boolean} local\n         * @private\n         */\n        _onPreview: function (error, src, local) {\n            var img, renderImage;\n\n            img = this._getPreviewImage();\n\n            /**\n             * Callback\n             * @param {String} source\n             */\n            renderImage = function (source) {\n                img.attr({\n                    'src': source\n                }).show();\n            };\n\n            if (error) {\n                return;\n            }\n\n            if (!local) {\n                renderImage(src);\n            } else {\n                this._readPreviewLocal(src, renderImage);\n            }\n        },\n\n        /**\n         *\n         * Return preview image imstance\n         * @returns {null}\n         * @private\n         */\n        _getPreviewImage: function () {\n\n            if (!this._previewImage) {\n                this._previewImage = $(document.createElement('img')).css({\n                    'width': '100%',\n                    'display': 'none',\n                    'src': ''\n                });\n                $(this._previewImage).insertAfter(this.element.find(this._videoPreviewImagePointer));\n                $(this._previewImage).attr('data-role', 'video_preview_image');\n            }\n\n            return this._previewImage;\n        },\n\n        /**\n         * Close slideout dialog\n         */\n        close: function () {\n            this.element.modal('closeModal');\n        },\n\n        /**\n         * Close dialog wrap\n         * @private\n         */\n        _onClose: function () {\n            var newVideoForm;\n\n            this._isEditPage = true;\n            this.imageData = null;\n\n            if (this._previewImage) {\n                this._previewImage.remove();\n                this._previewImage = null;\n            }\n            this._tempPreviewImageData = null;\n            this.element.trigger('reset');\n            newVideoForm = this.element.find(this._videoFormSelector);\n\n            $(newVideoForm).find('input[type=\"hidden\"][name!=\"form_key\"]').val('');\n            this._gallery.find('input[name*=\"' + this.element.find(\n                    this._itemIdSelector).val() + '\"]'\n            ).parent().removeClass('active');\n\n            try {\n                newVideoForm.validation('clearError');\n            } catch (e) {\n\n            }\n            newVideoForm.trigger('reset');\n        },\n\n        /**\n         * Find element by fileName\n         * @param {String} file\n         */\n        findElementId: function (file) {\n            var elem = this._gallery.find('.image.item').find('input[value=\"' + file + '\"]');\n\n            if (!elem.length) {\n                return null;\n            }\n\n            return $(elem).attr('name').replace('product[media_gallery][images][', '').replace('][file]', '');\n        },\n\n        /**\n         * Save image roles\n         * @param {Object} imageData\n         */\n        saveImageRoles: function (imageData) {\n            var data = imageData.file,\n                self = this,\n                containers;\n\n            if (data && data.length > 0) {\n                containers = this._gallery.find('.image-placeholder').siblings('input');\n                $.each(containers, function (i, el) {\n                    var start = el.name.indexOf('[') + 1,\n                        end = el.name.indexOf(']'),\n                        imageType = el.name.substring(start, end),\n                        imageCheckbox = self.element.find(\n                            self._videoFormSelector + ' input[value=\"' + imageType + '\"]'\n                        );\n\n                    self._changeRole(imageType, imageCheckbox.attr('checked'), imageData);\n                });\n            }\n        },\n\n        /**\n         * Change image role\n         * @param {String} imageType - role name\n         * @param {bool} isEnabled - role active status\n         * @param {Object} imageData - image data object\n         * @private\n         */\n        _changeRole: function (imageType, isEnabled, imageData) {\n            var needCheked = true;\n\n            if (!isEnabled) {\n                needCheked = this._gallery.find('input[name=\"product[' + imageType + ']\"]').val() === imageData.file;\n            }\n\n            if (!needCheked) {\n                return null;\n            }\n\n            this._gallery.trigger('setImageType', {\n                type: imageType,\n                imageData: isEnabled ? imageData : null\n            });\n        },\n\n        /**\n         * On open dialog\n         * @param {Object} e\n         * @param {Object} imageData\n         * @private\n         */\n        _onOpenDialog: function (e, imageData) {\n            var formFields, flagChecked, file,\n                modal = this.element.closest('.mage-new-video-dialog');\n\n            if (imageData['media_type'] === 'external-video') {\n                this.imageData = imageData;\n                modal.find('.video-create-button').hide();\n                modal.find('.video-delete-button').show();\n                modal.find('.video-edit').show();\n                modal.createVideoPlayer({\n                    reset: true\n                }).createVideoPlayer('reset');\n\n                formFields = modal.find(this._videoFormSelector).find('.edited-data');\n\n                $.each(formFields, function (i, field) {\n                    $(field).val(imageData[field.name]);\n                });\n\n                flagChecked = imageData.disabled > 0;\n                modal.find(this._videoDisableinputSelector).prop('checked', flagChecked);\n\n                file = modal.find('#file_name').val(imageData.file);\n\n                $.each(modal.find('.video_image_role'), function () {\n                    $(this).prop('checked', false).prop('disabled', false);\n                });\n\n                $.each(this._gallery.find('.image-placeholder').siblings('input:hidden'), function () {\n                    var start, end, imageRole;\n\n                    if ($(this).val() === file.val()) {\n                        start = this.name.indexOf('[') + 1;\n                        end = this.name.length - 1;\n                        imageRole = this.name.substring(start, end);\n                        modal.find('#new_video_form input[value=\"' + imageRole + '\"]').prop('checked', true);\n                    }\n                });\n            }\n\n        },\n\n        /**\n         * Toggle buttons\n         */\n        toggleButtons: function () {\n            var self = this,\n                modal = this.element.closest('.mage-new-video-dialog');\n\n            modal.find('.video-placeholder, .add-video-button-container > button').click(function () {\n                modal.find('.video-create-button').show();\n                modal.find('.video-delete-button').hide();\n                modal.find('.video-edit').hide();\n                modal.createVideoPlayer({\n                    reset: true\n                }).createVideoPlayer('reset').updateInputFields({\n                    reset: true\n                }).updateInputFields('reset');\n            });\n            this._gallery.on('click', '.item.video-item', function () {\n                modal.find('.video-create-button').hide();\n                modal.find('.video-delete-button').show();\n                modal.find('.video-edit').show();\n                modal.find('.mage-new-video-dialog').createVideoPlayer({\n                    reset: true\n                }).createVideoPlayer('reset');\n            });\n            this._gallery.on('click', '.item.video-item:not(.removed)', function () {\n                var flagChecked,\n                    file,\n                    formFields = modal.find('.edited-data'),\n                    container = $(this);\n\n                $.each(formFields, function (i, field) {\n                    $(field).val(container.find('input[name*=\"' + field.name + '\"]').val());\n                });\n\n                flagChecked = container.find('input[name*=\"disabled\"]').val() > 0;\n                self._gallery.find(self._videoDisableinputSelector).attr('checked', flagChecked);\n\n                file = self._gallery.find('#file_name').val(container.find('input[name*=\"file\"]').val());\n\n                $.each(self._gallery.find('.video_image_role'), function () {\n                    $(this).prop('checked', false).prop('disabled', false);\n                });\n\n                $.each(self._gallery.find('.image-placeholder').siblings('input:hidden'), function () {\n                    var start, end, imageRole;\n\n                    if ($(this).val() !== file.val()) {\n                        return null;\n                    }\n\n                    start = this.name.indexOf('[') + 1;\n                    end = this.name.length - 1;\n                    imageRole = this.name.substring(start, end);\n                    self._gallery.find('input[value=\"' + imageRole + '\"]').prop('checked', true);\n                });\n            });\n        }\n    });\n\n    $('#group-fields-image-management > legend > span').text($.mage.__('Images and Videos'));\n\n    return $.mage.newVideoDialog;\n});\n","Magento_ProductVideo/js/video-modal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'productGallery',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'mage/backend/tree-suggest',\n    'mage/backend/validation',\n    'newVideoDialog'\n], function ($, productGallery) {\n    'use strict';\n\n    $.widget('mage.productGallery', productGallery, {\n\n        /**\n         * Bind events\n         * @private\n         */\n        _bind: function () {\n            var events = {},\n                itemId;\n\n            this._super();\n\n            /**\n             * Add item_id value to opened modal\n             * @param {Object} event\n             */\n            events['click ' + this.options.imageSelector] = function (event) {\n                if (!$(event.currentTarget).is('.ui-sortable-helper')) {\n                    itemId = $(event.currentTarget).find('input')[0].name.match(/\\[([^\\]]*)\\]/g)[2];\n                    this.videoDialog.find('#item_id').val(itemId);\n                }\n            };\n            this._on(events);\n            this.element.prev().find('[data-role=\"add-video-button\"]').on('click', this.showModal.bind(this));\n            this.element.on('openDialog', '.gallery.ui-sortable', $.proxy(this._onOpenDialog, this));\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this._super();\n            this.videoDialog = this.element.find('#new-video');\n            this.videoDialog.mage('newVideoDialog', this.videoDialog.data('modalInfo'));\n        },\n\n        /**\n         * Open dialog for external video\n         * @private\n         */\n        _onOpenDialog: function (e, imageData) {\n\n            if (imageData['media_type'] !== 'external-video') {\n                this._superApply(arguments);\n            } else {\n                this.showModal();\n            }\n        },\n\n        /**\n         * Fired on trigger \"openModal\"\n         */\n        showModal: function () {\n            this.videoDialog.modal('openModal');\n        }\n    });\n\n    return $.mage.productGallery;\n});\n","Magento_Translation/js/i18n-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function () {\n    'use strict';\n\n    require.config({\n        config: {\n            'Magento_Ui/js/lib/knockout/bindings/i18n': {\n                inlineTranslation: true\n            }\n        }\n    });\n})();\n","Temando_Shipping/static/js/12.d17f3c98.chunk.js":"webpackJsonp([12],{131:function(e,r,t){\"use strict\";Object.defineProperty(r,\"__esModule\",{value:!0});var n=t(963),o=function(e){return e&&e.__esModule?e:{default:e}}(n);r.default=o.default,e.exports=r.default},255:function(e,r,t){\"use strict\";r.__esModule=!0;var n=t(105),o=function(e){return e&&e.__esModule?e:{default:e}}(n);r.default=o.default||function(e){for(var r=1;r<arguments.length;r++){var t=arguments[r];for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])}return e}},256:function(e,r,t){\"use strict\";r.__esModule=!0,r.default=function(e,r){if(!(e instanceof r))throw new TypeError(\"Cannot call a class as a function\")}},257:function(e,r,t){\"use strict\";r.__esModule=!0;var n=t(337),o=function(e){return e&&e.__esModule?e:{default:e}}(n);r.default=function(){function e(e,r){for(var t=0;t<r.length;t++){var n=r[t];n.enumerable=n.enumerable||!1,n.configurable=!0,\"value\"in n&&(n.writable=!0),(0,o.default)(e,n.key,n)}}return function(r,t,n){return t&&e(r.prototype,t),n&&e(r,n),r}}()},258:function(e,r,t){e.exports={default:t(411),__esModule:!0}},259:function(e,r,t){\"use strict\";r.__esModule=!0;var n=t(311),o=function(e){return e&&e.__esModule?e:{default:e}}(n);r.default=function(e,r){if(!e)throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\");return!r||\"object\"!==(\"undefined\"===typeof r?\"undefined\":(0,o.default)(r))&&\"function\"!==typeof r?e:r}},260:function(e,r,t){\"use strict\";function n(e){return e&&e.__esModule?e:{default:e}}r.__esModule=!0;var o=t(423),u=n(o),a=t(427),i=n(a),l=t(311),c=n(l);r.default=function(e,r){if(\"function\"!==typeof r&&null!==r)throw new TypeError(\"Super expression must either be null or a function, not \"+(\"undefined\"===typeof r?\"undefined\":(0,c.default)(r)));e.prototype=(0,i.default)(r&&r.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),r&&(u.default?(0,u.default)(e,r):e.__proto__=r)}},261:function(e,r,t){var n,o;!function(){\"use strict\";function t(){for(var e=[],r=0;r<arguments.length;r++){var n=arguments[r];if(n){var o=typeof n;if(\"string\"===o||\"number\"===o)e.push(n);else if(Array.isArray(n)&&n.length){var a=t.apply(null,n);a&&e.push(a)}else if(\"object\"===o)for(var i in n)u.call(n,i)&&n[i]&&e.push(i)}}return e.join(\" \")}var u={}.hasOwnProperty;\"undefined\"!==typeof e&&e.exports?(t.default=t,e.exports=t):(n=[],void 0!==(o=function(){return t}.apply(r,n))&&(e.exports=o))}()},262:function(e,r,t){\"use strict\";r.__esModule=!0;var n=t(337),o=function(e){return e&&e.__esModule?e:{default:e}}(n);r.default=function(e,r,t){return r in e?(0,o.default)(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}},263:function(e,r,t){\"use strict\";r.__esModule=!0,r.default=function(e,r){var t={};for(var n in e)r.indexOf(n)>=0||Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n]);return t}},265:function(e,r,t){e.exports={default:t(436),__esModule:!0}},270:function(e,r,t){(function(e,n){var o;(function(){function u(e,r,t){switch(t.length){case 0:return e.call(r);case 1:return e.call(r,t[0]);case 2:return e.call(r,t[0],t[1]);case 3:return e.call(r,t[0],t[1],t[2])}return e.apply(r,t)}function a(e,r,t,n){for(var o=-1,u=null==e?0:e.length;++o<u;){var a=e[o];r(n,a,t(a),e)}return n}function i(e,r){for(var t=-1,n=null==e?0:e.length;++t<n&&!1!==r(e[t],t,e););return e}function l(e,r){for(var t=null==e?0:e.length;t--&&!1!==r(e[t],t,e););return e}function c(e,r){for(var t=-1,n=null==e?0:e.length;++t<n;)if(!r(e[t],t,e))return!1;return!0}function s(e,r){for(var t=-1,n=null==e?0:e.length,o=0,u=[];++t<n;){var a=e[t];r(a,t,e)&&(u[o++]=a)}return u}function f(e,r){return!!(null==e?0:e.length)&&E(e,r,0)>-1}function p(e,r,t){for(var n=-1,o=null==e?0:e.length;++n<o;)if(t(r,e[n]))return!0;return!1}function d(e,r){for(var t=-1,n=null==e?0:e.length,o=Array(n);++t<n;)o[t]=r(e[t],t,e);return o}function h(e,r){for(var t=-1,n=r.length,o=e.length;++t<n;)e[o+t]=r[t];return e}function g(e,r,t,n){var o=-1,u=null==e?0:e.length;for(n&&u&&(t=e[++o]);++o<u;)t=r(t,e[o],o,e);return t}function m(e,r,t,n){var o=null==e?0:e.length;for(n&&o&&(t=e[--o]);o--;)t=r(t,e[o],o,e);return t}function v(e,r){for(var t=-1,n=null==e?0:e.length;++t<n;)if(r(e[t],t,e))return!0;return!1}function b(e){return e.split(\"\")}function y(e){return e.match(jr)||[]}function _(e,r,t){var n;return t(e,function(e,t,o){if(r(e,t,o))return n=t,!1}),n}function w(e,r,t,n){for(var o=e.length,u=t+(n?1:-1);n?u--:++u<o;)if(r(e[u],u,e))return u;return-1}function E(e,r,t){return r===r?Y(e,r,t):w(e,A,t)}function x(e,r,t,n){for(var o=t-1,u=e.length;++o<u;)if(n(e[o],r))return o;return-1}function A(e){return e!==e}function q(e,r){var t=null==e?0:e.length;return t?O(e,r)/t:Le}function D(e){return function(r){return null==r?te:r[e]}}function C(e){return function(r){return null==e?te:e[r]}}function k(e,r,t,n,o){return o(e,function(e,o,u){t=n?(n=!1,e):r(t,e,o,u)}),t}function S(e,r){var t=e.length;for(e.sort(r);t--;)e[t]=e[t].value;return e}function O(e,r){for(var t,n=-1,o=e.length;++n<o;){var u=r(e[n]);u!==te&&(t=t===te?u:t+u)}return t}function T(e,r){for(var t=-1,n=Array(e);++t<e;)n[t]=r(t);return n}function R(e,r){return d(r,function(r){return[r,e[r]]})}function L(e){return function(r){return e(r)}}function N(e,r){return d(r,function(r){return e[r]})}function P(e,r){return e.has(r)}function B(e,r){for(var t=-1,n=e.length;++t<n&&E(r,e[t],0)>-1;);return t}function j(e,r){for(var t=e.length;t--&&E(r,e[t],0)>-1;);return t}function I(e,r){for(var t=e.length,n=0;t--;)e[t]===r&&++n;return n}function U(e){return\"\\\\\"+At[e]}function F(e,r){return null==e?te:e[r]}function M(e){return gt.test(e)}function V(e){return mt.test(e)}function H(e){for(var r,t=[];!(r=e.next()).done;)t.push(r.value);return t}function z(e){var r=-1,t=Array(e.size);return e.forEach(function(e,n){t[++r]=[n,e]}),t}function G(e,r){return function(t){return e(r(t))}}function W(e,r){for(var t=-1,n=e.length,o=0,u=[];++t<n;){var a=e[t];a!==r&&a!==le||(e[t]=le,u[o++]=t)}return u}function J(e){var r=-1,t=Array(e.size);return e.forEach(function(e){t[++r]=e}),t}function Z(e){var r=-1,t=Array(e.size);return e.forEach(function(e){t[++r]=[e,e]}),t}function Y(e,r,t){for(var n=t-1,o=e.length;++n<o;)if(e[n]===r)return n;return-1}function K(e,r,t){for(var n=t+1;n--;)if(e[n]===r)return n;return n}function $(e){return M(e)?X(e):Mt(e)}function Q(e){return M(e)?ee(e):b(e)}function X(e){for(var r=dt.lastIndex=0;dt.test(e);)++r;return r}function ee(e){return e.match(dt)||[]}function re(e){return e.match(ht)||[]}var te,ne=200,oe=\"Unsupported core-js use. Try https://npms.io/search?q=ponyfill.\",ue=\"Expected a function\",ae=\"__lodash_hash_undefined__\",ie=500,le=\"__lodash_placeholder__\",ce=1,se=2,fe=4,pe=1,de=2,he=1,ge=2,me=4,ve=8,be=16,ye=32,_e=64,we=128,Ee=256,xe=512,Ae=30,qe=\"...\",De=800,Ce=16,ke=1,Se=2,Oe=1/0,Te=9007199254740991,Re=1.7976931348623157e308,Le=NaN,Ne=4294967295,Pe=Ne-1,Be=Ne>>>1,je=[[\"ary\",we],[\"bind\",he],[\"bindKey\",ge],[\"curry\",ve],[\"curryRight\",be],[\"flip\",xe],[\"partial\",ye],[\"partialRight\",_e],[\"rearg\",Ee]],Ie=\"[object Arguments]\",Ue=\"[object Array]\",Fe=\"[object AsyncFunction]\",Me=\"[object Boolean]\",Ve=\"[object Date]\",He=\"[object DOMException]\",ze=\"[object Error]\",Ge=\"[object Function]\",We=\"[object GeneratorFunction]\",Je=\"[object Map]\",Ze=\"[object Number]\",Ye=\"[object Null]\",Ke=\"[object Object]\",$e=\"[object Proxy]\",Qe=\"[object RegExp]\",Xe=\"[object Set]\",er=\"[object String]\",rr=\"[object Symbol]\",tr=\"[object Undefined]\",nr=\"[object WeakMap]\",or=\"[object WeakSet]\",ur=\"[object ArrayBuffer]\",ar=\"[object DataView]\",ir=\"[object Float32Array]\",lr=\"[object Float64Array]\",cr=\"[object Int8Array]\",sr=\"[object Int16Array]\",fr=\"[object Int32Array]\",pr=\"[object Uint8Array]\",dr=\"[object Uint8ClampedArray]\",hr=\"[object Uint16Array]\",gr=\"[object Uint32Array]\",mr=/\\b__p \\+= '';/g,vr=/\\b(__p \\+=) '' \\+/g,br=/(__e\\(.*?\\)|\\b__t\\)) \\+\\n'';/g,yr=/&(?:amp|lt|gt|quot|#39);/g,_r=/[&<>\"']/g,wr=RegExp(yr.source),Er=RegExp(_r.source),xr=/<%-([\\s\\S]+?)%>/g,Ar=/<%([\\s\\S]+?)%>/g,qr=/<%=([\\s\\S]+?)%>/g,Dr=/\\.|\\[(?:[^[\\]]*|([\"'])(?:(?!\\1)[^\\\\]|\\\\.)*?\\1)\\]/,Cr=/^\\w*$/,kr=/[^.[\\]]+|\\[(?:(-?\\d+(?:\\.\\d+)?)|([\"'])((?:(?!\\2)[^\\\\]|\\\\.)*?)\\2)\\]|(?=(?:\\.|\\[\\])(?:\\.|\\[\\]|$))/g,Sr=/[\\\\^$.*+?()[\\]{}|]/g,Or=RegExp(Sr.source),Tr=/^\\s+|\\s+$/g,Rr=/^\\s+/,Lr=/\\s+$/,Nr=/\\{(?:\\n\\/\\* \\[wrapped with .+\\] \\*\\/)?\\n?/,Pr=/\\{\\n\\/\\* \\[wrapped with (.+)\\] \\*/,Br=/,? & /,jr=/[^\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\x7f]+/g,Ir=/\\\\(\\\\)?/g,Ur=/\\$\\{([^\\\\}]*(?:\\\\.[^\\\\}]*)*)\\}/g,Fr=/\\w*$/,Mr=/^[-+]0x[0-9a-f]+$/i,Vr=/^0b[01]+$/i,Hr=/^\\[object .+?Constructor\\]$/,zr=/^0o[0-7]+$/i,Gr=/^(?:0|[1-9]\\d*)$/,Wr=/[\\xc0-\\xd6\\xd8-\\xf6\\xf8-\\xff\\u0100-\\u017f]/g,Jr=/($^)/,Zr=/['\\n\\r\\u2028\\u2029\\\\]/g,Yr=\"\\\\u0300-\\\\u036f\\\\ufe20-\\\\ufe2f\\\\u20d0-\\\\u20ff\",Kr=\"\\\\xac\\\\xb1\\\\xd7\\\\xf7\\\\x00-\\\\x2f\\\\x3a-\\\\x40\\\\x5b-\\\\x60\\\\x7b-\\\\xbf\\\\u2000-\\\\u206f \\\\t\\\\x0b\\\\f\\\\xa0\\\\ufeff\\\\n\\\\r\\\\u2028\\\\u2029\\\\u1680\\\\u180e\\\\u2000\\\\u2001\\\\u2002\\\\u2003\\\\u2004\\\\u2005\\\\u2006\\\\u2007\\\\u2008\\\\u2009\\\\u200a\\\\u202f\\\\u205f\\\\u3000\",$r=\"[\"+Kr+\"]\",Qr=\"[\"+Yr+\"]\",Xr=\"[a-z\\\\xdf-\\\\xf6\\\\xf8-\\\\xff]\",et=\"[^\\\\ud800-\\\\udfff\"+Kr+\"\\\\d+\\\\u2700-\\\\u27bfa-z\\\\xdf-\\\\xf6\\\\xf8-\\\\xffA-Z\\\\xc0-\\\\xd6\\\\xd8-\\\\xde]\",rt=\"\\\\ud83c[\\\\udffb-\\\\udfff]\",tt=\"(?:\\\\ud83c[\\\\udde6-\\\\uddff]){2}\",nt=\"[\\\\ud800-\\\\udbff][\\\\udc00-\\\\udfff]\",ot=\"[A-Z\\\\xc0-\\\\xd6\\\\xd8-\\\\xde]\",ut=\"(?:\"+Xr+\"|\"+et+\")\",at=\"(?:[\\\\u0300-\\\\u036f\\\\ufe20-\\\\ufe2f\\\\u20d0-\\\\u20ff]|\\\\ud83c[\\\\udffb-\\\\udfff])?\",it=\"(?:\\\\u200d(?:\"+[\"[^\\\\ud800-\\\\udfff]\",tt,nt].join(\"|\")+\")[\\\\ufe0e\\\\ufe0f]?\"+at+\")*\",lt=\"[\\\\ufe0e\\\\ufe0f]?\"+at+it,ct=\"(?:\"+[\"[\\\\u2700-\\\\u27bf]\",tt,nt].join(\"|\")+\")\"+lt,st=\"(?:\"+[\"[^\\\\ud800-\\\\udfff]\"+Qr+\"?\",Qr,tt,nt,\"[\\\\ud800-\\\\udfff]\"].join(\"|\")+\")\",ft=RegExp(\"['\\u2019]\",\"g\"),pt=RegExp(Qr,\"g\"),dt=RegExp(rt+\"(?=\"+rt+\")|\"+st+lt,\"g\"),ht=RegExp([ot+\"?\"+Xr+\"+(?:['\\u2019](?:d|ll|m|re|s|t|ve))?(?=\"+[$r,ot,\"$\"].join(\"|\")+\")\",\"(?:[A-Z\\\\xc0-\\\\xd6\\\\xd8-\\\\xde]|[^\\\\ud800-\\\\udfff\\\\xac\\\\xb1\\\\xd7\\\\xf7\\\\x00-\\\\x2f\\\\x3a-\\\\x40\\\\x5b-\\\\x60\\\\x7b-\\\\xbf\\\\u2000-\\\\u206f \\\\t\\\\x0b\\\\f\\\\xa0\\\\ufeff\\\\n\\\\r\\\\u2028\\\\u2029\\\\u1680\\\\u180e\\\\u2000\\\\u2001\\\\u2002\\\\u2003\\\\u2004\\\\u2005\\\\u2006\\\\u2007\\\\u2008\\\\u2009\\\\u200a\\\\u202f\\\\u205f\\\\u3000\\\\d+\\\\u2700-\\\\u27bfa-z\\\\xdf-\\\\xf6\\\\xf8-\\\\xffA-Z\\\\xc0-\\\\xd6\\\\xd8-\\\\xde])+(?:['\\u2019](?:D|LL|M|RE|S|T|VE))?(?=\"+[$r,ot+ut,\"$\"].join(\"|\")+\")\",ot+\"?\"+ut+\"+(?:['\\u2019](?:d|ll|m|re|s|t|ve))?\",ot+\"+(?:['\\u2019](?:D|LL|M|RE|S|T|VE))?\",\"\\\\d*(?:1ST|2ND|3RD|(?![123])\\\\dTH)(?=\\\\b|[a-z_])\",\"\\\\d*(?:1st|2nd|3rd|(?![123])\\\\dth)(?=\\\\b|[A-Z_])\",\"\\\\d+\",ct].join(\"|\"),\"g\"),gt=RegExp(\"[\\\\u200d\\\\ud800-\\\\udfff\"+Yr+\"\\\\ufe0e\\\\ufe0f]\"),mt=/[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/,vt=[\"Array\",\"Buffer\",\"DataView\",\"Date\",\"Error\",\"Float32Array\",\"Float64Array\",\"Function\",\"Int8Array\",\"Int16Array\",\"Int32Array\",\"Map\",\"Math\",\"Object\",\"Promise\",\"RegExp\",\"Set\",\"String\",\"Symbol\",\"TypeError\",\"Uint8Array\",\"Uint8ClampedArray\",\"Uint16Array\",\"Uint32Array\",\"WeakMap\",\"_\",\"clearTimeout\",\"isFinite\",\"parseInt\",\"setTimeout\"],bt=-1,yt={};yt[ir]=yt[lr]=yt[cr]=yt[sr]=yt[fr]=yt[pr]=yt[dr]=yt[hr]=yt[gr]=!0,yt[Ie]=yt[Ue]=yt[ur]=yt[Me]=yt[ar]=yt[Ve]=yt[ze]=yt[Ge]=yt[Je]=yt[Ze]=yt[Ke]=yt[Qe]=yt[Xe]=yt[er]=yt[nr]=!1;var _t={};_t[Ie]=_t[Ue]=_t[ur]=_t[ar]=_t[Me]=_t[Ve]=_t[ir]=_t[lr]=_t[cr]=_t[sr]=_t[fr]=_t[Je]=_t[Ze]=_t[Ke]=_t[Qe]=_t[Xe]=_t[er]=_t[rr]=_t[pr]=_t[dr]=_t[hr]=_t[gr]=!0,_t[ze]=_t[Ge]=_t[nr]=!1;var wt={\"\\xc0\":\"A\",\"\\xc1\":\"A\",\"\\xc2\":\"A\",\"\\xc3\":\"A\",\"\\xc4\":\"A\",\"\\xc5\":\"A\",\"\\xe0\":\"a\",\"\\xe1\":\"a\",\"\\xe2\":\"a\",\"\\xe3\":\"a\",\"\\xe4\":\"a\",\"\\xe5\":\"a\",\"\\xc7\":\"C\",\"\\xe7\":\"c\",\"\\xd0\":\"D\",\"\\xf0\":\"d\",\"\\xc8\":\"E\",\"\\xc9\":\"E\",\"\\xca\":\"E\",\"\\xcb\":\"E\",\"\\xe8\":\"e\",\"\\xe9\":\"e\",\"\\xea\":\"e\",\"\\xeb\":\"e\",\"\\xcc\":\"I\",\"\\xcd\":\"I\",\"\\xce\":\"I\",\"\\xcf\":\"I\",\"\\xec\":\"i\",\"\\xed\":\"i\",\"\\xee\":\"i\",\"\\xef\":\"i\",\"\\xd1\":\"N\",\"\\xf1\":\"n\",\"\\xd2\":\"O\",\"\\xd3\":\"O\",\"\\xd4\":\"O\",\"\\xd5\":\"O\",\"\\xd6\":\"O\",\"\\xd8\":\"O\",\"\\xf2\":\"o\",\"\\xf3\":\"o\",\"\\xf4\":\"o\",\"\\xf5\":\"o\",\"\\xf6\":\"o\",\"\\xf8\":\"o\",\"\\xd9\":\"U\",\"\\xda\":\"U\",\"\\xdb\":\"U\",\"\\xdc\":\"U\",\"\\xf9\":\"u\",\"\\xfa\":\"u\",\"\\xfb\":\"u\",\"\\xfc\":\"u\",\"\\xdd\":\"Y\",\"\\xfd\":\"y\",\"\\xff\":\"y\",\"\\xc6\":\"Ae\",\"\\xe6\":\"ae\",\"\\xde\":\"Th\",\"\\xfe\":\"th\",\"\\xdf\":\"ss\",\"\\u0100\":\"A\",\"\\u0102\":\"A\",\"\\u0104\":\"A\",\"\\u0101\":\"a\",\"\\u0103\":\"a\",\"\\u0105\":\"a\",\"\\u0106\":\"C\",\"\\u0108\":\"C\",\"\\u010a\":\"C\",\"\\u010c\":\"C\",\"\\u0107\":\"c\",\"\\u0109\":\"c\",\"\\u010b\":\"c\",\"\\u010d\":\"c\",\"\\u010e\":\"D\",\"\\u0110\":\"D\",\"\\u010f\":\"d\",\"\\u0111\":\"d\",\"\\u0112\":\"E\",\"\\u0114\":\"E\",\"\\u0116\":\"E\",\"\\u0118\":\"E\",\"\\u011a\":\"E\",\"\\u0113\":\"e\",\"\\u0115\":\"e\",\"\\u0117\":\"e\",\"\\u0119\":\"e\",\"\\u011b\":\"e\",\"\\u011c\":\"G\",\"\\u011e\":\"G\",\"\\u0120\":\"G\",\"\\u0122\":\"G\",\"\\u011d\":\"g\",\"\\u011f\":\"g\",\"\\u0121\":\"g\",\"\\u0123\":\"g\",\"\\u0124\":\"H\",\"\\u0126\":\"H\",\"\\u0125\":\"h\",\"\\u0127\":\"h\",\"\\u0128\":\"I\",\"\\u012a\":\"I\",\"\\u012c\":\"I\",\"\\u012e\":\"I\",\"\\u0130\":\"I\",\"\\u0129\":\"i\",\"\\u012b\":\"i\",\"\\u012d\":\"i\",\"\\u012f\":\"i\",\"\\u0131\":\"i\",\"\\u0134\":\"J\",\"\\u0135\":\"j\",\"\\u0136\":\"K\",\"\\u0137\":\"k\",\"\\u0138\":\"k\",\"\\u0139\":\"L\",\"\\u013b\":\"L\",\"\\u013d\":\"L\",\"\\u013f\":\"L\",\"\\u0141\":\"L\",\"\\u013a\":\"l\",\"\\u013c\":\"l\",\"\\u013e\":\"l\",\"\\u0140\":\"l\",\"\\u0142\":\"l\",\"\\u0143\":\"N\",\"\\u0145\":\"N\",\"\\u0147\":\"N\",\"\\u014a\":\"N\",\"\\u0144\":\"n\",\"\\u0146\":\"n\",\"\\u0148\":\"n\",\"\\u014b\":\"n\",\"\\u014c\":\"O\",\"\\u014e\":\"O\",\"\\u0150\":\"O\",\"\\u014d\":\"o\",\"\\u014f\":\"o\",\"\\u0151\":\"o\",\"\\u0154\":\"R\",\"\\u0156\":\"R\",\"\\u0158\":\"R\",\"\\u0155\":\"r\",\"\\u0157\":\"r\",\"\\u0159\":\"r\",\"\\u015a\":\"S\",\"\\u015c\":\"S\",\"\\u015e\":\"S\",\"\\u0160\":\"S\",\"\\u015b\":\"s\",\"\\u015d\":\"s\",\"\\u015f\":\"s\",\"\\u0161\":\"s\",\"\\u0162\":\"T\",\"\\u0164\":\"T\",\"\\u0166\":\"T\",\"\\u0163\":\"t\",\"\\u0165\":\"t\",\"\\u0167\":\"t\",\"\\u0168\":\"U\",\"\\u016a\":\"U\",\"\\u016c\":\"U\",\"\\u016e\":\"U\",\"\\u0170\":\"U\",\"\\u0172\":\"U\",\"\\u0169\":\"u\",\"\\u016b\":\"u\",\"\\u016d\":\"u\",\"\\u016f\":\"u\",\"\\u0171\":\"u\",\"\\u0173\":\"u\",\"\\u0174\":\"W\",\"\\u0175\":\"w\",\"\\u0176\":\"Y\",\"\\u0177\":\"y\",\"\\u0178\":\"Y\",\"\\u0179\":\"Z\",\"\\u017b\":\"Z\",\"\\u017d\":\"Z\",\"\\u017a\":\"z\",\"\\u017c\":\"z\",\"\\u017e\":\"z\",\"\\u0132\":\"IJ\",\"\\u0133\":\"ij\",\"\\u0152\":\"Oe\",\"\\u0153\":\"oe\",\"\\u0149\":\"'n\",\"\\u017f\":\"s\"},Et={\"&\":\"&amp;\",\"<\":\"&lt;\",\">\":\"&gt;\",'\"':\"&quot;\",\"'\":\"&#39;\"},xt={\"&amp;\":\"&\",\"&lt;\":\"<\",\"&gt;\":\">\",\"&quot;\":'\"',\"&#39;\":\"'\"},At={\"\\\\\":\"\\\\\",\"'\":\"'\",\"\\n\":\"n\",\"\\r\":\"r\",\"\\u2028\":\"u2028\",\"\\u2029\":\"u2029\"},qt=parseFloat,Dt=parseInt,Ct=\"object\"==typeof e&&e&&e.Object===Object&&e,kt=\"object\"==typeof self&&self&&self.Object===Object&&self,St=Ct||kt||Function(\"return this\")(),Ot=\"object\"==typeof r&&r&&!r.nodeType&&r,Tt=Ot&&\"object\"==typeof n&&n&&!n.nodeType&&n,Rt=Tt&&Tt.exports===Ot,Lt=Rt&&Ct.process,Nt=function(){try{var e=Tt&&Tt.require&&Tt.require(\"util\").types;return e||Lt&&Lt.binding&&Lt.binding(\"util\")}catch(e){}}(),Pt=Nt&&Nt.isArrayBuffer,Bt=Nt&&Nt.isDate,jt=Nt&&Nt.isMap,It=Nt&&Nt.isRegExp,Ut=Nt&&Nt.isSet,Ft=Nt&&Nt.isTypedArray,Mt=D(\"length\"),Vt=C(wt),Ht=C(Et),zt=C(xt),Gt=function e(r){function t(e){if(rl(e)&&!dp(e)&&!(e instanceof b)){if(e instanceof o)return e;if(ps.call(e,\"__wrapped__\"))return Qu(e)}return new o(e)}function n(){}function o(e,r){this.__wrapped__=e,this.__actions__=[],this.__chain__=!!r,this.__index__=0,this.__values__=te}function b(e){this.__wrapped__=e,this.__actions__=[],this.__dir__=1,this.__filtered__=!1,this.__iteratees__=[],this.__takeCount__=Ne,this.__views__=[]}function C(){var e=new b(this.__wrapped__);return e.__actions__=Lo(this.__actions__),e.__dir__=this.__dir__,e.__filtered__=this.__filtered__,e.__iteratees__=Lo(this.__iteratees__),e.__takeCount__=this.__takeCount__,e.__views__=Lo(this.__views__),e}function Y(){if(this.__filtered__){var e=new b(this);e.__dir__=-1,e.__filtered__=!0}else e=this.clone(),e.__dir__*=-1;return e}function X(){var e=this.__wrapped__.value(),r=this.__dir__,t=dp(e),n=r<0,o=t?e.length:0,u=Eu(0,o,this.__views__),a=u.start,i=u.end,l=i-a,c=n?i:a-1,s=this.__iteratees__,f=s.length,p=0,d=Vs(l,this.__takeCount__);if(!t||!n&&o==l&&d==l)return mo(e,this.__actions__);var h=[];e:for(;l--&&p<d;){c+=r;for(var g=-1,m=e[c];++g<f;){var v=s[g],b=v.iteratee,y=v.type,_=b(m);if(y==Se)m=_;else if(!_){if(y==ke)continue e;break e}}h[p++]=m}return h}function ee(e){var r=-1,t=null==e?0:e.length;for(this.clear();++r<t;){var n=e[r];this.set(n[0],n[1])}}function jr(){this.__data__=Qs?Qs(null):{},this.size=0}function Yr(e){var r=this.has(e)&&delete this.__data__[e];return this.size-=r?1:0,r}function Kr(e){var r=this.__data__;if(Qs){var t=r[e];return t===ae?te:t}return ps.call(r,e)?r[e]:te}function $r(e){var r=this.__data__;return Qs?r[e]!==te:ps.call(r,e)}function Qr(e,r){var t=this.__data__;return this.size+=this.has(e)?0:1,t[e]=Qs&&r===te?ae:r,this}function Xr(e){var r=-1,t=null==e?0:e.length;for(this.clear();++r<t;){var n=e[r];this.set(n[0],n[1])}}function et(){this.__data__=[],this.size=0}function rt(e){var r=this.__data__,t=Wt(r,e);return!(t<0)&&(t==r.length-1?r.pop():Ds.call(r,t,1),--this.size,!0)}function tt(e){var r=this.__data__,t=Wt(r,e);return t<0?te:r[t][1]}function nt(e){return Wt(this.__data__,e)>-1}function ot(e,r){var t=this.__data__,n=Wt(t,e);return n<0?(++this.size,t.push([e,r])):t[n][1]=r,this}function ut(e){var r=-1,t=null==e?0:e.length;for(this.clear();++r<t;){var n=e[r];this.set(n[0],n[1])}}function at(){this.size=0,this.__data__={hash:new ee,map:new(Zs||Xr),string:new ee}}function it(e){var r=bu(this,e).delete(e);return this.size-=r?1:0,r}function lt(e){return bu(this,e).get(e)}function ct(e){return bu(this,e).has(e)}function st(e,r){var t=bu(this,e),n=t.size;return t.set(e,r),this.size+=t.size==n?0:1,this}function dt(e){var r=-1,t=null==e?0:e.length;for(this.__data__=new ut;++r<t;)this.add(e[r])}function ht(e){return this.__data__.set(e,ae),this}function gt(e){return this.__data__.has(e)}function mt(e){var r=this.__data__=new Xr(e);this.size=r.size}function wt(){this.__data__=new Xr,this.size=0}function Et(e){var r=this.__data__,t=r.delete(e);return this.size=r.size,t}function xt(e){return this.__data__.get(e)}function At(e){return this.__data__.has(e)}function Ct(e,r){var t=this.__data__;if(t instanceof Xr){var n=t.__data__;if(!Zs||n.length<ne-1)return n.push([e,r]),this.size=++t.size,this;t=this.__data__=new ut(n)}return t.set(e,r),this.size=t.size,this}function kt(e,r){var t=dp(e),n=!t&&pp(e),o=!t&&!n&&gp(e),u=!t&&!n&&!o&&_p(e),a=t||n||o||u,i=a?T(e.length,us):[],l=i.length;for(var c in e)!r&&!ps.call(e,c)||a&&(\"length\"==c||o&&(\"offset\"==c||\"parent\"==c)||u&&(\"buffer\"==c||\"byteLength\"==c||\"byteOffset\"==c)||Ou(c,l))||i.push(c);return i}function Ot(e){var r=e.length;return r?e[Kn(0,r-1)]:te}function Tt(e,r){return Zu(Lo(e),Qt(r,0,e.length))}function Lt(e){return Zu(Lo(e))}function Nt(e,r,t){(t===te||Mi(e[r],t))&&(t!==te||r in e)||Kt(e,r,t)}function Mt(e,r,t){var n=e[r];ps.call(e,r)&&Mi(n,t)&&(t!==te||r in e)||Kt(e,r,t)}function Wt(e,r){for(var t=e.length;t--;)if(Mi(e[t][0],r))return t;return-1}function Jt(e,r,t,n){return ff(e,function(e,o,u){r(n,e,t(e),u)}),n}function Zt(e,r){return e&&No(r,Bl(r),e)}function Yt(e,r){return e&&No(r,jl(r),e)}function Kt(e,r,t){\"__proto__\"==r&&Os?Os(e,r,{configurable:!0,enumerable:!0,value:t,writable:!0}):e[r]=t}function $t(e,r){for(var t=-1,n=r.length,o=Qc(n),u=null==e;++t<n;)o[t]=u?te:Ll(e,r[t]);return o}function Qt(e,r,t){return e===e&&(t!==te&&(e=e<=t?e:t),r!==te&&(e=e>=r?e:r)),e}function Xt(e,r,t,n,o,u){var a,l=r&ce,c=r&se,s=r&fe;if(t&&(a=o?t(e,n,o,u):t(e)),a!==te)return a;if(!el(e))return e;var f=dp(e);if(f){if(a=qu(e),!l)return Lo(e,a)}else{var p=xf(e),d=p==Ge||p==We;if(gp(e))return xo(e,l);if(p==Ke||p==Ie||d&&!o){if(a=c||d?{}:Du(e),!l)return c?Bo(e,Yt(a,e)):Po(e,Zt(a,e))}else{if(!_t[p])return o?e:{};a=Cu(e,p,l)}}u||(u=new mt);var h=u.get(e);if(h)return h;u.set(e,a),yp(e)?e.forEach(function(n){a.add(Xt(n,r,t,n,e,u))}):vp(e)&&e.forEach(function(n,o){a.set(o,Xt(n,r,t,o,e,u))});var g=s?c?hu:du:c?jl:Bl,m=f?te:g(e);return i(m||e,function(n,o){m&&(o=n,n=e[o]),Mt(a,o,Xt(n,r,t,o,e,u))}),a}function en(e){var r=Bl(e);return function(t){return rn(t,e,r)}}function rn(e,r,t){var n=t.length;if(null==e)return!n;for(e=ns(e);n--;){var o=t[n],u=r[o],a=e[o];if(a===te&&!(o in e)||!u(a))return!1}return!0}function tn(e,r,t){if(\"function\"!=typeof e)throw new as(ue);return Df(function(){e.apply(te,t)},r)}function nn(e,r,t,n){var o=-1,u=f,a=!0,i=e.length,l=[],c=r.length;if(!i)return l;t&&(r=d(r,L(t))),n?(u=p,a=!1):r.length>=ne&&(u=P,a=!1,r=new dt(r));e:for(;++o<i;){var s=e[o],h=null==t?s:t(s);if(s=n||0!==s?s:0,a&&h===h){for(var g=c;g--;)if(r[g]===h)continue e;l.push(s)}else u(r,h,n)||l.push(s)}return l}function on(e,r){var t=!0;return ff(e,function(e,n,o){return t=!!r(e,n,o)}),t}function un(e,r,t){for(var n=-1,o=e.length;++n<o;){var u=e[n],a=r(u);if(null!=a&&(i===te?a===a&&!pl(a):t(a,i)))var i=a,l=u}return l}function an(e,r,t,n){var o=e.length;for(t=bl(t),t<0&&(t=-t>o?0:o+t),n=n===te||n>o?o:bl(n),n<0&&(n+=o),n=t>n?0:yl(n);t<n;)e[t++]=r;return e}function ln(e,r){var t=[];return ff(e,function(e,n,o){r(e,n,o)&&t.push(e)}),t}function cn(e,r,t,n,o){var u=-1,a=e.length;for(t||(t=Su),o||(o=[]);++u<a;){var i=e[u];r>0&&t(i)?r>1?cn(i,r-1,t,n,o):h(o,i):n||(o[o.length]=i)}return o}function sn(e,r){return e&&df(e,r,Bl)}function fn(e,r){return e&&hf(e,r,Bl)}function pn(e,r){return s(r,function(r){return $i(e[r])})}function dn(e,r){r=wo(r,e);for(var t=0,n=r.length;null!=e&&t<n;)e=e[Yu(r[t++])];return t&&t==n?e:te}function hn(e,r,t){var n=r(e);return dp(e)?n:h(n,t(e))}function gn(e){return null==e?e===te?tr:Ye:Ss&&Ss in ns(e)?wu(e):Mu(e)}function mn(e,r){return e>r}function vn(e,r){return null!=e&&ps.call(e,r)}function bn(e,r){return null!=e&&r in ns(e)}function yn(e,r,t){return e>=Vs(r,t)&&e<Ms(r,t)}function _n(e,r,t){for(var n=t?p:f,o=e[0].length,u=e.length,a=u,i=Qc(u),l=1/0,c=[];a--;){var s=e[a];a&&r&&(s=d(s,L(r))),l=Vs(s.length,l),i[a]=!t&&(r||o>=120&&s.length>=120)?new dt(a&&s):te}s=e[0];var h=-1,g=i[0];e:for(;++h<o&&c.length<l;){var m=s[h],v=r?r(m):m;if(m=t||0!==m?m:0,!(g?P(g,v):n(c,v,t))){for(a=u;--a;){var b=i[a];if(!(b?P(b,v):n(e[a],v,t)))continue e}g&&g.push(v),c.push(m)}}return c}function wn(e,r,t,n){return sn(e,function(e,o,u){r(n,t(e),o,u)}),n}function En(e,r,t){r=wo(r,e),e=Hu(e,r);var n=null==e?e:e[Yu(va(r))];return null==n?te:u(n,e,t)}function xn(e){return rl(e)&&gn(e)==Ie}function An(e){return rl(e)&&gn(e)==ur}function qn(e){return rl(e)&&gn(e)==Ve}function Dn(e,r,t,n,o){return e===r||(null==e||null==r||!rl(e)&&!rl(r)?e!==e&&r!==r:Cn(e,r,t,n,Dn,o))}function Cn(e,r,t,n,o,u){var a=dp(e),i=dp(r),l=a?Ue:xf(e),c=i?Ue:xf(r);l=l==Ie?Ke:l,c=c==Ie?Ke:c;var s=l==Ke,f=c==Ke,p=l==c;if(p&&gp(e)){if(!gp(r))return!1;a=!0,s=!1}if(p&&!s)return u||(u=new mt),a||_p(e)?cu(e,r,t,n,o,u):su(e,r,l,t,n,o,u);if(!(t&pe)){var d=s&&ps.call(e,\"__wrapped__\"),h=f&&ps.call(r,\"__wrapped__\");if(d||h){var g=d?e.value():e,m=h?r.value():r;return u||(u=new mt),o(g,m,t,n,u)}}return!!p&&(u||(u=new mt),fu(e,r,t,n,o,u))}function kn(e){return rl(e)&&xf(e)==Je}function Sn(e,r,t,n){var o=t.length,u=o,a=!n;if(null==e)return!u;for(e=ns(e);o--;){var i=t[o];if(a&&i[2]?i[1]!==e[i[0]]:!(i[0]in e))return!1}for(;++o<u;){i=t[o];var l=i[0],c=e[l],s=i[1];if(a&&i[2]){if(c===te&&!(l in e))return!1}else{var f=new mt;if(n)var p=n(c,s,l,e,r,f);if(!(p===te?Dn(s,c,pe|de,n,f):p))return!1}}return!0}function On(e){return!(!el(e)||Pu(e))&&($i(e)?bs:Hr).test(Ku(e))}function Tn(e){return rl(e)&&gn(e)==Qe}function Rn(e){return rl(e)&&xf(e)==Xe}function Ln(e){return rl(e)&&Xi(e.length)&&!!yt[gn(e)]}function Nn(e){return\"function\"==typeof e?e:null==e?Dc:\"object\"==typeof e?dp(e)?Fn(e[0],e[1]):Un(e):Nc(e)}function Pn(e){if(!Bu(e))return Fs(e);var r=[];for(var t in ns(e))ps.call(e,t)&&\"constructor\"!=t&&r.push(t);return r}function Bn(e){if(!el(e))return Fu(e);var r=Bu(e),t=[];for(var n in e)(\"constructor\"!=n||!r&&ps.call(e,n))&&t.push(n);return t}function jn(e,r){return e<r}function In(e,r){var t=-1,n=Vi(e)?Qc(e.length):[];return ff(e,function(e,o,u){n[++t]=r(e,o,u)}),n}function Un(e){var r=yu(e);return 1==r.length&&r[0][2]?Iu(r[0][0],r[0][1]):function(t){return t===e||Sn(t,e,r)}}function Fn(e,r){return Ru(e)&&ju(r)?Iu(Yu(e),r):function(t){var n=Ll(t,e);return n===te&&n===r?Pl(t,e):Dn(r,n,pe|de)}}function Mn(e,r,t,n,o){e!==r&&df(r,function(u,a){if(o||(o=new mt),el(u))Vn(e,r,a,t,Mn,n,o);else{var i=n?n(Gu(e,a),u,a+\"\",e,r,o):te;i===te&&(i=u),Nt(e,a,i)}},jl)}function Vn(e,r,t,n,o,u,a){var i=Gu(e,t),l=Gu(r,t),c=a.get(l);if(c)return void Nt(e,t,c);var s=u?u(i,l,t+\"\",e,r,a):te,f=s===te;if(f){var p=dp(l),d=!p&&gp(l),h=!p&&!d&&_p(l);s=l,p||d||h?dp(i)?s=i:Hi(i)?s=Lo(i):d?(f=!1,s=xo(l,!0)):h?(f=!1,s=ko(l,!0)):s=[]:cl(l)||pp(l)?(s=i,pp(i)?s=wl(i):el(i)&&!$i(i)||(s=Du(l))):f=!1}f&&(a.set(l,s),o(s,l,n,u,a),a.delete(l)),Nt(e,t,s)}function Hn(e,r){var t=e.length;if(t)return r+=r<0?t:0,Ou(r,t)?e[r]:te}function zn(e,r,t){var n=-1;return r=d(r.length?r:[Dc],L(vu())),S(In(e,function(e,t,o){return{criteria:d(r,function(r){return r(e)}),index:++n,value:e}}),function(e,r){return Oo(e,r,t)})}function Gn(e,r){return Wn(e,r,function(r,t){return Pl(e,t)})}function Wn(e,r,t){for(var n=-1,o=r.length,u={};++n<o;){var a=r[n],i=dn(e,a);t(i,a)&&to(u,wo(a,e),i)}return u}function Jn(e){return function(r){return dn(r,e)}}function Zn(e,r,t,n){var o=n?x:E,u=-1,a=r.length,i=e;for(e===r&&(r=Lo(r)),t&&(i=d(e,L(t)));++u<a;)for(var l=0,c=r[u],s=t?t(c):c;(l=o(i,s,l,n))>-1;)i!==e&&Ds.call(i,l,1),Ds.call(e,l,1);return e}function Yn(e,r){for(var t=e?r.length:0,n=t-1;t--;){var o=r[t];if(t==n||o!==u){var u=o;Ou(o)?Ds.call(e,o,1):po(e,o)}}return e}function Kn(e,r){return e+Ps(Gs()*(r-e+1))}function $n(e,r,t,n){for(var o=-1,u=Ms(Ns((r-e)/(t||1)),0),a=Qc(u);u--;)a[n?u:++o]=e,e+=t;return a}function Qn(e,r){var t=\"\";if(!e||r<1||r>Te)return t;do{r%2&&(t+=e),(r=Ps(r/2))&&(e+=e)}while(r);return t}function Xn(e,r){return Cf(Vu(e,r,Dc),e+\"\")}function eo(e){return Ot(Yl(e))}function ro(e,r){var t=Yl(e);return Zu(t,Qt(r,0,t.length))}function to(e,r,t,n){if(!el(e))return e;r=wo(r,e);for(var o=-1,u=r.length,a=u-1,i=e;null!=i&&++o<u;){var l=Yu(r[o]),c=t;if(o!=a){var s=i[l];c=n?n(s,l,i):te,c===te&&(c=el(s)?s:Ou(r[o+1])?[]:{})}Mt(i,l,c),i=i[l]}return e}function no(e){return Zu(Yl(e))}function oo(e,r,t){var n=-1,o=e.length;r<0&&(r=-r>o?0:o+r),t=t>o?o:t,t<0&&(t+=o),o=r>t?0:t-r>>>0,r>>>=0;for(var u=Qc(o);++n<o;)u[n]=e[n+r];return u}function uo(e,r){var t;return ff(e,function(e,n,o){return!(t=r(e,n,o))}),!!t}function ao(e,r,t){var n=0,o=null==e?n:e.length;if(\"number\"==typeof r&&r===r&&o<=Be){for(;n<o;){var u=n+o>>>1,a=e[u];null!==a&&!pl(a)&&(t?a<=r:a<r)?n=u+1:o=u}return o}return io(e,r,Dc,t)}function io(e,r,t,n){r=t(r);for(var o=0,u=null==e?0:e.length,a=r!==r,i=null===r,l=pl(r),c=r===te;o<u;){var s=Ps((o+u)/2),f=t(e[s]),p=f!==te,d=null===f,h=f===f,g=pl(f);if(a)var m=n||h;else m=c?h&&(n||p):i?h&&p&&(n||!d):l?h&&p&&!d&&(n||!g):!d&&!g&&(n?f<=r:f<r);m?o=s+1:u=s}return Vs(u,Pe)}function lo(e,r){for(var t=-1,n=e.length,o=0,u=[];++t<n;){var a=e[t],i=r?r(a):a;if(!t||!Mi(i,l)){var l=i;u[o++]=0===a?0:a}}return u}function co(e){return\"number\"==typeof e?e:pl(e)?Le:+e}function so(e){if(\"string\"==typeof e)return e;if(dp(e))return d(e,so)+\"\";if(pl(e))return cf?cf.call(e):\"\";var r=e+\"\";return\"0\"==r&&1/e==-Oe?\"-0\":r}function fo(e,r,t){var n=-1,o=f,u=e.length,a=!0,i=[],l=i;if(t)a=!1,o=p;else if(u>=ne){var c=r?null:yf(e);if(c)return J(c);a=!1,o=P,l=new dt}else l=r?[]:i;e:for(;++n<u;){var s=e[n],d=r?r(s):s;if(s=t||0!==s?s:0,a&&d===d){for(var h=l.length;h--;)if(l[h]===d)continue e;r&&l.push(d),i.push(s)}else o(l,d,t)||(l!==i&&l.push(d),i.push(s))}return i}function po(e,r){return r=wo(r,e),null==(e=Hu(e,r))||delete e[Yu(va(r))]}function ho(e,r,t,n){return to(e,r,t(dn(e,r)),n)}function go(e,r,t,n){for(var o=e.length,u=n?o:-1;(n?u--:++u<o)&&r(e[u],u,e););return t?oo(e,n?0:u,n?u+1:o):oo(e,n?u+1:0,n?o:u)}function mo(e,r){var t=e;return t instanceof b&&(t=t.value()),g(r,function(e,r){return r.func.apply(r.thisArg,h([e],r.args))},t)}function vo(e,r,t){var n=e.length;if(n<2)return n?fo(e[0]):[];for(var o=-1,u=Qc(n);++o<n;)for(var a=e[o],i=-1;++i<n;)i!=o&&(u[o]=nn(u[o]||a,e[i],r,t));return fo(cn(u,1),r,t)}function bo(e,r,t){for(var n=-1,o=e.length,u=r.length,a={};++n<o;){var i=n<u?r[n]:te;t(a,e[n],i)}return a}function yo(e){return Hi(e)?e:[]}function _o(e){return\"function\"==typeof e?e:Dc}function wo(e,r){return dp(e)?e:Ru(e,r)?[e]:kf(xl(e))}function Eo(e,r,t){var n=e.length;return t=t===te?n:t,!r&&t>=n?e:oo(e,r,t)}function xo(e,r){if(r)return e.slice();var t=e.length,n=Es?Es(t):new e.constructor(t);return e.copy(n),n}function Ao(e){var r=new e.constructor(e.byteLength);return new ws(r).set(new ws(e)),r}function qo(e,r){var t=r?Ao(e.buffer):e.buffer;return new e.constructor(t,e.byteOffset,e.byteLength)}function Do(e){var r=new e.constructor(e.source,Fr.exec(e));return r.lastIndex=e.lastIndex,r}function Co(e){return lf?ns(lf.call(e)):{}}function ko(e,r){var t=r?Ao(e.buffer):e.buffer;return new e.constructor(t,e.byteOffset,e.length)}function So(e,r){if(e!==r){var t=e!==te,n=null===e,o=e===e,u=pl(e),a=r!==te,i=null===r,l=r===r,c=pl(r);if(!i&&!c&&!u&&e>r||u&&a&&l&&!i&&!c||n&&a&&l||!t&&l||!o)return 1;if(!n&&!u&&!c&&e<r||c&&t&&o&&!n&&!u||i&&t&&o||!a&&o||!l)return-1}return 0}function Oo(e,r,t){for(var n=-1,o=e.criteria,u=r.criteria,a=o.length,i=t.length;++n<a;){var l=So(o[n],u[n]);if(l){if(n>=i)return l;return l*(\"desc\"==t[n]?-1:1)}}return e.index-r.index}function To(e,r,t,n){for(var o=-1,u=e.length,a=t.length,i=-1,l=r.length,c=Ms(u-a,0),s=Qc(l+c),f=!n;++i<l;)s[i]=r[i];for(;++o<a;)(f||o<u)&&(s[t[o]]=e[o]);for(;c--;)s[i++]=e[o++];return s}function Ro(e,r,t,n){for(var o=-1,u=e.length,a=-1,i=t.length,l=-1,c=r.length,s=Ms(u-i,0),f=Qc(s+c),p=!n;++o<s;)f[o]=e[o];for(var d=o;++l<c;)f[d+l]=r[l];for(;++a<i;)(p||o<u)&&(f[d+t[a]]=e[o++]);return f}function Lo(e,r){var t=-1,n=e.length;for(r||(r=Qc(n));++t<n;)r[t]=e[t];return r}function No(e,r,t,n){var o=!t;t||(t={});for(var u=-1,a=r.length;++u<a;){var i=r[u],l=n?n(t[i],e[i],i,t,e):te;l===te&&(l=e[i]),o?Kt(t,i,l):Mt(t,i,l)}return t}function Po(e,r){return No(e,wf(e),r)}function Bo(e,r){return No(e,Ef(e),r)}function jo(e,r){return function(t,n){var o=dp(t)?a:Jt,u=r?r():{};return o(t,e,vu(n,2),u)}}function Io(e){return Xn(function(r,t){var n=-1,o=t.length,u=o>1?t[o-1]:te,a=o>2?t[2]:te;for(u=e.length>3&&\"function\"==typeof u?(o--,u):te,a&&Tu(t[0],t[1],a)&&(u=o<3?te:u,o=1),r=ns(r);++n<o;){var i=t[n];i&&e(r,i,n,u)}return r})}function Uo(e,r){return function(t,n){if(null==t)return t;if(!Vi(t))return e(t,n);for(var o=t.length,u=r?o:-1,a=ns(t);(r?u--:++u<o)&&!1!==n(a[u],u,a););return t}}function Fo(e){return function(r,t,n){for(var o=-1,u=ns(r),a=n(r),i=a.length;i--;){var l=a[e?i:++o];if(!1===t(u[l],l,u))break}return r}}function Mo(e,r,t){function n(){return(this&&this!==St&&this instanceof n?u:e).apply(o?t:this,arguments)}var o=r&he,u=zo(e);return n}function Vo(e){return function(r){r=xl(r);var t=M(r)?Q(r):te,n=t?t[0]:r.charAt(0),o=t?Eo(t,1).join(\"\"):r.slice(1);return n[e]()+o}}function Ho(e){return function(r){return g(wc(rc(r).replace(ft,\"\")),e,\"\")}}function zo(e){return function(){var r=arguments;switch(r.length){case 0:return new e;case 1:return new e(r[0]);case 2:return new e(r[0],r[1]);case 3:return new e(r[0],r[1],r[2]);case 4:return new e(r[0],r[1],r[2],r[3]);case 5:return new e(r[0],r[1],r[2],r[3],r[4]);case 6:return new e(r[0],r[1],r[2],r[3],r[4],r[5]);case 7:return new e(r[0],r[1],r[2],r[3],r[4],r[5],r[6])}var t=sf(e.prototype),n=e.apply(t,r);return el(n)?n:t}}function Go(e,r,t){function n(){for(var a=arguments.length,i=Qc(a),l=a,c=mu(n);l--;)i[l]=arguments[l];var s=a<3&&i[0]!==c&&i[a-1]!==c?[]:W(i,c);return(a-=s.length)<t?tu(e,r,Zo,n.placeholder,te,i,s,te,te,t-a):u(this&&this!==St&&this instanceof n?o:e,this,i)}var o=zo(e);return n}function Wo(e){return function(r,t,n){var o=ns(r);if(!Vi(r)){var u=vu(t,3);r=Bl(r),t=function(e){return u(o[e],e,o)}}var a=e(r,t,n);return a>-1?o[u?r[a]:a]:te}}function Jo(e){return pu(function(r){var t=r.length,n=t,u=o.prototype.thru;for(e&&r.reverse();n--;){var a=r[n];if(\"function\"!=typeof a)throw new as(ue);if(u&&!i&&\"wrapper\"==gu(a))var i=new o([],!0)}for(n=i?n:t;++n<t;){a=r[n];var l=gu(a),c=\"wrapper\"==l?_f(a):te;i=c&&Nu(c[0])&&c[1]==(we|ve|ye|Ee)&&!c[4].length&&1==c[9]?i[gu(c[0])].apply(i,c[3]):1==a.length&&Nu(a)?i[l]():i.thru(a)}return function(){var e=arguments,n=e[0];if(i&&1==e.length&&dp(n))return i.plant(n).value();for(var o=0,u=t?r[o].apply(this,e):n;++o<t;)u=r[o].call(this,u);return u}})}function Zo(e,r,t,n,o,u,a,i,l,c){function s(){for(var v=arguments.length,b=Qc(v),y=v;y--;)b[y]=arguments[y];if(h)var _=mu(s),w=I(b,_);if(n&&(b=To(b,n,o,h)),u&&(b=Ro(b,u,a,h)),v-=w,h&&v<c){var E=W(b,_);return tu(e,r,Zo,s.placeholder,t,b,E,i,l,c-v)}var x=p?t:this,A=d?x[e]:e;return v=b.length,i?b=zu(b,i):g&&v>1&&b.reverse(),f&&l<v&&(b.length=l),this&&this!==St&&this instanceof s&&(A=m||zo(A)),A.apply(x,b)}var f=r&we,p=r&he,d=r&ge,h=r&(ve|be),g=r&xe,m=d?te:zo(e);return s}function Yo(e,r){return function(t,n){return wn(t,e,r(n),{})}}function Ko(e,r){return function(t,n){var o;if(t===te&&n===te)return r;if(t!==te&&(o=t),n!==te){if(o===te)return n;\"string\"==typeof t||\"string\"==typeof n?(t=so(t),n=so(n)):(t=co(t),n=co(n)),o=e(t,n)}return o}}function $o(e){return pu(function(r){return r=d(r,L(vu())),Xn(function(t){var n=this;return e(r,function(e){return u(e,n,t)})})})}function Qo(e,r){r=r===te?\" \":so(r);var t=r.length;if(t<2)return t?Qn(r,e):r;var n=Qn(r,Ns(e/$(r)));return M(r)?Eo(Q(n),0,e).join(\"\"):n.slice(0,e)}function Xo(e,r,t,n){function o(){for(var r=-1,l=arguments.length,c=-1,s=n.length,f=Qc(s+l),p=this&&this!==St&&this instanceof o?i:e;++c<s;)f[c]=n[c];for(;l--;)f[c++]=arguments[++r];return u(p,a?t:this,f)}var a=r&he,i=zo(e);return o}function eu(e){return function(r,t,n){return n&&\"number\"!=typeof n&&Tu(r,t,n)&&(t=n=te),r=vl(r),t===te?(t=r,r=0):t=vl(t),n=n===te?r<t?1:-1:vl(n),$n(r,t,n,e)}}function ru(e){return function(r,t){return\"string\"==typeof r&&\"string\"==typeof t||(r=_l(r),t=_l(t)),e(r,t)}}function tu(e,r,t,n,o,u,a,i,l,c){var s=r&ve,f=s?a:te,p=s?te:a,d=s?u:te,h=s?te:u;r|=s?ye:_e,(r&=~(s?_e:ye))&me||(r&=~(he|ge));var g=[e,r,o,d,f,h,p,i,l,c],m=t.apply(te,g);return Nu(e)&&qf(m,g),m.placeholder=n,Wu(m,e,r)}function nu(e){var r=ts[e];return function(e,t){if(e=_l(e),(t=null==t?0:Vs(bl(t),292))&&Is(e)){var n=(xl(e)+\"e\").split(\"e\");return n=(xl(r(n[0]+\"e\"+(+n[1]+t)))+\"e\").split(\"e\"),+(n[0]+\"e\"+(+n[1]-t))}return r(e)}}function ou(e){return function(r){var t=xf(r);return t==Je?z(r):t==Xe?Z(r):R(r,e(r))}}function uu(e,r,t,n,o,u,a,i){var l=r&ge;if(!l&&\"function\"!=typeof e)throw new as(ue);var c=n?n.length:0;if(c||(r&=~(ye|_e),n=o=te),a=a===te?a:Ms(bl(a),0),i=i===te?i:bl(i),c-=o?o.length:0,r&_e){var s=n,f=o;n=o=te}var p=l?te:_f(e),d=[e,r,t,n,o,s,f,u,a,i];if(p&&Uu(d,p),e=d[0],r=d[1],t=d[2],n=d[3],o=d[4],i=d[9]=d[9]===te?l?0:e.length:Ms(d[9]-c,0),!i&&r&(ve|be)&&(r&=~(ve|be)),r&&r!=he)h=r==ve||r==be?Go(e,r,i):r!=ye&&r!=(he|ye)||o.length?Zo.apply(te,d):Xo(e,r,t,n);else var h=Mo(e,r,t);return Wu((p?gf:qf)(h,d),e,r)}function au(e,r,t,n){return e===te||Mi(e,cs[t])&&!ps.call(n,t)?r:e}function iu(e,r,t,n,o,u){return el(e)&&el(r)&&(u.set(r,e),Mn(e,r,te,iu,u),u.delete(r)),e}function lu(e){return cl(e)?te:e}function cu(e,r,t,n,o,u){var a=t&pe,i=e.length,l=r.length;if(i!=l&&!(a&&l>i))return!1;var c=u.get(e);if(c&&u.get(r))return c==r;var s=-1,f=!0,p=t&de?new dt:te;for(u.set(e,r),u.set(r,e);++s<i;){var d=e[s],h=r[s];if(n)var g=a?n(h,d,s,r,e,u):n(d,h,s,e,r,u);if(g!==te){if(g)continue;f=!1;break}if(p){if(!v(r,function(e,r){if(!P(p,r)&&(d===e||o(d,e,t,n,u)))return p.push(r)})){f=!1;break}}else if(d!==h&&!o(d,h,t,n,u)){f=!1;break}}return u.delete(e),u.delete(r),f}function su(e,r,t,n,o,u,a){switch(t){case ar:if(e.byteLength!=r.byteLength||e.byteOffset!=r.byteOffset)return!1;e=e.buffer,r=r.buffer;case ur:return!(e.byteLength!=r.byteLength||!u(new ws(e),new ws(r)));case Me:case Ve:case Ze:return Mi(+e,+r);case ze:return e.name==r.name&&e.message==r.message;case Qe:case er:return e==r+\"\";case Je:var i=z;case Xe:var l=n&pe;if(i||(i=J),e.size!=r.size&&!l)return!1;var c=a.get(e);if(c)return c==r;n|=de,a.set(e,r);var s=cu(i(e),i(r),n,o,u,a);return a.delete(e),s;case rr:if(lf)return lf.call(e)==lf.call(r)}return!1}function fu(e,r,t,n,o,u){var a=t&pe,i=du(e),l=i.length;if(l!=du(r).length&&!a)return!1;for(var c=l;c--;){var s=i[c];if(!(a?s in r:ps.call(r,s)))return!1}var f=u.get(e);if(f&&u.get(r))return f==r;var p=!0;u.set(e,r),u.set(r,e);for(var d=a;++c<l;){s=i[c];var h=e[s],g=r[s];if(n)var m=a?n(g,h,s,r,e,u):n(h,g,s,e,r,u);if(!(m===te?h===g||o(h,g,t,n,u):m)){p=!1;break}d||(d=\"constructor\"==s)}if(p&&!d){var v=e.constructor,b=r.constructor;v!=b&&\"constructor\"in e&&\"constructor\"in r&&!(\"function\"==typeof v&&v instanceof v&&\"function\"==typeof b&&b instanceof b)&&(p=!1)}return u.delete(e),u.delete(r),p}function pu(e){return Cf(Vu(e,te,ca),e+\"\")}function du(e){return hn(e,Bl,wf)}function hu(e){return hn(e,jl,Ef)}function gu(e){for(var r=e.name+\"\",t=ef[r],n=ps.call(ef,r)?t.length:0;n--;){var o=t[n],u=o.func;if(null==u||u==e)return o.name}return r}function mu(e){return(ps.call(t,\"placeholder\")?t:e).placeholder}function vu(){var e=t.iteratee||Cc;return e=e===Cc?Nn:e,arguments.length?e(arguments[0],arguments[1]):e}function bu(e,r){var t=e.__data__;return Lu(r)?t[\"string\"==typeof r?\"string\":\"hash\"]:t.map}function yu(e){for(var r=Bl(e),t=r.length;t--;){var n=r[t],o=e[n];r[t]=[n,o,ju(o)]}return r}function _u(e,r){var t=F(e,r);return On(t)?t:te}function wu(e){var r=ps.call(e,Ss),t=e[Ss];try{e[Ss]=te;var n=!0}catch(e){}var o=gs.call(e);return n&&(r?e[Ss]=t:delete e[Ss]),o}function Eu(e,r,t){for(var n=-1,o=t.length;++n<o;){var u=t[n],a=u.size;switch(u.type){case\"drop\":e+=a;break;case\"dropRight\":r-=a;break;case\"take\":r=Vs(r,e+a);break;case\"takeRight\":e=Ms(e,r-a)}}return{start:e,end:r}}function xu(e){var r=e.match(Pr);return r?r[1].split(Br):[]}function Au(e,r,t){r=wo(r,e);for(var n=-1,o=r.length,u=!1;++n<o;){var a=Yu(r[n]);if(!(u=null!=e&&t(e,a)))break;e=e[a]}return u||++n!=o?u:!!(o=null==e?0:e.length)&&Xi(o)&&Ou(a,o)&&(dp(e)||pp(e))}function qu(e){var r=e.length,t=new e.constructor(r);return r&&\"string\"==typeof e[0]&&ps.call(e,\"index\")&&(t.index=e.index,t.input=e.input),t}function Du(e){return\"function\"!=typeof e.constructor||Bu(e)?{}:sf(xs(e))}function Cu(e,r,t){var n=e.constructor;switch(r){case ur:return Ao(e);case Me:case Ve:return new n(+e);case ar:return qo(e,t);case ir:case lr:case cr:case sr:case fr:case pr:case dr:case hr:case gr:return ko(e,t);case Je:return new n;case Ze:case er:return new n(e);case Qe:return Do(e);case Xe:return new n;case rr:return Co(e)}}function ku(e,r){var t=r.length;if(!t)return e;var n=t-1;return r[n]=(t>1?\"& \":\"\")+r[n],r=r.join(t>2?\", \":\" \"),e.replace(Nr,\"{\\n/* [wrapped with \"+r+\"] */\\n\")}function Su(e){return dp(e)||pp(e)||!!(Cs&&e&&e[Cs])}function Ou(e,r){var t=typeof e;return!!(r=null==r?Te:r)&&(\"number\"==t||\"symbol\"!=t&&Gr.test(e))&&e>-1&&e%1==0&&e<r}function Tu(e,r,t){if(!el(t))return!1;var n=typeof r;return!!(\"number\"==n?Vi(t)&&Ou(r,t.length):\"string\"==n&&r in t)&&Mi(t[r],e)}function Ru(e,r){if(dp(e))return!1;var t=typeof e;return!(\"number\"!=t&&\"symbol\"!=t&&\"boolean\"!=t&&null!=e&&!pl(e))||(Cr.test(e)||!Dr.test(e)||null!=r&&e in ns(r))}function Lu(e){var r=typeof e;return\"string\"==r||\"number\"==r||\"symbol\"==r||\"boolean\"==r?\"__proto__\"!==e:null===e}function Nu(e){var r=gu(e),n=t[r];if(\"function\"!=typeof n||!(r in b.prototype))return!1;if(e===n)return!0;var o=_f(n);return!!o&&e===o[0]}function Pu(e){return!!hs&&hs in e}function Bu(e){var r=e&&e.constructor;return e===(\"function\"==typeof r&&r.prototype||cs)}function ju(e){return e===e&&!el(e)}function Iu(e,r){return function(t){return null!=t&&(t[e]===r&&(r!==te||e in ns(t)))}}function Uu(e,r){var t=e[1],n=r[1],o=t|n,u=o<(he|ge|we),a=n==we&&t==ve||n==we&&t==Ee&&e[7].length<=r[8]||n==(we|Ee)&&r[7].length<=r[8]&&t==ve;if(!u&&!a)return e;n&he&&(e[2]=r[2],o|=t&he?0:me);var i=r[3];if(i){var l=e[3];e[3]=l?To(l,i,r[4]):i,e[4]=l?W(e[3],le):r[4]}return i=r[5],i&&(l=e[5],e[5]=l?Ro(l,i,r[6]):i,e[6]=l?W(e[5],le):r[6]),i=r[7],i&&(e[7]=i),n&we&&(e[8]=null==e[8]?r[8]:Vs(e[8],r[8])),null==e[9]&&(e[9]=r[9]),e[0]=r[0],e[1]=o,e}function Fu(e){var r=[];if(null!=e)for(var t in ns(e))r.push(t);return r}function Mu(e){return gs.call(e)}function Vu(e,r,t){return r=Ms(r===te?e.length-1:r,0),function(){for(var n=arguments,o=-1,a=Ms(n.length-r,0),i=Qc(a);++o<a;)i[o]=n[r+o];o=-1;for(var l=Qc(r+1);++o<r;)l[o]=n[o];return l[r]=t(i),u(e,this,l)}}function Hu(e,r){return r.length<2?e:dn(e,oo(r,0,-1))}function zu(e,r){for(var t=e.length,n=Vs(r.length,t),o=Lo(e);n--;){var u=r[n];e[n]=Ou(u,t)?o[u]:te}return e}function Gu(e,r){if((\"constructor\"!==r||\"function\"!==typeof e[r])&&\"__proto__\"!=r)return e[r]}function Wu(e,r,t){var n=r+\"\";return Cf(e,ku(n,$u(xu(n),t)))}function Ju(e){var r=0,t=0;return function(){var n=Hs(),o=Ce-(n-t);if(t=n,o>0){if(++r>=De)return arguments[0]}else r=0;return e.apply(te,arguments)}}function Zu(e,r){var t=-1,n=e.length,o=n-1;for(r=r===te?n:r;++t<r;){var u=Kn(t,o),a=e[u];e[u]=e[t],e[t]=a}return e.length=r,e}function Yu(e){if(\"string\"==typeof e||pl(e))return e;var r=e+\"\";return\"0\"==r&&1/e==-Oe?\"-0\":r}function Ku(e){if(null!=e){try{return fs.call(e)}catch(e){}try{return e+\"\"}catch(e){}}return\"\"}function $u(e,r){return i(je,function(t){var n=\"_.\"+t[0];r&t[1]&&!f(e,n)&&e.push(n)}),e.sort()}function Qu(e){if(e instanceof b)return e.clone();var r=new o(e.__wrapped__,e.__chain__);return r.__actions__=Lo(e.__actions__),r.__index__=e.__index__,r.__values__=e.__values__,r}function Xu(e,r,t){r=(t?Tu(e,r,t):r===te)?1:Ms(bl(r),0);var n=null==e?0:e.length;if(!n||r<1)return[];for(var o=0,u=0,a=Qc(Ns(n/r));o<n;)a[u++]=oo(e,o,o+=r);return a}function ea(e){for(var r=-1,t=null==e?0:e.length,n=0,o=[];++r<t;){var u=e[r];u&&(o[n++]=u)}return o}function ra(){var e=arguments.length;if(!e)return[];for(var r=Qc(e-1),t=arguments[0],n=e;n--;)r[n-1]=arguments[n];return h(dp(t)?Lo(t):[t],cn(r,1))}function ta(e,r,t){var n=null==e?0:e.length;return n?(r=t||r===te?1:bl(r),oo(e,r<0?0:r,n)):[]}function na(e,r,t){var n=null==e?0:e.length;return n?(r=t||r===te?1:bl(r),r=n-r,oo(e,0,r<0?0:r)):[]}function oa(e,r){return e&&e.length?go(e,vu(r,3),!0,!0):[]}function ua(e,r){return e&&e.length?go(e,vu(r,3),!0):[]}function aa(e,r,t,n){var o=null==e?0:e.length;return o?(t&&\"number\"!=typeof t&&Tu(e,r,t)&&(t=0,n=o),an(e,r,t,n)):[]}function ia(e,r,t){var n=null==e?0:e.length;if(!n)return-1;var o=null==t?0:bl(t);return o<0&&(o=Ms(n+o,0)),w(e,vu(r,3),o)}function la(e,r,t){var n=null==e?0:e.length;if(!n)return-1;var o=n-1;return t!==te&&(o=bl(t),o=t<0?Ms(n+o,0):Vs(o,n-1)),w(e,vu(r,3),o,!0)}function ca(e){return(null==e?0:e.length)?cn(e,1):[]}function sa(e){return(null==e?0:e.length)?cn(e,Oe):[]}function fa(e,r){return(null==e?0:e.length)?(r=r===te?1:bl(r),cn(e,r)):[]}function pa(e){for(var r=-1,t=null==e?0:e.length,n={};++r<t;){var o=e[r];n[o[0]]=o[1]}return n}function da(e){return e&&e.length?e[0]:te}function ha(e,r,t){var n=null==e?0:e.length;if(!n)return-1;var o=null==t?0:bl(t);return o<0&&(o=Ms(n+o,0)),E(e,r,o)}function ga(e){return(null==e?0:e.length)?oo(e,0,-1):[]}function ma(e,r){return null==e?\"\":Us.call(e,r)}function va(e){var r=null==e?0:e.length;return r?e[r-1]:te}function ba(e,r,t){var n=null==e?0:e.length;if(!n)return-1;var o=n;return t!==te&&(o=bl(t),o=o<0?Ms(n+o,0):Vs(o,n-1)),r===r?K(e,r,o):w(e,A,o,!0)}function ya(e,r){return e&&e.length?Hn(e,bl(r)):te}function _a(e,r){return e&&e.length&&r&&r.length?Zn(e,r):e}function wa(e,r,t){return e&&e.length&&r&&r.length?Zn(e,r,vu(t,2)):e}function Ea(e,r,t){return e&&e.length&&r&&r.length?Zn(e,r,te,t):e}function xa(e,r){var t=[];if(!e||!e.length)return t;var n=-1,o=[],u=e.length;for(r=vu(r,3);++n<u;){var a=e[n];r(a,n,e)&&(t.push(a),o.push(n))}return Yn(e,o),t}function Aa(e){return null==e?e:Ws.call(e)}function qa(e,r,t){var n=null==e?0:e.length;return n?(t&&\"number\"!=typeof t&&Tu(e,r,t)?(r=0,t=n):(r=null==r?0:bl(r),t=t===te?n:bl(t)),oo(e,r,t)):[]}function Da(e,r){return ao(e,r)}function Ca(e,r,t){return io(e,r,vu(t,2))}function ka(e,r){var t=null==e?0:e.length;if(t){var n=ao(e,r);if(n<t&&Mi(e[n],r))return n}return-1}function Sa(e,r){return ao(e,r,!0)}function Oa(e,r,t){return io(e,r,vu(t,2),!0)}function Ta(e,r){if(null==e?0:e.length){var t=ao(e,r,!0)-1;if(Mi(e[t],r))return t}return-1}function Ra(e){return e&&e.length?lo(e):[]}function La(e,r){return e&&e.length?lo(e,vu(r,2)):[]}function Na(e){var r=null==e?0:e.length;return r?oo(e,1,r):[]}function Pa(e,r,t){return e&&e.length?(r=t||r===te?1:bl(r),oo(e,0,r<0?0:r)):[]}function Ba(e,r,t){var n=null==e?0:e.length;return n?(r=t||r===te?1:bl(r),r=n-r,oo(e,r<0?0:r,n)):[]}function ja(e,r){return e&&e.length?go(e,vu(r,3),!1,!0):[]}function Ia(e,r){return e&&e.length?go(e,vu(r,3)):[]}function Ua(e){return e&&e.length?fo(e):[]}function Fa(e,r){return e&&e.length?fo(e,vu(r,2)):[]}function Ma(e,r){return r=\"function\"==typeof r?r:te,e&&e.length?fo(e,te,r):[]}function Va(e){if(!e||!e.length)return[];var r=0;return e=s(e,function(e){if(Hi(e))return r=Ms(e.length,r),!0}),T(r,function(r){return d(e,D(r))})}function Ha(e,r){if(!e||!e.length)return[];var t=Va(e);return null==r?t:d(t,function(e){return u(r,te,e)})}function za(e,r){return bo(e||[],r||[],Mt)}function Ga(e,r){return bo(e||[],r||[],to)}function Wa(e){var r=t(e);return r.__chain__=!0,r}function Ja(e,r){return r(e),e}function Za(e,r){return r(e)}function Ya(){return Wa(this)}function Ka(){return new o(this.value(),this.__chain__)}function $a(){this.__values__===te&&(this.__values__=ml(this.value()));var e=this.__index__>=this.__values__.length;return{done:e,value:e?te:this.__values__[this.__index__++]}}function Qa(){return this}function Xa(e){for(var r,t=this;t instanceof n;){var o=Qu(t);o.__index__=0,o.__values__=te,r?u.__wrapped__=o:r=o;var u=o;t=t.__wrapped__}return u.__wrapped__=e,r}function ei(){var e=this.__wrapped__;if(e instanceof b){var r=e;return this.__actions__.length&&(r=new b(this)),r=r.reverse(),r.__actions__.push({func:Za,args:[Aa],thisArg:te}),new o(r,this.__chain__)}return this.thru(Aa)}function ri(){return mo(this.__wrapped__,this.__actions__)}function ti(e,r,t){var n=dp(e)?c:on;return t&&Tu(e,r,t)&&(r=te),n(e,vu(r,3))}function ni(e,r){return(dp(e)?s:ln)(e,vu(r,3))}function oi(e,r){return cn(si(e,r),1)}function ui(e,r){return cn(si(e,r),Oe)}function ai(e,r,t){return t=t===te?1:bl(t),cn(si(e,r),t)}function ii(e,r){return(dp(e)?i:ff)(e,vu(r,3))}function li(e,r){return(dp(e)?l:pf)(e,vu(r,3))}function ci(e,r,t,n){e=Vi(e)?e:Yl(e),t=t&&!n?bl(t):0;var o=e.length;return t<0&&(t=Ms(o+t,0)),fl(e)?t<=o&&e.indexOf(r,t)>-1:!!o&&E(e,r,t)>-1}function si(e,r){return(dp(e)?d:In)(e,vu(r,3))}function fi(e,r,t,n){return null==e?[]:(dp(r)||(r=null==r?[]:[r]),t=n?te:t,dp(t)||(t=null==t?[]:[t]),zn(e,r,t))}function pi(e,r,t){var n=dp(e)?g:k,o=arguments.length<3;return n(e,vu(r,4),t,o,ff)}function di(e,r,t){var n=dp(e)?m:k,o=arguments.length<3;return n(e,vu(r,4),t,o,pf)}function hi(e,r){return(dp(e)?s:ln)(e,ki(vu(r,3)))}function gi(e){return(dp(e)?Ot:eo)(e)}function mi(e,r,t){return r=(t?Tu(e,r,t):r===te)?1:bl(r),(dp(e)?Tt:ro)(e,r)}function vi(e){return(dp(e)?Lt:no)(e)}function bi(e){if(null==e)return 0;if(Vi(e))return fl(e)?$(e):e.length;var r=xf(e);return r==Je||r==Xe?e.size:Pn(e).length}function yi(e,r,t){var n=dp(e)?v:uo;return t&&Tu(e,r,t)&&(r=te),n(e,vu(r,3))}function _i(e,r){if(\"function\"!=typeof r)throw new as(ue);return e=bl(e),function(){if(--e<1)return r.apply(this,arguments)}}function wi(e,r,t){return r=t?te:r,r=e&&null==r?e.length:r,uu(e,we,te,te,te,te,r)}function Ei(e,r){var t;if(\"function\"!=typeof r)throw new as(ue);return e=bl(e),function(){return--e>0&&(t=r.apply(this,arguments)),e<=1&&(r=te),t}}function xi(e,r,t){r=t?te:r;var n=uu(e,ve,te,te,te,te,te,r);return n.placeholder=xi.placeholder,n}function Ai(e,r,t){r=t?te:r;var n=uu(e,be,te,te,te,te,te,r);return n.placeholder=Ai.placeholder,n}function qi(e,r,t){function n(r){var t=p,n=d;return p=d=te,b=r,g=e.apply(n,t)}function o(e){return b=e,m=Df(i,r),y?n(e):g}function u(e){var t=e-v,n=e-b,o=r-t;return _?Vs(o,h-n):o}function a(e){var t=e-v,n=e-b;return v===te||t>=r||t<0||_&&n>=h}function i(){var e=rp();if(a(e))return l(e);m=Df(i,u(e))}function l(e){return m=te,w&&p?n(e):(p=d=te,g)}function c(){m!==te&&bf(m),b=0,p=v=d=m=te}function s(){return m===te?g:l(rp())}function f(){var e=rp(),t=a(e);if(p=arguments,d=this,v=e,t){if(m===te)return o(v);if(_)return bf(m),m=Df(i,r),n(v)}return m===te&&(m=Df(i,r)),g}var p,d,h,g,m,v,b=0,y=!1,_=!1,w=!0;if(\"function\"!=typeof e)throw new as(ue);return r=_l(r)||0,el(t)&&(y=!!t.leading,_=\"maxWait\"in t,h=_?Ms(_l(t.maxWait)||0,r):h,w=\"trailing\"in t?!!t.trailing:w),f.cancel=c,f.flush=s,f}function Di(e){return uu(e,xe)}function Ci(e,r){if(\"function\"!=typeof e||null!=r&&\"function\"!=typeof r)throw new as(ue);var t=function(){var n=arguments,o=r?r.apply(this,n):n[0],u=t.cache;if(u.has(o))return u.get(o);var a=e.apply(this,n);return t.cache=u.set(o,a)||u,a};return t.cache=new(Ci.Cache||ut),t}function ki(e){if(\"function\"!=typeof e)throw new as(ue);return function(){var r=arguments;switch(r.length){case 0:return!e.call(this);case 1:return!e.call(this,r[0]);case 2:return!e.call(this,r[0],r[1]);case 3:return!e.call(this,r[0],r[1],r[2])}return!e.apply(this,r)}}function Si(e){return Ei(2,e)}function Oi(e,r){if(\"function\"!=typeof e)throw new as(ue);return r=r===te?r:bl(r),Xn(e,r)}function Ti(e,r){if(\"function\"!=typeof e)throw new as(ue);return r=null==r?0:Ms(bl(r),0),Xn(function(t){var n=t[r],o=Eo(t,0,r);return n&&h(o,n),u(e,this,o)})}function Ri(e,r,t){var n=!0,o=!0;if(\"function\"!=typeof e)throw new as(ue);return el(t)&&(n=\"leading\"in t?!!t.leading:n,o=\"trailing\"in t?!!t.trailing:o),qi(e,r,{leading:n,maxWait:r,trailing:o})}function Li(e){return wi(e,1)}function Ni(e,r){return ip(_o(r),e)}function Pi(){if(!arguments.length)return[];var e=arguments[0];return dp(e)?e:[e]}function Bi(e){return Xt(e,fe)}function ji(e,r){return r=\"function\"==typeof r?r:te,Xt(e,fe,r)}function Ii(e){return Xt(e,ce|fe)}function Ui(e,r){return r=\"function\"==typeof r?r:te,Xt(e,ce|fe,r)}function Fi(e,r){return null==r||rn(e,r,Bl(r))}function Mi(e,r){return e===r||e!==e&&r!==r}function Vi(e){return null!=e&&Xi(e.length)&&!$i(e)}function Hi(e){return rl(e)&&Vi(e)}function zi(e){return!0===e||!1===e||rl(e)&&gn(e)==Me}function Gi(e){return rl(e)&&1===e.nodeType&&!cl(e)}function Wi(e){if(null==e)return!0;if(Vi(e)&&(dp(e)||\"string\"==typeof e||\"function\"==typeof e.splice||gp(e)||_p(e)||pp(e)))return!e.length;var r=xf(e);if(r==Je||r==Xe)return!e.size;if(Bu(e))return!Pn(e).length;for(var t in e)if(ps.call(e,t))return!1;return!0}function Ji(e,r){return Dn(e,r)}function Zi(e,r,t){t=\"function\"==typeof t?t:te;var n=t?t(e,r):te;return n===te?Dn(e,r,te,t):!!n}function Yi(e){if(!rl(e))return!1;var r=gn(e);return r==ze||r==He||\"string\"==typeof e.message&&\"string\"==typeof e.name&&!cl(e)}function Ki(e){return\"number\"==typeof e&&Is(e)}function $i(e){if(!el(e))return!1;var r=gn(e);return r==Ge||r==We||r==Fe||r==$e}function Qi(e){return\"number\"==typeof e&&e==bl(e)}function Xi(e){return\"number\"==typeof e&&e>-1&&e%1==0&&e<=Te}function el(e){var r=typeof e;return null!=e&&(\"object\"==r||\"function\"==r)}function rl(e){return null!=e&&\"object\"==typeof e}function tl(e,r){return e===r||Sn(e,r,yu(r))}function nl(e,r,t){return t=\"function\"==typeof t?t:te,Sn(e,r,yu(r),t)}function ol(e){return ll(e)&&e!=+e}function ul(e){if(Af(e))throw new es(oe);return On(e)}function al(e){return null===e}function il(e){return null==e}function ll(e){return\"number\"==typeof e||rl(e)&&gn(e)==Ze}function cl(e){if(!rl(e)||gn(e)!=Ke)return!1;var r=xs(e);if(null===r)return!0;var t=ps.call(r,\"constructor\")&&r.constructor;return\"function\"==typeof t&&t instanceof t&&fs.call(t)==ms}function sl(e){return Qi(e)&&e>=-Te&&e<=Te}function fl(e){return\"string\"==typeof e||!dp(e)&&rl(e)&&gn(e)==er}function pl(e){return\"symbol\"==typeof e||rl(e)&&gn(e)==rr}function dl(e){return e===te}function hl(e){return rl(e)&&xf(e)==nr}function gl(e){return rl(e)&&gn(e)==or}function ml(e){if(!e)return[];if(Vi(e))return fl(e)?Q(e):Lo(e);if(ks&&e[ks])return H(e[ks]());var r=xf(e);return(r==Je?z:r==Xe?J:Yl)(e)}function vl(e){if(!e)return 0===e?e:0;if((e=_l(e))===Oe||e===-Oe){return(e<0?-1:1)*Re}return e===e?e:0}function bl(e){var r=vl(e),t=r%1;return r===r?t?r-t:r:0}function yl(e){return e?Qt(bl(e),0,Ne):0}function _l(e){if(\"number\"==typeof e)return e;if(pl(e))return Le;if(el(e)){var r=\"function\"==typeof e.valueOf?e.valueOf():e;e=el(r)?r+\"\":r}if(\"string\"!=typeof e)return 0===e?e:+e;e=e.replace(Tr,\"\");var t=Vr.test(e);return t||zr.test(e)?Dt(e.slice(2),t?2:8):Mr.test(e)?Le:+e}function wl(e){return No(e,jl(e))}function El(e){return e?Qt(bl(e),-Te,Te):0===e?e:0}function xl(e){return null==e?\"\":so(e)}function Al(e,r){var t=sf(e);return null==r?t:Zt(t,r)}function ql(e,r){return _(e,vu(r,3),sn)}function Dl(e,r){return _(e,vu(r,3),fn)}function Cl(e,r){return null==e?e:df(e,vu(r,3),jl)}function kl(e,r){return null==e?e:hf(e,vu(r,3),jl)}function Sl(e,r){return e&&sn(e,vu(r,3))}function Ol(e,r){return e&&fn(e,vu(r,3))}function Tl(e){return null==e?[]:pn(e,Bl(e))}function Rl(e){return null==e?[]:pn(e,jl(e))}function Ll(e,r,t){var n=null==e?te:dn(e,r);return n===te?t:n}function Nl(e,r){return null!=e&&Au(e,r,vn)}function Pl(e,r){return null!=e&&Au(e,r,bn)}function Bl(e){return Vi(e)?kt(e):Pn(e)}function jl(e){return Vi(e)?kt(e,!0):Bn(e)}function Il(e,r){var t={};return r=vu(r,3),sn(e,function(e,n,o){Kt(t,r(e,n,o),e)}),t}function Ul(e,r){var t={};return r=vu(r,3),sn(e,function(e,n,o){Kt(t,n,r(e,n,o))}),t}function Fl(e,r){return Ml(e,ki(vu(r)))}function Ml(e,r){if(null==e)return{};var t=d(hu(e),function(e){return[e]});return r=vu(r),Wn(e,t,function(e,t){return r(e,t[0])})}function Vl(e,r,t){r=wo(r,e);var n=-1,o=r.length;for(o||(o=1,e=te);++n<o;){var u=null==e?te:e[Yu(r[n])];u===te&&(n=o,u=t),e=$i(u)?u.call(e):u}return e}function Hl(e,r,t){return null==e?e:to(e,r,t)}function zl(e,r,t,n){return n=\"function\"==typeof n?n:te,null==e?e:to(e,r,t,n)}function Gl(e,r,t){var n=dp(e),o=n||gp(e)||_p(e);if(r=vu(r,4),null==t){var u=e&&e.constructor;t=o?n?new u:[]:el(e)&&$i(u)?sf(xs(e)):{}}return(o?i:sn)(e,function(e,n,o){return r(t,e,n,o)}),t}function Wl(e,r){return null==e||po(e,r)}function Jl(e,r,t){return null==e?e:ho(e,r,_o(t))}function Zl(e,r,t,n){return n=\"function\"==typeof n?n:te,null==e?e:ho(e,r,_o(t),n)}function Yl(e){return null==e?[]:N(e,Bl(e))}function Kl(e){return null==e?[]:N(e,jl(e))}function $l(e,r,t){return t===te&&(t=r,r=te),t!==te&&(t=_l(t),t=t===t?t:0),r!==te&&(r=_l(r),r=r===r?r:0),Qt(_l(e),r,t)}function Ql(e,r,t){return r=vl(r),t===te?(t=r,r=0):t=vl(t),e=_l(e),yn(e,r,t)}function Xl(e,r,t){if(t&&\"boolean\"!=typeof t&&Tu(e,r,t)&&(r=t=te),t===te&&(\"boolean\"==typeof r?(t=r,r=te):\"boolean\"==typeof e&&(t=e,e=te)),e===te&&r===te?(e=0,r=1):(e=vl(e),r===te?(r=e,e=0):r=vl(r)),e>r){var n=e;e=r,r=n}if(t||e%1||r%1){var o=Gs();return Vs(e+o*(r-e+qt(\"1e-\"+((o+\"\").length-1))),r)}return Kn(e,r)}function ec(e){return Wp(xl(e).toLowerCase())}function rc(e){return(e=xl(e))&&e.replace(Wr,Vt).replace(pt,\"\")}function tc(e,r,t){e=xl(e),r=so(r);var n=e.length;t=t===te?n:Qt(bl(t),0,n);var o=t;return(t-=r.length)>=0&&e.slice(t,o)==r}function nc(e){return e=xl(e),e&&Er.test(e)?e.replace(_r,Ht):e}function oc(e){return e=xl(e),e&&Or.test(e)?e.replace(Sr,\"\\\\$&\"):e}function uc(e,r,t){e=xl(e),r=bl(r);var n=r?$(e):0;if(!r||n>=r)return e;var o=(r-n)/2;return Qo(Ps(o),t)+e+Qo(Ns(o),t)}function ac(e,r,t){e=xl(e),r=bl(r);var n=r?$(e):0;return r&&n<r?e+Qo(r-n,t):e}function ic(e,r,t){e=xl(e),r=bl(r);var n=r?$(e):0;return r&&n<r?Qo(r-n,t)+e:e}function lc(e,r,t){return t||null==r?r=0:r&&(r=+r),zs(xl(e).replace(Rr,\"\"),r||0)}function cc(e,r,t){return r=(t?Tu(e,r,t):r===te)?1:bl(r),Qn(xl(e),r)}function sc(){var e=arguments,r=xl(e[0]);return e.length<3?r:r.replace(e[1],e[2])}function fc(e,r,t){return t&&\"number\"!=typeof t&&Tu(e,r,t)&&(r=t=te),(t=t===te?Ne:t>>>0)?(e=xl(e),e&&(\"string\"==typeof r||null!=r&&!bp(r))&&!(r=so(r))&&M(e)?Eo(Q(e),0,t):e.split(r,t)):[]}function pc(e,r,t){return e=xl(e),t=null==t?0:Qt(bl(t),0,e.length),r=so(r),e.slice(t,t+r.length)==r}function dc(e,r,n){var o=t.templateSettings;n&&Tu(e,r,n)&&(r=te),e=xl(e),r=qp({},r,o,au);var u,a,i=qp({},r.imports,o.imports,au),l=Bl(i),c=N(i,l),s=0,f=r.interpolate||Jr,p=\"__p += '\",d=os((r.escape||Jr).source+\"|\"+f.source+\"|\"+(f===qr?Ur:Jr).source+\"|\"+(r.evaluate||Jr).source+\"|$\",\"g\"),h=\"//# sourceURL=\"+(ps.call(r,\"sourceURL\")?(r.sourceURL+\"\").replace(/[\\r\\n]/g,\" \"):\"lodash.templateSources[\"+ ++bt+\"]\")+\"\\n\";e.replace(d,function(r,t,n,o,i,l){return n||(n=o),p+=e.slice(s,l).replace(Zr,U),t&&(u=!0,p+=\"' +\\n__e(\"+t+\") +\\n'\"),i&&(a=!0,p+=\"';\\n\"+i+\";\\n__p += '\"),n&&(p+=\"' +\\n((__t = (\"+n+\")) == null ? '' : __t) +\\n'\"),s=l+r.length,r}),p+=\"';\\n\";var g=ps.call(r,\"variable\")&&r.variable;g||(p=\"with (obj) {\\n\"+p+\"\\n}\\n\"),p=(a?p.replace(mr,\"\"):p).replace(vr,\"$1\").replace(br,\"$1;\"),p=\"function(\"+(g||\"obj\")+\") {\\n\"+(g?\"\":\"obj || (obj = {});\\n\")+\"var __t, __p = ''\"+(u?\", __e = _.escape\":\"\")+(a?\", __j = Array.prototype.join;\\nfunction print() { __p += __j.call(arguments, '') }\\n\":\";\\n\")+p+\"return __p\\n}\";var m=Jp(function(){return rs(l,h+\"return \"+p).apply(te,c)});if(m.source=p,Yi(m))throw m;return m}function hc(e){return xl(e).toLowerCase()}function gc(e){return xl(e).toUpperCase()}function mc(e,r,t){if((e=xl(e))&&(t||r===te))return e.replace(Tr,\"\");if(!e||!(r=so(r)))return e;var n=Q(e),o=Q(r);return Eo(n,B(n,o),j(n,o)+1).join(\"\")}function vc(e,r,t){if((e=xl(e))&&(t||r===te))return e.replace(Lr,\"\");if(!e||!(r=so(r)))return e;var n=Q(e);return Eo(n,0,j(n,Q(r))+1).join(\"\")}function bc(e,r,t){if((e=xl(e))&&(t||r===te))return e.replace(Rr,\"\");if(!e||!(r=so(r)))return e;var n=Q(e);return Eo(n,B(n,Q(r))).join(\"\")}function yc(e,r){var t=Ae,n=qe;if(el(r)){var o=\"separator\"in r?r.separator:o;t=\"length\"in r?bl(r.length):t,n=\"omission\"in r?so(r.omission):n}e=xl(e);var u=e.length;if(M(e)){var a=Q(e);u=a.length}if(t>=u)return e;var i=t-$(n);if(i<1)return n;var l=a?Eo(a,0,i).join(\"\"):e.slice(0,i);if(o===te)return l+n;if(a&&(i+=l.length-i),bp(o)){if(e.slice(i).search(o)){var c,s=l;for(o.global||(o=os(o.source,xl(Fr.exec(o))+\"g\")),o.lastIndex=0;c=o.exec(s);)var f=c.index;l=l.slice(0,f===te?i:f)}}else if(e.indexOf(so(o),i)!=i){var p=l.lastIndexOf(o);p>-1&&(l=l.slice(0,p))}return l+n}function _c(e){return e=xl(e),e&&wr.test(e)?e.replace(yr,zt):e}function wc(e,r,t){return e=xl(e),r=t?te:r,r===te?V(e)?re(e):y(e):e.match(r)||[]}function Ec(e){var r=null==e?0:e.length,t=vu();return e=r?d(e,function(e){if(\"function\"!=typeof e[1])throw new as(ue);return[t(e[0]),e[1]]}):[],Xn(function(t){for(var n=-1;++n<r;){var o=e[n];if(u(o[0],this,t))return u(o[1],this,t)}})}function xc(e){return en(Xt(e,ce))}function Ac(e){return function(){return e}}function qc(e,r){return null==e||e!==e?r:e}function Dc(e){return e}function Cc(e){return Nn(\"function\"==typeof e?e:Xt(e,ce))}function kc(e){return Un(Xt(e,ce))}function Sc(e,r){return Fn(e,Xt(r,ce))}function Oc(e,r,t){var n=Bl(r),o=pn(r,n);null!=t||el(r)&&(o.length||!n.length)||(t=r,r=e,e=this,o=pn(r,Bl(r)));var u=!(el(t)&&\"chain\"in t)||!!t.chain,a=$i(e);return i(o,function(t){var n=r[t];e[t]=n,a&&(e.prototype[t]=function(){var r=this.__chain__;if(u||r){var t=e(this.__wrapped__);return(t.__actions__=Lo(this.__actions__)).push({func:n,args:arguments,thisArg:e}),t.__chain__=r,t}return n.apply(e,h([this.value()],arguments))})}),e}function Tc(){return St._===this&&(St._=vs),this}function Rc(){}function Lc(e){return e=bl(e),Xn(function(r){return Hn(r,e)})}function Nc(e){return Ru(e)?D(Yu(e)):Jn(e)}function Pc(e){return function(r){return null==e?te:dn(e,r)}}function Bc(){return[]}function jc(){return!1}function Ic(){return{}}function Uc(){return\"\"}function Fc(){return!0}function Mc(e,r){if((e=bl(e))<1||e>Te)return[];var t=Ne,n=Vs(e,Ne);r=vu(r),e-=Ne;for(var o=T(n,r);++t<e;)r(t);return o}function Vc(e){return dp(e)?d(e,Yu):pl(e)?[e]:Lo(kf(xl(e)))}function Hc(e){var r=++ds;return xl(e)+r}function zc(e){return e&&e.length?un(e,Dc,mn):te}function Gc(e,r){return e&&e.length?un(e,vu(r,2),mn):te}function Wc(e){return q(e,Dc)}function Jc(e,r){return q(e,vu(r,2))}function Zc(e){return e&&e.length?un(e,Dc,jn):te}function Yc(e,r){return e&&e.length?un(e,vu(r,2),jn):te}function Kc(e){return e&&e.length?O(e,Dc):0}function $c(e,r){return e&&e.length?O(e,vu(r,2)):0}r=null==r?St:Gt.defaults(St.Object(),r,Gt.pick(St,vt));var Qc=r.Array,Xc=r.Date,es=r.Error,rs=r.Function,ts=r.Math,ns=r.Object,os=r.RegExp,us=r.String,as=r.TypeError,is=Qc.prototype,ls=rs.prototype,cs=ns.prototype,ss=r[\"__core-js_shared__\"],fs=ls.toString,ps=cs.hasOwnProperty,ds=0,hs=function(){var e=/[^.]+$/.exec(ss&&ss.keys&&ss.keys.IE_PROTO||\"\");return e?\"Symbol(src)_1.\"+e:\"\"}(),gs=cs.toString,ms=fs.call(ns),vs=St._,bs=os(\"^\"+fs.call(ps).replace(Sr,\"\\\\$&\").replace(/hasOwnProperty|(function).*?(?=\\\\\\()| for .+?(?=\\\\\\])/g,\"$1.*?\")+\"$\"),ys=Rt?r.Buffer:te,_s=r.Symbol,ws=r.Uint8Array,Es=ys?ys.allocUnsafe:te,xs=G(ns.getPrototypeOf,ns),As=ns.create,qs=cs.propertyIsEnumerable,Ds=is.splice,Cs=_s?_s.isConcatSpreadable:te,ks=_s?_s.iterator:te,Ss=_s?_s.toStringTag:te,Os=function(){try{var e=_u(ns,\"defineProperty\");return e({},\"\",{}),e}catch(e){}}(),Ts=r.clearTimeout!==St.clearTimeout&&r.clearTimeout,Rs=Xc&&Xc.now!==St.Date.now&&Xc.now,Ls=r.setTimeout!==St.setTimeout&&r.setTimeout,Ns=ts.ceil,Ps=ts.floor,Bs=ns.getOwnPropertySymbols,js=ys?ys.isBuffer:te,Is=r.isFinite,Us=is.join,Fs=G(ns.keys,ns),Ms=ts.max,Vs=ts.min,Hs=Xc.now,zs=r.parseInt,Gs=ts.random,Ws=is.reverse,Js=_u(r,\"DataView\"),Zs=_u(r,\"Map\"),Ys=_u(r,\"Promise\"),Ks=_u(r,\"Set\"),$s=_u(r,\"WeakMap\"),Qs=_u(ns,\"create\"),Xs=$s&&new $s,ef={},rf=Ku(Js),tf=Ku(Zs),nf=Ku(Ys),of=Ku(Ks),uf=Ku($s),af=_s?_s.prototype:te,lf=af?af.valueOf:te,cf=af?af.toString:te,sf=function(){function e(){}return function(r){if(!el(r))return{};if(As)return As(r);e.prototype=r;var t=new e;return e.prototype=te,t}}();t.templateSettings={escape:xr,evaluate:Ar,interpolate:qr,variable:\"\",imports:{_:t}},t.prototype=n.prototype,t.prototype.constructor=t,o.prototype=sf(n.prototype),o.prototype.constructor=o,b.prototype=sf(n.prototype),b.prototype.constructor=b,ee.prototype.clear=jr,ee.prototype.delete=Yr,ee.prototype.get=Kr,ee.prototype.has=$r,ee.prototype.set=Qr,Xr.prototype.clear=et,Xr.prototype.delete=rt,Xr.prototype.get=tt,Xr.prototype.has=nt,Xr.prototype.set=ot,ut.prototype.clear=at,ut.prototype.delete=it,ut.prototype.get=lt,ut.prototype.has=ct,ut.prototype.set=st,dt.prototype.add=dt.prototype.push=ht,dt.prototype.has=gt,mt.prototype.clear=wt,mt.prototype.delete=Et,mt.prototype.get=xt,mt.prototype.has=At,mt.prototype.set=Ct;var ff=Uo(sn),pf=Uo(fn,!0),df=Fo(),hf=Fo(!0),gf=Xs?function(e,r){return Xs.set(e,r),e}:Dc,mf=Os?function(e,r){return Os(e,\"toString\",{configurable:!0,enumerable:!1,value:Ac(r),writable:!0})}:Dc,vf=Xn,bf=Ts||function(e){return St.clearTimeout(e)},yf=Ks&&1/J(new Ks([,-0]))[1]==Oe?function(e){return new Ks(e)}:Rc,_f=Xs?function(e){return Xs.get(e)}:Rc,wf=Bs?function(e){return null==e?[]:(e=ns(e),s(Bs(e),function(r){return qs.call(e,r)}))}:Bc,Ef=Bs?function(e){for(var r=[];e;)h(r,wf(e)),e=xs(e);return r}:Bc,xf=gn;(Js&&xf(new Js(new ArrayBuffer(1)))!=ar||Zs&&xf(new Zs)!=Je||Ys&&\"[object Promise]\"!=xf(Ys.resolve())||Ks&&xf(new Ks)!=Xe||$s&&xf(new $s)!=nr)&&(xf=function(e){var r=gn(e),t=r==Ke?e.constructor:te,n=t?Ku(t):\"\";if(n)switch(n){case rf:return ar;case tf:return Je;case nf:return\"[object Promise]\";case of:return Xe;case uf:return nr}return r});var Af=ss?$i:jc,qf=Ju(gf),Df=Ls||function(e,r){return St.setTimeout(e,r)},Cf=Ju(mf),kf=function(e){var r=Ci(e,function(e){return t.size===ie&&t.clear(),e}),t=r.cache;return r}(function(e){var r=[];return 46===e.charCodeAt(0)&&r.push(\"\"),e.replace(kr,function(e,t,n,o){r.push(n?o.replace(Ir,\"$1\"):t||e)}),r}),Sf=Xn(function(e,r){return Hi(e)?nn(e,cn(r,1,Hi,!0)):[]}),Of=Xn(function(e,r){var t=va(r);return Hi(t)&&(t=te),Hi(e)?nn(e,cn(r,1,Hi,!0),vu(t,2)):[]}),Tf=Xn(function(e,r){var t=va(r);return Hi(t)&&(t=te),Hi(e)?nn(e,cn(r,1,Hi,!0),te,t):[]}),Rf=Xn(function(e){var r=d(e,yo);return r.length&&r[0]===e[0]?_n(r):[]}),Lf=Xn(function(e){var r=va(e),t=d(e,yo);return r===va(t)?r=te:t.pop(),t.length&&t[0]===e[0]?_n(t,vu(r,2)):[]}),Nf=Xn(function(e){var r=va(e),t=d(e,yo);return r=\"function\"==typeof r?r:te,r&&t.pop(),t.length&&t[0]===e[0]?_n(t,te,r):[]}),Pf=Xn(_a),Bf=pu(function(e,r){var t=null==e?0:e.length,n=$t(e,r);return Yn(e,d(r,function(e){return Ou(e,t)?+e:e}).sort(So)),n}),jf=Xn(function(e){return fo(cn(e,1,Hi,!0))}),If=Xn(function(e){var r=va(e);return Hi(r)&&(r=te),fo(cn(e,1,Hi,!0),vu(r,2))}),Uf=Xn(function(e){var r=va(e);return r=\"function\"==typeof r?r:te,fo(cn(e,1,Hi,!0),te,r)}),Ff=Xn(function(e,r){return Hi(e)?nn(e,r):[]}),Mf=Xn(function(e){return vo(s(e,Hi))}),Vf=Xn(function(e){var r=va(e);return Hi(r)&&(r=te),vo(s(e,Hi),vu(r,2))}),Hf=Xn(function(e){var r=va(e);return r=\"function\"==typeof r?r:te,vo(s(e,Hi),te,r)}),zf=Xn(Va),Gf=Xn(function(e){var r=e.length,t=r>1?e[r-1]:te;return t=\"function\"==typeof t?(e.pop(),t):te,Ha(e,t)}),Wf=pu(function(e){var r=e.length,t=r?e[0]:0,n=this.__wrapped__,u=function(r){return $t(r,e)};return!(r>1||this.__actions__.length)&&n instanceof b&&Ou(t)?(n=n.slice(t,+t+(r?1:0)),n.__actions__.push({func:Za,args:[u],thisArg:te}),new o(n,this.__chain__).thru(function(e){return r&&!e.length&&e.push(te),e})):this.thru(u)}),Jf=jo(function(e,r,t){ps.call(e,t)?++e[t]:Kt(e,t,1)}),Zf=Wo(ia),Yf=Wo(la),Kf=jo(function(e,r,t){ps.call(e,t)?e[t].push(r):Kt(e,t,[r])}),$f=Xn(function(e,r,t){var n=-1,o=\"function\"==typeof r,a=Vi(e)?Qc(e.length):[];return ff(e,function(e){a[++n]=o?u(r,e,t):En(e,r,t)}),a}),Qf=jo(function(e,r,t){Kt(e,t,r)}),Xf=jo(function(e,r,t){e[t?0:1].push(r)},function(){return[[],[]]}),ep=Xn(function(e,r){if(null==e)return[];var t=r.length;return t>1&&Tu(e,r[0],r[1])?r=[]:t>2&&Tu(r[0],r[1],r[2])&&(r=[r[0]]),zn(e,cn(r,1),[])}),rp=Rs||function(){return St.Date.now()},tp=Xn(function(e,r,t){var n=he;if(t.length){var o=W(t,mu(tp));n|=ye}return uu(e,n,r,t,o)}),np=Xn(function(e,r,t){var n=he|ge;if(t.length){var o=W(t,mu(np));n|=ye}return uu(r,n,e,t,o)}),op=Xn(function(e,r){return tn(e,1,r)}),up=Xn(function(e,r,t){return tn(e,_l(r)||0,t)});Ci.Cache=ut;var ap=vf(function(e,r){r=1==r.length&&dp(r[0])?d(r[0],L(vu())):d(cn(r,1),L(vu()));var t=r.length;return Xn(function(n){for(var o=-1,a=Vs(n.length,t);++o<a;)n[o]=r[o].call(this,n[o]);return u(e,this,n)})}),ip=Xn(function(e,r){var t=W(r,mu(ip));return uu(e,ye,te,r,t)}),lp=Xn(function(e,r){var t=W(r,mu(lp));return uu(e,_e,te,r,t)}),cp=pu(function(e,r){return uu(e,Ee,te,te,te,r)}),sp=ru(mn),fp=ru(function(e,r){return e>=r}),pp=xn(function(){return arguments}())?xn:function(e){return rl(e)&&ps.call(e,\"callee\")&&!qs.call(e,\"callee\")},dp=Qc.isArray,hp=Pt?L(Pt):An,gp=js||jc,mp=Bt?L(Bt):qn,vp=jt?L(jt):kn,bp=It?L(It):Tn,yp=Ut?L(Ut):Rn,_p=Ft?L(Ft):Ln,wp=ru(jn),Ep=ru(function(e,r){return e<=r}),xp=Io(function(e,r){if(Bu(r)||Vi(r))return void No(r,Bl(r),e);for(var t in r)ps.call(r,t)&&Mt(e,t,r[t])}),Ap=Io(function(e,r){No(r,jl(r),e)}),qp=Io(function(e,r,t,n){No(r,jl(r),e,n)}),Dp=Io(function(e,r,t,n){No(r,Bl(r),e,n)}),Cp=pu($t),kp=Xn(function(e,r){e=ns(e);var t=-1,n=r.length,o=n>2?r[2]:te;for(o&&Tu(r[0],r[1],o)&&(n=1);++t<n;)for(var u=r[t],a=jl(u),i=-1,l=a.length;++i<l;){var c=a[i],s=e[c];(s===te||Mi(s,cs[c])&&!ps.call(e,c))&&(e[c]=u[c])}return e}),Sp=Xn(function(e){return e.push(te,iu),u(Np,te,e)}),Op=Yo(function(e,r,t){null!=r&&\"function\"!=typeof r.toString&&(r=gs.call(r)),e[r]=t},Ac(Dc)),Tp=Yo(function(e,r,t){null!=r&&\"function\"!=typeof r.toString&&(r=gs.call(r)),ps.call(e,r)?e[r].push(t):e[r]=[t]},vu),Rp=Xn(En),Lp=Io(function(e,r,t){Mn(e,r,t)}),Np=Io(function(e,r,t,n){Mn(e,r,t,n)}),Pp=pu(function(e,r){var t={};if(null==e)return t;var n=!1;r=d(r,function(r){return r=wo(r,e),n||(n=r.length>1),r}),No(e,hu(e),t),n&&(t=Xt(t,ce|se|fe,lu));for(var o=r.length;o--;)po(t,r[o]);return t}),Bp=pu(function(e,r){return null==e?{}:Gn(e,r)}),jp=ou(Bl),Ip=ou(jl),Up=Ho(function(e,r,t){return r=r.toLowerCase(),e+(t?ec(r):r)}),Fp=Ho(function(e,r,t){return e+(t?\"-\":\"\")+r.toLowerCase()}),Mp=Ho(function(e,r,t){return e+(t?\" \":\"\")+r.toLowerCase()}),Vp=Vo(\"toLowerCase\"),Hp=Ho(function(e,r,t){return e+(t?\"_\":\"\")+r.toLowerCase()}),zp=Ho(function(e,r,t){return e+(t?\" \":\"\")+Wp(r)}),Gp=Ho(function(e,r,t){return e+(t?\" \":\"\")+r.toUpperCase()}),Wp=Vo(\"toUpperCase\"),Jp=Xn(function(e,r){try{return u(e,te,r)}catch(e){return Yi(e)?e:new es(e)}}),Zp=pu(function(e,r){return i(r,function(r){r=Yu(r),Kt(e,r,tp(e[r],e))}),e}),Yp=Jo(),Kp=Jo(!0),$p=Xn(function(e,r){return function(t){return En(t,e,r)}}),Qp=Xn(function(e,r){return function(t){return En(e,t,r)}}),Xp=$o(d),ed=$o(c),rd=$o(v),td=eu(),nd=eu(!0),od=Ko(function(e,r){return e+r},0),ud=nu(\"ceil\"),ad=Ko(function(e,r){return e/r},1),id=nu(\"floor\"),ld=Ko(function(e,r){return e*r},1),cd=nu(\"round\"),sd=Ko(function(e,r){return e-r},0);return t.after=_i,t.ary=wi,t.assign=xp,t.assignIn=Ap,t.assignInWith=qp,t.assignWith=Dp,t.at=Cp,t.before=Ei,t.bind=tp,t.bindAll=Zp,t.bindKey=np,t.castArray=Pi,t.chain=Wa,t.chunk=Xu,t.compact=ea,t.concat=ra,t.cond=Ec,t.conforms=xc,t.constant=Ac,t.countBy=Jf,t.create=Al,t.curry=xi,t.curryRight=Ai,t.debounce=qi,t.defaults=kp,t.defaultsDeep=Sp,t.defer=op,t.delay=up,t.difference=Sf,t.differenceBy=Of,t.differenceWith=Tf,t.drop=ta,t.dropRight=na,t.dropRightWhile=oa,t.dropWhile=ua,t.fill=aa,t.filter=ni,t.flatMap=oi,t.flatMapDeep=ui,t.flatMapDepth=ai,t.flatten=ca,t.flattenDeep=sa,t.flattenDepth=fa,t.flip=Di,t.flow=Yp,t.flowRight=Kp,t.fromPairs=pa,t.functions=Tl,t.functionsIn=Rl,t.groupBy=Kf,t.initial=ga,t.intersection=Rf,t.intersectionBy=Lf,t.intersectionWith=Nf,t.invert=Op,t.invertBy=Tp,t.invokeMap=$f,t.iteratee=Cc,t.keyBy=Qf,t.keys=Bl,t.keysIn=jl,t.map=si,t.mapKeys=Il,t.mapValues=Ul,t.matches=kc,t.matchesProperty=Sc,t.memoize=Ci,t.merge=Lp,t.mergeWith=Np,t.method=$p,t.methodOf=Qp,t.mixin=Oc,t.negate=ki,t.nthArg=Lc,t.omit=Pp,t.omitBy=Fl,t.once=Si,t.orderBy=fi,t.over=Xp,t.overArgs=ap,t.overEvery=ed,t.overSome=rd,t.partial=ip,t.partialRight=lp,t.partition=Xf,t.pick=Bp,t.pickBy=Ml,t.property=Nc,t.propertyOf=Pc,t.pull=Pf,t.pullAll=_a,t.pullAllBy=wa,t.pullAllWith=Ea,t.pullAt=Bf,t.range=td,t.rangeRight=nd,t.rearg=cp,t.reject=hi,t.remove=xa,t.rest=Oi,t.reverse=Aa,t.sampleSize=mi,t.set=Hl,t.setWith=zl,t.shuffle=vi,t.slice=qa,t.sortBy=ep,t.sortedUniq=Ra,t.sortedUniqBy=La,t.split=fc,t.spread=Ti,t.tail=Na,t.take=Pa,t.takeRight=Ba,t.takeRightWhile=ja,t.takeWhile=Ia,t.tap=Ja,t.throttle=Ri,t.thru=Za,t.toArray=ml,t.toPairs=jp,t.toPairsIn=Ip,t.toPath=Vc,t.toPlainObject=wl,t.transform=Gl,t.unary=Li,t.union=jf,t.unionBy=If,t.unionWith=Uf,t.uniq=Ua,t.uniqBy=Fa,t.uniqWith=Ma,t.unset=Wl,t.unzip=Va,t.unzipWith=Ha,t.update=Jl,t.updateWith=Zl,t.values=Yl,t.valuesIn=Kl,t.without=Ff,t.words=wc,t.wrap=Ni,t.xor=Mf,t.xorBy=Vf,t.xorWith=Hf,t.zip=zf,t.zipObject=za,t.zipObjectDeep=Ga,t.zipWith=Gf,t.entries=jp,t.entriesIn=Ip,t.extend=Ap,t.extendWith=qp,Oc(t,t),t.add=od,t.attempt=Jp,t.camelCase=Up,t.capitalize=ec,t.ceil=ud,t.clamp=$l,t.clone=Bi,t.cloneDeep=Ii,t.cloneDeepWith=Ui,t.cloneWith=ji,t.conformsTo=Fi,t.deburr=rc,t.defaultTo=qc,t.divide=ad,t.endsWith=tc,t.eq=Mi,t.escape=nc,t.escapeRegExp=oc,t.every=ti,t.find=Zf,t.findIndex=ia,t.findKey=ql,t.findLast=Yf,t.findLastIndex=la,t.findLastKey=Dl,t.floor=id,t.forEach=ii,t.forEachRight=li,t.forIn=Cl,t.forInRight=kl,t.forOwn=Sl,t.forOwnRight=Ol,t.get=Ll,t.gt=sp,t.gte=fp,t.has=Nl,t.hasIn=Pl,t.head=da,t.identity=Dc,t.includes=ci,t.indexOf=ha,t.inRange=Ql,t.invoke=Rp,t.isArguments=pp,t.isArray=dp,t.isArrayBuffer=hp,t.isArrayLike=Vi,t.isArrayLikeObject=Hi,t.isBoolean=zi,t.isBuffer=gp,t.isDate=mp,t.isElement=Gi,t.isEmpty=Wi,t.isEqual=Ji,t.isEqualWith=Zi,t.isError=Yi,t.isFinite=Ki,t.isFunction=$i,t.isInteger=Qi,t.isLength=Xi,t.isMap=vp,t.isMatch=tl,t.isMatchWith=nl,t.isNaN=ol,t.isNative=ul,t.isNil=il,t.isNull=al,t.isNumber=ll,t.isObject=el,t.isObjectLike=rl,t.isPlainObject=cl,t.isRegExp=bp,t.isSafeInteger=sl,t.isSet=yp,t.isString=fl,t.isSymbol=pl,t.isTypedArray=_p,t.isUndefined=dl,t.isWeakMap=hl,t.isWeakSet=gl,t.join=ma,t.kebabCase=Fp,t.last=va,t.lastIndexOf=ba,t.lowerCase=Mp,t.lowerFirst=Vp,t.lt=wp,t.lte=Ep,t.max=zc,t.maxBy=Gc,t.mean=Wc,t.meanBy=Jc,t.min=Zc,t.minBy=Yc,t.stubArray=Bc,t.stubFalse=jc,t.stubObject=Ic,t.stubString=Uc,t.stubTrue=Fc,t.multiply=ld,t.nth=ya,t.noConflict=Tc,t.noop=Rc,t.now=rp,t.pad=uc,t.padEnd=ac,t.padStart=ic,t.parseInt=lc,t.random=Xl,t.reduce=pi,t.reduceRight=di,t.repeat=cc,t.replace=sc,t.result=Vl,t.round=cd,t.runInContext=e,t.sample=gi,t.size=bi,t.snakeCase=Hp,t.some=yi,t.sortedIndex=Da,t.sortedIndexBy=Ca,t.sortedIndexOf=ka,t.sortedLastIndex=Sa,t.sortedLastIndexBy=Oa,t.sortedLastIndexOf=Ta,t.startCase=zp,t.startsWith=pc,t.subtract=sd,t.sum=Kc,t.sumBy=$c,t.template=dc,t.times=Mc,t.toFinite=vl,t.toInteger=bl,t.toLength=yl,t.toLower=hc,t.toNumber=_l,t.toSafeInteger=El,t.toString=xl,t.toUpper=gc,t.trim=mc,t.trimEnd=vc,t.trimStart=bc,t.truncate=yc,t.unescape=_c,t.uniqueId=Hc,t.upperCase=Gp,t.upperFirst=Wp,t.each=ii,t.eachRight=li,t.first=da,Oc(t,function(){var e={};return sn(t,function(r,n){ps.call(t.prototype,n)||(e[n]=r)}),e}(),{chain:!1}),t.VERSION=\"4.17.15\",i([\"bind\",\"bindKey\",\"curry\",\"curryRight\",\"partial\",\"partialRight\"],function(e){t[e].placeholder=t}),i([\"drop\",\"take\"],function(e,r){b.prototype[e]=function(t){t=t===te?1:Ms(bl(t),0);var n=this.__filtered__&&!r?new b(this):this.clone();return n.__filtered__?n.__takeCount__=Vs(t,n.__takeCount__):n.__views__.push({size:Vs(t,Ne),type:e+(n.__dir__<0?\"Right\":\"\")}),n},b.prototype[e+\"Right\"]=function(r){return this.reverse()[e](r).reverse()}}),i([\"filter\",\"map\",\"takeWhile\"],function(e,r){var t=r+1,n=t==ke||3==t;b.prototype[e]=function(e){var r=this.clone();return r.__iteratees__.push({iteratee:vu(e,3),type:t}),r.__filtered__=r.__filtered__||n,r}}),i([\"head\",\"last\"],function(e,r){var t=\"take\"+(r?\"Right\":\"\");b.prototype[e]=function(){return this[t](1).value()[0]}}),i([\"initial\",\"tail\"],function(e,r){var t=\"drop\"+(r?\"\":\"Right\");b.prototype[e]=function(){return this.__filtered__?new b(this):this[t](1)}}),b.prototype.compact=function(){return this.filter(Dc)},b.prototype.find=function(e){return this.filter(e).head()},b.prototype.findLast=function(e){return this.reverse().find(e)},b.prototype.invokeMap=Xn(function(e,r){return\"function\"==typeof e?new b(this):this.map(function(t){return En(t,e,r)})}),b.prototype.reject=function(e){return this.filter(ki(vu(e)))},b.prototype.slice=function(e,r){e=bl(e);var t=this;return t.__filtered__&&(e>0||r<0)?new b(t):(e<0?t=t.takeRight(-e):e&&(t=t.drop(e)),r!==te&&(r=bl(r),t=r<0?t.dropRight(-r):t.take(r-e)),t)},b.prototype.takeRightWhile=function(e){return this.reverse().takeWhile(e).reverse()},b.prototype.toArray=function(){return this.take(Ne)},sn(b.prototype,function(e,r){var n=/^(?:filter|find|map|reject)|While$/.test(r),u=/^(?:head|last)$/.test(r),a=t[u?\"take\"+(\"last\"==r?\"Right\":\"\"):r],i=u||/^find/.test(r);a&&(t.prototype[r]=function(){var r=this.__wrapped__,l=u?[1]:arguments,c=r instanceof b,s=l[0],f=c||dp(r),p=function(e){var r=a.apply(t,h([e],l));return u&&d?r[0]:r};f&&n&&\"function\"==typeof s&&1!=s.length&&(c=f=!1);var d=this.__chain__,g=!!this.__actions__.length,m=i&&!d,v=c&&!g;if(!i&&f){r=v?r:new b(this);var y=e.apply(r,l);return y.__actions__.push({func:Za,args:[p],thisArg:te}),new o(y,d)}return m&&v?e.apply(this,l):(y=this.thru(p),m?u?y.value()[0]:y.value():y)})}),i([\"pop\",\"push\",\"shift\",\"sort\",\"splice\",\"unshift\"],function(e){var r=is[e],n=/^(?:push|sort|unshift)$/.test(e)?\"tap\":\"thru\",o=/^(?:pop|shift)$/.test(e);t.prototype[e]=function(){var e=arguments;if(o&&!this.__chain__){var t=this.value();return r.apply(dp(t)?t:[],e)}return this[n](function(t){return r.apply(dp(t)?t:[],e)})}}),sn(b.prototype,function(e,r){var n=t[r];if(n){var o=n.name+\"\";ps.call(ef,o)||(ef[o]=[]),ef[o].push({name:r,func:n})}}),ef[Zo(te,ge).name]=[{name:\"wrapper\",func:te}],b.prototype.clone=C,b.prototype.reverse=Y,b.prototype.value=X,t.prototype.at=Wf,t.prototype.chain=Ya,t.prototype.commit=Ka,t.prototype.next=$a,t.prototype.plant=Xa,t.prototype.reverse=ei,t.prototype.toJSON=t.prototype.valueOf=t.prototype.value=ri,t.prototype.first=t.prototype.head,ks&&(t.prototype[ks]=Qa),t}();St._=Gt,(o=function(){return Gt}.call(r,t,r,n))!==te&&(n.exports=o)}).call(this)}).call(r,t(108),t(309)(e))},276:function(e,r,t){\"use strict\";Object.defineProperty(r,\"__esModule\",{value:!0});var n=t(449),o=function(e){return e&&e.__esModule?e:{default:e}}(n);r.default=o.default,e.exports=r.default},284:function(e,r,t){\"use strict\";function n(e){return e&&e.__esModule?e:{default:e}}Object.defineProperty(r,\"__esModule\",{value:!0}),r.LoaderContainer=void 0;var o=t(432),u=n(o),a=t(433),i=n(a);r.default=u.default,r.LoaderContainer=i.default},291:function(e,r,t){r.f=t(4)},292:function(e,r,t){var n=t(3),o=t(7),u=t(49),a=t(291),i=t(33).f;e.exports=function(e){var r=o.Symbol||(o.Symbol=u?{}:n.Symbol||{});\"_\"==e.charAt(0)||e in r||i(r,e,{value:a.f(e)})}},294:function(e,r,t){\"use strict\";Object.defineProperty(r,\"__esModule\",{value:!0});var n=t(434),o=function(e){return e&&e.__esModule?e:{default:e}}(n);r.default=o.default,e.exports=r.default},309:function(e,r){e.exports=function(e){return e.webpackPolyfill||(e.deprecate=function(){},e.paths=[],e.children||(e.children=[]),Object.defineProperty(e,\"loaded\",{enumerable:!0,get:function(){return e.l}}),Object.defineProperty(e,\"id\",{enumerable:!0,get:function(){return e.i}}),e.webpackPolyfill=1),e}},310:function(e,r,t){e.exports={default:t(438),__esModule:!0}},311:function(e,r,t){\"use strict\";function n(e){return e&&e.__esModule?e:{default:e}}r.__esModule=!0;var o=t(415),u=n(o),a=t(403),i=n(a),l=\"function\"===typeof i.default&&\"symbol\"===typeof u.default?function(e){return typeof e}:function(e){return e&&\"function\"===typeof i.default&&e.constructor===i.default&&e!==i.default.prototype?\"symbol\":typeof e};r.default=\"function\"===typeof i.default&&\"symbol\"===l(u.default)?function(e){return\"undefined\"===typeof e?\"undefined\":l(e)}:function(e){return e&&\"function\"===typeof i.default&&e.constructor===i.default&&e!==i.default.prototype?\"symbol\":\"undefined\"===typeof e?\"undefined\":l(e)}},313:function(e,r,t){var n=t(71)(\"meta\"),o=t(28),u=t(35),a=t(33).f,i=0,l=Object.isExtensible||function(){return!0},c=!t(46)(function(){return l(Object.preventExtensions({}))}),s=function(e){a(e,n,{value:{i:\"O\"+ ++i,w:{}}})},f=function(e,r){if(!o(e))return\"symbol\"==typeof e?e:(\"string\"==typeof e?\"S\":\"P\")+e;if(!u(e,n)){if(!l(e))return\"F\";if(!r)return\"E\";s(e)}return e[n].i},p=function(e,r){if(!u(e,n)){if(!l(e))return!0;if(!r)return!1;s(e)}return e[n].w},d=function(e){return c&&h.NEED&&l(e)&&!u(e,n)&&s(e),e},h=e.exports={KEY:n,NEED:!1,fastKey:f,getWeak:p,onFreeze:d}},314:function(e,r,t){(function(e,n){var o;!function(u){var a=\"object\"==typeof r&&r,i=(\"object\"==typeof e&&e&&e.exports,\"object\"==typeof n&&n);var l=/[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,c=/[\\x01-\\x7F]/g,s=/[\\x01-\\t\\x0B\\f\\x0E-\\x1F\\x7F\\x81\\x8D\\x8F\\x90\\x9D\\xA0-\\uFFFF]/g,f=/<\\u20D2|=\\u20E5|>\\u20D2|\\u205F\\u200A|\\u219D\\u0338|\\u2202\\u0338|\\u2220\\u20D2|\\u2229\\uFE00|\\u222A\\uFE00|\\u223C\\u20D2|\\u223D\\u0331|\\u223E\\u0333|\\u2242\\u0338|\\u224B\\u0338|\\u224D\\u20D2|\\u224E\\u0338|\\u224F\\u0338|\\u2250\\u0338|\\u2261\\u20E5|\\u2264\\u20D2|\\u2265\\u20D2|\\u2266\\u0338|\\u2267\\u0338|\\u2268\\uFE00|\\u2269\\uFE00|\\u226A\\u0338|\\u226A\\u20D2|\\u226B\\u0338|\\u226B\\u20D2|\\u227F\\u0338|\\u2282\\u20D2|\\u2283\\u20D2|\\u228A\\uFE00|\\u228B\\uFE00|\\u228F\\u0338|\\u2290\\u0338|\\u2293\\uFE00|\\u2294\\uFE00|\\u22B4\\u20D2|\\u22B5\\u20D2|\\u22D8\\u0338|\\u22D9\\u0338|\\u22DA\\uFE00|\\u22DB\\uFE00|\\u22F5\\u0338|\\u22F9\\u0338|\\u2933\\u0338|\\u29CF\\u0338|\\u29D0\\u0338|\\u2A6D\\u0338|\\u2A70\\u0338|\\u2A7D\\u0338|\\u2A7E\\u0338|\\u2AA1\\u0338|\\u2AA2\\u0338|\\u2AAC\\uFE00|\\u2AAD\\uFE00|\\u2AAF\\u0338|\\u2AB0\\u0338|\\u2AC5\\u0338|\\u2AC6\\u0338|\\u2ACB\\uFE00|\\u2ACC\\uFE00|\\u2AFD\\u20E5|[\\xA0-\\u0113\\u0116-\\u0122\\u0124-\\u012B\\u012E-\\u014D\\u0150-\\u017E\\u0192\\u01B5\\u01F5\\u0237\\u02C6\\u02C7\\u02D8-\\u02DD\\u0311\\u0391-\\u03A1\\u03A3-\\u03A9\\u03B1-\\u03C9\\u03D1\\u03D2\\u03D5\\u03D6\\u03DC\\u03DD\\u03F0\\u03F1\\u03F5\\u03F6\\u0401-\\u040C\\u040E-\\u044F\\u0451-\\u045C\\u045E\\u045F\\u2002-\\u2005\\u2007-\\u2010\\u2013-\\u2016\\u2018-\\u201A\\u201C-\\u201E\\u2020-\\u2022\\u2025\\u2026\\u2030-\\u2035\\u2039\\u203A\\u203E\\u2041\\u2043\\u2044\\u204F\\u2057\\u205F-\\u2063\\u20AC\\u20DB\\u20DC\\u2102\\u2105\\u210A-\\u2113\\u2115-\\u211E\\u2122\\u2124\\u2127-\\u2129\\u212C\\u212D\\u212F-\\u2131\\u2133-\\u2138\\u2145-\\u2148\\u2153-\\u215E\\u2190-\\u219B\\u219D-\\u21A7\\u21A9-\\u21AE\\u21B0-\\u21B3\\u21B5-\\u21B7\\u21BA-\\u21DB\\u21DD\\u21E4\\u21E5\\u21F5\\u21FD-\\u2205\\u2207-\\u2209\\u220B\\u220C\\u220F-\\u2214\\u2216-\\u2218\\u221A\\u221D-\\u2238\\u223A-\\u2257\\u2259\\u225A\\u225C\\u225F-\\u2262\\u2264-\\u228B\\u228D-\\u229B\\u229D-\\u22A5\\u22A7-\\u22B0\\u22B2-\\u22BB\\u22BD-\\u22DB\\u22DE-\\u22E3\\u22E6-\\u22F7\\u22F9-\\u22FE\\u2305\\u2306\\u2308-\\u2310\\u2312\\u2313\\u2315\\u2316\\u231C-\\u231F\\u2322\\u2323\\u232D\\u232E\\u2336\\u233D\\u233F\\u237C\\u23B0\\u23B1\\u23B4-\\u23B6\\u23DC-\\u23DF\\u23E2\\u23E7\\u2423\\u24C8\\u2500\\u2502\\u250C\\u2510\\u2514\\u2518\\u251C\\u2524\\u252C\\u2534\\u253C\\u2550-\\u256C\\u2580\\u2584\\u2588\\u2591-\\u2593\\u25A1\\u25AA\\u25AB\\u25AD\\u25AE\\u25B1\\u25B3-\\u25B5\\u25B8\\u25B9\\u25BD-\\u25BF\\u25C2\\u25C3\\u25CA\\u25CB\\u25EC\\u25EF\\u25F8-\\u25FC\\u2605\\u2606\\u260E\\u2640\\u2642\\u2660\\u2663\\u2665\\u2666\\u266A\\u266D-\\u266F\\u2713\\u2717\\u2720\\u2736\\u2758\\u2772\\u2773\\u27C8\\u27C9\\u27E6-\\u27ED\\u27F5-\\u27FA\\u27FC\\u27FF\\u2902-\\u2905\\u290C-\\u2913\\u2916\\u2919-\\u2920\\u2923-\\u292A\\u2933\\u2935-\\u2939\\u293C\\u293D\\u2945\\u2948-\\u294B\\u294E-\\u2976\\u2978\\u2979\\u297B-\\u297F\\u2985\\u2986\\u298B-\\u2996\\u299A\\u299C\\u299D\\u29A4-\\u29B7\\u29B9\\u29BB\\u29BC\\u29BE-\\u29C5\\u29C9\\u29CD-\\u29D0\\u29DC-\\u29DE\\u29E3-\\u29E5\\u29EB\\u29F4\\u29F6\\u2A00-\\u2A02\\u2A04\\u2A06\\u2A0C\\u2A0D\\u2A10-\\u2A17\\u2A22-\\u2A27\\u2A29\\u2A2A\\u2A2D-\\u2A31\\u2A33-\\u2A3C\\u2A3F\\u2A40\\u2A42-\\u2A4D\\u2A50\\u2A53-\\u2A58\\u2A5A-\\u2A5D\\u2A5F\\u2A66\\u2A6A\\u2A6D-\\u2A75\\u2A77-\\u2A9A\\u2A9D-\\u2AA2\\u2AA4-\\u2AB0\\u2AB3-\\u2AC8\\u2ACB\\u2ACC\\u2ACF-\\u2ADB\\u2AE4\\u2AE6-\\u2AE9\\u2AEB-\\u2AF3\\u2AFD\\uFB00-\\uFB04]|\\uD835[\\uDC9C\\uDC9E\\uDC9F\\uDCA2\\uDCA5\\uDCA6\\uDCA9-\\uDCAC\\uDCAE-\\uDCB9\\uDCBB\\uDCBD-\\uDCC3\\uDCC5-\\uDCCF\\uDD04\\uDD05\\uDD07-\\uDD0A\\uDD0D-\\uDD14\\uDD16-\\uDD1C\\uDD1E-\\uDD39\\uDD3B-\\uDD3E\\uDD40-\\uDD44\\uDD46\\uDD4A-\\uDD50\\uDD52-\\uDD6B]/g,p={\"\\xad\":\"shy\",\"\\u200c\":\"zwnj\",\"\\u200d\":\"zwj\",\"\\u200e\":\"lrm\",\"\\u2063\":\"ic\",\"\\u2062\":\"it\",\"\\u2061\":\"af\",\"\\u200f\":\"rlm\",\"\\u200b\":\"ZeroWidthSpace\",\"\\u2060\":\"NoBreak\",\"\\u0311\":\"DownBreve\",\"\\u20db\":\"tdot\",\"\\u20dc\":\"DotDot\",\"\\t\":\"Tab\",\"\\n\":\"NewLine\",\"\\u2008\":\"puncsp\",\"\\u205f\":\"MediumSpace\",\"\\u2009\":\"thinsp\",\"\\u200a\":\"hairsp\",\"\\u2004\":\"emsp13\",\"\\u2002\":\"ensp\",\"\\u2005\":\"emsp14\",\"\\u2003\":\"emsp\",\"\\u2007\":\"numsp\",\"\\xa0\":\"nbsp\",\"\\u205f\\u200a\":\"ThickSpace\",\"\\u203e\":\"oline\",_:\"lowbar\",\"\\u2010\":\"dash\",\"\\u2013\":\"ndash\",\"\\u2014\":\"mdash\",\"\\u2015\":\"horbar\",\",\":\"comma\",\";\":\"semi\",\"\\u204f\":\"bsemi\",\":\":\"colon\",\"\\u2a74\":\"Colone\",\"!\":\"excl\",\"\\xa1\":\"iexcl\",\"?\":\"quest\",\"\\xbf\":\"iquest\",\".\":\"period\",\"\\u2025\":\"nldr\",\"\\u2026\":\"mldr\",\"\\xb7\":\"middot\",\"'\":\"apos\",\"\\u2018\":\"lsquo\",\"\\u2019\":\"rsquo\",\"\\u201a\":\"sbquo\",\"\\u2039\":\"lsaquo\",\"\\u203a\":\"rsaquo\",'\"':\"quot\",\"\\u201c\":\"ldquo\",\"\\u201d\":\"rdquo\",\"\\u201e\":\"bdquo\",\"\\xab\":\"laquo\",\"\\xbb\":\"raquo\",\"(\":\"lpar\",\")\":\"rpar\",\"[\":\"lsqb\",\"]\":\"rsqb\",\"{\":\"lcub\",\"}\":\"rcub\",\"\\u2308\":\"lceil\",\"\\u2309\":\"rceil\",\"\\u230a\":\"lfloor\",\"\\u230b\":\"rfloor\",\"\\u2985\":\"lopar\",\"\\u2986\":\"ropar\",\"\\u298b\":\"lbrke\",\"\\u298c\":\"rbrke\",\"\\u298d\":\"lbrkslu\",\"\\u298e\":\"rbrksld\",\"\\u298f\":\"lbrksld\",\"\\u2990\":\"rbrkslu\",\"\\u2991\":\"langd\",\"\\u2992\":\"rangd\",\"\\u2993\":\"lparlt\",\"\\u2994\":\"rpargt\",\"\\u2995\":\"gtlPar\",\"\\u2996\":\"ltrPar\",\"\\u27e6\":\"lobrk\",\"\\u27e7\":\"robrk\",\"\\u27e8\":\"lang\",\"\\u27e9\":\"rang\",\"\\u27ea\":\"Lang\",\"\\u27eb\":\"Rang\",\"\\u27ec\":\"loang\",\"\\u27ed\":\"roang\",\"\\u2772\":\"lbbrk\",\"\\u2773\":\"rbbrk\",\"\\u2016\":\"Vert\",\"\\xa7\":\"sect\",\"\\xb6\":\"para\",\"@\":\"commat\",\"*\":\"ast\",\"/\":\"sol\",undefined:null,\"&\":\"amp\",\"#\":\"num\",\"%\":\"percnt\",\"\\u2030\":\"permil\",\"\\u2031\":\"pertenk\",\"\\u2020\":\"dagger\",\"\\u2021\":\"Dagger\",\"\\u2022\":\"bull\",\"\\u2043\":\"hybull\",\"\\u2032\":\"prime\",\"\\u2033\":\"Prime\",\"\\u2034\":\"tprime\",\"\\u2057\":\"qprime\",\"\\u2035\":\"bprime\",\"\\u2041\":\"caret\",\"`\":\"grave\",\"\\xb4\":\"acute\",\"\\u02dc\":\"tilde\",\"^\":\"Hat\",\"\\xaf\":\"macr\",\"\\u02d8\":\"breve\",\"\\u02d9\":\"dot\",\"\\xa8\":\"die\",\"\\u02da\":\"ring\",\"\\u02dd\":\"dblac\",\"\\xb8\":\"cedil\",\"\\u02db\":\"ogon\",\"\\u02c6\":\"circ\",\"\\u02c7\":\"caron\",\"\\xb0\":\"deg\",\"\\xa9\":\"copy\",\"\\xae\":\"reg\",\"\\u2117\":\"copysr\",\"\\u2118\":\"wp\",\"\\u211e\":\"rx\",\"\\u2127\":\"mho\",\"\\u2129\":\"iiota\",\"\\u2190\":\"larr\",\"\\u219a\":\"nlarr\",\"\\u2192\":\"rarr\",\"\\u219b\":\"nrarr\",\"\\u2191\":\"uarr\",\"\\u2193\":\"darr\",\"\\u2194\":\"harr\",\"\\u21ae\":\"nharr\",\"\\u2195\":\"varr\",\"\\u2196\":\"nwarr\",\"\\u2197\":\"nearr\",\"\\u2198\":\"searr\",\"\\u2199\":\"swarr\",\"\\u219d\":\"rarrw\",\"\\u219d\\u0338\":\"nrarrw\",\"\\u219e\":\"Larr\",\"\\u219f\":\"Uarr\",\"\\u21a0\":\"Rarr\",\"\\u21a1\":\"Darr\",\"\\u21a2\":\"larrtl\",\"\\u21a3\":\"rarrtl\",\"\\u21a4\":\"mapstoleft\",\"\\u21a5\":\"mapstoup\",\"\\u21a6\":\"map\",\"\\u21a7\":\"mapstodown\",\"\\u21a9\":\"larrhk\",\"\\u21aa\":\"rarrhk\",\"\\u21ab\":\"larrlp\",\"\\u21ac\":\"rarrlp\",\"\\u21ad\":\"harrw\",\"\\u21b0\":\"lsh\",\"\\u21b1\":\"rsh\",\"\\u21b2\":\"ldsh\",\"\\u21b3\":\"rdsh\",\"\\u21b5\":\"crarr\",\"\\u21b6\":\"cularr\",\"\\u21b7\":\"curarr\",\"\\u21ba\":\"olarr\",\"\\u21bb\":\"orarr\",\"\\u21bc\":\"lharu\",\"\\u21bd\":\"lhard\",\"\\u21be\":\"uharr\",\"\\u21bf\":\"uharl\",\"\\u21c0\":\"rharu\",\"\\u21c1\":\"rhard\",\"\\u21c2\":\"dharr\",\"\\u21c3\":\"dharl\",\"\\u21c4\":\"rlarr\",\"\\u21c5\":\"udarr\",\"\\u21c6\":\"lrarr\",\"\\u21c7\":\"llarr\",\"\\u21c8\":\"uuarr\",\"\\u21c9\":\"rrarr\",\"\\u21ca\":\"ddarr\",\"\\u21cb\":\"lrhar\",\"\\u21cc\":\"rlhar\",\"\\u21d0\":\"lArr\",\"\\u21cd\":\"nlArr\",\"\\u21d1\":\"uArr\",\"\\u21d2\":\"rArr\",\"\\u21cf\":\"nrArr\",\"\\u21d3\":\"dArr\",\"\\u21d4\":\"iff\",\"\\u21ce\":\"nhArr\",\"\\u21d5\":\"vArr\",\"\\u21d6\":\"nwArr\",\"\\u21d7\":\"neArr\",\"\\u21d8\":\"seArr\",\"\\u21d9\":\"swArr\",\"\\u21da\":\"lAarr\",\"\\u21db\":\"rAarr\",\"\\u21dd\":\"zigrarr\",\"\\u21e4\":\"larrb\",\"\\u21e5\":\"rarrb\",\"\\u21f5\":\"duarr\",\"\\u21fd\":\"loarr\",\"\\u21fe\":\"roarr\",\"\\u21ff\":\"hoarr\",\"\\u2200\":\"forall\",\"\\u2201\":\"comp\",\"\\u2202\":\"part\",\"\\u2202\\u0338\":\"npart\",\"\\u2203\":\"exist\",\"\\u2204\":\"nexist\",\"\\u2205\":\"empty\",\"\\u2207\":\"Del\",\"\\u2208\":\"in\",\"\\u2209\":\"notin\",\"\\u220b\":\"ni\",\"\\u220c\":\"notni\",\"\\u03f6\":\"bepsi\",\"\\u220f\":\"prod\",\"\\u2210\":\"coprod\",\"\\u2211\":\"sum\",\"+\":\"plus\",\"\\xb1\":\"pm\",\"\\xf7\":\"div\",\"\\xd7\":\"times\",\"<\":\"lt\",\"\\u226e\":\"nlt\",\"<\\u20d2\":\"nvlt\",\"=\":\"equals\",\"\\u2260\":\"ne\",\"=\\u20e5\":\"bne\",\"\\u2a75\":\"Equal\",\">\":\"gt\",\"\\u226f\":\"ngt\",\">\\u20d2\":\"nvgt\",\"\\xac\":\"not\",\"|\":\"vert\",\"\\xa6\":\"brvbar\",\"\\u2212\":\"minus\",\"\\u2213\":\"mp\",\"\\u2214\":\"plusdo\",\"\\u2044\":\"frasl\",\"\\u2216\":\"setmn\",\"\\u2217\":\"lowast\",\"\\u2218\":\"compfn\",\"\\u221a\":\"Sqrt\",\"\\u221d\":\"prop\",\"\\u221e\":\"infin\",\"\\u221f\":\"angrt\",\"\\u2220\":\"ang\",\"\\u2220\\u20d2\":\"nang\",\"\\u2221\":\"angmsd\",\"\\u2222\":\"angsph\",\"\\u2223\":\"mid\",\"\\u2224\":\"nmid\",\"\\u2225\":\"par\",\"\\u2226\":\"npar\",\"\\u2227\":\"and\",\"\\u2228\":\"or\",\"\\u2229\":\"cap\",\"\\u2229\\ufe00\":\"caps\",\"\\u222a\":\"cup\",\"\\u222a\\ufe00\":\"cups\",\"\\u222b\":\"int\",\"\\u222c\":\"Int\",\"\\u222d\":\"tint\",\"\\u2a0c\":\"qint\",\"\\u222e\":\"oint\",\"\\u222f\":\"Conint\",\"\\u2230\":\"Cconint\",\"\\u2231\":\"cwint\",\"\\u2232\":\"cwconint\",\"\\u2233\":\"awconint\",\"\\u2234\":\"there4\",\"\\u2235\":\"becaus\",\"\\u2236\":\"ratio\",\"\\u2237\":\"Colon\",\"\\u2238\":\"minusd\",\"\\u223a\":\"mDDot\",\"\\u223b\":\"homtht\",\"\\u223c\":\"sim\",\"\\u2241\":\"nsim\",\"\\u223c\\u20d2\":\"nvsim\",\"\\u223d\":\"bsim\",\"\\u223d\\u0331\":\"race\",\"\\u223e\":\"ac\",\"\\u223e\\u0333\":\"acE\",\"\\u223f\":\"acd\",\"\\u2240\":\"wr\",\"\\u2242\":\"esim\",\"\\u2242\\u0338\":\"nesim\",\"\\u2243\":\"sime\",\"\\u2244\":\"nsime\",\"\\u2245\":\"cong\",\"\\u2247\":\"ncong\",\"\\u2246\":\"simne\",\"\\u2248\":\"ap\",\"\\u2249\":\"nap\",\"\\u224a\":\"ape\",\"\\u224b\":\"apid\",\"\\u224b\\u0338\":\"napid\",\"\\u224c\":\"bcong\",\"\\u224d\":\"CupCap\",\"\\u226d\":\"NotCupCap\",\"\\u224d\\u20d2\":\"nvap\",\"\\u224e\":\"bump\",\"\\u224e\\u0338\":\"nbump\",\"\\u224f\":\"bumpe\",\"\\u224f\\u0338\":\"nbumpe\",\"\\u2250\":\"doteq\",\"\\u2250\\u0338\":\"nedot\",\"\\u2251\":\"eDot\",\"\\u2252\":\"efDot\",\"\\u2253\":\"erDot\",\"\\u2254\":\"colone\",\"\\u2255\":\"ecolon\",\"\\u2256\":\"ecir\",\"\\u2257\":\"cire\",\"\\u2259\":\"wedgeq\",\"\\u225a\":\"veeeq\",\"\\u225c\":\"trie\",\"\\u225f\":\"equest\",\"\\u2261\":\"equiv\",\"\\u2262\":\"nequiv\",\"\\u2261\\u20e5\":\"bnequiv\",\"\\u2264\":\"le\",\"\\u2270\":\"nle\",\"\\u2264\\u20d2\":\"nvle\",\"\\u2265\":\"ge\",\"\\u2271\":\"nge\",\"\\u2265\\u20d2\":\"nvge\",\"\\u2266\":\"lE\",\"\\u2266\\u0338\":\"nlE\",\"\\u2267\":\"gE\",\"\\u2267\\u0338\":\"ngE\",\"\\u2268\\ufe00\":\"lvnE\",\"\\u2268\":\"lnE\",\"\\u2269\":\"gnE\",\"\\u2269\\ufe00\":\"gvnE\",\"\\u226a\":\"ll\",\"\\u226a\\u0338\":\"nLtv\",\"\\u226a\\u20d2\":\"nLt\",\"\\u226b\":\"gg\",\"\\u226b\\u0338\":\"nGtv\",\"\\u226b\\u20d2\":\"nGt\",\"\\u226c\":\"twixt\",\"\\u2272\":\"lsim\",\"\\u2274\":\"nlsim\",\"\\u2273\":\"gsim\",\"\\u2275\":\"ngsim\",\"\\u2276\":\"lg\",\"\\u2278\":\"ntlg\",\"\\u2277\":\"gl\",\"\\u2279\":\"ntgl\",\"\\u227a\":\"pr\",\"\\u2280\":\"npr\",\"\\u227b\":\"sc\",\"\\u2281\":\"nsc\",\"\\u227c\":\"prcue\",\"\\u22e0\":\"nprcue\",\"\\u227d\":\"sccue\",\"\\u22e1\":\"nsccue\",\"\\u227e\":\"prsim\",\"\\u227f\":\"scsim\",\"\\u227f\\u0338\":\"NotSucceedsTilde\",\"\\u2282\":\"sub\",\"\\u2284\":\"nsub\",\"\\u2282\\u20d2\":\"vnsub\",\"\\u2283\":\"sup\",\"\\u2285\":\"nsup\",\"\\u2283\\u20d2\":\"vnsup\",\"\\u2286\":\"sube\",\"\\u2288\":\"nsube\",\"\\u2287\":\"supe\",\"\\u2289\":\"nsupe\",\"\\u228a\\ufe00\":\"vsubne\",\"\\u228a\":\"subne\",\"\\u228b\\ufe00\":\"vsupne\",\"\\u228b\":\"supne\",\"\\u228d\":\"cupdot\",\"\\u228e\":\"uplus\",\"\\u228f\":\"sqsub\",\"\\u228f\\u0338\":\"NotSquareSubset\",\"\\u2290\":\"sqsup\",\"\\u2290\\u0338\":\"NotSquareSuperset\",\"\\u2291\":\"sqsube\",\"\\u22e2\":\"nsqsube\",\"\\u2292\":\"sqsupe\",\"\\u22e3\":\"nsqsupe\",\"\\u2293\":\"sqcap\",\"\\u2293\\ufe00\":\"sqcaps\",\"\\u2294\":\"sqcup\",\"\\u2294\\ufe00\":\"sqcups\",\"\\u2295\":\"oplus\",\"\\u2296\":\"ominus\",\"\\u2297\":\"otimes\",\"\\u2298\":\"osol\",\"\\u2299\":\"odot\",\"\\u229a\":\"ocir\",\"\\u229b\":\"oast\",\"\\u229d\":\"odash\",\"\\u229e\":\"plusb\",\"\\u229f\":\"minusb\",\"\\u22a0\":\"timesb\",\"\\u22a1\":\"sdotb\",\"\\u22a2\":\"vdash\",\"\\u22ac\":\"nvdash\",\"\\u22a3\":\"dashv\",\"\\u22a4\":\"top\",\"\\u22a5\":\"bot\",\"\\u22a7\":\"models\",\"\\u22a8\":\"vDash\",\"\\u22ad\":\"nvDash\",\"\\u22a9\":\"Vdash\",\"\\u22ae\":\"nVdash\",\"\\u22aa\":\"Vvdash\",\"\\u22ab\":\"VDash\",\"\\u22af\":\"nVDash\",\"\\u22b0\":\"prurel\",\"\\u22b2\":\"vltri\",\"\\u22ea\":\"nltri\",\"\\u22b3\":\"vrtri\",\"\\u22eb\":\"nrtri\",\"\\u22b4\":\"ltrie\",\"\\u22ec\":\"nltrie\",\"\\u22b4\\u20d2\":\"nvltrie\",\"\\u22b5\":\"rtrie\",\"\\u22ed\":\"nrtrie\",\"\\u22b5\\u20d2\":\"nvrtrie\",\"\\u22b6\":\"origof\",\"\\u22b7\":\"imof\",\"\\u22b8\":\"mumap\",\"\\u22b9\":\"hercon\",\"\\u22ba\":\"intcal\",\"\\u22bb\":\"veebar\",\"\\u22bd\":\"barvee\",\"\\u22be\":\"angrtvb\",\"\\u22bf\":\"lrtri\",\"\\u22c0\":\"Wedge\",\"\\u22c1\":\"Vee\",\"\\u22c2\":\"xcap\",\"\\u22c3\":\"xcup\",\"\\u22c4\":\"diam\",\"\\u22c5\":\"sdot\",\"\\u22c6\":\"Star\",\"\\u22c7\":\"divonx\",\"\\u22c8\":\"bowtie\",\"\\u22c9\":\"ltimes\",\"\\u22ca\":\"rtimes\",\"\\u22cb\":\"lthree\",\"\\u22cc\":\"rthree\",\"\\u22cd\":\"bsime\",\"\\u22ce\":\"cuvee\",\"\\u22cf\":\"cuwed\",\"\\u22d0\":\"Sub\",\"\\u22d1\":\"Sup\",\"\\u22d2\":\"Cap\",\"\\u22d3\":\"Cup\",\"\\u22d4\":\"fork\",\"\\u22d5\":\"epar\",\"\\u22d6\":\"ltdot\",\"\\u22d7\":\"gtdot\",\"\\u22d8\":\"Ll\",\"\\u22d8\\u0338\":\"nLl\",\"\\u22d9\":\"Gg\",\"\\u22d9\\u0338\":\"nGg\",\"\\u22da\\ufe00\":\"lesg\",\"\\u22da\":\"leg\",\"\\u22db\":\"gel\",\"\\u22db\\ufe00\":\"gesl\",\"\\u22de\":\"cuepr\",\"\\u22df\":\"cuesc\",\"\\u22e6\":\"lnsim\",\"\\u22e7\":\"gnsim\",\"\\u22e8\":\"prnsim\",\"\\u22e9\":\"scnsim\",\"\\u22ee\":\"vellip\",\"\\u22ef\":\"ctdot\",\"\\u22f0\":\"utdot\",\"\\u22f1\":\"dtdot\",\"\\u22f2\":\"disin\",\"\\u22f3\":\"isinsv\",\"\\u22f4\":\"isins\",\"\\u22f5\":\"isindot\",\"\\u22f5\\u0338\":\"notindot\",\"\\u22f6\":\"notinvc\",\"\\u22f7\":\"notinvb\",\"\\u22f9\":\"isinE\",\"\\u22f9\\u0338\":\"notinE\",\"\\u22fa\":\"nisd\",\"\\u22fb\":\"xnis\",\"\\u22fc\":\"nis\",\"\\u22fd\":\"notnivc\",\"\\u22fe\":\"notnivb\",\"\\u2305\":\"barwed\",\"\\u2306\":\"Barwed\",\"\\u230c\":\"drcrop\",\"\\u230d\":\"dlcrop\",\"\\u230e\":\"urcrop\",\"\\u230f\":\"ulcrop\",\"\\u2310\":\"bnot\",\"\\u2312\":\"profline\",\"\\u2313\":\"profsurf\",\"\\u2315\":\"telrec\",\"\\u2316\":\"target\",\"\\u231c\":\"ulcorn\",\"\\u231d\":\"urcorn\",\"\\u231e\":\"dlcorn\",\"\\u231f\":\"drcorn\",\"\\u2322\":\"frown\",\"\\u2323\":\"smile\",\"\\u232d\":\"cylcty\",\"\\u232e\":\"profalar\",\"\\u2336\":\"topbot\",\"\\u233d\":\"ovbar\",\"\\u233f\":\"solbar\",\"\\u237c\":\"angzarr\",\"\\u23b0\":\"lmoust\",\"\\u23b1\":\"rmoust\",\"\\u23b4\":\"tbrk\",\"\\u23b5\":\"bbrk\",\"\\u23b6\":\"bbrktbrk\",\"\\u23dc\":\"OverParenthesis\",\"\\u23dd\":\"UnderParenthesis\",\"\\u23de\":\"OverBrace\",\"\\u23df\":\"UnderBrace\",\"\\u23e2\":\"trpezium\",\"\\u23e7\":\"elinters\",\"\\u2423\":\"blank\",\"\\u2500\":\"boxh\",\"\\u2502\":\"boxv\",\"\\u250c\":\"boxdr\",\"\\u2510\":\"boxdl\",\"\\u2514\":\"boxur\",\"\\u2518\":\"boxul\",\"\\u251c\":\"boxvr\",\"\\u2524\":\"boxvl\",\"\\u252c\":\"boxhd\",\"\\u2534\":\"boxhu\",\"\\u253c\":\"boxvh\",\"\\u2550\":\"boxH\",\"\\u2551\":\"boxV\",\"\\u2552\":\"boxdR\",\"\\u2553\":\"boxDr\",\"\\u2554\":\"boxDR\",\"\\u2555\":\"boxdL\",\"\\u2556\":\"boxDl\",\"\\u2557\":\"boxDL\",\"\\u2558\":\"boxuR\",\"\\u2559\":\"boxUr\",\"\\u255a\":\"boxUR\",\"\\u255b\":\"boxuL\",\"\\u255c\":\"boxUl\",\"\\u255d\":\"boxUL\",\"\\u255e\":\"boxvR\",\"\\u255f\":\"boxVr\",\"\\u2560\":\"boxVR\",\"\\u2561\":\"boxvL\",\"\\u2562\":\"boxVl\",\"\\u2563\":\"boxVL\",\"\\u2564\":\"boxHd\",\"\\u2565\":\"boxhD\",\"\\u2566\":\"boxHD\",\"\\u2567\":\"boxHu\",\"\\u2568\":\"boxhU\",\"\\u2569\":\"boxHU\",\"\\u256a\":\"boxvH\",\"\\u256b\":\"boxVh\",\"\\u256c\":\"boxVH\",\"\\u2580\":\"uhblk\",\"\\u2584\":\"lhblk\",\"\\u2588\":\"block\",\"\\u2591\":\"blk14\",\"\\u2592\":\"blk12\",\"\\u2593\":\"blk34\",\"\\u25a1\":\"squ\",\"\\u25aa\":\"squf\",\"\\u25ab\":\"EmptyVerySmallSquare\",\"\\u25ad\":\"rect\",\"\\u25ae\":\"marker\",\"\\u25b1\":\"fltns\",\"\\u25b3\":\"xutri\",\"\\u25b4\":\"utrif\",\"\\u25b5\":\"utri\",\"\\u25b8\":\"rtrif\",\"\\u25b9\":\"rtri\",\"\\u25bd\":\"xdtri\",\"\\u25be\":\"dtrif\",\"\\u25bf\":\"dtri\",\"\\u25c2\":\"ltrif\",\"\\u25c3\":\"ltri\",\"\\u25ca\":\"loz\",\"\\u25cb\":\"cir\",\"\\u25ec\":\"tridot\",\"\\u25ef\":\"xcirc\",\"\\u25f8\":\"ultri\",\"\\u25f9\":\"urtri\",\"\\u25fa\":\"lltri\",\"\\u25fb\":\"EmptySmallSquare\",\"\\u25fc\":\"FilledSmallSquare\",\"\\u2605\":\"starf\",\"\\u2606\":\"star\",\"\\u260e\":\"phone\",\"\\u2640\":\"female\",\"\\u2642\":\"male\",\"\\u2660\":\"spades\",\"\\u2663\":\"clubs\",\"\\u2665\":\"hearts\",\"\\u2666\":\"diams\",\"\\u266a\":\"sung\",\"\\u2713\":\"check\",\"\\u2717\":\"cross\",\"\\u2720\":\"malt\",\"\\u2736\":\"sext\",\"\\u2758\":\"VerticalSeparator\",\"\\u27c8\":\"bsolhsub\",\"\\u27c9\":\"suphsol\",\"\\u27f5\":\"xlarr\",\"\\u27f6\":\"xrarr\",\"\\u27f7\":\"xharr\",\"\\u27f8\":\"xlArr\",\"\\u27f9\":\"xrArr\",\"\\u27fa\":\"xhArr\",\"\\u27fc\":\"xmap\",\"\\u27ff\":\"dzigrarr\",\"\\u2902\":\"nvlArr\",\"\\u2903\":\"nvrArr\",\"\\u2904\":\"nvHarr\",\"\\u2905\":\"Map\",\"\\u290c\":\"lbarr\",\"\\u290d\":\"rbarr\",\"\\u290e\":\"lBarr\",\"\\u290f\":\"rBarr\",\"\\u2910\":\"RBarr\",\"\\u2911\":\"DDotrahd\",\"\\u2912\":\"UpArrowBar\",\"\\u2913\":\"DownArrowBar\",\"\\u2916\":\"Rarrtl\",\"\\u2919\":\"latail\",\"\\u291a\":\"ratail\",\"\\u291b\":\"lAtail\",\"\\u291c\":\"rAtail\",\"\\u291d\":\"larrfs\",\"\\u291e\":\"rarrfs\",\"\\u291f\":\"larrbfs\",\"\\u2920\":\"rarrbfs\",\"\\u2923\":\"nwarhk\",\"\\u2924\":\"nearhk\",\"\\u2925\":\"searhk\",\"\\u2926\":\"swarhk\",\"\\u2927\":\"nwnear\",\"\\u2928\":\"toea\",\"\\u2929\":\"tosa\",\"\\u292a\":\"swnwar\",\"\\u2933\":\"rarrc\",\"\\u2933\\u0338\":\"nrarrc\",\"\\u2935\":\"cudarrr\",\"\\u2936\":\"ldca\",\"\\u2937\":\"rdca\",\"\\u2938\":\"cudarrl\",\"\\u2939\":\"larrpl\",\"\\u293c\":\"curarrm\",\"\\u293d\":\"cularrp\",\"\\u2945\":\"rarrpl\",\"\\u2948\":\"harrcir\",\"\\u2949\":\"Uarrocir\",\"\\u294a\":\"lurdshar\",\"\\u294b\":\"ldrushar\",\"\\u294e\":\"LeftRightVector\",\"\\u294f\":\"RightUpDownVector\",\"\\u2950\":\"DownLeftRightVector\",\"\\u2951\":\"LeftUpDownVector\",\"\\u2952\":\"LeftVectorBar\",\"\\u2953\":\"RightVectorBar\",\"\\u2954\":\"RightUpVectorBar\",\"\\u2955\":\"RightDownVectorBar\",\"\\u2956\":\"DownLeftVectorBar\",\"\\u2957\":\"DownRightVectorBar\",\"\\u2958\":\"LeftUpVectorBar\",\"\\u2959\":\"LeftDownVectorBar\",\"\\u295a\":\"LeftTeeVector\",\"\\u295b\":\"RightTeeVector\",\"\\u295c\":\"RightUpTeeVector\",\"\\u295d\":\"RightDownTeeVector\",\"\\u295e\":\"DownLeftTeeVector\",\"\\u295f\":\"DownRightTeeVector\",\"\\u2960\":\"LeftUpTeeVector\",\"\\u2961\":\"LeftDownTeeVector\",\"\\u2962\":\"lHar\",\"\\u2963\":\"uHar\",\"\\u2964\":\"rHar\",\"\\u2965\":\"dHar\",\"\\u2966\":\"luruhar\",\"\\u2967\":\"ldrdhar\",\"\\u2968\":\"ruluhar\",\"\\u2969\":\"rdldhar\",\"\\u296a\":\"lharul\",\"\\u296b\":\"llhard\",\"\\u296c\":\"rharul\",\"\\u296d\":\"lrhard\",\"\\u296e\":\"udhar\",\"\\u296f\":\"duhar\",\"\\u2970\":\"RoundImplies\",\"\\u2971\":\"erarr\",\"\\u2972\":\"simrarr\",\"\\u2973\":\"larrsim\",\"\\u2974\":\"rarrsim\",\"\\u2975\":\"rarrap\",\"\\u2976\":\"ltlarr\",\"\\u2978\":\"gtrarr\",\"\\u2979\":\"subrarr\",\"\\u297b\":\"suplarr\",\"\\u297c\":\"lfisht\",\"\\u297d\":\"rfisht\",\"\\u297e\":\"ufisht\",\"\\u297f\":\"dfisht\",\"\\u299a\":\"vzigzag\",\"\\u299c\":\"vangrt\",\"\\u299d\":\"angrtvbd\",\"\\u29a4\":\"ange\",\"\\u29a5\":\"range\",\"\\u29a6\":\"dwangle\",\"\\u29a7\":\"uwangle\",\"\\u29a8\":\"angmsdaa\",\"\\u29a9\":\"angmsdab\",\"\\u29aa\":\"angmsdac\",\"\\u29ab\":\"angmsdad\",\"\\u29ac\":\"angmsdae\",\"\\u29ad\":\"angmsdaf\",\"\\u29ae\":\"angmsdag\",\"\\u29af\":\"angmsdah\",\"\\u29b0\":\"bemptyv\",\"\\u29b1\":\"demptyv\",\"\\u29b2\":\"cemptyv\",\"\\u29b3\":\"raemptyv\",\"\\u29b4\":\"laemptyv\",\"\\u29b5\":\"ohbar\",\"\\u29b6\":\"omid\",\"\\u29b7\":\"opar\",\"\\u29b9\":\"operp\",\"\\u29bb\":\"olcross\",\"\\u29bc\":\"odsold\",\"\\u29be\":\"olcir\",\"\\u29bf\":\"ofcir\",\"\\u29c0\":\"olt\",\"\\u29c1\":\"ogt\",\"\\u29c2\":\"cirscir\",\"\\u29c3\":\"cirE\",\"\\u29c4\":\"solb\",\"\\u29c5\":\"bsolb\",\"\\u29c9\":\"boxbox\",\"\\u29cd\":\"trisb\",\"\\u29ce\":\"rtriltri\",\"\\u29cf\":\"LeftTriangleBar\",\"\\u29cf\\u0338\":\"NotLeftTriangleBar\",\"\\u29d0\":\"RightTriangleBar\",\"\\u29d0\\u0338\":\"NotRightTriangleBar\",\"\\u29dc\":\"iinfin\",\"\\u29dd\":\"infintie\",\"\\u29de\":\"nvinfin\",\"\\u29e3\":\"eparsl\",\"\\u29e4\":\"smeparsl\",\"\\u29e5\":\"eqvparsl\",\"\\u29eb\":\"lozf\",\"\\u29f4\":\"RuleDelayed\",\"\\u29f6\":\"dsol\",\"\\u2a00\":\"xodot\",\"\\u2a01\":\"xoplus\",\"\\u2a02\":\"xotime\",\"\\u2a04\":\"xuplus\",\"\\u2a06\":\"xsqcup\",\"\\u2a0d\":\"fpartint\",\"\\u2a10\":\"cirfnint\",\"\\u2a11\":\"awint\",\"\\u2a12\":\"rppolint\",\"\\u2a13\":\"scpolint\",\"\\u2a14\":\"npolint\",\"\\u2a15\":\"pointint\",\"\\u2a16\":\"quatint\",\"\\u2a17\":\"intlarhk\",\"\\u2a22\":\"pluscir\",\"\\u2a23\":\"plusacir\",\"\\u2a24\":\"simplus\",\"\\u2a25\":\"plusdu\",\"\\u2a26\":\"plussim\",\"\\u2a27\":\"plustwo\",\"\\u2a29\":\"mcomma\",\"\\u2a2a\":\"minusdu\",\"\\u2a2d\":\"loplus\",\"\\u2a2e\":\"roplus\",\"\\u2a2f\":\"Cross\",\"\\u2a30\":\"timesd\",\"\\u2a31\":\"timesbar\",\"\\u2a33\":\"smashp\",\"\\u2a34\":\"lotimes\",\"\\u2a35\":\"rotimes\",\"\\u2a36\":\"otimesas\",\"\\u2a37\":\"Otimes\",\"\\u2a38\":\"odiv\",\"\\u2a39\":\"triplus\",\"\\u2a3a\":\"triminus\",\"\\u2a3b\":\"tritime\",\"\\u2a3c\":\"iprod\",\"\\u2a3f\":\"amalg\",\"\\u2a40\":\"capdot\",\"\\u2a42\":\"ncup\",\"\\u2a43\":\"ncap\",\"\\u2a44\":\"capand\",\"\\u2a45\":\"cupor\",\"\\u2a46\":\"cupcap\",\"\\u2a47\":\"capcup\",\"\\u2a48\":\"cupbrcap\",\"\\u2a49\":\"capbrcup\",\"\\u2a4a\":\"cupcup\",\"\\u2a4b\":\"capcap\",\"\\u2a4c\":\"ccups\",\"\\u2a4d\":\"ccaps\",\"\\u2a50\":\"ccupssm\",\"\\u2a53\":\"And\",\"\\u2a54\":\"Or\",\"\\u2a55\":\"andand\",\"\\u2a56\":\"oror\",\"\\u2a57\":\"orslope\",\"\\u2a58\":\"andslope\",\"\\u2a5a\":\"andv\",\"\\u2a5b\":\"orv\",\"\\u2a5c\":\"andd\",\"\\u2a5d\":\"ord\",\"\\u2a5f\":\"wedbar\",\"\\u2a66\":\"sdote\",\"\\u2a6a\":\"simdot\",\"\\u2a6d\":\"congdot\",\"\\u2a6d\\u0338\":\"ncongdot\",\"\\u2a6e\":\"easter\",\"\\u2a6f\":\"apacir\",\"\\u2a70\":\"apE\",\"\\u2a70\\u0338\":\"napE\",\"\\u2a71\":\"eplus\",\"\\u2a72\":\"pluse\",\"\\u2a73\":\"Esim\",\"\\u2a77\":\"eDDot\",\"\\u2a78\":\"equivDD\",\"\\u2a79\":\"ltcir\",\"\\u2a7a\":\"gtcir\",\"\\u2a7b\":\"ltquest\",\"\\u2a7c\":\"gtquest\",\"\\u2a7d\":\"les\",\"\\u2a7d\\u0338\":\"nles\",\"\\u2a7e\":\"ges\",\"\\u2a7e\\u0338\":\"nges\",\"\\u2a7f\":\"lesdot\",\"\\u2a80\":\"gesdot\",\"\\u2a81\":\"lesdoto\",\"\\u2a82\":\"gesdoto\",\"\\u2a83\":\"lesdotor\",\"\\u2a84\":\"gesdotol\",\"\\u2a85\":\"lap\",\"\\u2a86\":\"gap\",\"\\u2a87\":\"lne\",\"\\u2a88\":\"gne\",\"\\u2a89\":\"lnap\",\"\\u2a8a\":\"gnap\",\"\\u2a8b\":\"lEg\",\"\\u2a8c\":\"gEl\",\"\\u2a8d\":\"lsime\",\"\\u2a8e\":\"gsime\",\"\\u2a8f\":\"lsimg\",\"\\u2a90\":\"gsiml\",\"\\u2a91\":\"lgE\",\"\\u2a92\":\"glE\",\"\\u2a93\":\"lesges\",\"\\u2a94\":\"gesles\",\"\\u2a95\":\"els\",\"\\u2a96\":\"egs\",\"\\u2a97\":\"elsdot\",\"\\u2a98\":\"egsdot\",\"\\u2a99\":\"el\",\"\\u2a9a\":\"eg\",\"\\u2a9d\":\"siml\",\"\\u2a9e\":\"simg\",\"\\u2a9f\":\"simlE\",\"\\u2aa0\":\"simgE\",\"\\u2aa1\":\"LessLess\",\"\\u2aa1\\u0338\":\"NotNestedLessLess\",\"\\u2aa2\":\"GreaterGreater\",\"\\u2aa2\\u0338\":\"NotNestedGreaterGreater\",\"\\u2aa4\":\"glj\",\"\\u2aa5\":\"gla\",\"\\u2aa6\":\"ltcc\",\"\\u2aa7\":\"gtcc\",\"\\u2aa8\":\"lescc\",\"\\u2aa9\":\"gescc\",\"\\u2aaa\":\"smt\",\"\\u2aab\":\"lat\",\"\\u2aac\":\"smte\",\"\\u2aac\\ufe00\":\"smtes\",\"\\u2aad\":\"late\",\"\\u2aad\\ufe00\":\"lates\",\"\\u2aae\":\"bumpE\",\"\\u2aaf\":\"pre\",\"\\u2aaf\\u0338\":\"npre\",\"\\u2ab0\":\"sce\",\"\\u2ab0\\u0338\":\"nsce\",\"\\u2ab3\":\"prE\",\"\\u2ab4\":\"scE\",\"\\u2ab5\":\"prnE\",\"\\u2ab6\":\"scnE\",\"\\u2ab7\":\"prap\",\"\\u2ab8\":\"scap\",\"\\u2ab9\":\"prnap\",\"\\u2aba\":\"scnap\",\"\\u2abb\":\"Pr\",\"\\u2abc\":\"Sc\",\"\\u2abd\":\"subdot\",\"\\u2abe\":\"supdot\",\"\\u2abf\":\"subplus\",\"\\u2ac0\":\"supplus\",\"\\u2ac1\":\"submult\",\"\\u2ac2\":\"supmult\",\"\\u2ac3\":\"subedot\",\"\\u2ac4\":\"supedot\",\"\\u2ac5\":\"subE\",\"\\u2ac5\\u0338\":\"nsubE\",\"\\u2ac6\":\"supE\",\"\\u2ac6\\u0338\":\"nsupE\",\"\\u2ac7\":\"subsim\",\"\\u2ac8\":\"supsim\",\"\\u2acb\\ufe00\":\"vsubnE\",\"\\u2acb\":\"subnE\",\"\\u2acc\\ufe00\":\"vsupnE\",\"\\u2acc\":\"supnE\",\"\\u2acf\":\"csub\",\"\\u2ad0\":\"csup\",\"\\u2ad1\":\"csube\",\"\\u2ad2\":\"csupe\",\"\\u2ad3\":\"subsup\",\"\\u2ad4\":\"supsub\",\"\\u2ad5\":\"subsub\",\"\\u2ad6\":\"supsup\",\"\\u2ad7\":\"suphsub\",\"\\u2ad8\":\"supdsub\",\"\\u2ad9\":\"forkv\",\"\\u2ada\":\"topfork\",\"\\u2adb\":\"mlcp\",\"\\u2ae4\":\"Dashv\",\"\\u2ae6\":\"Vdashl\",\"\\u2ae7\":\"Barv\",\"\\u2ae8\":\"vBar\",\"\\u2ae9\":\"vBarv\",\"\\u2aeb\":\"Vbar\",\"\\u2aec\":\"Not\",\"\\u2aed\":\"bNot\",\"\\u2aee\":\"rnmid\",\"\\u2aef\":\"cirmid\",\"\\u2af0\":\"midcir\",\"\\u2af1\":\"topcir\",\"\\u2af2\":\"nhpar\",\"\\u2af3\":\"parsim\",\"\\u2afd\":\"parsl\",\"\\u2afd\\u20e5\":\"nparsl\",\"\\u266d\":\"flat\",\"\\u266e\":\"natur\",\"\\u266f\":\"sharp\",\"\\xa4\":\"curren\",\"\\xa2\":\"cent\",$:\"dollar\",\"\\xa3\":\"pound\",\"\\xa5\":\"yen\",\"\\u20ac\":\"euro\",\"\\xb9\":\"sup1\",\"\\xbd\":\"half\",\"\\u2153\":\"frac13\",\"\\xbc\":\"frac14\",\"\\u2155\":\"frac15\",\"\\u2159\":\"frac16\",\"\\u215b\":\"frac18\",\"\\xb2\":\"sup2\",\"\\u2154\":\"frac23\",\"\\u2156\":\"frac25\",\"\\xb3\":\"sup3\",\"\\xbe\":\"frac34\",\"\\u2157\":\"frac35\",\"\\u215c\":\"frac38\",\"\\u2158\":\"frac45\",\"\\u215a\":\"frac56\",\"\\u215d\":\"frac58\",\"\\u215e\":\"frac78\",\"\\ud835\\udcb6\":\"ascr\",\"\\ud835\\udd52\":\"aopf\",\"\\ud835\\udd1e\":\"afr\",\"\\ud835\\udd38\":\"Aopf\",\"\\ud835\\udd04\":\"Afr\",\"\\ud835\\udc9c\":\"Ascr\",\"\\xaa\":\"ordf\",\"\\xe1\":\"aacute\",\"\\xc1\":\"Aacute\",\"\\xe0\":\"agrave\",\"\\xc0\":\"Agrave\",\"\\u0103\":\"abreve\",\"\\u0102\":\"Abreve\",\"\\xe2\":\"acirc\",\"\\xc2\":\"Acirc\",\"\\xe5\":\"aring\",\"\\xc5\":\"angst\",\"\\xe4\":\"auml\",\"\\xc4\":\"Auml\",\"\\xe3\":\"atilde\",\"\\xc3\":\"Atilde\",\"\\u0105\":\"aogon\",\"\\u0104\":\"Aogon\",\"\\u0101\":\"amacr\",\"\\u0100\":\"Amacr\",\"\\xe6\":\"aelig\",\"\\xc6\":\"AElig\",\"\\ud835\\udcb7\":\"bscr\",\"\\ud835\\udd53\":\"bopf\",\"\\ud835\\udd1f\":\"bfr\",\"\\ud835\\udd39\":\"Bopf\",\"\\u212c\":\"Bscr\",\"\\ud835\\udd05\":\"Bfr\",\"\\ud835\\udd20\":\"cfr\",\"\\ud835\\udcb8\":\"cscr\",\"\\ud835\\udd54\":\"copf\",\"\\u212d\":\"Cfr\",\"\\ud835\\udc9e\":\"Cscr\",\"\\u2102\":\"Copf\",\"\\u0107\":\"cacute\",\"\\u0106\":\"Cacute\",\"\\u0109\":\"ccirc\",\"\\u0108\":\"Ccirc\",\"\\u010d\":\"ccaron\",\"\\u010c\":\"Ccaron\",\"\\u010b\":\"cdot\",\"\\u010a\":\"Cdot\",\"\\xe7\":\"ccedil\",\"\\xc7\":\"Ccedil\",\"\\u2105\":\"incare\",\"\\ud835\\udd21\":\"dfr\",\"\\u2146\":\"dd\",\"\\ud835\\udd55\":\"dopf\",\"\\ud835\\udcb9\":\"dscr\",\"\\ud835\\udc9f\":\"Dscr\",\"\\ud835\\udd07\":\"Dfr\",\"\\u2145\":\"DD\",\"\\ud835\\udd3b\":\"Dopf\",\"\\u010f\":\"dcaron\",\"\\u010e\":\"Dcaron\",\"\\u0111\":\"dstrok\",\"\\u0110\":\"Dstrok\",\"\\xf0\":\"eth\",\"\\xd0\":\"ETH\",\"\\u2147\":\"ee\",\"\\u212f\":\"escr\",\"\\ud835\\udd22\":\"efr\",\"\\ud835\\udd56\":\"eopf\",\"\\u2130\":\"Escr\",\"\\ud835\\udd08\":\"Efr\",\"\\ud835\\udd3c\":\"Eopf\",\"\\xe9\":\"eacute\",\"\\xc9\":\"Eacute\",\"\\xe8\":\"egrave\",\"\\xc8\":\"Egrave\",\"\\xea\":\"ecirc\",\"\\xca\":\"Ecirc\",\"\\u011b\":\"ecaron\",\"\\u011a\":\"Ecaron\",\"\\xeb\":\"euml\",\"\\xcb\":\"Euml\",\"\\u0117\":\"edot\",\"\\u0116\":\"Edot\",\"\\u0119\":\"eogon\",\"\\u0118\":\"Eogon\",\"\\u0113\":\"emacr\",\"\\u0112\":\"Emacr\",\"\\ud835\\udd23\":\"ffr\",\"\\ud835\\udd57\":\"fopf\",\"\\ud835\\udcbb\":\"fscr\",\"\\ud835\\udd09\":\"Ffr\",\"\\ud835\\udd3d\":\"Fopf\",\"\\u2131\":\"Fscr\",\"\\ufb00\":\"fflig\",\"\\ufb03\":\"ffilig\",\"\\ufb04\":\"ffllig\",\"\\ufb01\":\"filig\",fj:\"fjlig\",\"\\ufb02\":\"fllig\",\"\\u0192\":\"fnof\",\"\\u210a\":\"gscr\",\"\\ud835\\udd58\":\"gopf\",\"\\ud835\\udd24\":\"gfr\",\"\\ud835\\udca2\":\"Gscr\",\"\\ud835\\udd3e\":\"Gopf\",\"\\ud835\\udd0a\":\"Gfr\",\"\\u01f5\":\"gacute\",\"\\u011f\":\"gbreve\",\"\\u011e\":\"Gbreve\",\"\\u011d\":\"gcirc\",\"\\u011c\":\"Gcirc\",\"\\u0121\":\"gdot\",\"\\u0120\":\"Gdot\",\"\\u0122\":\"Gcedil\",\"\\ud835\\udd25\":\"hfr\",\"\\u210e\":\"planckh\",\"\\ud835\\udcbd\":\"hscr\",\"\\ud835\\udd59\":\"hopf\",\"\\u210b\":\"Hscr\",\"\\u210c\":\"Hfr\",\"\\u210d\":\"Hopf\",\"\\u0125\":\"hcirc\",\"\\u0124\":\"Hcirc\",\"\\u210f\":\"hbar\",\"\\u0127\":\"hstrok\",\"\\u0126\":\"Hstrok\",\"\\ud835\\udd5a\":\"iopf\",\"\\ud835\\udd26\":\"ifr\",\"\\ud835\\udcbe\":\"iscr\",\"\\u2148\":\"ii\",\"\\ud835\\udd40\":\"Iopf\",\"\\u2110\":\"Iscr\",\"\\u2111\":\"Im\",\"\\xed\":\"iacute\",\"\\xcd\":\"Iacute\",\"\\xec\":\"igrave\",\"\\xcc\":\"Igrave\",\"\\xee\":\"icirc\",\"\\xce\":\"Icirc\",\"\\xef\":\"iuml\",\"\\xcf\":\"Iuml\",\"\\u0129\":\"itilde\",\"\\u0128\":\"Itilde\",\"\\u0130\":\"Idot\",\"\\u012f\":\"iogon\",\"\\u012e\":\"Iogon\",\"\\u012b\":\"imacr\",\"\\u012a\":\"Imacr\",\"\\u0133\":\"ijlig\",\"\\u0132\":\"IJlig\",\"\\u0131\":\"imath\",\"\\ud835\\udcbf\":\"jscr\",\"\\ud835\\udd5b\":\"jopf\",\"\\ud835\\udd27\":\"jfr\",\"\\ud835\\udca5\":\"Jscr\",\"\\ud835\\udd0d\":\"Jfr\",\"\\ud835\\udd41\":\"Jopf\",\"\\u0135\":\"jcirc\",\"\\u0134\":\"Jcirc\",\"\\u0237\":\"jmath\",\"\\ud835\\udd5c\":\"kopf\",\"\\ud835\\udcc0\":\"kscr\",\"\\ud835\\udd28\":\"kfr\",\"\\ud835\\udca6\":\"Kscr\",\"\\ud835\\udd42\":\"Kopf\",\"\\ud835\\udd0e\":\"Kfr\",\"\\u0137\":\"kcedil\",\"\\u0136\":\"Kcedil\",\"\\ud835\\udd29\":\"lfr\",\"\\ud835\\udcc1\":\"lscr\",\"\\u2113\":\"ell\",\"\\ud835\\udd5d\":\"lopf\",\"\\u2112\":\"Lscr\",\"\\ud835\\udd0f\":\"Lfr\",\"\\ud835\\udd43\":\"Lopf\",\"\\u013a\":\"lacute\",\"\\u0139\":\"Lacute\",\"\\u013e\":\"lcaron\",\"\\u013d\":\"Lcaron\",\"\\u013c\":\"lcedil\",\"\\u013b\":\"Lcedil\",\"\\u0142\":\"lstrok\",\"\\u0141\":\"Lstrok\",\"\\u0140\":\"lmidot\",\"\\u013f\":\"Lmidot\",\"\\ud835\\udd2a\":\"mfr\",\"\\ud835\\udd5e\":\"mopf\",\"\\ud835\\udcc2\":\"mscr\",\"\\ud835\\udd10\":\"Mfr\",\"\\ud835\\udd44\":\"Mopf\",\"\\u2133\":\"Mscr\",\"\\ud835\\udd2b\":\"nfr\",\"\\ud835\\udd5f\":\"nopf\",\"\\ud835\\udcc3\":\"nscr\",\"\\u2115\":\"Nopf\",\"\\ud835\\udca9\":\"Nscr\",\"\\ud835\\udd11\":\"Nfr\",\"\\u0144\":\"nacute\",\"\\u0143\":\"Nacute\",\"\\u0148\":\"ncaron\",\"\\u0147\":\"Ncaron\",\"\\xf1\":\"ntilde\",\"\\xd1\":\"Ntilde\",\"\\u0146\":\"ncedil\",\"\\u0145\":\"Ncedil\",\"\\u2116\":\"numero\",\"\\u014b\":\"eng\",\"\\u014a\":\"ENG\",\"\\ud835\\udd60\":\"oopf\",\"\\ud835\\udd2c\":\"ofr\",\"\\u2134\":\"oscr\",\"\\ud835\\udcaa\":\"Oscr\",\"\\ud835\\udd12\":\"Ofr\",\"\\ud835\\udd46\":\"Oopf\",\"\\xba\":\"ordm\",\"\\xf3\":\"oacute\",\"\\xd3\":\"Oacute\",\"\\xf2\":\"ograve\",\"\\xd2\":\"Ograve\",\"\\xf4\":\"ocirc\",\"\\xd4\":\"Ocirc\",\"\\xf6\":\"ouml\",\"\\xd6\":\"Ouml\",\"\\u0151\":\"odblac\",\"\\u0150\":\"Odblac\",\"\\xf5\":\"otilde\",\"\\xd5\":\"Otilde\",\"\\xf8\":\"oslash\",\"\\xd8\":\"Oslash\",\"\\u014d\":\"omacr\",\"\\u014c\":\"Omacr\",\"\\u0153\":\"oelig\",\"\\u0152\":\"OElig\",\"\\ud835\\udd2d\":\"pfr\",\"\\ud835\\udcc5\":\"pscr\",\"\\ud835\\udd61\":\"popf\",\"\\u2119\":\"Popf\",\"\\ud835\\udd13\":\"Pfr\",\"\\ud835\\udcab\":\"Pscr\",\"\\ud835\\udd62\":\"qopf\",\"\\ud835\\udd2e\":\"qfr\",\"\\ud835\\udcc6\":\"qscr\",\"\\ud835\\udcac\":\"Qscr\",\"\\ud835\\udd14\":\"Qfr\",\"\\u211a\":\"Qopf\",\"\\u0138\":\"kgreen\",\"\\ud835\\udd2f\":\"rfr\",\"\\ud835\\udd63\":\"ropf\",\"\\ud835\\udcc7\":\"rscr\",\"\\u211b\":\"Rscr\",\"\\u211c\":\"Re\",\"\\u211d\":\"Ropf\",\"\\u0155\":\"racute\",\"\\u0154\":\"Racute\",\"\\u0159\":\"rcaron\",\"\\u0158\":\"Rcaron\",\"\\u0157\":\"rcedil\",\"\\u0156\":\"Rcedil\",\"\\ud835\\udd64\":\"sopf\",\"\\ud835\\udcc8\":\"sscr\",\"\\ud835\\udd30\":\"sfr\",\"\\ud835\\udd4a\":\"Sopf\",\"\\ud835\\udd16\":\"Sfr\",\"\\ud835\\udcae\":\"Sscr\",\"\\u24c8\":\"oS\",\"\\u015b\":\"sacute\",\"\\u015a\":\"Sacute\",\"\\u015d\":\"scirc\",\"\\u015c\":\"Scirc\",\"\\u0161\":\"scaron\",\"\\u0160\":\"Scaron\",\"\\u015f\":\"scedil\",\"\\u015e\":\"Scedil\",\"\\xdf\":\"szlig\",\"\\ud835\\udd31\":\"tfr\",\"\\ud835\\udcc9\":\"tscr\",\"\\ud835\\udd65\":\"topf\",\"\\ud835\\udcaf\":\"Tscr\",\"\\ud835\\udd17\":\"Tfr\",\"\\ud835\\udd4b\":\"Topf\",\"\\u0165\":\"tcaron\",\"\\u0164\":\"Tcaron\",\"\\u0163\":\"tcedil\",\"\\u0162\":\"Tcedil\",\"\\u2122\":\"trade\",\"\\u0167\":\"tstrok\",\"\\u0166\":\"Tstrok\",\"\\ud835\\udcca\":\"uscr\",\"\\ud835\\udd66\":\"uopf\",\"\\ud835\\udd32\":\"ufr\",\"\\ud835\\udd4c\":\"Uopf\",\"\\ud835\\udd18\":\"Ufr\",\"\\ud835\\udcb0\":\"Uscr\",\"\\xfa\":\"uacute\",\"\\xda\":\"Uacute\",\"\\xf9\":\"ugrave\",\"\\xd9\":\"Ugrave\",\"\\u016d\":\"ubreve\",\"\\u016c\":\"Ubreve\",\"\\xfb\":\"ucirc\",\"\\xdb\":\"Ucirc\",\"\\u016f\":\"uring\",\"\\u016e\":\"Uring\",\"\\xfc\":\"uuml\",\"\\xdc\":\"Uuml\",\"\\u0171\":\"udblac\",\"\\u0170\":\"Udblac\",\"\\u0169\":\"utilde\",\"\\u0168\":\"Utilde\",\"\\u0173\":\"uogon\",\"\\u0172\":\"Uogon\",\"\\u016b\":\"umacr\",\"\\u016a\":\"Umacr\",\"\\ud835\\udd33\":\"vfr\",\"\\ud835\\udd67\":\"vopf\",\"\\ud835\\udccb\":\"vscr\",\"\\ud835\\udd19\":\"Vfr\",\"\\ud835\\udd4d\":\"Vopf\",\"\\ud835\\udcb1\":\"Vscr\",\"\\ud835\\udd68\":\"wopf\",\"\\ud835\\udccc\":\"wscr\",\"\\ud835\\udd34\":\"wfr\",\"\\ud835\\udcb2\":\"Wscr\",\"\\ud835\\udd4e\":\"Wopf\",\"\\ud835\\udd1a\":\"Wfr\",\"\\u0175\":\"wcirc\",\"\\u0174\":\"Wcirc\",\"\\ud835\\udd35\":\"xfr\",\"\\ud835\\udccd\":\"xscr\",\"\\ud835\\udd69\":\"xopf\",\"\\ud835\\udd4f\":\"Xopf\",\"\\ud835\\udd1b\":\"Xfr\",\"\\ud835\\udcb3\":\"Xscr\",\"\\ud835\\udd36\":\"yfr\",\"\\ud835\\udcce\":\"yscr\",\"\\ud835\\udd6a\":\"yopf\",\"\\ud835\\udcb4\":\"Yscr\",\"\\ud835\\udd1c\":\"Yfr\",\"\\ud835\\udd50\":\"Yopf\",\"\\xfd\":\"yacute\",\"\\xdd\":\"Yacute\",\"\\u0177\":\"ycirc\",\"\\u0176\":\"Ycirc\",\"\\xff\":\"yuml\",\"\\u0178\":\"Yuml\",\"\\ud835\\udccf\":\"zscr\",\"\\ud835\\udd37\":\"zfr\",\"\\ud835\\udd6b\":\"zopf\",\"\\u2128\":\"Zfr\",\"\\u2124\":\"Zopf\",\"\\ud835\\udcb5\":\"Zscr\",\"\\u017a\":\"zacute\",\"\\u0179\":\"Zacute\",\"\\u017e\":\"zcaron\",\"\\u017d\":\"Zcaron\",\"\\u017c\":\"zdot\",\"\\u017b\":\"Zdot\",\"\\u01b5\":\"imped\",\"\\xfe\":\"thorn\",\"\\xde\":\"THORN\",\"\\u0149\":\"napos\",\"\\u03b1\":\"alpha\",\"\\u0391\":\"Alpha\",\"\\u03b2\":\"beta\",\"\\u0392\":\"Beta\",\"\\u03b3\":\"gamma\",\"\\u0393\":\"Gamma\",\"\\u03b4\":\"delta\",\"\\u0394\":\"Delta\",\"\\u03b5\":\"epsi\",\"\\u03f5\":\"epsiv\",\"\\u0395\":\"Epsilon\",\"\\u03dd\":\"gammad\",\"\\u03dc\":\"Gammad\",\"\\u03b6\":\"zeta\",\"\\u0396\":\"Zeta\",\"\\u03b7\":\"eta\",\"\\u0397\":\"Eta\",\"\\u03b8\":\"theta\",\"\\u03d1\":\"thetav\",\"\\u0398\":\"Theta\",\"\\u03b9\":\"iota\",\"\\u0399\":\"Iota\",\"\\u03ba\":\"kappa\",\"\\u03f0\":\"kappav\",\"\\u039a\":\"Kappa\",\"\\u03bb\":\"lambda\",\"\\u039b\":\"Lambda\",\"\\u03bc\":\"mu\",\"\\xb5\":\"micro\",\"\\u039c\":\"Mu\",\"\\u03bd\":\"nu\",\"\\u039d\":\"Nu\",\"\\u03be\":\"xi\",\"\\u039e\":\"Xi\",\"\\u03bf\":\"omicron\",\"\\u039f\":\"Omicron\",\"\\u03c0\":\"pi\",\"\\u03d6\":\"piv\",\"\\u03a0\":\"Pi\",\"\\u03c1\":\"rho\",\"\\u03f1\":\"rhov\",\"\\u03a1\":\"Rho\",\"\\u03c3\":\"sigma\",\"\\u03a3\":\"Sigma\",\"\\u03c2\":\"sigmaf\",\"\\u03c4\":\"tau\",\"\\u03a4\":\"Tau\",\"\\u03c5\":\"upsi\",\"\\u03a5\":\"Upsilon\",\"\\u03d2\":\"Upsi\",\"\\u03c6\":\"phi\",\"\\u03d5\":\"phiv\",\"\\u03a6\":\"Phi\",\"\\u03c7\":\"chi\",\"\\u03a7\":\"Chi\",\"\\u03c8\":\"psi\",\"\\u03a8\":\"Psi\",\"\\u03c9\":\"omega\",\"\\u03a9\":\"ohm\",\"\\u0430\":\"acy\",\"\\u0410\":\"Acy\",\"\\u0431\":\"bcy\",\"\\u0411\":\"Bcy\",\"\\u0432\":\"vcy\",\"\\u0412\":\"Vcy\",\"\\u0433\":\"gcy\",\"\\u0413\":\"Gcy\",\"\\u0453\":\"gjcy\",\"\\u0403\":\"GJcy\",\"\\u0434\":\"dcy\",\"\\u0414\":\"Dcy\",\"\\u0452\":\"djcy\",\"\\u0402\":\"DJcy\",\"\\u0435\":\"iecy\",\"\\u0415\":\"IEcy\",\"\\u0451\":\"iocy\",\"\\u0401\":\"IOcy\",\"\\u0454\":\"jukcy\",\"\\u0404\":\"Jukcy\",\"\\u0436\":\"zhcy\",\"\\u0416\":\"ZHcy\",\"\\u0437\":\"zcy\",\"\\u0417\":\"Zcy\",\"\\u0455\":\"dscy\",\"\\u0405\":\"DScy\",\"\\u0438\":\"icy\",\"\\u0418\":\"Icy\",\"\\u0456\":\"iukcy\",\"\\u0406\":\"Iukcy\",\"\\u0457\":\"yicy\",\"\\u0407\":\"YIcy\",\"\\u0439\":\"jcy\",\"\\u0419\":\"Jcy\",\"\\u0458\":\"jsercy\",\"\\u0408\":\"Jsercy\",\"\\u043a\":\"kcy\",\"\\u041a\":\"Kcy\",\"\\u045c\":\"kjcy\",\"\\u040c\":\"KJcy\",\"\\u043b\":\"lcy\",\"\\u041b\":\"Lcy\",\"\\u0459\":\"ljcy\",\"\\u0409\":\"LJcy\",\"\\u043c\":\"mcy\",\"\\u041c\":\"Mcy\",\"\\u043d\":\"ncy\",\"\\u041d\":\"Ncy\",\"\\u045a\":\"njcy\",\"\\u040a\":\"NJcy\",\"\\u043e\":\"ocy\",\"\\u041e\":\"Ocy\",\"\\u043f\":\"pcy\",\"\\u041f\":\"Pcy\",\"\\u0440\":\"rcy\",\"\\u0420\":\"Rcy\",\"\\u0441\":\"scy\",\"\\u0421\":\"Scy\",\"\\u0442\":\"tcy\",\"\\u0422\":\"Tcy\",\"\\u045b\":\"tshcy\",\"\\u040b\":\"TSHcy\",\"\\u0443\":\"ucy\",\"\\u0423\":\"Ucy\",\"\\u045e\":\"ubrcy\",\"\\u040e\":\"Ubrcy\",\"\\u0444\":\"fcy\",\"\\u0424\":\"Fcy\",\"\\u0445\":\"khcy\",\"\\u0425\":\"KHcy\",\"\\u0446\":\"tscy\",\"\\u0426\":\"TScy\",\"\\u0447\":\"chcy\",\"\\u0427\":\"CHcy\",\"\\u045f\":\"dzcy\",\"\\u040f\":\"DZcy\",\"\\u0448\":\"shcy\",\"\\u0428\":\"SHcy\",\"\\u0449\":\"shchcy\",\"\\u0429\":\"SHCHcy\",\"\\u044a\":\"hardcy\",\"\\u042a\":\"HARDcy\",\"\\u044b\":\"ycy\",\"\\u042b\":\"Ycy\",\"\\u044c\":\"softcy\",\"\\u042c\":\"SOFTcy\",\"\\u044d\":\"ecy\",\"\\u042d\":\"Ecy\",\"\\u044e\":\"yucy\",\"\\u042e\":\"YUcy\",\"\\u044f\":\"yacy\",\"\\u042f\":\"YAcy\",\"\\u2135\":\"aleph\",\"\\u2136\":\"beth\",\"\\u2137\":\"gimel\",\"\\u2138\":\"daleth\"},d=/[\"&'<>`]/g,h={'\"':\"&quot;\",\"&\":\"&amp;\",\"'\":\"&#x27;\",\"<\":\"&lt;\",\">\":\"&gt;\",\"`\":\"&#x60;\"},g=/&#(?:[xX][^a-fA-F0-9]|[^0-9xX])/,m=/[\\0-\\x08\\x0B\\x0E-\\x1F\\x7F-\\x9F\\uFDD0-\\uFDEF\\uFFFE\\uFFFF]|[\\uD83F\\uD87F\\uD8BF\\uD8FF\\uD93F\\uD97F\\uD9BF\\uD9FF\\uDA3F\\uDA7F\\uDABF\\uDAFF\\uDB3F\\uDB7F\\uDBBF\\uDBFF][\\uDFFE\\uDFFF]|[\\uD800-\\uDBFF](?![\\uDC00-\\uDFFF])|(?:[^\\uD800-\\uDBFF]|^)[\\uDC00-\\uDFFF]/,v=/&(CounterClockwiseContourIntegral|DoubleLongLeftRightArrow|ClockwiseContourIntegral|NotNestedGreaterGreater|NotSquareSupersetEqual|DiacriticalDoubleAcute|NotRightTriangleEqual|NotSucceedsSlantEqual|NotPrecedesSlantEqual|CloseCurlyDoubleQuote|NegativeVeryThinSpace|DoubleContourIntegral|FilledVerySmallSquare|CapitalDifferentialD|OpenCurlyDoubleQuote|EmptyVerySmallSquare|NestedGreaterGreater|DoubleLongRightArrow|NotLeftTriangleEqual|NotGreaterSlantEqual|ReverseUpEquilibrium|DoubleLeftRightArrow|NotSquareSubsetEqual|NotDoubleVerticalBar|RightArrowLeftArrow|NotGreaterFullEqual|NotRightTriangleBar|SquareSupersetEqual|DownLeftRightVector|DoubleLongLeftArrow|leftrightsquigarrow|LeftArrowRightArrow|NegativeMediumSpace|blacktriangleright|RightDownVectorBar|PrecedesSlantEqual|RightDoubleBracket|SucceedsSlantEqual|NotLeftTriangleBar|RightTriangleEqual|SquareIntersection|RightDownTeeVector|ReverseEquilibrium|NegativeThickSpace|longleftrightarrow|Longleftrightarrow|LongLeftRightArrow|DownRightTeeVector|DownRightVectorBar|GreaterSlantEqual|SquareSubsetEqual|LeftDownVectorBar|LeftDoubleBracket|VerticalSeparator|rightleftharpoons|NotGreaterGreater|NotSquareSuperset|blacktriangleleft|blacktriangledown|NegativeThinSpace|LeftDownTeeVector|NotLessSlantEqual|leftrightharpoons|DoubleUpDownArrow|DoubleVerticalBar|LeftTriangleEqual|FilledSmallSquare|twoheadrightarrow|NotNestedLessLess|DownLeftTeeVector|DownLeftVectorBar|RightAngleBracket|NotTildeFullEqual|NotReverseElement|RightUpDownVector|DiacriticalTilde|NotSucceedsTilde|circlearrowright|NotPrecedesEqual|rightharpoondown|DoubleRightArrow|NotSucceedsEqual|NonBreakingSpace|NotRightTriangle|LessEqualGreater|RightUpTeeVector|LeftAngleBracket|GreaterFullEqual|DownArrowUpArrow|RightUpVectorBar|twoheadleftarrow|GreaterEqualLess|downharpoonright|RightTriangleBar|ntrianglerighteq|NotSupersetEqual|LeftUpDownVector|DiacriticalAcute|rightrightarrows|vartriangleright|UpArrowDownArrow|DiacriticalGrave|UnderParenthesis|EmptySmallSquare|LeftUpVectorBar|leftrightarrows|DownRightVector|downharpoonleft|trianglerighteq|ShortRightArrow|OverParenthesis|DoubleLeftArrow|DoubleDownArrow|NotSquareSubset|bigtriangledown|ntrianglelefteq|UpperRightArrow|curvearrowright|vartriangleleft|NotLeftTriangle|nleftrightarrow|LowerRightArrow|NotHumpDownHump|NotGreaterTilde|rightthreetimes|LeftUpTeeVector|NotGreaterEqual|straightepsilon|LeftTriangleBar|rightsquigarrow|ContourIntegral|rightleftarrows|CloseCurlyQuote|RightDownVector|LeftRightVector|nLeftrightarrow|leftharpoondown|circlearrowleft|SquareSuperset|OpenCurlyQuote|hookrightarrow|HorizontalLine|DiacriticalDot|NotLessGreater|ntriangleright|DoubleRightTee|InvisibleComma|InvisibleTimes|LowerLeftArrow|DownLeftVector|NotSubsetEqual|curvearrowleft|trianglelefteq|NotVerticalBar|TildeFullEqual|downdownarrows|NotGreaterLess|RightTeeVector|ZeroWidthSpace|looparrowright|LongRightArrow|doublebarwedge|ShortLeftArrow|ShortDownArrow|RightVectorBar|GreaterGreater|ReverseElement|rightharpoonup|LessSlantEqual|leftthreetimes|upharpoonright|rightarrowtail|LeftDownVector|Longrightarrow|NestedLessLess|UpperLeftArrow|nshortparallel|leftleftarrows|leftrightarrow|Leftrightarrow|LeftRightArrow|longrightarrow|upharpoonleft|RightArrowBar|ApplyFunction|LeftTeeVector|leftarrowtail|NotEqualTilde|varsubsetneqq|varsupsetneqq|RightTeeArrow|SucceedsEqual|SucceedsTilde|LeftVectorBar|SupersetEqual|hookleftarrow|DifferentialD|VerticalTilde|VeryThinSpace|blacktriangle|bigtriangleup|LessFullEqual|divideontimes|leftharpoonup|UpEquilibrium|ntriangleleft|RightTriangle|measuredangle|shortparallel|longleftarrow|Longleftarrow|LongLeftArrow|DoubleLeftTee|Poincareplane|PrecedesEqual|triangleright|DoubleUpArrow|RightUpVector|fallingdotseq|looparrowleft|PrecedesTilde|NotTildeEqual|NotTildeTilde|smallsetminus|Proportional|triangleleft|triangledown|UnderBracket|NotHumpEqual|exponentiale|ExponentialE|NotLessTilde|HilbertSpace|RightCeiling|blacklozenge|varsupsetneq|HumpDownHump|GreaterEqual|VerticalLine|LeftTeeArrow|NotLessEqual|DownTeeArrow|LeftTriangle|varsubsetneq|Intersection|NotCongruent|DownArrowBar|LeftUpVector|LeftArrowBar|risingdotseq|GreaterTilde|RoundImplies|SquareSubset|ShortUpArrow|NotSuperset|quaternions|precnapprox|backepsilon|preccurlyeq|OverBracket|blacksquare|MediumSpace|VerticalBar|circledcirc|circleddash|CircleMinus|CircleTimes|LessGreater|curlyeqprec|curlyeqsucc|diamondsuit|UpDownArrow|Updownarrow|RuleDelayed|Rrightarrow|updownarrow|RightVector|nRightarrow|nrightarrow|eqslantless|LeftCeiling|Equilibrium|SmallCircle|expectation|NotSucceeds|thickapprox|GreaterLess|SquareUnion|NotPrecedes|NotLessLess|straightphi|succnapprox|succcurlyeq|SubsetEqual|sqsupseteq|Proportion|Laplacetrf|ImaginaryI|supsetneqq|NotGreater|gtreqqless|NotElement|ThickSpace|TildeEqual|TildeTilde|Fouriertrf|rmoustache|EqualTilde|eqslantgtr|UnderBrace|LeftVector|UpArrowBar|nLeftarrow|nsubseteqq|subsetneqq|nsupseteqq|nleftarrow|succapprox|lessapprox|UpTeeArrow|upuparrows|curlywedge|lesseqqgtr|varepsilon|varnothing|RightFloor|complement|CirclePlus|sqsubseteq|Lleftarrow|circledast|RightArrow|Rightarrow|rightarrow|lmoustache|Bernoullis|precapprox|mapstoleft|mapstodown|longmapsto|dotsquare|downarrow|DoubleDot|nsubseteq|supsetneq|leftarrow|nsupseteq|subsetneq|ThinSpace|ngeqslant|subseteqq|HumpEqual|NotSubset|triangleq|NotCupCap|lesseqgtr|heartsuit|TripleDot|Leftarrow|Coproduct|Congruent|varpropto|complexes|gvertneqq|LeftArrow|LessTilde|supseteqq|MinusPlus|CircleDot|nleqslant|NotExists|gtreqless|nparallel|UnionPlus|LeftFloor|checkmark|CenterDot|centerdot|Mellintrf|gtrapprox|bigotimes|OverBrace|spadesuit|therefore|pitchfork|rationals|PlusMinus|Backslash|Therefore|DownBreve|backsimeq|backprime|DownArrow|nshortmid|Downarrow|lvertneqq|eqvparsl|imagline|imagpart|infintie|integers|Integral|intercal|LessLess|Uarrocir|intlarhk|sqsupset|angmsdaf|sqsubset|llcorner|vartheta|cupbrcap|lnapprox|Superset|SuchThat|succnsim|succneqq|angmsdag|biguplus|curlyvee|trpezium|Succeeds|NotTilde|bigwedge|angmsdah|angrtvbd|triminus|cwconint|fpartint|lrcorner|smeparsl|subseteq|urcorner|lurdshar|laemptyv|DDotrahd|approxeq|ldrushar|awconint|mapstoup|backcong|shortmid|triangle|geqslant|gesdotol|timesbar|circledR|circledS|setminus|multimap|naturals|scpolint|ncongdot|RightTee|boxminus|gnapprox|boxtimes|andslope|thicksim|angmsdaa|varsigma|cirfnint|rtriltri|angmsdab|rppolint|angmsdac|barwedge|drbkarow|clubsuit|thetasym|bsolhsub|capbrcup|dzigrarr|doteqdot|DotEqual|dotminus|UnderBar|NotEqual|realpart|otimesas|ulcorner|hksearow|hkswarow|parallel|PartialD|elinters|emptyset|plusacir|bbrktbrk|angmsdad|pointint|bigoplus|angmsdae|Precedes|bigsqcup|varkappa|notindot|supseteq|precneqq|precnsim|profalar|profline|profsurf|leqslant|lesdotor|raemptyv|subplus|notnivb|notnivc|subrarr|zigrarr|vzigzag|submult|subedot|Element|between|cirscir|larrbfs|larrsim|lotimes|lbrksld|lbrkslu|lozenge|ldrdhar|dbkarow|bigcirc|epsilon|simrarr|simplus|ltquest|Epsilon|luruhar|gtquest|maltese|npolint|eqcolon|npreceq|bigodot|ddagger|gtrless|bnequiv|harrcir|ddotseq|equivDD|backsim|demptyv|nsqsube|nsqsupe|Upsilon|nsubset|upsilon|minusdu|nsucceq|swarrow|nsupset|coloneq|searrow|boxplus|napprox|natural|asympeq|alefsym|congdot|nearrow|bigstar|diamond|supplus|tritime|LeftTee|nvinfin|triplus|NewLine|nvltrie|nvrtrie|nwarrow|nexists|Diamond|ruluhar|Implies|supmult|angzarr|suplarr|suphsub|questeq|because|digamma|Because|olcross|bemptyv|omicron|Omicron|rotimes|NoBreak|intprod|angrtvb|orderof|uwangle|suphsol|lesdoto|orslope|DownTee|realine|cudarrl|rdldhar|OverBar|supedot|lessdot|supdsub|topfork|succsim|rbrkslu|rbrksld|pertenk|cudarrr|isindot|planckh|lessgtr|pluscir|gesdoto|plussim|plustwo|lesssim|cularrp|rarrsim|Cayleys|notinva|notinvb|notinvc|UpArrow|Uparrow|uparrow|NotLess|dwangle|precsim|Product|curarrm|Cconint|dotplus|rarrbfs|ccupssm|Cedilla|cemptyv|notniva|quatint|frac35|frac38|frac45|frac56|frac58|frac78|tridot|xoplus|gacute|gammad|Gammad|lfisht|lfloor|bigcup|sqsupe|gbreve|Gbreve|lharul|sqsube|sqcups|Gcedil|apacir|llhard|lmidot|Lmidot|lmoust|andand|sqcaps|approx|Abreve|spades|circeq|tprime|divide|topcir|Assign|topbot|gesdot|divonx|xuplus|timesd|gesles|atilde|solbar|SOFTcy|loplus|timesb|lowast|lowbar|dlcorn|dlcrop|softcy|dollar|lparlt|thksim|lrhard|Atilde|lsaquo|smashp|bigvee|thinsp|wreath|bkarow|lsquor|lstrok|Lstrok|lthree|ltimes|ltlarr|DotDot|simdot|ltrPar|weierp|xsqcup|angmsd|sigmav|sigmaf|zeetrf|Zcaron|zcaron|mapsto|vsupne|thetav|cirmid|marker|mcomma|Zacute|vsubnE|there4|gtlPar|vsubne|bottom|gtrarr|SHCHcy|shchcy|midast|midcir|middot|minusb|minusd|gtrdot|bowtie|sfrown|mnplus|models|colone|seswar|Colone|mstpos|searhk|gtrsim|nacute|Nacute|boxbox|telrec|hairsp|Tcedil|nbumpe|scnsim|ncaron|Ncaron|ncedil|Ncedil|hamilt|Scedil|nearhk|hardcy|HARDcy|tcedil|Tcaron|commat|nequiv|nesear|tcaron|target|hearts|nexist|varrho|scedil|Scaron|scaron|hellip|Sacute|sacute|hercon|swnwar|compfn|rtimes|rthree|rsquor|rsaquo|zacute|wedgeq|homtht|barvee|barwed|Barwed|rpargt|horbar|conint|swarhk|roplus|nltrie|hslash|hstrok|Hstrok|rmoust|Conint|bprime|hybull|hyphen|iacute|Iacute|supsup|supsub|supsim|varphi|coprod|brvbar|agrave|Supset|supset|igrave|Igrave|notinE|Agrave|iiiint|iinfin|copysr|wedbar|Verbar|vangrt|becaus|incare|verbar|inodot|bullet|drcorn|intcal|drcrop|cularr|vellip|Utilde|bumpeq|cupcap|dstrok|Dstrok|CupCap|cupcup|cupdot|eacute|Eacute|supdot|iquest|easter|ecaron|Ecaron|ecolon|isinsv|utilde|itilde|Itilde|curarr|succeq|Bumpeq|cacute|ulcrop|nparsl|Cacute|nprcue|egrave|Egrave|nrarrc|nrarrw|subsup|subsub|nrtrie|jsercy|nsccue|Jsercy|kappav|kcedil|Kcedil|subsim|ulcorn|nsimeq|egsdot|veebar|kgreen|capand|elsdot|Subset|subset|curren|aacute|lacute|Lacute|emptyv|ntilde|Ntilde|lagran|lambda|Lambda|capcap|Ugrave|langle|subdot|emsp13|numero|emsp14|nvdash|nvDash|nVdash|nVDash|ugrave|ufisht|nvHarr|larrfs|nvlArr|larrhk|larrlp|larrpl|nvrArr|Udblac|nwarhk|larrtl|nwnear|oacute|Oacute|latail|lAtail|sstarf|lbrace|odblac|Odblac|lbrack|udblac|odsold|eparsl|lcaron|Lcaron|ograve|Ograve|lcedil|Lcedil|Aacute|ssmile|ssetmn|squarf|ldquor|capcup|ominus|cylcty|rharul|eqcirc|dagger|rfloor|rfisht|Dagger|daleth|equals|origof|capdot|equest|dcaron|Dcaron|rdquor|oslash|Oslash|otilde|Otilde|otimes|Otimes|urcrop|Ubreve|ubreve|Yacute|Uacute|uacute|Rcedil|rcedil|urcorn|parsim|Rcaron|Vdashl|rcaron|Tstrok|percnt|period|permil|Exists|yacute|rbrack|rbrace|phmmat|ccaron|Ccaron|planck|ccedil|plankv|tstrok|female|plusdo|plusdu|ffilig|plusmn|ffllig|Ccedil|rAtail|dfisht|bernou|ratail|Rarrtl|rarrtl|angsph|rarrpl|rarrlp|rarrhk|xwedge|xotime|forall|ForAll|Vvdash|vsupnE|preceq|bigcap|frac12|frac13|frac14|primes|rarrfs|prnsim|frac15|Square|frac16|square|lesdot|frac18|frac23|propto|prurel|rarrap|rangle|puncsp|frac25|Racute|qprime|racute|lesges|frac34|abreve|AElig|eqsim|utdot|setmn|urtri|Equal|Uring|seArr|uring|searr|dashv|Dashv|mumap|nabla|iogon|Iogon|sdote|sdotb|scsim|napid|napos|equiv|natur|Acirc|dblac|erarr|nbump|iprod|erDot|ucirc|awint|esdot|angrt|ncong|isinE|scnap|Scirc|scirc|ndash|isins|Ubrcy|nearr|neArr|isinv|nedot|ubrcy|acute|Ycirc|iukcy|Iukcy|xutri|nesim|caret|jcirc|Jcirc|caron|twixt|ddarr|sccue|exist|jmath|sbquo|ngeqq|angst|ccaps|lceil|ngsim|UpTee|delta|Delta|rtrif|nharr|nhArr|nhpar|rtrie|jukcy|Jukcy|kappa|rsquo|Kappa|nlarr|nlArr|TSHcy|rrarr|aogon|Aogon|fflig|xrarr|tshcy|ccirc|nleqq|filig|upsih|nless|dharl|nlsim|fjlig|ropar|nltri|dharr|robrk|roarr|fllig|fltns|roang|rnmid|subnE|subne|lAarr|trisb|Ccirc|acirc|ccups|blank|VDash|forkv|Vdash|langd|cedil|blk12|blk14|laquo|strns|diams|notin|vDash|larrb|blk34|block|disin|uplus|vdash|vBarv|aelig|starf|Wedge|check|xrArr|lates|lbarr|lBarr|notni|lbbrk|bcong|frasl|lbrke|frown|vrtri|vprop|vnsup|gamma|Gamma|wedge|xodot|bdquo|srarr|doteq|ldquo|boxdl|boxdL|gcirc|Gcirc|boxDl|boxDL|boxdr|boxdR|boxDr|TRADE|trade|rlhar|boxDR|vnsub|npart|vltri|rlarr|boxhd|boxhD|nprec|gescc|nrarr|nrArr|boxHd|boxHD|boxhu|boxhU|nrtri|boxHu|clubs|boxHU|times|colon|Colon|gimel|xlArr|Tilde|nsime|tilde|nsmid|nspar|THORN|thorn|xlarr|nsube|nsubE|thkap|xhArr|comma|nsucc|boxul|boxuL|nsupe|nsupE|gneqq|gnsim|boxUl|boxUL|grave|boxur|boxuR|boxUr|boxUR|lescc|angle|bepsi|boxvh|varpi|boxvH|numsp|Theta|gsime|gsiml|theta|boxVh|boxVH|boxvl|gtcir|gtdot|boxvL|boxVl|boxVL|crarr|cross|Cross|nvsim|boxvr|nwarr|nwArr|sqsup|dtdot|Uogon|lhard|lharu|dtrif|ocirc|Ocirc|lhblk|duarr|odash|sqsub|Hacek|sqcup|llarr|duhar|oelig|OElig|ofcir|boxvR|uogon|lltri|boxVr|csube|uuarr|ohbar|csupe|ctdot|olarr|olcir|harrw|oline|sqcap|omacr|Omacr|omega|Omega|boxVR|aleph|lneqq|lnsim|loang|loarr|rharu|lobrk|hcirc|operp|oplus|rhard|Hcirc|orarr|Union|order|ecirc|Ecirc|cuepr|szlig|cuesc|breve|reals|eDDot|Breve|hoarr|lopar|utrif|rdquo|Umacr|umacr|efDot|swArr|ultri|alpha|rceil|ovbar|swarr|Wcirc|wcirc|smtes|smile|bsemi|lrarr|aring|parsl|lrhar|bsime|uhblk|lrtri|cupor|Aring|uharr|uharl|slarr|rbrke|bsolb|lsime|rbbrk|RBarr|lsimg|phone|rBarr|rbarr|icirc|lsquo|Icirc|emacr|Emacr|ratio|simne|plusb|simlE|simgE|simeq|pluse|ltcir|ltdot|empty|xharr|xdtri|iexcl|Alpha|ltrie|rarrw|pound|ltrif|xcirc|bumpe|prcue|bumpE|asymp|amacr|cuvee|Sigma|sigma|iiint|udhar|iiota|ijlig|IJlig|supnE|imacr|Imacr|prime|Prime|image|prnap|eogon|Eogon|rarrc|mdash|mDDot|cuwed|imath|supne|imped|Amacr|udarr|prsim|micro|rarrb|cwint|raquo|infin|eplus|range|rangd|Ucirc|radic|minus|amalg|veeeq|rAarr|epsiv|ycirc|quest|sharp|quot|zwnj|Qscr|race|qscr|Qopf|qopf|qint|rang|Rang|Zscr|zscr|Zopf|zopf|rarr|rArr|Rarr|Pscr|pscr|prop|prod|prnE|prec|ZHcy|zhcy|prap|Zeta|zeta|Popf|popf|Zdot|plus|zdot|Yuml|yuml|phiv|YUcy|yucy|Yscr|yscr|perp|Yopf|yopf|part|para|YIcy|Ouml|rcub|yicy|YAcy|rdca|ouml|osol|Oscr|rdsh|yacy|real|oscr|xvee|andd|rect|andv|Xscr|oror|ordm|ordf|xscr|ange|aopf|Aopf|rHar|Xopf|opar|Oopf|xopf|xnis|rhov|oopf|omid|xmap|oint|apid|apos|ogon|ascr|Ascr|odot|odiv|xcup|xcap|ocir|oast|nvlt|nvle|nvgt|nvge|nvap|Wscr|wscr|auml|ntlg|ntgl|nsup|nsub|nsim|Nscr|nscr|nsce|Wopf|ring|npre|wopf|npar|Auml|Barv|bbrk|Nopf|nopf|nmid|nLtv|beta|ropf|Ropf|Beta|beth|nles|rpar|nleq|bnot|bNot|nldr|NJcy|rscr|Rscr|Vscr|vscr|rsqb|njcy|bopf|nisd|Bopf|rtri|Vopf|nGtv|ngtr|vopf|boxh|boxH|boxv|nges|ngeq|boxV|bscr|scap|Bscr|bsim|Vert|vert|bsol|bull|bump|caps|cdot|ncup|scnE|ncap|nbsp|napE|Cdot|cent|sdot|Vbar|nang|vBar|chcy|Mscr|mscr|sect|semi|CHcy|Mopf|mopf|sext|circ|cire|mldr|mlcp|cirE|comp|shcy|SHcy|vArr|varr|cong|copf|Copf|copy|COPY|malt|male|macr|lvnE|cscr|ltri|sime|ltcc|simg|Cscr|siml|csub|Uuml|lsqb|lsim|uuml|csup|Lscr|lscr|utri|smid|lpar|cups|smte|lozf|darr|Lopf|Uscr|solb|lopf|sopf|Sopf|lneq|uscr|spar|dArr|lnap|Darr|dash|Sqrt|LJcy|ljcy|lHar|dHar|Upsi|upsi|diam|lesg|djcy|DJcy|leqq|dopf|Dopf|dscr|Dscr|dscy|ldsh|ldca|squf|DScy|sscr|Sscr|dsol|lcub|late|star|Star|Uopf|Larr|lArr|larr|uopf|dtri|dzcy|sube|subE|Lang|lang|Kscr|kscr|Kopf|kopf|KJcy|kjcy|KHcy|khcy|DZcy|ecir|edot|eDot|Jscr|jscr|succ|Jopf|jopf|Edot|uHar|emsp|ensp|Iuml|iuml|eopf|isin|Iscr|iscr|Eopf|epar|sung|epsi|escr|sup1|sup2|sup3|Iota|iota|supe|supE|Iopf|iopf|IOcy|iocy|Escr|esim|Esim|imof|Uarr|QUOT|uArr|uarr|euml|IEcy|iecy|Idot|Euml|euro|excl|Hscr|hscr|Hopf|hopf|TScy|tscy|Tscr|hbar|tscr|flat|tbrk|fnof|hArr|harr|half|fopf|Fopf|tdot|gvnE|fork|trie|gtcc|fscr|Fscr|gdot|gsim|Gscr|gscr|Gopf|gopf|gneq|Gdot|tosa|gnap|Topf|topf|geqq|toea|GJcy|gjcy|tint|gesl|mid|Sfr|ggg|top|ges|gla|glE|glj|geq|gne|gEl|gel|gnE|Gcy|gcy|gap|Tfr|tfr|Tcy|tcy|Hat|Tau|Ffr|tau|Tab|hfr|Hfr|ffr|Fcy|fcy|icy|Icy|iff|ETH|eth|ifr|Ifr|Eta|eta|int|Int|Sup|sup|ucy|Ucy|Sum|sum|jcy|ENG|ufr|Ufr|eng|Jcy|jfr|els|ell|egs|Efr|efr|Jfr|uml|kcy|Kcy|Ecy|ecy|kfr|Kfr|lap|Sub|sub|lat|lcy|Lcy|leg|Dot|dot|lEg|leq|les|squ|div|die|lfr|Lfr|lgE|Dfr|dfr|Del|deg|Dcy|dcy|lne|lnE|sol|loz|smt|Cup|lrm|cup|lsh|Lsh|sim|shy|map|Map|mcy|Mcy|mfr|Mfr|mho|gfr|Gfr|sfr|cir|Chi|chi|nap|Cfr|vcy|Vcy|cfr|Scy|scy|ncy|Ncy|vee|Vee|Cap|cap|nfr|scE|sce|Nfr|nge|ngE|nGg|vfr|Vfr|ngt|bot|nGt|nis|niv|Rsh|rsh|nle|nlE|bne|Bfr|bfr|nLl|nlt|nLt|Bcy|bcy|not|Not|rlm|wfr|Wfr|npr|nsc|num|ocy|ast|Ocy|ofr|xfr|Xfr|Ofr|ogt|ohm|apE|olt|Rho|ape|rho|Rfr|rfr|ord|REG|ang|reg|orv|And|and|AMP|Rcy|amp|Afr|ycy|Ycy|yen|yfr|Yfr|rcy|par|pcy|Pcy|pfr|Pfr|phi|Phi|afr|Acy|acy|zcy|Zcy|piv|acE|acd|zfr|Zfr|pre|prE|psi|Psi|qfr|Qfr|zwj|Or|ge|Gg|gt|gg|el|oS|lt|Lt|LT|Re|lg|gl|eg|ne|Im|it|le|DD|wp|wr|nu|Nu|dd|lE|Sc|sc|pi|Pi|ee|af|ll|Ll|rx|gE|xi|pm|Xi|ic|pr|Pr|in|ni|mp|mu|ac|Mu|or|ap|Gt|GT|ii);|&(Aacute|Agrave|Atilde|Ccedil|Eacute|Egrave|Iacute|Igrave|Ntilde|Oacute|Ograve|Oslash|Otilde|Uacute|Ugrave|Yacute|aacute|agrave|atilde|brvbar|ccedil|curren|divide|eacute|egrave|frac12|frac14|frac34|iacute|igrave|iquest|middot|ntilde|oacute|ograve|oslash|otilde|plusmn|uacute|ugrave|yacute|AElig|Acirc|Aring|Ecirc|Icirc|Ocirc|THORN|Ucirc|acirc|acute|aelig|aring|cedil|ecirc|icirc|iexcl|laquo|micro|ocirc|pound|raquo|szlig|thorn|times|ucirc|Auml|COPY|Euml|Iuml|Ouml|QUOT|Uuml|auml|cent|copy|euml|iuml|macr|nbsp|ordf|ordm|ouml|para|quot|sect|sup1|sup2|sup3|uuml|yuml|AMP|ETH|REG|amp|deg|eth|not|reg|shy|uml|yen|GT|LT|gt|lt)(?!;)([=a-zA-Z0-9]?)|&#([0-9]+)(;?)|&#[xX]([a-fA-F0-9]+)(;?)|&([0-9a-zA-Z]+)/g,b={aacute:\"\\xe1\",Aacute:\"\\xc1\",abreve:\"\\u0103\",Abreve:\"\\u0102\",ac:\"\\u223e\",acd:\"\\u223f\",acE:\"\\u223e\\u0333\",acirc:\"\\xe2\",Acirc:\"\\xc2\",acute:\"\\xb4\",acy:\"\\u0430\",Acy:\"\\u0410\",aelig:\"\\xe6\",AElig:\"\\xc6\",af:\"\\u2061\",afr:\"\\ud835\\udd1e\",Afr:\"\\ud835\\udd04\",agrave:\"\\xe0\",Agrave:\"\\xc0\",alefsym:\"\\u2135\",aleph:\"\\u2135\",alpha:\"\\u03b1\",Alpha:\"\\u0391\",amacr:\"\\u0101\",Amacr:\"\\u0100\",amalg:\"\\u2a3f\",amp:\"&\",AMP:\"&\",and:\"\\u2227\",And:\"\\u2a53\",andand:\"\\u2a55\",andd:\"\\u2a5c\",andslope:\"\\u2a58\",andv:\"\\u2a5a\",ang:\"\\u2220\",ange:\"\\u29a4\",angle:\"\\u2220\",angmsd:\"\\u2221\",angmsdaa:\"\\u29a8\",angmsdab:\"\\u29a9\",angmsdac:\"\\u29aa\",angmsdad:\"\\u29ab\",angmsdae:\"\\u29ac\",angmsdaf:\"\\u29ad\",angmsdag:\"\\u29ae\",angmsdah:\"\\u29af\",angrt:\"\\u221f\",angrtvb:\"\\u22be\",angrtvbd:\"\\u299d\",angsph:\"\\u2222\",angst:\"\\xc5\",angzarr:\"\\u237c\",aogon:\"\\u0105\",Aogon:\"\\u0104\",aopf:\"\\ud835\\udd52\",Aopf:\"\\ud835\\udd38\",ap:\"\\u2248\",apacir:\"\\u2a6f\",ape:\"\\u224a\",apE:\"\\u2a70\",apid:\"\\u224b\",apos:\"'\",ApplyFunction:\"\\u2061\",approx:\"\\u2248\",approxeq:\"\\u224a\",aring:\"\\xe5\",Aring:\"\\xc5\",ascr:\"\\ud835\\udcb6\",Ascr:\"\\ud835\\udc9c\",Assign:\"\\u2254\",ast:\"*\",asymp:\"\\u2248\",asympeq:\"\\u224d\",atilde:\"\\xe3\",Atilde:\"\\xc3\",auml:\"\\xe4\",Auml:\"\\xc4\",awconint:\"\\u2233\",awint:\"\\u2a11\",backcong:\"\\u224c\",backepsilon:\"\\u03f6\",backprime:\"\\u2035\",backsim:\"\\u223d\",backsimeq:\"\\u22cd\",Backslash:\"\\u2216\",Barv:\"\\u2ae7\",barvee:\"\\u22bd\",barwed:\"\\u2305\",Barwed:\"\\u2306\",barwedge:\"\\u2305\",bbrk:\"\\u23b5\",bbrktbrk:\"\\u23b6\",bcong:\"\\u224c\",bcy:\"\\u0431\",Bcy:\"\\u0411\",bdquo:\"\\u201e\",becaus:\"\\u2235\",because:\"\\u2235\",Because:\"\\u2235\",bemptyv:\"\\u29b0\",bepsi:\"\\u03f6\",bernou:\"\\u212c\",Bernoullis:\"\\u212c\",beta:\"\\u03b2\",Beta:\"\\u0392\",beth:\"\\u2136\",between:\"\\u226c\",bfr:\"\\ud835\\udd1f\",Bfr:\"\\ud835\\udd05\",bigcap:\"\\u22c2\",bigcirc:\"\\u25ef\",bigcup:\"\\u22c3\",bigodot:\"\\u2a00\",bigoplus:\"\\u2a01\",bigotimes:\"\\u2a02\",bigsqcup:\"\\u2a06\",bigstar:\"\\u2605\",bigtriangledown:\"\\u25bd\",bigtriangleup:\"\\u25b3\",biguplus:\"\\u2a04\",bigvee:\"\\u22c1\",bigwedge:\"\\u22c0\",bkarow:\"\\u290d\",blacklozenge:\"\\u29eb\",blacksquare:\"\\u25aa\",blacktriangle:\"\\u25b4\",blacktriangledown:\"\\u25be\",blacktriangleleft:\"\\u25c2\",blacktriangleright:\"\\u25b8\",blank:\"\\u2423\",blk12:\"\\u2592\",blk14:\"\\u2591\",blk34:\"\\u2593\",block:\"\\u2588\",bne:\"=\\u20e5\",bnequiv:\"\\u2261\\u20e5\",bnot:\"\\u2310\",bNot:\"\\u2aed\",bopf:\"\\ud835\\udd53\",Bopf:\"\\ud835\\udd39\",bot:\"\\u22a5\",bottom:\"\\u22a5\",bowtie:\"\\u22c8\",boxbox:\"\\u29c9\",boxdl:\"\\u2510\",boxdL:\"\\u2555\",boxDl:\"\\u2556\",boxDL:\"\\u2557\",boxdr:\"\\u250c\",boxdR:\"\\u2552\",boxDr:\"\\u2553\",boxDR:\"\\u2554\",boxh:\"\\u2500\",boxH:\"\\u2550\",boxhd:\"\\u252c\",boxhD:\"\\u2565\",boxHd:\"\\u2564\",boxHD:\"\\u2566\",boxhu:\"\\u2534\",boxhU:\"\\u2568\",boxHu:\"\\u2567\",boxHU:\"\\u2569\",boxminus:\"\\u229f\",boxplus:\"\\u229e\",boxtimes:\"\\u22a0\",boxul:\"\\u2518\",boxuL:\"\\u255b\",boxUl:\"\\u255c\",boxUL:\"\\u255d\",boxur:\"\\u2514\",boxuR:\"\\u2558\",boxUr:\"\\u2559\",boxUR:\"\\u255a\",boxv:\"\\u2502\",boxV:\"\\u2551\",boxvh:\"\\u253c\",boxvH:\"\\u256a\",boxVh:\"\\u256b\",boxVH:\"\\u256c\",boxvl:\"\\u2524\",boxvL:\"\\u2561\",boxVl:\"\\u2562\",boxVL:\"\\u2563\",boxvr:\"\\u251c\",boxvR:\"\\u255e\",boxVr:\"\\u255f\",boxVR:\"\\u2560\",bprime:\"\\u2035\",breve:\"\\u02d8\",Breve:\"\\u02d8\",brvbar:\"\\xa6\",bscr:\"\\ud835\\udcb7\",Bscr:\"\\u212c\",bsemi:\"\\u204f\",bsim:\"\\u223d\",bsime:\"\\u22cd\",bsol:\"\\\\\",bsolb:\"\\u29c5\",bsolhsub:\"\\u27c8\",bull:\"\\u2022\",bullet:\"\\u2022\",bump:\"\\u224e\",bumpe:\"\\u224f\",bumpE:\"\\u2aae\",bumpeq:\"\\u224f\",Bumpeq:\"\\u224e\",cacute:\"\\u0107\",Cacute:\"\\u0106\",cap:\"\\u2229\",Cap:\"\\u22d2\",capand:\"\\u2a44\",capbrcup:\"\\u2a49\",capcap:\"\\u2a4b\",capcup:\"\\u2a47\",capdot:\"\\u2a40\",CapitalDifferentialD:\"\\u2145\",caps:\"\\u2229\\ufe00\",caret:\"\\u2041\",caron:\"\\u02c7\",Cayleys:\"\\u212d\",ccaps:\"\\u2a4d\",ccaron:\"\\u010d\",Ccaron:\"\\u010c\",ccedil:\"\\xe7\",Ccedil:\"\\xc7\",ccirc:\"\\u0109\",Ccirc:\"\\u0108\",Cconint:\"\\u2230\",ccups:\"\\u2a4c\",ccupssm:\"\\u2a50\",cdot:\"\\u010b\",Cdot:\"\\u010a\",cedil:\"\\xb8\",Cedilla:\"\\xb8\",cemptyv:\"\\u29b2\",cent:\"\\xa2\",centerdot:\"\\xb7\",CenterDot:\"\\xb7\",cfr:\"\\ud835\\udd20\",Cfr:\"\\u212d\",chcy:\"\\u0447\",CHcy:\"\\u0427\",check:\"\\u2713\",checkmark:\"\\u2713\",chi:\"\\u03c7\",Chi:\"\\u03a7\",cir:\"\\u25cb\",circ:\"\\u02c6\",circeq:\"\\u2257\",circlearrowleft:\"\\u21ba\",circlearrowright:\"\\u21bb\",circledast:\"\\u229b\",circledcirc:\"\\u229a\",circleddash:\"\\u229d\",CircleDot:\"\\u2299\",circledR:\"\\xae\",circledS:\"\\u24c8\",CircleMinus:\"\\u2296\",CirclePlus:\"\\u2295\",CircleTimes:\"\\u2297\",cire:\"\\u2257\",cirE:\"\\u29c3\",cirfnint:\"\\u2a10\",cirmid:\"\\u2aef\",cirscir:\"\\u29c2\",ClockwiseContourIntegral:\"\\u2232\",CloseCurlyDoubleQuote:\"\\u201d\",CloseCurlyQuote:\"\\u2019\",clubs:\"\\u2663\",clubsuit:\"\\u2663\",colon:\":\",Colon:\"\\u2237\",colone:\"\\u2254\",Colone:\"\\u2a74\",coloneq:\"\\u2254\",comma:\",\",commat:\"@\",comp:\"\\u2201\",compfn:\"\\u2218\",complement:\"\\u2201\",complexes:\"\\u2102\",cong:\"\\u2245\",congdot:\"\\u2a6d\",Congruent:\"\\u2261\",conint:\"\\u222e\",Conint:\"\\u222f\",ContourIntegral:\"\\u222e\",copf:\"\\ud835\\udd54\",Copf:\"\\u2102\",coprod:\"\\u2210\",Coproduct:\"\\u2210\",copy:\"\\xa9\",COPY:\"\\xa9\",copysr:\"\\u2117\",CounterClockwiseContourIntegral:\"\\u2233\",crarr:\"\\u21b5\",cross:\"\\u2717\",Cross:\"\\u2a2f\",cscr:\"\\ud835\\udcb8\",Cscr:\"\\ud835\\udc9e\",csub:\"\\u2acf\",csube:\"\\u2ad1\",csup:\"\\u2ad0\",csupe:\"\\u2ad2\",ctdot:\"\\u22ef\",cudarrl:\"\\u2938\",cudarrr:\"\\u2935\",cuepr:\"\\u22de\",cuesc:\"\\u22df\",cularr:\"\\u21b6\",cularrp:\"\\u293d\",cup:\"\\u222a\",Cup:\"\\u22d3\",cupbrcap:\"\\u2a48\",cupcap:\"\\u2a46\",CupCap:\"\\u224d\",cupcup:\"\\u2a4a\",cupdot:\"\\u228d\",cupor:\"\\u2a45\",cups:\"\\u222a\\ufe00\",curarr:\"\\u21b7\",curarrm:\"\\u293c\",curlyeqprec:\"\\u22de\",curlyeqsucc:\"\\u22df\",curlyvee:\"\\u22ce\",curlywedge:\"\\u22cf\",curren:\"\\xa4\",curvearrowleft:\"\\u21b6\",curvearrowright:\"\\u21b7\",cuvee:\"\\u22ce\",cuwed:\"\\u22cf\",cwconint:\"\\u2232\",cwint:\"\\u2231\",cylcty:\"\\u232d\",dagger:\"\\u2020\",Dagger:\"\\u2021\",daleth:\"\\u2138\",darr:\"\\u2193\",dArr:\"\\u21d3\",Darr:\"\\u21a1\",dash:\"\\u2010\",dashv:\"\\u22a3\",Dashv:\"\\u2ae4\",dbkarow:\"\\u290f\",dblac:\"\\u02dd\",dcaron:\"\\u010f\",Dcaron:\"\\u010e\",dcy:\"\\u0434\",Dcy:\"\\u0414\",dd:\"\\u2146\",DD:\"\\u2145\",ddagger:\"\\u2021\",ddarr:\"\\u21ca\",DDotrahd:\"\\u2911\",ddotseq:\"\\u2a77\",deg:\"\\xb0\",Del:\"\\u2207\",delta:\"\\u03b4\",Delta:\"\\u0394\",demptyv:\"\\u29b1\",dfisht:\"\\u297f\",dfr:\"\\ud835\\udd21\",Dfr:\"\\ud835\\udd07\",dHar:\"\\u2965\",dharl:\"\\u21c3\",dharr:\"\\u21c2\",DiacriticalAcute:\"\\xb4\",DiacriticalDot:\"\\u02d9\",DiacriticalDoubleAcute:\"\\u02dd\",DiacriticalGrave:\"`\",DiacriticalTilde:\"\\u02dc\",diam:\"\\u22c4\",diamond:\"\\u22c4\",Diamond:\"\\u22c4\",diamondsuit:\"\\u2666\",diams:\"\\u2666\",die:\"\\xa8\",DifferentialD:\"\\u2146\",digamma:\"\\u03dd\",disin:\"\\u22f2\",div:\"\\xf7\",divide:\"\\xf7\",divideontimes:\"\\u22c7\",divonx:\"\\u22c7\",djcy:\"\\u0452\",DJcy:\"\\u0402\",dlcorn:\"\\u231e\",dlcrop:\"\\u230d\",dollar:\"$\",dopf:\"\\ud835\\udd55\",Dopf:\"\\ud835\\udd3b\",dot:\"\\u02d9\",Dot:\"\\xa8\",DotDot:\"\\u20dc\",doteq:\"\\u2250\",doteqdot:\"\\u2251\",DotEqual:\"\\u2250\",dotminus:\"\\u2238\",dotplus:\"\\u2214\",dotsquare:\"\\u22a1\",doublebarwedge:\"\\u2306\",DoubleContourIntegral:\"\\u222f\",DoubleDot:\"\\xa8\",DoubleDownArrow:\"\\u21d3\",DoubleLeftArrow:\"\\u21d0\",DoubleLeftRightArrow:\"\\u21d4\",DoubleLeftTee:\"\\u2ae4\",DoubleLongLeftArrow:\"\\u27f8\",DoubleLongLeftRightArrow:\"\\u27fa\",DoubleLongRightArrow:\"\\u27f9\",DoubleRightArrow:\"\\u21d2\",DoubleRightTee:\"\\u22a8\",DoubleUpArrow:\"\\u21d1\",DoubleUpDownArrow:\"\\u21d5\",DoubleVerticalBar:\"\\u2225\",downarrow:\"\\u2193\",Downarrow:\"\\u21d3\",DownArrow:\"\\u2193\",DownArrowBar:\"\\u2913\",DownArrowUpArrow:\"\\u21f5\",DownBreve:\"\\u0311\",downdownarrows:\"\\u21ca\",downharpoonleft:\"\\u21c3\",downharpoonright:\"\\u21c2\",DownLeftRightVector:\"\\u2950\",DownLeftTeeVector:\"\\u295e\",DownLeftVector:\"\\u21bd\",DownLeftVectorBar:\"\\u2956\",DownRightTeeVector:\"\\u295f\",DownRightVector:\"\\u21c1\",DownRightVectorBar:\"\\u2957\",DownTee:\"\\u22a4\",DownTeeArrow:\"\\u21a7\",drbkarow:\"\\u2910\",drcorn:\"\\u231f\",drcrop:\"\\u230c\",dscr:\"\\ud835\\udcb9\",Dscr:\"\\ud835\\udc9f\",dscy:\"\\u0455\",DScy:\"\\u0405\",dsol:\"\\u29f6\",dstrok:\"\\u0111\",Dstrok:\"\\u0110\",dtdot:\"\\u22f1\",dtri:\"\\u25bf\",dtrif:\"\\u25be\",duarr:\"\\u21f5\",duhar:\"\\u296f\",dwangle:\"\\u29a6\",dzcy:\"\\u045f\",DZcy:\"\\u040f\",dzigrarr:\"\\u27ff\",eacute:\"\\xe9\",Eacute:\"\\xc9\",easter:\"\\u2a6e\",ecaron:\"\\u011b\",Ecaron:\"\\u011a\",ecir:\"\\u2256\",ecirc:\"\\xea\",Ecirc:\"\\xca\",ecolon:\"\\u2255\",ecy:\"\\u044d\",Ecy:\"\\u042d\",eDDot:\"\\u2a77\",edot:\"\\u0117\",eDot:\"\\u2251\",Edot:\"\\u0116\",ee:\"\\u2147\",efDot:\"\\u2252\",efr:\"\\ud835\\udd22\",Efr:\"\\ud835\\udd08\",eg:\"\\u2a9a\",egrave:\"\\xe8\",Egrave:\"\\xc8\",egs:\"\\u2a96\",egsdot:\"\\u2a98\",el:\"\\u2a99\",Element:\"\\u2208\",elinters:\"\\u23e7\",ell:\"\\u2113\",els:\"\\u2a95\",elsdot:\"\\u2a97\",emacr:\"\\u0113\",Emacr:\"\\u0112\",empty:\"\\u2205\",emptyset:\"\\u2205\",EmptySmallSquare:\"\\u25fb\",emptyv:\"\\u2205\",EmptyVerySmallSquare:\"\\u25ab\",emsp:\"\\u2003\",emsp13:\"\\u2004\",emsp14:\"\\u2005\",eng:\"\\u014b\",ENG:\"\\u014a\",ensp:\"\\u2002\",eogon:\"\\u0119\",Eogon:\"\\u0118\",eopf:\"\\ud835\\udd56\",Eopf:\"\\ud835\\udd3c\",epar:\"\\u22d5\",eparsl:\"\\u29e3\",eplus:\"\\u2a71\",epsi:\"\\u03b5\",epsilon:\"\\u03b5\",Epsilon:\"\\u0395\",epsiv:\"\\u03f5\",eqcirc:\"\\u2256\",eqcolon:\"\\u2255\",eqsim:\"\\u2242\",eqslantgtr:\"\\u2a96\",eqslantless:\"\\u2a95\",Equal:\"\\u2a75\",equals:\"=\",EqualTilde:\"\\u2242\",equest:\"\\u225f\",Equilibrium:\"\\u21cc\",equiv:\"\\u2261\",equivDD:\"\\u2a78\",eqvparsl:\"\\u29e5\",erarr:\"\\u2971\",erDot:\"\\u2253\",escr:\"\\u212f\",Escr:\"\\u2130\",esdot:\"\\u2250\",esim:\"\\u2242\",Esim:\"\\u2a73\",eta:\"\\u03b7\",Eta:\"\\u0397\",eth:\"\\xf0\",ETH:\"\\xd0\",euml:\"\\xeb\",Euml:\"\\xcb\",euro:\"\\u20ac\",excl:\"!\",exist:\"\\u2203\",Exists:\"\\u2203\",expectation:\"\\u2130\",exponentiale:\"\\u2147\",ExponentialE:\"\\u2147\",fallingdotseq:\"\\u2252\",fcy:\"\\u0444\",Fcy:\"\\u0424\",female:\"\\u2640\",ffilig:\"\\ufb03\",fflig:\"\\ufb00\",ffllig:\"\\ufb04\",ffr:\"\\ud835\\udd23\",Ffr:\"\\ud835\\udd09\",filig:\"\\ufb01\",FilledSmallSquare:\"\\u25fc\",FilledVerySmallSquare:\"\\u25aa\",fjlig:\"fj\",flat:\"\\u266d\",fllig:\"\\ufb02\",fltns:\"\\u25b1\",fnof:\"\\u0192\",fopf:\"\\ud835\\udd57\",Fopf:\"\\ud835\\udd3d\",forall:\"\\u2200\",ForAll:\"\\u2200\",fork:\"\\u22d4\",forkv:\"\\u2ad9\",Fouriertrf:\"\\u2131\",fpartint:\"\\u2a0d\",frac12:\"\\xbd\",frac13:\"\\u2153\",frac14:\"\\xbc\",frac15:\"\\u2155\",frac16:\"\\u2159\",frac18:\"\\u215b\",frac23:\"\\u2154\",frac25:\"\\u2156\",frac34:\"\\xbe\",frac35:\"\\u2157\",frac38:\"\\u215c\",frac45:\"\\u2158\",frac56:\"\\u215a\",frac58:\"\\u215d\",frac78:\"\\u215e\",frasl:\"\\u2044\",frown:\"\\u2322\",fscr:\"\\ud835\\udcbb\",Fscr:\"\\u2131\",gacute:\"\\u01f5\",gamma:\"\\u03b3\",Gamma:\"\\u0393\",gammad:\"\\u03dd\",Gammad:\"\\u03dc\",gap:\"\\u2a86\",gbreve:\"\\u011f\",Gbreve:\"\\u011e\",Gcedil:\"\\u0122\",gcirc:\"\\u011d\",Gcirc:\"\\u011c\",gcy:\"\\u0433\",Gcy:\"\\u0413\",gdot:\"\\u0121\",Gdot:\"\\u0120\",ge:\"\\u2265\",gE:\"\\u2267\",gel:\"\\u22db\",gEl:\"\\u2a8c\",geq:\"\\u2265\",geqq:\"\\u2267\",geqslant:\"\\u2a7e\",ges:\"\\u2a7e\",gescc:\"\\u2aa9\",gesdot:\"\\u2a80\",gesdoto:\"\\u2a82\",gesdotol:\"\\u2a84\",gesl:\"\\u22db\\ufe00\",gesles:\"\\u2a94\",gfr:\"\\ud835\\udd24\",Gfr:\"\\ud835\\udd0a\",gg:\"\\u226b\",Gg:\"\\u22d