require.config({"config": {
        "jsbuild":{"Magento_Tinymce3/tiny_mce/tiny_mce_prototype_src.js":"(function(win) {\n\tvar whiteSpaceRe = /^\\s*|\\s*$/g,\n\t\tundefined, isRegExpBroken = 'B'.replace(/A(.)|B/, '$1') === '$1';\n\n\tvar tinymce = {\n\t\tmajorVersion : '3',\n\n\t\tminorVersion : '4.7',\n\n\t\treleaseDate : '2011-11-03',\n\n\t\t_init : function() {\n\t\t\tvar t = this, d = document, na = navigator, ua = na.userAgent, i, nl, n, base, p, v;\n\n\t\t\tt.isOpera = win.opera && opera.buildNumber;\n\n\t\t\tt.isWebKit = /WebKit/.test(ua);\n\n\t\t\tt.isIE = !t.isWebKit && !t.isOpera && (/MSIE/gi).test(ua) && (/Explorer/gi).test(na.appName);\n\n\t\t\tt.isIE6 = t.isIE && /MSIE [56]/.test(ua);\n\n\t\t\tt.isIE7 = t.isIE && /MSIE [7]/.test(ua);\n\n\t\t\tt.isIE8 = t.isIE && /MSIE [8]/.test(ua);\n\n\t\t\tt.isIE9 = t.isIE && /MSIE [9]/.test(ua);\n\n\t\t\tt.isGecko = !t.isWebKit && /Gecko/.test(ua);\n\n\t\t\tt.isMac = ua.indexOf('Mac') != -1;\n\n\t\t\tt.isAir = /adobeair/i.test(ua);\n\n\t\t\tt.isIDevice = /(iPad|iPhone)/.test(ua);\n\t\t\t\n\t\t\tt.isIOS5 = t.isIDevice && ua.match(/AppleWebKit\\/(\\d*)/)[1]>=534;\n\n\t\t\t// TinyMCE .NET webcontrol might be setting the values for TinyMCE\n\t\t\tif (win.tinyMCEPreInit) {\n\t\t\t\tt.suffix = tinyMCEPreInit.suffix;\n\t\t\t\tt.baseURL = tinyMCEPreInit.base;\n\t\t\t\tt.query = tinyMCEPreInit.query;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Get suffix and base\n\t\t\tt.suffix = '';\n\n\t\t\t// If base element found, add that infront of baseURL\n\t\t\tnl = d.getElementsByTagName('base');\n\t\t\tfor (i=0; i<nl.length; i++) {\n\t\t\t\tif (v = nl[i].href) {\n\t\t\t\t\t// Host only value like http://site.com or http://site.com:8008\n\t\t\t\t\tif (/^https?:\\/\\/[^\\/]+$/.test(v))\n\t\t\t\t\t\tv += '/';\n\n\t\t\t\t\tbase = v ? v.match(/.*\\//)[0] : ''; // Get only directory\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfunction getBase(n) {\n\t\t\t\tif (n.src && /tiny_mce(|_gzip|_jquery|_prototype|_full)(_dev|_src)?.js/.test(n.src)) {\n\t\t\t\t\tif (/_(src|dev)\\.js/g.test(n.src))\n\t\t\t\t\t\tt.suffix = '_src';\n\n\t\t\t\t\tif ((p = n.src.indexOf('?')) != -1)\n\t\t\t\t\t\tt.query = n.src.substring(p + 1);\n\n\t\t\t\t\tt.baseURL = n.src.substring(0, n.src.lastIndexOf('/'));\n\n\t\t\t\t\t// If path to script is relative and a base href was found add that one infront\n\t\t\t\t\t// the src property will always be an absolute one on non IE browsers and IE 8\n\t\t\t\t\t// so this logic will basically only be executed on older IE versions\n\t\t\t\t\tif (base && t.baseURL.indexOf('://') == -1 && t.baseURL.indexOf('/') !== 0)\n\t\t\t\t\t\tt.baseURL = base + t.baseURL;\n\n\t\t\t\t\treturn t.baseURL;\n\t\t\t\t}\n\n\t\t\t\treturn null;\n\t\t\t};\n\n\t\t\t// Check document\n\t\t\tnl = d.getElementsByTagName('script');\n\t\t\tfor (i=0; i<nl.length; i++) {\n\t\t\t\tif (getBase(nl[i]))\n\t\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Check head\n\t\t\tn = d.getElementsByTagName('head')[0];\n\t\t\tif (n) {\n\t\t\t\tnl = n.getElementsByTagName('script');\n\t\t\t\tfor (i=0; i<nl.length; i++) {\n\t\t\t\t\tif (getBase(nl[i]))\n\t\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn;\n\t\t},\n\n\t\tis : function(o, t) {\n\t\t\tif (!t)\n\t\t\t\treturn o !== undefined;\n\n\t\t\tif (t == 'array' && (o.hasOwnProperty && o instanceof Array))\n\t\t\t\treturn true;\n\n\t\t\treturn typeof(o) == t;\n\t\t},\n\n\t\tmakeMap : function(items, delim, map) {\n\t\t\tvar i;\n\n\t\t\titems = items || [];\n\t\t\tdelim = delim || ',';\n\n\t\t\tif (typeof(items) == \"string\")\n\t\t\t\titems = items.split(delim);\n\n\t\t\tmap = map || {};\n\n\t\t\ti = items.length;\n\t\t\twhile (i--)\n\t\t\t\tmap[items[i]] = {};\n\n\t\t\treturn map;\n\t\t},\n\n\t\teach : function(o, cb, s) {\n\t\t\tvar n, l;\n\n\t\t\tif (!o)\n\t\t\t\treturn 0;\n\n\t\t\ts = s || o;\n\n\t\t\tif (o.length !== undefined) {\n\t\t\t\t// Indexed arrays, needed for Safari\n\t\t\t\tfor (n=0, l = o.length; n < l; n++) {\n\t\t\t\t\tif (cb.call(s, o[n], n, o) === false)\n\t\t\t\t\t\treturn 0;\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Hashtables\n\t\t\t\tfor (n in o) {\n\t\t\t\t\tif (o.hasOwnProperty(n)) {\n\t\t\t\t\t\tif (cb.call(s, o[n], n, o) === false)\n\t\t\t\t\t\t\treturn 0;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn 1;\n\t\t},\n\n\n\t\tmap : function(a, f) {\n\t\t\tvar o = [];\n\n\t\t\ttinymce.each(a, function(v) {\n\t\t\t\to.push(f(v));\n\t\t\t});\n\n\t\t\treturn o;\n\t\t},\n\n\t\tgrep : function(a, f) {\n\t\t\tvar o = [];\n\n\t\t\ttinymce.each(a, function(v) {\n\t\t\t\tif (!f || f(v))\n\t\t\t\t\to.push(v);\n\t\t\t});\n\n\t\t\treturn o;\n\t\t},\n\n\t\tinArray : function(a, v) {\n\t\t\tvar i, l;\n\n\t\t\tif (a) {\n\t\t\t\tfor (i = 0, l = a.length; i < l; i++) {\n\t\t\t\t\tif (a[i] === v)\n\t\t\t\t\t\treturn i;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn -1;\n\t\t},\n\n\t\textend : function(o, e) {\n\t\t\tvar i, l, a = arguments;\n\n\t\t\tfor (i = 1, l = a.length; i < l; i++) {\n\t\t\t\te = a[i];\n\n\t\t\t\ttinymce.each(e, function(v, n) {\n\t\t\t\t\tif (v !== undefined)\n\t\t\t\t\t\to[n] = v;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn o;\n\t\t},\n\n\n\t\ttrim : function(s) {\n\t\t\treturn (s ? '' + s : '').replace(whiteSpaceRe, '');\n\t\t},\n\n\t\tcreate : function(s, p, root) {\n\t\t\tvar t = this, sp, ns, cn, scn, c, de = 0;\n\n\t\t\t// Parse : <prefix> <class>:<super class>\n\t\t\ts = /^((static) )?([\\w.]+)(:([\\w.]+))?/.exec(s);\n\t\t\tcn = s[3].match(/(^|\\.)(\\w+)$/i)[2]; // Class name\n\n\t\t\t// Create namespace for new class\n\t\t\tns = t.createNS(s[3].replace(/\\.\\w+$/, ''), root);\n\n\t\t\t// Class already exists\n\t\t\tif (ns[cn])\n\t\t\t\treturn;\n\n\t\t\t// Make pure static class\n\t\t\tif (s[2] == 'static') {\n\t\t\t\tns[cn] = p;\n\n\t\t\t\tif (this.onCreate)\n\t\t\t\t\tthis.onCreate(s[2], s[3], ns[cn]);\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Create default constructor\n\t\t\tif (!p[cn]) {\n\t\t\t\tp[cn] = function() {};\n\t\t\t\tde = 1;\n\t\t\t}\n\n\t\t\t// Add constructor and methods\n\t\t\tns[cn] = p[cn];\n\t\t\tt.extend(ns[cn].prototype, p);\n\n\t\t\t// Extend\n\t\t\tif (s[5]) {\n\t\t\t\tsp = t.resolve(s[5]).prototype;\n\t\t\t\tscn = s[5].match(/\\.(\\w+)$/i)[1]; // Class name\n\n\t\t\t\t// Extend constructor\n\t\t\t\tc = ns[cn];\n\t\t\t\tif (de) {\n\t\t\t\t\t// Add passthrough constructor\n\t\t\t\t\tns[cn] = function() {\n\t\t\t\t\t\treturn sp[scn].apply(this, arguments);\n\t\t\t\t\t};\n\t\t\t\t} else {\n\t\t\t\t\t// Add inherit constructor\n\t\t\t\t\tns[cn] = function() {\n\t\t\t\t\t\tthis.parent = sp[scn];\n\t\t\t\t\t\treturn c.apply(this, arguments);\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t\tns[cn].prototype[cn] = ns[cn];\n\n\t\t\t\t// Add super methods\n\t\t\t\tt.each(sp, function(f, n) {\n\t\t\t\t\tns[cn].prototype[n] = sp[n];\n\t\t\t\t});\n\n\t\t\t\t// Add overridden methods\n\t\t\t\tt.each(p, function(f, n) {\n\t\t\t\t\t// Extend methods if needed\n\t\t\t\t\tif (sp[n]) {\n\t\t\t\t\t\tns[cn].prototype[n] = function() {\n\t\t\t\t\t\t\tthis.parent = sp[n];\n\t\t\t\t\t\t\treturn f.apply(this, arguments);\n\t\t\t\t\t\t};\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif (n != cn)\n\t\t\t\t\t\t\tns[cn].prototype[n] = f;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Add static methods\n\t\t\tt.each(p['static'], function(f, n) {\n\t\t\t\tns[cn][n] = f;\n\t\t\t});\n\n\t\t\tif (this.onCreate)\n\t\t\t\tthis.onCreate(s[2], s[3], ns[cn].prototype);\n\t\t},\n\n\t\twalk : function(o, f, n, s) {\n\t\t\ts = s || this;\n\n\t\t\tif (o) {\n\t\t\t\tif (n)\n\t\t\t\t\to = o[n];\n\n\t\t\t\ttinymce.each(o, function(o, i) {\n\t\t\t\t\tif (f.call(s, o, i, n) === false)\n\t\t\t\t\t\treturn false;\n\n\t\t\t\t\ttinymce.walk(o, f, n, s);\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\tcreateNS : function(n, o) {\n\t\t\tvar i, v;\n\n\t\t\to = o || win;\n\n\t\t\tn = n.split('.');\n\t\t\tfor (i=0; i<n.length; i++) {\n\t\t\t\tv = n[i];\n\n\t\t\t\tif (!o[v])\n\t\t\t\t\to[v] = {};\n\n\t\t\t\to = o[v];\n\t\t\t}\n\n\t\t\treturn o;\n\t\t},\n\n\t\tresolve : function(n, o) {\n\t\t\tvar i, l;\n\n\t\t\to = o || win;\n\n\t\t\tn = n.split('.');\n\t\t\tfor (i = 0, l = n.length; i < l; i++) {\n\t\t\t\to = o[n[i]];\n\n\t\t\t\tif (!o)\n\t\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\treturn o;\n\t\t},\n\n\t\taddUnload : function(f, s) {\n\t\t\tvar t = this;\n\n\t\t\tf = {func : f, scope : s || this};\n\n\t\t\tif (!t.unloads) {\n\t\t\t\tfunction unload() {\n\t\t\t\t\tvar li = t.unloads, o, n;\n\n\t\t\t\t\tif (li) {\n\t\t\t\t\t\t// Call unload handlers\n\t\t\t\t\t\tfor (n in li) {\n\t\t\t\t\t\t\to = li[n];\n\n\t\t\t\t\t\t\tif (o && o.func)\n\t\t\t\t\t\t\t\to.func.call(o.scope, 1); // Send in one arg to distinct unload and user destroy\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Detach unload function\n\t\t\t\t\t\tif (win.detachEvent) {\n\t\t\t\t\t\t\twin.detachEvent('onbeforeunload', fakeUnload);\n\t\t\t\t\t\t\twin.detachEvent('onunload', unload);\n\t\t\t\t\t\t} else if (win.removeEventListener)\n\t\t\t\t\t\t\twin.removeEventListener('unload', unload, false);\n\n\t\t\t\t\t\t// Destroy references\n\t\t\t\t\t\tt.unloads = o = li = w = unload = 0;\n\n\t\t\t\t\t\t// Run garbarge collector on IE\n\t\t\t\t\t\tif (win.CollectGarbage)\n\t\t\t\t\t\t\tCollectGarbage();\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\tfunction fakeUnload() {\n\t\t\t\t\tvar d = document;\n\n\t\t\t\t\t// Is there things still loading, then do some magic\n\t\t\t\t\tif (d.readyState == 'interactive') {\n\t\t\t\t\t\tfunction stop() {\n\t\t\t\t\t\t\t// Prevent memory leak\n\t\t\t\t\t\t\td.detachEvent('onstop', stop);\n\n\t\t\t\t\t\t\t// Call unload handler\n\t\t\t\t\t\t\tif (unload)\n\t\t\t\t\t\t\t\tunload();\n\n\t\t\t\t\t\t\td = 0;\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\t// Fire unload when the currently loading page is stopped\n\t\t\t\t\t\tif (d)\n\t\t\t\t\t\t\td.attachEvent('onstop', stop);\n\n\t\t\t\t\t\t// Remove onstop listener after a while to prevent the unload function\n\t\t\t\t\t\t// to execute if the user presses cancel in an onbeforeunload\n\t\t\t\t\t\t// confirm dialog and then presses the browser stop button\n\t\t\t\t\t\twin.setTimeout(function() {\n\t\t\t\t\t\t\tif (d)\n\t\t\t\t\t\t\t\td.detachEvent('onstop', stop);\n\t\t\t\t\t\t}, 0);\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\t// Attach unload handler\n\t\t\t\tif (win.attachEvent) {\n\t\t\t\t\twin.attachEvent('onunload', unload);\n\t\t\t\t\twin.attachEvent('onbeforeunload', fakeUnload);\n\t\t\t\t} else if (win.addEventListener)\n\t\t\t\t\twin.addEventListener('unload', unload, false);\n\n\t\t\t\t// Setup initial unload handler array\n\t\t\t\tt.unloads = [f];\n\t\t\t} else\n\t\t\t\tt.unloads.push(f);\n\n\t\t\treturn f;\n\t\t},\n\n\t\tremoveUnload : function(f) {\n\t\t\tvar u = this.unloads, r = null;\n\n\t\t\ttinymce.each(u, function(o, i) {\n\t\t\t\tif (o && o.func == f) {\n\t\t\t\t\tu.splice(i, 1);\n\t\t\t\t\tr = f;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn r;\n\t\t},\n\n\t\texplode : function(s, d) {\n\t\t\treturn s ? tinymce.map(s.split(d || ','), tinymce.trim) : s;\n\t\t},\n\n\t\t_addVer : function(u) {\n\t\t\tvar v;\n\n\t\t\tif (!this.query)\n\t\t\t\treturn u;\n\n\t\t\tv = (u.indexOf('?') == -1 ? '?' : '&') + this.query;\n\n\t\t\tif (u.indexOf('#') == -1)\n\t\t\t\treturn u + v;\n\n\t\t\treturn u.replace('#', v + '#');\n\t\t},\n\n\t\t// Fix function for IE 9 where regexps isn't working correctly\n\t\t// Todo: remove me once MS fixes the bug\n\t\t_replace : function(find, replace, str) {\n\t\t\t// On IE9 we have to fake $x replacement\n\t\t\tif (isRegExpBroken) {\n\t\t\t\treturn str.replace(find, function() {\n\t\t\t\t\tvar val = replace, args = arguments, i;\n\n\t\t\t\t\tfor (i = 0; i < args.length - 2; i++) {\n\t\t\t\t\t\tif (args[i] === undefined) {\n\t\t\t\t\t\t\tval = val.replace(new RegExp('\\\\$' + i, 'g'), '');\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tval = val.replace(new RegExp('\\\\$' + i, 'g'), args[i]);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn val;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn str.replace(find, replace);\n\t\t}\n\n\t\t};\n\n\t// Initialize the API\n\ttinymce._init();\n\n\t// Expose tinymce namespace to the global namespace (window)\n\twin.tinymce = win.tinyMCE = tinymce;\n\n\t// Describe the different namespaces\n\n\t})(window);\n\n\n\n(function() {\n\tif (!window.Prototype)\n\t\treturn alert(\"Load prototype first!\");\n\n\t// Patch in core NS functions\n\ttinymce.extend(tinymce, {\n\t\ttrim : function(s) {return s ? s.strip() : '';},\n\t\tinArray : function(a, v) {return a && a.indexOf ? a.indexOf(v) : -1;}\n\t});\n\n\t// Patch in functions in various clases\n\t// Add a \"#ifndefjquery\" statement around each core API function you add below\n\tvar patches = {\n\t\t'tinymce.util.JSON' : {\n\t\t\t/*serialize : function(o) {\n\t\t\t\treturn o.toJSON();\n\t\t\t}*/\n\t\t},\n\t};\n\n\t// Patch functions after a class is created\n\ttinymce.onCreate = function(ty, c, p) {\n\t\ttinymce.extend(p, patches[c]);\n\t};\n})();\n\n\ntinymce.create('tinymce.util.Dispatcher', {\n\tscope : null,\n\tlisteners : null,\n\n\tDispatcher : function(s) {\n\t\tthis.scope = s || this;\n\t\tthis.listeners = [];\n\t},\n\n\tadd : function(cb, s) {\n\t\tthis.listeners.push({cb : cb, scope : s || this.scope});\n\n\t\treturn cb;\n\t},\n\n\taddToTop : function(cb, s) {\n\t\tthis.listeners.unshift({cb : cb, scope : s || this.scope});\n\n\t\treturn cb;\n\t},\n\n\tremove : function(cb) {\n\t\tvar l = this.listeners, o = null;\n\n\t\ttinymce.each(l, function(c, i) {\n\t\t\tif (cb == c.cb) {\n\t\t\t\to = cb;\n\t\t\t\tl.splice(i, 1);\n\t\t\t\treturn false;\n\t\t\t}\n\t\t});\n\n\t\treturn o;\n\t},\n\n\tdispatch : function() {\n\t\tvar s, a = arguments, i, li = this.listeners, c;\n\n\t\t// Needs to be a real loop since the listener count might change while looping\n\t\t// And this is also more efficient\n\t\tfor (i = 0; i<li.length; i++) {\n\t\t\tc = li[i];\n\t\t\ts = c.cb.apply(c.scope, a);\n\n\t\t\tif (s === false)\n\t\t\t\tbreak;\n\t\t}\n\n\t\treturn s;\n\t}\n\n\t});\n\n(function() {\n\tvar each = tinymce.each;\n\n\ttinymce.create('tinymce.util.URI', {\n\t\tURI : function(u, s) {\n\t\t\tvar t = this, o, a, b, base_url;\n\n\t\t\t// Trim whitespace\n\t\t\tu = tinymce.trim(u);\n\n\t\t\t// Default settings\n\t\t\ts = t.settings = s || {};\n\n\t\t\t// Strange app protocol that isn't http/https or local anchor\n\t\t\t// For example: mailto,skype,tel etc.\n\t\t\tif (/^([\\w\\-]+):([^\\/]{2})/i.test(u) || /^\\s*#/.test(u)) {\n\t\t\t\tt.source = u;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Absolute path with no host, fake host and protocol\n\t\t\tif (u.indexOf('/') === 0 && u.indexOf('//') !== 0)\n\t\t\t\tu = (s.base_uri ? s.base_uri.protocol || 'http' : 'http') + '://mce_host' + u;\n\n\t\t\t// Relative path http:// or protocol relative //path\n\t\t\tif (!/^[\\w-]*:?\\/\\//.test(u)) {\n\t\t\t\tbase_url = s.base_uri ? s.base_uri.path : new tinymce.util.URI(location.href).directory;\n\t\t\t\tu = ((s.base_uri && s.base_uri.protocol) || 'http') + '://mce_host' + t.toAbsPath(base_url, u);\n\t\t\t}\n\n\t\t\t// Parse URL (Credits goes to Steave, http://blog.stevenlevithan.com/archives/parseuri)\n\t\t\tu = u.replace(/@@/g, '(mce_at)'); // Zope 3 workaround, they use @@something\n\t\t\tu = /^(?:(?![^:@]+:[^:@\\/]*@)([^:\\/?#.]+):)?(?:\\/\\/)?((?:(([^:@]*):?([^:@]*))?@)?([^:\\/?#]*)(?::(\\d*))?)(((\\/(?:[^?#](?![^?#\\/]*\\.[^?#\\/.]+(?:[?#]|$)))*\\/?)?([^?#\\/]*))(?:\\?([^#]*))?(?:#(.*))?)/.exec(u);\n\t\t\teach([\"source\",\"protocol\",\"authority\",\"userInfo\",\"user\",\"password\",\"host\",\"port\",\"relative\",\"path\",\"directory\",\"file\",\"query\",\"anchor\"], function(v, i) {\n\t\t\t\tvar s = u[i];\n\n\t\t\t\t// Zope 3 workaround, they use @@something\n\t\t\t\tif (s)\n\t\t\t\t\ts = s.replace(/\\(mce_at\\)/g, '@@');\n\n\t\t\t\tt[v] = s;\n\t\t\t});\n\n\t\t\tif (b = s.base_uri) {\n\t\t\t\tif (!t.protocol)\n\t\t\t\t\tt.protocol = b.protocol;\n\n\t\t\t\tif (!t.userInfo)\n\t\t\t\t\tt.userInfo = b.userInfo;\n\n\t\t\t\tif (!t.port && t.host == 'mce_host')\n\t\t\t\t\tt.port = b.port;\n\n\t\t\t\tif (!t.host || t.host == 'mce_host')\n\t\t\t\t\tt.host = b.host;\n\n\t\t\t\tt.source = '';\n\t\t\t}\n\n\t\t\t//t.path = t.path || '/';\n\t\t},\n\n\t\tsetPath : function(p) {\n\t\t\tvar t = this;\n\n\t\t\tp = /^(.*?)\\/?(\\w+)?$/.exec(p);\n\n\t\t\t// Update path parts\n\t\t\tt.path = p[0];\n\t\t\tt.directory = p[1];\n\t\t\tt.file = p[2];\n\n\t\t\t// Rebuild source\n\t\t\tt.source = '';\n\t\t\tt.getURI();\n\t\t},\n\n\t\ttoRelative : function(u) {\n\t\t\tvar t = this, o;\n\n\t\t\tif (u === \"./\")\n\t\t\t\treturn u;\n\n\t\t\tu = new tinymce.util.URI(u, {base_uri : t});\n\n\t\t\t// Not on same domain/port or protocol\n\t\t\tif ((u.host != 'mce_host' && t.host != u.host && u.host) || t.port != u.port || t.protocol != u.protocol)\n\t\t\t\treturn u.getURI();\n\n\t\t\to = t.toRelPath(t.path, u.path);\n\n\t\t\t// Add query\n\t\t\tif (u.query)\n\t\t\t\to += '?' + u.query;\n\n\t\t\t// Add anchor\n\t\t\tif (u.anchor)\n\t\t\t\to += '#' + u.anchor;\n\n\t\t\treturn o;\n\t\t},\n\t\n\t\ttoAbsolute : function(u, nh) {\n\t\t\tvar u = new tinymce.util.URI(u, {base_uri : this});\n\n\t\t\treturn u.getURI(this.host == u.host && this.protocol == u.protocol ? nh : 0);\n\t\t},\n\n\t\ttoRelPath : function(base, path) {\n\t\t\tvar items, bp = 0, out = '', i, l;\n\n\t\t\t// Split the paths\n\t\t\tbase = base.substring(0, base.lastIndexOf('/'));\n\t\t\tbase = base.split('/');\n\t\t\titems = path.split('/');\n\n\t\t\tif (base.length >= items.length) {\n\t\t\t\tfor (i = 0, l = base.length; i < l; i++) {\n\t\t\t\t\tif (i >= items.length || base[i] != items[i]) {\n\t\t\t\t\t\tbp = i + 1;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (base.length < items.length) {\n\t\t\t\tfor (i = 0, l = items.length; i < l; i++) {\n\t\t\t\t\tif (i >= base.length || base[i] != items[i]) {\n\t\t\t\t\t\tbp = i + 1;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (bp == 1)\n\t\t\t\treturn path;\n\n\t\t\tfor (i = 0, l = base.length - (bp - 1); i < l; i++)\n\t\t\t\tout += \"../\";\n\n\t\t\tfor (i = bp - 1, l = items.length; i < l; i++) {\n\t\t\t\tif (i != bp - 1)\n\t\t\t\t\tout += \"/\" + items[i];\n\t\t\t\telse\n\t\t\t\t\tout += items[i];\n\t\t\t}\n\n\t\t\treturn out;\n\t\t},\n\n\t\ttoAbsPath : function(base, path) {\n\t\t\tvar i, nb = 0, o = [], tr, outPath;\n\n\t\t\t// Split paths\n\t\t\ttr = /\\/$/.test(path) ? '/' : '';\n\t\t\tbase = base.split('/');\n\t\t\tpath = path.split('/');\n\n\t\t\t// Remove empty chunks\n\t\t\teach(base, function(k) {\n\t\t\t\tif (k)\n\t\t\t\t\to.push(k);\n\t\t\t});\n\n\t\t\tbase = o;\n\n\t\t\t// Merge relURLParts chunks\n\t\t\tfor (i = path.length - 1, o = []; i >= 0; i--) {\n\t\t\t\t// Ignore empty or .\n\t\t\t\tif (path[i].length == 0 || path[i] == \".\")\n\t\t\t\t\tcontinue;\n\n\t\t\t\t// Is parent\n\t\t\t\tif (path[i] == '..') {\n\t\t\t\t\tnb++;\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\t// Move up\n\t\t\t\tif (nb > 0) {\n\t\t\t\t\tnb--;\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\to.push(path[i]);\n\t\t\t}\n\n\t\t\ti = base.length - nb;\n\n\t\t\t// If /a/b/c or /\n\t\t\tif (i <= 0)\n\t\t\t\toutPath = o.reverse().join('/');\n\t\t\telse\n\t\t\t\toutPath = base.slice(0, i).join('/') + '/' + o.reverse().join('/');\n\n\t\t\t// Add front / if it's needed\n\t\t\tif (outPath.indexOf('/') !== 0)\n\t\t\t\toutPath = '/' + outPath;\n\n\t\t\t// Add traling / if it's needed\n\t\t\tif (tr && outPath.lastIndexOf('/') !== outPath.length - 1)\n\t\t\t\toutPath += tr;\n\n\t\t\treturn outPath;\n\t\t},\n\n\t\tgetURI : function(nh) {\n\t\t\tvar s, t = this;\n\n\t\t\t// Rebuild source\n\t\t\tif (!t.source || nh) {\n\t\t\t\ts = '';\n\n\t\t\t\tif (!nh) {\n\t\t\t\t\tif (t.protocol)\n\t\t\t\t\t\ts += t.protocol + '://';\n\n\t\t\t\t\tif (t.userInfo)\n\t\t\t\t\t\ts += t.userInfo + '@';\n\n\t\t\t\t\tif (t.host)\n\t\t\t\t\t\ts += t.host;\n\n\t\t\t\t\tif (t.port)\n\t\t\t\t\t\ts += ':' + t.port;\n\t\t\t\t}\n\n\t\t\t\tif (t.path)\n\t\t\t\t\ts += t.path;\n\n\t\t\t\tif (t.query)\n\t\t\t\t\ts += '?' + t.query;\n\n\t\t\t\tif (t.anchor)\n\t\t\t\t\ts += '#' + t.anchor;\n\n\t\t\t\tt.source = s;\n\t\t\t}\n\n\t\t\treturn t.source;\n\t\t}\n\t});\n})();\n\n(function() {\n\tvar each = tinymce.each;\n\n\ttinymce.create('static tinymce.util.Cookie', {\n\t\tgetHash : function(n) {\n\t\t\tvar v = this.get(n), h;\n\n\t\t\tif (v) {\n\t\t\t\teach(v.split('&'), function(v) {\n\t\t\t\t\tv = v.split('=');\n\t\t\t\t\th = h || {};\n\t\t\t\t\th[unescape(v[0])] = unescape(v[1]);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn h;\n\t\t},\n\n\t\tsetHash : function(n, v, e, p, d, s) {\n\t\t\tvar o = '';\n\n\t\t\teach(v, function(v, k) {\n\t\t\t\to += (!o ? '' : '&') + escape(k) + '=' + escape(v);\n\t\t\t});\n\n\t\t\tthis.set(n, o, e, p, d, s);\n\t\t},\n\n\t\tget : function(n) {\n\t\t\tvar c = document.cookie, e, p = n + \"=\", b;\n\n\t\t\t// Strict mode\n\t\t\tif (!c)\n\t\t\t\treturn;\n\n\t\t\tb = c.indexOf(\"; \" + p);\n\n\t\t\tif (b == -1) {\n\t\t\t\tb = c.indexOf(p);\n\n\t\t\t\tif (b != 0)\n\t\t\t\t\treturn null;\n\t\t\t} else\n\t\t\t\tb += 2;\n\n\t\t\te = c.indexOf(\";\", b);\n\n\t\t\tif (e == -1)\n\t\t\t\te = c.length;\n\n\t\t\treturn unescape(c.substring(b + p.length, e));\n\t\t},\n\n\t\tset : function(n, v, e, p, d, s) {\n\t\t\tdocument.cookie = n + \"=\" + escape(v) +\n\t\t\t\t((e) ? \"; expires=\" + e.toUTCString() : \"\") +\n\t\t\t\t((p) ? \"; path=\" + escape(p) : \"\") +\n\t\t\t\t((d) ? \"; domain=\" + d : \"\") +\n\t\t\t\t((s) ? \"; secure\" : \"\");\n\t\t},\n\n\t\tremove : function(n, p) {\n\t\t\tvar d = new Date();\n\n\t\t\td.setTime(d.getTime() - 1000);\n\n\t\t\tthis.set(n, '', d, p, d);\n\t\t}\n\t});\n})();\n\n(function() {\n\tfunction serialize(o, quote) {\n\t\tvar i, v, t;\n\n\t\tquote = quote || '\"';\n\n\t\tif (o == null)\n\t\t\treturn 'null';\n\n\t\tt = typeof o;\n\n\t\tif (t == 'string') {\n\t\t\tv = '\\bb\\tt\\nn\\ff\\rr\\\"\"\\'\\'\\\\\\\\';\n\n\t\t\treturn quote + o.replace(/([\\u0080-\\uFFFF\\x00-\\x1f\\\"\\'\\\\])/g, function(a, b) {\n\t\t\t\t// Make sure single quotes never get encoded inside double quotes for JSON compatibility\n\t\t\t\tif (quote === '\"' && a === \"'\")\n\t\t\t\t\treturn a;\n\n\t\t\t\ti = v.indexOf(b);\n\n\t\t\t\tif (i + 1)\n\t\t\t\t\treturn '\\\\' + v.charAt(i + 1);\n\n\t\t\t\ta = b.charCodeAt().toString(16);\n\n\t\t\t\treturn '\\\\u' + '0000'.substring(a.length) + a;\n\t\t\t}) + quote;\n\t\t}\n\n\t\tif (t == 'object') {\n\t\t\tif (o.hasOwnProperty && o instanceof Array) {\n\t\t\t\t\tfor (i=0, v = '['; i<o.length; i++)\n\t\t\t\t\t\tv += (i > 0 ? ',' : '') + serialize(o[i], quote);\n\n\t\t\t\t\treturn v + ']';\n\t\t\t\t}\n\n\t\t\t\tv = '{';\n\n\t\t\t\tfor (i in o) {\n\t\t\t\t\tif (o.hasOwnProperty(i)) {\n\t\t\t\t\t\tv += typeof o[i] != 'function' ? (v.length > 1 ? ',' + quote : quote) + i + quote +':' + serialize(o[i], quote) : '';\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn v + '}';\n\t\t}\n\n\t\treturn '' + o;\n\t};\n\n\ttinymce.util.JSON = {\n\t\tserialize: serialize,\n\n\t\tparse: function(s) {\n\t\t\ttry {\n\t\t\t\treturn JSON.parse(s);\n\t\t\t} catch (ex) {\n\t\t\t\t// Ignore\n\t\t\t}\n\t\t}\n\n\t\t};\n})();\n\ntinymce.create('static tinymce.util.XHR', {\n\tsend : function(o) {\n\t\tvar x, t, w = window, c = 0;\n\n\t\t// Default settings\n\t\to.scope = o.scope || this;\n\t\to.success_scope = o.success_scope || o.scope;\n\t\to.error_scope = o.error_scope || o.scope;\n\t\to.async = o.async === false ? false : true;\n\t\to.data = o.data || '';\n\n\t\tfunction get(s) {\n\t\t\tx = 0;\n\n\t\t\ttry {\n\t\t\t\tx = new ActiveXObject(s);\n\t\t\t} catch (ex) {\n\t\t\t}\n\n\t\t\treturn x;\n\t\t};\n\n\t\tx = w.XMLHttpRequest ? new XMLHttpRequest() : get('Microsoft.XMLHTTP') || get('Msxml2.XMLHTTP');\n\n\t\tif (x) {\n\t\t\tif (x.overrideMimeType)\n\t\t\t\tx.overrideMimeType(o.content_type);\n\n\t\t\tx.open(o.type || (o.data ? 'POST' : 'GET'), o.url, o.async);\n\n\t\t\tif (o.content_type)\n\t\t\t\tx.setRequestHeader('Content-Type', o.content_type);\n\n\t\t\tx.setRequestHeader('X-Requested-With', 'XMLHttpRequest');\n\n\t\t\tx.send(o.data);\n\n\t\t\tfunction ready() {\n\t\t\t\tif (!o.async || x.readyState == 4 || c++ > 10000) {\n\t\t\t\t\tif (o.success && c < 10000 && x.status == 200)\n\t\t\t\t\t\to.success.call(o.success_scope, '' + x.responseText, x, o);\n\t\t\t\t\telse if (o.error)\n\t\t\t\t\t\to.error.call(o.error_scope, c > 10000 ? 'TIMED_OUT' : 'GENERAL', x, o);\n\n\t\t\t\t\tx = null;\n\t\t\t\t} else\n\t\t\t\t\tw.setTimeout(ready, 10);\n\t\t\t};\n\n\t\t\t// Syncronous request\n\t\t\tif (!o.async)\n\t\t\t\treturn ready();\n\n\t\t\t// Wait for response, onReadyStateChange can not be used since it leaks memory in IE\n\t\t\tt = w.setTimeout(ready, 10);\n\t\t}\n\t}\n});\n\n(function() {\n\tvar extend = tinymce.extend, JSON = tinymce.util.JSON, XHR = tinymce.util.XHR;\n\n\ttinymce.create('tinymce.util.JSONRequest', {\n\t\tJSONRequest : function(s) {\n\t\t\tthis.settings = extend({\n\t\t\t}, s);\n\t\t\tthis.count = 0;\n\t\t},\n\n\t\tsend : function(o) {\n\t\t\tvar ecb = o.error, scb = o.success;\n\n\t\t\to = extend(this.settings, o);\n\n\t\t\to.success = function(c, x) {\n\t\t\t\tc = JSON.parse(c);\n\n\t\t\t\tif (typeof(c) == 'undefined') {\n\t\t\t\t\tc = {\n\t\t\t\t\t\terror : 'JSON Parse error.'\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\tif (c.error)\n\t\t\t\t\tecb.call(o.error_scope || o.scope, c.error, x);\n\t\t\t\telse\n\t\t\t\t\tscb.call(o.success_scope || o.scope, c.result);\n\t\t\t};\n\n\t\t\to.error = function(ty, x) {\n\t\t\t\tif (ecb)\n\t\t\t\t\tecb.call(o.error_scope || o.scope, ty, x);\n\t\t\t};\n\n\t\t\to.data = JSON.serialize({\n\t\t\t\tid : o.id || 'c' + (this.count++),\n\t\t\t\tmethod : o.method,\n\t\t\t\tparams : o.params\n\t\t\t});\n\n\t\t\t// JSON content type for Ruby on rails. Bug: #1883287\n\t\t\to.content_type = 'application/json';\n\n\t\t\tXHR.send(o);\n\t\t},\n\n\t\t'static' : {\n\t\t\tsendRPC : function(o) {\n\t\t\t\treturn new tinymce.util.JSONRequest().send(o);\n\t\t\t}\n\t\t}\n\t});\n}());\n(function(tinymce){\n\ttinymce.VK = {\n\t\tDELETE: 46,\n\t\tBACKSPACE: 8,\n\t\tENTER: 13,\n\t\tTAB: 9,\n        SPACEBAR: 32,\n\t\tUP: 38,\n\t\tDOWN: 40\n\t}\n})(tinymce);\n\n(function(tinymce) {\n\tvar VK = tinymce.VK, BACKSPACE = VK.BACKSPACE, DELETE = VK.DELETE;\n\n\tfunction cleanupStylesWhenDeleting(ed) {\n\t\tvar dom = ed.dom, selection = ed.selection;\n\n\t\ted.onKeyDown.add(function(ed, e) {\n\t\t\tvar rng, blockElm, node, clonedSpan, isDelete;\n\n\t\t\tisDelete = e.keyCode == DELETE;\n\t\t\tif (isDelete || e.keyCode == BACKSPACE) {\n\t\t\t\te.preventDefault();\n\t\t\t\trng = selection.getRng();\n\n\t\t\t\t// Find root block\n\t\t\t\tblockElm = dom.getParent(rng.startContainer, dom.isBlock);\n\n\t\t\t\t// On delete clone the root span of the next block element\n\t\t\t\tif (isDelete)\n\t\t\t\t\tblockElm = dom.getNext(blockElm, dom.isBlock);\n\n\t\t\t\t// Locate root span element and clone it since it would otherwise get merged by the \"apple-style-span\" on delete/backspace\n\t\t\t\tif (blockElm) {\n\t\t\t\t\tnode = blockElm.firstChild;\n\n\t\t\t\t\t// Ignore empty text nodes\n\t\t\t\t\twhile (node && node.nodeType == 3 && node.nodeValue.length == 0)\n\t\t\t\t\t\tnode = node.nextSibling;\n\n\t\t\t\t\tif (node && node.nodeName === 'SPAN') {\n\t\t\t\t\t\tclonedSpan = node.cloneNode(false);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Do the backspace/delete actiopn\n\t\t\t\ted.getDoc().execCommand(isDelete ? 'ForwardDelete' : 'Delete', false, null);\n\n\t\t\t\t// Find all odd apple-style-spans\n\t\t\t\tblockElm = dom.getParent(rng.startContainer, dom.isBlock);\n\t\t\t\ttinymce.each(dom.select('span.Apple-style-span,font.Apple-style-span', blockElm), function(span) {\n\t\t\t\t\tvar bm = selection.getBookmark();\n\n\t\t\t\t\tif (clonedSpan) {\n\t\t\t\t\t\tdom.replace(clonedSpan.cloneNode(false), span, true);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tdom.remove(span, true);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Restore the selection\n\t\t\t\t\tselection.moveToBookmark(bm);\n\t\t\t\t});\n\t\t\t}\n\t\t});\n\t};\n\n\tfunction emptyEditorWhenDeleting(ed) {\n\t\ted.onKeyUp.add(function(ed, e) {\n\t\t\tvar keyCode = e.keyCode;\n\n\t\t\tif (keyCode == DELETE || keyCode == BACKSPACE) {\n\t\t\t\tif (ed.dom.isEmpty(ed.getBody())) {\n\t\t\t\t\ted.setContent('', {format : 'raw'});\n\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t};\n\n\tfunction inputMethodFocus(ed) {\n\t\ted.dom.bind(ed.getDoc(), 'focusin', function() {\n\t\t\ted.selection.setRng(ed.selection.getRng());\n\t\t});\n\t};\n\n\tfunction removeHrOnBackspace(ed) {\n\t\ted.onKeyDown.add(function(ed, e) {\n\t\t\tif (e.keyCode === BACKSPACE) {\n\t\t\t\tif (ed.selection.isCollapsed() && ed.selection.getRng(true).startOffset === 0) {\n\t\t\t\t\tvar node = ed.selection.getNode();\n\t\t\t\t\tvar previousSibling = node.previousSibling;\n\t\t\t\t\tif (previousSibling && previousSibling.nodeName && previousSibling.nodeName.toLowerCase() === \"hr\") {\n\t\t\t\t\t\ted.dom.remove(previousSibling);\n\t\t\t\t\t\ttinymce.dom.Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t})\n\t}\n\n\tfunction focusBody(ed) {\n\t\t// Fix for a focus bug in FF 3.x where the body element\n\t\t// wouldn't get proper focus if the user clicked on the HTML element\n\t\tif (!Range.prototype.getClientRects) { // Detect getClientRects got introduced in FF 4\n\t\t\ted.onMouseDown.add(function(ed, e) {\n\t\t\t\tif (e.target.nodeName === \"HTML\") {\n\t\t\t\t\tvar body = ed.getBody();\n\n\t\t\t\t\t// Blur the body it's focused but not correctly focused\n\t\t\t\t\tbody.blur();\n\n\t\t\t\t\t// Refocus the body after a little while\n\t\t\t\t\tsetTimeout(function() {\n\t\t\t\t\t\tbody.focus();\n\t\t\t\t\t}, 0);\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t};\n\n\tfunction selectControlElements(ed) {\n\t\ted.onClick.add(function(ed, e) {\n\t\t\te = e.target;\n\n\t\t\tif (/^(IMG|HR)$/.test(e.nodeName))\n\t\t\t\ted.selection.select(e);\n\n\t\t\tif (e.nodeName == 'A' && ed.dom.hasClass(e, 'mceItemAnchor'))\n\t\t\t\ted.selection.select(e);\n\n\t\t\ted.nodeChanged();\n\t\t});\n\t};\n\n\tfunction selectionChangeNodeChanged(ed) {\n\t\tvar lastRng, selectionTimer;\n\n\t\ted.dom.bind(ed.getDoc(), 'selectionchange', function() {\n\t\t\tif (selectionTimer) {\n\t\t\t\tclearTimeout(selectionTimer);\n\t\t\t\tselectionTimer = 0;\n\t\t\t}\n\n\t\t\tselectionTimer = window.setTimeout(function() {\n\t\t\t\tvar rng = ed.selection.getRng();\n\n\t\t\t\t// Compare the ranges to see if it was a real change or not\n\t\t\t\tif (!lastRng || !tinymce.dom.RangeUtils.compareRanges(rng, lastRng)) {\n\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\tlastRng = rng;\n\t\t\t\t}\n\t\t\t}, 50);\n\t\t});\n\t}\n\n\tfunction ensureBodyHasRoleApplication(ed) {\n\t\tdocument.body.setAttribute(\"role\", \"application\");\n\t}\n\n\ttinymce.create('tinymce.util.Quirks', {\n\t\tQuirks: function(ed) {\n\t\t\t// WebKit\n\t\t\tif (tinymce.isWebKit) {\n\t\t\t\tcleanupStylesWhenDeleting(ed);\n\t\t\t\temptyEditorWhenDeleting(ed);\n\t\t\t\tinputMethodFocus(ed);\n\t\t\t\tselectControlElements(ed);\n\n\t\t\t\t// iOS\n\t\t\t\tif (tinymce.isIDevice) {\n\t\t\t\t\tselectionChangeNodeChanged(ed);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// IE\n\t\t\tif (tinymce.isIE) {\n\t\t\t\tremoveHrOnBackspace(ed);\n\t\t\t\temptyEditorWhenDeleting(ed);\n\t\t\t\tensureBodyHasRoleApplication(ed);\n\t\t\t}\n\n\t\t\t// Gecko\n\t\t\tif (tinymce.isGecko) {\n\t\t\t\tremoveHrOnBackspace(ed);\n\t\t\t\tfocusBody(ed);\n\t\t\t}\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar namedEntities, baseEntities, reverseEntities,\n\t\tattrsCharsRegExp = /[&<>\\\"\\u007E-\\uD7FF\\uE000-\\uFFEF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,\n\t\ttextCharsRegExp = /[<>&\\u007E-\\uD7FF\\uE000-\\uFFEF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,\n\t\trawCharsRegExp = /[<>&\\\"\\']/g,\n\t\tentityRegExp = /&(#x|#)?([\\w]+);/g,\n\t\tasciiMap = {\n\t\t\t\t128 : \"\\u20AC\", 130 : \"\\u201A\", 131 : \"\\u0192\", 132 : \"\\u201E\", 133 : \"\\u2026\", 134 : \"\\u2020\",\n\t\t\t\t135 : \"\\u2021\", 136 : \"\\u02C6\", 137 : \"\\u2030\", 138 : \"\\u0160\", 139 : \"\\u2039\", 140 : \"\\u0152\",\n\t\t\t\t142 : \"\\u017D\", 145 : \"\\u2018\", 146 : \"\\u2019\", 147 : \"\\u201C\", 148 : \"\\u201D\", 149 : \"\\u2022\",\n\t\t\t\t150 : \"\\u2013\", 151 : \"\\u2014\", 152 : \"\\u02DC\", 153 : \"\\u2122\", 154 : \"\\u0161\", 155 : \"\\u203A\",\n\t\t\t\t156 : \"\\u0153\", 158 : \"\\u017E\", 159 : \"\\u0178\"\n\t\t};\n\n\t// Raw entities\n\tbaseEntities = {\n\t\t'\\\"' : '&quot;', // Needs to be escaped since the YUI compressor would otherwise break the code\n\t\t\"'\" : '&#39;',\n\t\t'<' : '&lt;',\n\t\t'>' : '&gt;',\n\t\t'&' : '&amp;'\n\t};\n\n\t// Reverse lookup table for raw entities\n\treverseEntities = {\n\t\t'&lt;' : '<',\n\t\t'&gt;' : '>',\n\t\t'&amp;' : '&',\n\t\t'&quot;' : '\"',\n\t\t'&apos;' : \"'\"\n\t};\n\n\t// Decodes text by using the browser\n\tfunction nativeDecode(text) {\n\t\tvar elm;\n\n\t\telm = document.createElement(\"div\");\n\t\telm.innerHTML = text;\n\n\t\treturn elm.textContent || elm.innerText || text;\n\t};\n\n\t// Build a two way lookup table for the entities\n\tfunction buildEntitiesLookup(items, radix) {\n\t\tvar i, chr, entity, lookup = {};\n\n\t\tif (items) {\n\t\t\titems = items.split(',');\n\t\t\tradix = radix || 10;\n\n\t\t\t// Build entities lookup table\n\t\t\tfor (i = 0; i < items.length; i += 2) {\n\t\t\t\tchr = String.fromCharCode(parseInt(items[i], radix));\n\n\t\t\t\t// Only add non base entities\n\t\t\t\tif (!baseEntities[chr]) {\n\t\t\t\t\tentity = '&' + items[i + 1] + ';';\n\t\t\t\t\tlookup[chr] = entity;\n\t\t\t\t\tlookup[entity] = chr;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn lookup;\n\t\t}\n\t};\n\n\t// Unpack entities lookup where the numbers are in radix 32 to reduce the size\n\tnamedEntities = buildEntitiesLookup(\n\t\t'50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,' +\n\t\t'5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,' +\n\t\t'5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,' +\n\t\t'5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,' +\n\t\t'68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,' +\n\t\t'6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,' +\n\t\t'6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,' +\n\t\t'75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,' +\n\t\t'7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,' +\n\t\t'7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,' +\n\t\t'sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,' +\n\t\t'st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,' +\n\t\t't9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,' +\n\t\t'tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,' +\n\t\t'u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,' +\n\t\t'81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,' +\n\t\t'8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,' +\n\t\t'8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,' +\n\t\t'8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,' +\n\t\t'8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,' +\n\t\t'nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,' +\n\t\t'rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,' +\n\t\t'Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,' +\n\t\t'80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,' +\n\t\t'811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro'\n\t, 32);\n\n\ttinymce.html = tinymce.html || {};\n\n\ttinymce.html.Entities = {\n\t\tencodeRaw : function(text, attr) {\n\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\treturn baseEntities[chr] || chr;\n\t\t\t});\n\t\t},\n\n\t\tencodeAllRaw : function(text) {\n\t\t\treturn ('' + text).replace(rawCharsRegExp, function(chr) {\n\t\t\t\treturn baseEntities[chr] || chr;\n\t\t\t});\n\t\t},\n\n\t\tencodeNumeric : function(text, attr) {\n\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\t// Multi byte sequence convert it to a single entity\n\t\t\t\tif (chr.length > 1)\n\t\t\t\t\treturn '&#' + (((chr.charCodeAt(0) - 0xD800) * 0x400) + (chr.charCodeAt(1) - 0xDC00) + 0x10000) + ';';\n\n\t\t\t\treturn baseEntities[chr] || '&#' + chr.charCodeAt(0) + ';';\n\t\t\t});\n\t\t},\n\n\t\tencodeNamed : function(text, attr, entities) {\n\t\t\tentities = entities || namedEntities;\n\n\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\treturn baseEntities[chr] || entities[chr] || chr;\n\t\t\t});\n\t\t},\n\n\t\tgetEncodeFunc : function(name, entities) {\n\t\t\tvar Entities = tinymce.html.Entities;\n\n\t\t\tentities = buildEntitiesLookup(entities) || namedEntities;\n\n\t\t\tfunction encodeNamedAndNumeric(text, attr) {\n\t\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\t\treturn baseEntities[chr] || entities[chr] || '&#' + chr.charCodeAt(0) + ';' || chr;\n\t\t\t\t});\n\t\t\t};\n\n\t\t\tfunction encodeCustomNamed(text, attr) {\n\t\t\t\treturn Entities.encodeNamed(text, attr, entities);\n\t\t\t};\n\n\t\t\t// Replace + with , to be compatible with previous TinyMCE versions\n\t\t\tname = tinymce.makeMap(name.replace(/\\+/g, ','));\n\n\t\t\t// Named and numeric encoder\n\t\t\tif (name.named && name.numeric)\n\t\t\t\treturn encodeNamedAndNumeric;\n\n\t\t\t// Named encoder\n\t\t\tif (name.named) {\n\t\t\t\t// Custom names\n\t\t\t\tif (entities)\n\t\t\t\t\treturn encodeCustomNamed;\n\n\t\t\t\treturn Entities.encodeNamed;\n\t\t\t}\n\n\t\t\t// Numeric\n\t\t\tif (name.numeric)\n\t\t\t\treturn Entities.encodeNumeric;\n\n\t\t\t// Raw encoder\n\t\t\treturn Entities.encodeRaw;\n\t\t},\n\n\t\tdecode : function(text) {\n\t\t\treturn text.replace(entityRegExp, function(all, numeric, value) {\n\t\t\t\tif (numeric) {\n\t\t\t\t\tvalue = parseInt(value, numeric.length === 2 ? 16 : 10);\n\n\t\t\t\t\t// Support upper UTF\n\t\t\t\t\tif (value > 0xFFFF) {\n\t\t\t\t\t\tvalue -= 0x10000;\n\n\t\t\t\t\t\treturn String.fromCharCode(0xD800 + (value >> 10), 0xDC00 + (value & 0x3FF));\n\t\t\t\t\t} else\n\t\t\t\t\t\treturn asciiMap[value] || String.fromCharCode(value);\n\t\t\t\t}\n\n\t\t\t\treturn reverseEntities[all] || namedEntities[all] || nativeDecode(all);\n\t\t\t});\n\t\t}\n\t};\n})(tinymce);\n\ntinymce.html.Styles = function(settings, schema) {\n\tvar rgbRegExp = /rgb\\s*\\(\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*\\)/gi,\n\t\turlOrStrRegExp = /(?:url(?:(?:\\(\\s*\\\"([^\\\"]+)\\\"\\s*\\))|(?:\\(\\s*\\'([^\\']+)\\'\\s*\\))|(?:\\(\\s*([^)\\s]+)\\s*\\))))|(?:\\'([^\\']+)\\')|(?:\\\"([^\\\"]+)\\\")/gi,\n\t\tstyleRegExp = /\\s*([^:]+):\\s*([^;]+);?/g,\n\t\ttrimRightRegExp = /\\s+$/,\n\t\turlColorRegExp = /rgb/,\n\t\tundef, i, encodingLookup = {}, encodingItems;\n\n\tsettings = settings || {};\n\n\tencodingItems = '\\\\\" \\\\\\' \\\\; \\\\: ; : \\uFEFF'.split(' ');\n\tfor (i = 0; i < encodingItems.length; i++) {\n\t\tencodingLookup[encodingItems[i]] = '\\uFEFF' + i;\n\t\tencodingLookup['\\uFEFF' + i] = encodingItems[i];\n\t}\n\n\tfunction toHex(match, r, g, b) {\n\t\tfunction hex(val) {\n\t\t\tval = parseInt(val).toString(16);\n\n\t\t\treturn val.length > 1 ? val : '0' + val; // 0 -> 00\n\t\t};\n\n\t\treturn '#' + hex(r) + hex(g) + hex(b);\n\t};\n\n\treturn {\n\t\ttoHex : function(color) {\n\t\t\treturn color.replace(rgbRegExp, toHex);\n\t\t},\n\n\t\tparse : function(css) {\n\t\t\tvar styles = {}, matches, name, value, isEncoded, urlConverter = settings.url_converter, urlConverterScope = settings.url_converter_scope || this;\n\n\t\t\tfunction compress(prefix, suffix) {\n\t\t\t\tvar top, right, bottom, left;\n\n\t\t\t\t// Get values and check it needs compressing\n\t\t\t\ttop = styles[prefix + '-top' + suffix];\n\t\t\t\tif (!top)\n\t\t\t\t\treturn;\n\n\t\t\t\tright = styles[prefix + '-right' + suffix];\n\t\t\t\tif (top != right)\n\t\t\t\t\treturn;\n\n\t\t\t\tbottom = styles[prefix + '-bottom' + suffix];\n\t\t\t\tif (right != bottom)\n\t\t\t\t\treturn;\n\n\t\t\t\tleft = styles[prefix + '-left' + suffix];\n\t\t\t\tif (bottom != left)\n\t\t\t\t\treturn;\n\n\t\t\t\t// Compress\n\t\t\t\tstyles[prefix + suffix] = left;\n\t\t\t\tdelete styles[prefix + '-top' + suffix];\n\t\t\t\tdelete styles[prefix + '-right' + suffix];\n\t\t\t\tdelete styles[prefix + '-bottom' + suffix];\n\t\t\t\tdelete styles[prefix + '-left' + suffix];\n\t\t\t};\n\n\t\t\tfunction canCompress(key) {\n\t\t\t\tvar value = styles[key], i;\n\n\t\t\t\tif (!value || value.indexOf(' ') < 0)\n\t\t\t\t\treturn;\n\n\t\t\t\tvalue = value.split(' ');\n\t\t\t\ti = value.length;\n\t\t\t\twhile (i--) {\n\t\t\t\t\tif (value[i] !== value[0])\n\t\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tstyles[key] = value[0];\n\n\t\t\t\treturn true;\n\t\t\t};\n\n\t\t\tfunction compress2(target, a, b, c) {\n\t\t\t\tif (!canCompress(a))\n\t\t\t\t\treturn;\n\n\t\t\t\tif (!canCompress(b))\n\t\t\t\t\treturn;\n\n\t\t\t\tif (!canCompress(c))\n\t\t\t\t\treturn;\n\n\t\t\t\t// Compress\n\t\t\t\tstyles[target] = styles[a] + ' ' + styles[b] + ' ' + styles[c];\n\t\t\t\tdelete styles[a];\n\t\t\t\tdelete styles[b];\n\t\t\t\tdelete styles[c];\n\t\t\t};\n\n\t\t\t// Encodes the specified string by replacing all \\\" \\' ; : with _<num>\n\t\t\tfunction encode(str) {\n\t\t\t\tisEncoded = true;\n\n\t\t\t\treturn encodingLookup[str];\n\t\t\t};\n\n\t\t\t// Decodes the specified string by replacing all _<num> with it's original value \\\" \\' etc\n\t\t\t// It will also decode the \\\" \\' if keep_slashes is set to fale or omitted\n\t\t\tfunction decode(str, keep_slashes) {\n\t\t\t\tif (isEncoded) {\n\t\t\t\t\tstr = str.replace(/\\uFEFF[0-9]/g, function(str) {\n\t\t\t\t\t\treturn encodingLookup[str];\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif (!keep_slashes)\n\t\t\t\t\tstr = str.replace(/\\\\([\\'\\\";:])/g, \"$1\");\n\n\t\t\t\treturn str;\n\t\t\t}\n\n\t\t\tif (css) {\n\t\t\t\t// Encode \\\" \\' % and ; and : inside strings so they don't interfere with the style parsing\n\t\t\t\tcss = css.replace(/\\\\[\\\"\\';:\\uFEFF]/g, encode).replace(/\\\"[^\\\"]+\\\"|\\'[^\\']+\\'/g, function(str) {\n\t\t\t\t\treturn str.replace(/[;:]/g, encode);\n\t\t\t\t});\n\n\t\t\t\t// Parse styles\n\t\t\t\twhile (matches = styleRegExp.exec(css)) {\n\t\t\t\t\tname = matches[1].replace(trimRightRegExp, '').toLowerCase();\n\t\t\t\t\tvalue = matches[2].replace(trimRightRegExp, '');\n\n\t\t\t\t\tif (name && value.length > 0) {\n\t\t\t\t\t\t// Opera will produce 700 instead of bold in their style values\n\t\t\t\t\t\tif (name === 'font-weight' && value === '700')\n\t\t\t\t\t\t\tvalue = 'bold';\n\t\t\t\t\t\telse if (name === 'color' || name === 'background-color') // Lowercase colors like RED\n\t\t\t\t\t\t\tvalue = value.toLowerCase();\t\t\n\n\t\t\t\t\t\t// Convert RGB colors to HEX\n\t\t\t\t\t\tvalue = value.replace(rgbRegExp, toHex);\n\n\t\t\t\t\t\t// Convert URLs and force them into url('value') format\n\t\t\t\t\t\tvalue = value.replace(urlOrStrRegExp, function(match, url, url2, url3, str, str2) {\n\t\t\t\t\t\t\tstr = str || str2;\n\n\t\t\t\t\t\t\tif (str) {\n\t\t\t\t\t\t\t\tstr = decode(str);\n\n\t\t\t\t\t\t\t\t// Force strings into single quote format\n\t\t\t\t\t\t\t\treturn \"'\" + str.replace(/\\'/g, \"\\\\'\") + \"'\";\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\turl = decode(url || url2 || url3);\n\n\t\t\t\t\t\t\t// Convert the URL to relative/absolute depending on config\n\t\t\t\t\t\t\tif (urlConverter)\n\t\t\t\t\t\t\t\turl = urlConverter.call(urlConverterScope, url, 'style');\n\n\t\t\t\t\t\t\t// Output new URL format\n\t\t\t\t\t\t\treturn \"url('\" + url.replace(/\\'/g, \"\\\\'\") + \"')\";\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tstyles[name] = isEncoded ? decode(value, true) : value;\n\t\t\t\t\t}\n\n\t\t\t\t\tstyleRegExp.lastIndex = matches.index + matches[0].length;\n\t\t\t\t}\n\n\t\t\t\t// Compress the styles to reduce it's size for example IE will expand styles\n\t\t\t\tcompress(\"border\", \"\");\n\t\t\t\tcompress(\"border\", \"-width\");\n\t\t\t\tcompress(\"border\", \"-color\");\n\t\t\t\tcompress(\"border\", \"-style\");\n\t\t\t\tcompress(\"padding\", \"\");\n\t\t\t\tcompress(\"margin\", \"\");\n\t\t\t\tcompress2('border', 'border-width', 'border-style', 'border-color');\n\n\t\t\t\t// Remove pointless border, IE produces these\n\t\t\t\tif (styles.border === 'medium none')\n\t\t\t\t\tdelete styles.border;\n\t\t\t}\n\n\t\t\treturn styles;\n\t\t},\n\n\t\tserialize : function(styles, element_name) {\n\t\t\tvar css = '', name, value;\n\n\t\t\tfunction serializeStyles(name) {\n\t\t\t\tvar styleList, i, l, value;\n\n\t\t\t\tstyleList = schema.styles[name];\n\t\t\t\tif (styleList) {\n\t\t\t\t\tfor (i = 0, l = styleList.length; i < l; i++) {\n\t\t\t\t\t\tname = styleList[i];\n\t\t\t\t\t\tvalue = styles[name];\n\n\t\t\t\t\t\tif (value !== undef && value.length > 0)\n\t\t\t\t\t\t\tcss += (css.length > 0 ? ' ' : '') + name + ': ' + value + ';';\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Serialize styles according to schema\n\t\t\tif (element_name && schema && schema.styles) {\n\t\t\t\t// Serialize global styles and element specific styles\n\t\t\t\tserializeStyles('*');\n\t\t\t\tserializeStyles(element_name);\n\t\t\t} else {\n\t\t\t\t// Output the styles in the order they are inside the object\n\t\t\t\tfor (name in styles) {\n\t\t\t\t\tvalue = styles[name];\n\n\t\t\t\t\tif (value !== undef && value.length > 0)\n\t\t\t\t\t\tcss += (css.length > 0 ? ' ' : '') + name + ': ' + value + ';';\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn css;\n\t\t}\n\t};\n};\n\n(function(tinymce) {\n\tvar transitional = {}, boolAttrMap, blockElementsMap, shortEndedElementsMap, nonEmptyElementsMap, customElementsMap = {},\n\t\tdefaultWhiteSpaceElementsMap, selfClosingElementsMap, makeMap = tinymce.makeMap, each = tinymce.each;\n\n\tfunction split(str, delim) {\n\t\treturn str.split(delim || ',');\n\t};\n\n\tfunction unpack(lookup, data) {\n\t\tvar key, elements = {};\n\n\t\tfunction replace(value) {\n\t\t\treturn value.replace(/[A-Z]+/g, function(key) {\n\t\t\t\treturn replace(lookup[key]);\n\t\t\t});\n\t\t};\n\n\t\t// Unpack lookup\n\t\tfor (key in lookup) {\n\t\t\tif (lookup.hasOwnProperty(key))\n\t\t\t\tlookup[key] = replace(lookup[key]);\n\t\t}\n\n\t\t// Unpack and parse data into object map\n\t\treplace(data).replace(/#/g, '#text').replace(/(\\w+)\\[([^\\]]+)\\]\\[([^\\]]*)\\]/g, function(str, name, attributes, children) {\n\t\t\tattributes = split(attributes, '|');\n\n\t\t\telements[name] = {\n\t\t\t\tattributes : makeMap(attributes),\n\t\t\t\tattributesOrder : attributes,\n\t\t\t\tchildren : makeMap(children, '|', {'#comment' : {}})\n\t\t\t}\n\t\t});\n\n\t\treturn elements;\n\t};\n\n\t// Build a lookup table for block elements both lowercase and uppercase\n\tblockElementsMap = 'h1,h2,h3,h4,h5,h6,hr,p,div,address,pre,form,table,tbody,thead,tfoot,' + \n\t\t\t\t\t\t'th,tr,td,li,ol,ul,caption,blockquote,center,dl,dt,dd,dir,fieldset,' + \n\t\t\t\t\t\t'noscript,menu,isindex,samp,header,footer,article,section,hgroup';\n\tblockElementsMap = makeMap(blockElementsMap, ',', makeMap(blockElementsMap.toUpperCase()));\n\n\t// This is the XHTML 1.0 transitional elements with it's attributes and children packed to reduce it's size\n\ttransitional = unpack({\n\t\tZ : 'H|K|N|O|P',\n\t\tY : 'X|form|R|Q',\n\t\tZG : 'E|span|width|align|char|charoff|valign',\n\t\tX : 'p|T|div|U|W|isindex|fieldset|table',\n\t\tZF : 'E|align|char|charoff|valign',\n\t\tW : 'pre|hr|blockquote|address|center|noframes',\n\t\tZE : 'abbr|axis|headers|scope|rowspan|colspan|align|char|charoff|valign|nowrap|bgcolor|width|height',\n\t\tZD : '[E][S]',\n\t\tU : 'ul|ol|dl|menu|dir',\n\t\tZC : 'p|Y|div|U|W|table|br|span|bdo|object|applet|img|map|K|N|Q',\n\t\tT : 'h1|h2|h3|h4|h5|h6',\n\t\tZB : 'X|S|Q',\n\t\tS : 'R|P',\n\t\tZA : 'a|G|J|M|O|P',\n\t\tR : 'a|H|K|N|O',\n\t\tQ : 'noscript|P',\n\t\tP : 'ins|del|script',\n\t\tO : 'input|select|textarea|label|button',\n\t\tN : 'M|L',\n\t\tM : 'em|strong|dfn|code|q|samp|kbd|var|cite|abbr|acronym',\n\t\tL : 'sub|sup',\n\t\tK : 'J|I',\n\t\tJ : 'tt|i|b|u|s|strike',\n\t\tI : 'big|small|font|basefont',\n\t\tH : 'G|F',\n\t\tG : 'br|span|bdo',\n\t\tF : 'object|applet|img|map|iframe',\n\t\tE : 'A|B|C',\n\t\tD : 'accesskey|tabindex|onfocus|onblur',\n\t\tC : 'onclick|ondblclick|onmousedown|onmouseup|onmouseover|onmousemove|onmouseout|onkeypress|onkeydown|onkeyup',\n\t\tB : 'lang|xml:lang|dir',\n\t\tA : 'id|class|style|title'\n\t}, 'script[id|charset|type|language|src|defer|xml:space][]' + \n\t\t'style[B|id|type|media|title|xml:space][]' + \n\t\t'object[E|declare|classid|codebase|data|type|codetype|archive|standby|width|height|usemap|name|tabindex|align|border|hspace|vspace][#|param|Y]' + \n\t\t'param[id|name|value|valuetype|type][]' + \n\t\t'p[E|align][#|S]' + \n\t\t'a[E|D|charset|type|name|href|hreflang|rel|rev|shape|coords|target][#|Z]' + \n\t\t'br[A|clear][]' + \n\t\t'span[E][#|S]' + \n\t\t'bdo[A|C|B][#|S]' + \n\t\t'applet[A|codebase|archive|code|object|alt|name|width|height|align|hspace|vspace][#|param|Y]' + \n\t\t'h1[E|align][#|S]' + \n\t\t'img[E|src|alt|name|longdesc|width|height|usemap|ismap|align|border|hspace|vspace][]' + \n\t\t'map[B|C|A|name][X|form|Q|area]' + \n\t\t'h2[E|align][#|S]' + \n\t\t'iframe[A|longdesc|name|src|frameborder|marginwidth|marginheight|scrolling|align|width|height][#|Y]' + \n\t\t'h3[E|align][#|S]' + \n\t\t'tt[E][#|S]' + \n\t\t'i[E][#|S]' + \n\t\t'b[E][#|S]' + \n\t\t'u[E][#|S]' + \n\t\t's[E][#|S]' + \n\t\t'strike[E][#|S]' + \n\t\t'big[E][#|S]' + \n\t\t'small[E][#|S]' + \n\t\t'font[A|B|size|color|face][#|S]' + \n\t\t'basefont[id|size|color|face][]' + \n\t\t'em[E][#|S]' + \n\t\t'strong[E][#|S]' + \n\t\t'dfn[E][#|S]' + \n\t\t'code[E][#|S]' + \n\t\t'q[E|cite][#|S]' + \n\t\t'samp[E][#|S]' + \n\t\t'kbd[E][#|S]' + \n\t\t'var[E][#|S]' + \n\t\t'cite[E][#|S]' + \n\t\t'abbr[E][#|S]' + \n\t\t'acronym[E][#|S]' + \n\t\t'sub[E][#|S]' + \n\t\t'sup[E][#|S]' + \n\t\t'input[E|D|type|name|value|checked|disabled|readonly|size|maxlength|src|alt|usemap|onselect|onchange|accept|align][]' + \n\t\t'select[E|name|size|multiple|disabled|tabindex|onfocus|onblur|onchange][optgroup|option]' + \n\t\t'optgroup[E|disabled|label][option]' + \n\t\t'option[E|selected|disabled|label|value][]' + \n\t\t'textarea[E|D|name|rows|cols|disabled|readonly|onselect|onchange][]' + \n\t\t'label[E|for|accesskey|onfocus|onblur][#|S]' + \n\t\t'button[E|D|name|value|type|disabled][#|p|T|div|U|W|table|G|object|applet|img|map|K|N|Q]' + \n\t\t'h4[E|align][#|S]' + \n\t\t'ins[E|cite|datetime][#|Y]' + \n\t\t'h5[E|align][#|S]' + \n\t\t'del[E|cite|datetime][#|Y]' + \n\t\t'h6[E|align][#|S]' + \n\t\t'div[E|align][#|Y]' + \n\t\t'ul[E|type|compact][li]' + \n\t\t'li[E|type|value][#|Y]' + \n\t\t'ol[E|type|compact|start][li]' + \n\t\t'dl[E|compact][dt|dd]' + \n\t\t'dt[E][#|S]' + \n\t\t'dd[E][#|Y]' + \n\t\t'menu[E|compact][li]' + \n\t\t'dir[E|compact][li]' + \n\t\t'pre[E|width|xml:space][#|ZA]' + \n\t\t'hr[E|align|noshade|size|width][]' + \n\t\t'blockquote[E|cite][#|Y]' + \n\t\t'address[E][#|S|p]' + \n\t\t'center[E][#|Y]' + \n\t\t'noframes[E][#|Y]' + \n\t\t'isindex[A|B|prompt][]' + \n\t\t'fieldset[E][#|legend|Y]' + \n\t\t'legend[E|accesskey|align][#|S]' + \n\t\t'table[E|summary|width|border|frame|rules|cellspacing|cellpadding|align|bgcolor][caption|col|colgroup|thead|tfoot|tbody|tr]' + \n\t\t'caption[E|align][#|S]' + \n\t\t'col[ZG][]' + \n\t\t'colgroup[ZG][col]' + \n\t\t'thead[ZF][tr]' + \n\t\t'tr[ZF|bgcolor][th|td]' + \n\t\t'th[E|ZE][#|Y]' + \n\t\t'form[E|action|method|name|enctype|onsubmit|onreset|accept|accept-charset|target][#|X|R|Q]' + \n\t\t'noscript[E][#|Y]' + \n\t\t'td[E|ZE][#|Y]' + \n\t\t'tfoot[ZF][tr]' + \n\t\t'tbody[ZF][tr]' + \n\t\t'area[E|D|shape|coords|href|nohref|alt|target][]' + \n\t\t'base[id|href|target][]' + \n\t\t'body[E|onload|onunload|background|bgcolor|text|link|vlink|alink][#|Y]'\n\t);\n\n\tboolAttrMap = makeMap('checked,compact,declare,defer,disabled,ismap,multiple,nohref,noresize,noshade,nowrap,readonly,selected,autoplay,loop,controls');\n\tshortEndedElementsMap = makeMap('area,base,basefont,br,col,frame,hr,img,input,isindex,link,meta,param,embed,source');\n\tnonEmptyElementsMap = tinymce.extend(makeMap('td,th,iframe,video,audio,object'), shortEndedElementsMap);\n\tdefaultWhiteSpaceElementsMap = makeMap('pre,script,style,textarea');\n\tselfClosingElementsMap = makeMap('colgroup,dd,dt,li,options,p,td,tfoot,th,thead,tr');\n\n\ttinymce.html.Schema = function(settings) {\n\t\tvar self = this, elements = {}, children = {}, patternElements = [], validStyles, whiteSpaceElementsMap;\n\n\t\tsettings = settings || {};\n\n\t\t// Allow all elements and attributes if verify_html is set to false\n\t\tif (settings.verify_html === false)\n\t\t\tsettings.valid_elements = '*[*]';\n\n\t\t// Build styles list\n\t\tif (settings.valid_styles) {\n\t\t\tvalidStyles = {};\n\n\t\t\t// Convert styles into a rule list\n\t\t\teach(settings.valid_styles, function(value, key) {\n\t\t\t\tvalidStyles[key] = tinymce.explode(value);\n\t\t\t});\n\t\t}\n\n\t\twhiteSpaceElementsMap = settings.whitespace_elements ? makeMap(settings.whitespace_elements) : defaultWhiteSpaceElementsMap;\n\n\t\t// Converts a wildcard expression string to a regexp for example *a will become /.*a/.\n\t\tfunction patternToRegExp(str) {\n\t\t\treturn new RegExp('^' + str.replace(/([?+*])/g, '.$1') + '$');\n\t\t};\n\n\t\t// Parses the specified valid_elements string and adds to the current rules\n\t\t// This function is a bit hard to read since it's heavily optimized for speed\n\t\tfunction addValidElements(valid_elements) {\n\t\t\tvar ei, el, ai, al, yl, matches, element, attr, attrData, elementName, attrName, attrType, attributes, attributesOrder,\n\t\t\t\tprefix, outputName, globalAttributes, globalAttributesOrder, transElement, key, childKey, value,\n\t\t\t\telementRuleRegExp = /^([#+-])?([^\\[\\/]+)(?:\\/([^\\[]+))?(?:\\[([^\\]]+)\\])?$/,\n\t\t\t\tattrRuleRegExp = /^([!\\-])?(\\w+::\\w+|[^=:<]+)?(?:([=:<])(.*))?$/,\n\t\t\t\thasPatternsRegExp = /[*?+]/;\n\n\t\t\tif (valid_elements) {\n\t\t\t\t// Split valid elements into an array with rules\n\t\t\t\tvalid_elements = split(valid_elements);\n\n\t\t\t\tif (elements['@']) {\n\t\t\t\t\tglobalAttributes = elements['@'].attributes;\n\t\t\t\t\tglobalAttributesOrder = elements['@'].attributesOrder;\n\t\t\t\t}\n\n\t\t\t\t// Loop all rules\n\t\t\t\tfor (ei = 0, el = valid_elements.length; ei < el; ei++) {\n\t\t\t\t\t// Parse element rule\n\t\t\t\t\tmatches = elementRuleRegExp.exec(valid_elements[ei]);\n\t\t\t\t\tif (matches) {\n\t\t\t\t\t\t// Setup local names for matches\n\t\t\t\t\t\tprefix = matches[1];\n\t\t\t\t\t\telementName = matches[2];\n\t\t\t\t\t\toutputName = matches[3];\n\t\t\t\t\t\tattrData = matches[4];\n\n\t\t\t\t\t\t// Create new attributes and attributesOrder\n\t\t\t\t\t\tattributes = {};\n\t\t\t\t\t\tattributesOrder = [];\n\n\t\t\t\t\t\t// Create the new element\n\t\t\t\t\t\telement = {\n\t\t\t\t\t\t\tattributes : attributes,\n\t\t\t\t\t\t\tattributesOrder : attributesOrder\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\t// Padd empty elements prefix\n\t\t\t\t\t\tif (prefix === '#')\n\t\t\t\t\t\t\telement.paddEmpty = true;\n\n\t\t\t\t\t\t// Remove empty elements prefix\n\t\t\t\t\t\tif (prefix === '-')\n\t\t\t\t\t\t\telement.removeEmpty = true;\n\n\t\t\t\t\t\t// Copy attributes from global rule into current rule\n\t\t\t\t\t\tif (globalAttributes) {\n\t\t\t\t\t\t\tfor (key in globalAttributes)\n\t\t\t\t\t\t\t\tattributes[key] = globalAttributes[key];\n\n\t\t\t\t\t\t\tattributesOrder.push.apply(attributesOrder, globalAttributesOrder);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Attributes defined\n\t\t\t\t\t\tif (attrData) {\n\t\t\t\t\t\t\tattrData = split(attrData, '|');\n\t\t\t\t\t\t\tfor (ai = 0, al = attrData.length; ai < al; ai++) {\n\t\t\t\t\t\t\t\tmatches = attrRuleRegExp.exec(attrData[ai]);\n\t\t\t\t\t\t\t\tif (matches) {\n\t\t\t\t\t\t\t\t\tattr = {};\n\t\t\t\t\t\t\t\t\tattrType = matches[1];\n\t\t\t\t\t\t\t\t\tattrName = matches[2].replace(/::/g, ':');\n\t\t\t\t\t\t\t\t\tprefix = matches[3];\n\t\t\t\t\t\t\t\t\tvalue = matches[4];\n\n\t\t\t\t\t\t\t\t\t// Required\n\t\t\t\t\t\t\t\t\tif (attrType === '!') {\n\t\t\t\t\t\t\t\t\t\telement.attributesRequired = element.attributesRequired || [];\n\t\t\t\t\t\t\t\t\t\telement.attributesRequired.push(attrName);\n\t\t\t\t\t\t\t\t\t\tattr.required = true;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Denied from global\n\t\t\t\t\t\t\t\t\tif (attrType === '-') {\n\t\t\t\t\t\t\t\t\t\tdelete attributes[attrName];\n\t\t\t\t\t\t\t\t\t\tattributesOrder.splice(tinymce.inArray(attributesOrder, attrName), 1);\n\t\t\t\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Default value\n\t\t\t\t\t\t\t\t\tif (prefix) {\n\t\t\t\t\t\t\t\t\t\t// Default value\n\t\t\t\t\t\t\t\t\t\tif (prefix === '=') {\n\t\t\t\t\t\t\t\t\t\t\telement.attributesDefault = element.attributesDefault || [];\n\t\t\t\t\t\t\t\t\t\t\telement.attributesDefault.push({name: attrName, value: value});\n\t\t\t\t\t\t\t\t\t\t\tattr.defaultValue = value;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// Forced value\n\t\t\t\t\t\t\t\t\t\tif (prefix === ':') {\n\t\t\t\t\t\t\t\t\t\t\telement.attributesForced = element.attributesForced || [];\n\t\t\t\t\t\t\t\t\t\t\telement.attributesForced.push({name: attrName, value: value});\n\t\t\t\t\t\t\t\t\t\t\tattr.forcedValue = value;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// Required values\n\t\t\t\t\t\t\t\t\t\tif (prefix === '<')\n\t\t\t\t\t\t\t\t\t\t\tattr.validValues = makeMap(value, '?');\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Check for attribute patterns\n\t\t\t\t\t\t\t\t\tif (hasPatternsRegExp.test(attrName)) {\n\t\t\t\t\t\t\t\t\t\telement.attributePatterns = element.attributePatterns || [];\n\t\t\t\t\t\t\t\t\t\tattr.pattern = patternToRegExp(attrName);\n\t\t\t\t\t\t\t\t\t\telement.attributePatterns.push(attr);\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\t// Add attribute to order list if it doesn't already exist\n\t\t\t\t\t\t\t\t\t\tif (!attributes[attrName])\n\t\t\t\t\t\t\t\t\t\t\tattributesOrder.push(attrName);\n\n\t\t\t\t\t\t\t\t\t\tattributes[attrName] = attr;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Global rule, store away these for later usage\n\t\t\t\t\t\tif (!globalAttributes && elementName == '@') {\n\t\t\t\t\t\t\tglobalAttributes = attributes;\n\t\t\t\t\t\t\tglobalAttributesOrder = attributesOrder;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Handle substitute elements such as b/strong\n\t\t\t\t\t\tif (outputName) {\n\t\t\t\t\t\t\telement.outputName = elementName;\n\t\t\t\t\t\t\telements[outputName] = element;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Add pattern or exact element\n\t\t\t\t\t\tif (hasPatternsRegExp.test(elementName)) {\n\t\t\t\t\t\t\telement.pattern = patternToRegExp(elementName);\n\t\t\t\t\t\t\tpatternElements.push(element);\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\telements[elementName] = element;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction setValidElements(valid_elements) {\n\t\t\telements = {};\n\t\t\tpatternElements = [];\n\n\t\t\taddValidElements(valid_elements);\n\n\t\t\teach(transitional, function(element, name) {\n\t\t\t\tchildren[name] = element.children;\n\t\t\t});\n\t\t};\n\n\t\t// Adds custom non HTML elements to the schema\n\t\tfunction addCustomElements(custom_elements) {\n\t\t\tvar customElementRegExp = /^(~)?(.+)$/;\n\n\t\t\tif (custom_elements) {\n\t\t\t\teach(split(custom_elements), function(rule) {\n\t\t\t\t\tvar matches = customElementRegExp.exec(rule),\n\t\t\t\t\t\tinline = matches[1] === '~',\n\t\t\t\t\t\tcloneName = inline ? 'span' : 'div',\n\t\t\t\t\t\tname = matches[2];\n\n\t\t\t\t\tchildren[name] = children[cloneName];\n\t\t\t\t\tcustomElementsMap[name] = cloneName;\n\n\t\t\t\t\t// If it's not marked as inline then add it to valid block elements\n\t\t\t\t\tif (!inline)\n\t\t\t\t\t\tblockElementsMap[name] = {};\n\n\t\t\t\t\t// Add custom elements at span/div positions\n\t\t\t\t\teach(children, function(element, child) {\n\t\t\t\t\t\tif (element[cloneName])\n\t\t\t\t\t\t\telement[name] = element[cloneName];\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\t// Adds valid children to the schema object\n\t\tfunction addValidChildren(valid_children) {\n\t\t\tvar childRuleRegExp = /^([+\\-]?)(\\w+)\\[([^\\]]+)\\]$/;\n\n\t\t\tif (valid_children) {\n\t\t\t\teach(split(valid_children), function(rule) {\n\t\t\t\t\tvar matches = childRuleRegExp.exec(rule), parent, prefix;\n\n\t\t\t\t\tif (matches) {\n\t\t\t\t\t\tprefix = matches[1];\n\n\t\t\t\t\t\t// Add/remove items from default\n\t\t\t\t\t\tif (prefix)\n\t\t\t\t\t\t\tparent = children[matches[2]];\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tparent = children[matches[2]] = {'#comment' : {}};\n\n\t\t\t\t\t\tparent = children[matches[2]];\n\n\t\t\t\t\t\teach(split(matches[3], '|'), function(child) {\n\t\t\t\t\t\t\tif (prefix === '-')\n\t\t\t\t\t\t\t\tdelete parent[child];\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tparent[child] = {};\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\tfunction getElementRule(name) {\n\t\t\tvar element = elements[name], i;\n\n\t\t\t// Exact match found\n\t\t\tif (element)\n\t\t\t\treturn element;\n\n\t\t\t// No exact match then try the patterns\n\t\t\ti = patternElements.length;\n\t\t\twhile (i--) {\n\t\t\t\telement = patternElements[i];\n\n\t\t\t\tif (element.pattern.test(name))\n\t\t\t\t\treturn element;\n\t\t\t}\n\t\t};\n\n\t\tif (!settings.valid_elements) {\n\t\t\t// No valid elements defined then clone the elements from the transitional spec\n\t\t\teach(transitional, function(element, name) {\n\t\t\t\telements[name] = {\n\t\t\t\t\tattributes : element.attributes,\n\t\t\t\t\tattributesOrder : element.attributesOrder\n\t\t\t\t};\n\n\t\t\t\tchildren[name] = element.children;\n\t\t\t});\n\n\t\t\t// Switch these\n\t\t\teach(split('strong/b,em/i'), function(item) {\n\t\t\t\titem = split(item, '/');\n\t\t\t\telements[item[1]].outputName = item[0];\n\t\t\t});\n\n\t\t\t// Add default alt attribute for images\n\t\t\telements.img.attributesDefault = [{name: 'alt', value: ''}];\n\n\t\t\t// Remove these if they are empty by default\n\t\t\teach(split('ol,ul,sub,sup,blockquote,span,font,a,table,tbody,tr'), function(name) {\n\t\t\t\telements[name].removeEmpty = true;\n\t\t\t});\n\n\t\t\t// Padd these by default\n\t\t\teach(split('p,h1,h2,h3,h4,h5,h6,th,td,pre,div,address,caption'), function(name) {\n\t\t\t\telements[name].paddEmpty = true;\n\t\t\t});\n\t\t} else\n\t\t\tsetValidElements(settings.valid_elements);\n\n\t\taddCustomElements(settings.custom_elements);\n\t\taddValidChildren(settings.valid_children);\n\t\taddValidElements(settings.extended_valid_elements);\n\n\t\t// Todo: Remove this when we fix list handling to be valid\n\t\taddValidChildren('+ol[ul|ol],+ul[ul|ol]');\n\n\t\t// If the user didn't allow span only allow internal spans\n\t\tif (!getElementRule('span'))\n\t\t\taddValidElements('span[!data-mce-type|*]');\n\n\t\t// Delete invalid elements\n\t\tif (settings.invalid_elements) {\n\t\t\ttinymce.each(tinymce.explode(settings.invalid_elements), function(item) {\n\t\t\t\tif (elements[item])\n\t\t\t\t\tdelete elements[item];\n\t\t\t});\n\t\t}\n\n\t\tself.children = children;\n\n\t\tself.styles = validStyles;\n\n\t\tself.getBoolAttrs = function() {\n\t\t\treturn boolAttrMap;\n\t\t};\n\n\t\tself.getBlockElements = function() {\n\t\t\treturn blockElementsMap;\n\t\t};\n\n\t\tself.getShortEndedElements = function() {\n\t\t\treturn shortEndedElementsMap;\n\t\t};\n\n\t\tself.getSelfClosingElements = function() {\n\t\t\treturn selfClosingElementsMap;\n\t\t};\n\n\t\tself.getNonEmptyElements = function() {\n\t\t\treturn nonEmptyElementsMap;\n\t\t};\n\n\t\tself.getWhiteSpaceElements = function() {\n\t\t\treturn whiteSpaceElementsMap;\n\t\t};\n\n\t\tself.isValidChild = function(name, child) {\n\t\t\tvar parent = children[name];\n\n\t\t\treturn !!(parent && parent[child]);\n\t\t};\n\n\t\tself.getElementRule = getElementRule;\n\n\t\tself.getCustomElements = function() {\n\t\t\treturn customElementsMap;\n\t\t};\n\n\t\tself.addValidElements = addValidElements;\n\n\t\tself.setValidElements = setValidElements;\n\n\t\tself.addCustomElements = addCustomElements;\n\n\t\tself.addValidChildren = addValidChildren;\n\t};\n\n\t// Expose boolMap and blockElementMap as static properties for usage in DOMUtils\n\ttinymce.html.Schema.boolAttrMap = boolAttrMap;\n\ttinymce.html.Schema.blockElementsMap = blockElementsMap;\n})(tinymce);\n\n(function(tinymce) {\n\ttinymce.html.SaxParser = function(settings, schema) {\n\t\tvar self = this, noop = function() {};\n\n\t\tsettings = settings || {};\n\t\tself.schema = schema = schema || new tinymce.html.Schema();\n\n\t\tif (settings.fix_self_closing !== false)\n\t\t\tsettings.fix_self_closing = true;\n\n\t\t// Add handler functions from settings and setup default handlers\n\t\ttinymce.each('comment cdata text start end pi doctype'.split(' '), function(name) {\n\t\t\tif (name)\n\t\t\t\tself[name] = settings[name] || noop;\n\t\t});\n\n\t\tself.parse = function(html) {\n\t\t\tvar self = this, matches, index = 0, value, endRegExp, stack = [], attrList, i, text, name, isInternalElement, removeInternalElements,\n\t\t\t\tshortEndedElements, fillAttrsMap, isShortEnded, validate, elementRule, isValidElement, attr, attribsValue, invalidPrefixRegExp,\n\t\t\t\tvalidAttributesMap, validAttributePatterns, attributesRequired, attributesDefault, attributesForced, selfClosing,\n\t\t\t\ttokenRegExp, attrRegExp, specialElements, attrValue, idCount = 0, decode = tinymce.html.Entities.decode, fixSelfClosing, isIE;\n\n\t\t\tfunction processEndTag(name) {\n\t\t\t\tvar pos, i;\n\n\t\t\t\t// Find position of parent of the same type\n\t\t\t\tpos = stack.length;\n\t\t\t\twhile (pos--) {\n\t\t\t\t\tif (stack[pos].name === name)\n\t\t\t\t\t\tbreak;\t\t\t\t\t\t\n\t\t\t\t}\n\n\t\t\t\t// Found parent\n\t\t\t\tif (pos >= 0) {\n\t\t\t\t\t// Close all the open elements\n\t\t\t\t\tfor (i = stack.length - 1; i >= pos; i--) {\n\t\t\t\t\t\tname = stack[i];\n\n\t\t\t\t\t\tif (name.valid)\n\t\t\t\t\t\t\tself.end(name.name);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove the open elements from the stack\n\t\t\t\t\tstack.length = pos;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Precompile RegExps and map objects\n\t\t\ttokenRegExp = new RegExp('<(?:' +\n\t\t\t\t'(?:!--([\\\\w\\\\W]*?)-->)|' + // Comment\n\t\t\t\t'(?:!\\\\[CDATA\\\\[([\\\\w\\\\W]*?)\\\\]\\\\]>)|' + // CDATA\n\t\t\t\t'(?:!DOCTYPE([\\\\w\\\\W]*?)>)|' + // DOCTYPE\n\t\t\t\t'(?:\\\\?([^\\\\s\\\\/<>]+) ?([\\\\w\\\\W]*?)[?/]>)|' + // PI\n\t\t\t\t'(?:\\\\/([^>]+)>)|' + // End element\n\t\t\t\t'(?:([^\\\\s\\\\/<>]+)((?:\\\\s+[^\"\\'>]+(?:(?:\"[^\"]*\")|(?:\\'[^\\']*\\')|[^>]*))*|\\\\/)>)' + // Start element\n\t\t\t')', 'g');\n\n\t\t\tattrRegExp = /([\\w:\\-]+)(?:\\s*=\\s*(?:(?:\\\"((?:\\\\.|[^\\\"])*)\\\")|(?:\\'((?:\\\\.|[^\\'])*)\\')|([^>\\s]+)))?/g;\n\t\t\tspecialElements = {\n\t\t\t\t'script' : /<\\/script[^>]*>/gi,\n\t\t\t\t'style' : /<\\/style[^>]*>/gi,\n\t\t\t\t'noscript' : /<\\/noscript[^>]*>/gi\n\t\t\t};\n\n\t\t\t// Setup lookup tables for empty elements and boolean attributes\n\t\t\tshortEndedElements = schema.getShortEndedElements();\n\t\t\tselfClosing = schema.getSelfClosingElements();\n\t\t\tfillAttrsMap = schema.getBoolAttrs();\n\t\t\tvalidate = settings.validate;\n\t\t\tremoveInternalElements = settings.remove_internals;\n\t\t\tfixSelfClosing = settings.fix_self_closing;\n\t\t\tisIE = tinymce.isIE;\n\t\t\tinvalidPrefixRegExp = /^:/;\n\n\t\t\twhile (matches = tokenRegExp.exec(html)) {\n\t\t\t\t// Text\n\t\t\t\tif (index < matches.index)\n\t\t\t\t\tself.text(decode(html.substr(index, matches.index - index)));\n\n\t\t\t\tif (value = matches[6]) { // End element\n\t\t\t\t\tvalue = value.toLowerCase();\n\n\t\t\t\t\t// IE will add a \":\" in front of elements it doesn't understand like custom elements or HTML5 elements\n\t\t\t\t\tif (isIE && invalidPrefixRegExp.test(value))\n\t\t\t\t\t\tvalue = value.substr(1);\n\n\t\t\t\t\tprocessEndTag(value);\n\t\t\t\t} else if (value = matches[7]) { // Start element\n\t\t\t\t\tvalue = value.toLowerCase();\n\n\t\t\t\t\t// IE will add a \":\" in front of elements it doesn't understand like custom elements or HTML5 elements\n\t\t\t\t\tif (isIE && invalidPrefixRegExp.test(value))\n\t\t\t\t\t\tvalue = value.substr(1);\n\n\t\t\t\t\tisShortEnded = value in shortEndedElements;\n\n\t\t\t\t\t// Is self closing tag for example an <li> after an open <li>\n\t\t\t\t\tif (fixSelfClosing && selfClosing[value] && stack.length > 0 && stack[stack.length - 1].name === value)\n\t\t\t\t\t\tprocessEndTag(value);\n\n\t\t\t\t\t// Validate element\n\t\t\t\t\tif (!validate || (elementRule = schema.getElementRule(value))) {\n\t\t\t\t\t\tisValidElement = true;\n\n\t\t\t\t\t\t// Grab attributes map and patters when validation is enabled\n\t\t\t\t\t\tif (validate) {\n\t\t\t\t\t\t\tvalidAttributesMap = elementRule.attributes;\n\t\t\t\t\t\t\tvalidAttributePatterns = elementRule.attributePatterns;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Parse attributes\n\t\t\t\t\t\tif (attribsValue = matches[8]) {\n\t\t\t\t\t\t\tisInternalElement = attribsValue.indexOf('data-mce-type') !== -1; // Check if the element is an internal element\n\n\t\t\t\t\t\t\t// If the element has internal attributes then remove it if we are told to do so\n\t\t\t\t\t\t\tif (isInternalElement && removeInternalElements)\n\t\t\t\t\t\t\t\tisValidElement = false;\n\n\t\t\t\t\t\t\tattrList = [];\n\t\t\t\t\t\t\tattrList.map = {};\n\n\t\t\t\t\t\t\tattribsValue.replace(attrRegExp, function(match, name, value, val2, val3) {\n\t\t\t\t\t\t\t\tvar attrRule, i;\n\n\t\t\t\t\t\t\t\tname = name.toLowerCase();\n\t\t\t\t\t\t\t\tvalue = name in fillAttrsMap ? name : decode(value || val2 || val3 || ''); // Handle boolean attribute than value attribute\n\n\t\t\t\t\t\t\t\t// Validate name and value\n\t\t\t\t\t\t\t\tif (validate && !isInternalElement && name.indexOf('data-') !== 0) {\n\t\t\t\t\t\t\t\t\tattrRule = validAttributesMap[name];\n\n\t\t\t\t\t\t\t\t\t// Find rule by pattern matching\n\t\t\t\t\t\t\t\t\tif (!attrRule && validAttributePatterns) {\n\t\t\t\t\t\t\t\t\t\ti = validAttributePatterns.length;\n\t\t\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\t\t\tattrRule = validAttributePatterns[i];\n\t\t\t\t\t\t\t\t\t\t\tif (attrRule.pattern.test(name))\n\t\t\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// No rule matched\n\t\t\t\t\t\t\t\t\t\tif (i === -1)\n\t\t\t\t\t\t\t\t\t\t\tattrRule = null;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// No attribute rule found\n\t\t\t\t\t\t\t\t\tif (!attrRule)\n\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t// Validate value\n\t\t\t\t\t\t\t\t\tif (attrRule.validValues && !(value in attrRule.validValues))\n\t\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Add attribute to list and map\n\t\t\t\t\t\t\t\tattrList.map[name] = value;\n\t\t\t\t\t\t\t\tattrList.push({\n\t\t\t\t\t\t\t\t\tname: name,\n\t\t\t\t\t\t\t\t\tvalue: value\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tattrList = [];\n\t\t\t\t\t\t\tattrList.map = {};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Process attributes if validation is enabled\n\t\t\t\t\t\tif (validate && !isInternalElement) {\n\t\t\t\t\t\t\tattributesRequired = elementRule.attributesRequired;\n\t\t\t\t\t\t\tattributesDefault = elementRule.attributesDefault;\n\t\t\t\t\t\t\tattributesForced = elementRule.attributesForced;\n\n\t\t\t\t\t\t\t// Handle forced attributes\n\t\t\t\t\t\t\tif (attributesForced) {\n\t\t\t\t\t\t\t\ti = attributesForced.length;\n\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\tattr = attributesForced[i];\n\t\t\t\t\t\t\t\t\tname = attr.name;\n\t\t\t\t\t\t\t\t\tattrValue = attr.value;\n\n\t\t\t\t\t\t\t\t\tif (attrValue === '{$uid}')\n\t\t\t\t\t\t\t\t\t\tattrValue = 'mce_' + idCount++;\n\n\t\t\t\t\t\t\t\t\tattrList.map[name] = attrValue;\n\t\t\t\t\t\t\t\t\tattrList.push({name: name, value: attrValue});\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Handle default attributes\n\t\t\t\t\t\t\tif (attributesDefault) {\n\t\t\t\t\t\t\t\ti = attributesDefault.length;\n\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\tattr = attributesDefault[i];\n\t\t\t\t\t\t\t\t\tname = attr.name;\n\n\t\t\t\t\t\t\t\t\tif (!(name in attrList.map)) {\n\t\t\t\t\t\t\t\t\t\tattrValue = attr.value;\n\n\t\t\t\t\t\t\t\t\t\tif (attrValue === '{$uid}')\n\t\t\t\t\t\t\t\t\t\t\tattrValue = 'mce_' + idCount++;\n\n\t\t\t\t\t\t\t\t\t\tattrList.map[name] = attrValue;\n\t\t\t\t\t\t\t\t\t\tattrList.push({name: name, value: attrValue});\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Handle required attributes\n\t\t\t\t\t\t\tif (attributesRequired) {\n\t\t\t\t\t\t\t\ti = attributesRequired.length;\n\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\tif (attributesRequired[i] in attrList.map)\n\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// None of the required attributes where found\n\t\t\t\t\t\t\t\tif (i === -1)\n\t\t\t\t\t\t\t\t\tisValidElement = false;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Invalidate element if it's marked as bogus\n\t\t\t\t\t\t\tif (attrList.map['data-mce-bogus'])\n\t\t\t\t\t\t\t\tisValidElement = false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (isValidElement)\n\t\t\t\t\t\t\tself.start(value, attrList, isShortEnded);\n\t\t\t\t\t} else\n\t\t\t\t\t\tisValidElement = false;\n\n\t\t\t\t\t// Treat script, noscript and style a bit different since they may include code that looks like elements\n\t\t\t\t\tif (endRegExp = specialElements[value]) {\n\t\t\t\t\t\tendRegExp.lastIndex = index = matches.index + matches[0].length;\n\n\t\t\t\t\t\tif (matches = endRegExp.exec(html)) {\n\t\t\t\t\t\t\tif (isValidElement)\n\t\t\t\t\t\t\t\ttext = html.substr(index, matches.index - index);\n\n\t\t\t\t\t\t\tindex = matches.index + matches[0].length;\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\ttext = html.substr(index);\n\t\t\t\t\t\t\tindex = html.length;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (isValidElement && text.length > 0)\n\t\t\t\t\t\t\tself.text(text, true);\n\n\t\t\t\t\t\tif (isValidElement)\n\t\t\t\t\t\t\tself.end(value);\n\n\t\t\t\t\t\ttokenRegExp.lastIndex = index;\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Push value on to stack\n\t\t\t\t\tif (!isShortEnded) {\n\t\t\t\t\t\tif (!attribsValue || attribsValue.indexOf('/') != attribsValue.length - 1)\n\t\t\t\t\t\t\tstack.push({name: value, valid: isValidElement});\n\t\t\t\t\t\telse if (isValidElement)\n\t\t\t\t\t\t\tself.end(value);\n\t\t\t\t\t}\n\t\t\t\t} else if (value = matches[1]) { // Comment\n\t\t\t\t\tself.comment(value);\n\t\t\t\t} else if (value = matches[2]) { // CDATA\n\t\t\t\t\tself.cdata(value);\n\t\t\t\t} else if (value = matches[3]) { // DOCTYPE\n\t\t\t\t\tself.doctype(value);\n\t\t\t\t} else if (value = matches[4]) { // PI\n\t\t\t\t\tself.pi(value, matches[5]);\n\t\t\t\t}\n\n\t\t\t\tindex = matches.index + matches[0].length;\n\t\t\t}\n\n\t\t\t// Text\n\t\t\tif (index < html.length)\n\t\t\t\tself.text(decode(html.substr(index)));\n\n\t\t\t// Close any open elements\n\t\t\tfor (i = stack.length - 1; i >= 0; i--) {\n\t\t\t\tvalue = stack[i];\n\n\t\t\t\tif (value.valid)\n\t\t\t\t\tself.end(value.name);\n\t\t\t}\n\t\t};\n\t}\n})(tinymce);\n\n(function(tinymce) {\n\tvar whiteSpaceRegExp = /^[ \\t\\r\\n]*$/, typeLookup = {\n\t\t'#text' : 3,\n\t\t'#comment' : 8,\n\t\t'#cdata' : 4,\n\t\t'#pi' : 7,\n\t\t'#doctype' : 10,\n\t\t'#document-fragment' : 11\n\t};\n\n\t// Walks the tree left/right\n\tfunction walk(node, root_node, prev) {\n\t\tvar sibling, parent, startName = prev ? 'lastChild' : 'firstChild', siblingName = prev ? 'prev' : 'next';\n\n\t\t// Walk into nodes if it has a start\n\t\tif (node[startName])\n\t\t\treturn node[startName];\n\n\t\t// Return the sibling if it has one\n\t\tif (node !== root_node) {\n\t\t\tsibling = node[siblingName];\n\n\t\t\tif (sibling)\n\t\t\t\treturn sibling;\n\n\t\t\t// Walk up the parents to look for siblings\n\t\t\tfor (parent = node.parent; parent && parent !== root_node; parent = parent.parent) {\n\t\t\t\tsibling = parent[siblingName];\n\n\t\t\t\tif (sibling)\n\t\t\t\t\treturn sibling;\n\t\t\t}\n\t\t}\n\t};\n\n\tfunction Node(name, type) {\n\t\tthis.name = name;\n\t\tthis.type = type;\n\n\t\tif (type === 1) {\n\t\t\tthis.attributes = [];\n\t\t\tthis.attributes.map = {};\n\t\t}\n\t}\n\n\ttinymce.extend(Node.prototype, {\n\t\treplace : function(node) {\n\t\t\tvar self = this;\n\n\t\t\tif (node.parent)\n\t\t\t\tnode.remove();\n\n\t\t\tself.insert(node, self);\n\t\t\tself.remove();\n\n\t\t\treturn self;\n\t\t},\n\n\t\tattr : function(name, value) {\n\t\t\tvar self = this, attrs, i, undef;\n\n\t\t\tif (typeof name !== \"string\") {\n\t\t\t\tfor (i in name)\n\t\t\t\t\tself.attr(i, name[i]);\n\n\t\t\t\treturn self;\n\t\t\t}\n\n\t\t\tif (attrs = self.attributes) {\n\t\t\t\tif (value !== undef) {\n\t\t\t\t\t// Remove attribute\n\t\t\t\t\tif (value === null) {\n\t\t\t\t\t\tif (name in attrs.map) {\n\t\t\t\t\t\t\tdelete attrs.map[name];\n\n\t\t\t\t\t\t\ti = attrs.length;\n\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\tif (attrs[i].name === name) {\n\t\t\t\t\t\t\t\t\tattrs = attrs.splice(i, 1);\n\t\t\t\t\t\t\t\t\treturn self;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn self;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Set attribute\n\t\t\t\t\tif (name in attrs.map) {\n\t\t\t\t\t\t// Set attribute\n\t\t\t\t\t\ti = attrs.length;\n\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\tif (attrs[i].name === name) {\n\t\t\t\t\t\t\t\tattrs[i].value = value;\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t} else\n\t\t\t\t\t\tattrs.push({name: name, value: value});\n\n\t\t\t\t\tattrs.map[name] = value;\n\n\t\t\t\t\treturn self;\n\t\t\t\t} else {\n\t\t\t\t\treturn attrs.map[name];\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tclone : function() {\n\t\t\tvar self = this, clone = new Node(self.name, self.type), i, l, selfAttrs, selfAttr, cloneAttrs;\n\n\t\t\t// Clone element attributes\n\t\t\tif (selfAttrs = self.attributes) {\n\t\t\t\tcloneAttrs = [];\n\t\t\t\tcloneAttrs.map = {};\n\n\t\t\t\tfor (i = 0, l = selfAttrs.length; i < l; i++) {\n\t\t\t\t\tselfAttr = selfAttrs[i];\n\n\t\t\t\t\t// Clone everything except id\n\t\t\t\t\tif (selfAttr.name !== 'id') {\n\t\t\t\t\t\tcloneAttrs[cloneAttrs.length] = {name: selfAttr.name, value: selfAttr.value};\n\t\t\t\t\t\tcloneAttrs.map[selfAttr.name] = selfAttr.value;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tclone.attributes = cloneAttrs;\n\t\t\t}\n\n\t\t\tclone.value = self.value;\n\t\t\tclone.shortEnded = self.shortEnded;\n\n\t\t\treturn clone;\n\t\t},\n\n\t\twrap : function(wrapper) {\n\t\t\tvar self = this;\n\n\t\t\tself.parent.insert(wrapper, self);\n\t\t\twrapper.append(self);\n\n\t\t\treturn self;\n\t\t},\n\n\t\tunwrap : function() {\n\t\t\tvar self = this, node, next;\n\n\t\t\tfor (node = self.firstChild; node; ) {\n\t\t\t\tnext = node.next;\n\t\t\t\tself.insert(node, self, true);\n\t\t\t\tnode = next;\n\t\t\t}\n\n\t\t\tself.remove();\n\t\t},\n\n\t\tremove : function() {\n\t\t\tvar self = this, parent = self.parent, next = self.next, prev = self.prev;\n\n\t\t\tif (parent) {\n\t\t\t\tif (parent.firstChild === self) {\n\t\t\t\t\tparent.firstChild = next;\n\n\t\t\t\t\tif (next)\n\t\t\t\t\t\tnext.prev = null;\n\t\t\t\t} else {\n\t\t\t\t\tprev.next = next;\n\t\t\t\t}\n\n\t\t\t\tif (parent.lastChild === self) {\n\t\t\t\t\tparent.lastChild = prev;\n\n\t\t\t\t\tif (prev)\n\t\t\t\t\t\tprev.next = null;\n\t\t\t\t} else {\n\t\t\t\t\tnext.prev = prev;\n\t\t\t\t}\n\n\t\t\t\tself.parent = self.next = self.prev = null;\n\t\t\t}\n\n\t\t\treturn self;\n\t\t},\n\n\t\tappend : function(node) {\n\t\t\tvar self = this, last;\n\n\t\t\tif (node.parent)\n\t\t\t\tnode.remove();\n\n\t\t\tlast = self.lastChild;\n\t\t\tif (last) {\n\t\t\t\tlast.next = node;\n\t\t\t\tnode.prev = last;\n\t\t\t\tself.lastChild = node;\n\t\t\t} else\n\t\t\t\tself.lastChild = self.firstChild = node;\n\n\t\t\tnode.parent = self;\n\n\t\t\treturn node;\n\t\t},\n\n\t\tinsert : function(node, ref_node, before) {\n\t\t\tvar parent;\n\n\t\t\tif (node.parent)\n\t\t\t\tnode.remove();\n\n\t\t\tparent = ref_node.parent || this;\n\n\t\t\tif (before) {\n\t\t\t\tif (ref_node === parent.firstChild)\n\t\t\t\t\tparent.firstChild = node;\n\t\t\t\telse\n\t\t\t\t\tref_node.prev.next = node;\n\n\t\t\t\tnode.prev = ref_node.prev;\n\t\t\t\tnode.next = ref_node;\n\t\t\t\tref_node.prev = node;\n\t\t\t} else {\n\t\t\t\tif (ref_node === parent.lastChild)\n\t\t\t\t\tparent.lastChild = node;\n\t\t\t\telse\n\t\t\t\t\tref_node.next.prev = node;\n\n\t\t\t\tnode.next = ref_node.next;\n\t\t\t\tnode.prev = ref_node;\n\t\t\t\tref_node.next = node;\n\t\t\t}\n\n\t\t\tnode.parent = parent;\n\n\t\t\treturn node;\n\t\t},\n\n\t\tgetAll : function(name) {\n\t\t\tvar self = this, node, collection = [];\n\n\t\t\tfor (node = self.firstChild; node; node = walk(node, self)) {\n\t\t\t\tif (node.name === name)\n\t\t\t\t\tcollection.push(node);\n\t\t\t}\n\n\t\t\treturn collection;\n\t\t},\n\n\t\tempty : function() {\n\t\t\tvar self = this, nodes, i, node;\n\n\t\t\t// Remove all children\n\t\t\tif (self.firstChild) {\n\t\t\t\tnodes = [];\n\n\t\t\t\t// Collect the children\n\t\t\t\tfor (node = self.firstChild; node; node = walk(node, self))\n\t\t\t\t\tnodes.push(node);\n\n\t\t\t\t// Remove the children\n\t\t\t\ti = nodes.length;\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tnode.parent = node.firstChild = node.lastChild = node.next = node.prev = null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tself.firstChild = self.lastChild = null;\n\n\t\t\treturn self;\n\t\t},\n\n\t\tisEmpty : function(elements) {\n\t\t\tvar self = this, node = self.firstChild, i, name;\n\n\t\t\tif (node) {\n\t\t\t\tdo {\n\t\t\t\t\tif (node.type === 1) {\n\t\t\t\t\t\t// Ignore bogus elements\n\t\t\t\t\t\tif (node.attributes.map['data-mce-bogus'])\n\t\t\t\t\t\t\tcontinue;\n\n\t\t\t\t\t\t// Keep empty elements like <img />\n\t\t\t\t\t\tif (elements[node.name])\n\t\t\t\t\t\t\treturn false;\n\n\t\t\t\t\t\t// Keep elements with data attributes or name attribute like <a name=\"1\"></a>\n\t\t\t\t\t\ti = node.attributes.length;\n\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\tname = node.attributes[i].name;\n\t\t\t\t\t\t\tif (name === \"name\" || name.indexOf('data-') === 0)\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Keep non whitespace text nodes\n\t\t\t\t\tif ((node.type === 3 && !whiteSpaceRegExp.test(node.value)))\n\t\t\t\t\t\treturn false;\n\t\t\t\t} while (node = walk(node, self));\n\t\t\t}\n\n\t\t\treturn true;\n\t\t},\n\n\t\twalk : function(prev) {\n\t\t\treturn walk(this, null, prev);\n\t\t}\n\t});\n\n\ttinymce.extend(Node, {\n\t\tcreate : function(name, attrs) {\n\t\t\tvar node, attrName;\n\n\t\t\t// Create node\n\t\t\tnode = new Node(name, typeLookup[name] || 1);\n\n\t\t\t// Add attributes if needed\n\t\t\tif (attrs) {\n\t\t\t\tfor (attrName in attrs)\n\t\t\t\t\tnode.attr(attrName, attrs[attrName]);\n\t\t\t}\n\n\t\t\treturn node;\n\t\t}\n\t});\n\n\ttinymce.html.Node = Node;\n})(tinymce);\n\n(function(tinymce) {\n\tvar Node = tinymce.html.Node;\n\n\ttinymce.html.DomParser = function(settings, schema) {\n\t\tvar self = this, nodeFilters = {}, attributeFilters = [], matchedNodes = {}, matchedAttributes = {};\n\n\t\tsettings = settings || {};\n\t\tsettings.validate = \"validate\" in settings ? settings.validate : true;\n\t\tsettings.root_name = settings.root_name || 'body';\n\t\tself.schema = schema = schema || new tinymce.html.Schema();\n\n\t\tfunction fixInvalidChildren(nodes) {\n\t\t\tvar ni, node, parent, parents, newParent, currentNode, tempNode, childNode, i,\n\t\t\t\tchildClone, nonEmptyElements, nonSplitableElements, sibling, nextNode;\n\n\t\t\tnonSplitableElements = tinymce.makeMap('tr,td,th,tbody,thead,tfoot,table');\n\t\t\tnonEmptyElements = schema.getNonEmptyElements();\n\n\t\t\tfor (ni = 0; ni < nodes.length; ni++) {\n\t\t\t\tnode = nodes[ni];\n\n\t\t\t\t// Already removed\n\t\t\t\tif (!node.parent)\n\t\t\t\t\tcontinue;\n\n\t\t\t\t// Get list of all parent nodes until we find a valid parent to stick the child into\n\t\t\t\tparents = [node];\n\t\t\t\tfor (parent = node.parent; parent && !schema.isValidChild(parent.name, node.name) && !nonSplitableElements[parent.name]; parent = parent.parent)\n\t\t\t\t\tparents.push(parent);\n\n\t\t\t\t// Found a suitable parent\n\t\t\t\tif (parent && parents.length > 1) {\n\t\t\t\t\t// Reverse the array since it makes looping easier\n\t\t\t\t\tparents.reverse();\n\n\t\t\t\t\t// Clone the related parent and insert that after the moved node\n\t\t\t\t\tnewParent = currentNode = self.filterNode(parents[0].clone());\n\n\t\t\t\t\t// Start cloning and moving children on the left side of the target node\n\t\t\t\t\tfor (i = 0; i < parents.length - 1; i++) {\n\t\t\t\t\t\tif (schema.isValidChild(currentNode.name, parents[i].name)) {\n\t\t\t\t\t\t\ttempNode = self.filterNode(parents[i].clone());\n\t\t\t\t\t\t\tcurrentNode.append(tempNode);\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\ttempNode = currentNode;\n\n\t\t\t\t\t\tfor (childNode = parents[i].firstChild; childNode && childNode != parents[i + 1]; ) {\n\t\t\t\t\t\t\tnextNode = childNode.next;\n\t\t\t\t\t\t\ttempNode.append(childNode);\n\t\t\t\t\t\t\tchildNode = nextNode;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tcurrentNode = tempNode;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!newParent.isEmpty(nonEmptyElements)) {\n\t\t\t\t\t\tparent.insert(newParent, parents[0], true);\n\t\t\t\t\t\tparent.insert(node, newParent);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tparent.insert(node, parents[0], true);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Check if the element is empty by looking through it's contents and special treatment for <p><br /></p>\n\t\t\t\t\tparent = parents[0];\n\t\t\t\t\tif (parent.isEmpty(nonEmptyElements) || parent.firstChild === parent.lastChild && parent.firstChild.name === 'br') {\n\t\t\t\t\t\tparent.empty().remove();\n\t\t\t\t\t}\n\t\t\t\t} else if (node.parent) {\n\t\t\t\t\t// If it's an LI try to find a UL/OL for it or wrap it\n\t\t\t\t\tif (node.name === 'li') {\n\t\t\t\t\t\tsibling = node.prev;\n\t\t\t\t\t\tif (sibling && (sibling.name === 'ul' || sibling.name === 'ul')) {\n\t\t\t\t\t\t\tsibling.append(node);\n\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tsibling = node.next;\n\t\t\t\t\t\tif (sibling && (sibling.name === 'ul' || sibling.name === 'ul')) {\n\t\t\t\t\t\t\tsibling.insert(node, sibling.firstChild, true);\n\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tnode.wrap(self.filterNode(new Node('ul', 1)));\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Try wrapping the element in a DIV\n\t\t\t\t\tif (schema.isValidChild(node.parent.name, 'div') && schema.isValidChild('div', node.name)) {\n\t\t\t\t\t\tnode.wrap(self.filterNode(new Node('div', 1)));\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// We failed wrapping it, then remove or unwrap it\n\t\t\t\t\t\tif (node.name === 'style' || node.name === 'script')\n\t\t\t\t\t\t\tnode.empty().remove();\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tnode.unwrap();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tself.filterNode = function(node) {\n\t\t\tvar i, name, list;\n\n\t\t\t// Run element filters\n\t\t\tif (name in nodeFilters) {\n\t\t\t\tlist = matchedNodes[name];\n\n\t\t\t\tif (list)\n\t\t\t\t\tlist.push(node);\n\t\t\t\telse\n\t\t\t\t\tmatchedNodes[name] = [node];\n\t\t\t}\n\n\t\t\t// Run attribute filters\n\t\t\ti = attributeFilters.length;\n\t\t\twhile (i--) {\n\t\t\t\tname = attributeFilters[i].name;\n\n\t\t\t\tif (name in node.attributes.map) {\n\t\t\t\t\tlist = matchedAttributes[name];\n\n\t\t\t\t\tif (list)\n\t\t\t\t\t\tlist.push(node);\n\t\t\t\t\telse\n\t\t\t\t\t\tmatchedAttributes[name] = [node];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn node;\n\t\t};\n\n\t\tself.addNodeFilter = function(name, callback) {\n\t\t\ttinymce.each(tinymce.explode(name), function(name) {\n\t\t\t\tvar list = nodeFilters[name];\n\n\t\t\t\tif (!list)\n\t\t\t\t\tnodeFilters[name] = list = [];\n\n\t\t\t\tlist.push(callback);\n\t\t\t});\n\t\t};\n\n\t\tself.addAttributeFilter = function(name, callback) {\n\t\t\ttinymce.each(tinymce.explode(name), function(name) {\n\t\t\t\tvar i;\n\n\t\t\t\tfor (i = 0; i < attributeFilters.length; i++) {\n\t\t\t\t\tif (attributeFilters[i].name === name) {\n\t\t\t\t\t\tattributeFilters[i].callbacks.push(callback);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tattributeFilters.push({name: name, callbacks: [callback]});\n\t\t\t});\n\t\t};\n\n\t\tself.parse = function(html, args) {\n\t\t\tvar parser, rootNode, node, nodes, i, l, fi, fl, list, name, validate,\n\t\t\t\tblockElements, startWhiteSpaceRegExp, invalidChildren = [],\n\t\t\t\tendWhiteSpaceRegExp, allWhiteSpaceRegExp, whiteSpaceElements, children, nonEmptyElements, rootBlockName;\n\n\t\t\targs = args || {};\n\t\t\tmatchedNodes = {};\n\t\t\tmatchedAttributes = {};\n\t\t\tblockElements = tinymce.extend(tinymce.makeMap('script,style,head,html,body,title,meta,param'), schema.getBlockElements());\n\t\t\tnonEmptyElements = schema.getNonEmptyElements();\n\t\t\tchildren = schema.children;\n\t\t\tvalidate = settings.validate;\n\t\t\trootBlockName = \"forced_root_block\" in args ? args.forced_root_block : settings.forced_root_block;\n\n\t\t\twhiteSpaceElements = schema.getWhiteSpaceElements();\n\t\t\tstartWhiteSpaceRegExp = /^[ \\t\\r\\n]+/;\n\t\t\tendWhiteSpaceRegExp = /[ \\t\\r\\n]+$/;\n\t\t\tallWhiteSpaceRegExp = /[ \\t\\r\\n]+/g;\n\n\t\t\tfunction addRootBlocks() {\n\t\t\t\tvar node = rootNode.firstChild, next, rootBlockNode;\n\n\t\t\t\twhile (node) {\n\t\t\t\t\tnext = node.next;\n\n\t\t\t\t\tif (node.type == 3 || (node.type == 1 && node.name !== 'p' && !blockElements[node.name] && !node.attr('data-mce-type'))) {\n\t\t\t\t\t\tif (!rootBlockNode) {\n\t\t\t\t\t\t\t// Create a new root block element\n\t\t\t\t\t\t\trootBlockNode = createNode(rootBlockName, 1);\n\t\t\t\t\t\t\trootNode.insert(rootBlockNode, node);\n\t\t\t\t\t\t\trootBlockNode.append(node);\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\trootBlockNode.append(node);\n\t\t\t\t\t} else {\n\t\t\t\t\t\trootBlockNode = null;\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = next;\n\t\t\t\t};\n\t\t\t};\n\n\t\t\tfunction createNode(name, type) {\n\t\t\t\tvar node = new Node(name, type), list;\n\n\t\t\t\tif (name in nodeFilters) {\n\t\t\t\t\tlist = matchedNodes[name];\n\n\t\t\t\t\tif (list)\n\t\t\t\t\t\tlist.push(node);\n\t\t\t\t\telse\n\t\t\t\t\t\tmatchedNodes[name] = [node];\n\t\t\t\t}\n\n\t\t\t\treturn node;\n\t\t\t};\n\n\t\t\tfunction removeWhitespaceBefore(node) {\n\t\t\t\tvar textNode, textVal, sibling;\n\n\t\t\t\tfor (textNode = node.prev; textNode && textNode.type === 3; ) {\n\t\t\t\t\ttextVal = textNode.value.replace(endWhiteSpaceRegExp, '');\n\n\t\t\t\t\tif (textVal.length > 0) {\n\t\t\t\t\t\ttextNode.value = textVal;\n\t\t\t\t\t\ttextNode = textNode.prev;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tsibling = textNode.prev;\n\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\ttextNode = sibling;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tparser = new tinymce.html.SaxParser({\n\t\t\t\tvalidate : validate,\n\t\t\t\tfix_self_closing : !validate, // Let the DOM parser handle <li> in <li> or <p> in <p> for better results\n\n\t\t\t\tcdata: function(text) {\n\t\t\t\t\tnode.append(createNode('#cdata', 4)).value = text;\n\t\t\t\t},\n\n\t\t\t\ttext: function(text, raw) {\n\t\t\t\t\tvar textNode;\n\n\t\t\t\t\t// Trim all redundant whitespace on non white space elements\n\t\t\t\t\tif (!whiteSpaceElements[node.name]) {\n\t\t\t\t\t\ttext = text.replace(allWhiteSpaceRegExp, ' ');\n\n\t\t\t\t\t\tif (node.lastChild && blockElements[node.lastChild.name])\n\t\t\t\t\t\t\ttext = text.replace(startWhiteSpaceRegExp, '');\n\t\t\t\t\t}\n\n\t\t\t\t\t// Do we need to create the node\n\t\t\t\t\tif (text.length !== 0) {\n\t\t\t\t\t\ttextNode = createNode('#text', 3);\n\t\t\t\t\t\ttextNode.raw = !!raw;\n\t\t\t\t\t\tnode.append(textNode).value = text;\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tcomment: function(text) {\n\t\t\t\t\tnode.append(createNode('#comment', 8)).value = text;\n\t\t\t\t},\n\n\t\t\t\tpi: function(name, text) {\n\t\t\t\t\tnode.append(createNode(name, 7)).value = text;\n\t\t\t\t\tremoveWhitespaceBefore(node);\n\t\t\t\t},\n\n\t\t\t\tdoctype: function(text) {\n\t\t\t\t\tvar newNode;\n\t\t\n\t\t\t\t\tnewNode = node.append(createNode('#doctype', 10));\n\t\t\t\t\tnewNode.value = text;\n\t\t\t\t\tremoveWhitespaceBefore(node);\n\t\t\t\t},\n\n\t\t\t\tstart: function(name, attrs, empty) {\n\t\t\t\t\tvar newNode, attrFiltersLen, elementRule, textNode, attrName, text, sibling, parent;\n\n\t\t\t\t\telementRule = validate ? schema.getElementRule(name) : {};\n\t\t\t\t\tif (elementRule) {\n\t\t\t\t\t\tnewNode = createNode(elementRule.outputName || name, 1);\n\t\t\t\t\t\tnewNode.attributes = attrs;\n\t\t\t\t\t\tnewNode.shortEnded = empty;\n\n\t\t\t\t\t\tnode.append(newNode);\n\n\t\t\t\t\t\t// Check if node is valid child of the parent node is the child is\n\t\t\t\t\t\t// unknown we don't collect it since it's probably a custom element\n\t\t\t\t\t\tparent = children[node.name];\n\t\t\t\t\t\tif (parent && children[newNode.name] && !parent[newNode.name])\n\t\t\t\t\t\t\tinvalidChildren.push(newNode);\n\n\t\t\t\t\t\tattrFiltersLen = attributeFilters.length;\n\t\t\t\t\t\twhile (attrFiltersLen--) {\n\t\t\t\t\t\t\tattrName = attributeFilters[attrFiltersLen].name;\n\n\t\t\t\t\t\t\tif (attrName in attrs.map) {\n\t\t\t\t\t\t\t\tlist = matchedAttributes[attrName];\n\n\t\t\t\t\t\t\t\tif (list)\n\t\t\t\t\t\t\t\t\tlist.push(newNode);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\tmatchedAttributes[attrName] = [newNode];\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Trim whitespace before block\n\t\t\t\t\t\tif (blockElements[name])\n\t\t\t\t\t\t\tremoveWhitespaceBefore(newNode);\n\n\t\t\t\t\t\t// Change current node if the element wasn't empty i.e not <br /> or <img />\n\t\t\t\t\t\tif (!empty)\n\t\t\t\t\t\t\tnode = newNode;\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tend: function(name) {\n\t\t\t\t\tvar textNode, elementRule, text, sibling, tempNode;\n\n\t\t\t\t\telementRule = validate ? schema.getElementRule(name) : {};\n\t\t\t\t\tif (elementRule) {\n\t\t\t\t\t\tif (blockElements[name]) {\n\t\t\t\t\t\t\tif (!whiteSpaceElements[node.name]) {\n\t\t\t\t\t\t\t\t// Trim whitespace at beginning of block\n\t\t\t\t\t\t\t\tfor (textNode = node.firstChild; textNode && textNode.type === 3; ) {\n\t\t\t\t\t\t\t\t\ttext = textNode.value.replace(startWhiteSpaceRegExp, '');\n\n\t\t\t\t\t\t\t\t\tif (text.length > 0) {\n\t\t\t\t\t\t\t\t\t\ttextNode.value = text;\n\t\t\t\t\t\t\t\t\t\ttextNode = textNode.next;\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tsibling = textNode.next;\n\t\t\t\t\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\t\t\t\t\ttextNode = sibling;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Trim whitespace at end of block\n\t\t\t\t\t\t\t\tfor (textNode = node.lastChild; textNode && textNode.type === 3; ) {\n\t\t\t\t\t\t\t\t\ttext = textNode.value.replace(endWhiteSpaceRegExp, '');\n\n\t\t\t\t\t\t\t\t\tif (text.length > 0) {\n\t\t\t\t\t\t\t\t\t\ttextNode.value = text;\n\t\t\t\t\t\t\t\t\t\ttextNode = textNode.prev;\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tsibling = textNode.prev;\n\t\t\t\t\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\t\t\t\t\ttextNode = sibling;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Trim start white space\n\t\t\t\t\t\t\ttextNode = node.prev;\n\t\t\t\t\t\t\tif (textNode && textNode.type === 3) {\n\t\t\t\t\t\t\t\ttext = textNode.value.replace(startWhiteSpaceRegExp, '');\n\n\t\t\t\t\t\t\t\tif (text.length > 0)\n\t\t\t\t\t\t\t\t\ttextNode.value = text;\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Handle empty nodes\n\t\t\t\t\t\tif (elementRule.removeEmpty || elementRule.paddEmpty) {\n\t\t\t\t\t\t\tif (node.isEmpty(nonEmptyElements)) {\n\t\t\t\t\t\t\t\tif (elementRule.paddEmpty)\n\t\t\t\t\t\t\t\t\tnode.empty().append(new Node('#text', '3')).value = '\\u00a0';\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t// Leave nodes that have a name like <a name=\"name\">\n\t\t\t\t\t\t\t\t\tif (!node.attributes.map.name) {\n\t\t\t\t\t\t\t\t\t\ttempNode = node.parent;\n\t\t\t\t\t\t\t\t\t\tnode.empty().remove();\n\t\t\t\t\t\t\t\t\t\tnode = tempNode;\n\t\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tnode = node.parent;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}, schema);\n\n\t\t\trootNode = node = new Node(args.context || settings.root_name, 11);\n\n\t\t\tparser.parse(html);\n\n\t\t\t// Fix invalid children or report invalid children in a contextual parsing\n\t\t\tif (validate && invalidChildren.length) {\n\t\t\t\tif (!args.context)\n\t\t\t\t\tfixInvalidChildren(invalidChildren);\n\t\t\t\telse\n\t\t\t\t\targs.invalid = true;\n\t\t\t}\n\n\t\t\t// Wrap nodes in the root into block elements if the root is body\n\t\t\tif (rootBlockName && rootNode.name == 'body')\n\t\t\t\taddRootBlocks();\n\n\t\t\t// Run filters only when the contents is valid\n\t\t\tif (!args.invalid) {\n\t\t\t\t// Run node filters\n\t\t\t\tfor (name in matchedNodes) {\n\t\t\t\t\tlist = nodeFilters[name];\n\t\t\t\t\tnodes = matchedNodes[name];\n\n\t\t\t\t\t// Remove already removed children\n\t\t\t\t\tfi = nodes.length;\n\t\t\t\t\twhile (fi--) {\n\t\t\t\t\t\tif (!nodes[fi].parent)\n\t\t\t\t\t\t\tnodes.splice(fi, 1);\n\t\t\t\t\t}\n\n\t\t\t\t\tfor (i = 0, l = list.length; i < l; i++)\n\t\t\t\t\t\tlist[i](nodes, name, args);\n\t\t\t\t}\n\n\t\t\t\t// Run attribute filters\n\t\t\t\tfor (i = 0, l = attributeFilters.length; i < l; i++) {\n\t\t\t\t\tlist = attributeFilters[i];\n\n\t\t\t\t\tif (list.name in matchedAttributes) {\n\t\t\t\t\t\tnodes = matchedAttributes[list.name];\n\n\t\t\t\t\t\t// Remove already removed children\n\t\t\t\t\t\tfi = nodes.length;\n\t\t\t\t\t\twhile (fi--) {\n\t\t\t\t\t\t\tif (!nodes[fi].parent)\n\t\t\t\t\t\t\t\tnodes.splice(fi, 1);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfor (fi = 0, fl = list.callbacks.length; fi < fl; fi++)\n\t\t\t\t\t\t\tlist.callbacks[fi](nodes, list.name, args);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn rootNode;\n\t\t};\n\n\t\t// Remove <br> at end of block elements Gecko and WebKit injects BR elements to\n\t\t// make it possible to place the caret inside empty blocks. This logic tries to remove\n\t\t// these elements and keep br elements that where intended to be there intact\n\t\tif (settings.remove_trailing_brs) {\n\t\t\tself.addNodeFilter('br', function(nodes, name) {\n\t\t\t\tvar i, l = nodes.length, node, blockElements = schema.getBlockElements(),\n\t\t\t\t\tnonEmptyElements = schema.getNonEmptyElements(), parent, prev, prevName;\n\n\t\t\t\t// Remove brs from body element as well\n\t\t\t\tblockElements.body = 1;\n\n\t\t\t\t// Must loop forwards since it will otherwise remove all brs in <p>a<br><br><br></p>\n\t\t\t\tfor (i = 0; i < l; i++) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tparent = node.parent;\n\n\t\t\t\t\tif (blockElements[node.parent.name] && node === parent.lastChild) {\n\t\t\t\t\t\t// Loop all nodes to the right of the current node and check for other BR elements\n\t\t\t\t\t\t// excluding bookmarks since they are invisible\n\t\t\t\t\t\tprev = node.prev;\n\t\t\t\t\t\twhile (prev) {\n\t\t\t\t\t\t\tprevName = prev.name;\n\n\t\t\t\t\t\t\t// Ignore bookmarks\n\t\t\t\t\t\t\tif (prevName !== \"span\" || prev.attr('data-mce-type') !== 'bookmark') {\n\t\t\t\t\t\t\t\t// Found a non BR element\n\t\t\t\t\t\t\t\tif (prevName !== \"br\")\n\t\t\t\t\t\t\t\t\tbreak;\n\t\n\t\t\t\t\t\t\t\t// Found another br it's a <br><br> structure then don't remove anything\n\t\t\t\t\t\t\t\tif (prevName === 'br') {\n\t\t\t\t\t\t\t\t\tnode = null;\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tprev = prev.prev;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (node) {\n\t\t\t\t\t\t\tnode.remove();\n\n\t\t\t\t\t\t\t// Is the parent to be considered empty after we removed the BR\n\t\t\t\t\t\t\tif (parent.isEmpty(nonEmptyElements)) {\n\t\t\t\t\t\t\t\telementRule = schema.getElementRule(parent.name);\n\n\t\t\t\t\t\t\t\t// Remove or padd the element depending on schema rule\n\t\t\t\t\t\t\t\tif (elementRule) {\n\t\t\t\t\t\t\t\t  if (elementRule.removeEmpty)\n\t\t\t\t\t\t\t\t\t  parent.remove();\n\t\t\t\t\t\t\t\t  else if (elementRule.paddEmpty)\n\t\t\t\t\t\t\t\t\t  parent.empty().append(new tinymce.html.Node('#text', 3)).value = '\\u00a0';\n\t\t\t\t\t\t\t  }\n              }\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t}\n})(tinymce);\n\ntinymce.html.Writer = function(settings) {\n\tvar html = [], indent, indentBefore, indentAfter, encode, htmlOutput;\n\n\tsettings = settings || {};\n\tindent = settings.indent;\n\tindentBefore = tinymce.makeMap(settings.indent_before || '');\n\tindentAfter = tinymce.makeMap(settings.indent_after || '');\n\tencode = tinymce.html.Entities.getEncodeFunc(settings.entity_encoding || 'raw', settings.entities);\n\thtmlOutput = settings.element_format == \"html\";\n\n\treturn {\n\t\tstart: function(name, attrs, empty) {\n\t\t\tvar i, l, attr, value;\n\n\t\t\tif (indent && indentBefore[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}\n\n\t\t\thtml.push('<', name);\n\n\t\t\tif (attrs) {\n\t\t\t\tfor (i = 0, l = attrs.length; i < l; i++) {\n\t\t\t\t\tattr = attrs[i];\n\t\t\t\t\thtml.push(' ', attr.name, '=\"', encode(attr.value, true), '\"');\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (!empty || htmlOutput)\n\t\t\t\thtml[html.length] = '>';\n\t\t\telse\n\t\t\t\thtml[html.length] = ' />';\n\n\t\t\tif (empty && indent && indentAfter[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}\n\t\t},\n\n\t\tend: function(name) {\n\t\t\tvar value;\n\n\t\t\t/*if (indent && indentBefore[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}*/\n\n\t\t\thtml.push('</', name, '>');\n\n\t\t\tif (indent && indentAfter[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}\n\t\t},\n\n\t\ttext: function(text, raw) {\n\t\t\tif (text.length > 0)\n\t\t\t\thtml[html.length] = raw ? text : encode(text);\n\t\t},\n\n\t\tcdata: function(text) {\n\t\t\thtml.push('<![CDATA[', text, ']]>');\n\t\t},\n\n\t\tcomment: function(text) {\n\t\t\thtml.push('<!--', text, '-->');\n\t\t},\n\n\t\tpi: function(name, text) {\n\t\t\tif (text)\n\t\t\t\thtml.push('<?', name, ' ', text, '?>');\n\t\t\telse\n\t\t\t\thtml.push('<?', name, '?>');\n\n\t\t\tif (indent)\n\t\t\t\thtml.push('\\n');\n\t\t},\n\n\t\tdoctype: function(text) {\n\t\t\thtml.push('<!DOCTYPE', text, '>', indent ? '\\n' : '');\n\t\t},\n\n\t\treset: function() {\n\t\t\thtml.length = 0;\n\t\t},\n\n\t\tgetContent: function() {\n\t\t\treturn html.join('').replace(/\\n$/, '');\n\t\t}\n\t};\n};\n\n(function(tinymce) {\n\ttinymce.html.Serializer = function(settings, schema) {\n\t\tvar self = this, writer = new tinymce.html.Writer(settings);\n\n\t\tsettings = settings || {};\n\t\tsettings.validate = \"validate\" in settings ? settings.validate : true;\n\n\t\tself.schema = schema = schema || new tinymce.html.Schema();\n\t\tself.writer = writer;\n\n\t\tself.serialize = function(node) {\n\t\t\tvar handlers, validate;\n\n\t\t\tvalidate = settings.validate;\n\n\t\t\thandlers = {\n\t\t\t\t// #text\n\t\t\t\t3: function(node, raw) {\n\t\t\t\t\twriter.text(node.value, node.raw);\n\t\t\t\t},\n\n\t\t\t\t// #comment\n\t\t\t\t8: function(node) {\n\t\t\t\t\twriter.comment(node.value);\n\t\t\t\t},\n\n\t\t\t\t// Processing instruction\n\t\t\t\t7: function(node) {\n\t\t\t\t\twriter.pi(node.name, node.value);\n\t\t\t\t},\n\n\t\t\t\t// Doctype\n\t\t\t\t10: function(node) {\n\t\t\t\t\twriter.doctype(node.value);\n\t\t\t\t},\n\n\t\t\t\t// CDATA\n\t\t\t\t4: function(node) {\n\t\t\t\t\twriter.cdata(node.value);\n\t\t\t\t},\n\n \t\t\t\t// Document fragment\n\t\t\t\t11: function(node) {\n\t\t\t\t\tif ((node = node.firstChild)) {\n\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\twalk(node);\n\t\t\t\t\t\t} while (node = node.next);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\twriter.reset();\n\n\t\t\tfunction walk(node) {\n\t\t\t\tvar handler = handlers[node.type], name, isEmpty, attrs, attrName, attrValue, sortedAttrs, i, l, elementRule;\n\n\t\t\t\tif (!handler) {\n\t\t\t\t\tname = node.name;\n\t\t\t\t\tisEmpty = node.shortEnded;\n\t\t\t\t\tattrs = node.attributes;\n\n\t\t\t\t\t// Sort attributes\n\t\t\t\t\tif (validate && attrs && attrs.length > 1) {\n\t\t\t\t\t\tsortedAttrs = [];\n\t\t\t\t\t\tsortedAttrs.map = {};\n\n\t\t\t\t\t\telementRule = schema.getElementRule(node.name);\n\t\t\t\t\t\tfor (i = 0, l = elementRule.attributesOrder.length; i < l; i++) {\n\t\t\t\t\t\t\tattrName = elementRule.attributesOrder[i];\n\n\t\t\t\t\t\t\tif (attrName in attrs.map) {\n\t\t\t\t\t\t\t\tattrValue = attrs.map[attrName];\n\t\t\t\t\t\t\t\tsortedAttrs.map[attrName] = attrValue;\n\t\t\t\t\t\t\t\tsortedAttrs.push({name: attrName, value: attrValue});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfor (i = 0, l = attrs.length; i < l; i++) {\n\t\t\t\t\t\t\tattrName = attrs[i].name;\n\n\t\t\t\t\t\t\tif (!(attrName in sortedAttrs.map)) {\n\t\t\t\t\t\t\t\tattrValue = attrs.map[attrName];\n\t\t\t\t\t\t\t\tsortedAttrs.map[attrName] = attrValue;\n\t\t\t\t\t\t\t\tsortedAttrs.push({name: attrName, value: attrValue});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tattrs = sortedAttrs;\n\t\t\t\t\t}\n\n\t\t\t\t\twriter.start(node.name, attrs, isEmpty);\n\n\t\t\t\t\tif (!isEmpty) {\n\t\t\t\t\t\tif ((node = node.firstChild)) {\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\twalk(node);\n\t\t\t\t\t\t\t} while (node = node.next);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\twriter.end(name);\n\t\t\t\t\t}\n\t\t\t\t} else\n\t\t\t\t\thandler(node);\n\t\t\t}\n\n\t\t\t// Serialize element and treat all non elements as fragments\n\t\t\tif (node.type == 1 && !settings.inner)\n\t\t\t\twalk(node);\n\t\t\telse\n\t\t\t\thandlers[11](node);\n\n\t\t\treturn writer.getContent();\n\t\t};\n\t}\n})(tinymce);\n\n(function(tinymce) {\n\t// Shorten names\n\tvar each = tinymce.each,\n\t\tis = tinymce.is,\n\t\tisWebKit = tinymce.isWebKit,\n\t\tisIE = tinymce.isIE,\n\t\tEntities = tinymce.html.Entities,\n\t\tsimpleSelectorRe = /^([a-z0-9],?)+$/i,\n\t\tblockElementsMap = tinymce.html.Schema.blockElementsMap,\n\t\twhiteSpaceRegExp = /^[ \\t\\r\\n]*$/;\n\n\ttinymce.create('tinymce.dom.DOMUtils', {\n\t\tdoc : null,\n\t\troot : null,\n\t\tfiles : null,\n\t\tpixelStyles : /^(top|left|bottom|right|width|height|borderWidth)$/,\n\t\tprops : {\n\t\t\t\"for\" : \"htmlFor\",\n\t\t\t\"class\" : \"className\",\n\t\t\tclassName : \"className\",\n\t\t\tchecked : \"checked\",\n\t\t\tdisabled : \"disabled\",\n\t\t\tmaxlength : \"maxLength\",\n\t\t\treadonly : \"readOnly\",\n\t\t\tselected : \"selected\",\n\t\t\tvalue : \"value\",\n\t\t\tid : \"id\",\n\t\t\tname : \"name\",\n\t\t\ttype : \"type\"\n\t\t},\n\n\t\tDOMUtils : function(d, s) {\n\t\t\tvar t = this, globalStyle, name;\n\n\t\t\tt.doc = d;\n\t\t\tt.win = window;\n\t\t\tt.files = {};\n\t\t\tt.cssFlicker = false;\n\t\t\tt.counter = 0;\n\t\t\tt.stdMode = !tinymce.isIE || d.documentMode >= 8;\n\t\t\tt.boxModel = !tinymce.isIE || d.compatMode == \"CSS1Compat\" || t.stdMode;\n\t\t\tt.hasOuterHTML = \"outerHTML\" in d.createElement(\"a\");\n\n\t\t\tt.settings = s = tinymce.extend({\n\t\t\t\tkeep_values : false,\n\t\t\t\thex_colors : 1\n\t\t\t}, s);\n\t\t\t\n\t\t\tt.schema = s.schema;\n\t\t\tt.styles = new tinymce.html.Styles({\n\t\t\t\turl_converter : s.url_converter,\n\t\t\t\turl_converter_scope : s.url_converter_scope\n\t\t\t}, s.schema);\n\n\t\t\t// Fix IE6SP2 flicker and check it failed for pre SP2\n\t\t\tif (tinymce.isIE6) {\n\t\t\t\ttry {\n\t\t\t\t\td.execCommand('BackgroundImageCache', false, true);\n\t\t\t\t} catch (e) {\n\t\t\t\t\tt.cssFlicker = true;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (isIE && s.schema) {\n\t\t\t\t// Add missing HTML 4/5 elements to IE\n\t\t\t\t('abbr article aside audio canvas ' +\n\t\t\t\t'details figcaption figure footer ' +\n\t\t\t\t'header hgroup mark menu meter nav ' +\n\t\t\t\t'output progress section summary ' +\n\t\t\t\t'time video').replace(/\\w+/g, function(name) {\n\t\t\t\t\td.createElement(name);\n\t\t\t\t});\n\n\t\t\t\t// Create all custom elements\n\t\t\t\tfor (name in s.schema.getCustomElements()) {\n\t\t\t\t\td.createElement(name);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\ttinymce.addUnload(t.destroy, t);\n\t\t},\n\n\t\tgetRoot : function() {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\treturn (s && t.get(s.root_element)) || t.doc.body;\n\t\t},\n\n\t\tgetViewPort : function(w) {\n\t\t\tvar d, b;\n\n\t\t\tw = !w ? this.win : w;\n\t\t\td = w.document;\n\t\t\tb = this.boxModel ? d.documentElement : d.body;\n\n\t\t\t// Returns viewport size excluding scrollbars\n\t\t\treturn {\n\t\t\t\tx : w.pageXOffset || b.scrollLeft,\n\t\t\t\ty : w.pageYOffset || b.scrollTop,\n\t\t\t\tw : w.innerWidth || b.clientWidth,\n\t\t\t\th : w.innerHeight || b.clientHeight\n\t\t\t};\n\t\t},\n\n\t\tgetRect : function(e) {\n\t\t\tvar p, t = this, sr;\n\n\t\t\te = t.get(e);\n\t\t\tp = t.getPos(e);\n\t\t\tsr = t.getSize(e);\n\n\t\t\treturn {\n\t\t\t\tx : p.x,\n\t\t\t\ty : p.y,\n\t\t\t\tw : sr.w,\n\t\t\t\th : sr.h\n\t\t\t};\n\t\t},\n\n\t\tgetSize : function(e) {\n\t\t\tvar t = this, w, h;\n\n\t\t\te = t.get(e);\n\t\t\tw = t.getStyle(e, 'width');\n\t\t\th = t.getStyle(e, 'height');\n\n\t\t\t// Non pixel value, then force offset/clientWidth\n\t\t\tif (w.indexOf('px') === -1)\n\t\t\t\tw = 0;\n\n\t\t\t// Non pixel value, then force offset/clientWidth\n\t\t\tif (h.indexOf('px') === -1)\n\t\t\t\th = 0;\n\n\t\t\treturn {\n\t\t\t\tw : parseInt(w) || e.offsetWidth || e.clientWidth,\n\t\t\t\th : parseInt(h) || e.offsetHeight || e.clientHeight\n\t\t\t};\n\t\t},\n\n\t\tgetParent : function(n, f, r) {\n\t\t\treturn this.getParents(n, f, r, false);\n\t\t},\n\n\t\tgetParents : function(n, f, r, c) {\n\t\t\tvar t = this, na, se = t.settings, o = [];\n\n\t\t\tn = t.get(n);\n\t\t\tc = c === undefined;\n\n\t\t\tif (se.strict_root)\n\t\t\t\tr = r || t.getRoot();\n\n\t\t\t// Wrap node name as func\n\t\t\tif (is(f, 'string')) {\n\t\t\t\tna = f;\n\n\t\t\t\tif (f === '*') {\n\t\t\t\t\tf = function(n) {return n.nodeType == 1;};\n\t\t\t\t} else {\n\t\t\t\t\tf = function(n) {\n\t\t\t\t\t\treturn t.is(n, na);\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t}\n\n\t\t\twhile (n) {\n\t\t\t\tif (n == r || !n.nodeType || n.nodeType === 9)\n\t\t\t\t\tbreak;\n\n\t\t\t\tif (!f || f(n)) {\n\t\t\t\t\tif (c)\n\t\t\t\t\t\to.push(n);\n\t\t\t\t\telse\n\t\t\t\t\t\treturn n;\n\t\t\t\t}\n\n\t\t\t\tn = n.parentNode;\n\t\t\t}\n\n\t\t\treturn c ? o : null;\n\t\t},\n\n\t\tget : function(e) {\n\t\t\tvar n;\n\n\t\t\tif (e && this.doc && typeof(e) == 'string') {\n\t\t\t\tn = e;\n\t\t\t\te = this.doc.getElementById(e);\n\n\t\t\t\t// IE and Opera returns meta elements when they match the specified input ID, but getElementsByName seems to do the trick\n\t\t\t\tif (e && e.id !== n)\n\t\t\t\t\treturn this.doc.getElementsByName(n)[1];\n\t\t\t}\n\n\t\t\treturn e;\n\t\t},\n\n\t\tgetNext : function(node, selector) {\n\t\t\treturn this._findSib(node, selector, 'nextSibling');\n\t\t},\n\n\t\tgetPrev : function(node, selector) {\n\t\t\treturn this._findSib(node, selector, 'previousSibling');\n\t\t},\n\n\n\t\tselect : function(pa, s) {\n\t\t\tvar t = this;\n\n\t\t\treturn tinymce.dom.Sizzle(pa, t.get(s) || t.get(t.settings.root_element) || t.doc, []);\n\t\t},\n\n\t\tis : function(n, selector) {\n\t\t\tvar i;\n\n\t\t\t// If it isn't an array then try to do some simple selectors instead of Sizzle for to boost performance\n\t\t\tif (n.length === undefined) {\n\t\t\t\t// Simple all selector\n\t\t\t\tif (selector === '*')\n\t\t\t\t\treturn n.nodeType == 1;\n\n\t\t\t\t// Simple selector just elements\n\t\t\t\tif (simpleSelectorRe.test(selector)) {\n\t\t\t\t\tselector = selector.toLowerCase().split(/,/);\n\t\t\t\t\tn = n.nodeName.toLowerCase();\n\n\t\t\t\t\tfor (i = selector.length - 1; i >= 0; i--) {\n\t\t\t\t\t\tif (selector[i] == n)\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn tinymce.dom.Sizzle.matches(selector, n.nodeType ? [n] : n).length > 0;\n\t\t},\n\n\n\t\tadd : function(p, n, a, h, c) {\n\t\t\tvar t = this;\n\n\t\t\treturn this.run(p, function(p) {\n\t\t\t\tvar e, k;\n\n\t\t\t\te = is(n, 'string') ? t.doc.createElement(n) : n;\n\t\t\t\tt.setAttribs(e, a);\n\n\t\t\t\tif (h) {\n\t\t\t\t\tif (h.nodeType)\n\t\t\t\t\t\te.appendChild(h);\n\t\t\t\t\telse\n\t\t\t\t\t\tt.setHTML(e, h);\n\t\t\t\t}\n\n\t\t\t\treturn !c ? p.appendChild(e) : e;\n\t\t\t});\n\t\t},\n\n\t\tcreate : function(n, a, h) {\n\t\t\treturn this.add(this.doc.createElement(n), n, a, h, 1);\n\t\t},\n\n\t\tcreateHTML : function(n, a, h) {\n\t\t\tvar o = '', t = this, k;\n\n\t\t\to += '<' + n;\n\n\t\t\tfor (k in a) {\n\t\t\t\tif (a.hasOwnProperty(k))\n\t\t\t\t\to += ' ' + k + '=\"' + t.encode(a[k]) + '\"';\n\t\t\t}\n\n\t\t\t// A call to tinymce.is doesn't work for some odd reason on IE9 possible bug inside their JS runtime\n\t\t\tif (typeof(h) != \"undefined\")\n\t\t\t\treturn o + '>' + h + '</' + n + '>';\n\n\t\t\treturn o + ' />';\n\t\t},\n\n\t\tremove : function(node, keep_children) {\n\t\t\treturn this.run(node, function(node) {\n\t\t\t\tvar child, parent = node.parentNode;\n\n\t\t\t\tif (!parent)\n\t\t\t\t\treturn null;\n\n\t\t\t\tif (keep_children) {\n\t\t\t\t\twhile (child = node.firstChild) {\n\t\t\t\t\t\t// IE 8 will crash if you don't remove completely empty text nodes\n\t\t\t\t\t\tif (!tinymce.isIE || child.nodeType !== 3 || child.nodeValue)\n\t\t\t\t\t\t\tparent.insertBefore(child, node);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tnode.removeChild(child);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn parent.removeChild(node);\n\t\t\t});\n\t\t},\n\n\t\tsetStyle : function(n, na, v) {\n\t\t\tvar t = this;\n\n\t\t\treturn t.run(n, function(e) {\n\t\t\t\tvar s, i;\n\n\t\t\t\ts = e.style;\n\n\t\t\t\t// Camelcase it, if needed\n\t\t\t\tna = na.replace(/-(\\D)/g, function(a, b){\n\t\t\t\t\treturn b.toUpperCase();\n\t\t\t\t});\n\n\t\t\t\t// Default px suffix on these\n\t\t\t\tif (t.pixelStyles.test(na) && (tinymce.is(v, 'number') || /^[\\-0-9\\.]+$/.test(v)))\n\t\t\t\t\tv += 'px';\n\n\t\t\t\tswitch (na) {\n\t\t\t\t\tcase 'opacity':\n\t\t\t\t\t\t// IE specific opacity\n\t\t\t\t\t\tif (isIE) {\n\t\t\t\t\t\t\ts.filter = v === '' ? '' : \"alpha(opacity=\" + (v * 100) + \")\";\n\n\t\t\t\t\t\t\tif (!n.currentStyle || !n.currentStyle.hasLayout)\n\t\t\t\t\t\t\t\ts.display = 'inline-block';\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Fix for older browsers\n\t\t\t\t\t\ts[na] = s['-moz-opacity'] = s['-khtml-opacity'] = v || '';\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'float':\n\t\t\t\t\t\tisIE ? s.styleFloat = v : s.cssFloat = v;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t\n\t\t\t\t\tdefault:\n\t\t\t\t\t\ts[na] = v || '';\n\t\t\t\t}\n\n\t\t\t\t// Force update of the style data\n\t\t\t\tif (t.settings.update_styles)\n\t\t\t\t\tt.setAttrib(e, 'data-mce-style');\n\t\t\t});\n\t\t},\n\n\t\tgetStyle : function(n, na, c) {\n\t\t\tn = this.get(n);\n\n\t\t\tif (!n)\n\t\t\t\treturn;\n\n\t\t\t// Gecko\n\t\t\tif (this.doc.defaultView && c) {\n\t\t\t\t// Remove camelcase\n\t\t\t\tna = na.replace(/[A-Z]/g, function(a){\n\t\t\t\t\treturn '-' + a;\n\t\t\t\t});\n\n\t\t\t\ttry {\n\t\t\t\t\treturn this.doc.defaultView.getComputedStyle(n, null).getPropertyValue(na);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Old safari might fail\n\t\t\t\t\treturn null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Camelcase it, if needed\n\t\t\tna = na.replace(/-(\\D)/g, function(a, b){\n\t\t\t\treturn b.toUpperCase();\n\t\t\t});\n\n\t\t\tif (na == 'float')\n\t\t\t\tna = isIE ? 'styleFloat' : 'cssFloat';\n\n\t\t\t// IE & Opera\n\t\t\tif (n.currentStyle && c)\n\t\t\t\treturn n.currentStyle[na];\n\n\t\t\treturn n.style ? n.style[na] : undefined;\n\t\t},\n\n\t\tsetStyles : function(e, o) {\n\t\t\tvar t = this, s = t.settings, ol;\n\n\t\t\tol = s.update_styles;\n\t\t\ts.update_styles = 0;\n\n\t\t\teach(o, function(v, n) {\n\t\t\t\tt.setStyle(e, n, v);\n\t\t\t});\n\n\t\t\t// Update style info\n\t\t\ts.update_styles = ol;\n\t\t\tif (s.update_styles)\n\t\t\t\tt.setAttrib(e, s.cssText);\n\t\t},\n\n\t\tremoveAllAttribs: function(e) {\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\tvar i, attrs = e.attributes;\n\t\t\t\tfor (i = attrs.length - 1; i >= 0; i--) {\n\t\t\t\t\te.removeAttributeNode(attrs.item(i));\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\tsetAttrib : function(e, n, v) {\n\t\t\tvar t = this;\n\n\t\t\t// Whats the point\n\t\t\tif (!e || !n)\n\t\t\t\treturn;\n\n\t\t\t// Strict XML mode\n\t\t\tif (t.settings.strict)\n\t\t\t\tn = n.toLowerCase();\n\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\tvar s = t.settings;\n\t\t\t\tif (v !== null) {\n\t\t\t\t\tswitch (n) {\n\t\t\t\t\t\tcase \"style\":\n\t\t\t\t\t\t\tif (!is(v, 'string')) {\n\t\t\t\t\t\t\t\teach(v, function(v, n) {\n\t\t\t\t\t\t\t\t\tt.setStyle(e, n, v);\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// No mce_style for elements with these since they might get resized by the user\n\t\t\t\t\t\t\tif (s.keep_values) {\n\t\t\t\t\t\t\t\tif (v && !t._isRes(v))\n\t\t\t\t\t\t\t\t\te.setAttribute('data-mce-style', v, 2);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\te.removeAttribute('data-mce-style', 2);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\te.style.cssText = v;\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase \"class\":\n\t\t\t\t\t\t\te.className = v || ''; // Fix IE null bug\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase \"src\":\n\t\t\t\t\t\tcase \"href\":\n\t\t\t\t\t\t\tif (s.keep_values) {\n\t\t\t\t\t\t\t\tif (s.url_converter)\n\t\t\t\t\t\t\t\t\tv = s.url_converter.call(s.url_converter_scope || t, v, n, e);\n\n\t\t\t\t\t\t\t\tt.setAttrib(e, 'data-mce-' + n, v, 2);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase \"shape\":\n\t\t\t\t\t\t\te.setAttribute('data-mce-style', v);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif (is(v) && v !== null && v.length !== 0)\n\t\t\t\t\te.setAttribute(n, '' + v, 2);\n\t\t\t\telse\n\t\t\t\t\te.removeAttribute(n, 2);\n\t\t\t});\n\t\t},\n\n\t\tsetAttribs : function(e, o) {\n\t\t\tvar t = this;\n\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\teach(o, function(v, n) {\n\t\t\t\t\tt.setAttrib(e, n, v);\n\t\t\t\t});\n\t\t\t});\n\t\t},\n\n\t\tgetAttrib : function(e, n, dv) {\n\t\t\tvar v, t = this, undef;\n\n\t\t\te = t.get(e);\n\n\t\t\tif (!e || e.nodeType !== 1)\n\t\t\t\treturn dv === undef ? false : dv;\n\n\t\t\tif (!is(dv))\n\t\t\t\tdv = '';\n\n\t\t\t// Try the mce variant for these\n\t\t\tif (/^(src|href|style|coords|shape)$/.test(n)) {\n\t\t\t\tv = e.getAttribute(\"data-mce-\" + n);\n\n\t\t\t\tif (v)\n\t\t\t\t\treturn v;\n\t\t\t}\n\n\t\t\tif (isIE && t.props[n]) {\n\t\t\t\tv = e[t.props[n]];\n\t\t\t\tv = v && v.nodeValue ? v.nodeValue : v;\n\t\t\t}\n\n\t\t\tif (!v)\n\t\t\t\tv = e.getAttribute(n, 2);\n\n\t\t\t// Check boolean attribs\n\t\t\tif (/^(checked|compact|declare|defer|disabled|ismap|multiple|nohref|noshade|nowrap|readonly|selected)$/.test(n)) {\n\t\t\t\tif (e[t.props[n]] === true && v === '')\n\t\t\t\t\treturn n;\n\n\t\t\t\treturn v ? n : '';\n\t\t\t}\n\n\t\t\t// Inner input elements will override attributes on form elements\n\t\t\tif (e.nodeName === \"FORM\" && e.getAttributeNode(n))\n\t\t\t\treturn e.getAttributeNode(n).nodeValue;\n\n\t\t\tif (n === 'style') {\n\t\t\t\tv = v || e.style.cssText;\n\n\t\t\t\tif (v) {\n\t\t\t\t\tv = t.serializeStyle(t.parseStyle(v), e.nodeName);\n\n\t\t\t\t\tif (t.settings.keep_values && !t._isRes(v))\n\t\t\t\t\t\te.setAttribute('data-mce-style', v);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Remove Apple and WebKit stuff\n\t\t\tif (isWebKit && n === \"class\" && v)\n\t\t\t\tv = v.replace(/(apple|webkit)\\-[a-z\\-]+/gi, '');\n\n\t\t\t// Handle IE issues\n\t\t\tif (isIE) {\n\t\t\t\tswitch (n) {\n\t\t\t\t\tcase 'rowspan':\n\t\t\t\t\tcase 'colspan':\n\t\t\t\t\t\t// IE returns 1 as default value\n\t\t\t\t\t\tif (v === 1)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'size':\n\t\t\t\t\t\t// IE returns +0 as default value for size\n\t\t\t\t\t\tif (v === '+0' || v === 20 || v === 0)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'width':\n\t\t\t\t\tcase 'height':\n\t\t\t\t\tcase 'vspace':\n\t\t\t\t\tcase 'checked':\n\t\t\t\t\tcase 'disabled':\n\t\t\t\t\tcase 'readonly':\n\t\t\t\t\t\tif (v === 0)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'hspace':\n\t\t\t\t\t\t// IE returns -1 as default value\n\t\t\t\t\t\tif (v === -1)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'maxlength':\n\t\t\t\t\tcase 'tabindex':\n\t\t\t\t\t\t// IE returns default value\n\t\t\t\t\t\tif (v === 32768 || v === 2147483647 || v === '32768')\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'multiple':\n\t\t\t\t\tcase 'compact':\n\t\t\t\t\tcase 'noshade':\n\t\t\t\t\tcase 'nowrap':\n\t\t\t\t\t\tif (v === 65535)\n\t\t\t\t\t\t\treturn n;\n\n\t\t\t\t\t\treturn dv;\n\n\t\t\t\t\tcase 'shape':\n\t\t\t\t\t\tv = v.toLowerCase();\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tdefault:\n\t\t\t\t\t\t// IE has odd anonymous function for event attributes\n\t\t\t\t\t\tif (n.indexOf('on') === 0 && v)\n\t\t\t\t\t\t\tv = tinymce._replace(/^function\\s+\\w+\\(\\)\\s+\\{\\s+(.*)\\s+\\}$/, '$1', '' + v);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn (v !== undef && v !== null && v !== '') ? '' + v : dv;\n\t\t},\n\n\t\tgetPos : function(n, ro) {\n\t\t\tvar t = this, x = 0, y = 0, e, d = t.doc, r;\n\n\t\t\tn = t.get(n);\n\t\t\tro = ro || d.body;\n\n\t\t\tif (n) {\n\t\t\t\t// Use getBoundingClientRect if it exists since it's faster than looping offset nodes\n\t\t\t\tif (n.getBoundingClientRect) {\n\t\t\t\t\tn = n.getBoundingClientRect();\n\t\t\t\t\te = t.boxModel ? d.documentElement : d.body;\n\n\t\t\t\t\t// Add scroll offsets from documentElement or body since IE with the wrong box model will use d.body and so do WebKit\n\t\t\t\t\t// Also remove the body/documentelement clientTop/clientLeft on IE 6, 7 since they offset the position\n\t\t\t\t\tx = n.left + (d.documentElement.scrollLeft || d.body.scrollLeft) - e.clientTop;\n\t\t\t\t\ty = n.top + (d.documentElement.scrollTop || d.body.scrollTop) - e.clientLeft;\n\n\t\t\t\t\treturn {x : x, y : y};\n\t\t\t\t}\n\n\t\t\t\tr = n;\n\t\t\t\twhile (r && r != ro && r.nodeType) {\n\t\t\t\t\tx += r.offsetLeft || 0;\n\t\t\t\t\ty += r.offsetTop || 0;\n\t\t\t\t\tr = r.offsetParent;\n\t\t\t\t}\n\n\t\t\t\tr = n.parentNode;\n\t\t\t\twhile (r && r != ro && r.nodeType) {\n\t\t\t\t\tx -= r.scrollLeft || 0;\n\t\t\t\t\ty -= r.scrollTop || 0;\n\t\t\t\t\tr = r.parentNode;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn {x : x, y : y};\n\t\t},\n\n\t\tparseStyle : function(st) {\n\t\t\treturn this.styles.parse(st);\n\t\t},\n\n\t\tserializeStyle : function(o, name) {\n\t\t\treturn this.styles.serialize(o, name);\n\t\t},\n\n\t\tloadCSS : function(u) {\n\t\t\tvar t = this, d = t.doc, head;\n\n\t\t\tif (!u)\n\t\t\t\tu = '';\n\n\t\t\thead = t.select('head')[0];\n\n\t\t\teach(u.split(','), function(u) {\n\t\t\t\tvar link;\n\n\t\t\t\tif (t.files[u])\n\t\t\t\t\treturn;\n\n\t\t\t\tt.files[u] = true;\n\t\t\t\tlink = t.create('link', {rel : 'stylesheet', href : tinymce._addVer(u)});\n\n\t\t\t\t// IE 8 has a bug where dynamically loading stylesheets would produce a 1 item remaining bug\n\t\t\t\t// This fix seems to resolve that issue by realcing the document ones a stylesheet finishes loading\n\t\t\t\t// It's ugly but it seems to work fine.\n\t\t\t\tif (isIE && d.documentMode && d.recalc) {\n\t\t\t\t\tlink.onload = function() {\n\t\t\t\t\t\tif (d.recalc)\n\t\t\t\t\t\t\td.recalc();\n\n\t\t\t\t\t\tlink.onload = null;\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\thead.appendChild(link);\n\t\t\t});\n\t\t},\n\n\t\taddClass : function(e, c) {\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\tvar o;\n\n\t\t\t\tif (!c)\n\t\t\t\t\treturn 0;\n\n\t\t\t\tif (this.hasClass(e, c))\n\t\t\t\t\treturn e.className;\n\n\t\t\t\to = this.removeClass(e, c);\n\n\t\t\t\treturn e.className = (o != '' ? (o + ' ') : '') + c;\n\t\t\t});\n\t\t},\n\n\t\tremoveClass : function(e, c) {\n\t\t\tvar t = this, re;\n\n\t\t\treturn t.run(e, function(e) {\n\t\t\t\tvar v;\n\n\t\t\t\tif (t.hasClass(e, c)) {\n\t\t\t\t\tif (!re)\n\t\t\t\t\t\tre = new RegExp(\"(^|\\\\s+)\" + c + \"(\\\\s+|$)\", \"g\");\n\n\t\t\t\t\tv = e.className.replace(re, ' ');\n\t\t\t\t\tv = tinymce.trim(v != ' ' ? v : '');\n\n\t\t\t\t\te.className = v;\n\n\t\t\t\t\t// Empty class attr\n\t\t\t\t\tif (!v) {\n\t\t\t\t\t\te.removeAttribute('class');\n\t\t\t\t\t\te.removeAttribute('className');\n\t\t\t\t\t}\n\n\t\t\t\t\treturn v;\n\t\t\t\t}\n\n\t\t\t\treturn e.className;\n\t\t\t});\n\t\t},\n\n\t\thasClass : function(n, c) {\n\t\t\tn = this.get(n);\n\n\t\t\tif (!n || !c)\n\t\t\t\treturn false;\n\n\t\t\treturn (' ' + n.className + ' ').indexOf(' ' + c + ' ') !== -1;\n\t\t},\n\n\t\tshow : function(e) {\n\t\t\treturn this.setStyle(e, 'display', 'block');\n\t\t},\n\n\t\thide : function(e) {\n\t\t\treturn this.setStyle(e, 'display', 'none');\n\t\t},\n\n\t\tisHidden : function(e) {\n\t\t\te = this.get(e);\n\n\t\t\treturn !e || e.style.display == 'none' || this.getStyle(e, 'display') == 'none';\n\t\t},\n\n\t\tuniqueId : function(p) {\n\t\t\treturn (!p ? 'mce_' : p) + (this.counter++);\n\t\t},\n\n\t\tsetHTML : function(element, html) {\n\t\t\tvar self = this;\n\n\t\t\treturn self.run(element, function(element) {\n\t\t\t\tif (isIE) {\n\t\t\t\t\t// Remove all child nodes, IE keeps empty text nodes in DOM\n\t\t\t\t\twhile (element.firstChild)\n\t\t\t\t\t\telement.removeChild(element.firstChild);\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\t// IE will remove comments from the beginning\n\t\t\t\t\t\t// unless you padd the contents with something\n\t\t\t\t\t\telement.innerHTML = '<br />' + html;\n\t\t\t\t\t\telement.removeChild(element.firstChild);\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// IE sometimes produces an unknown runtime error on innerHTML if it's an block element within a block element for example a div inside a p\n\t\t\t\t\t\t// This seems to fix this problem\n\n\t\t\t\t\t\t// Create new div with HTML contents and a BR infront to keep comments\n\t\t\t\t\t\telement = self.create('div');\n\t\t\t\t\t\telement.innerHTML = '<br />' + html;\n\n\t\t\t\t\t\t// Add all children from div to target\n\t\t\t\t\t\teach (element.childNodes, function(node, i) {\n\t\t\t\t\t\t\t// Skip br element\n\t\t\t\t\t\t\tif (i)\n\t\t\t\t\t\t\t\telement.appendChild(node);\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t} else\n\t\t\t\t\telement.innerHTML = html;\n\n\t\t\t\treturn html;\n\t\t\t});\n\t\t},\n\n\t\tgetOuterHTML : function(elm) {\n\t\t\tvar doc, self = this;\n\n\t\t\telm = self.get(elm);\n\n\t\t\tif (!elm)\n\t\t\t\treturn null;\n\n\t\t\tif (elm.nodeType === 1 && self.hasOuterHTML)\n\t\t\t\treturn elm.outerHTML;\n\n\t\t\tdoc = (elm.ownerDocument || self.doc).createElement(\"body\");\n\t\t\tdoc.appendChild(elm.cloneNode(true));\n\n\t\t\treturn doc.innerHTML;\n\t\t},\n\n\t\tsetOuterHTML : function(e, h, d) {\n\t\t\tvar t = this;\n\n\t\t\tfunction setHTML(e, h, d) {\n\t\t\t\tvar n, tp;\n\n\t\t\t\ttp = d.createElement(\"body\");\n\t\t\t\ttp.innerHTML = h;\n\n\t\t\t\tn = tp.lastChild;\n\t\t\t\twhile (n) {\n\t\t\t\t\tt.insertAfter(n.cloneNode(true), e);\n\t\t\t\t\tn = n.previousSibling;\n\t\t\t\t}\n\n\t\t\t\tt.remove(e);\n\t\t\t};\n\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\te = t.get(e);\n\n\t\t\t\t// Only set HTML on elements\n\t\t\t\tif (e.nodeType == 1) {\n\t\t\t\t\td = d || e.ownerDocument || t.doc;\n\n\t\t\t\t\tif (isIE) {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t// Try outerHTML for IE it sometimes produces an unknown runtime error\n\t\t\t\t\t\t\tif (isIE && e.nodeType == 1)\n\t\t\t\t\t\t\t\te.outerHTML = h;\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tsetHTML(e, h, d);\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\t// Fix for unknown runtime error\n\t\t\t\t\t\t\tsetHTML(e, h, d);\n\t\t\t\t\t\t}\n\t\t\t\t\t} else\n\t\t\t\t\t\tsetHTML(e, h, d);\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\tdecode : Entities.decode,\n\n\t\tencode : Entities.encodeAllRaw,\n\n\t\tinsertAfter : function(node, reference_node) {\n\t\t\treference_node = this.get(reference_node);\n\n\t\t\treturn this.run(node, function(node) {\n\t\t\t\tvar parent, nextSibling;\n\n\t\t\t\tparent = reference_node.parentNode;\n\t\t\t\tnextSibling = reference_node.nextSibling;\n\n\t\t\t\tif (nextSibling)\n\t\t\t\t\tparent.insertBefore(node, nextSibling);\n\t\t\t\telse\n\t\t\t\t\tparent.appendChild(node);\n\n\t\t\t\treturn node;\n\t\t\t});\n\t\t},\n\n\t\tisBlock : function(node) {\n\t\t\tvar type = node.nodeType;\n\n\t\t\t// If it's a node then check the type and use the nodeName\n\t\t\tif (type)\n\t\t\t\treturn !!(type === 1 && blockElementsMap[node.nodeName]);\n\n\t\t\treturn !!blockElementsMap[node];\n\t\t},\n\n\t\treplace : function(n, o, k) {\n\t\t\tvar t = this;\n\n\t\t\tif (is(o, 'array'))\n\t\t\t\tn = n.cloneNode(true);\n\n\t\t\treturn t.run(o, function(o) {\n\t\t\t\tif (k) {\n\t\t\t\t\teach(tinymce.grep(o.childNodes), function(c) {\n\t\t\t\t\t\tn.appendChild(c);\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\treturn o.parentNode.replaceChild(n, o);\n\t\t\t});\n\t\t},\n\n\t\trename : function(elm, name) {\n\t\t\tvar t = this, newElm;\n\n\t\t\tif (elm.nodeName != name.toUpperCase()) {\n\t\t\t\t// Rename block element\n\t\t\t\tnewElm = t.create(name);\n\n\t\t\t\t// Copy attribs to new block\n\t\t\t\teach(t.getAttribs(elm), function(attr_node) {\n\t\t\t\t\tt.setAttrib(newElm, attr_node.nodeName, t.getAttrib(elm, attr_node.nodeName));\n\t\t\t\t});\n\n\t\t\t\t// Replace block\n\t\t\t\tt.replace(newElm, elm, 1);\n\t\t\t}\n\n\t\t\treturn newElm || elm;\n\t\t},\n\n\t\tfindCommonAncestor : function(a, b) {\n\t\t\tvar ps = a, pe;\n\n\t\t\twhile (ps) {\n\t\t\t\tpe = b;\n\n\t\t\t\twhile (pe && ps != pe)\n\t\t\t\t\tpe = pe.parentNode;\n\n\t\t\t\tif (ps == pe)\n\t\t\t\t\tbreak;\n\n\t\t\t\tps = ps.parentNode;\n\t\t\t}\n\n\t\t\tif (!ps && a.ownerDocument)\n\t\t\t\treturn a.ownerDocument.documentElement;\n\n\t\t\treturn ps;\n\t\t},\n\n\t\ttoHex : function(s) {\n\t\t\tvar c = /^\\s*rgb\\s*?\\(\\s*?([0-9]+)\\s*?,\\s*?([0-9]+)\\s*?,\\s*?([0-9]+)\\s*?\\)\\s*$/i.exec(s);\n\n\t\t\tfunction hex(s) {\n\t\t\t\ts = parseInt(s).toString(16);\n\n\t\t\t\treturn s.length > 1 ? s : '0' + s; // 0 -> 00\n\t\t\t};\n\n\t\t\tif (c) {\n\t\t\t\ts = '#' + hex(c[1]) + hex(c[2]) + hex(c[3]);\n\n\t\t\t\treturn s;\n\t\t\t}\n\n\t\t\treturn s;\n\t\t},\n\n\t\tgetClasses : function() {\n\t\t\tvar t = this, cl = [], i, lo = {}, f = t.settings.class_filter, ov;\n\n\t\t\tif (t.classes)\n\t\t\t\treturn t.classes;\n\n\t\t\tfunction addClasses(s) {\n\t\t\t\t// IE style imports\n\t\t\t\teach(s.imports, function(r) {\n\t\t\t\t\taddClasses(r);\n\t\t\t\t});\n\n\t\t\t\teach(s.cssRules || s.rules, function(r) {\n\t\t\t\t\t// Real type or fake it on IE\n\t\t\t\t\tswitch (r.type || 1) {\n\t\t\t\t\t\t// Rule\n\t\t\t\t\t\tcase 1:\n\t\t\t\t\t\t\tif (r.selectorText) {\n\t\t\t\t\t\t\t\teach(r.selectorText.split(','), function(v) {\n\t\t\t\t\t\t\t\t\tv = v.replace(/^\\s*|\\s*$|^\\s\\./g, \"\");\n\n\t\t\t\t\t\t\t\t\t// Is internal or it doesn't contain a class\n\t\t\t\t\t\t\t\t\tif (/\\.mce/.test(v) || !/\\.[\\w\\-]+$/.test(v))\n\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t// Remove everything but class name\n\t\t\t\t\t\t\t\t\tov = v;\n\t\t\t\t\t\t\t\t\tv = tinymce._replace(/.*\\.([a-z0-9_\\-]+).*/i, '$1', v);\n\n\t\t\t\t\t\t\t\t\t// Filter classes\n\t\t\t\t\t\t\t\t\tif (f && !(v = f(v, ov)))\n\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\tif (!lo[v]) {\n\t\t\t\t\t\t\t\t\t\tcl.push({'class' : v});\n\t\t\t\t\t\t\t\t\t\tlo[v] = 1;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\t// Import\n\t\t\t\t\t\tcase 3:\n\t\t\t\t\t\t\taddClasses(r.styleSheet);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t};\n\n\t\t\ttry {\n\t\t\t\teach(t.doc.styleSheets, addClasses);\n\t\t\t} catch (ex) {\n\t\t\t\t// Ignore\n\t\t\t}\n\n\t\t\tif (cl.length > 0)\n\t\t\t\tt.classes = cl;\n\n\t\t\treturn cl;\n\t\t},\n\n\t\trun : function(e, f, s) {\n\t\t\tvar t = this, o;\n\n\t\t\tif (t.doc && typeof(e) === 'string')\n\t\t\t\te = t.get(e);\n\n\t\t\tif (!e)\n\t\t\t\treturn false;\n\n\t\t\ts = s || this;\n\t\t\tif (!e.nodeType && (e.length || e.length === 0)) {\n\t\t\t\to = [];\n\n\t\t\t\teach(e, function(e, i) {\n\t\t\t\t\tif (e) {\n\t\t\t\t\t\tif (typeof(e) == 'string')\n\t\t\t\t\t\t\te = t.doc.getElementById(e);\n\n\t\t\t\t\t\to.push(f.call(s, e, i));\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\treturn o;\n\t\t\t}\n\n\t\t\treturn f.call(s, e);\n\t\t},\n\n\t\tgetAttribs : function(n) {\n\t\t\tvar o;\n\n\t\t\tn = this.get(n);\n\n\t\t\tif (!n)\n\t\t\t\treturn [];\n\n\t\t\tif (isIE) {\n\t\t\t\to = [];\n\n\t\t\t\t// Object will throw exception in IE\n\t\t\t\tif (n.nodeName == 'OBJECT')\n\t\t\t\t\treturn n.attributes;\n\n\t\t\t\t// IE doesn't keep the selected attribute if you clone option elements\n\t\t\t\tif (n.nodeName === 'OPTION' && this.getAttrib(n, 'selected'))\n\t\t\t\t\to.push({specified : 1, nodeName : 'selected'});\n\n\t\t\t\t// It's crazy that this is faster in IE but it's because it returns all attributes all the time\n\t\t\t\tn.cloneNode(false).outerHTML.replace(/<\\/?[\\w:\\-]+ ?|=[\\\"][^\\\"]+\\\"|=\\'[^\\']+\\'|=[\\w\\-]+|>/gi, '').replace(/[\\w:\\-]+/gi, function(a) {\n\t\t\t\t\to.push({specified : 1, nodeName : a});\n\t\t\t\t});\n\n\t\t\t\treturn o;\n\t\t\t}\n\n\t\t\treturn n.attributes;\n\t\t},\n\n\t\tisEmpty : function(node, elements) {\n\t\t\tvar self = this, i, attributes, type, walker, name, parentNode;\n\n\t\t\tnode = node.firstChild;\n\t\t\tif (node) {\n\t\t\t\twalker = new tinymce.dom.TreeWalker(node);\n\t\t\t\telements = elements || self.schema ? self.schema.getNonEmptyElements() : null;\n\n\t\t\t\tdo {\n\t\t\t\t\ttype = node.nodeType;\n\n\t\t\t\t\tif (type === 1) {\n\t\t\t\t\t\t// Ignore bogus elements\n\t\t\t\t\t\tif (node.getAttribute('data-mce-bogus'))\n\t\t\t\t\t\t\tcontinue;\n\n\t\t\t\t\t\t// Keep empty elements like <img />\n\t\t\t\t\t\tname = node.nodeName.toLowerCase();\n\t\t\t\t\t\tif (elements && elements[name]) {\n\t\t\t\t\t\t\t// Ignore single BR elements in blocks like <p><br /></p>\n\t\t\t\t\t\t\tparentNode = node.parentNode;\n\t\t\t\t\t\t\tif (name === 'br' && self.isBlock(parentNode) && parentNode.firstChild === node && parentNode.lastChild === node) {\n\t\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Keep elements with data-bookmark attributes or name attribute like <a name=\"1\"></a>\n\t\t\t\t\t\tattributes = self.getAttribs(node);\n\t\t\t\t\t\ti = node.attributes.length;\n\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\tname = node.attributes[i].nodeName;\n\t\t\t\t\t\t\tif (name === \"name\" || name === 'data-mce-bookmark')\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Keep non whitespace text nodes\n\t\t\t\t\tif ((type === 3 && !whiteSpaceRegExp.test(node.nodeValue)))\n\t\t\t\t\t\treturn false;\n\t\t\t\t} while (node = walker.next());\n\t\t\t}\n\n\t\t\treturn true;\n\t\t},\n\n\t\tdestroy : function(s) {\n\t\t\tvar t = this;\n\n\t\t\tif (t.events)\n\t\t\t\tt.events.destroy();\n\n\t\t\tt.win = t.doc = t.root = t.events = null;\n\n\t\t\t// Manual destroy then remove unload handler\n\t\t\tif (!s)\n\t\t\t\ttinymce.removeUnload(t.destroy);\n\t\t},\n\n\t\tcreateRng : function() {\n\t\t\tvar d = this.doc;\n\n\t\t\treturn d.createRange ? d.createRange() : new tinymce.dom.Range(this);\n\t\t},\n\n\t\tnodeIndex : function(node, normalized) {\n\t\t\tvar idx = 0, lastNodeType, lastNode, nodeType;\n\n\t\t\tif (node) {\n\t\t\t\tfor (lastNodeType = node.nodeType, node = node.previousSibling, lastNode = node; node; node = node.previousSibling) {\n\t\t\t\t\tnodeType = node.nodeType;\n\n\t\t\t\t\t// Normalize text nodes\n\t\t\t\t\tif (normalized && nodeType == 3) {\n\t\t\t\t\t\tif (nodeType == lastNodeType || !node.nodeValue.length)\n\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\t\t\t\t\tidx++;\n\t\t\t\t\tlastNodeType = nodeType;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn idx;\n\t\t},\n\n\t\tsplit : function(pe, e, re) {\n\t\t\tvar t = this, r = t.createRng(), bef, aft, pa;\n\n\t\t\t// W3C valid browsers tend to leave empty nodes to the left/right side of the contents, this makes sense\n\t\t\t// but we don't want that in our code since it serves no purpose for the end user\n\t\t\t// For example if this is chopped:\n\t\t\t//   <p>text 1<span><b>CHOP</b></span>text 2</p>\n\t\t\t// would produce:\n\t\t\t//   <p>text 1<span></span></p><b>CHOP</b><p><span></span>text 2</p>\n\t\t\t// this function will then trim of empty edges and produce:\n\t\t\t//   <p>text 1</p><b>CHOP</b><p>text 2</p>\n\t\t\tfunction trim(node) {\n\t\t\t\tvar i, children = node.childNodes, type = node.nodeType;\n\n\t\t\t\tif (type == 1 && node.getAttribute('data-mce-type') == 'bookmark')\n\t\t\t\t\treturn;\n\n\t\t\t\tfor (i = children.length - 1; i >= 0; i--)\n\t\t\t\t\ttrim(children[i]);\n\n\t\t\t\tif (type != 9) {\n\t\t\t\t\t// Keep non whitespace text nodes\n\t\t\t\t\tif (type == 3 && node.nodeValue.length > 0) {\n\t\t\t\t\t\t// If parent element isn't a block or there isn't any useful contents for example \"<p>   </p>\"\n\t\t\t\t\t\tif (!t.isBlock(node.parentNode) || tinymce.trim(node.nodeValue).length > 0)\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t} else if (type == 1) {\n\t\t\t\t\t\t// If the only child is a bookmark then move it up\n\t\t\t\t\t\tchildren = node.childNodes;\n\t\t\t\t\t\tif (children.length == 1 && children[0] && children[0].nodeType == 1 && children[0].getAttribute('data-mce-type') == 'bookmark')\n\t\t\t\t\t\t\tnode.parentNode.insertBefore(children[0], node);\n\n\t\t\t\t\t\t// Keep non empty elements or img, hr etc\n\t\t\t\t\t\tif (children.length || /^(br|hr|input|img)$/i.test(node.nodeName))\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tt.remove(node);\n\t\t\t\t}\n\n\t\t\t\treturn node;\n\t\t\t};\n\n\t\t\tif (pe && e) {\n\t\t\t\t// Get before chunk\n\t\t\t\tr.setStart(pe.parentNode, t.nodeIndex(pe));\n\t\t\t\tr.setEnd(e.parentNode, t.nodeIndex(e));\n\t\t\t\tbef = r.extractContents();\n\n\t\t\t\t// Get after chunk\n\t\t\t\tr = t.createRng();\n\t\t\t\tr.setStart(e.parentNode, t.nodeIndex(e) + 1);\n\t\t\t\tr.setEnd(pe.parentNode, t.nodeIndex(pe) + 1);\n\t\t\t\taft = r.extractContents();\n\n\t\t\t\t// Insert before chunk\n\t\t\t\tpa = pe.parentNode;\n\t\t\t\tpa.insertBefore(trim(bef), pe);\n\n\t\t\t\t// Insert middle chunk\n\t\t\t\tif (re)\n\t\t\t\t\tpa.replaceChild(re, e);\n\t\t\t\telse\n\t\t\t\t\tpa.insertBefore(e, pe);\n\n\t\t\t\t// Insert after chunk\n\t\t\t\tpa.insertBefore(trim(aft), pe);\n\t\t\t\tt.remove(pe);\n\n\t\t\t\treturn re || e;\n\t\t\t}\n\t\t},\n\n\t\tbind : function(target, name, func, scope) {\n\t\t\tvar t = this;\n\n\t\t\tif (!t.events)\n\t\t\t\tt.events = new tinymce.dom.EventUtils();\n\n\t\t\treturn t.events.add(target, name, func, scope || this);\n\t\t},\n\n\t\tunbind : function(target, name, func) {\n\t\t\tvar t = this;\n\n\t\t\tif (!t.events)\n\t\t\t\tt.events = new tinymce.dom.EventUtils();\n\n\t\t\treturn t.events.remove(target, name, func);\n\t\t},\n\n\n\t\t_findSib : function(node, selector, name) {\n\t\t\tvar t = this, f = selector;\n\n\t\t\tif (node) {\n\t\t\t\t// If expression make a function of it using is\n\t\t\t\tif (is(f, 'string')) {\n\t\t\t\t\tf = function(node) {\n\t\t\t\t\t\treturn t.is(node, selector);\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\t// Loop all siblings\n\t\t\t\tfor (node = node[name]; node; node = node[name]) {\n\t\t\t\t\tif (f(node))\n\t\t\t\t\t\treturn node;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn null;\n\t\t},\n\n\t\t_isRes : function(c) {\n\t\t\t// Is live resizble element\n\t\t\treturn /^(top|left|bottom|right|width|height)/i.test(c) || /;\\s*(top|left|bottom|right|width|height)/i.test(c);\n\t\t}\n\n\t\t/*\n\t\twalk : function(n, f, s) {\n\t\t\tvar d = this.doc, w;\n\n\t\t\tif (d.createTreeWalker) {\n\t\t\t\tw = d.createTreeWalker(n, NodeFilter.SHOW_TEXT, null, false);\n\n\t\t\t\twhile ((n = w.nextNode()) != null)\n\t\t\t\t\tf.call(s || this, n);\n\t\t\t} else\n\t\t\t\ttinymce.walk(n, f, 'childNodes', s);\n\t\t}\n\t\t*/\n\n\t\t/*\n\t\ttoRGB : function(s) {\n\t\t\tvar c = /^\\s*?#([0-9A-F]{2})([0-9A-F]{1,2})([0-9A-F]{2})?\\s*?$/.exec(s);\n\n\t\t\tif (c) {\n\t\t\t\t// #FFF -> #FFFFFF\n\t\t\t\tif (!is(c[3]))\n\t\t\t\t\tc[3] = c[2] = c[1];\n\n\t\t\t\treturn \"rgb(\" + parseInt(c[1], 16) + \",\" + parseInt(c[2], 16) + \",\" + parseInt(c[3], 16) + \")\";\n\t\t\t}\n\n\t\t\treturn s;\n\t\t}\n\t\t*/\n\t});\n\n\ttinymce.DOM = new tinymce.dom.DOMUtils(document, {process_html : 0});\n})(tinymce);\n\n(function(ns) {\n\t// Range constructor\n\tfunction Range(dom) {\n\t\tvar t = this,\n\t\t\tdoc = dom.doc,\n\t\t\tEXTRACT = 0,\n\t\t\tCLONE = 1,\n\t\t\tDELETE = 2,\n\t\t\tTRUE = true,\n\t\t\tFALSE = false,\n\t\t\tSTART_OFFSET = 'startOffset',\n\t\t\tSTART_CONTAINER = 'startContainer',\n\t\t\tEND_CONTAINER = 'endContainer',\n\t\t\tEND_OFFSET = 'endOffset',\n\t\t\textend = tinymce.extend,\n\t\t\tnodeIndex = dom.nodeIndex;\n\n\t\textend(t, {\n\t\t\t// Inital states\n\t\t\tstartContainer : doc,\n\t\t\tstartOffset : 0,\n\t\t\tendContainer : doc,\n\t\t\tendOffset : 0,\n\t\t\tcollapsed : TRUE,\n\t\t\tcommonAncestorContainer : doc,\n\n\t\t\t// Range constants\n\t\t\tSTART_TO_START : 0,\n\t\t\tSTART_TO_END : 1,\n\t\t\tEND_TO_END : 2,\n\t\t\tEND_TO_START : 3,\n\n\t\t\t// Public methods\n\t\t\tsetStart : setStart,\n\t\t\tsetEnd : setEnd,\n\t\t\tsetStartBefore : setStartBefore,\n\t\t\tsetStartAfter : setStartAfter,\n\t\t\tsetEndBefore : setEndBefore,\n\t\t\tsetEndAfter : setEndAfter,\n\t\t\tcollapse : collapse,\n\t\t\tselectNode : selectNode,\n\t\t\tselectNodeContents : selectNodeContents,\n\t\t\tcompareBoundaryPoints : compareBoundaryPoints,\n\t\t\tdeleteContents : deleteContents,\n\t\t\textractContents : extractContents,\n\t\t\tcloneContents : cloneContents,\n\t\t\tinsertNode : insertNode,\n\t\t\tsurroundContents : surroundContents,\n\t\t\tcloneRange : cloneRange\n\t\t});\n\n\t\tfunction setStart(n, o) {\n\t\t\t_setEndPoint(TRUE, n, o);\n\t\t};\n\n\t\tfunction setEnd(n, o) {\n\t\t\t_setEndPoint(FALSE, n, o);\n\t\t};\n\n\t\tfunction setStartBefore(n) {\n\t\t\tsetStart(n.parentNode, nodeIndex(n));\n\t\t};\n\n\t\tfunction setStartAfter(n) {\n\t\t\tsetStart(n.parentNode, nodeIndex(n) + 1);\n\t\t};\n\n\t\tfunction setEndBefore(n) {\n\t\t\tsetEnd(n.parentNode, nodeIndex(n));\n\t\t};\n\n\t\tfunction setEndAfter(n) {\n\t\t\tsetEnd(n.parentNode, nodeIndex(n) + 1);\n\t\t};\n\n\t\tfunction collapse(ts) {\n\t\t\tif (ts) {\n\t\t\t\tt[END_CONTAINER] = t[START_CONTAINER];\n\t\t\t\tt[END_OFFSET] = t[START_OFFSET];\n\t\t\t} else {\n\t\t\t\tt[START_CONTAINER] = t[END_CONTAINER];\n\t\t\t\tt[START_OFFSET] = t[END_OFFSET];\n\t\t\t}\n\n\t\t\tt.collapsed = TRUE;\n\t\t};\n\n\t\tfunction selectNode(n) {\n\t\t\tsetStartBefore(n);\n\t\t\tsetEndAfter(n);\n\t\t};\n\n\t\tfunction selectNodeContents(n) {\n\t\t\tsetStart(n, 0);\n\t\t\tsetEnd(n, n.nodeType === 1 ? n.childNodes.length : n.nodeValue.length);\n\t\t};\n\n\t\tfunction compareBoundaryPoints(h, r) {\n\t\t\tvar sc = t[START_CONTAINER], so = t[START_OFFSET], ec = t[END_CONTAINER], eo = t[END_OFFSET],\n\t\t\trsc = r.startContainer, rso = r.startOffset, rec = r.endContainer, reo = r.endOffset;\n\n\t\t\t// Check START_TO_START\n\t\t\tif (h === 0)\n\t\t\t\treturn _compareBoundaryPoints(sc, so, rsc, rso);\n\t\n\t\t\t// Check START_TO_END\n\t\t\tif (h === 1)\n\t\t\t\treturn _compareBoundaryPoints(ec, eo, rsc, rso);\n\t\n\t\t\t// Check END_TO_END\n\t\t\tif (h === 2)\n\t\t\t\treturn _compareBoundaryPoints(ec, eo, rec, reo);\n\t\n\t\t\t// Check END_TO_START\n\t\t\tif (h === 3) \n\t\t\t\treturn _compareBoundaryPoints(sc, so, rec, reo);\n\t\t};\n\n\t\tfunction deleteContents() {\n\t\t\t_traverse(DELETE);\n\t\t};\n\n\t\tfunction extractContents() {\n\t\t\treturn _traverse(EXTRACT);\n\t\t};\n\n\t\tfunction cloneContents() {\n\t\t\treturn _traverse(CLONE);\n\t\t};\n\n\t\tfunction insertNode(n) {\n\t\t\tvar startContainer = this[START_CONTAINER],\n\t\t\t\tstartOffset = this[START_OFFSET], nn, o;\n\n\t\t\t// Node is TEXT_NODE or CDATA\n\t\t\tif ((startContainer.nodeType === 3 || startContainer.nodeType === 4) && startContainer.nodeValue) {\n\t\t\t\tif (!startOffset) {\n\t\t\t\t\t// At the start of text\n\t\t\t\t\tstartContainer.parentNode.insertBefore(n, startContainer);\n\t\t\t\t} else if (startOffset >= startContainer.nodeValue.length) {\n\t\t\t\t\t// At the end of text\n\t\t\t\t\tdom.insertAfter(n, startContainer);\n\t\t\t\t} else {\n\t\t\t\t\t// Middle, need to split\n\t\t\t\t\tnn = startContainer.splitText(startOffset);\n\t\t\t\t\tstartContainer.parentNode.insertBefore(n, nn);\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Insert element node\n\t\t\t\tif (startContainer.childNodes.length > 0)\n\t\t\t\t\to = startContainer.childNodes[startOffset];\n\n\t\t\t\tif (o)\n\t\t\t\t\tstartContainer.insertBefore(n, o);\n\t\t\t\telse\n\t\t\t\t\tstartContainer.appendChild(n);\n\t\t\t}\n\t\t};\n\n\t\tfunction surroundContents(n) {\n\t\t\tvar f = t.extractContents();\n\n\t\t\tt.insertNode(n);\n\t\t\tn.appendChild(f);\n\t\t\tt.selectNode(n);\n\t\t};\n\n\t\tfunction cloneRange() {\n\t\t\treturn extend(new Range(dom), {\n\t\t\t\tstartContainer : t[START_CONTAINER],\n\t\t\t\tstartOffset : t[START_OFFSET],\n\t\t\t\tendContainer : t[END_CONTAINER],\n\t\t\t\tendOffset : t[END_OFFSET],\n\t\t\t\tcollapsed : t.collapsed,\n\t\t\t\tcommonAncestorContainer : t.commonAncestorContainer\n\t\t\t});\n\t\t};\n\n\t\t// Private methods\n\n\t\tfunction _getSelectedNode(container, offset) {\n\t\t\tvar child;\n\n\t\t\tif (container.nodeType == 3 /* TEXT_NODE */)\n\t\t\t\treturn container;\n\n\t\t\tif (offset < 0)\n\t\t\t\treturn container;\n\n\t\t\tchild = container.firstChild;\n\t\t\twhile (child && offset > 0) {\n\t\t\t\t--offset;\n\t\t\t\tchild = child.nextSibling;\n\t\t\t}\n\n\t\t\tif (child)\n\t\t\t\treturn child;\n\n\t\t\treturn container;\n\t\t};\n\n\t\tfunction _isCollapsed() {\n\t\t\treturn (t[START_CONTAINER] == t[END_CONTAINER] && t[START_OFFSET] == t[END_OFFSET]);\n\t\t};\n\n\t\tfunction _compareBoundaryPoints(containerA, offsetA, containerB, offsetB) {\n\t\t\tvar c, offsetC, n, cmnRoot, childA, childB;\n\t\t\t\n\t\t\t// In the first case the boundary-points have the same container. A is before B\n\t\t\t// if its offset is less than the offset of B, A is equal to B if its offset is\n\t\t\t// equal to the offset of B, and A is after B if its offset is greater than the\n\t\t\t// offset of B.\n\t\t\tif (containerA == containerB) {\n\t\t\t\tif (offsetA == offsetB)\n\t\t\t\t\treturn 0; // equal\n\n\t\t\t\tif (offsetA < offsetB)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\treturn 1; // after\n\t\t\t}\n\n\t\t\t// In the second case a child node C of the container of A is an ancestor\n\t\t\t// container of B. In this case, A is before B if the offset of A is less than or\n\t\t\t// equal to the index of the child node C and A is after B otherwise.\n\t\t\tc = containerB;\n\t\t\twhile (c && c.parentNode != containerA)\n\t\t\t\tc = c.parentNode;\n\n\t\t\tif (c) {\n\t\t\t\toffsetC = 0;\n\t\t\t\tn = containerA.firstChild;\n\n\t\t\t\twhile (n != c && offsetC < offsetA) {\n\t\t\t\t\toffsetC++;\n\t\t\t\t\tn = n.nextSibling;\n\t\t\t\t}\n\n\t\t\t\tif (offsetA <= offsetC)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\treturn 1; // after\n\t\t\t}\n\n\t\t\t// In the third case a child node C of the container of B is an ancestor container\n\t\t\t// of A. In this case, A is before B if the index of the child node C is less than\n\t\t\t// the offset of B and A is after B otherwise.\n\t\t\tc = containerA;\n\t\t\twhile (c && c.parentNode != containerB) {\n\t\t\t\tc = c.parentNode;\n\t\t\t}\n\n\t\t\tif (c) {\n\t\t\t\toffsetC = 0;\n\t\t\t\tn = containerB.firstChild;\n\n\t\t\t\twhile (n != c && offsetC < offsetB) {\n\t\t\t\t\toffsetC++;\n\t\t\t\t\tn = n.nextSibling;\n\t\t\t\t}\n\n\t\t\t\tif (offsetC < offsetB)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\treturn 1; // after\n\t\t\t}\n\n\t\t\t// In the fourth case, none of three other cases hold: the containers of A and B\n\t\t\t// are siblings or descendants of sibling nodes. In this case, A is before B if\n\t\t\t// the container of A is before the container of B in a pre-order traversal of the\n\t\t\t// Ranges' context tree and A is after B otherwise.\n\t\t\tcmnRoot = dom.findCommonAncestor(containerA, containerB);\n\t\t\tchildA = containerA;\n\n\t\t\twhile (childA && childA.parentNode != cmnRoot)\n\t\t\t\tchildA = childA.parentNode;\n\n\t\t\tif (!childA)\n\t\t\t\tchildA = cmnRoot;\n\n\t\t\tchildB = containerB;\n\t\t\twhile (childB && childB.parentNode != cmnRoot)\n\t\t\t\tchildB = childB.parentNode;\n\n\t\t\tif (!childB)\n\t\t\t\tchildB = cmnRoot;\n\n\t\t\tif (childA == childB)\n\t\t\t\treturn 0; // equal\n\n\t\t\tn = cmnRoot.firstChild;\n\t\t\twhile (n) {\n\t\t\t\tif (n == childA)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\tif (n == childB)\n\t\t\t\t\treturn 1; // after\n\n\t\t\t\tn = n.nextSibling;\n\t\t\t}\n\t\t};\n\n\t\tfunction _setEndPoint(st, n, o) {\n\t\t\tvar ec, sc;\n\n\t\t\tif (st) {\n\t\t\t\tt[START_CONTAINER] = n;\n\t\t\t\tt[START_OFFSET] = o;\n\t\t\t} else {\n\t\t\t\tt[END_CONTAINER] = n;\n\t\t\t\tt[END_OFFSET] = o;\n\t\t\t}\n\n\t\t\t// If one boundary-point of a Range is set to have a root container\n\t\t\t// other than the current one for the Range, the Range is collapsed to\n\t\t\t// the new position. This enforces the restriction that both boundary-\n\t\t\t// points of a Range must have the same root container.\n\t\t\tec = t[END_CONTAINER];\n\t\t\twhile (ec.parentNode)\n\t\t\t\tec = ec.parentNode;\n\n\t\t\tsc = t[START_CONTAINER];\n\t\t\twhile (sc.parentNode)\n\t\t\t\tsc = sc.parentNode;\n\n\t\t\tif (sc == ec) {\n\t\t\t\t// The start position of a Range is guaranteed to never be after the\n\t\t\t\t// end position. To enforce this restriction, if the start is set to\n\t\t\t\t// be at a position after the end, the Range is collapsed to that\n\t\t\t\t// position.\n\t\t\t\tif (_compareBoundaryPoints(t[START_CONTAINER], t[START_OFFSET], t[END_CONTAINER], t[END_OFFSET]) > 0)\n\t\t\t\t\tt.collapse(st);\n\t\t\t} else\n\t\t\t\tt.collapse(st);\n\n\t\t\tt.collapsed = _isCollapsed();\n\t\t\tt.commonAncestorContainer = dom.findCommonAncestor(t[START_CONTAINER], t[END_CONTAINER]);\n\t\t};\n\n\t\tfunction _traverse(how) {\n\t\t\tvar c, endContainerDepth = 0, startContainerDepth = 0, p, depthDiff, startNode, endNode, sp, ep;\n\n\t\t\tif (t[START_CONTAINER] == t[END_CONTAINER])\n\t\t\t\treturn _traverseSameContainer(how);\n\n\t\t\tfor (c = t[END_CONTAINER], p = c.parentNode; p; c = p, p = p.parentNode) {\n\t\t\t\tif (p == t[START_CONTAINER])\n\t\t\t\t\treturn _traverseCommonStartContainer(c, how);\n\n\t\t\t\t++endContainerDepth;\n\t\t\t}\n\n\t\t\tfor (c = t[START_CONTAINER], p = c.parentNode; p; c = p, p = p.parentNode) {\n\t\t\t\tif (p == t[END_CONTAINER])\n\t\t\t\t\treturn _traverseCommonEndContainer(c, how);\n\n\t\t\t\t++startContainerDepth;\n\t\t\t}\n\n\t\t\tdepthDiff = startContainerDepth - endContainerDepth;\n\n\t\t\tstartNode = t[START_CONTAINER];\n\t\t\twhile (depthDiff > 0) {\n\t\t\t\tstartNode = startNode.parentNode;\n\t\t\t\tdepthDiff--;\n\t\t\t}\n\n\t\t\tendNode = t[END_CONTAINER];\n\t\t\twhile (depthDiff < 0) {\n\t\t\t\tendNode = endNode.parentNode;\n\t\t\t\tdepthDiff++;\n\t\t\t}\n\n\t\t\t// ascend the ancestor hierarchy until we have a common parent.\n\t\t\tfor (sp = startNode.parentNode, ep = endNode.parentNode; sp != ep; sp = sp.parentNode, ep = ep.parentNode) {\n\t\t\t\tstartNode = sp;\n\t\t\t\tendNode = ep;\n\t\t\t}\n\n\t\t\treturn _traverseCommonAncestors(startNode, endNode, how);\n\t\t};\n\n\t\t function _traverseSameContainer(how) {\n\t\t\tvar frag, s, sub, n, cnt, sibling, xferNode;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\t// If selection is empty, just return the fragment\n\t\t\tif (t[START_OFFSET] == t[END_OFFSET])\n\t\t\t\treturn frag;\n\n\t\t\t// Text node needs special case handling\n\t\t\tif (t[START_CONTAINER].nodeType == 3 /* TEXT_NODE */) {\n\t\t\t\t// get the substring\n\t\t\t\ts = t[START_CONTAINER].nodeValue;\n\t\t\t\tsub = s.substring(t[START_OFFSET], t[END_OFFSET]);\n\n\t\t\t\t// set the original text node to its new value\n\t\t\t\tif (how != CLONE) {\n\t\t\t\t\tt[START_CONTAINER].deleteData(t[START_OFFSET], t[END_OFFSET] - t[START_OFFSET]);\n\n\t\t\t\t\t// Nothing is partially selected, so collapse to start point\n\t\t\t\t\tt.collapse(TRUE);\n\t\t\t\t}\n\n\t\t\t\tif (how == DELETE)\n\t\t\t\t\treturn;\n\n\t\t\t\tfrag.appendChild(doc.createTextNode(sub));\n\t\t\t\treturn frag;\n\t\t\t}\n\n\t\t\t// Copy nodes between the start/end offsets.\n\t\t\tn = _getSelectedNode(t[START_CONTAINER], t[START_OFFSET]);\n\t\t\tcnt = t[END_OFFSET] - t[START_OFFSET];\n\n\t\t\twhile (cnt > 0) {\n\t\t\t\tsibling = n.nextSibling;\n\t\t\t\txferNode = _traverseFullySelected(n, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.appendChild( xferNode );\n\n\t\t\t\t--cnt;\n\t\t\t\tn = sibling;\n\t\t\t}\n\n\t\t\t// Nothing is partially selected, so collapse to start point\n\t\t\tif (how != CLONE)\n\t\t\t\tt.collapse(TRUE);\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseCommonStartContainer(endAncestor, how) {\n\t\t\tvar frag, n, endIdx, cnt, sibling, xferNode;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\tn = _traverseRightBoundary(endAncestor, how);\n\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tendIdx = nodeIndex(endAncestor);\n\t\t\tcnt = endIdx - t[START_OFFSET];\n\n\t\t\tif (cnt <= 0) {\n\t\t\t\t// Collapse to just before the endAncestor, which\n\t\t\t\t// is partially selected.\n\t\t\t\tif (how != CLONE) {\n\t\t\t\t\tt.setEndBefore(endAncestor);\n\t\t\t\t\tt.collapse(FALSE);\n\t\t\t\t}\n\n\t\t\t\treturn frag;\n\t\t\t}\n\n\t\t\tn = endAncestor.previousSibling;\n\t\t\twhile (cnt > 0) {\n\t\t\t\tsibling = n.previousSibling;\n\t\t\t\txferNode = _traverseFullySelected(n, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.insertBefore(xferNode, frag.firstChild);\n\n\t\t\t\t--cnt;\n\t\t\t\tn = sibling;\n\t\t\t}\n\n\t\t\t// Collapse to just before the endAncestor, which\n\t\t\t// is partially selected.\n\t\t\tif (how != CLONE) {\n\t\t\t\tt.setEndBefore(endAncestor);\n\t\t\t\tt.collapse(FALSE);\n\t\t\t}\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseCommonEndContainer(startAncestor, how) {\n\t\t\tvar frag, startIdx, n, cnt, sibling, xferNode;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\tn = _traverseLeftBoundary(startAncestor, how);\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tstartIdx = nodeIndex(startAncestor);\n\t\t\t++startIdx; // Because we already traversed it\n\n\t\t\tcnt = t[END_OFFSET] - startIdx;\n\t\t\tn = startAncestor.nextSibling;\n\t\t\twhile (cnt > 0) {\n\t\t\t\tsibling = n.nextSibling;\n\t\t\t\txferNode = _traverseFullySelected(n, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.appendChild(xferNode);\n\n\t\t\t\t--cnt;\n\t\t\t\tn = sibling;\n\t\t\t}\n\n\t\t\tif (how != CLONE) {\n\t\t\t\tt.setStartAfter(startAncestor);\n\t\t\t\tt.collapse(TRUE);\n\t\t\t}\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseCommonAncestors(startAncestor, endAncestor, how) {\n\t\t\tvar n, frag, commonParent, startOffset, endOffset, cnt, sibling, nextSibling;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\tn = _traverseLeftBoundary(startAncestor, how);\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tcommonParent = startAncestor.parentNode;\n\t\t\tstartOffset = nodeIndex(startAncestor);\n\t\t\tendOffset = nodeIndex(endAncestor);\n\t\t\t++startOffset;\n\n\t\t\tcnt = endOffset - startOffset;\n\t\t\tsibling = startAncestor.nextSibling;\n\n\t\t\twhile (cnt > 0) {\n\t\t\t\tnextSibling = sibling.nextSibling;\n\t\t\t\tn = _traverseFullySelected(sibling, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.appendChild(n);\n\n\t\t\t\tsibling = nextSibling;\n\t\t\t\t--cnt;\n\t\t\t}\n\n\t\t\tn = _traverseRightBoundary(endAncestor, how);\n\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tif (how != CLONE) {\n\t\t\t\tt.setStartAfter(startAncestor);\n\t\t\t\tt.collapse(TRUE);\n\t\t\t}\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseRightBoundary(root, how) {\n\t\t\tvar next = _getSelectedNode(t[END_CONTAINER], t[END_OFFSET] - 1), parent, clonedParent, prevSibling, clonedChild, clonedGrandParent, isFullySelected = next != t[END_CONTAINER];\n\n\t\t\tif (next == root)\n\t\t\t\treturn _traverseNode(next, isFullySelected, FALSE, how);\n\n\t\t\tparent = next.parentNode;\n\t\t\tclonedParent = _traverseNode(parent, FALSE, FALSE, how);\n\n\t\t\twhile (parent) {\n\t\t\t\twhile (next) {\n\t\t\t\t\tprevSibling = next.previousSibling;\n\t\t\t\t\tclonedChild = _traverseNode(next, isFullySelected, FALSE, how);\n\n\t\t\t\t\tif (how != DELETE)\n\t\t\t\t\t\tclonedParent.insertBefore(clonedChild, clonedParent.firstChild);\n\n\t\t\t\t\tisFullySelected = TRUE;\n\t\t\t\t\tnext = prevSibling;\n\t\t\t\t}\n\n\t\t\t\tif (parent == root)\n\t\t\t\t\treturn clonedParent;\n\n\t\t\t\tnext = parent.previousSibling;\n\t\t\t\tparent = parent.parentNode;\n\n\t\t\t\tclonedGrandParent = _traverseNode(parent, FALSE, FALSE, how);\n\n\t\t\t\tif (how != DELETE)\n\t\t\t\t\tclonedGrandParent.appendChild(clonedParent);\n\n\t\t\t\tclonedParent = clonedGrandParent;\n\t\t\t}\n\t\t};\n\n\t\tfunction _traverseLeftBoundary(root, how) {\n\t\t\tvar next = _getSelectedNode(t[START_CONTAINER], t[START_OFFSET]), isFullySelected = next != t[START_CONTAINER], parent, clonedParent, nextSibling, clonedChild, clonedGrandParent;\n\n\t\t\tif (next == root)\n\t\t\t\treturn _traverseNode(next, isFullySelected, TRUE, how);\n\n\t\t\tparent = next.parentNode;\n\t\t\tclonedParent = _traverseNode(parent, FALSE, TRUE, how);\n\n\t\t\twhile (parent) {\n\t\t\t\twhile (next) {\n\t\t\t\t\tnextSibling = next.nextSibling;\n\t\t\t\t\tclonedChild = _traverseNode(next, isFullySelected, TRUE, how);\n\n\t\t\t\t\tif (how != DELETE)\n\t\t\t\t\t\tclonedParent.appendChild(clonedChild);\n\n\t\t\t\t\tisFullySelected = TRUE;\n\t\t\t\t\tnext = nextSibling;\n\t\t\t\t}\n\n\t\t\t\tif (parent == root)\n\t\t\t\t\treturn clonedParent;\n\n\t\t\t\tnext = parent.nextSibling;\n\t\t\t\tparent = parent.parentNode;\n\n\t\t\t\tclonedGrandParent = _traverseNode(parent, FALSE, TRUE, how);\n\n\t\t\t\tif (how != DELETE)\n\t\t\t\t\tclonedGrandParent.appendChild(clonedParent);\n\n\t\t\t\tclonedParent = clonedGrandParent;\n\t\t\t}\n\t\t};\n\n\t\tfunction _traverseNode(n, isFullySelected, isLeft, how) {\n\t\t\tvar txtValue, newNodeValue, oldNodeValue, offset, newNode;\n\n\t\t\tif (isFullySelected)\n\t\t\t\treturn _traverseFullySelected(n, how);\n\n\t\t\tif (n.nodeType == 3 /* TEXT_NODE */) {\n\t\t\t\ttxtValue = n.nodeValue;\n\n\t\t\t\tif (isLeft) {\n\t\t\t\t\toffset = t[START_OFFSET];\n\t\t\t\t\tnewNodeValue = txtValue.substring(offset);\n\t\t\t\t\toldNodeValue = txtValue.substring(0, offset);\n\t\t\t\t} else {\n\t\t\t\t\toffset = t[END_OFFSET];\n\t\t\t\t\tnewNodeValue = txtValue.substring(0, offset);\n\t\t\t\t\toldNodeValue = txtValue.substring(offset);\n\t\t\t\t}\n\n\t\t\t\tif (how != CLONE)\n\t\t\t\t\tn.nodeValue = oldNodeValue;\n\n\t\t\t\tif (how == DELETE)\n\t\t\t\t\treturn;\n\n\t\t\t\tnewNode = n.cloneNode(FALSE);\n\t\t\t\tnewNode.nodeValue = newNodeValue;\n\n\t\t\t\treturn newNode;\n\t\t\t}\n\n\t\t\tif (how == DELETE)\n\t\t\t\treturn;\n\n\t\t\treturn n.cloneNode(FALSE);\n\t\t};\n\n\t\tfunction _traverseFullySelected(n, how) {\n\t\t\tif (how != DELETE)\n\t\t\t\treturn how == CLONE ? n.cloneNode(TRUE) : n;\n\n\t\t\tn.parentNode.removeChild(n);\n\t\t};\n\t};\n\n\tns.Range = Range;\n})(tinymce.dom);\n\n(function() {\n\tfunction Selection(selection) {\n\t\tvar self = this, dom = selection.dom, TRUE = true, FALSE = false;\n\n\t\tfunction getPosition(rng, start) {\n\t\t\tvar checkRng, startIndex = 0, endIndex, inside,\n\t\t\t\tchildren, child, offset, index, position = -1, parent;\n\n\t\t\t// Setup test range, collapse it and get the parent\n\t\t\tcheckRng = rng.duplicate();\n\t\t\tcheckRng.collapse(start);\n\t\t\tparent = checkRng.parentElement();\n\n\t\t\t// Check if the selection is within the right document\n\t\t\tif (parent.ownerDocument !== selection.dom.doc)\n\t\t\t\treturn;\n\n\t\t\t// IE will report non editable elements as it's parent so look for an editable one\n\t\t\twhile (parent.contentEditable === \"false\") {\n\t\t\t\tparent = parent.parentNode;\n\t\t\t}\n\n\t\t\t// If parent doesn't have any children then return that we are inside the element\n\t\t\tif (!parent.hasChildNodes()) {\n\t\t\t\treturn {node : parent, inside : 1};\n\t\t\t}\n\n\t\t\t// Setup node list and endIndex\n\t\t\tchildren = parent.children;\n\t\t\tendIndex = children.length - 1;\n\n\t\t\t// Perform a binary search for the position\n\t\t\twhile (startIndex <= endIndex) {\n\t\t\t\tindex = Math.floor((startIndex + endIndex) / 2);\n\n\t\t\t\t// Move selection to node and compare the ranges\n\t\t\t\tchild = children[index];\n\t\t\t\tcheckRng.moveToElementText(child);\n\t\t\t\tposition = checkRng.compareEndPoints(start ? 'StartToStart' : 'EndToEnd', rng);\n\n\t\t\t\t// Before/after or an exact match\n\t\t\t\tif (position > 0) {\n\t\t\t\t\tendIndex = index - 1;\n\t\t\t\t} else if (position < 0) {\n\t\t\t\t\tstartIndex = index + 1;\n\t\t\t\t} else {\n\t\t\t\t\treturn {node : child};\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Check if child position is before or we didn't find a position\n\t\t\tif (position < 0) {\n\t\t\t\t// No element child was found use the parent element and the offset inside that\n\t\t\t\tif (!child) {\n\t\t\t\t\tcheckRng.moveToElementText(parent);\n\t\t\t\t\tcheckRng.collapse(true);\n\t\t\t\t\tchild = parent;\n\t\t\t\t\tinside = true;\n\t\t\t\t} else\n\t\t\t\t\tcheckRng.collapse(false);\n\n\t\t\t\tcheckRng.setEndPoint(start ? 'EndToStart' : 'EndToEnd', rng);\n\n\t\t\t\t// Fix for edge case: <div style=\"width: 100px; height:100px;\"><table>..</table>ab|c</div>\n\t\t\t\tif (checkRng.compareEndPoints(start ? 'StartToStart' : 'StartToEnd', rng) > 0) {\n\t\t\t\t\tcheckRng = rng.duplicate();\n\t\t\t\t\tcheckRng.collapse(start);\n\n\t\t\t\t\toffset = -1;\n\t\t\t\t\twhile (parent == checkRng.parentElement()) {\n\t\t\t\t\t\tif (checkRng.move('character', -1) == 0)\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\toffset++;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\toffset = offset || checkRng.text.replace('\\r\\n', ' ').length;\n\t\t\t} else {\n\t\t\t\t// Child position is after the selection endpoint\n\t\t\t\tcheckRng.collapse(true);\n\t\t\t\tcheckRng.setEndPoint(start ? 'StartToStart' : 'StartToEnd', rng);\n\n\t\t\t\t// Get the length of the text to find where the endpoint is relative to it's container\n\t\t\t\toffset = checkRng.text.replace('\\r\\n', ' ').length;\n\t\t\t}\n\n\t\t\treturn {node : child, position : position, offset : offset, inside : inside};\n\t\t};\n\n\t\t// Returns a W3C DOM compatible range object by using the IE Range API\n\t\tfunction getRange() {\n\t\t\tvar ieRange = selection.getRng(), domRange = dom.createRng(), element, collapsed, tmpRange, element2, bookmark, fail;\n\n\t\t\t// If selection is outside the current document just return an empty range\n\t\t\telement = ieRange.item ? ieRange.item(0) : ieRange.parentElement();\n\t\t\tif (element.ownerDocument != dom.doc)\n\t\t\t\treturn domRange;\n\n\t\t\tcollapsed = selection.isCollapsed();\n\n\t\t\t// Handle control selection\n\t\t\tif (ieRange.item) {\n\t\t\t\tdomRange.setStart(element.parentNode, dom.nodeIndex(element));\n\t\t\t\tdomRange.setEnd(domRange.startContainer, domRange.startOffset + 1);\n\n\t\t\t\treturn domRange;\n\t\t\t}\n\n\t\t\tfunction findEndPoint(start) {\n\t\t\t\tvar endPoint = getPosition(ieRange, start), container, offset, textNodeOffset = 0, sibling, undef, nodeValue;\n\n\t\t\t\tcontainer = endPoint.node;\n\t\t\t\toffset = endPoint.offset;\n\n\t\t\t\tif (endPoint.inside && !container.hasChildNodes()) {\n\t\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](container, 0);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (offset === undef) {\n\t\t\t\t\tdomRange[start ? 'setStartBefore' : 'setEndAfter'](container);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (endPoint.position < 0) {\n\t\t\t\t\tsibling = endPoint.inside ? container.firstChild : container.nextSibling;\n\n\t\t\t\t\tif (!sibling) {\n\t\t\t\t\t\tdomRange[start ? 'setStartAfter' : 'setEndAfter'](container);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!offset) {\n\t\t\t\t\t\tif (sibling.nodeType == 3)\n\t\t\t\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](sibling, 0);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tdomRange[start ? 'setStartBefore' : 'setEndBefore'](sibling);\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Find the text node and offset\n\t\t\t\t\twhile (sibling) {\n\t\t\t\t\t\tnodeValue = sibling.nodeValue;\n\t\t\t\t\t\ttextNodeOffset += nodeValue.length;\n\n\t\t\t\t\t\t// We are at or passed the position we where looking for\n\t\t\t\t\t\tif (textNodeOffset >= offset) {\n\t\t\t\t\t\t\tcontainer = sibling;\n\t\t\t\t\t\t\ttextNodeOffset -= offset;\n\t\t\t\t\t\t\ttextNodeOffset = nodeValue.length - textNodeOffset;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tsibling = sibling.nextSibling;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\t// Find the text node and offset\n\t\t\t\t\tsibling = container.previousSibling;\n\n\t\t\t\t\tif (!sibling)\n\t\t\t\t\t\treturn domRange[start ? 'setStartBefore' : 'setEndBefore'](container);\n\n\t\t\t\t\t// If there isn't any text to loop then use the first position\n\t\t\t\t\tif (!offset) {\n\t\t\t\t\t\tif (container.nodeType == 3)\n\t\t\t\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](sibling, container.nodeValue.length);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tdomRange[start ? 'setStartAfter' : 'setEndAfter'](sibling);\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\twhile (sibling) {\n\t\t\t\t\t\ttextNodeOffset += sibling.nodeValue.length;\n\n\t\t\t\t\t\t// We are at or passed the position we where looking for\n\t\t\t\t\t\tif (textNodeOffset >= offset) {\n\t\t\t\t\t\t\tcontainer = sibling;\n\t\t\t\t\t\t\ttextNodeOffset -= offset;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tsibling = sibling.previousSibling;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](container, textNodeOffset);\n\t\t\t};\n\n\t\t\ttry {\n\t\t\t\t// Find start point\n\t\t\t\tfindEndPoint(true);\n\n\t\t\t\t// Find end point if needed\n\t\t\t\tif (!collapsed)\n\t\t\t\t\tfindEndPoint();\n\t\t\t} catch (ex) {\n\t\t\t\t// IE has a nasty bug where text nodes might throw \"invalid argument\" when you\n\t\t\t\t// access the nodeValue or other properties of text nodes. This seems to happend when\n\t\t\t\t// text nodes are split into two nodes by a delete/backspace call. So lets detect it and try to fix it.\n\t\t\t\tif (ex.number == -2147024809) {\n\t\t\t\t\t// Get the current selection\n\t\t\t\t\tbookmark = self.getBookmark(2);\n\n\t\t\t\t\t// Get start element\n\t\t\t\t\ttmpRange = ieRange.duplicate();\n\t\t\t\t\ttmpRange.collapse(true);\n\t\t\t\t\telement = tmpRange.parentElement();\n\n\t\t\t\t\t// Get end element\n\t\t\t\t\tif (!collapsed) {\n\t\t\t\t\t\ttmpRange = ieRange.duplicate();\n\t\t\t\t\t\ttmpRange.collapse(false);\n\t\t\t\t\t\telement2 = tmpRange.parentElement();\n\t\t\t\t\t\telement2.innerHTML = element2.innerHTML;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove the broken elements\n\t\t\t\t\telement.innerHTML = element.innerHTML;\n\n\t\t\t\t\t// Restore the selection\n\t\t\t\t\tself.moveToBookmark(bookmark);\n\n\t\t\t\t\t// Since the range has moved we need to re-get it\n\t\t\t\t\tieRange = selection.getRng();\n\n\t\t\t\t\t// Find start point\n\t\t\t\t\tfindEndPoint(true);\n\n\t\t\t\t\t// Find end point if needed\n\t\t\t\t\tif (!collapsed)\n\t\t\t\t\t\tfindEndPoint();\n\t\t\t\t} else\n\t\t\t\t\tthrow ex; // Throw other errors\n\t\t\t}\n\n\t\t\treturn domRange;\n\t\t};\n\n\t\tthis.getBookmark = function(type) {\n\t\t\tvar rng = selection.getRng(), start, end, bookmark = {};\n\n\t\t\tfunction getIndexes(node) {\n\t\t\t\tvar node, parent, root, children, i, indexes = [];\n\n\t\t\t\tparent = node.parentNode;\n\t\t\t\troot = dom.getRoot().parentNode;\n\n\t\t\t\twhile (parent != root && parent.nodeType !== 9) {\n\t\t\t\t\tchildren = parent.children;\n\n\t\t\t\t\ti = children.length;\n\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\tif (node === children[i]) {\n\t\t\t\t\t\t\tindexes.push(i);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = parent;\n\t\t\t\t\tparent = parent.parentNode;\n\t\t\t\t}\n\n\t\t\t\treturn indexes;\n\t\t\t};\n\n\t\t\tfunction getBookmarkEndPoint(start) {\n\t\t\t\tvar position;\n\n\t\t\t\tposition = getPosition(rng, start);\n\t\t\t\tif (position) {\n\t\t\t\t\treturn {\n\t\t\t\t\t\tposition : position.position,\n\t\t\t\t\t\toffset : position.offset,\n\t\t\t\t\t\tindexes : getIndexes(position.node),\n\t\t\t\t\t\tinside : position.inside\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Non ubstructive bookmark\n\t\t\tif (type === 2) {\n\t\t\t\t// Handle text selection\n\t\t\t\tif (!rng.item) {\n\t\t\t\t\tbookmark.start = getBookmarkEndPoint(true);\n\n\t\t\t\t\tif (!selection.isCollapsed())\n\t\t\t\t\t\tbookmark.end = getBookmarkEndPoint();\n\t\t\t\t} else\n\t\t\t\t\tbookmark.start = {ctrl : true, indexes : getIndexes(rng.item(0))};\n\t\t\t}\n\n\t\t\treturn bookmark;\n\t\t};\n\n\t\tthis.moveToBookmark = function(bookmark) {\n\t\t\tvar rng, body = dom.doc.body;\n\n\t\t\tfunction resolveIndexes(indexes) {\n\t\t\t\tvar node, i, idx, children;\n\n\t\t\t\tnode = dom.getRoot();\n\t\t\t\tfor (i = indexes.length - 1; i >= 0; i--) {\n\t\t\t\t\tchildren = node.children;\n\t\t\t\t\tidx = indexes[i];\n\n\t\t\t\t\tif (idx <= children.length - 1) {\n\t\t\t\t\t\tnode = children[idx];\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn node;\n\t\t\t};\n\t\t\t\n\t\t\tfunction setBookmarkEndPoint(start) {\n\t\t\t\tvar endPoint = bookmark[start ? 'start' : 'end'], moveLeft, moveRng, undef;\n\n\t\t\t\tif (endPoint) {\n\t\t\t\t\tmoveLeft = endPoint.position > 0;\n\n\t\t\t\t\tmoveRng = body.createTextRange();\n\t\t\t\t\tmoveRng.moveToElementText(resolveIndexes(endPoint.indexes));\n\n\t\t\t\t\toffset = endPoint.offset;\n\t\t\t\t\tif (offset !== undef) {\n\t\t\t\t\t\tmoveRng.collapse(endPoint.inside || moveLeft);\n\t\t\t\t\t\tmoveRng.moveStart('character', moveLeft ? -offset : offset);\n\t\t\t\t\t} else\n\t\t\t\t\t\tmoveRng.collapse(start);\n\n\t\t\t\t\trng.setEndPoint(start ? 'StartToStart' : 'EndToStart', moveRng);\n\n\t\t\t\t\tif (start)\n\t\t\t\t\t\trng.collapse(true);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tif (bookmark.start) {\n\t\t\t\tif (bookmark.start.ctrl) {\n\t\t\t\t\trng = body.createControlRange();\n\t\t\t\t\trng.addElement(resolveIndexes(bookmark.start.indexes));\n\t\t\t\t\trng.select();\n\t\t\t\t} else {\n\t\t\t\t\trng = body.createTextRange();\n\t\t\t\t\tsetBookmarkEndPoint(true);\n\t\t\t\t\tsetBookmarkEndPoint();\n\t\t\t\t\trng.select();\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tthis.addRange = function(rng) {\n\t\t\tvar ieRng, ctrlRng, startContainer, startOffset, endContainer, endOffset, doc = selection.dom.doc, body = doc.body;\n\n\t\t\tfunction setEndPoint(start) {\n\t\t\t\tvar container, offset, marker, tmpRng, nodes;\n\n\t\t\t\tmarker = dom.create('a');\n\t\t\t\tcontainer = start ? startContainer : endContainer;\n\t\t\t\toffset = start ? startOffset : endOffset;\n\t\t\t\ttmpRng = ieRng.duplicate();\n\n\t\t\t\tif (container == doc || container == doc.documentElement) {\n\t\t\t\t\tcontainer = body;\n\t\t\t\t\toffset = 0;\n\t\t\t\t}\n\n\t\t\t\tif (container.nodeType == 3) {\n\t\t\t\t\tcontainer.parentNode.insertBefore(marker, container);\n\t\t\t\t\ttmpRng.moveToElementText(marker);\n\t\t\t\t\ttmpRng.moveStart('character', offset);\n\t\t\t\t\tdom.remove(marker);\n\t\t\t\t\tieRng.setEndPoint(start ? 'StartToStart' : 'EndToEnd', tmpRng);\n\t\t\t\t} else {\n\t\t\t\t\tnodes = container.childNodes;\n\n\t\t\t\t\tif (nodes.length) {\n\t\t\t\t\t\tif (offset >= nodes.length) {\n\t\t\t\t\t\t\tdom.insertAfter(marker, nodes[nodes.length - 1]);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tcontainer.insertBefore(marker, nodes[offset]);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\ttmpRng.moveToElementText(marker);\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Empty node selection for example <div>|</div>\n\t\t\t\t\t\tmarker = doc.createTextNode('\\uFEFF');\n\t\t\t\t\t\tcontainer.appendChild(marker);\n\t\t\t\t\t\ttmpRng.moveToElementText(marker.parentNode);\n\t\t\t\t\t\ttmpRng.collapse(TRUE);\n\t\t\t\t\t}\n\n\t\t\t\t\tieRng.setEndPoint(start ? 'StartToStart' : 'EndToEnd', tmpRng);\n\t\t\t\t\tdom.remove(marker);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Setup some shorter versions\n\t\t\tstartContainer = rng.startContainer;\n\t\t\tstartOffset = rng.startOffset;\n\t\t\tendContainer = rng.endContainer;\n\t\t\tendOffset = rng.endOffset;\n\t\t\tieRng = body.createTextRange();\n\n\t\t\t// If single element selection then try making a control selection out of it\n\t\t\tif (startContainer == endContainer && startContainer.nodeType == 1 && startOffset == endOffset - 1) {\n\t\t\t\tif (startOffset == endOffset - 1) {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tctrlRng = body.createControlRange();\n\t\t\t\t\t\tctrlRng.addElement(startContainer.childNodes[startOffset]);\n\t\t\t\t\t\tctrlRng.select();\n\t\t\t\t\t\treturn;\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// Ignore\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Set start/end point of selection\n\t\t\tsetEndPoint(true);\n\t\t\tsetEndPoint();\n\n\t\t\t// Select the new range and scroll it into view\n\t\t\tieRng.select();\n\t\t};\n\n\t\t// Expose range method\n\t\tthis.getRangeAt = getRange;\n\t};\n\n\t// Expose the selection object\n\ttinymce.dom.TridentSelection = Selection;\n})();\n\n\n/*\n * Sizzle CSS Selector Engine - v1.0\n *  Copyright 2009, The Dojo Foundation\n *  Released under the MIT, BSD, and GPL Licenses.\n *  More information: http://sizzlejs.com/\n */\n(function(){\n\nvar chunker = /((?:\\((?:\\([^()]+\\)|[^()]+)+\\)|\\[(?:\\[[^\\[\\]]*\\]|['\"][^'\"]*['\"]|[^\\[\\]'\"]+)+\\]|\\\\.|[^ >+~,(\\[\\\\]+)+|[>+~])(\\s*,\\s*)?((?:.|\\r|\\n)*)/g,\n\tdone = 0,\n\ttoString = Object.prototype.toString,\n\thasDuplicate = false,\n\tbaseHasDuplicate = true;\n\n// Here we check if the JavaScript engine is using some sort of\n// optimization where it does not always call our comparision\n// function. If that is the case, discard the hasDuplicate value.\n//   Thus far that includes Google Chrome.\n[0, 0].sort(function(){\n\tbaseHasDuplicate = false;\n\treturn 0;\n});\n\nvar Sizzle = function(selector, context, results, seed) {\n\tresults = results || [];\n\tcontext = context || document;\n\n\tvar origContext = context;\n\n\tif ( context.nodeType !== 1 && context.nodeType !== 9 ) {\n\t\treturn [];\n\t}\n\t\n\tif ( !selector || typeof selector !== \"string\" ) {\n\t\treturn results;\n\t}\n\n\tvar parts = [], m, set, checkSet, extra, prune = true, contextXML = Sizzle.isXML(context),\n\t\tsoFar = selector, ret, cur, pop, i;\n\t\n\t// Reset the position of the chunker regexp (start from head)\n\tdo {\n\t\tchunker.exec(\"\");\n\t\tm = chunker.exec(soFar);\n\n\t\tif ( m ) {\n\t\t\tsoFar = m[3];\n\t\t\n\t\t\tparts.push( m[1] );\n\t\t\n\t\t\tif ( m[2] ) {\n\t\t\t\textra = m[3];\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t} while ( m );\n\n\tif ( parts.length > 1 && origPOS.exec( selector ) ) {\n\t\tif ( parts.length === 2 && Expr.relative[ parts[0] ] ) {\n\t\t\tset = posProcess( parts[0] + parts[1], context );\n\t\t} else {\n\t\t\tset = Expr.relative[ parts[0] ] ?\n\t\t\t\t[ context ] :\n\t\t\t\tSizzle( parts.shift(), context );\n\n\t\t\twhile ( parts.length ) {\n\t\t\t\tselector = parts.shift();\n\n\t\t\t\tif ( Expr.relative[ selector ] ) {\n\t\t\t\t\tselector += parts.shift();\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\tset = posProcess( selector, set );\n\t\t\t}\n\t\t}\n\t} else {\n\t\t// Take a shortcut and set the context if the root selector is an ID\n\t\t// (but not if it'll be faster if the inner selector is an ID)\n\t\tif ( !seed && parts.length > 1 && context.nodeType === 9 && !contextXML &&\n\t\t\t\tExpr.match.ID.test(parts[0]) && !Expr.match.ID.test(parts[parts.length - 1]) ) {\n\t\t\tret = Sizzle.find( parts.shift(), context, contextXML );\n\t\t\tcontext = ret.expr ? Sizzle.filter( ret.expr, ret.set )[0] : ret.set[0];\n\t\t}\n\n\t\tif ( context ) {\n\t\t\tret = seed ?\n\t\t\t\t{ expr: parts.pop(), set: makeArray(seed) } :\n\t\t\t\tSizzle.find( parts.pop(), parts.length === 1 && (parts[0] === \"~\" || parts[0] === \"+\") && context.parentNode ? context.parentNode : context, contextXML );\n\t\t\tset = ret.expr ? Sizzle.filter( ret.expr, ret.set ) : ret.set;\n\n\t\t\tif ( parts.length > 0 ) {\n\t\t\t\tcheckSet = makeArray(set);\n\t\t\t} else {\n\t\t\t\tprune = false;\n\t\t\t}\n\n\t\t\twhile ( parts.length ) {\n\t\t\t\tcur = parts.pop();\n\t\t\t\tpop = cur;\n\n\t\t\t\tif ( !Expr.relative[ cur ] ) {\n\t\t\t\t\tcur = \"\";\n\t\t\t\t} else {\n\t\t\t\t\tpop = parts.pop();\n\t\t\t\t}\n\n\t\t\t\tif ( pop == null ) {\n\t\t\t\t\tpop = context;\n\t\t\t\t}\n\n\t\t\t\tExpr.relative[ cur ]( checkSet, pop, contextXML );\n\t\t\t}\n\t\t} else {\n\t\t\tcheckSet = parts = [];\n\t\t}\n\t}\n\n\tif ( !checkSet ) {\n\t\tcheckSet = set;\n\t}\n\n\tif ( !checkSet ) {\n\t\tSizzle.error( cur || selector );\n\t}\n\n\tif ( toString.call(checkSet) === \"[object Array]\" ) {\n\t\tif ( !prune ) {\n\t\t\tresults.push.apply( results, checkSet );\n\t\t} else if ( context && context.nodeType === 1 ) {\n\t\t\tfor ( i = 0; checkSet[i] != null; i++ ) {\n\t\t\t\tif ( checkSet[i] && (checkSet[i] === true || checkSet[i].nodeType === 1 && Sizzle.contains(context, checkSet[i])) ) {\n\t\t\t\t\tresults.push( set[i] );\n\t\t\t\t}\n\t\t\t}\n\t\t} else {\n\t\t\tfor ( i = 0; checkSet[i] != null; i++ ) {\n\t\t\t\tif ( checkSet[i] && checkSet[i].nodeType === 1 ) {\n\t\t\t\t\tresults.push( set[i] );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t} else {\n\t\tmakeArray( checkSet, results );\n\t}\n\n\tif ( extra ) {\n\t\tSizzle( extra, origContext, results, seed );\n\t\tSizzle.uniqueSort( results );\n\t}\n\n\treturn results;\n};\n\nSizzle.uniqueSort = function(results){\n\tif ( sortOrder ) {\n\t\thasDuplicate = baseHasDuplicate;\n\t\tresults.sort(sortOrder);\n\n\t\tif ( hasDuplicate ) {\n\t\t\tfor ( var i = 1; i < results.length; i++ ) {\n\t\t\t\tif ( results[i] === results[i-1] ) {\n\t\t\t\t\tresults.splice(i--, 1);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\treturn results;\n};\n\nSizzle.matches = function(expr, set){\n\treturn Sizzle(expr, null, null, set);\n};\n\nSizzle.find = function(expr, context, isXML){\n\tvar set;\n\n\tif ( !expr ) {\n\t\treturn [];\n\t}\n\n\tfor ( var i = 0, l = Expr.order.length; i < l; i++ ) {\n\t\tvar type = Expr.order[i], match;\n\t\t\n\t\tif ( (match = Expr.leftMatch[ type ].exec( expr )) ) {\n\t\t\tvar left = match[1];\n\t\t\tmatch.splice(1,1);\n\n\t\t\tif ( left.substr( left.length - 1 ) !== \"\\\\\" ) {\n\t\t\t\tmatch[1] = (match[1] || \"\").replace(/\\\\/g, \"\");\n\t\t\t\tset = Expr.find[ type ]( match, context, isXML );\n\t\t\t\tif ( set != null ) {\n\t\t\t\t\texpr = expr.replace( Expr.match[ type ], \"\" );\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\tif ( !set ) {\n\t\tset = context.getElementsByTagName(\"*\");\n\t}\n\n\treturn {set: set, expr: expr};\n};\n\nSizzle.filter = function(expr, set, inplace, not){\n\tvar old = expr, result = [], curLoop = set, match, anyFound,\n\t\tisXMLFilter = set && set[0] && Sizzle.isXML(set[0]);\n\n\twhile ( expr && set.length ) {\n\t\tfor ( var type in Expr.filter ) {\n\t\t\tif ( (match = Expr.leftMatch[ type ].exec( expr )) != null && match[2] ) {\n\t\t\t\tvar filter = Expr.filter[ type ], found, item, left = match[1];\n\t\t\t\tanyFound = false;\n\n\t\t\t\tmatch.splice(1,1);\n\n\t\t\t\tif ( left.substr( left.length - 1 ) === \"\\\\\" ) {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\tif ( curLoop === result ) {\n\t\t\t\t\tresult = [];\n\t\t\t\t}\n\n\t\t\t\tif ( Expr.preFilter[ type ] ) {\n\t\t\t\t\tmatch = Expr.preFilter[ type ]( match, curLoop, inplace, result, not, isXMLFilter );\n\n\t\t\t\t\tif ( !match ) {\n\t\t\t\t\t\tanyFound = found = true;\n\t\t\t\t\t} else if ( match === true ) {\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ( match ) {\n\t\t\t\t\tfor ( var i = 0; (item = curLoop[i]) != null; i++ ) {\n\t\t\t\t\t\tif ( item ) {\n\t\t\t\t\t\t\tfound = filter( item, match, i, curLoop );\n\t\t\t\t\t\t\tvar pass = not ^ !!found;\n\n\t\t\t\t\t\t\tif ( inplace && found != null ) {\n\t\t\t\t\t\t\t\tif ( pass ) {\n\t\t\t\t\t\t\t\t\tanyFound = true;\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tcurLoop[i] = false;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else if ( pass ) {\n\t\t\t\t\t\t\t\tresult.push( item );\n\t\t\t\t\t\t\t\tanyFound = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ( found !== undefined ) {\n\t\t\t\t\tif ( !inplace ) {\n\t\t\t\t\t\tcurLoop = result;\n\t\t\t\t\t}\n\n\t\t\t\t\texpr = expr.replace( Expr.match[ type ], \"\" );\n\n\t\t\t\t\tif ( !anyFound ) {\n\t\t\t\t\t\treturn [];\n\t\t\t\t\t}\n\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Improper expression\n\t\tif ( expr === old ) {\n\t\t\tif ( anyFound == null ) {\n\t\t\t\tSizzle.error( expr );\n\t\t\t} else {\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\n\t\told = expr;\n\t}\n\n\treturn curLoop;\n};\n\nSizzle.error = function( msg ) {\n\tthrow \"Syntax error, unrecognized expression: \" + msg;\n};\n\nvar Expr = Sizzle.selectors = {\n\torder: [ \"ID\", \"NAME\", \"TAG\" ],\n\tmatch: {\n\t\tID: /#((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)/,\n\t\tCLASS: /\\.((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)/,\n\t\tNAME: /\\[name=['\"]*((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)['\"]*\\]/,\n\t\tATTR: /\\[\\s*((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)\\s*(?:(\\S?=)\\s*(['\"]*)(.*?)\\3|)\\s*\\]/,\n\t\tTAG: /^((?:[\\w\\u00c0-\\uFFFF\\*\\-]|\\\\.)+)/,\n\t\tCHILD: /:(only|nth|last|first)-child(?:\\((even|odd|[\\dn+\\-]*)\\))?/,\n\t\tPOS: /:(nth|eq|gt|lt|first|last|even|odd)(?:\\((\\d*)\\))?(?=[^\\-]|$)/,\n\t\tPSEUDO: /:((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)(?:\\((['\"]?)((?:\\([^\\)]+\\)|[^\\(\\)]*)+)\\2\\))?/\n\t},\n\tleftMatch: {},\n\tattrMap: {\n\t\t\"class\": \"className\",\n\t\t\"for\": \"htmlFor\"\n\t},\n\tattrHandle: {\n\t\thref: function(elem){\n\t\t\treturn elem.getAttribute(\"href\");\n\t\t}\n\t},\n\trelative: {\n\t\t\"+\": function(checkSet, part){\n\t\t\tvar isPartStr = typeof part === \"string\",\n\t\t\t\tisTag = isPartStr && !/\\W/.test(part),\n\t\t\t\tisPartStrNotTag = isPartStr && !isTag;\n\n\t\t\tif ( isTag ) {\n\t\t\t\tpart = part.toLowerCase();\n\t\t\t}\n\n\t\t\tfor ( var i = 0, l = checkSet.length, elem; i < l; i++ ) {\n\t\t\t\tif ( (elem = checkSet[i]) ) {\n\t\t\t\t\twhile ( (elem = elem.previousSibling) && elem.nodeType !== 1 ) {}\n\n\t\t\t\t\tcheckSet[i] = isPartStrNotTag || elem && elem.nodeName.toLowerCase() === part ?\n\t\t\t\t\t\telem || false :\n\t\t\t\t\t\telem === part;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( isPartStrNotTag ) {\n\t\t\t\tSizzle.filter( part, checkSet, true );\n\t\t\t}\n\t\t},\n\t\t\">\": function(checkSet, part){\n\t\t\tvar isPartStr = typeof part === \"string\",\n\t\t\t\telem, i = 0, l = checkSet.length;\n\n\t\t\tif ( isPartStr && !/\\W/.test(part) ) {\n\t\t\t\tpart = part.toLowerCase();\n\n\t\t\t\tfor ( ; i < l; i++ ) {\n\t\t\t\t\telem = checkSet[i];\n\t\t\t\t\tif ( elem ) {\n\t\t\t\t\t\tvar parent = elem.parentNode;\n\t\t\t\t\t\tcheckSet[i] = parent.nodeName.toLowerCase() === part ? parent : false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tfor ( ; i < l; i++ ) {\n\t\t\t\t\telem = checkSet[i];\n\t\t\t\t\tif ( elem ) {\n\t\t\t\t\t\tcheckSet[i] = isPartStr ?\n\t\t\t\t\t\t\telem.parentNode :\n\t\t\t\t\t\t\telem.parentNode === part;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ( isPartStr ) {\n\t\t\t\t\tSizzle.filter( part, checkSet, true );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"\": function(checkSet, part, isXML){\n\t\t\tvar doneName = done++, checkFn = dirCheck, nodeCheck;\n\n\t\t\tif ( typeof part === \"string\" && !/\\W/.test(part) ) {\n\t\t\t\tpart = part.toLowerCase();\n\t\t\t\tnodeCheck = part;\n\t\t\t\tcheckFn = dirNodeCheck;\n\t\t\t}\n\n\t\t\tcheckFn(\"parentNode\", part, doneName, checkSet, nodeCheck, isXML);\n\t\t},\n\t\t\"~\": function(checkSet, part, isXML){\n\t\t\tvar doneName = done++, checkFn = dirCheck, nodeCheck;\n\n\t\t\tif ( typeof part === \"string\" && !/\\W/.test(part) ) {\n\t\t\t\tpart = part.toLowerCase();\n\t\t\t\tnodeCheck = part;\n\t\t\t\tcheckFn = dirNodeCheck;\n\t\t\t}\n\n\t\t\tcheckFn(\"previousSibling\", part, doneName, checkSet, nodeCheck, isXML);\n\t\t}\n\t},\n\tfind: {\n\t\tID: function(match, context, isXML){\n\t\t\tif ( typeof context.getElementById !== \"undefined\" && !isXML ) {\n\t\t\t\tvar m = context.getElementById(match[1]);\n\t\t\t\treturn m ? [m] : [];\n\t\t\t}\n\t\t},\n\t\tNAME: function(match, context){\n\t\t\tif ( typeof context.getElementsByName !== \"undefined\" ) {\n\t\t\t\tvar ret = [], results = context.getElementsByName(match[1]);\n\n\t\t\t\tfor ( var i = 0, l = results.length; i < l; i++ ) {\n\t\t\t\t\tif ( results[i].getAttribute(\"name\") === match[1] ) {\n\t\t\t\t\t\tret.push( results[i] );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn ret.length === 0 ? null : ret;\n\t\t\t}\n\t\t},\n\t\tTAG: function(match, context){\n\t\t\treturn context.getElementsByTagName(match[1]);\n\t\t}\n\t},\n\tpreFilter: {\n\t\tCLASS: function(match, curLoop, inplace, result, not, isXML){\n\t\t\tmatch = \" \" + match[1].replace(/\\\\/g, \"\") + \" \";\n\n\t\t\tif ( isXML ) {\n\t\t\t\treturn match;\n\t\t\t}\n\n\t\t\tfor ( var i = 0, elem; (elem = curLoop[i]) != null; i++ ) {\n\t\t\t\tif ( elem ) {\n\t\t\t\t\tif ( not ^ (elem.className && (\" \" + elem.className + \" \").replace(/[\\t\\n]/g, \" \").indexOf(match) >= 0) ) {\n\t\t\t\t\t\tif ( !inplace ) {\n\t\t\t\t\t\t\tresult.push( elem );\n\t\t\t\t\t\t}\n\t\t\t\t\t} else if ( inplace ) {\n\t\t\t\t\t\tcurLoop[i] = false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn false;\n\t\t},\n\t\tID: function(match){\n\t\t\treturn match[1].replace(/\\\\/g, \"\");\n\t\t},\n\t\tTAG: function(match, curLoop){\n\t\t\treturn match[1].toLowerCase();\n\t\t},\n\t\tCHILD: function(match){\n\t\t\tif ( match[1] === \"nth\" ) {\n\t\t\t\t// parse equations like 'even', 'odd', '5', '2n', '3n+2', '4n-1', '-n+6'\n\t\t\t\tvar test = /(-?)(\\d*)n((?:\\+|-)?\\d*)/.exec(\n\t\t\t\t\tmatch[2] === \"even\" && \"2n\" || match[2] === \"odd\" && \"2n+1\" ||\n\t\t\t\t\t!/\\D/.test( match[2] ) && \"0n+\" + match[2] || match[2]);\n\n\t\t\t\t// calculate the numbers (first)n+(last) including if they are negative\n\t\t\t\tmatch[2] = (test[1] + (test[2] || 1)) - 0;\n\t\t\t\tmatch[3] = test[3] - 0;\n\t\t\t}\n\n\t\t\t// TODO: Move to normal caching system\n\t\t\tmatch[0] = done++;\n\n\t\t\treturn match;\n\t\t},\n\t\tATTR: function(match, curLoop, inplace, result, not, isXML){\n\t\t\tvar name = match[1].replace(/\\\\/g, \"\");\n\t\t\t\n\t\t\tif ( !isXML && Expr.attrMap[name] ) {\n\t\t\t\tmatch[1] = Expr.attrMap[name];\n\t\t\t}\n\n\t\t\tif ( match[2] === \"~=\" ) {\n\t\t\t\tmatch[4] = \" \" + match[4] + \" \";\n\t\t\t}\n\n\t\t\treturn match;\n\t\t},\n\t\tPSEUDO: function(match, curLoop, inplace, result, not){\n\t\t\tif ( match[1] === \"not\" ) {\n\t\t\t\t// If we're dealing with a complex expression, or a simple one\n\t\t\t\tif ( ( chunker.exec(match[3]) || \"\" ).length > 1 || /^\\w/.test(match[3]) ) {\n\t\t\t\t\tmatch[3] = Sizzle(match[3], null, null, curLoop);\n\t\t\t\t} else {\n\t\t\t\t\tvar ret = Sizzle.filter(match[3], curLoop, inplace, true ^ not);\n\t\t\t\t\tif ( !inplace ) {\n\t\t\t\t\t\tresult.push.apply( result, ret );\n\t\t\t\t\t}\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t} else if ( Expr.match.POS.test( match[0] ) || Expr.match.CHILD.test( match[0] ) ) {\n\t\t\t\treturn true;\n\t\t\t}\n\t\t\t\n\t\t\treturn match;\n\t\t},\n\t\tPOS: function(match){\n\t\t\tmatch.unshift( true );\n\t\t\treturn match;\n\t\t}\n\t},\n\tfilters: {\n\t\tenabled: function(elem){\n\t\t\treturn elem.disabled === false && elem.type !== \"hidden\";\n\t\t},\n\t\tdisabled: function(elem){\n\t\t\treturn elem.disabled === true;\n\t\t},\n\t\tchecked: function(elem){\n\t\t\treturn elem.checked === true;\n\t\t},\n\t\tselected: function(elem){\n\t\t\t// Accessing this property makes selected-by-default\n\t\t\t// options in Safari work properly\n\t\t\telem.parentNode.selectedIndex;\n\t\t\treturn elem.selected === true;\n\t\t},\n\t\tparent: function(elem){\n\t\t\treturn !!elem.firstChild;\n\t\t},\n\t\tempty: function(elem){\n\t\t\treturn !elem.firstChild;\n\t\t},\n\t\thas: function(elem, i, match){\n\t\t\treturn !!Sizzle( match[3], elem ).length;\n\t\t},\n\t\theader: function(elem){\n\t\t\treturn (/h\\d/i).test( elem.nodeName );\n\t\t},\n\t\ttext: function(elem){\n\t\t\treturn \"text\" === elem.type;\n\t\t},\n\t\tradio: function(elem){\n\t\t\treturn \"radio\" === elem.type;\n\t\t},\n\t\tcheckbox: function(elem){\n\t\t\treturn \"checkbox\" === elem.type;\n\t\t},\n\t\tfile: function(elem){\n\t\t\treturn \"file\" === elem.type;\n\t\t},\n\t\tpassword: function(elem){\n\t\t\treturn \"password\" === elem.type;\n\t\t},\n\t\tsubmit: function(elem){\n\t\t\treturn \"submit\" === elem.type;\n\t\t},\n\t\timage: function(elem){\n\t\t\treturn \"image\" === elem.type;\n\t\t},\n\t\treset: function(elem){\n\t\t\treturn \"reset\" === elem.type;\n\t\t},\n\t\tbutton: function(elem){\n\t\t\treturn \"button\" === elem.type || elem.nodeName.toLowerCase() === \"button\";\n\t\t},\n\t\tinput: function(elem){\n\t\t\treturn (/input|select|textarea|button/i).test(elem.nodeName);\n\t\t}\n\t},\n\tsetFilters: {\n\t\tfirst: function(elem, i){\n\t\t\treturn i === 0;\n\t\t},\n\t\tlast: function(elem, i, match, array){\n\t\t\treturn i === array.length - 1;\n\t\t},\n\t\teven: function(elem, i){\n\t\t\treturn i % 2 === 0;\n\t\t},\n\t\todd: function(elem, i){\n\t\t\treturn i % 2 === 1;\n\t\t},\n\t\tlt: function(elem, i, match){\n\t\t\treturn i < match[3] - 0;\n\t\t},\n\t\tgt: function(elem, i, match){\n\t\t\treturn i > match[3] - 0;\n\t\t},\n\t\tnth: function(elem, i, match){\n\t\t\treturn match[3] - 0 === i;\n\t\t},\n\t\teq: function(elem, i, match){\n\t\t\treturn match[3] - 0 === i;\n\t\t}\n\t},\n\tfilter: {\n\t\tPSEUDO: function(elem, match, i, array){\n\t\t\tvar name = match[1], filter = Expr.filters[ name ];\n\n\t\t\tif ( filter ) {\n\t\t\t\treturn filter( elem, i, match, array );\n\t\t\t} else if ( name === \"contains\" ) {\n\t\t\t\treturn (elem.textContent || elem.innerText || Sizzle.getText([ elem ]) || \"\").indexOf(match[3]) >= 0;\n\t\t\t} else if ( name === \"not\" ) {\n\t\t\t\tvar not = match[3];\n\n\t\t\t\tfor ( var j = 0, l = not.length; j < l; j++ ) {\n\t\t\t\t\tif ( not[j] === elem ) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn true;\n\t\t\t} else {\n\t\t\t\tSizzle.error( \"Syntax error, unrecognized expression: \" + name );\n\t\t\t}\n\t\t},\n\t\tCHILD: function(elem, match){\n\t\t\tvar type = match[1], node = elem;\n\t\t\tswitch (type) {\n\t\t\t\tcase 'only':\n\t\t\t\tcase 'first':\n\t\t\t\t\twhile ( (node = node.previousSibling) )\t {\n\t\t\t\t\t\tif ( node.nodeType === 1 ) { \n\t\t\t\t\t\t\treturn false; \n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tif ( type === \"first\" ) { \n\t\t\t\t\t\treturn true; \n\t\t\t\t\t}\n\t\t\t\t\tnode = elem;\n\t\t\t\tcase 'last':\n\t\t\t\t\twhile ( (node = node.nextSibling) )\t {\n\t\t\t\t\t\tif ( node.nodeType === 1 ) { \n\t\t\t\t\t\t\treturn false; \n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn true;\n\t\t\t\tcase 'nth':\n\t\t\t\t\tvar first = match[2], last = match[3];\n\n\t\t\t\t\tif ( first === 1 && last === 0 ) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\t\t\t\t\t\n\t\t\t\t\tvar doneName = match[0],\n\t\t\t\t\t\tparent = elem.parentNode;\n\t\n\t\t\t\t\tif ( parent && (parent.sizcache !== doneName || !elem.nodeIndex) ) {\n\t\t\t\t\t\tvar count = 0;\n\t\t\t\t\t\tfor ( node = parent.firstChild; node; node = node.nextSibling ) {\n\t\t\t\t\t\t\tif ( node.nodeType === 1 ) {\n\t\t\t\t\t\t\t\tnode.nodeIndex = ++count;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} \n\t\t\t\t\t\tparent.sizcache = doneName;\n\t\t\t\t\t}\n\t\t\t\t\t\n\t\t\t\t\tvar diff = elem.nodeIndex - last;\n\t\t\t\t\tif ( first === 0 ) {\n\t\t\t\t\t\treturn diff === 0;\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn ( diff % first === 0 && diff / first >= 0 );\n\t\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\tID: function(elem, match){\n\t\t\treturn elem.nodeType === 1 && elem.getAttribute(\"id\") === match;\n\t\t},\n\t\tTAG: function(elem, match){\n\t\t\treturn (match === \"*\" && elem.nodeType === 1) || elem.nodeName.toLowerCase() === match;\n\t\t},\n\t\tCLASS: function(elem, match){\n\t\t\treturn (\" \" + (elem.className || elem.getAttribute(\"class\")) + \" \")\n\t\t\t\t.indexOf( match ) > -1;\n\t\t},\n\t\tATTR: function(elem, match){\n\t\t\tvar name = match[1],\n\t\t\t\tresult = Expr.attrHandle[ name ] ?\n\t\t\t\t\tExpr.attrHandle[ name ]( elem ) :\n\t\t\t\t\telem[ name ] != null ?\n\t\t\t\t\t\telem[ name ] :\n\t\t\t\t\t\telem.getAttribute( name ),\n\t\t\t\tvalue = result + \"\",\n\t\t\t\ttype = match[2],\n\t\t\t\tcheck = match[4];\n\n\t\t\treturn result == null ?\n\t\t\t\ttype === \"!=\" :\n\t\t\t\ttype === \"=\" ?\n\t\t\t\tvalue === check :\n\t\t\t\ttype === \"*=\" ?\n\t\t\t\tvalue.indexOf(check) >= 0 :\n\t\t\t\ttype === \"~=\" ?\n\t\t\t\t(\" \" + value + \" \").indexOf(check) >= 0 :\n\t\t\t\t!check ?\n\t\t\t\tvalue && result !== false :\n\t\t\t\ttype === \"!=\" ?\n\t\t\t\tvalue !== check :\n\t\t\t\ttype === \"^=\" ?\n\t\t\t\tvalue.indexOf(check) === 0 :\n\t\t\t\ttype === \"$=\" ?\n\t\t\t\tvalue.substr(value.length - check.length) === check :\n\t\t\t\ttype === \"|=\" ?\n\t\t\t\tvalue === check || value.substr(0, check.length + 1) === check + \"-\" :\n\t\t\t\tfalse;\n\t\t},\n\t\tPOS: function(elem, match, i, array){\n\t\t\tvar name = match[2], filter = Expr.setFilters[ name ];\n\n\t\t\tif ( filter ) {\n\t\t\t\treturn filter( elem, i, match, array );\n\t\t\t}\n\t\t}\n\t}\n};\n\nvar origPOS = Expr.match.POS,\n\tfescape = function(all, num){\n\t\treturn \"\\\\\" + (num - 0 + 1);\n\t};\n\nfor ( var type in Expr.match ) {\n\tExpr.match[ type ] = new RegExp( Expr.match[ type ].source + (/(?![^\\[]*\\])(?![^\\(]*\\))/.source) );\n\tExpr.leftMatch[ type ] = new RegExp( /(^(?:.|\\r|\\n)*?)/.source + Expr.match[ type ].source.replace(/\\\\(\\d+)/g, fescape) );\n}\n\nvar makeArray = function(array, results) {\n\tarray = Array.prototype.slice.call( array, 0 );\n\n\tif ( results ) {\n\t\tresults.push.apply( results, array );\n\t\treturn results;\n\t}\n\t\n\treturn array;\n};\n\n// Perform a simple check to determine if the browser is capable of\n// converting a NodeList to an array using builtin methods.\n// Also verifies that the returned array holds DOM nodes\n// (which is not the case in the Blackberry browser)\ntry {\n\tArray.prototype.slice.call( document.documentElement.childNodes, 0 )[0].nodeType;\n\n// Provide a fallback method if it does not work\n} catch(e){\n\tmakeArray = function(array, results) {\n\t\tvar ret = results || [], i = 0;\n\n\t\tif ( toString.call(array) === \"[object Array]\" ) {\n\t\t\tArray.prototype.push.apply( ret, array );\n\t\t} else {\n\t\t\tif ( typeof array.length === \"number\" ) {\n\t\t\t\tfor ( var l = array.length; i < l; i++ ) {\n\t\t\t\t\tret.push( array[i] );\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tfor ( ; array[i]; i++ ) {\n\t\t\t\t\tret.push( array[i] );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn ret;\n\t};\n}\n\nvar sortOrder;\n\nif ( document.documentElement.compareDocumentPosition ) {\n\tsortOrder = function( a, b ) {\n\t\tif ( !a.compareDocumentPosition || !b.compareDocumentPosition ) {\n\t\t\tif ( a == b ) {\n\t\t\t\thasDuplicate = true;\n\t\t\t}\n\t\t\treturn a.compareDocumentPosition ? -1 : 1;\n\t\t}\n\n\t\tvar ret = a.compareDocumentPosition(b) & 4 ? -1 : a === b ? 0 : 1;\n\t\tif ( ret === 0 ) {\n\t\t\thasDuplicate = true;\n\t\t}\n\t\treturn ret;\n\t};\n} else if ( \"sourceIndex\" in document.documentElement ) {\n\tsortOrder = function( a, b ) {\n\t\tif ( !a.sourceIndex || !b.sourceIndex ) {\n\t\t\tif ( a == b ) {\n\t\t\t\thasDuplicate = true;\n\t\t\t}\n\t\t\treturn a.sourceIndex ? -1 : 1;\n\t\t}\n\n\t\tvar ret = a.sourceIndex - b.sourceIndex;\n\t\tif ( ret === 0 ) {\n\t\t\thasDuplicate = true;\n\t\t}\n\t\treturn ret;\n\t};\n} else if ( document.createRange ) {\n\tsortOrder = function( a, b ) {\n\t\tif ( !a.ownerDocument || !b.ownerDocument ) {\n\t\t\tif ( a == b ) {\n\t\t\t\thasDuplicate = true;\n\t\t\t}\n\t\t\treturn a.ownerDocument ? -1 : 1;\n\t\t}\n\n\t\tvar aRange = a.ownerDocument.createRange(), bRange = b.ownerDocument.createRange();\n\t\taRange.setStart(a, 0);\n\t\taRange.setEnd(a, 0);\n\t\tbRange.setStart(b, 0);\n\t\tbRange.setEnd(b, 0);\n\t\tvar ret = aRange.compareBoundaryPoints(Range.START_TO_END, bRange);\n\t\tif ( ret === 0 ) {\n\t\t\thasDuplicate = true;\n\t\t}\n\t\treturn ret;\n\t};\n}\n\n// Utility function for retreiving the text value of an array of DOM nodes\nSizzle.getText = function( elems ) {\n\tvar ret = \"\", elem;\n\n\tfor ( var i = 0; elems[i]; i++ ) {\n\t\telem = elems[i];\n\n\t\t// Get the text from text nodes and CDATA nodes\n\t\tif ( elem.nodeType === 3 || elem.nodeType === 4 ) {\n\t\t\tret += elem.nodeValue;\n\n\t\t// Traverse everything else, except comment nodes\n\t\t} else if ( elem.nodeType !== 8 ) {\n\t\t\tret += Sizzle.getText( elem.childNodes );\n\t\t}\n\t}\n\n\treturn ret;\n};\n\n// Check to see if the browser returns elements by name when\n// querying by getElementById (and provide a workaround)\n(function(){\n\t// We're going to inject a fake input element with a specified name\n\tvar form = document.createElement(\"div\"),\n\t\tid = \"script\" + (new Date()).getTime();\n\tform.innerHTML = \"<a name='\" + id + \"'/>\";\n\n\t// Inject it into the root element, check its status, and remove it quickly\n\tvar root = document.documentElement;\n\troot.insertBefore( form, root.firstChild );\n\n\t// The workaround has to do additional checks after a getElementById\n\t// Which slows things down for other browsers (hence the branching)\n\tif ( document.getElementById( id ) ) {\n\t\tExpr.find.ID = function(match, context, isXML){\n\t\t\tif ( typeof context.getElementById !== \"undefined\" && !isXML ) {\n\t\t\t\tvar m = context.getElementById(match[1]);\n\t\t\t\treturn m ? m.id === match[1] || typeof m.getAttributeNode !== \"undefined\" && m.getAttributeNode(\"id\").nodeValue === match[1] ? [m] : undefined : [];\n\t\t\t}\n\t\t};\n\n\t\tExpr.filter.ID = function(elem, match){\n\t\t\tvar node = typeof elem.getAttributeNode !== \"undefined\" && elem.getAttributeNode(\"id\");\n\t\t\treturn elem.nodeType === 1 && node && node.nodeValue === match;\n\t\t};\n\t}\n\n\troot.removeChild( form );\n\troot = form = null; // release memory in IE\n})();\n\n(function(){\n\t// Check to see if the browser returns only elements\n\t// when doing getElementsByTagName(\"*\")\n\n\t// Create a fake element\n\tvar div = document.createElement(\"div\");\n\tdiv.appendChild( document.createComment(\"\") );\n\n\t// Make sure no comments are found\n\tif ( div.getElementsByTagName(\"*\").length > 0 ) {\n\t\tExpr.find.TAG = function(match, context){\n\t\t\tvar results = context.getElementsByTagName(match[1]);\n\n\t\t\t// Filter out possible comments\n\t\t\tif ( match[1] === \"*\" ) {\n\t\t\t\tvar tmp = [];\n\n\t\t\t\tfor ( var i = 0; results[i]; i++ ) {\n\t\t\t\t\tif ( results[i].nodeType === 1 ) {\n\t\t\t\t\t\ttmp.push( results[i] );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tresults = tmp;\n\t\t\t}\n\n\t\t\treturn results;\n\t\t};\n\t}\n\n\t// Check to see if an attribute returns normalized href attributes\n\tdiv.innerHTML = \"<a href='#'></a>\";\n\tif ( div.firstChild && typeof div.firstChild.getAttribute !== \"undefined\" &&\n\t\t\tdiv.firstChild.getAttribute(\"href\") !== \"#\" ) {\n\t\tExpr.attrHandle.href = function(elem){\n\t\t\treturn elem.getAttribute(\"href\", 2);\n\t\t};\n\t}\n\n\tdiv = null; // release memory in IE\n})();\n\nif ( document.querySelectorAll ) {\n\t(function(){\n\t\tvar oldSizzle = Sizzle, div = document.createElement(\"div\");\n\t\tdiv.innerHTML = \"<p class='TEST'></p>\";\n\n\t\t// Safari can't handle uppercase or unicode characters when\n\t\t// in quirks mode.\n\t\tif ( div.querySelectorAll && div.querySelectorAll(\".TEST\").length === 0 ) {\n\t\t\treturn;\n\t\t}\n\t\n\t\tSizzle = function(query, context, extra, seed){\n\t\t\tcontext = context || document;\n\n\t\t\t// Only use querySelectorAll on non-XML documents\n\t\t\t// (ID selectors don't work in non-HTML documents)\n\t\t\tif ( !seed && context.nodeType === 9 && !Sizzle.isXML(context) ) {\n\t\t\t\ttry {\n\t\t\t\t\treturn makeArray( context.querySelectorAll(query), extra );\n\t\t\t\t} catch(e){}\n\t\t\t}\n\t\t\n\t\t\treturn oldSizzle(query, context, extra, seed);\n\t\t};\n\n\t\tfor ( var prop in oldSizzle ) {\n\t\t\tSizzle[ prop ] = oldSizzle[ prop ];\n\t\t}\n\n\t\tdiv = null; // release memory in IE\n\t})();\n}\n\n(function(){\n\tvar div = document.createElement(\"div\");\n\n\tdiv.innerHTML = \"<div class='test e'></div><div class='test'></div>\";\n\n\t// Opera can't find a second classname (in 9.6)\n\t// Also, make sure that getElementsByClassName actually exists\n\tif ( !div.getElementsByClassName || div.getElementsByClassName(\"e\").length === 0 ) {\n\t\treturn;\n\t}\n\n\t// Safari caches class attributes, doesn't catch changes (in 3.2)\n\tdiv.lastChild.className = \"e\";\n\n\tif ( div.getElementsByClassName(\"e\").length === 1 ) {\n\t\treturn;\n\t}\n\t\n\tExpr.order.splice(1, 0, \"CLASS\");\n\tExpr.find.CLASS = function(match, context, isXML) {\n\t\tif ( typeof context.getElementsByClassName !== \"undefined\" && !isXML ) {\n\t\t\treturn context.getElementsByClassName(match[1]);\n\t\t}\n\t};\n\n\tdiv = null; // release memory in IE\n})();\n\nfunction dirNodeCheck( dir, cur, doneName, checkSet, nodeCheck, isXML ) {\n\tfor ( var i = 0, l = checkSet.length; i < l; i++ ) {\n\t\tvar elem = checkSet[i];\n\t\tif ( elem ) {\n\t\t\telem = elem[dir];\n\t\t\tvar match = false;\n\n\t\t\twhile ( elem ) {\n\t\t\t\tif ( elem.sizcache === doneName ) {\n\t\t\t\t\tmatch = checkSet[elem.sizset];\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tif ( elem.nodeType === 1 && !isXML ){\n\t\t\t\t\telem.sizcache = doneName;\n\t\t\t\t\telem.sizset = i;\n\t\t\t\t}\n\n\t\t\t\tif ( elem.nodeName.toLowerCase() === cur ) {\n\t\t\t\t\tmatch = elem;\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\telem = elem[dir];\n\t\t\t}\n\n\t\t\tcheckSet[i] = match;\n\t\t}\n\t}\n}\n\nfunction dirCheck( dir, cur, doneName, checkSet, nodeCheck, isXML ) {\n\tfor ( var i = 0, l = checkSet.length; i < l; i++ ) {\n\t\tvar elem = checkSet[i];\n\t\tif ( elem ) {\n\t\t\telem = elem[dir];\n\t\t\tvar match = false;\n\n\t\t\twhile ( elem ) {\n\t\t\t\tif ( elem.sizcache === doneName ) {\n\t\t\t\t\tmatch = checkSet[elem.sizset];\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\t\tif ( !isXML ) {\n\t\t\t\t\t\telem.sizcache = doneName;\n\t\t\t\t\t\telem.sizset = i;\n\t\t\t\t\t}\n\t\t\t\t\tif ( typeof cur !== \"string\" ) {\n\t\t\t\t\t\tif ( elem === cur ) {\n\t\t\t\t\t\t\tmatch = true;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t} else if ( Sizzle.filter( cur, [elem] ).length > 0 ) {\n\t\t\t\t\t\tmatch = elem;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\telem = elem[dir];\n\t\t\t}\n\n\t\t\tcheckSet[i] = match;\n\t\t}\n\t}\n}\n\nSizzle.contains = document.compareDocumentPosition ? function(a, b){\n\treturn !!(a.compareDocumentPosition(b) & 16);\n} : function(a, b){\n\treturn a !== b && (a.contains ? a.contains(b) : true);\n};\n\nSizzle.isXML = function(elem){\n\t// documentElement is verified for cases where it doesn't yet exist\n\t// (such as loading iframes in IE - #4833) \n\tvar documentElement = (elem ? elem.ownerDocument || elem : 0).documentElement;\n\treturn documentElement ? documentElement.nodeName !== \"HTML\" : false;\n};\n\nvar posProcess = function(selector, context){\n\tvar tmpSet = [], later = \"\", match,\n\t\troot = context.nodeType ? [context] : context;\n\n\t// Position selectors must be done after the filter\n\t// And so must :not(positional) so we move all PSEUDOs to the end\n\twhile ( (match = Expr.match.PSEUDO.exec( selector )) ) {\n\t\tlater += match[0];\n\t\tselector = selector.replace( Expr.match.PSEUDO, \"\" );\n\t}\n\n\tselector = Expr.relative[selector] ? selector + \"*\" : selector;\n\n\tfor ( var i = 0, l = root.length; i < l; i++ ) {\n\t\tSizzle( selector, root[i], tmpSet );\n\t}\n\n\treturn Sizzle.filter( later, tmpSet );\n};\n\n// EXPOSE\n\nwindow.tinymce.dom.Sizzle = Sizzle;\n\n})();\n\n\n(function(tinymce) {\n\t// Shorten names\n\tvar each = tinymce.each, DOM = tinymce.DOM, isIE = tinymce.isIE, isWebKit = tinymce.isWebKit, Event;\n\n\ttinymce.create('tinymce.dom.EventUtils', {\n\t\tEventUtils : function() {\n\t\t\tthis.inits = [];\n\t\t\tthis.events = [];\n\t\t},\n\n\t\tadd : function(o, n, f, s) {\n\t\t\tvar cb, t = this, el = t.events, r;\n\n\t\t\tif (n instanceof Array) {\n\t\t\t\tr = [];\n\n\t\t\t\teach(n, function(n) {\n\t\t\t\t\tr.push(t.add(o, n, f, s));\n\t\t\t\t});\n\n\t\t\t\treturn r;\n\t\t\t}\n\n\t\t\t// Handle array\n\t\t\tif (o && o.hasOwnProperty && o instanceof Array) {\n\t\t\t\tr = [];\n\n\t\t\t\teach(o, function(o) {\n\t\t\t\t\to = DOM.get(o);\n\t\t\t\t\tr.push(t.add(o, n, f, s));\n\t\t\t\t});\n\n\t\t\t\treturn r;\n\t\t\t}\n\n\t\t\to = DOM.get(o);\n\n\t\t\tif (!o)\n\t\t\t\treturn;\n\n\t\t\t// Setup event callback\n\t\t\tcb = function(e) {\n\t\t\t\t// Is all events disabled\n\t\t\t\tif (t.disabled)\n\t\t\t\t\treturn;\n\n\t\t\t\te = e || window.event;\n\n\t\t\t\t// Patch in target, preventDefault and stopPropagation in IE it's W3C valid\n\t\t\t\tif (e && isIE) {\n\t\t\t\t\tif (!e.target)\n\t\t\t\t\t\te.target = e.srcElement;\n\n\t\t\t\t\t// Patch in preventDefault, stopPropagation methods for W3C compatibility\n\t\t\t\t\ttinymce.extend(e, t._stoppers);\n\t\t\t\t}\n\n\t\t\t\tif (!s)\n\t\t\t\t\treturn f(e);\n\n\t\t\t\treturn f.call(s, e);\n\t\t\t};\n\n\t\t\tif (n == 'unload') {\n\t\t\t\ttinymce.unloads.unshift({func : cb});\n\t\t\t\treturn cb;\n\t\t\t}\n\n\t\t\tif (n == 'init') {\n\t\t\t\tif (t.domLoaded)\n\t\t\t\t\tcb();\n\t\t\t\telse\n\t\t\t\t\tt.inits.push(cb);\n\n\t\t\t\treturn cb;\n\t\t\t}\n\n\t\t\t// Store away listener reference\n\t\t\tel.push({\n\t\t\t\tobj : o,\n\t\t\t\tname : n,\n\t\t\t\tfunc : f,\n\t\t\t\tcfunc : cb,\n\t\t\t\tscope : s\n\t\t\t});\n\n\t\t\tt._add(o, n, cb);\n\n\t\t\treturn f;\n\t\t},\n\n\t\tremove : function(o, n, f) {\n\t\t\tvar t = this, a = t.events, s = false, r;\n\n\t\t\t// Handle array\n\t\t\tif (o && o.hasOwnProperty && o instanceof Array) {\n\t\t\t\tr = [];\n\n\t\t\t\teach(o, function(o) {\n\t\t\t\t\to = DOM.get(o);\n\t\t\t\t\tr.push(t.remove(o, n, f));\n\t\t\t\t});\n\n\t\t\t\treturn r;\n\t\t\t}\n\n\t\t\to = DOM.get(o);\n\n\t\t\teach(a, function(e, i) {\n\t\t\t\tif (e.obj == o && e.name == n && (!f || (e.func == f || e.cfunc == f))) {\n\t\t\t\t\ta.splice(i, 1);\n\t\t\t\t\tt._remove(o, n, e.cfunc);\n\t\t\t\t\ts = true;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn s;\n\t\t},\n\n\t\tclear : function(o) {\n\t\t\tvar t = this, a = t.events, i, e;\n\n\t\t\tif (o) {\n\t\t\t\to = DOM.get(o);\n\n\t\t\t\tfor (i = a.length - 1; i >= 0; i--) {\n\t\t\t\t\te = a[i];\n\n\t\t\t\t\tif (e.obj === o) {\n\t\t\t\t\t\tt._remove(e.obj, e.name, e.cfunc);\n\t\t\t\t\t\te.obj = e.cfunc = null;\n\t\t\t\t\t\ta.splice(i, 1);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tcancel : function(e) {\n\t\t\tif (!e)\n\t\t\t\treturn false;\n\n\t\t\tthis.stop(e);\n\n\t\t\treturn this.prevent(e);\n\t\t},\n\n\t\tstop : function(e) {\n\t\t\tif (e.stopPropagation)\n\t\t\t\te.stopPropagation();\n\t\t\telse\n\t\t\t\te.cancelBubble = true;\n\n\t\t\treturn false;\n\t\t},\n\n\t\tprevent : function(e) {\n\t\t\tif (e.preventDefault)\n\t\t\t\te.preventDefault();\n\t\t\telse\n\t\t\t\te.returnValue = false;\n\n\t\t\treturn false;\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tvar t = this;\n\n\t\t\teach(t.events, function(e, i) {\n\t\t\t\tt._remove(e.obj, e.name, e.cfunc);\n\t\t\t\te.obj = e.cfunc = null;\n\t\t\t});\n\n\t\t\tt.events = [];\n\t\t\tt = null;\n\t\t},\n\n\t\t_add : function(o, n, f) {\n\t\t\tif (o.attachEvent)\n\t\t\t\to.attachEvent('on' + n, f);\n\t\t\telse if (o.addEventListener)\n\t\t\t\to.addEventListener(n, f, false);\n\t\t\telse\n\t\t\t\to['on' + n] = f;\n\t\t},\n\n\t\t_remove : function(o, n, f) {\n\t\t\tif (o) {\n\t\t\t\ttry {\n\t\t\t\t\tif (o.detachEvent)\n\t\t\t\t\t\to.detachEvent('on' + n, f);\n\t\t\t\t\telse if (o.removeEventListener)\n\t\t\t\t\t\to.removeEventListener(n, f, false);\n\t\t\t\t\telse\n\t\t\t\t\t\to['on' + n] = null;\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Might fail with permission denined on IE so we just ignore that\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t_pageInit : function(win) {\n\t\t\tvar t = this;\n\n\t\t\t// Keep it from running more than once\n\t\t\tif (t.domLoaded)\n\t\t\t\treturn;\n\n\t\t\tt.domLoaded = true;\n\n\t\t\teach(t.inits, function(c) {\n\t\t\t\tc();\n\t\t\t});\n\n\t\t\tt.inits = [];\n\t\t},\n\n\t\t_wait : function(win) {\n\t\t\tvar t = this, doc = win.document;\n\n\t\t\t// No need since the document is already loaded\n\t\t\tif (win.tinyMCE_GZ && tinyMCE_GZ.loaded) {\n\t\t\t\tt.domLoaded = 1;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Use IE method\n\t\t\tif (doc.attachEvent) {\n\t\t\t\tdoc.attachEvent(\"onreadystatechange\", function() {\n\t\t\t\t\tif (doc.readyState === \"complete\") {\n\t\t\t\t\t\tdoc.detachEvent(\"onreadystatechange\", arguments.callee);\n\t\t\t\t\t\tt._pageInit(win);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tif (doc.documentElement.doScroll && win == win.top) {\n\t\t\t\t\t(function() {\n\t\t\t\t\t\tif (t.domLoaded)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t// If IE is used, use the trick by Diego Perini licensed under MIT by request to the author.\n\t\t\t\t\t\t\t// http://javascript.nwbox.com/IEContentLoaded/\n\t\t\t\t\t\t\tdoc.documentElement.doScroll(\"left\");\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\tsetTimeout(arguments.callee, 0);\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tt._pageInit(win);\n\t\t\t\t\t})();\n\t\t\t\t}\n\t\t\t} else if (doc.addEventListener) {\n\t\t\t\tt._add(win, 'DOMContentLoaded', function() {\n\t\t\t\t\tt._pageInit(win);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tt._add(win, 'load', function() {\n\t\t\t\tt._pageInit(win);\n\t\t\t});\n\t\t},\n\n\t\t_stoppers : {\n\t\t\tpreventDefault : function() {\n\t\t\t\tthis.returnValue = false;\n\t\t\t},\n\n\t\t\tstopPropagation : function() {\n\t\t\t\tthis.cancelBubble = true;\n\t\t\t}\n\t\t}\n\t});\n\n\tEvent = tinymce.dom.Event = new tinymce.dom.EventUtils();\n\n\t// Dispatch DOM content loaded event for IE and Safari\n\tEvent._wait(window);\n\n\ttinymce.addUnload(function() {\n\t\tEvent.destroy();\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\ttinymce.dom.Element = function(id, settings) {\n\t\tvar t = this, dom, el;\n\n\t\tt.settings = settings = settings || {};\n\t\tt.id = id;\n\t\tt.dom = dom = settings.dom || tinymce.DOM;\n\n\t\t// Only IE leaks DOM references, this is a lot faster\n\t\tif (!tinymce.isIE)\n\t\t\tel = dom.get(t.id);\n\n\t\ttinymce.each(\n\t\t\t\t('getPos,getRect,getParent,add,setStyle,getStyle,setStyles,' + \n\t\t\t\t'setAttrib,setAttribs,getAttrib,addClass,removeClass,' + \n\t\t\t\t'hasClass,getOuterHTML,setOuterHTML,remove,show,hide,' + \n\t\t\t\t'isHidden,setHTML,get').split(/,/)\n\t\t\t, function(k) {\n\t\t\t\tt[k] = function() {\n\t\t\t\t\tvar a = [id], i;\n\n\t\t\t\t\tfor (i = 0; i < arguments.length; i++)\n\t\t\t\t\t\ta.push(arguments[i]);\n\n\t\t\t\t\ta = dom[k].apply(dom, a);\n\t\t\t\t\tt.update(k);\n\n\t\t\t\t\treturn a;\n\t\t\t\t};\n\t\t});\n\n\t\ttinymce.extend(t, {\n\t\t\ton : function(n, f, s) {\n\t\t\t\treturn tinymce.dom.Event.add(t.id, n, f, s);\n\t\t\t},\n\n\t\t\tgetXY : function() {\n\t\t\t\treturn {\n\t\t\t\t\tx : parseInt(t.getStyle('left')),\n\t\t\t\t\ty : parseInt(t.getStyle('top'))\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tgetSize : function() {\n\t\t\t\tvar n = dom.get(t.id);\n\n\t\t\t\treturn {\n\t\t\t\t\tw : parseInt(t.getStyle('width') || n.clientWidth),\n\t\t\t\t\th : parseInt(t.getStyle('height') || n.clientHeight)\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tmoveTo : function(x, y) {\n\t\t\t\tt.setStyles({left : x, top : y});\n\t\t\t},\n\n\t\t\tmoveBy : function(x, y) {\n\t\t\t\tvar p = t.getXY();\n\n\t\t\t\tt.moveTo(p.x + x, p.y + y);\n\t\t\t},\n\n\t\t\tresizeTo : function(w, h) {\n\t\t\t\tt.setStyles({width : w, height : h});\n\t\t\t},\n\n\t\t\tresizeBy : function(w, h) {\n\t\t\t\tvar s = t.getSize();\n\n\t\t\t\tt.resizeTo(s.w + w, s.h + h);\n\t\t\t},\n\n\t\t\tupdate : function(k) {\n\t\t\t\tvar b;\n\n\t\t\t\tif (tinymce.isIE6 && settings.blocker) {\n\t\t\t\t\tk = k || '';\n\n\t\t\t\t\t// Ignore getters\n\t\t\t\t\tif (k.indexOf('get') === 0 || k.indexOf('has') === 0 || k.indexOf('is') === 0)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Remove blocker on remove\n\t\t\t\t\tif (k == 'remove') {\n\t\t\t\t\t\tdom.remove(t.blocker);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!t.blocker) {\n\t\t\t\t\t\tt.blocker = dom.uniqueId();\n\t\t\t\t\t\tb = dom.add(settings.container || dom.getRoot(), 'iframe', {id : t.blocker, style : 'position:absolute;', frameBorder : 0, src : 'javascript:\"\"'});\n\t\t\t\t\t\tdom.setStyle(b, 'opacity', 0);\n\t\t\t\t\t} else\n\t\t\t\t\t\tb = dom.get(t.blocker);\n\n\t\t\t\t\tdom.setStyles(b, {\n\t\t\t\t\t\tleft : t.getStyle('left', 1),\n\t\t\t\t\t\ttop : t.getStyle('top', 1),\n\t\t\t\t\t\twidth : t.getStyle('width', 1),\n\t\t\t\t\t\theight : t.getStyle('height', 1),\n\t\t\t\t\t\tdisplay : t.getStyle('display', 1),\n\t\t\t\t\t\tzIndex : parseInt(t.getStyle('zIndex', 1) || 0) - 1\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t};\n})(tinymce);\n\n(function(tinymce) {\n\tfunction trimNl(s) {\n\t\treturn s.replace(/[\\n\\r]+/g, '');\n\t};\n\n\t// Shorten names\n\tvar is = tinymce.is, isIE = tinymce.isIE, each = tinymce.each;\n\n\ttinymce.create('tinymce.dom.Selection', {\n\t\tSelection : function(dom, win, serializer) {\n\t\t\tvar t = this;\n\n\t\t\tt.dom = dom;\n\t\t\tt.win = win;\n\t\t\tt.serializer = serializer;\n\n\t\t\t// Add events\n\t\t\teach([\n\t\t\t\t'onBeforeSetContent',\n\n\t\t\t\t'onBeforeGetContent',\n\n\t\t\t\t'onSetContent',\n\n\t\t\t\t'onGetContent'\n\t\t\t], function(e) {\n\t\t\t\tt[e] = new tinymce.util.Dispatcher(t);\n\t\t\t});\n\n\t\t\t// No W3C Range support\n\t\t\tif (!t.win.getSelection)\n\t\t\t\tt.tridentSel = new tinymce.dom.TridentSelection(t);\n\n\t\t\tif (tinymce.isIE && dom.boxModel)\n\t\t\t\tthis._fixIESelection();\n\n\t\t\t// Prevent leaks\n\t\t\ttinymce.addUnload(t.destroy, t);\n\t\t},\n\n\t\tsetCursorLocation: function(node, offset) {\n\t\t\tvar t = this; var r = t.dom.createRng();\n\t\t\tr.setStart(node, offset);\n\t\t\tr.setEnd(node, offset);\n\t\t\tt.setRng(r);\n\t\t\tt.collapse(false);\n\t\t},\n\t\tgetContent : function(s) {\n\t\t\tvar t = this, r = t.getRng(), e = t.dom.create(\"body\"), se = t.getSel(), wb, wa, n;\n\n\t\t\ts = s || {};\n\t\t\twb = wa = '';\n\t\t\ts.get = true;\n\t\t\ts.format = s.format || 'html';\n\t\t\ts.forced_root_block = '';\n\t\t\tt.onBeforeGetContent.dispatch(t, s);\n\n\t\t\tif (s.format == 'text')\n\t\t\t\treturn t.isCollapsed() ? '' : (r.text || (se.toString ? se.toString() : ''));\n\n\t\t\tif (r.cloneContents) {\n\t\t\t\tn = r.cloneContents();\n\n\t\t\t\tif (n)\n\t\t\t\t\te.appendChild(n);\n\t\t\t} else if (is(r.item) || is(r.htmlText)) {\n\t\t\t\t// IE will produce invalid markup if elements are present that\n\t\t\t\t// it doesn't understand like custom elements or HTML5 elements.\n\t\t\t\t// Adding a BR in front of the contents and then remoiving it seems to fix it though.\n\t\t\t\te.innerHTML = '<br>' + (r.item ? r.item(0).outerHTML : r.htmlText);\n\t\t\t\te.removeChild(e.firstChild);\n\t\t\t} else\n\t\t\t\te.innerHTML = r.toString();\n\n\t\t\t// Keep whitespace before and after\n\t\t\tif (/^\\s/.test(e.innerHTML))\n\t\t\t\twb = ' ';\n\n\t\t\tif (/\\s+$/.test(e.innerHTML))\n\t\t\t\twa = ' ';\n\n\t\t\ts.getInner = true;\n\n\t\t\ts.content = t.isCollapsed() ? '' : wb + t.serializer.serialize(e, s) + wa;\n\t\t\tt.onGetContent.dispatch(t, s);\n\n\t\t\treturn s.content;\n\t\t},\n\n\t\tsetContent : function(content, args) {\n\t\t\tvar self = this, rng = self.getRng(), caretNode, doc = self.win.document, frag, temp;\n\n\t\t\targs = args || {format : 'html'};\n\t\t\targs.set = true;\n\t\t\tcontent = args.content = content;\n\n\t\t\t// Dispatch before set content event\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onBeforeSetContent.dispatch(self, args);\n\n\t\t\tcontent = args.content;\n\n\t\t\tif (rng.insertNode) {\n\t\t\t\t// Make caret marker since insertNode places the caret in the beginning of text after insert\n\t\t\t\tcontent += '<span id=\"__caret\">_</span>';\n\n\t\t\t\t// Delete and insert new node\n\t\t\t\tif (rng.startContainer == doc && rng.endContainer == doc) {\n\t\t\t\t\t// WebKit will fail if the body is empty since the range is then invalid and it can't insert contents\n\t\t\t\t\tdoc.body.innerHTML = content;\n\t\t\t\t} else {\n\t\t\t\t\trng.deleteContents();\n\n\t\t\t\t\tif (doc.body.childNodes.length == 0) {\n\t\t\t\t\t\tdoc.body.innerHTML = content;\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// createContextualFragment doesn't exists in IE 9 DOMRanges\n\t\t\t\t\t\tif (rng.createContextualFragment) {\n\t\t\t\t\t\t\trng.insertNode(rng.createContextualFragment(content));\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Fake createContextualFragment call in IE 9\n\t\t\t\t\t\t\tfrag = doc.createDocumentFragment();\n\t\t\t\t\t\t\ttemp = doc.createElement('div');\n\n\t\t\t\t\t\t\tfrag.appendChild(temp);\n\t\t\t\t\t\t\ttemp.outerHTML = content;\n\n\t\t\t\t\t\t\trng.insertNode(frag);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Move to caret marker\n\t\t\t\tcaretNode = self.dom.get('__caret');\n\n\t\t\t\t// Make sure we wrap it compleatly, Opera fails with a simple select call\n\t\t\t\trng = doc.createRange();\n\t\t\t\trng.setStartBefore(caretNode);\n\t\t\t\trng.setEndBefore(caretNode);\n\t\t\t\tself.setRng(rng);\n\n\t\t\t\t// Remove the caret position\n\t\t\t\tself.dom.remove('__caret');\n\n\t\t\t\ttry {\n\t\t\t\t\tself.setRng(rng);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Might fail on Opera for some odd reason\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tif (rng.item) {\n\t\t\t\t\t// Delete content and get caret text selection\n\t\t\t\t\tdoc.execCommand('Delete', false, null);\n\t\t\t\t\trng = self.getRng();\n\t\t\t\t}\n\n\t\t\t\t// Explorer removes spaces from the beginning of pasted contents\n\t\t\t\tif (/^\\s+/.test(content)) {\n\t\t\t\t\trng.pasteHTML('<span id=\"__mce_tmp\">_</span>' + content);\n\t\t\t\t\tself.dom.remove('__mce_tmp');\n\t\t\t\t} else\n\t\t\t\t\trng.pasteHTML(content);\n\t\t\t}\n\n\t\t\t// Dispatch set content event\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onSetContent.dispatch(self, args);\n\t\t},\n\n\t\tgetStart : function() {\n\t\t\tvar rng = this.getRng(), startElement, parentElement, checkRng, node;\n\n\t\t\tif (rng.duplicate || rng.item) {\n\t\t\t\t// Control selection, return first item\n\t\t\t\tif (rng.item)\n\t\t\t\t\treturn rng.item(0);\n\n\t\t\t\t// Get start element\n\t\t\t\tcheckRng = rng.duplicate();\n\t\t\t\tcheckRng.collapse(1);\n\t\t\t\tstartElement = checkRng.parentElement();\n\n\t\t\t\t// Check if range parent is inside the start element, then return the inner parent element\n\t\t\t\t// This will fix issues when a single element is selected, IE would otherwise return the wrong start element\n\t\t\t\tparentElement = node = rng.parentElement();\n\t\t\t\twhile (node = node.parentNode) {\n\t\t\t\t\tif (node == startElement) {\n\t\t\t\t\t\tstartElement = parentElement;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn startElement;\n\t\t\t} else {\n\t\t\t\tstartElement = rng.startContainer;\n\n\t\t\t\tif (startElement.nodeType == 1 && startElement.hasChildNodes())\n\t\t\t\t\tstartElement = startElement.childNodes[Math.min(startElement.childNodes.length - 1, rng.startOffset)];\n\n\t\t\t\tif (startElement && startElement.nodeType == 3)\n\t\t\t\t\treturn startElement.parentNode;\n\n\t\t\t\treturn startElement;\n\t\t\t}\n\t\t},\n\n\t\tgetEnd : function() {\n\t\t\tvar t = this, r = t.getRng(), e, eo;\n\n\t\t\tif (r.duplicate || r.item) {\n\t\t\t\tif (r.item)\n\t\t\t\t\treturn r.item(0);\n\n\t\t\t\tr = r.duplicate();\n\t\t\t\tr.collapse(0);\n\t\t\t\te = r.parentElement();\n\n\t\t\t\tif (e && e.nodeName == 'BODY')\n\t\t\t\t\treturn e.lastChild || e;\n\n\t\t\t\treturn e;\n\t\t\t} else {\n\t\t\t\te = r.endContainer;\n\t\t\t\teo = r.endOffset;\n\n\t\t\t\tif (e.nodeType == 1 && e.hasChildNodes())\n\t\t\t\t\te = e.childNodes[eo > 0 ? eo - 1 : eo];\n\n\t\t\t\tif (e && e.nodeType == 3)\n\t\t\t\t\treturn e.parentNode;\n\n\t\t\t\treturn e;\n\t\t\t}\n\t\t},\n\n\t\tgetBookmark : function(type, normalized) {\n\t\t\tvar t = this, dom = t.dom, rng, rng2, id, collapsed, name, element, index, chr = '\\uFEFF', styles;\n\n\t\t\tfunction findIndex(name, element) {\n\t\t\t\tvar index = 0;\n\n\t\t\t\teach(dom.select(name), function(node, i) {\n\t\t\t\t\tif (node == element)\n\t\t\t\t\t\tindex = i;\n\t\t\t\t});\n\n\t\t\t\treturn index;\n\t\t\t};\n\n\t\t\tif (type == 2) {\n\t\t\t\tfunction getLocation() {\n\t\t\t\t\tvar rng = t.getRng(true), root = dom.getRoot(), bookmark = {};\n\n\t\t\t\t\tfunction getPoint(rng, start) {\n\t\t\t\t\t\tvar container = rng[start ? 'startContainer' : 'endContainer'],\n\t\t\t\t\t\t\toffset = rng[start ? 'startOffset' : 'endOffset'], point = [], node, childNodes, after = 0;\n\n\t\t\t\t\t\tif (container.nodeType == 3) {\n\t\t\t\t\t\t\tif (normalized) {\n\t\t\t\t\t\t\t\tfor (node = container.previousSibling; node && node.nodeType == 3; node = node.previousSibling)\n\t\t\t\t\t\t\t\t\toffset += node.nodeValue.length;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tpoint.push(offset);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tchildNodes = container.childNodes;\n\n\t\t\t\t\t\t\tif (offset >= childNodes.length && childNodes.length) {\n\t\t\t\t\t\t\t\tafter = 1;\n\t\t\t\t\t\t\t\toffset = Math.max(0, childNodes.length - 1);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tpoint.push(t.dom.nodeIndex(childNodes[offset], normalized) + after);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfor (; container && container != root; container = container.parentNode)\n\t\t\t\t\t\t\tpoint.push(t.dom.nodeIndex(container, normalized));\n\n\t\t\t\t\t\treturn point;\n\t\t\t\t\t};\n\n\t\t\t\t\tbookmark.start = getPoint(rng, true);\n\n\t\t\t\t\tif (!t.isCollapsed())\n\t\t\t\t\t\tbookmark.end = getPoint(rng);\n\n\t\t\t\t\treturn bookmark;\n\t\t\t\t};\n\n\t\t\t\tif (t.tridentSel)\n\t\t\t\t\treturn t.tridentSel.getBookmark(type);\n\n\t\t\t\treturn getLocation();\n\t\t\t}\n\n\t\t\t// Handle simple range\n\t\t\tif (type)\n\t\t\t\treturn {rng : t.getRng()};\n\n\t\t\trng = t.getRng();\n\t\t\tid = dom.uniqueId();\n\t\t\tcollapsed = tinyMCE.activeEditor.selection.isCollapsed();\n\t\t\tstyles = 'overflow:hidden;line-height:0px';\n\n\t\t\t// Explorer method\n\t\t\tif (rng.duplicate || rng.item) {\n\t\t\t\t// Text selection\n\t\t\t\tif (!rng.item) {\n\t\t\t\t\trng2 = rng.duplicate();\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\t// Insert start marker\n\t\t\t\t\t\trng.collapse();\n\t\t\t\t\t\trng.pasteHTML('<span data-mce-type=\"bookmark\" id=\"' + id + '_start\" style=\"' + styles + '\">' + chr + '</span>');\n\n\t\t\t\t\t\t// Insert end marker\n\t\t\t\t\t\tif (!collapsed) {\n\t\t\t\t\t\t\trng2.collapse(false);\n\n\t\t\t\t\t\t\t// Detect the empty space after block elements in IE and move the end back one character <p></p>] becomes <p>]</p>\n\t\t\t\t\t\t\trng.moveToElementText(rng2.parentElement());\n\t\t\t\t\t\t\tif (rng.compareEndPoints('StartToEnd', rng2) == 0)\n\t\t\t\t\t\t\t\trng2.move('character', -1);\n\n\t\t\t\t\t\t\trng2.pasteHTML('<span data-mce-type=\"bookmark\" id=\"' + id + '_end\" style=\"' + styles + '\">' + chr + '</span>');\n\t\t\t\t\t\t}\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// IE might throw unspecified error so lets ignore it\n\t\t\t\t\t\treturn null;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\t// Control selection\n\t\t\t\t\telement = rng.item(0);\n\t\t\t\t\tname = element.nodeName;\n\n\t\t\t\t\treturn {name : name, index : findIndex(name, element)};\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\telement = t.getNode();\n\t\t\t\tname = element.nodeName;\n\t\t\t\tif (name == 'IMG')\n\t\t\t\t\treturn {name : name, index : findIndex(name, element)};\n\n\t\t\t\t// W3C method\n\t\t\t\trng2 = rng.cloneRange();\n\n\t\t\t\t// Insert end marker\n\t\t\t\tif (!collapsed) {\n\t\t\t\t\trng2.collapse(false);\n\t\t\t\t\trng2.insertNode(dom.create('span', {'data-mce-type' : \"bookmark\", id : id + '_end', style : styles}, chr));\n\t\t\t\t}\n\n\t\t\t\trng.collapse(true);\n\t\t\t\trng.insertNode(dom.create('span', {'data-mce-type' : \"bookmark\", id : id + '_start', style : styles}, chr));\n\t\t\t}\n\n\t\t\tt.moveToBookmark({id : id, keep : 1});\n\n\t\t\treturn {id : id};\n\t\t},\n\n\t\tmoveToBookmark : function(bookmark) {\n\t\t\tvar t = this, dom = t.dom, marker1, marker2, rng, root, startContainer, endContainer, startOffset, endOffset;\n\n\t\t\tif (bookmark) {\n\t\t\t\tif (bookmark.start) {\n\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\troot = dom.getRoot();\n\n\t\t\t\t\tfunction setEndPoint(start) {\n\t\t\t\t\t\tvar point = bookmark[start ? 'start' : 'end'], i, node, offset, children;\n\n\t\t\t\t\t\tif (point) {\n\t\t\t\t\t\t\toffset = point[0];\n\n\t\t\t\t\t\t\t// Find container node\n\t\t\t\t\t\t\tfor (node = root, i = point.length - 1; i >= 1; i--) {\n\t\t\t\t\t\t\t\tchildren = node.childNodes;\n\n\t\t\t\t\t\t\t\tif (point[i] > children.length - 1)\n\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\tnode = children[point[i]];\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Move text offset to best suitable location\n\t\t\t\t\t\t\tif (node.nodeType === 3)\n\t\t\t\t\t\t\t\toffset = Math.min(point[0], node.nodeValue.length);\n\n\t\t\t\t\t\t\t// Move element offset to best suitable location\n\t\t\t\t\t\t\tif (node.nodeType === 1)\n\t\t\t\t\t\t\t\toffset = Math.min(point[0], node.childNodes.length);\n\n\t\t\t\t\t\t\t// Set offset within container node\n\t\t\t\t\t\t\tif (start)\n\t\t\t\t\t\t\t\trng.setStart(node, offset);\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\trng.setEnd(node, offset);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t};\n\n\t\t\t\t\tif (t.tridentSel)\n\t\t\t\t\t\treturn t.tridentSel.moveToBookmark(bookmark);\n\n\t\t\t\t\tif (setEndPoint(true) && setEndPoint()) {\n\t\t\t\t\t\tt.setRng(rng);\n\t\t\t\t\t}\n\t\t\t\t} else if (bookmark.id) {\n\t\t\t\t\tfunction restoreEndPoint(suffix) {\n\t\t\t\t\t\tvar marker = dom.get(bookmark.id + '_' + suffix), node, idx, next, prev, keep = bookmark.keep;\n\n\t\t\t\t\t\tif (marker) {\n\t\t\t\t\t\t\tnode = marker.parentNode;\n\n\t\t\t\t\t\t\tif (suffix == 'start') {\n\t\t\t\t\t\t\t\tif (!keep) {\n\t\t\t\t\t\t\t\t\tidx = dom.nodeIndex(marker);\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tnode = marker.firstChild;\n\t\t\t\t\t\t\t\t\tidx = 1;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tstartContainer = endContainer = node;\n\t\t\t\t\t\t\t\tstartOffset = endOffset = idx;\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tif (!keep) {\n\t\t\t\t\t\t\t\t\tidx = dom.nodeIndex(marker);\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tnode = marker.firstChild;\n\t\t\t\t\t\t\t\t\tidx = 1;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tendContainer = node;\n\t\t\t\t\t\t\t\tendOffset = idx;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (!keep) {\n\t\t\t\t\t\t\t\tprev = marker.previousSibling;\n\t\t\t\t\t\t\t\tnext = marker.nextSibling;\n\n\t\t\t\t\t\t\t\t// Remove all marker text nodes\n\t\t\t\t\t\t\t\teach(tinymce.grep(marker.childNodes), function(node) {\n\t\t\t\t\t\t\t\t\tif (node.nodeType == 3)\n\t\t\t\t\t\t\t\t\t\tnode.nodeValue = node.nodeValue.replace(/\\uFEFF/g, '');\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\t// Remove marker but keep children if for example contents where inserted into the marker\n\t\t\t\t\t\t\t\t// Also remove duplicated instances of the marker for example by a split operation or by WebKit auto split on paste feature\n\t\t\t\t\t\t\t\twhile (marker = dom.get(bookmark.id + '_' + suffix))\n\t\t\t\t\t\t\t\t\tdom.remove(marker, 1);\n\n\t\t\t\t\t\t\t\t// If siblings are text nodes then merge them unless it's Opera since it some how removes the node\n\t\t\t\t\t\t\t\t// and we are sniffing since adding a lot of detection code for a browser with 3% of the market isn't worth the effort. Sorry, Opera but it's just a fact\n\t\t\t\t\t\t\t\tif (prev && next && prev.nodeType == next.nodeType && prev.nodeType == 3 && !tinymce.isOpera) {\n\t\t\t\t\t\t\t\t\tidx = prev.nodeValue.length;\n\t\t\t\t\t\t\t\t\tprev.appendData(next.nodeValue);\n\t\t\t\t\t\t\t\t\tdom.remove(next);\n\n\t\t\t\t\t\t\t\t\tif (suffix == 'start') {\n\t\t\t\t\t\t\t\t\t\tstartContainer = endContainer = prev;\n\t\t\t\t\t\t\t\t\t\tstartOffset = endOffset = idx;\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tendContainer = prev;\n\t\t\t\t\t\t\t\t\t\tendOffset = idx;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\t\tfunction addBogus(node) {\n\t\t\t\t\t\t// Adds a bogus BR element for empty block elements or just a space on IE since it renders BR elements incorrectly\n\t\t\t\t\t\tif (dom.isBlock(node) && !node.innerHTML)\n\t\t\t\t\t\t\tnode.innerHTML = !isIE ? '<br data-mce-bogus=\"1\" />' : ' ';\n\n\t\t\t\t\t\treturn node;\n\t\t\t\t\t};\n\n\t\t\t\t\t// Restore start/end points\n\t\t\t\t\trestoreEndPoint('start');\n\t\t\t\t\trestoreEndPoint('end');\n\n\t\t\t\t\tif (startContainer) {\n\t\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\t\trng.setStart(addBogus(startContainer), startOffset);\n\t\t\t\t\t\trng.setEnd(addBogus(endContainer), endOffset);\n\t\t\t\t\t\tt.setRng(rng);\n\t\t\t\t\t}\n\t\t\t\t} else if (bookmark.name) {\n\t\t\t\t\tt.select(dom.select(bookmark.name)[bookmark.index]);\n\t\t\t\t} else if (bookmark.rng)\n\t\t\t\t\tt.setRng(bookmark.rng);\n\t\t\t}\n\t\t},\n\n\t\tselect : function(node, content) {\n\t\t\tvar t = this, dom = t.dom, rng = dom.createRng(), idx;\n\n\t\t\tif (node) {\n\t\t\t\tidx = dom.nodeIndex(node);\n\t\t\t\trng.setStart(node.parentNode, idx);\n\t\t\t\trng.setEnd(node.parentNode, idx + 1);\n\n\t\t\t\t// Find first/last text node or BR element\n\t\t\t\tif (content) {\n\t\t\t\t\tfunction setPoint(node, start) {\n\t\t\t\t\t\tvar walker = new tinymce.dom.TreeWalker(node, node);\n\n\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t// Text node\n\t\t\t\t\t\t\tif (node.nodeType == 3 && tinymce.trim(node.nodeValue).length != 0) {\n\t\t\t\t\t\t\t\tif (start)\n\t\t\t\t\t\t\t\t\trng.setStart(node, 0);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\trng.setEnd(node, node.nodeValue.length);\n\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// BR element\n\t\t\t\t\t\t\tif (node.nodeName == 'BR') {\n\t\t\t\t\t\t\t\tif (start)\n\t\t\t\t\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\trng.setEndBefore(node);\n\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} while (node = (start ? walker.next() : walker.prev()));\n\t\t\t\t\t};\n\n\t\t\t\t\tsetPoint(node, 1);\n\t\t\t\t\tsetPoint(node);\n\t\t\t\t}\n\n\t\t\t\tt.setRng(rng);\n\t\t\t}\n\n\t\t\treturn node;\n\t\t},\n\n\t\tisCollapsed : function() {\n\t\t\tvar t = this, r = t.getRng(), s = t.getSel();\n\n\t\t\tif (!r || r.item)\n\t\t\t\treturn false;\n\n\t\t\tif (r.compareEndPoints)\n\t\t\t\treturn r.compareEndPoints('StartToEnd', r) === 0;\n\n\t\t\treturn !s || r.collapsed;\n\t\t},\n\n\t\tcollapse : function(to_start) {\n\t\t\tvar self = this, rng = self.getRng(), node;\n\n\t\t\t// Control range on IE\n\t\t\tif (rng.item) {\n\t\t\t\tnode = rng.item(0);\n\t\t\t\trng = self.win.document.body.createTextRange();\n\t\t\t\trng.moveToElementText(node);\n\t\t\t}\n\n\t\t\trng.collapse(!!to_start);\n\t\t\tself.setRng(rng);\n\t\t},\n\n\t\tgetSel : function() {\n\t\t\tvar t = this, w = this.win;\n\n\t\t\treturn w.getSelection ? w.getSelection() : w.document.selection;\n\t\t},\n\n\t\tgetRng : function(w3c) {\n\t\t\tvar t = this, s, r, elm, doc = t.win.document;\n\n\t\t\t// Found tridentSel object then we need to use that one\n\t\t\tif (w3c && t.tridentSel)\n\t\t\t\treturn t.tridentSel.getRangeAt(0);\n\n\t\t\ttry {\n\t\t\t\tif (s = t.getSel())\n\t\t\t\t\tr = s.rangeCount > 0 ? s.getRangeAt(0) : (s.createRange ? s.createRange() : doc.createRange());\n\t\t\t} catch (ex) {\n\t\t\t\t// IE throws unspecified error here if TinyMCE is placed in a frame/iframe\n\t\t\t}\n\n\t\t\t// We have W3C ranges and it's IE then fake control selection since IE9 doesn't handle that correctly yet\n\t\t\tif (tinymce.isIE && r && r.setStart && doc.selection.createRange().item) {\n\t\t\t\telm = doc.selection.createRange().item(0);\n\t\t\t\tr = doc.createRange();\n\t\t\t\tr.setStartBefore(elm);\n\t\t\t\tr.setEndAfter(elm);\n\t\t\t}\n\n\t\t\t// No range found then create an empty one\n\t\t\t// This can occur when the editor is placed in a hidden container element on Gecko\n\t\t\t// Or on IE when there was an exception\n\t\t\tif (!r)\n\t\t\t\tr = doc.createRange ? doc.createRange() : doc.body.createTextRange();\n\n\t\t\tif (t.selectedRange && t.explicitRange) {\n\t\t\t\tif (r.compareBoundaryPoints(r.START_TO_START, t.selectedRange) === 0 && r.compareBoundaryPoints(r.END_TO_END, t.selectedRange) === 0) {\n\t\t\t\t\t// Safari, Opera and Chrome only ever select text which causes the range to change.\n\t\t\t\t\t// This lets us use the originally set range if the selection hasn't been changed by the user.\n\t\t\t\t\tr = t.explicitRange;\n\t\t\t\t} else {\n\t\t\t\t\tt.selectedRange = null;\n\t\t\t\t\tt.explicitRange = null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn r;\n\t\t},\n\n\t\tsetRng : function(r) {\n\t\t\tvar s, t = this;\n\t\t\t\n\t\t\tif (!t.tridentSel) {\n\t\t\t\ts = t.getSel();\n\n\t\t\t\tif (s) {\n\t\t\t\t\tt.explicitRange = r;\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\ts.removeAllRanges();\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// IE9 might throw errors here don't know why\n\t\t\t\t\t}\n\n\t\t\t\t\ts.addRange(r);\n\t\t\t\t\tt.selectedRange = s.getRangeAt(0);\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Is W3C Range\n\t\t\t\tif (r.cloneRange) {\n\t\t\t\t\tt.tridentSel.addRange(r);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Is IE specific range\n\t\t\t\ttry {\n\t\t\t\t\tr.select();\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Needed for some odd IE bug #1843306\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tsetNode : function(n) {\n\t\t\tvar t = this;\n\n\t\t\tt.setContent(t.dom.getOuterHTML(n));\n\n\t\t\treturn n;\n\t\t},\n\n\t\tgetNode : function() {\n\t\t\tvar t = this, rng = t.getRng(), sel = t.getSel(), elm, start = rng.startContainer, end = rng.endContainer;\n\n\t\t\t// Range maybe lost after the editor is made visible again\n\t\t\tif (!rng)\n\t\t\t\treturn t.dom.getRoot();\n\n\t\t\tif (rng.setStart) {\n\t\t\t\telm = rng.commonAncestorContainer;\n\n\t\t\t\t// Handle selection a image or other control like element such as anchors\n\t\t\t\tif (!rng.collapsed) {\n\t\t\t\t\tif (rng.startContainer == rng.endContainer) {\n\t\t\t\t\t\tif (rng.endOffset - rng.startOffset < 2) {\n\t\t\t\t\t\t\tif (rng.startContainer.hasChildNodes())\n\t\t\t\t\t\t\t\telm = rng.startContainer.childNodes[rng.startOffset];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// If the anchor node is a element instead of a text node then return this element\n\t\t\t\t\t//if (tinymce.isWebKit && sel.anchorNode && sel.anchorNode.nodeType == 1) \n\t\t\t\t\t//\treturn sel.anchorNode.childNodes[sel.anchorOffset];\n\n\t\t\t\t\t// Handle cases where the selection is immediately wrapped around a node and return that node instead of it's parent.\n\t\t\t\t\t// This happens when you double click an underlined word in FireFox.\n\t\t\t\t\tif (start.nodeType === 3 && end.nodeType === 3) {\n\t\t\t\t\t\tfunction skipEmptyTextNodes(n, forwards) {\n\t\t\t\t\t\t\tvar orig = n;\n\t\t\t\t\t\t\twhile (n && n.nodeType === 3 && n.length === 0) {\n\t\t\t\t\t\t\t\tn = forwards ? n.nextSibling : n.previousSibling;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn n || orig;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (start.length === rng.startOffset) {\n\t\t\t\t\t\t\tstart = skipEmptyTextNodes(start.nextSibling, true);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tstart = start.parentNode;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (rng.endOffset === 0) {\n\t\t\t\t\t\t\tend = skipEmptyTextNodes(end.previousSibling, false);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tend = end.parentNode;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (start && start === end)\n\t\t\t\t\t\t\treturn start;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (elm && elm.nodeType == 3)\n\t\t\t\t\treturn elm.parentNode;\n\n\t\t\t\treturn elm;\n\t\t\t}\n\n\t\t\treturn rng.item ? rng.item(0) : rng.parentElement();\n\t\t},\n\n\t\tgetSelectedBlocks : function(st, en) {\n\t\t\tvar t = this, dom = t.dom, sb, eb, n, bl = [];\n\n\t\t\tsb = dom.getParent(st || t.getStart(), dom.isBlock);\n\t\t\teb = dom.getParent(en || t.getEnd(), dom.isBlock);\n\n\t\t\tif (sb)\n\t\t\t\tbl.push(sb);\n\n\t\t\tif (sb && eb && sb != eb) {\n\t\t\t\tn = sb;\n\n\t\t\t\tvar walker = new tinymce.dom.TreeWalker(sb, dom.getRoot());\n\t\t\t\twhile ((n = walker.next()) && n != eb) {\n\t\t\t\t\tif (dom.isBlock(n))\n\t\t\t\t\t\tbl.push(n);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (eb && sb != eb)\n\t\t\t\tbl.push(eb);\n\n\t\t\treturn bl;\n\t\t},\n\n\t\tnormalize : function() {\n\t\t\tvar self = this, rng, normalized;\n\n\t\t\t// Normalize only on non IE browsers for now\n\t\t\tif (tinymce.isIE)\n\t\t\t\treturn;\n\n\t\t\tfunction normalizeEndPoint(start) {\n\t\t\t\tvar container, offset, walker, dom = self.dom, body = dom.getRoot(), node;\n\n\t\t\t\tcontainer = rng[(start ? 'start' : 'end') + 'Container'];\n\t\t\t\toffset = rng[(start ? 'start' : 'end') + 'Offset'];\n\n\t\t\t\t// If the container is a document move it to the body element\n\t\t\t\tif (container.nodeType === 9) {\n\t\t\t\t\tcontainer = container.body;\n\t\t\t\t\toffset = 0;\n\t\t\t\t}\n\n\t\t\t\t// If the container is body try move it into the closest text node or position\n\t\t\t\t// TODO: Add more logic here to handle element selection cases\n\t\t\t\tif (container === body) {\n\t\t\t\t\t// Resolve the index\n\t\t\t\t\tif (container.hasChildNodes()) {\n\t\t\t\t\t\tcontainer = container.childNodes[Math.min(!start && offset > 0 ? offset - 1 : offset, container.childNodes.length - 1)];\n\t\t\t\t\t\toffset = 0;\n\n\t\t\t\t\t\t// Don't walk into elements that doesn't have any child nodes like a IMG\n\t\t\t\t\t\tif (container.hasChildNodes()) {\n\t\t\t\t\t\t\t// Walk the DOM to find a text node to place the caret at or a BR\n\t\t\t\t\t\t\tnode = container;\n\t\t\t\t\t\t\twalker = new tinymce.dom.TreeWalker(container, body);\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\t// Found a text node use that position\n\t\t\t\t\t\t\t\tif (node.nodeType === 3) {\n\t\t\t\t\t\t\t\t\toffset = start ? 0 : node.nodeValue.length - 1;\n\t\t\t\t\t\t\t\t\tcontainer = node;\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Found a BR element that we can place the caret before\n\t\t\t\t\t\t\t\tif (node.nodeName === 'BR') {\n\t\t\t\t\t\t\t\t\toffset = dom.nodeIndex(node);\n\t\t\t\t\t\t\t\t\tcontainer = node.parentNode;\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} while (node = (start ? walker.next() : walker.prev()));\n\n\t\t\t\t\t\t\tnormalized = true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Set endpoint if it was normalized\n\t\t\t\tif (normalized)\n\t\t\t\t\trng['set' + (start ? 'Start' : 'End')](container, offset);\n\t\t\t};\n\n\t\t\trng = self.getRng();\n\n\t\t\t// Normalize the end points\n\t\t\tnormalizeEndPoint(true);\n\t\t\t\n\t\t\tif (rng.collapsed)\n\t\t\t\tnormalizeEndPoint();\n\n\t\t\t// Set the selection if it was normalized\n\t\t\tif (normalized) {\n\t\t\t\t//console.log(self.dom.dumpRng(rng));\n\t\t\t\tself.setRng(rng);\n\t\t\t}\n\t\t},\n\n\t\tdestroy : function(s) {\n\t\t\tvar t = this;\n\n\t\t\tt.win = null;\n\n\t\t\t// Manual destroy then remove unload handler\n\t\t\tif (!s)\n\t\t\t\ttinymce.removeUnload(t.destroy);\n\t\t},\n\n\t\t// IE has an issue where you can't select/move the caret by clicking outside the body if the document is in standards mode\n\t\t_fixIESelection : function() {\n\t\t\tvar dom = this.dom, doc = dom.doc, body = doc.body, started, startRng, htmlElm;\n\n\t\t\t// Make HTML element unselectable since we are going to handle selection by hand\n\t\t\tdoc.documentElement.unselectable = true;\n\n\t\t\t// Return range from point or null if it failed\n\t\t\tfunction rngFromPoint(x, y) {\n\t\t\t\tvar rng = body.createTextRange();\n\n\t\t\t\ttry {\n\t\t\t\t\trng.moveToPoint(x, y);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// IE sometimes throws and exception, so lets just ignore it\n\t\t\t\t\trng = null;\n\t\t\t\t}\n\n\t\t\t\treturn rng;\n\t\t\t};\n\n\t\t\t// Fires while the selection is changing\n\t\t\tfunction selectionChange(e) {\n\t\t\t\tvar pointRng;\n\n\t\t\t\t// Check if the button is down or not\n\t\t\t\tif (e.button) {\n\t\t\t\t\t// Create range from mouse position\n\t\t\t\t\tpointRng = rngFromPoint(e.x, e.y);\n\n\t\t\t\t\tif (pointRng) {\n\t\t\t\t\t\t// Check if pointRange is before/after selection then change the endPoint\n\t\t\t\t\t\tif (pointRng.compareEndPoints('StartToStart', startRng) > 0)\n\t\t\t\t\t\t\tpointRng.setEndPoint('StartToStart', startRng);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tpointRng.setEndPoint('EndToEnd', startRng);\n\n\t\t\t\t\t\tpointRng.select();\n\t\t\t\t\t}\n\t\t\t\t} else\n\t\t\t\t\tendSelection();\n\t\t\t}\n\n\t\t\t// Removes listeners\n\t\t\tfunction endSelection() {\n\t\t\t\tvar rng = doc.selection.createRange();\n\n\t\t\t\t// If the range is collapsed then use the last start range\n\t\t\t\tif (startRng && !rng.item && rng.compareEndPoints('StartToEnd', rng) === 0)\n\t\t\t\t\tstartRng.select();\n\n\t\t\t\tdom.unbind(doc, 'mouseup', endSelection);\n\t\t\t\tdom.unbind(doc, 'mousemove', selectionChange);\n\t\t\t\tstartRng = started = 0;\n\t\t\t};\n\n\t\t\t// Detect when user selects outside BODY\n\t\t\tdom.bind(doc, ['mousedown', 'contextmenu'], function(e) {\n\t\t\t\tif (e.target.nodeName === 'HTML') {\n\t\t\t\t\tif (started)\n\t\t\t\t\t\tendSelection();\n\n\t\t\t\t\t// Detect vertical scrollbar, since IE will fire a mousedown on the scrollbar and have target set as HTML\n\t\t\t\t\thtmlElm = doc.documentElement;\n\t\t\t\t\tif (htmlElm.scrollHeight > htmlElm.clientHeight)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tstarted = 1;\n\t\t\t\t\t// Setup start position\n\t\t\t\t\tstartRng = rngFromPoint(e.x, e.y);\n\t\t\t\t\tif (startRng) {\n\t\t\t\t\t\t// Listen for selection change events\n\t\t\t\t\t\tdom.bind(doc, 'mouseup', endSelection);\n\t\t\t\t\t\tdom.bind(doc, 'mousemove', selectionChange);\n\n\t\t\t\t\t\tdom.win.focus();\n\t\t\t\t\t\tstartRng.select();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\ttinymce.dom.Serializer = function(settings, dom, schema) {\n\t\tvar onPreProcess, onPostProcess, isIE = tinymce.isIE, each = tinymce.each, htmlParser;\n\n\t\t// Support the old apply_source_formatting option\n\t\tif (!settings.apply_source_formatting)\n\t\t\tsettings.indent = false;\n\n\t\tsettings.remove_trailing_brs = true;\n\n\t\t// Default DOM and Schema if they are undefined\n\t\tdom = dom || tinymce.DOM;\n\t\tschema = schema || new tinymce.html.Schema(settings);\n\t\tsettings.entity_encoding = settings.entity_encoding || 'named';\n\n\t\tonPreProcess = new tinymce.util.Dispatcher(self);\n\n\t\tonPostProcess = new tinymce.util.Dispatcher(self);\n\n\t\thtmlParser = new tinymce.html.DomParser(settings, schema);\n\n\t\t// Convert move data-mce-src, data-mce-href and data-mce-style into nodes or process them if needed\n\t\thtmlParser.addAttributeFilter('src,href,style', function(nodes, name) {\n\t\t\tvar i = nodes.length, node, value, internalName = 'data-mce-' + name, urlConverter = settings.url_converter, urlConverterScope = settings.url_converter_scope, undef;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\n\t\t\t\tvalue = node.attributes.map[internalName];\n\t\t\t\tif (value !== undef) {\n\t\t\t\t\t// Set external name to internal value and remove internal\n\t\t\t\t\tnode.attr(name, value.length > 0 ? value : null);\n\t\t\t\t\tnode.attr(internalName, null);\n\t\t\t\t} else {\n\t\t\t\t\t// No internal attribute found then convert the value we have in the DOM\n\t\t\t\t\tvalue = node.attributes.map[name];\n\n\t\t\t\t\tif (name === \"style\")\n\t\t\t\t\t\tvalue = dom.serializeStyle(dom.parseStyle(value), node.name);\n\t\t\t\t\telse if (urlConverter)\n\t\t\t\t\t\tvalue = urlConverter.call(urlConverterScope, value, name, node.name);\n\n\t\t\t\t\tnode.attr(name, value.length > 0 ? value : null);\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\t// Remove internal classes mceItem<..>\n\t\thtmlParser.addAttributeFilter('class', function(nodes, name) {\n\t\t\tvar i = nodes.length, node, value;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\t\t\t\tvalue = node.attr('class').replace(/\\s*mce(Item\\w+|Selected)\\s*/g, '');\n\t\t\t\tnode.attr('class', value.length > 0 ? value : null);\n\t\t\t}\n\t\t});\n\n\t\t// Remove bookmark elements\n\t\thtmlParser.addAttributeFilter('data-mce-type', function(nodes, name, args) {\n\t\t\tvar i = nodes.length, node;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\n\t\t\t\tif (node.attributes.map['data-mce-type'] === 'bookmark' && !args.cleanup)\n\t\t\t\t\tnode.remove();\n\t\t\t}\n\t\t});\n\n\t\t// Force script into CDATA sections and remove the mce- prefix also add comments around styles\n\t\thtmlParser.addNodeFilter('script,style', function(nodes, name) {\n\t\t\tvar i = nodes.length, node, value;\n\n\t\t\tfunction trim(value) {\n\t\t\t\treturn value.replace(/(<!--\\[CDATA\\[|\\]\\]-->)/g, '\\n')\n\t\t\t\t\t\t.replace(/^[\\r\\n]*|[\\r\\n]*$/g, '')\n\t\t\t\t\t\t.replace(/^\\s*(\\/\\/\\s*<!--|\\/\\/\\s*<!\\[CDATA\\[|<!--|<!\\[CDATA\\[)[\\r\\n]*/g, '')\n\t\t\t\t\t\t.replace(/\\s*(\\/\\/\\s*\\]\\]>|\\/\\/\\s*-->|\\]\\]>|-->|\\]\\]-->)\\s*$/g, '');\n\t\t\t};\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\t\t\t\tvalue = node.firstChild ? node.firstChild.value : '';\n\n\t\t\t\tif (name === \"script\") {\n\t\t\t\t\t// Remove mce- prefix from script elements\n\t\t\t\t\tnode.attr('type', (node.attr('type') || 'text/javascript').replace(/^mce\\-/, ''));\n\n\t\t\t\t\tif (value.length > 0)\n\t\t\t\t\t\tnode.firstChild.value = '// <![CDATA[\\n' + trim(value) + '\\n// ]]>';\n\t\t\t\t} else {\n\t\t\t\t\tif (value.length > 0)\n\t\t\t\t\t\tnode.firstChild.value = '<!--\\n' + trim(value) + '\\n-->';\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\t// Convert comments to cdata and handle protected comments\n\t\thtmlParser.addNodeFilter('#comment', function(nodes, name) {\n\t\t\tvar i = nodes.length, node;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\n\t\t\t\tif (node.value.indexOf('[CDATA[') === 0) {\n\t\t\t\t\tnode.name = '#cdata';\n\t\t\t\t\tnode.type = 4;\n\t\t\t\t\tnode.value = node.value.replace(/^\\[CDATA\\[|\\]\\]$/g, '');\n\t\t\t\t} else if (node.value.indexOf('mce:protected ') === 0) {\n\t\t\t\t\tnode.name = \"#text\";\n\t\t\t\t\tnode.type = 3;\n\t\t\t\t\tnode.raw = true;\n\t\t\t\t\tnode.value = unescape(node.value).substr(14);\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\thtmlParser.addNodeFilter('xml:namespace,input', function(nodes, name) {\n\t\t\tvar i = nodes.length, node;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\t\t\t\tif (node.type === 7)\n\t\t\t\t\tnode.remove();\n\t\t\t\telse if (node.type === 1) {\n\t\t\t\t\tif (name === \"input\" && !(\"type\" in node.attributes.map))\n\t\t\t\t\t\tnode.attr('type', 'text');\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\t// Fix list elements, TODO: Replace this later\n\t\tif (settings.fix_list_elements) {\n\t\t\thtmlParser.addNodeFilter('ul,ol', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node, parentNode;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tparentNode = node.parent;\n\n\t\t\t\t\tif (parentNode.name === 'ul' || parentNode.name === 'ol') {\n\t\t\t\t\t\tif (node.prev && node.prev.name === 'li') {\n\t\t\t\t\t\t\tnode.prev.append(node);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\n\t\t// Remove internal data attributes\n\t\thtmlParser.addAttributeFilter('data-mce-src,data-mce-href,data-mce-style', function(nodes, name) {\n\t\t\tvar i = nodes.length;\n\n\t\t\twhile (i--) {\n\t\t\t\tnodes[i].attr(name, null);\n\t\t\t}\n\t\t});\n\n\t\t// Return public methods\n\t\treturn {\n\t\t\tschema : schema,\n\n\t\t\taddNodeFilter : htmlParser.addNodeFilter,\n\n\t\t\taddAttributeFilter : htmlParser.addAttributeFilter,\n\n\t\t\tonPreProcess : onPreProcess,\n\n\t\t\tonPostProcess : onPostProcess,\n\n\t\t\tserialize : function(node, args) {\n\t\t\t\tvar impl, doc, oldDoc, htmlSerializer, content;\n\n\t\t\t\t// Explorer won't clone contents of script and style and the\n\t\t\t\t// selected index of select elements are cleared on a clone operation.\n\t\t\t\tif (isIE && dom.select('script,style,select,map').length > 0) {\n\t\t\t\t\tcontent = node.innerHTML;\n\t\t\t\t\tnode = node.cloneNode(false);\n\t\t\t\t\tdom.setHTML(node, content);\n\t\t\t\t} else\n\t\t\t\t\tnode = node.cloneNode(true);\n\n\t\t\t\t// Nodes needs to be attached to something in WebKit/Opera\n\t\t\t\t// Older builds of Opera crashes if you attach the node to an document created dynamically\n\t\t\t\t// and since we can't feature detect a crash we need to sniff the acutal build number\n\t\t\t\t// This fix will make DOM ranges and make Sizzle happy!\n\t\t\t\timpl = node.ownerDocument.implementation;\n\t\t\t\tif (impl.createHTMLDocument) {\n\t\t\t\t\t// Create an empty HTML document\n\t\t\t\t\tdoc = impl.createHTMLDocument(\"\");\n\n\t\t\t\t\t// Add the element or it's children if it's a body element to the new document\n\t\t\t\t\teach(node.nodeName == 'BODY' ? node.childNodes : [node], function(node) {\n\t\t\t\t\t\tdoc.body.appendChild(doc.importNode(node, true));\n\t\t\t\t\t});\n\n\t\t\t\t\t// Grab first child or body element for serialization\n\t\t\t\t\tif (node.nodeName != 'BODY')\n\t\t\t\t\t\tnode = doc.body.firstChild;\n\t\t\t\t\telse\n\t\t\t\t\t\tnode = doc.body;\n\n\t\t\t\t\t// set the new document in DOMUtils so createElement etc works\n\t\t\t\t\toldDoc = dom.doc;\n\t\t\t\t\tdom.doc = doc;\n\t\t\t\t}\n\n\t\t\t\targs = args || {};\n\t\t\t\targs.format = args.format || 'html';\n\n\t\t\t\t// Pre process\n\t\t\t\tif (!args.no_events) {\n\t\t\t\t\targs.node = node;\n\t\t\t\t\tonPreProcess.dispatch(self, args);\n\t\t\t\t}\n\n\t\t\t\t// Setup serializer\n\t\t\t\thtmlSerializer = new tinymce.html.Serializer(settings, schema);\n\n\t\t\t\t// Parse and serialize HTML\n\t\t\t\targs.content = htmlSerializer.serialize(\n\t\t\t\t\thtmlParser.parse(args.getInner ? node.innerHTML : tinymce.trim(dom.getOuterHTML(node), args), args)\n\t\t\t\t);\n\n\t\t\t\t// Replace all BOM characters for now until we can find a better solution\n\t\t\t\tif (!args.cleanup)\n\t\t\t\t\targs.content = args.content.replace(/\\uFEFF|\\u200B/g, '');\n\n\t\t\t\t// Post process\n\t\t\t\tif (!args.no_events)\n\t\t\t\t\tonPostProcess.dispatch(self, args);\n\n\t\t\t\t// Restore the old document if it was changed\n\t\t\t\tif (oldDoc)\n\t\t\t\t\tdom.doc = oldDoc;\n\n\t\t\t\targs.node = null;\n\n\t\t\t\treturn args.content;\n\t\t\t},\n\n\t\t\taddRules : function(rules) {\n\t\t\t\tschema.addValidElements(rules);\n\t\t\t},\n\n\t\t\tsetRules : function(rules) {\n\t\t\t\tschema.setValidElements(rules);\n\t\t\t}\n\t\t};\n\t};\n})(tinymce);\n(function(tinymce) {\n\ttinymce.dom.ScriptLoader = function(settings) {\n\t\tvar QUEUED = 0,\n\t\t\tLOADING = 1,\n\t\t\tLOADED = 2,\n\t\t\tstates = {},\n\t\t\tqueue = [],\n\t\t\tscriptLoadedCallbacks = {},\n\t\t\tqueueLoadedCallbacks = [],\n\t\t\tloading = 0,\n\t\t\tundefined;\n\n\t\tfunction loadScript(url, callback) {\n\t\t\tvar t = this, dom = tinymce.DOM, elm, uri, loc, id;\n\n\t\t\t// Execute callback when script is loaded\n\t\t\tfunction done() {\n\t\t\t\tdom.remove(id);\n\n\t\t\t\tif (elm)\n\t\t\t\t\telm.onreadystatechange = elm.onload = elm = null;\n\n\t\t\t\tcallback();\n\t\t\t};\n\t\t\t\n\t\t\tfunction error() {\n\t\t\t\t// Report the error so it's easier for people to spot loading errors\n\t\t\t\tif (typeof(console) !== \"undefined\" && console.log)\n\t\t\t\t\tconsole.log(\"Failed to load: \" + url);\n\n\t\t\t\t// We can't mark it as done if there is a load error since\n\t\t\t\t// A) We don't want to produce 404 errors on the server and\n\t\t\t\t// B) the onerror event won't fire on all browsers.\n\t\t\t\t// done();\n\t\t\t};\n\n\t\t\tid = dom.uniqueId();\n\n\t\t\tif (tinymce.isIE6) {\n\t\t\t\turi = new tinymce.util.URI(url);\n\t\t\t\tloc = location;\n\n\t\t\t\t// If script is from same domain and we\n\t\t\t\t// use IE 6 then use XHR since it's more reliable\n\t\t\t\tif (uri.host == loc.hostname && uri.port == loc.port && (uri.protocol + ':') == loc.protocol && uri.protocol.toLowerCase() != 'file') {\n\t\t\t\t\ttinymce.util.XHR.send({\n\t\t\t\t\t\turl : tinymce._addVer(uri.getURI()),\n\t\t\t\t\t\tsuccess : function(content) {\n\t\t\t\t\t\t\t// Create new temp script element\n\t\t\t\t\t\t\tvar script = dom.create('script', {\n\t\t\t\t\t\t\t\ttype : 'text/javascript'\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t// Evaluate script in global scope\n\t\t\t\t\t\t\tscript.text = content;\n\t\t\t\t\t\t\tdocument.getElementsByTagName('head')[0].appendChild(script);\n\t\t\t\t\t\t\tdom.remove(script);\n\n\t\t\t\t\t\t\tdone();\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\n\t\t\t\t\t\terror : error\n\t\t\t\t\t});\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Create new script element\n\t\t\telm = dom.create('script', {\n\t\t\t\tid : id,\n\t\t\t\ttype : 'text/javascript',\n\t\t\t\tsrc : tinymce._addVer(url)\n\t\t\t});\n\n\t\t\t// Add onload listener for non IE browsers since IE9\n\t\t\t// fires onload event before the script is parsed and executed\n\t\t\tif (!tinymce.isIE)\n\t\t\t\telm.onload = done;\n\n\t\t\t// Add onerror event will get fired on some browsers but not all of them\n\t\t\telm.onerror = error;\n\n\t\t\t// Opera 9.60 doesn't seem to fire the onreadystate event at correctly\n\t\t\tif (!tinymce.isOpera) {\n\t\t\t\telm.onreadystatechange = function() {\n\t\t\t\t\tvar state = elm.readyState;\n\n\t\t\t\t\t// Loaded state is passed on IE 6 however there\n\t\t\t\t\t// are known issues with this method but we can't use\n\t\t\t\t\t// XHR in a cross domain loading\n\t\t\t\t\tif (state == 'complete' || state == 'loaded')\n\t\t\t\t\t\tdone();\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t// Most browsers support this feature so we report errors\n\t\t\t// for those at least to help users track their missing plugins etc\n\t\t\t// todo: Removed since it produced error if the document is unloaded by navigating away, re-add it as an option\n\t\t\t/*elm.onerror = function() {\n\t\t\t\talert('Failed to load: ' + url);\n\t\t\t};*/\n\n\t\t\t// Add script to document\n\t\t\t(document.getElementsByTagName('head')[0] || document.body).appendChild(elm);\n\t\t};\n\n\t\tthis.isDone = function(url) {\n\t\t\treturn states[url] == LOADED;\n\t\t};\n\n\t\tthis.markDone = function(url) {\n\t\t\tstates[url] = LOADED;\n\t\t};\n\n\t\tthis.add = this.load = function(url, callback, scope) {\n\t\t\tvar item, state = states[url];\n\n\t\t\t// Add url to load queue\n\t\t\tif (state == undefined) {\n\t\t\t\tqueue.push(url);\n\t\t\t\tstates[url] = QUEUED;\n\t\t\t}\n\n\t\t\tif (callback) {\n\t\t\t\t// Store away callback for later execution\n\t\t\t\tif (!scriptLoadedCallbacks[url])\n\t\t\t\t\tscriptLoadedCallbacks[url] = [];\n\n\t\t\t\tscriptLoadedCallbacks[url].push({\n\t\t\t\t\tfunc : callback,\n\t\t\t\t\tscope : scope || this\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\tthis.loadQueue = function(callback, scope) {\n\t\t\tthis.loadScripts(queue, callback, scope);\n\t\t};\n\n\t\tthis.loadScripts = function(scripts, callback, scope) {\n\t\t\tvar loadScripts;\n\n\t\t\tfunction execScriptLoadedCallbacks(url) {\n\t\t\t\t// Execute URL callback functions\n\t\t\t\ttinymce.each(scriptLoadedCallbacks[url], function(callback) {\n\t\t\t\t\tcallback.func.call(callback.scope);\n\t\t\t\t});\n\n\t\t\t\tscriptLoadedCallbacks[url] = undefined;\n\t\t\t};\n\n\t\t\tqueueLoadedCallbacks.push({\n\t\t\t\tfunc : callback,\n\t\t\t\tscope : scope || this\n\t\t\t});\n\n\t\t\tloadScripts = function() {\n\t\t\t\tvar loadingScripts = tinymce.grep(scripts);\n\n\t\t\t\t// Current scripts has been handled\n\t\t\t\tscripts.length = 0;\n\n\t\t\t\t// Load scripts that needs to be loaded\n\t\t\t\ttinymce.each(loadingScripts, function(url) {\n\t\t\t\t\t// Script is already loaded then execute script callbacks directly\n\t\t\t\t\tif (states[url] == LOADED) {\n\t\t\t\t\t\texecScriptLoadedCallbacks(url);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Is script not loading then start loading it\n\t\t\t\t\tif (states[url] != LOADING) {\n\t\t\t\t\t\tstates[url] = LOADING;\n\t\t\t\t\t\tloading++;\n\n\t\t\t\t\t\tloadScript(url, function() {\n\t\t\t\t\t\t\tstates[url] = LOADED;\n\t\t\t\t\t\t\tloading--;\n\n\t\t\t\t\t\t\texecScriptLoadedCallbacks(url);\n\n\t\t\t\t\t\t\t// Load more scripts if they where added by the recently loaded script\n\t\t\t\t\t\t\tloadScripts();\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// No scripts are currently loading then execute all pending queue loaded callbacks\n\t\t\t\tif (!loading) {\n\t\t\t\t\ttinymce.each(queueLoadedCallbacks, function(callback) {\n\t\t\t\t\t\tcallback.func.call(callback.scope);\n\t\t\t\t\t});\n\n\t\t\t\t\tqueueLoadedCallbacks.length = 0;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tloadScripts();\n\t\t};\n\t};\n\n\t// Global script loader\n\ttinymce.ScriptLoader = new tinymce.dom.ScriptLoader();\n})(tinymce);\n\ntinymce.dom.TreeWalker = function(start_node, root_node) {\n\tvar node = start_node;\n\n\tfunction findSibling(node, start_name, sibling_name, shallow) {\n\t\tvar sibling, parent;\n\n\t\tif (node) {\n\t\t\t// Walk into nodes if it has a start\n\t\t\tif (!shallow && node[start_name])\n\t\t\t\treturn node[start_name];\n\n\t\t\t// Return the sibling if it has one\n\t\t\tif (node != root_node) {\n\t\t\t\tsibling = node[sibling_name];\n\t\t\t\tif (sibling)\n\t\t\t\t\treturn sibling;\n\n\t\t\t\t// Walk up the parents to look for siblings\n\t\t\t\tfor (parent = node.parentNode; parent && parent != root_node; parent = parent.parentNode) {\n\t\t\t\t\tsibling = parent[sibling_name];\n\t\t\t\t\tif (sibling)\n\t\t\t\t\t\treturn sibling;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t};\n\n\tthis.current = function() {\n\t\treturn node;\n\t};\n\n\tthis.next = function(shallow) {\n\t\treturn (node = findSibling(node, 'firstChild', 'nextSibling', shallow));\n\t};\n\n\tthis.prev = function(shallow) {\n\t\treturn (node = findSibling(node, 'lastChild', 'previousSibling', shallow));\n\t};\n};\n\n(function(tinymce) {\n\ttinymce.dom.RangeUtils = function(dom) {\n\t\tvar INVISIBLE_CHAR = '\\uFEFF';\n\n\t\tthis.walk = function(rng, callback) {\n\t\t\tvar startContainer = rng.startContainer,\n\t\t\t\tstartOffset = rng.startOffset,\n\t\t\t\tendContainer = rng.endContainer,\n\t\t\t\tendOffset = rng.endOffset,\n\t\t\t\tancestor, startPoint,\n\t\t\t\tendPoint, node, parent, siblings, nodes;\n\n\t\t\t// Handle table cell selection the table plugin enables\n\t\t\t// you to fake select table cells and perform formatting actions on them\n\t\t\tnodes = dom.select('td.mceSelected,th.mceSelected');\n\t\t\tif (nodes.length > 0) {\n\t\t\t\ttinymce.each(nodes, function(node) {\n\t\t\t\t\tcallback([node]);\n\t\t\t\t});\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tfunction exclude(nodes) {\n\t\t\t\tvar node;\n\n\t\t\t\t// First node is excluded\n\t\t\t\tnode = nodes[0];\n\t\t\t\tif (node.nodeType === 3 && node === startContainer && startOffset >= node.nodeValue.length) {\n\t\t\t\t\tnodes.splice(0, 1);\n\t\t\t\t}\n\n\t\t\t\t// Last node is excluded\n\t\t\t\tnode = nodes[nodes.length - 1];\n\t\t\t\tif (endOffset === 0 && nodes.length > 0 && node === endContainer && node.nodeType === 3) {\n\t\t\t\t\tnodes.splice(nodes.length - 1, 1);\n\t\t\t\t}\n\n\t\t\t\treturn nodes;\n\t\t\t};\n\n\t\t\tfunction collectSiblings(node, name, end_node) {\n\t\t\t\tvar siblings = [];\n\n\t\t\t\tfor (; node && node != end_node; node = node[name])\n\t\t\t\t\tsiblings.push(node);\n\n\t\t\t\treturn siblings;\n\t\t\t};\n\n\t\t\tfunction findEndPoint(node, root) {\n\t\t\t\tdo {\n\t\t\t\t\tif (node.parentNode == root)\n\t\t\t\t\t\treturn node;\n\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t} while(node);\n\t\t\t};\n\n\t\t\tfunction walkBoundary(start_node, end_node, next) {\n\t\t\t\tvar siblingName = next ? 'nextSibling' : 'previousSibling';\n\n\t\t\t\tfor (node = start_node, parent = node.parentNode; node && node != end_node; node = parent) {\n\t\t\t\t\tparent = node.parentNode;\n\t\t\t\t\tsiblings = collectSiblings(node == start_node ? node : node[siblingName], siblingName);\n\n\t\t\t\t\tif (siblings.length) {\n\t\t\t\t\t\tif (!next)\n\t\t\t\t\t\t\tsiblings.reverse();\n\n\t\t\t\t\t\tcallback(exclude(siblings));\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// If index based start position then resolve it\n\t\t\tif (startContainer.nodeType == 1 && startContainer.hasChildNodes())\n\t\t\t\tstartContainer = startContainer.childNodes[startOffset];\n\n\t\t\t// If index based end position then resolve it\n\t\t\tif (endContainer.nodeType == 1 && endContainer.hasChildNodes())\n\t\t\t\tendContainer = endContainer.childNodes[Math.min(endOffset - 1, endContainer.childNodes.length - 1)];\n\n\t\t\t// Same container\n\t\t\tif (startContainer == endContainer)\n\t\t\t\treturn callback(exclude([startContainer]));\n\n\t\t\t// Find common ancestor and end points\n\t\t\tancestor = dom.findCommonAncestor(startContainer, endContainer);\n\t\t\t\t\n\t\t\t// Process left side\n\t\t\tfor (node = startContainer; node; node = node.parentNode) {\n\t\t\t\tif (node === endContainer)\n\t\t\t\t\treturn walkBoundary(startContainer, ancestor, true);\n\n\t\t\t\tif (node === ancestor)\n\t\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\t// Process right side\n\t\t\tfor (node = endContainer; node; node = node.parentNode) {\n\t\t\t\tif (node === startContainer)\n\t\t\t\t\treturn walkBoundary(endContainer, ancestor);\n\n\t\t\t\tif (node === ancestor)\n\t\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\t// Find start/end point\n\t\t\tstartPoint = findEndPoint(startContainer, ancestor) || startContainer;\n\t\t\tendPoint = findEndPoint(endContainer, ancestor) || endContainer;\n\n\t\t\t// Walk left leaf\n\t\t\twalkBoundary(startContainer, startPoint, true);\n\n\t\t\t// Walk the middle from start to end point\n\t\t\tsiblings = collectSiblings(\n\t\t\t\tstartPoint == startContainer ? startPoint : startPoint.nextSibling,\n\t\t\t\t'nextSibling',\n\t\t\t\tendPoint == endContainer ? endPoint.nextSibling : endPoint\n\t\t\t);\n\n\t\t\tif (siblings.length)\n\t\t\t\tcallback(exclude(siblings));\n\n\t\t\t// Walk right leaf\n\t\t\twalkBoundary(endContainer, endPoint);\n\t\t};\n\n\t\tthis.split = function(rng) {\n\t\t\tvar startContainer = rng.startContainer,\n\t\t\t\tstartOffset = rng.startOffset,\n\t\t\t\tendContainer = rng.endContainer,\n\t\t\t\tendOffset = rng.endOffset;\n\n\t\t\tfunction splitText(node, offset) {\n\t\t\t\treturn node.splitText(offset);\n\t\t\t};\n\n\t\t\t// Handle single text node\n\t\t\tif (startContainer == endContainer && startContainer.nodeType == 3) {\n\t\t\t\tif (startOffset > 0 && startOffset < startContainer.nodeValue.length) {\n\t\t\t\t\tendContainer = splitText(startContainer, startOffset);\n\t\t\t\t\tstartContainer = endContainer.previousSibling;\n\n\t\t\t\t\tif (endOffset > startOffset) {\n\t\t\t\t\t\tendOffset = endOffset - startOffset;\n\t\t\t\t\t\tstartContainer = endContainer = splitText(endContainer, endOffset).previousSibling;\n\t\t\t\t\t\tendOffset = endContainer.nodeValue.length;\n\t\t\t\t\t\tstartOffset = 0;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tendOffset = 0;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Split startContainer text node if needed\n\t\t\t\tif (startContainer.nodeType == 3 && startOffset > 0 && startOffset < startContainer.nodeValue.length) {\n\t\t\t\t\tstartContainer = splitText(startContainer, startOffset);\n\t\t\t\t\tstartOffset = 0;\n\t\t\t\t}\n\n\t\t\t\t// Split endContainer text node if needed\n\t\t\t\tif (endContainer.nodeType == 3 && endOffset > 0 && endOffset < endContainer.nodeValue.length) {\n\t\t\t\t\tendContainer = splitText(endContainer, endOffset).previousSibling;\n\t\t\t\t\tendOffset = endContainer.nodeValue.length;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn {\n\t\t\t\tstartContainer : startContainer,\n\t\t\t\tstartOffset : startOffset,\n\t\t\t\tendContainer : endContainer,\n\t\t\t\tendOffset : endOffset\n\t\t\t};\n\t\t};\n\n\t};\n\n\ttinymce.dom.RangeUtils.compareRanges = function(rng1, rng2) {\n\t\tif (rng1 && rng2) {\n\t\t\t// Compare native IE ranges\n\t\t\tif (rng1.item || rng1.duplicate) {\n\t\t\t\t// Both are control ranges and the selected element matches\n\t\t\t\tif (rng1.item && rng2.item && rng1.item(0) === rng2.item(0))\n\t\t\t\t\treturn true;\n\n\t\t\t\t// Both are text ranges and the range matches\n\t\t\t\tif (rng1.isEqual && rng2.isEqual && rng2.isEqual(rng1))\n\t\t\t\t\treturn true;\n\t\t\t} else {\n\t\t\t\t// Compare w3c ranges\n\t\t\t\treturn rng1.startContainer == rng2.startContainer && rng1.startOffset == rng2.startOffset;\n\t\t\t}\n\t\t}\n\n\t\treturn false;\n\t};\n})(tinymce);\n\n(function(tinymce) {\n\tvar Event = tinymce.dom.Event, each = tinymce.each;\n\n\ttinymce.create('tinymce.ui.KeyboardNavigation', {\n\t\tKeyboardNavigation: function(settings, dom) {\n\t\t\tvar t = this, root = settings.root, items = settings.items,\n\t\t\t\t\tenableUpDown = settings.enableUpDown, enableLeftRight = settings.enableLeftRight || !settings.enableUpDown,\n\t\t\t\t\texcludeFromTabOrder = settings.excludeFromTabOrder,\n\t\t\t\t\titemFocussed, itemBlurred, rootKeydown, rootFocussed, focussedId;\n\n\t\t\tdom = dom || tinymce.DOM;\n\n\t\t\titemFocussed = function(evt) {\n\t\t\t\tfocussedId = evt.target.id;\n\t\t\t};\n\t\t\t\n\t\t\titemBlurred = function(evt) {\n\t\t\t\tdom.setAttrib(evt.target.id, 'tabindex', '-1');\n\t\t\t};\n\t\t\t\n\t\t\trootFocussed = function(evt) {\n\t\t\t\tvar item = dom.get(focussedId);\n\t\t\t\tdom.setAttrib(item, 'tabindex', '0');\n\t\t\t\titem.focus();\n\t\t\t};\n\t\t\t\n\t\t\tt.focus = function() {\n\t\t\t\tdom.get(focussedId).focus();\n\t\t\t};\n\n\t\t\tt.destroy = function() {\n\t\t\t\teach(items, function(item) {\n\t\t\t\t\tdom.unbind(dom.get(item.id), 'focus', itemFocussed);\n\t\t\t\t\tdom.unbind(dom.get(item.id), 'blur', itemBlurred);\n\t\t\t\t});\n\n\t\t\t\tdom.unbind(dom.get(root), 'focus', rootFocussed);\n\t\t\t\tdom.unbind(dom.get(root), 'keydown', rootKeydown);\n\n\t\t\t\titems = dom = root = t.focus = itemFocussed = itemBlurred = rootKeydown = rootFocussed = null;\n\t\t\t\tt.destroy = function() {};\n\t\t\t};\n\t\t\t\n\t\t\tt.moveFocus = function(dir, evt) {\n\t\t\t\tvar idx = -1, controls = t.controls, newFocus;\n\n\t\t\t\tif (!focussedId)\n\t\t\t\t\treturn;\n\n\t\t\t\teach(items, function(item, index) {\n\t\t\t\t\tif (item.id === focussedId) {\n\t\t\t\t\t\tidx = index;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tidx += dir;\n\t\t\t\tif (idx < 0) {\n\t\t\t\t\tidx = items.length - 1;\n\t\t\t\t} else if (idx >= items.length) {\n\t\t\t\t\tidx = 0;\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\tnewFocus = items[idx];\n\t\t\t\tdom.setAttrib(focussedId, 'tabindex', '-1');\n\t\t\t\tdom.setAttrib(newFocus.id, 'tabindex', '0');\n\t\t\t\tdom.get(newFocus.id).focus();\n\n\t\t\t\tif (settings.actOnFocus) {\n\t\t\t\t\tsettings.onAction(newFocus.id);\n\t\t\t\t}\n\n\t\t\t\tif (evt)\n\t\t\t\t\tEvent.cancel(evt);\n\t\t\t};\n\t\t\t\n\t\t\trootKeydown = function(evt) {\n\t\t\t\tvar DOM_VK_LEFT = 37, DOM_VK_RIGHT = 39, DOM_VK_UP = 38, DOM_VK_DOWN = 40, DOM_VK_ESCAPE = 27, DOM_VK_ENTER = 14, DOM_VK_RETURN = 13, DOM_VK_SPACE = 32;\n\t\t\t\t\n\t\t\t\tswitch (evt.keyCode) {\n\t\t\t\t\tcase DOM_VK_LEFT:\n\t\t\t\t\t\tif (enableLeftRight) t.moveFocus(-1);\n\t\t\t\t\t\tbreak;\n\t\n\t\t\t\t\tcase DOM_VK_RIGHT:\n\t\t\t\t\t\tif (enableLeftRight) t.moveFocus(1);\n\t\t\t\t\t\tbreak;\n\t\n\t\t\t\t\tcase DOM_VK_UP:\n\t\t\t\t\t\tif (enableUpDown) t.moveFocus(-1);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase DOM_VK_DOWN:\n\t\t\t\t\t\tif (enableUpDown) t.moveFocus(1);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase DOM_VK_ESCAPE:\n\t\t\t\t\t\tif (settings.onCancel) {\n\t\t\t\t\t\t\tsettings.onCancel();\n\t\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase DOM_VK_ENTER:\n\t\t\t\t\tcase DOM_VK_RETURN:\n\t\t\t\t\tcase DOM_VK_SPACE:\n\t\t\t\t\t\tif (settings.onAction) {\n\t\t\t\t\t\t\tsettings.onAction(focussedId);\n\t\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Set up state and listeners for each item.\n\t\t\teach(items, function(item, idx) {\n\t\t\t\tvar tabindex;\n\n\t\t\t\tif (!item.id) {\n\t\t\t\t\titem.id = dom.uniqueId('_mce_item_');\n\t\t\t\t}\n\n\t\t\t\tif (excludeFromTabOrder) {\n\t\t\t\t\tdom.bind(item.id, 'blur', itemBlurred);\n\t\t\t\t\ttabindex = '-1';\n\t\t\t\t} else {\n\t\t\t\t\ttabindex = (idx === 0 ? '0' : '-1');\n\t\t\t\t}\n\n\t\t\t\tdom.setAttrib(item.id, 'tabindex', tabindex);\n\t\t\t\tdom.bind(dom.get(item.id), 'focus', itemFocussed);\n\t\t\t});\n\t\t\t\n\t\t\t// Setup initial state for root element.\n\t\t\tif (items[0]){\n\t\t\t\tfocussedId = items[0].id;\n\t\t\t}\n\n\t\t\tdom.setAttrib(root, 'tabindex', '-1');\n\t\t\t\n\t\t\t// Setup listeners for root element.\n\t\t\tdom.bind(dom.get(root), 'focus', rootFocussed);\n\t\t\tdom.bind(dom.get(root), 'keydown', rootKeydown);\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\t// Shorten class names\n\tvar DOM = tinymce.DOM, is = tinymce.is;\n\n\ttinymce.create('tinymce.ui.Control', {\n\t\tControl : function(id, s, editor) {\n\t\t\tthis.id = id;\n\t\t\tthis.settings = s = s || {};\n\t\t\tthis.rendered = false;\n\t\t\tthis.onRender = new tinymce.util.Dispatcher(this);\n\t\t\tthis.classPrefix = '';\n\t\t\tthis.scope = s.scope || this;\n\t\t\tthis.disabled = 0;\n\t\t\tthis.active = 0;\n\t\t\tthis.editor = editor;\n\t\t},\n\t\t\n\t\tsetAriaProperty : function(property, value) {\n\t\t\tvar element = DOM.get(this.id + '_aria') || DOM.get(this.id);\n\t\t\tif (element) {\n\t\t\t\tDOM.setAttrib(element, 'aria-' + property, !!value);\n\t\t\t}\n\t\t},\n\t\t\n\t\tfocus : function() {\n\t\t\tDOM.get(this.id).focus();\n\t\t},\n\n\t\tsetDisabled : function(s) {\n\t\t\tif (s != this.disabled) {\n\t\t\t\tthis.setAriaProperty('disabled', s);\n\n\t\t\t\tthis.setState('Disabled', s);\n\t\t\t\tthis.setState('Enabled', !s);\n\t\t\t\tthis.disabled = s;\n\t\t\t}\n\t\t},\n\n\t\tisDisabled : function() {\n\t\t\treturn this.disabled;\n\t\t},\n\n\t\tsetActive : function(s) {\n\t\t\tif (s != this.active) {\n\t\t\t\tthis.setState('Active', s);\n\t\t\t\tthis.active = s;\n\t\t\t\tthis.setAriaProperty('pressed', s);\n\t\t\t}\n\t\t},\n\n\t\tisActive : function() {\n\t\t\treturn this.active;\n\t\t},\n\n\t\tsetState : function(c, s) {\n\t\t\tvar n = DOM.get(this.id);\n\n\t\t\tc = this.classPrefix + c;\n\n\t\t\tif (s)\n\t\t\t\tDOM.addClass(n, c);\n\t\t\telse\n\t\t\t\tDOM.removeClass(n, c);\n\t\t},\n\n\t\tisRendered : function() {\n\t\t\treturn this.rendered;\n\t\t},\n\n\t\trenderHTML : function() {\n\t\t},\n\n\t\trenderTo : function(n) {\n\t\t\tDOM.setHTML(n, this.renderHTML());\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, b;\n\n\t\t\t// Set pending states\n\t\t\tif (is(t.disabled)) {\n\t\t\t\tb = t.disabled;\n\t\t\t\tt.disabled = -1;\n\t\t\t\tt.setDisabled(b);\n\t\t\t}\n\n\t\t\tif (is(t.active)) {\n\t\t\t\tb = t.active;\n\t\t\t\tt.active = -1;\n\t\t\t\tt.setActive(b);\n\t\t\t}\n\t\t},\n\n\t\tremove : function() {\n\t\t\tDOM.remove(this.id);\n\t\t\tthis.destroy();\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\ttinymce.dom.Event.clear(this.id);\n\t\t}\n\t});\n})(tinymce);\ntinymce.create('tinymce.ui.Container:tinymce.ui.Control', {\n\tContainer : function(id, s, editor) {\n\t\tthis.parent(id, s, editor);\n\n\t\tthis.controls = [];\n\n\t\tthis.lookup = {};\n\t},\n\n\tadd : function(c) {\n\t\tthis.lookup[c.id] = c;\n\t\tthis.controls.push(c);\n\n\t\treturn c;\n\t},\n\n\tget : function(n) {\n\t\treturn this.lookup[n];\n\t}\n});\n\n\ntinymce.create('tinymce.ui.Separator:tinymce.ui.Control', {\n\tSeparator : function(id, s) {\n\t\tthis.parent(id, s);\n\t\tthis.classPrefix = 'mceSeparator';\n\t\tthis.setDisabled(true);\n\t},\n\n\trenderHTML : function() {\n\t\treturn tinymce.DOM.createHTML('span', {'class' : this.classPrefix, role : 'separator', 'aria-orientation' : 'vertical', tabindex : '-1'});\n\t}\n});\n\n(function(tinymce) {\n\tvar is = tinymce.is, DOM = tinymce.DOM, each = tinymce.each, walk = tinymce.walk;\n\n\ttinymce.create('tinymce.ui.MenuItem:tinymce.ui.Control', {\n\t\tMenuItem : function(id, s) {\n\t\t\tthis.parent(id, s);\n\t\t\tthis.classPrefix = 'mceMenuItem';\n\t\t},\n\n\t\tsetSelected : function(s) {\n\t\t\tthis.setState('Selected', s);\n\t\t\tthis.setAriaProperty('checked', !!s);\n\t\t\tthis.selected = s;\n\t\t},\n\n\t\tisSelected : function() {\n\t\t\treturn this.selected;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this;\n\t\t\t\n\t\t\tt.parent();\n\n\t\t\t// Set pending state\n\t\t\tif (is(t.selected))\n\t\t\t\tt.setSelected(t.selected);\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar is = tinymce.is, DOM = tinymce.DOM, each = tinymce.each, walk = tinymce.walk;\n\n\ttinymce.create('tinymce.ui.Menu:tinymce.ui.MenuItem', {\n\t\tMenu : function(id, s) {\n\t\t\tvar t = this;\n\n\t\t\tt.parent(id, s);\n\t\t\tt.items = {};\n\t\t\tt.collapsed = false;\n\t\t\tt.menuCount = 0;\n\t\t\tt.onAddItem = new tinymce.util.Dispatcher(this);\n\t\t},\n\n\t\texpand : function(d) {\n\t\t\tvar t = this;\n\n\t\t\tif (d) {\n\t\t\t\twalk(t, function(o) {\n\t\t\t\t\tif (o.expand)\n\t\t\t\t\t\to.expand();\n\t\t\t\t}, 'items', t);\n\t\t\t}\n\n\t\t\tt.collapsed = false;\n\t\t},\n\n\t\tcollapse : function(d) {\n\t\t\tvar t = this;\n\n\t\t\tif (d) {\n\t\t\t\twalk(t, function(o) {\n\t\t\t\t\tif (o.collapse)\n\t\t\t\t\t\to.collapse();\n\t\t\t\t}, 'items', t);\n\t\t\t}\n\n\t\t\tt.collapsed = true;\n\t\t},\n\n\t\tisCollapsed : function() {\n\t\t\treturn this.collapsed;\n\t\t},\n\n\t\tadd : function(o) {\n\t\t\tif (!o.settings)\n\t\t\t\to = new tinymce.ui.MenuItem(o.id || DOM.uniqueId(), o);\n\n\t\t\tthis.onAddItem.dispatch(this, o);\n\n\t\t\treturn this.items[o.id] = o;\n\t\t},\n\n\t\taddSeparator : function() {\n\t\t\treturn this.add({separator : true});\n\t\t},\n\n\t\taddMenu : function(o) {\n\t\t\tif (!o.collapse)\n\t\t\t\to = this.createMenu(o);\n\n\t\t\tthis.menuCount++;\n\n\t\t\treturn this.add(o);\n\t\t},\n\n\t\thasMenus : function() {\n\t\t\treturn this.menuCount !== 0;\n\t\t},\n\n\t\tremove : function(o) {\n\t\t\tdelete this.items[o.id];\n\t\t},\n\n\t\tremoveAll : function() {\n\t\t\tvar t = this;\n\n\t\t\twalk(t, function(o) {\n\t\t\t\tif (o.removeAll)\n\t\t\t\t\to.removeAll();\n\t\t\t\telse\n\t\t\t\t\to.remove();\n\n\t\t\t\to.destroy();\n\t\t\t}, 'items', t);\n\n\t\t\tt.items = {};\n\t\t},\n\n\t\tcreateMenu : function(o) {\n\t\t\tvar m = new tinymce.ui.Menu(o.id || DOM.uniqueId(), o);\n\n\t\t\tm.onAddItem.add(this.onAddItem.dispatch, this.onAddItem);\n\n\t\t\treturn m;\n\t\t}\n\t});\n})(tinymce);\n(function(tinymce) {\n\tvar is = tinymce.is, DOM = tinymce.DOM, each = tinymce.each, Event = tinymce.dom.Event, Element = tinymce.dom.Element;\n\n\ttinymce.create('tinymce.ui.DropMenu:tinymce.ui.Menu', {\n\t\tDropMenu : function(id, s) {\n\t\t\ts = s || {};\n\t\t\ts.container = s.container || DOM.doc.body;\n\t\t\ts.offset_x = s.offset_x || 0;\n\t\t\ts.offset_y = s.offset_y || 0;\n\t\t\ts.vp_offset_x = s.vp_offset_x || 0;\n\t\t\ts.vp_offset_y = s.vp_offset_y || 0;\n\n\t\t\tif (is(s.icons) && !s.icons)\n\t\t\t\ts['class'] += ' mceNoIcons';\n\n\t\t\tthis.parent(id, s);\n\t\t\tthis.onShowMenu = new tinymce.util.Dispatcher(this);\n\t\t\tthis.onHideMenu = new tinymce.util.Dispatcher(this);\n\t\t\tthis.classPrefix = 'mceMenu';\n\t\t},\n\n\t\tcreateMenu : function(s) {\n\t\t\tvar t = this, cs = t.settings, m;\n\n\t\t\ts.container = s.container || cs.container;\n\t\t\ts.parent = t;\n\t\t\ts.constrain = s.constrain || cs.constrain;\n\t\t\ts['class'] = s['class'] || cs['class'];\n\t\t\ts.vp_offset_x = s.vp_offset_x || cs.vp_offset_x;\n\t\t\ts.vp_offset_y = s.vp_offset_y || cs.vp_offset_y;\n\t\t\ts.keyboard_focus = cs.keyboard_focus;\n\t\t\tm = new tinymce.ui.DropMenu(s.id || DOM.uniqueId(), s);\n\n\t\t\tm.onAddItem.add(t.onAddItem.dispatch, t.onAddItem);\n\n\t\t\treturn m;\n\t\t},\n\t\t\n\t\tfocus : function() {\n\t\t\tvar t = this;\n\t\t\tif (t.keyboardNav) {\n\t\t\t\tt.keyboardNav.focus();\n\t\t\t}\n\t\t},\n\n\t\tupdate : function() {\n\t\t\tvar t = this, s = t.settings, tb = DOM.get('menu_' + t.id + '_tbl'), co = DOM.get('menu_' + t.id + '_co'), tw, th;\n\n\t\t\ttw = s.max_width ? Math.min(tb.clientWidth, s.max_width) : tb.clientWidth;\n\t\t\tth = s.max_height ? Math.min(tb.clientHeight, s.max_height) : tb.clientHeight;\n\n\t\t\tif (!DOM.boxModel)\n\t\t\t\tt.element.setStyles({width : tw + 2, height : th + 2});\n\t\t\telse\n\t\t\t\tt.element.setStyles({width : tw, height : th});\n\n\t\t\tif (s.max_width)\n\t\t\t\tDOM.setStyle(co, 'width', tw);\n\n\t\t\tif (s.max_height) {\n\t\t\t\tDOM.setStyle(co, 'height', th);\n\n\t\t\t\tif (tb.clientHeight < s.max_height)\n\t\t\t\t\tDOM.setStyle(co, 'overflow', 'hidden');\n\t\t\t}\n\t\t},\n\n\t\tshowMenu : function(x, y, px) {\n\t\t\tvar t = this, s = t.settings, co, vp = DOM.getViewPort(), w, h, mx, my, ot = 2, dm, tb, cp = t.classPrefix;\n\n\t\t\tt.collapse(1);\n\n\t\t\tif (t.isMenuVisible)\n\t\t\t\treturn;\n\n\t\t\tif (!t.rendered) {\n\t\t\t\tco = DOM.add(t.settings.container, t.renderNode());\n\n\t\t\t\teach(t.items, function(o) {\n\t\t\t\t\to.postRender();\n\t\t\t\t});\n\n\t\t\t\tt.element = new Element('menu_' + t.id, {blocker : 1, container : s.container});\n\t\t\t} else\n\t\t\t\tco = DOM.get('menu_' + t.id);\n\n\t\t\t// Move layer out of sight unless it's Opera since it scrolls to top of page due to an bug\n\t\t\tif (!tinymce.isOpera)\n\t\t\t\tDOM.setStyles(co, {left : -0xFFFF , top : -0xFFFF});\n\n\t\t\tDOM.show(co);\n\t\t\tt.update();\n\n\t\t\tx += s.offset_x || 0;\n\t\t\ty += s.offset_y || 0;\n\t\t\tvp.w -= 4;\n\t\t\tvp.h -= 4;\n\n\t\t\t// Move inside viewport if not submenu\n\t\t\tif (s.constrain) {\n\t\t\t\tw = co.clientWidth - ot;\n\t\t\t\th = co.clientHeight - ot;\n\t\t\t\tmx = vp.x + vp.w;\n\t\t\t\tmy = vp.y + vp.h;\n\n\t\t\t\tif ((x + s.vp_offset_x + w) > mx)\n\t\t\t\t\tx = px ? px - w : Math.max(0, (mx - s.vp_offset_x) - w);\n\n\t\t\t\tif ((y + s.vp_offset_y + h) > my)\n\t\t\t\t\ty = Math.max(0, (my - s.vp_offset_y) - h);\n\t\t\t}\n\n\t\t\tDOM.setStyles(co, {left : x , top : y});\n\t\t\tt.element.update();\n\n\t\t\tt.isMenuVisible = 1;\n\t\t\tt.mouseClickFunc = Event.add(co, 'click', function(e) {\n\t\t\t\tvar m;\n\n\t\t\t\te = e.target;\n\n\t\t\t\tif (e && (e = DOM.getParent(e, 'tr')) && !DOM.hasClass(e, cp + 'ItemSub')) {\n\t\t\t\t\tm = t.items[e.id];\n\n\t\t\t\t\tif (m.isDisabled())\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tdm = t;\n\n\t\t\t\t\twhile (dm) {\n\t\t\t\t\t\tif (dm.hideMenu)\n\t\t\t\t\t\t\tdm.hideMenu();\n\n\t\t\t\t\t\tdm = dm.settings.parent;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (m.settings.onclick)\n\t\t\t\t\t\tm.settings.onclick(e);\n\n\t\t\t\t\treturn Event.cancel(e); // Cancel to fix onbeforeunload problem\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tif (t.hasMenus()) {\n\t\t\t\tt.mouseOverFunc = Event.add(co, 'mouseover', function(e) {\n\t\t\t\t\tvar m, r, mi;\n\n\t\t\t\t\te = e.target;\n\t\t\t\t\tif (e && (e = DOM.getParent(e, 'tr'))) {\n\t\t\t\t\t\tm = t.items[e.id];\n\n\t\t\t\t\t\tif (t.lastMenu)\n\t\t\t\t\t\t\tt.lastMenu.collapse(1);\n\n\t\t\t\t\t\tif (m.isDisabled())\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tif (e && DOM.hasClass(e, cp + 'ItemSub')) {\n\t\t\t\t\t\t\t//p = DOM.getPos(s.container);\n\t\t\t\t\t\t\tr = DOM.getRect(e);\n\t\t\t\t\t\t\tm.showMenu((r.x + r.w - ot), r.y - ot, r.x);\n\t\t\t\t\t\t\tt.lastMenu = m;\n\t\t\t\t\t\t\tDOM.addClass(DOM.get(m.id).firstChild, cp + 'ItemActive');\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t\t\n\t\t\tEvent.add(co, 'keydown', t._keyHandler, t);\n\n\t\t\tt.onShowMenu.dispatch(t);\n\n\t\t\tif (s.keyboard_focus) { \n\t\t\t\tt._setupKeyboardNav(); \n\t\t\t}\n\t\t},\n\n\t\thideMenu : function(c) {\n\t\t\tvar t = this, co = DOM.get('menu_' + t.id), e;\n\n\t\t\tif (!t.isMenuVisible)\n\t\t\t\treturn;\n\n\t\t\tif (t.keyboardNav) t.keyboardNav.destroy();\n\t\t\tEvent.remove(co, 'mouseover', t.mouseOverFunc);\n\t\t\tEvent.remove(co, 'click', t.mouseClickFunc);\n\t\t\tEvent.remove(co, 'keydown', t._keyHandler);\n\t\t\tDOM.hide(co);\n\t\t\tt.isMenuVisible = 0;\n\n\t\t\tif (!c)\n\t\t\t\tt.collapse(1);\n\n\t\t\tif (t.element)\n\t\t\t\tt.element.hide();\n\n\t\t\tif (e = DOM.get(t.id))\n\t\t\t\tDOM.removeClass(e.firstChild, t.classPrefix + 'ItemActive');\n\n\t\t\tt.onHideMenu.dispatch(t);\n\t\t},\n\n\t\tadd : function(o) {\n\t\t\tvar t = this, co;\n\n\t\t\to = t.parent(o);\n\n\t\t\tif (t.isRendered && (co = DOM.get('menu_' + t.id)))\n\t\t\t\tt._add(DOM.select('tbody', co)[0], o);\n\n\t\t\treturn o;\n\t\t},\n\n\t\tcollapse : function(d) {\n\t\t\tthis.parent(d);\n\t\t\tthis.hideMenu(1);\n\t\t},\n\n\t\tremove : function(o) {\n\t\t\tDOM.remove(o.id);\n\t\t\tthis.destroy();\n\n\t\t\treturn this.parent(o);\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tvar t = this, co = DOM.get('menu_' + t.id);\n\n\t\t\tif (t.keyboardNav) t.keyboardNav.destroy();\n\t\t\tEvent.remove(co, 'mouseover', t.mouseOverFunc);\n\t\t\tEvent.remove(DOM.select('a', co), 'focus', t.mouseOverFunc);\n\t\t\tEvent.remove(co, 'click', t.mouseClickFunc);\n\t\t\tEvent.remove(co, 'keydown', t._keyHandler);\n\n\t\t\tif (t.element)\n\t\t\t\tt.element.remove();\n\n\t\t\tDOM.remove(co);\n\t\t},\n\n\t\trenderNode : function() {\n\t\t\tvar t = this, s = t.settings, n, tb, co, w;\n\n\t\t\tw = DOM.create('div', {role: 'listbox', id : 'menu_' + t.id, 'class' : s['class'], 'style' : 'position:absolute;left:0;top:0;z-index:200000;outline:0'});\n\t\t\tif (t.settings.parent) {\n\t\t\t\tDOM.setAttrib(w, 'aria-parent', 'menu_' + t.settings.parent.id);\n\t\t\t}\n\t\t\tco = DOM.add(w, 'div', {role: 'presentation', id : 'menu_' + t.id + '_co', 'class' : t.classPrefix + (s['class'] ? ' ' + s['class'] : '')});\n\t\t\tt.element = new Element('menu_' + t.id, {blocker : 1, container : s.container});\n\n\t\t\tif (s.menu_line)\n\t\t\t\tDOM.add(co, 'span', {'class' : t.classPrefix + 'Line'});\n\n//\t\t\tn = DOM.add(co, 'div', {id : 'menu_' + t.id + '_co', 'class' : 'mceMenuContainer'});\n\t\t\tn = DOM.add(co, 'table', {role: 'presentation', id : 'menu_' + t.id + '_tbl', border : 0, cellPadding : 0, cellSpacing : 0});\n\t\t\ttb = DOM.add(n, 'tbody');\n\n\t\t\teach(t.items, function(o) {\n\t\t\t\tt._add(tb, o);\n\t\t\t});\n\n\t\t\tt.rendered = true;\n\n\t\t\treturn w;\n\t\t},\n\n\t\t// Internal functions\n\t\t_setupKeyboardNav : function(){\n\t\t\tvar contextMenu, menuItems, t=this; \n\t\t\tcontextMenu = DOM.select('#menu_' + t.id)[0];\n\t\t\tmenuItems = DOM.select('a[role=option]', 'menu_' + t.id);\n\t\t\tmenuItems.splice(0,0,contextMenu);\n\t\t\tt.keyboardNav = new tinymce.ui.KeyboardNavigation({\n\t\t\t\troot: 'menu_' + t.id,\n\t\t\t\titems: menuItems,\n\t\t\t\tonCancel: function() {\n\t\t\t\t\tt.hideMenu();\n\t\t\t\t},\n\t\t\t\tenableUpDown: true\n\t\t\t});\n\t\t\tcontextMenu.focus();\n\t\t},\n\n\t\t_keyHandler : function(evt) {\n\t\t\tvar t = this, e;\n\t\t\tswitch (evt.keyCode) {\n\t\t\t\tcase 37: // Left\n\t\t\t\t\tif (t.settings.parent) {\n\t\t\t\t\t\tt.hideMenu();\n\t\t\t\t\t\tt.settings.parent.focus();\n\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tcase 39: // Right\n\t\t\t\t\tif (t.mouseOverFunc)\n\t\t\t\t\t\tt.mouseOverFunc(evt);\n\t\t\t\t\tbreak;\n\t\t\t}\n\t\t},\n\n\t\t_add : function(tb, o) {\n\t\t\tvar n, s = o.settings, a, ro, it, cp = this.classPrefix, ic;\n\n\t\t\tif (s.separator) {\n\t\t\t\tro = DOM.add(tb, 'tr', {id : o.id, 'class' : cp + 'ItemSeparator'});\n\t\t\t\tDOM.add(ro, 'td', {'class' : cp + 'ItemSeparator'});\n\n\t\t\t\tif (n = ro.previousSibling)\n\t\t\t\t\tDOM.addClass(n, 'mceLast');\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tn = ro = DOM.add(tb, 'tr', {id : o.id, 'class' : cp + 'Item ' + cp + 'ItemEnabled'});\n\t\t\tn = it = DOM.add(n, s.titleItem ? 'th' : 'td');\n\t\t\tn = a = DOM.add(n, 'a', {id: o.id + '_aria',  role: s.titleItem ? 'presentation' : 'option', href : 'javascript:;', onclick : \"return false;\", onmousedown : 'return false;'});\n\n\t\t\tif (s.parent) {\n\t\t\t\tDOM.setAttrib(a, 'aria-haspopup', 'true');\n\t\t\t\tDOM.setAttrib(a, 'aria-owns', 'menu_' + o.id);\n\t\t\t}\n\n\t\t\tDOM.addClass(it, s['class']);\n//\t\t\tn = DOM.add(n, 'span', {'class' : 'item'});\n\n\t\t\tic = DOM.add(n, 'span', {'class' : 'mceIcon' + (s.icon ? ' mce_' + s.icon : '')});\n\n\t\t\tif (s.icon_src)\n\t\t\t\tDOM.add(ic, 'img', {src : s.icon_src});\n\n\t\t\tn = DOM.add(n, s.element || 'span', {'class' : 'mceText', title : o.settings.title}, o.settings.title);\n\n\t\t\tif (o.settings.style)\n\t\t\t\tDOM.setAttrib(n, 'style', o.settings.style);\n\n\t\t\tif (tb.childNodes.length == 1)\n\t\t\t\tDOM.addClass(ro, 'mceFirst');\n\n\t\t\tif ((n = ro.previousSibling) && DOM.hasClass(n, cp + 'ItemSeparator'))\n\t\t\t\tDOM.addClass(ro, 'mceFirst');\n\n\t\t\tif (o.collapse)\n\t\t\t\tDOM.addClass(ro, cp + 'ItemSub');\n\n\t\t\tif (n = ro.previousSibling)\n\t\t\t\tDOM.removeClass(n, 'mceLast');\n\n\t\t\tDOM.addClass(ro, 'mceLast');\n\t\t}\n\t});\n})(tinymce);\n(function(tinymce) {\n\tvar DOM = tinymce.DOM;\n\n\ttinymce.create('tinymce.ui.Button:tinymce.ui.Control', {\n\t\tButton : function(id, s, ed) {\n\t\t\tthis.parent(id, s, ed);\n\t\t\tthis.classPrefix = 'mceButton';\n\t\t},\n\n\t\trenderHTML : function() {\n\t\t\tvar cp = this.classPrefix, s = this.settings, h, l;\n\n\t\t\tl = DOM.encode(s.label || '');\n\t\t\th = '<a role=\"button\" id=\"' + this.id + '\" href=\"javascript:;\" class=\"' + cp + ' ' + cp + 'Enabled ' + s['class'] + (l ? ' ' + cp + 'Labeled' : '') +'\" onmousedown=\"return false;\" onclick=\"return false;\" aria-labelledby=\"' + this.id + '_voice\" title=\"' + DOM.encode(s.title) + '\">';\n\t\t\tif (s.image && !(this.editor  &&this.editor.forcedHighContrastMode) )\n\t\t\t\th += '<img class=\"mceIcon\" src=\"' + s.image + '\" alt=\"' + DOM.encode(s.title) + '\" />' + l;\n\t\t\telse\n\t\t\t\th += '<span class=\"mceIcon ' + s['class'] + '\"></span>' + (l ? '<span class=\"' + cp + 'Label\">' + l + '</span>' : '');\n\n\t\t\th += '<span class=\"mceVoiceLabel mceIconOnly\" style=\"display: none;\" id=\"' + this.id + '_voice\">' + s.title + '</span>'; \n\t\t\th += '</a>';\n\t\t\treturn h;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\ttinymce.dom.Event.add(t.id, 'click', function(e) {\n\t\t\t\tif (!t.isDisabled())\n\t\t\t\t\treturn s.onclick.call(s.scope, e);\n\t\t\t});\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each, Dispatcher = tinymce.util.Dispatcher;\n\n\ttinymce.create('tinymce.ui.ListBox:tinymce.ui.Control', {\n\t\tListBox : function(id, s, ed) {\n\t\t\tvar t = this;\n\n\t\t\tt.parent(id, s, ed);\n\n\t\t\tt.items = [];\n\n\t\t\tt.onChange = new Dispatcher(t);\n\n\t\t\tt.onPostRender = new Dispatcher(t);\n\n\t\t\tt.onAdd = new Dispatcher(t);\n\n\t\t\tt.onRenderMenu = new tinymce.util.Dispatcher(this);\n\n\t\t\tt.classPrefix = 'mceListBox';\n\t\t},\n\n\t\tselect : function(va) {\n\t\t\tvar t = this, fv, f;\n\n\t\t\tif (va == undefined)\n\t\t\t\treturn t.selectByIndex(-1);\n\n\t\t\t// Is string or number make function selector\n\t\t\tif (va && va.call)\n\t\t\t\tf = va;\n\t\t\telse {\n\t\t\t\tf = function(v) {\n\t\t\t\t\treturn v == va;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t// Do we need to do something?\n\t\t\tif (va != t.selectedValue) {\n\t\t\t\t// Find item\n\t\t\t\teach(t.items, function(o, i) {\n\t\t\t\t\tif (f(o.value)) {\n\t\t\t\t\t\tfv = 1;\n\t\t\t\t\t\tt.selectByIndex(i);\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tif (!fv)\n\t\t\t\t\tt.selectByIndex(-1);\n\t\t\t}\n\t\t},\n\n\t\tselectByIndex : function(idx) {\n\t\t\tvar t = this, e, o, label;\n\n\t\t\tif (idx != t.selectedIndex) {\n\t\t\t\te = DOM.get(t.id + '_text');\n\t\t\t\tlabel = DOM.get(t.id + '_voiceDesc');\n\t\t\t\to = t.items[idx];\n\n\t\t\t\tif (o) {\n\t\t\t\t\tt.selectedValue = o.value;\n\t\t\t\t\tt.selectedIndex = idx;\n\t\t\t\t\tDOM.setHTML(e, DOM.encode(o.title));\n\t\t\t\t\tDOM.setHTML(label, t.settings.title + \" - \" + o.title);\n\t\t\t\t\tDOM.removeClass(e, 'mceTitle');\n\t\t\t\t\tDOM.setAttrib(t.id, 'aria-valuenow', o.title);\n\t\t\t\t} else {\n\t\t\t\t\tDOM.setHTML(e, DOM.encode(t.settings.title));\n\t\t\t\t\tDOM.setHTML(label, DOM.encode(t.settings.title));\n\t\t\t\t\tDOM.addClass(e, 'mceTitle');\n\t\t\t\t\tt.selectedValue = t.selectedIndex = null;\n\t\t\t\t\tDOM.setAttrib(t.id, 'aria-valuenow', t.settings.title);\n\t\t\t\t}\n\t\t\t\te = 0;\n\t\t\t}\n\t\t},\n\n\t\tadd : function(n, v, o) {\n\t\t\tvar t = this;\n\n\t\t\to = o || {};\n\t\t\to = tinymce.extend(o, {\n\t\t\t\ttitle : n,\n\t\t\t\tvalue : v\n\t\t\t});\n\n\t\t\tt.items.push(o);\n\t\t\tt.onAdd.dispatch(t, o);\n\t\t},\n\n\t\tgetLength : function() {\n\t\t\treturn this.items.length;\n\t\t},\n\n\t\trenderHTML : function() {\n\t\t\tvar h = '', t = this, s = t.settings, cp = t.classPrefix;\n\n\t\t\th = '<span role=\"listbox\" aria-haspopup=\"true\" aria-labelledby=\"' + t.id +'_voiceDesc\" aria-describedby=\"' + t.id + '_voiceDesc\"><table role=\"presentation\" tabindex=\"0\" id=\"' + t.id + '\" cellpadding=\"0\" cellspacing=\"0\" class=\"' + cp + ' ' + cp + 'Enabled' + (s['class'] ? (' ' + s['class']) : '') + '\"><tbody><tr>';\n\t\t\th += '<td>' + DOM.createHTML('span', {id: t.id + '_voiceDesc', 'class': 'voiceLabel', style:'display:none;'}, t.settings.title); \n\t\t\th += DOM.createHTML('a', {id : t.id + '_text', tabindex : -1, href : 'javascript:;', 'class' : 'mceText', onclick : \"return false;\", onmousedown : 'return false;'}, DOM.encode(t.settings.title)) + '</td>';\n\t\t\th += '<td>' + DOM.createHTML('a', {id : t.id + '_open', tabindex : -1, href : 'javascript:;', 'class' : 'mceOpen', onclick : \"return false;\", onmousedown : 'return false;'}, '<span><span style=\"display:none;\" class=\"mceIconOnly\" aria-hidden=\"true\">\\u25BC</span></span>') + '</td>';\n\t\t\th += '</tr></tbody></table></span>';\n\n\t\t\treturn h;\n\t\t},\n\n\t\tshowMenu : function() {\n\t\t\tvar t = this, p2, e = DOM.get(this.id), m;\n\n\t\t\tif (t.isDisabled() || t.items.length == 0)\n\t\t\t\treturn;\n\n\t\t\tif (t.menu && t.menu.isMenuVisible)\n\t\t\t\treturn t.hideMenu();\n\n\t\t\tif (!t.isMenuRendered) {\n\t\t\t\tt.renderMenu();\n\t\t\t\tt.isMenuRendered = true;\n\t\t\t}\n\n\t\t\tp2 = DOM.getPos(e);\n\n\t\t\tm = t.menu;\n\t\t\tm.settings.offset_x = p2.x;\n\t\t\tm.settings.offset_y = p2.y;\n\t\t\tm.settings.keyboard_focus = !tinymce.isOpera; // Opera is buggy when it comes to auto focus\n\n\t\t\t// Select in menu\n\t\t\tif (t.oldID)\n\t\t\t\tm.items[t.oldID].setSelected(0);\n\n\t\t\teach(t.items, function(o) {\n\t\t\t\tif (o.value === t.selectedValue) {\n\t\t\t\t\tm.items[o.id].setSelected(1);\n\t\t\t\t\tt.oldID = o.id;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tm.showMenu(0, e.clientHeight);\n\n\t\t\tEvent.add(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\tDOM.addClass(t.id, t.classPrefix + 'Selected');\n\n\t\t\t//DOM.get(t.id + '_text').focus();\n\t\t},\n\n\t\thideMenu : function(e) {\n\t\t\tvar t = this;\n\n\t\t\tif (t.menu && t.menu.isMenuVisible) {\n\t\t\t\tDOM.removeClass(t.id, t.classPrefix + 'Selected');\n\n\t\t\t\t// Prevent double toogles by canceling the mouse click event to the button\n\t\t\t\tif (e && e.type == \"mousedown\" && (e.target.id == t.id + '_text' || e.target.id == t.id + '_open'))\n\t\t\t\t\treturn;\n\n\t\t\t\tif (!e || !DOM.getParent(e.target, '.mceMenu')) {\n\t\t\t\t\tDOM.removeClass(t.id, t.classPrefix + 'Selected');\n\t\t\t\t\tEvent.remove(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\t\t\tt.menu.hideMenu();\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\trenderMenu : function() {\n\t\t\tvar t = this, m;\n\n\t\t\tm = t.settings.control_manager.createDropMenu(t.id + '_menu', {\n\t\t\t\tmenu_line : 1,\n\t\t\t\t'class' : t.classPrefix + 'Menu mceNoIcons',\n\t\t\t\tmax_width : 150,\n\t\t\t\tmax_height : 150\n\t\t\t});\n\n\t\t\tm.onHideMenu.add(function() {\n\t\t\t\tt.hideMenu();\n\t\t\t\tt.focus();\n\t\t\t});\n\n\t\t\tm.add({\n\t\t\t\ttitle : t.settings.title,\n\t\t\t\t'class' : 'mceMenuItemTitle',\n\t\t\t\tonclick : function() {\n\t\t\t\t\tif (t.settings.onselect('') !== false)\n\t\t\t\t\t\tt.select(''); // Must be runned after\n\t\t\t\t}\n\t\t\t});\n\n\t\t\teach(t.items, function(o) {\n\t\t\t\t// No value then treat it as a title\n\t\t\t\tif (o.value === undefined) {\n\t\t\t\t\tm.add({\n\t\t\t\t\t\ttitle : o.title,\n\t\t\t\t\t\trole : \"option\",\n\t\t\t\t\t\t'class' : 'mceMenuItemTitle',\n\t\t\t\t\t\tonclick : function() {\n\t\t\t\t\t\t\tif (t.settings.onselect('') !== false)\n\t\t\t\t\t\t\t\tt.select(''); // Must be runned after\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\to.id = DOM.uniqueId();\n\t\t\t\t\to.role= \"option\";\n\t\t\t\t\to.onclick = function() {\n\t\t\t\t\t\tif (t.settings.onselect(o.value) !== false)\n\t\t\t\t\t\t\tt.select(o.value); // Must be runned after\n\t\t\t\t\t};\n\n\t\t\t\t\tm.add(o);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.onRenderMenu.dispatch(t, m);\n\t\t\tt.menu = m;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, cp = t.classPrefix;\n\n\t\t\tEvent.add(t.id, 'click', t.showMenu, t);\n\t\t\tEvent.add(t.id, 'keydown', function(evt) {\n\t\t\t\tif (evt.keyCode == 32) { // Space\n\t\t\t\t\tt.showMenu(evt);\n\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t}\n\t\t\t});\n\t\t\tEvent.add(t.id, 'focus', function() {\n\t\t\t\tif (!t._focused) {\n\t\t\t\t\tt.keyDownHandler = Event.add(t.id, 'keydown', function(e) {\n\t\t\t\t\t\tif (e.keyCode == 40) {\n\t\t\t\t\t\t\tt.showMenu();\n\t\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tt.keyPressHandler = Event.add(t.id, 'keypress', function(e) {\n\t\t\t\t\t\tvar v;\n\t\t\t\t\t\tif (e.keyCode == 13) {\n\t\t\t\t\t\t\t// Fake select on enter\n\t\t\t\t\t\t\tv = t.selectedValue;\n\t\t\t\t\t\t\tt.selectedValue = null; // Needs to be null to fake change\n\t\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t\t\t\tt.settings.onselect(v);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tt._focused = 1;\n\t\t\t});\n\t\t\tEvent.add(t.id, 'blur', function() {\n\t\t\t\tEvent.remove(t.id, 'keydown', t.keyDownHandler);\n\t\t\t\tEvent.remove(t.id, 'keypress', t.keyPressHandler);\n\t\t\t\tt._focused = 0;\n\t\t\t});\n\n\t\t\t// Old IE doesn't have hover on all elements\n\t\t\tif (tinymce.isIE6 || !DOM.boxModel) {\n\t\t\t\tEvent.add(t.id, 'mouseover', function() {\n\t\t\t\t\tif (!DOM.hasClass(t.id, cp + 'Disabled'))\n\t\t\t\t\t\tDOM.addClass(t.id, cp + 'Hover');\n\t\t\t\t});\n\n\t\t\t\tEvent.add(t.id, 'mouseout', function() {\n\t\t\t\t\tif (!DOM.hasClass(t.id, cp + 'Disabled'))\n\t\t\t\t\t\tDOM.removeClass(t.id, cp + 'Hover');\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tt.onPostRender.dispatch(t, DOM.get(t.id));\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tthis.parent();\n\n\t\t\tEvent.clear(this.id + '_text');\n\t\t\tEvent.clear(this.id + '_open');\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each, Dispatcher = tinymce.util.Dispatcher;\n\n\ttinymce.create('tinymce.ui.NativeListBox:tinymce.ui.ListBox', {\n\t\tNativeListBox : function(id, s) {\n\t\t\tthis.parent(id, s);\n\t\t\tthis.classPrefix = 'mceNativeListBox';\n\t\t},\n\n\t\tsetDisabled : function(s) {\n\t\t\tDOM.get(this.id).disabled = s;\n\t\t\tthis.setAriaProperty('disabled', s);\n\t\t},\n\n\t\tisDisabled : function() {\n\t\t\treturn DOM.get(this.id).disabled;\n\t\t},\n\n\t\tselect : function(va) {\n\t\t\tvar t = this, fv, f;\n\n\t\t\tif (va == undefined)\n\t\t\t\treturn t.selectByIndex(-1);\n\n\t\t\t// Is string or number make function selector\n\t\t\tif (va && va.call)\n\t\t\t\tf = va;\n\t\t\telse {\n\t\t\t\tf = function(v) {\n\t\t\t\t\treturn v == va;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t// Do we need to do something?\n\t\t\tif (va != t.selectedValue) {\n\t\t\t\t// Find item\n\t\t\t\teach(t.items, function(o, i) {\n\t\t\t\t\tif (f(o.value)) {\n\t\t\t\t\t\tfv = 1;\n\t\t\t\t\t\tt.selectByIndex(i);\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tif (!fv)\n\t\t\t\t\tt.selectByIndex(-1);\n\t\t\t}\n\t\t},\n\n\t\tselectByIndex : function(idx) {\n\t\t\tDOM.get(this.id).selectedIndex = idx + 1;\n\t\t\tthis.selectedValue = this.items[idx] ? this.items[idx].value : null;\n\t\t},\n\n\t\tadd : function(n, v, a) {\n\t\t\tvar o, t = this;\n\n\t\t\ta = a || {};\n\t\t\ta.value = v;\n\n\t\t\tif (t.isRendered())\n\t\t\t\tDOM.add(DOM.get(this.id), 'option', a, n);\n\n\t\t\to = {\n\t\t\t\ttitle : n,\n\t\t\t\tvalue : v,\n\t\t\t\tattribs : a\n\t\t\t};\n\n\t\t\tt.items.push(o);\n\t\t\tt.onAdd.dispatch(t, o);\n\t\t},\n\n\t\tgetLength : function() {\n\t\t\treturn this.items.length;\n\t\t},\n\n\t\trenderHTML : function() {\n\t\t\tvar h, t = this;\n\n\t\t\th = DOM.createHTML('option', {value : ''}, '-- ' + t.settings.title + ' --');\n\n\t\t\teach(t.items, function(it) {\n\t\t\t\th += DOM.createHTML('option', {value : it.value}, it.title);\n\t\t\t});\n\n\t\t\th = DOM.createHTML('select', {id : t.id, 'class' : 'mceNativeListBox', 'aria-labelledby': t.id + '_aria'}, h);\n\t\t\th += DOM.createHTML('span', {id : t.id + '_aria', 'style': 'display: none'}, t.settings.title);\n\t\t\treturn h;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, ch, changeListenerAdded = true;\n\n\t\t\tt.rendered = true;\n\n\t\t\tfunction onChange(e) {\n\t\t\t\tvar v = t.items[e.target.selectedIndex - 1];\n\n\t\t\t\tif (v && (v = v.value)) {\n\t\t\t\t\tt.onChange.dispatch(t, v);\n\n\t\t\t\t\tif (t.settings.onselect)\n\t\t\t\t\t\tt.settings.onselect(v);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tEvent.add(t.id, 'change', onChange);\n\n\t\t\t// Accessibility keyhandler\n\t\t\tEvent.add(t.id, 'keydown', function(e) {\n\t\t\t\tvar bf;\n\n\t\t\t\tEvent.remove(t.id, 'change', ch);\n\t\t\t\tchangeListenerAdded = false;\n\n\t\t\t\tbf = Event.add(t.id, 'blur', function() {\n\t\t\t\t\tif (changeListenerAdded) return;\n\t\t\t\t\tchangeListenerAdded = true;\n\t\t\t\t\tEvent.add(t.id, 'change', onChange);\n\t\t\t\t\tEvent.remove(t.id, 'blur', bf);\n\t\t\t\t});\n\n\t\t\t\t//prevent default left and right keys on chrome - so that the keyboard navigation is used.\n\t\t\t\tif (tinymce.isWebKit && (e.keyCode==37 ||e.keyCode==39)) {\n\t\t\t\t\treturn Event.prevent(e);\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\tif (e.keyCode == 13 || e.keyCode == 32) {\n\t\t\t\t\tonChange(e);\n\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.onPostRender.dispatch(t, DOM.get(t.id));\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each;\n\n\ttinymce.create('tinymce.ui.MenuButton:tinymce.ui.Button', {\n\t\tMenuButton : function(id, s, ed) {\n\t\t\tthis.parent(id, s, ed);\n\n\t\t\tthis.onRenderMenu = new tinymce.util.Dispatcher(this);\n\n\t\t\ts.menu_container = s.menu_container || DOM.doc.body;\n\t\t},\n\n\t\tshowMenu : function() {\n\t\t\tvar t = this, p1, p2, e = DOM.get(t.id), m;\n\n\t\t\tif (t.isDisabled())\n\t\t\t\treturn;\n\n\t\t\tif (!t.isMenuRendered) {\n\t\t\t\tt.renderMenu();\n\t\t\t\tt.isMenuRendered = true;\n\t\t\t}\n\n\t\t\tif (t.isMenuVisible)\n\t\t\t\treturn t.hideMenu();\n\n\t\t\tp1 = DOM.getPos(t.settings.menu_container);\n\t\t\tp2 = DOM.getPos(e);\n\n\t\t\tm = t.menu;\n\t\t\tm.settings.offset_x = p2.x;\n\t\t\tm.settings.offset_y = p2.y;\n\t\t\tm.settings.vp_offset_x = p2.x;\n\t\t\tm.settings.vp_offset_y = p2.y;\n\t\t\tm.settings.keyboard_focus = t._focused;\n\t\t\tm.showMenu(0, e.clientHeight);\n\n\t\t\tEvent.add(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\tt.setState('Selected', 1);\n\n\t\t\tt.isMenuVisible = 1;\n\t\t},\n\n\t\trenderMenu : function() {\n\t\t\tvar t = this, m;\n\n\t\t\tm = t.settings.control_manager.createDropMenu(t.id + '_menu', {\n\t\t\t\tmenu_line : 1,\n\t\t\t\t'class' : this.classPrefix + 'Menu',\n\t\t\t\ticons : t.settings.icons\n\t\t\t});\n\n\t\t\tm.onHideMenu.add(function() {\n\t\t\t\tt.hideMenu();\n\t\t\t\tt.focus();\n\t\t\t});\n\n\t\t\tt.onRenderMenu.dispatch(t, m);\n\t\t\tt.menu = m;\n\t\t},\n\n\t\thideMenu : function(e) {\n\t\t\tvar t = this;\n\n\t\t\t// Prevent double toogles by canceling the mouse click event to the button\n\t\t\tif (e && e.type == \"mousedown\" && DOM.getParent(e.target, function(e) {return e.id === t.id || e.id === t.id + '_open';}))\n\t\t\t\treturn;\n\n\t\t\tif (!e || !DOM.getParent(e.target, '.mceMenu')) {\n\t\t\t\tt.setState('Selected', 0);\n\t\t\t\tEvent.remove(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\t\tif (t.menu)\n\t\t\t\t\tt.menu.hideMenu();\n\t\t\t}\n\n\t\t\tt.isMenuVisible = 0;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\tEvent.add(t.id, 'click', function() {\n\t\t\t\tif (!t.isDisabled()) {\n\t\t\t\t\tif (s.onclick)\n\t\t\t\t\t\ts.onclick(t.value);\n\n\t\t\t\t\tt.showMenu();\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each;\n\n\ttinymce.create('tinymce.ui.SplitButton:tinymce.ui.MenuButton', {\n\t\tSplitButton : function(id, s, ed) {\n\t\t\tthis.parent(id, s, ed);\n\t\t\tthis.classPrefix = 'mceSplitButton';\n\t\t},\n\n\t\trenderHTML : function() {\n\t\t\tvar h, t = this, s = t.settings, h1;\n\n\t\t\th = '<tbody><tr>';\n\n\t\t\tif (s.image)\n\t\t\t\th1 = DOM.createHTML('img ', {src : s.image, role: 'presentation', 'class' : 'mceAction ' + s['class']});\n\t\t\telse\n\t\t\t\th1 = DOM.createHTML('span', {'class' : 'mceAction ' + s['class']}, '');\n\n\t\t\th1 += DOM.createHTML('span', {'class': 'mceVoiceLabel mceIconOnly', id: t.id + '_voice', style: 'display:none;'}, s.title);\n\t\t\th += '<td >' + DOM.createHTML('a', {role: 'button', id : t.id + '_action', tabindex: '-1', href : 'javascript:;', 'class' : 'mceAction ' + s['class'], onclick : \"return false;\", onmousedown : 'return false;', title : s.title}, h1) + '</td>';\n\t\n\t\t\th1 = DOM.createHTML('span', {'class' : 'mceOpen ' + s['class']}, '<span style=\"display:none;\" class=\"mceIconOnly\" aria-hidden=\"true\">\\u25BC</span>');\n\t\t\th += '<td >' + DOM.createHTML('a', {role: 'button', id : t.id + '_open', tabindex: '-1', href : 'javascript:;', 'class' : 'mceOpen ' + s['class'], onclick : \"return false;\", onmousedown : 'return false;', title : s.title}, h1) + '</td>';\n\n\t\t\th += '</tr></tbody>';\n\t\t\th = DOM.createHTML('table', { role: 'presentation',   'class' : 'mceSplitButton mceSplitButtonEnabled ' + s['class'], cellpadding : '0', cellspacing : '0', title : s.title}, h);\n\t\t\treturn DOM.createHTML('div', {id : t.id, role: 'button', tabindex: '0', 'aria-labelledby': t.id + '_voice', 'aria-haspopup': 'true'}, h);\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, s = t.settings, activate;\n\n\t\t\tif (s.onclick) {\n\t\t\t\tactivate = function(evt) {\n\t\t\t\t\tif (!t.isDisabled()) {\n\t\t\t\t\t\ts.onclick(t.value);\n\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t\tEvent.add(t.id + '_action', 'click', activate);\n\t\t\t\tEvent.add(t.id, ['click', 'keydown'], function(evt) {\n\t\t\t\t\tvar DOM_VK_SPACE = 32, DOM_VK_ENTER = 14, DOM_VK_RETURN = 13, DOM_VK_UP = 38, DOM_VK_DOWN = 40;\n\t\t\t\t\tif ((evt.keyCode === 32 || evt.keyCode === 13 || evt.keyCode === 14) && !evt.altKey && !evt.ctrlKey && !evt.metaKey) {\n\t\t\t\t\t\tactivate();\n\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t} else if (evt.type === 'click' || evt.keyCode === DOM_VK_DOWN) {\n\t\t\t\t\t\tt.showMenu();\n\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tEvent.add(t.id + '_open', 'click', function (evt) {\n\t\t\t\tt.showMenu();\n\t\t\t\tEvent.cancel(evt);\n\t\t\t});\n\t\t\tEvent.add([t.id, t.id + '_open'], 'focus', function() {t._focused = 1;});\n\t\t\tEvent.add([t.id, t.id + '_open'], 'blur', function() {t._focused = 0;});\n\n\t\t\t// Old IE doesn't have hover on all elements\n\t\t\tif (tinymce.isIE6 || !DOM.boxModel) {\n\t\t\t\tEvent.add(t.id, 'mouseover', function() {\n\t\t\t\t\tif (!DOM.hasClass(t.id, 'mceSplitButtonDisabled'))\n\t\t\t\t\t\tDOM.addClass(t.id, 'mceSplitButtonHover');\n\t\t\t\t});\n\n\t\t\t\tEvent.add(t.id, 'mouseout', function() {\n\t\t\t\t\tif (!DOM.hasClass(t.id, 'mceSplitButtonDisabled'))\n\t\t\t\t\t\tDOM.removeClass(t.id, 'mceSplitButtonHover');\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tthis.parent();\n\n\t\t\tEvent.clear(this.id + '_action');\n\t\t\tEvent.clear(this.id + '_open');\n\t\t\tEvent.clear(this.id);\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, is = tinymce.is, each = tinymce.each;\n\n\ttinymce.create('tinymce.ui.ColorSplitButton:tinymce.ui.SplitButton', {\n\t\tColorSplitButton : function(id, s, ed) {\n\t\t\tvar t = this;\n\n\t\t\tt.parent(id, s, ed);\n\n\t\t\tt.settings = s = tinymce.extend({\n\t\t\t\tcolors : '000000,993300,333300,003300,003366,000080,333399,333333,800000,FF6600,808000,008000,008080,0000FF,666699,808080,FF0000,FF9900,99CC00,339966,33CCCC,3366FF,800080,999999,FF00FF,FFCC00,FFFF00,00FF00,00FFFF,00CCFF,993366,C0C0C0,FF99CC,FFCC99,FFFF99,CCFFCC,CCFFFF,99CCFF,CC99FF,FFFFFF',\n\t\t\t\tgrid_width : 8,\n\t\t\t\tdefault_color : '#888888'\n\t\t\t}, t.settings);\n\n\t\t\tt.onShowMenu = new tinymce.util.Dispatcher(t);\n\n\t\t\tt.onHideMenu = new tinymce.util.Dispatcher(t);\n\n\t\t\tt.value = s.default_color;\n\t\t},\n\n\t\tshowMenu : function() {\n\t\t\tvar t = this, r, p, e, p2;\n\n\t\t\tif (t.isDisabled())\n\t\t\t\treturn;\n\n\t\t\tif (!t.isMenuRendered) {\n\t\t\t\tt.renderMenu();\n\t\t\t\tt.isMenuRendered = true;\n\t\t\t}\n\n\t\t\tif (t.isMenuVisible)\n\t\t\t\treturn t.hideMenu();\n\n\t\t\te = DOM.get(t.id);\n\t\t\tDOM.show(t.id + '_menu');\n\t\t\tDOM.addClass(e, 'mceSplitButtonSelected');\n\t\t\tp2 = DOM.getPos(e);\n\t\t\tDOM.setStyles(t.id + '_menu', {\n\t\t\t\tleft : p2.x,\n\t\t\t\ttop : p2.y + e.clientHeight,\n\t\t\t\tzIndex : 200000\n\t\t\t});\n\t\t\te = 0;\n\n\t\t\tEvent.add(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\tt.onShowMenu.dispatch(t);\n\n\t\t\tif (t._focused) {\n\t\t\t\tt._keyHandler = Event.add(t.id + '_menu', 'keydown', function(e) {\n\t\t\t\t\tif (e.keyCode == 27)\n\t\t\t\t\t\tt.hideMenu();\n\t\t\t\t});\n\n\t\t\t\tDOM.select('a', t.id + '_menu')[0].focus(); // Select first link\n\t\t\t}\n\n\t\t\tt.isMenuVisible = 1;\n\t\t},\n\n\t\thideMenu : function(e) {\n\t\t\tvar t = this;\n\n\t\t\tif (t.isMenuVisible) {\n\t\t\t\t// Prevent double toogles by canceling the mouse click event to the button\n\t\t\t\tif (e && e.type == \"mousedown\" && DOM.getParent(e.target, function(e) {return e.id === t.id + '_open';}))\n\t\t\t\t\treturn;\n\n\t\t\t\tif (!e || !DOM.getParent(e.target, '.mceSplitButtonMenu')) {\n\t\t\t\t\tDOM.removeClass(t.id, 'mceSplitButtonSelected');\n\t\t\t\t\tEvent.remove(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\t\t\tEvent.remove(t.id + '_menu', 'keydown', t._keyHandler);\n\t\t\t\t\tDOM.hide(t.id + '_menu');\n\t\t\t\t}\n\n\t\t\t\tt.isMenuVisible = 0;\n\t\t\t\tt.onHideMenu.dispatch();\n\t\t\t}\n\t\t},\n\n\t\trenderMenu : function() {\n\t\t\tvar t = this, m, i = 0, s = t.settings, n, tb, tr, w, context;\n\n\t\t\tw = DOM.add(s.menu_container, 'div', {role: 'listbox', id : t.id + '_menu', 'class' : s['menu_class'] + ' ' + s['class'], style : 'position:absolute;left:0;top:-1000px;'});\n\t\t\tm = DOM.add(w, 'div', {'class' : s['class'] + ' mceSplitButtonMenu'});\n\t\t\tDOM.add(m, 'span', {'class' : 'mceMenuLine'});\n\n\t\t\tn = DOM.add(m, 'table', {role: 'presentation', 'class' : 'mceColorSplitMenu'});\n\t\t\ttb = DOM.add(n, 'tbody');\n\n\t\t\t// Generate color grid\n\t\t\ti = 0;\n\t\t\teach(is(s.colors, 'array') ? s.colors : s.colors.split(','), function(c) {\n\t\t\t\tc = c.replace(/^#/, '');\n\n\t\t\t\tif (!i--) {\n\t\t\t\t\ttr = DOM.add(tb, 'tr');\n\t\t\t\t\ti = s.grid_width - 1;\n\t\t\t\t}\n\n\t\t\t\tn = DOM.add(tr, 'td');\n\t\t\t\tn = DOM.add(n, 'a', {\n\t\t\t\t\trole : 'option',\n\t\t\t\t\thref : 'javascript:;',\n\t\t\t\t\tstyle : {\n\t\t\t\t\t\tbackgroundColor : '#' + c\n\t\t\t\t\t},\n\t\t\t\t\t'title': t.editor.getLang('colors.' + c, c),\n\t\t\t\t\t'data-mce-color' : '#' + c\n\t\t\t\t});\n\n\t\t\t\tif (t.editor.forcedHighContrastMode) {\n\t\t\t\t\tn = DOM.add(n, 'canvas', { width: 16, height: 16, 'aria-hidden': 'true' });\n\t\t\t\t\tif (n.getContext && (context = n.getContext(\"2d\"))) {\n\t\t\t\t\t\tcontext.fillStyle = '#' + c;\n\t\t\t\t\t\tcontext.fillRect(0, 0, 16, 16);\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// No point leaving a canvas element around if it's not supported for drawing on anyway.\n\t\t\t\t\t\tDOM.remove(n);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tif (s.more_colors_func) {\n\t\t\t\tn = DOM.add(tb, 'tr');\n\t\t\t\tn = DOM.add(n, 'td', {colspan : s.grid_width, 'class' : 'mceMoreColors'});\n\t\t\t\tn = DOM.add(n, 'a', {role: 'option', id : t.id + '_more', href : 'javascript:;', onclick : 'return false;', 'class' : 'mceMoreColors'}, s.more_colors_title);\n\n\t\t\t\tEvent.add(n, 'click', function(e) {\n\t\t\t\t\ts.more_colors_func.call(s.more_colors_scope || this);\n\t\t\t\t\treturn Event.cancel(e); // Cancel to fix onbeforeunload problem\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tDOM.addClass(m, 'mceColorSplitMenu');\n\t\t\t\n\t\t\tnew tinymce.ui.KeyboardNavigation({\n\t\t\t\troot: t.id + '_menu',\n\t\t\t\titems: DOM.select('a', t.id + '_menu'),\n\t\t\t\tonCancel: function() {\n\t\t\t\t\tt.hideMenu();\n\t\t\t\t\tt.focus();\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Prevent IE from scrolling and hindering click to occur #4019\n\t\t\tEvent.add(t.id + '_menu', 'mousedown', function(e) {return Event.cancel(e);});\n\n\t\t\tEvent.add(t.id + '_menu', 'click', function(e) {\n\t\t\t\tvar c;\n\n\t\t\t\te = DOM.getParent(e.target, 'a', tb);\n\n\t\t\t\tif (e && e.nodeName.toLowerCase() == 'a' && (c = e.getAttribute('data-mce-color')))\n\t\t\t\t\tt.setColor(c);\n\n\t\t\t\treturn Event.cancel(e); // Prevent IE auto save warning\n\t\t\t});\n\n\t\t\treturn w;\n\t\t},\n\n\t\tsetColor : function(c) {\n\t\t\tthis.displayColor(c);\n\t\t\tthis.hideMenu();\n\t\t\tthis.settings.onselect(c);\n\t\t},\n\t\t\n\t\tdisplayColor : function(c) {\n\t\t\tvar t = this;\n\n\t\t\tDOM.setStyle(t.id + '_preview', 'backgroundColor', c);\n\n\t\t\tt.value = c;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, id = t.id;\n\n\t\t\tt.parent();\n\t\t\tDOM.add(id + '_action', 'div', {id : id + '_preview', 'class' : 'mceColorPreview'});\n\t\t\tDOM.setStyle(t.id + '_preview', 'backgroundColor', t.value);\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tthis.parent();\n\n\t\t\tEvent.clear(this.id + '_menu');\n\t\t\tEvent.clear(this.id + '_more');\n\t\t\tDOM.remove(this.id + '_menu');\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n// Shorten class names\nvar dom = tinymce.DOM, each = tinymce.each, Event = tinymce.dom.Event;\ntinymce.create('tinymce.ui.ToolbarGroup:tinymce.ui.Container', {\n\trenderHTML : function() {\n\t\tvar t = this, h = [], controls = t.controls, each = tinymce.each, settings = t.settings;\n\n\t\th.push('<div id=\"' + t.id + '\" role=\"group\" aria-labelledby=\"' + t.id + '_voice\">');\n\t\t//TODO: ACC test this out - adding a role = application for getting the landmarks working well.\n\t\th.push(\"<span role='application'>\");\n\t\th.push('<span id=\"' + t.id + '_voice\" class=\"mceVoiceLabel\" style=\"display:none;\">' + dom.encode(settings.name) + '</span>');\n\t\teach(controls, function(toolbar) {\n\t\t\th.push(toolbar.renderHTML());\n\t\t});\n\t\th.push(\"</span>\");\n\t\th.push('</div>');\n\n\t\treturn h.join('');\n\t},\n\t\n\tfocus : function() {\n\t\tvar t = this;\n\t\tdom.get(t.id).focus();\n\t},\n\t\n\tpostRender : function() {\n\t\tvar t = this, items = [];\n\n\t\teach(t.controls, function(toolbar) {\n\t\t\teach (toolbar.controls, function(control) {\n\t\t\t\tif (control.id) {\n\t\t\t\t\titems.push(control);\n\t\t\t\t}\n\t\t\t});\n\t\t});\n\n\t\tt.keyNav = new tinymce.ui.KeyboardNavigation({\n\t\t\troot: t.id,\n\t\t\titems: items,\n\t\t\tonCancel: function() {\n\t\t\t\t//Move focus if webkit so that navigation back will read the item.\n\t\t\t\tif (tinymce.isWebKit) {\n\t\t\t\t\tdom.get(t.editor.id+\"_ifr\").focus();\n\t\t\t\t}\n\t\t\t\tt.editor.focus();\n\t\t\t},\n\t\t\texcludeFromTabOrder: !t.settings.tab_focus_toolbar\n\t\t});\n\t},\n\t\n\tdestroy : function() {\n\t\tvar self = this;\n\n\t\tself.parent();\n\t\tself.keyNav.destroy();\n\t\tEvent.clear(self.id);\n\t}\n});\n})(tinymce);\n\n(function(tinymce) {\n// Shorten class names\nvar dom = tinymce.DOM, each = tinymce.each;\ntinymce.create('tinymce.ui.Toolbar:tinymce.ui.Container', {\n\trenderHTML : function() {\n\t\tvar t = this, h = '', c, co, s = t.settings, i, pr, nx, cl;\n\n\t\tcl = t.controls;\n\t\tfor (i=0; i<cl.length; i++) {\n\t\t\t// Get current control, prev control, next control and if the control is a list box or not\n\t\t\tco = cl[i];\n\t\t\tpr = cl[i - 1];\n\t\t\tnx = cl[i + 1];\n\n\t\t\t// Add toolbar start\n\t\t\tif (i === 0) {\n\t\t\t\tc = 'mceToolbarStart';\n\n\t\t\t\tif (co.Button)\n\t\t\t\t\tc += ' mceToolbarStartButton';\n\t\t\t\telse if (co.SplitButton)\n\t\t\t\t\tc += ' mceToolbarStartSplitButton';\n\t\t\t\telse if (co.ListBox)\n\t\t\t\t\tc += ' mceToolbarStartListBox';\n\n\t\t\t\th += dom.createHTML('td', {'class' : c}, dom.createHTML('span', null, '<!-- IE -->'));\n\t\t\t}\n\n\t\t\t// Add toolbar end before list box and after the previous button\n\t\t\t// This is to fix the o2k7 editor skins\n\t\t\tif (pr && co.ListBox) {\n\t\t\t\tif (pr.Button || pr.SplitButton)\n\t\t\t\t\th += dom.createHTML('td', {'class' : 'mceToolbarEnd'}, dom.createHTML('span', null, '<!-- IE -->'));\n\t\t\t}\n\n\t\t\t// Render control HTML\n\n\t\t\t// IE 8 quick fix, needed to propertly generate a hit area for anchors\n\t\t\tif (dom.stdMode)\n\t\t\t\th += '<td style=\"position: relative\">' + co.renderHTML() + '</td>';\n\t\t\telse\n\t\t\t\th += '<td>' + co.renderHTML() + '</td>';\n\n\t\t\t// Add toolbar start after list box and before the next button\n\t\t\t// This is to fix the o2k7 editor skins\n\t\t\tif (nx && co.ListBox) {\n\t\t\t\tif (nx.Button || nx.SplitButton)\n\t\t\t\t\th += dom.createHTML('td', {'class' : 'mceToolbarStart'}, dom.createHTML('span', null, '<!-- IE -->'));\n\t\t\t}\n\t\t}\n\n\t\tc = 'mceToolbarEnd';\n\n\t\tif (co.Button)\n\t\t\tc += ' mceToolbarEndButton';\n\t\telse if (co.SplitButton)\n\t\t\tc += ' mceToolbarEndSplitButton';\n\t\telse if (co.ListBox)\n\t\t\tc += ' mceToolbarEndListBox';\n\n\t\th += dom.createHTML('td', {'class' : c}, dom.createHTML('span', null, '<!-- IE -->'));\n\n\t\treturn dom.createHTML('table', {id : t.id, 'class' : 'mceToolbar' + (s['class'] ? ' ' + s['class'] : ''), cellpadding : '0', cellspacing : '0', align : t.settings.align || '', role: 'presentation', tabindex: '-1'}, '<tbody><tr>' + h + '</tr></tbody>');\n\t}\n});\n})(tinymce);\n\n(function(tinymce) {\n\tvar Dispatcher = tinymce.util.Dispatcher, each = tinymce.each;\n\n\ttinymce.create('tinymce.AddOnManager', {\n\t\tAddOnManager : function() {\n\t\t\tvar self = this;\n\n\t\t\tself.items = [];\n\t\t\tself.urls = {};\n\t\t\tself.lookup = {};\n\t\t\tself.onAdd = new Dispatcher(self);\n\t\t},\n\n\t\tget : function(n) {\n\t\t\tif (this.lookup[n]) {\n\t\t\t\treturn this.lookup[n].instance;\n\t\t\t} else {\n\t\t\t\treturn undefined;\n\t\t\t}\n\t\t},\n\n\t\tdependencies : function(n) {\n\t\t\tvar result;\n\t\t\tif (this.lookup[n]) {\n\t\t\t\tresult = this.lookup[n].dependencies;\n\t\t\t}\n\t\t\treturn result || [];\n\t\t},\n\n\t\trequireLangPack : function(n) {\n\t\t\tvar s = tinymce.settings;\n\n\t\t\tif (s && s.language && s.language_load !== false)\n\t\t\t\ttinymce.ScriptLoader.add(this.urls[n] + '/langs/' + s.language + '.js');\n\t\t},\n\n\t\tadd : function(id, o, dependencies) {\n\t\t\tthis.items.push(o);\n\t\t\tthis.lookup[id] = {instance:o, dependencies:dependencies};\n\t\t\tthis.onAdd.dispatch(this, id, o);\n\n\t\t\treturn o;\n\t\t},\n\t\tcreateUrl: function(baseUrl, dep) {\n\t\t\tif (typeof dep === \"object\") {\n\t\t\t\treturn dep\n\t\t\t} else {\n\t\t\t\treturn {prefix: baseUrl.prefix, resource: dep, suffix: baseUrl.suffix};\n\t\t\t}\n\t\t},\n\n\t\taddComponents: function(pluginName, scripts) {\n\t\t\tvar pluginUrl = this.urls[pluginName];\n\t\t\ttinymce.each(scripts, function(script){\n\t\t\t\ttinymce.ScriptLoader.add(pluginUrl+\"/\"+script);\t\n\t\t\t});\n\t\t},\n\n\t\tload : function(n, u, cb, s) {\n\t\t\tvar t = this, url = u;\n\n\t\t\tfunction loadDependencies() {\n\t\t\t\tvar dependencies = t.dependencies(n);\n\t\t\t\ttinymce.each(dependencies, function(dep) {\n\t\t\t\t\tvar newUrl = t.createUrl(u, dep);\n\t\t\t\t\tt.load(newUrl.resource, newUrl, undefined, undefined);\n\t\t\t\t});\n\t\t\t\tif (cb) {\n\t\t\t\t\tif (s) {\n\t\t\t\t\t\tcb.call(s);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tcb.call(tinymce.ScriptLoader);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (t.urls[n])\n\t\t\t\treturn;\n\t\t\tif (typeof u === \"object\")\n\t\t\t\turl = u.prefix + u.resource + u.suffix;\n\n\t\t\tif (url.indexOf('/') != 0 && url.indexOf('://') == -1)\n\t\t\t\turl = tinymce.baseURL + '/' + url;\n\n\t\t\tt.urls[n] = url.substring(0, url.lastIndexOf('/'));\n\n\t\t\tif (t.lookup[n]) {\n\t\t\t\tloadDependencies();\n\t\t\t} else {\n\t\t\t\ttinymce.ScriptLoader.add(url, loadDependencies, s);\n\t\t\t}\n\t\t}\n\t});\n\n\t// Create plugin and theme managers\n\ttinymce.PluginManager = new tinymce.AddOnManager();\n\ttinymce.ThemeManager = new tinymce.AddOnManager();\n}(tinymce));\n\n(function(tinymce) {\n\t// Shorten names\n\tvar each = tinymce.each, extend = tinymce.extend,\n\t\tDOM = tinymce.DOM, Event = tinymce.dom.Event,\n\t\tThemeManager = tinymce.ThemeManager, PluginManager = tinymce.PluginManager,\n\t\texplode = tinymce.explode,\n\t\tDispatcher = tinymce.util.Dispatcher, undefined, instanceCounter = 0;\n\n\t// Setup some URLs where the editor API is located and where the document is\n\ttinymce.documentBaseURL = window.location.href.replace(/[\\?#].*$/, '').replace(/[\\/\\\\][^\\/]+$/, '');\n\tif (!/[\\/\\\\]$/.test(tinymce.documentBaseURL))\n\t\ttinymce.documentBaseURL += '/';\n\n\ttinymce.baseURL = new tinymce.util.URI(tinymce.documentBaseURL).toAbsolute(tinymce.baseURL);\n\n\ttinymce.baseURI = new tinymce.util.URI(tinymce.baseURL);\n\n\t// Add before unload listener\n\t// This was required since IE was leaking memory if you added and removed beforeunload listeners\n\t// with attachEvent/detatchEvent so this only adds one listener and instances can the attach to the onBeforeUnload event\n\ttinymce.onBeforeUnload = new Dispatcher(tinymce);\n\n\t// Must be on window or IE will leak if the editor is placed in frame or iframe\n\tEvent.add(window, 'beforeunload', function(e) {\n\t\ttinymce.onBeforeUnload.dispatch(tinymce, e);\n\t});\n\n\ttinymce.onAddEditor = new Dispatcher(tinymce);\n\n\ttinymce.onRemoveEditor = new Dispatcher(tinymce);\n\n\ttinymce.EditorManager = extend(tinymce, {\n\t\teditors : [],\n\n\t\ti18n : {},\n\n\t\tactiveEditor : null,\n\n\t\tinit : function(s) {\n\t\t\tvar t = this, pl, sl = tinymce.ScriptLoader, e, el = [], ed;\n\n\t\t\tfunction execCallback(se, n, s) {\n\t\t\t\tvar f = se[n];\n\n\t\t\t\tif (!f)\n\t\t\t\t\treturn;\n\n\t\t\t\tif (tinymce.is(f, 'string')) {\n\t\t\t\t\ts = f.replace(/\\.\\w+$/, '');\n\t\t\t\t\ts = s ? tinymce.resolve(s) : 0;\n\t\t\t\t\tf = tinymce.resolve(f);\n\t\t\t\t}\n\n\t\t\t\treturn f.apply(s || this, Array.prototype.slice.call(arguments, 2));\n\t\t\t};\n\n\t\t\ts = extend({\n\t\t\t\ttheme : \"simple\",\n\t\t\t\tlanguage : \"en\"\n\t\t\t}, s);\n\n\t\t\tt.settings = s;\n\n\t\t\t// Legacy call\n\t\t\tEvent.add(document, 'init', function() {\n\t\t\t\tvar l, co;\n\n\t\t\t\texecCallback(s, 'onpageload');\n\n\t\t\t\tswitch (s.mode) {\n\t\t\t\t\tcase \"exact\":\n\t\t\t\t\t\tl = s.elements || '';\n\n\t\t\t\t\t\tif(l.length > 0) {\n\t\t\t\t\t\t\teach(explode(l), function(v) {\n\t\t\t\t\t\t\t\tif (DOM.get(v)) {\n\t\t\t\t\t\t\t\t\ted = new tinymce.Editor(v, s);\n\t\t\t\t\t\t\t\t\tel.push(ed);\n\t\t\t\t\t\t\t\t\ted.render(1);\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\teach(document.forms, function(f) {\n\t\t\t\t\t\t\t\t\t\teach(f.elements, function(e) {\n\t\t\t\t\t\t\t\t\t\t\tif (e.name === v) {\n\t\t\t\t\t\t\t\t\t\t\t\tv = 'mce_editor_' + instanceCounter++;\n\t\t\t\t\t\t\t\t\t\t\t\tDOM.setAttrib(e, 'id', v);\n\n\t\t\t\t\t\t\t\t\t\t\t\ted = new tinymce.Editor(v, s);\n\t\t\t\t\t\t\t\t\t\t\t\tel.push(ed);\n\t\t\t\t\t\t\t\t\t\t\t\ted.render(1);\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase \"textareas\":\n\t\t\t\t\tcase \"specific_textareas\":\n\t\t\t\t\t\tfunction hasClass(n, c) {\n\t\t\t\t\t\t\treturn c.constructor === RegExp ? c.test(n.className) : DOM.hasClass(n, c);\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\teach(DOM.select('textarea'), function(v) {\n\t\t\t\t\t\t\tif (s.editor_deselector && hasClass(v, s.editor_deselector))\n\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\tif (!s.editor_selector || hasClass(v, s.editor_selector)) {\n\t\t\t\t\t\t\t\t// Can we use the name\n\t\t\t\t\t\t\t\te = DOM.get(v.name);\n\t\t\t\t\t\t\t\tif (!v.id && !e)\n\t\t\t\t\t\t\t\t\tv.id = v.name;\n\n\t\t\t\t\t\t\t\t// Generate unique name if missing or already exists\n\t\t\t\t\t\t\t\tif (!v.id || t.get(v.id))\n\t\t\t\t\t\t\t\t\tv.id = DOM.uniqueId();\n\n\t\t\t\t\t\t\t\ted = new tinymce.Editor(v.id, s);\n\t\t\t\t\t\t\t\tel.push(ed);\n\t\t\t\t\t\t\t\ted.render(1);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\t// Call onInit when all editors are initialized\n\t\t\t\tif (s.oninit) {\n\t\t\t\t\tl = co = 0;\n\n\t\t\t\t\teach(el, function(ed) {\n\t\t\t\t\t\tco++;\n\n\t\t\t\t\t\tif (!ed.initialized) {\n\t\t\t\t\t\t\t// Wait for it\n\t\t\t\t\t\t\ted.onInit.add(function() {\n\t\t\t\t\t\t\t\tl++;\n\n\t\t\t\t\t\t\t\t// All done\n\t\t\t\t\t\t\t\tif (l == co)\n\t\t\t\t\t\t\t\t\texecCallback(s, 'oninit');\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\tl++;\n\n\t\t\t\t\t\t// All done\n\t\t\t\t\t\tif (l == co)\n\t\t\t\t\t\t\texecCallback(s, 'oninit');\t\t\t\t\t\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\tget : function(id) {\n\t\t\tif (id === undefined)\n\t\t\t\treturn this.editors;\n\n\t\t\treturn this.editors[id];\n\t\t},\n\n\t\tgetInstanceById : function(id) {\n\t\t\treturn this.get(id);\n\t\t},\n\n\t\tadd : function(editor) {\n\t\t\tvar self = this, editors = self.editors;\n\n\t\t\t// Add named and index editor instance\n\t\t\teditors[editor.id] = editor;\n\t\t\teditors.push(editor);\n\n\t\t\tself._setActive(editor);\n\t\t\tself.onAddEditor.dispatch(self, editor);\n\n\n\t\t\treturn editor;\n\t\t},\n\n\t\tremove : function(editor) {\n\t\t\tvar t = this, i, editors = t.editors;\n\n\t\t\t// Not in the collection\n\t\t\tif (!editors[editor.id])\n\t\t\t\treturn null;\n\n\t\t\tdelete editors[editor.id];\n\n\t\t\tfor (i = 0; i < editors.length; i++) {\n\t\t\t\tif (editors[i] == editor) {\n\t\t\t\t\teditors.splice(i, 1);\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Select another editor since the active one was removed\n\t\t\tif (t.activeEditor == editor)\n\t\t\t\tt._setActive(editors[0]);\n\n\t\t\teditor.destroy();\n\t\t\tt.onRemoveEditor.dispatch(t, editor);\n\n\t\t\treturn editor;\n\t\t},\n\n\t\texecCommand : function(c, u, v) {\n\t\t\tvar t = this, ed = t.get(v), w;\n\n\t\t\t// Manager commands\n\t\t\tswitch (c) {\n\t\t\t\tcase \"mceFocus\":\n\t\t\t\t\ted.focus();\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase \"mceAddEditor\":\n\t\t\t\tcase \"mceAddControl\":\n\t\t\t\t\tif (!t.get(v))\n\t\t\t\t\t\tnew tinymce.Editor(v, t.settings).render();\n\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase \"mceAddFrameControl\":\n\t\t\t\t\tw = v.window;\n\n\t\t\t\t\t// Add tinyMCE global instance and tinymce namespace to specified window\n\t\t\t\t\tw.tinyMCE = tinyMCE;\n\t\t\t\t\tw.tinymce = tinymce;\n\n\t\t\t\t\ttinymce.DOM.doc = w.document;\n\t\t\t\t\ttinymce.DOM.win = w;\n\n\t\t\t\t\ted = new tinymce.Editor(v.element_id, v);\n\t\t\t\t\ted.render();\n\n\t\t\t\t\t// Fix IE memory leaks\n\t\t\t\t\tif (tinymce.isIE) {\n\t\t\t\t\t\tfunction clr() {\n\t\t\t\t\t\t\ted.destroy();\n\t\t\t\t\t\t\tw.detachEvent('onunload', clr);\n\t\t\t\t\t\t\tw = w.tinyMCE = w.tinymce = null; // IE leak\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tw.attachEvent('onunload', clr);\n\t\t\t\t\t}\n\n\t\t\t\t\tv.page_window = null;\n\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase \"mceRemoveEditor\":\n\t\t\t\tcase \"mceRemoveControl\":\n\t\t\t\t\tif (ed)\n\t\t\t\t\t\ted.remove();\n\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase 'mceToggleEditor':\n\t\t\t\t\tif (!ed) {\n\t\t\t\t\t\tt.execCommand('mceAddControl', 0, v);\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (ed.isHidden())\n\t\t\t\t\t\ted.show();\n\t\t\t\t\telse\n\t\t\t\t\t\ted.hide();\n\n\t\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Run command on active editor\n\t\t\tif (t.activeEditor)\n\t\t\t\treturn t.activeEditor.execCommand(c, u, v);\n\n\t\t\treturn false;\n\t\t},\n\n\t\texecInstanceCommand : function(id, c, u, v) {\n\t\t\tvar ed = this.get(id);\n\n\t\t\tif (ed)\n\t\t\t\treturn ed.execCommand(c, u, v);\n\n\t\t\treturn false;\n\t\t},\n\n\t\ttriggerSave : function() {\n\t\t\teach(this.editors, function(e) {\n\t\t\t\te.save();\n\t\t\t});\n\t\t},\n\n\t\taddI18n : function(p, o) {\n\t\t\tvar lo, i18n = this.i18n;\n\n\t\t\tif (!tinymce.is(p, 'string')) {\n\t\t\t\teach(p, function(o, lc) {\n\t\t\t\t\teach(o, function(o, g) {\n\t\t\t\t\t\teach(o, function(o, k) {\n\t\t\t\t\t\t\tif (g === 'common')\n\t\t\t\t\t\t\t\ti18n[lc + '.' + k] = o;\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\ti18n[lc + '.' + g + '.' + k] = o;\n\t\t\t\t\t\t});\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\teach(o, function(o, k) {\n\t\t\t\t\ti18n[p + '.' + k] = o;\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\t// Private methods\n\n\t\t_setActive : function(editor) {\n\t\t\tthis.selectedInstance = this.activeEditor = editor;\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\t// Shorten these names\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, extend = tinymce.extend,\n\t\tDispatcher = tinymce.util.Dispatcher, each = tinymce.each, isGecko = tinymce.isGecko,\n\t\tisIE = tinymce.isIE, isWebKit = tinymce.isWebKit, is = tinymce.is,\n\t\tThemeManager = tinymce.ThemeManager, PluginManager = tinymce.PluginManager,\n\t\tinArray = tinymce.inArray, grep = tinymce.grep, explode = tinymce.explode;\n\n\ttinymce.create('tinymce.Editor', {\n\t\tEditor : function(id, s) {\n\t\t\tvar t = this;\n\n\t\t\tt.id = t.editorId = id;\n\n\t\t\tt.execCommands = {};\n\t\t\tt.queryStateCommands = {};\n\t\t\tt.queryValueCommands = {};\n\n\t\t\tt.isNotDirty = false;\n\n\t\t\tt.plugins = {};\n\n\t\t\t// Add events to the editor\n\t\t\teach([\n\t\t\t\t'onPreInit',\n\n\t\t\t\t'onBeforeRenderUI',\n\n\t\t\t\t'onPostRender',\n\n\t\t\t\t'onInit',\n\n\t\t\t\t'onRemove',\n\n\t\t\t\t'onActivate',\n\n\t\t\t\t'onDeactivate',\n\n\t\t\t\t'onClick',\n\n\t\t\t\t'onEvent',\n\n\t\t\t\t'onMouseUp',\n\n\t\t\t\t'onMouseDown',\n\n\t\t\t\t'onDblClick',\n\n\t\t\t\t'onKeyDown',\n\n\t\t\t\t'onKeyUp',\n\n\t\t\t\t'onKeyPress',\n\n\t\t\t\t'onContextMenu',\n\n\t\t\t\t'onSubmit',\n\n\t\t\t\t'onReset',\n\n\t\t\t\t'onPaste',\n\n\t\t\t\t'onPreProcess',\n\n\t\t\t\t'onPostProcess',\n\n\t\t\t\t'onBeforeSetContent',\n\n\t\t\t\t'onBeforeGetContent',\n\n\t\t\t\t'onSetContent',\n\n\t\t\t\t'onGetContent',\n\n\t\t\t\t'onLoadContent',\n\n\t\t\t\t'onSaveContent',\n\n\t\t\t\t'onNodeChange',\n\n\t\t\t\t'onChange',\n\n\t\t\t\t'onBeforeExecCommand',\n\n\t\t\t\t'onExecCommand',\n\n\t\t\t\t'onUndo',\n\n\t\t\t\t'onRedo',\n\n\t\t\t\t'onVisualAid',\n\n\t\t\t\t'onSetProgressState'\n\t\t\t], function(e) {\n\t\t\t\tt[e] = new Dispatcher(t);\n\t\t\t});\n\n\t\t\tt.settings = s = extend({\n\t\t\t\tid : id,\n\t\t\t\tlanguage : 'en',\n\t\t\t\tdocs_language : 'en',\n\t\t\t\ttheme : 'simple',\n\t\t\t\tskin : 'default',\n\t\t\t\tdelta_width : 0,\n\t\t\t\tdelta_height : 0,\n\t\t\t\tpopup_css : '',\n\t\t\t\tplugins : '',\n\t\t\t\tdocument_base_url : tinymce.documentBaseURL,\n\t\t\t\tadd_form_submit_trigger : 1,\n\t\t\t\tsubmit_patch : 1,\n\t\t\t\tadd_unload_trigger : 1,\n\t\t\t\tconvert_urls : 1,\n\t\t\t\trelative_urls : 1,\n\t\t\t\tremove_script_host : 1,\n\t\t\t\ttable_inline_editing : 0,\n\t\t\t\tobject_resizing : 1,\n\t\t\t\tcleanup : 1,\n\t\t\t\taccessibility_focus : 1,\n\t\t\t\tcustom_shortcuts : 1,\n\t\t\t\tcustom_undo_redo_keyboard_shortcuts : 1,\n\t\t\t\tcustom_undo_redo_restore_selection : 1,\n\t\t\t\tcustom_undo_redo : 1,\n\t\t\t\tdoctype : tinymce.isIE6 ? '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">' : '<!DOCTYPE>', // Use old doctype on IE 6 to avoid horizontal scroll\n\t\t\t\tvisual_table_class : 'mceItemTable',\n\t\t\t\tvisual : 1,\n\t\t\t\tfont_size_style_values : 'xx-small,x-small,small,medium,large,x-large,xx-large',\n\t\t\t\tfont_size_legacy_values : 'xx-small,small,medium,large,x-large,xx-large,300%', // See: http://www.w3.org/TR/CSS2/fonts.html#propdef-font-size\n\t\t\t\tapply_source_formatting : 1,\n\t\t\t\tdirectionality : 'ltr',\n\t\t\t\tforced_root_block : 'p',\n\t\t\t\thidden_input : 1,\n\t\t\t\tpadd_empty_editor : 1,\n\t\t\t\trender_ui : 1,\n\t\t\t\tinit_theme : 1,\n\t\t\t\tforce_p_newlines : 1,\n\t\t\t\tindentation : '30px',\n\t\t\t\tkeep_styles : 1,\n\t\t\t\tfix_table_elements : 1,\n\t\t\t\tinline_styles : 1,\n\t\t\t\tconvert_fonts_to_spans : true,\n\t\t\t\tindent : 'simple',\n\t\t\t\tindent_before : 'p,h1,h2,h3,h4,h5,h6,blockquote,div,title,style,pre,script,td,ul,li,area,table,thead,tfoot,tbody,tr',\n\t\t\t\tindent_after : 'p,h1,h2,h3,h4,h5,h6,blockquote,div,title,style,pre,script,td,ul,li,area,table,thead,tfoot,tbody,tr',\n\t\t\t\tvalidate : true,\n\t\t\t\tentity_encoding : 'named',\n\t\t\t\turl_converter : t.convertURL,\n\t\t\t\turl_converter_scope : t,\n\t\t\t\tie7_compat : true\n\t\t\t}, s);\n\n\t\t\tt.documentBaseURI = new tinymce.util.URI(s.document_base_url || tinymce.documentBaseURL, {\n\t\t\t\tbase_uri : tinyMCE.baseURI\n\t\t\t});\n\n\t\t\tt.baseURI = tinymce.baseURI;\n\n\t\t\tt.contentCSS = [];\n\n\t\t\t// Call setup\n\t\t\tt.execCallback('setup', t);\n\t\t},\n\n\t\trender : function(nst) {\n\t\t\tvar t = this, s = t.settings, id = t.id, sl = tinymce.ScriptLoader;\n\n\t\t\t// Page is not loaded yet, wait for it\n\t\t\tif (!Event.domLoaded) {\n\t\t\t\tEvent.add(document, 'init', function() {\n\t\t\t\t\tt.render();\n\t\t\t\t});\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\ttinyMCE.settings = s;\n\n\t\t\t// Element not found, then skip initialization\n\t\t\tif (!t.getElement())\n\t\t\t\treturn;\n\n\t\t\t// Is a iPad/iPhone and not on iOS5, then skip initialization. We need to sniff \n\t\t\t// here since the browser says it has contentEditable support but there is no visible\n\t\t\t// caret We will remove this check ones Apple implements full contentEditable support\n\t\t\tif (tinymce.isIDevice && !tinymce.isIOS5)\n\t\t\t\treturn;\n\n\t\t\t// Add hidden input for non input elements inside form elements\n\t\t\tif (!/TEXTAREA|INPUT/i.test(t.getElement().nodeName) && s.hidden_input && DOM.getParent(id, 'form'))\n\t\t\t\tDOM.insertAfter(DOM.create('input', {type : 'hidden', name : id}), id);\n\n\t\t\tif (tinymce.WindowManager)\n\t\t\t\tt.windowManager = new tinymce.WindowManager(t);\n\n\t\t\tif (s.encoding == 'xml') {\n\t\t\t\tt.onGetContent.add(function(ed, o) {\n\t\t\t\t\tif (o.save)\n\t\t\t\t\t\to.content = DOM.encode(o.content);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.add_form_submit_trigger) {\n\t\t\t\tt.onSubmit.addToTop(function() {\n\t\t\t\t\tif (t.initialized) {\n\t\t\t\t\t\tt.save();\n\t\t\t\t\t\tt.isNotDirty = 1;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.add_unload_trigger) {\n\t\t\t\tt._beforeUnload = tinyMCE.onBeforeUnload.add(function() {\n\t\t\t\t\tif (t.initialized && !t.destroyed && !t.isHidden())\n\t\t\t\t\t\tt.save({format : 'raw', no_events : true});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\ttinymce.addUnload(t.destroy, t);\n\n\t\t\tif (s.submit_patch) {\n\t\t\t\tt.onBeforeRenderUI.add(function() {\n\t\t\t\t\tvar n = t.getElement().form;\n\n\t\t\t\t\tif (!n)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Already patched\n\t\t\t\t\tif (n._mceOldSubmit)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Check page uses id=\"submit\" or name=\"submit\" for it's submit button\n\t\t\t\t\tif (!n.submit.nodeType && !n.submit.length) {\n\t\t\t\t\t\tt.formElement = n;\n\t\t\t\t\t\tn._mceOldSubmit = n.submit;\n\t\t\t\t\t\tn.submit = function() {\n\t\t\t\t\t\t\t// Save all instances\n\t\t\t\t\t\t\ttinymce.triggerSave();\n\t\t\t\t\t\t\tt.isNotDirty = 1;\n\n\t\t\t\t\t\t\treturn t.formElement._mceOldSubmit(t.formElement);\n\t\t\t\t\t\t};\n\t\t\t\t\t}\n\n\t\t\t\t\tn = null;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Load scripts\n\t\t\tfunction loadScripts() {\n\t\t\t\tif (s.language && s.language_load !== false)\n\t\t\t\t\tsl.add(tinymce.baseURL + '/langs/' + s.language + '.js');\n\n\t\t\t\tif (s.theme && s.theme.charAt(0) != '-' && !ThemeManager.urls[s.theme])\n\t\t\t\t\tThemeManager.load(s.theme, 'themes/' + s.theme + '/editor_template' + tinymce.suffix + '.js');\n\n\t\t\t\teach(explode(s.plugins), function(p) {\n\t\t\t\t\tif (p &&!PluginManager.urls[p]) {\n\t\t\t\t\t\tif (p.charAt(0) == '-') {\n\t\t\t\t\t\t\tp = p.substr(1, p.length);\n\t\t\t\t\t\t\tvar dependencies = PluginManager.dependencies(p);\n\t\t\t\t\t\t\teach(dependencies, function(dep) {\n\t\t\t\t\t\t\t\tvar defaultSettings = {prefix:'plugins/', resource: dep, suffix:'/editor_plugin' + tinymce.suffix + '.js'};\n\t\t\t\t\t\t\t\tvar dep = PluginManager.createUrl(defaultSettings, dep);\n\t\t\t\t\t\t\t\tPluginManager.load(dep.resource, dep);\n\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Skip safari plugin, since it is removed as of 3.3b1\n\t\t\t\t\t\t\tif (p == 'safari') {\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tPluginManager.load(p, {prefix:'plugins/', resource: p, suffix:'/editor_plugin' + tinymce.suffix + '.js'});\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// Init when que is loaded\n\t\t\t\tsl.loadQueue(function() {\n\t\t\t\t\tif (!t.removed)\n\t\t\t\t\t\tt.init();\n\t\t\t\t});\n\t\t\t};\n\n\t\t\tloadScripts();\n\t\t},\n\n\t\tinit : function() {\n\t\t\tvar n, t = this, s = t.settings, w, h, e = t.getElement(), o, ti, u, bi, bc, re, i, initializedPlugins = [];\n\n\t\t\ttinymce.add(t);\n\n\t\t\ts.aria_label = s.aria_label || DOM.getAttrib(e, 'aria-label', t.getLang('aria.rich_text_area'));\n\n\t\t\tif (s.theme) {\n\t\t\t\ts.theme = s.theme.replace(/-/, '');\n\t\t\t\to = ThemeManager.get(s.theme);\n\t\t\t\tt.theme = new o();\n\n\t\t\t\tif (t.theme.init && s.init_theme)\n\t\t\t\t\tt.theme.init(t, ThemeManager.urls[s.theme] || tinymce.documentBaseURL.replace(/\\/$/, ''));\n\t\t\t}\n\t\t\tfunction initPlugin(p) {\n\t\t\t\tvar c = PluginManager.get(p), u = PluginManager.urls[p] || tinymce.documentBaseURL.replace(/\\/$/, ''), po;\n\t\t\t\tif (c && tinymce.inArray(initializedPlugins,p) === -1) {\n\t\t\t\t\teach(PluginManager.dependencies(p), function(dep){\n\t\t\t\t\t\tinitPlugin(dep);\n\t\t\t\t\t});\n\t\t\t\t\tpo = new c(t, u);\n\n\t\t\t\t\tt.plugins[p] = po;\n\n\t\t\t\t\tif (po.init) {\n\t\t\t\t\t\tpo.init(t, u);\n\t\t\t\t\t\tinitializedPlugins.push(p);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\t\n\t\t\t// Create all plugins\n\t\t\teach(explode(s.plugins.replace(/\\-/g, '')), initPlugin);\n\n\t\t\t// Setup popup CSS path(s)\n\t\t\tif (s.popup_css !== false) {\n\t\t\t\tif (s.popup_css)\n\t\t\t\t\ts.popup_css = t.documentBaseURI.toAbsolute(s.popup_css);\n\t\t\t\telse\n\t\t\t\t\ts.popup_css = t.baseURI.toAbsolute(\"themes/\" + s.theme + \"/skins/\" + s.skin + \"/dialog.css\");\n\t\t\t}\n\n\t\t\tif (s.popup_css_add)\n\t\t\t\ts.popup_css += ',' + t.documentBaseURI.toAbsolute(s.popup_css_add);\n\n\t\t\tt.controlManager = new tinymce.ControlManager(t);\n\n\t\t\tif (s.custom_undo_redo) {\n\t\t\t\tt.onBeforeExecCommand.add(function(ed, cmd, ui, val, a) {\n\t\t\t\t\tif (cmd != 'Undo' && cmd != 'Redo' && cmd != 'mceRepaint' && (!a || !a.skip_undo))\n\t\t\t\t\t\tt.undoManager.beforeChange();\n\t\t\t\t});\n\n\t\t\t\tt.onExecCommand.add(function(ed, cmd, ui, val, a) {\n\t\t\t\t\tif (cmd != 'Undo' && cmd != 'Redo' && cmd != 'mceRepaint' && (!a || !a.skip_undo))\n\t\t\t\t\t\tt.undoManager.add();\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tt.onExecCommand.add(function(ed, c) {\n\t\t\t\t// Don't refresh the select lists until caret move\n\t\t\t\tif (!/^(FontName|FontSize)$/.test(c))\n\t\t\t\t\tt.nodeChanged();\n\t\t\t});\n\n\t\t\t// Remove ghost selections on images and tables in Gecko\n\t\t\tif (isGecko) {\n\t\t\t\tfunction repaint(a, o) {\n\t\t\t\t\tif (!o || !o.initial)\n\t\t\t\t\t\tt.execCommand('mceRepaint');\n\t\t\t\t};\n\n\t\t\t\tt.onUndo.add(repaint);\n\t\t\t\tt.onRedo.add(repaint);\n\t\t\t\tt.onSetContent.add(repaint);\n\t\t\t}\n\n\t\t\t// Enables users to override the control factory\n\t\t\tt.onBeforeRenderUI.dispatch(t, t.controlManager);\n\n\t\t\t// Measure box\n\t\t\tif (s.render_ui) {\n\t\t\t\tw = s.width || e.style.width || e.offsetWidth;\n\t\t\t\th = s.height || e.style.height || e.offsetHeight;\n\t\t\t\tt.orgDisplay = e.style.display;\n\t\t\t\tre = /^[0-9\\.]+(|px)$/i;\n\n\t\t\t\tif (re.test('' + w))\n\t\t\t\t\tw = Math.max(parseInt(w) + (o.deltaWidth || 0), 100);\n\n\t\t\t\tif (re.test('' + h))\n\t\t\t\t\th = Math.max(parseInt(h) + (o.deltaHeight || 0), 100);\n\n\t\t\t\t// Render UI\n\t\t\t\to = t.theme.renderUI({\n\t\t\t\t\ttargetNode : e,\n\t\t\t\t\twidth : w,\n\t\t\t\t\theight : h,\n\t\t\t\t\tdeltaWidth : s.delta_width,\n\t\t\t\t\tdeltaHeight : s.delta_height\n\t\t\t\t});\n\n\t\t\t\tt.editorContainer = o.editorContainer;\n\t\t\t}\n\n\n\t\t\t// User specified a document.domain value\n\t\t\tif (document.domain && location.hostname != document.domain)\n\t\t\t\ttinymce.relaxedDomain = document.domain;\n\n\t\t\t// Resize editor\n\t\t\tDOM.setStyles(o.sizeContainer || o.editorContainer, {\n\t\t\t\twidth : w,\n\t\t\t\theight : h\n\t\t\t});\n\n\t\t\t// Load specified content CSS last\n\t\t\tif (s.content_css) {\n\t\t\t\ttinymce.each(explode(s.content_css), function(u) {\n\t\t\t\t\tt.contentCSS.push(t.documentBaseURI.toAbsolute(u));\n\t\t\t\t});\n\t\t\t}\n\n\t\t\th = (o.iframeHeight || h) + (typeof(h) == 'number' ? (o.deltaHeight || 0) : '');\n\t\t\tif (h < 100)\n\t\t\t\th = 100;\n\n\t\t\tt.iframeHTML = s.doctype + '<html><head xmlns=\"http://www.w3.org/1999/xhtml\">';\n\n\t\t\t// We only need to override paths if we have to\n\t\t\t// IE has a bug where it remove site absolute urls to relative ones if this is specified\n\t\t\tif (s.document_base_url != tinymce.documentBaseURL)\n\t\t\t\tt.iframeHTML += '<base href=\"' + t.documentBaseURI.getURI() + '\" />';\n\n\t\t\t// IE8 doesn't support carets behind images setting ie7_compat would force IE8+ to run in IE7 compat mode.\n\t\t\tif (s.ie7_compat)\n\t\t\t\tt.iframeHTML += '<meta http-equiv=\"X-UA-Compatible\" content=\"IE=7\" />';\n\t\t\telse\n\t\t\t\tt.iframeHTML += '<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />';\n\n\t\t\tt.iframeHTML += '<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />';\n\n\t\t\t// Load the CSS by injecting them into the HTML this will reduce \"flicker\"\n\t\t\tfor (i = 0; i < t.contentCSS.length; i++) {\n\t\t\t\tt.iframeHTML += '<link type=\"text/css\" rel=\"stylesheet\" href=\"' + t.contentCSS[i] + '\" />';\n\t\t\t}\n\n\t\t\tbi = s.body_id || 'tinymce';\n\t\t\tif (bi.indexOf('=') != -1) {\n\t\t\t\tbi = t.getParam('body_id', '', 'hash');\n\t\t\t\tbi = bi[t.id] || bi;\n\t\t\t}\n\n\t\t\tbc = s.body_class || '';\n\t\t\tif (bc.indexOf('=') != -1) {\n\t\t\t\tbc = t.getParam('body_class', '', 'hash');\n\t\t\t\tbc = bc[t.id] || '';\n\t\t\t}\n\n\t\t\tt.iframeHTML += '</head><body id=\"' + bi + '\" class=\"mceContentBody ' + bc + '\"><br></body></html>';\n\n\t\t\t// Domain relaxing enabled, then set document domain\n\t\t\tif (tinymce.relaxedDomain && (isIE || (tinymce.isOpera && parseFloat(opera.version()) < 11))) {\n\t\t\t\t// We need to write the contents here in IE since multiple writes messes up refresh button and back button\n\t\t\t\tu = 'javascript:(function(){document.open();document.domain=\"' + document.domain + '\";var ed = window.parent.tinyMCE.get(\"' + t.id + '\");document.write(ed.iframeHTML);document.close();ed.setupIframe();})()';\n\t\t\t}\n\n\t\t\t// Create iframe\n\t\t\t// TODO: ACC add the appropriate description on this.\n\t\t\tn = DOM.add(o.iframeContainer, 'iframe', { \n\t\t\t\tid : t.id + \"_ifr\",\n\t\t\t\tsrc : u || 'javascript:\"\"', // Workaround for HTTPS warning in IE6/7\n\t\t\t\tframeBorder : '0',\n\t\t\t\tallowTransparency : \"true\",\n\t\t\t\ttitle : s.aria_label,\n\t\t\t\tstyle : {\n\t\t\t\t\twidth : '100%',\n\t\t\t\t\theight : h,\n\t\t\t\t\tdisplay : 'block' // Important for Gecko to render the iframe correctly\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.contentAreaContainer = o.iframeContainer;\n\t\t\tDOM.get(o.editorContainer).style.display = t.orgDisplay;\n\t\t\tDOM.get(t.id).style.display = 'none';\n\t\t\tDOM.setAttrib(t.id, 'aria-hidden', true);\n\n\t\t\tif (!tinymce.relaxedDomain || !u)\n\t\t\t\tt.setupIframe();\n\n\t\t\te = n = o = null; // Cleanup\n\t\t},\n\n\t\tsetupIframe : function() {\n\t\t\tvar t = this, s = t.settings, e = DOM.get(t.id), d = t.getDoc(), h, b;\n\n\t\t\t// Setup iframe body\n\t\t\tif (!isIE || !tinymce.relaxedDomain) {\n\t\t\t\td.open();\n\t\t\t\td.write(t.iframeHTML);\n\t\t\t\td.close();\n\n\t\t\t\tif (tinymce.relaxedDomain)\n\t\t\t\t\td.domain = tinymce.relaxedDomain;\n\t\t\t}\n\n\t\t\t// It will not steal focus while setting contentEditable\n\t\t\tb = t.getBody();\n\t\t\tb.disabled = true;\n\n\t\t\tif (!s.readonly)\n\t\t\t\tb.contentEditable = true;\n\n\t\t\tb.disabled = false;\n\n\t\t\tt.schema = new tinymce.html.Schema(s);\n\n\t\t\tt.dom = new tinymce.dom.DOMUtils(t.getDoc(), {\n\t\t\t\tkeep_values : true,\n\t\t\t\turl_converter : t.convertURL,\n\t\t\t\turl_converter_scope : t,\n\t\t\t\thex_colors : s.force_hex_style_colors,\n\t\t\t\tclass_filter : s.class_filter,\n\t\t\t\tupdate_styles : 1,\n\t\t\t\tfix_ie_paragraphs : 1,\n\t\t\t\tschema : t.schema\n\t\t\t});\n\n\t\t\tt.parser = new tinymce.html.DomParser(s, t.schema);\n\n\t\t\t// Force anchor names closed, unless the setting \"allow_html_in_named_anchor\" is explicitly included.\n\t\t\tif (!t.settings.allow_html_in_named_anchor) {\n\t\t\t\tt.parser.addAttributeFilter('name', function(nodes, name) {\n\t\t\t\t\tvar i = nodes.length, sibling, prevSibling, parent, node;\n\t\n\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\t\tif (node.name === 'a' && node.firstChild) {\n\t\t\t\t\t\t\tparent = node.parent;\n\t\n\t\t\t\t\t\t\t// Move children after current node\n\t\t\t\t\t\t\tsibling = node.lastChild;\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\tprevSibling = sibling.prev;\n\t\t\t\t\t\t\t\tparent.insert(sibling, node);\n\t\t\t\t\t\t\t\tsibling = prevSibling;\n\t\t\t\t\t\t\t} while (sibling);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Convert src and href into data-mce-src, data-mce-href and data-mce-style\n\t\t\tt.parser.addAttributeFilter('src,href,style', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node, dom = t.dom, value, internalName;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tvalue = node.attr(name);\n\t\t\t\t\tinternalName = 'data-mce-' + name;\n\n\t\t\t\t\t// Add internal attribute if we need to we don't on a refresh of the document\n\t\t\t\t\tif (!node.attributes.map[internalName]) {\t\n\t\t\t\t\t\tif (name === \"style\")\n\t\t\t\t\t\t\tnode.attr(internalName, dom.serializeStyle(dom.parseStyle(value), node.name));\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tnode.attr(internalName, t.convertURL(value, name, node.name));\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Keep scripts from executing\n\t\t\tt.parser.addNodeFilter('script', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tnode.attr('type', 'mce-' + (node.attr('type') || 'text/javascript'));\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.parser.addNodeFilter('#cdata', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tnode.type = 8;\n\t\t\t\t\tnode.name = '#comment';\n\t\t\t\t\tnode.value = '[CDATA[' + node.value + ']]';\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.parser.addNodeFilter('p,h1,h2,h3,h4,h5,h6,div', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node, nonEmptyElements = t.schema.getNonEmptyElements();\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\n\t\t\t\t\tif (node.isEmpty(nonEmptyElements))\n\t\t\t\t\t\tnode.empty().append(new tinymce.html.Node('br', 1)).shortEnded = true;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.serializer = new tinymce.dom.Serializer(s, t.dom, t.schema);\n\n\t\t\tt.selection = new tinymce.dom.Selection(t.dom, t.getWin(), t.serializer);\n\n\t\t\tt.formatter = new tinymce.Formatter(this);\n\n\t\t\t// Register default formats\n\t\t\tt.formatter.register({\n\t\t\t\talignleft : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'left'}},\n\t\t\t\t\t{selector : 'img,table', collapsed : false, styles : {'float' : 'left'}}\n\t\t\t\t],\n\n\t\t\t\taligncenter : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'center'}},\n\t\t\t\t\t{selector : 'img', collapsed : false, styles : {display : 'block', marginLeft : 'auto', marginRight : 'auto'}},\n\t\t\t\t\t{selector : 'table', collapsed : false, styles : {marginLeft : 'auto', marginRight : 'auto'}}\n\t\t\t\t],\n\n\t\t\t\talignright : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'right'}},\n\t\t\t\t\t{selector : 'img,table', collapsed : false, styles : {'float' : 'right'}}\n\t\t\t\t],\n\n\t\t\t\talignfull : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'justify'}}\n\t\t\t\t],\n\n\t\t\t\tbold : [\n\t\t\t\t\t{inline : 'strong', remove : 'all'},\n\t\t\t\t\t{inline : 'span', styles : {fontWeight : 'bold'}},\n\t\t\t\t\t{inline : 'b', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\titalic : [\n\t\t\t\t\t{inline : 'em', remove : 'all'},\n\t\t\t\t\t{inline : 'span', styles : {fontStyle : 'italic'}},\n\t\t\t\t\t{inline : 'i', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\tunderline : [\n\t\t\t\t\t{inline : 'span', styles : {textDecoration : 'underline'}, exact : true},\n\t\t\t\t\t{inline : 'u', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\tstrikethrough : [\n\t\t\t\t\t{inline : 'span', styles : {textDecoration : 'line-through'}, exact : true},\n\t\t\t\t\t{inline : 'strike', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\tforecolor : {inline : 'span', styles : {color : '%value'}, wrap_links : false},\n\t\t\t\thilitecolor : {inline : 'span', styles : {backgroundColor : '%value'}, wrap_links : false},\n\t\t\t\tfontname : {inline : 'span', styles : {fontFamily : '%value'}},\n\t\t\t\tfontsize : {inline : 'span', styles : {fontSize : '%value'}},\n\t\t\t\tfontsize_class : {inline : 'span', attributes : {'class' : '%value'}},\n\t\t\t\tblockquote : {block : 'blockquote', wrapper : 1, remove : 'all'},\n\t\t\t\tsubscript : {inline : 'sub'},\n\t\t\t\tsuperscript : {inline : 'sup'},\n\n\t\t\t\tlink : {inline : 'a', selector : 'a', remove : 'all', split : true, deep : true,\n\t\t\t\t\tonmatch : function(node) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t},\n\n\t\t\t\t\tonformat : function(elm, fmt, vars) {\n\t\t\t\t\t\teach(vars, function(value, key) {\n\t\t\t\t\t\t\tt.dom.setAttrib(elm, key, value);\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tremoveformat : [\n\t\t\t\t\t{selector : 'b,strong,em,i,font,u,strike', remove : 'all', split : true, expand : false, block_expand : true, deep : true},\n\t\t\t\t\t{selector : 'span', attributes : ['style', 'class'], remove : 'empty', split : true, expand : false, deep : true},\n\t\t\t\t\t{selector : '*', attributes : ['style', 'class'], split : false, expand : false, deep : true}\n\t\t\t\t]\n\t\t\t});\n\n\t\t\t// Register default block formats\n\t\t\teach('p h1 h2 h3 h4 h5 h6 div address pre div code dt dd samp'.split(/\\s/), function(name) {\n\t\t\t\tt.formatter.register(name, {block : name, remove : 'all'});\n\t\t\t});\n\n\t\t\t// Register user defined formats\n\t\t\tt.formatter.register(t.settings.formats);\n\n\t\t\tt.undoManager = new tinymce.UndoManager(t);\n\n\t\t\t// Pass through\n\t\t\tt.undoManager.onAdd.add(function(um, l) {\n\t\t\t\tif (um.hasUndo())\n\t\t\t\t\treturn t.onChange.dispatch(t, l, um);\n\t\t\t});\n\n\t\t\tt.undoManager.onUndo.add(function(um, l) {\n\t\t\t\treturn t.onUndo.dispatch(t, l, um);\n\t\t\t});\n\n\t\t\tt.undoManager.onRedo.add(function(um, l) {\n\t\t\t\treturn t.onRedo.dispatch(t, l, um);\n\t\t\t});\n\n\t\t\tt.forceBlocks = new tinymce.ForceBlocks(t, {\n\t\t\t\tforced_root_block : s.forced_root_block\n\t\t\t});\n\n\t\t\tt.editorCommands = new tinymce.EditorCommands(t);\n\n\t\t\t// Pass through\n\t\t\tt.serializer.onPreProcess.add(function(se, o) {\n\t\t\t\treturn t.onPreProcess.dispatch(t, o, se);\n\t\t\t});\n\n\t\t\tt.serializer.onPostProcess.add(function(se, o) {\n\t\t\t\treturn t.onPostProcess.dispatch(t, o, se);\n\t\t\t});\n\n\t\t\tt.onPreInit.dispatch(t);\n\n\t\t\tif (!s.gecko_spellcheck)\n\t\t\t\tt.getBody().spellcheck = 0;\n\n\t\t\tif (!s.readonly)\n\t\t\t\tt._addEvents();\n\n\t\t\tt.controlManager.onPostRender.dispatch(t, t.controlManager);\n\t\t\tt.onPostRender.dispatch(t);\n\n\t\t\tt.quirks = new tinymce.util.Quirks(this);\n\n\t\t\tif (s.directionality)\n\t\t\t\tt.getBody().dir = s.directionality;\n\n\t\t\tif (s.nowrap)\n\t\t\t\tt.getBody().style.whiteSpace = \"nowrap\";\n\n\t\t\tif (s.handle_node_change_callback) {\n\t\t\t\tt.onNodeChange.add(function(ed, cm, n) {\n\t\t\t\t\tt.execCallback('handle_node_change_callback', t.id, n, -1, -1, true, t.selection.isCollapsed());\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.save_callback) {\n\t\t\t\tt.onSaveContent.add(function(ed, o) {\n\t\t\t\t\tvar h = t.execCallback('save_callback', t.id, o.content, t.getBody());\n\n\t\t\t\t\tif (h)\n\t\t\t\t\t\to.content = h;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.onchange_callback) {\n\t\t\t\tt.onChange.add(function(ed, l) {\n\t\t\t\t\tt.execCallback('onchange_callback', t, l);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.protect) {\n\t\t\t\tt.onBeforeSetContent.add(function(ed, o) {\n\t\t\t\t\tif (s.protect) {\n\t\t\t\t\t\teach(s.protect, function(pattern) {\n\t\t\t\t\t\t\to.content = o.content.replace(pattern, function(str) {\n\t\t\t\t\t\t\t\treturn '<!--mce:protected ' + escape(str) + '-->';\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.convert_newlines_to_brs) {\n\t\t\t\tt.onBeforeSetContent.add(function(ed, o) {\n\t\t\t\t\tif (o.initial)\n\t\t\t\t\t\to.content = o.content.replace(/\\r?\\n/g, '<br />');\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.preformatted) {\n\t\t\t\tt.onPostProcess.add(function(ed, o) {\n\t\t\t\t\to.content = o.content.replace(/^\\s*<pre.*?>/, '');\n\t\t\t\t\to.content = o.content.replace(/<\\/pre>\\s*$/, '');\n\n\t\t\t\t\tif (o.set)\n\t\t\t\t\t\to.content = '<pre class=\"mceItemHidden\">' + o.content + '</pre>';\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.verify_css_classes) {\n\t\t\t\tt.serializer.attribValueFilter = function(n, v) {\n\t\t\t\t\tvar s, cl;\n\n\t\t\t\t\tif (n == 'class') {\n\t\t\t\t\t\t// Build regexp for classes\n\t\t\t\t\t\tif (!t.classesRE) {\n\t\t\t\t\t\t\tcl = t.dom.getClasses();\n\n\t\t\t\t\t\t\tif (cl.length > 0) {\n\t\t\t\t\t\t\t\ts = '';\n\n\t\t\t\t\t\t\t\teach (cl, function(o) {\n\t\t\t\t\t\t\t\t\ts += (s ? '|' : '') + o['class'];\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\tt.classesRE = new RegExp('(' + s + ')', 'gi');\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn !t.classesRE || /(\\bmceItem\\w+\\b|\\bmceTemp\\w+\\b)/g.test(v) || t.classesRE.test(v) ? v : '';\n\t\t\t\t\t}\n\n\t\t\t\t\treturn v;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (s.cleanup_callback) {\n\t\t\t\tt.onBeforeSetContent.add(function(ed, o) {\n\t\t\t\t\to.content = t.execCallback('cleanup_callback', 'insert_to_editor', o.content, o);\n\t\t\t\t});\n\n\t\t\t\tt.onPreProcess.add(function(ed, o) {\n\t\t\t\t\tif (o.set)\n\t\t\t\t\t\tt.execCallback('cleanup_callback', 'insert_to_editor_dom', o.node, o);\n\n\t\t\t\t\tif (o.get)\n\t\t\t\t\t\tt.execCallback('cleanup_callback', 'get_from_editor_dom', o.node, o);\n\t\t\t\t});\n\n\t\t\t\tt.onPostProcess.add(function(ed, o) {\n\t\t\t\t\tif (o.set)\n\t\t\t\t\t\to.content = t.execCallback('cleanup_callback', 'insert_to_editor', o.content, o);\n\n\t\t\t\t\tif (o.get)\t\t\t\t\t\t\n\t\t\t\t\t\to.content = t.execCallback('cleanup_callback', 'get_from_editor', o.content, o);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.save_callback) {\n\t\t\t\tt.onGetContent.add(function(ed, o) {\n\t\t\t\t\tif (o.save)\n\t\t\t\t\t\to.content = t.execCallback('save_callback', t.id, o.content, t.getBody());\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.handle_event_callback) {\n\t\t\t\tt.onEvent.add(function(ed, e, o) {\n\t\t\t\t\tif (t.execCallback('handle_event_callback', e, ed, o) === false)\n\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Add visual aids when new contents is added\n\t\t\tt.onSetContent.add(function() {\n\t\t\t\tt.addVisual(t.getBody());\n\t\t\t});\n\n\t\t\t// Remove empty contents\n\t\t\tif (s.padd_empty_editor) {\n\t\t\t\tt.onPostProcess.add(function(ed, o) {\n\t\t\t\t\to.content = o.content.replace(/^(<p[^>]*>(&nbsp;|&#160;|\\s|\\u00a0|)<\\/p>[\\r\\n]*|<br \\/>[\\r\\n]*)$/, '');\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (isGecko) {\n\t\t\t\t// Fix gecko link bug, when a link is placed at the end of block elements there is\n\t\t\t\t// no way to move the caret behind the link. This fix adds a bogus br element after the link\n\t\t\t\tfunction fixLinks(ed, o) {\n\t\t\t\t\teach(ed.dom.select('a'), function(n) {\n\t\t\t\t\t\tvar pn = n.parentNode;\n\n\t\t\t\t\t\tif (ed.dom.isBlock(pn) && pn.lastChild === n)\n\t\t\t\t\t\t\ted.dom.add(pn, 'br', {'data-mce-bogus' : 1});\n\t\t\t\t\t});\n\t\t\t\t};\n\n\t\t\t\tt.onExecCommand.add(function(ed, cmd) {\n\t\t\t\t\tif (cmd === 'CreateLink')\n\t\t\t\t\t\tfixLinks(ed);\n\t\t\t\t});\n\n\t\t\t\tt.onSetContent.add(t.selection.onSetContent.add(fixLinks));\n\t\t\t}\n\n\t\t\tt.load({initial : true, format : 'html'});\n\t\t\tt.startContent = t.getContent({format : 'raw'});\n\t\t\tt.undoManager.add();\n\t\t\tt.initialized = true;\n\n\t\t\tt.onInit.dispatch(t);\n\t\t\tt.execCallback('setupcontent_callback', t.id, t.getBody(), t.getDoc());\n\t\t\tt.execCallback('init_instance_callback', t);\n\t\t\tt.focus(true);\n\t\t\tt.nodeChanged({initial : 1});\n\n\t\t\t// Load specified content CSS last\n\t\t\teach(t.contentCSS, function(u) {\n\t\t\t\tt.dom.loadCSS(u);\n\t\t\t});\n\n\t\t\t// Handle auto focus\n\t\t\tif (s.auto_focus) {\n\t\t\t\tsetTimeout(function () {\n\t\t\t\t\tvar ed = tinymce.get(s.auto_focus);\n\n\t\t\t\t\ted.selection.select(ed.getBody(), 1);\n\t\t\t\t\ted.selection.collapse(1);\n\t\t\t\t\ted.getBody().focus();\n\t\t\t\t\ted.getWin().focus();\n\t\t\t\t}, 100);\n\t\t\t}\n\n\t\t\te = null;\n\t\t},\n\n\n\t\tfocus : function(sf) {\n\t\t\tvar oed, t = this, selection = t.selection, ce = t.settings.content_editable, ieRng, controlElm, doc = t.getDoc();\n\n\t\t\tif (!sf) {\n\t\t\t\t// Get selected control element\n\t\t\t\tieRng = selection.getRng();\n\t\t\t\tif (ieRng.item) {\n\t\t\t\t\tcontrolElm = ieRng.item(0);\n\t\t\t\t}\n\n\t\t\t\tt._refreshContentEditable();\n\t\t\t\tselection.normalize();\n\n\t\t\t\t// Is not content editable\n\t\t\t\tif (!ce)\n\t\t\t\t\tt.getWin().focus();\n\n\t\t\t\t// Focus the body as well since it's contentEditable\n\t\t\t\tif (tinymce.isGecko) {\n\t\t\t\t\tt.getBody().focus();\n\t\t\t\t}\n\n\t\t\t\t// Restore selected control element\n\t\t\t\t// This is needed when for example an image is selected within a\n\t\t\t\t// layer a call to focus will then remove the control selection\n\t\t\t\tif (controlElm && controlElm.ownerDocument == doc) {\n\t\t\t\t\tieRng = doc.body.createControlRange();\n\t\t\t\t\tieRng.addElement(controlElm);\n\t\t\t\t\tieRng.select();\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t\tif (tinymce.activeEditor != t) {\n\t\t\t\tif ((oed = tinymce.activeEditor) != null)\n\t\t\t\t\toed.onDeactivate.dispatch(oed, t);\n\n\t\t\t\tt.onActivate.dispatch(t, oed);\n\t\t\t}\n\n\t\t\ttinymce._setActive(t);\n\t\t},\n\n\t\texecCallback : function(n) {\n\t\t\tvar t = this, f = t.settings[n], s;\n\n\t\t\tif (!f)\n\t\t\t\treturn;\n\n\t\t\t// Look through lookup\n\t\t\tif (t.callbackLookup && (s = t.callbackLookup[n])) {\n\t\t\t\tf = s.func;\n\t\t\t\ts = s.scope;\n\t\t\t}\n\n\t\t\tif (is(f, 'string')) {\n\t\t\t\ts = f.replace(/\\.\\w+$/, '');\n\t\t\t\ts = s ? tinymce.resolve(s) : 0;\n\t\t\t\tf = tinymce.resolve(f);\n\t\t\t\tt.callbackLookup = t.callbackLookup || {};\n\t\t\t\tt.callbackLookup[n] = {func : f, scope : s};\n\t\t\t}\n\n\t\t\treturn f.apply(s || t, Array.prototype.slice.call(arguments, 1));\n\t\t},\n\n\t\ttranslate : function(s) {\n\t\t\tvar c = this.settings.language || 'en', i18n = tinymce.i18n;\n\n\t\t\tif (!s)\n\t\t\t\treturn '';\n\n\t\t\treturn i18n[c + '.' + s] || s.replace(/{\\#([^}]+)\\}/g, function(a, b) {\n\t\t\t\treturn i18n[c + '.' + b] || '{#' + b + '}';\n\t\t\t});\n\t\t},\n\n\t\tgetLang : function(n, dv) {\n\t\t\treturn tinymce.i18n[(this.settings.language || 'en') + '.' + n] || (is(dv) ? dv : '{#' + n + '}');\n\t\t},\n\n\t\tgetParam : function(n, dv, ty) {\n\t\t\tvar tr = tinymce.trim, v = is(this.settings[n]) ? this.settings[n] : dv, o;\n\n\t\t\tif (ty === 'hash') {\n\t\t\t\to = {};\n\n\t\t\t\tif (is(v, 'string')) {\n\t\t\t\t\teach(v.indexOf('=') > 0 ? v.split(/[;,](?![^=;,]*(?:[;,]|$))/) : v.split(','), function(v) {\n\t\t\t\t\t\tv = v.split('=');\n\n\t\t\t\t\t\tif (v.length > 1)\n\t\t\t\t\t\t\to[tr(v[0])] = tr(v[1]);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\to[tr(v[0])] = tr(v);\n\t\t\t\t\t});\n\t\t\t\t} else\n\t\t\t\t\to = v;\n\n\t\t\t\treturn o;\n\t\t\t}\n\n\t\t\treturn v;\n\t\t},\n\n\t\tnodeChanged : function(o) {\n\t\t\tvar t = this, s = t.selection, n = s.getStart() || t.getBody();\n\n\t\t\t// Fix for bug #1896577 it seems that this can not be fired while the editor is loading\n\t\t\tif (t.initialized) {\n\t\t\t\to = o || {};\n\t\t\t\tn = isIE && n.ownerDocument != t.getDoc() ? t.getBody() : n; // Fix for IE initial state\n\n\t\t\t\t// Get parents and add them to object\n\t\t\t\to.parents = [];\n\t\t\t\tt.dom.getParent(n, function(node) {\n\t\t\t\t\tif (node.nodeName == 'BODY')\n\t\t\t\t\t\treturn true;\n\n\t\t\t\t\to.parents.push(node);\n\t\t\t\t});\n\n\t\t\t\tt.onNodeChange.dispatch(\n\t\t\t\t\tt,\n\t\t\t\t\to ? o.controlManager || t.controlManager : t.controlManager,\n\t\t\t\t\tn,\n\t\t\t\t\ts.isCollapsed(),\n\t\t\t\t\to\n\t\t\t\t);\n\t\t\t}\n\t\t},\n\n\t\taddButton : function(n, s) {\n\t\t\tvar t = this;\n\n\t\t\tt.buttons = t.buttons || {};\n\t\t\tt.buttons[n] = s;\n\t\t},\n\n\t\taddCommand : function(name, callback, scope) {\n\t\t\tthis.execCommands[name] = {func : callback, scope : scope || this};\n\t\t},\n\n\t\taddQueryStateHandler : function(name, callback, scope) {\n\t\t\tthis.queryStateCommands[name] = {func : callback, scope : scope || this};\n\t\t},\n\n\t\taddQueryValueHandler : function(name, callback, scope) {\n\t\t\tthis.queryValueCommands[name] = {func : callback, scope : scope || this};\n\t\t},\n\n\t\taddShortcut : function(pa, desc, cmd_func, sc) {\n\t\t\tvar t = this, c;\n\n\t\t\tif (!t.settings.custom_shortcuts)\n\t\t\t\treturn false;\n\n\t\t\tt.shortcuts = t.shortcuts || {};\n\n\t\t\tif (is(cmd_func, 'string')) {\n\t\t\t\tc = cmd_func;\n\n\t\t\t\tcmd_func = function() {\n\t\t\t\t\tt.execCommand(c, false, null);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (is(cmd_func, 'object')) {\n\t\t\t\tc = cmd_func;\n\n\t\t\t\tcmd_func = function() {\n\t\t\t\t\tt.execCommand(c[0], c[1], c[2]);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\teach(explode(pa), function(pa) {\n\t\t\t\tvar o = {\n\t\t\t\t\tfunc : cmd_func,\n\t\t\t\t\tscope : sc || this,\n\t\t\t\t\tdesc : desc,\n\t\t\t\t\talt : false,\n\t\t\t\t\tctrl : false,\n\t\t\t\t\tshift : false\n\t\t\t\t};\n\n\t\t\t\teach(explode(pa, '+'), function(v) {\n\t\t\t\t\tswitch (v) {\n\t\t\t\t\t\tcase 'alt':\n\t\t\t\t\t\tcase 'ctrl':\n\t\t\t\t\t\tcase 'shift':\n\t\t\t\t\t\t\to[v] = true;\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tdefault:\n\t\t\t\t\t\t\to.charCode = v.charCodeAt(0);\n\t\t\t\t\t\t\to.keyCode = v.toUpperCase().charCodeAt(0);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tt.shortcuts[(o.ctrl ? 'ctrl' : '') + ',' + (o.alt ? 'alt' : '') + ',' + (o.shift ? 'shift' : '') + ',' + o.keyCode] = o;\n\t\t\t});\n\n\t\t\treturn true;\n\t\t},\n\n\t\texecCommand : function(cmd, ui, val, a) {\n\t\t\tvar t = this, s = 0, o, st;\n\n\t\t\tif (!/^(mceAddUndoLevel|mceEndUndoLevel|mceBeginUndoLevel|mceRepaint|SelectAll)$/.test(cmd) && (!a || !a.skip_focus))\n\t\t\t\tt.focus();\n\n\t\t\to = {};\n\t\t\tt.onBeforeExecCommand.dispatch(t, cmd, ui, val, o);\n\t\t\tif (o.terminate)\n\t\t\t\treturn false;\n\n\t\t\t// Command callback\n\t\t\tif (t.execCallback('execcommand_callback', t.id, t.selection.getNode(), cmd, ui, val)) {\n\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Registred commands\n\t\t\tif (o = t.execCommands[cmd]) {\n\t\t\t\tst = o.func.call(o.scope, ui, val);\n\n\t\t\t\t// Fall through on true\n\t\t\t\tif (st !== true) {\n\t\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\t\treturn st;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Plugin commands\n\t\t\teach(t.plugins, function(p) {\n\t\t\t\tif (p.execCommand && p.execCommand(cmd, ui, val)) {\n\t\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\t\ts = 1;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tif (s)\n\t\t\t\treturn true;\n\n\t\t\t// Theme commands\n\t\t\tif (t.theme && t.theme.execCommand && t.theme.execCommand(cmd, ui, val)) {\n\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Editor commands\n\t\t\tif (t.editorCommands.execCommand(cmd, ui, val)) {\n\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Browser commands\n\t\t\tt.getDoc().execCommand(cmd, ui, val);\n\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t},\n\n\t\tqueryCommandState : function(cmd) {\n\t\t\tvar t = this, o, s;\n\n\t\t\t// Is hidden then return undefined\n\t\t\tif (t._isHidden())\n\t\t\t\treturn;\n\n\t\t\t// Registred commands\n\t\t\tif (o = t.queryStateCommands[cmd]) {\n\t\t\t\ts = o.func.call(o.scope);\n\n\t\t\t\t// Fall though on true\n\t\t\t\tif (s !== true)\n\t\t\t\t\treturn s;\n\t\t\t}\n\n\t\t\t// Registred commands\n\t\t\to = t.editorCommands.queryCommandState(cmd);\n\t\t\tif (o !== -1)\n\t\t\t\treturn o;\n\n\t\t\t// Browser commands\n\t\t\ttry {\n\t\t\t\treturn this.getDoc().queryCommandState(cmd);\n\t\t\t} catch (ex) {\n\t\t\t\t// Fails sometimes see bug: 1896577\n\t\t\t}\n\t\t},\n\n\t\tqueryCommandValue : function(c) {\n\t\t\tvar t = this, o, s;\n\n\t\t\t// Is hidden then return undefined\n\t\t\tif (t._isHidden())\n\t\t\t\treturn;\n\n\t\t\t// Registred commands\n\t\t\tif (o = t.queryValueCommands[c]) {\n\t\t\t\ts = o.func.call(o.scope);\n\n\t\t\t\t// Fall though on true\n\t\t\t\tif (s !== true)\n\t\t\t\t\treturn s;\n\t\t\t}\n\n\t\t\t// Registred commands\n\t\t\to = t.editorCommands.queryCommandValue(c);\n\t\t\tif (is(o))\n\t\t\t\treturn o;\n\n\t\t\t// Browser commands\n\t\t\ttry {\n\t\t\t\treturn this.getDoc().queryCommandValue(c);\n\t\t\t} catch (ex) {\n\t\t\t\t// Fails sometimes see bug: 1896577\n\t\t\t}\n\t\t},\n\n\t\tshow : function() {\n\t\t\tvar t = this;\n\n\t\t\tDOM.show(t.getContainer());\n\t\t\tDOM.hide(t.id);\n\t\t\tt.load();\n\t\t},\n\n\t\thide : function() {\n\t\t\tvar t = this, d = t.getDoc();\n\n\t\t\t// Fixed bug where IE has a blinking cursor left from the editor\n\t\t\tif (isIE && d)\n\t\t\t\td.execCommand('SelectAll');\n\n\t\t\t// We must save before we hide so Safari doesn't crash\n\t\t\tt.save();\n\t\t\tDOM.hide(t.getContainer());\n\t\t\tDOM.setStyle(t.id, 'display', t.orgDisplay);\n\t\t},\n\n\t\tisHidden : function() {\n\t\t\treturn !DOM.isHidden(this.id);\n\t\t},\n\n\t\tsetProgressState : function(b, ti, o) {\n\t\t\tthis.onSetProgressState.dispatch(this, b, ti, o);\n\n\t\t\treturn b;\n\t\t},\n\n\t\tload : function(o) {\n\t\t\tvar t = this, e = t.getElement(), h;\n\n\t\t\tif (e) {\n\t\t\t\to = o || {};\n\t\t\t\to.load = true;\n\n\t\t\t\t// Double encode existing entities in the value\n\t\t\t\th = t.setContent(is(e.value) ? e.value : e.innerHTML, o);\n\t\t\t\to.element = e;\n\n\t\t\t\tif (!o.no_events)\n\t\t\t\t\tt.onLoadContent.dispatch(t, o);\n\n\t\t\t\to.element = e = null;\n\n\t\t\t\treturn h;\n\t\t\t}\n\t\t},\n\n\t\tsave : function(o) {\n\t\t\tvar t = this, e = t.getElement(), h, f;\n\n\t\t\tif (!e || !t.initialized)\n\t\t\t\treturn;\n\n\t\t\to = o || {};\n\t\t\to.save = true;\n\n\t\t\t// Add undo level will trigger onchange event\n\t\t\tif (!o.no_events) {\n\t\t\t\tt.undoManager.typing = false;\n\t\t\t\tt.undoManager.add();\n\t\t\t}\n\n\t\t\to.element = e;\n\t\t\th = o.content = t.getContent(o);\n\n\t\t\tif (!o.no_events)\n\t\t\t\tt.onSaveContent.dispatch(t, o);\n\n\t\t\th = o.content;\n\n\t\t\tif (!/TEXTAREA|INPUT/i.test(e.nodeName)) {\n\t\t\t\te.innerHTML = h;\n\n\t\t\t\t// Update hidden form element\n\t\t\t\tif (f = DOM.getParent(t.id, 'form')) {\n\t\t\t\t\teach(f.elements, function(e) {\n\t\t\t\t\t\tif (e.name == t.id) {\n\t\t\t\t\t\t\te.value = h;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t} else\n\t\t\t\te.value = h;\n\n\t\t\to.element = e = null;\n\n\t\t\treturn h;\n\t\t},\n\n\t\tsetContent : function(content, args) {\n\t\t\tvar self = this, rootNode, body = self.getBody(), forcedRootBlockName;\n\n\t\t\t// Setup args object\n\t\t\targs = args || {};\n\t\t\targs.format = args.format || 'html';\n\t\t\targs.set = true;\n\t\t\targs.content = content;\n\n\t\t\t// Do preprocessing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onBeforeSetContent.dispatch(self, args);\n\n\t\t\tcontent = args.content;\n\n\t\t\t// Padd empty content in Gecko and Safari. Commands will otherwise fail on the content\n\t\t\t// It will also be impossible to place the caret in the editor unless there is a BR element present\n\t\t\tif (!tinymce.isIE && (content.length === 0 || /^\\s+$/.test(content))) {\n\t\t\t\tforcedRootBlockName = self.settings.forced_root_block;\n\t\t\t\tif (forcedRootBlockName)\n\t\t\t\t\tcontent = '<' + forcedRootBlockName + '><br data-mce-bogus=\"1\"></' + forcedRootBlockName + '>';\n\t\t\t\telse\n\t\t\t\t\tcontent = '<br data-mce-bogus=\"1\">';\n\n\t\t\t\tbody.innerHTML = content;\n\t\t\t\tself.selection.select(body, true);\n\t\t\t\tself.selection.collapse(true);\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Parse and serialize the html\n\t\t\tif (args.format !== 'raw') {\n\t\t\t\tcontent = new tinymce.html.Serializer({}, self.schema).serialize(\n\t\t\t\t\tself.parser.parse(content)\n\t\t\t\t);\n\t\t\t}\n\n\t\t\t// Set the new cleaned contents to the editor\n\t\t\targs.content = tinymce.trim(content);\n\t\t\tself.dom.setHTML(body, args.content);\n\n\t\t\t// Do post processing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onSetContent.dispatch(self, args);\n\n\t\t\tself.selection.normalize();\n\n\t\t\treturn args.content;\n\t\t},\n\n\t\tgetContent : function(args) {\n\t\t\tvar self = this, content;\n\n\t\t\t// Setup args object\n\t\t\targs = args || {};\n\t\t\targs.format = args.format || 'html';\n\t\t\targs.get = true;\n\n\t\t\t// Do preprocessing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onBeforeGetContent.dispatch(self, args);\n\n\t\t\t// Get raw contents or by default the cleaned contents\n\t\t\tif (args.format == 'raw')\n\t\t\t\tcontent = self.getBody().innerHTML;\n\t\t\telse\n\t\t\t\tcontent = self.serializer.serialize(self.getBody(), args);\n\n\t\t\targs.content = tinymce.trim(content);\n\n\t\t\t// Do post processing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onGetContent.dispatch(self, args);\n\n\t\t\treturn args.content;\n\t\t},\n\n\t\tisDirty : function() {\n\t\t\tvar self = this;\n\n\t\t\treturn tinymce.trim(self.startContent) != tinymce.trim(self.getContent({format : 'raw', no_events : 1})) && !self.isNotDirty;\n\t\t},\n\n\t\tgetContainer : function() {\n\t\t\tvar t = this;\n\n\t\t\tif (!t.container)\n\t\t\t\tt.container = DOM.get(t.editorContainer || t.id + '_parent');\n\n\t\t\treturn t.container;\n\t\t},\n\n\t\tgetContentAreaContainer : function() {\n\t\t\treturn this.contentAreaContainer;\n\t\t},\n\n\t\tgetElement : function() {\n\t\t\treturn DOM.get(this.settings.content_element || this.id);\n\t\t},\n\n\t\tgetWin : function() {\n\t\t\tvar t = this, e;\n\n\t\t\tif (!t.contentWindow) {\n\t\t\t\te = DOM.get(t.id + \"_ifr\");\n\n\t\t\t\tif (e)\n\t\t\t\t\tt.contentWindow = e.contentWindow;\n\t\t\t}\n\n\t\t\treturn t.contentWindow;\n\t\t},\n\n\t\tgetDoc : function() {\n\t\t\tvar t = this, w;\n\n\t\t\tif (!t.contentDocument) {\n\t\t\t\tw = t.getWin();\n\n\t\t\t\tif (w)\n\t\t\t\t\tt.contentDocument = w.document;\n\t\t\t}\n\n\t\t\treturn t.contentDocument;\n\t\t},\n\n\t\tgetBody : function() {\n\t\t\treturn this.bodyElement || this.getDoc().body;\n\t\t},\n\n\t\tconvertURL : function(u, n, e) {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\t// Use callback instead\n\t\t\tif (s.urlconverter_callback)\n\t\t\t\treturn t.execCallback('urlconverter_callback', u, e, true, n);\n\n\t\t\t// Don't convert link href since thats the CSS files that gets loaded into the editor also skip local file URLs\n\t\t\tif (!s.convert_urls || (e && e.nodeName == 'LINK') || u.indexOf('file:') === 0)\n\t\t\t\treturn u;\n\n\t\t\t// Convert to relative\n\t\t\tif (s.relative_urls)\n\t\t\t\treturn t.documentBaseURI.toRelative(u);\n\n\t\t\t// Convert to absolute\n\t\t\tu = t.documentBaseURI.toAbsolute(u, s.remove_script_host);\n\n\t\t\treturn u;\n\t\t},\n\n\t\taddVisual : function(e) {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\te = e || t.getBody();\n\n\t\t\tif (!is(t.hasVisual))\n\t\t\t\tt.hasVisual = s.visual;\n\n\t\t\teach(t.dom.select('table,a', e), function(e) {\n\t\t\t\tvar v;\n\n\t\t\t\tswitch (e.nodeName) {\n\t\t\t\t\tcase 'TABLE':\n\t\t\t\t\t\tv = t.dom.getAttrib(e, 'border');\n\n\t\t\t\t\t\tif (!v || v == '0') {\n\t\t\t\t\t\t\tif (t.hasVisual)\n\t\t\t\t\t\t\t\tt.dom.addClass(e, s.visual_table_class);\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tt.dom.removeClass(e, s.visual_table_class);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tcase 'A':\n\t\t\t\t\t\tv = t.dom.getAttrib(e, 'name');\n\n\t\t\t\t\t\tif (v) {\n\t\t\t\t\t\t\tif (t.hasVisual)\n\t\t\t\t\t\t\t\tt.dom.addClass(e, 'mceItemAnchor');\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tt.dom.removeClass(e, 'mceItemAnchor');\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.onVisualAid.dispatch(t, e, t.hasVisual);\n\t\t},\n\n\t\tremove : function() {\n\t\t\tvar t = this, e = t.getContainer();\n\n\t\t\tt.removed = 1; // Cancels post remove event execution\n\t\t\tt.hide();\n\n\t\t\tt.execCallback('remove_instance_callback', t);\n\t\t\tt.onRemove.dispatch(t);\n\n\t\t\t// Clear all execCommand listeners this is required to avoid errors if the editor was removed inside another command\n\t\t\tt.onExecCommand.listeners = [];\n\n\t\t\ttinymce.remove(t);\n\t\t\tDOM.remove(e);\n\t\t},\n\n\t\tdestroy : function(s) {\n\t\t\tvar t = this;\n\n\t\t\t// One time is enough\n\t\t\tif (t.destroyed)\n\t\t\t\treturn;\n\n\t\t\tif (!s) {\n\t\t\t\ttinymce.removeUnload(t.destroy);\n\t\t\t\ttinyMCE.onBeforeUnload.remove(t._beforeUnload);\n\n\t\t\t\t// Manual destroy\n\t\t\t\tif (t.theme && t.theme.destroy)\n\t\t\t\t\tt.theme.destroy();\n\n\t\t\t\t// Destroy controls, selection and dom\n\t\t\t\tt.controlManager.destroy();\n\t\t\t\tt.selection.destroy();\n\t\t\t\tt.dom.destroy();\n\n\t\t\t\t// Remove all events\n\n\t\t\t\t// Don't clear the window or document if content editable\n\t\t\t\t// is enabled since other instances might still be present\n\t\t\t\tif (!t.settings.content_editable) {\n\t\t\t\t\tEvent.clear(t.getWin());\n\t\t\t\t\tEvent.clear(t.getDoc());\n\t\t\t\t}\n\n\t\t\t\tEvent.clear(t.getBody());\n\t\t\t\tEvent.clear(t.formElement);\n\t\t\t}\n\n\t\t\tif (t.formElement) {\n\t\t\t\tt.formElement.submit = t.formElement._mceOldSubmit;\n\t\t\t\tt.formElement._mceOldSubmit = null;\n\t\t\t}\n\n\t\t\tt.contentAreaContainer = t.formElement = t.container = t.settings.content_element = t.bodyElement = t.contentDocument = t.contentWindow = null;\n\n\t\t\tif (t.selection)\n\t\t\t\tt.selection = t.selection.win = t.selection.dom = t.selection.dom.doc = null;\n\n\t\t\tt.destroyed = 1;\n\t\t},\n\n\t\t// Internal functions\n\n\t\t_addEvents : function() {\n\t\t\t// 'focus', 'blur', 'dblclick', 'beforedeactivate', submit, reset\n\t\t\tvar t = this, i, s = t.settings, dom = t.dom, lo = {\n\t\t\t\tmouseup : 'onMouseUp',\n\t\t\t\tmousedown : 'onMouseDown',\n\t\t\t\tclick : 'onClick',\n\t\t\t\tkeyup : 'onKeyUp',\n\t\t\t\tkeydown : 'onKeyDown',\n\t\t\t\tkeypress : 'onKeyPress',\n\t\t\t\tsubmit : 'onSubmit',\n\t\t\t\treset : 'onReset',\n\t\t\t\tcontextmenu : 'onContextMenu',\n\t\t\t\tdblclick : 'onDblClick',\n\t\t\t\tpaste : 'onPaste' // Doesn't work in all browsers yet\n\t\t\t};\n\n\t\t\tfunction eventHandler(e, o) {\n\t\t\t\tvar ty = e.type;\n\n\t\t\t\t// Don't fire events when it's removed\n\t\t\t\tif (t.removed)\n\t\t\t\t\treturn;\n\n\t\t\t\t// Generic event handler\n\t\t\t\tif (t.onEvent.dispatch(t, e, o) !== false) {\n\t\t\t\t\t// Specific event handler\n\t\t\t\t\tt[lo[e.fakeType || e.type]].dispatch(t, e, o);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Add DOM events\n\t\t\teach(lo, function(v, k) {\n\t\t\t\tswitch (k) {\n\t\t\t\t\tcase 'contextmenu':\n\t\t\t\t\t\tdom.bind(t.getDoc(), k, eventHandler);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'paste':\n\t\t\t\t\t\tdom.bind(t.getBody(), k, function(e) {\n\t\t\t\t\t\t\teventHandler(e);\n\t\t\t\t\t\t});\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'submit':\n\t\t\t\t\tcase 'reset':\n\t\t\t\t\t\tdom.bind(t.getElement().form || DOM.getParent(t.id, 'form'), k, eventHandler);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tdefault:\n\t\t\t\t\t\tdom.bind(s.content_editable ? t.getBody() : t.getDoc(), k, eventHandler);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tdom.bind(s.content_editable ? t.getBody() : (isGecko ? t.getDoc() : t.getWin()), 'focus', function(e) {\n\t\t\t\tt.focus(true);\n\t\t\t});\n\n\n\t\t\t// Fixes bug where a specified document_base_uri could result in broken images\n\t\t\t// This will also fix drag drop of images in Gecko\n\t\t\tif (tinymce.isGecko) {\n\t\t\t\tdom.bind(t.getDoc(), 'DOMNodeInserted', function(e) {\n\t\t\t\t\tvar v;\n\n\t\t\t\t\te = e.target;\n\n\t\t\t\t\tif (e.nodeType === 1 && e.nodeName === 'IMG' && (v = e.getAttribute('data-mce-src')))\n\t\t\t\t\t\te.src = t.documentBaseURI.toAbsolute(v);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Set various midas options in Gecko\n\t\t\tif (isGecko) {\n\t\t\t\tfunction setOpts() {\n\t\t\t\t\tvar t = this, d = t.getDoc(), s = t.settings;\n\n\t\t\t\t\tif (isGecko && !s.readonly) {\n\t\t\t\t\t\tt._refreshContentEditable();\n\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t// Try new Gecko method\n\t\t\t\t\t\t\td.execCommand(\"styleWithCSS\", 0, false);\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\t// Use old method\n\t\t\t\t\t\t\tif (!t._isHidden())\n\t\t\t\t\t\t\t\ttry {d.execCommand(\"useCSS\", 0, true);} catch (ex) {}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (!s.table_inline_editing)\n\t\t\t\t\t\t\ttry {d.execCommand('enableInlineTableEditing', false, false);} catch (ex) {}\n\n\t\t\t\t\t\tif (!s.object_resizing)\n\t\t\t\t\t\t\ttry {d.execCommand('enableObjectResizing', false, false);} catch (ex) {}\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\tt.onBeforeExecCommand.add(setOpts);\n\t\t\t\tt.onMouseDown.add(setOpts);\n\t\t\t}\n\n\t\t\t// Add node change handlers\n\t\t\tt.onMouseUp.add(t.nodeChanged);\n\t\t\t//t.onClick.add(t.nodeChanged);\n\t\t\tt.onKeyUp.add(function(ed, e) {\n\t\t\t\tvar c = e.keyCode;\n\n\t\t\t\tif ((c >= 33 && c <= 36) || (c >= 37 && c <= 40) || c == 13 || c == 45 || c == 46 || c == 8 || (tinymce.isMac && (c == 91 || c == 93)) || e.ctrlKey)\n\t\t\t\t\tt.nodeChanged();\n\t\t\t});\n\n\n\t\t\t// Add block quote deletion handler\n\t\t\tt.onKeyDown.add(function(ed, e) {\n\t\t\t\t// Was the BACKSPACE key pressed?\n\t\t\t\tif (e.keyCode != 8)\n\t\t\t\t\treturn;\n\n\t\t\t\tvar n = ed.selection.getRng().startContainer;\n\t\t\t\tvar offset = ed.selection.getRng().startOffset;\n\n\t\t\t\twhile (n && n.nodeType && n.nodeType != 1 && n.parentNode)\n\t\t\t\t\tn = n.parentNode;\n\t\t\t\t\t\n\t\t\t\t// Is the cursor at the beginning of a blockquote?\n\t\t\t\tif (n && n.parentNode && n.parentNode.tagName === 'BLOCKQUOTE' && n.parentNode.firstChild == n && offset == 0) {\n\t\t\t\t\t// Remove the blockquote\n\t\t\t\t\ted.formatter.toggle('blockquote', null, n.parentNode);\n\n\t\t\t\t\t// Move the caret to the beginning of n\n\t\t\t\t\tvar rng = ed.selection.getRng();\n\t\t\t\t\trng.setStart(n, 0);\n\t\t\t\t\trng.setEnd(n, 0);\n\t\t\t\t\ted.selection.setRng(rng);\n\t\t\t\t\ted.selection.collapse(false);\n\t\t\t\t}\n\t\t\t});\n \n\n\n\t\t\t// Add reset handler\n\t\t\tt.onReset.add(function() {\n\t\t\t\tt.setContent(t.startContent, {format : 'raw'});\n\t\t\t});\n\n\t\t\t// Add shortcuts\n\t\t\tif (s.custom_shortcuts) {\n\t\t\t\tif (s.custom_undo_redo_keyboard_shortcuts) {\n\t\t\t\t\tt.addShortcut('ctrl+z', t.getLang('undo_desc'), 'Undo');\n\t\t\t\t\tt.addShortcut('ctrl+y', t.getLang('redo_desc'), 'Redo');\n\t\t\t\t}\n\n\t\t\t\t// Add default shortcuts for gecko\n\t\t\t\tt.addShortcut('ctrl+b', t.getLang('bold_desc'), 'Bold');\n\t\t\t\tt.addShortcut('ctrl+i', t.getLang('italic_desc'), 'Italic');\n\t\t\t\tt.addShortcut('ctrl+u', t.getLang('underline_desc'), 'Underline');\n\n\t\t\t\t// BlockFormat shortcuts keys\n\t\t\t\tfor (i=1; i<=6; i++)\n\t\t\t\t\tt.addShortcut('ctrl+' + i, '', ['FormatBlock', false, 'h' + i]);\n\n\t\t\t\tt.addShortcut('ctrl+7', '', ['FormatBlock', false, 'p']);\n\t\t\t\tt.addShortcut('ctrl+8', '', ['FormatBlock', false, 'div']);\n\t\t\t\tt.addShortcut('ctrl+9', '', ['FormatBlock', false, 'address']);\n\n\t\t\t\tfunction find(e) {\n\t\t\t\t\tvar v = null;\n\n\t\t\t\t\tif (!e.altKey && !e.ctrlKey && !e.metaKey)\n\t\t\t\t\t\treturn v;\n\n\t\t\t\t\teach(t.shortcuts, function(o) {\n\t\t\t\t\t\tif (tinymce.isMac && o.ctrl != e.metaKey)\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\telse if (!tinymce.isMac && o.ctrl != e.ctrlKey)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tif (o.alt != e.altKey)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tif (o.shift != e.shiftKey)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tif (e.keyCode == o.keyCode || (e.charCode && e.charCode == o.charCode)) {\n\t\t\t\t\t\t\tv = o;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\n\t\t\t\t\treturn v;\n\t\t\t\t};\n\n\t\t\t\tt.onKeyUp.add(function(ed, e) {\n\t\t\t\t\tvar o = find(e);\n\n\t\t\t\t\tif (o)\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t});\n\n\t\t\t\tt.onKeyPress.add(function(ed, e) {\n\t\t\t\t\tvar o = find(e);\n\n\t\t\t\t\tif (o)\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t});\n\n\t\t\t\tt.onKeyDown.add(function(ed, e) {\n\t\t\t\t\tvar o = find(e);\n\n\t\t\t\t\tif (o) {\n\t\t\t\t\t\to.func.call(o.scope);\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (tinymce.isIE) {\n\t\t\t\t// Fix so resize will only update the width and height attributes not the styles of an image\n\t\t\t\t// It will also block mceItemNoResize items\n\t\t\t\tdom.bind(t.getDoc(), 'controlselect', function(e) {\n\t\t\t\t\tvar re = t.resizeInfo, cb;\n\n\t\t\t\t\te = e.target;\n\n\t\t\t\t\t// Don't do this action for non image elements\n\t\t\t\t\tif (e.nodeName !== 'IMG')\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tif (re)\n\t\t\t\t\t\tdom.unbind(re.node, re.ev, re.cb);\n\n\t\t\t\t\tif (!dom.hasClass(e, 'mceItemNoResize')) {\n\t\t\t\t\t\tev = 'resizeend';\n\t\t\t\t\t\tcb = dom.bind(e, ev, function(e) {\n\t\t\t\t\t\t\tvar v;\n\n\t\t\t\t\t\t\te = e.target;\n\n\t\t\t\t\t\t\tif (v = dom.getStyle(e, 'width')) {\n\t\t\t\t\t\t\t\tdom.setAttrib(e, 'width', v.replace(/[^0-9%]+/g, ''));\n\t\t\t\t\t\t\t\tdom.setStyle(e, 'width', '');\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (v = dom.getStyle(e, 'height')) {\n\t\t\t\t\t\t\t\tdom.setAttrib(e, 'height', v.replace(/[^0-9%]+/g, ''));\n\t\t\t\t\t\t\t\tdom.setStyle(e, 'height', '');\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t} else {\n\t\t\t\t\t\tev = 'resizestart';\n\t\t\t\t\t\tcb = dom.bind(e, 'resizestart', Event.cancel, Event);\n\t\t\t\t\t}\n\n\t\t\t\t\tre = t.resizeInfo = {\n\t\t\t\t\t\tnode : e,\n\t\t\t\t\t\tev : ev,\n\t\t\t\t\t\tcb : cb\n\t\t\t\t\t};\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (tinymce.isOpera) {\n\t\t\t\tt.onClick.add(function(ed, e) {\n\t\t\t\t\tEvent.prevent(e);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Add custom undo/redo handlers\n\t\t\tif (s.custom_undo_redo) {\n\t\t\t\tfunction addUndo() {\n\t\t\t\t\tt.undoManager.typing = false;\n\t\t\t\t\tt.undoManager.add();\n\t\t\t\t};\n\n\t\t\t\tdom.bind(t.getDoc(), 'focusout', function(e) {\n\t\t\t\t\tif (!t.removed && t.undoManager.typing)\n\t\t\t\t\t\taddUndo();\n\t\t\t\t});\n\n\t\t\t\t// Add undo level when contents is drag/dropped within the editor\n\t\t\t\tt.dom.bind(t.dom.getRoot(), 'dragend', function(e) {\n\t\t\t\t\taddUndo();\n\t\t\t\t});\n\n\t\t\t\tt.onKeyUp.add(function(ed, e) {\n\t\t\t\t\tvar keyCode = e.keyCode;\n\n\t\t\t\t\tif ((keyCode >= 33 && keyCode <= 36) || (keyCode >= 37 && keyCode <= 40) || keyCode == 13 || keyCode == 45 || e.ctrlKey)\n\t\t\t\t\t\taddUndo();\n\t\t\t\t});\n\n\t\t\t\tt.onKeyDown.add(function(ed, e) {\n\t\t\t\t\tvar keyCode = e.keyCode, sel;\n\n\t\t\t\t\tif (keyCode == 8) {\n\t\t\t\t\t\tsel = t.getDoc().selection;\n\n\t\t\t\t\t\t// Fix IE control + backspace browser bug\n\t\t\t\t\t\tif (sel && sel.createRange && sel.createRange().item) {\n\t\t\t\t\t\t\tt.undoManager.beforeChange();\n\t\t\t\t\t\t\ted.dom.remove(sel.createRange().item(0));\n\t\t\t\t\t\t\taddUndo();\n\n\t\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Is caracter positon keys left,right,up,down,home,end,pgdown,pgup,enter\n\t\t\t\t\tif ((keyCode >= 33 && keyCode <= 36) || (keyCode >= 37 && keyCode <= 40) || keyCode == 13 || keyCode == 45) {\n\t\t\t\t\t\t// Add position before enter key is pressed, used by IE since it still uses the default browser behavior\n\t\t\t\t\t\t// Todo: Remove this once we normalize enter behavior on IE\n\t\t\t\t\t\tif (tinymce.isIE && keyCode == 13)\n\t\t\t\t\t\t\tt.undoManager.beforeChange();\n\n\t\t\t\t\t\tif (t.undoManager.typing)\n\t\t\t\t\t\t\taddUndo();\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// If key isn't shift,ctrl,alt,capslock,metakey\n\t\t\t\t\tif ((keyCode < 16 || keyCode > 20) && keyCode != 224 && keyCode != 91 && !t.undoManager.typing) {\n\t\t\t\t\t\tt.undoManager.beforeChange();\n\t\t\t\t\t\tt.undoManager.typing = true;\n\t\t\t\t\t\tt.undoManager.add();\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tt.onMouseDown.add(function() {\n\t\t\t\t\tif (t.undoManager.typing)\n\t\t\t\t\t\taddUndo();\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Bug fix for FireFox keeping styles from end of selection instead of start.\n\t\t\tif (tinymce.isGecko) {\n\t\t\t\tfunction getAttributeApplyFunction() {\n\t\t\t\t\tvar template = t.dom.getAttribs(t.selection.getStart().cloneNode(false));\n\n\t\t\t\t\treturn function() {\n\t\t\t\t\t\tvar target = t.selection.getStart();\n\n\t\t\t\t\t\tif (target !== t.getBody()) {\n\t\t\t\t\t\t\tt.dom.setAttrib(target, \"style\", null);\n\n\t\t\t\t\t\t\teach(template, function(attr) {\n\t\t\t\t\t\t\t\ttarget.setAttributeNode(attr.cloneNode(true));\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\tfunction isSelectionAcrossElements() {\n\t\t\t\t\tvar s = t.selection;\n\n\t\t\t\t\treturn !s.isCollapsed() && s.getStart() != s.getEnd();\n\t\t\t\t}\n\n\t\t\t\tt.onKeyPress.add(function(ed, e) {\n\t\t\t\t\tvar applyAttributes;\n\n\t\t\t\t\tif ((e.keyCode == 8 || e.keyCode == 46) && isSelectionAcrossElements()) {\n\t\t\t\t\t\tapplyAttributes = getAttributeApplyFunction();\n\t\t\t\t\t\tt.getDoc().execCommand('delete', false, null);\n\t\t\t\t\t\tapplyAttributes();\n\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tt.dom.bind(t.getDoc(), 'cut', function(e) {\n\t\t\t\t\tvar applyAttributes;\n\n\t\t\t\t\tif (isSelectionAcrossElements()) {\n\t\t\t\t\t\tapplyAttributes = getAttributeApplyFunction();\n\t\t\t\t\t\tt.onKeyUp.addToTop(Event.cancel, Event);\n\n\t\t\t\t\t\tsetTimeout(function() {\n\t\t\t\t\t\t\tapplyAttributes();\n\t\t\t\t\t\t\tt.onKeyUp.remove(Event.cancel, Event);\n\t\t\t\t\t\t}, 0);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\t_refreshContentEditable : function() {\n\t\t\tvar self = this, body, parent;\n\n\t\t\t// Check if the editor was hidden and the re-initalize contentEditable mode by removing and adding the body again\n\t\t\tif (self._isHidden()) {\n\t\t\t\tbody = self.getBody();\n\t\t\t\tparent = body.parentNode;\n\n\t\t\t\tparent.removeChild(body);\n\t\t\t\tparent.appendChild(body);\n\n\t\t\t\tbody.focus();\n\t\t\t}\n\t\t},\n\n\t\t_isHidden : function() {\n\t\t\tvar s;\n\n\t\t\tif (!isGecko)\n\t\t\t\treturn 0;\n\n\t\t\t// Weird, wheres that cursor selection?\n\t\t\ts = this.selection.getSel();\n\t\t\treturn (!s || !s.rangeCount || s.rangeCount == 0);\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\t// Added for compression purposes\n\tvar each = tinymce.each, undefined, TRUE = true, FALSE = false;\n\n\ttinymce.EditorCommands = function(editor) {\n\t\tvar dom = editor.dom,\n\t\t\tselection = editor.selection,\n\t\t\tcommands = {state: {}, exec : {}, value : {}},\n\t\t\tsettings = editor.settings,\n\t\t\tformatter = editor.formatter,\n\t\t\tbookmark;\n\n\t\tfunction execCommand(command, ui, value) {\n\t\t\tvar func;\n\n\t\t\tcommand = command.toLowerCase();\n\t\t\tif (func = commands.exec[command]) {\n\t\t\t\tfunc(command, ui, value);\n\t\t\t\treturn TRUE;\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\tfunction queryCommandState(command) {\n\t\t\tvar func;\n\n\t\t\tcommand = command.toLowerCase();\n\t\t\tif (func = commands.state[command])\n\t\t\t\treturn func(command);\n\n\t\t\treturn -1;\n\t\t};\n\n\t\tfunction queryCommandValue(command) {\n\t\t\tvar func;\n\n\t\t\tcommand = command.toLowerCase();\n\t\t\tif (func = commands.value[command])\n\t\t\t\treturn func(command);\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\tfunction addCommands(command_list, type) {\n\t\t\ttype = type || 'exec';\n\n\t\t\teach(command_list, function(callback, command) {\n\t\t\t\teach(command.toLowerCase().split(','), function(command) {\n\t\t\t\t\tcommands[type][command] = callback;\n\t\t\t\t});\n\t\t\t});\n\t\t};\n\n\t\t// Expose public methods\n\t\ttinymce.extend(this, {\n\t\t\texecCommand : execCommand,\n\t\t\tqueryCommandState : queryCommandState,\n\t\t\tqueryCommandValue : queryCommandValue,\n\t\t\taddCommands : addCommands\n\t\t});\n\n\t\t// Private methods\n\n\t\tfunction execNativeCommand(command, ui, value) {\n\t\t\tif (ui === undefined)\n\t\t\t\tui = FALSE;\n\n\t\t\tif (value === undefined)\n\t\t\t\tvalue = null;\n\n\t\t\treturn editor.getDoc().execCommand(command, ui, value);\n\t\t};\n\n\t\tfunction isFormatMatch(name) {\n\t\t\treturn formatter.match(name);\n\t\t};\n\n\t\tfunction toggleFormat(name, value) {\n\t\t\tformatter.toggle(name, value ? {value : value} : undefined);\n\t\t};\n\n\t\tfunction storeSelection(type) {\n\t\t\tbookmark = selection.getBookmark(type);\n\t\t};\n\n\t\tfunction restoreSelection() {\n\t\t\tselection.moveToBookmark(bookmark);\n\t\t};\n\n\t\t// Add execCommand overrides\n\t\taddCommands({\n\t\t\t// Ignore these, added for compatibility\n\t\t\t'mceResetDesignMode,mceBeginUndoLevel' : function() {},\n\n\t\t\t// Add undo manager logic\n\t\t\t'mceEndUndoLevel,mceAddUndoLevel' : function() {\n\t\t\t\teditor.undoManager.add();\n\t\t\t},\n\n\t\t\t'Cut,Copy,Paste' : function(command) {\n\t\t\t\tvar doc = editor.getDoc(), failed;\n\n\t\t\t\t// Try executing the native command\n\t\t\t\ttry {\n\t\t\t\t\texecNativeCommand(command);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Command failed\n\t\t\t\t\tfailed = TRUE;\n\t\t\t\t}\n\n\t\t\t\t// Present alert message about clipboard access not being available\n\t\t\t\tif (failed || !doc.queryCommandSupported(command)) {\n\t\t\t\t\tif (tinymce.isGecko) {\n\t\t\t\t\t\teditor.windowManager.confirm(editor.getLang('clipboard_msg'), function(state) {\n\t\t\t\t\t\t\tif (state)\n\t\t\t\t\t\t\t\topen('http://www.mozilla.org/editor/midasdemo/securityprefs.html', '_blank');\n\t\t\t\t\t\t});\n\t\t\t\t\t} else\n\t\t\t\t\t\teditor.windowManager.alert(editor.getLang('clipboard_no_support'));\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Override unlink command\n\t\t\tunlink : function(command) {\n\t\t\t\tif (selection.isCollapsed())\n\t\t\t\t\tselection.select(selection.getNode());\n\n\t\t\t\texecNativeCommand(command);\n\t\t\t\tselection.collapse(FALSE);\n\t\t\t},\n\n\t\t\t// Override justify commands to use the text formatter engine\n\t\t\t'JustifyLeft,JustifyCenter,JustifyRight,JustifyFull' : function(command) {\n\t\t\t\tvar align = command.substring(7);\n\n\t\t\t\t// Remove all other alignments first\n\t\t\t\teach('left,center,right,full'.split(','), function(name) {\n\t\t\t\t\tif (align != name)\n\t\t\t\t\t\tformatter.remove('align' + name);\n\t\t\t\t});\n\n\t\t\t\ttoggleFormat('align' + align);\n\t\t\t\texecCommand('mceRepaint');\n\t\t\t},\n\n\t\t\t// Override list commands to fix WebKit bug\n\t\t\t'InsertUnorderedList,InsertOrderedList' : function(command) {\n\t\t\t\tvar listElm, listParent;\n\n\t\t\t\texecNativeCommand(command);\n\n\t\t\t\t// WebKit produces lists within block elements so we need to split them\n\t\t\t\t// we will replace the native list creation logic to custom logic later on\n\t\t\t\t// TODO: Remove this when the list creation logic is removed\n\t\t\t\tlistElm = dom.getParent(selection.getNode(), 'ol,ul');\n\t\t\t\tif (listElm) {\n\t\t\t\t\tlistParent = listElm.parentNode;\n\n\t\t\t\t\t// If list is within a text block then split that block\n\t\t\t\t\tif (/^(H[1-6]|P|ADDRESS|PRE)$/.test(listParent.nodeName)) {\n\t\t\t\t\t\tstoreSelection();\n\t\t\t\t\t\tdom.split(listParent, listElm);\n\t\t\t\t\t\trestoreSelection();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Override commands to use the text formatter engine\n\t\t\t'Bold,Italic,Underline,Strikethrough,Superscript,Subscript' : function(command) {\n\t\t\t\ttoggleFormat(command);\n\t\t\t},\n\n\t\t\t// Override commands to use the text formatter engine\n\t\t\t'ForeColor,HiliteColor,FontName' : function(command, ui, value) {\n\t\t\t\ttoggleFormat(command, value);\n\t\t\t},\n\n\t\t\tFontSize : function(command, ui, value) {\n\t\t\t\tvar fontClasses, fontSizes;\n\n\t\t\t\t// Convert font size 1-7 to styles\n\t\t\t\tif (value >= 1 && value <= 7) {\n\t\t\t\t\tfontSizes = tinymce.explode(settings.font_size_style_values);\n\t\t\t\t\tfontClasses = tinymce.explode(settings.font_size_classes);\n\n\t\t\t\t\tif (fontClasses)\n\t\t\t\t\t\tvalue = fontClasses[value - 1] || value;\n\t\t\t\t\telse\n\t\t\t\t\t\tvalue = fontSizes[value - 1] || value;\n\t\t\t\t}\n\n\t\t\t\ttoggleFormat(command, value);\n\t\t\t},\n\n\t\t\tRemoveFormat : function(command) {\n\t\t\t\tformatter.remove(command);\n\t\t\t},\n\n\t\t\tmceBlockQuote : function(command) {\n\t\t\t\ttoggleFormat('blockquote');\n\t\t\t},\n\n\t\t\tFormatBlock : function(command, ui, value) {\n\t\t\t\treturn toggleFormat(value || 'p');\n\t\t\t},\n\n\t\t\tmceCleanup : function() {\n\t\t\t\tvar bookmark = selection.getBookmark();\n\n\t\t\t\teditor.setContent(editor.getContent({cleanup : TRUE}), {cleanup : TRUE});\n\n\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t},\n\n\t\t\tmceRemoveNode : function(command, ui, value) {\n\t\t\t\tvar node = value || selection.getNode();\n\n\t\t\t\t// Make sure that the body node isn't removed\n\t\t\t\tif (node != editor.getBody()) {\n\t\t\t\t\tstoreSelection();\n\t\t\t\t\teditor.dom.remove(node, TRUE);\n\t\t\t\t\trestoreSelection();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tmceSelectNodeDepth : function(command, ui, value) {\n\t\t\t\tvar counter = 0;\n\n\t\t\t\tdom.getParent(selection.getNode(), function(node) {\n\t\t\t\t\tif (node.nodeType == 1 && counter++ == value) {\n\t\t\t\t\t\tselection.select(node);\n\t\t\t\t\t\treturn FALSE;\n\t\t\t\t\t}\n\t\t\t\t}, editor.getBody());\n\t\t\t},\n\n\t\t\tmceSelectNode : function(command, ui, value) {\n\t\t\t\tselection.select(value);\n\t\t\t},\n\n\t\t\tmceInsertContent : function(command, ui, value) {\n\t\t\t\tvar parser, serializer, parentNode, rootNode, fragment, args,\n\t\t\t\t\tmarker, nodeRect, viewPortRect, rng, node, node2, bookmarkHtml, viewportBodyElement;\n\n\t\t\t\t// Setup parser and serializer\n\t\t\t\tparser = editor.parser;\n\t\t\t\tserializer = new tinymce.html.Serializer({}, editor.schema);\n\t\t\t\tbookmarkHtml = '<span id=\"mce_marker\" data-mce-type=\"bookmark\">\\uFEFF</span>';\n\n\t\t\t\t// Run beforeSetContent handlers on the HTML to be inserted\n\t\t\t\targs = {content: value, format: 'html'};\n\t\t\t\tselection.onBeforeSetContent.dispatch(selection, args);\n\t\t\t\tvalue = args.content;\n\n\t\t\t\t// Add caret at end of contents if it's missing\n\t\t\t\tif (value.indexOf('{$caret}') == -1)\n\t\t\t\t\tvalue += '{$caret}';\n\n\t\t\t\t// Replace the caret marker with a span bookmark element\n\t\t\t\tvalue = value.replace(/\\{\\$caret\\}/, bookmarkHtml);\n\n\t\t\t\t// Insert node maker where we will insert the new HTML and get it's parent\n\t\t\t\tif (!selection.isCollapsed())\n\t\t\t\t\teditor.getDoc().execCommand('Delete', false, null);\n\n\t\t\t\tparentNode = selection.getNode();\n\n\t\t\t\t// Parse the fragment within the context of the parent node\n\t\t\t\targs = {context : parentNode.nodeName.toLowerCase()};\n\t\t\t\tfragment = parser.parse(value, args);\n\n\t\t\t\t// Move the caret to a more suitable location\n\t\t\t\tnode = fragment.lastChild;\n\t\t\t\tif (node.attr('id') == 'mce_marker') {\n\t\t\t\t\tmarker = node;\n\n\t\t\t\t\tfor (node = node.prev; node; node = node.walk(true)) {\n\t\t\t\t\t\tif (node.type == 3 || !dom.isBlock(node.name)) {\n\t\t\t\t\t\t\tnode.parent.insert(marker, node, node.name === 'br');\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// If parser says valid we can insert the contents into that parent\n\t\t\t\tif (!args.invalid) {\n\t\t\t\t\tvalue = serializer.serialize(fragment);\n\n\t\t\t\t\t// Check if parent is empty or only has one BR element then set the innerHTML of that parent\n\t\t\t\t\tnode = parentNode.firstChild;\n\t\t\t\t\tnode2 = parentNode.lastChild;\n\t\t\t\t\tif (!node || (node === node2 && node.nodeName === 'BR'))\n\t\t\t\t\t\tdom.setHTML(parentNode, value);\n\t\t\t\t\telse\n\t\t\t\t\t\tselection.setContent(value);\n\t\t\t\t} else {\n\t\t\t\t\t// If the fragment was invalid within that context then we need\n\t\t\t\t\t// to parse and process the parent it's inserted into\n\n\t\t\t\t\t// Insert bookmark node and get the parent\n\t\t\t\t\tselection.setContent(bookmarkHtml);\n\t\t\t\t\tparentNode = editor.selection.getNode();\n\t\t\t\t\trootNode = editor.getBody();\n\n\t\t\t\t\t// Opera will return the document node when selection is in root\n\t\t\t\t\tif (parentNode.nodeType == 9)\n\t\t\t\t\t\tparentNode = node = rootNode;\n\t\t\t\t\telse\n\t\t\t\t\t\tnode = parentNode;\n\n\t\t\t\t\t// Find the ancestor just before the root element\n\t\t\t\t\twhile (node !== rootNode) {\n\t\t\t\t\t\tparentNode = node;\n\t\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Get the outer/inner HTML depending on if we are in the root and parser and serialize that\n\t\t\t\t\tvalue = parentNode == rootNode ? rootNode.innerHTML : dom.getOuterHTML(parentNode);\n\t\t\t\t\tvalue = serializer.serialize(\n\t\t\t\t\t\tparser.parse(\n\t\t\t\t\t\t\t// Need to replace by using a function since $ in the contents would otherwise be a problem\n\t\t\t\t\t\t\tvalue.replace(/<span (id=\"mce_marker\"|id=mce_marker).+?<\\/span>/i, function() {\n\t\t\t\t\t\t\t\treturn serializer.serialize(fragment);\n\t\t\t\t\t\t\t})\n\t\t\t\t\t\t)\n\t\t\t\t\t);\n\n\t\t\t\t\t// Set the inner/outer HTML depending on if we are in the root or not\n\t\t\t\t\tif (parentNode == rootNode)\n\t\t\t\t\t\tdom.setHTML(rootNode, value);\n\t\t\t\t\telse\n\t\t\t\t\t\tdom.setOuterHTML(parentNode, value);\n\t\t\t\t}\n\n\t\t\t\tmarker = dom.get('mce_marker');\n\n\t\t\t\t// Scroll range into view scrollIntoView on element can't be used since it will scroll the main view port as well\n\t\t\t\tnodeRect = dom.getRect(marker);\n\t\t\t\tviewPortRect = dom.getViewPort(editor.getWin());\n\n\t\t\t\t// Check if node is out side the viewport if it is then scroll to it\n\t\t\t\tif ((nodeRect.y + nodeRect.h > viewPortRect.y + viewPortRect.h || nodeRect.y < viewPortRect.y) ||\n\t\t\t\t\t(nodeRect.x > viewPortRect.x + viewPortRect.w || nodeRect.x < viewPortRect.x)) {\n\t\t\t\t\tviewportBodyElement = tinymce.isIE ? editor.getDoc().documentElement : editor.getBody();\n\t\t\t\t\tviewportBodyElement.scrollLeft = nodeRect.x;\n\t\t\t\t\tviewportBodyElement.scrollTop = nodeRect.y - viewPortRect.h + 25;\n\t\t\t\t}\n\n\t\t\t\t// Move selection before marker and remove it\n\t\t\t\trng = dom.createRng();\n\n\t\t\t\t// If previous sibling is a text node set the selection to the end of that node\n\t\t\t\tnode = marker.previousSibling;\n\t\t\t\tif (node && node.nodeType == 3) {\n\t\t\t\t\trng.setStart(node, node.nodeValue.length);\n\t\t\t\t} else {\n\t\t\t\t\t// If the previous sibling isn't a text node or doesn't exist set the selection before the marker node\n\t\t\t\t\trng.setStartBefore(marker);\n\t\t\t\t\trng.setEndBefore(marker);\n\t\t\t\t}\n\n\t\t\t\t// Remove the marker node and set the new range\n\t\t\t\tdom.remove(marker);\n\t\t\t\tselection.setRng(rng);\n\n\t\t\t\t// Dispatch after event and add any visual elements needed\n\t\t\t\tselection.onSetContent.dispatch(selection, args);\n\t\t\t\teditor.addVisual();\n\t\t\t},\n\n\t\t\tmceInsertRawHTML : function(command, ui, value) {\n\t\t\t\tselection.setContent('tiny_mce_marker');\n\t\t\t\teditor.setContent(editor.getContent().replace(/tiny_mce_marker/g, function() { return value }));\n\t\t\t},\n\n\t\t\tmceSetContent : function(command, ui, value) {\n\t\t\t\teditor.setContent(value);\n\t\t\t},\n\n\t\t\t'Indent,Outdent' : function(command) {\n\t\t\t\tvar intentValue, indentUnit, value;\n\n\t\t\t\t// Setup indent level\n\t\t\t\tintentValue = settings.indentation;\n\t\t\t\tindentUnit = /[a-z%]+$/i.exec(intentValue);\n\t\t\t\tintentValue = parseInt(intentValue);\n\n\t\t\t\tif (!queryCommandState('InsertUnorderedList') && !queryCommandState('InsertOrderedList')) {\n\t\t\t\t\teach(selection.getSelectedBlocks(), function(element) {\n\t\t\t\t\t\tif (command == 'outdent') {\n\t\t\t\t\t\t\tvalue = Math.max(0, parseInt(element.style.paddingLeft || 0) - intentValue);\n\t\t\t\t\t\t\tdom.setStyle(element, 'paddingLeft', value ? value + indentUnit : '');\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\tdom.setStyle(element, 'paddingLeft', (parseInt(element.style.paddingLeft || 0) + intentValue) + indentUnit);\n\t\t\t\t\t});\n\t\t\t\t} else\n\t\t\t\t\texecNativeCommand(command);\n\t\t\t},\n\n\t\t\tmceRepaint : function() {\n\t\t\t\tvar bookmark;\n\n\t\t\t\tif (tinymce.isGecko) {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tstoreSelection(TRUE);\n\n\t\t\t\t\t\tif (selection.getSel())\n\t\t\t\t\t\t\tselection.getSel().selectAllChildren(editor.getBody());\n\n\t\t\t\t\t\tselection.collapse(TRUE);\n\t\t\t\t\t\trestoreSelection();\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// Ignore\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tmceToggleFormat : function(command, ui, value) {\n\t\t\t\tformatter.toggle(value);\n\t\t\t},\n\n\t\t\tInsertHorizontalRule : function() {\n\t\t\t\teditor.execCommand('mceInsertContent', false, '<hr />');\n\t\t\t},\n\n\t\t\tmceToggleVisualAid : function() {\n\t\t\t\teditor.hasVisual = !editor.hasVisual;\n\t\t\t\teditor.addVisual();\n\t\t\t},\n\n\t\t\tmceReplaceContent : function(command, ui, value) {\n\t\t\t\teditor.execCommand('mceInsertContent', false, value.replace(/\\{\\$selection\\}/g, selection.getContent({format : 'text'})));\n\t\t\t},\n\n\t\t\tmceInsertLink : function(command, ui, value) {\n\t\t\t\tvar anchor;\n\n\t\t\t\tif (typeof(value) == 'string')\n\t\t\t\t\tvalue = {href : value};\n\n\t\t\t\tanchor = dom.getParent(selection.getNode(), 'a');\n\n\t\t\t\t// Spaces are never valid in URLs and it's a very common mistake for people to make so we fix it here.\n\t\t\t\tvalue.href = value.href.replace(' ', '%20');\n\n\t\t\t\t// Remove existing links if there could be child links or that the href isn't specified\n\t\t\t\tif (!anchor || !value.href) {\n\t\t\t\t\tformatter.remove('link');\n\t\t\t\t}\t\t\n\n\t\t\t\t// Apply new link to selection\n\t\t\t\tif (value.href) {\n\t\t\t\t\tformatter.apply('link', value, anchor);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tselectAll : function() {\n\t\t\t\tvar root = dom.getRoot(), rng = dom.createRng();\n\n\t\t\t\trng.setStart(root, 0);\n\t\t\t\trng.setEnd(root, root.childNodes.length);\n\n\t\t\t\teditor.selection.setRng(rng);\n\t\t\t}\n\t\t});\n\n\t\t// Add queryCommandState overrides\n\t\taddCommands({\n\t\t\t// Override justify commands\n\t\t\t'JustifyLeft,JustifyCenter,JustifyRight,JustifyFull' : function(command) {\n\t\t\t\treturn isFormatMatch('align' + command.substring(7));\n\t\t\t},\n\n\t\t\t'Bold,Italic,Underline,Strikethrough,Superscript,Subscript' : function(command) {\n\t\t\t\treturn isFormatMatch(command);\n\t\t\t},\n\n\t\t\tmceBlockQuote : function() {\n\t\t\t\treturn isFormatMatch('blockquote');\n\t\t\t},\n\n\t\t\tOutdent : function() {\n\t\t\t\tvar node;\n\n\t\t\t\tif (settings.inline_styles) {\n\t\t\t\t\tif ((node = dom.getParent(selection.getStart(), dom.isBlock)) && parseInt(node.style.paddingLeft) > 0)\n\t\t\t\t\t\treturn TRUE;\n\n\t\t\t\t\tif ((node = dom.getParent(selection.getEnd(), dom.isBlock)) && parseInt(node.style.paddingLeft) > 0)\n\t\t\t\t\t\treturn TRUE;\n\t\t\t\t}\n\n\t\t\t\treturn queryCommandState('InsertUnorderedList') || queryCommandState('InsertOrderedList') || (!settings.inline_styles && !!dom.getParent(selection.getNode(), 'BLOCKQUOTE'));\n\t\t\t},\n\n\t\t\t'InsertUnorderedList,InsertOrderedList' : function(command) {\n\t\t\t\treturn dom.getParent(selection.getNode(), command == 'insertunorderedlist' ? 'UL' : 'OL');\n\t\t\t}\n\t\t}, 'state');\n\n\t\t// Add queryCommandValue overrides\n\t\taddCommands({\n\t\t\t'FontSize,FontName' : function(command) {\n\t\t\t\tvar value = 0, parent;\n\n\t\t\t\tif (parent = dom.getParent(selection.getNode(), 'span')) {\n\t\t\t\t\tif (command == 'fontsize')\n\t\t\t\t\t\tvalue = parent.style.fontSize;\n\t\t\t\t\telse\n\t\t\t\t\t\tvalue = parent.style.fontFamily.replace(/, /g, ',').replace(/[\\'\\\"]/g, '').toLowerCase();\n\t\t\t\t}\n\n\t\t\t\treturn value;\n\t\t\t}\n\t\t}, 'value');\n\n\t\t// Add undo manager logic\n\t\tif (settings.custom_undo_redo) {\n\t\t\taddCommands({\n\t\t\t\tUndo : function() {\n\t\t\t\t\teditor.undoManager.undo();\n\t\t\t\t},\n\n\t\t\t\tRedo : function() {\n\t\t\t\t\teditor.undoManager.redo();\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t};\n})(tinymce);\n\n(function(tinymce) {\n\tvar Dispatcher = tinymce.util.Dispatcher;\n\n\ttinymce.UndoManager = function(editor) {\n\t\tvar self, index = 0, data = [], beforeBookmark;\n\n\t\tfunction getContent() {\n\t\t\treturn tinymce.trim(editor.getContent({format : 'raw', no_events : 1}));\n\t\t};\n\n\t\treturn self = {\n\t\t\ttyping : false,\n\n\t\t\tonAdd : new Dispatcher(self),\n\n\t\t\tonUndo : new Dispatcher(self),\n\n\t\t\tonRedo : new Dispatcher(self),\n\n\t\t\tbeforeChange : function() {\n\t\t\t\tbeforeBookmark = editor.selection.getBookmark(2, true);\n\t\t\t},\n\n\t\t\tadd : function(level) {\n\t\t\t\tvar i, settings = editor.settings, lastLevel;\n\n\t\t\t\tlevel = level || {};\n\t\t\t\tlevel.content = getContent();\n\n\t\t\t\t// Add undo level if needed\n\t\t\t\tlastLevel = data[index];\n\t\t\t\tif (lastLevel && lastLevel.content == level.content)\n\t\t\t\t\treturn null;\n\n\t\t\t\t// Set before bookmark on previous level\n\t\t\t\tif (data[index])\n\t\t\t\t\tdata[index].beforeBookmark = beforeBookmark;\n\n\t\t\t\t// Time to compress\n\t\t\t\tif (settings.custom_undo_redo_levels) {\n\t\t\t\t\tif (data.length > settings.custom_undo_redo_levels) {\n\t\t\t\t\t\tfor (i = 0; i < data.length - 1; i++)\n\t\t\t\t\t\t\tdata[i] = data[i + 1];\n\n\t\t\t\t\t\tdata.length--;\n\t\t\t\t\t\tindex = data.length;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Get a non intrusive normalized bookmark\n\t\t\t\tlevel.bookmark = editor.selection.getBookmark(2, true);\n\n\t\t\t\t// Crop array if needed\n\t\t\t\tif (index < data.length - 1)\n\t\t\t\t\tdata.length = index + 1;\n\n\t\t\t\tdata.push(level);\n\t\t\t\tindex = data.length - 1;\n\n\t\t\t\tself.onAdd.dispatch(self, level);\n\t\t\t\teditor.isNotDirty = 0;\n\n\t\t\t\treturn level;\n\t\t\t},\n\n\t\t\tundo : function() {\n\t\t\t\tvar level, i;\n\n\t\t\t\tif (self.typing) {\n\t\t\t\t\tself.add();\n\t\t\t\t\tself.typing = false;\n\t\t\t\t}\n\n\t\t\t\tif (index > 0) {\n\t\t\t\t\tlevel = data[--index];\n\n\t\t\t\t\teditor.setContent(level.content, {format : 'raw'});\n\t\t\t\t\teditor.selection.moveToBookmark(level.beforeBookmark);\n\n\t\t\t\t\tself.onUndo.dispatch(self, level);\n\t\t\t\t}\n\n\t\t\t\treturn level;\n\t\t\t},\n\n\t\t\tredo : function() {\n\t\t\t\tvar level;\n\n\t\t\t\tif (index < data.length - 1) {\n\t\t\t\t\tlevel = data[++index];\n\n\t\t\t\t\teditor.setContent(level.content, {format : 'raw'});\n\t\t\t\t\teditor.selection.moveToBookmark(level.bookmark);\n\n\t\t\t\t\tself.onRedo.dispatch(self, level);\n\t\t\t\t}\n\n\t\t\t\treturn level;\n\t\t\t},\n\n\t\t\tclear : function() {\n\t\t\t\tdata = [];\n\t\t\t\tindex = 0;\n\t\t\t\tself.typing = false;\n\t\t\t},\n\n\t\t\thasUndo : function() {\n\t\t\t\treturn index > 0 || this.typing;\n\t\t\t},\n\n\t\t\thasRedo : function() {\n\t\t\t\treturn index < data.length - 1 && !this.typing;\n\t\t\t}\n\t\t};\n\t};\n})(tinymce);\n\n(function(tinymce) {\n\t// Shorten names\n\tvar Event = tinymce.dom.Event,\n\t\tisIE = tinymce.isIE,\n\t\tisGecko = tinymce.isGecko,\n\t\tisOpera = tinymce.isOpera,\n\t\teach = tinymce.each,\n\t\textend = tinymce.extend,\n\t\tTRUE = true,\n\t\tFALSE = false;\n\n\tfunction cloneFormats(node) {\n\t\tvar clone, temp, inner;\n\n\t\tdo {\n\t\t\tif (/^(SPAN|STRONG|B|EM|I|FONT|STRIKE|U)$/.test(node.nodeName)) {\n\t\t\t\tif (clone) {\n\t\t\t\t\ttemp = node.cloneNode(false);\n\t\t\t\t\ttemp.appendChild(clone);\n\t\t\t\t\tclone = temp;\n\t\t\t\t} else {\n\t\t\t\t\tclone = inner = node.cloneNode(false);\n\t\t\t\t}\n\n\t\t\t\tclone.removeAttribute('id');\n\t\t\t}\n\t\t} while (node = node.parentNode);\n\n\t\tif (clone)\n\t\t\treturn {wrapper : clone, inner : inner};\n\t};\n\n\t// Checks if the selection/caret is at the end of the specified block element\n\tfunction isAtEnd(rng, par) {\n\t\tvar rng2 = par.ownerDocument.createRange();\n\n\t\trng2.setStart(rng.endContainer, rng.endOffset);\n\t\trng2.setEndAfter(par);\n\n\t\t// Get number of characters to the right of the cursor if it's zero then we are at the end and need to merge the next block element\n\t\treturn rng2.cloneContents().textContent.length == 0;\n\t};\n\n\tfunction splitList(selection, dom, li) {\n\t\tvar listBlock, block;\n\n\t\tif (dom.isEmpty(li)) {\n\t\t\tlistBlock = dom.getParent(li, 'ul,ol');\n\n\t\t\tif (!dom.getParent(listBlock.parentNode, 'ul,ol')) {\n\t\t\t\tdom.split(listBlock, li);\n\t\t\t\tblock = dom.create('p', 0, '<br data-mce-bogus=\"1\" />');\n\t\t\t\tdom.replace(block, li);\n\t\t\t\tselection.select(block, 1);\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t}\n\n\t\treturn TRUE;\n\t};\n\n\ttinymce.create('tinymce.ForceBlocks', {\n\t\tForceBlocks : function(ed) {\n\t\t\tvar t = this, s = ed.settings, elm;\n\n\t\t\tt.editor = ed;\n\t\t\tt.dom = ed.dom;\n\t\t\telm = (s.forced_root_block || 'p').toLowerCase();\n\t\t\ts.element = elm.toUpperCase();\n\n\t\t\ted.onPreInit.add(t.setup, t);\n\t\t},\n\n\t\tsetup : function() {\n\t\t\tvar t = this, ed = t.editor, s = ed.settings, dom = ed.dom, selection = ed.selection, blockElements = ed.schema.getBlockElements();\n\n\t\t\t// Force root blocks\n\t\t\tif (s.forced_root_block) {\n\t\t\t\tfunction addRootBlocks() {\n\t\t\t\t\tvar node = selection.getStart(), rootNode = ed.getBody(), rng, startContainer, startOffset, endContainer, endOffset, rootBlockNode, tempNode, offset = -0xFFFFFF;\n\n\t\t\t\t\tif (!node || node.nodeType !== 1)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Check if node is wrapped in block\n\t\t\t\t\twhile (node != rootNode) {\n\t\t\t\t\t\tif (blockElements[node.nodeName])\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Get current selection\n\t\t\t\t\trng = selection.getRng();\n\t\t\t\t\tif (rng.setStart) {\n\t\t\t\t\t\tstartContainer = rng.startContainer;\n\t\t\t\t\t\tstartOffset = rng.startOffset;\n\t\t\t\t\t\tendContainer = rng.endContainer;\n\t\t\t\t\t\tendOffset = rng.endOffset;\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Force control range into text range\n\t\t\t\t\t\tif (rng.item) {\n\t\t\t\t\t\t\trng = ed.getDoc().body.createTextRange();\n\t\t\t\t\t\t\trng.moveToElementText(rng.item(0));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\ttmpRng = rng.duplicate();\n\t\t\t\t\t\ttmpRng.collapse(true);\n\t\t\t\t\t\tstartOffset = tmpRng.move('character', offset) * -1;\n\n\t\t\t\t\t\tif (!tmpRng.collapsed) {\n\t\t\t\t\t\t\ttmpRng = rng.duplicate();\n\t\t\t\t\t\t\ttmpRng.collapse(false);\n\t\t\t\t\t\t\tendOffset = (tmpRng.move('character', offset) * -1) - startOffset;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Wrap non block elements and text nodes\n\t\t\t\t\tfor (node = rootNode.firstChild; node; node) {\n\t\t\t\t\t\tif (node.nodeType === 3 || (node.nodeType == 1 && !blockElements[node.nodeName])) {\n\t\t\t\t\t\t\tif (!rootBlockNode) {\n\t\t\t\t\t\t\t\trootBlockNode = dom.create(s.forced_root_block);\n\t\t\t\t\t\t\t\tnode.parentNode.insertBefore(rootBlockNode, node);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\ttempNode = node;\n\t\t\t\t\t\t\tnode = node.nextSibling;\n\t\t\t\t\t\t\trootBlockNode.appendChild(tempNode);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\trootBlockNode = null;\n\t\t\t\t\t\t\tnode = node.nextSibling;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tif (rng.setStart) {\n\t\t\t\t\t\trng.setStart(startContainer, startOffset);\n\t\t\t\t\t\trng.setEnd(endContainer, endOffset);\n\t\t\t\t\t\tselection.setRng(rng);\n\t\t\t\t\t} else {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\trng = ed.getDoc().body.createTextRange();\n\t\t\t\t\t\t\trng.moveToElementText(rootNode);\n\t\t\t\t\t\t\trng.collapse(true);\n\t\t\t\t\t\t\trng.moveStart('character', startOffset);\n\n\t\t\t\t\t\t\tif (endOffset > 0)\n\t\t\t\t\t\t\t\trng.moveEnd('character', endOffset);\n\n\t\t\t\t\t\t\trng.select();\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\t// Ignore\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\ted.nodeChanged();\n\t\t\t\t};\n\n\t\t\t\ted.onKeyUp.add(addRootBlocks);\n\t\t\t\ted.onClick.add(addRootBlocks);\n\t\t\t}\n\n\t\t\tif (s.force_br_newlines) {\n\t\t\t\t// Force IE to produce BRs on enter\n\t\t\t\tif (isIE) {\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tvar n;\n\n\t\t\t\t\t\tif (e.keyCode == 13 && selection.getNode().nodeName != 'LI') {\n\t\t\t\t\t\t\tselection.setContent('<br id=\"__\" /> ', {format : 'raw'});\n\t\t\t\t\t\t\tn = dom.get('__');\n\t\t\t\t\t\t\tn.removeAttribute('id');\n\t\t\t\t\t\t\tselection.select(n);\n\t\t\t\t\t\t\tselection.collapse();\n\t\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (s.force_p_newlines) {\n\t\t\t\tif (!isIE) {\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tif (e.keyCode == 13 && !e.shiftKey && !t.insertPara(e))\n\t\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\t// Ungly hack to for IE to preserve the formatting when you press\n\t\t\t\t\t// enter at the end of a block element with formatted contents\n\t\t\t\t\t// This logic overrides the browsers default logic with\n\t\t\t\t\t// custom logic that enables us to control the output\n\t\t\t\t\ttinymce.addUnload(function() {\n\t\t\t\t\t\tt._previousFormats = 0; // Fix IE leak\n\t\t\t\t\t});\n\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tt._previousFormats = 0;\n\n\t\t\t\t\t\t// Clone the current formats, this will later be applied to the new block contents\n\t\t\t\t\t\tif (e.keyCode == 13 && !e.shiftKey && ed.selection.isCollapsed() && s.keep_styles)\n\t\t\t\t\t\t\tt._previousFormats = cloneFormats(ed.selection.getStart());\n\t\t\t\t\t});\n\n\t\t\t\t\ted.onKeyUp.add(function(ed, e) {\n\t\t\t\t\t\t// Let IE break the element and the wrap the new caret location in the previous formats\n\t\t\t\t\t\tif (e.keyCode == 13 && !e.shiftKey) {\n\t\t\t\t\t\t\tvar parent = ed.selection.getStart(), fmt = t._previousFormats;\n\n\t\t\t\t\t\t\t// Parent is an empty block\n\t\t\t\t\t\t\tif (!parent.hasChildNodes() && fmt) {\n\t\t\t\t\t\t\t\tparent = dom.getParent(parent, dom.isBlock);\n\n\t\t\t\t\t\t\t\tif (parent && parent.nodeName != 'LI') {\n\t\t\t\t\t\t\t\t\tparent.innerHTML = '';\n\n\t\t\t\t\t\t\t\t\tif (t._previousFormats) {\n\t\t\t\t\t\t\t\t\t\tparent.appendChild(fmt.wrapper);\n\t\t\t\t\t\t\t\t\t\tfmt.inner.innerHTML = '\\uFEFF';\n\t\t\t\t\t\t\t\t\t} else\n\t\t\t\t\t\t\t\t\t\tparent.innerHTML = '\\uFEFF';\n\n\t\t\t\t\t\t\t\t\tselection.select(parent, 1);\n\t\t\t\t\t\t\t\t\tselection.collapse(true);\n\t\t\t\t\t\t\t\t\ted.getDoc().execCommand('Delete', false, null);\n\t\t\t\t\t\t\t\t\tt._previousFormats = 0;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif (isGecko) {\n\t\t\t\t\ted.onKeyDown.add(function(ed, e) {\n\t\t\t\t\t\tif ((e.keyCode == 8 || e.keyCode == 46) && !e.shiftKey)\n\t\t\t\t\t\t\tt.backspaceDelete(e, e.keyCode == 8);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Workaround for missing shift+enter support, http://bugs.webkit.org/show_bug.cgi?id=16973\n\t\t\tif (tinymce.isWebKit) {\n\t\t\t\tfunction insertBr(ed) {\n\t\t\t\t\tvar rng = selection.getRng(), br, div = dom.create('div', null, ' '), divYPos, vpHeight = dom.getViewPort(ed.getWin()).h;\n\n\t\t\t\t\t// Insert BR element\n\t\t\t\t\trng.insertNode(br = dom.create('br'));\n\n\t\t\t\t\t// Place caret after BR\n\t\t\t\t\trng.setStartAfter(br);\n\t\t\t\t\trng.setEndAfter(br);\n\t\t\t\t\tselection.setRng(rng);\n\n\t\t\t\t\t// Could not place caret after BR then insert an nbsp entity and move the caret\n\t\t\t\t\tif (selection.getSel().focusNode == br.previousSibling) {\n\t\t\t\t\t\tselection.select(dom.insertAfter(dom.doc.createTextNode('\\u00a0'), br));\n\t\t\t\t\t\tselection.collapse(TRUE);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Create a temporary DIV after the BR and get the position as it\n\t\t\t\t\t// seems like getPos() returns 0 for text nodes and BR elements.\n\t\t\t\t\tdom.insertAfter(div, br);\n\t\t\t\t\tdivYPos = dom.getPos(div).y;\n\t\t\t\t\tdom.remove(div);\n\n\t\t\t\t\t// Scroll to new position, scrollIntoView can't be used due to bug: http://bugs.webkit.org/show_bug.cgi?id=16117\n\t\t\t\t\tif (divYPos > vpHeight) // It is not necessary to scroll if the DIV is inside the view port.\n\t\t\t\t\t\ted.getWin().scrollTo(0, divYPos);\n\t\t\t\t};\n\n\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\tif (e.keyCode == 13 && (e.shiftKey || (s.force_br_newlines && !dom.getParent(selection.getNode(), 'h1,h2,h3,h4,h5,h6,ol,ul')))) {\n\t\t\t\t\t\tinsertBr(ed);\n\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// IE specific fixes\n\t\t\tif (isIE) {\n\t\t\t\t// Replaces IE:s auto generated paragraphs with the specified element name\n\t\t\t\tif (s.element != 'P') {\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tt.lastElm = selection.getNode().nodeName;\n\t\t\t\t\t});\n\n\t\t\t\t\ted.onKeyUp.add(function(ed, e) {\n\t\t\t\t\t\tvar bl, n = selection.getNode(), b = ed.getBody();\n\n\t\t\t\t\t\tif (b.childNodes.length === 1 && n.nodeName == 'P') {\n\t\t\t\t\t\t\tn = dom.rename(n, s.element);\n\t\t\t\t\t\t\tselection.select(n);\n\t\t\t\t\t\t\tselection.collapse();\n\t\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t\t} else if (e.keyCode == 13 && !e.shiftKey && t.lastElm != 'P') {\n\t\t\t\t\t\t\tbl = dom.getParent(n, 'p');\n\n\t\t\t\t\t\t\tif (bl) {\n\t\t\t\t\t\t\t\tdom.rename(bl, s.element);\n\t\t\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tgetParentBlock : function(n) {\n\t\t\tvar d = this.dom;\n\n\t\t\treturn d.getParent(n, d.isBlock);\n\t\t},\n\n\t\tinsertPara : function(e) {\n\t\t\tvar t = this, ed = t.editor, dom = ed.dom, d = ed.getDoc(), se = ed.settings, s = ed.selection.getSel(), r = s.getRangeAt(0), b = d.body;\n\t\t\tvar rb, ra, dir, sn, so, en, eo, sb, eb, bn, bef, aft, sc, ec, n, vp = dom.getViewPort(ed.getWin()), y, ch, car;\n\n\t\t\ted.undoManager.beforeChange();\n\n\t\t\t// If root blocks are forced then use Operas default behavior since it's really good\n// Removed due to bug: #1853816\n//\t\t\tif (se.forced_root_block && isOpera)\n//\t\t\t\treturn TRUE;\n\n\t\t\t// Setup before range\n\t\t\trb = d.createRange();\n\n\t\t\t// If is before the first block element and in body, then move it into first block element\n\t\t\trb.setStart(s.anchorNode, s.anchorOffset);\n\t\t\trb.collapse(TRUE);\n\n\t\t\t// Setup after range\n\t\t\tra = d.createRange();\n\n\t\t\t// If is before the first block element and in body, then move it into first block element\n\t\t\tra.setStart(s.focusNode, s.focusOffset);\n\t\t\tra.collapse(TRUE);\n\n\t\t\t// Setup start/end points\n\t\t\tdir = rb.compareBoundaryPoints(rb.START_TO_END, ra) < 0;\n\t\t\tsn = dir ? s.anchorNode : s.focusNode;\n\t\t\tso = dir ? s.anchorOffset : s.focusOffset;\n\t\t\ten = dir ? s.focusNode : s.anchorNode;\n\t\t\teo = dir ? s.focusOffset : s.anchorOffset;\n\n\t\t\t// If selection is in empty table cell\n\t\t\tif (sn === en && /^(TD|TH)$/.test(sn.nodeName)) {\n\t\t\t\tif (sn.firstChild.nodeName == 'BR')\n\t\t\t\t\tdom.remove(sn.firstChild); // Remove BR\n\n\t\t\t\t// Create two new block elements\n\t\t\t\tif (sn.childNodes.length == 0) {\n\t\t\t\t\ted.dom.add(sn, se.element, null, '<br />');\n\t\t\t\t\taft = ed.dom.add(sn, se.element, null, '<br />');\n\t\t\t\t} else {\n\t\t\t\t\tn = sn.innerHTML;\n\t\t\t\t\tsn.innerHTML = '';\n\t\t\t\t\ted.dom.add(sn, se.element, null, n);\n\t\t\t\t\taft = ed.dom.add(sn, se.element, null, '<br />');\n\t\t\t\t}\n\n\t\t\t\t// Move caret into the last one\n\t\t\t\tr = d.createRange();\n\t\t\t\tr.selectNodeContents(aft);\n\t\t\t\tr.collapse(1);\n\t\t\t\ted.selection.setRng(r);\n\n\t\t\t\treturn FALSE;\n\t\t\t}\n\n\t\t\t// If the caret is in an invalid location in FF we need to move it into the first block\n\t\t\tif (sn == b && en == b && b.firstChild && ed.dom.isBlock(b.firstChild)) {\n\t\t\t\tsn = en = sn.firstChild;\n\t\t\t\tso = eo = 0;\n\t\t\t\trb = d.createRange();\n\t\t\t\trb.setStart(sn, 0);\n\t\t\t\tra = d.createRange();\n\t\t\t\tra.setStart(en, 0);\n\t\t\t}\n\n\t\t\t// If the body is totally empty add a BR element this might happen on webkit\n\t\t\tif (!d.body.hasChildNodes()) {\n\t\t\t\td.body.appendChild(dom.create('br'));\n\t\t\t}\n\n\t\t\t// Never use body as start or end node\n\t\t\tsn = sn.nodeName == \"HTML\" ? d.body : sn; // Fix for Opera bug: https://bugs.opera.com/show_bug.cgi?id=273224&comments=yes\n\t\t\tsn = sn.nodeName == \"BODY\" ? sn.firstChild : sn;\n\t\t\ten = en.nodeName == \"HTML\" ? d.body : en; // Fix for Opera bug: https://bugs.opera.com/show_bug.cgi?id=273224&comments=yes\n\t\t\ten = en.nodeName == \"BODY\" ? en.firstChild : en;\n\n\t\t\t// Get start and end blocks\n\t\t\tsb = t.getParentBlock(sn);\n\t\t\teb = t.getParentBlock(en);\n\t\t\tbn = sb ? sb.nodeName : se.element; // Get block name to create\n\n\t\t\t// Return inside list use default browser behavior\n\t\t\tif (n = t.dom.getParent(sb, 'li,pre')) {\n\t\t\t\tif (n.nodeName == 'LI')\n\t\t\t\t\treturn splitList(ed.selection, t.dom, n);\n\n\t\t\t\treturn TRUE;\n\t\t\t}\n\n\t\t\t// If caption or absolute layers then always generate new blocks within\n\t\t\tif (sb && (sb.nodeName == 'CAPTION' || /absolute|relative|fixed/gi.test(dom.getStyle(sb, 'position', 1)))) {\n\t\t\t\tbn = se.element;\n\t\t\t\tsb = null;\n\t\t\t}\n\n\t\t\t// If caption or absolute layers then always generate new blocks within\n\t\t\tif (eb && (eb.nodeName == 'CAPTION' || /absolute|relative|fixed/gi.test(dom.getStyle(sb, 'position', 1)))) {\n\t\t\t\tbn = se.element;\n\t\t\t\teb = null;\n\t\t\t}\n\n\t\t\t// Use P instead\n\t\t\tif (/(TD|TABLE|TH|CAPTION)/.test(bn) || (sb && bn == \"DIV\" && /left|right/gi.test(dom.getStyle(sb, 'float', 1)))) {\n\t\t\t\tbn = se.element;\n\t\t\t\tsb = eb = null;\n\t\t\t}\n\n\t\t\t// Setup new before and after blocks\n\t\t\tbef = (sb && sb.nodeName == bn) ? sb.cloneNode(0) : ed.dom.create(bn);\n\t\t\taft = (eb && eb.nodeName == bn) ? eb.cloneNode(0) : ed.dom.create(bn);\n\n\t\t\t// Remove id from after clone\n\t\t\taft.removeAttribute('id');\n\n\t\t\t// Is header and cursor is at the end, then force paragraph under\n\t\t\tif (/^(H[1-6])$/.test(bn) && isAtEnd(r, sb))\n\t\t\t\taft = ed.dom.create(se.element);\n\n\t\t\t// Find start chop node\n\t\t\tn = sc = sn;\n\t\t\tdo {\n\t\t\t\tif (n == b || n.nodeType == 9 || t.dom.isBlock(n) || /(TD|TABLE|TH|CAPTION)/.test(n.nodeName))\n\t\t\t\t\tbreak;\n\n\t\t\t\tsc = n;\n\t\t\t} while ((n = n.previousSibling ? n.previousSibling : n.parentNode));\n\n\t\t\t// Find end chop node\n\t\t\tn = ec = en;\n\t\t\tdo {\n\t\t\t\tif (n == b || n.nodeType == 9 || t.dom.isBlock(n) || /(TD|TABLE|TH|CAPTION)/.test(n.nodeName))\n\t\t\t\t\tbreak;\n\n\t\t\t\tec = n;\n\t\t\t} while ((n = n.nextSibling ? n.nextSibling : n.parentNode));\n\n\t\t\t// Place first chop part into before block element\n\t\t\tif (sc.nodeName == bn)\n\t\t\t\trb.setStart(sc, 0);\n\t\t\telse\n\t\t\t\trb.setStartBefore(sc);\n\n\t\t\trb.setEnd(sn, so);\n\t\t\tbef.appendChild(rb.cloneContents() || d.createTextNode('')); // Empty text node needed for Safari\n\n\t\t\t// Place secnd chop part within new block element\n\t\t\ttry {\n\t\t\t\tra.setEndAfter(ec);\n\t\t\t} catch(ex) {\n\t\t\t\t//console.debug(s.focusNode, s.focusOffset);\n\t\t\t}\n\n\t\t\tra.setStart(en, eo);\n\t\t\taft.appendChild(ra.cloneContents() || d.createTextNode('')); // Empty text node needed for Safari\n\n\t\t\t// Create range around everything\n\t\t\tr = d.createRange();\n\t\t\tif (!sc.previousSibling && sc.parentNode.nodeName == bn) {\n\t\t\t\tr.setStartBefore(sc.parentNode);\n\t\t\t} else {\n\t\t\t\tif (rb.startContainer.nodeName == bn && rb.startOffset == 0)\n\t\t\t\t\tr.setStartBefore(rb.startContainer);\n\t\t\t\telse\n\t\t\t\t\tr.setStart(rb.startContainer, rb.startOffset);\n\t\t\t}\n\n\t\t\tif (!ec.nextSibling && ec.parentNode.nodeName == bn)\n\t\t\t\tr.setEndAfter(ec.parentNode);\n\t\t\telse\n\t\t\t\tr.setEnd(ra.endContainer, ra.endOffset);\n\n\t\t\t// Delete and replace it with new block elements\n\t\t\tr.deleteContents();\n\n\t\t\tif (isOpera)\n\t\t\t\ted.getWin().scrollTo(0, vp.y);\n\n\t\t\t// Never wrap blocks in blocks\n\t\t\tif (bef.firstChild && bef.firstChild.nodeName == bn)\n\t\t\t\tbef.innerHTML = bef.firstChild.innerHTML;\n\n\t\t\tif (aft.firstChild && aft.firstChild.nodeName == bn)\n\t\t\t\taft.innerHTML = aft.firstChild.innerHTML;\n\n\t\t\tfunction appendStyles(e, en) {\n\t\t\t\tvar nl = [], nn, n, i;\n\n\t\t\t\te.innerHTML = '';\n\n\t\t\t\t// Make clones of style elements\n\t\t\t\tif (se.keep_styles) {\n\t\t\t\t\tn = en;\n\t\t\t\t\tdo {\n\t\t\t\t\t\t// We only want style specific elements\n\t\t\t\t\t\tif (/^(SPAN|STRONG|B|EM|I|FONT|STRIKE|U)$/.test(n.nodeName)) {\n\t\t\t\t\t\t\tnn = n.cloneNode(FALSE);\n\t\t\t\t\t\t\tdom.setAttrib(nn, 'id', ''); // Remove ID since it needs to be unique\n\t\t\t\t\t\t\tnl.push(nn);\n\t\t\t\t\t\t}\n\t\t\t\t\t} while (n = n.parentNode);\n\t\t\t\t}\n\n\t\t\t\t// Append style elements to aft\n\t\t\t\tif (nl.length > 0) {\n\t\t\t\t\tfor (i = nl.length - 1, nn = e; i >= 0; i--)\n\t\t\t\t\t\tnn = nn.appendChild(nl[i]);\n\n\t\t\t\t\t// Padd most inner style element\n\t\t\t\t\tnl[0].innerHTML = isOpera ? '\\u00a0' : '<br />'; // Extra space for Opera so that the caret can move there\n\t\t\t\t\treturn nl[0]; // Move caret to most inner element\n\t\t\t\t} else\n\t\t\t\t\te.innerHTML = isOpera ? '\\u00a0' : '<br />'; // Extra space for Opera so that the caret can move there\n\t\t\t};\n\t\t\t\t\n\t\t\t// Padd empty blocks\n\t\t\tif (dom.isEmpty(bef))\n\t\t\t\tappendStyles(bef, sn);\n\n\t\t\t// Fill empty afterblook with current style\n\t\t\tif (dom.isEmpty(aft))\n\t\t\t\tcar = appendStyles(aft, en);\n\n\t\t\t// Opera needs this one backwards for older versions\n\t\t\tif (isOpera && parseFloat(opera.version()) < 9.5) {\n\t\t\t\tr.insertNode(bef);\n\t\t\t\tr.insertNode(aft);\n\t\t\t} else {\n\t\t\t\tr.insertNode(aft);\n\t\t\t\tr.insertNode(bef);\n\t\t\t}\n\n\t\t\t// Normalize\n\t\t\taft.normalize();\n\t\t\tbef.normalize();\n\n\t\t\t// Move cursor and scroll into view\n\t\t\ted.selection.select(aft, true);\n\t\t\ted.selection.collapse(true);\n\n\t\t\t// scrollIntoView seems to scroll the parent window in most browsers now including FF 3.0b4 so it's time to stop using it and do it our selfs\n\t\t\ty = ed.dom.getPos(aft).y;\n\t\t\t//ch = aft.clientHeight;\n\n\t\t\t// Is element within viewport\n\t\t\tif (y < vp.y || y + 25 > vp.y + vp.h) {\n\t\t\t\ted.getWin().scrollTo(0, y < vp.y ? y : y - vp.h + 25); // Needs to be hardcoded to roughly one line of text if a huge text block is broken into two blocks\n\n\t\t\t\t/*console.debug(\n\t\t\t\t\t'Element: y=' + y + ', h=' + ch + ', ' +\n\t\t\t\t\t'Viewport: y=' + vp.y + \", h=\" + vp.h + ', bottom=' + (vp.y + vp.h)\n\t\t\t\t);*/\n\t\t\t}\n\n\t\t\ted.undoManager.add();\n\n\t\t\treturn FALSE;\n\t\t},\n\n\t\tbackspaceDelete : function(e, bs) {\n\t\t\tvar t = this, ed = t.editor, b = ed.getBody(), dom = ed.dom, n, se = ed.selection, r = se.getRng(), sc = r.startContainer, n, w, tn, walker;\n\n\t\t\t// Delete when caret is behind a element doesn't work correctly on Gecko see #3011651\n\t\t\tif (!bs && r.collapsed && sc.nodeType == 1 && r.startOffset == sc.childNodes.length) {\n\t\t\t\twalker = new tinymce.dom.TreeWalker(sc.lastChild, sc);\n\n\t\t\t\t// Walk the dom backwards until we find a text node\n\t\t\t\tfor (n = sc.lastChild; n; n = walker.prev()) {\n\t\t\t\t\tif (n.nodeType == 3) {\n\t\t\t\t\t\tr.setStart(n, n.nodeValue.length);\n\t\t\t\t\t\tr.collapse(true);\n\t\t\t\t\t\tse.setRng(r);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// The caret sometimes gets stuck in Gecko if you delete empty paragraphs\n\t\t\t// This workaround removes the element by hand and moves the caret to the previous element\n\t\t\tif (sc && ed.dom.isBlock(sc) && !/^(TD|TH)$/.test(sc.nodeName) && bs) {\n\t\t\t\tif (sc.childNodes.length == 0 || (sc.childNodes.length == 1 && sc.firstChild.nodeName == 'BR')) {\n\t\t\t\t\t// Find previous block element\n\t\t\t\t\tn = sc;\n\t\t\t\t\twhile ((n = n.previousSibling) && !ed.dom.isBlock(n)) ;\n\n\t\t\t\t\tif (n) {\n\t\t\t\t\t\tif (sc != b.firstChild) {\n\t\t\t\t\t\t\t// Find last text node\n\t\t\t\t\t\t\tw = ed.dom.doc.createTreeWalker(n, NodeFilter.SHOW_TEXT, null, FALSE);\n\t\t\t\t\t\t\twhile (tn = w.nextNode())\n\t\t\t\t\t\t\t\tn = tn;\n\n\t\t\t\t\t\t\t// Place caret at the end of last text node\n\t\t\t\t\t\t\tr = ed.getDoc().createRange();\n\t\t\t\t\t\t\tr.setStart(n, n.nodeValue ? n.nodeValue.length : 0);\n\t\t\t\t\t\t\tr.setEnd(n, n.nodeValue ? n.nodeValue.length : 0);\n\t\t\t\t\t\t\tse.setRng(r);\n\n\t\t\t\t\t\t\t// Remove the target container\n\t\t\t\t\t\t\ted.dom.remove(sc);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\t// Shorten names\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each, extend = tinymce.extend;\n\n\ttinymce.create('tinymce.ControlManager', {\n\t\tControlManager : function(ed, s) {\n\t\t\tvar t = this, i;\n\n\t\t\ts = s || {};\n\t\t\tt.editor = ed;\n\t\t\tt.controls = {};\n\t\t\tt.onAdd = new tinymce.util.Dispatcher(t);\n\t\t\tt.onPostRender = new tinymce.util.Dispatcher(t);\n\t\t\tt.prefix = s.prefix || ed.id + '_';\n\t\t\tt._cls = {};\n\n\t\t\tt.onPostRender.add(function() {\n\t\t\t\teach(t.controls, function(c) {\n\t\t\t\t\tc.postRender();\n\t\t\t\t});\n\t\t\t});\n\t\t},\n\n\t\tget : function(id) {\n\t\t\treturn this.controls[this.prefix + id] || this.controls[id];\n\t\t},\n\n\t\tsetActive : function(id, s) {\n\t\t\tvar c = null;\n\n\t\t\tif (c = this.get(id))\n\t\t\t\tc.setActive(s);\n\n\t\t\treturn c;\n\t\t},\n\n\t\tsetDisabled : function(id, s) {\n\t\t\tvar c = null;\n\n\t\t\tif (c = this.get(id))\n\t\t\t\tc.setDisabled(s);\n\n\t\t\treturn c;\n\t\t},\n\n\t\tadd : function(c) {\n\t\t\tvar t = this;\n\n\t\t\tif (c) {\n\t\t\t\tt.controls[c.id] = c;\n\t\t\t\tt.onAdd.dispatch(c, t);\n\t\t\t}\n\n\t\t\treturn c;\n\t\t},\n\n\t\tcreateControl : function(n) {\n\t\t\tvar c, t = this, ed = t.editor;\n\n\t\t\teach(ed.plugins, function(p) {\n\t\t\t\tif (p.createControl) {\n\t\t\t\t\tc = p.createControl(n, t);\n\n\t\t\t\t\tif (c)\n\t\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tswitch (n) {\n\t\t\t\tcase \"|\":\n\t\t\t\tcase \"separator\":\n\t\t\t\t\treturn t.createSeparator();\n\t\t\t}\n\n\t\t\tif (!c && ed.buttons && (c = ed.buttons[n]))\n\t\t\t\treturn t.createButton(n, c);\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateDropMenu : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, c, bm, v, cls;\n\n\t\t\ts = extend({\n\t\t\t\t'class' : 'mceDropDown',\n\t\t\t\tconstrain : ed.settings.constrain_menus\n\t\t\t}, s);\n\n\t\t\ts['class'] = s['class'] + ' ' + ed.getParam('skin') + 'Skin';\n\t\t\tif (v = ed.getParam('skin_variant'))\n\t\t\t\ts['class'] += ' ' + ed.getParam('skin') + 'Skin' + v.substring(0, 1).toUpperCase() + v.substring(1);\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.dropmenu || tinymce.ui.DropMenu;\n\t\t\tc = t.controls[id] = new cls(id, s);\n\t\t\tc.onAddItem.add(function(c, o) {\n\t\t\t\tvar s = o.settings;\n\n\t\t\t\ts.title = ed.getLang(s.title, s.title);\n\n\t\t\t\tif (!s.onclick) {\n\t\t\t\t\ts.onclick = function(v) {\n\t\t\t\t\t\tif (s.cmd)\n\t\t\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, s.value);\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t});\n\n\t\t\ted.onRemove.add(function() {\n\t\t\t\tc.destroy();\n\t\t\t});\n\n\t\t\t// Fix for bug #1897785, #1898007\n\t\t\tif (tinymce.isIE) {\n\t\t\t\tc.onShowMenu.add(function() {\n\t\t\t\t\t// IE 8 needs focus in order to store away a range with the current collapsed caret location\n\t\t\t\t\ted.focus();\n\n\t\t\t\t\tbm = ed.selection.getBookmark(1);\n\t\t\t\t});\n\n\t\t\t\tc.onHideMenu.add(function() {\n\t\t\t\t\tif (bm) {\n\t\t\t\t\t\ted.selection.moveToBookmark(bm);\n\t\t\t\t\t\tbm = 0;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateListBox : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, cmd, c, cls;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onselect) {\n\t\t\t\ts.onselect = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\tscope : s.scope,\n\t\t\t\tcontrol_manager : t\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\n\n\t\t\tfunction useNativeListForAccessibility(ed) {\n\t\t\t\treturn ed.settings.use_accessible_selects && !tinymce.isGecko\n\t\t\t}\n\n\t\t\tif (ed.settings.use_native_selects || useNativeListForAccessibility(ed))\n\t\t\t\tc = new tinymce.ui.NativeListBox(id, s);\n\t\t\telse {\n\t\t\t\tcls = cc || t._cls.listbox || tinymce.ui.ListBox;\n\t\t\t\tc = new cls(id, s, ed);\n\t\t\t}\n\n\t\t\tt.controls[id] = c;\n\n\t\t\t// Fix focus problem in Safari\n\t\t\tif (tinymce.isWebKit) {\n\t\t\t\tc.onPostRender.add(function(c, n) {\n\t\t\t\t\t// Store bookmark on mousedown\n\t\t\t\t\tEvent.add(n, 'mousedown', function() {\n\t\t\t\t\t\ted.bookmark = ed.selection.getBookmark(1);\n\t\t\t\t\t});\n\n\t\t\t\t\t// Restore on focus, since it might be lost\n\t\t\t\t\tEvent.add(n, 'focus', function() {\n\t\t\t\t\t\ted.selection.moveToBookmark(ed.bookmark);\n\t\t\t\t\t\ted.bookmark = null;\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (c.hideMenu)\n\t\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateButton : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, o, c, cls;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.label = ed.translate(s.label);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onclick && !s.menu_button) {\n\t\t\t\ts.onclick = function() {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\tunavailable_prefix : ed.getLang('unavailable', ''),\n\t\t\t\tscope : s.scope,\n\t\t\t\tcontrol_manager : t\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\n\t\t\tif (s.menu_button) {\n\t\t\t\tcls = cc || t._cls.menubutton || tinymce.ui.MenuButton;\n\t\t\t\tc = new cls(id, s, ed);\n\t\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\t\t\t} else {\n\t\t\t\tcls = t._cls.button || tinymce.ui.Button;\n\t\t\t\tc = new cls(id, s, ed);\n\t\t\t}\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateMenuButton : function(id, s, cc) {\n\t\t\ts = s || {};\n\t\t\ts.menu_button = 1;\n\n\t\t\treturn this.createButton(id, s, cc);\n\t\t},\n\n\t\tcreateSplitButton : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, cmd, c, cls;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onclick) {\n\t\t\t\ts.onclick = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (!s.onselect) {\n\t\t\t\ts.onselect = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\tscope : s.scope,\n\t\t\t\tcontrol_manager : t\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.splitbutton || tinymce.ui.SplitButton;\n\t\t\tc = t.add(new cls(id, s, ed));\n\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\n\t\t\treturn c;\n\t\t},\n\n\t\tcreateColorSplitButton : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, cmd, c, cls, bm;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onclick) {\n\t\t\t\ts.onclick = function(v) {\n\t\t\t\t\tif (tinymce.isIE)\n\t\t\t\t\t\tbm = ed.selection.getBookmark(1);\n\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (!s.onselect) {\n\t\t\t\ts.onselect = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\t'menu_class' : ed.getParam('skin') + 'Skin',\n\t\t\t\tscope : s.scope,\n\t\t\t\tmore_colors_title : ed.getLang('more_colors')\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.colorsplitbutton || tinymce.ui.ColorSplitButton;\n\t\t\tc = new cls(id, s, ed);\n\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\n\t\t\t// Remove the menu element when the editor is removed\n\t\t\ted.onRemove.add(function() {\n\t\t\t\tc.destroy();\n\t\t\t});\n\n\t\t\t// Fix for bug #1897785, #1898007\n\t\t\tif (tinymce.isIE) {\n\t\t\t\tc.onShowMenu.add(function() {\n\t\t\t\t\t// IE 8 needs focus in order to store away a range with the current collapsed caret location\n\t\t\t\t\ted.focus();\n\t\t\t\t\tbm = ed.selection.getBookmark(1);\n\t\t\t\t});\n\n\t\t\t\tc.onHideMenu.add(function() {\n\t\t\t\t\tif (bm) {\n\t\t\t\t\t\ted.selection.moveToBookmark(bm);\n\t\t\t\t\t\tbm = 0;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateToolbar : function(id, s, cc) {\n\t\t\tvar c, t = this, cls;\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.toolbar || tinymce.ui.Toolbar;\n\t\t\tc = new cls(id, s, t.editor);\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\treturn t.add(c);\n\t\t},\n\t\t\n\t\tcreateToolbarGroup : function(id, s, cc) {\n\t\t\tvar c, t = this, cls;\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || this._cls.toolbarGroup || tinymce.ui.ToolbarGroup;\n\t\t\tc = new cls(id, s, t.editor);\n\t\t\t\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\t\t\t\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateSeparator : function(cc) {\n\t\t\tvar cls = cc || this._cls.separator || tinymce.ui.Separator;\n\n\t\t\treturn new cls();\n\t\t},\n\n\t\tsetControlType : function(n, c) {\n\t\t\treturn this._cls[n.toLowerCase()] = c;\n\t\t},\n\t\n\t\tdestroy : function() {\n\t\t\teach(this.controls, function(c) {\n\t\t\t\tc.destroy();\n\t\t\t});\n\n\t\t\tthis.controls = null;\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar Dispatcher = tinymce.util.Dispatcher, each = tinymce.each, isIE = tinymce.isIE, isOpera = tinymce.isOpera;\n\n\ttinymce.create('tinymce.WindowManager', {\n\t\tWindowManager : function(ed) {\n\t\t\tvar t = this;\n\n\t\t\tt.editor = ed;\n\t\t\tt.onOpen = new Dispatcher(t);\n\t\t\tt.onClose = new Dispatcher(t);\n\t\t\tt.params = {};\n\t\t\tt.features = {};\n\t\t},\n\n\t\topen : function(s, p) {\n\t\t\tvar t = this, f = '', x, y, mo = t.editor.settings.dialog_type == 'modal', w, sw, sh, vp = tinymce.DOM.getViewPort(), u;\n\n\t\t\t// Default some options\n\t\t\ts = s || {};\n\t\t\tp = p || {};\n\t\t\tsw = isOpera ? vp.w : screen.width; // Opera uses windows inside the Opera window\n\t\t\tsh = isOpera ? vp.h : screen.height;\n\t\t\ts.name = s.name || 'mc_' + new Date().getTime();\n\t\t\ts.width = parseInt(s.width || 320);\n\t\t\ts.height = parseInt(s.height || 240);\n\t\t\ts.resizable = true;\n\t\t\ts.left = s.left || parseInt(sw / 2.0) - (s.width / 2.0);\n\t\t\ts.top = s.top || parseInt(sh / 2.0) - (s.height / 2.0);\n\t\t\tp.inline = false;\n\t\t\tp.mce_width = s.width;\n\t\t\tp.mce_height = s.height;\n\t\t\tp.mce_auto_focus = s.auto_focus;\n\n\t\t\tif (mo) {\n\t\t\t\tif (isIE) {\n\t\t\t\t\ts.center = true;\n\t\t\t\t\ts.help = false;\n\t\t\t\t\ts.dialogWidth = s.width + 'px';\n\t\t\t\t\ts.dialogHeight = s.height + 'px';\n\t\t\t\t\ts.scroll = s.scrollbars || false;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Build features string\n\t\t\teach(s, function(v, k) {\n\t\t\t\tif (tinymce.is(v, 'boolean'))\n\t\t\t\t\tv = v ? 'yes' : 'no';\n\n\t\t\t\tif (!/^(name|url)$/.test(k)) {\n\t\t\t\t\tif (isIE && mo)\n\t\t\t\t\t\tf += (f ? ';' : '') + k + ':' + v;\n\t\t\t\t\telse\n\t\t\t\t\t\tf += (f ? ',' : '') + k + '=' + v;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.features = s;\n\t\t\tt.params = p;\n\t\t\tt.onOpen.dispatch(t, s, p);\n\n\t\t\tu = s.url || s.file;\n\t\t\tu = tinymce._addVer(u);\n\n\t\t\ttry {\n\t\t\t\tif (isIE && mo) {\n\t\t\t\t\tw = 1;\n\t\t\t\t\twindow.showModalDialog(u, window, f);\n\t\t\t\t} else\n\t\t\t\t\tw = window.open(u, s.name, f);\n\t\t\t} catch (ex) {\n\t\t\t\t// Ignore\n\t\t\t}\n\n\t\t\tif (!w)\n\t\t\t\talert(t.editor.getLang('popup_blocked'));\n\t\t},\n\n\t\tclose : function(w) {\n\t\t\tw.close();\n\t\t\tthis.onClose.dispatch(this);\n\t\t},\n\n\t\tcreateInstance : function(cl, a, b, c, d, e) {\n\t\t\tvar f = tinymce.resolve(cl);\n\n\t\t\treturn new f(a, b, c, d, e);\n\t\t},\n\n\t\tconfirm : function(t, cb, s, w) {\n\t\t\tw = w || window;\n\n\t\t\tcb.call(s || this, w.confirm(this._decode(this.editor.getLang(t, t))));\n\t\t},\n\n\t\talert : function(tx, cb, s, w) {\n\t\t\tvar t = this;\n\n\t\t\tw = w || window;\n\t\t\tw.alert(t._decode(t.editor.getLang(tx, tx)));\n\n\t\t\tif (cb)\n\t\t\t\tcb.call(s || t);\n\t\t},\n\n\t\tresizeBy : function(dw, dh, win) {\n\t\t\twin.resizeBy(dw, dh);\n\t\t},\n\n\t\t// Internal functions\n\n\t\t_decode : function(s) {\n\t\t\treturn tinymce.DOM.decode(s).replace(/\\\\n/g, '\\n');\n\t\t}\n\t});\n}(tinymce));\n(function(tinymce) {\n\ttinymce.Formatter = function(ed) {\n\t\tvar formats = {},\n\t\t\teach = tinymce.each,\n\t\t\tdom = ed.dom,\n\t\t\tselection = ed.selection,\n\t\t\tTreeWalker = tinymce.dom.TreeWalker,\n\t\t\trangeUtils = new tinymce.dom.RangeUtils(dom),\n\t\t\tisValid = ed.schema.isValidChild,\n\t\t\tisBlock = dom.isBlock,\n\t\t\tforcedRootBlock = ed.settings.forced_root_block,\n\t\t\tnodeIndex = dom.nodeIndex,\n\t\t\tINVISIBLE_CHAR = '\\uFEFF',\n\t\t\tMCE_ATTR_RE = /^(src|href|style)$/,\n\t\t\tFALSE = false,\n\t\t\tTRUE = true,\n\t\t\tundefined;\n\n\t\tfunction isArray(obj) {\n\t\t\treturn obj instanceof Array;\n\t\t};\n\n\t\tfunction getParents(node, selector) {\n\t\t\treturn dom.getParents(node, selector, dom.getRoot());\n\t\t};\n\n\t\tfunction isCaretNode(node) {\n\t\t\treturn node.nodeType === 1 && (node.face === 'mceinline' || node.style.fontFamily === 'mceinline');\n\t\t};\n\n\t\t// Public functions\n\n\t\tfunction get(name) {\n\t\t\treturn name ? formats[name] : formats;\n\t\t};\n\n\t\tfunction register(name, format) {\n\t\t\tif (name) {\n\t\t\t\tif (typeof(name) !== 'string') {\n\t\t\t\t\teach(name, function(format, name) {\n\t\t\t\t\t\tregister(name, format);\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\t// Force format into array and add it to internal collection\n\t\t\t\t\tformat = format.length ? format : [format];\n\n\t\t\t\t\teach(format, function(format) {\n\t\t\t\t\t\t// Set deep to false by default on selector formats this to avoid removing\n\t\t\t\t\t\t// alignment on images inside paragraphs when alignment is changed on paragraphs\n\t\t\t\t\t\tif (format.deep === undefined)\n\t\t\t\t\t\t\tformat.deep = !format.selector;\n\n\t\t\t\t\t\t// Default to true\n\t\t\t\t\t\tif (format.split === undefined)\n\t\t\t\t\t\t\tformat.split = !format.selector || format.inline;\n\n\t\t\t\t\t\t// Default to true\n\t\t\t\t\t\tif (format.remove === undefined && format.selector && !format.inline)\n\t\t\t\t\t\t\tformat.remove = 'none';\n\n\t\t\t\t\t\t// Mark format as a mixed format inline + block level\n\t\t\t\t\t\tif (format.selector && format.inline) {\n\t\t\t\t\t\t\tformat.mixed = true;\n\t\t\t\t\t\t\tformat.block_expand = true;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Split classes if needed\n\t\t\t\t\t\tif (typeof(format.classes) === 'string')\n\t\t\t\t\t\t\tformat.classes = format.classes.split(/\\s+/);\n\t\t\t\t\t});\n\n\t\t\t\t\tformats[name] = format;\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tvar getTextDecoration = function(node) {\n\t\t\tvar decoration;\n\n\t\t\ted.dom.getParent(node, function(n) {\n\t\t\t\tdecoration = ed.dom.getStyle(n, 'text-decoration');\n\t\t\t\treturn decoration && decoration !== 'none';\n\t\t\t});\n\n\t\t\treturn decoration;\n\t\t};\n\n\t\tvar processUnderlineAndColor = function(node) {\n\t\t\tvar textDecoration;\n\t\t\tif (node.nodeType === 1 && node.parentNode && node.parentNode.nodeType === 1) {\n\t\t\t\ttextDecoration = getTextDecoration(node.parentNode);\n\t\t\t\tif (ed.dom.getStyle(node, 'color') && textDecoration) {\n\t\t\t\t\ted.dom.setStyle(node, 'text-decoration', textDecoration);\n\t\t\t\t} else if (ed.dom.getStyle(node, 'textdecoration') === textDecoration) {\n\t\t\t\t\ted.dom.setStyle(node, 'text-decoration', null);\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction apply(name, vars, node) {\n\t\t\tvar formatList = get(name), format = formatList[0], bookmark, rng, i, isCollapsed = selection.isCollapsed();\n\n\t\t\tfunction moveStart(rng) {\n\t\t\t\tvar container = rng.startContainer,\n\t\t\t\t\toffset = rng.startOffset,\n\t\t\t\t\twalker, node;\n\n\t\t\t\t// Move startContainer/startOffset in to a suitable node\n\t\t\t\tif (container.nodeType == 1 || container.nodeValue === \"\") {\n\t\t\t\t\tcontainer = container.nodeType == 1 ? container.childNodes[offset] : container;\n\n\t\t\t\t\t// Might fail if the offset is behind the last element in it's container\n\t\t\t\t\tif (container) {\n\t\t\t\t\t\twalker = new TreeWalker(container, container.parentNode);\n\t\t\t\t\t\tfor (node = walker.current(); node; node = walker.next()) {\n\t\t\t\t\t\t\tif (node.nodeType == 3 && !isWhiteSpaceNode(node)) {\n\t\t\t\t\t\t\t\trng.setStart(node, 0);\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn rng;\n\t\t\t};\n\n\t\t\tfunction setElementFormat(elm, fmt) {\n\t\t\t\tfmt = fmt || format;\n\n\t\t\t\tif (elm) {\n\t\t\t\t\tif (fmt.onformat) {\n\t\t\t\t\t\tfmt.onformat(elm, fmt, vars, node);\n\t\t\t\t\t}\n\n\t\t\t\t\teach(fmt.styles, function(value, name) {\n\t\t\t\t\t\tdom.setStyle(elm, name, replaceVars(value, vars));\n\t\t\t\t\t});\n\n\t\t\t\t\teach(fmt.attributes, function(value, name) {\n\t\t\t\t\t\tdom.setAttrib(elm, name, replaceVars(value, vars));\n\t\t\t\t\t});\n\n\t\t\t\t\teach(fmt.classes, function(value) {\n\t\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\t\tif (!dom.hasClass(elm, value))\n\t\t\t\t\t\t\tdom.addClass(elm, value);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t};\n\t\t\tfunction adjustSelectionToVisibleSelection() {\n\t\t\t\tfunction findSelectionEnd(start, end) {\n\t\t\t\t\tvar walker = new TreeWalker(end);\n\t\t\t\t\tfor (node = walker.current(); node; node = walker.prev()) {\n\t\t\t\t\t\tif (node.childNodes.length > 1 || node == start) {\n\t\t\t\t\t\t\treturn node;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\t// Adjust selection so that a end container with a end offset of zero is not included in the selection\n\t\t\t\t// as this isn't visible to the user.\n\t\t\t\tvar rng = ed.selection.getRng();\n\t\t\t\tvar start = rng.startContainer;\n\t\t\t\tvar end = rng.endContainer;\n\n\t\t\t\tif (start != end && rng.endOffset == 0) {\n\t\t\t\t\tvar newEnd = findSelectionEnd(start, end);\n\t\t\t\t\tvar endOffset = newEnd.nodeType == 3 ? newEnd.length : newEnd.childNodes.length;\n\n\t\t\t\t\trng.setEnd(newEnd, endOffset);\n\t\t\t\t}\n\n\t\t\t\treturn rng;\n\t\t\t}\n\t\t\t\n\t\t\tfunction applyStyleToList(node, bookmark, wrapElm, newWrappers, process){\n\t\t\t\tvar nodes = [], listIndex = -1, list, startIndex = -1, endIndex = -1, currentWrapElm;\n\t\t\t\t\n\t\t\t\t// find the index of the first child list.\n\t\t\t\teach(node.childNodes, function(n, index) {\n\t\t\t\t\tif (n.nodeName === \"UL\" || n.nodeName === \"OL\") {\n\t\t\t\t\t\tlistIndex = index;\n\t\t\t\t\t\tlist = n;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t\t\n\t\t\t\t// get the index of the bookmarks\n\t\t\t\teach(node.childNodes, function(n, index) {\n\t\t\t\t\tif (n.nodeName === \"SPAN\" && dom.getAttrib(n, \"data-mce-type\") == \"bookmark\") {\n\t\t\t\t\t\tif (n.id == bookmark.id + \"_start\") {\n\t\t\t\t\t\t\tstartIndex = index;\n\t\t\t\t\t\t} else if (n.id == bookmark.id + \"_end\") {\n\t\t\t\t\t\t\tendIndex = index;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t\t\n\t\t\t\t// if the selection spans across an embedded list, or there isn't an embedded list - handle processing normally\n\t\t\t\tif (listIndex <= 0 || (startIndex < listIndex && endIndex > listIndex)) {\n\t\t\t\t\teach(tinymce.grep(node.childNodes), process);\n\t\t\t\t\treturn 0;\n\t\t\t\t} else {\n\t\t\t\t\tcurrentWrapElm = wrapElm.cloneNode(FALSE);\n\t\t\t\t\t\n\t\t\t\t\t// create a list of the nodes on the same side of the list as the selection\n\t\t\t\t\teach(tinymce.grep(node.childNodes), function(n, index) {\n\t\t\t\t\t\tif ((startIndex < listIndex && index < listIndex) || (startIndex > listIndex && index > listIndex)) {\n\t\t\t\t\t\t\tnodes.push(n); \n\t\t\t\t\t\t\tn.parentNode.removeChild(n);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\t\n\t\t\t\t\t// insert the wrapping element either before or after the list.\n\t\t\t\t\tif (startIndex < listIndex) {\n\t\t\t\t\t\tnode.insertBefore(currentWrapElm, list);\n\t\t\t\t\t} else if (startIndex > listIndex) {\n\t\t\t\t\t\tnode.insertBefore(currentWrapElm, list.nextSibling);\n\t\t\t\t\t}\n\t\t\t\t\t\n\t\t\t\t\t// add the new nodes to the list.\n\t\t\t\t\tnewWrappers.push(currentWrapElm);\n\n\t\t\t\t\teach(nodes, function(node) {\n\t\t\t\t\t\tcurrentWrapElm.appendChild(node);\n\t\t\t\t\t});\n\n\t\t\t\t\treturn currentWrapElm;\n\t\t\t\t}\n\t\t\t};\n\t\t\t\n\t\t\tfunction applyRngStyle(rng, bookmark, node_specific) {\n\t\t\t\tvar newWrappers = [], wrapName, wrapElm;\n\n\t\t\t\t// Setup wrapper element\n\t\t\t\twrapName = format.inline || format.block;\n\t\t\t\twrapElm = dom.create(wrapName);\n\t\t\t\tsetElementFormat(wrapElm);\n\n\t\t\t\trangeUtils.walk(rng, function(nodes) {\n\t\t\t\t\tvar currentWrapElm;\n\n\t\t\t\t\tfunction process(node) {\n\t\t\t\t\t\tvar nodeName = node.nodeName.toLowerCase(), parentName = node.parentNode.nodeName.toLowerCase(), found;\n\n\t\t\t\t\t\t// Stop wrapping on br elements\n\t\t\t\t\t\tif (isEq(nodeName, 'br')) {\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\n\t\t\t\t\t\t\t// Remove any br elements when we wrap things\n\t\t\t\t\t\t\tif (format.block)\n\t\t\t\t\t\t\t\tdom.remove(node);\n\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// If node is wrapper type\n\t\t\t\t\t\tif (format.wrapper && matchNode(node, name, vars)) {\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Can we rename the block\n\t\t\t\t\t\tif (format.block && !format.wrapper && isTextBlock(nodeName)) {\n\t\t\t\t\t\t\tnode = dom.rename(node, wrapName);\n\t\t\t\t\t\t\tsetElementFormat(node);\n\t\t\t\t\t\t\tnewWrappers.push(node);\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Handle selector patterns\n\t\t\t\t\t\tif (format.selector) {\n\t\t\t\t\t\t\t// Look for matching formats\n\t\t\t\t\t\t\teach(formatList, function(format) {\n\t\t\t\t\t\t\t\t// Check collapsed state if it exists\n\t\t\t\t\t\t\t\tif ('collapsed' in format && format.collapsed !== isCollapsed) {\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tif (dom.is(node, format.selector) && !isCaretNode(node)) {\n\t\t\t\t\t\t\t\t\tsetElementFormat(node, format);\n\t\t\t\t\t\t\t\t\tfound = true;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t// Continue processing if a selector match wasn't found and a inline element is defined\n\t\t\t\t\t\t\tif (!format.inline || found) {\n\t\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Is it valid to wrap this item\n\t\t\t\t\t\tif (isValid(wrapName, nodeName) && isValid(parentName, wrapName) &&\n\t\t\t\t\t\t\t\t!(!node_specific && node.nodeType === 3 && node.nodeValue.length === 1 && node.nodeValue.charCodeAt(0) === 65279) && node.id !== '_mce_caret') {\n\t\t\t\t\t\t\t// Start wrapping\n\t\t\t\t\t\t\tif (!currentWrapElm) {\n\t\t\t\t\t\t\t\t// Wrap the node\n\t\t\t\t\t\t\t\tcurrentWrapElm = wrapElm.cloneNode(FALSE);\n\t\t\t\t\t\t\t\tnode.parentNode.insertBefore(currentWrapElm, node);\n\t\t\t\t\t\t\t\tnewWrappers.push(currentWrapElm);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tcurrentWrapElm.appendChild(node);\n\t\t\t\t\t\t} else if (nodeName == 'li' && bookmark) {\n\t\t\t\t\t\t\t// Start wrapping - if we are in a list node and have a bookmark, then we will always begin by wrapping in a new element.\n\t\t\t\t\t\t\tcurrentWrapElm = applyStyleToList(node, bookmark, wrapElm, newWrappers, process);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Start a new wrapper for possible children\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\n\t\t\t\t\t\t\teach(tinymce.grep(node.childNodes), process);\n\n\t\t\t\t\t\t\t// End the last wrapper\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\t\t// Process siblings from range\n\t\t\t\t\teach(nodes, process);\n\t\t\t\t});\n\n\t\t\t\t// Wrap links inside as well, for example color inside a link when the wrapper is around the link\n\t\t\t\tif (format.wrap_links === false) {\n\t\t\t\t\teach(newWrappers, function(node) {\n\t\t\t\t\t\tfunction process(node) {\n\t\t\t\t\t\t\tvar i, currentWrapElm, children;\n\n\t\t\t\t\t\t\tif (node.nodeName === 'A') {\n\t\t\t\t\t\t\t\tcurrentWrapElm = wrapElm.cloneNode(FALSE);\n\t\t\t\t\t\t\t\tnewWrappers.push(currentWrapElm);\n\n\t\t\t\t\t\t\t\tchildren = tinymce.grep(node.childNodes);\n\t\t\t\t\t\t\t\tfor (i = 0; i < children.length; i++)\n\t\t\t\t\t\t\t\t\tcurrentWrapElm.appendChild(children[i]);\n\n\t\t\t\t\t\t\t\tnode.appendChild(currentWrapElm);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\teach(tinymce.grep(node.childNodes), process);\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tprocess(node);\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\t// Cleanup\n\t\t\t\teach(newWrappers, function(node) {\n\t\t\t\t\tvar childCount;\n\n\t\t\t\t\tfunction getChildCount(node) {\n\t\t\t\t\t\tvar count = 0;\n\n\t\t\t\t\t\teach(node.childNodes, function(node) {\n\t\t\t\t\t\t\tif (!isWhiteSpaceNode(node) && !isBookmarkNode(node))\n\t\t\t\t\t\t\t\tcount++;\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\treturn count;\n\t\t\t\t\t};\n\n\t\t\t\t\tfunction mergeStyles(node) {\n\t\t\t\t\t\tvar child, clone;\n\n\t\t\t\t\t\teach(node.childNodes, function(node) {\n\t\t\t\t\t\t\tif (node.nodeType == 1 && !isBookmarkNode(node) && !isCaretNode(node)) {\n\t\t\t\t\t\t\t\tchild = node;\n\t\t\t\t\t\t\t\treturn FALSE; // break loop\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\t// If child was found and of the same type as the current node\n\t\t\t\t\t\tif (child && matchName(child, format)) {\n\t\t\t\t\t\t\tclone = child.cloneNode(FALSE);\n\t\t\t\t\t\t\tsetElementFormat(clone);\n\n\t\t\t\t\t\t\tdom.replace(clone, node, TRUE);\n\t\t\t\t\t\t\tdom.remove(child, 1);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn clone || node;\n\t\t\t\t\t};\n\n\t\t\t\t\tchildCount = getChildCount(node);\n\n\t\t\t\t\t// Remove empty nodes but only if there is multiple wrappers and they are not block\n\t\t\t\t\t// elements so never remove single <h1></h1> since that would remove the current empty block element where the caret is at\n\t\t\t\t\tif ((newWrappers.length > 1 || !isBlock(node)) && childCount === 0) {\n\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (format.inline || format.wrapper) {\n\t\t\t\t\t\t// Merges the current node with it's children of similar type to reduce the number of elements\n\t\t\t\t\t\tif (!format.exact && childCount === 1)\n\t\t\t\t\t\t\tnode = mergeStyles(node);\n\n\t\t\t\t\t\t// Remove/merge children\n\t\t\t\t\t\teach(formatList, function(format) {\n\t\t\t\t\t\t\t// Merge all children of similar type will move styles from child to parent\n\t\t\t\t\t\t\t// this: <span style=\"color:red\"><b><span style=\"color:red; font-size:10px\">text</span></b></span>\n\t\t\t\t\t\t\t// will become: <span style=\"color:red\"><b><span style=\"font-size:10px\">text</span></b></span>\n\t\t\t\t\t\t\teach(dom.select(format.inline, node), function(child) {\n\t\t\t\t\t\t\t\tvar parent;\n\n\t\t\t\t\t\t\t\t// When wrap_links is set to false we don't want\n\t\t\t\t\t\t\t\t// to remove the format on children within links\n\t\t\t\t\t\t\t\tif (format.wrap_links === false) {\n\t\t\t\t\t\t\t\t\tparent = child.parentNode;\n\n\t\t\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\t\t\tif (parent.nodeName === 'A')\n\t\t\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t\t} while (parent = parent.parentNode);\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tremoveFormat(format, vars, child, format.exact ? child : null);\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\t// Remove child if direct parent is of same type\n\t\t\t\t\t\tif (matchNode(node.parentNode, name, vars)) {\n\t\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t\t\tnode = 0;\n\t\t\t\t\t\t\treturn TRUE;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Look for parent with similar style format\n\t\t\t\t\t\tif (format.merge_with_parents) {\n\t\t\t\t\t\t\tdom.getParent(node.parentNode, function(parent) {\n\t\t\t\t\t\t\t\tif (matchNode(parent, name, vars)) {\n\t\t\t\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t\t\t\t\tnode = 0;\n\t\t\t\t\t\t\t\t\treturn TRUE;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Merge next and previous siblings if they are similar <b>text</b><b>text</b> becomes <b>texttext</b>\n\t\t\t\t\t\tif (node && format.merge_siblings !== false) {\n\t\t\t\t\t\t\tnode = mergeSiblings(getNonWhiteSpaceSibling(node), node);\n\t\t\t\t\t\t\tnode = mergeSiblings(node, getNonWhiteSpaceSibling(node, TRUE));\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t};\n\n\t\t\tif (format) {\n\t\t\t\tif (node) {\n\t\t\t\t\tif (node.nodeType) {\n\t\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\t\trng.setEndAfter(node);\n\t\t\t\t\t\tapplyRngStyle(expandRng(rng, formatList), null, true);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tapplyRngStyle(node, null, true);\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tif (!isCollapsed || !format.inline || dom.select('td.mceSelected,th.mceSelected').length) {\n\t\t\t\t\t\t// Obtain selection node before selection is unselected by applyRngStyle()\n\t\t\t\t\t\tvar curSelNode = ed.selection.getNode();\n\n\t\t\t\t\t\t// Apply formatting to selection\n\t\t\t\t\t\ted.selection.setRng(adjustSelectionToVisibleSelection());\n\t\t\t\t\t\tbookmark = selection.getBookmark();\n\t\t\t\t\t\tapplyRngStyle(expandRng(selection.getRng(TRUE), formatList), bookmark);\n\n\t\t\t\t\t\t// Colored nodes should be underlined so that the color of the underline matches the text color.\n\t\t\t\t\t\tif (format.styles && (format.styles.color || format.styles.textDecoration)) {\n\t\t\t\t\t\t\ttinymce.walk(curSelNode, processUnderlineAndColor, 'childNodes');\n\t\t\t\t\t\t\tprocessUnderlineAndColor(curSelNode);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t\t\t\tselection.setRng(moveStart(selection.getRng(TRUE)));\n\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t} else\n\t\t\t\t\t\tperformCaretAction('apply', name, vars);\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction remove(name, vars, node) {\n\t\t\tvar formatList = get(name), format = formatList[0], bookmark, i, rng;\n\t\t\tfunction moveStart(rng) {\n\t\t\t\tvar container = rng.startContainer,\n\t\t\t\t\toffset = rng.startOffset,\n\t\t\t\t\twalker, node, nodes, tmpNode;\n\n\t\t\t\t// Convert text node into index if possible\n\t\t\t\tif (container.nodeType == 3 && offset >= container.nodeValue.length - 1) {\n\t\t\t\t\tcontainer = container.parentNode;\n\t\t\t\t\toffset = nodeIndex(container) + 1;\n\t\t\t\t}\n\n\t\t\t\t// Move startContainer/startOffset in to a suitable node\n\t\t\t\tif (container.nodeType == 1) {\n\t\t\t\t\tnodes = container.childNodes;\n\t\t\t\t\tcontainer = nodes[Math.min(offset, nodes.length - 1)];\n\t\t\t\t\twalker = new TreeWalker(container);\n\n\t\t\t\t\t// If offset is at end of the parent node walk to the next one\n\t\t\t\t\tif (offset > nodes.length - 1)\n\t\t\t\t\t\twalker.next();\n\n\t\t\t\t\tfor (node = walker.current(); node; node = walker.next()) {\n\t\t\t\t\t\tif (node.nodeType == 3 && !isWhiteSpaceNode(node)) {\n\t\t\t\t\t\t\t// IE has a \"neat\" feature where it moves the start node into the closest element\n\t\t\t\t\t\t\t// we can avoid this by inserting an element before it and then remove it after we set the selection\n\t\t\t\t\t\t\ttmpNode = dom.create('a', null, INVISIBLE_CHAR);\n\t\t\t\t\t\t\tnode.parentNode.insertBefore(tmpNode, node);\n\n\t\t\t\t\t\t\t// Set selection and remove tmpNode\n\t\t\t\t\t\t\trng.setStart(node, 0);\n\t\t\t\t\t\t\tselection.setRng(rng);\n\t\t\t\t\t\t\tdom.remove(tmpNode);\n\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Merges the styles for each node\n\t\t\tfunction process(node) {\n\t\t\t\tvar children, i, l;\n\n\t\t\t\t// Grab the children first since the nodelist might be changed\n\t\t\t\tchildren = tinymce.grep(node.childNodes);\n\n\t\t\t\t// Process current node\n\t\t\t\tfor (i = 0, l = formatList.length; i < l; i++) {\n\t\t\t\t\tif (removeFormat(formatList[i], vars, node, node))\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\t// Process the children\n\t\t\t\tif (format.deep) {\n\t\t\t\t\tfor (i = 0, l = children.length; i < l; i++)\n\t\t\t\t\t\tprocess(children[i]);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tfunction findFormatRoot(container) {\n\t\t\t\tvar formatRoot;\n\n\t\t\t\t// Find format root\n\t\t\t\teach(getParents(container.parentNode).reverse(), function(parent) {\n\t\t\t\t\tvar format;\n\n\t\t\t\t\t// Find format root element\n\t\t\t\t\tif (!formatRoot && parent.id != '_start' && parent.id != '_end') {\n\t\t\t\t\t\t// Is the node matching the format we are looking for\n\t\t\t\t\t\tformat = matchNode(parent, name, vars);\n\t\t\t\t\t\tif (format && format.split !== false)\n\t\t\t\t\t\t\tformatRoot = parent;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\treturn formatRoot;\n\t\t\t};\n\n\t\t\tfunction wrapAndSplit(format_root, container, target, split) {\n\t\t\t\tvar parent, clone, lastClone, firstClone, i, formatRootParent;\n\n\t\t\t\t// Format root found then clone formats and split it\n\t\t\t\tif (format_root) {\n\t\t\t\t\tformatRootParent = format_root.parentNode;\n\n\t\t\t\t\tfor (parent = container.parentNode; parent && parent != formatRootParent; parent = parent.parentNode) {\n\t\t\t\t\t\tclone = parent.cloneNode(FALSE);\n\n\t\t\t\t\t\tfor (i = 0; i < formatList.length; i++) {\n\t\t\t\t\t\t\tif (removeFormat(formatList[i], vars, clone, clone)) {\n\t\t\t\t\t\t\t\tclone = 0;\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Build wrapper node\n\t\t\t\t\t\tif (clone) {\n\t\t\t\t\t\t\tif (lastClone)\n\t\t\t\t\t\t\t\tclone.appendChild(lastClone);\n\n\t\t\t\t\t\t\tif (!firstClone)\n\t\t\t\t\t\t\t\tfirstClone = clone;\n\n\t\t\t\t\t\t\tlastClone = clone;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Never split block elements if the format is mixed\n\t\t\t\t\tif (split && (!format.mixed || !isBlock(format_root)))\n\t\t\t\t\t\tcontainer = dom.split(format_root, container);\n\n\t\t\t\t\t// Wrap container in cloned formats\n\t\t\t\t\tif (lastClone) {\n\t\t\t\t\t\ttarget.parentNode.insertBefore(lastClone, target);\n\t\t\t\t\t\tfirstClone.appendChild(target);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn container;\n\t\t\t};\n\n\t\t\tfunction splitToFormatRoot(container) {\n\t\t\t\treturn wrapAndSplit(findFormatRoot(container), container, container, true);\n\t\t\t};\n\n\t\t\tfunction unwrap(start) {\n\t\t\t\tvar node = dom.get(start ? '_start' : '_end'),\n\t\t\t\t\tout = node[start ? 'firstChild' : 'lastChild'];\n\n\t\t\t\t// If the end is placed within the start the result will be removed\n\t\t\t\t// So this checks if the out node is a bookmark node if it is it\n\t\t\t\t// checks for another more suitable node\n\t\t\t\tif (isBookmarkNode(out))\n\t\t\t\t\tout = out[start ? 'firstChild' : 'lastChild'];\n\n\t\t\t\tdom.remove(node, true);\n\n\t\t\t\treturn out;\n\t\t\t};\n\n\t\t\tfunction removeRngStyle(rng) {\n\t\t\t\tvar startContainer, endContainer;\n\n\t\t\t\trng = expandRng(rng, formatList, TRUE);\n\n\t\t\t\tif (format.split) {\n\t\t\t\t\tstartContainer = getContainer(rng, TRUE);\n\t\t\t\t\tendContainer = getContainer(rng);\n\n\t\t\t\t\tif (startContainer != endContainer) {\n\t\t\t\t\t\t// Wrap start/end nodes in span element since these might be cloned/moved\n\t\t\t\t\t\tstartContainer = wrap(startContainer, 'span', {id : '_start', 'data-mce-type' : 'bookmark'});\n\t\t\t\t\t\tendContainer = wrap(endContainer, 'span', {id : '_end', 'data-mce-type' : 'bookmark'});\n\n\t\t\t\t\t\t// Split start/end\n\t\t\t\t\t\tsplitToFormatRoot(startContainer);\n\t\t\t\t\t\tsplitToFormatRoot(endContainer);\n\n\t\t\t\t\t\t// Unwrap start/end to get real elements again\n\t\t\t\t\t\tstartContainer = unwrap(TRUE);\n\t\t\t\t\t\tendContainer = unwrap();\n\t\t\t\t\t} else\n\t\t\t\t\t\tstartContainer = endContainer = splitToFormatRoot(startContainer);\n\n\t\t\t\t\t// Update range positions since they might have changed after the split operations\n\t\t\t\t\trng.startContainer = startContainer.parentNode;\n\t\t\t\t\trng.startOffset = nodeIndex(startContainer);\n\t\t\t\t\trng.endContainer = endContainer.parentNode;\n\t\t\t\t\trng.endOffset = nodeIndex(endContainer) + 1;\n\t\t\t\t}\n\n\t\t\t\t// Remove items between start/end\n\t\t\t\trangeUtils.walk(rng, function(nodes) {\n\t\t\t\t\teach(nodes, function(node) {\n\t\t\t\t\t\tprocess(node);\n\n\t\t\t\t\t\t// Remove parent span if it only contains text-decoration: underline, yet a parent node is also underlined.\n\t\t\t\t\t\tif (node.nodeType === 1 && ed.dom.getStyle(node, 'text-decoration') === 'underline' && node.parentNode && getTextDecoration(node.parentNode) === 'underline') {\n\t\t\t\t\t\t\tremoveFormat({'deep': false, 'exact': true, 'inline': 'span', 'styles': {'textDecoration' : 'underline'}}, null, node);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t};\n\n\t\t\t// Handle node\n\t\t\tif (node) {\n\t\t\t\tif (node.nodeType) {\n\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\trng.setEndAfter(node);\n\t\t\t\t\tremoveRngStyle(rng);\n\t\t\t\t} else {\n\t\t\t\t\tremoveRngStyle(node);\n\t\t\t\t}\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif (!selection.isCollapsed() || !format.inline || dom.select('td.mceSelected,th.mceSelected').length) {\n\t\t\t\tbookmark = selection.getBookmark();\n\t\t\t\tremoveRngStyle(selection.getRng(TRUE));\n\t\t\t\tselection.moveToBookmark(bookmark);\n\n\t\t\t\t// Check if start element still has formatting then we are at: \"<b>text|</b>text\" and need to move the start into the next text node\n\t\t\t\tif (format.inline && match(name, vars, selection.getStart())) {\n\t\t\t\t\tmoveStart(selection.getRng(true));\n\t\t\t\t}\n\n\t\t\t\ted.nodeChanged();\n\t\t\t} else\n\t\t\t\tperformCaretAction('remove', name, vars);\n\n\t\t\t// When you remove formatting from a table cell in WebKit (cell, not the contents of a cell) there is a rendering issue with column width\n\t\t\tif (tinymce.isWebKit) {\n\t\t\t\ted.execCommand('mceCleanup');\n\t\t\t}\n\t\t};\n\n\t\tfunction toggle(name, vars, node) {\n\t\t\tvar fmt = get(name);\n\n\t\t\tif (match(name, vars, node) && (!('toggle' in fmt[0]) || fmt[0]['toggle']))\n\t\t\t\tremove(name, vars, node);\n\t\t\telse\n\t\t\t\tapply(name, vars, node);\n\t\t};\n\n\t\tfunction matchNode(node, name, vars, similar) {\n\t\t\tvar formatList = get(name), format, i, classes;\n\n\t\t\tfunction matchItems(node, format, item_name) {\n\t\t\t\tvar key, value, items = format[item_name], i;\n\n\t\t\t\t// Custom match\n\t\t\t\tif (format.onmatch) {\n\t\t\t\t\treturn format.onmatch(node, format, item_name);\n\t\t\t\t}\n\n\t\t\t\t// Check all items\n\t\t\t\tif (items) {\n\t\t\t\t\t// Non indexed object\n\t\t\t\t\tif (items.length === undefined) {\n\t\t\t\t\t\tfor (key in items) {\n\t\t\t\t\t\t\tif (items.hasOwnProperty(key)) {\n\t\t\t\t\t\t\t\tif (item_name === 'attributes')\n\t\t\t\t\t\t\t\t\tvalue = dom.getAttrib(node, key);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\tvalue = getStyle(node, key);\n\n\t\t\t\t\t\t\t\tif (similar && !value && !format.exact)\n\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\tif ((!similar || format.exact) && !isEq(value, replaceVars(items[key], vars)))\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Only one match needed for indexed arrays\n\t\t\t\t\t\tfor (i = 0; i < items.length; i++) {\n\t\t\t\t\t\t\tif (item_name === 'attributes' ? dom.getAttrib(node, items[i]) : getStyle(node, items[i]))\n\t\t\t\t\t\t\t\treturn format;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn format;\n\t\t\t};\n\n\t\t\tif (formatList && node) {\n\t\t\t\t// Check each format in list\n\t\t\t\tfor (i = 0; i < formatList.length; i++) {\n\t\t\t\t\tformat = formatList[i];\n\n\t\t\t\t\t// Name name, attributes, styles and classes\n\t\t\t\t\tif (matchName(node, format) && matchItems(node, format, 'attributes') && matchItems(node, format, 'styles')) {\n\t\t\t\t\t\t// Match classes\n\t\t\t\t\t\tif (classes = format.classes) {\n\t\t\t\t\t\t\tfor (i = 0; i < classes.length; i++) {\n\t\t\t\t\t\t\t\tif (!dom.hasClass(node, classes[i]))\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn format;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction match(name, vars, node) {\n\t\t\tvar startNode;\n\n\t\t\tfunction matchParents(node) {\n\t\t\t\t// Find first node with similar format settings\n\t\t\t\tnode = dom.getParent(node, function(node) {\n\t\t\t\t\treturn !!matchNode(node, name, vars, true);\n\t\t\t\t});\n\n\t\t\t\t// Do an exact check on the similar format element\n\t\t\t\treturn matchNode(node, name, vars);\n\t\t\t};\n\n\t\t\t// Check specified node\n\t\t\tif (node)\n\t\t\t\treturn matchParents(node);\n\n\t\t\t// Check selected node\n\t\t\tnode = selection.getNode();\n\t\t\tif (matchParents(node))\n\t\t\t\treturn TRUE;\n\n\t\t\t// Check start node if it's different\n\t\t\tstartNode = selection.getStart();\n\t\t\tif (startNode != node) {\n\t\t\t\tif (matchParents(startNode))\n\t\t\t\t\treturn TRUE;\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\tfunction matchAll(names, vars) {\n\t\t\tvar startElement, matchedFormatNames = [], checkedMap = {}, i, ni, name;\n\n\t\t\t// Check start of selection for formats\n\t\t\tstartElement = selection.getStart();\n\t\t\tdom.getParent(startElement, function(node) {\n\t\t\t\tvar i, name;\n\n\t\t\t\tfor (i = 0; i < names.length; i++) {\n\t\t\t\t\tname = names[i];\n\n\t\t\t\t\tif (!checkedMap[name] && matchNode(node, name, vars)) {\n\t\t\t\t\t\tcheckedMap[name] = true;\n\t\t\t\t\t\tmatchedFormatNames.push(name);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn matchedFormatNames;\n\t\t};\n\n\t\tfunction canApply(name) {\n\t\t\tvar formatList = get(name), startNode, parents, i, x, selector;\n\n\t\t\tif (formatList) {\n\t\t\t\tstartNode = selection.getStart();\n\t\t\t\tparents = getParents(startNode);\n\n\t\t\t\tfor (x = formatList.length - 1; x >= 0; x--) {\n\t\t\t\t\tselector = formatList[x].selector;\n\n\t\t\t\t\t// Format is not selector based, then always return TRUE\n\t\t\t\t\tif (!selector)\n\t\t\t\t\t\treturn TRUE;\n\n\t\t\t\t\tfor (i = parents.length - 1; i >= 0; i--) {\n\t\t\t\t\t\tif (dom.is(parents[i], selector))\n\t\t\t\t\t\t\treturn TRUE;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\t// Expose to public\n\t\ttinymce.extend(this, {\n\t\t\tget : get,\n\t\t\tregister : register,\n\t\t\tapply : apply,\n\t\t\tremove : remove,\n\t\t\ttoggle : toggle,\n\t\t\tmatch : match,\n\t\t\tmatchAll : matchAll,\n\t\t\tmatchNode : matchNode,\n\t\t\tcanApply : canApply\n\t\t});\n\n\t\t// Private functions\n\n\t\tfunction matchName(node, format) {\n\t\t\t// Check for inline match\n\t\t\tif (isEq(node, format.inline))\n\t\t\t\treturn TRUE;\n\n\t\t\t// Check for block match\n\t\t\tif (isEq(node, format.block))\n\t\t\t\treturn TRUE;\n\n\t\t\t// Check for selector match\n\t\t\tif (format.selector)\n\t\t\t\treturn dom.is(node, format.selector);\n\t\t};\n\n\t\tfunction isEq(str1, str2) {\n\t\t\tstr1 = str1 || '';\n\t\t\tstr2 = str2 || '';\n\n\t\t\tstr1 = '' + (str1.nodeName || str1);\n\t\t\tstr2 = '' + (str2.nodeName || str2);\n\n\t\t\treturn str1.toLowerCase() == str2.toLowerCase();\n\t\t};\n\n\t\tfunction getStyle(node, name) {\n\t\t\tvar styleVal = dom.getStyle(node, name);\n\n\t\t\t// Force the format to hex\n\t\t\tif (name == 'color' || name == 'backgroundColor')\n\t\t\t\tstyleVal = dom.toHex(styleVal);\n\n\t\t\t// Opera will return bold as 700\n\t\t\tif (name == 'fontWeight' && styleVal == 700)\n\t\t\t\tstyleVal = 'bold';\n\n\t\t\treturn '' + styleVal;\n\t\t};\n\n\t\tfunction replaceVars(value, vars) {\n\t\t\tif (typeof(value) != \"string\")\n\t\t\t\tvalue = value(vars);\n\t\t\telse if (vars) {\n\t\t\t\tvalue = value.replace(/%(\\w+)/g, function(str, name) {\n\t\t\t\t\treturn vars[name] || str;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn value;\n\t\t};\n\n\t\tfunction isWhiteSpaceNode(node) {\n\t\t\treturn node && node.nodeType === 3 && /^([\\t \\r\\n]+|)$/.test(node.nodeValue);\n\t\t};\n\n\t\tfunction wrap(node, name, attrs) {\n\t\t\tvar wrapper = dom.create(name, attrs);\n\n\t\t\tnode.parentNode.insertBefore(wrapper, node);\n\t\t\twrapper.appendChild(node);\n\n\t\t\treturn wrapper;\n\t\t};\n\n\t\tfunction expandRng(rng, format, remove) {\n\t\t\tvar startContainer = rng.startContainer,\n\t\t\t\tstartOffset = rng.startOffset,\n\t\t\t\tendContainer = rng.endContainer,\n\t\t\t\tendOffset = rng.endOffset, sibling, lastIdx, leaf, endPoint;\n\n\t\t\t// This function walks up the tree if there is no siblings before/after the node\n\t\t\tfunction findParentContainer(start) {\n\t\t\t\tvar container, parent, child, sibling, siblingName;\n\n\t\t\t\tcontainer = parent = start ? startContainer : endContainer;\n\t\t\t\tsiblingName = start ? 'previousSibling' : 'nextSibling';\n\t\t\t\troot = dom.getRoot();\n\n\t\t\t\t// If it's a text node and the offset is inside the text\n\t\t\t\tif (container.nodeType == 3 && !isWhiteSpaceNode(container)) {\n\t\t\t\t\tif (start ? startOffset > 0 : endOffset < container.nodeValue.length) {\n\t\t\t\t\t\treturn container;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor (;;) {\n\t\t\t\t\t// Stop expanding on block elements or root depending on format\n\t\t\t\t\tif (parent == root || (!format[0].block_expand && isBlock(parent)))\n\t\t\t\t\t\treturn parent;\n\n\t\t\t\t\t// Walk left/right\n\t\t\t\t\tfor (sibling = parent[siblingName]; sibling; sibling = sibling[siblingName]) {\n\t\t\t\t\t\tif (!isBookmarkNode(sibling) && !isWhiteSpaceNode(sibling)) {\n\t\t\t\t\t\t\treturn parent;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Check if we can move up are we at root level or body level\n\t\t\t\t\tparent = parent.parentNode;\n\t\t\t\t}\n\n\t\t\t\treturn container;\n\t\t\t};\n\n\t\t\t// This function walks down the tree to find the leaf at the selection.\n\t\t\t// The offset is also returned as if node initially a leaf, the offset may be in the middle of the text node.\n\t\t\tfunction findLeaf(node, offset) {\n\t\t\t\tif (offset === undefined)\n\t\t\t\t\toffset = node.nodeType === 3 ? node.length : node.childNodes.length;\n\t\t\t\twhile (node && node.hasChildNodes()) {\n\t\t\t\t\tnode = node.childNodes[offset];\n\t\t\t\t\tif (node)\n\t\t\t\t\t\toffset = node.nodeType === 3 ? node.length : node.childNodes.length;\n\t\t\t\t}\n\t\t\t\treturn { node: node, offset: offset };\n\t\t\t}\n\n\t\t\t// If index based start position then resolve it\n\t\t\tif (startContainer.nodeType == 1 && startContainer.hasChildNodes()) {\n\t\t\t\tlastIdx = startContainer.childNodes.length - 1;\n\t\t\t\tstartContainer = startContainer.childNodes[startOffset > lastIdx ? lastIdx : startOffset];\n\n\t\t\t\tif (startContainer.nodeType == 3)\n\t\t\t\t\tstartOffset = 0;\n\t\t\t}\n\n\t\t\t// If index based end position then resolve it\n\t\t\tif (endContainer.nodeType == 1 && endContainer.hasChildNodes()) {\n\t\t\t\tlastIdx = endContainer.childNodes.length - 1;\n\t\t\t\tendContainer = endContainer.childNodes[endOffset > lastIdx ? lastIdx : endOffset - 1];\n\n\t\t\t\tif (endContainer.nodeType == 3)\n\t\t\t\t\tendOffset = endContainer.nodeValue.length;\n\t\t\t}\n\n\t\t\t// Exclude bookmark nodes if possible\n\t\t\tif (isBookmarkNode(startContainer.parentNode) || isBookmarkNode(startContainer)) {\n\t\t\t\tstartContainer = isBookmarkNode(startContainer) ? startContainer : startContainer.parentNode;\n\t\t\t\tstartContainer = startContainer.nextSibling || startContainer;\n\n\t\t\t\tif (startContainer.nodeType == 3)\n\t\t\t\t\tstartOffset = 0;\n\t\t\t}\n\n\t\t\tif (isBookmarkNode(endContainer.parentNode) || isBookmarkNode(endContainer)) {\n\t\t\t\tendContainer = isBookmarkNode(endContainer) ? endContainer : endContainer.parentNode;\n\t\t\t\tendContainer = endContainer.previousSibling || endContainer;\n\n\t\t\t\tif (endContainer.nodeType == 3)\n\t\t\t\t\tendOffset = endContainer.length;\n\t\t\t}\n\n\t\t\tif (format[0].inline) {\n\t\t\t\tif (rng.collapsed) {\n\t\t\t\t\tfunction findWordEndPoint(container, offset, start) {\n\t\t\t\t\t\tvar walker, node, pos, lastTextNode;\n\n\t\t\t\t\t\tfunction findSpace(node, offset) {\n\t\t\t\t\t\t\tvar pos, pos2, str = node.nodeValue;\n\n\t\t\t\t\t\t\tif (typeof(offset) == \"undefined\") {\n\t\t\t\t\t\t\t\toffset = start ? str.length : 0;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (start) {\n\t\t\t\t\t\t\t\tpos = str.lastIndexOf(' ', offset);\n\t\t\t\t\t\t\t\tpos2 = str.lastIndexOf('\\u00a0', offset);\n\t\t\t\t\t\t\t\tpos = pos > pos2 ? pos : pos2;\n\n\t\t\t\t\t\t\t\t// Include the space on remove to avoid tag soup\n\t\t\t\t\t\t\t\tif (pos !== -1 && !remove) {\n\t\t\t\t\t\t\t\t\tpos++;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tpos = str.indexOf(' ', offset);\n\t\t\t\t\t\t\t\tpos2 = str.indexOf('\\u00a0', offset);\n\t\t\t\t\t\t\t\tpos = pos !== -1 && (pos2 === -1 || pos < pos2) ? pos : pos2;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn pos;\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tif (container.nodeType === 3) {\n\t\t\t\t\t\t\tpos = findSpace(container, offset);\n\n\t\t\t\t\t\t\tif (pos !== -1) {\n\t\t\t\t\t\t\t\treturn {container : container, offset : pos};\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tlastTextNode = container;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Walk the nodes inside the block\n\t\t\t\t\t\twalker = new TreeWalker(container, dom.getParent(container, isBlock) || ed.getBody());\n\t\t\t\t\t\twhile (node = walker[start ? 'prev' : 'next']()) {\n\t\t\t\t\t\t\tif (node.nodeType === 3) {\n\t\t\t\t\t\t\t\tlastTextNode = node;\n\t\t\t\t\t\t\t\tpos = findSpace(node);\n\n\t\t\t\t\t\t\t\tif (pos !== -1) {\n\t\t\t\t\t\t\t\t\treturn {container : node, offset : pos};\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else if (isBlock(node)) {\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (lastTextNode) {\n\t\t\t\t\t\t\tif (start) {\n\t\t\t\t\t\t\t\toffset = 0;\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\toffset = lastTextNode.length;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn {container: lastTextNode, offset: offset};\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Expand left to closest word boundery\n\t\t\t\t\tendPoint = findWordEndPoint(startContainer, startOffset, true);\n\t\t\t\t\tif (endPoint) {\n\t\t\t\t\t\tstartContainer = endPoint.container;\n\t\t\t\t\t\tstartOffset = endPoint.offset;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Expand right to closest word boundery\n\t\t\t\t\tendPoint = findWordEndPoint(endContainer, endOffset);\n\t\t\t\t\tif (endPoint) {\n\t\t\t\t\t\tendContainer = endPoint.container;\n\t\t\t\t\t\tendOffset = endPoint.offset;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Avoid applying formatting to a trailing space.\n\t\t\t\tleaf = findLeaf(endContainer, endOffset);\n\t\t\t\tif (leaf.node) {\n\t\t\t\t\twhile (leaf.node && leaf.offset === 0 && leaf.node.previousSibling)\n\t\t\t\t\t\tleaf = findLeaf(leaf.node.previousSibling);\n\n\t\t\t\t\tif (leaf.node && leaf.offset > 0 && leaf.node.nodeType === 3 &&\n\t\t\t\t\t\t\tleaf.node.nodeValue.charAt(leaf.offset - 1) === ' ') {\n\n\t\t\t\t\t\tif (leaf.offset > 1) {\n\t\t\t\t\t\t\tendContainer = leaf.node;\n\t\t\t\t\t\t\tendContainer.splitText(leaf.offset - 1);\n\t\t\t\t\t\t} else if (leaf.node.previousSibling) {\n\t\t\t\t\t\t\t// TODO: Figure out why this is in here\n\t\t\t\t\t\t\t//endContainer = leaf.node.previousSibling;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Move start/end point up the tree if the leaves are sharp and if we are in different containers\n\t\t\t// Example * becomes !: !<p><b><i>*text</i><i>text*</i></b></p>!\n\t\t\t// This will reduce the number of wrapper elements that needs to be created\n\t\t\t// Move start point up the tree\n\t\t\tif (format[0].inline || format[0].block_expand) {\n\t\t\t\tif (!format[0].inline || (startContainer.nodeType != 3 || startOffset === 0)) {\n\t\t\t\t\tstartContainer = findParentContainer(true);\n\t\t\t\t}\n\n\t\t\t\tif (!format[0].inline || (endContainer.nodeType != 3 || endOffset === endContainer.nodeValue.length)) {\n\t\t\t\t\tendContainer = findParentContainer();\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Expand start/end container to matching selector\n\t\t\tif (format[0].selector && format[0].expand !== FALSE && !format[0].inline) {\n\t\t\t\tfunction findSelectorEndPoint(container, sibling_name) {\n\t\t\t\t\tvar parents, i, y, curFormat;\n\n\t\t\t\t\tif (container.nodeType == 3 && container.nodeValue.length == 0 && container[sibling_name])\n\t\t\t\t\t\tcontainer = container[sibling_name];\n\n\t\t\t\t\tparents = getParents(container);\n\t\t\t\t\tfor (i = 0; i < parents.length; i++) {\n\t\t\t\t\t\tfor (y = 0; y < format.length; y++) {\n\t\t\t\t\t\t\tcurFormat = format[y];\n\n\t\t\t\t\t\t\t// If collapsed state is set then skip formats that doesn't match that\n\t\t\t\t\t\t\tif (\"collapsed\" in curFormat && curFormat.collapsed !== rng.collapsed)\n\t\t\t\t\t\t\t\tcontinue;\n\n\t\t\t\t\t\t\tif (dom.is(parents[i], curFormat.selector))\n\t\t\t\t\t\t\t\treturn parents[i];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn container;\n\t\t\t\t};\n\n\t\t\t\t// Find new startContainer/endContainer if there is better one\n\t\t\t\tstartContainer = findSelectorEndPoint(startContainer, 'previousSibling');\n\t\t\t\tendContainer = findSelectorEndPoint(endContainer, 'nextSibling');\n\t\t\t}\n\n\t\t\t// Expand start/end container to matching block element or text node\n\t\t\tif (format[0].block || format[0].selector) {\n\t\t\t\tfunction findBlockEndPoint(container, sibling_name, sibling_name2) {\n\t\t\t\t\tvar node;\n\n\t\t\t\t\t// Expand to block of similar type\n\t\t\t\t\tif (!format[0].wrapper)\n\t\t\t\t\t\tnode = dom.getParent(container, format[0].block);\n\n\t\t\t\t\t// Expand to first wrappable block element or any block element\n\t\t\t\t\tif (!node)\n\t\t\t\t\t\tnode = dom.getParent(container.nodeType == 3 ? container.parentNode : container, isBlock);\n\n\t\t\t\t\t// Exclude inner lists from wrapping\n\t\t\t\t\tif (node && format[0].wrapper)\n\t\t\t\t\t\tnode = getParents(node, 'ul,ol').reverse()[0] || node;\n\n\t\t\t\t\t// Didn't find a block element look for first/last wrappable element\n\t\t\t\t\tif (!node) {\n\t\t\t\t\t\tnode = container;\n\n\t\t\t\t\t\twhile (node[sibling_name] && !isBlock(node[sibling_name])) {\n\t\t\t\t\t\t\tnode = node[sibling_name];\n\n\t\t\t\t\t\t\t// Break on BR but include it will be removed later on\n\t\t\t\t\t\t\t// we can't remove it now since we need to check if it can be wrapped\n\t\t\t\t\t\t\tif (isEq(node, 'br'))\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn node || container;\n\t\t\t\t};\n\n\t\t\t\t// Find new startContainer/endContainer if there is better one\n\t\t\t\tstartContainer = findBlockEndPoint(startContainer, 'previousSibling');\n\t\t\t\tendContainer = findBlockEndPoint(endContainer, 'nextSibling');\n\n\t\t\t\t// Non block element then try to expand up the leaf\n\t\t\t\tif (format[0].block) {\n\t\t\t\t\tif (!isBlock(startContainer))\n\t\t\t\t\t\tstartContainer = findParentContainer(true);\n\n\t\t\t\t\tif (!isBlock(endContainer))\n\t\t\t\t\t\tendContainer = findParentContainer();\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Setup index for startContainer\n\t\t\tif (startContainer.nodeType == 1) {\n\t\t\t\tstartOffset = nodeIndex(startContainer);\n\t\t\t\tstartContainer = startContainer.parentNode;\n\t\t\t}\n\n\t\t\t// Setup index for endContainer\n\t\t\tif (endContainer.nodeType == 1) {\n\t\t\t\tendOffset = nodeIndex(endContainer) + 1;\n\t\t\t\tendContainer = endContainer.parentNode;\n\t\t\t}\n\n\t\t\t// Return new range like object\n\t\t\treturn {\n\t\t\t\tstartContainer : startContainer,\n\t\t\t\tstartOffset : startOffset,\n\t\t\t\tendContainer : endContainer,\n\t\t\t\tendOffset : endOffset\n\t\t\t};\n\t\t}\n\n\t\tfunction removeFormat(format, vars, node, compare_node) {\n\t\t\tvar i, attrs, stylesModified;\n\n\t\t\t// Check if node matches format\n\t\t\tif (!matchName(node, format))\n\t\t\t\treturn FALSE;\n\n\t\t\t// Should we compare with format attribs and styles\n\t\t\tif (format.remove != 'all') {\n\t\t\t\t// Remove styles\n\t\t\t\teach(format.styles, function(value, name) {\n\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\t// Indexed array\n\t\t\t\t\tif (typeof(name) === 'number') {\n\t\t\t\t\t\tname = value;\n\t\t\t\t\t\tcompare_node = 0;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!compare_node || isEq(getStyle(compare_node, name), value))\n\t\t\t\t\t\tdom.setStyle(node, name, '');\n\n\t\t\t\t\tstylesModified = 1;\n\t\t\t\t});\n\n\t\t\t\t// Remove style attribute if it's empty\n\t\t\t\tif (stylesModified && dom.getAttrib(node, 'style') == '') {\n\t\t\t\t\tnode.removeAttribute('style');\n\t\t\t\t\tnode.removeAttribute('data-mce-style');\n\t\t\t\t}\n\n\t\t\t\t// Remove attributes\n\t\t\t\teach(format.attributes, function(value, name) {\n\t\t\t\t\tvar valueOut;\n\n\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\t// Indexed array\n\t\t\t\t\tif (typeof(name) === 'number') {\n\t\t\t\t\t\tname = value;\n\t\t\t\t\t\tcompare_node = 0;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!compare_node || isEq(dom.getAttrib(compare_node, name), value)) {\n\t\t\t\t\t\t// Keep internal classes\n\t\t\t\t\t\tif (name == 'class') {\n\t\t\t\t\t\t\tvalue = dom.getAttrib(node, name);\n\t\t\t\t\t\t\tif (value) {\n\t\t\t\t\t\t\t\t// Build new class value where everything is removed except the internal prefixed classes\n\t\t\t\t\t\t\t\tvalueOut = '';\n\t\t\t\t\t\t\t\teach(value.split(/\\s+/), function(cls) {\n\t\t\t\t\t\t\t\t\tif (/mce\\w+/.test(cls))\n\t\t\t\t\t\t\t\t\t\tvalueOut += (valueOut ? ' ' : '') + cls;\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\t// We got some internal classes left\n\t\t\t\t\t\t\t\tif (valueOut) {\n\t\t\t\t\t\t\t\t\tdom.setAttrib(node, name, valueOut);\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// IE6 has a bug where the attribute doesn't get removed correctly\n\t\t\t\t\t\tif (name == \"class\")\n\t\t\t\t\t\t\tnode.removeAttribute('className');\n\n\t\t\t\t\t\t// Remove mce prefixed attributes\n\t\t\t\t\t\tif (MCE_ATTR_RE.test(name))\n\t\t\t\t\t\t\tnode.removeAttribute('data-mce-' + name);\n\n\t\t\t\t\t\tnode.removeAttribute(name);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// Remove classes\n\t\t\t\teach(format.classes, function(value) {\n\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\tif (!compare_node || dom.hasClass(compare_node, value))\n\t\t\t\t\t\tdom.removeClass(node, value);\n\t\t\t\t});\n\n\t\t\t\t// Check for non internal attributes\n\t\t\t\tattrs = dom.getAttribs(node);\n\t\t\t\tfor (i = 0; i < attrs.length; i++) {\n\t\t\t\t\tif (attrs[i].nodeName.indexOf('_') !== 0)\n\t\t\t\t\t\treturn FALSE;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Remove the inline child if it's empty for example <b> or <span>\n\t\t\tif (format.remove != 'none') {\n\t\t\t\tremoveNode(node, format);\n\t\t\t\treturn TRUE;\n\t\t\t}\n\t\t};\n\n\t\tfunction removeNode(node, format) {\n\t\t\tvar parentNode = node.parentNode, rootBlockElm;\n\n\t\t\tif (format.block) {\n\t\t\t\tif (!forcedRootBlock) {\n\t\t\t\t\tfunction find(node, next, inc) {\n\t\t\t\t\t\tnode = getNonWhiteSpaceSibling(node, next, inc);\n\n\t\t\t\t\t\treturn !node || (node.nodeName == 'BR' || isBlock(node));\n\t\t\t\t\t};\n\n\t\t\t\t\t// Append BR elements if needed before we remove the block\n\t\t\t\t\tif (isBlock(node) && !isBlock(parentNode)) {\n\t\t\t\t\t\tif (!find(node, FALSE) && !find(node.firstChild, TRUE, 1))\n\t\t\t\t\t\t\tnode.insertBefore(dom.create('br'), node.firstChild);\n\n\t\t\t\t\t\tif (!find(node, TRUE) && !find(node.lastChild, FALSE, 1))\n\t\t\t\t\t\t\tnode.appendChild(dom.create('br'));\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\t// Wrap the block in a forcedRootBlock if we are at the root of document\n\t\t\t\t\tif (parentNode == dom.getRoot()) {\n\t\t\t\t\t\tif (!format.list_block || !isEq(node, format.list_block)) {\n\t\t\t\t\t\t\teach(tinymce.grep(node.childNodes), function(node) {\n\t\t\t\t\t\t\t\tif (isValid(forcedRootBlock, node.nodeName.toLowerCase())) {\n\t\t\t\t\t\t\t\t\tif (!rootBlockElm)\n\t\t\t\t\t\t\t\t\t\trootBlockElm = wrap(node, forcedRootBlock);\n\t\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\t\trootBlockElm.appendChild(node);\n\t\t\t\t\t\t\t\t} else\n\t\t\t\t\t\t\t\t\trootBlockElm = 0;\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Never remove nodes that isn't the specified inline element if a selector is specified too\n\t\t\tif (format.selector && format.inline && !isEq(format.inline, node))\n\t\t\t\treturn;\n\n\t\t\tdom.remove(node, 1);\n\t\t};\n\n\t\tfunction getNonWhiteSpaceSibling(node, next, inc) {\n\t\t\tif (node) {\n\t\t\t\tnext = next ? 'nextSibling' : 'previousSibling';\n\n\t\t\t\tfor (node = inc ? node : node[next]; node; node = node[next]) {\n\t\t\t\t\tif (node.nodeType == 1 || !isWhiteSpaceNode(node))\n\t\t\t\t\t\treturn node;\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction isBookmarkNode(node) {\n\t\t\treturn node && node.nodeType == 1 && node.getAttribute('data-mce-type') == 'bookmark';\n\t\t};\n\n\t\tfunction mergeSiblings(prev, next) {\n\t\t\tvar marker, sibling, tmpSibling;\n\n\t\t\tfunction compareElements(node1, node2) {\n\t\t\t\t// Not the same name\n\t\t\t\tif (node1.nodeName != node2.nodeName)\n\t\t\t\t\treturn FALSE;\n\n\t\t\t\tfunction getAttribs(node) {\n\t\t\t\t\tvar attribs = {};\n\n\t\t\t\t\teach(dom.getAttribs(node), function(attr) {\n\t\t\t\t\t\tvar name = attr.nodeName.toLowerCase();\n\n\t\t\t\t\t\t// Don't compare internal attributes or style\n\t\t\t\t\t\tif (name.indexOf('_') !== 0 && name !== 'style')\n\t\t\t\t\t\t\tattribs[name] = dom.getAttrib(node, name);\n\t\t\t\t\t});\n\n\t\t\t\t\treturn attribs;\n\t\t\t\t};\n\n\t\t\t\tfunction compareObjects(obj1, obj2) {\n\t\t\t\t\tvar value, name;\n\n\t\t\t\t\tfor (name in obj1) {\n\t\t\t\t\t\t// Obj1 has item obj2 doesn't have\n\t\t\t\t\t\tif (obj1.hasOwnProperty(name)) {\n\t\t\t\t\t\t\tvalue = obj2[name];\n\n\t\t\t\t\t\t\t// Obj2 doesn't have obj1 item\n\t\t\t\t\t\t\tif (value === undefined)\n\t\t\t\t\t\t\t\treturn FALSE;\n\n\t\t\t\t\t\t\t// Obj2 item has a different value\n\t\t\t\t\t\t\tif (obj1[name] != value)\n\t\t\t\t\t\t\t\treturn FALSE;\n\n\t\t\t\t\t\t\t// Delete similar value\n\t\t\t\t\t\t\tdelete obj2[name];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Check if obj 2 has something obj 1 doesn't have\n\t\t\t\t\tfor (name in obj2) {\n\t\t\t\t\t\t// Obj2 has item obj1 doesn't have\n\t\t\t\t\t\tif (obj2.hasOwnProperty(name))\n\t\t\t\t\t\t\treturn FALSE;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn TRUE;\n\t\t\t\t};\n\n\t\t\t\t// Attribs are not the same\n\t\t\t\tif (!compareObjects(getAttribs(node1), getAttribs(node2)))\n\t\t\t\t\treturn FALSE;\n\n\t\t\t\t// Styles are not the same\n\t\t\t\tif (!compareObjects(dom.parseStyle(dom.getAttrib(node1, 'style')), dom.parseStyle(dom.getAttrib(node2, 'style'))))\n\t\t\t\t\treturn FALSE;\n\n\t\t\t\treturn TRUE;\n\t\t\t};\n\n\t\t\t// Check if next/prev exists and that they are elements\n\t\t\tif (prev && next) {\n\t\t\t\tfunction findElementSibling(node, sibling_name) {\n\t\t\t\t\tfor (sibling = node; sibling; sibling = sibling[sibling_name]) {\n\t\t\t\t\t\tif (sibling.nodeType == 3 && sibling.nodeValue.length !== 0)\n\t\t\t\t\t\t\treturn node;\n\n\t\t\t\t\t\tif (sibling.nodeType == 1 && !isBookmarkNode(sibling))\n\t\t\t\t\t\t\treturn sibling;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn node;\n\t\t\t\t};\n\n\t\t\t\t// If previous sibling is empty then jump over it\n\t\t\t\tprev = findElementSibling(prev, 'previousSibling');\n\t\t\t\tnext = findElementSibling(next, 'nextSibling');\n\n\t\t\t\t// Compare next and previous nodes\n\t\t\t\tif (compareElements(prev, next)) {\n\t\t\t\t\t// Append nodes between\n\t\t\t\t\tfor (sibling = prev.nextSibling; sibling && sibling != next;) {\n\t\t\t\t\t\ttmpSibling = sibling;\n\t\t\t\t\t\tsibling = sibling.nextSibling;\n\t\t\t\t\t\tprev.appendChild(tmpSibling);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove next node\n\t\t\t\t\tdom.remove(next);\n\n\t\t\t\t\t// Move children into prev node\n\t\t\t\t\teach(tinymce.grep(next.childNodes), function(node) {\n\t\t\t\t\t\tprev.appendChild(node);\n\t\t\t\t\t});\n\n\t\t\t\t\treturn prev;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn next;\n\t\t};\n\n\t\tfunction isTextBlock(name) {\n\t\t\treturn /^(h[1-6]|p|div|pre|address|dl|dt|dd)$/.test(name);\n\t\t};\n\n\t\tfunction getContainer(rng, start) {\n\t\t\tvar container, offset, lastIdx, walker;\n\n\t\t\tcontainer = rng[start ? 'startContainer' : 'endContainer'];\n\t\t\toffset = rng[start ? 'startOffset' : 'endOffset'];\n\n\t\t\tif (container.nodeType == 1) {\n\t\t\t\tlastIdx = container.childNodes.length - 1;\n\n\t\t\t\tif (!start && offset)\n\t\t\t\t\toffset--;\n\n\t\t\t\tcontainer = container.childNodes[offset > lastIdx ? lastIdx : offset];\n\t\t\t}\n\n\t\t\t// If start text node is excluded then walk to the next node\n\t\t\tif (container.nodeType === 3 && start && offset >= container.nodeValue.length) {\n\t\t\t\tcontainer = new TreeWalker(container, ed.getBody()).next() || container;\n\t\t\t}\n\n\t\t\t// If end text node is excluded then walk to the previous node\n\t\t\tif (container.nodeType === 3 && !start && offset == 0) {\n\t\t\t\tcontainer = new TreeWalker(container, ed.getBody()).prev() || container;\n\t\t\t}\n\n\t\t\treturn container;\n\t\t};\n\n\t\tfunction performCaretAction(type, name, vars) {\n\t\t\tvar invisibleChar, caretContainerId = '_mce_caret', debug = ed.settings.caret_debug;\n\n\t\t\t// Setup invisible character use zero width space on Gecko since it doesn't change the heigt of the container\n\t\t\tinvisibleChar = tinymce.isGecko ? '\\u200B' : INVISIBLE_CHAR;\n\n\t\t\t// Creates a caret container bogus element\n\t\t\tfunction createCaretContainer(fill) {\n\t\t\t\tvar caretContainer = dom.create('span', {id: caretContainerId, 'data-mce-bogus': true, style: debug ? 'color:red' : ''});\n\n\t\t\t\tif (fill) {\n\t\t\t\t\tcaretContainer.appendChild(ed.getDoc().createTextNode(invisibleChar));\n\t\t\t\t}\n\n\t\t\t\treturn caretContainer;\n\t\t\t};\n\n\t\t\tfunction isCaretContainerEmpty(node, nodes) {\n\t\t\t\twhile (node) {\n\t\t\t\t\tif ((node.nodeType === 3 && node.nodeValue !== invisibleChar) || node.childNodes.length > 1) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Collect nodes\n\t\t\t\t\tif (nodes && node.nodeType === 1) {\n\t\t\t\t\t\tnodes.push(node);\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = node.firstChild;\n\t\t\t\t}\n\n\t\t\t\treturn true;\n\t\t\t};\n\t\t\t\n\t\t\t// Returns any parent caret container element\n\t\t\tfunction getParentCaretContainer(node) {\n\t\t\t\twhile (node) {\n\t\t\t\t\tif (node.id === caretContainerId) {\n\t\t\t\t\t\treturn node;\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Finds the first text node in the specified node\n\t\t\tfunction findFirstTextNode(node) {\n\t\t\t\tvar walker;\n\n\t\t\t\tif (node) {\n\t\t\t\t\twalker = new TreeWalker(node, node);\n\n\t\t\t\t\tfor (node = walker.current(); node; node = walker.next()) {\n\t\t\t\t\t\tif (node.nodeType === 3) {\n\t\t\t\t\t\t\treturn node;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Removes the caret container for the specified node or all on the current document\n\t\t\tfunction removeCaretContainer(node, move_caret) {\n\t\t\t\tvar child, rng;\n\n\t\t\t\tif (!node) {\n\t\t\t\t\tnode = getParentCaretContainer(selection.getStart());\n\n\t\t\t\t\tif (!node) {\n\t\t\t\t\t\twhile (node = dom.get(caretContainerId)) {\n\t\t\t\t\t\t\tremoveCaretContainer(node, false);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\trng = selection.getRng(true);\n\n\t\t\t\t\tif (isCaretContainerEmpty(node)) {\n\t\t\t\t\t\tif (move_caret !== false) {\n\t\t\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\t\t\trng.setEndBefore(node);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tdom.remove(node);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tchild = findFirstTextNode(node);\n\t\t\t\t\t\tchild = child.deleteData(0, 1);\n\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t}\n\n\t\t\t\t\tselection.setRng(rng);\n\t\t\t\t}\n\t\t\t};\n\t\t\t\n\t\t\t// Applies formatting to the caret position\n\t\t\tfunction applyCaretFormat() {\n\t\t\t\tvar rng, caretContainer, textNode, offset, bookmark, container, text;\n\n\t\t\t\trng = selection.getRng(true);\n\t\t\t\toffset = rng.startOffset;\n\t\t\t\tcontainer = rng.startContainer;\n\t\t\t\ttext = container.nodeValue;\n\n\t\t\t\tcaretContainer = getParentCaretContainer(selection.getStart());\n\t\t\t\tif (caretContainer) {\n\t\t\t\t\ttextNode = findFirstTextNode(caretContainer);\n\t\t\t\t}\n\n\t\t\t\t// Expand to word is caret is in the middle of a text node and the char before/after is a alpha numeric character\n\t\t\t\tif (text && offset > 0 && offset < text.length && /\\w/.test(text.charAt(offset)) && /\\w/.test(text.charAt(offset - 1))) {\n\t\t\t\t\t// Get bookmark of caret position\n\t\t\t\t\tbookmark = selection.getBookmark();\n\n\t\t\t\t\t// Collapse bookmark range (WebKit)\n\t\t\t\t\trng.collapse(true);\n\n\t\t\t\t\t// Expand the range to the closest word and split it at those points\n\t\t\t\t\trng = expandRng(rng, get(name));\n\t\t\t\t\trng = rangeUtils.split(rng);\n\n\t\t\t\t\t// Apply the format to the range\n\t\t\t\t\tapply(name, vars, rng);\n\n\t\t\t\t\t// Move selection back to caret position\n\t\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t\t} else {\n\t\t\t\t\tif (!caretContainer || textNode.nodeValue !== invisibleChar) {\n\t\t\t\t\t\tcaretContainer = createCaretContainer(true);\n\t\t\t\t\t\ttextNode = caretContainer.firstChild;\n\n\t\t\t\t\t\trng.insertNode(caretContainer);\n\t\t\t\t\t\toffset = 1;\n\n\t\t\t\t\t\tapply(name, vars, caretContainer);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tapply(name, vars, caretContainer);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Move selection to text node\n\t\t\t\t\tselection.setCursorLocation(textNode, offset);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tfunction removeCaretFormat() {\n\t\t\t\tvar rng = selection.getRng(true), container, offset, bookmark,\n\t\t\t\t\thasContentAfter, node, formatNode, parents = [], i, caretContainer;\n\n\t\t\t\tcontainer = rng.startContainer;\n\t\t\t\toffset = rng.startOffset;\n\t\t\t\tnode = container;\n\n\t\t\t\tif (container.nodeType == 3) {\n\t\t\t\t\tif (offset != container.nodeValue.length || container.nodeValue === invisibleChar) {\n\t\t\t\t\t\thasContentAfter = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t}\n\n\t\t\t\twhile (node) {\n\t\t\t\t\tif (matchNode(node, name, vars)) {\n\t\t\t\t\t\tformatNode = node;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (node.nextSibling) {\n\t\t\t\t\t\thasContentAfter = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tparents.push(node);\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t}\n\n\t\t\t\t// Node doesn't have the specified format\n\t\t\t\tif (!formatNode) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Is there contents after the caret then remove the format on the element\n\t\t\t\tif (hasContentAfter) {\n\t\t\t\t\t// Get bookmark of caret position\n\t\t\t\t\tbookmark = selection.getBookmark();\n\n\t\t\t\t\t// Collapse bookmark range (WebKit)\n\t\t\t\t\trng.collapse(true);\n\n\t\t\t\t\t// Expand the range to the closest word and split it at those points\n\t\t\t\t\trng = expandRng(rng, get(name), true);\n\t\t\t\t\trng = rangeUtils.split(rng);\n\n\t\t\t\t\t// Remove the format from the range\n\t\t\t\t\tremove(name, vars, rng);\n\n\t\t\t\t\t// Move selection back to caret position\n\t\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t\t} else {\n\t\t\t\t\tcaretContainer = createCaretContainer();\n\n\t\t\t\t\tnode = caretContainer;\n\t\t\t\t\tfor (i = parents.length - 1; i >= 0; i--) {\n\t\t\t\t\t\tnode.appendChild(parents[i].cloneNode(false));\n\t\t\t\t\t\tnode = node.firstChild;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Insert invisible character into inner most format element\n\t\t\t\t\tnode.appendChild(dom.doc.createTextNode(invisibleChar));\n\t\t\t\t\tnode = node.firstChild;\n\n\t\t\t\t\t// Insert caret container after the formatted node\n\t\t\t\t\tdom.insertAfter(caretContainer, formatNode);\n\n\t\t\t\t\t// Move selection to text node\n\t\t\t\t\tselection.setCursorLocation(node, 1);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Mark current caret container elements as bogus when getting the contents so we don't end up with empty elements\n\t\t\ted.onBeforeGetContent.addToTop(function() {\n\t\t\t\tvar nodes = [], i;\n\n\t\t\t\tif (isCaretContainerEmpty(getParentCaretContainer(selection.getStart()), nodes)) {\n\t\t\t\t\t// Mark children\n\t\t\t\t\ti = nodes.length;\n\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\tdom.setAttrib(nodes[i], 'data-mce-bogus', '1');\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Remove caret container on mouse up and on key up\n\t\t\ttinymce.each('onMouseUp onKeyUp'.split(' '), function(name) {\n\t\t\t\ted[name].addToTop(function() {\n\t\t\t\t\tremoveCaretContainer();\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// Remove caret container on keydown and it's a backspace, enter or left/right arrow keys\n\t\t\ted.onKeyDown.addToTop(function(ed, e) {\n\t\t\t\tvar keyCode = e.keyCode;\n\n\t\t\t\tif (keyCode == 8 || keyCode == 37 || keyCode == 39) {\n\t\t\t\t\tremoveCaretContainer(getParentCaretContainer(selection.getStart()));\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Do apply or remove caret format\n\t\t\tif (type == \"apply\") {\n\t\t\t\tapplyCaretFormat();\n\t\t\t} else {\n\t\t\t\tremoveCaretFormat();\n\t\t\t}\n\t\t};\n\t};\n})(tinymce);\n\ntinymce.onAddEditor.add(function(tinymce, ed) {\n\tvar filters, fontSizes, dom, settings = ed.settings;\n\n\tif (settings.inline_styles) {\n\t\tfontSizes = tinymce.explode(settings.font_size_legacy_values);\n\n\t\tfunction replaceWithSpan(node, styles) {\n\t\t\ttinymce.each(styles, function(value, name) {\n\t\t\t\tif (value)\n\t\t\t\t\tdom.setStyle(node, name, value);\n\t\t\t});\n\n\t\t\tdom.rename(node, 'span');\n\t\t};\n\n\t\tfilters = {\n\t\t\tfont : function(dom, node) {\n\t\t\t\treplaceWithSpan(node, {\n\t\t\t\t\tbackgroundColor : node.style.backgroundColor,\n\t\t\t\t\tcolor : node.color,\n\t\t\t\t\tfontFamily : node.face,\n\t\t\t\t\tfontSize : fontSizes[parseInt(node.size) - 1]\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tu : function(dom, node) {\n\t\t\t\treplaceWithSpan(node, {\n\t\t\t\t\ttextDecoration : 'underline'\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tstrike : function(dom, node) {\n\t\t\t\treplaceWithSpan(node, {\n\t\t\t\t\ttextDecoration : 'line-through'\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\tfunction convert(editor, params) {\n\t\t\tdom = editor.dom;\n\n\t\t\tif (settings.convert_fonts_to_spans) {\n\t\t\t\ttinymce.each(dom.select('font,u,strike', params.node), function(node) {\n\t\t\t\t\tfilters[node.nodeName.toLowerCase()](ed.dom, node);\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\ted.onPreProcess.add(convert);\n\t\ted.onSetContent.add(convert);\n\n\t\ted.onInit.add(function() {\n\t\t\ted.selection.onSetContent.add(convert);\n\t\t});\n\t}\n});\n\n","Magento_Tinymce3/tiny_mce/tiny_mce_jquery_src.js":"(function(win) {\n\tvar whiteSpaceRe = /^\\s*|\\s*$/g,\n\t\tundefined, isRegExpBroken = 'B'.replace(/A(.)|B/, '$1') === '$1';\n\n\tvar tinymce = {\n\t\tmajorVersion : '3',\n\n\t\tminorVersion : '4.7',\n\n\t\treleaseDate : '2011-11-03',\n\n\t\t_init : function() {\n\t\t\tvar t = this, d = document, na = navigator, ua = na.userAgent, i, nl, n, base, p, v;\n\n\t\t\tt.isOpera = win.opera && opera.buildNumber;\n\n\t\t\tt.isWebKit = /WebKit/.test(ua);\n\n\t\t\tt.isIE = !t.isWebKit && !t.isOpera && (/MSIE/gi).test(ua) && (/Explorer/gi).test(na.appName);\n\n\t\t\tt.isIE6 = t.isIE && /MSIE [56]/.test(ua);\n\n\t\t\tt.isIE7 = t.isIE && /MSIE [7]/.test(ua);\n\n\t\t\tt.isIE8 = t.isIE && /MSIE [8]/.test(ua);\n\n\t\t\tt.isIE9 = t.isIE && /MSIE [9]/.test(ua);\n\n\t\t\tt.isGecko = !t.isWebKit && /Gecko/.test(ua);\n\n\t\t\tt.isMac = ua.indexOf('Mac') != -1;\n\n\t\t\tt.isAir = /adobeair/i.test(ua);\n\n\t\t\tt.isIDevice = /(iPad|iPhone)/.test(ua);\n\n\t\t\tt.isIOS5 = t.isIDevice && ua.match(/AppleWebKit\\/(\\d*)/)[1]>=534;\n\n\t\t\t// TinyMCE .NET webcontrol might be setting the values for TinyMCE\n\t\t\tif (win.tinyMCEPreInit) {\n\t\t\t\tt.suffix = tinyMCEPreInit.suffix;\n\t\t\t\tt.baseURL = tinyMCEPreInit.base;\n\t\t\t\tt.query = tinyMCEPreInit.query;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Get suffix and base\n\t\t\tt.suffix = '';\n\n\t\t\t// If base element found, add that infront of baseURL\n\t\t\tnl = d.getElementsByTagName('base');\n\t\t\tfor (i=0; i<nl.length; i++) {\n\t\t\t\tif (v = nl[i].href) {\n\t\t\t\t\t// Host only value like http://site.com or http://site.com:8008\n\t\t\t\t\tif (/^https?:\\/\\/[^\\/]+$/.test(v))\n\t\t\t\t\t\tv += '/';\n\n\t\t\t\t\tbase = v ? v.match(/.*\\//)[0] : ''; // Get only directory\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfunction getBase(n) {\n\t\t\t\tif (n.src && /tiny_mce(|_gzip|_jquery|_prototype|_full)(_dev|_src)?.js/.test(n.src)) {\n\t\t\t\t\tif (/_(src|dev)\\.js/g.test(n.src))\n\t\t\t\t\t\tt.suffix = '_src';\n\n\t\t\t\t\tif ((p = n.src.indexOf('?')) != -1)\n\t\t\t\t\t\tt.query = n.src.substring(p + 1);\n\n\t\t\t\t\tt.baseURL = n.src.substring(0, n.src.lastIndexOf('/'));\n\n\t\t\t\t\t// If path to script is relative and a base href was found add that one infront\n\t\t\t\t\t// the src property will always be an absolute one on non IE browsers and IE 8\n\t\t\t\t\t// so this logic will basically only be executed on older IE versions\n\t\t\t\t\tif (base && t.baseURL.indexOf('://') == -1 && t.baseURL.indexOf('/') !== 0)\n\t\t\t\t\t\tt.baseURL = base + t.baseURL;\n\n\t\t\t\t\treturn t.baseURL;\n\t\t\t\t}\n\n\t\t\t\treturn null;\n\t\t\t};\n\n\t\t\t// Check document\n\t\t\tnl = d.getElementsByTagName('script');\n\t\t\tfor (i=0; i<nl.length; i++) {\n\t\t\t\tif (getBase(nl[i]))\n\t\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Check head\n\t\t\tn = d.getElementsByTagName('head')[0];\n\t\t\tif (n) {\n\t\t\t\tnl = n.getElementsByTagName('script');\n\t\t\t\tfor (i=0; i<nl.length; i++) {\n\t\t\t\t\tif (getBase(nl[i]))\n\t\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn;\n\t\t},\n\n\t\tis : function(o, t) {\n\t\t\tif (!t)\n\t\t\t\treturn o !== undefined;\n\n\t\t\tif (t == 'array' && (o.hasOwnProperty && o instanceof Array))\n\t\t\t\treturn true;\n\n\t\t\treturn typeof(o) == t;\n\t\t},\n\n\t\tmakeMap : function(items, delim, map) {\n\t\t\tvar i;\n\n\t\t\titems = items || [];\n\t\t\tdelim = delim || ',';\n\n\t\t\tif (typeof(items) == \"string\")\n\t\t\t\titems = items.split(delim);\n\n\t\t\tmap = map || {};\n\n\t\t\ti = items.length;\n\t\t\twhile (i--)\n\t\t\t\tmap[items[i]] = {};\n\n\t\t\treturn map;\n\t\t},\n\n\t\teach : function(o, cb, s) {\n\t\t\tvar n, l;\n\n\t\t\tif (!o)\n\t\t\t\treturn 0;\n\n\t\t\ts = s || o;\n\n\t\t\tif (o.length !== undefined) {\n\t\t\t\t// Indexed arrays, needed for Safari\n\t\t\t\tfor (n=0, l = o.length; n < l; n++) {\n\t\t\t\t\tif (cb.call(s, o[n], n, o) === false)\n\t\t\t\t\t\treturn 0;\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Hashtables\n\t\t\t\tfor (n in o) {\n\t\t\t\t\tif (o.hasOwnProperty(n)) {\n\t\t\t\t\t\tif (cb.call(s, o[n], n, o) === false)\n\t\t\t\t\t\t\treturn 0;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn 1;\n\t\t},\n\n\n\t\ttrim : function(s) {\n\t\t\treturn (s ? '' + s : '').replace(whiteSpaceRe, '');\n\t\t},\n\n\t\tcreate : function(s, p, root) {\n\t\t\tvar t = this, sp, ns, cn, scn, c, de = 0;\n\n\t\t\t// Parse : <prefix> <class>:<super class>\n\t\t\ts = /^((static) )?([\\w.]+)(:([\\w.]+))?/.exec(s);\n\t\t\tcn = s[3].match(/(^|\\.)(\\w+)$/i)[2]; // Class name\n\n\t\t\t// Create namespace for new class\n\t\t\tns = t.createNS(s[3].replace(/\\.\\w+$/, ''), root);\n\n\t\t\t// Class already exists\n\t\t\tif (ns[cn])\n\t\t\t\treturn;\n\n\t\t\t// Make pure static class\n\t\t\tif (s[2] == 'static') {\n\t\t\t\tns[cn] = p;\n\n\t\t\t\tif (this.onCreate)\n\t\t\t\t\tthis.onCreate(s[2], s[3], ns[cn]);\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Create default constructor\n\t\t\tif (!p[cn]) {\n\t\t\t\tp[cn] = function() {};\n\t\t\t\tde = 1;\n\t\t\t}\n\n\t\t\t// Add constructor and methods\n\t\t\tns[cn] = p[cn];\n\t\t\tt.extend(ns[cn].prototype, p);\n\n\t\t\t// Extend\n\t\t\tif (s[5]) {\n\t\t\t\tsp = t.resolve(s[5]).prototype;\n\t\t\t\tscn = s[5].match(/\\.(\\w+)$/i)[1]; // Class name\n\n\t\t\t\t// Extend constructor\n\t\t\t\tc = ns[cn];\n\t\t\t\tif (de) {\n\t\t\t\t\t// Add passthrough constructor\n\t\t\t\t\tns[cn] = function() {\n\t\t\t\t\t\treturn sp[scn].apply(this, arguments);\n\t\t\t\t\t};\n\t\t\t\t} else {\n\t\t\t\t\t// Add inherit constructor\n\t\t\t\t\tns[cn] = function() {\n\t\t\t\t\t\tthis.parent = sp[scn];\n\t\t\t\t\t\treturn c.apply(this, arguments);\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t\tns[cn].prototype[cn] = ns[cn];\n\n\t\t\t\t// Add super methods\n\t\t\t\tt.each(sp, function(f, n) {\n\t\t\t\t\tns[cn].prototype[n] = sp[n];\n\t\t\t\t});\n\n\t\t\t\t// Add overridden methods\n\t\t\t\tt.each(p, function(f, n) {\n\t\t\t\t\t// Extend methods if needed\n\t\t\t\t\tif (sp[n]) {\n\t\t\t\t\t\tns[cn].prototype[n] = function() {\n\t\t\t\t\t\t\tthis.parent = sp[n];\n\t\t\t\t\t\t\treturn f.apply(this, arguments);\n\t\t\t\t\t\t};\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif (n != cn)\n\t\t\t\t\t\t\tns[cn].prototype[n] = f;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Add static methods\n\t\t\tt.each(p['static'], function(f, n) {\n\t\t\t\tns[cn][n] = f;\n\t\t\t});\n\n\t\t\tif (this.onCreate)\n\t\t\t\tthis.onCreate(s[2], s[3], ns[cn].prototype);\n\t\t},\n\n\t\twalk : function(o, f, n, s) {\n\t\t\ts = s || this;\n\n\t\t\tif (o) {\n\t\t\t\tif (n)\n\t\t\t\t\to = o[n];\n\n\t\t\t\ttinymce.each(o, function(o, i) {\n\t\t\t\t\tif (f.call(s, o, i, n) === false)\n\t\t\t\t\t\treturn false;\n\n\t\t\t\t\ttinymce.walk(o, f, n, s);\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\tcreateNS : function(n, o) {\n\t\t\tvar i, v;\n\n\t\t\to = o || win;\n\n\t\t\tn = n.split('.');\n\t\t\tfor (i=0; i<n.length; i++) {\n\t\t\t\tv = n[i];\n\n\t\t\t\tif (!o[v])\n\t\t\t\t\to[v] = {};\n\n\t\t\t\to = o[v];\n\t\t\t}\n\n\t\t\treturn o;\n\t\t},\n\n\t\tresolve : function(n, o) {\n\t\t\tvar i, l;\n\n\t\t\to = o || win;\n\n\t\t\tn = n.split('.');\n\t\t\tfor (i = 0, l = n.length; i < l; i++) {\n\t\t\t\to = o[n[i]];\n\n\t\t\t\tif (!o)\n\t\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\treturn o;\n\t\t},\n\n\t\taddUnload : function(f, s) {\n\t\t\tvar t = this;\n\n\t\t\tf = {func : f, scope : s || this};\n\n\t\t\tif (!t.unloads) {\n\t\t\t\tfunction unload() {\n\t\t\t\t\tvar li = t.unloads, o, n;\n\n\t\t\t\t\tif (li) {\n\t\t\t\t\t\t// Call unload handlers\n\t\t\t\t\t\tfor (n in li) {\n\t\t\t\t\t\t\to = li[n];\n\n\t\t\t\t\t\t\tif (o && o.func)\n\t\t\t\t\t\t\t\to.func.call(o.scope, 1); // Send in one arg to distinct unload and user destroy\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Detach unload function\n\t\t\t\t\t\tif (win.detachEvent) {\n\t\t\t\t\t\t\twin.detachEvent('onbeforeunload', fakeUnload);\n\t\t\t\t\t\t\twin.detachEvent('onunload', unload);\n\t\t\t\t\t\t} else if (win.removeEventListener)\n\t\t\t\t\t\t\twin.removeEventListener('unload', unload, false);\n\n\t\t\t\t\t\t// Destroy references\n\t\t\t\t\t\tt.unloads = o = li = w = unload = 0;\n\n\t\t\t\t\t\t// Run garbarge collector on IE\n\t\t\t\t\t\tif (win.CollectGarbage)\n\t\t\t\t\t\t\tCollectGarbage();\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\tfunction fakeUnload() {\n\t\t\t\t\tvar d = document;\n\n\t\t\t\t\t// Is there things still loading, then do some magic\n\t\t\t\t\tif (d.readyState == 'interactive') {\n\t\t\t\t\t\tfunction stop() {\n\t\t\t\t\t\t\t// Prevent memory leak\n\t\t\t\t\t\t\td.detachEvent('onstop', stop);\n\n\t\t\t\t\t\t\t// Call unload handler\n\t\t\t\t\t\t\tif (unload)\n\t\t\t\t\t\t\t\tunload();\n\n\t\t\t\t\t\t\td = 0;\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\t// Fire unload when the currently loading page is stopped\n\t\t\t\t\t\tif (d)\n\t\t\t\t\t\t\td.attachEvent('onstop', stop);\n\n\t\t\t\t\t\t// Remove onstop listener after a while to prevent the unload function\n\t\t\t\t\t\t// to execute if the user presses cancel in an onbeforeunload\n\t\t\t\t\t\t// confirm dialog and then presses the browser stop button\n\t\t\t\t\t\twin.setTimeout(function() {\n\t\t\t\t\t\t\tif (d)\n\t\t\t\t\t\t\t\td.detachEvent('onstop', stop);\n\t\t\t\t\t\t}, 0);\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\t// Attach unload handler\n\t\t\t\tif (win.attachEvent) {\n\t\t\t\t\twin.attachEvent('onunload', unload);\n\t\t\t\t\twin.attachEvent('onbeforeunload', fakeUnload);\n\t\t\t\t} else if (win.addEventListener)\n\t\t\t\t\twin.addEventListener('unload', unload, false);\n\n\t\t\t\t// Setup initial unload handler array\n\t\t\t\tt.unloads = [f];\n\t\t\t} else\n\t\t\t\tt.unloads.push(f);\n\n\t\t\treturn f;\n\t\t},\n\n\t\tremoveUnload : function(f) {\n\t\t\tvar u = this.unloads, r = null;\n\n\t\t\ttinymce.each(u, function(o, i) {\n\t\t\t\tif (o && o.func == f) {\n\t\t\t\t\tu.splice(i, 1);\n\t\t\t\t\tr = f;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn r;\n\t\t},\n\n\t\texplode : function(s, d) {\n\t\t\treturn s ? tinymce.map(s.split(d || ','), tinymce.trim) : s;\n\t\t},\n\n\t\t_addVer : function(u) {\n\t\t\tvar v;\n\n\t\t\tif (!this.query)\n\t\t\t\treturn u;\n\n\t\t\tv = (u.indexOf('?') == -1 ? '?' : '&') + this.query;\n\n\t\t\tif (u.indexOf('#') == -1)\n\t\t\t\treturn u + v;\n\n\t\t\treturn u.replace('#', v + '#');\n\t\t},\n\n\t\t// Fix function for IE 9 where regexps isn't working correctly\n\t\t// Todo: remove me once MS fixes the bug\n\t\t_replace : function(find, replace, str) {\n\t\t\t// On IE9 we have to fake $x replacement\n\t\t\tif (isRegExpBroken) {\n\t\t\t\treturn str.replace(find, function() {\n\t\t\t\t\tvar val = replace, args = arguments, i;\n\n\t\t\t\t\tfor (i = 0; i < args.length - 2; i++) {\n\t\t\t\t\t\tif (args[i] === undefined) {\n\t\t\t\t\t\t\tval = val.replace(new RegExp('\\\\$' + i, 'g'), '');\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tval = val.replace(new RegExp('\\\\$' + i, 'g'), args[i]);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn val;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn str.replace(find, replace);\n\t\t}\n\n\t\t};\n\n\t// Initialize the API\n\ttinymce._init();\n\n\t// Expose tinymce namespace to the global namespace (window)\n\twin.tinymce = win.tinyMCE = tinymce;\n\n\t// Describe the different namespaces\n\n\t})(window);\n\n\n(function($, tinymce) {\n\tvar is = tinymce.is, attrRegExp = /^(href|src|style)$/i, undefined;\n\n\t// jQuery is undefined\n\tif (!$ && window.console) {\n\t\treturn console.log(\"Load jQuery first!\");\n\t}\n\n\t// Stick jQuery into the tinymce namespace\n\ttinymce.$ = $;\n\n\t// Setup adapter\n\ttinymce.adapter = {\n\t\tpatchEditor : function(editor) {\n\t\t\tvar fn = $.fn;\n\n\t\t\t// Adapt the css function to make sure that the data-mce-style\n\t\t\t// attribute gets updated with the new style information\n\t\t\tfunction css(name, value) {\n\t\t\t\tvar self = this;\n\n\t\t\t\t// Remove data-mce-style when set operation occurs\n\t\t\t\tif (value)\n\t\t\t\t\tself.removeAttr('data-mce-style');\n\n\t\t\t\treturn fn.css.apply(self, arguments);\n\t\t\t};\n\n\t\t\t// Apapt the attr function to make sure that it uses the data-mce- prefixed variants\n\t\t\tfunction attr(name, value) {\n\t\t\t\tvar self = this;\n\n\t\t\t\t// Update/retrieve data-mce- attribute variants\n\t\t\t\tif (attrRegExp.test(name)) {\n\t\t\t\t\tif (value !== undefined) {\n\t\t\t\t\t\t// Use TinyMCE behavior when setting the specifc attributes\n\t\t\t\t\t\tself.each(function(i, node) {\n\t\t\t\t\t\t\teditor.dom.setAttrib(node, name, value);\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\treturn self;\n\t\t\t\t\t} else\n\t\t\t\t\t\treturn self.attr('data-mce-' + name);\n\t\t\t\t}\n\n\t\t\t\t// Default behavior\n\t\t\t\treturn fn.attr.apply(self, arguments);\n\t\t\t};\n\n\t\t\tfunction htmlPatchFunc(func) {\n\t\t\t\t// Returns a modified function that processes\n\t\t\t\t// the HTML before executing the action this makes sure\n\t\t\t\t// that href/src etc gets moved into the data-mce- variants\n\t\t\t\treturn function(content) {\n\t\t\t\t\tif (content)\n\t\t\t\t\t\tcontent = editor.dom.processHTML(content);\n\n\t\t\t\t\treturn func.call(this, content);\n\t\t\t\t};\n\t\t\t};\n\n\t\t\t// Patch various jQuery functions to handle tinymce specific attribute and content behavior\n\t\t\t// we don't patch the jQuery.fn directly since it will most likely break compatibility\n\t\t\t// with other jQuery logic on the page. Only instances created by TinyMCE should be patched.\n\t\t\tfunction patch(jq) {\n\t\t\t\t// Patch some functions, only patch the object once\n\t\t\t\tif (jq.css !== css) {\n\t\t\t\t\t// Patch css/attr to use the data-mce- prefixed attribute variants\n\t\t\t\t\tjq.css = css;\n\t\t\t\t\tjq.attr = attr;\n\n\t\t\t\t\t// Patch HTML functions to use the DOMUtils.processHTML filter logic\n\t\t\t\t\tjq.html = htmlPatchFunc(fn.html);\n\t\t\t\t\tjq.append = htmlPatchFunc(fn.append);\n\t\t\t\t\tjq.prepend = htmlPatchFunc(fn.prepend);\n\t\t\t\t\tjq.after = htmlPatchFunc(fn.after);\n\t\t\t\t\tjq.before = htmlPatchFunc(fn.before);\n\t\t\t\t\tjq.replaceWith = htmlPatchFunc(fn.replaceWith);\n\t\t\t\t\tjq.tinymce = editor;\n\n\t\t\t\t\t// Each pushed jQuery instance needs to be patched\n\t\t\t\t\t// as well for example when traversing the DOM\n\t\t\t\t\tjq.pushStack = function() {\n\t\t\t\t\t\treturn patch(fn.pushStack.apply(this, arguments));\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\treturn jq;\n\t\t\t};\n\n\t\t\t// Add a $ function on each editor instance this one is scoped for the editor document object\n\t\t\t// this way you can do chaining like this tinymce.get(0).$('p').append('text').css('color', 'red');\n\t\t\teditor.$ = function(selector, scope) {\n\t\t\t\tvar doc = editor.getDoc();\n\n\t\t\t\treturn patch($(selector || doc, doc || scope));\n\t\t\t};\n\t\t}\n\t};\n\n\t// Patch in core NS functions\n\ttinymce.extend = $.extend;\n\ttinymce.extend(tinymce, {\n\t\tmap : $.map,\n\t\tgrep : function(a, f) {return $.grep(a, f || function(){return 1;});},\n\t\tinArray : function(a, v) {return $.inArray(v, a || []);}\n\n\t\t/* Didn't iterate stylesheets\n\t\teach : function(o, cb, s) {\n\t\t\tif (!o)\n\t\t\t\treturn 0;\n\n\t\t\tvar r = 1;\n\n\t\t\t$.each(o, function(nr, el){\n\t\t\t\tif (cb.call(s, el, nr, o) === false) {\n\t\t\t\t\tr = 0;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn r;\n\t\t}*/\n\t});\n\n\t// Patch in functions in various clases\n\t// Add a \"#ifndefjquery\" statement around each core API function you add below\n\tvar patches = {\n\t\t'tinymce.dom.DOMUtils' : {\n\t\t\t/*\n\t\t\taddClass : function(e, c) {\n\t\t\t\tif (is(e, 'array') && is(e[0], 'string'))\n\t\t\t\t\te = e.join(',#');\n\t\t\t\treturn (e && $(is(e, 'string') ? '#' + e : e)\n\t\t\t\t\t.addClass(c)\n\t\t\t\t\t.attr('class')) || false;\n\t\t\t},\n\n\t\t\thasClass : function(n, c) {\n\t\t\t\treturn $(is(n, 'string') ? '#' + n : n).hasClass(c);\n\t\t\t},\n\n\t\t\tremoveClass : function(e, c) {\n\t\t\t\tif (!e)\n\t\t\t\t\treturn false;\n\n\t\t\t\tvar r = [];\n\n\t\t\t\t$(is(e, 'string') ? '#' + e : e)\n\t\t\t\t\t.removeClass(c)\n\t\t\t\t\t.each(function(){\n\t\t\t\t\t\tr.push(this.className);\n\t\t\t\t\t});\n\n\t\t\t\treturn r.length == 1 ? r[0] : r;\n\t\t\t},\n\t\t\t*/\n\n\t\t\tselect : function(pattern, scope) {\n\t\t\t\tvar t = this;\n\n\t\t\t\treturn $.find(pattern, t.get(scope) || t.get(t.settings.root_element) || t.doc, []);\n\t\t\t},\n\n\t\t\tis : function(n, patt) {\n\t\t\t\treturn $(this.get(n)).is(patt);\n\t\t\t}\n\n\t\t\t/*\n\t\t\tshow : function(e) {\n\t\t\t\tif (is(e, 'array') && is(e[0], 'string'))\n\t\t\t\t\te = e.join(',#');\n\n\t\t\t\t$(is(e, 'string') ? '#' + e : e).css('display', 'block');\n\t\t\t},\n\n\t\t\thide : function(e) {\n\t\t\t\tif (is(e, 'array') && is(e[0], 'string'))\n\t\t\t\t\te = e.join(',#');\n\n\t\t\t\t$(is(e, 'string') ? '#' + e : e).css('display', 'none');\n\t\t\t},\n\n\t\t\tisHidden : function(e) {\n\t\t\t\treturn $(is(e, 'string') ? '#' + e : e).is(':hidden');\n\t\t\t},\n\n\t\t\tinsertAfter : function(n, e) {\n\t\t\t\treturn $(is(e, 'string') ? '#' + e : e).after(n);\n\t\t\t},\n\n\t\t\treplace : function(o, n, k) {\n\t\t\t\tn = $(is(n, 'string') ? '#' + n : n);\n\n\t\t\t\tif (k)\n\t\t\t\t\tn.children().appendTo(o);\n\n\t\t\t\tn.replaceWith(o);\n\t\t\t},\n\n\t\t\tsetStyle : function(n, na, v) {\n\t\t\t\tif (is(n, 'array') && is(n[0], 'string'))\n\t\t\t\t\tn = n.join(',#');\n\n\t\t\t\t$(is(n, 'string') ? '#' + n : n).css(na, v);\n\t\t\t},\n\n\t\t\tgetStyle : function(n, na, c) {\n\t\t\t\treturn $(is(n, 'string') ? '#' + n : n).css(na);\n\t\t\t},\n\n\t\t\tsetStyles : function(e, o) {\n\t\t\t\tif (is(e, 'array') && is(e[0], 'string'))\n\t\t\t\t\te = e.join(',#');\n\t\t\t\t$(is(e, 'string') ? '#' + e : e).css(o);\n\t\t\t},\n\n\t\t\tsetAttrib : function(e, n, v) {\n\t\t\t\tvar t = this, s = t.settings;\n\n\t\t\t\tif (is(e, 'array') && is(e[0], 'string'))\n\t\t\t\t\te = e.join(',#');\n\n\t\t\t\te = $(is(e, 'string') ? '#' + e : e);\n\n\t\t\t\tswitch (n) {\n\t\t\t\t\tcase \"style\":\n\t\t\t\t\t\te.each(function(i, v){\n\t\t\t\t\t\t\tif (s.keep_values)\n\t\t\t\t\t\t\t\t$(v).attr('data-mce-style', v);\n\n\t\t\t\t\t\t\tv.style.cssText = v;\n\t\t\t\t\t\t});\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase \"class\":\n\t\t\t\t\t\te.each(function(){\n\t\t\t\t\t\t\tthis.className = v;\n\t\t\t\t\t\t});\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase \"src\":\n\t\t\t\t\tcase \"href\":\n\t\t\t\t\t\te.each(function(i, v){\n\t\t\t\t\t\t\tif (s.keep_values) {\n\t\t\t\t\t\t\t\tif (s.url_converter)\n\t\t\t\t\t\t\t\t\tv = s.url_converter.call(s.url_converter_scope || t, v, n, v);\n\n\t\t\t\t\t\t\t\tt.setAttrib(v, 'data-mce-' + n, v);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tif (v !== null && v.length !== 0)\n\t\t\t\t\te.attr(n, '' + v);\n\t\t\t\telse\n\t\t\t\t\te.removeAttr(n);\n\t\t\t},\n\n\t\t\tsetAttribs : function(e, o) {\n\t\t\t\tvar t = this;\n\n\t\t\t\t$.each(o, function(n, v){\n\t\t\t\t\tt.setAttrib(e,n,v);\n\t\t\t\t});\n\t\t\t}\n\t\t\t*/\n\t\t}\n\n/*\n\t\t'tinymce.dom.Event' : {\n\t\t\tadd : function (o, n, f, s) {\n\t\t\t\tvar lo, cb;\n\n\t\t\t\tcb = function(e) {\n\t\t\t\t\te.target = e.target || this;\n\t\t\t\t\tf.call(s || this, e);\n\t\t\t\t};\n\n\t\t\t\tif (is(o, 'array') && is(o[0], 'string'))\n\t\t\t\t\to = o.join(',#');\n\t\t\t\to = $(is(o, 'string') ? '#' + o : o);\n\t\t\t\tif (n == 'init') {\n\t\t\t\t\to.ready(cb, s);\n\t\t\t\t} else {\n\t\t\t\t\tif (s) {\n\t\t\t\t\t\to.bind(n, s, cb);\n\t\t\t\t\t} else {\n\t\t\t\t\t\to.bind(n, cb);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tlo = this._jqLookup || (this._jqLookup = []);\n\t\t\t\tlo.push({func : f, cfunc : cb});\n\n\t\t\t\treturn cb;\n\t\t\t},\n\n\t\t\tremove : function(o, n, f) {\n\t\t\t\t// Find cfunc\n\t\t\t\t$(this._jqLookup).each(function() {\n\t\t\t\t\tif (this.func === f)\n\t\t\t\t\t\tf = this.cfunc;\n\t\t\t\t});\n\n\t\t\t\tif (is(o, 'array') && is(o[0], 'string'))\n\t\t\t\t\to = o.join(',#');\n\n\t\t\t\t$(is(o, 'string') ? '#' + o : o).unbind(n,f);\n\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n*/\n\t};\n\n\t// Patch functions after a class is created\n\ttinymce.onCreate = function(ty, c, p) {\n\t\ttinymce.extend(p, patches[c]);\n\t};\n})(window.jQuery, tinymce);\n\n\n\ntinymce.create('tinymce.util.Dispatcher', {\n\tscope : null,\n\tlisteners : null,\n\n\tDispatcher : function(s) {\n\t\tthis.scope = s || this;\n\t\tthis.listeners = [];\n\t},\n\n\tadd : function(cb, s) {\n\t\tthis.listeners.push({cb : cb, scope : s || this.scope});\n\n\t\treturn cb;\n\t},\n\n\taddToTop : function(cb, s) {\n\t\tthis.listeners.unshift({cb : cb, scope : s || this.scope});\n\n\t\treturn cb;\n\t},\n\n\tremove : function(cb) {\n\t\tvar l = this.listeners, o = null;\n\n\t\ttinymce.each(l, function(c, i) {\n\t\t\tif (cb == c.cb) {\n\t\t\t\to = cb;\n\t\t\t\tl.splice(i, 1);\n\t\t\t\treturn false;\n\t\t\t}\n\t\t});\n\n\t\treturn o;\n\t},\n\n\tdispatch : function() {\n\t\tvar s, a = arguments, i, li = this.listeners, c;\n\n\t\t// Needs to be a real loop since the listener count might change while looping\n\t\t// And this is also more efficient\n\t\tfor (i = 0; i<li.length; i++) {\n\t\t\tc = li[i];\n\t\t\ts = c.cb.apply(c.scope, a);\n\n\t\t\tif (s === false)\n\t\t\t\tbreak;\n\t\t}\n\n\t\treturn s;\n\t}\n\n\t});\n\n(function() {\n\tvar each = tinymce.each;\n\n\ttinymce.create('tinymce.util.URI', {\n\t\tURI : function(u, s) {\n\t\t\tvar t = this, o, a, b, base_url;\n\n\t\t\t// Trim whitespace\n\t\t\tu = tinymce.trim(u);\n\n\t\t\t// Default settings\n\t\t\ts = t.settings = s || {};\n\n\t\t\t// Strange app protocol that isn't http/https or local anchor\n\t\t\t// For example: mailto,skype,tel etc.\n\t\t\tif (/^([\\w\\-]+):([^\\/]{2})/i.test(u) || /^\\s*#/.test(u)) {\n\t\t\t\tt.source = u;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Absolute path with no host, fake host and protocol\n\t\t\tif (u.indexOf('/') === 0 && u.indexOf('//') !== 0)\n\t\t\t\tu = (s.base_uri ? s.base_uri.protocol || 'http' : 'http') + '://mce_host' + u;\n\n\t\t\t// Relative path http:// or protocol relative //path\n\t\t\tif (!/^[\\w-]*:?\\/\\//.test(u)) {\n\t\t\t\tbase_url = s.base_uri ? s.base_uri.path : new tinymce.util.URI(location.href).directory;\n\t\t\t\tu = ((s.base_uri && s.base_uri.protocol) || 'http') + '://mce_host' + t.toAbsPath(base_url, u);\n\t\t\t}\n\n\t\t\t// Parse URL (Credits goes to Steave, http://blog.stevenlevithan.com/archives/parseuri)\n\t\t\tu = u.replace(/@@/g, '(mce_at)'); // Zope 3 workaround, they use @@something\n\t\t\tu = /^(?:(?![^:@]+:[^:@\\/]*@)([^:\\/?#.]+):)?(?:\\/\\/)?((?:(([^:@]*):?([^:@]*))?@)?([^:\\/?#]*)(?::(\\d*))?)(((\\/(?:[^?#](?![^?#\\/]*\\.[^?#\\/.]+(?:[?#]|$)))*\\/?)?([^?#\\/]*))(?:\\?([^#]*))?(?:#(.*))?)/.exec(u);\n\t\t\teach([\"source\",\"protocol\",\"authority\",\"userInfo\",\"user\",\"password\",\"host\",\"port\",\"relative\",\"path\",\"directory\",\"file\",\"query\",\"anchor\"], function(v, i) {\n\t\t\t\tvar s = u[i];\n\n\t\t\t\t// Zope 3 workaround, they use @@something\n\t\t\t\tif (s)\n\t\t\t\t\ts = s.replace(/\\(mce_at\\)/g, '@@');\n\n\t\t\t\tt[v] = s;\n\t\t\t});\n\n\t\t\tif (b = s.base_uri) {\n\t\t\t\tif (!t.protocol)\n\t\t\t\t\tt.protocol = b.protocol;\n\n\t\t\t\tif (!t.userInfo)\n\t\t\t\t\tt.userInfo = b.userInfo;\n\n\t\t\t\tif (!t.port && t.host == 'mce_host')\n\t\t\t\t\tt.port = b.port;\n\n\t\t\t\tif (!t.host || t.host == 'mce_host')\n\t\t\t\t\tt.host = b.host;\n\n\t\t\t\tt.source = '';\n\t\t\t}\n\n\t\t\t//t.path = t.path || '/';\n\t\t},\n\n\t\tsetPath : function(p) {\n\t\t\tvar t = this;\n\n\t\t\tp = /^(.*?)\\/?(\\w+)?$/.exec(p);\n\n\t\t\t// Update path parts\n\t\t\tt.path = p[0];\n\t\t\tt.directory = p[1];\n\t\t\tt.file = p[2];\n\n\t\t\t// Rebuild source\n\t\t\tt.source = '';\n\t\t\tt.getURI();\n\t\t},\n\n\t\ttoRelative : function(u) {\n\t\t\tvar t = this, o;\n\n\t\t\tif (u === \"./\")\n\t\t\t\treturn u;\n\n\t\t\tu = new tinymce.util.URI(u, {base_uri : t});\n\n\t\t\t// Not on same domain/port or protocol\n\t\t\tif ((u.host != 'mce_host' && t.host != u.host && u.host) || t.port != u.port || t.protocol != u.protocol)\n\t\t\t\treturn u.getURI();\n\n\t\t\to = t.toRelPath(t.path, u.path);\n\n\t\t\t// Add query\n\t\t\tif (u.query)\n\t\t\t\to += '?' + u.query;\n\n\t\t\t// Add anchor\n\t\t\tif (u.anchor)\n\t\t\t\to += '#' + u.anchor;\n\n\t\t\treturn o;\n\t\t},\n\n\t\ttoAbsolute : function(u, nh) {\n\t\t\tvar u = new tinymce.util.URI(u, {base_uri : this});\n\n\t\t\treturn u.getURI(this.host == u.host && this.protocol == u.protocol ? nh : 0);\n\t\t},\n\n\t\ttoRelPath : function(base, path) {\n\t\t\tvar items, bp = 0, out = '', i, l;\n\n\t\t\t// Split the paths\n\t\t\tbase = base.substring(0, base.lastIndexOf('/'));\n\t\t\tbase = base.split('/');\n\t\t\titems = path.split('/');\n\n\t\t\tif (base.length >= items.length) {\n\t\t\t\tfor (i = 0, l = base.length; i < l; i++) {\n\t\t\t\t\tif (i >= items.length || base[i] != items[i]) {\n\t\t\t\t\t\tbp = i + 1;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (base.length < items.length) {\n\t\t\t\tfor (i = 0, l = items.length; i < l; i++) {\n\t\t\t\t\tif (i >= base.length || base[i] != items[i]) {\n\t\t\t\t\t\tbp = i + 1;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (bp == 1)\n\t\t\t\treturn path;\n\n\t\t\tfor (i = 0, l = base.length - (bp - 1); i < l; i++)\n\t\t\t\tout += \"../\";\n\n\t\t\tfor (i = bp - 1, l = items.length; i < l; i++) {\n\t\t\t\tif (i != bp - 1)\n\t\t\t\t\tout += \"/\" + items[i];\n\t\t\t\telse\n\t\t\t\t\tout += items[i];\n\t\t\t}\n\n\t\t\treturn out;\n\t\t},\n\n\t\ttoAbsPath : function(base, path) {\n\t\t\tvar i, nb = 0, o = [], tr, outPath;\n\n\t\t\t// Split paths\n\t\t\ttr = /\\/$/.test(path) ? '/' : '';\n\t\t\tbase = base.split('/');\n\t\t\tpath = path.split('/');\n\n\t\t\t// Remove empty chunks\n\t\t\teach(base, function(k) {\n\t\t\t\tif (k)\n\t\t\t\t\to.push(k);\n\t\t\t});\n\n\t\t\tbase = o;\n\n\t\t\t// Merge relURLParts chunks\n\t\t\tfor (i = path.length - 1, o = []; i >= 0; i--) {\n\t\t\t\t// Ignore empty or .\n\t\t\t\tif (path[i].length == 0 || path[i] == \".\")\n\t\t\t\t\tcontinue;\n\n\t\t\t\t// Is parent\n\t\t\t\tif (path[i] == '..') {\n\t\t\t\t\tnb++;\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\t// Move up\n\t\t\t\tif (nb > 0) {\n\t\t\t\t\tnb--;\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\to.push(path[i]);\n\t\t\t}\n\n\t\t\ti = base.length - nb;\n\n\t\t\t// If /a/b/c or /\n\t\t\tif (i <= 0)\n\t\t\t\toutPath = o.reverse().join('/');\n\t\t\telse\n\t\t\t\toutPath = base.slice(0, i).join('/') + '/' + o.reverse().join('/');\n\n\t\t\t// Add front / if it's needed\n\t\t\tif (outPath.indexOf('/') !== 0)\n\t\t\t\toutPath = '/' + outPath;\n\n\t\t\t// Add traling / if it's needed\n\t\t\tif (tr && outPath.lastIndexOf('/') !== outPath.length - 1)\n\t\t\t\toutPath += tr;\n\n\t\t\treturn outPath;\n\t\t},\n\n\t\tgetURI : function(nh) {\n\t\t\tvar s, t = this;\n\n\t\t\t// Rebuild source\n\t\t\tif (!t.source || nh) {\n\t\t\t\ts = '';\n\n\t\t\t\tif (!nh) {\n\t\t\t\t\tif (t.protocol)\n\t\t\t\t\t\ts += t.protocol + '://';\n\n\t\t\t\t\tif (t.userInfo)\n\t\t\t\t\t\ts += t.userInfo + '@';\n\n\t\t\t\t\tif (t.host)\n\t\t\t\t\t\ts += t.host;\n\n\t\t\t\t\tif (t.port)\n\t\t\t\t\t\ts += ':' + t.port;\n\t\t\t\t}\n\n\t\t\t\tif (t.path)\n\t\t\t\t\ts += t.path;\n\n\t\t\t\tif (t.query)\n\t\t\t\t\ts += '?' + t.query;\n\n\t\t\t\tif (t.anchor)\n\t\t\t\t\ts += '#' + t.anchor;\n\n\t\t\t\tt.source = s;\n\t\t\t}\n\n\t\t\treturn t.source;\n\t\t}\n\t});\n})();\n\n(function() {\n\tvar each = tinymce.each;\n\n\ttinymce.create('static tinymce.util.Cookie', {\n\t\tgetHash : function(n) {\n\t\t\tvar v = this.get(n), h;\n\n\t\t\tif (v) {\n\t\t\t\teach(v.split('&'), function(v) {\n\t\t\t\t\tv = v.split('=');\n\t\t\t\t\th = h || {};\n\t\t\t\t\th[unescape(v[0])] = unescape(v[1]);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn h;\n\t\t},\n\n\t\tsetHash : function(n, v, e, p, d, s) {\n\t\t\tvar o = '';\n\n\t\t\teach(v, function(v, k) {\n\t\t\t\to += (!o ? '' : '&') + escape(k) + '=' + escape(v);\n\t\t\t});\n\n\t\t\tthis.set(n, o, e, p, d, s);\n\t\t},\n\n\t\tget : function(n) {\n\t\t\tvar c = document.cookie, e, p = n + \"=\", b;\n\n\t\t\t// Strict mode\n\t\t\tif (!c)\n\t\t\t\treturn;\n\n\t\t\tb = c.indexOf(\"; \" + p);\n\n\t\t\tif (b == -1) {\n\t\t\t\tb = c.indexOf(p);\n\n\t\t\t\tif (b != 0)\n\t\t\t\t\treturn null;\n\t\t\t} else\n\t\t\t\tb += 2;\n\n\t\t\te = c.indexOf(\";\", b);\n\n\t\t\tif (e == -1)\n\t\t\t\te = c.length;\n\n\t\t\treturn unescape(c.substring(b + p.length, e));\n\t\t},\n\n\t\tset : function(n, v, e, p, d, s) {\n\t\t\tdocument.cookie = n + \"=\" + escape(v) +\n\t\t\t\t((e) ? \"; expires=\" + e.toUTCString() : \"\") +\n\t\t\t\t((p) ? \"; path=\" + escape(p) : \"\") +\n\t\t\t\t((d) ? \"; domain=\" + d : \"\") +\n\t\t\t\t((s) ? \"; secure\" : \"\");\n\t\t},\n\n\t\tremove : function(n, p) {\n\t\t\tvar d = new Date();\n\n\t\t\td.setTime(d.getTime() - 1000);\n\n\t\t\tthis.set(n, '', d, p, d);\n\t\t}\n\t});\n})();\n\n(function() {\n\tfunction serialize(o, quote) {\n\t\tvar i, v, t;\n\n\t\tquote = quote || '\"';\n\n\t\tif (o == null)\n\t\t\treturn 'null';\n\n\t\tt = typeof o;\n\n\t\tif (t == 'string') {\n\t\t\tv = '\\bb\\tt\\nn\\ff\\rr\\\"\"\\'\\'\\\\\\\\';\n\n\t\t\treturn quote + o.replace(/([\\u0080-\\uFFFF\\x00-\\x1f\\\"\\'\\\\])/g, function(a, b) {\n\t\t\t\t// Make sure single quotes never get encoded inside double quotes for JSON compatibility\n\t\t\t\tif (quote === '\"' && a === \"'\")\n\t\t\t\t\treturn a;\n\n\t\t\t\ti = v.indexOf(b);\n\n\t\t\t\tif (i + 1)\n\t\t\t\t\treturn '\\\\' + v.charAt(i + 1);\n\n\t\t\t\ta = b.charCodeAt().toString(16);\n\n\t\t\t\treturn '\\\\u' + '0000'.substring(a.length) + a;\n\t\t\t}) + quote;\n\t\t}\n\n\t\tif (t == 'object') {\n\t\t\tif (o.hasOwnProperty && o instanceof Array) {\n\t\t\t\t\tfor (i=0, v = '['; i<o.length; i++)\n\t\t\t\t\t\tv += (i > 0 ? ',' : '') + serialize(o[i], quote);\n\n\t\t\t\t\treturn v + ']';\n\t\t\t\t}\n\n\t\t\t\tv = '{';\n\n\t\t\t\tfor (i in o) {\n\t\t\t\t\tif (o.hasOwnProperty(i)) {\n\t\t\t\t\t\tv += typeof o[i] != 'function' ? (v.length > 1 ? ',' + quote : quote) + i + quote +':' + serialize(o[i], quote) : '';\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn v + '}';\n\t\t}\n\n\t\treturn '' + o;\n\t};\n\n\ttinymce.util.JSON = {\n\t\tserialize: serialize,\n\n\t\tparse: function(s) {\n\t\t\ttry {\n\t\t\t\treturn JSON.parse(s);\n\t\t\t} catch (ex) {\n\t\t\t\t// Ignore\n\t\t\t}\n\t\t}\n\n\t\t};\n})();\n\ntinymce.create('static tinymce.util.XHR', {\n\tsend : function(o) {\n\t\tvar x, t, w = window, c = 0;\n\n\t\t// Default settings\n\t\to.scope = o.scope || this;\n\t\to.success_scope = o.success_scope || o.scope;\n\t\to.error_scope = o.error_scope || o.scope;\n\t\to.async = o.async === false ? false : true;\n\t\to.data = o.data || '';\n\n\t\tfunction get(s) {\n\t\t\tx = 0;\n\n\t\t\ttry {\n\t\t\t\tx = new ActiveXObject(s);\n\t\t\t} catch (ex) {\n\t\t\t}\n\n\t\t\treturn x;\n\t\t};\n\n\t\tx = w.XMLHttpRequest ? new XMLHttpRequest() : get('Microsoft.XMLHTTP') || get('Msxml2.XMLHTTP');\n\n\t\tif (x) {\n\t\t\tif (x.overrideMimeType)\n\t\t\t\tx.overrideMimeType(o.content_type);\n\n\t\t\tx.open(o.type || (o.data ? 'POST' : 'GET'), o.url, o.async);\n\n\t\t\tif (o.content_type)\n\t\t\t\tx.setRequestHeader('Content-Type', o.content_type);\n\n\t\t\tx.setRequestHeader('X-Requested-With', 'XMLHttpRequest');\n\n\t\t\tx.send(o.data);\n\n\t\t\tfunction ready() {\n\t\t\t\tif (!o.async || x.readyState == 4 || c++ > 10000) {\n\t\t\t\t\tif (o.success && c < 10000 && x.status == 200)\n\t\t\t\t\t\to.success.call(o.success_scope, '' + x.responseText, x, o);\n\t\t\t\t\telse if (o.error)\n\t\t\t\t\t\to.error.call(o.error_scope, c > 10000 ? 'TIMED_OUT' : 'GENERAL', x, o);\n\n\t\t\t\t\tx = null;\n\t\t\t\t} else\n\t\t\t\t\tw.setTimeout(ready, 10);\n\t\t\t};\n\n\t\t\t// Syncronous request\n\t\t\tif (!o.async)\n\t\t\t\treturn ready();\n\n\t\t\t// Wait for response, onReadyStateChange can not be used since it leaks memory in IE\n\t\t\tt = w.setTimeout(ready, 10);\n\t\t}\n\t}\n});\n\n(function() {\n\tvar extend = tinymce.extend, JSON = tinymce.util.JSON, XHR = tinymce.util.XHR;\n\n\ttinymce.create('tinymce.util.JSONRequest', {\n\t\tJSONRequest : function(s) {\n\t\t\tthis.settings = extend({\n\t\t\t}, s);\n\t\t\tthis.count = 0;\n\t\t},\n\n\t\tsend : function(o) {\n\t\t\tvar ecb = o.error, scb = o.success;\n\n\t\t\to = extend(this.settings, o);\n\n\t\t\to.success = function(c, x) {\n\t\t\t\tc = JSON.parse(c);\n\n\t\t\t\tif (typeof(c) == 'undefined') {\n\t\t\t\t\tc = {\n\t\t\t\t\t\terror : 'JSON Parse error.'\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\tif (c.error)\n\t\t\t\t\tecb.call(o.error_scope || o.scope, c.error, x);\n\t\t\t\telse\n\t\t\t\t\tscb.call(o.success_scope || o.scope, c.result);\n\t\t\t};\n\n\t\t\to.error = function(ty, x) {\n\t\t\t\tif (ecb)\n\t\t\t\t\tecb.call(o.error_scope || o.scope, ty, x);\n\t\t\t};\n\n\t\t\to.data = JSON.serialize({\n\t\t\t\tid : o.id || 'c' + (this.count++),\n\t\t\t\tmethod : o.method,\n\t\t\t\tparams : o.params\n\t\t\t});\n\n\t\t\t// JSON content type for Ruby on rails. Bug: #1883287\n\t\t\to.content_type = 'application/json';\n\n\t\t\tXHR.send(o);\n\t\t},\n\n\t\t'static' : {\n\t\t\tsendRPC : function(o) {\n\t\t\t\treturn new tinymce.util.JSONRequest().send(o);\n\t\t\t}\n\t\t}\n\t});\n}());\n(function(tinymce){\n\ttinymce.VK = {\n\t\tDELETE: 46,\n\t\tBACKSPACE: 8,\n\t\tENTER: 13,\n\t\tTAB: 9,\n        SPACEBAR: 32,\n\t\tUP: 38,\n\t\tDOWN: 40\n\t}\n})(tinymce);\n\n(function(tinymce) {\n\tvar VK = tinymce.VK, BACKSPACE = VK.BACKSPACE, DELETE = VK.DELETE;\n\n\tfunction cleanupStylesWhenDeleting(ed) {\n\t\tvar dom = ed.dom, selection = ed.selection;\n\n\t\ted.onKeyDown.add(function(ed, e) {\n\t\t\tvar rng, blockElm, node, clonedSpan, isDelete;\n\n\t\t\tisDelete = e.keyCode == DELETE;\n\t\t\tif (isDelete || e.keyCode == BACKSPACE) {\n\t\t\t\te.preventDefault();\n\t\t\t\trng = selection.getRng();\n\n\t\t\t\t// Find root block\n\t\t\t\tblockElm = dom.getParent(rng.startContainer, dom.isBlock);\n\n\t\t\t\t// On delete clone the root span of the next block element\n\t\t\t\tif (isDelete)\n\t\t\t\t\tblockElm = dom.getNext(blockElm, dom.isBlock);\n\n\t\t\t\t// Locate root span element and clone it since it would otherwise get merged by the \"apple-style-span\" on delete/backspace\n\t\t\t\tif (blockElm) {\n\t\t\t\t\tnode = blockElm.firstChild;\n\n\t\t\t\t\t// Ignore empty text nodes\n\t\t\t\t\twhile (node && node.nodeType == 3 && node.nodeValue.length == 0)\n\t\t\t\t\t\tnode = node.nextSibling;\n\n\t\t\t\t\tif (node && node.nodeName === 'SPAN') {\n\t\t\t\t\t\tclonedSpan = node.cloneNode(false);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Do the backspace/delete actiopn\n\t\t\t\ted.getDoc().execCommand(isDelete ? 'ForwardDelete' : 'Delete', false, null);\n\n\t\t\t\t// Find all odd apple-style-spans\n\t\t\t\tblockElm = dom.getParent(rng.startContainer, dom.isBlock);\n\t\t\t\ttinymce.each(dom.select('span.Apple-style-span,font.Apple-style-span', blockElm), function(span) {\n\t\t\t\t\tvar bm = selection.getBookmark();\n\n\t\t\t\t\tif (clonedSpan) {\n\t\t\t\t\t\tdom.replace(clonedSpan.cloneNode(false), span, true);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tdom.remove(span, true);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Restore the selection\n\t\t\t\t\tselection.moveToBookmark(bm);\n\t\t\t\t});\n\t\t\t}\n\t\t});\n\t};\n\n\tfunction emptyEditorWhenDeleting(ed) {\n\t\ted.onKeyUp.add(function(ed, e) {\n\t\t\tvar keyCode = e.keyCode;\n\n\t\t\tif (keyCode == DELETE || keyCode == BACKSPACE) {\n\t\t\t\tif (ed.dom.isEmpty(ed.getBody())) {\n\t\t\t\t\ted.setContent('', {format : 'raw'});\n\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t};\n\n\tfunction inputMethodFocus(ed) {\n\t\ted.dom.bind(ed.getDoc(), 'focusin', function() {\n\t\t\ted.selection.setRng(ed.selection.getRng());\n\t\t});\n\t};\n\n\tfunction removeHrOnBackspace(ed) {\n\t\ted.onKeyDown.add(function(ed, e) {\n\t\t\tif (e.keyCode === BACKSPACE) {\n\t\t\t\tif (ed.selection.isCollapsed() && ed.selection.getRng(true).startOffset === 0) {\n\t\t\t\t\tvar node = ed.selection.getNode();\n\t\t\t\t\tvar previousSibling = node.previousSibling;\n\t\t\t\t\tif (previousSibling && previousSibling.nodeName && previousSibling.nodeName.toLowerCase() === \"hr\") {\n\t\t\t\t\t\ted.dom.remove(previousSibling);\n\t\t\t\t\t\ttinymce.dom.Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t})\n\t}\n\n\tfunction focusBody(ed) {\n\t\t// Fix for a focus bug in FF 3.x where the body element\n\t\t// wouldn't get proper focus if the user clicked on the HTML element\n\t\tif (!Range.prototype.getClientRects) { // Detect getClientRects got introduced in FF 4\n\t\t\ted.onMouseDown.add(function(ed, e) {\n\t\t\t\tif (e.target.nodeName === \"HTML\") {\n\t\t\t\t\tvar body = ed.getBody();\n\n\t\t\t\t\t// Blur the body it's focused but not correctly focused\n\t\t\t\t\tbody.blur();\n\n\t\t\t\t\t// Refocus the body after a little while\n\t\t\t\t\tsetTimeout(function() {\n\t\t\t\t\t\tbody.focus();\n\t\t\t\t\t}, 0);\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t};\n\n\tfunction selectControlElements(ed) {\n\t\ted.onClick.add(function(ed, e) {\n\t\t\te = e.target;\n\n\t\t\tif (/^(IMG|HR)$/.test(e.nodeName))\n\t\t\t\ted.selection.select(e);\n\n\t\t\tif (e.nodeName == 'A' && ed.dom.hasClass(e, 'mceItemAnchor'))\n\t\t\t\ted.selection.select(e);\n\n\t\t\ted.nodeChanged();\n\t\t});\n\t};\n\n\tfunction selectionChangeNodeChanged(ed) {\n\t\tvar lastRng, selectionTimer;\n\n\t\ted.dom.bind(ed.getDoc(), 'selectionchange', function() {\n\t\t\tif (selectionTimer) {\n\t\t\t\tclearTimeout(selectionTimer);\n\t\t\t\tselectionTimer = 0;\n\t\t\t}\n\n\t\t\tselectionTimer = window.setTimeout(function() {\n\t\t\t\tvar rng = ed.selection.getRng();\n\n\t\t\t\t// Compare the ranges to see if it was a real change or not\n\t\t\t\tif (!lastRng || !tinymce.dom.RangeUtils.compareRanges(rng, lastRng)) {\n\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\tlastRng = rng;\n\t\t\t\t}\n\t\t\t}, 50);\n\t\t});\n\t}\n\n\tfunction ensureBodyHasRoleApplication(ed) {\n\t\tdocument.body.setAttribute(\"role\", \"application\");\n\t}\n\n\ttinymce.create('tinymce.util.Quirks', {\n\t\tQuirks: function(ed) {\n\t\t\t// WebKit\n\t\t\tif (tinymce.isWebKit) {\n\t\t\t\tcleanupStylesWhenDeleting(ed);\n\t\t\t\temptyEditorWhenDeleting(ed);\n\t\t\t\tinputMethodFocus(ed);\n\t\t\t\tselectControlElements(ed);\n\n\t\t\t\t// iOS\n\t\t\t\tif (tinymce.isIDevice) {\n\t\t\t\t\tselectionChangeNodeChanged(ed);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// IE\n\t\t\tif (tinymce.isIE) {\n\t\t\t\tremoveHrOnBackspace(ed);\n\t\t\t\temptyEditorWhenDeleting(ed);\n\t\t\t\tensureBodyHasRoleApplication(ed);\n\t\t\t}\n\n\t\t\t// Gecko\n\t\t\tif (tinymce.isGecko) {\n\t\t\t\tremoveHrOnBackspace(ed);\n\t\t\t\tfocusBody(ed);\n\t\t\t}\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar namedEntities, baseEntities, reverseEntities,\n\t\tattrsCharsRegExp = /[&<>\\\"\\u007E-\\uD7FF\\uE000-\\uFFEF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,\n\t\ttextCharsRegExp = /[<>&\\u007E-\\uD7FF\\uE000-\\uFFEF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,\n\t\trawCharsRegExp = /[<>&\\\"\\']/g,\n\t\tentityRegExp = /&(#x|#)?([\\w]+);/g,\n\t\tasciiMap = {\n\t\t\t\t128 : \"\\u20AC\", 130 : \"\\u201A\", 131 : \"\\u0192\", 132 : \"\\u201E\", 133 : \"\\u2026\", 134 : \"\\u2020\",\n\t\t\t\t135 : \"\\u2021\", 136 : \"\\u02C6\", 137 : \"\\u2030\", 138 : \"\\u0160\", 139 : \"\\u2039\", 140 : \"\\u0152\",\n\t\t\t\t142 : \"\\u017D\", 145 : \"\\u2018\", 146 : \"\\u2019\", 147 : \"\\u201C\", 148 : \"\\u201D\", 149 : \"\\u2022\",\n\t\t\t\t150 : \"\\u2013\", 151 : \"\\u2014\", 152 : \"\\u02DC\", 153 : \"\\u2122\", 154 : \"\\u0161\", 155 : \"\\u203A\",\n\t\t\t\t156 : \"\\u0153\", 158 : \"\\u017E\", 159 : \"\\u0178\"\n\t\t};\n\n\t// Raw entities\n\tbaseEntities = {\n\t\t'\\\"' : '&quot;', // Needs to be escaped since the YUI compressor would otherwise break the code\n\t\t\"'\" : '&#39;',\n\t\t'<' : '&lt;',\n\t\t'>' : '&gt;',\n\t\t'&' : '&amp;'\n\t};\n\n\t// Reverse lookup table for raw entities\n\treverseEntities = {\n\t\t'&lt;' : '<',\n\t\t'&gt;' : '>',\n\t\t'&amp;' : '&',\n\t\t'&quot;' : '\"',\n\t\t'&apos;' : \"'\"\n\t};\n\n\t// Decodes text by using the browser\n\tfunction nativeDecode(text) {\n\t\tvar elm;\n\n\t\telm = document.createElement(\"div\");\n\t\telm.innerHTML = text;\n\n\t\treturn elm.textContent || elm.innerText || text;\n\t};\n\n\t// Build a two way lookup table for the entities\n\tfunction buildEntitiesLookup(items, radix) {\n\t\tvar i, chr, entity, lookup = {};\n\n\t\tif (items) {\n\t\t\titems = items.split(',');\n\t\t\tradix = radix || 10;\n\n\t\t\t// Build entities lookup table\n\t\t\tfor (i = 0; i < items.length; i += 2) {\n\t\t\t\tchr = String.fromCharCode(parseInt(items[i], radix));\n\n\t\t\t\t// Only add non base entities\n\t\t\t\tif (!baseEntities[chr]) {\n\t\t\t\t\tentity = '&' + items[i + 1] + ';';\n\t\t\t\t\tlookup[chr] = entity;\n\t\t\t\t\tlookup[entity] = chr;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn lookup;\n\t\t}\n\t};\n\n\t// Unpack entities lookup where the numbers are in radix 32 to reduce the size\n\tnamedEntities = buildEntitiesLookup(\n\t\t'50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,' +\n\t\t'5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,' +\n\t\t'5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,' +\n\t\t'5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,' +\n\t\t'68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,' +\n\t\t'6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,' +\n\t\t'6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,' +\n\t\t'75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,' +\n\t\t'7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,' +\n\t\t'7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,' +\n\t\t'sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,' +\n\t\t'st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,' +\n\t\t't9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,' +\n\t\t'tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,' +\n\t\t'u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,' +\n\t\t'81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,' +\n\t\t'8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,' +\n\t\t'8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,' +\n\t\t'8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,' +\n\t\t'8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,' +\n\t\t'nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,' +\n\t\t'rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,' +\n\t\t'Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,' +\n\t\t'80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,' +\n\t\t'811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro'\n\t, 32);\n\n\ttinymce.html = tinymce.html || {};\n\n\ttinymce.html.Entities = {\n\t\tencodeRaw : function(text, attr) {\n\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\treturn baseEntities[chr] || chr;\n\t\t\t});\n\t\t},\n\n\t\tencodeAllRaw : function(text) {\n\t\t\treturn ('' + text).replace(rawCharsRegExp, function(chr) {\n\t\t\t\treturn baseEntities[chr] || chr;\n\t\t\t});\n\t\t},\n\n\t\tencodeNumeric : function(text, attr) {\n\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\t// Multi byte sequence convert it to a single entity\n\t\t\t\tif (chr.length > 1)\n\t\t\t\t\treturn '&#' + (((chr.charCodeAt(0) - 0xD800) * 0x400) + (chr.charCodeAt(1) - 0xDC00) + 0x10000) + ';';\n\n\t\t\t\treturn baseEntities[chr] || '&#' + chr.charCodeAt(0) + ';';\n\t\t\t});\n\t\t},\n\n\t\tencodeNamed : function(text, attr, entities) {\n\t\t\tentities = entities || namedEntities;\n\n\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\treturn baseEntities[chr] || entities[chr] || chr;\n\t\t\t});\n\t\t},\n\n\t\tgetEncodeFunc : function(name, entities) {\n\t\t\tvar Entities = tinymce.html.Entities;\n\n\t\t\tentities = buildEntitiesLookup(entities) || namedEntities;\n\n\t\t\tfunction encodeNamedAndNumeric(text, attr) {\n\t\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\t\treturn baseEntities[chr] || entities[chr] || '&#' + chr.charCodeAt(0) + ';' || chr;\n\t\t\t\t});\n\t\t\t};\n\n\t\t\tfunction encodeCustomNamed(text, attr) {\n\t\t\t\treturn Entities.encodeNamed(text, attr, entities);\n\t\t\t};\n\n\t\t\t// Replace + with , to be compatible with previous TinyMCE versions\n\t\t\tname = tinymce.makeMap(name.replace(/\\+/g, ','));\n\n\t\t\t// Named and numeric encoder\n\t\t\tif (name.named && name.numeric)\n\t\t\t\treturn encodeNamedAndNumeric;\n\n\t\t\t// Named encoder\n\t\t\tif (name.named) {\n\t\t\t\t// Custom names\n\t\t\t\tif (entities)\n\t\t\t\t\treturn encodeCustomNamed;\n\n\t\t\t\treturn Entities.encodeNamed;\n\t\t\t}\n\n\t\t\t// Numeric\n\t\t\tif (name.numeric)\n\t\t\t\treturn Entities.encodeNumeric;\n\n\t\t\t// Raw encoder\n\t\t\treturn Entities.encodeRaw;\n\t\t},\n\n\t\tdecode : function(text) {\n\t\t\treturn text.replace(entityRegExp, function(all, numeric, value) {\n\t\t\t\tif (numeric) {\n\t\t\t\t\tvalue = parseInt(value, numeric.length === 2 ? 16 : 10);\n\n\t\t\t\t\t// Support upper UTF\n\t\t\t\t\tif (value > 0xFFFF) {\n\t\t\t\t\t\tvalue -= 0x10000;\n\n\t\t\t\t\t\treturn String.fromCharCode(0xD800 + (value >> 10), 0xDC00 + (value & 0x3FF));\n\t\t\t\t\t} else\n\t\t\t\t\t\treturn asciiMap[value] || String.fromCharCode(value);\n\t\t\t\t}\n\n\t\t\t\treturn reverseEntities[all] || namedEntities[all] || nativeDecode(all);\n\t\t\t});\n\t\t}\n\t};\n})(tinymce);\n\ntinymce.html.Styles = function(settings, schema) {\n\tvar rgbRegExp = /rgb\\s*\\(\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*\\)/gi,\n\t\turlOrStrRegExp = /(?:url(?:(?:\\(\\s*\\\"([^\\\"]+)\\\"\\s*\\))|(?:\\(\\s*\\'([^\\']+)\\'\\s*\\))|(?:\\(\\s*([^)\\s]+)\\s*\\))))|(?:\\'([^\\']+)\\')|(?:\\\"([^\\\"]+)\\\")/gi,\n\t\tstyleRegExp = /\\s*([^:]+):\\s*([^;]+);?/g,\n\t\ttrimRightRegExp = /\\s+$/,\n\t\turlColorRegExp = /rgb/,\n\t\tundef, i, encodingLookup = {}, encodingItems;\n\n\tsettings = settings || {};\n\n\tencodingItems = '\\\\\" \\\\\\' \\\\; \\\\: ; : \\uFEFF'.split(' ');\n\tfor (i = 0; i < encodingItems.length; i++) {\n\t\tencodingLookup[encodingItems[i]] = '\\uFEFF' + i;\n\t\tencodingLookup['\\uFEFF' + i] = encodingItems[i];\n\t}\n\n\tfunction toHex(match, r, g, b) {\n\t\tfunction hex(val) {\n\t\t\tval = parseInt(val).toString(16);\n\n\t\t\treturn val.length > 1 ? val : '0' + val; // 0 -> 00\n\t\t};\n\n\t\treturn '#' + hex(r) + hex(g) + hex(b);\n\t};\n\n\treturn {\n\t\ttoHex : function(color) {\n\t\t\treturn color.replace(rgbRegExp, toHex);\n\t\t},\n\n\t\tparse : function(css) {\n\t\t\tvar styles = {}, matches, name, value, isEncoded, urlConverter = settings.url_converter, urlConverterScope = settings.url_converter_scope || this;\n\n\t\t\tfunction compress(prefix, suffix) {\n\t\t\t\tvar top, right, bottom, left;\n\n\t\t\t\t// Get values and check it needs compressing\n\t\t\t\ttop = styles[prefix + '-top' + suffix];\n\t\t\t\tif (!top)\n\t\t\t\t\treturn;\n\n\t\t\t\tright = styles[prefix + '-right' + suffix];\n\t\t\t\tif (top != right)\n\t\t\t\t\treturn;\n\n\t\t\t\tbottom = styles[prefix + '-bottom' + suffix];\n\t\t\t\tif (right != bottom)\n\t\t\t\t\treturn;\n\n\t\t\t\tleft = styles[prefix + '-left' + suffix];\n\t\t\t\tif (bottom != left)\n\t\t\t\t\treturn;\n\n\t\t\t\t// Compress\n\t\t\t\tstyles[prefix + suffix] = left;\n\t\t\t\tdelete styles[prefix + '-top' + suffix];\n\t\t\t\tdelete styles[prefix + '-right' + suffix];\n\t\t\t\tdelete styles[prefix + '-bottom' + suffix];\n\t\t\t\tdelete styles[prefix + '-left' + suffix];\n\t\t\t};\n\n\t\t\tfunction canCompress(key) {\n\t\t\t\tvar value = styles[key], i;\n\n\t\t\t\tif (!value || value.indexOf(' ') < 0)\n\t\t\t\t\treturn;\n\n\t\t\t\tvalue = value.split(' ');\n\t\t\t\ti = value.length;\n\t\t\t\twhile (i--) {\n\t\t\t\t\tif (value[i] !== value[0])\n\t\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tstyles[key] = value[0];\n\n\t\t\t\treturn true;\n\t\t\t};\n\n\t\t\tfunction compress2(target, a, b, c) {\n\t\t\t\tif (!canCompress(a))\n\t\t\t\t\treturn;\n\n\t\t\t\tif (!canCompress(b))\n\t\t\t\t\treturn;\n\n\t\t\t\tif (!canCompress(c))\n\t\t\t\t\treturn;\n\n\t\t\t\t// Compress\n\t\t\t\tstyles[target] = styles[a] + ' ' + styles[b] + ' ' + styles[c];\n\t\t\t\tdelete styles[a];\n\t\t\t\tdelete styles[b];\n\t\t\t\tdelete styles[c];\n\t\t\t};\n\n\t\t\t// Encodes the specified string by replacing all \\\" \\' ; : with _<num>\n\t\t\tfunction encode(str) {\n\t\t\t\tisEncoded = true;\n\n\t\t\t\treturn encodingLookup[str];\n\t\t\t};\n\n\t\t\t// Decodes the specified string by replacing all _<num> with it's original value \\\" \\' etc\n\t\t\t// It will also decode the \\\" \\' if keep_slashes is set to fale or omitted\n\t\t\tfunction decode(str, keep_slashes) {\n\t\t\t\tif (isEncoded) {\n\t\t\t\t\tstr = str.replace(/\\uFEFF[0-9]/g, function(str) {\n\t\t\t\t\t\treturn encodingLookup[str];\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif (!keep_slashes)\n\t\t\t\t\tstr = str.replace(/\\\\([\\'\\\";:])/g, \"$1\");\n\n\t\t\t\treturn str;\n\t\t\t}\n\n\t\t\tif (css) {\n\t\t\t\t// Encode \\\" \\' % and ; and : inside strings so they don't interfere with the style parsing\n\t\t\t\tcss = css.replace(/\\\\[\\\"\\';:\\uFEFF]/g, encode).replace(/\\\"[^\\\"]+\\\"|\\'[^\\']+\\'/g, function(str) {\n\t\t\t\t\treturn str.replace(/[;:]/g, encode);\n\t\t\t\t});\n\n\t\t\t\t// Parse styles\n\t\t\t\twhile (matches = styleRegExp.exec(css)) {\n\t\t\t\t\tname = matches[1].replace(trimRightRegExp, '').toLowerCase();\n\t\t\t\t\tvalue = matches[2].replace(trimRightRegExp, '');\n\n\t\t\t\t\tif (name && value.length > 0) {\n\t\t\t\t\t\t// Opera will produce 700 instead of bold in their style values\n\t\t\t\t\t\tif (name === 'font-weight' && value === '700')\n\t\t\t\t\t\t\tvalue = 'bold';\n\t\t\t\t\t\telse if (name === 'color' || name === 'background-color') // Lowercase colors like RED\n\t\t\t\t\t\t\tvalue = value.toLowerCase();\n\n\t\t\t\t\t\t// Convert RGB colors to HEX\n\t\t\t\t\t\tvalue = value.replace(rgbRegExp, toHex);\n\n\t\t\t\t\t\t// Convert URLs and force them into url('value') format\n\t\t\t\t\t\tvalue = value.replace(urlOrStrRegExp, function(match, url, url2, url3, str, str2) {\n\t\t\t\t\t\t\tstr = str || str2;\n\n\t\t\t\t\t\t\tif (str) {\n\t\t\t\t\t\t\t\tstr = decode(str);\n\n\t\t\t\t\t\t\t\t// Force strings into single quote format\n\t\t\t\t\t\t\t\treturn \"'\" + str.replace(/\\'/g, \"\\\\'\") + \"'\";\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\turl = decode(url || url2 || url3);\n\n\t\t\t\t\t\t\t// Convert the URL to relative/absolute depending on config\n\t\t\t\t\t\t\tif (urlConverter)\n\t\t\t\t\t\t\t\turl = urlConverter.call(urlConverterScope, url, 'style');\n\n\t\t\t\t\t\t\t// Output new URL format\n\t\t\t\t\t\t\treturn \"url('\" + url.replace(/\\'/g, \"\\\\'\") + \"')\";\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tstyles[name] = isEncoded ? decode(value, true) : value;\n\t\t\t\t\t}\n\n\t\t\t\t\tstyleRegExp.lastIndex = matches.index + matches[0].length;\n\t\t\t\t}\n\n\t\t\t\t// Compress the styles to reduce it's size for example IE will expand styles\n\t\t\t\tcompress(\"border\", \"\");\n\t\t\t\tcompress(\"border\", \"-width\");\n\t\t\t\tcompress(\"border\", \"-color\");\n\t\t\t\tcompress(\"border\", \"-style\");\n\t\t\t\tcompress(\"padding\", \"\");\n\t\t\t\tcompress(\"margin\", \"\");\n\t\t\t\tcompress2('border', 'border-width', 'border-style', 'border-color');\n\n\t\t\t\t// Remove pointless border, IE produces these\n\t\t\t\tif (styles.border === 'medium none')\n\t\t\t\t\tdelete styles.border;\n\t\t\t}\n\n\t\t\treturn styles;\n\t\t},\n\n\t\tserialize : function(styles, element_name) {\n\t\t\tvar css = '', name, value;\n\n\t\t\tfunction serializeStyles(name) {\n\t\t\t\tvar styleList, i, l, value;\n\n\t\t\t\tstyleList = schema.styles[name];\n\t\t\t\tif (styleList) {\n\t\t\t\t\tfor (i = 0, l = styleList.length; i < l; i++) {\n\t\t\t\t\t\tname = styleList[i];\n\t\t\t\t\t\tvalue = styles[name];\n\n\t\t\t\t\t\tif (value !== undef && value.length > 0)\n\t\t\t\t\t\t\tcss += (css.length > 0 ? ' ' : '') + name + ': ' + value + ';';\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Serialize styles according to schema\n\t\t\tif (element_name && schema && schema.styles) {\n\t\t\t\t// Serialize global styles and element specific styles\n\t\t\t\tserializeStyles('*');\n\t\t\t\tserializeStyles(element_name);\n\t\t\t} else {\n\t\t\t\t// Output the styles in the order they are inside the object\n\t\t\t\tfor (name in styles) {\n\t\t\t\t\tvalue = styles[name];\n\n\t\t\t\t\tif (value !== undef && value.length > 0)\n\t\t\t\t\t\tcss += (css.length > 0 ? ' ' : '') + name + ': ' + value + ';';\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn css;\n\t\t}\n\t};\n};\n\n(function(tinymce) {\n\tvar transitional = {}, boolAttrMap, blockElementsMap, shortEndedElementsMap, nonEmptyElementsMap, customElementsMap = {},\n\t\tdefaultWhiteSpaceElementsMap, selfClosingElementsMap, makeMap = tinymce.makeMap, each = tinymce.each;\n\n\tfunction split(str, delim) {\n\t\treturn str.split(delim || ',');\n\t};\n\n\tfunction unpack(lookup, data) {\n\t\tvar key, elements = {};\n\n\t\tfunction replace(value) {\n\t\t\treturn value.replace(/[A-Z]+/g, function(key) {\n\t\t\t\treturn replace(lookup[key]);\n\t\t\t});\n\t\t};\n\n\t\t// Unpack lookup\n\t\tfor (key in lookup) {\n\t\t\tif (lookup.hasOwnProperty(key))\n\t\t\t\tlookup[key] = replace(lookup[key]);\n\t\t}\n\n\t\t// Unpack and parse data into object map\n\t\treplace(data).replace(/#/g, '#text').replace(/(\\w+)\\[([^\\]]+)\\]\\[([^\\]]*)\\]/g, function(str, name, attributes, children) {\n\t\t\tattributes = split(attributes, '|');\n\n\t\t\telements[name] = {\n\t\t\t\tattributes : makeMap(attributes),\n\t\t\t\tattributesOrder : attributes,\n\t\t\t\tchildren : makeMap(children, '|', {'#comment' : {}})\n\t\t\t}\n\t\t});\n\n\t\treturn elements;\n\t};\n\n\t// Build a lookup table for block elements both lowercase and uppercase\n\tblockElementsMap = 'h1,h2,h3,h4,h5,h6,hr,p,div,address,pre,form,table,tbody,thead,tfoot,' +\n\t\t\t\t\t\t'th,tr,td,li,ol,ul,caption,blockquote,center,dl,dt,dd,dir,fieldset,' +\n\t\t\t\t\t\t'noscript,menu,isindex,samp,header,footer,article,section,hgroup';\n\tblockElementsMap = makeMap(blockElementsMap, ',', makeMap(blockElementsMap.toUpperCase()));\n\n\t// This is the XHTML 1.0 transitional elements with it's attributes and children packed to reduce it's size\n\ttransitional = unpack({\n\t\tZ : 'H|K|N|O|P',\n\t\tY : 'X|form|R|Q',\n\t\tZG : 'E|span|width|align|char|charoff|valign',\n\t\tX : 'p|T|div|U|W|isindex|fieldset|table',\n\t\tZF : 'E|align|char|charoff|valign',\n\t\tW : 'pre|hr|blockquote|address|center|noframes',\n\t\tZE : 'abbr|axis|headers|scope|rowspan|colspan|align|char|charoff|valign|nowrap|bgcolor|width|height',\n\t\tZD : '[E][S]',\n\t\tU : 'ul|ol|dl|menu|dir',\n\t\tZC : 'p|Y|div|U|W|table|br|span|bdo|object|applet|img|map|K|N|Q',\n\t\tT : 'h1|h2|h3|h4|h5|h6',\n\t\tZB : 'X|S|Q',\n\t\tS : 'R|P',\n\t\tZA : 'a|G|J|M|O|P',\n\t\tR : 'a|H|K|N|O',\n\t\tQ : 'noscript|P',\n\t\tP : 'ins|del|script',\n\t\tO : 'input|select|textarea|label|button',\n\t\tN : 'M|L',\n\t\tM : 'em|strong|dfn|code|q|samp|kbd|var|cite|abbr|acronym',\n\t\tL : 'sub|sup',\n\t\tK : 'J|I',\n\t\tJ : 'tt|i|b|u|s|strike',\n\t\tI : 'big|small|font|basefont',\n\t\tH : 'G|F',\n\t\tG : 'br|span|bdo',\n\t\tF : 'object|applet|img|map|iframe',\n\t\tE : 'A|B|C',\n\t\tD : 'accesskey|tabindex|onfocus|onblur',\n\t\tC : 'onclick|ondblclick|onmousedown|onmouseup|onmouseover|onmousemove|onmouseout|onkeypress|onkeydown|onkeyup',\n\t\tB : 'lang|xml:lang|dir',\n\t\tA : 'id|class|style|title'\n\t}, 'script[id|charset|type|language|src|defer|xml:space][]' +\n\t\t'style[B|id|type|media|title|xml:space][]' +\n\t\t'object[E|declare|classid|codebase|data|type|codetype|archive|standby|width|height|usemap|name|tabindex|align|border|hspace|vspace][#|param|Y]' +\n\t\t'param[id|name|value|valuetype|type][]' +\n\t\t'p[E|align][#|S]' +\n\t\t'a[E|D|charset|type|name|href|hreflang|rel|rev|shape|coords|target][#|Z]' +\n\t\t'br[A|clear][]' +\n\t\t'span[E][#|S]' +\n\t\t'bdo[A|C|B][#|S]' +\n\t\t'applet[A|codebase|archive|code|object|alt|name|width|height|align|hspace|vspace][#|param|Y]' +\n\t\t'h1[E|align][#|S]' +\n\t\t'img[E|src|alt|name|longdesc|width|height|usemap|ismap|align|border|hspace|vspace][]' +\n\t\t'map[B|C|A|name][X|form|Q|area]' +\n\t\t'h2[E|align][#|S]' +\n\t\t'iframe[A|longdesc|name|src|frameborder|marginwidth|marginheight|scrolling|align|width|height][#|Y]' +\n\t\t'h3[E|align][#|S]' +\n\t\t'tt[E][#|S]' +\n\t\t'i[E][#|S]' +\n\t\t'b[E][#|S]' +\n\t\t'u[E][#|S]' +\n\t\t's[E][#|S]' +\n\t\t'strike[E][#|S]' +\n\t\t'big[E][#|S]' +\n\t\t'small[E][#|S]' +\n\t\t'font[A|B|size|color|face][#|S]' +\n\t\t'basefont[id|size|color|face][]' +\n\t\t'em[E][#|S]' +\n\t\t'strong[E][#|S]' +\n\t\t'dfn[E][#|S]' +\n\t\t'code[E][#|S]' +\n\t\t'q[E|cite][#|S]' +\n\t\t'samp[E][#|S]' +\n\t\t'kbd[E][#|S]' +\n\t\t'var[E][#|S]' +\n\t\t'cite[E][#|S]' +\n\t\t'abbr[E][#|S]' +\n\t\t'acronym[E][#|S]' +\n\t\t'sub[E][#|S]' +\n\t\t'sup[E][#|S]' +\n\t\t'input[E|D|type|name|value|checked|disabled|readonly|size|maxlength|src|alt|usemap|onselect|onchange|accept|align][]' +\n\t\t'select[E|name|size|multiple|disabled|tabindex|onfocus|onblur|onchange][optgroup|option]' +\n\t\t'optgroup[E|disabled|label][option]' +\n\t\t'option[E|selected|disabled|label|value][]' +\n\t\t'textarea[E|D|name|rows|cols|disabled|readonly|onselect|onchange][]' +\n\t\t'label[E|for|accesskey|onfocus|onblur][#|S]' +\n\t\t'button[E|D|name|value|type|disabled][#|p|T|div|U|W|table|G|object|applet|img|map|K|N|Q]' +\n\t\t'h4[E|align][#|S]' +\n\t\t'ins[E|cite|datetime][#|Y]' +\n\t\t'h5[E|align][#|S]' +\n\t\t'del[E|cite|datetime][#|Y]' +\n\t\t'h6[E|align][#|S]' +\n\t\t'div[E|align][#|Y]' +\n\t\t'ul[E|type|compact][li]' +\n\t\t'li[E|type|value][#|Y]' +\n\t\t'ol[E|type|compact|start][li]' +\n\t\t'dl[E|compact][dt|dd]' +\n\t\t'dt[E][#|S]' +\n\t\t'dd[E][#|Y]' +\n\t\t'menu[E|compact][li]' +\n\t\t'dir[E|compact][li]' +\n\t\t'pre[E|width|xml:space][#|ZA]' +\n\t\t'hr[E|align|noshade|size|width][]' +\n\t\t'blockquote[E|cite][#|Y]' +\n\t\t'address[E][#|S|p]' +\n\t\t'center[E][#|Y]' +\n\t\t'noframes[E][#|Y]' +\n\t\t'isindex[A|B|prompt][]' +\n\t\t'fieldset[E][#|legend|Y]' +\n\t\t'legend[E|accesskey|align][#|S]' +\n\t\t'table[E|summary|width|border|frame|rules|cellspacing|cellpadding|align|bgcolor][caption|col|colgroup|thead|tfoot|tbody|tr]' +\n\t\t'caption[E|align][#|S]' +\n\t\t'col[ZG][]' +\n\t\t'colgroup[ZG][col]' +\n\t\t'thead[ZF][tr]' +\n\t\t'tr[ZF|bgcolor][th|td]' +\n\t\t'th[E|ZE][#|Y]' +\n\t\t'form[E|action|method|name|enctype|onsubmit|onreset|accept|accept-charset|target][#|X|R|Q]' +\n\t\t'noscript[E][#|Y]' +\n\t\t'td[E|ZE][#|Y]' +\n\t\t'tfoot[ZF][tr]' +\n\t\t'tbody[ZF][tr]' +\n\t\t'area[E|D|shape|coords|href|nohref|alt|target][]' +\n\t\t'base[id|href|target][]' +\n\t\t'body[E|onload|onunload|background|bgcolor|text|link|vlink|alink][#|Y]'\n\t);\n\n\tboolAttrMap = makeMap('checked,compact,declare,defer,disabled,ismap,multiple,nohref,noresize,noshade,nowrap,readonly,selected,autoplay,loop,controls');\n\tshortEndedElementsMap = makeMap('area,base,basefont,br,col,frame,hr,img,input,isindex,link,meta,param,embed,source');\n\tnonEmptyElementsMap = tinymce.extend(makeMap('td,th,iframe,video,audio,object'), shortEndedElementsMap);\n\tdefaultWhiteSpaceElementsMap = makeMap('pre,script,style,textarea');\n\tselfClosingElementsMap = makeMap('colgroup,dd,dt,li,options,p,td,tfoot,th,thead,tr');\n\n\ttinymce.html.Schema = function(settings) {\n\t\tvar self = this, elements = {}, children = {}, patternElements = [], validStyles, whiteSpaceElementsMap;\n\n\t\tsettings = settings || {};\n\n\t\t// Allow all elements and attributes if verify_html is set to false\n\t\tif (settings.verify_html === false)\n\t\t\tsettings.valid_elements = '*[*]';\n\n\t\t// Build styles list\n\t\tif (settings.valid_styles) {\n\t\t\tvalidStyles = {};\n\n\t\t\t// Convert styles into a rule list\n\t\t\teach(settings.valid_styles, function(value, key) {\n\t\t\t\tvalidStyles[key] = tinymce.explode(value);\n\t\t\t});\n\t\t}\n\n\t\twhiteSpaceElementsMap = settings.whitespace_elements ? makeMap(settings.whitespace_elements) : defaultWhiteSpaceElementsMap;\n\n\t\t// Converts a wildcard expression string to a regexp for example *a will become /.*a/.\n\t\tfunction patternToRegExp(str) {\n\t\t\treturn new RegExp('^' + str.replace(/([?+*])/g, '.$1') + '$');\n\t\t};\n\n\t\t// Parses the specified valid_elements string and adds to the current rules\n\t\t// This function is a bit hard to read since it's heavily optimized for speed\n\t\tfunction addValidElements(valid_elements) {\n\t\t\tvar ei, el, ai, al, yl, matches, element, attr, attrData, elementName, attrName, attrType, attributes, attributesOrder,\n\t\t\t\tprefix, outputName, globalAttributes, globalAttributesOrder, transElement, key, childKey, value,\n\t\t\t\telementRuleRegExp = /^([#+-])?([^\\[\\/]+)(?:\\/([^\\[]+))?(?:\\[([^\\]]+)\\])?$/,\n\t\t\t\tattrRuleRegExp = /^([!\\-])?(\\w+::\\w+|[^=:<]+)?(?:([=:<])(.*))?$/,\n\t\t\t\thasPatternsRegExp = /[*?+]/;\n\n\t\t\tif (valid_elements) {\n\t\t\t\t// Split valid elements into an array with rules\n\t\t\t\tvalid_elements = split(valid_elements);\n\n\t\t\t\tif (elements['@']) {\n\t\t\t\t\tglobalAttributes = elements['@'].attributes;\n\t\t\t\t\tglobalAttributesOrder = elements['@'].attributesOrder;\n\t\t\t\t}\n\n\t\t\t\t// Loop all rules\n\t\t\t\tfor (ei = 0, el = valid_elements.length; ei < el; ei++) {\n\t\t\t\t\t// Parse element rule\n\t\t\t\t\tmatches = elementRuleRegExp.exec(valid_elements[ei]);\n\t\t\t\t\tif (matches) {\n\t\t\t\t\t\t// Setup local names for matches\n\t\t\t\t\t\tprefix = matches[1];\n\t\t\t\t\t\telementName = matches[2];\n\t\t\t\t\t\toutputName = matches[3];\n\t\t\t\t\t\tattrData = matches[4];\n\n\t\t\t\t\t\t// Create new attributes and attributesOrder\n\t\t\t\t\t\tattributes = {};\n\t\t\t\t\t\tattributesOrder = [];\n\n\t\t\t\t\t\t// Create the new element\n\t\t\t\t\t\telement = {\n\t\t\t\t\t\t\tattributes : attributes,\n\t\t\t\t\t\t\tattributesOrder : attributesOrder\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\t// Padd empty elements prefix\n\t\t\t\t\t\tif (prefix === '#')\n\t\t\t\t\t\t\telement.paddEmpty = true;\n\n\t\t\t\t\t\t// Remove empty elements prefix\n\t\t\t\t\t\tif (prefix === '-')\n\t\t\t\t\t\t\telement.removeEmpty = true;\n\n\t\t\t\t\t\t// Copy attributes from global rule into current rule\n\t\t\t\t\t\tif (globalAttributes) {\n\t\t\t\t\t\t\tfor (key in globalAttributes)\n\t\t\t\t\t\t\t\tattributes[key] = globalAttributes[key];\n\n\t\t\t\t\t\t\tattributesOrder.push.apply(attributesOrder, globalAttributesOrder);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Attributes defined\n\t\t\t\t\t\tif (attrData) {\n\t\t\t\t\t\t\tattrData = split(attrData, '|');\n\t\t\t\t\t\t\tfor (ai = 0, al = attrData.length; ai < al; ai++) {\n\t\t\t\t\t\t\t\tmatches = attrRuleRegExp.exec(attrData[ai]);\n\t\t\t\t\t\t\t\tif (matches) {\n\t\t\t\t\t\t\t\t\tattr = {};\n\t\t\t\t\t\t\t\t\tattrType = matches[1];\n\t\t\t\t\t\t\t\t\tattrName = matches[2].replace(/::/g, ':');\n\t\t\t\t\t\t\t\t\tprefix = matches[3];\n\t\t\t\t\t\t\t\t\tvalue = matches[4];\n\n\t\t\t\t\t\t\t\t\t// Required\n\t\t\t\t\t\t\t\t\tif (attrType === '!') {\n\t\t\t\t\t\t\t\t\t\telement.attributesRequired = element.attributesRequired || [];\n\t\t\t\t\t\t\t\t\t\telement.attributesRequired.push(attrName);\n\t\t\t\t\t\t\t\t\t\tattr.required = true;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Denied from global\n\t\t\t\t\t\t\t\t\tif (attrType === '-') {\n\t\t\t\t\t\t\t\t\t\tdelete attributes[attrName];\n\t\t\t\t\t\t\t\t\t\tattributesOrder.splice(tinymce.inArray(attributesOrder, attrName), 1);\n\t\t\t\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Default value\n\t\t\t\t\t\t\t\t\tif (prefix) {\n\t\t\t\t\t\t\t\t\t\t// Default value\n\t\t\t\t\t\t\t\t\t\tif (prefix === '=') {\n\t\t\t\t\t\t\t\t\t\t\telement.attributesDefault = element.attributesDefault || [];\n\t\t\t\t\t\t\t\t\t\t\telement.attributesDefault.push({name: attrName, value: value});\n\t\t\t\t\t\t\t\t\t\t\tattr.defaultValue = value;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// Forced value\n\t\t\t\t\t\t\t\t\t\tif (prefix === ':') {\n\t\t\t\t\t\t\t\t\t\t\telement.attributesForced = element.attributesForced || [];\n\t\t\t\t\t\t\t\t\t\t\telement.attributesForced.push({name: attrName, value: value});\n\t\t\t\t\t\t\t\t\t\t\tattr.forcedValue = value;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// Required values\n\t\t\t\t\t\t\t\t\t\tif (prefix === '<')\n\t\t\t\t\t\t\t\t\t\t\tattr.validValues = makeMap(value, '?');\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Check for attribute patterns\n\t\t\t\t\t\t\t\t\tif (hasPatternsRegExp.test(attrName)) {\n\t\t\t\t\t\t\t\t\t\telement.attributePatterns = element.attributePatterns || [];\n\t\t\t\t\t\t\t\t\t\tattr.pattern = patternToRegExp(attrName);\n\t\t\t\t\t\t\t\t\t\telement.attributePatterns.push(attr);\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\t// Add attribute to order list if it doesn't already exist\n\t\t\t\t\t\t\t\t\t\tif (!attributes[attrName])\n\t\t\t\t\t\t\t\t\t\t\tattributesOrder.push(attrName);\n\n\t\t\t\t\t\t\t\t\t\tattributes[attrName] = attr;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Global rule, store away these for later usage\n\t\t\t\t\t\tif (!globalAttributes && elementName == '@') {\n\t\t\t\t\t\t\tglobalAttributes = attributes;\n\t\t\t\t\t\t\tglobalAttributesOrder = attributesOrder;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Handle substitute elements such as b/strong\n\t\t\t\t\t\tif (outputName) {\n\t\t\t\t\t\t\telement.outputName = elementName;\n\t\t\t\t\t\t\telements[outputName] = element;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Add pattern or exact element\n\t\t\t\t\t\tif (hasPatternsRegExp.test(elementName)) {\n\t\t\t\t\t\t\telement.pattern = patternToRegExp(elementName);\n\t\t\t\t\t\t\tpatternElements.push(element);\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\telements[elementName] = element;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction setValidElements(valid_elements) {\n\t\t\telements = {};\n\t\t\tpatternElements = [];\n\n\t\t\taddValidElements(valid_elements);\n\n\t\t\teach(transitional, function(element, name) {\n\t\t\t\tchildren[name] = element.children;\n\t\t\t});\n\t\t};\n\n\t\t// Adds custom non HTML elements to the schema\n\t\tfunction addCustomElements(custom_elements) {\n\t\t\tvar customElementRegExp = /^(~)?(.+)$/;\n\n\t\t\tif (custom_elements) {\n\t\t\t\teach(split(custom_elements), function(rule) {\n\t\t\t\t\tvar matches = customElementRegExp.exec(rule),\n\t\t\t\t\t\tinline = matches[1] === '~',\n\t\t\t\t\t\tcloneName = inline ? 'span' : 'div',\n\t\t\t\t\t\tname = matches[2];\n\n\t\t\t\t\tchildren[name] = children[cloneName];\n\t\t\t\t\tcustomElementsMap[name] = cloneName;\n\n\t\t\t\t\t// If it's not marked as inline then add it to valid block elements\n\t\t\t\t\tif (!inline)\n\t\t\t\t\t\tblockElementsMap[name] = {};\n\n\t\t\t\t\t// Add custom elements at span/div positions\n\t\t\t\t\teach(children, function(element, child) {\n\t\t\t\t\t\tif (element[cloneName])\n\t\t\t\t\t\t\telement[name] = element[cloneName];\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\t// Adds valid children to the schema object\n\t\tfunction addValidChildren(valid_children) {\n\t\t\tvar childRuleRegExp = /^([+\\-]?)(\\w+)\\[([^\\]]+)\\]$/;\n\n\t\t\tif (valid_children) {\n\t\t\t\teach(split(valid_children), function(rule) {\n\t\t\t\t\tvar matches = childRuleRegExp.exec(rule), parent, prefix;\n\n\t\t\t\t\tif (matches) {\n\t\t\t\t\t\tprefix = matches[1];\n\n\t\t\t\t\t\t// Add/remove items from default\n\t\t\t\t\t\tif (prefix)\n\t\t\t\t\t\t\tparent = children[matches[2]];\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tparent = children[matches[2]] = {'#comment' : {}};\n\n\t\t\t\t\t\tparent = children[matches[2]];\n\n\t\t\t\t\t\teach(split(matches[3], '|'), function(child) {\n\t\t\t\t\t\t\tif (prefix === '-')\n\t\t\t\t\t\t\t\tdelete parent[child];\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tparent[child] = {};\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\tfunction getElementRule(name) {\n\t\t\tvar element = elements[name], i;\n\n\t\t\t// Exact match found\n\t\t\tif (element)\n\t\t\t\treturn element;\n\n\t\t\t// No exact match then try the patterns\n\t\t\ti = patternElements.length;\n\t\t\twhile (i--) {\n\t\t\t\telement = patternElements[i];\n\n\t\t\t\tif (element.pattern.test(name))\n\t\t\t\t\treturn element;\n\t\t\t}\n\t\t};\n\n\t\tif (!settings.valid_elements) {\n\t\t\t// No valid elements defined then clone the elements from the transitional spec\n\t\t\teach(transitional, function(element, name) {\n\t\t\t\telements[name] = {\n\t\t\t\t\tattributes : element.attributes,\n\t\t\t\t\tattributesOrder : element.attributesOrder\n\t\t\t\t};\n\n\t\t\t\tchildren[name] = element.children;\n\t\t\t});\n\n\t\t\t// Switch these\n\t\t\teach(split('strong/b,em/i'), function(item) {\n\t\t\t\titem = split(item, '/');\n\t\t\t\telements[item[1]].outputName = item[0];\n\t\t\t});\n\n\t\t\t// Add default alt attribute for images\n\t\t\telements.img.attributesDefault = [{name: 'alt', value: ''}];\n\n\t\t\t// Remove these if they are empty by default\n\t\t\teach(split('ol,ul,sub,sup,blockquote,span,font,a,table,tbody,tr'), function(name) {\n\t\t\t\telements[name].removeEmpty = true;\n\t\t\t});\n\n\t\t\t// Padd these by default\n\t\t\teach(split('p,h1,h2,h3,h4,h5,h6,th,td,pre,div,address,caption'), function(name) {\n\t\t\t\telements[name].paddEmpty = true;\n\t\t\t});\n\t\t} else\n\t\t\tsetValidElements(settings.valid_elements);\n\n\t\taddCustomElements(settings.custom_elements);\n\t\taddValidChildren(settings.valid_children);\n\t\taddValidElements(settings.extended_valid_elements);\n\n\t\t// Todo: Remove this when we fix list handling to be valid\n\t\taddValidChildren('+ol[ul|ol],+ul[ul|ol]');\n\n\t\t// If the user didn't allow span only allow internal spans\n\t\tif (!getElementRule('span'))\n\t\t\taddValidElements('span[!data-mce-type|*]');\n\n\t\t// Delete invalid elements\n\t\tif (settings.invalid_elements) {\n\t\t\ttinymce.each(tinymce.explode(settings.invalid_elements), function(item) {\n\t\t\t\tif (elements[item])\n\t\t\t\t\tdelete elements[item];\n\t\t\t});\n\t\t}\n\n\t\tself.children = children;\n\n\t\tself.styles = validStyles;\n\n\t\tself.getBoolAttrs = function() {\n\t\t\treturn boolAttrMap;\n\t\t};\n\n\t\tself.getBlockElements = function() {\n\t\t\treturn blockElementsMap;\n\t\t};\n\n\t\tself.getShortEndedElements = function() {\n\t\t\treturn shortEndedElementsMap;\n\t\t};\n\n\t\tself.getSelfClosingElements = function() {\n\t\t\treturn selfClosingElementsMap;\n\t\t};\n\n\t\tself.getNonEmptyElements = function() {\n\t\t\treturn nonEmptyElementsMap;\n\t\t};\n\n\t\tself.getWhiteSpaceElements = function() {\n\t\t\treturn whiteSpaceElementsMap;\n\t\t};\n\n\t\tself.isValidChild = function(name, child) {\n\t\t\tvar parent = children[name];\n\n\t\t\treturn !!(parent && parent[child]);\n\t\t};\n\n\t\tself.getElementRule = getElementRule;\n\n\t\tself.getCustomElements = function() {\n\t\t\treturn customElementsMap;\n\t\t};\n\n\t\tself.addValidElements = addValidElements;\n\n\t\tself.setValidElements = setValidElements;\n\n\t\tself.addCustomElements = addCustomElements;\n\n\t\tself.addValidChildren = addValidChildren;\n\t};\n\n\t// Expose boolMap and blockElementMap as static properties for usage in DOMUtils\n\ttinymce.html.Schema.boolAttrMap = boolAttrMap;\n\ttinymce.html.Schema.blockElementsMap = blockElementsMap;\n})(tinymce);\n\n(function(tinymce) {\n\ttinymce.html.SaxParser = function(settings, schema) {\n\t\tvar self = this, noop = function() {};\n\n\t\tsettings = settings || {};\n\t\tself.schema = schema = schema || new tinymce.html.Schema();\n\n\t\tif (settings.fix_self_closing !== false)\n\t\t\tsettings.fix_self_closing = true;\n\n\t\t// Add handler functions from settings and setup default handlers\n\t\ttinymce.each('comment cdata text start end pi doctype'.split(' '), function(name) {\n\t\t\tif (name)\n\t\t\t\tself[name] = settings[name] || noop;\n\t\t});\n\n\t\tself.parse = function(html) {\n\t\t\tvar self = this, matches, index = 0, value, endRegExp, stack = [], attrList, i, text, name, isInternalElement, removeInternalElements,\n\t\t\t\tshortEndedElements, fillAttrsMap, isShortEnded, validate, elementRule, isValidElement, attr, attribsValue, invalidPrefixRegExp,\n\t\t\t\tvalidAttributesMap, validAttributePatterns, attributesRequired, attributesDefault, attributesForced, selfClosing,\n\t\t\t\ttokenRegExp, attrRegExp, specialElements, attrValue, idCount = 0, decode = tinymce.html.Entities.decode, fixSelfClosing, isIE;\n\n\t\t\tfunction processEndTag(name) {\n\t\t\t\tvar pos, i;\n\n\t\t\t\t// Find position of parent of the same type\n\t\t\t\tpos = stack.length;\n\t\t\t\twhile (pos--) {\n\t\t\t\t\tif (stack[pos].name === name)\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\t// Found parent\n\t\t\t\tif (pos >= 0) {\n\t\t\t\t\t// Close all the open elements\n\t\t\t\t\tfor (i = stack.length - 1; i >= pos; i--) {\n\t\t\t\t\t\tname = stack[i];\n\n\t\t\t\t\t\tif (name.valid)\n\t\t\t\t\t\t\tself.end(name.name);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove the open elements from the stack\n\t\t\t\t\tstack.length = pos;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Precompile RegExps and map objects\n\t\t\ttokenRegExp = new RegExp('<(?:' +\n\t\t\t\t'(?:!--([\\\\w\\\\W]*?)-->)|' + // Comment\n\t\t\t\t'(?:!\\\\[CDATA\\\\[([\\\\w\\\\W]*?)\\\\]\\\\]>)|' + // CDATA\n\t\t\t\t'(?:!DOCTYPE([\\\\w\\\\W]*?)>)|' + // DOCTYPE\n\t\t\t\t'(?:\\\\?([^\\\\s\\\\/<>]+) ?([\\\\w\\\\W]*?)[?/]>)|' + // PI\n\t\t\t\t'(?:\\\\/([^>]+)>)|' + // End element\n\t\t\t\t'(?:([^\\\\s\\\\/<>]+)((?:\\\\s+[^\"\\'>]+(?:(?:\"[^\"]*\")|(?:\\'[^\\']*\\')|[^>]*))*|\\\\/)>)' + // Start element\n\t\t\t')', 'g');\n\n\t\t\tattrRegExp = /([\\w:\\-]+)(?:\\s*=\\s*(?:(?:\\\"((?:\\\\.|[^\\\"])*)\\\")|(?:\\'((?:\\\\.|[^\\'])*)\\')|([^>\\s]+)))?/g;\n\t\t\tspecialElements = {\n\t\t\t\t'script' : /<\\/script[^>]*>/gi,\n\t\t\t\t'style' : /<\\/style[^>]*>/gi,\n\t\t\t\t'noscript' : /<\\/noscript[^>]*>/gi\n\t\t\t};\n\n\t\t\t// Setup lookup tables for empty elements and boolean attributes\n\t\t\tshortEndedElements = schema.getShortEndedElements();\n\t\t\tselfClosing = schema.getSelfClosingElements();\n\t\t\tfillAttrsMap = schema.getBoolAttrs();\n\t\t\tvalidate = settings.validate;\n\t\t\tremoveInternalElements = settings.remove_internals;\n\t\t\tfixSelfClosing = settings.fix_self_closing;\n\t\t\tisIE = tinymce.isIE;\n\t\t\tinvalidPrefixRegExp = /^:/;\n\n\t\t\twhile (matches = tokenRegExp.exec(html)) {\n\t\t\t\t// Text\n\t\t\t\tif (index < matches.index)\n\t\t\t\t\tself.text(decode(html.substr(index, matches.index - index)));\n\n\t\t\t\tif (value = matches[6]) { // End element\n\t\t\t\t\tvalue = value.toLowerCase();\n\n\t\t\t\t\t// IE will add a \":\" in front of elements it doesn't understand like custom elements or HTML5 elements\n\t\t\t\t\tif (isIE && invalidPrefixRegExp.test(value))\n\t\t\t\t\t\tvalue = value.substr(1);\n\n\t\t\t\t\tprocessEndTag(value);\n\t\t\t\t} else if (value = matches[7]) { // Start element\n\t\t\t\t\tvalue = value.toLowerCase();\n\n\t\t\t\t\t// IE will add a \":\" in front of elements it doesn't understand like custom elements or HTML5 elements\n\t\t\t\t\tif (isIE && invalidPrefixRegExp.test(value))\n\t\t\t\t\t\tvalue = value.substr(1);\n\n\t\t\t\t\tisShortEnded = value in shortEndedElements;\n\n\t\t\t\t\t// Is self closing tag for example an <li> after an open <li>\n\t\t\t\t\tif (fixSelfClosing && selfClosing[value] && stack.length > 0 && stack[stack.length - 1].name === value)\n\t\t\t\t\t\tprocessEndTag(value);\n\n\t\t\t\t\t// Validate element\n\t\t\t\t\tif (!validate || (elementRule = schema.getElementRule(value))) {\n\t\t\t\t\t\tisValidElement = true;\n\n\t\t\t\t\t\t// Grab attributes map and patters when validation is enabled\n\t\t\t\t\t\tif (validate) {\n\t\t\t\t\t\t\tvalidAttributesMap = elementRule.attributes;\n\t\t\t\t\t\t\tvalidAttributePatterns = elementRule.attributePatterns;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Parse attributes\n\t\t\t\t\t\tif (attribsValue = matches[8]) {\n\t\t\t\t\t\t\tisInternalElement = attribsValue.indexOf('data-mce-type') !== -1; // Check if the element is an internal element\n\n\t\t\t\t\t\t\t// If the element has internal attributes then remove it if we are told to do so\n\t\t\t\t\t\t\tif (isInternalElement && removeInternalElements)\n\t\t\t\t\t\t\t\tisValidElement = false;\n\n\t\t\t\t\t\t\tattrList = [];\n\t\t\t\t\t\t\tattrList.map = {};\n\n\t\t\t\t\t\t\tattribsValue.replace(attrRegExp, function(match, name, value, val2, val3) {\n\t\t\t\t\t\t\t\tvar attrRule, i;\n\n\t\t\t\t\t\t\t\tname = name.toLowerCase();\n\t\t\t\t\t\t\t\tvalue = name in fillAttrsMap ? name : decode(value || val2 || val3 || ''); // Handle boolean attribute than value attribute\n\n\t\t\t\t\t\t\t\t// Validate name and value\n\t\t\t\t\t\t\t\tif (validate && !isInternalElement && name.indexOf('data-') !== 0) {\n\t\t\t\t\t\t\t\t\tattrRule = validAttributesMap[name];\n\n\t\t\t\t\t\t\t\t\t// Find rule by pattern matching\n\t\t\t\t\t\t\t\t\tif (!attrRule && validAttributePatterns) {\n\t\t\t\t\t\t\t\t\t\ti = validAttributePatterns.length;\n\t\t\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\t\t\tattrRule = validAttributePatterns[i];\n\t\t\t\t\t\t\t\t\t\t\tif (attrRule.pattern.test(name))\n\t\t\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// No rule matched\n\t\t\t\t\t\t\t\t\t\tif (i === -1)\n\t\t\t\t\t\t\t\t\t\t\tattrRule = null;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// No attribute rule found\n\t\t\t\t\t\t\t\t\tif (!attrRule)\n\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t// Validate value\n\t\t\t\t\t\t\t\t\tif (attrRule.validValues && !(value in attrRule.validValues))\n\t\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Add attribute to list and map\n\t\t\t\t\t\t\t\tattrList.map[name] = value;\n\t\t\t\t\t\t\t\tattrList.push({\n\t\t\t\t\t\t\t\t\tname: name,\n\t\t\t\t\t\t\t\t\tvalue: value\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tattrList = [];\n\t\t\t\t\t\t\tattrList.map = {};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Process attributes if validation is enabled\n\t\t\t\t\t\tif (validate && !isInternalElement) {\n\t\t\t\t\t\t\tattributesRequired = elementRule.attributesRequired;\n\t\t\t\t\t\t\tattributesDefault = elementRule.attributesDefault;\n\t\t\t\t\t\t\tattributesForced = elementRule.attributesForced;\n\n\t\t\t\t\t\t\t// Handle forced attributes\n\t\t\t\t\t\t\tif (attributesForced) {\n\t\t\t\t\t\t\t\ti = attributesForced.length;\n\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\tattr = attributesForced[i];\n\t\t\t\t\t\t\t\t\tname = attr.name;\n\t\t\t\t\t\t\t\t\tattrValue = attr.value;\n\n\t\t\t\t\t\t\t\t\tif (attrValue === '{$uid}')\n\t\t\t\t\t\t\t\t\t\tattrValue = 'mce_' + idCount++;\n\n\t\t\t\t\t\t\t\t\tattrList.map[name] = attrValue;\n\t\t\t\t\t\t\t\t\tattrList.push({name: name, value: attrValue});\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Handle default attributes\n\t\t\t\t\t\t\tif (attributesDefault) {\n\t\t\t\t\t\t\t\ti = attributesDefault.length;\n\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\tattr = attributesDefault[i];\n\t\t\t\t\t\t\t\t\tname = attr.name;\n\n\t\t\t\t\t\t\t\t\tif (!(name in attrList.map)) {\n\t\t\t\t\t\t\t\t\t\tattrValue = attr.value;\n\n\t\t\t\t\t\t\t\t\t\tif (attrValue === '{$uid}')\n\t\t\t\t\t\t\t\t\t\t\tattrValue = 'mce_' + idCount++;\n\n\t\t\t\t\t\t\t\t\t\tattrList.map[name] = attrValue;\n\t\t\t\t\t\t\t\t\t\tattrList.push({name: name, value: attrValue});\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Handle required attributes\n\t\t\t\t\t\t\tif (attributesRequired) {\n\t\t\t\t\t\t\t\ti = attributesRequired.length;\n\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\tif (attributesRequired[i] in attrList.map)\n\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// None of the required attributes where found\n\t\t\t\t\t\t\t\tif (i === -1)\n\t\t\t\t\t\t\t\t\tisValidElement = false;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Invalidate element if it's marked as bogus\n\t\t\t\t\t\t\tif (attrList.map['data-mce-bogus'])\n\t\t\t\t\t\t\t\tisValidElement = false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (isValidElement)\n\t\t\t\t\t\t\tself.start(value, attrList, isShortEnded);\n\t\t\t\t\t} else\n\t\t\t\t\t\tisValidElement = false;\n\n\t\t\t\t\t// Treat script, noscript and style a bit different since they may include code that looks like elements\n\t\t\t\t\tif (endRegExp = specialElements[value]) {\n\t\t\t\t\t\tendRegExp.lastIndex = index = matches.index + matches[0].length;\n\n\t\t\t\t\t\tif (matches = endRegExp.exec(html)) {\n\t\t\t\t\t\t\tif (isValidElement)\n\t\t\t\t\t\t\t\ttext = html.substr(index, matches.index - index);\n\n\t\t\t\t\t\t\tindex = matches.index + matches[0].length;\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\ttext = html.substr(index);\n\t\t\t\t\t\t\tindex = html.length;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (isValidElement && text.length > 0)\n\t\t\t\t\t\t\tself.text(text, true);\n\n\t\t\t\t\t\tif (isValidElement)\n\t\t\t\t\t\t\tself.end(value);\n\n\t\t\t\t\t\ttokenRegExp.lastIndex = index;\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Push value on to stack\n\t\t\t\t\tif (!isShortEnded) {\n\t\t\t\t\t\tif (!attribsValue || attribsValue.indexOf('/') != attribsValue.length - 1)\n\t\t\t\t\t\t\tstack.push({name: value, valid: isValidElement});\n\t\t\t\t\t\telse if (isValidElement)\n\t\t\t\t\t\t\tself.end(value);\n\t\t\t\t\t}\n\t\t\t\t} else if (value = matches[1]) { // Comment\n\t\t\t\t\tself.comment(value);\n\t\t\t\t} else if (value = matches[2]) { // CDATA\n\t\t\t\t\tself.cdata(value);\n\t\t\t\t} else if (value = matches[3]) { // DOCTYPE\n\t\t\t\t\tself.doctype(value);\n\t\t\t\t} else if (value = matches[4]) { // PI\n\t\t\t\t\tself.pi(value, matches[5]);\n\t\t\t\t}\n\n\t\t\t\tindex = matches.index + matches[0].length;\n\t\t\t}\n\n\t\t\t// Text\n\t\t\tif (index < html.length)\n\t\t\t\tself.text(decode(html.substr(index)));\n\n\t\t\t// Close any open elements\n\t\t\tfor (i = stack.length - 1; i >= 0; i--) {\n\t\t\t\tvalue = stack[i];\n\n\t\t\t\tif (value.valid)\n\t\t\t\t\tself.end(value.name);\n\t\t\t}\n\t\t};\n\t}\n})(tinymce);\n\n(function(tinymce) {\n\tvar whiteSpaceRegExp = /^[ \\t\\r\\n]*$/, typeLookup = {\n\t\t'#text' : 3,\n\t\t'#comment' : 8,\n\t\t'#cdata' : 4,\n\t\t'#pi' : 7,\n\t\t'#doctype' : 10,\n\t\t'#document-fragment' : 11\n\t};\n\n\t// Walks the tree left/right\n\tfunction walk(node, root_node, prev) {\n\t\tvar sibling, parent, startName = prev ? 'lastChild' : 'firstChild', siblingName = prev ? 'prev' : 'next';\n\n\t\t// Walk into nodes if it has a start\n\t\tif (node[startName])\n\t\t\treturn node[startName];\n\n\t\t// Return the sibling if it has one\n\t\tif (node !== root_node) {\n\t\t\tsibling = node[siblingName];\n\n\t\t\tif (sibling)\n\t\t\t\treturn sibling;\n\n\t\t\t// Walk up the parents to look for siblings\n\t\t\tfor (parent = node.parent; parent && parent !== root_node; parent = parent.parent) {\n\t\t\t\tsibling = parent[siblingName];\n\n\t\t\t\tif (sibling)\n\t\t\t\t\treturn sibling;\n\t\t\t}\n\t\t}\n\t};\n\n\tfunction Node(name, type) {\n\t\tthis.name = name;\n\t\tthis.type = type;\n\n\t\tif (type === 1) {\n\t\t\tthis.attributes = [];\n\t\t\tthis.attributes.map = {};\n\t\t}\n\t}\n\n\ttinymce.extend(Node.prototype, {\n\t\treplace : function(node) {\n\t\t\tvar self = this;\n\n\t\t\tif (node.parent)\n\t\t\t\tnode.remove();\n\n\t\t\tself.insert(node, self);\n\t\t\tself.remove();\n\n\t\t\treturn self;\n\t\t},\n\n\t\tattr : function(name, value) {\n\t\t\tvar self = this, attrs, i, undef;\n\n\t\t\tif (typeof name !== \"string\") {\n\t\t\t\tfor (i in name)\n\t\t\t\t\tself.attr(i, name[i]);\n\n\t\t\t\treturn self;\n\t\t\t}\n\n\t\t\tif (attrs = self.attributes) {\n\t\t\t\tif (value !== undef) {\n\t\t\t\t\t// Remove attribute\n\t\t\t\t\tif (value === null) {\n\t\t\t\t\t\tif (name in attrs.map) {\n\t\t\t\t\t\t\tdelete attrs.map[name];\n\n\t\t\t\t\t\t\ti = attrs.length;\n\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\tif (attrs[i].name === name) {\n\t\t\t\t\t\t\t\t\tattrs = attrs.splice(i, 1);\n\t\t\t\t\t\t\t\t\treturn self;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn self;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Set attribute\n\t\t\t\t\tif (name in attrs.map) {\n\t\t\t\t\t\t// Set attribute\n\t\t\t\t\t\ti = attrs.length;\n\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\tif (attrs[i].name === name) {\n\t\t\t\t\t\t\t\tattrs[i].value = value;\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t} else\n\t\t\t\t\t\tattrs.push({name: name, value: value});\n\n\t\t\t\t\tattrs.map[name] = value;\n\n\t\t\t\t\treturn self;\n\t\t\t\t} else {\n\t\t\t\t\treturn attrs.map[name];\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tclone : function() {\n\t\t\tvar self = this, clone = new Node(self.name, self.type), i, l, selfAttrs, selfAttr, cloneAttrs;\n\n\t\t\t// Clone element attributes\n\t\t\tif (selfAttrs = self.attributes) {\n\t\t\t\tcloneAttrs = [];\n\t\t\t\tcloneAttrs.map = {};\n\n\t\t\t\tfor (i = 0, l = selfAttrs.length; i < l; i++) {\n\t\t\t\t\tselfAttr = selfAttrs[i];\n\n\t\t\t\t\t// Clone everything except id\n\t\t\t\t\tif (selfAttr.name !== 'id') {\n\t\t\t\t\t\tcloneAttrs[cloneAttrs.length] = {name: selfAttr.name, value: selfAttr.value};\n\t\t\t\t\t\tcloneAttrs.map[selfAttr.name] = selfAttr.value;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tclone.attributes = cloneAttrs;\n\t\t\t}\n\n\t\t\tclone.value = self.value;\n\t\t\tclone.shortEnded = self.shortEnded;\n\n\t\t\treturn clone;\n\t\t},\n\n\t\twrap : function(wrapper) {\n\t\t\tvar self = this;\n\n\t\t\tself.parent.insert(wrapper, self);\n\t\t\twrapper.append(self);\n\n\t\t\treturn self;\n\t\t},\n\n\t\tunwrap : function() {\n\t\t\tvar self = this, node, next;\n\n\t\t\tfor (node = self.firstChild; node; ) {\n\t\t\t\tnext = node.next;\n\t\t\t\tself.insert(node, self, true);\n\t\t\t\tnode = next;\n\t\t\t}\n\n\t\t\tself.remove();\n\t\t},\n\n\t\tremove : function() {\n\t\t\tvar self = this, parent = self.parent, next = self.next, prev = self.prev;\n\n\t\t\tif (parent) {\n\t\t\t\tif (parent.firstChild === self) {\n\t\t\t\t\tparent.firstChild = next;\n\n\t\t\t\t\tif (next)\n\t\t\t\t\t\tnext.prev = null;\n\t\t\t\t} else {\n\t\t\t\t\tprev.next = next;\n\t\t\t\t}\n\n\t\t\t\tif (parent.lastChild === self) {\n\t\t\t\t\tparent.lastChild = prev;\n\n\t\t\t\t\tif (prev)\n\t\t\t\t\t\tprev.next = null;\n\t\t\t\t} else {\n\t\t\t\t\tnext.prev = prev;\n\t\t\t\t}\n\n\t\t\t\tself.parent = self.next = self.prev = null;\n\t\t\t}\n\n\t\t\treturn self;\n\t\t},\n\n\t\tappend : function(node) {\n\t\t\tvar self = this, last;\n\n\t\t\tif (node.parent)\n\t\t\t\tnode.remove();\n\n\t\t\tlast = self.lastChild;\n\t\t\tif (last) {\n\t\t\t\tlast.next = node;\n\t\t\t\tnode.prev = last;\n\t\t\t\tself.lastChild = node;\n\t\t\t} else\n\t\t\t\tself.lastChild = self.firstChild = node;\n\n\t\t\tnode.parent = self;\n\n\t\t\treturn node;\n\t\t},\n\n\t\tinsert : function(node, ref_node, before) {\n\t\t\tvar parent;\n\n\t\t\tif (node.parent)\n\t\t\t\tnode.remove();\n\n\t\t\tparent = ref_node.parent || this;\n\n\t\t\tif (before) {\n\t\t\t\tif (ref_node === parent.firstChild)\n\t\t\t\t\tparent.firstChild = node;\n\t\t\t\telse\n\t\t\t\t\tref_node.prev.next = node;\n\n\t\t\t\tnode.prev = ref_node.prev;\n\t\t\t\tnode.next = ref_node;\n\t\t\t\tref_node.prev = node;\n\t\t\t} else {\n\t\t\t\tif (ref_node === parent.lastChild)\n\t\t\t\t\tparent.lastChild = node;\n\t\t\t\telse\n\t\t\t\t\tref_node.next.prev = node;\n\n\t\t\t\tnode.next = ref_node.next;\n\t\t\t\tnode.prev = ref_node;\n\t\t\t\tref_node.next = node;\n\t\t\t}\n\n\t\t\tnode.parent = parent;\n\n\t\t\treturn node;\n\t\t},\n\n\t\tgetAll : function(name) {\n\t\t\tvar self = this, node, collection = [];\n\n\t\t\tfor (node = self.firstChild; node; node = walk(node, self)) {\n\t\t\t\tif (node.name === name)\n\t\t\t\t\tcollection.push(node);\n\t\t\t}\n\n\t\t\treturn collection;\n\t\t},\n\n\t\tempty : function() {\n\t\t\tvar self = this, nodes, i, node;\n\n\t\t\t// Remove all children\n\t\t\tif (self.firstChild) {\n\t\t\t\tnodes = [];\n\n\t\t\t\t// Collect the children\n\t\t\t\tfor (node = self.firstChild; node; node = walk(node, self))\n\t\t\t\t\tnodes.push(node);\n\n\t\t\t\t// Remove the children\n\t\t\t\ti = nodes.length;\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tnode.parent = node.firstChild = node.lastChild = node.next = node.prev = null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tself.firstChild = self.lastChild = null;\n\n\t\t\treturn self;\n\t\t},\n\n\t\tisEmpty : function(elements) {\n\t\t\tvar self = this, node = self.firstChild, i, name;\n\n\t\t\tif (node) {\n\t\t\t\tdo {\n\t\t\t\t\tif (node.type === 1) {\n\t\t\t\t\t\t// Ignore bogus elements\n\t\t\t\t\t\tif (node.attributes.map['data-mce-bogus'])\n\t\t\t\t\t\t\tcontinue;\n\n\t\t\t\t\t\t// Keep empty elements like <img />\n\t\t\t\t\t\tif (elements[node.name])\n\t\t\t\t\t\t\treturn false;\n\n\t\t\t\t\t\t// Keep elements with data attributes or name attribute like <a name=\"1\"></a>\n\t\t\t\t\t\ti = node.attributes.length;\n\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\tname = node.attributes[i].name;\n\t\t\t\t\t\t\tif (name === \"name\" || name.indexOf('data-') === 0)\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Keep non whitespace text nodes\n\t\t\t\t\tif ((node.type === 3 && !whiteSpaceRegExp.test(node.value)))\n\t\t\t\t\t\treturn false;\n\t\t\t\t} while (node = walk(node, self));\n\t\t\t}\n\n\t\t\treturn true;\n\t\t},\n\n\t\twalk : function(prev) {\n\t\t\treturn walk(this, null, prev);\n\t\t}\n\t});\n\n\ttinymce.extend(Node, {\n\t\tcreate : function(name, attrs) {\n\t\t\tvar node, attrName;\n\n\t\t\t// Create node\n\t\t\tnode = new Node(name, typeLookup[name] || 1);\n\n\t\t\t// Add attributes if needed\n\t\t\tif (attrs) {\n\t\t\t\tfor (attrName in attrs)\n\t\t\t\t\tnode.attr(attrName, attrs[attrName]);\n\t\t\t}\n\n\t\t\treturn node;\n\t\t}\n\t});\n\n\ttinymce.html.Node = Node;\n})(tinymce);\n\n(function(tinymce) {\n\tvar Node = tinymce.html.Node;\n\n\ttinymce.html.DomParser = function(settings, schema) {\n\t\tvar self = this, nodeFilters = {}, attributeFilters = [], matchedNodes = {}, matchedAttributes = {};\n\n\t\tsettings = settings || {};\n\t\tsettings.validate = \"validate\" in settings ? settings.validate : true;\n\t\tsettings.root_name = settings.root_name || 'body';\n\t\tself.schema = schema = schema || new tinymce.html.Schema();\n\n\t\tfunction fixInvalidChildren(nodes) {\n\t\t\tvar ni, node, parent, parents, newParent, currentNode, tempNode, childNode, i,\n\t\t\t\tchildClone, nonEmptyElements, nonSplitableElements, sibling, nextNode;\n\n\t\t\tnonSplitableElements = tinymce.makeMap('tr,td,th,tbody,thead,tfoot,table');\n\t\t\tnonEmptyElements = schema.getNonEmptyElements();\n\n\t\t\tfor (ni = 0; ni < nodes.length; ni++) {\n\t\t\t\tnode = nodes[ni];\n\n\t\t\t\t// Already removed\n\t\t\t\tif (!node.parent)\n\t\t\t\t\tcontinue;\n\n\t\t\t\t// Get list of all parent nodes until we find a valid parent to stick the child into\n\t\t\t\tparents = [node];\n\t\t\t\tfor (parent = node.parent; parent && !schema.isValidChild(parent.name, node.name) && !nonSplitableElements[parent.name]; parent = parent.parent)\n\t\t\t\t\tparents.push(parent);\n\n\t\t\t\t// Found a suitable parent\n\t\t\t\tif (parent && parents.length > 1) {\n\t\t\t\t\t// Reverse the array since it makes looping easier\n\t\t\t\t\tparents.reverse();\n\n\t\t\t\t\t// Clone the related parent and insert that after the moved node\n\t\t\t\t\tnewParent = currentNode = self.filterNode(parents[0].clone());\n\n\t\t\t\t\t// Start cloning and moving children on the left side of the target node\n\t\t\t\t\tfor (i = 0; i < parents.length - 1; i++) {\n\t\t\t\t\t\tif (schema.isValidChild(currentNode.name, parents[i].name)) {\n\t\t\t\t\t\t\ttempNode = self.filterNode(parents[i].clone());\n\t\t\t\t\t\t\tcurrentNode.append(tempNode);\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\ttempNode = currentNode;\n\n\t\t\t\t\t\tfor (childNode = parents[i].firstChild; childNode && childNode != parents[i + 1]; ) {\n\t\t\t\t\t\t\tnextNode = childNode.next;\n\t\t\t\t\t\t\ttempNode.append(childNode);\n\t\t\t\t\t\t\tchildNode = nextNode;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tcurrentNode = tempNode;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!newParent.isEmpty(nonEmptyElements)) {\n\t\t\t\t\t\tparent.insert(newParent, parents[0], true);\n\t\t\t\t\t\tparent.insert(node, newParent);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tparent.insert(node, parents[0], true);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Check if the element is empty by looking through it's contents and special treatment for <p><br /></p>\n\t\t\t\t\tparent = parents[0];\n\t\t\t\t\tif (parent.isEmpty(nonEmptyElements) || parent.firstChild === parent.lastChild && parent.firstChild.name === 'br') {\n\t\t\t\t\t\tparent.empty().remove();\n\t\t\t\t\t}\n\t\t\t\t} else if (node.parent) {\n\t\t\t\t\t// If it's an LI try to find a UL/OL for it or wrap it\n\t\t\t\t\tif (node.name === 'li') {\n\t\t\t\t\t\tsibling = node.prev;\n\t\t\t\t\t\tif (sibling && (sibling.name === 'ul' || sibling.name === 'ul')) {\n\t\t\t\t\t\t\tsibling.append(node);\n\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tsibling = node.next;\n\t\t\t\t\t\tif (sibling && (sibling.name === 'ul' || sibling.name === 'ul')) {\n\t\t\t\t\t\t\tsibling.insert(node, sibling.firstChild, true);\n\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tnode.wrap(self.filterNode(new Node('ul', 1)));\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Try wrapping the element in a DIV\n\t\t\t\t\tif (schema.isValidChild(node.parent.name, 'div') && schema.isValidChild('div', node.name)) {\n\t\t\t\t\t\tnode.wrap(self.filterNode(new Node('div', 1)));\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// We failed wrapping it, then remove or unwrap it\n\t\t\t\t\t\tif (node.name === 'style' || node.name === 'script')\n\t\t\t\t\t\t\tnode.empty().remove();\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tnode.unwrap();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tself.filterNode = function(node) {\n\t\t\tvar i, name, list;\n\n\t\t\t// Run element filters\n\t\t\tif (name in nodeFilters) {\n\t\t\t\tlist = matchedNodes[name];\n\n\t\t\t\tif (list)\n\t\t\t\t\tlist.push(node);\n\t\t\t\telse\n\t\t\t\t\tmatchedNodes[name] = [node];\n\t\t\t}\n\n\t\t\t// Run attribute filters\n\t\t\ti = attributeFilters.length;\n\t\t\twhile (i--) {\n\t\t\t\tname = attributeFilters[i].name;\n\n\t\t\t\tif (name in node.attributes.map) {\n\t\t\t\t\tlist = matchedAttributes[name];\n\n\t\t\t\t\tif (list)\n\t\t\t\t\t\tlist.push(node);\n\t\t\t\t\telse\n\t\t\t\t\t\tmatchedAttributes[name] = [node];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn node;\n\t\t};\n\n\t\tself.addNodeFilter = function(name, callback) {\n\t\t\ttinymce.each(tinymce.explode(name), function(name) {\n\t\t\t\tvar list = nodeFilters[name];\n\n\t\t\t\tif (!list)\n\t\t\t\t\tnodeFilters[name] = list = [];\n\n\t\t\t\tlist.push(callback);\n\t\t\t});\n\t\t};\n\n\t\tself.addAttributeFilter = function(name, callback) {\n\t\t\ttinymce.each(tinymce.explode(name), function(name) {\n\t\t\t\tvar i;\n\n\t\t\t\tfor (i = 0; i < attributeFilters.length; i++) {\n\t\t\t\t\tif (attributeFilters[i].name === name) {\n\t\t\t\t\t\tattributeFilters[i].callbacks.push(callback);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tattributeFilters.push({name: name, callbacks: [callback]});\n\t\t\t});\n\t\t};\n\n\t\tself.parse = function(html, args) {\n\t\t\tvar parser, rootNode, node, nodes, i, l, fi, fl, list, name, validate,\n\t\t\t\tblockElements, startWhiteSpaceRegExp, invalidChildren = [],\n\t\t\t\tendWhiteSpaceRegExp, allWhiteSpaceRegExp, whiteSpaceElements, children, nonEmptyElements, rootBlockName;\n\n\t\t\targs = args || {};\n\t\t\tmatchedNodes = {};\n\t\t\tmatchedAttributes = {};\n\t\t\tblockElements = tinymce.extend(tinymce.makeMap('script,style,head,html,body,title,meta,param'), schema.getBlockElements());\n\t\t\tnonEmptyElements = schema.getNonEmptyElements();\n\t\t\tchildren = schema.children;\n\t\t\tvalidate = settings.validate;\n\t\t\trootBlockName = \"forced_root_block\" in args ? args.forced_root_block : settings.forced_root_block;\n\n\t\t\twhiteSpaceElements = schema.getWhiteSpaceElements();\n\t\t\tstartWhiteSpaceRegExp = /^[ \\t\\r\\n]+/;\n\t\t\tendWhiteSpaceRegExp = /[ \\t\\r\\n]+$/;\n\t\t\tallWhiteSpaceRegExp = /[ \\t\\r\\n]+/g;\n\n\t\t\tfunction addRootBlocks() {\n\t\t\t\tvar node = rootNode.firstChild, next, rootBlockNode;\n\n\t\t\t\twhile (node) {\n\t\t\t\t\tnext = node.next;\n\n\t\t\t\t\tif (node.type == 3 || (node.type == 1 && node.name !== 'p' && !blockElements[node.name] && !node.attr('data-mce-type'))) {\n\t\t\t\t\t\tif (!rootBlockNode) {\n\t\t\t\t\t\t\t// Create a new root block element\n\t\t\t\t\t\t\trootBlockNode = createNode(rootBlockName, 1);\n\t\t\t\t\t\t\trootNode.insert(rootBlockNode, node);\n\t\t\t\t\t\t\trootBlockNode.append(node);\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\trootBlockNode.append(node);\n\t\t\t\t\t} else {\n\t\t\t\t\t\trootBlockNode = null;\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = next;\n\t\t\t\t};\n\t\t\t};\n\n\t\t\tfunction createNode(name, type) {\n\t\t\t\tvar node = new Node(name, type), list;\n\n\t\t\t\tif (name in nodeFilters) {\n\t\t\t\t\tlist = matchedNodes[name];\n\n\t\t\t\t\tif (list)\n\t\t\t\t\t\tlist.push(node);\n\t\t\t\t\telse\n\t\t\t\t\t\tmatchedNodes[name] = [node];\n\t\t\t\t}\n\n\t\t\t\treturn node;\n\t\t\t};\n\n\t\t\tfunction removeWhitespaceBefore(node) {\n\t\t\t\tvar textNode, textVal, sibling;\n\n\t\t\t\tfor (textNode = node.prev; textNode && textNode.type === 3; ) {\n\t\t\t\t\ttextVal = textNode.value.replace(endWhiteSpaceRegExp, '');\n\n\t\t\t\t\tif (textVal.length > 0) {\n\t\t\t\t\t\ttextNode.value = textVal;\n\t\t\t\t\t\ttextNode = textNode.prev;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tsibling = textNode.prev;\n\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\ttextNode = sibling;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tparser = new tinymce.html.SaxParser({\n\t\t\t\tvalidate : validate,\n\t\t\t\tfix_self_closing : !validate, // Let the DOM parser handle <li> in <li> or <p> in <p> for better results\n\n\t\t\t\tcdata: function(text) {\n\t\t\t\t\tnode.append(createNode('#cdata', 4)).value = text;\n\t\t\t\t},\n\n\t\t\t\ttext: function(text, raw) {\n\t\t\t\t\tvar textNode;\n\n\t\t\t\t\t// Trim all redundant whitespace on non white space elements\n\t\t\t\t\tif (!whiteSpaceElements[node.name]) {\n\t\t\t\t\t\ttext = text.replace(allWhiteSpaceRegExp, ' ');\n\n\t\t\t\t\t\tif (node.lastChild && blockElements[node.lastChild.name])\n\t\t\t\t\t\t\ttext = text.replace(startWhiteSpaceRegExp, '');\n\t\t\t\t\t}\n\n\t\t\t\t\t// Do we need to create the node\n\t\t\t\t\tif (text.length !== 0) {\n\t\t\t\t\t\ttextNode = createNode('#text', 3);\n\t\t\t\t\t\ttextNode.raw = !!raw;\n\t\t\t\t\t\tnode.append(textNode).value = text;\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tcomment: function(text) {\n\t\t\t\t\tnode.append(createNode('#comment', 8)).value = text;\n\t\t\t\t},\n\n\t\t\t\tpi: function(name, text) {\n\t\t\t\t\tnode.append(createNode(name, 7)).value = text;\n\t\t\t\t\tremoveWhitespaceBefore(node);\n\t\t\t\t},\n\n\t\t\t\tdoctype: function(text) {\n\t\t\t\t\tvar newNode;\n\n\t\t\t\t\tnewNode = node.append(createNode('#doctype', 10));\n\t\t\t\t\tnewNode.value = text;\n\t\t\t\t\tremoveWhitespaceBefore(node);\n\t\t\t\t},\n\n\t\t\t\tstart: function(name, attrs, empty) {\n\t\t\t\t\tvar newNode, attrFiltersLen, elementRule, textNode, attrName, text, sibling, parent;\n\n\t\t\t\t\telementRule = validate ? schema.getElementRule(name) : {};\n\t\t\t\t\tif (elementRule) {\n\t\t\t\t\t\tnewNode = createNode(elementRule.outputName || name, 1);\n\t\t\t\t\t\tnewNode.attributes = attrs;\n\t\t\t\t\t\tnewNode.shortEnded = empty;\n\n\t\t\t\t\t\tnode.append(newNode);\n\n\t\t\t\t\t\t// Check if node is valid child of the parent node is the child is\n\t\t\t\t\t\t// unknown we don't collect it since it's probably a custom element\n\t\t\t\t\t\tparent = children[node.name];\n\t\t\t\t\t\tif (parent && children[newNode.name] && !parent[newNode.name])\n\t\t\t\t\t\t\tinvalidChildren.push(newNode);\n\n\t\t\t\t\t\tattrFiltersLen = attributeFilters.length;\n\t\t\t\t\t\twhile (attrFiltersLen--) {\n\t\t\t\t\t\t\tattrName = attributeFilters[attrFiltersLen].name;\n\n\t\t\t\t\t\t\tif (attrName in attrs.map) {\n\t\t\t\t\t\t\t\tlist = matchedAttributes[attrName];\n\n\t\t\t\t\t\t\t\tif (list)\n\t\t\t\t\t\t\t\t\tlist.push(newNode);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\tmatchedAttributes[attrName] = [newNode];\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Trim whitespace before block\n\t\t\t\t\t\tif (blockElements[name])\n\t\t\t\t\t\t\tremoveWhitespaceBefore(newNode);\n\n\t\t\t\t\t\t// Change current node if the element wasn't empty i.e not <br /> or <img />\n\t\t\t\t\t\tif (!empty)\n\t\t\t\t\t\t\tnode = newNode;\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tend: function(name) {\n\t\t\t\t\tvar textNode, elementRule, text, sibling, tempNode;\n\n\t\t\t\t\telementRule = validate ? schema.getElementRule(name) : {};\n\t\t\t\t\tif (elementRule) {\n\t\t\t\t\t\tif (blockElements[name]) {\n\t\t\t\t\t\t\tif (!whiteSpaceElements[node.name]) {\n\t\t\t\t\t\t\t\t// Trim whitespace at beginning of block\n\t\t\t\t\t\t\t\tfor (textNode = node.firstChild; textNode && textNode.type === 3; ) {\n\t\t\t\t\t\t\t\t\ttext = textNode.value.replace(startWhiteSpaceRegExp, '');\n\n\t\t\t\t\t\t\t\t\tif (text.length > 0) {\n\t\t\t\t\t\t\t\t\t\ttextNode.value = text;\n\t\t\t\t\t\t\t\t\t\ttextNode = textNode.next;\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tsibling = textNode.next;\n\t\t\t\t\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\t\t\t\t\ttextNode = sibling;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Trim whitespace at end of block\n\t\t\t\t\t\t\t\tfor (textNode = node.lastChild; textNode && textNode.type === 3; ) {\n\t\t\t\t\t\t\t\t\ttext = textNode.value.replace(endWhiteSpaceRegExp, '');\n\n\t\t\t\t\t\t\t\t\tif (text.length > 0) {\n\t\t\t\t\t\t\t\t\t\ttextNode.value = text;\n\t\t\t\t\t\t\t\t\t\ttextNode = textNode.prev;\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tsibling = textNode.prev;\n\t\t\t\t\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\t\t\t\t\ttextNode = sibling;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Trim start white space\n\t\t\t\t\t\t\ttextNode = node.prev;\n\t\t\t\t\t\t\tif (textNode && textNode.type === 3) {\n\t\t\t\t\t\t\t\ttext = textNode.value.replace(startWhiteSpaceRegExp, '');\n\n\t\t\t\t\t\t\t\tif (text.length > 0)\n\t\t\t\t\t\t\t\t\ttextNode.value = text;\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Handle empty nodes\n\t\t\t\t\t\tif (elementRule.removeEmpty || elementRule.paddEmpty) {\n\t\t\t\t\t\t\tif (node.isEmpty(nonEmptyElements)) {\n\t\t\t\t\t\t\t\tif (elementRule.paddEmpty)\n\t\t\t\t\t\t\t\t\tnode.empty().append(new Node('#text', '3')).value = '\\u00a0';\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t// Leave nodes that have a name like <a name=\"name\">\n\t\t\t\t\t\t\t\t\tif (!node.attributes.map.name) {\n\t\t\t\t\t\t\t\t\t\ttempNode = node.parent;\n\t\t\t\t\t\t\t\t\t\tnode.empty().remove();\n\t\t\t\t\t\t\t\t\t\tnode = tempNode;\n\t\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tnode = node.parent;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}, schema);\n\n\t\t\trootNode = node = new Node(args.context || settings.root_name, 11);\n\n\t\t\tparser.parse(html);\n\n\t\t\t// Fix invalid children or report invalid children in a contextual parsing\n\t\t\tif (validate && invalidChildren.length) {\n\t\t\t\tif (!args.context)\n\t\t\t\t\tfixInvalidChildren(invalidChildren);\n\t\t\t\telse\n\t\t\t\t\targs.invalid = true;\n\t\t\t}\n\n\t\t\t// Wrap nodes in the root into block elements if the root is body\n\t\t\tif (rootBlockName && rootNode.name == 'body')\n\t\t\t\taddRootBlocks();\n\n\t\t\t// Run filters only when the contents is valid\n\t\t\tif (!args.invalid) {\n\t\t\t\t// Run node filters\n\t\t\t\tfor (name in matchedNodes) {\n\t\t\t\t\tlist = nodeFilters[name];\n\t\t\t\t\tnodes = matchedNodes[name];\n\n\t\t\t\t\t// Remove already removed children\n\t\t\t\t\tfi = nodes.length;\n\t\t\t\t\twhile (fi--) {\n\t\t\t\t\t\tif (!nodes[fi].parent)\n\t\t\t\t\t\t\tnodes.splice(fi, 1);\n\t\t\t\t\t}\n\n\t\t\t\t\tfor (i = 0, l = list.length; i < l; i++)\n\t\t\t\t\t\tlist[i](nodes, name, args);\n\t\t\t\t}\n\n\t\t\t\t// Run attribute filters\n\t\t\t\tfor (i = 0, l = attributeFilters.length; i < l; i++) {\n\t\t\t\t\tlist = attributeFilters[i];\n\n\t\t\t\t\tif (list.name in matchedAttributes) {\n\t\t\t\t\t\tnodes = matchedAttributes[list.name];\n\n\t\t\t\t\t\t// Remove already removed children\n\t\t\t\t\t\tfi = nodes.length;\n\t\t\t\t\t\twhile (fi--) {\n\t\t\t\t\t\t\tif (!nodes[fi].parent)\n\t\t\t\t\t\t\t\tnodes.splice(fi, 1);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfor (fi = 0, fl = list.callbacks.length; fi < fl; fi++)\n\t\t\t\t\t\t\tlist.callbacks[fi](nodes, list.name, args);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn rootNode;\n\t\t};\n\n\t\t// Remove <br> at end of block elements Gecko and WebKit injects BR elements to\n\t\t// make it possible to place the caret inside empty blocks. This logic tries to remove\n\t\t// these elements and keep br elements that where intended to be there intact\n\t\tif (settings.remove_trailing_brs) {\n\t\t\tself.addNodeFilter('br', function(nodes, name) {\n\t\t\t\tvar i, l = nodes.length, node, blockElements = schema.getBlockElements(),\n\t\t\t\t\tnonEmptyElements = schema.getNonEmptyElements(), parent, prev, prevName;\n\n\t\t\t\t// Remove brs from body element as well\n\t\t\t\tblockElements.body = 1;\n\n\t\t\t\t// Must loop forwards since it will otherwise remove all brs in <p>a<br><br><br></p>\n\t\t\t\tfor (i = 0; i < l; i++) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tparent = node.parent;\n\n\t\t\t\t\tif (blockElements[node.parent.name] && node === parent.lastChild) {\n\t\t\t\t\t\t// Loop all nodes to the right of the current node and check for other BR elements\n\t\t\t\t\t\t// excluding bookmarks since they are invisible\n\t\t\t\t\t\tprev = node.prev;\n\t\t\t\t\t\twhile (prev) {\n\t\t\t\t\t\t\tprevName = prev.name;\n\n\t\t\t\t\t\t\t// Ignore bookmarks\n\t\t\t\t\t\t\tif (prevName !== \"span\" || prev.attr('data-mce-type') !== 'bookmark') {\n\t\t\t\t\t\t\t\t// Found a non BR element\n\t\t\t\t\t\t\t\tif (prevName !== \"br\")\n\t\t\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\t\t\t// Found another br it's a <br><br> structure then don't remove anything\n\t\t\t\t\t\t\t\tif (prevName === 'br') {\n\t\t\t\t\t\t\t\t\tnode = null;\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tprev = prev.prev;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (node) {\n\t\t\t\t\t\t\tnode.remove();\n\n\t\t\t\t\t\t\t// Is the parent to be considered empty after we removed the BR\n\t\t\t\t\t\t\tif (parent.isEmpty(nonEmptyElements)) {\n\t\t\t\t\t\t\t\telementRule = schema.getElementRule(parent.name);\n\n\t\t\t\t\t\t\t\t// Remove or padd the element depending on schema rule\n\t\t\t\t\t\t\t\tif (elementRule) {\n\t\t\t\t\t\t\t\t  if (elementRule.removeEmpty)\n\t\t\t\t\t\t\t\t\t  parent.remove();\n\t\t\t\t\t\t\t\t  else if (elementRule.paddEmpty)\n\t\t\t\t\t\t\t\t\t  parent.empty().append(new tinymce.html.Node('#text', 3)).value = '\\u00a0';\n\t\t\t\t\t\t\t  }\n              }\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t}\n})(tinymce);\n\ntinymce.html.Writer = function(settings) {\n\tvar html = [], indent, indentBefore, indentAfter, encode, htmlOutput;\n\n\tsettings = settings || {};\n\tindent = settings.indent;\n\tindentBefore = tinymce.makeMap(settings.indent_before || '');\n\tindentAfter = tinymce.makeMap(settings.indent_after || '');\n\tencode = tinymce.html.Entities.getEncodeFunc(settings.entity_encoding || 'raw', settings.entities);\n\thtmlOutput = settings.element_format == \"html\";\n\n\treturn {\n\t\tstart: function(name, attrs, empty) {\n\t\t\tvar i, l, attr, value;\n\n\t\t\tif (indent && indentBefore[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}\n\n\t\t\thtml.push('<', name);\n\n\t\t\tif (attrs) {\n\t\t\t\tfor (i = 0, l = attrs.length; i < l; i++) {\n\t\t\t\t\tattr = attrs[i];\n\t\t\t\t\thtml.push(' ', attr.name, '=\"', encode(attr.value, true), '\"');\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (!empty || htmlOutput)\n\t\t\t\thtml[html.length] = '>';\n\t\t\telse\n\t\t\t\thtml[html.length] = ' />';\n\n\t\t\tif (empty && indent && indentAfter[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}\n\t\t},\n\n\t\tend: function(name) {\n\t\t\tvar value;\n\n\t\t\t/*if (indent && indentBefore[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}*/\n\n\t\t\thtml.push('</', name, '>');\n\n\t\t\tif (indent && indentAfter[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}\n\t\t},\n\n\t\ttext: function(text, raw) {\n\t\t\tif (text.length > 0)\n\t\t\t\thtml[html.length] = raw ? text : encode(text);\n\t\t},\n\n\t\tcdata: function(text) {\n\t\t\thtml.push('<![CDATA[', text, ']]>');\n\t\t},\n\n\t\tcomment: function(text) {\n\t\t\thtml.push('<!--', text, '-->');\n\t\t},\n\n\t\tpi: function(name, text) {\n\t\t\tif (text)\n\t\t\t\thtml.push('<?', name, ' ', text, '?>');\n\t\t\telse\n\t\t\t\thtml.push('<?', name, '?>');\n\n\t\t\tif (indent)\n\t\t\t\thtml.push('\\n');\n\t\t},\n\n\t\tdoctype: function(text) {\n\t\t\thtml.push('<!DOCTYPE', text, '>', indent ? '\\n' : '');\n\t\t},\n\n\t\treset: function() {\n\t\t\thtml.length = 0;\n\t\t},\n\n\t\tgetContent: function() {\n\t\t\treturn html.join('').replace(/\\n$/, '');\n\t\t}\n\t};\n};\n\n(function(tinymce) {\n\ttinymce.html.Serializer = function(settings, schema) {\n\t\tvar self = this, writer = new tinymce.html.Writer(settings);\n\n\t\tsettings = settings || {};\n\t\tsettings.validate = \"validate\" in settings ? settings.validate : true;\n\n\t\tself.schema = schema = schema || new tinymce.html.Schema();\n\t\tself.writer = writer;\n\n\t\tself.serialize = function(node) {\n\t\t\tvar handlers, validate;\n\n\t\t\tvalidate = settings.validate;\n\n\t\t\thandlers = {\n\t\t\t\t// #text\n\t\t\t\t3: function(node, raw) {\n\t\t\t\t\twriter.text(node.value, node.raw);\n\t\t\t\t},\n\n\t\t\t\t// #comment\n\t\t\t\t8: function(node) {\n\t\t\t\t\twriter.comment(node.value);\n\t\t\t\t},\n\n\t\t\t\t// Processing instruction\n\t\t\t\t7: function(node) {\n\t\t\t\t\twriter.pi(node.name, node.value);\n\t\t\t\t},\n\n\t\t\t\t// Doctype\n\t\t\t\t10: function(node) {\n\t\t\t\t\twriter.doctype(node.value);\n\t\t\t\t},\n\n\t\t\t\t// CDATA\n\t\t\t\t4: function(node) {\n\t\t\t\t\twriter.cdata(node.value);\n\t\t\t\t},\n\n \t\t\t\t// Document fragment\n\t\t\t\t11: function(node) {\n\t\t\t\t\tif ((node = node.firstChild)) {\n\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\twalk(node);\n\t\t\t\t\t\t} while (node = node.next);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\twriter.reset();\n\n\t\t\tfunction walk(node) {\n\t\t\t\tvar handler = handlers[node.type], name, isEmpty, attrs, attrName, attrValue, sortedAttrs, i, l, elementRule;\n\n\t\t\t\tif (!handler) {\n\t\t\t\t\tname = node.name;\n\t\t\t\t\tisEmpty = node.shortEnded;\n\t\t\t\t\tattrs = node.attributes;\n\n\t\t\t\t\t// Sort attributes\n\t\t\t\t\tif (validate && attrs && attrs.length > 1) {\n\t\t\t\t\t\tsortedAttrs = [];\n\t\t\t\t\t\tsortedAttrs.map = {};\n\n\t\t\t\t\t\telementRule = schema.getElementRule(node.name);\n\t\t\t\t\t\tfor (i = 0, l = elementRule.attributesOrder.length; i < l; i++) {\n\t\t\t\t\t\t\tattrName = elementRule.attributesOrder[i];\n\n\t\t\t\t\t\t\tif (attrName in attrs.map) {\n\t\t\t\t\t\t\t\tattrValue = attrs.map[attrName];\n\t\t\t\t\t\t\t\tsortedAttrs.map[attrName] = attrValue;\n\t\t\t\t\t\t\t\tsortedAttrs.push({name: attrName, value: attrValue});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfor (i = 0, l = attrs.length; i < l; i++) {\n\t\t\t\t\t\t\tattrName = attrs[i].name;\n\n\t\t\t\t\t\t\tif (!(attrName in sortedAttrs.map)) {\n\t\t\t\t\t\t\t\tattrValue = attrs.map[attrName];\n\t\t\t\t\t\t\t\tsortedAttrs.map[attrName] = attrValue;\n\t\t\t\t\t\t\t\tsortedAttrs.push({name: attrName, value: attrValue});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tattrs = sortedAttrs;\n\t\t\t\t\t}\n\n\t\t\t\t\twriter.start(node.name, attrs, isEmpty);\n\n\t\t\t\t\tif (!isEmpty) {\n\t\t\t\t\t\tif ((node = node.firstChild)) {\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\twalk(node);\n\t\t\t\t\t\t\t} while (node = node.next);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\twriter.end(name);\n\t\t\t\t\t}\n\t\t\t\t} else\n\t\t\t\t\thandler(node);\n\t\t\t}\n\n\t\t\t// Serialize element and treat all non elements as fragments\n\t\t\tif (node.type == 1 && !settings.inner)\n\t\t\t\twalk(node);\n\t\t\telse\n\t\t\t\thandlers[11](node);\n\n\t\t\treturn writer.getContent();\n\t\t};\n\t}\n})(tinymce);\n\n(function(tinymce) {\n\t// Shorten names\n\tvar each = tinymce.each,\n\t\tis = tinymce.is,\n\t\tisWebKit = tinymce.isWebKit,\n\t\tisIE = tinymce.isIE,\n\t\tEntities = tinymce.html.Entities,\n\t\tsimpleSelectorRe = /^([a-z0-9],?)+$/i,\n\t\tblockElementsMap = tinymce.html.Schema.blockElementsMap,\n\t\twhiteSpaceRegExp = /^[ \\t\\r\\n]*$/;\n\n\ttinymce.create('tinymce.dom.DOMUtils', {\n\t\tdoc : null,\n\t\troot : null,\n\t\tfiles : null,\n\t\tpixelStyles : /^(top|left|bottom|right|width|height|borderWidth)$/,\n\t\tprops : {\n\t\t\t\"for\" : \"htmlFor\",\n\t\t\t\"class\" : \"className\",\n\t\t\tclassName : \"className\",\n\t\t\tchecked : \"checked\",\n\t\t\tdisabled : \"disabled\",\n\t\t\tmaxlength : \"maxLength\",\n\t\t\treadonly : \"readOnly\",\n\t\t\tselected : \"selected\",\n\t\t\tvalue : \"value\",\n\t\t\tid : \"id\",\n\t\t\tname : \"name\",\n\t\t\ttype : \"type\"\n\t\t},\n\n\t\tDOMUtils : function(d, s) {\n\t\t\tvar t = this, globalStyle, name;\n\n\t\t\tt.doc = d;\n\t\t\tt.win = window;\n\t\t\tt.files = {};\n\t\t\tt.cssFlicker = false;\n\t\t\tt.counter = 0;\n\t\t\tt.stdMode = !tinymce.isIE || d.documentMode >= 8;\n\t\t\tt.boxModel = !tinymce.isIE || d.compatMode == \"CSS1Compat\" || t.stdMode;\n\t\t\tt.hasOuterHTML = \"outerHTML\" in d.createElement(\"a\");\n\n\t\t\tt.settings = s = tinymce.extend({\n\t\t\t\tkeep_values : false,\n\t\t\t\thex_colors : 1\n\t\t\t}, s);\n\n\t\t\tt.schema = s.schema;\n\t\t\tt.styles = new tinymce.html.Styles({\n\t\t\t\turl_converter : s.url_converter,\n\t\t\t\turl_converter_scope : s.url_converter_scope\n\t\t\t}, s.schema);\n\n\t\t\t// Fix IE6SP2 flicker and check it failed for pre SP2\n\t\t\tif (tinymce.isIE6) {\n\t\t\t\ttry {\n\t\t\t\t\td.execCommand('BackgroundImageCache', false, true);\n\t\t\t\t} catch (e) {\n\t\t\t\t\tt.cssFlicker = true;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (isIE && s.schema) {\n\t\t\t\t// Add missing HTML 4/5 elements to IE\n\t\t\t\t('abbr article aside audio canvas ' +\n\t\t\t\t'details figcaption figure footer ' +\n\t\t\t\t'header hgroup mark menu meter nav ' +\n\t\t\t\t'output progress section summary ' +\n\t\t\t\t'time video').replace(/\\w+/g, function(name) {\n\t\t\t\t\td.createElement(name);\n\t\t\t\t});\n\n\t\t\t\t// Create all custom elements\n\t\t\t\tfor (name in s.schema.getCustomElements()) {\n\t\t\t\t\td.createElement(name);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\ttinymce.addUnload(t.destroy, t);\n\t\t},\n\n\t\tgetRoot : function() {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\treturn (s && t.get(s.root_element)) || t.doc.body;\n\t\t},\n\n\t\tgetViewPort : function(w) {\n\t\t\tvar d, b;\n\n\t\t\tw = !w ? this.win : w;\n\t\t\td = w.document;\n\t\t\tb = this.boxModel ? d.documentElement : d.body;\n\n\t\t\t// Returns viewport size excluding scrollbars\n\t\t\treturn {\n\t\t\t\tx : w.pageXOffset || b.scrollLeft,\n\t\t\t\ty : w.pageYOffset || b.scrollTop,\n\t\t\t\tw : w.innerWidth || b.clientWidth,\n\t\t\t\th : w.innerHeight || b.clientHeight\n\t\t\t};\n\t\t},\n\n\t\tgetRect : function(e) {\n\t\t\tvar p, t = this, sr;\n\n\t\t\te = t.get(e);\n\t\t\tp = t.getPos(e);\n\t\t\tsr = t.getSize(e);\n\n\t\t\treturn {\n\t\t\t\tx : p.x,\n\t\t\t\ty : p.y,\n\t\t\t\tw : sr.w,\n\t\t\t\th : sr.h\n\t\t\t};\n\t\t},\n\n\t\tgetSize : function(e) {\n\t\t\tvar t = this, w, h;\n\n\t\t\te = t.get(e);\n\t\t\tw = t.getStyle(e, 'width');\n\t\t\th = t.getStyle(e, 'height');\n\n\t\t\t// Non pixel value, then force offset/clientWidth\n\t\t\tif (w.indexOf('px') === -1)\n\t\t\t\tw = 0;\n\n\t\t\t// Non pixel value, then force offset/clientWidth\n\t\t\tif (h.indexOf('px') === -1)\n\t\t\t\th = 0;\n\n\t\t\treturn {\n\t\t\t\tw : parseInt(w) || e.offsetWidth || e.clientWidth,\n\t\t\t\th : parseInt(h) || e.offsetHeight || e.clientHeight\n\t\t\t};\n\t\t},\n\n\t\tgetParent : function(n, f, r) {\n\t\t\treturn this.getParents(n, f, r, false);\n\t\t},\n\n\t\tgetParents : function(n, f, r, c) {\n\t\t\tvar t = this, na, se = t.settings, o = [];\n\n\t\t\tn = t.get(n);\n\t\t\tc = c === undefined;\n\n\t\t\tif (se.strict_root)\n\t\t\t\tr = r || t.getRoot();\n\n\t\t\t// Wrap node name as func\n\t\t\tif (is(f, 'string')) {\n\t\t\t\tna = f;\n\n\t\t\t\tif (f === '*') {\n\t\t\t\t\tf = function(n) {return n.nodeType == 1;};\n\t\t\t\t} else {\n\t\t\t\t\tf = function(n) {\n\t\t\t\t\t\treturn t.is(n, na);\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t}\n\n\t\t\twhile (n) {\n\t\t\t\tif (n == r || !n.nodeType || n.nodeType === 9)\n\t\t\t\t\tbreak;\n\n\t\t\t\tif (!f || f(n)) {\n\t\t\t\t\tif (c)\n\t\t\t\t\t\to.push(n);\n\t\t\t\t\telse\n\t\t\t\t\t\treturn n;\n\t\t\t\t}\n\n\t\t\t\tn = n.parentNode;\n\t\t\t}\n\n\t\t\treturn c ? o : null;\n\t\t},\n\n\t\tget : function(e) {\n\t\t\tvar n;\n\n\t\t\tif (e && this.doc && typeof(e) == 'string') {\n\t\t\t\tn = e;\n\t\t\t\te = this.doc.getElementById(e);\n\n\t\t\t\t// IE and Opera returns meta elements when they match the specified input ID, but getElementsByName seems to do the trick\n\t\t\t\tif (e && e.id !== n)\n\t\t\t\t\treturn this.doc.getElementsByName(n)[1];\n\t\t\t}\n\n\t\t\treturn e;\n\t\t},\n\n\t\tgetNext : function(node, selector) {\n\t\t\treturn this._findSib(node, selector, 'nextSibling');\n\t\t},\n\n\t\tgetPrev : function(node, selector) {\n\t\t\treturn this._findSib(node, selector, 'previousSibling');\n\t\t},\n\n\n\t\tadd : function(p, n, a, h, c) {\n\t\t\tvar t = this;\n\n\t\t\treturn this.run(p, function(p) {\n\t\t\t\tvar e, k;\n\n\t\t\t\te = is(n, 'string') ? t.doc.createElement(n) : n;\n\t\t\t\tt.setAttribs(e, a);\n\n\t\t\t\tif (h) {\n\t\t\t\t\tif (h.nodeType)\n\t\t\t\t\t\te.appendChild(h);\n\t\t\t\t\telse\n\t\t\t\t\t\tt.setHTML(e, h);\n\t\t\t\t}\n\n\t\t\t\treturn !c ? p.appendChild(e) : e;\n\t\t\t});\n\t\t},\n\n\t\tcreate : function(n, a, h) {\n\t\t\treturn this.add(this.doc.createElement(n), n, a, h, 1);\n\t\t},\n\n\t\tcreateHTML : function(n, a, h) {\n\t\t\tvar o = '', t = this, k;\n\n\t\t\to += '<' + n;\n\n\t\t\tfor (k in a) {\n\t\t\t\tif (a.hasOwnProperty(k))\n\t\t\t\t\to += ' ' + k + '=\"' + t.encode(a[k]) + '\"';\n\t\t\t}\n\n\t\t\t// A call to tinymce.is doesn't work for some odd reason on IE9 possible bug inside their JS runtime\n\t\t\tif (typeof(h) != \"undefined\")\n\t\t\t\treturn o + '>' + h + '</' + n + '>';\n\n\t\t\treturn o + ' />';\n\t\t},\n\n\t\tremove : function(node, keep_children) {\n\t\t\treturn this.run(node, function(node) {\n\t\t\t\tvar child, parent = node.parentNode;\n\n\t\t\t\tif (!parent)\n\t\t\t\t\treturn null;\n\n\t\t\t\tif (keep_children) {\n\t\t\t\t\twhile (child = node.firstChild) {\n\t\t\t\t\t\t// IE 8 will crash if you don't remove completely empty text nodes\n\t\t\t\t\t\tif (!tinymce.isIE || child.nodeType !== 3 || child.nodeValue)\n\t\t\t\t\t\t\tparent.insertBefore(child, node);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tnode.removeChild(child);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn parent.removeChild(node);\n\t\t\t});\n\t\t},\n\n\t\tsetStyle : function(n, na, v) {\n\t\t\tvar t = this;\n\n\t\t\treturn t.run(n, function(e) {\n\t\t\t\tvar s, i;\n\n\t\t\t\ts = e.style;\n\n\t\t\t\t// Camelcase it, if needed\n\t\t\t\tna = na.replace(/-(\\D)/g, function(a, b){\n\t\t\t\t\treturn b.toUpperCase();\n\t\t\t\t});\n\n\t\t\t\t// Default px suffix on these\n\t\t\t\tif (t.pixelStyles.test(na) && (tinymce.is(v, 'number') || /^[\\-0-9\\.]+$/.test(v)))\n\t\t\t\t\tv += 'px';\n\n\t\t\t\tswitch (na) {\n\t\t\t\t\tcase 'opacity':\n\t\t\t\t\t\t// IE specific opacity\n\t\t\t\t\t\tif (isIE) {\n\t\t\t\t\t\t\ts.filter = v === '' ? '' : \"alpha(opacity=\" + (v * 100) + \")\";\n\n\t\t\t\t\t\t\tif (!n.currentStyle || !n.currentStyle.hasLayout)\n\t\t\t\t\t\t\t\ts.display = 'inline-block';\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Fix for older browsers\n\t\t\t\t\t\ts[na] = s['-moz-opacity'] = s['-khtml-opacity'] = v || '';\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'float':\n\t\t\t\t\t\tisIE ? s.styleFloat = v : s.cssFloat = v;\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tdefault:\n\t\t\t\t\t\ts[na] = v || '';\n\t\t\t\t}\n\n\t\t\t\t// Force update of the style data\n\t\t\t\tif (t.settings.update_styles)\n\t\t\t\t\tt.setAttrib(e, 'data-mce-style');\n\t\t\t});\n\t\t},\n\n\t\tgetStyle : function(n, na, c) {\n\t\t\tn = this.get(n);\n\n\t\t\tif (!n)\n\t\t\t\treturn;\n\n\t\t\t// Gecko\n\t\t\tif (this.doc.defaultView && c) {\n\t\t\t\t// Remove camelcase\n\t\t\t\tna = na.replace(/[A-Z]/g, function(a){\n\t\t\t\t\treturn '-' + a;\n\t\t\t\t});\n\n\t\t\t\ttry {\n\t\t\t\t\treturn this.doc.defaultView.getComputedStyle(n, null).getPropertyValue(na);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Old safari might fail\n\t\t\t\t\treturn null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Camelcase it, if needed\n\t\t\tna = na.replace(/-(\\D)/g, function(a, b){\n\t\t\t\treturn b.toUpperCase();\n\t\t\t});\n\n\t\t\tif (na == 'float')\n\t\t\t\tna = isIE ? 'styleFloat' : 'cssFloat';\n\n\t\t\t// IE & Opera\n\t\t\tif (n.currentStyle && c)\n\t\t\t\treturn n.currentStyle[na];\n\n\t\t\treturn n.style ? n.style[na] : undefined;\n\t\t},\n\n\t\tsetStyles : function(e, o) {\n\t\t\tvar t = this, s = t.settings, ol;\n\n\t\t\tol = s.update_styles;\n\t\t\ts.update_styles = 0;\n\n\t\t\teach(o, function(v, n) {\n\t\t\t\tt.setStyle(e, n, v);\n\t\t\t});\n\n\t\t\t// Update style info\n\t\t\ts.update_styles = ol;\n\t\t\tif (s.update_styles)\n\t\t\t\tt.setAttrib(e, s.cssText);\n\t\t},\n\n\t\tremoveAllAttribs: function(e) {\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\tvar i, attrs = e.attributes;\n\t\t\t\tfor (i = attrs.length - 1; i >= 0; i--) {\n\t\t\t\t\te.removeAttributeNode(attrs.item(i));\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\tsetAttrib : function(e, n, v) {\n\t\t\tvar t = this;\n\n\t\t\t// Whats the point\n\t\t\tif (!e || !n)\n\t\t\t\treturn;\n\n\t\t\t// Strict XML mode\n\t\t\tif (t.settings.strict)\n\t\t\t\tn = n.toLowerCase();\n\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\tvar s = t.settings;\n\t\t\t\tif (v !== null) {\n\t\t\t\t\tswitch (n) {\n\t\t\t\t\t\tcase \"style\":\n\t\t\t\t\t\t\tif (!is(v, 'string')) {\n\t\t\t\t\t\t\t\teach(v, function(v, n) {\n\t\t\t\t\t\t\t\t\tt.setStyle(e, n, v);\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// No mce_style for elements with these since they might get resized by the user\n\t\t\t\t\t\t\tif (s.keep_values) {\n\t\t\t\t\t\t\t\tif (v && !t._isRes(v))\n\t\t\t\t\t\t\t\t\te.setAttribute('data-mce-style', v, 2);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\te.removeAttribute('data-mce-style', 2);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\te.style.cssText = v;\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase \"class\":\n\t\t\t\t\t\t\te.className = v || ''; // Fix IE null bug\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase \"src\":\n\t\t\t\t\t\tcase \"href\":\n\t\t\t\t\t\t\tif (s.keep_values) {\n\t\t\t\t\t\t\t\tif (s.url_converter)\n\t\t\t\t\t\t\t\t\tv = s.url_converter.call(s.url_converter_scope || t, v, n, e);\n\n\t\t\t\t\t\t\t\tt.setAttrib(e, 'data-mce-' + n, v, 2);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase \"shape\":\n\t\t\t\t\t\t\te.setAttribute('data-mce-style', v);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif (is(v) && v !== null && v.length !== 0)\n\t\t\t\t\te.setAttribute(n, '' + v, 2);\n\t\t\t\telse\n\t\t\t\t\te.removeAttribute(n, 2);\n\t\t\t});\n\t\t},\n\n\t\tsetAttribs : function(e, o) {\n\t\t\tvar t = this;\n\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\teach(o, function(v, n) {\n\t\t\t\t\tt.setAttrib(e, n, v);\n\t\t\t\t});\n\t\t\t});\n\t\t},\n\n\t\tgetAttrib : function(e, n, dv) {\n\t\t\tvar v, t = this, undef;\n\n\t\t\te = t.get(e);\n\n\t\t\tif (!e || e.nodeType !== 1)\n\t\t\t\treturn dv === undef ? false : dv;\n\n\t\t\tif (!is(dv))\n\t\t\t\tdv = '';\n\n\t\t\t// Try the mce variant for these\n\t\t\tif (/^(src|href|style|coords|shape)$/.test(n)) {\n\t\t\t\tv = e.getAttribute(\"data-mce-\" + n);\n\n\t\t\t\tif (v)\n\t\t\t\t\treturn v;\n\t\t\t}\n\n\t\t\tif (isIE && t.props[n]) {\n\t\t\t\tv = e[t.props[n]];\n\t\t\t\tv = v && v.nodeValue ? v.nodeValue : v;\n\t\t\t}\n\n\t\t\tif (!v)\n\t\t\t\tv = e.getAttribute(n, 2);\n\n\t\t\t// Check boolean attribs\n\t\t\tif (/^(checked|compact|declare|defer|disabled|ismap|multiple|nohref|noshade|nowrap|readonly|selected)$/.test(n)) {\n\t\t\t\tif (e[t.props[n]] === true && v === '')\n\t\t\t\t\treturn n;\n\n\t\t\t\treturn v ? n : '';\n\t\t\t}\n\n\t\t\t// Inner input elements will override attributes on form elements\n\t\t\tif (e.nodeName === \"FORM\" && e.getAttributeNode(n))\n\t\t\t\treturn e.getAttributeNode(n).nodeValue;\n\n\t\t\tif (n === 'style') {\n\t\t\t\tv = v || e.style.cssText;\n\n\t\t\t\tif (v) {\n\t\t\t\t\tv = t.serializeStyle(t.parseStyle(v), e.nodeName);\n\n\t\t\t\t\tif (t.settings.keep_values && !t._isRes(v))\n\t\t\t\t\t\te.setAttribute('data-mce-style', v);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Remove Apple and WebKit stuff\n\t\t\tif (isWebKit && n === \"class\" && v)\n\t\t\t\tv = v.replace(/(apple|webkit)\\-[a-z\\-]+/gi, '');\n\n\t\t\t// Handle IE issues\n\t\t\tif (isIE) {\n\t\t\t\tswitch (n) {\n\t\t\t\t\tcase 'rowspan':\n\t\t\t\t\tcase 'colspan':\n\t\t\t\t\t\t// IE returns 1 as default value\n\t\t\t\t\t\tif (v === 1)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'size':\n\t\t\t\t\t\t// IE returns +0 as default value for size\n\t\t\t\t\t\tif (v === '+0' || v === 20 || v === 0)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'width':\n\t\t\t\t\tcase 'height':\n\t\t\t\t\tcase 'vspace':\n\t\t\t\t\tcase 'checked':\n\t\t\t\t\tcase 'disabled':\n\t\t\t\t\tcase 'readonly':\n\t\t\t\t\t\tif (v === 0)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'hspace':\n\t\t\t\t\t\t// IE returns -1 as default value\n\t\t\t\t\t\tif (v === -1)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'maxlength':\n\t\t\t\t\tcase 'tabindex':\n\t\t\t\t\t\t// IE returns default value\n\t\t\t\t\t\tif (v === 32768 || v === 2147483647 || v === '32768')\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'multiple':\n\t\t\t\t\tcase 'compact':\n\t\t\t\t\tcase 'noshade':\n\t\t\t\t\tcase 'nowrap':\n\t\t\t\t\t\tif (v === 65535)\n\t\t\t\t\t\t\treturn n;\n\n\t\t\t\t\t\treturn dv;\n\n\t\t\t\t\tcase 'shape':\n\t\t\t\t\t\tv = v.toLowerCase();\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tdefault:\n\t\t\t\t\t\t// IE has odd anonymous function for event attributes\n\t\t\t\t\t\tif (n.indexOf('on') === 0 && v)\n\t\t\t\t\t\t\tv = tinymce._replace(/^function\\s+\\w+\\(\\)\\s+\\{\\s+(.*)\\s+\\}$/, '$1', '' + v);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn (v !== undef && v !== null && v !== '') ? '' + v : dv;\n\t\t},\n\n\t\tgetPos : function(n, ro) {\n\t\t\tvar t = this, x = 0, y = 0, e, d = t.doc, r;\n\n\t\t\tn = t.get(n);\n\t\t\tro = ro || d.body;\n\n\t\t\tif (n) {\n\t\t\t\t// Use getBoundingClientRect if it exists since it's faster than looping offset nodes\n\t\t\t\tif (n.getBoundingClientRect) {\n\t\t\t\t\tn = n.getBoundingClientRect();\n\t\t\t\t\te = t.boxModel ? d.documentElement : d.body;\n\n\t\t\t\t\t// Add scroll offsets from documentElement or body since IE with the wrong box model will use d.body and so do WebKit\n\t\t\t\t\t// Also remove the body/documentelement clientTop/clientLeft on IE 6, 7 since they offset the position\n\t\t\t\t\tx = n.left + (d.documentElement.scrollLeft || d.body.scrollLeft) - e.clientTop;\n\t\t\t\t\ty = n.top + (d.documentElement.scrollTop || d.body.scrollTop) - e.clientLeft;\n\n\t\t\t\t\treturn {x : x, y : y};\n\t\t\t\t}\n\n\t\t\t\tr = n;\n\t\t\t\twhile (r && r != ro && r.nodeType) {\n\t\t\t\t\tx += r.offsetLeft || 0;\n\t\t\t\t\ty += r.offsetTop || 0;\n\t\t\t\t\tr = r.offsetParent;\n\t\t\t\t}\n\n\t\t\t\tr = n.parentNode;\n\t\t\t\twhile (r && r != ro && r.nodeType) {\n\t\t\t\t\tx -= r.scrollLeft || 0;\n\t\t\t\t\ty -= r.scrollTop || 0;\n\t\t\t\t\tr = r.parentNode;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn {x : x, y : y};\n\t\t},\n\n\t\tparseStyle : function(st) {\n\t\t\treturn this.styles.parse(st);\n\t\t},\n\n\t\tserializeStyle : function(o, name) {\n\t\t\treturn this.styles.serialize(o, name);\n\t\t},\n\n\t\tloadCSS : function(u) {\n\t\t\tvar t = this, d = t.doc, head;\n\n\t\t\tif (!u)\n\t\t\t\tu = '';\n\n\t\t\thead = t.select('head')[0];\n\n\t\t\teach(u.split(','), function(u) {\n\t\t\t\tvar link;\n\n\t\t\t\tif (t.files[u])\n\t\t\t\t\treturn;\n\n\t\t\t\tt.files[u] = true;\n\t\t\t\tlink = t.create('link', {rel : 'stylesheet', href : tinymce._addVer(u)});\n\n\t\t\t\t// IE 8 has a bug where dynamically loading stylesheets would produce a 1 item remaining bug\n\t\t\t\t// This fix seems to resolve that issue by realcing the document ones a stylesheet finishes loading\n\t\t\t\t// It's ugly but it seems to work fine.\n\t\t\t\tif (isIE && d.documentMode && d.recalc) {\n\t\t\t\t\tlink.onload = function() {\n\t\t\t\t\t\tif (d.recalc)\n\t\t\t\t\t\t\td.recalc();\n\n\t\t\t\t\t\tlink.onload = null;\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\thead.appendChild(link);\n\t\t\t});\n\t\t},\n\n\t\taddClass : function(e, c) {\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\tvar o;\n\n\t\t\t\tif (!c)\n\t\t\t\t\treturn 0;\n\n\t\t\t\tif (this.hasClass(e, c))\n\t\t\t\t\treturn e.className;\n\n\t\t\t\to = this.removeClass(e, c);\n\n\t\t\t\treturn e.className = (o != '' ? (o + ' ') : '') + c;\n\t\t\t});\n\t\t},\n\n\t\tremoveClass : function(e, c) {\n\t\t\tvar t = this, re;\n\n\t\t\treturn t.run(e, function(e) {\n\t\t\t\tvar v;\n\n\t\t\t\tif (t.hasClass(e, c)) {\n\t\t\t\t\tif (!re)\n\t\t\t\t\t\tre = new RegExp(\"(^|\\\\s+)\" + c + \"(\\\\s+|$)\", \"g\");\n\n\t\t\t\t\tv = e.className.replace(re, ' ');\n\t\t\t\t\tv = tinymce.trim(v != ' ' ? v : '');\n\n\t\t\t\t\te.className = v;\n\n\t\t\t\t\t// Empty class attr\n\t\t\t\t\tif (!v) {\n\t\t\t\t\t\te.removeAttribute('class');\n\t\t\t\t\t\te.removeAttribute('className');\n\t\t\t\t\t}\n\n\t\t\t\t\treturn v;\n\t\t\t\t}\n\n\t\t\t\treturn e.className;\n\t\t\t});\n\t\t},\n\n\t\thasClass : function(n, c) {\n\t\t\tn = this.get(n);\n\n\t\t\tif (!n || !c)\n\t\t\t\treturn false;\n\n\t\t\treturn (' ' + n.className + ' ').indexOf(' ' + c + ' ') !== -1;\n\t\t},\n\n\t\tshow : function(e) {\n\t\t\treturn this.setStyle(e, 'display', 'block');\n\t\t},\n\n\t\thide : function(e) {\n\t\t\treturn this.setStyle(e, 'display', 'none');\n\t\t},\n\n\t\tisHidden : function(e) {\n\t\t\te = this.get(e);\n\n\t\t\treturn !e || e.style.display == 'none' || this.getStyle(e, 'display') == 'none';\n\t\t},\n\n\t\tuniqueId : function(p) {\n\t\t\treturn (!p ? 'mce_' : p) + (this.counter++);\n\t\t},\n\n\t\tsetHTML : function(element, html) {\n\t\t\tvar self = this;\n\n\t\t\treturn self.run(element, function(element) {\n\t\t\t\tif (isIE) {\n\t\t\t\t\t// Remove all child nodes, IE keeps empty text nodes in DOM\n\t\t\t\t\twhile (element.firstChild)\n\t\t\t\t\t\telement.removeChild(element.firstChild);\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\t// IE will remove comments from the beginning\n\t\t\t\t\t\t// unless you padd the contents with something\n\t\t\t\t\t\telement.innerHTML = '<br />' + html;\n\t\t\t\t\t\telement.removeChild(element.firstChild);\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// IE sometimes produces an unknown runtime error on innerHTML if it's an block element within a block element for example a div inside a p\n\t\t\t\t\t\t// This seems to fix this problem\n\n\t\t\t\t\t\t// Create new div with HTML contents and a BR infront to keep comments\n\t\t\t\t\t\telement = self.create('div');\n\t\t\t\t\t\telement.innerHTML = '<br />' + html;\n\n\t\t\t\t\t\t// Add all children from div to target\n\t\t\t\t\t\teach (element.childNodes, function(node, i) {\n\t\t\t\t\t\t\t// Skip br element\n\t\t\t\t\t\t\tif (i)\n\t\t\t\t\t\t\t\telement.appendChild(node);\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t} else\n\t\t\t\t\telement.innerHTML = html;\n\n\t\t\t\treturn html;\n\t\t\t});\n\t\t},\n\n\t\tgetOuterHTML : function(elm) {\n\t\t\tvar doc, self = this;\n\n\t\t\telm = self.get(elm);\n\n\t\t\tif (!elm)\n\t\t\t\treturn null;\n\n\t\t\tif (elm.nodeType === 1 && self.hasOuterHTML)\n\t\t\t\treturn elm.outerHTML;\n\n\t\t\tdoc = (elm.ownerDocument || self.doc).createElement(\"body\");\n\t\t\tdoc.appendChild(elm.cloneNode(true));\n\n\t\t\treturn doc.innerHTML;\n\t\t},\n\n\t\tsetOuterHTML : function(e, h, d) {\n\t\t\tvar t = this;\n\n\t\t\tfunction setHTML(e, h, d) {\n\t\t\t\tvar n, tp;\n\n\t\t\t\ttp = d.createElement(\"body\");\n\t\t\t\ttp.innerHTML = h;\n\n\t\t\t\tn = tp.lastChild;\n\t\t\t\twhile (n) {\n\t\t\t\t\tt.insertAfter(n.cloneNode(true), e);\n\t\t\t\t\tn = n.previousSibling;\n\t\t\t\t}\n\n\t\t\t\tt.remove(e);\n\t\t\t};\n\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\te = t.get(e);\n\n\t\t\t\t// Only set HTML on elements\n\t\t\t\tif (e.nodeType == 1) {\n\t\t\t\t\td = d || e.ownerDocument || t.doc;\n\n\t\t\t\t\tif (isIE) {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t// Try outerHTML for IE it sometimes produces an unknown runtime error\n\t\t\t\t\t\t\tif (isIE && e.nodeType == 1)\n\t\t\t\t\t\t\t\te.outerHTML = h;\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tsetHTML(e, h, d);\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\t// Fix for unknown runtime error\n\t\t\t\t\t\t\tsetHTML(e, h, d);\n\t\t\t\t\t\t}\n\t\t\t\t\t} else\n\t\t\t\t\t\tsetHTML(e, h, d);\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\tdecode : Entities.decode,\n\n\t\tencode : Entities.encodeAllRaw,\n\n\t\tinsertAfter : function(node, reference_node) {\n\t\t\treference_node = this.get(reference_node);\n\n\t\t\treturn this.run(node, function(node) {\n\t\t\t\tvar parent, nextSibling;\n\n\t\t\t\tparent = reference_node.parentNode;\n\t\t\t\tnextSibling = reference_node.nextSibling;\n\n\t\t\t\tif (nextSibling)\n\t\t\t\t\tparent.insertBefore(node, nextSibling);\n\t\t\t\telse\n\t\t\t\t\tparent.appendChild(node);\n\n\t\t\t\treturn node;\n\t\t\t});\n\t\t},\n\n\t\tisBlock : function(node) {\n\t\t\tvar type = node.nodeType;\n\n\t\t\t// If it's a node then check the type and use the nodeName\n\t\t\tif (type)\n\t\t\t\treturn !!(type === 1 && blockElementsMap[node.nodeName]);\n\n\t\t\treturn !!blockElementsMap[node];\n\t\t},\n\n\t\treplace : function(n, o, k) {\n\t\t\tvar t = this;\n\n\t\t\tif (is(o, 'array'))\n\t\t\t\tn = n.cloneNode(true);\n\n\t\t\treturn t.run(o, function(o) {\n\t\t\t\tif (k) {\n\t\t\t\t\teach(tinymce.grep(o.childNodes), function(c) {\n\t\t\t\t\t\tn.appendChild(c);\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\treturn o.parentNode.replaceChild(n, o);\n\t\t\t});\n\t\t},\n\n\t\trename : function(elm, name) {\n\t\t\tvar t = this, newElm;\n\n\t\t\tif (elm.nodeName != name.toUpperCase()) {\n\t\t\t\t// Rename block element\n\t\t\t\tnewElm = t.create(name);\n\n\t\t\t\t// Copy attribs to new block\n\t\t\t\teach(t.getAttribs(elm), function(attr_node) {\n\t\t\t\t\tt.setAttrib(newElm, attr_node.nodeName, t.getAttrib(elm, attr_node.nodeName));\n\t\t\t\t});\n\n\t\t\t\t// Replace block\n\t\t\t\tt.replace(newElm, elm, 1);\n\t\t\t}\n\n\t\t\treturn newElm || elm;\n\t\t},\n\n\t\tfindCommonAncestor : function(a, b) {\n\t\t\tvar ps = a, pe;\n\n\t\t\twhile (ps) {\n\t\t\t\tpe = b;\n\n\t\t\t\twhile (pe && ps != pe)\n\t\t\t\t\tpe = pe.parentNode;\n\n\t\t\t\tif (ps == pe)\n\t\t\t\t\tbreak;\n\n\t\t\t\tps = ps.parentNode;\n\t\t\t}\n\n\t\t\tif (!ps && a.ownerDocument)\n\t\t\t\treturn a.ownerDocument.documentElement;\n\n\t\t\treturn ps;\n\t\t},\n\n\t\ttoHex : function(s) {\n\t\t\tvar c = /^\\s*rgb\\s*?\\(\\s*?([0-9]+)\\s*?,\\s*?([0-9]+)\\s*?,\\s*?([0-9]+)\\s*?\\)\\s*$/i.exec(s);\n\n\t\t\tfunction hex(s) {\n\t\t\t\ts = parseInt(s).toString(16);\n\n\t\t\t\treturn s.length > 1 ? s : '0' + s; // 0 -> 00\n\t\t\t};\n\n\t\t\tif (c) {\n\t\t\t\ts = '#' + hex(c[1]) + hex(c[2]) + hex(c[3]);\n\n\t\t\t\treturn s;\n\t\t\t}\n\n\t\t\treturn s;\n\t\t},\n\n\t\tgetClasses : function() {\n\t\t\tvar t = this, cl = [], i, lo = {}, f = t.settings.class_filter, ov;\n\n\t\t\tif (t.classes)\n\t\t\t\treturn t.classes;\n\n\t\t\tfunction addClasses(s) {\n\t\t\t\t// IE style imports\n\t\t\t\teach(s.imports, function(r) {\n\t\t\t\t\taddClasses(r);\n\t\t\t\t});\n\n\t\t\t\teach(s.cssRules || s.rules, function(r) {\n\t\t\t\t\t// Real type or fake it on IE\n\t\t\t\t\tswitch (r.type || 1) {\n\t\t\t\t\t\t// Rule\n\t\t\t\t\t\tcase 1:\n\t\t\t\t\t\t\tif (r.selectorText) {\n\t\t\t\t\t\t\t\teach(r.selectorText.split(','), function(v) {\n\t\t\t\t\t\t\t\t\tv = v.replace(/^\\s*|\\s*$|^\\s\\./g, \"\");\n\n\t\t\t\t\t\t\t\t\t// Is internal or it doesn't contain a class\n\t\t\t\t\t\t\t\t\tif (/\\.mce/.test(v) || !/\\.[\\w\\-]+$/.test(v))\n\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t// Remove everything but class name\n\t\t\t\t\t\t\t\t\tov = v;\n\t\t\t\t\t\t\t\t\tv = tinymce._replace(/.*\\.([a-z0-9_\\-]+).*/i, '$1', v);\n\n\t\t\t\t\t\t\t\t\t// Filter classes\n\t\t\t\t\t\t\t\t\tif (f && !(v = f(v, ov)))\n\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\tif (!lo[v]) {\n\t\t\t\t\t\t\t\t\t\tcl.push({'class' : v});\n\t\t\t\t\t\t\t\t\t\tlo[v] = 1;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\t// Import\n\t\t\t\t\t\tcase 3:\n\t\t\t\t\t\t\taddClasses(r.styleSheet);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t};\n\n\t\t\ttry {\n\t\t\t\teach(t.doc.styleSheets, addClasses);\n\t\t\t} catch (ex) {\n\t\t\t\t// Ignore\n\t\t\t}\n\n\t\t\tif (cl.length > 0)\n\t\t\t\tt.classes = cl;\n\n\t\t\treturn cl;\n\t\t},\n\n\t\trun : function(e, f, s) {\n\t\t\tvar t = this, o;\n\n\t\t\tif (t.doc && typeof(e) === 'string')\n\t\t\t\te = t.get(e);\n\n\t\t\tif (!e)\n\t\t\t\treturn false;\n\n\t\t\ts = s || this;\n\t\t\tif (!e.nodeType && (e.length || e.length === 0)) {\n\t\t\t\to = [];\n\n\t\t\t\teach(e, function(e, i) {\n\t\t\t\t\tif (e) {\n\t\t\t\t\t\tif (typeof(e) == 'string')\n\t\t\t\t\t\t\te = t.doc.getElementById(e);\n\n\t\t\t\t\t\to.push(f.call(s, e, i));\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\treturn o;\n\t\t\t}\n\n\t\t\treturn f.call(s, e);\n\t\t},\n\n\t\tgetAttribs : function(n) {\n\t\t\tvar o;\n\n\t\t\tn = this.get(n);\n\n\t\t\tif (!n)\n\t\t\t\treturn [];\n\n\t\t\tif (isIE) {\n\t\t\t\to = [];\n\n\t\t\t\t// Object will throw exception in IE\n\t\t\t\tif (n.nodeName == 'OBJECT')\n\t\t\t\t\treturn n.attributes;\n\n\t\t\t\t// IE doesn't keep the selected attribute if you clone option elements\n\t\t\t\tif (n.nodeName === 'OPTION' && this.getAttrib(n, 'selected'))\n\t\t\t\t\to.push({specified : 1, nodeName : 'selected'});\n\n\t\t\t\t// It's crazy that this is faster in IE but it's because it returns all attributes all the time\n\t\t\t\tn.cloneNode(false).outerHTML.replace(/<\\/?[\\w:\\-]+ ?|=[\\\"][^\\\"]+\\\"|=\\'[^\\']+\\'|=[\\w\\-]+|>/gi, '').replace(/[\\w:\\-]+/gi, function(a) {\n\t\t\t\t\to.push({specified : 1, nodeName : a});\n\t\t\t\t});\n\n\t\t\t\treturn o;\n\t\t\t}\n\n\t\t\treturn n.attributes;\n\t\t},\n\n\t\tisEmpty : function(node, elements) {\n\t\t\tvar self = this, i, attributes, type, walker, name, parentNode;\n\n\t\t\tnode = node.firstChild;\n\t\t\tif (node) {\n\t\t\t\twalker = new tinymce.dom.TreeWalker(node);\n\t\t\t\telements = elements || self.schema ? self.schema.getNonEmptyElements() : null;\n\n\t\t\t\tdo {\n\t\t\t\t\ttype = node.nodeType;\n\n\t\t\t\t\tif (type === 1) {\n\t\t\t\t\t\t// Ignore bogus elements\n\t\t\t\t\t\tif (node.getAttribute('data-mce-bogus'))\n\t\t\t\t\t\t\tcontinue;\n\n\t\t\t\t\t\t// Keep empty elements like <img />\n\t\t\t\t\t\tname = node.nodeName.toLowerCase();\n\t\t\t\t\t\tif (elements && elements[name]) {\n\t\t\t\t\t\t\t// Ignore single BR elements in blocks like <p><br /></p>\n\t\t\t\t\t\t\tparentNode = node.parentNode;\n\t\t\t\t\t\t\tif (name === 'br' && self.isBlock(parentNode) && parentNode.firstChild === node && parentNode.lastChild === node) {\n\t\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Keep elements with data-bookmark attributes or name attribute like <a name=\"1\"></a>\n\t\t\t\t\t\tattributes = self.getAttribs(node);\n\t\t\t\t\t\ti = node.attributes.length;\n\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\tname = node.attributes[i].nodeName;\n\t\t\t\t\t\t\tif (name === \"name\" || name === 'data-mce-bookmark')\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Keep non whitespace text nodes\n\t\t\t\t\tif ((type === 3 && !whiteSpaceRegExp.test(node.nodeValue)))\n\t\t\t\t\t\treturn false;\n\t\t\t\t} while (node = walker.next());\n\t\t\t}\n\n\t\t\treturn true;\n\t\t},\n\n\t\tdestroy : function(s) {\n\t\t\tvar t = this;\n\n\t\t\tif (t.events)\n\t\t\t\tt.events.destroy();\n\n\t\t\tt.win = t.doc = t.root = t.events = null;\n\n\t\t\t// Manual destroy then remove unload handler\n\t\t\tif (!s)\n\t\t\t\ttinymce.removeUnload(t.destroy);\n\t\t},\n\n\t\tcreateRng : function() {\n\t\t\tvar d = this.doc;\n\n\t\t\treturn d.createRange ? d.createRange() : new tinymce.dom.Range(this);\n\t\t},\n\n\t\tnodeIndex : function(node, normalized) {\n\t\t\tvar idx = 0, lastNodeType, lastNode, nodeType;\n\n\t\t\tif (node) {\n\t\t\t\tfor (lastNodeType = node.nodeType, node = node.previousSibling, lastNode = node; node; node = node.previousSibling) {\n\t\t\t\t\tnodeType = node.nodeType;\n\n\t\t\t\t\t// Normalize text nodes\n\t\t\t\t\tif (normalized && nodeType == 3) {\n\t\t\t\t\t\tif (nodeType == lastNodeType || !node.nodeValue.length)\n\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\t\t\t\t\tidx++;\n\t\t\t\t\tlastNodeType = nodeType;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn idx;\n\t\t},\n\n\t\tsplit : function(pe, e, re) {\n\t\t\tvar t = this, r = t.createRng(), bef, aft, pa;\n\n\t\t\t// W3C valid browsers tend to leave empty nodes to the left/right side of the contents, this makes sense\n\t\t\t// but we don't want that in our code since it serves no purpose for the end user\n\t\t\t// For example if this is chopped:\n\t\t\t//   <p>text 1<span><b>CHOP</b></span>text 2</p>\n\t\t\t// would produce:\n\t\t\t//   <p>text 1<span></span></p><b>CHOP</b><p><span></span>text 2</p>\n\t\t\t// this function will then trim of empty edges and produce:\n\t\t\t//   <p>text 1</p><b>CHOP</b><p>text 2</p>\n\t\t\tfunction trim(node) {\n\t\t\t\tvar i, children = node.childNodes, type = node.nodeType;\n\n\t\t\t\tif (type == 1 && node.getAttribute('data-mce-type') == 'bookmark')\n\t\t\t\t\treturn;\n\n\t\t\t\tfor (i = children.length - 1; i >= 0; i--)\n\t\t\t\t\ttrim(children[i]);\n\n\t\t\t\tif (type != 9) {\n\t\t\t\t\t// Keep non whitespace text nodes\n\t\t\t\t\tif (type == 3 && node.nodeValue.length > 0) {\n\t\t\t\t\t\t// If parent element isn't a block or there isn't any useful contents for example \"<p>   </p>\"\n\t\t\t\t\t\tif (!t.isBlock(node.parentNode) || tinymce.trim(node.nodeValue).length > 0)\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t} else if (type == 1) {\n\t\t\t\t\t\t// If the only child is a bookmark then move it up\n\t\t\t\t\t\tchildren = node.childNodes;\n\t\t\t\t\t\tif (children.length == 1 && children[0] && children[0].nodeType == 1 && children[0].getAttribute('data-mce-type') == 'bookmark')\n\t\t\t\t\t\t\tnode.parentNode.insertBefore(children[0], node);\n\n\t\t\t\t\t\t// Keep non empty elements or img, hr etc\n\t\t\t\t\t\tif (children.length || /^(br|hr|input|img)$/i.test(node.nodeName))\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tt.remove(node);\n\t\t\t\t}\n\n\t\t\t\treturn node;\n\t\t\t};\n\n\t\t\tif (pe && e) {\n\t\t\t\t// Get before chunk\n\t\t\t\tr.setStart(pe.parentNode, t.nodeIndex(pe));\n\t\t\t\tr.setEnd(e.parentNode, t.nodeIndex(e));\n\t\t\t\tbef = r.extractContents();\n\n\t\t\t\t// Get after chunk\n\t\t\t\tr = t.createRng();\n\t\t\t\tr.setStart(e.parentNode, t.nodeIndex(e) + 1);\n\t\t\t\tr.setEnd(pe.parentNode, t.nodeIndex(pe) + 1);\n\t\t\t\taft = r.extractContents();\n\n\t\t\t\t// Insert before chunk\n\t\t\t\tpa = pe.parentNode;\n\t\t\t\tpa.insertBefore(trim(bef), pe);\n\n\t\t\t\t// Insert middle chunk\n\t\t\t\tif (re)\n\t\t\t\t\tpa.replaceChild(re, e);\n\t\t\t\telse\n\t\t\t\t\tpa.insertBefore(e, pe);\n\n\t\t\t\t// Insert after chunk\n\t\t\t\tpa.insertBefore(trim(aft), pe);\n\t\t\t\tt.remove(pe);\n\n\t\t\t\treturn re || e;\n\t\t\t}\n\t\t},\n\n\t\tbind : function(target, name, func, scope) {\n\t\t\tvar t = this;\n\n\t\t\tif (!t.events)\n\t\t\t\tt.events = new tinymce.dom.EventUtils();\n\n\t\t\treturn t.events.add(target, name, func, scope || this);\n\t\t},\n\n\t\tunbind : function(target, name, func) {\n\t\t\tvar t = this;\n\n\t\t\tif (!t.events)\n\t\t\t\tt.events = new tinymce.dom.EventUtils();\n\n\t\t\treturn t.events.remove(target, name, func);\n\t\t},\n\n\n\t\t_findSib : function(node, selector, name) {\n\t\t\tvar t = this, f = selector;\n\n\t\t\tif (node) {\n\t\t\t\t// If expression make a function of it using is\n\t\t\t\tif (is(f, 'string')) {\n\t\t\t\t\tf = function(node) {\n\t\t\t\t\t\treturn t.is(node, selector);\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\t// Loop all siblings\n\t\t\t\tfor (node = node[name]; node; node = node[name]) {\n\t\t\t\t\tif (f(node))\n\t\t\t\t\t\treturn node;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn null;\n\t\t},\n\n\t\t_isRes : function(c) {\n\t\t\t// Is live resizble element\n\t\t\treturn /^(top|left|bottom|right|width|height)/i.test(c) || /;\\s*(top|left|bottom|right|width|height)/i.test(c);\n\t\t}\n\n\t\t/*\n\t\twalk : function(n, f, s) {\n\t\t\tvar d = this.doc, w;\n\n\t\t\tif (d.createTreeWalker) {\n\t\t\t\tw = d.createTreeWalker(n, NodeFilter.SHOW_TEXT, null, false);\n\n\t\t\t\twhile ((n = w.nextNode()) != null)\n\t\t\t\t\tf.call(s || this, n);\n\t\t\t} else\n\t\t\t\ttinymce.walk(n, f, 'childNodes', s);\n\t\t}\n\t\t*/\n\n\t\t/*\n\t\ttoRGB : function(s) {\n\t\t\tvar c = /^\\s*?#([0-9A-F]{2})([0-9A-F]{1,2})([0-9A-F]{2})?\\s*?$/.exec(s);\n\n\t\t\tif (c) {\n\t\t\t\t// #FFF -> #FFFFFF\n\t\t\t\tif (!is(c[3]))\n\t\t\t\t\tc[3] = c[2] = c[1];\n\n\t\t\t\treturn \"rgb(\" + parseInt(c[1], 16) + \",\" + parseInt(c[2], 16) + \",\" + parseInt(c[3], 16) + \")\";\n\t\t\t}\n\n\t\t\treturn s;\n\t\t}\n\t\t*/\n\t});\n\n\ttinymce.DOM = new tinymce.dom.DOMUtils(document, {process_html : 0});\n})(tinymce);\n\n(function(ns) {\n\t// Range constructor\n\tfunction Range(dom) {\n\t\tvar t = this,\n\t\t\tdoc = dom.doc,\n\t\t\tEXTRACT = 0,\n\t\t\tCLONE = 1,\n\t\t\tDELETE = 2,\n\t\t\tTRUE = true,\n\t\t\tFALSE = false,\n\t\t\tSTART_OFFSET = 'startOffset',\n\t\t\tSTART_CONTAINER = 'startContainer',\n\t\t\tEND_CONTAINER = 'endContainer',\n\t\t\tEND_OFFSET = 'endOffset',\n\t\t\textend = tinymce.extend,\n\t\t\tnodeIndex = dom.nodeIndex;\n\n\t\textend(t, {\n\t\t\t// Inital states\n\t\t\tstartContainer : doc,\n\t\t\tstartOffset : 0,\n\t\t\tendContainer : doc,\n\t\t\tendOffset : 0,\n\t\t\tcollapsed : TRUE,\n\t\t\tcommonAncestorContainer : doc,\n\n\t\t\t// Range constants\n\t\t\tSTART_TO_START : 0,\n\t\t\tSTART_TO_END : 1,\n\t\t\tEND_TO_END : 2,\n\t\t\tEND_TO_START : 3,\n\n\t\t\t// Public methods\n\t\t\tsetStart : setStart,\n\t\t\tsetEnd : setEnd,\n\t\t\tsetStartBefore : setStartBefore,\n\t\t\tsetStartAfter : setStartAfter,\n\t\t\tsetEndBefore : setEndBefore,\n\t\t\tsetEndAfter : setEndAfter,\n\t\t\tcollapse : collapse,\n\t\t\tselectNode : selectNode,\n\t\t\tselectNodeContents : selectNodeContents,\n\t\t\tcompareBoundaryPoints : compareBoundaryPoints,\n\t\t\tdeleteContents : deleteContents,\n\t\t\textractContents : extractContents,\n\t\t\tcloneContents : cloneContents,\n\t\t\tinsertNode : insertNode,\n\t\t\tsurroundContents : surroundContents,\n\t\t\tcloneRange : cloneRange\n\t\t});\n\n\t\tfunction setStart(n, o) {\n\t\t\t_setEndPoint(TRUE, n, o);\n\t\t};\n\n\t\tfunction setEnd(n, o) {\n\t\t\t_setEndPoint(FALSE, n, o);\n\t\t};\n\n\t\tfunction setStartBefore(n) {\n\t\t\tsetStart(n.parentNode, nodeIndex(n));\n\t\t};\n\n\t\tfunction setStartAfter(n) {\n\t\t\tsetStart(n.parentNode, nodeIndex(n) + 1);\n\t\t};\n\n\t\tfunction setEndBefore(n) {\n\t\t\tsetEnd(n.parentNode, nodeIndex(n));\n\t\t};\n\n\t\tfunction setEndAfter(n) {\n\t\t\tsetEnd(n.parentNode, nodeIndex(n) + 1);\n\t\t};\n\n\t\tfunction collapse(ts) {\n\t\t\tif (ts) {\n\t\t\t\tt[END_CONTAINER] = t[START_CONTAINER];\n\t\t\t\tt[END_OFFSET] = t[START_OFFSET];\n\t\t\t} else {\n\t\t\t\tt[START_CONTAINER] = t[END_CONTAINER];\n\t\t\t\tt[START_OFFSET] = t[END_OFFSET];\n\t\t\t}\n\n\t\t\tt.collapsed = TRUE;\n\t\t};\n\n\t\tfunction selectNode(n) {\n\t\t\tsetStartBefore(n);\n\t\t\tsetEndAfter(n);\n\t\t};\n\n\t\tfunction selectNodeContents(n) {\n\t\t\tsetStart(n, 0);\n\t\t\tsetEnd(n, n.nodeType === 1 ? n.childNodes.length : n.nodeValue.length);\n\t\t};\n\n\t\tfunction compareBoundaryPoints(h, r) {\n\t\t\tvar sc = t[START_CONTAINER], so = t[START_OFFSET], ec = t[END_CONTAINER], eo = t[END_OFFSET],\n\t\t\trsc = r.startContainer, rso = r.startOffset, rec = r.endContainer, reo = r.endOffset;\n\n\t\t\t// Check START_TO_START\n\t\t\tif (h === 0)\n\t\t\t\treturn _compareBoundaryPoints(sc, so, rsc, rso);\n\n\t\t\t// Check START_TO_END\n\t\t\tif (h === 1)\n\t\t\t\treturn _compareBoundaryPoints(ec, eo, rsc, rso);\n\n\t\t\t// Check END_TO_END\n\t\t\tif (h === 2)\n\t\t\t\treturn _compareBoundaryPoints(ec, eo, rec, reo);\n\n\t\t\t// Check END_TO_START\n\t\t\tif (h === 3)\n\t\t\t\treturn _compareBoundaryPoints(sc, so, rec, reo);\n\t\t};\n\n\t\tfunction deleteContents() {\n\t\t\t_traverse(DELETE);\n\t\t};\n\n\t\tfunction extractContents() {\n\t\t\treturn _traverse(EXTRACT);\n\t\t};\n\n\t\tfunction cloneContents() {\n\t\t\treturn _traverse(CLONE);\n\t\t};\n\n\t\tfunction insertNode(n) {\n\t\t\tvar startContainer = this[START_CONTAINER],\n\t\t\t\tstartOffset = this[START_OFFSET], nn, o;\n\n\t\t\t// Node is TEXT_NODE or CDATA\n\t\t\tif ((startContainer.nodeType === 3 || startContainer.nodeType === 4) && startContainer.nodeValue) {\n\t\t\t\tif (!startOffset) {\n\t\t\t\t\t// At the start of text\n\t\t\t\t\tstartContainer.parentNode.insertBefore(n, startContainer);\n\t\t\t\t} else if (startOffset >= startContainer.nodeValue.length) {\n\t\t\t\t\t// At the end of text\n\t\t\t\t\tdom.insertAfter(n, startContainer);\n\t\t\t\t} else {\n\t\t\t\t\t// Middle, need to split\n\t\t\t\t\tnn = startContainer.splitText(startOffset);\n\t\t\t\t\tstartContainer.parentNode.insertBefore(n, nn);\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Insert element node\n\t\t\t\tif (startContainer.childNodes.length > 0)\n\t\t\t\t\to = startContainer.childNodes[startOffset];\n\n\t\t\t\tif (o)\n\t\t\t\t\tstartContainer.insertBefore(n, o);\n\t\t\t\telse\n\t\t\t\t\tstartContainer.appendChild(n);\n\t\t\t}\n\t\t};\n\n\t\tfunction surroundContents(n) {\n\t\t\tvar f = t.extractContents();\n\n\t\t\tt.insertNode(n);\n\t\t\tn.appendChild(f);\n\t\t\tt.selectNode(n);\n\t\t};\n\n\t\tfunction cloneRange() {\n\t\t\treturn extend(new Range(dom), {\n\t\t\t\tstartContainer : t[START_CONTAINER],\n\t\t\t\tstartOffset : t[START_OFFSET],\n\t\t\t\tendContainer : t[END_CONTAINER],\n\t\t\t\tendOffset : t[END_OFFSET],\n\t\t\t\tcollapsed : t.collapsed,\n\t\t\t\tcommonAncestorContainer : t.commonAncestorContainer\n\t\t\t});\n\t\t};\n\n\t\t// Private methods\n\n\t\tfunction _getSelectedNode(container, offset) {\n\t\t\tvar child;\n\n\t\t\tif (container.nodeType == 3 /* TEXT_NODE */)\n\t\t\t\treturn container;\n\n\t\t\tif (offset < 0)\n\t\t\t\treturn container;\n\n\t\t\tchild = container.firstChild;\n\t\t\twhile (child && offset > 0) {\n\t\t\t\t--offset;\n\t\t\t\tchild = child.nextSibling;\n\t\t\t}\n\n\t\t\tif (child)\n\t\t\t\treturn child;\n\n\t\t\treturn container;\n\t\t};\n\n\t\tfunction _isCollapsed() {\n\t\t\treturn (t[START_CONTAINER] == t[END_CONTAINER] && t[START_OFFSET] == t[END_OFFSET]);\n\t\t};\n\n\t\tfunction _compareBoundaryPoints(containerA, offsetA, containerB, offsetB) {\n\t\t\tvar c, offsetC, n, cmnRoot, childA, childB;\n\n\t\t\t// In the first case the boundary-points have the same container. A is before B\n\t\t\t// if its offset is less than the offset of B, A is equal to B if its offset is\n\t\t\t// equal to the offset of B, and A is after B if its offset is greater than the\n\t\t\t// offset of B.\n\t\t\tif (containerA == containerB) {\n\t\t\t\tif (offsetA == offsetB)\n\t\t\t\t\treturn 0; // equal\n\n\t\t\t\tif (offsetA < offsetB)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\treturn 1; // after\n\t\t\t}\n\n\t\t\t// In the second case a child node C of the container of A is an ancestor\n\t\t\t// container of B. In this case, A is before B if the offset of A is less than or\n\t\t\t// equal to the index of the child node C and A is after B otherwise.\n\t\t\tc = containerB;\n\t\t\twhile (c && c.parentNode != containerA)\n\t\t\t\tc = c.parentNode;\n\n\t\t\tif (c) {\n\t\t\t\toffsetC = 0;\n\t\t\t\tn = containerA.firstChild;\n\n\t\t\t\twhile (n != c && offsetC < offsetA) {\n\t\t\t\t\toffsetC++;\n\t\t\t\t\tn = n.nextSibling;\n\t\t\t\t}\n\n\t\t\t\tif (offsetA <= offsetC)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\treturn 1; // after\n\t\t\t}\n\n\t\t\t// In the third case a child node C of the container of B is an ancestor container\n\t\t\t// of A. In this case, A is before B if the index of the child node C is less than\n\t\t\t// the offset of B and A is after B otherwise.\n\t\t\tc = containerA;\n\t\t\twhile (c && c.parentNode != containerB) {\n\t\t\t\tc = c.parentNode;\n\t\t\t}\n\n\t\t\tif (c) {\n\t\t\t\toffsetC = 0;\n\t\t\t\tn = containerB.firstChild;\n\n\t\t\t\twhile (n != c && offsetC < offsetB) {\n\t\t\t\t\toffsetC++;\n\t\t\t\t\tn = n.nextSibling;\n\t\t\t\t}\n\n\t\t\t\tif (offsetC < offsetB)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\treturn 1; // after\n\t\t\t}\n\n\t\t\t// In the fourth case, none of three other cases hold: the containers of A and B\n\t\t\t// are siblings or descendants of sibling nodes. In this case, A is before B if\n\t\t\t// the container of A is before the container of B in a pre-order traversal of the\n\t\t\t// Ranges' context tree and A is after B otherwise.\n\t\t\tcmnRoot = dom.findCommonAncestor(containerA, containerB);\n\t\t\tchildA = containerA;\n\n\t\t\twhile (childA && childA.parentNode != cmnRoot)\n\t\t\t\tchildA = childA.parentNode;\n\n\t\t\tif (!childA)\n\t\t\t\tchildA = cmnRoot;\n\n\t\t\tchildB = containerB;\n\t\t\twhile (childB && childB.parentNode != cmnRoot)\n\t\t\t\tchildB = childB.parentNode;\n\n\t\t\tif (!childB)\n\t\t\t\tchildB = cmnRoot;\n\n\t\t\tif (childA == childB)\n\t\t\t\treturn 0; // equal\n\n\t\t\tn = cmnRoot.firstChild;\n\t\t\twhile (n) {\n\t\t\t\tif (n == childA)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\tif (n == childB)\n\t\t\t\t\treturn 1; // after\n\n\t\t\t\tn = n.nextSibling;\n\t\t\t}\n\t\t};\n\n\t\tfunction _setEndPoint(st, n, o) {\n\t\t\tvar ec, sc;\n\n\t\t\tif (st) {\n\t\t\t\tt[START_CONTAINER] = n;\n\t\t\t\tt[START_OFFSET] = o;\n\t\t\t} else {\n\t\t\t\tt[END_CONTAINER] = n;\n\t\t\t\tt[END_OFFSET] = o;\n\t\t\t}\n\n\t\t\t// If one boundary-point of a Range is set to have a root container\n\t\t\t// other than the current one for the Range, the Range is collapsed to\n\t\t\t// the new position. This enforces the restriction that both boundary-\n\t\t\t// points of a Range must have the same root container.\n\t\t\tec = t[END_CONTAINER];\n\t\t\twhile (ec.parentNode)\n\t\t\t\tec = ec.parentNode;\n\n\t\t\tsc = t[START_CONTAINER];\n\t\t\twhile (sc.parentNode)\n\t\t\t\tsc = sc.parentNode;\n\n\t\t\tif (sc == ec) {\n\t\t\t\t// The start position of a Range is guaranteed to never be after the\n\t\t\t\t// end position. To enforce this restriction, if the start is set to\n\t\t\t\t// be at a position after the end, the Range is collapsed to that\n\t\t\t\t// position.\n\t\t\t\tif (_compareBoundaryPoints(t[START_CONTAINER], t[START_OFFSET], t[END_CONTAINER], t[END_OFFSET]) > 0)\n\t\t\t\t\tt.collapse(st);\n\t\t\t} else\n\t\t\t\tt.collapse(st);\n\n\t\t\tt.collapsed = _isCollapsed();\n\t\t\tt.commonAncestorContainer = dom.findCommonAncestor(t[START_CONTAINER], t[END_CONTAINER]);\n\t\t};\n\n\t\tfunction _traverse(how) {\n\t\t\tvar c, endContainerDepth = 0, startContainerDepth = 0, p, depthDiff, startNode, endNode, sp, ep;\n\n\t\t\tif (t[START_CONTAINER] == t[END_CONTAINER])\n\t\t\t\treturn _traverseSameContainer(how);\n\n\t\t\tfor (c = t[END_CONTAINER], p = c.parentNode; p; c = p, p = p.parentNode) {\n\t\t\t\tif (p == t[START_CONTAINER])\n\t\t\t\t\treturn _traverseCommonStartContainer(c, how);\n\n\t\t\t\t++endContainerDepth;\n\t\t\t}\n\n\t\t\tfor (c = t[START_CONTAINER], p = c.parentNode; p; c = p, p = p.parentNode) {\n\t\t\t\tif (p == t[END_CONTAINER])\n\t\t\t\t\treturn _traverseCommonEndContainer(c, how);\n\n\t\t\t\t++startContainerDepth;\n\t\t\t}\n\n\t\t\tdepthDiff = startContainerDepth - endContainerDepth;\n\n\t\t\tstartNode = t[START_CONTAINER];\n\t\t\twhile (depthDiff > 0) {\n\t\t\t\tstartNode = startNode.parentNode;\n\t\t\t\tdepthDiff--;\n\t\t\t}\n\n\t\t\tendNode = t[END_CONTAINER];\n\t\t\twhile (depthDiff < 0) {\n\t\t\t\tendNode = endNode.parentNode;\n\t\t\t\tdepthDiff++;\n\t\t\t}\n\n\t\t\t// ascend the ancestor hierarchy until we have a common parent.\n\t\t\tfor (sp = startNode.parentNode, ep = endNode.parentNode; sp != ep; sp = sp.parentNode, ep = ep.parentNode) {\n\t\t\t\tstartNode = sp;\n\t\t\t\tendNode = ep;\n\t\t\t}\n\n\t\t\treturn _traverseCommonAncestors(startNode, endNode, how);\n\t\t};\n\n\t\t function _traverseSameContainer(how) {\n\t\t\tvar frag, s, sub, n, cnt, sibling, xferNode;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\t// If selection is empty, just return the fragment\n\t\t\tif (t[START_OFFSET] == t[END_OFFSET])\n\t\t\t\treturn frag;\n\n\t\t\t// Text node needs special case handling\n\t\t\tif (t[START_CONTAINER].nodeType == 3 /* TEXT_NODE */) {\n\t\t\t\t// get the substring\n\t\t\t\ts = t[START_CONTAINER].nodeValue;\n\t\t\t\tsub = s.substring(t[START_OFFSET], t[END_OFFSET]);\n\n\t\t\t\t// set the original text node to its new value\n\t\t\t\tif (how != CLONE) {\n\t\t\t\t\tt[START_CONTAINER].deleteData(t[START_OFFSET], t[END_OFFSET] - t[START_OFFSET]);\n\n\t\t\t\t\t// Nothing is partially selected, so collapse to start point\n\t\t\t\t\tt.collapse(TRUE);\n\t\t\t\t}\n\n\t\t\t\tif (how == DELETE)\n\t\t\t\t\treturn;\n\n\t\t\t\tfrag.appendChild(doc.createTextNode(sub));\n\t\t\t\treturn frag;\n\t\t\t}\n\n\t\t\t// Copy nodes between the start/end offsets.\n\t\t\tn = _getSelectedNode(t[START_CONTAINER], t[START_OFFSET]);\n\t\t\tcnt = t[END_OFFSET] - t[START_OFFSET];\n\n\t\t\twhile (cnt > 0) {\n\t\t\t\tsibling = n.nextSibling;\n\t\t\t\txferNode = _traverseFullySelected(n, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.appendChild( xferNode );\n\n\t\t\t\t--cnt;\n\t\t\t\tn = sibling;\n\t\t\t}\n\n\t\t\t// Nothing is partially selected, so collapse to start point\n\t\t\tif (how != CLONE)\n\t\t\t\tt.collapse(TRUE);\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseCommonStartContainer(endAncestor, how) {\n\t\t\tvar frag, n, endIdx, cnt, sibling, xferNode;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\tn = _traverseRightBoundary(endAncestor, how);\n\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tendIdx = nodeIndex(endAncestor);\n\t\t\tcnt = endIdx - t[START_OFFSET];\n\n\t\t\tif (cnt <= 0) {\n\t\t\t\t// Collapse to just before the endAncestor, which\n\t\t\t\t// is partially selected.\n\t\t\t\tif (how != CLONE) {\n\t\t\t\t\tt.setEndBefore(endAncestor);\n\t\t\t\t\tt.collapse(FALSE);\n\t\t\t\t}\n\n\t\t\t\treturn frag;\n\t\t\t}\n\n\t\t\tn = endAncestor.previousSibling;\n\t\t\twhile (cnt > 0) {\n\t\t\t\tsibling = n.previousSibling;\n\t\t\t\txferNode = _traverseFullySelected(n, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.insertBefore(xferNode, frag.firstChild);\n\n\t\t\t\t--cnt;\n\t\t\t\tn = sibling;\n\t\t\t}\n\n\t\t\t// Collapse to just before the endAncestor, which\n\t\t\t// is partially selected.\n\t\t\tif (how != CLONE) {\n\t\t\t\tt.setEndBefore(endAncestor);\n\t\t\t\tt.collapse(FALSE);\n\t\t\t}\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseCommonEndContainer(startAncestor, how) {\n\t\t\tvar frag, startIdx, n, cnt, sibling, xferNode;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\tn = _traverseLeftBoundary(startAncestor, how);\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tstartIdx = nodeIndex(startAncestor);\n\t\t\t++startIdx; // Because we already traversed it\n\n\t\t\tcnt = t[END_OFFSET] - startIdx;\n\t\t\tn = startAncestor.nextSibling;\n\t\t\twhile (cnt > 0) {\n\t\t\t\tsibling = n.nextSibling;\n\t\t\t\txferNode = _traverseFullySelected(n, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.appendChild(xferNode);\n\n\t\t\t\t--cnt;\n\t\t\t\tn = sibling;\n\t\t\t}\n\n\t\t\tif (how != CLONE) {\n\t\t\t\tt.setStartAfter(startAncestor);\n\t\t\t\tt.collapse(TRUE);\n\t\t\t}\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseCommonAncestors(startAncestor, endAncestor, how) {\n\t\t\tvar n, frag, commonParent, startOffset, endOffset, cnt, sibling, nextSibling;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\tn = _traverseLeftBoundary(startAncestor, how);\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tcommonParent = startAncestor.parentNode;\n\t\t\tstartOffset = nodeIndex(startAncestor);\n\t\t\tendOffset = nodeIndex(endAncestor);\n\t\t\t++startOffset;\n\n\t\t\tcnt = endOffset - startOffset;\n\t\t\tsibling = startAncestor.nextSibling;\n\n\t\t\twhile (cnt > 0) {\n\t\t\t\tnextSibling = sibling.nextSibling;\n\t\t\t\tn = _traverseFullySelected(sibling, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.appendChild(n);\n\n\t\t\t\tsibling = nextSibling;\n\t\t\t\t--cnt;\n\t\t\t}\n\n\t\t\tn = _traverseRightBoundary(endAncestor, how);\n\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tif (how != CLONE) {\n\t\t\t\tt.setStartAfter(startAncestor);\n\t\t\t\tt.collapse(TRUE);\n\t\t\t}\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseRightBoundary(root, how) {\n\t\t\tvar next = _getSelectedNode(t[END_CONTAINER], t[END_OFFSET] - 1), parent, clonedParent, prevSibling, clonedChild, clonedGrandParent, isFullySelected = next != t[END_CONTAINER];\n\n\t\t\tif (next == root)\n\t\t\t\treturn _traverseNode(next, isFullySelected, FALSE, how);\n\n\t\t\tparent = next.parentNode;\n\t\t\tclonedParent = _traverseNode(parent, FALSE, FALSE, how);\n\n\t\t\twhile (parent) {\n\t\t\t\twhile (next) {\n\t\t\t\t\tprevSibling = next.previousSibling;\n\t\t\t\t\tclonedChild = _traverseNode(next, isFullySelected, FALSE, how);\n\n\t\t\t\t\tif (how != DELETE)\n\t\t\t\t\t\tclonedParent.insertBefore(clonedChild, clonedParent.firstChild);\n\n\t\t\t\t\tisFullySelected = TRUE;\n\t\t\t\t\tnext = prevSibling;\n\t\t\t\t}\n\n\t\t\t\tif (parent == root)\n\t\t\t\t\treturn clonedParent;\n\n\t\t\t\tnext = parent.previousSibling;\n\t\t\t\tparent = parent.parentNode;\n\n\t\t\t\tclonedGrandParent = _traverseNode(parent, FALSE, FALSE, how);\n\n\t\t\t\tif (how != DELETE)\n\t\t\t\t\tclonedGrandParent.appendChild(clonedParent);\n\n\t\t\t\tclonedParent = clonedGrandParent;\n\t\t\t}\n\t\t};\n\n\t\tfunction _traverseLeftBoundary(root, how) {\n\t\t\tvar next = _getSelectedNode(t[START_CONTAINER], t[START_OFFSET]), isFullySelected = next != t[START_CONTAINER], parent, clonedParent, nextSibling, clonedChild, clonedGrandParent;\n\n\t\t\tif (next == root)\n\t\t\t\treturn _traverseNode(next, isFullySelected, TRUE, how);\n\n\t\t\tparent = next.parentNode;\n\t\t\tclonedParent = _traverseNode(parent, FALSE, TRUE, how);\n\n\t\t\twhile (parent) {\n\t\t\t\twhile (next) {\n\t\t\t\t\tnextSibling = next.nextSibling;\n\t\t\t\t\tclonedChild = _traverseNode(next, isFullySelected, TRUE, how);\n\n\t\t\t\t\tif (how != DELETE)\n\t\t\t\t\t\tclonedParent.appendChild(clonedChild);\n\n\t\t\t\t\tisFullySelected = TRUE;\n\t\t\t\t\tnext = nextSibling;\n\t\t\t\t}\n\n\t\t\t\tif (parent == root)\n\t\t\t\t\treturn clonedParent;\n\n\t\t\t\tnext = parent.nextSibling;\n\t\t\t\tparent = parent.parentNode;\n\n\t\t\t\tclonedGrandParent = _traverseNode(parent, FALSE, TRUE, how);\n\n\t\t\t\tif (how != DELETE)\n\t\t\t\t\tclonedGrandParent.appendChild(clonedParent);\n\n\t\t\t\tclonedParent = clonedGrandParent;\n\t\t\t}\n\t\t};\n\n\t\tfunction _traverseNode(n, isFullySelected, isLeft, how) {\n\t\t\tvar txtValue, newNodeValue, oldNodeValue, offset, newNode;\n\n\t\t\tif (isFullySelected)\n\t\t\t\treturn _traverseFullySelected(n, how);\n\n\t\t\tif (n.nodeType == 3 /* TEXT_NODE */) {\n\t\t\t\ttxtValue = n.nodeValue;\n\n\t\t\t\tif (isLeft) {\n\t\t\t\t\toffset = t[START_OFFSET];\n\t\t\t\t\tnewNodeValue = txtValue.substring(offset);\n\t\t\t\t\toldNodeValue = txtValue.substring(0, offset);\n\t\t\t\t} else {\n\t\t\t\t\toffset = t[END_OFFSET];\n\t\t\t\t\tnewNodeValue = txtValue.substring(0, offset);\n\t\t\t\t\toldNodeValue = txtValue.substring(offset);\n\t\t\t\t}\n\n\t\t\t\tif (how != CLONE)\n\t\t\t\t\tn.nodeValue = oldNodeValue;\n\n\t\t\t\tif (how == DELETE)\n\t\t\t\t\treturn;\n\n\t\t\t\tnewNode = n.cloneNode(FALSE);\n\t\t\t\tnewNode.nodeValue = newNodeValue;\n\n\t\t\t\treturn newNode;\n\t\t\t}\n\n\t\t\tif (how == DELETE)\n\t\t\t\treturn;\n\n\t\t\treturn n.cloneNode(FALSE);\n\t\t};\n\n\t\tfunction _traverseFullySelected(n, how) {\n\t\t\tif (how != DELETE)\n\t\t\t\treturn how == CLONE ? n.cloneNode(TRUE) : n;\n\n\t\t\tn.parentNode.removeChild(n);\n\t\t};\n\t};\n\n\tns.Range = Range;\n})(tinymce.dom);\n\n(function() {\n\tfunction Selection(selection) {\n\t\tvar self = this, dom = selection.dom, TRUE = true, FALSE = false;\n\n\t\tfunction getPosition(rng, start) {\n\t\t\tvar checkRng, startIndex = 0, endIndex, inside,\n\t\t\t\tchildren, child, offset, index, position = -1, parent;\n\n\t\t\t// Setup test range, collapse it and get the parent\n\t\t\tcheckRng = rng.duplicate();\n\t\t\tcheckRng.collapse(start);\n\t\t\tparent = checkRng.parentElement();\n\n\t\t\t// Check if the selection is within the right document\n\t\t\tif (parent.ownerDocument !== selection.dom.doc)\n\t\t\t\treturn;\n\n\t\t\t// IE will report non editable elements as it's parent so look for an editable one\n\t\t\twhile (parent.contentEditable === \"false\") {\n\t\t\t\tparent = parent.parentNode;\n\t\t\t}\n\n\t\t\t// If parent doesn't have any children then return that we are inside the element\n\t\t\tif (!parent.hasChildNodes()) {\n\t\t\t\treturn {node : parent, inside : 1};\n\t\t\t}\n\n\t\t\t// Setup node list and endIndex\n\t\t\tchildren = parent.children;\n\t\t\tendIndex = children.length - 1;\n\n\t\t\t// Perform a binary search for the position\n\t\t\twhile (startIndex <= endIndex) {\n\t\t\t\tindex = Math.floor((startIndex + endIndex) / 2);\n\n\t\t\t\t// Move selection to node and compare the ranges\n\t\t\t\tchild = children[index];\n\t\t\t\tcheckRng.moveToElementText(child);\n\t\t\t\tposition = checkRng.compareEndPoints(start ? 'StartToStart' : 'EndToEnd', rng);\n\n\t\t\t\t// Before/after or an exact match\n\t\t\t\tif (position > 0) {\n\t\t\t\t\tendIndex = index - 1;\n\t\t\t\t} else if (position < 0) {\n\t\t\t\t\tstartIndex = index + 1;\n\t\t\t\t} else {\n\t\t\t\t\treturn {node : child};\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Check if child position is before or we didn't find a position\n\t\t\tif (position < 0) {\n\t\t\t\t// No element child was found use the parent element and the offset inside that\n\t\t\t\tif (!child) {\n\t\t\t\t\tcheckRng.moveToElementText(parent);\n\t\t\t\t\tcheckRng.collapse(true);\n\t\t\t\t\tchild = parent;\n\t\t\t\t\tinside = true;\n\t\t\t\t} else\n\t\t\t\t\tcheckRng.collapse(false);\n\n\t\t\t\tcheckRng.setEndPoint(start ? 'EndToStart' : 'EndToEnd', rng);\n\n\t\t\t\t// Fix for edge case: <div style=\"width: 100px; height:100px;\"><table>..</table>ab|c</div>\n\t\t\t\tif (checkRng.compareEndPoints(start ? 'StartToStart' : 'StartToEnd', rng) > 0) {\n\t\t\t\t\tcheckRng = rng.duplicate();\n\t\t\t\t\tcheckRng.collapse(start);\n\n\t\t\t\t\toffset = -1;\n\t\t\t\t\twhile (parent == checkRng.parentElement()) {\n\t\t\t\t\t\tif (checkRng.move('character', -1) == 0)\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\toffset++;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\toffset = offset || checkRng.text.replace('\\r\\n', ' ').length;\n\t\t\t} else {\n\t\t\t\t// Child position is after the selection endpoint\n\t\t\t\tcheckRng.collapse(true);\n\t\t\t\tcheckRng.setEndPoint(start ? 'StartToStart' : 'StartToEnd', rng);\n\n\t\t\t\t// Get the length of the text to find where the endpoint is relative to it's container\n\t\t\t\toffset = checkRng.text.replace('\\r\\n', ' ').length;\n\t\t\t}\n\n\t\t\treturn {node : child, position : position, offset : offset, inside : inside};\n\t\t};\n\n\t\t// Returns a W3C DOM compatible range object by using the IE Range API\n\t\tfunction getRange() {\n\t\t\tvar ieRange = selection.getRng(), domRange = dom.createRng(), element, collapsed, tmpRange, element2, bookmark, fail;\n\n\t\t\t// If selection is outside the current document just return an empty range\n\t\t\telement = ieRange.item ? ieRange.item(0) : ieRange.parentElement();\n\t\t\tif (element.ownerDocument != dom.doc)\n\t\t\t\treturn domRange;\n\n\t\t\tcollapsed = selection.isCollapsed();\n\n\t\t\t// Handle control selection\n\t\t\tif (ieRange.item) {\n\t\t\t\tdomRange.setStart(element.parentNode, dom.nodeIndex(element));\n\t\t\t\tdomRange.setEnd(domRange.startContainer, domRange.startOffset + 1);\n\n\t\t\t\treturn domRange;\n\t\t\t}\n\n\t\t\tfunction findEndPoint(start) {\n\t\t\t\tvar endPoint = getPosition(ieRange, start), container, offset, textNodeOffset = 0, sibling, undef, nodeValue;\n\n\t\t\t\tcontainer = endPoint.node;\n\t\t\t\toffset = endPoint.offset;\n\n\t\t\t\tif (endPoint.inside && !container.hasChildNodes()) {\n\t\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](container, 0);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (offset === undef) {\n\t\t\t\t\tdomRange[start ? 'setStartBefore' : 'setEndAfter'](container);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (endPoint.position < 0) {\n\t\t\t\t\tsibling = endPoint.inside ? container.firstChild : container.nextSibling;\n\n\t\t\t\t\tif (!sibling) {\n\t\t\t\t\t\tdomRange[start ? 'setStartAfter' : 'setEndAfter'](container);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!offset) {\n\t\t\t\t\t\tif (sibling.nodeType == 3)\n\t\t\t\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](sibling, 0);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tdomRange[start ? 'setStartBefore' : 'setEndBefore'](sibling);\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Find the text node and offset\n\t\t\t\t\twhile (sibling) {\n\t\t\t\t\t\tnodeValue = sibling.nodeValue;\n\t\t\t\t\t\ttextNodeOffset += nodeValue.length;\n\n\t\t\t\t\t\t// We are at or passed the position we where looking for\n\t\t\t\t\t\tif (textNodeOffset >= offset) {\n\t\t\t\t\t\t\tcontainer = sibling;\n\t\t\t\t\t\t\ttextNodeOffset -= offset;\n\t\t\t\t\t\t\ttextNodeOffset = nodeValue.length - textNodeOffset;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tsibling = sibling.nextSibling;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\t// Find the text node and offset\n\t\t\t\t\tsibling = container.previousSibling;\n\n\t\t\t\t\tif (!sibling)\n\t\t\t\t\t\treturn domRange[start ? 'setStartBefore' : 'setEndBefore'](container);\n\n\t\t\t\t\t// If there isn't any text to loop then use the first position\n\t\t\t\t\tif (!offset) {\n\t\t\t\t\t\tif (container.nodeType == 3)\n\t\t\t\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](sibling, container.nodeValue.length);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tdomRange[start ? 'setStartAfter' : 'setEndAfter'](sibling);\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\twhile (sibling) {\n\t\t\t\t\t\ttextNodeOffset += sibling.nodeValue.length;\n\n\t\t\t\t\t\t// We are at or passed the position we where looking for\n\t\t\t\t\t\tif (textNodeOffset >= offset) {\n\t\t\t\t\t\t\tcontainer = sibling;\n\t\t\t\t\t\t\ttextNodeOffset -= offset;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tsibling = sibling.previousSibling;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](container, textNodeOffset);\n\t\t\t};\n\n\t\t\ttry {\n\t\t\t\t// Find start point\n\t\t\t\tfindEndPoint(true);\n\n\t\t\t\t// Find end point if needed\n\t\t\t\tif (!collapsed)\n\t\t\t\t\tfindEndPoint();\n\t\t\t} catch (ex) {\n\t\t\t\t// IE has a nasty bug where text nodes might throw \"invalid argument\" when you\n\t\t\t\t// access the nodeValue or other properties of text nodes. This seems to happend when\n\t\t\t\t// text nodes are split into two nodes by a delete/backspace call. So lets detect it and try to fix it.\n\t\t\t\tif (ex.number == -2147024809) {\n\t\t\t\t\t// Get the current selection\n\t\t\t\t\tbookmark = self.getBookmark(2);\n\n\t\t\t\t\t// Get start element\n\t\t\t\t\ttmpRange = ieRange.duplicate();\n\t\t\t\t\ttmpRange.collapse(true);\n\t\t\t\t\telement = tmpRange.parentElement();\n\n\t\t\t\t\t// Get end element\n\t\t\t\t\tif (!collapsed) {\n\t\t\t\t\t\ttmpRange = ieRange.duplicate();\n\t\t\t\t\t\ttmpRange.collapse(false);\n\t\t\t\t\t\telement2 = tmpRange.parentElement();\n\t\t\t\t\t\telement2.innerHTML = element2.innerHTML;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove the broken elements\n\t\t\t\t\telement.innerHTML = element.innerHTML;\n\n\t\t\t\t\t// Restore the selection\n\t\t\t\t\tself.moveToBookmark(bookmark);\n\n\t\t\t\t\t// Since the range has moved we need to re-get it\n\t\t\t\t\tieRange = selection.getRng();\n\n\t\t\t\t\t// Find start point\n\t\t\t\t\tfindEndPoint(true);\n\n\t\t\t\t\t// Find end point if needed\n\t\t\t\t\tif (!collapsed)\n\t\t\t\t\t\tfindEndPoint();\n\t\t\t\t} else\n\t\t\t\t\tthrow ex; // Throw other errors\n\t\t\t}\n\n\t\t\treturn domRange;\n\t\t};\n\n\t\tthis.getBookmark = function(type) {\n\t\t\tvar rng = selection.getRng(), start, end, bookmark = {};\n\n\t\t\tfunction getIndexes(node) {\n\t\t\t\tvar node, parent, root, children, i, indexes = [];\n\n\t\t\t\tparent = node.parentNode;\n\t\t\t\troot = dom.getRoot().parentNode;\n\n\t\t\t\twhile (parent != root && parent.nodeType !== 9) {\n\t\t\t\t\tchildren = parent.children;\n\n\t\t\t\t\ti = children.length;\n\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\tif (node === children[i]) {\n\t\t\t\t\t\t\tindexes.push(i);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = parent;\n\t\t\t\t\tparent = parent.parentNode;\n\t\t\t\t}\n\n\t\t\t\treturn indexes;\n\t\t\t};\n\n\t\t\tfunction getBookmarkEndPoint(start) {\n\t\t\t\tvar position;\n\n\t\t\t\tposition = getPosition(rng, start);\n\t\t\t\tif (position) {\n\t\t\t\t\treturn {\n\t\t\t\t\t\tposition : position.position,\n\t\t\t\t\t\toffset : position.offset,\n\t\t\t\t\t\tindexes : getIndexes(position.node),\n\t\t\t\t\t\tinside : position.inside\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Non ubstructive bookmark\n\t\t\tif (type === 2) {\n\t\t\t\t// Handle text selection\n\t\t\t\tif (!rng.item) {\n\t\t\t\t\tbookmark.start = getBookmarkEndPoint(true);\n\n\t\t\t\t\tif (!selection.isCollapsed())\n\t\t\t\t\t\tbookmark.end = getBookmarkEndPoint();\n\t\t\t\t} else\n\t\t\t\t\tbookmark.start = {ctrl : true, indexes : getIndexes(rng.item(0))};\n\t\t\t}\n\n\t\t\treturn bookmark;\n\t\t};\n\n\t\tthis.moveToBookmark = function(bookmark) {\n\t\t\tvar rng, body = dom.doc.body;\n\n\t\t\tfunction resolveIndexes(indexes) {\n\t\t\t\tvar node, i, idx, children;\n\n\t\t\t\tnode = dom.getRoot();\n\t\t\t\tfor (i = indexes.length - 1; i >= 0; i--) {\n\t\t\t\t\tchildren = node.children;\n\t\t\t\t\tidx = indexes[i];\n\n\t\t\t\t\tif (idx <= children.length - 1) {\n\t\t\t\t\t\tnode = children[idx];\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn node;\n\t\t\t};\n\n\t\t\tfunction setBookmarkEndPoint(start) {\n\t\t\t\tvar endPoint = bookmark[start ? 'start' : 'end'], moveLeft, moveRng, undef;\n\n\t\t\t\tif (endPoint) {\n\t\t\t\t\tmoveLeft = endPoint.position > 0;\n\n\t\t\t\t\tmoveRng = body.createTextRange();\n\t\t\t\t\tmoveRng.moveToElementText(resolveIndexes(endPoint.indexes));\n\n\t\t\t\t\toffset = endPoint.offset;\n\t\t\t\t\tif (offset !== undef) {\n\t\t\t\t\t\tmoveRng.collapse(endPoint.inside || moveLeft);\n\t\t\t\t\t\tmoveRng.moveStart('character', moveLeft ? -offset : offset);\n\t\t\t\t\t} else\n\t\t\t\t\t\tmoveRng.collapse(start);\n\n\t\t\t\t\trng.setEndPoint(start ? 'StartToStart' : 'EndToStart', moveRng);\n\n\t\t\t\t\tif (start)\n\t\t\t\t\t\trng.collapse(true);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tif (bookmark.start) {\n\t\t\t\tif (bookmark.start.ctrl) {\n\t\t\t\t\trng = body.createControlRange();\n\t\t\t\t\trng.addElement(resolveIndexes(bookmark.start.indexes));\n\t\t\t\t\trng.select();\n\t\t\t\t} else {\n\t\t\t\t\trng = body.createTextRange();\n\t\t\t\t\tsetBookmarkEndPoint(true);\n\t\t\t\t\tsetBookmarkEndPoint();\n\t\t\t\t\trng.select();\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tthis.addRange = function(rng) {\n\t\t\tvar ieRng, ctrlRng, startContainer, startOffset, endContainer, endOffset, doc = selection.dom.doc, body = doc.body;\n\n\t\t\tfunction setEndPoint(start) {\n\t\t\t\tvar container, offset, marker, tmpRng, nodes;\n\n\t\t\t\tmarker = dom.create('a');\n\t\t\t\tcontainer = start ? startContainer : endContainer;\n\t\t\t\toffset = start ? startOffset : endOffset;\n\t\t\t\ttmpRng = ieRng.duplicate();\n\n\t\t\t\tif (container == doc || container == doc.documentElement) {\n\t\t\t\t\tcontainer = body;\n\t\t\t\t\toffset = 0;\n\t\t\t\t}\n\n\t\t\t\tif (container.nodeType == 3) {\n\t\t\t\t\tcontainer.parentNode.insertBefore(marker, container);\n\t\t\t\t\ttmpRng.moveToElementText(marker);\n\t\t\t\t\ttmpRng.moveStart('character', offset);\n\t\t\t\t\tdom.remove(marker);\n\t\t\t\t\tieRng.setEndPoint(start ? 'StartToStart' : 'EndToEnd', tmpRng);\n\t\t\t\t} else {\n\t\t\t\t\tnodes = container.childNodes;\n\n\t\t\t\t\tif (nodes.length) {\n\t\t\t\t\t\tif (offset >= nodes.length) {\n\t\t\t\t\t\t\tdom.insertAfter(marker, nodes[nodes.length - 1]);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tcontainer.insertBefore(marker, nodes[offset]);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\ttmpRng.moveToElementText(marker);\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Empty node selection for example <div>|</div>\n\t\t\t\t\t\tmarker = doc.createTextNode('\\uFEFF');\n\t\t\t\t\t\tcontainer.appendChild(marker);\n\t\t\t\t\t\ttmpRng.moveToElementText(marker.parentNode);\n\t\t\t\t\t\ttmpRng.collapse(TRUE);\n\t\t\t\t\t}\n\n\t\t\t\t\tieRng.setEndPoint(start ? 'StartToStart' : 'EndToEnd', tmpRng);\n\t\t\t\t\tdom.remove(marker);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Setup some shorter versions\n\t\t\tstartContainer = rng.startContainer;\n\t\t\tstartOffset = rng.startOffset;\n\t\t\tendContainer = rng.endContainer;\n\t\t\tendOffset = rng.endOffset;\n\t\t\tieRng = body.createTextRange();\n\n\t\t\t// If single element selection then try making a control selection out of it\n\t\t\tif (startContainer == endContainer && startContainer.nodeType == 1 && startOffset == endOffset - 1) {\n\t\t\t\tif (startOffset == endOffset - 1) {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tctrlRng = body.createControlRange();\n\t\t\t\t\t\tctrlRng.addElement(startContainer.childNodes[startOffset]);\n\t\t\t\t\t\tctrlRng.select();\n\t\t\t\t\t\treturn;\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// Ignore\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Set start/end point of selection\n\t\t\tsetEndPoint(true);\n\t\t\tsetEndPoint();\n\n\t\t\t// Select the new range and scroll it into view\n\t\t\tieRng.select();\n\t\t};\n\n\t\t// Expose range method\n\t\tthis.getRangeAt = getRange;\n\t};\n\n\t// Expose the selection object\n\ttinymce.dom.TridentSelection = Selection;\n})();\n\n\n(function(tinymce) {\n\t// Shorten names\n\tvar each = tinymce.each, DOM = tinymce.DOM, isIE = tinymce.isIE, isWebKit = tinymce.isWebKit, Event;\n\n\ttinymce.create('tinymce.dom.EventUtils', {\n\t\tEventUtils : function() {\n\t\t\tthis.inits = [];\n\t\t\tthis.events = [];\n\t\t},\n\n\t\tadd : function(o, n, f, s) {\n\t\t\tvar cb, t = this, el = t.events, r;\n\n\t\t\tif (n instanceof Array) {\n\t\t\t\tr = [];\n\n\t\t\t\teach(n, function(n) {\n\t\t\t\t\tr.push(t.add(o, n, f, s));\n\t\t\t\t});\n\n\t\t\t\treturn r;\n\t\t\t}\n\n\t\t\t// Handle array\n\t\t\tif (o && o.hasOwnProperty && o instanceof Array) {\n\t\t\t\tr = [];\n\n\t\t\t\teach(o, function(o) {\n\t\t\t\t\to = DOM.get(o);\n\t\t\t\t\tr.push(t.add(o, n, f, s));\n\t\t\t\t});\n\n\t\t\t\treturn r;\n\t\t\t}\n\n\t\t\to = DOM.get(o);\n\n\t\t\tif (!o)\n\t\t\t\treturn;\n\n\t\t\t// Setup event callback\n\t\t\tcb = function(e) {\n\t\t\t\t// Is all events disabled\n\t\t\t\tif (t.disabled)\n\t\t\t\t\treturn;\n\n\t\t\t\te = e || window.event;\n\n\t\t\t\t// Patch in target, preventDefault and stopPropagation in IE it's W3C valid\n\t\t\t\tif (e && isIE) {\n\t\t\t\t\tif (!e.target)\n\t\t\t\t\t\te.target = e.srcElement;\n\n\t\t\t\t\t// Patch in preventDefault, stopPropagation methods for W3C compatibility\n\t\t\t\t\ttinymce.extend(e, t._stoppers);\n\t\t\t\t}\n\n\t\t\t\tif (!s)\n\t\t\t\t\treturn f(e);\n\n\t\t\t\treturn f.call(s, e);\n\t\t\t};\n\n\t\t\tif (n == 'unload') {\n\t\t\t\ttinymce.unloads.unshift({func : cb});\n\t\t\t\treturn cb;\n\t\t\t}\n\n\t\t\tif (n == 'init') {\n\t\t\t\tif (t.domLoaded)\n\t\t\t\t\tcb();\n\t\t\t\telse\n\t\t\t\t\tt.inits.push(cb);\n\n\t\t\t\treturn cb;\n\t\t\t}\n\n\t\t\t// Store away listener reference\n\t\t\tel.push({\n\t\t\t\tobj : o,\n\t\t\t\tname : n,\n\t\t\t\tfunc : f,\n\t\t\t\tcfunc : cb,\n\t\t\t\tscope : s\n\t\t\t});\n\n\t\t\tt._add(o, n, cb);\n\n\t\t\treturn f;\n\t\t},\n\n\t\tremove : function(o, n, f) {\n\t\t\tvar t = this, a = t.events, s = false, r;\n\n\t\t\t// Handle array\n\t\t\tif (o && o.hasOwnProperty && o instanceof Array) {\n\t\t\t\tr = [];\n\n\t\t\t\teach(o, function(o) {\n\t\t\t\t\to = DOM.get(o);\n\t\t\t\t\tr.push(t.remove(o, n, f));\n\t\t\t\t});\n\n\t\t\t\treturn r;\n\t\t\t}\n\n\t\t\to = DOM.get(o);\n\n\t\t\teach(a, function(e, i) {\n\t\t\t\tif (e.obj == o && e.name == n && (!f || (e.func == f || e.cfunc == f))) {\n\t\t\t\t\ta.splice(i, 1);\n\t\t\t\t\tt._remove(o, n, e.cfunc);\n\t\t\t\t\ts = true;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn s;\n\t\t},\n\n\t\tclear : function(o) {\n\t\t\tvar t = this, a = t.events, i, e;\n\n\t\t\tif (o) {\n\t\t\t\to = DOM.get(o);\n\n\t\t\t\tfor (i = a.length - 1; i >= 0; i--) {\n\t\t\t\t\te = a[i];\n\n\t\t\t\t\tif (e.obj === o) {\n\t\t\t\t\t\tt._remove(e.obj, e.name, e.cfunc);\n\t\t\t\t\t\te.obj = e.cfunc = null;\n\t\t\t\t\t\ta.splice(i, 1);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tcancel : function(e) {\n\t\t\tif (!e)\n\t\t\t\treturn false;\n\n\t\t\tthis.stop(e);\n\n\t\t\treturn this.prevent(e);\n\t\t},\n\n\t\tstop : function(e) {\n\t\t\tif (e.stopPropagation)\n\t\t\t\te.stopPropagation();\n\t\t\telse\n\t\t\t\te.cancelBubble = true;\n\n\t\t\treturn false;\n\t\t},\n\n\t\tprevent : function(e) {\n\t\t\tif (e.preventDefault)\n\t\t\t\te.preventDefault();\n\t\t\telse\n\t\t\t\te.returnValue = false;\n\n\t\t\treturn false;\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tvar t = this;\n\n\t\t\teach(t.events, function(e, i) {\n\t\t\t\tt._remove(e.obj, e.name, e.cfunc);\n\t\t\t\te.obj = e.cfunc = null;\n\t\t\t});\n\n\t\t\tt.events = [];\n\t\t\tt = null;\n\t\t},\n\n\t\t_add : function(o, n, f) {\n\t\t\tif (o.attachEvent)\n\t\t\t\to.attachEvent('on' + n, f);\n\t\t\telse if (o.addEventListener)\n\t\t\t\to.addEventListener(n, f, false);\n\t\t\telse\n\t\t\t\to['on' + n] = f;\n\t\t},\n\n\t\t_remove : function(o, n, f) {\n\t\t\tif (o) {\n\t\t\t\ttry {\n\t\t\t\t\tif (o.detachEvent)\n\t\t\t\t\t\to.detachEvent('on' + n, f);\n\t\t\t\t\telse if (o.removeEventListener)\n\t\t\t\t\t\to.removeEventListener(n, f, false);\n\t\t\t\t\telse\n\t\t\t\t\t\to['on' + n] = null;\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Might fail with permission denined on IE so we just ignore that\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t_pageInit : function(win) {\n\t\t\tvar t = this;\n\n\t\t\t// Keep it from running more than once\n\t\t\tif (t.domLoaded)\n\t\t\t\treturn;\n\n\t\t\tt.domLoaded = true;\n\n\t\t\teach(t.inits, function(c) {\n\t\t\t\tc();\n\t\t\t});\n\n\t\t\tt.inits = [];\n\t\t},\n\n\t\t_wait : function(win) {\n\t\t\tvar t = this, doc = win.document;\n\n\t\t\t// No need since the document is already loaded\n\t\t\tif (win.tinyMCE_GZ && tinyMCE_GZ.loaded) {\n\t\t\t\tt.domLoaded = 1;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Use IE method\n\t\t\tif (doc.attachEvent) {\n\t\t\t\tdoc.attachEvent(\"onreadystatechange\", function() {\n\t\t\t\t\tif (doc.readyState === \"complete\") {\n\t\t\t\t\t\tdoc.detachEvent(\"onreadystatechange\", arguments.callee);\n\t\t\t\t\t\tt._pageInit(win);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tif (doc.documentElement.doScroll && win == win.top) {\n\t\t\t\t\t(function() {\n\t\t\t\t\t\tif (t.domLoaded)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t// If IE is used, use the trick by Diego Perini licensed under MIT by request to the author.\n\t\t\t\t\t\t\t// http://javascript.nwbox.com/IEContentLoaded/\n\t\t\t\t\t\t\tdoc.documentElement.doScroll(\"left\");\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\tsetTimeout(arguments.callee, 0);\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tt._pageInit(win);\n\t\t\t\t\t})();\n\t\t\t\t}\n\t\t\t} else if (doc.addEventListener) {\n\t\t\t\tt._add(win, 'DOMContentLoaded', function() {\n\t\t\t\t\tt._pageInit(win);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tt._add(win, 'load', function() {\n\t\t\t\tt._pageInit(win);\n\t\t\t});\n\t\t},\n\n\t\t_stoppers : {\n\t\t\tpreventDefault : function() {\n\t\t\t\tthis.returnValue = false;\n\t\t\t},\n\n\t\t\tstopPropagation : function() {\n\t\t\t\tthis.cancelBubble = true;\n\t\t\t}\n\t\t}\n\t});\n\n\tEvent = tinymce.dom.Event = new tinymce.dom.EventUtils();\n\n\t// Dispatch DOM content loaded event for IE and Safari\n\tEvent._wait(window);\n\n\ttinymce.addUnload(function() {\n\t\tEvent.destroy();\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\ttinymce.dom.Element = function(id, settings) {\n\t\tvar t = this, dom, el;\n\n\t\tt.settings = settings = settings || {};\n\t\tt.id = id;\n\t\tt.dom = dom = settings.dom || tinymce.DOM;\n\n\t\t// Only IE leaks DOM references, this is a lot faster\n\t\tif (!tinymce.isIE)\n\t\t\tel = dom.get(t.id);\n\n\t\ttinymce.each(\n\t\t\t\t('getPos,getRect,getParent,add,setStyle,getStyle,setStyles,' +\n\t\t\t\t'setAttrib,setAttribs,getAttrib,addClass,removeClass,' +\n\t\t\t\t'hasClass,getOuterHTML,setOuterHTML,remove,show,hide,' +\n\t\t\t\t'isHidden,setHTML,get').split(/,/)\n\t\t\t, function(k) {\n\t\t\t\tt[k] = function() {\n\t\t\t\t\tvar a = [id], i;\n\n\t\t\t\t\tfor (i = 0; i < arguments.length; i++)\n\t\t\t\t\t\ta.push(arguments[i]);\n\n\t\t\t\t\ta = dom[k].apply(dom, a);\n\t\t\t\t\tt.update(k);\n\n\t\t\t\t\treturn a;\n\t\t\t\t};\n\t\t});\n\n\t\ttinymce.extend(t, {\n\t\t\ton : function(n, f, s) {\n\t\t\t\treturn tinymce.dom.Event.add(t.id, n, f, s);\n\t\t\t},\n\n\t\t\tgetXY : function() {\n\t\t\t\treturn {\n\t\t\t\t\tx : parseInt(t.getStyle('left')),\n\t\t\t\t\ty : parseInt(t.getStyle('top'))\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tgetSize : function() {\n\t\t\t\tvar n = dom.get(t.id);\n\n\t\t\t\treturn {\n\t\t\t\t\tw : parseInt(t.getStyle('width') || n.clientWidth),\n\t\t\t\t\th : parseInt(t.getStyle('height') || n.clientHeight)\n\t\t\t\t};\n\t\t\t},\n\n\t\t\tmoveTo : function(x, y) {\n\t\t\t\tt.setStyles({left : x, top : y});\n\t\t\t},\n\n\t\t\tmoveBy : function(x, y) {\n\t\t\t\tvar p = t.getXY();\n\n\t\t\t\tt.moveTo(p.x + x, p.y + y);\n\t\t\t},\n\n\t\t\tresizeTo : function(w, h) {\n\t\t\t\tt.setStyles({width : w, height : h});\n\t\t\t},\n\n\t\t\tresizeBy : function(w, h) {\n\t\t\t\tvar s = t.getSize();\n\n\t\t\t\tt.resizeTo(s.w + w, s.h + h);\n\t\t\t},\n\n\t\t\tupdate : function(k) {\n\t\t\t\tvar b;\n\n\t\t\t\tif (tinymce.isIE6 && settings.blocker) {\n\t\t\t\t\tk = k || '';\n\n\t\t\t\t\t// Ignore getters\n\t\t\t\t\tif (k.indexOf('get') === 0 || k.indexOf('has') === 0 || k.indexOf('is') === 0)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Remove blocker on remove\n\t\t\t\t\tif (k == 'remove') {\n\t\t\t\t\t\tdom.remove(t.blocker);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!t.blocker) {\n\t\t\t\t\t\tt.blocker = dom.uniqueId();\n\t\t\t\t\t\tb = dom.add(settings.container || dom.getRoot(), 'iframe', {id : t.blocker, style : 'position:absolute;', frameBorder : 0, src : 'javascript:\"\"'});\n\t\t\t\t\t\tdom.setStyle(b, 'opacity', 0);\n\t\t\t\t\t} else\n\t\t\t\t\t\tb = dom.get(t.blocker);\n\n\t\t\t\t\tdom.setStyles(b, {\n\t\t\t\t\t\tleft : t.getStyle('left', 1),\n\t\t\t\t\t\ttop : t.getStyle('top', 1),\n\t\t\t\t\t\twidth : t.getStyle('width', 1),\n\t\t\t\t\t\theight : t.getStyle('height', 1),\n\t\t\t\t\t\tdisplay : t.getStyle('display', 1),\n\t\t\t\t\t\tzIndex : parseInt(t.getStyle('zIndex', 1) || 0) - 1\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t};\n})(tinymce);\n\n(function(tinymce) {\n\tfunction trimNl(s) {\n\t\treturn s.replace(/[\\n\\r]+/g, '');\n\t};\n\n\t// Shorten names\n\tvar is = tinymce.is, isIE = tinymce.isIE, each = tinymce.each;\n\n\ttinymce.create('tinymce.dom.Selection', {\n\t\tSelection : function(dom, win, serializer) {\n\t\t\tvar t = this;\n\n\t\t\tt.dom = dom;\n\t\t\tt.win = win;\n\t\t\tt.serializer = serializer;\n\n\t\t\t// Add events\n\t\t\teach([\n\t\t\t\t'onBeforeSetContent',\n\n\t\t\t\t'onBeforeGetContent',\n\n\t\t\t\t'onSetContent',\n\n\t\t\t\t'onGetContent'\n\t\t\t], function(e) {\n\t\t\t\tt[e] = new tinymce.util.Dispatcher(t);\n\t\t\t});\n\n\t\t\t// No W3C Range support\n\t\t\tif (!t.win.getSelection)\n\t\t\t\tt.tridentSel = new tinymce.dom.TridentSelection(t);\n\n\t\t\tif (tinymce.isIE && dom.boxModel)\n\t\t\t\tthis._fixIESelection();\n\n\t\t\t// Prevent leaks\n\t\t\ttinymce.addUnload(t.destroy, t);\n\t\t},\n\n\t\tsetCursorLocation: function(node, offset) {\n\t\t\tvar t = this; var r = t.dom.createRng();\n\t\t\tr.setStart(node, offset);\n\t\t\tr.setEnd(node, offset);\n\t\t\tt.setRng(r);\n\t\t\tt.collapse(false);\n\t\t},\n\t\tgetContent : function(s) {\n\t\t\tvar t = this, r = t.getRng(), e = t.dom.create(\"body\"), se = t.getSel(), wb, wa, n;\n\n\t\t\ts = s || {};\n\t\t\twb = wa = '';\n\t\t\ts.get = true;\n\t\t\ts.format = s.format || 'html';\n\t\t\ts.forced_root_block = '';\n\t\t\tt.onBeforeGetContent.dispatch(t, s);\n\n\t\t\tif (s.format == 'text')\n\t\t\t\treturn t.isCollapsed() ? '' : (r.text || (se.toString ? se.toString() : ''));\n\n\t\t\tif (r.cloneContents) {\n\t\t\t\tn = r.cloneContents();\n\n\t\t\t\tif (n)\n\t\t\t\t\te.appendChild(n);\n\t\t\t} else if (is(r.item) || is(r.htmlText)) {\n\t\t\t\t// IE will produce invalid markup if elements are present that\n\t\t\t\t// it doesn't understand like custom elements or HTML5 elements.\n\t\t\t\t// Adding a BR in front of the contents and then remoiving it seems to fix it though.\n\t\t\t\te.innerHTML = '<br>' + (r.item ? r.item(0).outerHTML : r.htmlText);\n\t\t\t\te.removeChild(e.firstChild);\n\t\t\t} else\n\t\t\t\te.innerHTML = r.toString();\n\n\t\t\t// Keep whitespace before and after\n\t\t\tif (/^\\s/.test(e.innerHTML))\n\t\t\t\twb = ' ';\n\n\t\t\tif (/\\s+$/.test(e.innerHTML))\n\t\t\t\twa = ' ';\n\n\t\t\ts.getInner = true;\n\n\t\t\ts.content = t.isCollapsed() ? '' : wb + t.serializer.serialize(e, s) + wa;\n\t\t\tt.onGetContent.dispatch(t, s);\n\n\t\t\treturn s.content;\n\t\t},\n\n\t\tsetContent : function(content, args) {\n\t\t\tvar self = this, rng = self.getRng(), caretNode, doc = self.win.document, frag, temp;\n\n\t\t\targs = args || {format : 'html'};\n\t\t\targs.set = true;\n\t\t\tcontent = args.content = content;\n\n\t\t\t// Dispatch before set content event\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onBeforeSetContent.dispatch(self, args);\n\n\t\t\tcontent = args.content;\n\n\t\t\tif (rng.insertNode) {\n\t\t\t\t// Make caret marker since insertNode places the caret in the beginning of text after insert\n\t\t\t\tcontent += '<span id=\"__caret\">_</span>';\n\n\t\t\t\t// Delete and insert new node\n\t\t\t\tif (rng.startContainer == doc && rng.endContainer == doc) {\n\t\t\t\t\t// WebKit will fail if the body is empty since the range is then invalid and it can't insert contents\n\t\t\t\t\tdoc.body.innerHTML = content;\n\t\t\t\t} else {\n\t\t\t\t\trng.deleteContents();\n\n\t\t\t\t\tif (doc.body.childNodes.length == 0) {\n\t\t\t\t\t\tdoc.body.innerHTML = content;\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// createContextualFragment doesn't exists in IE 9 DOMRanges\n\t\t\t\t\t\tif (rng.createContextualFragment) {\n\t\t\t\t\t\t\trng.insertNode(rng.createContextualFragment(content));\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Fake createContextualFragment call in IE 9\n\t\t\t\t\t\t\tfrag = doc.createDocumentFragment();\n\t\t\t\t\t\t\ttemp = doc.createElement('div');\n\n\t\t\t\t\t\t\tfrag.appendChild(temp);\n\t\t\t\t\t\t\ttemp.outerHTML = content;\n\n\t\t\t\t\t\t\trng.insertNode(frag);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Move to caret marker\n\t\t\t\tcaretNode = self.dom.get('__caret');\n\n\t\t\t\t// Make sure we wrap it compleatly, Opera fails with a simple select call\n\t\t\t\trng = doc.createRange();\n\t\t\t\trng.setStartBefore(caretNode);\n\t\t\t\trng.setEndBefore(caretNode);\n\t\t\t\tself.setRng(rng);\n\n\t\t\t\t// Remove the caret position\n\t\t\t\tself.dom.remove('__caret');\n\n\t\t\t\ttry {\n\t\t\t\t\tself.setRng(rng);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Might fail on Opera for some odd reason\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tif (rng.item) {\n\t\t\t\t\t// Delete content and get caret text selection\n\t\t\t\t\tdoc.execCommand('Delete', false, null);\n\t\t\t\t\trng = self.getRng();\n\t\t\t\t}\n\n\t\t\t\t// Explorer removes spaces from the beginning of pasted contents\n\t\t\t\tif (/^\\s+/.test(content)) {\n\t\t\t\t\trng.pasteHTML('<span id=\"__mce_tmp\">_</span>' + content);\n\t\t\t\t\tself.dom.remove('__mce_tmp');\n\t\t\t\t} else\n\t\t\t\t\trng.pasteHTML(content);\n\t\t\t}\n\n\t\t\t// Dispatch set content event\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onSetContent.dispatch(self, args);\n\t\t},\n\n\t\tgetStart : function() {\n\t\t\tvar rng = this.getRng(), startElement, parentElement, checkRng, node;\n\n\t\t\tif (rng.duplicate || rng.item) {\n\t\t\t\t// Control selection, return first item\n\t\t\t\tif (rng.item)\n\t\t\t\t\treturn rng.item(0);\n\n\t\t\t\t// Get start element\n\t\t\t\tcheckRng = rng.duplicate();\n\t\t\t\tcheckRng.collapse(1);\n\t\t\t\tstartElement = checkRng.parentElement();\n\n\t\t\t\t// Check if range parent is inside the start element, then return the inner parent element\n\t\t\t\t// This will fix issues when a single element is selected, IE would otherwise return the wrong start element\n\t\t\t\tparentElement = node = rng.parentElement();\n\t\t\t\twhile (node = node.parentNode) {\n\t\t\t\t\tif (node == startElement) {\n\t\t\t\t\t\tstartElement = parentElement;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn startElement;\n\t\t\t} else {\n\t\t\t\tstartElement = rng.startContainer;\n\n\t\t\t\tif (startElement.nodeType == 1 && startElement.hasChildNodes())\n\t\t\t\t\tstartElement = startElement.childNodes[Math.min(startElement.childNodes.length - 1, rng.startOffset)];\n\n\t\t\t\tif (startElement && startElement.nodeType == 3)\n\t\t\t\t\treturn startElement.parentNode;\n\n\t\t\t\treturn startElement;\n\t\t\t}\n\t\t},\n\n\t\tgetEnd : function() {\n\t\t\tvar t = this, r = t.getRng(), e, eo;\n\n\t\t\tif (r.duplicate || r.item) {\n\t\t\t\tif (r.item)\n\t\t\t\t\treturn r.item(0);\n\n\t\t\t\tr = r.duplicate();\n\t\t\t\tr.collapse(0);\n\t\t\t\te = r.parentElement();\n\n\t\t\t\tif (e && e.nodeName == 'BODY')\n\t\t\t\t\treturn e.lastChild || e;\n\n\t\t\t\treturn e;\n\t\t\t} else {\n\t\t\t\te = r.endContainer;\n\t\t\t\teo = r.endOffset;\n\n\t\t\t\tif (e.nodeType == 1 && e.hasChildNodes())\n\t\t\t\t\te = e.childNodes[eo > 0 ? eo - 1 : eo];\n\n\t\t\t\tif (e && e.nodeType == 3)\n\t\t\t\t\treturn e.parentNode;\n\n\t\t\t\treturn e;\n\t\t\t}\n\t\t},\n\n\t\tgetBookmark : function(type, normalized) {\n\t\t\tvar t = this, dom = t.dom, rng, rng2, id, collapsed, name, element, index, chr = '\\uFEFF', styles;\n\n\t\t\tfunction findIndex(name, element) {\n\t\t\t\tvar index = 0;\n\n\t\t\t\teach(dom.select(name), function(node, i) {\n\t\t\t\t\tif (node == element)\n\t\t\t\t\t\tindex = i;\n\t\t\t\t});\n\n\t\t\t\treturn index;\n\t\t\t};\n\n\t\t\tif (type == 2) {\n\t\t\t\tfunction getLocation() {\n\t\t\t\t\tvar rng = t.getRng(true), root = dom.getRoot(), bookmark = {};\n\n\t\t\t\t\tfunction getPoint(rng, start) {\n\t\t\t\t\t\tvar container = rng[start ? 'startContainer' : 'endContainer'],\n\t\t\t\t\t\t\toffset = rng[start ? 'startOffset' : 'endOffset'], point = [], node, childNodes, after = 0;\n\n\t\t\t\t\t\tif (container.nodeType == 3) {\n\t\t\t\t\t\t\tif (normalized) {\n\t\t\t\t\t\t\t\tfor (node = container.previousSibling; node && node.nodeType == 3; node = node.previousSibling)\n\t\t\t\t\t\t\t\t\toffset += node.nodeValue.length;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tpoint.push(offset);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tchildNodes = container.childNodes;\n\n\t\t\t\t\t\t\tif (offset >= childNodes.length && childNodes.length) {\n\t\t\t\t\t\t\t\tafter = 1;\n\t\t\t\t\t\t\t\toffset = Math.max(0, childNodes.length - 1);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tpoint.push(t.dom.nodeIndex(childNodes[offset], normalized) + after);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfor (; container && container != root; container = container.parentNode)\n\t\t\t\t\t\t\tpoint.push(t.dom.nodeIndex(container, normalized));\n\n\t\t\t\t\t\treturn point;\n\t\t\t\t\t};\n\n\t\t\t\t\tbookmark.start = getPoint(rng, true);\n\n\t\t\t\t\tif (!t.isCollapsed())\n\t\t\t\t\t\tbookmark.end = getPoint(rng);\n\n\t\t\t\t\treturn bookmark;\n\t\t\t\t};\n\n\t\t\t\tif (t.tridentSel)\n\t\t\t\t\treturn t.tridentSel.getBookmark(type);\n\n\t\t\t\treturn getLocation();\n\t\t\t}\n\n\t\t\t// Handle simple range\n\t\t\tif (type)\n\t\t\t\treturn {rng : t.getRng()};\n\n\t\t\trng = t.getRng();\n\t\t\tid = dom.uniqueId();\n\t\t\tcollapsed = tinyMCE.activeEditor.selection.isCollapsed();\n\t\t\tstyles = 'overflow:hidden;line-height:0px';\n\n\t\t\t// Explorer method\n\t\t\tif (rng.duplicate || rng.item) {\n\t\t\t\t// Text selection\n\t\t\t\tif (!rng.item) {\n\t\t\t\t\trng2 = rng.duplicate();\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\t// Insert start marker\n\t\t\t\t\t\trng.collapse();\n\t\t\t\t\t\trng.pasteHTML('<span data-mce-type=\"bookmark\" id=\"' + id + '_start\" style=\"' + styles + '\">' + chr + '</span>');\n\n\t\t\t\t\t\t// Insert end marker\n\t\t\t\t\t\tif (!collapsed) {\n\t\t\t\t\t\t\trng2.collapse(false);\n\n\t\t\t\t\t\t\t// Detect the empty space after block elements in IE and move the end back one character <p></p>] becomes <p>]</p>\n\t\t\t\t\t\t\trng.moveToElementText(rng2.parentElement());\n\t\t\t\t\t\t\tif (rng.compareEndPoints('StartToEnd', rng2) == 0)\n\t\t\t\t\t\t\t\trng2.move('character', -1);\n\n\t\t\t\t\t\t\trng2.pasteHTML('<span data-mce-type=\"bookmark\" id=\"' + id + '_end\" style=\"' + styles + '\">' + chr + '</span>');\n\t\t\t\t\t\t}\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// IE might throw unspecified error so lets ignore it\n\t\t\t\t\t\treturn null;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\t// Control selection\n\t\t\t\t\telement = rng.item(0);\n\t\t\t\t\tname = element.nodeName;\n\n\t\t\t\t\treturn {name : name, index : findIndex(name, element)};\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\telement = t.getNode();\n\t\t\t\tname = element.nodeName;\n\t\t\t\tif (name == 'IMG')\n\t\t\t\t\treturn {name : name, index : findIndex(name, element)};\n\n\t\t\t\t// W3C method\n\t\t\t\trng2 = rng.cloneRange();\n\n\t\t\t\t// Insert end marker\n\t\t\t\tif (!collapsed) {\n\t\t\t\t\trng2.collapse(false);\n\t\t\t\t\trng2.insertNode(dom.create('span', {'data-mce-type' : \"bookmark\", id : id + '_end', style : styles}, chr));\n\t\t\t\t}\n\n\t\t\t\trng.collapse(true);\n\t\t\t\trng.insertNode(dom.create('span', {'data-mce-type' : \"bookmark\", id : id + '_start', style : styles}, chr));\n\t\t\t}\n\n\t\t\tt.moveToBookmark({id : id, keep : 1});\n\n\t\t\treturn {id : id};\n\t\t},\n\n\t\tmoveToBookmark : function(bookmark) {\n\t\t\tvar t = this, dom = t.dom, marker1, marker2, rng, root, startContainer, endContainer, startOffset, endOffset;\n\n\t\t\tif (bookmark) {\n\t\t\t\tif (bookmark.start) {\n\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\troot = dom.getRoot();\n\n\t\t\t\t\tfunction setEndPoint(start) {\n\t\t\t\t\t\tvar point = bookmark[start ? 'start' : 'end'], i, node, offset, children;\n\n\t\t\t\t\t\tif (point) {\n\t\t\t\t\t\t\toffset = point[0];\n\n\t\t\t\t\t\t\t// Find container node\n\t\t\t\t\t\t\tfor (node = root, i = point.length - 1; i >= 1; i--) {\n\t\t\t\t\t\t\t\tchildren = node.childNodes;\n\n\t\t\t\t\t\t\t\tif (point[i] > children.length - 1)\n\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\tnode = children[point[i]];\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Move text offset to best suitable location\n\t\t\t\t\t\t\tif (node.nodeType === 3)\n\t\t\t\t\t\t\t\toffset = Math.min(point[0], node.nodeValue.length);\n\n\t\t\t\t\t\t\t// Move element offset to best suitable location\n\t\t\t\t\t\t\tif (node.nodeType === 1)\n\t\t\t\t\t\t\t\toffset = Math.min(point[0], node.childNodes.length);\n\n\t\t\t\t\t\t\t// Set offset within container node\n\t\t\t\t\t\t\tif (start)\n\t\t\t\t\t\t\t\trng.setStart(node, offset);\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\trng.setEnd(node, offset);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t};\n\n\t\t\t\t\tif (t.tridentSel)\n\t\t\t\t\t\treturn t.tridentSel.moveToBookmark(bookmark);\n\n\t\t\t\t\tif (setEndPoint(true) && setEndPoint()) {\n\t\t\t\t\t\tt.setRng(rng);\n\t\t\t\t\t}\n\t\t\t\t} else if (bookmark.id) {\n\t\t\t\t\tfunction restoreEndPoint(suffix) {\n\t\t\t\t\t\tvar marker = dom.get(bookmark.id + '_' + suffix), node, idx, next, prev, keep = bookmark.keep;\n\n\t\t\t\t\t\tif (marker) {\n\t\t\t\t\t\t\tnode = marker.parentNode;\n\n\t\t\t\t\t\t\tif (suffix == 'start') {\n\t\t\t\t\t\t\t\tif (!keep) {\n\t\t\t\t\t\t\t\t\tidx = dom.nodeIndex(marker);\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tnode = marker.firstChild;\n\t\t\t\t\t\t\t\t\tidx = 1;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tstartContainer = endContainer = node;\n\t\t\t\t\t\t\t\tstartOffset = endOffset = idx;\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tif (!keep) {\n\t\t\t\t\t\t\t\t\tidx = dom.nodeIndex(marker);\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tnode = marker.firstChild;\n\t\t\t\t\t\t\t\t\tidx = 1;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tendContainer = node;\n\t\t\t\t\t\t\t\tendOffset = idx;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (!keep) {\n\t\t\t\t\t\t\t\tprev = marker.previousSibling;\n\t\t\t\t\t\t\t\tnext = marker.nextSibling;\n\n\t\t\t\t\t\t\t\t// Remove all marker text nodes\n\t\t\t\t\t\t\t\teach(tinymce.grep(marker.childNodes), function(node) {\n\t\t\t\t\t\t\t\t\tif (node.nodeType == 3)\n\t\t\t\t\t\t\t\t\t\tnode.nodeValue = node.nodeValue.replace(/\\uFEFF/g, '');\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\t// Remove marker but keep children if for example contents where inserted into the marker\n\t\t\t\t\t\t\t\t// Also remove duplicated instances of the marker for example by a split operation or by WebKit auto split on paste feature\n\t\t\t\t\t\t\t\twhile (marker = dom.get(bookmark.id + '_' + suffix))\n\t\t\t\t\t\t\t\t\tdom.remove(marker, 1);\n\n\t\t\t\t\t\t\t\t// If siblings are text nodes then merge them unless it's Opera since it some how removes the node\n\t\t\t\t\t\t\t\t// and we are sniffing since adding a lot of detection code for a browser with 3% of the market isn't worth the effort. Sorry, Opera but it's just a fact\n\t\t\t\t\t\t\t\tif (prev && next && prev.nodeType == next.nodeType && prev.nodeType == 3 && !tinymce.isOpera) {\n\t\t\t\t\t\t\t\t\tidx = prev.nodeValue.length;\n\t\t\t\t\t\t\t\t\tprev.appendData(next.nodeValue);\n\t\t\t\t\t\t\t\t\tdom.remove(next);\n\n\t\t\t\t\t\t\t\t\tif (suffix == 'start') {\n\t\t\t\t\t\t\t\t\t\tstartContainer = endContainer = prev;\n\t\t\t\t\t\t\t\t\t\tstartOffset = endOffset = idx;\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tendContainer = prev;\n\t\t\t\t\t\t\t\t\t\tendOffset = idx;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\t\tfunction addBogus(node) {\n\t\t\t\t\t\t// Adds a bogus BR element for empty block elements or just a space on IE since it renders BR elements incorrectly\n\t\t\t\t\t\tif (dom.isBlock(node) && !node.innerHTML)\n\t\t\t\t\t\t\tnode.innerHTML = !isIE ? '<br data-mce-bogus=\"1\" />' : ' ';\n\n\t\t\t\t\t\treturn node;\n\t\t\t\t\t};\n\n\t\t\t\t\t// Restore start/end points\n\t\t\t\t\trestoreEndPoint('start');\n\t\t\t\t\trestoreEndPoint('end');\n\n\t\t\t\t\tif (startContainer) {\n\t\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\t\trng.setStart(addBogus(startContainer), startOffset);\n\t\t\t\t\t\trng.setEnd(addBogus(endContainer), endOffset);\n\t\t\t\t\t\tt.setRng(rng);\n\t\t\t\t\t}\n\t\t\t\t} else if (bookmark.name) {\n\t\t\t\t\tt.select(dom.select(bookmark.name)[bookmark.index]);\n\t\t\t\t} else if (bookmark.rng)\n\t\t\t\t\tt.setRng(bookmark.rng);\n\t\t\t}\n\t\t},\n\n\t\tselect : function(node, content) {\n\t\t\tvar t = this, dom = t.dom, rng = dom.createRng(), idx;\n\n\t\t\tif (node) {\n\t\t\t\tidx = dom.nodeIndex(node);\n\t\t\t\trng.setStart(node.parentNode, idx);\n\t\t\t\trng.setEnd(node.parentNode, idx + 1);\n\n\t\t\t\t// Find first/last text node or BR element\n\t\t\t\tif (content) {\n\t\t\t\t\tfunction setPoint(node, start) {\n\t\t\t\t\t\tvar walker = new tinymce.dom.TreeWalker(node, node);\n\n\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t// Text node\n\t\t\t\t\t\t\tif (node.nodeType == 3 && tinymce.trim(node.nodeValue).length != 0) {\n\t\t\t\t\t\t\t\tif (start)\n\t\t\t\t\t\t\t\t\trng.setStart(node, 0);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\trng.setEnd(node, node.nodeValue.length);\n\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// BR element\n\t\t\t\t\t\t\tif (node.nodeName == 'BR') {\n\t\t\t\t\t\t\t\tif (start)\n\t\t\t\t\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\trng.setEndBefore(node);\n\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} while (node = (start ? walker.next() : walker.prev()));\n\t\t\t\t\t};\n\n\t\t\t\t\tsetPoint(node, 1);\n\t\t\t\t\tsetPoint(node);\n\t\t\t\t}\n\n\t\t\t\tt.setRng(rng);\n\t\t\t}\n\n\t\t\treturn node;\n\t\t},\n\n\t\tisCollapsed : function() {\n\t\t\tvar t = this, r = t.getRng(), s = t.getSel();\n\n\t\t\tif (!r || r.item)\n\t\t\t\treturn false;\n\n\t\t\tif (r.compareEndPoints)\n\t\t\t\treturn r.compareEndPoints('StartToEnd', r) === 0;\n\n\t\t\treturn !s || r.collapsed;\n\t\t},\n\n\t\tcollapse : function(to_start) {\n\t\t\tvar self = this, rng = self.getRng(), node;\n\n\t\t\t// Control range on IE\n\t\t\tif (rng.item) {\n\t\t\t\tnode = rng.item(0);\n\t\t\t\trng = self.win.document.body.createTextRange();\n\t\t\t\trng.moveToElementText(node);\n\t\t\t}\n\n\t\t\trng.collapse(!!to_start);\n\t\t\tself.setRng(rng);\n\t\t},\n\n\t\tgetSel : function() {\n\t\t\tvar t = this, w = this.win;\n\n\t\t\treturn w.getSelection ? w.getSelection() : w.document.selection;\n\t\t},\n\n\t\tgetRng : function(w3c) {\n\t\t\tvar t = this, s, r, elm, doc = t.win.document;\n\n\t\t\t// Found tridentSel object then we need to use that one\n\t\t\tif (w3c && t.tridentSel)\n\t\t\t\treturn t.tridentSel.getRangeAt(0);\n\n\t\t\ttry {\n\t\t\t\tif (s = t.getSel())\n\t\t\t\t\tr = s.rangeCount > 0 ? s.getRangeAt(0) : (s.createRange ? s.createRange() : doc.createRange());\n\t\t\t} catch (ex) {\n\t\t\t\t// IE throws unspecified error here if TinyMCE is placed in a frame/iframe\n\t\t\t}\n\n\t\t\t// We have W3C ranges and it's IE then fake control selection since IE9 doesn't handle that correctly yet\n\t\t\tif (tinymce.isIE && r && r.setStart && doc.selection.createRange().item) {\n\t\t\t\telm = doc.selection.createRange().item(0);\n\t\t\t\tr = doc.createRange();\n\t\t\t\tr.setStartBefore(elm);\n\t\t\t\tr.setEndAfter(elm);\n\t\t\t}\n\n\t\t\t// No range found then create an empty one\n\t\t\t// This can occur when the editor is placed in a hidden container element on Gecko\n\t\t\t// Or on IE when there was an exception\n\t\t\tif (!r)\n\t\t\t\tr = doc.createRange ? doc.createRange() : doc.body.createTextRange();\n\n\t\t\tif (t.selectedRange && t.explicitRange) {\n\t\t\t\tif (r.compareBoundaryPoints(r.START_TO_START, t.selectedRange) === 0 && r.compareBoundaryPoints(r.END_TO_END, t.selectedRange) === 0) {\n\t\t\t\t\t// Safari, Opera and Chrome only ever select text which causes the range to change.\n\t\t\t\t\t// This lets us use the originally set range if the selection hasn't been changed by the user.\n\t\t\t\t\tr = t.explicitRange;\n\t\t\t\t} else {\n\t\t\t\t\tt.selectedRange = null;\n\t\t\t\t\tt.explicitRange = null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn r;\n\t\t},\n\n\t\tsetRng : function(r) {\n\t\t\tvar s, t = this;\n\n\t\t\tif (!t.tridentSel) {\n\t\t\t\ts = t.getSel();\n\n\t\t\t\tif (s) {\n\t\t\t\t\tt.explicitRange = r;\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\ts.removeAllRanges();\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// IE9 might throw errors here don't know why\n\t\t\t\t\t}\n\n\t\t\t\t\ts.addRange(r);\n\t\t\t\t\tt.selectedRange = s.getRangeAt(0);\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Is W3C Range\n\t\t\t\tif (r.cloneRange) {\n\t\t\t\t\tt.tridentSel.addRange(r);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Is IE specific range\n\t\t\t\ttry {\n\t\t\t\t\tr.select();\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Needed for some odd IE bug #1843306\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tsetNode : function(n) {\n\t\t\tvar t = this;\n\n\t\t\tt.setContent(t.dom.getOuterHTML(n));\n\n\t\t\treturn n;\n\t\t},\n\n\t\tgetNode : function() {\n\t\t\tvar t = this, rng = t.getRng(), sel = t.getSel(), elm, start = rng.startContainer, end = rng.endContainer;\n\n\t\t\t// Range maybe lost after the editor is made visible again\n\t\t\tif (!rng)\n\t\t\t\treturn t.dom.getRoot();\n\n\t\t\tif (rng.setStart) {\n\t\t\t\telm = rng.commonAncestorContainer;\n\n\t\t\t\t// Handle selection a image or other control like element such as anchors\n\t\t\t\tif (!rng.collapsed) {\n\t\t\t\t\tif (rng.startContainer == rng.endContainer) {\n\t\t\t\t\t\tif (rng.endOffset - rng.startOffset < 2) {\n\t\t\t\t\t\t\tif (rng.startContainer.hasChildNodes())\n\t\t\t\t\t\t\t\telm = rng.startContainer.childNodes[rng.startOffset];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// If the anchor node is a element instead of a text node then return this element\n\t\t\t\t\t//if (tinymce.isWebKit && sel.anchorNode && sel.anchorNode.nodeType == 1)\n\t\t\t\t\t//\treturn sel.anchorNode.childNodes[sel.anchorOffset];\n\n\t\t\t\t\t// Handle cases where the selection is immediately wrapped around a node and return that node instead of it's parent.\n\t\t\t\t\t// This happens when you double click an underlined word in FireFox.\n\t\t\t\t\tif (start.nodeType === 3 && end.nodeType === 3) {\n\t\t\t\t\t\tfunction skipEmptyTextNodes(n, forwards) {\n\t\t\t\t\t\t\tvar orig = n;\n\t\t\t\t\t\t\twhile (n && n.nodeType === 3 && n.length === 0) {\n\t\t\t\t\t\t\t\tn = forwards ? n.nextSibling : n.previousSibling;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn n || orig;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (start.length === rng.startOffset) {\n\t\t\t\t\t\t\tstart = skipEmptyTextNodes(start.nextSibling, true);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tstart = start.parentNode;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (rng.endOffset === 0) {\n\t\t\t\t\t\t\tend = skipEmptyTextNodes(end.previousSibling, false);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tend = end.parentNode;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (start && start === end)\n\t\t\t\t\t\t\treturn start;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (elm && elm.nodeType == 3)\n\t\t\t\t\treturn elm.parentNode;\n\n\t\t\t\treturn elm;\n\t\t\t}\n\n\t\t\treturn rng.item ? rng.item(0) : rng.parentElement();\n\t\t},\n\n\t\tgetSelectedBlocks : function(st, en) {\n\t\t\tvar t = this, dom = t.dom, sb, eb, n, bl = [];\n\n\t\t\tsb = dom.getParent(st || t.getStart(), dom.isBlock);\n\t\t\teb = dom.getParent(en || t.getEnd(), dom.isBlock);\n\n\t\t\tif (sb)\n\t\t\t\tbl.push(sb);\n\n\t\t\tif (sb && eb && sb != eb) {\n\t\t\t\tn = sb;\n\n\t\t\t\tvar walker = new tinymce.dom.TreeWalker(sb, dom.getRoot());\n\t\t\t\twhile ((n = walker.next()) && n != eb) {\n\t\t\t\t\tif (dom.isBlock(n))\n\t\t\t\t\t\tbl.push(n);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (eb && sb != eb)\n\t\t\t\tbl.push(eb);\n\n\t\t\treturn bl;\n\t\t},\n\n\t\tnormalize : function() {\n\t\t\tvar self = this, rng, normalized;\n\n\t\t\t// Normalize only on non IE browsers for now\n\t\t\tif (tinymce.isIE)\n\t\t\t\treturn;\n\n\t\t\tfunction normalizeEndPoint(start) {\n\t\t\t\tvar container, offset, walker, dom = self.dom, body = dom.getRoot(), node;\n\n\t\t\t\tcontainer = rng[(start ? 'start' : 'end') + 'Container'];\n\t\t\t\toffset = rng[(start ? 'start' : 'end') + 'Offset'];\n\n\t\t\t\t// If the container is a document move it to the body element\n\t\t\t\tif (container.nodeType === 9) {\n\t\t\t\t\tcontainer = container.body;\n\t\t\t\t\toffset = 0;\n\t\t\t\t}\n\n\t\t\t\t// If the container is body try move it into the closest text node or position\n\t\t\t\t// TODO: Add more logic here to handle element selection cases\n\t\t\t\tif (container === body) {\n\t\t\t\t\t// Resolve the index\n\t\t\t\t\tif (container.hasChildNodes()) {\n\t\t\t\t\t\tcontainer = container.childNodes[Math.min(!start && offset > 0 ? offset - 1 : offset, container.childNodes.length - 1)];\n\t\t\t\t\t\toffset = 0;\n\n\t\t\t\t\t\t// Don't walk into elements that doesn't have any child nodes like a IMG\n\t\t\t\t\t\tif (container.hasChildNodes()) {\n\t\t\t\t\t\t\t// Walk the DOM to find a text node to place the caret at or a BR\n\t\t\t\t\t\t\tnode = container;\n\t\t\t\t\t\t\twalker = new tinymce.dom.TreeWalker(container, body);\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\t// Found a text node use that position\n\t\t\t\t\t\t\t\tif (node.nodeType === 3) {\n\t\t\t\t\t\t\t\t\toffset = start ? 0 : node.nodeValue.length - 1;\n\t\t\t\t\t\t\t\t\tcontainer = node;\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Found a BR element that we can place the caret before\n\t\t\t\t\t\t\t\tif (node.nodeName === 'BR') {\n\t\t\t\t\t\t\t\t\toffset = dom.nodeIndex(node);\n\t\t\t\t\t\t\t\t\tcontainer = node.parentNode;\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} while (node = (start ? walker.next() : walker.prev()));\n\n\t\t\t\t\t\t\tnormalized = true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Set endpoint if it was normalized\n\t\t\t\tif (normalized)\n\t\t\t\t\trng['set' + (start ? 'Start' : 'End')](container, offset);\n\t\t\t};\n\n\t\t\trng = self.getRng();\n\n\t\t\t// Normalize the end points\n\t\t\tnormalizeEndPoint(true);\n\n\t\t\tif (rng.collapsed)\n\t\t\t\tnormalizeEndPoint();\n\n\t\t\t// Set the selection if it was normalized\n\t\t\tif (normalized) {\n\t\t\t\t//console.log(self.dom.dumpRng(rng));\n\t\t\t\tself.setRng(rng);\n\t\t\t}\n\t\t},\n\n\t\tdestroy : function(s) {\n\t\t\tvar t = this;\n\n\t\t\tt.win = null;\n\n\t\t\t// Manual destroy then remove unload handler\n\t\t\tif (!s)\n\t\t\t\ttinymce.removeUnload(t.destroy);\n\t\t},\n\n\t\t// IE has an issue where you can't select/move the caret by clicking outside the body if the document is in standards mode\n\t\t_fixIESelection : function() {\n\t\t\tvar dom = this.dom, doc = dom.doc, body = doc.body, started, startRng, htmlElm;\n\n\t\t\t// Make HTML element unselectable since we are going to handle selection by hand\n\t\t\tdoc.documentElement.unselectable = true;\n\n\t\t\t// Return range from point or null if it failed\n\t\t\tfunction rngFromPoint(x, y) {\n\t\t\t\tvar rng = body.createTextRange();\n\n\t\t\t\ttry {\n\t\t\t\t\trng.moveToPoint(x, y);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// IE sometimes throws and exception, so lets just ignore it\n\t\t\t\t\trng = null;\n\t\t\t\t}\n\n\t\t\t\treturn rng;\n\t\t\t};\n\n\t\t\t// Fires while the selection is changing\n\t\t\tfunction selectionChange(e) {\n\t\t\t\tvar pointRng;\n\n\t\t\t\t// Check if the button is down or not\n\t\t\t\tif (e.button) {\n\t\t\t\t\t// Create range from mouse position\n\t\t\t\t\tpointRng = rngFromPoint(e.x, e.y);\n\n\t\t\t\t\tif (pointRng) {\n\t\t\t\t\t\t// Check if pointRange is before/after selection then change the endPoint\n\t\t\t\t\t\tif (pointRng.compareEndPoints('StartToStart', startRng) > 0)\n\t\t\t\t\t\t\tpointRng.setEndPoint('StartToStart', startRng);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tpointRng.setEndPoint('EndToEnd', startRng);\n\n\t\t\t\t\t\tpointRng.select();\n\t\t\t\t\t}\n\t\t\t\t} else\n\t\t\t\t\tendSelection();\n\t\t\t}\n\n\t\t\t// Removes listeners\n\t\t\tfunction endSelection() {\n\t\t\t\tvar rng = doc.selection.createRange();\n\n\t\t\t\t// If the range is collapsed then use the last start range\n\t\t\t\tif (startRng && !rng.item && rng.compareEndPoints('StartToEnd', rng) === 0)\n\t\t\t\t\tstartRng.select();\n\n\t\t\t\tdom.unbind(doc, 'mouseup', endSelection);\n\t\t\t\tdom.unbind(doc, 'mousemove', selectionChange);\n\t\t\t\tstartRng = started = 0;\n\t\t\t};\n\n\t\t\t// Detect when user selects outside BODY\n\t\t\tdom.bind(doc, ['mousedown', 'contextmenu'], function(e) {\n\t\t\t\tif (e.target.nodeName === 'HTML') {\n\t\t\t\t\tif (started)\n\t\t\t\t\t\tendSelection();\n\n\t\t\t\t\t// Detect vertical scrollbar, since IE will fire a mousedown on the scrollbar and have target set as HTML\n\t\t\t\t\thtmlElm = doc.documentElement;\n\t\t\t\t\tif (htmlElm.scrollHeight > htmlElm.clientHeight)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tstarted = 1;\n\t\t\t\t\t// Setup start position\n\t\t\t\t\tstartRng = rngFromPoint(e.x, e.y);\n\t\t\t\t\tif (startRng) {\n\t\t\t\t\t\t// Listen for selection change events\n\t\t\t\t\t\tdom.bind(doc, 'mouseup', endSelection);\n\t\t\t\t\t\tdom.bind(doc, 'mousemove', selectionChange);\n\n\t\t\t\t\t\tdom.win.focus();\n\t\t\t\t\t\tstartRng.select();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\ttinymce.dom.Serializer = function(settings, dom, schema) {\n\t\tvar onPreProcess, onPostProcess, isIE = tinymce.isIE, each = tinymce.each, htmlParser;\n\n\t\t// Support the old apply_source_formatting option\n\t\tif (!settings.apply_source_formatting)\n\t\t\tsettings.indent = false;\n\n\t\tsettings.remove_trailing_brs = true;\n\n\t\t// Default DOM and Schema if they are undefined\n\t\tdom = dom || tinymce.DOM;\n\t\tschema = schema || new tinymce.html.Schema(settings);\n\t\tsettings.entity_encoding = settings.entity_encoding || 'named';\n\n\t\tonPreProcess = new tinymce.util.Dispatcher(self);\n\n\t\tonPostProcess = new tinymce.util.Dispatcher(self);\n\n\t\thtmlParser = new tinymce.html.DomParser(settings, schema);\n\n\t\t// Convert move data-mce-src, data-mce-href and data-mce-style into nodes or process them if needed\n\t\thtmlParser.addAttributeFilter('src,href,style', function(nodes, name) {\n\t\t\tvar i = nodes.length, node, value, internalName = 'data-mce-' + name, urlConverter = settings.url_converter, urlConverterScope = settings.url_converter_scope, undef;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\n\t\t\t\tvalue = node.attributes.map[internalName];\n\t\t\t\tif (value !== undef) {\n\t\t\t\t\t// Set external name to internal value and remove internal\n\t\t\t\t\tnode.attr(name, value.length > 0 ? value : null);\n\t\t\t\t\tnode.attr(internalName, null);\n\t\t\t\t} else {\n\t\t\t\t\t// No internal attribute found then convert the value we have in the DOM\n\t\t\t\t\tvalue = node.attributes.map[name];\n\n\t\t\t\t\tif (name === \"style\")\n\t\t\t\t\t\tvalue = dom.serializeStyle(dom.parseStyle(value), node.name);\n\t\t\t\t\telse if (urlConverter)\n\t\t\t\t\t\tvalue = urlConverter.call(urlConverterScope, value, name, node.name);\n\n\t\t\t\t\tnode.attr(name, value.length > 0 ? value : null);\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\t// Remove internal classes mceItem<..>\n\t\thtmlParser.addAttributeFilter('class', function(nodes, name) {\n\t\t\tvar i = nodes.length, node, value;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\t\t\t\tvalue = node.attr('class').replace(/\\s*mce(Item\\w+|Selected)\\s*/g, '');\n\t\t\t\tnode.attr('class', value.length > 0 ? value : null);\n\t\t\t}\n\t\t});\n\n\t\t// Remove bookmark elements\n\t\thtmlParser.addAttributeFilter('data-mce-type', function(nodes, name, args) {\n\t\t\tvar i = nodes.length, node;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\n\t\t\t\tif (node.attributes.map['data-mce-type'] === 'bookmark' && !args.cleanup)\n\t\t\t\t\tnode.remove();\n\t\t\t}\n\t\t});\n\n\t\t// Force script into CDATA sections and remove the mce- prefix also add comments around styles\n\t\thtmlParser.addNodeFilter('script,style', function(nodes, name) {\n\t\t\tvar i = nodes.length, node, value;\n\n\t\t\tfunction trim(value) {\n\t\t\t\treturn value.replace(/(<!--\\[CDATA\\[|\\]\\]-->)/g, '\\n')\n\t\t\t\t\t\t.replace(/^[\\r\\n]*|[\\r\\n]*$/g, '')\n\t\t\t\t\t\t.replace(/^\\s*(\\/\\/\\s*<!--|\\/\\/\\s*<!\\[CDATA\\[|<!--|<!\\[CDATA\\[)[\\r\\n]*/g, '')\n\t\t\t\t\t\t.replace(/\\s*(\\/\\/\\s*\\]\\]>|\\/\\/\\s*-->|\\]\\]>|-->|\\]\\]-->)\\s*$/g, '');\n\t\t\t};\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\t\t\t\tvalue = node.firstChild ? node.firstChild.value : '';\n\n\t\t\t\tif (name === \"script\") {\n\t\t\t\t\t// Remove mce- prefix from script elements\n\t\t\t\t\tnode.attr('type', (node.attr('type') || 'text/javascript').replace(/^mce\\-/, ''));\n\n\t\t\t\t\tif (value.length > 0)\n\t\t\t\t\t\tnode.firstChild.value = '// <![CDATA[\\n' + trim(value) + '\\n// ]]>';\n\t\t\t\t} else {\n\t\t\t\t\tif (value.length > 0)\n\t\t\t\t\t\tnode.firstChild.value = '<!--\\n' + trim(value) + '\\n-->';\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\t// Convert comments to cdata and handle protected comments\n\t\thtmlParser.addNodeFilter('#comment', function(nodes, name) {\n\t\t\tvar i = nodes.length, node;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\n\t\t\t\tif (node.value.indexOf('[CDATA[') === 0) {\n\t\t\t\t\tnode.name = '#cdata';\n\t\t\t\t\tnode.type = 4;\n\t\t\t\t\tnode.value = node.value.replace(/^\\[CDATA\\[|\\]\\]$/g, '');\n\t\t\t\t} else if (node.value.indexOf('mce:protected ') === 0) {\n\t\t\t\t\tnode.name = \"#text\";\n\t\t\t\t\tnode.type = 3;\n\t\t\t\t\tnode.raw = true;\n\t\t\t\t\tnode.value = unescape(node.value).substr(14);\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\thtmlParser.addNodeFilter('xml:namespace,input', function(nodes, name) {\n\t\t\tvar i = nodes.length, node;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\t\t\t\tif (node.type === 7)\n\t\t\t\t\tnode.remove();\n\t\t\t\telse if (node.type === 1) {\n\t\t\t\t\tif (name === \"input\" && !(\"type\" in node.attributes.map))\n\t\t\t\t\t\tnode.attr('type', 'text');\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\t// Fix list elements, TODO: Replace this later\n\t\tif (settings.fix_list_elements) {\n\t\t\thtmlParser.addNodeFilter('ul,ol', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node, parentNode;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tparentNode = node.parent;\n\n\t\t\t\t\tif (parentNode.name === 'ul' || parentNode.name === 'ol') {\n\t\t\t\t\t\tif (node.prev && node.prev.name === 'li') {\n\t\t\t\t\t\t\tnode.prev.append(node);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\n\t\t// Remove internal data attributes\n\t\thtmlParser.addAttributeFilter('data-mce-src,data-mce-href,data-mce-style', function(nodes, name) {\n\t\t\tvar i = nodes.length;\n\n\t\t\twhile (i--) {\n\t\t\t\tnodes[i].attr(name, null);\n\t\t\t}\n\t\t});\n\n\t\t// Return public methods\n\t\treturn {\n\t\t\tschema : schema,\n\n\t\t\taddNodeFilter : htmlParser.addNodeFilter,\n\n\t\t\taddAttributeFilter : htmlParser.addAttributeFilter,\n\n\t\t\tonPreProcess : onPreProcess,\n\n\t\t\tonPostProcess : onPostProcess,\n\n\t\t\tserialize : function(node, args) {\n\t\t\t\tvar impl, doc, oldDoc, htmlSerializer, content;\n\n\t\t\t\t// Explorer won't clone contents of script and style and the\n\t\t\t\t// selected index of select elements are cleared on a clone operation.\n\t\t\t\tif (isIE && dom.select('script,style,select,map').length > 0) {\n\t\t\t\t\tcontent = node.innerHTML;\n\t\t\t\t\tnode = node.cloneNode(false);\n\t\t\t\t\tdom.setHTML(node, content);\n\t\t\t\t} else\n\t\t\t\t\tnode = node.cloneNode(true);\n\n\t\t\t\t// Nodes needs to be attached to something in WebKit/Opera\n\t\t\t\t// Older builds of Opera crashes if you attach the node to an document created dynamically\n\t\t\t\t// and since we can't feature detect a crash we need to sniff the acutal build number\n\t\t\t\t// This fix will make DOM ranges and make Sizzle happy!\n\t\t\t\timpl = node.ownerDocument.implementation;\n\t\t\t\tif (impl.createHTMLDocument) {\n\t\t\t\t\t// Create an empty HTML document\n\t\t\t\t\tdoc = impl.createHTMLDocument(\"\");\n\n\t\t\t\t\t// Add the element or it's children if it's a body element to the new document\n\t\t\t\t\teach(node.nodeName == 'BODY' ? node.childNodes : [node], function(node) {\n\t\t\t\t\t\tdoc.body.appendChild(doc.importNode(node, true));\n\t\t\t\t\t});\n\n\t\t\t\t\t// Grab first child or body element for serialization\n\t\t\t\t\tif (node.nodeName != 'BODY')\n\t\t\t\t\t\tnode = doc.body.firstChild;\n\t\t\t\t\telse\n\t\t\t\t\t\tnode = doc.body;\n\n\t\t\t\t\t// set the new document in DOMUtils so createElement etc works\n\t\t\t\t\toldDoc = dom.doc;\n\t\t\t\t\tdom.doc = doc;\n\t\t\t\t}\n\n\t\t\t\targs = args || {};\n\t\t\t\targs.format = args.format || 'html';\n\n\t\t\t\t// Pre process\n\t\t\t\tif (!args.no_events) {\n\t\t\t\t\targs.node = node;\n\t\t\t\t\tonPreProcess.dispatch(self, args);\n\t\t\t\t}\n\n\t\t\t\t// Setup serializer\n\t\t\t\thtmlSerializer = new tinymce.html.Serializer(settings, schema);\n\n\t\t\t\t// Parse and serialize HTML\n\t\t\t\targs.content = htmlSerializer.serialize(\n\t\t\t\t\thtmlParser.parse(args.getInner ? node.innerHTML : tinymce.trim(dom.getOuterHTML(node), args), args)\n\t\t\t\t);\n\n\t\t\t\t// Replace all BOM characters for now until we can find a better solution\n\t\t\t\tif (!args.cleanup)\n\t\t\t\t\targs.content = args.content.replace(/\\uFEFF|\\u200B/g, '');\n\n\t\t\t\t// Post process\n\t\t\t\tif (!args.no_events)\n\t\t\t\t\tonPostProcess.dispatch(self, args);\n\n\t\t\t\t// Restore the old document if it was changed\n\t\t\t\tif (oldDoc)\n\t\t\t\t\tdom.doc = oldDoc;\n\n\t\t\t\targs.node = null;\n\n\t\t\t\treturn args.content;\n\t\t\t},\n\n\t\t\taddRules : function(rules) {\n\t\t\t\tschema.addValidElements(rules);\n\t\t\t},\n\n\t\t\tsetRules : function(rules) {\n\t\t\t\tschema.setValidElements(rules);\n\t\t\t}\n\t\t};\n\t};\n})(tinymce);\n(function(tinymce) {\n\ttinymce.dom.ScriptLoader = function(settings) {\n\t\tvar QUEUED = 0,\n\t\t\tLOADING = 1,\n\t\t\tLOADED = 2,\n\t\t\tstates = {},\n\t\t\tqueue = [],\n\t\t\tscriptLoadedCallbacks = {},\n\t\t\tqueueLoadedCallbacks = [],\n\t\t\tloading = 0,\n\t\t\tundefined;\n\n\t\tfunction loadScript(url, callback) {\n\t\t\tvar t = this, dom = tinymce.DOM, elm, uri, loc, id;\n\n\t\t\t// Execute callback when script is loaded\n\t\t\tfunction done() {\n\t\t\t\tdom.remove(id);\n\n\t\t\t\tif (elm)\n\t\t\t\t\telm.onreadystatechange = elm.onload = elm = null;\n\n\t\t\t\tcallback();\n\t\t\t};\n\n\t\t\tfunction error() {\n\t\t\t\t// Report the error so it's easier for people to spot loading errors\n\t\t\t\tif (typeof(console) !== \"undefined\" && console.log)\n\t\t\t\t\tconsole.log(\"Failed to load: \" + url);\n\n\t\t\t\t// We can't mark it as done if there is a load error since\n\t\t\t\t// A) We don't want to produce 404 errors on the server and\n\t\t\t\t// B) the onerror event won't fire on all browsers.\n\t\t\t\t// done();\n\t\t\t};\n\n\t\t\tid = dom.uniqueId();\n\n\t\t\tif (tinymce.isIE6) {\n\t\t\t\turi = new tinymce.util.URI(url);\n\t\t\t\tloc = location;\n\n\t\t\t\t// If script is from same domain and we\n\t\t\t\t// use IE 6 then use XHR since it's more reliable\n\t\t\t\tif (uri.host == loc.hostname && uri.port == loc.port && (uri.protocol + ':') == loc.protocol && uri.protocol.toLowerCase() != 'file') {\n\t\t\t\t\ttinymce.util.XHR.send({\n\t\t\t\t\t\turl : tinymce._addVer(uri.getURI()),\n\t\t\t\t\t\tsuccess : function(content) {\n\t\t\t\t\t\t\t// Create new temp script element\n\t\t\t\t\t\t\tvar script = dom.create('script', {\n\t\t\t\t\t\t\t\ttype : 'text/javascript'\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t// Evaluate script in global scope\n\t\t\t\t\t\t\tscript.text = content;\n\t\t\t\t\t\t\tdocument.getElementsByTagName('head')[0].appendChild(script);\n\t\t\t\t\t\t\tdom.remove(script);\n\n\t\t\t\t\t\t\tdone();\n\t\t\t\t\t\t},\n\n\t\t\t\t\t\terror : error\n\t\t\t\t\t});\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Create new script element\n\t\t\telm = dom.create('script', {\n\t\t\t\tid : id,\n\t\t\t\ttype : 'text/javascript',\n\t\t\t\tsrc : tinymce._addVer(url)\n\t\t\t});\n\n\t\t\t// Add onload listener for non IE browsers since IE9\n\t\t\t// fires onload event before the script is parsed and executed\n\t\t\tif (!tinymce.isIE)\n\t\t\t\telm.onload = done;\n\n\t\t\t// Add onerror event will get fired on some browsers but not all of them\n\t\t\telm.onerror = error;\n\n\t\t\t// Opera 9.60 doesn't seem to fire the onreadystate event at correctly\n\t\t\tif (!tinymce.isOpera) {\n\t\t\t\telm.onreadystatechange = function() {\n\t\t\t\t\tvar state = elm.readyState;\n\n\t\t\t\t\t// Loaded state is passed on IE 6 however there\n\t\t\t\t\t// are known issues with this method but we can't use\n\t\t\t\t\t// XHR in a cross domain loading\n\t\t\t\t\tif (state == 'complete' || state == 'loaded')\n\t\t\t\t\t\tdone();\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t// Most browsers support this feature so we report errors\n\t\t\t// for those at least to help users track their missing plugins etc\n\t\t\t// todo: Removed since it produced error if the document is unloaded by navigating away, re-add it as an option\n\t\t\t/*elm.onerror = function() {\n\t\t\t\talert('Failed to load: ' + url);\n\t\t\t};*/\n\n\t\t\t// Add script to document\n\t\t\t(document.getElementsByTagName('head')[0] || document.body).appendChild(elm);\n\t\t};\n\n\t\tthis.isDone = function(url) {\n\t\t\treturn states[url] == LOADED;\n\t\t};\n\n\t\tthis.markDone = function(url) {\n\t\t\tstates[url] = LOADED;\n\t\t};\n\n\t\tthis.add = this.load = function(url, callback, scope) {\n\t\t\tvar item, state = states[url];\n\n\t\t\t// Add url to load queue\n\t\t\tif (state == undefined) {\n\t\t\t\tqueue.push(url);\n\t\t\t\tstates[url] = QUEUED;\n\t\t\t}\n\n\t\t\tif (callback) {\n\t\t\t\t// Store away callback for later execution\n\t\t\t\tif (!scriptLoadedCallbacks[url])\n\t\t\t\t\tscriptLoadedCallbacks[url] = [];\n\n\t\t\t\tscriptLoadedCallbacks[url].push({\n\t\t\t\t\tfunc : callback,\n\t\t\t\t\tscope : scope || this\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\tthis.loadQueue = function(callback, scope) {\n\t\t\tthis.loadScripts(queue, callback, scope);\n\t\t};\n\n\t\tthis.loadScripts = function(scripts, callback, scope) {\n\t\t\tvar loadScripts;\n\n\t\t\tfunction execScriptLoadedCallbacks(url) {\n\t\t\t\t// Execute URL callback functions\n\t\t\t\ttinymce.each(scriptLoadedCallbacks[url], function(callback) {\n\t\t\t\t\tcallback.func.call(callback.scope);\n\t\t\t\t});\n\n\t\t\t\tscriptLoadedCallbacks[url] = undefined;\n\t\t\t};\n\n\t\t\tqueueLoadedCallbacks.push({\n\t\t\t\tfunc : callback,\n\t\t\t\tscope : scope || this\n\t\t\t});\n\n\t\t\tloadScripts = function() {\n\t\t\t\tvar loadingScripts = tinymce.grep(scripts);\n\n\t\t\t\t// Current scripts has been handled\n\t\t\t\tscripts.length = 0;\n\n\t\t\t\t// Load scripts that needs to be loaded\n\t\t\t\ttinymce.each(loadingScripts, function(url) {\n\t\t\t\t\t// Script is already loaded then execute script callbacks directly\n\t\t\t\t\tif (states[url] == LOADED) {\n\t\t\t\t\t\texecScriptLoadedCallbacks(url);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Is script not loading then start loading it\n\t\t\t\t\tif (states[url] != LOADING) {\n\t\t\t\t\t\tstates[url] = LOADING;\n\t\t\t\t\t\tloading++;\n\n\t\t\t\t\t\tloadScript(url, function() {\n\t\t\t\t\t\t\tstates[url] = LOADED;\n\t\t\t\t\t\t\tloading--;\n\n\t\t\t\t\t\t\texecScriptLoadedCallbacks(url);\n\n\t\t\t\t\t\t\t// Load more scripts if they where added by the recently loaded script\n\t\t\t\t\t\t\tloadScripts();\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// No scripts are currently loading then execute all pending queue loaded callbacks\n\t\t\t\tif (!loading) {\n\t\t\t\t\ttinymce.each(queueLoadedCallbacks, function(callback) {\n\t\t\t\t\t\tcallback.func.call(callback.scope);\n\t\t\t\t\t});\n\n\t\t\t\t\tqueueLoadedCallbacks.length = 0;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tloadScripts();\n\t\t};\n\t};\n\n\t// Global script loader\n\ttinymce.ScriptLoader = new tinymce.dom.ScriptLoader();\n})(tinymce);\n\ntinymce.dom.TreeWalker = function(start_node, root_node) {\n\tvar node = start_node;\n\n\tfunction findSibling(node, start_name, sibling_name, shallow) {\n\t\tvar sibling, parent;\n\n\t\tif (node) {\n\t\t\t// Walk into nodes if it has a start\n\t\t\tif (!shallow && node[start_name])\n\t\t\t\treturn node[start_name];\n\n\t\t\t// Return the sibling if it has one\n\t\t\tif (node != root_node) {\n\t\t\t\tsibling = node[sibling_name];\n\t\t\t\tif (sibling)\n\t\t\t\t\treturn sibling;\n\n\t\t\t\t// Walk up the parents to look for siblings\n\t\t\t\tfor (parent = node.parentNode; parent && parent != root_node; parent = parent.parentNode) {\n\t\t\t\t\tsibling = parent[sibling_name];\n\t\t\t\t\tif (sibling)\n\t\t\t\t\t\treturn sibling;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t};\n\n\tthis.current = function() {\n\t\treturn node;\n\t};\n\n\tthis.next = function(shallow) {\n\t\treturn (node = findSibling(node, 'firstChild', 'nextSibling', shallow));\n\t};\n\n\tthis.prev = function(shallow) {\n\t\treturn (node = findSibling(node, 'lastChild', 'previousSibling', shallow));\n\t};\n};\n\n(function(tinymce) {\n\ttinymce.dom.RangeUtils = function(dom) {\n\t\tvar INVISIBLE_CHAR = '\\uFEFF';\n\n\t\tthis.walk = function(rng, callback) {\n\t\t\tvar startContainer = rng.startContainer,\n\t\t\t\tstartOffset = rng.startOffset,\n\t\t\t\tendContainer = rng.endContainer,\n\t\t\t\tendOffset = rng.endOffset,\n\t\t\t\tancestor, startPoint,\n\t\t\t\tendPoint, node, parent, siblings, nodes;\n\n\t\t\t// Handle table cell selection the table plugin enables\n\t\t\t// you to fake select table cells and perform formatting actions on them\n\t\t\tnodes = dom.select('td.mceSelected,th.mceSelected');\n\t\t\tif (nodes.length > 0) {\n\t\t\t\ttinymce.each(nodes, function(node) {\n\t\t\t\t\tcallback([node]);\n\t\t\t\t});\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tfunction exclude(nodes) {\n\t\t\t\tvar node;\n\n\t\t\t\t// First node is excluded\n\t\t\t\tnode = nodes[0];\n\t\t\t\tif (node.nodeType === 3 && node === startContainer && startOffset >= node.nodeValue.length) {\n\t\t\t\t\tnodes.splice(0, 1);\n\t\t\t\t}\n\n\t\t\t\t// Last node is excluded\n\t\t\t\tnode = nodes[nodes.length - 1];\n\t\t\t\tif (endOffset === 0 && nodes.length > 0 && node === endContainer && node.nodeType === 3) {\n\t\t\t\t\tnodes.splice(nodes.length - 1, 1);\n\t\t\t\t}\n\n\t\t\t\treturn nodes;\n\t\t\t};\n\n\t\t\tfunction collectSiblings(node, name, end_node) {\n\t\t\t\tvar siblings = [];\n\n\t\t\t\tfor (; node && node != end_node; node = node[name])\n\t\t\t\t\tsiblings.push(node);\n\n\t\t\t\treturn siblings;\n\t\t\t};\n\n\t\t\tfunction findEndPoint(node, root) {\n\t\t\t\tdo {\n\t\t\t\t\tif (node.parentNode == root)\n\t\t\t\t\t\treturn node;\n\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t} while(node);\n\t\t\t};\n\n\t\t\tfunction walkBoundary(start_node, end_node, next) {\n\t\t\t\tvar siblingName = next ? 'nextSibling' : 'previousSibling';\n\n\t\t\t\tfor (node = start_node, parent = node.parentNode; node && node != end_node; node = parent) {\n\t\t\t\t\tparent = node.parentNode;\n\t\t\t\t\tsiblings = collectSiblings(node == start_node ? node : node[siblingName], siblingName);\n\n\t\t\t\t\tif (siblings.length) {\n\t\t\t\t\t\tif (!next)\n\t\t\t\t\t\t\tsiblings.reverse();\n\n\t\t\t\t\t\tcallback(exclude(siblings));\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// If index based start position then resolve it\n\t\t\tif (startContainer.nodeType == 1 && startContainer.hasChildNodes())\n\t\t\t\tstartContainer = startContainer.childNodes[startOffset];\n\n\t\t\t// If index based end position then resolve it\n\t\t\tif (endContainer.nodeType == 1 && endContainer.hasChildNodes())\n\t\t\t\tendContainer = endContainer.childNodes[Math.min(endOffset - 1, endContainer.childNodes.length - 1)];\n\n\t\t\t// Same container\n\t\t\tif (startContainer == endContainer)\n\t\t\t\treturn callback(exclude([startContainer]));\n\n\t\t\t// Find common ancestor and end points\n\t\t\tancestor = dom.findCommonAncestor(startContainer, endContainer);\n\n\t\t\t// Process left side\n\t\t\tfor (node = startContainer; node; node = node.parentNode) {\n\t\t\t\tif (node === endContainer)\n\t\t\t\t\treturn walkBoundary(startContainer, ancestor, true);\n\n\t\t\t\tif (node === ancestor)\n\t\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\t// Process right side\n\t\t\tfor (node = endContainer; node; node = node.parentNode) {\n\t\t\t\tif (node === startContainer)\n\t\t\t\t\treturn walkBoundary(endContainer, ancestor);\n\n\t\t\t\tif (node === ancestor)\n\t\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\t// Find start/end point\n\t\t\tstartPoint = findEndPoint(startContainer, ancestor) || startContainer;\n\t\t\tendPoint = findEndPoint(endContainer, ancestor) || endContainer;\n\n\t\t\t// Walk left leaf\n\t\t\twalkBoundary(startContainer, startPoint, true);\n\n\t\t\t// Walk the middle from start to end point\n\t\t\tsiblings = collectSiblings(\n\t\t\t\tstartPoint == startContainer ? startPoint : startPoint.nextSibling,\n\t\t\t\t'nextSibling',\n\t\t\t\tendPoint == endContainer ? endPoint.nextSibling : endPoint\n\t\t\t);\n\n\t\t\tif (siblings.length)\n\t\t\t\tcallback(exclude(siblings));\n\n\t\t\t// Walk right leaf\n\t\t\twalkBoundary(endContainer, endPoint);\n\t\t};\n\n\t\tthis.split = function(rng) {\n\t\t\tvar startContainer = rng.startContainer,\n\t\t\t\tstartOffset = rng.startOffset,\n\t\t\t\tendContainer = rng.endContainer,\n\t\t\t\tendOffset = rng.endOffset;\n\n\t\t\tfunction splitText(node, offset) {\n\t\t\t\treturn node.splitText(offset);\n\t\t\t};\n\n\t\t\t// Handle single text node\n\t\t\tif (startContainer == endContainer && startContainer.nodeType == 3) {\n\t\t\t\tif (startOffset > 0 && startOffset < startContainer.nodeValue.length) {\n\t\t\t\t\tendContainer = splitText(startContainer, startOffset);\n\t\t\t\t\tstartContainer = endContainer.previousSibling;\n\n\t\t\t\t\tif (endOffset > startOffset) {\n\t\t\t\t\t\tendOffset = endOffset - startOffset;\n\t\t\t\t\t\tstartContainer = endContainer = splitText(endContainer, endOffset).previousSibling;\n\t\t\t\t\t\tendOffset = endContainer.nodeValue.length;\n\t\t\t\t\t\tstartOffset = 0;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tendOffset = 0;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Split startContainer text node if needed\n\t\t\t\tif (startContainer.nodeType == 3 && startOffset > 0 && startOffset < startContainer.nodeValue.length) {\n\t\t\t\t\tstartContainer = splitText(startContainer, startOffset);\n\t\t\t\t\tstartOffset = 0;\n\t\t\t\t}\n\n\t\t\t\t// Split endContainer text node if needed\n\t\t\t\tif (endContainer.nodeType == 3 && endOffset > 0 && endOffset < endContainer.nodeValue.length) {\n\t\t\t\t\tendContainer = splitText(endContainer, endOffset).previousSibling;\n\t\t\t\t\tendOffset = endContainer.nodeValue.length;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn {\n\t\t\t\tstartContainer : startContainer,\n\t\t\t\tstartOffset : startOffset,\n\t\t\t\tendContainer : endContainer,\n\t\t\t\tendOffset : endOffset\n\t\t\t};\n\t\t};\n\n\t};\n\n\ttinymce.dom.RangeUtils.compareRanges = function(rng1, rng2) {\n\t\tif (rng1 && rng2) {\n\t\t\t// Compare native IE ranges\n\t\t\tif (rng1.item || rng1.duplicate) {\n\t\t\t\t// Both are control ranges and the selected element matches\n\t\t\t\tif (rng1.item && rng2.item && rng1.item(0) === rng2.item(0))\n\t\t\t\t\treturn true;\n\n\t\t\t\t// Both are text ranges and the range matches\n\t\t\t\tif (rng1.isEqual && rng2.isEqual && rng2.isEqual(rng1))\n\t\t\t\t\treturn true;\n\t\t\t} else {\n\t\t\t\t// Compare w3c ranges\n\t\t\t\treturn rng1.startContainer == rng2.startContainer && rng1.startOffset == rng2.startOffset;\n\t\t\t}\n\t\t}\n\n\t\treturn false;\n\t};\n})(tinymce);\n\n(function(tinymce) {\n\tvar Event = tinymce.dom.Event, each = tinymce.each;\n\n\ttinymce.create('tinymce.ui.KeyboardNavigation', {\n\t\tKeyboardNavigation: function(settings, dom) {\n\t\t\tvar t = this, root = settings.root, items = settings.items,\n\t\t\t\t\tenableUpDown = settings.enableUpDown, enableLeftRight = settings.enableLeftRight || !settings.enableUpDown,\n\t\t\t\t\texcludeFromTabOrder = settings.excludeFromTabOrder,\n\t\t\t\t\titemFocussed, itemBlurred, rootKeydown, rootFocussed, focussedId;\n\n\t\t\tdom = dom || tinymce.DOM;\n\n\t\t\titemFocussed = function(evt) {\n\t\t\t\tfocussedId = evt.target.id;\n\t\t\t};\n\n\t\t\titemBlurred = function(evt) {\n\t\t\t\tdom.setAttrib(evt.target.id, 'tabindex', '-1');\n\t\t\t};\n\n\t\t\trootFocussed = function(evt) {\n\t\t\t\tvar item = dom.get(focussedId);\n\t\t\t\tdom.setAttrib(item, 'tabindex', '0');\n\t\t\t\titem.focus();\n\t\t\t};\n\n\t\t\tt.focus = function() {\n\t\t\t\tdom.get(focussedId).focus();\n\t\t\t};\n\n\t\t\tt.destroy = function() {\n\t\t\t\teach(items, function(item) {\n\t\t\t\t\tdom.unbind(dom.get(item.id), 'focus', itemFocussed);\n\t\t\t\t\tdom.unbind(dom.get(item.id), 'blur', itemBlurred);\n\t\t\t\t});\n\n\t\t\t\tdom.unbind(dom.get(root), 'focus', rootFocussed);\n\t\t\t\tdom.unbind(dom.get(root), 'keydown', rootKeydown);\n\n\t\t\t\titems = dom = root = t.focus = itemFocussed = itemBlurred = rootKeydown = rootFocussed = null;\n\t\t\t\tt.destroy = function() {};\n\t\t\t};\n\n\t\t\tt.moveFocus = function(dir, evt) {\n\t\t\t\tvar idx = -1, controls = t.controls, newFocus;\n\n\t\t\t\tif (!focussedId)\n\t\t\t\t\treturn;\n\n\t\t\t\teach(items, function(item, index) {\n\t\t\t\t\tif (item.id === focussedId) {\n\t\t\t\t\t\tidx = index;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tidx += dir;\n\t\t\t\tif (idx < 0) {\n\t\t\t\t\tidx = items.length - 1;\n\t\t\t\t} else if (idx >= items.length) {\n\t\t\t\t\tidx = 0;\n\t\t\t\t}\n\n\t\t\t\tnewFocus = items[idx];\n\t\t\t\tdom.setAttrib(focussedId, 'tabindex', '-1');\n\t\t\t\tdom.setAttrib(newFocus.id, 'tabindex', '0');\n\t\t\t\tdom.get(newFocus.id).focus();\n\n\t\t\t\tif (settings.actOnFocus) {\n\t\t\t\t\tsettings.onAction(newFocus.id);\n\t\t\t\t}\n\n\t\t\t\tif (evt)\n\t\t\t\t\tEvent.cancel(evt);\n\t\t\t};\n\n\t\t\trootKeydown = function(evt) {\n\t\t\t\tvar DOM_VK_LEFT = 37, DOM_VK_RIGHT = 39, DOM_VK_UP = 38, DOM_VK_DOWN = 40, DOM_VK_ESCAPE = 27, DOM_VK_ENTER = 14, DOM_VK_RETURN = 13, DOM_VK_SPACE = 32;\n\n\t\t\t\tswitch (evt.keyCode) {\n\t\t\t\t\tcase DOM_VK_LEFT:\n\t\t\t\t\t\tif (enableLeftRight) t.moveFocus(-1);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase DOM_VK_RIGHT:\n\t\t\t\t\t\tif (enableLeftRight) t.moveFocus(1);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase DOM_VK_UP:\n\t\t\t\t\t\tif (enableUpDown) t.moveFocus(-1);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase DOM_VK_DOWN:\n\t\t\t\t\t\tif (enableUpDown) t.moveFocus(1);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase DOM_VK_ESCAPE:\n\t\t\t\t\t\tif (settings.onCancel) {\n\t\t\t\t\t\t\tsettings.onCancel();\n\t\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase DOM_VK_ENTER:\n\t\t\t\t\tcase DOM_VK_RETURN:\n\t\t\t\t\tcase DOM_VK_SPACE:\n\t\t\t\t\t\tif (settings.onAction) {\n\t\t\t\t\t\t\tsettings.onAction(focussedId);\n\t\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Set up state and listeners for each item.\n\t\t\teach(items, function(item, idx) {\n\t\t\t\tvar tabindex;\n\n\t\t\t\tif (!item.id) {\n\t\t\t\t\titem.id = dom.uniqueId('_mce_item_');\n\t\t\t\t}\n\n\t\t\t\tif (excludeFromTabOrder) {\n\t\t\t\t\tdom.bind(item.id, 'blur', itemBlurred);\n\t\t\t\t\ttabindex = '-1';\n\t\t\t\t} else {\n\t\t\t\t\ttabindex = (idx === 0 ? '0' : '-1');\n\t\t\t\t}\n\n\t\t\t\tdom.setAttrib(item.id, 'tabindex', tabindex);\n\t\t\t\tdom.bind(dom.get(item.id), 'focus', itemFocussed);\n\t\t\t});\n\n\t\t\t// Setup initial state for root element.\n\t\t\tif (items[0]){\n\t\t\t\tfocussedId = items[0].id;\n\t\t\t}\n\n\t\t\tdom.setAttrib(root, 'tabindex', '-1');\n\n\t\t\t// Setup listeners for root element.\n\t\t\tdom.bind(dom.get(root), 'focus', rootFocussed);\n\t\t\tdom.bind(dom.get(root), 'keydown', rootKeydown);\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\t// Shorten class names\n\tvar DOM = tinymce.DOM, is = tinymce.is;\n\n\ttinymce.create('tinymce.ui.Control', {\n\t\tControl : function(id, s, editor) {\n\t\t\tthis.id = id;\n\t\t\tthis.settings = s = s || {};\n\t\t\tthis.rendered = false;\n\t\t\tthis.onRender = new tinymce.util.Dispatcher(this);\n\t\t\tthis.classPrefix = '';\n\t\t\tthis.scope = s.scope || this;\n\t\t\tthis.disabled = 0;\n\t\t\tthis.active = 0;\n\t\t\tthis.editor = editor;\n\t\t},\n\n\t\tsetAriaProperty : function(property, value) {\n\t\t\tvar element = DOM.get(this.id + '_aria') || DOM.get(this.id);\n\t\t\tif (element) {\n\t\t\t\tDOM.setAttrib(element, 'aria-' + property, !!value);\n\t\t\t}\n\t\t},\n\n\t\tfocus : function() {\n\t\t\tDOM.get(this.id).focus();\n\t\t},\n\n\t\tsetDisabled : function(s) {\n\t\t\tif (s != this.disabled) {\n\t\t\t\tthis.setAriaProperty('disabled', s);\n\n\t\t\t\tthis.setState('Disabled', s);\n\t\t\t\tthis.setState('Enabled', !s);\n\t\t\t\tthis.disabled = s;\n\t\t\t}\n\t\t},\n\n\t\tisDisabled : function() {\n\t\t\treturn this.disabled;\n\t\t},\n\n\t\tsetActive : function(s) {\n\t\t\tif (s != this.active) {\n\t\t\t\tthis.setState('Active', s);\n\t\t\t\tthis.active = s;\n\t\t\t\tthis.setAriaProperty('pressed', s);\n\t\t\t}\n\t\t},\n\n\t\tisActive : function() {\n\t\t\treturn this.active;\n\t\t},\n\n\t\tsetState : function(c, s) {\n\t\t\tvar n = DOM.get(this.id);\n\n\t\t\tc = this.classPrefix + c;\n\n\t\t\tif (s)\n\t\t\t\tDOM.addClass(n, c);\n\t\t\telse\n\t\t\t\tDOM.removeClass(n, c);\n\t\t},\n\n\t\tisRendered : function() {\n\t\t\treturn this.rendered;\n\t\t},\n\n\t\trenderHTML : function() {\n\t\t},\n\n\t\trenderTo : function(n) {\n\t\t\tDOM.setHTML(n, this.renderHTML());\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, b;\n\n\t\t\t// Set pending states\n\t\t\tif (is(t.disabled)) {\n\t\t\t\tb = t.disabled;\n\t\t\t\tt.disabled = -1;\n\t\t\t\tt.setDisabled(b);\n\t\t\t}\n\n\t\t\tif (is(t.active)) {\n\t\t\t\tb = t.active;\n\t\t\t\tt.active = -1;\n\t\t\t\tt.setActive(b);\n\t\t\t}\n\t\t},\n\n\t\tremove : function() {\n\t\t\tDOM.remove(this.id);\n\t\t\tthis.destroy();\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\ttinymce.dom.Event.clear(this.id);\n\t\t}\n\t});\n})(tinymce);\ntinymce.create('tinymce.ui.Container:tinymce.ui.Control', {\n\tContainer : function(id, s, editor) {\n\t\tthis.parent(id, s, editor);\n\n\t\tthis.controls = [];\n\n\t\tthis.lookup = {};\n\t},\n\n\tadd : function(c) {\n\t\tthis.lookup[c.id] = c;\n\t\tthis.controls.push(c);\n\n\t\treturn c;\n\t},\n\n\tget : function(n) {\n\t\treturn this.lookup[n];\n\t}\n});\n\n\ntinymce.create('tinymce.ui.Separator:tinymce.ui.Control', {\n\tSeparator : function(id, s) {\n\t\tthis.parent(id, s);\n\t\tthis.classPrefix = 'mceSeparator';\n\t\tthis.setDisabled(true);\n\t},\n\n\trenderHTML : function() {\n\t\treturn tinymce.DOM.createHTML('span', {'class' : this.classPrefix, role : 'separator', 'aria-orientation' : 'vertical', tabindex : '-1'});\n\t}\n});\n\n(function(tinymce) {\n\tvar is = tinymce.is, DOM = tinymce.DOM, each = tinymce.each, walk = tinymce.walk;\n\n\ttinymce.create('tinymce.ui.MenuItem:tinymce.ui.Control', {\n\t\tMenuItem : function(id, s) {\n\t\t\tthis.parent(id, s);\n\t\t\tthis.classPrefix = 'mceMenuItem';\n\t\t},\n\n\t\tsetSelected : function(s) {\n\t\t\tthis.setState('Selected', s);\n\t\t\tthis.setAriaProperty('checked', !!s);\n\t\t\tthis.selected = s;\n\t\t},\n\n\t\tisSelected : function() {\n\t\t\treturn this.selected;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this;\n\n\t\t\tt.parent();\n\n\t\t\t// Set pending state\n\t\t\tif (is(t.selected))\n\t\t\t\tt.setSelected(t.selected);\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar is = tinymce.is, DOM = tinymce.DOM, each = tinymce.each, walk = tinymce.walk;\n\n\ttinymce.create('tinymce.ui.Menu:tinymce.ui.MenuItem', {\n\t\tMenu : function(id, s) {\n\t\t\tvar t = this;\n\n\t\t\tt.parent(id, s);\n\t\t\tt.items = {};\n\t\t\tt.collapsed = false;\n\t\t\tt.menuCount = 0;\n\t\t\tt.onAddItem = new tinymce.util.Dispatcher(this);\n\t\t},\n\n\t\texpand : function(d) {\n\t\t\tvar t = this;\n\n\t\t\tif (d) {\n\t\t\t\twalk(t, function(o) {\n\t\t\t\t\tif (o.expand)\n\t\t\t\t\t\to.expand();\n\t\t\t\t}, 'items', t);\n\t\t\t}\n\n\t\t\tt.collapsed = false;\n\t\t},\n\n\t\tcollapse : function(d) {\n\t\t\tvar t = this;\n\n\t\t\tif (d) {\n\t\t\t\twalk(t, function(o) {\n\t\t\t\t\tif (o.collapse)\n\t\t\t\t\t\to.collapse();\n\t\t\t\t}, 'items', t);\n\t\t\t}\n\n\t\t\tt.collapsed = true;\n\t\t},\n\n\t\tisCollapsed : function() {\n\t\t\treturn this.collapsed;\n\t\t},\n\n\t\tadd : function(o) {\n\t\t\tif (!o.settings)\n\t\t\t\to = new tinymce.ui.MenuItem(o.id || DOM.uniqueId(), o);\n\n\t\t\tthis.onAddItem.dispatch(this, o);\n\n\t\t\treturn this.items[o.id] = o;\n\t\t},\n\n\t\taddSeparator : function() {\n\t\t\treturn this.add({separator : true});\n\t\t},\n\n\t\taddMenu : function(o) {\n\t\t\tif (!o.collapse)\n\t\t\t\to = this.createMenu(o);\n\n\t\t\tthis.menuCount++;\n\n\t\t\treturn this.add(o);\n\t\t},\n\n\t\thasMenus : function() {\n\t\t\treturn this.menuCount !== 0;\n\t\t},\n\n\t\tremove : function(o) {\n\t\t\tdelete this.items[o.id];\n\t\t},\n\n\t\tremoveAll : function() {\n\t\t\tvar t = this;\n\n\t\t\twalk(t, function(o) {\n\t\t\t\tif (o.removeAll)\n\t\t\t\t\to.removeAll();\n\t\t\t\telse\n\t\t\t\t\to.remove();\n\n\t\t\t\to.destroy();\n\t\t\t}, 'items', t);\n\n\t\t\tt.items = {};\n\t\t},\n\n\t\tcreateMenu : function(o) {\n\t\t\tvar m = new tinymce.ui.Menu(o.id || DOM.uniqueId(), o);\n\n\t\t\tm.onAddItem.add(this.onAddItem.dispatch, this.onAddItem);\n\n\t\t\treturn m;\n\t\t}\n\t});\n})(tinymce);\n(function(tinymce) {\n\tvar is = tinymce.is, DOM = tinymce.DOM, each = tinymce.each, Event = tinymce.dom.Event, Element = tinymce.dom.Element;\n\n\ttinymce.create('tinymce.ui.DropMenu:tinymce.ui.Menu', {\n\t\tDropMenu : function(id, s) {\n\t\t\ts = s || {};\n\t\t\ts.container = s.container || DOM.doc.body;\n\t\t\ts.offset_x = s.offset_x || 0;\n\t\t\ts.offset_y = s.offset_y || 0;\n\t\t\ts.vp_offset_x = s.vp_offset_x || 0;\n\t\t\ts.vp_offset_y = s.vp_offset_y || 0;\n\n\t\t\tif (is(s.icons) && !s.icons)\n\t\t\t\ts['class'] += ' mceNoIcons';\n\n\t\t\tthis.parent(id, s);\n\t\t\tthis.onShowMenu = new tinymce.util.Dispatcher(this);\n\t\t\tthis.onHideMenu = new tinymce.util.Dispatcher(this);\n\t\t\tthis.classPrefix = 'mceMenu';\n\t\t},\n\n\t\tcreateMenu : function(s) {\n\t\t\tvar t = this, cs = t.settings, m;\n\n\t\t\ts.container = s.container || cs.container;\n\t\t\ts.parent = t;\n\t\t\ts.constrain = s.constrain || cs.constrain;\n\t\t\ts['class'] = s['class'] || cs['class'];\n\t\t\ts.vp_offset_x = s.vp_offset_x || cs.vp_offset_x;\n\t\t\ts.vp_offset_y = s.vp_offset_y || cs.vp_offset_y;\n\t\t\ts.keyboard_focus = cs.keyboard_focus;\n\t\t\tm = new tinymce.ui.DropMenu(s.id || DOM.uniqueId(), s);\n\n\t\t\tm.onAddItem.add(t.onAddItem.dispatch, t.onAddItem);\n\n\t\t\treturn m;\n\t\t},\n\n\t\tfocus : function() {\n\t\t\tvar t = this;\n\t\t\tif (t.keyboardNav) {\n\t\t\t\tt.keyboardNav.focus();\n\t\t\t}\n\t\t},\n\n\t\tupdate : function() {\n\t\t\tvar t = this, s = t.settings, tb = DOM.get('menu_' + t.id + '_tbl'), co = DOM.get('menu_' + t.id + '_co'), tw, th;\n\n\t\t\ttw = s.max_width ? Math.min(tb.clientWidth, s.max_width) : tb.clientWidth;\n\t\t\tth = s.max_height ? Math.min(tb.clientHeight, s.max_height) : tb.clientHeight;\n\n\t\t\tif (!DOM.boxModel)\n\t\t\t\tt.element.setStyles({width : tw + 2, height : th + 2});\n\t\t\telse\n\t\t\t\tt.element.setStyles({width : tw, height : th});\n\n\t\t\tif (s.max_width)\n\t\t\t\tDOM.setStyle(co, 'width', tw);\n\n\t\t\tif (s.max_height) {\n\t\t\t\tDOM.setStyle(co, 'height', th);\n\n\t\t\t\tif (tb.clientHeight < s.max_height)\n\t\t\t\t\tDOM.setStyle(co, 'overflow', 'hidden');\n\t\t\t}\n\t\t},\n\n\t\tshowMenu : function(x, y, px) {\n\t\t\tvar t = this, s = t.settings, co, vp = DOM.getViewPort(), w, h, mx, my, ot = 2, dm, tb, cp = t.classPrefix;\n\n\t\t\tt.collapse(1);\n\n\t\t\tif (t.isMenuVisible)\n\t\t\t\treturn;\n\n\t\t\tif (!t.rendered) {\n\t\t\t\tco = DOM.add(t.settings.container, t.renderNode());\n\n\t\t\t\teach(t.items, function(o) {\n\t\t\t\t\to.postRender();\n\t\t\t\t});\n\n\t\t\t\tt.element = new Element('menu_' + t.id, {blocker : 1, container : s.container});\n\t\t\t} else\n\t\t\t\tco = DOM.get('menu_' + t.id);\n\n\t\t\t// Move layer out of sight unless it's Opera since it scrolls to top of page due to an bug\n\t\t\tif (!tinymce.isOpera)\n\t\t\t\tDOM.setStyles(co, {left : -0xFFFF , top : -0xFFFF});\n\n\t\t\tDOM.show(co);\n\t\t\tt.update();\n\n\t\t\tx += s.offset_x || 0;\n\t\t\ty += s.offset_y || 0;\n\t\t\tvp.w -= 4;\n\t\t\tvp.h -= 4;\n\n\t\t\t// Move inside viewport if not submenu\n\t\t\tif (s.constrain) {\n\t\t\t\tw = co.clientWidth - ot;\n\t\t\t\th = co.clientHeight - ot;\n\t\t\t\tmx = vp.x + vp.w;\n\t\t\t\tmy = vp.y + vp.h;\n\n\t\t\t\tif ((x + s.vp_offset_x + w) > mx)\n\t\t\t\t\tx = px ? px - w : Math.max(0, (mx - s.vp_offset_x) - w);\n\n\t\t\t\tif ((y + s.vp_offset_y + h) > my)\n\t\t\t\t\ty = Math.max(0, (my - s.vp_offset_y) - h);\n\t\t\t}\n\n\t\t\tDOM.setStyles(co, {left : x , top : y});\n\t\t\tt.element.update();\n\n\t\t\tt.isMenuVisible = 1;\n\t\t\tt.mouseClickFunc = Event.add(co, 'click', function(e) {\n\t\t\t\tvar m;\n\n\t\t\t\te = e.target;\n\n\t\t\t\tif (e && (e = DOM.getParent(e, 'tr')) && !DOM.hasClass(e, cp + 'ItemSub')) {\n\t\t\t\t\tm = t.items[e.id];\n\n\t\t\t\t\tif (m.isDisabled())\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tdm = t;\n\n\t\t\t\t\twhile (dm) {\n\t\t\t\t\t\tif (dm.hideMenu)\n\t\t\t\t\t\t\tdm.hideMenu();\n\n\t\t\t\t\t\tdm = dm.settings.parent;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (m.settings.onclick)\n\t\t\t\t\t\tm.settings.onclick(e);\n\n\t\t\t\t\treturn Event.cancel(e); // Cancel to fix onbeforeunload problem\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tif (t.hasMenus()) {\n\t\t\t\tt.mouseOverFunc = Event.add(co, 'mouseover', function(e) {\n\t\t\t\t\tvar m, r, mi;\n\n\t\t\t\t\te = e.target;\n\t\t\t\t\tif (e && (e = DOM.getParent(e, 'tr'))) {\n\t\t\t\t\t\tm = t.items[e.id];\n\n\t\t\t\t\t\tif (t.lastMenu)\n\t\t\t\t\t\t\tt.lastMenu.collapse(1);\n\n\t\t\t\t\t\tif (m.isDisabled())\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tif (e && DOM.hasClass(e, cp + 'ItemSub')) {\n\t\t\t\t\t\t\t//p = DOM.getPos(s.container);\n\t\t\t\t\t\t\tr = DOM.getRect(e);\n\t\t\t\t\t\t\tm.showMenu((r.x + r.w - ot), r.y - ot, r.x);\n\t\t\t\t\t\t\tt.lastMenu = m;\n\t\t\t\t\t\t\tDOM.addClass(DOM.get(m.id).firstChild, cp + 'ItemActive');\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tEvent.add(co, 'keydown', t._keyHandler, t);\n\n\t\t\tt.onShowMenu.dispatch(t);\n\n\t\t\tif (s.keyboard_focus) {\n\t\t\t\tt._setupKeyboardNav();\n\t\t\t}\n\t\t},\n\n\t\thideMenu : function(c) {\n\t\t\tvar t = this, co = DOM.get('menu_' + t.id), e;\n\n\t\t\tif (!t.isMenuVisible)\n\t\t\t\treturn;\n\n\t\t\tif (t.keyboardNav) t.keyboardNav.destroy();\n\t\t\tEvent.remove(co, 'mouseover', t.mouseOverFunc);\n\t\t\tEvent.remove(co, 'click', t.mouseClickFunc);\n\t\t\tEvent.remove(co, 'keydown', t._keyHandler);\n\t\t\tDOM.hide(co);\n\t\t\tt.isMenuVisible = 0;\n\n\t\t\tif (!c)\n\t\t\t\tt.collapse(1);\n\n\t\t\tif (t.element)\n\t\t\t\tt.element.hide();\n\n\t\t\tif (e = DOM.get(t.id))\n\t\t\t\tDOM.removeClass(e.firstChild, t.classPrefix + 'ItemActive');\n\n\t\t\tt.onHideMenu.dispatch(t);\n\t\t},\n\n\t\tadd : function(o) {\n\t\t\tvar t = this, co;\n\n\t\t\to = t.parent(o);\n\n\t\t\tif (t.isRendered && (co = DOM.get('menu_' + t.id)))\n\t\t\t\tt._add(DOM.select('tbody', co)[0], o);\n\n\t\t\treturn o;\n\t\t},\n\n\t\tcollapse : function(d) {\n\t\t\tthis.parent(d);\n\t\t\tthis.hideMenu(1);\n\t\t},\n\n\t\tremove : function(o) {\n\t\t\tDOM.remove(o.id);\n\t\t\tthis.destroy();\n\n\t\t\treturn this.parent(o);\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tvar t = this, co = DOM.get('menu_' + t.id);\n\n\t\t\tif (t.keyboardNav) t.keyboardNav.destroy();\n\t\t\tEvent.remove(co, 'mouseover', t.mouseOverFunc);\n\t\t\tEvent.remove(DOM.select('a', co), 'focus', t.mouseOverFunc);\n\t\t\tEvent.remove(co, 'click', t.mouseClickFunc);\n\t\t\tEvent.remove(co, 'keydown', t._keyHandler);\n\n\t\t\tif (t.element)\n\t\t\t\tt.element.remove();\n\n\t\t\tDOM.remove(co);\n\t\t},\n\n\t\trenderNode : function() {\n\t\t\tvar t = this, s = t.settings, n, tb, co, w;\n\n\t\t\tw = DOM.create('div', {role: 'listbox', id : 'menu_' + t.id, 'class' : s['class'], 'style' : 'position:absolute;left:0;top:0;z-index:200000;outline:0'});\n\t\t\tif (t.settings.parent) {\n\t\t\t\tDOM.setAttrib(w, 'aria-parent', 'menu_' + t.settings.parent.id);\n\t\t\t}\n\t\t\tco = DOM.add(w, 'div', {role: 'presentation', id : 'menu_' + t.id + '_co', 'class' : t.classPrefix + (s['class'] ? ' ' + s['class'] : '')});\n\t\t\tt.element = new Element('menu_' + t.id, {blocker : 1, container : s.container});\n\n\t\t\tif (s.menu_line)\n\t\t\t\tDOM.add(co, 'span', {'class' : t.classPrefix + 'Line'});\n\n//\t\t\tn = DOM.add(co, 'div', {id : 'menu_' + t.id + '_co', 'class' : 'mceMenuContainer'});\n\t\t\tn = DOM.add(co, 'table', {role: 'presentation', id : 'menu_' + t.id + '_tbl', border : 0, cellPadding : 0, cellSpacing : 0});\n\t\t\ttb = DOM.add(n, 'tbody');\n\n\t\t\teach(t.items, function(o) {\n\t\t\t\tt._add(tb, o);\n\t\t\t});\n\n\t\t\tt.rendered = true;\n\n\t\t\treturn w;\n\t\t},\n\n\t\t// Internal functions\n\t\t_setupKeyboardNav : function(){\n\t\t\tvar contextMenu, menuItems, t=this;\n\t\t\tcontextMenu = DOM.select('#menu_' + t.id)[0];\n\t\t\tmenuItems = DOM.select('a[role=option]', 'menu_' + t.id);\n\t\t\tmenuItems.splice(0,0,contextMenu);\n\t\t\tt.keyboardNav = new tinymce.ui.KeyboardNavigation({\n\t\t\t\troot: 'menu_' + t.id,\n\t\t\t\titems: menuItems,\n\t\t\t\tonCancel: function() {\n\t\t\t\t\tt.hideMenu();\n\t\t\t\t},\n\t\t\t\tenableUpDown: true\n\t\t\t});\n\t\t\tcontextMenu.focus();\n\t\t},\n\n\t\t_keyHandler : function(evt) {\n\t\t\tvar t = this, e;\n\t\t\tswitch (evt.keyCode) {\n\t\t\t\tcase 37: // Left\n\t\t\t\t\tif (t.settings.parent) {\n\t\t\t\t\t\tt.hideMenu();\n\t\t\t\t\t\tt.settings.parent.focus();\n\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tcase 39: // Right\n\t\t\t\t\tif (t.mouseOverFunc)\n\t\t\t\t\t\tt.mouseOverFunc(evt);\n\t\t\t\t\tbreak;\n\t\t\t}\n\t\t},\n\n\t\t_add : function(tb, o) {\n\t\t\tvar n, s = o.settings, a, ro, it, cp = this.classPrefix, ic;\n\n\t\t\tif (s.separator) {\n\t\t\t\tro = DOM.add(tb, 'tr', {id : o.id, 'class' : cp + 'ItemSeparator'});\n\t\t\t\tDOM.add(ro, 'td', {'class' : cp + 'ItemSeparator'});\n\n\t\t\t\tif (n = ro.previousSibling)\n\t\t\t\t\tDOM.addClass(n, 'mceLast');\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tn = ro = DOM.add(tb, 'tr', {id : o.id, 'class' : cp + 'Item ' + cp + 'ItemEnabled'});\n\t\t\tn = it = DOM.add(n, s.titleItem ? 'th' : 'td');\n\t\t\tn = a = DOM.add(n, 'a', {id: o.id + '_aria',  role: s.titleItem ? 'presentation' : 'option', href : 'javascript:;', onclick : \"return false;\", onmousedown : 'return false;'});\n\n\t\t\tif (s.parent) {\n\t\t\t\tDOM.setAttrib(a, 'aria-haspopup', 'true');\n\t\t\t\tDOM.setAttrib(a, 'aria-owns', 'menu_' + o.id);\n\t\t\t}\n\n\t\t\tDOM.addClass(it, s['class']);\n//\t\t\tn = DOM.add(n, 'span', {'class' : 'item'});\n\n\t\t\tic = DOM.add(n, 'span', {'class' : 'mceIcon' + (s.icon ? ' mce_' + s.icon : '')});\n\n\t\t\tif (s.icon_src)\n\t\t\t\tDOM.add(ic, 'img', {src : s.icon_src});\n\n\t\t\tn = DOM.add(n, s.element || 'span', {'class' : 'mceText', title : o.settings.title}, o.settings.title);\n\n\t\t\tif (o.settings.style)\n\t\t\t\tDOM.setAttrib(n, 'style', o.settings.style);\n\n\t\t\tif (tb.childNodes.length == 1)\n\t\t\t\tDOM.addClass(ro, 'mceFirst');\n\n\t\t\tif ((n = ro.previousSibling) && DOM.hasClass(n, cp + 'ItemSeparator'))\n\t\t\t\tDOM.addClass(ro, 'mceFirst');\n\n\t\t\tif (o.collapse)\n\t\t\t\tDOM.addClass(ro, cp + 'ItemSub');\n\n\t\t\tif (n = ro.previousSibling)\n\t\t\t\tDOM.removeClass(n, 'mceLast');\n\n\t\t\tDOM.addClass(ro, 'mceLast');\n\t\t}\n\t});\n})(tinymce);\n(function(tinymce) {\n\tvar DOM = tinymce.DOM;\n\n\ttinymce.create('tinymce.ui.Button:tinymce.ui.Control', {\n\t\tButton : function(id, s, ed) {\n\t\t\tthis.parent(id, s, ed);\n\t\t\tthis.classPrefix = 'mceButton';\n\t\t},\n\n\t\trenderHTML : function() {\n\t\t\tvar cp = this.classPrefix, s = this.settings, h, l;\n\n\t\t\tl = DOM.encode(s.label || '');\n\t\t\th = '<a role=\"button\" id=\"' + this.id + '\" href=\"javascript:;\" class=\"' + cp + ' ' + cp + 'Enabled ' + s['class'] + (l ? ' ' + cp + 'Labeled' : '') +'\" onmousedown=\"return false;\" onclick=\"return false;\" aria-labelledby=\"' + this.id + '_voice\" title=\"' + DOM.encode(s.title) + '\">';\n\t\t\tif (s.image && !(this.editor  &&this.editor.forcedHighContrastMode) )\n\t\t\t\th += '<img class=\"mceIcon\" src=\"' + s.image + '\" alt=\"' + DOM.encode(s.title) + '\" />' + l;\n\t\t\telse\n\t\t\t\th += '<span class=\"mceIcon ' + s['class'] + '\"></span>' + (l ? '<span class=\"' + cp + 'Label\">' + l + '</span>' : '');\n\n\t\t\th += '<span class=\"mceVoiceLabel mceIconOnly\" style=\"display: none;\" id=\"' + this.id + '_voice\">' + s.title + '</span>';\n\t\t\th += '</a>';\n\t\t\treturn h;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\ttinymce.dom.Event.add(t.id, 'click', function(e) {\n\t\t\t\tif (!t.isDisabled())\n\t\t\t\t\treturn s.onclick.call(s.scope, e);\n\t\t\t});\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each, Dispatcher = tinymce.util.Dispatcher;\n\n\ttinymce.create('tinymce.ui.ListBox:tinymce.ui.Control', {\n\t\tListBox : function(id, s, ed) {\n\t\t\tvar t = this;\n\n\t\t\tt.parent(id, s, ed);\n\n\t\t\tt.items = [];\n\n\t\t\tt.onChange = new Dispatcher(t);\n\n\t\t\tt.onPostRender = new Dispatcher(t);\n\n\t\t\tt.onAdd = new Dispatcher(t);\n\n\t\t\tt.onRenderMenu = new tinymce.util.Dispatcher(this);\n\n\t\t\tt.classPrefix = 'mceListBox';\n\t\t},\n\n\t\tselect : function(va) {\n\t\t\tvar t = this, fv, f;\n\n\t\t\tif (va == undefined)\n\t\t\t\treturn t.selectByIndex(-1);\n\n\t\t\t// Is string or number make function selector\n\t\t\tif (va && va.call)\n\t\t\t\tf = va;\n\t\t\telse {\n\t\t\t\tf = function(v) {\n\t\t\t\t\treturn v == va;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t// Do we need to do something?\n\t\t\tif (va != t.selectedValue) {\n\t\t\t\t// Find item\n\t\t\t\teach(t.items, function(o, i) {\n\t\t\t\t\tif (f(o.value)) {\n\t\t\t\t\t\tfv = 1;\n\t\t\t\t\t\tt.selectByIndex(i);\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tif (!fv)\n\t\t\t\t\tt.selectByIndex(-1);\n\t\t\t}\n\t\t},\n\n\t\tselectByIndex : function(idx) {\n\t\t\tvar t = this, e, o, label;\n\n\t\t\tif (idx != t.selectedIndex) {\n\t\t\t\te = DOM.get(t.id + '_text');\n\t\t\t\tlabel = DOM.get(t.id + '_voiceDesc');\n\t\t\t\to = t.items[idx];\n\n\t\t\t\tif (o) {\n\t\t\t\t\tt.selectedValue = o.value;\n\t\t\t\t\tt.selectedIndex = idx;\n\t\t\t\t\tDOM.setHTML(e, DOM.encode(o.title));\n\t\t\t\t\tDOM.setHTML(label, t.settings.title + \" - \" + o.title);\n\t\t\t\t\tDOM.removeClass(e, 'mceTitle');\n\t\t\t\t\tDOM.setAttrib(t.id, 'aria-valuenow', o.title);\n\t\t\t\t} else {\n\t\t\t\t\tDOM.setHTML(e, DOM.encode(t.settings.title));\n\t\t\t\t\tDOM.setHTML(label, DOM.encode(t.settings.title));\n\t\t\t\t\tDOM.addClass(e, 'mceTitle');\n\t\t\t\t\tt.selectedValue = t.selectedIndex = null;\n\t\t\t\t\tDOM.setAttrib(t.id, 'aria-valuenow', t.settings.title);\n\t\t\t\t}\n\t\t\t\te = 0;\n\t\t\t}\n\t\t},\n\n\t\tadd : function(n, v, o) {\n\t\t\tvar t = this;\n\n\t\t\to = o || {};\n\t\t\to = tinymce.extend(o, {\n\t\t\t\ttitle : n,\n\t\t\t\tvalue : v\n\t\t\t});\n\n\t\t\tt.items.push(o);\n\t\t\tt.onAdd.dispatch(t, o);\n\t\t},\n\n\t\tgetLength : function() {\n\t\t\treturn this.items.length;\n\t\t},\n\n\t\trenderHTML : function() {\n\t\t\tvar h = '', t = this, s = t.settings, cp = t.classPrefix;\n\n\t\t\th = '<span role=\"listbox\" aria-haspopup=\"true\" aria-labelledby=\"' + t.id +'_voiceDesc\" aria-describedby=\"' + t.id + '_voiceDesc\"><table role=\"presentation\" tabindex=\"0\" id=\"' + t.id + '\" cellpadding=\"0\" cellspacing=\"0\" class=\"' + cp + ' ' + cp + 'Enabled' + (s['class'] ? (' ' + s['class']) : '') + '\"><tbody><tr>';\n\t\t\th += '<td>' + DOM.createHTML('span', {id: t.id + '_voiceDesc', 'class': 'voiceLabel', style:'display:none;'}, t.settings.title);\n\t\t\th += DOM.createHTML('a', {id : t.id + '_text', tabindex : -1, href : 'javascript:;', 'class' : 'mceText', onclick : \"return false;\", onmousedown : 'return false;'}, DOM.encode(t.settings.title)) + '</td>';\n\t\t\th += '<td>' + DOM.createHTML('a', {id : t.id + '_open', tabindex : -1, href : 'javascript:;', 'class' : 'mceOpen', onclick : \"return false;\", onmousedown : 'return false;'}, '<span><span style=\"display:none;\" class=\"mceIconOnly\" aria-hidden=\"true\">\\u25BC</span></span>') + '</td>';\n\t\t\th += '</tr></tbody></table></span>';\n\n\t\t\treturn h;\n\t\t},\n\n\t\tshowMenu : function() {\n\t\t\tvar t = this, p2, e = DOM.get(this.id), m;\n\n\t\t\tif (t.isDisabled() || t.items.length == 0)\n\t\t\t\treturn;\n\n\t\t\tif (t.menu && t.menu.isMenuVisible)\n\t\t\t\treturn t.hideMenu();\n\n\t\t\tif (!t.isMenuRendered) {\n\t\t\t\tt.renderMenu();\n\t\t\t\tt.isMenuRendered = true;\n\t\t\t}\n\n\t\t\tp2 = DOM.getPos(e);\n\n\t\t\tm = t.menu;\n\t\t\tm.settings.offset_x = p2.x;\n\t\t\tm.settings.offset_y = p2.y;\n\t\t\tm.settings.keyboard_focus = !tinymce.isOpera; // Opera is buggy when it comes to auto focus\n\n\t\t\t// Select in menu\n\t\t\tif (t.oldID)\n\t\t\t\tm.items[t.oldID].setSelected(0);\n\n\t\t\teach(t.items, function(o) {\n\t\t\t\tif (o.value === t.selectedValue) {\n\t\t\t\t\tm.items[o.id].setSelected(1);\n\t\t\t\t\tt.oldID = o.id;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tm.showMenu(0, e.clientHeight);\n\n\t\t\tEvent.add(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\tDOM.addClass(t.id, t.classPrefix + 'Selected');\n\n\t\t\t//DOM.get(t.id + '_text').focus();\n\t\t},\n\n\t\thideMenu : function(e) {\n\t\t\tvar t = this;\n\n\t\t\tif (t.menu && t.menu.isMenuVisible) {\n\t\t\t\tDOM.removeClass(t.id, t.classPrefix + 'Selected');\n\n\t\t\t\t// Prevent double toogles by canceling the mouse click event to the button\n\t\t\t\tif (e && e.type == \"mousedown\" && (e.target.id == t.id + '_text' || e.target.id == t.id + '_open'))\n\t\t\t\t\treturn;\n\n\t\t\t\tif (!e || !DOM.getParent(e.target, '.mceMenu')) {\n\t\t\t\t\tDOM.removeClass(t.id, t.classPrefix + 'Selected');\n\t\t\t\t\tEvent.remove(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\t\t\tt.menu.hideMenu();\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\trenderMenu : function() {\n\t\t\tvar t = this, m;\n\n\t\t\tm = t.settings.control_manager.createDropMenu(t.id + '_menu', {\n\t\t\t\tmenu_line : 1,\n\t\t\t\t'class' : t.classPrefix + 'Menu mceNoIcons',\n\t\t\t\tmax_width : 150,\n\t\t\t\tmax_height : 150\n\t\t\t});\n\n\t\t\tm.onHideMenu.add(function() {\n\t\t\t\tt.hideMenu();\n\t\t\t\tt.focus();\n\t\t\t});\n\n\t\t\tm.add({\n\t\t\t\ttitle : t.settings.title,\n\t\t\t\t'class' : 'mceMenuItemTitle',\n\t\t\t\tonclick : function() {\n\t\t\t\t\tif (t.settings.onselect('') !== false)\n\t\t\t\t\t\tt.select(''); // Must be runned after\n\t\t\t\t}\n\t\t\t});\n\n\t\t\teach(t.items, function(o) {\n\t\t\t\t// No value then treat it as a title\n\t\t\t\tif (o.value === undefined) {\n\t\t\t\t\tm.add({\n\t\t\t\t\t\ttitle : o.title,\n\t\t\t\t\t\trole : \"option\",\n\t\t\t\t\t\t'class' : 'mceMenuItemTitle',\n\t\t\t\t\t\tonclick : function() {\n\t\t\t\t\t\t\tif (t.settings.onselect('') !== false)\n\t\t\t\t\t\t\t\tt.select(''); // Must be runned after\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\to.id = DOM.uniqueId();\n\t\t\t\t\to.role= \"option\";\n\t\t\t\t\to.onclick = function() {\n\t\t\t\t\t\tif (t.settings.onselect(o.value) !== false)\n\t\t\t\t\t\t\tt.select(o.value); // Must be runned after\n\t\t\t\t\t};\n\n\t\t\t\t\tm.add(o);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.onRenderMenu.dispatch(t, m);\n\t\t\tt.menu = m;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, cp = t.classPrefix;\n\n\t\t\tEvent.add(t.id, 'click', t.showMenu, t);\n\t\t\tEvent.add(t.id, 'keydown', function(evt) {\n\t\t\t\tif (evt.keyCode == 32) { // Space\n\t\t\t\t\tt.showMenu(evt);\n\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t}\n\t\t\t});\n\t\t\tEvent.add(t.id, 'focus', function() {\n\t\t\t\tif (!t._focused) {\n\t\t\t\t\tt.keyDownHandler = Event.add(t.id, 'keydown', function(e) {\n\t\t\t\t\t\tif (e.keyCode == 40) {\n\t\t\t\t\t\t\tt.showMenu();\n\t\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tt.keyPressHandler = Event.add(t.id, 'keypress', function(e) {\n\t\t\t\t\t\tvar v;\n\t\t\t\t\t\tif (e.keyCode == 13) {\n\t\t\t\t\t\t\t// Fake select on enter\n\t\t\t\t\t\t\tv = t.selectedValue;\n\t\t\t\t\t\t\tt.selectedValue = null; // Needs to be null to fake change\n\t\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t\t\t\tt.settings.onselect(v);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tt._focused = 1;\n\t\t\t});\n\t\t\tEvent.add(t.id, 'blur', function() {\n\t\t\t\tEvent.remove(t.id, 'keydown', t.keyDownHandler);\n\t\t\t\tEvent.remove(t.id, 'keypress', t.keyPressHandler);\n\t\t\t\tt._focused = 0;\n\t\t\t});\n\n\t\t\t// Old IE doesn't have hover on all elements\n\t\t\tif (tinymce.isIE6 || !DOM.boxModel) {\n\t\t\t\tEvent.add(t.id, 'mouseover', function() {\n\t\t\t\t\tif (!DOM.hasClass(t.id, cp + 'Disabled'))\n\t\t\t\t\t\tDOM.addClass(t.id, cp + 'Hover');\n\t\t\t\t});\n\n\t\t\t\tEvent.add(t.id, 'mouseout', function() {\n\t\t\t\t\tif (!DOM.hasClass(t.id, cp + 'Disabled'))\n\t\t\t\t\t\tDOM.removeClass(t.id, cp + 'Hover');\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tt.onPostRender.dispatch(t, DOM.get(t.id));\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tthis.parent();\n\n\t\t\tEvent.clear(this.id + '_text');\n\t\t\tEvent.clear(this.id + '_open');\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each, Dispatcher = tinymce.util.Dispatcher;\n\n\ttinymce.create('tinymce.ui.NativeListBox:tinymce.ui.ListBox', {\n\t\tNativeListBox : function(id, s) {\n\t\t\tthis.parent(id, s);\n\t\t\tthis.classPrefix = 'mceNativeListBox';\n\t\t},\n\n\t\tsetDisabled : function(s) {\n\t\t\tDOM.get(this.id).disabled = s;\n\t\t\tthis.setAriaProperty('disabled', s);\n\t\t},\n\n\t\tisDisabled : function() {\n\t\t\treturn DOM.get(this.id).disabled;\n\t\t},\n\n\t\tselect : function(va) {\n\t\t\tvar t = this, fv, f;\n\n\t\t\tif (va == undefined)\n\t\t\t\treturn t.selectByIndex(-1);\n\n\t\t\t// Is string or number make function selector\n\t\t\tif (va && va.call)\n\t\t\t\tf = va;\n\t\t\telse {\n\t\t\t\tf = function(v) {\n\t\t\t\t\treturn v == va;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t// Do we need to do something?\n\t\t\tif (va != t.selectedValue) {\n\t\t\t\t// Find item\n\t\t\t\teach(t.items, function(o, i) {\n\t\t\t\t\tif (f(o.value)) {\n\t\t\t\t\t\tfv = 1;\n\t\t\t\t\t\tt.selectByIndex(i);\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tif (!fv)\n\t\t\t\t\tt.selectByIndex(-1);\n\t\t\t}\n\t\t},\n\n\t\tselectByIndex : function(idx) {\n\t\t\tDOM.get(this.id).selectedIndex = idx + 1;\n\t\t\tthis.selectedValue = this.items[idx] ? this.items[idx].value : null;\n\t\t},\n\n\t\tadd : function(n, v, a) {\n\t\t\tvar o, t = this;\n\n\t\t\ta = a || {};\n\t\t\ta.value = v;\n\n\t\t\tif (t.isRendered())\n\t\t\t\tDOM.add(DOM.get(this.id), 'option', a, n);\n\n\t\t\to = {\n\t\t\t\ttitle : n,\n\t\t\t\tvalue : v,\n\t\t\t\tattribs : a\n\t\t\t};\n\n\t\t\tt.items.push(o);\n\t\t\tt.onAdd.dispatch(t, o);\n\t\t},\n\n\t\tgetLength : function() {\n\t\t\treturn this.items.length;\n\t\t},\n\n\t\trenderHTML : function() {\n\t\t\tvar h, t = this;\n\n\t\t\th = DOM.createHTML('option', {value : ''}, '-- ' + t.settings.title + ' --');\n\n\t\t\teach(t.items, function(it) {\n\t\t\t\th += DOM.createHTML('option', {value : it.value}, it.title);\n\t\t\t});\n\n\t\t\th = DOM.createHTML('select', {id : t.id, 'class' : 'mceNativeListBox', 'aria-labelledby': t.id + '_aria'}, h);\n\t\t\th += DOM.createHTML('span', {id : t.id + '_aria', 'style': 'display: none'}, t.settings.title);\n\t\t\treturn h;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, ch, changeListenerAdded = true;\n\n\t\t\tt.rendered = true;\n\n\t\t\tfunction onChange(e) {\n\t\t\t\tvar v = t.items[e.target.selectedIndex - 1];\n\n\t\t\t\tif (v && (v = v.value)) {\n\t\t\t\t\tt.onChange.dispatch(t, v);\n\n\t\t\t\t\tif (t.settings.onselect)\n\t\t\t\t\t\tt.settings.onselect(v);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tEvent.add(t.id, 'change', onChange);\n\n\t\t\t// Accessibility keyhandler\n\t\t\tEvent.add(t.id, 'keydown', function(e) {\n\t\t\t\tvar bf;\n\n\t\t\t\tEvent.remove(t.id, 'change', ch);\n\t\t\t\tchangeListenerAdded = false;\n\n\t\t\t\tbf = Event.add(t.id, 'blur', function() {\n\t\t\t\t\tif (changeListenerAdded) return;\n\t\t\t\t\tchangeListenerAdded = true;\n\t\t\t\t\tEvent.add(t.id, 'change', onChange);\n\t\t\t\t\tEvent.remove(t.id, 'blur', bf);\n\t\t\t\t});\n\n\t\t\t\t//prevent default left and right keys on chrome - so that the keyboard navigation is used.\n\t\t\t\tif (tinymce.isWebKit && (e.keyCode==37 ||e.keyCode==39)) {\n\t\t\t\t\treturn Event.prevent(e);\n\t\t\t\t}\n\n\t\t\t\tif (e.keyCode == 13 || e.keyCode == 32) {\n\t\t\t\t\tonChange(e);\n\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.onPostRender.dispatch(t, DOM.get(t.id));\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each;\n\n\ttinymce.create('tinymce.ui.MenuButton:tinymce.ui.Button', {\n\t\tMenuButton : function(id, s, ed) {\n\t\t\tthis.parent(id, s, ed);\n\n\t\t\tthis.onRenderMenu = new tinymce.util.Dispatcher(this);\n\n\t\t\ts.menu_container = s.menu_container || DOM.doc.body;\n\t\t},\n\n\t\tshowMenu : function() {\n\t\t\tvar t = this, p1, p2, e = DOM.get(t.id), m;\n\n\t\t\tif (t.isDisabled())\n\t\t\t\treturn;\n\n\t\t\tif (!t.isMenuRendered) {\n\t\t\t\tt.renderMenu();\n\t\t\t\tt.isMenuRendered = true;\n\t\t\t}\n\n\t\t\tif (t.isMenuVisible)\n\t\t\t\treturn t.hideMenu();\n\n\t\t\tp1 = DOM.getPos(t.settings.menu_container);\n\t\t\tp2 = DOM.getPos(e);\n\n\t\t\tm = t.menu;\n\t\t\tm.settings.offset_x = p2.x;\n\t\t\tm.settings.offset_y = p2.y;\n\t\t\tm.settings.vp_offset_x = p2.x;\n\t\t\tm.settings.vp_offset_y = p2.y;\n\t\t\tm.settings.keyboard_focus = t._focused;\n\t\t\tm.showMenu(0, e.clientHeight);\n\n\t\t\tEvent.add(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\tt.setState('Selected', 1);\n\n\t\t\tt.isMenuVisible = 1;\n\t\t},\n\n\t\trenderMenu : function() {\n\t\t\tvar t = this, m;\n\n\t\t\tm = t.settings.control_manager.createDropMenu(t.id + '_menu', {\n\t\t\t\tmenu_line : 1,\n\t\t\t\t'class' : this.classPrefix + 'Menu',\n\t\t\t\ticons : t.settings.icons\n\t\t\t});\n\n\t\t\tm.onHideMenu.add(function() {\n\t\t\t\tt.hideMenu();\n\t\t\t\tt.focus();\n\t\t\t});\n\n\t\t\tt.onRenderMenu.dispatch(t, m);\n\t\t\tt.menu = m;\n\t\t},\n\n\t\thideMenu : function(e) {\n\t\t\tvar t = this;\n\n\t\t\t// Prevent double toogles by canceling the mouse click event to the button\n\t\t\tif (e && e.type == \"mousedown\" && DOM.getParent(e.target, function(e) {return e.id === t.id || e.id === t.id + '_open';}))\n\t\t\t\treturn;\n\n\t\t\tif (!e || !DOM.getParent(e.target, '.mceMenu')) {\n\t\t\t\tt.setState('Selected', 0);\n\t\t\t\tEvent.remove(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\t\tif (t.menu)\n\t\t\t\t\tt.menu.hideMenu();\n\t\t\t}\n\n\t\t\tt.isMenuVisible = 0;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\tEvent.add(t.id, 'click', function() {\n\t\t\t\tif (!t.isDisabled()) {\n\t\t\t\t\tif (s.onclick)\n\t\t\t\t\t\ts.onclick(t.value);\n\n\t\t\t\t\tt.showMenu();\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each;\n\n\ttinymce.create('tinymce.ui.SplitButton:tinymce.ui.MenuButton', {\n\t\tSplitButton : function(id, s, ed) {\n\t\t\tthis.parent(id, s, ed);\n\t\t\tthis.classPrefix = 'mceSplitButton';\n\t\t},\n\n\t\trenderHTML : function() {\n\t\t\tvar h, t = this, s = t.settings, h1;\n\n\t\t\th = '<tbody><tr>';\n\n\t\t\tif (s.image)\n\t\t\t\th1 = DOM.createHTML('img ', {src : s.image, role: 'presentation', 'class' : 'mceAction ' + s['class']});\n\t\t\telse\n\t\t\t\th1 = DOM.createHTML('span', {'class' : 'mceAction ' + s['class']}, '');\n\n\t\t\th1 += DOM.createHTML('span', {'class': 'mceVoiceLabel mceIconOnly', id: t.id + '_voice', style: 'display:none;'}, s.title);\n\t\t\th += '<td >' + DOM.createHTML('a', {role: 'button', id : t.id + '_action', tabindex: '-1', href : 'javascript:;', 'class' : 'mceAction ' + s['class'], onclick : \"return false;\", onmousedown : 'return false;', title : s.title}, h1) + '</td>';\n\n\t\t\th1 = DOM.createHTML('span', {'class' : 'mceOpen ' + s['class']}, '<span style=\"display:none;\" class=\"mceIconOnly\" aria-hidden=\"true\">\\u25BC</span>');\n\t\t\th += '<td >' + DOM.createHTML('a', {role: 'button', id : t.id + '_open', tabindex: '-1', href : 'javascript:;', 'class' : 'mceOpen ' + s['class'], onclick : \"return false;\", onmousedown : 'return false;', title : s.title}, h1) + '</td>';\n\n\t\t\th += '</tr></tbody>';\n\t\t\th = DOM.createHTML('table', { role: 'presentation',   'class' : 'mceSplitButton mceSplitButtonEnabled ' + s['class'], cellpadding : '0', cellspacing : '0', title : s.title}, h);\n\t\t\treturn DOM.createHTML('div', {id : t.id, role: 'button', tabindex: '0', 'aria-labelledby': t.id + '_voice', 'aria-haspopup': 'true'}, h);\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, s = t.settings, activate;\n\n\t\t\tif (s.onclick) {\n\t\t\t\tactivate = function(evt) {\n\t\t\t\t\tif (!t.isDisabled()) {\n\t\t\t\t\t\ts.onclick(t.value);\n\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t\tEvent.add(t.id + '_action', 'click', activate);\n\t\t\t\tEvent.add(t.id, ['click', 'keydown'], function(evt) {\n\t\t\t\t\tvar DOM_VK_SPACE = 32, DOM_VK_ENTER = 14, DOM_VK_RETURN = 13, DOM_VK_UP = 38, DOM_VK_DOWN = 40;\n\t\t\t\t\tif ((evt.keyCode === 32 || evt.keyCode === 13 || evt.keyCode === 14) && !evt.altKey && !evt.ctrlKey && !evt.metaKey) {\n\t\t\t\t\t\tactivate();\n\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t} else if (evt.type === 'click' || evt.keyCode === DOM_VK_DOWN) {\n\t\t\t\t\t\tt.showMenu();\n\t\t\t\t\t\tEvent.cancel(evt);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tEvent.add(t.id + '_open', 'click', function (evt) {\n\t\t\t\tt.showMenu();\n\t\t\t\tEvent.cancel(evt);\n\t\t\t});\n\t\t\tEvent.add([t.id, t.id + '_open'], 'focus', function() {t._focused = 1;});\n\t\t\tEvent.add([t.id, t.id + '_open'], 'blur', function() {t._focused = 0;});\n\n\t\t\t// Old IE doesn't have hover on all elements\n\t\t\tif (tinymce.isIE6 || !DOM.boxModel) {\n\t\t\t\tEvent.add(t.id, 'mouseover', function() {\n\t\t\t\t\tif (!DOM.hasClass(t.id, 'mceSplitButtonDisabled'))\n\t\t\t\t\t\tDOM.addClass(t.id, 'mceSplitButtonHover');\n\t\t\t\t});\n\n\t\t\t\tEvent.add(t.id, 'mouseout', function() {\n\t\t\t\t\tif (!DOM.hasClass(t.id, 'mceSplitButtonDisabled'))\n\t\t\t\t\t\tDOM.removeClass(t.id, 'mceSplitButtonHover');\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tthis.parent();\n\n\t\t\tEvent.clear(this.id + '_action');\n\t\t\tEvent.clear(this.id + '_open');\n\t\t\tEvent.clear(this.id);\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, is = tinymce.is, each = tinymce.each;\n\n\ttinymce.create('tinymce.ui.ColorSplitButton:tinymce.ui.SplitButton', {\n\t\tColorSplitButton : function(id, s, ed) {\n\t\t\tvar t = this;\n\n\t\t\tt.parent(id, s, ed);\n\n\t\t\tt.settings = s = tinymce.extend({\n\t\t\t\tcolors : '000000,993300,333300,003300,003366,000080,333399,333333,800000,FF6600,808000,008000,008080,0000FF,666699,808080,FF0000,FF9900,99CC00,339966,33CCCC,3366FF,800080,999999,FF00FF,FFCC00,FFFF00,00FF00,00FFFF,00CCFF,993366,C0C0C0,FF99CC,FFCC99,FFFF99,CCFFCC,CCFFFF,99CCFF,CC99FF,FFFFFF',\n\t\t\t\tgrid_width : 8,\n\t\t\t\tdefault_color : '#888888'\n\t\t\t}, t.settings);\n\n\t\t\tt.onShowMenu = new tinymce.util.Dispatcher(t);\n\n\t\t\tt.onHideMenu = new tinymce.util.Dispatcher(t);\n\n\t\t\tt.value = s.default_color;\n\t\t},\n\n\t\tshowMenu : function() {\n\t\t\tvar t = this, r, p, e, p2;\n\n\t\t\tif (t.isDisabled())\n\t\t\t\treturn;\n\n\t\t\tif (!t.isMenuRendered) {\n\t\t\t\tt.renderMenu();\n\t\t\t\tt.isMenuRendered = true;\n\t\t\t}\n\n\t\t\tif (t.isMenuVisible)\n\t\t\t\treturn t.hideMenu();\n\n\t\t\te = DOM.get(t.id);\n\t\t\tDOM.show(t.id + '_menu');\n\t\t\tDOM.addClass(e, 'mceSplitButtonSelected');\n\t\t\tp2 = DOM.getPos(e);\n\t\t\tDOM.setStyles(t.id + '_menu', {\n\t\t\t\tleft : p2.x,\n\t\t\t\ttop : p2.y + e.clientHeight,\n\t\t\t\tzIndex : 200000\n\t\t\t});\n\t\t\te = 0;\n\n\t\t\tEvent.add(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\tt.onShowMenu.dispatch(t);\n\n\t\t\tif (t._focused) {\n\t\t\t\tt._keyHandler = Event.add(t.id + '_menu', 'keydown', function(e) {\n\t\t\t\t\tif (e.keyCode == 27)\n\t\t\t\t\t\tt.hideMenu();\n\t\t\t\t});\n\n\t\t\t\tDOM.select('a', t.id + '_menu')[0].focus(); // Select first link\n\t\t\t}\n\n\t\t\tt.isMenuVisible = 1;\n\t\t},\n\n\t\thideMenu : function(e) {\n\t\t\tvar t = this;\n\n\t\t\tif (t.isMenuVisible) {\n\t\t\t\t// Prevent double toogles by canceling the mouse click event to the button\n\t\t\t\tif (e && e.type == \"mousedown\" && DOM.getParent(e.target, function(e) {return e.id === t.id + '_open';}))\n\t\t\t\t\treturn;\n\n\t\t\t\tif (!e || !DOM.getParent(e.target, '.mceSplitButtonMenu')) {\n\t\t\t\t\tDOM.removeClass(t.id, 'mceSplitButtonSelected');\n\t\t\t\t\tEvent.remove(DOM.doc, 'mousedown', t.hideMenu, t);\n\t\t\t\t\tEvent.remove(t.id + '_menu', 'keydown', t._keyHandler);\n\t\t\t\t\tDOM.hide(t.id + '_menu');\n\t\t\t\t}\n\n\t\t\t\tt.isMenuVisible = 0;\n\t\t\t\tt.onHideMenu.dispatch();\n\t\t\t}\n\t\t},\n\n\t\trenderMenu : function() {\n\t\t\tvar t = this, m, i = 0, s = t.settings, n, tb, tr, w, context;\n\n\t\t\tw = DOM.add(s.menu_container, 'div', {role: 'listbox', id : t.id + '_menu', 'class' : s['menu_class'] + ' ' + s['class'], style : 'position:absolute;left:0;top:-1000px;'});\n\t\t\tm = DOM.add(w, 'div', {'class' : s['class'] + ' mceSplitButtonMenu'});\n\t\t\tDOM.add(m, 'span', {'class' : 'mceMenuLine'});\n\n\t\t\tn = DOM.add(m, 'table', {role: 'presentation', 'class' : 'mceColorSplitMenu'});\n\t\t\ttb = DOM.add(n, 'tbody');\n\n\t\t\t// Generate color grid\n\t\t\ti = 0;\n\t\t\teach(is(s.colors, 'array') ? s.colors : s.colors.split(','), function(c) {\n\t\t\t\tc = c.replace(/^#/, '');\n\n\t\t\t\tif (!i--) {\n\t\t\t\t\ttr = DOM.add(tb, 'tr');\n\t\t\t\t\ti = s.grid_width - 1;\n\t\t\t\t}\n\n\t\t\t\tn = DOM.add(tr, 'td');\n\t\t\t\tn = DOM.add(n, 'a', {\n\t\t\t\t\trole : 'option',\n\t\t\t\t\thref : 'javascript:;',\n\t\t\t\t\tstyle : {\n\t\t\t\t\t\tbackgroundColor : '#' + c\n\t\t\t\t\t},\n\t\t\t\t\t'title': t.editor.getLang('colors.' + c, c),\n\t\t\t\t\t'data-mce-color' : '#' + c\n\t\t\t\t});\n\n\t\t\t\tif (t.editor.forcedHighContrastMode) {\n\t\t\t\t\tn = DOM.add(n, 'canvas', { width: 16, height: 16, 'aria-hidden': 'true' });\n\t\t\t\t\tif (n.getContext && (context = n.getContext(\"2d\"))) {\n\t\t\t\t\t\tcontext.fillStyle = '#' + c;\n\t\t\t\t\t\tcontext.fillRect(0, 0, 16, 16);\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// No point leaving a canvas element around if it's not supported for drawing on anyway.\n\t\t\t\t\t\tDOM.remove(n);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tif (s.more_colors_func) {\n\t\t\t\tn = DOM.add(tb, 'tr');\n\t\t\t\tn = DOM.add(n, 'td', {colspan : s.grid_width, 'class' : 'mceMoreColors'});\n\t\t\t\tn = DOM.add(n, 'a', {role: 'option', id : t.id + '_more', href : 'javascript:;', onclick : 'return false;', 'class' : 'mceMoreColors'}, s.more_colors_title);\n\n\t\t\t\tEvent.add(n, 'click', function(e) {\n\t\t\t\t\ts.more_colors_func.call(s.more_colors_scope || this);\n\t\t\t\t\treturn Event.cancel(e); // Cancel to fix onbeforeunload problem\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tDOM.addClass(m, 'mceColorSplitMenu');\n\n\t\t\tnew tinymce.ui.KeyboardNavigation({\n\t\t\t\troot: t.id + '_menu',\n\t\t\t\titems: DOM.select('a', t.id + '_menu'),\n\t\t\t\tonCancel: function() {\n\t\t\t\t\tt.hideMenu();\n\t\t\t\t\tt.focus();\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Prevent IE from scrolling and hindering click to occur #4019\n\t\t\tEvent.add(t.id + '_menu', 'mousedown', function(e) {return Event.cancel(e);});\n\n\t\t\tEvent.add(t.id + '_menu', 'click', function(e) {\n\t\t\t\tvar c;\n\n\t\t\t\te = DOM.getParent(e.target, 'a', tb);\n\n\t\t\t\tif (e && e.nodeName.toLowerCase() == 'a' && (c = e.getAttribute('data-mce-color')))\n\t\t\t\t\tt.setColor(c);\n\n\t\t\t\treturn Event.cancel(e); // Prevent IE auto save warning\n\t\t\t});\n\n\t\t\treturn w;\n\t\t},\n\n\t\tsetColor : function(c) {\n\t\t\tthis.displayColor(c);\n\t\t\tthis.hideMenu();\n\t\t\tthis.settings.onselect(c);\n\t\t},\n\n\t\tdisplayColor : function(c) {\n\t\t\tvar t = this;\n\n\t\t\tDOM.setStyle(t.id + '_preview', 'backgroundColor', c);\n\n\t\t\tt.value = c;\n\t\t},\n\n\t\tpostRender : function() {\n\t\t\tvar t = this, id = t.id;\n\n\t\t\tt.parent();\n\t\t\tDOM.add(id + '_action', 'div', {id : id + '_preview', 'class' : 'mceColorPreview'});\n\t\t\tDOM.setStyle(t.id + '_preview', 'backgroundColor', t.value);\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\tthis.parent();\n\n\t\t\tEvent.clear(this.id + '_menu');\n\t\t\tEvent.clear(this.id + '_more');\n\t\t\tDOM.remove(this.id + '_menu');\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n// Shorten class names\nvar dom = tinymce.DOM, each = tinymce.each, Event = tinymce.dom.Event;\ntinymce.create('tinymce.ui.ToolbarGroup:tinymce.ui.Container', {\n\trenderHTML : function() {\n\t\tvar t = this, h = [], controls = t.controls, each = tinymce.each, settings = t.settings;\n\n\t\th.push('<div id=\"' + t.id + '\" role=\"group\" aria-labelledby=\"' + t.id + '_voice\">');\n\t\t//TODO: ACC test this out - adding a role = application for getting the landmarks working well.\n\t\th.push(\"<span role='application'>\");\n\t\th.push('<span id=\"' + t.id + '_voice\" class=\"mceVoiceLabel\" style=\"display:none;\">' + dom.encode(settings.name) + '</span>');\n\t\teach(controls, function(toolbar) {\n\t\t\th.push(toolbar.renderHTML());\n\t\t});\n\t\th.push(\"</span>\");\n\t\th.push('</div>');\n\n\t\treturn h.join('');\n\t},\n\n\tfocus : function() {\n\t\tvar t = this;\n\t\tdom.get(t.id).focus();\n\t},\n\n\tpostRender : function() {\n\t\tvar t = this, items = [];\n\n\t\teach(t.controls, function(toolbar) {\n\t\t\teach (toolbar.controls, function(control) {\n\t\t\t\tif (control.id) {\n\t\t\t\t\titems.push(control);\n\t\t\t\t}\n\t\t\t});\n\t\t});\n\n\t\tt.keyNav = new tinymce.ui.KeyboardNavigation({\n\t\t\troot: t.id,\n\t\t\titems: items,\n\t\t\tonCancel: function() {\n\t\t\t\t//Move focus if webkit so that navigation back will read the item.\n\t\t\t\tif (tinymce.isWebKit) {\n\t\t\t\t\tdom.get(t.editor.id+\"_ifr\").focus();\n\t\t\t\t}\n\t\t\t\tt.editor.focus();\n\t\t\t},\n\t\t\texcludeFromTabOrder: !t.settings.tab_focus_toolbar\n\t\t});\n\t},\n\n\tdestroy : function() {\n\t\tvar self = this;\n\n\t\tself.parent();\n\t\tself.keyNav.destroy();\n\t\tEvent.clear(self.id);\n\t}\n});\n})(tinymce);\n\n(function(tinymce) {\n// Shorten class names\nvar dom = tinymce.DOM, each = tinymce.each;\ntinymce.create('tinymce.ui.Toolbar:tinymce.ui.Container', {\n\trenderHTML : function() {\n\t\tvar t = this, h = '', c, co, s = t.settings, i, pr, nx, cl;\n\n\t\tcl = t.controls;\n\t\tfor (i=0; i<cl.length; i++) {\n\t\t\t// Get current control, prev control, next control and if the control is a list box or not\n\t\t\tco = cl[i];\n\t\t\tpr = cl[i - 1];\n\t\t\tnx = cl[i + 1];\n\n\t\t\t// Add toolbar start\n\t\t\tif (i === 0) {\n\t\t\t\tc = 'mceToolbarStart';\n\n\t\t\t\tif (co.Button)\n\t\t\t\t\tc += ' mceToolbarStartButton';\n\t\t\t\telse if (co.SplitButton)\n\t\t\t\t\tc += ' mceToolbarStartSplitButton';\n\t\t\t\telse if (co.ListBox)\n\t\t\t\t\tc += ' mceToolbarStartListBox';\n\n\t\t\t\th += dom.createHTML('td', {'class' : c}, dom.createHTML('span', null, '<!-- IE -->'));\n\t\t\t}\n\n\t\t\t// Add toolbar end before list box and after the previous button\n\t\t\t// This is to fix the o2k7 editor skins\n\t\t\tif (pr && co.ListBox) {\n\t\t\t\tif (pr.Button || pr.SplitButton)\n\t\t\t\t\th += dom.createHTML('td', {'class' : 'mceToolbarEnd'}, dom.createHTML('span', null, '<!-- IE -->'));\n\t\t\t}\n\n\t\t\t// Render control HTML\n\n\t\t\t// IE 8 quick fix, needed to propertly generate a hit area for anchors\n\t\t\tif (dom.stdMode)\n\t\t\t\th += '<td style=\"position: relative\">' + co.renderHTML() + '</td>';\n\t\t\telse\n\t\t\t\th += '<td>' + co.renderHTML() + '</td>';\n\n\t\t\t// Add toolbar start after list box and before the next button\n\t\t\t// This is to fix the o2k7 editor skins\n\t\t\tif (nx && co.ListBox) {\n\t\t\t\tif (nx.Button || nx.SplitButton)\n\t\t\t\t\th += dom.createHTML('td', {'class' : 'mceToolbarStart'}, dom.createHTML('span', null, '<!-- IE -->'));\n\t\t\t}\n\t\t}\n\n\t\tc = 'mceToolbarEnd';\n\n\t\tif (co.Button)\n\t\t\tc += ' mceToolbarEndButton';\n\t\telse if (co.SplitButton)\n\t\t\tc += ' mceToolbarEndSplitButton';\n\t\telse if (co.ListBox)\n\t\t\tc += ' mceToolbarEndListBox';\n\n\t\th += dom.createHTML('td', {'class' : c}, dom.createHTML('span', null, '<!-- IE -->'));\n\n\t\treturn dom.createHTML('table', {id : t.id, 'class' : 'mceToolbar' + (s['class'] ? ' ' + s['class'] : ''), cellpadding : '0', cellspacing : '0', align : t.settings.align || '', role: 'presentation', tabindex: '-1'}, '<tbody><tr>' + h + '</tr></tbody>');\n\t}\n});\n})(tinymce);\n\n(function(tinymce) {\n\tvar Dispatcher = tinymce.util.Dispatcher, each = tinymce.each;\n\n\ttinymce.create('tinymce.AddOnManager', {\n\t\tAddOnManager : function() {\n\t\t\tvar self = this;\n\n\t\t\tself.items = [];\n\t\t\tself.urls = {};\n\t\t\tself.lookup = {};\n\t\t\tself.onAdd = new Dispatcher(self);\n\t\t},\n\n\t\tget : function(n) {\n\t\t\tif (this.lookup[n]) {\n\t\t\t\treturn this.lookup[n].instance;\n\t\t\t} else {\n\t\t\t\treturn undefined;\n\t\t\t}\n\t\t},\n\n\t\tdependencies : function(n) {\n\t\t\tvar result;\n\t\t\tif (this.lookup[n]) {\n\t\t\t\tresult = this.lookup[n].dependencies;\n\t\t\t}\n\t\t\treturn result || [];\n\t\t},\n\n\t\trequireLangPack : function(n) {\n\t\t\tvar s = tinymce.settings;\n\n\t\t\tif (s && s.language && s.language_load !== false)\n\t\t\t\ttinymce.ScriptLoader.add(this.urls[n] + '/langs/' + s.language + '.js');\n\t\t},\n\n\t\tadd : function(id, o, dependencies) {\n\t\t\tthis.items.push(o);\n\t\t\tthis.lookup[id] = {instance:o, dependencies:dependencies};\n\t\t\tthis.onAdd.dispatch(this, id, o);\n\n\t\t\treturn o;\n\t\t},\n\t\tcreateUrl: function(baseUrl, dep) {\n\t\t\tif (typeof dep === \"object\") {\n\t\t\t\treturn dep\n\t\t\t} else {\n\t\t\t\treturn {prefix: baseUrl.prefix, resource: dep, suffix: baseUrl.suffix};\n\t\t\t}\n\t\t},\n\n\t\taddComponents: function(pluginName, scripts) {\n\t\t\tvar pluginUrl = this.urls[pluginName];\n\t\t\ttinymce.each(scripts, function(script){\n\t\t\t\ttinymce.ScriptLoader.add(pluginUrl+\"/\"+script);\n\t\t\t});\n\t\t},\n\n\t\tload : function(n, u, cb, s) {\n\t\t\tvar t = this, url = u;\n\n\t\t\tfunction loadDependencies() {\n\t\t\t\tvar dependencies = t.dependencies(n);\n\t\t\t\ttinymce.each(dependencies, function(dep) {\n\t\t\t\t\tvar newUrl = t.createUrl(u, dep);\n\t\t\t\t\tt.load(newUrl.resource, newUrl, undefined, undefined);\n\t\t\t\t});\n\t\t\t\tif (cb) {\n\t\t\t\t\tif (s) {\n\t\t\t\t\t\tcb.call(s);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tcb.call(tinymce.ScriptLoader);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (t.urls[n])\n\t\t\t\treturn;\n\t\t\tif (typeof u === \"object\")\n\t\t\t\turl = u.prefix + u.resource + u.suffix;\n\n\t\t\tif (url.indexOf('/') != 0 && url.indexOf('://') == -1)\n\t\t\t\turl = tinymce.baseURL + '/' + url;\n\n\t\t\tt.urls[n] = url.substring(0, url.lastIndexOf('/'));\n\n\t\t\tif (t.lookup[n]) {\n\t\t\t\tloadDependencies();\n\t\t\t} else {\n\t\t\t\ttinymce.ScriptLoader.add(url, loadDependencies, s);\n\t\t\t}\n\t\t}\n\t});\n\n\t// Create plugin and theme managers\n\ttinymce.PluginManager = new tinymce.AddOnManager();\n\ttinymce.ThemeManager = new tinymce.AddOnManager();\n}(tinymce));\n\n(function(tinymce) {\n\t// Shorten names\n\tvar each = tinymce.each, extend = tinymce.extend,\n\t\tDOM = tinymce.DOM, Event = tinymce.dom.Event,\n\t\tThemeManager = tinymce.ThemeManager, PluginManager = tinymce.PluginManager,\n\t\texplode = tinymce.explode,\n\t\tDispatcher = tinymce.util.Dispatcher, undefined, instanceCounter = 0;\n\n\t// Setup some URLs where the editor API is located and where the document is\n\ttinymce.documentBaseURL = window.location.href.replace(/[\\?#].*$/, '').replace(/[\\/\\\\][^\\/]+$/, '');\n\tif (!/[\\/\\\\]$/.test(tinymce.documentBaseURL))\n\t\ttinymce.documentBaseURL += '/';\n\n\ttinymce.baseURL = new tinymce.util.URI(tinymce.documentBaseURL).toAbsolute(tinymce.baseURL);\n\n\ttinymce.baseURI = new tinymce.util.URI(tinymce.baseURL);\n\n\t// Add before unload listener\n\t// This was required since IE was leaking memory if you added and removed beforeunload listeners\n\t// with attachEvent/detatchEvent so this only adds one listener and instances can the attach to the onBeforeUnload event\n\ttinymce.onBeforeUnload = new Dispatcher(tinymce);\n\n\t// Must be on window or IE will leak if the editor is placed in frame or iframe\n\tEvent.add(window, 'beforeunload', function(e) {\n\t\ttinymce.onBeforeUnload.dispatch(tinymce, e);\n\t});\n\n\ttinymce.onAddEditor = new Dispatcher(tinymce);\n\n\ttinymce.onRemoveEditor = new Dispatcher(tinymce);\n\n\ttinymce.EditorManager = extend(tinymce, {\n\t\teditors : [],\n\n\t\ti18n : {},\n\n\t\tactiveEditor : null,\n\n\t\tinit : function(s) {\n\t\t\tvar t = this, pl, sl = tinymce.ScriptLoader, e, el = [], ed;\n\n\t\t\tfunction execCallback(se, n, s) {\n\t\t\t\tvar f = se[n];\n\n\t\t\t\tif (!f)\n\t\t\t\t\treturn;\n\n\t\t\t\tif (tinymce.is(f, 'string')) {\n\t\t\t\t\ts = f.replace(/\\.\\w+$/, '');\n\t\t\t\t\ts = s ? tinymce.resolve(s) : 0;\n\t\t\t\t\tf = tinymce.resolve(f);\n\t\t\t\t}\n\n\t\t\t\treturn f.apply(s || this, Array.prototype.slice.call(arguments, 2));\n\t\t\t};\n\n\t\t\ts = extend({\n\t\t\t\ttheme : \"simple\",\n\t\t\t\tlanguage : \"en\"\n\t\t\t}, s);\n\n\t\t\tt.settings = s;\n\n\t\t\t// Legacy call\n\t\t\tEvent.add(document, 'init', function() {\n\t\t\t\tvar l, co;\n\n\t\t\t\texecCallback(s, 'onpageload');\n\n\t\t\t\tswitch (s.mode) {\n\t\t\t\t\tcase \"exact\":\n\t\t\t\t\t\tl = s.elements || '';\n\n\t\t\t\t\t\tif(l.length > 0) {\n\t\t\t\t\t\t\teach(explode(l), function(v) {\n\t\t\t\t\t\t\t\tif (DOM.get(v)) {\n\t\t\t\t\t\t\t\t\ted = new tinymce.Editor(v, s);\n\t\t\t\t\t\t\t\t\tel.push(ed);\n\t\t\t\t\t\t\t\t\ted.render(1);\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\teach(document.forms, function(f) {\n\t\t\t\t\t\t\t\t\t\teach(f.elements, function(e) {\n\t\t\t\t\t\t\t\t\t\t\tif (e.name === v) {\n\t\t\t\t\t\t\t\t\t\t\t\tv = 'mce_editor_' + instanceCounter++;\n\t\t\t\t\t\t\t\t\t\t\t\tDOM.setAttrib(e, 'id', v);\n\n\t\t\t\t\t\t\t\t\t\t\t\ted = new tinymce.Editor(v, s);\n\t\t\t\t\t\t\t\t\t\t\t\tel.push(ed);\n\t\t\t\t\t\t\t\t\t\t\t\ted.render(1);\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase \"textareas\":\n\t\t\t\t\tcase \"specific_textareas\":\n\t\t\t\t\t\tfunction hasClass(n, c) {\n\t\t\t\t\t\t\treturn c.constructor === RegExp ? c.test(n.className) : DOM.hasClass(n, c);\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\teach(DOM.select('textarea'), function(v) {\n\t\t\t\t\t\t\tif (s.editor_deselector && hasClass(v, s.editor_deselector))\n\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\tif (!s.editor_selector || hasClass(v, s.editor_selector)) {\n\t\t\t\t\t\t\t\t// Can we use the name\n\t\t\t\t\t\t\t\te = DOM.get(v.name);\n\t\t\t\t\t\t\t\tif (!v.id && !e)\n\t\t\t\t\t\t\t\t\tv.id = v.name;\n\n\t\t\t\t\t\t\t\t// Generate unique name if missing or already exists\n\t\t\t\t\t\t\t\tif (!v.id || t.get(v.id))\n\t\t\t\t\t\t\t\t\tv.id = DOM.uniqueId();\n\n\t\t\t\t\t\t\t\ted = new tinymce.Editor(v.id, s);\n\t\t\t\t\t\t\t\tel.push(ed);\n\t\t\t\t\t\t\t\ted.render(1);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\t// Call onInit when all editors are initialized\n\t\t\t\tif (s.oninit) {\n\t\t\t\t\tl = co = 0;\n\n\t\t\t\t\teach(el, function(ed) {\n\t\t\t\t\t\tco++;\n\n\t\t\t\t\t\tif (!ed.initialized) {\n\t\t\t\t\t\t\t// Wait for it\n\t\t\t\t\t\t\ted.onInit.add(function() {\n\t\t\t\t\t\t\t\tl++;\n\n\t\t\t\t\t\t\t\t// All done\n\t\t\t\t\t\t\t\tif (l == co)\n\t\t\t\t\t\t\t\t\texecCallback(s, 'oninit');\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\tl++;\n\n\t\t\t\t\t\t// All done\n\t\t\t\t\t\tif (l == co)\n\t\t\t\t\t\t\texecCallback(s, 'oninit');\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\tget : function(id) {\n\t\t\tif (id === undefined)\n\t\t\t\treturn this.editors;\n\n\t\t\treturn this.editors[id];\n\t\t},\n\n\t\tgetInstanceById : function(id) {\n\t\t\treturn this.get(id);\n\t\t},\n\n\t\tadd : function(editor) {\n\t\t\tvar self = this, editors = self.editors;\n\n\t\t\t// Add named and index editor instance\n\t\t\teditors[editor.id] = editor;\n\t\t\teditors.push(editor);\n\n\t\t\tself._setActive(editor);\n\t\t\tself.onAddEditor.dispatch(self, editor);\n\n\n\t\t\t// Patch the tinymce.Editor instance with jQuery adapter logic\n\t\t\tif (tinymce.adapter)\n\t\t\t\ttinymce.adapter.patchEditor(editor);\n\n\n\t\t\treturn editor;\n\t\t},\n\n\t\tremove : function(editor) {\n\t\t\tvar t = this, i, editors = t.editors;\n\n\t\t\t// Not in the collection\n\t\t\tif (!editors[editor.id])\n\t\t\t\treturn null;\n\n\t\t\tdelete editors[editor.id];\n\n\t\t\tfor (i = 0; i < editors.length; i++) {\n\t\t\t\tif (editors[i] == editor) {\n\t\t\t\t\teditors.splice(i, 1);\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Select another editor since the active one was removed\n\t\t\tif (t.activeEditor == editor)\n\t\t\t\tt._setActive(editors[0]);\n\n\t\t\teditor.destroy();\n\t\t\tt.onRemoveEditor.dispatch(t, editor);\n\n\t\t\treturn editor;\n\t\t},\n\n\t\texecCommand : function(c, u, v) {\n\t\t\tvar t = this, ed = t.get(v), w;\n\n\t\t\t// Manager commands\n\t\t\tswitch (c) {\n\t\t\t\tcase \"mceFocus\":\n\t\t\t\t\ted.focus();\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase \"mceAddEditor\":\n\t\t\t\tcase \"mceAddControl\":\n\t\t\t\t\tif (!t.get(v))\n\t\t\t\t\t\tnew tinymce.Editor(v, t.settings).render();\n\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase \"mceAddFrameControl\":\n\t\t\t\t\tw = v.window;\n\n\t\t\t\t\t// Add tinyMCE global instance and tinymce namespace to specified window\n\t\t\t\t\tw.tinyMCE = tinyMCE;\n\t\t\t\t\tw.tinymce = tinymce;\n\n\t\t\t\t\ttinymce.DOM.doc = w.document;\n\t\t\t\t\ttinymce.DOM.win = w;\n\n\t\t\t\t\ted = new tinymce.Editor(v.element_id, v);\n\t\t\t\t\ted.render();\n\n\t\t\t\t\t// Fix IE memory leaks\n\t\t\t\t\tif (tinymce.isIE) {\n\t\t\t\t\t\tfunction clr() {\n\t\t\t\t\t\t\ted.destroy();\n\t\t\t\t\t\t\tw.detachEvent('onunload', clr);\n\t\t\t\t\t\t\tw = w.tinyMCE = w.tinymce = null; // IE leak\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tw.attachEvent('onunload', clr);\n\t\t\t\t\t}\n\n\t\t\t\t\tv.page_window = null;\n\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase \"mceRemoveEditor\":\n\t\t\t\tcase \"mceRemoveControl\":\n\t\t\t\t\tif (ed)\n\t\t\t\t\t\ted.remove();\n\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase 'mceToggleEditor':\n\t\t\t\t\tif (!ed) {\n\t\t\t\t\t\tt.execCommand('mceAddControl', 0, v);\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (ed.isHidden())\n\t\t\t\t\t\ted.show();\n\t\t\t\t\telse\n\t\t\t\t\t\ted.hide();\n\n\t\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Run command on active editor\n\t\t\tif (t.activeEditor)\n\t\t\t\treturn t.activeEditor.execCommand(c, u, v);\n\n\t\t\treturn false;\n\t\t},\n\n\t\texecInstanceCommand : function(id, c, u, v) {\n\t\t\tvar ed = this.get(id);\n\n\t\t\tif (ed)\n\t\t\t\treturn ed.execCommand(c, u, v);\n\n\t\t\treturn false;\n\t\t},\n\n\t\ttriggerSave : function() {\n\t\t\teach(this.editors, function(e) {\n\t\t\t\te.save();\n\t\t\t});\n\t\t},\n\n\t\taddI18n : function(p, o) {\n\t\t\tvar lo, i18n = this.i18n;\n\n\t\t\tif (!tinymce.is(p, 'string')) {\n\t\t\t\teach(p, function(o, lc) {\n\t\t\t\t\teach(o, function(o, g) {\n\t\t\t\t\t\teach(o, function(o, k) {\n\t\t\t\t\t\t\tif (g === 'common')\n\t\t\t\t\t\t\t\ti18n[lc + '.' + k] = o;\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\ti18n[lc + '.' + g + '.' + k] = o;\n\t\t\t\t\t\t});\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\teach(o, function(o, k) {\n\t\t\t\t\ti18n[p + '.' + k] = o;\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\t// Private methods\n\n\t\t_setActive : function(editor) {\n\t\t\tthis.selectedInstance = this.activeEditor = editor;\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\t// Shorten these names\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, extend = tinymce.extend,\n\t\tDispatcher = tinymce.util.Dispatcher, each = tinymce.each, isGecko = tinymce.isGecko,\n\t\tisIE = tinymce.isIE, isWebKit = tinymce.isWebKit, is = tinymce.is,\n\t\tThemeManager = tinymce.ThemeManager, PluginManager = tinymce.PluginManager,\n\t\tinArray = tinymce.inArray, grep = tinymce.grep, explode = tinymce.explode;\n\n\ttinymce.create('tinymce.Editor', {\n\t\tEditor : function(id, s) {\n\t\t\tvar t = this;\n\n\t\t\tt.id = t.editorId = id;\n\n\t\t\tt.execCommands = {};\n\t\t\tt.queryStateCommands = {};\n\t\t\tt.queryValueCommands = {};\n\n\t\t\tt.isNotDirty = false;\n\n\t\t\tt.plugins = {};\n\n\t\t\t// Add events to the editor\n\t\t\teach([\n\t\t\t\t'onPreInit',\n\n\t\t\t\t'onBeforeRenderUI',\n\n\t\t\t\t'onPostRender',\n\n\t\t\t\t'onInit',\n\n\t\t\t\t'onRemove',\n\n\t\t\t\t'onActivate',\n\n\t\t\t\t'onDeactivate',\n\n\t\t\t\t'onClick',\n\n\t\t\t\t'onEvent',\n\n\t\t\t\t'onMouseUp',\n\n\t\t\t\t'onMouseDown',\n\n\t\t\t\t'onDblClick',\n\n\t\t\t\t'onKeyDown',\n\n\t\t\t\t'onKeyUp',\n\n\t\t\t\t'onKeyPress',\n\n\t\t\t\t'onContextMenu',\n\n\t\t\t\t'onSubmit',\n\n\t\t\t\t'onReset',\n\n\t\t\t\t'onPaste',\n\n\t\t\t\t'onPreProcess',\n\n\t\t\t\t'onPostProcess',\n\n\t\t\t\t'onBeforeSetContent',\n\n\t\t\t\t'onBeforeGetContent',\n\n\t\t\t\t'onSetContent',\n\n\t\t\t\t'onGetContent',\n\n\t\t\t\t'onLoadContent',\n\n\t\t\t\t'onSaveContent',\n\n\t\t\t\t'onNodeChange',\n\n\t\t\t\t'onChange',\n\n\t\t\t\t'onBeforeExecCommand',\n\n\t\t\t\t'onExecCommand',\n\n\t\t\t\t'onUndo',\n\n\t\t\t\t'onRedo',\n\n\t\t\t\t'onVisualAid',\n\n\t\t\t\t'onSetProgressState'\n\t\t\t], function(e) {\n\t\t\t\tt[e] = new Dispatcher(t);\n\t\t\t});\n\n\t\t\tt.settings = s = extend({\n\t\t\t\tid : id,\n\t\t\t\tlanguage : 'en',\n\t\t\t\tdocs_language : 'en',\n\t\t\t\ttheme : 'simple',\n\t\t\t\tskin : 'default',\n\t\t\t\tdelta_width : 0,\n\t\t\t\tdelta_height : 0,\n\t\t\t\tpopup_css : '',\n\t\t\t\tplugins : '',\n\t\t\t\tdocument_base_url : tinymce.documentBaseURL,\n\t\t\t\tadd_form_submit_trigger : 1,\n\t\t\t\tsubmit_patch : 1,\n\t\t\t\tadd_unload_trigger : 1,\n\t\t\t\tconvert_urls : 1,\n\t\t\t\trelative_urls : 1,\n\t\t\t\tremove_script_host : 1,\n\t\t\t\ttable_inline_editing : 0,\n\t\t\t\tobject_resizing : 1,\n\t\t\t\tcleanup : 1,\n\t\t\t\taccessibility_focus : 1,\n\t\t\t\tcustom_shortcuts : 1,\n\t\t\t\tcustom_undo_redo_keyboard_shortcuts : 1,\n\t\t\t\tcustom_undo_redo_restore_selection : 1,\n\t\t\t\tcustom_undo_redo : 1,\n\t\t\t\tdoctype : tinymce.isIE6 ? '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">' : '<!DOCTYPE>', // Use old doctype on IE 6 to avoid horizontal scroll\n\t\t\t\tvisual_table_class : 'mceItemTable',\n\t\t\t\tvisual : 1,\n\t\t\t\tfont_size_style_values : 'xx-small,x-small,small,medium,large,x-large,xx-large',\n\t\t\t\tfont_size_legacy_values : 'xx-small,small,medium,large,x-large,xx-large,300%', // See: http://www.w3.org/TR/CSS2/fonts.html#propdef-font-size\n\t\t\t\tapply_source_formatting : 1,\n\t\t\t\tdirectionality : 'ltr',\n\t\t\t\tforced_root_block : 'p',\n\t\t\t\thidden_input : 1,\n\t\t\t\tpadd_empty_editor : 1,\n\t\t\t\trender_ui : 1,\n\t\t\t\tinit_theme : 1,\n\t\t\t\tforce_p_newlines : 1,\n\t\t\t\tindentation : '30px',\n\t\t\t\tkeep_styles : 1,\n\t\t\t\tfix_table_elements : 1,\n\t\t\t\tinline_styles : 1,\n\t\t\t\tconvert_fonts_to_spans : true,\n\t\t\t\tindent : 'simple',\n\t\t\t\tindent_before : 'p,h1,h2,h3,h4,h5,h6,blockquote,div,title,style,pre,script,td,ul,li,area,table,thead,tfoot,tbody,tr',\n\t\t\t\tindent_after : 'p,h1,h2,h3,h4,h5,h6,blockquote,div,title,style,pre,script,td,ul,li,area,table,thead,tfoot,tbody,tr',\n\t\t\t\tvalidate : true,\n\t\t\t\tentity_encoding : 'named',\n\t\t\t\turl_converter : t.convertURL,\n\t\t\t\turl_converter_scope : t,\n\t\t\t\tie7_compat : true\n\t\t\t}, s);\n\n\t\t\tt.documentBaseURI = new tinymce.util.URI(s.document_base_url || tinymce.documentBaseURL, {\n\t\t\t\tbase_uri : tinyMCE.baseURI\n\t\t\t});\n\n\t\t\tt.baseURI = tinymce.baseURI;\n\n\t\t\tt.contentCSS = [];\n\n\t\t\t// Call setup\n\t\t\tt.execCallback('setup', t);\n\t\t},\n\n\t\trender : function(nst) {\n\t\t\tvar t = this, s = t.settings, id = t.id, sl = tinymce.ScriptLoader;\n\n\t\t\t// Page is not loaded yet, wait for it\n\t\t\tif (!Event.domLoaded) {\n\t\t\t\tEvent.add(document, 'init', function() {\n\t\t\t\t\tt.render();\n\t\t\t\t});\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\ttinyMCE.settings = s;\n\n\t\t\t// Element not found, then skip initialization\n\t\t\tif (!t.getElement())\n\t\t\t\treturn;\n\n\t\t\t// Is a iPad/iPhone and not on iOS5, then skip initialization. We need to sniff\n\t\t\t// here since the browser says it has contentEditable support but there is no visible\n\t\t\t// caret We will remove this check ones Apple implements full contentEditable support\n\t\t\tif (tinymce.isIDevice && !tinymce.isIOS5)\n\t\t\t\treturn;\n\n\t\t\t// Add hidden input for non input elements inside form elements\n\t\t\tif (!/TEXTAREA|INPUT/i.test(t.getElement().nodeName) && s.hidden_input && DOM.getParent(id, 'form'))\n\t\t\t\tDOM.insertAfter(DOM.create('input', {type : 'hidden', name : id}), id);\n\n\t\t\tif (tinymce.WindowManager)\n\t\t\t\tt.windowManager = new tinymce.WindowManager(t);\n\n\t\t\tif (s.encoding == 'xml') {\n\t\t\t\tt.onGetContent.add(function(ed, o) {\n\t\t\t\t\tif (o.save)\n\t\t\t\t\t\to.content = DOM.encode(o.content);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.add_form_submit_trigger) {\n\t\t\t\tt.onSubmit.addToTop(function() {\n\t\t\t\t\tif (t.initialized) {\n\t\t\t\t\t\tt.save();\n\t\t\t\t\t\tt.isNotDirty = 1;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.add_unload_trigger) {\n\t\t\t\tt._beforeUnload = tinyMCE.onBeforeUnload.add(function() {\n\t\t\t\t\tif (t.initialized && !t.destroyed && !t.isHidden())\n\t\t\t\t\t\tt.save({format : 'raw', no_events : true});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\ttinymce.addUnload(t.destroy, t);\n\n\t\t\tif (s.submit_patch) {\n\t\t\t\tt.onBeforeRenderUI.add(function() {\n\t\t\t\t\tvar n = t.getElement().form;\n\n\t\t\t\t\tif (!n)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Already patched\n\t\t\t\t\tif (n._mceOldSubmit)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Check page uses id=\"submit\" or name=\"submit\" for it's submit button\n\t\t\t\t\tif (!n.submit.nodeType && !n.submit.length) {\n\t\t\t\t\t\tt.formElement = n;\n\t\t\t\t\t\tn._mceOldSubmit = n.submit;\n\t\t\t\t\t\tn.submit = function() {\n\t\t\t\t\t\t\t// Save all instances\n\t\t\t\t\t\t\ttinymce.triggerSave();\n\t\t\t\t\t\t\tt.isNotDirty = 1;\n\n\t\t\t\t\t\t\treturn t.formElement._mceOldSubmit(t.formElement);\n\t\t\t\t\t\t};\n\t\t\t\t\t}\n\n\t\t\t\t\tn = null;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Load scripts\n\t\t\tfunction loadScripts() {\n\t\t\t\tif (s.language && s.language_load !== false)\n\t\t\t\t\tsl.add(tinymce.baseURL + '/langs/' + s.language + '.js');\n\n\t\t\t\tif (s.theme && s.theme.charAt(0) != '-' && !ThemeManager.urls[s.theme])\n\t\t\t\t\tThemeManager.load(s.theme, 'themes/' + s.theme + '/editor_template' + tinymce.suffix + '.js');\n\n\t\t\t\teach(explode(s.plugins), function(p) {\n\t\t\t\t\tif (p &&!PluginManager.urls[p]) {\n\t\t\t\t\t\tif (p.charAt(0) == '-') {\n\t\t\t\t\t\t\tp = p.substr(1, p.length);\n\t\t\t\t\t\t\tvar dependencies = PluginManager.dependencies(p);\n\t\t\t\t\t\t\teach(dependencies, function(dep) {\n\t\t\t\t\t\t\t\tvar defaultSettings = {prefix:'plugins/', resource: dep, suffix:'/editor_plugin' + tinymce.suffix + '.js'};\n\t\t\t\t\t\t\t\tvar dep = PluginManager.createUrl(defaultSettings, dep);\n\t\t\t\t\t\t\t\tPluginManager.load(dep.resource, dep);\n\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Skip safari plugin, since it is removed as of 3.3b1\n\t\t\t\t\t\t\tif (p == 'safari') {\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tPluginManager.load(p, {prefix:'plugins/', resource: p, suffix:'/editor_plugin' + tinymce.suffix + '.js'});\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// Init when que is loaded\n\t\t\t\tsl.loadQueue(function() {\n\t\t\t\t\tif (!t.removed)\n\t\t\t\t\t\tt.init();\n\t\t\t\t});\n\t\t\t};\n\n\t\t\tloadScripts();\n\t\t},\n\n\t\tinit : function() {\n\t\t\tvar n, t = this, s = t.settings, w, h, e = t.getElement(), o, ti, u, bi, bc, re, i, initializedPlugins = [];\n\n\t\t\ttinymce.add(t);\n\n\t\t\ts.aria_label = s.aria_label || DOM.getAttrib(e, 'aria-label', t.getLang('aria.rich_text_area'));\n\n\t\t\tif (s.theme) {\n\t\t\t\ts.theme = s.theme.replace(/-/, '');\n\t\t\t\to = ThemeManager.get(s.theme);\n\t\t\t\tt.theme = new o();\n\n\t\t\t\tif (t.theme.init && s.init_theme)\n\t\t\t\t\tt.theme.init(t, ThemeManager.urls[s.theme] || tinymce.documentBaseURL.replace(/\\/$/, ''));\n\t\t\t}\n\t\t\tfunction initPlugin(p) {\n\t\t\t\tvar c = PluginManager.get(p), u = PluginManager.urls[p] || tinymce.documentBaseURL.replace(/\\/$/, ''), po;\n\t\t\t\tif (c && tinymce.inArray(initializedPlugins,p) === -1) {\n\t\t\t\t\teach(PluginManager.dependencies(p), function(dep){\n\t\t\t\t\t\tinitPlugin(dep);\n\t\t\t\t\t});\n\t\t\t\t\tpo = new c(t, u);\n\n\t\t\t\t\tt.plugins[p] = po;\n\n\t\t\t\t\tif (po.init) {\n\t\t\t\t\t\tpo.init(t, u);\n\t\t\t\t\t\tinitializedPlugins.push(p);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Create all plugins\n\t\t\teach(explode(s.plugins.replace(/\\-/g, '')), initPlugin);\n\n\t\t\t// Setup popup CSS path(s)\n\t\t\tif (s.popup_css !== false) {\n\t\t\t\tif (s.popup_css)\n\t\t\t\t\ts.popup_css = t.documentBaseURI.toAbsolute(s.popup_css);\n\t\t\t\telse\n\t\t\t\t\ts.popup_css = t.baseURI.toAbsolute(\"themes/\" + s.theme + \"/skins/\" + s.skin + \"/dialog.css\");\n\t\t\t}\n\n\t\t\tif (s.popup_css_add)\n\t\t\t\ts.popup_css += ',' + t.documentBaseURI.toAbsolute(s.popup_css_add);\n\n\t\t\tt.controlManager = new tinymce.ControlManager(t);\n\n\t\t\tif (s.custom_undo_redo) {\n\t\t\t\tt.onBeforeExecCommand.add(function(ed, cmd, ui, val, a) {\n\t\t\t\t\tif (cmd != 'Undo' && cmd != 'Redo' && cmd != 'mceRepaint' && (!a || !a.skip_undo))\n\t\t\t\t\t\tt.undoManager.beforeChange();\n\t\t\t\t});\n\n\t\t\t\tt.onExecCommand.add(function(ed, cmd, ui, val, a) {\n\t\t\t\t\tif (cmd != 'Undo' && cmd != 'Redo' && cmd != 'mceRepaint' && (!a || !a.skip_undo))\n\t\t\t\t\t\tt.undoManager.add();\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tt.onExecCommand.add(function(ed, c) {\n\t\t\t\t// Don't refresh the select lists until caret move\n\t\t\t\tif (!/^(FontName|FontSize)$/.test(c))\n\t\t\t\t\tt.nodeChanged();\n\t\t\t});\n\n\t\t\t// Remove ghost selections on images and tables in Gecko\n\t\t\tif (isGecko) {\n\t\t\t\tfunction repaint(a, o) {\n\t\t\t\t\tif (!o || !o.initial)\n\t\t\t\t\t\tt.execCommand('mceRepaint');\n\t\t\t\t};\n\n\t\t\t\tt.onUndo.add(repaint);\n\t\t\t\tt.onRedo.add(repaint);\n\t\t\t\tt.onSetContent.add(repaint);\n\t\t\t}\n\n\t\t\t// Enables users to override the control factory\n\t\t\tt.onBeforeRenderUI.dispatch(t, t.controlManager);\n\n\t\t\t// Measure box\n\t\t\tif (s.render_ui) {\n\t\t\t\tw = s.width || e.style.width || e.offsetWidth;\n\t\t\t\th = s.height || e.style.height || e.offsetHeight;\n\t\t\t\tt.orgDisplay = e.style.display;\n\t\t\t\tre = /^[0-9\\.]+(|px)$/i;\n\n\t\t\t\tif (re.test('' + w))\n\t\t\t\t\tw = Math.max(parseInt(w) + (o.deltaWidth || 0), 100);\n\n\t\t\t\tif (re.test('' + h))\n\t\t\t\t\th = Math.max(parseInt(h) + (o.deltaHeight || 0), 100);\n\n\t\t\t\t// Render UI\n\t\t\t\to = t.theme.renderUI({\n\t\t\t\t\ttargetNode : e,\n\t\t\t\t\twidth : w,\n\t\t\t\t\theight : h,\n\t\t\t\t\tdeltaWidth : s.delta_width,\n\t\t\t\t\tdeltaHeight : s.delta_height\n\t\t\t\t});\n\n\t\t\t\tt.editorContainer = o.editorContainer;\n\t\t\t}\n\n\n\t\t\t// User specified a document.domain value\n\t\t\tif (document.domain && location.hostname != document.domain)\n\t\t\t\ttinymce.relaxedDomain = document.domain;\n\n\t\t\t// Resize editor\n\t\t\tDOM.setStyles(o.sizeContainer || o.editorContainer, {\n\t\t\t\twidth : w,\n\t\t\t\theight : h\n\t\t\t});\n\n\t\t\t// Load specified content CSS last\n\t\t\tif (s.content_css) {\n\t\t\t\ttinymce.each(explode(s.content_css), function(u) {\n\t\t\t\t\tt.contentCSS.push(t.documentBaseURI.toAbsolute(u));\n\t\t\t\t});\n\t\t\t}\n\n\t\t\th = (o.iframeHeight || h) + (typeof(h) == 'number' ? (o.deltaHeight || 0) : '');\n\t\t\tif (h < 100)\n\t\t\t\th = 100;\n\n\t\t\tt.iframeHTML = s.doctype + '<html><head xmlns=\"http://www.w3.org/1999/xhtml\">';\n\n\t\t\t// We only need to override paths if we have to\n\t\t\t// IE has a bug where it remove site absolute urls to relative ones if this is specified\n\t\t\tif (s.document_base_url != tinymce.documentBaseURL)\n\t\t\t\tt.iframeHTML += '<base href=\"' + t.documentBaseURI.getURI() + '\" />';\n\n\t\t\t// IE8 doesn't support carets behind images setting ie7_compat would force IE8+ to run in IE7 compat mode.\n\t\t\tif (s.ie7_compat)\n\t\t\t\tt.iframeHTML += '<meta http-equiv=\"X-UA-Compatible\" content=\"IE=7\" />';\n\t\t\telse\n\t\t\t\tt.iframeHTML += '<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />';\n\n\t\t\tt.iframeHTML += '<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />';\n\n\t\t\t// Load the CSS by injecting them into the HTML this will reduce \"flicker\"\n\t\t\tfor (i = 0; i < t.contentCSS.length; i++) {\n\t\t\t\tt.iframeHTML += '<link type=\"text/css\" rel=\"stylesheet\" href=\"' + t.contentCSS[i] + '\" />';\n\t\t\t}\n\n\t\t\tbi = s.body_id || 'tinymce';\n\t\t\tif (bi.indexOf('=') != -1) {\n\t\t\t\tbi = t.getParam('body_id', '', 'hash');\n\t\t\t\tbi = bi[t.id] || bi;\n\t\t\t}\n\n\t\t\tbc = s.body_class || '';\n\t\t\tif (bc.indexOf('=') != -1) {\n\t\t\t\tbc = t.getParam('body_class', '', 'hash');\n\t\t\t\tbc = bc[t.id] || '';\n\t\t\t}\n\n\t\t\tt.iframeHTML += '</head><body id=\"' + bi + '\" class=\"mceContentBody ' + bc + '\"><br></body></html>';\n\n\t\t\t// Domain relaxing enabled, then set document domain\n\t\t\tif (tinymce.relaxedDomain && (isIE || (tinymce.isOpera && parseFloat(opera.version()) < 11))) {\n\t\t\t\t// We need to write the contents here in IE since multiple writes messes up refresh button and back button\n\t\t\t\tu = 'javascript:(function(){document.open();document.domain=\"' + document.domain + '\";var ed = window.parent.tinyMCE.get(\"' + t.id + '\");document.write(ed.iframeHTML);document.close();ed.setupIframe();})()';\n\t\t\t}\n\n\t\t\t// Create iframe\n\t\t\t// TODO: ACC add the appropriate description on this.\n\t\t\tn = DOM.add(o.iframeContainer, 'iframe', {\n\t\t\t\tid : t.id + \"_ifr\",\n\t\t\t\tsrc : u || 'javascript:\"\"', // Workaround for HTTPS warning in IE6/7\n\t\t\t\tframeBorder : '0',\n\t\t\t\tallowTransparency : \"true\",\n\t\t\t\ttitle : s.aria_label,\n\t\t\t\tstyle : {\n\t\t\t\t\twidth : '100%',\n\t\t\t\t\theight : h,\n\t\t\t\t\tdisplay : 'block' // Important for Gecko to render the iframe correctly\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.contentAreaContainer = o.iframeContainer;\n\t\t\tDOM.get(o.editorContainer).style.display = t.orgDisplay;\n\t\t\tDOM.get(t.id).style.display = 'none';\n\t\t\tDOM.setAttrib(t.id, 'aria-hidden', true);\n\n\t\t\tif (!tinymce.relaxedDomain || !u)\n\t\t\t\tt.setupIframe();\n\n\t\t\te = n = o = null; // Cleanup\n\t\t},\n\n\t\tsetupIframe : function() {\n\t\t\tvar t = this, s = t.settings, e = DOM.get(t.id), d = t.getDoc(), h, b;\n\n\t\t\t// Setup iframe body\n\t\t\tif (!isIE || !tinymce.relaxedDomain) {\n\t\t\t\td.open();\n\t\t\t\td.write(t.iframeHTML);\n\t\t\t\td.close();\n\n\t\t\t\tif (tinymce.relaxedDomain)\n\t\t\t\t\td.domain = tinymce.relaxedDomain;\n\t\t\t}\n\n\t\t\t// It will not steal focus while setting contentEditable\n\t\t\tb = t.getBody();\n\t\t\tb.disabled = true;\n\n\t\t\tif (!s.readonly)\n\t\t\t\tb.contentEditable = true;\n\n\t\t\tb.disabled = false;\n\n\t\t\tt.schema = new tinymce.html.Schema(s);\n\n\t\t\tt.dom = new tinymce.dom.DOMUtils(t.getDoc(), {\n\t\t\t\tkeep_values : true,\n\t\t\t\turl_converter : t.convertURL,\n\t\t\t\turl_converter_scope : t,\n\t\t\t\thex_colors : s.force_hex_style_colors,\n\t\t\t\tclass_filter : s.class_filter,\n\t\t\t\tupdate_styles : 1,\n\t\t\t\tfix_ie_paragraphs : 1,\n\t\t\t\tschema : t.schema\n\t\t\t});\n\n\t\t\tt.parser = new tinymce.html.DomParser(s, t.schema);\n\n\t\t\t// Force anchor names closed, unless the setting \"allow_html_in_named_anchor\" is explicitly included.\n\t\t\tif (!t.settings.allow_html_in_named_anchor) {\n\t\t\t\tt.parser.addAttributeFilter('name', function(nodes, name) {\n\t\t\t\t\tvar i = nodes.length, sibling, prevSibling, parent, node;\n\n\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\t\tif (node.name === 'a' && node.firstChild) {\n\t\t\t\t\t\t\tparent = node.parent;\n\n\t\t\t\t\t\t\t// Move children after current node\n\t\t\t\t\t\t\tsibling = node.lastChild;\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\tprevSibling = sibling.prev;\n\t\t\t\t\t\t\t\tparent.insert(sibling, node);\n\t\t\t\t\t\t\t\tsibling = prevSibling;\n\t\t\t\t\t\t\t} while (sibling);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Convert src and href into data-mce-src, data-mce-href and data-mce-style\n\t\t\tt.parser.addAttributeFilter('src,href,style', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node, dom = t.dom, value, internalName;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tvalue = node.attr(name);\n\t\t\t\t\tinternalName = 'data-mce-' + name;\n\n\t\t\t\t\t// Add internal attribute if we need to we don't on a refresh of the document\n\t\t\t\t\tif (!node.attributes.map[internalName]) {\n\t\t\t\t\t\tif (name === \"style\")\n\t\t\t\t\t\t\tnode.attr(internalName, dom.serializeStyle(dom.parseStyle(value), node.name));\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tnode.attr(internalName, t.convertURL(value, name, node.name));\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Keep scripts from executing\n\t\t\tt.parser.addNodeFilter('script', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tnode.attr('type', 'mce-' + (node.attr('type') || 'text/javascript'));\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.parser.addNodeFilter('#cdata', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tnode.type = 8;\n\t\t\t\t\tnode.name = '#comment';\n\t\t\t\t\tnode.value = '[CDATA[' + node.value + ']]';\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.parser.addNodeFilter('p,h1,h2,h3,h4,h5,h6,div', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node, nonEmptyElements = t.schema.getNonEmptyElements();\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\n\t\t\t\t\tif (node.isEmpty(nonEmptyElements))\n\t\t\t\t\t\tnode.empty().append(new tinymce.html.Node('br', 1)).shortEnded = true;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.serializer = new tinymce.dom.Serializer(s, t.dom, t.schema);\n\n\t\t\tt.selection = new tinymce.dom.Selection(t.dom, t.getWin(), t.serializer);\n\n\t\t\tt.formatter = new tinymce.Formatter(this);\n\n\t\t\t// Register default formats\n\t\t\tt.formatter.register({\n\t\t\t\talignleft : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'left'}},\n\t\t\t\t\t{selector : 'img,table', collapsed : false, styles : {'float' : 'left'}}\n\t\t\t\t],\n\n\t\t\t\taligncenter : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'center'}},\n\t\t\t\t\t{selector : 'img', collapsed : false, styles : {display : 'block', marginLeft : 'auto', marginRight : 'auto'}},\n\t\t\t\t\t{selector : 'table', collapsed : false, styles : {marginLeft : 'auto', marginRight : 'auto'}}\n\t\t\t\t],\n\n\t\t\t\talignright : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'right'}},\n\t\t\t\t\t{selector : 'img,table', collapsed : false, styles : {'float' : 'right'}}\n\t\t\t\t],\n\n\t\t\t\talignfull : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'justify'}}\n\t\t\t\t],\n\n\t\t\t\tbold : [\n\t\t\t\t\t{inline : 'strong', remove : 'all'},\n\t\t\t\t\t{inline : 'span', styles : {fontWeight : 'bold'}},\n\t\t\t\t\t{inline : 'b', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\titalic : [\n\t\t\t\t\t{inline : 'em', remove : 'all'},\n\t\t\t\t\t{inline : 'span', styles : {fontStyle : 'italic'}},\n\t\t\t\t\t{inline : 'i', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\tunderline : [\n\t\t\t\t\t{inline : 'span', styles : {textDecoration : 'underline'}, exact : true},\n\t\t\t\t\t{inline : 'u', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\tstrikethrough : [\n\t\t\t\t\t{inline : 'span', styles : {textDecoration : 'line-through'}, exact : true},\n\t\t\t\t\t{inline : 'strike', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\tforecolor : {inline : 'span', styles : {color : '%value'}, wrap_links : false},\n\t\t\t\thilitecolor : {inline : 'span', styles : {backgroundColor : '%value'}, wrap_links : false},\n\t\t\t\tfontname : {inline : 'span', styles : {fontFamily : '%value'}},\n\t\t\t\tfontsize : {inline : 'span', styles : {fontSize : '%value'}},\n\t\t\t\tfontsize_class : {inline : 'span', attributes : {'class' : '%value'}},\n\t\t\t\tblockquote : {block : 'blockquote', wrapper : 1, remove : 'all'},\n\t\t\t\tsubscript : {inline : 'sub'},\n\t\t\t\tsuperscript : {inline : 'sup'},\n\n\t\t\t\tlink : {inline : 'a', selector : 'a', remove : 'all', split : true, deep : true,\n\t\t\t\t\tonmatch : function(node) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t},\n\n\t\t\t\t\tonformat : function(elm, fmt, vars) {\n\t\t\t\t\t\teach(vars, function(value, key) {\n\t\t\t\t\t\t\tt.dom.setAttrib(elm, key, value);\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tremoveformat : [\n\t\t\t\t\t{selector : 'b,strong,em,i,font,u,strike', remove : 'all', split : true, expand : false, block_expand : true, deep : true},\n\t\t\t\t\t{selector : 'span', attributes : ['style', 'class'], remove : 'empty', split : true, expand : false, deep : true},\n\t\t\t\t\t{selector : '*', attributes : ['style', 'class'], split : false, expand : false, deep : true}\n\t\t\t\t]\n\t\t\t});\n\n\t\t\t// Register default block formats\n\t\t\teach('p h1 h2 h3 h4 h5 h6 div address pre div code dt dd samp'.split(/\\s/), function(name) {\n\t\t\t\tt.formatter.register(name, {block : name, remove : 'all'});\n\t\t\t});\n\n\t\t\t// Register user defined formats\n\t\t\tt.formatter.register(t.settings.formats);\n\n\t\t\tt.undoManager = new tinymce.UndoManager(t);\n\n\t\t\t// Pass through\n\t\t\tt.undoManager.onAdd.add(function(um, l) {\n\t\t\t\tif (um.hasUndo())\n\t\t\t\t\treturn t.onChange.dispatch(t, l, um);\n\t\t\t});\n\n\t\t\tt.undoManager.onUndo.add(function(um, l) {\n\t\t\t\treturn t.onUndo.dispatch(t, l, um);\n\t\t\t});\n\n\t\t\tt.undoManager.onRedo.add(function(um, l) {\n\t\t\t\treturn t.onRedo.dispatch(t, l, um);\n\t\t\t});\n\n\t\t\tt.forceBlocks = new tinymce.ForceBlocks(t, {\n\t\t\t\tforced_root_block : s.forced_root_block\n\t\t\t});\n\n\t\t\tt.editorCommands = new tinymce.EditorCommands(t);\n\n\t\t\t// Pass through\n\t\t\tt.serializer.onPreProcess.add(function(se, o) {\n\t\t\t\treturn t.onPreProcess.dispatch(t, o, se);\n\t\t\t});\n\n\t\t\tt.serializer.onPostProcess.add(function(se, o) {\n\t\t\t\treturn t.onPostProcess.dispatch(t, o, se);\n\t\t\t});\n\n\t\t\tt.onPreInit.dispatch(t);\n\n\t\t\tif (!s.gecko_spellcheck)\n\t\t\t\tt.getBody().spellcheck = 0;\n\n\t\t\tif (!s.readonly)\n\t\t\t\tt._addEvents();\n\n\t\t\tt.controlManager.onPostRender.dispatch(t, t.controlManager);\n\t\t\tt.onPostRender.dispatch(t);\n\n\t\t\tt.quirks = new tinymce.util.Quirks(this);\n\n\t\t\tif (s.directionality)\n\t\t\t\tt.getBody().dir = s.directionality;\n\n\t\t\tif (s.nowrap)\n\t\t\t\tt.getBody().style.whiteSpace = \"nowrap\";\n\n\t\t\tif (s.handle_node_change_callback) {\n\t\t\t\tt.onNodeChange.add(function(ed, cm, n) {\n\t\t\t\t\tt.execCallback('handle_node_change_callback', t.id, n, -1, -1, true, t.selection.isCollapsed());\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.save_callback) {\n\t\t\t\tt.onSaveContent.add(function(ed, o) {\n\t\t\t\t\tvar h = t.execCallback('save_callback', t.id, o.content, t.getBody());\n\n\t\t\t\t\tif (h)\n\t\t\t\t\t\to.content = h;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.onchange_callback) {\n\t\t\t\tt.onChange.add(function(ed, l) {\n\t\t\t\t\tt.execCallback('onchange_callback', t, l);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.protect) {\n\t\t\t\tt.onBeforeSetContent.add(function(ed, o) {\n\t\t\t\t\tif (s.protect) {\n\t\t\t\t\t\teach(s.protect, function(pattern) {\n\t\t\t\t\t\t\to.content = o.content.replace(pattern, function(str) {\n\t\t\t\t\t\t\t\treturn '<!--mce:protected ' + escape(str) + '-->';\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.convert_newlines_to_brs) {\n\t\t\t\tt.onBeforeSetContent.add(function(ed, o) {\n\t\t\t\t\tif (o.initial)\n\t\t\t\t\t\to.content = o.content.replace(/\\r?\\n/g, '<br />');\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.preformatted) {\n\t\t\t\tt.onPostProcess.add(function(ed, o) {\n\t\t\t\t\to.content = o.content.replace(/^\\s*<pre.*?>/, '');\n\t\t\t\t\to.content = o.content.replace(/<\\/pre>\\s*$/, '');\n\n\t\t\t\t\tif (o.set)\n\t\t\t\t\t\to.content = '<pre class=\"mceItemHidden\">' + o.content + '</pre>';\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.verify_css_classes) {\n\t\t\t\tt.serializer.attribValueFilter = function(n, v) {\n\t\t\t\t\tvar s, cl;\n\n\t\t\t\t\tif (n == 'class') {\n\t\t\t\t\t\t// Build regexp for classes\n\t\t\t\t\t\tif (!t.classesRE) {\n\t\t\t\t\t\t\tcl = t.dom.getClasses();\n\n\t\t\t\t\t\t\tif (cl.length > 0) {\n\t\t\t\t\t\t\t\ts = '';\n\n\t\t\t\t\t\t\t\teach (cl, function(o) {\n\t\t\t\t\t\t\t\t\ts += (s ? '|' : '') + o['class'];\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\tt.classesRE = new RegExp('(' + s + ')', 'gi');\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn !t.classesRE || /(\\bmceItem\\w+\\b|\\bmceTemp\\w+\\b)/g.test(v) || t.classesRE.test(v) ? v : '';\n\t\t\t\t\t}\n\n\t\t\t\t\treturn v;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (s.cleanup_callback) {\n\t\t\t\tt.onBeforeSetContent.add(function(ed, o) {\n\t\t\t\t\to.content = t.execCallback('cleanup_callback', 'insert_to_editor', o.content, o);\n\t\t\t\t});\n\n\t\t\t\tt.onPreProcess.add(function(ed, o) {\n\t\t\t\t\tif (o.set)\n\t\t\t\t\t\tt.execCallback('cleanup_callback', 'insert_to_editor_dom', o.node, o);\n\n\t\t\t\t\tif (o.get)\n\t\t\t\t\t\tt.execCallback('cleanup_callback', 'get_from_editor_dom', o.node, o);\n\t\t\t\t});\n\n\t\t\t\tt.onPostProcess.add(function(ed, o) {\n\t\t\t\t\tif (o.set)\n\t\t\t\t\t\to.content = t.execCallback('cleanup_callback', 'insert_to_editor', o.content, o);\n\n\t\t\t\t\tif (o.get)\n\t\t\t\t\t\to.content = t.execCallback('cleanup_callback', 'get_from_editor', o.content, o);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.save_callback) {\n\t\t\t\tt.onGetContent.add(function(ed, o) {\n\t\t\t\t\tif (o.save)\n\t\t\t\t\t\to.content = t.execCallback('save_callback', t.id, o.content, t.getBody());\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.handle_event_callback) {\n\t\t\t\tt.onEvent.add(function(ed, e, o) {\n\t\t\t\t\tif (t.execCallback('handle_event_callback', e, ed, o) === false)\n\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Add visual aids when new contents is added\n\t\t\tt.onSetContent.add(function() {\n\t\t\t\tt.addVisual(t.getBody());\n\t\t\t});\n\n\t\t\t// Remove empty contents\n\t\t\tif (s.padd_empty_editor) {\n\t\t\t\tt.onPostProcess.add(function(ed, o) {\n\t\t\t\t\to.content = o.content.replace(/^(<p[^>]*>(&nbsp;|&#160;|\\s|\\u00a0|)<\\/p>[\\r\\n]*|<br \\/>[\\r\\n]*)$/, '');\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (isGecko) {\n\t\t\t\t// Fix gecko link bug, when a link is placed at the end of block elements there is\n\t\t\t\t// no way to move the caret behind the link. This fix adds a bogus br element after the link\n\t\t\t\tfunction fixLinks(ed, o) {\n\t\t\t\t\teach(ed.dom.select('a'), function(n) {\n\t\t\t\t\t\tvar pn = n.parentNode;\n\n\t\t\t\t\t\tif (ed.dom.isBlock(pn) && pn.lastChild === n)\n\t\t\t\t\t\t\ted.dom.add(pn, 'br', {'data-mce-bogus' : 1});\n\t\t\t\t\t});\n\t\t\t\t};\n\n\t\t\t\tt.onExecCommand.add(function(ed, cmd) {\n\t\t\t\t\tif (cmd === 'CreateLink')\n\t\t\t\t\t\tfixLinks(ed);\n\t\t\t\t});\n\n\t\t\t\tt.onSetContent.add(t.selection.onSetContent.add(fixLinks));\n\t\t\t}\n\n\t\t\tt.load({initial : true, format : 'html'});\n\t\t\tt.startContent = t.getContent({format : 'raw'});\n\t\t\tt.undoManager.add();\n\t\t\tt.initialized = true;\n\n\t\t\tt.onInit.dispatch(t);\n\t\t\tt.execCallback('setupcontent_callback', t.id, t.getBody(), t.getDoc());\n\t\t\tt.execCallback('init_instance_callback', t);\n\t\t\tt.focus(true);\n\t\t\tt.nodeChanged({initial : 1});\n\n\t\t\t// Load specified content CSS last\n\t\t\teach(t.contentCSS, function(u) {\n\t\t\t\tt.dom.loadCSS(u);\n\t\t\t});\n\n\t\t\t// Handle auto focus\n\t\t\tif (s.auto_focus) {\n\t\t\t\tsetTimeout(function () {\n\t\t\t\t\tvar ed = tinymce.get(s.auto_focus);\n\n\t\t\t\t\ted.selection.select(ed.getBody(), 1);\n\t\t\t\t\ted.selection.collapse(1);\n\t\t\t\t\ted.getBody().focus();\n\t\t\t\t\ted.getWin().focus();\n\t\t\t\t}, 100);\n\t\t\t}\n\n\t\t\te = null;\n\t\t},\n\n\n\t\tfocus : function(sf) {\n\t\t\tvar oed, t = this, selection = t.selection, ce = t.settings.content_editable, ieRng, controlElm, doc = t.getDoc();\n\n\t\t\tif (!sf) {\n\t\t\t\t// Get selected control element\n\t\t\t\tieRng = selection.getRng();\n\t\t\t\tif (ieRng.item) {\n\t\t\t\t\tcontrolElm = ieRng.item(0);\n\t\t\t\t}\n\n\t\t\t\tt._refreshContentEditable();\n\t\t\t\tselection.normalize();\n\n\t\t\t\t// Is not content editable\n\t\t\t\tif (!ce)\n\t\t\t\t\tt.getWin().focus();\n\n\t\t\t\t// Focus the body as well since it's contentEditable\n\t\t\t\tif (tinymce.isGecko) {\n\t\t\t\t\tt.getBody().focus();\n\t\t\t\t}\n\n\t\t\t\t// Restore selected control element\n\t\t\t\t// This is needed when for example an image is selected within a\n\t\t\t\t// layer a call to focus will then remove the control selection\n\t\t\t\tif (controlElm && controlElm.ownerDocument == doc) {\n\t\t\t\t\tieRng = doc.body.createControlRange();\n\t\t\t\t\tieRng.addElement(controlElm);\n\t\t\t\t\tieRng.select();\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t\tif (tinymce.activeEditor != t) {\n\t\t\t\tif ((oed = tinymce.activeEditor) != null)\n\t\t\t\t\toed.onDeactivate.dispatch(oed, t);\n\n\t\t\t\tt.onActivate.dispatch(t, oed);\n\t\t\t}\n\n\t\t\ttinymce._setActive(t);\n\t\t},\n\n\t\texecCallback : function(n) {\n\t\t\tvar t = this, f = t.settings[n], s;\n\n\t\t\tif (!f)\n\t\t\t\treturn;\n\n\t\t\t// Look through lookup\n\t\t\tif (t.callbackLookup && (s = t.callbackLookup[n])) {\n\t\t\t\tf = s.func;\n\t\t\t\ts = s.scope;\n\t\t\t}\n\n\t\t\tif (is(f, 'string')) {\n\t\t\t\ts = f.replace(/\\.\\w+$/, '');\n\t\t\t\ts = s ? tinymce.resolve(s) : 0;\n\t\t\t\tf = tinymce.resolve(f);\n\t\t\t\tt.callbackLookup = t.callbackLookup || {};\n\t\t\t\tt.callbackLookup[n] = {func : f, scope : s};\n\t\t\t}\n\n\t\t\treturn f.apply(s || t, Array.prototype.slice.call(arguments, 1));\n\t\t},\n\n\t\ttranslate : function(s) {\n\t\t\tvar c = this.settings.language || 'en', i18n = tinymce.i18n;\n\n\t\t\tif (!s)\n\t\t\t\treturn '';\n\n\t\t\treturn i18n[c + '.' + s] || s.replace(/{\\#([^}]+)\\}/g, function(a, b) {\n\t\t\t\treturn i18n[c + '.' + b] || '{#' + b + '}';\n\t\t\t});\n\t\t},\n\n\t\tgetLang : function(n, dv) {\n\t\t\treturn tinymce.i18n[(this.settings.language || 'en') + '.' + n] || (is(dv) ? dv : '{#' + n + '}');\n\t\t},\n\n\t\tgetParam : function(n, dv, ty) {\n\t\t\tvar tr = tinymce.trim, v = is(this.settings[n]) ? this.settings[n] : dv, o;\n\n\t\t\tif (ty === 'hash') {\n\t\t\t\to = {};\n\n\t\t\t\tif (is(v, 'string')) {\n\t\t\t\t\teach(v.indexOf('=') > 0 ? v.split(/[;,](?![^=;,]*(?:[;,]|$))/) : v.split(','), function(v) {\n\t\t\t\t\t\tv = v.split('=');\n\n\t\t\t\t\t\tif (v.length > 1)\n\t\t\t\t\t\t\to[tr(v[0])] = tr(v[1]);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\to[tr(v[0])] = tr(v);\n\t\t\t\t\t});\n\t\t\t\t} else\n\t\t\t\t\to = v;\n\n\t\t\t\treturn o;\n\t\t\t}\n\n\t\t\treturn v;\n\t\t},\n\n\t\tnodeChanged : function(o) {\n\t\t\tvar t = this, s = t.selection, n = s.getStart() || t.getBody();\n\n\t\t\t// Fix for bug #1896577 it seems that this can not be fired while the editor is loading\n\t\t\tif (t.initialized) {\n\t\t\t\to = o || {};\n\t\t\t\tn = isIE && n.ownerDocument != t.getDoc() ? t.getBody() : n; // Fix for IE initial state\n\n\t\t\t\t// Get parents and add them to object\n\t\t\t\to.parents = [];\n\t\t\t\tt.dom.getParent(n, function(node) {\n\t\t\t\t\tif (node.nodeName == 'BODY')\n\t\t\t\t\t\treturn true;\n\n\t\t\t\t\to.parents.push(node);\n\t\t\t\t});\n\n\t\t\t\tt.onNodeChange.dispatch(\n\t\t\t\t\tt,\n\t\t\t\t\to ? o.controlManager || t.controlManager : t.controlManager,\n\t\t\t\t\tn,\n\t\t\t\t\ts.isCollapsed(),\n\t\t\t\t\to\n\t\t\t\t);\n\t\t\t}\n\t\t},\n\n\t\taddButton : function(n, s) {\n\t\t\tvar t = this;\n\n\t\t\tt.buttons = t.buttons || {};\n\t\t\tt.buttons[n] = s;\n\t\t},\n\n\t\taddCommand : function(name, callback, scope) {\n\t\t\tthis.execCommands[name] = {func : callback, scope : scope || this};\n\t\t},\n\n\t\taddQueryStateHandler : function(name, callback, scope) {\n\t\t\tthis.queryStateCommands[name] = {func : callback, scope : scope || this};\n\t\t},\n\n\t\taddQueryValueHandler : function(name, callback, scope) {\n\t\t\tthis.queryValueCommands[name] = {func : callback, scope : scope || this};\n\t\t},\n\n\t\taddShortcut : function(pa, desc, cmd_func, sc) {\n\t\t\tvar t = this, c;\n\n\t\t\tif (!t.settings.custom_shortcuts)\n\t\t\t\treturn false;\n\n\t\t\tt.shortcuts = t.shortcuts || {};\n\n\t\t\tif (is(cmd_func, 'string')) {\n\t\t\t\tc = cmd_func;\n\n\t\t\t\tcmd_func = function() {\n\t\t\t\t\tt.execCommand(c, false, null);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (is(cmd_func, 'object')) {\n\t\t\t\tc = cmd_func;\n\n\t\t\t\tcmd_func = function() {\n\t\t\t\t\tt.execCommand(c[0], c[1], c[2]);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\teach(explode(pa), function(pa) {\n\t\t\t\tvar o = {\n\t\t\t\t\tfunc : cmd_func,\n\t\t\t\t\tscope : sc || this,\n\t\t\t\t\tdesc : desc,\n\t\t\t\t\talt : false,\n\t\t\t\t\tctrl : false,\n\t\t\t\t\tshift : false\n\t\t\t\t};\n\n\t\t\t\teach(explode(pa, '+'), function(v) {\n\t\t\t\t\tswitch (v) {\n\t\t\t\t\t\tcase 'alt':\n\t\t\t\t\t\tcase 'ctrl':\n\t\t\t\t\t\tcase 'shift':\n\t\t\t\t\t\t\to[v] = true;\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tdefault:\n\t\t\t\t\t\t\to.charCode = v.charCodeAt(0);\n\t\t\t\t\t\t\to.keyCode = v.toUpperCase().charCodeAt(0);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tt.shortcuts[(o.ctrl ? 'ctrl' : '') + ',' + (o.alt ? 'alt' : '') + ',' + (o.shift ? 'shift' : '') + ',' + o.keyCode] = o;\n\t\t\t});\n\n\t\t\treturn true;\n\t\t},\n\n\t\texecCommand : function(cmd, ui, val, a) {\n\t\t\tvar t = this, s = 0, o, st;\n\n\t\t\tif (!/^(mceAddUndoLevel|mceEndUndoLevel|mceBeginUndoLevel|mceRepaint|SelectAll)$/.test(cmd) && (!a || !a.skip_focus))\n\t\t\t\tt.focus();\n\n\t\t\to = {};\n\t\t\tt.onBeforeExecCommand.dispatch(t, cmd, ui, val, o);\n\t\t\tif (o.terminate)\n\t\t\t\treturn false;\n\n\t\t\t// Command callback\n\t\t\tif (t.execCallback('execcommand_callback', t.id, t.selection.getNode(), cmd, ui, val)) {\n\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Registred commands\n\t\t\tif (o = t.execCommands[cmd]) {\n\t\t\t\tst = o.func.call(o.scope, ui, val);\n\n\t\t\t\t// Fall through on true\n\t\t\t\tif (st !== true) {\n\t\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\t\treturn st;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Plugin commands\n\t\t\teach(t.plugins, function(p) {\n\t\t\t\tif (p.execCommand && p.execCommand(cmd, ui, val)) {\n\t\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\t\ts = 1;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tif (s)\n\t\t\t\treturn true;\n\n\t\t\t// Theme commands\n\t\t\tif (t.theme && t.theme.execCommand && t.theme.execCommand(cmd, ui, val)) {\n\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Editor commands\n\t\t\tif (t.editorCommands.execCommand(cmd, ui, val)) {\n\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Browser commands\n\t\t\tt.getDoc().execCommand(cmd, ui, val);\n\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t},\n\n\t\tqueryCommandState : function(cmd) {\n\t\t\tvar t = this, o, s;\n\n\t\t\t// Is hidden then return undefined\n\t\t\tif (t._isHidden())\n\t\t\t\treturn;\n\n\t\t\t// Registred commands\n\t\t\tif (o = t.queryStateCommands[cmd]) {\n\t\t\t\ts = o.func.call(o.scope);\n\n\t\t\t\t// Fall though on true\n\t\t\t\tif (s !== true)\n\t\t\t\t\treturn s;\n\t\t\t}\n\n\t\t\t// Registred commands\n\t\t\to = t.editorCommands.queryCommandState(cmd);\n\t\t\tif (o !== -1)\n\t\t\t\treturn o;\n\n\t\t\t// Browser commands\n\t\t\ttry {\n\t\t\t\treturn this.getDoc().queryCommandState(cmd);\n\t\t\t} catch (ex) {\n\t\t\t\t// Fails sometimes see bug: 1896577\n\t\t\t}\n\t\t},\n\n\t\tqueryCommandValue : function(c) {\n\t\t\tvar t = this, o, s;\n\n\t\t\t// Is hidden then return undefined\n\t\t\tif (t._isHidden())\n\t\t\t\treturn;\n\n\t\t\t// Registred commands\n\t\t\tif (o = t.queryValueCommands[c]) {\n\t\t\t\ts = o.func.call(o.scope);\n\n\t\t\t\t// Fall though on true\n\t\t\t\tif (s !== true)\n\t\t\t\t\treturn s;\n\t\t\t}\n\n\t\t\t// Registred commands\n\t\t\to = t.editorCommands.queryCommandValue(c);\n\t\t\tif (is(o))\n\t\t\t\treturn o;\n\n\t\t\t// Browser commands\n\t\t\ttry {\n\t\t\t\treturn this.getDoc().queryCommandValue(c);\n\t\t\t} catch (ex) {\n\t\t\t\t// Fails sometimes see bug: 1896577\n\t\t\t}\n\t\t},\n\n\t\tshow : function() {\n\t\t\tvar t = this;\n\n\t\t\tDOM.show(t.getContainer());\n\t\t\tDOM.hide(t.id);\n\t\t\tt.load();\n\t\t},\n\n\t\thide : function() {\n\t\t\tvar t = this, d = t.getDoc();\n\n\t\t\t// Fixed bug where IE has a blinking cursor left from the editor\n\t\t\tif (isIE && d)\n\t\t\t\td.execCommand('SelectAll');\n\n\t\t\t// We must save before we hide so Safari doesn't crash\n\t\t\tt.save();\n\t\t\tDOM.hide(t.getContainer());\n\t\t\tDOM.setStyle(t.id, 'display', t.orgDisplay);\n\t\t},\n\n\t\tisHidden : function() {\n\t\t\treturn !DOM.isHidden(this.id);\n\t\t},\n\n\t\tsetProgressState : function(b, ti, o) {\n\t\t\tthis.onSetProgressState.dispatch(this, b, ti, o);\n\n\t\t\treturn b;\n\t\t},\n\n\t\tload : function(o) {\n\t\t\tvar t = this, e = t.getElement(), h;\n\n\t\t\tif (e) {\n\t\t\t\to = o || {};\n\t\t\t\to.load = true;\n\n\t\t\t\t// Double encode existing entities in the value\n\t\t\t\th = t.setContent(is(e.value) ? e.value : e.innerHTML, o);\n\t\t\t\to.element = e;\n\n\t\t\t\tif (!o.no_events)\n\t\t\t\t\tt.onLoadContent.dispatch(t, o);\n\n\t\t\t\to.element = e = null;\n\n\t\t\t\treturn h;\n\t\t\t}\n\t\t},\n\n\t\tsave : function(o) {\n\t\t\tvar t = this, e = t.getElement(), h, f;\n\n\t\t\tif (!e || !t.initialized)\n\t\t\t\treturn;\n\n\t\t\to = o || {};\n\t\t\to.save = true;\n\n\t\t\t// Add undo level will trigger onchange event\n\t\t\tif (!o.no_events) {\n\t\t\t\tt.undoManager.typing = false;\n\t\t\t\tt.undoManager.add();\n\t\t\t}\n\n\t\t\to.element = e;\n\t\t\th = o.content = t.getContent(o);\n\n\t\t\tif (!o.no_events)\n\t\t\t\tt.onSaveContent.dispatch(t, o);\n\n\t\t\th = o.content;\n\n\t\t\tif (!/TEXTAREA|INPUT/i.test(e.nodeName)) {\n\t\t\t\te.innerHTML = h;\n\n\t\t\t\t// Update hidden form element\n\t\t\t\tif (f = DOM.getParent(t.id, 'form')) {\n\t\t\t\t\teach(f.elements, function(e) {\n\t\t\t\t\t\tif (e.name == t.id) {\n\t\t\t\t\t\t\te.value = h;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t} else\n\t\t\t\te.value = h;\n\n\t\t\to.element = e = null;\n\n\t\t\treturn h;\n\t\t},\n\n\t\tsetContent : function(content, args) {\n\t\t\tvar self = this, rootNode, body = self.getBody(), forcedRootBlockName;\n\n\t\t\t// Setup args object\n\t\t\targs = args || {};\n\t\t\targs.format = args.format || 'html';\n\t\t\targs.set = true;\n\t\t\targs.content = content;\n\n\t\t\t// Do preprocessing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onBeforeSetContent.dispatch(self, args);\n\n\t\t\tcontent = args.content;\n\n\t\t\t// Padd empty content in Gecko and Safari. Commands will otherwise fail on the content\n\t\t\t// It will also be impossible to place the caret in the editor unless there is a BR element present\n\t\t\tif (!tinymce.isIE && (content.length === 0 || /^\\s+$/.test(content))) {\n\t\t\t\tforcedRootBlockName = self.settings.forced_root_block;\n\t\t\t\tif (forcedRootBlockName)\n\t\t\t\t\tcontent = '<' + forcedRootBlockName + '><br data-mce-bogus=\"1\"></' + forcedRootBlockName + '>';\n\t\t\t\telse\n\t\t\t\t\tcontent = '<br data-mce-bogus=\"1\">';\n\n\t\t\t\tbody.innerHTML = content;\n\t\t\t\tself.selection.select(body, true);\n\t\t\t\tself.selection.collapse(true);\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Parse and serialize the html\n\t\t\tif (args.format !== 'raw') {\n\t\t\t\tcontent = new tinymce.html.Serializer({}, self.schema).serialize(\n\t\t\t\t\tself.parser.parse(content)\n\t\t\t\t);\n\t\t\t}\n\n\t\t\t// Set the new cleaned contents to the editor\n\t\t\targs.content = tinymce.trim(content);\n\t\t\tself.dom.setHTML(body, args.content);\n\n\t\t\t// Do post processing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onSetContent.dispatch(self, args);\n\n\t\t\tself.selection.normalize();\n\n\t\t\treturn args.content;\n\t\t},\n\n\t\tgetContent : function(args) {\n\t\t\tvar self = this, content;\n\n\t\t\t// Setup args object\n\t\t\targs = args || {};\n\t\t\targs.format = args.format || 'html';\n\t\t\targs.get = true;\n\n\t\t\t// Do preprocessing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onBeforeGetContent.dispatch(self, args);\n\n\t\t\t// Get raw contents or by default the cleaned contents\n\t\t\tif (args.format == 'raw')\n\t\t\t\tcontent = self.getBody().innerHTML;\n\t\t\telse\n\t\t\t\tcontent = self.serializer.serialize(self.getBody(), args);\n\n\t\t\targs.content = tinymce.trim(content);\n\n\t\t\t// Do post processing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onGetContent.dispatch(self, args);\n\n\t\t\treturn args.content;\n\t\t},\n\n\t\tisDirty : function() {\n\t\t\tvar self = this;\n\n\t\t\treturn tinymce.trim(self.startContent) != tinymce.trim(self.getContent({format : 'raw', no_events : 1})) && !self.isNotDirty;\n\t\t},\n\n\t\tgetContainer : function() {\n\t\t\tvar t = this;\n\n\t\t\tif (!t.container)\n\t\t\t\tt.container = DOM.get(t.editorContainer || t.id + '_parent');\n\n\t\t\treturn t.container;\n\t\t},\n\n\t\tgetContentAreaContainer : function() {\n\t\t\treturn this.contentAreaContainer;\n\t\t},\n\n\t\tgetElement : function() {\n\t\t\treturn DOM.get(this.settings.content_element || this.id);\n\t\t},\n\n\t\tgetWin : function() {\n\t\t\tvar t = this, e;\n\n\t\t\tif (!t.contentWindow) {\n\t\t\t\te = DOM.get(t.id + \"_ifr\");\n\n\t\t\t\tif (e)\n\t\t\t\t\tt.contentWindow = e.contentWindow;\n\t\t\t}\n\n\t\t\treturn t.contentWindow;\n\t\t},\n\n\t\tgetDoc : function() {\n\t\t\tvar t = this, w;\n\n\t\t\tif (!t.contentDocument) {\n\t\t\t\tw = t.getWin();\n\n\t\t\t\tif (w)\n\t\t\t\t\tt.contentDocument = w.document;\n\t\t\t}\n\n\t\t\treturn t.contentDocument;\n\t\t},\n\n\t\tgetBody : function() {\n\t\t\treturn this.bodyElement || this.getDoc().body;\n\t\t},\n\n\t\tconvertURL : function(u, n, e) {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\t// Use callback instead\n\t\t\tif (s.urlconverter_callback)\n\t\t\t\treturn t.execCallback('urlconverter_callback', u, e, true, n);\n\n\t\t\t// Don't convert link href since thats the CSS files that gets loaded into the editor also skip local file URLs\n\t\t\tif (!s.convert_urls || (e && e.nodeName == 'LINK') || u.indexOf('file:') === 0)\n\t\t\t\treturn u;\n\n\t\t\t// Convert to relative\n\t\t\tif (s.relative_urls)\n\t\t\t\treturn t.documentBaseURI.toRelative(u);\n\n\t\t\t// Convert to absolute\n\t\t\tu = t.documentBaseURI.toAbsolute(u, s.remove_script_host);\n\n\t\t\treturn u;\n\t\t},\n\n\t\taddVisual : function(e) {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\te = e || t.getBody();\n\n\t\t\tif (!is(t.hasVisual))\n\t\t\t\tt.hasVisual = s.visual;\n\n\t\t\teach(t.dom.select('table,a', e), function(e) {\n\t\t\t\tvar v;\n\n\t\t\t\tswitch (e.nodeName) {\n\t\t\t\t\tcase 'TABLE':\n\t\t\t\t\t\tv = t.dom.getAttrib(e, 'border');\n\n\t\t\t\t\t\tif (!v || v == '0') {\n\t\t\t\t\t\t\tif (t.hasVisual)\n\t\t\t\t\t\t\t\tt.dom.addClass(e, s.visual_table_class);\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tt.dom.removeClass(e, s.visual_table_class);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tcase 'A':\n\t\t\t\t\t\tv = t.dom.getAttrib(e, 'name');\n\n\t\t\t\t\t\tif (v) {\n\t\t\t\t\t\t\tif (t.hasVisual)\n\t\t\t\t\t\t\t\tt.dom.addClass(e, 'mceItemAnchor');\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tt.dom.removeClass(e, 'mceItemAnchor');\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.onVisualAid.dispatch(t, e, t.hasVisual);\n\t\t},\n\n\t\tremove : function() {\n\t\t\tvar t = this, e = t.getContainer();\n\n\t\t\tt.removed = 1; // Cancels post remove event execution\n\t\t\tt.hide();\n\n\t\t\tt.execCallback('remove_instance_callback', t);\n\t\t\tt.onRemove.dispatch(t);\n\n\t\t\t// Clear all execCommand listeners this is required to avoid errors if the editor was removed inside another command\n\t\t\tt.onExecCommand.listeners = [];\n\n\t\t\ttinymce.remove(t);\n\t\t\tDOM.remove(e);\n\t\t},\n\n\t\tdestroy : function(s) {\n\t\t\tvar t = this;\n\n\t\t\t// One time is enough\n\t\t\tif (t.destroyed)\n\t\t\t\treturn;\n\n\t\t\tif (!s) {\n\t\t\t\ttinymce.removeUnload(t.destroy);\n\t\t\t\ttinyMCE.onBeforeUnload.remove(t._beforeUnload);\n\n\t\t\t\t// Manual destroy\n\t\t\t\tif (t.theme && t.theme.destroy)\n\t\t\t\t\tt.theme.destroy();\n\n\t\t\t\t// Destroy controls, selection and dom\n\t\t\t\tt.controlManager.destroy();\n\t\t\t\tt.selection.destroy();\n\t\t\t\tt.dom.destroy();\n\n\t\t\t\t// Remove all events\n\n\t\t\t\t// Don't clear the window or document if content editable\n\t\t\t\t// is enabled since other instances might still be present\n\t\t\t\tif (!t.settings.content_editable) {\n\t\t\t\t\tEvent.clear(t.getWin());\n\t\t\t\t\tEvent.clear(t.getDoc());\n\t\t\t\t}\n\n\t\t\t\tEvent.clear(t.getBody());\n\t\t\t\tEvent.clear(t.formElement);\n\t\t\t}\n\n\t\t\tif (t.formElement) {\n\t\t\t\tt.formElement.submit = t.formElement._mceOldSubmit;\n\t\t\t\tt.formElement._mceOldSubmit = null;\n\t\t\t}\n\n\t\t\tt.contentAreaContainer = t.formElement = t.container = t.settings.content_element = t.bodyElement = t.contentDocument = t.contentWindow = null;\n\n\t\t\tif (t.selection)\n\t\t\t\tt.selection = t.selection.win = t.selection.dom = t.selection.dom.doc = null;\n\n\t\t\tt.destroyed = 1;\n\t\t},\n\n\t\t// Internal functions\n\n\t\t_addEvents : function() {\n\t\t\t// 'focus', 'blur', 'dblclick', 'beforedeactivate', submit, reset\n\t\t\tvar t = this, i, s = t.settings, dom = t.dom, lo = {\n\t\t\t\tmouseup : 'onMouseUp',\n\t\t\t\tmousedown : 'onMouseDown',\n\t\t\t\tclick : 'onClick',\n\t\t\t\tkeyup : 'onKeyUp',\n\t\t\t\tkeydown : 'onKeyDown',\n\t\t\t\tkeypress : 'onKeyPress',\n\t\t\t\tsubmit : 'onSubmit',\n\t\t\t\treset : 'onReset',\n\t\t\t\tcontextmenu : 'onContextMenu',\n\t\t\t\tdblclick : 'onDblClick',\n\t\t\t\tpaste : 'onPaste' // Doesn't work in all browsers yet\n\t\t\t};\n\n\t\t\tfunction eventHandler(e, o) {\n\t\t\t\tvar ty = e.type;\n\n\t\t\t\t// Don't fire events when it's removed\n\t\t\t\tif (t.removed)\n\t\t\t\t\treturn;\n\n\t\t\t\t// Generic event handler\n\t\t\t\tif (t.onEvent.dispatch(t, e, o) !== false) {\n\t\t\t\t\t// Specific event handler\n\t\t\t\t\tt[lo[e.fakeType || e.type]].dispatch(t, e, o);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Add DOM events\n\t\t\teach(lo, function(v, k) {\n\t\t\t\tswitch (k) {\n\t\t\t\t\tcase 'contextmenu':\n\t\t\t\t\t\tdom.bind(t.getDoc(), k, eventHandler);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'paste':\n\t\t\t\t\t\tdom.bind(t.getBody(), k, function(e) {\n\t\t\t\t\t\t\teventHandler(e);\n\t\t\t\t\t\t});\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'submit':\n\t\t\t\t\tcase 'reset':\n\t\t\t\t\t\tdom.bind(t.getElement().form || DOM.getParent(t.id, 'form'), k, eventHandler);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tdefault:\n\t\t\t\t\t\tdom.bind(s.content_editable ? t.getBody() : t.getDoc(), k, eventHandler);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tdom.bind(s.content_editable ? t.getBody() : (isGecko ? t.getDoc() : t.getWin()), 'focus', function(e) {\n\t\t\t\tt.focus(true);\n\t\t\t});\n\n\n\t\t\t// Fixes bug where a specified document_base_uri could result in broken images\n\t\t\t// This will also fix drag drop of images in Gecko\n\t\t\tif (tinymce.isGecko) {\n\t\t\t\tdom.bind(t.getDoc(), 'DOMNodeInserted', function(e) {\n\t\t\t\t\tvar v;\n\n\t\t\t\t\te = e.target;\n\n\t\t\t\t\tif (e.nodeType === 1 && e.nodeName === 'IMG' && (v = e.getAttribute('data-mce-src')))\n\t\t\t\t\t\te.src = t.documentBaseURI.toAbsolute(v);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Set various midas options in Gecko\n\t\t\tif (isGecko) {\n\t\t\t\tfunction setOpts() {\n\t\t\t\t\tvar t = this, d = t.getDoc(), s = t.settings;\n\n\t\t\t\t\tif (isGecko && !s.readonly) {\n\t\t\t\t\t\tt._refreshContentEditable();\n\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t// Try new Gecko method\n\t\t\t\t\t\t\td.execCommand(\"styleWithCSS\", 0, false);\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\t// Use old method\n\t\t\t\t\t\t\tif (!t._isHidden())\n\t\t\t\t\t\t\t\ttry {d.execCommand(\"useCSS\", 0, true);} catch (ex) {}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (!s.table_inline_editing)\n\t\t\t\t\t\t\ttry {d.execCommand('enableInlineTableEditing', false, false);} catch (ex) {}\n\n\t\t\t\t\t\tif (!s.object_resizing)\n\t\t\t\t\t\t\ttry {d.execCommand('enableObjectResizing', false, false);} catch (ex) {}\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\tt.onBeforeExecCommand.add(setOpts);\n\t\t\t\tt.onMouseDown.add(setOpts);\n\t\t\t}\n\n\t\t\t// Add node change handlers\n\t\t\tt.onMouseUp.add(t.nodeChanged);\n\t\t\t//t.onClick.add(t.nodeChanged);\n\t\t\tt.onKeyUp.add(function(ed, e) {\n\t\t\t\tvar c = e.keyCode;\n\n\t\t\t\tif ((c >= 33 && c <= 36) || (c >= 37 && c <= 40) || c == 13 || c == 45 || c == 46 || c == 8 || (tinymce.isMac && (c == 91 || c == 93)) || e.ctrlKey)\n\t\t\t\t\tt.nodeChanged();\n\t\t\t});\n\n\n\t\t\t// Add block quote deletion handler\n\t\t\tt.onKeyDown.add(function(ed, e) {\n\t\t\t\t// Was the BACKSPACE key pressed?\n\t\t\t\tif (e.keyCode != 8)\n\t\t\t\t\treturn;\n\n\t\t\t\tvar n = ed.selection.getRng().startContainer;\n\t\t\t\tvar offset = ed.selection.getRng().startOffset;\n\n\t\t\t\twhile (n && n.nodeType && n.nodeType != 1 && n.parentNode)\n\t\t\t\t\tn = n.parentNode;\n\n\t\t\t\t// Is the cursor at the beginning of a blockquote?\n\t\t\t\tif (n && n.parentNode && n.parentNode.tagName === 'BLOCKQUOTE' && n.parentNode.firstChild == n && offset == 0) {\n\t\t\t\t\t// Remove the blockquote\n\t\t\t\t\ted.formatter.toggle('blockquote', null, n.parentNode);\n\n\t\t\t\t\t// Move the caret to the beginning of n\n\t\t\t\t\tvar rng = ed.selection.getRng();\n\t\t\t\t\trng.setStart(n, 0);\n\t\t\t\t\trng.setEnd(n, 0);\n\t\t\t\t\ted.selection.setRng(rng);\n\t\t\t\t\ted.selection.collapse(false);\n\t\t\t\t}\n\t\t\t});\n\n\n\n\t\t\t// Add reset handler\n\t\t\tt.onReset.add(function() {\n\t\t\t\tt.setContent(t.startContent, {format : 'raw'});\n\t\t\t});\n\n\t\t\t// Add shortcuts\n\t\t\tif (s.custom_shortcuts) {\n\t\t\t\tif (s.custom_undo_redo_keyboard_shortcuts) {\n\t\t\t\t\tt.addShortcut('ctrl+z', t.getLang('undo_desc'), 'Undo');\n\t\t\t\t\tt.addShortcut('ctrl+y', t.getLang('redo_desc'), 'Redo');\n\t\t\t\t}\n\n\t\t\t\t// Add default shortcuts for gecko\n\t\t\t\tt.addShortcut('ctrl+b', t.getLang('bold_desc'), 'Bold');\n\t\t\t\tt.addShortcut('ctrl+i', t.getLang('italic_desc'), 'Italic');\n\t\t\t\tt.addShortcut('ctrl+u', t.getLang('underline_desc'), 'Underline');\n\n\t\t\t\t// BlockFormat shortcuts keys\n\t\t\t\tfor (i=1; i<=6; i++)\n\t\t\t\t\tt.addShortcut('ctrl+' + i, '', ['FormatBlock', false, 'h' + i]);\n\n\t\t\t\tt.addShortcut('ctrl+7', '', ['FormatBlock', false, 'p']);\n\t\t\t\tt.addShortcut('ctrl+8', '', ['FormatBlock', false, 'div']);\n\t\t\t\tt.addShortcut('ctrl+9', '', ['FormatBlock', false, 'address']);\n\n\t\t\t\tfunction find(e) {\n\t\t\t\t\tvar v = null;\n\n\t\t\t\t\tif (!e.altKey && !e.ctrlKey && !e.metaKey)\n\t\t\t\t\t\treturn v;\n\n\t\t\t\t\teach(t.shortcuts, function(o) {\n\t\t\t\t\t\tif (tinymce.isMac && o.ctrl != e.metaKey)\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\telse if (!tinymce.isMac && o.ctrl != e.ctrlKey)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tif (o.alt != e.altKey)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tif (o.shift != e.shiftKey)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tif (e.keyCode == o.keyCode || (e.charCode && e.charCode == o.charCode)) {\n\t\t\t\t\t\t\tv = o;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\n\t\t\t\t\treturn v;\n\t\t\t\t};\n\n\t\t\t\tt.onKeyUp.add(function(ed, e) {\n\t\t\t\t\tvar o = find(e);\n\n\t\t\t\t\tif (o)\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t});\n\n\t\t\t\tt.onKeyPress.add(function(ed, e) {\n\t\t\t\t\tvar o = find(e);\n\n\t\t\t\t\tif (o)\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t});\n\n\t\t\t\tt.onKeyDown.add(function(ed, e) {\n\t\t\t\t\tvar o = find(e);\n\n\t\t\t\t\tif (o) {\n\t\t\t\t\t\to.func.call(o.scope);\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (tinymce.isIE) {\n\t\t\t\t// Fix so resize will only update the width and height attributes not the styles of an image\n\t\t\t\t// It will also block mceItemNoResize items\n\t\t\t\tdom.bind(t.getDoc(), 'controlselect', function(e) {\n\t\t\t\t\tvar re = t.resizeInfo, cb;\n\n\t\t\t\t\te = e.target;\n\n\t\t\t\t\t// Don't do this action for non image elements\n\t\t\t\t\tif (e.nodeName !== 'IMG')\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tif (re)\n\t\t\t\t\t\tdom.unbind(re.node, re.ev, re.cb);\n\n\t\t\t\t\tif (!dom.hasClass(e, 'mceItemNoResize')) {\n\t\t\t\t\t\tev = 'resizeend';\n\t\t\t\t\t\tcb = dom.bind(e, ev, function(e) {\n\t\t\t\t\t\t\tvar v;\n\n\t\t\t\t\t\t\te = e.target;\n\n\t\t\t\t\t\t\tif (v = dom.getStyle(e, 'width')) {\n\t\t\t\t\t\t\t\tdom.setAttrib(e, 'width', v.replace(/[^0-9%]+/g, ''));\n\t\t\t\t\t\t\t\tdom.setStyle(e, 'width', '');\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (v = dom.getStyle(e, 'height')) {\n\t\t\t\t\t\t\t\tdom.setAttrib(e, 'height', v.replace(/[^0-9%]+/g, ''));\n\t\t\t\t\t\t\t\tdom.setStyle(e, 'height', '');\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t} else {\n\t\t\t\t\t\tev = 'resizestart';\n\t\t\t\t\t\tcb = dom.bind(e, 'resizestart', Event.cancel, Event);\n\t\t\t\t\t}\n\n\t\t\t\t\tre = t.resizeInfo = {\n\t\t\t\t\t\tnode : e,\n\t\t\t\t\t\tev : ev,\n\t\t\t\t\t\tcb : cb\n\t\t\t\t\t};\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (tinymce.isOpera) {\n\t\t\t\tt.onClick.add(function(ed, e) {\n\t\t\t\t\tEvent.prevent(e);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Add custom undo/redo handlers\n\t\t\tif (s.custom_undo_redo) {\n\t\t\t\tfunction addUndo() {\n\t\t\t\t\tt.undoManager.typing = false;\n\t\t\t\t\tt.undoManager.add();\n\t\t\t\t};\n\n\t\t\t\tdom.bind(t.getDoc(), 'focusout', function(e) {\n\t\t\t\t\tif (!t.removed && t.undoManager.typing)\n\t\t\t\t\t\taddUndo();\n\t\t\t\t});\n\n\t\t\t\t// Add undo level when contents is drag/dropped within the editor\n\t\t\t\tt.dom.bind(t.dom.getRoot(), 'dragend', function(e) {\n\t\t\t\t\taddUndo();\n\t\t\t\t});\n\n\t\t\t\tt.onKeyUp.add(function(ed, e) {\n\t\t\t\t\tvar keyCode = e.keyCode;\n\n\t\t\t\t\tif ((keyCode >= 33 && keyCode <= 36) || (keyCode >= 37 && keyCode <= 40) || keyCode == 13 || keyCode == 45 || e.ctrlKey)\n\t\t\t\t\t\taddUndo();\n\t\t\t\t});\n\n\t\t\t\tt.onKeyDown.add(function(ed, e) {\n\t\t\t\t\tvar keyCode = e.keyCode, sel;\n\n\t\t\t\t\tif (keyCode == 8) {\n\t\t\t\t\t\tsel = t.getDoc().selection;\n\n\t\t\t\t\t\t// Fix IE control + backspace browser bug\n\t\t\t\t\t\tif (sel && sel.createRange && sel.createRange().item) {\n\t\t\t\t\t\t\tt.undoManager.beforeChange();\n\t\t\t\t\t\t\ted.dom.remove(sel.createRange().item(0));\n\t\t\t\t\t\t\taddUndo();\n\n\t\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Is caracter positon keys left,right,up,down,home,end,pgdown,pgup,enter\n\t\t\t\t\tif ((keyCode >= 33 && keyCode <= 36) || (keyCode >= 37 && keyCode <= 40) || keyCode == 13 || keyCode == 45) {\n\t\t\t\t\t\t// Add position before enter key is pressed, used by IE since it still uses the default browser behavior\n\t\t\t\t\t\t// Todo: Remove this once we normalize enter behavior on IE\n\t\t\t\t\t\tif (tinymce.isIE && keyCode == 13)\n\t\t\t\t\t\t\tt.undoManager.beforeChange();\n\n\t\t\t\t\t\tif (t.undoManager.typing)\n\t\t\t\t\t\t\taddUndo();\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// If key isn't shift,ctrl,alt,capslock,metakey\n\t\t\t\t\tif ((keyCode < 16 || keyCode > 20) && keyCode != 224 && keyCode != 91 && !t.undoManager.typing) {\n\t\t\t\t\t\tt.undoManager.beforeChange();\n\t\t\t\t\t\tt.undoManager.typing = true;\n\t\t\t\t\t\tt.undoManager.add();\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tt.onMouseDown.add(function() {\n\t\t\t\t\tif (t.undoManager.typing)\n\t\t\t\t\t\taddUndo();\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Bug fix for FireFox keeping styles from end of selection instead of start.\n\t\t\tif (tinymce.isGecko) {\n\t\t\t\tfunction getAttributeApplyFunction() {\n\t\t\t\t\tvar template = t.dom.getAttribs(t.selection.getStart().cloneNode(false));\n\n\t\t\t\t\treturn function() {\n\t\t\t\t\t\tvar target = t.selection.getStart();\n\n\t\t\t\t\t\tif (target !== t.getBody()) {\n\t\t\t\t\t\t\tt.dom.setAttrib(target, \"style\", null);\n\n\t\t\t\t\t\t\teach(template, function(attr) {\n\t\t\t\t\t\t\t\ttarget.setAttributeNode(attr.cloneNode(true));\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\tfunction isSelectionAcrossElements() {\n\t\t\t\t\tvar s = t.selection;\n\n\t\t\t\t\treturn !s.isCollapsed() && s.getStart() != s.getEnd();\n\t\t\t\t}\n\n\t\t\t\tt.onKeyPress.add(function(ed, e) {\n\t\t\t\t\tvar applyAttributes;\n\n\t\t\t\t\tif ((e.keyCode == 8 || e.keyCode == 46) && isSelectionAcrossElements()) {\n\t\t\t\t\t\tapplyAttributes = getAttributeApplyFunction();\n\t\t\t\t\t\tt.getDoc().execCommand('delete', false, null);\n\t\t\t\t\t\tapplyAttributes();\n\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tt.dom.bind(t.getDoc(), 'cut', function(e) {\n\t\t\t\t\tvar applyAttributes;\n\n\t\t\t\t\tif (isSelectionAcrossElements()) {\n\t\t\t\t\t\tapplyAttributes = getAttributeApplyFunction();\n\t\t\t\t\t\tt.onKeyUp.addToTop(Event.cancel, Event);\n\n\t\t\t\t\t\tsetTimeout(function() {\n\t\t\t\t\t\t\tapplyAttributes();\n\t\t\t\t\t\t\tt.onKeyUp.remove(Event.cancel, Event);\n\t\t\t\t\t\t}, 0);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\t_refreshContentEditable : function() {\n\t\t\tvar self = this, body, parent;\n\n\t\t\t// Check if the editor was hidden and the re-initalize contentEditable mode by removing and adding the body again\n\t\t\tif (self._isHidden()) {\n\t\t\t\tbody = self.getBody();\n\t\t\t\tparent = body.parentNode;\n\n\t\t\t\tparent.removeChild(body);\n\t\t\t\tparent.appendChild(body);\n\n\t\t\t\tbody.focus();\n\t\t\t}\n\t\t},\n\n\t\t_isHidden : function() {\n\t\t\tvar s;\n\n\t\t\tif (!isGecko)\n\t\t\t\treturn 0;\n\n\t\t\t// Weird, wheres that cursor selection?\n\t\t\ts = this.selection.getSel();\n\t\t\treturn (!s || !s.rangeCount || s.rangeCount == 0);\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\t// Added for compression purposes\n\tvar each = tinymce.each, undefined, TRUE = true, FALSE = false;\n\n\ttinymce.EditorCommands = function(editor) {\n\t\tvar dom = editor.dom,\n\t\t\tselection = editor.selection,\n\t\t\tcommands = {state: {}, exec : {}, value : {}},\n\t\t\tsettings = editor.settings,\n\t\t\tformatter = editor.formatter,\n\t\t\tbookmark;\n\n\t\tfunction execCommand(command, ui, value) {\n\t\t\tvar func;\n\n\t\t\tcommand = command.toLowerCase();\n\t\t\tif (func = commands.exec[command]) {\n\t\t\t\tfunc(command, ui, value);\n\t\t\t\treturn TRUE;\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\tfunction queryCommandState(command) {\n\t\t\tvar func;\n\n\t\t\tcommand = command.toLowerCase();\n\t\t\tif (func = commands.state[command])\n\t\t\t\treturn func(command);\n\n\t\t\treturn -1;\n\t\t};\n\n\t\tfunction queryCommandValue(command) {\n\t\t\tvar func;\n\n\t\t\tcommand = command.toLowerCase();\n\t\t\tif (func = commands.value[command])\n\t\t\t\treturn func(command);\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\tfunction addCommands(command_list, type) {\n\t\t\ttype = type || 'exec';\n\n\t\t\teach(command_list, function(callback, command) {\n\t\t\t\teach(command.toLowerCase().split(','), function(command) {\n\t\t\t\t\tcommands[type][command] = callback;\n\t\t\t\t});\n\t\t\t});\n\t\t};\n\n\t\t// Expose public methods\n\t\ttinymce.extend(this, {\n\t\t\texecCommand : execCommand,\n\t\t\tqueryCommandState : queryCommandState,\n\t\t\tqueryCommandValue : queryCommandValue,\n\t\t\taddCommands : addCommands\n\t\t});\n\n\t\t// Private methods\n\n\t\tfunction execNativeCommand(command, ui, value) {\n\t\t\tif (ui === undefined)\n\t\t\t\tui = FALSE;\n\n\t\t\tif (value === undefined)\n\t\t\t\tvalue = null;\n\n\t\t\treturn editor.getDoc().execCommand(command, ui, value);\n\t\t};\n\n\t\tfunction isFormatMatch(name) {\n\t\t\treturn formatter.match(name);\n\t\t};\n\n\t\tfunction toggleFormat(name, value) {\n\t\t\tformatter.toggle(name, value ? {value : value} : undefined);\n\t\t};\n\n\t\tfunction storeSelection(type) {\n\t\t\tbookmark = selection.getBookmark(type);\n\t\t};\n\n\t\tfunction restoreSelection() {\n\t\t\tselection.moveToBookmark(bookmark);\n\t\t};\n\n\t\t// Add execCommand overrides\n\t\taddCommands({\n\t\t\t// Ignore these, added for compatibility\n\t\t\t'mceResetDesignMode,mceBeginUndoLevel' : function() {},\n\n\t\t\t// Add undo manager logic\n\t\t\t'mceEndUndoLevel,mceAddUndoLevel' : function() {\n\t\t\t\teditor.undoManager.add();\n\t\t\t},\n\n\t\t\t'Cut,Copy,Paste' : function(command) {\n\t\t\t\tvar doc = editor.getDoc(), failed;\n\n\t\t\t\t// Try executing the native command\n\t\t\t\ttry {\n\t\t\t\t\texecNativeCommand(command);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Command failed\n\t\t\t\t\tfailed = TRUE;\n\t\t\t\t}\n\n\t\t\t\t// Present alert message about clipboard access not being available\n\t\t\t\tif (failed || !doc.queryCommandSupported(command)) {\n\t\t\t\t\tif (tinymce.isGecko) {\n\t\t\t\t\t\teditor.windowManager.confirm(editor.getLang('clipboard_msg'), function(state) {\n\t\t\t\t\t\t\tif (state)\n\t\t\t\t\t\t\t\topen('http://www.mozilla.org/editor/midasdemo/securityprefs.html', '_blank');\n\t\t\t\t\t\t});\n\t\t\t\t\t} else\n\t\t\t\t\t\teditor.windowManager.alert(editor.getLang('clipboard_no_support'));\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Override unlink command\n\t\t\tunlink : function(command) {\n\t\t\t\tif (selection.isCollapsed())\n\t\t\t\t\tselection.select(selection.getNode());\n\n\t\t\t\texecNativeCommand(command);\n\t\t\t\tselection.collapse(FALSE);\n\t\t\t},\n\n\t\t\t// Override justify commands to use the text formatter engine\n\t\t\t'JustifyLeft,JustifyCenter,JustifyRight,JustifyFull' : function(command) {\n\t\t\t\tvar align = command.substring(7);\n\n\t\t\t\t// Remove all other alignments first\n\t\t\t\teach('left,center,right,full'.split(','), function(name) {\n\t\t\t\t\tif (align != name)\n\t\t\t\t\t\tformatter.remove('align' + name);\n\t\t\t\t});\n\n\t\t\t\ttoggleFormat('align' + align);\n\t\t\t\texecCommand('mceRepaint');\n\t\t\t},\n\n\t\t\t// Override list commands to fix WebKit bug\n\t\t\t'InsertUnorderedList,InsertOrderedList' : function(command) {\n\t\t\t\tvar listElm, listParent;\n\n\t\t\t\texecNativeCommand(command);\n\n\t\t\t\t// WebKit produces lists within block elements so we need to split them\n\t\t\t\t// we will replace the native list creation logic to custom logic later on\n\t\t\t\t// TODO: Remove this when the list creation logic is removed\n\t\t\t\tlistElm = dom.getParent(selection.getNode(), 'ol,ul');\n\t\t\t\tif (listElm) {\n\t\t\t\t\tlistParent = listElm.parentNode;\n\n\t\t\t\t\t// If list is within a text block then split that block\n\t\t\t\t\tif (/^(H[1-6]|P|ADDRESS|PRE)$/.test(listParent.nodeName)) {\n\t\t\t\t\t\tstoreSelection();\n\t\t\t\t\t\tdom.split(listParent, listElm);\n\t\t\t\t\t\trestoreSelection();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Override commands to use the text formatter engine\n\t\t\t'Bold,Italic,Underline,Strikethrough,Superscript,Subscript' : function(command) {\n\t\t\t\ttoggleFormat(command);\n\t\t\t},\n\n\t\t\t// Override commands to use the text formatter engine\n\t\t\t'ForeColor,HiliteColor,FontName' : function(command, ui, value) {\n\t\t\t\ttoggleFormat(command, value);\n\t\t\t},\n\n\t\t\tFontSize : function(command, ui, value) {\n\t\t\t\tvar fontClasses, fontSizes;\n\n\t\t\t\t// Convert font size 1-7 to styles\n\t\t\t\tif (value >= 1 && value <= 7) {\n\t\t\t\t\tfontSizes = tinymce.explode(settings.font_size_style_values);\n\t\t\t\t\tfontClasses = tinymce.explode(settings.font_size_classes);\n\n\t\t\t\t\tif (fontClasses)\n\t\t\t\t\t\tvalue = fontClasses[value - 1] || value;\n\t\t\t\t\telse\n\t\t\t\t\t\tvalue = fontSizes[value - 1] || value;\n\t\t\t\t}\n\n\t\t\t\ttoggleFormat(command, value);\n\t\t\t},\n\n\t\t\tRemoveFormat : function(command) {\n\t\t\t\tformatter.remove(command);\n\t\t\t},\n\n\t\t\tmceBlockQuote : function(command) {\n\t\t\t\ttoggleFormat('blockquote');\n\t\t\t},\n\n\t\t\tFormatBlock : function(command, ui, value) {\n\t\t\t\treturn toggleFormat(value || 'p');\n\t\t\t},\n\n\t\t\tmceCleanup : function() {\n\t\t\t\tvar bookmark = selection.getBookmark();\n\n\t\t\t\teditor.setContent(editor.getContent({cleanup : TRUE}), {cleanup : TRUE});\n\n\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t},\n\n\t\t\tmceRemoveNode : function(command, ui, value) {\n\t\t\t\tvar node = value || selection.getNode();\n\n\t\t\t\t// Make sure that the body node isn't removed\n\t\t\t\tif (node != editor.getBody()) {\n\t\t\t\t\tstoreSelection();\n\t\t\t\t\teditor.dom.remove(node, TRUE);\n\t\t\t\t\trestoreSelection();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tmceSelectNodeDepth : function(command, ui, value) {\n\t\t\t\tvar counter = 0;\n\n\t\t\t\tdom.getParent(selection.getNode(), function(node) {\n\t\t\t\t\tif (node.nodeType == 1 && counter++ == value) {\n\t\t\t\t\t\tselection.select(node);\n\t\t\t\t\t\treturn FALSE;\n\t\t\t\t\t}\n\t\t\t\t}, editor.getBody());\n\t\t\t},\n\n\t\t\tmceSelectNode : function(command, ui, value) {\n\t\t\t\tselection.select(value);\n\t\t\t},\n\n\t\t\tmceInsertContent : function(command, ui, value) {\n\t\t\t\tvar parser, serializer, parentNode, rootNode, fragment, args,\n\t\t\t\t\tmarker, nodeRect, viewPortRect, rng, node, node2, bookmarkHtml, viewportBodyElement;\n\n\t\t\t\t// Setup parser and serializer\n\t\t\t\tparser = editor.parser;\n\t\t\t\tserializer = new tinymce.html.Serializer({}, editor.schema);\n\t\t\t\tbookmarkHtml = '<span id=\"mce_marker\" data-mce-type=\"bookmark\">\\uFEFF</span>';\n\n\t\t\t\t// Run beforeSetContent handlers on the HTML to be inserted\n\t\t\t\targs = {content: value, format: 'html'};\n\t\t\t\tselection.onBeforeSetContent.dispatch(selection, args);\n\t\t\t\tvalue = args.content;\n\n\t\t\t\t// Add caret at end of contents if it's missing\n\t\t\t\tif (value.indexOf('{$caret}') == -1)\n\t\t\t\t\tvalue += '{$caret}';\n\n\t\t\t\t// Replace the caret marker with a span bookmark element\n\t\t\t\tvalue = value.replace(/\\{\\$caret\\}/, bookmarkHtml);\n\n\t\t\t\t// Insert node maker where we will insert the new HTML and get it's parent\n\t\t\t\tif (!selection.isCollapsed())\n\t\t\t\t\teditor.getDoc().execCommand('Delete', false, null);\n\n\t\t\t\tparentNode = selection.getNode();\n\n\t\t\t\t// Parse the fragment within the context of the parent node\n\t\t\t\targs = {context : parentNode.nodeName.toLowerCase()};\n\t\t\t\tfragment = parser.parse(value, args);\n\n\t\t\t\t// Move the caret to a more suitable location\n\t\t\t\tnode = fragment.lastChild;\n\t\t\t\tif (node.attr('id') == 'mce_marker') {\n\t\t\t\t\tmarker = node;\n\n\t\t\t\t\tfor (node = node.prev; node; node = node.walk(true)) {\n\t\t\t\t\t\tif (node.type == 3 || !dom.isBlock(node.name)) {\n\t\t\t\t\t\t\tnode.parent.insert(marker, node, node.name === 'br');\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// If parser says valid we can insert the contents into that parent\n\t\t\t\tif (!args.invalid) {\n\t\t\t\t\tvalue = serializer.serialize(fragment);\n\n\t\t\t\t\t// Check if parent is empty or only has one BR element then set the innerHTML of that parent\n\t\t\t\t\tnode = parentNode.firstChild;\n\t\t\t\t\tnode2 = parentNode.lastChild;\n\t\t\t\t\tif (!node || (node === node2 && node.nodeName === 'BR'))\n\t\t\t\t\t\tdom.setHTML(parentNode, value);\n\t\t\t\t\telse\n\t\t\t\t\t\tselection.setContent(value);\n\t\t\t\t} else {\n\t\t\t\t\t// If the fragment was invalid within that context then we need\n\t\t\t\t\t// to parse and process the parent it's inserted into\n\n\t\t\t\t\t// Insert bookmark node and get the parent\n\t\t\t\t\tselection.setContent(bookmarkHtml);\n\t\t\t\t\tparentNode = editor.selection.getNode();\n\t\t\t\t\trootNode = editor.getBody();\n\n\t\t\t\t\t// Opera will return the document node when selection is in root\n\t\t\t\t\tif (parentNode.nodeType == 9)\n\t\t\t\t\t\tparentNode = node = rootNode;\n\t\t\t\t\telse\n\t\t\t\t\t\tnode = parentNode;\n\n\t\t\t\t\t// Find the ancestor just before the root element\n\t\t\t\t\twhile (node !== rootNode) {\n\t\t\t\t\t\tparentNode = node;\n\t\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Get the outer/inner HTML depending on if we are in the root and parser and serialize that\n\t\t\t\t\tvalue = parentNode == rootNode ? rootNode.innerHTML : dom.getOuterHTML(parentNode);\n\t\t\t\t\tvalue = serializer.serialize(\n\t\t\t\t\t\tparser.parse(\n\t\t\t\t\t\t\t// Need to replace by using a function since $ in the contents would otherwise be a problem\n\t\t\t\t\t\t\tvalue.replace(/<span (id=\"mce_marker\"|id=mce_marker).+?<\\/span>/i, function() {\n\t\t\t\t\t\t\t\treturn serializer.serialize(fragment);\n\t\t\t\t\t\t\t})\n\t\t\t\t\t\t)\n\t\t\t\t\t);\n\n\t\t\t\t\t// Set the inner/outer HTML depending on if we are in the root or not\n\t\t\t\t\tif (parentNode == rootNode)\n\t\t\t\t\t\tdom.setHTML(rootNode, value);\n\t\t\t\t\telse\n\t\t\t\t\t\tdom.setOuterHTML(parentNode, value);\n\t\t\t\t}\n\n\t\t\t\tmarker = dom.get('mce_marker');\n\n\t\t\t\t// Scroll range into view scrollIntoView on element can't be used since it will scroll the main view port as well\n\t\t\t\tnodeRect = dom.getRect(marker);\n\t\t\t\tviewPortRect = dom.getViewPort(editor.getWin());\n\n\t\t\t\t// Check if node is out side the viewport if it is then scroll to it\n\t\t\t\tif ((nodeRect.y + nodeRect.h > viewPortRect.y + viewPortRect.h || nodeRect.y < viewPortRect.y) ||\n\t\t\t\t\t(nodeRect.x > viewPortRect.x + viewPortRect.w || nodeRect.x < viewPortRect.x)) {\n\t\t\t\t\tviewportBodyElement = tinymce.isIE ? editor.getDoc().documentElement : editor.getBody();\n\t\t\t\t\tviewportBodyElement.scrollLeft = nodeRect.x;\n\t\t\t\t\tviewportBodyElement.scrollTop = nodeRect.y - viewPortRect.h + 25;\n\t\t\t\t}\n\n\t\t\t\t// Move selection before marker and remove it\n\t\t\t\trng = dom.createRng();\n\n\t\t\t\t// If previous sibling is a text node set the selection to the end of that node\n\t\t\t\tnode = marker.previousSibling;\n\t\t\t\tif (node && node.nodeType == 3) {\n\t\t\t\t\trng.setStart(node, node.nodeValue.length);\n\t\t\t\t} else {\n\t\t\t\t\t// If the previous sibling isn't a text node or doesn't exist set the selection before the marker node\n\t\t\t\t\trng.setStartBefore(marker);\n\t\t\t\t\trng.setEndBefore(marker);\n\t\t\t\t}\n\n\t\t\t\t// Remove the marker node and set the new range\n\t\t\t\tdom.remove(marker);\n\t\t\t\tselection.setRng(rng);\n\n\t\t\t\t// Dispatch after event and add any visual elements needed\n\t\t\t\tselection.onSetContent.dispatch(selection, args);\n\t\t\t\teditor.addVisual();\n\t\t\t},\n\n\t\t\tmceInsertRawHTML : function(command, ui, value) {\n\t\t\t\tselection.setContent('tiny_mce_marker');\n\t\t\t\teditor.setContent(editor.getContent().replace(/tiny_mce_marker/g, function() { return value }));\n\t\t\t},\n\n\t\t\tmceSetContent : function(command, ui, value) {\n\t\t\t\teditor.setContent(value);\n\t\t\t},\n\n\t\t\t'Indent,Outdent' : function(command) {\n\t\t\t\tvar intentValue, indentUnit, value;\n\n\t\t\t\t// Setup indent level\n\t\t\t\tintentValue = settings.indentation;\n\t\t\t\tindentUnit = /[a-z%]+$/i.exec(intentValue);\n\t\t\t\tintentValue = parseInt(intentValue);\n\n\t\t\t\tif (!queryCommandState('InsertUnorderedList') && !queryCommandState('InsertOrderedList')) {\n\t\t\t\t\teach(selection.getSelectedBlocks(), function(element) {\n\t\t\t\t\t\tif (command == 'outdent') {\n\t\t\t\t\t\t\tvalue = Math.max(0, parseInt(element.style.paddingLeft || 0) - intentValue);\n\t\t\t\t\t\t\tdom.setStyle(element, 'paddingLeft', value ? value + indentUnit : '');\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\tdom.setStyle(element, 'paddingLeft', (parseInt(element.style.paddingLeft || 0) + intentValue) + indentUnit);\n\t\t\t\t\t});\n\t\t\t\t} else\n\t\t\t\t\texecNativeCommand(command);\n\t\t\t},\n\n\t\t\tmceRepaint : function() {\n\t\t\t\tvar bookmark;\n\n\t\t\t\tif (tinymce.isGecko) {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tstoreSelection(TRUE);\n\n\t\t\t\t\t\tif (selection.getSel())\n\t\t\t\t\t\t\tselection.getSel().selectAllChildren(editor.getBody());\n\n\t\t\t\t\t\tselection.collapse(TRUE);\n\t\t\t\t\t\trestoreSelection();\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// Ignore\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tmceToggleFormat : function(command, ui, value) {\n\t\t\t\tformatter.toggle(value);\n\t\t\t},\n\n\t\t\tInsertHorizontalRule : function() {\n\t\t\t\teditor.execCommand('mceInsertContent', false, '<hr />');\n\t\t\t},\n\n\t\t\tmceToggleVisualAid : function() {\n\t\t\t\teditor.hasVisual = !editor.hasVisual;\n\t\t\t\teditor.addVisual();\n\t\t\t},\n\n\t\t\tmceReplaceContent : function(command, ui, value) {\n\t\t\t\teditor.execCommand('mceInsertContent', false, value.replace(/\\{\\$selection\\}/g, selection.getContent({format : 'text'})));\n\t\t\t},\n\n\t\t\tmceInsertLink : function(command, ui, value) {\n\t\t\t\tvar anchor;\n\n\t\t\t\tif (typeof(value) == 'string')\n\t\t\t\t\tvalue = {href : value};\n\n\t\t\t\tanchor = dom.getParent(selection.getNode(), 'a');\n\n\t\t\t\t// Spaces are never valid in URLs and it's a very common mistake for people to make so we fix it here.\n\t\t\t\tvalue.href = value.href.replace(' ', '%20');\n\n\t\t\t\t// Remove existing links if there could be child links or that the href isn't specified\n\t\t\t\tif (!anchor || !value.href) {\n\t\t\t\t\tformatter.remove('link');\n\t\t\t\t}\n\n\t\t\t\t// Apply new link to selection\n\t\t\t\tif (value.href) {\n\t\t\t\t\tformatter.apply('link', value, anchor);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tselectAll : function() {\n\t\t\t\tvar root = dom.getRoot(), rng = dom.createRng();\n\n\t\t\t\trng.setStart(root, 0);\n\t\t\t\trng.setEnd(root, root.childNodes.length);\n\n\t\t\t\teditor.selection.setRng(rng);\n\t\t\t}\n\t\t});\n\n\t\t// Add queryCommandState overrides\n\t\taddCommands({\n\t\t\t// Override justify commands\n\t\t\t'JustifyLeft,JustifyCenter,JustifyRight,JustifyFull' : function(command) {\n\t\t\t\treturn isFormatMatch('align' + command.substring(7));\n\t\t\t},\n\n\t\t\t'Bold,Italic,Underline,Strikethrough,Superscript,Subscript' : function(command) {\n\t\t\t\treturn isFormatMatch(command);\n\t\t\t},\n\n\t\t\tmceBlockQuote : function() {\n\t\t\t\treturn isFormatMatch('blockquote');\n\t\t\t},\n\n\t\t\tOutdent : function() {\n\t\t\t\tvar node;\n\n\t\t\t\tif (settings.inline_styles) {\n\t\t\t\t\tif ((node = dom.getParent(selection.getStart(), dom.isBlock)) && parseInt(node.style.paddingLeft) > 0)\n\t\t\t\t\t\treturn TRUE;\n\n\t\t\t\t\tif ((node = dom.getParent(selection.getEnd(), dom.isBlock)) && parseInt(node.style.paddingLeft) > 0)\n\t\t\t\t\t\treturn TRUE;\n\t\t\t\t}\n\n\t\t\t\treturn queryCommandState('InsertUnorderedList') || queryCommandState('InsertOrderedList') || (!settings.inline_styles && !!dom.getParent(selection.getNode(), 'BLOCKQUOTE'));\n\t\t\t},\n\n\t\t\t'InsertUnorderedList,InsertOrderedList' : function(command) {\n\t\t\t\treturn dom.getParent(selection.getNode(), command == 'insertunorderedlist' ? 'UL' : 'OL');\n\t\t\t}\n\t\t}, 'state');\n\n\t\t// Add queryCommandValue overrides\n\t\taddCommands({\n\t\t\t'FontSize,FontName' : function(command) {\n\t\t\t\tvar value = 0, parent;\n\n\t\t\t\tif (parent = dom.getParent(selection.getNode(), 'span')) {\n\t\t\t\t\tif (command == 'fontsize')\n\t\t\t\t\t\tvalue = parent.style.fontSize;\n\t\t\t\t\telse\n\t\t\t\t\t\tvalue = parent.style.fontFamily.replace(/, /g, ',').replace(/[\\'\\\"]/g, '').toLowerCase();\n\t\t\t\t}\n\n\t\t\t\treturn value;\n\t\t\t}\n\t\t}, 'value');\n\n\t\t// Add undo manager logic\n\t\tif (settings.custom_undo_redo) {\n\t\t\taddCommands({\n\t\t\t\tUndo : function() {\n\t\t\t\t\teditor.undoManager.undo();\n\t\t\t\t},\n\n\t\t\t\tRedo : function() {\n\t\t\t\t\teditor.undoManager.redo();\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t};\n})(tinymce);\n\n(function(tinymce) {\n\tvar Dispatcher = tinymce.util.Dispatcher;\n\n\ttinymce.UndoManager = function(editor) {\n\t\tvar self, index = 0, data = [], beforeBookmark;\n\n\t\tfunction getContent() {\n\t\t\treturn tinymce.trim(editor.getContent({format : 'raw', no_events : 1}));\n\t\t};\n\n\t\treturn self = {\n\t\t\ttyping : false,\n\n\t\t\tonAdd : new Dispatcher(self),\n\n\t\t\tonUndo : new Dispatcher(self),\n\n\t\t\tonRedo : new Dispatcher(self),\n\n\t\t\tbeforeChange : function() {\n\t\t\t\tbeforeBookmark = editor.selection.getBookmark(2, true);\n\t\t\t},\n\n\t\t\tadd : function(level) {\n\t\t\t\tvar i, settings = editor.settings, lastLevel;\n\n\t\t\t\tlevel = level || {};\n\t\t\t\tlevel.content = getContent();\n\n\t\t\t\t// Add undo level if needed\n\t\t\t\tlastLevel = data[index];\n\t\t\t\tif (lastLevel && lastLevel.content == level.content)\n\t\t\t\t\treturn null;\n\n\t\t\t\t// Set before bookmark on previous level\n\t\t\t\tif (data[index])\n\t\t\t\t\tdata[index].beforeBookmark = beforeBookmark;\n\n\t\t\t\t// Time to compress\n\t\t\t\tif (settings.custom_undo_redo_levels) {\n\t\t\t\t\tif (data.length > settings.custom_undo_redo_levels) {\n\t\t\t\t\t\tfor (i = 0; i < data.length - 1; i++)\n\t\t\t\t\t\t\tdata[i] = data[i + 1];\n\n\t\t\t\t\t\tdata.length--;\n\t\t\t\t\t\tindex = data.length;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Get a non intrusive normalized bookmark\n\t\t\t\tlevel.bookmark = editor.selection.getBookmark(2, true);\n\n\t\t\t\t// Crop array if needed\n\t\t\t\tif (index < data.length - 1)\n\t\t\t\t\tdata.length = index + 1;\n\n\t\t\t\tdata.push(level);\n\t\t\t\tindex = data.length - 1;\n\n\t\t\t\tself.onAdd.dispatch(self, level);\n\t\t\t\teditor.isNotDirty = 0;\n\n\t\t\t\treturn level;\n\t\t\t},\n\n\t\t\tundo : function() {\n\t\t\t\tvar level, i;\n\n\t\t\t\tif (self.typing) {\n\t\t\t\t\tself.add();\n\t\t\t\t\tself.typing = false;\n\t\t\t\t}\n\n\t\t\t\tif (index > 0) {\n\t\t\t\t\tlevel = data[--index];\n\n\t\t\t\t\teditor.setContent(level.content, {format : 'raw'});\n\t\t\t\t\teditor.selection.moveToBookmark(level.beforeBookmark);\n\n\t\t\t\t\tself.onUndo.dispatch(self, level);\n\t\t\t\t}\n\n\t\t\t\treturn level;\n\t\t\t},\n\n\t\t\tredo : function() {\n\t\t\t\tvar level;\n\n\t\t\t\tif (index < data.length - 1) {\n\t\t\t\t\tlevel = data[++index];\n\n\t\t\t\t\teditor.setContent(level.content, {format : 'raw'});\n\t\t\t\t\teditor.selection.moveToBookmark(level.bookmark);\n\n\t\t\t\t\tself.onRedo.dispatch(self, level);\n\t\t\t\t}\n\n\t\t\t\treturn level;\n\t\t\t},\n\n\t\t\tclear : function() {\n\t\t\t\tdata = [];\n\t\t\t\tindex = 0;\n\t\t\t\tself.typing = false;\n\t\t\t},\n\n\t\t\thasUndo : function() {\n\t\t\t\treturn index > 0 || this.typing;\n\t\t\t},\n\n\t\t\thasRedo : function() {\n\t\t\t\treturn index < data.length - 1 && !this.typing;\n\t\t\t}\n\t\t};\n\t};\n})(tinymce);\n\n(function(tinymce) {\n\t// Shorten names\n\tvar Event = tinymce.dom.Event,\n\t\tisIE = tinymce.isIE,\n\t\tisGecko = tinymce.isGecko,\n\t\tisOpera = tinymce.isOpera,\n\t\teach = tinymce.each,\n\t\textend = tinymce.extend,\n\t\tTRUE = true,\n\t\tFALSE = false;\n\n\tfunction cloneFormats(node) {\n\t\tvar clone, temp, inner;\n\n\t\tdo {\n\t\t\tif (/^(SPAN|STRONG|B|EM|I|FONT|STRIKE|U)$/.test(node.nodeName)) {\n\t\t\t\tif (clone) {\n\t\t\t\t\ttemp = node.cloneNode(false);\n\t\t\t\t\ttemp.appendChild(clone);\n\t\t\t\t\tclone = temp;\n\t\t\t\t} else {\n\t\t\t\t\tclone = inner = node.cloneNode(false);\n\t\t\t\t}\n\n\t\t\t\tclone.removeAttribute('id');\n\t\t\t}\n\t\t} while (node = node.parentNode);\n\n\t\tif (clone)\n\t\t\treturn {wrapper : clone, inner : inner};\n\t};\n\n\t// Checks if the selection/caret is at the end of the specified block element\n\tfunction isAtEnd(rng, par) {\n\t\tvar rng2 = par.ownerDocument.createRange();\n\n\t\trng2.setStart(rng.endContainer, rng.endOffset);\n\t\trng2.setEndAfter(par);\n\n\t\t// Get number of characters to the right of the cursor if it's zero then we are at the end and need to merge the next block element\n\t\treturn rng2.cloneContents().textContent.length == 0;\n\t};\n\n\tfunction splitList(selection, dom, li) {\n\t\tvar listBlock, block;\n\n\t\tif (dom.isEmpty(li)) {\n\t\t\tlistBlock = dom.getParent(li, 'ul,ol');\n\n\t\t\tif (!dom.getParent(listBlock.parentNode, 'ul,ol')) {\n\t\t\t\tdom.split(listBlock, li);\n\t\t\t\tblock = dom.create('p', 0, '<br data-mce-bogus=\"1\" />');\n\t\t\t\tdom.replace(block, li);\n\t\t\t\tselection.select(block, 1);\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t}\n\n\t\treturn TRUE;\n\t};\n\n\ttinymce.create('tinymce.ForceBlocks', {\n\t\tForceBlocks : function(ed) {\n\t\t\tvar t = this, s = ed.settings, elm;\n\n\t\t\tt.editor = ed;\n\t\t\tt.dom = ed.dom;\n\t\t\telm = (s.forced_root_block || 'p').toLowerCase();\n\t\t\ts.element = elm.toUpperCase();\n\n\t\t\ted.onPreInit.add(t.setup, t);\n\t\t},\n\n\t\tsetup : function() {\n\t\t\tvar t = this, ed = t.editor, s = ed.settings, dom = ed.dom, selection = ed.selection, blockElements = ed.schema.getBlockElements();\n\n\t\t\t// Force root blocks\n\t\t\tif (s.forced_root_block) {\n\t\t\t\tfunction addRootBlocks() {\n\t\t\t\t\tvar node = selection.getStart(), rootNode = ed.getBody(), rng, startContainer, startOffset, endContainer, endOffset, rootBlockNode, tempNode, offset = -0xFFFFFF;\n\n\t\t\t\t\tif (!node || node.nodeType !== 1)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Check if node is wrapped in block\n\t\t\t\t\twhile (node != rootNode) {\n\t\t\t\t\t\tif (blockElements[node.nodeName])\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Get current selection\n\t\t\t\t\trng = selection.getRng();\n\t\t\t\t\tif (rng.setStart) {\n\t\t\t\t\t\tstartContainer = rng.startContainer;\n\t\t\t\t\t\tstartOffset = rng.startOffset;\n\t\t\t\t\t\tendContainer = rng.endContainer;\n\t\t\t\t\t\tendOffset = rng.endOffset;\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Force control range into text range\n\t\t\t\t\t\tif (rng.item) {\n\t\t\t\t\t\t\trng = ed.getDoc().body.createTextRange();\n\t\t\t\t\t\t\trng.moveToElementText(rng.item(0));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\ttmpRng = rng.duplicate();\n\t\t\t\t\t\ttmpRng.collapse(true);\n\t\t\t\t\t\tstartOffset = tmpRng.move('character', offset) * -1;\n\n\t\t\t\t\t\tif (!tmpRng.collapsed) {\n\t\t\t\t\t\t\ttmpRng = rng.duplicate();\n\t\t\t\t\t\t\ttmpRng.collapse(false);\n\t\t\t\t\t\t\tendOffset = (tmpRng.move('character', offset) * -1) - startOffset;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Wrap non block elements and text nodes\n\t\t\t\t\tfor (node = rootNode.firstChild; node; node) {\n\t\t\t\t\t\tif (node.nodeType === 3 || (node.nodeType == 1 && !blockElements[node.nodeName])) {\n\t\t\t\t\t\t\tif (!rootBlockNode) {\n\t\t\t\t\t\t\t\trootBlockNode = dom.create(s.forced_root_block);\n\t\t\t\t\t\t\t\tnode.parentNode.insertBefore(rootBlockNode, node);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\ttempNode = node;\n\t\t\t\t\t\t\tnode = node.nextSibling;\n\t\t\t\t\t\t\trootBlockNode.appendChild(tempNode);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\trootBlockNode = null;\n\t\t\t\t\t\t\tnode = node.nextSibling;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tif (rng.setStart) {\n\t\t\t\t\t\trng.setStart(startContainer, startOffset);\n\t\t\t\t\t\trng.setEnd(endContainer, endOffset);\n\t\t\t\t\t\tselection.setRng(rng);\n\t\t\t\t\t} else {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\trng = ed.getDoc().body.createTextRange();\n\t\t\t\t\t\t\trng.moveToElementText(rootNode);\n\t\t\t\t\t\t\trng.collapse(true);\n\t\t\t\t\t\t\trng.moveStart('character', startOffset);\n\n\t\t\t\t\t\t\tif (endOffset > 0)\n\t\t\t\t\t\t\t\trng.moveEnd('character', endOffset);\n\n\t\t\t\t\t\t\trng.select();\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\t// Ignore\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\ted.nodeChanged();\n\t\t\t\t};\n\n\t\t\t\ted.onKeyUp.add(addRootBlocks);\n\t\t\t\ted.onClick.add(addRootBlocks);\n\t\t\t}\n\n\t\t\tif (s.force_br_newlines) {\n\t\t\t\t// Force IE to produce BRs on enter\n\t\t\t\tif (isIE) {\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tvar n;\n\n\t\t\t\t\t\tif (e.keyCode == 13 && selection.getNode().nodeName != 'LI') {\n\t\t\t\t\t\t\tselection.setContent('<br id=\"__\" /> ', {format : 'raw'});\n\t\t\t\t\t\t\tn = dom.get('__');\n\t\t\t\t\t\t\tn.removeAttribute('id');\n\t\t\t\t\t\t\tselection.select(n);\n\t\t\t\t\t\t\tselection.collapse();\n\t\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (s.force_p_newlines) {\n\t\t\t\tif (!isIE) {\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tif (e.keyCode == 13 && !e.shiftKey && !t.insertPara(e))\n\t\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\t// Ungly hack to for IE to preserve the formatting when you press\n\t\t\t\t\t// enter at the end of a block element with formatted contents\n\t\t\t\t\t// This logic overrides the browsers default logic with\n\t\t\t\t\t// custom logic that enables us to control the output\n\t\t\t\t\ttinymce.addUnload(function() {\n\t\t\t\t\t\tt._previousFormats = 0; // Fix IE leak\n\t\t\t\t\t});\n\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tt._previousFormats = 0;\n\n\t\t\t\t\t\t// Clone the current formats, this will later be applied to the new block contents\n\t\t\t\t\t\tif (e.keyCode == 13 && !e.shiftKey && ed.selection.isCollapsed() && s.keep_styles)\n\t\t\t\t\t\t\tt._previousFormats = cloneFormats(ed.selection.getStart());\n\t\t\t\t\t});\n\n\t\t\t\t\ted.onKeyUp.add(function(ed, e) {\n\t\t\t\t\t\t// Let IE break the element and the wrap the new caret location in the previous formats\n\t\t\t\t\t\tif (e.keyCode == 13 && !e.shiftKey) {\n\t\t\t\t\t\t\tvar parent = ed.selection.getStart(), fmt = t._previousFormats;\n\n\t\t\t\t\t\t\t// Parent is an empty block\n\t\t\t\t\t\t\tif (!parent.hasChildNodes() && fmt) {\n\t\t\t\t\t\t\t\tparent = dom.getParent(parent, dom.isBlock);\n\n\t\t\t\t\t\t\t\tif (parent && parent.nodeName != 'LI') {\n\t\t\t\t\t\t\t\t\tparent.innerHTML = '';\n\n\t\t\t\t\t\t\t\t\tif (t._previousFormats) {\n\t\t\t\t\t\t\t\t\t\tparent.appendChild(fmt.wrapper);\n\t\t\t\t\t\t\t\t\t\tfmt.inner.innerHTML = '\\uFEFF';\n\t\t\t\t\t\t\t\t\t} else\n\t\t\t\t\t\t\t\t\t\tparent.innerHTML = '\\uFEFF';\n\n\t\t\t\t\t\t\t\t\tselection.select(parent, 1);\n\t\t\t\t\t\t\t\t\tselection.collapse(true);\n\t\t\t\t\t\t\t\t\ted.getDoc().execCommand('Delete', false, null);\n\t\t\t\t\t\t\t\t\tt._previousFormats = 0;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif (isGecko) {\n\t\t\t\t\ted.onKeyDown.add(function(ed, e) {\n\t\t\t\t\t\tif ((e.keyCode == 8 || e.keyCode == 46) && !e.shiftKey)\n\t\t\t\t\t\t\tt.backspaceDelete(e, e.keyCode == 8);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Workaround for missing shift+enter support, http://bugs.webkit.org/show_bug.cgi?id=16973\n\t\t\tif (tinymce.isWebKit) {\n\t\t\t\tfunction insertBr(ed) {\n\t\t\t\t\tvar rng = selection.getRng(), br, div = dom.create('div', null, ' '), divYPos, vpHeight = dom.getViewPort(ed.getWin()).h;\n\n\t\t\t\t\t// Insert BR element\n\t\t\t\t\trng.insertNode(br = dom.create('br'));\n\n\t\t\t\t\t// Place caret after BR\n\t\t\t\t\trng.setStartAfter(br);\n\t\t\t\t\trng.setEndAfter(br);\n\t\t\t\t\tselection.setRng(rng);\n\n\t\t\t\t\t// Could not place caret after BR then insert an nbsp entity and move the caret\n\t\t\t\t\tif (selection.getSel().focusNode == br.previousSibling) {\n\t\t\t\t\t\tselection.select(dom.insertAfter(dom.doc.createTextNode('\\u00a0'), br));\n\t\t\t\t\t\tselection.collapse(TRUE);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Create a temporary DIV after the BR and get the position as it\n\t\t\t\t\t// seems like getPos() returns 0 for text nodes and BR elements.\n\t\t\t\t\tdom.insertAfter(div, br);\n\t\t\t\t\tdivYPos = dom.getPos(div).y;\n\t\t\t\t\tdom.remove(div);\n\n\t\t\t\t\t// Scroll to new position, scrollIntoView can't be used due to bug: http://bugs.webkit.org/show_bug.cgi?id=16117\n\t\t\t\t\tif (divYPos > vpHeight) // It is not necessary to scroll if the DIV is inside the view port.\n\t\t\t\t\t\ted.getWin().scrollTo(0, divYPos);\n\t\t\t\t};\n\n\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\tif (e.keyCode == 13 && (e.shiftKey || (s.force_br_newlines && !dom.getParent(selection.getNode(), 'h1,h2,h3,h4,h5,h6,ol,ul')))) {\n\t\t\t\t\t\tinsertBr(ed);\n\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// IE specific fixes\n\t\t\tif (isIE) {\n\t\t\t\t// Replaces IE:s auto generated paragraphs with the specified element name\n\t\t\t\tif (s.element != 'P') {\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tt.lastElm = selection.getNode().nodeName;\n\t\t\t\t\t});\n\n\t\t\t\t\ted.onKeyUp.add(function(ed, e) {\n\t\t\t\t\t\tvar bl, n = selection.getNode(), b = ed.getBody();\n\n\t\t\t\t\t\tif (b.childNodes.length === 1 && n.nodeName == 'P') {\n\t\t\t\t\t\t\tn = dom.rename(n, s.element);\n\t\t\t\t\t\t\tselection.select(n);\n\t\t\t\t\t\t\tselection.collapse();\n\t\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t\t} else if (e.keyCode == 13 && !e.shiftKey && t.lastElm != 'P') {\n\t\t\t\t\t\t\tbl = dom.getParent(n, 'p');\n\n\t\t\t\t\t\t\tif (bl) {\n\t\t\t\t\t\t\t\tdom.rename(bl, s.element);\n\t\t\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tgetParentBlock : function(n) {\n\t\t\tvar d = this.dom;\n\n\t\t\treturn d.getParent(n, d.isBlock);\n\t\t},\n\n\t\tinsertPara : function(e) {\n\t\t\tvar t = this, ed = t.editor, dom = ed.dom, d = ed.getDoc(), se = ed.settings, s = ed.selection.getSel(), r = s.getRangeAt(0), b = d.body;\n\t\t\tvar rb, ra, dir, sn, so, en, eo, sb, eb, bn, bef, aft, sc, ec, n, vp = dom.getViewPort(ed.getWin()), y, ch, car;\n\n\t\t\ted.undoManager.beforeChange();\n\n\t\t\t// If root blocks are forced then use Operas default behavior since it's really good\n// Removed due to bug: #1853816\n//\t\t\tif (se.forced_root_block && isOpera)\n//\t\t\t\treturn TRUE;\n\n\t\t\t// Setup before range\n\t\t\trb = d.createRange();\n\n\t\t\t// If is before the first block element and in body, then move it into first block element\n\t\t\trb.setStart(s.anchorNode, s.anchorOffset);\n\t\t\trb.collapse(TRUE);\n\n\t\t\t// Setup after range\n\t\t\tra = d.createRange();\n\n\t\t\t// If is before the first block element and in body, then move it into first block element\n\t\t\tra.setStart(s.focusNode, s.focusOffset);\n\t\t\tra.collapse(TRUE);\n\n\t\t\t// Setup start/end points\n\t\t\tdir = rb.compareBoundaryPoints(rb.START_TO_END, ra) < 0;\n\t\t\tsn = dir ? s.anchorNode : s.focusNode;\n\t\t\tso = dir ? s.anchorOffset : s.focusOffset;\n\t\t\ten = dir ? s.focusNode : s.anchorNode;\n\t\t\teo = dir ? s.focusOffset : s.anchorOffset;\n\n\t\t\t// If selection is in empty table cell\n\t\t\tif (sn === en && /^(TD|TH)$/.test(sn.nodeName)) {\n\t\t\t\tif (sn.firstChild.nodeName == 'BR')\n\t\t\t\t\tdom.remove(sn.firstChild); // Remove BR\n\n\t\t\t\t// Create two new block elements\n\t\t\t\tif (sn.childNodes.length == 0) {\n\t\t\t\t\ted.dom.add(sn, se.element, null, '<br />');\n\t\t\t\t\taft = ed.dom.add(sn, se.element, null, '<br />');\n\t\t\t\t} else {\n\t\t\t\t\tn = sn.innerHTML;\n\t\t\t\t\tsn.innerHTML = '';\n\t\t\t\t\ted.dom.add(sn, se.element, null, n);\n\t\t\t\t\taft = ed.dom.add(sn, se.element, null, '<br />');\n\t\t\t\t}\n\n\t\t\t\t// Move caret into the last one\n\t\t\t\tr = d.createRange();\n\t\t\t\tr.selectNodeContents(aft);\n\t\t\t\tr.collapse(1);\n\t\t\t\ted.selection.setRng(r);\n\n\t\t\t\treturn FALSE;\n\t\t\t}\n\n\t\t\t// If the caret is in an invalid location in FF we need to move it into the first block\n\t\t\tif (sn == b && en == b && b.firstChild && ed.dom.isBlock(b.firstChild)) {\n\t\t\t\tsn = en = sn.firstChild;\n\t\t\t\tso = eo = 0;\n\t\t\t\trb = d.createRange();\n\t\t\t\trb.setStart(sn, 0);\n\t\t\t\tra = d.createRange();\n\t\t\t\tra.setStart(en, 0);\n\t\t\t}\n\n\t\t\t// If the body is totally empty add a BR element this might happen on webkit\n\t\t\tif (!d.body.hasChildNodes()) {\n\t\t\t\td.body.appendChild(dom.create('br'));\n\t\t\t}\n\n\t\t\t// Never use body as start or end node\n\t\t\tsn = sn.nodeName == \"HTML\" ? d.body : sn; // Fix for Opera bug: https://bugs.opera.com/show_bug.cgi?id=273224&comments=yes\n\t\t\tsn = sn.nodeName == \"BODY\" ? sn.firstChild : sn;\n\t\t\ten = en.nodeName == \"HTML\" ? d.body : en; // Fix for Opera bug: https://bugs.opera.com/show_bug.cgi?id=273224&comments=yes\n\t\t\ten = en.nodeName == \"BODY\" ? en.firstChild : en;\n\n\t\t\t// Get start and end blocks\n\t\t\tsb = t.getParentBlock(sn);\n\t\t\teb = t.getParentBlock(en);\n\t\t\tbn = sb ? sb.nodeName : se.element; // Get block name to create\n\n\t\t\t// Return inside list use default browser behavior\n\t\t\tif (n = t.dom.getParent(sb, 'li,pre')) {\n\t\t\t\tif (n.nodeName == 'LI')\n\t\t\t\t\treturn splitList(ed.selection, t.dom, n);\n\n\t\t\t\treturn TRUE;\n\t\t\t}\n\n\t\t\t// If caption or absolute layers then always generate new blocks within\n\t\t\tif (sb && (sb.nodeName == 'CAPTION' || /absolute|relative|fixed/gi.test(dom.getStyle(sb, 'position', 1)))) {\n\t\t\t\tbn = se.element;\n\t\t\t\tsb = null;\n\t\t\t}\n\n\t\t\t// If caption or absolute layers then always generate new blocks within\n\t\t\tif (eb && (eb.nodeName == 'CAPTION' || /absolute|relative|fixed/gi.test(dom.getStyle(sb, 'position', 1)))) {\n\t\t\t\tbn = se.element;\n\t\t\t\teb = null;\n\t\t\t}\n\n\t\t\t// Use P instead\n\t\t\tif (/(TD|TABLE|TH|CAPTION)/.test(bn) || (sb && bn == \"DIV\" && /left|right/gi.test(dom.getStyle(sb, 'float', 1)))) {\n\t\t\t\tbn = se.element;\n\t\t\t\tsb = eb = null;\n\t\t\t}\n\n\t\t\t// Setup new before and after blocks\n\t\t\tbef = (sb && sb.nodeName == bn) ? sb.cloneNode(0) : ed.dom.create(bn);\n\t\t\taft = (eb && eb.nodeName == bn) ? eb.cloneNode(0) : ed.dom.create(bn);\n\n\t\t\t// Remove id from after clone\n\t\t\taft.removeAttribute('id');\n\n\t\t\t// Is header and cursor is at the end, then force paragraph under\n\t\t\tif (/^(H[1-6])$/.test(bn) && isAtEnd(r, sb))\n\t\t\t\taft = ed.dom.create(se.element);\n\n\t\t\t// Find start chop node\n\t\t\tn = sc = sn;\n\t\t\tdo {\n\t\t\t\tif (n == b || n.nodeType == 9 || t.dom.isBlock(n) || /(TD|TABLE|TH|CAPTION)/.test(n.nodeName))\n\t\t\t\t\tbreak;\n\n\t\t\t\tsc = n;\n\t\t\t} while ((n = n.previousSibling ? n.previousSibling : n.parentNode));\n\n\t\t\t// Find end chop node\n\t\t\tn = ec = en;\n\t\t\tdo {\n\t\t\t\tif (n == b || n.nodeType == 9 || t.dom.isBlock(n) || /(TD|TABLE|TH|CAPTION)/.test(n.nodeName))\n\t\t\t\t\tbreak;\n\n\t\t\t\tec = n;\n\t\t\t} while ((n = n.nextSibling ? n.nextSibling : n.parentNode));\n\n\t\t\t// Place first chop part into before block element\n\t\t\tif (sc.nodeName == bn)\n\t\t\t\trb.setStart(sc, 0);\n\t\t\telse\n\t\t\t\trb.setStartBefore(sc);\n\n\t\t\trb.setEnd(sn, so);\n\t\t\tbef.appendChild(rb.cloneContents() || d.createTextNode('')); // Empty text node needed for Safari\n\n\t\t\t// Place secnd chop part within new block element\n\t\t\ttry {\n\t\t\t\tra.setEndAfter(ec);\n\t\t\t} catch(ex) {\n\t\t\t\t//console.debug(s.focusNode, s.focusOffset);\n\t\t\t}\n\n\t\t\tra.setStart(en, eo);\n\t\t\taft.appendChild(ra.cloneContents() || d.createTextNode('')); // Empty text node needed for Safari\n\n\t\t\t// Create range around everything\n\t\t\tr = d.createRange();\n\t\t\tif (!sc.previousSibling && sc.parentNode.nodeName == bn) {\n\t\t\t\tr.setStartBefore(sc.parentNode);\n\t\t\t} else {\n\t\t\t\tif (rb.startContainer.nodeName == bn && rb.startOffset == 0)\n\t\t\t\t\tr.setStartBefore(rb.startContainer);\n\t\t\t\telse\n\t\t\t\t\tr.setStart(rb.startContainer, rb.startOffset);\n\t\t\t}\n\n\t\t\tif (!ec.nextSibling && ec.parentNode.nodeName == bn)\n\t\t\t\tr.setEndAfter(ec.parentNode);\n\t\t\telse\n\t\t\t\tr.setEnd(ra.endContainer, ra.endOffset);\n\n\t\t\t// Delete and replace it with new block elements\n\t\t\tr.deleteContents();\n\n\t\t\tif (isOpera)\n\t\t\t\ted.getWin().scrollTo(0, vp.y);\n\n\t\t\t// Never wrap blocks in blocks\n\t\t\tif (bef.firstChild && bef.firstChild.nodeName == bn)\n\t\t\t\tbef.innerHTML = bef.firstChild.innerHTML;\n\n\t\t\tif (aft.firstChild && aft.firstChild.nodeName == bn)\n\t\t\t\taft.innerHTML = aft.firstChild.innerHTML;\n\n\t\t\tfunction appendStyles(e, en) {\n\t\t\t\tvar nl = [], nn, n, i;\n\n\t\t\t\te.innerHTML = '';\n\n\t\t\t\t// Make clones of style elements\n\t\t\t\tif (se.keep_styles) {\n\t\t\t\t\tn = en;\n\t\t\t\t\tdo {\n\t\t\t\t\t\t// We only want style specific elements\n\t\t\t\t\t\tif (/^(SPAN|STRONG|B|EM|I|FONT|STRIKE|U)$/.test(n.nodeName)) {\n\t\t\t\t\t\t\tnn = n.cloneNode(FALSE);\n\t\t\t\t\t\t\tdom.setAttrib(nn, 'id', ''); // Remove ID since it needs to be unique\n\t\t\t\t\t\t\tnl.push(nn);\n\t\t\t\t\t\t}\n\t\t\t\t\t} while (n = n.parentNode);\n\t\t\t\t}\n\n\t\t\t\t// Append style elements to aft\n\t\t\t\tif (nl.length > 0) {\n\t\t\t\t\tfor (i = nl.length - 1, nn = e; i >= 0; i--)\n\t\t\t\t\t\tnn = nn.appendChild(nl[i]);\n\n\t\t\t\t\t// Padd most inner style element\n\t\t\t\t\tnl[0].innerHTML = isOpera ? '\\u00a0' : '<br />'; // Extra space for Opera so that the caret can move there\n\t\t\t\t\treturn nl[0]; // Move caret to most inner element\n\t\t\t\t} else\n\t\t\t\t\te.innerHTML = isOpera ? '\\u00a0' : '<br />'; // Extra space for Opera so that the caret can move there\n\t\t\t};\n\n\t\t\t// Padd empty blocks\n\t\t\tif (dom.isEmpty(bef))\n\t\t\t\tappendStyles(bef, sn);\n\n\t\t\t// Fill empty afterblook with current style\n\t\t\tif (dom.isEmpty(aft))\n\t\t\t\tcar = appendStyles(aft, en);\n\n\t\t\t// Opera needs this one backwards for older versions\n\t\t\tif (isOpera && parseFloat(opera.version()) < 9.5) {\n\t\t\t\tr.insertNode(bef);\n\t\t\t\tr.insertNode(aft);\n\t\t\t} else {\n\t\t\t\tr.insertNode(aft);\n\t\t\t\tr.insertNode(bef);\n\t\t\t}\n\n\t\t\t// Normalize\n\t\t\taft.normalize();\n\t\t\tbef.normalize();\n\n\t\t\t// Move cursor and scroll into view\n\t\t\ted.selection.select(aft, true);\n\t\t\ted.selection.collapse(true);\n\n\t\t\t// scrollIntoView seems to scroll the parent window in most browsers now including FF 3.0b4 so it's time to stop using it and do it our selfs\n\t\t\ty = ed.dom.getPos(aft).y;\n\t\t\t//ch = aft.clientHeight;\n\n\t\t\t// Is element within viewport\n\t\t\tif (y < vp.y || y + 25 > vp.y + vp.h) {\n\t\t\t\ted.getWin().scrollTo(0, y < vp.y ? y : y - vp.h + 25); // Needs to be hardcoded to roughly one line of text if a huge text block is broken into two blocks\n\n\t\t\t\t/*console.debug(\n\t\t\t\t\t'Element: y=' + y + ', h=' + ch + ', ' +\n\t\t\t\t\t'Viewport: y=' + vp.y + \", h=\" + vp.h + ', bottom=' + (vp.y + vp.h)\n\t\t\t\t);*/\n\t\t\t}\n\n\t\t\ted.undoManager.add();\n\n\t\t\treturn FALSE;\n\t\t},\n\n\t\tbackspaceDelete : function(e, bs) {\n\t\t\tvar t = this, ed = t.editor, b = ed.getBody(), dom = ed.dom, n, se = ed.selection, r = se.getRng(), sc = r.startContainer, n, w, tn, walker;\n\n\t\t\t// Delete when caret is behind a element doesn't work correctly on Gecko see #3011651\n\t\t\tif (!bs && r.collapsed && sc.nodeType == 1 && r.startOffset == sc.childNodes.length) {\n\t\t\t\twalker = new tinymce.dom.TreeWalker(sc.lastChild, sc);\n\n\t\t\t\t// Walk the dom backwards until we find a text node\n\t\t\t\tfor (n = sc.lastChild; n; n = walker.prev()) {\n\t\t\t\t\tif (n.nodeType == 3) {\n\t\t\t\t\t\tr.setStart(n, n.nodeValue.length);\n\t\t\t\t\t\tr.collapse(true);\n\t\t\t\t\t\tse.setRng(r);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// The caret sometimes gets stuck in Gecko if you delete empty paragraphs\n\t\t\t// This workaround removes the element by hand and moves the caret to the previous element\n\t\t\tif (sc && ed.dom.isBlock(sc) && !/^(TD|TH)$/.test(sc.nodeName) && bs) {\n\t\t\t\tif (sc.childNodes.length == 0 || (sc.childNodes.length == 1 && sc.firstChild.nodeName == 'BR')) {\n\t\t\t\t\t// Find previous block element\n\t\t\t\t\tn = sc;\n\t\t\t\t\twhile ((n = n.previousSibling) && !ed.dom.isBlock(n)) ;\n\n\t\t\t\t\tif (n) {\n\t\t\t\t\t\tif (sc != b.firstChild) {\n\t\t\t\t\t\t\t// Find last text node\n\t\t\t\t\t\t\tw = ed.dom.doc.createTreeWalker(n, NodeFilter.SHOW_TEXT, null, FALSE);\n\t\t\t\t\t\t\twhile (tn = w.nextNode())\n\t\t\t\t\t\t\t\tn = tn;\n\n\t\t\t\t\t\t\t// Place caret at the end of last text node\n\t\t\t\t\t\t\tr = ed.getDoc().createRange();\n\t\t\t\t\t\t\tr.setStart(n, n.nodeValue ? n.nodeValue.length : 0);\n\t\t\t\t\t\t\tr.setEnd(n, n.nodeValue ? n.nodeValue.length : 0);\n\t\t\t\t\t\t\tse.setRng(r);\n\n\t\t\t\t\t\t\t// Remove the target container\n\t\t\t\t\t\t\ted.dom.remove(sc);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\t// Shorten names\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each, extend = tinymce.extend;\n\n\ttinymce.create('tinymce.ControlManager', {\n\t\tControlManager : function(ed, s) {\n\t\t\tvar t = this, i;\n\n\t\t\ts = s || {};\n\t\t\tt.editor = ed;\n\t\t\tt.controls = {};\n\t\t\tt.onAdd = new tinymce.util.Dispatcher(t);\n\t\t\tt.onPostRender = new tinymce.util.Dispatcher(t);\n\t\t\tt.prefix = s.prefix || ed.id + '_';\n\t\t\tt._cls = {};\n\n\t\t\tt.onPostRender.add(function() {\n\t\t\t\teach(t.controls, function(c) {\n\t\t\t\t\tc.postRender();\n\t\t\t\t});\n\t\t\t});\n\t\t},\n\n\t\tget : function(id) {\n\t\t\treturn this.controls[this.prefix + id] || this.controls[id];\n\t\t},\n\n\t\tsetActive : function(id, s) {\n\t\t\tvar c = null;\n\n\t\t\tif (c = this.get(id))\n\t\t\t\tc.setActive(s);\n\n\t\t\treturn c;\n\t\t},\n\n\t\tsetDisabled : function(id, s) {\n\t\t\tvar c = null;\n\n\t\t\tif (c = this.get(id))\n\t\t\t\tc.setDisabled(s);\n\n\t\t\treturn c;\n\t\t},\n\n\t\tadd : function(c) {\n\t\t\tvar t = this;\n\n\t\t\tif (c) {\n\t\t\t\tt.controls[c.id] = c;\n\t\t\t\tt.onAdd.dispatch(c, t);\n\t\t\t}\n\n\t\t\treturn c;\n\t\t},\n\n\t\tcreateControl : function(n) {\n\t\t\tvar c, t = this, ed = t.editor;\n\n\t\t\teach(ed.plugins, function(p) {\n\t\t\t\tif (p.createControl) {\n\t\t\t\t\tc = p.createControl(n, t);\n\n\t\t\t\t\tif (c)\n\t\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tswitch (n) {\n\t\t\t\tcase \"|\":\n\t\t\t\tcase \"separator\":\n\t\t\t\t\treturn t.createSeparator();\n\t\t\t}\n\n\t\t\tif (!c && ed.buttons && (c = ed.buttons[n]))\n\t\t\t\treturn t.createButton(n, c);\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateDropMenu : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, c, bm, v, cls;\n\n\t\t\ts = extend({\n\t\t\t\t'class' : 'mceDropDown',\n\t\t\t\tconstrain : ed.settings.constrain_menus\n\t\t\t}, s);\n\n\t\t\ts['class'] = s['class'] + ' ' + ed.getParam('skin') + 'Skin';\n\t\t\tif (v = ed.getParam('skin_variant'))\n\t\t\t\ts['class'] += ' ' + ed.getParam('skin') + 'Skin' + v.substring(0, 1).toUpperCase() + v.substring(1);\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.dropmenu || tinymce.ui.DropMenu;\n\t\t\tc = t.controls[id] = new cls(id, s);\n\t\t\tc.onAddItem.add(function(c, o) {\n\t\t\t\tvar s = o.settings;\n\n\t\t\t\ts.title = ed.getLang(s.title, s.title);\n\n\t\t\t\tif (!s.onclick) {\n\t\t\t\t\ts.onclick = function(v) {\n\t\t\t\t\t\tif (s.cmd)\n\t\t\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, s.value);\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t});\n\n\t\t\ted.onRemove.add(function() {\n\t\t\t\tc.destroy();\n\t\t\t});\n\n\t\t\t// Fix for bug #1897785, #1898007\n\t\t\tif (tinymce.isIE) {\n\t\t\t\tc.onShowMenu.add(function() {\n\t\t\t\t\t// IE 8 needs focus in order to store away a range with the current collapsed caret location\n\t\t\t\t\ted.focus();\n\n\t\t\t\t\tbm = ed.selection.getBookmark(1);\n\t\t\t\t});\n\n\t\t\t\tc.onHideMenu.add(function() {\n\t\t\t\t\tif (bm) {\n\t\t\t\t\t\ted.selection.moveToBookmark(bm);\n\t\t\t\t\t\tbm = 0;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateListBox : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, cmd, c, cls;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onselect) {\n\t\t\t\ts.onselect = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\tscope : s.scope,\n\t\t\t\tcontrol_manager : t\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\n\n\t\t\tfunction useNativeListForAccessibility(ed) {\n\t\t\t\treturn ed.settings.use_accessible_selects && !tinymce.isGecko\n\t\t\t}\n\n\t\t\tif (ed.settings.use_native_selects || useNativeListForAccessibility(ed))\n\t\t\t\tc = new tinymce.ui.NativeListBox(id, s);\n\t\t\telse {\n\t\t\t\tcls = cc || t._cls.listbox || tinymce.ui.ListBox;\n\t\t\t\tc = new cls(id, s, ed);\n\t\t\t}\n\n\t\t\tt.controls[id] = c;\n\n\t\t\t// Fix focus problem in Safari\n\t\t\tif (tinymce.isWebKit) {\n\t\t\t\tc.onPostRender.add(function(c, n) {\n\t\t\t\t\t// Store bookmark on mousedown\n\t\t\t\t\tEvent.add(n, 'mousedown', function() {\n\t\t\t\t\t\ted.bookmark = ed.selection.getBookmark(1);\n\t\t\t\t\t});\n\n\t\t\t\t\t// Restore on focus, since it might be lost\n\t\t\t\t\tEvent.add(n, 'focus', function() {\n\t\t\t\t\t\ted.selection.moveToBookmark(ed.bookmark);\n\t\t\t\t\t\ted.bookmark = null;\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (c.hideMenu)\n\t\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateButton : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, o, c, cls;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.label = ed.translate(s.label);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onclick && !s.menu_button) {\n\t\t\t\ts.onclick = function() {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\tunavailable_prefix : ed.getLang('unavailable', ''),\n\t\t\t\tscope : s.scope,\n\t\t\t\tcontrol_manager : t\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\n\t\t\tif (s.menu_button) {\n\t\t\t\tcls = cc || t._cls.menubutton || tinymce.ui.MenuButton;\n\t\t\t\tc = new cls(id, s, ed);\n\t\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\t\t\t} else {\n\t\t\t\tcls = t._cls.button || tinymce.ui.Button;\n\t\t\t\tc = new cls(id, s, ed);\n\t\t\t}\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateMenuButton : function(id, s, cc) {\n\t\t\ts = s || {};\n\t\t\ts.menu_button = 1;\n\n\t\t\treturn this.createButton(id, s, cc);\n\t\t},\n\n\t\tcreateSplitButton : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, cmd, c, cls;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onclick) {\n\t\t\t\ts.onclick = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (!s.onselect) {\n\t\t\t\ts.onselect = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\tscope : s.scope,\n\t\t\t\tcontrol_manager : t\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.splitbutton || tinymce.ui.SplitButton;\n\t\t\tc = t.add(new cls(id, s, ed));\n\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\n\t\t\treturn c;\n\t\t},\n\n\t\tcreateColorSplitButton : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, cmd, c, cls, bm;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onclick) {\n\t\t\t\ts.onclick = function(v) {\n\t\t\t\t\tif (tinymce.isIE)\n\t\t\t\t\t\tbm = ed.selection.getBookmark(1);\n\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (!s.onselect) {\n\t\t\t\ts.onselect = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\t'menu_class' : ed.getParam('skin') + 'Skin',\n\t\t\t\tscope : s.scope,\n\t\t\t\tmore_colors_title : ed.getLang('more_colors')\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.colorsplitbutton || tinymce.ui.ColorSplitButton;\n\t\t\tc = new cls(id, s, ed);\n\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\n\t\t\t// Remove the menu element when the editor is removed\n\t\t\ted.onRemove.add(function() {\n\t\t\t\tc.destroy();\n\t\t\t});\n\n\t\t\t// Fix for bug #1897785, #1898007\n\t\t\tif (tinymce.isIE) {\n\t\t\t\tc.onShowMenu.add(function() {\n\t\t\t\t\t// IE 8 needs focus in order to store away a range with the current collapsed caret location\n\t\t\t\t\ted.focus();\n\t\t\t\t\tbm = ed.selection.getBookmark(1);\n\t\t\t\t});\n\n\t\t\t\tc.onHideMenu.add(function() {\n\t\t\t\t\tif (bm) {\n\t\t\t\t\t\ted.selection.moveToBookmark(bm);\n\t\t\t\t\t\tbm = 0;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateToolbar : function(id, s, cc) {\n\t\t\tvar c, t = this, cls;\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.toolbar || tinymce.ui.Toolbar;\n\t\t\tc = new cls(id, s, t.editor);\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateToolbarGroup : function(id, s, cc) {\n\t\t\tvar c, t = this, cls;\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || this._cls.toolbarGroup || tinymce.ui.ToolbarGroup;\n\t\t\tc = new cls(id, s, t.editor);\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\tcreateSeparator : function(cc) {\n\t\t\tvar cls = cc || this._cls.separator || tinymce.ui.Separator;\n\n\t\t\treturn new cls();\n\t\t},\n\n\t\tsetControlType : function(n, c) {\n\t\t\treturn this._cls[n.toLowerCase()] = c;\n\t\t},\n\n\t\tdestroy : function() {\n\t\t\teach(this.controls, function(c) {\n\t\t\t\tc.destroy();\n\t\t\t});\n\n\t\t\tthis.controls = null;\n\t\t}\n\t});\n})(tinymce);\n\n(function(tinymce) {\n\tvar Dispatcher = tinymce.util.Dispatcher, each = tinymce.each, isIE = tinymce.isIE, isOpera = tinymce.isOpera;\n\n\ttinymce.create('tinymce.WindowManager', {\n\t\tWindowManager : function(ed) {\n\t\t\tvar t = this;\n\n\t\t\tt.editor = ed;\n\t\t\tt.onOpen = new Dispatcher(t);\n\t\t\tt.onClose = new Dispatcher(t);\n\t\t\tt.params = {};\n\t\t\tt.features = {};\n\t\t},\n\n\t\topen : function(s, p) {\n\t\t\tvar t = this, f = '', x, y, mo = t.editor.settings.dialog_type == 'modal', w, sw, sh, vp = tinymce.DOM.getViewPort(), u;\n\n\t\t\t// Default some options\n\t\t\ts = s || {};\n\t\t\tp = p || {};\n\t\t\tsw = isOpera ? vp.w : screen.width; // Opera uses windows inside the Opera window\n\t\t\tsh = isOpera ? vp.h : screen.height;\n\t\t\ts.name = s.name || 'mc_' + new Date().getTime();\n\t\t\ts.width = parseInt(s.width || 320);\n\t\t\ts.height = parseInt(s.height || 240);\n\t\t\ts.resizable = true;\n\t\t\ts.left = s.left || parseInt(sw / 2.0) - (s.width / 2.0);\n\t\t\ts.top = s.top || parseInt(sh / 2.0) - (s.height / 2.0);\n\t\t\tp.inline = false;\n\t\t\tp.mce_width = s.width;\n\t\t\tp.mce_height = s.height;\n\t\t\tp.mce_auto_focus = s.auto_focus;\n\n\t\t\tif (mo) {\n\t\t\t\tif (isIE) {\n\t\t\t\t\ts.center = true;\n\t\t\t\t\ts.help = false;\n\t\t\t\t\ts.dialogWidth = s.width + 'px';\n\t\t\t\t\ts.dialogHeight = s.height + 'px';\n\t\t\t\t\ts.scroll = s.scrollbars || false;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Build features string\n\t\t\teach(s, function(v, k) {\n\t\t\t\tif (tinymce.is(v, 'boolean'))\n\t\t\t\t\tv = v ? 'yes' : 'no';\n\n\t\t\t\tif (!/^(name|url)$/.test(k)) {\n\t\t\t\t\tif (isIE && mo)\n\t\t\t\t\t\tf += (f ? ';' : '') + k + ':' + v;\n\t\t\t\t\telse\n\t\t\t\t\t\tf += (f ? ',' : '') + k + '=' + v;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.features = s;\n\t\t\tt.params = p;\n\t\t\tt.onOpen.dispatch(t, s, p);\n\n\t\t\tu = s.url || s.file;\n\t\t\tu = tinymce._addVer(u);\n\n\t\t\ttry {\n\t\t\t\tif (isIE && mo) {\n\t\t\t\t\tw = 1;\n\t\t\t\t\twindow.showModalDialog(u, window, f);\n\t\t\t\t} else\n\t\t\t\t\tw = window.open(u, s.name, f);\n\t\t\t} catch (ex) {\n\t\t\t\t// Ignore\n\t\t\t}\n\n\t\t\tif (!w)\n\t\t\t\talert(t.editor.getLang('popup_blocked'));\n\t\t},\n\n\t\tclose : function(w) {\n\t\t\tw.close();\n\t\t\tthis.onClose.dispatch(this);\n\t\t},\n\n\t\tcreateInstance : function(cl, a, b, c, d, e) {\n\t\t\tvar f = tinymce.resolve(cl);\n\n\t\t\treturn new f(a, b, c, d, e);\n\t\t},\n\n\t\tconfirm : function(t, cb, s, w) {\n\t\t\tw = w || window;\n\n\t\t\tcb.call(s || this, w.confirm(this._decode(this.editor.getLang(t, t))));\n\t\t},\n\n\t\talert : function(tx, cb, s, w) {\n\t\t\tvar t = this;\n\n\t\t\tw = w || window;\n\t\t\tw.alert(t._decode(t.editor.getLang(tx, tx)));\n\n\t\t\tif (cb)\n\t\t\t\tcb.call(s || t);\n\t\t},\n\n\t\tresizeBy : function(dw, dh, win) {\n\t\t\twin.resizeBy(dw, dh);\n\t\t},\n\n\t\t// Internal functions\n\n\t\t_decode : function(s) {\n\t\t\treturn tinymce.DOM.decode(s).replace(/\\\\n/g, '\\n');\n\t\t}\n\t});\n}(tinymce));\n(function(tinymce) {\n\ttinymce.Formatter = function(ed) {\n\t\tvar formats = {},\n\t\t\teach = tinymce.each,\n\t\t\tdom = ed.dom,\n\t\t\tselection = ed.selection,\n\t\t\tTreeWalker = tinymce.dom.TreeWalker,\n\t\t\trangeUtils = new tinymce.dom.RangeUtils(dom),\n\t\t\tisValid = ed.schema.isValidChild,\n\t\t\tisBlock = dom.isBlock,\n\t\t\tforcedRootBlock = ed.settings.forced_root_block,\n\t\t\tnodeIndex = dom.nodeIndex,\n\t\t\tINVISIBLE_CHAR = '\\uFEFF',\n\t\t\tMCE_ATTR_RE = /^(src|href|style)$/,\n\t\t\tFALSE = false,\n\t\t\tTRUE = true,\n\t\t\tundefined;\n\n\t\tfunction isArray(obj) {\n\t\t\treturn obj instanceof Array;\n\t\t};\n\n\t\tfunction getParents(node, selector) {\n\t\t\treturn dom.getParents(node, selector, dom.getRoot());\n\t\t};\n\n\t\tfunction isCaretNode(node) {\n\t\t\treturn node.nodeType === 1 && (node.face === 'mceinline' || node.style.fontFamily === 'mceinline');\n\t\t};\n\n\t\t// Public functions\n\n\t\tfunction get(name) {\n\t\t\treturn name ? formats[name] : formats;\n\t\t};\n\n\t\tfunction register(name, format) {\n\t\t\tif (name) {\n\t\t\t\tif (typeof(name) !== 'string') {\n\t\t\t\t\teach(name, function(format, name) {\n\t\t\t\t\t\tregister(name, format);\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\t// Force format into array and add it to internal collection\n\t\t\t\t\tformat = format.length ? format : [format];\n\n\t\t\t\t\teach(format, function(format) {\n\t\t\t\t\t\t// Set deep to false by default on selector formats this to avoid removing\n\t\t\t\t\t\t// alignment on images inside paragraphs when alignment is changed on paragraphs\n\t\t\t\t\t\tif (format.deep === undefined)\n\t\t\t\t\t\t\tformat.deep = !format.selector;\n\n\t\t\t\t\t\t// Default to true\n\t\t\t\t\t\tif (format.split === undefined)\n\t\t\t\t\t\t\tformat.split = !format.selector || format.inline;\n\n\t\t\t\t\t\t// Default to true\n\t\t\t\t\t\tif (format.remove === undefined && format.selector && !format.inline)\n\t\t\t\t\t\t\tformat.remove = 'none';\n\n\t\t\t\t\t\t// Mark format as a mixed format inline + block level\n\t\t\t\t\t\tif (format.selector && format.inline) {\n\t\t\t\t\t\t\tformat.mixed = true;\n\t\t\t\t\t\t\tformat.block_expand = true;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Split classes if needed\n\t\t\t\t\t\tif (typeof(format.classes) === 'string')\n\t\t\t\t\t\t\tformat.classes = format.classes.split(/\\s+/);\n\t\t\t\t\t});\n\n\t\t\t\t\tformats[name] = format;\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tvar getTextDecoration = function(node) {\n\t\t\tvar decoration;\n\n\t\t\ted.dom.getParent(node, function(n) {\n\t\t\t\tdecoration = ed.dom.getStyle(n, 'text-decoration');\n\t\t\t\treturn decoration && decoration !== 'none';\n\t\t\t});\n\n\t\t\treturn decoration;\n\t\t};\n\n\t\tvar processUnderlineAndColor = function(node) {\n\t\t\tvar textDecoration;\n\t\t\tif (node.nodeType === 1 && node.parentNode && node.parentNode.nodeType === 1) {\n\t\t\t\ttextDecoration = getTextDecoration(node.parentNode);\n\t\t\t\tif (ed.dom.getStyle(node, 'color') && textDecoration) {\n\t\t\t\t\ted.dom.setStyle(node, 'text-decoration', textDecoration);\n\t\t\t\t} else if (ed.dom.getStyle(node, 'textdecoration') === textDecoration) {\n\t\t\t\t\ted.dom.setStyle(node, 'text-decoration', null);\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction apply(name, vars, node) {\n\t\t\tvar formatList = get(name), format = formatList[0], bookmark, rng, i, isCollapsed = selection.isCollapsed();\n\n\t\t\tfunction moveStart(rng) {\n\t\t\t\tvar container = rng.startContainer,\n\t\t\t\t\toffset = rng.startOffset,\n\t\t\t\t\twalker, node;\n\n\t\t\t\t// Move startContainer/startOffset in to a suitable node\n\t\t\t\tif (container.nodeType == 1 || container.nodeValue === \"\") {\n\t\t\t\t\tcontainer = container.nodeType == 1 ? container.childNodes[offset] : container;\n\n\t\t\t\t\t// Might fail if the offset is behind the last element in it's container\n\t\t\t\t\tif (container) {\n\t\t\t\t\t\twalker = new TreeWalker(container, container.parentNode);\n\t\t\t\t\t\tfor (node = walker.current(); node; node = walker.next()) {\n\t\t\t\t\t\t\tif (node.nodeType == 3 && !isWhiteSpaceNode(node)) {\n\t\t\t\t\t\t\t\trng.setStart(node, 0);\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn rng;\n\t\t\t};\n\n\t\t\tfunction setElementFormat(elm, fmt) {\n\t\t\t\tfmt = fmt || format;\n\n\t\t\t\tif (elm) {\n\t\t\t\t\tif (fmt.onformat) {\n\t\t\t\t\t\tfmt.onformat(elm, fmt, vars, node);\n\t\t\t\t\t}\n\n\t\t\t\t\teach(fmt.styles, function(value, name) {\n\t\t\t\t\t\tdom.setStyle(elm, name, replaceVars(value, vars));\n\t\t\t\t\t});\n\n\t\t\t\t\teach(fmt.attributes, function(value, name) {\n\t\t\t\t\t\tdom.setAttrib(elm, name, replaceVars(value, vars));\n\t\t\t\t\t});\n\n\t\t\t\t\teach(fmt.classes, function(value) {\n\t\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\t\tif (!dom.hasClass(elm, value))\n\t\t\t\t\t\t\tdom.addClass(elm, value);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t};\n\t\t\tfunction adjustSelectionToVisibleSelection() {\n\t\t\t\tfunction findSelectionEnd(start, end) {\n\t\t\t\t\tvar walker = new TreeWalker(end);\n\t\t\t\t\tfor (node = walker.current(); node; node = walker.prev()) {\n\t\t\t\t\t\tif (node.childNodes.length > 1 || node == start) {\n\t\t\t\t\t\t\treturn node;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\t// Adjust selection so that a end container with a end offset of zero is not included in the selection\n\t\t\t\t// as this isn't visible to the user.\n\t\t\t\tvar rng = ed.selection.getRng();\n\t\t\t\tvar start = rng.startContainer;\n\t\t\t\tvar end = rng.endContainer;\n\n\t\t\t\tif (start != end && rng.endOffset == 0) {\n\t\t\t\t\tvar newEnd = findSelectionEnd(start, end);\n\t\t\t\t\tvar endOffset = newEnd.nodeType == 3 ? newEnd.length : newEnd.childNodes.length;\n\n\t\t\t\t\trng.setEnd(newEnd, endOffset);\n\t\t\t\t}\n\n\t\t\t\treturn rng;\n\t\t\t}\n\n\t\t\tfunction applyStyleToList(node, bookmark, wrapElm, newWrappers, process){\n\t\t\t\tvar nodes = [], listIndex = -1, list, startIndex = -1, endIndex = -1, currentWrapElm;\n\n\t\t\t\t// find the index of the first child list.\n\t\t\t\teach(node.childNodes, function(n, index) {\n\t\t\t\t\tif (n.nodeName === \"UL\" || n.nodeName === \"OL\") {\n\t\t\t\t\t\tlistIndex = index;\n\t\t\t\t\t\tlist = n;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// get the index of the bookmarks\n\t\t\t\teach(node.childNodes, function(n, index) {\n\t\t\t\t\tif (n.nodeName === \"SPAN\" && dom.getAttrib(n, \"data-mce-type\") == \"bookmark\") {\n\t\t\t\t\t\tif (n.id == bookmark.id + \"_start\") {\n\t\t\t\t\t\t\tstartIndex = index;\n\t\t\t\t\t\t} else if (n.id == bookmark.id + \"_end\") {\n\t\t\t\t\t\t\tendIndex = index;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// if the selection spans across an embedded list, or there isn't an embedded list - handle processing normally\n\t\t\t\tif (listIndex <= 0 || (startIndex < listIndex && endIndex > listIndex)) {\n\t\t\t\t\teach(tinymce.grep(node.childNodes), process);\n\t\t\t\t\treturn 0;\n\t\t\t\t} else {\n\t\t\t\t\tcurrentWrapElm = wrapElm.cloneNode(FALSE);\n\n\t\t\t\t\t// create a list of the nodes on the same side of the list as the selection\n\t\t\t\t\teach(tinymce.grep(node.childNodes), function(n, index) {\n\t\t\t\t\t\tif ((startIndex < listIndex && index < listIndex) || (startIndex > listIndex && index > listIndex)) {\n\t\t\t\t\t\t\tnodes.push(n);\n\t\t\t\t\t\t\tn.parentNode.removeChild(n);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\n\t\t\t\t\t// insert the wrapping element either before or after the list.\n\t\t\t\t\tif (startIndex < listIndex) {\n\t\t\t\t\t\tnode.insertBefore(currentWrapElm, list);\n\t\t\t\t\t} else if (startIndex > listIndex) {\n\t\t\t\t\t\tnode.insertBefore(currentWrapElm, list.nextSibling);\n\t\t\t\t\t}\n\n\t\t\t\t\t// add the new nodes to the list.\n\t\t\t\t\tnewWrappers.push(currentWrapElm);\n\n\t\t\t\t\teach(nodes, function(node) {\n\t\t\t\t\t\tcurrentWrapElm.appendChild(node);\n\t\t\t\t\t});\n\n\t\t\t\t\treturn currentWrapElm;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tfunction applyRngStyle(rng, bookmark, node_specific) {\n\t\t\t\tvar newWrappers = [], wrapName, wrapElm;\n\n\t\t\t\t// Setup wrapper element\n\t\t\t\twrapName = format.inline || format.block;\n\t\t\t\twrapElm = dom.create(wrapName);\n\t\t\t\tsetElementFormat(wrapElm);\n\n\t\t\t\trangeUtils.walk(rng, function(nodes) {\n\t\t\t\t\tvar currentWrapElm;\n\n\t\t\t\t\tfunction process(node) {\n\t\t\t\t\t\tvar nodeName = node.nodeName.toLowerCase(), parentName = node.parentNode.nodeName.toLowerCase(), found;\n\n\t\t\t\t\t\t// Stop wrapping on br elements\n\t\t\t\t\t\tif (isEq(nodeName, 'br')) {\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\n\t\t\t\t\t\t\t// Remove any br elements when we wrap things\n\t\t\t\t\t\t\tif (format.block)\n\t\t\t\t\t\t\t\tdom.remove(node);\n\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// If node is wrapper type\n\t\t\t\t\t\tif (format.wrapper && matchNode(node, name, vars)) {\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Can we rename the block\n\t\t\t\t\t\tif (format.block && !format.wrapper && isTextBlock(nodeName)) {\n\t\t\t\t\t\t\tnode = dom.rename(node, wrapName);\n\t\t\t\t\t\t\tsetElementFormat(node);\n\t\t\t\t\t\t\tnewWrappers.push(node);\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Handle selector patterns\n\t\t\t\t\t\tif (format.selector) {\n\t\t\t\t\t\t\t// Look for matching formats\n\t\t\t\t\t\t\teach(formatList, function(format) {\n\t\t\t\t\t\t\t\t// Check collapsed state if it exists\n\t\t\t\t\t\t\t\tif ('collapsed' in format && format.collapsed !== isCollapsed) {\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tif (dom.is(node, format.selector) && !isCaretNode(node)) {\n\t\t\t\t\t\t\t\t\tsetElementFormat(node, format);\n\t\t\t\t\t\t\t\t\tfound = true;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t// Continue processing if a selector match wasn't found and a inline element is defined\n\t\t\t\t\t\t\tif (!format.inline || found) {\n\t\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Is it valid to wrap this item\n\t\t\t\t\t\tif (isValid(wrapName, nodeName) && isValid(parentName, wrapName) &&\n\t\t\t\t\t\t\t\t!(!node_specific && node.nodeType === 3 && node.nodeValue.length === 1 && node.nodeValue.charCodeAt(0) === 65279) && node.id !== '_mce_caret') {\n\t\t\t\t\t\t\t// Start wrapping\n\t\t\t\t\t\t\tif (!currentWrapElm) {\n\t\t\t\t\t\t\t\t// Wrap the node\n\t\t\t\t\t\t\t\tcurrentWrapElm = wrapElm.cloneNode(FALSE);\n\t\t\t\t\t\t\t\tnode.parentNode.insertBefore(currentWrapElm, node);\n\t\t\t\t\t\t\t\tnewWrappers.push(currentWrapElm);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tcurrentWrapElm.appendChild(node);\n\t\t\t\t\t\t} else if (nodeName == 'li' && bookmark) {\n\t\t\t\t\t\t\t// Start wrapping - if we are in a list node and have a bookmark, then we will always begin by wrapping in a new element.\n\t\t\t\t\t\t\tcurrentWrapElm = applyStyleToList(node, bookmark, wrapElm, newWrappers, process);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Start a new wrapper for possible children\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\n\t\t\t\t\t\t\teach(tinymce.grep(node.childNodes), process);\n\n\t\t\t\t\t\t\t// End the last wrapper\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\t\t// Process siblings from range\n\t\t\t\t\teach(nodes, process);\n\t\t\t\t});\n\n\t\t\t\t// Wrap links inside as well, for example color inside a link when the wrapper is around the link\n\t\t\t\tif (format.wrap_links === false) {\n\t\t\t\t\teach(newWrappers, function(node) {\n\t\t\t\t\t\tfunction process(node) {\n\t\t\t\t\t\t\tvar i, currentWrapElm, children;\n\n\t\t\t\t\t\t\tif (node.nodeName === 'A') {\n\t\t\t\t\t\t\t\tcurrentWrapElm = wrapElm.cloneNode(FALSE);\n\t\t\t\t\t\t\t\tnewWrappers.push(currentWrapElm);\n\n\t\t\t\t\t\t\t\tchildren = tinymce.grep(node.childNodes);\n\t\t\t\t\t\t\t\tfor (i = 0; i < children.length; i++)\n\t\t\t\t\t\t\t\t\tcurrentWrapElm.appendChild(children[i]);\n\n\t\t\t\t\t\t\t\tnode.appendChild(currentWrapElm);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\teach(tinymce.grep(node.childNodes), process);\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tprocess(node);\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\t// Cleanup\n\t\t\t\teach(newWrappers, function(node) {\n\t\t\t\t\tvar childCount;\n\n\t\t\t\t\tfunction getChildCount(node) {\n\t\t\t\t\t\tvar count = 0;\n\n\t\t\t\t\t\teach(node.childNodes, function(node) {\n\t\t\t\t\t\t\tif (!isWhiteSpaceNode(node) && !isBookmarkNode(node))\n\t\t\t\t\t\t\t\tcount++;\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\treturn count;\n\t\t\t\t\t};\n\n\t\t\t\t\tfunction mergeStyles(node) {\n\t\t\t\t\t\tvar child, clone;\n\n\t\t\t\t\t\teach(node.childNodes, function(node) {\n\t\t\t\t\t\t\tif (node.nodeType == 1 && !isBookmarkNode(node) && !isCaretNode(node)) {\n\t\t\t\t\t\t\t\tchild = node;\n\t\t\t\t\t\t\t\treturn FALSE; // break loop\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\t// If child was found and of the same type as the current node\n\t\t\t\t\t\tif (child && matchName(child, format)) {\n\t\t\t\t\t\t\tclone = child.cloneNode(FALSE);\n\t\t\t\t\t\t\tsetElementFormat(clone);\n\n\t\t\t\t\t\t\tdom.replace(clone, node, TRUE);\n\t\t\t\t\t\t\tdom.remove(child, 1);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn clone || node;\n\t\t\t\t\t};\n\n\t\t\t\t\tchildCount = getChildCount(node);\n\n\t\t\t\t\t// Remove empty nodes but only if there is multiple wrappers and they are not block\n\t\t\t\t\t// elements so never remove single <h1></h1> since that would remove the current empty block element where the caret is at\n\t\t\t\t\tif ((newWrappers.length > 1 || !isBlock(node)) && childCount === 0) {\n\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (format.inline || format.wrapper) {\n\t\t\t\t\t\t// Merges the current node with it's children of similar type to reduce the number of elements\n\t\t\t\t\t\tif (!format.exact && childCount === 1)\n\t\t\t\t\t\t\tnode = mergeStyles(node);\n\n\t\t\t\t\t\t// Remove/merge children\n\t\t\t\t\t\teach(formatList, function(format) {\n\t\t\t\t\t\t\t// Merge all children of similar type will move styles from child to parent\n\t\t\t\t\t\t\t// this: <span style=\"color:red\"><b><span style=\"color:red; font-size:10px\">text</span></b></span>\n\t\t\t\t\t\t\t// will become: <span style=\"color:red\"><b><span style=\"font-size:10px\">text</span></b></span>\n\t\t\t\t\t\t\teach(dom.select(format.inline, node), function(child) {\n\t\t\t\t\t\t\t\tvar parent;\n\n\t\t\t\t\t\t\t\t// When wrap_links is set to false we don't want\n\t\t\t\t\t\t\t\t// to remove the format on children within links\n\t\t\t\t\t\t\t\tif (format.wrap_links === false) {\n\t\t\t\t\t\t\t\t\tparent = child.parentNode;\n\n\t\t\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\t\t\tif (parent.nodeName === 'A')\n\t\t\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t\t} while (parent = parent.parentNode);\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tremoveFormat(format, vars, child, format.exact ? child : null);\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\t// Remove child if direct parent is of same type\n\t\t\t\t\t\tif (matchNode(node.parentNode, name, vars)) {\n\t\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t\t\tnode = 0;\n\t\t\t\t\t\t\treturn TRUE;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Look for parent with similar style format\n\t\t\t\t\t\tif (format.merge_with_parents) {\n\t\t\t\t\t\t\tdom.getParent(node.parentNode, function(parent) {\n\t\t\t\t\t\t\t\tif (matchNode(parent, name, vars)) {\n\t\t\t\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t\t\t\t\tnode = 0;\n\t\t\t\t\t\t\t\t\treturn TRUE;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Merge next and previous siblings if they are similar <b>text</b><b>text</b> becomes <b>texttext</b>\n\t\t\t\t\t\tif (node && format.merge_siblings !== false) {\n\t\t\t\t\t\t\tnode = mergeSiblings(getNonWhiteSpaceSibling(node), node);\n\t\t\t\t\t\t\tnode = mergeSiblings(node, getNonWhiteSpaceSibling(node, TRUE));\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t};\n\n\t\t\tif (format) {\n\t\t\t\tif (node) {\n\t\t\t\t\tif (node.nodeType) {\n\t\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\t\trng.setEndAfter(node);\n\t\t\t\t\t\tapplyRngStyle(expandRng(rng, formatList), null, true);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tapplyRngStyle(node, null, true);\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tif (!isCollapsed || !format.inline || dom.select('td.mceSelected,th.mceSelected').length) {\n\t\t\t\t\t\t// Obtain selection node before selection is unselected by applyRngStyle()\n\t\t\t\t\t\tvar curSelNode = ed.selection.getNode();\n\n\t\t\t\t\t\t// Apply formatting to selection\n\t\t\t\t\t\ted.selection.setRng(adjustSelectionToVisibleSelection());\n\t\t\t\t\t\tbookmark = selection.getBookmark();\n\t\t\t\t\t\tapplyRngStyle(expandRng(selection.getRng(TRUE), formatList), bookmark);\n\n\t\t\t\t\t\t// Colored nodes should be underlined so that the color of the underline matches the text color.\n\t\t\t\t\t\tif (format.styles && (format.styles.color || format.styles.textDecoration)) {\n\t\t\t\t\t\t\ttinymce.walk(curSelNode, processUnderlineAndColor, 'childNodes');\n\t\t\t\t\t\t\tprocessUnderlineAndColor(curSelNode);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t\t\t\tselection.setRng(moveStart(selection.getRng(TRUE)));\n\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t} else\n\t\t\t\t\t\tperformCaretAction('apply', name, vars);\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction remove(name, vars, node) {\n\t\t\tvar formatList = get(name), format = formatList[0], bookmark, i, rng;\n\t\t\tfunction moveStart(rng) {\n\t\t\t\tvar container = rng.startContainer,\n\t\t\t\t\toffset = rng.startOffset,\n\t\t\t\t\twalker, node, nodes, tmpNode;\n\n\t\t\t\t// Convert text node into index if possible\n\t\t\t\tif (container.nodeType == 3 && offset >= container.nodeValue.length - 1) {\n\t\t\t\t\tcontainer = container.parentNode;\n\t\t\t\t\toffset = nodeIndex(container) + 1;\n\t\t\t\t}\n\n\t\t\t\t// Move startContainer/startOffset in to a suitable node\n\t\t\t\tif (container.nodeType == 1) {\n\t\t\t\t\tnodes = container.childNodes;\n\t\t\t\t\tcontainer = nodes[Math.min(offset, nodes.length - 1)];\n\t\t\t\t\twalker = new TreeWalker(container);\n\n\t\t\t\t\t// If offset is at end of the parent node walk to the next one\n\t\t\t\t\tif (offset > nodes.length - 1)\n\t\t\t\t\t\twalker.next();\n\n\t\t\t\t\tfor (node = walker.current(); node; node = walker.next()) {\n\t\t\t\t\t\tif (node.nodeType == 3 && !isWhiteSpaceNode(node)) {\n\t\t\t\t\t\t\t// IE has a \"neat\" feature where it moves the start node into the closest element\n\t\t\t\t\t\t\t// we can avoid this by inserting an element before it and then remove it after we set the selection\n\t\t\t\t\t\t\ttmpNode = dom.create('a', null, INVISIBLE_CHAR);\n\t\t\t\t\t\t\tnode.parentNode.insertBefore(tmpNode, node);\n\n\t\t\t\t\t\t\t// Set selection and remove tmpNode\n\t\t\t\t\t\t\trng.setStart(node, 0);\n\t\t\t\t\t\t\tselection.setRng(rng);\n\t\t\t\t\t\t\tdom.remove(tmpNode);\n\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Merges the styles for each node\n\t\t\tfunction process(node) {\n\t\t\t\tvar children, i, l;\n\n\t\t\t\t// Grab the children first since the nodelist might be changed\n\t\t\t\tchildren = tinymce.grep(node.childNodes);\n\n\t\t\t\t// Process current node\n\t\t\t\tfor (i = 0, l = formatList.length; i < l; i++) {\n\t\t\t\t\tif (removeFormat(formatList[i], vars, node, node))\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\t// Process the children\n\t\t\t\tif (format.deep) {\n\t\t\t\t\tfor (i = 0, l = children.length; i < l; i++)\n\t\t\t\t\t\tprocess(children[i]);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tfunction findFormatRoot(container) {\n\t\t\t\tvar formatRoot;\n\n\t\t\t\t// Find format root\n\t\t\t\teach(getParents(container.parentNode).reverse(), function(parent) {\n\t\t\t\t\tvar format;\n\n\t\t\t\t\t// Find format root element\n\t\t\t\t\tif (!formatRoot && parent.id != '_start' && parent.id != '_end') {\n\t\t\t\t\t\t// Is the node matching the format we are looking for\n\t\t\t\t\t\tformat = matchNode(parent, name, vars);\n\t\t\t\t\t\tif (format && format.split !== false)\n\t\t\t\t\t\t\tformatRoot = parent;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\treturn formatRoot;\n\t\t\t};\n\n\t\t\tfunction wrapAndSplit(format_root, container, target, split) {\n\t\t\t\tvar parent, clone, lastClone, firstClone, i, formatRootParent;\n\n\t\t\t\t// Format root found then clone formats and split it\n\t\t\t\tif (format_root) {\n\t\t\t\t\tformatRootParent = format_root.parentNode;\n\n\t\t\t\t\tfor (parent = container.parentNode; parent && parent != formatRootParent; parent = parent.parentNode) {\n\t\t\t\t\t\tclone = parent.cloneNode(FALSE);\n\n\t\t\t\t\t\tfor (i = 0; i < formatList.length; i++) {\n\t\t\t\t\t\t\tif (removeFormat(formatList[i], vars, clone, clone)) {\n\t\t\t\t\t\t\t\tclone = 0;\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Build wrapper node\n\t\t\t\t\t\tif (clone) {\n\t\t\t\t\t\t\tif (lastClone)\n\t\t\t\t\t\t\t\tclone.appendChild(lastClone);\n\n\t\t\t\t\t\t\tif (!firstClone)\n\t\t\t\t\t\t\t\tfirstClone = clone;\n\n\t\t\t\t\t\t\tlastClone = clone;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Never split block elements if the format is mixed\n\t\t\t\t\tif (split && (!format.mixed || !isBlock(format_root)))\n\t\t\t\t\t\tcontainer = dom.split(format_root, container);\n\n\t\t\t\t\t// Wrap container in cloned formats\n\t\t\t\t\tif (lastClone) {\n\t\t\t\t\t\ttarget.parentNode.insertBefore(lastClone, target);\n\t\t\t\t\t\tfirstClone.appendChild(target);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn container;\n\t\t\t};\n\n\t\t\tfunction splitToFormatRoot(container) {\n\t\t\t\treturn wrapAndSplit(findFormatRoot(container), container, container, true);\n\t\t\t};\n\n\t\t\tfunction unwrap(start) {\n\t\t\t\tvar node = dom.get(start ? '_start' : '_end'),\n\t\t\t\t\tout = node[start ? 'firstChild' : 'lastChild'];\n\n\t\t\t\t// If the end is placed within the start the result will be removed\n\t\t\t\t// So this checks if the out node is a bookmark node if it is it\n\t\t\t\t// checks for another more suitable node\n\t\t\t\tif (isBookmarkNode(out))\n\t\t\t\t\tout = out[start ? 'firstChild' : 'lastChild'];\n\n\t\t\t\tdom.remove(node, true);\n\n\t\t\t\treturn out;\n\t\t\t};\n\n\t\t\tfunction removeRngStyle(rng) {\n\t\t\t\tvar startContainer, endContainer;\n\n\t\t\t\trng = expandRng(rng, formatList, TRUE);\n\n\t\t\t\tif (format.split) {\n\t\t\t\t\tstartContainer = getContainer(rng, TRUE);\n\t\t\t\t\tendContainer = getContainer(rng);\n\n\t\t\t\t\tif (startContainer != endContainer) {\n\t\t\t\t\t\t// Wrap start/end nodes in span element since these might be cloned/moved\n\t\t\t\t\t\tstartContainer = wrap(startContainer, 'span', {id : '_start', 'data-mce-type' : 'bookmark'});\n\t\t\t\t\t\tendContainer = wrap(endContainer, 'span', {id : '_end', 'data-mce-type' : 'bookmark'});\n\n\t\t\t\t\t\t// Split start/end\n\t\t\t\t\t\tsplitToFormatRoot(startContainer);\n\t\t\t\t\t\tsplitToFormatRoot(endContainer);\n\n\t\t\t\t\t\t// Unwrap start/end to get real elements again\n\t\t\t\t\t\tstartContainer = unwrap(TRUE);\n\t\t\t\t\t\tendContainer = unwrap();\n\t\t\t\t\t} else\n\t\t\t\t\t\tstartContainer = endContainer = splitToFormatRoot(startContainer);\n\n\t\t\t\t\t// Update range positions since they might have changed after the split operations\n\t\t\t\t\trng.startContainer = startContainer.parentNode;\n\t\t\t\t\trng.startOffset = nodeIndex(startContainer);\n\t\t\t\t\trng.endContainer = endContainer.parentNode;\n\t\t\t\t\trng.endOffset = nodeIndex(endContainer) + 1;\n\t\t\t\t}\n\n\t\t\t\t// Remove items between start/end\n\t\t\t\trangeUtils.walk(rng, function(nodes) {\n\t\t\t\t\teach(nodes, function(node) {\n\t\t\t\t\t\tprocess(node);\n\n\t\t\t\t\t\t// Remove parent span if it only contains text-decoration: underline, yet a parent node is also underlined.\n\t\t\t\t\t\tif (node.nodeType === 1 && ed.dom.getStyle(node, 'text-decoration') === 'underline' && node.parentNode && getTextDecoration(node.parentNode) === 'underline') {\n\t\t\t\t\t\t\tremoveFormat({'deep': false, 'exact': true, 'inline': 'span', 'styles': {'textDecoration' : 'underline'}}, null, node);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t};\n\n\t\t\t// Handle node\n\t\t\tif (node) {\n\t\t\t\tif (node.nodeType) {\n\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\trng.setEndAfter(node);\n\t\t\t\t\tremoveRngStyle(rng);\n\t\t\t\t} else {\n\t\t\t\t\tremoveRngStyle(node);\n\t\t\t\t}\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif (!selection.isCollapsed() || !format.inline || dom.select('td.mceSelected,th.mceSelected').length) {\n\t\t\t\tbookmark = selection.getBookmark();\n\t\t\t\tremoveRngStyle(selection.getRng(TRUE));\n\t\t\t\tselection.moveToBookmark(bookmark);\n\n\t\t\t\t// Check if start element still has formatting then we are at: \"<b>text|</b>text\" and need to move the start into the next text node\n\t\t\t\tif (format.inline && match(name, vars, selection.getStart())) {\n\t\t\t\t\tmoveStart(selection.getRng(true));\n\t\t\t\t}\n\n\t\t\t\ted.nodeChanged();\n\t\t\t} else\n\t\t\t\tperformCaretAction('remove', name, vars);\n\n\t\t\t// When you remove formatting from a table cell in WebKit (cell, not the contents of a cell) there is a rendering issue with column width\n\t\t\tif (tinymce.isWebKit) {\n\t\t\t\ted.execCommand('mceCleanup');\n\t\t\t}\n\t\t};\n\n\t\tfunction toggle(name, vars, node) {\n\t\t\tvar fmt = get(name);\n\n\t\t\tif (match(name, vars, node) && (!('toggle' in fmt[0]) || fmt[0]['toggle']))\n\t\t\t\tremove(name, vars, node);\n\t\t\telse\n\t\t\t\tapply(name, vars, node);\n\t\t};\n\n\t\tfunction matchNode(node, name, vars, similar) {\n\t\t\tvar formatList = get(name), format, i, classes;\n\n\t\t\tfunction matchItems(node, format, item_name) {\n\t\t\t\tvar key, value, items = format[item_name], i;\n\n\t\t\t\t// Custom match\n\t\t\t\tif (format.onmatch) {\n\t\t\t\t\treturn format.onmatch(node, format, item_name);\n\t\t\t\t}\n\n\t\t\t\t// Check all items\n\t\t\t\tif (items) {\n\t\t\t\t\t// Non indexed object\n\t\t\t\t\tif (items.length === undefined) {\n\t\t\t\t\t\tfor (key in items) {\n\t\t\t\t\t\t\tif (items.hasOwnProperty(key)) {\n\t\t\t\t\t\t\t\tif (item_name === 'attributes')\n\t\t\t\t\t\t\t\t\tvalue = dom.getAttrib(node, key);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\tvalue = getStyle(node, key);\n\n\t\t\t\t\t\t\t\tif (similar && !value && !format.exact)\n\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\tif ((!similar || format.exact) && !isEq(value, replaceVars(items[key], vars)))\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Only one match needed for indexed arrays\n\t\t\t\t\t\tfor (i = 0; i < items.length; i++) {\n\t\t\t\t\t\t\tif (item_name === 'attributes' ? dom.getAttrib(node, items[i]) : getStyle(node, items[i]))\n\t\t\t\t\t\t\t\treturn format;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn format;\n\t\t\t};\n\n\t\t\tif (formatList && node) {\n\t\t\t\t// Check each format in list\n\t\t\t\tfor (i = 0; i < formatList.length; i++) {\n\t\t\t\t\tformat = formatList[i];\n\n\t\t\t\t\t// Name name, attributes, styles and classes\n\t\t\t\t\tif (matchName(node, format) && matchItems(node, format, 'attributes') && matchItems(node, format, 'styles')) {\n\t\t\t\t\t\t// Match classes\n\t\t\t\t\t\tif (classes = format.classes) {\n\t\t\t\t\t\t\tfor (i = 0; i < classes.length; i++) {\n\t\t\t\t\t\t\t\tif (!dom.hasClass(node, classes[i]))\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn format;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction match(name, vars, node) {\n\t\t\tvar startNode;\n\n\t\t\tfunction matchParents(node) {\n\t\t\t\t// Find first node with similar format settings\n\t\t\t\tnode = dom.getParent(node, function(node) {\n\t\t\t\t\treturn !!matchNode(node, name, vars, true);\n\t\t\t\t});\n\n\t\t\t\t// Do an exact check on the similar format element\n\t\t\t\treturn matchNode(node, name, vars);\n\t\t\t};\n\n\t\t\t// Check specified node\n\t\t\tif (node)\n\t\t\t\treturn matchParents(node);\n\n\t\t\t// Check selected node\n\t\t\tnode = selection.getNode();\n\t\t\tif (matchParents(node))\n\t\t\t\treturn TRUE;\n\n\t\t\t// Check start node if it's different\n\t\t\tstartNode = selection.getStart();\n\t\t\tif (startNode != node) {\n\t\t\t\tif (matchParents(startNode))\n\t\t\t\t\treturn TRUE;\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\tfunction matchAll(names, vars) {\n\t\t\tvar startElement, matchedFormatNames = [], checkedMap = {}, i, ni, name;\n\n\t\t\t// Check start of selection for formats\n\t\t\tstartElement = selection.getStart();\n\t\t\tdom.getParent(startElement, function(node) {\n\t\t\t\tvar i, name;\n\n\t\t\t\tfor (i = 0; i < names.length; i++) {\n\t\t\t\t\tname = names[i];\n\n\t\t\t\t\tif (!checkedMap[name] && matchNode(node, name, vars)) {\n\t\t\t\t\t\tcheckedMap[name] = true;\n\t\t\t\t\t\tmatchedFormatNames.push(name);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn matchedFormatNames;\n\t\t};\n\n\t\tfunction canApply(name) {\n\t\t\tvar formatList = get(name), startNode, parents, i, x, selector;\n\n\t\t\tif (formatList) {\n\t\t\t\tstartNode = selection.getStart();\n\t\t\t\tparents = getParents(startNode);\n\n\t\t\t\tfor (x = formatList.length - 1; x >= 0; x--) {\n\t\t\t\t\tselector = formatList[x].selector;\n\n\t\t\t\t\t// Format is not selector based, then always return TRUE\n\t\t\t\t\tif (!selector)\n\t\t\t\t\t\treturn TRUE;\n\n\t\t\t\t\tfor (i = parents.length - 1; i >= 0; i--) {\n\t\t\t\t\t\tif (dom.is(parents[i], selector))\n\t\t\t\t\t\t\treturn TRUE;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\t// Expose to public\n\t\ttinymce.extend(this, {\n\t\t\tget : get,\n\t\t\tregister : register,\n\t\t\tapply : apply,\n\t\t\tremove : remove,\n\t\t\ttoggle : toggle,\n\t\t\tmatch : match,\n\t\t\tmatchAll : matchAll,\n\t\t\tmatchNode : matchNode,\n\t\t\tcanApply : canApply\n\t\t});\n\n\t\t// Private functions\n\n\t\tfunction matchName(node, format) {\n\t\t\t// Check for inline match\n\t\t\tif (isEq(node, format.inline))\n\t\t\t\treturn TRUE;\n\n\t\t\t// Check for block match\n\t\t\tif (isEq(node, format.block))\n\t\t\t\treturn TRUE;\n\n\t\t\t// Check for selector match\n\t\t\tif (format.selector)\n\t\t\t\treturn dom.is(node, format.selector);\n\t\t};\n\n\t\tfunction isEq(str1, str2) {\n\t\t\tstr1 = str1 || '';\n\t\t\tstr2 = str2 || '';\n\n\t\t\tstr1 = '' + (str1.nodeName || str1);\n\t\t\tstr2 = '' + (str2.nodeName || str2);\n\n\t\t\treturn str1.toLowerCase() == str2.toLowerCase();\n\t\t};\n\n\t\tfunction getStyle(node, name) {\n\t\t\tvar styleVal = dom.getStyle(node, name);\n\n\t\t\t// Force the format to hex\n\t\t\tif (name == 'color' || name == 'backgroundColor')\n\t\t\t\tstyleVal = dom.toHex(styleVal);\n\n\t\t\t// Opera will return bold as 700\n\t\t\tif (name == 'fontWeight' && styleVal == 700)\n\t\t\t\tstyleVal = 'bold';\n\n\t\t\treturn '' + styleVal;\n\t\t};\n\n\t\tfunction replaceVars(value, vars) {\n\t\t\tif (typeof(value) != \"string\")\n\t\t\t\tvalue = value(vars);\n\t\t\telse if (vars) {\n\t\t\t\tvalue = value.replace(/%(\\w+)/g, function(str, name) {\n\t\t\t\t\treturn vars[name] || str;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn value;\n\t\t};\n\n\t\tfunction isWhiteSpaceNode(node) {\n\t\t\treturn node && node.nodeType === 3 && /^([\\t \\r\\n]+|)$/.test(node.nodeValue);\n\t\t};\n\n\t\tfunction wrap(node, name, attrs) {\n\t\t\tvar wrapper = dom.create(name, attrs);\n\n\t\t\tnode.parentNode.insertBefore(wrapper, node);\n\t\t\twrapper.appendChild(node);\n\n\t\t\treturn wrapper;\n\t\t};\n\n\t\tfunction expandRng(rng, format, remove) {\n\t\t\tvar startContainer = rng.startContainer,\n\t\t\t\tstartOffset = rng.startOffset,\n\t\t\t\tendContainer = rng.endContainer,\n\t\t\t\tendOffset = rng.endOffset, sibling, lastIdx, leaf, endPoint;\n\n\t\t\t// This function walks up the tree if there is no siblings before/after the node\n\t\t\tfunction findParentContainer(start) {\n\t\t\t\tvar container, parent, child, sibling, siblingName;\n\n\t\t\t\tcontainer = parent = start ? startContainer : endContainer;\n\t\t\t\tsiblingName = start ? 'previousSibling' : 'nextSibling';\n\t\t\t\troot = dom.getRoot();\n\n\t\t\t\t// If it's a text node and the offset is inside the text\n\t\t\t\tif (container.nodeType == 3 && !isWhiteSpaceNode(container)) {\n\t\t\t\t\tif (start ? startOffset > 0 : endOffset < container.nodeValue.length) {\n\t\t\t\t\t\treturn container;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor (;;) {\n\t\t\t\t\t// Stop expanding on block elements or root depending on format\n\t\t\t\t\tif (parent == root || (!format[0].block_expand && isBlock(parent)))\n\t\t\t\t\t\treturn parent;\n\n\t\t\t\t\t// Walk left/right\n\t\t\t\t\tfor (sibling = parent[siblingName]; sibling; sibling = sibling[siblingName]) {\n\t\t\t\t\t\tif (!isBookmarkNode(sibling) && !isWhiteSpaceNode(sibling)) {\n\t\t\t\t\t\t\treturn parent;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Check if we can move up are we at root level or body level\n\t\t\t\t\tparent = parent.parentNode;\n\t\t\t\t}\n\n\t\t\t\treturn container;\n\t\t\t};\n\n\t\t\t// This function walks down the tree to find the leaf at the selection.\n\t\t\t// The offset is also returned as if node initially a leaf, the offset may be in the middle of the text node.\n\t\t\tfunction findLeaf(node, offset) {\n\t\t\t\tif (offset === undefined)\n\t\t\t\t\toffset = node.nodeType === 3 ? node.length : node.childNodes.length;\n\t\t\t\twhile (node && node.hasChildNodes()) {\n\t\t\t\t\tnode = node.childNodes[offset];\n\t\t\t\t\tif (node)\n\t\t\t\t\t\toffset = node.nodeType === 3 ? node.length : node.childNodes.length;\n\t\t\t\t}\n\t\t\t\treturn { node: node, offset: offset };\n\t\t\t}\n\n\t\t\t// If index based start position then resolve it\n\t\t\tif (startContainer.nodeType == 1 && startContainer.hasChildNodes()) {\n\t\t\t\tlastIdx = startContainer.childNodes.length - 1;\n\t\t\t\tstartContainer = startContainer.childNodes[startOffset > lastIdx ? lastIdx : startOffset];\n\n\t\t\t\tif (startContainer.nodeType == 3)\n\t\t\t\t\tstartOffset = 0;\n\t\t\t}\n\n\t\t\t// If index based end position then resolve it\n\t\t\tif (endContainer.nodeType == 1 && endContainer.hasChildNodes()) {\n\t\t\t\tlastIdx = endContainer.childNodes.length - 1;\n\t\t\t\tendContainer = endContainer.childNodes[endOffset > lastIdx ? lastIdx : endOffset - 1];\n\n\t\t\t\tif (endContainer.nodeType == 3)\n\t\t\t\t\tendOffset = endContainer.nodeValue.length;\n\t\t\t}\n\n\t\t\t// Exclude bookmark nodes if possible\n\t\t\tif (isBookmarkNode(startContainer.parentNode) || isBookmarkNode(startContainer)) {\n\t\t\t\tstartContainer = isBookmarkNode(startContainer) ? startContainer : startContainer.parentNode;\n\t\t\t\tstartContainer = startContainer.nextSibling || startContainer;\n\n\t\t\t\tif (startContainer.nodeType == 3)\n\t\t\t\t\tstartOffset = 0;\n\t\t\t}\n\n\t\t\tif (isBookmarkNode(endContainer.parentNode) || isBookmarkNode(endContainer)) {\n\t\t\t\tendContainer = isBookmarkNode(endContainer) ? endContainer : endContainer.parentNode;\n\t\t\t\tendContainer = endContainer.previousSibling || endContainer;\n\n\t\t\t\tif (endContainer.nodeType == 3)\n\t\t\t\t\tendOffset = endContainer.length;\n\t\t\t}\n\n\t\t\tif (format[0].inline) {\n\t\t\t\tif (rng.collapsed) {\n\t\t\t\t\tfunction findWordEndPoint(container, offset, start) {\n\t\t\t\t\t\tvar walker, node, pos, lastTextNode;\n\n\t\t\t\t\t\tfunction findSpace(node, offset) {\n\t\t\t\t\t\t\tvar pos, pos2, str = node.nodeValue;\n\n\t\t\t\t\t\t\tif (typeof(offset) == \"undefined\") {\n\t\t\t\t\t\t\t\toffset = start ? str.length : 0;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (start) {\n\t\t\t\t\t\t\t\tpos = str.lastIndexOf(' ', offset);\n\t\t\t\t\t\t\t\tpos2 = str.lastIndexOf('\\u00a0', offset);\n\t\t\t\t\t\t\t\tpos = pos > pos2 ? pos : pos2;\n\n\t\t\t\t\t\t\t\t// Include the space on remove to avoid tag soup\n\t\t\t\t\t\t\t\tif (pos !== -1 && !remove) {\n\t\t\t\t\t\t\t\t\tpos++;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tpos = str.indexOf(' ', offset);\n\t\t\t\t\t\t\t\tpos2 = str.indexOf('\\u00a0', offset);\n\t\t\t\t\t\t\t\tpos = pos !== -1 && (pos2 === -1 || pos < pos2) ? pos : pos2;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn pos;\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tif (container.nodeType === 3) {\n\t\t\t\t\t\t\tpos = findSpace(container, offset);\n\n\t\t\t\t\t\t\tif (pos !== -1) {\n\t\t\t\t\t\t\t\treturn {container : container, offset : pos};\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tlastTextNode = container;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Walk the nodes inside the block\n\t\t\t\t\t\twalker = new TreeWalker(container, dom.getParent(container, isBlock) || ed.getBody());\n\t\t\t\t\t\twhile (node = walker[start ? 'prev' : 'next']()) {\n\t\t\t\t\t\t\tif (node.nodeType === 3) {\n\t\t\t\t\t\t\t\tlastTextNode = node;\n\t\t\t\t\t\t\t\tpos = findSpace(node);\n\n\t\t\t\t\t\t\t\tif (pos !== -1) {\n\t\t\t\t\t\t\t\t\treturn {container : node, offset : pos};\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else if (isBlock(node)) {\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (lastTextNode) {\n\t\t\t\t\t\t\tif (start) {\n\t\t\t\t\t\t\t\toffset = 0;\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\toffset = lastTextNode.length;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn {container: lastTextNode, offset: offset};\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Expand left to closest word boundery\n\t\t\t\t\tendPoint = findWordEndPoint(startContainer, startOffset, true);\n\t\t\t\t\tif (endPoint) {\n\t\t\t\t\t\tstartContainer = endPoint.container;\n\t\t\t\t\t\tstartOffset = endPoint.offset;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Expand right to closest word boundery\n\t\t\t\t\tendPoint = findWordEndPoint(endContainer, endOffset);\n\t\t\t\t\tif (endPoint) {\n\t\t\t\t\t\tendContainer = endPoint.container;\n\t\t\t\t\t\tendOffset = endPoint.offset;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Avoid applying formatting to a trailing space.\n\t\t\t\tleaf = findLeaf(endContainer, endOffset);\n\t\t\t\tif (leaf.node) {\n\t\t\t\t\twhile (leaf.node && leaf.offset === 0 && leaf.node.previousSibling)\n\t\t\t\t\t\tleaf = findLeaf(leaf.node.previousSibling);\n\n\t\t\t\t\tif (leaf.node && leaf.offset > 0 && leaf.node.nodeType === 3 &&\n\t\t\t\t\t\t\tleaf.node.nodeValue.charAt(leaf.offset - 1) === ' ') {\n\n\t\t\t\t\t\tif (leaf.offset > 1) {\n\t\t\t\t\t\t\tendContainer = leaf.node;\n\t\t\t\t\t\t\tendContainer.splitText(leaf.offset - 1);\n\t\t\t\t\t\t} else if (leaf.node.previousSibling) {\n\t\t\t\t\t\t\t// TODO: Figure out why this is in here\n\t\t\t\t\t\t\t//endContainer = leaf.node.previousSibling;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Move start/end point up the tree if the leaves are sharp and if we are in different containers\n\t\t\t// Example * becomes !: !<p><b><i>*text</i><i>text*</i></b></p>!\n\t\t\t// This will reduce the number of wrapper elements that needs to be created\n\t\t\t// Move start point up the tree\n\t\t\tif (format[0].inline || format[0].block_expand) {\n\t\t\t\tif (!format[0].inline || (startContainer.nodeType != 3 || startOffset === 0)) {\n\t\t\t\t\tstartContainer = findParentContainer(true);\n\t\t\t\t}\n\n\t\t\t\tif (!format[0].inline || (endContainer.nodeType != 3 || endOffset === endContainer.nodeValue.length)) {\n\t\t\t\t\tendContainer = findParentContainer();\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Expand start/end container to matching selector\n\t\t\tif (format[0].selector && format[0].expand !== FALSE && !format[0].inline) {\n\t\t\t\tfunction findSelectorEndPoint(container, sibling_name) {\n\t\t\t\t\tvar parents, i, y, curFormat;\n\n\t\t\t\t\tif (container.nodeType == 3 && container.nodeValue.length == 0 && container[sibling_name])\n\t\t\t\t\t\tcontainer = container[sibling_name];\n\n\t\t\t\t\tparents = getParents(container);\n\t\t\t\t\tfor (i = 0; i < parents.length; i++) {\n\t\t\t\t\t\tfor (y = 0; y < format.length; y++) {\n\t\t\t\t\t\t\tcurFormat = format[y];\n\n\t\t\t\t\t\t\t// If collapsed state is set then skip formats that doesn't match that\n\t\t\t\t\t\t\tif (\"collapsed\" in curFormat && curFormat.collapsed !== rng.collapsed)\n\t\t\t\t\t\t\t\tcontinue;\n\n\t\t\t\t\t\t\tif (dom.is(parents[i], curFormat.selector))\n\t\t\t\t\t\t\t\treturn parents[i];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn container;\n\t\t\t\t};\n\n\t\t\t\t// Find new startContainer/endContainer if there is better one\n\t\t\t\tstartContainer = findSelectorEndPoint(startContainer, 'previousSibling');\n\t\t\t\tendContainer = findSelectorEndPoint(endContainer, 'nextSibling');\n\t\t\t}\n\n\t\t\t// Expand start/end container to matching block element or text node\n\t\t\tif (format[0].block || format[0].selector) {\n\t\t\t\tfunction findBlockEndPoint(container, sibling_name, sibling_name2) {\n\t\t\t\t\tvar node;\n\n\t\t\t\t\t// Expand to block of similar type\n\t\t\t\t\tif (!format[0].wrapper)\n\t\t\t\t\t\tnode = dom.getParent(container, format[0].block);\n\n\t\t\t\t\t// Expand to first wrappable block element or any block element\n\t\t\t\t\tif (!node)\n\t\t\t\t\t\tnode = dom.getParent(container.nodeType == 3 ? container.parentNode : container, isBlock);\n\n\t\t\t\t\t// Exclude inner lists from wrapping\n\t\t\t\t\tif (node && format[0].wrapper)\n\t\t\t\t\t\tnode = getParents(node, 'ul,ol').reverse()[0] || node;\n\n\t\t\t\t\t// Didn't find a block element look for first/last wrappable element\n\t\t\t\t\tif (!node) {\n\t\t\t\t\t\tnode = container;\n\n\t\t\t\t\t\twhile (node[sibling_name] && !isBlock(node[sibling_name])) {\n\t\t\t\t\t\t\tnode = node[sibling_name];\n\n\t\t\t\t\t\t\t// Break on BR but include it will be removed later on\n\t\t\t\t\t\t\t// we can't remove it now since we need to check if it can be wrapped\n\t\t\t\t\t\t\tif (isEq(node, 'br'))\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn node || container;\n\t\t\t\t};\n\n\t\t\t\t// Find new startContainer/endContainer if there is better one\n\t\t\t\tstartContainer = findBlockEndPoint(startContainer, 'previousSibling');\n\t\t\t\tendContainer = findBlockEndPoint(endContainer, 'nextSibling');\n\n\t\t\t\t// Non block element then try to expand up the leaf\n\t\t\t\tif (format[0].block) {\n\t\t\t\t\tif (!isBlock(startContainer))\n\t\t\t\t\t\tstartContainer = findParentContainer(true);\n\n\t\t\t\t\tif (!isBlock(endContainer))\n\t\t\t\t\t\tendContainer = findParentContainer();\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Setup index for startContainer\n\t\t\tif (startContainer.nodeType == 1) {\n\t\t\t\tstartOffset = nodeIndex(startContainer);\n\t\t\t\tstartContainer = startContainer.parentNode;\n\t\t\t}\n\n\t\t\t// Setup index for endContainer\n\t\t\tif (endContainer.nodeType == 1) {\n\t\t\t\tendOffset = nodeIndex(endContainer) + 1;\n\t\t\t\tendContainer = endContainer.parentNode;\n\t\t\t}\n\n\t\t\t// Return new range like object\n\t\t\treturn {\n\t\t\t\tstartContainer : startContainer,\n\t\t\t\tstartOffset : startOffset,\n\t\t\t\tendContainer : endContainer,\n\t\t\t\tendOffset : endOffset\n\t\t\t};\n\t\t}\n\n\t\tfunction removeFormat(format, vars, node, compare_node) {\n\t\t\tvar i, attrs, stylesModified;\n\n\t\t\t// Check if node matches format\n\t\t\tif (!matchName(node, format))\n\t\t\t\treturn FALSE;\n\n\t\t\t// Should we compare with format attribs and styles\n\t\t\tif (format.remove != 'all') {\n\t\t\t\t// Remove styles\n\t\t\t\teach(format.styles, function(value, name) {\n\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\t// Indexed array\n\t\t\t\t\tif (typeof(name) === 'number') {\n\t\t\t\t\t\tname = value;\n\t\t\t\t\t\tcompare_node = 0;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!compare_node || isEq(getStyle(compare_node, name), value))\n\t\t\t\t\t\tdom.setStyle(node, name, '');\n\n\t\t\t\t\tstylesModified = 1;\n\t\t\t\t});\n\n\t\t\t\t// Remove style attribute if it's empty\n\t\t\t\tif (stylesModified && dom.getAttrib(node, 'style') == '') {\n\t\t\t\t\tnode.removeAttribute('style');\n\t\t\t\t\tnode.removeAttribute('data-mce-style');\n\t\t\t\t}\n\n\t\t\t\t// Remove attributes\n\t\t\t\teach(format.attributes, function(value, name) {\n\t\t\t\t\tvar valueOut;\n\n\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\t// Indexed array\n\t\t\t\t\tif (typeof(name) === 'number') {\n\t\t\t\t\t\tname = value;\n\t\t\t\t\t\tcompare_node = 0;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!compare_node || isEq(dom.getAttrib(compare_node, name), value)) {\n\t\t\t\t\t\t// Keep internal classes\n\t\t\t\t\t\tif (name == 'class') {\n\t\t\t\t\t\t\tvalue = dom.getAttrib(node, name);\n\t\t\t\t\t\t\tif (value) {\n\t\t\t\t\t\t\t\t// Build new class value where everything is removed except the internal prefixed classes\n\t\t\t\t\t\t\t\tvalueOut = '';\n\t\t\t\t\t\t\t\teach(value.split(/\\s+/), function(cls) {\n\t\t\t\t\t\t\t\t\tif (/mce\\w+/.test(cls))\n\t\t\t\t\t\t\t\t\t\tvalueOut += (valueOut ? ' ' : '') + cls;\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\t// We got some internal classes left\n\t\t\t\t\t\t\t\tif (valueOut) {\n\t\t\t\t\t\t\t\t\tdom.setAttrib(node, name, valueOut);\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// IE6 has a bug where the attribute doesn't get removed correctly\n\t\t\t\t\t\tif (name == \"class\")\n\t\t\t\t\t\t\tnode.removeAttribute('className');\n\n\t\t\t\t\t\t// Remove mce prefixed attributes\n\t\t\t\t\t\tif (MCE_ATTR_RE.test(name))\n\t\t\t\t\t\t\tnode.removeAttribute('data-mce-' + name);\n\n\t\t\t\t\t\tnode.removeAttribute(name);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// Remove classes\n\t\t\t\teach(format.classes, function(value) {\n\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\tif (!compare_node || dom.hasClass(compare_node, value))\n\t\t\t\t\t\tdom.removeClass(node, value);\n\t\t\t\t});\n\n\t\t\t\t// Check for non internal attributes\n\t\t\t\tattrs = dom.getAttribs(node);\n\t\t\t\tfor (i = 0; i < attrs.length; i++) {\n\t\t\t\t\tif (attrs[i].nodeName.indexOf('_') !== 0)\n\t\t\t\t\t\treturn FALSE;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Remove the inline child if it's empty for example <b> or <span>\n\t\t\tif (format.remove != 'none') {\n\t\t\t\tremoveNode(node, format);\n\t\t\t\treturn TRUE;\n\t\t\t}\n\t\t};\n\n\t\tfunction removeNode(node, format) {\n\t\t\tvar parentNode = node.parentNode, rootBlockElm;\n\n\t\t\tif (format.block) {\n\t\t\t\tif (!forcedRootBlock) {\n\t\t\t\t\tfunction find(node, next, inc) {\n\t\t\t\t\t\tnode = getNonWhiteSpaceSibling(node, next, inc);\n\n\t\t\t\t\t\treturn !node || (node.nodeName == 'BR' || isBlock(node));\n\t\t\t\t\t};\n\n\t\t\t\t\t// Append BR elements if needed before we remove the block\n\t\t\t\t\tif (isBlock(node) && !isBlock(parentNode)) {\n\t\t\t\t\t\tif (!find(node, FALSE) && !find(node.firstChild, TRUE, 1))\n\t\t\t\t\t\t\tnode.insertBefore(dom.create('br'), node.firstChild);\n\n\t\t\t\t\t\tif (!find(node, TRUE) && !find(node.lastChild, FALSE, 1))\n\t\t\t\t\t\t\tnode.appendChild(dom.create('br'));\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\t// Wrap the block in a forcedRootBlock if we are at the root of document\n\t\t\t\t\tif (parentNode == dom.getRoot()) {\n\t\t\t\t\t\tif (!format.list_block || !isEq(node, format.list_block)) {\n\t\t\t\t\t\t\teach(tinymce.grep(node.childNodes), function(node) {\n\t\t\t\t\t\t\t\tif (isValid(forcedRootBlock, node.nodeName.toLowerCase())) {\n\t\t\t\t\t\t\t\t\tif (!rootBlockElm)\n\t\t\t\t\t\t\t\t\t\trootBlockElm = wrap(node, forcedRootBlock);\n\t\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\t\trootBlockElm.appendChild(node);\n\t\t\t\t\t\t\t\t} else\n\t\t\t\t\t\t\t\t\trootBlockElm = 0;\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Never remove nodes that isn't the specified inline element if a selector is specified too\n\t\t\tif (format.selector && format.inline && !isEq(format.inline, node))\n\t\t\t\treturn;\n\n\t\t\tdom.remove(node, 1);\n\t\t};\n\n\t\tfunction getNonWhiteSpaceSibling(node, next, inc) {\n\t\t\tif (node) {\n\t\t\t\tnext = next ? 'nextSibling' : 'previousSibling';\n\n\t\t\t\tfor (node = inc ? node : node[next]; node; node = node[next]) {\n\t\t\t\t\tif (node.nodeType == 1 || !isWhiteSpaceNode(node))\n\t\t\t\t\t\treturn node;\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction isBookmarkNode(node) {\n\t\t\treturn node && node.nodeType == 1 && node.getAttribute('data-mce-type') == 'bookmark';\n\t\t};\n\n\t\tfunction mergeSiblings(prev, next) {\n\t\t\tvar marker, sibling, tmpSibling;\n\n\t\t\tfunction compareElements(node1, node2) {\n\t\t\t\t// Not the same name\n\t\t\t\tif (node1.nodeName != node2.nodeName)\n\t\t\t\t\treturn FALSE;\n\n\t\t\t\tfunction getAttribs(node) {\n\t\t\t\t\tvar attribs = {};\n\n\t\t\t\t\teach(dom.getAttribs(node), function(attr) {\n\t\t\t\t\t\tvar name = attr.nodeName.toLowerCase();\n\n\t\t\t\t\t\t// Don't compare internal attributes or style\n\t\t\t\t\t\tif (name.indexOf('_') !== 0 && name !== 'style')\n\t\t\t\t\t\t\tattribs[name] = dom.getAttrib(node, name);\n\t\t\t\t\t});\n\n\t\t\t\t\treturn attribs;\n\t\t\t\t};\n\n\t\t\t\tfunction compareObjects(obj1, obj2) {\n\t\t\t\t\tvar value, name;\n\n\t\t\t\t\tfor (name in obj1) {\n\t\t\t\t\t\t// Obj1 has item obj2 doesn't have\n\t\t\t\t\t\tif (obj1.hasOwnProperty(name)) {\n\t\t\t\t\t\t\tvalue = obj2[name];\n\n\t\t\t\t\t\t\t// Obj2 doesn't have obj1 item\n\t\t\t\t\t\t\tif (value === undefined)\n\t\t\t\t\t\t\t\treturn FALSE;\n\n\t\t\t\t\t\t\t// Obj2 item has a different value\n\t\t\t\t\t\t\tif (obj1[name] != value)\n\t\t\t\t\t\t\t\treturn FALSE;\n\n\t\t\t\t\t\t\t// Delete similar value\n\t\t\t\t\t\t\tdelete obj2[name];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Check if obj 2 has something obj 1 doesn't have\n\t\t\t\t\tfor (name in obj2) {\n\t\t\t\t\t\t// Obj2 has item obj1 doesn't have\n\t\t\t\t\t\tif (obj2.hasOwnProperty(name))\n\t\t\t\t\t\t\treturn FALSE;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn TRUE;\n\t\t\t\t};\n\n\t\t\t\t// Attribs are not the same\n\t\t\t\tif (!compareObjects(getAttribs(node1), getAttribs(node2)))\n\t\t\t\t\treturn FALSE;\n\n\t\t\t\t// Styles are not the same\n\t\t\t\tif (!compareObjects(dom.parseStyle(dom.getAttrib(node1, 'style')), dom.parseStyle(dom.getAttrib(node2, 'style'))))\n\t\t\t\t\treturn FALSE;\n\n\t\t\t\treturn TRUE;\n\t\t\t};\n\n\t\t\t// Check if next/prev exists and that they are elements\n\t\t\tif (prev && next) {\n\t\t\t\tfunction findElementSibling(node, sibling_name) {\n\t\t\t\t\tfor (sibling = node; sibling; sibling = sibling[sibling_name]) {\n\t\t\t\t\t\tif (sibling.nodeType == 3 && sibling.nodeValue.length !== 0)\n\t\t\t\t\t\t\treturn node;\n\n\t\t\t\t\t\tif (sibling.nodeType == 1 && !isBookmarkNode(sibling))\n\t\t\t\t\t\t\treturn sibling;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn node;\n\t\t\t\t};\n\n\t\t\t\t// If previous sibling is empty then jump over it\n\t\t\t\tprev = findElementSibling(prev, 'previousSibling');\n\t\t\t\tnext = findElementSibling(next, 'nextSibling');\n\n\t\t\t\t// Compare next and previous nodes\n\t\t\t\tif (compareElements(prev, next)) {\n\t\t\t\t\t// Append nodes between\n\t\t\t\t\tfor (sibling = prev.nextSibling; sibling && sibling != next;) {\n\t\t\t\t\t\ttmpSibling = sibling;\n\t\t\t\t\t\tsibling = sibling.nextSibling;\n\t\t\t\t\t\tprev.appendChild(tmpSibling);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove next node\n\t\t\t\t\tdom.remove(next);\n\n\t\t\t\t\t// Move children into prev node\n\t\t\t\t\teach(tinymce.grep(next.childNodes), function(node) {\n\t\t\t\t\t\tprev.appendChild(node);\n\t\t\t\t\t});\n\n\t\t\t\t\treturn prev;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn next;\n\t\t};\n\n\t\tfunction isTextBlock(name) {\n\t\t\treturn /^(h[1-6]|p|div|pre|address|dl|dt|dd)$/.test(name);\n\t\t};\n\n\t\tfunction getContainer(rng, start) {\n\t\t\tvar container, offset, lastIdx, walker;\n\n\t\t\tcontainer = rng[start ? 'startContainer' : 'endContainer'];\n\t\t\toffset = rng[start ? 'startOffset' : 'endOffset'];\n\n\t\t\tif (container.nodeType == 1) {\n\t\t\t\tlastIdx = container.childNodes.length - 1;\n\n\t\t\t\tif (!start && offset)\n\t\t\t\t\toffset--;\n\n\t\t\t\tcontainer = container.childNodes[offset > lastIdx ? lastIdx : offset];\n\t\t\t}\n\n\t\t\t// If start text node is excluded then walk to the next node\n\t\t\tif (container.nodeType === 3 && start && offset >= container.nodeValue.length) {\n\t\t\t\tcontainer = new TreeWalker(container, ed.getBody()).next() || container;\n\t\t\t}\n\n\t\t\t// If end text node is excluded then walk to the previous node\n\t\t\tif (container.nodeType === 3 && !start && offset == 0) {\n\t\t\t\tcontainer = new TreeWalker(container, ed.getBody()).prev() || container;\n\t\t\t}\n\n\t\t\treturn container;\n\t\t};\n\n\t\tfunction performCaretAction(type, name, vars) {\n\t\t\tvar invisibleChar, caretContainerId = '_mce_caret', debug = ed.settings.caret_debug;\n\n\t\t\t// Setup invisible character use zero width space on Gecko since it doesn't change the heigt of the container\n\t\t\tinvisibleChar = tinymce.isGecko ? '\\u200B' : INVISIBLE_CHAR;\n\n\t\t\t// Creates a caret container bogus element\n\t\t\tfunction createCaretContainer(fill) {\n\t\t\t\tvar caretContainer = dom.create('span', {id: caretContainerId, 'data-mce-bogus': true, style: debug ? 'color:red' : ''});\n\n\t\t\t\tif (fill) {\n\t\t\t\t\tcaretContainer.appendChild(ed.getDoc().createTextNode(invisibleChar));\n\t\t\t\t}\n\n\t\t\t\treturn caretContainer;\n\t\t\t};\n\n\t\t\tfunction isCaretContainerEmpty(node, nodes) {\n\t\t\t\twhile (node) {\n\t\t\t\t\tif ((node.nodeType === 3 && node.nodeValue !== invisibleChar) || node.childNodes.length > 1) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Collect nodes\n\t\t\t\t\tif (nodes && node.nodeType === 1) {\n\t\t\t\t\t\tnodes.push(node);\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = node.firstChild;\n\t\t\t\t}\n\n\t\t\t\treturn true;\n\t\t\t};\n\n\t\t\t// Returns any parent caret container element\n\t\t\tfunction getParentCaretContainer(node) {\n\t\t\t\twhile (node) {\n\t\t\t\t\tif (node.id === caretContainerId) {\n\t\t\t\t\t\treturn node;\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Finds the first text node in the specified node\n\t\t\tfunction findFirstTextNode(node) {\n\t\t\t\tvar walker;\n\n\t\t\t\tif (node) {\n\t\t\t\t\twalker = new TreeWalker(node, node);\n\n\t\t\t\t\tfor (node = walker.current(); node; node = walker.next()) {\n\t\t\t\t\t\tif (node.nodeType === 3) {\n\t\t\t\t\t\t\treturn node;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Removes the caret container for the specified node or all on the current document\n\t\t\tfunction removeCaretContainer(node, move_caret) {\n\t\t\t\tvar child, rng;\n\n\t\t\t\tif (!node) {\n\t\t\t\t\tnode = getParentCaretContainer(selection.getStart());\n\n\t\t\t\t\tif (!node) {\n\t\t\t\t\t\twhile (node = dom.get(caretContainerId)) {\n\t\t\t\t\t\t\tremoveCaretContainer(node, false);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\trng = selection.getRng(true);\n\n\t\t\t\t\tif (isCaretContainerEmpty(node)) {\n\t\t\t\t\t\tif (move_caret !== false) {\n\t\t\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\t\t\trng.setEndBefore(node);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tdom.remove(node);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tchild = findFirstTextNode(node);\n\t\t\t\t\t\tchild = child.deleteData(0, 1);\n\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t}\n\n\t\t\t\t\tselection.setRng(rng);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Applies formatting to the caret position\n\t\t\tfunction applyCaretFormat() {\n\t\t\t\tvar rng, caretContainer, textNode, offset, bookmark, container, text;\n\n\t\t\t\trng = selection.getRng(true);\n\t\t\t\toffset = rng.startOffset;\n\t\t\t\tcontainer = rng.startContainer;\n\t\t\t\ttext = container.nodeValue;\n\n\t\t\t\tcaretContainer = getParentCaretContainer(selection.getStart());\n\t\t\t\tif (caretContainer) {\n\t\t\t\t\ttextNode = findFirstTextNode(caretContainer);\n\t\t\t\t}\n\n\t\t\t\t// Expand to word is caret is in the middle of a text node and the char before/after is a alpha numeric character\n\t\t\t\tif (text && offset > 0 && offset < text.length && /\\w/.test(text.charAt(offset)) && /\\w/.test(text.charAt(offset - 1))) {\n\t\t\t\t\t// Get bookmark of caret position\n\t\t\t\t\tbookmark = selection.getBookmark();\n\n\t\t\t\t\t// Collapse bookmark range (WebKit)\n\t\t\t\t\trng.collapse(true);\n\n\t\t\t\t\t// Expand the range to the closest word and split it at those points\n\t\t\t\t\trng = expandRng(rng, get(name));\n\t\t\t\t\trng = rangeUtils.split(rng);\n\n\t\t\t\t\t// Apply the format to the range\n\t\t\t\t\tapply(name, vars, rng);\n\n\t\t\t\t\t// Move selection back to caret position\n\t\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t\t} else {\n\t\t\t\t\tif (!caretContainer || textNode.nodeValue !== invisibleChar) {\n\t\t\t\t\t\tcaretContainer = createCaretContainer(true);\n\t\t\t\t\t\ttextNode = caretContainer.firstChild;\n\n\t\t\t\t\t\trng.insertNode(caretContainer);\n\t\t\t\t\t\toffset = 1;\n\n\t\t\t\t\t\tapply(name, vars, caretContainer);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tapply(name, vars, caretContainer);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Move selection to text node\n\t\t\t\t\tselection.setCursorLocation(textNode, offset);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tfunction removeCaretFormat() {\n\t\t\t\tvar rng = selection.getRng(true), container, offset, bookmark,\n\t\t\t\t\thasContentAfter, node, formatNode, parents = [], i, caretContainer;\n\n\t\t\t\tcontainer = rng.startContainer;\n\t\t\t\toffset = rng.startOffset;\n\t\t\t\tnode = container;\n\n\t\t\t\tif (container.nodeType == 3) {\n\t\t\t\t\tif (offset != container.nodeValue.length || container.nodeValue === invisibleChar) {\n\t\t\t\t\t\thasContentAfter = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t}\n\n\t\t\t\twhile (node) {\n\t\t\t\t\tif (matchNode(node, name, vars)) {\n\t\t\t\t\t\tformatNode = node;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (node.nextSibling) {\n\t\t\t\t\t\thasContentAfter = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tparents.push(node);\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t}\n\n\t\t\t\t// Node doesn't have the specified format\n\t\t\t\tif (!formatNode) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Is there contents after the caret then remove the format on the element\n\t\t\t\tif (hasContentAfter) {\n\t\t\t\t\t// Get bookmark of caret position\n\t\t\t\t\tbookmark = selection.getBookmark();\n\n\t\t\t\t\t// Collapse bookmark range (WebKit)\n\t\t\t\t\trng.collapse(true);\n\n\t\t\t\t\t// Expand the range to the closest word and split it at those points\n\t\t\t\t\trng = expandRng(rng, get(name), true);\n\t\t\t\t\trng = rangeUtils.split(rng);\n\n\t\t\t\t\t// Remove the format from the range\n\t\t\t\t\tremove(name, vars, rng);\n\n\t\t\t\t\t// Move selection back to caret position\n\t\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t\t} else {\n\t\t\t\t\tcaretContainer = createCaretContainer();\n\n\t\t\t\t\tnode = caretContainer;\n\t\t\t\t\tfor (i = parents.length - 1; i >= 0; i--) {\n\t\t\t\t\t\tnode.appendChild(parents[i].cloneNode(false));\n\t\t\t\t\t\tnode = node.firstChild;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Insert invisible character into inner most format element\n\t\t\t\t\tnode.appendChild(dom.doc.createTextNode(invisibleChar));\n\t\t\t\t\tnode = node.firstChild;\n\n\t\t\t\t\t// Insert caret container after the formatted node\n\t\t\t\t\tdom.insertAfter(caretContainer, formatNode);\n\n\t\t\t\t\t// Move selection to text node\n\t\t\t\t\tselection.setCursorLocation(node, 1);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Mark current caret container elements as bogus when getting the contents so we don't end up with empty elements\n\t\t\ted.onBeforeGetContent.addToTop(function() {\n\t\t\t\tvar nodes = [], i;\n\n\t\t\t\tif (isCaretContainerEmpty(getParentCaretContainer(selection.getStart()), nodes)) {\n\t\t\t\t\t// Mark children\n\t\t\t\t\ti = nodes.length;\n\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\tdom.setAttrib(nodes[i], 'data-mce-bogus', '1');\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Remove caret container on mouse up and on key up\n\t\t\ttinymce.each('onMouseUp onKeyUp'.split(' '), function(name) {\n\t\t\t\ted[name].addToTop(function() {\n\t\t\t\t\tremoveCaretContainer();\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// Remove caret container on keydown and it's a backspace, enter or left/right arrow keys\n\t\t\ted.onKeyDown.addToTop(function(ed, e) {\n\t\t\t\tvar keyCode = e.keyCode;\n\n\t\t\t\tif (keyCode == 8 || keyCode == 37 || keyCode == 39) {\n\t\t\t\t\tremoveCaretContainer(getParentCaretContainer(selection.getStart()));\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Do apply or remove caret format\n\t\t\tif (type == \"apply\") {\n\t\t\t\tapplyCaretFormat();\n\t\t\t} else {\n\t\t\t\tremoveCaretFormat();\n\t\t\t}\n\t\t};\n\t};\n})(tinymce);\n\ntinymce.onAddEditor.add(function(tinymce, ed) {\n\tvar filters, fontSizes, dom, settings = ed.settings;\n\n\tif (settings.inline_styles) {\n\t\tfontSizes = tinymce.explode(settings.font_size_legacy_values);\n\n\t\tfunction replaceWithSpan(node, styles) {\n\t\t\ttinymce.each(styles, function(value, name) {\n\t\t\t\tif (value)\n\t\t\t\t\tdom.setStyle(node, name, value);\n\t\t\t});\n\n\t\t\tdom.rename(node, 'span');\n\t\t};\n\n\t\tfilters = {\n\t\t\tfont : function(dom, node) {\n\t\t\t\treplaceWithSpan(node, {\n\t\t\t\t\tbackgroundColor : node.style.backgroundColor,\n\t\t\t\t\tcolor : node.color,\n\t\t\t\t\tfontFamily : node.face,\n\t\t\t\t\tfontSize : fontSizes[parseInt(node.size) - 1]\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tu : function(dom, node) {\n\t\t\t\treplaceWithSpan(node, {\n\t\t\t\t\ttextDecoration : 'underline'\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tstrike : function(dom, node) {\n\t\t\t\treplaceWithSpan(node, {\n\t\t\t\t\ttextDecoration : 'line-through'\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\tfunction convert(editor, params) {\n\t\t\tdom = editor.dom;\n\n\t\t\tif (settings.convert_fonts_to_spans) {\n\t\t\t\ttinymce.each(dom.select('font,u,strike', params.node), function(node) {\n\t\t\t\t\tfilters[node.nodeName.toLowerCase()](ed.dom, node);\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\ted.onPreProcess.add(convert);\n\t\ted.onSetContent.add(convert);\n\n\t\ted.onInit.add(function() {\n\t\t\ted.selection.onSetContent.add(convert);\n\t\t});\n\t}\n});\n\n","Magento_Tinymce3/tiny_mce/tiny_mce.js":"(function(d){var a=/^\\s*|\\s*$/g,e,c=\"B\".replace(/A(.)|B/,\"$1\")===\"$1\";var b={majorVersion:\"3\",minorVersion:\"4.7\",releaseDate:\"2011-11-03\",_init:function(){var s=this,q=document,o=navigator,g=o.userAgent,m,f,l,k,j,r;s.isOpera=d.opera&&opera.buildNumber;s.isWebKit=/WebKit/.test(g);s.isIE=!s.isWebKit&&!s.isOpera&&(/MSIE/gi).test(g)&&(/Explorer/gi).test(o.appName);s.isIE6=s.isIE&&/MSIE [56]/.test(g);s.isIE7=s.isIE&&/MSIE [7]/.test(g);s.isIE8=s.isIE&&/MSIE [8]/.test(g);s.isIE9=s.isIE&&/MSIE [9]/.test(g);s.isGecko=!s.isWebKit&&/Gecko/.test(g);s.isMac=g.indexOf(\"Mac\")!=-1;s.isAir=/adobeair/i.test(g);s.isIDevice=/(iPad|iPhone)/.test(g);s.isIOS5=s.isIDevice&&g.match(/AppleWebKit\\/(\\d*)/)[1]>=534;if(d.tinyMCEPreInit){s.suffix=tinyMCEPreInit.suffix;s.baseURL=tinyMCEPreInit.base;s.query=tinyMCEPreInit.query;return}s.suffix=\"\";f=q.getElementsByTagName(\"base\");for(m=0;m<f.length;m++){if(r=f[m].href){if(/^https?:\\/\\/[^\\/]+$/.test(r)){r+=\"/\"}k=r?r.match(/.*\\//)[0]:\"\"}}function h(i){if(i.src&&/tiny_mce(|_gzip|_jquery|_prototype|_full)(_dev|_src)?.js/.test(i.src)){if(/_(src|dev)\\.js/g.test(i.src)){s.suffix=\"_src\"}if((j=i.src.indexOf(\"?\"))!=-1){s.query=i.src.substring(j+1)}s.baseURL=i.src.substring(0,i.src.lastIndexOf(\"/\"));if(k&&s.baseURL.indexOf(\"://\")==-1&&s.baseURL.indexOf(\"/\")!==0){s.baseURL=k+s.baseURL}return s.baseURL}return null}f=q.getElementsByTagName(\"script\");for(m=0;m<f.length;m++){if(h(f[m])){return}}l=q.getElementsByTagName(\"head\")[0];if(l){f=l.getElementsByTagName(\"script\");for(m=0;m<f.length;m++){if(h(f[m])){return}}}return},is:function(g,f){if(!f){return g!==e}if(f==\"array\"&&(g.hasOwnProperty&&g instanceof Array)){return true}return typeof(g)==f},makeMap:function(f,j,h){var g;f=f||[];j=j||\",\";if(typeof(f)==\"string\"){f=f.split(j)}h=h||{};g=f.length;while(g--){h[f[g]]={}}return h},each:function(i,f,h){var j,g;if(!i){return 0}h=h||i;if(i.length!==e){for(j=0,g=i.length;j<g;j++){if(f.call(h,i[j],j,i)===false){return 0}}}else{for(j in i){if(i.hasOwnProperty(j)){if(f.call(h,i[j],j,i)===false){return 0}}}}return 1},map:function(g,h){var i=[];b.each(g,function(f){i.push(h(f))});return i},grep:function(g,h){var i=[];b.each(g,function(f){if(!h||h(f)){i.push(f)}});return i},inArray:function(g,h){var j,f;if(g){for(j=0,f=g.length;j<f;j++){if(g[j]===h){return j}}}return -1},extend:function(k,j){var h,g,f=arguments;for(h=1,g=f.length;h<g;h++){j=f[h];b.each(j,function(i,l){if(i!==e){k[l]=i}})}return k},trim:function(f){return(f?\"\"+f:\"\").replace(a,\"\")},create:function(o,f,j){var n=this,g,i,k,l,h,m=0;o=/^((static) )?([\\w.]+)(:([\\w.]+))?/.exec(o);k=o[3].match(/(^|\\.)(\\w+)$/i)[2];i=n.createNS(o[3].replace(/\\.\\w+$/,\"\"),j);if(i[k]){return}if(o[2]==\"static\"){i[k]=f;if(this.onCreate){this.onCreate(o[2],o[3],i[k])}return}if(!f[k]){f[k]=function(){};m=1}i[k]=f[k];n.extend(i[k].prototype,f);if(o[5]){g=n.resolve(o[5]).prototype;l=o[5].match(/\\.(\\w+)$/i)[1];h=i[k];if(m){i[k]=function(){return g[l].apply(this,arguments)}}else{i[k]=function(){this.parent=g[l];return h.apply(this,arguments)}}i[k].prototype[k]=i[k];n.each(g,function(p,q){i[k].prototype[q]=g[q]});n.each(f,function(p,q){if(g[q]){i[k].prototype[q]=function(){this.parent=g[q];return p.apply(this,arguments)}}else{if(q!=k){i[k].prototype[q]=p}}})}n.each(f[\"static\"],function(p,q){i[k][q]=p});if(this.onCreate){this.onCreate(o[2],o[3],i[k].prototype)}},walk:function(i,h,j,g){g=g||this;if(i){if(j){i=i[j]}b.each(i,function(k,f){if(h.call(g,k,f,j)===false){return false}b.walk(k,h,j,g)})}},createNS:function(j,h){var g,f;h=h||d;j=j.split(\".\");for(g=0;g<j.length;g++){f=j[g];if(!h[f]){h[f]={}}h=h[f]}return h},resolve:function(j,h){var g,f;h=h||d;j=j.split(\".\");for(g=0,f=j.length;g<f;g++){h=h[j[g]];if(!h){break}}return h},addUnload:function(j,i){var h=this;j={func:j,scope:i||this};if(!h.unloads){function g(){var f=h.unloads,l,m;if(f){for(m in f){l=f[m];if(l&&l.func){l.func.call(l.scope,1)}}if(d.detachEvent){d.detachEvent(\"onbeforeunload\",k);d.detachEvent(\"onunload\",g)}else{if(d.removeEventListener){d.removeEventListener(\"unload\",g,false)}}h.unloads=l=f=w=g=0;if(d.CollectGarbage){CollectGarbage()}}}function k(){var l=document;if(l.readyState==\"interactive\"){function f(){l.detachEvent(\"onstop\",f);if(g){g()}l=0}if(l){l.attachEvent(\"onstop\",f)}d.setTimeout(function(){if(l){l.detachEvent(\"onstop\",f)}},0)}}if(d.attachEvent){d.attachEvent(\"onunload\",g);d.attachEvent(\"onbeforeunload\",k)}else{if(d.addEventListener){d.addEventListener(\"unload\",g,false)}}h.unloads=[j]}else{h.unloads.push(j)}return j},removeUnload:function(i){var g=this.unloads,h=null;b.each(g,function(j,f){if(j&&j.func==i){g.splice(f,1);h=i;return false}});return h},explode:function(f,g){return f?b.map(f.split(g||\",\"),b.trim):f},_addVer:function(g){var f;if(!this.query){return g}f=(g.indexOf(\"?\")==-1?\"?\":\"&\")+this.query;if(g.indexOf(\"#\")==-1){return g+f}return g.replace(\"#\",f+\"#\")},_replace:function(h,f,g){if(c){return g.replace(h,function(){var l=f,j=arguments,k;for(k=0;k<j.length-2;k++){if(j[k]===e){l=l.replace(new RegExp(\"\\\\$\"+k,\"g\"),\"\")}else{l=l.replace(new RegExp(\"\\\\$\"+k,\"g\"),j[k])}}return l})}return g.replace(h,f)}};b._init();d.tinymce=d.tinyMCE=b})(window);tinymce.create(\"tinymce.util.Dispatcher\",{scope:null,listeners:null,Dispatcher:function(a){this.scope=a||this;this.listeners=[]},add:function(a,b){this.listeners.push({cb:a,scope:b||this.scope});return a},addToTop:function(a,b){this.listeners.unshift({cb:a,scope:b||this.scope});return a},remove:function(a){var b=this.listeners,c=null;tinymce.each(b,function(e,d){if(a==e.cb){c=a;b.splice(d,1);return false}});return c},dispatch:function(){var f,d=arguments,e,b=this.listeners,g;for(e=0;e<b.length;e++){g=b[e];f=g.cb.apply(g.scope,d);if(f===false){break}}return f}});(function(){var a=tinymce.each;tinymce.create(\"tinymce.util.URI\",{URI:function(e,g){var f=this,i,d,c,h;e=tinymce.trim(e);g=f.settings=g||{};if(/^([\\w\\-]+):([^\\/]{2})/i.test(e)||/^\\s*#/.test(e)){f.source=e;return}if(e.indexOf(\"/\")===0&&e.indexOf(\"//\")!==0){e=(g.base_uri?g.base_uri.protocol||\"http\":\"http\")+\"://mce_host\"+e}if(!/^[\\w-]*:?\\/\\//.test(e)){h=g.base_uri?g.base_uri.path:new tinymce.util.URI(location.href).directory;e=((g.base_uri&&g.base_uri.protocol)||\"http\")+\"://mce_host\"+f.toAbsPath(h,e)}e=e.replace(/@@/g,\"(mce_at)\");e=/^(?:(?![^:@]+:[^:@\\/]*@)([^:\\/?#.]+):)?(?:\\/\\/)?((?:(([^:@]*):?([^:@]*))?@)?([^:\\/?#]*)(?::(\\d*))?)(((\\/(?:[^?#](?![^?#\\/]*\\.[^?#\\/.]+(?:[?#]|$)))*\\/?)?([^?#\\/]*))(?:\\?([^#]*))?(?:#(.*))?)/.exec(e);a([\"source\",\"protocol\",\"authority\",\"userInfo\",\"user\",\"password\",\"host\",\"port\",\"relative\",\"path\",\"directory\",\"file\",\"query\",\"anchor\"],function(b,j){var k=e[j];if(k){k=k.replace(/\\(mce_at\\)/g,\"@@\")}f[b]=k});if(c=g.base_uri){if(!f.protocol){f.protocol=c.protocol}if(!f.userInfo){f.userInfo=c.userInfo}if(!f.port&&f.host==\"mce_host\"){f.port=c.port}if(!f.host||f.host==\"mce_host\"){f.host=c.host}f.source=\"\"}},setPath:function(c){var b=this;c=/^(.*?)\\/?(\\w+)?$/.exec(c);b.path=c[0];b.directory=c[1];b.file=c[2];b.source=\"\";b.getURI()},toRelative:function(b){var c=this,d;if(b===\"./\"){return b}b=new tinymce.util.URI(b,{base_uri:c});if((b.host!=\"mce_host\"&&c.host!=b.host&&b.host)||c.port!=b.port||c.protocol!=b.protocol){return b.getURI()}d=c.toRelPath(c.path,b.path);if(b.query){d+=\"?\"+b.query}if(b.anchor){d+=\"#\"+b.anchor}return d},toAbsolute:function(b,c){var b=new tinymce.util.URI(b,{base_uri:this});return b.getURI(this.host==b.host&&this.protocol==b.protocol?c:0)},toRelPath:function(g,h){var c,f=0,d=\"\",e,b;g=g.substring(0,g.lastIndexOf(\"/\"));g=g.split(\"/\");c=h.split(\"/\");if(g.length>=c.length){for(e=0,b=g.length;e<b;e++){if(e>=c.length||g[e]!=c[e]){f=e+1;break}}}if(g.length<c.length){for(e=0,b=c.length;e<b;e++){if(e>=g.length||g[e]!=c[e]){f=e+1;break}}}if(f==1){return h}for(e=0,b=g.length-(f-1);e<b;e++){d+=\"../\"}for(e=f-1,b=c.length;e<b;e++){if(e!=f-1){d+=\"/\"+c[e]}else{d+=c[e]}}return d},toAbsPath:function(e,f){var c,b=0,h=[],d,g;d=/\\/$/.test(f)?\"/\":\"\";e=e.split(\"/\");f=f.split(\"/\");a(e,function(i){if(i){h.push(i)}});e=h;for(c=f.length-1,h=[];c>=0;c--){if(f[c].length==0||f[c]==\".\"){continue}if(f[c]==\"..\"){b++;continue}if(b>0){b--;continue}h.push(f[c])}c=e.length-b;if(c<=0){g=h.reverse().join(\"/\")}else{g=e.slice(0,c).join(\"/\")+\"/\"+h.reverse().join(\"/\")}if(g.indexOf(\"/\")!==0){g=\"/\"+g}if(d&&g.lastIndexOf(\"/\")!==g.length-1){g+=d}return g},getURI:function(d){var c,b=this;if(!b.source||d){c=\"\";if(!d){if(b.protocol){c+=b.protocol+\"://\"}if(b.userInfo){c+=b.userInfo+\"@\"}if(b.host){c+=b.host}if(b.port){c+=\":\"+b.port}}if(b.path){c+=b.path}if(b.query){c+=\"?\"+b.query}if(b.anchor){c+=\"#\"+b.anchor}b.source=c}return b.source}})})();(function(){var a=tinymce.each;tinymce.create(\"static tinymce.util.Cookie\",{getHash:function(d){var b=this.get(d),c;if(b){a(b.split(\"&\"),function(e){e=e.split(\"=\");c=c||{};c[unescape(e[0])]=unescape(e[1])})}return c},setHash:function(j,b,g,f,i,c){var h=\"\";a(b,function(e,d){h+=(!h?\"\":\"&\")+escape(d)+\"=\"+escape(e)});this.set(j,h,g,f,i,c)},get:function(i){var h=document.cookie,g,f=i+\"=\",d;if(!h){return}d=h.indexOf(\"; \"+f);if(d==-1){d=h.indexOf(f);if(d!=0){return null}}else{d+=2}g=h.indexOf(\";\",d);if(g==-1){g=h.length}return unescape(h.substring(d+f.length,g))},set:function(i,b,g,f,h,c){document.cookie=i+\"=\"+escape(b)+((g)?\"; expires=\"+g.toUTCString():\"\")+((f)?\"; path=\"+escape(f):\"\")+((h)?\"; domain=\"+h:\"\")+((c)?\"; secure\":\"\")},remove:function(e,b){var c=new Date();c.setTime(c.getTime()-1000);this.set(e,\"\",c,b,c)}})})();(function(){function serialize(o,quote){var i,v,t;quote=quote||'\"';if(o==null){return\"null\"}t=typeof o;if(t==\"string\"){v=\"\\bb\\tt\\nn\\ff\\rr\\\"\\\"''\\\\\\\\\";return quote+o.replace(/([\\u0080-\\uFFFF\\x00-\\x1f\\\"\\'\\\\])/g,function(a,b){if(quote==='\"'&&a===\"'\"){return a}i=v.indexOf(b);if(i+1){return\"\\\\\"+v.charAt(i+1)}a=b.charCodeAt().toString(16);return\"\\\\u\"+\"0000\".substring(a.length)+a})+quote}if(t==\"object\"){if(o.hasOwnProperty&&o instanceof Array){for(i=0,v=\"[\";i<o.length;i++){v+=(i>0?\",\":\"\")+serialize(o[i],quote)}return v+\"]\"}v=\"{\";for(i in o){if(o.hasOwnProperty(i)){v+=typeof o[i]!=\"function\"?(v.length>1?\",\"+quote:quote)+i+quote+\":\"+serialize(o[i],quote):\"\"}}return v+\"}\"}return\"\"+o}tinymce.util.JSON={serialize:serialize,parse:function(s){try{return eval(\"(\"+s+\")\")}catch(ex){}}}})();tinymce.create(\"static tinymce.util.XHR\",{send:function(g){var a,e,b=window,h=0;g.scope=g.scope||this;g.success_scope=g.success_scope||g.scope;g.error_scope=g.error_scope||g.scope;g.async=g.async===false?false:true;g.data=g.data||\"\";function d(i){a=0;try{a=new ActiveXObject(i)}catch(c){}return a}a=b.XMLHttpRequest?new XMLHttpRequest():d(\"Microsoft.XMLHTTP\")||d(\"Msxml2.XMLHTTP\");if(a){if(a.overrideMimeType){a.overrideMimeType(g.content_type)}a.open(g.type||(g.data?\"POST\":\"GET\"),g.url,g.async);if(g.content_type){a.setRequestHeader(\"Content-Type\",g.content_type)}a.setRequestHeader(\"X-Requested-With\",\"XMLHttpRequest\");a.send(g.data);function f(){if(!g.async||a.readyState==4||h++>10000){if(g.success&&h<10000&&a.status==200){g.success.call(g.success_scope,\"\"+a.responseText,a,g)}else{if(g.error){g.error.call(g.error_scope,h>10000?\"TIMED_OUT\":\"GENERAL\",a,g)}}a=null}else{b.setTimeout(f,10)}}if(!g.async){return f()}e=b.setTimeout(f,10)}}});(function(){var c=tinymce.extend,b=tinymce.util.JSON,a=tinymce.util.XHR;tinymce.create(\"tinymce.util.JSONRequest\",{JSONRequest:function(d){this.settings=c({},d);this.count=0},send:function(f){var e=f.error,d=f.success;f=c(this.settings,f);f.success=function(h,g){h=b.parse(h);if(typeof(h)==\"undefined\"){h={error:\"JSON Parse error.\"}}if(h.error){e.call(f.error_scope||f.scope,h.error,g)}else{d.call(f.success_scope||f.scope,h.result)}};f.error=function(h,g){if(e){e.call(f.error_scope||f.scope,h,g)}};f.data=b.serialize({id:f.id||\"c\"+(this.count++),method:f.method,params:f.params});f.content_type=\"application/json\";a.send(f)},\"static\":{sendRPC:function(d){return new tinymce.util.JSONRequest().send(d)}}})}());(function(a){a.VK={DELETE:46,BACKSPACE:8,ENTER:13,TAB:9,SPACEBAR:32,UP:38,DOWN:40}})(tinymce);(function(k){var i=k.VK,j=i.BACKSPACE,h=i.DELETE;function c(m){var o=m.dom,n=m.selection;m.onKeyDown.add(function(q,u){var p,v,s,t,r;r=u.keyCode==h;if(r||u.keyCode==j){u.preventDefault();p=n.getRng();v=o.getParent(p.startContainer,o.isBlock);if(r){v=o.getNext(v,o.isBlock)}if(v){s=v.firstChild;while(s&&s.nodeType==3&&s.nodeValue.length==0){s=s.nextSibling}if(s&&s.nodeName===\"SPAN\"){t=s.cloneNode(false)}}q.getDoc().execCommand(r?\"ForwardDelete\":\"Delete\",false,null);v=o.getParent(p.startContainer,o.isBlock);k.each(o.select(\"span.Apple-style-span,font.Apple-style-span\",v),function(x){var y=n.getBookmark();if(t){o.replace(t.cloneNode(false),x,true)}else{o.remove(x,true)}n.moveToBookmark(y)})}})}function d(m){m.onKeyUp.add(function(n,p){var o=p.keyCode;if(o==h||o==j){if(n.dom.isEmpty(n.getBody())){n.setContent(\"\",{format:\"raw\"});n.nodeChanged();return}}})}function b(m){m.dom.bind(m.getDoc(),\"focusin\",function(){m.selection.setRng(m.selection.getRng())})}function e(m){m.onKeyDown.add(function(n,q){if(q.keyCode===j){if(n.selection.isCollapsed()&&n.selection.getRng(true).startOffset===0){var p=n.selection.getNode();var o=p.previousSibling;if(o&&o.nodeName&&o.nodeName.toLowerCase()===\"hr\"){n.dom.remove(o);k.dom.Event.cancel(q)}}}})}function g(m){if(!Range.prototype.getClientRects){m.onMouseDown.add(function(o,p){if(p.target.nodeName===\"HTML\"){var n=o.getBody();n.blur();setTimeout(function(){n.focus()},0)}})}}function f(m){m.onClick.add(function(n,o){o=o.target;if(/^(IMG|HR)$/.test(o.nodeName)){n.selection.select(o)}if(o.nodeName==\"A\"&&n.dom.hasClass(o,\"mceItemAnchor\")){n.selection.select(o)}n.nodeChanged()})}function l(m){var o,n;m.dom.bind(m.getDoc(),\"selectionchange\",function(){if(n){clearTimeout(n);n=0}n=window.setTimeout(function(){var p=m.selection.getRng();if(!o||!k.dom.RangeUtils.compareRanges(p,o)){m.nodeChanged();o=p}},50)})}function a(m){document.body.setAttribute(\"role\",\"application\")}k.create(\"tinymce.util.Quirks\",{Quirks:function(m){if(k.isWebKit){c(m);d(m);b(m);f(m);if(k.isIDevice){l(m)}}if(k.isIE){e(m);d(m);a(m)}if(k.isGecko){e(m);g(m)}}})})(tinymce);(function(j){var a,g,d,k=/[&<>\\\"\\u007E-\\uD7FF\\uE000-\\uFFEF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,b=/[<>&\\u007E-\\uD7FF\\uE000-\\uFFEF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,f=/[<>&\\\"\\']/g,c=/&(#x|#)?([\\w]+);/g,i={128:\"\\u20AC\",130:\"\\u201A\",131:\"\\u0192\",132:\"\\u201E\",133:\"\\u2026\",134:\"\\u2020\",135:\"\\u2021\",136:\"\\u02C6\",137:\"\\u2030\",138:\"\\u0160\",139:\"\\u2039\",140:\"\\u0152\",142:\"\\u017D\",145:\"\\u2018\",146:\"\\u2019\",147:\"\\u201C\",148:\"\\u201D\",149:\"\\u2022\",150:\"\\u2013\",151:\"\\u2014\",152:\"\\u02DC\",153:\"\\u2122\",154:\"\\u0161\",155:\"\\u203A\",156:\"\\u0153\",158:\"\\u017E\",159:\"\\u0178\"};g={'\"':\"&quot;\",\"'\":\"&#39;\",\"<\":\"&lt;\",\">\":\"&gt;\",\"&\":\"&amp;\"};d={\"&lt;\":\"<\",\"&gt;\":\">\",\"&amp;\":\"&\",\"&quot;\":'\"',\"&apos;\":\"'\"};function h(l){var m;m=document.createElement(\"div\");m.innerHTML=l;return m.textContent||m.innerText||l}function e(m,p){var n,o,l,q={};if(m){m=m.split(\",\");p=p||10;for(n=0;n<m.length;n+=2){o=String.fromCharCode(parseInt(m[n],p));if(!g[o]){l=\"&\"+m[n+1]+\";\";q[o]=l;q[l]=o}}return q}}a=e(\"50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro\",32);j.html=j.html||{};j.html.Entities={encodeRaw:function(m,l){return m.replace(l?k:b,function(n){return g[n]||n})},encodeAllRaw:function(l){return(\"\"+l).replace(f,function(m){return g[m]||m})},encodeNumeric:function(m,l){return m.replace(l?k:b,function(n){if(n.length>1){return\"&#\"+(((n.charCodeAt(0)-55296)*1024)+(n.charCodeAt(1)-56320)+65536)+\";\"}return g[n]||\"&#\"+n.charCodeAt(0)+\";\"})},encodeNamed:function(n,l,m){m=m||a;return n.replace(l?k:b,function(o){return g[o]||m[o]||o})},getEncodeFunc:function(l,o){var p=j.html.Entities;o=e(o)||a;function m(r,q){return r.replace(q?k:b,function(s){return g[s]||o[s]||\"&#\"+s.charCodeAt(0)+\";\"||s})}function n(r,q){return p.encodeNamed(r,q,o)}l=j.makeMap(l.replace(/\\+/g,\",\"));if(l.named&&l.numeric){return m}if(l.named){if(o){return n}return p.encodeNamed}if(l.numeric){return p.encodeNumeric}return p.encodeRaw},decode:function(l){return l.replace(c,function(n,m,o){if(m){o=parseInt(o,m.length===2?16:10);if(o>65535){o-=65536;return String.fromCharCode(55296+(o>>10),56320+(o&1023))}else{return i[o]||String.fromCharCode(o)}}return d[n]||a[n]||h(n)})}}})(tinymce);tinymce.html.Styles=function(d,f){var k=/rgb\\s*\\(\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*\\)/gi,h=/(?:url(?:(?:\\(\\s*\\\"([^\\\"]+)\\\"\\s*\\))|(?:\\(\\s*\\'([^\\']+)\\'\\s*\\))|(?:\\(\\s*([^)\\s]+)\\s*\\))))|(?:\\'([^\\']+)\\')|(?:\\\"([^\\\"]+)\\\")/gi,b=/\\s*([^:]+):\\s*([^;]+);?/g,l=/\\s+$/,m=/rgb/,e,g,a={},j;d=d||{};j=\"\\\\\\\" \\\\' \\\\; \\\\: ; : \\uFEFF\".split(\" \");for(g=0;g<j.length;g++){a[j[g]]=\"\\uFEFF\"+g;a[\"\\uFEFF\"+g]=j[g]}function c(n,q,p,i){function o(r){r=parseInt(r).toString(16);return r.length>1?r:\"0\"+r}return\"#\"+o(q)+o(p)+o(i)}return{toHex:function(i){return i.replace(k,c)},parse:function(r){var y={},p,n,v,q,u=d.url_converter,x=d.url_converter_scope||this;function o(C,F){var E,B,A,D;E=y[C+\"-top\"+F];if(!E){return}B=y[C+\"-right\"+F];if(E!=B){return}A=y[C+\"-bottom\"+F];if(B!=A){return}D=y[C+\"-left\"+F];if(A!=D){return}y[C+F]=D;delete y[C+\"-top\"+F];delete y[C+\"-right\"+F];delete y[C+\"-bottom\"+F];delete y[C+\"-left\"+F]}function t(B){var C=y[B],A;if(!C||C.indexOf(\" \")<0){return}C=C.split(\" \");A=C.length;while(A--){if(C[A]!==C[0]){return false}}y[B]=C[0];return true}function z(C,B,A,D){if(!t(B)){return}if(!t(A)){return}if(!t(D)){return}y[C]=y[B]+\" \"+y[A]+\" \"+y[D];delete y[B];delete y[A];delete y[D]}function s(A){q=true;return a[A]}function i(B,A){if(q){B=B.replace(/\\uFEFF[0-9]/g,function(C){return a[C]})}if(!A){B=B.replace(/\\\\([\\'\\\";:])/g,\"$1\")}return B}if(r){r=r.replace(/\\\\[\\\"\\';:\\uFEFF]/g,s).replace(/\\\"[^\\\"]+\\\"|\\'[^\\']+\\'/g,function(A){return A.replace(/[;:]/g,s)});while(p=b.exec(r)){n=p[1].replace(l,\"\").toLowerCase();v=p[2].replace(l,\"\");if(n&&v.length>0){if(n===\"font-weight\"&&v===\"700\"){v=\"bold\"}else{if(n===\"color\"||n===\"background-color\"){v=v.toLowerCase()}}v=v.replace(k,c);v=v.replace(h,function(B,A,E,D,F,C){F=F||C;if(F){F=i(F);return\"'\"+F.replace(/\\'/g,\"\\\\'\")+\"'\"}A=i(A||E||D);if(u){A=u.call(x,A,\"style\")}return\"url('\"+A.replace(/\\'/g,\"\\\\'\")+\"')\"});y[n]=q?i(v,true):v}b.lastIndex=p.index+p[0].length}o(\"border\",\"\");o(\"border\",\"-width\");o(\"border\",\"-color\");o(\"border\",\"-style\");o(\"padding\",\"\");o(\"margin\",\"\");z(\"border\",\"border-width\",\"border-style\",\"border-color\");if(y.border===\"medium none\"){delete y.border}}return y},serialize:function(p,r){var o=\"\",n,q;function i(t){var x,u,s,v;x=f.styles[t];if(x){for(u=0,s=x.length;u<s;u++){t=x[u];v=p[t];if(v!==e&&v.length>0){o+=(o.length>0?\" \":\"\")+t+\": \"+v+\";\"}}}}if(r&&f&&f.styles){i(\"*\");i(r)}else{for(n in p){q=p[n];if(q!==e&&q.length>0){o+=(o.le