require.config({"config": {
        "jsbuild":{"Magento_Tinymce3/tiny_mce/plugins/table/js/table.js":"tinyMCEPopup.requireLangPack();\n\nvar action, orgTableWidth, orgTableHeight, dom = tinyMCEPopup.editor.dom;\n\nfunction insertTable() {\n\tvar formObj = document.forms[0];\n\tvar inst = tinyMCEPopup.editor, dom = inst.dom;\n\tvar cols = 2, rows = 2, border = 0, cellpadding = -1, cellspacing = -1, align, width, height, className, caption, frame, rules;\n\tvar html = '', capEl, elm;\n\tvar cellLimit, rowLimit, colLimit;\n\n\ttinyMCEPopup.restoreSelection();\n\n\tif (!AutoValidator.validate(formObj)) {\n\t\ttinyMCEPopup.alert(AutoValidator.getErrorMessages(formObj).join('. ') + '.');\n\t\treturn false;\n\t}\n\n\telm = dom.getParent(inst.selection.getNode(), 'table');\n\n\t// Get form data\n\tcols = formObj.elements['cols'].value;\n\trows = formObj.elements['rows'].value;\n\tborder = formObj.elements['border'].value != \"\" ? formObj.elements['border'].value : 0;\n\tcellpadding = formObj.elements['cellpadding'].value != \"\" ? formObj.elements['cellpadding'].value : \"\";\n\tcellspacing = formObj.elements['cellspacing'].value != \"\" ? formObj.elements['cellspacing'].value : \"\";\n\talign = getSelectValue(formObj, \"align\");\n\tframe = getSelectValue(formObj, \"tframe\");\n\trules = getSelectValue(formObj, \"rules\");\n\twidth = formObj.elements['width'].value;\n\theight = formObj.elements['height'].value;\n\tbordercolor = formObj.elements['bordercolor'].value;\n\tbgcolor = formObj.elements['bgcolor'].value;\n\tclassName = getSelectValue(formObj, \"class\");\n\tid = formObj.elements['id'].value;\n\tsummary = formObj.elements['summary'].value;\n\tstyle = formObj.elements['style'].value;\n\tdir = formObj.elements['dir'].value;\n\tlang = formObj.elements['lang'].value;\n\tbackground = formObj.elements['backgroundimage'].value;\n\tcaption = formObj.elements['caption'].checked;\n\n\tcellLimit = tinyMCEPopup.getParam('table_cell_limit', false);\n\trowLimit = tinyMCEPopup.getParam('table_row_limit', false);\n\tcolLimit = tinyMCEPopup.getParam('table_col_limit', false);\n\n\t// Validate table size\n\tif (colLimit && cols > colLimit) {\n\t\ttinyMCEPopup.alert(inst.getLang('table_dlg.col_limit').replace(/\\{\\$cols\\}/g, colLimit));\n\t\treturn false;\n\t} else if (rowLimit && rows > rowLimit) {\n\t\ttinyMCEPopup.alert(inst.getLang('table_dlg.row_limit').replace(/\\{\\$rows\\}/g, rowLimit));\n\t\treturn false;\n\t} else if (cellLimit && cols * rows > cellLimit) {\n\t\ttinyMCEPopup.alert(inst.getLang('table_dlg.cell_limit').replace(/\\{\\$cells\\}/g, cellLimit));\n\t\treturn false;\n\t}\n\n\t// Update table\n\tif (action == \"update\") {\n\t\tdom.setAttrib(elm, 'cellPadding', cellpadding, true);\n\t\tdom.setAttrib(elm, 'cellSpacing', cellspacing, true);\n\n\t\tif (!isCssSize(border)) {\n\t\t\tdom.setAttrib(elm, 'border', border);\n\t\t} else {\n\t\t\tdom.setAttrib(elm, 'border', '');\n\t\t}\n\n\t\tif (border == '') {\n\t\t\tdom.setStyle(elm, 'border-width', '');\n\t\t\tdom.setStyle(elm, 'border', '');\n\t\t\tdom.setAttrib(elm, 'border', '');\n\t\t}\n\n\t\tdom.setAttrib(elm, 'align', align);\n\t\tdom.setAttrib(elm, 'frame', frame);\n\t\tdom.setAttrib(elm, 'rules', rules);\n\t\tdom.setAttrib(elm, 'class', className);\n\t\tdom.setAttrib(elm, 'style', style);\n\t\tdom.setAttrib(elm, 'id', id);\n\t\tdom.setAttrib(elm, 'summary', summary);\n\t\tdom.setAttrib(elm, 'dir', dir);\n\t\tdom.setAttrib(elm, 'lang', lang);\n\n\t\tcapEl = inst.dom.select('caption', elm)[0];\n\n\t\tif (capEl && !caption)\n\t\t\tcapEl.parentNode.removeChild(capEl);\n\n\t\tif (!capEl && caption) {\n\t\t\tcapEl = elm.ownerDocument.createElement('caption');\n\n\t\t\tif (!tinymce.isIE)\n\t\t\t\tcapEl.innerHTML = '<br data-mce-bogus=\"1\"/>';\n\n\t\t\telm.insertBefore(capEl, elm.firstChild);\n\t\t}\n\n\t\tif (width && inst.settings.inline_styles) {\n\t\t\tdom.setStyle(elm, 'width', width);\n\t\t\tdom.setAttrib(elm, 'width', '');\n\t\t} else {\n\t\t\tdom.setAttrib(elm, 'width', width, true);\n\t\t\tdom.setStyle(elm, 'width', '');\n\t\t}\n\n\t\t// Remove these since they are not valid XHTML\n\t\tdom.setAttrib(elm, 'borderColor', '');\n\t\tdom.setAttrib(elm, 'bgColor', '');\n\t\tdom.setAttrib(elm, 'background', '');\n\n\t\tif (height && inst.settings.inline_styles) {\n\t\t\tdom.setStyle(elm, 'height', height);\n\t\t\tdom.setAttrib(elm, 'height', '');\n\t\t} else {\n\t\t\tdom.setAttrib(elm, 'height', height, true);\n\t\t\tdom.setStyle(elm, 'height', '');\n \t\t}\n\n\t\tif (background != '')\n\t\t\telm.style.backgroundImage = \"url('\" + background + \"')\";\n\t\telse\n\t\t\telm.style.backgroundImage = '';\n\n/*\t\tif (tinyMCEPopup.getParam(\"inline_styles\")) {\n\t\t\tif (width != '')\n\t\t\t\telm.style.width = getCSSSize(width);\n\t\t}*/\n\n\t\tif (bordercolor != \"\") {\n\t\t\telm.style.borderColor = bordercolor;\n\t\t\telm.style.borderStyle = elm.style.borderStyle == \"\" ? \"solid\" : elm.style.borderStyle;\n\t\t\telm.style.borderWidth = cssSize(border);\n\t\t} else\n\t\t\telm.style.borderColor = '';\n\n\t\telm.style.backgroundColor = bgcolor;\n\t\telm.style.height = getCSSSize(height);\n\n\t\tinst.addVisual();\n\n\t\t// Fix for stange MSIE align bug\n\t\t//elm.outerHTML = elm.outerHTML;\n\n\t\tinst.nodeChanged();\n\t\tinst.execCommand('mceEndUndoLevel');\n\n\t\t// Repaint if dimensions changed\n\t\tif (formObj.width.value != orgTableWidth || formObj.height.value != orgTableHeight)\n\t\t\tinst.execCommand('mceRepaint');\n\n\t\ttinyMCEPopup.close();\n\t\treturn true;\n\t}\n\n\t// Create new table\n\thtml += '<table';\n\n\thtml += makeAttrib('id', id);\n\tif (!isCssSize(border)) {\n\t\thtml += makeAttrib('border', border);\n\t}\n\n\thtml += makeAttrib('cellpadding', cellpadding);\n\thtml += makeAttrib('cellspacing', cellspacing);\n\thtml += makeAttrib('data-mce-new', '1');\n\n\tif (width && inst.settings.inline_styles) {\n\t\tif (style)\n\t\t\tstyle += '; ';\n\n\t\t// Force px\n\t\tif (/^[0-9\\.]+$/.test(width))\n\t\t\twidth += 'px';\n\n\t\tstyle += 'width: ' + width;\n\t} else\n\t\thtml += makeAttrib('width', width);\n\n/*\tif (height) {\n\t\tif (style)\n\t\t\tstyle += '; ';\n\n\t\tstyle += 'height: ' + height;\n\t}*/\n\n\t//html += makeAttrib('height', height);\n\t//html += makeAttrib('bordercolor', bordercolor);\n\t//html += makeAttrib('bgcolor', bgcolor);\n\thtml += makeAttrib('align', align);\n\thtml += makeAttrib('frame', frame);\n\thtml += makeAttrib('rules', rules);\n\thtml += makeAttrib('class', className);\n\thtml += makeAttrib('style', style);\n\thtml += makeAttrib('summary', summary);\n\thtml += makeAttrib('dir', dir);\n\thtml += makeAttrib('lang', lang);\n\thtml += '>';\n\n\tif (caption) {\n\t\tif (!tinymce.isIE)\n\t\t\thtml += '<caption><br data-mce-bogus=\"1\"/></caption>';\n\t\telse\n\t\t\thtml += '<caption></caption>';\n\t}\n\n\tfor (var y=0; y<rows; y++) {\n\t\thtml += \"<tr>\";\n\n\t\tfor (var x=0; x<cols; x++) {\n\t\t\tif (!tinymce.isIE)\n\t\t\t\thtml += '<td><br data-mce-bogus=\"1\"/></td>';\n\t\t\telse\n\t\t\t\thtml += '<td></td>';\n\t\t}\n\n\t\thtml += \"</tr>\";\n\t}\n\n\thtml += \"</table>\";\n\n\t// Move table\n\tif (inst.settings.fix_table_elements) {\n\t\tvar patt = '';\n\n\t\tinst.focus();\n\t\tinst.selection.setContent('<br class=\"_mce_marker\" />');\n\n\t\ttinymce.each('h1,h2,h3,h4,h5,h6,p'.split(','), function(n) {\n\t\t\tif (patt)\n\t\t\t\tpatt += ',';\n\n\t\t\tpatt += n + ' ._mce_marker';\n\t\t});\n\n\t\ttinymce.each(inst.dom.select(patt), function(n) {\n\t\t\tinst.dom.split(inst.dom.getParent(n, 'h1,h2,h3,h4,h5,h6,p'), n);\n\t\t});\n\n\t\tdom.setOuterHTML(dom.select('br._mce_marker')[0], html);\n\t} else\n\t\tinst.execCommand('mceInsertContent', false, html);\n\n\ttinymce.each(dom.select('table[data-mce-new]'), function(node) {\n\t\tvar tdorth = dom.select('td,th', node);\n\n\t\ttry {\n\t\t\t// IE9 might fail to do this selection \n\t\t\tinst.selection.setCursorLocation(tdorth[0], 0);\n\t\t} catch (ex) {\n\t\t\t// Ignore\n\t\t}\n\n\t\tdom.setAttrib(node, 'data-mce-new', '');\n\t});\n\n\tinst.addVisual();\n\tinst.execCommand('mceEndUndoLevel');\n\n\ttinyMCEPopup.close();\n}\n\nfunction makeAttrib(attrib, value) {\n\tvar formObj = document.forms[0];\n\tvar valueElm = formObj.elements[attrib];\n\n\tif (typeof(value) == \"undefined\" || value == null) {\n\t\tvalue = \"\";\n\n\t\tif (valueElm)\n\t\t\tvalue = valueElm.value;\n\t}\n\n\tif (value == \"\")\n\t\treturn \"\";\n\n\t// XML encode it\n\tvalue = value.replace(/&/g, '&amp;');\n\tvalue = value.replace(/\\\"/g, '&quot;');\n\tvalue = value.replace(/</g, '&lt;');\n\tvalue = value.replace(/>/g, '&gt;');\n\n\treturn ' ' + attrib + '=\"' + value + '\"';\n}\n\nfunction init() {\n\ttinyMCEPopup.resizeToInnerSize();\n\n\tdocument.getElementById('backgroundimagebrowsercontainer').innerHTML = getBrowserHTML('backgroundimagebrowser','backgroundimage','image','table');\n\tdocument.getElementById('backgroundimagebrowsercontainer').innerHTML = getBrowserHTML('backgroundimagebrowser','backgroundimage','image','table');\n\tdocument.getElementById('bordercolor_pickcontainer').innerHTML = getColorPickerHTML('bordercolor_pick','bordercolor');\n\tdocument.getElementById('bgcolor_pickcontainer').innerHTML = getColorPickerHTML('bgcolor_pick','bgcolor');\n\n\tvar cols = 2, rows = 2, border = tinyMCEPopup.getParam('table_default_border', '0'), cellpadding = tinyMCEPopup.getParam('table_default_cellpadding', ''), cellspacing = tinyMCEPopup.getParam('table_default_cellspacing', '');\n\tvar align = \"\", width = \"\", height = \"\", bordercolor = \"\", bgcolor = \"\", className = \"\";\n\tvar id = \"\", summary = \"\", style = \"\", dir = \"\", lang = \"\", background = \"\", bgcolor = \"\", bordercolor = \"\", rules = \"\", frame = \"\";\n\tvar inst = tinyMCEPopup.editor, dom = inst.dom;\n\tvar formObj = document.forms[0];\n\tvar elm = dom.getParent(inst.selection.getNode(), \"table\");\n\n\taction = tinyMCEPopup.getWindowArg('action');\n\n\tif (!action)\n\t\taction = elm ? \"update\" : \"insert\";\n\n\tif (elm && action != \"insert\") {\n\t\tvar rowsAr = elm.rows;\n\t\tvar cols = 0;\n\t\tfor (var i=0; i<rowsAr.length; i++)\n\t\t\tif (rowsAr[i].cells.length > cols)\n\t\t\t\tcols = rowsAr[i].cells.length;\n\n\t\tcols = cols;\n\t\trows = rowsAr.length;\n\n\t\tst = dom.parseStyle(dom.getAttrib(elm, \"style\"));\n\t\tborder = trimSize(getStyle(elm, 'border', 'borderWidth'));\n\t\tcellpadding = dom.getAttrib(elm, 'cellpadding', \"\");\n\t\tcellspacing = dom.getAttrib(elm, 'cellspacing', \"\");\n\t\twidth = trimSize(getStyle(elm, 'width', 'width'));\n\t\theight = trimSize(getStyle(elm, 'height', 'height'));\n\t\tbordercolor = convertRGBToHex(getStyle(elm, 'bordercolor', 'borderLeftColor'));\n\t\tbgcolor = convertRGBToHex(getStyle(elm, 'bgcolor', 'backgroundColor'));\n\t\talign = dom.getAttrib(elm, 'align', align);\n\t\tframe = dom.getAttrib(elm, 'frame');\n\t\trules = dom.getAttrib(elm, 'rules');\n\t\tclassName = tinymce.trim(dom.getAttrib(elm, 'class').replace(/mceItem.+/g, ''));\n\t\tid = dom.getAttrib(elm, 'id');\n\t\tsummary = dom.getAttrib(elm, 'summary');\n\t\tstyle = dom.serializeStyle(st);\n\t\tdir = dom.getAttrib(elm, 'dir');\n\t\tlang = dom.getAttrib(elm, 'lang');\n\t\tbackground = getStyle(elm, 'background', 'backgroundImage').replace(new RegExp(\"url\\\\(['\\\"]?([^'\\\"]*)['\\\"]?\\\\)\", 'gi'), \"$1\");\n\t\tformObj.caption.checked = elm.getElementsByTagName('caption').length > 0;\n\n\t\torgTableWidth = width;\n\t\torgTableHeight = height;\n\n\t\taction = \"update\";\n\t\tformObj.insert.value = inst.getLang('update');\n\t}\n\n\taddClassesToList('class', \"table_styles\");\n\tTinyMCE_EditableSelects.init();\n\n\t// Update form\n\tselectByValue(formObj, 'align', align);\n\tselectByValue(formObj, 'tframe', frame);\n\tselectByValue(formObj, 'rules', rules);\n\tselectByValue(formObj, 'class', className, true, true);\n\tformObj.cols.value = cols;\n\tformObj.rows.value = rows;\n\tformObj.border.value = border;\n\tformObj.cellpadding.value = cellpadding;\n\tformObj.cellspacing.value = cellspacing;\n\tformObj.width.value = width;\n\tformObj.height.value = height;\n\tformObj.bordercolor.value = bordercolor;\n\tformObj.bgcolor.value = bgcolor;\n\tformObj.id.value = id;\n\tformObj.summary.value = summary;\n\tformObj.style.value = style;\n\tformObj.dir.value = dir;\n\tformObj.lang.value = lang;\n\tformObj.backgroundimage.value = background;\n\n\tupdateColor('bordercolor_pick', 'bordercolor');\n\tupdateColor('bgcolor_pick', 'bgcolor');\n\n\t// Resize some elements\n\tif (isVisible('backgroundimagebrowser'))\n\t\tdocument.getElementById('backgroundimage').style.width = '180px';\n\n\t// Disable some fields in update mode\n\tif (action == \"update\") {\n\t\tformObj.cols.disabled = true;\n\t\tformObj.rows.disabled = true;\n\t}\n}\n\nfunction changedSize() {\n\tvar formObj = document.forms[0];\n\tvar st = dom.parseStyle(formObj.style.value);\n\n/*\tvar width = formObj.width.value;\n\tif (width != \"\")\n\t\tst['width'] = tinyMCEPopup.getParam(\"inline_styles\") ? getCSSSize(width) : \"\";\n\telse\n\t\tst['width'] = \"\";*/\n\n\tvar height = formObj.height.value;\n\tif (height != \"\")\n\t\tst['height'] = getCSSSize(height);\n\telse\n\t\tst['height'] = \"\";\n\n\tformObj.style.value = dom.serializeStyle(st);\n}\n\nfunction isCssSize(value) {\n\treturn /^[0-9.]+(%|in|cm|mm|em|ex|pt|pc|px)$/.test(value);\n}\n\nfunction cssSize(value, def) {\n\tvalue = tinymce.trim(value || def);\n\n\tif (!isCssSize(value)) {\n\t\treturn parseInt(value, 10) + 'px';\n\t}\n\n\treturn value;\n}\n\nfunction changedBackgroundImage() {\n\tvar formObj = document.forms[0];\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\tst['background-image'] = \"url('\" + formObj.backgroundimage.value + \"')\";\n\n\tformObj.style.value = dom.serializeStyle(st);\n}\n\nfunction changedBorder() {\n\tvar formObj = document.forms[0];\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\t// Update border width if the element has a color\n\tif (formObj.border.value != \"\" && (isCssSize(formObj.border.value) || formObj.bordercolor.value != \"\"))\n\t\tst['border-width'] = cssSize(formObj.border.value);\n\telse {\n\t\tif (!formObj.border.value) {\n\t\t\tst['border'] = '';\n\t\t\tst['border-width'] = '';\n\t\t}\n\t}\n\n\tformObj.style.value = dom.serializeStyle(st);\n}\n\nfunction changedColor() {\n\tvar formObj = document.forms[0];\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\tst['background-color'] = formObj.bgcolor.value;\n\n\tif (formObj.bordercolor.value != \"\") {\n\t\tst['border-color'] = formObj.bordercolor.value;\n\n\t\t// Add border-width if it's missing\n\t\tif (!st['border-width'])\n\t\t\tst['border-width'] = cssSize(formObj.border.value, 1);\n\t}\n\n\tformObj.style.value = dom.serializeStyle(st);\n}\n\nfunction changedStyle() {\n\tvar formObj = document.forms[0];\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\tif (st['background-image'])\n\t\tformObj.backgroundimage.value = st['background-image'].replace(new RegExp(\"url\\\\(['\\\"]?([^'\\\"]*)['\\\"]?\\\\)\", 'gi'), \"$1\");\n\telse\n\t\tformObj.backgroundimage.value = '';\n\n\tif (st['width'])\n\t\tformObj.width.value = trimSize(st['width']);\n\n\tif (st['height'])\n\t\tformObj.height.value = trimSize(st['height']);\n\n\tif (st['background-color']) {\n\t\tformObj.bgcolor.value = st['background-color'];\n\t\tupdateColor('bgcolor_pick','bgcolor');\n\t}\n\n\tif (st['border-color']) {\n\t\tformObj.bordercolor.value = st['border-color'];\n\t\tupdateColor('bordercolor_pick','bordercolor');\n\t}\n}\n\ntinyMCEPopup.onInit.add(init);\n","Magento_Tinymce3/tiny_mce/plugins/table/js/row.js":"tinyMCEPopup.requireLangPack();\n\nfunction init() {\n\ttinyMCEPopup.resizeToInnerSize();\n\n\tdocument.getElementById('backgroundimagebrowsercontainer').innerHTML = getBrowserHTML('backgroundimagebrowser','backgroundimage','image','table');\n\tdocument.getElementById('bgcolor_pickcontainer').innerHTML = getColorPickerHTML('bgcolor_pick','bgcolor');\n\n\tvar inst = tinyMCEPopup.editor;\n\tvar dom = inst.dom;\n\tvar trElm = dom.getParent(inst.selection.getStart(), \"tr\");\n\tvar formObj = document.forms[0];\n\tvar st = dom.parseStyle(dom.getAttrib(trElm, \"style\"));\n\n\t// Get table row data\n\tvar rowtype = trElm.parentNode.nodeName.toLowerCase();\n\tvar align = dom.getAttrib(trElm, 'align');\n\tvar valign = dom.getAttrib(trElm, 'valign');\n\tvar height = trimSize(getStyle(trElm, 'height', 'height'));\n\tvar className = dom.getAttrib(trElm, 'class');\n\tvar bgcolor = convertRGBToHex(getStyle(trElm, 'bgcolor', 'backgroundColor'));\n\tvar backgroundimage = getStyle(trElm, 'background', 'backgroundImage').replace(new RegExp(\"url\\\\(['\\\"]?([^'\\\"]*)['\\\"]?\\\\)\", 'gi'), \"$1\");\n\tvar id = dom.getAttrib(trElm, 'id');\n\tvar lang = dom.getAttrib(trElm, 'lang');\n\tvar dir = dom.getAttrib(trElm, 'dir');\n\n\tselectByValue(formObj, 'rowtype', rowtype);\n\n\t// Any cells selected\n\tif (dom.select('td.mceSelected,th.mceSelected', trElm).length == 0) {\n\t\t// Setup form\n\t\taddClassesToList('class', 'table_row_styles');\n\t\tTinyMCE_EditableSelects.init();\n\n\t\tformObj.bgcolor.value = bgcolor;\n\t\tformObj.backgroundimage.value = backgroundimage;\n\t\tformObj.height.value = height;\n\t\tformObj.id.value = id;\n\t\tformObj.lang.value = lang;\n\t\tformObj.style.value = dom.serializeStyle(st);\n\t\tselectByValue(formObj, 'align', align);\n\t\tselectByValue(formObj, 'valign', valign);\n\t\tselectByValue(formObj, 'class', className, true, true);\n\t\tselectByValue(formObj, 'dir', dir);\n\n\t\t// Resize some elements\n\t\tif (isVisible('backgroundimagebrowser'))\n\t\t\tdocument.getElementById('backgroundimage').style.width = '180px';\n\n\t\tupdateColor('bgcolor_pick', 'bgcolor');\n\t} else\n\t\ttinyMCEPopup.dom.hide('action');\n}\n\nfunction updateAction() {\n\tvar inst = tinyMCEPopup.editor, dom = inst.dom, trElm, tableElm, formObj = document.forms[0];\n\tvar action = getSelectValue(formObj, 'action');\n\n\tif (!AutoValidator.validate(formObj)) {\n\t\ttinyMCEPopup.alert(AutoValidator.getErrorMessages(formObj).join('. ') + '.');\n\t\treturn false;\n\t}\n\n\ttinyMCEPopup.restoreSelection();\n\ttrElm = dom.getParent(inst.selection.getStart(), \"tr\");\n\ttableElm = dom.getParent(inst.selection.getStart(), \"table\");\n\n\t// Update all selected rows\n\tif (dom.select('td.mceSelected,th.mceSelected', trElm).length > 0) {\n\t\ttinymce.each(tableElm.rows, function(tr) {\n\t\t\tvar i;\n\n\t\t\tfor (i = 0; i < tr.cells.length; i++) {\n\t\t\t\tif (dom.hasClass(tr.cells[i], 'mceSelected')) {\n\t\t\t\t\tupdateRow(tr, true);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\tinst.addVisual();\n\t\tinst.nodeChanged();\n\t\tinst.execCommand('mceEndUndoLevel');\n\t\ttinyMCEPopup.close();\n\t\treturn;\n\t}\n\n\tswitch (action) {\n\t\tcase \"row\":\n\t\t\tupdateRow(trElm);\n\t\t\tbreak;\n\n\t\tcase \"all\":\n\t\t\tvar rows = tableElm.getElementsByTagName(\"tr\");\n\n\t\t\tfor (var i=0; i<rows.length; i++)\n\t\t\t\tupdateRow(rows[i], true);\n\n\t\t\tbreak;\n\n\t\tcase \"odd\":\n\t\tcase \"even\":\n\t\t\tvar rows = tableElm.getElementsByTagName(\"tr\");\n\n\t\t\tfor (var i=0; i<rows.length; i++) {\n\t\t\t\tif ((i % 2 == 0 && action == \"odd\") || (i % 2 != 0 && action == \"even\"))\n\t\t\t\t\tupdateRow(rows[i], true, true);\n\t\t\t}\n\n\t\t\tbreak;\n\t}\n\n\tinst.addVisual();\n\tinst.nodeChanged();\n\tinst.execCommand('mceEndUndoLevel');\n\ttinyMCEPopup.close();\n}\n\nfunction updateRow(tr_elm, skip_id, skip_parent) {\n\tvar inst = tinyMCEPopup.editor;\n\tvar formObj = document.forms[0];\n\tvar dom = inst.dom;\n\tvar curRowType = tr_elm.parentNode.nodeName.toLowerCase();\n\tvar rowtype = getSelectValue(formObj, 'rowtype');\n\tvar doc = inst.getDoc();\n\n\t// Update row element\n\tif (!skip_id)\n\t\tdom.setAttrib(tr_elm, 'id', formObj.id.value);\n\n\tdom.setAttrib(tr_elm, 'align', getSelectValue(formObj, 'align'));\n\tdom.setAttrib(tr_elm, 'vAlign', getSelectValue(formObj, 'valign'));\n\tdom.setAttrib(tr_elm, 'lang', formObj.lang.value);\n\tdom.setAttrib(tr_elm, 'dir', getSelectValue(formObj, 'dir'));\n\tdom.setAttrib(tr_elm, 'style', dom.serializeStyle(dom.parseStyle(formObj.style.value)));\n\tdom.setAttrib(tr_elm, 'class', getSelectValue(formObj, 'class'));\n\n\t// Clear deprecated attributes\n\tdom.setAttrib(tr_elm, 'background', '');\n\tdom.setAttrib(tr_elm, 'bgColor', '');\n\tdom.setAttrib(tr_elm, 'height', '');\n\n\t// Set styles\n\ttr_elm.style.height = getCSSSize(formObj.height.value);\n\ttr_elm.style.backgroundColor = formObj.bgcolor.value;\n\n\tif (formObj.backgroundimage.value != \"\")\n\t\ttr_elm.style.backgroundImage = \"url('\" + formObj.backgroundimage.value + \"')\";\n\telse\n\t\ttr_elm.style.backgroundImage = '';\n\n\t// Setup new rowtype\n\tif (curRowType != rowtype && !skip_parent) {\n\t\t// first, clone the node we are working on\n\t\tvar newRow = tr_elm.cloneNode(1);\n\n\t\t// next, find the parent of its new destination (creating it if necessary)\n\t\tvar theTable = dom.getParent(tr_elm, \"table\");\n\t\tvar dest = rowtype;\n\t\tvar newParent = null;\n\t\tfor (var i = 0; i < theTable.childNodes.length; i++) {\n\t\t\tif (theTable.childNodes[i].nodeName.toLowerCase() == dest)\n\t\t\t\tnewParent = theTable.childNodes[i];\n\t\t}\n\n\t\tif (newParent == null) {\n\t\t\tnewParent = doc.createElement(dest);\n\n\t\t\tif (theTable.firstChild.nodeName == 'CAPTION')\n\t\t\t\tinst.dom.insertAfter(newParent, theTable.firstChild);\n\t\t\telse\n\t\t\t\ttheTable.insertBefore(newParent, theTable.firstChild);\n\t\t}\n\n\t\t// append the row to the new parent\n\t\tnewParent.appendChild(newRow);\n\n\t\t// remove the original\n\t\ttr_elm.parentNode.removeChild(tr_elm);\n\n\t\t// set tr_elm to the new node\n\t\ttr_elm = newRow;\n\t}\n\n\tdom.setAttrib(tr_elm, 'style', dom.serializeStyle(dom.parseStyle(tr_elm.style.cssText)));\n}\n\nfunction changedBackgroundImage() {\n\tvar formObj = document.forms[0], dom = tinyMCEPopup.editor.dom;\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\tst['background-image'] = \"url('\" + formObj.backgroundimage.value + \"')\";\n\n\tformObj.style.value = dom.serializeStyle(st);\n}\n\nfunction changedStyle() {\n\tvar formObj = document.forms[0], dom = tinyMCEPopup.editor.dom;\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\tif (st['background-image'])\n\t\tformObj.backgroundimage.value = st['background-image'].replace(new RegExp(\"url\\\\('?([^']*)'?\\\\)\", 'gi'), \"$1\");\n\telse\n\t\tformObj.backgroundimage.value = '';\n\n\tif (st['height'])\n\t\tformObj.height.value = trimSize(st['height']);\n\n\tif (st['background-color']) {\n\t\tformObj.bgcolor.value = st['background-color'];\n\t\tupdateColor('bgcolor_pick','bgcolor');\n\t}\n}\n\nfunction changedSize() {\n\tvar formObj = document.forms[0], dom = tinyMCEPopup.editor.dom;\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\tvar height = formObj.height.value;\n\tif (height != \"\")\n\t\tst['height'] = getCSSSize(height);\n\telse\n\t\tst['height'] = \"\";\n\n\tformObj.style.value = dom.serializeStyle(st);\n}\n\nfunction changedColor() {\n\tvar formObj = document.forms[0], dom = tinyMCEPopup.editor.dom;\n\tvar st = dom.parseStyle(formObj.style.value);\n\n\tst['background-color'] = formObj.bgcolor.value;\n\n\tformObj.style.value = dom.serializeStyle(st);\n}\n\ntinyMCEPopup.onInit.add(init);\n","Magento_Tinymce3/tiny_mce/plugins/table/js/cell.js":"tinyMCEPopup.requireLangPack();\n\nvar ed;\n\nfunction init() {\n\ted = tinyMCEPopup.editor;\n\ttinyMCEPopup.resizeToInnerSize();\n\n\tdocument.getElementById('backgroundimagebrowsercontainer').innerHTML = getBrowserHTML('backgroundimagebrowser','backgroundimage','image','table');\n\tdocument.getElementById('bordercolor_pickcontainer').innerHTML = getColorPickerHTML('bordercolor_pick','bordercolor');\n\tdocument.getElementById('bgcolor_pickcontainer').innerHTML = getColorPickerHTML('bgcolor_pick','bgcolor')\n\n\tvar inst = ed;\n\tvar tdElm = ed.dom.getParent(ed.selection.getStart(), \"td,th\");\n\tvar formObj = document.forms[0];\n\tvar st = ed.dom.parseStyle(ed.dom.getAttrib(tdElm, \"style\"));\n\n\t// Get table cell data\n\tvar celltype = tdElm.nodeName.toLowerCase();\n\tvar align = ed.dom.getAttrib(tdElm, 'align');\n\tvar valign = ed.dom.getAttrib(tdElm, 'valign');\n\tvar width = trimSize(getStyle(tdElm, 'width', 'width'));\n\tvar height = trimSize(getStyle(tdElm, 'height', 'height'));\n\tvar bordercolor = convertRGBToHex(getStyle(tdElm, 'bordercolor', 'borderLeftColor'));\n\tvar bgcolor = convertRGBToHex(getStyle(tdElm, 'bgcolor', 'backgroundColor'));\n\tvar className = ed.dom.getAttrib(tdElm, 'class');\n\tvar backgroundimage = getStyle(tdElm, 'background', 'backgroundImage').replace(new RegExp(\"url\\\\(['\\\"]?([^'\\\"]*)['\\\"]?\\\\)\", 'gi'), \"$1\");\n\tvar id = ed.dom.getAttrib(tdElm, 'id');\n\tvar lang = ed.dom.getAttrib(tdElm, 'lang');\n\tvar dir = ed.dom.getAttrib(tdElm, 'dir');\n\tvar scope = ed.dom.getAttrib(tdElm, 'scope');\n\n\t// Setup form\n\taddClassesToList('class', 'table_cell_styles');\n\tTinyMCE_EditableSelects.init();\n\n\tif (!ed.dom.hasClass(tdElm, 'mceSelected')) {\n\t\tformObj.bordercolor.value = bordercolor;\n\t\tformObj.bgcolor.value = bgcolor;\n\t\tformObj.backgroundimage.value = backgroundimage;\n\t\tformObj.width.value = width;\n\t\tformObj.height.value = height;\n\t\tformObj.id.value = id;\n\t\tformObj.lang.value = lang;\n\t\tformObj.style.value = ed.dom.serializeStyle(st);\n\t\tselectByValue(formObj, 'align', align);\n\t\tselectByValue(formObj, 'valign', valign);\n\t\tselectByValue(formObj, 'class', className, true, true);\n\t\tselectByValue(formObj, 'celltype', celltype);\n\t\tselectByValue(formObj, 'dir', dir);\n\t\tselectByValue(formObj, 'scope', scope);\n\n\t\t// Resize some elements\n\t\tif (isVisible('backgroundimagebrowser'))\n\t\t\tdocument.getElementById('backgroundimage').style.width = '180px';\n\n\t\tupdateColor('bordercolor_pick', 'bordercolor');\n\t\tupdateColor('bgcolor_pick', 'bgcolor');\n\t} else\n\t\ttinyMCEPopup.dom.hide('action');\n}\n\nfunction updateAction() {\n\tvar el, inst = ed, tdElm, trElm, tableElm, formObj = document.forms[0];\n\n\tif (!AutoValidator.validate(formObj)) {\n\t\ttinyMCEPopup.alert(AutoValidator.getErrorMessages(formObj).join('. ') + '.');\n\t\treturn false;\n\t}\n\n\ttinyMCEPopup.restoreSelection();\n\tel = ed.selection.getStart();\n\ttdElm = ed.dom.getParent(el, \"td,th\");\n\ttrElm = ed.dom.getParent(el, \"tr\");\n\ttableElm = ed.dom.getParent(el, \"table\");\n\n\t// Cell is selected\n\tif (ed.dom.hasClass(tdElm, 'mceSelected')) {\n\t\t// Update all selected sells\n\t\ttinymce.each(ed.dom.select('td.mceSelected,th.mceSelected'), function(td) {\n\t\t\tupdateCell(td);\n\t\t});\n\n\t\ted.addVisual();\n\t\ted.nodeChanged();\n\t\tinst.execCommand('mceEndUndoLevel');\n\t\ttinyMCEPopup.close();\n\t\treturn;\n\t}\n\n\tswitch (getSelectValue(formObj, 'action')) {\n\t\tcase \"cell\":\n\t\t\tvar celltype = getSelectValue(formObj, 'celltype');\n\t\t\tvar scope = getSelectValue(formObj, 'scope');\n\n\t\t\tfunction doUpdate(s) {\n\t\t\t\tif (s) {\n\t\t\t\t\tupdateCell(tdElm);\n\n\t\t\t\t\ted.addVisual();\n\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\tinst.execCommand('mceEndUndoLevel');\n\t\t\t\t\ttinyMCEPopup.close();\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tif (ed.getParam(\"accessibility_warnings\", 1)) {\n\t\t\t\tif (celltype == \"th\" && scope == \"\")\n\t\t\t\t\ttinyMCEPopup.confirm(ed.getLang('table_dlg.missing_scope', '', true), doUpdate);\n\t\t\t\telse\n\t\t\t\t\tdoUpdate(1);\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tupdateCell(tdElm);\n\t\t\tbreak;\n\n\t\tcase \"row\":\n\t\t\tvar cell = trElm.firstChild;\n\n\t\t\tif (cell.nodeName != \"TD\" && cell.nodeName != \"TH\")\n\t\t\t\tcell = nextCell(cell);\n\n\t\t\tdo {\n\t\t\t\tcell = updateCell(cell, true);\n\t\t\t} while ((cell = nextCell(cell)) != null);\n\n\t\t\tbreak;\n\n\t\tcase \"col\":\n\t\t\tvar curr, col = 0, cell = trElm.firstChild, rows = tableElm.getElementsByTagName(\"tr\");\n\n\t\t\tif (cell.nodeName != \"TD\" && cell.nodeName != \"TH\")\n\t\t\t\tcell = nextCell(cell);\n\n\t\t\tdo {\n\t\t\t\tif (cell == tdElm)\n\t\t\t\t\tbreak;\n\t\t\t\tcol += cell.getAttribute(\"colspan\");\n\t\t\t} while ((cell = nextCell(cell)) != null);\n\n\t\t\tfor (var i=0; i<rows.length; i++) {\n\t\t\t\tcell = rows[i].firstChild;\n\n\t\t\t\tif (cell.nodeName != \"TD\" && cell.nodeName != \"TH\")\n\t\t\t\t\tcell = nextCell(cell);\n\n\t\t\t\tcurr = 0;\n\t\t\t\tdo {\n\t\t\t\t\tif (curr == col) {\n\t\t\t\t\t\tcell = updateCell(cell, true);\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t\tcurr += cell.getAttribute(\"colspan\");\n\t\t\t\t} while ((cell = nextCell(cell)) != null);\n\t\t\t}\n\n\t\t\tbreak;\n\n\t\tcase \"all\":\n\t\t\tvar rows = tableElm.getElementsByTagName(\"tr\");\n\n\t\t\tfor (var i=0; i<rows.length; i++) {\n\t\t\t\tvar cell = rows[i].firstChild;\n\n\t\t\t\tif (cell.nodeName != \"TD\" && cell.nodeName != \"TH\")\n\t\t\t\t\tcell = nextCell(cell);\n\n\t\t\t\tdo {\n\t\t\t\t\tcell = updateCell(cell, true);\n\t\t\t\t} while ((cell = nextCell(cell)) != null);\n\t\t\t}\n\n\t\t\tbreak;\n\t}\n\n\ted.addVisual();\n\ted.nodeChanged();\n\tinst.execCommand('mceEndUndoLevel');\n\ttinyMCEPopup.close();\n}\n\nfunction nextCell(elm) {\n\twhile ((elm = elm.nextSibling) != null) {\n\t\tif (elm.nodeName == \"TD\" || elm.nodeName == \"TH\")\n\t\t\treturn elm;\n\t}\n\n\treturn null;\n}\n\nfunction updateCell(td, skip_id) {\n\tvar inst = ed;\n\tvar formObj = document.forms[0];\n\tvar curCellType = td.nodeName.toLowerCase();\n\tvar celltype = getSelectValue(formObj, 'celltype');\n\tvar doc = inst.getDoc();\n\tvar dom = ed.dom;\n\n\tif (!skip_id)\n\t\tdom.setAttrib(td, 'id', formObj.id.value);\n\n\tdom.setAttrib(td, 'align', formObj.align.value);\n\tdom.setAttrib(td, 'vAlign', formObj.valign.value);\n\tdom.setAttrib(td, 'lang', formObj.lang.value);\n\tdom.setAttrib(td, 'dir', getSelectValue(formObj, 'dir'));\n\tdom.setAttrib(td, 'style', ed.dom.serializeStyle(ed.dom.parseStyle(formObj.style.value)));\n\tdom.setAttrib(td, 'scope', formObj.scope.value);\n\tdom.setAttrib(td, 'class', getSelectValue(formObj, 'class'));\n\n\t// Clear deprecated attributes\n\ted.dom.setAttrib(td, 'width', '');\n\ted.dom.setAttrib(td, 'height', '');\n\ted.dom.setAttrib(td, 'bgColor', '');\n\ted.dom.setAttrib(td, 'borderColor', '');\n\ted.dom.setAttrib(td, 'background', '');\n\n\t// Set styles\n\ttd.style.width = getCSSSize(formObj.width.value);\n\ttd.style.height = getCSSSize(formObj.height.value);\n\tif (formObj.bordercolor.value != \"\") {\n\t\ttd.style.borderColor = formObj.bordercolor.value;\n\t\ttd.style.borderStyle = td.style.borderStyle == \"\" ? \"solid\" : td.style.borderStyle;\n\t\ttd.style.borderWidth = td.style.borderWidth == \"\" ? \"1px\" : td.style.borderWidth;\n\t} else\n\t\ttd.style.borderColor = '';\n\n\ttd.style.backgroundColor = formObj.bgcolor.value;\n\n\tif (formObj.backgroundimage.value != \"\")\n\t\ttd.style.backgroundImage = \"url('\" + formObj.backgroundimage.value + \"')\";\n\telse\n\t\ttd.style.backgroundImage = '';\n\n\tif (curCellType != celltype) {\n\t\t// changing to a different node type\n\t\tvar newCell = doc.createElement(celltype);\n\n\t\tfor (var c=0; c<td.childNodes.length; c++)\n\t\t\tnewCell.appendChild(td.childNodes[c].cloneNode(1));\n\n\t\tfor (var a=0; a<td.attributes.length; a++)\n\t\t\ted.dom.setAttrib(newCell, td.attributes[a].name, ed.dom.getAttrib(td, td.attributes[a].name));\n\n\t\ttd.parentNode.replaceChild(newCell, td);\n\t\ttd = newCell;\n\t}\n\n\tdom.setAttrib(td, 'style', dom.serializeStyle(dom.parseStyle(td.style.cssText)));\n\n\treturn td;\n}\n\nfunction changedBackgroundImage() {\n\tvar formObj = document.forms[0];\n\tvar st = ed.dom.parseStyle(formObj.style.value);\n\n\tst['background-image'] = \"url('\" + formObj.backgroundimage.value + \"')\";\n\n\tformObj.style.value = ed.dom.serializeStyle(st);\n}\n\nfunction changedSize() {\n\tvar formObj = document.forms[0];\n\tvar st = ed.dom.parseStyle(formObj.style.value);\n\n\tvar width = formObj.width.value;\n\tif (width != \"\")\n\t\tst['width'] = getCSSSize(width);\n\telse\n\t\tst['width'] = \"\";\n\n\tvar height = formObj.height.value;\n\tif (height != \"\")\n\t\tst['height'] = getCSSSize(height);\n\telse\n\t\tst['height'] = \"\";\n\n\tformObj.style.value = ed.dom.serializeStyle(st);\n}\n\nfunction changedColor() {\n\tvar formObj = document.forms[0];\n\tvar st = ed.dom.parseStyle(formObj.style.value);\n\n\tst['background-color'] = formObj.bgcolor.value;\n\tst['border-color'] = formObj.bordercolor.value;\n\n\tformObj.style.value = ed.dom.serializeStyle(st);\n}\n\nfunction changedStyle() {\n\tvar formObj = document.forms[0];\n\tvar st = ed.dom.parseStyle(formObj.style.value);\n\n\tif (st['background-image'])\n\t\tformObj.backgroundimage.value = st['background-image'].replace(new RegExp(\"url\\\\('?([^']*)'?\\\\)\", 'gi'), \"$1\");\n\telse\n\t\tformObj.backgroundimage.value = '';\n\n\tif (st['width'])\n\t\tformObj.width.value = trimSize(st['width']);\n\n\tif (st['height'])\n\t\tformObj.height.value = trimSize(st['height']);\n\n\tif (st['background-color']) {\n\t\tformObj.bgcolor.value = st['background-color'];\n\t\tupdateColor('bgcolor_pick','bgcolor');\n\t}\n\n\tif (st['border-color']) {\n\t\tformObj.bordercolor.value = st['border-color'];\n\t\tupdateColor('bordercolor_pick','bordercolor');\n\t}\n}\n\ntinyMCEPopup.onInit.add(init);\n","Magento_Tinymce3/tiny_mce/plugins/table/js/merge_cells.js":"tinyMCEPopup.requireLangPack();\n\nvar MergeCellsDialog = {\n\tinit : function() {\n\t\tvar f = document.forms[0];\n\n\t\tf.numcols.value = tinyMCEPopup.getWindowArg('cols', 1);\n\t\tf.numrows.value = tinyMCEPopup.getWindowArg('rows', 1);\n\t},\n\n\tmerge : function() {\n\t\tvar func, f = document.forms[0];\n\n\t\ttinyMCEPopup.restoreSelection();\n\n\t\tfunc = tinyMCEPopup.getWindowArg('onaction');\n\n\t\tfunc({\n\t\t\tcols : f.numcols.value,\n\t\t\trows : f.numrows.value\n\t\t});\n\n\t\ttinyMCEPopup.close();\n\t}\n};\n\ntinyMCEPopup.onInit.add(MergeCellsDialog.init, MergeCellsDialog);\n","Magento_Tinymce3/tiny_mce/plugins/table/langs/en_dlg.js":"tinyMCE.addI18n('en.table_dlg',{\"rules_border\":\"border\",\"rules_box\":\"box\",\"rules_vsides\":\"vsides\",\"rules_rhs\":\"rhs\",\"rules_lhs\":\"lhs\",\"rules_hsides\":\"hsides\",\"rules_below\":\"below\",\"rules_above\":\"above\",\"rules_void\":\"void\",rules:\"Rules\",\"frame_all\":\"all\",\"frame_cols\":\"cols\",\"frame_rows\":\"rows\",\"frame_groups\":\"groups\",\"frame_none\":\"none\",frame:\"Frame\",caption:\"Table Caption\",\"missing_scope\":\"Are you sure you want to continue without specifying a scope for this table header cell. Without it, it may be difficult for some users with disabilities to understand the content or data displayed of the table.\",\"cell_limit\":\"You\\'ve exceeded the maximum number of cells of {$cells}.\",\"row_limit\":\"You\\'ve exceeded the maximum number of rows of {$rows}.\",\"col_limit\":\"You\\'ve exceeded the maximum number of columns of {$cols}.\",colgroup:\"Col Group\",rowgroup:\"Row Group\",scope:\"Scope\",tfoot:\"Footer\",tbody:\"Body\",thead:\"Header\",\"row_all\":\"Update All Rows in Table\",\"row_even\":\"Update Even Rows in Table\",\"row_odd\":\"Update Odd Rows in Table\",\"row_row\":\"Update Current Row\",\"cell_all\":\"Update All Cells in Table\",\"cell_row\":\"Update All Cells in Row\",\"cell_cell\":\"Update Current Cell\",th:\"Header\",td:\"Data\",summary:\"Summary\",bgimage:\"Background Image\",rtl:\"Right to Left\",ltr:\"Left to Right\",mime:\"Target MIME Type\",langcode:\"Language Code\",langdir:\"Language Direction\",style:\"Style\",id:\"ID\",\"merge_cells_title\":\"Merge Table Cells\",bgcolor:\"Background Color\",bordercolor:\"Border Color\",\"align_bottom\":\"Bottom\",\"align_top\":\"Top\",valign:\"Vertical Alignment\",\"cell_type\":\"Cell Type\",\"cell_title\":\"Table Cell Properties\",\"row_title\":\"Table Row Properties\",\"align_middle\":\"Center\",\"align_right\":\"Right\",\"align_left\":\"Left\",\"align_default\":\"Default\",align:\"Alignment\",border:\"Border\",cellpadding:\"Cell Padding\",cellspacing:\"Cell Spacing\",rows:\"Rows\",cols:\"Columns\",height:\"Height\",width:\"Width\",title:\"Insert/Edit Table\",rowtype:\"Row Type\",\"advanced_props\":\"Advanced Properties\",\"general_props\":\"General Properties\",\"advanced_tab\":\"Advanced\",\"general_tab\":\"General\",\"cell_col\":\"Update all cells in column\"});","Magento_Tinymce3/tiny_mce/plugins/emotions/editor_plugin.js":"(function(a){a.create(\"tinymce.plugins.EmotionsPlugin\",{init:function(b,c){b.addCommand(\"mceEmotion\",function(){b.windowManager.open({file:c+\"/emotions.htm\",width:250+parseInt(b.getLang(\"emotions.delta_width\",0)),height:160+parseInt(b.getLang(\"emotions.delta_height\",0)),inline:1},{plugin_url:c})});b.addButton(\"emotions\",{title:\"emotions.emotions_desc\",cmd:\"mceEmotion\"})},getInfo:function(){return{longname:\"Emotions\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/emotions\",version:a.majorVersion+\".\"+a.minorVersion}}});a.PluginManager.add(\"emotions\",a.plugins.EmotionsPlugin)})(tinymce);","Magento_Tinymce3/tiny_mce/plugins/emotions/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\ttinymce.create('tinymce.plugins.EmotionsPlugin', {\n\t\tinit : function(ed, url) {\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceEmotion', function() {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/emotions.htm',\n\t\t\t\t\twidth : 250 + parseInt(ed.getLang('emotions.delta_width', 0)),\n\t\t\t\t\theight : 160 + parseInt(ed.getLang('emotions.delta_height', 0)),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('emotions', {title : 'emotions.emotions_desc', cmd : 'mceEmotion'});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Emotions',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/emotions',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('emotions', tinymce.plugins.EmotionsPlugin);\n})(tinymce);","Magento_Tinymce3/tiny_mce/plugins/emotions/js/emotions.js":"tinyMCEPopup.requireLangPack();\n\nvar EmotionsDialog = {\n\taddKeyboardNavigation: function(){\n\t\tvar tableElm, cells, settings;\n\t\t\t\n\t\tcells = tinyMCEPopup.dom.select(\"a.emoticon_link\", \"emoticon_table\");\n\t\t\t\n\t\tsettings ={\n\t\t\troot: \"emoticon_table\",\n\t\t\titems: cells\n\t\t};\n\t\tcells[0].tabindex=0;\n\t\ttinyMCEPopup.dom.addClass(cells[0], \"mceFocus\");\n\t\tif (tinymce.isGecko) {\n\t\t\tcells[0].focus();\t\t\n\t\t} else {\n\t\t\tsetTimeout(function(){\n\t\t\t\tcells[0].focus();\n\t\t\t}, 100);\n\t\t}\n\t\ttinyMCEPopup.editor.windowManager.createInstance('tinymce.ui.KeyboardNavigation', settings, tinyMCEPopup.dom);\n\t}, \n\tinit : function(ed) {\n\t\ttinyMCEPopup.resizeToInnerSize();\n\t\tthis.addKeyboardNavigation();\n\t},\n\n\tinsert : function(file, title) {\n\t\tvar ed = tinyMCEPopup.editor, dom = ed.dom;\n\n\t\ttinyMCEPopup.execCommand('mceInsertContent', false, dom.createHTML('img', {\n\t\t\tsrc : tinyMCEPopup.getWindowArg('plugin_url') + '/img/' + file,\n\t\t\talt : ed.getLang(title),\n\t\t\ttitle : ed.getLang(title),\n\t\t\tborder : 0\n\t\t}));\n\n\t\ttinyMCEPopup.close();\n\t}\n};\n\ntinyMCEPopup.onInit.add(EmotionsDialog.init, EmotionsDialog);\n","Magento_Tinymce3/tiny_mce/plugins/emotions/langs/en_dlg.js":"tinyMCE.addI18n('en.emotions_dlg',{cry:\"Cry\",cool:\"Cool\",desc:\"Emotions\",title:\"Insert Emotion\",usage:\"Use left and right arrows to navigate.\",yell:\"Yell\",wink:\"Wink\",undecided:\"Undecided\",\"tongue_out\":\"Tongue Out\",surprised:\"Surprised\",smile:\"Smile\",sealed:\"Sealed\",\"money_mouth\":\"Money Mouth\",laughing:\"Laughing\",kiss:\"Kiss\",innocent:\"Innocent\",frown:\"Frown\",\"foot_in_mouth\":\"Foot in Mouth\",embarassed:\"Embarassed\"});\n","Magento_Tinymce3/tiny_mce/plugins/iespell/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.IESpell\",{init:function(a,b){var c=this,d;if(!tinymce.isIE){return}c.editor=a;a.addCommand(\"mceIESpell\",function(){try{d=new ActiveXObject(\"ieSpell.ieSpellExtension\");d.CheckDocumentNode(a.getDoc().documentElement)}catch(f){if(f.number==-2146827859){a.windowManager.confirm(a.getLang(\"iespell.download\"),function(e){if(e){window.open(\"http://www.iespell.com/download.php\",\"ieSpellDownload\",\"\")}})}else{a.windowManager.alert(\"Error Loading ieSpell: Exception \"+f.number)}}});a.addButton(\"iespell\",{title:\"iespell.iespell_desc\",cmd:\"mceIESpell\"})},getInfo:function(){return{longname:\"IESpell (IE Only)\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/iespell\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"iespell\",tinymce.plugins.IESpell)})();","Magento_Tinymce3/tiny_mce/plugins/iespell/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.IESpell', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this, sp;\n\n\t\t\tif (!tinymce.isIE)\n\t\t\t\treturn;\n\n\t\t\tt.editor = ed;\n\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceIESpell', function() {\n\t\t\t\ttry {\n\t\t\t\t\tsp = new ActiveXObject(\"ieSpell.ieSpellExtension\");\n\t\t\t\t\tsp.CheckDocumentNode(ed.getDoc().documentElement);\n\t\t\t\t} catch (e) {\n\t\t\t\t\tif (e.number == -2146827859) {\n\t\t\t\t\t\ted.windowManager.confirm(ed.getLang(\"iespell.download\"), function(s) {\n\t\t\t\t\t\t\tif (s)\n\t\t\t\t\t\t\t\twindow.open('http://www.iespell.com/download.php', 'ieSpellDownload', '');\n\t\t\t\t\t\t});\n\t\t\t\t\t} else\n\t\t\t\t\t\ted.windowManager.alert(\"Error Loading ieSpell: Exception \" + e.number);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('iespell', {title : 'iespell.iespell_desc', cmd : 'mceIESpell'});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'IESpell (IE Only)',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/iespell',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('iespell', tinymce.plugins.IESpell);\n})();","Magento_Tinymce3/tiny_mce/plugins/preview/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.Preview\",{init:function(a,b){var d=this,c=tinymce.explode(a.settings.content_css);d.editor=a;tinymce.each(c,function(f,e){c[e]=a.documentBaseURI.toAbsolute(f)});a.addCommand(\"mcePreview\",function(){a.windowManager.open({file:a.getParam(\"plugin_preview_pageurl\",b+\"/preview.html\"),width:parseInt(a.getParam(\"plugin_preview_width\",\"550\")),height:parseInt(a.getParam(\"plugin_preview_height\",\"600\")),resizable:\"yes\",scrollbars:\"yes\",popup_css:c?c.join(\",\"):a.baseURI.toAbsolute(\"themes/\"+a.settings.theme+\"/skins/\"+a.settings.skin+\"/content.css\"),inline:a.getParam(\"plugin_preview_inline\",1)},{base:a.documentBaseURI.getURI()})});a.addButton(\"preview\",{title:\"preview.preview_desc\",cmd:\"mcePreview\"})},getInfo:function(){return{longname:\"Preview\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/preview\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"preview\",tinymce.plugins.Preview)})();","Magento_Tinymce3/tiny_mce/plugins/preview/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.Preview', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this, css = tinymce.explode(ed.settings.content_css);\n\n\t\t\tt.editor = ed;\n\n\t\t\t// Force absolute CSS urls\t\n\t\t\ttinymce.each(css, function(u, k) {\n\t\t\t\tcss[k] = ed.documentBaseURI.toAbsolute(u);\n\t\t\t});\n\n\t\t\ted.addCommand('mcePreview', function() {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : ed.getParam(\"plugin_preview_pageurl\", url + \"/preview.html\"),\n\t\t\t\t\twidth : parseInt(ed.getParam(\"plugin_preview_width\", \"550\")),\n\t\t\t\t\theight : parseInt(ed.getParam(\"plugin_preview_height\", \"600\")),\n\t\t\t\t\tresizable : \"yes\",\n\t\t\t\t\tscrollbars : \"yes\",\n\t\t\t\t\tpopup_css : css ? css.join(',') : ed.baseURI.toAbsolute(\"themes/\" + ed.settings.theme + \"/skins/\" + ed.settings.skin + \"/content.css\"),\n\t\t\t\t\tinline : ed.getParam(\"plugin_preview_inline\", 1)\n\t\t\t\t}, {\n\t\t\t\t\tbase : ed.documentBaseURI.getURI()\n\t\t\t\t});\n\t\t\t});\n\n\t\t\ted.addButton('preview', {title : 'preview.preview_desc', cmd : 'mcePreview'});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Preview',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/preview',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('preview', tinymce.plugins.Preview);\n})();","Magento_Tinymce3/tiny_mce/plugins/preview/jscripts/embed.js":"/**\n * This script contains embed functions for common plugins. This scripts are complety free to use for any purpose.\n */\n\nfunction writeFlash(p) {\n\twriteEmbed(\n\t\t'D27CDB6E-AE6D-11cf-96B8-444553540000',\n\t\t'http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0',\n\t\t'application/x-shockwave-flash',\n\t\tp\n\t);\n}\n\nfunction writeShockWave(p) {\n\twriteEmbed(\n\t'166B1BCA-3F9C-11CF-8075-444553540000',\n\t'http://download.macromedia.com/pub/shockwave/cabs/director/sw.cab#version=8,5,1,0',\n\t'application/x-director',\n\t\tp\n\t);\n}\n\nfunction writeQuickTime(p) {\n\twriteEmbed(\n\t\t'02BF25D5-8C17-4B23-BC80-D3488ABDDC6B',\n\t\t'http://www.apple.com/qtactivex/qtplugin.cab#version=6,0,2,0',\n\t\t'video/quicktime',\n\t\tp\n\t);\n}\n\nfunction writeRealMedia(p) {\n\twriteEmbed(\n\t\t'CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA',\n\t\t'http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0',\n\t\t'audio/x-pn-realaudio-plugin',\n\t\tp\n\t);\n}\n\nfunction writeWindowsMedia(p) {\n\tp.url = p.src;\n\twriteEmbed(\n\t\t'6BF52A52-394A-11D3-B153-00C04F79FAA6',\n\t\t'http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=5,1,52,701',\n\t\t'application/x-mplayer2',\n\t\tp\n\t);\n}\n\nfunction writeEmbed(cls, cb, mt, p) {\n\tvar h = '', n;\n\n\th += '<object classid=\"clsid:' + cls + '\" codebase=\"' + cb + '\"';\n\th += typeof(p.id) != \"undefined\" ? 'id=\"' + p.id + '\"' : '';\n\th += typeof(p.name) != \"undefined\" ? 'name=\"' + p.name + '\"' : '';\n\th += typeof(p.width) != \"undefined\" ? 'width=\"' + p.width + '\"' : '';\n\th += typeof(p.height) != \"undefined\" ? 'height=\"' + p.height + '\"' : '';\n\th += typeof(p.align) != \"undefined\" ? 'align=\"' + p.align + '\"' : '';\n\th += '>';\n\n\tfor (n in p)\n\t\th += '<param name=\"' + n + '\" value=\"' + p[n] + '\">';\n\n\th += '<embed type=\"' + mt + '\"';\n\n\tfor (n in p)\n\t\th += n + '=\"' + p[n] + '\" ';\n\n\th += '></embed></object>';\n\n\tdocument.write(h);\n}\n","Magento_Tinymce3/tiny_mce/plugins/paste/editor_plugin.js":"(function(){var c=tinymce.each,a={paste_auto_cleanup_on_paste:true,paste_enable_default_filters:true,paste_block_drop:false,paste_retain_style_properties:\"none\",paste_strip_class_attributes:\"mso\",paste_remove_spans:false,paste_remove_styles:false,paste_remove_styles_if_webkit:true,paste_convert_middot_lists:true,paste_convert_headers_to_strong:false,paste_dialog_width:\"450\",paste_dialog_height:\"400\",paste_text_use_dialog:false,paste_text_sticky:false,paste_text_sticky_default:false,paste_text_notifyalways:false,paste_text_linebreaktype:\"combined\",paste_text_replacements:[[/\\u2026/g,\"...\"],[/[\\x93\\x94\\u201c\\u201d]/g,'\"'],[/[\\x60\\x91\\x92\\u2018\\u2019]/g,\"'\"]]};function b(d,e){return d.getParam(e,a[e])}tinymce.create(\"tinymce.plugins.PastePlugin\",{init:function(d,e){var f=this;f.editor=d;f.url=e;f.onPreProcess=new tinymce.util.Dispatcher(f);f.onPostProcess=new tinymce.util.Dispatcher(f);f.onPreProcess.add(f._preProcess);f.onPostProcess.add(f._postProcess);f.onPreProcess.add(function(i,j){d.execCallback(\"paste_preprocess\",i,j)});f.onPostProcess.add(function(i,j){d.execCallback(\"paste_postprocess\",i,j)});d.onKeyDown.addToTop(function(i,j){if(((tinymce.isMac?j.metaKey:j.ctrlKey)&&j.keyCode==86)||(j.shiftKey&&j.keyCode==45)){return false}});d.pasteAsPlainText=b(d,\"paste_text_sticky_default\");function h(l,j){var k=d.dom,i;f.onPreProcess.dispatch(f,l);l.node=k.create(\"div\",0,l.content);if(tinymce.isGecko){i=d.selection.getRng(true);if(i.startContainer==i.endContainer&&i.startContainer.nodeType==3){if(l.node.childNodes.length===1&&/^(p|h[1-6]|pre)$/i.test(l.node.firstChild.nodeName)&&l.content.indexOf(\"__MCE_ITEM__\")===-1){k.remove(l.node.firstChild,true)}}}f.onPostProcess.dispatch(f,l);l.content=d.serializer.serialize(l.node,{getInner:1,forced_root_block:\"\"});if((!j)&&(d.pasteAsPlainText)){f._insertPlainText(l.content);if(!b(d,\"paste_text_sticky\")){d.pasteAsPlainText=false;d.controlManager.setActive(\"pastetext\",false)}}else{f._insert(l.content)}}d.addCommand(\"mceInsertClipboardContent\",function(i,j){h(j,true)});if(!b(d,\"paste_text_use_dialog\")){d.addCommand(\"mcePasteText\",function(j,i){var k=tinymce.util.Cookie;d.pasteAsPlainText=!d.pasteAsPlainText;d.controlManager.setActive(\"pastetext\",d.pasteAsPlainText);if((d.pasteAsPlainText)&&(!k.get(\"tinymcePasteText\"))){if(b(d,\"paste_text_sticky\")){d.windowManager.alert(d.translate(\"paste.plaintext_mode_sticky\"))}else{d.windowManager.alert(d.translate(\"paste.plaintext_mode\"))}if(!b(d,\"paste_text_notifyalways\")){k.set(\"tinymcePasteText\",\"1\",new Date(new Date().getFullYear()+1,12,31))}}})}d.addButton(\"pastetext\",{title:\"paste.paste_text_desc\",cmd:\"mcePasteText\"});d.addButton(\"selectall\",{title:\"paste.selectall_desc\",cmd:\"selectall\"});function g(s){var l,p,j,t,k=d.selection,o=d.dom,q=d.getBody(),i,r;if(s.clipboardData||o.doc.dataTransfer){r=(s.clipboardData||o.doc.dataTransfer).getData(\"Text\");if(d.pasteAsPlainText){s.preventDefault();h({content:o.encode(r).replace(/\\r?\\n/g,\"<br />\")});return}}if(o.get(\"_mcePaste\")){return}l=o.add(q,\"div\",{id:\"_mcePaste\",\"class\":\"mcePaste\",\"data-mce-bogus\":\"1\"},\"\\uFEFF\\uFEFF\");if(q!=d.getDoc().body){i=o.getPos(d.selection.getStart(),q).y}else{i=q.scrollTop+o.getViewPort(d.getWin()).y}o.setStyles(l,{position:\"absolute\",left:tinymce.isGecko?-40:0,top:i-25,width:1,height:1,overflow:\"hidden\"});if(tinymce.isIE){t=k.getRng();j=o.doc.body.createTextRange();j.moveToElementText(l);j.execCommand(\"Paste\");o.remove(l);if(l.innerHTML===\"\\uFEFF\\uFEFF\"){d.execCommand(\"mcePasteWord\");s.preventDefault();return}k.setRng(t);k.setContent(\"\");setTimeout(function(){h({content:l.innerHTML})},0);return tinymce.dom.Event.cancel(s)}else{function m(n){n.preventDefault()}o.bind(d.getDoc(),\"mousedown\",m);o.bind(d.getDoc(),\"keydown\",m);p=d.selection.getRng();l=l.firstChild;j=d.getDoc().createRange();j.setStart(l,0);j.setEnd(l,2);k.setRng(j);window.setTimeout(function(){var u=\"\",n;if(!o.select(\"div.mcePaste > div.mcePaste\").length){n=o.select(\"div.mcePaste\");c(n,function(w){var v=w.firstChild;if(v&&v.nodeName==\"DIV\"&&v.style.marginTop&&v.style.backgroundColor){o.remove(v,1)}c(o.select(\"span.Apple-style-span\",w),function(x){o.remove(x,1)});c(o.select(\"br[data-mce-bogus]\",w),function(x){o.remove(x)});if(w.parentNode.className!=\"mcePaste\"){u+=w.innerHTML}})}else{u=\"<p>\"+o.encode(r).replace(/\\r?\\n\\r?\\n/g,\"</p><p>\").replace(/\\r?\\n/g,\"<br />\")+\"</p>\"}c(o.select(\"div.mcePaste\"),function(v){o.remove(v)});if(p){k.setRng(p)}h({content:u});o.unbind(d.getDoc(),\"mousedown\",m);o.unbind(d.getDoc(),\"keydown\",m)},0)}}if(b(d,\"paste_auto_cleanup_on_paste\")){if(tinymce.isOpera||/Firefox\\/2/.test(navigator.userAgent)){d.onKeyDown.addToTop(function(i,j){if(((tinymce.isMac?j.metaKey:j.ctrlKey)&&j.keyCode==86)||(j.shiftKey&&j.keyCode==45)){g(j)}})}else{d.onPaste.addToTop(function(i,j){return g(j)})}}d.onInit.add(function(){d.controlManager.setActive(\"pastetext\",d.pasteAsPlainText);if(b(d,\"paste_block_drop\")){d.dom.bind(d.getBody(),[\"dragend\",\"dragover\",\"draggesture\",\"dragdrop\",\"drop\",\"drag\"],function(i){i.preventDefault();i.stopPropagation();return false})}});f._legacySupport()},getInfo:function(){return{longname:\"Paste text/word\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/paste\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}},_preProcess:function(g,e){var k=this.editor,j=e.content,p=tinymce.grep,n=tinymce.explode,f=tinymce.trim,l,i;function d(h){c(h,function(o){if(o.constructor==RegExp){j=j.replace(o,\"\")}else{j=j.replace(o[0],o[1])}})}if(k.settings.paste_enable_default_filters==false){return}if(tinymce.isIE&&document.documentMode>=9){d([[/(?:<br>&nbsp;[\\s\\r\\n]+|<br>)*(<\\/?(h[1-6r]|p|div|address|pre|form|table|tbody|thead|tfoot|th|tr|td|li|ol|ul|caption|blockquote|center|dl|dt|dd|dir|fieldset)[^>]*>)(?:<br>&nbsp;[\\s\\r\\n]+|<br>)*/g,\"$1\"]]);d([[/<br><br>/g,\"<BR><BR>\"],[/<br>/g,\" \"],[/<BR><BR>/g,\"<br>\"]])}if(/class=\"?Mso|style=\"[^\"]*\\bmso-|w:WordDocument/i.test(j)||e.wordContent){e.wordContent=true;d([/^\\s*(&nbsp;)+/gi,/(&nbsp;|<br[^>]*>)+\\s*$/gi]);if(b(k,\"paste_convert_headers_to_strong\")){j=j.replace(/<p [^>]*class=\"?MsoHeading\"?[^>]*>(.*?)<\\/p>/gi,\"<p><strong>$1</strong></p>\")}if(b(k,\"paste_convert_middot_lists\")){d([[/<!--\\[if !supportLists\\]-->/gi,\"$&__MCE_ITEM__\"],[/(<span[^>]+(?:mso-list:|:\\s*symbol)[^>]+>)/gi,\"$1__MCE_ITEM__\"],[/(<p[^>]+(?:MsoListParagraph)[^>]+>)/gi,\"$1__MCE_ITEM__\"]])}d([/<!--[\\s\\S]+?-->/gi,/<(!|script[^>]*>.*?<\\/script(?=[>\\s])|\\/?(\\?xml(:\\w+)?|img|meta|link|style|\\w:\\w+)(?=[\\s\\/>]))[^>]*>/gi,[/<(\\/?)s>/gi,\"<$1strike>\"],[/&nbsp;/gi,\"\\u00a0\"]]);do{l=j.length;j=j.replace(/(<[a-z][^>]*\\s)(?:id|name|language|type|on\\w+|\\w+:\\w+)=(?:\"[^\"]*\"|\\w+)\\s?/gi,\"$1\")}while(l!=j.length);if(b(k,\"paste_retain_style_properties\").replace(/^none$/i,\"\").length==0){j=j.replace(/<\\/?span[^>]*>/gi,\"\")}else{d([[/<span\\s+style\\s*=\\s*\"\\s*mso-spacerun\\s*:\\s*yes\\s*;?\\s*\"\\s*>([\\s\\u00a0]*)<\\/span>/gi,function(o,h){return(h.length>0)?h.replace(/./,\" \").slice(Math.floor(h.length/2)).split(\"\").join(\"\\u00a0\"):\"\"}],[/(<[a-z][^>]*)\\sstyle=\"([^\"]*)\"/gi,function(t,h,r){var u=[],o=0,q=n(f(r).replace(/&quot;/gi,\"'\"),\";\");c(q,function(s){var w,y,z=n(s,\":\");function x(A){return A+((A!==\"0\")&&(/\\d$/.test(A)))?\"px\":\"\"}if(z.length==2){w=z[0].toLowerCase();y=z[1].toLowerCase();switch(w){case\"mso-padding-alt\":case\"mso-padding-top-alt\":case\"mso-padding-right-alt\":case\"mso-padding-bottom-alt\":case\"mso-padding-left-alt\":case\"mso-margin-alt\":case\"mso-margin-top-alt\":case\"mso-margin-right-alt\":case\"mso-margin-bottom-alt\":case\"mso-margin-left-alt\":case\"mso-table-layout-alt\":case\"mso-height\":case\"mso-width\":case\"mso-vertical-align-alt\":u[o++]=w.replace(/^mso-|-alt$/g,\"\")+\":\"+x(y);return;case\"horiz-align\":u[o++]=\"text-align:\"+y;return;case\"vert-align\":u[o++]=\"vertical-align:\"+y;return;case\"font-color\":case\"mso-foreground\":u[o++]=\"color:\"+y;return;case\"mso-background\":case\"mso-highlight\":u[o++]=\"background:\"+y;return;case\"mso-default-height\":u[o++]=\"min-height:\"+x(y);return;case\"mso-default-width\":u[o++]=\"min-width:\"+x(y);return;case\"mso-padding-between-alt\":u[o++]=\"border-collapse:separate;border-spacing:\"+x(y);return;case\"text-line-through\":if((y==\"single\")||(y==\"double\")){u[o++]=\"text-decoration:line-through\"}return;case\"mso-zero-height\":if(y==\"yes\"){u[o++]=\"display:none\"}return}if(/^(mso|column|font-emph|lang|layout|line-break|list-image|nav|panose|punct|row|ruby|sep|size|src|tab-|table-border|text-(?!align|decor|indent|trans)|top-bar|version|vnd|word-break)/.test(w)){return}u[o++]=w+\":\"+z[1]}});if(o>0){return h+' style=\"'+u.join(\";\")+'\"'}else{return h}}]])}}if(b(k,\"paste_convert_headers_to_strong\")){d([[/<h[1-6][^>]*>/gi,\"<p><strong>\"],[/<\\/h[1-6][^>]*>/gi,\"</strong></p>\"]])}d([[/Version:[\\d.]+\\nStartHTML:\\d+\\nEndHTML:\\d+\\nStartFragment:\\d+\\nEndFragment:\\d+/gi,\"\"]]);i=b(k,\"paste_strip_class_attributes\");if(i!==\"none\"){function m(q,o){if(i===\"all\"){return\"\"}var h=p(n(o.replace(/^([\"'])(.*)\\1$/,\"$2\"),\" \"),function(r){return(/^(?!mso)/i.test(r))});return h.length?' class=\"'+h.join(\" \")+'\"':\"\"}j=j.replace(/ class=\"([^\"]+)\"/gi,m);j=j.replace(/ class=([\\-\\w]+)/gi,m)}if(b(k,\"paste_remove_spans\")){j=j.replace(/<\\/?span[^>]*>/gi,\"\")}e.content=j},_postProcess:function(g,i){var f=this,e=f.editor,h=e.dom,d;if(e.settings.paste_enable_default_filters==false){return}if(i.wordContent){c(h.select(\"a\",i.node),function(j){if(!j.href||j.href.indexOf(\"#_Toc\")!=-1){h.remove(j,1)}});if(b(e,\"paste_convert_middot_lists\")){f._convertLists(g,i)}d=b(e,\"paste_retain_style_properties\");if((tinymce.is(d,\"string\"))&&(d!==\"all\")&&(d!==\"*\")){d=tinymce.explode(d.replace(/^none$/i,\"\"));c(h.select(\"*\",i.node),function(m){var n={},k=0,l,o,j;if(d){for(l=0;l<d.length;l++){o=d[l];j=h.getStyle(m,o);if(j){n[o]=j;k++}}}h.setAttrib(m,\"style\",\"\");if(d&&k>0){h.setStyles(m,n)}else{if(m.nodeName==\"SPAN\"&&!m.className){h.remove(m,true)}}})}}if(b(e,\"paste_remove_styles\")||(b(e,\"paste_remove_styles_if_webkit\")&&tinymce.isWebKit)){c(h.select(\"*[style]\",i.node),function(j){j.removeAttribute(\"style\");j.removeAttribute(\"data-mce-style\")})}else{if(tinymce.isWebKit){c(h.select(\"*\",i.node),function(j){j.removeAttribute(\"data-mce-style\")})}}},_convertLists:function(g,e){var i=g.editor.dom,h,l,d=-1,f,m=[],k,j;c(i.select(\"p\",e.node),function(t){var q,u=\"\",s,r,n,o;for(q=t.firstChild;q&&q.nodeType==3;q=q.nextSibling){u+=q.nodeValue}u=t.innerHTML.replace(/<\\/?\\w+[^>]*>/gi,\"\").replace(/&nbsp;/g,\"\\u00a0\");if(/^(__MCE_ITEM__)+[\\u2022\\u00b7\\u00a7\\u00d8o\\u25CF]\\s*\\u00a0*/.test(u)){s=\"ul\"}if(/^__MCE_ITEM__\\s*\\w+\\.\\s*\\u00a0+/.test(u)){s=\"ol\"}if(s){f=parseFloat(t.style.marginLeft||0);if(f>d){m.push(f)}if(!h||s!=k){h=i.create(s);i.insertAfter(h,t)}else{if(f>d){h=l.appendChild(i.create(s))}else{if(f<d){n=tinymce.inArray(m,f);o=i.getParents(h.parentNode,s);h=o[o.length-1-n]||h}}}c(i.select(\"span\",t),function(v){var p=v.innerHTML.replace(/<\\/?\\w+[^>]*>/gi,\"\");if(s==\"ul\"&&/^__MCE_ITEM__[\\u2022\\u00b7\\u00a7\\u00d8o\\u25CF]/.test(p)){i.remove(v)}else{if(/^__MCE_ITEM__[\\s\\S]*\\w+\\.(&nbsp;|\\u00a0)*\\s*/.test(p)){i.remove(v)}}});r=t.innerHTML;if(s==\"ul\"){r=t.innerHTML.replace(/__MCE_ITEM__/g,\"\").replace(/^[\\u2022\\u00b7\\u00a7\\u00d8o\\u25CF]\\s*(&nbsp;|\\u00a0)+\\s*/,\"\")}else{r=t.innerHTML.replace(/__MCE_ITEM__/g,\"\").replace(/^\\s*\\w+\\.(&nbsp;|\\u00a0)+\\s*/,\"\")}l=h.appendChild(i.create(\"li\",0,r));i.remove(t);d=f;k=s}else{h=d=0}});j=e.node.innerHTML;if(j.indexOf(\"__MCE_ITEM__\")!=-1){e.node.innerHTML=j.replace(/__MCE_ITEM__/g,\"\")}},_insert:function(f,d){var e=this.editor,g=e.selection.getRng();if(!e.selection.isCollapsed()&&g.startContainer!=g.endContainer){e.getDoc().execCommand(\"Delete\",false,null)}e.execCommand(\"mceInsertContent\",false,f,{skip_undo:d})},_insertPlainText:function(g){var d=this.editor,e=b(d,\"paste_text_linebreaktype\"),i=b(d,\"paste_text_replacements\"),f=tinymce.is;function h(j){c(j,function(k){if(k.constructor==RegExp){g=g.replace(k,\"\")}else{g=g.replace(k[0],k[1])}})}if((typeof(g)===\"string\")&&(g.length>0)){if(/<(?:p|br|h[1-6]|ul|ol|dl|table|t[rdh]|div|blockquote|fieldset|pre|address|center)[^>]*>/i.test(g)){h([/[\\n\\r]+/g])}else{h([/\\r+/g])}h([[/<\\/(?:p|h[1-6]|ul|ol|dl|table|div|blockquote|fieldset|pre|address|center)>/gi,\"\\n\\n\"],[/<br[^>]*>|<\\/tr>/gi,\"\\n\"],[/<\\/t[dh]>\\s*<t[dh][^>]*>/gi,\"\\t\"],/<[a-z!\\/?][^>]*>/gi,[/&nbsp;/gi,\" \"],[/(?:(?!\\n)\\s)*(\\n+)(?:(?!\\n)\\s)*/gi,\"$1\"],[/\\n{3,}/g,\"\\n\\n\"]]);g=d.dom.decode(tinymce.html.Entities.encodeRaw(g));if(f(i,\"array\")){h(i)}else{if(f(i,\"string\")){h(new RegExp(i,\"gi\"))}}if(e==\"none\"){h([[/\\n+/g,\" \"]])}else{if(e==\"br\"){h([[/\\n/g,\"<br />\"]])}else{if(e==\"p\"){h([[/\\n+/g,\"</p><p>\"],[/^(.*<\\/p>)(<p>)$/,\"<p>$1\"]])}else{h([[/\\n\\n/g,\"</p><p>\"],[/^(.*<\\/p>)(<p>)$/,\"<p>$1\"],[/\\n/g,\"<br />\"]])}}}d.execCommand(\"mceInsertContent\",false,g)}},_legacySupport:function(){var e=this,d=e.editor;d.addCommand(\"mcePasteWord\",function(){d.windowManager.open({file:e.url+\"/pasteword.htm\",width:parseInt(b(d,\"paste_dialog_width\")),height:parseInt(b(d,\"paste_dialog_height\")),inline:1})});if(b(d,\"paste_text_use_dialog\")){d.addCommand(\"mcePasteText\",function(){d.windowManager.open({file:e.url+\"/pastetext.htm\",width:parseInt(b(d,\"paste_dialog_width\")),height:parseInt(b(d,\"paste_dialog_height\")),inline:1})})}d.addButton(\"pasteword\",{title:\"paste.paste_word_desc\",cmd:\"mcePasteWord\"})}});tinymce.PluginManager.add(\"paste\",tinymce.plugins.PastePlugin)})();","Magento_Tinymce3/tiny_mce/plugins/paste/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\tvar each = tinymce.each,\n\t\tdefs = {\n\t\t\tpaste_auto_cleanup_on_paste : true,\n\t\t\tpaste_enable_default_filters : true,\n\t\t\tpaste_block_drop : false,\n\t\t\tpaste_retain_style_properties : \"none\",\n\t\t\tpaste_strip_class_attributes : \"mso\",\n\t\t\tpaste_remove_spans : false,\n\t\t\tpaste_remove_styles : false,\n\t\t\tpaste_remove_styles_if_webkit : true,\n\t\t\tpaste_convert_middot_lists : true,\n\t\t\tpaste_convert_headers_to_strong : false,\n\t\t\tpaste_dialog_width : \"450\",\n\t\t\tpaste_dialog_height : \"400\",\n\t\t\tpaste_text_use_dialog : false,\n\t\t\tpaste_text_sticky : false,\n\t\t\tpaste_text_sticky_default : false,\n\t\t\tpaste_text_notifyalways : false,\n\t\t\tpaste_text_linebreaktype : \"combined\",\n\t\t\tpaste_text_replacements : [\n\t\t\t\t[/\\u2026/g, \"...\"],\n\t\t\t\t[/[\\x93\\x94\\u201c\\u201d]/g, '\"'],\n\t\t\t\t[/[\\x60\\x91\\x92\\u2018\\u2019]/g, \"'\"]\n\t\t\t]\n\t\t};\n\n\tfunction getParam(ed, name) {\n\t\treturn ed.getParam(name, defs[name]);\n\t}\n\n\ttinymce.create('tinymce.plugins.PastePlugin', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this;\n\n\t\t\tt.editor = ed;\n\t\t\tt.url = url;\n\n\t\t\t// Setup plugin events\n\t\t\tt.onPreProcess = new tinymce.util.Dispatcher(t);\n\t\t\tt.onPostProcess = new tinymce.util.Dispatcher(t);\n\n\t\t\t// Register default handlers\n\t\t\tt.onPreProcess.add(t._preProcess);\n\t\t\tt.onPostProcess.add(t._postProcess);\n\n\t\t\t// Register optional preprocess handler\n\t\t\tt.onPreProcess.add(function(pl, o) {\n\t\t\t\ted.execCallback('paste_preprocess', pl, o);\n\t\t\t});\n\n\t\t\t// Register optional postprocess\n\t\t\tt.onPostProcess.add(function(pl, o) {\n\t\t\t\ted.execCallback('paste_postprocess', pl, o);\n\t\t\t});\n\n\t\t\ted.onKeyDown.addToTop(function(ed, e) {\n\t\t\t\t// Block ctrl+v from adding an undo level since the default logic in tinymce.Editor will add that\n\t\t\t\tif (((tinymce.isMac ? e.metaKey : e.ctrlKey) && e.keyCode == 86) || (e.shiftKey && e.keyCode == 45))\n\t\t\t\t\treturn false; // Stop other listeners\n\t\t\t});\n\n\t\t\t// Initialize plain text flag\n\t\t\ted.pasteAsPlainText = getParam(ed, 'paste_text_sticky_default');\n\n\t\t\t// This function executes the process handlers and inserts the contents\n\t\t\t// force_rich overrides plain text mode set by user, important for pasting with execCommand\n\t\t\tfunction process(o, force_rich) {\n\t\t\t\tvar dom = ed.dom, rng;\n\n\t\t\t\t// Execute pre process handlers\n\t\t\t\tt.onPreProcess.dispatch(t, o);\n\n\t\t\t\t// Create DOM structure\n\t\t\t\to.node = dom.create('div', 0, o.content);\n\n\t\t\t\t// If pasting inside the same element and the contents is only one block\n\t\t\t\t// remove the block and keep the text since Firefox will copy parts of pre and h1-h6 as a pre element\n\t\t\t\tif (tinymce.isGecko) {\n\t\t\t\t\trng = ed.selection.getRng(true);\n\t\t\t\t\tif (rng.startContainer == rng.endContainer && rng.startContainer.nodeType == 3) {\n\t\t\t\t\t\t// Is only one block node and it doesn't contain word stuff\n\t\t\t\t\t\tif (o.node.childNodes.length === 1 && /^(p|h[1-6]|pre)$/i.test(o.node.firstChild.nodeName) && o.content.indexOf('__MCE_ITEM__') === -1)\n\t\t\t\t\t\t\tdom.remove(o.node.firstChild, true);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Execute post process handlers\n\t\t\t\tt.onPostProcess.dispatch(t, o);\n\n\t\t\t\t// Serialize content\n\t\t\t\to.content = ed.serializer.serialize(o.node, {getInner : 1, forced_root_block : ''});\n\n\t\t\t\t// Plain text option active?\n\t\t\t\tif ((!force_rich) && (ed.pasteAsPlainText)) {\n\t\t\t\t\tt._insertPlainText(o.content);\n\n\t\t\t\t\tif (!getParam(ed, \"paste_text_sticky\")) {\n\t\t\t\t\t\ted.pasteAsPlainText = false;\n\t\t\t\t\t\ted.controlManager.setActive(\"pastetext\", false);\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tt._insert(o.content);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Add command for external usage\n\t\t\ted.addCommand('mceInsertClipboardContent', function(u, o) {\n\t\t\t\tprocess(o, true);\n\t\t\t});\n\n\t\t\tif (!getParam(ed, \"paste_text_use_dialog\")) {\n\t\t\t\ted.addCommand('mcePasteText', function(u, v) {\n\t\t\t\t\tvar cookie = tinymce.util.Cookie;\n\n\t\t\t\t\ted.pasteAsPlainText = !ed.pasteAsPlainText;\n\t\t\t\t\ted.controlManager.setActive('pastetext', ed.pasteAsPlainText);\n\n\t\t\t\t\tif ((ed.pasteAsPlainText) && (!cookie.get(\"tinymcePasteText\"))) {\n\t\t\t\t\t\tif (getParam(ed, \"paste_text_sticky\")) {\n\t\t\t\t\t\t\ted.windowManager.alert(ed.translate('paste.plaintext_mode_sticky'));\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\ted.windowManager.alert(ed.translate('paste.plaintext_mode'));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (!getParam(ed, \"paste_text_notifyalways\")) {\n\t\t\t\t\t\t\tcookie.set(\"tinymcePasteText\", \"1\", new Date(new Date().getFullYear() + 1, 12, 31))\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\ted.addButton('pastetext', {title: 'paste.paste_text_desc', cmd: 'mcePasteText'});\n\t\t\ted.addButton('selectall', {title: 'paste.selectall_desc', cmd: 'selectall'});\n\n\t\t\t// This function grabs the contents from the clipboard by adding a\n\t\t\t// hidden div and placing the caret inside it and after the browser paste\n\t\t\t// is done it grabs that contents and processes that\n\t\t\tfunction grabContent(e) {\n\t\t\t\tvar n, or, rng, oldRng, sel = ed.selection, dom = ed.dom, body = ed.getBody(), posY, textContent;\n\n\t\t\t\t// Check if browser supports direct plaintext access\n\t\t\t\tif (e.clipboardData || dom.doc.dataTransfer) {\n\t\t\t\t\ttextContent = (e.clipboardData || dom.doc.dataTransfer).getData('Text');\n\n\t\t\t\t\tif (ed.pasteAsPlainText) {\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\tprocess({content : dom.encode(textContent).replace(/\\r?\\n/g, '<br />')});\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (dom.get('_mcePaste'))\n\t\t\t\t\treturn;\n\n\t\t\t\t// Create container to paste into\n\t\t\t\tn = dom.add(body, 'div', {id : '_mcePaste', 'class' : 'mcePaste', 'data-mce-bogus' : '1'}, '\\uFEFF\\uFEFF');\n\n\t\t\t\t// If contentEditable mode we need to find out the position of the closest element\n\t\t\t\tif (body != ed.getDoc().body)\n\t\t\t\t\tposY = dom.getPos(ed.selection.getStart(), body).y;\n\t\t\t\telse\n\t\t\t\t\tposY = body.scrollTop + dom.getViewPort(ed.getWin()).y;\n\n\t\t\t\t// Styles needs to be applied after the element is added to the document since WebKit will otherwise remove all styles\n\t\t\t\t// If also needs to be in view on IE or the paste would fail\n\t\t\t\tdom.setStyles(n, {\n\t\t\t\t\tposition : 'absolute',\n\t\t\t\t\tleft : tinymce.isGecko ? -40 : 0, // Need to move it out of site on Gecko since it will othewise display a ghost resize rect for the div\n\t\t\t\t\ttop : posY - 25,\n\t\t\t\t\twidth : 1,\n\t\t\t\t\theight : 1,\n\t\t\t\t\toverflow : 'hidden'\n\t\t\t\t});\n\n\t\t\t\tif (tinymce.isIE) {\n\t\t\t\t\t// Store away the old range\n\t\t\t\t\toldRng = sel.getRng();\n\n\t\t\t\t\t// Select the container\n\t\t\t\t\trng = dom.doc.body.createTextRange();\n\t\t\t\t\trng.moveToElementText(n);\n\t\t\t\t\trng.execCommand('Paste');\n\n\t\t\t\t\t// Remove container\n\t\t\t\t\tdom.remove(n);\n\n\t\t\t\t\t// Check if the contents was changed, if it wasn't then clipboard extraction failed probably due\n\t\t\t\t\t// to IE security settings so we pass the junk though better than nothing right\n\t\t\t\t\tif (n.innerHTML === '\\uFEFF\\uFEFF') {\n\t\t\t\t\t\ted.execCommand('mcePasteWord');\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Restore the old range and clear the contents before pasting\n\t\t\t\t\tsel.setRng(oldRng);\n\t\t\t\t\tsel.setContent('');\n\n\t\t\t\t\t// For some odd reason we need to detach the mceInsertContent call from the paste event\n\t\t\t\t\t// It's like IE has a reference to the parent element that you paste in and the selection gets messed up\n\t\t\t\t\t// when it tries to restore the selection\n\t\t\t\t\tsetTimeout(function() {\n\t\t\t\t\t\t// Process contents\n\t\t\t\t\t\tprocess({content : n.innerHTML});\n\t\t\t\t\t}, 0);\n\n\t\t\t\t\t// Block the real paste event\n\t\t\t\t\treturn tinymce.dom.Event.cancel(e);\n\t\t\t\t} else {\n\t\t\t\t\tfunction block(e) {\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t};\n\n\t\t\t\t\t// Block mousedown and click to prevent selection change\n\t\t\t\t\tdom.bind(ed.getDoc(), 'mousedown', block);\n\t\t\t\t\tdom.bind(ed.getDoc(), 'keydown', block);\n\n\t\t\t\t\tor = ed.selection.getRng();\n\n\t\t\t\t\t// Move select contents inside DIV\n\t\t\t\t\tn = n.firstChild;\n\t\t\t\t\trng = ed.getDoc().createRange();\n\t\t\t\t\trng.setStart(n, 0);\n\t\t\t\t\trng.setEnd(n, 2);\n\t\t\t\t\tsel.setRng(rng);\n\n\t\t\t\t\t// Wait a while and grab the pasted contents\n\t\t\t\t\twindow.setTimeout(function() {\n\t\t\t\t\t\tvar h = '', nl;\n\n\t\t\t\t\t\t// Paste divs duplicated in paste divs seems to happen when you paste plain text so lets first look for that broken behavior in WebKit\n\t\t\t\t\t\tif (!dom.select('div.mcePaste > div.mcePaste').length) {\n\t\t\t\t\t\t\tnl = dom.select('div.mcePaste');\n\n\t\t\t\t\t\t\t// WebKit will split the div into multiple ones so this will loop through then all and join them to get the whole HTML string\n\t\t\t\t\t\t\teach(nl, function(n) {\n\t\t\t\t\t\t\t\tvar child = n.firstChild;\n\n\t\t\t\t\t\t\t\t// WebKit inserts a DIV container with lots of odd styles\n\t\t\t\t\t\t\t\tif (child && child.nodeName == 'DIV' && child.style.marginTop && child.style.backgroundColor) {\n\t\t\t\t\t\t\t\t\tdom.remove(child, 1);\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Remove apply style spans\n\t\t\t\t\t\t\t\teach(dom.select('span.Apple-style-span', n), function(n) {\n\t\t\t\t\t\t\t\t\tdom.remove(n, 1);\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\t// Remove bogus br elements\n\t\t\t\t\t\t\t\teach(dom.select('br[data-mce-bogus]', n), function(n) {\n\t\t\t\t\t\t\t\t\tdom.remove(n);\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\t// WebKit will make a copy of the DIV for each line of plain text pasted and insert them into the DIV\n\t\t\t\t\t\t\t\tif (n.parentNode.className != 'mcePaste')\n\t\t\t\t\t\t\t\t\th += n.innerHTML;\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Found WebKit weirdness so force the content into paragraphs this seems to happen when you paste plain text from Nodepad etc\n\t\t\t\t\t\t\t// So this logic will replace double enter with paragraphs and single enter with br so it kind of looks the same\n\t\t\t\t\t\t\th = '<p>' + dom.encode(textContent).replace(/\\r?\\n\\r?\\n/g, '</p><p>').replace(/\\r?\\n/g, '<br />') + '</p>';\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Remove the nodes\n\t\t\t\t\t\teach(dom.select('div.mcePaste'), function(n) {\n\t\t\t\t\t\t\tdom.remove(n);\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\t// Restore the old selection\n\t\t\t\t\t\tif (or)\n\t\t\t\t\t\t\tsel.setRng(or);\n\n\t\t\t\t\t\tprocess({content : h});\n\n\t\t\t\t\t\t// Unblock events ones we got the contents\n\t\t\t\t\t\tdom.unbind(ed.getDoc(), 'mousedown', block);\n\t\t\t\t\t\tdom.unbind(ed.getDoc(), 'keydown', block);\n\t\t\t\t\t}, 0);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Check if we should use the new auto process method\t\t\t\n\t\t\tif (getParam(ed, \"paste_auto_cleanup_on_paste\")) {\n\t\t\t\t// Is it's Opera or older FF use key handler\n\t\t\t\tif (tinymce.isOpera || /Firefox\\/2/.test(navigator.userAgent)) {\n\t\t\t\t\ted.onKeyDown.addToTop(function(ed, e) {\n\t\t\t\t\t\tif (((tinymce.isMac ? e.metaKey : e.ctrlKey) && e.keyCode == 86) || (e.shiftKey && e.keyCode == 45))\n\t\t\t\t\t\t\tgrabContent(e);\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\t// Grab contents on paste event on Gecko and WebKit\n\t\t\t\t\ted.onPaste.addToTop(function(ed, e) {\n\t\t\t\t\t\treturn grabContent(e);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\ted.onInit.add(function() {\n\t\t\t\ted.controlManager.setActive(\"pastetext\", ed.pasteAsPlainText);\n\n\t\t\t\t// Block all drag/drop events\n\t\t\t\tif (getParam(ed, \"paste_block_drop\")) {\n\t\t\t\t\ted.dom.bind(ed.getBody(), ['dragend', 'dragover', 'draggesture', 'dragdrop', 'drop', 'drag'], function(e) {\n\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\te.stopPropagation();\n\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Add legacy support\n\t\t\tt._legacySupport();\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Paste text/word',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/paste',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t},\n\n\t\t_preProcess : function(pl, o) {\n\t\t\tvar ed = this.editor,\n\t\t\t\th = o.content,\n\t\t\t\tgrep = tinymce.grep,\n\t\t\t\texplode = tinymce.explode,\n\t\t\t\ttrim = tinymce.trim,\n\t\t\t\tlen, stripClass;\n\n\t\t\t//console.log('Before preprocess:' + o.content);\n\n\t\t\tfunction process(items) {\n\t\t\t\teach(items, function(v) {\n\t\t\t\t\t// Remove or replace\n\t\t\t\t\tif (v.constructor == RegExp)\n\t\t\t\t\t\th = h.replace(v, '');\n\t\t\t\t\telse\n\t\t\t\t\t\th = h.replace(v[0], v[1]);\n\t\t\t\t});\n\t\t\t}\n\t\t\t\n\t\t\tif (ed.settings.paste_enable_default_filters == false) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// IE9 adds BRs before/after block elements when contents is pasted from word or for example another browser\n\t\t\tif (tinymce.isIE && document.documentMode >= 9) {\n\t\t\t\t// IE9 adds BRs before/after block elements when contents is pasted from word or for example another browser\n\t\t\t\tprocess([[/(?:<br>&nbsp;[\\s\\r\\n]+|<br>)*(<\\/?(h[1-6r]|p|div|address|pre|form|table|tbody|thead|tfoot|th|tr|td|li|ol|ul|caption|blockquote|center|dl|dt|dd|dir|fieldset)[^>]*>)(?:<br>&nbsp;[\\s\\r\\n]+|<br>)*/g, '$1']]);\n\n\t\t\t\t// IE9 also adds an extra BR element for each soft-linefeed and it also adds a BR for each word wrap break\n\t\t\t\tprocess([\n\t\t\t\t\t[/<br><br>/g, '<BR><BR>'], // Replace multiple BR elements with uppercase BR to keep them intact\n\t\t\t\t\t[/<br>/g, ' '], // Replace single br elements with space since they are word wrap BR:s\n\t\t\t\t\t[/<BR><BR>/g, '<br>'] // Replace back the double brs but into a single BR\n\t\t\t\t]);\n\t\t\t}\n\n\t\t\t// Detect Word content and process it more aggressive\n\t\t\tif (/class=\"?Mso|style=\"[^\"]*\\bmso-|w:WordDocument/i.test(h) || o.wordContent) {\n\t\t\t\to.wordContent = true;\t\t\t// Mark the pasted contents as word specific content\n\t\t\t\t//console.log('Word contents detected.');\n\n\t\t\t\t// Process away some basic content\n\t\t\t\tprocess([\n\t\t\t\t\t/^\\s*(&nbsp;)+/gi,\t\t\t\t// &nbsp; entities at the start of contents\n\t\t\t\t\t/(&nbsp;|<br[^>]*>)+\\s*$/gi\t\t// &nbsp; entities at the end of contents\n\t\t\t\t]);\n\n\t\t\t\tif (getParam(ed, \"paste_convert_headers_to_strong\")) {\n\t\t\t\t\th = h.replace(/<p [^>]*class=\"?MsoHeading\"?[^>]*>(.*?)<\\/p>/gi, \"<p><strong>$1</strong></p>\");\n\t\t\t\t}\n\n\t\t\t\tif (getParam(ed, \"paste_convert_middot_lists\")) {\n\t\t\t\t\tprocess([\n\t\t\t\t\t\t[/<!--\\[if !supportLists\\]-->/gi, '$&__MCE_ITEM__'],\t\t\t\t\t// Convert supportLists to a list item marker\n\t\t\t\t\t\t[/(<span[^>]+(?:mso-list:|:\\s*symbol)[^>]+>)/gi, '$1__MCE_ITEM__'],\t\t// Convert mso-list and symbol spans to item markers\n\t\t\t\t\t\t[/(<p[^>]+(?:MsoListParagraph)[^>]+>)/gi, '$1__MCE_ITEM__']\t\t\t\t// Convert mso-list and symbol paragraphs to item markers (FF)\n\t\t\t\t\t]);\n\t\t\t\t}\n\n\t\t\t\tprocess([\n\t\t\t\t\t// Word comments like conditional comments etc\n\t\t\t\t\t/<!--[\\s\\S]+?-->/gi,\n\n\t\t\t\t\t// Remove comments, scripts (e.g., msoShowComment), XML tag, VML content, MS Office namespaced tags, and a few other tags\n\t\t\t\t\t/<(!|script[^>]*>.*?<\\/script(?=[>\\s])|\\/?(\\?xml(:\\w+)?|img|meta|link|style|\\w:\\w+)(?=[\\s\\/>]))[^>]*>/gi,\n\n\t\t\t\t\t// Convert <s> into <strike> for line-though\n\t\t\t\t\t[/<(\\/?)s>/gi, \"<$1strike>\"],\n\n\t\t\t\t\t// Replace nsbp entites to char since it's easier to handle\n\t\t\t\t\t[/&nbsp;/gi, \"\\u00a0\"]\n\t\t\t\t]);\n\n\t\t\t\t// Remove bad attributes, with or without quotes, ensuring that attribute text is really inside a tag.\n\t\t\t\t// If JavaScript had a RegExp look-behind, we could have integrated this with the last process() array and got rid of the loop. But alas, it does not, so we cannot.\n\t\t\t\tdo {\n\t\t\t\t\tlen = h.length;\n\t\t\t\t\th = h.replace(/(<[a-z][^>]*\\s)(?:id|name|language|type|on\\w+|\\w+:\\w+)=(?:\"[^\"]*\"|\\w+)\\s?/gi, \"$1\");\n\t\t\t\t} while (len != h.length);\n\n\t\t\t\t// Remove all spans if no styles is to be retained\n\t\t\t\tif (getParam(ed, \"paste_retain_style_properties\").replace(/^none$/i, \"\").length == 0) {\n\t\t\t\t\th = h.replace(/<\\/?span[^>]*>/gi, \"\");\n\t\t\t\t} else {\n\t\t\t\t\t// We're keeping styles, so at least clean them up.\n\t\t\t\t\t// CSS Reference: http://msdn.microsoft.com/en-us/library/aa155477.aspx\n\n\t\t\t\t\tprocess([\n\t\t\t\t\t\t// Convert <span style=\"mso-spacerun:yes\">___</span> to string of alternating breaking/non-breaking spaces of same length\n\t\t\t\t\t\t[/<span\\s+style\\s*=\\s*\"\\s*mso-spacerun\\s*:\\s*yes\\s*;?\\s*\"\\s*>([\\s\\u00a0]*)<\\/span>/gi,\n\t\t\t\t\t\t\tfunction(str, spaces) {\n\t\t\t\t\t\t\t\treturn (spaces.length > 0)? spaces.replace(/./, \" \").slice(Math.floor(spaces.length/2)).split(\"\").join(\"\\u00a0\") : \"\";\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t],\n\n\t\t\t\t\t\t// Examine all styles: delete junk, transform some, and keep the rest\n\t\t\t\t\t\t[/(<[a-z][^>]*)\\sstyle=\"([^\"]*)\"/gi,\n\t\t\t\t\t\t\tfunction(str, tag, style) {\n\t\t\t\t\t\t\t\tvar n = [],\n\t\t\t\t\t\t\t\t\ti = 0,\n\t\t\t\t\t\t\t\t\ts = explode(trim(style).replace(/&quot;/gi, \"'\"), \";\");\n\n\t\t\t\t\t\t\t\t// Examine each style definition within the tag's style attribute\n\t\t\t\t\t\t\t\teach(s, function(v) {\n\t\t\t\t\t\t\t\t\tvar name, value,\n\t\t\t\t\t\t\t\t\t\tparts = explode(v, \":\");\n\n\t\t\t\t\t\t\t\t\tfunction ensureUnits(v) {\n\t\t\t\t\t\t\t\t\t\treturn v + ((v !== \"0\") && (/\\d$/.test(v)))? \"px\" : \"\";\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\tif (parts.length == 2) {\n\t\t\t\t\t\t\t\t\t\tname = parts[0].toLowerCase();\n\t\t\t\t\t\t\t\t\t\tvalue = parts[1].toLowerCase();\n\n\t\t\t\t\t\t\t\t\t\t// Translate certain MS Office styles into their CSS equivalents\n\t\t\t\t\t\t\t\t\t\tswitch (name) {\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-padding-alt\":\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-padding-top-alt\":\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-padding-right-alt\":\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-padding-bottom-alt\":\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-padding-left-alt\":\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-margin-alt\":\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-margin-top-alt\":\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-margin-right-alt\":\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-margin-bottom-alt\":\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-margin-left-alt\":\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-table-layout-alt\":\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-height\":\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-width\":\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-vertical-align-alt\":\n\t\t\t\t\t\t\t\t\t\t\t\tn[i++] = name.replace(/^mso-|-alt$/g, \"\") + \":\" + ensureUnits(value);\n\t\t\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t\t\tcase \"horiz-align\":\n\t\t\t\t\t\t\t\t\t\t\t\tn[i++] = \"text-align:\" + value;\n\t\t\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t\t\tcase \"vert-align\":\n\t\t\t\t\t\t\t\t\t\t\t\tn[i++] = \"vertical-align:\" + value;\n\t\t\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t\t\tcase \"font-color\":\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-foreground\":\n\t\t\t\t\t\t\t\t\t\t\t\tn[i++] = \"color:\" + value;\n\t\t\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-background\":\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-highlight\":\n\t\t\t\t\t\t\t\t\t\t\t\tn[i++] = \"background:\" + value;\n\t\t\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-default-height\":\n\t\t\t\t\t\t\t\t\t\t\t\tn[i++] = \"min-height:\" + ensureUnits(value);\n\t\t\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-default-width\":\n\t\t\t\t\t\t\t\t\t\t\t\tn[i++] = \"min-width:\" + ensureUnits(value);\n\t\t\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-padding-between-alt\":\n\t\t\t\t\t\t\t\t\t\t\t\tn[i++] = \"border-collapse:separate;border-spacing:\" + ensureUnits(value);\n\t\t\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t\t\tcase \"text-line-through\":\n\t\t\t\t\t\t\t\t\t\t\t\tif ((value == \"single\") || (value == \"double\")) {\n\t\t\t\t\t\t\t\t\t\t\t\t\tn[i++] = \"text-decoration:line-through\";\n\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t\t\tcase \"mso-zero-height\":\n\t\t\t\t\t\t\t\t\t\t\t\tif (value == \"yes\") {\n\t\t\t\t\t\t\t\t\t\t\t\t\tn[i++] = \"display:none\";\n\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// Eliminate all MS Office style definitions that have no CSS equivalent by examining the first characters in the name\n\t\t\t\t\t\t\t\t\t\tif (/^(mso|column|font-emph|lang|layout|line-break|list-image|nav|panose|punct|row|ruby|sep|size|src|tab-|table-border|text-(?!align|decor|indent|trans)|top-bar|version|vnd|word-break)/.test(name)) {\n\t\t\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// If it reached this point, it must be a valid CSS style\n\t\t\t\t\t\t\t\t\t\tn[i++] = name + \":\" + parts[1];\t\t// Lower-case name, but keep value case\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\t// If style attribute contained any valid styles the re-write it; otherwise delete style attribute.\n\t\t\t\t\t\t\t\tif (i > 0) {\n\t\t\t\t\t\t\t\t\treturn tag + ' style=\"' + n.join(';') + '\"';\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\treturn tag;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t]\n\t\t\t\t\t]);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Replace headers with <strong>\n\t\t\tif (getParam(ed, \"paste_convert_headers_to_strong\")) {\n\t\t\t\tprocess([\n\t\t\t\t\t[/<h[1-6][^>]*>/gi, \"<p><strong>\"],\n\t\t\t\t\t[/<\\/h[1-6][^>]*>/gi, \"</strong></p>\"]\n\t\t\t\t]);\n\t\t\t}\n\n\t\t\tprocess([\n\t\t\t\t// Copy paste from Java like Open Office will produce this junk on FF\n\t\t\t\t[/Version:[\\d.]+\\nStartHTML:\\d+\\nEndHTML:\\d+\\nStartFragment:\\d+\\nEndFragment:\\d+/gi, '']\n\t\t\t]);\n\n\t\t\t// Class attribute options are: leave all as-is (\"none\"), remove all (\"all\"), or remove only those starting with mso (\"mso\").\n\t\t\t// Note:-  paste_strip_class_attributes: \"none\", verify_css_classes: true is also a good variation.\n\t\t\tstripClass = getParam(ed, \"paste_strip_class_attributes\");\n\n\t\t\tif (stripClass !== \"none\") {\n\t\t\t\tfunction removeClasses(match, g1) {\n\t\t\t\t\t\tif (stripClass === \"all\")\n\t\t\t\t\t\t\treturn '';\n\n\t\t\t\t\t\tvar cls = grep(explode(g1.replace(/^([\"'])(.*)\\1$/, \"$2\"), \" \"),\n\t\t\t\t\t\t\tfunction(v) {\n\t\t\t\t\t\t\t\treturn (/^(?!mso)/i.test(v));\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t);\n\n\t\t\t\t\t\treturn cls.length ? ' class=\"' + cls.join(\" \") + '\"' : '';\n\t\t\t\t};\n\n\t\t\t\th = h.replace(/ class=\"([^\"]+)\"/gi, removeClasses);\n\t\t\t\th = h.replace(/ class=([\\-\\w]+)/gi, removeClasses);\n\t\t\t}\n\n\t\t\t// Remove spans option\n\t\t\tif (getParam(ed, \"paste_remove_spans\")) {\n\t\t\t\th = h.replace(/<\\/?span[^>]*>/gi, \"\");\n\t\t\t}\n\n\t\t\t//console.log('After preprocess:' + h);\n\n\t\t\to.content = h;\n\t\t},\n\n\t\t/**\n\t\t * Various post process items.\n\t\t */\n\t\t_postProcess : function(pl, o) {\n\t\t\tvar t = this, ed = t.editor, dom = ed.dom, styleProps;\n\n\t\t\tif (ed.settings.paste_enable_default_filters == false) {\n\t\t\t\treturn;\n\t\t\t}\n\t\t\t\n\t\t\tif (o.wordContent) {\n\t\t\t\t// Remove named anchors or TOC links\n\t\t\t\teach(dom.select('a', o.node), function(a) {\n\t\t\t\t\tif (!a.href || a.href.indexOf('#_Toc') != -1)\n\t\t\t\t\t\tdom.remove(a, 1);\n\t\t\t\t});\n\n\t\t\t\tif (getParam(ed, \"paste_convert_middot_lists\")) {\n\t\t\t\t\tt._convertLists(pl, o);\n\t\t\t\t}\n\n\t\t\t\t// Process styles\n\t\t\t\tstyleProps = getParam(ed, \"paste_retain_style_properties\"); // retained properties\n\n\t\t\t\t// Process only if a string was specified and not equal to \"all\" or \"*\"\n\t\t\t\tif ((tinymce.is(styleProps, \"string\")) && (styleProps !== \"all\") && (styleProps !== \"*\")) {\n\t\t\t\t\tstyleProps = tinymce.explode(styleProps.replace(/^none$/i, \"\"));\n\n\t\t\t\t\t// Retains some style properties\n\t\t\t\t\teach(dom.select('*', o.node), function(el) {\n\t\t\t\t\t\tvar newStyle = {}, npc = 0, i, sp, sv;\n\n\t\t\t\t\t\t// Store a subset of the existing styles\n\t\t\t\t\t\tif (styleProps) {\n\t\t\t\t\t\t\tfor (i = 0; i < styleProps.length; i++) {\n\t\t\t\t\t\t\t\tsp = styleProps[i];\n\t\t\t\t\t\t\t\tsv = dom.getStyle(el, sp);\n\n\t\t\t\t\t\t\t\tif (sv) {\n\t\t\t\t\t\t\t\t\tnewStyle[sp] = sv;\n\t\t\t\t\t\t\t\t\tnpc++;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Remove all of the existing styles\n\t\t\t\t\t\tdom.setAttrib(el, 'style', '');\n\n\t\t\t\t\t\tif (styleProps && npc > 0)\n\t\t\t\t\t\t\tdom.setStyles(el, newStyle); // Add back the stored subset of styles\n\t\t\t\t\t\telse // Remove empty span tags that do not have class attributes\n\t\t\t\t\t\t\tif (el.nodeName == 'SPAN' && !el.className)\n\t\t\t\t\t\t\t\tdom.remove(el, true);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Remove all style information or only specifically on WebKit to avoid the style bug on that browser\n\t\t\tif (getParam(ed, \"paste_remove_styles\") || (getParam(ed, \"paste_remove_styles_if_webkit\") && tinymce.isWebKit)) {\n\t\t\t\teach(dom.select('*[style]', o.node), function(el) {\n\t\t\t\t\tel.removeAttribute('style');\n\t\t\t\t\tel.removeAttribute('data-mce-style');\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\tif (tinymce.isWebKit) {\n\t\t\t\t\t// We need to compress the styles on WebKit since if you paste <img border=\"0\" /> it will become <img border=\"0\" style=\"... lots of junk ...\" />\n\t\t\t\t\t// Removing the mce_style that contains the real value will force the Serializer engine to compress the styles\n\t\t\t\t\teach(dom.select('*', o.node), function(el) {\n\t\t\t\t\t\tel.removeAttribute('data-mce-style');\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Converts the most common bullet and number formats in Office into a real semantic UL/LI list.\n\t\t */\n\t\t_convertLists : function(pl, o) {\n\t\t\tvar dom = pl.editor.dom, listElm, li, lastMargin = -1, margin, levels = [], lastType, html;\n\n\t\t\t// Convert middot lists into real semantic lists\n\t\t\teach(dom.select('p', o.node), function(p) {\n\t\t\t\tvar sib, val = '', type, html, idx, parents;\n\n\t\t\t\t// Get text node value at beginning of paragraph\n\t\t\t\tfor (sib = p.firstChild; sib && sib.nodeType == 3; sib = sib.nextSibling)\n\t\t\t\t\tval += sib.nodeValue;\n\n\t\t\t\tval = p.innerHTML.replace(/<\\/?\\w+[^>]*>/gi, '').replace(/&nbsp;/g, '\\u00a0');\n\n\t\t\t\t// Detect unordered lists look for bullets\n\t\t\t\tif (/^(__MCE_ITEM__)+[\\u2022\\u00b7\\u00a7\\u00d8o\\u25CF]\\s*\\u00a0*/.test(val))\n\t\t\t\t\ttype = 'ul';\n\n\t\t\t\t// Detect ordered lists 1., a. or ixv.\n\t\t\t\tif (/^__MCE_ITEM__\\s*\\w+\\.\\s*\\u00a0+/.test(val))\n\t\t\t\t\ttype = 'ol';\n\n\t\t\t\t// Check if node value matches the list pattern: o&nbsp;&nbsp;\n\t\t\t\tif (type) {\n\t\t\t\t\tmargin = parseFloat(p.style.marginLeft || 0);\n\n\t\t\t\t\tif (margin > lastMargin)\n\t\t\t\t\t\tlevels.push(margin);\n\n\t\t\t\t\tif (!listElm || type != lastType) {\n\t\t\t\t\t\tlistElm = dom.create(type);\n\t\t\t\t\t\tdom.insertAfter(listElm, p);\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Nested list element\n\t\t\t\t\t\tif (margin > lastMargin) {\n\t\t\t\t\t\t\tlistElm = li.appendChild(dom.create(type));\n\t\t\t\t\t\t} else if (margin < lastMargin) {\n\t\t\t\t\t\t\t// Find parent level based on margin value\n\t\t\t\t\t\t\tidx = tinymce.inArray(levels, margin);\n\t\t\t\t\t\t\tparents = dom.getParents(listElm.parentNode, type);\n\t\t\t\t\t\t\tlistElm = parents[parents.length - 1 - idx] || listElm;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove middot or number spans if they exists\n\t\t\t\t\teach(dom.select('span', p), function(span) {\n\t\t\t\t\t\tvar html = span.innerHTML.replace(/<\\/?\\w+[^>]*>/gi, '');\n\n\t\t\t\t\t\t// Remove span with the middot or the number\n\t\t\t\t\t\tif (type == 'ul' && /^__MCE_ITEM__[\\u2022\\u00b7\\u00a7\\u00d8o\\u25CF]/.test(html))\n\t\t\t\t\t\t\tdom.remove(span);\n\t\t\t\t\t\telse if (/^__MCE_ITEM__[\\s\\S]*\\w+\\.(&nbsp;|\\u00a0)*\\s*/.test(html))\n\t\t\t\t\t\t\tdom.remove(span);\n\t\t\t\t\t});\n\n\t\t\t\t\thtml = p.innerHTML;\n\n\t\t\t\t\t// Remove middot/list items\n\t\t\t\t\tif (type == 'ul')\n\t\t\t\t\t\thtml = p.innerHTML.replace(/__MCE_ITEM__/g, '').replace(/^[\\u2022\\u00b7\\u00a7\\u00d8o\\u25CF]\\s*(&nbsp;|\\u00a0)+\\s*/, '');\n\t\t\t\t\telse\n\t\t\t\t\t\thtml = p.innerHTML.replace(/__MCE_ITEM__/g, '').replace(/^\\s*\\w+\\.(&nbsp;|\\u00a0)+\\s*/, '');\n\n\t\t\t\t\t// Create li and add paragraph data into the new li\n\t\t\t\t\tli = listElm.appendChild(dom.create('li', 0, html));\n\t\t\t\t\tdom.remove(p);\n\n\t\t\t\t\tlastMargin = margin;\n\t\t\t\t\tlastType = type;\n\t\t\t\t} else\n\t\t\t\t\tlistElm = lastMargin = 0; // End list element\n\t\t\t});\n\n\t\t\t// Remove any left over makers\n\t\t\thtml = o.node.innerHTML;\n\t\t\tif (html.indexOf('__MCE_ITEM__') != -1)\n\t\t\t\to.node.innerHTML = html.replace(/__MCE_ITEM__/g, '');\n\t\t},\n\n\t\t/**\n\t\t * Inserts the specified contents at the caret position.\n\t\t */\n\t\t_insert : function(h, skip_undo) {\n\t\t\tvar ed = this.editor, r = ed.selection.getRng();\n\n\t\t\t// First delete the contents seems to work better on WebKit when the selection spans multiple list items or multiple table cells.\n\t\t\tif (!ed.selection.isCollapsed() && r.startContainer != r.endContainer)\n\t\t\t\ted.getDoc().execCommand('Delete', false, null);\n\n\t\t\ted.execCommand('mceInsertContent', false, h, {skip_undo : skip_undo});\n\t\t},\n\n\t\t/**\n\t\t * Instead of the old plain text method which tried to re-create a paste operation, the\n\t\t * new approach adds a plain text mode toggle switch that changes the behavior of paste.\n\t\t * This function is passed the same input that the regular paste plugin produces.\n\t\t * It performs additional scrubbing and produces (and inserts) the plain text.\n\t\t * This approach leverages all of the great existing functionality in the paste\n\t\t * plugin, and requires minimal changes to add the new functionality.\n\t\t * Speednet - June 2009\n\t\t */\n\t\t_insertPlainText : function(content) {\n\t\t\tvar ed = this.editor,\n\t\t\t\tlinebr = getParam(ed, \"paste_text_linebreaktype\"),\n\t\t\t\trl = getParam(ed, \"paste_text_replacements\"),\n\t\t\t\tis = tinymce.is;\n\n\t\t\tfunction process(items) {\n\t\t\t\teach(items, function(v) {\n\t\t\t\t\tif (v.constructor == RegExp)\n\t\t\t\t\t\tcontent = content.replace(v, \"\");\n\t\t\t\t\telse\n\t\t\t\t\t\tcontent = content.replace(v[0], v[1]);\n\t\t\t\t});\n\t\t\t};\n\n\t\t\tif ((typeof(content) === \"string\") && (content.length > 0)) {\n\t\t\t\t// If HTML content with line-breaking tags, then remove all cr/lf chars because only tags will break a line\n\t\t\t\tif (/<(?:p|br|h[1-6]|ul|ol|dl|table|t[rdh]|div|blockquote|fieldset|pre|address|center)[^>]*>/i.test(content)) {\n\t\t\t\t\tprocess([\n\t\t\t\t\t\t/[\\n\\r]+/g\n\t\t\t\t\t]);\n\t\t\t\t} else {\n\t\t\t\t\t// Otherwise just get rid of carriage returns (only need linefeeds)\n\t\t\t\t\tprocess([\n\t\t\t\t\t\t/\\r+/g\n\t\t\t\t\t]);\n\t\t\t\t}\n\n\t\t\t\tprocess([\n\t\t\t\t\t[/<\\/(?:p|h[1-6]|ul|ol|dl|table|div|blockquote|fieldset|pre|address|center)>/gi, \"\\n\\n\"],\t\t// Block tags get a blank line after them\n\t\t\t\t\t[/<br[^>]*>|<\\/tr>/gi, \"\\n\"],\t\t\t\t// Single linebreak for <br /> tags and table rows\n\t\t\t\t\t[/<\\/t[dh]>\\s*<t[dh][^>]*>/gi, \"\\t\"],\t\t// Table cells get tabs betweem them\n\t\t\t\t\t/<[a-z!\\/?][^>]*>/gi,\t\t\t\t\t\t// Delete all remaining tags\n\t\t\t\t\t[/&nbsp;/gi, \" \"],\t\t\t\t\t\t\t// Convert non-break spaces to regular spaces (remember, *plain text*)\n\t\t\t\t\t[/(?:(?!\\n)\\s)*(\\n+)(?:(?!\\n)\\s)*/gi, \"$1\"],// Cool little RegExp deletes whitespace around linebreak chars.\n\t\t\t\t\t[/\\n{3,}/g, \"\\n\\n\"]\t\t\t\t\t\t\t// Max. 2 consecutive linebreaks\n\t\t\t\t]);\n\n\t\t\t\tcontent = ed.dom.decode(tinymce.html.Entities.encodeRaw(content));\n\n\t\t\t\t// Perform default or custom replacements\n\t\t\t\tif (is(rl, \"array\")) {\n\t\t\t\t\tprocess(rl);\n\t\t\t\t} else if (is(rl, \"string\")) {\n\t\t\t\t\tprocess(new RegExp(rl, \"gi\"));\n\t\t\t\t}\n\n\t\t\t\t// Treat paragraphs as specified in the config\n\t\t\t\tif (linebr == \"none\") {\n\t\t\t\t\t// Convert all line breaks to space\n\t\t\t\t\tprocess([\n\t\t\t\t\t\t[/\\n+/g, \" \"]\n\t\t\t\t\t]);\n\t\t\t\t} else if (linebr == \"br\") {\n\t\t\t\t\t// Convert all line breaks to <br />\n\t\t\t\t\tprocess([\n\t\t\t\t\t\t[/\\n/g, \"<br />\"]\n\t\t\t\t\t]);\n\t\t\t\t} else if (linebr == \"p\") {\n\t\t\t\t\t// Convert all line breaks to <p>...</p>\n\t\t\t\t\tprocess([\n\t\t\t\t\t\t[/\\n+/g, \"</p><p>\"],\n\t\t\t\t\t\t[/^(.*<\\/p>)(<p>)$/, '<p>$1']\n\t\t\t\t\t]);\n\t\t\t\t} else {\n\t\t\t\t\t// defaults to \"combined\"\n\t\t\t\t\t// Convert single line breaks to <br /> and double line breaks to <p>...</p>\n\t\t\t\t\tprocess([\n\t\t\t\t\t\t[/\\n\\n/g, \"</p><p>\"],\n\t\t\t\t\t\t[/^(.*<\\/p>)(<p>)$/, '<p>$1'],\n\t\t\t\t\t\t[/\\n/g, \"<br />\"]\n\t\t\t\t\t]);\n\t\t\t\t}\n\n\t\t\t\ted.execCommand('mceInsertContent', false, content);\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * This method will open the old style paste dialogs. Some users might want the old behavior but still use the new cleanup engine.\n\t\t */\n\t\t_legacySupport : function() {\n\t\t\tvar t = this, ed = t.editor;\n\n\t\t\t// Register command(s) for backwards compatibility\n\t\t\ted.addCommand(\"mcePasteWord\", function() {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile: t.url + \"/pasteword.htm\",\n\t\t\t\t\twidth: parseInt(getParam(ed, \"paste_dialog_width\")),\n\t\t\t\t\theight: parseInt(getParam(ed, \"paste_dialog_height\")),\n\t\t\t\t\tinline: 1\n\t\t\t\t});\n\t\t\t});\n\n\t\t\tif (getParam(ed, \"paste_text_use_dialog\")) {\n\t\t\t\ted.addCommand(\"mcePasteText\", function() {\n\t\t\t\t\ted.windowManager.open({\n\t\t\t\t\t\tfile : t.url + \"/pastetext.htm\",\n\t\t\t\t\t\twidth: parseInt(getParam(ed, \"paste_dialog_width\")),\n\t\t\t\t\t\theight: parseInt(getParam(ed, \"paste_dialog_height\")),\n\t\t\t\t\t\tinline : 1\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Register button for backwards compatibility\n\t\t\ted.addButton(\"pasteword\", {title : \"paste.paste_word_desc\", cmd : \"mcePasteWord\"});\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add(\"paste\", tinymce.plugins.PastePlugin);\n})();\n","Magento_Tinymce3/tiny_mce/plugins/paste/js/pastetext.js":"tinyMCEPopup.requireLangPack();\n\nvar PasteTextDialog = {\n\tinit : function() {\n\t\tthis.resize();\n\t},\n\n\tinsert : function() {\n\t\tvar h = tinyMCEPopup.dom.encode(document.getElementById('content').value), lines;\n\n\t\t// Convert linebreaks into paragraphs\n\t\tif (document.getElementById('linebreaks').checked) {\n\t\t\tlines = h.split(/\\r?\\n/);\n\t\t\tif (lines.length > 1) {\n\t\t\t\th = '';\n\t\t\t\ttinymce.each(lines, function(row) {\n\t\t\t\t\th += '<p>' + row + '</p>';\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\n\t\ttinyMCEPopup.editor.execCommand('mceInsertClipboardContent', false, {content : h});\n\t\ttinyMCEPopup.close();\n\t},\n\n\tresize : function() {\n\t\tvar vp = tinyMCEPopup.dom.getViewPort(window), el;\n\n\t\tel = document.getElementById('content');\n\n\t\tel.style.width  = (vp.w - 20) + 'px';\n\t\tel.style.height = (vp.h - 90) + 'px';\n\t}\n};\n\ntinyMCEPopup.onInit.add(PasteTextDialog.init, PasteTextDialog);\n","Magento_Tinymce3/tiny_mce/plugins/paste/js/pasteword.js":"tinyMCEPopup.requireLangPack();\n\nvar PasteWordDialog = {\n\tinit : function() {\n\t\tvar ed = tinyMCEPopup.editor, el = document.getElementById('iframecontainer'), ifr, doc, css, cssHTML = '';\n\n\t\t// Create iframe\n\t\tel.innerHTML = '<iframe id=\"iframe\" src=\"javascript:\\'\\';\" frameBorder=\"0\" style=\"border: 1px solid gray\"></iframe>';\n\t\tifr = document.getElementById('iframe');\n\t\tdoc = ifr.contentWindow.document;\n\n\t\t// Force absolute CSS urls\n\t\tcss = [ed.baseURI.toAbsolute(\"themes/\" + ed.settings.theme + \"/skins/\" + ed.settings.skin + \"/content.css\")];\n\t\tcss = css.concat(tinymce.explode(ed.settings.content_css) || []);\n\t\ttinymce.each(css, function(u) {\n\t\t\tcssHTML += '<link href=\"' + ed.documentBaseURI.toAbsolute('' + u) + '\" rel=\"stylesheet\" type=\"text/css\" />';\n\t\t});\n\n\t\t// Write content into iframe\n\t\tdoc.open();\n\t\tdoc.write('<html><head>' + cssHTML + '</head><body class=\"mceContentBody\" spellcheck=\"false\"></body></html>');\n\t\tdoc.close();\n\n\t\tdoc.designMode = 'on';\n\t\tthis.resize();\n\n\t\twindow.setTimeout(function() {\n\t\t\tifr.contentWindow.focus();\n\t\t}, 10);\n\t},\n\n\tinsert : function() {\n\t\tvar h = document.getElementById('iframe').contentWindow.document.body.innerHTML;\n\n\t\ttinyMCEPopup.editor.execCommand('mceInsertClipboardContent', false, {content : h, wordContent : true});\n\t\ttinyMCEPopup.close();\n\t},\n\n\tresize : function() {\n\t\tvar vp = tinyMCEPopup.dom.getViewPort(window), el;\n\n\t\tel = document.getElementById('iframe');\n\n\t\tif (el) {\n\t\t\tel.style.width  = (vp.w - 20) + 'px';\n\t\t\tel.style.height = (vp.h - 90) + 'px';\n\t\t}\n\t}\n};\n\ntinyMCEPopup.onInit.add(PasteWordDialog.init, PasteWordDialog);\n","Magento_Tinymce3/tiny_mce/plugins/paste/langs/en_dlg.js":"tinyMCE.addI18n('en.paste_dlg',{\"word_title\":\"Use Ctrl+V on your keyboard to paste the text into the window.\",\"text_linebreaks\":\"Keep Linebreaks\",\"text_title\":\"Use Ctrl+V on your keyboard to paste the text into the window.\"});","Magento_Tinymce3/tiny_mce/plugins/autolink/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.AutolinkPlugin\",{init:function(a,b){var c=this;if(tinyMCE.isIE){return}a.onKeyDown.add(function(d,f){if(f.keyCode==13){return c.handleEnter(d)}});a.onKeyPress.add(function(d,f){if(f.which==41){return c.handleEclipse(d)}});a.onKeyUp.add(function(d,f){if(f.keyCode==32){return c.handleSpacebar(d)}})},handleEclipse:function(a){this.parseCurrentLine(a,-1,\"(\",true)},handleSpacebar:function(a){this.parseCurrentLine(a,0,\"\",true)},handleEnter:function(a){this.parseCurrentLine(a,-1,\"\",false)},parseCurrentLine:function(i,d,b,g){var a,f,c,n,k,m,h,e,j;a=i.selection.getRng().cloneRange();if(a.startOffset<5){e=a.endContainer.previousSibling;if(e==null){if(a.endContainer.firstChild==null||a.endContainer.firstChild.nextSibling==null){return}e=a.endContainer.firstChild.nextSibling}j=e.length;a.setStart(e,j);a.setEnd(e,j);if(a.endOffset<5){return}f=a.endOffset;n=e}else{n=a.endContainer;if(n.nodeType!=3&&n.firstChild){while(n.nodeType!=3&&n.firstChild){n=n.firstChild}a.setStart(n,0);a.setEnd(n,n.nodeValue.length)}if(a.endOffset==1){f=2}else{f=a.endOffset-1-d}}c=f;do{a.setStart(n,f-2);a.setEnd(n,f-1);f-=1}while(a.toString()!=\" \"&&a.toString()!=\"\"&&a.toString().charCodeAt(0)!=160&&(f-2)>=0&&a.toString()!=b);if(a.toString()==b||a.toString().charCodeAt(0)==160){a.setStart(n,f);a.setEnd(n,c);f+=1}else{if(a.startOffset==0){a.setStart(n,0);a.setEnd(n,c)}else{a.setStart(n,f);a.setEnd(n,c)}}m=a.toString();h=m.match(/^(https?:\\/\\/|ssh:\\/\\/|ftp:\\/\\/|file:\\/|www\\.)(.+)$/i);if(h){if(h[1]==\"www.\"){h[1]=\"http://www.\"}k=i.selection.getBookmark();i.selection.setRng(a);tinyMCE.execCommand(\"createlink\",false,h[1]+h[2]);i.selection.moveToBookmark(k);if(tinyMCE.isWebKit){i.selection.collapse(false);var l=Math.min(n.length,c+1);a.setStart(n,l);a.setEnd(n,l);i.selection.setRng(a)}}},getInfo:function(){return{longname:\"Autolink\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/autolink\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"autolink\",tinymce.plugins.AutolinkPlugin)})();","Magento_Tinymce3/tiny_mce/plugins/autolink/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2011, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.AutolinkPlugin', {\n\t/**\n\t* Initializes the plugin, this will be executed after the plugin has been created.\n\t* This call is done before the editor instance has finished it's initialization so use the onInit event\n\t* of the editor instance to intercept that event.\n\t*\n\t* @param {tinymce.Editor} ed Editor instance that the plugin is initialized in.\n\t* @param {string} url Absolute URL to where the plugin is located.\n\t*/\n\n\tinit : function(ed, url) {\n\t\tvar t = this;\n\n\t\t// Internet Explorer has built-in automatic linking\n\t\tif (tinyMCE.isIE)\n\t\t\treturn;\n\n\t\t// Add a key down handler\n\t\ted.onKeyDown.add(function(ed, e) {\n\t\t\tif (e.keyCode == 13)\n\t\t\t\treturn t.handleEnter(ed);\n\t\t\t});\n\n\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\tif (e.which == 41)\n\t\t\t\treturn t.handleEclipse(ed);\n\t\t});\n\n\t\t// Add a key up handler\n\t\ted.onKeyUp.add(function(ed, e) {\n\t\t\tif (e.keyCode == 32)\n\t\t\t\treturn t.handleSpacebar(ed);\n\t\t\t});\n\t       },\n\n\t\thandleEclipse : function(ed) {\n\t\t\tthis.parseCurrentLine(ed, -1, '(', true);\n\t\t},\n\n\t\thandleSpacebar : function(ed) {\n\t\t\t this.parseCurrentLine(ed, 0, '', true);\n\t\t },\n\n\t\thandleEnter : function(ed) {\n\t\t\tthis.parseCurrentLine(ed, -1, '', false);\n\t\t},\n\n\t\tparseCurrentLine : function(ed, end_offset, delimiter, goback) {\n\t\t\tvar r, end, start, endContainer, bookmark, text, matches, prev, len;\n\n\t\t\t// We need at least five characters to form a URL,\n\t\t\t// hence, at minimum, five characters from the beginning of the line.\n\t\t\tr = ed.selection.getRng().cloneRange();\n\t\t\tif (r.startOffset < 5) {\n\t\t\t\t// During testing, the caret is placed inbetween two text nodes. \n\t\t\t\t// The previous text node contains the URL.\n\t\t\t\tprev = r.endContainer.previousSibling;\n\t\t\t\tif (prev == null) {\n\t\t\t\t\tif (r.endContainer.firstChild == null || r.endContainer.firstChild.nextSibling == null)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tprev = r.endContainer.firstChild.nextSibling;\n\t\t\t\t}\n\t\t\t\tlen = prev.length;\n\t\t\t\tr.setStart(prev, len);\n\t\t\t\tr.setEnd(prev, len);\n\n\t\t\t\tif (r.endOffset < 5)\n\t\t\t\t\treturn;\n\n\t\t\t\tend = r.endOffset;\n\t\t\t\tendContainer = prev;\n\t\t\t} else {\n\t\t\t\tendContainer = r.endContainer;\n\n\t\t\t\t// Get a text node\n\t\t\t\tif (endContainer.nodeType != 3 && endContainer.firstChild) {\n\t\t\t\t\twhile (endContainer.nodeType != 3 && endContainer.firstChild)\n\t\t\t\t\t\tendContainer = endContainer.firstChild;\n\n\t\t\t\t\tr.setStart(endContainer, 0);\n\t\t\t\t\tr.setEnd(endContainer, endContainer.nodeValue.length);\n\t\t\t\t}\n\n\t\t\t\tif (r.endOffset == 1)\n\t\t\t\t\tend = 2;\n\t\t\t\telse\n\t\t\t\t\tend = r.endOffset - 1 - end_offset;\n\t\t\t}\n\n\t\t\tstart = end;\n\n\t\t\tdo\n\t\t\t{\n\t\t\t\t// Move the selection one character backwards.\n\t\t\t\tr.setStart(endContainer, end - 2);\n\t\t\t\tr.setEnd(endContainer, end - 1);\n\t\t\t\tend -= 1;\n\n\t\t\t\t// Loop until one of the following is found: a blank space, &nbsp;, delimeter, (end-2) >= 0\n\t\t\t} while (r.toString() != ' ' && r.toString() != '' && r.toString().charCodeAt(0) != 160 && (end -2) >= 0 && r.toString() != delimiter);\n\n\t\t\tif (r.toString() == delimiter || r.toString().charCodeAt(0) == 160) {\n\t\t\t\tr.setStart(endContainer, end);\n\t\t\t\tr.setEnd(endContainer, start);\n\t\t\t\tend += 1;\n\t\t\t} else if (r.startOffset == 0) {\n\t\t\t\tr.setStart(endContainer, 0);\n\t\t\t\tr.setEnd(endContainer, start);\n\t\t\t}\n\t\t\telse {\n\t\t\t\tr.setStart(endContainer, end);\n\t\t\t\tr.setEnd(endContainer, start);\n\t\t\t}\n\n\t\t\ttext = r.toString();\n\t\t\tmatches = text.match(/^(https?:\\/\\/|ssh:\\/\\/|ftp:\\/\\/|file:\\/|www\\.)(.+)$/i);\n\n\t\t\tif (matches) {\n\t\t\t\tif (matches[1] == 'www.') {\n\t\t\t\t\tmatches[1] = 'http://www.';\n\t\t\t\t}\n\n\t\t\t\tbookmark = ed.selection.getBookmark();\n\n\t\t\t\ted.selection.setRng(r);\n\t\t\t\ttinyMCE.execCommand('createlink',false, matches[1] + matches[2]);\n\t\t\t\ted.selection.moveToBookmark(bookmark);\n\n\t\t\t\t// TODO: Determine if this is still needed.\n\t\t\t\tif (tinyMCE.isWebKit) {\n\t\t\t\t\t// move the caret to its original position\n\t\t\t\t\ted.selection.collapse(false);\n\t\t\t\t\tvar max = Math.min(endContainer.length, start + 1);\n\t\t\t\t\tr.setStart(endContainer, max);\n\t\t\t\t\tr.setEnd(endContainer, max);\n\t\t\t\t\ted.selection.setRng(r);\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t* Returns information about the plugin as a name/value array.\n\t\t* The current keys are longname, author, authorurl, infourl and version.\n\t\t*\n\t\t* @return {Object} Name/value array containing information about the plugin.\n\t\t*/\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Autolink',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/autolink',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('autolink', tinymce.plugins.AutolinkPlugin);\n})();\n","Magento_Tinymce3/tiny_mce/plugins/save/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.Save\",{init:function(a,b){var c=this;c.editor=a;a.addCommand(\"mceSave\",c._save,c);a.addCommand(\"mceCancel\",c._cancel,c);a.addButton(\"save\",{title:\"save.save_desc\",cmd:\"mceSave\"});a.addButton(\"cancel\",{title:\"save.cancel_desc\",cmd:\"mceCancel\"});a.onNodeChange.add(c._nodeChange,c);a.addShortcut(\"ctrl+s\",a.getLang(\"save.save_desc\"),\"mceSave\")},getInfo:function(){return{longname:\"Save\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/save\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}},_nodeChange:function(b,a,c){var b=this.editor;if(b.getParam(\"save_enablewhendirty\")){a.setDisabled(\"save\",!b.isDirty());a.setDisabled(\"cancel\",!b.isDirty())}},_save:function(){var c=this.editor,a,e,d,b;a=tinymce.DOM.get(c.id).form||tinymce.DOM.getParent(c.id,\"form\");if(c.getParam(\"save_enablewhendirty\")&&!c.isDirty()){return}tinyMCE.triggerSave();if(e=c.getParam(\"save_onsavecallback\")){if(c.execCallback(\"save_onsavecallback\",c)){c.startContent=tinymce.trim(c.getContent({format:\"raw\"}));c.nodeChanged()}return}if(a){c.isNotDirty=true;if(a.onsubmit==null||a.onsubmit()!=false){a.submit()}c.nodeChanged()}else{c.windowManager.alert(\"Error: No form element found.\")}},_cancel:function(){var a=this.editor,c,b=tinymce.trim(a.startContent);if(c=a.getParam(\"save_oncancelcallback\")){a.execCallback(\"save_oncancelcallback\",a);return}a.setContent(b);a.undoManager.clear();a.nodeChanged()}});tinymce.PluginManager.add(\"save\",tinymce.plugins.Save)})();","Magento_Tinymce3/tiny_mce/plugins/save/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.Save', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this;\n\n\t\t\tt.editor = ed;\n\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceSave', t._save, t);\n\t\t\ted.addCommand('mceCancel', t._cancel, t);\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('save', {title : 'save.save_desc', cmd : 'mceSave'});\n\t\t\ted.addButton('cancel', {title : 'save.cancel_desc', cmd : 'mceCancel'});\n\n\t\t\ted.onNodeChange.add(t._nodeChange, t);\n\t\t\ted.addShortcut('ctrl+s', ed.getLang('save.save_desc'), 'mceSave');\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Save',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/save',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t},\n\n\t\t// Private methods\n\n\t\t_nodeChange : function(ed, cm, n) {\n\t\t\tvar ed = this.editor;\n\n\t\t\tif (ed.getParam('save_enablewhendirty')) {\n\t\t\t\tcm.setDisabled('save', !ed.isDirty());\n\t\t\t\tcm.setDisabled('cancel', !ed.isDirty());\n\t\t\t}\n\t\t},\n\n\t\t// Private methods\n\n\t\t_save : function() {\n\t\t\tvar ed = this.editor, formObj, os, i, elementId;\n\n\t\t\tformObj = tinymce.DOM.get(ed.id).form || tinymce.DOM.getParent(ed.id, 'form');\n\n\t\t\tif (ed.getParam(\"save_enablewhendirty\") && !ed.isDirty())\n\t\t\t\treturn;\n\n\t\t\ttinyMCE.triggerSave();\n\n\t\t\t// Use callback instead\n\t\t\tif (os = ed.getParam(\"save_onsavecallback\")) {\n\t\t\t\tif (ed.execCallback('save_onsavecallback', ed)) {\n\t\t\t\t\ted.startContent = tinymce.trim(ed.getContent({format : 'raw'}));\n\t\t\t\t\ted.nodeChanged();\n\t\t\t\t}\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif (formObj) {\n\t\t\t\ted.isNotDirty = true;\n\n\t\t\t\tif (formObj.onsubmit == null || formObj.onsubmit() != false)\n\t\t\t\t\tformObj.submit();\n\n\t\t\t\ted.nodeChanged();\n\t\t\t} else\n\t\t\t\ted.windowManager.alert(\"Error: No form element found.\");\n\t\t},\n\n\t\t_cancel : function() {\n\t\t\tvar ed = this.editor, os, h = tinymce.trim(ed.startContent);\n\n\t\t\t// Use callback instead\n\t\t\tif (os = ed.getParam(\"save_oncancelcallback\")) {\n\t\t\t\ted.execCallback('save_oncancelcallback', ed);\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\ted.setContent(h);\n\t\t\ted.undoManager.clear();\n\t\t\ted.nodeChanged();\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('save', tinymce.plugins.Save);\n})();","Magento_Tinymce3/tiny_mce/plugins/wordcount/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.WordCount\",{block:0,id:null,countre:null,cleanre:null,init:function(a,b){var c=this,d=0;c.countre=a.getParam(\"wordcount_countregex\",/[\\w\\u2019\\'-]+/g);c.cleanre=a.getParam(\"wordcount_cleanregex\",/[0-9.(),;:!?%#$?\\'\\\"_+=\\\\\\/-]*/g);c.id=a.id+\"-word-count\";a.onPostRender.add(function(f,e){var g,h;h=f.getParam(\"wordcount_target_id\");if(!h){g=tinymce.DOM.get(f.id+\"_path_row\");if(g){tinymce.DOM.add(g.parentNode,\"div\",{style:\"float: right\"},f.getLang(\"wordcount.words\",\"Words: \")+'<span id=\"'+c.id+'\">0</span>')}}else{tinymce.DOM.add(h,\"span\",{},'<span id=\"'+c.id+'\">0</span>')}});a.onInit.add(function(e){e.selection.onSetContent.add(function(){c._count(e)});c._count(e)});a.onSetContent.add(function(e){c._count(e)});a.onKeyUp.add(function(f,g){if(g.keyCode==d){return}if(13==g.keyCode||8==d||46==d){c._count(f)}d=g.keyCode})},_getCount:function(c){var a=0;var b=c.getContent({format:\"raw\"});if(b){b=b.replace(/\\.\\.\\./g,\" \");b=b.replace(/<.[^<>]*?>/g,\" \").replace(/&nbsp;|&#160;/gi,\" \");b=b.replace(/(\\w+)(&.+?;)+(\\w+)/,\"$1$3\").replace(/&.+?;/g,\" \");b=b.replace(this.cleanre,\"\");var d=b.match(this.countre);if(d){a=d.length}}return a},_count:function(a){var b=this;if(b.block){return}b.block=1;setTimeout(function(){if(!a.destroyed){var c=b._getCount(a);tinymce.DOM.setHTML(b.id,c.toString());setTimeout(function(){b.block=0},2000)}},1)},getInfo:function(){return{longname:\"Word Count plugin\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/wordcount\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"wordcount\",tinymce.plugins.WordCount)})();","Magento_Tinymce3/tiny_mce/plugins/wordcount/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.WordCount', {\n\t\tblock : 0,\n\t\tid : null,\n\t\tcountre : null,\n\t\tcleanre : null,\n\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this, last = 0;\n\n\t\t\tt.countre = ed.getParam('wordcount_countregex', /[\\w\\u2019\\'-]+/g); // u2019 == &rsquo;\n\t\t\tt.cleanre = ed.getParam('wordcount_cleanregex', /[0-9.(),;:!?%#$?\\'\\\"_+=\\\\\\/-]*/g);\n\t\t\tt.id = ed.id + '-word-count';\n\n\t\t\ted.onPostRender.add(function(ed, cm) {\n\t\t\t\tvar row, id;\n\n\t\t\t\t// Add it to the specified id or the theme advanced path\n\t\t\t\tid = ed.getParam('wordcount_target_id');\n\t\t\t\tif (!id) {\n\t\t\t\t\trow = tinymce.DOM.get(ed.id + '_path_row');\n\n\t\t\t\t\tif (row)\n\t\t\t\t\t\ttinymce.DOM.add(row.parentNode, 'div', {'style': 'float: right'}, ed.getLang('wordcount.words', 'Words: ') + '<span id=\"' + t.id + '\">0</span>');\n\t\t\t\t} else {\n\t\t\t\t\ttinymce.DOM.add(id, 'span', {}, '<span id=\"' + t.id + '\">0</span>');\n\t\t\t\t}\n\t\t\t});\n\n\t\t\ted.onInit.add(function(ed) {\n\t\t\t\ted.selection.onSetContent.add(function() {\n\t\t\t\t\tt._count(ed);\n\t\t\t\t});\n\n\t\t\t\tt._count(ed);\n\t\t\t});\n\n\t\t\ted.onSetContent.add(function(ed) {\n\t\t\t\tt._count(ed);\n\t\t\t});\n\n\t\t\ted.onKeyUp.add(function(ed, e) {\n\t\t\t\tif (e.keyCode == last)\n\t\t\t\t\treturn;\n\n\t\t\t\tif (13 == e.keyCode || 8 == last || 46 == last)\n\t\t\t\t\tt._count(ed);\n\n\t\t\t\tlast = e.keyCode;\n\t\t\t});\n\t\t},\n\n\t\t_getCount : function(ed) {\n\t\t\tvar tc = 0;\n\t\t\tvar tx = ed.getContent({ format: 'raw' });\n\n\t\t\tif (tx) {\n\t\t\t\t\ttx = tx.replace(/\\.\\.\\./g, ' '); // convert ellipses to spaces\n\t\t\t\t\ttx = tx.replace(/<.[^<>]*?>/g, ' ').replace(/&nbsp;|&#160;/gi, ' '); // remove html tags and space chars\n\n\t\t\t\t\t// deal with html entities\n\t\t\t\t\ttx = tx.replace(/(\\w+)(&.+?;)+(\\w+)/, \"$1$3\").replace(/&.+?;/g, ' ');\n\t\t\t\t\ttx = tx.replace(this.cleanre, ''); // remove numbers and punctuation\n\n\t\t\t\t\tvar wordArray = tx.match(this.countre);\n\t\t\t\t\tif (wordArray) {\n\t\t\t\t\t\t\ttc = wordArray.length;\n\t\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn tc;\n\t\t},\n\n\t\t_count : function(ed) {\n\t\t\tvar t = this;\n\n\t\t\t// Keep multiple calls from happening at the same time\n\t\t\tif (t.block)\n\t\t\t\treturn;\n\n\t\t\tt.block = 1;\n\n\t\t\tsetTimeout(function() {\n\t\t\t\tif (!ed.destroyed) {\n\t\t\t\t\tvar tc = t._getCount(ed);\n\t\t\t\t\ttinymce.DOM.setHTML(t.id, tc.toString());\n\t\t\t\t\tsetTimeout(function() {t.block = 0;}, 2000);\n\t\t\t\t}\n\t\t\t}, 1);\n\t\t},\n\n\t\tgetInfo: function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Word Count plugin',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/wordcount',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\ttinymce.PluginManager.add('wordcount', tinymce.plugins.WordCount);\n})();\n","Magento_Tinymce3/tiny_mce/plugins/legacyoutput/editor_plugin.js":"(function(a){a.onAddEditor.addToTop(function(c,b){b.settings.inline_styles=false});a.create(\"tinymce.plugins.LegacyOutput\",{init:function(b){b.onInit.add(function(){var c=\"p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,table,img\",e=a.explode(b.settings.font_size_style_values),d=b.schema;b.formatter.register({alignleft:{selector:c,attributes:{align:\"left\"}},aligncenter:{selector:c,attributes:{align:\"center\"}},alignright:{selector:c,attributes:{align:\"right\"}},alignfull:{selector:c,attributes:{align:\"justify\"}},bold:[{inline:\"b\",remove:\"all\"},{inline:\"strong\",remove:\"all\"},{inline:\"span\",styles:{fontWeight:\"bold\"}}],italic:[{inline:\"i\",remove:\"all\"},{inline:\"em\",remove:\"all\"},{inline:\"span\",styles:{fontStyle:\"italic\"}}],underline:[{inline:\"u\",remove:\"all\"},{inline:\"span\",styles:{textDecoration:\"underline\"},exact:true}],strikethrough:[{inline:\"strike\",remove:\"all\"},{inline:\"span\",styles:{textDecoration:\"line-through\"},exact:true}],fontname:{inline:\"font\",attributes:{face:\"%value\"}},fontsize:{inline:\"font\",attributes:{size:function(f){return a.inArray(e,f.value)+1}}},forecolor:{inline:\"font\",styles:{color:\"%value\"}},hilitecolor:{inline:\"font\",styles:{backgroundColor:\"%value\"}}});a.each(\"b,i,u,strike\".split(\",\"),function(f){d.addValidElements(f+\"[*]\")});if(!d.getElementRule(\"font\")){d.addValidElements(\"font[face|size|color|style]\")}a.each(c.split(\",\"),function(f){var h=d.getElementRule(f),g;if(h){if(!h.attributes.align){h.attributes.align={};h.attributesOrder.push(\"align\")}}});b.onNodeChange.add(function(g,k){var j,f,h,i;f=g.dom.getParent(g.selection.getNode(),\"font\");if(f){h=f.face;i=f.size}if(j=k.get(\"fontselect\")){j.select(function(l){return l==h})}if(j=k.get(\"fontsizeselect\")){j.select(function(m){var l=a.inArray(e,m.fontSize);return l+1==i})}})})},getInfo:function(){return{longname:\"LegacyOutput\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/legacyoutput\",version:a.majorVersion+\".\"+a.minorVersion}}});a.PluginManager.add(\"legacyoutput\",a.plugins.LegacyOutput)})(tinymce);","Magento_Tinymce3/tiny_mce/plugins/legacyoutput/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n *\n * This plugin will force TinyMCE to produce deprecated legacy output such as font elements, u elements, align\n * attributes and so forth. There are a few cases where these old items might be needed for example in email applications or with Flash\n *\n * However you should NOT use this plugin if you are building some system that produces web contents such as a CMS. All these elements are\n * not apart of the newer specifications for HTML and XHTML.\n */\n\n(function(tinymce) {\n\t// Override inline_styles setting to force TinyMCE to produce deprecated contents\n\ttinymce.onAddEditor.addToTop(function(tinymce, editor) {\n\t\teditor.settings.inline_styles = false;\n\t});\n\n\t// Create the legacy ouput plugin\n\ttinymce.create('tinymce.plugins.LegacyOutput', {\n\t\tinit : function(editor) {\n\t\t\teditor.onInit.add(function() {\n\t\t\t\tvar alignElements = 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,table,img',\n\t\t\t\t\tfontSizes = tinymce.explode(editor.settings.font_size_style_values),\n\t\t\t\t\tschema = editor.schema;\n\n\t\t\t\t// Override some internal formats to produce legacy elements and attributes\n\t\t\t\teditor.formatter.register({\n\t\t\t\t\t// Change alignment formats to use the deprecated align attribute\n\t\t\t\t\talignleft : {selector : alignElements, attributes : {align : 'left'}},\n\t\t\t\t\taligncenter : {selector : alignElements, attributes : {align : 'center'}},\n\t\t\t\t\talignright : {selector : alignElements, attributes : {align : 'right'}},\n\t\t\t\t\talignfull : {selector : alignElements, attributes : {align : 'justify'}},\n\n\t\t\t\t\t// Change the basic formatting elements to use deprecated element types\n\t\t\t\t\tbold : [\n\t\t\t\t\t\t{inline : 'b', remove : 'all'},\n\t\t\t\t\t\t{inline : 'strong', remove : 'all'},\n\t\t\t\t\t\t{inline : 'span', styles : {fontWeight : 'bold'}}\n\t\t\t\t\t],\n\t\t\t\t\titalic : [\n\t\t\t\t\t\t{inline : 'i', remove : 'all'},\n\t\t\t\t\t\t{inline : 'em', remove : 'all'},\n\t\t\t\t\t\t{inline : 'span', styles : {fontStyle : 'italic'}}\n\t\t\t\t\t],\n\t\t\t\t\tunderline : [\n\t\t\t\t\t\t{inline : 'u', remove : 'all'},\n\t\t\t\t\t\t{inline : 'span', styles : {textDecoration : 'underline'}, exact : true}\n\t\t\t\t\t],\n\t\t\t\t\tstrikethrough : [\n\t\t\t\t\t\t{inline : 'strike', remove : 'all'},\n\t\t\t\t\t\t{inline : 'span', styles : {textDecoration: 'line-through'}, exact : true}\n\t\t\t\t\t],\n\n\t\t\t\t\t// Change font size and font family to use the deprecated font element\n\t\t\t\t\tfontname : {inline : 'font', attributes : {face : '%value'}},\n\t\t\t\t\tfontsize : {\n\t\t\t\t\t\tinline : 'font',\n\t\t\t\t\t\tattributes : {\n\t\t\t\t\t\t\tsize : function(vars) {\n\t\t\t\t\t\t\t\treturn tinymce.inArray(fontSizes, vars.value) + 1;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t},\n\n\t\t\t\t\t// Setup font elements for colors as well\n\t\t\t\t\tforecolor : {inline : 'font', styles : {color : '%value'}},\n\t\t\t\t\thilitecolor : {inline : 'font', styles : {backgroundColor : '%value'}}\n\t\t\t\t});\n\n\t\t\t\t// Check that deprecated elements are allowed if not add them\n\t\t\t\ttinymce.each('b,i,u,strike'.split(','), function(name) {\n\t\t\t\t\tschema.addValidElements(name + '[*]');\n\t\t\t\t});\n\n\t\t\t\t// Add font element if it's missing\n\t\t\t\tif (!schema.getElementRule(\"font\"))\n\t\t\t\t\tschema.addValidElements(\"font[face|size|color|style]\");\n\n\t\t\t\t// Add the missing and depreacted align attribute for the serialization engine\n\t\t\t\ttinymce.each(alignElements.split(','), function(name) {\n\t\t\t\t\tvar rule = schema.getElementRule(name), found;\n\n\t\t\t\t\tif (rule) {\n\t\t\t\t\t\tif (!rule.attributes.align) {\n\t\t\t\t\t\t\trule.attributes.align = {};\n\t\t\t\t\t\t\trule.attributesOrder.push('align');\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// Listen for the onNodeChange event so that we can do special logic for the font size and font name drop boxes\n\t\t\t\teditor.onNodeChange.add(function(editor, control_manager) {\n\t\t\t\t\tvar control, fontElm, fontName, fontSize;\n\n\t\t\t\t\t// Find font element get it's name and size\n\t\t\t\t\tfontElm = editor.dom.getParent(editor.selection.getNode(), 'font');\n\t\t\t\t\tif (fontElm) {\n\t\t\t\t\t\tfontName = fontElm.face;\n\t\t\t\t\t\tfontSize = fontElm.size;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Select/unselect the font name in droplist\n\t\t\t\t\tif (control = control_manager.get('fontselect')) {\n\t\t\t\t\t\tcontrol.select(function(value) {\n\t\t\t\t\t\t\treturn value == fontName;\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\n\t\t\t\t\t// Select/unselect the font size in droplist\n\t\t\t\t\tif (control = control_manager.get('fontsizeselect')) {\n\t\t\t\t\t\tcontrol.select(function(value) {\n\t\t\t\t\t\t\tvar index = tinymce.inArray(fontSizes, value.fontSize);\n\n\t\t\t\t\t\t\treturn index + 1 == fontSize;\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'LegacyOutput',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/legacyoutput',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('legacyoutput', tinymce.plugins.LegacyOutput);\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/plugins/media/editor_plugin.js":"(function(){var d=tinymce.explode(\"id,name,width,height,style,align,class,hspace,vspace,bgcolor,type\"),h=tinymce.makeMap(d.join(\",\")),b=tinymce.html.Node,f,a,g=tinymce.util.JSON,e;f=[[\"Flash\",\"d27cdb6e-ae6d-11cf-96b8-444553540000\",\"application/x-shockwave-flash\",\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0\"],[\"ShockWave\",\"166b1bca-3f9c-11cf-8075-444553540000\",\"application/x-director\",\"http://download.macromedia.com/pub/shockwave/cabs/director/sw.cab#version=8,5,1,0\"],[\"WindowsMedia\",\"6bf52a52-394a-11d3-b153-00c04f79faa6,22d6f312-b0f6-11d0-94ab-0080c74c7e95,05589fa1-c356-11ce-bf01-00aa0055595a\",\"application/x-mplayer2\",\"http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=5,1,52,701\"],[\"QuickTime\",\"02bf25d5-8c17-4b23-bc80-d3488abddc6b\",\"video/quicktime\",\"http://www.apple.com/qtactivex/qtplugin.cab#version=6,0,2,0\"],[\"RealMedia\",\"cfcdaa03-8be4-11cf-b84b-0020afbbccfa\",\"audio/x-pn-realaudio-plugin\",\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0\"],[\"Java\",\"8ad9c840-044e-11d1-b3e9-00805f499d93\",\"application/x-java-applet\",\"http://java.sun.com/products/plugin/autodl/jinstall-1_5_0-windows-i586.cab#Version=1,5,0,0\"],[\"Silverlight\",\"dfeaf541-f3e1-4c24-acac-99c30715084a\",\"application/x-silverlight-2\"],[\"Iframe\"],[\"Video\"],[\"EmbeddedAudio\"],[\"Audio\"]];function c(m){var l,j,k;if(m&&!m.splice){j=[];for(k=0;true;k++){if(m[k]){j[k]=m[k]}else{break}}return j}return m}tinymce.create(\"tinymce.plugins.MediaPlugin\",{init:function(n,j){var r=this,l={},m,p,q,k;function o(i){return i&&i.nodeName===\"IMG\"&&n.dom.hasClass(i,\"mceItemMedia\")}r.editor=n;r.url=j;a=\"\";for(m=0;m<f.length;m++){k=f[m][0];q={name:k,clsids:tinymce.explode(f[m][1]||\"\"),mimes:tinymce.explode(f[m][2]||\"\"),codebase:f[m][3]};for(p=0;p<q.clsids.length;p++){l[\"clsid:\"+q.clsids[p]]=q}for(p=0;p<q.mimes.length;p++){l[q.mimes[p]]=q}l[\"mceItem\"+k]=q;l[k.toLowerCase()]=q;a+=(a?\"|\":\"\")+k}tinymce.each(n.getParam(\"media_types\",\"video=mp4,m4v,ogv,webm;silverlight=xap;flash=swf,flv;shockwave=dcr;quicktime=mov,qt,mpg,mpeg;shockwave=dcr;windowsmedia=avi,wmv,wm,asf,asx,wmx,wvx;realmedia=rm,ra,ram;java=jar;audio=mp3,ogg\").split(\";\"),function(v){var s,u,t;v=v.split(/=/);u=tinymce.explode(v[1].toLowerCase());for(s=0;s<u.length;s++){t=l[v[0].toLowerCase()];if(t){l[u[s]]=t}}});a=new RegExp(\"write(\"+a+\")\\\\(([^)]+)\\\\)\");r.lookup=l;n.onPreInit.add(function(){n.schema.addValidElements(\"object[id|style|width|height|classid|codebase|*],param[name|value],embed[id|style|width|height|type|src|*],video[*],audio[*],source[*]\");n.parser.addNodeFilter(\"object,embed,video,audio,script,iframe\",function(s){var t=s.length;while(t--){r.objectToImg(s[t])}});n.serializer.addNodeFilter(\"img\",function(s,u,t){var v=s.length,w;while(v--){w=s[v];if((w.attr(\"class\")||\"\").indexOf(\"mceItemMedia\")!==-1){r.imgToObject(w,t)}}})});n.onInit.add(function(){if(n.theme&&n.theme.onResolveName){n.theme.onResolveName.add(function(i,s){if(s.name===\"img\"&&n.dom.hasClass(s.node,\"mceItemMedia\")){s.name=\"media\"}})}if(n&&n.plugins.contextmenu){n.plugins.contextmenu.onContextMenu.add(function(s,t,i){if(i.nodeName===\"IMG\"&&i.className.indexOf(\"mceItemMedia\")!==-1){t.add({title:\"media.edit\",icon:\"media\",cmd:\"mceMedia\"})}})}});n.addCommand(\"mceMedia\",function(){var s,i;i=n.selection.getNode();if(o(i)){s=n.dom.getAttrib(i,\"data-mce-json\");if(s){s=g.parse(s);tinymce.each(d,function(t){var u=n.dom.getAttrib(i,t);if(u){s[t]=u}});s.type=r.getType(i.className).name.toLowerCase()}}if(!s){s={type:\"flash\",video:{sources:[]},params:{}}}n.windowManager.open({file:j+\"/media.htm\",width:430+parseInt(n.getLang(\"media.delta_width\",0)),height:500+parseInt(n.getLang(\"media.delta_height\",0)),inline:1},{plugin_url:j,data:s})});n.addButton(\"media\",{title:\"media.desc\",cmd:\"mceMedia\"});n.onNodeChange.add(function(s,i,t){i.setActive(\"media\",o(t))})},convertUrl:function(k,n){var j=this,m=j.editor,l=m.settings,o=l.url_converter,i=l.url_converter_scope||j;if(!k){return k}if(n){return m.documentBaseURI.toAbsolute(k)}return o.call(i,k,\"src\",\"object\")},getInfo:function(){return{longname:\"Media\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/media\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}},dataToImg:function(m,k){var r=this,o=r.editor,p=o.documentBaseURI,j,q,n,l;m.params.src=r.convertUrl(m.params.src,k);q=m.video.attrs;if(q){q.src=r.convertUrl(q.src,k)}if(q){q.poster=r.convertUrl(q.poster,k)}j=c(m.video.sources);if(j){for(l=0;l<j.length;l++){j[l].src=r.convertUrl(j[l].src,k)}}n=r.editor.dom.create(\"img\",{id:m.id,style:m.style,align:m.align,hspace:m.hspace,vspace:m.vspace,src:r.editor.theme.url+\"/img/trans.gif\",\"class\":\"mceItemMedia mceItem\"+r.getType(m.type).name,\"data-mce-json\":g.serialize(m,\"'\")});n.width=m.width||(m.type==\"audio\"?\"300\":\"320\");n.height=m.height||(m.type==\"audio\"?\"32\":\"240\");return n},dataToHtml:function(i,j){return this.editor.serializer.serialize(this.dataToImg(i,j),{forced_root_block:\"\",force_absolute:j})},htmlToData:function(k){var j,i,l;l={type:\"flash\",video:{sources:[]},params:{}};j=this.editor.parser.parse(k);i=j.getAll(\"img\")[0];if(i){l=g.parse(i.attr(\"data-mce-json\"));l.type=this.getType(i.attr(\"class\")).name.toLowerCase();tinymce.each(d,function(m){var n=i.attr(m);if(n){l[m]=n}})}return l},getType:function(m){var k,j,l;j=tinymce.explode(m,\" \");for(k=0;k<j.length;k++){l=this.lookup[j[k]];if(l){return l}}},imgToObject:function(z,o){var u=this,p=u.editor,C,H,j,t,I,y,G,w,k,E,s,q,A,D,m,x,l,B,F;function r(i,n){var M,L,N,K,J;J=p.getParam(\"flash_video_player_url\",u.convertUrl(u.url+\"/moxieplayer.swf\"));if(J){M=p.documentBaseURI;G.params.src=J;if(p.getParam(\"flash_video_player_absvideourl\",true)){i=M.toAbsolute(i||\"\",true);n=M.toAbsolute(n||\"\",true)}N=\"\";L=p.getParam(\"flash_video_player_flashvars\",{url:\"$url\",poster:\"$poster\"});tinymce.each(L,function(P,O){P=P.replace(/\\$url/,i||\"\");P=P.replace(/\\$poster/,n||\"\");if(P.length>0){N+=(N?\"&\":\"\")+O+\"=\"+escape(P)}});if(N.length){G.params.flashvars=N}K=p.getParam(\"flash_video_player_params\",{allowfullscreen:true,allowscriptaccess:true});tinymce.each(K,function(P,O){G.params[O]=\"\"+P})}}G=z.attr(\"data-mce-json\");if(!G){return}G=g.parse(G);q=this.getType(z.attr(\"class\"));B=z.attr(\"data-mce-style\");if(!B){B=z.attr(\"style\");if(B){B=p.dom.serializeStyle(p.dom.parseStyle(B,\"img\"))}}if(q.name===\"Iframe\"){x=new b(\"iframe\",1);tinymce.each(d,function(i){var n=z.attr(i);if(i==\"class\"&&n){n=n.replace(/mceItem.+ ?/g,\"\")}if(n&&n.length>0){x.attr(i,n)}});for(I in G.params){x.attr(I,G.params[I])}x.attr({style:B,src:G.params.src});z.replace(x);return}if(this.editor.settings.media_use_script){x=new b(\"script\",1).attr(\"type\",\"text/javascript\");y=new b(\"#text\",3);y.value=\"write\"+q.name+\"(\"+g.serialize(tinymce.extend(G.params,{width:z.attr(\"width\"),height:z.attr(\"height\")}))+\");\";x.append(y);z.replace(x);return}if(q.name===\"Video\"&&G.video.sources[0]){C=new b(\"video\",1).attr(tinymce.extend({id:z.attr(\"id\"),width:z.attr(\"width\"),height:z.attr(\"height\"),style:B},G.video.attrs));if(G.video.attrs){l=G.video.attrs.poster}k=G.video.sources=c(G.video.sources);for(A=0;A<k.length;A++){if(/\\.mp4$/.test(k[A].src)){m=k[A].src}}if(!k[0].type){C.attr(\"src\",k[0].src);k.splice(0,1)}for(A=0;A<k.length;A++){w=new b(\"source\",1).attr(k[A]);w.shortEnded=true;C.append(w)}if(m){r(m,l);q=u.getType(\"flash\")}else{G.params.src=\"\"}}if(q.name===\"Audio\"&&G.video.sources[0]){F=new b(\"audio\",1).attr(tinymce.extend({id:z.attr(\"id\"),width:z.attr(\"width\"),height:z.attr(\"height\"),style:B},G.video.attrs));if(G.video.attrs){l=G.video.attrs.poster}k=G.video.sources=c(G.video.sources);if(!k[0].type){F.attr(\"src\",k[0].src);k.splice(0,1)}for(A=0;A<k.length;A++){w=new b(\"source\",1).attr(k[A]);w.shortEnded=true;F.append(w)}G.params.src=\"\"}if(q.name===\"EmbeddedAudio\"){j=new b(\"embed\",1);j.shortEnded=true;j.attr({id:z.attr(\"id\"),width:z.attr(\"width\"),height:z.attr(\"height\"),style:B,type:z.attr(\"type\")});for(I in G.params){j.attr(I,G.params[I])}tinymce.each(d,function(i){if(G[i]&&i!=\"type\"){j.attr(i,G[i])}});G.params.src=\"\"}if(G.params.src){if(/\\.flv$/i.test(G.params.src)){r(G.params.src,\"\")}if(o&&o.force_absolute){G.params.src=p.documentBaseURI.toAbsolute(G.params.src)}H=new b(\"object\",1).attr({id:z.attr(\"id\"),width:z.attr(\"width\"),height:z.attr(\"height\"),style:B});tinymce.each(d,function(i){var n=G[i];if(i==\"class\"&&n){n=n.replace(/mceItem.+ ?/g,\"\")}if(n&&i!=\"type\"){H.attr(i,n)}});for(I in G.params){s=new b(\"param\",1);s.shortEnded=true;y=G.params[I];if(I===\"src\"&&q.name===\"WindowsMedia\"){I=\"url\"}s.attr({name:I,value:y});H.append(s)}if(this.editor.getParam(\"media_strict\",true)){H.attr({data:G.params.src,type:q.mimes[0]})}else{H.attr({classid:\"clsid:\"+q.clsids[0],codebase:q.codebase});j=new b(\"embed\",1);j.shortEnded=true;j.attr({id:z.attr(\"id\"),width:z.attr(\"width\"),height:z.attr(\"height\"),style:B,type:q.mimes[0]});for(I in G.params){j.attr(I,G.params[I])}tinymce.each(d,function(i){if(G[i]&&i!=\"type\"){j.attr(i,G[i])}});H.append(j)}if(G.object_html){y=new b(\"#text\",3);y.raw=true;y.value=G.object_html;H.append(y)}if(C){C.append(H)}}if(C){if(G.video_html){y=new b(\"#text\",3);y.raw=true;y.value=G.video_html;C.append(y)}}if(F){if(G.video_html){y=new b(\"#text\",3);y.raw=true;y.value=G.video_html;F.append(y)}}var v=C||F||H||j;if(v){z.replace(v)}else{z.remove()}},objectToImg:function(C){var L,k,F,s,M,N,y,A,x,G,E,t,q,I,B,l,K,o,H=this.lookup,m,z,v=this.editor.settings.url_converter,n=this.editor.settings.url_converter_scope,w,r,D,j;function u(i){return new tinymce.html.Serializer({inner:true,validate:false}).serialize(i)}function J(O,i){return H[(O.attr(i)||\"\").toLowerCase()]}function p(O){var i=O.replace(/^.*\\.([^.]+)$/,\"$1\");return H[i.toLowerCase()||\"\"]}if(!C.parent){return}if(C.name===\"script\"){if(C.firstChild){m=a.exec(C.firstChild.value)}if(!m){return}o=m[1];K={video:{},params:g.parse(m[2])};A=K.params.width;x=K.params.height}K=K||{video:{},params:{}};M=new b(\"img\",1);M.attr({src:this.editor.theme.url+\"/img/trans.gif\"});N=C.name;if(N===\"video\"||N==\"audio\"){F=C;L=C.getAll(\"object\")[0];k=C.getAll(\"embed\")[0];A=F.attr(\"width\");x=F.attr(\"height\");y=F.attr(\"id\");K.video={attrs:{},sources:[]};z=K.video.attrs;for(N in F.attributes.map){z[N]=F.attributes.map[N]}B=C.attr(\"src\");if(B){K.video.sources.push({src:v.call(n,B,\"src\",C.name)})}l=F.getAll(\"source\");for(E=0;E<l.length;E++){B=l[E].remove();K.video.sources.push({src:v.call(n,B.attr(\"src\"),\"src\",\"source\"),type:B.attr(\"type\"),media:B.attr(\"media\")})}if(z.poster){z.poster=v.call(n,z.poster,\"poster\",C.name)}}if(C.name===\"object\"){L=C;k=C.getAll(\"embed\")[0]}if(C.name===\"embed\"){k=C}if(C.name===\"iframe\"){s=C;o=\"Iframe\"}if(L){A=A||L.attr(\"width\");x=x||L.attr(\"height\");G=G||L.attr(\"style\");y=y||L.attr(\"id\");w=w||L.attr(\"hspace\");r=r||L.attr(\"vspace\");D=D||L.attr(\"align\");j=j||L.attr(\"bgcolor\");K.name=L.attr(\"name\");I=L.getAll(\"param\");for(E=0;E<I.length;E++){q=I[E];N=q.remove().attr(\"name\");if(!h[N]){K.params[N]=q.attr(\"value\")}}K.params.src=K.params.src||L.attr(\"data\")}if(k){A=A||k.attr(\"width\");x=x||k.attr(\"height\");G=G||k.attr(\"style\");y=y||k.attr(\"id\");w=w||k.attr(\"hspace\");r=r||k.attr(\"vspace\");D=D||k.attr(\"align\");j=j||k.attr(\"bgcolor\");for(N in k.attributes.map){if(!h[N]&&!K.params[N]){K.params[N]=k.attributes.map[N]}}}if(s){A=s.attr(\"width\");x=s.attr(\"height\");G=G||s.attr(\"style\");y=s.attr(\"id\");w=s.attr(\"hspace\");r=s.attr(\"vspace\");D=s.attr(\"align\");j=s.attr(\"bgcolor\");tinymce.each(d,function(i){M.attr(i,s.attr(i))});for(N in s.attributes.map){if(!h[N]&&!K.params[N]){K.params[N]=s.attributes.map[N]}}}if(K.params.movie){K.params.src=K.params.src||K.params.movie;delete K.params.movie}if(K.params.src){K.params.src=v.call(n,K.params.src,\"src\",\"object\")}if(F){if(C.name===\"video\"){o=H.video.name}else{if(C.name===\"audio\"){o=H.audio.name}}}if(L&&!o){o=(J(L,\"clsid\")||J(L,\"classid\")||J(L,\"type\")||{}).name}if(k&&!o){o=(J(k,\"type\")||p(K.params.src)||{}).name}if(k&&o==\"EmbeddedAudio\"){K.params.type=k.attr(\"type\")}C.replace(M);if(k){k.remove()}if(L){t=u(L.remove());if(t){K.object_html=t}}if(F){t=u(F.remove());if(t){K.video_html=t}}K.hspace=w;K.vspace=r;K.align=D;K.bgcolor=j;M.attr({id:y,\"class\":\"mceItemMedia mceItem\"+(o||\"Flash\"),style:G,width:A||(C.name==\"audio\"?\"300\":\"320\"),height:x||(C.name==\"audio\"?\"32\":\"240\"),hspace:w,vspace:r,align:D,bgcolor:j,\"data-mce-json\":g.serialize(K,\"'\")})}});tinymce.PluginManager.add(\"media\",tinymce.plugins.MediaPlugin)})();","Magento_Tinymce3/tiny_mce/plugins/media/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\tvar rootAttributes = tinymce.explode('id,name,width,height,style,align,class,hspace,vspace,bgcolor,type'), excludedAttrs = tinymce.makeMap(rootAttributes.join(',')), Node = tinymce.html.Node,\n\t\tmediaTypes, scriptRegExp, JSON = tinymce.util.JSON, mimeTypes;\n\n\t// Media types supported by this plugin\n\tmediaTypes = [\n\t\t// Type, clsid:s, mime types, codebase\n\t\t[\"Flash\", \"d27cdb6e-ae6d-11cf-96b8-444553540000\", \"application/x-shockwave-flash\", \"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0\"],\n\t\t[\"ShockWave\", \"166b1bca-3f9c-11cf-8075-444553540000\", \"application/x-director\", \"http://download.macromedia.com/pub/shockwave/cabs/director/sw.cab#version=8,5,1,0\"],\n\t\t[\"WindowsMedia\", \"6bf52a52-394a-11d3-b153-00c04f79faa6,22d6f312-b0f6-11d0-94ab-0080c74c7e95,05589fa1-c356-11ce-bf01-00aa0055595a\", \"application/x-mplayer2\", \"http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=5,1,52,701\"],\n\t\t[\"QuickTime\", \"02bf25d5-8c17-4b23-bc80-d3488abddc6b\", \"video/quicktime\", \"http://www.apple.com/qtactivex/qtplugin.cab#version=6,0,2,0\"],\n\t\t[\"RealMedia\", \"cfcdaa03-8be4-11cf-b84b-0020afbbccfa\", \"audio/x-pn-realaudio-plugin\", \"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0\"],\n\t\t[\"Java\", \"8ad9c840-044e-11d1-b3e9-00805f499d93\", \"application/x-java-applet\", \"http://java.sun.com/products/plugin/autodl/jinstall-1_5_0-windows-i586.cab#Version=1,5,0,0\"],\n\t\t[\"Silverlight\", \"dfeaf541-f3e1-4c24-acac-99c30715084a\", \"application/x-silverlight-2\"],\n\t\t[\"Iframe\"],\n\t\t[\"Video\"],\n\t\t[\"EmbeddedAudio\"],\n\t\t[\"Audio\"]\n\t];\n\n\tfunction toArray(obj) {\n\t\tvar undef, out, i;\n\n\t\tif (obj && !obj.splice) {\n\t\t\tout = [];\n\n\t\t\tfor (i = 0; true; i++) {\n\t\t\t\tif (obj[i])\n\t\t\t\t\tout[i] = obj[i];\n\t\t\t\telse\n\t\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\treturn out;\n\t\t}\n\n\t\treturn obj;\n\t};\n\n\ttinymce.create('tinymce.plugins.MediaPlugin', {\n\t\tinit : function(ed, url) {\n\t\t\tvar self = this, lookup = {}, i, y, item, name;\n\n\t\t\tfunction isMediaImg(node) {\n\t\t\t\treturn node && node.nodeName === 'IMG' && ed.dom.hasClass(node, 'mceItemMedia');\n\t\t\t};\n\n\t\t\tself.editor = ed;\n\t\t\tself.url = url;\n\n\t\t\t// Parse media types into a lookup table\n\t\t\tscriptRegExp = '';\n\t\t\tfor (i = 0; i < mediaTypes.length; i++) {\n\t\t\t\tname = mediaTypes[i][0];\n\n\t\t\t\titem = {\n\t\t\t\t\tname : name,\n\t\t\t\t\tclsids : tinymce.explode(mediaTypes[i][1] || ''),\n\t\t\t\t\tmimes : tinymce.explode(mediaTypes[i][2] || ''),\n\t\t\t\t\tcodebase : mediaTypes[i][3]\n\t\t\t\t};\n\n\t\t\t\tfor (y = 0; y < item.clsids.length; y++)\n\t\t\t\t\tlookup['clsid:' + item.clsids[y]] = item;\n\n\t\t\t\tfor (y = 0; y < item.mimes.length; y++)\n\t\t\t\t\tlookup[item.mimes[y]] = item;\n\n\t\t\t\tlookup['mceItem' + name] = item;\n\t\t\t\tlookup[name.toLowerCase()] = item;\n\n\t\t\t\tscriptRegExp += (scriptRegExp ? '|' : '') + name;\n\t\t\t}\n\n\t\t\t// Handle the media_types setting\n\t\t\ttinymce.each(ed.getParam(\"media_types\",\n\t\t\t\t\"video=mp4,m4v,ogv,webm;\" +\n\t\t\t\t\"silverlight=xap;\" +\n\t\t\t\t\"flash=swf,flv;\" +\n\t\t\t\t\"shockwave=dcr;\" +\n\t\t\t\t\"quicktime=mov,qt,mpg,mpeg;\" +\n\t\t\t\t\"shockwave=dcr;\" +\n\t\t\t\t\"windowsmedia=avi,wmv,wm,asf,asx,wmx,wvx;\" +\n\t\t\t\t\"realmedia=rm,ra,ram;\" +\n\t\t\t\t\"java=jar;\" +\n\t\t\t\t\"audio=mp3,ogg\"\n\t\t\t).split(';'), function(item) {\n\t\t\t\tvar i, extensions, type;\n\n\t\t\t\titem = item.split(/=/);\n\t\t\t\textensions = tinymce.explode(item[1].toLowerCase());\n\t\t\t\tfor (i = 0; i < extensions.length; i++) {\n\t\t\t\t\ttype = lookup[item[0].toLowerCase()];\n\n\t\t\t\t\tif (type)\n\t\t\t\t\t\tlookup[extensions[i]] = type;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tscriptRegExp = new RegExp('write(' + scriptRegExp + ')\\\\(([^)]+)\\\\)');\n\t\t\tself.lookup = lookup;\n\n\t\t\ted.onPreInit.add(function() {\n\t\t\t\t// Allow video elements\n\t\t\t\ted.schema.addValidElements('object[id|style|width|height|classid|codebase|*],param[name|value],embed[id|style|width|height|type|src|*],video[*],audio[*],source[*]');\n\n\t\t\t\t// Convert video elements to image placeholder\n\t\t\t\ted.parser.addNodeFilter('object,embed,video,audio,script,iframe', function(nodes) {\n\t\t\t\t\tvar i = nodes.length;\n\n\t\t\t\t\twhile (i--)\n\t\t\t\t\t\tself.objectToImg(nodes[i]);\n\t\t\t\t});\n\n\t\t\t\t// Convert image placeholders to video elements\n\t\t\t\ted.serializer.addNodeFilter('img', function(nodes, name, args) {\n\t\t\t\t\tvar i = nodes.length, node;\n\n\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\t\tif ((node.attr('class') || '').indexOf('mceItemMedia') !== -1)\n\t\t\t\t\t\t\tself.imgToObject(node, args);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t});\n\n\t\t\ted.onInit.add(function() {\n\t\t\t\t// Display \"media\" instead of \"img\" in element path\n\t\t\t\tif (ed.theme && ed.theme.onResolveName) {\n\t\t\t\t\ted.theme.onResolveName.add(function(theme, path_object) {\n\t\t\t\t\t\tif (path_object.name === 'img' && ed.dom.hasClass(path_object.node, 'mceItemMedia'))\n\t\t\t\t\t\t\tpath_object.name = 'media';\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\t// Add contect menu if it's loaded\n\t\t\t\tif (ed && ed.plugins.contextmenu) {\n\t\t\t\t\ted.plugins.contextmenu.onContextMenu.add(function(plugin, menu, element) {\n\t\t\t\t\t\tif (element.nodeName === 'IMG' && element.className.indexOf('mceItemMedia') !== -1)\n\t\t\t\t\t\t\tmenu.add({title : 'media.edit', icon : 'media', cmd : 'mceMedia'});\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceMedia', function() {\n\t\t\t\tvar data, img;\n\n\t\t\t\timg = ed.selection.getNode();\n\t\t\t\tif (isMediaImg(img)) {\n\t\t\t\t\tdata = ed.dom.getAttrib(img, 'data-mce-json');\n\t\t\t\t\tif (data) {\n\t\t\t\t\t\tdata = JSON.parse(data);\n\n\t\t\t\t\t\t// Add some extra properties to the data object\n\t\t\t\t\t\ttinymce.each(rootAttributes, function(name) {\n\t\t\t\t\t\t\tvar value = ed.dom.getAttrib(img, name);\n\n\t\t\t\t\t\t\tif (value)\n\t\t\t\t\t\t\t\tdata[name] = value;\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tdata.type = self.getType(img.className).name.toLowerCase();\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (!data) {\n\t\t\t\t\tdata = {\n\t\t\t\t\t\ttype : 'flash',\n\t\t\t\t\t\tvideo: {sources:[]},\n\t\t\t\t\t\tparams: {}\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/media.htm',\n\t\t\t\t\twidth : 430 + parseInt(ed.getLang('media.delta_width', 0)),\n\t\t\t\t\theight : 500 + parseInt(ed.getLang('media.delta_height', 0)),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url,\n\t\t\t\t\tdata : data\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('media', {title : 'media.desc', cmd : 'mceMedia'});\n\n\t\t\t// Update media selection status\n\t\t\ted.onNodeChange.add(function(ed, cm, node) {\n\t\t\t\tcm.setActive('media', isMediaImg(node));\n\t\t\t});\n\t\t},\n\n\t\tconvertUrl : function(url, force_absolute) {\n\t\t\tvar self = this, editor = self.editor, settings = editor.settings,\n\t\t\t\turlConverter = settings.url_converter,\n\t\t\t\turlConverterScope = settings.url_converter_scope || self;\n\n\t\t\tif (!url)\n\t\t\t\treturn url;\n\n\t\t\tif (force_absolute)\n\t\t\t\treturn editor.documentBaseURI.toAbsolute(url);\n\n\t\t\treturn urlConverter.call(urlConverterScope, url, 'src', 'object');\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Media',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/media',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t},\n\n\t\t/**\n\t\t * Converts the JSON data object to an img node.\n\t\t */\n\t\tdataToImg : function(data, force_absolute) {\n\t\t\tvar self = this, editor = self.editor, baseUri = editor.documentBaseURI, sources, attrs, img, i;\n\n\t\t\tdata.params.src = self.convertUrl(data.params.src, force_absolute);\n\n\t\t\tattrs = data.video.attrs;\n\t\t\tif (attrs)\n\t\t\t\tattrs.src = self.convertUrl(attrs.src, force_absolute);\n\n\t\t\tif (attrs)\n\t\t\t\tattrs.poster = self.convertUrl(attrs.poster, force_absolute);\n\n\t\t\tsources = toArray(data.video.sources);\n\t\t\tif (sources) {\n\t\t\t\tfor (i = 0; i < sources.length; i++)\n\t\t\t\t\tsources[i].src = self.convertUrl(sources[i].src, force_absolute);\n\t\t\t}\n\n\t\t\timg = self.editor.dom.create('img', {\n\t\t\t\tid : data.id,\n\t\t\t\tstyle : data.style,\n\t\t\t\talign : data.align,\n\t\t\t\thspace : data.hspace,\n\t\t\t\tvspace : data.vspace,\n\t\t\t\tsrc : self.editor.theme.url + '/img/trans.gif',\n\t\t\t\t'class' : 'mceItemMedia mceItem' + self.getType(data.type).name,\n\t\t\t\t'data-mce-json' : JSON.serialize(data, \"'\")\n\t\t\t});\n\n\t\t\timg.width = data.width || (data.type == 'audio' ? \"300\" : \"320\");\n\t\t\timg.height = data.height || (data.type == 'audio' ? \"32\" : \"240\");\n\n\t\t\treturn img;\n\t\t},\n\n\t\t/**\n\t\t * Converts the JSON data object to a HTML string.\n\t\t */\n\t\tdataToHtml : function(data, force_absolute) {\n\t\t\treturn this.editor.serializer.serialize(this.dataToImg(data, force_absolute), {forced_root_block : '', force_absolute : force_absolute});\n\t\t},\n\n\t\t/**\n\t\t * Converts the JSON data object to a HTML string.\n\t\t */\n\t\thtmlToData : function(html) {\n\t\t\tvar fragment, img, data;\n\n\t\t\tdata = {\n\t\t\t\ttype : 'flash',\n\t\t\t\tvideo: {sources:[]},\n\t\t\t\tparams: {}\n\t\t\t};\n\n\t\t\tfragment = this.editor.parser.parse(html);\n\t\t\timg = fragment.getAll('img')[0];\n\n\t\t\tif (img) {\n\t\t\t\tdata = JSON.parse(img.attr('data-mce-json'));\n\t\t\t\tdata.type = this.getType(img.attr('class')).name.toLowerCase();\n\n\t\t\t\t// Add some extra properties to the data object\n\t\t\t\ttinymce.each(rootAttributes, function(name) {\n\t\t\t\t\tvar value = img.attr(name);\n\n\t\t\t\t\tif (value)\n\t\t\t\t\t\tdata[name] = value;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn data;\n\t\t},\n\n\t\t/**\n\t\t * Get type item by extension, class, clsid or mime type.\n\t\t *\n\t\t * @method getType\n\t\t * @param {String} value Value to get type item by.\n\t\t * @return {Object} Type item object or undefined.\n\t\t */\n\t\tgetType : function(value) {\n\t\t\tvar i, values, typeItem;\n\n\t\t\t// Find type by checking the classes\n\t\t\tvalues = tinymce.explode(value, ' ');\n\t\t\tfor (i = 0; i < values.length; i++) {\n\t\t\t\ttypeItem = this.lookup[values[i]];\n\n\t\t\t\tif (typeItem)\n\t\t\t\t\treturn typeItem;\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Converts a tinymce.html.Node image element to video/object/embed.\n\t\t */\n\t\timgToObject : function(node, args) {\n\t\t\tvar self = this, editor = self.editor, video, object, embed, iframe, name, value, data,\n\t\t\t\tsource, sources, params, param, typeItem, i, item, mp4Source, replacement,\n\t\t\t\tposterSrc, style, audio;\n\n\t\t\t// Adds the flash player\n\t\t\tfunction addPlayer(video_src, poster_src) {\n\t\t\t\tvar baseUri, flashVars, flashVarsOutput, params, flashPlayer;\n\n\t\t\t\tflashPlayer = editor.getParam('flash_video_player_url', self.convertUrl(self.url + '/moxieplayer.swf'));\n\t\t\t\tif (flashPlayer) {\n\t\t\t\t\tbaseUri = editor.documentBaseURI;\n\t\t\t\t\tdata.params.src = flashPlayer;\n\n\t\t\t\t\t// Convert the movie url to absolute urls\n\t\t\t\t\tif (editor.getParam('flash_video_player_absvideourl', true)) {\n\t\t\t\t\t\tvideo_src = baseUri.toAbsolute(video_src || '', true);\n\t\t\t\t\t\tposter_src = baseUri.toAbsolute(poster_src || '', true);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Generate flash vars\n\t\t\t\t\tflashVarsOutput = '';\n\t\t\t\t\tflashVars = editor.getParam('flash_video_player_flashvars', {url : '$url', poster : '$poster'});\n\t\t\t\t\ttinymce.each(flashVars, function(value, name) {\n\t\t\t\t\t\t// Replace $url and $poster variables in flashvars value\n\t\t\t\t\t\tvalue = value.replace(/\\$url/, video_src || '');\n\t\t\t\t\t\tvalue = value.replace(/\\$poster/, poster_src || '');\n\n\t\t\t\t\t\tif (value.length > 0)\n\t\t\t\t\t\t\tflashVarsOutput += (flashVarsOutput ? '&' : '') + name + '=' + escape(value);\n\t\t\t\t\t});\n\n\t\t\t\t\tif (flashVarsOutput.length)\n\t\t\t\t\t\tdata.params.flashvars = flashVarsOutput;\n\n\t\t\t\t\tparams = editor.getParam('flash_video_player_params', {\n\t\t\t\t\t\tallowfullscreen: true,\n\t\t\t\t\t\tallowscriptaccess: true\n\t\t\t\t\t});\n\n\t\t\t\t\ttinymce.each(params, function(value, name) {\n\t\t\t\t\t\tdata.params[name] = \"\" + value;\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tdata = node.attr('data-mce-json');\n\t\t\tif (!data)\n\t\t\t\treturn;\n\n\t\t\tdata = JSON.parse(data);\n\t\t\ttypeItem = this.getType(node.attr('class'));\n\n\t\t\tstyle = node.attr('data-mce-style')\n\t\t\tif (!style) {\n\t\t\t\tstyle = node.attr('style');\n\n\t\t\t\tif (style)\n\t\t\t\t\tstyle = editor.dom.serializeStyle(editor.dom.parseStyle(style, 'img'));\n\t\t\t}\n\n\t\t\t// Handle iframe\n\t\t\tif (typeItem.name === 'Iframe') {\n\t\t\t\treplacement = new Node('iframe', 1);\n\n\t\t\t\ttinymce.each(rootAttributes, function(name) {\n\t\t\t\t\tvar value = node.attr(name);\n\n\t\t\t\t\tif (name == 'class' && value)\n\t\t\t\t\t\tvalue = value.replace(/mceItem.+ ?/g, '');\n\n\t\t\t\t\tif (value && value.length > 0)\n\t\t\t\t\t\treplacement.attr(name, value);\n\t\t\t\t});\n\n\t\t\t\tfor (name in data.params)\n\t\t\t\t\treplacement.attr(name, data.params[name]);\n\n\t\t\t\treplacement.attr({\n\t\t\t\t\tstyle: style,\n\t\t\t\t\tsrc: data.params.src\n\t\t\t\t});\n\n\t\t\t\tnode.replace(replacement);\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Handle scripts\n\t\t\tif (this.editor.settings.media_use_script) {\n\t\t\t\treplacement = new Node('script', 1).attr('type', 'text/javascript');\n\n\t\t\t\tvalue = new Node('#text', 3);\n\t\t\t\tvalue.value = 'write' + typeItem.name + '(' + JSON.serialize(tinymce.extend(data.params, {\n\t\t\t\t\twidth: node.attr('width'),\n\t\t\t\t\theight: node.attr('height')\n\t\t\t\t})) + ');';\n\n\t\t\t\treplacement.append(value);\n\t\t\t\tnode.replace(replacement);\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Add HTML5 video element\n\t\t\tif (typeItem.name === 'Video' && data.video.sources[0]) {\n\t\t\t\t// Create new object element\n\t\t\t\tvideo = new Node('video', 1).attr(tinymce.extend({\n\t\t\t\t\tid : node.attr('id'),\n\t\t\t\t\twidth: node.attr('width'),\n\t\t\t\t\theight: node.attr('height'),\n\t\t\t\t\tstyle : style\n\t\t\t\t}, data.video.attrs));\n\n\t\t\t\t// Get poster source and use that for flash fallback\n\t\t\t\tif (data.video.attrs)\n\t\t\t\t\tposterSrc = data.video.attrs.poster;\n\n\t\t\t\tsources = data.video.sources = toArray(data.video.sources);\n\t\t\t\tfor (i = 0; i < sources.length; i++) {\n\t\t\t\t\tif (/\\.mp4$/.test(sources[i].src))\n\t\t\t\t\t\tmp4Source = sources[i].src;\n\t\t\t\t}\n\n\t\t\t\tif (!sources[0].type) {\n\t\t\t\t\tvideo.attr('src', sources[0].src);\n\t\t\t\t\tsources.splice(0, 1);\n\t\t\t\t}\n\n\t\t\t\tfor (i = 0; i < sources.length; i++) {\n\t\t\t\t\tsource = new Node('source', 1).attr(sources[i]);\n\t\t\t\t\tsource.shortEnded = true;\n\t\t\t\t\tvideo.append(source);\n\t\t\t\t}\n\n\t\t\t\t// Create flash fallback for video if we have a mp4 source\n\t\t\t\tif (mp4Source) {\n\t\t\t\t\taddPlayer(mp4Source, posterSrc);\n\t\t\t\t\ttypeItem = self.getType('flash');\n\t\t\t\t} else\n\t\t\t\t\tdata.params.src = '';\n\t\t\t}\n\n\t\t\t// Add HTML5 audio element\n\t\t\tif (typeItem.name === 'Audio' && data.video.sources[0]) {\n\t\t\t\t// Create new object element\n\t\t\t\taudio = new Node('audio', 1).attr(tinymce.extend({\n\t\t\t\t\tid : node.attr('id'),\n\t\t\t\t\twidth: node.attr('width'),\n\t\t\t\t\theight: node.attr('height'),\n\t\t\t\t\tstyle : style\n\t\t\t\t}, data.video.attrs));\n\n\t\t\t\t// Get poster source and use that for flash fallback\n\t\t\t\tif (data.video.attrs)\n\t\t\t\t\tposterSrc = data.video.attrs.poster;\n\n\t\t\t\tsources = data.video.sources = toArray(data.video.sources);\n\t\t\t\tif (!sources[0].type) {\n\t\t\t\t\taudio.attr('src', sources[0].src);\n\t\t\t\t\tsources.splice(0, 1);\n\t\t\t\t}\n\n\t\t\t\tfor (i = 0; i < sources.length; i++) {\n\t\t\t\t\tsource = new Node('source', 1).attr(sources[i]);\n\t\t\t\t\tsource.shortEnded = true;\n\t\t\t\t\taudio.append(source);\n\t\t\t\t}\n\n\t\t\t\tdata.params.src = '';\n\t\t\t}\n\n\t\t\tif (typeItem.name === 'EmbeddedAudio') {\n\t\t\t\tembed = new Node('embed', 1);\n\t\t\t\tembed.shortEnded = true;\n\t\t\t\tembed.attr({\n\t\t\t\t\tid: node.attr('id'),\n\t\t\t\t\twidth: node.attr('width'),\n\t\t\t\t\theight: node.attr('height'),\n\t\t\t\t\tstyle : style,\n\t\t\t\t\ttype: node.attr('type')\n\t\t\t\t});\n\n\t\t\t\tfor (name in data.params)\n\t\t\t\t\tembed.attr(name, data.params[name]);\n\n\t\t\t\ttinymce.each(rootAttributes, function(name) {\n\t\t\t\t\tif (data[name] && name != 'type')\n\t\t\t\t\t\tembed.attr(name, data[name]);\n\t\t\t\t});\n\n\t\t\t\tdata.params.src = '';\n\t\t\t}\n\n\t\t\t// Do we have a params src then we can generate object\n\t\t\tif (data.params.src) {\n\t\t\t\t// Is flv movie add player for it\n\t\t\t\tif (/\\.flv$/i.test(data.params.src))\n\t\t\t\t\taddPlayer(data.params.src, '');\n\n\t\t\t\tif (args && args.force_absolute)\n\t\t\t\t\tdata.params.src = editor.documentBaseURI.toAbsolute(data.params.src);\n\n\t\t\t\t// Create new object element\n\t\t\t\tobject = new Node('object', 1).attr({\n\t\t\t\t\tid : node.attr('id'),\n\t\t\t\t\twidth: node.attr('width'),\n\t\t\t\t\theight: node.attr('height'),\n\t\t\t\t\tstyle : style\n\t\t\t\t});\n\n\t\t\t\ttinymce.each(rootAttributes, function(name) {\n\t\t\t\t\tvar value = data[name];\n\n\t\t\t\t\tif (name == 'class' && value)\n\t\t\t\t\t\tvalue = value.replace(/mceItem.+ ?/g, '');\n\n\t\t\t\t\tif (value && name != 'type')\n\t\t\t\t\t\tobject.attr(name, value);\n\t\t\t\t});\n\n\t\t\t\t// Add params\n\t\t\t\tfor (name in data.params) {\n\t\t\t\t\tparam = new Node('param', 1);\n\t\t\t\t\tparam.shortEnded = true;\n\t\t\t\t\tvalue = data.params[name];\n\n\t\t\t\t\t// Windows media needs to use url instead of src for the media URL\n\t\t\t\t\tif (name === 'src' && typeItem.name === 'WindowsMedia')\n\t\t\t\t\t\tname = 'url';\n\n\t\t\t\t\tparam.attr({name: name, value: value});\n\t\t\t\t\tobject.append(param);\n\t\t\t\t}\n\n\t\t\t\t// Setup add type and classid if strict is disabled\n\t\t\t\tif (this.editor.getParam('media_strict', true)) {\n\t\t\t\t\tobject.attr({\n\t\t\t\t\t\tdata: data.params.src,\n\t\t\t\t\t\ttype: typeItem.mimes[0]\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\tobject.attr({\n\t\t\t\t\t\tclassid: \"clsid:\" + typeItem.clsids[0],\n\t\t\t\t\t\tcodebase: typeItem.codebase\n\t\t\t\t\t});\n\n\t\t\t\t\tembed = new Node('embed', 1);\n\t\t\t\t\tembed.shortEnded = true;\n\t\t\t\t\tembed.attr({\n\t\t\t\t\t\tid: node.attr('id'),\n\t\t\t\t\t\twidth: node.attr('width'),\n\t\t\t\t\t\theight: node.attr('height'),\n\t\t\t\t\t\tstyle : style,\n\t\t\t\t\t\ttype: typeItem.mimes[0]\n\t\t\t\t\t});\n\n\t\t\t\t\tfor (name in data.params)\n\t\t\t\t\t\tembed.attr(name, data.params[name]);\n\n\t\t\t\t\ttinymce.each(rootAttributes, function(name) {\n\t\t\t\t\t\tif (data[name] && name != 'type')\n\t\t\t\t\t\t\tembed.attr(name, data[name]);\n\t\t\t\t\t});\n\n\t\t\t\t\tobject.append(embed);\n\t\t\t\t}\n\n\t\t\t\t// Insert raw HTML\n\t\t\t\tif (data.object_html) {\n\t\t\t\t\tvalue = new Node('#text', 3);\n\t\t\t\t\tvalue.raw = true;\n\t\t\t\t\tvalue.value = data.object_html;\n\t\t\t\t\tobject.append(value);\n\t\t\t\t}\n\n\t\t\t\t// Append object to video element if it exists\n\t\t\t\tif (video)\n\t\t\t\t\tvideo.append(object);\n\t\t\t}\n\n\t\t\tif (video) {\n\t\t\t\t// Insert raw HTML\n\t\t\t\tif (data.video_html) {\n\t\t\t\t\tvalue = new Node('#text', 3);\n\t\t\t\t\tvalue.raw = true;\n\t\t\t\t\tvalue.value = data.video_html;\n\t\t\t\t\tvideo.append(value);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (audio) {\n\t\t\t\t// Insert raw HTML\n\t\t\t\tif (data.video_html) {\n\t\t\t\t\tvalue = new Node('#text', 3);\n\t\t\t\t\tvalue.raw = true;\n\t\t\t\t\tvalue.value = data.video_html;\n\t\t\t\t\taudio.append(value);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tvar n = video || audio || object || embed;\n\t\t\tif (n)\n\t\t\t\tnode.replace(n);\n\t\t\telse\n\t\t\t\tnode.remove();\n\t\t},\n\n\t\t/**\n\t\t * Converts a tinymce.html.Node video/object/embed to an img element.\n\t\t *\n\t\t * The video/object/embed will be converted into an image placeholder with a JSON data attribute like this:\n\t\t * <img class=\"mceItemMedia mceItemFlash\" width=\"100\" height=\"100\" data-mce-json=\"{..}\" />\n\t\t *\n\t\t * The JSON structure will be like this:\n\t\t * {'params':{'flashvars':'something','quality':'high','src':'someurl'}, 'video':{'sources':[{src: 'someurl', type: 'video/mp4'}]}}\n\t\t */\n\t\tobjectToImg : function(node) {\n\t\t\tvar object, embed, video, iframe, img, name, id, width, height, style, i, html,\n\t\t\t\tparam, params, source, sources, data, type, lookup = this.lookup,\n\t\t\t\tmatches, attrs, urlConverter = this.editor.settings.url_converter,\n\t\t\t\turlConverterScope = this.editor.settings.url_converter_scope,\n\t\t\t\thspace, vspace, align, bgcolor;\n\n\t\t\tfunction getInnerHTML(node) {\n\t\t\t\treturn new tinymce.html.Serializer({\n\t\t\t\t\tinner: true,\n\t\t\t\t\tvalidate: false\n\t\t\t\t}).serialize(node);\n\t\t\t};\n\n\t\t\tfunction lookupAttribute(o, attr) {\n\t\t\t\treturn lookup[(o.attr(attr) || '').toLowerCase()];\n\t\t\t}\n\n\t\t\tfunction lookupExtension(src) {\n\t\t\t\tvar ext = src.replace(/^.*\\.([^.]+)$/, '$1');\n\t\t\t\treturn lookup[ext.toLowerCase() || ''];\n\t\t\t}\n\n\t\t\t// If node isn't in document\n\t\t\tif (!node.parent)\n\t\t\t\treturn;\n\n\t\t\t// Handle media scripts\n\t\t\tif (node.name === 'script') {\n\t\t\t\tif (node.firstChild)\n\t\t\t\t\tmatches = scriptRegExp.exec(node.firstChild.value);\n\n\t\t\t\tif (!matches)\n\t\t\t\t\treturn;\n\n\t\t\t\ttype = matches[1];\n\t\t\t\tdata = {video : {}, params : JSON.parse(matches[2])};\n\t\t\t\twidth = data.params.width;\n\t\t\t\theight = data.params.height;\n\t\t\t}\n\n\t\t\t// Setup data objects\n\t\t\tdata = data || {\n\t\t\t\tvideo : {},\n\t\t\t\tparams : {}\n\t\t\t};\n\n\t\t\t// Setup new image object\n\t\t\timg = new Node('img', 1);\n\t\t\timg.attr({\n\t\t\t\tsrc : this.editor.theme.url + '/img/trans.gif'\n\t\t\t});\n\n\t\t\t// Video element\n\t\t\tname = node.name;\n\t\t\tif (name === 'video' || name == 'audio') {\n\t\t\t\tvideo = node;\n\t\t\t\tobject = node.getAll('object')[0];\n\t\t\t\tembed = node.getAll('embed')[0];\n\t\t\t\twidth = video.attr('width');\n\t\t\t\theight = video.attr('height');\n\t\t\t\tid = video.attr('id');\n\t\t\t\tdata.video = {attrs : {}, sources : []};\n\n\t\t\t\t// Get all video attributes\n\t\t\t\tattrs = data.video.attrs;\n\t\t\t\tfor (name in video.attributes.map)\n\t\t\t\t\tattrs[name] = video.attributes.map[name];\n\n\t\t\t\tsource = node.attr('src');\n\t\t\t\tif (source)\n\t\t\t\t\tdata.video.sources.push({src : urlConverter.call(urlConverterScope, source, 'src', node.name)});\n\n\t\t\t\t// Get all sources\n\t\t\t\tsources = video.getAll(\"source\");\n\t\t\t\tfor (i = 0; i < sources.length; i++) {\n\t\t\t\t\tsource = sources[i].remove();\n\n\t\t\t\t\tdata.video.sources.push({\n\t\t\t\t\t\tsrc: urlConverter.call(urlConverterScope, source.attr('src'), 'src', 'source'),\n\t\t\t\t\t\ttype: source.attr('type'),\n\t\t\t\t\t\tmedia: source.attr('media')\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\t// Convert the poster URL\n\t\t\t\tif (attrs.poster)\n\t\t\t\t\tattrs.poster = urlConverter.call(urlConverterScope, attrs.poster, 'poster', node.name);\n\t\t\t}\n\n\t\t\t// Object element\n\t\t\tif (node.name === 'object') {\n\t\t\t\tobject = node;\n\t\t\t\tembed = node.getAll('embed')[0];\n\t\t\t}\n\n\t\t\t// Embed element\n\t\t\tif (node.name === 'embed')\n\t\t\t\tembed = node;\n\n\t\t\t// Iframe element\n\t\t\tif (node.name === 'iframe') {\n\t\t\t\tiframe = node;\n\t\t\t\ttype = 'Iframe';\n\t\t\t}\n\n\t\t\tif (object) {\n\t\t\t\t// Get width/height\n\t\t\t\twidth = width || object.attr('width');\n\t\t\t\theight = height || object.attr('height');\n\t\t\t\tstyle = style || object.attr('style');\n\t\t\t\tid = id || object.attr('id');\n\t\t\t\thspace = hspace || object.attr('hspace');\n\t\t\t\tvspace = vspace || object.attr('vspace');\n\t\t\t\talign = align || object.attr('align');\n\t\t\t\tbgcolor = bgcolor || object.attr('bgcolor');\n\t\t\t\tdata.name = object.attr('name');\n\n\t\t\t\t// Get all object params\n\t\t\t\tparams = object.getAll(\"param\");\n\t\t\t\tfor (i = 0; i < params.length; i++) {\n\t\t\t\t\tparam = params[i];\n\t\t\t\t\tname = param.remove().attr('name');\n\n\t\t\t\t\tif (!excludedAttrs[name])\n\t\t\t\t\t\tdata.params[name] = param.attr('value');\n\t\t\t\t}\n\n\t\t\t\tdata.params.src = data.params.src || object.attr('data');\n\t\t\t}\n\n\t\t\tif (embed) {\n\t\t\t\t// Get width/height\n\t\t\t\twidth = width || embed.attr('width');\n\t\t\t\theight = height || embed.attr('height');\n\t\t\t\tstyle = style || embed.attr('style');\n\t\t\t\tid = id || embed.attr('id');\n\t\t\t\thspace = hspace || embed.attr('hspace');\n\t\t\t\tvspace = vspace || embed.attr('vspace');\n\t\t\t\talign = align || embed.attr('align');\n\t\t\t\tbgcolor = bgcolor || embed.attr('bgcolor');\n\n\t\t\t\t// Get all embed attributes\n\t\t\t\tfor (name in embed.attributes.map) {\n\t\t\t\t\tif (!excludedAttrs[name] && !data.params[name])\n\t\t\t\t\t\tdata.params[name] = embed.attributes.map[name];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (iframe) {\n\t\t\t\t// Get width/height\n\t\t\t\twidth = iframe.attr('width');\n\t\t\t\theight = iframe.attr('height');\n\t\t\t\tstyle = style || iframe.attr('style');\n\t\t\t\tid = iframe.attr('id');\n\t\t\t\thspace = iframe.attr('hspace');\n\t\t\t\tvspace = iframe.attr('vspace');\n\t\t\t\talign = iframe.attr('align');\n\t\t\t\tbgcolor = iframe.attr('bgcolor');\n\n\t\t\t\ttinymce.each(rootAttributes, function(name) {\n\t\t\t\t\timg.attr(name, iframe.attr(name));\n\t\t\t\t});\n\n\t\t\t\t// Get all iframe attributes\n\t\t\t\tfor (name in iframe.attributes.map) {\n\t\t\t\t\tif (!excludedAttrs[name] && !data.params[name])\n\t\t\t\t\t\tdata.params[name] = iframe.attributes.map[name];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Use src not movie\n\t\t\tif (data.params.movie) {\n\t\t\t\tdata.params.src = data.params.src || data.params.movie;\n\t\t\t\tdelete data.params.movie;\n\t\t\t}\n\n\t\t\t// Convert the URL to relative/absolute depending on configuration\n\t\t\tif (data.params.src)\n\t\t\t\tdata.params.src = urlConverter.call(urlConverterScope, data.params.src, 'src', 'object');\n\n\t\t\tif (video) {\n\t\t\t\tif (node.name === 'video')\n\t\t\t\t\ttype = lookup.video.name;\n\t\t\t\telse if (node.name === 'audio')\n\t\t\t\t\ttype = lookup.audio.name;\n\t\t\t}\n\n\t\t\tif (object && !type)\n\t\t\t\ttype = (lookupAttribute(object, 'clsid') || lookupAttribute(object, 'classid') || lookupAttribute(object, 'type') || {}).name;\n\n\t\t\tif (embed && !type)\n\t\t\t\ttype = (lookupAttribute(embed, 'type') || lookupExtension(data.params.src) || {}).name;\n\n\t\t\t// for embedded audio we preserve the original specified type\n\t\t\tif (embed && type == 'EmbeddedAudio') {\n\t\t\t\tdata.params.type = embed.attr('type');\n\t\t\t}\n\n\t\t\t// Replace the video/object/embed element with a placeholder image containing the data\n\t\t\tnode.replace(img);\n\n\t\t\t// Remove embed\n\t\t\tif (embed)\n\t\t\t\tembed.remove();\n\n\t\t\t// Serialize the inner HTML of the object element\n\t\t\tif (object) {\n\t\t\t\thtml = getInnerHTML(object.remove());\n\n\t\t\t\tif (html)\n\t\t\t\t\tdata.object_html = html;\n\t\t\t}\n\n\t\t\t// Serialize the inner HTML of the video element\n\t\t\tif (video) {\n\t\t\t\thtml = getInnerHTML(video.remove());\n\n\t\t\t\tif (html)\n\t\t\t\t\tdata.video_html = html;\n\t\t\t}\n\n\t\t\tdata.hspace = hspace;\n\t\t\tdata.vspace = vspace;\n\t\t\tdata.align = align;\n\t\t\tdata.bgcolor = bgcolor;\n\n\t\t\t// Set width/height of placeholder\n\t\t\timg.attr({\n\t\t\t\tid : id,\n\t\t\t\t'class' : 'mceItemMedia mceItem' + (type || 'Flash'),\n\t\t\t\tstyle : style,\n\t\t\t\twidth : width || (node.name == 'audio' ? \"300\" : \"320\"),\n\t\t\t\theight : height || (node.name == 'audio' ? \"32\" : \"240\"),\n\t\t\t\thspace : hspace,\n\t\t\t\tvspace : vspace,\n\t\t\t\talign : align,\n\t\t\t\tbgcolor : bgcolor,\n\t\t\t\t\"data-mce-json\" : JSON.serialize(data, \"'\")\n\t\t\t});\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('media', tinymce.plugins.MediaPlugin);\n})();\n","Magento_Tinymce3/tiny_mce/plugins/media/js/media.js":"(function() {\n\tvar url;\n\n\tif (url = tinyMCEPopup.getParam(\"media_external_list_url\"))\n\t\tdocument.write('<script language=\"javascript\" type=\"text/javascript\" src=\"' + tinyMCEPopup.editor.documentBaseURI.toAbsolute(url) + '\"></script>');\n\n\tfunction get(id) {\n\t\treturn document.getElementById(id);\n\t}\n\n\tfunction clone(obj) {\n\t\tvar i, len, copy, attr;\n\n\t\tif (null == obj || \"object\" != typeof obj)\n\t\t\treturn obj;\n\n\t\t// Handle Array\n\t\tif ('length' in obj) {\n\t\t\tcopy = [];\n\n\t\t\tfor (i = 0, len = obj.length; i < len; ++i) {\n\t\t\t\tcopy[i] = clone(obj[i]);\n\t\t\t}\n\n\t\t\treturn copy;\n\t\t}\n\n\t\t// Handle Object\n\t\tcopy = {};\n\t\tfor (attr in obj) {\n\t\t\tif (obj.hasOwnProperty(attr))\n\t\t\t\tcopy[attr] = clone(obj[attr]);\n\t\t}\n\n\t\treturn copy;\n\t}\n\n\tfunction getVal(id) {\n\t\tvar elm = get(id);\n\n\t\tif (elm.nodeName == \"SELECT\")\n\t\t\treturn elm.options[elm.selectedIndex].value;\n\n\t\tif (elm.type == \"checkbox\")\n\t\t\treturn elm.checked;\n\n\t\treturn elm.value;\n\t}\n\n\tfunction setVal(id, value, name) {\n\t\tif (typeof(value) != 'undefined') {\n\t\t\tvar elm = get(id);\n\n\t\t\tif (elm.nodeName == \"SELECT\")\n\t\t\t\tselectByValue(document.forms[0], id, value);\n\t\t\telse if (elm.type == \"checkbox\") {\n\t\t\t\tif (typeof(value) == 'string') {\n\t\t\t\t\tvalue = value.toLowerCase();\n\t\t\t\t\tvalue = (!name && value === 'true') || (name && value === name.toLowerCase());\n\t\t\t\t}\n\t\t\t\telm.checked = !!value;\n\t\t\t} else\n\t\t\t\telm.value = value;\n\t\t}\n\t}\n\n\twindow.Media = {\n\t\tinit : function() {\n\t\t\tvar html, editor, self = this;\n\n\t\t\tself.editor = editor = tinyMCEPopup.editor;\n\n\t\t\t// Setup file browsers and color pickers\n\t\t\tget('filebrowsercontainer').innerHTML = getBrowserHTML('filebrowser','src','media','media');\n\t\t\tget('qtsrcfilebrowsercontainer').innerHTML = getBrowserHTML('qtsrcfilebrowser','quicktime_qtsrc','media','media');\n\t\t\tget('bgcolor_pickcontainer').innerHTML = getColorPickerHTML('bgcolor_pick','bgcolor');\n\t\t\tget('video_altsource1_filebrowser').innerHTML = getBrowserHTML('video_filebrowser_altsource1','video_altsource1','media','media');\n\t\t\tget('video_altsource2_filebrowser').innerHTML = getBrowserHTML('video_filebrowser_altsource2','video_altsource2','media','media');\n\t\t\tget('audio_altsource1_filebrowser').innerHTML = getBrowserHTML('audio_filebrowser_altsource1','audio_altsource1','media','media');\n\t\t\tget('audio_altsource2_filebrowser').innerHTML = getBrowserHTML('audio_filebrowser_altsource2','audio_altsource2','media','media');\n\t\t\tget('video_poster_filebrowser').innerHTML = getBrowserHTML('filebrowser_poster','video_poster','media','image');\n\n\t\t\thtml = self.getMediaListHTML('medialist', 'src', 'media', 'media');\n\t\t\tif (html == \"\")\n\t\t\t\tget(\"linklistrow\").style.display = 'none';\n\t\t\telse\n\t\t\t\tget(\"linklistcontainer\").innerHTML = html;\n\n\t\t\tif (isVisible('filebrowser'))\n\t\t\t\tget('src').style.width = '230px';\n\n\t\t\tif (isVisible('video_filebrowser_altsource1'))\n\t\t\t\tget('video_altsource1').style.width = '220px';\n\n\t\t\tif (isVisible('video_filebrowser_altsource2'))\n\t\t\t\tget('video_altsource2').style.width = '220px';\n\n\t\t\tif (isVisible('audio_filebrowser_altsource1'))\n\t\t\t\tget('audio_altsource1').style.width = '220px';\n\n\t\t\tif (isVisible('audio_filebrowser_altsource2'))\n\t\t\t\tget('audio_altsource2').style.width = '220px';\n\n\t\t\tif (isVisible('filebrowser_poster'))\n\t\t\t\tget('video_poster').style.width = '220px';\n\n\t\t\teditor.dom.setOuterHTML(get('media_type'), self.getMediaTypeHTML(editor));\n\n\t\t\tself.setDefaultDialogSettings(editor);\n\t\t\tself.data = clone(tinyMCEPopup.getWindowArg('data'));\n\t\t\tself.dataToForm();\n\t\t\tself.preview();\n\n\t\t\tupdateColor('bgcolor_pick', 'bgcolor');\n\t\t},\n\n\t\tinsert : function() {\n\t\t\tvar editor = tinyMCEPopup.editor;\n\n\t\t\tthis.formToData();\n\t\t\teditor.execCommand('mceRepaint');\n\t\t\ttinyMCEPopup.restoreSelection();\n\t\t\teditor.selection.setNode(editor.plugins.media.dataToImg(this.data));\n\t\t\ttinyMCEPopup.close();\n\t\t},\n\n\t\tpreview : function() {\n\t\t\tget('prev').innerHTML = this.editor.plugins.media.dataToHtml(this.data, true);\n\t\t},\n\n\t\tmoveStates : function(to_form, field) {\n\t\t\tvar data = this.data, editor = this.editor,\n\t\t\t\tmediaPlugin = editor.plugins.media, ext, src, typeInfo, defaultStates, src;\n\n\t\t\tdefaultStates = {\n\t\t\t\t// QuickTime\n\t\t\t\tquicktime_autoplay : true,\n\t\t\t\tquicktime_controller : true,\n\n\t\t\t\t// Flash\n\t\t\t\tflash_play : true,\n\t\t\t\tflash_loop : true,\n\t\t\t\tflash_menu : true,\n\n\t\t\t\t// WindowsMedia\n\t\t\t\twindowsmedia_autostart : true,\n\t\t\t\twindowsmedia_enablecontextmenu : true,\n\t\t\t\twindowsmedia_invokeurls : true,\n\n\t\t\t\t// RealMedia\n\t\t\t\trealmedia_autogotourl : true,\n\t\t\t\trealmedia_imagestatus : true\n\t\t\t};\n\n\t\t\tfunction parseQueryParams(str) {\n\t\t\t\tvar out = {};\n\n\t\t\t\tif (str) {\n\t\t\t\t\ttinymce.each(str.split('&'), function(item) {\n\t\t\t\t\t\tvar parts = item.split('=');\n\n\t\t\t\t\t\tout[unescape(parts[0])] = unescape(parts[1]);\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\treturn out;\n\t\t\t};\n\n\t\t\tfunction setOptions(type, names) {\n\t\t\t\tvar i, name, formItemName, value, list;\n\n\t\t\t\tif (type == data.type || type == 'global') {\n\t\t\t\t\tnames = tinymce.explode(names);\n\t\t\t\t\tfor (i = 0; i < names.length; i++) {\n\t\t\t\t\t\tname = names[i];\n\t\t\t\t\t\tformItemName = type == 'global' ? name : type + '_' + name;\n\n\t\t\t\t\t\tif (type == 'global')\n\t\t\t\t\t\t\tlist = data;\n\t\t\t\t\t\telse if (type == 'video' || type == 'audio') {\n\t\t\t\t\t\t\tlist = data.video.attrs;\n\n\t\t\t\t\t\t\tif (!list && !to_form)\n\t\t\t\t\t\t\t\tdata.video.attrs = list = {};\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\tlist = data.params;\n\n\t\t\t\t\t\tif (list) {\n\t\t\t\t\t\t\tif (to_form) {\n\t\t\t\t\t\t\t\tsetVal(formItemName, list[name], type == 'video' || type == 'audio' ? name : '');\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tdelete list[name];\n\n\t\t\t\t\t\t\t\tvalue = getVal(formItemName);\n\t\t\t\t\t\t\t\tif ((type == 'video' || type == 'audio') && value === true)\n\t\t\t\t\t\t\t\t\tvalue = name;\n\n\t\t\t\t\t\t\t\tif (defaultStates[formItemName]) {\n\t\t\t\t\t\t\t\t\tif (value !== defaultStates[formItemName]) {\n\t\t\t\t\t\t\t\t\t\tvalue = \"\" + value;\n\t\t\t\t\t\t\t\t\t\tlist[name] = value;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t} else if (value) {\n\t\t\t\t\t\t\t\t\tvalue = \"\" + value;\n\t\t\t\t\t\t\t\t\tlist[name] = value;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (!to_form) {\n\t\t\t\tdata.type = get('media_type').options[get('media_type').selectedIndex].value;\n\t\t\t\tdata.width = getVal('width');\n\t\t\t\tdata.height = getVal('height');\n\n\t\t\t\t// Switch type based on extension\n\t\t\t\tsrc = getVal('src');\n\t\t\t\tif (field == 'src') {\n\t\t\t\t\text = src.replace(/^.*\\.([^.]+)$/, '$1');\n\t\t\t\t\tif (typeInfo = mediaPlugin.getType(ext))\n\t\t\t\t\t\tdata.type = typeInfo.name.toLowerCase();\n\n\t\t\t\t\tsetVal('media_type', data.type);\n\t\t\t\t}\n\n\t\t\t\tif (data.type == \"video\" || data.type == \"audio\") {\n\t\t\t\t\tif (!data.video.sources)\n\t\t\t\t\t\tdata.video.sources = [];\n\n\t\t\t\t\tdata.video.sources[0] = {src: getVal('src')};\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Hide all fieldsets and show the one active\n\t\t\tget('video_options').style.display = 'none';\n\t\t\tget('audio_options').style.display = 'none';\n\t\t\tget('flash_options').style.display = 'none';\n\t\t\tget('quicktime_options').style.display = 'none';\n\t\t\tget('shockwave_options').style.display = 'none';\n\t\t\tget('windowsmedia_options').style.display = 'none';\n\t\t\tget('realmedia_options').style.display = 'none';\n\t\t\tget('embeddedaudio_options').style.display = 'none';\n\n\t\t\tif (get(data.type + '_options'))\n\t\t\t\tget(data.type + '_options').style.display = 'block';\n\n\t\t\tsetVal('media_type', data.type);\n\n\t\t\tsetOptions('flash', 'play,loop,menu,swliveconnect,quality,scale,salign,wmode,base,flashvars');\n\t\t\tsetOptions('quicktime', 'loop,autoplay,cache,controller,correction,enablejavascript,kioskmode,autohref,playeveryframe,targetcache,scale,starttime,endtime,target,qtsrcchokespeed,volume,qtsrc');\n\t\t\tsetOptions('shockwave', 'sound,progress,autostart,swliveconnect,swvolume,swstretchstyle,swstretchhalign,swstretchvalign');\n\t\t\tsetOptions('windowsmedia', 'autostart,enabled,enablecontextmenu,fullscreen,invokeurls,mute,stretchtofit,windowlessvideo,balance,baseurl,captioningid,currentmarker,currentposition,defaultframe,playcount,rate,uimode,volume');\n\t\t\tsetOptions('realmedia', 'autostart,loop,autogotourl,center,imagestatus,maintainaspect,nojava,prefetch,shuffle,console,controls,numloop,scriptcallbacks');\n\t\t\tsetOptions('video', 'poster,autoplay,loop,muted,preload,controls');\n\t\t\tsetOptions('audio', 'autoplay,loop,preload,controls');\n\t\t\tsetOptions('embeddedaudio', 'autoplay,loop,controls');\n\t\t\tsetOptions('global', 'id,name,vspace,hspace,bgcolor,align,width,height');\n\n\t\t\tif (to_form) {\n\t\t\t\tif (data.type == 'video') {\n\t\t\t\t\tif (data.video.sources[0])\n\t\t\t\t\t\tsetVal('src', data.video.sources[0].src);\n\n\t\t\t\t\tsrc = data.video.sources[1];\n\t\t\t\t\tif (src)\n\t\t\t\t\t\tsetVal('video_altsource1', src.src);\n\n\t\t\t\t\tsrc = data.video.sources[2];\n\t\t\t\t\tif (src)\n\t\t\t\t\t\tsetVal('video_altsource2', src.src);\n                } else if (data.type == 'audio') {\n                    if (data.video.sources[0])\n                        setVal('src', data.video.sources[0].src);\n                    \n                    src = data.video.sources[1];\n                    if (src)\n                        setVal('audio_altsource1', src.src);\n                    \n                    src = data.video.sources[2];\n                    if (src)\n                        setVal('audio_altsource2', src.src);\n\t\t\t\t} else {\n\t\t\t\t\t// Check flash vars\n\t\t\t\t\tif (data.type == 'flash') {\n\t\t\t\t\t\ttinymce.each(editor.getParam('flash_video_player_flashvars', {url : '$url', poster : '$poster'}), function(value, name) {\n\t\t\t\t\t\t\tif (value == '$url')\n\t\t\t\t\t\t\t\tdata.params.src = parseQueryParams(data.params.flashvars)[name] || data.params.src || '';\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\n\t\t\t\t\tsetVal('src', data.params.src);\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tsrc = getVal(\"src\");\n\n\t\t\t\t// YouTube *NEW*\n\t\t\t\tif (src.match(/youtu.be\\/[a-z1-9.-_]+/)) {\n\t\t\t\t\tdata.width = 425;\n\t\t\t\t\tdata.height = 350;\n\t\t\t\t\tdata.params.frameborder = '0';\n\t\t\t\t\tdata.type = 'iframe';\n\t\t\t\t\tsrc = 'http://www.youtube.com/embed/' + src.match(/youtu.be\\/([a-z1-9.-_]+)/)[1];\n\t\t\t\t\tsetVal('src', src);\n\t\t\t\t\tsetVal('media_type', data.type);\n\t\t\t\t}\n\n\t\t\t\t// YouTube\n\t\t\t\tif (src.match(/youtube.com(.+)v=([^&]+)/)) {\n\t\t\t\t\tdata.width = 425;\n\t\t\t\t\tdata.height = 350;\n\t\t\t\t\tdata.params.frameborder = '0';\n\t\t\t\t\tdata.type = 'iframe';\n\t\t\t\t\tsrc = 'http://www.youtube.com/embed/' + src.match(/v=([^&]+)/)[1];\n\t\t\t\t\tsetVal('src', src);\n\t\t\t\t\tsetVal('media_type', data.type);\n\t\t\t\t}\n\n\t\t\t\t// Google video\n\t\t\t\tif (src.match(/video.google.com(.+)docid=([^&]+)/)) {\n\t\t\t\t\tdata.width = 425;\n\t\t\t\t\tdata.height = 326;\n\t\t\t\t\tdata.type = 'flash';\n\t\t\t\t\tsrc = 'http://video.google.com/googleplayer.swf?docId=' + src.match(/docid=([^&]+)/)[1] + '&hl=en';\n\t\t\t\t\tsetVal('src', src);\n\t\t\t\t\tsetVal('media_type', data.type);\n\t\t\t\t}\n\n\t\t\t\tif (data.type == 'video') {\n\t\t\t\t\tif (!data.video.sources)\n\t\t\t\t\t\tdata.video.sources = [];\n\n\t\t\t\t\tdata.video.sources[0] = {src : src};\n\n\t\t\t\t\tsrc = getVal(\"video_altsource1\");\n\t\t\t\t\tif (src)\n\t\t\t\t\t\tdata.video.sources[1] = {src : src};\n\n\t\t\t\t\tsrc = getVal(\"video_altsource2\");\n\t\t\t\t\tif (src)\n\t\t\t\t\t\tdata.video.sources[2] = {src : src};\n                } else if (data.type == 'audio') {\n                    if (!data.video.sources)\n                        data.video.sources = [];\n                    \n                    data.video.sources[0] = {src : src};\n                    \n                    src = getVal(\"audio_altsource1\");\n                    if (src)\n                        data.video.sources[1] = {src : src};\n                    \n                    src = getVal(\"audio_altsource2\");\n                    if (src)\n                        data.video.sources[2] = {src : src};\n\t\t\t\t} else\n\t\t\t\t\tdata.params.src = src;\n\n\t\t\t\t// Set default size\n                setVal('width', data.width || (data.type == 'audio' ? 300 : 320));\n                setVal('height', data.height || (data.type == 'audio' ? 32 : 240));\n\t\t\t}\n\t\t},\n\n\t\tdataToForm : function() {\n\t\t\tthis.moveStates(true);\n\t\t},\n\n\t\tformToData : function(field) {\n\t\t\tif (field == \"width\" || field == \"height\")\n\t\t\t\tthis.changeSize(field);\n\n\t\t\tif (field == 'source') {\n\t\t\t\tthis.moveStates(false, field);\n\t\t\t\tsetVal('source', this.editor.plugins.media.dataToHtml(this.data));\n\t\t\t\tthis.panel = 'source';\n\t\t\t} else {\n\t\t\t\tif (this.panel == 'source') {\n\t\t\t\t\tthis.data = clone(this.editor.plugins.media.htmlToData(getVal('source')));\n\t\t\t\t\tthis.dataToForm();\n\t\t\t\t\tthis.panel = '';\n\t\t\t\t}\n\n\t\t\t\tthis.moveStates(false, field);\n\t\t\t\tthis.preview();\n\t\t\t}\n\t\t},\n\n\t\tbeforeResize : function() {\n            this.width = parseInt(getVal('width') || (this.data.type == 'audio' ? \"300\" : \"320\"), 10);\n            this.height = parseInt(getVal('height') || (this.data.type == 'audio' ? \"32\" : \"240\"), 10);\n\t\t},\n\n\t\tchangeSize : function(type) {\n\t\t\tvar width, height, scale, size;\n\n\t\t\tif (get('constrain').checked) {\n                width = parseInt(getVal('width') || (this.data.type == 'audio' ? \"300\" : \"320\"), 10);\n                height = parseInt(getVal('height') || (this.data.type == 'audio' ? \"32\" : \"240\"), 10);\n\n\t\t\t\tif (type == 'width') {\n\t\t\t\t\tthis.height = Math.round((width / this.width) * height);\n\t\t\t\t\tsetVal('height', this.height);\n\t\t\t\t} else {\n\t\t\t\t\tthis.width = Math.round((height / this.height) * width);\n\t\t\t\t\tsetVal('width', this.width);\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tgetMediaListHTML : function() {\n\t\t\tif (typeof(tinyMCEMediaList) != \"undefined\" && tinyMCEMediaList.length > 0) {\n\t\t\t\tvar html = \"\";\n\n\t\t\t\thtml += '<select id=\"linklist\" name=\"linklist\" style=\"width: 250px\" onchange=\"this.form.src.value=this.options[this.selectedIndex].value;Media.formToData(\\'src\\');\">';\n\t\t\t\thtml += '<option value=\"\">---</option>';\n\n\t\t\t\tfor (var i=0; i<tinyMCEMediaList.length; i++)\n\t\t\t\t\thtml += '<option value=\"' + tinyMCEMediaList[i][1] + '\">' + tinyMCEMediaList[i][0] + '</option>';\n\n\t\t\t\thtml += '</select>';\n\n\t\t\t\treturn html;\n\t\t\t}\n\n\t\t\treturn \"\";\n\t\t},\n\n\t\tgetMediaTypeHTML : function(editor) {\n\t\t\tfunction option(media_type){\n\t\t\t\treturn '<option value=\"'+media_type+'\">'+tinyMCEPopup.editor.translate(\"media_dlg.\"+media_type)+'</option>'\n\t\t\t}\n\t\t\tvar html = \"\";\n\t\t\thtml += '<select id=\"media_type\" name=\"media_type\" onchange=\"Media.formToData(\\'type\\');\">';\n\t\t\thtml += option(\"video\");\n\t\t\thtml += option(\"audio\");\n\t\t\thtml += option(\"flash\");\n\t\t\thtml += option(\"quicktime\");\n\t\t\thtml += option(\"shockwave\");\n\t\t\thtml += option(\"windowsmedia\");\n\t\t\thtml += option(\"realmedia\");\n\t\t\thtml += option(\"iframe\");\n\n\t\t\tif (editor.getParam('media_embedded_audio', false)) {\n\t\t\t\thtml += option('embeddedaudio');\n\t\t\t}\n\t\t\t\n\t\t\thtml += '</select>';\n\t\t\treturn html;\n\t\t},\n\n\t\tsetDefaultDialogSettings : function(editor) {\n\t\t\tvar defaultDialogSettings = editor.getParam(\"media_dialog_defaults\", {});\n\t\t\ttinymce.each(defaultDialogSettings, function(v, k) {\n\t\t\t\tsetVal(k, v);\n\t\t\t});\n\t\t}\n\t};\n\n\ttinyMCEPopup.requireLangPack();\n\ttinyMCEPopup.onInit.add(function() {\n\t\tMedia.init();\n\t});\n})();\n","Magento_Tinymce3/tiny_mce/plugins/media/js/embed.js":"/**\n * This script contains embed functions for common plugins. This scripts are complety free to use for any purpose.\n */\n\nfunction writeFlash(p) {\n\twriteEmbed(\n\t\t'D27CDB6E-AE6D-11cf-96B8-444553540000',\n\t\t'http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0',\n\t\t'application/x-shockwave-flash',\n\t\tp\n\t);\n}\n\nfunction writeShockWave(p) {\n\twriteEmbed(\n\t'166B1BCA-3F9C-11CF-8075-444553540000',\n\t'http://download.macromedia.com/pub/shockwave/cabs/director/sw.cab#version=8,5,1,0',\n\t'application/x-director',\n\t\tp\n\t);\n}\n\nfunction writeQuickTime(p) {\n\twriteEmbed(\n\t\t'02BF25D5-8C17-4B23-BC80-D3488ABDDC6B',\n\t\t'http://www.apple.com/qtactivex/qtplugin.cab#version=6,0,2,0',\n\t\t'video/quicktime',\n\t\tp\n\t);\n}\n\nfunction writeRealMedia(p) {\n\twriteEmbed(\n\t\t'CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA',\n\t\t'http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0',\n\t\t'audio/x-pn-realaudio-plugin',\n\t\tp\n\t);\n}\n\nfunction writeWindowsMedia(p) {\n\tp.url = p.src;\n\twriteEmbed(\n\t\t'6BF52A52-394A-11D3-B153-00C04F79FAA6',\n\t\t'http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=5,1,52,701',\n\t\t'application/x-mplayer2',\n\t\tp\n\t);\n}\n\nfunction writeEmbed(cls, cb, mt, p) {\n\tvar h = '', n;\n\n\th += '<object classid=\"clsid:' + cls + '\" codebase=\"' + cb + '\"';\n\th += typeof(p.id) != \"undefined\" ? 'id=\"' + p.id + '\"' : '';\n\th += typeof(p.name) != \"undefined\" ? 'name=\"' + p.name + '\"' : '';\n\th += typeof(p.width) != \"undefined\" ? 'width=\"' + p.width + '\"' : '';\n\th += typeof(p.height) != \"undefined\" ? 'height=\"' + p.height + '\"' : '';\n\th += typeof(p.align) != \"undefined\" ? 'align=\"' + p.align + '\"' : '';\n\th += '>';\n\n\tfor (n in p)\n\t\th += '<param name=\"' + n + '\" value=\"' + p[n] + '\">';\n\n\th += '<embed type=\"' + mt + '\"';\n\n\tfor (n in p)\n\t\th += n + '=\"' + p[n] + '\" ';\n\n\th += '></embed></object>';\n\n\tdocument.write(h);\n}\n","Magento_Tinymce3/tiny_mce/plugins/media/langs/en_dlg.js":"tinyMCE.addI18n('en.media_dlg',{list:\"List\",file:\"File/URL\",advanced:\"Advanced\",general:\"General\",title:\"Insert/Edit Embedded Media\",\"align_top_left\":\"Top Left\",\"align_center\":\"Center\",\"align_left\":\"Left\",\"align_bottom\":\"Bottom\",\"align_right\":\"Right\",\"align_top\":\"Top\",\"qt_stream_warn\":\"Streamed RTSP resources should be added to the QT Source field under the Advanced tab.\\nYou should also add a non-streamed version to the Source field.\",qtsrc:\"QT Source\",progress:\"Progress\",sound:\"Sound\",swstretchvalign:\"Stretch V-Align\",swstretchhalign:\"Stretch H-Align\",swstretchstyle:\"Stretch Style\",scriptcallbacks:\"Script Callbacks\",\"align_top_right\":\"Top Right\",uimode:\"UI Mode\",rate:\"Rate\",playcount:\"Play Count\",defaultframe:\"Default Frame\",currentposition:\"Current Position\",currentmarker:\"Current Marker\",captioningid:\"Captioning ID\",baseurl:\"Base URL\",balance:\"Balance\",windowlessvideo:\"Windowless Video\",stretchtofit:\"Stretch to Fit\",mute:\"Mute\",invokeurls:\"Invoke URLs\",fullscreen:\"Full Screen\",enabled:\"Enabled\",autostart:\"Auto Start\",volume:\"Volume\",target:\"Target\",qtsrcchokespeed:\"Choke Speed\",href:\"HREF\",endtime:\"End Time\",starttime:\"Start Time\",enablejavascript:\"Enable JavaScript\",correction:\"No Correction\",targetcache:\"Target Cache\",playeveryframe:\"Play Every Frame\",kioskmode:\"Kiosk Mode\",controller:\"Controller\",menu:\"Show Menu\",loop:\"Loop\",play:\"Auto Play\",hspace:\"H-Space\",vspace:\"V-Space\",\"class_name\":\"Class\",name:\"Name\",id:\"ID\",type:\"Type\",size:\"Dimensions\",preview:\"Preview\",\"constrain_proportions\":\"Constrain Proportions\",controls:\"Controls\",numloop:\"Num Loops\",console:\"Console\",cache:\"Cache\",autohref:\"Auto HREF\",liveconnect:\"SWLiveConnect\",flashvars:\"Flash Vars\",base:\"Base\",bgcolor:\"Background\",wmode:\"WMode\",salign:\"SAlign\",align:\"Align\",scale:\"Scale\",quality:\"Quality\",shuffle:\"Shuffle\",prefetch:\"Prefetch\",nojava:\"No Java\",maintainaspect:\"Maintain Aspect\",imagestatus:\"Image Status\",center:\"Center\",autogotourl:\"Auto Goto URL\",\"shockwave_options\":\"Shockwave Options\",\"rmp_options\":\"Real Media Player Options\",\"wmp_options\":\"Windows Media Player Options\",\"qt_options\":\"QuickTime Options\",\"flash_options\":\"Flash Options\",hidden:\"Hidden\",\"align_bottom_left\":\"Bottom Left\",\"align_bottom_right\":\"Bottom Right\",\"html5_video_options\":\"HTML5 Video Options\",altsource1:\"Alternative source 1\",altsource2:\"Alternative source 2\",preload:\"Preload\",poster:\"Poster\",source:\"Source\",\"html5_audio_options\":\"Audio Options\",\"preload_none\":\"Don\\'t Preload\",\"preload_metadata\":\"Preload video metadata\",\"preload_auto\":\"Let user\\'s browser decide\", \"embedded_audio_options\":\"Embedded Audio Options\", video:\"HTML5 Video\", audio:\"HTML5 Audio\", flash:\"Flash\", quicktime:\"QuickTime\", shockwave:\"Shockwave\", windowsmedia:\"Windows Media\", realmedia:\"Real Media\", iframe:\"Iframe\", embeddedaudio:\"Embedded Audio\" }); \n","Magento_Tinymce3/tiny_mce/plugins/advlink/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.AdvancedLinkPlugin\",{init:function(a,b){this.editor=a;a.addCommand(\"mceAdvLink\",function(){var c=a.selection;if(c.isCollapsed()&&!a.dom.getParent(c.getNode(),\"A\")){return}a.windowManager.open({file:b+\"/link.htm\",width:480+parseInt(a.getLang(\"advlink.delta_width\",0)),height:400+parseInt(a.getLang(\"advlink.delta_height\",0)),inline:1},{plugin_url:b})});a.addButton(\"link\",{title:\"advlink.link_desc\",cmd:\"mceAdvLink\"});a.addShortcut(\"ctrl+k\",\"advlink.advlink_desc\",\"mceAdvLink\");a.onNodeChange.add(function(d,c,f,e){c.setDisabled(\"link\",e&&f.nodeName!=\"A\");c.setActive(\"link\",f.nodeName==\"A\"&&!f.name)})},getInfo:function(){return{longname:\"Advanced link\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/advlink\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"advlink\",tinymce.plugins.AdvancedLinkPlugin)})();","Magento_Tinymce3/tiny_mce/plugins/advlink/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.AdvancedLinkPlugin', {\n\t\tinit : function(ed, url) {\n\t\t\tthis.editor = ed;\n\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceAdvLink', function() {\n\t\t\t\tvar se = ed.selection;\n\n\t\t\t\t// No selection and not in link\n\t\t\t\tif (se.isCollapsed() && !ed.dom.getParent(se.getNode(), 'A'))\n\t\t\t\t\treturn;\n\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/link.htm',\n\t\t\t\t\twidth : 480 + parseInt(ed.getLang('advlink.delta_width', 0)),\n\t\t\t\t\theight : 400 + parseInt(ed.getLang('advlink.delta_height', 0)),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('link', {\n\t\t\t\ttitle : 'advlink.link_desc',\n\t\t\t\tcmd : 'mceAdvLink'\n\t\t\t});\n\n\t\t\ted.addShortcut('ctrl+k', 'advlink.advlink_desc', 'mceAdvLink');\n\n\t\t\ted.onNodeChange.add(function(ed, cm, n, co) {\n\t\t\t\tcm.setDisabled('link', co && n.nodeName != 'A');\n\t\t\t\tcm.setActive('link', n.nodeName == 'A' && !n.name);\n\t\t\t});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Advanced link',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/advlink',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('advlink', tinymce.plugins.AdvancedLinkPlugin);\n})();","Magento_Tinymce3/tiny_mce/plugins/advlink/js/advlink.js":"/* Functions for the advlink plugin popup */\n\ntinyMCEPopup.requireLangPack();\n\nvar templates = {\n\t\"window.open\" : \"window.open('${url}','${target}','${options}')\"\n};\n\nfunction preinit() {\n\tvar url;\n\n\tif (url = tinyMCEPopup.getParam(\"external_link_list_url\"))\n\t\tdocument.write('<script language=\"javascript\" type=\"text/javascript\" src=\"' + tinyMCEPopup.editor.documentBaseURI.toAbsolute(url) + '\"></script>');\n}\n\nfunction changeClass() {\n\tvar f = document.forms[0];\n\n\tf.classes.value = getSelectValue(f, 'classlist');\n}\n\nfunction init() {\n\ttinyMCEPopup.resizeToInnerSize();\n\n\tvar formObj = document.forms[0];\n\tvar inst = tinyMCEPopup.editor;\n\tvar elm = inst.selection.getNode();\n\tvar action = \"insert\";\n\tvar html;\n\n\tdocument.getElementById('hrefbrowsercontainer').innerHTML = getBrowserHTML('hrefbrowser','href','file','advlink');\n\tdocument.getElementById('popupurlbrowsercontainer').innerHTML = getBrowserHTML('popupurlbrowser','popupurl','file','advlink');\n\tdocument.getElementById('targetlistcontainer').innerHTML = getTargetListHTML('targetlist','target');\n\n\t// Link list\n\thtml = getLinkListHTML('linklisthref','href');\n\tif (html == \"\")\n\t\tdocument.getElementById(\"linklisthrefrow\").style.display = 'none';\n\telse\n\t\tdocument.getElementById(\"linklisthrefcontainer\").innerHTML = html;\n\n\t// Anchor list\n\thtml = getAnchorListHTML('anchorlist','href');\n\tif (html == \"\")\n\t\tdocument.getElementById(\"anchorlistrow\").style.display = 'none';\n\telse\n\t\tdocument.getElementById(\"anchorlistcontainer\").innerHTML = html;\n\n\t// Resize some elements\n\tif (isVisible('hrefbrowser'))\n\t\tdocument.getElementById('href').style.width = '260px';\n\n\tif (isVisible('popupurlbrowser'))\n\t\tdocument.getElementById('popupurl').style.width = '180px';\n\n\telm = inst.dom.getParent(elm, \"A\");\n\tif (elm != null && elm.nodeName == \"A\")\n\t\taction = \"update\";\n\n\tformObj.insert.value = tinyMCEPopup.getLang(action, 'Insert', true); \n\n\tsetPopupControlsDisabled(true);\n\n\tif (action == \"update\") {\n\t\tvar href = inst.dom.getAttrib(elm, 'href');\n\t\tvar onclick = inst.dom.getAttrib(elm, 'onclick');\n\n\t\t// Setup form data\n\t\tsetFormValue('href', href);\n\t\tsetFormValue('title', inst.dom.getAttrib(elm, 'title'));\n\t\tsetFormValue('id', inst.dom.getAttrib(elm, 'id'));\n\t\tsetFormValue('style', inst.dom.getAttrib(elm, \"style\"));\n\t\tsetFormValue('rel', inst.dom.getAttrib(elm, 'rel'));\n\t\tsetFormValue('rev', inst.dom.getAttrib(elm, 'rev'));\n\t\tsetFormValue('charset', inst.dom.getAttrib(elm, 'charset'));\n\t\tsetFormValue('hreflang', inst.dom.getAttrib(elm, 'hreflang'));\n\t\tsetFormValue('dir', inst.dom.getAttrib(elm, 'dir'));\n\t\tsetFormValue('lang', inst.dom.getAttrib(elm, 'lang'));\n\t\tsetFormValue('tabindex', inst.dom.getAttrib(elm, 'tabindex', typeof(elm.tabindex) != \"undefined\" ? elm.tabindex : \"\"));\n\t\tsetFormValue('accesskey', inst.dom.getAttrib(elm, 'accesskey', typeof(elm.accesskey) != \"undefined\" ? elm.accesskey : \"\"));\n\t\tsetFormValue('type', inst.dom.getAttrib(elm, 'type'));\n\t\tsetFormValue('onfocus', inst.dom.getAttrib(elm, 'onfocus'));\n\t\tsetFormValue('onblur', inst.dom.getAttrib(elm, 'onblur'));\n\t\tsetFormValue('onclick', onclick);\n\t\tsetFormValue('ondblclick', inst.dom.getAttrib(elm, 'ondblclick'));\n\t\tsetFormValue('onmousedown', inst.dom.getAttrib(elm, 'onmousedown'));\n\t\tsetFormValue('onmouseup', inst.dom.getAttrib(elm, 'onmouseup'));\n\t\tsetFormValue('onmouseover', inst.dom.getAttrib(elm, 'onmouseover'));\n\t\tsetFormValue('onmousemove', inst.dom.getAttrib(elm, 'onmousemove'));\n\t\tsetFormValue('onmouseout', inst.dom.getAttrib(elm, 'onmouseout'));\n\t\tsetFormValue('onkeypress', inst.dom.getAttrib(elm, 'onkeypress'));\n\t\tsetFormValue('onkeydown', inst.dom.getAttrib(elm, 'onkeydown'));\n\t\tsetFormValue('onkeyup', inst.dom.getAttrib(elm, 'onkeyup'));\n\t\tsetFormValue('target', inst.dom.getAttrib(elm, 'target'));\n\t\tsetFormValue('classes', inst.dom.getAttrib(elm, 'class'));\n\n\t\t// Parse onclick data\n\t\tif (onclick != null && onclick.indexOf('window.open') != -1)\n\t\t\tparseWindowOpen(onclick);\n\t\telse\n\t\t\tparseFunction(onclick);\n\n\t\t// Select by the values\n\t\tselectByValue(formObj, 'dir', inst.dom.getAttrib(elm, 'dir'));\n\t\tselectByValue(formObj, 'rel', inst.dom.getAttrib(elm, 'rel'));\n\t\tselectByValue(formObj, 'rev', inst.dom.getAttrib(elm, 'rev'));\n\t\tselectByValue(formObj, 'linklisthref', href);\n\n\t\tif (href.charAt(0) == '#')\n\t\t\tselectByValue(formObj, 'anchorlist', href);\n\n\t\taddClassesToList('classlist', 'advlink_styles');\n\n\t\tselectByValue(formObj, 'classlist', inst.dom.getAttrib(elm, 'class'), true);\n\t\tselectByValue(formObj, 'targetlist', inst.dom.getAttrib(elm, 'target'), true);\n\t} else\n\t\taddClassesToList('classlist', 'advlink_styles');\n}\n\nfunction checkPrefix(n) {\n\tif (n.value && Validator.isEmail(n) && !/^\\s*mailto:/i.test(n.value) && confirm(tinyMCEPopup.getLang('advlink_dlg.is_email')))\n\t\tn.value = 'mailto:' + n.value;\n\n\tif (/^\\s*www\\./i.test(n.value) && confirm(tinyMCEPopup.getLang('advlink_dlg.is_external')))\n\t\tn.value = 'http://' + n.value;\n}\n\nfunction setFormValue(name, value) {\n\tdocument.forms[0].elements[name].value = value;\n}\n\nfunction parseWindowOpen(onclick) {\n\tvar formObj = document.forms[0];\n\n\t// Preprocess center code\n\tif (onclick.indexOf('return false;') != -1) {\n\t\tformObj.popupreturn.checked = true;\n\t\tonclick = onclick.replace('return false;', '');\n\t} else\n\t\tformObj.popupreturn.checked = false;\n\n\tvar onClickData = parseLink(onclick);\n\n\tif (onClickData != null) {\n\t\tformObj.ispopup.checked = true;\n\t\tsetPopupControlsDisabled(false);\n\n\t\tvar onClickWindowOptions = parseOptions(onClickData['options']);\n\t\tvar url = onClickData['url'];\n\n\t\tformObj.popupname.value = onClickData['target'];\n\t\tformObj.popupurl.value = url;\n\t\tformObj.popupwidth.value = getOption(onClickWindowOptions, 'width');\n\t\tformObj.popupheight.value = getOption(onClickWindowOptions, 'height');\n\n\t\tformObj.popupleft.value = getOption(onClickWindowOptions, 'left');\n\t\tformObj.popuptop.value = getOption(onClickWindowOptions, 'top');\n\n\t\tif (formObj.popupleft.value.indexOf('screen') != -1)\n\t\t\tformObj.popupleft.value = \"c\";\n\n\t\tif (formObj.popuptop.value.indexOf('screen') != -1)\n\t\t\tformObj.popuptop.value = \"c\";\n\n\t\tformObj.popuplocation.checked = getOption(onClickWindowOptions, 'location') == \"yes\";\n\t\tformObj.popupscrollbars.checked = getOption(onClickWindowOptions, 'scrollbars') == \"yes\";\n\t\tformObj.popupmenubar.checked = getOption(onClickWindowOptions, 'menubar') == \"yes\";\n\t\tformObj.popupresizable.checked = getOption(onClickWindowOptions, 'resizable') == \"yes\";\n\t\tformObj.popuptoolbar.checked = getOption(onClickWindowOptions, 'toolbar') == \"yes\";\n\t\tformObj.popupstatus.checked = getOption(onClickWindowOptions, 'status') == \"yes\";\n\t\tformObj.popupdependent.checked = getOption(onClickWindowOptions, 'dependent') == \"yes\";\n\n\t\tbuildOnClick();\n\t}\n}\n\nfunction parseFunction(onclick) {\n\tvar formObj = document.forms[0];\n\tvar onClickData = parseLink(onclick);\n\n\t// TODO: Add stuff here\n}\n\nfunction getOption(opts, name) {\n\treturn typeof(opts[name]) == \"undefined\" ? \"\" : opts[name];\n}\n\nfunction setPopupControlsDisabled(state) {\n\tvar formObj = document.forms[0];\n\n\tformObj.popupname.disabled = state;\n\tformObj.popupurl.disabled = state;\n\tformObj.popupwidth.disabled = state;\n\tformObj.popupheight.disabled = state;\n\tformObj.popupleft.disabled = state;\n\tformObj.popuptop.disabled = state;\n\tformObj.popuplocation.disabled = state;\n\tformObj.popupscrollbars.disabled = state;\n\tformObj.popupmenubar.disabled = state;\n\tformObj.popupresizable.disabled = state;\n\tformObj.popuptoolbar.disabled = state;\n\tformObj.popupstatus.disabled = state;\n\tformObj.popupreturn.disabled = state;\n\tformObj.popupdependent.disabled = state;\n\n\tsetBrowserDisabled('popupurlbrowser', state);\n}\n\nfunction parseLink(link) {\n\tlink = link.replace(new RegExp('&#39;', 'g'), \"'\");\n\n\tvar fnName = link.replace(new RegExp(\"\\\\s*([A-Za-z0-9\\.]*)\\\\s*\\\\(.*\", \"gi\"), \"$1\");\n\n\t// Is function name a template function\n\tvar template = templates[fnName];\n\tif (template) {\n\t\t// Build regexp\n\t\tvar variableNames = template.match(new RegExp(\"'?\\\\$\\\\{[A-Za-z0-9\\.]*\\\\}'?\", \"gi\"));\n\t\tvar regExp = \"\\\\s*[A-Za-z0-9\\.]*\\\\s*\\\\(\";\n\t\tvar replaceStr = \"\";\n\t\tfor (var i=0; i<variableNames.length; i++) {\n\t\t\t// Is string value\n\t\t\tif (variableNames[i].indexOf(\"'${\") != -1)\n\t\t\t\tregExp += \"'(.*)'\";\n\t\t\telse // Number value\n\t\t\t\tregExp += \"([0-9]*)\";\n\n\t\t\treplaceStr += \"$\" + (i+1);\n\n\t\t\t// Cleanup variable name\n\t\t\tvariableNames[i] = variableNames[i].replace(new RegExp(\"[^A-Za-z0-9]\", \"gi\"), \"\");\n\n\t\t\tif (i != variableNames.length-1) {\n\t\t\t\tregExp += \"\\\\s*,\\\\s*\";\n\t\t\t\treplaceStr += \"<delim>\";\n\t\t\t} else\n\t\t\t\tregExp += \".*\";\n\t\t}\n\n\t\tregExp += \"\\\\);?\";\n\n\t\t// Build variable array\n\t\tvar variables = [];\n\t\tvariables[\"_function\"] = fnName;\n\t\tvar variableValues = link.replace(new RegExp(regExp, \"gi\"), replaceStr).split('<delim>');\n\t\tfor (var i=0; i<variableNames.length; i++)\n\t\t\tvariables[variableNames[i]] = variableValues[i];\n\n\t\treturn variables;\n\t}\n\n\treturn null;\n}\n\nfunction parseOptions(opts) {\n\tif (opts == null || opts == \"\")\n\t\treturn [];\n\n\t// Cleanup the options\n\topts = opts.toLowerCase();\n\topts = opts.replace(/;/g, \",\");\n\topts = opts.replace(/[^0-9a-z=,]/g, \"\");\n\n\tvar optionChunks = opts.split(',');\n\tvar options = [];\n\n\tfor (var i=0; i<optionChunks.length; i++) {\n\t\tvar parts = optionChunks[i].split('=');\n\n\t\tif (parts.length == 2)\n\t\t\toptions[parts[0]] = parts[1];\n\t}\n\n\treturn options;\n}\n\nfunction buildOnClick() {\n\tvar formObj = document.forms[0];\n\n\tif (!formObj.ispopup.checked) {\n\t\tformObj.onclick.value = \"\";\n\t\treturn;\n\t}\n\n\tvar onclick = \"window.open('\";\n\tvar url = formObj.popupurl.value;\n\n\tonclick += url + \"','\";\n\tonclick += formObj.popupname.value + \"','\";\n\n\tif (formObj.popuplocation.checked)\n\t\tonclick += \"location=yes,\";\n\n\tif (formObj.popupscrollbars.checked)\n\t\tonclick += \"scrollbars=yes,\";\n\n\tif (formObj.popupmenubar.checked)\n\t\tonclick += \"menubar=yes,\";\n\n\tif (formObj.popupresizable.checked)\n\t\tonclick += \"resizable=yes,\";\n\n\tif (formObj.popuptoolbar.checked)\n\t\tonclick += \"toolbar=yes,\";\n\n\tif (formObj.popupstatus.checked)\n\t\tonclick += \"status=yes,\";\n\n\tif (formObj.popupdependent.checked)\n\t\tonclick += \"dependent=yes,\";\n\n\tif (formObj.popupwidth.value != \"\")\n\t\tonclick += \"width=\" + formObj.popupwidth.value + \",\";\n\n\tif (formObj.popupheight.value != \"\")\n\t\tonclick += \"height=\" + formObj.popupheight.value + \",\";\n\n\tif (formObj.popupleft.value != \"\") {\n\t\tif (formObj.popupleft.value != \"c\")\n\t\t\tonclick += \"left=\" + formObj.popupleft.value + \",\";\n\t\telse\n\t\t\tonclick += \"left='+(screen.availWidth/2-\" + (formObj.popupwidth.value/2) + \")+',\";\n\t}\n\n\tif (formObj.popuptop.value != \"\") {\n\t\tif (formObj.popuptop.value != \"c\")\n\t\t\tonclick += \"top=\" + formObj.popuptop.value + \",\";\n\t\telse\n\t\t\tonclick += \"top='+(screen.availHeight/2-\" + (formObj.popupheight.value/2) + \")+',\";\n\t}\n\n\tif (onclick.charAt(onclick.length-1) == ',')\n\t\tonclick = onclick.substring(0, onclick.length-1);\n\n\tonclick += \"');\";\n\n\tif (formObj.popupreturn.checked)\n\t\tonclick += \"return false;\";\n\n\t// tinyMCE.debug(onclick);\n\n\tformObj.onclick.value = onclick;\n\n\tif (formObj.href.value == \"\")\n\t\tformObj.href.value = url;\n}\n\nfunction setAttrib(elm, attrib, value) {\n\tvar formObj = document.forms[0];\n\tvar valueElm = formObj.elements[attrib.toLowerCase()];\n\tvar dom = tinyMCEPopup.editor.dom;\n\n\tif (typeof(value) == \"undefined\" || value == null) {\n\t\tvalue = \"\";\n\n\t\tif (valueElm)\n\t\t\tvalue = valueElm.value;\n\t}\n\n\t// Clean up the style\n\tif (attrib == 'style')\n\t\tvalue = dom.serializeStyle(dom.parseStyle(value), 'a');\n\n\tdom.setAttrib(elm, attrib, value);\n}\n\nfunction getAnchorListHTML(id, target) {\n\tvar ed = tinyMCEPopup.editor, nodes = ed.dom.select('a'), name, i, len, html = \"\";\n\n\tfor (i=0, len=nodes.length; i<len; i++) {\n\t\tif ((name = ed.dom.getAttrib(nodes[i], \"name\")) != \"\")\n\t\t\thtml += '<option value=\"#' + name + '\">' + name + '</option>';\n\t}\n\n\tif (html == \"\")\n\t\treturn \"\";\n\n\thtml = '<select id=\"' + id + '\" name=\"' + id + '\" class=\"mceAnchorList\"'\n\t\t+ ' onchange=\"this.form.' + target + '.value=this.options[this.selectedIndex].value\"'\n\t\t+ '>'\n\t\t+ '<option value=\"\">---</option>'\n\t\t+ html\n\t\t+ '</select>';\n\n\treturn html;\n}\n\nfunction insertAction() {\n\tvar inst = tinyMCEPopup.editor;\n\tvar elm, elementArray, i;\n\n\telm = inst.selection.getNode();\n\tcheckPrefix(document.forms[0].href);\n\n\telm = inst.dom.getParent(elm, \"A\");\n\n\t// Remove element if there is no href\n\tif (!document.forms[0].href.value) {\n\t\ti = inst.selection.getBookmark();\n\t\tinst.dom.remove(elm, 1);\n\t\tinst.selection.moveToBookmark(i);\n\t\ttinyMCEPopup.execCommand(\"mceEndUndoLevel\");\n\t\ttinyMCEPopup.close();\n\t\treturn;\n\t}\n\n\t// Create new anchor elements\n\tif (elm == null) {\n\t\tinst.getDoc().execCommand(\"unlink\", false, null);\n\t\ttinyMCEPopup.execCommand(\"mceInsertLink\", false, \"#mce_temp_url#\", {skip_undo : 1});\n\n\t\telementArray = tinymce.grep(inst.dom.select(\"a\"), function(n) {return inst.dom.getAttrib(n, 'href') == '#mce_temp_url#';});\n\t\tfor (i=0; i<elementArray.length; i++)\n\t\t\tsetAllAttribs(elm = elementArray[i]);\n\t} else\n\t\tsetAllAttribs(elm);\n\n\t// Don't move caret if selection was image\n\tif (elm.childNodes.length != 1 || elm.firstChild.nodeName != 'IMG') {\n\t\tinst.focus();\n\t\tinst.selection.select(elm);\n\t\tinst.selection.collapse(0);\n\t\ttinyMCEPopup.storeSelection();\n\t}\n\n\ttinyMCEPopup.execCommand(\"mceEndUndoLevel\");\n\ttinyMCEPopup.close();\n}\n\nfunction setAllAttribs(elm) {\n\tvar formObj = document.forms[0];\n\tvar href = formObj.href.value.replace(/ /g, '%20');\n\tvar target = getSelectValue(formObj, 'targetlist');\n\n\tsetAttrib(elm, 'href', href);\n\tsetAttrib(elm, 'title');\n\tsetAttrib(elm, 'target', target == '_self' ? '' : target);\n\tsetAttrib(elm, 'id');\n\tsetAttrib(elm, 'style');\n\tsetAttrib(elm, 'class', getSelectValue(formObj, 'classlist'));\n\tsetAttrib(elm, 'rel');\n\tsetAttrib(elm, 'rev');\n\tsetAttrib(elm, 'charset');\n\tsetAttrib(elm, 'hreflang');\n\tsetAttrib(elm, 'dir');\n\tsetAttrib(elm, 'lang');\n\tsetAttrib(elm, 'tabindex');\n\tsetAttrib(elm, 'accesskey');\n\tsetAttrib(elm, 'type');\n\tsetAttrib(elm, 'onfocus');\n\tsetAttrib(elm, 'onblur');\n\tsetAttrib(elm, 'onclick');\n\tsetAttrib(elm, 'ondblclick');\n\tsetAttrib(elm, 'onmousedown');\n\tsetAttrib(elm, 'onmouseup');\n\tsetAttrib(elm, 'onmouseover');\n\tsetAttrib(elm, 'onmousemove');\n\tsetAttrib(elm, 'onmouseout');\n\tsetAttrib(elm, 'onkeypress');\n\tsetAttrib(elm, 'onkeydown');\n\tsetAttrib(elm, 'onkeyup');\n\n\t// Refresh in old MSIE\n\tif (tinyMCE.isMSIE5)\n\t\telm.outerHTML = elm.outerHTML;\n}\n\nfunction getSelectValue(form_obj, field_name) {\n\tvar elm = form_obj.elements[field_name];\n\n\tif (!elm || elm.options == null || elm.selectedIndex == -1)\n\t\treturn \"\";\n\n\treturn elm.options[elm.selectedIndex].value;\n}\n\nfunction getLinkListHTML(elm_id, target_form_element, onchange_func) {\n\tif (typeof(tinyMCELinkList) == \"undefined\" || tinyMCELinkList.length == 0)\n\t\treturn \"\";\n\n\tvar html = \"\";\n\n\thtml += '<select id=\"' + elm_id + '\" name=\"' + elm_id + '\"';\n\thtml += ' class=\"mceLinkList\" onfoc2us=\"tinyMCE.addSelectAccessibility(event, this, window);\" onchange=\"this.form.' + target_form_element + '.value=';\n\thtml += 'this.options[this.selectedIndex].value;';\n\n\tif (typeof(onchange_func) != \"undefined\")\n\t\thtml += onchange_func + '(\\'' + target_form_element + '\\',this.options[this.selectedIndex].text,this.options[this.selectedIndex].value);';\n\n\thtml += '\"><option value=\"\">---</option>';\n\n\tfor (var i=0; i<tinyMCELinkList.length; i++)\n\t\thtml += '<option value=\"' + tinyMCELinkList[i][1] + '\">' + tinyMCELinkList[i][0] + '</option>';\n\n\thtml += '</select>';\n\n\treturn html;\n\n\t// tinyMCE.debug('-- image list start --', html, '-- image list end --');\n}\n\nfunction getTargetListHTML(elm_id, target_form_element) {\n\tvar targets = tinyMCEPopup.getParam('theme_advanced_link_targets', '').split(';');\n\tvar html = '';\n\n\thtml += '<select id=\"' + elm_id + '\" name=\"' + elm_id + '\" onf2ocus=\"tinyMCE.addSelectAccessibility(event, this, window);\" onchange=\"this.form.' + target_form_element + '.value=';\n\thtml += 'this.options[this.selectedIndex].value;\">';\n\thtml += '<option value=\"_self\">' + tinyMCEPopup.getLang('advlink_dlg.target_same') + '</option>';\n\thtml += '<option value=\"_blank\">' + tinyMCEPopup.getLang('advlink_dlg.target_blank') + ' (_blank)</option>';\n\thtml += '<option value=\"_parent\">' + tinyMCEPopup.getLang('advlink_dlg.target_parent') + ' (_parent)</option>';\n\thtml += '<option value=\"_top\">' + tinyMCEPopup.getLang('advlink_dlg.target_top') + ' (_top)</option>';\n\n\tfor (var i=0; i<targets.length; i++) {\n\t\tvar key, value;\n\n\t\tif (targets[i] == \"\")\n\t\t\tcontinue;\n\n\t\tkey = targets[i].split('=')[0];\n\t\tvalue = targets[i].split('=')[1];\n\n\t\thtml += '<option value=\"' + key + '\">' + value + ' (' + key + ')</option>';\n\t}\n\n\thtml += '</select>';\n\n\treturn html;\n}\n\n// While loading\npreinit();\ntinyMCEPopup.onInit.add(init);\n","Magento_Tinymce3/tiny_mce/plugins/advlink/langs/en_dlg.js":"tinyMCE.addI18n('en.advlink_dlg',{\"target_name\":\"Target Name\",classes:\"Classes\",style:\"Style\",id:\"ID\",\"popup_position\":\"Position (X/Y)\",langdir:\"Language Direction\",\"popup_size\":\"Size\",\"popup_dependent\":\"Dependent (Mozilla/Firefox Only)\",\"popup_resizable\":\"Make Window Resizable\",\"popup_location\":\"Show Location Bar\",\"popup_menubar\":\"Show Menu Bar\",\"popup_toolbar\":\"Show Toolbars\",\"popup_statusbar\":\"Show Status Bar\",\"popup_scrollbars\":\"Show Scrollbars\",\"popup_return\":\"Insert \\'return false\\'\",\"popup_name\":\"Window Name\",\"popup_url\":\"Popup URL\",popup:\"JavaScript Popup\",\"target_blank\":\"Open in New Window\",\"target_top\":\"Open in Top Frame (Replaces All Frames)\",\"target_parent\":\"Open in Parent Window/Frame\",\"target_same\":\"Open in This Window/Frame\",\"anchor_names\":\"Anchors\",\"popup_opts\":\"Options\",\"advanced_props\":\"Advanced Properties\",\"event_props\":\"Events\",\"popup_props\":\"Popup Properties\",\"general_props\":\"General Properties\",\"advanced_tab\":\"Advanced\",\"events_tab\":\"Events\",\"popup_tab\":\"Popup\",\"general_tab\":\"General\",list:\"Link List\",\"is_external\":\"The URL you entered seems to be an external link. Do you want to add the required http:// prefix?\",\"is_email\":\"The URL you entered seems to be an email address. Do you want to add the required mailto: prefix?\",titlefield:\"Title\",target:\"Target\",url:\"Link URL\",title:\"Insert/Edit Link\",\"link_list\":\"Link List\",rtl:\"Right to Left\",ltr:\"Left to Right\",accesskey:\"AccessKey\",tabindex:\"TabIndex\",rev:\"Relationship Target to Page\",rel:\"Relationship Page to Target\",mime:\"Target MIME Type\",encoding:\"Target Character Encoding\",langcode:\"Language Code\",\"target_langcode\":\"Target Language\",width:\"Width\",height:\"Height\"});","Magento_Tinymce3/tiny_mce/plugins/visualchars/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.VisualChars\",{init:function(a,b){var c=this;c.editor=a;a.addCommand(\"mceVisualChars\",c._toggleVisualChars,c);a.addButton(\"visualchars\",{title:\"visualchars.desc\",cmd:\"mceVisualChars\"});a.onBeforeGetContent.add(function(d,e){if(c.state&&e.format!=\"raw\"&&!e.draft){c.state=true;c._toggleVisualChars(false)}})},getInfo:function(){return{longname:\"Visual characters\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/visualchars\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}},_toggleVisualChars:function(m){var p=this,k=p.editor,a,g,j,n=k.getDoc(),o=k.getBody(),l,q=k.selection,e,c,f;p.state=!p.state;k.controlManager.setActive(\"visualchars\",p.state);if(m){f=q.getBookmark()}if(p.state){a=[];tinymce.walk(o,function(b){if(b.nodeType==3&&b.nodeValue&&b.nodeValue.indexOf(\"\\u00a0\")!=-1){a.push(b)}},\"childNodes\");for(g=0;g<a.length;g++){l=a[g].nodeValue;l=l.replace(/(\\u00a0)/g,'<span data-mce-bogus=\"1\" class=\"mceItemHidden mceItemNbsp\">$1</span>');c=k.dom.create(\"div\",null,l);while(node=c.lastChild){k.dom.insertAfter(node,a[g])}k.dom.remove(a[g])}}else{a=k.dom.select(\"span.mceItemNbsp\",o);for(g=a.length-1;g>=0;g--){k.dom.remove(a[g],1)}}q.moveToBookmark(f)}});tinymce.PluginManager.add(\"visualchars\",tinymce.plugins.VisualChars)})();","Magento_Tinymce3/tiny_mce/plugins/visualchars/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.VisualChars', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this;\n\n\t\t\tt.editor = ed;\n\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceVisualChars', t._toggleVisualChars, t);\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('visualchars', {title : 'visualchars.desc', cmd : 'mceVisualChars'});\n\n\t\t\ted.onBeforeGetContent.add(function(ed, o) {\n\t\t\t\tif (t.state && o.format != 'raw' && !o.draft) {\n\t\t\t\t\tt.state = true;\n\t\t\t\t\tt._toggleVisualChars(false);\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Visual characters',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/visualchars',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t},\n\n\t\t// Private methods\n\n\t\t_toggleVisualChars : function(bookmark) {\n\t\t\tvar t = this, ed = t.editor, nl, i, h, d = ed.getDoc(), b = ed.getBody(), nv, s = ed.selection, bo, div, bm;\n\n\t\t\tt.state = !t.state;\n\t\t\ted.controlManager.setActive('visualchars', t.state);\n\n\t\t\tif (bookmark)\n\t\t\t\tbm = s.getBookmark();\n\n\t\t\tif (t.state) {\n\t\t\t\tnl = [];\n\t\t\t\ttinymce.walk(b, function(n) {\n\t\t\t\t\tif (n.nodeType == 3 && n.nodeValue && n.nodeValue.indexOf('\\u00a0') != -1)\n\t\t\t\t\t\tnl.push(n);\n\t\t\t\t}, 'childNodes');\n\n\t\t\t\tfor (i = 0; i < nl.length; i++) {\n\t\t\t\t\tnv = nl[i].nodeValue;\n\t\t\t\t\tnv = nv.replace(/(\\u00a0)/g, '<span data-mce-bogus=\"1\" class=\"mceItemHidden mceItemNbsp\">$1</span>');\n\n\t\t\t\t\tdiv = ed.dom.create('div', null, nv);\n\t\t\t\t\twhile (node = div.lastChild)\n\t\t\t\t\t\ted.dom.insertAfter(node, nl[i]);\n\n\t\t\t\t\ted.dom.remove(nl[i]);\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tnl = ed.dom.select('span.mceItemNbsp', b);\n\n\t\t\t\tfor (i = nl.length - 1; i >= 0; i--)\n\t\t\t\t\ted.dom.remove(nl[i], 1);\n\t\t\t}\n\n\t\t\ts.moveToBookmark(bm);\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('visualchars', tinymce.plugins.VisualChars);\n})();","Magento_Tinymce3/tiny_mce/plugins/noneditable/editor_plugin.js":"(function(){var a=tinymce.dom.Event;tinymce.create(\"tinymce.plugins.NonEditablePlugin\",{init:function(d,e){var f=this,c,b,g;f.editor=d;c=d.getParam(\"noneditable_editable_class\",\"mceEditable\");b=d.getParam(\"noneditable_noneditable_class\",\"mceNonEditable\");d.onNodeChange.addToTop(function(i,h,l){var k,j;k=i.dom.getParent(i.selection.getStart(),function(m){return i.dom.hasClass(m,b)});j=i.dom.getParent(i.selection.getEnd(),function(m){return i.dom.hasClass(m,b)});if(k||j){g=1;f._setDisabled(1);return false}else{if(g==1){f._setDisabled(0);g=0}}})},getInfo:function(){return{longname:\"Non editable elements\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/noneditable\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}},_block:function(c,d){var b=d.keyCode;if((b>32&&b<41)||(b>111&&b<124)){return}return a.cancel(d)},_setDisabled:function(d){var c=this,b=c.editor;tinymce.each(b.controlManager.controls,function(e){e.setDisabled(d)});if(d!==c.disabled){if(d){b.onKeyDown.addToTop(c._block);b.onKeyPress.addToTop(c._block);b.onKeyUp.addToTop(c._block);b.onPaste.addToTop(c._block);b.onContextMenu.addToTop(c._block)}else{b.onKeyDown.remove(c._block);b.onKeyPress.remove(c._block);b.onKeyUp.remove(c._block);b.onPaste.remove(c._block);b.onContextMenu.remove(c._block)}c.disabled=d}}});tinymce.PluginManager.add(\"noneditable\",tinymce.plugins.NonEditablePlugin)})();","Magento_Tinymce3/tiny_mce/plugins/noneditable/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\tvar Event = tinymce.dom.Event;\n\n\ttinymce.create('tinymce.plugins.NonEditablePlugin', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this, editClass, nonEditClass, state;\n\n\t\t\tt.editor = ed;\n\t\t\teditClass = ed.getParam(\"noneditable_editable_class\", \"mceEditable\");\n\t\t\tnonEditClass = ed.getParam(\"noneditable_noneditable_class\", \"mceNonEditable\");\n\n\t\t\ted.onNodeChange.addToTop(function(ed, cm, n) {\n\t\t\t\tvar sc, ec;\n\n\t\t\t\t// Block if start or end is inside a non editable element\n\t\t\t\tsc = ed.dom.getParent(ed.selection.getStart(), function(n) {\n\t\t\t\t\treturn ed.dom.hasClass(n, nonEditClass);\n\t\t\t\t});\n\n\t\t\t\tec = ed.dom.getParent(ed.selection.getEnd(), function(n) {\n\t\t\t\t\treturn ed.dom.hasClass(n, nonEditClass);\n\t\t\t\t});\n\n\t\t\t\t// Block or unblock\n\t\t\t\tif (sc || ec) {\n\t\t\t\t\tstate = 1;\n\t\t\t\t\tt._setDisabled(1);\n\t\t\t\t\treturn false;\n\t\t\t\t} else if (state == 1) {\n\t\t\t\t\tt._setDisabled(0);\n\t\t\t\t\tstate = 0;\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Non editable elements',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/noneditable',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t},\n\n\t\t_block : function(ed, e) {\n\t\t\tvar k = e.keyCode;\n\n\t\t\t// Don't block arrow keys, pg up/down, and F1-F12\n\t\t\tif ((k > 32 && k < 41) || (k > 111 && k < 124))\n\t\t\t\treturn;\n\n\t\t\treturn Event.cancel(e);\n\t\t},\n\n\t\t_setDisabled : function(s) {\n\t\t\tvar t = this, ed = t.editor;\n\n\t\t\ttinymce.each(ed.controlManager.controls, function(c) {\n\t\t\t\tc.setDisabled(s);\n\t\t\t});\n\n\t\t\tif (s !== t.disabled) {\n\t\t\t\tif (s) {\n\t\t\t\t\ted.onKeyDown.addToTop(t._block);\n\t\t\t\t\ted.onKeyPress.addToTop(t._block);\n\t\t\t\t\ted.onKeyUp.addToTop(t._block);\n\t\t\t\t\ted.onPaste.addToTop(t._block);\n\t\t\t\t\ted.onContextMenu.addToTop(t._block);\n\t\t\t\t} else {\n\t\t\t\t\ted.onKeyDown.remove(t._block);\n\t\t\t\t\ted.onKeyPress.remove(t._block);\n\t\t\t\t\ted.onKeyUp.remove(t._block);\n\t\t\t\t\ted.onPaste.remove(t._block);\n\t\t\t\t\ted.onContextMenu.remove(t._block);\n\t\t\t\t}\n\n\t\t\t\tt.disabled = s;\n\t\t\t}\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('noneditable', tinymce.plugins.NonEditablePlugin);\n})();","Magento_Tinymce3/tiny_mce/plugins/example_dependency/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.ExampleDependencyPlugin\",{init:function(a,b){},getInfo:function(){return{longname:\"Example Dependency plugin\",author:\"Some author\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/example_dependency\",version:\"1.0\"}}});tinymce.PluginManager.add(\"example_dependency\",tinymce.plugins.ExampleDependencyPlugin,[\"example\"])})();","Magento_Tinymce3/tiny_mce/plugins/example_dependency/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\n\ttinymce.create('tinymce.plugins.ExampleDependencyPlugin', {\n\t\t/**\n\t\t * Initializes the plugin, this will be executed after the plugin has been created.\n\t\t * This call is done before the editor instance has finished it's initialization so use the onInit event\n\t\t * of the editor instance to intercept that event.\n\t\t *\n\t\t * @param {tinymce.Editor} ed Editor instance that the plugin is initialized in.\n\t\t * @param {string} url Absolute URL to where the plugin is located.\n\t\t */\n\t\tinit : function(ed, url) {\n\t\t},\n\n\n\t\t/**\n\t\t * Returns information about the plugin as a name/value array.\n\t\t * The current keys are longname, author, authorurl, infourl and version.\n\t\t *\n\t\t * @return {Object} Name/value array containing information about the plugin.\n\t\t */\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Example Dependency plugin',\n\t\t\t\tauthor : 'Some author',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/example_dependency',\n\t\t\t\tversion : \"1.0\"\n\t\t\t};\n\t\t}\n\t});\n\n\t/**\n\t * Register the plugin, specifying the list of the plugins that this plugin depends on.  They are specified in a list, with the list loaded in order.\n\t * plugins in this list will be initialised when this plugin is initialized. (before the init method is called).\n\t * plugins in a depends list should typically be specified using the short name).  If necessary this can be done\n\t * with an object which has the url to the plugin and the shortname.\n\t */\n\ttinymce.PluginManager.add('example_dependency', tinymce.plugins.ExampleDependencyPlugin, ['example']);\n})();\n","Magento_Tinymce3/tiny_mce/plugins/tabfocus/editor_plugin.js":"(function(){var c=tinymce.DOM,a=tinymce.dom.Event,d=tinymce.each,b=tinymce.explode;tinymce.create(\"tinymce.plugins.TabFocusPlugin\",{init:function(f,g){function e(i,j){if(j.keyCode===9){return a.cancel(j)}}function h(l,p){var j,m,o,n,k;function q(t){n=c.select(\":input:enabled,*[tabindex]\");function s(v){return v.nodeName===\"BODY\"||(v.type!=\"hidden\"&&!(v.style.display==\"none\")&&!(v.style.visibility==\"hidden\")&&s(v.parentNode))}function i(v){return v.attributes.tabIndex.specified||v.nodeName==\"INPUT\"||v.nodeName==\"TEXTAREA\"}function u(){return tinymce.isIE6||tinymce.isIE7}function r(v){return((!u()||i(v)))&&v.getAttribute(\"tabindex\")!=\"-1\"&&s(v)}d(n,function(w,v){if(w.id==l.id){j=v;return false}});if(t>0){for(m=j+1;m<n.length;m++){if(r(n[m])){return n[m]}}}else{for(m=j-1;m>=0;m--){if(r(n[m])){return n[m]}}}return null}if(p.keyCode===9){k=b(l.getParam(\"tab_focus\",l.getParam(\"tabfocus_elements\",\":prev,:next\")));if(k.length==1){k[1]=k[0];k[0]=\":prev\"}if(p.shiftKey){if(k[0]==\":prev\"){n=q(-1)}else{n=c.get(k[0])}}else{if(k[1]==\":next\"){n=q(1)}else{n=c.get(k[1])}}if(n){if(n.id&&(l=tinymce.get(n.id||n.name))){l.focus()}else{window.setTimeout(function(){if(!tinymce.isWebKit){window.focus()}n.focus()},10)}return a.cancel(p)}}}f.onKeyUp.add(e);if(tinymce.isGecko){f.onKeyPress.add(h);f.onKeyDown.add(e)}else{f.onKeyDown.add(h)}},getInfo:function(){return{longname:\"Tabfocus\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/tabfocus\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"tabfocus\",tinymce.plugins.TabFocusPlugin)})();","Magento_Tinymce3/tiny_mce/plugins/tabfocus/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each, explode = tinymce.explode;\n\n\ttinymce.create('tinymce.plugins.TabFocusPlugin', {\n\t\tinit : function(ed, url) {\n\t\t\tfunction tabCancel(ed, e) {\n\t\t\t\tif (e.keyCode === 9)\n\t\t\t\t\treturn Event.cancel(e);\n\t\t\t}\n\n\t\t\tfunction tabHandler(ed, e) {\n\t\t\t\tvar x, i, f, el, v;\n\n\t\t\t\tfunction find(d) {\n\t\t\t\t\tel = DOM.select(':input:enabled,*[tabindex]');\n\n\t\t\t\t\tfunction canSelectRecursive(e) {\n\t\t\t\t\t\treturn e.nodeName===\"BODY\" || (e.type != 'hidden' &&\n\t\t\t\t\t\t\t!(e.style.display == \"none\") &&\n\t\t\t\t\t\t\t!(e.style.visibility == \"hidden\") && canSelectRecursive(e.parentNode));\n\t\t\t\t\t}\n\t\t\t\t\tfunction canSelectInOldIe(el) {\n\t\t\t\t\t\treturn el.attributes[\"tabIndex\"].specified || el.nodeName == \"INPUT\" || el.nodeName == \"TEXTAREA\";\n\t\t\t\t\t}\n\t\t\t\t\tfunction isOldIe() {\n\t\t\t\t\t\treturn tinymce.isIE6 || tinymce.isIE7;\n\t\t\t\t\t}\n\t\t\t\t\tfunction canSelect(el) {\n\t\t\t\t\t\treturn ((!isOldIe() || canSelectInOldIe(el))) && el.getAttribute(\"tabindex\") != '-1' && canSelectRecursive(el);\n\t\t\t\t\t}\n\n\t\t\t\t\teach(el, function(e, i) {\n\t\t\t\t\t\tif (e.id == ed.id) {\n\t\t\t\t\t\t\tx = i;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\tif (d > 0) {\n\t\t\t\t\t\tfor (i = x + 1; i < el.length; i++) {\n\t\t\t\t\t\t\tif (canSelect(el[i]))\n\t\t\t\t\t\t\t\treturn el[i];\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\tfor (i = x - 1; i >= 0; i--) {\n\t\t\t\t\t\t\tif (canSelect(el[i]))\n\t\t\t\t\t\t\t\treturn el[i];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn null;\n\t\t\t\t}\n\n\t\t\t\tif (e.keyCode === 9) {\n\t\t\t\t\tv = explode(ed.getParam('tab_focus', ed.getParam('tabfocus_elements', ':prev,:next')));\n\n\t\t\t\t\tif (v.length == 1) {\n\t\t\t\t\t\tv[1] = v[0];\n\t\t\t\t\t\tv[0] = ':prev';\n\t\t\t\t\t}\n\n\t\t\t\t\t// Find element to focus\n\t\t\t\t\tif (e.shiftKey) {\n\t\t\t\t\t\tif (v[0] == ':prev')\n\t\t\t\t\t\t\tel = find(-1);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tel = DOM.get(v[0]);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif (v[1] == ':next')\n\t\t\t\t\t\t\tel = find(1);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tel = DOM.get(v[1]);\n\t\t\t\t\t}\n\n\t\t\t\t\tif (el) {\n\t\t\t\t\t\tif (el.id && (ed = tinymce.get(el.id || el.name)))\n\t\t\t\t\t\t\ted.focus();\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\twindow.setTimeout(function() {\n\t\t\t\t\t\t\t\tif (!tinymce.isWebKit)\n\t\t\t\t\t\t\t\t\twindow.focus();\n\t\t\t\t\t\t\t\tel.focus();\n\t\t\t\t\t\t\t}, 10);\n\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\ted.onKeyUp.add(tabCancel);\n\n\t\t\tif (tinymce.isGecko) {\n\t\t\t\ted.onKeyPress.add(tabHandler);\n\t\t\t\ted.onKeyDown.add(tabCancel);\n\t\t\t} else\n\t\t\t\ted.onKeyDown.add(tabHandler);\n\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Tabfocus',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/tabfocus',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('tabfocus', tinymce.plugins.TabFocusPlugin);\n})();\n","Magento_Tinymce3/tiny_mce/plugins/autoresize/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.AutoResizePlugin\",{init:function(a,c){var d=this,e=0;if(a.getParam(\"fullscreen_is_enabled\")){return}function b(){var i=a.getDoc(),f=i.body,k=i.documentElement,h=tinymce.DOM,j=d.autoresize_min_height,g;g=tinymce.isIE?f.scrollHeight:i.body.offsetHeight;if(g>d.autoresize_min_height){j=g}if(d.autoresize_max_height&&g>d.autoresize_max_height){j=d.autoresize_max_height;a.getBody().style.overflowY=\"auto\"}else{a.getBody().style.overflowY=\"hidden\"}if(j!==e){h.setStyle(h.get(a.id+\"_ifr\"),\"height\",j+\"px\");e=j}if(d.throbbing){a.setProgressState(false);a.setProgressState(true)}}d.editor=a;d.autoresize_min_height=parseInt(a.getParam(\"autoresize_min_height\",a.getElement().offsetHeight));d.autoresize_max_height=parseInt(a.getParam(\"autoresize_max_height\",0));a.onInit.add(function(f){f.dom.setStyle(f.getBody(),\"paddingBottom\",f.getParam(\"autoresize_bottom_margin\",50)+\"px\")});a.onChange.add(b);a.onSetContent.add(b);a.onPaste.add(b);a.onKeyUp.add(b);a.onPostRender.add(b);if(a.getParam(\"autoresize_on_init\",true)){a.onInit.add(function(g,f){g.setProgressState(true);d.throbbing=true;g.getBody().style.overflowY=\"hidden\"});a.onLoadContent.add(function(g,f){b();setTimeout(function(){b();g.setProgressState(false);d.throbbing=false},1250)})}a.addCommand(\"mceAutoResize\",b)},getInfo:function(){return{longname:\"Auto Resize\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/autoresize\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"autoresize\",tinymce.plugins.AutoResizePlugin)})();","Magento_Tinymce3/tiny_mce/plugins/autoresize/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\t/**\n\t * Auto Resize\n\t * \n\t * This plugin automatically resizes the content area to fit its content height.\n\t * It will retain a minimum height, which is the height of the content area when\n\t * it's initialized.\n\t */\n\ttinymce.create('tinymce.plugins.AutoResizePlugin', {\n\t\t/**\n\t\t * Initializes the plugin, this will be executed after the plugin has been created.\n\t\t * This call is done before the editor instance has finished it's initialization so use the onInit event\n\t\t * of the editor instance to intercept that event.\n\t\t *\n\t\t * @param {tinymce.Editor} ed Editor instance that the plugin is initialized in.\n\t\t * @param {string} url Absolute URL to where the plugin is located.\n\t\t */\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this, oldSize = 0;\n\n\t\t\tif (ed.getParam('fullscreen_is_enabled'))\n\t\t\t\treturn;\n\n\t\t\t/**\n\t\t\t * This method gets executed each time the editor needs to resize.\n\t\t\t */\n\t\t\tfunction resize() {\n\t\t\t\tvar d = ed.getDoc(), b = d.body, de = d.documentElement, DOM = tinymce.DOM, resizeHeight = t.autoresize_min_height, myHeight;\n\n\t\t\t\t// Get height differently depending on the browser used\n\t\t\t\tmyHeight = tinymce.isIE ? b.scrollHeight : d.body.offsetHeight;\n\n\t\t\t\t// Don't make it smaller than the minimum height\n\t\t\t\tif (myHeight > t.autoresize_min_height)\n\t\t\t\t\tresizeHeight = myHeight;\n\n\t\t\t\t// If a maximum height has been defined don't exceed this height\n\t\t\t\tif (t.autoresize_max_height && myHeight > t.autoresize_max_height) {\n\t\t\t\t\tresizeHeight = t.autoresize_max_height;\n\t\t\t\t\ted.getBody().style.overflowY = \"auto\";\n\t\t\t\t} else\n\t\t\t\t\ted.getBody().style.overflowY = \"hidden\";\n\n\t\t\t\t// Resize content element\n\t\t\t\tif (resizeHeight !== oldSize) {\n\t\t\t\t\tDOM.setStyle(DOM.get(ed.id + '_ifr'), 'height', resizeHeight + 'px');\n\t\t\t\t\toldSize = resizeHeight;\n\t\t\t\t}\n\n\t\t\t\t// if we're throbbing, we'll re-throb to match the new size\n\t\t\t\tif (t.throbbing) {\n\t\t\t\t\ted.setProgressState(false);\n\t\t\t\t\ted.setProgressState(true);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tt.editor = ed;\n\n\t\t\t// Define minimum height\n\t\t\tt.autoresize_min_height = parseInt( ed.getParam('autoresize_min_height', ed.getElement().offsetHeight) );\n\n\t\t\t// Define maximum height\t\n\t\t\tt.autoresize_max_height = parseInt( ed.getParam('autoresize_max_height', 0) );\n\n\t\t\t// Add padding at the bottom for better UX\n\t\t\ted.onInit.add(function(ed){\n\t\t\t\ted.dom.setStyle(ed.getBody(), 'paddingBottom', ed.getParam('autoresize_bottom_margin', 50) + 'px');\n\t\t\t});\n\n\t\t\t// Add appropriate listeners for resizing content area\n\t\t\ted.onChange.add(resize);\n\t\t\ted.onSetContent.add(resize);\n\t\t\ted.onPaste.add(resize);\n\t\t\ted.onKeyUp.add(resize);\n\t\t\ted.onPostRender.add(resize);\n\n\t\t\tif (ed.getParam('autoresize_on_init', true)) {\n\t\t\t\t// Things to do when the editor is ready\n\t\t\t\ted.onInit.add(function(ed, l) {\n\t\t\t\t\t// Show throbber until content area is resized properly\n\t\t\t\t\ted.setProgressState(true);\n\t\t\t\t\tt.throbbing = true;\n\n\t\t\t\t\t// Hide scrollbars\n\t\t\t\t\ted.getBody().style.overflowY = \"hidden\";\n\t\t\t\t});\n\n\t\t\t\ted.onLoadContent.add(function(ed, l) {\n\t\t\t\t\tresize();\n\n\t\t\t\t\t// Because the content area resizes when its content CSS loads,\n\t\t\t\t\t// and we can't easily add a listener to its onload event,\n\t\t\t\t\t// we'll just trigger a resize after a short loading period\n\t\t\t\t\tsetTimeout(function() {\n\t\t\t\t\t\tresize();\n\n\t\t\t\t\t\t// Disable throbber\n\t\t\t\t\t\ted.setProgressState(false);\n\t\t\t\t\t\tt.throbbing = false;\n\t\t\t\t\t}, 1250);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Register the command so that it can be invoked by using tinyMCE.activeEditor.execCommand('mceExample');\n\t\t\ted.addCommand('mceAutoResize', resize);\n\t\t},\n\n\t\t/**\n\t\t * Returns information about the plugin as a name/value array.\n\t\t * The current keys are longname, author, authorurl, infourl and version.\n\t\t *\n\t\t * @return {Object} Name/value array containing information about the plugin.\n\t\t */\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Auto Resize',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/autoresize',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('autoresize', tinymce.plugins.AutoResizePlugin);\n})();\n","Magento_Tinymce3/tiny_mce/plugins/print/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.Print\",{init:function(a,b){a.addCommand(\"mcePrint\",function(){a.getWin().print()});a.addButton(\"print\",{title:\"print.print_desc\",cmd:\"mcePrint\"})},getInfo:function(){return{longname:\"Print\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/print\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"print\",tinymce.plugins.Print)})();","Magento_Tinymce3/tiny_mce/plugins/print/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.Print', {\n\t\tinit : function(ed, url) {\n\t\t\ted.addCommand('mcePrint', function() {\n\t\t\t\ted.getWin().print();\n\t\t\t});\n\n\t\t\ted.addButton('print', {title : 'print.print_desc', cmd : 'mcePrint'});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Print',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/print',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('print', tinymce.plugins.Print);\n})();\n","Magento_Tinymce3/tiny_mce/plugins/magentowidget/editor_plugin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global tinyMCE, tinymceDeprecated, widgetTools, Base64 */\n/* eslint-disable strict */\ntinyMCE.addI18n({\n    en: {\n        magentowidget: {\n            'insert_widget': 'Insert Widget'\n        }\n    }\n});\n\n(function () {\n\n    tinymce.create('tinymce.plugins.MagentowidgetPlugin', {\n        /**\n         * @param {tinymceDeprecated.Editor} ed - Editor instance that the plugin is initialized in.\n         * @param {String} url - Absolute URL to where the plugin is located.\n         */\n        init: function (ed, url) {\n            ed.addCommand('mceMagentowidget', function () {\n                widgetTools.openDialog(\n                    ed.settings['magentowidget_url'] + 'widget_target_id/' + ed.getElement().id + '/'\n                );\n            });\n\n            // Register Widget plugin button\n            ed.addButton('magentowidget', {\n                title: 'magentowidget.insert_widget',\n                cmd: 'mceMagentowidget',\n                image: url + '/img/icon.gif'\n            });\n\n            // Add a node change handler, selects the button in the UI when a image is selected\n            ed.onNodeChange.add(function (edi, cm, n) {\n                var widgetCode;\n\n                widgetTools.setEditMode(false);\n                cm.setActive('magentowidget', false);\n\n                if (n.id && n.nodeName == 'IMG') { //eslint-disable-line eqeqeq\n                    widgetCode = Base64.idDecode(n.id);\n\n                    if (widgetCode.indexOf('{{widget') !== -1) {\n                        widgetTools.setEditMode(true);\n                        cm.setActive('magentowidget', true);\n                    }\n                }\n            });\n\n            // Add a widget placeholder image double click callback\n            ed.onDblClick.add(function (edi, e) {\n                var n = e.target,\n                    widgetCode;\n\n                if (n.id && n.nodeName == 'IMG') { //eslint-disable-line eqeqeq\n                    widgetCode = Base64.idDecode(n.id);\n\n                    if (widgetCode.indexOf('{{widget') !== -1) {\n                        widgetTools.setEditMode(true);\n                        edi.execCommand('mceMagentowidget');\n                    }\n                }\n            });\n        },\n\n        /**\n         * @return {Object}\n         */\n        getInfo: function () {\n            return {\n                longname: 'Magento Widget Manager Plugin for TinyMCE 3.x',\n                author: 'Magento Core Team',\n                authorurl: 'http://magentocommerce.com',\n                infourl: 'http://magentocommerce.com',\n                version: '1.0'\n            };\n        }\n    });\n\n    // Register plugin\n    tinymce.PluginManager.add('magentowidget', tinymce.plugins.MagentowidgetPlugin);\n})();\n","Magento_Tinymce3/tiny_mce/plugins/advimage/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.AdvancedImagePlugin\",{init:function(a,b){a.addCommand(\"mceAdvImage\",function(){if(a.dom.getAttrib(a.selection.getNode(),\"class\",\"\").indexOf(\"mceItem\")!=-1){return}a.windowManager.open({file:b+\"/image.htm\",width:480+parseInt(a.getLang(\"advimage.delta_width\",0)),height:385+parseInt(a.getLang(\"advimage.delta_height\",0)),inline:1},{plugin_url:b})});a.addButton(\"image\",{title:\"advimage.image_desc\",cmd:\"mceAdvImage\"})},getInfo:function(){return{longname:\"Advanced image\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/advimage\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"advimage\",tinymce.plugins.AdvancedImagePlugin)})();","Magento_Tinymce3/tiny_mce/plugins/advimage/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.AdvancedImagePlugin', {\n\t\tinit : function(ed, url) {\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceAdvImage', function() {\n\t\t\t\t// Internal image object like a flash placeholder\n\t\t\t\tif (ed.dom.getAttrib(ed.selection.getNode(), 'class', '').indexOf('mceItem') != -1)\n\t\t\t\t\treturn;\n\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/image.htm',\n\t\t\t\t\twidth : 480 + parseInt(ed.getLang('advimage.delta_width', 0)),\n\t\t\t\t\theight : 385 + parseInt(ed.getLang('advimage.delta_height', 0)),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('image', {\n\t\t\t\ttitle : 'advimage.image_desc',\n\t\t\t\tcmd : 'mceAdvImage'\n\t\t\t});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Advanced image',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/advimage',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('advimage', tinymce.plugins.AdvancedImagePlugin);\n})();","Magento_Tinymce3/tiny_mce/plugins/advimage/js/image.js":"var ImageDialog = {\n\tpreInit : function() {\n\t\tvar url;\n\n\t\ttinyMCEPopup.requireLangPack();\n\n\t\tif (url = tinyMCEPopup.getParam(\"external_image_list_url\"))\n\t\t\tdocument.write('<script language=\"javascript\" type=\"text/javascript\" src=\"' + tinyMCEPopup.editor.documentBaseURI.toAbsolute(url) + '\"></script>');\n\t},\n\n\tinit : function(ed) {\n\t\tvar f = document.forms[0], nl = f.elements, ed = tinyMCEPopup.editor, dom = ed.dom, n = ed.selection.getNode(), fl = tinyMCEPopup.getParam('external_image_list', 'tinyMCEImageList');\n\n\t\ttinyMCEPopup.resizeToInnerSize();\n\t\tthis.fillClassList('class_list');\n\t\tthis.fillFileList('src_list', fl);\n\t\tthis.fillFileList('over_list', fl);\n\t\tthis.fillFileList('out_list', fl);\n\t\tTinyMCE_EditableSelects.init();\n\n\t\tif (n.nodeName == 'IMG') {\n\t\t\tnl.src.value = dom.getAttrib(n, 'src');\n\t\t\tnl.width.value = dom.getAttrib(n, 'width');\n\t\t\tnl.height.value = dom.getAttrib(n, 'height');\n\t\t\tnl.alt.value = dom.getAttrib(n, 'alt');\n\t\t\tnl.title.value = dom.getAttrib(n, 'title');\n\t\t\tnl.vspace.value = this.getAttrib(n, 'vspace');\n\t\t\tnl.hspace.value = this.getAttrib(n, 'hspace');\n\t\t\tnl.border.value = this.getAttrib(n, 'border');\n\t\t\tselectByValue(f, 'align', this.getAttrib(n, 'align'));\n\t\t\tselectByValue(f, 'class_list', dom.getAttrib(n, 'class'), true, true);\n\t\t\tnl.style.value = dom.getAttrib(n, 'style');\n\t\t\tnl.id.value = dom.getAttrib(n, 'id');\n\t\t\tnl.dir.value = dom.getAttrib(n, 'dir');\n\t\t\tnl.lang.value = dom.getAttrib(n, 'lang');\n\t\t\tnl.usemap.value = dom.getAttrib(n, 'usemap');\n\t\t\tnl.longdesc.value = dom.getAttrib(n, 'longdesc');\n\t\t\tnl.insert.value = ed.getLang('update');\n\n\t\t\tif (/^\\s*this.src\\s*=\\s*\\'([^\\']+)\\';?\\s*$/.test(dom.getAttrib(n, 'onmouseover')))\n\t\t\t\tnl.onmouseoversrc.value = dom.getAttrib(n, 'onmouseover').replace(/^\\s*this.src\\s*=\\s*\\'([^\\']+)\\';?\\s*$/, '$1');\n\n\t\t\tif (/^\\s*this.src\\s*=\\s*\\'([^\\']+)\\';?\\s*$/.test(dom.getAttrib(n, 'onmouseout')))\n\t\t\t\tnl.onmouseoutsrc.value = dom.getAttrib(n, 'onmouseout').replace(/^\\s*this.src\\s*=\\s*\\'([^\\']+)\\';?\\s*$/, '$1');\n\n\t\t\tif (ed.settings.inline_styles) {\n\t\t\t\t// Move attribs to styles\n\t\t\t\tif (dom.getAttrib(n, 'align'))\n\t\t\t\t\tthis.updateStyle('align');\n\n\t\t\t\tif (dom.getAttrib(n, 'hspace'))\n\t\t\t\t\tthis.updateStyle('hspace');\n\n\t\t\t\tif (dom.getAttrib(n, 'border'))\n\t\t\t\t\tthis.updateStyle('border');\n\n\t\t\t\tif (dom.getAttrib(n, 'vspace'))\n\t\t\t\t\tthis.updateStyle('vspace');\n\t\t\t}\n\t\t}\n\n\t\t// Setup browse button\n\t\tdocument.getElementById('srcbrowsercontainer').innerHTML = getBrowserHTML('srcbrowser','src','image','theme_advanced_image');\n\t\tif (isVisible('srcbrowser'))\n\t\t\tdocument.getElementById('src').style.width = '260px';\n\n\t\t// Setup browse button\n\t\tdocument.getElementById('onmouseoversrccontainer').innerHTML = getBrowserHTML('overbrowser','onmouseoversrc','image','theme_advanced_image');\n\t\tif (isVisible('overbrowser'))\n\t\t\tdocument.getElementById('onmouseoversrc').style.width = '260px';\n\n\t\t// Setup browse button\n\t\tdocument.getElementById('onmouseoutsrccontainer').innerHTML = getBrowserHTML('outbrowser','onmouseoutsrc','image','theme_advanced_image');\n\t\tif (isVisible('outbrowser'))\n\t\t\tdocument.getElementById('onmouseoutsrc').style.width = '260px';\n\n\t\t// If option enabled default contrain proportions to checked\n\t\tif (ed.getParam(\"advimage_constrain_proportions\", true))\n\t\t\tf.constrain.checked = true;\n\n\t\t// Check swap image if valid data\n\t\tif (nl.onmouseoversrc.value || nl.onmouseoutsrc.value)\n\t\t\tthis.setSwapImage(true);\n\t\telse\n\t\t\tthis.setSwapImage(false);\n\n\t\tthis.changeAppearance();\n\t\tthis.showPreviewImage(nl.src.value, 1);\n\t},\n\n\tinsert : function(file, title) {\n\t\tvar ed = tinyMCEPopup.editor, t = this, f = document.forms[0];\n\n\t\tif (f.src.value === '') {\n\t\t\tif (ed.selection.getNode().nodeName == 'IMG') {\n\t\t\t\ted.dom.remove(ed.selection.getNode());\n\t\t\t\ted.execCommand('mceRepaint');\n\t\t\t}\n\n\t\t\ttinyMCEPopup.close();\n\t\t\treturn;\n\t\t}\n\n\t\tif (tinyMCEPopup.getParam(\"accessibility_warnings\", 1)) {\n\t\t\tif (!f.alt.value) {\n\t\t\t\ttinyMCEPopup.confirm(tinyMCEPopup.getLang('advimage_dlg.missing_alt'), function(s) {\n\t\t\t\t\tif (s)\n\t\t\t\t\t\tt.insertAndClose();\n\t\t\t\t});\n\n\t\t\t\treturn;\n\t\t\t}\n\t\t}\n\n\t\tt.insertAndClose();\n\t},\n\n\tinsertAndClose : function() {\n\t\tvar ed = tinyMCEPopup.editor, f = document.forms[0], nl = f.elements, v, args = {}, el;\n\n\t\ttinyMCEPopup.restoreSelection();\n\n\t\t// Fixes crash in Safari\n\t\tif (tinymce.isWebKit)\n\t\t\ted.getWin().focus();\n\n\t\tif (!ed.settings.inline_styles) {\n\t\t\targs = {\n\t\t\t\tvspace : nl.vspace.value,\n\t\t\t\thspace : nl.hspace.value,\n\t\t\t\tborder : nl.border.value,\n\t\t\t\talign : getSelectValue(f, 'align')\n\t\t\t};\n\t\t} else {\n\t\t\t// Remove deprecated values\n\t\t\targs = {\n\t\t\t\tvspace : '',\n\t\t\t\thspace : '',\n\t\t\t\tborder : '',\n\t\t\t\talign : ''\n\t\t\t};\n\t\t}\n\n\t\ttinymce.extend(args, {\n\t\t\tsrc : nl.src.value.replace(/ /g, '%20'),\n\t\t\twidth : nl.width.value,\n\t\t\theight : nl.height.value,\n\t\t\talt : nl.alt.value,\n\t\t\ttitle : nl.title.value,\n\t\t\t'class' : getSelectValue(f, 'class_list'),\n\t\t\tstyle : nl.style.value,\n\t\t\tid : nl.id.value,\n\t\t\tdir : nl.dir.value,\n\t\t\tlang : nl.lang.value,\n\t\t\tusemap : nl.usemap.value,\n\t\t\tlongdesc : nl.longdesc.value\n\t\t});\n\n\t\targs.onmouseover = args.onmouseout = '';\n\n\t\tif (f.onmousemovecheck.checked) {\n\t\t\tif (nl.onmouseoversrc.value)\n\t\t\t\targs.onmouseover = \"this.src='\" + nl.onmouseoversrc.value + \"';\";\n\n\t\t\tif (nl.onmouseoutsrc.value)\n\t\t\t\targs.onmouseout = \"this.src='\" + nl.onmouseoutsrc.value + \"';\";\n\t\t}\n\n\t\tel = ed.selection.getNode();\n\n\t\tif (el && el.nodeName == 'IMG') {\n\t\t\ted.dom.setAttribs(el, args);\n\t\t} else {\n\t\t\ttinymce.each(args, function(value, name) {\n\t\t\t\tif (value === \"\") {\n\t\t\t\t\tdelete args[name];\n\t\t\t\t}\n\t\t\t});\n\n\t\t\ted.execCommand('mceInsertContent', false, tinyMCEPopup.editor.dom.createHTML('img', args), {skip_undo : 1});\n\t\t\ted.undoManager.add();\n\t\t}\n\n\t\ttinyMCEPopup.editor.execCommand('mceRepaint');\n\t\ttinyMCEPopup.editor.focus();\n\t\ttinyMCEPopup.close();\n\t\ted.onChange.dispatch(ed);\n\t},\n\n\tgetAttrib : function(e, at) {\n\t\tvar ed = tinyMCEPopup.editor, dom = ed.dom, v, v2;\n\n\t\tif (ed.settings.inline_styles) {\n\t\t\tswitch (at) {\n\t\t\t\tcase 'align':\n\t\t\t\t\tif (v = dom.getStyle(e, 'float'))\n\t\t\t\t\t\treturn v;\n\n\t\t\t\t\tif (v = dom.getStyle(e, 'vertical-align'))\n\t\t\t\t\t\treturn v;\n\n\t\t\t\t\tbreak;\n\n\t\t\t\tcase 'hspace':\n\t\t\t\t\tv = dom.getStyle(e, 'margin-left')\n\t\t\t\t\tv2 = dom.getStyle(e, 'margin-right');\n\n\t\t\t\t\tif (v && v == v2)\n\t\t\t\t\t\treturn parseInt(v.replace(/[^0-9]/g, ''));\n\n\t\t\t\t\tbreak;\n\n\t\t\t\tcase 'vspace':\n\t\t\t\t\tv = dom.getStyle(e, 'margin-top')\n\t\t\t\t\tv2 = dom.getStyle(e, 'margin-bottom');\n\t\t\t\t\tif (v && v == v2)\n\t\t\t\t\t\treturn parseInt(v.replace(/[^0-9]/g, ''));\n\n\t\t\t\t\tbreak;\n\n\t\t\t\tcase 'border':\n\t\t\t\t\tv = 0;\n\n\t\t\t\t\ttinymce.each(['top', 'right', 'bottom', 'left'], function(sv) {\n\t\t\t\t\t\tsv = dom.getStyle(e, 'border-' + sv + '-width');\n\n\t\t\t\t\t\t// False or not the same as prev\n\t\t\t\t\t\tif (!sv || (sv != v && v !== 0)) {\n\t\t\t\t\t\t\tv = 0;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (sv)\n\t\t\t\t\t\t\tv = sv;\n\t\t\t\t\t});\n\n\t\t\t\t\tif (v)\n\t\t\t\t\t\treturn parseInt(v.replace(/[^0-9]/g, ''));\n\n\t\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\n\t\tif (v = dom.getAttrib(e, at))\n\t\t\treturn v;\n\n\t\treturn '';\n\t},\n\n\tsetSwapImage : function(st) {\n\t\tvar f = document.forms[0];\n\n\t\tf.onmousemovecheck.checked = st;\n\t\tsetBrowserDisabled('overbrowser', !st);\n\t\tsetBrowserDisabled('outbrowser', !st);\n\n\t\tif (f.over_list)\n\t\t\tf.over_list.disabled = !st;\n\n\t\tif (f.out_list)\n\t\t\tf.out_list.disabled = !st;\n\n\t\tf.onmouseoversrc.disabled = !st;\n\t\tf.onmouseoutsrc.disabled  = !st;\n\t},\n\n\tfillClassList : function(id) {\n\t\tvar dom = tinyMCEPopup.dom, lst = dom.get(id), v, cl;\n\n\t\tif (v = tinyMCEPopup.getParam('theme_advanced_styles')) {\n\t\t\tcl = [];\n\n\t\t\ttinymce.each(v.split(';'), function(v) {\n\t\t\t\tvar p = v.split('=');\n\n\t\t\t\tcl.push({'title' : p[0], 'class' : p[1]});\n\t\t\t});\n\t\t} else\n\t\t\tcl = tinyMCEPopup.editor.dom.getClasses();\n\n\t\tif (cl.length > 0) {\n\t\t\tlst.options.length = 0;\n\t\t\tlst.options[lst.options.length] = new Option(tinyMCEPopup.getLang('not_set'), '');\n\n\t\t\ttinymce.each(cl, function(o) {\n\t\t\t\tlst.options[lst.options.length] = new Option(o.title || o['class'], o['class']);\n\t\t\t});\n\t\t} else\n\t\t\tdom.remove(dom.getParent(id, 'tr'));\n\t},\n\n\tfillFileList : function(id, l) {\n\t\tvar dom = tinyMCEPopup.dom, lst = dom.get(id), v, cl;\n\n\t\tl = typeof(l) === 'function' ? l() : window[l];\n\t\tlst.options.length = 0;\n\n\t\tif (l && l.length > 0) {\n\t\t\tlst.options[lst.options.length] = new Option('', '');\n\n\t\t\ttinymce.each(l, function(o) {\n\t\t\t\tlst.options[lst.options.length] = new Option(o[0], o[1]);\n\t\t\t});\n\t\t} else\n\t\t\tdom.remove(dom.getParent(id, 'tr'));\n\t},\n\n\tresetImageData : function() {\n\t\tvar f = document.forms[0];\n\n\t\tf.elements.width.value = f.elements.height.value = '';\n\t},\n\n\tupdateImageData : function(img, st) {\n\t\tvar f = document.forms[0];\n\n\t\tif (!st) {\n\t\t\tf.elements.width.value = img.width;\n\t\t\tf.elements.height.value = img.height;\n\t\t}\n\n\t\tthis.preloadImg = img;\n\t},\n\n\tchangeAppearance : function() {\n\t\tvar ed = tinyMCEPopup.editor, f = document.forms[0], img = document.getElementById('alignSampleImg');\n\n\t\tif (img) {\n\t\t\tif (ed.getParam('inline_styles')) {\n\t\t\t\ted.dom.setAttrib(img, 'style', f.style.value);\n\t\t\t} else {\n\t\t\t\timg.align = f.align.value;\n\t\t\t\timg.border = f.border.value;\n\t\t\t\timg.hspace = f.hspace.value;\n\t\t\t\timg.vspace = f.vspace.value;\n\t\t\t}\n\t\t}\n\t},\n\n\tchangeHeight : function() {\n\t\tvar f = document.forms[0], tp, t = this;\n\n\t\tif (!f.constrain.checked || !t.preloadImg) {\n\t\t\treturn;\n\t\t}\n\n\t\tif (f.width.value == \"\" || f.height.value == \"\")\n\t\t\treturn;\n\n\t\ttp = (parseInt(f.width.value) / parseInt(t.preloadImg.width)) * t.preloadImg.height;\n\t\tf.height.value = tp.toFixed(0);\n\t},\n\n\tchangeWidth : function() {\n\t\tvar f = document.forms[0], tp, t = this;\n\n\t\tif (!f.constrain.checked || !t.preloadImg) {\n\t\t\treturn;\n\t\t}\n\n\t\tif (f.width.value == \"\" || f.height.value == \"\")\n\t\t\treturn;\n\n\t\ttp = (parseInt(f.height.value) / parseInt(t.preloadImg.height)) * t.preloadImg.width;\n\t\tf.width.value = tp.toFixed(0);\n\t},\n\n\tupdateStyle : function(ty) {\n\t\tvar dom = tinyMCEPopup.dom, b, bStyle, bColor, v, isIE = tinymce.isIE, f = document.forms[0], img = dom.create('img', {style : dom.get('style').value});\n\n\t\tif (tinyMCEPopup.editor.settings.inline_styles) {\n\t\t\t// Handle align\n\t\t\tif (ty == 'align') {\n\t\t\t\tdom.setStyle(img, 'float', '');\n\t\t\t\tdom.setStyle(img, 'vertical-align', '');\n\n\t\t\t\tv = getSelectValue(f, 'align');\n\t\t\t\tif (v) {\n\t\t\t\t\tif (v == 'left' || v == 'right')\n\t\t\t\t\t\tdom.setStyle(img, 'float', v);\n\t\t\t\t\telse\n\t\t\t\t\t\timg.style.verticalAlign = v;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Handle border\n\t\t\tif (ty == 'border') {\n\t\t\t\tb = img.style.border ? img.style.border.split(' ') : [];\n\t\t\t\tbStyle = dom.getStyle(img, 'border-style');\n\t\t\t\tbColor = dom.getStyle(img, 'border-color');\n\n\t\t\t\tdom.setStyle(img, 'border', '');\n\n\t\t\t\tv = f.border.value;\n\t\t\t\tif (v || v == '0') {\n\t\t\t\t\tif (v == '0')\n\t\t\t\t\t\timg.style.border = isIE ? '0' : '0 none none';\n\t\t\t\t\telse {\n\t\t\t\t\t\tif (b.length == 3 && b[isIE ? 2 : 1])\n\t\t\t\t\t\t\tbStyle = b[isIE ? 2 : 1];\n\t\t\t\t\t\telse if (!bStyle || bStyle == 'none')\n\t\t\t\t\t\t\tbStyle = 'solid';\n\t\t\t\t\t\tif (b.length == 3 && b[isIE ? 0 : 2])\n\t\t\t\t\t\t\tbColor = b[isIE ? 0 : 2];\n\t\t\t\t\t\telse if (!bColor || bColor == 'none')\n\t\t\t\t\t\t\tbColor = 'black';\n\t\t\t\t\t\timg.style.border = v + 'px ' + bStyle + ' ' + bColor;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Handle hspace\n\t\t\tif (ty == 'hspace') {\n\t\t\t\tdom.setStyle(img, 'marginLeft', '');\n\t\t\t\tdom.setStyle(img, 'marginRight', '');\n\n\t\t\t\tv = f.hspace.value;\n\t\t\t\tif (v) {\n\t\t\t\t\timg.style.marginLeft = v + 'px';\n\t\t\t\t\timg.style.marginRight = v + 'px';\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Handle vspace\n\t\t\tif (ty == 'vspace') {\n\t\t\t\tdom.setStyle(img, 'marginTop', '');\n\t\t\t\tdom.setStyle(img, 'marginBottom', '');\n\n\t\t\t\tv = f.vspace.value;\n\t\t\t\tif (v) {\n\t\t\t\t\timg.style.marginTop = v + 'px';\n\t\t\t\t\timg.style.marginBottom = v + 'px';\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Merge\n\t\t\tdom.get('style').value = dom.serializeStyle(dom.parseStyle(img.style.cssText), 'img');\n\t\t}\n\t},\n\n\tchangeMouseMove : function() {\n\t},\n\n\tshowPreviewImage : function(u, st) {\n\t\tif (!u) {\n\t\t\ttinyMCEPopup.dom.setHTML('prev', '');\n\t\t\treturn;\n\t\t}\n\n\t\tif (!st && tinyMCEPopup.getParam(\"advimage_update_dimensions_onchange\", true))\n\t\t\tthis.resetImageData();\n\n\t\tu = tinyMCEPopup.editor.documentBaseURI.toAbsolute(u);\n\n\t\tif (!st)\n\t\t\ttinyMCEPopup.dom.setHTML('prev', '<img id=\"previewImg\" src=\"' + u + '\" border=\"0\" onload=\"ImageDialog.updateImageData(this);\" onerror=\"ImageDialog.resetImageData();\" />');\n\t\telse\n\t\t\ttinyMCEPopup.dom.setHTML('prev', '<img id=\"previewImg\" src=\"' + u + '\" border=\"0\" onload=\"ImageDialog.updateImageData(this, 1);\" />');\n\t}\n};\n\nImageDialog.preInit();\ntinyMCEPopup.onInit.add(ImageDialog.init, ImageDialog);\n","Magento_Tinymce3/tiny_mce/plugins/advimage/langs/en_dlg.js":"tinyMCE.addI18n('en.advimage_dlg',{\"image_list\":\"Image List\",\"align_right\":\"Right\",\"align_left\":\"Left\",\"align_textbottom\":\"Text Bottom\",\"align_texttop\":\"Text Top\",\"align_bottom\":\"Bottom\",\"align_middle\":\"Middle\",\"align_top\":\"Top\",\"align_baseline\":\"Baseline\",align:\"Alignment\",hspace:\"Horizontal Space\",vspace:\"Vertical Space\",dimensions:\"Dimensions\",border:\"Border\",list:\"Image List\",alt:\"Image Description\",src:\"Image URL\",\"dialog_title\":\"Insert/Edit Image\",\"missing_alt\":\"Are you sure you want to continue without including an Image Description? Without it the image may not be accessible to some users with disabilities, or to those using a text browser, or browsing the Web with images turned off.\",\"example_img\":\"Appearance Preview Image\",misc:\"Miscellaneous\",mouseout:\"For Mouse Out\",mouseover:\"For Mouse Over\",\"alt_image\":\"Alternative Image\",\"swap_image\":\"Swap Image\",map:\"Image Map\",id:\"ID\",rtl:\"Right to Left\",ltr:\"Left to Right\",classes:\"Classes\",style:\"Style\",\"long_desc\":\"Long Description Link\",langcode:\"Language Code\",langdir:\"Language Direction\",\"constrain_proportions\":\"Constrain Proportions\",preview:\"Preview\",title:\"Title\",general:\"General\",\"tab_advanced\":\"Advanced\",\"tab_appearance\":\"Appearance\",\"tab_general\":\"General\",width:\"Width\",height:\"Height\"});","Magento_Tinymce3/tiny_mce/plugins/advhr/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.AdvancedHRPlugin\",{init:function(a,b){a.addCommand(\"mceAdvancedHr\",function(){a.windowManager.open({file:b+\"/rule.htm\",width:250+parseInt(a.getLang(\"advhr.delta_width\",0)),height:160+parseInt(a.getLang(\"advhr.delta_height\",0)),inline:1},{plugin_url:b})});a.addButton(\"advhr\",{title:\"advhr.advhr_desc\",cmd:\"mceAdvancedHr\"});a.onNodeChange.add(function(d,c,e){c.setActive(\"advhr\",e.nodeName==\"HR\")});a.onClick.add(function(c,d){d=d.target;if(d.nodeName===\"HR\"){c.selection.select(d)}})},getInfo:function(){return{longname:\"Advanced HR\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/advhr\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"advhr\",tinymce.plugins.AdvancedHRPlugin)})();","Magento_Tinymce3/tiny_mce/plugins/advhr/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.AdvancedHRPlugin', {\n\t\tinit : function(ed, url) {\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceAdvancedHr', function() {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/rule.htm',\n\t\t\t\t\twidth : 250 + parseInt(ed.getLang('advhr.delta_width', 0)),\n\t\t\t\t\theight : 160 + parseInt(ed.getLang('advhr.delta_height', 0)),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('advhr', {\n\t\t\t\ttitle : 'advhr.advhr_desc',\n\t\t\t\tcmd : 'mceAdvancedHr'\n\t\t\t});\n\n\t\t\ted.onNodeChange.add(function(ed, cm, n) {\n\t\t\t\tcm.setActive('advhr', n.nodeName == 'HR');\n\t\t\t});\n\n\t\t\ted.onClick.add(function(ed, e) {\n\t\t\t\te = e.target;\n\n\t\t\t\tif (e.nodeName === 'HR')\n\t\t\t\t\ted.selection.select(e);\n\t\t\t});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Advanced HR',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/advhr',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('advhr', tinymce.plugins.AdvancedHRPlugin);\n})();","Magento_Tinymce3/tiny_mce/plugins/advhr/js/rule.js":"var AdvHRDialog = {\n\tinit : function(ed) {\n\t\tvar dom = ed.dom, f = document.forms[0], n = ed.selection.getNode(), w;\n\n\t\tw = dom.getAttrib(n, 'width');\n\t\tf.width.value = w ? parseInt(w) : (dom.getStyle('width') || '');\n\t\tf.size.value = dom.getAttrib(n, 'size') || parseInt(dom.getStyle('height')) || '';\n\t\tf.noshade.checked = !!dom.getAttrib(n, 'noshade') || !!dom.getStyle('border-width');\n\t\tselectByValue(f, 'width2', w.indexOf('%') != -1 ? '%' : 'px');\n\t},\n\n\tupdate : function() {\n\t\tvar ed = tinyMCEPopup.editor, h, f = document.forms[0], st = '';\n\n\t\th = '<hr';\n\n\t\tif (f.size.value) {\n\t\t\th += ' size=\"' + f.size.value + '\"';\n\t\t\tst += ' height:' + f.size.value + 'px;';\n\t\t}\n\n\t\tif (f.width.value) {\n\t\t\th += ' width=\"' + f.width.value + (f.width2.value == '%' ? '%' : '') + '\"';\n\t\t\tst += ' width:' + f.width.value + (f.width2.value == '%' ? '%' : 'px') + ';';\n\t\t}\n\n\t\tif (f.noshade.checked) {\n\t\t\th += ' noshade=\"noshade\"';\n\t\t\tst += ' border-width: 1px; border-style: solid; border-color: #CCCCCC; color: #ffffff;';\n\t\t}\n\n\t\tif (ed.settings.inline_styles)\n\t\t\th += ' style=\"' + tinymce.trim(st) + '\"';\n\n\t\th += ' />';\n\n\t\ted.execCommand(\"mceInsertContent\", false, h);\n\t\ttinyMCEPopup.close();\n\t}\n};\n\ntinyMCEPopup.requireLangPack();\ntinyMCEPopup.onInit.add(AdvHRDialog.init, AdvHRDialog);\n","Magento_Tinymce3/tiny_mce/plugins/advhr/langs/en_dlg.js":"tinyMCE.addI18n('en.advhr_dlg',{size:\"Height\",noshade:\"No Shadow\",width:\"Width\",normal:\"Normal\",widthunits:\"Units\"});","Magento_Tinymce3/tiny_mce/plugins/searchreplace/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.SearchReplacePlugin\",{init:function(a,c){function b(d){window.focus();a.windowManager.open({file:c+\"/searchreplace.htm\",width:420+parseInt(a.getLang(\"searchreplace.delta_width\",0)),height:170+parseInt(a.getLang(\"searchreplace.delta_height\",0)),inline:1,auto_focus:0},{mode:d,search_string:a.selection.getContent({format:\"text\"}),plugin_url:c})}a.addCommand(\"mceSearch\",function(){b(\"search\")});a.addCommand(\"mceReplace\",function(){b(\"replace\")});a.addButton(\"search\",{title:\"searchreplace.search_desc\",cmd:\"mceSearch\"});a.addButton(\"replace\",{title:\"searchreplace.replace_desc\",cmd:\"mceReplace\"});a.addShortcut(\"ctrl+f\",\"searchreplace.search_desc\",\"mceSearch\")},getInfo:function(){return{longname:\"Search/Replace\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/searchreplace\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"searchreplace\",tinymce.plugins.SearchReplacePlugin)})();","Magento_Tinymce3/tiny_mce/plugins/searchreplace/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.SearchReplacePlugin', {\n\t\tinit : function(ed, url) {\n\t\t\tfunction open(m) {\n\t\t\t\t// Keep IE from writing out the f/r character to the editor\n\t\t\t\t// instance while initializing a new dialog. See: #3131190\n\t\t\t\twindow.focus();\n\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/searchreplace.htm',\n\t\t\t\t\twidth : 420 + parseInt(ed.getLang('searchreplace.delta_width', 0)),\n\t\t\t\t\theight : 170 + parseInt(ed.getLang('searchreplace.delta_height', 0)),\n\t\t\t\t\tinline : 1,\n\t\t\t\t\tauto_focus : 0\n\t\t\t\t}, {\n\t\t\t\t\tmode : m,\n\t\t\t\t\tsearch_string : ed.selection.getContent({format : 'text'}),\n\t\t\t\t\tplugin_url : url\n\t\t\t\t});\n\t\t\t};\n\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceSearch', function() {\n\t\t\t\topen('search');\n\t\t\t});\n\n\t\t\ted.addCommand('mceReplace', function() {\n\t\t\t\topen('replace');\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('search', {title : 'searchreplace.search_desc', cmd : 'mceSearch'});\n\t\t\ted.addButton('replace', {title : 'searchreplace.replace_desc', cmd : 'mceReplace'});\n\n\t\t\ted.addShortcut('ctrl+f', 'searchreplace.search_desc', 'mceSearch');\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Search/Replace',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/searchreplace',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('searchreplace', tinymce.plugins.SearchReplacePlugin);\n})();","Magento_Tinymce3/tiny_mce/plugins/searchreplace/js/searchreplace.js":"tinyMCEPopup.requireLangPack();\n\nvar SearchReplaceDialog = {\n\tinit : function(ed) {\n\t\tvar t = this, f = document.forms[0], m = tinyMCEPopup.getWindowArg(\"mode\");\n\n\t\tt.switchMode(m);\n\n\t\tf[m + '_panel_searchstring'].value = tinyMCEPopup.getWindowArg(\"search_string\");\n\n\t\t// Focus input field\n\t\tf[m + '_panel_searchstring'].focus();\n\t\t\n\t\tmcTabs.onChange.add(function(tab_id, panel_id) {\n\t\t\tt.switchMode(tab_id.substring(0, tab_id.indexOf('_')));\n\t\t});\n\t},\n\n\tswitchMode : function(m) {\n\t\tvar f, lm = this.lastMode;\n\n\t\tif (lm != m) {\n\t\t\tf = document.forms[0];\n\n\t\t\tif (lm) {\n\t\t\t\tf[m + '_panel_searchstring'].value = f[lm + '_panel_searchstring'].value;\n\t\t\t\tf[m + '_panel_backwardsu'].checked = f[lm + '_panel_backwardsu'].checked;\n\t\t\t\tf[m + '_panel_backwardsd'].checked = f[lm + '_panel_backwardsd'].checked;\n\t\t\t\tf[m + '_panel_casesensitivebox'].checked = f[lm + '_panel_casesensitivebox'].checked;\n\t\t\t}\n\n\t\t\tmcTabs.displayTab(m + '_tab',  m + '_panel');\n\t\t\tdocument.getElementById(\"replaceBtn\").style.display = (m == \"replace\") ? \"inline\" : \"none\";\n\t\t\tdocument.getElementById(\"replaceAllBtn\").style.display = (m == \"replace\") ? \"inline\" : \"none\";\n\t\t\tthis.lastMode = m;\n\t\t}\n\t},\n\n\tsearchNext : function(a) {\n\t\tvar ed = tinyMCEPopup.editor, se = ed.selection, r = se.getRng(), f, m = this.lastMode, s, b, fl = 0, w = ed.getWin(), wm = ed.windowManager, fo = 0;\n\n\t\t// Get input\n\t\tf = document.forms[0];\n\t\ts = f[m + '_panel_searchstring'].value;\n\t\tb = f[m + '_panel_backwardsu'].checked;\n\t\tca = f[m + '_panel_casesensitivebox'].checked;\n\t\trs = f['replace_panel_replacestring'].value;\n\n\t\tif (tinymce.isIE) {\n\t\t\tr = ed.getDoc().selection.createRange();\n\t\t}\n\n\t\tif (s == '')\n\t\t\treturn;\n\n\t\tfunction fix() {\n\t\t\t// Correct Firefox graphics glitches\n\t\t\t// TODO: Verify if this is actually needed any more, maybe it was for very old FF versions? \n\t\t\tr = se.getRng().cloneRange();\n\t\t\ted.getDoc().execCommand('SelectAll', false, null);\n\t\t\tse.setRng(r);\n\t\t};\n\n\t\tfunction replace() {\n\t\t\ted.selection.setContent(rs); // Needs to be duplicated due to selection bug in IE\n\t\t};\n\n\t\t// IE flags\n\t\tif (ca)\n\t\t\tfl = fl | 4;\n\n\t\tswitch (a) {\n\t\t\tcase 'all':\n\t\t\t\t// Move caret to beginning of text\n\t\t\t\ted.execCommand('SelectAll');\n\t\t\t\ted.selection.collapse(true);\n\n\t\t\t\tif (tinymce.isIE) {\n\t\t\t\t\ted.focus();\n\t\t\t\t\tr = ed.getDoc().selection.createRange();\n\n\t\t\t\t\twhile (r.findText(s, b ? -1 : 1, fl)) {\n\t\t\t\t\t\tr.scrollIntoView();\n\t\t\t\t\t\tr.select();\n\t\t\t\t\t\treplace();\n\t\t\t\t\t\tfo = 1;\n\n\t\t\t\t\t\tif (b) {\n\t\t\t\t\t\t\tr.moveEnd(\"character\", -(rs.length)); // Otherwise will loop forever\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\ttinyMCEPopup.storeSelection();\n\t\t\t\t} else {\n\t\t\t\t\twhile (w.find(s, ca, b, false, false, false, false)) {\n\t\t\t\t\t\treplace();\n\t\t\t\t\t\tfo = 1;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (fo)\n\t\t\t\t\ttinyMCEPopup.alert(ed.getLang('searchreplace_dlg.allreplaced'));\n\t\t\t\telse\n\t\t\t\t\ttinyMCEPopup.alert(ed.getLang('searchreplace_dlg.notfound'));\n\n\t\t\t\treturn;\n\n\t\t\tcase 'current':\n\t\t\t\tif (!ed.selection.isCollapsed())\n\t\t\t\t\treplace();\n\n\t\t\t\tbreak;\n\t\t}\n\n\t\tse.collapse(b);\n\t\tr = se.getRng();\n\n\t\t// Whats the point\n\t\tif (!s)\n\t\t\treturn;\n\n\t\tif (tinymce.isIE) {\n\t\t\ted.focus();\n\t\t\tr = ed.getDoc().selection.createRange();\n\n\t\t\tif (r.findText(s, b ? -1 : 1, fl)) {\n\t\t\t\tr.scrollIntoView();\n\t\t\t\tr.select();\n\t\t\t} else\n\t\t\t\ttinyMCEPopup.alert(ed.getLang('searchreplace_dlg.notfound'));\n\n\t\t\ttinyMCEPopup.storeSelection();\n\t\t} else {\n\t\t\tif (!w.find(s, ca, b, false, false, false, false))\n\t\t\t\ttinyMCEPopup.alert(ed.getLang('searchreplace_dlg.notfound'));\n\t\t\telse\n\t\t\t\tfix();\n\t\t}\n\t}\n};\n\ntinyMCEPopup.onInit.add(SearchReplaceDialog.init, SearchReplaceDialog);\n","Magento_Tinymce3/tiny_mce/plugins/searchreplace/langs/en_dlg.js":"tinyMCE.addI18n('en.searchreplace_dlg',{findwhat:\"Find What\",replacewith:\"Replace with\",direction:\"Direction\",up:\"Up\",down:\"Down\",mcase:\"Match Case\",findnext:\"Find Next\",allreplaced:\"All occurrences of the search string were replaced.\",\"searchnext_desc\":\"Find Again\",notfound:\"The search has been completed. The search string could not be found.\",\"search_title\":\"Find\",\"replace_title\":\"Find/Replace\",replaceall:\"Replace All\",replace:\"Replace\"});","Magento_Tinymce3/tiny_mce/plugins/advlist/editor_plugin.js":"(function(){var a=tinymce.each;tinymce.create(\"tinymce.plugins.AdvListPlugin\",{init:function(b,c){var d=this;d.editor=b;function e(g){var f=[];a(g.split(/,/),function(h){f.push({title:\"advlist.\"+(h==\"default\"?\"def\":h.replace(/-/g,\"_\")),styles:{listStyleType:h==\"default\"?\"\":h}})});return f}d.numlist=b.getParam(\"advlist_number_styles\")||e(\"default,lower-alpha,lower-greek,lower-roman,upper-alpha,upper-roman\");d.bullist=b.getParam(\"advlist_bullet_styles\")||e(\"default,circle,disc,square\");if(tinymce.isIE&&/MSIE [2-7]/.test(navigator.userAgent)){d.isIE7=true}},createControl:function(d,b){var f=this,e,i,g=f.editor;if(d==\"numlist\"||d==\"bullist\"){if(f[d][0].title==\"advlist.def\"){i=f[d][0]}function c(j,l){var k=true;a(l.styles,function(n,m){if(g.dom.getStyle(j,m)!=n){k=false;return false}});return k}function h(){var k,l=g.dom,j=g.selection;k=l.getParent(j.getNode(),\"ol,ul\");if(!k||k.nodeName==(d==\"bullist\"?\"OL\":\"UL\")||c(k,i)){g.execCommand(d==\"bullist\"?\"InsertUnorderedList\":\"InsertOrderedList\")}if(i){k=l.getParent(j.getNode(),\"ol,ul\");if(k){l.setStyles(k,i.styles);k.removeAttribute(\"data-mce-style\")}}g.focus()}e=b.createSplitButton(d,{title:\"advanced.\"+d+\"_desc\",\"class\":\"mce_\"+d,onclick:function(){h()}});e.onRenderMenu.add(function(j,k){k.onHideMenu.add(function(){if(f.bookmark){g.selection.moveToBookmark(f.bookmark);f.bookmark=0}});k.onShowMenu.add(function(){var n=g.dom,m=n.getParent(g.selection.getNode(),\"ol,ul\"),l;if(m||i){l=f[d];a(k.items,function(o){var p=true;o.setSelected(0);if(m&&!o.isDisabled()){a(l,function(q){if(q.id==o.id){if(!c(m,q)){p=false;return false}}});if(p){o.setSelected(1)}}});if(!m){k.items[i.id].setSelected(1)}}g.focus();if(tinymce.isIE){f.bookmark=g.selection.getBookmark(1)}});k.add({id:g.dom.uniqueId(),title:\"advlist.types\",\"class\":\"mceMenuItemTitle\",titleItem:true}).setDisabled(1);a(f[d],function(l){if(f.isIE7&&l.styles.listStyleType==\"lower-greek\"){return}l.id=g.dom.uniqueId();k.add({id:l.id,title:l.title,onclick:function(){i=l;h()}})})});return e}},getInfo:function(){return{longname:\"Advanced lists\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/advlist\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"advlist\",tinymce.plugins.AdvListPlugin)})();","Magento_Tinymce3/tiny_mce/plugins/advlist/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\tvar each = tinymce.each;\n\n\ttinymce.create('tinymce.plugins.AdvListPlugin', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this;\n\n\t\t\tt.editor = ed;\n\n\t\t\tfunction buildFormats(str) {\n\t\t\t\tvar formats = [];\n\n\t\t\t\teach(str.split(/,/), function(type) {\n\t\t\t\t\tformats.push({\n\t\t\t\t\t\ttitle : 'advlist.' + (type == 'default' ? 'def' : type.replace(/-/g, '_')),\n\t\t\t\t\t\tstyles : {\n\t\t\t\t\t\t\tlistStyleType : type == 'default' ? '' : type\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t});\n\n\t\t\t\treturn formats;\n\t\t\t};\n\n\t\t\t// Setup number formats from config or default\n\t\t\tt.numlist = ed.getParam(\"advlist_number_styles\") || buildFormats(\"default,lower-alpha,lower-greek,lower-roman,upper-alpha,upper-roman\");\n\t\t\tt.bullist = ed.getParam(\"advlist_bullet_styles\") || buildFormats(\"default,circle,disc,square\");\n\n\t\t\tif (tinymce.isIE && /MSIE [2-7]/.test(navigator.userAgent))\n\t\t\t\tt.isIE7 = true;\n\t\t},\n\n\t\tcreateControl: function(name, cm) {\n\t\t\tvar t = this, btn, format, editor = t.editor;\n\n\t\t\tif (name == 'numlist' || name == 'bullist') {\n\t\t\t\t// Default to first item if it's a default item\n\t\t\t\tif (t[name][0].title == 'advlist.def')\n\t\t\t\t\tformat = t[name][0];\n\n\t\t\t\tfunction hasFormat(node, format) {\n\t\t\t\t\tvar state = true;\n\n\t\t\t\t\teach(format.styles, function(value, name) {\n\t\t\t\t\t\t// Format doesn't match\n\t\t\t\t\t\tif (editor.dom.getStyle(node, name) != value) {\n\t\t\t\t\t\t\tstate = false;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\n\t\t\t\t\treturn state;\n\t\t\t\t};\n\n\t\t\t\tfunction applyListFormat() {\n\t\t\t\t\tvar list, dom = editor.dom, sel = editor.selection;\n\n\t\t\t\t\t// Check for existing list element\n\t\t\t\t\tlist = dom.getParent(sel.getNode(), 'ol,ul');\n\n\t\t\t\t\t// Switch/add list type if needed\n\t\t\t\t\tif (!list || list.nodeName == (name == 'bullist' ? 'OL' : 'UL') || hasFormat(list, format))\n\t\t\t\t\t\teditor.execCommand(name == 'bullist' ? 'InsertUnorderedList' : 'InsertOrderedList');\n\n\t\t\t\t\t// Append styles to new list element\n\t\t\t\t\tif (format) {\n\t\t\t\t\t\tlist = dom.getParent(sel.getNode(), 'ol,ul');\n\t\t\t\t\t\tif (list) {\n\t\t\t\t\t\t\tdom.setStyles(list, format.styles);\n\t\t\t\t\t\t\tlist.removeAttribute('data-mce-style');\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\teditor.focus();\n\t\t\t\t};\n\n\t\t\t\tbtn = cm.createSplitButton(name, {\n\t\t\t\t\ttitle : 'advanced.' + name + '_desc',\n\t\t\t\t\t'class' : 'mce_' + name,\n\t\t\t\t\tonclick : function() {\n\t\t\t\t\t\tapplyListFormat();\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tbtn.onRenderMenu.add(function(btn, menu) {\n\t\t\t\t\tmenu.onHideMenu.add(function() {\n\t\t\t\t\t\tif (t.bookmark) {\n\t\t\t\t\t\t\teditor.selection.moveToBookmark(t.bookmark);\n\t\t\t\t\t\t\tt.bookmark = 0;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\n\t\t\t\t\tmenu.onShowMenu.add(function() {\n\t\t\t\t\t\tvar dom = editor.dom, list = dom.getParent(editor.selection.getNode(), 'ol,ul'), fmtList;\n\n\t\t\t\t\t\tif (list || format) {\n\t\t\t\t\t\t\tfmtList = t[name];\n\n\t\t\t\t\t\t\t// Unselect existing items\n\t\t\t\t\t\t\teach(menu.items, function(item) {\n\t\t\t\t\t\t\t\tvar state = true;\n\n\t\t\t\t\t\t\t\titem.setSelected(0);\n\n\t\t\t\t\t\t\t\tif (list && !item.isDisabled()) {\n\t\t\t\t\t\t\t\t\teach(fmtList, function(fmt) {\n\t\t\t\t\t\t\t\t\t\tif (fmt.id == item.id) {\n\t\t\t\t\t\t\t\t\t\t\tif (!hasFormat(list, fmt)) {\n\t\t\t\t\t\t\t\t\t\t\t\tstate = false;\n\t\t\t\t\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\t\tif (state)\n\t\t\t\t\t\t\t\t\t\titem.setSelected(1);\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t// Select the current format\n\t\t\t\t\t\t\tif (!list)\n\t\t\t\t\t\t\t\tmenu.items[format.id].setSelected(1);\n\t\t\t\t\t\t}\n\t\n\t\t\t\t\t\teditor.focus();\n\n\t\t\t\t\t\t// IE looses it's selection so store it away and restore it later\n\t\t\t\t\t\tif (tinymce.isIE) {\n\t\t\t\t\t\t\tt.bookmark = editor.selection.getBookmark(1);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\n\t\t\t\t\tmenu.add({id : editor.dom.uniqueId(), title : 'advlist.types', 'class' : 'mceMenuItemTitle', titleItem: true}).setDisabled(1);\n\n\t\t\t\t\teach(t[name], function(item) {\n\t\t\t\t\t\t// IE<8 doesn't support lower-greek, skip it\n\t\t\t\t\t\tif (t.isIE7 && item.styles.listStyleType == 'lower-greek')\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\titem.id = editor.dom.uniqueId();\n\n\t\t\t\t\t\tmenu.add({id : item.id, title : item.title, onclick : function() {\n\t\t\t\t\t\t\tformat = item;\n\t\t\t\t\t\t\tapplyListFormat();\n\t\t\t\t\t\t}});\n\t\t\t\t\t});\n\t\t\t\t});\n\n\t\t\t\treturn btn;\n\t\t\t}\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Advanced lists',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/advlist',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('advlist', tinymce.plugins.AdvListPlugin);\n})();","Magento_Tinymce3/tiny_mce/plugins/style/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.StylePlugin\",{init:function(a,b){a.addCommand(\"mceStyleProps\",function(){a.windowManager.open({file:b+\"/props.htm\",width:480+parseInt(a.getLang(\"style.delta_width\",0)),height:320+parseInt(a.getLang(\"style.delta_height\",0)),inline:1},{plugin_url:b,style_text:a.selection.getNode().style.cssText})});a.addCommand(\"mceSetElementStyle\",function(d,c){if(e=a.selection.getNode()){a.dom.setAttrib(e,\"style\",c);a.execCommand(\"mceRepaint\")}});a.onNodeChange.add(function(d,c,f){c.setDisabled(\"styleprops\",f.nodeName===\"BODY\")});a.addButton(\"styleprops\",{title:\"style.desc\",cmd:\"mceStyleProps\"})},getInfo:function(){return{longname:\"Style\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/style\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}}});tinymce.PluginManager.add(\"style\",tinymce.plugins.StylePlugin)})();","Magento_Tinymce3/tiny_mce/plugins/style/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.StylePlugin', {\n\t\tinit : function(ed, url) {\n\t\t\t// Register commands\n\t\t\ted.addCommand('mceStyleProps', function() {\n\t\t\t\ted.windowManager.open({\n\t\t\t\t\tfile : url + '/props.htm',\n\t\t\t\t\twidth : 480 + parseInt(ed.getLang('style.delta_width', 0)),\n\t\t\t\t\theight : 320 + parseInt(ed.getLang('style.delta_height', 0)),\n\t\t\t\t\tinline : 1\n\t\t\t\t}, {\n\t\t\t\t\tplugin_url : url,\n\t\t\t\t\tstyle_text : ed.selection.getNode().style.cssText\n\t\t\t\t});\n\t\t\t});\n\n\t\t\ted.addCommand('mceSetElementStyle', function(ui, v) {\n\t\t\t\tif (e = ed.selection.getNode()) {\n\t\t\t\t\ted.dom.setAttrib(e, 'style', v);\n\t\t\t\t\ted.execCommand('mceRepaint');\n\t\t\t\t}\n\t\t\t});\n\n\t\t\ted.onNodeChange.add(function(ed, cm, n) {\n\t\t\t\tcm.setDisabled('styleprops', n.nodeName === 'BODY');\n\t\t\t});\n\n\t\t\t// Register buttons\n\t\t\ted.addButton('styleprops', {title : 'style.desc', cmd : 'mceStyleProps'});\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Style',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/style',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('style', tinymce.plugins.StylePlugin);\n})();","Magento_Tinymce3/tiny_mce/plugins/style/js/props.js":"tinyMCEPopup.requireLangPack();\n\nvar defaultFonts = \"\" + \n\t\"Arial, Helvetica, sans-serif=Arial, Helvetica, sans-serif;\" + \n\t\"Times New Roman, Times, serif=Times New Roman, Times, serif;\" + \n\t\"Courier New, Courier, mono=Courier New, Courier, mono;\" + \n\t\"Times New Roman, Times, serif=Times New Roman, Times, serif;\" + \n\t\"Georgia, Times New Roman, Times, serif=Georgia, Times New Roman, Times, serif;\" + \n\t\"Verdana, Arial, Helvetica, sans-serif=Verdana, Arial, Helvetica, sans-serif;\" + \n\t\"Geneva, Arial, Helvetica, sans-serif=Geneva, Arial, Helvetica, sans-serif\";\n\nvar defaultSizes = \"9;10;12;14;16;18;24;xx-small;x-small;small;medium;large;x-large;xx-large;smaller;larger\";\nvar defaultMeasurement = \"+pixels=px;points=pt;inches=in;centimetres=cm;millimetres=mm;picas=pc;ems=em;exs=ex;%\";\nvar defaultSpacingMeasurement = \"pixels=px;points=pt;inches=in;centimetres=cm;millimetres=mm;picas=pc;+ems=em;exs=ex;%\";\nvar defaultIndentMeasurement = \"pixels=px;+points=pt;inches=in;centimetres=cm;millimetres=mm;picas=pc;ems=em;exs=ex;%\";\nvar defaultWeight = \"normal;bold;bolder;lighter;100;200;300;400;500;600;700;800;900\";\nvar defaultTextStyle = \"normal;italic;oblique\";\nvar defaultVariant = \"normal;small-caps\";\nvar defaultLineHeight = \"normal\";\nvar defaultAttachment = \"fixed;scroll\";\nvar defaultRepeat = \"no-repeat;repeat;repeat-x;repeat-y\";\nvar defaultPosH = \"left;center;right\";\nvar defaultPosV = \"top;center;bottom\";\nvar defaultVAlign = \"baseline;sub;super;top;text-top;middle;bottom;text-bottom\";\nvar defaultDisplay = \"inline;block;list-item;run-in;compact;marker;table;inline-table;table-row-group;table-header-group;table-footer-group;table-row;table-column-group;table-column;table-cell;table-caption;none\";\nvar defaultBorderStyle = \"none;solid;dashed;dotted;double;groove;ridge;inset;outset\";\nvar defaultBorderWidth = \"thin;medium;thick\";\nvar defaultListType = \"disc;circle;square;decimal;lower-roman;upper-roman;lower-alpha;upper-alpha;none\";\n\nfunction init() {\n\tvar ce = document.getElementById('container'), h;\n\n\tce.style.cssText = tinyMCEPopup.getWindowArg('style_text');\n\n\th = getBrowserHTML('background_image_browser','background_image','image','advimage');\n\tdocument.getElementById(\"background_image_browser\").innerHTML = h;\n\n\tdocument.getElementById('text_color_pickcontainer').innerHTML = getColorPickerHTML('text_color_pick','text_color');\n\tdocument.getElementById('background_color_pickcontainer').innerHTML = getColorPickerHTML('background_color_pick','background_color');\n\tdocument.getElementById('border_color_top_pickcontainer').innerHTML = getColorPickerHTML('border_color_top_pick','border_color_top');\n\tdocument.getElementById('border_color_right_pickcontainer').innerHTML = getColorPickerHTML('border_color_right_pick','border_color_right');\n\tdocument.getElementById('border_color_bottom_pickcontainer').innerHTML = getColorPickerHTML('border_color_bottom_pick','border_color_bottom');\n\tdocument.getElementById('border_color_left_pickcontainer').innerHTML = getColorPickerHTML('border_color_left_pick','border_color_left');\n\n\tfillSelect(0, 'text_font', 'style_font', defaultFonts, ';', true);\n\tfillSelect(0, 'text_size', 'style_font_size', defaultSizes, ';', true);\n\tfillSelect(0, 'text_size_measurement', 'style_font_size_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'text_case', 'style_text_case', \"capitalize;uppercase;lowercase\", ';', true);\n\tfillSelect(0, 'text_weight', 'style_font_weight', defaultWeight, ';', true);\n\tfillSelect(0, 'text_style', 'style_font_style', defaultTextStyle, ';', true);\n\tfillSelect(0, 'text_variant', 'style_font_variant', defaultVariant, ';', true);\n\tfillSelect(0, 'text_lineheight', 'style_font_line_height', defaultLineHeight, ';', true);\n\tfillSelect(0, 'text_lineheight_measurement', 'style_font_line_height_measurement', defaultMeasurement, ';', true);\n\n\tfillSelect(0, 'background_attachment', 'style_background_attachment', defaultAttachment, ';', true);\n\tfillSelect(0, 'background_repeat', 'style_background_repeat', defaultRepeat, ';', true);\n\n\tfillSelect(0, 'background_hpos_measurement', 'style_background_hpos_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'background_vpos_measurement', 'style_background_vpos_measurement', defaultMeasurement, ';', true);\n\n\tfillSelect(0, 'background_hpos', 'style_background_hpos', defaultPosH, ';', true);\n\tfillSelect(0, 'background_vpos', 'style_background_vpos', defaultPosV, ';', true);\n\n\tfillSelect(0, 'block_wordspacing', 'style_wordspacing', 'normal', ';', true);\n\tfillSelect(0, 'block_wordspacing_measurement', 'style_wordspacing_measurement', defaultSpacingMeasurement, ';', true);\n\tfillSelect(0, 'block_letterspacing', 'style_letterspacing', 'normal', ';', true);\n\tfillSelect(0, 'block_letterspacing_measurement', 'style_letterspacing_measurement', defaultSpacingMeasurement, ';', true);\n\tfillSelect(0, 'block_vertical_alignment', 'style_vertical_alignment', defaultVAlign, ';', true);\n\tfillSelect(0, 'block_text_align', 'style_text_align', \"left;right;center;justify\", ';', true);\n\tfillSelect(0, 'block_whitespace', 'style_whitespace', \"normal;pre;nowrap\", ';', true);\n\tfillSelect(0, 'block_display', 'style_display', defaultDisplay, ';', true);\n\tfillSelect(0, 'block_text_indent_measurement', 'style_text_indent_measurement', defaultIndentMeasurement, ';', true);\n\n\tfillSelect(0, 'box_width_measurement', 'style_box_width_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'box_height_measurement', 'style_box_height_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'box_float', 'style_float', 'left;right;none', ';', true);\n\tfillSelect(0, 'box_clear', 'style_clear', 'left;right;both;none', ';', true);\n\tfillSelect(0, 'box_padding_left_measurement', 'style_padding_left_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'box_padding_top_measurement', 'style_padding_top_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'box_padding_bottom_measurement', 'style_padding_bottom_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'box_padding_right_measurement', 'style_padding_right_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'box_margin_left_measurement', 'style_margin_left_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'box_margin_top_measurement', 'style_margin_top_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'box_margin_bottom_measurement', 'style_margin_bottom_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'box_margin_right_measurement', 'style_margin_right_measurement', defaultMeasurement, ';', true);\n\n\tfillSelect(0, 'border_style_top', 'style_border_style_top', defaultBorderStyle, ';', true);\n\tfillSelect(0, 'border_style_right', 'style_border_style_right', defaultBorderStyle, ';', true);\n\tfillSelect(0, 'border_style_bottom', 'style_border_style_bottom', defaultBorderStyle, ';', true);\n\tfillSelect(0, 'border_style_left', 'style_border_style_left', defaultBorderStyle, ';', true);\n\n\tfillSelect(0, 'border_width_top', 'style_border_width_top', defaultBorderWidth, ';', true);\n\tfillSelect(0, 'border_width_right', 'style_border_width_right', defaultBorderWidth, ';', true);\n\tfillSelect(0, 'border_width_bottom', 'style_border_width_bottom', defaultBorderWidth, ';', true);\n\tfillSelect(0, 'border_width_left', 'style_border_width_left', defaultBorderWidth, ';', true);\n\n\tfillSelect(0, 'border_width_top_measurement', 'style_border_width_top_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'border_width_right_measurement', 'style_border_width_right_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'border_width_bottom_measurement', 'style_border_width_bottom_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'border_width_left_measurement', 'style_border_width_left_measurement', defaultMeasurement, ';', true);\n\n\tfillSelect(0, 'list_type', 'style_list_type', defaultListType, ';', true);\n\tfillSelect(0, 'list_position', 'style_list_position', \"inside;outside\", ';', true);\n\n\tfillSelect(0, 'positioning_type', 'style_positioning_type', \"absolute;relative;static\", ';', true);\n\tfillSelect(0, 'positioning_visibility', 'style_positioning_visibility', \"inherit;visible;hidden\", ';', true);\n\n\tfillSelect(0, 'positioning_width_measurement', 'style_positioning_width_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'positioning_height_measurement', 'style_positioning_height_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'positioning_overflow', 'style_positioning_overflow', \"visible;hidden;scroll;auto\", ';', true);\n\n\tfillSelect(0, 'positioning_placement_top_measurement', 'style_positioning_placement_top_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'positioning_placement_right_measurement', 'style_positioning_placement_right_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'positioning_placement_bottom_measurement', 'style_positioning_placement_bottom_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'positioning_placement_left_measurement', 'style_positioning_placement_left_measurement', defaultMeasurement, ';', true);\n\n\tfillSelect(0, 'positioning_clip_top_measurement', 'style_positioning_clip_top_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'positioning_clip_right_measurement', 'style_positioning_clip_right_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'positioning_clip_bottom_measurement', 'style_positioning_clip_bottom_measurement', defaultMeasurement, ';', true);\n\tfillSelect(0, 'positioning_clip_left_measurement', 'style_positioning_clip_left_measurement', defaultMeasurement, ';', true);\n\n\tTinyMCE_EditableSelects.init();\n\tsetupFormData();\n\tshowDisabledControls();\n}\n\nfunction setupFormData() {\n\tvar ce = document.getElementById('container'), f = document.forms[0], s, b, i;\n\n\t// Setup text fields\n\n\tselectByValue(f, 'text_font', ce.style.fontFamily, true, true);\n\tselectByValue(f, 'text_size', getNum(ce.style.fontSize), true, true);\n\tselectByValue(f, 'text_size_measurement', getMeasurement(ce.style.fontSize));\n\tselectByValue(f, 'text_weight', ce.style.fontWeight, true, true);\n\tselectByValue(f, 'text_style', ce.style.fontStyle, true, true);\n\tselectByValue(f, 'text_lineheight', getNum(ce.style.lineHeight), true, true);\n\tselectByValue(f, 'text_lineheight_measurement', getMeasurement(ce.style.lineHeight));\n\tselectByValue(f, 'text_case', ce.style.textTransform, true, true);\n\tselectByValue(f, 'text_variant', ce.style.fontVariant, true, true);\n\tf.text_color.value = tinyMCEPopup.editor.dom.toHex(ce.style.color);\n\tupdateColor('text_color_pick', 'text_color');\n\tf.text_underline.checked = inStr(ce.style.textDecoration, 'underline');\n\tf.text_overline.checked = inStr(ce.style.textDecoration, 'overline');\n\tf.text_linethrough.checked = inStr(ce.style.textDecoration, 'line-through');\n\tf.text_blink.checked = inStr(ce.style.textDecoration, 'blink');\n\n\t// Setup background fields\n\n\tf.background_color.value = tinyMCEPopup.editor.dom.toHex(ce.style.backgroundColor);\n\tupdateColor('background_color_pick', 'background_color');\n\tf.background_image.value = ce.style.backgroundImage.replace(new RegExp(\"url\\\\('?([^']*)'?\\\\)\", 'gi'), \"$1\");\n\tselectByValue(f, 'background_repeat', ce.style.backgroundRepeat, true, true);\n\tselectByValue(f, 'background_attachment', ce.style.backgroundAttachment, true, true);\n\tselectByValue(f, 'background_hpos', getNum(getVal(ce.style.backgroundPosition, 0)), true, true);\n\tselectByValue(f, 'background_hpos_measurement', getMeasurement(getVal(ce.style.backgroundPosition, 0)));\n\tselectByValue(f, 'background_vpos', getNum(getVal(ce.style.backgroundPosition, 1)), true, true);\n\tselectByValue(f, 'background_vpos_measurement', getMeasurement(getVal(ce.style.backgroundPosition, 1)));\n\n\t// Setup block fields\n\n\tselectByValue(f, 'block_wordspacing', getNum(ce.style.wordSpacing), true, true);\n\tselectByValue(f, 'block_wordspacing_measurement', getMeasurement(ce.style.wordSpacing));\n\tselectByValue(f, 'block_letterspacing', getNum(ce.style.letterSpacing), true, true);\n\tselectByValue(f, 'block_letterspacing_measurement', getMeasurement(ce.style.letterSpacing));\n\tselectByValue(f, 'block_vertical_alignment', ce.style.verticalAlign, true, true);\n\tselectByValue(f, 'block_text_align', ce.style.textAlign, true, true);\n\tf.block_text_indent.value = getNum(ce.style.textIndent);\n\tselectByValue(f, 'block_text_indent_measurement', getMeasurement(ce.style.textIndent));\n\tselectByValue(f, 'block_whitespace', ce.style.whiteSpace, true, true);\n\tselectByValue(f, 'block_display', ce.style.display, true, true);\n\n\t// Setup box fields\n\n\tf.box_width.value = getNum(ce.style.width);\n\tselectByValue(f, 'box_width_measurement', getMeasurement(ce.style.width));\n\n\tf.box_height.value = getNum(ce.style.height);\n\tselectByValue(f, 'box_height_measurement', getMeasurement(ce.style.height));\n\tselectByValue(f, 'box_float', ce.style.cssFloat || ce.style.styleFloat, true, true);\n\n\tselectByValue(f, 'box_clear', ce.style.clear, true, true);\n\n\tsetupBox(f, ce, 'box_padding', 'padding', '');\n\tsetupBox(f, ce, 'box_margin', 'margin', '');\n\n\t// Setup border fields\n\n\tsetupBox(f, ce, 'border_style', 'border', 'Style');\n\tsetupBox(f, ce, 'border_width', 'border', 'Width');\n\tsetupBox(f, ce, 'border_color', 'border', 'Color');\n\n\tupdateColor('border_color_top_pick', 'border_color_top');\n\tupdateColor('border_color_right_pick', 'border_color_right');\n\tupdateColor('border_color_bottom_pick', 'border_color_bottom');\n\tupdateColor('border_color_left_pick', 'border_color_left');\n\n\tf.elements.border_color_top.value = tinyMCEPopup.editor.dom.toHex(f.elements.border_color_top.value);\n\tf.elements.border_color_right.value = tinyMCEPopup.editor.dom.toHex(f.elements.border_color_right.value);\n\tf.elements.border_color_bottom.value = tinyMCEPopup.editor.dom.toHex(f.elements.border_color_bottom.value);\n\tf.elements.border_color_left.value = tinyMCEPopup.editor.dom.toHex(f.elements.border_color_left.value);\n\n\t// Setup list fields\n\n\tselectByValue(f, 'list_type', ce.style.listStyleType, true, true);\n\tselectByValue(f, 'list_position', ce.style.listStylePosition, true, true);\n\tf.list_bullet_image.value = ce.style.listStyleImage.replace(new RegExp(\"url\\\\('?([^']*)'?\\\\)\", 'gi'), \"$1\");\n\n\t// Setup box fields\n\n\tselectByValue(f, 'positioning_type', ce.style.position, true, true);\n\tselectByValue(f, 'positioning_visibility', ce.style.visibility, true, true);\n\tselectByValue(f, 'positioning_overflow', ce.style.overflow, true, true);\n\tf.positioning_zindex.value = ce.style.zIndex ? ce.style.zIndex : \"\";\n\n\tf.positioning_width.value = getNum(ce.style.width);\n\tselectByValue(f, 'positioning_width_measurement', getMeasurement(ce.style.width));\n\n\tf.positioning_height.value = getNum(ce.style.height);\n\tselectByValue(f, 'positioning_height_measurement', getMeasurement(ce.style.height));\n\n\tsetupBox(f, ce, 'positioning_placement', '', '', ['top', 'right', 'bottom', 'left']);\n\n\ts = ce.style.clip.replace(new RegExp(\"rect\\\\('?([^']*)'?\\\\)\", 'gi'), \"$1\");\n\ts = s.replace(/,/g, ' ');\n\n\tif (!hasEqualValues([getVal(s, 0), getVal(s, 1), getVal(s, 2), getVal(s, 3)])) {\n\t\tf.positioning_clip_top.value = getNum(getVal(s, 0));\n\t\tselectByValue(f, 'positioning_clip_top_measurement', getMeasurement(getVal(s, 0)));\n\t\tf.positioning_clip_right.value = getNum(getVal(s, 1));\n\t\tselectByValue(f, 'positioning_clip_right_measurement', getMeasurement(getVal(s, 1)));\n\t\tf.positioning_clip_bottom.value = getNum(getVal(s, 2));\n\t\tselectByValue(f, 'positioning_clip_bottom_measurement', getMeasurement(getVal(s, 2)));\n\t\tf.positioning_clip_left.value = getNum(getVal(s, 3));\n\t\tselectByValue(f, 'positioning_clip_left_measurement', getMeasurement(getVal(s, 3)));\n\t} else {\n\t\tf.positioning_clip_top.value = getNum(getVal(s, 0));\n\t\tselectByValue(f, 'positioning_clip_top_measurement', getMeasurement(getVal(s, 0)));\n\t\tf.positioning_clip_right.value = f.positioning_clip_bottom.value = f.positioning_clip_left.value;\n\t}\n\n//\tsetupBox(f, ce, '', 'border', 'Color');\n}\n\nfunction getMeasurement(s) {\n\treturn s.replace(/^([0-9.]+)(.*)$/, \"$2\");\n}\n\nfunction getNum(s) {\n\tif (new RegExp('^(?:[0-9.]+)(?:[a-z%]+)$', 'gi').test(s))\n\t\treturn s.replace(/[^0-9.]/g, '');\n\n\treturn s;\n}\n\nfunction inStr(s, n) {\n\treturn new RegExp(n, 'gi').test(s);\n}\n\nfunction getVal(s, i) {\n\tvar a = s.split(' ');\n\n\tif (a.length > 1)\n\t\treturn a[i];\n\n\treturn \"\";\n}\n\nfunction setValue(f, n, v) {\n\tif (f.elements[n].type == \"text\")\n\t\tf.elements[n].value = v;\n\telse\n\t\tselectByValue(f, n, v, true, true);\n}\n\nfunction setupBox(f, ce, fp, pr, sf, b) {\n\tif (typeof(b) == \"undefined\")\n\t\tb = ['Top', 'Right', 'Bottom', 'Left'];\n\n\tif (isSame(ce, pr, sf, b)) {\n\t\tf.elements[fp + \"_same\"].checked = true;\n\n\t\tsetValue(f, fp + \"_top\", getNum(ce.style[pr + b[0] + sf]));\n\t\tf.elements[fp + \"_top\"].disabled = false;\n\n\t\tf.elements[fp + \"_right\"].value = \"\";\n\t\tf.elements[fp + \"_right\"].disabled = true;\n\t\tf.elements[fp + \"_bottom\"].value = \"\";\n\t\tf.elements[fp + \"_bottom\"].disabled = true;\n\t\tf.elements[fp + \"_left\"].value = \"\";\n\t\tf.elements[fp + \"_left\"].disabled = true;\n\n\t\tif (f.elements[fp + \"_top_measurement\"]) {\n\t\t\tselectByValue(f, fp + '_top_measurement', getMeasurement(ce.style[pr + b[0] + sf]));\n\t\t\tf.elements[fp + \"_left_measurement\"].disabled = true;\n\t\t\tf.elements[fp + \"_bottom_measurement\"].disabled = true;\n\t\t\tf.elements[fp + \"_right_measurement\"].disabled = true;\n\t\t}\n\t} else {\n\t\tf.elements[fp + \"_same\"].checked = false;\n\n\t\tsetValue(f, fp + \"_top\", getNum(ce.style[pr + b[0] + sf]));\n\t\tf.elements[fp + \"_top\"].disabled = false;\n\n\t\tsetValue(f, fp + \"_right\", getNum(ce.style[pr + b[1] + sf]));\n\t\tf.elements[fp + \"_right\"].disabled = false;\n\n\t\tsetValue(f, fp + \"_bottom\", getNum(ce.style[pr + b[2] + sf]));\n\t\tf.elements[fp + \"_bottom\"].disabled = false;\n\n\t\tsetValue(f, fp + \"_left\", getNum(ce.style[pr + b[3] + sf]));\n\t\tf.elements[fp + \"_left\"].disabled = false;\n\n\t\tif (f.elements[fp + \"_top_measurement\"]) {\n\t\t\tselectByValue(f, fp + '_top_measurement', getMeasurement(ce.style[pr + b[0] + sf]));\n\t\t\tselectByValue(f, fp + '_right_measurement', getMeasurement(ce.style[pr + b[1] + sf]));\n\t\t\tselectByValue(f, fp + '_bottom_measurement', getMeasurement(ce.style[pr + b[2] + sf]));\n\t\t\tselectByValue(f, fp + '_left_measurement', getMeasurement(ce.style[pr + b[3] + sf]));\n\t\t\tf.elements[fp + \"_left_measurement\"].disabled = false;\n\t\t\tf.elements[fp + \"_bottom_measurement\"].disabled = false;\n\t\t\tf.elements[fp + \"_right_measurement\"].disabled = false;\n\t\t}\n\t}\n}\n\nfunction isSame(e, pr, sf, b) {\n\tvar a = [], i, x;\n\n\tif (typeof(b) == \"undefined\")\n\t\tb = ['Top', 'Right', 'Bottom', 'Left'];\n\n\tif (typeof(sf) == \"undefined\" || sf == null)\n\t\tsf = \"\";\n\n\ta[0] = e.style[pr + b[0] + sf];\n\ta[1] = e.style[pr + b[1] + sf];\n\ta[2] = e.style[pr + b[2] + sf];\n\ta[3] = e.style[pr + b[3] + sf];\n\n\tfor (i=0; i<a.length; i++) {\n\t\tif (a[i] == null)\n\t\t\treturn false;\n\n\t\tfor (x=0; x<a.length; x++) {\n\t\t\tif (a[x] != a[i])\n\t\t\t\treturn false;\n\t\t}\n\t}\n\n\treturn true;\n};\n\nfunction hasEqualValues(a) {\n\tvar i, x;\n\n\tfor (i=0; i<a.length; i++) {\n\t\tif (a[i] == null)\n\t\t\treturn false;\n\n\t\tfor (x=0; x<a.length; x++) {\n\t\t\tif (a[x] != a[i])\n\t\t\t\treturn false;\n\t\t}\n\t}\n\n\treturn true;\n}\n\nfunction applyAction() {\n\tvar ce = document.getElementById('container'), ed = tinyMCEPopup.editor;\n\n\tgenerateCSS();\n\n\ttinyMCEPopup.restoreSelection();\n\ted.dom.setAttrib(ed.selection.getSelectedBlocks(), 'style', tinyMCEPopup.editor.dom.serializeStyle(tinyMCEPopup.editor.dom.parseStyle(ce.style.cssText)));\n}\n\nfunction updateAction() {\n\tapplyAction();\n\ttinyMCEPopup.close();\n}\n\nfunction generateCSS() {\n\tvar ce = document.getElementById('container'), f = document.forms[0], num = new RegExp('[0-9]+', 'g'), s, t;\n\n\tce.style.cssText = \"\";\n\n\t// Build text styles\n\tce.style.fontFamily = f.text_font.value;\n\tce.style.fontSize = f.text_size.value + (isNum(f.text_size.value) ? (f.text_size_measurement.value || 'px') : \"\");\n\tce.style.fontStyle = f.text_style.value;\n\tce.style.lineHeight = f.text_lineheight.value + (isNum(f.text_lineheight.value) ? f.text_lineheight_measurement.value : \"\");\n\tce.style.textTransform = f.text_case.value;\n\tce.style.fontWeight = f.text_weight.value;\n\tce.style.fontVariant = f.text_variant.value;\n\tce.style.color = f.text_color.value;\n\n\ts = \"\";\n\ts += f.text_underline.checked ? \" underline\" : \"\";\n\ts += f.text_overline.checked ? \" overline\" : \"\";\n\ts += f.text_linethrough.checked ? \" line-through\" : \"\";\n\ts += f.text_blink.checked ? \" blink\" : \"\";\n\ts = s.length > 0 ? s.substring(1) : s;\n\n\tif (f.text_none.checked)\n\t\ts = \"none\";\n\n\tce.style.textDecoration = s;\n\n\t// Build background styles\n\n\tce.style.backgroundColor = f.background_color.value;\n\tce.style.backgroundImage = f.background_image.value != \"\" ? \"url(\" + f.background_image.value + \")\" : \"\";\n\tce.style.backgroundRepeat = f.background_repeat.value;\n\tce.style.backgroundAttachment = f.background_attachment.value;\n\n\tif (f.background_hpos.value != \"\") {\n\t\ts = \"\";\n\t\ts += f.background_hpos.value + (isNum(f.background_hpos.value) ? f.background_hpos_measurement.value : \"\") + \" \";\n\t\ts += f.background_vpos.value + (isNum(f.background_vpos.value) ? f.background_vpos_measurement.value : \"\");\n\t\tce.style.backgroundPosition = s;\n\t}\n\n\t// Build block styles\n\n\tce.style.wordSpacing = f.block_wordspacing.value + (isNum(f.block_wordspacing.value) ? f.block_wordspacing_measurement.value : \"\");\n\tce.style.letterSpacing = f.block_letterspacing.value + (isNum(f.block_letterspacing.value) ? f.block_letterspacing_measurement.value : \"\");\n\tce.style.verticalAlign = f.block_vertical_alignment.value;\n\tce.style.textAlign = f.block_text_align.value;\n\tce.style.textIndent = f.block_text_indent.value + (isNum(f.block_text_indent.value) ? f.block_text_indent_measurement.value : \"\");\n\tce.style.whiteSpace = f.block_whitespace.value;\n\tce.style.display = f.block_display.value;\n\n\t// Build box styles\n\n\tce.style.width = f.box_width.value + (isNum(f.box_width.value) ? f.box_width_measurement.value : \"\");\n\tce.style.height = f.box_height.value + (isNum(f.box_height.value) ? f.box_height_measurement.value : \"\");\n\tce.style.styleFloat = f.box_float.value;\n\tce.style.cssFloat = f.box_float.value;\n\n\tce.style.clear = f.box_clear.value;\n\n\tif (!f.box_padding_same.checked) {\n\t\tce.style.paddingTop = f.box_padding_top.value + (isNum(f.box_padding_top.value) ? f.box_padding_top_measurement.value : \"\");\n\t\tce.style.paddingRight = f.box_padding_right.value + (isNum(f.box_padding_right.value) ? f.box_padding_right_measurement.value : \"\");\n\t\tce.style.paddingBottom = f.box_padding_bottom.value + (isNum(f.box_padding_bottom.value) ? f.box_padding_bottom_measurement.value : \"\");\n\t\tce.style.paddingLeft = f.box_padding_left.value + (isNum(f.box_padding_left.value) ? f.box_padding_left_measurement.value : \"\");\n\t} else\n\t\tce.style.padding = f.box_padding_top.value + (isNum(f.box_padding_top.value) ? f.box_padding_top_measurement.value : \"\");\t\t\n\n\tif (!f.box_margin_same.checked) {\n\t\tce.style.marginTop = f.box_margin_top.value + (isNum(f.box_margin_top.value) ? f.box_margin_top_measurement.value : \"\");\n\t\tce.style.marginRight = f.box_margin_right.value + (isNum(f.box_margin_right.value) ? f.box_margin_right_measurement.value : \"\");\n\t\tce.style.marginBottom = f.box_margin_bottom.value + (isNum(f.box_margin_bottom.value) ? f.box_margin_bottom_measurement.value : \"\");\n\t\tce.style.marginLeft = f.box_margin_left.value + (isNum(f.box_margin_left.value) ? f.box_margin_left_measurement.value : \"\");\n\t} else\n\t\tce.style.margin = f.box_margin_top.value + (isNum(f.box_margin_top.value) ? f.box_margin_top_measurement.value : \"\");\t\t\n\n\t// Build border styles\n\n\tif (!f.border_style_same.checked) {\n\t\tce.style.borderTopStyle = f.border_style_top.value;\n\t\tce.style.borderRightStyle = f.border_style_right.value;\n\t\tce.style.borderBottomStyle = f.border_style_bottom.value;\n\t\tce.style.borderLeftStyle = f.border_style_left.value;\n\t} else\n\t\tce.style.borderStyle = f.border_style_top.value;\n\n\tif (!f.border_width_same.checked) {\n\t\tce.style.borderTopWidth = f.border_width_top.value + (isNum(f.border_width_top.value) ? f.border_width_top_measurement.value : \"\");\n\t\tce.style.borderRightWidth = f.border_width_right.value + (isNum(f.border_width_right.value) ? f.border_width_right_measurement.value : \"\");\n\t\tce.style.borderBottomWidth = f.border_width_bottom.value + (isNum(f.border_width_bottom.value) ? f.border_width_bottom_measurement.value : \"\");\n\t\tce.style.borderLeftWidth = f.border_width_left.value + (isNum(f.border_width_left.value) ? f.border_width_left_measurement.value : \"\");\n\t} else\n\t\tce.style.borderWidth = f.border_width_top.value + (isNum(f.border_width_top.value) ? f.border_width_top_measurement.value : \"\");\n\n\tif (!f.border_color_same.checked) {\n\t\tce.style.borderTopColor = f.border_color_top.value;\n\t\tce.style.borderRightColor = f.border_color_right.value;\n\t\tce.style.borderBottomColor = f.border_color_bottom.value;\n\t\tce.style.borderLeftColor = f.border_color_left.value;\n\t} else\n\t\tce.style.borderColor = f.border_color_top.value;\n\n\t// Build list styles\n\n\tce.style.listStyleType = f.list_type.value;\n\tce.style.listStylePosition = f.list_position.value;\n\tce.style.listStyleImage = f.list_bullet_image.value != \"\" ? \"url(\" + f.list_bullet_image.value + \")\" : \"\";\n\n\t// Build positioning styles\n\n\tce.style.position = f.positioning_type.value;\n\tce.style.visibility = f.positioning_visibility.value;\n\n\tif (ce.style.width == \"\")\n\t\tce.style.width = f.positioning_width.value + (isNum(f.positioning_width.value) ? f.positioning_width_measurement.value : \"\");\n\n\tif (ce.style.height == \"\")\n\t\tce.style.height = f.positioning_height.value + (isNum(f.positioning_height.value) ? f.positioning_height_measurement.value : \"\");\n\n\tce.style.zIndex = f.positioning_zindex.value;\n\tce.style.overflow = f.positioning_overflow.value;\n\n\tif (!f.positioning_placement_same.checked) {\n\t\tce.style.top = f.positioning_placement_top.value + (isNum(f.positioning_placement_top.value) ? f.positioning_placement_top_measurement.value : \"\");\n\t\tce.style.right = f.positioning_placement_right.value + (isNum(f.positioning_placement_right.value) ? f.positioning_placement_right_measurement.value : \"\");\n\t\tce.style.bottom = f.positioning_placement_bottom.value + (isNum(f.positioning_placement_bottom.value) ? f.positioning_placement_bottom_measurement.value : \"\");\n\t\tce.style.left = f.positioning_placement_left.value + (isNum(f.positioning_placement_left.value) ? f.positioning_placement_left_measurement.value : \"\");\n\t} else {\n\t\ts = f.positioning_placement_top.value + (isNum(f.positioning_placement_top.value) ? f.positioning_placement_top_measurement.value : \"\");\n\t\tce.style.top = s;\n\t\tce.style.right = s;\n\t\tce.style.bottom = s;\n\t\tce.style.left = s;\n\t}\n\n\tif (!f.positioning_clip_same.checked) {\n\t\ts = \"rect(\";\n\t\ts += (isNum(f.positioning_clip_top.value) ? f.positioning_clip_top.value + f.positioning_clip_top_measurement.value : \"auto\") + \" \";\n\t\ts += (isNum(f.positioning_clip_right.value) ? f.positioning_clip_right.value + f.positioning_clip_right_measurement.value : \"auto\") + \" \";\n\t\ts += (isNum(f.positioning_clip_bottom.value) ? f.positioning_clip_bottom.value + f.positioning_clip_bottom_measurement.value : \"auto\") + \" \";\n\t\ts += (isNum(f.positioning_clip_left.value) ? f.positioning_clip_left.value + f.positioning_clip_left_measurement.value : \"auto\");\n\t\ts += \")\";\n\n\t\tif (s != \"rect(auto auto auto auto)\")\n\t\t\tce.style.clip = s;\n\t} else {\n\t\ts = \"rect(\";\n\t\tt = isNum(f.positioning_clip_top.value) ? f.positioning_clip_top.value + f.positioning_clip_top_measurement.value : \"auto\";\n\t\ts += t + \" \";\n\t\ts += t + \" \";\n\t\ts += t + \" \";\n\t\ts += t + \")\";\n\n\t\tif (s != \"rect(auto auto auto auto)\")\n\t\t\tce.style.clip = s;\n\t}\n\n\tce.style.cssText = ce.style.cssText;\n}\n\nfunction isNum(s) {\n\treturn new RegExp('[0-9]+', 'g').test(s);\n}\n\nfunction showDisabledControls() {\n\tvar f = document.forms, i, a;\n\n\tfor (i=0; i<f.length; i++) {\n\t\tfor (a=0; a<f[i].elements.length; a++) {\n\t\t\tif (f[i].elements[a].disabled)\n\t\t\t\ttinyMCEPopup.editor.dom.addClass(f[i].elements[a], \"disabled\");\n\t\t\telse\n\t\t\t\ttinyMCEPopup.editor.dom.removeClass(f[i].elements[a], \"disabled\");\n\t\t}\n\t}\n}\n\nfunction fillSelect(f, s, param, dval, sep, em) {\n\tvar i, ar, p, se;\n\n\tf = document.forms[f];\n\tsep = typeof(sep) == \"undefined\" ? \";\" : sep;\n\n\tif (em)\n\t\taddSelectValue(f, s, \"\", \"\");\n\n\tar = tinyMCEPopup.getParam(param, dval).split(sep);\n\tfor (i=0; i<ar.length; i++) {\n\t\tse = false;\n\n\t\tif (ar[i].charAt(0) == '+') {\n\t\t\tar[i] = ar[i].substring(1);\n\t\t\tse = true;\n\t\t}\n\n\t\tp = ar[i].split('=');\n\n\t\tif (p.length > 1) {\n\t\t\taddSelectValue(f, s, p[0], p[1]);\n\n\t\t\tif (se)\n\t\t\t\tselectByValue(f, s, p[1]);\n\t\t} else {\n\t\t\taddSelectValue(f, s, p[0], p[0]);\n\n\t\t\tif (se)\n\t\t\t\tselectByValue(f, s, p[0]);\n\t\t}\n\t}\n}\n\nfunction toggleSame(ce, pre) {\n\tvar el = document.forms[0].elements, i;\n\n\tif (ce.checked) {\n\t\tel[pre + \"_top\"].disabled = false;\n\t\tel[pre + \"_right\"].disabled = true;\n\t\tel[pre + \"_bottom\"].disabled = true;\n\t\tel[pre + \"_left\"].disabled = true;\n\n\t\tif (el[pre + \"_top_measurement\"]) {\n\t\t\tel[pre + \"_top_measurement\"].disabled = false;\n\t\t\tel[pre + \"_right_measurement\"].disabled = true;\n\t\t\tel[pre + \"_bottom_measurement\"].disabled = true;\n\t\t\tel[pre + \"_left_measurement\"].disabled = true;\n\t\t}\n\t} else {\n\t\tel[pre + \"_top\"].disabled = false;\n\t\tel[pre + \"_right\"].disabled = false;\n\t\tel[pre + \"_bottom\"].disabled = false;\n\t\tel[pre + \"_left\"].disabled = false;\n\n\t\tif (el[pre + \"_top_measurement\"]) {\n\t\t\tel[pre + \"_top_measurement\"].disabled = false;\n\t\t\tel[pre + \"_right_measurement\"].disabled = false;\n\t\t\tel[pre + \"_bottom_measurement\"].disabled = false;\n\t\t\tel[pre + \"_left_measurement\"].disabled = false;\n\t\t}\n\t}\n\n\tshowDisabledControls();\n}\n\nfunction synch(fr, to) {\n\tvar f = document.forms[0];\n\n\tf.elements[to].value = f.elements[fr].value;\n\n\tif (f.elements[fr + \"_measurement\"])\n\t\tselectByValue(f, to + \"_measurement\", f.elements[fr + \"_measurement\"].value);\n}\n\ntinyMCEPopup.onInit.add(init);\n","Magento_Tinymce3/tiny_mce/plugins/style/langs/en_dlg.js":"tinyMCE.addI18n('en.style_dlg',{\"text_lineheight\":\"Line Height\",\"text_variant\":\"Variant\",\"text_style\":\"Style\",\"text_weight\":\"Weight\",\"text_size\":\"Size\",\"text_font\":\"Font\",\"text_props\":\"Text\",\"positioning_tab\":\"Positioning\",\"list_tab\":\"List\",\"border_tab\":\"Border\",\"box_tab\":\"Box\",\"block_tab\":\"Block\",\"background_tab\":\"Background\",\"text_tab\":\"Text\",apply:\"Apply\",title:\"Edit CSS Style\",clip:\"Clip\",placement:\"Placement\",overflow:\"Overflow\",zindex:\"Z-index\",visibility:\"Visibility\",\"positioning_type\":\"Type\",position:\"Position\",\"bullet_image\":\"Bullet Image\",\"list_type\":\"Type\",color:\"Color\",height:\"Height\",width:\"Width\",style:\"Style\",margin:\"Margin\",left:\"Left\",bottom:\"Bottom\",right:\"Right\",top:\"Top\",same:\"Same for All\",padding:\"Padding\",\"box_clear\":\"Clear\",\"box_float\":\"Float\",\"box_height\":\"Height\",\"box_width\":\"Width\",\"block_display\":\"Display\",\"block_whitespace\":\"Whitespace\",\"block_text_indent\":\"Text Indent\",\"block_text_align\":\"Text Align\",\"block_vertical_alignment\":\"Vertical Alignment\",\"block_letterspacing\":\"Letter Spacing\",\"block_wordspacing\":\"Word Spacing\",\"background_vpos\":\"Vertical Position\",\"background_hpos\":\"Horizontal Position\",\"background_attachment\":\"Attachment\",\"background_repeat\":\"Repeat\",\"background_image\":\"Background Image\",\"background_color\":\"Background Color\",\"text_none\":\"None\",\"text_blink\":\"Blink\",\"text_case\":\"Case\",\"text_striketrough\":\"Strikethrough\",\"text_underline\":\"Underline\",\"text_overline\":\"Overline\",\"text_decoration\":\"Decoration\",\"text_color\":\"Color\",text:\"Text\",background:\"Background\",block:\"Block\",box:\"Box\",border:\"Border\",list:\"List\"});","Magento_Tinymce3/tiny_mce/plugins/directionality/editor_plugin.js":"(function(){tinymce.create(\"tinymce.plugins.Directionality\",{init:function(a,b){var c=this;c.editor=a;a.addCommand(\"mceDirectionLTR\",function(){var d=a.dom.getParent(a.selection.getNode(),a.dom.isBlock);if(d){if(a.dom.getAttrib(d,\"dir\")!=\"ltr\"){a.dom.setAttrib(d,\"dir\",\"ltr\")}else{a.dom.setAttrib(d,\"dir\",\"\")}}a.nodeChanged()});a.addCommand(\"mceDirectionRTL\",function(){var d=a.dom.getParent(a.selection.getNode(),a.dom.isBlock);if(d){if(a.dom.getAttrib(d,\"dir\")!=\"rtl\"){a.dom.setAttrib(d,\"dir\",\"rtl\")}else{a.dom.setAttrib(d,\"dir\",\"\")}}a.nodeChanged()});a.addButton(\"ltr\",{title:\"directionality.ltr_desc\",cmd:\"mceDirectionLTR\"});a.addButton(\"rtl\",{title:\"directionality.rtl_desc\",cmd:\"mceDirectionRTL\"});a.onNodeChange.add(c._nodeChange,c)},getInfo:function(){return{longname:\"Directionality\",author:\"Moxiecode Systems AB\",authorurl:\"http://tinymce.moxiecode.com\",infourl:\"http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/directionality\",version:tinymce.majorVersion+\".\"+tinymce.minorVersion}},_nodeChange:function(b,a,e){var d=b.dom,c;e=d.getParent(e,d.isBlock);if(!e){a.setDisabled(\"ltr\",1);a.setDisabled(\"rtl\",1);return}c=d.getAttrib(e,\"dir\");a.setActive(\"ltr\",c==\"ltr\");a.setDisabled(\"ltr\",0);a.setActive(\"rtl\",c==\"rtl\");a.setDisabled(\"rtl\",0)}});tinymce.PluginManager.add(\"directionality\",tinymce.plugins.Directionality)})();","Magento_Tinymce3/tiny_mce/plugins/directionality/editor_plugin_src.js":"/**\n * editor_plugin_src.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\ttinymce.create('tinymce.plugins.Directionality', {\n\t\tinit : function(ed, url) {\n\t\t\tvar t = this;\n\n\t\t\tt.editor = ed;\n\n\t\t\ted.addCommand('mceDirectionLTR', function() {\n\t\t\t\tvar e = ed.dom.getParent(ed.selection.getNode(), ed.dom.isBlock);\n\n\t\t\t\tif (e) {\n\t\t\t\t\tif (ed.dom.getAttrib(e, \"dir\") != \"ltr\")\n\t\t\t\t\t\ted.dom.setAttrib(e, \"dir\", \"ltr\");\n\t\t\t\t\telse\n\t\t\t\t\t\ted.dom.setAttrib(e, \"dir\", \"\");\n\t\t\t\t}\n\n\t\t\t\ted.nodeChanged();\n\t\t\t});\n\n\t\t\ted.addCommand('mceDirectionRTL', function() {\n\t\t\t\tvar e = ed.dom.getParent(ed.selection.getNode(), ed.dom.isBlock);\n\n\t\t\t\tif (e) {\n\t\t\t\t\tif (ed.dom.getAttrib(e, \"dir\") != \"rtl\")\n\t\t\t\t\t\ted.dom.setAttrib(e, \"dir\", \"rtl\");\n\t\t\t\t\telse\n\t\t\t\t\t\ted.dom.setAttrib(e, \"dir\", \"\");\n\t\t\t\t}\n\n\t\t\t\ted.nodeChanged();\n\t\t\t});\n\n\t\t\ted.addButton('ltr', {title : 'directionality.ltr_desc', cmd : 'mceDirectionLTR'});\n\t\t\ted.addButton('rtl', {title : 'directionality.rtl_desc', cmd : 'mceDirectionRTL'});\n\n\t\t\ted.onNodeChange.add(t._nodeChange, t);\n\t\t},\n\n\t\tgetInfo : function() {\n\t\t\treturn {\n\t\t\t\tlongname : 'Directionality',\n\t\t\t\tauthor : 'Moxiecode Systems AB',\n\t\t\t\tauthorurl : 'http://tinymce.moxiecode.com',\n\t\t\t\tinfourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/directionality',\n\t\t\t\tversion : tinymce.majorVersion + \".\" + tinymce.minorVersion\n\t\t\t};\n\t\t},\n\n\t\t// Private methods\n\n\t\t_nodeChange : function(ed, cm, n) {\n\t\t\tvar dom = ed.dom, dir;\n\n\t\t\tn = dom.getParent(n, dom.isBlock);\n\t\t\tif (!n) {\n\t\t\t\tcm.setDisabled('ltr', 1);\n\t\t\t\tcm.setDisabled('rtl', 1);\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tdir = dom.getAttrib(n, 'dir');\n\t\t\tcm.setActive('ltr', dir == \"ltr\");\n\t\t\tcm.setDisabled('ltr', 0);\n\t\t\tcm.setActive('rtl', dir == \"rtl\");\n\t\t\tcm.setDisabled('rtl', 0);\n\t\t}\n\t});\n\n\t// Register plugin\n\ttinymce.PluginManager.add('directionality', tinymce.plugins.Directionality);\n})();","Magento_Tinymce3/tiny_mce/utils/editable_selects.js":"/**\n * editable_selects.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\nvar TinyMCE_EditableSelects = {\n\teditSelectElm : null,\n\n\tinit : function() {\n\t\tvar nl = document.getElementsByTagName(\"select\"), i, d = document, o;\n\n\t\tfor (i=0; i<nl.length; i++) {\n\t\t\tif (nl[i].className.indexOf('mceEditableSelect') != -1) {\n\t\t\t\to = new Option(tinyMCEPopup.editor.translate('value'), '__mce_add_custom__');\n\n\t\t\t\to.className = 'mceAddSelectValue';\n\n\t\t\t\tnl[i].options[nl[i].options.length] = o;\n\t\t\t\tnl[i].onchange = TinyMCE_EditableSelects.onChangeEditableSelect;\n\t\t\t}\n\t\t}\n\t},\n\n\tonChangeEditableSelect : function(e) {\n\t\tvar d = document, ne, se = window.event ? window.event.srcElement : e.target;\n\n\t\tif (se.options[se.selectedIndex].value == '__mce_add_custom__') {\n\t\t\tne = d.createElement(\"input\");\n\t\t\tne.id = se.id + \"_custom\";\n\t\t\tne.name = se.name + \"_custom\";\n\t\t\tne.type = \"text\";\n\n\t\t\tne.style.width = se.offsetWidth + 'px';\n\t\t\tse.parentNode.insertBefore(ne, se);\n\t\t\tse.style.display = 'none';\n\t\t\tne.focus();\n\t\t\tne.onblur = TinyMCE_EditableSelects.onBlurEditableSelectInput;\n\t\t\tne.onkeydown = TinyMCE_EditableSelects.onKeyDown;\n\t\t\tTinyMCE_EditableSelects.editSelectElm = se;\n\t\t}\n\t},\n\n\tonBlurEditableSelectInput : function() {\n\t\tvar se = TinyMCE_EditableSelects.editSelectElm;\n\n\t\tif (se) {\n\t\t\tif (se.previousSibling.value != '') {\n\t\t\t\taddSelectValue(document.forms[0], se.id, se.previousSibling.value, se.previousSibling.value);\n\t\t\t\tselectByValue(document.forms[0], se.id, se.previousSibling.value);\n\t\t\t} else\n\t\t\t\tselectByValue(document.forms[0], se.id, '');\n\n\t\t\tse.style.display = 'inline';\n\t\t\tse.parentNode.removeChild(se.previousSibling);\n\t\t\tTinyMCE_EditableSelects.editSelectElm = null;\n\t\t}\n\t},\n\n\tonKeyDown : function(e) {\n\t\te = e || window.event;\n\n\t\tif (e.keyCode == 13)\n\t\t\tTinyMCE_EditableSelects.onBlurEditableSelectInput();\n\t}\n};\n","Magento_Tinymce3/tiny_mce/utils/validate.js":"/**\n * validate.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n/**\n\t// String validation:\n\n\tif (!Validator.isEmail('myemail'))\n\t\talert('Invalid email.');\n\n\t// Form validation:\n\n\tvar f = document.forms['myform'];\n\n\tif (!Validator.isEmail(f.myemail))\n\t\talert('Invalid email.');\n*/\n\nvar Validator = {\n\tisEmail : function(s) {\n\t\treturn this.test(s, '^[-!#$%&\\'*+\\\\./0-9=?A-Z^_`a-z{|}~]+@[-!#$%&\\'*+\\\\/0-9=?A-Z^_`a-z{|}~]+\\.[-!#$%&\\'*+\\\\./0-9=?A-Z^_`a-z{|}~]+$');\n\t},\n\n\tisAbsUrl : function(s) {\n\t\treturn this.test(s, '^(news|telnet|nttp|file|http|ftp|https)://[-A-Za-z0-9\\\\.]+\\\\/?.*$');\n\t},\n\n\tisSize : function(s) {\n\t\treturn this.test(s, '^[0-9.]+(%|in|cm|mm|em|ex|pt|pc|px)?$');\n\t},\n\n\tisId : function(s) {\n\t\treturn this.test(s, '^[A-Za-z_]([A-Za-z0-9_])*$');\n\t},\n\n\tisEmpty : function(s) {\n\t\tvar nl, i;\n\n\t\tif (s.nodeName == 'SELECT' && s.selectedIndex < 1)\n\t\t\treturn true;\n\n\t\tif (s.type == 'checkbox' && !s.checked)\n\t\t\treturn true;\n\n\t\tif (s.type == 'radio') {\n\t\t\tfor (i=0, nl = s.form.elements; i<nl.length; i++) {\n\t\t\t\tif (nl[i].type == \"radio\" && nl[i].name == s.name && nl[i].checked)\n\t\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\treturn true;\n\t\t}\n\n\t\treturn new RegExp('^\\\\s*$').test(s.nodeType == 1 ? s.value : s);\n\t},\n\n\tisNumber : function(s, d) {\n\t\treturn !isNaN(s.nodeType == 1 ? s.value : s) && (!d || !this.test(s, '^-?[0-9]*\\\\.[0-9]*$'));\n\t},\n\n\ttest : function(s, p) {\n\t\ts = s.nodeType == 1 ? s.value : s;\n\n\t\treturn s == '' || new RegExp(p).test(s);\n\t}\n};\n\nvar AutoValidator = {\n\tsettings : {\n\t\tid_cls : 'id',\n\t\tint_cls : 'int',\n\t\turl_cls : 'url',\n\t\tnumber_cls : 'number',\n\t\temail_cls : 'email',\n\t\tsize_cls : 'size',\n\t\trequired_cls : 'required',\n\t\tinvalid_cls : 'invalid',\n\t\tmin_cls : 'min',\n\t\tmax_cls : 'max'\n\t},\n\n\tinit : function(s) {\n\t\tvar n;\n\n\t\tfor (n in s)\n\t\t\tthis.settings[n] = s[n];\n\t},\n\n\tvalidate : function(f) {\n\t\tvar i, nl, s = this.settings, c = 0;\n\n\t\tnl = this.tags(f, 'label');\n\t\tfor (i=0; i<nl.length; i++) {\n\t\t\tthis.removeClass(nl[i], s.invalid_cls);\n\t\t\tnl[i].setAttribute('aria-invalid', false);\n\t\t}\n\n\t\tc += this.validateElms(f, 'input');\n\t\tc += this.validateElms(f, 'select');\n\t\tc += this.validateElms(f, 'textarea');\n\n\t\treturn c == 3;\n\t},\n\n\tinvalidate : function(n) {\n\t\tthis.mark(n.form, n);\n\t},\n\t\n\tgetErrorMessages : function(f) {\n\t\tvar nl, i, s = this.settings, field, msg, values, messages = [], ed = tinyMCEPopup.editor;\n\t\tnl = this.tags(f, \"label\");\n\t\tfor (i=0; i<nl.length; i++) {\n\t\t\tif (this.hasClass(nl[i], s.invalid_cls)) {\n\t\t\t\tfield = document.getElementById(nl[i].getAttribute(\"for\"));\n\t\t\t\tvalues = { field: nl[i].textContent };\n\t\t\t\tif (this.hasClass(field, s.min_cls, true)) {\n\t\t\t\t\tmessage = ed.getLang('invalid_data_min');\n\t\t\t\t\tvalues.min = this.getNum(field, s.min_cls);\n\t\t\t\t} else if (this.hasClass(field, s.number_cls)) {\n\t\t\t\t\tmessage = ed.getLang('invalid_data_number');\n\t\t\t\t} else if (this.hasClass(field, s.size_cls)) {\n\t\t\t\t\tmessage = ed.getLang('invalid_data_size');\n\t\t\t\t} else {\n\t\t\t\t\tmessage = ed.getLang('invalid_data');\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\tmessage = message.replace(/{\\#([^}]+)\\}/g, function(a, b) {\n\t\t\t\t\treturn values[b] || '{#' + b + '}';\n\t\t\t\t});\n\t\t\t\tmessages.push(message);\n\t\t\t}\n\t\t}\n\t\treturn messages;\n\t},\n\n\treset : function(e) {\n\t\tvar t = ['label', 'input', 'select', 'textarea'];\n\t\tvar i, j, nl, s = this.settings;\n\n\t\tif (e == null)\n\t\t\treturn;\n\n\t\tfor (i=0; i<t.length; i++) {\n\t\t\tnl = this.tags(e.form ? e.form : e, t[i]);\n\t\t\tfor (j=0; j<nl.length; j++) {\n\t\t\t\tthis.removeClass(nl[j], s.invalid_cls);\n\t\t\t\tnl[j].setAttribute('aria-invalid', false);\n\t\t\t}\n\t\t}\n\t},\n\n\tvalidateElms : function(f, e) {\n\t\tvar nl, i, n, s = this.settings, st = true, va = Validator, v;\n\n\t\tnl = this.tags(f, e);\n\t\tfor (i=0; i<nl.length; i++) {\n\t\t\tn = nl[i];\n\n\t\t\tthis.removeClass(n, s.invalid_cls);\n\n\t\t\tif (this.hasClass(n, s.required_cls) && va.isEmpty(n))\n\t\t\t\tst = this.mark(f, n);\n\n\t\t\tif (this.hasClass(n, s.number_cls) && !va.isNumber(n))\n\t\t\t\tst = this.mark(f, n);\n\n\t\t\tif (this.hasClass(n, s.int_cls) && !va.isNumber(n, true))\n\t\t\t\tst = this.mark(f, n);\n\n\t\t\tif (this.hasClass(n, s.url_cls) && !va.isAbsUrl(n))\n\t\t\t\tst = this.mark(f, n);\n\n\t\t\tif (this.hasClass(n, s.email_cls) && !va.isEmail(n))\n\t\t\t\tst = this.mark(f, n);\n\n\t\t\tif (this.hasClass(n, s.size_cls) && !va.isSize(n))\n\t\t\t\tst = this.mark(f, n);\n\n\t\t\tif (this.hasClass(n, s.id_cls) && !va.isId(n))\n\t\t\t\tst = this.mark(f, n);\n\n\t\t\tif (this.hasClass(n, s.min_cls, true)) {\n\t\t\t\tv = this.getNum(n, s.min_cls);\n\n\t\t\t\tif (isNaN(v) || parseInt(n.value) < parseInt(v))\n\t\t\t\t\tst = this.mark(f, n);\n\t\t\t}\n\n\t\t\tif (this.hasClass(n, s.max_cls, true)) {\n\t\t\t\tv = this.getNum(n, s.max_cls);\n\n\t\t\t\tif (isNaN(v) || parseInt(n.value) > parseInt(v))\n\t\t\t\t\tst = this.mark(f, n);\n\t\t\t}\n\t\t}\n\n\t\treturn st;\n\t},\n\n\thasClass : function(n, c, d) {\n\t\treturn new RegExp('\\\\b' + c + (d ? '[0-9]+' : '') + '\\\\b', 'g').test(n.className);\n\t},\n\n\tgetNum : function(n, c) {\n\t\tc = n.className.match(new RegExp('\\\\b' + c + '([0-9]+)\\\\b', 'g'))[0];\n\t\tc = c.replace(/[^0-9]/g, '');\n\n\t\treturn c;\n\t},\n\n\taddClass : function(n, c, b) {\n\t\tvar o = this.removeClass(n, c);\n\t\tn.className = b ? c + (o != '' ? (' ' + o) : '') : (o != '' ? (o + ' ') : '') + c;\n\t},\n\n\tremoveClass : function(n, c) {\n\t\tc = n.className.replace(new RegExp(\"(^|\\\\s+)\" + c + \"(\\\\s+|$)\"), ' ');\n\t\treturn n.className = c != ' ' ? c : '';\n\t},\n\n\ttags : function(f, s) {\n\t\treturn f.getElementsByTagName(s);\n\t},\n\n\tmark : function(f, n) {\n\t\tvar s = this.settings;\n\n\t\tthis.addClass(n, s.invalid_cls);\n\t\tn.setAttribute('aria-invalid', 'true');\n\t\tthis.markLabels(f, n, s.invalid_cls);\n\n\t\treturn false;\n\t},\n\n\tmarkLabels : function(f, n, ic) {\n\t\tvar nl, i;\n\n\t\tnl = this.tags(f, \"label\");\n\t\tfor (i=0; i<nl.length; i++) {\n\t\t\tif (nl[i].getAttribute(\"for\") == n.id || nl[i].htmlFor == n.id)\n\t\t\t\tthis.addClass(nl[i], ic);\n\t\t}\n\n\t\treturn null;\n\t}\n};\n","Magento_Tinymce3/tiny_mce/utils/mctabs.js":"/**\n * mctabs.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\nfunction MCTabs() {\n\tthis.settings = [];\n\tthis.onChange = tinyMCEPopup.editor.windowManager.createInstance('tinymce.util.Dispatcher');\n};\n\nMCTabs.prototype.init = function(settings) {\n\tthis.settings = settings;\n};\n\nMCTabs.prototype.getParam = function(name, default_value) {\n\tvar value = null;\n\n\tvalue = (typeof(this.settings[name]) == \"undefined\") ? default_value : this.settings[name];\n\n\t// Fix bool values\n\tif (value == \"true\" || value == \"false\")\n\t\treturn (value == \"true\");\n\n\treturn value;\n};\n\nMCTabs.prototype.showTab =function(tab){\n\ttab.className = 'current';\n\ttab.setAttribute(\"aria-selected\", true);\n\ttab.setAttribute(\"aria-expanded\", true);\n\ttab.tabIndex = 0;\n};\n\nMCTabs.prototype.hideTab =function(tab){\n\tvar t=this;\n\n\ttab.className = '';\n\ttab.setAttribute(\"aria-selected\", false);\n\ttab.setAttribute(\"aria-expanded\", false);\n\ttab.tabIndex = -1;\n};\n\nMCTabs.prototype.showPanel = function(panel) {\n\tpanel.className = 'current'; \n\tpanel.setAttribute(\"aria-hidden\", false);\n};\n\nMCTabs.prototype.hidePanel = function(panel) {\n\tpanel.className = 'panel';\n\tpanel.setAttribute(\"aria-hidden\", true);\n}; \n\nMCTabs.prototype.getPanelForTab = function(tabElm) {\n\treturn tinyMCEPopup.dom.getAttrib(tabElm, \"aria-controls\");\n};\n\nMCTabs.prototype.displayTab = function(tab_id, panel_id, avoid_focus) {\n\tvar panelElm, panelContainerElm, tabElm, tabContainerElm, selectionClass, nodes, i, t = this;\n\n\ttabElm = document.getElementById(tab_id);\n\n\tif (panel_id === undefined) {\n\t\tpanel_id = t.getPanelForTab(tabElm);\n\t}\n\n\tpanelElm= document.getElementById(panel_id);\n\tpanelContainerElm = panelElm ? panelElm.parentNode : null;\n\ttabContainerElm = tabElm ? tabElm.parentNode : null;\n\tselectionClass = t.getParam('selection_class', 'current');\n\n\tif (tabElm && tabContainerElm) {\n\t\tnodes = tabContainerElm.childNodes;\n\n\t\t// Hide all other tabs\n\t\tfor (i = 0; i < nodes.length; i++) {\n\t\t\tif (nodes[i].nodeName == \"LI\") {\n\t\t\t\tt.hideTab(nodes[i]);\n\t\t\t}\n\t\t}\n\n\t\t// Show selected tab\n\t\tt.showTab(tabElm);\n\t}\n\n\tif (panelElm && panelContainerElm) {\n\t\tnodes = panelContainerElm.childNodes;\n\n\t\t// Hide all other panels\n\t\tfor (i = 0; i < nodes.length; i++) {\n\t\t\tif (nodes[i].nodeName == \"DIV\")\n\t\t\t\tt.hidePanel(nodes[i]);\n\t\t}\n\n\t\tif (!avoid_focus) { \n\t\t\ttabElm.focus();\n\t\t}\n\n\t\t// Show selected panel\n\t\tt.showPanel(panelElm);\n\t}\n};\n\nMCTabs.prototype.getAnchor = function() {\n\tvar pos, url = document.location.href;\n\n\tif ((pos = url.lastIndexOf('#')) != -1)\n\t\treturn url.substring(pos + 1);\n\n\treturn \"\";\n};\n\n\n//Global instance\nvar mcTabs = new MCTabs();\n\ntinyMCEPopup.onInit.add(function() {\n\tvar tinymce = tinyMCEPopup.getWin().tinymce, dom = tinyMCEPopup.dom, each = tinymce.each;\n\n\teach(dom.select('div.tabs'), function(tabContainerElm) {\n\t\tvar keyNav;\n\n\t\tdom.setAttrib(tabContainerElm, \"role\", \"tablist\"); \n\n\t\tvar items = tinyMCEPopup.dom.select('li', tabContainerElm);\n\t\tvar action = function(id) {\n\t\t\tmcTabs.displayTab(id, mcTabs.getPanelForTab(id));\n\t\t\tmcTabs.onChange.dispatch(id);\n\t\t};\n\n\t\teach(items, function(item) {\n\t\t\tdom.setAttrib(item, 'role', 'tab');\n\t\t\tdom.bind(item, 'click', function(evt) {\n\t\t\t\taction(item.id);\n\t\t\t});\n\t\t});\n\n\t\tdom.bind(dom.getRoot(), 'keydown', function(evt) {\n\t\t\tif (evt.keyCode === 9 && evt.ctrlKey && !evt.altKey) { // Tab\n\t\t\t\tkeyNav.moveFocus(evt.shiftKey ? -1 : 1);\n\t\t\t\ttinymce.dom.Event.cancel(evt);\n\t\t\t}\n\t\t});\n\n\t\teach(dom.select('a', tabContainerElm), function(a) {\n\t\t\tdom.setAttrib(a, 'tabindex', '-1');\n\t\t});\n\n\t\tkeyNav = tinyMCEPopup.editor.windowManager.createInstance('tinymce.ui.KeyboardNavigation', {\n\t\t\troot: tabContainerElm,\n\t\t\titems: items,\n\t\t\tonAction: action,\n\t\t\tactOnFocus: true,\n\t\t\tenableLeftRight: true,\n\t\t\tenableUpDown: true\n\t\t}, tinyMCEPopup.dom);\n\t});\n});","Magento_Tinymce3/tiny_mce/utils/form_utils.js":"/**\n * form_utils.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\nvar themeBaseURL = tinyMCEPopup.editor.baseURI.toAbsolute('themes/' + tinyMCEPopup.getParam(\"theme\"));\n\nfunction getColorPickerHTML(id, target_form_element) {\n\tvar h = \"\", dom = tinyMCEPopup.dom;\n\n\tif (label = dom.select('label[for=' + target_form_element + ']')[0]) {\n\t\tlabel.id = label.id || dom.uniqueId();\n\t}\n\n\th += '<a role=\"button\" aria-labelledby=\"' + id + '_label\" id=\"' + id + '_link\" href=\"javascript:;\" onclick=\"tinyMCEPopup.pickColor(event,\\'' + target_form_element +'\\');\" onmousedown=\"return false;\" class=\"pickcolor\">';\n\th += '<span id=\"' + id + '\" title=\"' + tinyMCEPopup.getLang('browse') + '\">&nbsp;<span id=\"' + id + '_label\" class=\"mceVoiceLabel mceIconOnly\" style=\"display:none;\">' + tinyMCEPopup.getLang('browse') + '</span></span></a>';\n\n\treturn h;\n}\n\nfunction updateColor(img_id, form_element_id) {\n\tdocument.getElementById(img_id).style.backgroundColor = document.forms[0].elements[form_element_id].value;\n}\n\nfunction setBrowserDisabled(id, state) {\n\tvar img = document.getElementById(id);\n\tvar lnk = document.getElementById(id + \"_link\");\n\n\tif (lnk) {\n\t\tif (state) {\n\t\t\tlnk.setAttribute(\"realhref\", lnk.getAttribute(\"href\"));\n\t\t\tlnk.removeAttribute(\"href\");\n\t\t\ttinyMCEPopup.dom.addClass(img, 'disabled');\n\t\t} else {\n\t\t\tif (lnk.getAttribute(\"realhref\"))\n\t\t\t\tlnk.setAttribute(\"href\", lnk.getAttribute(\"realhref\"));\n\n\t\t\ttinyMCEPopup.dom.removeClass(img, 'disabled');\n\t\t}\n\t}\n}\n\nfunction getBrowserHTML(id, target_form_element, type, prefix) {\n\tvar option = prefix + \"_\" + type + \"_browser_callback\", cb, html;\n\n\tcb = tinyMCEPopup.getParam(option, tinyMCEPopup.getParam(\"file_browser_callback\"));\n\n\tif (!cb)\n\t\treturn \"\";\n\n\thtml = \"\";\n\thtml += '<a id=\"' + id + '_link\" href=\"javascript:openBrowser(\\'' + id + '\\',\\'' + target_form_element + '\\', \\'' + type + '\\',\\'' + option + '\\');\" onmousedown=\"return false;\" class=\"browse\">';\n\thtml += '<span id=\"' + id + '\" title=\"' + tinyMCEPopup.getLang('browse') + '\">&nbsp;</span></a>';\n\n\treturn html;\n}\n\nfunction openBrowser(img_id, target_form_element, type, option) {\n\tvar img = document.getElementById(img_id);\n\n\tif (img.className != \"mceButtonDisabled\")\n\t\ttinyMCEPopup.openBrowser(target_form_element, type, option);\n}\n\nfunction selectByValue(form_obj, field_name, value, add_custom, ignore_case) {\n\tif (!form_obj || !form_obj.elements[field_name])\n\t\treturn;\n\n\tif (!value)\n\t\tvalue = \"\";\n\n\tvar sel = form_obj.elements[field_name];\n\n\tvar found = false;\n\tfor (var i=0; i<sel.options.length; i++) {\n\t\tvar option = sel.options[i];\n\n\t\tif (option.value == value || (ignore_case && option.value.toLowerCase() == value.toLowerCase())) {\n\t\t\toption.selected = true;\n\t\t\tfound = true;\n\t\t} else\n\t\t\toption.selected = false;\n\t}\n\n\tif (!found && add_custom && value != '') {\n\t\tvar option = new Option(value, value);\n\t\toption.selected = true;\n\t\tsel.options[sel.options.length] = option;\n\t\tsel.selectedIndex = sel.options.length - 1;\n\t}\n\n\treturn found;\n}\n\nfunction getSelectValue(form_obj, field_name) {\n\tvar elm = form_obj.elements[field_name];\n\n\tif (elm == null || elm.options == null || elm.selectedIndex === -1)\n\t\treturn \"\";\n\n\treturn elm.options[elm.selectedIndex].value;\n}\n\nfunction addSelectValue(form_obj, field_name, name, value) {\n\tvar s = form_obj.elements[field_name];\n\tvar o = new Option(name, value);\n\ts.options[s.options.length] = o;\n}\n\nfunction addClassesToList(list_id, specific_option) {\n\t// Setup class droplist\n\tvar styleSelectElm = document.getElementById(list_id);\n\tvar styles = tinyMCEPopup.getParam('theme_advanced_styles', false);\n\tstyles = tinyMCEPopup.getParam(specific_option, styles);\n\n\tif (styles) {\n\t\tvar stylesAr = styles.split(';');\n\n\t\tfor (var i=0; i<stylesAr.length; i++) {\n\t\t\tif (stylesAr != \"\") {\n\t\t\t\tvar key, value;\n\n\t\t\t\tkey = stylesAr[i].split('=')[0];\n\t\t\t\tvalue = stylesAr[i].split('=')[1];\n\n\t\t\t\tstyleSelectElm.options[styleSelectElm.length] = new Option(key, value);\n\t\t\t}\n\t\t}\n\t} else {\n\t\ttinymce.each(tinyMCEPopup.editor.dom.getClasses(), function(o) {\n\t\t\tstyleSelectElm.options[styleSelectElm.length] = new Option(o.title || o['class'], o['class']);\n\t\t});\n\t}\n}\n\nfunction isVisible(element_id) {\n\tvar elm = document.getElementById(element_id);\n\n\treturn elm && elm.style.display != \"none\";\n}\n\nfunction convertRGBToHex(col) {\n\tvar re = new RegExp(\"rgb\\\\s*\\\\(\\\\s*([0-9]+).*,\\\\s*([0-9]+).*,\\\\s*([0-9]+).*\\\\)\", \"gi\");\n\n\tvar rgb = col.replace(re, \"$1,$2,$3\").split(',');\n\tif (rgb.length == 3) {\n\t\tr = parseInt(rgb[0]).toString(16);\n\t\tg = parseInt(rgb[1]).toString(16);\n\t\tb = parseInt(rgb[2]).toString(16);\n\n\t\tr = r.length == 1 ? '0' + r : r;\n\t\tg = g.length == 1 ? '0' + g : g;\n\t\tb = b.length == 1 ? '0' + b : b;\n\n\t\treturn \"#\" + r + g + b;\n\t}\n\n\treturn col;\n}\n\nfunction convertHexToRGB(col) {\n\tif (col.indexOf('#') != -1) {\n\t\tcol = col.replace(new RegExp('[^0-9A-F]', 'gi'), '');\n\n\t\tr = parseInt(col.substring(0, 2), 16);\n\t\tg = parseInt(col.substring(2, 4), 16);\n\t\tb = parseInt(col.substring(4, 6), 16);\n\n\t\treturn \"rgb(\" + r + \",\" + g + \",\" + b + \")\";\n\t}\n\n\treturn col;\n}\n\nfunction trimSize(size) {\n\treturn size.replace(/([0-9\\.]+)(px|%|in|cm|mm|em|ex|pt|pc)/i, '$1$2');\n}\n\nfunction getCSSSize(size) {\n\tsize = trimSize(size);\n\n\tif (size == \"\")\n\t\treturn \"\";\n\n\t// Add px\n\tif (/^[0-9]+$/.test(size))\n\t\tsize += 'px';\n\t// Sanity check, IE doesn't like broken values\n\telse if (!(/^[0-9\\.]+(px|%|in|cm|mm|em|ex|pt|pc)$/i.test(size)))\n\t\treturn \"\";\n\n\treturn size;\n}\n\nfunction getStyle(elm, attrib, style) {\n\tvar val = tinyMCEPopup.dom.getAttrib(elm, attrib);\n\n\tif (val != '')\n\t\treturn '' + val;\n\n\tif (typeof(style) == 'undefined')\n\t\tstyle = attrib;\n\n\treturn tinyMCEPopup.dom.getStyle(elm, style);\n}\n","Magento_Tinymce3/tiny_mce/langs/en.js":"tinyMCE.addI18n({en:{common:{\"more_colors\":\"More Colors...\",\"invalid_data\":\"Error: Invalid values entered, these are marked in red.\",\"popup_blocked\":\"Sorry, but we have noticed that your popup-blocker has disabled a window that provides application functionality. You will need to disable popup blocking on this site in order to fully utilize this tool.\",\"clipboard_no_support\":\"Currently not supported by your browser, use keyboard shortcuts instead.\",\"clipboard_msg\":\"Copy/Cut/Paste is not available in Mozilla and Firefox.\\nDo you want more information about this issue?\",\"not_set\":\"-- Not Set --\",\"class_name\":\"Class\",browse:\"Browse\",close:\"Close\",cancel:\"Cancel\",update:\"Update\",insert:\"Insert\",apply:\"Apply\",\"edit_confirm\":\"Do you want to use the WYSIWYG mode for this textarea?\",\"invalid_data_number\":\"{#field} must be a number\",\"invalid_data_min\":\"{#field} must be a number greater than {#min}\",\"invalid_data_size\":\"{#field} must be a number or percentage\",value:\"(value)\"},contextmenu:{full:\"Full\",right:\"Right\",center:\"Center\",left:\"Left\",align:\"Alignment\"},insertdatetime:{\"day_short\":\"Sun,Mon,Tue,Wed,Thu,Fri,Sat,Sun\",\"day_long\":\"Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday\",\"months_short\":\"Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec\",\"months_long\":\"January,February,March,April,May,June,July,August,September,October,November,December\",\"inserttime_desc\":\"Insert Time\",\"insertdate_desc\":\"Insert Date\",\"time_fmt\":\"%H:%M:%S\",\"date_fmt\":\"%Y-%m-%d\"},print:{\"print_desc\":\"Print\"},preview:{\"preview_desc\":\"Preview\"},directionality:{\"rtl_desc\":\"Direction Right to Left\",\"ltr_desc\":\"Direction Left to Right\"},layer:{content:\"New layer...\",\"absolute_desc\":\"Toggle Absolute Positioning\",\"backward_desc\":\"Move Backward\",\"forward_desc\":\"Move Forward\",\"insertlayer_desc\":\"Insert New Layer\"},save:{\"save_desc\":\"Save\",\"cancel_desc\":\"Cancel All Changes\"},nonbreaking:{\"nonbreaking_desc\":\"Insert Non-Breaking Space Character\"},iespell:{download:\"ieSpell not detected. Do you want to install it now?\",\"iespell_desc\":\"Check Spelling\"},advhr:{\"delta_height\":\"\",\"delta_width\":\"\",\"advhr_desc\":\"Insert Horizontal Line\"},emotions:{\"delta_height\":\"\",\"delta_width\":\"\",\"emotions_desc\":\"Emotions\"},searchreplace:{\"replace_desc\":\"Find/Replace\",\"delta_width\":\"\",\"delta_height\":\"\",\"search_desc\":\"Find\"},advimage:{\"delta_width\":\"\",\"image_desc\":\"Insert/Edit Image\",\"delta_height\":\"\"},advlink:{\"delta_height\":\"\",\"delta_width\":\"\",\"link_desc\":\"Insert/Edit Link\"},xhtmlxtras:{\"attribs_delta_height\":\"\",\"attribs_delta_width\":\"\",\"ins_delta_height\":\"\",\"ins_delta_width\":\"\",\"del_delta_height\":\"\",\"del_delta_width\":\"\",\"acronym_delta_height\":\"\",\"acronym_delta_width\":\"\",\"abbr_delta_height\":\"\",\"abbr_delta_width\":\"\",\"cite_delta_height\":\"\",\"cite_delta_width\":\"\",\"attribs_desc\":\"Insert/Edit Attributes\",\"ins_desc\":\"Insertion\",\"del_desc\":\"Deletion\",\"acronym_desc\":\"Acronym\",\"abbr_desc\":\"Abbreviation\",\"cite_desc\":\"Citation\"},style:{\"delta_height\":\"\",\"delta_width\":\"\",desc:\"Edit CSS Style\"},paste:{\"plaintext_mode_stick\":\"Paste is now in plain text mode. Click again to toggle back to regular paste mode.\",\"plaintext_mode\":\"Paste is now in plain text mode. Click again to toggle back to regular paste mode. After you paste something you will be returned to regular paste mode.\",\"selectall_desc\":\"Select All\",\"paste_word_desc\":\"Paste from Word\",\"paste_text_desc\":\"Paste as Plain Text\"},\"paste_dlg\":{\"word_title\":\"Use Ctrl+V on your keyboard to paste the text into the window.\",\"text_linebreaks\":\"Keep Linebreaks\",\"text_title\":\"Use Ctrl+V on your keyboard to paste the text into the window.\"},table:{\"merge_cells_delta_height\":\"\",\"merge_cells_delta_width\":\"\",\"table_delta_height\":\"\",\"table_delta_width\":\"\",\"cellprops_delta_height\":\"\",\"cellprops_delta_width\":\"\",\"rowprops_delta_height\":\"\",\"rowprops_delta_width\":\"\",cell:\"Cell\",col:\"Column\",row:\"Row\",del:\"Delete Table\",\"copy_row_desc\":\"Copy Table Row\",\"cut_row_desc\":\"Cut Table Row\",\"paste_row_after_desc\":\"Paste Table Row After\",\"paste_row_before_desc\":\"Paste Table Row Before\",\"props_desc\":\"Table Properties\",\"cell_desc\":\"Table Cell Properties\",\"row_desc\":\"Table Row Properties\",\"merge_cells_desc\":\"Merge Table Cells\",\"split_cells_desc\":\"Split Merged Table Cells\",\"delete_col_desc\":\"Delete Column\",\"col_after_desc\":\"Insert Column After\",\"col_before_desc\":\"Insert Column Before\",\"delete_row_desc\":\"Delete Row\",\"row_after_desc\":\"Insert Row After\",\"row_before_desc\":\"Insert Row Before\",desc:\"Insert/Edit Table\"},autosave:{\"warning_message\":\"If you restore the saved content, you will lose all the content that is currently in the editor.\\n\\nAre you sure you want to restore the saved content?\",\"restore_content\":\"Restore auto-saved content.\",\"unload_msg\":\"The changes you made will be lost if you navigate away from this page.\"},fullscreen:{desc:\"Toggle Full Screen Mode\"},media:{\"delta_height\":\"\",\"delta_width\":\"\",edit:\"Edit Embedded Media\",desc:\"Insert/Edit Embedded Media\"},fullpage:{desc:\"Document Properties\",\"delta_width\":\"\",\"delta_height\":\"\"},template:{desc:\"Insert Predefined Template Content\"},visualchars:{desc:\"Show/Hide Visual Control Characters\"},spellchecker:{desc:\"Toggle Spell Checker\",menu:\"Spell Checker Settings\",\"ignore_word\":\"Ignore Word\",\"ignore_words\":\"Ignore All\",langs:\"Languages\",wait:\"Please wait...\",sug:\"Suggestions\",\"no_sug\":\"No Suggestions\",\"no_mpell\":\"No misspellings found.\",\"learn_word\":\"Learn word\"},pagebreak:{desc:\"Insert Page Break for Printing\"},advlist:{types:\"Types\",def:\"Default\",\"lower_alpha\":\"Lower Alpha\",\"lower_greek\":\"Lower Greek\",\"lower_roman\":\"Lower Roman\",\"upper_alpha\":\"Upper Alpha\",\"upper_roman\":\"Upper Roman\",circle:\"Circle\",disc:\"Disc\",square:\"Square\"},colors:{\"333300\":\"Dark olive\",\"993300\":\"Burnt orange\",\"000000\":\"Black\",\"003300\":\"Dark green\",\"003366\":\"Dark azure\",\"000080\":\"Navy Blue\",\"333399\":\"Indigo\",\"333333\":\"Very dark gray\",\"800000\":\"Maroon\",FF6600:\"Orange\",\"808000\":\"Olive\",\"008000\":\"Green\",\"008080\":\"Teal\",\"0000FF\":\"Blue\",\"666699\":\"Grayish blue\",\"808080\":\"Gray\",FF0000:\"Red\",FF9900:\"Amber\",\"99CC00\":\"Yellow green\",\"339966\":\"Sea green\",\"33CCCC\":\"Turquoise\",\"3366FF\":\"Royal blue\",\"800080\":\"Purple\",\"999999\":\"Medium gray\",FF00FF:\"Magenta\",FFCC00:\"Gold\",FFFF00:\"Yellow\",\"00FF00\":\"Lime\",\"00FFFF\":\"Aqua\",\"00CCFF\":\"Sky blue\",\"993366\":\"Brown\",C0C0C0:\"Silver\",FF99CC:\"Pink\",FFCC99:\"Peach\",FFFF99:\"Light yellow\",CCFFCC:\"Pale green\",CCFFFF:\"Pale cyan\",\"99CCFF\":\"Light sky blue\",CC99FF:\"Plum\",FFFFFF:\"White\"},aria:{\"rich_text_area\":\"Rich Text Area\"},wordcount:{words:\"Words:\"}}});","Magento_Tinymce3/tiny_mce/classes/Editor.js":"/**\n * Editor.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\t// Shorten these names\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, extend = tinymce.extend,\n\t\tDispatcher = tinymce.util.Dispatcher, each = tinymce.each, isGecko = tinymce.isGecko,\n\t\tisIE = tinymce.isIE, isWebKit = tinymce.isWebKit, is = tinymce.is,\n\t\tThemeManager = tinymce.ThemeManager, PluginManager = tinymce.PluginManager,\n\t\tinArray = tinymce.inArray, grep = tinymce.grep, explode = tinymce.explode;\n\n\t/**\n\t * This class contains the core logic for a TinyMCE editor.\n\t *\n\t * @class tinymce.Editor\n\t * @example\n\t * // Add a class to all paragraphs in the editor.\n\t * tinyMCE.activeEditor.dom.addClass(tinyMCE.activeEditor.dom.select('p'), 'someclass');\n\t *\n\t * // Gets the current editors selection as text\n\t * tinyMCE.activeEditor.selection.getContent({format : 'text'});\n\t *\n\t * // Creates a new editor instance\n\t * var ed = new tinymce.Editor('textareaid', {\n\t *     some_setting : 1\n\t * });\n\t *\n\t * // Select each item the user clicks on\n\t * ed.onClick.add(function(ed, e) {\n\t *     ed.selection.select(e.target);\n\t * });\n\t *\n\t * ed.render();\n\t */\n\ttinymce.create('tinymce.Editor', {\n\t\t/**\n\t\t * Constructs a editor instance by id.\n\t\t *\n\t\t * @constructor\n\t\t * @method Editor\n\t\t * @param {String} id Unique id for the editor.\n\t\t * @param {Object} s Optional settings string for the editor.\n\t\t * @author Moxiecode\n\t\t */\n\t\tEditor : function(id, s) {\n\t\t\tvar t = this;\n\n\t\t\t/**\n\t\t\t * Editor instance id, normally the same as the div/textarea that was replaced.\n\t\t\t *\n\t\t\t * @property id\n\t\t\t * @type String\n\t\t\t */\n\t\t\tt.id = t.editorId = id;\n\n\t\t\tt.execCommands = {};\n\t\t\tt.queryStateCommands = {};\n\t\t\tt.queryValueCommands = {};\n\n\t\t\t/**\n\t\t\t * State to force the editor to return false on a isDirty call.\n\t\t\t *\n\t\t\t * @property isNotDirty\n\t\t\t * @type Boolean\n\t\t\t * @example\n\t\t\t * function ajaxSave() {\n\t\t\t *     var ed = tinyMCE.get('elm1');\n\t\t\t *\n\t\t\t *     // Save contents using some XHR call\n\t\t\t *     alert(ed.getContent());\n\t\t\t *\n\t\t\t *     ed.isNotDirty = 1; // Force not dirty state\n\t\t\t * }\n\t\t\t */\n\t\t\tt.isNotDirty = false;\n\n\t\t\t/**\n\t\t\t * Name/Value object containting plugin instances.\n\t\t\t *\n\t\t\t * @property plugins\n\t\t\t * @type Object\n\t\t\t * @example\n\t\t\t * // Execute a method inside a plugin directly\n\t\t\t * tinyMCE.activeEditor.plugins.someplugin.someMethod();\n\t\t\t */\n\t\t\tt.plugins = {};\n\n\t\t\t// Add events to the editor\n\t\t\teach([\n\t\t\t\t/**\n\t\t\t\t * Fires before the initialization of the editor.\n\t\t\t\t *\n\t\t\t\t * @event onPreInit\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @see #onInit\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onPreInit event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onPreInit.add(function(ed) {\n\t\t\t\t *           console.debug('PreInit: ' + ed.id);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onPreInit',\n\n\t\t\t\t/**\n\t\t\t\t * Fires before the initialization of the editor.\n\t\t\t\t *\n\t\t\t\t * @event onBeforeRenderUI\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onBeforeRenderUI event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n \t\t\t\t *      ed.onBeforeRenderUI.add(function(ed, cm) {\n \t\t\t\t *          console.debug('Before render: ' + ed.id);\n \t\t\t\t *      });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onBeforeRenderUI',\n\n\t\t\t\t/**\n\t\t\t\t * Fires after the rendering has completed.\n\t\t\t\t *\n\t\t\t\t * @event onPostRender\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onPostRender event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onPostRender.add(function(ed, cm) {\n\t\t\t\t *           console.debug('After render: ' + ed.id);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onPostRender',\n\n\t\t\t\t/**\n\t\t\t\t * Fires after the initialization of the editor is done.\n\t\t\t\t *\n\t\t\t\t * @event onInit\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @see #onPreInit\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onInit event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onInit.add(function(ed) {\n\t\t\t\t *           console.debug('Editor is done: ' + ed.id);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onInit',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when the editor instance is removed from page.\n\t\t\t\t *\n\t\t\t\t * @event onRemove\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onRemove event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onRemove.add(function(ed) {\n\t\t\t\t *           console.debug('Editor was removed: ' + ed.id);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onRemove',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when the editor is activated.\n\t\t\t\t *\n\t\t\t\t * @event onActivate\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onActivate event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onActivate.add(function(ed) {\n\t\t\t\t *           console.debug('Editor was activated: ' + ed.id);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onActivate',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when the editor is deactivated.\n\t\t\t\t *\n\t\t\t\t * @event onDeactivate\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onDeactivate event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onDeactivate.add(function(ed) {\n\t\t\t\t *           console.debug('Editor was deactivated: ' + ed.id);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onDeactivate',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when something in the body of the editor is clicked.\n\t\t\t\t *\n\t\t\t\t * @event onClick\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Event} evt W3C DOM Event instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onClick event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onClick.add(function(ed, e) {\n\t\t\t\t *           console.debug('Editor was clicked: ' + e.target.nodeName);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onClick',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when a registered event is intercepted.\n\t\t\t\t *\n\t\t\t\t * @event onEvent\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Event} evt W3C DOM Event instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onEvent event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onEvent.add(function(ed, e) {\n \t\t\t\t *          console.debug('Editor event occurred: ' + e.target.nodeName);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onEvent',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when a mouseup event is intercepted inside the editor.\n\t\t\t\t *\n\t\t\t\t * @event onMouseUp\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Event} evt W3C DOM Event instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onMouseUp event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onMouseUp.add(function(ed, e) {\n\t\t\t\t *           console.debug('Mouse up event: ' + e.target.nodeName);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onMouseUp',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when a mousedown event is intercepted inside the editor.\n\t\t\t\t *\n\t\t\t\t * @event onMouseDown\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Event} evt W3C DOM Event instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onMouseDown event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onMouseDown.add(function(ed, e) {\n\t\t\t\t *           console.debug('Mouse down event: ' + e.target.nodeName);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onMouseDown',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when a dblclick event is intercepted inside the editor.\n\t\t\t\t *\n\t\t\t\t * @event onDblClick\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Event} evt W3C DOM Event instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onDblClick event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onDblClick.add(function(ed, e) {\n \t\t\t\t *          console.debug('Double click event: ' + e.target.nodeName);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onDblClick',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when a keydown event is intercepted inside the editor.\n\t\t\t\t *\n\t\t\t\t * @event onKeyDown\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Event} evt W3C DOM Event instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onKeyDown event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onKeyDown.add(function(ed, e) {\n\t\t\t\t *           console.debug('Key down event: ' + e.keyCode);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onKeyDown',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when a keydown event is intercepted inside the editor.\n\t\t\t\t *\n\t\t\t\t * @event onKeyUp\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Event} evt W3C DOM Event instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onKeyUp event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onKeyUp.add(function(ed, e) {\n\t\t\t\t *           console.debug('Key up event: ' + e.keyCode);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onKeyUp',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when a keypress event is intercepted inside the editor.\n\t\t\t\t *\n\t\t\t\t * @event onKeyPress\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Event} evt W3C DOM Event instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onKeyPress event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onKeyPress.add(function(ed, e) {\n\t\t\t\t *           console.debug('Key press event: ' + e.keyCode);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onKeyPress',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when a contextmenu event is intercepted inside the editor.\n\t\t\t\t *\n\t\t\t\t * @event onContextMenu\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Event} evt W3C DOM Event instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onContextMenu event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onContextMenu.add(function(ed, e) {\n\t\t\t\t *            console.debug('Context menu event:' + e.target);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onContextMenu',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when a form submit event is intercepted.\n\t\t\t\t *\n\t\t\t\t * @event onSubmit\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Event} evt W3C DOM Event instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onSubmit event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onSubmit.add(function(ed, e) {\n\t\t\t\t *            console.debug('Form submit:' + e.target);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onSubmit',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when a form reset event is intercepted.\n\t\t\t\t *\n\t\t\t\t * @event onReset\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Event} evt W3C DOM Event instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onReset event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onReset.add(function(ed, e) {\n\t\t\t\t *            console.debug('Form reset:' + e.target);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onReset',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when a paste event is intercepted inside the editor.\n\t\t\t\t *\n\t\t\t\t * @event onPaste\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Event} evt W3C DOM Event instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onPaste event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onPaste.add(function(ed, e) {\n\t\t\t\t *            console.debug('Pasted plain text');\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onPaste',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when the Serializer does a preProcess on the contents.\n\t\t\t\t *\n\t\t\t\t * @event onPreProcess\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Object} obj PreProcess object.\n\t\t\t\t * @option {Node} node DOM node for the item being serialized.\n\t\t\t\t * @option {String} format The specified output format normally \"html\".\n\t\t\t\t * @option {Boolean} get Is true if the process is on a getContent operation.\n\t\t\t\t * @option {Boolean} set Is true if the process is on a setContent operation.\n\t\t\t\t * @option {Boolean} cleanup Is true if the process is on a cleanup operation.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onPreProcess event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onPreProcess.add(function(ed, o) {\n\t\t\t\t *            // Add a class to each paragraph in the editor\n\t\t\t\t *            ed.dom.addClass(ed.dom.select('p', o.node), 'myclass');\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onPreProcess',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when the Serializer does a postProcess on the contents.\n\t\t\t\t *\n\t\t\t\t * @event onPostProcess\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Object} obj PreProcess object.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onPostProcess event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onPostProcess.add(function(ed, o) {\n\t\t\t\t *            // Remove all paragraphs and replace with BR\n\t\t\t\t *            o.content = o.content.replace(/<p[^>]+>|<p>/g, '');\n\t\t\t\t *            o.content = o.content.replace(/<\\/p>/g, '<br />');\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onPostProcess',\n\n\t\t\t\t/**\n\t\t\t\t * Fires before new contents is added to the editor. Using for example setContent.\n\t\t\t\t *\n\t\t\t\t * @event onBeforeSetContent\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onBeforeSetContent event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onBeforeSetContent.add(function(ed, o) {\n\t\t\t\t *            // Replaces all a characters with b characters\n\t\t\t\t *            o.content = o.content.replace(/a/g, 'b');\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onBeforeSetContent',\n\n\t\t\t\t/**\n\t\t\t\t * Fires before contents is extracted from the editor using for example getContent.\n\t\t\t\t *\n\t\t\t\t * @event onBeforeGetContent\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Event} evt W3C DOM Event instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onBeforeGetContent event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onBeforeGetContent.add(function(ed, o) {\n\t\t\t\t *            console.debug('Before get content.');\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onBeforeGetContent',\n\n\t\t\t\t/**\n\t\t\t\t * Fires after the contents has been added to the editor using for example onSetContent.\n\t\t\t\t *\n\t\t\t\t * @event onSetContent\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onSetContent event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onSetContent.add(function(ed, o) {\n\t\t\t\t *            // Replaces all a characters with b characters\n\t\t\t\t *            o.content = o.content.replace(/a/g, 'b');\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onSetContent',\n\n\t\t\t\t/**\n\t\t\t\t * Fires after the contents has been extracted from the editor using for example getContent.\n\t\t\t\t *\n\t\t\t\t * @event onGetContent\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onGetContent event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onGetContent.add(function(ed, o) {\n\t\t\t\t *           // Replace all a characters with b\n\t\t\t\t *           o.content = o.content.replace(/a/g, 'b');\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onGetContent',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when the editor gets loaded with contents for example when the load method is executed.\n\t\t\t\t *\n\t\t\t\t * @event onLoadContent\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onLoadContent event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onLoadContent.add(function(ed, o) {\n\t\t\t\t *           // Output the element name\n\t\t\t\t *           console.debug(o.element.nodeName);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onLoadContent',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when the editor contents gets saved for example when the save method is executed.\n\t\t\t\t *\n\t\t\t\t * @event onSaveContent\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onSaveContent event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onSaveContent.add(function(ed, o) {\n\t\t\t\t *           // Output the element name\n\t\t\t\t *           console.debug(o.element.nodeName);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onSaveContent',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when the user changes node location using the mouse or keyboard.\n\t\t\t\t *\n\t\t\t\t * @event onNodeChange\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onNodeChange event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onNodeChange.add(function(ed, cm, e) {\n\t\t\t\t *           // Activates the link button when the caret is placed in a anchor element\n\t\t\t\t *           if (e.nodeName == 'A')\n\t\t\t\t *              cm.setActive('link', true);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onNodeChange',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when a new undo level is added to the editor.\n\t\t\t\t *\n\t\t\t\t * @event onChange\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onChange event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t * \t  ed.onChange.add(function(ed, l) {\n\t\t\t\t * \t\t  console.debug('Editor contents was modified. Contents: ' + l.content);\n\t\t\t\t * \t  });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onChange',\n\n\t\t\t\t/**\n\t\t\t\t * Fires before a command gets executed for example \"Bold\".\n\t\t\t\t *\n\t\t\t\t * @event onBeforeExecCommand\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onBeforeExecCommand event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onBeforeExecCommand.add(function(ed, cmd, ui, val) {\n\t\t\t\t *           console.debug('Command is to be executed: ' + cmd);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onBeforeExecCommand',\n\n\t\t\t\t/**\n\t\t\t\t * Fires after a command is executed for example \"Bold\".\n\t\t\t\t *\n\t\t\t\t * @event onExecCommand\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onExecCommand event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onExecCommand.add(function(ed, cmd, ui, val) {\n\t\t\t\t *           console.debug('Command was executed: ' + cmd);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onExecCommand',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when the contents is undo:ed.\n\t\t\t\t *\n\t\t\t\t * @event onUndo\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Object} level Undo level object.\n\t\t\t\t * @ example\n\t\t\t\t * // Adds an observer to the onUndo event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onUndo.add(function(ed, level) {\n\t\t\t\t *           console.debug('Undo was performed: ' + level.content);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onUndo',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when the contents is redo:ed.\n\t\t\t\t *\n\t\t\t\t * @event onRedo\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @param {Object} level Undo level object.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onRedo event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onRedo.add(function(ed, level) {\n\t\t\t\t *           console.debug('Redo was performed: ' +level.content);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onRedo',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when visual aids is enabled/disabled.\n\t\t\t\t *\n\t\t\t\t * @event onVisualAid\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onVisualAid event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onVisualAid.add(function(ed, e, s) {\n\t\t\t\t *           console.debug('onVisualAid event: ' + ed.id + \", State: \" + s);\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onVisualAid',\n\n\t\t\t\t/**\n\t\t\t\t * Fires when the progress throbber is shown above the editor.\n\t\t\t\t *\n\t\t\t\t * @event onSetProgressState\n\t\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t\t * @example\n\t\t\t\t * // Adds an observer to the onSetProgressState event using tinyMCE.init\n\t\t\t\t * tinyMCE.init({\n\t\t\t\t *    ...\n\t\t\t\t *    setup : function(ed) {\n\t\t\t\t *       ed.onSetProgressState.add(function(ed, b) {\n\t\t\t\t *            if (b)\n\t\t\t\t *                 console.debug('SHOW!');\n\t\t\t\t *            else\n\t\t\t\t *                 console.debug('HIDE!');\n\t\t\t\t *       });\n\t\t\t\t *    }\n\t\t\t\t * });\n\t\t\t\t */\n\t\t\t\t'onSetProgressState'\n\t\t\t], function(e) {\n\t\t\t\tt[e] = new Dispatcher(t);\n\t\t\t});\n\n\t\t\t/**\n\t\t\t * Name/value collection with editor settings.\n\t\t\t *\n\t\t\t * @property settings\n\t\t\t * @type Object\n\t\t\t * @example\n\t\t\t * // Get the value of the theme setting\n\t\t\t * tinyMCE.activeEditor.windowManager.alert(\"You are using the \" + tinyMCE.activeEditor.settings.theme + \" theme\");\n\t\t\t */\n\t\t\tt.settings = s = extend({\n\t\t\t\tid : id,\n\t\t\t\tlanguage : 'en',\n\t\t\t\tdocs_language : 'en',\n\t\t\t\ttheme : 'simple',\n\t\t\t\tskin : 'default',\n\t\t\t\tdelta_width : 0,\n\t\t\t\tdelta_height : 0,\n\t\t\t\tpopup_css : '',\n\t\t\t\tplugins : '',\n\t\t\t\tdocument_base_url : tinymce.documentBaseURL,\n\t\t\t\tadd_form_submit_trigger : 1,\n\t\t\t\tsubmit_patch : 1,\n\t\t\t\tadd_unload_trigger : 1,\n\t\t\t\tconvert_urls : 1,\n\t\t\t\trelative_urls : 1,\n\t\t\t\tremove_script_host : 1,\n\t\t\t\ttable_inline_editing : 0,\n\t\t\t\tobject_resizing : 1,\n\t\t\t\tcleanup : 1,\n\t\t\t\taccessibility_focus : 1,\n\t\t\t\tcustom_shortcuts : 1,\n\t\t\t\tcustom_undo_redo_keyboard_shortcuts : 1,\n\t\t\t\tcustom_undo_redo_restore_selection : 1,\n\t\t\t\tcustom_undo_redo : 1,\n\t\t\t\tdoctype : tinymce.isIE6 ? '<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">' : '<!DOCTYPE>', // Use old doctype on IE 6 to avoid horizontal scroll\n\t\t\t\tvisual_table_class : 'mceItemTable',\n\t\t\t\tvisual : 1,\n\t\t\t\tfont_size_style_values : 'xx-small,x-small,small,medium,large,x-large,xx-large',\n\t\t\t\tfont_size_legacy_values : 'xx-small,small,medium,large,x-large,xx-large,300%', // See: http://www.w3.org/TR/CSS2/fonts.html#propdef-font-size\n\t\t\t\tapply_source_formatting : 1,\n\t\t\t\tdirectionality : 'ltr',\n\t\t\t\tforced_root_block : 'p',\n\t\t\t\thidden_input : 1,\n\t\t\t\tpadd_empty_editor : 1,\n\t\t\t\trender_ui : 1,\n\t\t\t\tinit_theme : 1,\n\t\t\t\tforce_p_newlines : 1,\n\t\t\t\tindentation : '30px',\n\t\t\t\tkeep_styles : 1,\n\t\t\t\tfix_table_elements : 1,\n\t\t\t\tinline_styles : 1,\n\t\t\t\tconvert_fonts_to_spans : true,\n\t\t\t\tindent : 'simple',\n\t\t\t\tindent_before : 'p,h1,h2,h3,h4,h5,h6,blockquote,div,title,style,pre,script,td,ul,li,area,table,thead,tfoot,tbody,tr',\n\t\t\t\tindent_after : 'p,h1,h2,h3,h4,h5,h6,blockquote,div,title,style,pre,script,td,ul,li,area,table,thead,tfoot,tbody,tr',\n\t\t\t\tvalidate : true,\n\t\t\t\tentity_encoding : 'named',\n\t\t\t\turl_converter : t.convertURL,\n\t\t\t\turl_converter_scope : t,\n\t\t\t\tie7_compat : true\n\t\t\t}, s);\n\n\t\t\t/**\n\t\t\t * URI object to document configured for the TinyMCE instance.\n\t\t\t *\n\t\t\t * @property documentBaseURI\n\t\t\t * @type tinymce.util.URI\n\t\t\t * @example\n\t\t\t * // Get relative URL from the location of document_base_url\n\t\t\t * tinyMCE.activeEditor.documentBaseURI.toRelative('/somedir/somefile.htm');\n\t\t\t *\n\t\t\t * // Get absolute URL from the location of document_base_url\n\t\t\t * tinyMCE.activeEditor.documentBaseURI.toAbsolute('somefile.htm');\n\t\t\t */\n\t\t\tt.documentBaseURI = new tinymce.util.URI(s.document_base_url || tinymce.documentBaseURL, {\n\t\t\t\tbase_uri : tinyMCE.baseURI\n\t\t\t});\n\n\t\t\t/**\n\t\t\t * URI object to current document that holds the TinyMCE editor instance.\n\t\t\t *\n\t\t\t * @property baseURI\n\t\t\t * @type tinymce.util.URI\n\t\t\t * @example\n\t\t\t * // Get relative URL from the location of the API\n\t\t\t * tinyMCE.activeEditor.baseURI.toRelative('/somedir/somefile.htm');\n\t\t\t *\n\t\t\t * // Get absolute URL from the location of the API\n\t\t\t * tinyMCE.activeEditor.baseURI.toAbsolute('somefile.htm');\n\t\t\t */\n\t\t\tt.baseURI = tinymce.baseURI;\n\n\t\t\t/**\n\t\t\t * Array with CSS files to load into the iframe.\n\t\t\t *\n\t\t\t * @property contentCSS\n\t\t\t * @type Array\n\t\t\t */\n\t\t\tt.contentCSS = [];\n\n\t\t\t// Call setup\n\t\t\tt.execCallback('setup', t);\n\t\t},\n\n\t\t/**\n\t\t * Renderes the editor/adds it to the page.\n\t\t *\n\t\t * @method render\n\t\t */\n\t\trender : function(nst) {\n\t\t\tvar t = this, s = t.settings, id = t.id, sl = tinymce.ScriptLoader;\n\n\t\t\t// Page is not loaded yet, wait for it\n\t\t\tif (!Event.domLoaded) {\n\t\t\t\tEvent.add(document, 'init', function() {\n\t\t\t\t\tt.render();\n\t\t\t\t});\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\ttinyMCE.settings = s;\n\n\t\t\t// Element not found, then skip initialization\n\t\t\tif (!t.getElement())\n\t\t\t\treturn;\n\n\t\t\t// Is a iPad/iPhone and not on iOS5, then skip initialization. We need to sniff\n\t\t\t// here since the browser says it has contentEditable support but there is no visible\n\t\t\t// caret We will remove this check ones Apple implements full contentEditable support\n\t\t\tif (tinymce.isIDevice && !tinymce.isIOS5)\n\t\t\t\treturn;\n\n\t\t\t// Add hidden input for non input elements inside form elements\n\t\t\tif (!/TEXTAREA|INPUT/i.test(t.getElement().nodeName) && s.hidden_input && DOM.getParent(id, 'form'))\n\t\t\t\tDOM.insertAfter(DOM.create('input', {type : 'hidden', name : id}), id);\n\n\t\t\t/**\n\t\t\t * Window manager reference, use this to open new windows and dialogs.\n\t\t\t *\n\t\t\t * @property windowManager\n\t\t\t * @type tinymce.WindowManager\n\t\t\t * @example\n\t\t\t * // Shows an alert message\n\t\t\t * tinyMCE.activeEditor.windowManager.alert('Hello world!');\n\t\t\t *\n\t\t\t * // Opens a new dialog with the file.htm file and the size 320x240\n\t\t\t * // It also adds a custom parameter this can be retrieved by using tinyMCEPopup.getWindowArg inside the dialog.\n\t\t\t * tinyMCE.activeEditor.windowManager.open({\n\t\t\t *    url : 'file.htm',\n\t\t\t *    width : 320,\n\t\t\t *    height : 240\n\t\t\t * }, {\n\t\t\t *    custom_param : 1\n\t\t\t * });\n\t\t\t */\n\t\t\tif (tinymce.WindowManager)\n\t\t\t\tt.windowManager = new tinymce.WindowManager(t);\n\n\t\t\tif (s.encoding == 'xml') {\n\t\t\t\tt.onGetContent.add(function(ed, o) {\n\t\t\t\t\tif (o.save)\n\t\t\t\t\t\to.content = DOM.encode(o.content);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.add_form_submit_trigger) {\n\t\t\t\tt.onSubmit.addToTop(function() {\n\t\t\t\t\tif (t.initialized) {\n\t\t\t\t\t\tt.save();\n\t\t\t\t\t\tt.isNotDirty = 1;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.add_unload_trigger) {\n\t\t\t\tt._beforeUnload = tinyMCE.onBeforeUnload.add(function() {\n\t\t\t\t\tif (t.initialized && !t.destroyed && !t.isHidden())\n\t\t\t\t\t\tt.save({format : 'raw', no_events : true});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\ttinymce.addUnload(t.destroy, t);\n\n\t\t\tif (s.submit_patch) {\n\t\t\t\tt.onBeforeRenderUI.add(function() {\n\t\t\t\t\tvar n = t.getElement().form;\n\n\t\t\t\t\tif (!n)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Already patched\n\t\t\t\t\tif (n._mceOldSubmit)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Check page uses id=\"submit\" or name=\"submit\" for it's submit button\n\t\t\t\t\tif (!n.submit.nodeType && !n.submit.length) {\n\t\t\t\t\t\tt.formElement = n;\n\t\t\t\t\t\tn._mceOldSubmit = n.submit;\n\t\t\t\t\t\tn.submit = function() {\n\t\t\t\t\t\t\t// Save all instances\n\t\t\t\t\t\t\ttinymce.triggerSave();\n\t\t\t\t\t\t\tt.isNotDirty = 1;\n\n\t\t\t\t\t\t\treturn t.formElement._mceOldSubmit(t.formElement);\n\t\t\t\t\t\t};\n\t\t\t\t\t}\n\n\t\t\t\t\tn = null;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Load scripts\n\t\t\tfunction loadScripts() {\n\t\t\t\tif (s.language && s.language_load !== false)\n\t\t\t\t\tsl.add(tinymce.baseURL + '/langs/' + s.language + '.js');\n\n\t\t\t\tif (s.theme && s.theme.charAt(0) != '-' && !ThemeManager.urls[s.theme])\n\t\t\t\t\tThemeManager.load(s.theme, 'themes/' + s.theme + '/editor_template' + tinymce.suffix + '.js');\n\n\t\t\t\teach(explode(s.plugins), function(p) {\n\t\t\t\t\tif (p &&!PluginManager.urls[p]) {\n\t\t\t\t\t\tif (p.charAt(0) == '-') {\n\t\t\t\t\t\t\tp = p.substr(1, p.length);\n\t\t\t\t\t\t\tvar dependencies = PluginManager.dependencies(p);\n\t\t\t\t\t\t\teach(dependencies, function(dep) {\n\t\t\t\t\t\t\t\tvar defaultSettings = {prefix:'plugins/', resource: dep, suffix:'/editor_plugin' + tinymce.suffix + '.js'};\n\t\t\t\t\t\t\t\tvar dep = PluginManager.createUrl(defaultSettings, dep);\n\t\t\t\t\t\t\t\tPluginManager.load(dep.resource, dep);\n\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Skip safari plugin, since it is removed as of 3.3b1\n\t\t\t\t\t\t\tif (p == 'safari') {\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tPluginManager.load(p, {prefix:'plugins/', resource: p, suffix:'/editor_plugin' + tinymce.suffix + '.js'});\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// Init when que is loaded\n\t\t\t\tsl.loadQueue(function() {\n\t\t\t\t\tif (!t.removed)\n\t\t\t\t\t\tt.init();\n\t\t\t\t});\n\t\t\t};\n\n\t\t\tloadScripts();\n\t\t},\n\n\t\t/**\n\t\t * Initializes the editor this will be called automatically when\n\t\t * all plugins/themes and language packs are loaded by the rendered method.\n\t\t * This method will setup the iframe and create the theme and plugin instances.\n\t\t *\n\t\t * @method init\n\t\t */\n\t\tinit : function() {\n\t\t\tvar n, t = this, s = t.settings, w, h, e = t.getElement(), o, ti, u, bi, bc, re, i, initializedPlugins = [];\n\n\t\t\ttinymce.add(t);\n\n\t\t\ts.aria_label = s.aria_label || DOM.getAttrib(e, 'aria-label', t.getLang('aria.rich_text_area'));\n\n\t\t\t/**\n\t\t\t * Reference to the theme instance that was used to generate the UI.\n\t\t\t *\n\t\t\t * @property theme\n\t\t\t * @type tinymce.Theme\n\t\t\t * @example\n\t\t\t * // Executes a method on the theme directly\n\t\t\t * tinyMCE.activeEditor.theme.someMethod();\n\t\t\t */\n\t\t\tif (s.theme) {\n\t\t\t\ts.theme = s.theme.replace(/-/, '');\n\t\t\t\to = ThemeManager.get(s.theme);\n\t\t\t\tt.theme = new o();\n\n\t\t\t\tif (t.theme.init && s.init_theme)\n\t\t\t\t\tt.theme.init(t, ThemeManager.urls[s.theme] || tinymce.documentBaseURL.replace(/\\/$/, ''));\n\t\t\t}\n\t\t\tfunction initPlugin(p) {\n\t\t\t\tvar c = PluginManager.get(p), u = PluginManager.urls[p] || tinymce.documentBaseURL.replace(/\\/$/, ''), po;\n\t\t\t\tif (c && tinymce.inArray(initializedPlugins,p) === -1) {\n\t\t\t\t\teach(PluginManager.dependencies(p), function(dep){\n\t\t\t\t\t\tinitPlugin(dep);\n\t\t\t\t\t});\n\t\t\t\t\tpo = new c(t, u);\n\n\t\t\t\t\tt.plugins[p] = po;\n\n\t\t\t\t\tif (po.init) {\n\t\t\t\t\t\tpo.init(t, u);\n\t\t\t\t\t\tinitializedPlugins.push(p);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Create all plugins\n\t\t\teach(explode(s.plugins.replace(/\\-/g, '')), initPlugin);\n\n\t\t\t// Setup popup CSS path(s)\n\t\t\tif (s.popup_css !== false) {\n\t\t\t\tif (s.popup_css)\n\t\t\t\t\ts.popup_css = t.documentBaseURI.toAbsolute(s.popup_css);\n\t\t\t\telse\n\t\t\t\t\ts.popup_css = t.baseURI.toAbsolute(\"themes/\" + s.theme + \"/skins/\" + s.skin + \"/dialog.css\");\n\t\t\t}\n\n\t\t\tif (s.popup_css_add)\n\t\t\t\ts.popup_css += ',' + t.documentBaseURI.toAbsolute(s.popup_css_add);\n\n\t\t\t/**\n\t\t\t * Control manager instance for the editor. Will enables you to create new UI elements and change their states etc.\n\t\t\t *\n\t\t\t * @property controlManager\n\t\t\t * @type tinymce.ControlManager\n\t\t\t * @example\n\t\t\t * // Disables the bold button\n\t\t\t * tinyMCE.activeEditor.controlManager.setDisabled('bold', true);\n\t\t\t */\n\t\t\tt.controlManager = new tinymce.ControlManager(t);\n\n\t\t\tif (s.custom_undo_redo) {\n\t\t\t\tt.onBeforeExecCommand.add(function(ed, cmd, ui, val, a) {\n\t\t\t\t\tif (cmd != 'Undo' && cmd != 'Redo' && cmd != 'mceRepaint' && (!a || !a.skip_undo))\n\t\t\t\t\t\tt.undoManager.beforeChange();\n\t\t\t\t});\n\n\t\t\t\tt.onExecCommand.add(function(ed, cmd, ui, val, a) {\n\t\t\t\t\tif (cmd != 'Undo' && cmd != 'Redo' && cmd != 'mceRepaint' && (!a || !a.skip_undo))\n\t\t\t\t\t\tt.undoManager.add();\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tt.onExecCommand.add(function(ed, c) {\n\t\t\t\t// Don't refresh the select lists until caret move\n\t\t\t\tif (!/^(FontName|FontSize)$/.test(c))\n\t\t\t\t\tt.nodeChanged();\n\t\t\t});\n\n\t\t\t// Remove ghost selections on images and tables in Gecko\n\t\t\tif (isGecko) {\n\t\t\t\tfunction repaint(a, o) {\n\t\t\t\t\tif (!o || !o.initial)\n\t\t\t\t\t\tt.execCommand('mceRepaint');\n\t\t\t\t};\n\n\t\t\t\tt.onUndo.add(repaint);\n\t\t\t\tt.onRedo.add(repaint);\n\t\t\t\tt.onSetContent.add(repaint);\n\t\t\t}\n\n\t\t\t// Enables users to override the control factory\n\t\t\tt.onBeforeRenderUI.dispatch(t, t.controlManager);\n\n\t\t\t// Measure box\n\t\t\tif (s.render_ui) {\n\t\t\t\tw = s.width || e.style.width || e.offsetWidth;\n\t\t\t\th = s.height || e.style.height || e.offsetHeight;\n\t\t\t\tt.orgDisplay = e.style.display;\n\t\t\t\tre = /^[0-9\\.]+(|px)$/i;\n\n\t\t\t\tif (re.test('' + w))\n\t\t\t\t\tw = Math.max(parseInt(w) + (o.deltaWidth || 0), 100);\n\n\t\t\t\tif (re.test('' + h))\n\t\t\t\t\th = Math.max(parseInt(h) + (o.deltaHeight || 0), 100);\n\n\t\t\t\t// Render UI\n\t\t\t\to = t.theme.renderUI({\n\t\t\t\t\ttargetNode : e,\n\t\t\t\t\twidth : w,\n\t\t\t\t\theight : h,\n\t\t\t\t\tdeltaWidth : s.delta_width,\n\t\t\t\t\tdeltaHeight : s.delta_height\n\t\t\t\t});\n\n\t\t\t\tt.editorContainer = o.editorContainer;\n\t\t\t}\n\n\t\t\t// #ifdef contentEditable\n\n\t\t\t// Content editable mode ends here\n\t\t\tif (s.content_editable) {\n\t\t\t\te = n = o = null; // Fix IE leak\n\t\t\t\treturn t.setupContentEditable();\n\t\t\t}\n\n\t\t\t// #endif\n\n\t\t\t// User specified a document.domain value\n\t\t\tif (document.domain && location.hostname != document.domain)\n\t\t\t\ttinymce.relaxedDomain = document.domain;\n\n\t\t\t// Resize editor\n\t\t\tDOM.setStyles(o.sizeContainer || o.editorContainer, {\n\t\t\t\twidth : w,\n\t\t\t\theight : h\n\t\t\t});\n\n\t\t\t// Load specified content CSS last\n\t\t\tif (s.content_css) {\n\t\t\t\ttinymce.each(explode(s.content_css), function(u) {\n\t\t\t\t\tt.contentCSS.push(t.documentBaseURI.toAbsolute(u));\n\t\t\t\t});\n\t\t\t}\n\n\t\t\th = (o.iframeHeight || h) + (typeof(h) == 'number' ? (o.deltaHeight || 0) : '');\n\t\t\tif (h < 100)\n\t\t\t\th = 100;\n\n\t\t\tt.iframeHTML = s.doctype + '<html><head xmlns=\"http://www.w3.org/1999/xhtml\">';\n\n\t\t\t// We only need to override paths if we have to\n\t\t\t// IE has a bug where it remove site absolute urls to relative ones if this is specified\n\t\t\tif (s.document_base_url != tinymce.documentBaseURL)\n\t\t\t\tt.iframeHTML += '<base href=\"' + t.documentBaseURI.getURI() + '\" />';\n\n\t\t\t// IE8 doesn't support carets behind images setting ie7_compat would force IE8+ to run in IE7 compat mode.\n\t\t\tif (s.ie7_compat)\n\t\t\t\tt.iframeHTML += '<meta http-equiv=\"X-UA-Compatible\" content=\"IE=7\" />';\n\t\t\telse\n\t\t\t\tt.iframeHTML += '<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />';\n\n\t\t\tt.iframeHTML += '<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />';\n\n\t\t\t// Load the CSS by injecting them into the HTML this will reduce \"flicker\"\n\t\t\tfor (i = 0; i < t.contentCSS.length; i++) {\n\t\t\t\tt.iframeHTML += '<link type=\"text/css\" rel=\"stylesheet\" href=\"' + t.contentCSS[i] + '\" />';\n\t\t\t}\n\n\t\t\tbi = s.body_id || 'tinymce';\n\t\t\tif (bi.indexOf('=') != -1) {\n\t\t\t\tbi = t.getParam('body_id', '', 'hash');\n\t\t\t\tbi = bi[t.id] || bi;\n\t\t\t}\n\n\t\t\tbc = s.body_class || '';\n\t\t\tif (bc.indexOf('=') != -1) {\n\t\t\t\tbc = t.getParam('body_class', '', 'hash');\n\t\t\t\tbc = bc[t.id] || '';\n\t\t\t}\n\n\t\t\tt.iframeHTML += '</head><body id=\"' + bi + '\" class=\"mceContentBody ' + bc + '\"><br></body></html>';\n\n\t\t\t// Domain relaxing enabled, then set document domain\n\t\t\tif (tinymce.relaxedDomain && (isIE || (tinymce.isOpera && parseFloat(opera.version()) < 11))) {\n\t\t\t\t// We need to write the contents here in IE since multiple writes messes up refresh button and back button\n\t\t\t\tu = 'javascript:(function(){document.open();document.domain=\"' + document.domain + '\";var ed = window.parent.tinyMCE.get(\"' + t.id + '\");document.write(ed.iframeHTML);document.close();ed.setupIframe();})()';\n\t\t\t}\n\n\t\t\t// Create iframe\n\t\t\t// TODO: ACC add the appropriate description on this.\n\t\t\tn = DOM.add(o.iframeContainer, 'iframe', {\n\t\t\t\tid : t.id + \"_ifr\",\n\t\t\t\tsrc : u || 'javascript:\"\"', // Workaround for HTTPS warning in IE6/7\n\t\t\t\tframeBorder : '0',\n\t\t\t\tallowTransparency : \"true\",\n\t\t\t\ttitle : s.aria_label,\n\t\t\t\tstyle : {\n\t\t\t\t\twidth : '100%',\n\t\t\t\t\theight : h,\n\t\t\t\t\tdisplay : 'block' // Important for Gecko to render the iframe correctly\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.contentAreaContainer = o.iframeContainer;\n\t\t\tDOM.get(o.editorContainer).style.display = t.orgDisplay;\n\t\t\tDOM.get(t.id).style.display = 'none';\n\t\t\tDOM.setAttrib(t.id, 'aria-hidden', true);\n\n\t\t\tif (!tinymce.relaxedDomain || !u)\n\t\t\t\tt.setupIframe();\n\n\t\t\te = n = o = null; // Cleanup\n\t\t},\n\n\t\t/**\n\t\t * This method get called by the init method ones the iframe is loaded.\n\t\t * It will fill the iframe with contents, setups DOM and selection objects for the iframe.\n\t\t * This method should not be called directly.\n\t\t *\n\t\t * @method setupIframe\n\t\t */\n\t\tsetupIframe : function() {\n\t\t\tvar t = this, s = t.settings, e = DOM.get(t.id), d = t.getDoc(), h, b;\n\n\t\t\t// Setup iframe body\n\t\t\tif (!isIE || !tinymce.relaxedDomain) {\n\t\t\t\td.open();\n\t\t\t\td.write(t.iframeHTML);\n\t\t\t\td.close();\n\n\t\t\t\tif (tinymce.relaxedDomain)\n\t\t\t\t\td.domain = tinymce.relaxedDomain;\n\t\t\t}\n\n\t\t\t// It will not steal focus while setting contentEditable\n\t\t\tb = t.getBody();\n\t\t\tb.disabled = true;\n\n\t\t\tif (!s.readonly)\n\t\t\t\tb.contentEditable = true;\n\n\t\t\tb.disabled = false;\n\n\t\t\t/**\n\t\t\t * Schema instance, enables you to validate elements and it's children.\n\t\t\t *\n\t\t\t * @property schema\n\t\t\t * @type tinymce.html.Schema\n\t\t\t */\n\t\t\tt.schema = new tinymce.html.Schema(s);\n\n\t\t\t/**\n\t\t\t * DOM instance for the editor.\n\t\t\t *\n\t\t\t * @property dom\n\t\t\t * @type tinymce.dom.DOMUtils\n\t\t\t * @example\n\t\t\t * // Adds a class to all paragraphs within the editor\n\t\t\t * tinyMCE.activeEditor.dom.addClass(tinyMCE.activeEditor.dom.select('p'), 'someclass');\n\t\t\t */\n\t\t\tt.dom = new tinymce.dom.DOMUtils(t.getDoc(), {\n\t\t\t\tkeep_values : true,\n\t\t\t\turl_converter : t.convertURL,\n\t\t\t\turl_converter_scope : t,\n\t\t\t\thex_colors : s.force_hex_style_colors,\n\t\t\t\tclass_filter : s.class_filter,\n\t\t\t\tupdate_styles : 1,\n\t\t\t\tfix_ie_paragraphs : 1,\n\t\t\t\tschema : t.schema\n\t\t\t});\n\n\t\t\t/**\n\t\t\t * HTML parser will be used when contents is inserted into the editor.\n\t\t\t *\n\t\t\t * @property parser\n\t\t\t * @type tinymce.html.DomParser\n\t\t\t */\n\t\t\tt.parser = new tinymce.html.DomParser(s, t.schema);\n\n\t\t\t// Force anchor names closed, unless the setting \"allow_html_in_named_anchor\" is explicitly included.\n\t\t\tif (!t.settings.allow_html_in_named_anchor) {\n\t\t\t\tt.parser.addAttributeFilter('name', function(nodes, name) {\n\t\t\t\t\tvar i = nodes.length, sibling, prevSibling, parent, node;\n\n\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\t\tif (node.name === 'a' && node.firstChild) {\n\t\t\t\t\t\t\tparent = node.parent;\n\n\t\t\t\t\t\t\t// Move children after current node\n\t\t\t\t\t\t\tsibling = node.lastChild;\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\tprevSibling = sibling.prev;\n\t\t\t\t\t\t\t\tparent.insert(sibling, node);\n\t\t\t\t\t\t\t\tsibling = prevSibling;\n\t\t\t\t\t\t\t} while (sibling);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Convert src and href into data-mce-src, data-mce-href and data-mce-style\n\t\t\tt.parser.addAttributeFilter('src,href,style', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node, dom = t.dom, value, internalName;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tvalue = node.attr(name);\n\t\t\t\t\tinternalName = 'data-mce-' + name;\n\n\t\t\t\t\t// Add internal attribute if we need to we don't on a refresh of the document\n\t\t\t\t\tif (!node.attributes.map[internalName]) {\n\t\t\t\t\t\tif (name === \"style\")\n\t\t\t\t\t\t\tnode.attr(internalName, dom.serializeStyle(dom.parseStyle(value), node.name));\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tnode.attr(internalName, t.convertURL(value, name, node.name));\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Keep scripts from executing\n\t\t\tt.parser.addNodeFilter('script', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tnode.attr('type', 'mce-' + (node.attr('type') || 'text/javascript'));\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.parser.addNodeFilter('#cdata', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tnode.type = 8;\n\t\t\t\t\tnode.name = '#comment';\n\t\t\t\t\tnode.value = '[CDATA[' + node.value + ']]';\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.parser.addNodeFilter('p,h1,h2,h3,h4,h5,h6,div', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node, nonEmptyElements = t.schema.getNonEmptyElements();\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\n\t\t\t\t\tif (node.isEmpty(nonEmptyElements))\n\t\t\t\t\t\tnode.empty().append(new tinymce.html.Node('br', 1)).shortEnded = true;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t/**\n\t\t\t * DOM serializer for the editor. Will be used when contents is extracted from the editor.\n\t\t\t *\n\t\t\t * @property serializer\n\t\t\t * @type tinymce.dom.Serializer\n\t\t\t * @example\n\t\t\t * // Serializes the first paragraph in the editor into a string\n\t\t\t * tinyMCE.activeEditor.serializer.serialize(tinyMCE.activeEditor.dom.select('p')[0]);\n\t\t\t */\n\t\t\tt.serializer = new tinymce.dom.Serializer(s, t.dom, t.schema);\n\n\t\t\t/**\n\t\t\t * Selection instance for the editor.\n\t\t\t *\n\t\t\t * @property selection\n\t\t\t * @type tinymce.dom.Selection\n\t\t\t * @example\n\t\t\t * // Sets some contents to the current selection in the editor\n\t\t\t * tinyMCE.activeEditor.selection.setContent('Some contents');\n\t\t\t *\n\t\t\t * // Gets the current selection\n\t\t\t * alert(tinyMCE.activeEditor.selection.getContent());\n\t\t\t *\n\t\t\t * // Selects the first paragraph found\n\t\t\t * tinyMCE.activeEditor.selection.select(tinyMCE.activeEditor.dom.select('p')[0]);\n\t\t\t */\n\t\t\tt.selection = new tinymce.dom.Selection(t.dom, t.getWin(), t.serializer);\n\n\t\t\t/**\n\t\t\t * Formatter instance.\n\t\t\t *\n\t\t\t * @property formatter\n\t\t\t * @type tinymce.Formatter\n\t\t\t */\n\t\t\tt.formatter = new tinymce.Formatter(this);\n\n\t\t\t// Register default formats\n\t\t\tt.formatter.register({\n\t\t\t\talignleft : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'left'}},\n\t\t\t\t\t{selector : 'img,table', collapsed : false, styles : {'float' : 'left'}}\n\t\t\t\t],\n\n\t\t\t\taligncenter : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'center'}},\n\t\t\t\t\t{selector : 'img', collapsed : false, styles : {display : 'block', marginLeft : 'auto', marginRight : 'auto'}},\n\t\t\t\t\t{selector : 'table', collapsed : false, styles : {marginLeft : 'auto', marginRight : 'auto'}}\n\t\t\t\t],\n\n\t\t\t\talignright : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'right'}},\n\t\t\t\t\t{selector : 'img,table', collapsed : false, styles : {'float' : 'right'}}\n\t\t\t\t],\n\n\t\t\t\talignfull : [\n\t\t\t\t\t{selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li', styles : {textAlign : 'justify'}}\n\t\t\t\t],\n\n\t\t\t\tbold : [\n\t\t\t\t\t{inline : 'strong', remove : 'all'},\n\t\t\t\t\t{inline : 'span', styles : {fontWeight : 'bold'}},\n\t\t\t\t\t{inline : 'b', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\titalic : [\n\t\t\t\t\t{inline : 'em', remove : 'all'},\n\t\t\t\t\t{inline : 'span', styles : {fontStyle : 'italic'}},\n\t\t\t\t\t{inline : 'i', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\tunderline : [\n\t\t\t\t\t{inline : 'span', styles : {textDecoration : 'underline'}, exact : true},\n\t\t\t\t\t{inline : 'u', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\tstrikethrough : [\n\t\t\t\t\t{inline : 'span', styles : {textDecoration : 'line-through'}, exact : true},\n\t\t\t\t\t{inline : 'strike', remove : 'all'}\n\t\t\t\t],\n\n\t\t\t\tforecolor : {inline : 'span', styles : {color : '%value'}, wrap_links : false},\n\t\t\t\thilitecolor : {inline : 'span', styles : {backgroundColor : '%value'}, wrap_links : false},\n\t\t\t\tfontname : {inline : 'span', styles : {fontFamily : '%value'}},\n\t\t\t\tfontsize : {inline : 'span', styles : {fontSize : '%value'}},\n\t\t\t\tfontsize_class : {inline : 'span', attributes : {'class' : '%value'}},\n\t\t\t\tblockquote : {block : 'blockquote', wrapper : 1, remove : 'all'},\n\t\t\t\tsubscript : {inline : 'sub'},\n\t\t\t\tsuperscript : {inline : 'sup'},\n\n\t\t\t\tlink : {inline : 'a', selector : 'a', remove : 'all', split : true, deep : true,\n\t\t\t\t\tonmatch : function(node) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t},\n\n\t\t\t\t\tonformat : function(elm, fmt, vars) {\n\t\t\t\t\t\teach(vars, function(value, key) {\n\t\t\t\t\t\t\tt.dom.setAttrib(elm, key, value);\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tremoveformat : [\n\t\t\t\t\t{selector : 'b,strong,em,i,font,u,strike', remove : 'all', split : true, expand : false, block_expand : true, deep : true},\n\t\t\t\t\t{selector : 'span', attributes : ['style', 'class'], remove : 'empty', split : true, expand : false, deep : true},\n\t\t\t\t\t{selector : '*', attributes : ['style', 'class'], split : false, expand : false, deep : true}\n\t\t\t\t]\n\t\t\t});\n\n\t\t\t// Register default block formats\n\t\t\teach('p h1 h2 h3 h4 h5 h6 div address pre div code dt dd samp'.split(/\\s/), function(name) {\n\t\t\t\tt.formatter.register(name, {block : name, remove : 'all'});\n\t\t\t});\n\n\t\t\t// Register user defined formats\n\t\t\tt.formatter.register(t.settings.formats);\n\n\t\t\t/**\n\t\t\t * Undo manager instance, responsible for handling undo levels.\n\t\t\t *\n\t\t\t * @property undoManager\n\t\t\t * @type tinymce.UndoManager\n\t\t\t * @example\n\t\t\t * // Undoes the last modification to the editor\n\t\t\t * tinyMCE.activeEditor.undoManager.undo();\n\t\t\t */\n\t\t\tt.undoManager = new tinymce.UndoManager(t);\n\n\t\t\t// Pass through\n\t\t\tt.undoManager.onAdd.add(function(um, l) {\n\t\t\t\tif (um.hasUndo())\n\t\t\t\t\treturn t.onChange.dispatch(t, l, um);\n\t\t\t});\n\n\t\t\tt.undoManager.onUndo.add(function(um, l) {\n\t\t\t\treturn t.onUndo.dispatch(t, l, um);\n\t\t\t});\n\n\t\t\tt.undoManager.onRedo.add(function(um, l) {\n\t\t\t\treturn t.onRedo.dispatch(t, l, um);\n\t\t\t});\n\n\t\t\tt.forceBlocks = new tinymce.ForceBlocks(t, {\n\t\t\t\tforced_root_block : s.forced_root_block\n\t\t\t});\n\n\t\t\tt.editorCommands = new tinymce.EditorCommands(t);\n\n\t\t\t// Pass through\n\t\t\tt.serializer.onPreProcess.add(function(se, o) {\n\t\t\t\treturn t.onPreProcess.dispatch(t, o, se);\n\t\t\t});\n\n\t\t\tt.serializer.onPostProcess.add(function(se, o) {\n\t\t\t\treturn t.onPostProcess.dispatch(t, o, se);\n\t\t\t});\n\n\t\t\tt.onPreInit.dispatch(t);\n\n\t\t\tif (!s.gecko_spellcheck)\n\t\t\t\tt.getBody().spellcheck = 0;\n\n\t\t\tif (!s.readonly)\n\t\t\t\tt._addEvents();\n\n\t\t\tt.controlManager.onPostRender.dispatch(t, t.controlManager);\n\t\t\tt.onPostRender.dispatch(t);\n\n\t\t\tt.quirks = new tinymce.util.Quirks(this);\n\n\t\t\tif (s.directionality)\n\t\t\t\tt.getBody().dir = s.directionality;\n\n\t\t\tif (s.nowrap)\n\t\t\t\tt.getBody().style.whiteSpace = \"nowrap\";\n\n\t\t\tif (s.handle_node_change_callback) {\n\t\t\t\tt.onNodeChange.add(function(ed, cm, n) {\n\t\t\t\t\tt.execCallback('handle_node_change_callback', t.id, n, -1, -1, true, t.selection.isCollapsed());\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.save_callback) {\n\t\t\t\tt.onSaveContent.add(function(ed, o) {\n\t\t\t\t\tvar h = t.execCallback('save_callback', t.id, o.content, t.getBody());\n\n\t\t\t\t\tif (h)\n\t\t\t\t\t\to.content = h;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.onchange_callback) {\n\t\t\t\tt.onChange.add(function(ed, l) {\n\t\t\t\t\tt.execCallback('onchange_callback', t, l);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.protect) {\n\t\t\t\tt.onBeforeSetContent.add(function(ed, o) {\n\t\t\t\t\tif (s.protect) {\n\t\t\t\t\t\teach(s.protect, function(pattern) {\n\t\t\t\t\t\t\to.content = o.content.replace(pattern, function(str) {\n\t\t\t\t\t\t\t\treturn '<!--mce:protected ' + escape(str) + '-->';\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.convert_newlines_to_brs) {\n\t\t\t\tt.onBeforeSetContent.add(function(ed, o) {\n\t\t\t\t\tif (o.initial)\n\t\t\t\t\t\to.content = o.content.replace(/\\r?\\n/g, '<br />');\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.preformatted) {\n\t\t\t\tt.onPostProcess.add(function(ed, o) {\n\t\t\t\t\to.content = o.content.replace(/^\\s*<pre.*?>/, '');\n\t\t\t\t\to.content = o.content.replace(/<\\/pre>\\s*$/, '');\n\n\t\t\t\t\tif (o.set)\n\t\t\t\t\t\to.content = '<pre class=\"mceItemHidden\">' + o.content + '</pre>';\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.verify_css_classes) {\n\t\t\t\tt.serializer.attribValueFilter = function(n, v) {\n\t\t\t\t\tvar s, cl;\n\n\t\t\t\t\tif (n == 'class') {\n\t\t\t\t\t\t// Build regexp for classes\n\t\t\t\t\t\tif (!t.classesRE) {\n\t\t\t\t\t\t\tcl = t.dom.getClasses();\n\n\t\t\t\t\t\t\tif (cl.length > 0) {\n\t\t\t\t\t\t\t\ts = '';\n\n\t\t\t\t\t\t\t\teach (cl, function(o) {\n\t\t\t\t\t\t\t\t\ts += (s ? '|' : '') + o['class'];\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\tt.classesRE = new RegExp('(' + s + ')', 'gi');\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn !t.classesRE || /(\\bmceItem\\w+\\b|\\bmceTemp\\w+\\b)/g.test(v) || t.classesRE.test(v) ? v : '';\n\t\t\t\t\t}\n\n\t\t\t\t\treturn v;\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (s.cleanup_callback) {\n\t\t\t\tt.onBeforeSetContent.add(function(ed, o) {\n\t\t\t\t\to.content = t.execCallback('cleanup_callback', 'insert_to_editor', o.content, o);\n\t\t\t\t});\n\n\t\t\t\tt.onPreProcess.add(function(ed, o) {\n\t\t\t\t\tif (o.set)\n\t\t\t\t\t\tt.execCallback('cleanup_callback', 'insert_to_editor_dom', o.node, o);\n\n\t\t\t\t\tif (o.get)\n\t\t\t\t\t\tt.execCallback('cleanup_callback', 'get_from_editor_dom', o.node, o);\n\t\t\t\t});\n\n\t\t\t\tt.onPostProcess.add(function(ed, o) {\n\t\t\t\t\tif (o.set)\n\t\t\t\t\t\to.content = t.execCallback('cleanup_callback', 'insert_to_editor', o.content, o);\n\n\t\t\t\t\tif (o.get)\n\t\t\t\t\t\to.content = t.execCallback('cleanup_callback', 'get_from_editor', o.content, o);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.save_callback) {\n\t\t\t\tt.onGetContent.add(function(ed, o) {\n\t\t\t\t\tif (o.save)\n\t\t\t\t\t\to.content = t.execCallback('save_callback', t.id, o.content, t.getBody());\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (s.handle_event_callback) {\n\t\t\t\tt.onEvent.add(function(ed, e, o) {\n\t\t\t\t\tif (t.execCallback('handle_event_callback', e, ed, o) === false)\n\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Add visual aids when new contents is added\n\t\t\tt.onSetContent.add(function() {\n\t\t\t\tt.addVisual(t.getBody());\n\t\t\t});\n\n\t\t\t// Remove empty contents\n\t\t\tif (s.padd_empty_editor) {\n\t\t\t\tt.onPostProcess.add(function(ed, o) {\n\t\t\t\t\to.content = o.content.replace(/^(<p[^>]*>(&nbsp;|&#160;|\\s|\\u00a0|)<\\/p>[\\r\\n]*|<br \\/>[\\r\\n]*)$/, '');\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (isGecko) {\n\t\t\t\t// Fix gecko link bug, when a link is placed at the end of block elements there is\n\t\t\t\t// no way to move the caret behind the link. This fix adds a bogus br element after the link\n\t\t\t\tfunction fixLinks(ed, o) {\n\t\t\t\t\teach(ed.dom.select('a'), function(n) {\n\t\t\t\t\t\tvar pn = n.parentNode;\n\n\t\t\t\t\t\tif (ed.dom.isBlock(pn) && pn.lastChild === n)\n\t\t\t\t\t\t\ted.dom.add(pn, 'br', {'data-mce-bogus' : 1});\n\t\t\t\t\t});\n\t\t\t\t};\n\n\t\t\t\tt.onExecCommand.add(function(ed, cmd) {\n\t\t\t\t\tif (cmd === 'CreateLink')\n\t\t\t\t\t\tfixLinks(ed);\n\t\t\t\t});\n\n\t\t\t\tt.onSetContent.add(t.selection.onSetContent.add(fixLinks));\n\t\t\t}\n\n\t\t\tt.load({initial : true, format : 'html'});\n\t\t\tt.startContent = t.getContent({format : 'raw'});\n\t\t\tt.undoManager.add();\n\t\t\tt.initialized = true;\n\n\t\t\tt.onInit.dispatch(t);\n\t\t\tt.execCallback('setupcontent_callback', t.id, t.getBody(), t.getDoc());\n\t\t\tt.execCallback('init_instance_callback', t);\n\t\t\tt.focus(true);\n\t\t\tt.nodeChanged({initial : 1});\n\n\t\t\t// Load specified content CSS last\n\t\t\teach(t.contentCSS, function(u) {\n\t\t\t\tt.dom.loadCSS(u);\n\t\t\t});\n\n\t\t\t// Handle auto focus\n\t\t\tif (s.auto_focus) {\n\t\t\t\tsetTimeout(function () {\n\t\t\t\t\tvar ed = tinymce.get(s.auto_focus);\n\n\t\t\t\t\ted.selection.select(ed.getBody(), 1);\n\t\t\t\t\ted.selection.collapse(1);\n\t\t\t\t\ted.getBody().focus();\n\t\t\t\t\ted.getWin().focus();\n\t\t\t\t}, 100);\n\t\t\t}\n\n\t\t\te = null;\n\t\t},\n\n\t\t// #ifdef contentEditable\n\n\t\t/**\n\t\t * Sets up the contentEditable mode.\n\t\t *\n\t\t * @method setupContentEditable\n\t\t */\n\t\tsetupContentEditable : function() {\n\t\t\tvar t = this, s = t.settings, e = t.getElement();\n\n\t\t\tt.contentDocument = s.content_document || document;\n\t\t\tt.contentWindow = s.content_window || window;\n\t\t\tt.bodyElement = e;\n\n\t\t\t// Prevent leak in IE\n\t\t\ts.content_document = s.content_window = null;\n\n\t\t\tDOM.hide(e);\n\t\t\te.contentEditable = t.getParam('content_editable_state', true);\n\t\t\tDOM.show(e);\n\n\t\t\tif (!s.gecko_spellcheck)\n\t\t\t\tt.getDoc().body.spellcheck = 0;\n\n\t\t\t// Setup objects\n\t\t\tt.dom = new tinymce.dom.DOMUtils(t.getDoc(), {\n\t\t\t\tkeep_values : true,\n\t\t\t\turl_converter : t.convertURL,\n\t\t\t\turl_converter_scope : t,\n\t\t\t\thex_colors : s.force_hex_style_colors,\n\t\t\t\tclass_filter : s.class_filter,\n\t\t\t\troot_element : t.id,\n\t\t\t\tfix_ie_paragraphs : 1,\n\t\t\t\tupdate_styles : 1\n\t\t\t});\n\n\t\t\tt.serializer = new tinymce.dom.Serializer(s, t.dom, schema);\n\n\t\t\tt.selection = new tinymce.dom.Selection(t.dom, t.getWin(), t.serializer);\n\t\t\tt.forceBlocks = new tinymce.ForceBlocks(t, {\n\t\t\t\tforced_root_block : s.forced_root_block\n\t\t\t});\n\n\t\t\tt.editorCommands = new tinymce.EditorCommands(t);\n\n\t\t\t// Pass through\n\t\t\tt.serializer.onPreProcess.add(function(se, o) {\n\t\t\t\treturn t.onPreProcess.dispatch(t, o, se);\n\t\t\t});\n\n\t\t\tt.serializer.onPostProcess.add(function(se, o) {\n\t\t\t\treturn t.onPostProcess.dispatch(t, o, se);\n\t\t\t});\n\n\t\t\tt.onPreInit.dispatch(t);\n\t\t\tt._addEvents();\n\n\t\t\tt.controlManager.onPostRender.dispatch(t, t.controlManager);\n\t\t\tt.onPostRender.dispatch(t);\n\n\t\t\tt.onSetContent.add(function() {\n\t\t\t\tt.addVisual(t.getBody());\n\t\t\t});\n\n\t\t\t//t.load({initial : true, format : (s.cleanup_on_startup ? 'html' : 'raw')});\n\t\t\tt.startContent = t.getContent({format : 'raw'});\n\t\t\tt.undoManager.add({initial : true});\n\t\t\tt.initialized = true;\n\n\t\t\tt.onInit.dispatch(t);\n\t\t\tt.focus(true);\n\t\t\tt.nodeChanged({initial : 1});\n\n\t\t\t// Load specified content CSS last\n\t\t\tif (s.content_css) {\n\t\t\t\teach(explode(s.content_css), function(u) {\n\t\t\t\t\tt.dom.loadCSS(t.documentBaseURI.toAbsolute(u));\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (isIE) {\n\t\t\t\t// Store away selection\n\t\t\t\tt.dom.bind(t.getElement(), 'beforedeactivate', function() {\n\t\t\t\t\tt.lastSelectionBookmark = t.selection.getBookmark(1);\n\t\t\t\t});\n\n\t\t\t\tt.onBeforeExecCommand.add(function(ed, cmd, ui, val, o) {\n\t\t\t\t\tif (!DOM.getParent(ed.selection.getStart(), function(n) {return n == ed.getBody();}))\n\t\t\t\t\t\to.terminate = 1;\n\n\t\t\t\t\tif (!DOM.getParent(ed.selection.getEnd(), function(n) {return n == ed.getBody();}))\n\t\t\t\t\t\to.terminate = 1;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\te = null; // Cleanup\n\t\t},\n\n\t\t// #endif\n\n\t\t/**\n\t\t * Focuses/activates the editor. This will set this editor as the activeEditor in the tinymce collection\n\t\t * it will also place DOM focus inside the editor.\n\t\t *\n\t\t * @method focus\n\t\t * @param {Boolean} sf Skip DOM focus. Just set is as the active editor.\n\t\t */\n\t\tfocus : function(sf) {\n\t\t\tvar oed, t = this, selection = t.selection, ce = t.settings.content_editable, ieRng, controlElm, doc = t.getDoc();\n\n\t\t\tif (!sf) {\n\t\t\t\t// Get selected control element\n\t\t\t\tieRng = selection.getRng();\n\t\t\t\tif (ieRng.item) {\n\t\t\t\t\tcontrolElm = ieRng.item(0);\n\t\t\t\t}\n\n\t\t\t\tt._refreshContentEditable();\n\t\t\t\tselection.normalize();\n\n\t\t\t\t// Is not content editable\n\t\t\t\tif (!ce)\n\t\t\t\t\tt.getWin().focus();\n\n\t\t\t\t// Focus the body as well since it's contentEditable\n\t\t\t\tif (tinymce.isGecko) {\n\t\t\t\t\tt.getBody().focus();\n\t\t\t\t}\n\n\t\t\t\t// Restore selected control element\n\t\t\t\t// This is needed when for example an image is selected within a\n\t\t\t\t// layer a call to focus will then remove the control selection\n\t\t\t\tif (controlElm && controlElm.ownerDocument == doc) {\n\t\t\t\t\tieRng = doc.body.createControlRange();\n\t\t\t\t\tieRng.addElement(controlElm);\n\t\t\t\t\tieRng.select();\n\t\t\t\t}\n\n\t\t\t\t// #ifdef contentEditable\n\n\t\t\t\t// Content editable mode ends here\n\t\t\t\tif (ce) {\n\t\t\t\t\tif (tinymce.isWebKit)\n\t\t\t\t\t\tt.getWin().focus();\n\t\t\t\t\telse {\n\t\t\t\t\t\tif (tinymce.isIE)\n\t\t\t\t\t\t\tt.getElement().setActive();\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tt.getElement().focus();\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// #endif\n\t\t\t}\n\n\t\t\tif (tinymce.activeEditor != t) {\n\t\t\t\tif ((oed = tinymce.activeEditor) != null)\n\t\t\t\t\toed.onDeactivate.dispatch(oed, t);\n\n\t\t\t\tt.onActivate.dispatch(t, oed);\n\t\t\t}\n\n\t\t\ttinymce._setActive(t);\n\t\t},\n\n\t\t/**\n\t\t * Executes a legacy callback. This method is useful to call old 2.x option callbacks.\n\t\t * There new event model is a better way to add callback so this method might be removed in the future.\n\t\t *\n\t\t * @method execCallback\n\t\t * @param {String} n Name of the callback to execute.\n\t\t * @return {Object} Return value passed from callback function.\n\t\t */\n\t\texecCallback : function(n) {\n\t\t\tvar t = this, f = t.settings[n], s;\n\n\t\t\tif (!f)\n\t\t\t\treturn;\n\n\t\t\t// Look through lookup\n\t\t\tif (t.callbackLookup && (s = t.callbackLookup[n])) {\n\t\t\t\tf = s.func;\n\t\t\t\ts = s.scope;\n\t\t\t}\n\n\t\t\tif (is(f, 'string')) {\n\t\t\t\ts = f.replace(/\\.\\w+$/, '');\n\t\t\t\ts = s ? tinymce.resolve(s) : 0;\n\t\t\t\tf = tinymce.resolve(f);\n\t\t\t\tt.callbackLookup = t.callbackLookup || {};\n\t\t\t\tt.callbackLookup[n] = {func : f, scope : s};\n\t\t\t}\n\n\t\t\treturn f.apply(s || t, Array.prototype.slice.call(arguments, 1));\n\t\t},\n\n\t\t/**\n\t\t * Translates the specified string by replacing variables with language pack items it will also check if there is\n\t\t * a key mathcin the input.\n\t\t *\n\t\t * @method translate\n\t\t * @param {String} s String to translate by the language pack data.\n\t\t * @return {String} Translated string.\n\t\t */\n\t\ttranslate : function(s) {\n\t\t\tvar c = this.settings.language || 'en', i18n = tinymce.i18n;\n\n\t\t\tif (!s)\n\t\t\t\treturn '';\n\n\t\t\treturn i18n[c + '.' + s] || s.replace(/{\\#([^}]+)\\}/g, function(a, b) {\n\t\t\t\treturn i18n[c + '.' + b] || '{#' + b + '}';\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Returns a language pack item by name/key.\n\t\t *\n\t\t * @method getLang\n\t\t * @param {String} n Name/key to get from the language pack.\n\t\t * @param {String} dv Optional default value to retrieve.\n\t\t */\n\t\tgetLang : function(n, dv) {\n\t\t\treturn tinymce.i18n[(this.settings.language || 'en') + '.' + n] || (is(dv) ? dv : '{#' + n + '}');\n\t\t},\n\n\t\t/**\n\t\t * Returns a configuration parameter by name.\n\t\t *\n\t\t * @method getParam\n\t\t * @param {String} n Configruation parameter to retrieve.\n\t\t * @param {String} dv Optional default value to return.\n\t\t * @param {String} ty Optional type parameter.\n\t\t * @return {String} Configuration parameter value or default value.\n\t\t * @example\n\t\t * // Returns a specific config value from the currently active editor\n\t\t * var someval = tinyMCE.activeEditor.getParam('myvalue');\n\t\t *\n\t\t * // Returns a specific config value from a specific editor instance by id\n\t\t * var someval2 = tinyMCE.get('my_editor').getParam('myvalue');\n\t\t */\n\t\tgetParam : function(n, dv, ty) {\n\t\t\tvar tr = tinymce.trim, v = is(this.settings[n]) ? this.settings[n] : dv, o;\n\n\t\t\tif (ty === 'hash') {\n\t\t\t\to = {};\n\n\t\t\t\tif (is(v, 'string')) {\n\t\t\t\t\teach(v.indexOf('=') > 0 ? v.split(/[;,](?![^=;,]*(?:[;,]|$))/) : v.split(','), function(v) {\n\t\t\t\t\t\tv = v.split('=');\n\n\t\t\t\t\t\tif (v.length > 1)\n\t\t\t\t\t\t\to[tr(v[0])] = tr(v[1]);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\to[tr(v[0])] = tr(v);\n\t\t\t\t\t});\n\t\t\t\t} else\n\t\t\t\t\to = v;\n\n\t\t\t\treturn o;\n\t\t\t}\n\n\t\t\treturn v;\n\t\t},\n\n\t\t/**\n\t\t * Distpaches out a onNodeChange event to all observers. This method should be called when you\n\t\t * need to update the UI states or element path etc.\n\t\t *\n\t\t * @method nodeChanged\n\t\t * @param {Object} o Optional object to pass along for the node changed event.\n\t\t */\n\t\tnodeChanged : function(o) {\n\t\t\tvar t = this, s = t.selection, n = s.getStart() || t.getBody();\n\n\t\t\t// Fix for bug #1896577 it seems that this can not be fired while the editor is loading\n\t\t\tif (t.initialized) {\n\t\t\t\to = o || {};\n\t\t\t\tn = isIE && n.ownerDocument != t.getDoc() ? t.getBody() : n; // Fix for IE initial state\n\n\t\t\t\t// Get parents and add them to object\n\t\t\t\to.parents = [];\n\t\t\t\tt.dom.getParent(n, function(node) {\n\t\t\t\t\tif (node.nodeName == 'BODY')\n\t\t\t\t\t\treturn true;\n\n\t\t\t\t\to.parents.push(node);\n\t\t\t\t});\n\n\t\t\t\tt.onNodeChange.dispatch(\n\t\t\t\t\tt,\n\t\t\t\t\to ? o.controlManager || t.controlManager : t.controlManager,\n\t\t\t\t\tn,\n\t\t\t\t\ts.isCollapsed(),\n\t\t\t\t\to\n\t\t\t\t);\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Adds a button that later gets created by the ControlManager. This is a shorter and easier method\n\t\t * of adding buttons without the need to deal with the ControlManager directly. But it's also less\n\t\t * powerfull if you need more control use the ControlManagers factory methods instead.\n\t\t *\n\t\t * @method addButton\n\t\t * @param {String} n Button name to add.\n\t\t * @param {Object} s Settings object with title, cmd etc.\n\t\t * @example\n\t\t * // Adds a custom button to the editor and when a user clicks the button it will open\n\t\t * // an alert box with the selected contents as plain text.\n\t\t * tinyMCE.init({\n\t\t *    ...\n\t\t *\n\t\t *    theme_advanced_buttons1 : 'example,..'\n\t\t *\n\t\t *    setup : function(ed) {\n\t\t *       // Register example button\n\t\t *       ed.addButton('example', {\n\t\t *          title : 'example.desc',\n\t\t *          image : '../jscripts/tiny_mce/plugins/example/img/example.gif',\n\t\t *          onclick : function() {\n\t\t *             ed.windowManager.alert('Hello world!! Selection: ' + ed.selection.getContent({format : 'text'}));\n\t\t *          }\n\t\t *       });\n\t\t *    }\n\t\t * });\n\t\t */\n\t\taddButton : function(n, s) {\n\t\t\tvar t = this;\n\n\t\t\tt.buttons = t.buttons || {};\n\t\t\tt.buttons[n] = s;\n\t\t},\n\n\t\t/**\n\t\t * Adds a custom command to the editor, you can also override existing commands with this method.\n\t\t * The command that you add can be executed with execCommand.\n\t\t *\n\t\t * @method addCommand\n\t\t * @param {String} name Command name to add/override.\n\t\t * @param {addCommandCallback} callback Function to execute when the command occurs.\n\t\t * @param {Object} scope Optional scope to execute the function in.\n\t\t * @example\n\t\t * // Adds a custom command that later can be executed using execCommand\n\t\t * tinyMCE.init({\n\t\t *    ...\n\t\t *\n\t\t *    setup : function(ed) {\n\t\t *       // Register example command\n\t\t *       ed.addCommand('mycommand', function(ui, v) {\n\t\t *          ed.windowManager.alert('Hello world!! Selection: ' + ed.selection.getContent({format : 'text'}));\n\t\t *       });\n\t\t *    }\n\t\t * });\n\t\t */\n\t\taddCommand : function(name, callback, scope) {\n\t\t\t/**\n\t\t\t * Callback function that gets called when a command is executed.\n\t\t\t *\n\t\t\t * @callback addCommandCallback\n\t\t\t * @param {Boolean} ui Display UI state true/false.\n\t\t\t * @param {Object} value Optional value for command.\n\t\t\t * @return {Boolean} True/false state if the command was handled or not.\n\t\t\t */\n\t\t\tthis.execCommands[name] = {func : callback, scope : scope || this};\n\t\t},\n\n\t\t/**\n\t\t * Adds a custom query state command to the editor, you can also override existing commands with this method.\n\t\t * The command that you add can be executed with queryCommandState function.\n\t\t *\n\t\t * @method addQueryStateHandler\n\t\t * @param {String} name Command name to add/override.\n\t\t * @param {addQueryStateHandlerCallback} callback Function to execute when the command state retrival occurs.\n\t\t * @param {Object} scope Optional scope to execute the function in.\n\t\t */\n\t\taddQueryStateHandler : function(name, callback, scope) {\n\t\t\t/**\n\t\t\t * Callback function that gets called when a queryCommandState is executed.\n\t\t\t *\n\t\t\t * @callback addQueryStateHandlerCallback\n\t\t\t * @return {Boolean} True/false state if the command is enabled or not like is it bold.\n\t\t\t */\n\t\t\tthis.queryStateCommands[name] = {func : callback, scope : scope || this};\n\t\t},\n\n\t\t/**\n\t\t * Adds a custom query value command to the editor, you can also override existing commands with this method.\n\t\t * The command that you add can be executed with queryCommandValue function.\n\t\t *\n\t\t * @method addQueryValueHandler\n\t\t * @param {String} name Command name to add/override.\n\t\t * @param {addQueryValueHandlerCallback} callback Function to execute when the command value retrival occurs.\n\t\t * @param {Object} scope Optional scope to execute the function in.\n\t\t */\n\t\taddQueryValueHandler : function(name, callback, scope) {\n\t\t\t/**\n\t\t\t * Callback function that gets called when a queryCommandValue is executed.\n\t\t\t *\n\t\t\t * @callback addQueryValueHandlerCallback\n\t\t\t * @return {Object} Value of the command or undefined.\n\t\t\t */\n\t\t\tthis.queryValueCommands[name] = {func : callback, scope : scope || this};\n\t\t},\n\n\t\t/**\n\t\t * Adds a keyboard shortcut for some command or function.\n\t\t *\n\t\t * @method addShortcut\n\t\t * @param {String} pa Shortcut pattern. Like for example: ctrl+alt+o.\n\t\t * @param {String} desc Text description for the command.\n\t\t * @param {String/Function} cmd_func Command name string or function to execute when the key is pressed.\n\t\t * @param {Object} sc Optional scope to execute the function in.\n\t\t * @return {Boolean} true/false state if the shortcut was added or not.\n\t\t */\n\t\taddShortcut : function(pa, desc, cmd_func, sc) {\n\t\t\tvar t = this, c;\n\n\t\t\tif (!t.settings.custom_shortcuts)\n\t\t\t\treturn false;\n\n\t\t\tt.shortcuts = t.shortcuts || {};\n\n\t\t\tif (is(cmd_func, 'string')) {\n\t\t\t\tc = cmd_func;\n\n\t\t\t\tcmd_func = function() {\n\t\t\t\t\tt.execCommand(c, false, null);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (is(cmd_func, 'object')) {\n\t\t\t\tc = cmd_func;\n\n\t\t\t\tcmd_func = function() {\n\t\t\t\t\tt.execCommand(c[0], c[1], c[2]);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\teach(explode(pa), function(pa) {\n\t\t\t\tvar o = {\n\t\t\t\t\tfunc : cmd_func,\n\t\t\t\t\tscope : sc || this,\n\t\t\t\t\tdesc : desc,\n\t\t\t\t\talt : false,\n\t\t\t\t\tctrl : false,\n\t\t\t\t\tshift : false\n\t\t\t\t};\n\n\t\t\t\teach(explode(pa, '+'), function(v) {\n\t\t\t\t\tswitch (v) {\n\t\t\t\t\t\tcase 'alt':\n\t\t\t\t\t\tcase 'ctrl':\n\t\t\t\t\t\tcase 'shift':\n\t\t\t\t\t\t\to[v] = true;\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tdefault:\n\t\t\t\t\t\t\to.charCode = v.charCodeAt(0);\n\t\t\t\t\t\t\to.keyCode = v.toUpperCase().charCodeAt(0);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tt.shortcuts[(o.ctrl ? 'ctrl' : '') + ',' + (o.alt ? 'alt' : '') + ',' + (o.shift ? 'shift' : '') + ',' + o.keyCode] = o;\n\t\t\t});\n\n\t\t\treturn true;\n\t\t},\n\n\t\t/**\n\t\t * Executes a command on the current instance. These commands can be TinyMCE internal commands prefixed with \"mce\" or\n\t\t * they can be build in browser commands such as \"Bold\". A compleate list of browser commands is available on MSDN or Mozilla.org.\n\t\t * This function will dispatch the execCommand function on each plugin, theme or the execcommand_callback option if none of these\n\t\t * return true it will handle the command as a internal browser command.\n\t\t *\n\t\t * @method execCommand\n\t\t * @param {String} cmd Command name to execute, for example mceLink or Bold.\n\t\t * @param {Boolean} ui True/false state if a UI (dialog) should be presented or not.\n\t\t * @param {mixed} val Optional command value, this can be anything.\n\t\t * @param {Object} a Optional arguments object.\n\t\t * @return {Boolean} True/false if the command was executed or not.\n\t\t */\n\t\texecCommand : function(cmd, ui, val, a) {\n\t\t\tvar t = this, s = 0, o, st;\n\n\t\t\tif (!/^(mceAddUndoLevel|mceEndUndoLevel|mceBeginUndoLevel|mceRepaint|SelectAll)$/.test(cmd) && (!a || !a.skip_focus))\n\t\t\t\tt.focus();\n\n\t\t\to = {};\n\t\t\tt.onBeforeExecCommand.dispatch(t, cmd, ui, val, o);\n\t\t\tif (o.terminate)\n\t\t\t\treturn false;\n\n\t\t\t// Command callback\n\t\t\tif (t.execCallback('execcommand_callback', t.id, t.selection.getNode(), cmd, ui, val)) {\n\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Registred commands\n\t\t\tif (o = t.execCommands[cmd]) {\n\t\t\t\tst = o.func.call(o.scope, ui, val);\n\n\t\t\t\t// Fall through on true\n\t\t\t\tif (st !== true) {\n\t\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\t\treturn st;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Plugin commands\n\t\t\teach(t.plugins, function(p) {\n\t\t\t\tif (p.execCommand && p.execCommand(cmd, ui, val)) {\n\t\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\t\ts = 1;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tif (s)\n\t\t\t\treturn true;\n\n\t\t\t// Theme commands\n\t\t\tif (t.theme && t.theme.execCommand && t.theme.execCommand(cmd, ui, val)) {\n\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Editor commands\n\t\t\tif (t.editorCommands.execCommand(cmd, ui, val)) {\n\t\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Browser commands\n\t\t\tt.getDoc().execCommand(cmd, ui, val);\n\t\t\tt.onExecCommand.dispatch(t, cmd, ui, val, a);\n\t\t},\n\n\t\t/**\n\t\t * Returns a command specific state, for example if bold is enabled or not.\n\t\t *\n\t\t * @method queryCommandState\n\t\t * @param {string} cmd Command to query state from.\n\t\t * @return {Boolean} Command specific state, for example if bold is enabled or not.\n\t\t */\n\t\tqueryCommandState : function(cmd) {\n\t\t\tvar t = this, o, s;\n\n\t\t\t// Is hidden then return undefined\n\t\t\tif (t._isHidden())\n\t\t\t\treturn;\n\n\t\t\t// Registred commands\n\t\t\tif (o = t.queryStateCommands[cmd]) {\n\t\t\t\ts = o.func.call(o.scope);\n\n\t\t\t\t// Fall though on true\n\t\t\t\tif (s !== true)\n\t\t\t\t\treturn s;\n\t\t\t}\n\n\t\t\t// Registred commands\n\t\t\to = t.editorCommands.queryCommandState(cmd);\n\t\t\tif (o !== -1)\n\t\t\t\treturn o;\n\n\t\t\t// Browser commands\n\t\t\ttry {\n\t\t\t\treturn this.getDoc().queryCommandState(cmd);\n\t\t\t} catch (ex) {\n\t\t\t\t// Fails sometimes see bug: 1896577\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Returns a command specific value, for example the current font size.\n\t\t *\n\t\t * @method queryCommandValue\n\t\t * @param {string} c Command to query value from.\n\t\t * @return {Object} Command specific value, for example the current font size.\n\t\t */\n\t\tqueryCommandValue : function(c) {\n\t\t\tvar t = this, o, s;\n\n\t\t\t// Is hidden then return undefined\n\t\t\tif (t._isHidden())\n\t\t\t\treturn;\n\n\t\t\t// Registred commands\n\t\t\tif (o = t.queryValueCommands[c]) {\n\t\t\t\ts = o.func.call(o.scope);\n\n\t\t\t\t// Fall though on true\n\t\t\t\tif (s !== true)\n\t\t\t\t\treturn s;\n\t\t\t}\n\n\t\t\t// Registred commands\n\t\t\to = t.editorCommands.queryCommandValue(c);\n\t\t\tif (is(o))\n\t\t\t\treturn o;\n\n\t\t\t// Browser commands\n\t\t\ttry {\n\t\t\t\treturn this.getDoc().queryCommandValue(c);\n\t\t\t} catch (ex) {\n\t\t\t\t// Fails sometimes see bug: 1896577\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Shows the editor and hides any textarea/div that the editor is supposed to replace.\n\t\t *\n\t\t * @method show\n\t\t */\n\t\tshow : function() {\n\t\t\tvar t = this;\n\n\t\t\tDOM.show(t.getContainer());\n\t\t\tDOM.hide(t.id);\n\t\t\tt.load();\n\t\t},\n\n\t\t/**\n\t\t * Hides the editor and shows any textarea/div that the editor is supposed to replace.\n\t\t *\n\t\t * @method hide\n\t\t */\n\t\thide : function() {\n\t\t\tvar t = this, d = t.getDoc();\n\n\t\t\t// Fixed bug where IE has a blinking cursor left from the editor\n\t\t\tif (isIE && d)\n\t\t\t\td.execCommand('SelectAll');\n\n\t\t\t// We must save before we hide so Safari doesn't crash\n\t\t\tt.save();\n\t\t\tDOM.hide(t.getContainer());\n\t\t\tDOM.setStyle(t.id, 'display', t.orgDisplay);\n\t\t},\n\n\t\t/**\n\t\t * Returns true/false if the editor is hidden or not.\n\t\t *\n\t\t * @method isHidden\n\t\t * @return {Boolean} True/false if the editor is hidden or not.\n\t\t */\n\t\tisHidden : function() {\n\t\t\treturn !DOM.isHidden(this.id);\n\t\t},\n\n\t\t/**\n\t\t * Sets the progress state, this will display a throbber/progess for the editor.\n\t\t * This is ideal for asycronous operations like an AJAX save call.\n\t\t *\n\t\t * @method setProgressState\n\t\t * @param {Boolean} b Boolean state if the progress should be shown or hidden.\n\t\t * @param {Number} ti Optional time to wait before the progress gets shown.\n\t\t * @param {Object} o Optional object to pass to the progress observers.\n\t\t * @return {Boolean} Same as the input state.\n\t\t * @example\n\t\t * // Show progress for the active editor\n\t\t * tinyMCE.activeEditor.setProgressState(true);\n\t\t *\n\t\t * // Hide progress for the active editor\n\t\t * tinyMCE.activeEditor.setProgressState(false);\n\t\t *\n\t\t * // Show progress after 3 seconds\n\t\t * tinyMCE.activeEditor.setProgressState(true, 3000);\n\t\t */\n\t\tsetProgressState : function(b, ti, o) {\n\t\t\tthis.onSetProgressState.dispatch(this, b, ti, o);\n\n\t\t\treturn b;\n\t\t},\n\n\t\t/**\n\t\t * Loads contents from the textarea or div element that got converted into an editor instance.\n\t\t * This method will move the contents from that textarea or div into the editor by using setContent\n\t\t * so all events etc that method has will get dispatched as well.\n\t\t *\n\t\t * @method load\n\t\t * @param {Object} o Optional content object, this gets passed around through the whole load process.\n\t\t * @return {String} HTML string that got set into the editor.\n\t\t */\n\t\tload : function(o) {\n\t\t\tvar t = this, e = t.getElement(), h;\n\n\t\t\tif (e) {\n\t\t\t\to = o || {};\n\t\t\t\to.load = true;\n\n\t\t\t\t// Double encode existing entities in the value\n\t\t\t\th = t.setContent(is(e.value) ? e.value : e.innerHTML, o);\n\t\t\t\to.element = e;\n\n\t\t\t\tif (!o.no_events)\n\t\t\t\t\tt.onLoadContent.dispatch(t, o);\n\n\t\t\t\to.element = e = null;\n\n\t\t\t\treturn h;\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Saves the contents from a editor out to the textarea or div element that got converted into an editor instance.\n\t\t * This method will move the HTML contents from the editor into that textarea or div by getContent\n\t\t * so all events etc that method has will get dispatched as well.\n\t\t *\n\t\t * @method save\n\t\t * @param {Object} o Optional content object, this gets passed around through the whole save process.\n\t\t * @return {String} HTML string that got set into the textarea/div.\n\t\t */\n\t\tsave : function(o) {\n\t\t\tvar t = this, e = t.getElement(), h, f;\n\n\t\t\tif (!e || !t.initialized)\n\t\t\t\treturn;\n\n\t\t\to = o || {};\n\t\t\to.save = true;\n\n\t\t\t// Add undo level will trigger onchange event\n\t\t\tif (!o.no_events) {\n\t\t\t\tt.undoManager.typing = false;\n\t\t\t\tt.undoManager.add();\n\t\t\t}\n\n\t\t\to.element = e;\n\t\t\th = o.content = t.getContent(o);\n\n\t\t\tif (!o.no_events)\n\t\t\t\tt.onSaveContent.dispatch(t, o);\n\n\t\t\th = o.content;\n\n\t\t\tif (!/TEXTAREA|INPUT/i.test(e.nodeName)) {\n\t\t\t\te.innerHTML = h;\n\n\t\t\t\t// Update hidden form element\n\t\t\t\tif (f = DOM.getParent(t.id, 'form')) {\n\t\t\t\t\teach(f.elements, function(e) {\n\t\t\t\t\t\tif (e.name == t.id) {\n\t\t\t\t\t\t\te.value = h;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t} else\n\t\t\t\te.value = h;\n\n\t\t\to.element = e = null;\n\n\t\t\treturn h;\n\t\t},\n\n\t\t/**\n\t\t * Sets the specified content to the editor instance, this will cleanup the content before it gets set using\n\t\t * the different cleanup rules options.\n\t\t *\n\t\t * @method setContent\n\t\t * @param {String} content Content to set to editor, normally HTML contents but can be other formats as well.\n\t\t * @param {Object} args Optional content object, this gets passed around through the whole set process.\n\t\t * @return {String} HTML string that got set into the editor.\n\t\t * @example\n\t\t * // Sets the HTML contents of the activeEditor editor\n\t\t * tinyMCE.activeEditor.setContent('<span>some</span> html');\n\t\t *\n\t\t * // Sets the raw contents of the activeEditor editor\n\t\t * tinyMCE.activeEditor.setContent('<span>some</span> html', {format : 'raw'});\n\t\t *\n\t\t * // Sets the content of a specific editor (my_editor in this example)\n\t\t * tinyMCE.get('my_editor').setContent(data);\n\t\t *\n\t\t * // Sets the bbcode contents of the activeEditor editor if the bbcode plugin was added\n\t\t * tinyMCE.activeEditor.setContent('[b]some[/b] html', {format : 'bbcode'});\n\t\t */\n\t\tsetContent : function(content, args) {\n\t\t\tvar self = this, rootNode, body = self.getBody(), forcedRootBlockName;\n\n\t\t\t// Setup args object\n\t\t\targs = args || {};\n\t\t\targs.format = args.format || 'html';\n\t\t\targs.set = true;\n\t\t\targs.content = content;\n\n\t\t\t// Do preprocessing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onBeforeSetContent.dispatch(self, args);\n\n\t\t\tcontent = args.content;\n\n\t\t\t// Padd empty content in Gecko and Safari. Commands will otherwise fail on the content\n\t\t\t// It will also be impossible to place the caret in the editor unless there is a BR element present\n\t\t\tif (!tinymce.isIE && (content.length === 0 || /^\\s+$/.test(content))) {\n\t\t\t\tforcedRootBlockName = self.settings.forced_root_block;\n\t\t\t\tif (forcedRootBlockName)\n\t\t\t\t\tcontent = '<' + forcedRootBlockName + '><br data-mce-bogus=\"1\"></' + forcedRootBlockName + '>';\n\t\t\t\telse\n\t\t\t\t\tcontent = '<br data-mce-bogus=\"1\">';\n\n\t\t\t\tbody.innerHTML = content;\n\t\t\t\tself.selection.select(body, true);\n\t\t\t\tself.selection.collapse(true);\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Parse and serialize the html\n\t\t\tif (args.format !== 'raw') {\n\t\t\t\tcontent = new tinymce.html.Serializer({}, self.schema).serialize(\n\t\t\t\t\tself.parser.parse(content)\n\t\t\t\t);\n\t\t\t}\n\n\t\t\t// Set the new cleaned contents to the editor\n\t\t\targs.content = tinymce.trim(content);\n\t\t\tself.dom.setHTML(body, args.content);\n\n\t\t\t// Do post processing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onSetContent.dispatch(self, args);\n\n\t\t\tself.selection.normalize();\n\n\t\t\treturn args.content;\n\t\t},\n\n\t\t/**\n\t\t * Gets the content from the editor instance, this will cleanup the content before it gets returned using\n\t\t * the different cleanup rules options.\n\t\t *\n\t\t * @method getContent\n\t\t * @param {Object} args Optional content object, this gets passed around through the whole get process.\n\t\t * @return {String} Cleaned content string, normally HTML contents.\n\t\t * @example\n\t\t * // Get the HTML contents of the currently active editor\n\t\t * console.debug(tinyMCE.activeEditor.getContent());\n\t\t *\n\t\t * // Get the raw contents of the currently active editor\n\t\t * tinyMCE.activeEditor.getContent({format : 'raw'});\n\t\t *\n\t\t * // Get content of a specific editor:\n\t\t * tinyMCE.get('content id').getContent()\n\t\t */\n\t\tgetContent : function(args) {\n\t\t\tvar self = this, content;\n\n\t\t\t// Setup args object\n\t\t\targs = args || {};\n\t\t\targs.format = args.format || 'html';\n\t\t\targs.get = true;\n\n\t\t\t// Do preprocessing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onBeforeGetContent.dispatch(self, args);\n\n\t\t\t// Get raw contents or by default the cleaned contents\n\t\t\tif (args.format == 'raw')\n\t\t\t\tcontent = self.getBody().innerHTML;\n\t\t\telse\n\t\t\t\tcontent = self.serializer.serialize(self.getBody(), args);\n\n\t\t\targs.content = tinymce.trim(content);\n\n\t\t\t// Do post processing\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onGetContent.dispatch(self, args);\n\n\t\t\treturn args.content;\n\t\t},\n\n\t\t/**\n\t\t * Returns true/false if the editor is dirty or not. It will get dirty if the user has made modifications to the contents.\n\t\t *\n\t\t * @method isDirty\n\t\t * @return {Boolean} True/false if the editor is dirty or not. It will get dirty if the user has made modifications to the contents.\n\t\t * @example\n\t\t * if (tinyMCE.activeEditor.isDirty())\n\t\t *     alert(\"You must save your contents.\");\n\t\t */\n\t\tisDirty : function() {\n\t\t\tvar self = this;\n\n\t\t\treturn tinymce.trim(self.startContent) != tinymce.trim(self.getContent({format : 'raw', no_events : 1})) && !self.isNotDirty;\n\t\t},\n\n\t\t/**\n\t\t * Returns the editors container element. The container element wrappes in\n\t\t * all the elements added to the page for the editor. Such as UI, iframe etc.\n\t\t *\n\t\t * @method getContainer\n\t\t * @return {Element} HTML DOM element for the editor container.\n\t\t */\n\t\tgetContainer : function() {\n\t\t\tvar t = this;\n\n\t\t\tif (!t.container)\n\t\t\t\tt.container = DOM.get(t.editorContainer || t.id + '_parent');\n\n\t\t\treturn t.container;\n\t\t},\n\n\t\t/**\n\t\t * Returns the editors content area container element. The this element is the one who\n\t\t * holds the iframe or the editable element.\n\t\t *\n\t\t * @method getContentAreaContainer\n\t\t * @return {Element} HTML DOM element for the editor area container.\n\t\t */\n\t\tgetContentAreaContainer : function() {\n\t\t\treturn this.contentAreaContainer;\n\t\t},\n\n\t\t/**\n\t\t * Returns the target element/textarea that got replaced with a TinyMCE editor instance.\n\t\t *\n\t\t * @method getElement\n\t\t * @return {Element} HTML DOM element for the replaced element.\n\t\t */\n\t\tgetElement : function() {\n\t\t\treturn DOM.get(this.settings.content_element || this.id);\n\t\t},\n\n\t\t/**\n\t\t * Returns the iframes window object.\n\t\t *\n\t\t * @method getWin\n\t\t * @return {Window} Iframe DOM window object.\n\t\t */\n\t\tgetWin : function() {\n\t\t\tvar t = this, e;\n\n\t\t\tif (!t.contentWindow) {\n\t\t\t\te = DOM.get(t.id + \"_ifr\");\n\n\t\t\t\tif (e)\n\t\t\t\t\tt.contentWindow = e.contentWindow;\n\t\t\t}\n\n\t\t\treturn t.contentWindow;\n\t\t},\n\n\t\t/**\n\t\t * Returns the iframes document object.\n\t\t *\n\t\t * @method getDoc\n\t\t * @return {Document} Iframe DOM document object.\n\t\t */\n\t\tgetDoc : function() {\n\t\t\tvar t = this, w;\n\n\t\t\tif (!t.contentDocument) {\n\t\t\t\tw = t.getWin();\n\n\t\t\t\tif (w)\n\t\t\t\t\tt.contentDocument = w.document;\n\t\t\t}\n\n\t\t\treturn t.contentDocument;\n\t\t},\n\n\t\t/**\n\t\t * Returns the iframes body element.\n\t\t *\n\t\t * @method getBody\n\t\t * @return {Element} Iframe body element.\n\t\t */\n\t\tgetBody : function() {\n\t\t\treturn this.bodyElement || this.getDoc().body;\n\t\t},\n\n\t\t/**\n\t\t * URL converter function this gets executed each time a user adds an img, a or\n\t\t * any other element that has a URL in it. This will be called both by the DOM and HTML\n\t\t * manipulation functions.\n\t\t *\n\t\t * @method convertURL\n\t\t * @param {string} u URL to convert.\n\t\t * @param {string} n Attribute name src, href etc.\n\t\t * @param {string/HTMLElement} Tag name or HTML DOM element depending on HTML or DOM insert.\n\t\t * @return {string} Converted URL string.\n\t\t */\n\t\tconvertURL : function(u, n, e) {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\t// Use callback instead\n\t\t\tif (s.urlconverter_callback)\n\t\t\t\treturn t.execCallback('urlconverter_callback', u, e, true, n);\n\n\t\t\t// Don't convert link href since thats the CSS files that gets loaded into the editor also skip local file URLs\n\t\t\tif (!s.convert_urls || (e && e.nodeName == 'LINK') || u.indexOf('file:') === 0)\n\t\t\t\treturn u;\n\n\t\t\t// Convert to relative\n\t\t\tif (s.relative_urls)\n\t\t\t\treturn t.documentBaseURI.toRelative(u);\n\n\t\t\t// Convert to absolute\n\t\t\tu = t.documentBaseURI.toAbsolute(u, s.remove_script_host);\n\n\t\t\treturn u;\n\t\t},\n\n\t\t/**\n\t\t * Adds visual aid for tables, anchors etc so they can be more easily edited inside the editor.\n\t\t *\n\t\t * @method addVisual\n\t\t * @param {Element} e Optional root element to loop though to find tables etc that needs the visual aid.\n\t\t */\n\t\taddVisual : function(e) {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\te = e || t.getBody();\n\n\t\t\tif (!is(t.hasVisual))\n\t\t\t\tt.hasVisual = s.visual;\n\n\t\t\teach(t.dom.select('table,a', e), function(e) {\n\t\t\t\tvar v;\n\n\t\t\t\tswitch (e.nodeName) {\n\t\t\t\t\tcase 'TABLE':\n\t\t\t\t\t\tv = t.dom.getAttrib(e, 'border');\n\n\t\t\t\t\t\tif (!v || v == '0') {\n\t\t\t\t\t\t\tif (t.hasVisual)\n\t\t\t\t\t\t\t\tt.dom.addClass(e, s.visual_table_class);\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tt.dom.removeClass(e, s.visual_table_class);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tcase 'A':\n\t\t\t\t\t\tv = t.dom.getAttrib(e, 'name');\n\n\t\t\t\t\t\tif (v) {\n\t\t\t\t\t\t\tif (t.hasVisual)\n\t\t\t\t\t\t\t\tt.dom.addClass(e, 'mceItemAnchor');\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tt.dom.removeClass(e, 'mceItemAnchor');\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.onVisualAid.dispatch(t, e, t.hasVisual);\n\t\t},\n\n\t\t/**\n\t\t * Removes the editor from the dom and tinymce collection.\n\t\t *\n\t\t * @method remove\n\t\t */\n\t\tremove : function() {\n\t\t\tvar t = this, e = t.getContainer();\n\n\t\t\tt.removed = 1; // Cancels post remove event execution\n\t\t\tt.hide();\n\n\t\t\tt.execCallback('remove_instance_callback', t);\n\t\t\tt.onRemove.dispatch(t);\n\n\t\t\t// Clear all execCommand listeners this is required to avoid errors if the editor was removed inside another command\n\t\t\tt.onExecCommand.listeners = [];\n\n\t\t\ttinymce.remove(t);\n\t\t\tDOM.remove(e);\n\t\t},\n\n\t\t/**\n\t\t * Destroys the editor instance by removing all events, element references or other resources\n\t\t * that could leak memory. This method will be called automatically when the page is unloaded\n\t\t * but you can also call it directly if you know what you are doing.\n\t\t *\n\t\t * @method destroy\n\t\t * @param {Boolean} s Optional state if the destroy is an automatic destroy or user called one.\n\t\t */\n\t\tdestroy : function(s) {\n\t\t\tvar t = this;\n\n\t\t\t// One time is enough\n\t\t\tif (t.destroyed)\n\t\t\t\treturn;\n\n\t\t\tif (!s) {\n\t\t\t\ttinymce.removeUnload(t.destroy);\n\t\t\t\ttinyMCE.onBeforeUnload.remove(t._beforeUnload);\n\n\t\t\t\t// Manual destroy\n\t\t\t\tif (t.theme && t.theme.destroy)\n\t\t\t\t\tt.theme.destroy();\n\n\t\t\t\t// Destroy controls, selection and dom\n\t\t\t\tt.controlManager.destroy();\n\t\t\t\tt.selection.destroy();\n\t\t\t\tt.dom.destroy();\n\n\t\t\t\t// Remove all events\n\n\t\t\t\t// Don't clear the window or document if content editable\n\t\t\t\t// is enabled since other instances might still be present\n\t\t\t\tif (!t.settings.content_editable) {\n\t\t\t\t\tEvent.clear(t.getWin());\n\t\t\t\t\tEvent.clear(t.getDoc());\n\t\t\t\t}\n\n\t\t\t\tEvent.clear(t.getBody());\n\t\t\t\tEvent.clear(t.formElement);\n\t\t\t}\n\n\t\t\tif (t.formElement) {\n\t\t\t\tt.formElement.submit = t.formElement._mceOldSubmit;\n\t\t\t\tt.formElement._mceOldSubmit = null;\n\t\t\t}\n\n\t\t\tt.contentAreaContainer = t.formElement = t.container = t.settings.content_element = t.bodyElement = t.contentDocument = t.contentWindow = null;\n\n\t\t\tif (t.selection)\n\t\t\t\tt.selection = t.selection.win = t.selection.dom = t.selection.dom.doc = null;\n\n\t\t\tt.destroyed = 1;\n\t\t},\n\n\t\t// Internal functions\n\n\t\t_addEvents : function() {\n\t\t\t// 'focus', 'blur', 'dblclick', 'beforedeactivate', submit, reset\n\t\t\tvar t = this, i, s = t.settings, dom = t.dom, lo = {\n\t\t\t\tmouseup : 'onMouseUp',\n\t\t\t\tmousedown : 'onMouseDown',\n\t\t\t\tclick : 'onClick',\n\t\t\t\tkeyup : 'onKeyUp',\n\t\t\t\tkeydown : 'onKeyDown',\n\t\t\t\tkeypress : 'onKeyPress',\n\t\t\t\tsubmit : 'onSubmit',\n\t\t\t\treset : 'onReset',\n\t\t\t\tcontextmenu : 'onContextMenu',\n\t\t\t\tdblclick : 'onDblClick',\n\t\t\t\tpaste : 'onPaste' // Doesn't work in all browsers yet\n\t\t\t};\n\n\t\t\tfunction eventHandler(e, o) {\n\t\t\t\tvar ty = e.type;\n\n\t\t\t\t// Don't fire events when it's removed\n\t\t\t\tif (t.removed)\n\t\t\t\t\treturn;\n\n\t\t\t\t// Generic event handler\n\t\t\t\tif (t.onEvent.dispatch(t, e, o) !== false) {\n\t\t\t\t\t// Specific event handler\n\t\t\t\t\tt[lo[e.fakeType || e.type]].dispatch(t, e, o);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Add DOM events\n\t\t\teach(lo, function(v, k) {\n\t\t\t\tswitch (k) {\n\t\t\t\t\tcase 'contextmenu':\n\t\t\t\t\t\tdom.bind(t.getDoc(), k, eventHandler);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'paste':\n\t\t\t\t\t\tdom.bind(t.getBody(), k, function(e) {\n\t\t\t\t\t\t\teventHandler(e);\n\t\t\t\t\t\t});\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'submit':\n\t\t\t\t\tcase 'reset':\n\t\t\t\t\t\tdom.bind(t.getElement().form || DOM.getParent(t.id, 'form'), k, eventHandler);\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tdefault:\n\t\t\t\t\t\tdom.bind(s.content_editable ? t.getBody() : t.getDoc(), k, eventHandler);\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tdom.bind(s.content_editable ? t.getBody() : (isGecko ? t.getDoc() : t.getWin()), 'focus', function(e) {\n\t\t\t\tt.focus(true);\n\t\t\t});\n\n\t\t\t// #ifdef contentEditable\n\n\t\t\tif (s.content_editable && tinymce.isOpera) {\n\t\t\t\t// Opera doesn't support focus event for contentEditable elements so we need to fake it\n\t\t\t\tfunction doFocus(e) {\n\t\t\t\t\tt.focus(true);\n\t\t\t\t};\n\n\t\t\t\tdom.bind(t.getBody(), 'click', doFocus);\n\t\t\t\tdom.bind(t.getBody(), 'keydown', doFocus);\n\t\t\t}\n\n\t\t\t// #endif\n\n\t\t\t// Fixes bug where a specified document_base_uri could result in broken images\n\t\t\t// This will also fix drag drop of images in Gecko\n\t\t\tif (tinymce.isGecko) {\n\t\t\t\tdom.bind(t.getDoc(), 'DOMNodeInserted', function(e) {\n\t\t\t\t\tvar v;\n\n\t\t\t\t\te = e.target;\n\n\t\t\t\t\tif (e.nodeType === 1 && e.nodeName === 'IMG' && (v = e.getAttribute('data-mce-src')))\n\t\t\t\t\t\te.src = t.documentBaseURI.toAbsolute(v);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Set various midas options in Gecko\n\t\t\tif (isGecko) {\n\t\t\t\tfunction setOpts() {\n\t\t\t\t\tvar t = this, d = t.getDoc(), s = t.settings;\n\n\t\t\t\t\tif (isGecko && !s.readonly) {\n\t\t\t\t\t\tt._refreshContentEditable();\n\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t// Try new Gecko method\n\t\t\t\t\t\t\td.execCommand(\"styleWithCSS\", 0, false);\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\t// Use old method\n\t\t\t\t\t\t\tif (!t._isHidden())\n\t\t\t\t\t\t\t\ttry {d.execCommand(\"useCSS\", 0, true);} catch (ex) {}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (!s.table_inline_editing)\n\t\t\t\t\t\t\ttry {d.execCommand('enableInlineTableEditing', false, false);} catch (ex) {}\n\n\t\t\t\t\t\tif (!s.object_resizing)\n\t\t\t\t\t\t\ttry {d.execCommand('enableObjectResizing', false, false);} catch (ex) {}\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\tt.onBeforeExecCommand.add(setOpts);\n\t\t\t\tt.onMouseDown.add(setOpts);\n\t\t\t}\n\n\t\t\t// Add node change handlers\n\t\t\tt.onMouseUp.add(t.nodeChanged);\n\t\t\t//t.onClick.add(t.nodeChanged);\n\t\t\tt.onKeyUp.add(function(ed, e) {\n\t\t\t\tvar c = e.keyCode;\n\n\t\t\t\tif ((c >= 33 && c <= 36) || (c >= 37 && c <= 40) || c == 13 || c == 45 || c == 46 || c == 8 || (tinymce.isMac && (c == 91 || c == 93)) || e.ctrlKey)\n\t\t\t\t\tt.nodeChanged();\n\t\t\t});\n\n\n\t\t\t// Add block quote deletion handler\n\t\t\tt.onKeyDown.add(function(ed, e) {\n\t\t\t\t// Was the BACKSPACE key pressed?\n\t\t\t\tif (e.keyCode != 8)\n\t\t\t\t\treturn;\n\n\t\t\t\tvar n = ed.selection.getRng().startContainer;\n\t\t\t\tvar offset = ed.selection.getRng().startOffset;\n\n\t\t\t\twhile (n && n.nodeType && n.nodeType != 1 && n.parentNode)\n\t\t\t\t\tn = n.parentNode;\n\n\t\t\t\t// Is the cursor at the beginning of a blockquote?\n\t\t\t\tif (n && n.parentNode && n.parentNode.tagName === 'BLOCKQUOTE' && n.parentNode.firstChild == n && offset == 0) {\n\t\t\t\t\t// Remove the blockquote\n\t\t\t\t\ted.formatter.toggle('blockquote', null, n.parentNode);\n\n\t\t\t\t\t// Move the caret to the beginning of n\n\t\t\t\t\tvar rng = ed.selection.getRng();\n\t\t\t\t\trng.setStart(n, 0);\n\t\t\t\t\trng.setEnd(n, 0);\n\t\t\t\t\ted.selection.setRng(rng);\n\t\t\t\t\ted.selection.collapse(false);\n\t\t\t\t}\n\t\t\t});\n\n\n\n\t\t\t// Add reset handler\n\t\t\tt.onReset.add(function() {\n\t\t\t\tt.setContent(t.startContent, {format : 'raw'});\n\t\t\t});\n\n\t\t\t// Add shortcuts\n\t\t\tif (s.custom_shortcuts) {\n\t\t\t\tif (s.custom_undo_redo_keyboard_shortcuts) {\n\t\t\t\t\tt.addShortcut('ctrl+z', t.getLang('undo_desc'), 'Undo');\n\t\t\t\t\tt.addShortcut('ctrl+y', t.getLang('redo_desc'), 'Redo');\n\t\t\t\t}\n\n\t\t\t\t// Add default shortcuts for gecko\n\t\t\t\tt.addShortcut('ctrl+b', t.getLang('bold_desc'), 'Bold');\n\t\t\t\tt.addShortcut('ctrl+i', t.getLang('italic_desc'), 'Italic');\n\t\t\t\tt.addShortcut('ctrl+u', t.getLang('underline_desc'), 'Underline');\n\n\t\t\t\t// BlockFormat shortcuts keys\n\t\t\t\tfor (i=1; i<=6; i++)\n\t\t\t\t\tt.addShortcut('ctrl+' + i, '', ['FormatBlock', false, 'h' + i]);\n\n\t\t\t\tt.addShortcut('ctrl+7', '', ['FormatBlock', false, 'p']);\n\t\t\t\tt.addShortcut('ctrl+8', '', ['FormatBlock', false, 'div']);\n\t\t\t\tt.addShortcut('ctrl+9', '', ['FormatBlock', false, 'address']);\n\n\t\t\t\tfunction find(e) {\n\t\t\t\t\tvar v = null;\n\n\t\t\t\t\tif (!e.altKey && !e.ctrlKey && !e.metaKey)\n\t\t\t\t\t\treturn v;\n\n\t\t\t\t\teach(t.shortcuts, function(o) {\n\t\t\t\t\t\tif (tinymce.isMac && o.ctrl != e.metaKey)\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\telse if (!tinymce.isMac && o.ctrl != e.ctrlKey)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tif (o.alt != e.altKey)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tif (o.shift != e.shiftKey)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tif (e.keyCode == o.keyCode || (e.charCode && e.charCode == o.charCode)) {\n\t\t\t\t\t\t\tv = o;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\n\t\t\t\t\treturn v;\n\t\t\t\t};\n\n\t\t\t\tt.onKeyUp.add(function(ed, e) {\n\t\t\t\t\tvar o = find(e);\n\n\t\t\t\t\tif (o)\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t});\n\n\t\t\t\tt.onKeyPress.add(function(ed, e) {\n\t\t\t\t\tvar o = find(e);\n\n\t\t\t\t\tif (o)\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t});\n\n\t\t\t\tt.onKeyDown.add(function(ed, e) {\n\t\t\t\t\tvar o = find(e);\n\n\t\t\t\t\tif (o) {\n\t\t\t\t\t\to.func.call(o.scope);\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (tinymce.isIE) {\n\t\t\t\t// Fix so resize will only update the width and height attributes not the styles of an image\n\t\t\t\t// It will also block mceItemNoResize items\n\t\t\t\tdom.bind(t.getDoc(), 'controlselect', function(e) {\n\t\t\t\t\tvar re = t.resizeInfo, cb;\n\n\t\t\t\t\te = e.target;\n\n\t\t\t\t\t// Don't do this action for non image elements\n\t\t\t\t\tif (e.nodeName !== 'IMG')\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tif (re)\n\t\t\t\t\t\tdom.unbind(re.node, re.ev, re.cb);\n\n\t\t\t\t\tif (!dom.hasClass(e, 'mceItemNoResize')) {\n\t\t\t\t\t\tev = 'resizeend';\n\t\t\t\t\t\tcb = dom.bind(e, ev, function(e) {\n\t\t\t\t\t\t\tvar v;\n\n\t\t\t\t\t\t\te = e.target;\n\n\t\t\t\t\t\t\tif (v = dom.getStyle(e, 'width')) {\n\t\t\t\t\t\t\t\tdom.setAttrib(e, 'width', v.replace(/[^0-9%]+/g, ''));\n\t\t\t\t\t\t\t\tdom.setStyle(e, 'width', '');\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (v = dom.getStyle(e, 'height')) {\n\t\t\t\t\t\t\t\tdom.setAttrib(e, 'height', v.replace(/[^0-9%]+/g, ''));\n\t\t\t\t\t\t\t\tdom.setStyle(e, 'height', '');\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t} else {\n\t\t\t\t\t\tev = 'resizestart';\n\t\t\t\t\t\tcb = dom.bind(e, 'resizestart', Event.cancel, Event);\n\t\t\t\t\t}\n\n\t\t\t\t\tre = t.resizeInfo = {\n\t\t\t\t\t\tnode : e,\n\t\t\t\t\t\tev : ev,\n\t\t\t\t\t\tcb : cb\n\t\t\t\t\t};\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (tinymce.isOpera) {\n\t\t\t\tt.onClick.add(function(ed, e) {\n\t\t\t\t\tEvent.prevent(e);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Add custom undo/redo handlers\n\t\t\tif (s.custom_undo_redo) {\n\t\t\t\tfunction addUndo() {\n\t\t\t\t\tt.undoManager.typing = false;\n\t\t\t\t\tt.undoManager.add();\n\t\t\t\t};\n\n\t\t\t\tdom.bind(t.getDoc(), 'focusout', function(e) {\n\t\t\t\t\tif (!t.removed && t.undoManager.typing)\n\t\t\t\t\t\taddUndo();\n\t\t\t\t});\n\n\t\t\t\t// Add undo level when contents is drag/dropped within the editor\n\t\t\t\tt.dom.bind(t.dom.getRoot(), 'dragend', function(e) {\n\t\t\t\t\taddUndo();\n\t\t\t\t});\n\n\t\t\t\tt.onKeyUp.add(function(ed, e) {\n\t\t\t\t\tvar keyCode = e.keyCode;\n\n\t\t\t\t\tif ((keyCode >= 33 && keyCode <= 36) || (keyCode >= 37 && keyCode <= 40) || keyCode == 13 || keyCode == 45 || e.ctrlKey)\n\t\t\t\t\t\taddUndo();\n\t\t\t\t});\n\n\t\t\t\tt.onKeyDown.add(function(ed, e) {\n\t\t\t\t\tvar keyCode = e.keyCode, sel;\n\n\t\t\t\t\tif (keyCode == 8) {\n\t\t\t\t\t\tsel = t.getDoc().selection;\n\n\t\t\t\t\t\t// Fix IE control + backspace browser bug\n\t\t\t\t\t\tif (sel && sel.createRange && sel.createRange().item) {\n\t\t\t\t\t\t\tt.undoManager.beforeChange();\n\t\t\t\t\t\t\ted.dom.remove(sel.createRange().item(0));\n\t\t\t\t\t\t\taddUndo();\n\n\t\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Is caracter positon keys left,right,up,down,home,end,pgdown,pgup,enter\n\t\t\t\t\tif ((keyCode >= 33 && keyCode <= 36) || (keyCode >= 37 && keyCode <= 40) || keyCode == 13 || keyCode == 45) {\n\t\t\t\t\t\t// Add position before enter key is pressed, used by IE since it still uses the default browser behavior\n\t\t\t\t\t\t// Todo: Remove this once we normalize enter behavior on IE\n\t\t\t\t\t\tif (tinymce.isIE && keyCode == 13)\n\t\t\t\t\t\t\tt.undoManager.beforeChange();\n\n\t\t\t\t\t\tif (t.undoManager.typing)\n\t\t\t\t\t\t\taddUndo();\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// If key isn't shift,ctrl,alt,capslock,metakey\n\t\t\t\t\tif ((keyCode < 16 || keyCode > 20) && keyCode != 224 && keyCode != 91 && !t.undoManager.typing) {\n\t\t\t\t\t\tt.undoManager.beforeChange();\n\t\t\t\t\t\tt.undoManager.typing = true;\n\t\t\t\t\t\tt.undoManager.add();\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tt.onMouseDown.add(function() {\n\t\t\t\t\tif (t.undoManager.typing)\n\t\t\t\t\t\taddUndo();\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Bug fix for FireFox keeping styles from end of selection instead of start.\n\t\t\tif (tinymce.isGecko) {\n\t\t\t\tfunction getAttributeApplyFunction() {\n\t\t\t\t\tvar template = t.dom.getAttribs(t.selection.getStart().cloneNode(false));\n\n\t\t\t\t\treturn function() {\n\t\t\t\t\t\tvar target = t.selection.getStart();\n\n\t\t\t\t\t\tif (target !== t.getBody()) {\n\t\t\t\t\t\t\tt.dom.setAttrib(target, \"style\", null);\n\n\t\t\t\t\t\t\teach(template, function(attr) {\n\t\t\t\t\t\t\t\ttarget.setAttributeNode(attr.cloneNode(true));\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\tfunction isSelectionAcrossElements() {\n\t\t\t\t\tvar s = t.selection;\n\n\t\t\t\t\treturn !s.isCollapsed() && s.getStart() != s.getEnd();\n\t\t\t\t}\n\n\t\t\t\tt.onKeyPress.add(function(ed, e) {\n\t\t\t\t\tvar applyAttributes;\n\n\t\t\t\t\tif ((e.keyCode == 8 || e.keyCode == 46) && isSelectionAcrossElements()) {\n\t\t\t\t\t\tapplyAttributes = getAttributeApplyFunction();\n\t\t\t\t\t\tt.getDoc().execCommand('delete', false, null);\n\t\t\t\t\t\tapplyAttributes();\n\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tt.dom.bind(t.getDoc(), 'cut', function(e) {\n\t\t\t\t\tvar applyAttributes;\n\n\t\t\t\t\tif (isSelectionAcrossElements()) {\n\t\t\t\t\t\tapplyAttributes = getAttributeApplyFunction();\n\t\t\t\t\t\tt.onKeyUp.addToTop(Event.cancel, Event);\n\n\t\t\t\t\t\tsetTimeout(function() {\n\t\t\t\t\t\t\tapplyAttributes();\n\t\t\t\t\t\t\tt.onKeyUp.remove(Event.cancel, Event);\n\t\t\t\t\t\t}, 0);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\t_refreshContentEditable : function() {\n\t\t\tvar self = this, body, parent;\n\n\t\t\t// Check if the editor was hidden and the re-initalize contentEditable mode by removing and adding the body again\n\t\t\tif (self._isHidden()) {\n\t\t\t\tbody = self.getBody();\n\t\t\t\tparent = body.parentNode;\n\n\t\t\t\tparent.removeChild(body);\n\t\t\t\tparent.appendChild(body);\n\n\t\t\t\tbody.focus();\n\t\t\t}\n\t\t},\n\n\t\t_isHidden : function() {\n\t\t\tvar s;\n\n\t\t\tif (!isGecko)\n\t\t\t\treturn 0;\n\n\t\t\t// Weird, wheres that cursor selection?\n\t\t\ts = this.selection.getSel();\n\t\t\treturn (!s || !s.rangeCount || s.rangeCount == 0);\n\t\t}\n\t});\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/tinymce.js":"/**\n * tinymce.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(win) {\n\tvar whiteSpaceRe = /^\\s*|\\s*$/g,\n\t\tundefined, isRegExpBroken = 'B'.replace(/A(.)|B/, '$1') === '$1';\n\n\t/**\n\t * Core namespace with core functionality for the TinyMCE API all sub classes will be added to this namespace/object.\n\t *\n\t * @static\n\t * @class tinymce\n\t * @example\n\t * // Using each method\n\t * tinymce.each([1, 2, 3], function(v, i) {\n\t *   console.log(i + '=' + v);\n\t * });\n\t *\n\t * // Checking for a specific browser\n\t * if (tinymce.isIE)\n\t *   console.log(\"IE\");\n\t */\n\tvar tinymce = {\n\t\t/**\n\t\t * Major version of TinyMCE build.\n\t\t *\n\t\t * @property majorVersion\n\t\t * @type String\n\t\t */\n\t\tmajorVersion : '@@tinymce_major_version@@',\n\n\t\t/**\n\t\t * Major version of TinyMCE build.\n\t\t *\n\t\t * @property minorVersion\n\t\t * @type String\n\t\t */\n\t\tminorVersion : '@@tinymce_minor_version@@',\n\n\t\t/**\n\t\t * Release date of TinyMCE build.\n\t\t *\n\t\t * @property releaseDate\n\t\t * @type String\n\t\t */\n\t\treleaseDate : '@@tinymce_release_date@@',\n\n\t\t/**\n\t\t * Initializes the TinyMCE global namespace this will setup browser detection and figure out where TinyMCE is running from.\n\t\t */\n\t\t_init : function() {\n\t\t\tvar t = this, d = document, na = navigator, ua = na.userAgent, i, nl, n, base, p, v;\n\n\t\t\t/**\n\t\t\t * Constant that is true if the browser is Opera.\n\t\t\t *\n\t\t\t * @property isOpera\n\t\t\t * @type Boolean\n\t\t\t * @final\n\t\t\t */\n\t\t\tt.isOpera = win.opera && opera.buildNumber;\n\n\t\t\t/**\n\t\t\t * Constant that is true if the browser is WebKit (Safari/Chrome).\n\t\t\t *\n\t\t\t * @property isWebKit\n\t\t\t * @type Boolean\n\t\t\t * @final\n\t\t\t */\n\t\t\tt.isWebKit = /WebKit/.test(ua);\n\n\t\t\t/**\n\t\t\t * Constant that is true if the browser is IE.\n\t\t\t *\n\t\t\t * @property isIE\n\t\t\t * @type Boolean\n\t\t\t * @final\n\t\t\t */\n\t\t\tt.isIE = !t.isWebKit && !t.isOpera && (/MSIE/gi).test(ua) && (/Explorer/gi).test(na.appName);\n\n\t\t\t/**\n\t\t\t * Constant that is true if the browser is IE 6 or older.\n\t\t\t *\n\t\t\t * @property isIE6\n\t\t\t * @type Boolean\n\t\t\t * @final\n\t\t\t */\n\t\t\tt.isIE6 = t.isIE && /MSIE [56]/.test(ua);\n\n\t\t\t/**\n\t\t\t * Constant that is true if the browser is IE 7.\n\t\t\t *\n\t\t\t * @property isIE7\n\t\t\t * @type Boolean\n\t\t\t * @final\n\t\t\t */\n\t\t\tt.isIE7 = t.isIE && /MSIE [7]/.test(ua);\n\n\t\t\t/**\n\t\t\t * Constant that is true if the browser is IE 8.\n\t\t\t *\n\t\t\t * @property isIE8\n\t\t\t * @type Boolean\n\t\t\t * @final\n\t\t\t */\n\t\t\tt.isIE8 = t.isIE && /MSIE [8]/.test(ua);\n\n\t\t\t/**\n\t\t\t * Constant that is true if the browser is IE 9.\n\t\t\t *\n\t\t\t * @property isIE9\n\t\t\t * @type Boolean\n\t\t\t * @final\n\t\t\t */\n\t\t\tt.isIE9 = t.isIE && /MSIE [9]/.test(ua);\n\n\t\t\t/**\n\t\t\t * Constant that is true if the browser is Gecko.\n\t\t\t *\n\t\t\t * @property isGecko\n\t\t\t * @type Boolean\n\t\t\t * @final\n\t\t\t */\n\t\t\tt.isGecko = !t.isWebKit && /Gecko/.test(ua);\n\n\t\t\t/**\n\t\t\t * Constant that is true if the os is Mac OS.\n\t\t\t *\n\t\t\t * @property isMac\n\t\t\t * @type Boolean\n\t\t\t * @final\n\t\t\t */\n\t\t\tt.isMac = ua.indexOf('Mac') != -1;\n\n\t\t\t/**\n\t\t\t * Constant that is true if the runtime is Adobe Air.\n\t\t\t *\n\t\t\t * @property isAir\n\t\t\t * @type Boolean\n\t\t\t * @final\n\t\t\t */\n\t\t\tt.isAir = /adobeair/i.test(ua);\n\n\t\t\t/**\n\t\t\t * Constant that tells if the current browser is an iPhone or iPad.\n\t\t\t *\n\t\t\t * @property isIDevice\n\t\t\t * @type Boolean\n\t\t\t * @final\n\t\t\t */\n\t\t\tt.isIDevice = /(iPad|iPhone)/.test(ua);\n\t\t\t\n\t\t\t/**\n\t\t\t * Constant that is true if the current browser is running on iOS 5 or greater.\n\t\t\t *\n\t\t\t * @property isIOS5\n\t\t\t * @type Boolean\n\t\t\t * @final\n\t\t\t */\n\t\t\tt.isIOS5 = t.isIDevice && ua.match(/AppleWebKit\\/(\\d*)/)[1]>=534;\n\n\t\t\t// TinyMCE .NET webcontrol might be setting the values for TinyMCE\n\t\t\tif (win.tinyMCEPreInit) {\n\t\t\t\tt.suffix = tinyMCEPreInit.suffix;\n\t\t\t\tt.baseURL = tinyMCEPreInit.base;\n\t\t\t\tt.query = tinyMCEPreInit.query;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Get suffix and base\n\t\t\tt.suffix = '';\n\n\t\t\t// If base element found, add that infront of baseURL\n\t\t\tnl = d.getElementsByTagName('base');\n\t\t\tfor (i=0; i<nl.length; i++) {\n\t\t\t\tif (v = nl[i].href) {\n\t\t\t\t\t// Host only value like http://site.com or http://site.com:8008\n\t\t\t\t\tif (/^https?:\\/\\/[^\\/]+$/.test(v))\n\t\t\t\t\t\tv += '/';\n\n\t\t\t\t\tbase = v ? v.match(/.*\\//)[0] : ''; // Get only directory\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tfunction getBase(n) {\n\t\t\t\tif (n.src && /tiny_mce(|_gzip|_jquery|_prototype|_full)(_dev|_src)?.js/.test(n.src)) {\n\t\t\t\t\tif (/_(src|dev)\\.js/g.test(n.src))\n\t\t\t\t\t\tt.suffix = '_src';\n\n\t\t\t\t\tif ((p = n.src.indexOf('?')) != -1)\n\t\t\t\t\t\tt.query = n.src.substring(p + 1);\n\n\t\t\t\t\tt.baseURL = n.src.substring(0, n.src.lastIndexOf('/'));\n\n\t\t\t\t\t// If path to script is relative and a base href was found add that one infront\n\t\t\t\t\t// the src property will always be an absolute one on non IE browsers and IE 8\n\t\t\t\t\t// so this logic will basically only be executed on older IE versions\n\t\t\t\t\tif (base && t.baseURL.indexOf('://') == -1 && t.baseURL.indexOf('/') !== 0)\n\t\t\t\t\t\tt.baseURL = base + t.baseURL;\n\n\t\t\t\t\treturn t.baseURL;\n\t\t\t\t}\n\n\t\t\t\treturn null;\n\t\t\t};\n\n\t\t\t// Check document\n\t\t\tnl = d.getElementsByTagName('script');\n\t\t\tfor (i=0; i<nl.length; i++) {\n\t\t\t\tif (getBase(nl[i]))\n\t\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Check head\n\t\t\tn = d.getElementsByTagName('head')[0];\n\t\t\tif (n) {\n\t\t\t\tnl = n.getElementsByTagName('script');\n\t\t\t\tfor (i=0; i<nl.length; i++) {\n\t\t\t\t\tif (getBase(nl[i]))\n\t\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn;\n\t\t},\n\n\t\t/**\n\t\t * Checks if a object is of a specific type for example an array.\n\t\t *\n\t\t * @method is\n\t\t * @param {Object} o Object to check type of.\n\t\t * @param {string} t Optional type to check for.\n\t\t * @return {Boolean} true/false if the object is of the specified type.\n\t\t */\n\t\tis : function(o, t) {\n\t\t\tif (!t)\n\t\t\t\treturn o !== undefined;\n\n\t\t\tif (t == 'array' && (o.hasOwnProperty && o instanceof Array))\n\t\t\t\treturn true;\n\n\t\t\treturn typeof(o) == t;\n\t\t},\n\n\t\t/**\n\t\t * Makes a name/object map out of an array with names.\n\t\t *\n\t\t * @method makeMap\n\t\t * @param {Array/String} items Items to make map out of.\n\t\t * @param {String} delim Optional delimiter to split string by.\n\t\t * @param {Object} map Optional map to add items to.\n\t\t * @return {Object} Name/value map of items.\n\t\t */\n\t\tmakeMap : function(items, delim, map) {\n\t\t\tvar i;\n\n\t\t\titems = items || [];\n\t\t\tdelim = delim || ',';\n\n\t\t\tif (typeof(items) == \"string\")\n\t\t\t\titems = items.split(delim);\n\n\t\t\tmap = map || {};\n\n\t\t\ti = items.length;\n\t\t\twhile (i--)\n\t\t\t\tmap[items[i]] = {};\n\n\t\t\treturn map;\n\t\t},\n\n\t\t/**\n\t\t * Performs an iteration of all items in a collection such as an object or array. This method will execure the\n\t\t * callback function for each item in the collection, if the callback returns false the iteration will terminate.\n\t\t * The callback has the following format: cb(value, key_or_index).\n\t\t *\n\t\t * @method each\n\t\t * @param {Object} o Collection to iterate.\n\t\t * @param {function} cb Callback function to execute for each item.\n\t\t * @param {Object} s Optional scope to execute the callback in.\n\t\t * @example\n\t\t * // Iterate an array\n\t\t * tinymce.each([1,2,3], function(v, i) {\n\t\t *     console.debug(\"Value: \" + v + \", Index: \" + i);\n\t\t * });\n\t\t * \n\t\t * // Iterate an object\n\t\t * tinymce.each({a : 1, b : 2, c: 3], function(v, k) {\n\t\t *     console.debug(\"Value: \" + v + \", Key: \" + k);\n\t\t * });\n\t\t */\n\t\teach : function(o, cb, s) {\n\t\t\tvar n, l;\n\n\t\t\tif (!o)\n\t\t\t\treturn 0;\n\n\t\t\ts = s || o;\n\n\t\t\tif (o.length !== undefined) {\n\t\t\t\t// Indexed arrays, needed for Safari\n\t\t\t\tfor (n=0, l = o.length; n < l; n++) {\n\t\t\t\t\tif (cb.call(s, o[n], n, o) === false)\n\t\t\t\t\t\treturn 0;\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Hashtables\n\t\t\t\tfor (n in o) {\n\t\t\t\t\tif (o.hasOwnProperty(n)) {\n\t\t\t\t\t\tif (cb.call(s, o[n], n, o) === false)\n\t\t\t\t\t\t\treturn 0;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn 1;\n\t\t},\n\n\t\t// #ifndef jquery\n\n\t\t/**\n\t\t * Creates a new array by the return value of each iteration function call. This enables you to convert\n\t\t * one array list into another.\n\t\t *\n\t\t * @method map\n\t\t * @param {Array} a Array of items to iterate.\n\t\t * @param {function} f Function to call for each item. It's return value will be the new value.\n\t\t * @return {Array} Array with new values based on function return values.\n\t\t */\n\t\tmap : function(a, f) {\n\t\t\tvar o = [];\n\n\t\t\ttinymce.each(a, function(v) {\n\t\t\t\to.push(f(v));\n\t\t\t});\n\n\t\t\treturn o;\n\t\t},\n\n\t\t/**\n\t\t * Filters out items from the input array by calling the specified function for each item.\n\t\t * If the function returns false the item will be excluded if it returns true it will be included.\n\t\t *\n\t\t * @method grep\n\t\t * @param {Array} a Array of items to loop though.\n\t\t * @param {function} f Function to call for each item. Include/exclude depends on it's return value.\n\t\t * @return {Array} New array with values imported and filtered based in input.\n\t\t * @example\n\t\t * // Filter out some items, this will return an array with 4 and 5\n\t\t * var items = tinymce.grep([1,2,3,4,5], function(v) {return v > 3;});\n\t\t */\n\t\tgrep : function(a, f) {\n\t\t\tvar o = [];\n\n\t\t\ttinymce.each(a, function(v) {\n\t\t\t\tif (!f || f(v))\n\t\t\t\t\to.push(v);\n\t\t\t});\n\n\t\t\treturn o;\n\t\t},\n\n\t\t/**\n\t\t * Returns the index of a value in an array, this method will return -1 if the item wasn't found.\n\t\t *\n\t\t * @method inArray\n\t\t * @param {Array} a Array/Object to search for value in.\n\t\t * @param {Object} v Value to check for inside the array.\n\t\t * @return {Number/String} Index of item inside the array inside an object. Or -1 if it wasn't found.\n\t\t * @example\n\t\t * // Get index of value in array this will alert 1 since 2 is at that index\n\t\t * alert(tinymce.inArray([1,2,3], 2));\n\t\t */\n\t\tinArray : function(a, v) {\n\t\t\tvar i, l;\n\n\t\t\tif (a) {\n\t\t\t\tfor (i = 0, l = a.length; i < l; i++) {\n\t\t\t\t\tif (a[i] === v)\n\t\t\t\t\t\treturn i;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn -1;\n\t\t},\n\n\t\t/**\n\t\t * Extends an object with the specified other object(s).\n\t\t *\n\t\t * @method extend\n\t\t * @param {Object} o Object to extend with new items.\n\t\t * @param {Object} e..n Object(s) to extend the specified object with.\n\t\t * @return {Object} o New extended object, same reference as the input object.\n\t\t * @example\n\t\t * // Extends obj1 with two new fields\n\t\t * var obj = tinymce.extend(obj1, {\n\t\t *     somefield1 : 'a',\n\t\t *     somefield2 : 'a'\n\t\t * });\n\t\t * \n\t\t * // Extends obj with obj2 and obj3\n\t\t * tinymce.extend(obj, obj2, obj3);\n\t\t */\n\t\textend : function(o, e) {\n\t\t\tvar i, l, a = arguments;\n\n\t\t\tfor (i = 1, l = a.length; i < l; i++) {\n\t\t\t\te = a[i];\n\n\t\t\t\ttinymce.each(e, function(v, n) {\n\t\t\t\t\tif (v !== undefined)\n\t\t\t\t\t\to[n] = v;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn o;\n\t\t},\n\n\t\t// #endif\n\n\t\t/**\n\t\t * Removes whitespace from the beginning and end of a string.\n\t\t *\n\t\t * @method trim\n\t\t * @param {String} s String to remove whitespace from.\n\t\t * @return {String} New string with removed whitespace.\n\t\t */\n\t\ttrim : function(s) {\n\t\t\treturn (s ? '' + s : '').replace(whiteSpaceRe, '');\n\t\t},\n\n\t\t/**\n\t\t * Creates a class, subclass or static singleton.\n\t\t * More details on this method can be found in the Wiki.\n\t\t *\n\t\t * @method create\n\t\t * @param {String} s Class name, inheritage and prefix.\n\t\t * @param {Object} p Collection of methods to add to the class.\n\t\t * @param {Object} root Optional root object defaults to the global window object.\n\t\t * @example\n\t\t * // Creates a basic class\n\t\t * tinymce.create('tinymce.somepackage.SomeClass', {\n\t\t *     SomeClass : function() {\n\t\t *         // Class constructor\n\t\t *     },\n\t\t * \n\t\t *     method : function() {\n\t\t *         // Some method\n\t\t *     }\n\t\t * });\n\t\t *\n\t\t * // Creates a basic subclass class\n\t\t * tinymce.create('tinymce.somepackage.SomeSubClass:tinymce.somepackage.SomeClass', {\n\t\t *     SomeSubClass: function() {\n\t\t *         // Class constructor\n\t\t *         this.parent(); // Call parent constructor\n\t\t *     },\n\t\t * \n\t\t *     method : function() {\n\t\t *         // Some method\n\t\t *         this.parent(); // Call parent method\n\t\t *     },\n\t\t * \n\t\t *     'static' : {\n\t\t *         staticMethod : function() {\n\t\t *             // Static method\n\t\t *         }\n\t\t *     }\n\t\t * });\n\t\t *\n\t\t * // Creates a singleton/static class\n\t\t * tinymce.create('static tinymce.somepackage.SomeSingletonClass', {\n\t\t *     method : function() {\n\t\t *         // Some method\n\t\t *     }\n\t\t * });\n\t\t */\n\t\tcreate : function(s, p, root) {\n\t\t\tvar t = this, sp, ns, cn, scn, c, de = 0;\n\n\t\t\t// Parse : <prefix> <class>:<super class>\n\t\t\ts = /^((static) )?([\\w.]+)(:([\\w.]+))?/.exec(s);\n\t\t\tcn = s[3].match(/(^|\\.)(\\w+)$/i)[2]; // Class name\n\n\t\t\t// Create namespace for new class\n\t\t\tns = t.createNS(s[3].replace(/\\.\\w+$/, ''), root);\n\n\t\t\t// Class already exists\n\t\t\tif (ns[cn])\n\t\t\t\treturn;\n\n\t\t\t// Make pure static class\n\t\t\tif (s[2] == 'static') {\n\t\t\t\tns[cn] = p;\n\n\t\t\t\tif (this.onCreate)\n\t\t\t\t\tthis.onCreate(s[2], s[3], ns[cn]);\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Create default constructor\n\t\t\tif (!p[cn]) {\n\t\t\t\tp[cn] = function() {};\n\t\t\t\tde = 1;\n\t\t\t}\n\n\t\t\t// Add constructor and methods\n\t\t\tns[cn] = p[cn];\n\t\t\tt.extend(ns[cn].prototype, p);\n\n\t\t\t// Extend\n\t\t\tif (s[5]) {\n\t\t\t\tsp = t.resolve(s[5]).prototype;\n\t\t\t\tscn = s[5].match(/\\.(\\w+)$/i)[1]; // Class name\n\n\t\t\t\t// Extend constructor\n\t\t\t\tc = ns[cn];\n\t\t\t\tif (de) {\n\t\t\t\t\t// Add passthrough constructor\n\t\t\t\t\tns[cn] = function() {\n\t\t\t\t\t\treturn sp[scn].apply(this, arguments);\n\t\t\t\t\t};\n\t\t\t\t} else {\n\t\t\t\t\t// Add inherit constructor\n\t\t\t\t\tns[cn] = function() {\n\t\t\t\t\t\tthis.parent = sp[scn];\n\t\t\t\t\t\treturn c.apply(this, arguments);\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t\tns[cn].prototype[cn] = ns[cn];\n\n\t\t\t\t// Add super methods\n\t\t\t\tt.each(sp, function(f, n) {\n\t\t\t\t\tns[cn].prototype[n] = sp[n];\n\t\t\t\t});\n\n\t\t\t\t// Add overridden methods\n\t\t\t\tt.each(p, function(f, n) {\n\t\t\t\t\t// Extend methods if needed\n\t\t\t\t\tif (sp[n]) {\n\t\t\t\t\t\tns[cn].prototype[n] = function() {\n\t\t\t\t\t\t\tthis.parent = sp[n];\n\t\t\t\t\t\t\treturn f.apply(this, arguments);\n\t\t\t\t\t\t};\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif (n != cn)\n\t\t\t\t\t\t\tns[cn].prototype[n] = f;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Add static methods\n\t\t\tt.each(p['static'], function(f, n) {\n\t\t\t\tns[cn][n] = f;\n\t\t\t});\n\n\t\t\tif (this.onCreate)\n\t\t\t\tthis.onCreate(s[2], s[3], ns[cn].prototype);\n\t\t},\n\n\t\t/**\n\t\t * Executed the specified function for each item in a object tree.\n\t\t *\n\t\t * @method walk\n\t\t * @param {Object} o Object tree to walk though.\n\t\t * @param {function} f Function to call for each item.\n\t\t * @param {String} n Optional name of collection inside the objects to walk for example childNodes.\n\t\t * @param {String} s Optional scope to execute the function in.\n\t\t */\n\t\twalk : function(o, f, n, s) {\n\t\t\ts = s || this;\n\n\t\t\tif (o) {\n\t\t\t\tif (n)\n\t\t\t\t\to = o[n];\n\n\t\t\t\ttinymce.each(o, function(o, i) {\n\t\t\t\t\tif (f.call(s, o, i, n) === false)\n\t\t\t\t\t\treturn false;\n\n\t\t\t\t\ttinymce.walk(o, f, n, s);\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Creates a namespace on a specific object.\n\t\t *\n\t\t * @method createNS\n\t\t * @param {String} n Namespace to create for example a.b.c.d.\n\t\t * @param {Object} o Optional object to add namespace to, defaults to window.\n\t\t * @return {Object} New namespace object the last item in path.\n\t\t * @example\n\t\t * // Create some namespace\n\t\t * tinymce.createNS('tinymce.somepackage.subpackage');\n\t\t *\n\t\t * // Add a singleton\n\t\t * var tinymce.somepackage.subpackage.SomeSingleton = {\n\t\t *     method : function() {\n\t\t *         // Some method\n\t\t *     }\n\t\t * };\n\t\t */\n\t\tcreateNS : function(n, o) {\n\t\t\tvar i, v;\n\n\t\t\to = o || win;\n\n\t\t\tn = n.split('.');\n\t\t\tfor (i=0; i<n.length; i++) {\n\t\t\t\tv = n[i];\n\n\t\t\t\tif (!o[v])\n\t\t\t\t\to[v] = {};\n\n\t\t\t\to = o[v];\n\t\t\t}\n\n\t\t\treturn o;\n\t\t},\n\n\t\t/**\n\t\t * Resolves a string and returns the object from a specific structure.\n\t\t *\n\t\t * @method resolve\n\t\t * @param {String} n Path to resolve for example a.b.c.d.\n\t\t * @param {Object} o Optional object to search though, defaults to window.\n\t\t * @return {Object} Last object in path or null if it couldn't be resolved.\n\t\t * @example\n\t\t * // Resolve a path into an object reference\n\t\t * var obj = tinymce.resolve('a.b.c.d');\n\t\t */\n\t\tresolve : function(n, o) {\n\t\t\tvar i, l;\n\n\t\t\to = o || win;\n\n\t\t\tn = n.split('.');\n\t\t\tfor (i = 0, l = n.length; i < l; i++) {\n\t\t\t\to = o[n[i]];\n\n\t\t\t\tif (!o)\n\t\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\treturn o;\n\t\t},\n\n\t\t/**\n\t\t * Adds an unload handler to the document. This handler will be executed when the document gets unloaded.\n\t\t * This method is useful for dealing with browser memory leaks where it might be vital to remove DOM references etc.\n\t\t *\n\t\t * @method addUnload\n\t\t * @param {function} f Function to execute before the document gets unloaded.\n\t\t * @param {Object} s Optional scope to execute the function in.\n\t\t * @return {function} Returns the specified unload handler function.\n\t\t * @example\n\t\t * // Fixes a leak with a DOM element that was palces in the someObject\n\t\t * tinymce.addUnload(function() {\n\t\t *     // Null DOM element to reduce IE memory leak\n\t\t *     someObject.someElement = null;\n\t\t * });\n\t\t */\n\t\taddUnload : function(f, s) {\n\t\t\tvar t = this;\n\n\t\t\tf = {func : f, scope : s || this};\n\n\t\t\tif (!t.unloads) {\n\t\t\t\tfunction unload() {\n\t\t\t\t\tvar li = t.unloads, o, n;\n\n\t\t\t\t\tif (li) {\n\t\t\t\t\t\t// Call unload handlers\n\t\t\t\t\t\tfor (n in li) {\n\t\t\t\t\t\t\to = li[n];\n\n\t\t\t\t\t\t\tif (o && o.func)\n\t\t\t\t\t\t\t\to.func.call(o.scope, 1); // Send in one arg to distinct unload and user destroy\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Detach unload function\n\t\t\t\t\t\tif (win.detachEvent) {\n\t\t\t\t\t\t\twin.detachEvent('onbeforeunload', fakeUnload);\n\t\t\t\t\t\t\twin.detachEvent('onunload', unload);\n\t\t\t\t\t\t} else if (win.removeEventListener)\n\t\t\t\t\t\t\twin.removeEventListener('unload', unload, false);\n\n\t\t\t\t\t\t// Destroy references\n\t\t\t\t\t\tt.unloads = o = li = w = unload = 0;\n\n\t\t\t\t\t\t// Run garbarge collector on IE\n\t\t\t\t\t\tif (win.CollectGarbage)\n\t\t\t\t\t\t\tCollectGarbage();\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\tfunction fakeUnload() {\n\t\t\t\t\tvar d = document;\n\n\t\t\t\t\t// Is there things still loading, then do some magic\n\t\t\t\t\tif (d.readyState == 'interactive') {\n\t\t\t\t\t\tfunction stop() {\n\t\t\t\t\t\t\t// Prevent memory leak\n\t\t\t\t\t\t\td.detachEvent('onstop', stop);\n\n\t\t\t\t\t\t\t// Call unload handler\n\t\t\t\t\t\t\tif (unload)\n\t\t\t\t\t\t\t\tunload();\n\n\t\t\t\t\t\t\td = 0;\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\t// Fire unload when the currently loading page is stopped\n\t\t\t\t\t\tif (d)\n\t\t\t\t\t\t\td.attachEvent('onstop', stop);\n\n\t\t\t\t\t\t// Remove onstop listener after a while to prevent the unload function\n\t\t\t\t\t\t// to execute if the user presses cancel in an onbeforeunload\n\t\t\t\t\t\t// confirm dialog and then presses the browser stop button\n\t\t\t\t\t\twin.setTimeout(function() {\n\t\t\t\t\t\t\tif (d)\n\t\t\t\t\t\t\t\td.detachEvent('onstop', stop);\n\t\t\t\t\t\t}, 0);\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\t// Attach unload handler\n\t\t\t\tif (win.attachEvent) {\n\t\t\t\t\twin.attachEvent('onunload', unload);\n\t\t\t\t\twin.attachEvent('onbeforeunload', fakeUnload);\n\t\t\t\t} else if (win.addEventListener)\n\t\t\t\t\twin.addEventListener('unload', unload, false);\n\n\t\t\t\t// Setup initial unload handler array\n\t\t\t\tt.unloads = [f];\n\t\t\t} else\n\t\t\t\tt.unloads.push(f);\n\n\t\t\treturn f;\n\t\t},\n\n\t\t/**\n\t\t * Removes the specified function form the unload handler list.\n\t\t *\n\t\t * @method removeUnload\n\t\t * @param {function} f Function to remove from unload handler list.\n\t\t * @return {function} Removed function name or null if it wasn't found.\n\t\t */\n\t\tremoveUnload : function(f) {\n\t\t\tvar u = this.unloads, r = null;\n\n\t\t\ttinymce.each(u, function(o, i) {\n\t\t\t\tif (o && o.func == f) {\n\t\t\t\t\tu.splice(i, 1);\n\t\t\t\t\tr = f;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn r;\n\t\t},\n\n\t\t/**\n\t\t * Splits a string but removes the whitespace before and after each value.\n\t\t *\n\t\t * @method explode\n\t\t * @param {string} s String to split.\n\t\t * @param {string} d Delimiter to split by.\n\t\t * @example\n\t\t * // Split a string into an array with a,b,c\n\t\t * var arr = tinymce.explode('a, b,   c');\n\t\t */\n\t\texplode : function(s, d) {\n\t\t\treturn s ? tinymce.map(s.split(d || ','), tinymce.trim) : s;\n\t\t},\n\n\t\t_addVer : function(u) {\n\t\t\tvar v;\n\n\t\t\tif (!this.query)\n\t\t\t\treturn u;\n\n\t\t\tv = (u.indexOf('?') == -1 ? '?' : '&') + this.query;\n\n\t\t\tif (u.indexOf('#') == -1)\n\t\t\t\treturn u + v;\n\n\t\t\treturn u.replace('#', v + '#');\n\t\t},\n\n\t\t// Fix function for IE 9 where regexps isn't working correctly\n\t\t// Todo: remove me once MS fixes the bug\n\t\t_replace : function(find, replace, str) {\n\t\t\t// On IE9 we have to fake $x replacement\n\t\t\tif (isRegExpBroken) {\n\t\t\t\treturn str.replace(find, function() {\n\t\t\t\t\tvar val = replace, args = arguments, i;\n\n\t\t\t\t\tfor (i = 0; i < args.length - 2; i++) {\n\t\t\t\t\t\tif (args[i] === undefined) {\n\t\t\t\t\t\t\tval = val.replace(new RegExp('\\\\$' + i, 'g'), '');\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tval = val.replace(new RegExp('\\\\$' + i, 'g'), args[i]);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn val;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn str.replace(find, replace);\n\t\t}\n\n\t\t/**#@-*/\n\t};\n\n\t// Initialize the API\n\ttinymce._init();\n\n\t// Expose tinymce namespace to the global namespace (window)\n\twin.tinymce = win.tinyMCE = tinymce;\n\n\t// Describe the different namespaces\n\n\t/**\n\t * Root level namespace this contains classes directly releated to the TinyMCE editor.\n\t *\n\t * @namespace tinymce\n\t */\n\n\t/**\n\t * Contains classes for handling the browsers DOM.\n\t *\n\t * @namespace tinymce.dom\n\t */\n\n\t/**\n\t * Contains html parser and serializer logic.\n\t *\n\t * @namespace tinymce.html\n\t */\n\n\t/**\n\t * Contains the different UI types such as buttons, listboxes etc.\n\t *\n\t * @namespace tinymce.ui\n\t */\n\n\t/**\n\t * Contains various utility classes such as json parser, cookies etc.\n\t *\n\t * @namespace tinymce.util\n\t */\n\n\t/**\n\t * Contains plugin classes.\n\t *\n\t * @namespace tinymce.plugins\n\t */\n})(window);\n","Magento_Tinymce3/tiny_mce/classes/EditorCommands.js":"/**\n * EditorCommands.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\t// Added for compression purposes\n\tvar each = tinymce.each, undefined, TRUE = true, FALSE = false;\n\n\t/**\n\t * This class enables you to add custom editor commands and it contains\n\t * overrides for native browser commands to address various bugs and issues.\n\t *\n\t * @class tinymce.EditorCommands\n\t */\n\ttinymce.EditorCommands = function(editor) {\n\t\tvar dom = editor.dom,\n\t\t\tselection = editor.selection,\n\t\t\tcommands = {state: {}, exec : {}, value : {}},\n\t\t\tsettings = editor.settings,\n\t\t\tformatter = editor.formatter,\n\t\t\tbookmark;\n\n\t\t/**\n\t\t * Executes the specified command.\n\t\t *\n\t\t * @method execCommand\n\t\t * @param {String} command Command to execute.\n\t\t * @param {Boolean} ui Optional user interface state.\n\t\t * @param {Object} value Optional value for command.\n\t\t * @return {Boolean} true/false if the command was found or not.\n\t\t */\n\t\tfunction execCommand(command, ui, value) {\n\t\t\tvar func;\n\n\t\t\tcommand = command.toLowerCase();\n\t\t\tif (func = commands.exec[command]) {\n\t\t\t\tfunc(command, ui, value);\n\t\t\t\treturn TRUE;\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\t/**\n\t\t * Queries the current state for a command for example if the current selection is \"bold\".\n\t\t *\n\t\t * @method queryCommandState\n\t\t * @param {String} command Command to check the state of.\n\t\t * @return {Boolean/Number} true/false if the selected contents is bold or not, -1 if it's not found.\n\t\t */\n\t\tfunction queryCommandState(command) {\n\t\t\tvar func;\n\n\t\t\tcommand = command.toLowerCase();\n\t\t\tif (func = commands.state[command])\n\t\t\t\treturn func(command);\n\n\t\t\treturn -1;\n\t\t};\n\n\t\t/**\n\t\t * Queries the command value for example the current fontsize.\n\t\t *\n\t\t * @method queryCommandValue\n\t\t * @param {String} command Command to check the value of.\n\t\t * @return {Object} Command value of false if it's not found.\n\t\t */\n\t\tfunction queryCommandValue(command) {\n\t\t\tvar func;\n\n\t\t\tcommand = command.toLowerCase();\n\t\t\tif (func = commands.value[command])\n\t\t\t\treturn func(command);\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\t/**\n\t\t * Adds commands to the command collection.\n\t\t *\n\t\t * @method addCommands\n\t\t * @param {Object} command_list Name/value collection with commands to add, the names can also be comma separated.\n\t\t * @param {String} type Optional type to add, defaults to exec. Can be value or state as well.\n\t\t */\n\t\tfunction addCommands(command_list, type) {\n\t\t\ttype = type || 'exec';\n\n\t\t\teach(command_list, function(callback, command) {\n\t\t\t\teach(command.toLowerCase().split(','), function(command) {\n\t\t\t\t\tcommands[type][command] = callback;\n\t\t\t\t});\n\t\t\t});\n\t\t};\n\n\t\t// Expose public methods\n\t\ttinymce.extend(this, {\n\t\t\texecCommand : execCommand,\n\t\t\tqueryCommandState : queryCommandState,\n\t\t\tqueryCommandValue : queryCommandValue,\n\t\t\taddCommands : addCommands\n\t\t});\n\n\t\t// Private methods\n\n\t\tfunction execNativeCommand(command, ui, value) {\n\t\t\tif (ui === undefined)\n\t\t\t\tui = FALSE;\n\n\t\t\tif (value === undefined)\n\t\t\t\tvalue = null;\n\n\t\t\treturn editor.getDoc().execCommand(command, ui, value);\n\t\t};\n\n\t\tfunction isFormatMatch(name) {\n\t\t\treturn formatter.match(name);\n\t\t};\n\n\t\tfunction toggleFormat(name, value) {\n\t\t\tformatter.toggle(name, value ? {value : value} : undefined);\n\t\t};\n\n\t\tfunction storeSelection(type) {\n\t\t\tbookmark = selection.getBookmark(type);\n\t\t};\n\n\t\tfunction restoreSelection() {\n\t\t\tselection.moveToBookmark(bookmark);\n\t\t};\n\n\t\t// Add execCommand overrides\n\t\taddCommands({\n\t\t\t// Ignore these, added for compatibility\n\t\t\t'mceResetDesignMode,mceBeginUndoLevel' : function() {},\n\n\t\t\t// Add undo manager logic\n\t\t\t'mceEndUndoLevel,mceAddUndoLevel' : function() {\n\t\t\t\teditor.undoManager.add();\n\t\t\t},\n\n\t\t\t'Cut,Copy,Paste' : function(command) {\n\t\t\t\tvar doc = editor.getDoc(), failed;\n\n\t\t\t\t// Try executing the native command\n\t\t\t\ttry {\n\t\t\t\t\texecNativeCommand(command);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Command failed\n\t\t\t\t\tfailed = TRUE;\n\t\t\t\t}\n\n\t\t\t\t// Present alert message about clipboard access not being available\n\t\t\t\tif (failed || !doc.queryCommandSupported(command)) {\n\t\t\t\t\tif (tinymce.isGecko) {\n\t\t\t\t\t\teditor.windowManager.confirm(editor.getLang('clipboard_msg'), function(state) {\n\t\t\t\t\t\t\tif (state)\n\t\t\t\t\t\t\t\topen('http://www.mozilla.org/editor/midasdemo/securityprefs.html', '_blank');\n\t\t\t\t\t\t});\n\t\t\t\t\t} else\n\t\t\t\t\t\teditor.windowManager.alert(editor.getLang('clipboard_no_support'));\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Override unlink command\n\t\t\tunlink : function(command) {\n\t\t\t\tif (selection.isCollapsed())\n\t\t\t\t\tselection.select(selection.getNode());\n\n\t\t\t\texecNativeCommand(command);\n\t\t\t\tselection.collapse(FALSE);\n\t\t\t},\n\n\t\t\t// Override justify commands to use the text formatter engine\n\t\t\t'JustifyLeft,JustifyCenter,JustifyRight,JustifyFull' : function(command) {\n\t\t\t\tvar align = command.substring(7);\n\n\t\t\t\t// Remove all other alignments first\n\t\t\t\teach('left,center,right,full'.split(','), function(name) {\n\t\t\t\t\tif (align != name)\n\t\t\t\t\t\tformatter.remove('align' + name);\n\t\t\t\t});\n\n\t\t\t\ttoggleFormat('align' + align);\n\t\t\t\texecCommand('mceRepaint');\n\t\t\t},\n\n\t\t\t// Override list commands to fix WebKit bug\n\t\t\t'InsertUnorderedList,InsertOrderedList' : function(command) {\n\t\t\t\tvar listElm, listParent;\n\n\t\t\t\texecNativeCommand(command);\n\n\t\t\t\t// WebKit produces lists within block elements so we need to split them\n\t\t\t\t// we will replace the native list creation logic to custom logic later on\n\t\t\t\t// TODO: Remove this when the list creation logic is removed\n\t\t\t\tlistElm = dom.getParent(selection.getNode(), 'ol,ul');\n\t\t\t\tif (listElm) {\n\t\t\t\t\tlistParent = listElm.parentNode;\n\n\t\t\t\t\t// If list is within a text block then split that block\n\t\t\t\t\tif (/^(H[1-6]|P|ADDRESS|PRE)$/.test(listParent.nodeName)) {\n\t\t\t\t\t\tstoreSelection();\n\t\t\t\t\t\tdom.split(listParent, listElm);\n\t\t\t\t\t\trestoreSelection();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Override commands to use the text formatter engine\n\t\t\t'Bold,Italic,Underline,Strikethrough,Superscript,Subscript' : function(command) {\n\t\t\t\ttoggleFormat(command);\n\t\t\t},\n\n\t\t\t// Override commands to use the text formatter engine\n\t\t\t'ForeColor,HiliteColor,FontName' : function(command, ui, value) {\n\t\t\t\ttoggleFormat(command, value);\n\t\t\t},\n\n\t\t\tFontSize : function(command, ui, value) {\n\t\t\t\tvar fontClasses, fontSizes;\n\n\t\t\t\t// Convert font size 1-7 to styles\n\t\t\t\tif (value >= 1 && value <= 7) {\n\t\t\t\t\tfontSizes = tinymce.explode(settings.font_size_style_values);\n\t\t\t\t\tfontClasses = tinymce.explode(settings.font_size_classes);\n\n\t\t\t\t\tif (fontClasses)\n\t\t\t\t\t\tvalue = fontClasses[value - 1] || value;\n\t\t\t\t\telse\n\t\t\t\t\t\tvalue = fontSizes[value - 1] || value;\n\t\t\t\t}\n\n\t\t\t\ttoggleFormat(command, value);\n\t\t\t},\n\n\t\t\tRemoveFormat : function(command) {\n\t\t\t\tformatter.remove(command);\n\t\t\t},\n\n\t\t\tmceBlockQuote : function(command) {\n\t\t\t\ttoggleFormat('blockquote');\n\t\t\t},\n\n\t\t\tFormatBlock : function(command, ui, value) {\n\t\t\t\treturn toggleFormat(value || 'p');\n\t\t\t},\n\n\t\t\tmceCleanup : function() {\n\t\t\t\tvar bookmark = selection.getBookmark();\n\n\t\t\t\teditor.setContent(editor.getContent({cleanup : TRUE}), {cleanup : TRUE});\n\n\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t},\n\n\t\t\tmceRemoveNode : function(command, ui, value) {\n\t\t\t\tvar node = value || selection.getNode();\n\n\t\t\t\t// Make sure that the body node isn't removed\n\t\t\t\tif (node != editor.getBody()) {\n\t\t\t\t\tstoreSelection();\n\t\t\t\t\teditor.dom.remove(node, TRUE);\n\t\t\t\t\trestoreSelection();\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tmceSelectNodeDepth : function(command, ui, value) {\n\t\t\t\tvar counter = 0;\n\n\t\t\t\tdom.getParent(selection.getNode(), function(node) {\n\t\t\t\t\tif (node.nodeType == 1 && counter++ == value) {\n\t\t\t\t\t\tselection.select(node);\n\t\t\t\t\t\treturn FALSE;\n\t\t\t\t\t}\n\t\t\t\t}, editor.getBody());\n\t\t\t},\n\n\t\t\tmceSelectNode : function(command, ui, value) {\n\t\t\t\tselection.select(value);\n\t\t\t},\n\n\t\t\tmceInsertContent : function(command, ui, value) {\n\t\t\t\tvar parser, serializer, parentNode, rootNode, fragment, args,\n\t\t\t\t\tmarker, nodeRect, viewPortRect, rng, node, node2, bookmarkHtml, viewportBodyElement;\n\n\t\t\t\t// Setup parser and serializer\n\t\t\t\tparser = editor.parser;\n\t\t\t\tserializer = new tinymce.html.Serializer({}, editor.schema);\n\t\t\t\tbookmarkHtml = '<span id=\"mce_marker\" data-mce-type=\"bookmark\">\\uFEFF</span>';\n\n\t\t\t\t// Run beforeSetContent handlers on the HTML to be inserted\n\t\t\t\targs = {content: value, format: 'html'};\n\t\t\t\tselection.onBeforeSetContent.dispatch(selection, args);\n\t\t\t\tvalue = args.content;\n\n\t\t\t\t// Add caret at end of contents if it's missing\n\t\t\t\tif (value.indexOf('{$caret}') == -1)\n\t\t\t\t\tvalue += '{$caret}';\n\n\t\t\t\t// Replace the caret marker with a span bookmark element\n\t\t\t\tvalue = value.replace(/\\{\\$caret\\}/, bookmarkHtml);\n\n\t\t\t\t// Insert node maker where we will insert the new HTML and get it's parent\n\t\t\t\tif (!selection.isCollapsed())\n\t\t\t\t\teditor.getDoc().execCommand('Delete', false, null);\n\n\t\t\t\tparentNode = selection.getNode();\n\n\t\t\t\t// Parse the fragment within the context of the parent node\n\t\t\t\targs = {context : parentNode.nodeName.toLowerCase()};\n\t\t\t\tfragment = parser.parse(value, args);\n\n\t\t\t\t// Move the caret to a more suitable location\n\t\t\t\tnode = fragment.lastChild;\n\t\t\t\tif (node.attr('id') == 'mce_marker') {\n\t\t\t\t\tmarker = node;\n\n\t\t\t\t\tfor (node = node.prev; node; node = node.walk(true)) {\n\t\t\t\t\t\tif (node.type == 3 || !dom.isBlock(node.name)) {\n\t\t\t\t\t\t\tnode.parent.insert(marker, node, node.name === 'br');\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// If parser says valid we can insert the contents into that parent\n\t\t\t\tif (!args.invalid) {\n\t\t\t\t\tvalue = serializer.serialize(fragment);\n\n\t\t\t\t\t// Check if parent is empty or only has one BR element then set the innerHTML of that parent\n\t\t\t\t\tnode = parentNode.firstChild;\n\t\t\t\t\tnode2 = parentNode.lastChild;\n\t\t\t\t\tif (!node || (node === node2 && node.nodeName === 'BR'))\n\t\t\t\t\t\tdom.setHTML(parentNode, value);\n\t\t\t\t\telse\n\t\t\t\t\t\tselection.setContent(value);\n\t\t\t\t} else {\n\t\t\t\t\t// If the fragment was invalid within that context then we need\n\t\t\t\t\t// to parse and process the parent it's inserted into\n\n\t\t\t\t\t// Insert bookmark node and get the parent\n\t\t\t\t\tselection.setContent(bookmarkHtml);\n\t\t\t\t\tparentNode = editor.selection.getNode();\n\t\t\t\t\trootNode = editor.getBody();\n\n\t\t\t\t\t// Opera will return the document node when selection is in root\n\t\t\t\t\tif (parentNode.nodeType == 9)\n\t\t\t\t\t\tparentNode = node = rootNode;\n\t\t\t\t\telse\n\t\t\t\t\t\tnode = parentNode;\n\n\t\t\t\t\t// Find the ancestor just before the root element\n\t\t\t\t\twhile (node !== rootNode) {\n\t\t\t\t\t\tparentNode = node;\n\t\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Get the outer/inner HTML depending on if we are in the root and parser and serialize that\n\t\t\t\t\tvalue = parentNode == rootNode ? rootNode.innerHTML : dom.getOuterHTML(parentNode);\n\t\t\t\t\tvalue = serializer.serialize(\n\t\t\t\t\t\tparser.parse(\n\t\t\t\t\t\t\t// Need to replace by using a function since $ in the contents would otherwise be a problem\n\t\t\t\t\t\t\tvalue.replace(/<span (id=\"mce_marker\"|id=mce_marker).+?<\\/span>/i, function() {\n\t\t\t\t\t\t\t\treturn serializer.serialize(fragment);\n\t\t\t\t\t\t\t})\n\t\t\t\t\t\t)\n\t\t\t\t\t);\n\n\t\t\t\t\t// Set the inner/outer HTML depending on if we are in the root or not\n\t\t\t\t\tif (parentNode == rootNode)\n\t\t\t\t\t\tdom.setHTML(rootNode, value);\n\t\t\t\t\telse\n\t\t\t\t\t\tdom.setOuterHTML(parentNode, value);\n\t\t\t\t}\n\n\t\t\t\tmarker = dom.get('mce_marker');\n\n\t\t\t\t// Scroll range into view scrollIntoView on element can't be used since it will scroll the main view port as well\n\t\t\t\tnodeRect = dom.getRect(marker);\n\t\t\t\tviewPortRect = dom.getViewPort(editor.getWin());\n\n\t\t\t\t// Check if node is out side the viewport if it is then scroll to it\n\t\t\t\tif ((nodeRect.y + nodeRect.h > viewPortRect.y + viewPortRect.h || nodeRect.y < viewPortRect.y) ||\n\t\t\t\t\t(nodeRect.x > viewPortRect.x + viewPortRect.w || nodeRect.x < viewPortRect.x)) {\n\t\t\t\t\tviewportBodyElement = tinymce.isIE ? editor.getDoc().documentElement : editor.getBody();\n\t\t\t\t\tviewportBodyElement.scrollLeft = nodeRect.x;\n\t\t\t\t\tviewportBodyElement.scrollTop = nodeRect.y - viewPortRect.h + 25;\n\t\t\t\t}\n\n\t\t\t\t// Move selection before marker and remove it\n\t\t\t\trng = dom.createRng();\n\n\t\t\t\t// If previous sibling is a text node set the selection to the end of that node\n\t\t\t\tnode = marker.previousSibling;\n\t\t\t\tif (node && node.nodeType == 3) {\n\t\t\t\t\trng.setStart(node, node.nodeValue.length);\n\t\t\t\t} else {\n\t\t\t\t\t// If the previous sibling isn't a text node or doesn't exist set the selection before the marker node\n\t\t\t\t\trng.setStartBefore(marker);\n\t\t\t\t\trng.setEndBefore(marker);\n\t\t\t\t}\n\n\t\t\t\t// Remove the marker node and set the new range\n\t\t\t\tdom.remove(marker);\n\t\t\t\tselection.setRng(rng);\n\n\t\t\t\t// Dispatch after event and add any visual elements needed\n\t\t\t\tselection.onSetContent.dispatch(selection, args);\n\t\t\t\teditor.addVisual();\n\t\t\t},\n\n\t\t\tmceInsertRawHTML : function(command, ui, value) {\n\t\t\t\tselection.setContent('tiny_mce_marker');\n\t\t\t\teditor.setContent(editor.getContent().replace(/tiny_mce_marker/g, function() { return value }));\n\t\t\t},\n\n\t\t\tmceSetContent : function(command, ui, value) {\n\t\t\t\teditor.setContent(value);\n\t\t\t},\n\n\t\t\t'Indent,Outdent' : function(command) {\n\t\t\t\tvar intentValue, indentUnit, value;\n\n\t\t\t\t// Setup indent level\n\t\t\t\tintentValue = settings.indentation;\n\t\t\t\tindentUnit = /[a-z%]+$/i.exec(intentValue);\n\t\t\t\tintentValue = parseInt(intentValue);\n\n\t\t\t\tif (!queryCommandState('InsertUnorderedList') && !queryCommandState('InsertOrderedList')) {\n\t\t\t\t\teach(selection.getSelectedBlocks(), function(element) {\n\t\t\t\t\t\tif (command == 'outdent') {\n\t\t\t\t\t\t\tvalue = Math.max(0, parseInt(element.style.paddingLeft || 0) - intentValue);\n\t\t\t\t\t\t\tdom.setStyle(element, 'paddingLeft', value ? value + indentUnit : '');\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\tdom.setStyle(element, 'paddingLeft', (parseInt(element.style.paddingLeft || 0) + intentValue) + indentUnit);\n\t\t\t\t\t});\n\t\t\t\t} else\n\t\t\t\t\texecNativeCommand(command);\n\t\t\t},\n\n\t\t\tmceRepaint : function() {\n\t\t\t\tvar bookmark;\n\n\t\t\t\tif (tinymce.isGecko) {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tstoreSelection(TRUE);\n\n\t\t\t\t\t\tif (selection.getSel())\n\t\t\t\t\t\t\tselection.getSel().selectAllChildren(editor.getBody());\n\n\t\t\t\t\t\tselection.collapse(TRUE);\n\t\t\t\t\t\trestoreSelection();\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// Ignore\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tmceToggleFormat : function(command, ui, value) {\n\t\t\t\tformatter.toggle(value);\n\t\t\t},\n\n\t\t\tInsertHorizontalRule : function() {\n\t\t\t\teditor.execCommand('mceInsertContent', false, '<hr />');\n\t\t\t},\n\n\t\t\tmceToggleVisualAid : function() {\n\t\t\t\teditor.hasVisual = !editor.hasVisual;\n\t\t\t\teditor.addVisual();\n\t\t\t},\n\n\t\t\tmceReplaceContent : function(command, ui, value) {\n\t\t\t\teditor.execCommand('mceInsertContent', false, value.replace(/\\{\\$selection\\}/g, selection.getContent({format : 'text'})));\n\t\t\t},\n\n\t\t\tmceInsertLink : function(command, ui, value) {\n\t\t\t\tvar anchor;\n\n\t\t\t\tif (typeof(value) == 'string')\n\t\t\t\t\tvalue = {href : value};\n\n\t\t\t\tanchor = dom.getParent(selection.getNode(), 'a');\n\n\t\t\t\t// Spaces are never valid in URLs and it's a very common mistake for people to make so we fix it here.\n\t\t\t\tvalue.href = value.href.replace(' ', '%20');\n\n\t\t\t\t// Remove existing links if there could be child links or that the href isn't specified\n\t\t\t\tif (!anchor || !value.href) {\n\t\t\t\t\tformatter.remove('link');\n\t\t\t\t}\t\t\n\n\t\t\t\t// Apply new link to selection\n\t\t\t\tif (value.href) {\n\t\t\t\t\tformatter.apply('link', value, anchor);\n\t\t\t\t}\n\t\t\t},\n\n\t\t\tselectAll : function() {\n\t\t\t\tvar root = dom.getRoot(), rng = dom.createRng();\n\n\t\t\t\trng.setStart(root, 0);\n\t\t\t\trng.setEnd(root, root.childNodes.length);\n\n\t\t\t\teditor.selection.setRng(rng);\n\t\t\t}\n\t\t});\n\n\t\t// Add queryCommandState overrides\n\t\taddCommands({\n\t\t\t// Override justify commands\n\t\t\t'JustifyLeft,JustifyCenter,JustifyRight,JustifyFull' : function(command) {\n\t\t\t\treturn isFormatMatch('align' + command.substring(7));\n\t\t\t},\n\n\t\t\t'Bold,Italic,Underline,Strikethrough,Superscript,Subscript' : function(command) {\n\t\t\t\treturn isFormatMatch(command);\n\t\t\t},\n\n\t\t\tmceBlockQuote : function() {\n\t\t\t\treturn isFormatMatch('blockquote');\n\t\t\t},\n\n\t\t\tOutdent : function() {\n\t\t\t\tvar node;\n\n\t\t\t\tif (settings.inline_styles) {\n\t\t\t\t\tif ((node = dom.getParent(selection.getStart(), dom.isBlock)) && parseInt(node.style.paddingLeft) > 0)\n\t\t\t\t\t\treturn TRUE;\n\n\t\t\t\t\tif ((node = dom.getParent(selection.getEnd(), dom.isBlock)) && parseInt(node.style.paddingLeft) > 0)\n\t\t\t\t\t\treturn TRUE;\n\t\t\t\t}\n\n\t\t\t\treturn queryCommandState('InsertUnorderedList') || queryCommandState('InsertOrderedList') || (!settings.inline_styles && !!dom.getParent(selection.getNode(), 'BLOCKQUOTE'));\n\t\t\t},\n\n\t\t\t'InsertUnorderedList,InsertOrderedList' : function(command) {\n\t\t\t\treturn dom.getParent(selection.getNode(), command == 'insertunorderedlist' ? 'UL' : 'OL');\n\t\t\t}\n\t\t}, 'state');\n\n\t\t// Add queryCommandValue overrides\n\t\taddCommands({\n\t\t\t'FontSize,FontName' : function(command) {\n\t\t\t\tvar value = 0, parent;\n\n\t\t\t\tif (parent = dom.getParent(selection.getNode(), 'span')) {\n\t\t\t\t\tif (command == 'fontsize')\n\t\t\t\t\t\tvalue = parent.style.fontSize;\n\t\t\t\t\telse\n\t\t\t\t\t\tvalue = parent.style.fontFamily.replace(/, /g, ',').replace(/[\\'\\\"]/g, '').toLowerCase();\n\t\t\t\t}\n\n\t\t\t\treturn value;\n\t\t\t}\n\t\t}, 'value');\n\n\t\t// Add undo manager logic\n\t\tif (settings.custom_undo_redo) {\n\t\t\taddCommands({\n\t\t\t\tUndo : function() {\n\t\t\t\t\teditor.undoManager.undo();\n\t\t\t\t},\n\n\t\t\t\tRedo : function() {\n\t\t\t\t\teditor.undoManager.redo();\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t};\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/Formatter.js":"/**\n * Formatter.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\t/**\n\t * Text formatter engine class. This class is used to apply formats like bold, italic, font size\n\t * etc to the current selection or specific nodes. This engine was build to replace the browsers\n\t * default formatting logic for execCommand due to it's inconsistant and buggy behavior.\n\t *\n\t * @class tinymce.Formatter\n\t * @example\n\t *  tinymce.activeEditor.formatter.register('mycustomformat', {\n\t *    inline : 'span',\n\t *    styles : {color : '#ff0000'}\n\t *  });\n\t *\n\t *  tinymce.activeEditor.formatter.apply('mycustomformat');\n\t */\n\n\t/**\n\t * Constructs a new formatter instance.\n\t *\n\t * @constructor Formatter\n\t * @param {tinymce.Editor} ed Editor instance to construct the formatter engine to.\n\t */\n\ttinymce.Formatter = function(ed) {\n\t\tvar formats = {},\n\t\t\teach = tinymce.each,\n\t\t\tdom = ed.dom,\n\t\t\tselection = ed.selection,\n\t\t\tTreeWalker = tinymce.dom.TreeWalker,\n\t\t\trangeUtils = new tinymce.dom.RangeUtils(dom),\n\t\t\tisValid = ed.schema.isValidChild,\n\t\t\tisBlock = dom.isBlock,\n\t\t\tforcedRootBlock = ed.settings.forced_root_block,\n\t\t\tnodeIndex = dom.nodeIndex,\n\t\t\tINVISIBLE_CHAR = '\\uFEFF',\n\t\t\tMCE_ATTR_RE = /^(src|href|style)$/,\n\t\t\tFALSE = false,\n\t\t\tTRUE = true,\n\t\t\tundefined;\n\n\t\tfunction isArray(obj) {\n\t\t\treturn obj instanceof Array;\n\t\t};\n\n\t\tfunction getParents(node, selector) {\n\t\t\treturn dom.getParents(node, selector, dom.getRoot());\n\t\t};\n\n\t\tfunction isCaretNode(node) {\n\t\t\treturn node.nodeType === 1 && (node.face === 'mceinline' || node.style.fontFamily === 'mceinline');\n\t\t};\n\n\t\t// Public functions\n\n\t\t/**\n\t\t * Returns the format by name or all formats if no name is specified.\n\t\t *\n\t\t * @method get\n\t\t * @param {String} name Optional name to retrieve by.\n\t\t * @return {Array/Object} Array/Object with all registered formats or a specific format.\n\t\t */\n\t\tfunction get(name) {\n\t\t\treturn name ? formats[name] : formats;\n\t\t};\n\n\t\t/**\n\t\t * Registers a specific format by name.\n\t\t *\n\t\t * @method register\n\t\t * @param {Object/String} name Name of the format for example \"bold\".\n\t\t * @param {Object/Array} format Optional format object or array of format variants can only be omitted if the first arg is an object.\n\t\t */\n\t\tfunction register(name, format) {\n\t\t\tif (name) {\n\t\t\t\tif (typeof(name) !== 'string') {\n\t\t\t\t\teach(name, function(format, name) {\n\t\t\t\t\t\tregister(name, format);\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\t// Force format into array and add it to internal collection\n\t\t\t\t\tformat = format.length ? format : [format];\n\n\t\t\t\t\teach(format, function(format) {\n\t\t\t\t\t\t// Set deep to false by default on selector formats this to avoid removing\n\t\t\t\t\t\t// alignment on images inside paragraphs when alignment is changed on paragraphs\n\t\t\t\t\t\tif (format.deep === undefined)\n\t\t\t\t\t\t\tformat.deep = !format.selector;\n\n\t\t\t\t\t\t// Default to true\n\t\t\t\t\t\tif (format.split === undefined)\n\t\t\t\t\t\t\tformat.split = !format.selector || format.inline;\n\n\t\t\t\t\t\t// Default to true\n\t\t\t\t\t\tif (format.remove === undefined && format.selector && !format.inline)\n\t\t\t\t\t\t\tformat.remove = 'none';\n\n\t\t\t\t\t\t// Mark format as a mixed format inline + block level\n\t\t\t\t\t\tif (format.selector && format.inline) {\n\t\t\t\t\t\t\tformat.mixed = true;\n\t\t\t\t\t\t\tformat.block_expand = true;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Split classes if needed\n\t\t\t\t\t\tif (typeof(format.classes) === 'string')\n\t\t\t\t\t\t\tformat.classes = format.classes.split(/\\s+/);\n\t\t\t\t\t});\n\n\t\t\t\t\tformats[name] = format;\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tvar getTextDecoration = function(node) {\n\t\t\tvar decoration;\n\n\t\t\ted.dom.getParent(node, function(n) {\n\t\t\t\tdecoration = ed.dom.getStyle(n, 'text-decoration');\n\t\t\t\treturn decoration && decoration !== 'none';\n\t\t\t});\n\n\t\t\treturn decoration;\n\t\t};\n\n\t\tvar processUnderlineAndColor = function(node) {\n\t\t\tvar textDecoration;\n\t\t\tif (node.nodeType === 1 && node.parentNode && node.parentNode.nodeType === 1) {\n\t\t\t\ttextDecoration = getTextDecoration(node.parentNode);\n\t\t\t\tif (ed.dom.getStyle(node, 'color') && textDecoration) {\n\t\t\t\t\ted.dom.setStyle(node, 'text-decoration', textDecoration);\n\t\t\t\t} else if (ed.dom.getStyle(node, 'textdecoration') === textDecoration) {\n\t\t\t\t\ted.dom.setStyle(node, 'text-decoration', null);\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\t/**\n\t\t * Applies the specified format to the current selection or specified node.\n\t\t *\n\t\t * @method apply\n\t\t * @param {String} name Name of format to apply.\n\t\t * @param {Object} vars Optional list of variables to replace within format before applying it.\n\t\t * @param {Node} node Optional node to apply the format to defaults to current selection.\n\t\t */\n\t\tfunction apply(name, vars, node) {\n\t\t\tvar formatList = get(name), format = formatList[0], bookmark, rng, i, isCollapsed = selection.isCollapsed();\n\n\t\t\t/**\n\t\t\t * Moves the start to the first suitable text node.\n\t\t\t */\n\t\t\tfunction moveStart(rng) {\n\t\t\t\tvar container = rng.startContainer,\n\t\t\t\t\toffset = rng.startOffset,\n\t\t\t\t\twalker, node;\n\n\t\t\t\t// Move startContainer/startOffset in to a suitable node\n\t\t\t\tif (container.nodeType == 1 || container.nodeValue === \"\") {\n\t\t\t\t\tcontainer = container.nodeType == 1 ? container.childNodes[offset] : container;\n\n\t\t\t\t\t// Might fail if the offset is behind the last element in it's container\n\t\t\t\t\tif (container) {\n\t\t\t\t\t\twalker = new TreeWalker(container, container.parentNode);\n\t\t\t\t\t\tfor (node = walker.current(); node; node = walker.next()) {\n\t\t\t\t\t\t\tif (node.nodeType == 3 && !isWhiteSpaceNode(node)) {\n\t\t\t\t\t\t\t\trng.setStart(node, 0);\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn rng;\n\t\t\t};\n\n\t\t\tfunction setElementFormat(elm, fmt) {\n\t\t\t\tfmt = fmt || format;\n\n\t\t\t\tif (elm) {\n\t\t\t\t\tif (fmt.onformat) {\n\t\t\t\t\t\tfmt.onformat(elm, fmt, vars, node);\n\t\t\t\t\t}\n\n\t\t\t\t\teach(fmt.styles, function(value, name) {\n\t\t\t\t\t\tdom.setStyle(elm, name, replaceVars(value, vars));\n\t\t\t\t\t});\n\n\t\t\t\t\teach(fmt.attributes, function(value, name) {\n\t\t\t\t\t\tdom.setAttrib(elm, name, replaceVars(value, vars));\n\t\t\t\t\t});\n\n\t\t\t\t\teach(fmt.classes, function(value) {\n\t\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\t\tif (!dom.hasClass(elm, value))\n\t\t\t\t\t\t\tdom.addClass(elm, value);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t};\n\t\t\tfunction adjustSelectionToVisibleSelection() {\n\t\t\t\tfunction findSelectionEnd(start, end) {\n\t\t\t\t\tvar walker = new TreeWalker(end);\n\t\t\t\t\tfor (node = walker.current(); node; node = walker.prev()) {\n\t\t\t\t\t\tif (node.childNodes.length > 1 || node == start) {\n\t\t\t\t\t\t\treturn node;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\t// Adjust selection so that a end container with a end offset of zero is not included in the selection\n\t\t\t\t// as this isn't visible to the user.\n\t\t\t\tvar rng = ed.selection.getRng();\n\t\t\t\tvar start = rng.startContainer;\n\t\t\t\tvar end = rng.endContainer;\n\n\t\t\t\tif (start != end && rng.endOffset == 0) {\n\t\t\t\t\tvar newEnd = findSelectionEnd(start, end);\n\t\t\t\t\tvar endOffset = newEnd.nodeType == 3 ? newEnd.length : newEnd.childNodes.length;\n\n\t\t\t\t\trng.setEnd(newEnd, endOffset);\n\t\t\t\t}\n\n\t\t\t\treturn rng;\n\t\t\t}\n\n\t\t\tfunction applyStyleToList(node, bookmark, wrapElm, newWrappers, process){\n\t\t\t\tvar nodes = [], listIndex = -1, list, startIndex = -1, endIndex = -1, currentWrapElm;\n\n\t\t\t\t// find the index of the first child list.\n\t\t\t\teach(node.childNodes, function(n, index) {\n\t\t\t\t\tif (n.nodeName === \"UL\" || n.nodeName === \"OL\") {\n\t\t\t\t\t\tlistIndex = index;\n\t\t\t\t\t\tlist = n;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// get the index of the bookmarks\n\t\t\t\teach(node.childNodes, function(n, index) {\n\t\t\t\t\tif (n.nodeName === \"SPAN\" && dom.getAttrib(n, \"data-mce-type\") == \"bookmark\") {\n\t\t\t\t\t\tif (n.id == bookmark.id + \"_start\") {\n\t\t\t\t\t\t\tstartIndex = index;\n\t\t\t\t\t\t} else if (n.id == bookmark.id + \"_end\") {\n\t\t\t\t\t\t\tendIndex = index;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// if the selection spans across an embedded list, or there isn't an embedded list - handle processing normally\n\t\t\t\tif (listIndex <= 0 || (startIndex < listIndex && endIndex > listIndex)) {\n\t\t\t\t\teach(tinymce.grep(node.childNodes), process);\n\t\t\t\t\treturn 0;\n\t\t\t\t} else {\n\t\t\t\t\tcurrentWrapElm = wrapElm.cloneNode(FALSE);\n\n\t\t\t\t\t// create a list of the nodes on the same side of the list as the selection\n\t\t\t\t\teach(tinymce.grep(node.childNodes), function(n, index) {\n\t\t\t\t\t\tif ((startIndex < listIndex && index < listIndex) || (startIndex > listIndex && index > listIndex)) {\n\t\t\t\t\t\t\tnodes.push(n);\n\t\t\t\t\t\t\tn.parentNode.removeChild(n);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\n\t\t\t\t\t// insert the wrapping element either before or after the list.\n\t\t\t\t\tif (startIndex < listIndex) {\n\t\t\t\t\t\tnode.insertBefore(currentWrapElm, list);\n\t\t\t\t\t} else if (startIndex > listIndex) {\n\t\t\t\t\t\tnode.insertBefore(currentWrapElm, list.nextSibling);\n\t\t\t\t\t}\n\n\t\t\t\t\t// add the new nodes to the list.\n\t\t\t\t\tnewWrappers.push(currentWrapElm);\n\n\t\t\t\t\teach(nodes, function(node) {\n\t\t\t\t\t\tcurrentWrapElm.appendChild(node);\n\t\t\t\t\t});\n\n\t\t\t\t\treturn currentWrapElm;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tfunction applyRngStyle(rng, bookmark, node_specific) {\n\t\t\t\tvar newWrappers = [], wrapName, wrapElm;\n\n\t\t\t\t// Setup wrapper element\n\t\t\t\twrapName = format.inline || format.block;\n\t\t\t\twrapElm = dom.create(wrapName);\n\t\t\t\tsetElementFormat(wrapElm);\n\n\t\t\t\trangeUtils.walk(rng, function(nodes) {\n\t\t\t\t\tvar currentWrapElm;\n\n\t\t\t\t\t/**\n\t\t\t\t\t * Process a list of nodes wrap them.\n\t\t\t\t\t */\n\t\t\t\t\tfunction process(node) {\n\t\t\t\t\t\tvar nodeName = node.nodeName.toLowerCase(), parentName = node.parentNode.nodeName.toLowerCase(), found;\n\n\t\t\t\t\t\t// Stop wrapping on br elements\n\t\t\t\t\t\tif (isEq(nodeName, 'br')) {\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\n\t\t\t\t\t\t\t// Remove any br elements when we wrap things\n\t\t\t\t\t\t\tif (format.block)\n\t\t\t\t\t\t\t\tdom.remove(node);\n\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// If node is wrapper type\n\t\t\t\t\t\tif (format.wrapper && matchNode(node, name, vars)) {\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Can we rename the block\n\t\t\t\t\t\tif (format.block && !format.wrapper && isTextBlock(nodeName)) {\n\t\t\t\t\t\t\tnode = dom.rename(node, wrapName);\n\t\t\t\t\t\t\tsetElementFormat(node);\n\t\t\t\t\t\t\tnewWrappers.push(node);\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Handle selector patterns\n\t\t\t\t\t\tif (format.selector) {\n\t\t\t\t\t\t\t// Look for matching formats\n\t\t\t\t\t\t\teach(formatList, function(format) {\n\t\t\t\t\t\t\t\t// Check collapsed state if it exists\n\t\t\t\t\t\t\t\tif ('collapsed' in format && format.collapsed !== isCollapsed) {\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tif (dom.is(node, format.selector) && !isCaretNode(node)) {\n\t\t\t\t\t\t\t\t\tsetElementFormat(node, format);\n\t\t\t\t\t\t\t\t\tfound = true;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t// Continue processing if a selector match wasn't found and a inline element is defined\n\t\t\t\t\t\t\tif (!format.inline || found) {\n\t\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Is it valid to wrap this item\n\t\t\t\t\t\tif (isValid(wrapName, nodeName) && isValid(parentName, wrapName) &&\n\t\t\t\t\t\t\t\t!(!node_specific && node.nodeType === 3 && node.nodeValue.length === 1 && node.nodeValue.charCodeAt(0) === 65279) && node.id !== '_mce_caret') {\n\t\t\t\t\t\t\t// Start wrapping\n\t\t\t\t\t\t\tif (!currentWrapElm) {\n\t\t\t\t\t\t\t\t// Wrap the node\n\t\t\t\t\t\t\t\tcurrentWrapElm = wrapElm.cloneNode(FALSE);\n\t\t\t\t\t\t\t\tnode.parentNode.insertBefore(currentWrapElm, node);\n\t\t\t\t\t\t\t\tnewWrappers.push(currentWrapElm);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tcurrentWrapElm.appendChild(node);\n\t\t\t\t\t\t} else if (nodeName == 'li' && bookmark) {\n\t\t\t\t\t\t\t// Start wrapping - if we are in a list node and have a bookmark, then we will always begin by wrapping in a new element.\n\t\t\t\t\t\t\tcurrentWrapElm = applyStyleToList(node, bookmark, wrapElm, newWrappers, process);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Start a new wrapper for possible children\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\n\t\t\t\t\t\t\teach(tinymce.grep(node.childNodes), process);\n\n\t\t\t\t\t\t\t// End the last wrapper\n\t\t\t\t\t\t\tcurrentWrapElm = 0;\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\t\t// Process siblings from range\n\t\t\t\t\teach(nodes, process);\n\t\t\t\t});\n\n\t\t\t\t// Wrap links inside as well, for example color inside a link when the wrapper is around the link\n\t\t\t\tif (format.wrap_links === false) {\n\t\t\t\t\teach(newWrappers, function(node) {\n\t\t\t\t\t\tfunction process(node) {\n\t\t\t\t\t\t\tvar i, currentWrapElm, children;\n\n\t\t\t\t\t\t\tif (node.nodeName === 'A') {\n\t\t\t\t\t\t\t\tcurrentWrapElm = wrapElm.cloneNode(FALSE);\n\t\t\t\t\t\t\t\tnewWrappers.push(currentWrapElm);\n\n\t\t\t\t\t\t\t\tchildren = tinymce.grep(node.childNodes);\n\t\t\t\t\t\t\t\tfor (i = 0; i < children.length; i++)\n\t\t\t\t\t\t\t\t\tcurrentWrapElm.appendChild(children[i]);\n\n\t\t\t\t\t\t\t\tnode.appendChild(currentWrapElm);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\teach(tinymce.grep(node.childNodes), process);\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tprocess(node);\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\t// Cleanup\n\t\t\t\teach(newWrappers, function(node) {\n\t\t\t\t\tvar childCount;\n\n\t\t\t\t\tfunction getChildCount(node) {\n\t\t\t\t\t\tvar count = 0;\n\n\t\t\t\t\t\teach(node.childNodes, function(node) {\n\t\t\t\t\t\t\tif (!isWhiteSpaceNode(node) && !isBookmarkNode(node))\n\t\t\t\t\t\t\t\tcount++;\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\treturn count;\n\t\t\t\t\t};\n\n\t\t\t\t\tfunction mergeStyles(node) {\n\t\t\t\t\t\tvar child, clone;\n\n\t\t\t\t\t\teach(node.childNodes, function(node) {\n\t\t\t\t\t\t\tif (node.nodeType == 1 && !isBookmarkNode(node) && !isCaretNode(node)) {\n\t\t\t\t\t\t\t\tchild = node;\n\t\t\t\t\t\t\t\treturn FALSE; // break loop\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\t// If child was found and of the same type as the current node\n\t\t\t\t\t\tif (child && matchName(child, format)) {\n\t\t\t\t\t\t\tclone = child.cloneNode(FALSE);\n\t\t\t\t\t\t\tsetElementFormat(clone);\n\n\t\t\t\t\t\t\tdom.replace(clone, node, TRUE);\n\t\t\t\t\t\t\tdom.remove(child, 1);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn clone || node;\n\t\t\t\t\t};\n\n\t\t\t\t\tchildCount = getChildCount(node);\n\n\t\t\t\t\t// Remove empty nodes but only if there is multiple wrappers and they are not block\n\t\t\t\t\t// elements so never remove single <h1></h1> since that would remove the current empty block element where the caret is at\n\t\t\t\t\tif ((newWrappers.length > 1 || !isBlock(node)) && childCount === 0) {\n\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (format.inline || format.wrapper) {\n\t\t\t\t\t\t// Merges the current node with it's children of similar type to reduce the number of elements\n\t\t\t\t\t\tif (!format.exact && childCount === 1)\n\t\t\t\t\t\t\tnode = mergeStyles(node);\n\n\t\t\t\t\t\t// Remove/merge children\n\t\t\t\t\t\teach(formatList, function(format) {\n\t\t\t\t\t\t\t// Merge all children of similar type will move styles from child to parent\n\t\t\t\t\t\t\t// this: <span style=\"color:red\"><b><span style=\"color:red; font-size:10px\">text</span></b></span>\n\t\t\t\t\t\t\t// will become: <span style=\"color:red\"><b><span style=\"font-size:10px\">text</span></b></span>\n\t\t\t\t\t\t\teach(dom.select(format.inline, node), function(child) {\n\t\t\t\t\t\t\t\tvar parent;\n\n\t\t\t\t\t\t\t\t// When wrap_links is set to false we don't want\n\t\t\t\t\t\t\t\t// to remove the format on children within links\n\t\t\t\t\t\t\t\tif (format.wrap_links === false) {\n\t\t\t\t\t\t\t\t\tparent = child.parentNode;\n\n\t\t\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\t\t\tif (parent.nodeName === 'A')\n\t\t\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t\t} while (parent = parent.parentNode);\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tremoveFormat(format, vars, child, format.exact ? child : null);\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\t// Remove child if direct parent is of same type\n\t\t\t\t\t\tif (matchNode(node.parentNode, name, vars)) {\n\t\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t\t\tnode = 0;\n\t\t\t\t\t\t\treturn TRUE;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Look for parent with similar style format\n\t\t\t\t\t\tif (format.merge_with_parents) {\n\t\t\t\t\t\t\tdom.getParent(node.parentNode, function(parent) {\n\t\t\t\t\t\t\t\tif (matchNode(parent, name, vars)) {\n\t\t\t\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t\t\t\t\tnode = 0;\n\t\t\t\t\t\t\t\t\treturn TRUE;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Merge next and previous siblings if they are similar <b>text</b><b>text</b> becomes <b>texttext</b>\n\t\t\t\t\t\tif (node && format.merge_siblings !== false) {\n\t\t\t\t\t\t\tnode = mergeSiblings(getNonWhiteSpaceSibling(node), node);\n\t\t\t\t\t\t\tnode = mergeSiblings(node, getNonWhiteSpaceSibling(node, TRUE));\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t};\n\n\t\t\tif (format) {\n\t\t\t\tif (node) {\n\t\t\t\t\tif (node.nodeType) {\n\t\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\t\trng.setEndAfter(node);\n\t\t\t\t\t\tapplyRngStyle(expandRng(rng, formatList), null, true);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tapplyRngStyle(node, null, true);\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tif (!isCollapsed || !format.inline || dom.select('td.mceSelected,th.mceSelected').length) {\n\t\t\t\t\t\t// Obtain selection node before selection is unselected by applyRngStyle()\n\t\t\t\t\t\tvar curSelNode = ed.selection.getNode();\n\n\t\t\t\t\t\t// Apply formatting to selection\n\t\t\t\t\t\ted.selection.setRng(adjustSelectionToVisibleSelection());\n\t\t\t\t\t\tbookmark = selection.getBookmark();\n\t\t\t\t\t\tapplyRngStyle(expandRng(selection.getRng(TRUE), formatList), bookmark);\n\n\t\t\t\t\t\t// Colored nodes should be underlined so that the color of the underline matches the text color.\n\t\t\t\t\t\tif (format.styles && (format.styles.color || format.styles.textDecoration)) {\n\t\t\t\t\t\t\ttinymce.walk(curSelNode, processUnderlineAndColor, 'childNodes');\n\t\t\t\t\t\t\tprocessUnderlineAndColor(curSelNode);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t\t\t\tselection.setRng(moveStart(selection.getRng(TRUE)));\n\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t} else\n\t\t\t\t\t\tperformCaretAction('apply', name, vars);\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\t/**\n\t\t * Removes the specified format from the current selection or specified node.\n\t\t *\n\t\t * @method remove\n\t\t * @param {String} name Name of format to remove.\n\t\t * @param {Object} vars Optional list of variables to replace within format before removing it.\n\t\t * @param {Node/Range} node Optional node or DOM range to remove the format from defaults to current selection.\n\t\t */\n\t\tfunction remove(name, vars, node) {\n\t\t\tvar formatList = get(name), format = formatList[0], bookmark, i, rng;\n\t\t\t/**\n\t\t\t * Moves the start to the first suitable text node.\n\t\t\t */\n\t\t\tfunction moveStart(rng) {\n\t\t\t\tvar container = rng.startContainer,\n\t\t\t\t\toffset = rng.startOffset,\n\t\t\t\t\twalker, node, nodes, tmpNode;\n\n\t\t\t\t// Convert text node into index if possible\n\t\t\t\tif (container.nodeType == 3 && offset >= container.nodeValue.length - 1) {\n\t\t\t\t\tcontainer = container.parentNode;\n\t\t\t\t\toffset = nodeIndex(container) + 1;\n\t\t\t\t}\n\n\t\t\t\t// Move startContainer/startOffset in to a suitable node\n\t\t\t\tif (container.nodeType == 1) {\n\t\t\t\t\tnodes = container.childNodes;\n\t\t\t\t\tcontainer = nodes[Math.min(offset, nodes.length - 1)];\n\t\t\t\t\twalker = new TreeWalker(container);\n\n\t\t\t\t\t// If offset is at end of the parent node walk to the next one\n\t\t\t\t\tif (offset > nodes.length - 1)\n\t\t\t\t\t\twalker.next();\n\n\t\t\t\t\tfor (node = walker.current(); node; node = walker.next()) {\n\t\t\t\t\t\tif (node.nodeType == 3 && !isWhiteSpaceNode(node)) {\n\t\t\t\t\t\t\t// IE has a \"neat\" feature where it moves the start node into the closest element\n\t\t\t\t\t\t\t// we can avoid this by inserting an element before it and then remove it after we set the selection\n\t\t\t\t\t\t\ttmpNode = dom.create('a', null, INVISIBLE_CHAR);\n\t\t\t\t\t\t\tnode.parentNode.insertBefore(tmpNode, node);\n\n\t\t\t\t\t\t\t// Set selection and remove tmpNode\n\t\t\t\t\t\t\trng.setStart(node, 0);\n\t\t\t\t\t\t\tselection.setRng(rng);\n\t\t\t\t\t\t\tdom.remove(tmpNode);\n\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Merges the styles for each node\n\t\t\tfunction process(node) {\n\t\t\t\tvar children, i, l;\n\n\t\t\t\t// Grab the children first since the nodelist might be changed\n\t\t\t\tchildren = tinymce.grep(node.childNodes);\n\n\t\t\t\t// Process current node\n\t\t\t\tfor (i = 0, l = formatList.length; i < l; i++) {\n\t\t\t\t\tif (removeFormat(formatList[i], vars, node, node))\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\t// Process the children\n\t\t\t\tif (format.deep) {\n\t\t\t\t\tfor (i = 0, l = children.length; i < l; i++)\n\t\t\t\t\t\tprocess(children[i]);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tfunction findFormatRoot(container) {\n\t\t\t\tvar formatRoot;\n\n\t\t\t\t// Find format root\n\t\t\t\teach(getParents(container.parentNode).reverse(), function(parent) {\n\t\t\t\t\tvar format;\n\n\t\t\t\t\t// Find format root element\n\t\t\t\t\tif (!formatRoot && parent.id != '_start' && parent.id != '_end') {\n\t\t\t\t\t\t// Is the node matching the format we are looking for\n\t\t\t\t\t\tformat = matchNode(parent, name, vars);\n\t\t\t\t\t\tif (format && format.split !== false)\n\t\t\t\t\t\t\tformatRoot = parent;\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\treturn formatRoot;\n\t\t\t};\n\n\t\t\tfunction wrapAndSplit(format_root, container, target, split) {\n\t\t\t\tvar parent, clone, lastClone, firstClone, i, formatRootParent;\n\n\t\t\t\t// Format root found then clone formats and split it\n\t\t\t\tif (format_root) {\n\t\t\t\t\tformatRootParent = format_root.parentNode;\n\n\t\t\t\t\tfor (parent = container.parentNode; parent && parent != formatRootParent; parent = parent.parentNode) {\n\t\t\t\t\t\tclone = parent.cloneNode(FALSE);\n\n\t\t\t\t\t\tfor (i = 0; i < formatList.length; i++) {\n\t\t\t\t\t\t\tif (removeFormat(formatList[i], vars, clone, clone)) {\n\t\t\t\t\t\t\t\tclone = 0;\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Build wrapper node\n\t\t\t\t\t\tif (clone) {\n\t\t\t\t\t\t\tif (lastClone)\n\t\t\t\t\t\t\t\tclone.appendChild(lastClone);\n\n\t\t\t\t\t\t\tif (!firstClone)\n\t\t\t\t\t\t\t\tfirstClone = clone;\n\n\t\t\t\t\t\t\tlastClone = clone;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Never split block elements if the format is mixed\n\t\t\t\t\tif (split && (!format.mixed || !isBlock(format_root)))\n\t\t\t\t\t\tcontainer = dom.split(format_root, container);\n\n\t\t\t\t\t// Wrap container in cloned formats\n\t\t\t\t\tif (lastClone) {\n\t\t\t\t\t\ttarget.parentNode.insertBefore(lastClone, target);\n\t\t\t\t\t\tfirstClone.appendChild(target);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn container;\n\t\t\t};\n\n\t\t\tfunction splitToFormatRoot(container) {\n\t\t\t\treturn wrapAndSplit(findFormatRoot(container), container, container, true);\n\t\t\t};\n\n\t\t\tfunction unwrap(start) {\n\t\t\t\tvar node = dom.get(start ? '_start' : '_end'),\n\t\t\t\t\tout = node[start ? 'firstChild' : 'lastChild'];\n\n\t\t\t\t// If the end is placed within the start the result will be removed\n\t\t\t\t// So this checks if the out node is a bookmark node if it is it\n\t\t\t\t// checks for another more suitable node\n\t\t\t\tif (isBookmarkNode(out))\n\t\t\t\t\tout = out[start ? 'firstChild' : 'lastChild'];\n\n\t\t\t\tdom.remove(node, true);\n\n\t\t\t\treturn out;\n\t\t\t};\n\n\t\t\tfunction removeRngStyle(rng) {\n\t\t\t\tvar startContainer, endContainer;\n\n\t\t\t\trng = expandRng(rng, formatList, TRUE);\n\n\t\t\t\tif (format.split) {\n\t\t\t\t\tstartContainer = getContainer(rng, TRUE);\n\t\t\t\t\tendContainer = getContainer(rng);\n\n\t\t\t\t\tif (startContainer != endContainer) {\n\t\t\t\t\t\t// Wrap start/end nodes in span element since these might be cloned/moved\n\t\t\t\t\t\tstartContainer = wrap(startContainer, 'span', {id : '_start', 'data-mce-type' : 'bookmark'});\n\t\t\t\t\t\tendContainer = wrap(endContainer, 'span', {id : '_end', 'data-mce-type' : 'bookmark'});\n\n\t\t\t\t\t\t// Split start/end\n\t\t\t\t\t\tsplitToFormatRoot(startContainer);\n\t\t\t\t\t\tsplitToFormatRoot(endContainer);\n\n\t\t\t\t\t\t// Unwrap start/end to get real elements again\n\t\t\t\t\t\tstartContainer = unwrap(TRUE);\n\t\t\t\t\t\tendContainer = unwrap();\n\t\t\t\t\t} else\n\t\t\t\t\t\tstartContainer = endContainer = splitToFormatRoot(startContainer);\n\n\t\t\t\t\t// Update range positions since they might have changed after the split operations\n\t\t\t\t\trng.startContainer = startContainer.parentNode;\n\t\t\t\t\trng.startOffset = nodeIndex(startContainer);\n\t\t\t\t\trng.endContainer = endContainer.parentNode;\n\t\t\t\t\trng.endOffset = nodeIndex(endContainer) + 1;\n\t\t\t\t}\n\n\t\t\t\t// Remove items between start/end\n\t\t\t\trangeUtils.walk(rng, function(nodes) {\n\t\t\t\t\teach(nodes, function(node) {\n\t\t\t\t\t\tprocess(node);\n\n\t\t\t\t\t\t// Remove parent span if it only contains text-decoration: underline, yet a parent node is also underlined.\n\t\t\t\t\t\tif (node.nodeType === 1 && ed.dom.getStyle(node, 'text-decoration') === 'underline' && node.parentNode && getTextDecoration(node.parentNode) === 'underline') {\n\t\t\t\t\t\t\tremoveFormat({'deep': false, 'exact': true, 'inline': 'span', 'styles': {'textDecoration' : 'underline'}}, null, node);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t};\n\n\t\t\t// Handle node\n\t\t\tif (node) {\n\t\t\t\tif (node.nodeType) {\n\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\trng.setEndAfter(node);\n\t\t\t\t\tremoveRngStyle(rng);\n\t\t\t\t} else {\n\t\t\t\t\tremoveRngStyle(node);\n\t\t\t\t}\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif (!selection.isCollapsed() || !format.inline || dom.select('td.mceSelected,th.mceSelected').length) {\n\t\t\t\tbookmark = selection.getBookmark();\n\t\t\t\tremoveRngStyle(selection.getRng(TRUE));\n\t\t\t\tselection.moveToBookmark(bookmark);\n\n\t\t\t\t// Check if start element still has formatting then we are at: \"<b>text|</b>text\" and need to move the start into the next text node\n\t\t\t\tif (format.inline && match(name, vars, selection.getStart())) {\n\t\t\t\t\tmoveStart(selection.getRng(true));\n\t\t\t\t}\n\n\t\t\t\ted.nodeChanged();\n\t\t\t} else\n\t\t\t\tperformCaretAction('remove', name, vars);\n\n\t\t\t// When you remove formatting from a table cell in WebKit (cell, not the contents of a cell) there is a rendering issue with column width\n\t\t\tif (tinymce.isWebKit) {\n\t\t\t\ted.execCommand('mceCleanup');\n\t\t\t}\n\t\t};\n\n\t\t/**\n\t\t * Toggles the specified format on/off.\n\t\t *\n\t\t * @method toggle\n\t\t * @param {String} name Name of format to apply/remove.\n\t\t * @param {Object} vars Optional list of variables to replace within format before applying/removing it.\n\t\t * @param {Node} node Optional node to apply the format to or remove from. Defaults to current selection.\n\t\t */\n\t\tfunction toggle(name, vars, node) {\n\t\t\tvar fmt = get(name);\n\n\t\t\tif (match(name, vars, node) && (!('toggle' in fmt[0]) || fmt[0]['toggle']))\n\t\t\t\tremove(name, vars, node);\n\t\t\telse\n\t\t\t\tapply(name, vars, node);\n\t\t};\n\n\t\t/**\n\t\t * Return true/false if the specified node has the specified format.\n\t\t *\n\t\t * @method matchNode\n\t\t * @param {Node} node Node to check the format on.\n\t\t * @param {String} name Format name to check.\n\t\t * @param {Object} vars Optional list of variables to replace before checking it.\n\t\t * @param {Boolean} similar Match format that has similar properties.\n\t\t * @return {Object} Returns the format object it matches or undefined if it doesn't match.\n\t\t */\n\t\tfunction matchNode(node, name, vars, similar) {\n\t\t\tvar formatList = get(name), format, i, classes;\n\n\t\t\tfunction matchItems(node, format, item_name) {\n\t\t\t\tvar key, value, items = format[item_name], i;\n\n\t\t\t\t// Custom match\n\t\t\t\tif (format.onmatch) {\n\t\t\t\t\treturn format.onmatch(node, format, item_name);\n\t\t\t\t}\n\n\t\t\t\t// Check all items\n\t\t\t\tif (items) {\n\t\t\t\t\t// Non indexed object\n\t\t\t\t\tif (items.length === undefined) {\n\t\t\t\t\t\tfor (key in items) {\n\t\t\t\t\t\t\tif (items.hasOwnProperty(key)) {\n\t\t\t\t\t\t\t\tif (item_name === 'attributes')\n\t\t\t\t\t\t\t\t\tvalue = dom.getAttrib(node, key);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\tvalue = getStyle(node, key);\n\n\t\t\t\t\t\t\t\tif (similar && !value && !format.exact)\n\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\tif ((!similar || format.exact) && !isEq(value, replaceVars(items[key], vars)))\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Only one match needed for indexed arrays\n\t\t\t\t\t\tfor (i = 0; i < items.length; i++) {\n\t\t\t\t\t\t\tif (item_name === 'attributes' ? dom.getAttrib(node, items[i]) : getStyle(node, items[i]))\n\t\t\t\t\t\t\t\treturn format;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn format;\n\t\t\t};\n\n\t\t\tif (formatList && node) {\n\t\t\t\t// Check each format in list\n\t\t\t\tfor (i = 0; i < formatList.length; i++) {\n\t\t\t\t\tformat = formatList[i];\n\n\t\t\t\t\t// Name name, attributes, styles and classes\n\t\t\t\t\tif (matchName(node, format) && matchItems(node, format, 'attributes') && matchItems(node, format, 'styles')) {\n\t\t\t\t\t\t// Match classes\n\t\t\t\t\t\tif (classes = format.classes) {\n\t\t\t\t\t\t\tfor (i = 0; i < classes.length; i++) {\n\t\t\t\t\t\t\t\tif (!dom.hasClass(node, classes[i]))\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn format;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\t/**\n\t\t * Matches the current selection or specified node against the specified format name.\n\t\t *\n\t\t * @method match\n\t\t * @param {String} name Name of format to match.\n\t\t * @param {Object} vars Optional list of variables to replace before checking it.\n\t\t * @param {Node} node Optional node to check.\n\t\t * @return {boolean} true/false if the specified selection/node matches the format.\n\t\t */\n\t\tfunction match(name, vars, node) {\n\t\t\tvar startNode;\n\n\t\t\tfunction matchParents(node) {\n\t\t\t\t// Find first node with similar format settings\n\t\t\t\tnode = dom.getParent(node, function(node) {\n\t\t\t\t\treturn !!matchNode(node, name, vars, true);\n\t\t\t\t});\n\n\t\t\t\t// Do an exact check on the similar format element\n\t\t\t\treturn matchNode(node, name, vars);\n\t\t\t};\n\n\t\t\t// Check specified node\n\t\t\tif (node)\n\t\t\t\treturn matchParents(node);\n\n\t\t\t// Check selected node\n\t\t\tnode = selection.getNode();\n\t\t\tif (matchParents(node))\n\t\t\t\treturn TRUE;\n\n\t\t\t// Check start node if it's different\n\t\t\tstartNode = selection.getStart();\n\t\t\tif (startNode != node) {\n\t\t\t\tif (matchParents(startNode))\n\t\t\t\t\treturn TRUE;\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\t/**\n\t\t * Matches the current selection against the array of formats and returns a new array with matching formats.\n\t\t *\n\t\t * @method matchAll\n\t\t * @param {Array} names Name of format to match.\n\t\t * @param {Object} vars Optional list of variables to replace before checking it.\n\t\t * @return {Array} Array with matched formats.\n\t\t */\n\t\tfunction matchAll(names, vars) {\n\t\t\tvar startElement, matchedFormatNames = [], checkedMap = {}, i, ni, name;\n\n\t\t\t// Check start of selection for formats\n\t\t\tstartElement = selection.getStart();\n\t\t\tdom.getParent(startElement, function(node) {\n\t\t\t\tvar i, name;\n\n\t\t\t\tfor (i = 0; i < names.length; i++) {\n\t\t\t\t\tname = names[i];\n\n\t\t\t\t\tif (!checkedMap[name] && matchNode(node, name, vars)) {\n\t\t\t\t\t\tcheckedMap[name] = true;\n\t\t\t\t\t\tmatchedFormatNames.push(name);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn matchedFormatNames;\n\t\t};\n\n\t\t/**\n\t\t * Returns true/false if the specified format can be applied to the current selection or not. It will currently only check the state for selector formats, it returns true on all other format types.\n\t\t *\n\t\t * @method canApply\n\t\t * @param {String} name Name of format to check.\n\t\t * @return {boolean} true/false if the specified format can be applied to the current selection/node.\n\t\t */\n\t\tfunction canApply(name) {\n\t\t\tvar formatList = get(name), startNode, parents, i, x, selector;\n\n\t\t\tif (formatList) {\n\t\t\t\tstartNode = selection.getStart();\n\t\t\t\tparents = getParents(startNode);\n\n\t\t\t\tfor (x = formatList.length - 1; x >= 0; x--) {\n\t\t\t\t\tselector = formatList[x].selector;\n\n\t\t\t\t\t// Format is not selector based, then always return TRUE\n\t\t\t\t\tif (!selector)\n\t\t\t\t\t\treturn TRUE;\n\n\t\t\t\t\tfor (i = parents.length - 1; i >= 0; i--) {\n\t\t\t\t\t\tif (dom.is(parents[i], selector))\n\t\t\t\t\t\t\treturn TRUE;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t};\n\n\t\t// Expose to public\n\t\ttinymce.extend(this, {\n\t\t\tget : get,\n\t\t\tregister : register,\n\t\t\tapply : apply,\n\t\t\tremove : remove,\n\t\t\ttoggle : toggle,\n\t\t\tmatch : match,\n\t\t\tmatchAll : matchAll,\n\t\t\tmatchNode : matchNode,\n\t\t\tcanApply : canApply\n\t\t});\n\n\t\t// Private functions\n\n\t\t/**\n\t\t * Checks if the specified nodes name matches the format inline/block or selector.\n\t\t *\n\t\t * @private\n\t\t * @param {Node} node Node to match against the specified format.\n\t\t * @param {Object} format Format object o match with.\n\t\t * @return {boolean} true/false if the format matches.\n\t\t */\n\t\tfunction matchName(node, format) {\n\t\t\t// Check for inline match\n\t\t\tif (isEq(node, format.inline))\n\t\t\t\treturn TRUE;\n\n\t\t\t// Check for block match\n\t\t\tif (isEq(node, format.block))\n\t\t\t\treturn TRUE;\n\n\t\t\t// Check for selector match\n\t\t\tif (format.selector)\n\t\t\t\treturn dom.is(node, format.selector);\n\t\t};\n\n\t\t/**\n\t\t * Compares two string/nodes regardless of their case.\n\t\t *\n\t\t * @private\n\t\t * @param {String/Node} Node or string to compare.\n\t\t * @param {String/Node} Node or string to compare.\n\t\t * @return {boolean} True/false if they match.\n\t\t */\n\t\tfunction isEq(str1, str2) {\n\t\t\tstr1 = str1 || '';\n\t\t\tstr2 = str2 || '';\n\n\t\t\tstr1 = '' + (str1.nodeName || str1);\n\t\t\tstr2 = '' + (str2.nodeName || str2);\n\n\t\t\treturn str1.toLowerCase() == str2.toLowerCase();\n\t\t};\n\n\t\t/**\n\t\t * Returns the style by name on the specified node. This method modifies the style\n\t\t * contents to make it more easy to match. This will resolve a few browser issues.\n\t\t *\n\t\t * @private\n\t\t * @param {Node} node to get style from.\n\t\t * @param {String} name Style name to get.\n\t\t * @return {String} Style item value.\n\t\t */\n\t\tfunction getStyle(node, name) {\n\t\t\tvar styleVal = dom.getStyle(node, name);\n\n\t\t\t// Force the format to hex\n\t\t\tif (name == 'color' || name == 'backgroundColor')\n\t\t\t\tstyleVal = dom.toHex(styleVal);\n\n\t\t\t// Opera will return bold as 700\n\t\t\tif (name == 'fontWeight' && styleVal == 700)\n\t\t\t\tstyleVal = 'bold';\n\n\t\t\treturn '' + styleVal;\n\t\t};\n\n\t\t/**\n\t\t * Replaces variables in the value. The variable format is %var.\n\t\t *\n\t\t * @private\n\t\t * @param {String} value Value to replace variables in.\n\t\t * @param {Object} vars Name/value array with variables to replace.\n\t\t * @return {String} New value with replaced variables.\n\t\t */\n\t\tfunction replaceVars(value, vars) {\n\t\t\tif (typeof(value) != \"string\")\n\t\t\t\tvalue = value(vars);\n\t\t\telse if (vars) {\n\t\t\t\tvalue = value.replace(/%(\\w+)/g, function(str, name) {\n\t\t\t\t\treturn vars[name] || str;\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn value;\n\t\t};\n\n\t\tfunction isWhiteSpaceNode(node) {\n\t\t\treturn node && node.nodeType === 3 && /^([\\t \\r\\n]+|)$/.test(node.nodeValue);\n\t\t};\n\n\t\tfunction wrap(node, name, attrs) {\n\t\t\tvar wrapper = dom.create(name, attrs);\n\n\t\t\tnode.parentNode.insertBefore(wrapper, node);\n\t\t\twrapper.appendChild(node);\n\n\t\t\treturn wrapper;\n\t\t};\n\n\t\t/**\n\t\t * Expands the specified range like object to depending on format.\n\t\t *\n\t\t * For example on block formats it will move the start/end position\n\t\t * to the beginning of the current block.\n\t\t *\n\t\t * @private\n\t\t * @param {Object} rng Range like object.\n\t\t * @param {Array} formats Array with formats to expand by.\n\t\t * @return {Object} Expanded range like object.\n\t\t */\n\t\tfunction expandRng(rng, format, remove) {\n\t\t\tvar startContainer = rng.startContainer,\n\t\t\t\tstartOffset = rng.startOffset,\n\t\t\t\tendContainer = rng.endContainer,\n\t\t\t\tendOffset = rng.endOffset, sibling, lastIdx, leaf, endPoint;\n\n\t\t\t// This function walks up the tree if there is no siblings before/after the node\n\t\t\tfunction findParentContainer(start) {\n\t\t\t\tvar container, parent, child, sibling, siblingName;\n\n\t\t\t\tcontainer = parent = start ? startContainer : endContainer;\n\t\t\t\tsiblingName = start ? 'previousSibling' : 'nextSibling';\n\t\t\t\troot = dom.getRoot();\n\n\t\t\t\t// If it's a text node and the offset is inside the text\n\t\t\t\tif (container.nodeType == 3 && !isWhiteSpaceNode(container)) {\n\t\t\t\t\tif (start ? startOffset > 0 : endOffset < container.nodeValue.length) {\n\t\t\t\t\t\treturn container;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tfor (;;) {\n\t\t\t\t\t// Stop expanding on block elements or root depending on format\n\t\t\t\t\tif (parent == root || (!format[0].block_expand && isBlock(parent)))\n\t\t\t\t\t\treturn parent;\n\n\t\t\t\t\t// Walk left/right\n\t\t\t\t\tfor (sibling = parent[siblingName]; sibling; sibling = sibling[siblingName]) {\n\t\t\t\t\t\tif (!isBookmarkNode(sibling) && !isWhiteSpaceNode(sibling)) {\n\t\t\t\t\t\t\treturn parent;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Check if we can move up are we at root level or body level\n\t\t\t\t\tparent = parent.parentNode;\n\t\t\t\t}\n\n\t\t\t\treturn container;\n\t\t\t};\n\n\t\t\t// This function walks down the tree to find the leaf at the selection.\n\t\t\t// The offset is also returned as if node initially a leaf, the offset may be in the middle of the text node.\n\t\t\tfunction findLeaf(node, offset) {\n\t\t\t\tif (offset === undefined)\n\t\t\t\t\toffset = node.nodeType === 3 ? node.length : node.childNodes.length;\n\t\t\t\twhile (node && node.hasChildNodes()) {\n\t\t\t\t\tnode = node.childNodes[offset];\n\t\t\t\t\tif (node)\n\t\t\t\t\t\toffset = node.nodeType === 3 ? node.length : node.childNodes.length;\n\t\t\t\t}\n\t\t\t\treturn { node: node, offset: offset };\n\t\t\t}\n\n\t\t\t// If index based start position then resolve it\n\t\t\tif (startContainer.nodeType == 1 && startContainer.hasChildNodes()) {\n\t\t\t\tlastIdx = startContainer.childNodes.length - 1;\n\t\t\t\tstartContainer = startContainer.childNodes[startOffset > lastIdx ? lastIdx : startOffset];\n\n\t\t\t\tif (startContainer.nodeType == 3)\n\t\t\t\t\tstartOffset = 0;\n\t\t\t}\n\n\t\t\t// If index based end position then resolve it\n\t\t\tif (endContainer.nodeType == 1 && endContainer.hasChildNodes()) {\n\t\t\t\tlastIdx = endContainer.childNodes.length - 1;\n\t\t\t\tendContainer = endContainer.childNodes[endOffset > lastIdx ? lastIdx : endOffset - 1];\n\n\t\t\t\tif (endContainer.nodeType == 3)\n\t\t\t\t\tendOffset = endContainer.nodeValue.length;\n\t\t\t}\n\n\t\t\t// Exclude bookmark nodes if possible\n\t\t\tif (isBookmarkNode(startContainer.parentNode) || isBookmarkNode(startContainer)) {\n\t\t\t\tstartContainer = isBookmarkNode(startContainer) ? startContainer : startContainer.parentNode;\n\t\t\t\tstartContainer = startContainer.nextSibling || startContainer;\n\n\t\t\t\tif (startContainer.nodeType == 3)\n\t\t\t\t\tstartOffset = 0;\n\t\t\t}\n\n\t\t\tif (isBookmarkNode(endContainer.parentNode) || isBookmarkNode(endContainer)) {\n\t\t\t\tendContainer = isBookmarkNode(endContainer) ? endContainer : endContainer.parentNode;\n\t\t\t\tendContainer = endContainer.previousSibling || endContainer;\n\n\t\t\t\tif (endContainer.nodeType == 3)\n\t\t\t\t\tendOffset = endContainer.length;\n\t\t\t}\n\n\t\t\tif (format[0].inline) {\n\t\t\t\tif (rng.collapsed) {\n\t\t\t\t\tfunction findWordEndPoint(container, offset, start) {\n\t\t\t\t\t\tvar walker, node, pos, lastTextNode;\n\n\t\t\t\t\t\tfunction findSpace(node, offset) {\n\t\t\t\t\t\t\tvar pos, pos2, str = node.nodeValue;\n\n\t\t\t\t\t\t\tif (typeof(offset) == \"undefined\") {\n\t\t\t\t\t\t\t\toffset = start ? str.length : 0;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (start) {\n\t\t\t\t\t\t\t\tpos = str.lastIndexOf(' ', offset);\n\t\t\t\t\t\t\t\tpos2 = str.lastIndexOf('\\u00a0', offset);\n\t\t\t\t\t\t\t\tpos = pos > pos2 ? pos : pos2;\n\n\t\t\t\t\t\t\t\t// Include the space on remove to avoid tag soup\n\t\t\t\t\t\t\t\tif (pos !== -1 && !remove) {\n\t\t\t\t\t\t\t\t\tpos++;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tpos = str.indexOf(' ', offset);\n\t\t\t\t\t\t\t\tpos2 = str.indexOf('\\u00a0', offset);\n\t\t\t\t\t\t\t\tpos = pos !== -1 && (pos2 === -1 || pos < pos2) ? pos : pos2;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn pos;\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tif (container.nodeType === 3) {\n\t\t\t\t\t\t\tpos = findSpace(container, offset);\n\n\t\t\t\t\t\t\tif (pos !== -1) {\n\t\t\t\t\t\t\t\treturn {container : container, offset : pos};\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tlastTextNode = container;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Walk the nodes inside the block\n\t\t\t\t\t\twalker = new TreeWalker(container, dom.getParent(container, isBlock) || ed.getBody());\n\t\t\t\t\t\twhile (node = walker[start ? 'prev' : 'next']()) {\n\t\t\t\t\t\t\tif (node.nodeType === 3) {\n\t\t\t\t\t\t\t\tlastTextNode = node;\n\t\t\t\t\t\t\t\tpos = findSpace(node);\n\n\t\t\t\t\t\t\t\tif (pos !== -1) {\n\t\t\t\t\t\t\t\t\treturn {container : node, offset : pos};\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else if (isBlock(node)) {\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (lastTextNode) {\n\t\t\t\t\t\t\tif (start) {\n\t\t\t\t\t\t\t\toffset = 0;\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\toffset = lastTextNode.length;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn {container: lastTextNode, offset: offset};\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Expand left to closest word boundery\n\t\t\t\t\tendPoint = findWordEndPoint(startContainer, startOffset, true);\n\t\t\t\t\tif (endPoint) {\n\t\t\t\t\t\tstartContainer = endPoint.container;\n\t\t\t\t\t\tstartOffset = endPoint.offset;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Expand right to closest word boundery\n\t\t\t\t\tendPoint = findWordEndPoint(endContainer, endOffset);\n\t\t\t\t\tif (endPoint) {\n\t\t\t\t\t\tendContainer = endPoint.container;\n\t\t\t\t\t\tendOffset = endPoint.offset;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Avoid applying formatting to a trailing space.\n\t\t\t\tleaf = findLeaf(endContainer, endOffset);\n\t\t\t\tif (leaf.node) {\n\t\t\t\t\twhile (leaf.node && leaf.offset === 0 && leaf.node.previousSibling)\n\t\t\t\t\t\tleaf = findLeaf(leaf.node.previousSibling);\n\n\t\t\t\t\tif (leaf.node && leaf.offset > 0 && leaf.node.nodeType === 3 &&\n\t\t\t\t\t\t\tleaf.node.nodeValue.charAt(leaf.offset - 1) === ' ') {\n\n\t\t\t\t\t\tif (leaf.offset > 1) {\n\t\t\t\t\t\t\tendContainer = leaf.node;\n\t\t\t\t\t\t\tendContainer.splitText(leaf.offset - 1);\n\t\t\t\t\t\t} else if (leaf.node.previousSibling) {\n\t\t\t\t\t\t\t// TODO: Figure out why this is in here\n\t\t\t\t\t\t\t//endContainer = leaf.node.previousSibling;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Move start/end point up the tree if the leaves are sharp and if we are in different containers\n\t\t\t// Example * becomes !: !<p><b><i>*text</i><i>text*</i></b></p>!\n\t\t\t// This will reduce the number of wrapper elements that needs to be created\n\t\t\t// Move start point up the tree\n\t\t\tif (format[0].inline || format[0].block_expand) {\n\t\t\t\tif (!format[0].inline || (startContainer.nodeType != 3 || startOffset === 0)) {\n\t\t\t\t\tstartContainer = findParentContainer(true);\n\t\t\t\t}\n\n\t\t\t\tif (!format[0].inline || (endContainer.nodeType != 3 || endOffset === endContainer.nodeValue.length)) {\n\t\t\t\t\tendContainer = findParentContainer();\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Expand start/end container to matching selector\n\t\t\tif (format[0].selector && format[0].expand !== FALSE && !format[0].inline) {\n\t\t\t\tfunction findSelectorEndPoint(container, sibling_name) {\n\t\t\t\t\tvar parents, i, y, curFormat;\n\n\t\t\t\t\tif (container.nodeType == 3 && container.nodeValue.length == 0 && container[sibling_name])\n\t\t\t\t\t\tcontainer = container[sibling_name];\n\n\t\t\t\t\tparents = getParents(container);\n\t\t\t\t\tfor (i = 0; i < parents.length; i++) {\n\t\t\t\t\t\tfor (y = 0; y < format.length; y++) {\n\t\t\t\t\t\t\tcurFormat = format[y];\n\n\t\t\t\t\t\t\t// If collapsed state is set then skip formats that doesn't match that\n\t\t\t\t\t\t\tif (\"collapsed\" in curFormat && curFormat.collapsed !== rng.collapsed)\n\t\t\t\t\t\t\t\tcontinue;\n\n\t\t\t\t\t\t\tif (dom.is(parents[i], curFormat.selector))\n\t\t\t\t\t\t\t\treturn parents[i];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn container;\n\t\t\t\t};\n\n\t\t\t\t// Find new startContainer/endContainer if there is better one\n\t\t\t\tstartContainer = findSelectorEndPoint(startContainer, 'previousSibling');\n\t\t\t\tendContainer = findSelectorEndPoint(endContainer, 'nextSibling');\n\t\t\t}\n\n\t\t\t// Expand start/end container to matching block element or text node\n\t\t\tif (format[0].block || format[0].selector) {\n\t\t\t\tfunction findBlockEndPoint(container, sibling_name, sibling_name2) {\n\t\t\t\t\tvar node;\n\n\t\t\t\t\t// Expand to block of similar type\n\t\t\t\t\tif (!format[0].wrapper)\n\t\t\t\t\t\tnode = dom.getParent(container, format[0].block);\n\n\t\t\t\t\t// Expand to first wrappable block element or any block element\n\t\t\t\t\tif (!node)\n\t\t\t\t\t\tnode = dom.getParent(container.nodeType == 3 ? container.parentNode : container, isBlock);\n\n\t\t\t\t\t// Exclude inner lists from wrapping\n\t\t\t\t\tif (node && format[0].wrapper)\n\t\t\t\t\t\tnode = getParents(node, 'ul,ol').reverse()[0] || node;\n\n\t\t\t\t\t// Didn't find a block element look for first/last wrappable element\n\t\t\t\t\tif (!node) {\n\t\t\t\t\t\tnode = container;\n\n\t\t\t\t\t\twhile (node[sibling_name] && !isBlock(node[sibling_name])) {\n\t\t\t\t\t\t\tnode = node[sibling_name];\n\n\t\t\t\t\t\t\t// Break on BR but include it will be removed later on\n\t\t\t\t\t\t\t// we can't remove it now since we need to check if it can be wrapped\n\t\t\t\t\t\t\tif (isEq(node, 'br'))\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn node || container;\n\t\t\t\t};\n\n\t\t\t\t// Find new startContainer/endContainer if there is better one\n\t\t\t\tstartContainer = findBlockEndPoint(startContainer, 'previousSibling');\n\t\t\t\tendContainer = findBlockEndPoint(endContainer, 'nextSibling');\n\n\t\t\t\t// Non block element then try to expand up the leaf\n\t\t\t\tif (format[0].block) {\n\t\t\t\t\tif (!isBlock(startContainer))\n\t\t\t\t\t\tstartContainer = findParentContainer(true);\n\n\t\t\t\t\tif (!isBlock(endContainer))\n\t\t\t\t\t\tendContainer = findParentContainer();\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Setup index for startContainer\n\t\t\tif (startContainer.nodeType == 1) {\n\t\t\t\tstartOffset = nodeIndex(startContainer);\n\t\t\t\tstartContainer = startContainer.parentNode;\n\t\t\t}\n\n\t\t\t// Setup index for endContainer\n\t\t\tif (endContainer.nodeType == 1) {\n\t\t\t\tendOffset = nodeIndex(endContainer) + 1;\n\t\t\t\tendContainer = endContainer.parentNode;\n\t\t\t}\n\n\t\t\t// Return new range like object\n\t\t\treturn {\n\t\t\t\tstartContainer : startContainer,\n\t\t\t\tstartOffset : startOffset,\n\t\t\t\tendContainer : endContainer,\n\t\t\t\tendOffset : endOffset\n\t\t\t};\n\t\t}\n\n\t\t/**\n\t\t * Removes the specified format for the specified node. It will also remove the node if it doesn't have\n\t\t * any attributes if the format specifies it to do so.\n\t\t *\n\t\t * @private\n\t\t * @param {Object} format Format object with items to remove from node.\n\t\t * @param {Object} vars Name/value object with variables to apply to format.\n\t\t * @param {Node} node Node to remove the format styles on.\n\t\t * @param {Node} compare_node Optional compare node, if specified the styles will be compared to that node.\n\t\t * @return {Boolean} True/false if the node was removed or not.\n\t\t */\n\t\tfunction removeFormat(format, vars, node, compare_node) {\n\t\t\tvar i, attrs, stylesModified;\n\n\t\t\t// Check if node matches format\n\t\t\tif (!matchName(node, format))\n\t\t\t\treturn FALSE;\n\n\t\t\t// Should we compare with format attribs and styles\n\t\t\tif (format.remove != 'all') {\n\t\t\t\t// Remove styles\n\t\t\t\teach(format.styles, function(value, name) {\n\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\t// Indexed array\n\t\t\t\t\tif (typeof(name) === 'number') {\n\t\t\t\t\t\tname = value;\n\t\t\t\t\t\tcompare_node = 0;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!compare_node || isEq(getStyle(compare_node, name), value))\n\t\t\t\t\t\tdom.setStyle(node, name, '');\n\n\t\t\t\t\tstylesModified = 1;\n\t\t\t\t});\n\n\t\t\t\t// Remove style attribute if it's empty\n\t\t\t\tif (stylesModified && dom.getAttrib(node, 'style') == '') {\n\t\t\t\t\tnode.removeAttribute('style');\n\t\t\t\t\tnode.removeAttribute('data-mce-style');\n\t\t\t\t}\n\n\t\t\t\t// Remove attributes\n\t\t\t\teach(format.attributes, function(value, name) {\n\t\t\t\t\tvar valueOut;\n\n\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\t// Indexed array\n\t\t\t\t\tif (typeof(name) === 'number') {\n\t\t\t\t\t\tname = value;\n\t\t\t\t\t\tcompare_node = 0;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!compare_node || isEq(dom.getAttrib(compare_node, name), value)) {\n\t\t\t\t\t\t// Keep internal classes\n\t\t\t\t\t\tif (name == 'class') {\n\t\t\t\t\t\t\tvalue = dom.getAttrib(node, name);\n\t\t\t\t\t\t\tif (value) {\n\t\t\t\t\t\t\t\t// Build new class value where everything is removed except the internal prefixed classes\n\t\t\t\t\t\t\t\tvalueOut = '';\n\t\t\t\t\t\t\t\teach(value.split(/\\s+/), function(cls) {\n\t\t\t\t\t\t\t\t\tif (/mce\\w+/.test(cls))\n\t\t\t\t\t\t\t\t\t\tvalueOut += (valueOut ? ' ' : '') + cls;\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\t// We got some internal classes left\n\t\t\t\t\t\t\t\tif (valueOut) {\n\t\t\t\t\t\t\t\t\tdom.setAttrib(node, name, valueOut);\n\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// IE6 has a bug where the attribute doesn't get removed correctly\n\t\t\t\t\t\tif (name == \"class\")\n\t\t\t\t\t\t\tnode.removeAttribute('className');\n\n\t\t\t\t\t\t// Remove mce prefixed attributes\n\t\t\t\t\t\tif (MCE_ATTR_RE.test(name))\n\t\t\t\t\t\t\tnode.removeAttribute('data-mce-' + name);\n\n\t\t\t\t\t\tnode.removeAttribute(name);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// Remove classes\n\t\t\t\teach(format.classes, function(value) {\n\t\t\t\t\tvalue = replaceVars(value, vars);\n\n\t\t\t\t\tif (!compare_node || dom.hasClass(compare_node, value))\n\t\t\t\t\t\tdom.removeClass(node, value);\n\t\t\t\t});\n\n\t\t\t\t// Check for non internal attributes\n\t\t\t\tattrs = dom.getAttribs(node);\n\t\t\t\tfor (i = 0; i < attrs.length; i++) {\n\t\t\t\t\tif (attrs[i].nodeName.indexOf('_') !== 0)\n\t\t\t\t\t\treturn FALSE;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Remove the inline child if it's empty for example <b> or <span>\n\t\t\tif (format.remove != 'none') {\n\t\t\t\tremoveNode(node, format);\n\t\t\t\treturn TRUE;\n\t\t\t}\n\t\t};\n\n\t\t/**\n\t\t * Removes the node and wrap it's children in paragraphs before doing so or\n\t\t * appends BR elements to the beginning/end of the block element if forcedRootBlocks is disabled.\n\t\t *\n\t\t * If the div in the node below gets removed:\n\t\t *  text<div>text</div>text\n\t\t *\n\t\t * Output becomes:\n\t\t *  text<div><br />text<br /></div>text\n\t\t *\n\t\t * So when the div is removed the result is:\n\t\t *  text<br />text<br />text\n\t\t *\n\t\t * @private\n\t\t * @param {Node} node Node to remove + apply BR/P elements to.\n\t\t * @param {Object} format Format rule.\n\t\t * @return {Node} Input node.\n\t\t */\n\t\tfunction removeNode(node, format) {\n\t\t\tvar parentNode = node.parentNode, rootBlockElm;\n\n\t\t\tif (format.block) {\n\t\t\t\tif (!forcedRootBlock) {\n\t\t\t\t\tfunction find(node, next, inc) {\n\t\t\t\t\t\tnode = getNonWhiteSpaceSibling(node, next, inc);\n\n\t\t\t\t\t\treturn !node || (node.nodeName == 'BR' || isBlock(node));\n\t\t\t\t\t};\n\n\t\t\t\t\t// Append BR elements if needed before we remove the block\n\t\t\t\t\tif (isBlock(node) && !isBlock(parentNode)) {\n\t\t\t\t\t\tif (!find(node, FALSE) && !find(node.firstChild, TRUE, 1))\n\t\t\t\t\t\t\tnode.insertBefore(dom.create('br'), node.firstChild);\n\n\t\t\t\t\t\tif (!find(node, TRUE) && !find(node.lastChild, FALSE, 1))\n\t\t\t\t\t\t\tnode.appendChild(dom.create('br'));\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\t// Wrap the block in a forcedRootBlock if we are at the root of document\n\t\t\t\t\tif (parentNode == dom.getRoot()) {\n\t\t\t\t\t\tif (!format.list_block || !isEq(node, format.list_block)) {\n\t\t\t\t\t\t\teach(tinymce.grep(node.childNodes), function(node) {\n\t\t\t\t\t\t\t\tif (isValid(forcedRootBlock, node.nodeName.toLowerCase())) {\n\t\t\t\t\t\t\t\t\tif (!rootBlockElm)\n\t\t\t\t\t\t\t\t\t\trootBlockElm = wrap(node, forcedRootBlock);\n\t\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\t\trootBlockElm.appendChild(node);\n\t\t\t\t\t\t\t\t} else\n\t\t\t\t\t\t\t\t\trootBlockElm = 0;\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Never remove nodes that isn't the specified inline element if a selector is specified too\n\t\t\tif (format.selector && format.inline && !isEq(format.inline, node))\n\t\t\t\treturn;\n\n\t\t\tdom.remove(node, 1);\n\t\t};\n\n\t\t/**\n\t\t * Returns the next/previous non whitespace node.\n\t\t *\n\t\t * @private\n\t\t * @param {Node} node Node to start at.\n\t\t * @param {boolean} next (Optional) Include next or previous node defaults to previous.\n\t\t * @param {boolean} inc (Optional) Include the current node in checking. Defaults to false.\n\t\t * @return {Node} Next or previous node or undefined if it wasn't found.\n\t\t */\n\t\tfunction getNonWhiteSpaceSibling(node, next, inc) {\n\t\t\tif (node) {\n\t\t\t\tnext = next ? 'nextSibling' : 'previousSibling';\n\n\t\t\t\tfor (node = inc ? node : node[next]; node; node = node[next]) {\n\t\t\t\t\tif (node.nodeType == 1 || !isWhiteSpaceNode(node))\n\t\t\t\t\t\treturn node;\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\t/**\n\t\t * Checks if the specified node is a bookmark node or not.\n\t\t *\n\t\t * @param {Node} node Node to check if it's a bookmark node or not.\n\t\t * @return {Boolean} true/false if the node is a bookmark node.\n\t\t */\n\t\tfunction isBookmarkNode(node) {\n\t\t\treturn node && node.nodeType == 1 && node.getAttribute('data-mce-type') == 'bookmark';\n\t\t};\n\n\t\t/**\n\t\t * Merges the next/previous sibling element if they match.\n\t\t *\n\t\t * @private\n\t\t * @param {Node} prev Previous node to compare/merge.\n\t\t * @param {Node} next Next node to compare/merge.\n\t\t * @return {Node} Next node if we didn't merge and prev node if we did.\n\t\t */\n\t\tfunction mergeSiblings(prev, next) {\n\t\t\tvar marker, sibling, tmpSibling;\n\n\t\t\t/**\n\t\t\t * Compares two nodes and checks if it's attributes and styles matches.\n\t\t\t * This doesn't compare classes as items since their order is significant.\n\t\t\t *\n\t\t\t * @private\n\t\t\t * @param {Node} node1 First node to compare with.\n\t\t\t * @param {Node} node2 Second node to compare with.\n\t\t\t * @return {boolean} True/false if the nodes are the same or not.\n\t\t\t */\n\t\t\tfunction compareElements(node1, node2) {\n\t\t\t\t// Not the same name\n\t\t\t\tif (node1.nodeName != node2.nodeName)\n\t\t\t\t\treturn FALSE;\n\n\t\t\t\t/**\n\t\t\t\t * Returns all the nodes attributes excluding internal ones, styles and classes.\n\t\t\t\t *\n\t\t\t\t * @private\n\t\t\t\t * @param {Node} node Node to get attributes from.\n\t\t\t\t * @return {Object} Name/value object with attributes and attribute values.\n\t\t\t\t */\n\t\t\t\tfunction getAttribs(node) {\n\t\t\t\t\tvar attribs = {};\n\n\t\t\t\t\teach(dom.getAttribs(node), function(attr) {\n\t\t\t\t\t\tvar name = attr.nodeName.toLowerCase();\n\n\t\t\t\t\t\t// Don't compare internal attributes or style\n\t\t\t\t\t\tif (name.indexOf('_') !== 0 && name !== 'style')\n\t\t\t\t\t\t\tattribs[name] = dom.getAttrib(node, name);\n\t\t\t\t\t});\n\n\t\t\t\t\treturn attribs;\n\t\t\t\t};\n\n\t\t\t\t/**\n\t\t\t\t * Compares two objects checks if it's key + value exists in the other one.\n\t\t\t\t *\n\t\t\t\t * @private\n\t\t\t\t * @param {Object} obj1 First object to compare.\n\t\t\t\t * @param {Object} obj2 Second object to compare.\n\t\t\t\t * @return {boolean} True/false if the objects matches or not.\n\t\t\t\t */\n\t\t\t\tfunction compareObjects(obj1, obj2) {\n\t\t\t\t\tvar value, name;\n\n\t\t\t\t\tfor (name in obj1) {\n\t\t\t\t\t\t// Obj1 has item obj2 doesn't have\n\t\t\t\t\t\tif (obj1.hasOwnProperty(name)) {\n\t\t\t\t\t\t\tvalue = obj2[name];\n\n\t\t\t\t\t\t\t// Obj2 doesn't have obj1 item\n\t\t\t\t\t\t\tif (value === undefined)\n\t\t\t\t\t\t\t\treturn FALSE;\n\n\t\t\t\t\t\t\t// Obj2 item has a different value\n\t\t\t\t\t\t\tif (obj1[name] != value)\n\t\t\t\t\t\t\t\treturn FALSE;\n\n\t\t\t\t\t\t\t// Delete similar value\n\t\t\t\t\t\t\tdelete obj2[name];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Check if obj 2 has something obj 1 doesn't have\n\t\t\t\t\tfor (name in obj2) {\n\t\t\t\t\t\t// Obj2 has item obj1 doesn't have\n\t\t\t\t\t\tif (obj2.hasOwnProperty(name))\n\t\t\t\t\t\t\treturn FALSE;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn TRUE;\n\t\t\t\t};\n\n\t\t\t\t// Attribs are not the same\n\t\t\t\tif (!compareObjects(getAttribs(node1), getAttribs(node2)))\n\t\t\t\t\treturn FALSE;\n\n\t\t\t\t// Styles are not the same\n\t\t\t\tif (!compareObjects(dom.parseStyle(dom.getAttrib(node1, 'style')), dom.parseStyle(dom.getAttrib(node2, 'style'))))\n\t\t\t\t\treturn FALSE;\n\n\t\t\t\treturn TRUE;\n\t\t\t};\n\n\t\t\t// Check if next/prev exists and that they are elements\n\t\t\tif (prev && next) {\n\t\t\t\tfunction findElementSibling(node, sibling_name) {\n\t\t\t\t\tfor (sibling = node; sibling; sibling = sibling[sibling_name]) {\n\t\t\t\t\t\tif (sibling.nodeType == 3 && sibling.nodeValue.length !== 0)\n\t\t\t\t\t\t\treturn node;\n\n\t\t\t\t\t\tif (sibling.nodeType == 1 && !isBookmarkNode(sibling))\n\t\t\t\t\t\t\treturn sibling;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn node;\n\t\t\t\t};\n\n\t\t\t\t// If previous sibling is empty then jump over it\n\t\t\t\tprev = findElementSibling(prev, 'previousSibling');\n\t\t\t\tnext = findElementSibling(next, 'nextSibling');\n\n\t\t\t\t// Compare next and previous nodes\n\t\t\t\tif (compareElements(prev, next)) {\n\t\t\t\t\t// Append nodes between\n\t\t\t\t\tfor (sibling = prev.nextSibling; sibling && sibling != next;) {\n\t\t\t\t\t\ttmpSibling = sibling;\n\t\t\t\t\t\tsibling = sibling.nextSibling;\n\t\t\t\t\t\tprev.appendChild(tmpSibling);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove next node\n\t\t\t\t\tdom.remove(next);\n\n\t\t\t\t\t// Move children into prev node\n\t\t\t\t\teach(tinymce.grep(next.childNodes), function(node) {\n\t\t\t\t\t\tprev.appendChild(node);\n\t\t\t\t\t});\n\n\t\t\t\t\treturn prev;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn next;\n\t\t};\n\n\t\t/**\n\t\t * Returns true/false if the specified node is a text block or not.\n\t\t *\n\t\t * @private\n\t\t * @param {Node} node Node to check.\n\t\t * @return {boolean} True/false if the node is a text block.\n\t\t */\n\t\tfunction isTextBlock(name) {\n\t\t\treturn /^(h[1-6]|p|div|pre|address|dl|dt|dd)$/.test(name);\n\t\t};\n\n\t\tfunction getContainer(rng, start) {\n\t\t\tvar container, offset, lastIdx, walker;\n\n\t\t\tcontainer = rng[start ? 'startContainer' : 'endContainer'];\n\t\t\toffset = rng[start ? 'startOffset' : 'endOffset'];\n\n\t\t\tif (container.nodeType == 1) {\n\t\t\t\tlastIdx = container.childNodes.length - 1;\n\n\t\t\t\tif (!start && offset)\n\t\t\t\t\toffset--;\n\n\t\t\t\tcontainer = container.childNodes[offset > lastIdx ? lastIdx : offset];\n\t\t\t}\n\n\t\t\t// If start text node is excluded then walk to the next node\n\t\t\tif (container.nodeType === 3 && start && offset >= container.nodeValue.length) {\n\t\t\t\tcontainer = new TreeWalker(container, ed.getBody()).next() || container;\n\t\t\t}\n\n\t\t\t// If end text node is excluded then walk to the previous node\n\t\t\tif (container.nodeType === 3 && !start && offset == 0) {\n\t\t\t\tcontainer = new TreeWalker(container, ed.getBody()).prev() || container;\n\t\t\t}\n\n\t\t\treturn container;\n\t\t};\n\n\t\tfunction performCaretAction(type, name, vars) {\n\t\t\tvar invisibleChar, caretContainerId = '_mce_caret', debug = ed.settings.caret_debug;\n\n\t\t\t// Setup invisible character use zero width space on Gecko since it doesn't change the heigt of the container\n\t\t\tinvisibleChar = tinymce.isGecko ? '\\u200B' : INVISIBLE_CHAR;\n\n\t\t\t// Creates a caret container bogus element\n\t\t\tfunction createCaretContainer(fill) {\n\t\t\t\tvar caretContainer = dom.create('span', {id: caretContainerId, 'data-mce-bogus': true, style: debug ? 'color:red' : ''});\n\n\t\t\t\tif (fill) {\n\t\t\t\t\tcaretContainer.appendChild(ed.getDoc().createTextNode(invisibleChar));\n\t\t\t\t}\n\n\t\t\t\treturn caretContainer;\n\t\t\t};\n\n\t\t\tfunction isCaretContainerEmpty(node, nodes) {\n\t\t\t\twhile (node) {\n\t\t\t\t\tif ((node.nodeType === 3 && node.nodeValue !== invisibleChar) || node.childNodes.length > 1) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Collect nodes\n\t\t\t\t\tif (nodes && node.nodeType === 1) {\n\t\t\t\t\t\tnodes.push(node);\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = node.firstChild;\n\t\t\t\t}\n\n\t\t\t\treturn true;\n\t\t\t};\n\n\t\t\t// Returns any parent caret container element\n\t\t\tfunction getParentCaretContainer(node) {\n\t\t\t\twhile (node) {\n\t\t\t\t\tif (node.id === caretContainerId) {\n\t\t\t\t\t\treturn node;\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Finds the first text node in the specified node\n\t\t\tfunction findFirstTextNode(node) {\n\t\t\t\tvar walker;\n\n\t\t\t\tif (node) {\n\t\t\t\t\twalker = new TreeWalker(node, node);\n\n\t\t\t\t\tfor (node = walker.current(); node; node = walker.next()) {\n\t\t\t\t\t\tif (node.nodeType === 3) {\n\t\t\t\t\t\t\treturn node;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Removes the caret container for the specified node or all on the current document\n\t\t\tfunction removeCaretContainer(node, move_caret) {\n\t\t\t\tvar child, rng;\n\n\t\t\t\tif (!node) {\n\t\t\t\t\tnode = getParentCaretContainer(selection.getStart());\n\n\t\t\t\t\tif (!node) {\n\t\t\t\t\t\twhile (node = dom.get(caretContainerId)) {\n\t\t\t\t\t\t\tremoveCaretContainer(node, false);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\trng = selection.getRng(true);\n\n\t\t\t\t\tif (isCaretContainerEmpty(node)) {\n\t\t\t\t\t\tif (move_caret !== false) {\n\t\t\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\t\t\trng.setEndBefore(node);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tdom.remove(node);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tchild = findFirstTextNode(node);\n\t\t\t\t\t\tchild = child.deleteData(0, 1);\n\t\t\t\t\t\tdom.remove(node, 1);\n\t\t\t\t\t}\n\n\t\t\t\t\tselection.setRng(rng);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Applies formatting to the caret position\n\t\t\tfunction applyCaretFormat() {\n\t\t\t\tvar rng, caretContainer, textNode, offset, bookmark, container, text;\n\n\t\t\t\trng = selection.getRng(true);\n\t\t\t\toffset = rng.startOffset;\n\t\t\t\tcontainer = rng.startContainer;\n\t\t\t\ttext = container.nodeValue;\n\n\t\t\t\tcaretContainer = getParentCaretContainer(selection.getStart());\n\t\t\t\tif (caretContainer) {\n\t\t\t\t\ttextNode = findFirstTextNode(caretContainer);\n\t\t\t\t}\n\n\t\t\t\t// Expand to word is caret is in the middle of a text node and the char before/after is a alpha numeric character\n\t\t\t\tif (text && offset > 0 && offset < text.length && /\\w/.test(text.charAt(offset)) && /\\w/.test(text.charAt(offset - 1))) {\n\t\t\t\t\t// Get bookmark of caret position\n\t\t\t\t\tbookmark = selection.getBookmark();\n\n\t\t\t\t\t// Collapse bookmark range (WebKit)\n\t\t\t\t\trng.collapse(true);\n\n\t\t\t\t\t// Expand the range to the closest word and split it at those points\n\t\t\t\t\trng = expandRng(rng, get(name));\n\t\t\t\t\trng = rangeUtils.split(rng);\n\n\t\t\t\t\t// Apply the format to the range\n\t\t\t\t\tapply(name, vars, rng);\n\n\t\t\t\t\t// Move selection back to caret position\n\t\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t\t} else {\n\t\t\t\t\tif (!caretContainer || textNode.nodeValue !== invisibleChar) {\n\t\t\t\t\t\tcaretContainer = createCaretContainer(true);\n\t\t\t\t\t\ttextNode = caretContainer.firstChild;\n\n\t\t\t\t\t\trng.insertNode(caretContainer);\n\t\t\t\t\t\toffset = 1;\n\n\t\t\t\t\t\tapply(name, vars, caretContainer);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tapply(name, vars, caretContainer);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Move selection to text node\n\t\t\t\t\tselection.setCursorLocation(textNode, offset);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tfunction removeCaretFormat() {\n\t\t\t\tvar rng = selection.getRng(true), container, offset, bookmark,\n\t\t\t\t\thasContentAfter, node, formatNode, parents = [], i, caretContainer;\n\n\t\t\t\tcontainer = rng.startContainer;\n\t\t\t\toffset = rng.startOffset;\n\t\t\t\tnode = container;\n\n\t\t\t\tif (container.nodeType == 3) {\n\t\t\t\t\tif (offset != container.nodeValue.length || container.nodeValue === invisibleChar) {\n\t\t\t\t\t\thasContentAfter = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t}\n\n\t\t\t\twhile (node) {\n\t\t\t\t\tif (matchNode(node, name, vars)) {\n\t\t\t\t\t\tformatNode = node;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (node.nextSibling) {\n\t\t\t\t\t\thasContentAfter = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tparents.push(node);\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t}\n\n\t\t\t\t// Node doesn't have the specified format\n\t\t\t\tif (!formatNode) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Is there contents after the caret then remove the format on the element\n\t\t\t\tif (hasContentAfter) {\n\t\t\t\t\t// Get bookmark of caret position\n\t\t\t\t\tbookmark = selection.getBookmark();\n\n\t\t\t\t\t// Collapse bookmark range (WebKit)\n\t\t\t\t\trng.collapse(true);\n\n\t\t\t\t\t// Expand the range to the closest word and split it at those points\n\t\t\t\t\trng = expandRng(rng, get(name), true);\n\t\t\t\t\trng = rangeUtils.split(rng);\n\n\t\t\t\t\t// Remove the format from the range\n\t\t\t\t\tremove(name, vars, rng);\n\n\t\t\t\t\t// Move selection back to caret position\n\t\t\t\t\tselection.moveToBookmark(bookmark);\n\t\t\t\t} else {\n\t\t\t\t\tcaretContainer = createCaretContainer();\n\n\t\t\t\t\tnode = caretContainer;\n\t\t\t\t\tfor (i = parents.length - 1; i >= 0; i--) {\n\t\t\t\t\t\tnode.appendChild(parents[i].cloneNode(false));\n\t\t\t\t\t\tnode = node.firstChild;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Insert invisible character into inner most format element\n\t\t\t\t\tnode.appendChild(dom.doc.createTextNode(invisibleChar));\n\t\t\t\t\tnode = node.firstChild;\n\n\t\t\t\t\t// Insert caret container after the formatted node\n\t\t\t\t\tdom.insertAfter(caretContainer, formatNode);\n\n\t\t\t\t\t// Move selection to text node\n\t\t\t\t\tselection.setCursorLocation(node, 1);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Mark current caret container elements as bogus when getting the contents so we don't end up with empty elements\n\t\t\ted.onBeforeGetContent.addToTop(function() {\n\t\t\t\tvar nodes = [], i;\n\n\t\t\t\tif (isCaretContainerEmpty(getParentCaretContainer(selection.getStart()), nodes)) {\n\t\t\t\t\t// Mark children\n\t\t\t\t\ti = nodes.length;\n\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\tdom.setAttrib(nodes[i], 'data-mce-bogus', '1');\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Remove caret container on mouse up and on key up\n\t\t\ttinymce.each('onMouseUp onKeyUp'.split(' '), function(name) {\n\t\t\t\ted[name].addToTop(function() {\n\t\t\t\t\tremoveCaretContainer();\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// Remove caret container on keydown and it's a backspace, enter or left/right arrow keys\n\t\t\ted.onKeyDown.addToTop(function(ed, e) {\n\t\t\t\tvar keyCode = e.keyCode;\n\n\t\t\t\tif (keyCode == 8 || keyCode == 37 || keyCode == 39) {\n\t\t\t\t\tremoveCaretContainer(getParentCaretContainer(selection.getStart()));\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Do apply or remove caret format\n\t\t\tif (type == \"apply\") {\n\t\t\t\tapplyCaretFormat();\n\t\t\t} else {\n\t\t\t\tremoveCaretFormat();\n\t\t\t}\n\t\t};\n\t};\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/EditorManager.js":"/**\n * EditorManager.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\t/**\n\t * @class tinymce\n\t */\n\n\t// Shorten names\n\tvar each = tinymce.each, extend = tinymce.extend,\n\t\tDOM = tinymce.DOM, Event = tinymce.dom.Event,\n\t\tThemeManager = tinymce.ThemeManager, PluginManager = tinymce.PluginManager,\n\t\texplode = tinymce.explode,\n\t\tDispatcher = tinymce.util.Dispatcher, undefined, instanceCounter = 0;\n\n\t// Setup some URLs where the editor API is located and where the document is\n\ttinymce.documentBaseURL = window.location.href.replace(/[\\?#].*$/, '').replace(/[\\/\\\\][^\\/]+$/, '');\n\tif (!/[\\/\\\\]$/.test(tinymce.documentBaseURL))\n\t\ttinymce.documentBaseURL += '/';\n\n\ttinymce.baseURL = new tinymce.util.URI(tinymce.documentBaseURL).toAbsolute(tinymce.baseURL);\n\n\t/**\n\t * Absolute baseURI for the installation path of TinyMCE.\n\t *\n\t * @property baseURI\n\t * @type tinymce.util.URI\n\t */\n\ttinymce.baseURI = new tinymce.util.URI(tinymce.baseURL);\n\n\t// Add before unload listener\n\t// This was required since IE was leaking memory if you added and removed beforeunload listeners\n\t// with attachEvent/detatchEvent so this only adds one listener and instances can the attach to the onBeforeUnload event\n\ttinymce.onBeforeUnload = new Dispatcher(tinymce);\n\n\t// Must be on window or IE will leak if the editor is placed in frame or iframe\n\tEvent.add(window, 'beforeunload', function(e) {\n\t\ttinymce.onBeforeUnload.dispatch(tinymce, e);\n\t});\n\n\t/**\n\t * Fires when a new editor instance is added to the tinymce collection.\n\t *\n\t * @event onAddEditor\n\t * @param {tinymce} sender TinyMCE root class/namespace.\n\t * @param {tinymce.Editor} editor Editor instance.\n\t * @example\n\t * tinyMCE.execCommand(\"mceAddControl\", false, \"some_textarea\");\n\t * tinyMCE.onAddEditor.add(function(mgr,ed) {\n\t *     console.debug('A new editor is available' + ed.id);\n\t * });\n\t */\n\ttinymce.onAddEditor = new Dispatcher(tinymce);\n\n\t/**\n\t * Fires when an editor instance is removed from the tinymce collection.\n\t *\n\t * @event onRemoveEditor\n\t * @param {tinymce} sender TinyMCE root class/namespace.\n\t * @param {tinymce.Editor} editor Editor instance.\n\t */\n\ttinymce.onRemoveEditor = new Dispatcher(tinymce);\n\n\ttinymce.EditorManager = extend(tinymce, {\n\t\t/**\n\t\t * Collection of editor instances.\n\t\t *\n\t\t * @property editors\n\t\t * @type Object\n\t\t * @example\n\t\t * for (edId in tinyMCE.editors)\n\t\t *     tinyMCE.editors[edId].save();\n\t\t */\n\t\teditors : [],\n\n\t\t/**\n\t\t * Collection of language pack data.\n\t\t *\n\t\t * @property i18n\n\t\t * @type Object\n\t\t */\n\t\ti18n : {},\n\n\t\t/**\n\t\t * Currently active editor instance.\n\t\t *\n\t\t * @property activeEditor\n\t\t * @type tinymce.Editor\n\t\t * @example\n\t\t * tinyMCE.activeEditor.selection.getContent();\n\t\t * tinymce.EditorManager.activeEditor.selection.getContent();\n\t\t */\n\t\tactiveEditor : null,\n\n\t\t/**\n\t\t * Initializes a set of editors. This method will create a bunch of editors based in the input.\n\t\t *\n\t\t * @method init\n\t\t * @param {Object} s Settings object to be passed to each editor instance.\n\t\t * @example\n\t\t * // Initializes a editor using the longer method\n\t\t * tinymce.EditorManager.init({\n\t\t *    some_settings : 'some value'\n\t\t * });\n\t\t * \n\t\t * // Initializes a editor instance using the shorter version\n\t\t * tinyMCE.init({\n\t\t *    some_settings : 'some value'\n\t\t * });\n\t\t */\n\t\tinit : function(s) {\n\t\t\tvar t = this, pl, sl = tinymce.ScriptLoader, e, el = [], ed;\n\n\t\t\tfunction execCallback(se, n, s) {\n\t\t\t\tvar f = se[n];\n\n\t\t\t\tif (!f)\n\t\t\t\t\treturn;\n\n\t\t\t\tif (tinymce.is(f, 'string')) {\n\t\t\t\t\ts = f.replace(/\\.\\w+$/, '');\n\t\t\t\t\ts = s ? tinymce.resolve(s) : 0;\n\t\t\t\t\tf = tinymce.resolve(f);\n\t\t\t\t}\n\n\t\t\t\treturn f.apply(s || this, Array.prototype.slice.call(arguments, 2));\n\t\t\t};\n\n\t\t\ts = extend({\n\t\t\t\ttheme : \"simple\",\n\t\t\t\tlanguage : \"en\"\n\t\t\t}, s);\n\n\t\t\tt.settings = s;\n\n\t\t\t// Legacy call\n\t\t\tEvent.add(document, 'init', function() {\n\t\t\t\tvar l, co;\n\n\t\t\t\texecCallback(s, 'onpageload');\n\n\t\t\t\tswitch (s.mode) {\n\t\t\t\t\tcase \"exact\":\n\t\t\t\t\t\tl = s.elements || '';\n\n\t\t\t\t\t\tif(l.length > 0) {\n\t\t\t\t\t\t\teach(explode(l), function(v) {\n\t\t\t\t\t\t\t\tif (DOM.get(v)) {\n\t\t\t\t\t\t\t\t\ted = new tinymce.Editor(v, s);\n\t\t\t\t\t\t\t\t\tel.push(ed);\n\t\t\t\t\t\t\t\t\ted.render(1);\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\teach(document.forms, function(f) {\n\t\t\t\t\t\t\t\t\t\teach(f.elements, function(e) {\n\t\t\t\t\t\t\t\t\t\t\tif (e.name === v) {\n\t\t\t\t\t\t\t\t\t\t\t\tv = 'mce_editor_' + instanceCounter++;\n\t\t\t\t\t\t\t\t\t\t\t\tDOM.setAttrib(e, 'id', v);\n\n\t\t\t\t\t\t\t\t\t\t\t\ted = new tinymce.Editor(v, s);\n\t\t\t\t\t\t\t\t\t\t\t\tel.push(ed);\n\t\t\t\t\t\t\t\t\t\t\t\ted.render(1);\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase \"textareas\":\n\t\t\t\t\tcase \"specific_textareas\":\n\t\t\t\t\t\tfunction hasClass(n, c) {\n\t\t\t\t\t\t\treturn c.constructor === RegExp ? c.test(n.className) : DOM.hasClass(n, c);\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\teach(DOM.select('textarea'), function(v) {\n\t\t\t\t\t\t\tif (s.editor_deselector && hasClass(v, s.editor_deselector))\n\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\tif (!s.editor_selector || hasClass(v, s.editor_selector)) {\n\t\t\t\t\t\t\t\t// Can we use the name\n\t\t\t\t\t\t\t\te = DOM.get(v.name);\n\t\t\t\t\t\t\t\tif (!v.id && !e)\n\t\t\t\t\t\t\t\t\tv.id = v.name;\n\n\t\t\t\t\t\t\t\t// Generate unique name if missing or already exists\n\t\t\t\t\t\t\t\tif (!v.id || t.get(v.id))\n\t\t\t\t\t\t\t\t\tv.id = DOM.uniqueId();\n\n\t\t\t\t\t\t\t\ted = new tinymce.Editor(v.id, s);\n\t\t\t\t\t\t\t\tel.push(ed);\n\t\t\t\t\t\t\t\ted.render(1);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\t// Call onInit when all editors are initialized\n\t\t\t\tif (s.oninit) {\n\t\t\t\t\tl = co = 0;\n\n\t\t\t\t\teach(el, function(ed) {\n\t\t\t\t\t\tco++;\n\n\t\t\t\t\t\tif (!ed.initialized) {\n\t\t\t\t\t\t\t// Wait for it\n\t\t\t\t\t\t\ted.onInit.add(function() {\n\t\t\t\t\t\t\t\tl++;\n\n\t\t\t\t\t\t\t\t// All done\n\t\t\t\t\t\t\t\tif (l == co)\n\t\t\t\t\t\t\t\t\texecCallback(s, 'oninit');\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\tl++;\n\n\t\t\t\t\t\t// All done\n\t\t\t\t\t\tif (l == co)\n\t\t\t\t\t\t\texecCallback(s, 'oninit');\t\t\t\t\t\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Returns a editor instance by id.\n\t\t *\n\t\t * @method get\n\t\t * @param {String/Number} id Editor instance id or index to return.\n\t\t * @return {tinymce.Editor} Editor instance to return.\n\t\t * @example\n\t\t * // Adds an onclick event to an editor by id (shorter version)\n\t\t * tinyMCE.get('mytextbox').onClick.add(function(ed, e) {\n\t\t *    ed.windowManager.alert('Hello world!');\n\t\t * });\n\t\t * \n\t\t * // Adds an onclick event to an editor by id (longer version)\n\t\t * tinymce.EditorManager.get('mytextbox').onClick.add(function(ed, e) {\n\t\t *    ed.windowManager.alert('Hello world!');\n\t\t * });\n\t\t */\n\t\tget : function(id) {\n\t\t\tif (id === undefined)\n\t\t\t\treturn this.editors;\n\n\t\t\treturn this.editors[id];\n\t\t},\n\n\t\t/**\n\t\t * Returns a editor instance by id. This method was added for compatibility with the 2.x branch.\n\t\t *\n\t\t * @method getInstanceById\n\t\t * @param {String} id Editor instance id to return.\n\t\t * @return {tinymce.Editor} Editor instance to return.\n\t\t * @deprecated Use get method instead.\n\t\t * @see #get\n\t\t */\n\t\tgetInstanceById : function(id) {\n\t\t\treturn this.get(id);\n\t\t},\n\n\t\t/**\n\t\t * Adds an editor instance to the editor collection. This will also set it as the active editor.\n\t\t *\n\t\t * @method add\n\t\t * @param {tinymce.Editor} editor Editor instance to add to the collection.\n\t\t * @return {tinymce.Editor} The same instance that got passed in.\n\t\t */\n\t\tadd : function(editor) {\n\t\t\tvar self = this, editors = self.editors;\n\n\t\t\t// Add named and index editor instance\n\t\t\teditors[editor.id] = editor;\n\t\t\teditors.push(editor);\n\n\t\t\tself._setActive(editor);\n\t\t\tself.onAddEditor.dispatch(self, editor);\n\n\t\t\t// #ifdef jquery\n\n\t\t\t// Patch the tinymce.Editor instance with jQuery adapter logic\n\t\t\tif (tinymce.adapter)\n\t\t\t\ttinymce.adapter.patchEditor(editor);\n\n\t\t\t// #endif\n\n\t\t\treturn editor;\n\t\t},\n\n\t\t/**\n\t\t * Removes a editor instance from the collection.\n\t\t *\n\t\t * @method remove\n\t\t * @param {tinymce.Editor} e Editor instance to remove.\n\t\t * @return {tinymce.Editor} The editor that got passed in will be return if it was found otherwise null.\n\t\t */\n\t\tremove : function(editor) {\n\t\t\tvar t = this, i, editors = t.editors;\n\n\t\t\t// Not in the collection\n\t\t\tif (!editors[editor.id])\n\t\t\t\treturn null;\n\n\t\t\tdelete editors[editor.id];\n\n\t\t\tfor (i = 0; i < editors.length; i++) {\n\t\t\t\tif (editors[i] == editor) {\n\t\t\t\t\teditors.splice(i, 1);\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Select another editor since the active one was removed\n\t\t\tif (t.activeEditor == editor)\n\t\t\t\tt._setActive(editors[0]);\n\n\t\t\teditor.destroy();\n\t\t\tt.onRemoveEditor.dispatch(t, editor);\n\n\t\t\treturn editor;\n\t\t},\n\n\t\t/**\n\t\t * Executes a specific command on the currently active editor.\n\t\t *\n\t\t * @method execCommand\n\t\t * @param {String} c Command to perform for example Bold.\n\t\t * @param {Boolean} u Optional boolean state if a UI should be presented for the command or not.\n\t\t * @param {String} v Optional value parameter like for example an URL to a link.\n\t\t * @return {Boolean} true/false if the command was executed or not.\n\t\t */\n\t\texecCommand : function(c, u, v) {\n\t\t\tvar t = this, ed = t.get(v), w;\n\n\t\t\t// Manager commands\n\t\t\tswitch (c) {\n\t\t\t\tcase \"mceFocus\":\n\t\t\t\t\ted.focus();\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase \"mceAddEditor\":\n\t\t\t\tcase \"mceAddControl\":\n\t\t\t\t\tif (!t.get(v))\n\t\t\t\t\t\tnew tinymce.Editor(v, t.settings).render();\n\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase \"mceAddFrameControl\":\n\t\t\t\t\tw = v.window;\n\n\t\t\t\t\t// Add tinyMCE global instance and tinymce namespace to specified window\n\t\t\t\t\tw.tinyMCE = tinyMCE;\n\t\t\t\t\tw.tinymce = tinymce;\n\n\t\t\t\t\ttinymce.DOM.doc = w.document;\n\t\t\t\t\ttinymce.DOM.win = w;\n\n\t\t\t\t\ted = new tinymce.Editor(v.element_id, v);\n\t\t\t\t\ted.render();\n\n\t\t\t\t\t// Fix IE memory leaks\n\t\t\t\t\tif (tinymce.isIE) {\n\t\t\t\t\t\tfunction clr() {\n\t\t\t\t\t\t\ted.destroy();\n\t\t\t\t\t\t\tw.detachEvent('onunload', clr);\n\t\t\t\t\t\t\tw = w.tinyMCE = w.tinymce = null; // IE leak\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\tw.attachEvent('onunload', clr);\n\t\t\t\t\t}\n\n\t\t\t\t\tv.page_window = null;\n\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase \"mceRemoveEditor\":\n\t\t\t\tcase \"mceRemoveControl\":\n\t\t\t\t\tif (ed)\n\t\t\t\t\t\ted.remove();\n\n\t\t\t\t\treturn true;\n\n\t\t\t\tcase 'mceToggleEditor':\n\t\t\t\t\tif (!ed) {\n\t\t\t\t\t\tt.execCommand('mceAddControl', 0, v);\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (ed.isHidden())\n\t\t\t\t\t\ted.show();\n\t\t\t\t\telse\n\t\t\t\t\t\ted.hide();\n\n\t\t\t\t\treturn true;\n\t\t\t}\n\n\t\t\t// Run command on active editor\n\t\t\tif (t.activeEditor)\n\t\t\t\treturn t.activeEditor.execCommand(c, u, v);\n\n\t\t\treturn false;\n\t\t},\n\n\t\t/**\n\t\t * Executes a command on a specific editor by id. This method was added for compatibility with the 2.x branch.\n\t\t *\n\t\t * @deprecated Use the execCommand method of a editor instance instead.\n\t\t * @method execInstanceCommand\n\t\t * @param {String} id Editor id to perform the command on.\n\t\t * @param {String} c Command to perform for example Bold.\n\t\t * @param {Boolean} u Optional boolean state if a UI should be presented for the command or not.\n\t\t * @param {String} v Optional value parameter like for example an URL to a link.\n\t\t * @return {Boolean} true/false if the command was executed or not.\n\t\t */\n\t\texecInstanceCommand : function(id, c, u, v) {\n\t\t\tvar ed = this.get(id);\n\n\t\t\tif (ed)\n\t\t\t\treturn ed.execCommand(c, u, v);\n\n\t\t\treturn false;\n\t\t},\n\n\t\t/**\n\t\t * Calls the save method on all editor instances in the collection. This can be useful when a form is to be submitted.\n\t\t *\n\t\t * @method triggerSave\n\t\t * @example\n\t\t * // Saves all contents\n\t\t * tinyMCE.triggerSave();\n\t\t */\n\t\ttriggerSave : function() {\n\t\t\teach(this.editors, function(e) {\n\t\t\t\te.save();\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Adds a language pack, this gets called by the loaded language files like en.js.\n\t\t *\n\t\t * @method addI18n\n\t\t * @param {String} p Prefix for the language items. For example en.myplugin\n\t\t * @param {Object} o Name/Value collection with items to add to the language group.\n\t\t */\n\t\taddI18n : function(p, o) {\n\t\t\tvar lo, i18n = this.i18n;\n\n\t\t\tif (!tinymce.is(p, 'string')) {\n\t\t\t\teach(p, function(o, lc) {\n\t\t\t\t\teach(o, function(o, g) {\n\t\t\t\t\t\teach(o, function(o, k) {\n\t\t\t\t\t\t\tif (g === 'common')\n\t\t\t\t\t\t\t\ti18n[lc + '.' + k] = o;\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\ti18n[lc + '.' + g + '.' + k] = o;\n\t\t\t\t\t\t});\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\teach(o, function(o, k) {\n\t\t\t\t\ti18n[p + '.' + k] = o;\n\t\t\t\t});\n\t\t\t}\n\t\t},\n\n\t\t// Private methods\n\n\t\t_setActive : function(editor) {\n\t\t\tthis.selectedInstance = this.activeEditor = editor;\n\t\t}\n\t});\n})(tinymce);\n\n/**\n * Alternative name for tinymce added for 2.x compatibility.\n *\n * @member\n * @property tinyMCE\n * @type tinymce\n * @example\n * // To initialize editor instances\n * tinyMCE.init({\n *    ...\n * });\n */\n\n/**\n * Alternative name for tinymce added for compatibility.\n *\n * @member tinymce\n * @property EditorManager\n * @type tinymce\n * @example\n * // To initialize editor instances\n * tinymce.EditorManager.get('editor');\n */\n","Magento_Tinymce3/tiny_mce/classes/ControlManager.js":"/**\n * ControlManager.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\t// Shorten names\n\tvar DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each, extend = tinymce.extend;\n\n\t/**\n\t * This class is responsible for managing UI control instances. It's both a factory and a collection for the controls.\n\t * @class tinymce.ControlManager\n\t */\n\ttinymce.create('tinymce.ControlManager', {\n\t\t/**\n\t\t * Constructs a new control manager instance.\n\t\t * Consult the Wiki for more details on this class.\n\t\t *\n\t\t * @constructor\n\t\t * @method ControlManager\n\t\t * @param {tinymce.Editor} ed TinyMCE editor instance to add the control to.\n\t\t * @param {Object} s Optional settings object for the control manager.\n\t\t */\n\t\tControlManager : function(ed, s) {\n\t\t\tvar t = this, i;\n\n\t\t\ts = s || {};\n\t\t\tt.editor = ed;\n\t\t\tt.controls = {};\n\t\t\tt.onAdd = new tinymce.util.Dispatcher(t);\n\t\t\tt.onPostRender = new tinymce.util.Dispatcher(t);\n\t\t\tt.prefix = s.prefix || ed.id + '_';\n\t\t\tt._cls = {};\n\n\t\t\tt.onPostRender.add(function() {\n\t\t\t\teach(t.controls, function(c) {\n\t\t\t\t\tc.postRender();\n\t\t\t\t});\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Returns a control by id or undefined it wasn't found.\n\t\t *\n\t\t * @method get\n\t\t * @param {String} id Control instance name.\n\t\t * @return {tinymce.ui.Control} Control instance or undefined.\n\t\t */\n\t\tget : function(id) {\n\t\t\treturn this.controls[this.prefix + id] || this.controls[id];\n\t\t},\n\n\t\t/**\n\t\t * Sets the active state of a control by id.\n\t\t *\n\t\t * @method setActive\n\t\t * @param {String} id Control id to set state on.\n\t\t * @param {Boolean} s Active state true/false.\n\t\t * @return {tinymce.ui.Control} Control instance that got activated or null if it wasn't found.\n\t\t */\n\t\tsetActive : function(id, s) {\n\t\t\tvar c = null;\n\n\t\t\tif (c = this.get(id))\n\t\t\t\tc.setActive(s);\n\n\t\t\treturn c;\n\t\t},\n\n\t\t/**\n\t\t * Sets the dsiabled state of a control by id.\n\t\t *\n\t\t * @method setDisabled\n\t\t * @param {String} id Control id to set state on.\n\t\t * @param {Boolean} s Active state true/false.\n\t\t * @return {tinymce.ui.Control} Control instance that got disabled or null if it wasn't found.\n\t\t */\n\t\tsetDisabled : function(id, s) {\n\t\t\tvar c = null;\n\n\t\t\tif (c = this.get(id))\n\t\t\t\tc.setDisabled(s);\n\n\t\t\treturn c;\n\t\t},\n\n\t\t/**\n\t\t * Adds a control to the control collection inside the manager.\n\t\t *\n\t\t * @method add\n\t\t * @param {tinymce.ui.Control} Control instance to add to collection.\n\t\t * @return {tinymce.ui.Control} Control instance that got passed in.\n\t\t */\n\t\tadd : function(c) {\n\t\t\tvar t = this;\n\n\t\t\tif (c) {\n\t\t\t\tt.controls[c.id] = c;\n\t\t\t\tt.onAdd.dispatch(c, t);\n\t\t\t}\n\n\t\t\treturn c;\n\t\t},\n\n\t\t/**\n\t\t * Creates a control by name, when a control is created it will automatically add it to the control collection.\n\t\t * It first ask all plugins for the specified control if the plugins didn't return a control then the default behavior\n\t\t * will be used.\n\t\t *\n\t\t * @method createControl\n\t\t * @param {String} n Control name to create for example \"separator\".\n\t\t * @return {tinymce.ui.Control} Control instance that got created and added.\n\t\t */\n\t\tcreateControl : function(n) {\n\t\t\tvar c, t = this, ed = t.editor;\n\n\t\t\teach(ed.plugins, function(p) {\n\t\t\t\tif (p.createControl) {\n\t\t\t\t\tc = p.createControl(n, t);\n\n\t\t\t\t\tif (c)\n\t\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tswitch (n) {\n\t\t\t\tcase \"|\":\n\t\t\t\tcase \"separator\":\n\t\t\t\t\treturn t.createSeparator();\n\t\t\t}\n\n\t\t\tif (!c && ed.buttons && (c = ed.buttons[n]))\n\t\t\t\treturn t.createButton(n, c);\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\t/**\n\t\t * Creates a drop menu control instance by id.\n\t\t *\n\t\t * @method createDropMenu\n\t\t * @param {String} id Unique id for the new dropdown instance. For example \"some menu\".\n\t\t * @param {Object} s Optional settings object for the control.\n\t\t * @param {Object} cc Optional control class to use instead of the default one.\n\t\t * @return {tinymce.ui.Control} Control instance that got created and added.\n\t\t */\n\t\tcreateDropMenu : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, c, bm, v, cls;\n\n\t\t\ts = extend({\n\t\t\t\t'class' : 'mceDropDown',\n\t\t\t\tconstrain : ed.settings.constrain_menus\n\t\t\t}, s);\n\n\t\t\ts['class'] = s['class'] + ' ' + ed.getParam('skin') + 'Skin';\n\t\t\tif (v = ed.getParam('skin_variant'))\n\t\t\t\ts['class'] += ' ' + ed.getParam('skin') + 'Skin' + v.substring(0, 1).toUpperCase() + v.substring(1);\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.dropmenu || tinymce.ui.DropMenu;\n\t\t\tc = t.controls[id] = new cls(id, s);\n\t\t\tc.onAddItem.add(function(c, o) {\n\t\t\t\tvar s = o.settings;\n\n\t\t\t\ts.title = ed.getLang(s.title, s.title);\n\n\t\t\t\tif (!s.onclick) {\n\t\t\t\t\ts.onclick = function(v) {\n\t\t\t\t\t\tif (s.cmd)\n\t\t\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, s.value);\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t});\n\n\t\t\ted.onRemove.add(function() {\n\t\t\t\tc.destroy();\n\t\t\t});\n\n\t\t\t// Fix for bug #1897785, #1898007\n\t\t\tif (tinymce.isIE) {\n\t\t\t\tc.onShowMenu.add(function() {\n\t\t\t\t\t// IE 8 needs focus in order to store away a range with the current collapsed caret location\n\t\t\t\t\ted.focus();\n\n\t\t\t\t\tbm = ed.selection.getBookmark(1);\n\t\t\t\t});\n\n\t\t\t\tc.onHideMenu.add(function() {\n\t\t\t\t\tif (bm) {\n\t\t\t\t\t\ted.selection.moveToBookmark(bm);\n\t\t\t\t\t\tbm = 0;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\t/**\n\t\t * Creates a list box control instance by id. A list box is either a native select element or a DOM/JS based list box control. This\n\t\t * depends on the use_native_selects settings state.\n\t\t *\n\t\t * @method createListBox\n\t\t * @param {String} id Unique id for the new listbox instance. For example \"styles\".\n\t\t * @param {Object} s Optional settings object for the control.\n\t\t * @param {Object} cc Optional control class to use instead of the default one.\n\t\t * @return {tinymce.ui.Control} Control instance that got created and added.\n\t\t */\n\t\tcreateListBox : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, cmd, c, cls;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onselect) {\n\t\t\t\ts.onselect = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\tscope : s.scope,\n\t\t\t\tcontrol_manager : t\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\n\n\t\t\tfunction useNativeListForAccessibility(ed) {\n\t\t\t\treturn ed.settings.use_accessible_selects && !tinymce.isGecko\n\t\t\t}\n\n\t\t\tif (ed.settings.use_native_selects || useNativeListForAccessibility(ed))\n\t\t\t\tc = new tinymce.ui.NativeListBox(id, s);\n\t\t\telse {\n\t\t\t\tcls = cc || t._cls.listbox || tinymce.ui.ListBox;\n\t\t\t\tc = new cls(id, s, ed);\n\t\t\t}\n\n\t\t\tt.controls[id] = c;\n\n\t\t\t// Fix focus problem in Safari\n\t\t\tif (tinymce.isWebKit) {\n\t\t\t\tc.onPostRender.add(function(c, n) {\n\t\t\t\t\t// Store bookmark on mousedown\n\t\t\t\t\tEvent.add(n, 'mousedown', function() {\n\t\t\t\t\t\ted.bookmark = ed.selection.getBookmark(1);\n\t\t\t\t\t});\n\n\t\t\t\t\t// Restore on focus, since it might be lost\n\t\t\t\t\tEvent.add(n, 'focus', function() {\n\t\t\t\t\t\ted.selection.moveToBookmark(ed.bookmark);\n\t\t\t\t\t\ted.bookmark = null;\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tif (c.hideMenu)\n\t\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\t/**\n\t\t * Creates a button control instance by id.\n\t\t *\n\t\t * @method createButton\n\t\t * @param {String} id Unique id for the new button instance. For example \"bold\".\n\t\t * @param {Object} s Optional settings object for the control.\n\t\t * @param {Object} cc Optional control class to use instead of the default one.\n\t\t * @return {tinymce.ui.Control} Control instance that got created and added.\n\t\t */\n\t\tcreateButton : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, o, c, cls;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.label = ed.translate(s.label);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onclick && !s.menu_button) {\n\t\t\t\ts.onclick = function() {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\tunavailable_prefix : ed.getLang('unavailable', ''),\n\t\t\t\tscope : s.scope,\n\t\t\t\tcontrol_manager : t\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\n\t\t\tif (s.menu_button) {\n\t\t\t\tcls = cc || t._cls.menubutton || tinymce.ui.MenuButton;\n\t\t\t\tc = new cls(id, s, ed);\n\t\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\t\t\t} else {\n\t\t\t\tcls = t._cls.button || tinymce.ui.Button;\n\t\t\t\tc = new cls(id, s, ed);\n\t\t\t}\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\t/**\n\t\t * Creates a menu button control instance by id.\n\t\t *\n\t\t * @method createMenuButton\n\t\t * @param {String} id Unique id for the new menu button instance. For example \"menu1\".\n\t\t * @param {Object} s Optional settings object for the control.\n\t\t * @param {Object} cc Optional control class to use instead of the default one.\n\t\t * @return {tinymce.ui.Control} Control instance that got created and added.\n\t\t */\n\t\tcreateMenuButton : function(id, s, cc) {\n\t\t\ts = s || {};\n\t\t\ts.menu_button = 1;\n\n\t\t\treturn this.createButton(id, s, cc);\n\t\t},\n\n\t\t/**\n\t\t * Creates a split button control instance by id.\n\t\t *\n\t\t * @method createSplitButton\n\t\t * @param {String} id Unique id for the new split button instance. For example \"spellchecker\".\n\t\t * @param {Object} s Optional settings object for the control.\n\t\t * @param {Object} cc Optional control class to use instead of the default one.\n\t\t * @return {tinymce.ui.Control} Control instance that got created and added.\n\t\t */\n\t\tcreateSplitButton : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, cmd, c, cls;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onclick) {\n\t\t\t\ts.onclick = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (!s.onselect) {\n\t\t\t\ts.onselect = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\tscope : s.scope,\n\t\t\t\tcontrol_manager : t\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.splitbutton || tinymce.ui.SplitButton;\n\t\t\tc = t.add(new cls(id, s, ed));\n\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\n\t\t\treturn c;\n\t\t},\n\n\t\t/**\n\t\t * Creates a color split button control instance by id.\n\t\t *\n\t\t * @method createColorSplitButton\n\t\t * @param {String} id Unique id for the new color split button instance. For example \"forecolor\".\n\t\t * @param {Object} s Optional settings object for the control.\n\t\t * @param {Object} cc Optional control class to use instead of the default one.\n\t\t * @return {tinymce.ui.Control} Control instance that got created and added.\n\t\t */\n\t\tcreateColorSplitButton : function(id, s, cc) {\n\t\t\tvar t = this, ed = t.editor, cmd, c, cls, bm;\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\ts.title = ed.translate(s.title);\n\t\t\ts.scope = s.scope || ed;\n\n\t\t\tif (!s.onclick) {\n\t\t\t\ts.onclick = function(v) {\n\t\t\t\t\tif (tinymce.isIE)\n\t\t\t\t\t\tbm = ed.selection.getBookmark(1);\n\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\tif (!s.onselect) {\n\t\t\t\ts.onselect = function(v) {\n\t\t\t\t\ted.execCommand(s.cmd, s.ui || false, v || s.value);\n\t\t\t\t};\n\t\t\t}\n\n\t\t\ts = extend({\n\t\t\t\ttitle : s.title,\n\t\t\t\t'class' : 'mce_' + id,\n\t\t\t\t'menu_class' : ed.getParam('skin') + 'Skin',\n\t\t\t\tscope : s.scope,\n\t\t\t\tmore_colors_title : ed.getLang('more_colors')\n\t\t\t}, s);\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.colorsplitbutton || tinymce.ui.ColorSplitButton;\n\t\t\tc = new cls(id, s, ed);\n\t\t\ted.onMouseDown.add(c.hideMenu, c);\n\n\t\t\t// Remove the menu element when the editor is removed\n\t\t\ted.onRemove.add(function() {\n\t\t\t\tc.destroy();\n\t\t\t});\n\n\t\t\t// Fix for bug #1897785, #1898007\n\t\t\tif (tinymce.isIE) {\n\t\t\t\tc.onShowMenu.add(function() {\n\t\t\t\t\t// IE 8 needs focus in order to store away a range with the current collapsed caret location\n\t\t\t\t\ted.focus();\n\t\t\t\t\tbm = ed.selection.getBookmark(1);\n\t\t\t\t});\n\n\t\t\t\tc.onHideMenu.add(function() {\n\t\t\t\t\tif (bm) {\n\t\t\t\t\t\ted.selection.moveToBookmark(bm);\n\t\t\t\t\t\tbm = 0;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\t/**\n\t\t * Creates a toolbar container control instance by id.\n\t\t *\n\t\t * @method createToolbar\n\t\t * @param {String} id Unique id for the new toolbar container control instance. For example \"toolbar1\".\n\t\t * @param {Object} s Optional settings object for the control.\n\t\t * @param {Object} cc Optional control class to use instead of the default one.\n\t\t * @return {tinymce.ui.Control} Control instance that got created and added.\n\t\t */\n\t\tcreateToolbar : function(id, s, cc) {\n\t\t\tvar c, t = this, cls;\n\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || t._cls.toolbar || tinymce.ui.Toolbar;\n\t\t\tc = new cls(id, s, t.editor);\n\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\n\t\t\treturn t.add(c);\n\t\t},\n\t\t\n\t\tcreateToolbarGroup : function(id, s, cc) {\n\t\t\tvar c, t = this, cls;\n\t\t\tid = t.prefix + id;\n\t\t\tcls = cc || this._cls.toolbarGroup || tinymce.ui.ToolbarGroup;\n\t\t\tc = new cls(id, s, t.editor);\n\t\t\t\n\t\t\tif (t.get(id))\n\t\t\t\treturn null;\n\t\t\t\n\t\t\treturn t.add(c);\n\t\t},\n\n\t\t/**\n\t\t * Creates a separator control instance.\n\t\t *\n\t\t * @method createSeparator\n\t\t * @param {Object} cc Optional control class to use instead of the default one.\n\t\t * @return {tinymce.ui.Control} Control instance that got created and added.\n\t\t */\n\t\tcreateSeparator : function(cc) {\n\t\t\tvar cls = cc || this._cls.separator || tinymce.ui.Separator;\n\n\t\t\treturn new cls();\n\t\t},\n\n\t\t/**\n\t\t * Overrides a specific control type with a custom class.\n\t\t *\n\t\t * @method setControlType\n\t\t * @param {string} n Name of the control to override for example button or dropmenu.\n\t\t * @param {function} c Class reference to use instead of the default one.\n\t\t * @return {function} Same as the class reference.\n\t\t */\n\t\tsetControlType : function(n, c) {\n\t\t\treturn this._cls[n.toLowerCase()] = c;\n\t\t},\n\t\n\t\t/**\n\t\t * Destroy.\n\t\t *\n\t\t * @method destroy\n\t\t */\n\t\tdestroy : function() {\n\t\t\teach(this.controls, function(c) {\n\t\t\t\tc.destroy();\n\t\t\t});\n\n\t\t\tthis.controls = null;\n\t\t}\n\t});\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/AddOnManager.js":"/**\n * AddOnManager.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\tvar Dispatcher = tinymce.util.Dispatcher, each = tinymce.each;\n\n\t/**\n\t * This class handles the loading of themes/plugins or other add-ons and their language packs.\n\t *\n\t * @class tinymce.AddOnManager\n\t */\n\ttinymce.create('tinymce.AddOnManager', {\n\t\tAddOnManager : function() {\n\t\t\tvar self = this;\n\n\t\t\tself.items = [];\n\t\t\tself.urls = {};\n\t\t\tself.lookup = {};\n\t\t\tself.onAdd = new Dispatcher(self);\n\t\t},\n\n\t\t/**\n\t\t * Fires when a item is added.\n\t\t *\n\t\t * @event onAdd\n\t\t */\n\n\t\t/**\n\t\t * Returns the specified add on by the short name.\n\t\t *\n\t\t * @method get\n\t\t * @param {String} n Add-on to look for.\n\t\t * @return {tinymce.Theme/tinymce.Plugin} Theme or plugin add-on instance or undefined.\n\t\t */\n\t\tget : function(n) {\n\t\t\tif (this.lookup[n]) {\n\t\t\t\treturn this.lookup[n].instance;\n\t\t\t} else {\n\t\t\t\treturn undefined;\n\t\t\t}\n\t\t},\n\n\t\tdependencies : function(n) {\n\t\t\tvar result;\n\t\t\tif (this.lookup[n]) {\n\t\t\t\tresult = this.lookup[n].dependencies;\n\t\t\t}\n\t\t\treturn result || [];\n\t\t},\n\n\t\t/**\n\t\t * Loads a language pack for the specified add-on.\n\t\t *\n\t\t * @method requireLangPack\n\t\t * @param {String} n Short name of the add-on.\n\t\t */\n\t\trequireLangPack : function(n) {\n\t\t\tvar s = tinymce.settings;\n\n\t\t\tif (s && s.language && s.language_load !== false)\n\t\t\t\ttinymce.ScriptLoader.add(this.urls[n] + '/langs/' + s.language + '.js');\n\t\t},\n\n\t\t/**\n\t\t * Adds a instance of the add-on by it's short name.\n\t\t *\n\t\t * @method add\n\t\t * @param {String} id Short name/id for the add-on.\n\t\t * @param {tinymce.Theme/tinymce.Plugin} o Theme or plugin to add.\n\t\t * @return {tinymce.Theme/tinymce.Plugin} The same theme or plugin instance that got passed in.\n\t\t * @example\n\t\t * // Create a simple plugin\n\t\t * tinymce.create('tinymce.plugins.TestPlugin', {\n\t\t *     TestPlugin : function(ed, url) {\n\t\t *         ed.onClick.add(function(ed, e) {\n\t\t *             ed.windowManager.alert('Hello World!');\n\t\t *         });\n\t\t *     }\n\t\t * });\n\t\t * \n\t\t * // Register plugin using the add method\n\t\t * tinymce.PluginManager.add('test', tinymce.plugins.TestPlugin);\n\t\t * \n\t\t * // Initialize TinyMCE\n\t\t * tinyMCE.init({\n\t\t *    ...\n\t\t *    plugins : '-test' // Init the plugin but don't try to load it\n\t\t * });\n\t\t */\n\t\tadd : function(id, o, dependencies) {\n\t\t\tthis.items.push(o);\n\t\t\tthis.lookup[id] = {instance:o, dependencies:dependencies};\n\t\t\tthis.onAdd.dispatch(this, id, o);\n\n\t\t\treturn o;\n\t\t},\n\t\tcreateUrl: function(baseUrl, dep) {\n\t\t\tif (typeof dep === \"object\") {\n\t\t\t\treturn dep\n\t\t\t} else {\n\t\t\t\treturn {prefix: baseUrl.prefix, resource: dep, suffix: baseUrl.suffix};\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t \t * Add a set of components that will make up the add-on. Using the url of the add-on name as the base url.\n\t\t * This should be used in development mode.  A new compressor/javascript munger process will ensure that the \n\t\t * components are put together into the editor_plugin.js file and compressed correctly.\n\t\t * @param pluginName {String} name of the plugin to load scripts from (will be used to get the base url for the plugins).\n\t\t * @param scripts {Array} Array containing the names of the scripts to load.\n\t \t */\n\t\taddComponents: function(pluginName, scripts) {\n\t\t\tvar pluginUrl = this.urls[pluginName];\n\t\t\ttinymce.each(scripts, function(script){\n\t\t\t\ttinymce.ScriptLoader.add(pluginUrl+\"/\"+script);\t\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Loads an add-on from a specific url.\n\t\t *\n\t\t * @method load\n\t\t * @param {String} n Short name of the add-on that gets loaded.\n\t\t * @param {String} u URL to the add-on that will get loaded.\n\t\t * @param {function} cb Optional callback to execute ones the add-on is loaded.\n\t\t * @param {Object} s Optional scope to execute the callback in.\n\t\t * @example\n\t\t * // Loads a plugin from an external URL\n\t\t * tinymce.PluginManager.load('myplugin', '/some/dir/someplugin/editor_plugin.js');\n\t\t *\n\t\t * // Initialize TinyMCE\n\t\t * tinyMCE.init({\n\t\t *    ...\n\t\t *    plugins : '-myplugin' // Don't try to load it again\n\t\t * });\n\t\t */\n\t\tload : function(n, u, cb, s) {\n\t\t\tvar t = this, url = u;\n\n\t\t\tfunction loadDependencies() {\n\t\t\t\tvar dependencies = t.dependencies(n);\n\t\t\t\ttinymce.each(dependencies, function(dep) {\n\t\t\t\t\tvar newUrl = t.createUrl(u, dep);\n\t\t\t\t\tt.load(newUrl.resource, newUrl, undefined, undefined);\n\t\t\t\t});\n\t\t\t\tif (cb) {\n\t\t\t\t\tif (s) {\n\t\t\t\t\t\tcb.call(s);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tcb.call(tinymce.ScriptLoader);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (t.urls[n])\n\t\t\t\treturn;\n\t\t\tif (typeof u === \"object\")\n\t\t\t\turl = u.prefix + u.resource + u.suffix;\n\n\t\t\tif (url.indexOf('/') != 0 && url.indexOf('://') == -1)\n\t\t\t\turl = tinymce.baseURL + '/' + url;\n\n\t\t\tt.urls[n] = url.substring(0, url.lastIndexOf('/'));\n\n\t\t\tif (t.lookup[n]) {\n\t\t\t\tloadDependencies();\n\t\t\t} else {\n\t\t\t\ttinymce.ScriptLoader.add(url, loadDependencies, s);\n\t\t\t}\n\t\t}\n\t});\n\n\t// Create plugin and theme managers\n\ttinymce.PluginManager = new tinymce.AddOnManager();\n\ttinymce.ThemeManager = new tinymce.AddOnManager();\n}(tinymce));\n\n/**\n * TinyMCE theme class.\n *\n * @class tinymce.Theme\n */\n\n/**\n * Initializes the theme.\n *\n * @method init\n * @param {tinymce.Editor} editor Editor instance that created the theme instance.\n * @param {String} url Absolute URL where the theme is located. \n */\n\n/**\n * Meta info method, this method gets executed when TinyMCE wants to present information about the theme for example in the about/help dialog.\n *\n * @method getInfo\n * @return {Object} Returns an object with meta information about the theme the current items are longname, author, authorurl, infourl and version.\n */\n\n/**\n * This method is responsible for rendering/generating the overall user interface with toolbars, buttons, iframe containers etc.\n *\n * @method renderUI\n * @param {Object} obj Object parameter containing the targetNode DOM node that will be replaced visually with an editor instance. \n * @return {Object} an object with items like iframeContainer, editorContainer, sizeContainer, deltaWidth, deltaHeight. \n */\n\n/**\n * Plugin base class, this is a pseudo class that describes how a plugin is to be created for TinyMCE. The methods below are all optional.\n *\n * @class tinymce.Plugin\n * @example\n * // Create a new plugin class\n * tinymce.create('tinymce.plugins.ExamplePlugin', {\n *     init : function(ed, url) {\n *         // Register an example button\n *         ed.addButton('example', {\n *             title : 'example.desc',\n *             onclick : function() {\n *                  // Display an alert when the user clicks the button\n *                  ed.windowManager.alert('Hello world!');\n *             },\n *             'class' : 'bold' // Use the bold icon from the theme\n *         });\n *     }\n * });\n * \n * // Register plugin with a short name\n * tinymce.PluginManager.add('example', tinymce.plugins.ExamplePlugin);\n * \n * // Initialize TinyMCE with the new plugin and button\n * tinyMCE.init({\n *    ...\n *    plugins : '-example', // - means TinyMCE will not try to load it\n *    theme_advanced_buttons1 : 'example' // Add the new example button to the toolbar\n * });\n */\n\n/**\n * Initialization function for the plugin. This will be called when the plugin is created. \n *\n * @method init\n * @param {tinymce.Editor} editor Editor instance that created the plugin instance. \n * @param {String} url Absolute URL where the plugin is located. \n * @example\n * // Creates a new plugin class\n * tinymce.create('tinymce.plugins.ExamplePlugin', {\n *     init : function(ed, url) {\n *         // Register the command so that it can be invoked by using tinyMCE.activeEditor.execCommand('mceExample');\n *         ed.addCommand('mceExample', function() {\n *             ed.windowManager.open({\n *                 file : url + '/dialog.htm',\n *                 width : 320 + ed.getLang('example.delta_width', 0),\n *                 height : 120 + ed.getLang('example.delta_height', 0),\n *                 inline : 1\n *             }, {\n *                 plugin_url : url, // Plugin absolute URL\n *                 some_custom_arg : 'custom arg' // Custom argument\n *             });\n *         });\n * \n *         // Register example button\n *         ed.addButton('example', {\n *             title : 'example.desc',\n *             cmd : 'mceExample',\n *             image : url + '/img/example.gif'\n *         });\n * \n *         // Add a node change handler, selects the button in the UI when a image is selected\n *         ed.onNodeChange.add(function(ed, cm, n) {\n *             cm.setActive('example', n.nodeName == 'IMG');\n *         });\n *     }\n * });\n * \n * // Register plugin\n * tinymce.PluginManager.add('example', tinymce.plugins.ExamplePlugin);\n */\n\n/**\n * Meta info method, this method gets executed when TinyMCE wants to present information about the plugin for example in the about/help dialog.\n *\n * @method getInfo\n * @return {Object} Returns an object with meta information about the plugin the current items are longname, author, authorurl, infourl and version.\n * @example \n * // Creates a new plugin class\n * tinymce.create('tinymce.plugins.ExamplePlugin', {\n *     // Meta info method\n *     getInfo : function() {\n *         return {\n *             longname : 'Example plugin',\n *             author : 'Some author',\n *             authorurl : 'http://tinymce.moxiecode.com',\n *             infourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/example',\n *             version : \"1.0\"\n *         };\n *     }\n * });\n * \n * // Register plugin\n * tinymce.PluginManager.add('example', tinymce.plugins.ExamplePlugin);\n * \n * // Initialize TinyMCE with the new plugin\n * tinyMCE.init({\n *    ...\n *    plugins : '-example' // - means TinyMCE will not try to load it\n * });\n */\n\n/**\n * Gets called when a new control instance is created.\n *\n * @method createControl\n * @param {String} name Control name to create for example \"mylistbox\" \n * @param {tinymce.ControlManager} controlman Control manager/factory to use to create the control. \n * @return {tinymce.ui.Control} Returns a new control instance or null.\n * @example \n * // Creates a new plugin class\n * tinymce.create('tinymce.plugins.ExamplePlugin', {\n *     createControl: function(n, cm) {\n *         switch (n) {\n *             case 'mylistbox':\n *                 var mlb = cm.createListBox('mylistbox', {\n *                      title : 'My list box',\n *                      onselect : function(v) {\n *                          tinyMCE.activeEditor.windowManager.alert('Value selected:' + v);\n *                      }\n *                 });\n * \n *                 // Add some values to the list box\n *                 mlb.add('Some item 1', 'val1');\n *                 mlb.add('some item 2', 'val2');\n *                 mlb.add('some item 3', 'val3');\n * \n *                 // Return the new listbox instance\n *                 return mlb;\n *         }\n * \n *         return null;\n *     }\n * });\n * \n * // Register plugin\n * tinymce.PluginManager.add('example', tinymce.plugins.ExamplePlugin);\n * \n * // Initialize TinyMCE with the new plugin and button\n * tinyMCE.init({\n *    ...\n *    plugins : '-example', // - means TinyMCE will not try to load it\n *    theme_advanced_buttons1 : 'mylistbox' // Add the new mylistbox control to the toolbar\n * });\n */\n","Magento_Tinymce3/tiny_mce/classes/Popup.js":"/**\n * Popup.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n// Some global instances\nvar tinymce = null, tinyMCEPopup, tinyMCE;\n\n/**\n * TinyMCE popup/dialog helper class. This gives you easy access to the\n * parent editor instance and a bunch of other things. It's higly recommended\n * that you load this script into your dialogs.\n *\n * @static\n * @class tinyMCEPopup\n */\ntinyMCEPopup = {\n\t/**\n\t * Initializes the popup this will be called automatically.\n\t *\n\t * @method init\n\t */\n\tinit : function() {\n\t\tvar t = this, w, ti;\n\n\t\t// Find window & API\n\t\tw = t.getWin();\n\t\ttinymce = w.tinymce;\n\t\ttinyMCE = w.tinyMCE;\n\t\tt.editor = tinymce.EditorManager.activeEditor;\n\t\tt.params = t.editor.windowManager.params;\n\t\tt.features = t.editor.windowManager.features;\n\n\t\t// Setup local DOM\n\t\tt.dom = t.editor.windowManager.createInstance('tinymce.dom.DOMUtils', document);\n\n\t\t// Enables you to skip loading the default css\n\t\tif (t.features.popup_css !== false)\n\t\t\tt.dom.loadCSS(t.features.popup_css || t.editor.settings.popup_css);\n\n\t\t// Setup on init listeners\n\t\tt.listeners = [];\n\n\t\t/**\n\t\t * Fires when the popup is initialized.\n\t\t *\n\t\t * @event onInit\n\t\t * @param {tinymce.Editor} editor Editor instance.\n\t\t * @example\n\t\t * // Alerts the selected contents when the dialog is loaded\n\t\t * tinyMCEPopup.onInit.add(function(ed) {\n\t\t *     alert(ed.selection.getContent());\n\t\t * });\n\t\t *\n\t\t * // Executes the init method on page load in some object using the SomeObject scope\n\t\t * tinyMCEPopup.onInit.add(SomeObject.init, SomeObject);\n\t\t */\n\t\tt.onInit = {\n\t\t\tadd : function(f, s) {\n\t\t\t\tt.listeners.push({func : f, scope : s});\n\t\t\t}\n\t\t};\n\n\t\tt.isWindow = !t.getWindowArg('mce_inline');\n\t\tt.id = t.getWindowArg('mce_window_id');\n\t\tt.editor.windowManager.onOpen.dispatch(t.editor.windowManager, window);\n\t},\n\n\t/**\n\t * Returns the reference to the parent window that opened the dialog.\n\t *\n\t * @method getWin\n\t * @return {Window} Reference to the parent window that opened the dialog.\n\t */\n\tgetWin : function() {\n\t\t// Added frameElement check to fix bug: #2817583\n\t\treturn (!window.frameElement && window.dialogArguments) || opener || parent || top;\n\t},\n\n\t/**\n\t * Returns a window argument/parameter by name.\n\t *\n\t * @method getWindowArg\n\t * @param {String} n Name of the window argument to retrieve.\n\t * @param {String} dv Optional default value to return.\n\t * @return {String} Argument value or default value if it wasn't found.\n\t */\n\tgetWindowArg : function(n, dv) {\n\t\tvar v = this.params[n];\n\n\t\treturn tinymce.is(v) ? v : dv;\n\t},\n\n\t/**\n\t * Returns a editor parameter/config option value.\n\t *\n\t * @method getParam\n\t * @param {String} n Name of the editor config option to retrieve.\n\t * @param {String} dv Optional default value to return.\n\t * @return {String} Parameter value or default value if it wasn't found.\n\t */\n\tgetParam : function(n, dv) {\n\t\treturn this.editor.getParam(n, dv);\n\t},\n\n\t/**\n\t * Returns a language item by key.\n\t *\n\t * @method getLang\n\t * @param {String} n Language item like mydialog.something.\n\t * @param {String} dv Optional default value to return.\n\t * @return {String} Language value for the item like \"my string\" or the default value if it wasn't found.\n\t */\n\tgetLang : function(n, dv) {\n\t\treturn this.editor.getLang(n, dv);\n\t},\n\n\t/**\n\t * Executed a command on editor that opened the dialog/popup.\n\t *\n\t * @method execCommand\n\t * @param {String} cmd Command to execute.\n\t * @param {Boolean} ui Optional boolean value if the UI for the command should be presented or not.\n\t * @param {Object} val Optional value to pass with the comman like an URL.\n\t * @param {Object} a Optional arguments object.\n\t */\n\texecCommand : function(cmd, ui, val, a) {\n\t\ta = a || {};\n\t\ta.skip_focus = 1;\n\n\t\tthis.restoreSelection();\n\t\treturn this.editor.execCommand(cmd, ui, val, a);\n\t},\n\n\t/**\n\t * Resizes the dialog to the inner size of the window. This is needed since various browsers\n\t * have different border sizes on windows.\n\t *\n\t * @method resizeToInnerSize\n\t */\n\tresizeToInnerSize : function() {\n\t\tvar t = this;\n\n\t\t// Detach it to workaround a Chrome specific bug\n\t\t// https://sourceforge.net/tracker/?func=detail&atid=635682&aid=2926339&group_id=103281\n\t\tsetTimeout(function() {\n\t\t\tvar vp = t.dom.getViewPort(window);\n\n\t\t\tt.editor.windowManager.resizeBy(\n\t\t\t\tt.getWindowArg('mce_width') - vp.w,\n\t\t\t\tt.getWindowArg('mce_height') - vp.h,\n\t\t\t\tt.id || window\n\t\t\t);\n\t\t}, 10);\n\t},\n\n\t/**\n\t * Will executed the specified string when the page has been loaded. This function\n\t * was added for compatibility with the 2.x branch.\n\t *\n\t * @method executeOnLoad\n\t * @param {String} s String to evalutate on init.\n\t */\n\texecuteOnLoad : function(s) {\n\t\tthis.onInit.add(function() {\n\t\t\teval(s);\n\t\t});\n\t},\n\n\t/**\n\t * Stores the current editor selection for later restoration. This can be useful since some browsers\n\t * looses it's selection if a control element is selected/focused inside the dialogs.\n\t *\n\t * @method storeSelection\n\t */\n\tstoreSelection : function() {\n\t\tthis.editor.windowManager.bookmark = tinyMCEPopup.editor.selection.getBookmark(1);\n\t},\n\n\t/**\n\t * Restores any stored selection. This can be useful since some browsers\n\t * looses it's selection if a control element is selected/focused inside the dialogs.\n\t *\n\t * @method restoreSelection\n\t */\n\trestoreSelection : function() {\n\t\tvar t = tinyMCEPopup;\n\n\t\tif (!t.isWindow && tinymce.isIE)\n\t\t\tt.editor.selection.moveToBookmark(t.editor.windowManager.bookmark);\n\t},\n\n\t/**\n\t * Loads a specific dialog language pack. If you pass in plugin_url as a arugment\n\t * when you open the window it will load the <plugin url>/langs/<code>_dlg.js lang pack file.\n\t *\n\t * @method requireLangPack\n\t */\n\trequireLangPack : function() {\n\t\tvar t = this, u = t.getWindowArg('plugin_url') || t.getWindowArg('theme_url');\n\n\t\tif (u && t.editor.settings.language && t.features.translate_i18n !== false && t.editor.settings.language_load !== false) {\n\t\t\tu += '/langs/' + t.editor.settings.language + '_dlg.js';\n\n\t\t\tif (!tinymce.ScriptLoader.isDone(u)) {\n\t\t\t\tdocument.write('<script type=\"text/javascript\" src=\"' + tinymce._addVer(u) + '\"></script>');\n\t\t\t\ttinymce.ScriptLoader.markDone(u);\n\t\t\t}\n\t\t}\n\t},\n\n\t/**\n\t * Executes a color picker on the specified element id. When the user\n\t * then selects a color it will be set as the value of the specified element.\n\t *\n\t * @method pickColor\n\t * @param {DOMEvent} e DOM event object.\n\t * @param {string} element_id Element id to be filled with the color value from the picker.\n\t */\n\tpickColor : function(e, element_id) {\n\t\tthis.execCommand('mceColorPicker', true, {\n\t\t\tcolor : document.getElementById(element_id).value,\n\t\t\tfunc : function(c) {\n\t\t\t\tdocument.getElementById(element_id).value = c;\n\n\t\t\t\ttry {\n\t\t\t\t\tdocument.getElementById(element_id).onchange();\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Try fire event, ignore errors\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t},\n\n\t/**\n\t * Opens a filebrowser/imagebrowser this will set the output value from\n\t * the browser as a value on the specified element.\n\t *\n\t * @method openBrowser\n\t * @param {string} element_id Id of the element to set value in.\n\t * @param {string} type Type of browser to open image/file/flash.\n\t * @param {string} option Option name to get the file_broswer_callback function name from.\n\t */\n\topenBrowser : function(element_id, type, option) {\n\t\ttinyMCEPopup.restoreSelection();\n\t\tthis.editor.execCallback('file_browser_callback', element_id, document.getElementById(element_id).value, type, window);\n\t},\n\n\t/**\n\t * Creates a confirm dialog. Please don't use the blocking behavior of this\n\t * native version use the callback method instead then it can be extended.\n\t *\n\t * @method confirm\n\t * @param {String} t Title for the new confirm dialog.\n\t * @param {function} cb Callback function to be executed after the user has selected ok or cancel.\n\t * @param {Object} s Optional scope to execute the callback in.\n\t */\n\tconfirm : function(t, cb, s) {\n\t\tthis.editor.windowManager.confirm(t, cb, s, window);\n\t},\n\n\t/**\n\t * Creates a alert dialog. Please don't use the blocking behavior of this\n\t * native version use the callback method instead then it can be extended.\n\t *\n\t * @method alert\n\t * @param {String} t Title for the new alert dialog.\n\t * @param {function} cb Callback function to be executed after the user has selected ok.\n\t * @param {Object} s Optional scope to execute the callback in.\n\t */\n\talert : function(tx, cb, s) {\n\t\tthis.editor.windowManager.alert(tx, cb, s, window);\n\t},\n\n\t/**\n\t * Closes the current window.\n\t *\n\t * @method close\n\t */\n\tclose : function() {\n\t\tvar t = this;\n\n\t\t// To avoid domain relaxing issue in Opera\n\t\tfunction close() {\n\t\t\tt.editor.windowManager.close(window);\n\t\t\ttinymce = tinyMCE = t.editor = t.params = t.dom = t.dom.doc = null; // Cleanup\n\t\t};\n\n\t\tif (tinymce.isOpera)\n\t\t\tt.getWin().setTimeout(close, 0);\n\t\telse\n\t\t\tclose();\n\t},\n\n\t// Internal functions\n\n\t_restoreSelection : function() {\n\t\tvar e = window.event.srcElement;\n\n\t\tif (e.nodeName == 'INPUT' && (e.type == 'submit' || e.type == 'button'))\n\t\t\ttinyMCEPopup.restoreSelection();\n\t},\n\n/*\t_restoreSelection : function() {\n\t\tvar e = window.event.srcElement;\n\n\t\t// If user focus a non text input or textarea\n\t\tif ((e.nodeName != 'INPUT' && e.nodeName != 'TEXTAREA') || e.type != 'text')\n\t\t\ttinyMCEPopup.restoreSelection();\n\t},*/\n\n\t_onDOMLoaded : function() {\n\t\tvar t = tinyMCEPopup, ti = document.title, bm, h, nv;\n\n\t\tif (t.domLoaded)\n\t\t\treturn;\n\n\t\tt.domLoaded = 1;\n\n\t\t// Translate page\n\t\tif (t.features.translate_i18n !== false) {\n\t\t\th = document.body.innerHTML;\n\n\t\t\t// Replace a=x with a=\"x\" in IE\n\t\t\tif (tinymce.isIE)\n\t\t\t\th = h.replace(/ (value|title|alt)=([^\"][^\\s>]+)/gi, ' $1=\"$2\"')\n\n\t\t\tdocument.dir = t.editor.getParam('directionality','');\n\n\t\t\tif ((nv = t.editor.translate(h)) && nv != h)\n\t\t\t\tdocument.body.innerHTML = nv;\n\n\t\t\tif ((nv = t.editor.translate(ti)) && nv != ti)\n\t\t\t\tdocument.title = ti = nv;\n\t\t}\n\n\t\tif (!t.editor.getParam('browser_preferred_colors', false) || !t.isWindow)\n\t\t\tt.dom.addClass(document.body, 'forceColors');\n\n\t\tdocument.body.style.display = '';\n\n\t\t// Restore selection in IE when focus is placed on a non textarea or input element of the type text\n\t\tif (tinymce.isIE) {\n\t\t\tdocument.attachEvent('onmouseup', tinyMCEPopup._restoreSelection);\n\n\t\t\t// Add base target element for it since it would fail with modal dialogs\n\t\t\tt.dom.add(t.dom.select('head')[0], 'base', {target : '_self'});\n\t\t}\n\n\t\tt.restoreSelection();\n\t\tt.resizeToInnerSize();\n\n\t\t// Set inline title\n\t\tif (!t.isWindow)\n\t\t\tt.editor.windowManager.setTitle(window, ti);\n\t\telse\n\t\t\twindow.focus();\n\n\t\tif (!tinymce.isIE && !t.isWindow) {\n\t\t\ttinymce.dom.Event._add(document, 'focus', function() {\n\t\t\t\tt.editor.windowManager.focus(t.id);\n\t\t\t});\n\t\t}\n\n\t\t// Patch for accessibility\n\t\ttinymce.each(t.dom.select('select'), function(e) {\n\t\t\te.onkeydown = tinyMCEPopup._accessHandler;\n\t\t});\n\n\t\t// Call onInit\n\t\t// Init must be called before focus so the selection won't get lost by the focus call\n\t\ttinymce.each(t.listeners, function(o) {\n\t\t\to.func.call(o.scope, t.editor);\n\t\t});\n\n\t\t// Move focus to window\n\t\tif (t.getWindowArg('mce_auto_focus', true)) {\n\t\t\twindow.focus();\n\n\t\t\t// Focus element with mceFocus class\n\t\t\ttinymce.each(document.forms, function(f) {\n\t\t\t\ttinymce.each(f.elements, function(e) {\n\t\t\t\t\tif (t.dom.hasClass(e, 'mceFocus') && !e.disabled) {\n\t\t\t\t\t\te.focus();\n\t\t\t\t\t\treturn false; // Break loop\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t});\n\t\t}\n\n\t\tdocument.onkeyup = tinyMCEPopup._closeWinKeyHandler;\n\t},\n\n\t_accessHandler : function(e) {\n\t\te = e || window.event;\n\n\t\tif (e.keyCode == 13 || e.keyCode == 32) {\n\t\t\te = e.target || e.srcElement;\n\n\t\t\tif (e.onchange)\n\t\t\t\te.onchange();\n\n\t\t\treturn tinymce.dom.Event.cancel(e);\n\t\t}\n\t},\n\n\t_closeWinKeyHandler : function(e) {\n\t\te = e || window.event;\n\n\t\tif (e.keyCode == 27)\n\t\t\ttinyMCEPopup.close();\n\t},\n\n\t_wait : function() {\n\t\t// Use IE method\n\t\tif (document.attachEvent) {\n\t\t\tdocument.attachEvent(\"onreadystatechange\", function() {\n\t\t\t\tif (document.readyState === \"complete\") {\n\t\t\t\t\tdocument.detachEvent(\"onreadystatechange\", arguments.callee);\n\t\t\t\t\ttinyMCEPopup._onDOMLoaded();\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tif (document.documentElement.doScroll && window == window.top) {\n\t\t\t\t(function() {\n\t\t\t\t\tif (tinyMCEPopup.domLoaded)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\t// If IE is used, use the trick by Diego Perini licensed under MIT by request to the author.\n\t\t\t\t\t\t// http://javascript.nwbox.com/IEContentLoaded/\n\t\t\t\t\t\tdocument.documentElement.doScroll(\"left\");\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\tsetTimeout(arguments.callee, 0);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\ttinyMCEPopup._onDOMLoaded();\n\t\t\t\t})();\n\t\t\t}\n\n\t\t\tdocument.attachEvent('onload', tinyMCEPopup._onDOMLoaded);\n\t\t} else if (document.addEventListener) {\n\t\t\twindow.addEventListener('DOMContentLoaded', tinyMCEPopup._onDOMLoaded, false);\n\t\t\twindow.addEventListener('load', tinyMCEPopup._onDOMLoaded, false);\n\t\t}\n\t}\n};\n\ntinyMCEPopup.init();\ntinyMCEPopup._wait(); // Wait for DOM Content Loaded\n","Magento_Tinymce3/tiny_mce/classes/LegacyInput.js":"/**\n * LegacyInput.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\ntinymce.onAddEditor.add(function(tinymce, ed) {\n\tvar filters, fontSizes, dom, settings = ed.settings;\n\n\tif (settings.inline_styles) {\n\t\tfontSizes = tinymce.explode(settings.font_size_legacy_values);\n\n\t\tfunction replaceWithSpan(node, styles) {\n\t\t\ttinymce.each(styles, function(value, name) {\n\t\t\t\tif (value)\n\t\t\t\t\tdom.setStyle(node, name, value);\n\t\t\t});\n\n\t\t\tdom.rename(node, 'span');\n\t\t};\n\n\t\tfilters = {\n\t\t\tfont : function(dom, node) {\n\t\t\t\treplaceWithSpan(node, {\n\t\t\t\t\tbackgroundColor : node.style.backgroundColor,\n\t\t\t\t\tcolor : node.color,\n\t\t\t\t\tfontFamily : node.face,\n\t\t\t\t\tfontSize : fontSizes[parseInt(node.size) - 1]\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tu : function(dom, node) {\n\t\t\t\treplaceWithSpan(node, {\n\t\t\t\t\ttextDecoration : 'underline'\n\t\t\t\t});\n\t\t\t},\n\n\t\t\tstrike : function(dom, node) {\n\t\t\t\treplaceWithSpan(node, {\n\t\t\t\t\ttextDecoration : 'line-through'\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\tfunction convert(editor, params) {\n\t\t\tdom = editor.dom;\n\n\t\t\tif (settings.convert_fonts_to_spans) {\n\t\t\t\ttinymce.each(dom.select('font,u,strike', params.node), function(node) {\n\t\t\t\t\tfilters[node.nodeName.toLowerCase()](ed.dom, node);\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\ted.onPreProcess.add(convert);\n\t\ted.onSetContent.add(convert);\n\n\t\ted.onInit.add(function() {\n\t\t\ted.selection.onSetContent.add(convert);\n\t\t});\n\t}\n});\n","Magento_Tinymce3/tiny_mce/classes/UndoManager.js":"/**\n * UndoManager.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\tvar Dispatcher = tinymce.util.Dispatcher;\n\n\t/**\n\t * This class handles the undo/redo history levels for the editor. Since the build in undo/redo has major drawbacks a custom one was needed.\n\t *\n\t * @class tinymce.UndoManager\n\t */\n\ttinymce.UndoManager = function(editor) {\n\t\tvar self, index = 0, data = [], beforeBookmark;\n\n\t\tfunction getContent() {\n\t\t\treturn tinymce.trim(editor.getContent({format : 'raw', no_events : 1}));\n\t\t};\n\n\t\treturn self = {\n\t\t\t/**\n\t\t\t * State if the user is currently typing or not. This will add a typing operation into one undo\n\t\t\t * level instead of one new level for each keystroke.\n\t\t\t *\n\t\t\t * @field {Boolean} typing\n\t\t\t */\n\t\t\ttyping : false,\n\n\t\t\t/**\n\t\t\t * This event will fire each time a new undo level is added to the undo manager.\n\t\t\t *\n\t\t\t * @event onAdd\n\t\t\t * @param {tinymce.UndoManager} sender UndoManager instance that got the new level.\n\t\t\t * @param {Object} level The new level object containing a bookmark and contents.\n\t\t\t */\n\t\t\tonAdd : new Dispatcher(self),\n\n\t\t\t/**\n\t\t\t * This event will fire when the user make an undo of a change.\n\t\t\t *\n\t\t\t * @event onUndo\n\t\t\t * @param {tinymce.UndoManager} sender UndoManager instance that got the new level.\n\t\t\t * @param {Object} level The old level object containing a bookmark and contents.\n\t\t\t */\n\t\t\tonUndo : new Dispatcher(self),\n\n\t\t\t/**\n\t\t\t * This event will fire when the user make an redo of a change.\n\t\t\t *\n\t\t\t * @event onRedo\n\t\t\t * @param {tinymce.UndoManager} sender UndoManager instance that got the new level.\n\t\t\t * @param {Object} level The old level object containing a bookmark and contents.\n\t\t\t */\n\t\t\tonRedo : new Dispatcher(self),\n\n\t\t\t/**\n\t\t\t * Stores away a bookmark to be used when performing an undo action so that the selection is before\n\t\t\t * the change has been made.\n\t\t\t *\n\t\t\t * @method beforeChange\n\t\t\t */\n\t\t\tbeforeChange : function() {\n\t\t\t\tbeforeBookmark = editor.selection.getBookmark(2, true);\n\t\t\t},\n\n\t\t\t/**\n\t\t\t * Adds a new undo level/snapshot to the undo list.\n\t\t\t *\n\t\t\t * @method add\n\t\t\t * @param {Object} l Optional undo level object to add.\n\t\t\t * @return {Object} Undo level that got added or null it a level wasn't needed.\n\t\t\t */\n\t\t\tadd : function(level) {\n\t\t\t\tvar i, settings = editor.settings, lastLevel;\n\n\t\t\t\tlevel = level || {};\n\t\t\t\tlevel.content = getContent();\n\n\t\t\t\t// Add undo level if needed\n\t\t\t\tlastLevel = data[index];\n\t\t\t\tif (lastLevel && lastLevel.content == level.content)\n\t\t\t\t\treturn null;\n\n\t\t\t\t// Set before bookmark on previous level\n\t\t\t\tif (data[index])\n\t\t\t\t\tdata[index].beforeBookmark = beforeBookmark;\n\n\t\t\t\t// Time to compress\n\t\t\t\tif (settings.custom_undo_redo_levels) {\n\t\t\t\t\tif (data.length > settings.custom_undo_redo_levels) {\n\t\t\t\t\t\tfor (i = 0; i < data.length - 1; i++)\n\t\t\t\t\t\t\tdata[i] = data[i + 1];\n\n\t\t\t\t\t\tdata.length--;\n\t\t\t\t\t\tindex = data.length;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Get a non intrusive normalized bookmark\n\t\t\t\tlevel.bookmark = editor.selection.getBookmark(2, true);\n\n\t\t\t\t// Crop array if needed\n\t\t\t\tif (index < data.length - 1)\n\t\t\t\t\tdata.length = index + 1;\n\n\t\t\t\tdata.push(level);\n\t\t\t\tindex = data.length - 1;\n\n\t\t\t\tself.onAdd.dispatch(self, level);\n\t\t\t\teditor.isNotDirty = 0;\n\n\t\t\t\treturn level;\n\t\t\t},\n\n\t\t\t/**\n\t\t\t * Undoes the last action.\n\t\t\t *\n\t\t\t * @method undo\n\t\t\t * @return {Object} Undo level or null if no undo was performed.\n\t\t\t */\n\t\t\tundo : function() {\n\t\t\t\tvar level, i;\n\n\t\t\t\tif (self.typing) {\n\t\t\t\t\tself.add();\n\t\t\t\t\tself.typing = false;\n\t\t\t\t}\n\n\t\t\t\tif (index > 0) {\n\t\t\t\t\tlevel = data[--index];\n\n\t\t\t\t\teditor.setContent(level.content, {format : 'raw'});\n\t\t\t\t\teditor.selection.moveToBookmark(level.beforeBookmark);\n\n\t\t\t\t\tself.onUndo.dispatch(self, level);\n\t\t\t\t}\n\n\t\t\t\treturn level;\n\t\t\t},\n\n\t\t\t/**\n\t\t\t * Redoes the last action.\n\t\t\t *\n\t\t\t * @method redo\n\t\t\t * @return {Object} Redo level or null if no redo was performed.\n\t\t\t */\n\t\t\tredo : function() {\n\t\t\t\tvar level;\n\n\t\t\t\tif (index < data.length - 1) {\n\t\t\t\t\tlevel = data[++index];\n\n\t\t\t\t\teditor.setContent(level.content, {format : 'raw'});\n\t\t\t\t\teditor.selection.moveToBookmark(level.bookmark);\n\n\t\t\t\t\tself.onRedo.dispatch(self, level);\n\t\t\t\t}\n\n\t\t\t\treturn level;\n\t\t\t},\n\n\t\t\t/**\n\t\t\t * Removes all undo levels.\n\t\t\t *\n\t\t\t * @method clear\n\t\t\t */\n\t\t\tclear : function() {\n\t\t\t\tdata = [];\n\t\t\t\tindex = 0;\n\t\t\t\tself.typing = false;\n\t\t\t},\n\n\t\t\t/**\n\t\t\t * Returns true/false if the undo manager has any undo levels.\n\t\t\t *\n\t\t\t * @method hasUndo\n\t\t\t * @return {Boolean} true/false if the undo manager has any undo levels.\n\t\t\t */\n\t\t\thasUndo : function() {\n\t\t\t\treturn index > 0 || this.typing;\n\t\t\t},\n\n\t\t\t/**\n\t\t\t * Returns true/false if the undo manager has any redo levels.\n\t\t\t *\n\t\t\t * @method hasRedo\n\t\t\t * @return {Boolean} true/false if the undo manager has any redo levels.\n\t\t\t */\n\t\t\thasRedo : function() {\n\t\t\t\treturn index < data.length - 1 && !this.typing;\n\t\t\t}\n\t\t};\n\t};\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/ForceBlocks.js":"/**\n * ForceBlocks.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\t// Shorten names\n\tvar Event = tinymce.dom.Event,\n\t\tisIE = tinymce.isIE,\n\t\tisGecko = tinymce.isGecko,\n\t\tisOpera = tinymce.isOpera,\n\t\teach = tinymce.each,\n\t\textend = tinymce.extend,\n\t\tTRUE = true,\n\t\tFALSE = false;\n\n\tfunction cloneFormats(node) {\n\t\tvar clone, temp, inner;\n\n\t\tdo {\n\t\t\tif (/^(SPAN|STRONG|B|EM|I|FONT|STRIKE|U)$/.test(node.nodeName)) {\n\t\t\t\tif (clone) {\n\t\t\t\t\ttemp = node.cloneNode(false);\n\t\t\t\t\ttemp.appendChild(clone);\n\t\t\t\t\tclone = temp;\n\t\t\t\t} else {\n\t\t\t\t\tclone = inner = node.cloneNode(false);\n\t\t\t\t}\n\n\t\t\t\tclone.removeAttribute('id');\n\t\t\t}\n\t\t} while (node = node.parentNode);\n\n\t\tif (clone)\n\t\t\treturn {wrapper : clone, inner : inner};\n\t};\n\n\t// Checks if the selection/caret is at the end of the specified block element\n\tfunction isAtEnd(rng, par) {\n\t\tvar rng2 = par.ownerDocument.createRange();\n\n\t\trng2.setStart(rng.endContainer, rng.endOffset);\n\t\trng2.setEndAfter(par);\n\n\t\t// Get number of characters to the right of the cursor if it's zero then we are at the end and need to merge the next block element\n\t\treturn rng2.cloneContents().textContent.length == 0;\n\t};\n\n\tfunction splitList(selection, dom, li) {\n\t\tvar listBlock, block;\n\n\t\tif (dom.isEmpty(li)) {\n\t\t\tlistBlock = dom.getParent(li, 'ul,ol');\n\n\t\t\tif (!dom.getParent(listBlock.parentNode, 'ul,ol')) {\n\t\t\t\tdom.split(listBlock, li);\n\t\t\t\tblock = dom.create('p', 0, '<br data-mce-bogus=\"1\" />');\n\t\t\t\tdom.replace(block, li);\n\t\t\t\tselection.select(block, 1);\n\t\t\t}\n\n\t\t\treturn FALSE;\n\t\t}\n\n\t\treturn TRUE;\n\t};\n\n\t/**\n\t * This is a internal class and no method in this class should be called directly form the out side.\n\t */\n\ttinymce.create('tinymce.ForceBlocks', {\n\t\tForceBlocks : function(ed) {\n\t\t\tvar t = this, s = ed.settings, elm;\n\n\t\t\tt.editor = ed;\n\t\t\tt.dom = ed.dom;\n\t\t\telm = (s.forced_root_block || 'p').toLowerCase();\n\t\t\ts.element = elm.toUpperCase();\n\n\t\t\ted.onPreInit.add(t.setup, t);\n\t\t},\n\n\t\tsetup : function() {\n\t\t\tvar t = this, ed = t.editor, s = ed.settings, dom = ed.dom, selection = ed.selection, blockElements = ed.schema.getBlockElements();\n\n\t\t\t// Force root blocks\n\t\t\tif (s.forced_root_block) {\n\t\t\t\tfunction addRootBlocks() {\n\t\t\t\t\tvar node = selection.getStart(), rootNode = ed.getBody(), rng, startContainer, startOffset, endContainer, endOffset, rootBlockNode, tempNode, offset = -0xFFFFFF;\n\n\t\t\t\t\tif (!node || node.nodeType !== 1)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Check if node is wrapped in block\n\t\t\t\t\twhile (node != rootNode) {\n\t\t\t\t\t\tif (blockElements[node.nodeName])\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Get current selection\n\t\t\t\t\trng = selection.getRng();\n\t\t\t\t\tif (rng.setStart) {\n\t\t\t\t\t\tstartContainer = rng.startContainer;\n\t\t\t\t\t\tstartOffset = rng.startOffset;\n\t\t\t\t\t\tendContainer = rng.endContainer;\n\t\t\t\t\t\tendOffset = rng.endOffset;\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Force control range into text range\n\t\t\t\t\t\tif (rng.item) {\n\t\t\t\t\t\t\trng = ed.getDoc().body.createTextRange();\n\t\t\t\t\t\t\trng.moveToElementText(rng.item(0));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\ttmpRng = rng.duplicate();\n\t\t\t\t\t\ttmpRng.collapse(true);\n\t\t\t\t\t\tstartOffset = tmpRng.move('character', offset) * -1;\n\n\t\t\t\t\t\tif (!tmpRng.collapsed) {\n\t\t\t\t\t\t\ttmpRng = rng.duplicate();\n\t\t\t\t\t\t\ttmpRng.collapse(false);\n\t\t\t\t\t\t\tendOffset = (tmpRng.move('character', offset) * -1) - startOffset;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Wrap non block elements and text nodes\n\t\t\t\t\tfor (node = rootNode.firstChild; node; node) {\n\t\t\t\t\t\tif (node.nodeType === 3 || (node.nodeType == 1 && !blockElements[node.nodeName])) {\n\t\t\t\t\t\t\tif (!rootBlockNode) {\n\t\t\t\t\t\t\t\trootBlockNode = dom.create(s.forced_root_block);\n\t\t\t\t\t\t\t\tnode.parentNode.insertBefore(rootBlockNode, node);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\ttempNode = node;\n\t\t\t\t\t\t\tnode = node.nextSibling;\n\t\t\t\t\t\t\trootBlockNode.appendChild(tempNode);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\trootBlockNode = null;\n\t\t\t\t\t\t\tnode = node.nextSibling;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tif (rng.setStart) {\n\t\t\t\t\t\trng.setStart(startContainer, startOffset);\n\t\t\t\t\t\trng.setEnd(endContainer, endOffset);\n\t\t\t\t\t\tselection.setRng(rng);\n\t\t\t\t\t} else {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\trng = ed.getDoc().body.createTextRange();\n\t\t\t\t\t\t\trng.moveToElementText(rootNode);\n\t\t\t\t\t\t\trng.collapse(true);\n\t\t\t\t\t\t\trng.moveStart('character', startOffset);\n\n\t\t\t\t\t\t\tif (endOffset > 0)\n\t\t\t\t\t\t\t\trng.moveEnd('character', endOffset);\n\n\t\t\t\t\t\t\trng.select();\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\t// Ignore\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\ted.nodeChanged();\n\t\t\t\t};\n\n\t\t\t\ted.onKeyUp.add(addRootBlocks);\n\t\t\t\ted.onClick.add(addRootBlocks);\n\t\t\t}\n\n\t\t\tif (s.force_br_newlines) {\n\t\t\t\t// Force IE to produce BRs on enter\n\t\t\t\tif (isIE) {\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tvar n;\n\n\t\t\t\t\t\tif (e.keyCode == 13 && selection.getNode().nodeName != 'LI') {\n\t\t\t\t\t\t\tselection.setContent('<br id=\"__\" /> ', {format : 'raw'});\n\t\t\t\t\t\t\tn = dom.get('__');\n\t\t\t\t\t\t\tn.removeAttribute('id');\n\t\t\t\t\t\t\tselection.select(n);\n\t\t\t\t\t\t\tselection.collapse();\n\t\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (s.force_p_newlines) {\n\t\t\t\tif (!isIE) {\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tif (e.keyCode == 13 && !e.shiftKey && !t.insertPara(e))\n\t\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\t// Ungly hack to for IE to preserve the formatting when you press\n\t\t\t\t\t// enter at the end of a block element with formatted contents\n\t\t\t\t\t// This logic overrides the browsers default logic with\n\t\t\t\t\t// custom logic that enables us to control the output\n\t\t\t\t\ttinymce.addUnload(function() {\n\t\t\t\t\t\tt._previousFormats = 0; // Fix IE leak\n\t\t\t\t\t});\n\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tt._previousFormats = 0;\n\n\t\t\t\t\t\t// Clone the current formats, this will later be applied to the new block contents\n\t\t\t\t\t\tif (e.keyCode == 13 && !e.shiftKey && ed.selection.isCollapsed() && s.keep_styles)\n\t\t\t\t\t\t\tt._previousFormats = cloneFormats(ed.selection.getStart());\n\t\t\t\t\t});\n\n\t\t\t\t\ted.onKeyUp.add(function(ed, e) {\n\t\t\t\t\t\t// Let IE break the element and the wrap the new caret location in the previous formats\n\t\t\t\t\t\tif (e.keyCode == 13 && !e.shiftKey) {\n\t\t\t\t\t\t\tvar parent = ed.selection.getStart(), fmt = t._previousFormats;\n\n\t\t\t\t\t\t\t// Parent is an empty block\n\t\t\t\t\t\t\tif (!parent.hasChildNodes() && fmt) {\n\t\t\t\t\t\t\t\tparent = dom.getParent(parent, dom.isBlock);\n\n\t\t\t\t\t\t\t\tif (parent && parent.nodeName != 'LI') {\n\t\t\t\t\t\t\t\t\tparent.innerHTML = '';\n\n\t\t\t\t\t\t\t\t\tif (t._previousFormats) {\n\t\t\t\t\t\t\t\t\t\tparent.appendChild(fmt.wrapper);\n\t\t\t\t\t\t\t\t\t\tfmt.inner.innerHTML = '\\uFEFF';\n\t\t\t\t\t\t\t\t\t} else\n\t\t\t\t\t\t\t\t\t\tparent.innerHTML = '\\uFEFF';\n\n\t\t\t\t\t\t\t\t\tselection.select(parent, 1);\n\t\t\t\t\t\t\t\t\tselection.collapse(true);\n\t\t\t\t\t\t\t\t\ted.getDoc().execCommand('Delete', false, null);\n\t\t\t\t\t\t\t\t\tt._previousFormats = 0;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif (isGecko) {\n\t\t\t\t\ted.onKeyDown.add(function(ed, e) {\n\t\t\t\t\t\tif ((e.keyCode == 8 || e.keyCode == 46) && !e.shiftKey)\n\t\t\t\t\t\t\tt.backspaceDelete(e, e.keyCode == 8);\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Workaround for missing shift+enter support, http://bugs.webkit.org/show_bug.cgi?id=16973\n\t\t\tif (tinymce.isWebKit) {\n\t\t\t\tfunction insertBr(ed) {\n\t\t\t\t\tvar rng = selection.getRng(), br, div = dom.create('div', null, ' '), divYPos, vpHeight = dom.getViewPort(ed.getWin()).h;\n\n\t\t\t\t\t// Insert BR element\n\t\t\t\t\trng.insertNode(br = dom.create('br'));\n\n\t\t\t\t\t// Place caret after BR\n\t\t\t\t\trng.setStartAfter(br);\n\t\t\t\t\trng.setEndAfter(br);\n\t\t\t\t\tselection.setRng(rng);\n\n\t\t\t\t\t// Could not place caret after BR then insert an nbsp entity and move the caret\n\t\t\t\t\tif (selection.getSel().focusNode == br.previousSibling) {\n\t\t\t\t\t\tselection.select(dom.insertAfter(dom.doc.createTextNode('\\u00a0'), br));\n\t\t\t\t\t\tselection.collapse(TRUE);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Create a temporary DIV after the BR and get the position as it\n\t\t\t\t\t// seems like getPos() returns 0 for text nodes and BR elements.\n\t\t\t\t\tdom.insertAfter(div, br);\n\t\t\t\t\tdivYPos = dom.getPos(div).y;\n\t\t\t\t\tdom.remove(div);\n\n\t\t\t\t\t// Scroll to new position, scrollIntoView can't be used due to bug: http://bugs.webkit.org/show_bug.cgi?id=16117\n\t\t\t\t\tif (divYPos > vpHeight) // It is not necessary to scroll if the DIV is inside the view port.\n\t\t\t\t\t\ted.getWin().scrollTo(0, divYPos);\n\t\t\t\t};\n\n\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\tif (e.keyCode == 13 && (e.shiftKey || (s.force_br_newlines && !dom.getParent(selection.getNode(), 'h1,h2,h3,h4,h5,h6,ol,ul')))) {\n\t\t\t\t\t\tinsertBr(ed);\n\t\t\t\t\t\tEvent.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// IE specific fixes\n\t\t\tif (isIE) {\n\t\t\t\t// Replaces IE:s auto generated paragraphs with the specified element name\n\t\t\t\tif (s.element != 'P') {\n\t\t\t\t\ted.onKeyPress.add(function(ed, e) {\n\t\t\t\t\t\tt.lastElm = selection.getNode().nodeName;\n\t\t\t\t\t});\n\n\t\t\t\t\ted.onKeyUp.add(function(ed, e) {\n\t\t\t\t\t\tvar bl, n = selection.getNode(), b = ed.getBody();\n\n\t\t\t\t\t\tif (b.childNodes.length === 1 && n.nodeName == 'P') {\n\t\t\t\t\t\t\tn = dom.rename(n, s.element);\n\t\t\t\t\t\t\tselection.select(n);\n\t\t\t\t\t\t\tselection.collapse();\n\t\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t\t} else if (e.keyCode == 13 && !e.shiftKey && t.lastElm != 'P') {\n\t\t\t\t\t\t\tbl = dom.getParent(n, 'p');\n\n\t\t\t\t\t\t\tif (bl) {\n\t\t\t\t\t\t\t\tdom.rename(bl, s.element);\n\t\t\t\t\t\t\t\ted.nodeChanged();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tgetParentBlock : function(n) {\n\t\t\tvar d = this.dom;\n\n\t\t\treturn d.getParent(n, d.isBlock);\n\t\t},\n\n\t\tinsertPara : function(e) {\n\t\t\tvar t = this, ed = t.editor, dom = ed.dom, d = ed.getDoc(), se = ed.settings, s = ed.selection.getSel(), r = s.getRangeAt(0), b = d.body;\n\t\t\tvar rb, ra, dir, sn, so, en, eo, sb, eb, bn, bef, aft, sc, ec, n, vp = dom.getViewPort(ed.getWin()), y, ch, car;\n\n\t\t\ted.undoManager.beforeChange();\n\n\t\t\t// If root blocks are forced then use Operas default behavior since it's really good\n// Removed due to bug: #1853816\n//\t\t\tif (se.forced_root_block && isOpera)\n//\t\t\t\treturn TRUE;\n\n\t\t\t// Setup before range\n\t\t\trb = d.createRange();\n\n\t\t\t// If is before the first block element and in body, then move it into first block element\n\t\t\trb.setStart(s.anchorNode, s.anchorOffset);\n\t\t\trb.collapse(TRUE);\n\n\t\t\t// Setup after range\n\t\t\tra = d.createRange();\n\n\t\t\t// If is before the first block element and in body, then move it into first block element\n\t\t\tra.setStart(s.focusNode, s.focusOffset);\n\t\t\tra.collapse(TRUE);\n\n\t\t\t// Setup start/end points\n\t\t\tdir = rb.compareBoundaryPoints(rb.START_TO_END, ra) < 0;\n\t\t\tsn = dir ? s.anchorNode : s.focusNode;\n\t\t\tso = dir ? s.anchorOffset : s.focusOffset;\n\t\t\ten = dir ? s.focusNode : s.anchorNode;\n\t\t\teo = dir ? s.focusOffset : s.anchorOffset;\n\n\t\t\t// If selection is in empty table cell\n\t\t\tif (sn === en && /^(TD|TH)$/.test(sn.nodeName)) {\n\t\t\t\tif (sn.firstChild.nodeName == 'BR')\n\t\t\t\t\tdom.remove(sn.firstChild); // Remove BR\n\n\t\t\t\t// Create two new block elements\n\t\t\t\tif (sn.childNodes.length == 0) {\n\t\t\t\t\ted.dom.add(sn, se.element, null, '<br />');\n\t\t\t\t\taft = ed.dom.add(sn, se.element, null, '<br />');\n\t\t\t\t} else {\n\t\t\t\t\tn = sn.innerHTML;\n\t\t\t\t\tsn.innerHTML = '';\n\t\t\t\t\ted.dom.add(sn, se.element, null, n);\n\t\t\t\t\taft = ed.dom.add(sn, se.element, null, '<br />');\n\t\t\t\t}\n\n\t\t\t\t// Move caret into the last one\n\t\t\t\tr = d.createRange();\n\t\t\t\tr.selectNodeContents(aft);\n\t\t\t\tr.collapse(1);\n\t\t\t\ted.selection.setRng(r);\n\n\t\t\t\treturn FALSE;\n\t\t\t}\n\n\t\t\t// If the caret is in an invalid location in FF we need to move it into the first block\n\t\t\tif (sn == b && en == b && b.firstChild && ed.dom.isBlock(b.firstChild)) {\n\t\t\t\tsn = en = sn.firstChild;\n\t\t\t\tso = eo = 0;\n\t\t\t\trb = d.createRange();\n\t\t\t\trb.setStart(sn, 0);\n\t\t\t\tra = d.createRange();\n\t\t\t\tra.setStart(en, 0);\n\t\t\t}\n\n\t\t\t// If the body is totally empty add a BR element this might happen on webkit\n\t\t\tif (!d.body.hasChildNodes()) {\n\t\t\t\td.body.appendChild(dom.create('br'));\n\t\t\t}\n\n\t\t\t// Never use body as start or end node\n\t\t\tsn = sn.nodeName == \"HTML\" ? d.body : sn; // Fix for Opera bug: https://bugs.opera.com/show_bug.cgi?id=273224&comments=yes\n\t\t\tsn = sn.nodeName == \"BODY\" ? sn.firstChild : sn;\n\t\t\ten = en.nodeName == \"HTML\" ? d.body : en; // Fix for Opera bug: https://bugs.opera.com/show_bug.cgi?id=273224&comments=yes\n\t\t\ten = en.nodeName == \"BODY\" ? en.firstChild : en;\n\n\t\t\t// Get start and end blocks\n\t\t\tsb = t.getParentBlock(sn);\n\t\t\teb = t.getParentBlock(en);\n\t\t\tbn = sb ? sb.nodeName : se.element; // Get block name to create\n\n\t\t\t// Return inside list use default browser behavior\n\t\t\tif (n = t.dom.getParent(sb, 'li,pre')) {\n\t\t\t\tif (n.nodeName == 'LI')\n\t\t\t\t\treturn splitList(ed.selection, t.dom, n);\n\n\t\t\t\treturn TRUE;\n\t\t\t}\n\n\t\t\t// If caption or absolute layers then always generate new blocks within\n\t\t\tif (sb && (sb.nodeName == 'CAPTION' || /absolute|relative|fixed/gi.test(dom.getStyle(sb, 'position', 1)))) {\n\t\t\t\tbn = se.element;\n\t\t\t\tsb = null;\n\t\t\t}\n\n\t\t\t// If caption or absolute layers then always generate new blocks within\n\t\t\tif (eb && (eb.nodeName == 'CAPTION' || /absolute|relative|fixed/gi.test(dom.getStyle(sb, 'position', 1)))) {\n\t\t\t\tbn = se.element;\n\t\t\t\teb = null;\n\t\t\t}\n\n\t\t\t// Use P instead\n\t\t\tif (/(TD|TABLE|TH|CAPTION)/.test(bn) || (sb && bn == \"DIV\" && /left|right/gi.test(dom.getStyle(sb, 'float', 1)))) {\n\t\t\t\tbn = se.element;\n\t\t\t\tsb = eb = null;\n\t\t\t}\n\n\t\t\t// Setup new before and after blocks\n\t\t\tbef = (sb && sb.nodeName == bn) ? sb.cloneNode(0) : ed.dom.create(bn);\n\t\t\taft = (eb && eb.nodeName == bn) ? eb.cloneNode(0) : ed.dom.create(bn);\n\n\t\t\t// Remove id from after clone\n\t\t\taft.removeAttribute('id');\n\n\t\t\t// Is header and cursor is at the end, then force paragraph under\n\t\t\tif (/^(H[1-6])$/.test(bn) && isAtEnd(r, sb))\n\t\t\t\taft = ed.dom.create(se.element);\n\n\t\t\t// Find start chop node\n\t\t\tn = sc = sn;\n\t\t\tdo {\n\t\t\t\tif (n == b || n.nodeType == 9 || t.dom.isBlock(n) || /(TD|TABLE|TH|CAPTION)/.test(n.nodeName))\n\t\t\t\t\tbreak;\n\n\t\t\t\tsc = n;\n\t\t\t} while ((n = n.previousSibling ? n.previousSibling : n.parentNode));\n\n\t\t\t// Find end chop node\n\t\t\tn = ec = en;\n\t\t\tdo {\n\t\t\t\tif (n == b || n.nodeType == 9 || t.dom.isBlock(n) || /(TD|TABLE|TH|CAPTION)/.test(n.nodeName))\n\t\t\t\t\tbreak;\n\n\t\t\t\tec = n;\n\t\t\t} while ((n = n.nextSibling ? n.nextSibling : n.parentNode));\n\n\t\t\t// Place first chop part into before block element\n\t\t\tif (sc.nodeName == bn)\n\t\t\t\trb.setStart(sc, 0);\n\t\t\telse\n\t\t\t\trb.setStartBefore(sc);\n\n\t\t\trb.setEnd(sn, so);\n\t\t\tbef.appendChild(rb.cloneContents() || d.createTextNode('')); // Empty text node needed for Safari\n\n\t\t\t// Place secnd chop part within new block element\n\t\t\ttry {\n\t\t\t\tra.setEndAfter(ec);\n\t\t\t} catch(ex) {\n\t\t\t\t//console.debug(s.focusNode, s.focusOffset);\n\t\t\t}\n\n\t\t\tra.setStart(en, eo);\n\t\t\taft.appendChild(ra.cloneContents() || d.createTextNode('')); // Empty text node needed for Safari\n\n\t\t\t// Create range around everything\n\t\t\tr = d.createRange();\n\t\t\tif (!sc.previousSibling && sc.parentNode.nodeName == bn) {\n\t\t\t\tr.setStartBefore(sc.parentNode);\n\t\t\t} else {\n\t\t\t\tif (rb.startContainer.nodeName == bn && rb.startOffset == 0)\n\t\t\t\t\tr.setStartBefore(rb.startContainer);\n\t\t\t\telse\n\t\t\t\t\tr.setStart(rb.startContainer, rb.startOffset);\n\t\t\t}\n\n\t\t\tif (!ec.nextSibling && ec.parentNode.nodeName == bn)\n\t\t\t\tr.setEndAfter(ec.parentNode);\n\t\t\telse\n\t\t\t\tr.setEnd(ra.endContainer, ra.endOffset);\n\n\t\t\t// Delete and replace it with new block elements\n\t\t\tr.deleteContents();\n\n\t\t\tif (isOpera)\n\t\t\t\ted.getWin().scrollTo(0, vp.y);\n\n\t\t\t// Never wrap blocks in blocks\n\t\t\tif (bef.firstChild && bef.firstChild.nodeName == bn)\n\t\t\t\tbef.innerHTML = bef.firstChild.innerHTML;\n\n\t\t\tif (aft.firstChild && aft.firstChild.nodeName == bn)\n\t\t\t\taft.innerHTML = aft.firstChild.innerHTML;\n\n\t\t\tfunction appendStyles(e, en) {\n\t\t\t\tvar nl = [], nn, n, i;\n\n\t\t\t\te.innerHTML = '';\n\n\t\t\t\t// Make clones of style elements\n\t\t\t\tif (se.keep_styles) {\n\t\t\t\t\tn = en;\n\t\t\t\t\tdo {\n\t\t\t\t\t\t// We only want style specific elements\n\t\t\t\t\t\tif (/^(SPAN|STRONG|B|EM|I|FONT|STRIKE|U)$/.test(n.nodeName)) {\n\t\t\t\t\t\t\tnn = n.cloneNode(FALSE);\n\t\t\t\t\t\t\tdom.setAttrib(nn, 'id', ''); // Remove ID since it needs to be unique\n\t\t\t\t\t\t\tnl.push(nn);\n\t\t\t\t\t\t}\n\t\t\t\t\t} while (n = n.parentNode);\n\t\t\t\t}\n\n\t\t\t\t// Append style elements to aft\n\t\t\t\tif (nl.length > 0) {\n\t\t\t\t\tfor (i = nl.length - 1, nn = e; i >= 0; i--)\n\t\t\t\t\t\tnn = nn.appendChild(nl[i]);\n\n\t\t\t\t\t// Padd most inner style element\n\t\t\t\t\tnl[0].innerHTML = isOpera ? '\\u00a0' : '<br />'; // Extra space for Opera so that the caret can move there\n\t\t\t\t\treturn nl[0]; // Move caret to most inner element\n\t\t\t\t} else\n\t\t\t\t\te.innerHTML = isOpera ? '\\u00a0' : '<br />'; // Extra space for Opera so that the caret can move there\n\t\t\t};\n\t\t\t\t\n\t\t\t// Padd empty blocks\n\t\t\tif (dom.isEmpty(bef))\n\t\t\t\tappendStyles(bef, sn);\n\n\t\t\t// Fill empty afterblook with current style\n\t\t\tif (dom.isEmpty(aft))\n\t\t\t\tcar = appendStyles(aft, en);\n\n\t\t\t// Opera needs this one backwards for older versions\n\t\t\tif (isOpera && parseFloat(opera.version()) < 9.5) {\n\t\t\t\tr.insertNode(bef);\n\t\t\t\tr.insertNode(aft);\n\t\t\t} else {\n\t\t\t\tr.insertNode(aft);\n\t\t\t\tr.insertNode(bef);\n\t\t\t}\n\n\t\t\t// Normalize\n\t\t\taft.normalize();\n\t\t\tbef.normalize();\n\n\t\t\t// Move cursor and scroll into view\n\t\t\ted.selection.select(aft, true);\n\t\t\ted.selection.collapse(true);\n\n\t\t\t// scrollIntoView seems to scroll the parent window in most browsers now including FF 3.0b4 so it's time to stop using it and do it our selfs\n\t\t\ty = ed.dom.getPos(aft).y;\n\t\t\t//ch = aft.clientHeight;\n\n\t\t\t// Is element within viewport\n\t\t\tif (y < vp.y || y + 25 > vp.y + vp.h) {\n\t\t\t\ted.getWin().scrollTo(0, y < vp.y ? y : y - vp.h + 25); // Needs to be hardcoded to roughly one line of text if a huge text block is broken into two blocks\n\n\t\t\t\t/*console.debug(\n\t\t\t\t\t'Element: y=' + y + ', h=' + ch + ', ' +\n\t\t\t\t\t'Viewport: y=' + vp.y + \", h=\" + vp.h + ', bottom=' + (vp.y + vp.h)\n\t\t\t\t);*/\n\t\t\t}\n\n\t\t\ted.undoManager.add();\n\n\t\t\treturn FALSE;\n\t\t},\n\n\t\tbackspaceDelete : function(e, bs) {\n\t\t\tvar t = this, ed = t.editor, b = ed.getBody(), dom = ed.dom, n, se = ed.selection, r = se.getRng(), sc = r.startContainer, n, w, tn, walker;\n\n\t\t\t// Delete when caret is behind a element doesn't work correctly on Gecko see #3011651\n\t\t\tif (!bs && r.collapsed && sc.nodeType == 1 && r.startOffset == sc.childNodes.length) {\n\t\t\t\twalker = new tinymce.dom.TreeWalker(sc.lastChild, sc);\n\n\t\t\t\t// Walk the dom backwards until we find a text node\n\t\t\t\tfor (n = sc.lastChild; n; n = walker.prev()) {\n\t\t\t\t\tif (n.nodeType == 3) {\n\t\t\t\t\t\tr.setStart(n, n.nodeValue.length);\n\t\t\t\t\t\tr.collapse(true);\n\t\t\t\t\t\tse.setRng(r);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// The caret sometimes gets stuck in Gecko if you delete empty paragraphs\n\t\t\t// This workaround removes the element by hand and moves the caret to the previous element\n\t\t\tif (sc && ed.dom.isBlock(sc) && !/^(TD|TH)$/.test(sc.nodeName) && bs) {\n\t\t\t\tif (sc.childNodes.length == 0 || (sc.childNodes.length == 1 && sc.firstChild.nodeName == 'BR')) {\n\t\t\t\t\t// Find previous block element\n\t\t\t\t\tn = sc;\n\t\t\t\t\twhile ((n = n.previousSibling) && !ed.dom.isBlock(n)) ;\n\n\t\t\t\t\tif (n) {\n\t\t\t\t\t\tif (sc != b.firstChild) {\n\t\t\t\t\t\t\t// Find last text node\n\t\t\t\t\t\t\tw = ed.dom.doc.createTreeWalker(n, NodeFilter.SHOW_TEXT, null, FALSE);\n\t\t\t\t\t\t\twhile (tn = w.nextNode())\n\t\t\t\t\t\t\t\tn = tn;\n\n\t\t\t\t\t\t\t// Place caret at the end of last text node\n\t\t\t\t\t\t\tr = ed.getDoc().createRange();\n\t\t\t\t\t\t\tr.setStart(n, n.nodeValue ? n.nodeValue.length : 0);\n\t\t\t\t\t\t\tr.setEnd(n, n.nodeValue ? n.nodeValue.length : 0);\n\t\t\t\t\t\t\tse.setRng(r);\n\n\t\t\t\t\t\t\t// Remove the target container\n\t\t\t\t\t\t\ted.dom.remove(sc);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn Event.cancel(e);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t});\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/WindowManager.js":"/**\n * WindowManager.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\tvar Dispatcher = tinymce.util.Dispatcher, each = tinymce.each, isIE = tinymce.isIE, isOpera = tinymce.isOpera;\n\n\t/**\n\t * This class handles the creation of native windows and dialogs. This class can be extended to provide for example inline dialogs.\n\t *\n\t * @class tinymce.WindowManager\n\t * @example\n\t * // Opens a new dialog with the file.htm file and the size 320x240\n\t * // It also adds a custom parameter this can be retrieved by using tinyMCEPopup.getWindowArg inside the dialog.\n\t * tinyMCE.activeEditor.windowManager.open({\n\t *    url : 'file.htm',\n\t *    width : 320,\n\t *    height : 240\n\t * }, {\n\t *    custom_param : 1\n\t * });\n\t *\n\t * // Displays an alert box using the active editors window manager instance\n\t * tinyMCE.activeEditor.windowManager.alert('Hello world!');\n\t *\n\t * // Displays an confirm box and an alert message will be displayed depending on what you choose in the confirm\n\t * tinyMCE.activeEditor.windowManager.confirm(\"Do you want to do something\", function(s) {\n\t *    if (s)\n\t *       tinyMCE.activeEditor.windowManager.alert(\"Ok\");\n\t *    else\n\t *       tinyMCE.activeEditor.windowManager.alert(\"Cancel\");\n\t * });\n\t */\n\ttinymce.create('tinymce.WindowManager', {\n\t\t/**\n\t\t * Constructs a new window manager instance.\n\t\t *\n\t\t * @constructor\n\t\t * @method WindowManager\n\t\t * @param {tinymce.Editor} ed Editor instance that the windows are bound to.\n\t\t */\n\t\tWindowManager : function(ed) {\n\t\t\tvar t = this;\n\n\t\t\tt.editor = ed;\n\t\t\tt.onOpen = new Dispatcher(t);\n\t\t\tt.onClose = new Dispatcher(t);\n\t\t\tt.params = {};\n\t\t\tt.features = {};\n\t\t},\n\n\t\t/**\n\t\t * Opens a new window.\n\t\t *\n\t\t * @method open\n\t\t * @param {Object} s Optional name/value settings collection contains things like width/height/url etc.\n\t\t * @option {String} title Window title.\n\t\t * @option {String} file URL of the file to open in the window.\n\t\t * @option {Number} width Width in pixels.\n\t\t * @option {Number} height Height in pixels.\n\t\t * @option {Boolean} resizable Specifies whether the popup window is resizable or not.\n\t\t * @option {Boolean} maximizable Specifies whether the popup window has a \"maximize\" button and can get maximized or not.\n\t\t * @option {Boolean} inline Specifies whether to display in-line (set to 1 or true for in-line display; requires inlinepopups plugin).\n\t\t * @option {String/Boolean} popup_css Optional CSS to use in the popup. Set to false to remove the default one.\n\t\t * @option {Boolean} translate_i18n Specifies whether translation should occur or not of i18 key strings. Default is true.\n\t\t * @option {String/bool} close_previous Specifies whether a previously opened popup window is to be closed or not (like when calling the file browser window over the advlink popup).\n\t\t * @option {String/bool} scrollbars Specifies whether the popup window can have scrollbars if required (i.e. content larger than the popup size specified).\n\t\t * @param {Object} p Optional parameters/arguments collection can be used by the dialogs to retrieve custom parameters.\n\t\t * @option {String} plugin_url url to plugin if opening plugin window that calls tinyMCEPopup.requireLangPack() and needs access to the plugin language js files\n\t\t */\n\t\topen : function(s, p) {\n\t\t\tvar t = this, f = '', x, y, mo = t.editor.settings.dialog_type == 'modal', w, sw, sh, vp = tinymce.DOM.getViewPort(), u;\n\n\t\t\t// Default some options\n\t\t\ts = s || {};\n\t\t\tp = p || {};\n\t\t\tsw = isOpera ? vp.w : screen.width; // Opera uses windows inside the Opera window\n\t\t\tsh = isOpera ? vp.h : screen.height;\n\t\t\ts.name = s.name || 'mc_' + new Date().getTime();\n\t\t\ts.width = parseInt(s.width || 320);\n\t\t\ts.height = parseInt(s.height || 240);\n\t\t\ts.resizable = true;\n\t\t\ts.left = s.left || parseInt(sw / 2.0) - (s.width / 2.0);\n\t\t\ts.top = s.top || parseInt(sh / 2.0) - (s.height / 2.0);\n\t\t\tp.inline = false;\n\t\t\tp.mce_width = s.width;\n\t\t\tp.mce_height = s.height;\n\t\t\tp.mce_auto_focus = s.auto_focus;\n\n\t\t\tif (mo) {\n\t\t\t\tif (isIE) {\n\t\t\t\t\ts.center = true;\n\t\t\t\t\ts.help = false;\n\t\t\t\t\ts.dialogWidth = s.width + 'px';\n\t\t\t\t\ts.dialogHeight = s.height + 'px';\n\t\t\t\t\ts.scroll = s.scrollbars || false;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Build features string\n\t\t\teach(s, function(v, k) {\n\t\t\t\tif (tinymce.is(v, 'boolean'))\n\t\t\t\t\tv = v ? 'yes' : 'no';\n\n\t\t\t\tif (!/^(name|url)$/.test(k)) {\n\t\t\t\t\tif (isIE && mo)\n\t\t\t\t\t\tf += (f ? ';' : '') + k + ':' + v;\n\t\t\t\t\telse\n\t\t\t\t\t\tf += (f ? ',' : '') + k + '=' + v;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tt.features = s;\n\t\t\tt.params = p;\n\t\t\tt.onOpen.dispatch(t, s, p);\n\n\t\t\tu = s.url || s.file;\n\t\t\tu = tinymce._addVer(u);\n\n\t\t\ttry {\n\t\t\t\tif (isIE && mo) {\n\t\t\t\t\tw = 1;\n\t\t\t\t\twindow.showModalDialog(u, window, f);\n\t\t\t\t} else\n\t\t\t\t\tw = window.open(u, s.name, f);\n\t\t\t} catch (ex) {\n\t\t\t\t// Ignore\n\t\t\t}\n\n\t\t\tif (!w)\n\t\t\t\talert(t.editor.getLang('popup_blocked'));\n\t\t},\n\n\t\t/**\n\t\t * Closes the specified window. This will also dispatch out a onClose event.\n\t\t *\n\t\t * @method close\n\t\t * @param {Window} w Native window object to close.\n\t\t */\n\t\tclose : function(w) {\n\t\t\tw.close();\n\t\t\tthis.onClose.dispatch(this);\n\t\t},\n\n\t\t/**\n\t\t * Creates a instance of a class. This method was needed since IE can't create instances\n\t\t * of classes from a parent window due to some reference problem. Any arguments passed after the class name\n\t\t * will be passed as arguments to the constructor.\n\t\t *\n\t\t * @method createInstance\n\t\t * @param {String} cl Class name to create an instance of.\n\t\t * @return {Object} Instance of the specified class.\n\t\t * @example\n\t\t * var uri = tinyMCEPopup.editor.windowManager.createInstance('tinymce.util.URI', 'http://www.somesite.com');\n\t\t * alert(uri.getURI());\n\t\t */\n\t\tcreateInstance : function(cl, a, b, c, d, e) {\n\t\t\tvar f = tinymce.resolve(cl);\n\n\t\t\treturn new f(a, b, c, d, e);\n\t\t},\n\n\t\t/**\n\t\t * Creates a confirm dialog. Please don't use the blocking behavior of this\n\t\t * native version use the callback method instead then it can be extended.\n\t\t *\n\t\t * @method confirm\n\t\t * @param {String} t Title for the new confirm dialog.\n\t\t * @param {function} cb Callback function to be executed after the user has selected ok or cancel.\n\t\t * @param {Object} s Optional scope to execute the callback in.\n\t\t * @example\n\t\t * // Displays an confirm box and an alert message will be displayed depending on what you choose in the confirm\n\t\t * tinyMCE.activeEditor.windowManager.confirm(\"Do you want to do something\", function(s) {\n\t\t *    if (s)\n\t\t *       tinyMCE.activeEditor.windowManager.alert(\"Ok\");\n\t\t *    else\n\t\t *       tinyMCE.activeEditor.windowManager.alert(\"Cancel\");\n\t\t * });\n\t\t */\n\t\tconfirm : function(t, cb, s, w) {\n\t\t\tw = w || window;\n\n\t\t\tcb.call(s || this, w.confirm(this._decode(this.editor.getLang(t, t))));\n\t\t},\n\n\t\t/**\n\t\t * Creates a alert dialog. Please don't use the blocking behavior of this\n\t\t * native version use the callback method instead then it can be extended.\n\t\t *\n\t\t * @method alert\n\t\t * @param {String} t Title for the new alert dialog.\n\t\t * @param {function} cb Callback function to be executed after the user has selected ok.\n\t\t * @param {Object} s Optional scope to execute the callback in.\n\t\t * @example\n\t\t * // Displays an alert box using the active editors window manager instance\n\t\t * tinyMCE.activeEditor.windowManager.alert('Hello world!');\n\t\t */\n\t\talert : function(tx, cb, s, w) {\n\t\t\tvar t = this;\n\n\t\t\tw = w || window;\n\t\t\tw.alert(t._decode(t.editor.getLang(tx, tx)));\n\n\t\t\tif (cb)\n\t\t\t\tcb.call(s || t);\n\t\t},\n\n\t\t/**\n\t\t * Resizes the specified window or id.\n\t\t *\n\t\t * @param {Number} dw Delta width.\n\t\t * @param {Number} dh Delta height.\n\t\t * @param {window/id} win Window if the dialog isn't inline. Id if the dialog is inline.\n\t\t */\n\t\tresizeBy : function(dw, dh, win) {\n\t\t\twin.resizeBy(dw, dh);\n\t\t},\n\n\t\t// Internal functions\n\n\t\t_decode : function(s) {\n\t\t\treturn tinymce.DOM.decode(s).replace(/\\\\n/g, '\\n');\n\t\t}\n\t});\n}(tinymce));\n","Magento_Tinymce3/tiny_mce/classes/xml/Parser.js":"/**\n * Parser.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\t/**\n\t * XML Parser class. This class is only available for the dev version of TinyMCE.\n\t */\n\ttinymce.create('tinymce.xml.Parser', {\n\t\t/**\n\t\t * Constucts a new XML parser instance.\n\t\t *\n\t\t * @param {Object} Optional settings object.\n\t\t */\n\t\tParser : function(s) {\n\t\t\tthis.settings = tinymce.extend({\n\t\t\t\tasync : true\n\t\t\t}, s);\n\t\t},\n\n\t\t/**\n\t\t * Parses the specified document and executed the callback ones it's parsed.\n\t\t *\n\t\t * @param {String} u URL to XML file to parse.\n\t\t * @param {function} cb Optional callback to execute ones the XML file is loaded.\n\t\t * @param {Object} s Optional scope for the callback execution.\n\t\t */\n\t\tload : function(u, cb, s) {\n\t\t\tvar doc, t, w = window, c = 0;\n\n\t\t\ts = s || this;\n\n\t\t\t// Explorer, use XMLDOM since it can be used on local fs\n\t\t\tif (window.ActiveXObject) {\n\t\t\t\tdoc = new ActiveXObject(\"Microsoft.XMLDOM\");\n\t\t\t\tdoc.async = this.settings.async;\n\n\t\t\t\t// Wait for response\n\t\t\t\tif (doc.async) {\n\t\t\t\t\tfunction check() {\n\t\t\t\t\t\tif (doc.readyState == 4 || c++ > 10000)\n\t\t\t\t\t\t\treturn cb.call(s, doc);\n\n\t\t\t\t\t\tw.setTimeout(check, 10);\n\t\t\t\t\t};\n\n\t\t\t\t\tt = w.setTimeout(check, 10);\n\t\t\t\t}\n\n\t\t\t\tdoc.load(u);\n\n\t\t\t\tif (!doc.async)\n\t\t\t\t\tcb.call(s, doc);\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// W3C using XMLHttpRequest\n\t\t\tif (window.XMLHttpRequest) {\n\t\t\t\ttry {\n\t\t\t\t\tdoc = new window.XMLHttpRequest();\n\t\t\t\t\tdoc.open('GET', u, this.settings.async);\n\t\t\t\t\tdoc.async = this.settings.async;\n\n\t\t\t\t\tdoc.onload = function() {\n\t\t\t\t\t\tcb.call(s, doc.responseXML);\n\t\t\t\t\t};\n\n\t\t\t\t\tdoc.send('');\n\t\t\t\t} catch (ex) {\n\t\t\t\t\tcb.call(s, null, ex);\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Parses the specified XML string.\n\t\t *\n\t\t * @param {String} xml XML String to parse.\n\t\t * @return {Document} XML Document instance.\n\t\t */\n\t\tloadXML : function(xml) {\n\t\t\tvar doc;\n\n\t\t\t// W3C\n\t\t\tif (window.DOMParser)\n\t\t\t\treturn new DOMParser().parseFromString(xml, \"text/xml\");\n\n\t\t\t// Explorer\n\t\t\tif (window.ActiveXObject) {\n\t\t\t\tdoc = new ActiveXObject(\"Microsoft.XMLDOM\");\n\t\t\t\tdoc.async = \"false\";\n\t\t\t\tdoc.loadXML(xml);\n\n\t\t\t\treturn doc;\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Returns all string contents of a element concated together.\n\t\t *\n\t\t * @param {XMLNode} el XML element to retrieve text from.\n\t\t * @return {string} XML element text contents.\n\t\t */\n\t\tgetText : function(el) {\n\t\t\tvar o = '';\n\n\t\t\tif (!el)\n\t\t\t\treturn '';\n\n\t\t\tif (el.hasChildNodes()) {\n\t\t\t\tel = el.firstChild;\n\n\t\t\t\tdo {\n\t\t\t\t\tif (el.nodeType == 3 || el.nodeType == 4)\n\t\t\t\t\t\to += el.nodeValue;\n\t\t\t\t} while(el = el.nextSibling);\n\t\t\t}\n\n\t\t\treturn o;\n\t\t}\n\t});\n})();\n","Magento_Tinymce3/tiny_mce/classes/html/Styles.js":"/**\n * Styles.js\n *\n * Copyright 2010, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n/**\n * This class is used to parse CSS styles it also compresses styles to reduce the output size.\n *\n * @example\n * var Styles = new tinymce.html.Styles({\n *    url_converter: function(url) {\n *       return url;\n *    }\n * });\n *\n * styles = Styles.parse('border: 1px solid red');\n * styles.color = 'red';\n *\n * console.log(new tinymce.html.StyleSerializer().serialize(styles));\n *\n * @class tinymce.html.Styles\n * @version 3.4\n */\ntinymce.html.Styles = function(settings, schema) {\n\tvar rgbRegExp = /rgb\\s*\\(\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*\\)/gi,\n\t\turlOrStrRegExp = /(?:url(?:(?:\\(\\s*\\\"([^\\\"]+)\\\"\\s*\\))|(?:\\(\\s*\\'([^\\']+)\\'\\s*\\))|(?:\\(\\s*([^)\\s]+)\\s*\\))))|(?:\\'([^\\']+)\\')|(?:\\\"([^\\\"]+)\\\")/gi,\n\t\tstyleRegExp = /\\s*([^:]+):\\s*([^;]+);?/g,\n\t\ttrimRightRegExp = /\\s+$/,\n\t\turlColorRegExp = /rgb/,\n\t\tundef, i, encodingLookup = {}, encodingItems;\n\n\tsettings = settings || {};\n\n\tencodingItems = '\\\\\" \\\\\\' \\\\; \\\\: ; : \\uFEFF'.split(' ');\n\tfor (i = 0; i < encodingItems.length; i++) {\n\t\tencodingLookup[encodingItems[i]] = '\\uFEFF' + i;\n\t\tencodingLookup['\\uFEFF' + i] = encodingItems[i];\n\t}\n\n\tfunction toHex(match, r, g, b) {\n\t\tfunction hex(val) {\n\t\t\tval = parseInt(val).toString(16);\n\n\t\t\treturn val.length > 1 ? val : '0' + val; // 0 -> 00\n\t\t};\n\n\t\treturn '#' + hex(r) + hex(g) + hex(b);\n\t};\n\n\treturn {\n\t\t/**\n\t\t * Parses the specified RGB color value and returns a hex version of that color.\n\t\t *\n\t\t * @method toHex\n\t\t * @param {String} color RGB string value like rgb(1,2,3)\n\t\t * @return {String} Hex version of that RGB value like #FF00FF.\n\t\t */\n\t\ttoHex : function(color) {\n\t\t\treturn color.replace(rgbRegExp, toHex);\n\t\t},\n\n\t\t/**\n\t\t * Parses the specified style value into an object collection. This parser will also\n\t\t * merge and remove any redundant items that browsers might have added. It will also convert non hex\n\t\t * colors to hex values. Urls inside the styles will also be converted to absolute/relative based on settings.\n\t\t *\n\t\t * @method parse\n\t\t * @param {String} css Style value to parse for example: border:1px solid red;.\n\t\t * @return {Object} Object representation of that style like {border : '1px solid red'}\n\t\t */\n\t\tparse : function(css) {\n\t\t\tvar styles = {}, matches, name, value, isEncoded, urlConverter = settings.url_converter, urlConverterScope = settings.url_converter_scope || this;\n\n\t\t\tfunction compress(prefix, suffix) {\n\t\t\t\tvar top, right, bottom, left;\n\n\t\t\t\t// Get values and check it needs compressing\n\t\t\t\ttop = styles[prefix + '-top' + suffix];\n\t\t\t\tif (!top)\n\t\t\t\t\treturn;\n\n\t\t\t\tright = styles[prefix + '-right' + suffix];\n\t\t\t\tif (top != right)\n\t\t\t\t\treturn;\n\n\t\t\t\tbottom = styles[prefix + '-bottom' + suffix];\n\t\t\t\tif (right != bottom)\n\t\t\t\t\treturn;\n\n\t\t\t\tleft = styles[prefix + '-left' + suffix];\n\t\t\t\tif (bottom != left)\n\t\t\t\t\treturn;\n\n\t\t\t\t// Compress\n\t\t\t\tstyles[prefix + suffix] = left;\n\t\t\t\tdelete styles[prefix + '-top' + suffix];\n\t\t\t\tdelete styles[prefix + '-right' + suffix];\n\t\t\t\tdelete styles[prefix + '-bottom' + suffix];\n\t\t\t\tdelete styles[prefix + '-left' + suffix];\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * Checks if the specific style can be compressed in other words if all border-width are equal.\n\t\t\t */\n\t\t\tfunction canCompress(key) {\n\t\t\t\tvar value = styles[key], i;\n\n\t\t\t\tif (!value || value.indexOf(' ') < 0)\n\t\t\t\t\treturn;\n\n\t\t\t\tvalue = value.split(' ');\n\t\t\t\ti = value.length;\n\t\t\t\twhile (i--) {\n\t\t\t\t\tif (value[i] !== value[0])\n\t\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tstyles[key] = value[0];\n\n\t\t\t\treturn true;\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * Compresses multiple styles into one style.\n\t\t\t */\n\t\t\tfunction compress2(target, a, b, c) {\n\t\t\t\tif (!canCompress(a))\n\t\t\t\t\treturn;\n\n\t\t\t\tif (!canCompress(b))\n\t\t\t\t\treturn;\n\n\t\t\t\tif (!canCompress(c))\n\t\t\t\t\treturn;\n\n\t\t\t\t// Compress\n\t\t\t\tstyles[target] = styles[a] + ' ' + styles[b] + ' ' + styles[c];\n\t\t\t\tdelete styles[a];\n\t\t\t\tdelete styles[b];\n\t\t\t\tdelete styles[c];\n\t\t\t};\n\n\t\t\t// Encodes the specified string by replacing all \\\" \\' ; : with _<num>\n\t\t\tfunction encode(str) {\n\t\t\t\tisEncoded = true;\n\n\t\t\t\treturn encodingLookup[str];\n\t\t\t};\n\n\t\t\t// Decodes the specified string by replacing all _<num> with it's original value \\\" \\' etc\n\t\t\t// It will also decode the \\\" \\' if keep_slashes is set to fale or omitted\n\t\t\tfunction decode(str, keep_slashes) {\n\t\t\t\tif (isEncoded) {\n\t\t\t\t\tstr = str.replace(/\\uFEFF[0-9]/g, function(str) {\n\t\t\t\t\t\treturn encodingLookup[str];\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tif (!keep_slashes)\n\t\t\t\t\tstr = str.replace(/\\\\([\\'\\\";:])/g, \"$1\");\n\n\t\t\t\treturn str;\n\t\t\t}\n\n\t\t\tif (css) {\n\t\t\t\t// Encode \\\" \\' % and ; and : inside strings so they don't interfere with the style parsing\n\t\t\t\tcss = css.replace(/\\\\[\\\"\\';:\\uFEFF]/g, encode).replace(/\\\"[^\\\"]+\\\"|\\'[^\\']+\\'/g, function(str) {\n\t\t\t\t\treturn str.replace(/[;:]/g, encode);\n\t\t\t\t});\n\n\t\t\t\t// Parse styles\n\t\t\t\twhile (matches = styleRegExp.exec(css)) {\n\t\t\t\t\tname = matches[1].replace(trimRightRegExp, '').toLowerCase();\n\t\t\t\t\tvalue = matches[2].replace(trimRightRegExp, '');\n\n\t\t\t\t\tif (name && value.length > 0) {\n\t\t\t\t\t\t// Opera will produce 700 instead of bold in their style values\n\t\t\t\t\t\tif (name === 'font-weight' && value === '700')\n\t\t\t\t\t\t\tvalue = 'bold';\n\t\t\t\t\t\telse if (name === 'color' || name === 'background-color') // Lowercase colors like RED\n\t\t\t\t\t\t\tvalue = value.toLowerCase();\t\t\n\n\t\t\t\t\t\t// Convert RGB colors to HEX\n\t\t\t\t\t\tvalue = value.replace(rgbRegExp, toHex);\n\n\t\t\t\t\t\t// Convert URLs and force them into url('value') format\n\t\t\t\t\t\tvalue = value.replace(urlOrStrRegExp, function(match, url, url2, url3, str, str2) {\n\t\t\t\t\t\t\tstr = str || str2;\n\n\t\t\t\t\t\t\tif (str) {\n\t\t\t\t\t\t\t\tstr = decode(str);\n\n\t\t\t\t\t\t\t\t// Force strings into single quote format\n\t\t\t\t\t\t\t\treturn \"'\" + str.replace(/\\'/g, \"\\\\'\") + \"'\";\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\turl = decode(url || url2 || url3);\n\n\t\t\t\t\t\t\t// Convert the URL to relative/absolute depending on config\n\t\t\t\t\t\t\tif (urlConverter)\n\t\t\t\t\t\t\t\turl = urlConverter.call(urlConverterScope, url, 'style');\n\n\t\t\t\t\t\t\t// Output new URL format\n\t\t\t\t\t\t\treturn \"url('\" + url.replace(/\\'/g, \"\\\\'\") + \"')\";\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tstyles[name] = isEncoded ? decode(value, true) : value;\n\t\t\t\t\t}\n\n\t\t\t\t\tstyleRegExp.lastIndex = matches.index + matches[0].length;\n\t\t\t\t}\n\n\t\t\t\t// Compress the styles to reduce it's size for example IE will expand styles\n\t\t\t\tcompress(\"border\", \"\");\n\t\t\t\tcompress(\"border\", \"-width\");\n\t\t\t\tcompress(\"border\", \"-color\");\n\t\t\t\tcompress(\"border\", \"-style\");\n\t\t\t\tcompress(\"padding\", \"\");\n\t\t\t\tcompress(\"margin\", \"\");\n\t\t\t\tcompress2('border', 'border-width', 'border-style', 'border-color');\n\n\t\t\t\t// Remove pointless border, IE produces these\n\t\t\t\tif (styles.border === 'medium none')\n\t\t\t\t\tdelete styles.border;\n\t\t\t}\n\n\t\t\treturn styles;\n\t\t},\n\n\t\t/**\n\t\t * Serializes the specified style object into a string.\n\t\t *\n\t\t * @method serialize\n\t\t * @param {Object} styles Object to serialize as string for example: {border : '1px solid red'}\n\t\t * @param {String} element_name Optional element name, if specified only the styles that matches the schema will be serialized.\n\t\t * @return {String} String representation of the style object for example: border: 1px solid red.\n\t\t */\n\t\tserialize : function(styles, element_name) {\n\t\t\tvar css = '', name, value;\n\n\t\t\tfunction serializeStyles(name) {\n\t\t\t\tvar styleList, i, l, value;\n\n\t\t\t\tstyleList = schema.styles[name];\n\t\t\t\tif (styleList) {\n\t\t\t\t\tfor (i = 0, l = styleList.length; i < l; i++) {\n\t\t\t\t\t\tname = styleList[i];\n\t\t\t\t\t\tvalue = styles[name];\n\n\t\t\t\t\t\tif (value !== undef && value.length > 0)\n\t\t\t\t\t\t\tcss += (css.length > 0 ? ' ' : '') + name + ': ' + value + ';';\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Serialize styles according to schema\n\t\t\tif (element_name && schema && schema.styles) {\n\t\t\t\t// Serialize global styles and element specific styles\n\t\t\t\tserializeStyles('*');\n\t\t\t\tserializeStyles(element_name);\n\t\t\t} else {\n\t\t\t\t// Output the styles in the order they are inside the object\n\t\t\t\tfor (name in styles) {\n\t\t\t\t\tvalue = styles[name];\n\n\t\t\t\t\tif (value !== undef && value.length > 0)\n\t\t\t\t\t\tcss += (css.length > 0 ? ' ' : '') + name + ': ' + value + ';';\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn css;\n\t\t}\n\t};\n};\n","Magento_Tinymce3/tiny_mce/classes/html/Schema.js":"/**\n * Schema.js\n *\n * Copyright 2010, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\tvar transitional = {}, boolAttrMap, blockElementsMap, shortEndedElementsMap, nonEmptyElementsMap, customElementsMap = {},\n\t\tdefaultWhiteSpaceElementsMap, selfClosingElementsMap, makeMap = tinymce.makeMap, each = tinymce.each;\n\n\tfunction split(str, delim) {\n\t\treturn str.split(delim || ',');\n\t};\n\n\t/**\n\t * Unpacks the specified lookup and string data it will also parse it into an object\n\t * map with sub object for it's children. This will later also include the attributes.\n\t */\n\tfunction unpack(lookup, data) {\n\t\tvar key, elements = {};\n\n\t\tfunction replace(value) {\n\t\t\treturn value.replace(/[A-Z]+/g, function(key) {\n\t\t\t\treturn replace(lookup[key]);\n\t\t\t});\n\t\t};\n\n\t\t// Unpack lookup\n\t\tfor (key in lookup) {\n\t\t\tif (lookup.hasOwnProperty(key))\n\t\t\t\tlookup[key] = replace(lookup[key]);\n\t\t}\n\n\t\t// Unpack and parse data into object map\n\t\treplace(data).replace(/#/g, '#text').replace(/(\\w+)\\[([^\\]]+)\\]\\[([^\\]]*)\\]/g, function(str, name, attributes, children) {\n\t\t\tattributes = split(attributes, '|');\n\n\t\t\telements[name] = {\n\t\t\t\tattributes : makeMap(attributes),\n\t\t\t\tattributesOrder : attributes,\n\t\t\t\tchildren : makeMap(children, '|', {'#comment' : {}})\n\t\t\t}\n\t\t});\n\n\t\treturn elements;\n\t};\n\n\t// Build a lookup table for block elements both lowercase and uppercase\n\tblockElementsMap = 'h1,h2,h3,h4,h5,h6,hr,p,div,address,pre,form,table,tbody,thead,tfoot,' + \n\t\t\t\t\t\t'th,tr,td,li,ol,ul,caption,blockquote,center,dl,dt,dd,dir,fieldset,' + \n\t\t\t\t\t\t'noscript,menu,isindex,samp,header,footer,article,section,hgroup';\n\tblockElementsMap = makeMap(blockElementsMap, ',', makeMap(blockElementsMap.toUpperCase()));\n\n\t// This is the XHTML 1.0 transitional elements with it's attributes and children packed to reduce it's size\n\ttransitional = unpack({\n\t\tZ : 'H|K|N|O|P',\n\t\tY : 'X|form|R|Q',\n\t\tZG : 'E|span|width|align|char|charoff|valign',\n\t\tX : 'p|T|div|U|W|isindex|fieldset|table',\n\t\tZF : 'E|align|char|charoff|valign',\n\t\tW : 'pre|hr|blockquote|address|center|noframes',\n\t\tZE : 'abbr|axis|headers|scope|rowspan|colspan|align|char|charoff|valign|nowrap|bgcolor|width|height',\n\t\tZD : '[E][S]',\n\t\tU : 'ul|ol|dl|menu|dir',\n\t\tZC : 'p|Y|div|U|W|table|br|span|bdo|object|applet|img|map|K|N|Q',\n\t\tT : 'h1|h2|h3|h4|h5|h6',\n\t\tZB : 'X|S|Q',\n\t\tS : 'R|P',\n\t\tZA : 'a|G|J|M|O|P',\n\t\tR : 'a|H|K|N|O',\n\t\tQ : 'noscript|P',\n\t\tP : 'ins|del|script',\n\t\tO : 'input|select|textarea|label|button',\n\t\tN : 'M|L',\n\t\tM : 'em|strong|dfn|code|q|samp|kbd|var|cite|abbr|acronym',\n\t\tL : 'sub|sup',\n\t\tK : 'J|I',\n\t\tJ : 'tt|i|b|u|s|strike',\n\t\tI : 'big|small|font|basefont',\n\t\tH : 'G|F',\n\t\tG : 'br|span|bdo',\n\t\tF : 'object|applet|img|map|iframe',\n\t\tE : 'A|B|C',\n\t\tD : 'accesskey|tabindex|onfocus|onblur',\n\t\tC : 'onclick|ondblclick|onmousedown|onmouseup|onmouseover|onmousemove|onmouseout|onkeypress|onkeydown|onkeyup',\n\t\tB : 'lang|xml:lang|dir',\n\t\tA : 'id|class|style|title'\n\t}, 'script[id|charset|type|language|src|defer|xml:space][]' + \n\t\t'style[B|id|type|media|title|xml:space][]' + \n\t\t'object[E|declare|classid|codebase|data|type|codetype|archive|standby|width|height|usemap|name|tabindex|align|border|hspace|vspace][#|param|Y]' + \n\t\t'param[id|name|value|valuetype|type][]' + \n\t\t'p[E|align][#|S]' + \n\t\t'a[E|D|charset|type|name|href|hreflang|rel|rev|shape|coords|target][#|Z]' + \n\t\t'br[A|clear][]' + \n\t\t'span[E][#|S]' + \n\t\t'bdo[A|C|B][#|S]' + \n\t\t'applet[A|codebase|archive|code|object|alt|name|width|height|align|hspace|vspace][#|param|Y]' + \n\t\t'h1[E|align][#|S]' + \n\t\t'img[E|src|alt|name|longdesc|width|height|usemap|ismap|align|border|hspace|vspace][]' + \n\t\t'map[B|C|A|name][X|form|Q|area]' + \n\t\t'h2[E|align][#|S]' + \n\t\t'iframe[A|longdesc|name|src|frameborder|marginwidth|marginheight|scrolling|align|width|height][#|Y]' + \n\t\t'h3[E|align][#|S]' + \n\t\t'tt[E][#|S]' + \n\t\t'i[E][#|S]' + \n\t\t'b[E][#|S]' + \n\t\t'u[E][#|S]' + \n\t\t's[E][#|S]' + \n\t\t'strike[E][#|S]' + \n\t\t'big[E][#|S]' + \n\t\t'small[E][#|S]' + \n\t\t'font[A|B|size|color|face][#|S]' + \n\t\t'basefont[id|size|color|face][]' + \n\t\t'em[E][#|S]' + \n\t\t'strong[E][#|S]' + \n\t\t'dfn[E][#|S]' + \n\t\t'code[E][#|S]' + \n\t\t'q[E|cite][#|S]' + \n\t\t'samp[E][#|S]' + \n\t\t'kbd[E][#|S]' + \n\t\t'var[E][#|S]' + \n\t\t'cite[E][#|S]' + \n\t\t'abbr[E][#|S]' + \n\t\t'acronym[E][#|S]' + \n\t\t'sub[E][#|S]' + \n\t\t'sup[E][#|S]' + \n\t\t'input[E|D|type|name|value|checked|disabled|readonly|size|maxlength|src|alt|usemap|onselect|onchange|accept|align][]' + \n\t\t'select[E|name|size|multiple|disabled|tabindex|onfocus|onblur|onchange][optgroup|option]' + \n\t\t'optgroup[E|disabled|label][option]' + \n\t\t'option[E|selected|disabled|label|value][]' + \n\t\t'textarea[E|D|name|rows|cols|disabled|readonly|onselect|onchange][]' + \n\t\t'label[E|for|accesskey|onfocus|onblur][#|S]' + \n\t\t'button[E|D|name|value|type|disabled][#|p|T|div|U|W|table|G|object|applet|img|map|K|N|Q]' + \n\t\t'h4[E|align][#|S]' + \n\t\t'ins[E|cite|datetime][#|Y]' + \n\t\t'h5[E|align][#|S]' + \n\t\t'del[E|cite|datetime][#|Y]' + \n\t\t'h6[E|align][#|S]' + \n\t\t'div[E|align][#|Y]' + \n\t\t'ul[E|type|compact][li]' + \n\t\t'li[E|type|value][#|Y]' + \n\t\t'ol[E|type|compact|start][li]' + \n\t\t'dl[E|compact][dt|dd]' + \n\t\t'dt[E][#|S]' + \n\t\t'dd[E][#|Y]' + \n\t\t'menu[E|compact][li]' + \n\t\t'dir[E|compact][li]' + \n\t\t'pre[E|width|xml:space][#|ZA]' + \n\t\t'hr[E|align|noshade|size|width][]' + \n\t\t'blockquote[E|cite][#|Y]' + \n\t\t'address[E][#|S|p]' + \n\t\t'center[E][#|Y]' + \n\t\t'noframes[E][#|Y]' + \n\t\t'isindex[A|B|prompt][]' + \n\t\t'fieldset[E][#|legend|Y]' + \n\t\t'legend[E|accesskey|align][#|S]' + \n\t\t'table[E|summary|width|border|frame|rules|cellspacing|cellpadding|align|bgcolor][caption|col|colgroup|thead|tfoot|tbody|tr]' + \n\t\t'caption[E|align][#|S]' + \n\t\t'col[ZG][]' + \n\t\t'colgroup[ZG][col]' + \n\t\t'thead[ZF][tr]' + \n\t\t'tr[ZF|bgcolor][th|td]' + \n\t\t'th[E|ZE][#|Y]' + \n\t\t'form[E|action|method|name|enctype|onsubmit|onreset|accept|accept-charset|target][#|X|R|Q]' + \n\t\t'noscript[E][#|Y]' + \n\t\t'td[E|ZE][#|Y]' + \n\t\t'tfoot[ZF][tr]' + \n\t\t'tbody[ZF][tr]' + \n\t\t'area[E|D|shape|coords|href|nohref|alt|target][]' + \n\t\t'base[id|href|target][]' + \n\t\t'body[E|onload|onunload|background|bgcolor|text|link|vlink|alink][#|Y]'\n\t);\n\n\tboolAttrMap = makeMap('checked,compact,declare,defer,disabled,ismap,multiple,nohref,noresize,noshade,nowrap,readonly,selected,autoplay,loop,controls');\n\tshortEndedElementsMap = makeMap('area,base,basefont,br,col,frame,hr,img,input,isindex,link,meta,param,embed,source');\n\tnonEmptyElementsMap = tinymce.extend(makeMap('td,th,iframe,video,audio,object'), shortEndedElementsMap);\n\tdefaultWhiteSpaceElementsMap = makeMap('pre,script,style,textarea');\n\tselfClosingElementsMap = makeMap('colgroup,dd,dt,li,options,p,td,tfoot,th,thead,tr');\n\n\t/**\n\t * Schema validator class.\n\t *\n\t * @class tinymce.html.Schema\n\t * @example\n\t *  if (tinymce.activeEditor.schema.isValidChild('p', 'span'))\n\t *    alert('span is valid child of p.');\n\t *\n\t *  if (tinymce.activeEditor.schema.getElementRule('p'))\n\t *    alert('P is a valid element.');\n\t *\n\t * @class tinymce.html.Schema\n\t * @version 3.4\n\t */\n\n\t/**\n\t * Constructs a new Schema instance.\n\t *\n\t * @constructor\n\t * @method Schema\n\t * @param {Object} settings Name/value settings object.\n\t */\n\ttinymce.html.Schema = function(settings) {\n\t\tvar self = this, elements = {}, children = {}, patternElements = [], validStyles, whiteSpaceElementsMap;\n\n\t\tsettings = settings || {};\n\n\t\t// Allow all elements and attributes if verify_html is set to false\n\t\tif (settings.verify_html === false)\n\t\t\tsettings.valid_elements = '*[*]';\n\n\t\t// Build styles list\n\t\tif (settings.valid_styles) {\n\t\t\tvalidStyles = {};\n\n\t\t\t// Convert styles into a rule list\n\t\t\teach(settings.valid_styles, function(value, key) {\n\t\t\t\tvalidStyles[key] = tinymce.explode(value);\n\t\t\t});\n\t\t}\n\n\t\twhiteSpaceElementsMap = settings.whitespace_elements ? makeMap(settings.whitespace_elements) : defaultWhiteSpaceElementsMap;\n\n\t\t// Converts a wildcard expression string to a regexp for example *a will become /.*a/.\n\t\tfunction patternToRegExp(str) {\n\t\t\treturn new RegExp('^' + str.replace(/([?+*])/g, '.$1') + '$');\n\t\t};\n\n\t\t// Parses the specified valid_elements string and adds to the current rules\n\t\t// This function is a bit hard to read since it's heavily optimized for speed\n\t\tfunction addValidElements(valid_elements) {\n\t\t\tvar ei, el, ai, al, yl, matches, element, attr, attrData, elementName, attrName, attrType, attributes, attributesOrder,\n\t\t\t\tprefix, outputName, globalAttributes, globalAttributesOrder, transElement, key, childKey, value,\n\t\t\t\telementRuleRegExp = /^([#+-])?([^\\[\\/]+)(?:\\/([^\\[]+))?(?:\\[([^\\]]+)\\])?$/,\n\t\t\t\tattrRuleRegExp = /^([!\\-])?(\\w+::\\w+|[^=:<]+)?(?:([=:<])(.*))?$/,\n\t\t\t\thasPatternsRegExp = /[*?+]/;\n\n\t\t\tif (valid_elements) {\n\t\t\t\t// Split valid elements into an array with rules\n\t\t\t\tvalid_elements = split(valid_elements);\n\n\t\t\t\tif (elements['@']) {\n\t\t\t\t\tglobalAttributes = elements['@'].attributes;\n\t\t\t\t\tglobalAttributesOrder = elements['@'].attributesOrder;\n\t\t\t\t}\n\n\t\t\t\t// Loop all rules\n\t\t\t\tfor (ei = 0, el = valid_elements.length; ei < el; ei++) {\n\t\t\t\t\t// Parse element rule\n\t\t\t\t\tmatches = elementRuleRegExp.exec(valid_elements[ei]);\n\t\t\t\t\tif (matches) {\n\t\t\t\t\t\t// Setup local names for matches\n\t\t\t\t\t\tprefix = matches[1];\n\t\t\t\t\t\telementName = matches[2];\n\t\t\t\t\t\toutputName = matches[3];\n\t\t\t\t\t\tattrData = matches[4];\n\n\t\t\t\t\t\t// Create new attributes and attributesOrder\n\t\t\t\t\t\tattributes = {};\n\t\t\t\t\t\tattributesOrder = [];\n\n\t\t\t\t\t\t// Create the new element\n\t\t\t\t\t\telement = {\n\t\t\t\t\t\t\tattributes : attributes,\n\t\t\t\t\t\t\tattributesOrder : attributesOrder\n\t\t\t\t\t\t};\n\n\t\t\t\t\t\t// Padd empty elements prefix\n\t\t\t\t\t\tif (prefix === '#')\n\t\t\t\t\t\t\telement.paddEmpty = true;\n\n\t\t\t\t\t\t// Remove empty elements prefix\n\t\t\t\t\t\tif (prefix === '-')\n\t\t\t\t\t\t\telement.removeEmpty = true;\n\n\t\t\t\t\t\t// Copy attributes from global rule into current rule\n\t\t\t\t\t\tif (globalAttributes) {\n\t\t\t\t\t\t\tfor (key in globalAttributes)\n\t\t\t\t\t\t\t\tattributes[key] = globalAttributes[key];\n\n\t\t\t\t\t\t\tattributesOrder.push.apply(attributesOrder, globalAttributesOrder);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Attributes defined\n\t\t\t\t\t\tif (attrData) {\n\t\t\t\t\t\t\tattrData = split(attrData, '|');\n\t\t\t\t\t\t\tfor (ai = 0, al = attrData.length; ai < al; ai++) {\n\t\t\t\t\t\t\t\tmatches = attrRuleRegExp.exec(attrData[ai]);\n\t\t\t\t\t\t\t\tif (matches) {\n\t\t\t\t\t\t\t\t\tattr = {};\n\t\t\t\t\t\t\t\t\tattrType = matches[1];\n\t\t\t\t\t\t\t\t\tattrName = matches[2].replace(/::/g, ':');\n\t\t\t\t\t\t\t\t\tprefix = matches[3];\n\t\t\t\t\t\t\t\t\tvalue = matches[4];\n\n\t\t\t\t\t\t\t\t\t// Required\n\t\t\t\t\t\t\t\t\tif (attrType === '!') {\n\t\t\t\t\t\t\t\t\t\telement.attributesRequired = element.attributesRequired || [];\n\t\t\t\t\t\t\t\t\t\telement.attributesRequired.push(attrName);\n\t\t\t\t\t\t\t\t\t\tattr.required = true;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Denied from global\n\t\t\t\t\t\t\t\t\tif (attrType === '-') {\n\t\t\t\t\t\t\t\t\t\tdelete attributes[attrName];\n\t\t\t\t\t\t\t\t\t\tattributesOrder.splice(tinymce.inArray(attributesOrder, attrName), 1);\n\t\t\t\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Default value\n\t\t\t\t\t\t\t\t\tif (prefix) {\n\t\t\t\t\t\t\t\t\t\t// Default value\n\t\t\t\t\t\t\t\t\t\tif (prefix === '=') {\n\t\t\t\t\t\t\t\t\t\t\telement.attributesDefault = element.attributesDefault || [];\n\t\t\t\t\t\t\t\t\t\t\telement.attributesDefault.push({name: attrName, value: value});\n\t\t\t\t\t\t\t\t\t\t\tattr.defaultValue = value;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// Forced value\n\t\t\t\t\t\t\t\t\t\tif (prefix === ':') {\n\t\t\t\t\t\t\t\t\t\t\telement.attributesForced = element.attributesForced || [];\n\t\t\t\t\t\t\t\t\t\t\telement.attributesForced.push({name: attrName, value: value});\n\t\t\t\t\t\t\t\t\t\t\tattr.forcedValue = value;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// Required values\n\t\t\t\t\t\t\t\t\t\tif (prefix === '<')\n\t\t\t\t\t\t\t\t\t\t\tattr.validValues = makeMap(value, '?');\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// Check for attribute patterns\n\t\t\t\t\t\t\t\t\tif (hasPatternsRegExp.test(attrName)) {\n\t\t\t\t\t\t\t\t\t\telement.attributePatterns = element.attributePatterns || [];\n\t\t\t\t\t\t\t\t\t\tattr.pattern = patternToRegExp(attrName);\n\t\t\t\t\t\t\t\t\t\telement.attributePatterns.push(attr);\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\t// Add attribute to order list if it doesn't already exist\n\t\t\t\t\t\t\t\t\t\tif (!attributes[attrName])\n\t\t\t\t\t\t\t\t\t\t\tattributesOrder.push(attrName);\n\n\t\t\t\t\t\t\t\t\t\tattributes[attrName] = attr;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Global rule, store away these for later usage\n\t\t\t\t\t\tif (!globalAttributes && elementName == '@') {\n\t\t\t\t\t\t\tglobalAttributes = attributes;\n\t\t\t\t\t\t\tglobalAttributesOrder = attributesOrder;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Handle substitute elements such as b/strong\n\t\t\t\t\t\tif (outputName) {\n\t\t\t\t\t\t\telement.outputName = elementName;\n\t\t\t\t\t\t\telements[outputName] = element;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Add pattern or exact element\n\t\t\t\t\t\tif (hasPatternsRegExp.test(elementName)) {\n\t\t\t\t\t\t\telement.pattern = patternToRegExp(elementName);\n\t\t\t\t\t\t\tpatternElements.push(element);\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\telements[elementName] = element;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tfunction setValidElements(valid_elements) {\n\t\t\telements = {};\n\t\t\tpatternElements = [];\n\n\t\t\taddValidElements(valid_elements);\n\n\t\t\teach(transitional, function(element, name) {\n\t\t\t\tchildren[name] = element.children;\n\t\t\t});\n\t\t};\n\n\t\t// Adds custom non HTML elements to the schema\n\t\tfunction addCustomElements(custom_elements) {\n\t\t\tvar customElementRegExp = /^(~)?(.+)$/;\n\n\t\t\tif (custom_elements) {\n\t\t\t\teach(split(custom_elements), function(rule) {\n\t\t\t\t\tvar matches = customElementRegExp.exec(rule),\n\t\t\t\t\t\tinline = matches[1] === '~',\n\t\t\t\t\t\tcloneName = inline ? 'span' : 'div',\n\t\t\t\t\t\tname = matches[2];\n\n\t\t\t\t\tchildren[name] = children[cloneName];\n\t\t\t\t\tcustomElementsMap[name] = cloneName;\n\n\t\t\t\t\t// If it's not marked as inline then add it to valid block elements\n\t\t\t\t\tif (!inline)\n\t\t\t\t\t\tblockElementsMap[name] = {};\n\n\t\t\t\t\t// Add custom elements at span/div positions\n\t\t\t\t\teach(children, function(element, child) {\n\t\t\t\t\t\tif (element[cloneName])\n\t\t\t\t\t\t\telement[name] = element[cloneName];\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\t// Adds valid children to the schema object\n\t\tfunction addValidChildren(valid_children) {\n\t\t\tvar childRuleRegExp = /^([+\\-]?)(\\w+)\\[([^\\]]+)\\]$/;\n\n\t\t\tif (valid_children) {\n\t\t\t\teach(split(valid_children), function(rule) {\n\t\t\t\t\tvar matches = childRuleRegExp.exec(rule), parent, prefix;\n\n\t\t\t\t\tif (matches) {\n\t\t\t\t\t\tprefix = matches[1];\n\n\t\t\t\t\t\t// Add/remove items from default\n\t\t\t\t\t\tif (prefix)\n\t\t\t\t\t\t\tparent = children[matches[2]];\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tparent = children[matches[2]] = {'#comment' : {}};\n\n\t\t\t\t\t\tparent = children[matches[2]];\n\n\t\t\t\t\t\teach(split(matches[3], '|'), function(child) {\n\t\t\t\t\t\t\tif (prefix === '-')\n\t\t\t\t\t\t\t\tdelete parent[child];\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tparent[child] = {};\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\tfunction getElementRule(name) {\n\t\t\tvar element = elements[name], i;\n\n\t\t\t// Exact match found\n\t\t\tif (element)\n\t\t\t\treturn element;\n\n\t\t\t// No exact match then try the patterns\n\t\t\ti = patternElements.length;\n\t\t\twhile (i--) {\n\t\t\t\telement = patternElements[i];\n\n\t\t\t\tif (element.pattern.test(name))\n\t\t\t\t\treturn element;\n\t\t\t}\n\t\t};\n\n\t\tif (!settings.valid_elements) {\n\t\t\t// No valid elements defined then clone the elements from the transitional spec\n\t\t\teach(transitional, function(element, name) {\n\t\t\t\telements[name] = {\n\t\t\t\t\tattributes : element.attributes,\n\t\t\t\t\tattributesOrder : element.attributesOrder\n\t\t\t\t};\n\n\t\t\t\tchildren[name] = element.children;\n\t\t\t});\n\n\t\t\t// Switch these\n\t\t\teach(split('strong/b,em/i'), function(item) {\n\t\t\t\titem = split(item, '/');\n\t\t\t\telements[item[1]].outputName = item[0];\n\t\t\t});\n\n\t\t\t// Add default alt attribute for images\n\t\t\telements.img.attributesDefault = [{name: 'alt', value: ''}];\n\n\t\t\t// Remove these if they are empty by default\n\t\t\teach(split('ol,ul,sub,sup,blockquote,span,font,a,table,tbody,tr'), function(name) {\n\t\t\t\telements[name].removeEmpty = true;\n\t\t\t});\n\n\t\t\t// Padd these by default\n\t\t\teach(split('p,h1,h2,h3,h4,h5,h6,th,td,pre,div,address,caption'), function(name) {\n\t\t\t\telements[name].paddEmpty = true;\n\t\t\t});\n\t\t} else\n\t\t\tsetValidElements(settings.valid_elements);\n\n\t\taddCustomElements(settings.custom_elements);\n\t\taddValidChildren(settings.valid_children);\n\t\taddValidElements(settings.extended_valid_elements);\n\n\t\t// Todo: Remove this when we fix list handling to be valid\n\t\taddValidChildren('+ol[ul|ol],+ul[ul|ol]');\n\n\t\t// If the user didn't allow span only allow internal spans\n\t\tif (!getElementRule('span'))\n\t\t\taddValidElements('span[!data-mce-type|*]');\n\n\t\t// Delete invalid elements\n\t\tif (settings.invalid_elements) {\n\t\t\ttinymce.each(tinymce.explode(settings.invalid_elements), function(item) {\n\t\t\t\tif (elements[item])\n\t\t\t\t\tdelete elements[item];\n\t\t\t});\n\t\t}\n\n\t\t/**\n\t\t * Name/value map object with valid parents and children to those parents.\n\t\t *\n\t\t * @example\n\t\t * children = {\n\t\t *    div:{p:{}, h1:{}}\n\t\t * };\n\t\t * @field children\n\t\t * @type {Object}\n\t\t */\n\t\tself.children = children;\n\n\t\t/**\n\t\t * Name/value map object with valid styles for each element.\n\t\t *\n\t\t * @field styles\n\t\t * @type {Object}\n\t\t */\n\t\tself.styles = validStyles;\n\n\t\t/**\n\t\t * Returns a map with boolean attributes.\n\t\t *\n\t\t * @method getBoolAttrs\n\t\t * @return {Object} Name/value lookup map for boolean attributes.\n\t\t */\n\t\tself.getBoolAttrs = function() {\n\t\t\treturn boolAttrMap;\n\t\t};\n\n\t\t/**\n\t\t * Returns a map with block elements.\n\t\t *\n\t\t * @method getBoolAttrs\n\t\t * @return {Object} Name/value lookup map for block elements.\n\t\t */\n\t\tself.getBlockElements = function() {\n\t\t\treturn blockElementsMap;\n\t\t};\n\n\t\t/**\n\t\t * Returns a map with short ended elements such as BR or IMG.\n\t\t *\n\t\t * @method getShortEndedElements\n\t\t * @return {Object} Name/value lookup map for short ended elements.\n\t\t */\n\t\tself.getShortEndedElements = function() {\n\t\t\treturn shortEndedElementsMap;\n\t\t};\n\n\t\t/**\n\t\t * Returns a map with self closing tags such as <li>.\n\t\t *\n\t\t * @method getSelfClosingElements\n\t\t * @return {Object} Name/value lookup map for self closing tags elements.\n\t\t */\n\t\tself.getSelfClosingElements = function() {\n\t\t\treturn selfClosingElementsMap;\n\t\t};\n\n\t\t/**\n\t\t * Returns a map with elements that should be treated as contents regardless if it has text\n\t\t * content in them or not such as TD, VIDEO or IMG.\n\t\t *\n\t\t * @method getNonEmptyElements\n\t\t * @return {Object} Name/value lookup map for non empty elements.\n\t\t */\n\t\tself.getNonEmptyElements = function() {\n\t\t\treturn nonEmptyElementsMap;\n\t\t};\n\n\t\t/**\n\t\t * Returns a map with elements where white space is to be preserved like PRE or SCRIPT.\n\t\t *\n\t\t * @method getWhiteSpaceElements\n\t\t * @return {Object} Name/value lookup map for white space elements.\n\t\t */\n\t\tself.getWhiteSpaceElements = function() {\n\t\t\treturn whiteSpaceElementsMap;\n\t\t};\n\n\t\t/**\n\t\t * Returns true/false if the specified element and it's child is valid or not\n\t\t * according to the schema.\n\t\t *\n\t\t * @method isValidChild\n\t\t * @param {String} name Element name to check for.\n\t\t * @param {String} child Element child to verify.\n\t\t * @return {Boolean} True/false if the element is a valid child of the specified parent.\n\t\t */\n\t\tself.isValidChild = function(name, child) {\n\t\t\tvar parent = children[name];\n\n\t\t\treturn !!(parent && parent[child]);\n\t\t};\n\n\t\t/**\n\t\t * Returns true/false if the specified element is valid or not\n\t\t * according to the schema.\n\t\t *\n\t\t * @method getElementRule\n\t\t * @param {String} name Element name to check for.\n\t\t * @return {Object} Element object or undefined if the element isn't valid.\n\t\t */\n\t\tself.getElementRule = getElementRule;\n\n\t\t/**\n\t\t * Returns an map object of all custom elements.\n\t\t *\n\t\t * @method getCustomElements\n\t\t * @return {Object} Name/value map object of all custom elements.\n\t\t */\n\t\tself.getCustomElements = function() {\n\t\t\treturn customElementsMap;\n\t\t};\n\n\t\t/**\n\t\t * Parses a valid elements string and adds it to the schema. The valid elements format is for example \"element[attr=default|otherattr]\".\n\t\t * Existing rules will be replaced with the ones specified, so this extends the schema.\n\t\t *\n\t\t * @method addValidElements\n\t\t * @param {String} valid_elements String in the valid elements format to be parsed.\n\t\t */\n\t\tself.addValidElements = addValidElements;\n\n\t\t/**\n\t\t * Parses a valid elements string and sets it to the schema. The valid elements format is for example \"element[attr=default|otherattr]\".\n\t\t * Existing rules will be replaced with the ones specified, so this extends the schema.\n\t\t *\n\t\t * @method setValidElements\n\t\t * @param {String} valid_elements String in the valid elements format to be parsed.\n\t\t */\n\t\tself.setValidElements = setValidElements;\n\n\t\t/**\n\t\t * Adds custom non HTML elements to the schema.\n\t\t *\n\t\t * @method addCustomElements\n\t\t * @param {String} custom_elements Comma separated list of custom elements to add.\n\t\t */\n\t\tself.addCustomElements = addCustomElements;\n\n\t\t/**\n\t\t * Parses a valid children string and adds them to the schema structure. The valid children format is for example: \"element[child1|child2]\".\n\t\t *\n\t\t * @method addValidChildren\n\t\t * @param {String} valid_children Valid children elements string to parse\n\t\t */\n\t\tself.addValidChildren = addValidChildren;\n\t};\n\n\t// Expose boolMap and blockElementMap as static properties for usage in DOMUtils\n\ttinymce.html.Schema.boolAttrMap = boolAttrMap;\n\ttinymce.html.Schema.blockElementsMap = blockElementsMap;\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/html/Entities.js":"/**\n * Entities.js\n *\n * Copyright 2010, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\tvar namedEntities, baseEntities, reverseEntities,\n\t\tattrsCharsRegExp = /[&<>\\\"\\u007E-\\uD7FF\\uE000-\\uFFEF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,\n\t\ttextCharsRegExp = /[<>&\\u007E-\\uD7FF\\uE000-\\uFFEF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,\n\t\trawCharsRegExp = /[<>&\\\"\\']/g,\n\t\tentityRegExp = /&(#x|#)?([\\w]+);/g,\n\t\tasciiMap = {\n\t\t\t\t128 : \"\\u20AC\", 130 : \"\\u201A\", 131 : \"\\u0192\", 132 : \"\\u201E\", 133 : \"\\u2026\", 134 : \"\\u2020\",\n\t\t\t\t135 : \"\\u2021\", 136 : \"\\u02C6\", 137 : \"\\u2030\", 138 : \"\\u0160\", 139 : \"\\u2039\", 140 : \"\\u0152\",\n\t\t\t\t142 : \"\\u017D\", 145 : \"\\u2018\", 146 : \"\\u2019\", 147 : \"\\u201C\", 148 : \"\\u201D\", 149 : \"\\u2022\",\n\t\t\t\t150 : \"\\u2013\", 151 : \"\\u2014\", 152 : \"\\u02DC\", 153 : \"\\u2122\", 154 : \"\\u0161\", 155 : \"\\u203A\",\n\t\t\t\t156 : \"\\u0153\", 158 : \"\\u017E\", 159 : \"\\u0178\"\n\t\t};\n\n\t// Raw entities\n\tbaseEntities = {\n\t\t'\\\"' : '&quot;', // Needs to be escaped since the YUI compressor would otherwise break the code\n\t\t\"'\" : '&#39;',\n\t\t'<' : '&lt;',\n\t\t'>' : '&gt;',\n\t\t'&' : '&amp;'\n\t};\n\n\t// Reverse lookup table for raw entities\n\treverseEntities = {\n\t\t'&lt;' : '<',\n\t\t'&gt;' : '>',\n\t\t'&amp;' : '&',\n\t\t'&quot;' : '\"',\n\t\t'&apos;' : \"'\"\n\t};\n\n\t// Decodes text by using the browser\n\tfunction nativeDecode(text) {\n\t\tvar elm;\n\n\t\telm = document.createElement(\"div\");\n\t\telm.innerHTML = text;\n\n\t\treturn elm.textContent || elm.innerText || text;\n\t};\n\n\t// Build a two way lookup table for the entities\n\tfunction buildEntitiesLookup(items, radix) {\n\t\tvar i, chr, entity, lookup = {};\n\n\t\tif (items) {\n\t\t\titems = items.split(',');\n\t\t\tradix = radix || 10;\n\n\t\t\t// Build entities lookup table\n\t\t\tfor (i = 0; i < items.length; i += 2) {\n\t\t\t\tchr = String.fromCharCode(parseInt(items[i], radix));\n\n\t\t\t\t// Only add non base entities\n\t\t\t\tif (!baseEntities[chr]) {\n\t\t\t\t\tentity = '&' + items[i + 1] + ';';\n\t\t\t\t\tlookup[chr] = entity;\n\t\t\t\t\tlookup[entity] = chr;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn lookup;\n\t\t}\n\t};\n\n\t// Unpack entities lookup where the numbers are in radix 32 to reduce the size\n\tnamedEntities = buildEntitiesLookup(\n\t\t'50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,' +\n\t\t'5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,' +\n\t\t'5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,' +\n\t\t'5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,' +\n\t\t'68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,' +\n\t\t'6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,' +\n\t\t'6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,' +\n\t\t'75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,' +\n\t\t'7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,' +\n\t\t'7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,' +\n\t\t'sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,' +\n\t\t'st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,' +\n\t\t't9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,' +\n\t\t'tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,' +\n\t\t'u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,' +\n\t\t'81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,' +\n\t\t'8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,' +\n\t\t'8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,' +\n\t\t'8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,' +\n\t\t'8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,' +\n\t\t'nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,' +\n\t\t'rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,' +\n\t\t'Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,' +\n\t\t'80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,' +\n\t\t'811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro'\n\t, 32);\n\n\ttinymce.html = tinymce.html || {};\n\n\t/**\n\t * Entity encoder class.\n\t *\n\t * @class tinymce.html.SaxParser\n\t * @static\n\t * @version 3.4\n\t */\n\ttinymce.html.Entities = {\n\t\t/**\n\t\t * Encodes the specified string using raw entities. This means only the required XML base entities will be endoded.\n\t\t *\n\t\t * @method encodeRaw\n\t\t * @param {String} text Text to encode.\n\t\t * @param {Boolean} attr Optional flag to specify if the text is attribute contents.\n\t\t * @return {String} Entity encoded text.\n\t\t */\n\t\tencodeRaw : function(text, attr) {\n\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\treturn baseEntities[chr] || chr;\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Encoded the specified text with both the attributes and text entities. This function will produce larger text contents\n\t\t * since it doesn't know if the context is within a attribute or text node. This was added for compatibility\n\t\t * and is exposed as the DOMUtils.encode function.\n\t\t *\n\t\t * @method encodeAllRaw\n\t\t * @param {String} text Text to encode.\n\t\t * @return {String} Entity encoded text.\n\t\t */\n\t\tencodeAllRaw : function(text) {\n\t\t\treturn ('' + text).replace(rawCharsRegExp, function(chr) {\n\t\t\t\treturn baseEntities[chr] || chr;\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Encodes the specified string using numeric entities. The core entities will be encoded as named ones but all non lower ascii characters\n\t\t * will be encoded into numeric entities.\n\t\t *\n\t\t * @method encodeNumeric\n\t\t * @param {String} text Text to encode.\n\t\t * @param {Boolean} attr Optional flag to specify if the text is attribute contents.\n\t\t * @return {String} Entity encoded text.\n\t\t */\n\t\tencodeNumeric : function(text, attr) {\n\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\t// Multi byte sequence convert it to a single entity\n\t\t\t\tif (chr.length > 1)\n\t\t\t\t\treturn '&#' + (((chr.charCodeAt(0) - 0xD800) * 0x400) + (chr.charCodeAt(1) - 0xDC00) + 0x10000) + ';';\n\n\t\t\t\treturn baseEntities[chr] || '&#' + chr.charCodeAt(0) + ';';\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Encodes the specified string using named entities. The core entities will be encoded as named ones but all non lower ascii characters\n\t\t * will be encoded into named entities.\n\t\t *\n\t\t * @method encodeNamed\n\t\t * @param {String} text Text to encode.\n\t\t * @param {Boolean} attr Optional flag to specify if the text is attribute contents.\n\t\t * @param {Object} entities Optional parameter with entities to use.\n\t\t * @return {String} Entity encoded text.\n\t\t */\n\t\tencodeNamed : function(text, attr, entities) {\n\t\t\tentities = entities || namedEntities;\n\n\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\treturn baseEntities[chr] || entities[chr] || chr;\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Returns an encode function based on the name(s) and it's optional entities.\n\t\t *\n\t\t * @method getEncodeFunc\n\t\t * @param {String} name Comma separated list of encoders for example named,numeric.\n\t\t * @param {String} entities Optional parameter with entities to use instead of the built in set.\n\t\t * @return {function} Encode function to be used.\n\t\t */\n\t\tgetEncodeFunc : function(name, entities) {\n\t\t\tvar Entities = tinymce.html.Entities;\n\n\t\t\tentities = buildEntitiesLookup(entities) || namedEntities;\n\n\t\t\tfunction encodeNamedAndNumeric(text, attr) {\n\t\t\t\treturn text.replace(attr ? attrsCharsRegExp : textCharsRegExp, function(chr) {\n\t\t\t\t\treturn baseEntities[chr] || entities[chr] || '&#' + chr.charCodeAt(0) + ';' || chr;\n\t\t\t\t});\n\t\t\t};\n\n\t\t\tfunction encodeCustomNamed(text, attr) {\n\t\t\t\treturn Entities.encodeNamed(text, attr, entities);\n\t\t\t};\n\n\t\t\t// Replace + with , to be compatible with previous TinyMCE versions\n\t\t\tname = tinymce.makeMap(name.replace(/\\+/g, ','));\n\n\t\t\t// Named and numeric encoder\n\t\t\tif (name.named && name.numeric)\n\t\t\t\treturn encodeNamedAndNumeric;\n\n\t\t\t// Named encoder\n\t\t\tif (name.named) {\n\t\t\t\t// Custom names\n\t\t\t\tif (entities)\n\t\t\t\t\treturn encodeCustomNamed;\n\n\t\t\t\treturn Entities.encodeNamed;\n\t\t\t}\n\n\t\t\t// Numeric\n\t\t\tif (name.numeric)\n\t\t\t\treturn Entities.encodeNumeric;\n\n\t\t\t// Raw encoder\n\t\t\treturn Entities.encodeRaw;\n\t\t},\n\n\t\t/**\n\t\t * Decodes the specified string, this will replace entities with raw UTF characters.\n\t\t *\n\t\t * @param {String} text Text to entity decode.\n\t\t * @return {String} Entity decoded string.\n\t\t */\n\t\tdecode : function(text) {\n\t\t\treturn text.replace(entityRegExp, function(all, numeric, value) {\n\t\t\t\tif (numeric) {\n\t\t\t\t\tvalue = parseInt(value, numeric.length === 2 ? 16 : 10);\n\n\t\t\t\t\t// Support upper UTF\n\t\t\t\t\tif (value > 0xFFFF) {\n\t\t\t\t\t\tvalue -= 0x10000;\n\n\t\t\t\t\t\treturn String.fromCharCode(0xD800 + (value >> 10), 0xDC00 + (value & 0x3FF));\n\t\t\t\t\t} else\n\t\t\t\t\t\treturn asciiMap[value] || String.fromCharCode(value);\n\t\t\t\t}\n\n\t\t\t\treturn reverseEntities[all] || namedEntities[all] || nativeDecode(all);\n\t\t\t});\n\t\t}\n\t};\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/html/SaxParser.js":"/**\n * SaxParser.js\n *\n * Copyright 2010, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\t/**\n\t * This class parses HTML code using pure JavaScript and executes various events for each item it finds. It will\n\t * always execute the events in the right order for tag soup code like <b><p></b></p>. It will also remove elements\n\t * and attributes that doesn't fit the schema if the validate setting is enabled.\n\t *\n\t * @example\n\t * var parser = new tinymce.html.SaxParser({\n\t *     validate: true,\n\t *\n\t *     comment: function(text) {\n\t *         console.log('Comment:', text);\n\t *     },\n\t *\n\t *     cdata: function(text) {\n\t *         console.log('CDATA:', text);\n\t *     },\n\t *\n\t *     text: function(text, raw) {\n\t *         console.log('Text:', text, 'Raw:', raw);\n\t *     },\n\t *\n\t *     start: function(name, attrs, empty) {\n\t *         console.log('Start:', name, attrs, empty);\n\t *     },\n\t *\n\t *     end: function(name) {\n\t *         console.log('End:', name);\n\t *     },\n\t *\n\t *     pi: function(name, text) {\n\t *         console.log('PI:', name, text);\n\t *     },\n\t *\n\t *     doctype: function(text) {\n\t *         console.log('DocType:', text);\n\t *     }\n\t * }, schema);\n\t * @class tinymce.html.SaxParser\n\t * @version 3.4\n\t */\n\n\t/**\n\t * Constructs a new SaxParser instance.\n\t *\n\t * @constructor\n\t * @method SaxParser\n\t * @param {Object} settings Name/value collection of settings. comment, cdata, text, start and end are callbacks.\n\t * @param {tinymce.html.Schema} schema HTML Schema class to use when parsing.\n\t */\n\ttinymce.html.SaxParser = function(settings, schema) {\n\t\tvar self = this, noop = function() {};\n\n\t\tsettings = settings || {};\n\t\tself.schema = schema = schema || new tinymce.html.Schema();\n\n\t\tif (settings.fix_self_closing !== false)\n\t\t\tsettings.fix_self_closing = true;\n\n\t\t// Add handler functions from settings and setup default handlers\n\t\ttinymce.each('comment cdata text start end pi doctype'.split(' '), function(name) {\n\t\t\tif (name)\n\t\t\t\tself[name] = settings[name] || noop;\n\t\t});\n\n\t\t/**\n\t\t * Parses the specified HTML string and executes the callbacks for each item it finds.\n\t\t *\n\t\t * @example\n\t\t * new SaxParser({...}).parse('<b>text</b>');\n\t\t * @method parse\n\t\t * @param {String} html Html string to sax parse.\n\t\t */\n\t\tself.parse = function(html) {\n\t\t\tvar self = this, matches, index = 0, value, endRegExp, stack = [], attrList, i, text, name, isInternalElement, removeInternalElements,\n\t\t\t\tshortEndedElements, fillAttrsMap, isShortEnded, validate, elementRule, isValidElement, attr, attribsValue, invalidPrefixRegExp,\n\t\t\t\tvalidAttributesMap, validAttributePatterns, attributesRequired, attributesDefault, attributesForced, selfClosing,\n\t\t\t\ttokenRegExp, attrRegExp, specialElements, attrValue, idCount = 0, decode = tinymce.html.Entities.decode, fixSelfClosing, isIE;\n\n\t\t\tfunction processEndTag(name) {\n\t\t\t\tvar pos, i;\n\n\t\t\t\t// Find position of parent of the same type\n\t\t\t\tpos = stack.length;\n\t\t\t\twhile (pos--) {\n\t\t\t\t\tif (stack[pos].name === name)\n\t\t\t\t\t\tbreak;\t\t\t\t\t\t\n\t\t\t\t}\n\n\t\t\t\t// Found parent\n\t\t\t\tif (pos >= 0) {\n\t\t\t\t\t// Close all the open elements\n\t\t\t\t\tfor (i = stack.length - 1; i >= pos; i--) {\n\t\t\t\t\t\tname = stack[i];\n\n\t\t\t\t\t\tif (name.valid)\n\t\t\t\t\t\t\tself.end(name.name);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove the open elements from the stack\n\t\t\t\t\tstack.length = pos;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Precompile RegExps and map objects\n\t\t\ttokenRegExp = new RegExp('<(?:' +\n\t\t\t\t'(?:!--([\\\\w\\\\W]*?)-->)|' + // Comment\n\t\t\t\t'(?:!\\\\[CDATA\\\\[([\\\\w\\\\W]*?)\\\\]\\\\]>)|' + // CDATA\n\t\t\t\t'(?:!DOCTYPE([\\\\w\\\\W]*?)>)|' + // DOCTYPE\n\t\t\t\t'(?:\\\\?([^\\\\s\\\\/<>]+) ?([\\\\w\\\\W]*?)[?/]>)|' + // PI\n\t\t\t\t'(?:\\\\/([^>]+)>)|' + // End element\n\t\t\t\t'(?:([^\\\\s\\\\/<>]+)((?:\\\\s+[^\"\\'>]+(?:(?:\"[^\"]*\")|(?:\\'[^\\']*\\')|[^>]*))*|\\\\/)>)' + // Start element\n\t\t\t')', 'g');\n\n\t\t\tattrRegExp = /([\\w:\\-]+)(?:\\s*=\\s*(?:(?:\\\"((?:\\\\.|[^\\\"])*)\\\")|(?:\\'((?:\\\\.|[^\\'])*)\\')|([^>\\s]+)))?/g;\n\t\t\tspecialElements = {\n\t\t\t\t'script' : /<\\/script[^>]*>/gi,\n\t\t\t\t'style' : /<\\/style[^>]*>/gi,\n\t\t\t\t'noscript' : /<\\/noscript[^>]*>/gi\n\t\t\t};\n\n\t\t\t// Setup lookup tables for empty elements and boolean attributes\n\t\t\tshortEndedElements = schema.getShortEndedElements();\n\t\t\tselfClosing = schema.getSelfClosingElements();\n\t\t\tfillAttrsMap = schema.getBoolAttrs();\n\t\t\tvalidate = settings.validate;\n\t\t\tremoveInternalElements = settings.remove_internals;\n\t\t\tfixSelfClosing = settings.fix_self_closing;\n\t\t\tisIE = tinymce.isIE;\n\t\t\tinvalidPrefixRegExp = /^:/;\n\n\t\t\twhile (matches = tokenRegExp.exec(html)) {\n\t\t\t\t// Text\n\t\t\t\tif (index < matches.index)\n\t\t\t\t\tself.text(decode(html.substr(index, matches.index - index)));\n\n\t\t\t\tif (value = matches[6]) { // End element\n\t\t\t\t\tvalue = value.toLowerCase();\n\n\t\t\t\t\t// IE will add a \":\" in front of elements it doesn't understand like custom elements or HTML5 elements\n\t\t\t\t\tif (isIE && invalidPrefixRegExp.test(value))\n\t\t\t\t\t\tvalue = value.substr(1);\n\n\t\t\t\t\tprocessEndTag(value);\n\t\t\t\t} else if (value = matches[7]) { // Start element\n\t\t\t\t\tvalue = value.toLowerCase();\n\n\t\t\t\t\t// IE will add a \":\" in front of elements it doesn't understand like custom elements or HTML5 elements\n\t\t\t\t\tif (isIE && invalidPrefixRegExp.test(value))\n\t\t\t\t\t\tvalue = value.substr(1);\n\n\t\t\t\t\tisShortEnded = value in shortEndedElements;\n\n\t\t\t\t\t// Is self closing tag for example an <li> after an open <li>\n\t\t\t\t\tif (fixSelfClosing && selfClosing[value] && stack.length > 0 && stack[stack.length - 1].name === value)\n\t\t\t\t\t\tprocessEndTag(value);\n\n\t\t\t\t\t// Validate element\n\t\t\t\t\tif (!validate || (elementRule = schema.getElementRule(value))) {\n\t\t\t\t\t\tisValidElement = true;\n\n\t\t\t\t\t\t// Grab attributes map and patters when validation is enabled\n\t\t\t\t\t\tif (validate) {\n\t\t\t\t\t\t\tvalidAttributesMap = elementRule.attributes;\n\t\t\t\t\t\t\tvalidAttributePatterns = elementRule.attributePatterns;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Parse attributes\n\t\t\t\t\t\tif (attribsValue = matches[8]) {\n\t\t\t\t\t\t\tisInternalElement = attribsValue.indexOf('data-mce-type') !== -1; // Check if the element is an internal element\n\n\t\t\t\t\t\t\t// If the element has internal attributes then remove it if we are told to do so\n\t\t\t\t\t\t\tif (isInternalElement && removeInternalElements)\n\t\t\t\t\t\t\t\tisValidElement = false;\n\n\t\t\t\t\t\t\tattrList = [];\n\t\t\t\t\t\t\tattrList.map = {};\n\n\t\t\t\t\t\t\tattribsValue.replace(attrRegExp, function(match, name, value, val2, val3) {\n\t\t\t\t\t\t\t\tvar attrRule, i;\n\n\t\t\t\t\t\t\t\tname = name.toLowerCase();\n\t\t\t\t\t\t\t\tvalue = name in fillAttrsMap ? name : decode(value || val2 || val3 || ''); // Handle boolean attribute than value attribute\n\n\t\t\t\t\t\t\t\t// Validate name and value\n\t\t\t\t\t\t\t\tif (validate && !isInternalElement && name.indexOf('data-') !== 0) {\n\t\t\t\t\t\t\t\t\tattrRule = validAttributesMap[name];\n\n\t\t\t\t\t\t\t\t\t// Find rule by pattern matching\n\t\t\t\t\t\t\t\t\tif (!attrRule && validAttributePatterns) {\n\t\t\t\t\t\t\t\t\t\ti = validAttributePatterns.length;\n\t\t\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\t\t\tattrRule = validAttributePatterns[i];\n\t\t\t\t\t\t\t\t\t\t\tif (attrRule.pattern.test(name))\n\t\t\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t\t// No rule matched\n\t\t\t\t\t\t\t\t\t\tif (i === -1)\n\t\t\t\t\t\t\t\t\t\t\tattrRule = null;\n\t\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t\t// No attribute rule found\n\t\t\t\t\t\t\t\t\tif (!attrRule)\n\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t// Validate value\n\t\t\t\t\t\t\t\t\tif (attrRule.validValues && !(value in attrRule.validValues))\n\t\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Add attribute to list and map\n\t\t\t\t\t\t\t\tattrList.map[name] = value;\n\t\t\t\t\t\t\t\tattrList.push({\n\t\t\t\t\t\t\t\t\tname: name,\n\t\t\t\t\t\t\t\t\tvalue: value\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tattrList = [];\n\t\t\t\t\t\t\tattrList.map = {};\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Process attributes if validation is enabled\n\t\t\t\t\t\tif (validate && !isInternalElement) {\n\t\t\t\t\t\t\tattributesRequired = elementRule.attributesRequired;\n\t\t\t\t\t\t\tattributesDefault = elementRule.attributesDefault;\n\t\t\t\t\t\t\tattributesForced = elementRule.attributesForced;\n\n\t\t\t\t\t\t\t// Handle forced attributes\n\t\t\t\t\t\t\tif (attributesForced) {\n\t\t\t\t\t\t\t\ti = attributesForced.length;\n\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\tattr = attributesForced[i];\n\t\t\t\t\t\t\t\t\tname = attr.name;\n\t\t\t\t\t\t\t\t\tattrValue = attr.value;\n\n\t\t\t\t\t\t\t\t\tif (attrValue === '{$uid}')\n\t\t\t\t\t\t\t\t\t\tattrValue = 'mce_' + idCount++;\n\n\t\t\t\t\t\t\t\t\tattrList.map[name] = attrValue;\n\t\t\t\t\t\t\t\t\tattrList.push({name: name, value: attrValue});\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Handle default attributes\n\t\t\t\t\t\t\tif (attributesDefault) {\n\t\t\t\t\t\t\t\ti = attributesDefault.length;\n\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\tattr = attributesDefault[i];\n\t\t\t\t\t\t\t\t\tname = attr.name;\n\n\t\t\t\t\t\t\t\t\tif (!(name in attrList.map)) {\n\t\t\t\t\t\t\t\t\t\tattrValue = attr.value;\n\n\t\t\t\t\t\t\t\t\t\tif (attrValue === '{$uid}')\n\t\t\t\t\t\t\t\t\t\t\tattrValue = 'mce_' + idCount++;\n\n\t\t\t\t\t\t\t\t\t\tattrList.map[name] = attrValue;\n\t\t\t\t\t\t\t\t\t\tattrList.push({name: name, value: attrValue});\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Handle required attributes\n\t\t\t\t\t\t\tif (attributesRequired) {\n\t\t\t\t\t\t\t\ti = attributesRequired.length;\n\t\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\t\tif (attributesRequired[i] in attrList.map)\n\t\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// None of the required attributes where found\n\t\t\t\t\t\t\t\tif (i === -1)\n\t\t\t\t\t\t\t\t\tisValidElement = false;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Invalidate element if it's marked as bogus\n\t\t\t\t\t\t\tif (attrList.map['data-mce-bogus'])\n\t\t\t\t\t\t\t\tisValidElement = false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (isValidElement)\n\t\t\t\t\t\t\tself.start(value, attrList, isShortEnded);\n\t\t\t\t\t} else\n\t\t\t\t\t\tisValidElement = false;\n\n\t\t\t\t\t// Treat script, noscript and style a bit different since they may include code that looks like elements\n\t\t\t\t\tif (endRegExp = specialElements[value]) {\n\t\t\t\t\t\tendRegExp.lastIndex = index = matches.index + matches[0].length;\n\n\t\t\t\t\t\tif (matches = endRegExp.exec(html)) {\n\t\t\t\t\t\t\tif (isValidElement)\n\t\t\t\t\t\t\t\ttext = html.substr(index, matches.index - index);\n\n\t\t\t\t\t\t\tindex = matches.index + matches[0].length;\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\ttext = html.substr(index);\n\t\t\t\t\t\t\tindex = html.length;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (isValidElement && text.length > 0)\n\t\t\t\t\t\t\tself.text(text, true);\n\n\t\t\t\t\t\tif (isValidElement)\n\t\t\t\t\t\t\tself.end(value);\n\n\t\t\t\t\t\ttokenRegExp.lastIndex = index;\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Push value on to stack\n\t\t\t\t\tif (!isShortEnded) {\n\t\t\t\t\t\tif (!attribsValue || attribsValue.indexOf('/') != attribsValue.length - 1)\n\t\t\t\t\t\t\tstack.push({name: value, valid: isValidElement});\n\t\t\t\t\t\telse if (isValidElement)\n\t\t\t\t\t\t\tself.end(value);\n\t\t\t\t\t}\n\t\t\t\t} else if (value = matches[1]) { // Comment\n\t\t\t\t\tself.comment(value);\n\t\t\t\t} else if (value = matches[2]) { // CDATA\n\t\t\t\t\tself.cdata(value);\n\t\t\t\t} else if (value = matches[3]) { // DOCTYPE\n\t\t\t\t\tself.doctype(value);\n\t\t\t\t} else if (value = matches[4]) { // PI\n\t\t\t\t\tself.pi(value, matches[5]);\n\t\t\t\t}\n\n\t\t\t\tindex = matches.index + matches[0].length;\n\t\t\t}\n\n\t\t\t// Text\n\t\t\tif (index < html.length)\n\t\t\t\tself.text(decode(html.substr(index)));\n\n\t\t\t// Close any open elements\n\t\t\tfor (i = stack.length - 1; i >= 0; i--) {\n\t\t\t\tvalue = stack[i];\n\n\t\t\t\tif (value.valid)\n\t\t\t\t\tself.end(value.name);\n\t\t\t}\n\t\t};\n\t}\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/html/DomParser.js":"/**\n * DomParser.js\n *\n * Copyright 2010, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\tvar Node = tinymce.html.Node;\n\n\t/**\n\t * This class parses HTML code into a DOM like structure of nodes it will remove redundant whitespace and make\n\t * sure that the node tree is valid according to the specified schema. So for example: <p>a<p>b</p>c</p> will become <p>a</p><p>b</p><p>c</p>\n\t *\n\t * @example\n\t * var parser = new tinymce.html.DomParser({validate: true}, schema);\n\t * var rootNode = parser.parse('<h1>content</h1>');\n\t *\n\t * @class tinymce.html.DomParser\n\t * @version 3.4\n\t */\n\n\t/**\n\t * Constructs a new DomParser instance.\n\t *\n\t * @constructor\n\t * @method DomParser\n\t * @param {Object} settings Name/value collection of settings. comment, cdata, text, start and end are callbacks.\n\t * @param {tinymce.html.Schema} schema HTML Schema class to use when parsing.\n\t */\n\ttinymce.html.DomParser = function(settings, schema) {\n\t\tvar self = this, nodeFilters = {}, attributeFilters = [], matchedNodes = {}, matchedAttributes = {};\n\n\t\tsettings = settings || {};\n\t\tsettings.validate = \"validate\" in settings ? settings.validate : true;\n\t\tsettings.root_name = settings.root_name || 'body';\n\t\tself.schema = schema = schema || new tinymce.html.Schema();\n\n\t\tfunction fixInvalidChildren(nodes) {\n\t\t\tvar ni, node, parent, parents, newParent, currentNode, tempNode, childNode, i,\n\t\t\t\tchildClone, nonEmptyElements, nonSplitableElements, sibling, nextNode;\n\n\t\t\tnonSplitableElements = tinymce.makeMap('tr,td,th,tbody,thead,tfoot,table');\n\t\t\tnonEmptyElements = schema.getNonEmptyElements();\n\n\t\t\tfor (ni = 0; ni < nodes.length; ni++) {\n\t\t\t\tnode = nodes[ni];\n\n\t\t\t\t// Already removed\n\t\t\t\tif (!node.parent)\n\t\t\t\t\tcontinue;\n\n\t\t\t\t// Get list of all parent nodes until we find a valid parent to stick the child into\n\t\t\t\tparents = [node];\n\t\t\t\tfor (parent = node.parent; parent && !schema.isValidChild(parent.name, node.name) && !nonSplitableElements[parent.name]; parent = parent.parent)\n\t\t\t\t\tparents.push(parent);\n\n\t\t\t\t// Found a suitable parent\n\t\t\t\tif (parent && parents.length > 1) {\n\t\t\t\t\t// Reverse the array since it makes looping easier\n\t\t\t\t\tparents.reverse();\n\n\t\t\t\t\t// Clone the related parent and insert that after the moved node\n\t\t\t\t\tnewParent = currentNode = self.filterNode(parents[0].clone());\n\n\t\t\t\t\t// Start cloning and moving children on the left side of the target node\n\t\t\t\t\tfor (i = 0; i < parents.length - 1; i++) {\n\t\t\t\t\t\tif (schema.isValidChild(currentNode.name, parents[i].name)) {\n\t\t\t\t\t\t\ttempNode = self.filterNode(parents[i].clone());\n\t\t\t\t\t\t\tcurrentNode.append(tempNode);\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\ttempNode = currentNode;\n\n\t\t\t\t\t\tfor (childNode = parents[i].firstChild; childNode && childNode != parents[i + 1]; ) {\n\t\t\t\t\t\t\tnextNode = childNode.next;\n\t\t\t\t\t\t\ttempNode.append(childNode);\n\t\t\t\t\t\t\tchildNode = nextNode;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tcurrentNode = tempNode;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!newParent.isEmpty(nonEmptyElements)) {\n\t\t\t\t\t\tparent.insert(newParent, parents[0], true);\n\t\t\t\t\t\tparent.insert(node, newParent);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tparent.insert(node, parents[0], true);\n\t\t\t\t\t}\n\n\t\t\t\t\t// Check if the element is empty by looking through it's contents and special treatment for <p><br /></p>\n\t\t\t\t\tparent = parents[0];\n\t\t\t\t\tif (parent.isEmpty(nonEmptyElements) || parent.firstChild === parent.lastChild && parent.firstChild.name === 'br') {\n\t\t\t\t\t\tparent.empty().remove();\n\t\t\t\t\t}\n\t\t\t\t} else if (node.parent) {\n\t\t\t\t\t// If it's an LI try to find a UL/OL for it or wrap it\n\t\t\t\t\tif (node.name === 'li') {\n\t\t\t\t\t\tsibling = node.prev;\n\t\t\t\t\t\tif (sibling && (sibling.name === 'ul' || sibling.name === 'ul')) {\n\t\t\t\t\t\t\tsibling.append(node);\n\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tsibling = node.next;\n\t\t\t\t\t\tif (sibling && (sibling.name === 'ul' || sibling.name === 'ul')) {\n\t\t\t\t\t\t\tsibling.insert(node, sibling.firstChild, true);\n\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tnode.wrap(self.filterNode(new Node('ul', 1)));\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Try wrapping the element in a DIV\n\t\t\t\t\tif (schema.isValidChild(node.parent.name, 'div') && schema.isValidChild('div', node.name)) {\n\t\t\t\t\t\tnode.wrap(self.filterNode(new Node('div', 1)));\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// We failed wrapping it, then remove or unwrap it\n\t\t\t\t\t\tif (node.name === 'style' || node.name === 'script')\n\t\t\t\t\t\t\tnode.empty().remove();\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tnode.unwrap();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\t/**\n\t\t * Runs the specified node though the element and attributes filters.\n\t\t *\n\t\t * @param {tinymce.html.Node} Node the node to run filters on.\n\t\t * @return {tinymce.html.Node} The passed in node.\n\t\t */\n\t\tself.filterNode = function(node) {\n\t\t\tvar i, name, list;\n\n\t\t\t// Run element filters\n\t\t\tif (name in nodeFilters) {\n\t\t\t\tlist = matchedNodes[name];\n\n\t\t\t\tif (list)\n\t\t\t\t\tlist.push(node);\n\t\t\t\telse\n\t\t\t\t\tmatchedNodes[name] = [node];\n\t\t\t}\n\n\t\t\t// Run attribute filters\n\t\t\ti = attributeFilters.length;\n\t\t\twhile (i--) {\n\t\t\t\tname = attributeFilters[i].name;\n\n\t\t\t\tif (name in node.attributes.map) {\n\t\t\t\t\tlist = matchedAttributes[name];\n\n\t\t\t\t\tif (list)\n\t\t\t\t\t\tlist.push(node);\n\t\t\t\t\telse\n\t\t\t\t\t\tmatchedAttributes[name] = [node];\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn node;\n\t\t};\n\n\t\t/**\n\t\t * Adds a node filter function to the parser, the parser will collect the specified nodes by name\n\t\t * and then execute the callback ones it has finished parsing the document.\n\t\t *\n\t\t * @example\n\t\t * parser.addNodeFilter('p,h1', function(nodes, name) {\n\t\t *\t\tfor (var i = 0; i < nodes.length; i++) {\n\t\t *\t\t\tconsole.log(nodes[i].name);\n\t\t *\t\t}\n\t\t * });\n\t\t * @method addNodeFilter\n\t\t * @method {String} name Comma separated list of nodes to collect.\n\t\t * @param {function} callback Callback function to execute once it has collected nodes.\n\t\t */\n\t\tself.addNodeFilter = function(name, callback) {\n\t\t\ttinymce.each(tinymce.explode(name), function(name) {\n\t\t\t\tvar list = nodeFilters[name];\n\n\t\t\t\tif (!list)\n\t\t\t\t\tnodeFilters[name] = list = [];\n\n\t\t\t\tlist.push(callback);\n\t\t\t});\n\t\t};\n\n\t\t/**\n\t\t * Adds a attribute filter function to the parser, the parser will collect nodes that has the specified attributes\n\t\t * and then execute the callback ones it has finished parsing the document.\n\t\t *\n\t\t * @example\n\t\t * parser.addAttributeFilter('src,href', function(nodes, name) {\n\t\t *\t\tfor (var i = 0; i < nodes.length; i++) {\n\t\t *\t\t\tconsole.log(nodes[i].name);\n\t\t *\t\t}\n\t\t * });\n\t\t * @method addAttributeFilter\n\t\t * @method {String} name Comma separated list of nodes to collect.\n\t\t * @param {function} callback Callback function to execute once it has collected nodes.\n\t\t */\n\t\tself.addAttributeFilter = function(name, callback) {\n\t\t\ttinymce.each(tinymce.explode(name), function(name) {\n\t\t\t\tvar i;\n\n\t\t\t\tfor (i = 0; i < attributeFilters.length; i++) {\n\t\t\t\t\tif (attributeFilters[i].name === name) {\n\t\t\t\t\t\tattributeFilters[i].callbacks.push(callback);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tattributeFilters.push({name: name, callbacks: [callback]});\n\t\t\t});\n\t\t};\n\n\t\t/**\n\t\t * Parses the specified HTML string into a DOM like node tree and returns the result.\n\t\t *\n\t\t * @example\n\t\t * var rootNode = new DomParser({...}).parse('<b>text</b>');\n\t\t * @method parse\n\t\t * @param {String} html Html string to sax parse.\n\t\t * @param {Object} args Optional args object that gets passed to all filter functions.\n\t\t * @return {tinymce.html.Node} Root node containing the tree.\n\t\t */\n\t\tself.parse = function(html, args) {\n\t\t\tvar parser, rootNode, node, nodes, i, l, fi, fl, list, name, validate,\n\t\t\t\tblockElements, startWhiteSpaceRegExp, invalidChildren = [],\n\t\t\t\tendWhiteSpaceRegExp, allWhiteSpaceRegExp, whiteSpaceElements, children, nonEmptyElements, rootBlockName;\n\n\t\t\targs = args || {};\n\t\t\tmatchedNodes = {};\n\t\t\tmatchedAttributes = {};\n\t\t\tblockElements = tinymce.extend(tinymce.makeMap('script,style,head,html,body,title,meta,param'), schema.getBlockElements());\n\t\t\tnonEmptyElements = schema.getNonEmptyElements();\n\t\t\tchildren = schema.children;\n\t\t\tvalidate = settings.validate;\n\t\t\trootBlockName = \"forced_root_block\" in args ? args.forced_root_block : settings.forced_root_block;\n\n\t\t\twhiteSpaceElements = schema.getWhiteSpaceElements();\n\t\t\tstartWhiteSpaceRegExp = /^[ \\t\\r\\n]+/;\n\t\t\tendWhiteSpaceRegExp = /[ \\t\\r\\n]+$/;\n\t\t\tallWhiteSpaceRegExp = /[ \\t\\r\\n]+/g;\n\n\t\t\tfunction addRootBlocks() {\n\t\t\t\tvar node = rootNode.firstChild, next, rootBlockNode;\n\n\t\t\t\twhile (node) {\n\t\t\t\t\tnext = node.next;\n\n\t\t\t\t\tif (node.type == 3 || (node.type == 1 && node.name !== 'p' && !blockElements[node.name] && !node.attr('data-mce-type'))) {\n\t\t\t\t\t\tif (!rootBlockNode) {\n\t\t\t\t\t\t\t// Create a new root block element\n\t\t\t\t\t\t\trootBlockNode = createNode(rootBlockName, 1);\n\t\t\t\t\t\t\trootNode.insert(rootBlockNode, node);\n\t\t\t\t\t\t\trootBlockNode.append(node);\n\t\t\t\t\t\t} else\n\t\t\t\t\t\t\trootBlockNode.append(node);\n\t\t\t\t\t} else {\n\t\t\t\t\t\trootBlockNode = null;\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = next;\n\t\t\t\t};\n\t\t\t};\n\n\t\t\tfunction createNode(name, type) {\n\t\t\t\tvar node = new Node(name, type), list;\n\n\t\t\t\tif (name in nodeFilters) {\n\t\t\t\t\tlist = matchedNodes[name];\n\n\t\t\t\t\tif (list)\n\t\t\t\t\t\tlist.push(node);\n\t\t\t\t\telse\n\t\t\t\t\t\tmatchedNodes[name] = [node];\n\t\t\t\t}\n\n\t\t\t\treturn node;\n\t\t\t};\n\n\t\t\tfunction removeWhitespaceBefore(node) {\n\t\t\t\tvar textNode, textVal, sibling;\n\n\t\t\t\tfor (textNode = node.prev; textNode && textNode.type === 3; ) {\n\t\t\t\t\ttextVal = textNode.value.replace(endWhiteSpaceRegExp, '');\n\n\t\t\t\t\tif (textVal.length > 0) {\n\t\t\t\t\t\ttextNode.value = textVal;\n\t\t\t\t\t\ttextNode = textNode.prev;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tsibling = textNode.prev;\n\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\ttextNode = sibling;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tparser = new tinymce.html.SaxParser({\n\t\t\t\tvalidate : validate,\n\t\t\t\tfix_self_closing : !validate, // Let the DOM parser handle <li> in <li> or <p> in <p> for better results\n\n\t\t\t\tcdata: function(text) {\n\t\t\t\t\tnode.append(createNode('#cdata', 4)).value = text;\n\t\t\t\t},\n\n\t\t\t\ttext: function(text, raw) {\n\t\t\t\t\tvar textNode;\n\n\t\t\t\t\t// Trim all redundant whitespace on non white space elements\n\t\t\t\t\tif (!whiteSpaceElements[node.name]) {\n\t\t\t\t\t\ttext = text.replace(allWhiteSpaceRegExp, ' ');\n\n\t\t\t\t\t\tif (node.lastChild && blockElements[node.lastChild.name])\n\t\t\t\t\t\t\ttext = text.replace(startWhiteSpaceRegExp, '');\n\t\t\t\t\t}\n\n\t\t\t\t\t// Do we need to create the node\n\t\t\t\t\tif (text.length !== 0) {\n\t\t\t\t\t\ttextNode = createNode('#text', 3);\n\t\t\t\t\t\ttextNode.raw = !!raw;\n\t\t\t\t\t\tnode.append(textNode).value = text;\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tcomment: function(text) {\n\t\t\t\t\tnode.append(createNode('#comment', 8)).value = text;\n\t\t\t\t},\n\n\t\t\t\tpi: function(name, text) {\n\t\t\t\t\tnode.append(createNode(name, 7)).value = text;\n\t\t\t\t\tremoveWhitespaceBefore(node);\n\t\t\t\t},\n\n\t\t\t\tdoctype: function(text) {\n\t\t\t\t\tvar newNode;\n\t\t\n\t\t\t\t\tnewNode = node.append(createNode('#doctype', 10));\n\t\t\t\t\tnewNode.value = text;\n\t\t\t\t\tremoveWhitespaceBefore(node);\n\t\t\t\t},\n\n\t\t\t\tstart: function(name, attrs, empty) {\n\t\t\t\t\tvar newNode, attrFiltersLen, elementRule, textNode, attrName, text, sibling, parent;\n\n\t\t\t\t\telementRule = validate ? schema.getElementRule(name) : {};\n\t\t\t\t\tif (elementRule) {\n\t\t\t\t\t\tnewNode = createNode(elementRule.outputName || name, 1);\n\t\t\t\t\t\tnewNode.attributes = attrs;\n\t\t\t\t\t\tnewNode.shortEnded = empty;\n\n\t\t\t\t\t\tnode.append(newNode);\n\n\t\t\t\t\t\t// Check if node is valid child of the parent node is the child is\n\t\t\t\t\t\t// unknown we don't collect it since it's probably a custom element\n\t\t\t\t\t\tparent = children[node.name];\n\t\t\t\t\t\tif (parent && children[newNode.name] && !parent[newNode.name])\n\t\t\t\t\t\t\tinvalidChildren.push(newNode);\n\n\t\t\t\t\t\tattrFiltersLen = attributeFilters.length;\n\t\t\t\t\t\twhile (attrFiltersLen--) {\n\t\t\t\t\t\t\tattrName = attributeFilters[attrFiltersLen].name;\n\n\t\t\t\t\t\t\tif (attrName in attrs.map) {\n\t\t\t\t\t\t\t\tlist = matchedAttributes[attrName];\n\n\t\t\t\t\t\t\t\tif (list)\n\t\t\t\t\t\t\t\t\tlist.push(newNode);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\tmatchedAttributes[attrName] = [newNode];\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Trim whitespace before block\n\t\t\t\t\t\tif (blockElements[name])\n\t\t\t\t\t\t\tremoveWhitespaceBefore(newNode);\n\n\t\t\t\t\t\t// Change current node if the element wasn't empty i.e not <br /> or <img />\n\t\t\t\t\t\tif (!empty)\n\t\t\t\t\t\t\tnode = newNode;\n\t\t\t\t\t}\n\t\t\t\t},\n\n\t\t\t\tend: function(name) {\n\t\t\t\t\tvar textNode, elementRule, text, sibling, tempNode;\n\n\t\t\t\t\telementRule = validate ? schema.getElementRule(name) : {};\n\t\t\t\t\tif (elementRule) {\n\t\t\t\t\t\tif (blockElements[name]) {\n\t\t\t\t\t\t\tif (!whiteSpaceElements[node.name]) {\n\t\t\t\t\t\t\t\t// Trim whitespace at beginning of block\n\t\t\t\t\t\t\t\tfor (textNode = node.firstChild; textNode && textNode.type === 3; ) {\n\t\t\t\t\t\t\t\t\ttext = textNode.value.replace(startWhiteSpaceRegExp, '');\n\n\t\t\t\t\t\t\t\t\tif (text.length > 0) {\n\t\t\t\t\t\t\t\t\t\ttextNode.value = text;\n\t\t\t\t\t\t\t\t\t\ttextNode = textNode.next;\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tsibling = textNode.next;\n\t\t\t\t\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\t\t\t\t\ttextNode = sibling;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Trim whitespace at end of block\n\t\t\t\t\t\t\t\tfor (textNode = node.lastChild; textNode && textNode.type === 3; ) {\n\t\t\t\t\t\t\t\t\ttext = textNode.value.replace(endWhiteSpaceRegExp, '');\n\n\t\t\t\t\t\t\t\t\tif (text.length > 0) {\n\t\t\t\t\t\t\t\t\t\ttextNode.value = text;\n\t\t\t\t\t\t\t\t\t\ttextNode = textNode.prev;\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tsibling = textNode.prev;\n\t\t\t\t\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\t\t\t\t\ttextNode = sibling;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Trim start white space\n\t\t\t\t\t\t\ttextNode = node.prev;\n\t\t\t\t\t\t\tif (textNode && textNode.type === 3) {\n\t\t\t\t\t\t\t\ttext = textNode.value.replace(startWhiteSpaceRegExp, '');\n\n\t\t\t\t\t\t\t\tif (text.length > 0)\n\t\t\t\t\t\t\t\t\ttextNode.value = text;\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\ttextNode.remove();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Handle empty nodes\n\t\t\t\t\t\tif (elementRule.removeEmpty || elementRule.paddEmpty) {\n\t\t\t\t\t\t\tif (node.isEmpty(nonEmptyElements)) {\n\t\t\t\t\t\t\t\tif (elementRule.paddEmpty)\n\t\t\t\t\t\t\t\t\tnode.empty().append(new Node('#text', '3')).value = '\\u00a0';\n\t\t\t\t\t\t\t\telse {\n\t\t\t\t\t\t\t\t\t// Leave nodes that have a name like <a name=\"name\">\n\t\t\t\t\t\t\t\t\tif (!node.attributes.map.name) {\n\t\t\t\t\t\t\t\t\t\ttempNode = node.parent;\n\t\t\t\t\t\t\t\t\t\tnode.empty().remove();\n\t\t\t\t\t\t\t\t\t\tnode = tempNode;\n\t\t\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tnode = node.parent;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}, schema);\n\n\t\t\trootNode = node = new Node(args.context || settings.root_name, 11);\n\n\t\t\tparser.parse(html);\n\n\t\t\t// Fix invalid children or report invalid children in a contextual parsing\n\t\t\tif (validate && invalidChildren.length) {\n\t\t\t\tif (!args.context)\n\t\t\t\t\tfixInvalidChildren(invalidChildren);\n\t\t\t\telse\n\t\t\t\t\targs.invalid = true;\n\t\t\t}\n\n\t\t\t// Wrap nodes in the root into block elements if the root is body\n\t\t\tif (rootBlockName && rootNode.name == 'body')\n\t\t\t\taddRootBlocks();\n\n\t\t\t// Run filters only when the contents is valid\n\t\t\tif (!args.invalid) {\n\t\t\t\t// Run node filters\n\t\t\t\tfor (name in matchedNodes) {\n\t\t\t\t\tlist = nodeFilters[name];\n\t\t\t\t\tnodes = matchedNodes[name];\n\n\t\t\t\t\t// Remove already removed children\n\t\t\t\t\tfi = nodes.length;\n\t\t\t\t\twhile (fi--) {\n\t\t\t\t\t\tif (!nodes[fi].parent)\n\t\t\t\t\t\t\tnodes.splice(fi, 1);\n\t\t\t\t\t}\n\n\t\t\t\t\tfor (i = 0, l = list.length; i < l; i++)\n\t\t\t\t\t\tlist[i](nodes, name, args);\n\t\t\t\t}\n\n\t\t\t\t// Run attribute filters\n\t\t\t\tfor (i = 0, l = attributeFilters.length; i < l; i++) {\n\t\t\t\t\tlist = attributeFilters[i];\n\n\t\t\t\t\tif (list.name in matchedAttributes) {\n\t\t\t\t\t\tnodes = matchedAttributes[list.name];\n\n\t\t\t\t\t\t// Remove already removed children\n\t\t\t\t\t\tfi = nodes.length;\n\t\t\t\t\t\twhile (fi--) {\n\t\t\t\t\t\t\tif (!nodes[fi].parent)\n\t\t\t\t\t\t\t\tnodes.splice(fi, 1);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfor (fi = 0, fl = list.callbacks.length; fi < fl; fi++)\n\t\t\t\t\t\t\tlist.callbacks[fi](nodes, list.name, args);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn rootNode;\n\t\t};\n\n\t\t// Remove <br> at end of block elements Gecko and WebKit injects BR elements to\n\t\t// make it possible to place the caret inside empty blocks. This logic tries to remove\n\t\t// these elements and keep br elements that where intended to be there intact\n\t\tif (settings.remove_trailing_brs) {\n\t\t\tself.addNodeFilter('br', function(nodes, name) {\n\t\t\t\tvar i, l = nodes.length, node, blockElements = schema.getBlockElements(),\n\t\t\t\t\tnonEmptyElements = schema.getNonEmptyElements(), parent, prev, prevName;\n\n\t\t\t\t// Remove brs from body element as well\n\t\t\t\tblockElements.body = 1;\n\n\t\t\t\t// Must loop forwards since it will otherwise remove all brs in <p>a<br><br><br></p>\n\t\t\t\tfor (i = 0; i < l; i++) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tparent = node.parent;\n\n\t\t\t\t\tif (blockElements[node.parent.name] && node === parent.lastChild) {\n\t\t\t\t\t\t// Loop all nodes to the right of the current node and check for other BR elements\n\t\t\t\t\t\t// excluding bookmarks since they are invisible\n\t\t\t\t\t\tprev = node.prev;\n\t\t\t\t\t\twhile (prev) {\n\t\t\t\t\t\t\tprevName = prev.name;\n\n\t\t\t\t\t\t\t// Ignore bookmarks\n\t\t\t\t\t\t\tif (prevName !== \"span\" || prev.attr('data-mce-type') !== 'bookmark') {\n\t\t\t\t\t\t\t\t// Found a non BR element\n\t\t\t\t\t\t\t\tif (prevName !== \"br\")\n\t\t\t\t\t\t\t\t\tbreak;\n\t\n\t\t\t\t\t\t\t\t// Found another br it's a <br><br> structure then don't remove anything\n\t\t\t\t\t\t\t\tif (prevName === 'br') {\n\t\t\t\t\t\t\t\t\tnode = null;\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tprev = prev.prev;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (node) {\n\t\t\t\t\t\t\tnode.remove();\n\n\t\t\t\t\t\t\t// Is the parent to be considered empty after we removed the BR\n\t\t\t\t\t\t\tif (parent.isEmpty(nonEmptyElements)) {\n\t\t\t\t\t\t\t\telementRule = schema.getElementRule(parent.name);\n\n\t\t\t\t\t\t\t\t// Remove or padd the element depending on schema rule\n\t\t\t\t\t\t\t\tif (elementRule) {\n\t\t\t\t\t\t\t\t  if (elementRule.removeEmpty)\n\t\t\t\t\t\t\t\t\t  parent.remove();\n\t\t\t\t\t\t\t\t  else if (elementRule.paddEmpty)\n\t\t\t\t\t\t\t\t\t  parent.empty().append(new tinymce.html.Node('#text', 3)).value = '\\u00a0';\n\t\t\t\t\t\t\t  }\n              }\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t}\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/html/Serializer.js":"/**\n * Serializer.js\n *\n * Copyright 2010, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\t/**\n\t * This class is used to serialize down the DOM tree into a string using a Writer instance.\n\t *\n\t *\n\t * @example\n\t * new tinymce.html.Serializer().serialize(new tinymce.html.DomParser().parse('<p>text</p>'));\n\t * @class tinymce.html.Serializer\n\t * @version 3.4\n\t */\n\n\t/**\n\t * Constructs a new Serializer instance.\n\t *\n\t * @constructor\n\t * @method Serializer\n\t * @param {Object} settings Name/value settings object.\n\t * @param {tinymce.html.Schema} schema Schema instance to use.\n\t */\n\ttinymce.html.Serializer = function(settings, schema) {\n\t\tvar self = this, writer = new tinymce.html.Writer(settings);\n\n\t\tsettings = settings || {};\n\t\tsettings.validate = \"validate\" in settings ? settings.validate : true;\n\n\t\tself.schema = schema = schema || new tinymce.html.Schema();\n\t\tself.writer = writer;\n\n\t\t/**\n\t\t * Serializes the specified node into a string.\n\t\t *\n\t\t * @example\n\t\t * new tinymce.html.Serializer().serialize(new tinymce.html.DomParser().parse('<p>text</p>'));\n\t\t * @method serialize\n\t\t * @param {tinymce.html.Node} node Node instance to serialize.\n\t\t * @return {String} String with HTML based on DOM tree.\n\t\t */\n\t\tself.serialize = function(node) {\n\t\t\tvar handlers, validate;\n\n\t\t\tvalidate = settings.validate;\n\n\t\t\thandlers = {\n\t\t\t\t// #text\n\t\t\t\t3: function(node, raw) {\n\t\t\t\t\twriter.text(node.value, node.raw);\n\t\t\t\t},\n\n\t\t\t\t// #comment\n\t\t\t\t8: function(node) {\n\t\t\t\t\twriter.comment(node.value);\n\t\t\t\t},\n\n\t\t\t\t// Processing instruction\n\t\t\t\t7: function(node) {\n\t\t\t\t\twriter.pi(node.name, node.value);\n\t\t\t\t},\n\n\t\t\t\t// Doctype\n\t\t\t\t10: function(node) {\n\t\t\t\t\twriter.doctype(node.value);\n\t\t\t\t},\n\n\t\t\t\t// CDATA\n\t\t\t\t4: function(node) {\n\t\t\t\t\twriter.cdata(node.value);\n\t\t\t\t},\n\n \t\t\t\t// Document fragment\n\t\t\t\t11: function(node) {\n\t\t\t\t\tif ((node = node.firstChild)) {\n\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\twalk(node);\n\t\t\t\t\t\t} while (node = node.next);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\twriter.reset();\n\n\t\t\tfunction walk(node) {\n\t\t\t\tvar handler = handlers[node.type], name, isEmpty, attrs, attrName, attrValue, sortedAttrs, i, l, elementRule;\n\n\t\t\t\tif (!handler) {\n\t\t\t\t\tname = node.name;\n\t\t\t\t\tisEmpty = node.shortEnded;\n\t\t\t\t\tattrs = node.attributes;\n\n\t\t\t\t\t// Sort attributes\n\t\t\t\t\tif (validate && attrs && attrs.length > 1) {\n\t\t\t\t\t\tsortedAttrs = [];\n\t\t\t\t\t\tsortedAttrs.map = {};\n\n\t\t\t\t\t\telementRule = schema.getElementRule(node.name);\n\t\t\t\t\t\tfor (i = 0, l = elementRule.attributesOrder.length; i < l; i++) {\n\t\t\t\t\t\t\tattrName = elementRule.attributesOrder[i];\n\n\t\t\t\t\t\t\tif (attrName in attrs.map) {\n\t\t\t\t\t\t\t\tattrValue = attrs.map[attrName];\n\t\t\t\t\t\t\t\tsortedAttrs.map[attrName] = attrValue;\n\t\t\t\t\t\t\t\tsortedAttrs.push({name: attrName, value: attrValue});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfor (i = 0, l = attrs.length; i < l; i++) {\n\t\t\t\t\t\t\tattrName = attrs[i].name;\n\n\t\t\t\t\t\t\tif (!(attrName in sortedAttrs.map)) {\n\t\t\t\t\t\t\t\tattrValue = attrs.map[attrName];\n\t\t\t\t\t\t\t\tsortedAttrs.map[attrName] = attrValue;\n\t\t\t\t\t\t\t\tsortedAttrs.push({name: attrName, value: attrValue});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tattrs = sortedAttrs;\n\t\t\t\t\t}\n\n\t\t\t\t\twriter.start(node.name, attrs, isEmpty);\n\n\t\t\t\t\tif (!isEmpty) {\n\t\t\t\t\t\tif ((node = node.firstChild)) {\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\twalk(node);\n\t\t\t\t\t\t\t} while (node = node.next);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\twriter.end(name);\n\t\t\t\t\t}\n\t\t\t\t} else\n\t\t\t\t\thandler(node);\n\t\t\t}\n\n\t\t\t// Serialize element and treat all non elements as fragments\n\t\t\tif (node.type == 1 && !settings.inner)\n\t\t\t\twalk(node);\n\t\t\telse\n\t\t\t\thandlers[11](node);\n\n\t\t\treturn writer.getContent();\n\t\t};\n\t}\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/html/Node.js":"/**\n * Node.js\n *\n * Copyright 2010, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\tvar whiteSpaceRegExp = /^[ \\t\\r\\n]*$/, typeLookup = {\n\t\t'#text' : 3,\n\t\t'#comment' : 8,\n\t\t'#cdata' : 4,\n\t\t'#pi' : 7,\n\t\t'#doctype' : 10,\n\t\t'#document-fragment' : 11\n\t};\n\n\t// Walks the tree left/right\n\tfunction walk(node, root_node, prev) {\n\t\tvar sibling, parent, startName = prev ? 'lastChild' : 'firstChild', siblingName = prev ? 'prev' : 'next';\n\n\t\t// Walk into nodes if it has a start\n\t\tif (node[startName])\n\t\t\treturn node[startName];\n\n\t\t// Return the sibling if it has one\n\t\tif (node !== root_node) {\n\t\t\tsibling = node[siblingName];\n\n\t\t\tif (sibling)\n\t\t\t\treturn sibling;\n\n\t\t\t// Walk up the parents to look for siblings\n\t\t\tfor (parent = node.parent; parent && parent !== root_node; parent = parent.parent) {\n\t\t\t\tsibling = parent[siblingName];\n\n\t\t\t\tif (sibling)\n\t\t\t\t\treturn sibling;\n\t\t\t}\n\t\t}\n\t};\n\n\t/**\n\t * This class is a minimalistic implementation of a DOM like node used by the DomParser class.\n\t *\n\t * @example\n\t * var node = new tinymce.html.Node('strong', 1);\n\t * someRoot.append(node);\n\t *\n\t * @class tinymce.html.Node\n\t * @version 3.4\n\t */\n\n\t/**\n\t * Constructs a new Node instance.\n\t *\n\t * @constructor\n\t * @method Node\n\t * @param {String} name Name of the node type.\n\t * @param {Number} type Numeric type representing the node.\n\t */\n\tfunction Node(name, type) {\n\t\tthis.name = name;\n\t\tthis.type = type;\n\n\t\tif (type === 1) {\n\t\t\tthis.attributes = [];\n\t\t\tthis.attributes.map = {};\n\t\t}\n\t}\n\n\ttinymce.extend(Node.prototype, {\n\t\t/**\n\t\t * Replaces the current node with the specified one.\n\t\t *\n\t\t * @example\n\t\t * someNode.replace(someNewNode);\n\t\t *\n\t\t * @method replace\n\t\t * @param {tinymce.html.Node} node Node to replace the current node with.\n\t\t * @return {tinymce.html.Node} The old node that got replaced.\n\t\t */\n\t\treplace : function(node) {\n\t\t\tvar self = this;\n\n\t\t\tif (node.parent)\n\t\t\t\tnode.remove();\n\n\t\t\tself.insert(node, self);\n\t\t\tself.remove();\n\n\t\t\treturn self;\n\t\t},\n\n\t\t/**\n\t\t * Gets/sets or removes an attribute by name.\n\t\t *\n\t\t * @example\n\t\t * someNode.attr(\"name\", \"value\"); // Sets an attribute\n\t\t * console.log(someNode.attr(\"name\")); // Gets an attribute\n\t\t * someNode.attr(\"name\", null); // Removes an attribute\n\t\t *\n\t\t * @method attr\n\t\t * @param {String} name Attribute name to set or get.\n\t\t * @param {String} value Optional value to set.\n\t\t * @return {String/tinymce.html.Node} String or undefined on a get operation or the current node on a set operation.\n\t\t */\n\t\tattr : function(name, value) {\n\t\t\tvar self = this, attrs, i, undef;\n\n\t\t\tif (typeof name !== \"string\") {\n\t\t\t\tfor (i in name)\n\t\t\t\t\tself.attr(i, name[i]);\n\n\t\t\t\treturn self;\n\t\t\t}\n\n\t\t\tif (attrs = self.attributes) {\n\t\t\t\tif (value !== undef) {\n\t\t\t\t\t// Remove attribute\n\t\t\t\t\tif (value === null) {\n\t\t\t\t\t\tif (name in attrs.map) {\n\t\t\t\t\t\t\tdelete attrs.map[name];\n\n\t\t\t\t\t\t\ti = attrs.length;\n\t\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\t\tif (attrs[i].name === name) {\n\t\t\t\t\t\t\t\t\tattrs = attrs.splice(i, 1);\n\t\t\t\t\t\t\t\t\treturn self;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn self;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Set attribute\n\t\t\t\t\tif (name in attrs.map) {\n\t\t\t\t\t\t// Set attribute\n\t\t\t\t\t\ti = attrs.length;\n\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\tif (attrs[i].name === name) {\n\t\t\t\t\t\t\t\tattrs[i].value = value;\n\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t} else\n\t\t\t\t\t\tattrs.push({name: name, value: value});\n\n\t\t\t\t\tattrs.map[name] = value;\n\n\t\t\t\t\treturn self;\n\t\t\t\t} else {\n\t\t\t\t\treturn attrs.map[name];\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Does a shallow clones the node into a new node. It will also exclude id attributes since\n\t\t * there should only be one id per document.\n\t\t *\n\t\t * @example\n\t\t * var clonedNode = node.clone();\n\t\t *\n\t\t * @method clone\n\t\t * @return {tinymce.html.Node} New copy of the original node.\n\t\t */\n\t\tclone : function() {\n\t\t\tvar self = this, clone = new Node(self.name, self.type), i, l, selfAttrs, selfAttr, cloneAttrs;\n\n\t\t\t// Clone element attributes\n\t\t\tif (selfAttrs = self.attributes) {\n\t\t\t\tcloneAttrs = [];\n\t\t\t\tcloneAttrs.map = {};\n\n\t\t\t\tfor (i = 0, l = selfAttrs.length; i < l; i++) {\n\t\t\t\t\tselfAttr = selfAttrs[i];\n\n\t\t\t\t\t// Clone everything except id\n\t\t\t\t\tif (selfAttr.name !== 'id') {\n\t\t\t\t\t\tcloneAttrs[cloneAttrs.length] = {name: selfAttr.name, value: selfAttr.value};\n\t\t\t\t\t\tcloneAttrs.map[selfAttr.name] = selfAttr.value;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tclone.attributes = cloneAttrs;\n\t\t\t}\n\n\t\t\tclone.value = self.value;\n\t\t\tclone.shortEnded = self.shortEnded;\n\n\t\t\treturn clone;\n\t\t},\n\n\t\t/**\n\t\t * Wraps the node in in another node.\n\t\t *\n\t\t * @example\n\t\t * node.wrap(wrapperNode);\n\t\t *\n\t\t * @method wrap\n\t\t */\n\t\twrap : function(wrapper) {\n\t\t\tvar self = this;\n\n\t\t\tself.parent.insert(wrapper, self);\n\t\t\twrapper.append(self);\n\n\t\t\treturn self;\n\t\t},\n\n\t\t/**\n\t\t * Unwraps the node in other words it removes the node but keeps the children.\n\t\t *\n\t\t * @example\n\t\t * node.unwrap();\n\t\t *\n\t\t * @method unwrap\n\t\t */\n\t\tunwrap : function() {\n\t\t\tvar self = this, node, next;\n\n\t\t\tfor (node = self.firstChild; node; ) {\n\t\t\t\tnext = node.next;\n\t\t\t\tself.insert(node, self, true);\n\t\t\t\tnode = next;\n\t\t\t}\n\n\t\t\tself.remove();\n\t\t},\n\n\t\t/**\n\t\t * Removes the node from it's parent.\n\t\t *\n\t\t * @example\n\t\t * node.remove();\n\t\t *\n\t\t * @method remove\n\t\t * @return {tinymce.html.Node} Current node that got removed.\n\t\t */\n\t\tremove : function() {\n\t\t\tvar self = this, parent = self.parent, next = self.next, prev = self.prev;\n\n\t\t\tif (parent) {\n\t\t\t\tif (parent.firstChild === self) {\n\t\t\t\t\tparent.firstChild = next;\n\n\t\t\t\t\tif (next)\n\t\t\t\t\t\tnext.prev = null;\n\t\t\t\t} else {\n\t\t\t\t\tprev.next = next;\n\t\t\t\t}\n\n\t\t\t\tif (parent.lastChild === self) {\n\t\t\t\t\tparent.lastChild = prev;\n\n\t\t\t\t\tif (prev)\n\t\t\t\t\t\tprev.next = null;\n\t\t\t\t} else {\n\t\t\t\t\tnext.prev = prev;\n\t\t\t\t}\n\n\t\t\t\tself.parent = self.next = self.prev = null;\n\t\t\t}\n\n\t\t\treturn self;\n\t\t},\n\n\t\t/**\n\t\t * Appends a new node as a child of the current node.\n\t\t *\n\t\t * @example\n\t\t * node.append(someNode);\n\t\t *\n\t\t * @method append\n\t\t * @param {tinymce.html.Node} node Node to append as a child of the current one.\n\t\t * @return {tinymce.html.Node} The node that got appended.\n\t\t */\n\t\tappend : function(node) {\n\t\t\tvar self = this, last;\n\n\t\t\tif (node.parent)\n\t\t\t\tnode.remove();\n\n\t\t\tlast = self.lastChild;\n\t\t\tif (last) {\n\t\t\t\tlast.next = node;\n\t\t\t\tnode.prev = last;\n\t\t\t\tself.lastChild = node;\n\t\t\t} else\n\t\t\t\tself.lastChild = self.firstChild = node;\n\n\t\t\tnode.parent = self;\n\n\t\t\treturn node;\n\t\t},\n\n\t\t/**\n\t\t * Inserts a node at a specific position as a child of the current node.\n\t\t *\n\t\t * @example\n\t\t * parentNode.insert(newChildNode, oldChildNode);\n\t\t *\n\t\t * @method insert\n\t\t * @param {tinymce.html.Node} node Node to insert as a child of the current node.\n\t\t * @param {tinymce.html.Node} ref_node Reference node to set node before/after.\n\t\t * @param {Boolean} before Optional state to insert the node before the reference node.\n\t\t * @return {tinymce.html.Node} The node that got inserted.\n\t\t */\n\t\tinsert : function(node, ref_node, before) {\n\t\t\tvar parent;\n\n\t\t\tif (node.parent)\n\t\t\t\tnode.remove();\n\n\t\t\tparent = ref_node.parent || this;\n\n\t\t\tif (before) {\n\t\t\t\tif (ref_node === parent.firstChild)\n\t\t\t\t\tparent.firstChild = node;\n\t\t\t\telse\n\t\t\t\t\tref_node.prev.next = node;\n\n\t\t\t\tnode.prev = ref_node.prev;\n\t\t\t\tnode.next = ref_node;\n\t\t\t\tref_node.prev = node;\n\t\t\t} else {\n\t\t\t\tif (ref_node === parent.lastChild)\n\t\t\t\t\tparent.lastChild = node;\n\t\t\t\telse\n\t\t\t\t\tref_node.next.prev = node;\n\n\t\t\t\tnode.next = ref_node.next;\n\t\t\t\tnode.prev = ref_node;\n\t\t\t\tref_node.next = node;\n\t\t\t}\n\n\t\t\tnode.parent = parent;\n\n\t\t\treturn node;\n\t\t},\n\n\t\t/**\n\t\t * Get all children by name.\n\t\t *\n\t\t * @method getAll\n\t\t * @param {String} name Name of the child nodes to collect.\n\t\t * @return {Array} Array with child nodes matchin the specified name.\n\t\t */\n\t\tgetAll : function(name) {\n\t\t\tvar self = this, node, collection = [];\n\n\t\t\tfor (node = self.firstChild; node; node = walk(node, self)) {\n\t\t\t\tif (node.name === name)\n\t\t\t\t\tcollection.push(node);\n\t\t\t}\n\n\t\t\treturn collection;\n\t\t},\n\n\t\t/**\n\t\t * Removes all children of the current node.\n\t\t *\n\t\t * @method empty\n\t\t * @return {tinymce.html.Node} The current node that got cleared.\n\t\t */\n\t\tempty : function() {\n\t\t\tvar self = this, nodes, i, node;\n\n\t\t\t// Remove all children\n\t\t\tif (self.firstChild) {\n\t\t\t\tnodes = [];\n\n\t\t\t\t// Collect the children\n\t\t\t\tfor (node = self.firstChild; node; node = walk(node, self))\n\t\t\t\t\tnodes.push(node);\n\n\t\t\t\t// Remove the children\n\t\t\t\ti = nodes.length;\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tnode.parent = node.firstChild = node.lastChild = node.next = node.prev = null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tself.firstChild = self.lastChild = null;\n\n\t\t\treturn self;\n\t\t},\n\n\t\t/**\n\t\t * Returns true/false if the node is to be considered empty or not.\n\t\t *\n\t\t * @example\n\t\t * node.isEmpty({img : true});\n\t\t * @method isEmpty\n\t\t * @param {Object} elements Name/value object with elements that are automatically treated as non empty elements.\n\t\t * @return {Boolean} true/false if the node is empty or not.\n\t\t */\n\t\tisEmpty : function(elements) {\n\t\t\tvar self = this, node = self.firstChild, i, name;\n\n\t\t\tif (node) {\n\t\t\t\tdo {\n\t\t\t\t\tif (node.type === 1) {\n\t\t\t\t\t\t// Ignore bogus elements\n\t\t\t\t\t\tif (node.attributes.map['data-mce-bogus'])\n\t\t\t\t\t\t\tcontinue;\n\n\t\t\t\t\t\t// Keep empty elements like <img />\n\t\t\t\t\t\tif (elements[node.name])\n\t\t\t\t\t\t\treturn false;\n\n\t\t\t\t\t\t// Keep elements with data attributes or name attribute like <a name=\"1\"></a>\n\t\t\t\t\t\ti = node.attributes.length;\n\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\tname = node.attributes[i].name;\n\t\t\t\t\t\t\tif (name === \"name\" || name.indexOf('data-') === 0)\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Keep non whitespace text nodes\n\t\t\t\t\tif ((node.type === 3 && !whiteSpaceRegExp.test(node.value)))\n\t\t\t\t\t\treturn false;\n\t\t\t\t} while (node = walk(node, self));\n\t\t\t}\n\n\t\t\treturn true;\n\t\t},\n\n\t\t/**\n\t\t * Walks to the next or previous node and returns that node or null if it wasn't found.\n\t\t *\n\t\t * @method walk\n\t\t * @param {Boolean} prev Optional previous node state defaults to false.\n\t\t * @return {tinymce.html.Node} Node that is next to or previous of the current node.\n\t\t */\n\t\twalk : function(prev) {\n\t\t\treturn walk(this, null, prev);\n\t\t}\n\t});\n\n\ttinymce.extend(Node, {\n\t\t/**\n\t\t * Creates a node of a specific type.\n\t\t *\n\t\t * @static\n\t\t * @method create\n\t\t * @param {String} name Name of the node type to create for example \"b\" or \"#text\".\n\t\t * @param {Object} attrs Name/value collection of attributes that will be applied to elements.\n\t\t */\n\t\tcreate : function(name, attrs) {\n\t\t\tvar node, attrName;\n\n\t\t\t// Create node\n\t\t\tnode = new Node(name, typeLookup[name] || 1);\n\n\t\t\t// Add attributes if needed\n\t\t\tif (attrs) {\n\t\t\t\tfor (attrName in attrs)\n\t\t\t\t\tnode.attr(attrName, attrs[attrName]);\n\t\t\t}\n\n\t\t\treturn node;\n\t\t}\n\t});\n\n\ttinymce.html.Node = Node;\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/html/Writer.js":"/**\n * Writer.js\n *\n * Copyright 2010, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n/**\n * This class is used to write HTML tags out it can be used with the Serializer or the SaxParser.\n *\n * @class tinymce.html.Writer\n * @example\n * var writer = new tinymce.html.Writer({indent : true});\n * var parser = new tinymce.html.SaxParser(writer).parse('<p><br></p>');\n * console.log(writer.getContent());\n *\n * @class tinymce.html.Writer\n * @version 3.4\n */\n\n/**\n * Constructs a new Writer instance.\n *\n * @constructor\n * @method Writer\n * @param {Object} settings Name/value settings object.\n */\ntinymce.html.Writer = function(settings) {\n\tvar html = [], indent, indentBefore, indentAfter, encode, htmlOutput;\n\n\tsettings = settings || {};\n\tindent = settings.indent;\n\tindentBefore = tinymce.makeMap(settings.indent_before || '');\n\tindentAfter = tinymce.makeMap(settings.indent_after || '');\n\tencode = tinymce.html.Entities.getEncodeFunc(settings.entity_encoding || 'raw', settings.entities);\n\thtmlOutput = settings.element_format == \"html\";\n\n\treturn {\n\t\t/**\n\t\t * Writes the a start element such as <p id=\"a\">.\n\t\t *\n\t\t * @method start\n\t\t * @param {String} name Name of the element.\n\t\t * @param {Array} attrs Optional attribute array or undefined if it hasn't any.\n\t\t * @param {Boolean} empty Optional empty state if the tag should end like <br />.\n\t\t */\n\t\tstart: function(name, attrs, empty) {\n\t\t\tvar i, l, attr, value;\n\n\t\t\tif (indent && indentBefore[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}\n\n\t\t\thtml.push('<', name);\n\n\t\t\tif (attrs) {\n\t\t\t\tfor (i = 0, l = attrs.length; i < l; i++) {\n\t\t\t\t\tattr = attrs[i];\n\t\t\t\t\thtml.push(' ', attr.name, '=\"', encode(attr.value, true), '\"');\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (!empty || htmlOutput)\n\t\t\t\thtml[html.length] = '>';\n\t\t\telse\n\t\t\t\thtml[html.length] = ' />';\n\n\t\t\tif (empty && indent && indentAfter[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Writes the a end element such as </p>.\n\t\t *\n\t\t * @method end\n\t\t * @param {String} name Name of the element.\n\t\t */\n\t\tend: function(name) {\n\t\t\tvar value;\n\n\t\t\t/*if (indent && indentBefore[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}*/\n\n\t\t\thtml.push('</', name, '>');\n\n\t\t\tif (indent && indentAfter[name] && html.length > 0) {\n\t\t\t\tvalue = html[html.length - 1];\n\n\t\t\t\tif (value.length > 0 && value !== '\\n')\n\t\t\t\t\thtml.push('\\n');\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Writes a text node.\n\t\t *\n\t\t * @method text\n\t\t * @param {String} text String to write out.\n\t\t * @param {Boolean} raw Optional raw state if true the contents won't get encoded.\n\t\t */\n\t\ttext: function(text, raw) {\n\t\t\tif (text.length > 0)\n\t\t\t\thtml[html.length] = raw ? text : encode(text);\n\t\t},\n\n\t\t/**\n\t\t * Writes a cdata node such as <![CDATA[data]]>.\n\t\t *\n\t\t * @method cdata\n\t\t * @param {String} text String to write out inside the cdata.\n\t\t */\n\t\tcdata: function(text) {\n\t\t\thtml.push('<![CDATA[', text, ']]>');\n\t\t},\n\n\t\t/**\n\t\t * Writes a comment node such as <!-- Comment -->.\n\t\t *\n\t\t * @method cdata\n\t\t * @param {String} text String to write out inside the comment.\n\t\t */\n\t\tcomment: function(text) {\n\t\t\thtml.push('<!--', text, '-->');\n\t\t},\n\n\t\t/**\n\t\t * Writes a PI node such as <?xml attr=\"value\" ?>.\n\t\t *\n\t\t * @method pi\n\t\t * @param {String} name Name of the pi.\n\t\t * @param {String} text String to write out inside the pi.\n\t\t */\n\t\tpi: function(name, text) {\n\t\t\tif (text)\n\t\t\t\thtml.push('<?', name, ' ', text, '?>');\n\t\t\telse\n\t\t\t\thtml.push('<?', name, '?>');\n\n\t\t\tif (indent)\n\t\t\t\thtml.push('\\n');\n\t\t},\n\n\t\t/**\n\t\t * Writes a doctype node such as <!DOCTYPE data>.\n\t\t *\n\t\t * @method doctype\n\t\t * @param {String} text String to write out inside the doctype.\n\t\t */\n\t\tdoctype: function(text) {\n\t\t\thtml.push('<!DOCTYPE', text, '>', indent ? '\\n' : '');\n\t\t},\n\n\t\t/**\n\t\t * Resets the internal buffer if one wants to reuse the writer.\n\t\t *\n\t\t * @method reset\n\t\t */\n\t\treset: function() {\n\t\t\thtml.length = 0;\n\t\t},\n\n\t\t/**\n\t\t * Returns the contents that got serialized.\n\t\t *\n\t\t * @method getContent\n\t\t * @return {String} HTML contents that got written down.\n\t\t */\n\t\tgetContent: function() {\n\t\t\treturn html.join('').replace(/\\n$/, '');\n\t\t}\n\t};\n};\n","Magento_Tinymce3/tiny_mce/classes/dom/EventUtils.js":"/**\n * EventUtils.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\t// Shorten names\n\tvar each = tinymce.each, DOM = tinymce.DOM, isIE = tinymce.isIE, isWebKit = tinymce.isWebKit, Event;\n\n\t/**\n\t * This class handles DOM events in a cross platform fasion it also keeps track of element\n\t * and handler references to be able to clean elements to reduce IE memory leaks.\n\t *\n\t * @class tinymce.dom.EventUtils\n\t */\n\ttinymce.create('tinymce.dom.EventUtils', {\n\t\t/**\n\t\t * Constructs a new EventUtils instance.\n\t\t *\n\t\t * @constructor\n\t\t * @method EventUtils\n\t\t */\n\t\tEventUtils : function() {\n\t\t\tthis.inits = [];\n\t\t\tthis.events = [];\n\t\t},\n\n\t\t/**\n\t\t * Adds an event handler to the specified object.\n\t\t *\n\t\t * @method add\n\t\t * @param {Element/Document/Window/Array/String} o Object or element id string to add event handler to or an array of elements/ids/documents.\n\t\t * @param {String/Array} n Name of event handler to add for example: click.\n\t\t * @param {function} f Function to execute when the event occurs.\n\t\t * @param {Object} s Optional scope to execute the function in.\n\t\t * @return {function} Function callback handler the same as the one passed in.\n\t\t * @example\n\t\t * // Adds a click handler to the current document\n\t\t * tinymce.dom.Event.add(document, 'click', function(e) {\n\t\t *    console.debug(e.target);\n\t\t * });\n\t\t */\n\t\tadd : function(o, n, f, s) {\n\t\t\tvar cb, t = this, el = t.events, r;\n\n\t\t\tif (n instanceof Array) {\n\t\t\t\tr = [];\n\n\t\t\t\teach(n, function(n) {\n\t\t\t\t\tr.push(t.add(o, n, f, s));\n\t\t\t\t});\n\n\t\t\t\treturn r;\n\t\t\t}\n\n\t\t\t// Handle array\n\t\t\tif (o && o.hasOwnProperty && o instanceof Array) {\n\t\t\t\tr = [];\n\n\t\t\t\teach(o, function(o) {\n\t\t\t\t\to = DOM.get(o);\n\t\t\t\t\tr.push(t.add(o, n, f, s));\n\t\t\t\t});\n\n\t\t\t\treturn r;\n\t\t\t}\n\n\t\t\to = DOM.get(o);\n\n\t\t\tif (!o)\n\t\t\t\treturn;\n\n\t\t\t// Setup event callback\n\t\t\tcb = function(e) {\n\t\t\t\t// Is all events disabled\n\t\t\t\tif (t.disabled)\n\t\t\t\t\treturn;\n\n\t\t\t\te = e || window.event;\n\n\t\t\t\t// Patch in target, preventDefault and stopPropagation in IE it's W3C valid\n\t\t\t\tif (e && isIE) {\n\t\t\t\t\tif (!e.target)\n\t\t\t\t\t\te.target = e.srcElement;\n\n\t\t\t\t\t// Patch in preventDefault, stopPropagation methods for W3C compatibility\n\t\t\t\t\ttinymce.extend(e, t._stoppers);\n\t\t\t\t}\n\n\t\t\t\tif (!s)\n\t\t\t\t\treturn f(e);\n\n\t\t\t\treturn f.call(s, e);\n\t\t\t};\n\n\t\t\tif (n == 'unload') {\n\t\t\t\ttinymce.unloads.unshift({func : cb});\n\t\t\t\treturn cb;\n\t\t\t}\n\n\t\t\tif (n == 'init') {\n\t\t\t\tif (t.domLoaded)\n\t\t\t\t\tcb();\n\t\t\t\telse\n\t\t\t\t\tt.inits.push(cb);\n\n\t\t\t\treturn cb;\n\t\t\t}\n\n\t\t\t// Store away listener reference\n\t\t\tel.push({\n\t\t\t\tobj : o,\n\t\t\t\tname : n,\n\t\t\t\tfunc : f,\n\t\t\t\tcfunc : cb,\n\t\t\t\tscope : s\n\t\t\t});\n\n\t\t\tt._add(o, n, cb);\n\n\t\t\treturn f;\n\t\t},\n\n\t\t/**\n\t\t * Removes the specified event handler by name and function from a element or collection of elements.\n\t\t *\n\t\t * @method remove\n\t\t * @param {String/Element/Array} o Element ID string or HTML element or an array of elements or ids to remove handler from.\n\t\t * @param {String} n Event handler name like for example: \"click\"\n\t\t * @param {function} f Function to remove.\n\t\t * @return {bool/Array} Bool state if true if the handler was removed or an array with states if multiple elements where passed in.\n\t\t * @example\n\t\t * // Adds a click handler to the current document\n\t\t * var func = tinymce.dom.Event.add(document, 'click', function(e) {\n\t\t *    console.debug(e.target);\n\t\t * });\n\t\t * \n\t\t * // Removes the click handler from the document\n\t\t * tinymce.dom.Event.remove(document, 'click', func);\n\t\t */\n\t\tremove : function(o, n, f) {\n\t\t\tvar t = this, a = t.events, s = false, r;\n\n\t\t\t// Handle array\n\t\t\tif (o && o.hasOwnProperty && o instanceof Array) {\n\t\t\t\tr = [];\n\n\t\t\t\teach(o, function(o) {\n\t\t\t\t\to = DOM.get(o);\n\t\t\t\t\tr.push(t.remove(o, n, f));\n\t\t\t\t});\n\n\t\t\t\treturn r;\n\t\t\t}\n\n\t\t\to = DOM.get(o);\n\n\t\t\teach(a, function(e, i) {\n\t\t\t\tif (e.obj == o && e.name == n && (!f || (e.func == f || e.cfunc == f))) {\n\t\t\t\t\ta.splice(i, 1);\n\t\t\t\t\tt._remove(o, n, e.cfunc);\n\t\t\t\t\ts = true;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn s;\n\t\t},\n\n\t\t/**\n\t\t * Clears all events of a specific object.\n\t\t *\n\t\t * @method clear\n\t\t * @param {Object} o DOM element or object to remove all events from.\n\t\t * @example\n\t\t * // Cancels all mousedown events in the active editor\n\t\t * tinyMCE.activeEditor.onMouseDown.add(function(ed, e) {\n\t\t *    return tinymce.dom.Event.cancel(e);\n\t\t * });\n\t\t */\n\t\tclear : function(o) {\n\t\t\tvar t = this, a = t.events, i, e;\n\n\t\t\tif (o) {\n\t\t\t\to = DOM.get(o);\n\n\t\t\t\tfor (i = a.length - 1; i >= 0; i--) {\n\t\t\t\t\te = a[i];\n\n\t\t\t\t\tif (e.obj === o) {\n\t\t\t\t\t\tt._remove(e.obj, e.name, e.cfunc);\n\t\t\t\t\t\te.obj = e.cfunc = null;\n\t\t\t\t\t\ta.splice(i, 1);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Cancels an event for both bubbeling and the default browser behavior.\n\t\t *\n\t\t * @method cancel\n\t\t * @param {Event} e Event object to cancel.\n\t\t * @return {Boolean} Always false.\n\t\t */\n\t\tcancel : function(e) {\n\t\t\tif (!e)\n\t\t\t\treturn false;\n\n\t\t\tthis.stop(e);\n\n\t\t\treturn this.prevent(e);\n\t\t},\n\n\t\t/**\n\t\t * Stops propogation/bubbeling of an event.\n\t\t *\n\t\t * @method stop\n\t\t * @param {Event} e Event to cancel bubbeling on.\n\t\t * @return {Boolean} Always false.\n\t\t */\n\t\tstop : function(e) {\n\t\t\tif (e.stopPropagation)\n\t\t\t\te.stopPropagation();\n\t\t\telse\n\t\t\t\te.cancelBubble = true;\n\n\t\t\treturn false;\n\t\t},\n\n\t\t/**\n\t\t * Prevent default browser behvaior of an event.\n\t\t *\n\t\t * @method prevent\n\t\t * @param {Event} e Event to prevent default browser behvaior of an event.\n\t\t * @return {Boolean} Always false.\n\t\t */\n\t\tprevent : function(e) {\n\t\t\tif (e.preventDefault)\n\t\t\t\te.preventDefault();\n\t\t\telse\n\t\t\t\te.returnValue = false;\n\n\t\t\treturn false;\n\t\t},\n\n\t\t/**\n\t\t * Destroys the instance.\n\t\t *\n\t\t * @method destroy\n\t\t */\n\t\tdestroy : function() {\n\t\t\tvar t = this;\n\n\t\t\teach(t.events, function(e, i) {\n\t\t\t\tt._remove(e.obj, e.name, e.cfunc);\n\t\t\t\te.obj = e.cfunc = null;\n\t\t\t});\n\n\t\t\tt.events = [];\n\t\t\tt = null;\n\t\t},\n\n\t\t_add : function(o, n, f) {\n\t\t\tif (o.attachEvent)\n\t\t\t\to.attachEvent('on' + n, f);\n\t\t\telse if (o.addEventListener)\n\t\t\t\to.addEventListener(n, f, false);\n\t\t\telse\n\t\t\t\to['on' + n] = f;\n\t\t},\n\n\t\t_remove : function(o, n, f) {\n\t\t\tif (o) {\n\t\t\t\ttry {\n\t\t\t\t\tif (o.detachEvent)\n\t\t\t\t\t\to.detachEvent('on' + n, f);\n\t\t\t\t\telse if (o.removeEventListener)\n\t\t\t\t\t\to.removeEventListener(n, f, false);\n\t\t\t\t\telse\n\t\t\t\t\t\to['on' + n] = null;\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Might fail with permission denined on IE so we just ignore that\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t_pageInit : function(win) {\n\t\t\tvar t = this;\n\n\t\t\t// Keep it from running more than once\n\t\t\tif (t.domLoaded)\n\t\t\t\treturn;\n\n\t\t\tt.domLoaded = true;\n\n\t\t\teach(t.inits, function(c) {\n\t\t\t\tc();\n\t\t\t});\n\n\t\t\tt.inits = [];\n\t\t},\n\n\t\t_wait : function(win) {\n\t\t\tvar t = this, doc = win.document;\n\n\t\t\t// No need since the document is already loaded\n\t\t\tif (win.tinyMCE_GZ && tinyMCE_GZ.loaded) {\n\t\t\t\tt.domLoaded = 1;\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Use IE method\n\t\t\tif (doc.attachEvent) {\n\t\t\t\tdoc.attachEvent(\"onreadystatechange\", function() {\n\t\t\t\t\tif (doc.readyState === \"complete\") {\n\t\t\t\t\t\tdoc.detachEvent(\"onreadystatechange\", arguments.callee);\n\t\t\t\t\t\tt._pageInit(win);\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\tif (doc.documentElement.doScroll && win == win.top) {\n\t\t\t\t\t(function() {\n\t\t\t\t\t\tif (t.domLoaded)\n\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t// If IE is used, use the trick by Diego Perini licensed under MIT by request to the author.\n\t\t\t\t\t\t\t// http://javascript.nwbox.com/IEContentLoaded/\n\t\t\t\t\t\t\tdoc.documentElement.doScroll(\"left\");\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\tsetTimeout(arguments.callee, 0);\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tt._pageInit(win);\n\t\t\t\t\t})();\n\t\t\t\t}\n\t\t\t} else if (doc.addEventListener) {\n\t\t\t\tt._add(win, 'DOMContentLoaded', function() {\n\t\t\t\t\tt._pageInit(win);\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tt._add(win, 'load', function() {\n\t\t\t\tt._pageInit(win);\n\t\t\t});\n\t\t},\n\n\t\t_stoppers : {\n\t\t\tpreventDefault : function() {\n\t\t\t\tthis.returnValue = false;\n\t\t\t},\n\n\t\t\tstopPropagation : function() {\n\t\t\t\tthis.cancelBubble = true;\n\t\t\t}\n\t\t}\n\t});\n\n\t/**\n\t * Instance of EventUtils for the current document.\n\t *\n\t * @property Event\n\t * @member tinymce.dom\n\t * @type tinymce.dom.EventUtils\n\t */\n\tEvent = tinymce.dom.Event = new tinymce.dom.EventUtils();\n\n\t// Dispatch DOM content loaded event for IE and Safari\n\tEvent._wait(window);\n\n\ttinymce.addUnload(function() {\n\t\tEvent.destroy();\n\t});\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/dom/Selection.js":"/**\n * Selection.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\tfunction trimNl(s) {\n\t\treturn s.replace(/[\\n\\r]+/g, '');\n\t};\n\n\t// Shorten names\n\tvar is = tinymce.is, isIE = tinymce.isIE, each = tinymce.each;\n\n\t/**\n\t * This class handles text and control selection it's an crossbrowser utility class.\n\t * Consult the TinyMCE Wiki API for more details and examples on how to use this class.\n\t *\n\t * @class tinymce.dom.Selection\n\t * @example\n\t * // Getting the currently selected node for the active editor\n\t * alert(tinymce.activeEditor.selection.getNode().nodeName);\n\t */\n\ttinymce.create('tinymce.dom.Selection', {\n\t\t/**\n\t\t * Constructs a new selection instance.\n\t\t *\n\t\t * @constructor\n\t\t * @method Selection\n\t\t * @param {tinymce.dom.DOMUtils} dom DOMUtils object reference.\n\t\t * @param {Window} win Window to bind the selection object to.\n\t\t * @param {tinymce.dom.Serializer} serializer DOM serialization class to use for getContent.\n\t\t */\n\t\tSelection : function(dom, win, serializer) {\n\t\t\tvar t = this;\n\n\t\t\tt.dom = dom;\n\t\t\tt.win = win;\n\t\t\tt.serializer = serializer;\n\n\t\t\t// Add events\n\t\t\teach([\n\t\t\t\t/**\n\t\t\t\t * This event gets executed before contents is extracted from the selection.\n\t\t\t\t *\n\t\t\t\t * @event onBeforeSetContent\n\t\t\t\t * @param {tinymce.dom.Selection} selection Selection object that fired the event.\n\t\t\t\t * @param {Object} args Contains things like the contents that will be returned. \n\t\t\t\t */\n\t\t\t\t'onBeforeSetContent',\n\n\t\t\t\t/**\n\t\t\t\t * This event gets executed before contents is inserted into selection. \n\t\t\t\t *\n\t\t\t\t * @event onBeforeGetContent\n\t\t\t\t * @param {tinymce.dom.Selection} selection Selection object that fired the event.\n\t\t\t\t * @param {Object} args Contains things like the contents that will be inserted. \n\t\t\t\t */\n\t\t\t\t'onBeforeGetContent',\n\n\t\t\t\t/**\n\t\t\t\t * This event gets executed when contents is inserted into selection.\n\t\t\t\t *\n\t\t\t\t * @event onSetContent\n\t\t\t\t * @param {tinymce.dom.Selection} selection Selection object that fired the event.\n\t\t\t\t * @param {Object} args Contains things like the contents that will be inserted. \n\t\t\t\t */\n\t\t\t\t'onSetContent',\n\n\t\t\t\t/**\n\t\t\t\t * This event gets executed when contents is extracted from the selection.\n\t\t\t\t *\n\t\t\t\t * @event onGetContent\n\t\t\t\t * @param {tinymce.dom.Selection} selection Selection object that fired the event.\n\t\t\t\t * @param {Object} args Contains things like the contents that will be returned. \n\t\t\t\t */\n\t\t\t\t'onGetContent'\n\t\t\t], function(e) {\n\t\t\t\tt[e] = new tinymce.util.Dispatcher(t);\n\t\t\t});\n\n\t\t\t// No W3C Range support\n\t\t\tif (!t.win.getSelection)\n\t\t\t\tt.tridentSel = new tinymce.dom.TridentSelection(t);\n\n\t\t\tif (tinymce.isIE && dom.boxModel)\n\t\t\t\tthis._fixIESelection();\n\n\t\t\t// Prevent leaks\n\t\t\ttinymce.addUnload(t.destroy, t);\n\t\t},\n\n\t\t/**\n\t\t * Move the selection cursor range to the specified node and offset.\n\t\t * @param node Node to put the cursor in.\n\t\t * @param offset Offset from the start of the node to put the cursor at.\n\t\t */\n\t\tsetCursorLocation: function(node, offset) {\n\t\t\tvar t = this; var r = t.dom.createRng();\n\t\t\tr.setStart(node, offset);\n\t\t\tr.setEnd(node, offset);\n\t\t\tt.setRng(r);\n\t\t\tt.collapse(false);\n\t\t},\n\t\t/**\n\t\t * Returns the selected contents using the DOM serializer passed in to this class.\n\t\t *\n\t\t * @method getContent\n\t\t * @param {Object} s Optional settings class with for example output format text or html.\n\t\t * @return {String} Selected contents in for example HTML format.\n\t\t * @example\n\t\t * // Alerts the currently selected contents\n\t\t * alert(tinyMCE.activeEditor.selection.getContent());\n\t\t * \n\t\t * // Alerts the currently selected contents as plain text\n\t\t * alert(tinyMCE.activeEditor.selection.getContent({format : 'text'}));\n\t\t */\n\t\tgetContent : function(s) {\n\t\t\tvar t = this, r = t.getRng(), e = t.dom.create(\"body\"), se = t.getSel(), wb, wa, n;\n\n\t\t\ts = s || {};\n\t\t\twb = wa = '';\n\t\t\ts.get = true;\n\t\t\ts.format = s.format || 'html';\n\t\t\ts.forced_root_block = '';\n\t\t\tt.onBeforeGetContent.dispatch(t, s);\n\n\t\t\tif (s.format == 'text')\n\t\t\t\treturn t.isCollapsed() ? '' : (r.text || (se.toString ? se.toString() : ''));\n\n\t\t\tif (r.cloneContents) {\n\t\t\t\tn = r.cloneContents();\n\n\t\t\t\tif (n)\n\t\t\t\t\te.appendChild(n);\n\t\t\t} else if (is(r.item) || is(r.htmlText)) {\n\t\t\t\t// IE will produce invalid markup if elements are present that\n\t\t\t\t// it doesn't understand like custom elements or HTML5 elements.\n\t\t\t\t// Adding a BR in front of the contents and then remoiving it seems to fix it though.\n\t\t\t\te.innerHTML = '<br>' + (r.item ? r.item(0).outerHTML : r.htmlText);\n\t\t\t\te.removeChild(e.firstChild);\n\t\t\t} else\n\t\t\t\te.innerHTML = r.toString();\n\n\t\t\t// Keep whitespace before and after\n\t\t\tif (/^\\s/.test(e.innerHTML))\n\t\t\t\twb = ' ';\n\n\t\t\tif (/\\s+$/.test(e.innerHTML))\n\t\t\t\twa = ' ';\n\n\t\t\ts.getInner = true;\n\n\t\t\ts.content = t.isCollapsed() ? '' : wb + t.serializer.serialize(e, s) + wa;\n\t\t\tt.onGetContent.dispatch(t, s);\n\n\t\t\treturn s.content;\n\t\t},\n\n\t\t/**\n\t\t * Sets the current selection to the specified content. If any contents is selected it will be replaced\n\t\t * with the contents passed in to this function. If there is no selection the contents will be inserted\n\t\t * where the caret is placed in the editor/page.\n\t\t *\n\t\t * @method setContent\n\t\t * @param {String} content HTML contents to set could also be other formats depending on settings.\n\t\t * @param {Object} args Optional settings object with for example data format.\n\t\t * @example\n\t\t * // Inserts some HTML contents at the current selection\n\t\t * tinyMCE.activeEditor.selection.setContent('<strong>Some contents</strong>');\n\t\t */\n\t\tsetContent : function(content, args) {\n\t\t\tvar self = this, rng = self.getRng(), caretNode, doc = self.win.document, frag, temp;\n\n\t\t\targs = args || {format : 'html'};\n\t\t\targs.set = true;\n\t\t\tcontent = args.content = content;\n\n\t\t\t// Dispatch before set content event\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onBeforeSetContent.dispatch(self, args);\n\n\t\t\tcontent = args.content;\n\n\t\t\tif (rng.insertNode) {\n\t\t\t\t// Make caret marker since insertNode places the caret in the beginning of text after insert\n\t\t\t\tcontent += '<span id=\"__caret\">_</span>';\n\n\t\t\t\t// Delete and insert new node\n\t\t\t\tif (rng.startContainer == doc && rng.endContainer == doc) {\n\t\t\t\t\t// WebKit will fail if the body is empty since the range is then invalid and it can't insert contents\n\t\t\t\t\tdoc.body.innerHTML = content;\n\t\t\t\t} else {\n\t\t\t\t\trng.deleteContents();\n\n\t\t\t\t\tif (doc.body.childNodes.length == 0) {\n\t\t\t\t\t\tdoc.body.innerHTML = content;\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// createContextualFragment doesn't exists in IE 9 DOMRanges\n\t\t\t\t\t\tif (rng.createContextualFragment) {\n\t\t\t\t\t\t\trng.insertNode(rng.createContextualFragment(content));\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t// Fake createContextualFragment call in IE 9\n\t\t\t\t\t\t\tfrag = doc.createDocumentFragment();\n\t\t\t\t\t\t\ttemp = doc.createElement('div');\n\n\t\t\t\t\t\t\tfrag.appendChild(temp);\n\t\t\t\t\t\t\ttemp.outerHTML = content;\n\n\t\t\t\t\t\t\trng.insertNode(frag);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Move to caret marker\n\t\t\t\tcaretNode = self.dom.get('__caret');\n\n\t\t\t\t// Make sure we wrap it compleatly, Opera fails with a simple select call\n\t\t\t\trng = doc.createRange();\n\t\t\t\trng.setStartBefore(caretNode);\n\t\t\t\trng.setEndBefore(caretNode);\n\t\t\t\tself.setRng(rng);\n\n\t\t\t\t// Remove the caret position\n\t\t\t\tself.dom.remove('__caret');\n\n\t\t\t\ttry {\n\t\t\t\t\tself.setRng(rng);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Might fail on Opera for some odd reason\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tif (rng.item) {\n\t\t\t\t\t// Delete content and get caret text selection\n\t\t\t\t\tdoc.execCommand('Delete', false, null);\n\t\t\t\t\trng = self.getRng();\n\t\t\t\t}\n\n\t\t\t\t// Explorer removes spaces from the beginning of pasted contents\n\t\t\t\tif (/^\\s+/.test(content)) {\n\t\t\t\t\trng.pasteHTML('<span id=\"__mce_tmp\">_</span>' + content);\n\t\t\t\t\tself.dom.remove('__mce_tmp');\n\t\t\t\t} else\n\t\t\t\t\trng.pasteHTML(content);\n\t\t\t}\n\n\t\t\t// Dispatch set content event\n\t\t\tif (!args.no_events)\n\t\t\t\tself.onSetContent.dispatch(self, args);\n\t\t},\n\n\t\t/**\n\t\t * Returns the start element of a selection range. If the start is in a text\n\t\t * node the parent element will be returned.\n\t\t *\n\t\t * @method getStart\n\t\t * @return {Element} Start element of selection range.\n\t\t */\n\t\tgetStart : function() {\n\t\t\tvar rng = this.getRng(), startElement, parentElement, checkRng, node;\n\n\t\t\tif (rng.duplicate || rng.item) {\n\t\t\t\t// Control selection, return first item\n\t\t\t\tif (rng.item)\n\t\t\t\t\treturn rng.item(0);\n\n\t\t\t\t// Get start element\n\t\t\t\tcheckRng = rng.duplicate();\n\t\t\t\tcheckRng.collapse(1);\n\t\t\t\tstartElement = checkRng.parentElement();\n\n\t\t\t\t// Check if range parent is inside the start element, then return the inner parent element\n\t\t\t\t// This will fix issues when a single element is selected, IE would otherwise return the wrong start element\n\t\t\t\tparentElement = node = rng.parentElement();\n\t\t\t\twhile (node = node.parentNode) {\n\t\t\t\t\tif (node == startElement) {\n\t\t\t\t\t\tstartElement = parentElement;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn startElement;\n\t\t\t} else {\n\t\t\t\tstartElement = rng.startContainer;\n\n\t\t\t\tif (startElement.nodeType == 1 && startElement.hasChildNodes())\n\t\t\t\t\tstartElement = startElement.childNodes[Math.min(startElement.childNodes.length - 1, rng.startOffset)];\n\n\t\t\t\tif (startElement && startElement.nodeType == 3)\n\t\t\t\t\treturn startElement.parentNode;\n\n\t\t\t\treturn startElement;\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Returns the end element of a selection range. If the end is in a text\n\t\t * node the parent element will be returned.\n\t\t *\n\t\t * @method getEnd\n\t\t * @return {Element} End element of selection range.\n\t\t */\n\t\tgetEnd : function() {\n\t\t\tvar t = this, r = t.getRng(), e, eo;\n\n\t\t\tif (r.duplicate || r.item) {\n\t\t\t\tif (r.item)\n\t\t\t\t\treturn r.item(0);\n\n\t\t\t\tr = r.duplicate();\n\t\t\t\tr.collapse(0);\n\t\t\t\te = r.parentElement();\n\n\t\t\t\tif (e && e.nodeName == 'BODY')\n\t\t\t\t\treturn e.lastChild || e;\n\n\t\t\t\treturn e;\n\t\t\t} else {\n\t\t\t\te = r.endContainer;\n\t\t\t\teo = r.endOffset;\n\n\t\t\t\tif (e.nodeType == 1 && e.hasChildNodes())\n\t\t\t\t\te = e.childNodes[eo > 0 ? eo - 1 : eo];\n\n\t\t\t\tif (e && e.nodeType == 3)\n\t\t\t\t\treturn e.parentNode;\n\n\t\t\t\treturn e;\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Returns a bookmark location for the current selection. This bookmark object\n\t\t * can then be used to restore the selection after some content modification to the document.\n\t\t *\n\t\t * @method getBookmark\n\t\t * @param {Number} type Optional state if the bookmark should be simple or not. Default is complex.\n\t\t * @param {Boolean} normalized Optional state that enables you to get a position that it would be after normalization.\n\t\t * @return {Object} Bookmark object, use moveToBookmark with this object to restore the selection.\n\t\t * @example\n\t\t * // Stores a bookmark of the current selection\n\t\t * var bm = tinyMCE.activeEditor.selection.getBookmark();\n\t\t * \n\t\t * tinyMCE.activeEditor.setContent(tinyMCE.activeEditor.getContent() + 'Some new content');\n\t\t * \n\t\t * // Restore the selection bookmark\n\t\t * tinyMCE.activeEditor.selection.moveToBookmark(bm);\n\t\t */\n\t\tgetBookmark : function(type, normalized) {\n\t\t\tvar t = this, dom = t.dom, rng, rng2, id, collapsed, name, element, index, chr = '\\uFEFF', styles;\n\n\t\t\tfunction findIndex(name, element) {\n\t\t\t\tvar index = 0;\n\n\t\t\t\teach(dom.select(name), function(node, i) {\n\t\t\t\t\tif (node == element)\n\t\t\t\t\t\tindex = i;\n\t\t\t\t});\n\n\t\t\t\treturn index;\n\t\t\t};\n\n\t\t\tif (type == 2) {\n\t\t\t\tfunction getLocation() {\n\t\t\t\t\tvar rng = t.getRng(true), root = dom.getRoot(), bookmark = {};\n\n\t\t\t\t\tfunction getPoint(rng, start) {\n\t\t\t\t\t\tvar container = rng[start ? 'startContainer' : 'endContainer'],\n\t\t\t\t\t\t\toffset = rng[start ? 'startOffset' : 'endOffset'], point = [], node, childNodes, after = 0;\n\n\t\t\t\t\t\tif (container.nodeType == 3) {\n\t\t\t\t\t\t\tif (normalized) {\n\t\t\t\t\t\t\t\tfor (node = container.previousSibling; node && node.nodeType == 3; node = node.previousSibling)\n\t\t\t\t\t\t\t\t\toffset += node.nodeValue.length;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tpoint.push(offset);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tchildNodes = container.childNodes;\n\n\t\t\t\t\t\t\tif (offset >= childNodes.length && childNodes.length) {\n\t\t\t\t\t\t\t\tafter = 1;\n\t\t\t\t\t\t\t\toffset = Math.max(0, childNodes.length - 1);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tpoint.push(t.dom.nodeIndex(childNodes[offset], normalized) + after);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tfor (; container && container != root; container = container.parentNode)\n\t\t\t\t\t\t\tpoint.push(t.dom.nodeIndex(container, normalized));\n\n\t\t\t\t\t\treturn point;\n\t\t\t\t\t};\n\n\t\t\t\t\tbookmark.start = getPoint(rng, true);\n\n\t\t\t\t\tif (!t.isCollapsed())\n\t\t\t\t\t\tbookmark.end = getPoint(rng);\n\n\t\t\t\t\treturn bookmark;\n\t\t\t\t};\n\n\t\t\t\tif (t.tridentSel)\n\t\t\t\t\treturn t.tridentSel.getBookmark(type);\n\n\t\t\t\treturn getLocation();\n\t\t\t}\n\n\t\t\t// Handle simple range\n\t\t\tif (type)\n\t\t\t\treturn {rng : t.getRng()};\n\n\t\t\trng = t.getRng();\n\t\t\tid = dom.uniqueId();\n\t\t\tcollapsed = tinyMCE.activeEditor.selection.isCollapsed();\n\t\t\tstyles = 'overflow:hidden;line-height:0px';\n\n\t\t\t// Explorer method\n\t\t\tif (rng.duplicate || rng.item) {\n\t\t\t\t// Text selection\n\t\t\t\tif (!rng.item) {\n\t\t\t\t\trng2 = rng.duplicate();\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\t// Insert start marker\n\t\t\t\t\t\trng.collapse();\n\t\t\t\t\t\trng.pasteHTML('<span data-mce-type=\"bookmark\" id=\"' + id + '_start\" style=\"' + styles + '\">' + chr + '</span>');\n\n\t\t\t\t\t\t// Insert end marker\n\t\t\t\t\t\tif (!collapsed) {\n\t\t\t\t\t\t\trng2.collapse(false);\n\n\t\t\t\t\t\t\t// Detect the empty space after block elements in IE and move the end back one character <p></p>] becomes <p>]</p>\n\t\t\t\t\t\t\trng.moveToElementText(rng2.parentElement());\n\t\t\t\t\t\t\tif (rng.compareEndPoints('StartToEnd', rng2) == 0)\n\t\t\t\t\t\t\t\trng2.move('character', -1);\n\n\t\t\t\t\t\t\trng2.pasteHTML('<span data-mce-type=\"bookmark\" id=\"' + id + '_end\" style=\"' + styles + '\">' + chr + '</span>');\n\t\t\t\t\t\t}\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// IE might throw unspecified error so lets ignore it\n\t\t\t\t\t\treturn null;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\t// Control selection\n\t\t\t\t\telement = rng.item(0);\n\t\t\t\t\tname = element.nodeName;\n\n\t\t\t\t\treturn {name : name, index : findIndex(name, element)};\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\telement = t.getNode();\n\t\t\t\tname = element.nodeName;\n\t\t\t\tif (name == 'IMG')\n\t\t\t\t\treturn {name : name, index : findIndex(name, element)};\n\n\t\t\t\t// W3C method\n\t\t\t\trng2 = rng.cloneRange();\n\n\t\t\t\t// Insert end marker\n\t\t\t\tif (!collapsed) {\n\t\t\t\t\trng2.collapse(false);\n\t\t\t\t\trng2.insertNode(dom.create('span', {'data-mce-type' : \"bookmark\", id : id + '_end', style : styles}, chr));\n\t\t\t\t}\n\n\t\t\t\trng.collapse(true);\n\t\t\t\trng.insertNode(dom.create('span', {'data-mce-type' : \"bookmark\", id : id + '_start', style : styles}, chr));\n\t\t\t}\n\n\t\t\tt.moveToBookmark({id : id, keep : 1});\n\n\t\t\treturn {id : id};\n\t\t},\n\n\t\t/**\n\t\t * Restores the selection to the specified bookmark.\n\t\t *\n\t\t * @method moveToBookmark\n\t\t * @param {Object} bookmark Bookmark to restore selection from.\n\t\t * @return {Boolean} true/false if it was successful or not.\n\t\t * @example\n\t\t * // Stores a bookmark of the current selection\n\t\t * var bm = tinyMCE.activeEditor.selection.getBookmark();\n\t\t * \n\t\t * tinyMCE.activeEditor.setContent(tinyMCE.activeEditor.getContent() + 'Some new content');\n\t\t * \n\t\t * // Restore the selection bookmark\n\t\t * tinyMCE.activeEditor.selection.moveToBookmark(bm);\n\t\t */\n\t\tmoveToBookmark : function(bookmark) {\n\t\t\tvar t = this, dom = t.dom, marker1, marker2, rng, root, startContainer, endContainer, startOffset, endOffset;\n\n\t\t\tif (bookmark) {\n\t\t\t\tif (bookmark.start) {\n\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\troot = dom.getRoot();\n\n\t\t\t\t\tfunction setEndPoint(start) {\n\t\t\t\t\t\tvar point = bookmark[start ? 'start' : 'end'], i, node, offset, children;\n\n\t\t\t\t\t\tif (point) {\n\t\t\t\t\t\t\toffset = point[0];\n\n\t\t\t\t\t\t\t// Find container node\n\t\t\t\t\t\t\tfor (node = root, i = point.length - 1; i >= 1; i--) {\n\t\t\t\t\t\t\t\tchildren = node.childNodes;\n\n\t\t\t\t\t\t\t\tif (point[i] > children.length - 1)\n\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\tnode = children[point[i]];\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Move text offset to best suitable location\n\t\t\t\t\t\t\tif (node.nodeType === 3)\n\t\t\t\t\t\t\t\toffset = Math.min(point[0], node.nodeValue.length);\n\n\t\t\t\t\t\t\t// Move element offset to best suitable location\n\t\t\t\t\t\t\tif (node.nodeType === 1)\n\t\t\t\t\t\t\t\toffset = Math.min(point[0], node.childNodes.length);\n\n\t\t\t\t\t\t\t// Set offset within container node\n\t\t\t\t\t\t\tif (start)\n\t\t\t\t\t\t\t\trng.setStart(node, offset);\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\trng.setEnd(node, offset);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t};\n\n\t\t\t\t\tif (t.tridentSel)\n\t\t\t\t\t\treturn t.tridentSel.moveToBookmark(bookmark);\n\n\t\t\t\t\tif (setEndPoint(true) && setEndPoint()) {\n\t\t\t\t\t\tt.setRng(rng);\n\t\t\t\t\t}\n\t\t\t\t} else if (bookmark.id) {\n\t\t\t\t\tfunction restoreEndPoint(suffix) {\n\t\t\t\t\t\tvar marker = dom.get(bookmark.id + '_' + suffix), node, idx, next, prev, keep = bookmark.keep;\n\n\t\t\t\t\t\tif (marker) {\n\t\t\t\t\t\t\tnode = marker.parentNode;\n\n\t\t\t\t\t\t\tif (suffix == 'start') {\n\t\t\t\t\t\t\t\tif (!keep) {\n\t\t\t\t\t\t\t\t\tidx = dom.nodeIndex(marker);\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tnode = marker.firstChild;\n\t\t\t\t\t\t\t\t\tidx = 1;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tstartContainer = endContainer = node;\n\t\t\t\t\t\t\t\tstartOffset = endOffset = idx;\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tif (!keep) {\n\t\t\t\t\t\t\t\t\tidx = dom.nodeIndex(marker);\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tnode = marker.firstChild;\n\t\t\t\t\t\t\t\t\tidx = 1;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tendContainer = node;\n\t\t\t\t\t\t\t\tendOffset = idx;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tif (!keep) {\n\t\t\t\t\t\t\t\tprev = marker.previousSibling;\n\t\t\t\t\t\t\t\tnext = marker.nextSibling;\n\n\t\t\t\t\t\t\t\t// Remove all marker text nodes\n\t\t\t\t\t\t\t\teach(tinymce.grep(marker.childNodes), function(node) {\n\t\t\t\t\t\t\t\t\tif (node.nodeType == 3)\n\t\t\t\t\t\t\t\t\t\tnode.nodeValue = node.nodeValue.replace(/\\uFEFF/g, '');\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\t// Remove marker but keep children if for example contents where inserted into the marker\n\t\t\t\t\t\t\t\t// Also remove duplicated instances of the marker for example by a split operation or by WebKit auto split on paste feature\n\t\t\t\t\t\t\t\twhile (marker = dom.get(bookmark.id + '_' + suffix))\n\t\t\t\t\t\t\t\t\tdom.remove(marker, 1);\n\n\t\t\t\t\t\t\t\t// If siblings are text nodes then merge them unless it's Opera since it some how removes the node\n\t\t\t\t\t\t\t\t// and we are sniffing since adding a lot of detection code for a browser with 3% of the market isn't worth the effort. Sorry, Opera but it's just a fact\n\t\t\t\t\t\t\t\tif (prev && next && prev.nodeType == next.nodeType && prev.nodeType == 3 && !tinymce.isOpera) {\n\t\t\t\t\t\t\t\t\tidx = prev.nodeValue.length;\n\t\t\t\t\t\t\t\t\tprev.appendData(next.nodeValue);\n\t\t\t\t\t\t\t\t\tdom.remove(next);\n\n\t\t\t\t\t\t\t\t\tif (suffix == 'start') {\n\t\t\t\t\t\t\t\t\t\tstartContainer = endContainer = prev;\n\t\t\t\t\t\t\t\t\t\tstartOffset = endOffset = idx;\n\t\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\t\tendContainer = prev;\n\t\t\t\t\t\t\t\t\t\tendOffset = idx;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t};\n\n\t\t\t\t\tfunction addBogus(node) {\n\t\t\t\t\t\t// Adds a bogus BR element for empty block elements or just a space on IE since it renders BR elements incorrectly\n\t\t\t\t\t\tif (dom.isBlock(node) && !node.innerHTML)\n\t\t\t\t\t\t\tnode.innerHTML = !isIE ? '<br data-mce-bogus=\"1\" />' : ' ';\n\n\t\t\t\t\t\treturn node;\n\t\t\t\t\t};\n\n\t\t\t\t\t// Restore start/end points\n\t\t\t\t\trestoreEndPoint('start');\n\t\t\t\t\trestoreEndPoint('end');\n\n\t\t\t\t\tif (startContainer) {\n\t\t\t\t\t\trng = dom.createRng();\n\t\t\t\t\t\trng.setStart(addBogus(startContainer), startOffset);\n\t\t\t\t\t\trng.setEnd(addBogus(endContainer), endOffset);\n\t\t\t\t\t\tt.setRng(rng);\n\t\t\t\t\t}\n\t\t\t\t} else if (bookmark.name) {\n\t\t\t\t\tt.select(dom.select(bookmark.name)[bookmark.index]);\n\t\t\t\t} else if (bookmark.rng)\n\t\t\t\t\tt.setRng(bookmark.rng);\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Selects the specified element. This will place the start and end of the selection range around the element.\n\t\t *\n\t\t * @method select\n\t\t * @param {Element} node HMTL DOM element to select.\n\t\t * @param {Boolean} content Optional bool state if the contents should be selected or not on non IE browser.\n\t\t * @return {Element} Selected element the same element as the one that got passed in.\n\t\t * @example\n\t\t * // Select the first paragraph in the active editor\n\t\t * tinyMCE.activeEditor.selection.select(tinyMCE.activeEditor.dom.select('p')[0]);\n\t\t */\n\t\tselect : function(node, content) {\n\t\t\tvar t = this, dom = t.dom, rng = dom.createRng(), idx;\n\n\t\t\tif (node) {\n\t\t\t\tidx = dom.nodeIndex(node);\n\t\t\t\trng.setStart(node.parentNode, idx);\n\t\t\t\trng.setEnd(node.parentNode, idx + 1);\n\n\t\t\t\t// Find first/last text node or BR element\n\t\t\t\tif (content) {\n\t\t\t\t\tfunction setPoint(node, start) {\n\t\t\t\t\t\tvar walker = new tinymce.dom.TreeWalker(node, node);\n\n\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t// Text node\n\t\t\t\t\t\t\tif (node.nodeType == 3 && tinymce.trim(node.nodeValue).length != 0) {\n\t\t\t\t\t\t\t\tif (start)\n\t\t\t\t\t\t\t\t\trng.setStart(node, 0);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\trng.setEnd(node, node.nodeValue.length);\n\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// BR element\n\t\t\t\t\t\t\tif (node.nodeName == 'BR') {\n\t\t\t\t\t\t\t\tif (start)\n\t\t\t\t\t\t\t\t\trng.setStartBefore(node);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\trng.setEndBefore(node);\n\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} while (node = (start ? walker.next() : walker.prev()));\n\t\t\t\t\t};\n\n\t\t\t\t\tsetPoint(node, 1);\n\t\t\t\t\tsetPoint(node);\n\t\t\t\t}\n\n\t\t\t\tt.setRng(rng);\n\t\t\t}\n\n\t\t\treturn node;\n\t\t},\n\n\t\t/**\n\t\t * Returns true/false if the selection range is collapsed or not. Collapsed means if it's a caret or a larger selection.\n\t\t *\n\t\t * @method isCollapsed\n\t\t * @return {Boolean} true/false state if the selection range is collapsed or not. Collapsed means if it's a caret or a larger selection.\n\t\t */\n\t\tisCollapsed : function() {\n\t\t\tvar t = this, r = t.getRng(), s = t.getSel();\n\n\t\t\tif (!r || r.item)\n\t\t\t\treturn false;\n\n\t\t\tif (r.compareEndPoints)\n\t\t\t\treturn r.compareEndPoints('StartToEnd', r) === 0;\n\n\t\t\treturn !s || r.collapsed;\n\t\t},\n\n\t\t/**\n\t\t * Collapse the selection to start or end of range.\n\t\t *\n\t\t * @method collapse\n\t\t * @param {Boolean} to_start Optional boolean state if to collapse to end or not. Defaults to start.\n\t\t */\n\t\tcollapse : function(to_start) {\n\t\t\tvar self = this, rng = self.getRng(), node;\n\n\t\t\t// Control range on IE\n\t\t\tif (rng.item) {\n\t\t\t\tnode = rng.item(0);\n\t\t\t\trng = self.win.document.body.createTextRange();\n\t\t\t\trng.moveToElementText(node);\n\t\t\t}\n\n\t\t\trng.collapse(!!to_start);\n\t\t\tself.setRng(rng);\n\t\t},\n\n\t\t/**\n\t\t * Returns the browsers internal selection object.\n\t\t *\n\t\t * @method getSel\n\t\t * @return {Selection} Internal browser selection object.\n\t\t */\n\t\tgetSel : function() {\n\t\t\tvar t = this, w = this.win;\n\n\t\t\treturn w.getSelection ? w.getSelection() : w.document.selection;\n\t\t},\n\n\t\t/**\n\t\t * Returns the browsers internal range object.\n\t\t *\n\t\t * @method getRng\n\t\t * @param {Boolean} w3c Forces a compatible W3C range on IE.\n\t\t * @return {Range} Internal browser range object.\n\t\t * @see http://www.quirksmode.org/dom/range_intro.html\n\t\t * @see http://www.dotvoid.com/2001/03/using-the-range-object-in-mozilla/\n\t\t */\n\t\tgetRng : function(w3c) {\n\t\t\tvar t = this, s, r, elm, doc = t.win.document;\n\n\t\t\t// Found tridentSel object then we need to use that one\n\t\t\tif (w3c && t.tridentSel)\n\t\t\t\treturn t.tridentSel.getRangeAt(0);\n\n\t\t\ttry {\n\t\t\t\tif (s = t.getSel())\n\t\t\t\t\tr = s.rangeCount > 0 ? s.getRangeAt(0) : (s.createRange ? s.createRange() : doc.createRange());\n\t\t\t} catch (ex) {\n\t\t\t\t// IE throws unspecified error here if TinyMCE is placed in a frame/iframe\n\t\t\t}\n\n\t\t\t// We have W3C ranges and it's IE then fake control selection since IE9 doesn't handle that correctly yet\n\t\t\tif (tinymce.isIE && r && r.setStart && doc.selection.createRange().item) {\n\t\t\t\telm = doc.selection.createRange().item(0);\n\t\t\t\tr = doc.createRange();\n\t\t\t\tr.setStartBefore(elm);\n\t\t\t\tr.setEndAfter(elm);\n\t\t\t}\n\n\t\t\t// No range found then create an empty one\n\t\t\t// This can occur when the editor is placed in a hidden container element on Gecko\n\t\t\t// Or on IE when there was an exception\n\t\t\tif (!r)\n\t\t\t\tr = doc.createRange ? doc.createRange() : doc.body.createTextRange();\n\n\t\t\tif (t.selectedRange && t.explicitRange) {\n\t\t\t\tif (r.compareBoundaryPoints(r.START_TO_START, t.selectedRange) === 0 && r.compareBoundaryPoints(r.END_TO_END, t.selectedRange) === 0) {\n\t\t\t\t\t// Safari, Opera and Chrome only ever select text which causes the range to change.\n\t\t\t\t\t// This lets us use the originally set range if the selection hasn't been changed by the user.\n\t\t\t\t\tr = t.explicitRange;\n\t\t\t\t} else {\n\t\t\t\t\tt.selectedRange = null;\n\t\t\t\t\tt.explicitRange = null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn r;\n\t\t},\n\n\t\t/**\n\t\t * Changes the selection to the specified DOM range.\n\t\t *\n\t\t * @method setRng\n\t\t * @param {Range} r Range to select.\n\t\t */\n\t\tsetRng : function(r) {\n\t\t\tvar s, t = this;\n\t\t\t\n\t\t\tif (!t.tridentSel) {\n\t\t\t\ts = t.getSel();\n\n\t\t\t\tif (s) {\n\t\t\t\t\tt.explicitRange = r;\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\ts.removeAllRanges();\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// IE9 might throw errors here don't know why\n\t\t\t\t\t}\n\n\t\t\t\t\ts.addRange(r);\n\t\t\t\t\tt.selectedRange = s.getRangeAt(0);\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Is W3C Range\n\t\t\t\tif (r.cloneRange) {\n\t\t\t\t\tt.tridentSel.addRange(r);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Is IE specific range\n\t\t\t\ttry {\n\t\t\t\t\tr.select();\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Needed for some odd IE bug #1843306\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Sets the current selection to the specified DOM element.\n\t\t *\n\t\t * @method setNode\n\t\t * @param {Element} n Element to set as the contents of the selection.\n\t\t * @return {Element} Returns the element that got passed in.\n\t\t * @example\n\t\t * // Inserts a DOM node at current selection/caret location\n\t\t * tinyMCE.activeEditor.selection.setNode(tinyMCE.activeEditor.dom.create('img', {src : 'some.gif', title : 'some title'}));\n\t\t */\n\t\tsetNode : function(n) {\n\t\t\tvar t = this;\n\n\t\t\tt.setContent(t.dom.getOuterHTML(n));\n\n\t\t\treturn n;\n\t\t},\n\n\t\t/**\n\t\t * Returns the currently selected element or the common ancestor element for both start and end of the selection.\n\t\t *\n\t\t * @method getNode\n\t\t * @return {Element} Currently selected element or common ancestor element.\n\t\t * @example\n\t\t * // Alerts the currently selected elements node name\n\t\t * alert(tinyMCE.activeEditor.selection.getNode().nodeName);\n\t\t */\n\t\tgetNode : function() {\n\t\t\tvar t = this, rng = t.getRng(), sel = t.getSel(), elm, start = rng.startContainer, end = rng.endContainer;\n\n\t\t\t// Range maybe lost after the editor is made visible again\n\t\t\tif (!rng)\n\t\t\t\treturn t.dom.getRoot();\n\n\t\t\tif (rng.setStart) {\n\t\t\t\telm = rng.commonAncestorContainer;\n\n\t\t\t\t// Handle selection a image or other control like element such as anchors\n\t\t\t\tif (!rng.collapsed) {\n\t\t\t\t\tif (rng.startContainer == rng.endContainer) {\n\t\t\t\t\t\tif (rng.endOffset - rng.startOffset < 2) {\n\t\t\t\t\t\t\tif (rng.startContainer.hasChildNodes())\n\t\t\t\t\t\t\t\telm = rng.startContainer.childNodes[rng.startOffset];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// If the anchor node is a element instead of a text node then return this element\n\t\t\t\t\t//if (tinymce.isWebKit && sel.anchorNode && sel.anchorNode.nodeType == 1) \n\t\t\t\t\t//\treturn sel.anchorNode.childNodes[sel.anchorOffset];\n\n\t\t\t\t\t// Handle cases where the selection is immediately wrapped around a node and return that node instead of it's parent.\n\t\t\t\t\t// This happens when you double click an underlined word in FireFox.\n\t\t\t\t\tif (start.nodeType === 3 && end.nodeType === 3) {\n\t\t\t\t\t\tfunction skipEmptyTextNodes(n, forwards) {\n\t\t\t\t\t\t\tvar orig = n;\n\t\t\t\t\t\t\twhile (n && n.nodeType === 3 && n.length === 0) {\n\t\t\t\t\t\t\t\tn = forwards ? n.nextSibling : n.previousSibling;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn n || orig;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (start.length === rng.startOffset) {\n\t\t\t\t\t\t\tstart = skipEmptyTextNodes(start.nextSibling, true);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tstart = start.parentNode;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (rng.endOffset === 0) {\n\t\t\t\t\t\t\tend = skipEmptyTextNodes(end.previousSibling, false);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tend = end.parentNode;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (start && start === end)\n\t\t\t\t\t\t\treturn start;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (elm && elm.nodeType == 3)\n\t\t\t\t\treturn elm.parentNode;\n\n\t\t\t\treturn elm;\n\t\t\t}\n\n\t\t\treturn rng.item ? rng.item(0) : rng.parentElement();\n\t\t},\n\n\t\tgetSelectedBlocks : function(st, en) {\n\t\t\tvar t = this, dom = t.dom, sb, eb, n, bl = [];\n\n\t\t\tsb = dom.getParent(st || t.getStart(), dom.isBlock);\n\t\t\teb = dom.getParent(en || t.getEnd(), dom.isBlock);\n\n\t\t\tif (sb)\n\t\t\t\tbl.push(sb);\n\n\t\t\tif (sb && eb && sb != eb) {\n\t\t\t\tn = sb;\n\n\t\t\t\tvar walker = new tinymce.dom.TreeWalker(sb, dom.getRoot());\n\t\t\t\twhile ((n = walker.next()) && n != eb) {\n\t\t\t\t\tif (dom.isBlock(n))\n\t\t\t\t\t\tbl.push(n);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (eb && sb != eb)\n\t\t\t\tbl.push(eb);\n\n\t\t\treturn bl;\n\t\t},\n\n\t\tnormalize : function() {\n\t\t\tvar self = this, rng, normalized;\n\n\t\t\t// Normalize only on non IE browsers for now\n\t\t\tif (tinymce.isIE)\n\t\t\t\treturn;\n\n\t\t\tfunction normalizeEndPoint(start) {\n\t\t\t\tvar container, offset, walker, dom = self.dom, body = dom.getRoot(), node;\n\n\t\t\t\tcontainer = rng[(start ? 'start' : 'end') + 'Container'];\n\t\t\t\toffset = rng[(start ? 'start' : 'end') + 'Offset'];\n\n\t\t\t\t// If the container is a document move it to the body element\n\t\t\t\tif (container.nodeType === 9) {\n\t\t\t\t\tcontainer = container.body;\n\t\t\t\t\toffset = 0;\n\t\t\t\t}\n\n\t\t\t\t// If the container is body try move it into the closest text node or position\n\t\t\t\t// TODO: Add more logic here to handle element selection cases\n\t\t\t\tif (container === body) {\n\t\t\t\t\t// Resolve the index\n\t\t\t\t\tif (container.hasChildNodes()) {\n\t\t\t\t\t\tcontainer = container.childNodes[Math.min(!start && offset > 0 ? offset - 1 : offset, container.childNodes.length - 1)];\n\t\t\t\t\t\toffset = 0;\n\n\t\t\t\t\t\t// Don't walk into elements that doesn't have any child nodes like a IMG\n\t\t\t\t\t\tif (container.hasChildNodes()) {\n\t\t\t\t\t\t\t// Walk the DOM to find a text node to place the caret at or a BR\n\t\t\t\t\t\t\tnode = container;\n\t\t\t\t\t\t\twalker = new tinymce.dom.TreeWalker(container, body);\n\t\t\t\t\t\t\tdo {\n\t\t\t\t\t\t\t\t// Found a text node use that position\n\t\t\t\t\t\t\t\tif (node.nodeType === 3) {\n\t\t\t\t\t\t\t\t\toffset = start ? 0 : node.nodeValue.length - 1;\n\t\t\t\t\t\t\t\t\tcontainer = node;\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\t// Found a BR element that we can place the caret before\n\t\t\t\t\t\t\t\tif (node.nodeName === 'BR') {\n\t\t\t\t\t\t\t\t\toffset = dom.nodeIndex(node);\n\t\t\t\t\t\t\t\t\tcontainer = node.parentNode;\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} while (node = (start ? walker.next() : walker.prev()));\n\n\t\t\t\t\t\t\tnormalized = true;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Set endpoint if it was normalized\n\t\t\t\tif (normalized)\n\t\t\t\t\trng['set' + (start ? 'Start' : 'End')](container, offset);\n\t\t\t};\n\n\t\t\trng = self.getRng();\n\n\t\t\t// Normalize the end points\n\t\t\tnormalizeEndPoint(true);\n\t\t\t\n\t\t\tif (rng.collapsed)\n\t\t\t\tnormalizeEndPoint();\n\n\t\t\t// Set the selection if it was normalized\n\t\t\tif (normalized) {\n\t\t\t\t//console.log(self.dom.dumpRng(rng));\n\t\t\t\tself.setRng(rng);\n\t\t\t}\n\t\t},\n\n\t\tdestroy : function(s) {\n\t\t\tvar t = this;\n\n\t\t\tt.win = null;\n\n\t\t\t// Manual destroy then remove unload handler\n\t\t\tif (!s)\n\t\t\t\ttinymce.removeUnload(t.destroy);\n\t\t},\n\n\t\t// IE has an issue where you can't select/move the caret by clicking outside the body if the document is in standards mode\n\t\t_fixIESelection : function() {\n\t\t\tvar dom = this.dom, doc = dom.doc, body = doc.body, started, startRng, htmlElm;\n\n\t\t\t// Make HTML element unselectable since we are going to handle selection by hand\n\t\t\tdoc.documentElement.unselectable = true;\n\n\t\t\t// Return range from point or null if it failed\n\t\t\tfunction rngFromPoint(x, y) {\n\t\t\t\tvar rng = body.createTextRange();\n\n\t\t\t\ttry {\n\t\t\t\t\trng.moveToPoint(x, y);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// IE sometimes throws and exception, so lets just ignore it\n\t\t\t\t\trng = null;\n\t\t\t\t}\n\n\t\t\t\treturn rng;\n\t\t\t};\n\n\t\t\t// Fires while the selection is changing\n\t\t\tfunction selectionChange(e) {\n\t\t\t\tvar pointRng;\n\n\t\t\t\t// Check if the button is down or not\n\t\t\t\tif (e.button) {\n\t\t\t\t\t// Create range from mouse position\n\t\t\t\t\tpointRng = rngFromPoint(e.x, e.y);\n\n\t\t\t\t\tif (pointRng) {\n\t\t\t\t\t\t// Check if pointRange is before/after selection then change the endPoint\n\t\t\t\t\t\tif (pointRng.compareEndPoints('StartToStart', startRng) > 0)\n\t\t\t\t\t\t\tpointRng.setEndPoint('StartToStart', startRng);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tpointRng.setEndPoint('EndToEnd', startRng);\n\n\t\t\t\t\t\tpointRng.select();\n\t\t\t\t\t}\n\t\t\t\t} else\n\t\t\t\t\tendSelection();\n\t\t\t}\n\n\t\t\t// Removes listeners\n\t\t\tfunction endSelection() {\n\t\t\t\tvar rng = doc.selection.createRange();\n\n\t\t\t\t// If the range is collapsed then use the last start range\n\t\t\t\tif (startRng && !rng.item && rng.compareEndPoints('StartToEnd', rng) === 0)\n\t\t\t\t\tstartRng.select();\n\n\t\t\t\tdom.unbind(doc, 'mouseup', endSelection);\n\t\t\t\tdom.unbind(doc, 'mousemove', selectionChange);\n\t\t\t\tstartRng = started = 0;\n\t\t\t};\n\n\t\t\t// Detect when user selects outside BODY\n\t\t\tdom.bind(doc, ['mousedown', 'contextmenu'], function(e) {\n\t\t\t\tif (e.target.nodeName === 'HTML') {\n\t\t\t\t\tif (started)\n\t\t\t\t\t\tendSelection();\n\n\t\t\t\t\t// Detect vertical scrollbar, since IE will fire a mousedown on the scrollbar and have target set as HTML\n\t\t\t\t\thtmlElm = doc.documentElement;\n\t\t\t\t\tif (htmlElm.scrollHeight > htmlElm.clientHeight)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\tstarted = 1;\n\t\t\t\t\t// Setup start position\n\t\t\t\t\tstartRng = rngFromPoint(e.x, e.y);\n\t\t\t\t\tif (startRng) {\n\t\t\t\t\t\t// Listen for selection change events\n\t\t\t\t\t\tdom.bind(doc, 'mouseup', endSelection);\n\t\t\t\t\t\tdom.bind(doc, 'mousemove', selectionChange);\n\n\t\t\t\t\t\tdom.win.focus();\n\t\t\t\t\t\tstartRng.select();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t});\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/dom/Sizzle.js":"// #ifndef jquery\n\n/*\n * Sizzle CSS Selector Engine - v1.0\n *  Copyright 2009, The Dojo Foundation\n *  Released under the MIT, BSD, and GPL Licenses.\n *  More information: http://sizzlejs.com/\n */\n(function(){\n\nvar chunker = /((?:\\((?:\\([^()]+\\)|[^()]+)+\\)|\\[(?:\\[[^\\[\\]]*\\]|['\"][^'\"]*['\"]|[^\\[\\]'\"]+)+\\]|\\\\.|[^ >+~,(\\[\\\\]+)+|[>+~])(\\s*,\\s*)?((?:.|\\r|\\n)*)/g,\n\tdone = 0,\n\ttoString = Object.prototype.toString,\n\thasDuplicate = false,\n\tbaseHasDuplicate = true;\n\n// Here we check if the JavaScript engine is using some sort of\n// optimization where it does not always call our comparision\n// function. If that is the case, discard the hasDuplicate value.\n//   Thus far that includes Google Chrome.\n[0, 0].sort(function(){\n\tbaseHasDuplicate = false;\n\treturn 0;\n});\n\nvar Sizzle = function(selector, context, results, seed) {\n\tresults = results || [];\n\tcontext = context || document;\n\n\tvar origContext = context;\n\n\tif ( context.nodeType !== 1 && context.nodeType !== 9 ) {\n\t\treturn [];\n\t}\n\t\n\tif ( !selector || typeof selector !== \"string\" ) {\n\t\treturn results;\n\t}\n\n\tvar parts = [], m, set, checkSet, extra, prune = true, contextXML = Sizzle.isXML(context),\n\t\tsoFar = selector, ret, cur, pop, i;\n\t\n\t// Reset the position of the chunker regexp (start from head)\n\tdo {\n\t\tchunker.exec(\"\");\n\t\tm = chunker.exec(soFar);\n\n\t\tif ( m ) {\n\t\t\tsoFar = m[3];\n\t\t\n\t\t\tparts.push( m[1] );\n\t\t\n\t\t\tif ( m[2] ) {\n\t\t\t\textra = m[3];\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\t} while ( m );\n\n\tif ( parts.length > 1 && origPOS.exec( selector ) ) {\n\t\tif ( parts.length === 2 && Expr.relative[ parts[0] ] ) {\n\t\t\tset = posProcess( parts[0] + parts[1], context );\n\t\t} else {\n\t\t\tset = Expr.relative[ parts[0] ] ?\n\t\t\t\t[ context ] :\n\t\t\t\tSizzle( parts.shift(), context );\n\n\t\t\twhile ( parts.length ) {\n\t\t\t\tselector = parts.shift();\n\n\t\t\t\tif ( Expr.relative[ selector ] ) {\n\t\t\t\t\tselector += parts.shift();\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\tset = posProcess( selector, set );\n\t\t\t}\n\t\t}\n\t} else {\n\t\t// Take a shortcut and set the context if the root selector is an ID\n\t\t// (but not if it'll be faster if the inner selector is an ID)\n\t\tif ( !seed && parts.length > 1 && context.nodeType === 9 && !contextXML &&\n\t\t\t\tExpr.match.ID.test(parts[0]) && !Expr.match.ID.test(parts[parts.length - 1]) ) {\n\t\t\tret = Sizzle.find( parts.shift(), context, contextXML );\n\t\t\tcontext = ret.expr ? Sizzle.filter( ret.expr, ret.set )[0] : ret.set[0];\n\t\t}\n\n\t\tif ( context ) {\n\t\t\tret = seed ?\n\t\t\t\t{ expr: parts.pop(), set: makeArray(seed) } :\n\t\t\t\tSizzle.find( parts.pop(), parts.length === 1 && (parts[0] === \"~\" || parts[0] === \"+\") && context.parentNode ? context.parentNode : context, contextXML );\n\t\t\tset = ret.expr ? Sizzle.filter( ret.expr, ret.set ) : ret.set;\n\n\t\t\tif ( parts.length > 0 ) {\n\t\t\t\tcheckSet = makeArray(set);\n\t\t\t} else {\n\t\t\t\tprune = false;\n\t\t\t}\n\n\t\t\twhile ( parts.length ) {\n\t\t\t\tcur = parts.pop();\n\t\t\t\tpop = cur;\n\n\t\t\t\tif ( !Expr.relative[ cur ] ) {\n\t\t\t\t\tcur = \"\";\n\t\t\t\t} else {\n\t\t\t\t\tpop = parts.pop();\n\t\t\t\t}\n\n\t\t\t\tif ( pop == null ) {\n\t\t\t\t\tpop = context;\n\t\t\t\t}\n\n\t\t\t\tExpr.relative[ cur ]( checkSet, pop, contextXML );\n\t\t\t}\n\t\t} else {\n\t\t\tcheckSet = parts = [];\n\t\t}\n\t}\n\n\tif ( !checkSet ) {\n\t\tcheckSet = set;\n\t}\n\n\tif ( !checkSet ) {\n\t\tSizzle.error( cur || selector );\n\t}\n\n\tif ( toString.call(checkSet) === \"[object Array]\" ) {\n\t\tif ( !prune ) {\n\t\t\tresults.push.apply( results, checkSet );\n\t\t} else if ( context && context.nodeType === 1 ) {\n\t\t\tfor ( i = 0; checkSet[i] != null; i++ ) {\n\t\t\t\tif ( checkSet[i] && (checkSet[i] === true || checkSet[i].nodeType === 1 && Sizzle.contains(context, checkSet[i])) ) {\n\t\t\t\t\tresults.push( set[i] );\n\t\t\t\t}\n\t\t\t}\n\t\t} else {\n\t\t\tfor ( i = 0; checkSet[i] != null; i++ ) {\n\t\t\t\tif ( checkSet[i] && checkSet[i].nodeType === 1 ) {\n\t\t\t\t\tresults.push( set[i] );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t} else {\n\t\tmakeArray( checkSet, results );\n\t}\n\n\tif ( extra ) {\n\t\tSizzle( extra, origContext, results, seed );\n\t\tSizzle.uniqueSort( results );\n\t}\n\n\treturn results;\n};\n\nSizzle.uniqueSort = function(results){\n\tif ( sortOrder ) {\n\t\thasDuplicate = baseHasDuplicate;\n\t\tresults.sort(sortOrder);\n\n\t\tif ( hasDuplicate ) {\n\t\t\tfor ( var i = 1; i < results.length; i++ ) {\n\t\t\t\tif ( results[i] === results[i-1] ) {\n\t\t\t\t\tresults.splice(i--, 1);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\treturn results;\n};\n\nSizzle.matches = function(expr, set){\n\treturn Sizzle(expr, null, null, set);\n};\n\nSizzle.find = function(expr, context, isXML){\n\tvar set;\n\n\tif ( !expr ) {\n\t\treturn [];\n\t}\n\n\tfor ( var i = 0, l = Expr.order.length; i < l; i++ ) {\n\t\tvar type = Expr.order[i], match;\n\t\t\n\t\tif ( (match = Expr.leftMatch[ type ].exec( expr )) ) {\n\t\t\tvar left = match[1];\n\t\t\tmatch.splice(1,1);\n\n\t\t\tif ( left.substr( left.length - 1 ) !== \"\\\\\" ) {\n\t\t\t\tmatch[1] = (match[1] || \"\").replace(/\\\\/g, \"\");\n\t\t\t\tset = Expr.find[ type ]( match, context, isXML );\n\t\t\t\tif ( set != null ) {\n\t\t\t\t\texpr = expr.replace( Expr.match[ type ], \"\" );\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\tif ( !set ) {\n\t\tset = context.getElementsByTagName(\"*\");\n\t}\n\n\treturn {set: set, expr: expr};\n};\n\nSizzle.filter = function(expr, set, inplace, not){\n\tvar old = expr, result = [], curLoop = set, match, anyFound,\n\t\tisXMLFilter = set && set[0] && Sizzle.isXML(set[0]);\n\n\twhile ( expr && set.length ) {\n\t\tfor ( var type in Expr.filter ) {\n\t\t\tif ( (match = Expr.leftMatch[ type ].exec( expr )) != null && match[2] ) {\n\t\t\t\tvar filter = Expr.filter[ type ], found, item, left = match[1];\n\t\t\t\tanyFound = false;\n\n\t\t\t\tmatch.splice(1,1);\n\n\t\t\t\tif ( left.substr( left.length - 1 ) === \"\\\\\" ) {\n\t\t\t\t\tcontinue;\n\t\t\t\t}\n\n\t\t\t\tif ( curLoop === result ) {\n\t\t\t\t\tresult = [];\n\t\t\t\t}\n\n\t\t\t\tif ( Expr.preFilter[ type ] ) {\n\t\t\t\t\tmatch = Expr.preFilter[ type ]( match, curLoop, inplace, result, not, isXMLFilter );\n\n\t\t\t\t\tif ( !match ) {\n\t\t\t\t\t\tanyFound = found = true;\n\t\t\t\t\t} else if ( match === true ) {\n\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ( match ) {\n\t\t\t\t\tfor ( var i = 0; (item = curLoop[i]) != null; i++ ) {\n\t\t\t\t\t\tif ( item ) {\n\t\t\t\t\t\t\tfound = filter( item, match, i, curLoop );\n\t\t\t\t\t\t\tvar pass = not ^ !!found;\n\n\t\t\t\t\t\t\tif ( inplace && found != null ) {\n\t\t\t\t\t\t\t\tif ( pass ) {\n\t\t\t\t\t\t\t\t\tanyFound = true;\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tcurLoop[i] = false;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t} else if ( pass ) {\n\t\t\t\t\t\t\t\tresult.push( item );\n\t\t\t\t\t\t\t\tanyFound = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ( found !== undefined ) {\n\t\t\t\t\tif ( !inplace ) {\n\t\t\t\t\t\tcurLoop = result;\n\t\t\t\t\t}\n\n\t\t\t\t\texpr = expr.replace( Expr.match[ type ], \"\" );\n\n\t\t\t\t\tif ( !anyFound ) {\n\t\t\t\t\t\treturn [];\n\t\t\t\t\t}\n\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Improper expression\n\t\tif ( expr === old ) {\n\t\t\tif ( anyFound == null ) {\n\t\t\t\tSizzle.error( expr );\n\t\t\t} else {\n\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\n\t\told = expr;\n\t}\n\n\treturn curLoop;\n};\n\nSizzle.error = function( msg ) {\n\tthrow \"Syntax error, unrecognized expression: \" + msg;\n};\n\nvar Expr = Sizzle.selectors = {\n\torder: [ \"ID\", \"NAME\", \"TAG\" ],\n\tmatch: {\n\t\tID: /#((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)/,\n\t\tCLASS: /\\.((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)/,\n\t\tNAME: /\\[name=['\"]*((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)['\"]*\\]/,\n\t\tATTR: /\\[\\s*((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)\\s*(?:(\\S?=)\\s*(['\"]*)(.*?)\\3|)\\s*\\]/,\n\t\tTAG: /^((?:[\\w\\u00c0-\\uFFFF\\*\\-]|\\\\.)+)/,\n\t\tCHILD: /:(only|nth|last|first)-child(?:\\((even|odd|[\\dn+\\-]*)\\))?/,\n\t\tPOS: /:(nth|eq|gt|lt|first|last|even|odd)(?:\\((\\d*)\\))?(?=[^\\-]|$)/,\n\t\tPSEUDO: /:((?:[\\w\\u00c0-\\uFFFF\\-]|\\\\.)+)(?:\\((['\"]?)((?:\\([^\\)]+\\)|[^\\(\\)]*)+)\\2\\))?/\n\t},\n\tleftMatch: {},\n\tattrMap: {\n\t\t\"class\": \"className\",\n\t\t\"for\": \"htmlFor\"\n\t},\n\tattrHandle: {\n\t\thref: function(elem){\n\t\t\treturn elem.getAttribute(\"href\");\n\t\t}\n\t},\n\trelative: {\n\t\t\"+\": function(checkSet, part){\n\t\t\tvar isPartStr = typeof part === \"string\",\n\t\t\t\tisTag = isPartStr && !/\\W/.test(part),\n\t\t\t\tisPartStrNotTag = isPartStr && !isTag;\n\n\t\t\tif ( isTag ) {\n\t\t\t\tpart = part.toLowerCase();\n\t\t\t}\n\n\t\t\tfor ( var i = 0, l = checkSet.length, elem; i < l; i++ ) {\n\t\t\t\tif ( (elem = checkSet[i]) ) {\n\t\t\t\t\twhile ( (elem = elem.previousSibling) && elem.nodeType !== 1 ) {}\n\n\t\t\t\t\tcheckSet[i] = isPartStrNotTag || elem && elem.nodeName.toLowerCase() === part ?\n\t\t\t\t\t\telem || false :\n\t\t\t\t\t\telem === part;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( isPartStrNotTag ) {\n\t\t\t\tSizzle.filter( part, checkSet, true );\n\t\t\t}\n\t\t},\n\t\t\">\": function(checkSet, part){\n\t\t\tvar isPartStr = typeof part === \"string\",\n\t\t\t\telem, i = 0, l = checkSet.length;\n\n\t\t\tif ( isPartStr && !/\\W/.test(part) ) {\n\t\t\t\tpart = part.toLowerCase();\n\n\t\t\t\tfor ( ; i < l; i++ ) {\n\t\t\t\t\telem = checkSet[i];\n\t\t\t\t\tif ( elem ) {\n\t\t\t\t\t\tvar parent = elem.parentNode;\n\t\t\t\t\t\tcheckSet[i] = parent.nodeName.toLowerCase() === part ? parent : false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tfor ( ; i < l; i++ ) {\n\t\t\t\t\telem = checkSet[i];\n\t\t\t\t\tif ( elem ) {\n\t\t\t\t\t\tcheckSet[i] = isPartStr ?\n\t\t\t\t\t\t\telem.parentNode :\n\t\t\t\t\t\t\telem.parentNode === part;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif ( isPartStr ) {\n\t\t\t\t\tSizzle.filter( part, checkSet, true );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"\": function(checkSet, part, isXML){\n\t\t\tvar doneName = done++, checkFn = dirCheck, nodeCheck;\n\n\t\t\tif ( typeof part === \"string\" && !/\\W/.test(part) ) {\n\t\t\t\tpart = part.toLowerCase();\n\t\t\t\tnodeCheck = part;\n\t\t\t\tcheckFn = dirNodeCheck;\n\t\t\t}\n\n\t\t\tcheckFn(\"parentNode\", part, doneName, checkSet, nodeCheck, isXML);\n\t\t},\n\t\t\"~\": function(checkSet, part, isXML){\n\t\t\tvar doneName = done++, checkFn = dirCheck, nodeCheck;\n\n\t\t\tif ( typeof part === \"string\" && !/\\W/.test(part) ) {\n\t\t\t\tpart = part.toLowerCase();\n\t\t\t\tnodeCheck = part;\n\t\t\t\tcheckFn = dirNodeCheck;\n\t\t\t}\n\n\t\t\tcheckFn(\"previousSibling\", part, doneName, checkSet, nodeCheck, isXML);\n\t\t}\n\t},\n\tfind: {\n\t\tID: function(match, context, isXML){\n\t\t\tif ( typeof context.getElementById !== \"undefined\" && !isXML ) {\n\t\t\t\tvar m = context.getElementById(match[1]);\n\t\t\t\treturn m ? [m] : [];\n\t\t\t}\n\t\t},\n\t\tNAME: function(match, context){\n\t\t\tif ( typeof context.getElementsByName !== \"undefined\" ) {\n\t\t\t\tvar ret = [], results = context.getElementsByName(match[1]);\n\n\t\t\t\tfor ( var i = 0, l = results.length; i < l; i++ ) {\n\t\t\t\t\tif ( results[i].getAttribute(\"name\") === match[1] ) {\n\t\t\t\t\t\tret.push( results[i] );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn ret.length === 0 ? null : ret;\n\t\t\t}\n\t\t},\n\t\tTAG: function(match, context){\n\t\t\treturn context.getElementsByTagName(match[1]);\n\t\t}\n\t},\n\tpreFilter: {\n\t\tCLASS: function(match, curLoop, inplace, result, not, isXML){\n\t\t\tmatch = \" \" + match[1].replace(/\\\\/g, \"\") + \" \";\n\n\t\t\tif ( isXML ) {\n\t\t\t\treturn match;\n\t\t\t}\n\n\t\t\tfor ( var i = 0, elem; (elem = curLoop[i]) != null; i++ ) {\n\t\t\t\tif ( elem ) {\n\t\t\t\t\tif ( not ^ (elem.className && (\" \" + elem.className + \" \").replace(/[\\t\\n]/g, \" \").indexOf(match) >= 0) ) {\n\t\t\t\t\t\tif ( !inplace ) {\n\t\t\t\t\t\t\tresult.push( elem );\n\t\t\t\t\t\t}\n\t\t\t\t\t} else if ( inplace ) {\n\t\t\t\t\t\tcurLoop[i] = false;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn false;\n\t\t},\n\t\tID: function(match){\n\t\t\treturn match[1].replace(/\\\\/g, \"\");\n\t\t},\n\t\tTAG: function(match, curLoop){\n\t\t\treturn match[1].toLowerCase();\n\t\t},\n\t\tCHILD: function(match){\n\t\t\tif ( match[1] === \"nth\" ) {\n\t\t\t\t// parse equations like 'even', 'odd', '5', '2n', '3n+2', '4n-1', '-n+6'\n\t\t\t\tvar test = /(-?)(\\d*)n((?:\\+|-)?\\d*)/.exec(\n\t\t\t\t\tmatch[2] === \"even\" && \"2n\" || match[2] === \"odd\" && \"2n+1\" ||\n\t\t\t\t\t!/\\D/.test( match[2] ) && \"0n+\" + match[2] || match[2]);\n\n\t\t\t\t// calculate the numbers (first)n+(last) including if they are negative\n\t\t\t\tmatch[2] = (test[1] + (test[2] || 1)) - 0;\n\t\t\t\tmatch[3] = test[3] - 0;\n\t\t\t}\n\n\t\t\t// TODO: Move to normal caching system\n\t\t\tmatch[0] = done++;\n\n\t\t\treturn match;\n\t\t},\n\t\tATTR: function(match, curLoop, inplace, result, not, isXML){\n\t\t\tvar name = match[1].replace(/\\\\/g, \"\");\n\t\t\t\n\t\t\tif ( !isXML && Expr.attrMap[name] ) {\n\t\t\t\tmatch[1] = Expr.attrMap[name];\n\t\t\t}\n\n\t\t\tif ( match[2] === \"~=\" ) {\n\t\t\t\tmatch[4] = \" \" + match[4] + \" \";\n\t\t\t}\n\n\t\t\treturn match;\n\t\t},\n\t\tPSEUDO: function(match, curLoop, inplace, result, not){\n\t\t\tif ( match[1] === \"not\" ) {\n\t\t\t\t// If we're dealing with a complex expression, or a simple one\n\t\t\t\tif ( ( chunker.exec(match[3]) || \"\" ).length > 1 || /^\\w/.test(match[3]) ) {\n\t\t\t\t\tmatch[3] = Sizzle(match[3], null, null, curLoop);\n\t\t\t\t} else {\n\t\t\t\t\tvar ret = Sizzle.filter(match[3], curLoop, inplace, true ^ not);\n\t\t\t\t\tif ( !inplace ) {\n\t\t\t\t\t\tresult.push.apply( result, ret );\n\t\t\t\t\t}\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t} else if ( Expr.match.POS.test( match[0] ) || Expr.match.CHILD.test( match[0] ) ) {\n\t\t\t\treturn true;\n\t\t\t}\n\t\t\t\n\t\t\treturn match;\n\t\t},\n\t\tPOS: function(match){\n\t\t\tmatch.unshift( true );\n\t\t\treturn match;\n\t\t}\n\t},\n\tfilters: {\n\t\tenabled: function(elem){\n\t\t\treturn elem.disabled === false && elem.type !== \"hidden\";\n\t\t},\n\t\tdisabled: function(elem){\n\t\t\treturn elem.disabled === true;\n\t\t},\n\t\tchecked: function(elem){\n\t\t\treturn elem.checked === true;\n\t\t},\n\t\tselected: function(elem){\n\t\t\t// Accessing this property makes selected-by-default\n\t\t\t// options in Safari work properly\n\t\t\telem.parentNode.selectedIndex;\n\t\t\treturn elem.selected === true;\n\t\t},\n\t\tparent: function(elem){\n\t\t\treturn !!elem.firstChild;\n\t\t},\n\t\tempty: function(elem){\n\t\t\treturn !elem.firstChild;\n\t\t},\n\t\thas: function(elem, i, match){\n\t\t\treturn !!Sizzle( match[3], elem ).length;\n\t\t},\n\t\theader: function(elem){\n\t\t\treturn (/h\\d/i).test( elem.nodeName );\n\t\t},\n\t\ttext: function(elem){\n\t\t\treturn \"text\" === elem.type;\n\t\t},\n\t\tradio: function(elem){\n\t\t\treturn \"radio\" === elem.type;\n\t\t},\n\t\tcheckbox: function(elem){\n\t\t\treturn \"checkbox\" === elem.type;\n\t\t},\n\t\tfile: function(elem){\n\t\t\treturn \"file\" === elem.type;\n\t\t},\n\t\tpassword: function(elem){\n\t\t\treturn \"password\" === elem.type;\n\t\t},\n\t\tsubmit: function(elem){\n\t\t\treturn \"submit\" === elem.type;\n\t\t},\n\t\timage: function(elem){\n\t\t\treturn \"image\" === elem.type;\n\t\t},\n\t\treset: function(elem){\n\t\t\treturn \"reset\" === elem.type;\n\t\t},\n\t\tbutton: function(elem){\n\t\t\treturn \"button\" === elem.type || elem.nodeName.toLowerCase() === \"button\";\n\t\t},\n\t\tinput: function(elem){\n\t\t\treturn (/input|select|textarea|button/i).test(elem.nodeName);\n\t\t}\n\t},\n\tsetFilters: {\n\t\tfirst: function(elem, i){\n\t\t\treturn i === 0;\n\t\t},\n\t\tlast: function(elem, i, match, array){\n\t\t\treturn i === array.length - 1;\n\t\t},\n\t\teven: function(elem, i){\n\t\t\treturn i % 2 === 0;\n\t\t},\n\t\todd: function(elem, i){\n\t\t\treturn i % 2 === 1;\n\t\t},\n\t\tlt: function(elem, i, match){\n\t\t\treturn i < match[3] - 0;\n\t\t},\n\t\tgt: function(elem, i, match){\n\t\t\treturn i > match[3] - 0;\n\t\t},\n\t\tnth: function(elem, i, match){\n\t\t\treturn match[3] - 0 === i;\n\t\t},\n\t\teq: function(elem, i, match){\n\t\t\treturn match[3] - 0 === i;\n\t\t}\n\t},\n\tfilter: {\n\t\tPSEUDO: function(elem, match, i, array){\n\t\t\tvar name = match[1], filter = Expr.filters[ name ];\n\n\t\t\tif ( filter ) {\n\t\t\t\treturn filter( elem, i, match, array );\n\t\t\t} else if ( name === \"contains\" ) {\n\t\t\t\treturn (elem.textContent || elem.innerText || Sizzle.getText([ elem ]) || \"\").indexOf(match[3]) >= 0;\n\t\t\t} else if ( name === \"not\" ) {\n\t\t\t\tvar not = match[3];\n\n\t\t\t\tfor ( var j = 0, l = not.length; j < l; j++ ) {\n\t\t\t\t\tif ( not[j] === elem ) {\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn true;\n\t\t\t} else {\n\t\t\t\tSizzle.error( \"Syntax error, unrecognized expression: \" + name );\n\t\t\t}\n\t\t},\n\t\tCHILD: function(elem, match){\n\t\t\tvar type = match[1], node = elem;\n\t\t\tswitch (type) {\n\t\t\t\tcase 'only':\n\t\t\t\tcase 'first':\n\t\t\t\t\twhile ( (node = node.previousSibling) )\t {\n\t\t\t\t\t\tif ( node.nodeType === 1 ) { \n\t\t\t\t\t\t\treturn false; \n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tif ( type === \"first\" ) { \n\t\t\t\t\t\treturn true; \n\t\t\t\t\t}\n\t\t\t\t\tnode = elem;\n\t\t\t\tcase 'last':\n\t\t\t\t\twhile ( (node = node.nextSibling) )\t {\n\t\t\t\t\t\tif ( node.nodeType === 1 ) { \n\t\t\t\t\t\t\treturn false; \n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn true;\n\t\t\t\tcase 'nth':\n\t\t\t\t\tvar first = match[2], last = match[3];\n\n\t\t\t\t\tif ( first === 1 && last === 0 ) {\n\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\t\t\t\t\t\n\t\t\t\t\tvar doneName = match[0],\n\t\t\t\t\t\tparent = elem.parentNode;\n\t\n\t\t\t\t\tif ( parent && (parent.sizcache !== doneName || !elem.nodeIndex) ) {\n\t\t\t\t\t\tvar count = 0;\n\t\t\t\t\t\tfor ( node = parent.firstChild; node; node = node.nextSibling ) {\n\t\t\t\t\t\t\tif ( node.nodeType === 1 ) {\n\t\t\t\t\t\t\t\tnode.nodeIndex = ++count;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} \n\t\t\t\t\t\tparent.sizcache = doneName;\n\t\t\t\t\t}\n\t\t\t\t\t\n\t\t\t\t\tvar diff = elem.nodeIndex - last;\n\t\t\t\t\tif ( first === 0 ) {\n\t\t\t\t\t\treturn diff === 0;\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn ( diff % first === 0 && diff / first >= 0 );\n\t\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\tID: function(elem, match){\n\t\t\treturn elem.nodeType === 1 && elem.getAttribute(\"id\") === match;\n\t\t},\n\t\tTAG: function(elem, match){\n\t\t\treturn (match === \"*\" && elem.nodeType === 1) || elem.nodeName.toLowerCase() === match;\n\t\t},\n\t\tCLASS: function(elem, match){\n\t\t\treturn (\" \" + (elem.className || elem.getAttribute(\"class\")) + \" \")\n\t\t\t\t.indexOf( match ) > -1;\n\t\t},\n\t\tATTR: function(elem, match){\n\t\t\tvar name = match[1],\n\t\t\t\tresult = Expr.attrHandle[ name ] ?\n\t\t\t\t\tExpr.attrHandle[ name ]( elem ) :\n\t\t\t\t\telem[ name ] != null ?\n\t\t\t\t\t\telem[ name ] :\n\t\t\t\t\t\telem.getAttribute( name ),\n\t\t\t\tvalue = result + \"\",\n\t\t\t\ttype = match[2],\n\t\t\t\tcheck = match[4];\n\n\t\t\treturn result == null ?\n\t\t\t\ttype === \"!=\" :\n\t\t\t\ttype === \"=\" ?\n\t\t\t\tvalue === check :\n\t\t\t\ttype === \"*=\" ?\n\t\t\t\tvalue.indexOf(check) >= 0 :\n\t\t\t\ttype === \"~=\" ?\n\t\t\t\t(\" \" + value + \" \").indexOf(check) >= 0 :\n\t\t\t\t!check ?\n\t\t\t\tvalue && result !== false :\n\t\t\t\ttype === \"!=\" ?\n\t\t\t\tvalue !== check :\n\t\t\t\ttype === \"^=\" ?\n\t\t\t\tvalue.indexOf(check) === 0 :\n\t\t\t\ttype === \"$=\" ?\n\t\t\t\tvalue.substr(value.length - check.length) === check :\n\t\t\t\ttype === \"|=\" ?\n\t\t\t\tvalue === check || value.substr(0, check.length + 1) === check + \"-\" :\n\t\t\t\tfalse;\n\t\t},\n\t\tPOS: function(elem, match, i, array){\n\t\t\tvar name = match[2], filter = Expr.setFilters[ name ];\n\n\t\t\tif ( filter ) {\n\t\t\t\treturn filter( elem, i, match, array );\n\t\t\t}\n\t\t}\n\t}\n};\n\nvar origPOS = Expr.match.POS,\n\tfescape = function(all, num){\n\t\treturn \"\\\\\" + (num - 0 + 1);\n\t};\n\nfor ( var type in Expr.match ) {\n\tExpr.match[ type ] = new RegExp( Expr.match[ type ].source + (/(?![^\\[]*\\])(?![^\\(]*\\))/.source) );\n\tExpr.leftMatch[ type ] = new RegExp( /(^(?:.|\\r|\\n)*?)/.source + Expr.match[ type ].source.replace(/\\\\(\\d+)/g, fescape) );\n}\n\nvar makeArray = function(array, results) {\n\tarray = Array.prototype.slice.call( array, 0 );\n\n\tif ( results ) {\n\t\tresults.push.apply( results, array );\n\t\treturn results;\n\t}\n\t\n\treturn array;\n};\n\n// Perform a simple check to determine if the browser is capable of\n// converting a NodeList to an array using builtin methods.\n// Also verifies that the returned array holds DOM nodes\n// (which is not the case in the Blackberry browser)\ntry {\n\tArray.prototype.slice.call( document.documentElement.childNodes, 0 )[0].nodeType;\n\n// Provide a fallback method if it does not work\n} catch(e){\n\tmakeArray = function(array, results) {\n\t\tvar ret = results || [], i = 0;\n\n\t\tif ( toString.call(array) === \"[object Array]\" ) {\n\t\t\tArray.prototype.push.apply( ret, array );\n\t\t} else {\n\t\t\tif ( typeof array.length === \"number\" ) {\n\t\t\t\tfor ( var l = array.length; i < l; i++ ) {\n\t\t\t\t\tret.push( array[i] );\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tfor ( ; array[i]; i++ ) {\n\t\t\t\t\tret.push( array[i] );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn ret;\n\t};\n}\n\nvar sortOrder;\n\nif ( document.documentElement.compareDocumentPosition ) {\n\tsortOrder = function( a, b ) {\n\t\tif ( !a.compareDocumentPosition || !b.compareDocumentPosition ) {\n\t\t\tif ( a == b ) {\n\t\t\t\thasDuplicate = true;\n\t\t\t}\n\t\t\treturn a.compareDocumentPosition ? -1 : 1;\n\t\t}\n\n\t\tvar ret = a.compareDocumentPosition(b) & 4 ? -1 : a === b ? 0 : 1;\n\t\tif ( ret === 0 ) {\n\t\t\thasDuplicate = true;\n\t\t}\n\t\treturn ret;\n\t};\n} else if ( \"sourceIndex\" in document.documentElement ) {\n\tsortOrder = function( a, b ) {\n\t\tif ( !a.sourceIndex || !b.sourceIndex ) {\n\t\t\tif ( a == b ) {\n\t\t\t\thasDuplicate = true;\n\t\t\t}\n\t\t\treturn a.sourceIndex ? -1 : 1;\n\t\t}\n\n\t\tvar ret = a.sourceIndex - b.sourceIndex;\n\t\tif ( ret === 0 ) {\n\t\t\thasDuplicate = true;\n\t\t}\n\t\treturn ret;\n\t};\n} else if ( document.createRange ) {\n\tsortOrder = function( a, b ) {\n\t\tif ( !a.ownerDocument || !b.ownerDocument ) {\n\t\t\tif ( a == b ) {\n\t\t\t\thasDuplicate = true;\n\t\t\t}\n\t\t\treturn a.ownerDocument ? -1 : 1;\n\t\t}\n\n\t\tvar aRange = a.ownerDocument.createRange(), bRange = b.ownerDocument.createRange();\n\t\taRange.setStart(a, 0);\n\t\taRange.setEnd(a, 0);\n\t\tbRange.setStart(b, 0);\n\t\tbRange.setEnd(b, 0);\n\t\tvar ret = aRange.compareBoundaryPoints(Range.START_TO_END, bRange);\n\t\tif ( ret === 0 ) {\n\t\t\thasDuplicate = true;\n\t\t}\n\t\treturn ret;\n\t};\n}\n\n// Utility function for retreiving the text value of an array of DOM nodes\nSizzle.getText = function( elems ) {\n\tvar ret = \"\", elem;\n\n\tfor ( var i = 0; elems[i]; i++ ) {\n\t\telem = elems[i];\n\n\t\t// Get the text from text nodes and CDATA nodes\n\t\tif ( elem.nodeType === 3 || elem.nodeType === 4 ) {\n\t\t\tret += elem.nodeValue;\n\n\t\t// Traverse everything else, except comment nodes\n\t\t} else if ( elem.nodeType !== 8 ) {\n\t\t\tret += Sizzle.getText( elem.childNodes );\n\t\t}\n\t}\n\n\treturn ret;\n};\n\n// Check to see if the browser returns elements by name when\n// querying by getElementById (and provide a workaround)\n(function(){\n\t// We're going to inject a fake input element with a specified name\n\tvar form = document.createElement(\"div\"),\n\t\tid = \"script\" + (new Date()).getTime();\n\tform.innerHTML = \"<a name='\" + id + \"'/>\";\n\n\t// Inject it into the root element, check its status, and remove it quickly\n\tvar root = document.documentElement;\n\troot.insertBefore( form, root.firstChild );\n\n\t// The workaround has to do additional checks after a getElementById\n\t// Which slows things down for other browsers (hence the branching)\n\tif ( document.getElementById( id ) ) {\n\t\tExpr.find.ID = function(match, context, isXML){\n\t\t\tif ( typeof context.getElementById !== \"undefined\" && !isXML ) {\n\t\t\t\tvar m = context.getElementById(match[1]);\n\t\t\t\treturn m ? m.id === match[1] || typeof m.getAttributeNode !== \"undefined\" && m.getAttributeNode(\"id\").nodeValue === match[1] ? [m] : undefined : [];\n\t\t\t}\n\t\t};\n\n\t\tExpr.filter.ID = function(elem, match){\n\t\t\tvar node = typeof elem.getAttributeNode !== \"undefined\" && elem.getAttributeNode(\"id\");\n\t\t\treturn elem.nodeType === 1 && node && node.nodeValue === match;\n\t\t};\n\t}\n\n\troot.removeChild( form );\n\troot = form = null; // release memory in IE\n})();\n\n(function(){\n\t// Check to see if the browser returns only elements\n\t// when doing getElementsByTagName(\"*\")\n\n\t// Create a fake element\n\tvar div = document.createElement(\"div\");\n\tdiv.appendChild( document.createComment(\"\") );\n\n\t// Make sure no comments are found\n\tif ( div.getElementsByTagName(\"*\").length > 0 ) {\n\t\tExpr.find.TAG = function(match, context){\n\t\t\tvar results = context.getElementsByTagName(match[1]);\n\n\t\t\t// Filter out possible comments\n\t\t\tif ( match[1] === \"*\" ) {\n\t\t\t\tvar tmp = [];\n\n\t\t\t\tfor ( var i = 0; results[i]; i++ ) {\n\t\t\t\t\tif ( results[i].nodeType === 1 ) {\n\t\t\t\t\t\ttmp.push( results[i] );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tresults = tmp;\n\t\t\t}\n\n\t\t\treturn results;\n\t\t};\n\t}\n\n\t// Check to see if an attribute returns normalized href attributes\n\tdiv.innerHTML = \"<a href='#'></a>\";\n\tif ( div.firstChild && typeof div.firstChild.getAttribute !== \"undefined\" &&\n\t\t\tdiv.firstChild.getAttribute(\"href\") !== \"#\" ) {\n\t\tExpr.attrHandle.href = function(elem){\n\t\t\treturn elem.getAttribute(\"href\", 2);\n\t\t};\n\t}\n\n\tdiv = null; // release memory in IE\n})();\n\nif ( document.querySelectorAll ) {\n\t(function(){\n\t\tvar oldSizzle = Sizzle, div = document.createElement(\"div\");\n\t\tdiv.innerHTML = \"<p class='TEST'></p>\";\n\n\t\t// Safari can't handle uppercase or unicode characters when\n\t\t// in quirks mode.\n\t\tif ( div.querySelectorAll && div.querySelectorAll(\".TEST\").length === 0 ) {\n\t\t\treturn;\n\t\t}\n\t\n\t\tSizzle = function(query, context, extra, seed){\n\t\t\tcontext = context || document;\n\n\t\t\t// Only use querySelectorAll on non-XML documents\n\t\t\t// (ID selectors don't work in non-HTML documents)\n\t\t\tif ( !seed && context.nodeType === 9 && !Sizzle.isXML(context) ) {\n\t\t\t\ttry {\n\t\t\t\t\treturn makeArray( context.querySelectorAll(query), extra );\n\t\t\t\t} catch(e){}\n\t\t\t}\n\t\t\n\t\t\treturn oldSizzle(query, context, extra, seed);\n\t\t};\n\n\t\tfor ( var prop in oldSizzle ) {\n\t\t\tSizzle[ prop ] = oldSizzle[ prop ];\n\t\t}\n\n\t\tdiv = null; // release memory in IE\n\t})();\n}\n\n(function(){\n\tvar div = document.createElement(\"div\");\n\n\tdiv.innerHTML = \"<div class='test e'></div><div class='test'></div>\";\n\n\t// Opera can't find a second classname (in 9.6)\n\t// Also, make sure that getElementsByClassName actually exists\n\tif ( !div.getElementsByClassName || div.getElementsByClassName(\"e\").length === 0 ) {\n\t\treturn;\n\t}\n\n\t// Safari caches class attributes, doesn't catch changes (in 3.2)\n\tdiv.lastChild.className = \"e\";\n\n\tif ( div.getElementsByClassName(\"e\").length === 1 ) {\n\t\treturn;\n\t}\n\t\n\tExpr.order.splice(1, 0, \"CLASS\");\n\tExpr.find.CLASS = function(match, context, isXML) {\n\t\tif ( typeof context.getElementsByClassName !== \"undefined\" && !isXML ) {\n\t\t\treturn context.getElementsByClassName(match[1]);\n\t\t}\n\t};\n\n\tdiv = null; // release memory in IE\n})();\n\nfunction dirNodeCheck( dir, cur, doneName, checkSet, nodeCheck, isXML ) {\n\tfor ( var i = 0, l = checkSet.length; i < l; i++ ) {\n\t\tvar elem = checkSet[i];\n\t\tif ( elem ) {\n\t\t\telem = elem[dir];\n\t\t\tvar match = false;\n\n\t\t\twhile ( elem ) {\n\t\t\t\tif ( elem.sizcache === doneName ) {\n\t\t\t\t\tmatch = checkSet[elem.sizset];\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tif ( elem.nodeType === 1 && !isXML ){\n\t\t\t\t\telem.sizcache = doneName;\n\t\t\t\t\telem.sizset = i;\n\t\t\t\t}\n\n\t\t\t\tif ( elem.nodeName.toLowerCase() === cur ) {\n\t\t\t\t\tmatch = elem;\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\telem = elem[dir];\n\t\t\t}\n\n\t\t\tcheckSet[i] = match;\n\t\t}\n\t}\n}\n\nfunction dirCheck( dir, cur, doneName, checkSet, nodeCheck, isXML ) {\n\tfor ( var i = 0, l = checkSet.length; i < l; i++ ) {\n\t\tvar elem = checkSet[i];\n\t\tif ( elem ) {\n\t\t\telem = elem[dir];\n\t\t\tvar match = false;\n\n\t\t\twhile ( elem ) {\n\t\t\t\tif ( elem.sizcache === doneName ) {\n\t\t\t\t\tmatch = checkSet[elem.sizset];\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tif ( elem.nodeType === 1 ) {\n\t\t\t\t\tif ( !isXML ) {\n\t\t\t\t\t\telem.sizcache = doneName;\n\t\t\t\t\t\telem.sizset = i;\n\t\t\t\t\t}\n\t\t\t\t\tif ( typeof cur !== \"string\" ) {\n\t\t\t\t\t\tif ( elem === cur ) {\n\t\t\t\t\t\t\tmatch = true;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t} else if ( Sizzle.filter( cur, [elem] ).length > 0 ) {\n\t\t\t\t\t\tmatch = elem;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\telem = elem[dir];\n\t\t\t}\n\n\t\t\tcheckSet[i] = match;\n\t\t}\n\t}\n}\n\nSizzle.contains = document.compareDocumentPosition ? function(a, b){\n\treturn !!(a.compareDocumentPosition(b) & 16);\n} : function(a, b){\n\treturn a !== b && (a.contains ? a.contains(b) : true);\n};\n\nSizzle.isXML = function(elem){\n\t// documentElement is verified for cases where it doesn't yet exist\n\t// (such as loading iframes in IE - #4833) \n\tvar documentElement = (elem ? elem.ownerDocument || elem : 0).documentElement;\n\treturn documentElement ? documentElement.nodeName !== \"HTML\" : false;\n};\n\nvar posProcess = function(selector, context){\n\tvar tmpSet = [], later = \"\", match,\n\t\troot = context.nodeType ? [context] : context;\n\n\t// Position selectors must be done after the filter\n\t// And so must :not(positional) so we move all PSEUDOs to the end\n\twhile ( (match = Expr.match.PSEUDO.exec( selector )) ) {\n\t\tlater += match[0];\n\t\tselector = selector.replace( Expr.match.PSEUDO, \"\" );\n\t}\n\n\tselector = Expr.relative[selector] ? selector + \"*\" : selector;\n\n\tfor ( var i = 0, l = root.length; i < l; i++ ) {\n\t\tSizzle( selector, root[i], tmpSet );\n\t}\n\n\treturn Sizzle.filter( later, tmpSet );\n};\n\n// EXPOSE\n\nwindow.tinymce.dom.Sizzle = Sizzle;\n\n})();\n\n// #endif\n","Magento_Tinymce3/tiny_mce/classes/dom/Range.js":"/**\n * Range.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(ns) {\n\t// Range constructor\n\tfunction Range(dom) {\n\t\tvar t = this,\n\t\t\tdoc = dom.doc,\n\t\t\tEXTRACT = 0,\n\t\t\tCLONE = 1,\n\t\t\tDELETE = 2,\n\t\t\tTRUE = true,\n\t\t\tFALSE = false,\n\t\t\tSTART_OFFSET = 'startOffset',\n\t\t\tSTART_CONTAINER = 'startContainer',\n\t\t\tEND_CONTAINER = 'endContainer',\n\t\t\tEND_OFFSET = 'endOffset',\n\t\t\textend = tinymce.extend,\n\t\t\tnodeIndex = dom.nodeIndex;\n\n\t\textend(t, {\n\t\t\t// Inital states\n\t\t\tstartContainer : doc,\n\t\t\tstartOffset : 0,\n\t\t\tendContainer : doc,\n\t\t\tendOffset : 0,\n\t\t\tcollapsed : TRUE,\n\t\t\tcommonAncestorContainer : doc,\n\n\t\t\t// Range constants\n\t\t\tSTART_TO_START : 0,\n\t\t\tSTART_TO_END : 1,\n\t\t\tEND_TO_END : 2,\n\t\t\tEND_TO_START : 3,\n\n\t\t\t// Public methods\n\t\t\tsetStart : setStart,\n\t\t\tsetEnd : setEnd,\n\t\t\tsetStartBefore : setStartBefore,\n\t\t\tsetStartAfter : setStartAfter,\n\t\t\tsetEndBefore : setEndBefore,\n\t\t\tsetEndAfter : setEndAfter,\n\t\t\tcollapse : collapse,\n\t\t\tselectNode : selectNode,\n\t\t\tselectNodeContents : selectNodeContents,\n\t\t\tcompareBoundaryPoints : compareBoundaryPoints,\n\t\t\tdeleteContents : deleteContents,\n\t\t\textractContents : extractContents,\n\t\t\tcloneContents : cloneContents,\n\t\t\tinsertNode : insertNode,\n\t\t\tsurroundContents : surroundContents,\n\t\t\tcloneRange : cloneRange\n\t\t});\n\n\t\tfunction setStart(n, o) {\n\t\t\t_setEndPoint(TRUE, n, o);\n\t\t};\n\n\t\tfunction setEnd(n, o) {\n\t\t\t_setEndPoint(FALSE, n, o);\n\t\t};\n\n\t\tfunction setStartBefore(n) {\n\t\t\tsetStart(n.parentNode, nodeIndex(n));\n\t\t};\n\n\t\tfunction setStartAfter(n) {\n\t\t\tsetStart(n.parentNode, nodeIndex(n) + 1);\n\t\t};\n\n\t\tfunction setEndBefore(n) {\n\t\t\tsetEnd(n.parentNode, nodeIndex(n));\n\t\t};\n\n\t\tfunction setEndAfter(n) {\n\t\t\tsetEnd(n.parentNode, nodeIndex(n) + 1);\n\t\t};\n\n\t\tfunction collapse(ts) {\n\t\t\tif (ts) {\n\t\t\t\tt[END_CONTAINER] = t[START_CONTAINER];\n\t\t\t\tt[END_OFFSET] = t[START_OFFSET];\n\t\t\t} else {\n\t\t\t\tt[START_CONTAINER] = t[END_CONTAINER];\n\t\t\t\tt[START_OFFSET] = t[END_OFFSET];\n\t\t\t}\n\n\t\t\tt.collapsed = TRUE;\n\t\t};\n\n\t\tfunction selectNode(n) {\n\t\t\tsetStartBefore(n);\n\t\t\tsetEndAfter(n);\n\t\t};\n\n\t\tfunction selectNodeContents(n) {\n\t\t\tsetStart(n, 0);\n\t\t\tsetEnd(n, n.nodeType === 1 ? n.childNodes.length : n.nodeValue.length);\n\t\t};\n\n\t\tfunction compareBoundaryPoints(h, r) {\n\t\t\tvar sc = t[START_CONTAINER], so = t[START_OFFSET], ec = t[END_CONTAINER], eo = t[END_OFFSET],\n\t\t\trsc = r.startContainer, rso = r.startOffset, rec = r.endContainer, reo = r.endOffset;\n\n\t\t\t// Check START_TO_START\n\t\t\tif (h === 0)\n\t\t\t\treturn _compareBoundaryPoints(sc, so, rsc, rso);\n\t\n\t\t\t// Check START_TO_END\n\t\t\tif (h === 1)\n\t\t\t\treturn _compareBoundaryPoints(ec, eo, rsc, rso);\n\t\n\t\t\t// Check END_TO_END\n\t\t\tif (h === 2)\n\t\t\t\treturn _compareBoundaryPoints(ec, eo, rec, reo);\n\t\n\t\t\t// Check END_TO_START\n\t\t\tif (h === 3) \n\t\t\t\treturn _compareBoundaryPoints(sc, so, rec, reo);\n\t\t};\n\n\t\tfunction deleteContents() {\n\t\t\t_traverse(DELETE);\n\t\t};\n\n\t\tfunction extractContents() {\n\t\t\treturn _traverse(EXTRACT);\n\t\t};\n\n\t\tfunction cloneContents() {\n\t\t\treturn _traverse(CLONE);\n\t\t};\n\n\t\tfunction insertNode(n) {\n\t\t\tvar startContainer = this[START_CONTAINER],\n\t\t\t\tstartOffset = this[START_OFFSET], nn, o;\n\n\t\t\t// Node is TEXT_NODE or CDATA\n\t\t\tif ((startContainer.nodeType === 3 || startContainer.nodeType === 4) && startContainer.nodeValue) {\n\t\t\t\tif (!startOffset) {\n\t\t\t\t\t// At the start of text\n\t\t\t\t\tstartContainer.parentNode.insertBefore(n, startContainer);\n\t\t\t\t} else if (startOffset >= startContainer.nodeValue.length) {\n\t\t\t\t\t// At the end of text\n\t\t\t\t\tdom.insertAfter(n, startContainer);\n\t\t\t\t} else {\n\t\t\t\t\t// Middle, need to split\n\t\t\t\t\tnn = startContainer.splitText(startOffset);\n\t\t\t\t\tstartContainer.parentNode.insertBefore(n, nn);\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Insert element node\n\t\t\t\tif (startContainer.childNodes.length > 0)\n\t\t\t\t\to = startContainer.childNodes[startOffset];\n\n\t\t\t\tif (o)\n\t\t\t\t\tstartContainer.insertBefore(n, o);\n\t\t\t\telse\n\t\t\t\t\tstartContainer.appendChild(n);\n\t\t\t}\n\t\t};\n\n\t\tfunction surroundContents(n) {\n\t\t\tvar f = t.extractContents();\n\n\t\t\tt.insertNode(n);\n\t\t\tn.appendChild(f);\n\t\t\tt.selectNode(n);\n\t\t};\n\n\t\tfunction cloneRange() {\n\t\t\treturn extend(new Range(dom), {\n\t\t\t\tstartContainer : t[START_CONTAINER],\n\t\t\t\tstartOffset : t[START_OFFSET],\n\t\t\t\tendContainer : t[END_CONTAINER],\n\t\t\t\tendOffset : t[END_OFFSET],\n\t\t\t\tcollapsed : t.collapsed,\n\t\t\t\tcommonAncestorContainer : t.commonAncestorContainer\n\t\t\t});\n\t\t};\n\n\t\t// Private methods\n\n\t\tfunction _getSelectedNode(container, offset) {\n\t\t\tvar child;\n\n\t\t\tif (container.nodeType == 3 /* TEXT_NODE */)\n\t\t\t\treturn container;\n\n\t\t\tif (offset < 0)\n\t\t\t\treturn container;\n\n\t\t\tchild = container.firstChild;\n\t\t\twhile (child && offset > 0) {\n\t\t\t\t--offset;\n\t\t\t\tchild = child.nextSibling;\n\t\t\t}\n\n\t\t\tif (child)\n\t\t\t\treturn child;\n\n\t\t\treturn container;\n\t\t};\n\n\t\tfunction _isCollapsed() {\n\t\t\treturn (t[START_CONTAINER] == t[END_CONTAINER] && t[START_OFFSET] == t[END_OFFSET]);\n\t\t};\n\n\t\tfunction _compareBoundaryPoints(containerA, offsetA, containerB, offsetB) {\n\t\t\tvar c, offsetC, n, cmnRoot, childA, childB;\n\t\t\t\n\t\t\t// In the first case the boundary-points have the same container. A is before B\n\t\t\t// if its offset is less than the offset of B, A is equal to B if its offset is\n\t\t\t// equal to the offset of B, and A is after B if its offset is greater than the\n\t\t\t// offset of B.\n\t\t\tif (containerA == containerB) {\n\t\t\t\tif (offsetA == offsetB)\n\t\t\t\t\treturn 0; // equal\n\n\t\t\t\tif (offsetA < offsetB)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\treturn 1; // after\n\t\t\t}\n\n\t\t\t// In the second case a child node C of the container of A is an ancestor\n\t\t\t// container of B. In this case, A is before B if the offset of A is less than or\n\t\t\t// equal to the index of the child node C and A is after B otherwise.\n\t\t\tc = containerB;\n\t\t\twhile (c && c.parentNode != containerA)\n\t\t\t\tc = c.parentNode;\n\n\t\t\tif (c) {\n\t\t\t\toffsetC = 0;\n\t\t\t\tn = containerA.firstChild;\n\n\t\t\t\twhile (n != c && offsetC < offsetA) {\n\t\t\t\t\toffsetC++;\n\t\t\t\t\tn = n.nextSibling;\n\t\t\t\t}\n\n\t\t\t\tif (offsetA <= offsetC)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\treturn 1; // after\n\t\t\t}\n\n\t\t\t// In the third case a child node C of the container of B is an ancestor container\n\t\t\t// of A. In this case, A is before B if the index of the child node C is less than\n\t\t\t// the offset of B and A is after B otherwise.\n\t\t\tc = containerA;\n\t\t\twhile (c && c.parentNode != containerB) {\n\t\t\t\tc = c.parentNode;\n\t\t\t}\n\n\t\t\tif (c) {\n\t\t\t\toffsetC = 0;\n\t\t\t\tn = containerB.firstChild;\n\n\t\t\t\twhile (n != c && offsetC < offsetB) {\n\t\t\t\t\toffsetC++;\n\t\t\t\t\tn = n.nextSibling;\n\t\t\t\t}\n\n\t\t\t\tif (offsetC < offsetB)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\treturn 1; // after\n\t\t\t}\n\n\t\t\t// In the fourth case, none of three other cases hold: the containers of A and B\n\t\t\t// are siblings or descendants of sibling nodes. In this case, A is before B if\n\t\t\t// the container of A is before the container of B in a pre-order traversal of the\n\t\t\t// Ranges' context tree and A is after B otherwise.\n\t\t\tcmnRoot = dom.findCommonAncestor(containerA, containerB);\n\t\t\tchildA = containerA;\n\n\t\t\twhile (childA && childA.parentNode != cmnRoot)\n\t\t\t\tchildA = childA.parentNode;\n\n\t\t\tif (!childA)\n\t\t\t\tchildA = cmnRoot;\n\n\t\t\tchildB = containerB;\n\t\t\twhile (childB && childB.parentNode != cmnRoot)\n\t\t\t\tchildB = childB.parentNode;\n\n\t\t\tif (!childB)\n\t\t\t\tchildB = cmnRoot;\n\n\t\t\tif (childA == childB)\n\t\t\t\treturn 0; // equal\n\n\t\t\tn = cmnRoot.firstChild;\n\t\t\twhile (n) {\n\t\t\t\tif (n == childA)\n\t\t\t\t\treturn -1; // before\n\n\t\t\t\tif (n == childB)\n\t\t\t\t\treturn 1; // after\n\n\t\t\t\tn = n.nextSibling;\n\t\t\t}\n\t\t};\n\n\t\tfunction _setEndPoint(st, n, o) {\n\t\t\tvar ec, sc;\n\n\t\t\tif (st) {\n\t\t\t\tt[START_CONTAINER] = n;\n\t\t\t\tt[START_OFFSET] = o;\n\t\t\t} else {\n\t\t\t\tt[END_CONTAINER] = n;\n\t\t\t\tt[END_OFFSET] = o;\n\t\t\t}\n\n\t\t\t// If one boundary-point of a Range is set to have a root container\n\t\t\t// other than the current one for the Range, the Range is collapsed to\n\t\t\t// the new position. This enforces the restriction that both boundary-\n\t\t\t// points of a Range must have the same root container.\n\t\t\tec = t[END_CONTAINER];\n\t\t\twhile (ec.parentNode)\n\t\t\t\tec = ec.parentNode;\n\n\t\t\tsc = t[START_CONTAINER];\n\t\t\twhile (sc.parentNode)\n\t\t\t\tsc = sc.parentNode;\n\n\t\t\tif (sc == ec) {\n\t\t\t\t// The start position of a Range is guaranteed to never be after the\n\t\t\t\t// end position. To enforce this restriction, if the start is set to\n\t\t\t\t// be at a position after the end, the Range is collapsed to that\n\t\t\t\t// position.\n\t\t\t\tif (_compareBoundaryPoints(t[START_CONTAINER], t[START_OFFSET], t[END_CONTAINER], t[END_OFFSET]) > 0)\n\t\t\t\t\tt.collapse(st);\n\t\t\t} else\n\t\t\t\tt.collapse(st);\n\n\t\t\tt.collapsed = _isCollapsed();\n\t\t\tt.commonAncestorContainer = dom.findCommonAncestor(t[START_CONTAINER], t[END_CONTAINER]);\n\t\t};\n\n\t\tfunction _traverse(how) {\n\t\t\tvar c, endContainerDepth = 0, startContainerDepth = 0, p, depthDiff, startNode, endNode, sp, ep;\n\n\t\t\tif (t[START_CONTAINER] == t[END_CONTAINER])\n\t\t\t\treturn _traverseSameContainer(how);\n\n\t\t\tfor (c = t[END_CONTAINER], p = c.parentNode; p; c = p, p = p.parentNode) {\n\t\t\t\tif (p == t[START_CONTAINER])\n\t\t\t\t\treturn _traverseCommonStartContainer(c, how);\n\n\t\t\t\t++endContainerDepth;\n\t\t\t}\n\n\t\t\tfor (c = t[START_CONTAINER], p = c.parentNode; p; c = p, p = p.parentNode) {\n\t\t\t\tif (p == t[END_CONTAINER])\n\t\t\t\t\treturn _traverseCommonEndContainer(c, how);\n\n\t\t\t\t++startContainerDepth;\n\t\t\t}\n\n\t\t\tdepthDiff = startContainerDepth - endContainerDepth;\n\n\t\t\tstartNode = t[START_CONTAINER];\n\t\t\twhile (depthDiff > 0) {\n\t\t\t\tstartNode = startNode.parentNode;\n\t\t\t\tdepthDiff--;\n\t\t\t}\n\n\t\t\tendNode = t[END_CONTAINER];\n\t\t\twhile (depthDiff < 0) {\n\t\t\t\tendNode = endNode.parentNode;\n\t\t\t\tdepthDiff++;\n\t\t\t}\n\n\t\t\t// ascend the ancestor hierarchy until we have a common parent.\n\t\t\tfor (sp = startNode.parentNode, ep = endNode.parentNode; sp != ep; sp = sp.parentNode, ep = ep.parentNode) {\n\t\t\t\tstartNode = sp;\n\t\t\t\tendNode = ep;\n\t\t\t}\n\n\t\t\treturn _traverseCommonAncestors(startNode, endNode, how);\n\t\t};\n\n\t\t function _traverseSameContainer(how) {\n\t\t\tvar frag, s, sub, n, cnt, sibling, xferNode;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\t// If selection is empty, just return the fragment\n\t\t\tif (t[START_OFFSET] == t[END_OFFSET])\n\t\t\t\treturn frag;\n\n\t\t\t// Text node needs special case handling\n\t\t\tif (t[START_CONTAINER].nodeType == 3 /* TEXT_NODE */) {\n\t\t\t\t// get the substring\n\t\t\t\ts = t[START_CONTAINER].nodeValue;\n\t\t\t\tsub = s.substring(t[START_OFFSET], t[END_OFFSET]);\n\n\t\t\t\t// set the original text node to its new value\n\t\t\t\tif (how != CLONE) {\n\t\t\t\t\tt[START_CONTAINER].deleteData(t[START_OFFSET], t[END_OFFSET] - t[START_OFFSET]);\n\n\t\t\t\t\t// Nothing is partially selected, so collapse to start point\n\t\t\t\t\tt.collapse(TRUE);\n\t\t\t\t}\n\n\t\t\t\tif (how == DELETE)\n\t\t\t\t\treturn;\n\n\t\t\t\tfrag.appendChild(doc.createTextNode(sub));\n\t\t\t\treturn frag;\n\t\t\t}\n\n\t\t\t// Copy nodes between the start/end offsets.\n\t\t\tn = _getSelectedNode(t[START_CONTAINER], t[START_OFFSET]);\n\t\t\tcnt = t[END_OFFSET] - t[START_OFFSET];\n\n\t\t\twhile (cnt > 0) {\n\t\t\t\tsibling = n.nextSibling;\n\t\t\t\txferNode = _traverseFullySelected(n, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.appendChild( xferNode );\n\n\t\t\t\t--cnt;\n\t\t\t\tn = sibling;\n\t\t\t}\n\n\t\t\t// Nothing is partially selected, so collapse to start point\n\t\t\tif (how != CLONE)\n\t\t\t\tt.collapse(TRUE);\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseCommonStartContainer(endAncestor, how) {\n\t\t\tvar frag, n, endIdx, cnt, sibling, xferNode;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\tn = _traverseRightBoundary(endAncestor, how);\n\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tendIdx = nodeIndex(endAncestor);\n\t\t\tcnt = endIdx - t[START_OFFSET];\n\n\t\t\tif (cnt <= 0) {\n\t\t\t\t// Collapse to just before the endAncestor, which\n\t\t\t\t// is partially selected.\n\t\t\t\tif (how != CLONE) {\n\t\t\t\t\tt.setEndBefore(endAncestor);\n\t\t\t\t\tt.collapse(FALSE);\n\t\t\t\t}\n\n\t\t\t\treturn frag;\n\t\t\t}\n\n\t\t\tn = endAncestor.previousSibling;\n\t\t\twhile (cnt > 0) {\n\t\t\t\tsibling = n.previousSibling;\n\t\t\t\txferNode = _traverseFullySelected(n, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.insertBefore(xferNode, frag.firstChild);\n\n\t\t\t\t--cnt;\n\t\t\t\tn = sibling;\n\t\t\t}\n\n\t\t\t// Collapse to just before the endAncestor, which\n\t\t\t// is partially selected.\n\t\t\tif (how != CLONE) {\n\t\t\t\tt.setEndBefore(endAncestor);\n\t\t\t\tt.collapse(FALSE);\n\t\t\t}\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseCommonEndContainer(startAncestor, how) {\n\t\t\tvar frag, startIdx, n, cnt, sibling, xferNode;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\tn = _traverseLeftBoundary(startAncestor, how);\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tstartIdx = nodeIndex(startAncestor);\n\t\t\t++startIdx; // Because we already traversed it\n\n\t\t\tcnt = t[END_OFFSET] - startIdx;\n\t\t\tn = startAncestor.nextSibling;\n\t\t\twhile (cnt > 0) {\n\t\t\t\tsibling = n.nextSibling;\n\t\t\t\txferNode = _traverseFullySelected(n, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.appendChild(xferNode);\n\n\t\t\t\t--cnt;\n\t\t\t\tn = sibling;\n\t\t\t}\n\n\t\t\tif (how != CLONE) {\n\t\t\t\tt.setStartAfter(startAncestor);\n\t\t\t\tt.collapse(TRUE);\n\t\t\t}\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseCommonAncestors(startAncestor, endAncestor, how) {\n\t\t\tvar n, frag, commonParent, startOffset, endOffset, cnt, sibling, nextSibling;\n\n\t\t\tif (how != DELETE)\n\t\t\t\tfrag = doc.createDocumentFragment();\n\n\t\t\tn = _traverseLeftBoundary(startAncestor, how);\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tcommonParent = startAncestor.parentNode;\n\t\t\tstartOffset = nodeIndex(startAncestor);\n\t\t\tendOffset = nodeIndex(endAncestor);\n\t\t\t++startOffset;\n\n\t\t\tcnt = endOffset - startOffset;\n\t\t\tsibling = startAncestor.nextSibling;\n\n\t\t\twhile (cnt > 0) {\n\t\t\t\tnextSibling = sibling.nextSibling;\n\t\t\t\tn = _traverseFullySelected(sibling, how);\n\n\t\t\t\tif (frag)\n\t\t\t\t\tfrag.appendChild(n);\n\n\t\t\t\tsibling = nextSibling;\n\t\t\t\t--cnt;\n\t\t\t}\n\n\t\t\tn = _traverseRightBoundary(endAncestor, how);\n\n\t\t\tif (frag)\n\t\t\t\tfrag.appendChild(n);\n\n\t\t\tif (how != CLONE) {\n\t\t\t\tt.setStartAfter(startAncestor);\n\t\t\t\tt.collapse(TRUE);\n\t\t\t}\n\n\t\t\treturn frag;\n\t\t};\n\n\t\tfunction _traverseRightBoundary(root, how) {\n\t\t\tvar next = _getSelectedNode(t[END_CONTAINER], t[END_OFFSET] - 1), parent, clonedParent, prevSibling, clonedChild, clonedGrandParent, isFullySelected = next != t[END_CONTAINER];\n\n\t\t\tif (next == root)\n\t\t\t\treturn _traverseNode(next, isFullySelected, FALSE, how);\n\n\t\t\tparent = next.parentNode;\n\t\t\tclonedParent = _traverseNode(parent, FALSE, FALSE, how);\n\n\t\t\twhile (parent) {\n\t\t\t\twhile (next) {\n\t\t\t\t\tprevSibling = next.previousSibling;\n\t\t\t\t\tclonedChild = _traverseNode(next, isFullySelected, FALSE, how);\n\n\t\t\t\t\tif (how != DELETE)\n\t\t\t\t\t\tclonedParent.insertBefore(clonedChild, clonedParent.firstChild);\n\n\t\t\t\t\tisFullySelected = TRUE;\n\t\t\t\t\tnext = prevSibling;\n\t\t\t\t}\n\n\t\t\t\tif (parent == root)\n\t\t\t\t\treturn clonedParent;\n\n\t\t\t\tnext = parent.previousSibling;\n\t\t\t\tparent = parent.parentNode;\n\n\t\t\t\tclonedGrandParent = _traverseNode(parent, FALSE, FALSE, how);\n\n\t\t\t\tif (how != DELETE)\n\t\t\t\t\tclonedGrandParent.appendChild(clonedParent);\n\n\t\t\t\tclonedParent = clonedGrandParent;\n\t\t\t}\n\t\t};\n\n\t\tfunction _traverseLeftBoundary(root, how) {\n\t\t\tvar next = _getSelectedNode(t[START_CONTAINER], t[START_OFFSET]), isFullySelected = next != t[START_CONTAINER], parent, clonedParent, nextSibling, clonedChild, clonedGrandParent;\n\n\t\t\tif (next == root)\n\t\t\t\treturn _traverseNode(next, isFullySelected, TRUE, how);\n\n\t\t\tparent = next.parentNode;\n\t\t\tclonedParent = _traverseNode(parent, FALSE, TRUE, how);\n\n\t\t\twhile (parent) {\n\t\t\t\twhile (next) {\n\t\t\t\t\tnextSibling = next.nextSibling;\n\t\t\t\t\tclonedChild = _traverseNode(next, isFullySelected, TRUE, how);\n\n\t\t\t\t\tif (how != DELETE)\n\t\t\t\t\t\tclonedParent.appendChild(clonedChild);\n\n\t\t\t\t\tisFullySelected = TRUE;\n\t\t\t\t\tnext = nextSibling;\n\t\t\t\t}\n\n\t\t\t\tif (parent == root)\n\t\t\t\t\treturn clonedParent;\n\n\t\t\t\tnext = parent.nextSibling;\n\t\t\t\tparent = parent.parentNode;\n\n\t\t\t\tclonedGrandParent = _traverseNode(parent, FALSE, TRUE, how);\n\n\t\t\t\tif (how != DELETE)\n\t\t\t\t\tclonedGrandParent.appendChild(clonedParent);\n\n\t\t\t\tclonedParent = clonedGrandParent;\n\t\t\t}\n\t\t};\n\n\t\tfunction _traverseNode(n, isFullySelected, isLeft, how) {\n\t\t\tvar txtValue, newNodeValue, oldNodeValue, offset, newNode;\n\n\t\t\tif (isFullySelected)\n\t\t\t\treturn _traverseFullySelected(n, how);\n\n\t\t\tif (n.nodeType == 3 /* TEXT_NODE */) {\n\t\t\t\ttxtValue = n.nodeValue;\n\n\t\t\t\tif (isLeft) {\n\t\t\t\t\toffset = t[START_OFFSET];\n\t\t\t\t\tnewNodeValue = txtValue.substring(offset);\n\t\t\t\t\toldNodeValue = txtValue.substring(0, offset);\n\t\t\t\t} else {\n\t\t\t\t\toffset = t[END_OFFSET];\n\t\t\t\t\tnewNodeValue = txtValue.substring(0, offset);\n\t\t\t\t\toldNodeValue = txtValue.substring(offset);\n\t\t\t\t}\n\n\t\t\t\tif (how != CLONE)\n\t\t\t\t\tn.nodeValue = oldNodeValue;\n\n\t\t\t\tif (how == DELETE)\n\t\t\t\t\treturn;\n\n\t\t\t\tnewNode = n.cloneNode(FALSE);\n\t\t\t\tnewNode.nodeValue = newNodeValue;\n\n\t\t\t\treturn newNode;\n\t\t\t}\n\n\t\t\tif (how == DELETE)\n\t\t\t\treturn;\n\n\t\t\treturn n.cloneNode(FALSE);\n\t\t};\n\n\t\tfunction _traverseFullySelected(n, how) {\n\t\t\tif (how != DELETE)\n\t\t\t\treturn how == CLONE ? n.cloneNode(TRUE) : n;\n\n\t\t\tn.parentNode.removeChild(n);\n\t\t};\n\t};\n\n\tns.Range = Range;\n})(tinymce.dom);\n","Magento_Tinymce3/tiny_mce/classes/dom/Element.js":"/**\n * Element.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\t/**\n\t * Element class, this enables element blocking in IE. Element blocking is a method to block out select blockes that\n\t * gets visible though DIVs on IE 6 it uses a iframe for this blocking. This class also shortens the length of some DOM API calls\n\t * since it's bound to an element.\n\t *\n\t * @class tinymce.dom.Element\n\t * @example\n\t * // Creates an basic element for an existing element\n\t * var elm = new tinymce.dom.Element('someid');\n\t * \n\t * elm.setStyle('background-color', 'red');\n\t * elm.moveTo(10, 10);\n\t */\n\n\t/**\n\t * Constructs a new Element instance. Consult the Wiki for more details on this class.\n\t *\n\t * @constructor\n\t * @method Element\n\t * @param {String} id Element ID to bind/execute methods on.\n\t * @param {Object} settings Optional settings name/value collection.\n\t */\n\ttinymce.dom.Element = function(id, settings) {\n\t\tvar t = this, dom, el;\n\n\t\tt.settings = settings = settings || {};\n\t\tt.id = id;\n\t\tt.dom = dom = settings.dom || tinymce.DOM;\n\n\t\t// Only IE leaks DOM references, this is a lot faster\n\t\tif (!tinymce.isIE)\n\t\t\tel = dom.get(t.id);\n\n\t\ttinymce.each(\n\t\t\t\t('getPos,getRect,getParent,add,setStyle,getStyle,setStyles,' + \n\t\t\t\t'setAttrib,setAttribs,getAttrib,addClass,removeClass,' + \n\t\t\t\t'hasClass,getOuterHTML,setOuterHTML,remove,show,hide,' + \n\t\t\t\t'isHidden,setHTML,get').split(/,/)\n\t\t\t, function(k) {\n\t\t\t\tt[k] = function() {\n\t\t\t\t\tvar a = [id], i;\n\n\t\t\t\t\tfor (i = 0; i < arguments.length; i++)\n\t\t\t\t\t\ta.push(arguments[i]);\n\n\t\t\t\t\ta = dom[k].apply(dom, a);\n\t\t\t\t\tt.update(k);\n\n\t\t\t\t\treturn a;\n\t\t\t\t};\n\t\t});\n\n\t\ttinymce.extend(t, {\n\t\t\t/**\n\t\t\t * Adds a event handler to the element.\n\t\t\t *\n\t\t\t * @method on\n\t\t\t * @param {String} n Event name like for example \"click\".\n\t\t\t * @param {function} f Function to execute on the specified event.\n\t\t\t * @param {Object} s Optional scope to execute function on.\n\t\t\t * @return {function} Event handler function the same as the input function.\n\t\t\t */\n\t\t\ton : function(n, f, s) {\n\t\t\t\treturn tinymce.dom.Event.add(t.id, n, f, s);\n\t\t\t},\n\n\t\t\t/**\n\t\t\t * Returns the absolute X, Y cordinate of the element.\n\t\t\t *\n\t\t\t * @method getXY\n\t\t\t * @return {Object} Objext with x, y cordinate fields.\n\t\t\t */\n\t\t\tgetXY : function() {\n\t\t\t\treturn {\n\t\t\t\t\tx : parseInt(t.getStyle('left')),\n\t\t\t\t\ty : parseInt(t.getStyle('top'))\n\t\t\t\t};\n\t\t\t},\n\n\t\t\t/**\n\t\t\t * Returns the size of the element by a object with w and h fields.\n\t\t\t *\n\t\t\t * @method getSize\n\t\t\t * @return {Object} Object with element size with a w and h field.\n\t\t\t */\n\t\t\tgetSize : function() {\n\t\t\t\tvar n = dom.get(t.id);\n\n\t\t\t\treturn {\n\t\t\t\t\tw : parseInt(t.getStyle('width') || n.clientWidth),\n\t\t\t\t\th : parseInt(t.getStyle('height') || n.clientHeight)\n\t\t\t\t};\n\t\t\t},\n\n\t\t\t/**\n\t\t\t * Moves the element to a specific absolute position.\n\t\t\t *\n\t\t\t * @method moveTo\n\t\t\t * @param {Number} x X cordinate of element position.\n\t\t\t * @param {Number} y Y cordinate of element position.\n\t\t\t */\n\t\t\tmoveTo : function(x, y) {\n\t\t\t\tt.setStyles({left : x, top : y});\n\t\t\t},\n\n\t\t\t/**\n\t\t\t * Moves the element relative to the current position.\n\t\t\t *\n\t\t\t * @method moveBy\n\t\t\t * @param {Number} x Relative X cordinate of element position.\n\t\t\t * @param {Number} y Relative Y cordinate of element position.\n\t\t\t */\n\t\t\tmoveBy : function(x, y) {\n\t\t\t\tvar p = t.getXY();\n\n\t\t\t\tt.moveTo(p.x + x, p.y + y);\n\t\t\t},\n\n\t\t\t/**\n\t\t\t * Resizes the element to a specific size.\n\t\t\t *\n\t\t\t * @method resizeTo\n\t\t\t * @param {Number} w New width of element.\n\t\t\t * @param {Numner} h New height of element.\n\t\t\t */\n\t\t\tresizeTo : function(w, h) {\n\t\t\t\tt.setStyles({width : w, height : h});\n\t\t\t},\n\n\t\t\t/**\n\t\t\t * Resizes the element relative to the current sizeto a specific size.\n\t\t\t *\n\t\t\t * @method resizeBy\n\t\t\t * @param {Number} w Relative width of element.\n\t\t\t * @param {Numner} h Relative height of element.\n\t\t\t */\n\t\t\tresizeBy : function(w, h) {\n\t\t\t\tvar s = t.getSize();\n\n\t\t\t\tt.resizeTo(s.w + w, s.h + h);\n\t\t\t},\n\n\t\t\t/**\n\t\t\t * Updates the element blocker in IE6 based on the style information of the element.\n\t\t\t *\n\t\t\t * @method update\n\t\t\t * @param {String} k Optional function key. Used internally.\n\t\t\t */\n\t\t\tupdate : function(k) {\n\t\t\t\tvar b;\n\n\t\t\t\tif (tinymce.isIE6 && settings.blocker) {\n\t\t\t\t\tk = k || '';\n\n\t\t\t\t\t// Ignore getters\n\t\t\t\t\tif (k.indexOf('get') === 0 || k.indexOf('has') === 0 || k.indexOf('is') === 0)\n\t\t\t\t\t\treturn;\n\n\t\t\t\t\t// Remove blocker on remove\n\t\t\t\t\tif (k == 'remove') {\n\t\t\t\t\t\tdom.remove(t.blocker);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!t.blocker) {\n\t\t\t\t\t\tt.blocker = dom.uniqueId();\n\t\t\t\t\t\tb = dom.add(settings.container || dom.getRoot(), 'iframe', {id : t.blocker, style : 'position:absolute;', frameBorder : 0, src : 'javascript:\"\"'});\n\t\t\t\t\t\tdom.setStyle(b, 'opacity', 0);\n\t\t\t\t\t} else\n\t\t\t\t\t\tb = dom.get(t.blocker);\n\n\t\t\t\t\tdom.setStyles(b, {\n\t\t\t\t\t\tleft : t.getStyle('left', 1),\n\t\t\t\t\t\ttop : t.getStyle('top', 1),\n\t\t\t\t\t\twidth : t.getStyle('width', 1),\n\t\t\t\t\t\theight : t.getStyle('height', 1),\n\t\t\t\t\t\tdisplay : t.getStyle('display', 1),\n\t\t\t\t\t\tzIndex : parseInt(t.getStyle('zIndex', 1) || 0) - 1\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t};\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/dom/TridentSelection.js":"/**\n * TridentSelection.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function() {\n\tfunction Selection(selection) {\n\t\tvar self = this, dom = selection.dom, TRUE = true, FALSE = false;\n\n\t\tfunction getPosition(rng, start) {\n\t\t\tvar checkRng, startIndex = 0, endIndex, inside,\n\t\t\t\tchildren, child, offset, index, position = -1, parent;\n\n\t\t\t// Setup test range, collapse it and get the parent\n\t\t\tcheckRng = rng.duplicate();\n\t\t\tcheckRng.collapse(start);\n\t\t\tparent = checkRng.parentElement();\n\n\t\t\t// Check if the selection is within the right document\n\t\t\tif (parent.ownerDocument !== selection.dom.doc)\n\t\t\t\treturn;\n\n\t\t\t// IE will report non editable elements as it's parent so look for an editable one\n\t\t\twhile (parent.contentEditable === \"false\") {\n\t\t\t\tparent = parent.parentNode;\n\t\t\t}\n\n\t\t\t// If parent doesn't have any children then return that we are inside the element\n\t\t\tif (!parent.hasChildNodes()) {\n\t\t\t\treturn {node : parent, inside : 1};\n\t\t\t}\n\n\t\t\t// Setup node list and endIndex\n\t\t\tchildren = parent.children;\n\t\t\tendIndex = children.length - 1;\n\n\t\t\t// Perform a binary search for the position\n\t\t\twhile (startIndex <= endIndex) {\n\t\t\t\tindex = Math.floor((startIndex + endIndex) / 2);\n\n\t\t\t\t// Move selection to node and compare the ranges\n\t\t\t\tchild = children[index];\n\t\t\t\tcheckRng.moveToElementText(child);\n\t\t\t\tposition = checkRng.compareEndPoints(start ? 'StartToStart' : 'EndToEnd', rng);\n\n\t\t\t\t// Before/after or an exact match\n\t\t\t\tif (position > 0) {\n\t\t\t\t\tendIndex = index - 1;\n\t\t\t\t} else if (position < 0) {\n\t\t\t\t\tstartIndex = index + 1;\n\t\t\t\t} else {\n\t\t\t\t\treturn {node : child};\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Check if child position is before or we didn't find a position\n\t\t\tif (position < 0) {\n\t\t\t\t// No element child was found use the parent element and the offset inside that\n\t\t\t\tif (!child) {\n\t\t\t\t\tcheckRng.moveToElementText(parent);\n\t\t\t\t\tcheckRng.collapse(true);\n\t\t\t\t\tchild = parent;\n\t\t\t\t\tinside = true;\n\t\t\t\t} else\n\t\t\t\t\tcheckRng.collapse(false);\n\n\t\t\t\tcheckRng.setEndPoint(start ? 'EndToStart' : 'EndToEnd', rng);\n\n\t\t\t\t// Fix for edge case: <div style=\"width: 100px; height:100px;\"><table>..</table>ab|c</div>\n\t\t\t\tif (checkRng.compareEndPoints(start ? 'StartToStart' : 'StartToEnd', rng) > 0) {\n\t\t\t\t\tcheckRng = rng.duplicate();\n\t\t\t\t\tcheckRng.collapse(start);\n\n\t\t\t\t\toffset = -1;\n\t\t\t\t\twhile (parent == checkRng.parentElement()) {\n\t\t\t\t\t\tif (checkRng.move('character', -1) == 0)\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\toffset++;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\toffset = offset || checkRng.text.replace('\\r\\n', ' ').length;\n\t\t\t} else {\n\t\t\t\t// Child position is after the selection endpoint\n\t\t\t\tcheckRng.collapse(true);\n\t\t\t\tcheckRng.setEndPoint(start ? 'StartToStart' : 'StartToEnd', rng);\n\n\t\t\t\t// Get the length of the text to find where the endpoint is relative to it's container\n\t\t\t\toffset = checkRng.text.replace('\\r\\n', ' ').length;\n\t\t\t}\n\n\t\t\treturn {node : child, position : position, offset : offset, inside : inside};\n\t\t};\n\n\t\t// Returns a W3C DOM compatible range object by using the IE Range API\n\t\tfunction getRange() {\n\t\t\tvar ieRange = selection.getRng(), domRange = dom.createRng(), element, collapsed, tmpRange, element2, bookmark, fail;\n\n\t\t\t// If selection is outside the current document just return an empty range\n\t\t\telement = ieRange.item ? ieRange.item(0) : ieRange.parentElement();\n\t\t\tif (element.ownerDocument != dom.doc)\n\t\t\t\treturn domRange;\n\n\t\t\tcollapsed = selection.isCollapsed();\n\n\t\t\t// Handle control selection\n\t\t\tif (ieRange.item) {\n\t\t\t\tdomRange.setStart(element.parentNode, dom.nodeIndex(element));\n\t\t\t\tdomRange.setEnd(domRange.startContainer, domRange.startOffset + 1);\n\n\t\t\t\treturn domRange;\n\t\t\t}\n\n\t\t\tfunction findEndPoint(start) {\n\t\t\t\tvar endPoint = getPosition(ieRange, start), container, offset, textNodeOffset = 0, sibling, undef, nodeValue;\n\n\t\t\t\tcontainer = endPoint.node;\n\t\t\t\toffset = endPoint.offset;\n\n\t\t\t\tif (endPoint.inside && !container.hasChildNodes()) {\n\t\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](container, 0);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (offset === undef) {\n\t\t\t\t\tdomRange[start ? 'setStartBefore' : 'setEndAfter'](container);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (endPoint.position < 0) {\n\t\t\t\t\tsibling = endPoint.inside ? container.firstChild : container.nextSibling;\n\n\t\t\t\t\tif (!sibling) {\n\t\t\t\t\t\tdomRange[start ? 'setStartAfter' : 'setEndAfter'](container);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (!offset) {\n\t\t\t\t\t\tif (sibling.nodeType == 3)\n\t\t\t\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](sibling, 0);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tdomRange[start ? 'setStartBefore' : 'setEndBefore'](sibling);\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Find the text node and offset\n\t\t\t\t\twhile (sibling) {\n\t\t\t\t\t\tnodeValue = sibling.nodeValue;\n\t\t\t\t\t\ttextNodeOffset += nodeValue.length;\n\n\t\t\t\t\t\t// We are at or passed the position we where looking for\n\t\t\t\t\t\tif (textNodeOffset >= offset) {\n\t\t\t\t\t\t\tcontainer = sibling;\n\t\t\t\t\t\t\ttextNodeOffset -= offset;\n\t\t\t\t\t\t\ttextNodeOffset = nodeValue.length - textNodeOffset;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tsibling = sibling.nextSibling;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\t// Find the text node and offset\n\t\t\t\t\tsibling = container.previousSibling;\n\n\t\t\t\t\tif (!sibling)\n\t\t\t\t\t\treturn domRange[start ? 'setStartBefore' : 'setEndBefore'](container);\n\n\t\t\t\t\t// If there isn't any text to loop then use the first position\n\t\t\t\t\tif (!offset) {\n\t\t\t\t\t\tif (container.nodeType == 3)\n\t\t\t\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](sibling, container.nodeValue.length);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tdomRange[start ? 'setStartAfter' : 'setEndAfter'](sibling);\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\twhile (sibling) {\n\t\t\t\t\t\ttextNodeOffset += sibling.nodeValue.length;\n\n\t\t\t\t\t\t// We are at or passed the position we where looking for\n\t\t\t\t\t\tif (textNodeOffset >= offset) {\n\t\t\t\t\t\t\tcontainer = sibling;\n\t\t\t\t\t\t\ttextNodeOffset -= offset;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tsibling = sibling.previousSibling;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tdomRange[start ? 'setStart' : 'setEnd'](container, textNodeOffset);\n\t\t\t};\n\n\t\t\ttry {\n\t\t\t\t// Find start point\n\t\t\t\tfindEndPoint(true);\n\n\t\t\t\t// Find end point if needed\n\t\t\t\tif (!collapsed)\n\t\t\t\t\tfindEndPoint();\n\t\t\t} catch (ex) {\n\t\t\t\t// IE has a nasty bug where text nodes might throw \"invalid argument\" when you\n\t\t\t\t// access the nodeValue or other properties of text nodes. This seems to happend when\n\t\t\t\t// text nodes are split into two nodes by a delete/backspace call. So lets detect it and try to fix it.\n\t\t\t\tif (ex.number == -2147024809) {\n\t\t\t\t\t// Get the current selection\n\t\t\t\t\tbookmark = self.getBookmark(2);\n\n\t\t\t\t\t// Get start element\n\t\t\t\t\ttmpRange = ieRange.duplicate();\n\t\t\t\t\ttmpRange.collapse(true);\n\t\t\t\t\telement = tmpRange.parentElement();\n\n\t\t\t\t\t// Get end element\n\t\t\t\t\tif (!collapsed) {\n\t\t\t\t\t\ttmpRange = ieRange.duplicate();\n\t\t\t\t\t\ttmpRange.collapse(false);\n\t\t\t\t\t\telement2 = tmpRange.parentElement();\n\t\t\t\t\t\telement2.innerHTML = element2.innerHTML;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Remove the broken elements\n\t\t\t\t\telement.innerHTML = element.innerHTML;\n\n\t\t\t\t\t// Restore the selection\n\t\t\t\t\tself.moveToBookmark(bookmark);\n\n\t\t\t\t\t// Since the range has moved we need to re-get it\n\t\t\t\t\tieRange = selection.getRng();\n\n\t\t\t\t\t// Find start point\n\t\t\t\t\tfindEndPoint(true);\n\n\t\t\t\t\t// Find end point if needed\n\t\t\t\t\tif (!collapsed)\n\t\t\t\t\t\tfindEndPoint();\n\t\t\t\t} else\n\t\t\t\t\tthrow ex; // Throw other errors\n\t\t\t}\n\n\t\t\treturn domRange;\n\t\t};\n\n\t\tthis.getBookmark = function(type) {\n\t\t\tvar rng = selection.getRng(), start, end, bookmark = {};\n\n\t\t\tfunction getIndexes(node) {\n\t\t\t\tvar node, parent, root, children, i, indexes = [];\n\n\t\t\t\tparent = node.parentNode;\n\t\t\t\troot = dom.getRoot().parentNode;\n\n\t\t\t\twhile (parent != root && parent.nodeType !== 9) {\n\t\t\t\t\tchildren = parent.children;\n\n\t\t\t\t\ti = children.length;\n\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\tif (node === children[i]) {\n\t\t\t\t\t\t\tindexes.push(i);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tnode = parent;\n\t\t\t\t\tparent = parent.parentNode;\n\t\t\t\t}\n\n\t\t\t\treturn indexes;\n\t\t\t};\n\n\t\t\tfunction getBookmarkEndPoint(start) {\n\t\t\t\tvar position;\n\n\t\t\t\tposition = getPosition(rng, start);\n\t\t\t\tif (position) {\n\t\t\t\t\treturn {\n\t\t\t\t\t\tposition : position.position,\n\t\t\t\t\t\toffset : position.offset,\n\t\t\t\t\t\tindexes : getIndexes(position.node),\n\t\t\t\t\t\tinside : position.inside\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// Non ubstructive bookmark\n\t\t\tif (type === 2) {\n\t\t\t\t// Handle text selection\n\t\t\t\tif (!rng.item) {\n\t\t\t\t\tbookmark.start = getBookmarkEndPoint(true);\n\n\t\t\t\t\tif (!selection.isCollapsed())\n\t\t\t\t\t\tbookmark.end = getBookmarkEndPoint();\n\t\t\t\t} else\n\t\t\t\t\tbookmark.start = {ctrl : true, indexes : getIndexes(rng.item(0))};\n\t\t\t}\n\n\t\t\treturn bookmark;\n\t\t};\n\n\t\tthis.moveToBookmark = function(bookmark) {\n\t\t\tvar rng, body = dom.doc.body;\n\n\t\t\tfunction resolveIndexes(indexes) {\n\t\t\t\tvar node, i, idx, children;\n\n\t\t\t\tnode = dom.getRoot();\n\t\t\t\tfor (i = indexes.length - 1; i >= 0; i--) {\n\t\t\t\t\tchildren = node.children;\n\t\t\t\t\tidx = indexes[i];\n\n\t\t\t\t\tif (idx <= children.length - 1) {\n\t\t\t\t\t\tnode = children[idx];\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn node;\n\t\t\t};\n\t\t\t\n\t\t\tfunction setBookmarkEndPoint(start) {\n\t\t\t\tvar endPoint = bookmark[start ? 'start' : 'end'], moveLeft, moveRng, undef;\n\n\t\t\t\tif (endPoint) {\n\t\t\t\t\tmoveLeft = endPoint.position > 0;\n\n\t\t\t\t\tmoveRng = body.createTextRange();\n\t\t\t\t\tmoveRng.moveToElementText(resolveIndexes(endPoint.indexes));\n\n\t\t\t\t\toffset = endPoint.offset;\n\t\t\t\t\tif (offset !== undef) {\n\t\t\t\t\t\tmoveRng.collapse(endPoint.inside || moveLeft);\n\t\t\t\t\t\tmoveRng.moveStart('character', moveLeft ? -offset : offset);\n\t\t\t\t\t} else\n\t\t\t\t\t\tmoveRng.collapse(start);\n\n\t\t\t\t\trng.setEndPoint(start ? 'StartToStart' : 'EndToStart', moveRng);\n\n\t\t\t\t\tif (start)\n\t\t\t\t\t\trng.collapse(true);\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tif (bookmark.start) {\n\t\t\t\tif (bookmark.start.ctrl) {\n\t\t\t\t\trng = body.createControlRange();\n\t\t\t\t\trng.addElement(resolveIndexes(bookmark.start.indexes));\n\t\t\t\t\trng.select();\n\t\t\t\t} else {\n\t\t\t\t\trng = body.createTextRange();\n\t\t\t\t\tsetBookmarkEndPoint(true);\n\t\t\t\t\tsetBookmarkEndPoint();\n\t\t\t\t\trng.select();\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\n\t\tthis.addRange = function(rng) {\n\t\t\tvar ieRng, ctrlRng, startContainer, startOffset, endContainer, endOffset, doc = selection.dom.doc, body = doc.body;\n\n\t\t\tfunction setEndPoint(start) {\n\t\t\t\tvar container, offset, marker, tmpRng, nodes;\n\n\t\t\t\tmarker = dom.create('a');\n\t\t\t\tcontainer = start ? startContainer : endContainer;\n\t\t\t\toffset = start ? startOffset : endOffset;\n\t\t\t\ttmpRng = ieRng.duplicate();\n\n\t\t\t\tif (container == doc || container == doc.documentElement) {\n\t\t\t\t\tcontainer = body;\n\t\t\t\t\toffset = 0;\n\t\t\t\t}\n\n\t\t\t\tif (container.nodeType == 3) {\n\t\t\t\t\tcontainer.parentNode.insertBefore(marker, container);\n\t\t\t\t\ttmpRng.moveToElementText(marker);\n\t\t\t\t\ttmpRng.moveStart('character', offset);\n\t\t\t\t\tdom.remove(marker);\n\t\t\t\t\tieRng.setEndPoint(start ? 'StartToStart' : 'EndToEnd', tmpRng);\n\t\t\t\t} else {\n\t\t\t\t\tnodes = container.childNodes;\n\n\t\t\t\t\tif (nodes.length) {\n\t\t\t\t\t\tif (offset >= nodes.length) {\n\t\t\t\t\t\t\tdom.insertAfter(marker, nodes[nodes.length - 1]);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tcontainer.insertBefore(marker, nodes[offset]);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\ttmpRng.moveToElementText(marker);\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Empty node selection for example <div>|</div>\n\t\t\t\t\t\tmarker = doc.createTextNode('\\uFEFF');\n\t\t\t\t\t\tcontainer.appendChild(marker);\n\t\t\t\t\t\ttmpRng.moveToElementText(marker.parentNode);\n\t\t\t\t\t\ttmpRng.collapse(TRUE);\n\t\t\t\t\t}\n\n\t\t\t\t\tieRng.setEndPoint(start ? 'StartToStart' : 'EndToEnd', tmpRng);\n\t\t\t\t\tdom.remove(marker);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Setup some shorter versions\n\t\t\tstartContainer = rng.startContainer;\n\t\t\tstartOffset = rng.startOffset;\n\t\t\tendContainer = rng.endContainer;\n\t\t\tendOffset = rng.endOffset;\n\t\t\tieRng = body.createTextRange();\n\n\t\t\t// If single element selection then try making a control selection out of it\n\t\t\tif (startContainer == endContainer && startContainer.nodeType == 1 && startOffset == endOffset - 1) {\n\t\t\t\tif (startOffset == endOffset - 1) {\n\t\t\t\t\ttry {\n\t\t\t\t\t\tctrlRng = body.createControlRange();\n\t\t\t\t\t\tctrlRng.addElement(startContainer.childNodes[startOffset]);\n\t\t\t\t\t\tctrlRng.select();\n\t\t\t\t\t\treturn;\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// Ignore\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Set start/end point of selection\n\t\t\tsetEndPoint(true);\n\t\t\tsetEndPoint();\n\n\t\t\t// Select the new range and scroll it into view\n\t\t\tieRng.select();\n\t\t};\n\n\t\t// Expose range method\n\t\tthis.getRangeAt = getRange;\n\t};\n\n\t// Expose the selection object\n\ttinymce.dom.TridentSelection = Selection;\n})();\n","Magento_Tinymce3/tiny_mce/classes/dom/TreeWalker.js":"/**\n * TreeWalker.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\ntinymce.dom.TreeWalker = function(start_node, root_node) {\n\tvar node = start_node;\n\n\tfunction findSibling(node, start_name, sibling_name, shallow) {\n\t\tvar sibling, parent;\n\n\t\tif (node) {\n\t\t\t// Walk into nodes if it has a start\n\t\t\tif (!shallow && node[start_name])\n\t\t\t\treturn node[start_name];\n\n\t\t\t// Return the sibling if it has one\n\t\t\tif (node != root_node) {\n\t\t\t\tsibling = node[sibling_name];\n\t\t\t\tif (sibling)\n\t\t\t\t\treturn sibling;\n\n\t\t\t\t// Walk up the parents to look for siblings\n\t\t\t\tfor (parent = node.parentNode; parent && parent != root_node; parent = parent.parentNode) {\n\t\t\t\t\tsibling = parent[sibling_name];\n\t\t\t\t\tif (sibling)\n\t\t\t\t\t\treturn sibling;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t};\n\n\t/**\n\t * Returns the current node.\n\t *\n\t * @return {Node} Current node where the walker is.\n\t */\n\tthis.current = function() {\n\t\treturn node;\n\t};\n\n\t/**\n\t * Walks to the next node in tree.\n\t *\n\t * @return {Node} Current node where the walker is after moving to the next node.\n\t */\n\tthis.next = function(shallow) {\n\t\treturn (node = findSibling(node, 'firstChild', 'nextSibling', shallow));\n\t};\n\n\t/**\n\t * Walks to the previous node in tree.\n\t *\n\t * @return {Node} Current node where the walker is after moving to the previous node.\n\t */\n\tthis.prev = function(shallow) {\n\t\treturn (node = findSibling(node, 'lastChild', 'previousSibling', shallow));\n\t};\n};\n","Magento_Tinymce3/tiny_mce/classes/dom/RangeUtils.js":"/**\n * Range.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\ttinymce.dom.RangeUtils = function(dom) {\n\t\tvar INVISIBLE_CHAR = '\\uFEFF';\n\n\t\t/**\n\t\t * Walks the specified range like object and executes the callback for each sibling collection it finds.\n\t\t *\n\t\t * @param {Object} rng Range like object.\n\t\t * @param {function} callback Callback function to execute for each sibling collection.\n\t\t */\n\t\tthis.walk = function(rng, callback) {\n\t\t\tvar startContainer = rng.startContainer,\n\t\t\t\tstartOffset = rng.startOffset,\n\t\t\t\tendContainer = rng.endContainer,\n\t\t\t\tendOffset = rng.endOffset,\n\t\t\t\tancestor, startPoint,\n\t\t\t\tendPoint, node, parent, siblings, nodes;\n\n\t\t\t// Handle table cell selection the table plugin enables\n\t\t\t// you to fake select table cells and perform formatting actions on them\n\t\t\tnodes = dom.select('td.mceSelected,th.mceSelected');\n\t\t\tif (nodes.length > 0) {\n\t\t\t\ttinymce.each(nodes, function(node) {\n\t\t\t\t\tcallback([node]);\n\t\t\t\t});\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t/**\n\t\t\t * Excludes start/end text node if they are out side the range\n\t\t\t *\n\t\t\t * @private\n\t\t\t * @param {Array} nodes Nodes to exclude items from.\n\t\t\t * @return {Array} Array with nodes excluding the start/end container if needed.\n\t\t\t */\n\t\t\tfunction exclude(nodes) {\n\t\t\t\tvar node;\n\n\t\t\t\t// First node is excluded\n\t\t\t\tnode = nodes[0];\n\t\t\t\tif (node.nodeType === 3 && node === startContainer && startOffset >= node.nodeValue.length) {\n\t\t\t\t\tnodes.splice(0, 1);\n\t\t\t\t}\n\n\t\t\t\t// Last node is excluded\n\t\t\t\tnode = nodes[nodes.length - 1];\n\t\t\t\tif (endOffset === 0 && nodes.length > 0 && node === endContainer && node.nodeType === 3) {\n\t\t\t\t\tnodes.splice(nodes.length - 1, 1);\n\t\t\t\t}\n\n\t\t\t\treturn nodes;\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * Collects siblings\n\t\t\t *\n\t\t\t * @private\n\t\t\t * @param {Node} node Node to collect siblings from.\n\t\t\t * @param {String} name Name of the sibling to check for.\n\t\t\t * @return {Array} Array of collected siblings.\n\t\t\t */\n\t\t\tfunction collectSiblings(node, name, end_node) {\n\t\t\t\tvar siblings = [];\n\n\t\t\t\tfor (; node && node != end_node; node = node[name])\n\t\t\t\t\tsiblings.push(node);\n\n\t\t\t\treturn siblings;\n\t\t\t};\n\n\t\t\t/**\n\t\t\t * Find an end point this is the node just before the common ancestor root.\n\t\t\t *\n\t\t\t * @private\n\t\t\t * @param {Node} node Node to start at.\n\t\t\t * @param {Node} root Root/ancestor element to stop just before.\n\t\t\t * @return {Node} Node just before the root element.\n\t\t\t */\n\t\t\tfunction findEndPoint(node, root) {\n\t\t\t\tdo {\n\t\t\t\t\tif (node.parentNode == root)\n\t\t\t\t\t\treturn node;\n\n\t\t\t\t\tnode = node.parentNode;\n\t\t\t\t} while(node);\n\t\t\t};\n\n\t\t\tfunction walkBoundary(start_node, end_node, next) {\n\t\t\t\tvar siblingName = next ? 'nextSibling' : 'previousSibling';\n\n\t\t\t\tfor (node = start_node, parent = node.parentNode; node && node != end_node; node = parent) {\n\t\t\t\t\tparent = node.parentNode;\n\t\t\t\t\tsiblings = collectSiblings(node == start_node ? node : node[siblingName], siblingName);\n\n\t\t\t\t\tif (siblings.length) {\n\t\t\t\t\t\tif (!next)\n\t\t\t\t\t\t\tsiblings.reverse();\n\n\t\t\t\t\t\tcallback(exclude(siblings));\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t};\n\n\t\t\t// If index based start position then resolve it\n\t\t\tif (startContainer.nodeType == 1 && startContainer.hasChildNodes())\n\t\t\t\tstartContainer = startContainer.childNodes[startOffset];\n\n\t\t\t// If index based end position then resolve it\n\t\t\tif (endContainer.nodeType == 1 && endContainer.hasChildNodes())\n\t\t\t\tendContainer = endContainer.childNodes[Math.min(endOffset - 1, endContainer.childNodes.length - 1)];\n\n\t\t\t// Same container\n\t\t\tif (startContainer == endContainer)\n\t\t\t\treturn callback(exclude([startContainer]));\n\n\t\t\t// Find common ancestor and end points\n\t\t\tancestor = dom.findCommonAncestor(startContainer, endContainer);\n\t\t\t\t\n\t\t\t// Process left side\n\t\t\tfor (node = startContainer; node; node = node.parentNode) {\n\t\t\t\tif (node === endContainer)\n\t\t\t\t\treturn walkBoundary(startContainer, ancestor, true);\n\n\t\t\t\tif (node === ancestor)\n\t\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\t// Process right side\n\t\t\tfor (node = endContainer; node; node = node.parentNode) {\n\t\t\t\tif (node === startContainer)\n\t\t\t\t\treturn walkBoundary(endContainer, ancestor);\n\n\t\t\t\tif (node === ancestor)\n\t\t\t\t\tbreak;\n\t\t\t}\n\n\t\t\t// Find start/end point\n\t\t\tstartPoint = findEndPoint(startContainer, ancestor) || startContainer;\n\t\t\tendPoint = findEndPoint(endContainer, ancestor) || endContainer;\n\n\t\t\t// Walk left leaf\n\t\t\twalkBoundary(startContainer, startPoint, true);\n\n\t\t\t// Walk the middle from start to end point\n\t\t\tsiblings = collectSiblings(\n\t\t\t\tstartPoint == startContainer ? startPoint : startPoint.nextSibling,\n\t\t\t\t'nextSibling',\n\t\t\t\tendPoint == endContainer ? endPoint.nextSibling : endPoint\n\t\t\t);\n\n\t\t\tif (siblings.length)\n\t\t\t\tcallback(exclude(siblings));\n\n\t\t\t// Walk right leaf\n\t\t\twalkBoundary(endContainer, endPoint);\n\t\t};\n\n\t\t/**\n\t\t * Splits the specified range at it's start/end points.\n\t\t *\n\t\t * @param {Range/RangeObject} rng Range to split.\n\t\t * @return {Object} Range position object.\n\t\t */\n\t\tthis.split = function(rng) {\n\t\t\tvar startContainer = rng.startContainer,\n\t\t\t\tstartOffset = rng.startOffset,\n\t\t\t\tendContainer = rng.endContainer,\n\t\t\t\tendOffset = rng.endOffset;\n\n\t\t\tfunction splitText(node, offset) {\n\t\t\t\treturn node.splitText(offset);\n\t\t\t};\n\n\t\t\t// Handle single text node\n\t\t\tif (startContainer == endContainer && startContainer.nodeType == 3) {\n\t\t\t\tif (startOffset > 0 && startOffset < startContainer.nodeValue.length) {\n\t\t\t\t\tendContainer = splitText(startContainer, startOffset);\n\t\t\t\t\tstartContainer = endContainer.previousSibling;\n\n\t\t\t\t\tif (endOffset > startOffset) {\n\t\t\t\t\t\tendOffset = endOffset - startOffset;\n\t\t\t\t\t\tstartContainer = endContainer = splitText(endContainer, endOffset).previousSibling;\n\t\t\t\t\t\tendOffset = endContainer.nodeValue.length;\n\t\t\t\t\t\tstartOffset = 0;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tendOffset = 0;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\t// Split startContainer text node if needed\n\t\t\t\tif (startContainer.nodeType == 3 && startOffset > 0 && startOffset < startContainer.nodeValue.length) {\n\t\t\t\t\tstartContainer = splitText(startContainer, startOffset);\n\t\t\t\t\tstartOffset = 0;\n\t\t\t\t}\n\n\t\t\t\t// Split endContainer text node if needed\n\t\t\t\tif (endContainer.nodeType == 3 && endOffset > 0 && endOffset < endContainer.nodeValue.length) {\n\t\t\t\t\tendContainer = splitText(endContainer, endOffset).previousSibling;\n\t\t\t\t\tendOffset = endContainer.nodeValue.length;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn {\n\t\t\t\tstartContainer : startContainer,\n\t\t\t\tstartOffset : startOffset,\n\t\t\t\tendContainer : endContainer,\n\t\t\t\tendOffset : endOffset\n\t\t\t};\n\t\t};\n\n\t};\n\n\t/**\n\t * Compares two ranges and checks if they are equal.\n\t *\n\t * @static\n\t * @param {DOMRange} rng1 First range to compare.\n\t * @param {DOMRange} rng2 First range to compare.\n\t * @return {Boolean} true/false if the ranges are equal.\n\t */\n\ttinymce.dom.RangeUtils.compareRanges = function(rng1, rng2) {\n\t\tif (rng1 && rng2) {\n\t\t\t// Compare native IE ranges\n\t\t\tif (rng1.item || rng1.duplicate) {\n\t\t\t\t// Both are control ranges and the selected element matches\n\t\t\t\tif (rng1.item && rng2.item && rng1.item(0) === rng2.item(0))\n\t\t\t\t\treturn true;\n\n\t\t\t\t// Both are text ranges and the range matches\n\t\t\t\tif (rng1.isEqual && rng2.isEqual && rng2.isEqual(rng1))\n\t\t\t\t\treturn true;\n\t\t\t} else {\n\t\t\t\t// Compare w3c ranges\n\t\t\t\treturn rng1.startContainer == rng2.startContainer && rng1.startOffset == rng2.startOffset;\n\t\t\t}\n\t\t}\n\n\t\treturn false;\n\t};\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/dom/Serializer.js":"/**\n * Serializer.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\t/**\n\t * This class is used to serialize DOM trees into a string. Consult the TinyMCE Wiki API for more details and examples on how to use this class. \n\t *\n\t * @class tinymce.dom.Serializer\n\t */\n\n\t/**\n\t * Constucts a new DOM serializer class.\n\t *\n\t * @constructor\n\t * @method Serializer\n\t * @param {Object} settings Serializer settings object.\n\t * @param {tinymce.dom.DOMUtils} dom DOMUtils instance reference.\n\t * @param {tinymce.html.Schema} schema Optional schema reference.\n\t */\n\ttinymce.dom.Serializer = function(settings, dom, schema) {\n\t\tvar onPreProcess, onPostProcess, isIE = tinymce.isIE, each = tinymce.each, htmlParser;\n\n\t\t// Support the old apply_source_formatting option\n\t\tif (!settings.apply_source_formatting)\n\t\t\tsettings.indent = false;\n\n\t\tsettings.remove_trailing_brs = true;\n\n\t\t// Default DOM and Schema if they are undefined\n\t\tdom = dom || tinymce.DOM;\n\t\tschema = schema || new tinymce.html.Schema(settings);\n\t\tsettings.entity_encoding = settings.entity_encoding || 'named';\n\n\t\t/**\n\t\t * This event gets executed before a HTML fragment gets serialized into a HTML string. This event enables you to do modifications to the DOM before the serialization occurs. It's important to know that the element that is getting serialized is cloned so it's not inside a document.\n\t\t *\n\t\t * @event onPreProcess\n\t\t * @param {tinymce.dom.Serializer} sender object/Serializer instance that is serializing an element.\n\t\t * @param {Object} args Object containing things like the current node.\n\t\t * @example\n\t\t * // Adds an observer to the onPreProcess event\n\t\t * serializer.onPreProcess.add(function(se, o) {\n\t\t *     // Add a class to each paragraph\n\t\t *     se.dom.addClass(se.dom.select('p', o.node), 'myclass');\n\t\t * });\n\t\t */\n\t\tonPreProcess = new tinymce.util.Dispatcher(self);\n\n\t\t/**\n\t\t * This event gets executed after a HTML fragment has been serialized into a HTML string. This event enables you to do modifications to the HTML string like regexp replaces etc. \n\t\t *\n\t\t * @event onPreProcess\n\t\t * @param {tinymce.dom.Serializer} sender object/Serializer instance that is serializing an element.\n\t\t * @param {Object} args Object containing things like the current contents. \n\t\t * @example\n\t\t * // Adds an observer to the onPostProcess event\n\t\t * serializer.onPostProcess.add(function(se, o) {\n\t\t *    // Remove all paragraphs and replace with BR\n\t\t *    o.content = o.content.replace(/<p[^>]+>|<p>/g, '');\n\t\t *    o.content = o.content.replace(/<\\/p>/g, '<br />');\n\t\t * });\n\t\t */\n\t\tonPostProcess = new tinymce.util.Dispatcher(self);\n\n\t\thtmlParser = new tinymce.html.DomParser(settings, schema);\n\n\t\t// Convert move data-mce-src, data-mce-href and data-mce-style into nodes or process them if needed\n\t\thtmlParser.addAttributeFilter('src,href,style', function(nodes, name) {\n\t\t\tvar i = nodes.length, node, value, internalName = 'data-mce-' + name, urlConverter = settings.url_converter, urlConverterScope = settings.url_converter_scope, undef;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\n\t\t\t\tvalue = node.attributes.map[internalName];\n\t\t\t\tif (value !== undef) {\n\t\t\t\t\t// Set external name to internal value and remove internal\n\t\t\t\t\tnode.attr(name, value.length > 0 ? value : null);\n\t\t\t\t\tnode.attr(internalName, null);\n\t\t\t\t} else {\n\t\t\t\t\t// No internal attribute found then convert the value we have in the DOM\n\t\t\t\t\tvalue = node.attributes.map[name];\n\n\t\t\t\t\tif (name === \"style\")\n\t\t\t\t\t\tvalue = dom.serializeStyle(dom.parseStyle(value), node.name);\n\t\t\t\t\telse if (urlConverter)\n\t\t\t\t\t\tvalue = urlConverter.call(urlConverterScope, value, name, node.name);\n\n\t\t\t\t\tnode.attr(name, value.length > 0 ? value : null);\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\t// Remove internal classes mceItem<..>\n\t\thtmlParser.addAttributeFilter('class', function(nodes, name) {\n\t\t\tvar i = nodes.length, node, value;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\t\t\t\tvalue = node.attr('class').replace(/\\s*mce(Item\\w+|Selected)\\s*/g, '');\n\t\t\t\tnode.attr('class', value.length > 0 ? value : null);\n\t\t\t}\n\t\t});\n\n\t\t// Remove bookmark elements\n\t\thtmlParser.addAttributeFilter('data-mce-type', function(nodes, name, args) {\n\t\t\tvar i = nodes.length, node;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\n\t\t\t\tif (node.attributes.map['data-mce-type'] === 'bookmark' && !args.cleanup)\n\t\t\t\t\tnode.remove();\n\t\t\t}\n\t\t});\n\n\t\t// Force script into CDATA sections and remove the mce- prefix also add comments around styles\n\t\thtmlParser.addNodeFilter('script,style', function(nodes, name) {\n\t\t\tvar i = nodes.length, node, value;\n\n\t\t\tfunction trim(value) {\n\t\t\t\treturn value.replace(/(<!--\\[CDATA\\[|\\]\\]-->)/g, '\\n')\n\t\t\t\t\t\t.replace(/^[\\r\\n]*|[\\r\\n]*$/g, '')\n\t\t\t\t\t\t.replace(/^\\s*(\\/\\/\\s*<!--|\\/\\/\\s*<!\\[CDATA\\[|<!--|<!\\[CDATA\\[)[\\r\\n]*/g, '')\n\t\t\t\t\t\t.replace(/\\s*(\\/\\/\\s*\\]\\]>|\\/\\/\\s*-->|\\]\\]>|-->|\\]\\]-->)\\s*$/g, '');\n\t\t\t};\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\t\t\t\tvalue = node.firstChild ? node.firstChild.value : '';\n\n\t\t\t\tif (name === \"script\") {\n\t\t\t\t\t// Remove mce- prefix from script elements\n\t\t\t\t\tnode.attr('type', (node.attr('type') || 'text/javascript').replace(/^mce\\-/, ''));\n\n\t\t\t\t\tif (value.length > 0)\n\t\t\t\t\t\tnode.firstChild.value = '// <![CDATA[\\n' + trim(value) + '\\n// ]]>';\n\t\t\t\t} else {\n\t\t\t\t\tif (value.length > 0)\n\t\t\t\t\t\tnode.firstChild.value = '<!--\\n' + trim(value) + '\\n-->';\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\t// Convert comments to cdata and handle protected comments\n\t\thtmlParser.addNodeFilter('#comment', function(nodes, name) {\n\t\t\tvar i = nodes.length, node;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\n\t\t\t\tif (node.value.indexOf('[CDATA[') === 0) {\n\t\t\t\t\tnode.name = '#cdata';\n\t\t\t\t\tnode.type = 4;\n\t\t\t\t\tnode.value = node.value.replace(/^\\[CDATA\\[|\\]\\]$/g, '');\n\t\t\t\t} else if (node.value.indexOf('mce:protected ') === 0) {\n\t\t\t\t\tnode.name = \"#text\";\n\t\t\t\t\tnode.type = 3;\n\t\t\t\t\tnode.raw = true;\n\t\t\t\t\tnode.value = unescape(node.value).substr(14);\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\thtmlParser.addNodeFilter('xml:namespace,input', function(nodes, name) {\n\t\t\tvar i = nodes.length, node;\n\n\t\t\twhile (i--) {\n\t\t\t\tnode = nodes[i];\n\t\t\t\tif (node.type === 7)\n\t\t\t\t\tnode.remove();\n\t\t\t\telse if (node.type === 1) {\n\t\t\t\t\tif (name === \"input\" && !(\"type\" in node.attributes.map))\n\t\t\t\t\t\tnode.attr('type', 'text');\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\n\t\t// Fix list elements, TODO: Replace this later\n\t\tif (settings.fix_list_elements) {\n\t\t\thtmlParser.addNodeFilter('ul,ol', function(nodes, name) {\n\t\t\t\tvar i = nodes.length, node, parentNode;\n\n\t\t\t\twhile (i--) {\n\t\t\t\t\tnode = nodes[i];\n\t\t\t\t\tparentNode = node.parent;\n\n\t\t\t\t\tif (parentNode.name === 'ul' || parentNode.name === 'ol') {\n\t\t\t\t\t\tif (node.prev && node.prev.name === 'li') {\n\t\t\t\t\t\t\tnode.prev.append(node);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\n\t\t// Remove internal data attributes\n\t\thtmlParser.addAttributeFilter('data-mce-src,data-mce-href,data-mce-style', function(nodes, name) {\n\t\t\tvar i = nodes.length;\n\n\t\t\twhile (i--) {\n\t\t\t\tnodes[i].attr(name, null);\n\t\t\t}\n\t\t});\n\n\t\t// Return public methods\n\t\treturn {\n\t\t\t/**\n\t\t\t * Schema instance that was used to when the Serializer was constructed.\n\t\t\t *\n\t\t\t * @field {tinymce.html.Schema} schema\n\t\t\t */\n\t\t\tschema : schema,\n\n\t\t\t/**\n\t\t\t * Adds a node filter function to the parser used by the serializer, the parser will collect the specified nodes by name\n\t\t\t * and then execute the callback ones it has finished parsing the document.\n\t\t\t *\n\t\t\t * @example\n\t\t\t * parser.addNodeFilter('p,h1', function(nodes, name) {\n\t\t\t *\t\tfor (var i = 0; i < nodes.length; i++) {\n\t\t\t *\t\t\tconsole.log(nodes[i].name);\n\t\t\t *\t\t}\n\t\t\t * });\n\t\t\t * @method addNodeFilter\n\t\t\t * @method {String} name Comma separated list of nodes to collect.\n\t\t\t * @param {function} callback Callback function to execute once it has collected nodes.\n\t\t\t */\n\t\t\taddNodeFilter : htmlParser.addNodeFilter,\n\n\t\t\t/**\n\t\t\t * Adds a attribute filter function to the parser used by the serializer, the parser will collect nodes that has the specified attributes\n\t\t\t * and then execute the callback ones it has finished parsing the document.\n\t\t\t *\n\t\t\t * @example\n\t\t\t * parser.addAttributeFilter('src,href', function(nodes, name) {\n\t\t\t *\t\tfor (var i = 0; i < nodes.length; i++) {\n\t\t\t *\t\t\tconsole.log(nodes[i].name);\n\t\t\t *\t\t}\n\t\t\t * });\n\t\t\t * @method addAttributeFilter\n\t\t\t * @method {String} name Comma separated list of nodes to collect.\n\t\t\t * @param {function} callback Callback function to execute once it has collected nodes.\n\t\t\t */\n\t\t\taddAttributeFilter : htmlParser.addAttributeFilter,\n\n\t\t\t/**\n\t\t\t * Fires when the Serializer does a preProcess on the contents.\n\t\t\t *\n\t\t\t * @event onPreProcess\n\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t * @param {Object} obj PreProcess object.\n\t\t\t * @option {Node} node DOM node for the item being serialized.\n\t\t\t * @option {String} format The specified output format normally \"html\".\n\t\t\t * @option {Boolean} get Is true if the process is on a getContent operation.\n\t\t\t * @option {Boolean} set Is true if the process is on a setContent operation.\n\t\t\t * @option {Boolean} cleanup Is true if the process is on a cleanup operation.\n\t\t\t */\n\t\t\tonPreProcess : onPreProcess,\n\n\t\t\t/**\n\t\t\t * Fires when the Serializer does a postProcess on the contents.\n\t\t\t *\n\t\t\t * @event onPostProcess\n\t\t\t * @param {tinymce.Editor} sender Editor instance.\n\t\t\t * @param {Object} obj PreProcess object.\n\t\t\t */\n\t\t\tonPostProcess : onPostProcess,\n\n\t\t\t/**\n\t\t\t * Serializes the specified browser DOM node into a HTML string.\n\t\t\t *\n\t\t\t * @method serialize\n\t\t\t * @param {DOMNode} node DOM node to serialize.\n\t\t\t * @param {Object} args Arguments option that gets passed to event handlers.\n\t\t\t */\n\t\t\tserialize : function(node, args) {\n\t\t\t\tvar impl, doc, oldDoc, htmlSerializer, content;\n\n\t\t\t\t// Explorer won't clone contents of script and style and the\n\t\t\t\t// selected index of select elements are cleared on a clone operation.\n\t\t\t\tif (isIE && dom.select('script,style,select,map').length > 0) {\n\t\t\t\t\tcontent = node.innerHTML;\n\t\t\t\t\tnode = node.cloneNode(false);\n\t\t\t\t\tdom.setHTML(node, content);\n\t\t\t\t} else\n\t\t\t\t\tnode = node.cloneNode(true);\n\n\t\t\t\t// Nodes needs to be attached to something in WebKit/Opera\n\t\t\t\t// Older builds of Opera crashes if you attach the node to an document created dynamically\n\t\t\t\t// and since we can't feature detect a crash we need to sniff the acutal build number\n\t\t\t\t// This fix will make DOM ranges and make Sizzle happy!\n\t\t\t\timpl = node.ownerDocument.implementation;\n\t\t\t\tif (impl.createHTMLDocument) {\n\t\t\t\t\t// Create an empty HTML document\n\t\t\t\t\tdoc = impl.createHTMLDocument(\"\");\n\n\t\t\t\t\t// Add the element or it's children if it's a body element to the new document\n\t\t\t\t\teach(node.nodeName == 'BODY' ? node.childNodes : [node], function(node) {\n\t\t\t\t\t\tdoc.body.appendChild(doc.importNode(node, true));\n\t\t\t\t\t});\n\n\t\t\t\t\t// Grab first child or body element for serialization\n\t\t\t\t\tif (node.nodeName != 'BODY')\n\t\t\t\t\t\tnode = doc.body.firstChild;\n\t\t\t\t\telse\n\t\t\t\t\t\tnode = doc.body;\n\n\t\t\t\t\t// set the new document in DOMUtils so createElement etc works\n\t\t\t\t\toldDoc = dom.doc;\n\t\t\t\t\tdom.doc = doc;\n\t\t\t\t}\n\n\t\t\t\targs = args || {};\n\t\t\t\targs.format = args.format || 'html';\n\n\t\t\t\t// Pre process\n\t\t\t\tif (!args.no_events) {\n\t\t\t\t\targs.node = node;\n\t\t\t\t\tonPreProcess.dispatch(self, args);\n\t\t\t\t}\n\n\t\t\t\t// Setup serializer\n\t\t\t\thtmlSerializer = new tinymce.html.Serializer(settings, schema);\n\n\t\t\t\t// Parse and serialize HTML\n\t\t\t\targs.content = htmlSerializer.serialize(\n\t\t\t\t\thtmlParser.parse(args.getInner ? node.innerHTML : tinymce.trim(dom.getOuterHTML(node), args), args)\n\t\t\t\t);\n\n\t\t\t\t// Replace all BOM characters for now until we can find a better solution\n\t\t\t\tif (!args.cleanup)\n\t\t\t\t\targs.content = args.content.replace(/\\uFEFF|\\u200B/g, '');\n\n\t\t\t\t// Post process\n\t\t\t\tif (!args.no_events)\n\t\t\t\t\tonPostProcess.dispatch(self, args);\n\n\t\t\t\t// Restore the old document if it was changed\n\t\t\t\tif (oldDoc)\n\t\t\t\t\tdom.doc = oldDoc;\n\n\t\t\t\targs.node = null;\n\n\t\t\t\treturn args.content;\n\t\t\t},\n\n\t\t\t/**\n\t\t\t * Adds valid elements rules to the serializers schema instance this enables you to specify things\n\t\t\t * like what elements should be outputted and what attributes specific elements might have.\n\t\t\t * Consult the Wiki for more details on this format.\n\t\t\t *\n\t\t\t * @method addRules\n\t\t\t * @param {String} rules Valid elements rules string to add to schema.\n\t\t\t */\n\t\t\taddRules : function(rules) {\n\t\t\t\tschema.addValidElements(rules);\n\t\t\t},\n\n\t\t\t/**\n\t\t\t * Sets the valid elements rules to the serializers schema instance this enables you to specify things\n\t\t\t * like what elements should be outputted and what attributes specific elements might have.\n\t\t\t * Consult the Wiki for more details on this format.\n\t\t\t *\n\t\t\t * @method setRules\n\t\t\t * @param {String} rules Valid elements rules string.\n\t\t\t */\n\t\t\tsetRules : function(rules) {\n\t\t\t\tschema.setValidElements(rules);\n\t\t\t}\n\t\t};\n\t};\n})(tinymce);","Magento_Tinymce3/tiny_mce/classes/dom/DOMUtils.js":"/**\n * DOMUtils.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\t// Shorten names\n\tvar each = tinymce.each,\n\t\tis = tinymce.is,\n\t\tisWebKit = tinymce.isWebKit,\n\t\tisIE = tinymce.isIE,\n\t\tEntities = tinymce.html.Entities,\n\t\tsimpleSelectorRe = /^([a-z0-9],?)+$/i,\n\t\tblockElementsMap = tinymce.html.Schema.blockElementsMap,\n\t\twhiteSpaceRegExp = /^[ \\t\\r\\n]*$/;\n\n\t/**\n\t * Utility class for various DOM manipulation and retrival functions.\n\t *\n\t * @class tinymce.dom.DOMUtils\n\t * @example\n\t * // Add a class to an element by id in the page\n\t * tinymce.DOM.addClass('someid', 'someclass');\n\t *\n\t * // Add a class to an element by id inside the editor\n\t * tinyMCE.activeEditor.dom.addClass('someid', 'someclass');\n\t */\n\ttinymce.create('tinymce.dom.DOMUtils', {\n\t\tdoc : null,\n\t\troot : null,\n\t\tfiles : null,\n\t\tpixelStyles : /^(top|left|bottom|right|width|height|borderWidth)$/,\n\t\tprops : {\n\t\t\t\"for\" : \"htmlFor\",\n\t\t\t\"class\" : \"className\",\n\t\t\tclassName : \"className\",\n\t\t\tchecked : \"checked\",\n\t\t\tdisabled : \"disabled\",\n\t\t\tmaxlength : \"maxLength\",\n\t\t\treadonly : \"readOnly\",\n\t\t\tselected : \"selected\",\n\t\t\tvalue : \"value\",\n\t\t\tid : \"id\",\n\t\t\tname : \"name\",\n\t\t\ttype : \"type\"\n\t\t},\n\n\t\t/**\n\t\t * Constructs a new DOMUtils instance. Consult the Wiki for more details on settings etc for this class.\n\t\t *\n\t\t * @constructor\n\t\t * @method DOMUtils\n\t\t * @param {Document} d Document reference to bind the utility class to.\n\t\t * @param {settings} s Optional settings collection.\n\t\t */\n\t\tDOMUtils : function(d, s) {\n\t\t\tvar t = this, globalStyle, name;\n\n\t\t\tt.doc = d;\n\t\t\tt.win = window;\n\t\t\tt.files = {};\n\t\t\tt.cssFlicker = false;\n\t\t\tt.counter = 0;\n\t\t\tt.stdMode = !tinymce.isIE || d.documentMode >= 8;\n\t\t\tt.boxModel = !tinymce.isIE || d.compatMode == \"CSS1Compat\" || t.stdMode;\n\t\t\tt.hasOuterHTML = \"outerHTML\" in d.createElement(\"a\");\n\n\t\t\tt.settings = s = tinymce.extend({\n\t\t\t\tkeep_values : false,\n\t\t\t\thex_colors : 1\n\t\t\t}, s);\n\t\t\t\n\t\t\tt.schema = s.schema;\n\t\t\tt.styles = new tinymce.html.Styles({\n\t\t\t\turl_converter : s.url_converter,\n\t\t\t\turl_converter_scope : s.url_converter_scope\n\t\t\t}, s.schema);\n\n\t\t\t// Fix IE6SP2 flicker and check it failed for pre SP2\n\t\t\tif (tinymce.isIE6) {\n\t\t\t\ttry {\n\t\t\t\t\td.execCommand('BackgroundImageCache', false, true);\n\t\t\t\t} catch (e) {\n\t\t\t\t\tt.cssFlicker = true;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif (isIE && s.schema) {\n\t\t\t\t// Add missing HTML 4/5 elements to IE\n\t\t\t\t('abbr article aside audio canvas ' +\n\t\t\t\t'details figcaption figure footer ' +\n\t\t\t\t'header hgroup mark menu meter nav ' +\n\t\t\t\t'output progress section summary ' +\n\t\t\t\t'time video').replace(/\\w+/g, function(name) {\n\t\t\t\t\td.createElement(name);\n\t\t\t\t});\n\n\t\t\t\t// Create all custom elements\n\t\t\t\tfor (name in s.schema.getCustomElements()) {\n\t\t\t\t\td.createElement(name);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\ttinymce.addUnload(t.destroy, t);\n\t\t},\n\n\t\t/**\n\t\t * Returns the root node of the document this is normally the body but might be a DIV. Parents like getParent will not\n\t\t * go above the point of this root node.\n\t\t *\n\t\t * @method getRoot\n\t\t * @return {Element} Root element for the utility class.\n\t\t */\n\t\tgetRoot : function() {\n\t\t\tvar t = this, s = t.settings;\n\n\t\t\treturn (s && t.get(s.root_element)) || t.doc.body;\n\t\t},\n\n\t\t/**\n\t\t * Returns the viewport of the window.\n\t\t *\n\t\t * @method getViewPort\n\t\t * @param {Window} w Optional window to get viewport of.\n\t\t * @return {Object} Viewport object with fields x, y, w and h.\n\t\t */\n\t\tgetViewPort : function(w) {\n\t\t\tvar d, b;\n\n\t\t\tw = !w ? this.win : w;\n\t\t\td = w.document;\n\t\t\tb = this.boxModel ? d.documentElement : d.body;\n\n\t\t\t// Returns viewport size excluding scrollbars\n\t\t\treturn {\n\t\t\t\tx : w.pageXOffset || b.scrollLeft,\n\t\t\t\ty : w.pageYOffset || b.scrollTop,\n\t\t\t\tw : w.innerWidth || b.clientWidth,\n\t\t\t\th : w.innerHeight || b.clientHeight\n\t\t\t};\n\t\t},\n\n\t\t/**\n\t\t * Returns the rectangle for a specific element.\n\t\t *\n\t\t * @method getRect\n\t\t * @param {Element/String} e Element object or element ID to get rectange from.\n\t\t * @return {object} Rectange for specified element object with x, y, w, h fields.\n\t\t */\n\t\tgetRect : function(e) {\n\t\t\tvar p, t = this, sr;\n\n\t\t\te = t.get(e);\n\t\t\tp = t.getPos(e);\n\t\t\tsr = t.getSize(e);\n\n\t\t\treturn {\n\t\t\t\tx : p.x,\n\t\t\t\ty : p.y,\n\t\t\t\tw : sr.w,\n\t\t\t\th : sr.h\n\t\t\t};\n\t\t},\n\n\t\t/**\n\t\t * Returns the size dimensions of the specified element.\n\t\t *\n\t\t * @method getSize\n\t\t * @param {Element/String} e Element object or element ID to get rectange from.\n\t\t * @return {object} Rectange for specified element object with w, h fields.\n\t\t */\n\t\tgetSize : function(e) {\n\t\t\tvar t = this, w, h;\n\n\t\t\te = t.get(e);\n\t\t\tw = t.getStyle(e, 'width');\n\t\t\th = t.getStyle(e, 'height');\n\n\t\t\t// Non pixel value, then force offset/clientWidth\n\t\t\tif (w.indexOf('px') === -1)\n\t\t\t\tw = 0;\n\n\t\t\t// Non pixel value, then force offset/clientWidth\n\t\t\tif (h.indexOf('px') === -1)\n\t\t\t\th = 0;\n\n\t\t\treturn {\n\t\t\t\tw : parseInt(w) || e.offsetWidth || e.clientWidth,\n\t\t\t\th : parseInt(h) || e.offsetHeight || e.clientHeight\n\t\t\t};\n\t\t},\n\n\t\t/**\n\t\t * Returns a node by the specified selector function. This function will\n\t\t * loop through all parent nodes and call the specified function for each node.\n\t\t * If the function then returns true indicating that it has found what it was looking for, the loop execution will then end\n\t\t * and the node it found will be returned.\n\t\t *\n\t\t * @method getParent\n\t\t * @param {Node/String} n DOM node to search parents on or ID string.\n\t\t * @param {function} f Selection function to execute on each node or CSS pattern.\n\t\t * @param {Node} r Optional root element, never go below this point.\n\t\t * @return {Node} DOM Node or null if it wasn't found.\n\t\t */\n\t\tgetParent : function(n, f, r) {\n\t\t\treturn this.getParents(n, f, r, false);\n\t\t},\n\n\t\t/**\n\t\t * Returns a node list of all parents matching the specified selector function or pattern.\n\t\t * If the function then returns true indicating that it has found what it was looking for and that node will be collected.\n\t\t *\n\t\t * @method getParents\n\t\t * @param {Node/String} n DOM node to search parents on or ID string.\n\t\t * @param {function} f Selection function to execute on each node or CSS pattern.\n\t\t * @param {Node} r Optional root element, never go below this point.\n\t\t * @return {Array} Array of nodes or null if it wasn't found.\n\t\t */\n\t\tgetParents : function(n, f, r, c) {\n\t\t\tvar t = this, na, se = t.settings, o = [];\n\n\t\t\tn = t.get(n);\n\t\t\tc = c === undefined;\n\n\t\t\tif (se.strict_root)\n\t\t\t\tr = r || t.getRoot();\n\n\t\t\t// Wrap node name as func\n\t\t\tif (is(f, 'string')) {\n\t\t\t\tna = f;\n\n\t\t\t\tif (f === '*') {\n\t\t\t\t\tf = function(n) {return n.nodeType == 1;};\n\t\t\t\t} else {\n\t\t\t\t\tf = function(n) {\n\t\t\t\t\t\treturn t.is(n, na);\n\t\t\t\t\t};\n\t\t\t\t}\n\t\t\t}\n\n\t\t\twhile (n) {\n\t\t\t\tif (n == r || !n.nodeType || n.nodeType === 9)\n\t\t\t\t\tbreak;\n\n\t\t\t\tif (!f || f(n)) {\n\t\t\t\t\tif (c)\n\t\t\t\t\t\to.push(n);\n\t\t\t\t\telse\n\t\t\t\t\t\treturn n;\n\t\t\t\t}\n\n\t\t\t\tn = n.parentNode;\n\t\t\t}\n\n\t\t\treturn c ? o : null;\n\t\t},\n\n\t\t/**\n\t\t * Returns the specified element by ID or the input element if it isn't a string.\n\t\t *\n\t\t * @method get\n\t\t * @param {String/Element} n Element id to look for or element to just pass though.\n\t\t * @return {Element} Element matching the specified id or null if it wasn't found.\n\t\t */\n\t\tget : function(e) {\n\t\t\tvar n;\n\n\t\t\tif (e && this.doc && typeof(e) == 'string') {\n\t\t\t\tn = e;\n\t\t\t\te = this.doc.getElementById(e);\n\n\t\t\t\t// IE and Opera returns meta elements when they match the specified input ID, but getElementsByName seems to do the trick\n\t\t\t\tif (e && e.id !== n)\n\t\t\t\t\treturn this.doc.getElementsByName(n)[1];\n\t\t\t}\n\n\t\t\treturn e;\n\t\t},\n\n\t\t/**\n\t\t * Returns the next node that matches selector or function\n\t\t *\n\t\t * @method getNext\n\t\t * @param {Node} node Node to find siblings from.\n\t\t * @param {String/function} selector Selector CSS expression or function.\n\t\t * @return {Node} Next node item matching the selector or null if it wasn't found.\n\t\t */\n\t\tgetNext : function(node, selector) {\n\t\t\treturn this._findSib(node, selector, 'nextSibling');\n\t\t},\n\n\t\t/**\n\t\t * Returns the previous node that matches selector or function\n\t\t *\n\t\t * @method getPrev\n\t\t * @param {Node} node Node to find siblings from.\n\t\t * @param {String/function} selector Selector CSS expression or function.\n\t\t * @return {Node} Previous node item matching the selector or null if it wasn't found.\n\t\t */\n\t\tgetPrev : function(node, selector) {\n\t\t\treturn this._findSib(node, selector, 'previousSibling');\n\t\t},\n\n\t\t// #ifndef jquery\n\n\t\t/**\n\t\t * Selects specific elements by a CSS level 3 pattern. For example \"div#a1 p.test\".\n\t\t * This function is optimized for the most common patterns needed in TinyMCE but it also performes good enough\n\t\t * on more complex patterns.\n\t\t *\n\t\t * @method select\n\t\t * @param {String} p CSS level 1 pattern to select/find elements by.\n\t\t * @param {Object} s Optional root element/scope element to search in.\n\t\t * @return {Array} Array with all matched elements.\n\t\t * @example\n\t\t * // Adds a class to all paragraphs in the currently active editor\n\t\t * tinyMCE.activeEditor.dom.addClass(tinyMCE.activeEditor.dom.select('p'), 'someclass');\n\t\t * \n\t\t * // Adds a class to all spans that has the test class in the currently active editor\n\t\t * tinyMCE.activeEditor.dom.addClass(tinyMCE.activeEditor.dom.select('span.test'), 'someclass')\n\t\t */\n\t\tselect : function(pa, s) {\n\t\t\tvar t = this;\n\n\t\t\treturn tinymce.dom.Sizzle(pa, t.get(s) || t.get(t.settings.root_element) || t.doc, []);\n\t\t},\n\n\t\t/**\n\t\t * Returns true/false if the specified element matches the specified css pattern.\n\t\t *\n\t\t * @method is\n\t\t * @param {Node/NodeList} n DOM node to match or an array of nodes to match.\n\t\t * @param {String} selector CSS pattern to match the element agains.\n\t\t */\n\t\tis : function(n, selector) {\n\t\t\tvar i;\n\n\t\t\t// If it isn't an array then try to do some simple selectors instead of Sizzle for to boost performance\n\t\t\tif (n.length === undefined) {\n\t\t\t\t// Simple all selector\n\t\t\t\tif (selector === '*')\n\t\t\t\t\treturn n.nodeType == 1;\n\n\t\t\t\t// Simple selector just elements\n\t\t\t\tif (simpleSelectorRe.test(selector)) {\n\t\t\t\t\tselector = selector.toLowerCase().split(/,/);\n\t\t\t\t\tn = n.nodeName.toLowerCase();\n\n\t\t\t\t\tfor (i = selector.length - 1; i >= 0; i--) {\n\t\t\t\t\t\tif (selector[i] == n)\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t}\n\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn tinymce.dom.Sizzle.matches(selector, n.nodeType ? [n] : n).length > 0;\n\t\t},\n\n\t\t// #endif\n\n\t\t/**\n\t\t * Adds the specified element to another element or elements.\n\t\t *\n\t\t * @method add\n\t\t * @param {String/Element/Array} Element id string, DOM node element or array of id's or elements to add to.\n\t\t * @param {String/Element} n Name of new element to add or existing element to add.\n\t\t * @param {Object} a Optional object collection with arguments to add to the new element(s).\n\t\t * @param {String} h Optional inner HTML contents to add for each element.\n\t\t * @param {Boolean} c Optional internal state to indicate if it should create or add.\n\t\t * @return {Element/Array} Element that got created or array with elements if multiple elements where passed.\n\t\t * @example\n\t\t * // Adds a new paragraph to the end of the active editor\n\t\t * tinyMCE.activeEditor.dom.add(tinyMCE.activeEditor.getBody(), 'p', {title : 'my title'}, 'Some content');\n\t\t */\n\t\tadd : function(p, n, a, h, c) {\n\t\t\tvar t = this;\n\n\t\t\treturn this.run(p, function(p) {\n\t\t\t\tvar e, k;\n\n\t\t\t\te = is(n, 'string') ? t.doc.createElement(n) : n;\n\t\t\t\tt.setAttribs(e, a);\n\n\t\t\t\tif (h) {\n\t\t\t\t\tif (h.nodeType)\n\t\t\t\t\t\te.appendChild(h);\n\t\t\t\t\telse\n\t\t\t\t\t\tt.setHTML(e, h);\n\t\t\t\t}\n\n\t\t\t\treturn !c ? p.appendChild(e) : e;\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Creates a new element.\n\t\t *\n\t\t * @method create\n\t\t * @param {String} n Name of new element.\n\t\t * @param {Object} a Optional object name/value collection with element attributes.\n\t\t * @param {String} h Optional HTML string to set as inner HTML of the element.\n\t\t * @return {Element} HTML DOM node element that got created.\n\t\t * @example\n\t\t * // Adds an element where the caret/selection is in the active editor\n\t\t * var el = tinyMCE.activeEditor.dom.create('div', {id : 'test', 'class' : 'myclass'}, 'some content');\n\t\t * tinyMCE.activeEditor.selection.setNode(el);\n\t\t */\n\t\tcreate : function(n, a, h) {\n\t\t\treturn this.add(this.doc.createElement(n), n, a, h, 1);\n\t\t},\n\n\t\t/**\n\t\t * Create HTML string for element. The element will be closed unless an empty inner HTML string is passed.\n\t\t *\n\t\t * @method createHTML\n\t\t * @param {String} n Name of new element.\n\t\t * @param {Object} a Optional object name/value collection with element attributes.\n\t\t * @param {String} h Optional HTML string to set as inner HTML of the element.\n\t\t * @return {String} String with new HTML element like for example: <a href=\"#\">test</a>.\n\t\t * @example\n\t\t * // Creates a html chunk and inserts it at the current selection/caret location\n\t\t * tinyMCE.activeEditor.selection.setContent(tinyMCE.activeEditor.dom.createHTML('a', {href : 'test.html'}, 'some line'));\n\t\t */\n\t\tcreateHTML : function(n, a, h) {\n\t\t\tvar o = '', t = this, k;\n\n\t\t\to += '<' + n;\n\n\t\t\tfor (k in a) {\n\t\t\t\tif (a.hasOwnProperty(k))\n\t\t\t\t\to += ' ' + k + '=\"' + t.encode(a[k]) + '\"';\n\t\t\t}\n\n\t\t\t// A call to tinymce.is doesn't work for some odd reason on IE9 possible bug inside their JS runtime\n\t\t\tif (typeof(h) != \"undefined\")\n\t\t\t\treturn o + '>' + h + '</' + n + '>';\n\n\t\t\treturn o + ' />';\n\t\t},\n\n\t\t/**\n\t\t * Removes/deletes the specified element(s) from the DOM.\n\t\t *\n\t\t * @method remove\n\t\t * @param {String/Element/Array} node ID of element or DOM element object or array containing multiple elements/ids.\n\t\t * @param {Boolean} keep_children Optional state to keep children or not. If set to true all children will be placed at the location of the removed element.\n\t\t * @return {Element/Array} HTML DOM element that got removed or array of elements depending on input.\n\t\t * @example\n\t\t * // Removes all paragraphs in the active editor\n\t\t * tinyMCE.activeEditor.dom.remove(tinyMCE.activeEditor.dom.select('p'));\n\t\t * \n\t\t * // Removes a element by id in the document\n\t\t * tinyMCE.DOM.remove('mydiv');\n\t\t */\n\t\tremove : function(node, keep_children) {\n\t\t\treturn this.run(node, function(node) {\n\t\t\t\tvar child, parent = node.parentNode;\n\n\t\t\t\tif (!parent)\n\t\t\t\t\treturn null;\n\n\t\t\t\tif (keep_children) {\n\t\t\t\t\twhile (child = node.firstChild) {\n\t\t\t\t\t\t// IE 8 will crash if you don't remove completely empty text nodes\n\t\t\t\t\t\tif (!tinymce.isIE || child.nodeType !== 3 || child.nodeValue)\n\t\t\t\t\t\t\tparent.insertBefore(child, node);\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tnode.removeChild(child);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\treturn parent.removeChild(node);\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Sets the CSS style value on a HTML element. The name can be a camelcase string\n\t\t * or the CSS style name like background-color.\n\t\t *\n\t\t * @method setStyle\n\t\t * @param {String/Element/Array} n HTML element/Element ID or Array of elements/ids to set CSS style value on.\n\t\t * @param {String} na Name of the style value to set.\n\t\t * @param {String} v Value to set on the style.\n\t\t * @example\n\t\t * // Sets a style value on all paragraphs in the currently active editor\n\t\t * tinyMCE.activeEditor.dom.setStyle(tinyMCE.activeEditor.dom.select('p'), 'background-color', 'red');\n\t\t * \n\t\t * // Sets a style value to an element by id in the current document\n\t\t * tinyMCE.DOM.setStyle('mydiv', 'background-color', 'red');\n\t\t */\n\t\tsetStyle : function(n, na, v) {\n\t\t\tvar t = this;\n\n\t\t\treturn t.run(n, function(e) {\n\t\t\t\tvar s, i;\n\n\t\t\t\ts = e.style;\n\n\t\t\t\t// Camelcase it, if needed\n\t\t\t\tna = na.replace(/-(\\D)/g, function(a, b){\n\t\t\t\t\treturn b.toUpperCase();\n\t\t\t\t});\n\n\t\t\t\t// Default px suffix on these\n\t\t\t\tif (t.pixelStyles.test(na) && (tinymce.is(v, 'number') || /^[\\-0-9\\.]+$/.test(v)))\n\t\t\t\t\tv += 'px';\n\n\t\t\t\tswitch (na) {\n\t\t\t\t\tcase 'opacity':\n\t\t\t\t\t\t// IE specific opacity\n\t\t\t\t\t\tif (isIE) {\n\t\t\t\t\t\t\ts.filter = v === '' ? '' : \"alpha(opacity=\" + (v * 100) + \")\";\n\n\t\t\t\t\t\t\tif (!n.currentStyle || !n.currentStyle.hasLayout)\n\t\t\t\t\t\t\t\ts.display = 'inline-block';\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Fix for older browsers\n\t\t\t\t\t\ts[na] = s['-moz-opacity'] = s['-khtml-opacity'] = v || '';\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'float':\n\t\t\t\t\t\tisIE ? s.styleFloat = v : s.cssFloat = v;\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t\n\t\t\t\t\tdefault:\n\t\t\t\t\t\ts[na] = v || '';\n\t\t\t\t}\n\n\t\t\t\t// Force update of the style data\n\t\t\t\tif (t.settings.update_styles)\n\t\t\t\t\tt.setAttrib(e, 'data-mce-style');\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Returns the current style or runtime/computed value of a element.\n\t\t *\n\t\t * @method getStyle\n\t\t * @param {String/Element} n HTML element or element id string to get style from.\n\t\t * @param {String} na Style name to return.\n\t\t * @param {Boolean} c Computed style.\n\t\t * @return {String} Current style or computed style value of a element.\n\t\t */\n\t\tgetStyle : function(n, na, c) {\n\t\t\tn = this.get(n);\n\n\t\t\tif (!n)\n\t\t\t\treturn;\n\n\t\t\t// Gecko\n\t\t\tif (this.doc.defaultView && c) {\n\t\t\t\t// Remove camelcase\n\t\t\t\tna = na.replace(/[A-Z]/g, function(a){\n\t\t\t\t\treturn '-' + a;\n\t\t\t\t});\n\n\t\t\t\ttry {\n\t\t\t\t\treturn this.doc.defaultView.getComputedStyle(n, null).getPropertyValue(na);\n\t\t\t\t} catch (ex) {\n\t\t\t\t\t// Old safari might fail\n\t\t\t\t\treturn null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Camelcase it, if needed\n\t\t\tna = na.replace(/-(\\D)/g, function(a, b){\n\t\t\t\treturn b.toUpperCase();\n\t\t\t});\n\n\t\t\tif (na == 'float')\n\t\t\t\tna = isIE ? 'styleFloat' : 'cssFloat';\n\n\t\t\t// IE & Opera\n\t\t\tif (n.currentStyle && c)\n\t\t\t\treturn n.currentStyle[na];\n\n\t\t\treturn n.style ? n.style[na] : undefined;\n\t\t},\n\n\t\t/**\n\t\t * Sets multiple styles on the specified element(s).\n\t\t *\n\t\t * @method setStyles\n\t\t * @param {Element/String/Array} e DOM element, element id string or array of elements/ids to set styles on.\n\t\t * @param {Object} o Name/Value collection of style items to add to the element(s).\n\t\t * @example\n\t\t * // Sets styles on all paragraphs in the currently active editor\n\t\t * tinyMCE.activeEditor.dom.setStyles(tinyMCE.activeEditor.dom.select('p'), {'background-color' : 'red', 'color' : 'green'});\n\t\t * \n\t\t * // Sets styles to an element by id in the current document\n\t\t * tinyMCE.DOM.setStyles('mydiv', {'background-color' : 'red', 'color' : 'green'});\n\t\t */\n\t\tsetStyles : function(e, o) {\n\t\t\tvar t = this, s = t.settings, ol;\n\n\t\t\tol = s.update_styles;\n\t\t\ts.update_styles = 0;\n\n\t\t\teach(o, function(v, n) {\n\t\t\t\tt.setStyle(e, n, v);\n\t\t\t});\n\n\t\t\t// Update style info\n\t\t\ts.update_styles = ol;\n\t\t\tif (s.update_styles)\n\t\t\t\tt.setAttrib(e, s.cssText);\n\t\t},\n\n\t\t/**\n\t\t * Removes all attributes from an element or elements.\n\t\t * \n\t\t * @param {Element/String/Array} e DOM element, element id string or array of elements/ids to remove attributes from.\n\t\t */\n\t\tremoveAllAttribs: function(e) {\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\tvar i, attrs = e.attributes;\n\t\t\t\tfor (i = attrs.length - 1; i >= 0; i--) {\n\t\t\t\t\te.removeAttributeNode(attrs.item(i));\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Sets the specified attributes value of a element or elements.\n\t\t *\n\t\t * @method setAttrib\n\t\t * @param {Element/String/Array} e DOM element, element id string or array of elements/ids to set attribute on.\n\t\t * @param {String} n Name of attribute to set.\n\t\t * @param {String} v Value to set on the attribute of this value is falsy like null 0 or '' it will remove the attribute instead.\n\t\t * @example\n\t\t * // Sets an attribute to all paragraphs in the active editor\n\t\t * tinyMCE.activeEditor.dom.setAttrib(tinyMCE.activeEditor.dom.select('p'), 'class', 'myclass');\n\t\t * \n\t\t * // Sets an attribute to a specific element in the current page\n\t\t * tinyMCE.dom.setAttrib('mydiv', 'class', 'myclass');\n\t\t */\n\t\tsetAttrib : function(e, n, v) {\n\t\t\tvar t = this;\n\n\t\t\t// Whats the point\n\t\t\tif (!e || !n)\n\t\t\t\treturn;\n\n\t\t\t// Strict XML mode\n\t\t\tif (t.settings.strict)\n\t\t\t\tn = n.toLowerCase();\n\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\tvar s = t.settings;\n\t\t\t\tif (v !== null) {\n\t\t\t\t\tswitch (n) {\n\t\t\t\t\t\tcase \"style\":\n\t\t\t\t\t\t\tif (!is(v, 'string')) {\n\t\t\t\t\t\t\t\teach(v, function(v, n) {\n\t\t\t\t\t\t\t\t\tt.setStyle(e, n, v);\n\t\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// No mce_style for elements with these since they might get resized by the user\n\t\t\t\t\t\t\tif (s.keep_values) {\n\t\t\t\t\t\t\t\tif (v && !t._isRes(v))\n\t\t\t\t\t\t\t\t\te.setAttribute('data-mce-style', v, 2);\n\t\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\t\te.removeAttribute('data-mce-style', 2);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\te.style.cssText = v;\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase \"class\":\n\t\t\t\t\t\t\te.className = v || ''; // Fix IE null bug\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase \"src\":\n\t\t\t\t\t\tcase \"href\":\n\t\t\t\t\t\t\tif (s.keep_values) {\n\t\t\t\t\t\t\t\tif (s.url_converter)\n\t\t\t\t\t\t\t\t\tv = s.url_converter.call(s.url_converter_scope || t, v, n, e);\n\n\t\t\t\t\t\t\t\tt.setAttrib(e, 'data-mce-' + n, v, 2);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\tcase \"shape\":\n\t\t\t\t\t\t\te.setAttribute('data-mce-style', v);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif (is(v) && v !== null && v.length !== 0)\n\t\t\t\t\te.setAttribute(n, '' + v, 2);\n\t\t\t\telse\n\t\t\t\t\te.removeAttribute(n, 2);\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Sets the specified attributes of a element or elements.\n\t\t *\n\t\t * @method setAttribs\n\t\t * @param {Element/String/Array} e DOM element, element id string or array of elements/ids to set attributes on.\n\t\t * @param {Object} o Name/Value collection of attribute items to add to the element(s).\n\t\t * @example\n\t\t * // Sets some attributes to all paragraphs in the active editor\n\t\t * tinyMCE.activeEditor.dom.setAttribs(tinyMCE.activeEditor.dom.select('p'), {'class' : 'myclass', title : 'some title'});\n\t\t * \n\t\t * // Sets some attributes to a specific element in the current page\n\t\t * tinyMCE.DOM.setAttribs('mydiv', {'class' : 'myclass', title : 'some title'});\n\t\t */\n\t\tsetAttribs : function(e, o) {\n\t\t\tvar t = this;\n\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\teach(o, function(v, n) {\n\t\t\t\t\tt.setAttrib(e, n, v);\n\t\t\t\t});\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Returns the specified attribute by name.\n\t\t *\n\t\t * @method getAttrib\n\t\t * @param {String/Element} e Element string id or DOM element to get attribute from.\n\t\t * @param {String} n Name of attribute to get.\n\t\t * @param {String} dv Optional default value to return if the attribute didn't exist.\n\t\t * @return {String} Attribute value string, default value or null if the attribute wasn't found.\n\t\t */\n\t\tgetAttrib : function(e, n, dv) {\n\t\t\tvar v, t = this, undef;\n\n\t\t\te = t.get(e);\n\n\t\t\tif (!e || e.nodeType !== 1)\n\t\t\t\treturn dv === undef ? false : dv;\n\n\t\t\tif (!is(dv))\n\t\t\t\tdv = '';\n\n\t\t\t// Try the mce variant for these\n\t\t\tif (/^(src|href|style|coords|shape)$/.test(n)) {\n\t\t\t\tv = e.getAttribute(\"data-mce-\" + n);\n\n\t\t\t\tif (v)\n\t\t\t\t\treturn v;\n\t\t\t}\n\n\t\t\tif (isIE && t.props[n]) {\n\t\t\t\tv = e[t.props[n]];\n\t\t\t\tv = v && v.nodeValue ? v.nodeValue : v;\n\t\t\t}\n\n\t\t\tif (!v)\n\t\t\t\tv = e.getAttribute(n, 2);\n\n\t\t\t// Check boolean attribs\n\t\t\tif (/^(checked|compact|declare|defer|disabled|ismap|multiple|nohref|noshade|nowrap|readonly|selected)$/.test(n)) {\n\t\t\t\tif (e[t.props[n]] === true && v === '')\n\t\t\t\t\treturn n;\n\n\t\t\t\treturn v ? n : '';\n\t\t\t}\n\n\t\t\t// Inner input elements will override attributes on form elements\n\t\t\tif (e.nodeName === \"FORM\" && e.getAttributeNode(n))\n\t\t\t\treturn e.getAttributeNode(n).nodeValue;\n\n\t\t\tif (n === 'style') {\n\t\t\t\tv = v || e.style.cssText;\n\n\t\t\t\tif (v) {\n\t\t\t\t\tv = t.serializeStyle(t.parseStyle(v), e.nodeName);\n\n\t\t\t\t\tif (t.settings.keep_values && !t._isRes(v))\n\t\t\t\t\t\te.setAttribute('data-mce-style', v);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Remove Apple and WebKit stuff\n\t\t\tif (isWebKit && n === \"class\" && v)\n\t\t\t\tv = v.replace(/(apple|webkit)\\-[a-z\\-]+/gi, '');\n\n\t\t\t// Handle IE issues\n\t\t\tif (isIE) {\n\t\t\t\tswitch (n) {\n\t\t\t\t\tcase 'rowspan':\n\t\t\t\t\tcase 'colspan':\n\t\t\t\t\t\t// IE returns 1 as default value\n\t\t\t\t\t\tif (v === 1)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'size':\n\t\t\t\t\t\t// IE returns +0 as default value for size\n\t\t\t\t\t\tif (v === '+0' || v === 20 || v === 0)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'width':\n\t\t\t\t\tcase 'height':\n\t\t\t\t\tcase 'vspace':\n\t\t\t\t\tcase 'checked':\n\t\t\t\t\tcase 'disabled':\n\t\t\t\t\tcase 'readonly':\n\t\t\t\t\t\tif (v === 0)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'hspace':\n\t\t\t\t\t\t// IE returns -1 as default value\n\t\t\t\t\t\tif (v === -1)\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'maxlength':\n\t\t\t\t\tcase 'tabindex':\n\t\t\t\t\t\t// IE returns default value\n\t\t\t\t\t\tif (v === 32768 || v === 2147483647 || v === '32768')\n\t\t\t\t\t\t\tv = '';\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase 'multiple':\n\t\t\t\t\tcase 'compact':\n\t\t\t\t\tcase 'noshade':\n\t\t\t\t\tcase 'nowrap':\n\t\t\t\t\t\tif (v === 65535)\n\t\t\t\t\t\t\treturn n;\n\n\t\t\t\t\t\treturn dv;\n\n\t\t\t\t\tcase 'shape':\n\t\t\t\t\t\tv = v.toLowerCase();\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tdefault:\n\t\t\t\t\t\t// IE has odd anonymous function for event attributes\n\t\t\t\t\t\tif (n.indexOf('on') === 0 && v)\n\t\t\t\t\t\t\tv = tinymce._replace(/^function\\s+\\w+\\(\\)\\s+\\{\\s+(.*)\\s+\\}$/, '$1', '' + v);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn (v !== undef && v !== null && v !== '') ? '' + v : dv;\n\t\t},\n\n\t\t/**\n\t\t * Returns the absolute x, y position of a node. The position will be returned in a object with x, y fields.\n\t\t *\n\t\t * @method getPos\n\t\t * @param {Element/String} n HTML element or element id to get x, y position from.\n\t\t * @param {Element} ro Optional root element to stop calculations at.\n\t\t * @return {object} Absolute position of the specified element object with x, y fields.\n\t\t */\n\t\tgetPos : function(n, ro) {\n\t\t\tvar t = this, x = 0, y = 0, e, d = t.doc, r;\n\n\t\t\tn = t.get(n);\n\t\t\tro = ro || d.body;\n\n\t\t\tif (n) {\n\t\t\t\t// Use getBoundingClientRect if it exists since it's faster than looping offset nodes\n\t\t\t\tif (n.getBoundingClientRect) {\n\t\t\t\t\tn = n.getBoundingClientRect();\n\t\t\t\t\te = t.boxModel ? d.documentElement : d.body;\n\n\t\t\t\t\t// Add scroll offsets from documentElement or body since IE with the wrong box model will use d.body and so do WebKit\n\t\t\t\t\t// Also remove the body/documentelement clientTop/clientLeft on IE 6, 7 since they offset the position\n\t\t\t\t\tx = n.left + (d.documentElement.scrollLeft || d.body.scrollLeft) - e.clientTop;\n\t\t\t\t\ty = n.top + (d.documentElement.scrollTop || d.body.scrollTop) - e.clientLeft;\n\n\t\t\t\t\treturn {x : x, y : y};\n\t\t\t\t}\n\n\t\t\t\tr = n;\n\t\t\t\twhile (r && r != ro && r.nodeType) {\n\t\t\t\t\tx += r.offsetLeft || 0;\n\t\t\t\t\ty += r.offsetTop || 0;\n\t\t\t\t\tr = r.offsetParent;\n\t\t\t\t}\n\n\t\t\t\tr = n.parentNode;\n\t\t\t\twhile (r && r != ro && r.nodeType) {\n\t\t\t\t\tx -= r.scrollLeft || 0;\n\t\t\t\t\ty -= r.scrollTop || 0;\n\t\t\t\t\tr = r.parentNode;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn {x : x, y : y};\n\t\t},\n\n\t\t/**\n\t\t * Parses the specified style value into an object collection. This parser will also\n\t\t * merge and remove any redundant items that browsers might have added. It will also convert non hex\n\t\t * colors to hex values. Urls inside the styles will also be converted to absolute/relative based on settings.\n\t\t *\n\t\t * @method parseStyle\n\t\t * @param {String} st Style value to parse for example: border:1px solid red;.\n\t\t * @return {Object} Object representation of that style like {border : '1px solid red'}\n\t\t */\n\t\tparseStyle : function(st) {\n\t\t\treturn this.styles.parse(st);\n\t\t},\n\n\t\t/**\n\t\t * Serializes the specified style object into a string.\n\t\t *\n\t\t * @method serializeStyle\n\t\t * @param {Object} o Object to serialize as string for example: {border : '1px solid red'}\n\t\t * @param {String} name Optional element name.\n\t\t * @return {String} String representation of the style object for example: border: 1px solid red.\n\t\t */\n\t\tserializeStyle : function(o, name) {\n\t\t\treturn this.styles.serialize(o, name);\n\t\t},\n\n\t\t/**\n\t\t * Imports/loads the specified CSS file into the document bound to the class.\n\t\t *\n\t\t * @method loadCSS\n\t\t * @param {String} u URL to CSS file to load.\n\t\t * @example\n\t\t * // Loads a CSS file dynamically into the current document\n\t\t * tinymce.DOM.loadCSS('somepath/some.css');\n\t\t * \n\t\t * // Loads a CSS file into the currently active editor instance\n\t\t * tinyMCE.activeEditor.dom.loadCSS('somepath/some.css');\n\t\t * \n\t\t * // Loads a CSS file into an editor instance by id\n\t\t * tinyMCE.get('someid').dom.loadCSS('somepath/some.css');\n\t\t * \n\t\t * // Loads multiple CSS files into the current document\n\t\t * tinymce.DOM.loadCSS('somepath/some.css,somepath/someother.css');\n\t\t */\n\t\tloadCSS : function(u) {\n\t\t\tvar t = this, d = t.doc, head;\n\n\t\t\tif (!u)\n\t\t\t\tu = '';\n\n\t\t\thead = t.select('head')[0];\n\n\t\t\teach(u.split(','), function(u) {\n\t\t\t\tvar link;\n\n\t\t\t\tif (t.files[u])\n\t\t\t\t\treturn;\n\n\t\t\t\tt.files[u] = true;\n\t\t\t\tlink = t.create('link', {rel : 'stylesheet', href : tinymce._addVer(u)});\n\n\t\t\t\t// IE 8 has a bug where dynamically loading stylesheets would produce a 1 item remaining bug\n\t\t\t\t// This fix seems to resolve that issue by realcing the document ones a stylesheet finishes loading\n\t\t\t\t// It's ugly but it seems to work fine.\n\t\t\t\tif (isIE && d.documentMode && d.recalc) {\n\t\t\t\t\tlink.onload = function() {\n\t\t\t\t\t\tif (d.recalc)\n\t\t\t\t\t\t\td.recalc();\n\n\t\t\t\t\t\tlink.onload = null;\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\thead.appendChild(link);\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Adds a class to the specified element or elements.\n\t\t *\n\t\t * @method addClass\n\t\t * @param {String/Element/Array} Element ID string or DOM element or array with elements or IDs.\n\t\t * @param {String} c Class name to add to each element.\n\t\t * @return {String/Array} String with new class value or array with new class values for all elements.\n\t\t * @example\n\t\t * // Adds a class to all paragraphs in the active editor\n\t\t * tinyMCE.activeEditor.dom.addClass(tinyMCE.activeEditor.dom.select('p'), 'myclass');\n\t\t * \n\t\t * // Adds a class to a specific element in the current page\n\t\t * tinyMCE.DOM.addClass('mydiv', 'myclass');\n\t\t */\n\t\taddClass : function(e, c) {\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\tvar o;\n\n\t\t\t\tif (!c)\n\t\t\t\t\treturn 0;\n\n\t\t\t\tif (this.hasClass(e, c))\n\t\t\t\t\treturn e.className;\n\n\t\t\t\to = this.removeClass(e, c);\n\n\t\t\t\treturn e.className = (o != '' ? (o + ' ') : '') + c;\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Removes a class from the specified element or elements.\n\t\t *\n\t\t * @method removeClass\n\t\t * @param {String/Element/Array} Element ID string or DOM element or array with elements or IDs.\n\t\t * @param {String} c Class name to remove to each element.\n\t\t * @return {String/Array} String with new class value or array with new class values for all elements.\n\t\t * @example\n\t\t * // Removes a class from all paragraphs in the active editor\n\t\t * tinyMCE.activeEditor.dom.removeClass(tinyMCE.activeEditor.dom.select('p'), 'myclass');\n\t\t * \n\t\t * // Removes a class from a specific element in the current page\n\t\t * tinyMCE.DOM.removeClass('mydiv', 'myclass');\n\t\t */\n\t\tremoveClass : function(e, c) {\n\t\t\tvar t = this, re;\n\n\t\t\treturn t.run(e, function(e) {\n\t\t\t\tvar v;\n\n\t\t\t\tif (t.hasClass(e, c)) {\n\t\t\t\t\tif (!re)\n\t\t\t\t\t\tre = new RegExp(\"(^|\\\\s+)\" + c + \"(\\\\s+|$)\", \"g\");\n\n\t\t\t\t\tv = e.className.replace(re, ' ');\n\t\t\t\t\tv = tinymce.trim(v != ' ' ? v : '');\n\n\t\t\t\t\te.className = v;\n\n\t\t\t\t\t// Empty class attr\n\t\t\t\t\tif (!v) {\n\t\t\t\t\t\te.removeAttribute('class');\n\t\t\t\t\t\te.removeAttribute('className');\n\t\t\t\t\t}\n\n\t\t\t\t\treturn v;\n\t\t\t\t}\n\n\t\t\t\treturn e.className;\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Returns true if the specified element has the specified class.\n\t\t *\n\t\t * @method hasClass\n\t\t * @param {String/Element} n HTML element or element id string to check CSS class on.\n\t\t * @param {String} c CSS class to check for.\n\t\t * @return {Boolean} true/false if the specified element has the specified class.\n\t\t */\n\t\thasClass : function(n, c) {\n\t\t\tn = this.get(n);\n\n\t\t\tif (!n || !c)\n\t\t\t\treturn false;\n\n\t\t\treturn (' ' + n.className + ' ').indexOf(' ' + c + ' ') !== -1;\n\t\t},\n\n\t\t/**\n\t\t * Shows the specified element(s) by ID by setting the \"display\" style.\n\t\t *\n\t\t * @method show\n\t\t * @param {String/Element/Array} e ID of DOM element or DOM element or array with elements or IDs to show.\n\t\t */\n\t\tshow : function(e) {\n\t\t\treturn this.setStyle(e, 'display', 'block');\n\t\t},\n\n\t\t/**\n\t\t * Hides the specified element(s) by ID by setting the \"display\" style.\n\t\t *\n\t\t * @method hide\n\t\t * @param {String/Element/Array} e ID of DOM element or DOM element or array with elements or IDs to hide.\n\t\t * @example\n\t\t * // Hides a element by id in the document\n\t\t * tinymce.DOM.hide('myid');\n\t\t */\n\t\thide : function(e) {\n\t\t\treturn this.setStyle(e, 'display', 'none');\n\t\t},\n\n\t\t/**\n\t\t * Returns true/false if the element is hidden or not by checking the \"display\" style.\n\t\t *\n\t\t * @method isHidden\n\t\t * @param {String/Element} e Id or element to check display state on.\n\t\t * @return {Boolean} true/false if the element is hidden or not.\n\t\t */\n\t\tisHidden : function(e) {\n\t\t\te = this.get(e);\n\n\t\t\treturn !e || e.style.display == 'none' || this.getStyle(e, 'display') == 'none';\n\t\t},\n\n\t\t/**\n\t\t * Returns a unique id. This can be useful when generating elements on the fly.\n\t\t * This method will not check if the element already exists.\n\t\t *\n\t\t * @method uniqueId\n\t\t * @param {String} p Optional prefix to add infront of all ids defaults to \"mce_\".\n\t\t * @return {String} Unique id.\n\t\t */\n\t\tuniqueId : function(p) {\n\t\t\treturn (!p ? 'mce_' : p) + (this.counter++);\n\t\t},\n\n\t\t/**\n\t\t * Sets the specified HTML content inside the element or elements. The HTML will first be processed this means\n\t\t * URLs will get converted, hex color values fixed etc. Check processHTML for details.\n\t\t *\n\t\t * @method setHTML\n\t\t * @param {Element/String/Array} e DOM element, element id string or array of elements/ids to set HTML inside.\n\t\t * @param {String} h HTML content to set as inner HTML of the element.\n\t\t * @example\n\t\t * // Sets the inner HTML of all paragraphs in the active editor\n\t\t * tinyMCE.activeEditor.dom.setHTML(tinyMCE.activeEditor.dom.select('p'), 'some inner html');\n\t\t * \n\t\t * // Sets the inner HTML of a element by id in the document\n\t\t * tinyMCE.DOM.setHTML('mydiv', 'some inner html');\n\t\t */\n\t\tsetHTML : function(element, html) {\n\t\t\tvar self = this;\n\n\t\t\treturn self.run(element, function(element) {\n\t\t\t\tif (isIE) {\n\t\t\t\t\t// Remove all child nodes, IE keeps empty text nodes in DOM\n\t\t\t\t\twhile (element.firstChild)\n\t\t\t\t\t\telement.removeChild(element.firstChild);\n\n\t\t\t\t\ttry {\n\t\t\t\t\t\t// IE will remove comments from the beginning\n\t\t\t\t\t\t// unless you padd the contents with something\n\t\t\t\t\t\telement.innerHTML = '<br />' + html;\n\t\t\t\t\t\telement.removeChild(element.firstChild);\n\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t// IE sometimes produces an unknown runtime error on innerHTML if it's an block element within a block element for example a div inside a p\n\t\t\t\t\t\t// This seems to fix this problem\n\n\t\t\t\t\t\t// Create new div with HTML contents and a BR infront to keep comments\n\t\t\t\t\t\telement = self.create('div');\n\t\t\t\t\t\telement.innerHTML = '<br />' + html;\n\n\t\t\t\t\t\t// Add all children from div to target\n\t\t\t\t\t\teach (element.childNodes, function(node, i) {\n\t\t\t\t\t\t\t// Skip br element\n\t\t\t\t\t\t\tif (i)\n\t\t\t\t\t\t\t\telement.appendChild(node);\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t} else\n\t\t\t\t\telement.innerHTML = html;\n\n\t\t\t\treturn html;\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Returns the outer HTML of an element.\n\t\t *\n\t\t * @method getOuterHTML\n\t\t * @param {String/Element} elm Element ID or element object to get outer HTML from.\n\t\t * @return {String} Outer HTML string.\n\t\t * @example\n\t\t * tinymce.DOM.getOuterHTML(editorElement);\n\t\t * tinyMCE.activeEditor.getOuterHTML(tinyMCE.activeEditor.getBody());\n\t\t */\n\t\tgetOuterHTML : function(elm) {\n\t\t\tvar doc, self = this;\n\n\t\t\telm = self.get(elm);\n\n\t\t\tif (!elm)\n\t\t\t\treturn null;\n\n\t\t\tif (elm.nodeType === 1 && self.hasOuterHTML)\n\t\t\t\treturn elm.outerHTML;\n\n\t\t\tdoc = (elm.ownerDocument || self.doc).createElement(\"body\");\n\t\t\tdoc.appendChild(elm.cloneNode(true));\n\n\t\t\treturn doc.innerHTML;\n\t\t},\n\n\t\t/**\n\t\t * Sets the specified outer HTML on a element or elements.\n\t\t *\n\t\t * @method setOuterHTML\n\t\t * @param {Element/String/Array} e DOM element, element id string or array of elements/ids to set outer HTML on.\n\t\t * @param {Object} h HTML code to set as outer value for the element.\n\t\t * @param {Document} d Optional document scope to use in this process defaults to the document of the DOM class.\n\t\t * @example\n\t\t * // Sets the outer HTML of all paragraphs in the active editor\n\t\t * tinyMCE.activeEditor.dom.setOuterHTML(tinyMCE.activeEditor.dom.select('p'), '<div>some html</div>');\n\t\t * \n\t\t * // Sets the outer HTML of a element by id in the document\n\t\t * tinyMCE.DOM.setOuterHTML('mydiv', '<div>some html</div>');\n\t\t */\n\t\tsetOuterHTML : function(e, h, d) {\n\t\t\tvar t = this;\n\n\t\t\tfunction setHTML(e, h, d) {\n\t\t\t\tvar n, tp;\n\n\t\t\t\ttp = d.createElement(\"body\");\n\t\t\t\ttp.innerHTML = h;\n\n\t\t\t\tn = tp.lastChild;\n\t\t\t\twhile (n) {\n\t\t\t\t\tt.insertAfter(n.cloneNode(true), e);\n\t\t\t\t\tn = n.previousSibling;\n\t\t\t\t}\n\n\t\t\t\tt.remove(e);\n\t\t\t};\n\n\t\t\treturn this.run(e, function(e) {\n\t\t\t\te = t.get(e);\n\n\t\t\t\t// Only set HTML on elements\n\t\t\t\tif (e.nodeType == 1) {\n\t\t\t\t\td = d || e.ownerDocument || t.doc;\n\n\t\t\t\t\tif (isIE) {\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t// Try outerHTML for IE it sometimes produces an unknown runtime error\n\t\t\t\t\t\t\tif (isIE && e.nodeType == 1)\n\t\t\t\t\t\t\t\te.outerHTML = h;\n\t\t\t\t\t\t\telse\n\t\t\t\t\t\t\t\tsetHTML(e, h, d);\n\t\t\t\t\t\t} catch (ex) {\n\t\t\t\t\t\t\t// Fix for unknown runtime error\n\t\t\t\t\t\t\tsetHTML(e, h, d);\n\t\t\t\t\t\t}\n\t\t\t\t\t} else\n\t\t\t\t\t\tsetHTML(e, h, d);\n\t\t\t\t}\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Entity decode a string, resolves any HTML entities like &aring;.\n\t\t *\n\t\t * @method decode\n\t\t * @param {String} s String to decode entities on.\n\t\t * @return {String} Entity decoded string.\n\t\t */\n\t\tdecode : Entities.decode,\n\n\t\t/**\n\t\t * Entity encodes a string, encodes the most common entities <>\"& into entities.\n\t\t *\n\t\t * @method encode\n\t\t * @param {String} text String to encode with entities.\n\t\t * @return {String} Entity encoded string.\n\t\t */\n\t\tencode : Entities.encodeAllRaw,\n\n\t\t/**\n\t\t * Inserts a element after the reference element.\n\t\t *\n\t\t * @method insertAfter\n\t\t * @param {Element} node Element to insert after the reference.\n\t\t * @param {Element/String/Array} reference_node Reference element, element id or array of elements to insert after.\n\t\t * @return {Element/Array} Element that got added or an array with elements. \n\t\t */\n\t\tinsertAfter : function(node, reference_node) {\n\t\t\treference_node = this.get(reference_node);\n\n\t\t\treturn this.run(node, function(node) {\n\t\t\t\tvar parent, nextSibling;\n\n\t\t\t\tparent = reference_node.parentNode;\n\t\t\t\tnextSibling = reference_node.nextSibling;\n\n\t\t\t\tif (nextSibling)\n\t\t\t\t\tparent.insertBefore(node, nextSibling);\n\t\t\t\telse\n\t\t\t\t\tparent.appendChild(node);\n\n\t\t\t\treturn node;\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Returns true/false if the specified element is a block element or not.\n\t\t *\n\t\t * @method isBlock\n\t\t * @param {Node/String} node Element/Node to check.\n\t\t * @return {Boolean} True/False state if the node is a block element or not.\n\t\t */\n\t\tisBlock : function(node) {\n\t\t\tvar type = node.nodeType;\n\n\t\t\t// If it's a node then check the type and use the nodeName\n\t\t\tif (type)\n\t\t\t\treturn !!(type === 1 && blockElementsMap[node.nodeName]);\n\n\t\t\treturn !!blockElementsMap[node];\n\t\t},\n\n\t\t/**\n\t\t * Replaces the specified element or elements with the specified element, the new element will\n\t\t * be cloned if multiple inputs elements are passed.\n\t\t *\n\t\t * @method replace\n\t\t * @param {Element} n New element to replace old ones with.\n\t\t * @param {Element/String/Array} o Element DOM node, element id or array of elements or ids to replace.\n\t\t * @param {Boolean} k Optional keep children state, if set to true child nodes from the old object will be added to new ones.\n\t\t */\n\t\treplace : function(n, o, k) {\n\t\t\tvar t = this;\n\n\t\t\tif (is(o, 'array'))\n\t\t\t\tn = n.cloneNode(true);\n\n\t\t\treturn t.run(o, function(o) {\n\t\t\t\tif (k) {\n\t\t\t\t\teach(tinymce.grep(o.childNodes), function(c) {\n\t\t\t\t\t\tn.appendChild(c);\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\treturn o.parentNode.replaceChild(n, o);\n\t\t\t});\n\t\t},\n\n\t\t/**\n\t\t * Renames the specified element to a new name and keep it's attributes and children.\n\t\t *\n\t\t * @method rename\n\t\t * @param {Element} elm Element to rename.\n\t\t * @param {String} name Name of the new element.\n\t\t * @return New element or the old element if it needed renaming.\n\t\t */\n\t\trename : function(elm, name) {\n\t\t\tvar t = this, newElm;\n\n\t\t\tif (elm.nodeName != name.toUpperCase()) {\n\t\t\t\t// Rename block element\n\t\t\t\tnewElm = t.create(name);\n\n\t\t\t\t// Copy attribs to new block\n\t\t\t\teach(t.getAttribs(elm), function(attr_node) {\n\t\t\t\t\tt.setAttrib(newElm, attr_node.nodeName, t.getAttrib(elm, attr_node.nodeName));\n\t\t\t\t});\n\n\t\t\t\t// Replace block\n\t\t\t\tt.replace(newElm, elm, 1);\n\t\t\t}\n\n\t\t\treturn newElm || elm;\n\t\t},\n\n\t\t/**\n\t\t * Find the common ancestor of two elements. This is a shorter method than using the DOM Range logic.\n\t\t *\n\t\t * @method findCommonAncestor\n\t\t * @param {Element} a Element to find common ancestor of.\n\t\t * @param {Element} b Element to find common ancestor of.\n\t\t * @return {Element} Common ancestor element of the two input elements.\n\t\t */\n\t\tfindCommonAncestor : function(a, b) {\n\t\t\tvar ps = a, pe;\n\n\t\t\twhile (ps) {\n\t\t\t\tpe = b;\n\n\t\t\t\twhile (pe && ps != pe)\n\t\t\t\t\tpe = pe.parentNode;\n\n\t\t\t\tif (ps == pe)\n\t\t\t\t\tbreak;\n\n\t\t\t\tps = ps.parentNode;\n\t\t\t}\n\n\t\t\tif (!ps && a.ownerDocument)\n\t\t\t\treturn a.ownerDocument.documentElement;\n\n\t\t\treturn ps;\n\t\t},\n\n\t\t/**\n\t\t * Parses the specified RGB color value and returns a hex version of that color.\n\t\t *\n\t\t * @method toHex\n\t\t * @param {String} s RGB string value like rgb(1,2,3)\n\t\t * @return {String} Hex version of that RGB value like #FF00FF.\n\t\t */\n\t\ttoHex : function(s) {\n\t\t\tvar c = /^\\s*rgb\\s*?\\(\\s*?([0-9]+)\\s*?,\\s*?([0-9]+)\\s*?,\\s*?([0-9]+)\\s*?\\)\\s*$/i.exec(s);\n\n\t\t\tfunction hex(s) {\n\t\t\t\ts = parseInt(s).toString(16);\n\n\t\t\t\treturn s.length > 1 ? s : '0' + s; // 0 -> 00\n\t\t\t};\n\n\t\t\tif (c) {\n\t\t\t\ts = '#' + hex(c[1]) + hex(c[2]) + hex(c[3]);\n\n\t\t\t\treturn s;\n\t\t\t}\n\n\t\t\treturn s;\n\t\t},\n\n\t\t/**\n\t\t * Returns a array of all single CSS classes in the document. A single CSS class is a simple\n\t\t * rule like \".class\" complex ones like \"div td.class\" will not be added to output.\n\t\t *\n\t\t * @method getClasses\n\t\t * @return {Array} Array with class objects each object has a class field might be other fields in the future.\n\t\t */\n\t\tgetClasses : function() {\n\t\t\tvar t = this, cl = [], i, lo = {}, f = t.settings.class_filter, ov;\n\n\t\t\tif (t.classes)\n\t\t\t\treturn t.classes;\n\n\t\t\tfunction addClasses(s) {\n\t\t\t\t// IE style imports\n\t\t\t\teach(s.imports, function(r) {\n\t\t\t\t\taddClasses(r);\n\t\t\t\t});\n\n\t\t\t\teach(s.cssRules || s.rules, function(r) {\n\t\t\t\t\t// Real type or fake it on IE\n\t\t\t\t\tswitch (r.type || 1) {\n\t\t\t\t\t\t// Rule\n\t\t\t\t\t\tcase 1:\n\t\t\t\t\t\t\tif (r.selectorText) {\n\t\t\t\t\t\t\t\teach(r.selectorText.split(','), function(v) {\n\t\t\t\t\t\t\t\t\tv = v.replace(/^\\s*|\\s*$|^\\s\\./g, \"\");\n\n\t\t\t\t\t\t\t\t\t// Is internal or it doesn't contain a class\n\t\t\t\t\t\t\t\t\tif (/\\.mce/.test(v) || !/\\.[\\w\\-]+$/.test(v))\n\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\t// Remove everything but class name\n\t\t\t\t\t\t\t\t\tov = v;\n\t\t\t\t\t\t\t\t\tv = tinymce._replace(/.*\\.([a-z0-9_\\-]+).*/i, '$1', v);\n\n\t\t\t\t\t\t\t\t\t// Filter classes\n\t\t\t\t\t\t\t\t\tif (f && !(v = f(v, ov)))\n\t\t\t\t\t\t\t\t\t\treturn;\n\n\t\t\t\t\t\t\t\t\tif (!lo[v]) {\n\t\t\t\t\t\t\t\t\t\tcl.push({'class' : v});\n\t\t\t\t\t\t\t\t\t\tlo[v] = 1;\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t});\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\t// Import\n\t\t\t\t\t\tcase 3:\n\t\t\t\t\t\t\taddClasses(r.styleSheet);\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t};\n\n\t\t\ttry {\n\t\t\t\teach(t.doc.styleSheets, addClasses);\n\t\t\t} catch (ex) {\n\t\t\t\t// Ignore\n\t\t\t}\n\n\t\t\tif (cl.length > 0)\n\t\t\t\tt.classes = cl;\n\n\t\t\treturn cl;\n\t\t},\n\n\t\t/**\n\t\t * Executes the specified function on the element by id or dom element node or array of elements/id.\n\t\t *\n\t\t * @method run\n\t\t * @param {String/Element/Array} Element ID or DOM element object or array with ids or elements.\n\t\t * @param {function} f Function to execute for each item.\n\t\t * @param {Object} s Optional scope to execute the function in.\n\t\t * @return {Object/Array} Single object or array with objects depending on multiple input or not.\n\t\t */\n\t\trun : function(e, f, s) {\n\t\t\tvar t = this, o;\n\n\t\t\tif (t.doc && typeof(e) === 'string')\n\t\t\t\te = t.get(e);\n\n\t\t\tif (!e)\n\t\t\t\treturn false;\n\n\t\t\ts = s || this;\n\t\t\tif (!e.nodeType && (e.length || e.length === 0)) {\n\t\t\t\to = [];\n\n\t\t\t\teach(e, function(e, i) {\n\t\t\t\t\tif (e) {\n\t\t\t\t\t\tif (typeof(e) == 'string')\n\t\t\t\t\t\t\te = t.doc.getElementById(e);\n\n\t\t\t\t\t\to.push(f.call(s, e, i));\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\treturn o;\n\t\t\t}\n\n\t\t\treturn f.call(s, e);\n\t\t},\n\n\t\t/**\n\t\t * Returns an NodeList with attributes for the element.\n\t\t *\n\t\t * @method getAttribs\n\t\t * @param {HTMLElement/string} n Element node or string id to get attributes from.\n\t\t * @return {NodeList} NodeList with attributes.\n\t\t */\n\t\tgetAttribs : function(n) {\n\t\t\tvar o;\n\n\t\t\tn = this.get(n);\n\n\t\t\tif (!n)\n\t\t\t\treturn [];\n\n\t\t\tif (isIE) {\n\t\t\t\to = [];\n\n\t\t\t\t// Object will throw exception in IE\n\t\t\t\tif (n.nodeName == 'OBJECT')\n\t\t\t\t\treturn n.attributes;\n\n\t\t\t\t// IE doesn't keep the selected attribute if you clone option elements\n\t\t\t\tif (n.nodeName === 'OPTION' && this.getAttrib(n, 'selected'))\n\t\t\t\t\to.push({specified : 1, nodeName : 'selected'});\n\n\t\t\t\t// It's crazy that this is faster in IE but it's because it returns all attributes all the time\n\t\t\t\tn.cloneNode(false).outerHTML.replace(/<\\/?[\\w:\\-]+ ?|=[\\\"][^\\\"]+\\\"|=\\'[^\\']+\\'|=[\\w\\-]+|>/gi, '').replace(/[\\w:\\-]+/gi, function(a) {\n\t\t\t\t\to.push({specified : 1, nodeName : a});\n\t\t\t\t});\n\n\t\t\t\treturn o;\n\t\t\t}\n\n\t\t\treturn n.attributes;\n\t\t},\n\n\t\t/**\n\t\t * Returns true/false if the specified node is to be considered empty or not.\n\t\t *\n\t\t * @example\n\t\t * tinymce.DOM.isEmpty(node, {img : true});\n\t\t * @method isEmpty\n\t\t * @param {Object} elements Optional name/value object with elements that are automatically treated as non empty elements.\n\t\t * @return {Boolean} true/false if the node is empty or not.\n\t\t */\n\t\tisEmpty : function(node, elements) {\n\t\t\tvar self = this, i, attributes, type, walker, name, parentNode;\n\n\t\t\tnode = node.firstChild;\n\t\t\tif (node) {\n\t\t\t\twalker = new tinymce.dom.TreeWalker(node);\n\t\t\t\telements = elements || self.schema ? self.schema.getNonEmptyElements() : null;\n\n\t\t\t\tdo {\n\t\t\t\t\ttype = node.nodeType;\n\n\t\t\t\t\tif (type === 1) {\n\t\t\t\t\t\t// Ignore bogus elements\n\t\t\t\t\t\tif (node.getAttribute('data-mce-bogus'))\n\t\t\t\t\t\t\tcontinue;\n\n\t\t\t\t\t\t// Keep empty elements like <img />\n\t\t\t\t\t\tname = node.nodeName.toLowerCase();\n\t\t\t\t\t\tif (elements && elements[name]) {\n\t\t\t\t\t\t\t// Ignore single BR elements in blocks like <p><br /></p>\n\t\t\t\t\t\t\tparentNode = node.parentNode;\n\t\t\t\t\t\t\tif (name === 'br' && self.isBlock(parentNode) && parentNode.firstChild === node && parentNode.lastChild === node) {\n\t\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Keep elements with data-bookmark attributes or name attribute like <a name=\"1\"></a>\n\t\t\t\t\t\tattributes = self.getAttribs(node);\n\t\t\t\t\t\ti = node.attributes.length;\n\t\t\t\t\t\twhile (i--) {\n\t\t\t\t\t\t\tname = node.attributes[i].nodeName;\n\t\t\t\t\t\t\tif (name === \"name\" || name === 'data-mce-bookmark')\n\t\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\t// Keep non whitespace text nodes\n\t\t\t\t\tif ((type === 3 && !whiteSpaceRegExp.test(node.nodeValue)))\n\t\t\t\t\t\treturn false;\n\t\t\t\t} while (node = walker.next());\n\t\t\t}\n\n\t\t\treturn true;\n\t\t},\n\n\t\t/**\n\t\t * Destroys all internal references to the DOM to solve IE leak issues.\n\t\t *\n\t\t * @method destroy\n\t\t */\n\t\tdestroy : function(s) {\n\t\t\tvar t = this;\n\n\t\t\tif (t.events)\n\t\t\t\tt.events.destroy();\n\n\t\t\tt.win = t.doc = t.root = t.events = null;\n\n\t\t\t// Manual destroy then remove unload handler\n\t\t\tif (!s)\n\t\t\t\ttinymce.removeUnload(t.destroy);\n\t\t},\n\n\t\t/**\n\t\t * Created a new DOM Range object. This will use the native DOM Range API if it's\n\t\t * available if it's not it will fallback to the custom TinyMCE implementation.\n\t\t *\n\t\t * @method createRng\n\t\t * @return {DOMRange} DOM Range object.\n\t\t * @example\n\t\t * var rng = tinymce.DOM.createRng();\n\t\t * alert(rng.startContainer + \",\" + rng.startOffset);\n\t\t */\n\t\tcreateRng : function() {\n\t\t\tvar d = this.doc;\n\n\t\t\treturn d.createRange ? d.createRange() : new tinymce.dom.Range(this);\n\t\t},\n\n\t\t/**\n\t\t * Returns the index of the specified node within it's parent.\n\t\t *\n\t\t * @param {Node} node Node to look for.\n\t\t * @param {boolean} normalized Optional true/false state if the index is what it would be after a normalization.\n\t\t * @return {Number} Index of the specified node.\n\t\t */\n\t\tnodeIndex : function(node, normalized) {\n\t\t\tvar idx = 0, lastNodeType, lastNode, nodeType;\n\n\t\t\tif (node) {\n\t\t\t\tfor (lastNodeType = node.nodeType, node = node.previousSibling, lastNode = node; node; node = node.previousSibling) {\n\t\t\t\t\tnodeType = node.nodeType;\n\n\t\t\t\t\t// Normalize text nodes\n\t\t\t\t\tif (normalized && nodeType == 3) {\n\t\t\t\t\t\tif (nodeType == lastNodeType || !node.nodeValue.length)\n\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t}\n\t\t\t\t\tidx++;\n\t\t\t\t\tlastNodeType = nodeType;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn idx;\n\t\t},\n\n\t\t/**\n\t\t * Splits an element into two new elements and places the specified split\n\t\t * element or element between the new ones. For example splitting the paragraph at the bold element in\n\t\t * this example <p>abc<b>abc</b>123</p> would produce <p>abc</p><b>abc</b><p>123</p>. \n\t\t *\n\t\t * @method split\n\t\t * @param {Element} pe Parent element to split.\n\t\t * @param {Element} e Element to split at.\n\t\t * @param {Element} re Optional replacement element to replace the split element by.\n\t\t * @return {Element} Returns the split element or the replacement element if that is specified.\n\t\t */\n\t\tsplit : function(pe, e, re) {\n\t\t\tvar t = this, r = t.createRng(), bef, aft, pa;\n\n\t\t\t// W3C valid browsers tend to leave empty nodes to the left/right side of the contents, this makes sense\n\t\t\t// but we don't want that in our code since it serves no purpose for the end user\n\t\t\t// For example if this is chopped:\n\t\t\t//   <p>text 1<span><b>CHOP</b></span>text 2</p>\n\t\t\t// would produce:\n\t\t\t//   <p>text 1<span></span></p><b>CHOP</b><p><span></span>text 2</p>\n\t\t\t// this function will then trim of empty edges and produce:\n\t\t\t//   <p>text 1</p><b>CHOP</b><p>text 2</p>\n\t\t\tfunction trim(node) {\n\t\t\t\tvar i, children = node.childNodes, type = node.nodeType;\n\n\t\t\t\tif (type == 1 && node.getAttribute('data-mce-type') == 'bookmark')\n\t\t\t\t\treturn;\n\n\t\t\t\tfor (i = children.length - 1; i >= 0; i--)\n\t\t\t\t\ttrim(children[i]);\n\n\t\t\t\tif (type != 9) {\n\t\t\t\t\t// Keep non whitespace text nodes\n\t\t\t\t\tif (type == 3 && node.nodeValue.length > 0) {\n\t\t\t\t\t\t// If parent element isn't a block or there isn't any useful contents for example \"<p>   </p>\"\n\t\t\t\t\t\tif (!t.isBlock(node.parentNode) || tinymce.trim(node.nodeValue).length > 0)\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t} else if (type == 1) {\n\t\t\t\t\t\t// If the only child is a bookmark then move it up\n\t\t\t\t\t\tchildren = node.childNodes;\n\t\t\t\t\t\tif (children.length == 1 && children[0] && children[0].nodeType == 1 && children[0].getAttribute('data-mce-type') == 'bookmark')\n\t\t\t\t\t\t\tnode.parentNode.insertBefore(children[0], node);\n\n\t\t\t\t\t\t// Keep non empty elements or img, hr etc\n\t\t\t\t\t\tif (children.length || /^(br|hr|input|img)$/i.test(node.nodeName))\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\tt.remove(node);\n\t\t\t\t}\n\n\t\t\t\treturn node;\n\t\t\t};\n\n\t\t\tif (pe && e) {\n\t\t\t\t// Get before chunk\n\t\t\t\tr.setStart(pe.parentNode, t.nodeIndex(pe));\n\t\t\t\tr.setEnd(e.parentNode, t.nodeIndex(e));\n\t\t\t\tbef = r.extractContents();\n\n\t\t\t\t// Get after chunk\n\t\t\t\tr = t.createRng();\n\t\t\t\tr.setStart(e.parentNode, t.nodeIndex(e) + 1);\n\t\t\t\tr.setEnd(pe.parentNode, t.nodeIndex(pe) + 1);\n\t\t\t\taft = r.extractContents();\n\n\t\t\t\t// Insert before chunk\n\t\t\t\tpa = pe.parentNode;\n\t\t\t\tpa.insertBefore(trim(bef), pe);\n\n\t\t\t\t// Insert middle chunk\n\t\t\t\tif (re)\n\t\t\t\t\tpa.replaceChild(re, e);\n\t\t\t\telse\n\t\t\t\t\tpa.insertBefore(e, pe);\n\n\t\t\t\t// Insert after chunk\n\t\t\t\tpa.insertBefore(trim(aft), pe);\n\t\t\t\tt.remove(pe);\n\n\t\t\t\treturn re || e;\n\t\t\t}\n\t\t},\n\n\t\t/**\n\t\t * Adds an event handler to the specified object.\n\t\t *\n\t\t * @method bind\n\t\t * @param {Element/Document/Window/Array/String} o Object or element id string to add event handler to or an array of elements/ids/documents.\n\t\t * @param {String} n Name of event handler to add for example: click.\n\t\t * @param {function} f Function to execute when the event occurs.\n\t\t * @param {Object} s Optional scope to execute the function in.\n\t\t * @return {function} Function callback handler the same as the one passed in.\n\t\t */\n\t\tbind : function(target, name, func, scope) {\n\t\t\tvar t = this;\n\n\t\t\tif (!t.events)\n\t\t\t\tt.events = new tinymce.dom.EventUtils();\n\n\t\t\treturn t.events.add(target, name, func, scope || this);\n\t\t},\n\n\t\t/**\n\t\t * Removes the specified event handler by name and function from a element or collection of elements.\n\t\t *\n\t\t * @method unbind\n\t\t * @param {String/Element/Array} o Element ID string or HTML element or an array of elements or ids to remove handler from.\n\t\t * @param {String} n Event handler name like for example: \"click\"\n\t\t * @param {function} f Function to remove.\n\t\t * @return {bool/Array} Bool state if true if the handler was removed or an array with states if multiple elements where passed in.\n\t\t */\n\t\tunbind : function(target, name, func) {\n\t\t\tvar t = this;\n\n\t\t\tif (!t.events)\n\t\t\t\tt.events = new tinymce.dom.EventUtils();\n\n\t\t\treturn t.events.remove(target, name, func);\n\t\t},\n\n\t\t// #ifdef debug\n\n\t\tdumpRng : function(r) {\n\t\t\treturn 'startContainer: ' + r.startContainer.nodeName + ', startOffset: ' + r.startOffset + ', endContainer: ' + r.endContainer.nodeName + ', endOffset: ' + r.endOffset;\n\t\t},\n\n\t\t// #endif\n\n\t\t_findSib : function(node, selector, name) {\n\t\t\tvar t = this, f = selector;\n\n\t\t\tif (node) {\n\t\t\t\t// If expression make a function of it using is\n\t\t\t\tif (is(f, 'string')) {\n\t\t\t\t\tf = function(node) {\n\t\t\t\t\t\treturn t.is(node, selector);\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\t// Loop all siblings\n\t\t\t\tfor (node = node[name]; node; node = node[name]) {\n\t\t\t\t\tif (f(node))\n\t\t\t\t\t\treturn node;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn null;\n\t\t},\n\n\t\t_isRes : function(c) {\n\t\t\t// Is live resizble element\n\t\t\treturn /^(top|left|bottom|right|width|height)/i.test(c) || /;\\s*(top|left|bottom|right|width|height)/i.test(c);\n\t\t}\n\n\t\t/*\n\t\twalk : function(n, f, s) {\n\t\t\tvar d = this.doc, w;\n\n\t\t\tif (d.createTreeWalker) {\n\t\t\t\tw = d.createTreeWalker(n, NodeFilter.SHOW_TEXT, null, false);\n\n\t\t\t\twhile ((n = w.nextNode()) != null)\n\t\t\t\t\tf.call(s || this, n);\n\t\t\t} else\n\t\t\t\ttinymce.walk(n, f, 'childNodes', s);\n\t\t}\n\t\t*/\n\n\t\t/*\n\t\ttoRGB : function(s) {\n\t\t\tvar c = /^\\s*?#([0-9A-F]{2})([0-9A-F]{1,2})([0-9A-F]{2})?\\s*?$/.exec(s);\n\n\t\t\tif (c) {\n\t\t\t\t// #FFF -> #FFFFFF\n\t\t\t\tif (!is(c[3]))\n\t\t\t\t\tc[3] = c[2] = c[1];\n\n\t\t\t\treturn \"rgb(\" + parseInt(c[1], 16) + \",\" + parseInt(c[2], 16) + \",\" + parseInt(c[3], 16) + \")\";\n\t\t\t}\n\n\t\t\treturn s;\n\t\t}\n\t\t*/\n\t});\n\n\t/**\n\t * Instance of DOMUtils for the current document.\n\t *\n\t * @property DOM\n\t * @member tinymce\n\t * @type tinymce.dom.DOMUtils\n\t * @example\n\t * // Example of how to add a class to some element by id\n\t * tinymce.DOM.addClass('someid', 'someclass');\n\t */\n\ttinymce.DOM = new tinymce.dom.DOMUtils(document, {process_html : 0});\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/dom/ScriptLoader.js":"/**\n * ScriptLoader.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function(tinymce) {\n\t/**\n\t * This class handles asynchronous/synchronous loading of JavaScript files it will execute callbacks when various items gets loaded. This class is useful to load external JavaScript files. \n\t *\n\t * @class tinymce.dom.ScriptLoader\n\t * @example\n\t * // Load a script from a specific URL using the global script loader\n\t * tinymce.ScriptLoader.load('somescript.js');\n\t * \n\t * // Load a script using a unique instance of the script loader\n\t * var scriptLoader = new tinymce.dom.ScriptLoader();\n\t * \n\t * scriptLoader.load('somescript.js');\n\t * \n\t * // Load multiple scripts\n\t * var scriptLoader = new tinymce.dom.ScriptLoader();\n\t * \n\t * scriptLoader.add('somescript1.js');\n\t * scriptLoader.add('somescript2.js');\n\t * scriptLoader.add('somescript3.js');\n\t * \n\t * scriptLoader.loadQueue(function() {\n\t *    alert('All scripts are now loaded.');\n\t * });\n\t */\n\ttinymce.dom.ScriptLoader = function(settings) {\n\t\tvar QUEUED = 0,\n\t\t\tLOADING = 1,\n\t\t\tLOADED = 2,\n\t\t\tstates = {},\n\t\t\tqueue = [],\n\t\t\tscriptLoadedCallbacks = {},\n\t\t\tqueueLoadedCallbacks = [],\n\t\t\tloading = 0,\n\t\t\tundefined;\n\n\t\t/**\n\t\t * Loads a specific script directly without adding it to the load queue.\n\t\t *\n\t\t * @method load\n\t\t * @param {String} url Absolute URL to script to add.\n\t\t * @param {function} callback Optional callback function to execute ones this script gets loaded.\n\t\t * @param {Object} scope Optional scope to execute callback in.\n\t\t */\n\t\tfunction loadScript(url, callback) {\n\t\t\tvar t = this, dom = tinymce.DOM, elm, uri, loc, id;\n\n\t\t\t// Execute callback when script is loaded\n\t\t\tfunction done() {\n\t\t\t\tdom.remove(id);\n\n\t\t\t\tif (elm)\n\t\t\t\t\telm.onreadystatechange = elm.onload = elm = null;\n\n\t\t\t\tcallback();\n\t\t\t};\n\t\t\t\n\t\t\tfunction error() {\n\t\t\t\t// Report the error so it's easier for people to spot loading errors\n\t\t\t\tif (typeof(console) !== \"undefined\" && console.log)\n\t\t\t\t\tconsole.log(\"Failed to load: \" + url);\n\n\t\t\t\t// We can't mark it as done if there is a load error since\n\t\t\t\t// A) We don't want to produce 404 errors on the server and\n\t\t\t\t// B) the onerror event won't fire on all browsers.\n\t\t\t\t// done();\n\t\t\t};\n\n\t\t\tid = dom.uniqueId();\n\n\t\t\tif (tinymce.isIE6) {\n\t\t\t\turi = new tinymce.util.URI(url);\n\t\t\t\tloc = location;\n\n\t\t\t\t// If script is from same domain and we\n\t\t\t\t// use IE 6 then use XHR since it's more reliable\n\t\t\t\tif (uri.host == loc.hostname && uri.port == loc.port && (uri.protocol + ':') == loc.protocol && uri.protocol.toLowerCase() != 'file') {\n\t\t\t\t\ttinymce.util.XHR.send({\n\t\t\t\t\t\turl : tinymce._addVer(uri.getURI()),\n\t\t\t\t\t\tsuccess : function(content) {\n\t\t\t\t\t\t\t// Create new temp script element\n\t\t\t\t\t\t\tvar script = dom.create('script', {\n\t\t\t\t\t\t\t\ttype : 'text/javascript'\n\t\t\t\t\t\t\t});\n\n\t\t\t\t\t\t\t// Evaluate script in global scope\n\t\t\t\t\t\t\tscript.text = content;\n\t\t\t\t\t\t\tdocument.getElementsByTagName('head')[0].appendChild(script);\n\t\t\t\t\t\t\tdom.remove(script);\n\n\t\t\t\t\t\t\tdone();\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\n\t\t\t\t\t\terror : error\n\t\t\t\t\t});\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Create new script element\n\t\t\telm = dom.create('script', {\n\t\t\t\tid : id,\n\t\t\t\ttype : 'text/javascript',\n\t\t\t\tsrc : tinymce._addVer(url)\n\t\t\t});\n\n\t\t\t// Add onload listener for non IE browsers since IE9\n\t\t\t// fires onload event before the script is parsed and executed\n\t\t\tif (!tinymce.isIE)\n\t\t\t\telm.onload = done;\n\n\t\t\t// Add onerror event will get fired on some browsers but not all of them\n\t\t\telm.onerror = error;\n\n\t\t\t// Opera 9.60 doesn't seem to fire the onreadystate event at correctly\n\t\t\tif (!tinymce.isOpera) {\n\t\t\t\telm.onreadystatechange = function() {\n\t\t\t\t\tvar state = elm.readyState;\n\n\t\t\t\t\t// Loaded state is passed on IE 6 however there\n\t\t\t\t\t// are known issues with this method but we can't use\n\t\t\t\t\t// XHR in a cross domain loading\n\t\t\t\t\tif (state == 'complete' || state == 'loaded')\n\t\t\t\t\t\tdone();\n\t\t\t\t};\n\t\t\t}\n\n\t\t\t// Most browsers support this feature so we report errors\n\t\t\t// for those at least to help users track their missing plugins etc\n\t\t\t// todo: Removed since it produced error if the document is unloaded by navigating away, re-add it as an option\n\t\t\t/*elm.onerror = function() {\n\t\t\t\talert('Failed to load: ' + url);\n\t\t\t};*/\n\n\t\t\t// Add script to document\n\t\t\t(document.getElementsByTagName('head')[0] || document.body).appendChild(elm);\n\t\t};\n\n\t\t/**\n\t\t * Returns true/false if a script has been loaded or not.\n\t\t *\n\t\t * @method isDone\n\t\t * @param {String} url URL to check for.\n\t\t * @return [Boolean} true/false if the URL is loaded.\n\t\t */\n\t\tthis.isDone = function(url) {\n\t\t\treturn states[url] == LOADED;\n\t\t};\n\n\t\t/**\n\t\t * Marks a specific script to be loaded. This can be useful if a script got loaded outside\n\t\t * the script loader or to skip it from loading some script.\n\t\t *\n\t\t * @method markDone\n\t\t * @param {string} u Absolute URL to the script to mark as loaded.\n\t\t */\n\t\tthis.markDone = function(url) {\n\t\t\tstates[url] = LOADED;\n\t\t};\n\n\t\t/**\n\t\t * Adds a specific script to the load queue of the script loader.\n\t\t *\n\t\t * @method add\n\t\t * @param {String} url Absolute URL to script to add.\n\t\t * @param {function} callback Optional callback function to execute ones this script gets loaded.\n\t\t * @param {Object} scope Optional scope to execute callback in.\n\t\t */\n\t\tthis.add = this.load = function(url, callback, scope) {\n\t\t\tvar item, state = states[url];\n\n\t\t\t// Add url to load queue\n\t\t\tif (state == undefined) {\n\t\t\t\tqueue.push(url);\n\t\t\t\tstates[url] = QUEUED;\n\t\t\t}\n\n\t\t\tif (callback) {\n\t\t\t\t// Store away callback for later execution\n\t\t\t\tif (!scriptLoadedCallbacks[url])\n\t\t\t\t\tscriptLoadedCallbacks[url] = [];\n\n\t\t\t\tscriptLoadedCallbacks[url].push({\n\t\t\t\t\tfunc : callback,\n\t\t\t\t\tscope : scope || this\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\n\t\t/**\n\t\t * Starts the loading of the queue.\n\t\t *\n\t\t * @method loadQueue\n\t\t * @param {function} callback Optional callback to execute when all queued items are loaded.\n\t\t * @param {Object} scope Optional scope to execute the callback in.\n\t\t */\n\t\tthis.loadQueue = function(callback, scope) {\n\t\t\tthis.loadScripts(queue, callback, scope);\n\t\t};\n\n\t\t/**\n\t\t * Loads the specified queue of files and executes the callback ones they are loaded.\n\t\t * This method is generally not used outside this class but it might be useful in some scenarios. \n\t\t *\n\t\t * @method loadScripts\n\t\t * @param {Array} scripts Array of queue items to load.\n\t\t * @param {function} callback Optional callback to execute ones all items are loaded.\n\t\t * @param {Object} scope Optional scope to execute callback in.\n\t\t */\n\t\tthis.loadScripts = function(scripts, callback, scope) {\n\t\t\tvar loadScripts;\n\n\t\t\tfunction execScriptLoadedCallbacks(url) {\n\t\t\t\t// Execute URL callback functions\n\t\t\t\ttinymce.each(scriptLoadedCallbacks[url], function(callback) {\n\t\t\t\t\tcallback.func.call(callback.scope);\n\t\t\t\t});\n\n\t\t\t\tscriptLoadedCallbacks[url] = undefined;\n\t\t\t};\n\n\t\t\tqueueLoadedCallbacks.push({\n\t\t\t\tfunc : callback,\n\t\t\t\tscope : scope || this\n\t\t\t});\n\n\t\t\tloadScripts = function() {\n\t\t\t\tvar loadingScripts = tinymce.grep(scripts);\n\n\t\t\t\t// Current scripts has been handled\n\t\t\t\tscripts.length = 0;\n\n\t\t\t\t// Load scripts that needs to be loaded\n\t\t\t\ttinymce.each(loadingScripts, function(url) {\n\t\t\t\t\t// Script is already loaded then execute script callbacks directly\n\t\t\t\t\tif (states[url] == LOADED) {\n\t\t\t\t\t\texecScriptLoadedCallbacks(url);\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Is script not loading then start loading it\n\t\t\t\t\tif (states[url] != LOADING) {\n\t\t\t\t\t\tstates[url] = LOADING;\n\t\t\t\t\t\tloading++;\n\n\t\t\t\t\t\tloadScript(url, function() {\n\t\t\t\t\t\t\tstates[url] = LOADED;\n\t\t\t\t\t\t\tloading--;\n\n\t\t\t\t\t\t\texecScriptLoadedCallbacks(url);\n\n\t\t\t\t\t\t\t// Load more scripts if they where added by the recently loaded script\n\t\t\t\t\t\t\tloadScripts();\n\t\t\t\t\t\t});\n\t\t\t\t\t}\n\t\t\t\t});\n\n\t\t\t\t// No scripts are currently loading then execute all pending queue loaded callbacks\n\t\t\t\tif (!loading) {\n\t\t\t\t\ttinymce.each(queueLoadedCallbacks, function(callback) {\n\t\t\t\t\t\tcallback.func.call(callback.scope);\n\t\t\t\t\t});\n\n\t\t\t\t\tqueueLoadedCallbacks.length = 0;\n\t\t\t\t}\n\t\t\t};\n\n\t\t\tloadScripts();\n\t\t};\n\t};\n\n\t// Global script loader\n\ttinymce.ScriptLoader = new tinymce.dom.ScriptLoader();\n})(tinymce);\n","Magento_Tinymce3/tiny_mce/classes/adapter/jquery/jquery.tinymce.js":"/**\n * jquery.tinymce.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n(function($) {\n\tvar undefined,\n\t\tlazyLoading,\n\t\tdelayedInits = [],\n\t\twin = window;\n\n\t$.fn.tinymce = function(settings) {\n\t\tvar self = this, url, ed, base, pos, lang, query = \"\", suffix = \"\";\n\n\t\t// No match then just ignore the call\n\t\tif (!self.length)\n\t\t\treturn self;\n\n\t\t// Get editor instance\n\t\tif (!settings)\n\t\t\treturn tinyMCE.get(self[0].id);\n\n\t\tself.css('visibility', 'hidden'); // Hide textarea to avoid flicker\n\n\t\tfunction init() {\n\t\t\tvar editors = [], initCount = 0;\n\n\t\t\t// Apply patches to the jQuery object, only once\n\t\t\tif (applyPatch) {\n\t\t\t\tapplyPatch();\n\t\t\t\tapplyPatch = null;\n\t\t\t}\n\n\t\t\t// Create an editor instance for each matched node\n\t\t\tself.each(function(i, node) {\n\t\t\t\tvar ed, id = node.id, oninit = settings.oninit;\n\n\t\t\t\t// Generate unique id for target element if needed\n\t\t\t\tif (!id)\n\t\t\t\t\tnode.id = id = tinymce.DOM.uniqueId();\n\n\t\t\t\t// Create editor instance and render it\n\t\t\t\ted = new tinymce.Editor(id, settings);\n\t\t\t\teditors.push(ed);\n\n\t\t\t\ted.onInit.add(function() {\n\t\t\t\t\tvar scope, func = oninit;\n\n\t\t\t\t\tself.css('visibility', '');\n\n\t\t\t\t\t// Run this if the oninit setting is defined\n\t\t\t\t\t// this logic will fire the oninit callback ones each\n\t\t\t\t\t// matched editor instance is initialized\n\t\t\t\t\tif (oninit) {\n\t\t\t\t\t\t// Fire the oninit event ones each editor instance is initialized\n\t\t\t\t\t\tif (++initCount == editors.length) {\n\t\t\t\t\t\t\tif (tinymce.is(func, \"string\")) {\n\t\t\t\t\t\t\t\tscope = (func.indexOf(\".\") === -1) ? null : tinymce.resolve(func.replace(/\\.\\w+$/, \"\"));\n\t\t\t\t\t\t\t\tfunc = tinymce.resolve(func);\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Call the oninit function with the object\n\t\t\t\t\t\t\tfunc.apply(scope || tinymce, editors);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t});\n\n\t\t\t// Render the editor instances in a separate loop since we\n\t\t\t// need to have the full editors array used in the onInit calls\n\t\t\t$.each(editors, function(i, ed) {\n\t\t\t\ted.render();\n\t\t\t});\n\t\t}\n\n\t\t// Load TinyMCE on demand, if we need to\n\t\tif (!win[\"tinymce\"] && !lazyLoading && (url = settings.script_url)) {\n\t\t\tlazyLoading = 1;\n\t\t\tbase = url.substring(0, url.lastIndexOf(\"/\"));\n\n\t\t\t// Check if it's a dev/src version they want to load then\n\t\t\t// make sure that all plugins, themes etc are loaded in source mode aswell\n\t\t\tif (/_(src|dev)\\.js/g.test(url))\n\t\t\t\tsuffix = \"_src\";\n\n\t\t\t// Parse out query part, this will be appended to all scripts, css etc to clear browser cache\n\t\t\tpos = url.lastIndexOf(\"?\");\n\t\t\tif (pos != -1)\n\t\t\t\tquery = url.substring(pos + 1);\n\n\t\t\t// Setup tinyMCEPreInit object this will later be used by the TinyMCE\n\t\t\t// core script to locate other resources like CSS files, dialogs etc\n\t\t\t// You can also predefined a tinyMCEPreInit object and then it will use that instead\n\t\t\twin.tinyMCEPreInit = win.tinyMCEPreInit || {\n\t\t\t\tbase : base,\n\t\t\t\tsuffix : suffix,\n\t\t\t\tquery : query\n\t\t\t};\n\n\t\t\t// url contains gzip then we assume it's a compressor\n\t\t\tif (url.indexOf('gzip') != -1) {\n\t\t\t\tlang = settings.language || \"en\";\n\t\t\t\turl = url + (/\\?/.test(url) ? '&' : '?') + \"js=true&core=true&suffix=\" + escape(suffix) + \"&themes=\" + escape(settings.theme) + \"&plugins=\" + escape(settings.plugins) + \"&languages=\" + lang;\n\n\t\t\t\t// Check if compressor script is already loaded otherwise setup a basic one\n\t\t\t\tif (!win[\"tinyMCE_GZ\"]) {\n\t\t\t\t\ttinyMCE_GZ = {\n\t\t\t\t\t\tstart : function() {\n\t\t\t\t\t\t\ttinymce.suffix = suffix;\n\n\t\t\t\t\t\t\tfunction load(url) {\n\t\t\t\t\t\t\t\ttinymce.ScriptLoader.markDone(tinyMCE.baseURI.toAbsolute(url));\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t// Add core languages\n\t\t\t\t\t\t\tload(\"langs/\" + lang + \".js\");\n\n\t\t\t\t\t\t\t// Add themes with languages\n\t\t\t\t\t\t\tload(\"themes/\" + settings.theme + \"/editor_template\" + suffix + \".js\");\n\t\t\t\t\t\t\tload(\"themes/\" + settings.theme + \"/langs/\" + lang + \".js\");\n\n\t\t\t\t\t\t\t// Add plugins with languages\n\t\t\t\t\t\t\t$.each(settings.plugins.split(\",\"), function(i, name) {\n\t\t\t\t\t\t\t\tif (name) {\n\t\t\t\t\t\t\t\t\tload(\"plugins/\" + name + \"/editor_plugin\" + suffix + \".js\");\n\t\t\t\t\t\t\t\t\tload(\"plugins/\" + name + \"/langs/\" + lang + \".js\");\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t},\n\n\t\t\t\t\t\tend : function() {\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Load the script cached and execute the inits once it's done\n\t\t\t$.ajax({\n\t\t\t\ttype : \"GET\",\n\t\t\t\turl : url,\n\t\t\t\tdataType : \"script\",\n\t\t\t\tcache : true,\n\t\t\t\tsuccess : function() {\n\t\t\t\t\ttinymce.dom.Event.domLoaded = 1;\n\t\t\t\t\tlazyLoading = 2;\n\n\t\t\t\t\t// Execute callback after mainscript has been loaded and before the initialization occurs\n\t\t\t\t\tif (settings.script_loaded)\n\t\t\t\t\t\tsettings.script_loaded();\n\n\t\t\t\t\tinit();\n\n\t\t\t\t\t$.each(delayedInits, function(i, init) {\n\t\t\t\t\t\tinit();\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t});\n\t\t} else {\n\t\t\t// Delay the init call until tinymce is loaded\n\t\t\tif (lazyLoading === 1)\n\t\t\t\tdelayedInits.push(init);\n\t\t\telse\n\t\t\t\tinit();\n\t\t}\n\n\t\treturn self;\n\t};\n\n\t// Add :tinymce psuedo selector this will select elements that has been converted into editor instances\n\t// it's now possible to use things like $('*:tinymce') to get all TinyMCE bound elements.\n\t$.extend($.expr[\":\"], {\n\t\ttinymce : function(e) {\n\t\t\treturn e.id && !!tinyMCE.get(e.id);\n\t\t}\n\t});\n\n\t// This function patches internal jQuery functions so that if\n\t// you for example remove an div element containing an editor it's\n\t// automatically destroyed by the TinyMCE API\n\tfunction applyPatch() {\n\t\t// Removes any child editor instances by looking for editor wrapper elements\n\t\tfunction removeEditors(name) {\n\t\t\t// If the function is remove\n\t\t\tif (name === \"remove\") {\n\t\t\t\tthis.each(function(i, node) {\n\t\t\t\t\tvar ed = tinyMCEInstance(node);\n\n\t\t\t\t\tif (ed)\n\t\t\t\t\t\ted.remove();\n\t\t\t\t});\n\t\t\t}\n\n\t\t\tthis.find(\"span.mceEditor,div.mceEditor\").each(function(i, node) {\n\t\t\t\tvar ed = tinyMCE.get(node.id.replace(/_parent$/, \"\"));\n\n\t\t\t\tif (ed)\n\t\t\t\t\ted.remove();\n\t\t\t});\n\t\t}\n\n\t\t// Loads or saves contents from/to textarea if the value\n\t\t// argument is defined it will set the TinyMCE internal contents\n\t\tfunction loadOrSave(value) {\n\t\t\tvar self = this, ed;\n\n\t\t\t// Handle set value\n\t\t\tif (value !== undefined) {\n\t\t\t\tremoveEditors.call(self);\n\n\t\t\t\t// Saves the contents before get/set value of textarea/div\n\t\t\t\tself.each(function(i, node) {\n\t\t\t\t\tvar ed;\n\n\t\t\t\t\tif (ed = tinyMCE.get(node.id))\n\t\t\t\t\t\ted.setContent(value);\n\t\t\t\t});\n\t\t\t} else if (self.length > 0) {\n\t\t\t\t// Handle get value\n\t\t\t\tif (ed = tinyMCE.get(self[0].id))\n\t\t\t\t\treturn ed.getContent();\n\t\t\t}\n\t\t}\n\n\t\t// Returns tinymce instance for the specified element or null if it wasn't found\n\t\tfunction tinyMCEInstance(element) {\n\t\t\tvar ed = null;\n\n\t\t\t(element) && (element.id) && (win[\"tinymce\"]) && (ed = tinyMCE.get(element.id));\n\n\t\t\treturn ed;\n\t\t}\n\n\t\t// Checks if the specified set contains tinymce instances\n\t\tfunction containsTinyMCE(matchedSet) {\n\t\t\treturn !!((matchedSet) && (matchedSet.length) && (win[\"tinymce\"]) && (matchedSet.is(\":tinymce\")));\n\t\t}\n\n\t\t// Patch various jQuery functions\n\t\tvar jQueryFn = {};\n\n\t\t// Patch some setter/getter functions these will\n\t\t// now be able to set/get the contents of editor instances for\n\t\t// example $('#editorid').html('Content'); will update the TinyMCE iframe instance\n\t\t$.each([\"text\", \"html\", \"val\"], function(i, name) {\n\t\t\tvar origFn = jQueryFn[name] = $.fn[name],\n\t\t\t\ttextProc = (name === \"text\");\n\n\t\t\t $.fn[name] = function(value) {\n\t\t\t\tvar self = this;\n\n\t\t\t\tif (!containsTinyMCE(self))\n\t\t\t\t\treturn origFn.apply(self, arguments);\n\n\t\t\t\tif (value !== undefined) {\n\t\t\t\t\tloadOrSave.call(self.filter(\":tinymce\"), value);\n\t\t\t\t\torigFn.apply(self.not(\":tinymce\"), arguments);\n\n\t\t\t\t\treturn self; // return original set for chaining\n\t\t\t\t} else {\n\t\t\t\t\tvar ret = \"\";\n\t\t\t\t\tvar args = arguments;\n\t\t\t\t\t\n\t\t\t\t\t(textProc ? self : self.eq(0)).each(function(i, node) {\n\t\t\t\t\t\tvar ed = tinyMCEInstance(node);\n\n\t\t\t\t\t\tret += ed ? (textProc ? ed.getContent().replace(/<(?:\"[^\"]*\"|'[^']*'|[^'\">])*>/g, \"\") : ed.getContent()) : origFn.apply($(node), args);\n\t\t\t\t\t});\n\n\t\t\t\t\treturn ret;\n\t\t\t\t}\n\t\t\t };\n\t\t});\n\n\t\t// Makes it possible to use $('#id').append(\"content\"); to append contents to the TinyMCE editor iframe\n\t\t$.each([\"append\", \"prepend\"], function(i, name) {\n\t\t\tvar origFn = jQueryFn[name] = $.fn[name],\n\t\t\t\tprepend = (name === \"prepend\");\n\n\t\t\t $.fn[name] = function(value) {\n\t\t\t\tvar self = this;\n\n\t\t\t\tif (!containsTinyMCE(self))\n\t\t\t\t\treturn origFn.apply(self, arguments);\n\n\t\t\t\tif (value !== undefined) {\n\t\t\t\t\tself.filter(\":tinymce\").each(function(i, node) {\n\t\t\t\t\t\tvar ed = tinyMCEInstance(node);\n\n\t\t\t\t\t\ted && ed.setContent(prepend ? value + ed.getContent() : ed.getContent() + value);\n\t\t\t\t\t});\n\n\t\t\t\t\torigFn.apply(self.not(\":tinymce\"), arguments);\n\n\t\t\t\t\treturn self; // return original set for chaining\n\t\t\t\t}\n\t\t\t };\n\t\t});\n\n\t\t// Makes sure that the editor instance gets properly destroyed when the parent element is removed\n\t\t$.each([\"remove\", \"replaceWith\", \"replaceAll\", \"empty\"], function(i, name) {\n\t\t\tvar origFn = jQueryFn[name] = $.fn[name];\n\n\t\t\t$.fn[name] = function() {\n\t\t\t\tremoveEditors.call(this, name);\n\n\t\t\t\treturn origFn.apply(this, arguments);\n\t\t\t};\n\t\t});\n\n\t\tjQueryFn.attr = $.fn.attr;\n\n\t\t// Makes sure that $('#tinymce_id').attr('value') gets the editors current HTML contents\n\t\t$.fn.attr = function(name, value, type) {\n\t\t\tvar self = this;\n\n\t\t\tif ((!name) || (name !== \"value\") || (!containsTinyMCE(self)))\n\t\t\t\treturn jQueryFn.attr.call(self, name, value, type);\n\n\t\t\tif (value !== undefined) {\n\t\t\t\tloadOrSave.call(self.filter(\":tinymce\"), value);\n\t\t\t\tjQueryFn.attr.call(self.not(\":tinymce\"), name, value, type);\n\n\t\t\t\treturn self; // return original set for chaining\n\t\t\t} else {\n\t\t\t\tvar node = self[0], ed = tinyMCEInstance(node);\n\n\t\t\t\treturn ed ? ed.getContent() : jQueryFn.attr.call($(node), name, value, type);\n\t\t\t}\n\t\t};\n\t}\n})(jQuery);","Magento_Tinymce3/tiny_mce/classes/adapter/jquery/adapter.js":"/**\n * adapter.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n// #ifdef jquery_adapter\n\n(function($, tinymce) {\n\tvar is = tinymce.is, attrRegExp = /^(href|src|style)$/i, undefined;\n\n\t// jQuery is undefined\n\tif (!$ && window.console) {\n\t\treturn console.log(\"Load jQuery first!\");\n\t}\n\n\t// Stick jQuery into the tinymce namespace\n\ttinymce.$ = $;\n\n\t// Setup adapter\n\ttinymce.adapter = {\n\t\tpatchEditor : function(editor) {\n\t\t\tvar fn = $.fn;\n\n\t\t\t// Adapt the css function to make sure that the data-mce-style\n\t\t\t// attribute gets updated with the new style information\n\t\t\tfunction css(name, value) {\n\t\t\t\tvar self = this;\n\n\t\t\t\t// Remove data-mce-style when set operation occurs\n\t\t\t\tif (value)\n\t\t\t\t\tself.removeAttr('data-mce-style');\n\n\t\t\t\treturn fn.css.apply(self, arguments);\n\t\t\t};\n\n\t\t\t// Apapt the attr function to make sure that it uses the data-mce- prefixed variants\n\t\t\tfunction attr(name, value) {\n\t\t\t\tvar self = this;\n\n\t\t\t\t// Update/retrieve data-mce- attribute variants\n\t\t\t\tif (attrRegExp.test(name)) {\n\t\t\t\t\tif (value !== undefined) {\n\t\t\t\t\t\t// Use TinyMCE behavior when setting the specifc attributes\n\t\t\t\t\t\tself.each(function(i, node) {\n\t\t\t\t\t\t\teditor.dom.setAttrib(node, name, value);\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\treturn self;\n\t\t\t\t\t} else\n\t\t\t\t\t\treturn self.attr('data-mce-' + name);\n\t\t\t\t}\n\n\t\t\t\t// Default behavior\n\t\t\t\treturn fn.attr.apply(self, arguments);\n\t\t\t};\n\n\t\t\tfunction htmlPatchFunc(func) {\n\t\t\t\t// Returns a modified function that processes\n\t\t\t\t// the HTML before executing the action this makes sure\n\t\t\t\t// that href/src etc gets moved into the data-mce- variants\n\t\t\t\treturn function(content) {\n\t\t\t\t\tif (content)\n\t\t\t\t\t\tcontent = editor.dom.processHTML(content);\n\n\t\t\t\t\treturn func.call(this, content);\n\t\t\t\t};\n\t\t\t};\n\n\t\t\t// Patch various jQuery functions to handle tinymce specific attribute and content behavior\n\t\t\t// we don't patch the jQuery.fn directly since it will most likely break compatibility\n\t\t\t// with other jQuery logic on the page. Only instances created by TinyMCE should be patched.\n\t\t\tfunction patch(jq) {\n\t\t\t\t// Patch some functions, only patch the object once\n\t\t\t\tif (jq.css !== css) {\n\t\t\t\t\t// Patch css/attr to use the data-mce- prefixed attribute variants\n\t\t\t\t\tjq.css = css;\n\t\t\t\t\tjq.attr = attr;\n\n\t\t\t\t\t// Patch HTML functions to use the DOMUtils.processHTML filter logic\n\t\t\t\t\tjq.html = htmlPatchFunc(fn.html);\n\t\t\t\t\tjq.append = htmlPatchFunc(fn.append);\n\t\t\t\t\tjq.prepend = htmlPatchFunc(fn.prepend);\n\t\t\t\t\tjq.after = htmlPatchFunc(fn.after);\n\t\t\t\t\tjq.before = htmlPatchFunc(fn.before);\n\t\t\t\t\tjq.replaceWith = htmlPatchFunc(fn.replaceWith);\n\t\t\t\t\tjq.tinymce = editor;\n\n\t\t\t\t\t// Each pushed jQuery instance needs to be patched\n\t\t\t\t\t// as well for example when traversing the DOM\n\t\t\t\t\tjq.pushStack = function() {\n\t\t\t\t\t\treturn patch(fn.pushStack.apply(this, arguments));\n\t\t\t\t\t};\n\t\t\t\t}\n\n\t\t\t\treturn jq;\n\t\t\t};\n\n\t\t\t// Add a $ function on each editor instance this one is scoped for the editor document object\n\t\t\t// this way you can do chaining like this tinymce.get(0).$('p').append('text').css('color', 'red');\n\t\t\teditor.$ = function(selector, scope) {\n\t\t\t\tvar doc = editor.getDoc();\n\n\t\t\t\treturn patch($(selector || doc, doc || scope));\n\t\t\t};\n\t\t}\n\t};\n\n\t// Patch in core NS functions\n\ttinymce.extend = $.extend;\n\ttinymce.extend(tinymce, {\n\t\tmap : $.map,\n\t\tgrep : function(a, f) {return $.grep(a, f || function(){return 1;});},\n\t\tinArray : function(a, v) {return $.inArray(v, a || []);}\n\n\t\t/* Didn't iterate stylesheets\n\t\teach : function(o, cb, s) {\n\t\t\tif (!o)\n\t\t\t\treturn 0;\n\n\t\t\tvar r = 1;\n\n\t\t\t$.each(o, function(nr, el){\n\t\t\t\tif (cb.call(s, el, nr, o) === false) {\n\t\t\t\t\tr = 0;\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\treturn r;\n\t\t}*/\n\t});\n\n\t// Patch in functions in various clases\n\t// Add a \"#ifndefjquery\" statement around each core API function you add below\n\tvar patches = {\n\t\t'tinymce.dom.DOMUtils' : {\n\t\t\t/*\n\t\t\taddClass : function(e, c) {\n\t\t\t\tif (is(e, 'array') && is(e[0], 'string'))\n\t\t\t\t\te = e.join(',#');\n\t\t\t\treturn (e && $(is(e, 'string') ? '#' + e : e)\n\t\t\t\t\t.addClass(c)\n\t\t\t\t\t.attr('class')) || false;\n\t\t\t},\n\n\t\t\thasClass : function(n, c) {\n\t\t\t\treturn $(is(n, 'string') ? '#' + n : n).hasClass(c);\n\t\t\t},\n\n\t\t\tremoveClass : function(e, c) {\n\t\t\t\tif (!e)\n\t\t\t\t\treturn false;\n\n\t\t\t\tvar r = [];\n\n\t\t\t\t$(is(e, 'string') ? '#' + e : e)\n\t\t\t\t\t.removeClass(c)\n\t\t\t\t\t.each(function(){\n\t\t\t\t\t\tr.push(this.className);\n\t\t\t\t\t});\n\n\t\t\t\treturn r.length == 1 ? r[0] : r;\n\t\t\t},\n\t\t\t*/\n\n\t\t\tselect : function(pattern, scope) {\n\t\t\t\tvar t = this;\n\n\t\t\t\treturn $.find(pattern, t.get(scope) || t.get(t.settings.root_element) || t.doc, []);\n\t\t\t},\n\n\t\t\tis : function(n, patt) {\n\t\t\t\treturn $(this.get(n)).is(patt);\n\t\t\t}\n\n\t\t\t/*\n\t\t\tshow : function(e) {\n\t\t\t\tif (is(e, 'array') && is(e[0], 'string'))\n\t\t\t\t\te = e.join(',#');\n\n\t\t\t\t$(is(e, 'string') ? '#' + e : e).css('display', 'block');\n\t\t\t},\n\n\t\t\thide : function(e) {\n\t\t\t\tif (is(e, 'array') && is(e[0], 'string'))\n\t\t\t\t\te = e.join(',#');\n\n\t\t\t\t$(is(e, 'string') ? '#' + e : e).css('display', 'none');\n\t\t\t},\n\n\t\t\tisHidden : function(e) {\n\t\t\t\treturn $(is(e, 'string') ? '#' + e : e).is(':hidden');\n\t\t\t},\n\n\t\t\tinsertAfter : function(n, e) {\n\t\t\t\treturn $(is(e, 'string') ? '#' + e : e).after(n);\n\t\t\t},\n\n\t\t\treplace : function(o, n, k) {\n\t\t\t\tn = $(is(n, 'string') ? '#' + n : n);\n\n\t\t\t\tif (k)\n\t\t\t\t\tn.children().appendTo(o);\n\n\t\t\t\tn.replaceWith(o);\n\t\t\t},\n\n\t\t\tsetStyle : function(n, na, v) {\n\t\t\t\tif (is(n, 'array') && is(n[0], 'string'))\n\t\t\t\t\tn = n.join(',#');\n\n\t\t\t\t$(is(n, 'string') ? '#' + n : n).css(na, v);\n\t\t\t},\n\n\t\t\tgetStyle : function(n, na, c) {\n\t\t\t\treturn $(is(n, 'string') ? '#' + n : n).css(na);\n\t\t\t},\n\n\t\t\tsetStyles : function(e, o) {\n\t\t\t\tif (is(e, 'array') && is(e[0], 'string'))\n\t\t\t\t\te = e.join(',#');\n\t\t\t\t$(is(e, 'string') ? '#' + e : e).css(o);\n\t\t\t},\n\n\t\t\tsetAttrib : function(e, n, v) {\n\t\t\t\tvar t = this, s = t.settings;\n\n\t\t\t\tif (is(e, 'array') && is(e[0], 'string'))\n\t\t\t\t\te = e.join(',#');\n\n\t\t\t\te = $(is(e, 'string') ? '#' + e : e);\n\n\t\t\t\tswitch (n) {\n\t\t\t\t\tcase \"style\":\n\t\t\t\t\t\te.each(function(i, v){\n\t\t\t\t\t\t\tif (s.keep_values)\n\t\t\t\t\t\t\t\t$(v).attr('data-mce-style', v);\n\n\t\t\t\t\t\t\tv.style.cssText = v;\n\t\t\t\t\t\t});\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase \"class\":\n\t\t\t\t\t\te.each(function(){\n\t\t\t\t\t\t\tthis.className = v;\n\t\t\t\t\t\t});\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\tcase \"src\":\n\t\t\t\t\tcase \"href\":\n\t\t\t\t\t\te.each(function(i, v){\n\t\t\t\t\t\t\tif (s.keep_values) {\n\t\t\t\t\t\t\t\tif (s.url_converter)\n\t\t\t\t\t\t\t\t\tv = s.url_converter.call(s.url_converter_scope || t, v, n, v);\n\n\t\t\t\t\t\t\t\tt.setAttrib(v, 'data-mce-' + n, v);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t});\n\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\n\t\t\t\tif (v !== null && v.length !== 0)\n\t\t\t\t\te.attr(n, '' + v);\n\t\t\t\telse\n\t\t\t\t\te.removeAttr(n);\n\t\t\t},\n\n\t\t\tsetAttribs : function(e, o) {\n\t\t\t\tvar t = this;\n\n\t\t\t\t$.each(o, function(n, v){\n\t\t\t\t\tt.setAttrib(e,n,v);\n\t\t\t\t});\n\t\t\t}\n\t\t\t*/\n\t\t}\n\n/*\n\t\t'tinymce.dom.Event' : {\n\t\t\tadd : function (o, n, f, s) {\n\t\t\t\tvar lo, cb;\n\n\t\t\t\tcb = function(e) {\n\t\t\t\t\te.target = e.target || this;\n\t\t\t\t\tf.call(s || this, e);\n\t\t\t\t};\n\n\t\t\t\tif (is(o, 'array') && is(o[0], 'string'))\n\t\t\t\t\to = o.join(',#');\n\t\t\t\to = $(is(o, 'string') ? '#' + o : o);\n\t\t\t\tif (n == 'init') {\n\t\t\t\t\to.ready(cb, s);\n\t\t\t\t} else {\n\t\t\t\t\tif (s) {\n\t\t\t\t\t\to.bind(n, s, cb);\n\t\t\t\t\t} else {\n\t\t\t\t\t\to.bind(n, cb);\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tlo = this._jqLookup || (this._jqLookup = []);\n\t\t\t\tlo.push({func : f, cfunc : cb});\n\n\t\t\t\treturn cb;\n\t\t\t},\n\n\t\t\tremove : function(o, n, f) {\n\t\t\t\t// Find cfunc\n\t\t\t\t$(this._jqLookup).each(function() {\n\t\t\t\t\tif (this.func === f)\n\t\t\t\t\t\tf = this.cfunc;\n\t\t\t\t});\n\n\t\t\t\tif (is(o, 'array') && is(o[0], 'string'))\n\t\t\t\t\to = o.join(',#');\n\n\t\t\t\t$(is(o, 'string') ? '#' + o : o).unbind(n,f);\n\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n*/\n\t};\n\n\t// Patch functions after a class is created\n\ttinymce.onCreate = function(ty, c, p) {\n\t\ttinymce.extend(p, patches[c]);\n\t};\n})(window.jQuery, tinymce);\n\n// #endif\n","Magento_Tinymce3/tiny_mce/classes/adapter/prototype/adapter.js":"/**\n * adapter.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n */\n\n// #ifdef prototype_adapter\n\n(function() {\n\tif (!window.Prototype)\n\t\treturn alert(\"Load prototype first!\");\n\n\t// Patch in core NS functions\n\ttinymce.extend(tinymce, {\n\t\ttrim : function(s) {return s ? s.strip() : '';},\n\t\tinArray : function(a, v) {return a && a.indexOf ? a.indexOf(v) : -1;}\n\t});\n\n\t// Patch in functions in various clases\n\t// Add a \"#ifndefjquery\" statement around each core API function you add below\n\tvar patches = {\n\t\t'tinymce.util.JSON' : {\n\t\t\t/*serialize : function(o) {\n\t\t\t\treturn o.toJSON();\n\t\t\t}*/\n\t\t},\n\t};\n\n\t// Patch functions after a class is created\n\ttinymce.onCreate = function(ty, c, p) {\n\t\ttinymce.extend(p, patches[c]);\n\t};\n})();\n\n// #endif\n","Magento_Tinymce3/tiny_mce/classes/firebug/firebug-lite.js":"var firebug = {\n  version:[1.23,20090309],\n  el:{}, \n  env:{ \n    \"cache\":{},\n    \"extConsole\":null,\n    \"css\":\"http://getfirebug.com/releases/lite/1.2/firebug-lite.css\", \n    \"debug\":true,\n    \"detectFirebug\":true,\n    \"dIndex\":\"console\", \n    \"height\":295,\n    \"hideDOMFunctions\":false,\n    \"init\":false, \n    \"isPopup\":false,\n    \"liteFilename\":\"firebug-lite.js\",\n    \"minimized\":false,\n    \"openInPopup\": false,\n    \"override\":true,\n    \"ml\":false,\n    \"popupWin\":null,\n    \"showIconWhenHidden\":true,\n    \"targetWindow\":undefined,\n    \"popupTop\":1,\n    \"popupLeft\":1,\n    \"popupWidth\":undefined,\n    \"popupHeight\":undefined\n  },\n  initConsole:function(){\n    /* \n     * initialize the console - user defined values are not available within this method because FBLite is not yet initialized\n     */\n    var command;\n    try{\n      if((!window.console || (window.console && !window.console.firebug)) || (firebug.env.override && !(/Firefox\\/3/i.test(navigator.userAgent)))){\n        window.console = { \"provider\":\"Firebug Lite\" };\n\n        for(command in firebug.d.console.cmd){\n          window.console[command] = firebug.lib.util.Curry(firebug.d.console.run,window,command);\n        };\n      }\n      /*window.onerror = function(_message,_file,_line){\n        firebug.d.console.run('error',firebug.lib.util.String.format('{0} ({1},{2})',_message,firebug.getFileName(_file),_line));\n      };*/\n      } catch(e){}\n  },\n  overrideConsole:function(){\n    with (firebug){\n      env.override=true;\n      try{\n        env.extConsole=window.console;\n      } catch(e){}\n      initConsole();\n    }\n  },\n  restoreConsole:function(){\n    with(firebug){\n      if(env.extConsole){\n        env.override=false;\n        try{\n          window.console=env.extConsole;\n        } catch(e){}\n        env.extConsole=null;\n      }\n    }\n  },\n  init:function(_css){\n    var iconTitle = \"Click here or press F12, (CTRL|CMD)+SHIFT+L or SHIFT+ENTER to show Firebug Lite. CTRL|CMD click this icon to hide it.\";\n  \n    with(firebug){\n      if(document.getElementsByTagName('html')[0].attributes.getNamedItem('debug')){\n        env.debug = document.getElementsByTagName('html')[0].attributes.getNamedItem('debug').nodeValue !== \"false\";\n      }\n            \n      if(env.isPopup) {\n        env.openInPopup = false;\n        env.targetWindow = window.opener;\n        env.popupWidth = window.opener.firebug.env.popupWidth || window.opener.firebug.lib.util.GetViewport().width;\n        env.popupHeight = window.opener.firebug.env.popupHeight || window.opener.firebug.lib.util.GetViewport().height;\n      } else {\n        env.targetWindow = window;\n        env.popupWidth = env.popupWidth || lib.util.GetViewport().width;\n        env.popupHeight = env.popupHeight || lib.util.GetViewport().height;\n      }\n\n      settings.readCookie();\n      \n      if(env.init || (env.detectFirebug && window.console && window.console.firebug)) {\n        return;\n      }\n\n      document.getElementsByTagName(\"head\")[0].appendChild(\n        new lib.element(\"link\").attribute.set(\"rel\",\"stylesheet\").attribute.set(\"type\",\"text/css\").attribute.set(\"href\",env.css).element\n      );\n\n      if(env.override){\n        overrideConsole();\n      }\n      \n      /* \n       * Firebug Icon\n       */\n      el.firebugIcon = new lib.element(\"div\").attribute.set(\"id\",\"firebugIconDiv\").attribute.set(\"title\",iconTitle).attribute.set(\"alt\",iconTitle).event.addListener(\"mousedown\",win.iconClicked).insert(document.body);\n      \n      /* \n       * main interface\n       */\n      el.content = {};\n      el.mainiframe = new lib.element(\"IFRAME\").attribute.set(\"id\",\"FirebugIFrame\").environment.addStyle({ \"display\":\"none\", \"width\":lib.util.GetViewport().width+\"px\" }).insert(document.body);\n      el.main = new lib.element(\"DIV\").attribute.set(\"id\",\"Firebug\").environment.addStyle({ \"display\":\"none\", \"width\":lib.util.GetViewport().width+\"px\" }).insert(document.body);\n      if(!env.isPopup){\n        el.resizer = new lib.element(\"DIV\").attribute.addClass(\"Resizer\").event.addListener(\"mousedown\",win.resizer.start).insert(el.main);\n      }\n      el.header = ne