require.config({"config": {
        "jsbuild":{"jquery/ui-modules/widget.js":"/*!\n * jQuery UI Widget - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/jQuery.widget/\n */\n\ndefine([\n    'jquery'\n], function ($, undefined) {\n\n    var uuid = 0,\n        slice = Array.prototype.slice,\n        _cleanData = $.cleanData;\n    $.cleanData = function (elems) {\n        for (var i = 0, elem; (elem = elems[i]) != null; i++) {\n            try {\n                $(elem).triggerHandler(\"remove\");\n                // http://bugs.jquery.com/ticket/8235\n            } catch (e) {\n            }\n        }\n        _cleanData(elems);\n    };\n\n    $.widget = function (name, base, prototype) {\n        var fullName, existingConstructor, constructor, basePrototype,\n            // proxiedPrototype allows the provided prototype to remain unmodified\n            // so that it can be used as a mixin for multiple widgets (#8876)\n            proxiedPrototype = {},\n            namespace = name.split(\".\")[0];\n\n        name = name.split(\".\")[1];\n        fullName = namespace + \"-\" + name;\n\n        if (!prototype) {\n            prototype = base;\n            base = $.Widget;\n        }\n\n        // create selector for plugin\n        $.expr[\":\"][fullName.toLowerCase()] = function (elem) {\n            return !!$.data(elem, fullName);\n        };\n\n        $[namespace] = $[namespace] || {};\n        existingConstructor = $[namespace][name];\n        constructor = $[namespace][name] = function (options, element) {\n            // allow instantiation without \"new\" keyword\n            if (!this._createWidget) {\n                return new constructor(options, element);\n            }\n\n            // allow instantiation without initializing for simple inheritance\n            // must use \"new\" keyword (the code above always passes args)\n            if (arguments.length) {\n                this._createWidget(options, element);\n            }\n        };\n        // extend with the existing constructor to carry over any static properties\n        $.extend(constructor, existingConstructor, {\n            version: prototype.version,\n            // copy the object used to create the prototype in case we need to\n            // redefine the widget later\n            _proto: $.extend({}, prototype),\n            // track widgets that inherit from this widget in case this widget is\n            // redefined after a widget inherits from it\n            _childConstructors: []\n        });\n\n        basePrototype = new base();\n        // we need to make the options hash a property directly on the new instance\n        // otherwise we'll modify the options hash on the prototype that we're\n        // inheriting from\n        basePrototype.options = $.widget.extend({}, basePrototype.options);\n        $.each(prototype, function (prop, value) {\n            if (!$.isFunction(value)) {\n                proxiedPrototype[prop] = value;\n                return;\n            }\n            proxiedPrototype[prop] = (function () {\n                var _super = function () {\n                        return base.prototype[prop].apply(this, arguments);\n                    },\n                    _superApply = function (args) {\n                        return base.prototype[prop].apply(this, args);\n                    };\n                return function () {\n                    var __super = this._super,\n                        __superApply = this._superApply,\n                        returnValue;\n\n                    this._super = _super;\n                    this._superApply = _superApply;\n\n                    returnValue = value.apply(this, arguments);\n\n                    this._super = __super;\n                    this._superApply = __superApply;\n\n                    return returnValue;\n                };\n            })();\n        });\n        constructor.prototype = $.widget.extend(basePrototype, {\n            // TODO: remove support for widgetEventPrefix\n            // always use the name + a colon as the prefix, e.g., draggable:start\n            // don't prefix for widgets that aren't DOM-based\n            widgetEventPrefix: existingConstructor ? (basePrototype.widgetEventPrefix || name) : name\n        }, proxiedPrototype, {\n            constructor: constructor,\n            namespace: namespace,\n            widgetName: name,\n            widgetFullName: fullName\n        });\n\n        // If this widget is being redefined then we need to find all widgets that\n        // are inheriting from it and redefine all of them so that they inherit from\n        // the new version of this widget. We're essentially trying to replace one\n        // level in the prototype chain.\n        if (existingConstructor) {\n            $.each(existingConstructor._childConstructors, function (i, child) {\n                var childPrototype = child.prototype;\n\n                // redefine the child widget using the same prototype that was\n                // originally used, but inherit from the new version of the base\n                $.widget(childPrototype.namespace + \".\" + childPrototype.widgetName, constructor, child._proto);\n            });\n            // remove the list of existing child constructors from the old constructor\n            // so the old child constructors can be garbage collected\n            delete existingConstructor._childConstructors;\n        } else {\n            base._childConstructors.push(constructor);\n        }\n\n        $.widget.bridge(name, constructor);\n    };\n\n    $.widget.extend = function (target) {\n        var input = slice.call(arguments, 1),\n            inputIndex = 0,\n            inputLength = input.length,\n            key,\n            value;\n        for (; inputIndex < inputLength; inputIndex++) {\n            for (key in input[inputIndex]) {\n                value = input[inputIndex][key];\n                if (input[inputIndex].hasOwnProperty(key) && value !== undefined) {\n                    // Clone objects\n                    if ($.isPlainObject(value)) {\n                        target[key] = $.isPlainObject(target[key]) ?\n                            $.widget.extend({}, target[key], value) :\n                            // Don't extend strings, arrays, etc. with objects\n                            $.widget.extend({}, value);\n                        // Copy everything else by reference\n                    } else {\n                        target[key] = value;\n                    }\n                }\n            }\n        }\n        return target;\n    };\n\n    $.widget.bridge = function (name, object) {\n        var fullName = object.prototype.widgetFullName || name;\n        $.fn[name] = function (options) {\n            var isMethodCall = typeof options === \"string\",\n                args = slice.call(arguments, 1),\n                returnValue = this;\n\n            // allow multiple hashes to be passed on init\n            options = !isMethodCall && args.length ?\n                $.widget.extend.apply(null, [options].concat(args)) :\n                options;\n\n            if (isMethodCall) {\n                this.each(function () {\n                    var methodValue,\n                        instance = $.data(this, fullName);\n                    if (!instance) {\n                        return $.error(\"cannot call methods on \" + name + \" prior to initialization; \" +\n                            \"attempted to call method '\" + options + \"'\");\n                    }\n                    if (!$.isFunction(instance[options]) || options.charAt(0) === \"_\") {\n                        return $.error(\"no such method '\" + options + \"' for \" + name + \" widget instance\");\n                    }\n                    methodValue = instance[options].apply(instance, args);\n                    if (methodValue !== instance && methodValue !== undefined) {\n                        returnValue = methodValue && methodValue.jquery ?\n                            returnValue.pushStack(methodValue.get()) :\n                            methodValue;\n                        return false;\n                    }\n                });\n            } else {\n                this.each(function () {\n                    var instance = $.data(this, fullName);\n                    if (instance) {\n                        instance.option(options || {})._init();\n                    } else {\n                        $.data(this, fullName, new object(options, this));\n                    }\n                });\n            }\n\n            return returnValue;\n        };\n    };\n\n    $.Widget = function ( /* options, element */) {\n    };\n    $.Widget._childConstructors = [];\n\n    $.Widget.prototype = {\n        widgetName: \"widget\",\n        widgetEventPrefix: \"\",\n        defaultElement: \"<div>\",\n        options: {\n            disabled: false,\n\n            // callbacks\n            create: null\n        },\n        _createWidget: function (options, element) {\n            element = $(element || this.defaultElement || this)[0];\n            this.element = $(element);\n            this.uuid = uuid++;\n            this.eventNamespace = \".\" + this.widgetName + this.uuid;\n            this.options = $.widget.extend({},\n                this.options,\n                this._getCreateOptions(),\n                options);\n\n            this.bindings = $();\n            this.hoverable = $();\n            this.focusable = $();\n\n            if (element !== this) {\n                $.data(element, this.widgetFullName, this);\n                this._on(true, this.element, {\n                    remove: function (event) {\n                        if (event.target === element) {\n                            this.destroy();\n                        }\n                    }\n                });\n                this.document = $(element.style ?\n                    // element within the document\n                    element.ownerDocument :\n                    // element is window or document\n                    element.document || element);\n                this.window = $(this.document[0].defaultView || this.document[0].parentWindow);\n            }\n\n            this._create();\n            this._trigger(\"create\", null, this._getCreateEventData());\n            this._init();\n        },\n        _getCreateOptions: $.noop,\n        _getCreateEventData: $.noop,\n        _create: $.noop,\n        _init: $.noop,\n\n        destroy: function () {\n            this._destroy();\n            // we can probably remove the unbind calls in 2.0\n            // all event bindings should go through this._on()\n            this.element\n                .unbind(this.eventNamespace)\n                // 1.9 BC for #7810\n                // TODO remove dual storage\n                .removeData(this.widgetName)\n                .removeData(this.widgetFullName)\n                // support: jquery <1.6.3\n                // http://bugs.jquery.com/ticket/9413\n                .removeData($.camelCase(this.widgetFullName));\n            this.widget()\n                .unbind(this.eventNamespace)\n                .removeAttr(\"aria-disabled\")\n                .removeClass(\n                    this.widgetFullName + \"-disabled \" +\n                    \"ui-state-disabled\");\n\n            // clean up events and states\n            this.bindings.unbind(this.eventNamespace);\n            this.hoverable.removeClass(\"ui-state-hover\");\n            this.focusable.removeClass(\"ui-state-focus\");\n        },\n        _destroy: $.noop,\n\n        widget: function () {\n            return this.element;\n        },\n\n        option: function (key, value) {\n            var options = key,\n                parts,\n                curOption,\n                i;\n\n            if (arguments.length === 0) {\n                // don't return a reference to the internal hash\n                return $.widget.extend({}, this.options);\n            }\n\n            if (typeof key === \"string\") {\n                // handle nested keys, e.g., \"foo.bar\" => { foo: { bar: ___ } }\n                options = {};\n                parts = key.split(\".\");\n                key = parts.shift();\n                if (parts.length) {\n                    curOption = options[key] = $.widget.extend({}, this.options[key]);\n                    for (i = 0; i < parts.length - 1; i++) {\n                        curOption[parts[i]] = curOption[parts[i]] || {};\n                        curOption = curOption[parts[i]];\n                    }\n                    key = parts.pop();\n                    if (arguments.length === 1) {\n                        return curOption[key] === undefined ? null : curOption[key];\n                    }\n                    curOption[key] = value;\n                } else {\n                    if (arguments.length === 1) {\n                        return this.options[key] === undefined ? null : this.options[key];\n                    }\n                    options[key] = value;\n                }\n            }\n\n            this._setOptions(options);\n\n            return this;\n        },\n        _setOptions: function (options) {\n            var key;\n\n            for (key in options) {\n                this._setOption(key, options[key]);\n            }\n\n            return this;\n        },\n        _setOption: function (key, value) {\n            this.options[key] = value;\n\n            if (key === \"disabled\") {\n                this.widget()\n                    .toggleClass(this.widgetFullName + \"-disabled ui-state-disabled\", !!value)\n                    .attr(\"aria-disabled\", value);\n                this.hoverable.removeClass(\"ui-state-hover\");\n                this.focusable.removeClass(\"ui-state-focus\");\n            }\n\n            return this;\n        },\n\n        enable: function () {\n            return this._setOption(\"disabled\", false);\n        },\n        disable: function () {\n            return this._setOption(\"disabled\", true);\n        },\n\n        _on: function (suppressDisabledCheck, element, handlers) {\n            var delegateElement,\n                instance = this;\n\n            // no suppressDisabledCheck flag, shuffle arguments\n            if (typeof suppressDisabledCheck !== \"boolean\") {\n                handlers = element;\n                element = suppressDisabledCheck;\n                suppressDisabledCheck = false;\n            }\n\n            // no element argument, shuffle and use this.element\n            if (!handlers) {\n                handlers = element;\n                element = this.element;\n                delegateElement = this.widget();\n            } else {\n                // accept selectors, DOM elements\n                element = delegateElement = $(element);\n                this.bindings = this.bindings.add(element);\n            }\n\n            $.each(handlers, function (event, handler) {\n                function handlerProxy() {\n                    // allow widgets to customize the disabled handling\n                    // - disabled as an array instead of boolean\n                    // - disabled class as method for disabling individual parts\n                    if (!suppressDisabledCheck &&\n                        (instance.options.disabled === true ||\n                            $(this).hasClass(\"ui-state-disabled\"))) {\n                        return;\n                    }\n                    return (typeof handler === \"string\" ? instance[handler] : handler)\n                        .apply(instance, arguments);\n                }\n\n                // copy the guid so direct unbinding works\n                if (typeof handler !== \"string\") {\n                    handlerProxy.guid = handler.guid =\n                        handler.guid || handlerProxy.guid || $.guid++;\n                }\n\n                var match = event.match(/^(\\w+)\\s*(.*)$/),\n                    eventName = match[1] + instance.eventNamespace,\n                    selector = match[2];\n                if (selector) {\n                    delegateElement.delegate(selector, eventName, handlerProxy);\n                } else {\n                    element.bind(eventName, handlerProxy);\n                }\n            });\n        },\n\n        _off: function (element, eventName) {\n            eventName = (eventName || \"\").split(\" \").join(this.eventNamespace + \" \") + this.eventNamespace;\n            element.unbind(eventName).undelegate(eventName);\n        },\n\n        _delay: function (handler, delay) {\n            function handlerProxy() {\n                return (typeof handler === \"string\" ? instance[handler] : handler)\n                    .apply(instance, arguments);\n            }\n\n            var instance = this;\n            return setTimeout(handlerProxy, delay || 0);\n        },\n\n        _hoverable: function (element) {\n            this.hoverable = this.hoverable.add(element);\n            this._on(element, {\n                mouseenter: function (event) {\n                    $(event.currentTarget).addClass(\"ui-state-hover\");\n                },\n                mouseleave: function (event) {\n                    $(event.currentTarget).removeClass(\"ui-state-hover\");\n                }\n            });\n        },\n\n        _focusable: function (element) {\n            this.focusable = this.focusable.add(element);\n            this._on(element, {\n                focusin: function (event) {\n                    $(event.currentTarget).addClass(\"ui-state-focus\");\n                },\n                focusout: function (event) {\n                    $(event.currentTarget).removeClass(\"ui-state-focus\");\n                }\n            });\n        },\n\n        _trigger: function (type, event, data) {\n            var prop, orig,\n                callback = this.options[type];\n\n            data = data || {};\n            event = $.Event(event);\n            event.type = (type === this.widgetEventPrefix ?\n                type :\n                this.widgetEventPrefix + type).toLowerCase();\n            // the original event may come from any element\n            // so we need to reset the target on the new event\n            event.target = this.element[0];\n\n            // copy original event properties over to the new event\n            orig = event.originalEvent;\n            if (orig) {\n                for (prop in orig) {\n                    if (!(prop in event)) {\n                        event[prop] = orig[prop];\n                    }\n                }\n            }\n\n            this.element.trigger(event, data);\n            return !($.isFunction(callback) &&\n                callback.apply(this.element[0], [event].concat(data)) === false ||\n                event.isDefaultPrevented());\n        }\n    };\n\n    $.each({show: \"fadeIn\", hide: \"fadeOut\"}, function (method, defaultEffect) {\n        $.Widget.prototype[\"_\" + method] = function (element, options, callback) {\n            if (typeof options === \"string\") {\n                options = {effect: options};\n            }\n            var hasOptions,\n                effectName = !options ?\n                    method :\n                    options === true || typeof options === \"number\" ?\n                        defaultEffect :\n                        options.effect || defaultEffect;\n            options = options || {};\n            if (typeof options === \"number\") {\n                options = {duration: options};\n            }\n            hasOptions = !$.isEmptyObject(options);\n            options.complete = callback;\n            if (options.delay) {\n                element.delay(options.delay);\n            }\n            if (hasOptions && $.effects && $.effects.effect[effectName]) {\n                element[method](options);\n            } else if (effectName !== method && element[effectName]) {\n                element[effectName](options.duration, options.easing, callback);\n            } else {\n                element.queue(function (next) {\n                    $(this)[method]();\n                    if (callback) {\n                        callback.call(element[0]);\n                    }\n                    next();\n                });\n            }\n        };\n    });\n\n});\n","jquery/ui-modules/effect-bounce.js":"/*!\n * jQuery UI Effects Bounce - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/bounce-effect/\n *\n * Depends:\n *\tjquery.ui.effect.js\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.bounce = function (o, done) {\n        var el = $(this),\n            props = [\"position\", \"top\", \"bottom\", \"left\", \"right\", \"height\", \"width\"],\n\n            // defaults:\n            mode = $.effects.setMode(el, o.mode || \"effect\"),\n            hide = mode === \"hide\",\n            show = mode === \"show\",\n            direction = o.direction || \"up\",\n            distance = o.distance,\n            times = o.times || 5,\n\n            // number of internal animations\n            anims = times * 2 + (show || hide ? 1 : 0),\n            speed = o.duration / anims,\n            easing = o.easing,\n\n            // utility:\n            ref = (direction === \"up\" || direction === \"down\") ? \"top\" : \"left\",\n            motion = (direction === \"up\" || direction === \"left\"),\n            i,\n            upAnim,\n            downAnim,\n\n            // we will need to re-assemble the queue to stack our animations in place\n            queue = el.queue(),\n            queuelen = queue.length;\n\n        // Avoid touching opacity to prevent clearType and PNG issues in IE\n        if (show || hide) {\n            props.push(\"opacity\");\n        }\n\n        $.effects.save(el, props);\n        el.show();\n        $.effects.createWrapper(el); // Create Wrapper\n\n        // default distance for the BIGGEST bounce is the outer Distance / 3\n        if (!distance) {\n            distance = el[ref === \"top\" ? \"outerHeight\" : \"outerWidth\"]() / 3;\n        }\n\n        if (show) {\n            downAnim = {opacity: 1};\n            downAnim[ref] = 0;\n\n            // if we are showing, force opacity 0 and set the initial position\n            // then do the \"first\" animation\n            el.css(\"opacity\", 0)\n                .css(ref, motion ? -distance * 2 : distance * 2)\n                .animate(downAnim, speed, easing);\n        }\n\n        // start at the smallest distance if we are hiding\n        if (hide) {\n            distance = distance / Math.pow(2, times - 1);\n        }\n\n        downAnim = {};\n        downAnim[ref] = 0;\n        // Bounces up/down/left/right then back to 0 -- times * 2 animations happen here\n        for (i = 0; i < times; i++) {\n            upAnim = {};\n            upAnim[ref] = (motion ? \"-=\" : \"+=\") + distance;\n\n            el.animate(upAnim, speed, easing)\n                .animate(downAnim, speed, easing);\n\n            distance = hide ? distance * 2 : distance / 2;\n        }\n\n        // Last Bounce when Hiding\n        if (hide) {\n            upAnim = {opacity: 0};\n            upAnim[ref] = (motion ? \"-=\" : \"+=\") + distance;\n\n            el.animate(upAnim, speed, easing);\n        }\n\n        el.queue(function () {\n            if (hide) {\n                el.hide();\n            }\n            $.effects.restore(el, props);\n            $.effects.removeWrapper(el);\n            done();\n        });\n\n        // inject all the animations we just queued to be first in line (after \"inprogress\")\n        if (queuelen > 1) {\n            queue.splice.apply(queue,\n                [1, 0].concat(queue.splice(queuelen, anims + 1)));\n        }\n        el.dequeue();\n\n    };\n\n});\n","jquery/ui-modules/slider.js":"/*!\n * jQuery UI Slider - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/slider/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/mouse'\n], function ($, undefined) {\n\n// number of pages in a slider\n// (how many times can you page up/down to go through the whole range)\n    var numPages = 5;\n\n    $.widget(\"ui.slider\", $.ui.mouse, {\n        version: \"1.10.4\",\n        widgetEventPrefix: \"slide\",\n\n        options: {\n            animate: false,\n            distance: 0,\n            max: 100,\n            min: 0,\n            orientation: \"horizontal\",\n            range: false,\n            step: 1,\n            value: 0,\n            values: null,\n\n            // callbacks\n            change: null,\n            slide: null,\n            start: null,\n            stop: null\n        },\n\n        _create: function () {\n            this._keySliding = false;\n            this._mouseSliding = false;\n            this._animateOff = true;\n            this._handleIndex = null;\n            this._detectOrientation();\n            this._mouseInit();\n\n            this.element\n                .addClass(\"ui-slider\" +\n                    \" ui-slider-\" + this.orientation +\n                    \" ui-widget\" +\n                    \" ui-widget-content\" +\n                    \" ui-corner-all\");\n\n            this._refresh();\n            this._setOption(\"disabled\", this.options.disabled);\n\n            this._animateOff = false;\n        },\n\n        _refresh: function () {\n            this._createRange();\n            this._createHandles();\n            this._setupEvents();\n            this._refreshValue();\n        },\n\n        _createHandles: function () {\n            var i, handleCount,\n                options = this.options,\n                existingHandles = this.element.find(\".ui-slider-handle\").addClass(\"ui-state-default ui-corner-all\"),\n                handle = \"<a class='ui-slider-handle ui-state-default ui-corner-all' href='#'></a>\",\n                handles = [];\n\n            handleCount = (options.values && options.values.length) || 1;\n\n            if (existingHandles.length > handleCount) {\n                existingHandles.slice(handleCount).remove();\n                existingHandles = existingHandles.slice(0, handleCount);\n            }\n\n            for (i = existingHandles.length; i < handleCount; i++) {\n                handles.push(handle);\n            }\n\n            this.handles = existingHandles.add($(handles.join(\"\")).appendTo(this.element));\n\n            this.handle = this.handles.eq(0);\n\n            this.handles.each(function (i) {\n                $(this).data(\"ui-slider-handle-index\", i);\n            });\n        },\n\n        _createRange: function () {\n            var options = this.options,\n                classes = \"\";\n\n            if (options.range) {\n                if (options.range === true) {\n                    if (!options.values) {\n                        options.values = [this._valueMin(), this._valueMin()];\n                    } else if (options.values.length && options.values.length !== 2) {\n                        options.values = [options.values[0], options.values[0]];\n                    } else if ($.isArray(options.values)) {\n                        options.values = options.values.slice(0);\n                    }\n                }\n\n                if (!this.range || !this.range.length) {\n                    this.range = $(\"<div></div>\")\n                        .appendTo(this.element);\n\n                    classes = \"ui-slider-range\" +\n                        // note: this isn't the most fittingly semantic framework class for this element,\n                        // but worked best visually with a variety of themes\n                        \" ui-widget-header ui-corner-all\";\n                } else {\n                    this.range.removeClass(\"ui-slider-range-min ui-slider-range-max\")\n                    // Handle range switching from true to min/max\n                        .css({\n                            \"left\": \"\",\n                            \"bottom\": \"\"\n                        });\n                }\n\n                this.range.addClass(classes +\n                    ((options.range === \"min\" || options.range === \"max\") ? \" ui-slider-range-\" + options.range : \"\"));\n            } else {\n                if (this.range) {\n                    this.range.remove();\n                }\n                this.range = null;\n            }\n        },\n\n        _setupEvents: function () {\n            var elements = this.handles.add(this.range).filter(\"a\");\n            this._off(elements);\n            this._on(elements, this._handleEvents);\n            this._hoverable(elements);\n            this._focusable(elements);\n        },\n\n        _destroy: function () {\n            this.handles.remove();\n            if (this.range) {\n                this.range.remove();\n            }\n\n            this.element\n                .removeClass(\"ui-slider\" +\n                    \" ui-slider-horizontal\" +\n                    \" ui-slider-vertical\" +\n                    \" ui-widget\" +\n                    \" ui-widget-content\" +\n                    \" ui-corner-all\");\n\n            this._mouseDestroy();\n        },\n\n        _mouseCapture: function (event) {\n            var position, normValue, distance, closestHandle, index, allowed, offset, mouseOverHandle,\n                that = this,\n                o = this.options;\n\n            if (o.disabled) {\n                return false;\n            }\n\n            this.elementSize = {\n                width: this.element.outerWidth(),\n                height: this.element.outerHeight()\n            };\n            this.elementOffset = this.element.offset();\n\n            position = {x: event.pageX, y: event.pageY};\n            normValue = this._normValueFromMouse(position);\n            distance = this._valueMax() - this._valueMin() + 1;\n            this.handles.each(function (i) {\n                var thisDistance = Math.abs(normValue - that.values(i));\n                if ((distance > thisDistance) ||\n                    (distance === thisDistance &&\n                        (i === that._lastChangedValue || that.values(i) === o.min))) {\n                    distance = thisDistance;\n                    closestHandle = $(this);\n                    index = i;\n                }\n            });\n\n            allowed = this._start(event, index);\n            if (allowed === false) {\n                return false;\n            }\n            this._mouseSliding = true;\n\n            this._handleIndex = index;\n\n            closestHandle\n                .addClass(\"ui-state-active\")\n                .focus();\n\n            offset = closestHandle.offset();\n            mouseOverHandle = !$(event.target).parents().addBack().is(\".ui-slider-handle\");\n            this._clickOffset = mouseOverHandle ? {left: 0, top: 0} : {\n                left: event.pageX - offset.left - (closestHandle.width() / 2),\n                top: event.pageY - offset.top -\n                    (closestHandle.height() / 2) -\n                    (parseInt(closestHandle.css(\"borderTopWidth\"), 10) || 0) -\n                    (parseInt(closestHandle.css(\"borderBottomWidth\"), 10) || 0) +\n                    (parseInt(closestHandle.css(\"marginTop\"), 10) || 0)\n            };\n\n            if (!this.handles.hasClass(\"ui-state-hover\")) {\n                this._slide(event, index, normValue);\n            }\n            this._animateOff = true;\n            return true;\n        },\n\n        _mouseStart: function () {\n            return true;\n        },\n\n        _mouseDrag: function (event) {\n            var position = {x: event.pageX, y: event.pageY},\n                normValue = this._normValueFromMouse(position);\n\n            this._slide(event, this._handleIndex, normValue);\n\n            return false;\n        },\n\n        _mouseStop: function (event) {\n            this.handles.removeClass(\"ui-state-active\");\n            this._mouseSliding = false;\n\n            this._stop(event, this._handleIndex);\n            this._change(event, this._handleIndex);\n\n            this._handleIndex = null;\n            this._clickOffset = null;\n            this._animateOff = false;\n\n            return false;\n        },\n\n        _detectOrientation: function () {\n            this.orientation = (this.options.orientation === \"vertical\") ? \"vertical\" : \"horizontal\";\n        },\n\n        _normValueFromMouse: function (position) {\n            var pixelTotal,\n                pixelMouse,\n                percentMouse,\n                valueTotal,\n                valueMouse;\n\n            if (this.orientation === \"horizontal\") {\n                pixelTotal = this.elementSize.width;\n                pixelMouse = position.x - this.elementOffset.left - (this._clickOffset ? this._clickOffset.left : 0);\n            } else {\n                pixelTotal = this.elementSize.height;\n                pixelMouse = position.y - this.elementOffset.top - (this._clickOffset ? this._clickOffset.top : 0);\n            }\n\n            percentMouse = (pixelMouse / pixelTotal);\n            if (percentMouse > 1) {\n                percentMouse = 1;\n            }\n            if (percentMouse < 0) {\n                percentMouse = 0;\n            }\n            if (this.orientation === \"vertical\") {\n                percentMouse = 1 - percentMouse;\n            }\n\n            valueTotal = this._valueMax() - this._valueMin();\n            valueMouse = this._valueMin() + percentMouse * valueTotal;\n\n            return this._trimAlignValue(valueMouse);\n        },\n\n        _start: function (event, index) {\n            var uiHash = {\n                handle: this.handles[index],\n                value: this.value()\n            };\n            if (this.options.values && this.options.values.length) {\n                uiHash.value = this.values(index);\n                uiHash.values = this.values();\n            }\n            return this._trigger(\"start\", event, uiHash);\n        },\n\n        _slide: function (event, index, newVal) {\n            var otherVal,\n                newValues,\n                allowed;\n\n            if (this.options.values && this.options.values.length) {\n                otherVal = this.values(index ? 0 : 1);\n\n                if ((this.options.values.length === 2 && this.options.range === true) &&\n                    ((index === 0 && newVal > otherVal) || (index === 1 && newVal < otherVal))\n                ) {\n                    newVal = otherVal;\n                }\n\n                if (newVal !== this.values(index)) {\n                    newValues = this.values();\n                    newValues[index] = newVal;\n                    // A slide can be canceled by returning false from the slide callback\n                    allowed = this._trigger(\"slide\", event, {\n                        handle: this.handles[index],\n                        value: newVal,\n                        values: newValues\n                    });\n                    otherVal = this.values(index ? 0 : 1);\n                    if (allowed !== false) {\n                        this.values(index, newVal);\n                    }\n                }\n            } else {\n                if (newVal !== this.value()) {\n                    // A slide can be canceled by returning false from the slide callback\n                    allowed = this._trigger(\"slide\", event, {\n                        handle: this.handles[index],\n                        value: newVal\n                    });\n                    if (allowed !== false) {\n                        this.value(newVal);\n                    }\n                }\n            }\n        },\n\n        _stop: function (event, index) {\n            var uiHash = {\n                handle: this.handles[index],\n                value: this.value()\n            };\n            if (this.options.values && this.options.values.length) {\n                uiHash.value = this.values(index);\n                uiHash.values = this.values();\n            }\n\n            this._trigger(\"stop\", event, uiHash);\n        },\n\n        _change: function (event, index) {\n            if (!this._keySliding && !this._mouseSliding) {\n                var uiHash = {\n                    handle: this.handles[index],\n                    value: this.value()\n                };\n                if (this.options.values && this.options.values.length) {\n                    uiHash.value = this.values(index);\n                    uiHash.values = this.values();\n                }\n\n                //store the last changed value index for reference when handles overlap\n                this._lastChangedValue = index;\n\n                this._trigger(\"change\", event, uiHash);\n            }\n        },\n\n        value: function (newValue) {\n            if (arguments.length) {\n                this.options.value = this._trimAlignValue(newValue);\n                this._refreshValue();\n                this._change(null, 0);\n                return;\n            }\n\n            return this._value();\n        },\n\n        values: function (index, newValue) {\n            var vals,\n                newValues,\n                i;\n\n            if (arguments.length > 1) {\n                this.options.values[index] = this._trimAlignValue(newValue);\n                this._refreshValue();\n                this._change(null, index);\n                return;\n            }\n\n            if (arguments.length) {\n                if ($.isArray(arguments[0])) {\n                    vals = this.options.values;\n                    newValues = arguments[0];\n                    for (i = 0; i < vals.length; i += 1) {\n                        vals[i] = this._trimAlignValue(newValues[i]);\n                        this._change(null, i);\n                    }\n                    this._refreshValue();\n                } else {\n                    if (this.options.values && this.options.values.length) {\n                        return this._values(index);\n                    } else {\n                        return this.value();\n                    }\n                }\n            } else {\n                return this._values();\n            }\n        },\n\n        _setOption: function (key, value) {\n            var i,\n                valsLength = 0;\n\n            if (key === \"range\" && this.options.range === true) {\n                if (value === \"min\") {\n                    this.options.value = this._values(0);\n                    this.options.values = null;\n                } else if (value === \"max\") {\n                    this.options.value = this._values(this.options.values.length - 1);\n                    this.options.values = null;\n                }\n            }\n\n            if ($.isArray(this.options.values)) {\n                valsLength = this.options.values.length;\n            }\n\n            $.Widget.prototype._setOption.apply(this, arguments);\n\n            switch (key) {\n                case \"orientation\":\n                    this._detectOrientation();\n                    this.element\n                        .removeClass(\"ui-slider-horizontal ui-slider-vertical\")\n                        .addClass(\"ui-slider-\" + this.orientation);\n                    this._refreshValue();\n                    break;\n                case \"value\":\n                    this._animateOff = true;\n                    this._refreshValue();\n                    this._change(null, 0);\n                    this._animateOff = false;\n                    break;\n                case \"values\":\n                    this._animateOff = true;\n                    this._refreshValue();\n                    for (i = 0; i < valsLength; i += 1) {\n                        this._change(null, i);\n                    }\n                    this._animateOff = false;\n                    break;\n                case \"min\":\n                case \"max\":\n                    this._animateOff = true;\n                    this._refreshValue();\n                    this._animateOff = false;\n                    break;\n                case \"range\":\n                    this._animateOff = true;\n                    this._refresh();\n                    this._animateOff = false;\n                    break;\n            }\n        },\n\n        //internal value getter\n        // _value() returns value trimmed by min and max, aligned by step\n        _value: function () {\n            var val = this.options.value;\n            val = this._trimAlignValue(val);\n\n            return val;\n        },\n\n        //internal values getter\n        // _values() returns array of values trimmed by min and max, aligned by step\n        // _values( index ) returns single value trimmed by min and max, aligned by step\n        _values: function (index) {\n            var val,\n                vals,\n                i;\n\n            if (arguments.length) {\n                val = this.options.values[index];\n                val = this._trimAlignValue(val);\n\n                return val;\n            } else if (this.options.values && this.options.values.length) {\n                // .slice() creates a copy of the array\n                // this copy gets trimmed by min and max and then returned\n                vals = this.options.values.slice();\n                for (i = 0; i < vals.length; i += 1) {\n                    vals[i] = this._trimAlignValue(vals[i]);\n                }\n\n                return vals;\n            } else {\n                return [];\n            }\n        },\n\n        // returns the step-aligned value that val is closest to, between (inclusive) min and max\n        _trimAlignValue: function (val) {\n            if (val <= this._valueMin()) {\n                return this._valueMin();\n            }\n            if (val >= this._valueMax()) {\n                return this._valueMax();\n            }\n            var step = (this.options.step > 0) ? this.options.step : 1,\n                valModStep = (val - this._valueMin()) % step,\n                alignValue = val - valModStep;\n\n            if (Math.abs(valModStep) * 2 >= step) {\n                alignValue += (valModStep > 0) ? step : (-step);\n            }\n\n            // Since JavaScript has problems with large floats, round\n            // the final value to 5 digits after the decimal point (see #4124)\n            return parseFloat(alignValue.toFixed(5));\n        },\n\n        _valueMin: function () {\n            return this.options.min;\n        },\n\n        _valueMax: function () {\n            return this.options.max;\n        },\n\n        _refreshValue: function () {\n            var lastValPercent, valPercent, value, valueMin, valueMax,\n                oRange = this.options.range,\n                o = this.options,\n                that = this,\n                animate = (!this._animateOff) ? o.animate : false,\n                _set = {};\n\n            if (this.options.values && this.options.values.length) {\n                this.handles.each(function (i) {\n                    valPercent = (that.values(i) - that._valueMin()) / (that._valueMax() - that._valueMin()) * 100;\n                    _set[that.orientation === \"horizontal\" ? \"left\" : \"bottom\"] = valPercent + \"%\";\n                    $(this).stop(1, 1)[animate ? \"animate\" : \"css\"](_set, o.animate);\n                    if (that.options.range === true) {\n                        if (that.orientation === \"horizontal\") {\n                            if (i === 0) {\n                                that.range.stop(1, 1)[animate ? \"animate\" : \"css\"]({left: valPercent + \"%\"}, o.animate);\n                            }\n                            if (i === 1) {\n                                that.range[animate ? \"animate\" : \"css\"]({width: (valPercent - lastValPercent) + \"%\"}, {\n                                    queue: false,\n                                    duration: o.animate\n                                });\n                            }\n                        } else {\n                            if (i === 0) {\n                                that.range.stop(1, 1)[animate ? \"animate\" : \"css\"]({bottom: (valPercent) + \"%\"}, o.animate);\n                            }\n                            if (i === 1) {\n                                that.range[animate ? \"animate\" : \"css\"]({height: (valPercent - lastValPercent) + \"%\"}, {\n                                    queue: false,\n                                    duration: o.animate\n                                });\n                            }\n                        }\n                    }\n                    lastValPercent = valPercent;\n                });\n            } else {\n                value = this.value();\n                valueMin = this._valueMin();\n                valueMax = this._valueMax();\n                valPercent = (valueMax !== valueMin) ?\n                    (value - valueMin) / (valueMax - valueMin) * 100 :\n                    0;\n                _set[this.orientation === \"horizontal\" ? \"left\" : \"bottom\"] = valPercent + \"%\";\n                this.handle.stop(1, 1)[animate ? \"animate\" : \"css\"](_set, o.animate);\n\n                if (oRange === \"min\" && this.orientation === \"horizontal\") {\n                    this.range.stop(1, 1)[animate ? \"animate\" : \"css\"]({width: valPercent + \"%\"}, o.animate);\n                }\n                if (oRange === \"max\" && this.orientation === \"horizontal\") {\n                    this.range[animate ? \"animate\" : \"css\"]({width: (100 - valPercent) + \"%\"}, {\n                        queue: false,\n                        duration: o.animate\n                    });\n                }\n                if (oRange === \"min\" && this.orientation === \"vertical\") {\n                    this.range.stop(1, 1)[animate ? \"animate\" : \"css\"]({height: valPercent + \"%\"}, o.animate);\n                }\n                if (oRange === \"max\" && this.orientation === \"vertical\") {\n                    this.range[animate ? \"animate\" : \"css\"]({height: (100 - valPercent) + \"%\"}, {\n                        queue: false,\n                        duration: o.animate\n                    });\n                }\n            }\n        },\n\n        _handleEvents: {\n            keydown: function (event) {\n                var allowed, curVal, newVal, step,\n                    index = $(event.target).data(\"ui-slider-handle-index\");\n\n                switch (event.keyCode) {\n                    case $.ui.keyCode.HOME:\n                    case $.ui.keyCode.END:\n                    case $.ui.keyCode.PAGE_UP:\n                    case $.ui.keyCode.PAGE_DOWN:\n                    case $.ui.keyCode.UP:\n                    case $.ui.keyCode.RIGHT:\n                    case $.ui.keyCode.DOWN:\n                    case $.ui.keyCode.LEFT:\n                        event.preventDefault();\n                        if (!this._keySliding) {\n                            this._keySliding = true;\n                            $(event.target).addClass(\"ui-state-active\");\n                            allowed = this._start(event, index);\n                            if (allowed === false) {\n                                return;\n                            }\n                        }\n                        break;\n                }\n\n                step = this.options.step;\n                if (this.options.values && this.options.values.length) {\n                    curVal = newVal = this.values(index);\n                } else {\n                    curVal = newVal = this.value();\n                }\n\n                switch (event.keyCode) {\n                    case $.ui.keyCode.HOME:\n                        newVal = this._valueMin();\n                        break;\n                    case $.ui.keyCode.END:\n                        newVal = this._valueMax();\n                        break;\n                    case $.ui.keyCode.PAGE_UP:\n                        newVal = this._trimAlignValue(curVal + ((this._valueMax() - this._valueMin()) / numPages));\n                        break;\n                    case $.ui.keyCode.PAGE_DOWN:\n                        newVal = this._trimAlignValue(curVal - ((this._valueMax() - this._valueMin()) / numPages));\n                        break;\n                    case $.ui.keyCode.UP:\n                    case $.ui.keyCode.RIGHT:\n                        if (curVal === this._valueMax()) {\n                            return;\n                        }\n                        newVal = this._trimAlignValue(curVal + step);\n                        break;\n                    case $.ui.keyCode.DOWN:\n                    case $.ui.keyCode.LEFT:\n                        if (curVal === this._valueMin()) {\n                            return;\n                        }\n                        newVal = this._trimAlignValue(curVal - step);\n                        break;\n                }\n\n                this._slide(event, index, newVal);\n            },\n            click: function (event) {\n                event.preventDefault();\n            },\n            keyup: function (event) {\n                var index = $(event.target).data(\"ui-slider-handle-index\");\n\n                if (this._keySliding) {\n                    this._keySliding = false;\n                    this._stop(event, index);\n                    this._change(event, index);\n                    $(event.target).removeClass(\"ui-state-active\");\n                }\n            }\n        }\n\n    });\n\n});\n","jquery/ui-modules/autocomplete.js":"/*!\n * jQuery UI Autocomplete - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/autocomplete/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/menu'\n], function ($, undefined) {\n\n    $.widget(\"ui.autocomplete\", {\n        version: \"1.10.4\",\n        defaultElement: \"<input>\",\n        options: {\n            appendTo: null,\n            autoFocus: false,\n            delay: 300,\n            minLength: 1,\n            position: {\n                my: \"left top\",\n                at: \"left bottom\",\n                collision: \"none\"\n            },\n            source: null,\n\n            // callbacks\n            change: null,\n            close: null,\n            focus: null,\n            open: null,\n            response: null,\n            search: null,\n            select: null\n        },\n\n        requestIndex: 0,\n        pending: 0,\n\n        _create: function () {\n            // Some browsers only repeat keydown events, not keypress events,\n            // so we use the suppressKeyPress flag to determine if we've already\n            // handled the keydown event. #7269\n            // Unfortunately the code for & in keypress is the same as the up arrow,\n            // so we use the suppressKeyPressRepeat flag to avoid handling keypress\n            // events when we know the keydown event was used to modify the\n            // search term. #7799\n            var suppressKeyPress, suppressKeyPressRepeat, suppressInput,\n                nodeName = this.element[0].nodeName.toLowerCase(),\n                isTextarea = nodeName === \"textarea\",\n                isInput = nodeName === \"input\";\n\n            this.isMultiLine =\n                // Textareas are always multi-line\n                isTextarea ? true :\n                    // Inputs are always single-line, even if inside a contentEditable element\n                    // IE also treats inputs as contentEditable\n                    isInput ? false :\n                        // All other element types are determined by whether or not they're contentEditable\n                        this.element.prop(\"isContentEditable\");\n\n            this.valueMethod = this.element[isTextarea || isInput ? \"val\" : \"text\"];\n            this.isNewMenu = true;\n\n            this.element\n                .addClass(\"ui-autocomplete-input\")\n                .attr(\"autocomplete\", \"off\");\n\n            this._on(this.element, {\n                keydown: function (event) {\n                    if (this.element.prop(\"readOnly\")) {\n                        suppressKeyPress = true;\n                        suppressInput = true;\n                        suppressKeyPressRepeat = true;\n                        return;\n                    }\n\n                    suppressKeyPress = false;\n                    suppressInput = false;\n                    suppressKeyPressRepeat = false;\n                    var keyCode = $.ui.keyCode;\n                    switch (event.keyCode) {\n                        case keyCode.PAGE_UP:\n                            suppressKeyPress = true;\n                            this._move(\"previousPage\", event);\n                            break;\n                        case keyCode.PAGE_DOWN:\n                            suppressKeyPress = true;\n                            this._move(\"nextPage\", event);\n                            break;\n                        case keyCode.UP:\n                            suppressKeyPress = true;\n                            this._keyEvent(\"previous\", event);\n                            break;\n                        case keyCode.DOWN:\n                            suppressKeyPress = true;\n                            this._keyEvent(\"next\", event);\n                            break;\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            // when menu is open and has focus\n                            if (this.menu.active) {\n                                // #6055 - Opera still allows the keypress to occur\n                                // which causes forms to submit\n                                suppressKeyPress = true;\n                                event.preventDefault();\n                                this.menu.select(event);\n                            }\n                            break;\n                        case keyCode.TAB:\n                            if (this.menu.active) {\n                                this.menu.select(event);\n                            }\n                            break;\n                        case keyCode.ESCAPE:\n                            if (this.menu.element.is(\":visible\")) {\n                                this._value(this.term);\n                                this.close(event);\n                                // Different browsers have different default behavior for escape\n                                // Single press can mean undo or clear\n                                // Double press in IE means clear the whole form\n                                event.preventDefault();\n                            }\n                            break;\n                        default:\n                            suppressKeyPressRepeat = true;\n                            // search timeout should be triggered before the input value is changed\n                            this._searchTimeout(event);\n                            break;\n                    }\n                },\n                keypress: function (event) {\n                    if (suppressKeyPress) {\n                        suppressKeyPress = false;\n                        if (!this.isMultiLine || this.menu.element.is(\":visible\")) {\n                            event.preventDefault();\n                        }\n                        return;\n                    }\n                    if (suppressKeyPressRepeat) {\n                        return;\n                    }\n\n                    // replicate some key handlers to allow them to repeat in Firefox and Opera\n                    var keyCode = $.ui.keyCode;\n                    switch (event.keyCode) {\n                        case keyCode.PAGE_UP:\n                            this._move(\"previousPage\", event);\n                            break;\n                        case keyCode.PAGE_DOWN:\n                            this._move(\"nextPage\", event);\n                            break;\n                        case keyCode.UP:\n                            this._keyEvent(\"previous\", event);\n                            break;\n                        case keyCode.DOWN:\n                            this._keyEvent(\"next\", event);\n                            break;\n                    }\n                },\n                input: function (event) {\n                    if (suppressInput) {\n                        suppressInput = false;\n                        event.preventDefault();\n                        return;\n                    }\n                    this._searchTimeout(event);\n                },\n                focus: function () {\n                    this.selectedItem = null;\n                    this.previous = this._value();\n                },\n                blur: function (event) {\n                    if (this.cancelBlur) {\n                        delete this.cancelBlur;\n                        return;\n                    }\n\n                    clearTimeout(this.searching);\n                    this.close(event);\n                    this._change(event);\n                }\n            });\n\n            this._initSource();\n            this.menu = $(\"<ul>\")\n                .addClass(\"ui-autocomplete ui-front\")\n                .appendTo(this._appendTo())\n                .menu({\n                    // disable ARIA support, the live region takes care of that\n                    role: null\n                })\n                .hide()\n                .data(\"ui-menu\");\n\n            this._on(this.menu.element, {\n                mousedown: function (event) {\n                    // prevent moving focus out of the text field\n                    event.preventDefault();\n\n                    // IE doesn't prevent moving focus even with event.preventDefault()\n                    // so we set a flag to know when we should ignore the blur event\n                    this.cancelBlur = true;\n                    this._delay(function () {\n                        delete this.cancelBlur;\n                    });\n\n                    // clicking on the scrollbar causes focus to shift to the body\n                    // but we can't detect a mouseup or a click immediately afterward\n                    // so we have to track the next mousedown and close the menu if\n                    // the user clicks somewhere outside of the autocomplete\n                    var menuElement = this.menu.element[0];\n                    if (!$(event.target).closest(\".ui-menu-item\").length) {\n                        this._delay(function () {\n                            var that = this;\n                            this.document.one(\"mousedown\", function (event) {\n                                if (event.target !== that.element[0] &&\n                                    event.target !== menuElement &&\n                                    !$.contains(menuElement, event.target)) {\n                                    that.close();\n                                }\n                            });\n                        });\n                    }\n                },\n                menufocus: function (event, ui) {\n                    // support: Firefox\n                    // Prevent accidental activation of menu items in Firefox (#7024 #9118)\n                    if (this.isNewMenu) {\n                        this.isNewMenu = false;\n                        if (event.originalEvent && /^mouse/.test(event.originalEvent.type)) {\n                            this.menu.blur();\n\n                            this.document.one(\"mousemove\", function () {\n                                $(event.target).trigger(event.originalEvent);\n                            });\n\n                            return;\n                        }\n                    }\n\n                    var item = ui.item.data(\"ui-autocomplete-item\");\n                    if (false !== this._trigger(\"focus\", event, {item: item})) {\n                        // use value to match what will end up in the input, if it was a key event\n                        if (event.originalEvent && /^key/.test(event.originalEvent.type)) {\n                            this._value(item.value);\n                        }\n                    } else {\n                        // Normally the input is populated with the item's value as the\n                        // menu is navigated, causing screen readers to notice a change and\n                        // announce the item. Since the focus event was canceled, this doesn't\n                        // happen, so we update the live region so that screen readers can\n                        // still notice the change and announce it.\n                        this.liveRegion.text(item.value);\n                    }\n                },\n                menuselect: function (event, ui) {\n                    var item = ui.item.data(\"ui-autocomplete-item\"),\n                        previous = this.previous;\n\n                    // only trigger when focus was lost (click on menu)\n                    if (this.element[0] !== this.document[0].activeElement) {\n                        this.element.focus();\n                        this.previous = previous;\n                        // #6109 - IE triggers two focus events and the second\n                        // is asynchronous, so we need to reset the previous\n                        // term synchronously and asynchronously :-(\n                        this._delay(function () {\n                            this.previous = previous;\n                            this.selectedItem = item;\n                        });\n                    }\n\n                    if (false !== this._trigger(\"select\", event, {item: item})) {\n                        this._value(item.value);\n                    }\n                    // reset the term after the select event\n                    // this allows custom select handling to work properly\n                    this.term = this._value();\n\n                    this.close(event);\n                    this.selectedItem = item;\n                }\n            });\n\n            this.liveRegion = $(\"<span>\", {\n                role: \"status\",\n                \"aria-live\": \"polite\"\n            })\n                .addClass(\"ui-helper-hidden-accessible\")\n                .insertBefore(this.element);\n\n            // turning off autocomplete prevents the browser from remembering the\n            // value when navigating through history, so we re-enable autocomplete\n            // if the page is unloaded before the widget is destroyed. #7790\n            this._on(this.window, {\n                beforeunload: function () {\n                    this.element.removeAttr(\"autocomplete\");\n                }\n            });\n        },\n\n        _destroy: function () {\n            clearTimeout(this.searching);\n            this.element\n                .removeClass(\"ui-autocomplete-input\")\n                .removeAttr(\"autocomplete\");\n            this.menu.element.remove();\n            this.liveRegion.remove();\n        },\n\n        _setOption: function (key, value) {\n            this._super(key, value);\n            if (key === \"source\") {\n                this._initSource();\n            }\n            if (key === \"appendTo\") {\n                this.menu.element.appendTo(this._appendTo());\n            }\n            if (key === \"disabled\" && value && this.xhr) {\n                this.xhr.abort();\n            }\n        },\n\n        _appendTo: function () {\n            var element = this.options.appendTo;\n\n            if (element) {\n                element = element.jquery || element.nodeType ?\n                    $(element) :\n                    this.document.find(element).eq(0);\n            }\n\n            if (!element) {\n                element = this.element.closest(\".ui-front\");\n            }\n\n            if (!element.length) {\n                element = this.document[0].body;\n            }\n\n            return element;\n        },\n\n        _initSource: function () {\n            var array, url,\n                that = this;\n            if ($.isArray(this.options.source)) {\n                array = this.options.source;\n                this.source = function (request, response) {\n                    response($.ui.autocomplete.filter(array, request.term));\n                };\n            } else if (typeof this.options.source === \"string\") {\n                url = this.options.source;\n                this.source = function (request, response) {\n                    if (that.xhr) {\n                        that.xhr.abort();\n                    }\n                    that.xhr = $.ajax({\n                        url: url,\n                        data: request,\n                        dataType: \"json\",\n                        success: function (data) {\n                            response(data);\n                        },\n                        error: function () {\n                            response([]);\n                        }\n                    });\n                };\n            } else {\n                this.source = this.options.source;\n            }\n        },\n\n        _searchTimeout: function (event) {\n            clearTimeout(this.searching);\n            this.searching = this._delay(function () {\n                // only search if the value has changed\n                if (this.term !== this._value()) {\n                    this.selectedItem = null;\n                    this.search(null, event);\n                }\n            }, this.options.delay);\n        },\n\n        search: function (value, event) {\n            value = value != null ? value : this._value();\n\n            // always save the actual value, not the one passed as an argument\n            this.term = this._value();\n\n            if (value.length < this.options.minLength) {\n                return this.close(event);\n            }\n\n            if (this._trigger(\"search\", event) === false) {\n                return;\n            }\n\n            return this._search(value);\n        },\n\n        _search: function (value) {\n            this.pending++;\n            this.element.addClass(\"ui-autocomplete-loading\");\n            this.cancelSearch = false;\n\n            this.source({term: value}, this._response());\n        },\n\n        _response: function () {\n            var index = ++this.requestIndex;\n\n            return $.proxy(function (content) {\n                if (index === this.requestIndex) {\n                    this.__response(content);\n                }\n\n                this.pending--;\n                if (!this.pending) {\n                    this.element.removeClass(\"ui-autocomplete-loading\");\n                }\n            }, this);\n        },\n\n        __response: function (content) {\n            if (content) {\n                content = this._normalize(content);\n            }\n            this._trigger(\"response\", null, {content: content});\n            if (!this.options.disabled && content && content.length && !this.cancelSearch) {\n                this._suggest(content);\n                this._trigger(\"open\");\n            } else {\n                // use ._close() instead of .close() so we don't cancel future searches\n                this._close();\n            }\n        },\n\n        close: function (event) {\n            this.cancelSearch = true;\n            this._close(event);\n        },\n\n        _close: function (event) {\n            if (this.menu.element.is(\":visible\")) {\n                this.menu.element.hide();\n                this.menu.blur();\n                this.isNewMenu = true;\n                this._trigger(\"close\", event);\n            }\n        },\n\n        _change: function (event) {\n            if (this.previous !== this._value()) {\n                this._trigger(\"change\", event, {item: this.selectedItem});\n            }\n        },\n\n        _normalize: function (items) {\n            // assume all items have the right format when the first item is complete\n            if (items.length && items[0].label && items[0].value) {\n                return items;\n            }\n            return $.map(items, function (item) {\n                if (typeof item === \"string\") {\n                    return {\n                        label: item,\n                        value: item\n                    };\n                }\n                return $.extend({\n                    label: item.label || item.value,\n                    value: item.value || item.label\n                }, item);\n            });\n        },\n\n        _suggest: function (items) {\n            var ul = this.menu.element.empty();\n            this._renderMenu(ul, items);\n            this.isNewMenu = true;\n            this.menu.refresh();\n\n            // size and position menu\n            ul.show();\n            this._resizeMenu();\n            ul.position($.extend({\n                of: this.element\n            }, this.options.position));\n\n            if (this.options.autoFocus) {\n                this.menu.next();\n            }\n        },\n\n        _resizeMenu: function () {\n            var ul = this.menu.element;\n            ul.outerWidth(Math.max(\n                // Firefox wraps long text (possibly a rounding bug)\n                // so we add 1px to avoid the wrapping (#7513)\n                ul.width(\"\").outerWidth() + 1,\n                this.element.outerWidth()\n            ));\n        },\n\n        _renderMenu: function (ul, items) {\n            var that = this;\n            $.each(items, function (index, item) {\n                that._renderItemData(ul, item);\n            });\n        },\n\n        _renderItemData: function (ul, item) {\n            return this._renderItem(ul, item).data(\"ui-autocomplete-item\", item);\n        },\n\n        _renderItem: function (ul, item) {\n            return $(\"<li>\")\n                .append($(\"<a>\").text(item.label))\n                .appendTo(ul);\n        },\n\n        _move: function (direction, event) {\n            if (!this.menu.element.is(\":visible\")) {\n                this.search(null, event);\n                return;\n            }\n            if (this.menu.isFirstItem() && /^previous/.test(direction) ||\n                this.menu.isLastItem() && /^next/.test(direction)) {\n                this._value(this.term);\n                this.menu.blur();\n                return;\n            }\n            this.menu[direction](event);\n        },\n\n        widget: function () {\n            return this.menu.element;\n        },\n\n        _value: function () {\n            return this.valueMethod.apply(this.element, arguments);\n        },\n\n        _keyEvent: function (keyEvent, event) {\n            if (!this.isMultiLine || this.menu.element.is(\":visible\")) {\n                this._move(keyEvent, event);\n\n                // prevents moving cursor to beginning/end of the text field in some browsers\n                event.preventDefault();\n            }\n        }\n    });\n\n    $.extend($.ui.autocomplete, {\n        escapeRegex: function (value) {\n            return value.replace(/[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, \"\\\\$&\");\n        },\n        filter: function (array, term) {\n            var matcher = new RegExp($.ui.autocomplete.escapeRegex(term), \"i\");\n            return $.grep(array, function (value) {\n                return matcher.test(value.label || value.value || value);\n            });\n        }\n    });\n\n\n    // live region extension, adding a `messages` option\n    // NOTE: This is an experimental API. We are still investigating\n    // a full solution for string manipulation and internationalization.\n    $.widget(\"ui.autocomplete\", $.ui.autocomplete, {\n        options: {\n            messages: {\n                noResults: \"No search results.\",\n                results: function (amount) {\n                    return amount + (amount > 1 ? \" results are\" : \" result is\") +\n                        \" available, use up and down arrow keys to navigate.\";\n                }\n            }\n        },\n\n        __response: function (content) {\n            var message;\n            this._superApply(arguments);\n            if (this.options.disabled || this.cancelSearch) {\n                return;\n            }\n            if (content && content.length) {\n                message = this.options.messages.results(content.length);\n            } else {\n                message = this.options.messages.noResults;\n            }\n            this.liveRegion.text(message);\n        }\n    });\n});\n","jquery/ui-modules/effect-fold.js":"/*!\n * jQuery UI Effects Fold - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/fold-effect/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.fold = function (o, done) {\n\n        // Create element\n        var el = $(this),\n            props = [\"position\", \"top\", \"bottom\", \"left\", \"right\", \"height\", \"width\"],\n            mode = $.effects.setMode(el, o.mode || \"hide\"),\n            show = mode === \"show\",\n            hide = mode === \"hide\",\n            size = o.size || 15,\n            percent = /([0-9]+)%/.exec(size),\n            horizFirst = !!o.horizFirst,\n            widthFirst = show !== horizFirst,\n            ref = widthFirst ? [\"width\", \"height\"] : [\"height\", \"width\"],\n            duration = o.duration / 2,\n            wrapper, distance,\n            animation1 = {},\n            animation2 = {};\n\n        $.effects.save(el, props);\n        el.show();\n\n        // Create Wrapper\n        wrapper = $.effects.createWrapper(el).css({\n            overflow: \"hidden\"\n        });\n        distance = widthFirst ?\n            [wrapper.width(), wrapper.height()] :\n            [wrapper.height(), wrapper.width()];\n\n        if (percent) {\n            size = parseInt(percent[1], 10) / 100 * distance[hide ? 0 : 1];\n        }\n        if (show) {\n            wrapper.css(horizFirst ? {\n                height: 0,\n                width: size\n            } : {\n                height: size,\n                width: 0\n            });\n        }\n\n        // Animation\n        animation1[ref[0]] = show ? distance[0] : size;\n        animation2[ref[1]] = show ? distance[1] : 0;\n\n        // Animate\n        wrapper\n            .animate(animation1, duration, o.easing)\n            .animate(animation2, duration, o.easing, function () {\n                if (hide) {\n                    el.hide();\n                }\n                $.effects.restore(el, props);\n                $.effects.removeWrapper(el);\n                done();\n            });\n    };\n\n});\n","jquery/ui-modules/draggable.js":"/*!\n * jQuery UI Draggable - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/draggable/\n *\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/mouse'\n], function ($, undefined) {\n\n    $.widget(\"ui.draggable\", $.ui.mouse, {\n        version: \"1.10.4\",\n        widgetEventPrefix: \"drag\",\n        options: {\n            addClasses: true,\n            appendTo: \"parent\",\n            axis: false,\n            connectToSortable: false,\n            containment: false,\n            cursor: \"auto\",\n            cursorAt: false,\n            grid: false,\n            handle: false,\n            helper: \"original\",\n            iframeFix: false,\n            opacity: false,\n            refreshPositions: false,\n            revert: false,\n            revertDuration: 500,\n            scope: \"default\",\n            scroll: true,\n            scrollSensitivity: 20,\n            scrollSpeed: 20,\n            snap: false,\n            snapMode: \"both\",\n            snapTolerance: 20,\n            stack: false,\n            zIndex: false,\n\n            // callbacks\n            drag: null,\n            start: null,\n            stop: null\n        },\n        _create: function () {\n\n            if (this.options.helper === \"original\" && !(/^(?:r|a|f)/).test(this.element.css(\"position\"))) {\n                this.element[0].style.position = \"relative\";\n            }\n            if (this.options.addClasses) {\n                this.element.addClass(\"ui-draggable\");\n            }\n            if (this.options.disabled) {\n                this.element.addClass(\"ui-draggable-disabled\");\n            }\n\n            this._mouseInit();\n\n        },\n\n        _destroy: function () {\n            this.element.removeClass(\"ui-draggable ui-draggable-dragging ui-draggable-disabled\");\n            this._mouseDestroy();\n        },\n\n        _mouseCapture: function (event) {\n\n            var o = this.options;\n\n            // among others, prevent a drag on a resizable-handle\n            if (this.helper || o.disabled || $(event.target).closest(\".ui-resizable-handle\").length > 0) {\n                return false;\n            }\n\n            //Quit if we're not on a valid handle\n            this.handle = this._getHandle(event);\n            if (!this.handle) {\n                return false;\n            }\n\n            $(o.iframeFix === true ? \"iframe\" : o.iframeFix).each(function () {\n                $(\"<div class='ui-draggable-iframeFix' style='background: #fff;'></div>\")\n                    .css({\n                        width: this.offsetWidth + \"px\", height: this.offsetHeight + \"px\",\n                        position: \"absolute\", opacity: \"0.001\", zIndex: 1000\n                    })\n                    .css($(this).offset())\n                    .appendTo(\"body\");\n            });\n\n            return true;\n\n        },\n\n        _mouseStart: function (event) {\n\n            var o = this.options;\n\n            //Create and append the visible helper\n            this.helper = this._createHelper(event);\n\n            this.helper.addClass(\"ui-draggable-dragging\");\n\n            //Cache the helper size\n            this._cacheHelperProportions();\n\n            //If ddmanager is used for droppables, set the global draggable\n            if ($.ui.ddmanager) {\n                $.ui.ddmanager.current = this;\n            }\n\n            /*\n             * - Position generation -\n             * This block generates everything position related - it's the core of draggables.\n             */\n\n            //Cache the margins of the original element\n            this._cacheMargins();\n\n            //Store the helper's css position\n            this.cssPosition = this.helper.css(\"position\");\n            this.scrollParent = this.helper.scrollParent();\n            this.offsetParent = this.helper.offsetParent();\n            this.offsetParentCssPosition = this.offsetParent.css(\"position\");\n\n            //The element's absolute position on the page minus margins\n            this.offset = this.positionAbs = this.element.offset();\n            this.offset = {\n                top: this.offset.top - this.margins.top,\n                left: this.offset.left - this.margins.left\n            };\n\n            //Reset scroll cache\n            this.offset.scroll = false;\n\n            $.extend(this.offset, {\n                click: { //Where the click happened, relative to the element\n                    left: event.pageX - this.offset.left,\n                    top: event.pageY - this.offset.top\n                },\n                parent: this._getParentOffset(),\n                relative: this._getRelativeOffset() //This is a relative to absolute position minus the actual position calculation - only used for relative positioned helper\n            });\n\n            //Generate the original position\n            this.originalPosition = this.position = this._generatePosition(event);\n            this.originalPageX = event.pageX;\n            this.originalPageY = event.pageY;\n\n            //Adjust the mouse offset relative to the helper if \"cursorAt\" is supplied\n            (o.cursorAt && this._adjustOffsetFromHelper(o.cursorAt));\n\n            //Set a containment if given in the options\n            this._setContainment();\n\n            //Trigger event + callbacks\n            if (this._trigger(\"start\", event) === false) {\n                this._clear();\n                return false;\n            }\n\n            //Recache the helper size\n            this._cacheHelperProportions();\n\n            //Prepare the droppable offsets\n            if ($.ui.ddmanager && !o.dropBehaviour) {\n                $.ui.ddmanager.prepareOffsets(this, event);\n            }\n\n\n            this._mouseDrag(event, true); //Execute the drag once - this causes the helper not to be visible before getting its correct position\n\n            //If the ddmanager is used for droppables, inform the manager that dragging has started (see #5003)\n            if ($.ui.ddmanager) {\n                $.ui.ddmanager.dragStart(this, event);\n            }\n\n            return true;\n        },\n\n        _mouseDrag: function (event, noPropagation) {\n            // reset any necessary cached properties (see #5009)\n            if (this.offsetParentCssPosition === \"fixed\") {\n                this.offset.parent = this._getParentOffset();\n            }\n\n            //Compute the helpers position\n            this.position = this._generatePosition(event);\n            this.positionAbs = this._convertPositionTo(\"absolute\");\n\n            //Call plugins and callbacks and use the resulting position if something is returned\n            if (!noPropagation) {\n                var ui = this._uiHash();\n                if (this._trigger(\"drag\", event, ui) === false) {\n                    this._mouseUp({});\n                    return false;\n                }\n                this.position = ui.position;\n            }\n\n            if (!this.options.axis || this.options.axis !== \"y\") {\n                this.helper[0].style.left = this.position.left + \"px\";\n            }\n            if (!this.options.axis || this.options.axis !== \"x\") {\n                this.helper[0].style.top = this.position.top + \"px\";\n            }\n            if ($.ui.ddmanager) {\n                $.ui.ddmanager.drag(this, event);\n            }\n\n            return false;\n        },\n\n        _mouseStop: function (event) {\n\n            //If we are using droppables, inform the manager about the drop\n            var that = this,\n                dropped = false;\n            if ($.ui.ddmanager && !this.options.dropBehaviour) {\n                dropped = $.ui.ddmanager.drop(this, event);\n            }\n\n            //if a drop comes from outside (a sortable)\n            if (this.dropped) {\n                dropped = this.dropped;\n                this.dropped = false;\n            }\n\n            //if the original element is no longer in the DOM don't bother to continue (see #8269)\n            if (this.options.helper === \"original\" && !$.contains(this.element[0].ownerDocument, this.element[0])) {\n                return false;\n            }\n\n            if ((this.options.revert === \"invalid\" && !dropped) || (this.options.revert === \"valid\" && dropped) || this.options.revert === true || ($.isFunction(this.options.revert) && this.options.revert.call(this.element, dropped))) {\n                $(this.helper).animate(this.originalPosition, parseInt(this.options.revertDuration, 10), function () {\n                    if (that._trigger(\"stop\", event) !== false) {\n                        that._clear();\n                    }\n                });\n            } else {\n                if (this._trigger(\"stop\", event) !== false) {\n                    this._clear();\n                }\n            }\n\n            return false;\n        },\n\n        _mouseUp: function (event) {\n            //Remove frame helpers\n            $(\"div.ui-draggable-iframeFix\").each(function () {\n                this.parentNode.removeChild(this);\n            });\n\n            //If the ddmanager is used for droppables, inform the manager that dragging has stopped (see #5003)\n            if ($.ui.ddmanager) {\n                $.ui.ddmanager.dragStop(this, event);\n            }\n\n            return $.ui.mouse.prototype._mouseUp.call(this, event);\n        },\n\n        cancel: function () {\n\n            if (this.helper.is(\".ui-draggable-dragging\")) {\n                this._mouseUp({});\n            } else {\n                this._clear();\n            }\n\n            return this;\n\n        },\n\n        _getHandle: function (event) {\n            return this.options.handle ?\n                !!$(event.target).closest(this.element.find(this.options.handle)).length :\n                true;\n        },\n\n        _createHelper: function (event) {\n\n            var o = this.options,\n                helper = $.isFunction(o.helper) ? $(o.helper.apply(this.element[0], [event])) : (o.helper === \"clone\" ? this.element.clone().removeAttr(\"id\") : this.element);\n\n            if (!helper.parents(\"body\").length) {\n                helper.appendTo((o.appendTo === \"parent\" ? this.element[0].parentNode : o.appendTo));\n            }\n\n            if (helper[0] !== this.element[0] && !(/(fixed|absolute)/).test(helper.css(\"position\"))) {\n                helper.css(\"position\", \"absolute\");\n            }\n\n            return helper;\n\n        },\n\n        _adjustOffsetFromHelper: function (obj) {\n            if (typeof obj === \"string\") {\n                obj = obj.split(\" \");\n            }\n            if ($.isArray(obj)) {\n                obj = {left: +obj[0], top: +obj[1] || 0};\n            }\n            if (\"left\" in obj) {\n                this.offset.click.left = obj.left + this.margins.left;\n            }\n            if (\"right\" in obj) {\n                this.offset.click.left = this.helperProportions.width - obj.right + this.margins.left;\n            }\n            if (\"top\" in obj) {\n                this.offset.click.top = obj.top + this.margins.top;\n            }\n            if (\"bottom\" in obj) {\n                this.offset.click.top = this.helperProportions.height - obj.bottom + this.margins.top;\n            }\n        },\n\n        _getParentOffset: function () {\n\n            //Get the offsetParent and cache its position\n            var po = this.offsetParent.offset();\n\n            // This is a special case where we need to modify a offset calculated on start, since the following happened:\n            // 1. The position of the helper is absolute, so it's position is calculated based on the next positioned parent\n            // 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't the document, which means that\n            //    the scroll is included in the initial calculation of the offset of the parent, and never recalculated upon drag\n            if (this.cssPosition === \"absolute\" && this.scrollParent[0] !== document && $.contains(this.scrollParent[0], this.offsetParent[0])) {\n                po.left += this.scrollParent.scrollLeft();\n                po.top += this.scrollParent.scrollTop();\n            }\n\n            //This needs to be actually done for all browsers, since pageX/pageY includes this information\n            //Ugly IE fix\n            if ((this.offsetParent[0] === document.body) ||\n                (this.offsetParent[0].tagName && this.offsetParent[0].tagName.toLowerCase() === \"html\" && $.ui.ie)) {\n                po = {top: 0, left: 0};\n            }\n\n            return {\n                top: po.top + (parseInt(this.offsetParent.css(\"borderTopWidth\"), 10) || 0),\n                left: po.left + (parseInt(this.offsetParent.css(\"borderLeftWidth\"), 10) || 0)\n            };\n\n        },\n\n        _getRelativeOffset: function () {\n\n            if (this.cssPosition === \"relative\") {\n                var p = this.element.position();\n                return {\n                    top: p.top - (parseInt(this.helper.css(\"top\"), 10) || 0) + this.scrollParent.scrollTop(),\n                    left: p.left - (parseInt(this.helper.css(\"left\"), 10) || 0) + this.scrollParent.scrollLeft()\n                };\n            } else {\n                return {top: 0, left: 0};\n            }\n\n        },\n\n        _cacheMargins: function () {\n            this.margins = {\n                left: (parseInt(this.element.css(\"marginLeft\"), 10) || 0),\n                top: (parseInt(this.element.css(\"marginTop\"), 10) || 0),\n                right: (parseInt(this.element.css(\"marginRight\"), 10) || 0),\n                bottom: (parseInt(this.element.css(\"marginBottom\"), 10) || 0)\n            };\n        },\n\n        _cacheHelperProportions: function () {\n            this.helperProportions = {\n                width: this.helper.outerWidth(),\n                height: this.helper.outerHeight()\n            };\n        },\n\n        _setContainment: function () {\n\n            var over, c, ce,\n                o = this.options;\n\n            if (!o.containment) {\n                this.containment = null;\n                return;\n            }\n\n            if (o.containment === \"window\") {\n                this.containment = [\n                    $(window).scrollLeft() - this.offset.relative.left - this.offset.parent.left,\n                    $(window).scrollTop() - this.offset.relative.top - this.offset.parent.top,\n                    $(window).scrollLeft() + $(window).width() - this.helperProportions.width - this.margins.left,\n                    $(window).scrollTop() + ($(window).height() || document.body.parentNode.scrollHeight) - this.helperProportions.height - this.margins.top\n                ];\n                return;\n            }\n\n            if (o.containment === \"document\") {\n                this.containment = [\n                    0,\n                    0,\n                    $(document).width() - this.helperProportions.width - this.margins.left,\n                    ($(document).height() || document.body.parentNode.scrollHeight) - this.helperProportions.height - this.margins.top\n                ];\n                return;\n            }\n\n            if (o.containment.constructor === Array) {\n                this.containment = o.containment;\n                return;\n            }\n\n            if (o.containment === \"parent\") {\n                o.containment = this.helper[0].parentNode;\n            }\n\n            c = $(o.containment);\n            ce = c[0];\n\n            if (!ce) {\n                return;\n            }\n\n            over = c.css(\"overflow\") !== \"hidden\";\n\n            this.containment = [\n                (parseInt(c.css(\"borderLeftWidth\"), 10) || 0) + (parseInt(c.css(\"paddingLeft\"), 10) || 0),\n                (parseInt(c.css(\"borderTopWidth\"), 10) || 0) + (parseInt(c.css(\"paddingTop\"), 10) || 0),\n                (over ? Math.max(ce.scrollWidth, ce.offsetWidth) : ce.offsetWidth) - (parseInt(c.css(\"borderRightWidth\"), 10) || 0) - (parseInt(c.css(\"paddingRight\"), 10) || 0) - this.helperProportions.width - this.margins.left - this.margins.right,\n                (over ? Math.max(ce.scrollHeight, ce.offsetHeight) : ce.offsetHeight) - (parseInt(c.css(\"borderBottomWidth\"), 10) || 0) - (parseInt(c.css(\"paddingBottom\"), 10) || 0) - this.helperProportions.height - this.margins.top - this.margins.bottom\n            ];\n            this.relative_container = c;\n        },\n\n        _convertPositionTo: function (d, pos) {\n\n            if (!pos) {\n                pos = this.position;\n            }\n\n            var mod = d === \"absolute\" ? 1 : -1,\n                scroll = this.cssPosition === \"absolute\" && !(this.scrollParent[0] !== document && $.contains(this.scrollParent[0], this.offsetParent[0])) ? this.offsetParent : this.scrollParent;\n\n            //Cache the scroll\n            if (!this.offset.scroll) {\n                this.offset.scroll = {top: scroll.scrollTop(), left: scroll.scrollLeft()};\n            }\n\n            return {\n                top: (\n                    pos.top +\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n                    this.offset.relative.top * mod +\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.parent.top * mod -\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n                    ((this.cssPosition === \"fixed\" ? -this.scrollParent.scrollTop() : this.offset.scroll.top) * mod)\n                ),\n                left: (\n                    pos.left +\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n                    this.offset.relative.left * mod +\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.parent.left * mod -\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n                    ((this.cssPosition === \"fixed\" ? -this.scrollParent.scrollLeft() : this.offset.scroll.left) * mod)\n                )\n            };\n\n        },\n\n        _generatePosition: function (event) {\n\n            var containment, co, top, left,\n                o = this.options,\n                scroll = this.cssPosition === \"absolute\" && !(this.scrollParent[0] !== document && $.contains(this.scrollParent[0], this.offsetParent[0])) ? this.offsetParent : this.scrollParent,\n                pageX = event.pageX,\n                pageY = event.pageY;\n\n            //Cache the scroll\n            if (!this.offset.scroll) {\n                this.offset.scroll = {top: scroll.scrollTop(), left: scroll.scrollLeft()};\n            }\n\n            /*\n             * - Position constraining -\n             * Constrain the position to a mix of grid, containment.\n             */\n\n            // If we are not dragging yet, we won't check for options\n            if (this.originalPosition) {\n                if (this.containment) {\n                    if (this.relative_container) {\n                        co = this.relative_container.offset();\n                        containment = [\n                            this.containment[0] + co.left,\n                            this.containment[1] + co.top,\n                            this.containment[2] + co.left,\n                            this.containment[3] + co.top\n                        ];\n                    } else {\n                        containment = this.containment;\n                    }\n\n                    if (event.pageX - this.offset.click.left < containment[0]) {\n                        pageX = containment[0] + this.offset.click.left;\n                    }\n                    if (event.pageY - this.offset.click.top < containment[1]) {\n                        pageY = containment[1] + this.offset.click.top;\n                    }\n                    if (event.pageX - this.offset.click.left > containment[2]) {\n                        pageX = containment[2] + this.offset.click.left;\n                    }\n                    if (event.pageY - this.offset.click.top > containment[3]) {\n                        pageY = containment[3] + this.offset.click.top;\n                    }\n                }\n\n                if (o.grid) {\n                    //Check for grid elements set to 0 to prevent divide by 0 error causing invalid argument errors in IE (see ticket #6950)\n                    top = o.grid[1] ? this.originalPageY + Math.round((pageY - this.originalPageY) / o.grid[1]) * o.grid[1] : this.originalPageY;\n                    pageY = containment ? ((top - this.offset.click.top >= containment[1] || top - this.offset.click.top > containment[3]) ? top : ((top - this.offset.click.top >= containment[1]) ? top - o.grid[1] : top + o.grid[1])) : top;\n\n                    left = o.grid[0] ? this.originalPageX + Math.round((pageX - this.originalPageX) / o.grid[0]) * o.grid[0] : this.originalPageX;\n                    pageX = containment ? ((left - this.offset.click.left >= containment[0] || left - this.offset.click.left > containment[2]) ? left : ((left - this.offset.click.left >= containment[0]) ? left - o.grid[0] : left + o.grid[0])) : left;\n                }\n\n            }\n\n            return {\n                top: (\n                    pageY -\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n                    this.offset.click.top -\t\t\t\t\t\t\t\t\t\t\t\t// Click offset (relative to the element)\n                    this.offset.relative.top -\t\t\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.parent.top +\t\t\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n                    (this.cssPosition === \"fixed\" ? -this.scrollParent.scrollTop() : this.offset.scroll.top)\n                ),\n                left: (\n                    pageX -\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// The absolute mouse position\n                    this.offset.click.left -\t\t\t\t\t\t\t\t\t\t\t\t// Click offset (relative to the element)\n                    this.offset.relative.left -\t\t\t\t\t\t\t\t\t\t\t\t// Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.parent.left +\t\t\t\t\t\t\t\t\t\t\t\t// The offsetParent's offset without borders (offset + border)\n                    (this.cssPosition === \"fixed\" ? -this.scrollParent.scrollLeft() : this.offset.scroll.left)\n                )\n            };\n\n        },\n\n        _clear: function () {\n            this.helper.removeClass(\"ui-draggable-dragging\");\n            if (this.helper[0] !== this.element[0] && !this.cancelHelperRemoval) {\n                this.helper.remove();\n            }\n            this.helper = null;\n            this.cancelHelperRemoval = false;\n        },\n\n        // From now on bulk stuff - mainly helpers\n\n        _trigger: function (type, event, ui) {\n            ui = ui || this._uiHash();\n            $.ui.plugin.call(this, type, [event, ui]);\n            //The absolute position has to be recalculated after plugins\n            if (type === \"drag\") {\n                this.positionAbs = this._convertPositionTo(\"absolute\");\n            }\n            return $.Widget.prototype._trigger.call(this, type, event, ui);\n        },\n\n        plugins: {},\n\n        _uiHash: function () {\n            return {\n                helper: this.helper,\n                position: this.position,\n                originalPosition: this.originalPosition,\n                offset: this.positionAbs\n            };\n        }\n\n    });\n\n    $.ui.plugin.add(\"draggable\", \"connectToSortable\", {\n        start: function (event, ui) {\n\n            var inst = $(this).data(\"ui-draggable\"), o = inst.options,\n                uiSortable = $.extend({}, ui, {item: inst.element});\n            inst.sortables = [];\n            $(o.connectToSortable).each(function () {\n                var sortable = $.data(this, \"ui-sortable\");\n                if (sortable && !sortable.options.disabled) {\n                    inst.sortables.push({\n                        instance: sortable,\n                        shouldRevert: sortable.options.revert\n                    });\n                    sortable.refreshPositions();\t// Call the sortable's refreshPositions at drag start to refresh the containerCache since the sortable container cache is used in drag and needs to be up to date (this will ensure it's initialised as well as being kept in step with any changes that might have happened on the page).\n                    sortable._trigger(\"activate\", event, uiSortable);\n                }\n            });\n\n        },\n        stop: function (event, ui) {\n\n            //If we are still over the sortable, we fake the stop event of the sortable, but also remove helper\n            var inst = $(this).data(\"ui-draggable\"),\n                uiSortable = $.extend({}, ui, {item: inst.element});\n\n            $.each(inst.sortables, function () {\n                if (this.instance.isOver) {\n\n                    this.instance.isOver = 0;\n\n                    inst.cancelHelperRemoval = true; //Don't remove the helper in the draggable instance\n                    this.instance.cancelHelperRemoval = false; //Remove it in the sortable instance (so sortable plugins like revert still work)\n\n                    //The sortable revert is supported, and we have to set a temporary dropped variable on the draggable to support revert: \"valid/invalid\"\n                    if (this.shouldRevert) {\n                        this.instance.options.revert = this.shouldRevert;\n                    }\n\n                    //Trigger the stop of the sortable\n                    this.instance._mouseStop(event);\n\n                    this.instance.options.helper = this.instance.options._helper;\n\n                    //If the helper has been the original item, restore properties in the sortable\n                    if (inst.options.helper === \"original\") {\n                        this.instance.currentItem.css({top: \"auto\", left: \"auto\"});\n                    }\n\n                } else {\n                    this.instance.cancelHelperRemoval = false; //Remove the helper in the sortable instance\n                    this.instance._trigger(\"deactivate\", event, uiSortable);\n                }\n\n            });\n\n        },\n        drag: function (event, ui) {\n\n            var inst = $(this).data(\"ui-draggable\"), that = this;\n\n            $.each(inst.sortables, function () {\n\n                var innermostIntersecting = false,\n                    thisSortable = this;\n\n                //Copy over some variables to allow calling the sortable's native _intersectsWith\n                this.instance.positionAbs = inst.positionAbs;\n                this.instance.helperProportions = inst.helperProportions;\n                this.instance.offset.click = inst.offset.click;\n\n                if (this.instance._intersectsWith(this.instance.containerCache)) {\n                    innermostIntersecting = true;\n                    $.each(inst.sortables, function () {\n                        this.instance.positionAbs = inst.positionAbs;\n                        this.instance.helperProportions = inst.helperProportions;\n                        this.instance.offset.click = inst.offset.click;\n                        if (this !== thisSortable &&\n                            this.instance._intersectsWith(this.instance.containerCache) &&\n                            $.contains(thisSortable.instance.element[0], this.instance.element[0])\n                        ) {\n                            innermostIntersecting = false;\n                        }\n                        return innermostIntersecting;\n                    });\n                }\n\n\n                if (innermostIntersecting) {\n                    //If it intersects, we use a little isOver variable and set it once, so our move-in stuff gets fired only once\n                    if (!this.instance.isOver) {\n\n                        this.instance.isOver = 1;\n                        //Now we fake the start of dragging for the sortable instance,\n                        //by cloning the list group item, appending it to the sortable and using it as inst.currentItem\n                        //We can then fire the start event of the sortable with our passed browser event, and our own helper (so it doesn't create a new one)\n                        this.instance.currentItem = $(that).clone().removeAttr(\"id\").appendTo(this.instance.element).data(\"ui-sortable-item\", true);\n                        this.instance.options._helper = this.instance.options.helper; //Store helper option to later restore it\n                        this.instance.options.helper = function () {\n                            return ui.helper[0];\n                        };\n\n                        event.target = this.instance.currentItem[0];\n                        this.instance._mouseCapture(event, true);\n                        this.instance._mouseStart(event, true, true);\n\n                        //Because the browser event is way off the new appended portlet, we modify a couple of variables to reflect the changes\n                        this.instance.offset.click.top = inst.offset.click.top;\n                        this.instance.offset.click.left = inst.offset.click.left;\n                        this.instance.offset.parent.left -= inst.offset.parent.left - this.instance.offset.parent.left;\n                        this.instance.offset.parent.top -= inst.offset.parent.top - this.instance.offset.parent.top;\n\n                        inst._trigger(\"toSortable\", event);\n                        inst.dropped = this.instance.element; //draggable revert needs that\n                        //hack so receive/update callbacks work (mostly)\n                        inst.currentItem = inst.element;\n                        this.instance.fromOutside = inst;\n\n                    }\n\n                    //Provided we did all the previous steps, we can fire the drag event of the sortable on every draggable drag, when it intersects with the sortable\n                    if (this.instance.currentItem) {\n                        this.instance._mouseDrag(event);\n                    }\n\n                } else {\n\n                    //If it doesn't intersect with the sortable, and it intersected before,\n                    //we fake the drag stop of the sortable, but make sure it doesn't remove the helper by using cancelHelperRemoval\n                    if (this.instance.isOver) {\n\n                        this.instance.isOver = 0;\n                        this.instance.cancelHelperRemoval = true;\n\n                        //Prevent reverting on this forced stop\n                        this.instance.options.revert = false;\n\n                        // The out event needs to be triggered independently\n                        this.instance._trigger(\"out\", event, this.instance._uiHash(this.instance));\n\n                        this.instance._mouseStop(event, true);\n                        this.instance.options.helper = this.instance.options._helper;\n\n                        //Now we remove our currentItem, the list group clone again, and the placeholder, and animate the helper back to it's original size\n                        this.instance.currentItem.remove();\n                        if (this.instance.placeholder) {\n                            this.instance.placeholder.remove();\n                        }\n\n                        inst._trigger(\"fromSortable\", event);\n                        inst.dropped = false; //draggable revert needs that\n                    }\n\n                }\n\n            });\n\n        }\n    });\n\n    $.ui.plugin.add(\"draggable\", \"cursor\", {\n        start: function () {\n            var t = $(\"body\"), o = $(this).data(\"ui-draggable\").options;\n            if (t.css(\"cursor\")) {\n                o._cursor = t.css(\"cursor\");\n            }\n            t.css(\"cursor\", o.cursor);\n        },\n        stop: function () {\n            var o = $(this).data(\"ui-draggable\").options;\n            if (o._cursor) {\n                $(\"body\").css(\"cursor\", o._cursor);\n            }\n        }\n    });\n\n    $.ui.plugin.add(\"draggable\", \"opacity\", {\n        start: function (event, ui) {\n            var t = $(ui.helper), o = $(this).data(\"ui-draggable\").options;\n            if (t.css(\"opacity\")) {\n                o._opacity = t.css(\"opacity\");\n            }\n            t.css(\"opacity\", o.opacity);\n        },\n        stop: function (event, ui) {\n            var o = $(this).data(\"ui-draggable\").options;\n            if (o._opacity) {\n                $(ui.helper).css(\"opacity\", o._opacity);\n            }\n        }\n    });\n\n    $.ui.plugin.add(\"draggable\", \"scroll\", {\n        start: function () {\n            var i = $(this).data(\"ui-draggable\");\n            if (i.scrollParent[0] !== document && i.scrollParent[0].tagName !== \"HTML\") {\n                i.overflowOffset = i.scrollParent.offset();\n            }\n        },\n        drag: function (event) {\n\n            var i = $(this).data(\"ui-draggable\"), o = i.options, scrolled = false;\n\n            if (i.scrollParent[0] !== document && i.scrollParent[0].tagName !== \"HTML\") {\n\n                if (!o.axis || o.axis !== \"x\") {\n                    if ((i.overflowOffset.top + i.scrollParent[0].offsetHeight) - event.pageY < o.scrollSensitivity) {\n                        i.scrollParent[0].scrollTop = scrolled = i.scrollParent[0].scrollTop + o.scrollSpeed;\n                    } else if (event.pageY - i.overflowOffset.top < o.scrollSensitivity) {\n                        i.scrollParent[0].scrollTop = scrolled = i.scrollParent[0].scrollTop - o.scrollSpeed;\n                    }\n                }\n\n                if (!o.axis || o.axis !== \"y\") {\n                    if ((i.overflowOffset.left + i.scrollParent[0].offsetWidth) - event.pageX < o.scrollSensitivity) {\n                        i.scrollParent[0].scrollLeft = scrolled = i.scrollParent[0].scrollLeft + o.scrollSpeed;\n                    } else if (event.pageX - i.overflowOffset.left < o.scrollSensitivity) {\n                        i.scrollParent[0].scrollLeft = scrolled = i.scrollParent[0].scrollLeft - o.scrollSpeed;\n                    }\n                }\n\n            } else {\n\n                if (!o.axis || o.axis !== \"x\") {\n                    if (event.pageY - $(document).scrollTop() < o.scrollSensitivity) {\n                        scrolled = $(document).scrollTop($(document).scrollTop() - o.scrollSpeed);\n                    } else if ($(window).height() - (event.pageY - $(document).scrollTop()) < o.scrollSensitivity) {\n                        scrolled = $(document).scrollTop($(document).scrollTop() + o.scrollSpeed);\n                    }\n                }\n\n                if (!o.axis || o.axis !== \"y\") {\n                    if (event.pageX - $(document).scrollLeft() < o.scrollSensitivity) {\n                        scrolled = $(document).scrollLeft($(document).scrollLeft() - o.scrollSpeed);\n                    } else if ($(window).width() - (event.pageX - $(document).scrollLeft()) < o.scrollSensitivity) {\n                        scrolled = $(document).scrollLeft($(document).scrollLeft() + o.scrollSpeed);\n                    }\n                }\n\n            }\n\n            if (scrolled !== false && $.ui.ddmanager && !o.dropBehaviour) {\n                $.ui.ddmanager.prepareOffsets(i, event);\n            }\n\n        }\n    });\n\n    $.ui.plugin.add(\"draggable\", \"snap\", {\n        start: function () {\n\n            var i = $(this).data(\"ui-draggable\"),\n                o = i.options;\n\n            i.snapElements = [];\n\n            $(o.snap.constructor !== String ? (o.snap.items || \":data(ui-draggable)\") : o.snap).each(function () {\n                var $t = $(this),\n                    $o = $t.offset();\n                if (this !== i.element[0]) {\n                    i.snapElements.push({\n                        item: this,\n                        width: $t.outerWidth(), height: $t.outerHeight(),\n                        top: $o.top, left: $o.left\n                    });\n                }\n            });\n\n        },\n        drag: function (event, ui) {\n\n            var ts, bs, ls, rs, l, r, t, b, i, first,\n                inst = $(this).data(\"ui-draggable\"),\n                o = inst.options,\n                d = o.snapTolerance,\n                x1 = ui.offset.left, x2 = x1 + inst.helperProportions.width,\n                y1 = ui.offset.top, y2 = y1 + inst.helperProportions.height;\n\n            for (i = inst.snapElements.length - 1; i >= 0; i--) {\n\n                l = inst.snapElements[i].left;\n                r = l + inst.snapElements[i].width;\n                t = inst.snapElements[i].top;\n                b = t + inst.snapElements[i].height;\n\n                if (x2 < l - d || x1 > r + d || y2 < t - d || y1 > b + d || !$.contains(inst.snapElements[i].item.ownerDocument, inst.snapElements[i].item)) {\n                    if (inst.snapElements[i].snapping) {\n                        (inst.options.snap.release && inst.options.snap.release.call(inst.element, event, $.extend(inst._uiHash(), {snapItem: inst.snapElements[i].item})));\n                    }\n                    inst.snapElements[i].snapping = false;\n                    continue;\n                }\n\n                if (o.snapMode !== \"inner\") {\n                    ts = Math.abs(t - y2) <= d;\n                    bs = Math.abs(b - y1) <= d;\n                    ls = Math.abs(l - x2) <= d;\n                    rs = Math.abs(r - x1) <= d;\n                    if (ts) {\n                        ui.position.top = inst._convertPositionTo(\"relative\", {\n                            top: t - inst.helperProportions.height,\n                            left: 0\n                        }).top - inst.margins.top;\n                    }\n                    if (bs) {\n                        ui.position.top = inst._convertPositionTo(\"relative\", {top: b, left: 0}).top - inst.margins.top;\n                    }\n                    if (ls) {\n                        ui.position.left = inst._convertPositionTo(\"relative\", {\n                            top: 0,\n                            left: l - inst.helperProportions.width\n                        }).left - inst.margins.left;\n                    }\n                    if (rs) {\n                        ui.position.left = inst._convertPositionTo(\"relative\", {\n                            top: 0,\n                            left: r\n                        }).left - inst.margins.left;\n                    }\n                }\n\n                first = (ts || bs || ls || rs);\n\n                if (o.snapMode !== \"outer\") {\n                    ts = Math.abs(t - y1) <= d;\n                    bs = Math.abs(b - y2) <= d;\n                    ls = Math.abs(l - x1) <= d;\n                    rs = Math.abs(r - x2) <= d;\n                    if (ts) {\n                        ui.position.top = inst._convertPositionTo(\"relative\", {top: t, left: 0}).top - inst.margins.top;\n                    }\n                    if (bs) {\n                        ui.position.top = inst._convertPositionTo(\"relative\", {\n                            top: b - inst.helperProportions.height,\n                            left: 0\n                        }).top - inst.margins.top;\n                    }\n                    if (ls) {\n                        ui.position.left = inst._convertPositionTo(\"relative\", {\n                            top: 0,\n                            left: l\n                        }).left - inst.margins.left;\n                    }\n                    if (rs) {\n                        ui.position.left = inst._convertPositionTo(\"relative\", {\n                            top: 0,\n                            left: r - inst.helperProportions.width\n                        }).left - inst.margins.left;\n                    }\n                }\n\n                if (!inst.snapElements[i].snapping && (ts || bs || ls || rs || first)) {\n                    (inst.options.snap.snap && inst.options.snap.snap.call(inst.element, event, $.extend(inst._uiHash(), {snapItem: inst.snapElements[i].item})));\n                }\n                inst.snapElements[i].snapping = (ts || bs || ls || rs || first);\n\n            }\n\n        }\n    });\n\n    $.ui.plugin.add(\"draggable\", \"stack\", {\n        start: function () {\n            var min,\n                o = this.data(\"ui-draggable\").options,\n                group = $.makeArray($(o.stack)).sort(function (a, b) {\n                    return (parseInt($(a).css(\"zIndex\"), 10) || 0) - (parseInt($(b).css(\"zIndex\"), 10) || 0);\n                });\n\n            if (!group.length) {\n                return;\n            }\n\n            min = parseInt($(group[0]).css(\"zIndex\"), 10) || 0;\n            $(group).each(function (i) {\n                $(this).css(\"zIndex\", min + i);\n            });\n            this.css(\"zIndex\", (min + group.length));\n        }\n    });\n\n    $.ui.plugin.add(\"draggable\", \"zIndex\", {\n        start: function (event, ui) {\n            var t = $(ui.helper), o = $(this).data(\"ui-draggable\").options;\n            if (t.css(\"zIndex\")) {\n                o._zIndex = t.css(\"zIndex\");\n            }\n            t.css(\"zIndex\", o.zIndex);\n        },\n        stop: function (event, ui) {\n            var o = $(this).data(\"ui-draggable\").options;\n            if (o._zIndex) {\n                $(ui.helper).css(\"zIndex\", o._zIndex);\n            }\n        }\n    });\n\n});\n","jquery/ui-modules/effect-blind.js":"/*!\n * jQuery UI Effects Blind - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/blind-effect/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    var rvertical = /up|down|vertical/,\n        rpositivemotion = /up|left|vertical|horizontal/;\n\n    $.effects.effect.blind = function (o, done) {\n        // Create element\n        var el = $(this),\n            props = [\"position\", \"top\", \"bottom\", \"left\", \"right\", \"height\", \"width\"],\n            mode = $.effects.setMode(el, o.mode || \"hide\"),\n            direction = o.direction || \"up\",\n            vertical = rvertical.test(direction),\n            ref = vertical ? \"height\" : \"width\",\n            ref2 = vertical ? \"top\" : \"left\",\n            motion = rpositivemotion.test(direction),\n            animation = {},\n            show = mode === \"show\",\n            wrapper, distance, margin;\n\n        // if already wrapped, the wrapper's properties are my property. #6245\n        if (el.parent().is(\".ui-effects-wrapper\")) {\n            $.effects.save(el.parent(), props);\n        } else {\n            $.effects.save(el, props);\n        }\n        el.show();\n        wrapper = $.effects.createWrapper(el).css({\n            overflow: \"hidden\"\n        });\n\n        distance = wrapper[ref]();\n        margin = parseFloat(wrapper.css(ref2)) || 0;\n\n        animation[ref] = show ? distance : 0;\n        if (!motion) {\n            el\n                .css(vertical ? \"bottom\" : \"right\", 0)\n                .css(vertical ? \"top\" : \"left\", \"auto\")\n                .css({position: \"absolute\"});\n\n            animation[ref2] = show ? margin : distance + margin;\n        }\n\n        // start at 0 if we are showing\n        if (show) {\n            wrapper.css(ref, 0);\n            if (!motion) {\n                wrapper.css(ref2, margin + distance);\n            }\n        }\n\n        // Animate\n        wrapper.animate(animation, {\n            duration: o.duration,\n            easing: o.easing,\n            queue: false,\n            complete: function () {\n                if (mode === \"hide\") {\n                    el.hide();\n                }\n                $.effects.restore(el, props);\n                $.effects.removeWrapper(el);\n                done();\n            }\n        });\n\n    };\n\n});\n","jquery/ui-modules/effect-fade.js":"/*!\n * jQuery UI Effects Fade - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/fade-effect/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.fade = function (o, done) {\n        var el = $(this),\n            mode = $.effects.setMode(el, o.mode || \"toggle\");\n\n        el.animate({\n            opacity: mode\n        }, {\n            queue: false,\n            duration: o.duration,\n            easing: o.easing,\n            complete: done\n        });\n    };\n\n});\n","jquery/ui-modules/effect-clip.js":"/*!\n * jQuery UI Effects Clip - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/clip-effect/\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.clip = function (o, done) {\n        // Create element\n        var el = $(this),\n            props = [\"position\", \"top\", \"bottom\", \"left\", \"right\", \"height\", \"width\"],\n            mode = $.effects.setMode(el, o.mode || \"hide\"),\n            show = mode === \"show\",\n            direction = o.direction || \"vertical\",\n            vert = direction === \"vertical\",\n            size = vert ? \"height\" : \"width\",\n            position = vert ? \"top\" : \"left\",\n            animation = {},\n            wrapper, animate, distance;\n\n        // Save & Show\n        $.effects.save(el, props);\n        el.show();\n\n        // Create Wrapper\n        wrapper = $.effects.createWrapper(el).css({\n            overflow: \"hidden\"\n        });\n        animate = (el[0].tagName === \"IMG\") ? wrapper : el;\n        distance = animate[size]();\n\n        // Shift\n        if (show) {\n            animate.css(size, 0);\n            animate.css(position, distance / 2);\n        }\n\n        // Create Animation Object:\n        animation[size] = show ? distance : 0;\n        animation[position] = show ? 0 : distance / 2;\n\n        // Animate\n        animate.animate(animation, {\n            queue: false,\n            duration: o.duration,\n            easing: o.easing,\n            complete: function () {\n                if (!show) {\n                    el.hide();\n                }\n                $.effects.restore(el, props);\n                $.effects.removeWrapper(el);\n                done();\n            }\n        });\n\n    };\n\n});\n","jquery/ui-modules/tabs.js":"/*!\n * jQuery UI Tabs - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/tabs/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/widget'\n], function ($, undefined) {\n\n    var tabId = 0,\n        rhash = /#.*$/;\n\n    function getNextTabId() {\n        return ++tabId;\n    }\n\n    function isLocal(anchor) {\n        // support: IE7\n        // IE7 doesn't normalize the href property when set via script (#9317)\n        anchor = anchor.cloneNode(false);\n\n        return anchor.hash.length > 1 &&\n            decodeURIComponent(anchor.href.replace(rhash, \"\")) ===\n            decodeURIComponent(location.href.replace(rhash, \"\"));\n    }\n\n    $.widget(\"ui.tabs\", {\n        version: \"1.10.4\",\n        delay: 300,\n        options: {\n            active: null,\n            collapsible: false,\n            event: \"click\",\n            heightStyle: \"content\",\n            hide: null,\n            show: null,\n\n            // callbacks\n            activate: null,\n            beforeActivate: null,\n            beforeLoad: null,\n            load: null\n        },\n\n        _create: function () {\n            var that = this,\n                options = this.options;\n\n            this.running = false;\n\n            this.element\n                .addClass(\"ui-tabs ui-widget ui-widget-content ui-corner-all\")\n                .toggleClass(\"ui-tabs-collapsible\", options.collapsible)\n                // Prevent users from focusing disabled tabs via click\n                .delegate(\".ui-tabs-nav > li\", \"mousedown\" + this.eventNamespace, function (event) {\n                    if ($(this).is(\".ui-state-disabled\")) {\n                        event.preventDefault();\n                    }\n                })\n                // support: IE <9\n                // Preventing the default action in mousedown doesn't prevent IE\n                // from focusing the element, so if the anchor gets focused, blur.\n                // We don't have to worry about focusing the previously focused\n                // element since clicking on a non-focusable element should focus\n                // the body anyway.\n                .delegate(\".ui-tabs-anchor\", \"focus\" + this.eventNamespace, function () {\n                    if ($(this).closest(\"li\").is(\".ui-state-disabled\")) {\n                        this.blur();\n                    }\n                });\n\n            this._processTabs();\n            options.active = this._initialActive();\n\n            // Take disabling tabs via class attribute from HTML\n            // into account and update option properly.\n            if ($.isArray(options.disabled)) {\n                options.disabled = $.unique(options.disabled.concat(\n                    $.map(this.tabs.filter(\".ui-state-disabled\"), function (li) {\n                        return that.tabs.index(li);\n                    })\n                )).sort();\n            }\n\n            // check for length avoids error when initializing empty list\n            if (this.options.active !== false && this.anchors.length) {\n                this.active = this._findActive(options.active);\n            } else {\n                this.active = $();\n            }\n\n            this._refresh();\n\n            if (this.active.length) {\n                this.load(options.active);\n            }\n        },\n\n        _initialActive: function () {\n            var active = this.options.active,\n                collapsible = this.options.collapsible,\n                locationHash = location.hash.substring(1);\n\n            if (active === null) {\n                // check the fragment identifier in the URL\n                if (locationHash) {\n                    this.tabs.each(function (i, tab) {\n                        if ($(tab).attr(\"aria-controls\") === locationHash) {\n                            active = i;\n                            return false;\n                        }\n                    });\n                }\n\n                // check for a tab marked active via a class\n                if (active === null) {\n                    active = this.tabs.index(this.tabs.filter(\".ui-tabs-active\"));\n                }\n\n                // no active tab, set to false\n                if (active === null || active === -1) {\n                    active = this.tabs.length ? 0 : false;\n                }\n            }\n\n            // handle numbers: negative, out of range\n            if (active !== false) {\n                active = this.tabs.index(this.tabs.eq(active));\n                if (active === -1) {\n                    active = collapsible ? false : 0;\n                }\n            }\n\n            // don't allow collapsible: false and active: false\n            if (!collapsible && active === false && this.anchors.length) {\n                active = 0;\n            }\n\n            return active;\n        },\n\n        _getCreateEventData: function () {\n            return {\n                tab: this.active,\n                panel: !this.active.length ? $() : this._getPanelForTab(this.active)\n            };\n        },\n\n        _tabKeydown: function (event) {\n            var focusedTab = $(this.document[0].activeElement).closest(\"li\"),\n                selectedIndex = this.tabs.index(focusedTab),\n                goingForward = true;\n\n            if (this._handlePageNav(event)) {\n                return;\n            }\n\n            switch (event.keyCode) {\n                case $.ui.keyCode.RIGHT:\n                case $.ui.keyCode.DOWN:\n                    selectedIndex++;\n                    break;\n                case $.ui.keyCode.UP:\n                case $.ui.keyCode.LEFT:\n                    goingForward = false;\n                    selectedIndex--;\n                    break;\n                case $.ui.keyCode.END:\n                    selectedIndex = this.anchors.length - 1;\n                    break;\n                case $.ui.keyCode.HOME:\n                    selectedIndex = 0;\n                    break;\n                case $.ui.keyCode.SPACE:\n                    // Activate only, no collapsing\n                    event.preventDefault();\n                    clearTimeout(this.activating);\n                    this._activate(selectedIndex);\n                    return;\n                case $.ui.keyCode.ENTER:\n                    // Toggle (cancel delayed activation, allow collapsing)\n                    event.preventDefault();\n                    clearTimeout(this.activating);\n                    // Determine if we should collapse or activate\n                    this._activate(selectedIndex === this.options.active ? false : selectedIndex);\n                    return;\n                default:\n                    return;\n            }\n\n            // Focus the appropriate tab, based on which key was pressed\n            event.preventDefault();\n            clearTimeout(this.activating);\n            selectedIndex = this._focusNextTab(selectedIndex, goingForward);\n\n            // Navigating with control key will prevent automatic activation\n            if (!event.ctrlKey) {\n                // Update aria-selected immediately so that AT think the tab is already selected.\n                // Otherwise AT may confuse the user by stating that they need to activate the tab,\n                // but the tab will already be activated by the time the announcement finishes.\n                focusedTab.attr(\"aria-selected\", \"false\");\n                this.tabs.eq(selectedIndex).attr(\"aria-selected\", \"true\");\n\n                this.activating = this._delay(function () {\n                    this.option(\"active\", selectedIndex);\n                }, this.delay);\n            }\n        },\n\n        _panelKeydown: function (event) {\n            if (this._handlePageNav(event)) {\n                return;\n            }\n\n            // Ctrl+up moves focus to the current tab\n            if (event.ctrlKey && event.keyCode === $.ui.keyCode.UP) {\n                event.preventDefault();\n                this.active.focus();\n            }\n        },\n\n        // Alt+page up/down moves focus to the previous/next tab (and activates)\n        _handlePageNav: function (event) {\n            if (event.altKey && event.keyCode === $.ui.keyCode.PAGE_UP) {\n                this._activate(this._focusNextTab(this.options.active - 1, false));\n                return true;\n            }\n            if (event.altKey && event.keyCode === $.ui.keyCode.PAGE_DOWN) {\n                this._activate(this._focusNextTab(this.options.active + 1, true));\n                return true;\n            }\n        },\n\n        _findNextTab: function (index, goingForward) {\n            var lastTabIndex = this.tabs.length - 1;\n\n            function constrain() {\n                if (index > lastTabIndex) {\n                    index = 0;\n                }\n                if (index < 0) {\n                    index = lastTabIndex;\n                }\n                return index;\n            }\n\n            while ($.inArray(constrain(), this.options.disabled) !== -1) {\n                index = goingForward ? index + 1 : index - 1;\n            }\n\n            return index;\n        },\n\n        _focusNextTab: function (index, goingForward) {\n            index = this._findNextTab(index, goingForward);\n            this.tabs.eq(index).focus();\n            return index;\n        },\n\n        _setOption: function (key, value) {\n            if (key === \"active\") {\n                // _activate() will handle invalid values and update this.options\n                this._activate(value);\n                return;\n            }\n\n            if (key === \"disabled\") {\n                // don't use the widget factory's disabled handling\n                this._setupDisabled(value);\n                return;\n            }\n\n            this._super(key, value);\n\n            if (key === \"collapsible\") {\n                this.element.toggleClass(\"ui-tabs-collapsible\", value);\n                // Setting collapsible: false while collapsed; open first panel\n                if (!value && this.options.active === false) {\n                    this._activate(0);\n                }\n            }\n\n            if (key === \"event\") {\n                this._setupEvents(value);\n            }\n\n            if (key === \"heightStyle\") {\n                this._setupHeightStyle(value);\n            }\n        },\n\n        _tabId: function (tab) {\n            return tab.attr(\"aria-controls\") || \"ui-tabs-\" + getNextTabId();\n        },\n\n        _sanitizeSelector: function (hash) {\n            return hash ? hash.replace(/[!\"$%&'()*+,.\\/:;<=>?@\\[\\]\\^`{|}~]/g, \"\\\\$&\") : \"\";\n        },\n\n        refresh: function () {\n            var options = this.options,\n                lis = this.tablist.children(\":has(a[href])\");\n\n            // get disabled tabs from class attribute from HTML\n            // this will get converted to a boolean if needed in _refresh()\n            options.disabled = $.map(lis.filter(\".ui-state-disabled\"), function (tab) {\n                return lis.index(tab);\n            });\n\n            this._processTabs();\n\n            // was collapsed or no tabs\n            if (options.active === false || !this.anchors.length) {\n                options.active = false;\n                this.active = $();\n                // was active, but active tab is gone\n            } else if (this.active.length && !$.contains(this.tablist[0], this.active[0])) {\n                // all remaining tabs are disabled\n                if (this.tabs.length === options.disabled.length) {\n                    options.active = false;\n                    this.active = $();\n                    // activate previous tab\n                } else {\n                    this._activate(this._findNextTab(Math.max(0, options.active - 1), false));\n                }\n                // was active, active tab still exists\n            } else {\n                // make sure active index is correct\n                options.active = this.tabs.index(this.active);\n            }\n\n            this._refresh();\n        },\n\n        _refresh: function () {\n            this._setupDisabled(this.options.disabled);\n            this._setupEvents(this.options.event);\n            this._setupHeightStyle(this.options.heightStyle);\n\n            this.tabs.not(this.active).attr({\n                \"aria-selected\": \"false\",\n                tabIndex: -1\n            });\n            this.panels.not(this._getPanelForTab(this.active))\n                .hide()\n                .attr({\n                    \"aria-expanded\": \"false\",\n                    \"aria-hidden\": \"true\"\n                });\n\n            // Make sure one tab is in the tab order\n            if (!this.active.length) {\n                this.tabs.eq(0).attr(\"tabIndex\", 0);\n            } else {\n                this.active\n                    .addClass(\"ui-tabs-active ui-state-active\")\n                    .attr({\n                        \"aria-selected\": \"true\",\n                        tabIndex: 0\n                    });\n                this._getPanelForTab(this.active)\n                    .show()\n                    .attr({\n                        \"aria-expanded\": \"true\",\n                        \"aria-hidden\": \"false\"\n                    });\n            }\n        },\n\n        _processTabs: function () {\n            var that = this;\n\n            this.tablist = this._getList()\n                .addClass(\"ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all\")\n                .attr(\"role\", \"tablist\");\n\n            this.tabs = this.tablist.find(\"> li:has(a[href])\")\n                .addClass(\"ui-state-default ui-corner-top\")\n                .attr({\n                    role: \"tab\",\n                    tabIndex: -1\n                });\n\n            this.anchors = this.tabs.map(function () {\n                return $(\"a\", this)[0];\n            })\n                .addClass(\"ui-tabs-anchor\")\n                .attr({\n                    role: \"presentation\",\n                    tabIndex: -1\n                });\n\n            this.panels = $();\n\n            this.anchors.each(function (i, anchor) {\n                var selector, panel, panelId,\n                    anchorId = $(anchor).uniqueId().attr(\"id\"),\n                    tab = $(anchor).closest(\"li\"),\n                    originalAriaControls = tab.attr(\"aria-controls\");\n\n                // inline tab\n                if (isLocal(anchor)) {\n                    selector = anchor.hash;\n                    panel = that.element.find(that._sanitizeSelector(selector));\n                    // remote tab\n                } else {\n                    panelId = that._tabId(tab);\n                    selector = \"#\" + panelId;\n                    panel = that.element.find(selector);\n                    if (!panel.length) {\n                        panel = that._createPanel(panelId);\n                        panel.insertAfter(that.panels[i - 1] || that.tablist);\n                    }\n                    panel.attr(\"aria-live\", \"polite\");\n                }\n\n                if (panel.length) {\n                    that.panels = that.panels.add(panel);\n                }\n                if (originalAriaControls) {\n                    tab.data(\"ui-tabs-aria-controls\", originalAriaControls);\n                }\n                tab.attr({\n                    \"aria-controls\": selector.substring(1),\n                    \"aria-labelledby\": anchorId\n                });\n                panel.attr(\"aria-labelledby\", anchorId);\n            });\n\n            this.panels\n                .addClass(\"ui-tabs-panel ui-widget-content ui-corner-bottom\")\n                .attr(\"role\", \"tabpanel\");\n        },\n\n        // allow overriding how to find the list for rare usage scenarios (#7715)\n        _getList: function () {\n            return this.tablist || this.element.find(\"ol,ul\").eq(0);\n        },\n\n        _createPanel: function (id) {\n            return $(\"<div>\")\n                .attr(\"id\", id)\n                .addClass(\"ui-tabs-panel ui-widget-content ui-corner-bottom\")\n                .data(\"ui-tabs-destroy\", true);\n        },\n\n        _setupDisabled: function (disabled) {\n            if ($.isArray(disabled)) {\n                if (!disabled.length) {\n                    disabled = false;\n                } else if (disabled.length === this.anchors.length) {\n                    disabled = true;\n                }\n            }\n\n            // disable tabs\n            for (var i = 0, li; (li = this.tabs[i]); i++) {\n                if (disabled === true || $.inArray(i, disabled) !== -1) {\n                    $(li)\n                        .addClass(\"ui-state-disabled\")\n                        .attr(\"aria-disabled\", \"true\");\n                } else {\n                    $(li)\n                        .removeClass(\"ui-state-disabled\")\n                        .removeAttr(\"aria-disabled\");\n                }\n            }\n\n            this.options.disabled = disabled;\n        },\n\n        _setupEvents: function (event) {\n            var events = {\n                click: function (event) {\n                    event.preventDefault();\n                }\n            };\n            if (event) {\n                $.each(event.split(\" \"), function (index, eventName) {\n                    events[eventName] = \"_eventHandler\";\n                });\n            }\n\n            this._off(this.anchors.add(this.tabs).add(this.panels));\n            this._on(this.anchors, events);\n            this._on(this.tabs, {keydown: \"_tabKeydown\"});\n            this._on(this.panels, {keydown: \"_panelKeydown\"});\n\n            this._focusable(this.tabs);\n            this._hoverable(this.tabs);\n        },\n\n        _setupHeightStyle: function (heightStyle) {\n            var maxHeight,\n                parent = this.element.parent();\n\n            if (heightStyle === \"fill\") {\n                maxHeight = parent.height();\n                maxHeight -= this.element.outerHeight() - this.element.height();\n\n                this.element.siblings(\":visible\").each(function () {\n                    var elem = $(this),\n                        position = elem.css(\"position\");\n\n                    if (position === \"absolute\" || position === \"fixed\") {\n                        return;\n                    }\n                    maxHeight -= elem.outerHeight(true);\n                });\n\n                this.element.children().not(this.panels).each(function () {\n                    maxHeight -= $(this).outerHeight(true);\n                });\n\n                this.panels.each(function () {\n                    $(this).height(Math.max(0, maxHeight -\n                        $(this).innerHeight() + $(this).height()));\n                })\n                    .css(\"overflow\", \"auto\");\n            } else if (heightStyle === \"auto\") {\n                maxHeight = 0;\n                this.panels.each(function () {\n                    maxHeight = Math.max(maxHeight, $(this).height(\"\").height());\n                }).height(maxHeight);\n            }\n        },\n\n        _eventHandler: function (event) {\n            var options = this.options,\n                active = this.active,\n                anchor = $(event.currentTarget),\n                tab = anchor.closest(\"li\"),\n                clickedIsActive = tab[0] === active[0],\n                collapsing = clickedIsActive && options.collapsible,\n                toShow = collapsing ? $() : this._getPanelForTab(tab),\n                toHide = !active.length ? $() : this._getPanelForTab(active),\n                eventData = {\n                    oldTab: active,\n                    oldPanel: toHide,\n                    newTab: collapsing ? $() : tab,\n                    newPanel: toShow\n                };\n\n            event.preventDefault();\n\n            if (tab.hasClass(\"ui-state-disabled\") ||\n                // tab is already loading\n                tab.hasClass(\"ui-tabs-loading\") ||\n                // can't switch durning an animation\n                this.running ||\n                // click on active header, but not collapsible\n                (clickedIsActive && !options.collapsible) ||\n                // allow canceling activation\n                (this._trigger(\"beforeActivate\", event, eventData) === false)) {\n                return;\n            }\n\n            options.active = collapsing ? false : this.tabs.index(tab);\n\n            this.active = clickedIsActive ? $() : tab;\n            if (this.xhr) {\n                this.xhr.abort();\n            }\n\n            if (!toHide.length && !toShow.length) {\n                $.error(\"jQuery UI Tabs: Mismatching fragment identifier.\");\n            }\n\n            if (toShow.length) {\n                this.load(this.tabs.index(tab), event);\n            }\n            this._toggle(event, eventData);\n        },\n\n        // handles show/hide for selecting tabs\n        _toggle: function (event, eventData) {\n            var that = this,\n                toShow = eventData.newPanel,\n                toHide = eventData.oldPanel;\n\n            this.running = true;\n\n            function complete() {\n                that.running = false;\n                that._trigger(\"activate\", event, eventData);\n            }\n\n            function show() {\n                eventData.newTab.closest(\"li\").addClass(\"ui-tabs-active ui-state-active\");\n\n                if (toShow.length && that.options.show) {\n                    that._show(toShow, that.options.show, complete);\n                } else {\n                    toShow.show();\n                    complete();\n                }\n            }\n\n            // start out by hiding, then showing, then completing\n            if (toHide.length && this.options.hide) {\n                this._hide(toHide, this.options.hide, function () {\n                    eventData.oldTab.closest(\"li\").removeClass(\"ui-tabs-active ui-state-active\");\n                    show();\n                });\n            } else {\n                eventData.oldTab.closest(\"li\").removeClass(\"ui-tabs-active ui-state-active\");\n                toHide.hide();\n                show();\n            }\n\n            toHide.attr({\n                \"aria-expanded\": \"false\",\n                \"aria-hidden\": \"true\"\n            });\n            eventData.oldTab.attr(\"aria-selected\", \"false\");\n            // If we're switching tabs, remove the old tab from the tab order.\n            // If we're opening from collapsed state, remove the previous tab from the tab order.\n            // If we're collapsing, then keep the collapsing tab in the tab order.\n            if (toShow.length && toHide.length) {\n                eventData.oldTab.attr(\"tabIndex\", -1);\n            } else if (toShow.length) {\n                this.tabs.filter(function () {\n                    return $(this).attr(\"tabIndex\") === 0;\n                })\n                    .attr(\"tabIndex\", -1);\n            }\n\n            toShow.attr({\n                \"aria-expanded\": \"true\",\n                \"aria-hidden\": \"false\"\n            });\n            eventData.newTab.attr({\n                \"aria-selected\": \"true\",\n                tabIndex: 0\n            });\n        },\n\n        _activate: function (index) {\n            var anchor,\n                active = this._findActive(index);\n\n            // trying to activate the already active panel\n            if (active[0] === this.active[0]) {\n                return;\n            }\n\n            // trying to collapse, simulate a click on the current active header\n            if (!active.length) {\n                active = this.active;\n            }\n\n            anchor = active.find(\".ui-tabs-anchor\")[0];\n            this._eventHandler({\n                target: anchor,\n                currentTarget: anchor,\n                preventDefault: $.noop\n            });\n        },\n\n        _findActive: function (index) {\n            return index === false ? $() : this.tabs.eq(index);\n        },\n\n        _getIndex: function (index) {\n            // meta-function to give users option to provide a href string instead of a numerical index.\n            if (typeof index === \"string\") {\n                index = this.anchors.index(this.anchors.filter(\"[href$='\" + index + \"']\"));\n            }\n\n            return index;\n        },\n\n        _destroy: function () {\n            if (this.xhr) {\n                this.xhr.abort();\n            }\n\n            this.element.removeClass(\"ui-tabs ui-widget ui-widget-content ui-corner-all ui-tabs-collapsible\");\n\n            this.tablist\n                .removeClass(\"ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all\")\n                .removeAttr(\"role\");\n\n            this.anchors\n                .removeClass(\"ui-tabs-anchor\")\n                .removeAttr(\"role\")\n                .removeAttr(\"tabIndex\")\n                .removeUniqueId();\n\n            this.tabs.add(this.panels).each(function () {\n                if ($.data(this, \"ui-tabs-destroy\")) {\n                    $(this).remove();\n                } else {\n                    $(this)\n                        .removeClass(\"ui-state-default ui-state-active ui-state-disabled \" +\n                            \"ui-corner-top ui-corner-bottom ui-widget-content ui-tabs-active ui-tabs-panel\")\n                        .removeAttr(\"tabIndex\")\n                        .removeAttr(\"aria-live\")\n                        .removeAttr(\"aria-busy\")\n                        .removeAttr(\"aria-selected\")\n                        .removeAttr(\"aria-labelledby\")\n                        .removeAttr(\"aria-hidden\")\n                        .removeAttr(\"aria-expanded\")\n                        .removeAttr(\"role\");\n                }\n            });\n\n            this.tabs.each(function () {\n                var li = $(this),\n                    prev = li.data(\"ui-tabs-aria-controls\");\n                if (prev) {\n                    li\n                        .attr(\"aria-controls\", prev)\n                        .removeData(\"ui-tabs-aria-controls\");\n                } else {\n                    li.removeAttr(\"aria-controls\");\n                }\n            });\n\n            this.panels.show();\n\n            if (this.options.heightStyle !== \"content\") {\n                this.panels.css(\"height\", \"\");\n            }\n        },\n\n        enable: function (index) {\n            var disabled = this.options.disabled;\n            if (disabled === false) {\n                return;\n            }\n\n            if (index === undefined) {\n                disabled = false;\n            } else {\n                index = this._getIndex(index);\n                if ($.isArray(disabled)) {\n                    disabled = $.map(disabled, function (num) {\n                        return num !== index ? num : null;\n                    });\n                } else {\n                    disabled = $.map(this.tabs, function (li, num) {\n                        return num !== index ? num : null;\n                    });\n                }\n            }\n            this._setupDisabled(disabled);\n        },\n\n        disable: function (index) {\n            var disabled = this.options.disabled;\n            if (disabled === true) {\n                return;\n            }\n\n            if (index === undefined) {\n                disabled = true;\n            } else {\n                index = this._getIndex(index);\n                if ($.inArray(index, disabled) !== -1) {\n                    return;\n                }\n                if ($.isArray(disabled)) {\n                    disabled = $.merge([index], disabled).sort();\n                } else {\n                    disabled = [index];\n                }\n            }\n            this._setupDisabled(disabled);\n        },\n\n        load: function (index, event) {\n            index = this._getIndex(index);\n            var that = this,\n                tab = this.tabs.eq(index),\n                anchor = tab.find(\".ui-tabs-anchor\"),\n                panel = this._getPanelForTab(tab),\n                eventData = {\n                    tab: tab,\n                    panel: panel\n                };\n\n            // not remote\n            if (isLocal(anchor[0])) {\n                return;\n            }\n\n            this.xhr = $.ajax(this._ajaxSettings(anchor, event, eventData));\n\n            // support: jQuery <1.8\n            // jQuery <1.8 returns false if the request is canceled in beforeSend,\n            // but as of 1.8, $.ajax() always returns a jqXHR object.\n            if (this.xhr && this.xhr.statusText !== \"canceled\") {\n                tab.addClass(\"ui-tabs-loading\");\n                panel.attr(\"aria-busy\", \"true\");\n\n                this.xhr\n                    .success(function (response) {\n                        // support: jQuery <1.8\n                        // http://bugs.jquery.com/ticket/11778\n                        setTimeout(function () {\n                            panel.html(response);\n                            that._trigger(\"load\", event, eventData);\n                        }, 1);\n                    })\n                    .complete(function (jqXHR, status) {\n                        // support: jQuery <1.8\n                        // http://bugs.jquery.com/ticket/11778\n                        setTimeout(function () {\n                            if (status === \"abort\") {\n                                that.panels.stop(false, true);\n                            }\n\n                            tab.removeClass(\"ui-tabs-loading\");\n                            panel.removeAttr(\"aria-busy\");\n\n                            if (jqXHR === that.xhr) {\n                                delete that.xhr;\n                            }\n                        }, 1);\n                    });\n            }\n        },\n\n        _ajaxSettings: function (anchor, event, eventData) {\n            var that = this;\n            return {\n                url: anchor.attr(\"href\"),\n                beforeSend: function (jqXHR, settings) {\n                    return that._trigger(\"beforeLoad\", event,\n                        $.extend({jqXHR: jqXHR, ajaxSettings: settings}, eventData));\n                }\n            };\n        },\n\n        _getPanelForTab: function (tab) {\n            var id = $(tab).attr(\"aria-controls\");\n            return this.element.find(this._sanitizeSelector(\"#\" + id));\n        }\n    });\n\n});\n","jquery/ui-modules/position.js":"/*!\n * jQuery UI Position - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\ndefine([\n    'jquery'\n], function ($, undefined) {\n\n    $.ui = $.ui || {};\n\n    var cachedScrollbarWidth,\n        max = Math.max,\n        abs = Math.abs,\n        round = Math.round,\n        rhorizontal = /left|center|right/,\n        rvertical = /top|center|bottom/,\n        roffset = /[\\+\\-]\\d+(\\.[\\d]+)?%?/,\n        rposition = /^\\w+/,\n        rpercent = /%$/,\n        _position = $.fn.position;\n\n    function getOffsets(offsets, width, height) {\n        return [\n            parseFloat(offsets[0]) * (rpercent.test(offsets[0]) ? width / 100 : 1),\n            parseFloat(offsets[1]) * (rpercent.test(offsets[1]) ? height / 100 : 1)\n        ];\n    }\n\n    function parseCss(element, property) {\n        return parseInt($.css(element, property), 10) || 0;\n    }\n\n    function getDimensions(elem) {\n        var raw = elem[0];\n        if (raw.nodeType === 9) {\n            return {\n                width: elem.width(),\n                height: elem.height(),\n                offset: {top: 0, left: 0}\n            };\n        }\n        if ($.isWindow(raw)) {\n            return {\n                width: elem.width(),\n                height: elem.height(),\n                offset: {top: elem.scrollTop(), left: elem.scrollLeft()}\n            };\n        }\n        if (raw.preventDefault) {\n            return {\n                width: 0,\n                height: 0,\n                offset: {top: raw.pageY, left: raw.pageX}\n            };\n        }\n        return {\n            width: elem.outerWidth(),\n            height: elem.outerHeight(),\n            offset: elem.offset()\n        };\n    }\n\n    $.position = {\n        scrollbarWidth: function () {\n            if (cachedScrollbarWidth !== undefined) {\n                return cachedScrollbarWidth;\n            }\n            var w1, w2,\n                div = $(\"<div style='display:block;position:absolute;width:50px;height:50px;overflow:hidden;'><div style='height:100px;width:auto;'></div></div>\"),\n                innerDiv = div.children()[0];\n\n            $(\"body\").append(div);\n            w1 = innerDiv.offsetWidth;\n            div.css(\"overflow\", \"scroll\");\n\n            w2 = innerDiv.offsetWidth;\n\n            if (w1 === w2) {\n                w2 = div[0].clientWidth;\n            }\n\n            div.remove();\n\n            return (cachedScrollbarWidth = w1 - w2);\n        },\n        getScrollInfo: function (within) {\n            var overflowX = within.isWindow || within.isDocument ? \"\" :\n                within.element.css(\"overflow-x\"),\n                overflowY = within.isWindow || within.isDocument ? \"\" :\n                    within.element.css(\"overflow-y\"),\n                hasOverflowX = overflowX === \"scroll\" ||\n                    (overflowX === \"auto\" && within.width < within.element[0].scrollWidth),\n                hasOverflowY = overflowY === \"scroll\" ||\n                    (overflowY === \"auto\" && within.height < within.element[0].scrollHeight);\n            return {\n                width: hasOverflowY ? $.position.scrollbarWidth() : 0,\n                height: hasOverflowX ? $.position.scrollbarWidth() : 0\n            };\n        },\n        getWithinInfo: function (element) {\n            var withinElement = $(element || window),\n                isWindow = $.isWindow(withinElement[0]),\n                isDocument = !!withinElement[0] && withinElement[0].nodeType === 9;\n            return {\n                element: withinElement,\n                isWindow: isWindow,\n                isDocument: isDocument,\n                offset: withinElement.offset() || {left: 0, top: 0},\n                scrollLeft: withinElement.scrollLeft(),\n                scrollTop: withinElement.scrollTop(),\n                width: isWindow ? withinElement.width() : withinElement.outerWidth(),\n                height: isWindow ? withinElement.height() : withinElement.outerHeight()\n            };\n        }\n    };\n\n    $.fn.position = function (options) {\n        if (!options || !options.of) {\n            return _position.apply(this, arguments);\n        }\n\n        // make a copy, we don't want to modify arguments\n        options = $.extend({}, options);\n\n        var atOffset, targetWidth, targetHeight, targetOffset, basePosition, dimensions,\n            target = $(options.of),\n            within = $.position.getWithinInfo(options.within),\n            scrollInfo = $.position.getScrollInfo(within),\n            collision = (options.collision || \"flip\").split(\" \"),\n            offsets = {};\n\n        dimensions = getDimensions(target);\n        if (target[0].preventDefault) {\n            // force left top to allow flipping\n            options.at = \"left top\";\n        }\n        targetWidth = dimensions.width;\n        targetHeight = dimensions.height;\n        targetOffset = dimensions.offset;\n        // clone to reuse original targetOffset later\n        basePosition = $.extend({}, targetOffset);\n\n        // force my and at to have valid horizontal and vertical positions\n        // if a value is missing or invalid, it will be converted to center\n        $.each([\"my\", \"at\"], function () {\n            var pos = (options[this] || \"\").split(\" \"),\n                horizontalOffset,\n                verticalOffset;\n\n            if (pos.length === 1) {\n                pos = rhorizontal.test(pos[0]) ?\n                    pos.concat([\"center\"]) :\n                    rvertical.test(pos[0]) ?\n                        [\"center\"].concat(pos) :\n                        [\"center\", \"center\"];\n            }\n            pos[0] = rhorizontal.test(pos[0]) ? pos[0] : \"center\";\n            pos[1] = rvertical.test(pos[1]) ? pos[1] : \"center\";\n\n            // calculate offsets\n            horizontalOffset = roffset.exec(pos[0]);\n            verticalOffset = roffset.exec(pos[1]);\n            offsets[this] = [\n                horizontalOffset ? horizontalOffset[0] : 0,\n                verticalOffset ? verticalOffset[0] : 0\n            ];\n\n            // reduce to just the positions without the offsets\n            options[this] = [\n                rposition.exec(pos[0])[0],\n                rposition.exec(pos[1])[0]\n            ];\n        });\n\n        // normalize collision option\n        if (collision.length === 1) {\n            collision[1] = collision[0];\n        }\n\n        if (options.at[0] === \"right\") {\n            basePosition.left += targetWidth;\n        } else if (options.at[0] === \"center\") {\n            basePosition.left += targetWidth / 2;\n        }\n\n        if (options.at[1] === \"bottom\") {\n            basePosition.top += targetHeight;\n        } else if (options.at[1] === \"center\") {\n            basePosition.top += targetHeight / 2;\n        }\n\n        atOffset = getOffsets(offsets.at, targetWidth, targetHeight);\n        basePosition.left += atOffset[0];\n        basePosition.top += atOffset[1];\n\n        return this.each(function () {\n            var collisionPosition, using,\n                elem = $(this),\n                elemWidth = elem.outerWidth(),\n                elemHeight = elem.outerHeight(),\n                marginLeft = parseCss(this, \"marginLeft\"),\n                marginTop = parseCss(this, \"marginTop\"),\n                collisionWidth = elemWidth + marginLeft + parseCss(this, \"marginRight\") + scrollInfo.width,\n                collisionHeight = elemHeight + marginTop + parseCss(this, \"marginBottom\") + scrollInfo.height,\n                position = $.extend({}, basePosition),\n                myOffset = getOffsets(offsets.my, elem.outerWidth(), elem.outerHeight());\n\n            if (options.my[0] === \"right\") {\n                position.left -= elemWidth;\n            } else if (options.my[0] === \"center\") {\n                position.left -= elemWidth / 2;\n            }\n\n            if (options.my[1] === \"bottom\") {\n                position.top -= elemHeight;\n            } else if (options.my[1] === \"center\") {\n                position.top -= elemHeight / 2;\n            }\n\n            position.left += myOffset[0];\n            position.top += myOffset[1];\n\n            // if the browser doesn't support fractions, then round for consistent results\n            if (!$.support.offsetFractions) {\n                position.left = round(position.left);\n                position.top = round(position.top);\n            }\n\n            collisionPosition = {\n                marginLeft: marginLeft,\n                marginTop: marginTop\n            };\n\n            $.each([\"left\", \"top\"], function (i, dir) {\n                if ($.ui.position[collision[i]]) {\n                    $.ui.position[collision[i]][dir](position, {\n                        targetWidth: targetWidth,\n                        targetHeight: targetHeight,\n                        elemWidth: elemWidth,\n                        elemHeight: elemHeight,\n                        collisionPosition: collisionPosition,\n                        collisionWidth: collisionWidth,\n                        collisionHeight: collisionHeight,\n                        offset: [atOffset[0] + myOffset[0], atOffset [1] + myOffset[1]],\n                        my: options.my,\n                        at: options.at,\n                        within: within,\n                        elem: elem\n                    });\n                }\n            });\n\n            if (options.using) {\n                // adds feedback as second argument to using callback, if present\n                using = function (props) {\n                    var left = targetOffset.left - position.left,\n                        right = left + targetWidth - elemWidth,\n                        top = targetOffset.top - position.top,\n                        bottom = top + targetHeight - elemHeight,\n                        feedback = {\n                            target: {\n                                element: target,\n                                left: targetOffset.left,\n                                top: targetOffset.top,\n                                width: targetWidth,\n                                height: targetHeight\n                            },\n                            element: {\n                                element: elem,\n                                left: position.left,\n                                top: position.top,\n                                width: elemWidth,\n                                height: elemHeight\n                            },\n                            horizontal: right < 0 ? \"left\" : left > 0 ? \"right\" : \"center\",\n                            vertical: bottom < 0 ? \"top\" : top > 0 ? \"bottom\" : \"middle\"\n                        };\n                    if (targetWidth < elemWidth && abs(left + right) < targetWidth) {\n                        feedback.horizontal = \"center\";\n                    }\n                    if (targetHeight < elemHeight && abs(top + bottom) < targetHeight) {\n                        feedback.vertical = \"middle\";\n                    }\n                    if (max(abs(left), abs(right)) > max(abs(top), abs(bottom))) {\n                        feedback.important = \"horizontal\";\n                    } else {\n                        feedback.important = \"vertical\";\n                    }\n                    options.using.call(this, props, feedback);\n                };\n            }\n\n            elem.offset($.extend(position, {using: using}));\n        });\n    };\n\n    $.ui.position = {\n        fit: {\n            left: function (position, data) {\n                var within = data.within,\n                    withinOffset = within.isWindow ? within.scrollLeft : within.offset.left,\n                    outerWidth = within.width,\n                    collisionPosLeft = position.left - data.collisionPosition.marginLeft,\n                    overLeft = withinOffset - collisionPosLeft,\n                    overRight = collisionPosLeft + data.collisionWidth - outerWidth - withinOffset,\n                    newOverRight;\n\n                // element is wider than within\n                if (data.collisionWidth > outerWidth) {\n                    // element is initially over the left side of within\n                    if (overLeft > 0 && overRight <= 0) {\n                        newOverRight = position.left + overLeft + data.collisionWidth - outerWidth - withinOffset;\n                        position.left += overLeft - newOverRight;\n                        // element is initially over right side of within\n                    } else if (overRight > 0 && overLeft <= 0) {\n                        position.left = withinOffset;\n                        // element is initially over both left and right sides of within\n                    } else {\n                        if (overLeft > overRight) {\n                            position.left = withinOffset + outerWidth - data.collisionWidth;\n                        } else {\n                            position.left = withinOffset;\n                        }\n                    }\n                    // too far left -> align with left edge\n                } else if (overLeft > 0) {\n                    position.left += overLeft;\n                    // too far right -> align with right edge\n                } else if (overRight > 0) {\n                    position.left -= overRight;\n                    // adjust based on position and margin\n                } else {\n                    position.left = max(position.left - collisionPosLeft, position.left);\n                }\n            },\n            top: function (position, data) {\n                var within = data.within,\n                    withinOffset = within.isWindow ? within.scrollTop : within.offset.top,\n                    outerHeight = data.within.height,\n                    collisionPosTop = position.top - data.collisionPosition.marginTop,\n                    overTop = withinOffset - collisionPosTop,\n                    overBottom = collisionPosTop + data.collisionHeight - outerHeight - withinOffset,\n                    newOverBottom;\n\n                // element is taller than within\n                if (data.collisionHeight > outerHeight) {\n                    // element is initially over the top of within\n                    if (overTop > 0 && overBottom <= 0) {\n                        newOverBottom = position.top + overTop + data.collisionHeight - outerHeight - withinOffset;\n                        position.top += overTop - newOverBottom;\n                        // element is initially over bottom of within\n                    } else if (overBottom > 0 && overTop <= 0) {\n                        position.top = withinOffset;\n                        // element is initially over both top and bottom of within\n                    } else {\n                        if (overTop > overBottom) {\n                            position.top = withinOffset + outerHeight - data.collisionHeight;\n                        } else {\n                            position.top = withinOffset;\n                        }\n                    }\n                    // too far up -> align with top\n                } else if (overTop > 0) {\n                    position.top += overTop;\n                    // too far down -> align with bottom edge\n                } else if (overBottom > 0) {\n                    position.top -= overBottom;\n                    // adjust based on position and margin\n                } else {\n                    position.top = max(position.top - collisionPosTop, position.top);\n                }\n            }\n        },\n        flip: {\n            left: function (position, data) {\n                var within = data.within,\n                    withinOffset = within.offset.left + within.scrollLeft,\n                    outerWidth = within.width,\n                    offsetLeft = within.isWindow ? within.scrollLeft : within.offset.left,\n                    collisionPosLeft = position.left - data.collisionPosition.marginLeft,\n                    overLeft = collisionPosLeft - offsetLeft,\n                    overRight = collisionPosLeft + data.collisionWidth - outerWidth - offsetLeft,\n                    myOffset = data.my[0] === \"left\" ?\n                        -data.elemWidth :\n                        data.my[0] === \"right\" ?\n                            data.elemWidth :\n                            0,\n                    atOffset = data.at[0] === \"left\" ?\n                        data.targetWidth :\n                        data.at[0] === \"right\" ?\n                            -data.targetWidth :\n                            0,\n                    offset = -2 * data.offset[0],\n                    newOverRight,\n                    newOverLeft;\n\n                if (overLeft < 0) {\n                    newOverRight = position.left + myOffset + atOffset + offset + data.collisionWidth - outerWidth - withinOffset;\n                    if (newOverRight < 0 || newOverRight < abs(overLeft)) {\n                        position.left += myOffset + atOffset + offset;\n                    }\n                } else if (overRight > 0) {\n                    newOverLeft = position.left - data.collisionPosition.marginLeft + myOffset + atOffset + offset - offsetLeft;\n                    if (newOverLeft > 0 || abs(newOverLeft) < overRight) {\n                        position.left += myOffset + atOffset + offset;\n                    }\n                }\n            },\n            top: function (position, data) {\n                var within = data.within,\n                    withinOffset = within.offset.top + within.scrollTop,\n                    outerHeight = within.height,\n                    offsetTop = within.isWindow ? within.scrollTop : within.offset.top,\n                    collisionPosTop = position.top - data.collisionPosition.marginTop,\n                    overTop = collisionPosTop - offsetTop,\n                    overBottom = collisionPosTop + data.collisionHeight - outerHeight - offsetTop,\n                    top = data.my[1] === \"top\",\n                    myOffset = top ?\n                        -data.elemHeight :\n                        data.my[1] === \"bottom\" ?\n                            data.elemHeight :\n                            0,\n                    atOffset = data.at[1] === \"top\" ?\n                        data.targetHeight :\n                        data.at[1] === \"bottom\" ?\n                            -data.targetHeight :\n                            0,\n                    offset = -2 * data.offset[1],\n                    newOverTop,\n                    newOverBottom;\n                if (overTop < 0) {\n                    newOverBottom = position.top + myOffset + atOffset + offset + data.collisionHeight - outerHeight - withinOffset;\n                    if ((position.top + myOffset + atOffset + offset) > overTop && (newOverBottom < 0 || newOverBottom < abs(overTop))) {\n                        position.top += myOffset + atOffset + offset;\n                    }\n                } else if (overBottom > 0) {\n                    newOverTop = position.top - data.collisionPosition.marginTop + myOffset + atOffset + offset - offsetTop;\n                    if ((position.top + myOffset + atOffset + offset) > overBottom && (newOverTop > 0 || abs(newOverTop) < overBottom)) {\n                        position.top += myOffset + atOffset + offset;\n                    }\n                }\n            }\n        },\n        flipfit: {\n            left: function () {\n                $.ui.position.flip.left.apply(this, arguments);\n                $.ui.position.fit.left.apply(this, arguments);\n            },\n            top: function () {\n                $.ui.position.flip.top.apply(this, arguments);\n                $.ui.position.fit.top.apply(this, arguments);\n            }\n        }\n    };\n\n// fraction support test\n    (function () {\n        var testElement, testElementParent, testElementStyle, offsetLeft, i,\n            body = document.getElementsByTagName(\"body\")[0],\n            div = document.createElement(\"div\");\n\n        //Create a \"fake body\" for testing based on method used in jQuery.support\n        testElement = document.createElement(body ? \"div\" : \"body\");\n        testElementStyle = {\n            visibility: \"hidden\",\n            width: 0,\n            height: 0,\n            border: 0,\n            margin: 0,\n            background: \"none\"\n        };\n        if (body) {\n            $.extend(testElementStyle, {\n                position: \"absolute\",\n                left: \"-1000px\",\n                top: \"-1000px\"\n            });\n        }\n        for (i in testElementStyle) {\n            testElement.style[i] = testElementStyle[i];\n        }\n        testElement.appendChild(div);\n        testElementParent = body || document.documentElement;\n        testElementParent.insertBefore(testElement, testElementParent.firstChild);\n\n        div.style.cssText = \"position: absolute; left: 10.7432222px;\";\n\n        offsetLeft = $(div).offset().left;\n        $.support.offsetFractions = offsetLeft > 10 && offsetLeft < 11;\n\n        testElement.innerHTML = \"\";\n        testElementParent.removeChild(testElement);\n    })();\n\n});\n","jquery/ui-modules/selectable.js":"/*!\n * jQuery UI Selectable - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/selectable/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/mouse'\n], function ($, undefined) {\n\n    $.widget(\"ui.selectable\", $.ui.mouse, {\n        version: \"1.10.4\",\n        options: {\n            appendTo: \"body\",\n            autoRefresh: true,\n            distance: 0,\n            filter: \"*\",\n            tolerance: \"touch\",\n\n            // callbacks\n            selected: null,\n            selecting: null,\n            start: null,\n            stop: null,\n            unselected: null,\n            unselecting: null\n        },\n        _create: function () {\n            var selectees,\n                that = this;\n\n            this.element.addClass(\"ui-selectable\");\n\n            this.dragged = false;\n\n            // cache selectee children based on filter\n            this.refresh = function () {\n                selectees = $(that.options.filter, that.element[0]);\n                selectees.addClass(\"ui-selectee\");\n                selectees.each(function () {\n                    var $this = $(this),\n                        pos = $this.offset();\n                    $.data(this, \"selectable-item\", {\n                        element: this,\n                        $element: $this,\n                        left: pos.left,\n                        top: pos.top,\n                        right: pos.left + $this.outerWidth(),\n                        bottom: pos.top + $this.outerHeight(),\n                        startselected: false,\n                        selected: $this.hasClass(\"ui-selected\"),\n                        selecting: $this.hasClass(\"ui-selecting\"),\n                        unselecting: $this.hasClass(\"ui-unselecting\")\n                    });\n                });\n            };\n            this.refresh();\n\n            this.selectees = selectees.addClass(\"ui-selectee\");\n\n            this._mouseInit();\n\n            this.helper = $(\"<div class='ui-selectable-helper'></div>\");\n        },\n\n        _destroy: function () {\n            this.selectees\n                .removeClass(\"ui-selectee\")\n                .removeData(\"selectable-item\");\n            this.element\n                .removeClass(\"ui-selectable ui-selectable-disabled\");\n            this._mouseDestroy();\n        },\n\n        _mouseStart: function (event) {\n            var that = this,\n                options = this.options;\n\n            this.opos = [event.pageX, event.pageY];\n\n            if (this.options.disabled) {\n                return;\n            }\n\n            this.selectees = $(options.filter, this.element[0]);\n\n            this._trigger(\"start\", event);\n\n            $(options.appendTo).append(this.helper);\n            // position helper (lasso)\n            this.helper.css({\n                \"left\": event.pageX,\n                \"top\": event.pageY,\n                \"width\": 0,\n                \"height\": 0\n            });\n\n            if (options.autoRefresh) {\n                this.refresh();\n            }\n\n            this.selectees.filter(\".ui-selected\").each(function () {\n                var selectee = $.data(this, \"selectable-item\");\n                selectee.startselected = true;\n                if (!event.metaKey && !event.ctrlKey) {\n                    selectee.$element.removeClass(\"ui-selected\");\n                    selectee.selected = false;\n                    selectee.$element.addClass(\"ui-unselecting\");\n                    selectee.unselecting = true;\n                    // selectable UNSELECTING callback\n                    that._trigger(\"unselecting\", event, {\n                        unselecting: selectee.element\n                    });\n                }\n            });\n\n            $(event.target).parents().addBack().each(function () {\n                var doSelect,\n                    selectee = $.data(this, \"selectable-item\");\n                if (selectee) {\n                    doSelect = (!event.metaKey && !event.ctrlKey) || !selectee.$element.hasClass(\"ui-selected\");\n                    selectee.$element\n                        .removeClass(doSelect ? \"ui-unselecting\" : \"ui-selected\")\n                        .addClass(doSelect ? \"ui-selecting\" : \"ui-unselecting\");\n                    selectee.unselecting = !doSelect;\n                    selectee.selecting = doSelect;\n                    selectee.selected = doSelect;\n                    // selectable (UN)SELECTING callback\n                    if (doSelect) {\n                        that._trigger(\"selecting\", event, {\n                            selecting: selectee.element\n                        });\n                    } else {\n                        that._trigger(\"unselecting\", event, {\n                            unselecting: selectee.element\n                        });\n                    }\n                    return false;\n                }\n            });\n\n        },\n\n        _mouseDrag: function (event) {\n\n            this.dragged = true;\n\n            if (this.options.disabled) {\n                return;\n            }\n\n            var tmp,\n                that = this,\n                options = this.options,\n                x1 = this.opos[0],\n                y1 = this.opos[1],\n                x2 = event.pageX,\n                y2 = event.pageY;\n\n            if (x1 > x2) {\n                tmp = x2;\n                x2 = x1;\n                x1 = tmp;\n            }\n            if (y1 > y2) {\n                tmp = y2;\n                y2 = y1;\n                y1 = tmp;\n            }\n            this.helper.css({left: x1, top: y1, width: x2 - x1, height: y2 - y1});\n\n            this.selectees.each(function () {\n                var selectee = $.data(this, \"selectable-item\"),\n                    hit = false;\n\n                //prevent helper from being selected if appendTo: selectable\n                if (!selectee || selectee.element === that.element[0]) {\n                    return;\n                }\n\n                if (options.tolerance === \"touch\") {\n                    hit = (!(selectee.left > x2 || selectee.right < x1 || selectee.top > y2 || selectee.bottom < y1));\n                } else if (options.tolerance === \"fit\") {\n                    hit = (selectee.left > x1 && selectee.right < x2 && selectee.top > y1 && selectee.bottom < y2);\n                }\n\n                if (hit) {\n                    // SELECT\n                    if (selectee.selected) {\n                        selectee.$element.removeClass(\"ui-selected\");\n                        selectee.selected = false;\n                    }\n                    if (selectee.unselecting) {\n                        selectee.$element.removeClass(\"ui-unselecting\");\n                        selectee.unselecting = false;\n                    }\n                    if (!selectee.selecting) {\n                        selectee.$element.addClass(\"ui-selecting\");\n                        selectee.selecting = true;\n                        // selectable SELECTING callback\n                        that._trigger(\"selecting\", event, {\n                            selecting: selectee.element\n                        });\n                    }\n                } else {\n                    // UNSELECT\n                    if (selectee.selecting) {\n                        if ((event.metaKey || event.ctrlKey) && selectee.startselected) {\n                            selectee.$element.removeClass(\"ui-selecting\");\n                            selectee.selecting = false;\n                            selectee.$element.addClass(\"ui-selected\");\n                            selectee.selected = true;\n                        } else {\n                            selectee.$element.removeClass(\"ui-selecting\");\n                            selectee.selecting = false;\n                            if (selectee.startselected) {\n                                selectee.$element.addClass(\"ui-unselecting\");\n                                selectee.unselecting = true;\n                            }\n                            // selectable UNSELECTING callback\n                            that._trigger(\"unselecting\", event, {\n                                unselecting: selectee.element\n                            });\n                        }\n                    }\n                    if (selectee.selected) {\n                        if (!event.metaKey && !event.ctrlKey && !selectee.startselected) {\n                            selectee.$element.removeClass(\"ui-selected\");\n                            selectee.selected = false;\n\n                            selectee.$element.addClass(\"ui-unselecting\");\n                            selectee.unselecting = true;\n                            // selectable UNSELECTING callback\n                            that._trigger(\"unselecting\", event, {\n                                unselecting: selectee.element\n                            });\n                        }\n                    }\n                }\n            });\n\n            return false;\n        },\n\n        _mouseStop: function (event) {\n            var that = this;\n\n            this.dragged = false;\n\n            $(\".ui-unselecting\", this.element[0]).each(function () {\n                var selectee = $.data(this, \"selectable-item\");\n                selectee.$element.removeClass(\"ui-unselecting\");\n                selectee.unselecting = false;\n                selectee.startselected = false;\n                that._trigger(\"unselected\", event, {\n                    unselected: selectee.element\n                });\n            });\n            $(\".ui-selecting\", this.element[0]).each(function () {\n                var selectee = $.data(this, \"selectable-item\");\n                selectee.$element.removeClass(\"ui-selecting\").addClass(\"ui-selected\");\n                selectee.selecting = false;\n                selectee.selected = true;\n                selectee.startselected = true;\n                that._trigger(\"selected\", event, {\n                    selected: selectee.element\n                });\n            });\n            this._trigger(\"stop\", event);\n\n            this.helper.remove();\n\n            return false;\n        }\n\n    });\n\n});\n","jquery/ui-modules/effect-shake.js":"/*!\n * jQuery UI Effects Shake - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/shake-effect/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.shake = function (o, done) {\n\n        var el = $(this),\n            props = [\"position\", \"top\", \"bottom\", \"left\", \"right\", \"height\", \"width\"],\n            mode = $.effects.setMode(el, o.mode || \"effect\"),\n            direction = o.direction || \"left\",\n            distance = o.distance || 20,\n            times = o.times || 3,\n            anims = times * 2 + 1,\n            speed = Math.round(o.duration / anims),\n            ref = (direction === \"up\" || direction === \"down\") ? \"top\" : \"left\",\n            positiveMotion = (direction === \"up\" || direction === \"left\"),\n            animation = {},\n            animation1 = {},\n            animation2 = {},\n            i,\n\n            // we will need to re-assemble the queue to stack our animations in place\n            queue = el.queue(),\n            queuelen = queue.length;\n\n        $.effects.save(el, props);\n        el.show();\n        $.effects.createWrapper(el);\n\n        // Animation\n        animation[ref] = (positiveMotion ? \"-=\" : \"+=\") + distance;\n        animation1[ref] = (positiveMotion ? \"+=\" : \"-=\") + distance * 2;\n        animation2[ref] = (positiveMotion ? \"-=\" : \"+=\") + distance * 2;\n\n        // Animate\n        el.animate(animation, speed, o.easing);\n\n        // Shakes\n        for (i = 1; i < times; i++) {\n            el.animate(animation1, speed, o.easing).animate(animation2, speed, o.easing);\n        }\n        el\n            .animate(animation1, speed, o.easing)\n            .animate(animation, speed / 2, o.easing)\n            .queue(function () {\n                if (mode === \"hide\") {\n                    el.hide();\n                }\n                $.effects.restore(el, props);\n                $.effects.removeWrapper(el);\n                done();\n            });\n\n        // inject all the animations we just queued to be first in line (after \"inprogress\")\n        if (queuelen > 1) {\n            queue.splice.apply(queue,\n                [1, 0].concat(queue.splice(queuelen, anims + 1)));\n        }\n        el.dequeue();\n\n    };\n\n});\n","jquery/ui-modules/progressbar.js":"/*!\n * jQuery UI Progressbar - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/progressbar/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/widget'\n], function ($, undefined) {\n\n    $.widget(\"ui.progressbar\", {\n        version: \"1.10.4\",\n        options: {\n            max: 100,\n            value: 0,\n\n            change: null,\n            complete: null\n        },\n\n        min: 0,\n\n        _create: function () {\n            // Constrain initial value\n            this.oldValue = this.options.value = this._constrainedValue();\n\n            this.element\n                .addClass(\"ui-progressbar ui-widget ui-widget-content ui-corner-all\")\n                .attr({\n                    // Only set static values, aria-valuenow and aria-valuemax are\n                    // set inside _refreshValue()\n                    role: \"progressbar\",\n                    \"aria-valuemin\": this.min\n                });\n\n            this.valueDiv = $(\"<div class='ui-progressbar-value ui-widget-header ui-corner-left'></div>\")\n                .appendTo(this.element);\n\n            this._refreshValue();\n        },\n\n        _destroy: function () {\n            this.element\n                .removeClass(\"ui-progressbar ui-widget ui-widget-content ui-corner-all\")\n                .removeAttr(\"role\")\n                .removeAttr(\"aria-valuemin\")\n                .removeAttr(\"aria-valuemax\")\n                .removeAttr(\"aria-valuenow\");\n\n            this.valueDiv.remove();\n        },\n\n        value: function (newValue) {\n            if (newValue === undefined) {\n                return this.options.value;\n            }\n\n            this.options.value = this._constrainedValue(newValue);\n            this._refreshValue();\n        },\n\n        _constrainedValue: function (newValue) {\n            if (newValue === undefined) {\n                newValue = this.options.value;\n            }\n\n            this.indeterminate = newValue === false;\n\n            // sanitize value\n            if (typeof newValue !== \"number\") {\n                newValue = 0;\n            }\n\n            return this.indeterminate ? false :\n                Math.min(this.options.max, Math.max(this.min, newValue));\n        },\n\n        _setOptions: function (options) {\n            // Ensure \"value\" option is set after other values (like max)\n            var value = options.value;\n            delete options.value;\n\n            this._super(options);\n\n            this.options.value = this._constrainedValue(value);\n            this._refreshValue();\n        },\n\n        _setOption: function (key, value) {\n            if (key === \"max\") {\n                // Don't allow a max less than min\n                value = Math.max(this.min, value);\n            }\n\n            this._super(key, value);\n        },\n\n        _percentage: function () {\n            return this.indeterminate ? 100 : 100 * (this.options.value - this.min) / (this.options.max - this.min);\n        },\n\n        _refreshValue: function () {\n            var value = this.options.value,\n                percentage = this._percentage();\n\n            this.valueDiv\n                .toggle(this.indeterminate || value > this.min)\n                .toggleClass(\"ui-corner-right\", value === this.options.max)\n                .width(percentage.toFixed(0) + \"%\");\n\n            this.element.toggleClass(\"ui-progressbar-indeterminate\", this.indeterminate);\n\n            if (this.indeterminate) {\n                this.element.removeAttr(\"aria-valuenow\");\n                if (!this.overlayDiv) {\n                    this.overlayDiv = $(\"<div class='ui-progressbar-overlay'></div>\").appendTo(this.valueDiv);\n                }\n            } else {\n                this.element.attr({\n                    \"aria-valuemax\": this.options.max,\n                    \"aria-valuenow\": value\n                });\n                if (this.overlayDiv) {\n                    this.overlayDiv.remove();\n                    this.overlayDiv = null;\n                }\n            }\n\n            if (this.oldValue !== value) {\n                this.oldValue = value;\n                this._trigger(\"change\");\n            }\n            if (value === this.options.max) {\n                this._trigger(\"complete\");\n            }\n        }\n    });\n\n});\n","jquery/ui-modules/mouse.js":"/*!\n * jQuery UI Mouse - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/mouse/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($, undefined) {\n\n    var mouseHandled = false;\n    $(document).mouseup(function () {\n        mouseHandled = false;\n    });\n\n    $.widget(\"ui.mouse\", {\n        version: \"1.10.4\",\n        options: {\n            cancel: \"input,textarea,button,select,option\",\n            distance: 1,\n            delay: 0\n        },\n        _mouseInit: function () {\n            var that = this;\n\n            this.element\n                .bind(\"mousedown.\" + this.widgetName, function (event) {\n                    return that._mouseDown(event);\n                })\n                .bind(\"click.\" + this.widgetName, function (event) {\n                    if (true === $.data(event.target, that.widgetName + \".preventClickEvent\")) {\n                        $.removeData(event.target, that.widgetName + \".preventClickEvent\");\n                        event.stopImmediatePropagation();\n                        return false;\n                    }\n                });\n\n            this.started = false;\n        },\n\n        // TODO: make sure destroying one instance of mouse doesn't mess with\n        // other instances of mouse\n        _mouseDestroy: function () {\n            this.element.unbind(\".\" + this.widgetName);\n            if (this._mouseMoveDelegate) {\n                $(document)\n                    .unbind(\"mousemove.\" + this.widgetName, this._mouseMoveDelegate)\n                    .unbind(\"mouseup.\" + this.widgetName, this._mouseUpDelegate);\n            }\n        },\n\n        _mouseDown: function (event) {\n            // don't let more than one widget handle mouseStart\n            if (mouseHandled) {\n                return;\n            }\n\n            // we may have missed mouseup (out of window)\n            (this._mouseStarted && this._mouseUp(event));\n\n            this._mouseDownEvent = event;\n\n            var that = this,\n                btnIsLeft = (event.which === 1),\n                // event.target.nodeName works around a bug in IE 8 with\n                // disabled inputs (#7620)\n                elIsCancel = (typeof this.options.cancel === \"string\" && event.target.nodeName ? $(event.target).closest(this.options.cancel).length : false);\n            if (!btnIsLeft || elIsCancel || !this._mouseCapture(event)) {\n                return true;\n            }\n\n            this.mouseDelayMet = !this.options.delay;\n            if (!this.mouseDelayMet) {\n                this._mouseDelayTimer = setTimeout(function () {\n                    that.mouseDelayMet = true;\n                }, this.options.delay);\n            }\n\n            if (this._mouseDistanceMet(event) && this._mouseDelayMet(event)) {\n                this._mouseStarted = (this._mouseStart(event) !== false);\n                if (!this._mouseStarted) {\n                    event.preventDefault();\n                    return true;\n                }\n            }\n\n            // Click event may never have fired (Gecko & Opera)\n            if (true === $.data(event.target, this.widgetName + \".preventClickEvent\")) {\n                $.removeData(event.target, this.widgetName + \".preventClickEvent\");\n            }\n\n            // these delegates are required to keep context\n            this._mouseMoveDelegate = function (event) {\n                return that._mouseMove(event);\n            };\n            this._mouseUpDelegate = function (event) {\n                return that._mouseUp(event);\n            };\n            $(document)\n                .bind(\"mousemove.\" + this.widgetName, this._mouseMoveDelegate)\n                .bind(\"mouseup.\" + this.widgetName, this._mouseUpDelegate);\n\n            event.preventDefault();\n\n            mouseHandled = true;\n            return true;\n        },\n\n        _mouseMove: function (event) {\n            // IE mouseup check - mouseup happened when mouse was out of window\n            if ($.ui.ie && (!document.documentMode || document.documentMode < 9) && !event.button) {\n                return this._mouseUp(event);\n            }\n\n            if (this._mouseStarted) {\n                this._mouseDrag(event);\n                return event.preventDefault();\n            }\n\n            if (this._mouseDistanceMet(event) && this._mouseDelayMet(event)) {\n                this._mouseStarted =\n                    (this._mouseStart(this._mouseDownEvent, event) !== false);\n                (this._mouseStarted ? this._mouseDrag(event) : this._mouseUp(event));\n            }\n\n            return !this._mouseStarted;\n        },\n\n        _mouseUp: function (event) {\n            $(document)\n                .unbind(\"mousemove.\" + this.widgetName, this._mouseMoveDelegate)\n                .unbind(\"mouseup.\" + this.widgetName, this._mouseUpDelegate);\n\n            if (this._mouseStarted) {\n                this._mouseStarted = false;\n\n                if (event.target === this._mouseDownEvent.target) {\n                    $.data(event.target, this.widgetName + \".preventClickEvent\", true);\n                }\n\n                this._mouseStop(event);\n            }\n\n            return false;\n        },\n\n        _mouseDistanceMet: function (event) {\n            return (Math.max(\n                    Math.abs(this._mouseDownEvent.pageX - event.pageX),\n                    Math.abs(this._mouseDownEvent.pageY - event.pageY)\n                ) >= this.options.distance\n            );\n        },\n\n        _mouseDelayMet: function (/* event */) {\n            return this.mouseDelayMet;\n        },\n\n        // These are placeholder methods, to be overridden by extending plugin\n        _mouseStart: function (/* event */) {\n        },\n        _mouseDrag: function (/* event */) {\n        },\n        _mouseStop: function (/* event */) {\n        },\n        _mouseCapture: function (/* event */) {\n            return true;\n        }\n    });\n\n});\n","jquery/ui-modules/effect-drop.js":"/*!\n * jQuery UI Effects Drop - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/drop-effect/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.drop = function (o, done) {\n\n        var el = $(this),\n            props = [\"position\", \"top\", \"bottom\", \"left\", \"right\", \"opacity\", \"height\", \"width\"],\n            mode = $.effects.setMode(el, o.mode || \"hide\"),\n            show = mode === \"show\",\n            direction = o.direction || \"left\",\n            ref = (direction === \"up\" || direction === \"down\") ? \"top\" : \"left\",\n            motion = (direction === \"up\" || direction === \"left\") ? \"pos\" : \"neg\",\n            animation = {\n                opacity: show ? 1 : 0\n            },\n            distance;\n\n        // Adjust\n        $.effects.save(el, props);\n        el.show();\n        $.effects.createWrapper(el);\n\n        distance = o.distance || el[ref === \"top\" ? \"outerHeight\" : \"outerWidth\"](true) / 2;\n\n        if (show) {\n            el\n                .css(\"opacity\", 0)\n                .css(ref, motion === \"pos\" ? -distance : distance);\n        }\n\n        // Animation\n        animation[ref] = (show ?\n            (motion === \"pos\" ? \"+=\" : \"-=\") :\n            (motion === \"pos\" ? \"-=\" : \"+=\")) +\n            distance;\n\n        // Animate\n        el.animate(animation, {\n            queue: false,\n            duration: o.duration,\n            easing: o.easing,\n            complete: function () {\n                if (mode === \"hide\") {\n                    el.hide();\n                }\n                $.effects.restore(el, props);\n                $.effects.removeWrapper(el);\n                done();\n            }\n        });\n    };\n\n});\n","jquery/ui-modules/resizable.js":"/*!\n * jQuery UI Resizable - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/resizable/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/mouse'\n], function ($, undefined) {\n\n    function num(v) {\n        return parseInt(v, 10) || 0;\n    }\n\n    function isNumber(value) {\n        return !isNaN(parseInt(value, 10));\n    }\n\n    $.widget(\"ui.resizable\", $.ui.mouse, {\n        version: \"1.10.4\",\n        widgetEventPrefix: \"resize\",\n        options: {\n            alsoResize: false,\n            animate: false,\n            animateDuration: \"slow\",\n            animateEasing: \"swing\",\n            aspectRatio: false,\n            autoHide: false,\n            containment: false,\n            ghost: false,\n            grid: false,\n            handles: \"e,s,se\",\n            helper: false,\n            maxHeight: null,\n            maxWidth: null,\n            minHeight: 10,\n            minWidth: 10,\n            // See #7960\n            zIndex: 90,\n\n            // callbacks\n            resize: null,\n            start: null,\n            stop: null\n        },\n        _create: function () {\n\n            var n, i, handle, axis, hname,\n                that = this,\n                o = this.options;\n            this.element.addClass(\"ui-resizable\");\n\n            $.extend(this, {\n                _aspectRatio: !!(o.aspectRatio),\n                aspectRatio: o.aspectRatio,\n                originalElement: this.element,\n                _proportionallyResizeElements: [],\n                _helper: o.helper || o.ghost || o.animate ? o.helper || \"ui-resizable-helper\" : null\n            });\n\n            //Wrap the element if it cannot hold child nodes\n            if (this.element[0].nodeName.match(/canvas|textarea|input|select|button|img/i)) {\n\n                //Create a wrapper element and set the wrapper to the new current internal element\n                this.element.wrap(\n                    $(\"<div class='ui-wrapper' style='overflow: hidden;'></div>\").css({\n                        position: this.element.css(\"position\"),\n                        width: this.element.outerWidth(),\n                        height: this.element.outerHeight(),\n                        top: this.element.css(\"top\"),\n                        left: this.element.css(\"left\")\n                    })\n                );\n\n                //Overwrite the original this.element\n                this.element = this.element.parent().data(\n                    \"ui-resizable\", this.element.data(\"ui-resizable\")\n                );\n\n                this.elementIsWrapper = true;\n\n                //Move margins to the wrapper\n                this.element.css({\n                    marginLeft: this.originalElement.css(\"marginLeft\"),\n                    marginTop: this.originalElement.css(\"marginTop\"),\n                    marginRight: this.originalElement.css(\"marginRight\"),\n                    marginBottom: this.originalElement.css(\"marginBottom\")\n                });\n                this.originalElement.css({marginLeft: 0, marginTop: 0, marginRight: 0, marginBottom: 0});\n\n                //Prevent Safari textarea resize\n                this.originalResizeStyle = this.originalElement.css(\"resize\");\n                this.originalElement.css(\"resize\", \"none\");\n\n                //Push the actual element to our proportionallyResize internal array\n                this._proportionallyResizeElements.push(this.originalElement.css({\n                    position: \"static\",\n                    zoom: 1,\n                    display: \"block\"\n                }));\n\n                // avoid IE jump (hard set the margin)\n                this.originalElement.css({margin: this.originalElement.css(\"margin\")});\n\n                // fix handlers offset\n                this._proportionallyResize();\n\n            }\n\n            this.handles = o.handles || (!$(\".ui-resizable-handle\", this.element).length ? \"e,s,se\" : {\n                n: \".ui-resizable-n\",\n                e: \".ui-resizable-e\",\n                s: \".ui-resizable-s\",\n                w: \".ui-resizable-w\",\n                se: \".ui-resizable-se\",\n                sw: \".ui-resizable-sw\",\n                ne: \".ui-resizable-ne\",\n                nw: \".ui-resizable-nw\"\n            });\n            if (this.handles.constructor === String) {\n\n                if (this.handles === \"all\") {\n                    this.handles = \"n,e,s,w,se,sw,ne,nw\";\n                }\n\n                n = this.handles.split(\",\");\n                this.handles = {};\n\n                for (i = 0; i < n.length; i++) {\n\n                    handle = $.trim(n[i]);\n                    hname = \"ui-resizable-\" + handle;\n                    axis = $(\"<div class='ui-resizable-handle \" + hname + \"'></div>\");\n\n                    // Apply zIndex to all handles - see #7960\n                    axis.css({zIndex: o.zIndex});\n\n                    //TODO : What's going on here?\n                    if (\"se\" === handle) {\n                        axis.addClass(\"ui-icon ui-icon-gripsmall-diagonal-se\");\n                    }\n\n                    //Insert into internal handles object and append to element\n                    this.handles[handle] = \".ui-resizable-\" + handle;\n                    this.element.append(axis);\n                }\n\n            }\n\n            this._renderAxis = function (target) {\n\n                var i, axis, padPos, padWrapper;\n\n                target = target || this.element;\n\n                for (i in this.handles) {\n\n                    if (this.handles[i].constructor === String) {\n                        this.handles[i] = $(this.handles[i], this.element).show();\n                    }\n\n                    //Apply pad to wrapper element, needed to fix axis position (textarea, inputs, scrolls)\n                    if (this.elementIsWrapper && this.originalElement[0].nodeName.match(/textarea|input|select|button/i)) {\n\n                        axis = $(this.handles[i], this.element);\n\n                        //Checking the correct pad and border\n                        padWrapper = /sw|ne|nw|se|n|s/.test(i) ? axis.outerHeight() : axis.outerWidth();\n\n                        //The padding type i have to apply...\n                        padPos = [\"padding\",\n                            /ne|nw|n/.test(i) ? \"Top\" :\n                                /se|sw|s/.test(i) ? \"Bottom\" :\n                                    /^e$/.test(i) ? \"Right\" : \"Left\"].join(\"\");\n\n                        target.css(padPos, padWrapper);\n\n                        this._proportionallyResize();\n\n                    }\n\n                    //TODO: What's that good for? There's not anything to be executed left\n                    if (!$(this.handles[i]).length) {\n                        continue;\n                    }\n                }\n            };\n\n            //TODO: make renderAxis a prototype function\n            this._renderAxis(this.element);\n\n            this._handles = $(\".ui-resizable-handle\", this.element)\n                .disableSelection();\n\n            //Matching axis name\n            this._handles.mouseover(function () {\n                if (!that.resizing) {\n                    if (this.className) {\n                        axis = this.className.match(/ui-resizable-(se|sw|ne|nw|n|e|s|w)/i);\n                    }\n                    //Axis, default = se\n                    that.axis = axis && axis[1] ? axis[1] : \"se\";\n                }\n            });\n\n            //If we want to auto hide the elements\n            if (o.autoHide) {\n                this._handles.hide();\n                $(this.element)\n                    .addClass(\"ui-resizable-autohide\")\n                    .mouseenter(function () {\n                        if (o.disabled) {\n                            return;\n                        }\n                        $(this).removeClass(\"ui-resizable-autohide\");\n                        that._handles.show();\n                    })\n                    .mouseleave(function () {\n                        if (o.disabled) {\n                            return;\n                        }\n                        if (!that.resizing) {\n                            $(this).addClass(\"ui-resizable-autohide\");\n                            that._handles.hide();\n                        }\n                    });\n            }\n\n            //Initialize the mouse interaction\n            this._mouseInit();\n\n        },\n\n        _destroy: function () {\n\n            this._mouseDestroy();\n\n            var wrapper,\n                _destroy = function (exp) {\n                    $(exp).removeClass(\"ui-resizable ui-resizable-disabled ui-resizable-resizing\")\n                        .removeData(\"resizable\").removeData(\"ui-resizable\").unbind(\".resizable\").find(\".ui-resizable-handle\").remove();\n                };\n\n            //TODO: Unwrap at same DOM position\n            if (this.elementIsWrapper) {\n                _destroy(this.element);\n                wrapper = this.element;\n                this.originalElement.css({\n                    position: wrapper.css(\"position\"),\n                    width: wrapper.outerWidth(),\n                    height: wrapper.outerHeight(),\n                    top: wrapper.css(\"top\"),\n                    left: wrapper.css(\"left\")\n                }).insertAfter(wrapper);\n                wrapper.remove();\n            }\n\n            this.originalElement.css(\"resize\", this.originalResizeStyle);\n            _destroy(this.originalElement);\n\n            return this;\n        },\n\n        _mouseCapture: function (event) {\n            var i, handle,\n                capture = false;\n\n            for (i in this.handles) {\n                handle = $(this.handles[i])[0];\n                if (handle === event.target || $.contains(handle, event.target)) {\n                    capture = true;\n                }\n            }\n\n            return !this.options.disabled && capture;\n        },\n\n        _mouseStart: function (event) {\n\n            var curleft, curtop, cursor,\n                o = this.options,\n                iniPos = this.element.position(),\n                el = this.element;\n\n            this.resizing = true;\n\n            // bugfix for http://dev.jquery.com/ticket/1749\n            if ((/absolute/).test(el.css(\"position\"))) {\n                el.css({position: \"absolute\", top: el.css(\"top\"), left: el.css(\"left\")});\n            } else if (el.is(\".ui-draggable\")) {\n                el.css({position: \"absolute\", top: iniPos.top, left: iniPos.left});\n            }\n\n            this._renderProxy();\n\n            curleft = num(this.helper.css(\"left\"));\n            curtop = num(this.helper.css(\"top\"));\n\n            if (o.containment) {\n                curleft += $(o.containment).scrollLeft() || 0;\n                curtop += $(o.containment).scrollTop() || 0;\n            }\n\n            //Store needed variables\n            this.offset = this.helper.offset();\n            this.position = {left: curleft, top: curtop};\n            this.size = this._helper ? {width: this.helper.width(), height: this.helper.height()} : {\n                width: el.width(),\n                height: el.height()\n            };\n            this.originalSize = this._helper ? {width: el.outerWidth(), height: el.outerHeight()} : {\n                width: el.width(),\n                height: el.height()\n            };\n            this.originalPosition = {left: curleft, top: curtop};\n            this.sizeDiff = {width: el.outerWidth() - el.width(), height: el.outerHeight() - el.height()};\n            this.originalMousePosition = {left: event.pageX, top: event.pageY};\n\n            //Aspect Ratio\n            this.aspectRatio = (typeof o.aspectRatio === \"number\") ? o.aspectRatio : ((this.originalSize.width / this.originalSize.height) || 1);\n\n            cursor = $(\".ui-resizable-\" + this.axis).css(\"cursor\");\n            $(\"body\").css(\"cursor\", cursor === \"auto\" ? this.axis + \"-resize\" : cursor);\n\n            el.addClass(\"ui-resizable-resizing\");\n            this._propagate(\"start\", event);\n            return true;\n        },\n\n        _mouseDrag: function (event) {\n\n            //Increase performance, avoid regex\n            var data,\n                el = this.helper, props = {},\n                smp = this.originalMousePosition,\n                a = this.axis,\n                prevTop = this.position.top,\n                prevLeft = this.position.left,\n                prevWidth = this.size.width,\n                prevHeight = this.size.height,\n                dx = (event.pageX - smp.left) || 0,\n                dy = (event.pageY - smp.top) || 0,\n                trigger = this._change[a];\n\n            if (!trigger) {\n                return false;\n            }\n\n            // Calculate the attrs that will be change\n            data = trigger.apply(this, [event, dx, dy]);\n\n            // Put this in the mouseDrag handler since the user can start pressing shift while resizing\n            this._updateVirtualBoundaries(event.shiftKey);\n            if (this._aspectRatio || event.shiftKey) {\n                data = this._updateRatio(data, event);\n            }\n\n            data = this._respectSize(data, event);\n\n            this._updateCache(data);\n\n            // plugins callbacks need to be called first\n            this._propagate(\"resize\", event);\n\n            if (this.position.top !== prevTop) {\n                props.top = this.position.top + \"px\";\n            }\n            if (this.position.left !== prevLeft) {\n                props.left = this.position.left + \"px\";\n            }\n            if (this.size.width !== prevWidth) {\n                props.width = this.size.width + \"px\";\n            }\n            if (this.size.height !== prevHeight) {\n                props.height = this.size.height + \"px\";\n            }\n            el.css(props);\n\n            if (!this._helper && this._proportionallyResizeElements.length) {\n                this._proportionallyResize();\n            }\n\n            // Call the user callback if the element was resized\n            if (!$.isEmptyObject(props)) {\n                this._trigger(\"resize\", event, this.ui());\n            }\n\n            return false;\n        },\n\n        _mouseStop: function (event) {\n\n            this.resizing = false;\n            var pr, ista, soffseth, soffsetw, s, left, top,\n                o = this.options, that = this;\n\n            if (this._helper) {\n\n                pr = this._proportionallyResizeElements;\n                ista = pr.length && (/textarea/i).test(pr[0].nodeName);\n                soffseth = ista && $.ui.hasScroll(pr[0], \"left\") /* TODO - jump height */ ? 0 : that.sizeDiff.height;\n                soffsetw = ista ? 0 : that.sizeDiff.width;\n\n                s = {width: (that.helper.width() - soffsetw), height: (that.helper.height() - soffseth)};\n                left = (parseInt(that.element.css(\"left\"), 10) + (that.position.left - that.originalPosition.left)) || null;\n                top = (parseInt(that.element.css(\"top\"), 10) + (that.position.top - that.originalPosition.top)) || null;\n\n                if (!o.animate) {\n                    this.element.css($.extend(s, {top: top, left: left}));\n                }\n\n                that.helper.height(that.size.height);\n                that.helper.width(that.size.width);\n\n                if (this._helper && !o.animate) {\n                    this._proportionallyResize();\n                }\n            }\n\n            $(\"body\").css(\"cursor\", \"auto\");\n\n            this.element.removeClass(\"ui-resizable-resizing\");\n\n            this._propagate(\"stop\", event);\n\n            if (this._helper) {\n                this.helper.remove();\n            }\n\n            return false;\n\n        },\n\n        _updateVirtualBoundaries: function (forceAspectRatio) {\n            var pMinWidth, pMaxWidth, pMinHeight, pMaxHeight, b,\n                o = this.options;\n\n            b = {\n                minWidth: isNumber(o.minWidth) ? o.minWidth : 0,\n                maxWidth: isNumber(o.maxWidth) ? o.maxWidth : Infinity,\n                minHeight: isNumber(o.minHeight) ? o.minHeight : 0,\n                maxHeight: isNumber(o.maxHeight) ? o.maxHeight : Infinity\n            };\n\n            if (this._aspectRatio || forceAspectRatio) {\n                // We want to create an enclosing box whose aspect ration is the requested one\n                // First, compute the \"projected\" size for each dimension based on the aspect ratio and other dimension\n                pMinWidth = b.minHeight * this.aspectRatio;\n                pMinHeight = b.minWidth / this.aspectRatio;\n                pMaxWidth = b.maxHeight * this.aspectRatio;\n                pMaxHeight = b.maxWidth / this.aspectRatio;\n\n                if (pMinWidth > b.minWidth) {\n                    b.minWidth = pMinWidth;\n                }\n                if (pMinHeight > b.minHeight) {\n                    b.minHeight = pMinHeight;\n                }\n                if (pMaxWidth < b.maxWidth) {\n                    b.maxWidth = pMaxWidth;\n                }\n                if (pMaxHeight < b.maxHeight) {\n                    b.maxHeight = pMaxHeight;\n                }\n            }\n            this._vBoundaries = b;\n        },\n\n        _updateCache: function (data) {\n            this.offset = this.helper.offset();\n            if (isNumber(data.left)) {\n                this.position.left = data.left;\n            }\n            if (isNumber(data.top)) {\n                this.position.top = data.top;\n            }\n            if (isNumber(data.height)) {\n                this.size.height = data.height;\n            }\n            if (isNumber(data.width)) {\n                this.size.width = data.width;\n            }\n        },\n\n        _updateRatio: function (data) {\n\n            var cpos = this.position,\n                csize = this.size,\n                a = this.axis;\n\n            if (isNumber(data.height)) {\n                data.width = (data.height * this.aspectRatio);\n            } else if (isNumber(data.width)) {\n                data.height = (data.width / this.aspectRatio);\n            }\n\n            if (a === \"sw\") {\n                data.left = cpos.left + (csize.width - data.width);\n                data.top = null;\n            }\n            if (a === \"nw\") {\n                data.top = cpos.top + (csize.height - data.height);\n                data.left = cpos.left + (csize.width - data.width);\n            }\n\n            return data;\n        },\n\n        _respectSize: function (data) {\n\n            var o = this._vBoundaries,\n                a = this.axis,\n                ismaxw = isNumber(data.width) && o.maxWidth && (o.maxWidth < data.width),\n                ismaxh = isNumber(data.height) && o.maxHeight && (o.maxHeight < data.height),\n                isminw = isNumber(data.width) && o.minWidth && (o.minWidth > data.width),\n                isminh = isNumber(data.height) && o.minHeight && (o.minHeight > data.height),\n                dw = this.originalPosition.left + this.originalSize.width,\n                dh = this.position.top + this.size.height,\n                cw = /sw|nw|w/.test(a), ch = /nw|ne|n/.test(a);\n            if (isminw) {\n                data.width = o.minWidth;\n            }\n            if (isminh) {\n                data.height = o.minHeight;\n            }\n            if (ismaxw) {\n                data.width = o.maxWidth;\n            }\n            if (ismaxh) {\n                data.height = o.maxHeight;\n            }\n\n            if (isminw && cw) {\n                data.left = dw - o.minWidth;\n            }\n            if (ismaxw && cw) {\n                data.left = dw - o.maxWidth;\n            }\n            if (isminh && ch) {\n                data.top = dh - o.minHeight;\n            }\n            if (ismaxh && ch) {\n                data.top = dh - o.maxHeight;\n            }\n\n            // fixing jump error on top/left - bug #2330\n            if (!data.width && !data.height && !data.left && data.top) {\n                data.top = null;\n            } else if (!data.width && !data.height && !data.top && data.left) {\n                data.left = null;\n            }\n\n            return data;\n        },\n\n        _proportionallyResize: function () {\n\n            if (!this._proportionallyResizeElements.length) {\n                return;\n            }\n\n            var i, j, borders, paddings, prel,\n                element = this.helper || this.element;\n\n            for (i = 0; i < this._proportionallyResizeElements.length; i++) {\n\n                prel = this._proportionallyResizeElements[i];\n\n                if (!this.borderDif) {\n                    this.borderDif = [];\n                    borders = [prel.css(\"borderTopWidth\"), prel.css(\"borderRightWidth\"), prel.css(\"borderBottomWidth\"), prel.css(\"borderLeftWidth\")];\n                    paddings = [prel.css(\"paddingTop\"), prel.css(\"paddingRight\"), prel.css(\"paddingBottom\"), prel.css(\"paddingLeft\")];\n\n                    for (j = 0; j < borders.length; j++) {\n                        this.borderDif[j] = (parseInt(borders[j], 10) || 0) + (parseInt(paddings[j], 10) || 0);\n                    }\n                }\n\n                prel.css({\n                    height: (element.height() - this.borderDif[0] - this.borderDif[2]) || 0,\n                    width: (element.width() - this.borderDif[1] - this.borderDif[3]) || 0\n                });\n\n            }\n\n        },\n\n        _renderProxy: function () {\n\n            var el = this.element, o = this.options;\n            this.elementOffset = el.offset();\n\n            if (this._helper) {\n\n                this.helper = this.helper || $(\"<div style='overflow:hidden;'></div>\");\n\n                this.helper.addClass(this._helper).css({\n                    width: this.element.outerWidth() - 1,\n                    height: this.element.outerHeight() - 1,\n                    position: \"absolute\",\n                    left: this.elementOffset.left + \"px\",\n                    top: this.elementOffset.top + \"px\",\n                    zIndex: ++o.zIndex //TODO: Don't modify option\n                });\n\n                this.helper\n                    .appendTo(\"body\")\n                    .disableSelection();\n\n            } else {\n                this.helper = this.element;\n            }\n\n        },\n\n        _change: {\n            e: function (event, dx) {\n                return {width: this.originalSize.width + dx};\n            },\n            w: function (event, dx) {\n                var cs = this.originalSize, sp = this.originalPosition;\n                return {left: sp.left + dx, width: cs.width - dx};\n            },\n            n: function (event, dx, dy) {\n                var cs = this.originalSize, sp = this.originalPosition;\n                return {top: sp.top + dy, height: cs.height - dy};\n            },\n            s: function (event, dx, dy) {\n                return {height: this.originalSize.height + dy};\n            },\n            se: function (event, dx, dy) {\n                return $.extend(this._change.s.apply(this, arguments), this._change.e.apply(this, [event, dx, dy]));\n            },\n            sw: function (event, dx, dy) {\n                return $.extend(this._change.s.apply(this, arguments), this._change.w.apply(this, [event, dx, dy]));\n            },\n            ne: function (event, dx, dy) {\n                return $.extend(this._change.n.apply(this, arguments), this._change.e.apply(this, [event, dx, dy]));\n            },\n            nw: function (event, dx, dy) {\n                return $.extend(this._change.n.apply(this, arguments), this._change.w.apply(this, [event, dx, dy]));\n            }\n        },\n\n        _propagate: function (n, event) {\n            $.ui.plugin.call(this, n, [event, this.ui()]);\n            (n !== \"resize\" && this._trigger(n, event, this.ui()));\n        },\n\n        plugins: {},\n\n        ui: function () {\n            return {\n                originalElement: this.originalElement,\n                element: this.element,\n                helper: this.helper,\n                position: this.position,\n                size: this.size,\n                originalSize: this.originalSize,\n                originalPosition: this.originalPosition\n            };\n        }\n\n    });\n\n    /*\n     * Resizable Extensions\n     */\n\n    $.ui.plugin.add(\"resizable\", \"animate\", {\n\n        stop: function (event) {\n            var that = $(this).data(\"ui-resizable\"),\n                o = that.options,\n                pr = that._proportionallyResizeElements,\n                ista = pr.length && (/textarea/i).test(pr[0].nodeName),\n                soffseth = ista && $.ui.hasScroll(pr[0], \"left\") /* TODO - jump height */ ? 0 : that.sizeDiff.height,\n                soffsetw = ista ? 0 : that.sizeDiff.width,\n                style = {width: (that.size.width - soffsetw), height: (that.size.height - soffseth)},\n                left = (parseInt(that.element.css(\"left\"), 10) + (that.position.left - that.originalPosition.left)) || null,\n                top = (parseInt(that.element.css(\"top\"), 10) + (that.position.top - that.originalPosition.top)) || null;\n\n            that.element.animate(\n                $.extend(style, top && left ? {top: top, left: left} : {}), {\n                    duration: o.animateDuration,\n                    easing: o.animateEasing,\n                    step: function () {\n\n                        var data = {\n                            width: parseInt(that.element.css(\"width\"), 10),\n                            height: parseInt(that.element.css(\"height\"), 10),\n                            top: parseInt(that.element.css(\"top\"), 10),\n                            left: parseInt(that.element.css(\"left\"), 10)\n                        };\n\n                        if (pr && pr.length) {\n                            $(pr[0]).css({width: data.width, height: data.height});\n                        }\n\n                        // propagating resize, and updating values for each animation step\n                        that._updateCache(data);\n                        that._propagate(\"resize\", event);\n\n                    }\n                }\n            );\n        }\n\n    });\n\n    $.ui.plugin.add(\"resizable\", \"containment\", {\n\n        start: function () {\n            var element, p, co, ch, cw, width, height,\n                that = $(this).data(\"ui-resizable\"),\n                o = that.options,\n                el = that.element,\n                oc = o.containment,\n                ce = (oc instanceof $) ? oc.get(0) : (/parent/.test(oc)) ? el.parent().get(0) : oc;\n\n            if (!ce) {\n                return;\n            }\n\n            that.containerElement = $(ce);\n\n            if (/document/.test(oc) || oc === document) {\n                that.containerOffset = {left: 0, top: 0};\n                that.containerPosition = {left: 0, top: 0};\n\n                that.parentData = {\n                    element: $(document), left: 0, top: 0,\n                    width: $(document).width(), height: $(document).height() || document.body.parentNode.scrollHeight\n                };\n            }\n\n            // i'm a node, so compute top, left, right, bottom\n            else {\n                element = $(ce);\n                p = [];\n                $([\"Top\", \"Right\", \"Left\", \"Bottom\"]).each(function (i, name) {\n                    p[i] = num(element.css(\"padding\" + name));\n                });\n\n                that.containerOffset = element.offset();\n                that.containerPosition = element.position();\n                that.containerSize = {height: (element.innerHeight() - p[3]), width: (element.innerWidth() - p[1])};\n\n                co = that.containerOffset;\n                ch = that.containerSize.height;\n                cw = that.containerSize.width;\n                width = ($.ui.hasScroll(ce, \"left\") ? ce.scrollWidth : cw);\n                height = ($.ui.hasScroll(ce) ? ce.scrollHeight : ch);\n\n                that.parentData = {\n                    element: ce, left: co.left, top: co.top, width: width, height: height\n                };\n            }\n        },\n\n        resize: function (event) {\n            var woset, hoset, isParent, isOffsetRelative,\n                that = $(this).data(\"ui-resizable\"),\n                o = that.options,\n                co = that.containerOffset, cp = that.position,\n                pRatio = that._aspectRatio || event.shiftKey,\n                cop = {top: 0, left: 0}, ce = that.containerElement;\n\n            if (ce[0] !== document && (/static/).test(ce.css(\"position\"))) {\n                cop = co;\n            }\n\n            if (cp.left < (that._helper ? co.left : 0)) {\n                that.size.width = that.size.width + (that._helper ? (that.position.left - co.left) : (that.position.left - cop.left));\n                if (pRatio) {\n                    that.size.height = that.size.width / that.aspectRatio;\n                }\n                that.position.left = o.helper ? co.left : 0;\n            }\n\n            if (cp.top < (that._helper ? co.top : 0)) {\n                that.size.height = that.size.height + (that._helper ? (that.position.top - co.top) : that.position.top);\n                if (pRatio) {\n                    that.size.width = that.size.height * that.aspectRatio;\n                }\n                that.position.top = that._helper ? co.top : 0;\n            }\n\n            that.offset.left = that.parentData.left + that.position.left;\n            that.offset.top = that.parentData.top + that.position.top;\n\n            woset = Math.abs((that._helper ? that.offset.left - cop.left : (that.offset.left - cop.left)) + that.sizeDiff.width);\n            hoset = Math.abs((that._helper ? that.offset.top - cop.top : (that.offset.top - co.top)) + that.sizeDiff.height);\n\n            isParent = that.containerElement.get(0) === that.element.parent().get(0);\n            isOffsetRelative = /relative|absolute/.test(that.containerElement.css(\"position\"));\n\n            if (isParent && isOffsetRelative) {\n                woset -= Math.abs(that.parentData.left);\n            }\n\n            if (woset + that.size.width >= that.parentData.width) {\n                that.size.width = that.parentData.width - woset;\n                if (pRatio) {\n                    that.size.height = that.size.width / that.aspectRatio;\n                }\n            }\n\n            if (hoset + that.size.height >= that.parentData.height) {\n                that.size.height = that.parentData.height - hoset;\n                if (pRatio) {\n                    that.size.width = that.size.height * that.aspectRatio;\n                }\n            }\n        },\n\n        stop: function () {\n            var that = $(this).data(\"ui-resizable\"),\n                o = that.options,\n                co = that.containerOffset,\n                cop = that.containerPosition,\n                ce = that.containerElement,\n                helper = $(that.helper),\n                ho = helper.offset(),\n                w = helper.outerWidth() - that.sizeDiff.width,\n                h = helper.outerHeight() - that.sizeDiff.height;\n\n            if (that._helper && !o.animate && (/relative/).test(ce.css(\"position\"))) {\n                $(this).css({left: ho.left - cop.left - co.left, width: w, height: h});\n            }\n\n            if (that._helper && !o.animate && (/static/).test(ce.css(\"position\"))) {\n                $(this).css({left: ho.left - cop.left - co.left, width: w, height: h});\n            }\n\n        }\n    });\n\n    $.ui.plugin.add(\"resizable\", \"alsoResize\", {\n\n        start: function () {\n            var that = $(this).data(\"ui-resizable\"),\n                o = that.options,\n                _store = function (exp) {\n                    $(exp).each(function () {\n                        var el = $(this);\n                        el.data(\"ui-resizable-alsoresize\", {\n                            width: parseInt(el.width(), 10), height: parseInt(el.height(), 10),\n                            left: parseInt(el.css(\"left\"), 10), top: parseInt(el.css(\"top\"), 10)\n                        });\n                    });\n                };\n\n            if (typeof (o.alsoResize) === \"object\" && !o.alsoResize.parentNode) {\n                if (o.alsoResize.length) {\n                    o.alsoResize = o.alsoResize[0];\n                    _store(o.alsoResize);\n                } else {\n                    $.each(o.alsoResize, function (exp) {\n                        _store(exp);\n                    });\n                }\n            } else {\n                _store(o.alsoResize);\n            }\n        },\n\n        resize: function (event, ui) {\n            var that = $(this).data(\"ui-resizable\"),\n                o = that.options,\n                os = that.originalSize,\n                op = that.originalPosition,\n                delta = {\n                    height: (that.size.height - os.height) || 0, width: (that.size.width - os.width) || 0,\n                    top: (that.position.top - op.top) || 0, left: (that.position.left - op.left) || 0\n                },\n\n                _alsoResize = function (exp, c) {\n                    $(exp).each(function () {\n                        var el = $(this), start = $(this).data(\"ui-resizable-alsoresize\"), style = {},\n                            css = c && c.length ? c : el.parents(ui.originalElement[0]).length ? [\"width\", \"height\"] : [\"width\", \"height\", \"top\", \"left\"];\n\n                        $.each(css, function (i, prop) {\n                            var sum = (start[prop] || 0) + (delta[prop] || 0);\n                            if (sum && sum >= 0) {\n                                style[prop] = sum || null;\n                            }\n                        });\n\n                        el.css(style);\n                    });\n                };\n\n            if (typeof (o.alsoResize) === \"object\" && !o.alsoResize.nodeType) {\n                $.each(o.alsoResize, function (exp, c) {\n                    _alsoResize(exp, c);\n                });\n            } else {\n                _alsoResize(o.alsoResize);\n            }\n        },\n\n        stop: function () {\n            $(this).removeData(\"resizable-alsoresize\");\n        }\n    });\n\n    $.ui.plugin.add(\"resizable\", \"ghost\", {\n\n        start: function () {\n\n            var that = $(this).data(\"ui-resizable\"), o = that.options, cs = that.size;\n\n            that.ghost = that.originalElement.clone();\n            that.ghost\n                .css({\n                    opacity: 0.25,\n                    display: \"block\",\n                    position: \"relative\",\n                    height: cs.height,\n                    width: cs.width,\n                    margin: 0,\n                    left: 0,\n                    top: 0\n                })\n                .addClass(\"ui-resizable-ghost\")\n                .addClass(typeof o.ghost === \"string\" ? o.ghost : \"\");\n\n            that.ghost.appendTo(that.helper);\n\n        },\n\n        resize: function () {\n            var that = $(this).data(\"ui-resizable\");\n            if (that.ghost) {\n                that.ghost.css({position: \"relative\", height: that.size.height, width: that.size.width});\n            }\n        },\n\n        stop: function () {\n            var that = $(this).data(\"ui-resizable\");\n            if (that.ghost && that.helper) {\n                that.helper.get(0).removeChild(that.ghost.get(0));\n            }\n        }\n\n    });\n\n    $.ui.plugin.add(\"resizable\", \"grid\", {\n\n        resize: function () {\n            var that = $(this).data(\"ui-resizable\"),\n                o = that.options,\n                cs = that.size,\n                os = that.originalSize,\n                op = that.originalPosition,\n                a = that.axis,\n                grid = typeof o.grid === \"number\" ? [o.grid, o.grid] : o.grid,\n                gridX = (grid[0] || 1),\n                gridY = (grid[1] || 1),\n                ox = Math.round((cs.width - os.width) / gridX) * gridX,\n                oy = Math.round((cs.height - os.height) / gridY) * gridY,\n                newWidth = os.width + ox,\n                newHeight = os.height + oy,\n                isMaxWidth = o.maxWidth && (o.maxWidth < newWidth),\n                isMaxHeight = o.maxHeight && (o.maxHeight < newHeight),\n                isMinWidth = o.minWidth && (o.minWidth > newWidth),\n                isMinHeight = o.minHeight && (o.minHeight > newHeight);\n\n            o.grid = grid;\n\n            if (isMinWidth) {\n                newWidth = newWidth + gridX;\n            }\n            if (isMinHeight) {\n                newHeight = newHeight + gridY;\n            }\n            if (isMaxWidth) {\n                newWidth = newWidth - gridX;\n            }\n            if (isMaxHeight) {\n                newHeight = newHeight - gridY;\n            }\n\n            if (/^(se|s|e)$/.test(a)) {\n                that.size.width = newWidth;\n                that.size.height = newHeight;\n            } else if (/^(ne)$/.test(a)) {\n                that.size.width = newWidth;\n                that.size.height = newHeight;\n                that.position.top = op.top - oy;\n            } else if (/^(sw)$/.test(a)) {\n                that.size.width = newWidth;\n                that.size.height = newHeight;\n                that.position.left = op.left - ox;\n            } else {\n                if (newHeight - gridY > 0) {\n                    that.size.height = newHeight;\n                    that.position.top = op.top - oy;\n                } else {\n                    that.size.height = gridY;\n                    that.position.top = op.top + os.height - gridY;\n                }\n                if (newWidth - gridX > 0) {\n                    that.size.width = newWidth;\n                    that.position.left = op.left - ox;\n                } else {\n                    that.size.width = gridX;\n                    that.position.left = op.left + os.width - gridX;\n                }\n            }\n        }\n\n    });\n\n});\n","jquery/ui-modules/effect-slide.js":"/*!\n * jQuery UI Effects Slide - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/slide-effect/\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/effect'\n], function ($, undefined) {\n\n    $.effects.effect.slide = function (o, done) {\n\n        // Create element\n        var el = $(this),\n            props = [\"position\", \"top\", \"bottom\", \"left\", \"right\", \"width\", \"height\"],\n            mode = $.effects.setMode(el, o.mode || \"show\"),\n            show = mode === \"show\",\n            direction = o.direction || \"left\",\n            ref = (direction === \"up\" || direction === \"down\") ? \"top\" : \"left\",\n            positiveMotion = (direction === \"up\" || direction === \"left\"),\n            distance,\n            animation = {};\n\n        // Adjust\n        $.effects.save(el, props);\n        el.show();\n        distance = o.distance || el[ref === \"top\" ? \"outerHeight\" : \"outerWidth\"](true);\n\n        $.effects.createWrapper(el).css({\n            overflow: \"hidden\"\n        });\n\n        if (show) {\n            el.css(ref, positiveMotion ? (isNaN(distance) ? \"-\" + distance : -distance) : distance);\n        }\n\n        // Animation\n        animation[ref] = (show ?\n            (positiveMotion ? \"+=\" : \"-=\") :\n            (positiveMotion ? \"-=\" : \"+=\")) +\n            distance;\n\n        // Animate\n        el.animate(animation, {\n            queue: false,\n            duration: o.duration,\n            easing: o.easing,\n            complete: function () {\n                if (mode === \"hide\") {\n                    el.hide();\n                }\n                $.effects.restore(el, props);\n                $.effects.removeWrapper(el);\n                done();\n            }\n        });\n    };\n\n});\n","Magento_PaypalCaptcha/js/view/payment/list-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Captcha/js/model/captchaList'\n], function ($, captchaList) {\n    'use strict';\n\n    var mixin = {\n\n        formId: 'co-payment-form',\n\n        /**\n         * Sets custom template for Payflow Pro\n         *\n         * @param {Object} payment\n         * @returns {Object}\n         */\n        createComponent: function (payment) {\n\n            var component = this._super(payment);\n\n            if (component.component === 'Magento_Paypal/js/view/payment/method-renderer/payflowpro-method') {\n                component.template = 'Magento_PaypalCaptcha/payment/payflowpro-form';\n                $(window).off('clearTimeout')\n                    .on('clearTimeout', this.clearTimeout.bind(this));\n            }\n\n            return component;\n        },\n\n        /**\n         * Overrides default window.clearTimeout() to catch errors from iframe and reload Captcha.\n         */\n        clearTimeout: function () {\n            var captcha = captchaList.getCaptchaByFormId(this.formId);\n\n            if (captcha !== null) {\n                captcha.refresh();\n            }\n            clearTimeout();\n        }\n    };\n\n    /**\n     * Overrides `Magento_Checkout/js/view/payment/list::createComponent`\n     */\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n","Magento_PaypalCaptcha/js/view/checkout/paymentCaptcha.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Captcha/js/view/checkout/defaultCaptcha',\n    'Magento_Captcha/js/model/captchaList',\n    'Magento_Captcha/js/model/captcha'\n],\nfunction ($, defaultCaptcha, captchaList, Captcha) {\n    'use strict';\n\n    return defaultCaptcha.extend({\n\n        /** @inheritdoc */\n        initialize: function () {\n            var captchaConfigPayment,\n                currentCaptcha;\n\n            this._super();\n\n            if (window[this.configSource] && window[this.configSource].captchaPayments) {\n                captchaConfigPayment = window[this.configSource].captchaPayments;\n\n                $.each(captchaConfigPayment, function (formId, captchaData) {\n                    var captcha;\n\n                    captchaData.formId = formId;\n                    captcha = Captcha(captchaData);\n                    captchaList.add(captcha);\n                });\n            }\n\n            currentCaptcha = captchaList.getCaptchaByFormId(this.formId);\n\n            if (currentCaptcha != null) {\n                currentCaptcha.setIsVisible(true);\n                this.setCurrentCaptcha(currentCaptcha);\n            }\n        }\n    });\n});\n","js/navigation-menu.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * @deprecated\n * @see lib/web/mage/menu.js\n */\ndefine([\n    'jquery',\n    'matchMedia',\n    'mage/template',\n    'mage/dropdowns',\n    'mage/terms'\n], function ($, mediaCheck, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.navigationMenu', {\n        options: {\n            itemsContainer: '> ul',\n            topLevel: 'li.level0',\n            topLevelSubmenu: '> .submenu',\n            topLevelHoverClass: 'hover',\n            expandedTopLevel: '.more',\n            hoverInTimeout: 300,\n            hoverOutTimeout: 500,\n            submenuAnimationSpeed: 200,\n            collapsable: true,\n            collapsableDropdownTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<li class=\"level0 level-top more parent\">' +\n                        '<div class=\"submenu\">' +\n                            '<ul><%= elems %></ul>' +\n                        '</div>' +\n                    '</li>' +\n                '</script>'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.itemsContainer = $(this.options.itemsContainer, this.element);\n            this.topLevel = $(this.options.topLevel, this.element);\n            this.topLevelSubmenu = $(this.options.topLevelSubmenu, this.topLevel);\n\n            this._bind();\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            if (this.options.collapsable) {\n                setTimeout($.proxy(function () {\n                    this._checkToCollapseOrExpand();\n                }, this), 100);\n            }\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            this._on({\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                'mouseenter > ul > li.level0': function (e) {\n                    if (!this.entered) { // fix IE bug with 'mouseenter' event\n                        this.timeoutId && clearTimeout(this.timeoutId);\n                        this.timeoutId = setTimeout($.proxy(function () {\n                            this._openSubmenu(e);\n                        }, this), this.options.hoverInTimeout);\n                        this.entered = true;\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                'mouseleave > ul > li.level0': function (e) {\n                    this.entered = null;\n\n                    this.timeoutId && clearTimeout(this.timeoutId);\n                    this.timeoutId = setTimeout($.proxy(function () {\n                        this._closeSubmenu(e.currentTarget);\n                    }, this), this.options.hoverOutTimeout);\n                },\n\n                /**\n                 * @param {jQuert.Event} e\n                 */\n                'click': function (e) {\n                    e.stopPropagation();\n                }\n            });\n\n            $(document)\n                .on('click.hideMenu', $.proxy(function () {\n                    var isOpened = this.topLevel.filter(function () {\n                        return $(this).data('opened');\n                    });\n\n                    if (isOpened) {\n                        this._closeSubmenu(null, false);\n                    }\n                }, this));\n\n            $(window)\n                .on('resize', $.proxy(function () {\n                    this.timeoutOnResize && clearTimeout(this.timeoutOnResize);\n                    this.timeoutOnResize = setTimeout($.proxy(function () {\n                        if (this.options.collapsable) {\n                            if ($(this.options.expandedTopLevel, this.element).length) {\n                                this._expandMenu();\n                            }\n                            this._checkToCollapseOrExpand();\n                        }\n                    }, this), 300);\n                }, this));\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _openSubmenu: function (e) {\n            var menuItem = e.currentTarget;\n\n            if (!$(menuItem).data('opened')) {\n                this._closeSubmenu(menuItem, true, true);\n\n                $(this.options.topLevelSubmenu, menuItem)\n                    .slideDown(this.options.submenuAnimationSpeed, $.proxy(function () {\n                        $(menuItem).addClass(this.options.topLevelHoverClass);\n                        $(menuItem).data('opened', true);\n                    }, this));\n            } else if ($(e.target).closest(this.options.topLevel)) {\n                $(e.target)\n                    .addClass(this.options.topLevelHoverClass)\n                    .siblings(this.options.topLevel)\n                        .removeClass(this.options.topLevelHoverClass);\n            }\n        },\n\n        /**\n         * @param {*} menuItem\n         * @param {*} excludeCurrent\n         * @param {*} fast\n         * @private\n         */\n        _closeSubmenu: function (menuItem, excludeCurrent, fast) {\n            var topLevel = $(this.options.topLevel, this.element),\n                activeSubmenu = $(this.options.topLevelSubmenu, menuItem || null);\n\n            $(this.options.topLevelSubmenu, topLevel)\n                .filter(function () {\n                    return excludeCurrent ? $(this).not(activeSubmenu) : true;\n                })\n                .slideUp(fast ? 0 : this.options.submenuAnimationSpeed);\n\n            topLevel\n                .removeClass(this.options.topLevelHoverClass)\n                .data('opened', false);\n        },\n\n        /**\n         * @private\n         */\n        _checkToCollapseOrExpand: function () {\n            var navWidth, totalWidth, startCollapseIndex;\n\n            if ($('html').hasClass('lt-640') || $('html').hasClass('w-640')) {\n                return;\n            }\n\n            navWidth = this.itemsContainer.width();\n            totalWidth = 0;\n            startCollapseIndex = 0;\n\n            $.each($(this.options.topLevel, this.element), function (index, item) {\n                totalWidth += $(item).outerWidth(true);\n\n                if (totalWidth > navWidth && !startCollapseIndex) {\n                    startCollapseIndex = index - 2;\n                }\n            });\n\n            this[startCollapseIndex ? '_collapseMenu' : '_expandMenu'](startCollapseIndex);\n        },\n\n        /**\n         * @param {*} startCollapseIndex\n         * @private\n         */\n        _collapseMenu: function (startCollapseIndex) {\n            this.elemsToCollapse = this.topLevel.filter(function (index) {\n                return index > startCollapseIndex;\n            });\n            this.elemsToCollapseClone = $('<div></div>').append(this.elemsToCollapse.clone()).html();\n\n            this.collapsableDropdown = $(\n                mageTemplate(\n                    this.options.collapsableDropdownTemplate,\n                    {\n                        elems: this.elemsToCollapseClone\n                    }\n                )\n            );\n\n            this.itemsContainer.append(this.collapsableDropdown);\n            this.elemsToCollapse.detach();\n        },\n\n        /**\n         * @private\n         */\n        _expandMenu: function () {\n            this.elemsToCollapse && this.elemsToCollapse.appendTo(this.itemsContainer);\n            this.collapsableDropdown && this.collapsableDropdown.remove();\n        },\n\n        /**\n         * @private\n         */\n        _destroy: function () {\n            this._expandMenu();\n        }\n    });\n\n    /*\n     * Provides \"Continium\" effect for submenu\n     * */\n    $.widget('mage.navigationMenu', $.mage.navigationMenu, {\n        options: {\n            parentLevel: '> ul > li.level0',\n            submenuAnimationSpeed: 150,\n            submenuContiniumEffect: false\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            this._super();\n            this._applySubmenuStyles();\n        },\n\n        /**\n         * @private\n         */\n        _applySubmenuStyles: function () {\n            $(this.options.topLevelSubmenu, $(this.options.topLevel, this.element))\n                .removeAttr('style');\n\n            $(this.options.topLevelSubmenu, $(this.options.parentLevel, this.element))\n                .css({\n                    display: 'block',\n                    height: 0,\n                    overflow: 'hidden'\n                });\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _openSubmenu: function (e) {\n            var menuItem = e.currentTarget,\n                submenu = $(this.options.topLevelSubmenu, menuItem),\n                openedItems = $(this.options.topLevel, this.element).filter(function () {\n                    return $(this).data('opened');\n                });\n\n            if (submenu.length) {\n                this.heightToAnimate = $(this.options.itemsContainer, submenu).outerHeight(true);\n\n                if (openedItems.length) {\n                    this._closeSubmenu(menuItem, true, this.heightToAnimate, $.proxy(function () {\n                        submenu.css({\n                            height: 'auto'\n                        });\n                        $(menuItem)\n                            .addClass(this.options.topLevelHoverClass);\n                    }, this), e);\n                } else {\n                    submenu.animate({\n                        height: this.heightToAnimate\n                    }, this.options.submenuAnimationSpeed, $.proxy(function () {\n                        $(menuItem)\n                            .addClass(this.options.topLevelHoverClass);\n                    }, this));\n                }\n\n                $(menuItem)\n                    .data('opened', true);\n            } else {\n                this._closeSubmenu(menuItem);\n            }\n        },\n\n        /**\n         * @param {*} menuItem\n         * @param {*} excludeCurrent\n         * @param {*} heightToAnimate\n         * @param {Function} callback\n         * @private\n         */\n        _closeSubmenu: function (menuItem, excludeCurrent, heightToAnimate, callback) {\n            var topLevel = $(this.options.topLevel, this.itemsContainer),\n                prevOpenedItem, prevOpenedSubmenu;\n\n            if (!excludeCurrent) {\n                $(this.options.topLevelSubmenu, $(this.options.parentLevel, this.element))\n                    .animate({\n                        height: 0\n                    });\n\n                topLevel\n                    .data('opened', false)\n                    .removeClass(this.options.topLevelHoverClass);\n            } else {\n                prevOpenedItem = topLevel.filter(function () {\n                    return $(this).data('opened');\n                });\n                prevOpenedSubmenu = $(this.options.topLevelSubmenu, prevOpenedItem);\n\n                prevOpenedSubmenu.animate({\n                    height: heightToAnimate\n                }, this.options.submenuAnimationSpeed, 'linear', function () {\n                    $(this).css({\n                        height: 0\n                    });\n                    callback && callback();\n                });\n\n                prevOpenedItem\n                    .data('opened', false)\n                    .removeClass(this.options.topLevelHoverClass);\n            }\n        },\n\n        /**\n         * @private\n         */\n        _collapseMenu: function () {\n            this._superApply(arguments);\n            this._applySubmenuStyles();\n        }\n    });\n\n    //  Responsive menu\n    $.widget('mage.navigationMenu', $.mage.navigationMenu, {\n        options: {\n            responsive: false,\n            origNavPlaceholder: '.page-header',\n            mainContainer: 'body',\n            pageWrapper: '.page-wrapper',\n            openedMenuClass: 'opened',\n            toggleActionPlaceholder: '.block-search',\n            itemWithSubmenu: 'li.parent',\n            titleWithSubmenu: 'li.parent > a',\n            submenu: 'li.parent > .submenu',\n            toggleActionTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<span data-action=\"toggle-nav\" class=\"action toggle nav\">Toggle Nav</span>' +\n                '</script>',\n            submenuActionsTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<li class=\"action all\">' +\n                        '<a href=\"<%= categoryURL %>\"><span>All <%= category %></span></a>' +\n                    '</li>' +\n                '</script>',\n            navigationSectionsWrapperTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<dl class=\"navigation-tabs\" data-sections=\"tabs\">' +\n                    '</dl>' +\n                '</script>',\n            navigationItemWrapperTemplate:\n                '<script type=\"text/x-magento-template\">' +\n                    '<dt class=\"item title <% if (active) { %>active<% } %>\" data-section=\"title\">' +\n                        '<a class=\"switch\" data-toggle=\"switch\" href=\"#TODO\"><%= title %></a>' +\n                    '</dt>' +\n                    '<dd class=\"item content <% if (active) { %>active<%}%>\" data-section=\"content\">' +\n                    '</dd>' +\n                '</script>'\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            this._super();\n\n            this.mainContainer = $(this.options.mainContainer);\n            this.pageWrapper = $(this.options.pageWrapper);\n            this.toggleAction = $(mageTemplate(this.options.toggleActionTemplate, {}));\n\n            if (this.options.responsive) {\n                mediaCheck({\n                    media: '(min-width: 768px)',\n                    entry: $.proxy(function () {\n                        this._toggleDesktopMode();\n                    }, this),\n                    exit: $.proxy(function () {\n                        this._toggleMobileMode();\n                    }, this)\n                });\n            }\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            this._super();\n            this._bindDocumentEvents();\n        },\n\n        /**\n         * @private\n         */\n        _bindDocumentEvents: function () {\n            if (!this.eventsBound) {\n                $(document)\n                    .on('click.toggleMenu', '.action.toggle.nav', $.proxy(function (e) {\n                        if ($(this.element).data('opened')) {\n                            this._hideMenu();\n                        } else {\n                            this._showMenu();\n                        }\n                        e.stopPropagation();\n                        this.mobileNav.scrollTop(0);\n                        this._fixedBackLink();\n                    }, this))\n                    .on('click.hideMenu', this.options.pageWrapper, $.proxy(function () {\n                        if ($(this.element).data('opened')) {\n                            this._hideMenu();\n                            this.mobileNav.scrollTop(0);\n                            this._fixedBackLink();\n                        }\n                    }, this))\n                    .on('click.showSubmenu', this.options.titleWithSubmenu, $.proxy(function (e) {\n                        this._showSubmenu(e);\n\n                        e.preventDefault();\n                        this.mobileNav.scrollTop(0);\n                        this._fixedBackLink();\n                    }, this))\n                    .on('click.hideSubmenu', '.action.back', $.proxy(function (e) {\n                        this._hideSubmenu(e);\n                        this.mobileNav.scrollTop(0);\n                        this._fixedBackLink();\n                    }, this));\n\n                this.eventsBound = true;\n            }\n        },\n\n        /**\n         * @private\n         */\n        _showMenu: function () {\n            $(this.element).data('opened', true);\n            this.mainContainer.add('html').addClass(this.options.openedMenuClass);\n        },\n\n        /**\n         * @private\n         */\n        _hideMenu: function () {\n            $(this.element).data('opened', false);\n            this.mainContainer.add('html').removeClass(this.options.openedMenuClass);\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _showSubmenu: function (e) {\n            var submenu;\n\n            $(e.currentTarget).addClass('action back');\n            submenu = $(e.currentTarget).siblings('.submenu');\n\n            submenu.addClass('opened');\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _hideSubmenu: function (e) {\n            var submenuSelector = '.submenu',\n                submenu = $(e.currentTarget).next(submenuSelector);\n\n            $(e.currentTarget).removeClass('action back');\n            submenu.removeClass('opened');\n        },\n\n        /**\n         * @private\n         */\n        _renderSubmenuActions: function () {\n            $.each(\n                $(this.options.itemWithSubmenu),\n                $.proxy(function (index, item) {\n                    var actions = $(mageTemplate(\n                            this.options.submenuActionsTemplate,\n                            {\n                                category: $('> a > span', item).text(),\n                                categoryURL: $('> a', item).attr('href')\n                            }\n                        )),\n                        submenu = $('> .submenu', item),\n                        items = $('> ul', submenu);\n\n                    items.prepend(actions);\n                }, this)\n            );\n        },\n\n        /**\n         * @private\n         */\n        _toggleMobileMode: function () {\n            this._expandMenu();\n\n            $(this.options.topLevelSubmenu, $(this.options.topLevel, this.element))\n                .removeAttr('style');\n\n            this.toggleAction.insertBefore(this.options.toggleActionPlaceholder);\n            this.mobileNav = $(this.element).detach().clone();\n            this.mainContainer.prepend(this.mobileNav);\n            this.mobileNav.find('> ul').addClass('nav');\n            this._insertExtraItems();\n            this._wrapItemsInSections();\n            this.mobileNav.scroll($.proxy(function () {\n                this._fixedBackLink();\n            }, this));\n\n            this._renderSubmenuActions();\n            this._bindDocumentEvents();\n        },\n\n        /**\n         * @private\n         */\n        _toggleDesktopMode: function () {\n            this.mobileNav && this.mobileNav.remove();\n            this.toggleAction.detach();\n            $(this.element).insertAfter(this.options.origNavPlaceholder);\n\n            $(document)\n                .off('click.toggleMenu', '.action.toggle.nav')\n                .off('click.hideMenu', this.options.pageWrapper)\n                .off('click.showSubmenu', this.options.titleWithSubmenu)\n                .off('click.hideSubmenu', '.action.back');\n\n            this.eventsBound = false;\n\n            this._applySubmenuStyles();\n        },\n\n        /**\n         * @private\n         */\n        _insertExtraItems: function () {\n            var settings, footerSettings, account;\n\n            if ($('.header.panel .switcher').length) {\n                settings = $('.header.panel .switcher')\n                    .clone()\n                    .addClass('settings');\n\n                this.mobileNav.prepend(settings);\n            }\n\n            if ($('.footer .switcher').length) {\n                footerSettings = $('.footer .switcher')\n                    .clone()\n                    .addClass('settings');\n\n                this.mobileNav.prepend(footerSettings);\n            }\n\n            if ($('.header.panel .header.links li').length) {\n                account = $('.header.panel > .header.links')\n                    .clone()\n                    .addClass('account');\n\n                this.mobileNav.prepend(account);\n            }\n        },\n\n        /**\n         * @private\n         */\n        _wrapItemsInSections: function () {\n            var account = $('> .account', this.mobileNav),\n                settings = $('> .settings', this.mobileNav),\n                nav = $('> .nav', this.mobileNav),\n                navigationSectionsWrapper = $(mageTemplate(this.options.navigationSectionsWrapperTemplate, {})),\n                navigationItemWrapper;\n\n            this.mobileNav.append(navigationSectionsWrapper);\n\n            if (nav.length) {\n                navigationItemWrapper = $(mageTemplate(this.options.navigationItemWrapperTemplate, {\n                    title: 'Menu'\n                }));\n                navigationSectionsWrapper.append(navigationItemWrapper);\n                navigationItemWrapper.eq(1).append(nav);\n            }\n\n            if (account.length) {\n                navigationItemWrapper = $(mageTemplate(this.options.navigationItemWrapperTemplate, {\n                    title: 'Account'\n                }));\n                navigationSectionsWrapper.append(navigationItemWrapper);\n                navigationItemWrapper.eq(1).append(account);\n            }\n\n            if (settings.length) {\n                navigationItemWrapper = $(\n                    mageTemplate(this.options.navigationItemWrapperTemplate, {\n                        title: 'Settings'\n                    })\n                );\n                navigationSectionsWrapper.append(navigationItemWrapper);\n                navigationItemWrapper.eq(1).append(settings);\n            }\n\n            navigationSectionsWrapper.addClass(\n                'navigation-tabs-' + navigationSectionsWrapper.find('[data-section=\"title\"]').length\n            );\n            navigationSectionsWrapper.terms();\n        },\n\n        /**\n         * @private\n         */\n        _fixedBackLink: function () {\n            var linksBack = this.mobileNav.find('.submenu .action.back'),\n                linkBack = this.mobileNav.find('.submenu.opened > ul > .action.back').last(),\n                subMenu, navOffset, linkBackHeight;\n\n            linksBack.removeClass('fixed');\n\n            if (linkBack.length) {\n                subMenu = linkBack.parent();\n                navOffset = this.mobileNav.find('.nav').position().top;\n                linkBackHeight = linkBack.height();\n\n                if (navOffset <= 0) {\n                    linkBack.addClass('fixed');\n                    subMenu.css({\n                        paddingTop: linkBackHeight\n                    });\n                } else {\n                    linkBack.removeClass('fixed');\n                    subMenu.css({\n                        paddingTop: 0\n                    });\n                }\n            }\n        }\n    });\n\n    return $.mage.navigationMenu;\n});\n","Magento_Msrp/js/msrp.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'mage/dropdown',\n    'mage/template'\n], function ($, priceUtils, _) {\n    'use strict';\n\n    $.widget('mage.addToCart', {\n        options: {\n            showAddToCart: true,\n            submitUrl: '',\n            cartButtonId: '',\n            singleOpenDropDown: true,\n            dialog: {}, // Options for mage/dropdown\n            dialogDelay: 500, // Delay in ms after resize dropdown shown again\n            origin: '', //Required, type of popup: 'msrp', 'tier' or 'info' popup\n\n            // Selectors\n            cartForm: '.form.map.checkout',\n            msrpLabelId: '#map-popup-msrp',\n            msrpPriceElement: '#map-popup-msrp .price-wrapper',\n            priceLabelId: '#map-popup-price',\n            priceElement: '#map-popup-price .price',\n            mapInfoLinks: '.map-show-info',\n            displayPriceElement: '.old-price.map-old-price .price-wrapper',\n            fallbackPriceElement: '.normal-price.map-fallback-price .price-wrapper',\n            displayPriceContainer: '.old-price.map-old-price',\n            fallbackPriceContainer: '.normal-price.map-fallback-price',\n            popUpAttr: '[data-role=msrp-popup-template]',\n            popupCartButtonId: '#map-popup-button',\n            paypalCheckoutButons: '[data-action=checkout-form-submit]',\n            popupId: '',\n            realPrice: '',\n            isSaleable: '',\n            msrpPrice: '',\n            helpLinkId: '',\n            addToCartButton: '',\n\n            // Text options\n            productName: '',\n            addToCartUrl: ''\n        },\n\n        openDropDown: null,\n        triggerClass: 'dropdown-active',\n\n        popUpOptions: {\n            appendTo: 'body',\n            dialogContentClass: 'active',\n            closeOnMouseLeave: false,\n            autoPosition: true,\n            closeOnClickOutside: false,\n            'dialogClass': 'popup map-popup-wrapper',\n            position: {\n                my: 'left top',\n                collision: 'fit none',\n                at: 'left bottom',\n                within: 'body'\n            },\n            shadowHinter: 'popup popup-pointer'\n        },\n        popupOpened: false,\n        wasOpened: false,\n\n        /**\n         * Creates widget instance\n         *\n         * @private\n         */\n        _create: function () {\n            if (this.options.origin === 'msrp') {\n                this.initMsrpPopup();\n            } else if (this.options.origin === 'info') {\n                this.initInfoPopup();\n            } else if (this.options.origin === 'tier') {\n                this.initTierPopup();\n            }\n            $(this.options.cartButtonId).on('click', this._addToCartSubmit.bind(this));\n            $(document).on('updateMsrpPriceBlock', this.onUpdateMsrpPrice.bind(this));\n            $(this.options.cartForm).on('submit', this._onSubmitForm.bind(this));\n        },\n\n        /**\n         * Init msrp popup\n         *\n         * @private\n         */\n        initMsrpPopup: function () {\n            var popupDOM = $(this.options.popUpAttr)[0],\n                $msrpPopup = $(popupDOM.innerHTML.trim());\n\n            $msrpPopup.find(this.options.productIdInput).val(this.options.productId);\n            $('body').append($msrpPopup);\n            $msrpPopup.trigger('contentUpdated');\n\n            $msrpPopup.find('button')\n                .on('click',\n                    this.handleMsrpAddToCart.bind(this))\n                .filter(this.options.popupCartButtonId)\n                .text($(this.options.addToCartButton).text());\n\n            $msrpPopup.find(this.options.paypalCheckoutButons).on('click',\n                this.handleMsrpPaypalCheckout.bind(this));\n\n            $(this.options.popupId).on('click',\n                this.openPopup.bind(this));\n\n            this.$popup = $msrpPopup;\n        },\n\n        /**\n         * Init info popup\n         *\n         * @private\n         */\n        initInfoPopup: function () {\n            var infoPopupDOM = $('[data-role=msrp-info-template]')[0],\n                $infoPopup = $(infoPopupDOM.innerHTML.trim());\n\n            $('body').append($infoPopup);\n\n            $(this.options.helpLinkId).on('click', function (e) {\n                this.popUpOptions.position.of = $(e.target);\n                $infoPopup.dropdownDialog(this.popUpOptions).dropdownDialog('open');\n                this._toggle($infoPopup);\n            }.bind(this));\n\n            this.$popup = $infoPopup;\n        },\n\n        /**\n         * Init tier price popup\n         * @private\n         */\n        initTierPopup: function () {\n            var popupDOM = $(this.options.popUpAttr)[0],\n                $tierPopup = $(popupDOM.innerHTML.trim());\n\n            $('body').append($tierPopup);\n            $tierPopup.find(this.options.productIdInput).val(this.options.productId);\n            this.popUpOptions.position.of = $(this.options.helpLinkId);\n\n            $tierPopup.find('button').on('click',\n                this.handleTierAddToCart.bind(this))\n                .filter(this.options.popupCartButtonId)\n                .text($(this.options.addToCartButton).text());\n\n            $tierPopup.find(this.options.paypalCheckoutButons).on('click',\n                this.handleTierPaypalCheckout.bind(this));\n\n            $(this.options.attr).on('click', function (e) {\n                this.$popup = $tierPopup;\n                this.tierOptions = $(e.target).data('tier-price');\n                this.openPopup(e);\n            }.bind(this));\n        },\n\n        /**\n         * handle 'AddToCart' click on Msrp popup\n         * @param {Object} ev\n         *\n         * @private\n         */\n        handleMsrpAddToCart: function (ev) {\n            ev.preventDefault();\n\n            if (this.options.addToCartButton) {\n                $(this.options.addToCartButton).click();\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * handle 'paypal checkout buttons' click on Msrp popup\n         *\n         * @private\n         */\n        handleMsrpPaypalCheckout: function () {\n            this.closePopup(this.$popup);\n        },\n\n        /**\n         * handle 'AddToCart' click on Tier popup\n         *\n         * @param {Object} ev\n         * @private\n         */\n        handleTierAddToCart: function (ev) {\n            ev.preventDefault();\n\n            if (this.options.addToCartButton &&\n                this.options.inputQty && !isNaN(this.tierOptions.qty)\n            ) {\n                $(this.options.inputQty).val(this.tierOptions.qty);\n                $(this.options.addToCartButton).click();\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * handle 'paypal checkout buttons' click on Tier popup\n         *\n         * @private\n         */\n        handleTierPaypalCheckout: function () {\n            if (this.options.inputQty && !isNaN(this.tierOptions.qty)\n            ) {\n                $(this.options.inputQty).val(this.tierOptions.qty);\n                this.closePopup(this.$popup);\n            }\n        },\n\n        /**\n         * Open and set up popup\n         *\n         * @param {Object} event\n         */\n        openPopup: function (event) {\n            var options = this.tierOptions || this.options;\n\n            this.popUpOptions.position.of = $(event.target);\n\n            if (!this.wasOpened) {\n                this.$popup.find(this.options.msrpLabelId).html(options.msrpPrice);\n                this.$popup.find(this.options.priceLabelId).html(options.realPrice);\n                this.wasOpened = true;\n            }\n            this.$popup.dropdownDialog(this.popUpOptions).dropdownDialog('open');\n            this._toggle(this.$popup);\n\n            if (!this.options.isSaleable) {\n                this.$popup.find('form').hide();\n            }\n        },\n\n        /**\n         * Toggle MAP popup visibility\n         *\n         * @param {HTMLElement} $elem\n         * @private\n         */\n        _toggle: function ($elem) {\n            $(document).on('mouseup.msrp touchend.msrp', function (e) {\n                if (!$elem.is(e.target) && $elem.has(e.target).length === 0) {\n                    this.closePopup($elem);\n                }\n            }.bind(this));\n            $(window).on('resize', function () {\n                this.closePopup($elem);\n            }.bind(this));\n        },\n\n        /**\n         * Close MAP information popup\n         *\n         * @param {HTMLElement} $elem\n         */\n        closePopup: function ($elem) {\n            $elem.dropdownDialog('close');\n            $(document).off('mouseup.msrp touchend.msrp');\n        },\n\n        /**\n         * Handler for addToCart action\n         *\n         * @param {Object} e\n         */\n        _addToCartSubmit: function (e) {\n            this.element.trigger('addToCart', this.element);\n\n            if (this.element.data('stop-processing')) {\n                return false;\n            }\n\n            if (this.options.addToCartButton) {\n                $(this.options.addToCartButton).click();\n\n                return false;\n            }\n\n            if (this.options.addToCartUrl) {\n                $('.mage-dropdown-dialog > .ui-dialog-content').dropdownDialog('close');\n            }\n\n            e.preventDefault();\n            $(this.options.cartForm).submit();\n        },\n\n        /**\n         * Call on event updatePrice. Proxy to updateMsrpPrice method.\n         *\n         * @param {Event} event\n         * @param {mixed} priceIndex\n         * @param {Object} prices\n         */\n        onUpdateMsrpPrice: function onUpdateMsrpPrice(event, priceIndex, prices) {\n\n            var defaultMsrp,\n                defaultPrice,\n                msrpPrice,\n                finalPrice;\n\n            defaultMsrp = _.chain(prices).map(function (price) {\n                return price.msrpPrice.amount;\n            }).reject(function (p) {\n                return p === null;\n            }).max().value();\n\n            defaultPrice = _.chain(prices).map(function (p) {\n                return p.finalPrice.amount;\n            }).min().value();\n\n            if (typeof priceIndex !== 'undefined') {\n                msrpPrice = prices[priceIndex].msrpPrice.amount;\n                finalPrice = prices[priceIndex].finalPrice.amount;\n\n                if (msrpPrice === null || msrpPrice <= finalPrice) {\n                    this.updateNonMsrpPrice(priceUtils.formatPrice(finalPrice));\n                } else {\n                    this.updateMsrpPrice(\n                        priceUtils.formatPrice(finalPrice),\n                        priceUtils.formatPrice(msrpPrice),\n                        false);\n                }\n            } else {\n                this.updateMsrpPrice(\n                    priceUtils.formatPrice(defaultPrice),\n                    priceUtils.formatPrice(defaultMsrp),\n                    true);\n            }\n        },\n\n        /**\n         * Update prices for configurable product with MSRP enabled\n         *\n         * @param {String} finalPrice\n         * @param {String} msrpPrice\n         * @param {Boolean} useDefaultPrice\n         */\n        updateMsrpPrice: function (finalPrice, msrpPrice, useDefaultPrice) {\n            var options = this.tierOptions || this.options;\n\n            $(this.options.fallbackPriceContainer).hide();\n            $(this.options.displayPriceContainer).show();\n            $(this.options.mapInfoLinks).show();\n\n            if (useDefaultPrice || !this.wasOpened) {\n                this.$popup.find(this.options.msrpLabelId).html(options.msrpPrice);\n                this.$popup.find(this.options.priceLabelId).html(options.realPrice);\n                $(this.options.displayPriceElement).html(msrpPrice);\n                this.wasOpened = true;\n            }\n\n            if (!useDefaultPrice) {\n                this.$popup.find(this.options.msrpPriceElement).html(msrpPrice);\n                this.$popup.find(this.options.priceElement).html(finalPrice);\n                $(this.options.displayPriceElement).html(msrpPrice);\n            }\n        },\n\n        /**\n         * Display non MAP price for irrelevant products\n         *\n         * @param {String} price\n         */\n        updateNonMsrpPrice: function (price) {\n            $(this.options.fallbackPriceElement).html(price);\n            $(this.options.displayPriceContainer).hide();\n            $(this.options.mapInfoLinks).hide();\n            $(this.options.fallbackPriceContainer).show();\n        },\n\n        /**\n         * Handler for submit form\n         *\n         * @private\n         */\n        _onSubmitForm: function () {\n            if ($(this.options.cartForm).valid()) {\n                $(this.options.cartButtonId).prop('disabled', true);\n            }\n        }\n\n    });\n\n    return $.mage.addToCart;\n});\n","Magento_Msrp/js/product/list/columns/msrp-price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Catalog/js/product/list/columns/price-box',\n    'Magento_Catalog/js/product/addtocart-button',\n    'mage/dropdown'\n], function ($, _, PriceBox) {\n    'use strict';\n\n    return PriceBox.extend({\n        defaults: {\n            priceBoxSelector: '[data-role=msrp-price-box]',\n            popupTmpl: 'Magento_Msrp/product/item/popup',\n            popupTriggerSelector: '[data-role=msrp-popup-trigger]',\n            popupSelector: '[data-role=msrp-popup]',\n            popupOptions: {\n                appendTo: 'body',\n                dialogContentClass: 'active',\n                closeOnMouseLeave: false,\n                autoPosition: true,\n                dialogClass: 'popup map-popup-wrapper',\n                position: {\n                    my: 'left top',\n                    collision: 'fit none',\n                    at: 'left bottom',\n                    within: 'body'\n                },\n                shadowHinter: 'popup popup-pointer'\n            }\n        },\n\n        /**\n         * Create and open popup with Msrp information.\n         *\n         * @param {Object} data - element data\n         * @param {DOMElement} elem - element\n         * @param {Event} event - event object\n         */\n        openPopup: function (data, elem, event) {\n            var $elem = $(elem),\n                $popup = $elem.find(this.popupSelector),\n                $trigger = $elem.find(this.popupTriggerSelector);\n\n            event.stopPropagation();\n\n            this.popupOptions.position.of = $trigger;\n            this.popupOptions.triggerTarget = $trigger;\n\n            $popup.dropdownDialog(this.popupOptions)\n                  .dropdownDialog('open');\n        },\n\n        /**\n         * Set listeners.\n         *\n         * @param {DOMElement} elem - DOM element\n         * @param {Object} data - element data\n         */\n        initListeners: function (elem, data) {\n            var $trigger = $(elem).find(this.popupTriggerSelector);\n\n            $trigger.on('click', this.openPopup.bind(this, data, elem));\n        },\n\n        /**\n         * Check whether we can apply msrp, or should use standard price.\n         *\n         * @param {Object} row\n         * @returns {Bool}\n         */\n        isMsrpApplicable: function (row) {\n            return this.getPrice(row)['is_applicable'];\n        },\n\n        /**\n         * Retrieve msrp formatted price\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getPrice: function (row) {\n            return row['price_info']['extension_attributes'].msrp;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Check if popup with actual price must be shown.\n         *\n         * @returns {Boolean}\n         */\n        isShowPriceOnGesture: function (row) {\n            return this.getPrice(row)['is_shown_price_on_gesture'];\n        },\n\n        /**\n         * Get msrp price supporting text.\n         *\n         * @returns {String}\n         */\n        getMsrpPriceMessage: function (row) {\n            return this.getPrice(row)['msrp_message'];\n        },\n\n        /**\n         * Get msrp price supporting text, when actual price is hidden.\n         *\n         * @returns {String}\n         */\n        getExplanationMessage: function (row) {\n            return this.getPrice(row)['explanation_message'];\n        }\n    });\n});\n","Magento_Msrp/js/view/checkout/minicart/subtotal/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/minicart/subtotal/totals',\n    'underscore'\n], function (Component, _) {\n    'use strict';\n\n    return Component.extend({\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.displaySubtotal(this.isMsrpApplied(this.cart().items));\n            this.cart.subscribe(function (updatedCart) {\n\n                this.displaySubtotal(this.isMsrpApplied(updatedCart.items));\n            }, this);\n        },\n\n        /**\n         * Determine if subtotal should be hidden.\n         * @param {Array} cartItems\n         * @return {Boolean}\n         */\n        isMsrpApplied: function (cartItems) {\n            return !_.find(cartItems, function (item) {\n                if (_.has(item, 'canApplyMsrp')) {\n                    return item.canApplyMsrp;\n                }\n\n                return false;\n            });\n        }\n    });\n});\n","Magento_Review/js/error-placement.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/mage'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).mage('validation', {\n            /** @inheritdoc */\n            errorPlacement: function (error, el) {\n\n                if (el.parents('#product-review-table').length) {\n                    $('#product-review-table').siblings(this.errorElement + '.' + this.errorClass).remove();\n                    $('#product-review-table').after(error);\n                } else {\n                    el.after(error);\n                }\n            }\n        });\n    };\n});\n","Magento_Review/js/process-reviews.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * @param {String} url\n     * @param {*} fromPages\n     */\n    function processReviews(url, fromPages) {\n        $.ajax({\n            url: url,\n            cache: true,\n            dataType: 'html',\n            showLoader: false,\n            loaderContext: $('.product.data.items')\n        }).done(function (data) {\n            $('#product-review-container').html(data).trigger('contentUpdated');\n            $('[data-role=\"product-review\"] .pages a').each(function (index, element) {\n                $(element).click(function (event) { //eslint-disable-line max-nested-callbacks\n                    processReviews($(element).attr('href'), true);\n                    event.preventDefault();\n                });\n            });\n        }).complete(function () {\n            if (fromPages == true) { //eslint-disable-line eqeqeq\n                $('html, body').animate({\n                    scrollTop: $('#reviews').offset().top - 50\n                }, 300);\n            }\n        });\n    }\n\n    return function (config) {\n        var reviewTab = $(config.reviewsTabSelector),\n            requiredReviewTabRole = 'tab';\n\n        if (reviewTab.attr('role') === requiredReviewTabRole && reviewTab.hasClass('active')) {\n            processReviews(config.productReviewUrl, location.hash === '#reviews');\n        } else {\n            reviewTab.one('beforeOpen', function () {\n                processReviews(config.productReviewUrl);\n            });\n        }\n\n        $(function () {\n            $('.product-info-main .reviews-actions a').click(function (event) {\n                var anchor, addReviewBlock;\n\n                event.preventDefault();\n                anchor = $(this).attr('href').replace(/^.*?(#|$)/, '');\n                addReviewBlock = $('.block.review-add .block-content #' + anchor);\n\n                if (addReviewBlock.length) {\n                    $('.product.data.items [data-role=\"content\"]').each(function (index) { //eslint-disable-line\n                        if (this.id == 'reviews') { //eslint-disable-line eqeqeq\n                            $('.product.data.items').tabs('activate', index);\n                        }\n                    });\n                    $('html, body').animate({\n                        scrollTop: addReviewBlock.offset().top - 50\n                    }, 300);\n                }\n\n            });\n        });\n    };\n});\n","Magento_Review/js/validate-review.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/validate',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.validator.addMethod(\n        'rating-required', function (value) {\n            return value !== undefined;\n        }, $.mage.__('Please select one of each of the ratings above.'));\n});\n","Magento_Review/js/view/review.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'Magento_Customer/js/view/customer'\n], function (Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.review = customerData.get('review').extend({\n                disposableCustomerData: 'review'\n            });\n        },\n\n        /**\n         * @return {*}\n         */\n        nickname: function () {\n            return this.review().nickname || customerData.get('customer')().firstname;\n        }\n    });\n});\n","Magento_Tax/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'mage/translate'\n], function (Element, $t) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Tax/price/adjustment',\n            taxPriceType: 'final_price',\n            taxPriceCssClass: 'price-including-tax',\n            bothPrices: 3,\n            inclTax: 2,\n            exclTax: 1,\n            modules: {\n                price: '${ $.parentName }'\n            },\n            listens: {\n                price: 'initializePriceAttributes'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super()\n                .initializePriceAttributes();\n\n            return this;\n        },\n\n        /**\n         * Update parent price.\n         *\n         * @returns {Object} Chainable.\n         */\n        initializePriceAttributes: function () {\n            if (this.displayBothPrices && this.price()) {\n                this.price().priceWrapperCssClasses = this.taxPriceCssClass;\n                this.price().priceWrapperAttr = {\n                    'data-label': $t('Incl. Tax')\n                };\n            }\n\n            return this;\n        },\n\n        /**\n         * Get price tax adjustment.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} tax html\n         */\n        getTax: function (row) {\n            return row['price_info']['extension_attributes']['tax_adjustments']['formatted_prices'][this.taxPriceType];\n        },\n\n        /**\n         * Set price tax type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPrices: function () {\n            return +this.source.data.displayTaxes === this.bothPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceIncludeTax: function () {\n            return +this.source.data.displayTaxes === this.inclTax;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.exclTax;\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/view/summary/shipping',\n    'Magento_Checkout/js/model/quote'\n], function ($, Component, quote) {\n    'use strict';\n\n    var displayMode = window.checkoutConfig.reviewShippingDisplayMode;\n\n    return Component.extend({\n        defaults: {\n            displayMode: displayMode,\n            template: 'Magento_Tax/checkout/summary/shipping'\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isBothPricesDisplayed: function () {\n            return this.displayMode == 'both'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isIncludingDisplayed: function () {\n            return this.displayMode == 'including'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isExcludingDisplayed: function () {\n            return this.displayMode == 'excluding'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*|Boolean}\n         */\n        isCalculated: function () {\n            return this.totals() && this.isFullMode() && quote.shippingMethod() != null;\n        },\n\n        /**\n         * @return {*}\n         */\n        getIncludingValue: function () {\n            var price;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            price = this.totals()['shipping_incl_tax'];\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * @return {*}\n         */\n        getExcludingValue: function () {\n            var price;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            price = this.totals()['shipping_amount'];\n\n            return this.getFormattedPrice(price);\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'ko',\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/totals',\n    'mage/translate',\n    'underscore'\n], function (ko, Component, quote, totals, $t, _) {\n    'use strict';\n\n    var isTaxDisplayedInGrandTotal = window.checkoutConfig.includeTaxInGrandTotal,\n        isFullTaxSummaryDisplayed = window.checkoutConfig.isFullTaxSummaryDisplayed,\n        isZeroTaxDisplayed = window.checkoutConfig.isZeroTaxDisplayed,\n        taxAmount = 0,\n        rates = 0;\n\n    return Component.extend({\n        defaults: {\n            isTaxDisplayedInGrandTotal: isTaxDisplayedInGrandTotal,\n            notCalculatedMessage: $t('Not yet calculated'),\n            template: 'Magento_Tax/checkout/summary/tax'\n        },\n        totals: quote.getTotals(),\n        isFullTaxSummaryDisplayed: isFullTaxSummaryDisplayed,\n\n        /**\n         * @return {Boolean}\n         */\n        ifShowValue: function () {\n            if (this.isFullMode() && this.getPureValue() == 0) { //eslint-disable-line eqeqeq\n                return isZeroTaxDisplayed;\n            }\n\n            return true;\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        ifShowDetails: function () {\n            if (!this.isFullMode()) {\n                return false;\n            }\n\n            return this.getPureValue() > 0 && isFullTaxSummaryDisplayed;\n        },\n\n        /**\n         * @return {Number}\n         */\n        getPureValue: function () {\n            var amount = 0,\n                taxTotal;\n\n            if (this.totals()) {\n                taxTotal = totals.getSegment('tax');\n\n                if (taxTotal) {\n                    amount = taxTotal.value;\n                }\n            }\n\n            return amount;\n        },\n\n        /**\n         * @return {*|Boolean}\n         */\n        isCalculated: function () {\n            return this.totals() && this.isFullMode() && totals.getSegment('tax') != null;\n        },\n\n        /**\n         * @return {*}\n         */\n        getValue: function () {\n            var amount;\n\n            if (!this.isCalculated()) {\n                return this.notCalculatedMessage;\n            }\n            amount = totals.getSegment('tax').value;\n\n            return this.getFormattedPrice(amount);\n        },\n\n        /**\n         * @param {*} amount\n         * @return {*|String}\n         */\n        formatPrice: function (amount) {\n            return this.getFormattedPrice(amount);\n        },\n\n        /**\n         * @param {*} parent\n         * @param {*} percentage\n         * @return {*|String}\n         */\n        getTaxAmount: function (parent, percentage) {\n            var totalPercentage = 0;\n\n            taxAmount = parent.amount;\n            rates = parent.rates;\n            _.each(rates, function (rate) {\n                totalPercentage += parseFloat(rate.percent);\n            });\n\n            return this.getFormattedPrice(this.getPercentAmount(taxAmount, totalPercentage, percentage));\n        },\n\n        /**\n         * @param {*} amount\n         * @param {*} totalPercentage\n         * @param {*} percentage\n         * @return {*|String}\n         */\n        getPercentAmount: function (amount, totalPercentage, percentage) {\n            return parseFloat(amount * percentage / totalPercentage);\n        },\n\n        /**\n         * @return {Array}\n         */\n        getDetails: function () {\n            var taxSegment = totals.getSegment('tax');\n\n            if (taxSegment && taxSegment['extension_attributes']) {\n                return taxSegment['extension_attributes']['tax_grandtotal_details'];\n            }\n\n            return [];\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    var displaySubtotalMode = window.checkoutConfig.reviewTotalsDisplayMode;\n\n    return Component.extend({\n        defaults: {\n            displaySubtotalMode: displaySubtotalMode,\n            template: 'Magento_Tax/checkout/summary/subtotal'\n        },\n        totals: quote.getTotals(),\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = this.totals().subtotal;\n            }\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isBothPricesDisplayed: function () {\n            return this.displaySubtotalMode == 'both'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isIncludingTaxDisplayed: function () {\n            return this.displaySubtotalMode == 'including'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValueInclTax: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = this.totals()['subtotal_incl_tax'];\n            }\n\n            return this.getFormattedPrice(price);\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/grand-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/abstract-total',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Checkout/js/model/totals'\n], function (Component, quote, priceUtils, totals) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            isFullTaxSummaryDisplayed: window.checkoutConfig.isFullTaxSummaryDisplayed || false,\n            template: 'Magento_Tax/checkout/summary/grand-total'\n        },\n        totals: quote.getTotals(),\n        isTaxDisplayedInGrandTotal: window.checkoutConfig.includeTaxInGrandTotal || false,\n\n        /**\n         * @return {*}\n         */\n        isDisplayed: function () {\n            return this.isFullMode();\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getValue: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = totals.getSegment('grand_total').value;\n            }\n\n            return this.getFormattedPrice(price);\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getBaseValue: function () {\n            var price = 0;\n\n            if (this.totals()) {\n                price = this.totals()['base_grand_total'];\n            }\n\n            return priceUtils.formatPrice(price, quote.getBasePriceFormat());\n        },\n\n        /**\n         * @return {*}\n         */\n        getGrandTotalExclTax: function () {\n            var total = this.totals();\n\n            if (!total) {\n                return 0;\n            }\n\n            return this.getFormattedPrice(total['grand_total']);\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isBaseGrandTotalDisplayNeeded: function () {\n            var total = this.totals();\n\n            if (!total) {\n                return false;\n            }\n\n            return total['base_currency_code'] != total['quote_currency_code']; //eslint-disable-line eqeqeq\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/summary/item/details/subtotal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Checkout/js/view/summary/item/details/subtotal'\n], function (subtotal) {\n    'use strict';\n\n    var displayPriceMode = window.checkoutConfig.reviewItemPriceDisplayMode || 'including';\n\n    return subtotal.extend({\n        defaults: {\n            displayPriceMode: displayPriceMode,\n            template: 'Magento_Tax/checkout/summary/item/details/subtotal'\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isPriceInclTaxDisplayed: function () {\n            return displayPriceMode == 'both' || displayPriceMode == 'including'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        isPriceExclTaxDisplayed: function () {\n            return displayPriceMode == 'both' || displayPriceMode == 'excluding'; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {*|String}\n         */\n        getValueInclTax: function (quoteItem) {\n            return this.getFormattedPrice(quoteItem['row_total_incl_tax']);\n        },\n\n        /**\n         * @param {Object} quoteItem\n         * @return {*|String}\n         */\n        getValueExclTax: function (quoteItem) {\n            return this.getFormattedPrice(quoteItem['row_total']);\n        }\n\n    });\n});\n","Magento_Tax/js/view/checkout/minicart/subtotal/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'ko',\n    'uiComponent',\n    'Magento_Customer/js/customer-data'\n], function (ko, Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        displaySubtotal: ko.observable(true),\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.cart = customerData.get('cart');\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/cart/totals/shipping.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/summary/shipping',\n    'Magento_Checkout/js/model/quote'\n], function (Component, quote) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @override\n         */\n        isCalculated: function () {\n            return !!quote.shippingMethod();\n        },\n\n        /**\n         * @override\n         */\n        getShippingMethodTitle: function () {\n            return '(' + this._super() + ')';\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/cart/totals/tax.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/summary/tax',\n    'Magento_Checkout/js/model/totals'\n], function (Component, totals) {\n    'use strict';\n\n    var isFullTaxSummaryDisplayed = window.checkoutConfig.isFullTaxSummaryDisplayed,\n        isZeroTaxDisplayed = window.checkoutConfig.isZeroTaxDisplayed;\n\n    return Component.extend({\n        /**\n         * @override\n         */\n        ifShowValue: function () {\n            if (this.getPureValue() === 0) {\n                return isZeroTaxDisplayed;\n            }\n\n            return true;\n        },\n\n        /**\n         * @override\n         */\n        ifShowDetails: function () {\n            return this.getPureValue() > 0 && isFullTaxSummaryDisplayed;\n        },\n\n        /**\n         * @override\n         */\n        isCalculated: function () {\n            return this.totals() && totals.getSegment('tax') !== null;\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/cart/totals/grand-total.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'Magento_Tax/js/view/checkout/summary/grand-total'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        /**\n         * @override\n         */\n        isDisplayed: function () {\n            return true;\n        }\n    });\n});\n","Magento_Tax/js/view/checkout/shipping_method/price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Catalog/js/price-utils'\n], function (Component, quote, priceUtils) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Tax/checkout/shipping_method/price'\n        },\n        isDisplayShippingPriceExclTax: window.checkoutConfig.isDisplayShippingPriceExclTax,\n        isDisplayShippingBothPrices: window.checkoutConfig.isDisplayShippingBothPrices,\n\n        /**\n         * @param {Object} item\n         * @return {Boolean}\n         */\n        isPriceEqual: function (item) {\n            return item['price_excl_tax'] != item['price_incl_tax']; //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @param {*} price\n         * @return {*|String}\n         */\n        getFormattedPrice: function (price) {\n            //todo add format data\n            return priceUtils.formatPrice(price, quote.getPriceFormat());\n        }\n    });\n});\n","Magento_ProductVideo/js/load-player.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n @version 0.0.1\n @requires jQuery & jQuery UI\n */\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    var videoRegister = {\n        _register: {},\n\n        /**\n         * Checks, if api is already registered\n         *\n         * @param {String} api\n         * @returns {bool}\n         */\n        isRegistered: function (api) {\n            return this._register[api] !== undefined;\n        },\n\n        /**\n         * Checks, if api is loaded\n         *\n         * @param {String} api\n         * @returns {bool}\n         */\n        isLoaded: function (api) {\n            return this._register[api] !== undefined && this._register[api] === true;\n        },\n\n        /**\n         * Register new video api\n         * @param {String} api\n         * @param {bool} loaded\n         */\n        register: function (api, loaded) {\n            loaded = loaded || false;\n            this._register[api] = loaded;\n        }\n    };\n\n    $.widget('mage.productVideoLoader', {\n\n        /**\n         * @private\n         */\n        _create: function () {\n            switch (this.element.data('type')) {\n                case 'youtube':\n                    this.element.videoYoutube();\n                    this._player = this.element.data('mageVideoYoutube');\n                    break;\n\n                case 'vimeo':\n                    this.element.videoVimeo();\n                    this._player = this.element.data('mageVideoVimeo');\n                    break;\n                default:\n                    throw {\n                        name: 'Video Error',\n                        message: 'Unknown video type',\n\n                        /**\n                         * join name with message\n                         */\n                        toString: function () {\n                            return this.name + ': ' + this.message;\n                        }\n                    };\n            }\n        },\n\n        /**\n         * Initializes variables\n         * @private\n         */\n        _initialize: function () {\n            this._params = this.element.data('params') || {};\n            this._code = this.element.data('code');\n            this._width = this.element.data('width');\n            this._height = this.element.data('height');\n            this._autoplay = !!this.element.data('autoplay');\n            this._playing = this._autoplay || false;\n            this._loop = this.element.data('loop');\n            this._rel = this.element.data('related');\n            this.useYoutubeNocookie = this.element.data('youtubenocookie') || false;\n\n            this._responsive = this.element.data('responsive') !== false;\n\n            if (this._responsive === true) {\n                this.element.addClass('responsive');\n            }\n\n            this._calculateRatio();\n        },\n\n        /**\n         * Abstract play command\n         */\n        play: function () {\n            this._player.play();\n        },\n\n        /**\n         * Abstract pause command\n         */\n        pause: function () {\n            this._player.pause();\n        },\n\n        /**\n         * Abstract stop command\n         */\n        stop: function () {\n            this._player.stop();\n        },\n\n        /**\n         * Abstract playing command\n         */\n        playing: function () {\n            return this._player.playing();\n        },\n\n        /**\n         * Destroyer\n         */\n        destroy: function () {\n            this._player.destroy();\n        },\n\n        /**\n         * Calculates ratio for responsive videos\n         * @private\n         */\n        _calculateRatio: function () {\n            if (!this._responsive) {\n                return;\n            }\n            this.element.css('paddingBottom', this._height / this._width * 100 + '%');\n        }\n    });\n\n    $.widget('mage.videoYoutube', $.mage.productVideoLoader, {\n\n        /**\n         * Initialization of the Youtube widget\n         * @private\n         */\n        _create: function () {\n            var self = this;\n\n            this._initialize();\n\n            this.element.append('<div/>');\n\n            this._on(window, {\n\n                /**\n                 * Handle event\n                 */\n                'youtubeapiready': function () {\n                    var host = 'https://www.youtube.com';\n\n                    if (self.useYoutubeNocookie) {\n                        host = 'https://www.youtube-nocookie.com';\n                    }\n\n                    if (self._player !== undefined) {\n                        return;\n                    }\n                    self._autoplay = true;\n\n                    if (self._autoplay) {\n                        self._params.autoplay = 1;\n                    }\n\n                    if (!self._rel) {\n                        self._params.rel = 0;\n                    }\n\n                    self._player = new window.YT.Player(self.element.children(':first')[0], {\n                        height: self._height,\n                        width: self._width,\n                        videoId: self._code,\n                        playerVars: self._params,\n                        host: host,\n                        events: {\n\n                            /**\n                             * Get duration\n                             */\n                            'onReady': function onPlayerReady() {\n                                self._player.getDuration();\n                                self.element.closest('.fotorama__stage__frame')\n                                    .addClass('fotorama__product-video--loaded');\n                            },\n\n                            /**\n                             * Event observer\n                             */\n                            onStateChange: function (data) {\n                                switch (window.parseInt(data.data, 10)) {\n                                    case 1:\n                                        self._playing = true;\n                                        break;\n                                    default:\n                                        self._playing = false;\n                                        break;\n                                }\n\n                                self._trigger('statechange', {}, data);\n\n                                if (data.data === window.YT.PlayerState.ENDED && self._loop) {\n                                    self._player.playVideo();\n                                }\n                            }\n                        }\n\n                    });\n                }\n            });\n\n            this._loadApi();\n        },\n\n        /**\n         * Loads Youtube API and triggers event, when loaded\n         * @private\n         */\n        _loadApi: function () {\n            var element,\n                scriptTag;\n\n            if (videoRegister.isRegistered('youtube')) {\n                if (videoRegister.isLoaded('youtube')) {\n                    $(window).trigger('youtubeapiready');\n                }\n\n                return;\n            }\n            videoRegister.register('youtube');\n\n            element = document.createElement('script');\n            scriptTag = document.getElementsByTagName('script')[0];\n\n            element.async = true;\n            element.src = 'https://www.youtube.com/iframe_api';\n            scriptTag.parentNode.insertBefore(element, scriptTag);\n\n            /**\n             * Event observe and handle\n             */\n            window.onYouTubeIframeAPIReady = function () {\n                $(window).trigger('youtubeapiready');\n                videoRegister.register('youtube', true);\n            };\n        },\n\n        /**\n         * Play command for Youtube\n         */\n        play: function () {\n            this._player.playVideo();\n            this._playing = true;\n        },\n\n        /**\n         * Pause command for Youtube\n         */\n        pause: function () {\n            this._player.pauseVideo();\n            this._playing = false;\n        },\n\n        /**\n         * Stop command for Youtube\n         */\n        stop: function () {\n            this._player.stopVideo();\n            this._playing = false;\n        },\n\n        /**\n         * Playing command for Youtube\n         */\n        playing: function () {\n            return this._playing;\n        },\n\n        /**\n         * stops and unloads player\n         * @private\n         */\n        destroy: function () {\n            this.stop();\n            this._player.destroy();\n        }\n    });\n\n    $.widget('mage.videoVimeo', $.mage.productVideoLoader, {\n\n        /**\n         * Initialize the Vimeo widget\n         * @private\n         */\n        _create: function () {\n            var timestamp,\n                additionalParams = '',\n                src;\n\n            this._initialize();\n            timestamp = new Date().getTime();\n            this._autoplay = true;\n\n            if (this._autoplay) {\n                additionalParams += '&autoplay=1';\n            }\n\n            if (this._loop) {\n                additionalParams += '&loop=1';\n            }\n            src = 'https://player.vimeo.com/video/' +\n                this._code + '?api=1&player_id=vimeo' +\n                this._code +\n                timestamp +\n                additionalParams;\n            this.element.append(\n                $('<iframe/>')\n                    .attr('frameborder', 0)\n                    .attr('id', 'vimeo' + this._code + timestamp)\n                    .attr('width', this._width)\n                    .attr('height', this._height)\n                    .attr('src', src)\n                    .attr('webkitallowfullscreen', '')\n                    .attr('mozallowfullscreen', '')\n                    .attr('allowfullscreen', '')\n                    .attr('referrerPolicy', 'origin')\n            );\n            this._player = window.$f(this.element.children(':first')[0]);\n\n            // Froogaloop throws error without a registered ready event\n            this._player.addEvent('ready', function (id) {\n                $('#' + id).closest('.fotorama__stage__frame').addClass('fotorama__product-video--loaded');\n            });\n        },\n\n        /**\n         * Play command for Vimeo\n         */\n        play: function () {\n            this._player.api('play');\n            this._playing = true;\n        },\n\n        /**\n         * Pause command for Vimeo\n         */\n        pause: function () {\n            this._player.api('pause');\n            this._playing = false;\n        },\n\n        /**\n         * Stop command for Vimeo\n         */\n        stop: function () {\n            this._player.api('unload');\n            this._playing = false;\n        },\n\n        /**\n         * Playing command for Vimeo\n         */\n        playing: function () {\n            return this._playing;\n        }\n    });\n});\n","Magento_ProductVideo/js/fotorama-add-video-events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'catalogGallery',\n    'loadPlayer'\n], function ($) {\n    'use strict';\n\n    /**\n     * @private\n     */\n    var allowBase = true; //global var is needed because fotorama always fully reloads events in case of fullscreen\n\n    /**\n     * @private\n     */\n    function parseHref(href) {\n        var a = document.createElement('a');\n\n        a.href = href;\n\n        return a;\n    }\n\n    /**\n     * @private\n     */\n    function parseURL(href, forceVideo) {\n        var id,\n            type,\n            ampersandPosition,\n            vimeoRegex,\n            useYoutubeNocookie = false;\n\n        /**\n         * Get youtube ID\n         * @param {String} srcid\n         * @returns {{}}\n         */\n        function _getYoutubeId(srcid) {\n            if (srcid) {\n                ampersandPosition = srcid.indexOf('&');\n\n                if (ampersandPosition === -1) {\n                    return srcid;\n                }\n\n                srcid = srcid.substring(0, ampersandPosition);\n            }\n\n            return srcid;\n        }\n\n        if (typeof href !== 'string') {\n            return href;\n        }\n\n        href = parseHref(href);\n\n        if (href.host.match(/youtube\\.com/) && href.search) {\n            id = href.search.split('v=')[1];\n\n            if (id) {\n                id = _getYoutubeId(id);\n                type = 'youtube';\n            }\n        } else if (href.host.match(/youtube\\.com|youtu\\.be|youtube-nocookie.com/)) {\n            id = href.pathname.replace(/^\\/(embed\\/|v\\/)?/, '').replace(/\\/.*/, '');\n            type = 'youtube';\n\n            if (href.host.match(/youtube-nocookie.com/)) {\n                useYoutubeNocookie = true;\n            }\n        } else if (href.host.match(/vimeo\\.com/)) {\n            type = 'vimeo';\n            vimeoRegex = new RegExp(['https?:\\\\/\\\\/(?:www\\\\.|player\\\\.)?vimeo.com\\\\/(?:channels\\\\/(?:\\\\w+\\\\/)',\n                '?|groups\\\\/([^\\\\/]*)\\\\/videos\\\\/|album\\\\/(\\\\d+)\\\\/video\\\\/|video\\\\/|)(\\\\d+)(?:$|\\\\/|\\\\?)'\n            ].join(''));\n            id = href.href.match(vimeoRegex)[3];\n        }\n\n        if ((!id || !type) && forceVideo) {\n            id = href.href;\n            type = 'custom';\n        }\n\n        return id ? {\n            id: id, type: type, s: href.search.replace(/^\\?/, ''), useYoutubeNocookie: useYoutubeNocookie\n        } : false;\n    }\n\n    //create AddFotoramaVideoEvents widget\n    $.widget('mage.AddFotoramaVideoEvents', {\n        options: {\n            videoData: '',\n            videoSettings: '',\n            optionsVideoData: '',\n            dataMergeStrategy: 'replace',\n            vimeoJSFrameworkLoaded: false\n        },\n\n        /**\n         * @private\n         */\n        onVimeoJSFramework: function () {},\n        defaultVideoData: [],\n        PV: 'product-video', // [CONST]\n        VU: 'video-unplayed',\n        PVLOADED: 'fotorama__product-video--loaded', // [CONST]\n        PVLOADING: 'fotorama__product-video--loading', // [CONST]\n        VID: 'video', // [CONST]\n        VI: 'vimeo', // [CONST]\n        FTVC: 'fotorama__video-close',\n        FTAR: 'fotorama__arr',\n        fotoramaSpinner: 'fotorama__spinner',\n        fotoramaSpinnerShow: 'fotorama__spinner--show',\n        TI: 'video-thumb-icon',\n        isFullscreen: false,\n        FTCF: '[data-gallery-role=\"fotorama__fullscreen-icon\"]',\n        Base: 0, //on check for video is base this setting become true if there is any video with base role\n        MobileMaxWidth: 767,\n        GP: 'gallery-placeholder', //gallery placeholder class is needed to find and erase <script> tag\n        videoData: null,\n        videoDataPlaceholder: [{\n            id: '',\n            isBase: true,\n            mediaType: 'image',\n            provider: ''\n        }],\n\n        /**\n         * Creates widget\n         * @private\n         */\n        _create: function () {\n            $(this.element).on('gallery:loaded',  $.proxy(function () {\n                this.fotoramaItem = $(this.element).find('.fotorama-item');\n                this._initialize();\n            }, this));\n        },\n\n        /**\n         *\n         * @private\n         */\n        _initialize: function () {\n            if (!this.defaultVideoData.length) {\n                this.defaultVideoData = this.options.videoData;\n            }\n\n            // If product does not have images, no video data generated,\n            // but for configurable product we still need a video data, in case of 'prepend' gallery strategy.\n            if (!this.defaultVideoData.length && !this.options.videoData.length) {\n                this.defaultVideoData = this.options.videoData = this.videoDataPlaceholder;\n            }\n\n            this.clearEvents();\n\n            if (this._checkForVideoExist()) {\n                this._checkFullscreen();\n                this._listenForFullscreen();\n                this._checkForVimeo();\n                this._isVideoBase();\n                this._initFotoramaVideo();\n                this._attachFotoramaEvents();\n            }\n        },\n\n        /**\n         * Clear gallery events to prevent duplicated calls.\n         *\n         * @private\n         */\n        clearEvents: function () {\n            if (this.fotoramaItem !== undefined) {\n                this.fotoramaItem.off(\n                    'fotorama:show.' + this.PV +\n                    ' fotorama:showend.' + this.PV +\n                    ' fotorama:fullscreenenter.' + this.PV +\n                    ' fotorama:fullscreenexit.' + this.PV\n                );\n            }\n        },\n\n        /**\n         *\n         * @param {Object} options\n         * @private\n         */\n        _setOptions: function (options) {\n            if (options.videoData && options.videoData.length) {\n                this.options.videoData = options.videoData;\n            }\n\n            this._loadVideoData(options);\n            this._initialize();\n        },\n\n        /**\n         * Set video data for configurable product.\n         *\n         * @param {Object} options\n         * @private\n         */\n        _loadVideoData: function (options) {\n            if (options.selectedOption) {\n                if (options.dataMergeStrategy === 'prepend') {\n                    this.options.videoData = [].concat(\n                        this.options.optionsVideoData[options.selectedOption],\n                        this.defaultVideoData\n                    );\n                } else {\n                    this.options.videoData = this.options.optionsVideoData[options.selectedOption];\n                }\n            } else {\n                this.options.videoData = this.defaultVideoData;\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _checkFullscreen: function () {\n            if (this.fotoramaItem.data('fotorama').fullScreen || false) {\n                this.isFullscreen = true;\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _listenForFullscreen: function () {\n            this.fotoramaItem.on('fotorama:fullscreenenter.' + this.PV, $.proxy(function () {\n                this.isFullscreen = true;\n            }, this));\n\n            this.fotoramaItem.on('fotorama:fullscreenexit.' + this.PV, $.proxy(function () {\n                this.isFullscreen = false;\n                this._hideVideoArrows();\n            }, this));\n        },\n\n        /**\n         *\n         * @param {Object} inputData\n         * @param {bool} isJSON\n         * @returns {{}}\n         * @private\n         */\n        _createVideoData: function (inputData, isJSON) {\n            var videoData = [],\n                dataUrl,\n                tmpVideoData,\n                tmpInputData,\n                i;\n\n            if (isJSON) {\n                inputData = $.parseJSON(inputData);\n            }\n\n            for (i = 0; i < inputData.length; i++) {\n                tmpInputData = inputData[i];\n                dataUrl = '';\n                tmpVideoData = {\n                    mediaType: '',\n                    isBase: '',\n                    id: '',\n                    provider: ''\n                };\n                tmpVideoData.mediaType = this.VID;\n\n                if (tmpInputData.mediaType !== 'external-video') {\n                    tmpVideoData.mediaType = tmpInputData.mediaType;\n                }\n\n                tmpVideoData.isBase = tmpInputData.isBase;\n\n                if (tmpInputData.videoUrl && tmpInputData.videoUrl !== null) {\n                    dataUrl = tmpInputData.videoUrl;\n                    dataUrl = parseURL(dataUrl);\n                    tmpVideoData.id = dataUrl.id;\n                    tmpVideoData.provider = dataUrl.type;\n                    tmpVideoData.videoUrl = tmpInputData.videoUrl;\n                    tmpVideoData.useYoutubeNocookie = dataUrl.useYoutubeNocookie;\n                }\n\n                videoData.push(tmpVideoData);\n            }\n\n            return videoData;\n        },\n\n        /**\n         *\n         * @param {Object} fotorama\n         * @param {bool} isBase\n         * @private\n         */\n        _createCloseVideo: function (fotorama, isBase) {\n            var closeVideo;\n\n            this.fotoramaItem.find('.' + this.FTVC).remove();\n            this.fotoramaItem.append('<div class=\"' + this.FTVC + '\"></div>');\n            this.fotoramaItem.css('position', 'relative');\n            closeVideo = this.fotoramaItem.find('.' + this.FTVC);\n            this._closeVideoSetEvents(closeVideo, fotorama);\n\n            if (\n                isBase &&\n                this.options.videoData[fotorama.activeIndex].isBase &&\n                $(window).width() > this.MobileMaxWidth) {\n                this._showCloseVideo();\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _hideCloseVideo: function () {\n            this.fotoramaItem\n                .find('.' + this.FTVC)\n                .removeClass('fotorama-show-control');\n        },\n\n        /**\n         *\n         * @private\n         */\n        _showCloseVideo: function () {\n            this.fotoramaItem\n                .find('.' + this.FTVC)\n                .addClass('fotorama-show-control');\n        },\n\n        /**\n         *\n         * @param {jQuery} $closeVideo\n         * @param {jQuery} fotorama\n         * @private\n         */\n        _closeVideoSetEvents: function ($closeVideo, fotorama) {\n            $closeVideo.on('click', $.proxy(function () {\n                this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, true);\n                this._hideCloseVideo();\n            }, this));\n        },\n\n        /**\n         *\n         * @returns {Boolean}\n         * @private\n         */\n        _checkForVideoExist: function () {\n            var key, result, checker, videoSettings;\n\n            if (!this.options.videoData) {\n                return false;\n            }\n\n            if (!this.options.videoSettings) {\n                return false;\n            }\n\n            result = this._createVideoData(this.options.videoData, false);\n            checker = false;\n            videoSettings = this.options.videoSettings[0];\n            videoSettings.playIfBase = parseInt(videoSettings.playIfBase, 10);\n            videoSettings.showRelated = parseInt(videoSettings.showRelated, 10);\n            videoSettings.videoAutoRestart = parseInt(videoSettings.videoAutoRestart, 10);\n\n            for (key in result) {\n                if (result[key].mediaType === this.VID) {\n                    checker = true;\n                }\n            }\n\n            if (checker) {\n                this.options.videoData = result;\n            }\n\n            return checker;\n        },\n\n        /**\n         *\n         * @private\n         */\n        _checkForVimeo: function () {\n            var allVideoData = this.options.videoData,\n                videoItem;\n\n            if (window.Froogaloop) { // prevent duplicated initialization\n                return;\n            }\n\n            for (videoItem in allVideoData) {\n                if (allVideoData[videoItem].provider === this.VI) {\n                    this._loadVimeoJSFramework();\n\n                    return;\n                }\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _isVideoBase: function () {\n            var allVideoData = this.options.videoData,\n                videoItem,\n                allVideoDataKeys,\n                key,\n                i;\n\n            allVideoDataKeys = Object.keys(allVideoData);\n\n            for (i = 0; i < allVideoDataKeys.length; i++) {\n                key = allVideoDataKeys[i];\n                videoItem = allVideoData[key];\n\n                if (\n                    videoItem.mediaType === this.VID && videoItem.isBase &&\n                    this.options.videoSettings[0].playIfBase && allowBase\n                ) {\n                    this.Base = true;\n                    allowBase = false;\n                }\n            }\n\n            if (!this.isFullscreen) {\n                this._createCloseVideo(this.fotoramaItem.data('fotorama'), this.Base);\n            }\n        },\n\n        /**\n         *\n         * @private\n         */\n        _loadVimeoJSFramework: function () {\n            var element = document.createElement('script'),\n                scriptTag = document.getElementsByTagName('script')[0];\n\n            element.async = true;\n            element.src = 'https://f.vimeocdn.com/js/froogaloop2.min.js';\n\n            /**\n             * Vimeo js framework on load callback.\n             */\n            element.onload = function () {\n                this.onVimeoJSFramework();\n                this.vimeoJSFrameworkLoaded = true;\n            }.bind(this);\n            scriptTag.parentNode.insertBefore(element, scriptTag);\n        },\n\n        /**\n         *\n         * @param {Event} e\n         * @private\n         */\n        _initFotoramaVideo: function (e) {\n            var fotorama = this.fotoramaItem.data('fotorama'),\n                thumbsParent,\n                thumbs,\n                t;\n\n            if (!fotorama.activeFrame.$navThumbFrame) {\n                this.fotoramaItem.on('fotorama:showend.' + this.PV, $.proxy(function (evt, fotoramaData) {\n                    $(fotoramaData.activeFrame.$stageFrame).removeAttr('href');\n                }, this));\n\n                this._startPrepareForPlayer(e, fotorama);\n\n                return null;\n            }\n\n            fotorama.data.map($.proxy(this._setItemType, this));\n            thumbsParent = fotorama.activeFrame.$navThumbFrame.parent();\n            thumbs = thumbsParent.find('.fotorama__nav__frame:visible');\n\n            for (t = 0; t < thumbs.length; t++) {\n                this._setThumbsIcon(thumbs.eq(t), t);\n                this._checkForVideo(e, fotorama, t + 1);\n            }\n\n            this.fotoramaItem.on('fotorama:showend.' + this.PV, $.proxy(function (evt, fotoramaData) {\n                $(fotoramaData.activeFrame.$stageFrame).removeAttr('href');\n            }, this));\n        },\n\n        /**\n         *\n         * @param {Object} elem\n         * @param {Number} i\n         * @private\n         */\n        _setThumbsIcon: function (elem, i) {\n            var fotorama = this.fotoramaItem.data('fotorama');\n\n            if (fotorama.options.nav === 'dots' && elem.hasClass(this.TI)) {\n                elem.removeClass(this.TI);\n            }\n\n            if (this.options.videoData[i].mediaType === this.VID &&\n                fotorama.data[i].type ===  this.VID &&\n                fotorama.options.nav === 'thumbs') {\n                elem.addClass(this.TI);\n            }\n        },\n\n        /**\n         * Temporary solution with adding types for configurable product items\n         *\n         * @param {Object} item\n         * @param {Number} i\n         * @private\n         */\n        _setItemType: function (item, i) {\n            !item.type && (item.type = this.options.videoData[i].mediaType);\n        },\n\n        /**\n         * Attach\n         *\n         * @private\n         */\n        _attachFotoramaEvents: function () {\n            this.fotoramaItem.on('fotorama:showend.' + this.PV, $.proxy(function (e, fotorama) {\n                this._startPrepareForPlayer(e, fotorama);\n            }, this));\n\n            this.fotoramaItem.on('fotorama:show.' + this.PV, $.proxy(function (e, fotorama) {\n                this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, true);\n            }, this));\n\n            this.fotoramaItem.on('fotorama:fullscreenexit.' + this.PV, $.proxy(function (e, fotorama) {\n                fotorama.activeFrame.$stageFrame.find('.' + this.PV).remove();\n                this._startPrepareForPlayer(e, fotorama);\n            }, this));\n        },\n\n        /**\n         * Start prepare for player\n         *\n         * @param {Event} e\n         * @param {jQuery} fotorama\n         * @private\n         */\n        _startPrepareForPlayer: function (e, fotorama) {\n            this._unloadVideoPlayer(fotorama.activeFrame.$stageFrame.parent(), fotorama, false);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i - 1);\n            this._checkForVideo(e, fotorama, fotorama.activeFrame.i + 1);\n        },\n\n        /**\n         * Check for video\n         *\n         * @param {Event} e\n         * @param {jQuery} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _checkForVideo: function (e, fotorama, number) {\n            var videoData = this.options.videoData[number - 1],\n                $image = fotorama.data[number - 1];\n\n            if ($image) {\n                !$image.type && this._setItemType($image, number - 1);\n\n                if ($image.type === 'image') {\n                    $image.$navThumbFrame && $image.$navThumbFrame.removeClass(this.TI);\n                    this._hideCloseVideo();\n\n                    return;\n                } else if ($image.$navThumbFrame && $image.type === 'video') {\n                    !$image.$navThumbFrame.hasClass(this.TI) && $image.$navThumbFrame.addClass(this.TI);\n                }\n\n                $image = $image.$stageFrame;\n            }\n\n            if ($image && videoData && videoData.mediaType === this.VID) {\n                $(fotorama.activeFrame.$stageFrame).removeAttr('href');\n                this._prepareForVideoContainer($image, videoData, fotorama, number);\n            }\n\n            if (this.isFullscreen && this.fotoramaItem.data('fotorama').activeFrame.i === number) {\n                this.fotoramaItem.data('fotorama').activeFrame.$stageFrame[0].click();\n            }\n        },\n\n        /**\n         * Prepare for video container\n         *\n         * @param {jQuery} $image\n         * @param {Object} videoData\n         * @param {Object} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _prepareForVideoContainer: function ($image, videoData, fotorama, number) {\n            $image.addClass('fotorama-video-container').addClass(this.VU);\n            this._createVideoContainer(videoData, $image);\n            this._setVideoEvent($image, this.PV, fotorama, number);\n        },\n\n        /**\n         * Create video container\n         *\n         * @param {Object} videoData\n         * @param {jQuery} $image\n         * @private\n         */\n        _createVideoContainer: function (videoData, $image) {\n            var videoSettings;\n\n            videoSettings = this.options.videoSettings[0];\n            $image.find('.' + this.PV).remove();\n            $image.append(\n                '<div class=\"' +\n                this.PV +\n                '\" data-related=\"' +\n                videoSettings.showRelated +\n                '\" data-loop=\"' +\n                videoSettings.videoAutoRestart +\n                '\" data-type=\"' +\n                videoData.provider +\n                '\" data-code=\"' +\n                videoData.id +\n                '\"  data-youtubenocookie=\"' +\n                videoData.useYoutubeNocookie +\n                '\" data-width=\"100%\" data-height=\"100%\"></div>'\n            );\n        },\n\n        /**\n         *\n         * @param {Object} $image\n         * @param {Object} PV\n         * @param {Object} fotorama\n         * @param {Number} number\n         * @private\n         */\n        _setVideoEvent: function ($image, PV, fotorama, number) {\n            $image.find('.magnify-lens').remove();\n            $image\n                .off('click tap', $.proxy(this._clickHandler, this))\n                .on('click tap', $.proxy(this._clickHandler, this));\n            this._handleBaseVideo(fotorama, number); //check for video is it base and handle it if it's base\n        },\n\n        /**\n         * Hides preview arrows above video player.\n         * @private\n         */\n        _hideVideoArrows: function () {\n            var arrows = $('.' + this.FTAR);\n\n            arrows.removeClass('fotorama__arr--shown');\n            arrows.removeClass('fotorama__arr--hidden');\n        },\n\n        /**\n         * @private\n         */\n        _showLoader: function () {\n            var spinner = this.fotoramaItem.find('.' + this.fotoramaSpinner);\n\n            spinner.addClass(this.fotoramaSpinnerShow);\n            this.fotoramaItem.data('fotorama').activeFrame.$stageFrame.addClass(this.PVLOADING);\n        },\n\n        /**\n         * @private\n         */\n        _hideLoader: function () {\n            var spinner = this.fotoramaItem.find('.' + this.fotoramaSpinner);\n\n            spinner.removeClass(this.fotoramaSpinnerShow);\n            this.fotoramaItem.data('fotorama').activeFrame.$stageFrame.removeClass(this.PVLOADING);\n        },\n\n        /**\n         * @param {Event} event\n         * @private\n         */\n        _clickHandler: function (event) {\n            var type;\n\n            if ($(event.target).hasClass(this.VU) && $(event.target).find('iframe').length === 0) {\n                $(event.target).removeClass(this.VU);\n                type = $(event.target).find('.' + this.PV).data('type');\n\n                if (this.vimeoJSFrameworkLoaded && type === this.VI) {\n                    $(event.target).find('.' + this.PV).productVideoLoader();\n                } else if (type === this.VI) {\n                    this._showLoader();\n                    this.onVimeoJSFramework = function () {\n                        $(event.target).find('.' + this.PV).productVideoLoader();\n                        this._hideLoader();\n                    }.bind(this);\n                } else {\n                    $(event.target).find('.' + this.PV).productVideoLoader();\n                }\n\n                $('.' + this.FTAR).addClass(this.isFullscreen ? 'fotorama__arr--shown' : 'fotorama__arr--hidden');\n            }\n        },\n\n        /**\n         * Handle base video\n         * @param {Object} fotorama\n         * @param {Number} srcNumber\n         * @private\n         */\n        _handleBaseVideo: function (fotorama, srcNumber) {\n            var waitForFroogaloop,\n                videoData = this.options.videoData,\n                activeIndex = fotorama.activeIndex,\n                number = parseInt(srcNumber, 10),\n                activeIndexIsBase = videoData[activeIndex];\n\n            if (!this.Base) {\n                return;\n            }\n\n            if (activeIndexIsBase && number === 1 && $(window).width() > this.MobileMaxWidth) {\n                if (this.options.videoData[fotorama.activeIndex].provider === this.VI) {\n                    waitForFroogaloop = setInterval($.proxy(function () {\n                        if (window.Froogaloop) {\n                            clearInterval(waitForFroogaloop);\n                            fotorama.requestFullScreen();\n                            this.fotoramaItem.data('fotorama').activeFrame.$stageFrame[0].click();\n                            this.Base = false;\n                        }\n                    }, this), 50);\n                } else { //if not a vimeo - play it immediately with a little lag in case for fotorama fullscreen\n                    setTimeout($.proxy(function () {\n                        fotorama.requestFullScreen();\n                        this.fotoramaItem.data('fotorama').activeFrame.$stageFrame[0].click();\n                        this.Base = false;\n                    }, this), 50);\n                }\n            }\n        },\n\n        /**\n         * Destroy video player\n         * @param {jQuery} $wrapper\n         * @param {jQuery} current\n         * @param {bool} close\n         * @private\n         */\n        _unloadVideoPlayer: function ($wrapper, current, close) {\n            var self = this;\n\n            if (!$wrapper) {\n                return;\n            }\n\n            $wrapper.find('.' + this.PVLOADED).removeClass(this.PVLOADED);\n            this._hideLoader();\n\n            $wrapper.find('.' + this.PV).each(function () {\n                var $item = $(this).parent(),\n                    cloneVideoDiv,\n                    iframeElement = $(this).find('iframe'),\n                    currentIndex,\n                    itemIndex;\n\n                if (iframeElement.length === 0) {\n                    return;\n                }\n\n                currentIndex = current.activeFrame.$stageFrame.index();\n                itemIndex = $item.index();\n\n                if (currentIndex === itemIndex && !close) {\n                    return;\n                }\n\n                if (currentIndex !== itemIndex && close) {\n                    return;\n                }\n\n                iframeElement.remove();\n                cloneVideoDiv = $(this).clone();\n                $(this).remove();\n                $item.append(cloneVideoDiv);\n                $item.addClass(self.VU);\n\n                self._hideCloseVideo();\n                self._hideVideoArrows();\n\n                if (self.isFullscreen && !self.fotoramaItem.data('fotorama').options.fullscreen.arrows) {\n                    if ($('.' + self.FTAR + '--prev').is(':focus') || $('.' + self.FTAR + '--next').is(':focus')) {\n                        $(self.FTCF).focus();\n                    }\n                }\n            });\n        }\n    });\n\n    return $.mage.AddFotoramaVideoEvents;\n});\n","magnifier/magnify.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'magnifier/magnifier'\n], function ($, _) {\n    'use strict';\n\n    return function (config, element) {\n\n        var isTouchEnabled = 'ontouchstart' in document.documentElement,\n            gallerySelector = '[data-gallery-role=\"gallery\"]',\n            magnifierSelector = '[data-gallery-role=\"magnifier\"]',\n            magnifierZoomSelector = '[data-gallery-role=\"magnifier-zoom\"]',\n            zoomInButtonSelector = '[data-gallery-role=\"fotorama__zoom-in\"]',\n            zoomOutButtonSelector = '[data-gallery-role=\"fotorama__zoom-out\"]',\n            fullscreenImageSelector = '[data-gallery-role=\"stage-shaft\"] [data-active=\"true\"] .fotorama__img--full',\n            imageDraggableClass = 'fotorama__img--draggable',\n            imageZoommable = 'fotorama__img--zoommable',\n            zoomInLoaded = 'zoom-in-loaded',\n            zoomOutLoaded = 'zoom-out-loaded',\n            zoomInDisabled = 'fotorama__zoom-in--disabled',\n            zoomOutDisabled = 'fotorama__zoom-out--disabled',\n            keyboardNavigation,\n            videoContainerClass = 'fotorama-video-container',\n            hideMagnifier,\n            dragFlag,\n            endX,\n            transitionEnabled,\n            transitionActive = false,\n            tapFlag = 0,\n            allowZoomOut = false,\n            allowZoomIn = true;\n\n        (function () {\n            var style = document.documentElement.style,\n                transitionEnabled = style.transition !== undefined ||\n                style.WebkitTransition !== undefined ||\n                style.MozTransition !== undefined ||\n                style.MsTransition !== undefined ||\n                style.OTransition !== undefined;\n        })();\n\n        /**\n         * Return width and height of original image\n         * @param img original image node\n         * @returns {{rw: number, rh: number}}\n         */\n        function getImageSize(img) {\n            return {\n                rw: img.naturalWidth,\n                rh: img.naturalHeight\n            };\n        }\n\n        /**\n         * Sets min-height and min-width for image to avoid transition bug\n         * @param $image - fullscreen image\n         */\n        function calculateMinSize($image) {\n\n            var minHeight,\n                minWidth,\n                height = $image.height(),\n                width = $image.width(),\n                parentHeight = $image.parent().height(),\n                parentWidth = $image.parent().width();\n\n            if (width > parentWidth || height > parentHeight) {\n\n                if (width / height < parentWidth / parentHeight) {\n                    minHeight = parentHeight;\n                    minWidth = width * (parentHeight / height);\n                } else {\n                    minWidth = parentWidth;\n                    minHeight = height * parentWidth / width;\n                }\n                $image.css({\n                    'min-width': minWidth,\n                    'min-height': minHeight\n                });\n            }\n        }\n\n        function toggleZoomable($image, flag) {\n            if (flag) {\n                $image.css({\n                    'min-width': $image.width(),\n                    'min-height': $image.height(),\n                    'width': $image.width(),\n                    'height': $image.height()\n                }).addClass(imageZoommable);\n            } else {\n                $image.css({\n                    width: '',\n                    height: '',\n                    top: '',\n                    left: '',\n                    right: '',\n                    bottom: ''\n                }).removeClass(imageZoommable);\n                calculateMinSize($image);\n            }\n        }\n\n        function resetVars($image) {\n            allowZoomIn = true;\n            allowZoomOut = dragFlag = transitionActive = false;\n            $image.hasClass(imageDraggableClass) && $image.removeClass(imageDraggableClass);\n            toggleZoomable($image, false);\n        }\n\n        /**\n         * Set state for zoom controls.\n         * If state is true, zoom controls will be visible.\n         * IF state is false, zoom controls will be hidden.\n         * @param isHide\n         */\n        function hideZoomControls(isHide) {\n            if (isHide) {\n                $(zoomInButtonSelector).addClass(zoomInDisabled);\n                $(zoomOutButtonSelector).addClass(zoomOutDisabled);\n            } else {\n                $(zoomInButtonSelector).removeClass(zoomInDisabled);\n                $(zoomOutButtonSelector).removeClass(zoomOutDisabled);\n            }\n        }\n\n        /**\n         * Asynchronus control visibility of zoom buttons.\n         * If image bigger than her wrapper. Zoom controls must visible.\n         * @param path - image source path\n         * @param $image\n         */\n        function asyncToggleZoomButtons(path, $image) {\n            var img = new Image();\n\n            img.onload = function () {\n                this.height > $image.parent().height() || this.width > $image.parent().width() ?\n                    hideZoomControls(false) : hideZoomControls(true);\n            };\n            img.src = path;\n        }\n\n        /**\n         * Control visibility of zoom buttons.\n         * Zoom controls must be invisible for video content and touch devices.\n         * On touch devices active pinchIn/pinchOut.\n         * @param $image\n         * @param isTouchScreen - true for touch devices\n         * @param isVideoActiveFrame - true for active video frame\n         */\n        function toggleZoomButtons($image, isTouchScreen, isVideoActiveFrame) {\n            var path = $image.attr('src');\n\n            if (path && !isTouchScreen && !isVideoActiveFrame) {\n                asyncToggleZoomButtons(path, $image);\n            } else {\n                hideZoomControls(true);\n            }\n        }\n\n        /**\n         * Handle resize event in fullscreen.\n         * @param $image - Fullscreen image.\n         * @param e - Event.\n         */\n        function resizeHandler(e, $image) {\n            var imageSize,\n                parentWidth,\n                parentHeight,\n                isImageSmall,\n                isImageFit;\n\n            if (!e.data.$image || !e.data.$image.length)\n                return;\n\n            imageSize = getImageSize($(fullscreenImageSelector)[0]);\n            parentWidth = e.data.$image.parent().width();\n            parentHeight = e.data.$image.parent().height();\n            isImageSmall = parentWidth >= imageSize.rw && parentHeight >= imageSize.rh;\n            isImageFit = parentWidth > e.data.$image.width() && parentHeight > e.data.$image.height();\n\n            toggleZoomButtons(e.data.$image, isTouchEnabled, checkForVideo(e.data.fotorama.activeFrame.$stageFrame));\n            calculateMinSize(e.data.$image);\n\n            if (e.data.$image.hasClass(imageZoommable) && !allowZoomOut || isImageSmall || isImageFit) {\n                resetVars(e.data.$image);\n            }\n\n            if (!isImageSmall) {\n                toggleStandartNavigation();\n            }\n        }\n\n        function getTopValue($image, topProp, step, height, containerHeight) {\n            var top;\n\n            if (parseInt($image.css('marginTop')) || parseInt($image.css('marginLeft'))) {\n                top = dragFlag ? topProp - step / 4 : 0;\n                top = top < containerHeight - height ? containerHeight - height : top;\n                top = top > height - containerHeight ? height - containerHeight : top;\n            } else {\n                top = topProp + step / 2;\n                top = top < containerHeight - height ? containerHeight - height : top;\n                top = top > 0 ? 0 : top;\n\n                if (!dragFlag && step < 0) {\n                    top = top < (containerHeight - height) / 2 ? (containerHeight - height) / 2 : top;\n                }\n            }\n\n            return top;\n        }\n\n        function getLeftValue(leftProp, step, width, containerWidth) {\n            var left;\n\n            left = leftProp + step / 2;\n            left = left < containerWidth - width ? containerWidth - width : left;\n            left = left > 0 ? 0 : left;\n\n            if (!dragFlag && step < 0) {\n                left = left < (containerWidth - width) / 2 ? (containerWidth - width) / 2 : left;\n            }\n\n            return left;\n        }\n\n        function checkFullscreenImagePosition($image, dimentions, widthStep, heightStep) {\n            var $imageContainer,\n                containerWidth,\n                containerHeight,\n                settings,\n                top,\n                left,\n                right,\n                bottom,\n                ratio;\n\n            if ($(gallerySelector).data('fotorama').fullScreen) {\n                transitionActive = true;\n                $imageContainer = $image.parent();\n                containerWidth = $imageContainer.width();\n                containerHeight = $imageContainer.height();\n                top = $image.position().top;\n                left = $image.position().left;\n                ratio = $image.width() / $image.height();\n                dimentions.height = isNaN(dimentions.height) ? dimentions.width / ratio : dimentions.height;\n                dimentions.width = isNaN(dimentions.width) ? dimentions.height * ratio : dimentions.width;\n\n                top = dimentions.height >= containerHeight ?\n                    getTopValue($image, top, heightStep, dimentions.height, containerHeight) : 0;\n\n                left = dimentions.width >= containerWidth ?\n                    getLeftValue(left, widthStep, dimentions.width, containerWidth) : 0;\n\n                right = dragFlag && left < (containerWidth - dimentions.width) / 2 ? 0 : left;\n                bottom = dragFlag ? 0 : top;\n\n                settings = $.extend(dimentions, {\n                    top: top,\n                    left: left,\n                    right: right\n                });\n\n                $image.css(settings);\n            }\n        }\n\n        /**\n         * Toggles fotorama's keyboard and mouse/touch navigation.\n         */\n        function toggleStandartNavigation() {\n            var $selectable =\n                    $('a[href], area[href], input, select, textarea, button, iframe, object, embed, *[tabindex], *[contenteditable]')\n                    .not('[tabindex=-1], [disabled], :hidden'),\n                fotorama = $(gallerySelector).data('fotorama'),\n                $focus = $(':focus'),\n                index;\n\n            if (fotorama.fullScreen) {\n\n                $selectable.each(function (number) {\n\n                    if ($(this).is($focus)) {\n                        index = number;\n                    }\n                });\n\n                fotorama.setOptions({\n                    swipe: !allowZoomOut,\n                    keyboard: !allowZoomOut\n                });\n\n                if (_.isNumber(index)) {\n                    $selectable.eq(index).focus();\n                }\n            }\n        }\n\n        function zoomIn(e, xStep, yStep) {\n            var $image,\n                imgOriginalSize,\n                imageWidth,\n                imageHeight,\n                zoomWidthStep,\n                zoomHeightStep,\n                widthResult,\n                heightResult,\n                ratio,\n                dimentions = {};\n\n            if (allowZoomIn && (!transitionEnabled || !transitionActive) && (isTouchEnabled ||\n                !$(zoomInButtonSelector).hasClass(zoomInDisabled))) {\n                $image = $(fullscreenImageSelector);\n                imgOriginalSize = getImageSize($image[0]);\n                imageWidth = $image.width();\n                imageHeight = $image.height();\n                ratio = imageWidth / imageHeight;\n                allowZoomOut = true;\n                toggleStandartNavigation();\n\n                if (!$image.hasClass(imageZoommable)) {\n                    toggleZoomable($image, true);\n                }\n\n                e.preventDefault();\n\n                if (imageWidth >= imageHeight) {\n                    zoomWidthStep = xStep || Math.ceil(imageWidth * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    widthResult = imageWidth + zoomWidthStep;\n\n                    if (widthResult >= imgOriginalSize.rw) {\n                        widthResult = imgOriginalSize.rw;\n                        zoomWidthStep = xStep || widthResult - imageWidth;\n                        allowZoomIn = false;\n                    }\n                    heightResult = widthResult / ratio;\n                    zoomHeightStep = yStep || heightResult - imageHeight;\n                } else {\n                    zoomHeightStep = yStep || Math.ceil(imageHeight * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    heightResult = imageHeight + zoomHeightStep;\n\n                    if (heightResult >= imgOriginalSize.rh) {\n                        heightResult = imgOriginalSize.rh;\n                        zoomHeightStep = yStep || heightResult - imageHeight;\n                        allowZoomIn = false;\n                    }\n                    widthResult = heightResult * ratio;\n                    zoomWidthStep = xStep || widthResult - imageWidth;\n                }\n\n                if (imageWidth >= imageHeight && imageWidth !== imgOriginalSize.rw) {\n                    dimentions = $.extend(dimentions, {\n                        width: widthResult,\n                        height: 'auto'\n                    });\n                    checkFullscreenImagePosition($image, dimentions, -zoomWidthStep, -zoomHeightStep);\n\n                } else if (imageWidth < imageHeight && imageHeight !== imgOriginalSize.rh) {\n                    dimentions = $.extend(dimentions, {\n                        width: 'auto',\n                        height: heightResult\n                    });\n                    checkFullscreenImagePosition($image, dimentions, -zoomWidthStep, -zoomHeightStep);\n                }\n            }\n\n            return false;\n        }\n\n        function zoomOut(e, xStep, yStep) {\n            var $image,\n                widthResult,\n                heightResult,\n                dimentions,\n                parentWidth,\n                parentHeight,\n                imageWidth,\n                imageHeight,\n                zoomWidthStep,\n                zoomHeightStep,\n                ratio,\n                fitIntoParent;\n\n            if (allowZoomOut && (!transitionEnabled || !transitionActive) && (isTouchEnabled ||\n                !$(zoomOutButtonSelector).hasClass(zoomOutDisabled))) {\n                allowZoomIn = true;\n                $image = $(fullscreenImageSelector);\n                parentWidth = $image.parent().width();\n                parentHeight = $image.parent().height();\n                imageWidth = $image.width();\n                imageHeight = $image.height();\n                ratio = imageWidth / imageHeight;\n\n                e.preventDefault();\n\n                if (imageWidth >= imageHeight) {\n                    zoomWidthStep = xStep || Math.ceil(imageWidth * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    widthResult = imageWidth - zoomWidthStep;\n                    heightResult = widthResult / ratio;\n                    zoomHeightStep = yStep || imageHeight - heightResult;\n                } else {\n                    zoomHeightStep = yStep || Math.ceil(imageHeight * parseFloat(config.magnifierOpts.fullscreenzoom) / 100);\n                    heightResult = imageHeight - zoomHeightStep;\n                    widthResult = heightResult * ratio;\n                    zoomWidthStep = xStep || imageWidth - widthResult;\n                }\n\n                fitIntoParent = function () {\n                    if (ratio > parentWidth / parentHeight) {\n                        widthResult = parentWidth;\n                        zoomWidthStep = imageWidth - widthResult;\n                        heightResult = widthResult / ratio;\n                        zoomHeightStep = imageHeight - heightResult;\n                        dimentions = {\n                            width: widthResult,\n                            height: 'auto'\n                        };\n                    } else {\n                        heightResult = parentHeight;\n                        zoomHeightStep = imageHeight - heightResult;\n                        widthResult = heightResult * ratio;\n                        zoomWidthStep = imageWidth - widthResult;\n                        dimentions = {\n                            width: 'auto',\n                            height: heightResult\n                        };\n                    }\n                    checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                };\n\n                if (imageWidth >= imageHeight) {\n                    if (widthResult > parentWidth) {\n                        dimentions = {\n                            width: widthResult,\n                            height: 'auto'\n                        };\n                        checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                    } else if (heightResult > parentHeight) {\n                        dimentions = {\n                            width: widthResult,\n                            height: 'auto'\n                        };\n                        checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                    } else {\n                        allowZoomOut = dragFlag = false;\n                        toggleStandartNavigation();\n                        fitIntoParent();\n                    }\n                } else if (heightResult > parentHeight) {\n                    dimentions = {\n                        width: 'auto',\n                        height: heightResult\n                    };\n                    checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                } else if (widthResult > parentWidth) {\n                    dimentions = {\n                        width: 'auto',\n                        height: heightResult\n                    };\n                    checkFullscreenImagePosition($image, dimentions, zoomWidthStep, zoomHeightStep);\n                } else {\n                    allowZoomOut = dragFlag = false;\n                    toggleStandartNavigation();\n                    fitIntoParent();\n                }\n            }\n\n            return false;\n        }\n\n        /**\n         * Bind event on scroll on active item in fotorama\n         * @param e\n         * @param fotorama - object of fotorama\n         */\n        function mousewheel(e, fotorama, element) {\n            var $fotoramaStage = fotorama.activeFrame.$stageFrame,\n                fotoramaStage = $fotoramaStage.get(0);\n\n            function onWheel(e) {\n                var delta = e.deltaY || e.wheelDelta,\n                    ev = e || window.event;\n\n                if ($(gallerySelector).data('fotorama').fullScreen) {\n\n                    if (e.deltaY) {\n                        if (delta > 0) {\n                            zoomOut(ev);\n                        } else {\n                            zoomIn(ev);\n                        }\n                    } else if (delta > 0) {\n                        zoomIn(ev);\n                    } else {\n                        zoomOut(ev);\n                    }\n\n                    e.preventDefault ? e.preventDefault() : e.returnValue = false;\n                }\n            }\n\n            if (!$fotoramaStage.hasClass('magnify-wheel-loaded')) {\n                if (fotoramaStage && fotoramaStage.addEventListener) {\n                    if ('onwheel' in document) {\n                        fotoramaStage.addEventListener('wheel', onWheel);\n                    } else if ('onmousewheel' in document) {\n                        fotoramaStage.addEventListener('mousewheel', onWheel);\n                    } else {\n                        fotoramaStage.addEventListener('MozMousePixelScroll', onWheel);\n                    }\n                    $fotoramaStage.addClass('magnify-wheel-loaded');\n                }\n            }\n        }\n\n        /**\n         * Method which makes draggable picture. Also work on touch devices.\n         */\n        function magnifierFullscreen(fotorama) {\n            var isDragActive = false,\n                startX,\n                startY,\n                imagePosX,\n                imagePosY,\n                touch,\n                swipeSlide,\n                $gallery = $(gallerySelector),\n                $image = $(fullscreenImageSelector, $gallery),\n                $imageContainer = $('[data-gallery-role=\"stage-shaft\"] [data-active=\"true\"]'),\n                gallery = $gallery.data('fotorama'),\n                pinchDimention;\n\n            swipeSlide = _.throttle(function (direction) {\n                $(gallerySelector).data('fotorama').show(direction);\n            }, 500, {\n                trailing: false\n            });\n\n            /**\n             * Returns top position value for passed jQuery object.\n             *\n             * @param $el\n             * @return {number}\n             */\n            function getTop($el) {\n                return parseInt($el.get(0).style.top);\n            }\n\n            function shiftImage(dx, dy, e) {\n                var top = +imagePosY + dy,\n                    left = +imagePosX + dx,\n                    swipeCondition = $image.width() / 10 + 20;\n\n                dragFlag = true;\n\n                if ($image.offset().left === $imageContainer.offset().left + $imageContainer.width() - $image.width() && e.keyCode === 39 ||\n                    endX - 1 < $imageContainer.offset().left + $imageContainer.width() - $image.width() && dx < 0 &&\n                    _.isNumber(endX) &&\n                    (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove')) {\n                    endX = null;\n                    swipeSlide('>');\n\n                    return;\n                }\n\n                if ($image.offset().left === $imageContainer.offset().left && dx !== 0 && e.keyCode === 37 ||\n                    endX === $imageContainer.offset().left && dx > 0 &&\n                    (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove')) {\n                    endX = null;\n                    swipeSlide('<');\n\n                    return;\n                }\n\n                if ($image.height() > $imageContainer.height()) {\n                    if ($imageContainer.height() > $image.height() + top) {\n                        $image.css('top', $imageContainer.height() - $image.height());\n                    } else {\n                        top = $image.height() - getTop($image) - $imageContainer.height();\n                        dy = dy < top ? dy : top;\n                        $image.css('top', getTop($image) + dy);\n                    }\n                }\n\n                if ($image.width() > $imageContainer.width()) {\n\n                    if ($imageContainer.offset().left + $imageContainer.width() > left + $image.width()) {\n                        left = $imageContainer.offset().left + $imageContainer.width() - $image.width();\n                    } else {\n                        left = $imageContainer.offset().left < left ? $imageContainer.offset().left : left;\n                    }\n                    $image.offset({\n                        'left': left\n                    });\n                    $image.css('right', '');\n                } else if (Math.abs(dy) < 1 && allowZoomOut &&\n                    !(e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove')) {\n                    dx < 0 ? $(gallerySelector).data('fotorama').show('>') : $(gallerySelector).data('fotorama').show('<');\n                }\n\n                if ($image.width() <= $imageContainer.width() && allowZoomOut &&\n                    (e.type === 'mousemove' || e.type === 'touchmove' || e.type === 'pointermove' || e.type === 'MSPointerMove') &&\n                    Math.abs(dx) > Math.abs(dy) && Math.abs(dx) > swipeCondition) {\n                    dx < 0 ? swipeSlide('>') : swipeSlide('<');\n                }\n            }\n\n            /**\n             * Sets image size to original or fit in parent block\n             * @param e - event object\n             */\n            function dblClickHandler(e) {\n                var imgOriginalSize = getImageSize($image[0]),\n                    proportions;\n\n                if (imgOriginalSize.rh < $image.parent().height() && imgOriginalSize.rw < $image.parent().width()) {\n                    return;\n                }\n\n                proportions = imgOriginalSize.rw / imgOriginalSize.rh;\n\n                if (allowZoomIn) {\n                    zoomIn(e, imgOriginalSize.rw - $image.width(), imgOriginalSize.rh - $image.height());\n                } else if (proportions > $imageContainer.width() / $imageContainer.height()) {\n                    zoomOut(e, imgOriginalSize.rw - $imageContainer.width(), imgOriginalSize.rw / proportions);\n                } else {\n                    zoomOut(e, imgOriginalSize.rw * proportions, imgOriginalSize.rh - $imageContainer.height());\n                }\n            }\n\n            function detectDoubleTap(e) {\n                var now = new Date().getTime(),\n                    timesince = now - tapFlag;\n\n                if (timesince < 400 && timesince > 0) {\n                    transitionActive = false;\n                    tapFlag = 0;\n                    dblClickHandler(e);\n                } else {\n                    tapFlag = new Date().getTime();\n                }\n            }\n\n            if (isTouchEnabled) {\n                $image.off('tap');\n                $image.on('tap', function (e) {\n                    if (e.originalEvent.originalEvent.touches.length === 0) {\n                        detectDoubleTap(e);\n                    }\n                });\n            } else {\n                $image.unbind('dblclick');\n                $image.dblclick(dblClickHandler);\n            }\n\n            if (gallery.fullScreen) {\n                toggleZoomButtons($image, isTouchEnabled, checkForVideo(fotorama.activeFrame.$stageFrame));\n            }\n\n            function getDimention(event) {\n                return Math.sqrt(\n                    (event.touches[0].clientX - event.touches[1].clientX) * (event.touches[0].clientX - event.touches[1].clientX) +\n                    (event.touches[0].clientY - event.touches[1].clientY) * (event.touches[0].clientY - event.touches[1].clientY));\n            }\n\n            $image.off(isTouchEnabled ? 'touchstart' : 'pointerdown mousedown MSPointerDown');\n            $image.on(isTouchEnabled ? 'touchstart' : 'pointerdown mousedown MSPointerDown', function (e) {\n                if (e && e.originalEvent.touches && e.originalEvent.touches.length >= 2) {\n                    e.preventDefault();\n                    pinchDimention = getDimention(e.originalEvent);\n                    isDragActive = false;\n\n                    if ($image.hasClass(imageDraggableClass)) {\n                        $image.removeClass(imageDraggableClass);\n                    }\n                } else if (gallery.fullScreen && (!transitionEnabled || !transitionActive)) {\n                    e.preventDefault();\n\n                    imagePosY = getTop($image);\n                    imagePosX = $image.offset().left;\n\n                    if (isTouchEnabled) {\n                        touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];\n                        e.clientX = touch.pageX;\n                        e.clientY = touch.pageY;\n                    }\n                    startX = e.clientX || e.originalEvent.clientX;\n                    startY = e.clientY || e.originalEvent.clientY;\n                    isDragActive = true;\n                }\n\n                if ($image.offset() && $image.width() > $imageContainer.width()) {\n                    endX = $image.offset().left;\n                }\n            });\n\n            $image.off(isTouchEnabled ? 'touchmove' : 'mousemove pointermove MSPointerMove');\n            $image.on(isTouchEnabled ? 'touchmove' : 'mousemove pointermove MSPointerMove', function (e) {\n                if (e && e.originalEvent.touches && e.originalEvent.touches.length >= 2) {\n                    e.preventDefault();\n                    var currentDimention = getDimention(e.originalEvent);\n\n                    if ($image.hasClass(imageDraggableClass)) {\n                        $image.removeClass(imageDraggableClass);\n                    }\n\n                    if (currentDimention < pinchDimention) {\n                        zoomOut(e);\n                        pinchDimention = currentDimention;\n                    } else if (currentDimention > pinchDimention) {\n                        zoomIn(e);\n                        pinchDimention = currentDimention;\n                    }\n                } else {\n                    var clientX,\n                        clientY;\n\n                    if (gallery.fullScreen && isDragActive && (!transitionEnabled || !transitionActive)) {\n\n                        if (allowZoomOut && !$image.hasClass(imageDraggableClass)) {\n                            $image.addClass(imageDraggableClass);\n                        }\n                        clientX = e.clientX || e.originalEvent.clientX;\n                        clientY = e.clientY || e.originalEvent.clientY;\n\n                        e.preventDefault();\n\n                        if (isTouchEnabled) {\n                            touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];\n                            clientX = touch.pageX;\n                            clientY = touch.pageY;\n                        }\n\n                        if (allowZoomOut) {\n                            imagePosY = getTop($(fullscreenImageSelector, $gallery));\n                            shiftImage(clientX - startX, clientY - startY, e);\n                        }\n                    }\n                }\n            });\n\n            $image.off('transitionend webkitTransitionEnd mozTransitionEnd msTransitionEnd ');\n            $image.on('transitionend webkitTransitionEnd mozTransitionEnd msTransitionEnd', function () {\n                transitionActive = false;\n            });\n\n            if (keyboardNavigation) {\n                $(document).unbind('keydown', keyboardNavigation);\n            }\n\n            /**\n             * Replaces original navigations with better one\n             * @param e - event object\n             */\n            keyboardNavigation = function (e) {\n                var step = 40,\n                    $focus = $(':focus'),\n                    isFullScreen = $(gallerySelector).data('fotorama').fullScreen,\n                    initVars = function () {\n                        imagePosX = $(fullscreenImageSelector, $gallery).offset().left;\n                        imagePosY = getTop($(fullscreenImageSelector, $gallery));\n                    };\n\n                if (($focus.attr('data-gallery-role') || !$focus.length) && allowZoomOut) {\n                    if (isFullScreen) {\n                        imagePosX = $(fullscreenImageSelector, $(gallerySelector)).offset().left;\n                        imagePosY = getTop($(fullscreenImageSelector, $(gallerySelector)));\n                    }\n\n                    if (e.keyCode === 39) {\n\n                        if (isFullScreen) {\n                            initVars();\n                            shiftImage(-step, 0, e);\n                        }\n                    }\n\n                    if (e.keyCode === 38) {\n\n                        if (isFullScreen) {\n                            initVars();\n                            shiftImage(0, step, e);\n                        }\n                    }\n\n                    if (e.keyCode === 37) {\n\n                        if (isFullScreen) {\n                            initVars();\n                            shiftImage(step, 0, e);\n                        }\n                    }\n\n                    if (e.keyCode === 40) {\n\n                        if (isFullScreen) {\n                            e.preventDefault();\n                            initVars();\n                            shiftImage(0, -step, e);\n                        }\n                    }\n                }\n\n                if (e.keyCode === 27 && isFullScreen && allowZoomOut) {\n                    $(gallerySelector).data('fotorama').cancelFullScreen();\n                }\n            };\n\n            /**\n             * @todo keyboard navigation through Fotorama Api.\n             */\n            $(document).keydown(keyboardNavigation);\n\n            $(document).on(isTouchEnabled ? 'touchend' : 'mouseup pointerup MSPointerUp', function (e) {\n                if (gallery.fullScreen) {\n\n                    if ($image.offset() && $image.width() > $imageContainer.width()) {\n                        endX = $image.offset().left;\n                    }\n\n                    isDragActive = false;\n                    $image.removeClass(imageDraggableClass);\n                }\n            });\n\n            $(window).off('resize', resizeHandler);\n            $(window).on('resize', {\n                $image: $image,\n                fotorama: fotorama\n            }, resizeHandler);\n        }\n\n        /**\n         * Hides magnifier preview and zoom blocks.\n         */\n        hideMagnifier = function () {\n            $(magnifierSelector).empty().hide();\n            $(magnifierZoomSelector).remove();\n        };\n\n        /**\n         * Check is active frame in gallery include video content.\n         * If true activeFrame contain video.\n         * @param $stageFrame - active frame in gallery\n         * @returns {*|Boolean}\n         */\n        function checkForVideo($stageFrame) {\n            return $stageFrame.hasClass(videoContainerClass);\n        }\n\n        /**\n         * Hides magnifier on drag and while arrow click.\n         */\n        function behaveOnDrag(e, initPos) {\n            var pos = [e.pageX, e.pageY],\n                isArrow = $(e.target).data('gallery-role') === 'arrow',\n                isClick = initPos[0] === pos[0] && initPos[1] === pos[1],\n                isImg = $(e.target).parent().data('active');\n\n            if (isArrow || isImg && !isClick) {\n                hideMagnifier();\n            }\n        }\n\n        if (config.magnifierOpts.enabled) {\n            $(element).on('pointerdown mousedown MSPointerDown', function (e) {\n                var pos = [e.pageX, e.pageY];\n\n                $(element).on('mousemove pointermove MSPointerMove', function (ev) {\n                    navigator.msPointerEnabled ? hideMagnifier() : behaveOnDrag(ev, pos);\n                });\n                $(document).on('mouseup pointerup MSPointerUp', function () {\n                    $(element).off('mousemove pointermove MSPointerMove');\n                });\n            });\n        }\n\n        $.extend(config.magnifierOpts, {\n            zoomable: false,\n            thumb: '.fotorama__img',\n            largeWrapper: '[data-gallery-role=\"magnifier\"]',\n            height: config.magnifierOpts.height || function () {\n                return $('[data-active=\"true\"]').height();\n            },\n            width: config.magnifierOpts.width || function () {\n                var productMedia = $(gallerySelector).parent().parent();\n\n                return productMedia.parent().width() - productMedia.width() - 20;\n            },\n            left: config.magnifierOpts.left || function () {\n                return $(gallerySelector).offset().left + $(gallerySelector).width() + 20;\n            },\n            top: config.magnifierOpts.top || function () {\n                return $(gallerySelector).offset().top;\n            }\n        });\n\n        $(element).on('fotorama:load fotorama:showend fotorama:fullscreenexit fotorama:ready', function (e, fotorama) {\n            var $activeStageFrame = $(gallerySelector).data('fotorama').activeFrame.$stageFrame;\n\n            if (!$activeStageFrame.find(magnifierZoomSelector).length) {\n                hideMagnifier();\n\n                if (config.magnifierOpts) {\n                    config.magnifierOpts.large = $(gallerySelector).data('fotorama').activeFrame.img;\n                    config.magnifierOpts.full = fotorama.data[fotorama.activeIndex].original;\n                    !checkForVideo($activeStageFrame) && $($activeStageFrame).magnify(config.magnifierOpts);\n                }\n            }\n        });\n\n        $(element).on('gallery:loaded', function (e) {\n            var $prevImage;\n\n            $(element).find(gallerySelector)\n                .on('fotorama:ready', function (e, fotorama) {\n                    var $zoomIn = $(zoomInButtonSelector),\n                        $zoomOut = $(zoomOutButtonSelector);\n\n                    if (!$zoomIn.hasClass(zoomInLoaded)) {\n                        $zoomIn.on('click touchstart', zoomIn);\n                        $zoomIn.on('mousedown', function (e) {\n                            e.stopPropagation();\n                        });\n\n                        $zoomIn.keyup(function (e) {\n\n                            if (e.keyCode === 13) {\n                                zoomIn(e);\n                            }\n                        });\n\n                        $(window).keyup(function (e) {\n\n                            if (e.keyCode === 107 || fotorama.fullscreen) {\n                                zoomIn(e);\n                            }\n                        });\n\n                        $zoomIn.addClass(zoomInLoaded);\n                    }\n\n                    if (!$zoomOut.hasClass(zoomOutLoaded)) {\n                        $zoomOut.on('click touchstart', zoomOut);\n                        $zoomOut.on('mousedown', function (e) {\n                            e.stopPropagation();\n                        });\n\n                        $zoomOut.keyup(function (e) {\n\n                            if (e.keyCode === 13) {\n                                zoomOut(e);\n                            }\n                        });\n\n                        $(window).keyup(function (e) {\n\n                            if (e.keyCode === 109 || fotorama.fullscreen) {\n                                zoomOut(e);\n                            }\n                        });\n\n                        $zoomOut.addClass(zoomOutLoaded);\n                    }\n                })\n                .on('fotorama:fullscreenenter fotorama:showend', function (e, fotorama) {\n                    hideMagnifier();\n\n                    if (!$(fullscreenImageSelector).is($prevImage)) {\n                        resetVars($(fullscreenImageSelector));\n                    }\n                    magnifierFullscreen(fotorama);\n                    mousewheel(e, fotorama, element);\n\n                    if ($prevImage) {\n                        calculateMinSize($prevImage);\n\n                        if (!$(fullscreenImageSelector).is($prevImage)) {\n                            resetVars($prevImage);\n                        }\n                    }\n\n                    toggleStandartNavigation();\n                })\n                .on('fotorama:load', function (e, fotorama) {\n                    if ($(gallerySelector).data('fotorama').fullScreen) {\n                        toggleZoomButtons($(fullscreenImageSelector), isTouchEnabled,\n                            checkForVideo(fotorama.activeFrame.$stageFrame));\n                    }\n                    magnifierFullscreen(fotorama);\n                })\n                .on('fotorama:show', function (e, fotorama) {\n                    $prevImage = _.clone($(fullscreenImageSelector));\n                    hideMagnifier();\n                })\n                .on('fotorama:fullscreenexit', function (e, fotorama) {\n                    resetVars($(fullscreenImageSelector));\n                    hideMagnifier();\n                    hideZoomControls(true);\n                });\n        });\n\n        return config;\n    };\n});\n","magnifier/magnifier.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function ($) {\n    $.fn.magnify = function (options) {\n        'use strict';\n\n        var magnify = new Magnify($(this), options);\n\n        /* events must be tracked here */\n\n        /**\n         * Return that from _init function\n         *\n         */\n        return magnify;\n    };\n\n    function Magnify(element, options) {\n        var customUserOptions = options || {},\n            $box = $(element),\n            $thumb,\n            that = this,\n            largeWrapper = options.largeWrapper || '.magnifier-preview',\n            $magnifierPreview = $(largeWrapper);\n\n        curThumb = null,\n        magnifierOptions = {\n            x: 0,\n            y: 0,\n            w: 0,\n            h: 0,\n            lensW: 0,\n            lensH: 0,\n            lensBgX: 0,\n            lensBgY: 0,\n            largeW: 0,\n            largeH: 0,\n            largeL: 0,\n            largeT: 0,\n            zoom: 2,\n            zoomMin: 1.1,\n            zoomMax: 5,\n            mode: 'outside',\n            eventType: 'click',\n            status: 0,\n            zoomAttached: false,\n            zoomable: customUserOptions.zoomable !== undefined ?\n                customUserOptions.zoomable\n                : false,\n            onthumbenter: customUserOptions.onthumbenter !== undefined ?\n                customUserOptions.onthumbenter\n                : null,\n            onthumbmove: customUserOptions.onthumbmove !== undefined ?\n                customUserOptions.onthumbmove\n                : null,\n            onthumbleave: customUserOptions.onthumbleave !== undefined ?\n                customUserOptions.onthumbleave\n                : null,\n            onzoom: customUserOptions.onzoom !== undefined ?\n                customUserOptions.onzoom\n                : null\n        },\n        pos = {\n            t: 0,\n            l: 0,\n            x: 0,\n            y: 0\n        },\n        gId = 0,\n        status = 0,\n        curIdx = '',\n        curLens = null,\n        curLarge = null,\n        lensbg = customUserOptions.bg !== undefined ?\n            customUserOptions.lensbg\n            : true,\n        gZoom = customUserOptions.zoom !== undefined ?\n            customUserOptions.zoom\n            : magnifierOptions.zoom,\n        gZoomMin = customUserOptions.zoomMin !== undefined ?\n            customUserOptions.zoomMin\n            : magnifierOptions.zoomMin,\n        gZoomMax = customUserOptions.zoomMax !== undefined ?\n            customUserOptions.zoomMax\n            : magnifierOptions.zoomMax,\n        gMode = customUserOptions.mode || magnifierOptions.mode,\n        gEventType = customUserOptions.eventType || magnifierOptions.eventType,\n        data = {},\n        inBounds = false,\n        isOverThumb = false,\n        rate = 1,\n        paddingX = 0,\n        paddingY = 0,\n        enabled = true,\n        showWrapper = true;\n\n        var MagnifyCls = {\n            magnifyHidden: 'magnify-hidden',\n            magnifyOpaque: 'magnify-opaque',\n            magnifyFull: 'magnify-fullimage'\n        };\n\n        /**\n         * Update Lens positon on.\n         *\n         */\n        that.update = function () {\n            updateLensOnLoad();\n        };\n\n        /**\n         * Init new Magnifier\n         *\n         */\n        that.init = function () {\n            _init($box, options);\n        };\n\n        function _toBoolean(str) {\n            if (typeof str === 'string') {\n                if (str === 'true') {\n                    return true;\n                } else if (str === 'false' || '') {\n                    return false;\n                }\n                console.warn('Wrong type: can\\'t be transformed to Boolean');\n\n            } else if (typeof str === 'boolean') {\n                return str;\n            }\n        }\n\n        function createLens(thumb) {\n            if ($(thumb).siblings('.magnify-lens').length) {\n                return false;\n            }\n            var lens = $('<div class=\"magnify-lens magnify-hidden\" data-gallery-role=\"magnifier-zoom\"></div>');\n\n            $(thumb).parent().append(lens);\n        }\n\n        function updateLensOnLoad(idSelectorMainImg, thumb, largeImgInMagnifyLens, largeWrapper) {\n            var magnifyLensElement= $box.find('.magnify-lens'),\n                textWrapper;\n\n            if (data[idSelectorMainImg].status === 1) {\n                textWrapper = $('<div class=\"magnifier-loader-text\"></div>');\n                magnifyLensElement.className = 'magnifier-loader magnify-hidden';\n                textWrapper.html('Loading...');\n                magnifyLensElement.html('').append(textWrapper);\n            } else if (data[idSelectorMainImg].status === 2) {\n                magnifyLensElement.addClass(MagnifyCls.magnifyHidden);\n                magnifyLensElement.html('');\n\n                largeImgInMagnifyLens.id = idSelectorMainImg + '-large';\n                largeImgInMagnifyLens.style.width = data[idSelectorMainImg].largeImgInMagnifyLensWidth + 'px';\n                largeImgInMagnifyLens.style.height = data[idSelectorMainImg].largeImgInMagnifyLensHeight + 'px';\n                largeImgInMagnifyLens.className = 'magnifier-large magnify-hidden';\n\n                if (data[idSelectorMainImg].mode === 'inside') {\n                    magnifyLensElement.append(largeImgInMagnifyLens);\n                } else {\n                    largeWrapper.html('').append(largeImgInMagnifyLens);\n                }\n            }\n\n            data[idSelectorMainImg].lensH = data[idSelectorMainImg].lensH > $thumb.height() ? $thumb.height() : data[idSelectorMainImg].lensH;\n\n            if (Math.round(data[idSelectorMainImg].lensW) === 0) {\n                magnifyLensElement.css('display', 'none');\n            } else {\n                magnifyLensElement.css({\n                    width: Math.round(data[idSelectorMainImg].lensW) + 'px',\n                    height: Math.round(data[idSelectorMainImg].lensH) + 'px',\n                    display: ''\n                });\n            }\n        }\n\n        function getMousePos() {\n            var xPos = pos.x - magnifierOptions.x,\n                yPos = pos.y - magnifierOptions.y,\n                t,\n                l;\n\n            inBounds =  xPos < 0 || yPos < 0 || xPos > magnifierOptions.w || yPos > magnifierOptions.h  ? false : true;\n\n            l = xPos - magnifierOptions.lensW / 2;\n            t = yPos - magnifierOptions.lensH / 2;\n\n            if (xPos < magnifierOptions.lensW / 2) {\n                l = 0;\n            }\n\n            if (yPos < magnifierOptions.lensH / 2) {\n                t = 0;\n            }\n\n            if (xPos - magnifierOptions.w + Math.ceil(magnifierOptions.lensW / 2) > 0) {\n                l = magnifierOptions.w - Math.ceil(magnifierOptions.lensW + 2);\n            }\n\n            if (yPos - magnifierOptions.h + Math.ceil(magnifierOptions.lensH / 2) > 0) {\n                t = magnifierOptions.h - Math.ceil(magnifierOptions.lensH);\n            }\n\n            pos.l = l;\n            pos.t = t;\n\n            magnifierOptions.lensBgX = pos.l;\n            magnifierOptions.lensBgY = pos.t;\n\n            if (magnifierOptions.mode === 'inside') {\n                magnifierOptions.largeL = Math.round(xPos * (magnifierOptions.zoom - magnifierOptions.lensW / magnifierOptions.w));\n                magnifierOptions.largeT = Math.round(yPos * (magnifierOptions.zoom - magnifierOptions.lensH / magnifierOptions.h));\n            } else {\n                magnifierOptions.largeL = Math.round(magnifierOptions.lensBgX * magnifierOptions.zoom * (magnifierOptions.largeWrapperW / magnifierOptions.w));\n                magnifierOptions.largeT = Math.round(magnifierOptions.lensBgY * magnifierOptions.zoom * (magnifierOptions.largeWrapperH / magnifierOptions.h));\n            }\n        }\n\n        function onThumbEnter() {\n            if (_toBoolean(enabled)) {\n                magnifierOptions = data[curIdx];\n                curLens = $box.find('.magnify-lens');\n\n                if (magnifierOptions.status === 2) {\n                    curLens.removeClass(MagnifyCls.magnifyOpaque);\n                    curLarge = $('#' + curIdx + '-large');\n                    curLarge.removeClass(MagnifyCls.magnifyHidden);\n                } else if (magnifierOptions.status === 1) {\n                    curLens.className = 'magnifier-loader';\n                }\n            }\n        }\n\n        function onThumbLeave() {\n            if (magnifierOptions.status > 0) {\n                var handler = magnifierOptions.onthumbleave;\n\n                if (handler !== null) {\n                    handler({\n                        thumb: curThumb,\n                        lens: curLens,\n                        large: curLarge,\n                        x: pos.x,\n                        y: pos.y\n                    });\n                }\n\n                if (!curLens.hasClass(MagnifyCls.magnifyHidden)) {\n                    curLens.addClass(MagnifyCls.magnifyHidden);\n\n                    //$curThumb.removeClass(MagnifyCls.magnifyOpaque);\n                    if (curLarge !== null) {\n                        curLarge.addClass(MagnifyCls.magnifyHidden);\n                    }\n                }\n            }\n        }\n\n        function move() {\n            if (_toBoolean(enabled)) {\n                if (status !== magnifierOptions.status) {\n                    onThumbEnter();\n                }\n\n                if (magnifierOptions.status > 0) {\n                    curThumb.className = magnifierOptions.thumbCssClass + ' magnify-opaque';\n\n                    if (magnifierOptions.status === 1) {\n                        curLens.className = 'magnifier-loader';\n                    } else if (magnifierOptions.status === 2) {\n                        curLens.removeClass(MagnifyCls.magnifyHidden);\n                        curLarge.removeClass(MagnifyCls.magnifyHidden);\n                        curLarge.css({\n                            left: '-' + magnifierOptions.largeL + 'px',\n                            top: '-' + magnifierOptions.largeT + 'px'\n                        });\n                    }\n\n                    var borderOffset = 2; // Offset for magnify-lens border\n                    pos.t = pos.t <= 0 ? 0 : pos.t - borderOffset;\n\n                    curLens.css({\n                        left: pos.l + paddingX + 'px',\n                        top: pos.t + paddingY + 'px'\n                    });\n\n                    if (lensbg) {\n                        curLens.css({\n                            'background-color': 'rgba(f,f,f,.5)'\n                        });\n                    } else {\n                        curLens.get(0).style.backgroundPosition = '-' +\n                        magnifierOptions.lensBgX + 'px -' +\n                        magnifierOptions.lensBgY + 'px';\n                    }\n                    var handler = magnifierOptions.onthumbmove;\n\n                    if (handler !== null) {\n                        handler({\n                            thumb: curThumb,\n                            lens: curLens,\n                            large: curLarge,\n                            x: pos.x,\n                            y: pos.y\n                        });\n                    }\n                }\n\n                status = magnifierOptions.status;\n            }\n        }\n\n        function setThumbData(mainImage, mainImageData) {\n            var thumbBounds = mainImage.getBoundingClientRect(),\n                w = 0,\n                h = 0;\n\n            mainImageData.x = Math.round(thumbBounds.left);\n            mainImageData.y = Math.round(thumbBounds.top);\n            mainImageData.w = Math.round(thumbBounds.right - mainImageData.x);\n            mainImageData.h = Math.round(thumbBounds.bottom - mainImageData.y);\n\n            if (mainImageData.mode === 'inside') {\n                w = mainImageData.w;\n                h = mainImageData.h;\n            } else {\n                w = mainImageData.largeWrapperW;\n                h = mainImageData.largeWrapperH;\n            }\n\n            mainImageData.largeImgInMagnifyLensWidth = Math.round(mainImageData.zoom * w);\n            mainImageData.largeImgInMagnifyLensHeight = Math.round(mainImageData.zoom * h);\n\n            mainImageData.lensW = Math.round(mainImageData.w / mainImageData.zoom);\n            mainImageData.lensH = Math.round(mainImageData.h / mainImageData.zoom);\n        }\n\n        function _init($box, options) {\n            var opts = {};\n\n            if (options.thumb === undefined) {\n                return false;\n            }\n\n            $thumb = $box.find(options.thumb);\n\n            if ($thumb.length) {\n                for (var key in options) {\n                    opts[key] = options[key];\n                }\n\n                opts.thumb = $thumb;\n                enabled = opts.enabled;\n\n                if (_toBoolean(enabled)) {\n\n                    $magnifierPreview.show().css('display', '');\n                    $magnifierPreview.addClass(MagnifyCls.magnifyHidden);\n                    set(opts);\n                } else {\n                    $magnifierPreview.empty().hide();\n                }\n            }\n\n            return that;\n        }\n\n        function hoverEvents(thumb) {\n            $(thumb).on('mouseover', function (e) {\n\n                if (showWrapper) {\n\n                    if (magnifierOptions.status !== 0) {\n                        onThumbLeave();\n                    }\n                    handleEvents(e);\n                    isOverThumb = inBounds;\n                }\n            }).trigger('mouseover');\n        }\n\n        function clickEvents(thumb) {\n            $(thumb).on('click', function (e) {\n\n                if (showWrapper) {\n                    if (!isOverThumb) {\n                        if (magnifierOptions.status !== 0) {\n                            onThumbLeave();\n                        }\n                        handleEvents(e);\n                        isOverThumb = true;\n                    }\n                }\n            });\n        }\n\n        function bindEvents(eType, thumb) {\n            switch (eType) {\n                case 'hover':\n                    hoverEvents(thumb);\n                    break;\n\n                case 'click':\n                    clickEvents(thumb);\n                    break;\n            }\n        }\n\n        function handleEvents(e) {\n            var src = e.target;\n\n            curIdx = src.id;\n            curThumb = src;\n\n            onThumbEnter(src);\n\n            setThumbData(curThumb, magnifierOptions);\n\n            pos.x = e.clientX;\n            pos.y = e.clientY;\n\n            getMousePos();\n            move();\n\n            var handler = magnifierOptions.onthumbenter;\n\n            if (handler !== null) {\n                handler({\n                    thumb: curThumb,\n                    lens: curLens,\n                    large: curLarge,\n                    x: pos.x,\n                    y: pos.y\n                });\n            }\n        }\n\n        function set(options) {\n            if (data[options.thumb.id] !== undefined) {\n                curThumb = options.thumb;\n\n                return false;\n            }\n\n            var thumbObj = new Image(),\n                largeObj = new Image(),\n                $thumb = options.thumb,\n                thumb = $thumb.get(0),\n                idx = thumb.id,\n                largeUrl,\n                largeWrapper = $(options.largeWrapper),\n                zoom = options.zoom || thumb.getAttribute('data-zoom') || gZoom,\n                zoomMin = options.zoomMin || gZoomMin,\n                zoomMax = options.zoomMax || gZoomMax,\n                mode = options.mode || thumb.getAttribute('data-mode') || gMode,\n                eventType = options.eventType || thumb.getAttribute('data-eventType') || gEventType,\n                onthumbenter = options.onthumbenter !== undefined ?\n                    options.onthumbenter\n                    : magnifierOptions.onthumbenter,\n                onthumbleave = options.onthumbleave !== undefined ?\n                    options.onthumbleave\n                    : magnifierOptions.onthumbleave,\n                onthumbmove = options.onthumbmove !== undefined ?\n                    options.onthumbmove\n                    : magnifierOptions.onthumbmove;\n\n            largeUrl = $thumb.data('original') || customUserOptions.full || $thumb.attr('src');\n\n            if (thumb.id === '') {\n                idx = thumb.id = 'magnifier-item-' + gId;\n                gId += 1;\n            }\n\n            createLens(thumb, idx);\n\n            if (options.width) {\n                largeWrapper.width(options.width);\n            }\n\n            if (options.height) {\n                largeWrapper.height(options.height);\n            }\n\n            if (options.top) {\n                if (typeof options.top == 'function') {\n                    var top = options.top() + 'px';\n                } else {\n                    var top = options.top + 'px';\n                }\n\n                if (largeWrapper.length) {\n                    largeWrapper[0].style.top = top.replace('%px', '%');\n                }\n            }\n\n            if (options.left) {\n                if (typeof options.left == 'function') {\n                    var left = options.left() + 'px';\n                } else {\n                    var left = options.left + 'px';\n                }\n\n                if (largeWrapper.length) {\n                    largeWrapper[0].style.left = left.replace('%px', '%');\n                }\n            }\n\n            data[idx] = {\n                zoom: zoom,\n                zoomMin: zoomMin,\n                zoomMax: zoomMax,\n                mode: mode,\n                eventType: eventType,\n                thumbCssClass: thumb.className,\n                zoomAttached: false,\n                status: 0,\n                largeUrl: largeUrl,\n                largeWrapperId: mode === 'outside' ? largeWrapper.attr('id') : null,\n                largeWrapperW: mode === 'outside' ? largeWrapper.width() : null,\n                largeWrapperH: mode === 'outside' ? largeWrapper.height() : null,\n                onthumbenter: onthumbenter,\n                onthumbleave: onthumbleave,\n                onthumbmove: onthumbmove\n            };\n\n            paddingX = ($thumb.parent().width() - $thumb.width()) / 2;\n            paddingY = ($thumb.parent().height() - $thumb.height()) / 2;\n\n            showWrapper = false;\n            $(thumbObj).on('load', function () {\n                data[idx].status = 1;\n\n                $(largeObj).on('load', function () {\n\n                    if (largeObj.width > largeWrapper.width() || largeObj.height > largeWrapper.height()) {\n                        showWrapper = true;\n                        bindEvents(eventType, thumb);\n                        data[idx].status = 2;\n                        if (largeObj.width > largeObj.height) {\n                            data[idx].zoom = largeObj.width / largeWrapper.width();\n                        } else {\n                            data[idx].zoom = largeObj.height / largeWrapper.height();\n                        }\n                        setThumbData(thumb, data[idx]);\n                        updateLensOnLoad(idx, thumb, largeObj, largeWrapper);\n                    }\n                });\n\n                largeObj.src = data[idx].largeUrl;\n            });\n\n            thumbObj.src = thumb.src;\n        }\n\n        /**\n         * Hide magnifier when mouse exceeds image bounds.\n         */\n        function onMouseLeave() {\n            onThumbLeave();\n            isOverThumb = false;\n            $magnifierPreview.addClass(MagnifyCls.magnifyHidden);\n        }\n\n        function onMousemove(e) {\n            pos.x = e.clientX;\n            pos.y = e.clientY;\n\n            getMousePos();\n\n            if (gEventType === 'hover') {\n                isOverThumb = inBounds;\n            }\n\n            if (inBounds && isOverThumb && gMode === 'outside') {\n                $magnifierPreview.removeClass(MagnifyCls.magnifyHidden);\n                move();\n            }\n        }\n\n        function onScroll() {\n            if (curThumb !== null) {\n                setThumbData(curThumb, magnifierOptions);\n            }\n        }\n\n        $(window).on('scroll', onScroll);\n        $(window).resize(function () {\n            _init($box, customUserOptions);\n        });\n\n        $box.on('mousemove', onMousemove);\n        $box.on('mouseleave', onMouseLeave);\n\n        _init($box, customUserOptions);\n    }\n}(jQuery));\n","Magento_Translation/js/i18n-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function () {\n    'use strict';\n\n    require.config({\n        config: {\n            'Magento_Ui/js/lib/knockout/bindings/i18n': {\n                inlineTranslation: true\n            }\n        }\n    });\n})();\n","Magento_Translation/js/add-class.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).addClass(config.class);\n    };\n});\n","Temando_Shipping/js/action/select-search-result.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'Magento_Checkout/js/model/url-builder',\n    'Magento_Customer/js/model/customer',\n    'mage/storage',\n    'Magento_Checkout/js/model/quote',\n    'Temando_Shipping/js/model/cache-service',\n    'Magento_Checkout/js/model/shipping-service'\n], function (urlBuilder, customer, storage, quote, cacheService, shippingService) {\n    'use strict';\n\n    return function (selectedValue) {\n\n        var url, urlParams, serviceUrl;\n        if (customer.isLoggedIn()) {\n            url = '/carts/mine/checkout-collection-point/select';\n            urlParams = {};\n        } else {\n            url = '/guest-carts/:cartId/checkout-collection-point/select';\n            urlParams = {\n                cartId: quote.getQuoteId()\n            };\n        }\n        var payload = {collectionPointId: selectedValue};\n        serviceUrl = urlBuilder.createUrl(url, urlParams);\n\n        shippingService.isLoading(true);\n\n        return storage.post(\n            serviceUrl,\n            JSON.stringify(payload)\n        ).success(\n            function (response) {\n                if (quote.shippingAddress()) {\n                    // if a shipping address was selected, clear shipping rates cache\n                    cacheService.invalidateCacheForAddress(quote.shippingAddress());\n                    quote.shippingAddress.valueHasMutated();\n                } else {\n                    // otherwise stop spinner, no new rates to display\n                    shippingService.isLoading(false);\n                }\n            }\n        ).fail(\n            function () {\n                shippingService.isLoading(false);\n            }\n        );\n    };\n});\n","Temando_Shipping/js/action/save-search-request.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'Magento_Checkout/js/model/url-builder',\n    'Magento_Customer/js/model/customer',\n    'mage/storage',\n    'Magento_Checkout/js/model/quote',\n    'Temando_Shipping/js/model/cache-service',\n    'Magento_Checkout/js/model/shipping-service',\n    'Temando_Shipping/js/model/collection-points'\n], function (urlBuilder, customer, storage, quote, cacheService, shippingService, collectionPoints) {\n    'use strict';\n\n    return function (postCode, countryId) {\n\n        shippingService.isLoading(true);\n        var url, urlParams, serviceUrl, payload;\n        if (customer.isLoggedIn()) {\n            url = '/carts/mine/collection-point/search-request';\n            urlParams = {};\n        } else {\n            url = '/guest-carts/:cartId/collection-point/search-request';\n            urlParams = {\n                cartId: quote.getQuoteId()\n            };\n        }\n        payload = {postcode: postCode, countryId: countryId};\n        serviceUrl = urlBuilder.createUrl(url, urlParams);\n\n        return storage.put(\n            serviceUrl,\n            JSON.stringify(payload)\n        ).success(\n            function (response) {\n                if (quote.shippingAddress()) {\n                    // if a shipping address was selected, clear shipping rates cache\n                    cacheService.invalidateCacheForAddress(quote.shippingAddress());\n                    quote.shippingAddress.valueHasMutated();\n                } else {\n                    // otherwise stop spinner, no new rates to display\n                    shippingService.isLoading(false);\n                }\n\n                var subscription = shippingService.getShippingRates().subscribe(function() {\n                    shippingService.isLoading(true);\n                    collectionPoints.reloadCheckoutData().always(function () {\n                        shippingService.isLoading(false);\n                    });\n                    subscription.dispose();\n                });\n\n\n            }\n        ).fail(\n            function () {\n                shippingService.isLoading(false);\n            }\n        );\n    };\n});\n","Temando_Shipping/js/action/select-delivery-option.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/url-builder',\n    'Magento_Customer/js/model/customer',\n    'mage/storage',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/model/shipping-service',\n    'Temando_Shipping/js/model/cache-service',\n    'Temando_Shipping/js/model/collection-points',\n    'Temando_Shipping/js/model/pickup-locations'\n], function (_, urlBuilder, customer, storage, quote, shippingService, cacheService, collectionPoints, pickupLocations) {\n    'use strict';\n    var deliveryOptions = {\n        clickAndCollect: pickupLocations,\n        toCollectionPoint: collectionPoints\n    };\n    return function (value) {\n        shippingService.isLoading(true);\n\n        var url, urlParams, serviceUrl;\n        if (customer.isLoggedIn()) {\n            url = '/carts/mine/delivery-option';\n            urlParams = {};\n        } else {\n            url = '/guest-carts/:cartId/delivery-option';\n            urlParams = {\n                cartId: quote.getQuoteId()\n            };\n        }\n        var payload = {cartId: quote.getQuoteId(), selectedOption: value};\n        serviceUrl = urlBuilder.createUrl(url, urlParams);\n\n        return storage.post(\n            serviceUrl,\n            JSON.stringify(payload)\n        ).success(function () {\n            if (quote.shippingAddress()) {\n                // if a shipping address was selected, clear shipping rates cache\n                cacheService.invalidateCacheForAddress(quote.shippingAddress());\n                quote.shippingAddress.valueHasMutated();\n            } else {\n                // otherwise stop spinner, no new rates to display\n                shippingService.isLoading(false);\n            }\n\n            var subscription = shippingService.getShippingRates().subscribe(function () {\n                _.each(deliveryOptions, function (option) {\n                    option.clear();\n                });\n                if (deliveryOptions[value]) {\n                    deliveryOptions[value].reloadCheckoutData();\n                }\n                subscription.dispose();\n            });\n        }).fail(function () {\n            shippingService.isLoading(false);\n        });\n    };\n});\n","Temando_Shipping/js/action/select-pickup-location.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'Magento_Checkout/js/model/url-builder',\n    'Magento_Customer/js/model/customer',\n    'mage/storage',\n    'Magento_Checkout/js/model/quote',\n    'Temando_Shipping/js/model/cache-service',\n    'Magento_Checkout/js/model/shipping-service'\n], function (urlBuilder, customer, storage, quote, cacheService, shippingService) {\n    'use strict';\n\n    return function (selectedValue) {\n\n        var url, urlParams, serviceUrl;\n        if (customer.isLoggedIn()) {\n            url = '/carts/mine/checkout-pickup-location/select';\n            urlParams = {};\n        } else {\n            url = '/guest-carts/:cartId/checkout-pickup-location/select';\n            urlParams = {\n                cartId: quote.getQuoteId()\n            };\n        }\n        var payload = {pickupLocationId: selectedValue};\n        serviceUrl = urlBuilder.createUrl(url, urlParams);\n\n        shippingService.isLoading(true);\n\n        return storage.post(\n            serviceUrl,\n            JSON.stringify(payload)\n        ).success(\n            function (response) {\n                if (quote.shippingAddress()) {\n                    // if a shipping address was selected, clear shipping rates cache\n                    cacheService.invalidateCacheForAddress(quote.shippingAddress());\n                    quote.shippingAddress.valueHasMutated();\n                } else {\n                    // otherwise stop spinner, no new rates to display\n                    shippingService.isLoading(false);\n                }\n            }\n        ).fail(\n            function () {\n                shippingService.isLoading(false);\n            }\n        );\n    };\n});\n","Temando_Shipping/js/action/save-service-selection.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'underscore',\n    'Magento_Checkout/js/model/url-builder',\n    'Magento_Customer/js/model/customer',\n    'mage/storage',\n    'Magento_Checkout/js/model/quote',\n    'Temando_Shipping/js/model/cache-service',\n    'Magento_Checkout/js/model/shipping-service'\n], function (_, urlBuilder, customer, storage, quote, cacheService, shippingService) {\n    'use strict';\n\n    return function (serviceSelection) {\n\n        shippingService.isLoading(true);\n        var url, urlParams, serviceUrl, payload;\n        if (customer.isLoggedIn()) {\n            url = '/carts/mine/checkout-fields';\n            urlParams = {};\n        } else {\n            url = '/guest-carts/:cartId/checkout-fields';\n            urlParams = {\n                cartId: quote.getQuoteId()\n            };\n        }\n\n        var services = [];\n        _.each(serviceSelection, function (service) {\n            services.push(\n                {\n                    attributeCode: service.id,\n                    value: service.value()\n                }\n            );\n        });\n\n\n        payload = {serviceSelection: services};\n        serviceUrl = urlBuilder.createUrl(url, urlParams);\n\n        return storage.post(\n            serviceUrl,\n            JSON.stringify(payload)\n        ).success(\n            function (response) {\n                if (quote.shippingAddress()) {\n                    // if a shipping address was selected, clear shipping rates cache\n                    cacheService.invalidateCacheForAddress(quote.shippingAddress());\n                    quote.shippingAddress.valueHasMutated();\n                } else {\n                    // otherwise stop spinner, no new rates to display\n                    shippingService.isLoading(false);\n                }\n            }\n        ).fail(\n            function () {\n                shippingService.isLoading(false);\n            }\n        );\n    };\n});\n","Temando_Shipping/js/view/shipping-rates-validation/temando.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    'temandoShippingRatesValidator',\n    'temandoShippingRatesValidationRules'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    temandoShippingRatesValidator,\n    temandoShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('temando', temandoShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('temando', temandoShippingRatesValidationRules);\n\n    return Component;\n});\n","Temando_Shipping/js/view/checkout/shipping-information/address-renderer/shipping.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'underscore',\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'Temando_Shipping/js/model/collection-points',\n    'Temando_Shipping/js/model/pickup-locations'\n], function (_, Component, customerData, collectionPoints, pickupLocations) {\n    'use strict';\n\n    var countryData = customerData.get('directory-data');\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Checkout/shipping-information/address-renderer/default'\n        },\n        collectionPoints: collectionPoints,\n        pickupLocations: pickupLocations,\n\n        /**\n         * @param {*} countryId\n         * @return {String}\n         */\n        getCountryName: function (countryId) {\n            return countryData()[countryId] != undefined ? countryData()[countryId].name : ''; //eslint-disable-line\n        },\n\n        getRegionNameByCode: function (countryId, regionCode) {\n            var result = regionCode;\n            var countryRegions = countryData()[countryId].regions || {};\n\n            if (_.size(countryRegions) > 0) {\n                var region = _.filter(countryRegions, (function (element) {\n                        return element.code === regionCode;\n                    })\n                );\n\n                if (region.length > 0) {\n                    result = region[0].name;\n                }\n            }\n\n            return result;\n        },\n\n        getTemplate: function () {\n            var collectionPoint = collectionPoints.getSelectedCollectionPoint();\n            if (collectionPoint) {\n                return 'Temando_Shipping/checkout/shipping/address-renderer/collection-point';\n            }\n            var pickupLocation = pickupLocations.getSelectedPickupLocation();\n            if (pickupLocation) {\n                return 'Temando_Shipping/checkout/shipping/address-renderer/pickup-location';\n            }\n            // handle other specific adresses here\n            return this.template;\n        }\n    });\n});\n","Temando_Shipping/js/view/checkout/shipping/pickup-locations-form.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'underscore',\n    'uiComponent',\n    'ko',\n    'Temando_Shipping/js/model/pickup-locations',\n    'Temando_Shipping/js/action/select-pickup-location'\n], function (_, Component, ko, pickupLocations, selectPickupLocationAction) {\n    'use strict';\n\n    var selectedPickupLocation = ko.observable(false),\n        readSelected = function () {\n            if (selectedPickupLocation()) {\n                return selectedPickupLocation();\n            } else {\n                var selected = pickupLocations.getPickupLocations().find(function (element) {\n                    return element.selected;\n                });\n\n                return selected ? selected.pickup_location_id : false;\n            }\n        },\n        writeSelected = function (value) {\n            selectPickupLocationAction(value);\n            pickupLocations.selectPickupLocation(value);\n        };\n\n    return Component.extend({\n        defaults: {\n            template: 'Temando_Shipping/checkout/shipping/delivery-options'\n        },\n        selectedPickupLocation: selectedPickupLocation,\n        selected: ko.pureComputed({\n            read: readSelected,\n            write: writeSelected,\n            owner: this\n        }),\n\n        getPickupLocations: function () {\n            return pickupLocations.getPickupLocations();\n        },\n\n        getMessage: function () {\n            return pickupLocations.getMessage();\n        },\n\n        hasNoResult: function () {\n            var result = false;\n            if (this.getPickupLocations().length < 1) {\n                result = true;\n            }\n            return result;\n        }\n    });\n});\n","Temando_Shipping/js/view/checkout/shipping/collection-points-form.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'underscore',\n    'uiComponent',\n    'ko',\n    'Temando_Shipping/js/model/collection-points',\n    'Temando_Shipping/js/action/save-search-request',\n    'Temando_Shipping/js/action/select-search-result'\n], function (_, Component, ko, collectionPoints, searchAction, selectCollectionPointAction) {\n    'use strict';\n\n    var selectedCollectionPoint = ko.observable(false),\n        initializeZipCode =  collectionPoints.getSearchRequestPostCode(),\n        initializeCountryCode = collectionPoints.getSearchRequestCountryCode(),\n        readSelected = function () {\n            if (selectedCollectionPoint()) {\n                return selectedCollectionPoint();\n            } else {\n                var selected = collectionPoints.getCollectionPoints().find(function (element) {\n                    return element.selected;\n                });\n\n                return selected ? selected.collection_point_id : false;\n            }\n        },\n        writeSelected = function (value) {\n            selectCollectionPointAction(value);\n            collectionPoints.selectCollectionPoint(value);\n        };\n\n    return Component.extend({\n        defaults: {\n            template: 'Temando_Shipping/checkout/shipping/delivery-options'\n        },\n        selectedCollectionPoint: selectedCollectionPoint,\n        selected: ko.pureComputed({\n            read: readSelected,\n            write: writeSelected,\n            owner: this\n        }),\n        zipCodeError: ko.observable(''),\n        zipValue: ko.observable(initializeZipCode),\n        countryValue: ko.observable(initializeCountryCode),\n\n        getCountryData: function () {\n            var result = [];\n            var countryData = window.checkoutConfig['ts-cp-countries'];\n            _.each(countryData, function (country) {\n                result.push({\n                    'countryCode': country.value,\n                    'countryName': country.label\n                });\n            });\n\n            return result;\n        },\n\n        getCollectionPoints: function () {\n            return collectionPoints.getCollectionPoints();\n        },\n\n        getMessage: function () {\n            return collectionPoints.getMessage();\n        },\n\n        hasNoResult: function () {\n            var result = false;\n            if (collectionPoints.getSearchRequestPostCode() && this.getCollectionPoints().length < 1) {\n                result = true;\n            }\n            return result;\n        },\n\n        /**\n         * @return {null}\n         */\n        submitForm: function () {\n            if (this.zipValue().trim().length) {\n                // Call request for saving the fields into a table\n                searchAction(this.zipValue(), this.countryValue());\n                this.zipCodeError('');\n            } else {\n                this.zipCodeError('This is a required field.');\n            }\n        }\n    });\n});\n","Temando_Shipping/js/view/checkout/shipping/delivery-options.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'ko',\n    'uiComponent',\n    'temandoDeliveryOptions',\n    'Temando_Shipping/js/action/select-delivery-option'\n], function (ko, Component, deliveryOptions, selectDeliveryOption) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Temando_Shipping/checkout/shipping/delivery-options'\n        },\n\n        deliveryOptions: ko.observableArray(window.checkoutConfig['delivery-options']),\n        radioSelectedOptionValue: deliveryOptions.selected,\n        collectionPointsVisible: ko.computed(function () {\n            return deliveryOptions.selected() === 'toCollectionPoint';\n        }),\n        clickAndCollectVisible: ko.computed(function () {\n            return deliveryOptions.selected() === 'clickAndCollect';\n        }),\n\n        initialize: function () {\n            this._super();\n            var self = this;\n            self.radioSelectedOptionValue.subscribe(function (value) {\n                selectDeliveryOption(value);\n            });\n        }\n    });\n});\n","Temando_Shipping/js/view/checkout/shipping/checkout-fields.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'underscore',\n    'uiComponent',\n    'ko',\n    'temandoCheckoutFieldsDefinition',\n    'Magento_Checkout/js/model/quote',\n    'temandoDeliveryOptions',\n    'Temando_Shipping/js/action/save-service-selection'\n], function (_, Component, ko, fieldsDefinition, quote, deliveryOptions, saveServiceSelection) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Temando_Shipping/checkout/shipping/checkout-fields',\n            fields: []\n        },\n        checkoutFieldsVisible: deliveryOptions.isToAddressSelected,\n\n        /**\n         *\n         * @returns {*} Array of fields with observable values\n         */\n        getFields: function () {\n            if (_.isEmpty(this.fields)) {\n                _.each(fieldsDefinition.getFields(), function (fieldDefinition) {\n                    // init field for template rendering\n                    var field = {\n                        id: fieldDefinition.id,\n                        label: fieldDefinition.label,\n                        type: fieldDefinition.type,\n                        options: fieldDefinition.options,\n                        value: ko.observable(fieldDefinition.value)\n                    };\n\n                    field.value.subscribe(function (fieldValue) {\n                        // on value change, update section data and trigger rate request\n                        fieldsDefinition.updateFieldValue(fieldDefinition.id, fieldValue);\n\n                        saveServiceSelection(this.fields);\n                    }, this);\n                    // push field definition to component property for template rendering\n                    this.fields.push(field);\n                }, this);\n            }\n\n            return this.fields;\n        }\n    });\n});\n","Temando_Shipping/js/model/fields-definition.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'underscore',\n    'ko',\n    'Magento_Customer/js/customer-data'\n], function (_, ko, customerData) {\n    'use strict';\n\n    var cacheKey = 'checkout-fields';\n\n    return {\n        getFields: function () {\n            var sectionData = customerData.get(cacheKey);\n\n            _.each(sectionData().fields, function (field) {\n                if ((field.value === undefined) && field.defaultValue) {\n                    field.value = field.defaultValue;\n                }\n            });\n\n            return sectionData().fields;\n        },\n\n        updateFieldValue: function (fieldId, fieldValue) {\n            var sectionData = customerData.get(cacheKey);\n\n            if (fieldValue === undefined) {\n                fieldValue = '';\n            }\n\n            _.each(sectionData().fields, function (field) {\n                if (field.id === fieldId) {\n                    field.value = fieldValue;\n                }\n            });\n\n            customerData.set(cacheKey, sectionData());\n        }\n    };\n});\n","Temando_Shipping/js/model/cache-service.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'Magento_Checkout/js/model/shipping-rate-registry'\n], function (rateRegistry) {\n    'use strict';\n\n    return {\n        invalidateCacheForAddress: function(address) {\n            var cacheKey = address.getCacheKey();\n            rateRegistry.set(cacheKey, null);\n        }\n    };\n});\n","Temando_Shipping/js/model/pickup-locations.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'mage/translate'\n], function (_, $, customerData) {\n    'use strict';\n\n    var cacheKey = 'pickup-location-result';\n    var sectionData = customerData.get(cacheKey);\n\n\n    return {\n        getPickupLocations: function () {\n            return sectionData()['pickup-locations'] || [];\n        },\n\n        getMessage: function () {\n            var locations = this.getPickupLocations();\n            var searchRequest = this.getSearchRequest();\n            var locationsCount = _.size(locations);\n\n            if (_.isEmpty(searchRequest)) {\n                return $.mage.__('Please wait.');\n            } else if (_.isEmpty(locations) && _.size(searchRequest) > 0) {\n                return $.mage.__('No pickup locations found.');\n            } else {\n                return $.mage.__('There were %1 results for your search.').replace('%1', locationsCount);\n            }\n        },\n\n        getSearchRequest: function () {\n            if (_.size(sectionData()['search-request']) > 0) {\n                return sectionData()['search-request'];\n            }\n            return false;\n        },\n\n        selectPickupLocation: function (pickupLocationId) {\n            var pickupLocations = this.getPickupLocations();\n            var searchRequest = this.getSearchRequest();\n\n            _.each(pickupLocations, function (pickupLocation) {\n                pickupLocation.selected = (pickupLocation.pickup_location_id === pickupLocationId);\n            });\n\n            customerData.set(cacheKey, {\n                'pickup-locations': pickupLocations,\n                'search-request': searchRequest\n            });\n        },\n\n        getSelectedPickupLocation: function () {\n            var locations = this.getPickupLocations();\n            var selectedLocation = locations.filter(function (element) {\n                return element.selected;\n            });\n\n            if (selectedLocation.length === 0) {\n                return false;\n            } else {\n                return selectedLocation;\n            }\n        },\n\n        reloadCheckoutData: function () {\n            return customerData.reload([cacheKey]);\n        },\n\n        clear: function() {\n            customerData.set(cacheKey, {\n                'pickup-locations': [],\n                'search-request': {}\n            });\n        }\n    };\n});\n","Temando_Shipping/js/model/delivery-options.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'ko',\n    'Temando_Shipping/js/model/collection-points',\n    'Temando_Shipping/js/model/pickup-locations'\n], function (ko, collectionPoints, pickupLocations) {\n    'use strict';\n\n\n    var userValue = ko.observable('');\n    var selected = ko.pureComputed({\n        read: function() {\n            if (userValue() === '') {\n                if (collectionPoints.getSearchRequest()) {\n                   return  'toCollectionPoint';\n                }\n                if (pickupLocations.getSearchRequest()) {\n                    return  'clickAndCollect';\n                }\n                return 'toAddress';\n            } else {\n                return userValue();\n            }\n        },\n        write: function(value) {\n            userValue(value);\n        }\n    });\n    var collectionPointSelected = ko.computed(function () {\n        return (selected() === 'toCollectionPoint');\n    });\n    var toAddressSelected = ko.computed(function () {\n        return (selected() === 'toAddress');\n    });\n\n    var clickAndCollectSelected = ko.computed(function () {\n        return (selected() === 'clickAndCollect');\n    });\n\n    return {\n        selected: selected,\n        isCollectionPointSelected: collectionPointSelected,\n        isToAddressSelected: toAddressSelected\n    };\n});\n","Temando_Shipping/js/model/url.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\ndefine([], function () {\n    'use strict';\n\n    var pickupForwardUrlTemplate = '--id--';\n\n    return {\n        /**\n         * @param {String} urlTemplate\n         */\n        setPickupForwardUrlTemplate: function (urlTemplate) {\n            pickupForwardUrlTemplate = urlTemplate;\n        },\n\n        /**\n         * @param {String} pickupId\n         */\n        buildPickupForwardUrl: function (pickupId) {\n            return pickupForwardUrlTemplate.replace('--id--', pickupId);\n        }\n    };\n});\n","Temando_Shipping/js/model/collection-points.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'Magento_Customer/js/customer-data',\n    'mage/translate'\n], function (_,$,customerData) {\n    'use strict';\n\n    var cacheKey = 'collection-point-result';\n    var sectionData = customerData.get(cacheKey);\n\n\n    return {\n        getCollectionPoints: function () {\n            return sectionData()['collection-points'] || [];\n        },\n\n        getMessage: function () {\n            var collectionPoints = this.getCollectionPoints();\n            var searchRequest = this.getSearchRequest();\n            var cpCount = _.size(collectionPoints);\n\n            if (_.isEmpty(searchRequest) || searchRequest.pending === true) {\n                return $.mage.__('Enter country and postal code to search for a collection point.');\n            } else if (_.isEmpty(collectionPoints) && _.size(searchRequest) > 0) {\n                return $.mage.__('No collection points found.');\n            } else {\n                return $.mage.__('There were %1 results for your search.').replace('%1', cpCount);\n            }\n        },\n\n        getSearchRequest: function () {\n            if (_.size(sectionData()['search-request']) > 0) {\n                return sectionData()['search-request'];\n            }\n            return false;\n        },\n\n        getSearchRequestCountryCode: function () {\n            return this.getSearchRequest().country_id || '';\n        },\n\n        getSearchRequestPostCode: function () {\n            return this.getSearchRequest().postcode || '';\n        },\n\n        selectCollectionPoint: function (collectionPointId) {\n            var collectionPoints = this.getCollectionPoints();\n            var searchRequest = this.getSearchRequest();\n\n            _.each(collectionPoints, function (collectionPoint) {\n                collectionPoint.selected = (collectionPoint.collection_point_id === collectionPointId);\n            });\n\n            customerData.set(cacheKey, {\n                'collection-points': collectionPoints,\n                'search-request': searchRequest\n            });\n        },\n\n        getSelectedCollectionPoint: function () {\n            var collectionPoints = this.getCollectionPoints();\n            var selectedPoint = collectionPoints.filter(function (element) {\n                return element.selected;\n            });\n\n            if (selectedPoint.length === 0) {\n                return false;\n            } else {\n                return selectedPoint;\n            }\n        },\n\n        reloadCheckoutData: function () {\n            return customerData.reload([cacheKey]);\n        },\n\n        clear: function() {\n            customerData.set(cacheKey, {\n                'collection-points': [],\n                'search-request': {}\n            });\n        }\n    };\n});\n","Temando_Shipping/js/model/shipping-rates-validation-rules/temando.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'lastname': {\n                    'required': false\n                },\n                'postcode': {\n                    'required': false\n                },\n                'city': {\n                    'required': false\n                },\n                'country_id': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Temando_Shipping/js/model/shipping-rates-validator/temando.js":"/**\n * Refer to LICENSE.txt distributed with the Temando Shipping module for notice of license\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    'temandoShippingRatesValidationRules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_Tinymce3/tinymce3Adapter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated use lib/web/mage/adminhtml/wysiwyg/tiny_mce/tinymce4Adapter.js instead\n */\n/* global varienGlobalEvents, tinyMceEditors, MediabrowserUtility, closeEditorPopup, Base64 */\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'underscore',\n    'tinymceDeprecated',\n    'mage/adminhtml/wysiwyg/tiny_mce/html5-schema',\n    'mage/translate',\n    'prototype',\n    'mage/adminhtml/events'\n], function (jQuery, _, tinyMCE3, html5Schema) {\n\n    var tinyMce3Wysiwyg = Class.create();\n\n    tinyMce3Wysiwyg.prototype = {\n        mediaBrowserOpener: null,\n        mediaBrowserTargetElementId: null,\n\n        /**\n         * @param {*} htmlId\n         * @param {Object} config\n         */\n        initialize: function (htmlId, config) {\n            if (config.baseStaticUrl && config.baseStaticDefaultUrl) {\n                tinyMCE3.baseURL = tinyMCE3.baseURL.replace(config.baseStaticUrl, config.baseStaticDefaultUrl);\n            }\n\n            this.id = htmlId;\n            this.config = config;\n            this.schema = config.schema || html5Schema;\n\n            _.bindAll(\n                this,\n                'beforeSetContent',\n                'saveContent',\n                'onChangeContent',\n                'openFileBrowser',\n                'updateTextArea',\n                'removeEvents'\n            );\n\n            varienGlobalEvents.attachEventHandler('tinymceChange', this.onChangeContent);\n            varienGlobalEvents.attachEventHandler('tinymceBeforeSetContent', this.beforeSetContent);\n            varienGlobalEvents.attachEventHandler('tinymceSetContent', this.updateTextArea);\n            varienGlobalEvents.attachEventHandler('tinymceSaveContent', this.saveContent);\n\n            if (typeof tinyMceEditors == 'undefined') {\n                window.tinyMceEditors = $H({});\n            }\n\n            tinyMceEditors.set(this.id, this);\n        },\n\n        /**\n         * @param {*} mode\n         */\n        setup: function (mode) {\n            if (this.config['widget_plugin_src']) {\n                tinyMCE3.PluginManager.load('magentowidget', 'plugins/magentowidget/editor_plugin.js');\n            }\n\n            if (this.config.plugins) {\n                this.config.plugins.each(function (plugin) {\n                    tinyMCE3.PluginManager.load(plugin.name, plugin.src);\n                });\n            }\n\n            if (jQuery.isReady) {\n                tinyMCE3.dom.Event.domLoaded = true;\n            }\n\n            tinyMCE3.init(this.getSettings(mode));\n        },\n\n        /**\n         * Remove events from instance.\n         *\n         * @param {String} wysiwygId\n         */\n        removeEvents: function (wysiwygId) {\n            var editor = tinyMceEditors.get(wysiwygId);\n\n            varienGlobalEvents.removeEventHandler('tinymceChange', editor.onChangeContent);\n        },\n\n        /**\n         * @param {*} mode\n         * @return {Object}\n         */\n        getSettings: function (mode) {\n            var plugins = 'inlinepopups,safari,pagebreak,style,layer,table,advhr,advimage,emotions,iespell,media,searchreplace,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,noneditable', //eslint-disable-line\n                self = this,\n                magentoPluginsOptions, magentoPlugins, settings;\n\n            if (this.config['widget_plugin_src']) {\n                plugins = 'magentowidget,' + plugins;\n            }\n\n            magentoPluginsOptions = $H({});\n            magentoPlugins = '';\n\n            if (this.config.plugins) {\n                this.config.plugins.each(function (plugin) {\n                    magentoPlugins = plugin.name + ',' + magentoPlugins;\n                    magentoPluginsOptions.set(plugin.name, plugin.options);\n                });\n\n                if (magentoPlugins) {\n                    plugins = '-' + magentoPlugins + plugins;\n                }\n            }\n\n            settings = {\n                'entity_encoding': 'raw',\n                mode: mode != undefined ? mode : 'none', //eslint-disable-line eqeqeq\n                elements: this.id,\n                theme: 'advanced',\n                plugins: plugins,\n                'theme_advanced_buttons1': magentoPlugins + 'magentowidget,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,styleselect,formatselect,fontselect,fontsizeselect', //eslint-disable-line max-len\n                'theme_advanced_buttons2': 'cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,|,forecolor,backcolor', //eslint-disable-line max-len\n                'theme_advanced_buttons3': 'tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,iespell,media,advhr,|,ltr,rtl,|,fullscreen', //eslint-disable-line max-len\n                'theme_advanced_buttons4': 'insertlayer,moveforward,movebackward,absolute,|,styleprops,|,cite,abbr,acronym,del,ins,attribs,|,visualchars,nonbreaking,pagebreak', //eslint-disable-line max-len\n                'theme_advanced_toolbar_location': 'top',\n                'theme_advanced_toolbar_align': 'left',\n                'theme_advanced_statusbar_location': 'bottom',\n                'valid_elements': this.schema.validElements.join(','),\n                'valid_children': this.schema.validChildren.join(','),\n                'theme_advanced_resizing': true,\n                'theme_advanced_resize_horizontal': false,\n                'convert_urls': false,\n                'relative_urls': false,\n                'content_css': this.config['content_css'],\n                'custom_popup_css': this.config['popup_css'],\n                'magentowidget_url': this.config['widget_window_url'],\n                'noneditable_leave_contenteditable': true,\n                magentoPluginsOptions: magentoPluginsOptions,\n                doctype: '<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">', //eslint-disable-line max-len\n\n                /**\n                 * @param {Object} ed\n                 */\n                setup: function (ed) {\n                    var onChange;\n\n                    ed.onPreInit.add(self.onEditorPreInit.bind(self));\n\n                    ed.onInit.add(self.onEditorInit.bind(self));\n\n                    ed.onInit.add(function (editor) {\n                        varienGlobalEvents.fireEvent('wysiwygEditorInitialized', editor);\n                    });\n\n                    ed.onSubmit.add(function (edi, e) {\n                        varienGlobalEvents.fireEvent('tinymceSubmit', e);\n                    });\n\n                    ed.onPaste.add(function (edi, e, o) {\n                        varienGlobalEvents.fireEvent('tinymcePaste', o);\n                    });\n\n                    ed.onBeforeSetContent.add(function (edi, o) {\n                        varienGlobalEvents.fireEvent('tinymceBeforeSetContent', o);\n                    });\n\n                    ed.onSetContent.add(function (edi, o) {\n                        varienGlobalEvents.fireEvent('tinymceSetContent', o);\n                    });\n\n                    ed.onSaveContent.add(function (edi, o) {\n                        varienGlobalEvents.fireEvent('tinymceSaveContent', o);\n                    });\n\n                    /**\n                     * @param {*} edi\n                     * @param {*} l\n                     */\n                    onChange = function (edi, l) {\n                        varienGlobalEvents.fireEvent('tinymceChange', l);\n                    };\n\n                    ed.onChange.add(onChange);\n                    ed.onKeyUp.add(onChange);\n\n                    ed.onExecCommand.add(function (edi, cmd) {\n                        varienGlobalEvents.fireEvent('tinymceExecCommand', cmd);\n                    });\n                }\n            };\n\n            // jscs:disable requireDotNotation\n            if (!settings['style_formats']) {\n                settings['theme_advanced_buttons1'] = settings['theme_advanced_buttons1'].replace(',styleselect', '');\n            }\n\n            // Set the document base URL\n            if (this.config['document_base_url']) {\n                settings['document_base_url'] = this.config['document_base_url'];\n            }\n\n            if (this.config['files_browser_window_url']) {\n\n                /**\n                 * @param {*} fieldName\n                 * @param {*} url\n                 * @param {*} objectType\n                 * @param {*} w\n                 */\n                settings['file_browser_callback'] = function (fieldName, url, objectType, w) {\n                    varienGlobalEvents.fireEvent('open_browser_callback', {\n                        win: w,\n                        type: objectType,\n                        field: fieldName\n                    });\n                };\n            }\n            // jscs:enable requireDotNotation\n\n            if (this.config.width) {\n                settings.width = this.config.width;\n            }\n\n            if (this.config.height) {\n                settings.height = this.config.height;\n            }\n\n            if (this.config.settings) {\n                Object.extend(settings, this.config.settings);\n            }\n\n            return settings;\n        },\n\n        /**\n         * @param {Object} editor\n         */\n        applySchema: function (editor) {\n            var schema      = editor.schema,\n                schemaData  = this.schema,\n                makeMap     = tinyMCE3.makeMap;\n\n            jQuery.extend(true, {\n                nonEmpty: schema.getNonEmptyElements(),\n                boolAttrs: schema.getBoolAttrs(),\n                whiteSpace: schema.getWhiteSpaceElements(),\n                shortEnded: schema.getShortEndedElements(),\n                selfClosing: schema.getSelfClosingElements(),\n                blockElements: schema.getBlockElements()\n            }, {\n                nonEmpty: makeMap(schemaData.nonEmpty),\n                boolAttrs: makeMap(schemaData.boolAttrs),\n                whiteSpace: makeMap(schemaData.whiteSpace),\n                shortEnded: makeMap(schemaData.shortEnded),\n                selfClosing: makeMap(schemaData.selfClosing),\n                blockElements: makeMap(schemaData.blockElements)\n            });\n        },\n\n        /**\n         * @param {String} id\n         */\n        get: function (id) {\n            return tinyMCE3.get(id);\n        },\n\n        /**\n         * @return {String|null}\n         */\n        getId: function () {\n            return this.id || (this.activeEditor() ? this.activeEditor().id : null) || tinyMceEditors.values()[0].id;\n        },\n\n        /**\n         * @return {Object}\n         */\n        activeEditor: function () {\n            return tinyMCE3.activeEditor;\n        },\n\n        /**\n         * Insert content to active editor.\n         *\n         * @param {String} content\n         * @param {Boolean} ui\n         */\n        insertContent: function (content, ui) {\n            this.activeEditor().execCommand('mceInsertContent', typeof ui !== 'undefined' ? ui : false, content);\n        },\n\n        /**\n         * Set the status of the toolbar to disabled or enabled (true for enabled, false for disabled)\n         * @param {Boolean} enabled\n         */\n        setToolbarStatus: function (enabled) {\n            _.each(this.activeEditor().controlManager.controls, function (property, index, controls) {\n                controls[property.id].setDisabled(!enabled);\n            });\n        },\n\n        /**\n         * Set the status of the editor and toolbar\n         *\n         * @param {Boolean} enabled\n         */\n        setEnabledStatus: function (enabled) {\n            if (this.activeEditor()) {\n                this.activeEditor().getBody().setAttribute('contenteditable', enabled);\n                this.activeEditor().readonly = !enabled;\n                this.setToolbarStatus(enabled);\n            }\n\n            if (enabled) {\n                this.getTextArea().removeProp('disabled');\n            } else {\n                this.getTextArea().prop('disabled', 'disabled');\n            }\n        },\n\n        /**\n         * Set caret location in WYSIWYG editor.\n         *\n         * @param {Object} targetElement\n         */\n        setCaretOnElement: function (targetElement) {\n            this.activeEditor().selection.select(targetElement);\n            this.activeEditor().selection.collapse();\n        },\n\n        /**\n         * @param {Object} o\n         */\n        openFileBrowser: function (o) {\n            var typeTitle = this.translate('Select Images'),\n                storeId = this.config['store_id'] !== null ? this.config['store_id'] : 0,\n                frameDialog = jQuery(o.win.frameElement).parents('[role=\"dialog\"]'),\n                wUrl = this.config['files_browser_window_url'] +\n                    'target_element_id/' + this.getId() + '/' +\n                    'store/' + storeId + '/';\n\n            this.mediaBrowserOpener = o.win;\n            this.mediaBrowserTargetElementId = o.field;\n\n            if (typeof o.type != 'undefined' && o.type != '') { //eslint-disable-line eqeqeq\n                wUrl = wUrl + 'type/' + o.type + '/';\n            }\n\n            frameDialog.hide();\n            jQuery('#mceModalBlocker').hide();\n\n            require(['mage/adminhtml/browser'], function () {\n                MediabrowserUtility.openDialog(wUrl, false, false, typeTitle, {\n                    /**\n                     * Closed.\n                     */\n                    closed: function () {\n                        frameDialog.show();\n                        jQuery('#mceModalBlocker').show();\n                    }\n                });\n            });\n        },\n\n        /**\n         * @param {String} string\n         * @return {String}\n         */\n        translate: function (string) {\n            return jQuery.mage.__ ? jQuery.mage.__(string) : string;\n        },\n\n        /**\n         * @return {null}\n         */\n        getMediaBrowserOpener: function () {\n            return this.mediaBrowserOpener;\n        },\n\n        /**\n         * @return {null}\n         */\n        getMediaBrowserTargetElementId: function () {\n            return this.mediaBrowserTargetElementId;\n        },\n\n        /**\n         * @return {jQuery|*|HTMLElement}\n         */\n        getToggleButton: function () {\n            return $('toggle' + this.getId());\n        },\n\n        /**\n         * Get plugins button.\n         */\n        getPluginButtons: function () {\n            return jQuery('#buttons' + this.getId() + ' > button.plugin');\n        },\n\n        /**\n         * @param {*} mode\n         * @return {wysiwygSetup}\n         */\n        turnOn: function (mode) {\n            this.closePopups();\n\n            this.setup(mode);\n\n            tinyMCE3.execCommand('mceAddControl', false, this.getId());\n\n            this.getPluginButtons().hide();\n\n            return this;\n        },\n\n        /**\n         * @return {wysiwygSetup}\n         */\n        turnOff: function () {\n            this.closePopups();\n\n            tinyMCE3.execCommand('mceRemoveControl', false, this.getId());\n\n            this.getPluginButtons().show();\n\n            return this;\n        },\n\n        /**\n         * Close popups.\n         */\n        closePopups: function () {\n            if (typeof closeEditorPopup == 'function') {\n                // close all popups to avoid problems with updating parent content area\n                closeEditorPopup('widget_window' + this.getId());\n                closeEditorPopup('browser_window' + this.getId());\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        toggle: function () {\n            if (!tinyMCE3.get(this.getId())) {\n                this.turnOn();\n\n                return true;\n            }\n            this.turnOff();\n\n            return false;\n        },\n\n        /**\n         * Editor pre-initialise event handler.\n         */\n        onEditorPreInit: function (editor) {\n            this.applySchema(editor);\n        },\n\n        /**\n         * @deprecated\n         */\n        onEditorInit: function () {},\n\n        /**\n         * On form validation.\n         */\n        onFormValidation: function () {\n            if (tinyMCE3.get(this.getId())) {\n                $(this.getId()).value = tinyMCE3.get(this.getId()).getContent();\n            }\n        },\n\n        /**\n         * On change content.\n         */\n        onChangeContent: function () {\n            // Add \"changed\" to tab class if it exists\n            var tab;\n\n            this.updateTextArea();\n\n            if (this.config['tab_id']) {\n                tab = $$('a[id$=' + this.config['tab_id'] + ']')[0];\n\n                if ($(tab) != undefined && $(tab).hasClassName('tab-item-link')) { //eslint-disable-line eqeqeq\n                    $(tab).addClassName('changed');\n                }\n            }\n        },\n\n        /**\n         * Retrieve directives URL with substituted directive value.\n         *\n         * @param {String} directive\n         */\n        makeDirectiveUrl: function (directive) {\n            return this.config['directives_url']\n                .replace(/directive/, 'directive/___directive/' + directive)\n                .replace(/\\/$/, '');\n        },\n\n        /**\n         * Convert {{directive}} style attributes syntax to absolute URLs\n         * @param {Object} content\n         * @return {*}\n         */\n        encodeDirectives: function (content) {\n            // collect all HTML tags with attributes that contain directives\n            return content.gsub(/<([a-z0-9\\-\\_]+[^>]+?)([a-z0-9\\-\\_]+=\"[^\"]*?\\{\\{.+?\\}\\}.*?\".*?)>/i, function (match) {\n                var attributesString = match[2],\n                    decodedDirectiveString;\n\n                // process tag attributes string\n                attributesString = attributesString.gsub(/([a-z0-9\\-\\_]+)=\"(.*?)(\\{\\{.+?\\}\\})(.*?)\"/i, function (m) {\n                    decodedDirectiveString = encodeURIComponent(Base64.mageEncode(m[3].replace(/&quot;/g, '\"')));\n\n                    return m[1] + '=\"' + m[2] + this.makeDirectiveUrl(decodedDirectiveString) + m[4] + '\"';\n                }.bind(this));\n\n                return '<' + match[1] + attributesString + '>';\n            }.bind(this));\n        },\n\n        /**\n         * @param {Object} content\n         * @return {*}\n         */\n        encodeWidgets: function (content) {\n            return content.gsub(/\\{\\{widget(.*?)\\}\\}/i, function (match) {\n                var attributes = this.parseAttributesString(match[1]),\n                    imageSrc,\n                    imageHtml;\n\n                if (attributes.type) {\n                    attributes.type = attributes.type.replace(/\\\\\\\\/g, '\\\\');\n                    imageSrc = this.config['widget_placeholders'][attributes.type];\n\n                    imageHtml = '<img';\n                    imageHtml += ' id=\"' + Base64.idEncode(match[0]) + '\"';\n                    imageHtml += ' src=\"' + imageSrc + '\"';\n                    imageHtml += ' title=\"' +\n                        match[0].replace(/\\{\\{/g, '{').replace(/\\}\\}/g, '}').replace(/\\\"/g, '&quot;') + '\"';\n                    imageHtml += '>';\n\n                    return imageHtml;\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Convert absolute URLs to {{directive}} style attributes syntax\n         * @param {Object} content\n         * @return {*}\n         */\n        decodeDirectives: function (content) {\n            var directiveUrl = this.makeDirectiveUrl('%directive%').split('?')[0], // remove query string from directive\n                // escape special chars in directives url to use in regular expression\n                regexEscapedDirectiveUrl = directiveUrl.replace(/([$^.?*!+:=()\\[\\]{}|\\\\])/g, '\\\\$1'),\n                regexDirectiveUrl = regexEscapedDirectiveUrl\n                    .replace(\n                        '%directive%',\n                        '([a-zA-Z0-9,_-]+(?:%2[A-Z]|)+\\/?)(?:(?!\").)*'\n                    ) + '/?(\\\\\\\\?[^\"]*)?', // allow optional query string\n                reg = new RegExp(regexDirectiveUrl);\n\n            return content.gsub(reg, function (match) {\n                return Base64.mageDecode(decodeURIComponent(match[1]).replace(/\\/$/, '')).replace(/\"/g, '&quot;');\n            });\n        },\n\n        /**\n         * @param {Object} content\n         * @return {*}\n         */\n        decodeWidgets: function (content) {\n            return content.gsub(/<img([^>]+id=\\\"[^>]+)>/i, function (match) {\n                var attributes = this.parseAttributesString(match[1]),\n                    widgetCode;\n\n                if (attributes.id) {\n                    widgetCode = Base64.idDecode(attributes.id);\n\n                    if (widgetCode.indexOf('{{widget') !== -1) {\n                        return widgetCode;\n                    }\n                }\n\n                return match[0];\n            }.bind(this));\n        },\n\n        /**\n         * @param {Object} attributes\n         * @return {Object}\n         */\n        parseAttributesString: function (attributes) {\n            var result = {};\n\n            attributes.gsub(\n                /(\\w+)(?:\\s*=\\s*(?:(?:\"((?:\\\\.|[^\"])*)\")|(?:'((?:\\\\.|[^'])*)')|([^>\\s]+)))?/,\n                function (match) {\n                    result[match[1]] = match[2];\n                }\n            );\n\n            return result;\n        },\n\n        /**\n         * Update text area.\n         */\n        updateTextArea: function () {\n            var editor = tinyMCE3.get(this.getId()),\n                content;\n\n            if (!editor) {\n                return;\n            }\n\n            content = editor.getContent();\n            content = this.decodeContent(content);\n\n            this.getTextArea().val(content).trigger('change');\n        },\n\n        /**\n         * @return {Object} jQuery textarea element\n         */\n        getTextArea: function () {\n            return jQuery('#' + this.getId());\n        },\n\n        /**\n         * @param {Object} content\n         * @return {*}\n         */\n        decodeContent: function (content) {\n            var result = content;\n\n            if (this.config['add_widgets']) {\n                result = this.decodeWidgets(result);\n                result = this.decodeDirectives(result);\n            } else if (this.config['add_directives']) {\n                result = this.decodeDirectives(result);\n            }\n\n            return result;\n        },\n\n        /**\n         * @param {Object} content\n         * @return {*}\n         */\n        encodeContent: function (content) {\n            var result = content;\n\n            if (this.config['add_widgets']) {\n                result = this.encodeWidgets(this.decodeWidgets(result));\n                result = this.encodeDirectives(result);\n            } else if (this.config['add_directives']) {\n                result = this.encodeDirectives(result);\n            }\n\n            return result;\n        },\n\n        /**\n         * @param {Object} o\n         */\n        beforeSetContent: function (o) {\n            o.content = this.encodeContent(o.content);\n        },\n\n        /**\n         * @param {Object} o\n         */\n        saveContent: function (o) {\n            o.content = this.decodeContent(o.content);\n        },\n\n        /**\n         * @returns {Object}\n         */\n        getAdapterPrototype: function () {\n            return tinyMce3Wysiwyg;\n        }\n    };\n\n    return tinyMce3Wysiwyg.prototype;\n});\n","Magento_Tinymce3/tiny_mce/tiny_mce_jquery.js":"(function(d){var a=/^\\s*|\\s*$/g,e,c=\"B\".replace(/A(.)|B/,\"$1\")===\"$1\";var b={majorVersion:\"3\",minorVersion:\"4.7\",releaseDate:\"2011-11-03\",_init:function(){var s=this,q=document,o=navigator,g=o.userAgent,m,f,l,k,j,r;s.isOpera=d.opera&&opera.buildNumber;s.isWebKit=/WebKit/.test(g);s.isIE=!s.isWebKit&&!s.isOpera&&(/MSIE/gi).test(g)&&(/Explorer/gi).test(o.appName);s.isIE6=s.isIE&&/MSIE [56]/.test(g);s.isIE7=s.isIE&&/MSIE [7]/.test(g);s.isIE8=s.isIE&&/MSIE [8]/.test(g);s.isIE9=s.isIE&&/MSIE [9]/.test(g);s.isGecko=!s.isWebKit&&/Gecko/.test(g);s.isMac=g.indexOf(\"Mac\")!=-1;s.isAir=/adobeair/i.test(g);s.isIDevice=/(iPad|iPhone)/.test(g);s.isIOS5=s.isIDevice&&g.match(/AppleWebKit\\/(\\d*)/)[1]>=534;if(d.tinyMCEPreInit){s.suffix=tinyMCEPreInit.suffix;s.baseURL=tinyMCEPreInit.base;s.query=tinyMCEPreInit.query;return}s.suffix=\"\";f=q.getElementsByTagName(\"base\");for(m=0;m<f.length;m++){if(r=f[m].href){if(/^https?:\\/\\/[^\\/]+$/.test(r)){r+=\"/\"}k=r?r.match(/.*\\//)[0]:\"\"}}function h(i){if(i.src&&/tiny_mce(|_gzip|_jquery|_prototype|_full)(_dev|_src)?.js/.test(i.src)){if(/_(src|dev)\\.js/g.test(i.src)){s.suffix=\"_src\"}if((j=i.src.indexOf(\"?\"))!=-1){s.query=i.src.substring(j+1)}s.baseURL=i.src.substring(0,i.src.lastIndexOf(\"/\"));if(k&&s.baseURL.indexOf(\"://\")==-1&&s.baseURL.indexOf(\"/\")!==0){s.baseURL=k+s.baseURL}return s.baseURL}return null}f=q.getElementsByTagName(\"script\");for(m=0;m<f.length;m++){if(h(f[m])){return}}l=q.getElementsByTagName(\"head\")[0];if(l){f=l.getElementsByTagName(\"script\");for(m=0;m<f.length;m++){if(h(f[m])){return}}}return},is:function(g,f){if(!f){return g!==e}if(f==\"array\"&&(g.hasOwnProperty&&g instanceof Array)){return true}return typeof(g)==f},makeMap:function(f,j,h){var g;f=f||[];j=j||\",\";if(typeof(f)==\"string\"){f=f.split(j)}h=h||{};g=f.length;while(g--){h[f[g]]={}}return h},each:function(i,f,h){var j,g;if(!i){return 0}h=h||i;if(i.length!==e){for(j=0,g=i.length;j<g;j++){if(f.call(h,i[j],j,i)===false){return 0}}}else{for(j in i){if(i.hasOwnProperty(j)){if(f.call(h,i[j],j,i)===false){return 0}}}}return 1},trim:function(f){return(f?\"\"+f:\"\").replace(a,\"\")},create:function(o,f,j){var n=this,g,i,k,l,h,m=0;o=/^((static) )?([\\w.]+)(:([\\w.]+))?/.exec(o);k=o[3].match(/(^|\\.)(\\w+)$/i)[2];i=n.createNS(o[3].replace(/\\.\\w+$/,\"\"),j);if(i[k]){return}if(o[2]==\"static\"){i[k]=f;if(this.onCreate){this.onCreate(o[2],o[3],i[k])}return}if(!f[k]){f[k]=function(){};m=1}i[k]=f[k];n.extend(i[k].prototype,f);if(o[5]){g=n.resolve(o[5]).prototype;l=o[5].match(/\\.(\\w+)$/i)[1];h=i[k];if(m){i[k]=function(){return g[l].apply(this,arguments)}}else{i[k]=function(){this.parent=g[l];return h.apply(this,arguments)}}i[k].prototype[k]=i[k];n.each(g,function(p,q){i[k].prototype[q]=g[q]});n.each(f,function(p,q){if(g[q]){i[k].prototype[q]=function(){this.parent=g[q];return p.apply(this,arguments)}}else{if(q!=k){i[k].prototype[q]=p}}})}n.each(f[\"static\"],function(p,q){i[k][q]=p});if(this.onCreate){this.onCreate(o[2],o[3],i[k].prototype)}},walk:function(i,h,j,g){g=g||this;if(i){if(j){i=i[j]}b.each(i,function(k,f){if(h.call(g,k,f,j)===false){return false}b.walk(k,h,j,g)})}},createNS:function(j,h){var g,f;h=h||d;j=j.split(\".\");for(g=0;g<j.length;g++){f=j[g];if(!h[f]){h[f]={}}h=h[f]}return h},resolve:function(j,h){var g,f;h=h||d;j=j.split(\".\");for(g=0,f=j.length;g<f;g++){h=h[j[g]];if(!h){break}}return h},addUnload:function(j,i){var h=this;j={func:j,scope:i||this};if(!h.unloads){function g(){var f=h.unloads,l,m;if(f){for(m in f){l=f[m];if(l&&l.func){l.func.call(l.scope,1)}}if(d.detachEvent){d.detachEvent(\"onbeforeunload\",k);d.detachEvent(\"onunload\",g)}else{if(d.removeEventListener){d.removeEventListener(\"unload\",g,false)}}h.unloads=l=f=w=g=0;if(d.CollectGarbage){CollectGarbage()}}}function k(){var l=document;if(l.readyState==\"interactive\"){function f(){l.detachEvent(\"onstop\",f);if(g){g()}l=0}if(l){l.attachEvent(\"onstop\",f)}d.setTimeout(function(){if(l){l.detachEvent(\"onstop\",f)}},0)}}if(d.attachEvent){d.attachEvent(\"onunload\",g);d.attachEvent(\"onbeforeunload\",k)}else{if(d.addEventListener){d.addEventListener(\"unload\",g,false)}}h.unloads=[j]}else{h.unloads.push(j)}return j},removeUnload:function(i){var g=this.unloads,h=null;b.each(g,function(j,f){if(j&&j.func==i){g.splice(f,1);h=i;return false}});return h},explode:function(f,g){return f?b.map(f.split(g||\",\"),b.trim):f},_addVer:function(g){var f;if(!this.query){return g}f=(g.indexOf(\"?\")==-1?\"?\":\"&\")+this.query;if(g.indexOf(\"#\")==-1){return g+f}return g.replace(\"#\",f+\"#\")},_replace:function(h,f,g){if(c){return g.replace(h,function(){var l=f,j=arguments,k;for(k=0;k<j.length-2;k++){if(j[k]===e){l=l.replace(new RegExp(\"\\\\$\"+k,\"g\"),\"\")}else{l=l.replace(new RegExp(\"\\\\$\"+k,\"g\"),j[k])}}return l})}return g.replace(h,f)}};b._init();d.tinymce=d.tinyMCE=b})(window);(function(e,d){var c=d.is,b=/^(href|src|style)$/i,f;if(!e&&window.console){return console.log(\"Load jQuery first!\")}d.$=e;d.adapter={patchEditor:function(j){var i=e.fn;function h(n,o){var m=this;if(o){m.removeAttr(\"data-mce-style\")}return i.css.apply(m,arguments)}function g(n,o){var m=this;if(b.test(n)){if(o!==f){m.each(function(p,q){j.dom.setAttrib(q,n,o)});return m}else{return m.attr(\"data-mce-\"+n)}}return i.attr.apply(m,arguments)}function k(m){return function(n){if(n){n=j.dom.processHTML(n)}return m.call(this,n)}}function l(m){if(m.css!==h){m.css=h;m.attr=g;m.html=k(i.html);m.append=k(i.append);m.prepend=k(i.prepend);m.after=k(i.after);m.before=k(i.before);m.replaceWith=k(i.replaceWith);m.tinymce=j;m.pushStack=function(){return l(i.pushStack.apply(this,arguments))}}return m}j.$=function(m,n){var o=j.getDoc();return l(e(m||o,o||n))}}};d.extend=e.extend;d.extend(d,{map:e.map,grep:function(g,h){return e.grep(g,h||function(){return 1})},inArray:function(g,h){return e.inArray(h,g||[])}});var a={\"tinymce.dom.DOMUtils\":{select:function(i,h){var g=this;return e.find(i,g.get(h)||g.get(g.settings.root_element)||g.doc,[])},is:function(h,g){return e(this.get(h)).is(g)}}};d.onCreate=function(g,i,h){d.extend(h,a[i])}})(window.jQuery,tinymce);tinymce.create(\"tinymce.util.Dispatcher\",{scope:null,listeners:null,Dispatcher:function(a){this.scope=a||this;this.listeners=[]},add:function(a,b){this.listeners.push({cb:a,scope:b||this.scope});return a},addToTop:function(a,b){this.listeners.unshift({cb:a,scope:b||this.scope});return a},remove:function(a){var b=this.listeners,c=null;tinymce.each(b,function(e,d){if(a==e.cb){c=a;b.splice(d,1);return false}});return c},dispatch:function(){var f,d=arguments,e,b=this.listeners,g;for(e=0;e<b.length;e++){g=b[e];f=g.cb.apply(g.scope,d);if(f===false){break}}return f}});(function(){var a=tinymce.each;tinymce.create(\"tinymce.util.URI\",{URI:function(e,g){var f=this,i,d,c,h;e=tinymce.trim(e);g=f.settings=g||{};if(/^([\\w\\-]+):([^\\/]{2})/i.test(e)||/^\\s*#/.test(e)){f.source=e;return}if(e.indexOf(\"/\")===0&&e.indexOf(\"//\")!==0){e=(g.base_uri?g.base_uri.protocol||\"http\":\"http\")+\"://mce_host\"+e}if(!/^[\\w-]*:?\\/\\//.test(e)){h=g.base_uri?g.base_uri.path:new tinymce.util.URI(location.href).directory;e=((g.base_uri&&g.base_uri.protocol)||\"http\")+\"://mce_host\"+f.toAbsPath(h,e)}e=e.replace(/@@/g,\"(mce_at)\");e=/^(?:(?![^:@]+:[^:@\\/]*@)([^:\\/?#.]+):)?(?:\\/\\/)?((?:(([^:@]*):?([^:@]*))?@)?([^:\\/?#]*)(?::(\\d*))?)(((\\/(?:[^?#](?![^?#\\/]*\\.[^?#\\/.]+(?:[?#]|$)))*\\/?)?([^?#\\/]*))(?:\\?([^#]*))?(?:#(.*))?)/.exec(e);a([\"source\",\"protocol\",\"authority\",\"userInfo\",\"user\",\"password\",\"host\",\"port\",\"relative\",\"path\",\"directory\",\"file\",\"query\",\"anchor\"],function(b,j){var k=e[j];if(k){k=k.replace(/\\(mce_at\\)/g,\"@@\")}f[b]=k});if(c=g.base_uri){if(!f.protocol){f.protocol=c.protocol}if(!f.userInfo){f.userInfo=c.userInfo}if(!f.port&&f.host==\"mce_host\"){f.port=c.port}if(!f.host||f.host==\"mce_host\"){f.host=c.host}f.source=\"\"}},setPath:function(c){var b=this;c=/^(.*?)\\/?(\\w+)?$/.exec(c);b.path=c[0];b.directory=c[1];b.file=c[2];b.source=\"\";b.getURI()},toRelative:function(b){var c=this,d;if(b===\"./\"){return b}b=new tinymce.util.URI(b,{base_uri:c});if((b.host!=\"mce_host\"&&c.host!=b.host&&b.host)||c.port!=b.port||c.protocol!=b.protocol){return b.getURI()}d=c.toRelPath(c.path,b.path);if(b.query){d+=\"?\"+b.query}if(b.anchor){d+=\"#\"+b.anchor}return d},toAbsolute:function(b,c){var b=new tinymce.util.URI(b,{base_uri:this});return b.getURI(this.host==b.host&&this.protocol==b.protocol?c:0)},toRelPath:function(g,h){var c,f=0,d=\"\",e,b;g=g.substring(0,g.lastIndexOf(\"/\"));g=g.split(\"/\");c=h.split(\"/\");if(g.length>=c.length){for(e=0,b=g.length;e<b;e++){if(e>=c.length||g[e]!=c[e]){f=e+1;break}}}if(g.length<c.length){for(e=0,b=c.length;e<b;e++){if(e>=g.length||g[e]!=c[e]){f=e+1;break}}}if(f==1){return h}for(e=0,b=g.length-(f-1);e<b;e++){d+=\"../\"}for(e=f-1,b=c.length;e<b;e++){if(e!=f-1){d+=\"/\"+c[e]}else{d+=c[e]}}return d},toAbsPath:function(e,f){var c,b=0,h=[],d,g;d=/\\/$/.test(f)?\"/\":\"\";e=e.split(\"/\");f=f.split(\"/\");a(e,function(i){if(i){h.push(i)}});e=h;for(c=f.length-1,h=[];c>=0;c--){if(f[c].length==0||f[c]==\".\"){continue}if(f[c]==\"..\"){b++;continue}if(b>0){b--;continue}h.push(f[c])}c=e.length-b;if(c<=0){g=h.reverse().join(\"/\")}else{g=e.slice(0,c).join(\"/\")+\"/\"+h.reverse().join(\"/\")}if(g.indexOf(\"/\")!==0){g=\"/\"+g}if(d&&g.lastIndexOf(\"/\")!==g.length-1){g+=d}return g},getURI:function(d){var c,b=this;if(!b.source||d){c=\"\";if(!d){if(b.protocol){c+=b.protocol+\"://\"}if(b.userInfo){c+=b.userInfo+\"@\"}if(b.host){c+=b.host}if(b.port){c+=\":\"+b.port}}if(b.path){c+=b.path}if(b.query){c+=\"?\"+b.query}if(b.anchor){c+=\"#\"+b.anchor}b.source=c}return b.source}})})();(function(){var a=tinymce.each;tinymce.create(\"static tinymce.util.Cookie\",{getHash:function(d){var b=this.get(d),c;if(b){a(b.split(\"&\"),function(e){e=e.split(\"=\");c=c||{};c[unescape(e[0])]=unescape(e[1])})}return c},setHash:function(j,b,g,f,i,c){var h=\"\";a(b,function(e,d){h+=(!h?\"\":\"&\")+escape(d)+\"=\"+escape(e)});this.set(j,h,g,f,i,c)},get:function(i){var h=document.cookie,g,f=i+\"=\",d;if(!h){return}d=h.indexOf(\"; \"+f);if(d==-1){d=h.indexOf(f);if(d!=0){return null}}else{d+=2}g=h.indexOf(\";\",d);if(g==-1){g=h.length}return unescape(h.substring(d+f.length,g))},set:function(i,b,g,f,h,c){document.cookie=i+\"=\"+escape(b)+((g)?\"; expires=\"+g.toUTCString():\"\")+((f)?\"; path=\"+escape(f):\"\")+((h)?\"; domain=\"+h:\"\")+((c)?\"; secure\":\"\")},remove:function(e,b){var c=new Date();c.setTime(c.getTime()-1000);this.set(e,\"\",c,b,c)}})})();(function(){function serialize(o,quote){var i,v,t;quote=quote||'\"';if(o==null){return\"null\"}t=typeof o;if(t==\"string\"){v=\"\\bb\\tt\\nn\\ff\\rr\\\"\\\"''\\\\\\\\\";return quote+o.replace(/([\\u0080-\\uFFFF\\x00-\\x1f\\\"\\'\\\\])/g,function(a,b){if(quote==='\"'&&a===\"'\"){return a}i=v.indexOf(b);if(i+1){return\"\\\\\"+v.charAt(i+1)}a=b.charCodeAt().toString(16);return\"\\\\u\"+\"0000\".substring(a.length)+a})+quote}if(t==\"object\"){if(o.hasOwnProperty&&o instanceof Array){for(i=0,v=\"[\";i<o.length;i++){v+=(i>0?\",\":\"\")+serialize(o[i],quote)}return v+\"]\"}v=\"{\";for(i in o){if(o.hasOwnProperty(i)){v+=typeof o[i]!=\"function\"?(v.length>1?\",\"+quote:quote)+i+quote+\":\"+serialize(o[i],quote):\"\"}}return v+\"}\"}return\"\"+o}tinymce.util.JSON={serialize:serialize,parse:function(s){try{return eval(\"(\"+s+\")\")}catch(ex){}}}})();tinymce.create(\"static tinymce.util.XHR\",{send:function(g){var a,e,b=window,h=0;g.scope=g.scope||this;g.success_scope=g.success_scope||g.scope;g.error_scope=g.error_scope||g.scope;g.async=g.async===false?false:true;g.data=g.data||\"\";function d(i){a=0;try{a=new ActiveXObject(i)}catch(c){}return a}a=b.XMLHttpRequest?new XMLHttpRequest():d(\"Microsoft.XMLHTTP\")||d(\"Msxml2.XMLHTTP\");if(a){if(a.overrideMimeType){a.overrideMimeType(g.content_type)}a.open(g.type||(g.data?\"POST\":\"GET\"),g.url,g.async);if(g.content_type){a.setRequestHeader(\"Content-Type\",g.content_type)}a.setRequestHeader(\"X-Requested-With\",\"XMLHttpRequest\");a.send(g.data);function f(){if(!g.async||a.readyState==4||h++>10000){if(g.success&&h<10000&&a.status==200){g.success.call(g.success_scope,\"\"+a.responseText,a,g)}else{if(g.error){g.error.call(g.error_scope,h>10000?\"TIMED_OUT\":\"GENERAL\",a,g)}}a=null}else{b.setTimeout(f,10)}}if(!g.async){return f()}e=b.setTimeout(f,10)}}});(function(){var c=tinymce.extend,b=tinymce.util.JSON,a=tinymce.util.XHR;tinymce.create(\"tinymce.util.JSONRequest\",{JSONRequest:function(d){this.settings=c({},d);this.count=0},send:function(f){var e=f.error,d=f.success;f=c(this.settings,f);f.success=function(h,g){h=b.parse(h);if(typeof(h)==\"undefined\"){h={error:\"JSON Parse error.\"}}if(h.error){e.call(f.error_scope||f.scope,h.error,g)}else{d.call(f.success_scope||f.scope,h.result)}};f.error=function(h,g){if(e){e.call(f.error_scope||f.scope,h,g)}};f.data=b.serialize({id:f.id||\"c\"+(this.count++),method:f.method,params:f.params});f.content_type=\"application/json\";a.send(f)},\"static\":{sendRPC:function(d){return new tinymce.util.JSONRequest().send(d)}}})}());(function(a){a.VK={DELETE:46,BACKSPACE:8,ENTER:13,TAB:9,SPACEBAR:32,UP:38,DOWN:40}})(tinymce);(function(k){var i=k.VK,j=i.BACKSPACE,h=i.DELETE;function c(m){var o=m.dom,n=m.selection;m.onKeyDown.add(function(q,u){var p,v,s,t,r;r=u.keyCode==h;if(r||u.keyCode==j){u.preventDefault();p=n.getRng();v=o.getParent(p.startContainer,o.isBlock);if(r){v=o.getNext(v,o.isBlock)}if(v){s=v.firstChild;while(s&&s.nodeType==3&&s.nodeValue.length==0){s=s.nextSibling}if(s&&s.nodeName===\"SPAN\"){t=s.cloneNode(false)}}q.getDoc().execCommand(r?\"ForwardDelete\":\"Delete\",false,null);v=o.getParent(p.startContainer,o.isBlock);k.each(o.select(\"span.Apple-style-span,font.Apple-style-span\",v),function(x){var y=n.getBookmark();if(t){o.replace(t.cloneNode(false),x,true)}else{o.remove(x,true)}n.moveToBookmark(y)})}})}function d(m){m.onKeyUp.add(function(n,p){var o=p.keyCode;if(o==h||o==j){if(n.dom.isEmpty(n.getBody())){n.setContent(\"\",{format:\"raw\"});n.nodeChanged();return}}})}function b(m){m.dom.bind(m.getDoc(),\"focusin\",function(){m.selection.setRng(m.selection.getRng())})}function e(m){m.onKeyDown.add(function(n,q){if(q.keyCode===j){if(n.selection.isCollapsed()&&n.selection.getRng(true).startOffset===0){var p=n.selection.getNode();var o=p.previousSibling;if(o&&o.nodeName&&o.nodeName.toLowerCase()===\"hr\"){n.dom.remove(o);k.dom.Event.cancel(q)}}}})}function g(m){if(!Range.prototype.getClientRects){m.onMouseDown.add(function(o,p){if(p.target.nodeName===\"HTML\"){var n=o.getBody();n.blur();setTimeout(function(){n.focus()},0)}})}}function f(m){m.onClick.add(function(n,o){o=o.target;if(/^(IMG|HR)$/.test(o.nodeName)){n.selection.select(o)}if(o.nodeName==\"A\"&&n.dom.hasClass(o,\"mceItemAnchor\")){n.selection.select(o)}n.nodeChanged()})}function l(m){var o,n;m.dom.bind(m.getDoc(),\"selectionchange\",function(){if(n){clearTimeout(n);n=0}n=window.setTimeout(function(){var p=m.selection.getRng();if(!o||!k.dom.RangeUtils.compareRanges(p,o)){m.nodeChanged();o=p}},50)})}function a(m){document.body.setAttribute(\"role\",\"application\")}k.create(\"tinymce.util.Quirks\",{Quirks:function(m){if(k.isWebKit){c(m);d(m);b(m);f(m);if(k.isIDevice){l(m)}}if(k.isIE){e(m);d(m);a(m)}if(k.isGecko){e(m);g(m)}}})})(tinymce);(function(j){var a,g,d,k=/[&<>\\\"\\u007E-\\uD7FF\\uE000-\\uFFEF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,b=/[<>&\\u007E-\\uD7FF\\uE000-\\uFFEF]|[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,f=/[<>&\\\"\\']/g,c=/&(#x|#)?([\\w]+);/g,i={128:\"\\u20AC\",130:\"\\u201A\",131:\"\\u0192\",132:\"\\u201E\",133:\"\\u2026\",134:\"\\u2020\",135:\"\\u2021\",136:\"\\u02C6\",137:\"\\u2030\",138:\"\\u0160\",139:\"\\u2039\",140:\"\\u0152\",142:\"\\u017D\",145:\"\\u2018\",146:\"\\u2019\",147:\"\\u201C\",148:\"\\u201D\",149:\"\\u2022\",150:\"\\u2013\",151:\"\\u2014\",152:\"\\u02DC\",153:\"\\u2122\",154:\"\\u0161\",155:\"\\u203A\",156:\"\\u0153\",158:\"\\u017E\",159:\"\\u0178\"};g={'\"':\"&quot;\",\"'\":\"&#39;\",\"<\":\"&lt;\",\">\":\"&gt;\",\"&\":\"&amp;\"};d={\"&lt;\":\"<\",\"&gt;\":\">\",\"&amp;\":\"&\",\"&quot;\":'\"',\"&apos;\":\"'\"};function h(l){var m;m=document.createElement(\"div\");m.innerHTML=l;return m.textContent||m.innerText||l}function e(m,p){var n,o,l,q={};if(m){m=m.split(\",\");p=p||10;for(n=0;n<m.length;n+=2){o=String.fromCharCode(parseInt(m[n],p));if(!g[o]){l=\"&\"+m[n+1]+\";\";q[o]=l;q[l]=o}}return q}}a=e(\"50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro\",32);j.html=j.html||{};j.html.Entities={encodeRaw:function(m,l){return m.replace(l?k:b,function(n){return g[n]||n})},encodeAllRaw:function(l){return(\"\"+l).replace(f,function(m){return g[m]||m})},encodeNumeric:function(m,l){return m.replace(l?k:b,function(n){if(n.length>1){return\"&#\"+(((n.charCodeAt(0)-55296)*1024)+(n.charCodeAt(1)-56320)+65536)+\";\"}return g[n]||\"&#\"+n.charCodeAt(0)+\";\"})},encodeNamed:function(n,l,m){m=m||a;return n.replace(l?k:b,function(o){return g[o]||m[o]||o})},getEncodeFunc:function(l,o){var p=j.html.Entities;o=e(o)||a;function m(r,q){return r.replace(q?k:b,function(s){return g[s]||o[s]||\"&#\"+s.charCodeAt(0)+\";\"||s})}function n(r,q){return p.encodeNamed(r,q,o)}l=j.makeMap(l.replace(/\\+/g,\",\"));if(l.named&&l.numeric){return m}if(l.named){if(o){return n}return p.encodeNamed}if(l.numeric){return p.encodeNumeric}return p.encodeRaw},decode:function(l){return l.replace(c,function(n,m,o){if(m){o=parseInt(o,m.length===2?16:10);if(o>65535){o-=65536;return String.fromCharCode(55296+(o>>10),56320+(o&1023))}else{return i[o]||String.fromCharCode(o)}}return d[n]||a[n]||h(n)})}}})(tinymce);tinymce.html.Styles=function(d,f){var k=/rgb\\s*\\(\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*\\)/gi,h=/(?:url(?:(?:\\(\\s*\\\"([^\\\"]+)\\\"\\s*\\))|(?:\\(\\s*\\'([^\\']+)\\'\\s*\\))|(?:\\(\\s*([^)\\s]+)\\s*\\))))|(?:\\'([^\\']+)\\')|(?:\\\"([^\\\"]+)\\\")/gi,b=/\\s*([^:]+):\\s*([^;]+);?/g,l=/\\s+$/,m=/rgb/,e,g,a={},j;d=d||{};j=\"\\\\\\\" \\\\' \\\\; \\\\: ; : \\uFEFF\".split(\" \");for(g=0;g<j.length;g++){a[j[g]]=\"\\uFEFF\"+g;a[\"\\uFEFF\"+g]=j[g]}function c(n,q,p,i){function o(r){r=parseInt(r).toString(16);return r.length>1?r:\"0\"+r}return\"#\"+o(q)+o(p)+o(i)}return{toHex:function(i){return i.replace(k,c)},parse:function(r){var y={},p,n,v,q,u=d.url_converter,x=d.url_converter_scope||this;function o(C,F){var E,B,A,D;E=y[C+\"-top\"+F];if(!E){return}B=y[C+\"-right\"+F];if(E!=B){return}A=y[C+\"-bottom\"+F];if(B!=A){return}D=y[C+\"-left\"+F];if(A!=D){return}y[C+F]=D;delete y[C+\"-top\"+F];delete y[C+\"-right\"+F];delete y[C+\"-bottom\"+F];delete y[C+\"-left\"+F]}function t(B){var C=y[B],A;if(!C||C.indexOf(\" \")<0){return}C=C.split(\" \");A=C.length;while(A--){if(C[A]!==C[0]){return false}}y[B]=C[0];return true}function z(C,B,A,D){if(!t(B)){return}if(!t(A)){return}if(!t(D)){return}y[C]=y[B]+\" \"+y[A]+\" \"+y[D];delete y[B];delete y[A];delete y[D]}function s(A){q=true;return a[A]}function i(B,A){if(q){B=B.replace(/\\uFEFF[0-9]/g,function(C){return a[C]})}if(!A){B=B.replace(/\\\\([\\'\\\";:])/g,\"$1\")}return B}if(r){r=r.replace(/\\\\[\\\"\\';:\\uFEFF]/g,s).replace(/\\\"[^\\\"]+\\\"|\\'[^\\']+\\'/g,function(A){return A.replace(/[;:]/g,s)});while(p=b.exec(r)){n=p[1].replace(l,\"\").toLowerCase();v=p[2].replace(l,\"\");if(n&&v.length>0){if(n===\"font-weight\"&&v===\"700\"){v=\"bold\"}else{if(n===\"color\"||n===\"background-color\"){v=v.toLowerCase()}}v=v.replace(k,c);v=v.replace(h,function(B,A,E,D,F,C){F=F||C;if(F){F=i(F);return\"'\"+F.replace(/\\'/g,\"\\\\'\")+\"'\"}A=i(A||E||D);if(u){A=u.call(x,A,\"style\")}return\"url('\"+A.replace(/\\'/g,\"\\\\'\")+\"')\"});y[n]=q?i(v,true):v}b.lastIndex=p.index+p[0].length}o(\"border\",\"\");o(\"border\",\"-width\");o(\"border\",\"-color\");o(\"border\",\"-style\");o(\"padding\",\"\");o(\"margin\",\"\");z(\"border\",\"border-width\",\"border-style\",\"border-color\");if(y.border===\"medium none\"){delete y.border}}return y},serialize:function(p,r){var o=\"\",n,q;function i(t){var x,u,s,v;x=f.styles[t];if(x){for(u=0,s=x.length;u<s;u++){t=x[u];v=p[t];if(v!==e&&v.length>0){o+=(o.length>0?\" \":\"\")+t+\": \"+v+\";\"}}}}if(r&&f&&f.styles){i(\"*\");i(r)}else{for(n in p){q=p[n];if(q!==e&&q.length>0){o+=(o.length>0?\" \":\"\")+n+\": \"+q+\";\"}}}return o}}};(function(m){var h={},j,l,g,f,c={},b,e,d=m.makeMap,k=m.each;function i(o,n){return o.split(n||\",\")}function a(r,q){var o,p={};function n(s){return s.replace(/[A-Z]+/g,function(t){return n(r[t])})}for(o in r){if(r.hasOwnProperty(o)){r[o]=n(r[o])}}n(q).replace(/#/g,\"#text\").replace(/(\\w+)\\[([^\\]]+)\\]\\[([^\\]]*)\\]/g,function(v,t,s,u){s=i(s,\"|\");p[t]={attributes:d(s),attributesOrder:s,children:d(u,\"|\",{\"#comment\":{}})}});return p}l=\"h1,h2,h3,h4,h5,h6,hr,p,div,address,pre,form,table,tbody,thead,tfoot,th,tr,td,li,ol,ul,caption,blockquote,center,dl,dt,dd,dir,fieldset,noscript,menu,isindex,samp,header,footer,article,section,hgroup\";l=d(l,\",\",d(l.toUpperCase()));h=a({Z:\"H|K|N|O|P\",Y:\"X|form|R|Q\",ZG:\"E|span|width|align|char|charoff|valign\",X:\"p|T|div|U|W|isindex|fieldset|table\",ZF:\"E|align|char|charoff|valign\",W:\"pre|hr|blockquote|address|center|noframes\",ZE:\"abbr|axis|headers|scope|rowspan|colspan|align|char|charoff|valign|nowrap|bgcolor|width|height\",ZD:\"[E][S]\",U:\"ul|ol|dl|menu|dir\",ZC:\"p|Y|div|U|W|table|br|span|bdo|object|applet|img|map|K|N|Q\",T:\"h1|h2|h3|h4|h5|h6\",ZB:\"X|S|Q\",S:\"R|P\",ZA:\"a|G|J|M|O|P\",R:\"a|H|K|N|O\",Q:\"noscript|P\",P:\"ins|del|script\",O:\"input|select|textarea|label|button\",N:\"M|L\",M:\"em|strong|dfn|code|q|samp|kbd|var|cite|abbr|acronym\",L:\"sub|sup\",K:\"J|I\",J:\"tt|i|b|u|s|strike\",I:\"big|small|font|basefont\",H:\"G|F\",G:\"br|span|bdo\",F:\"object|applet|img|map|iframe\",E:\"A|B|C\",D:\"accesskey|tabindex|onfocus|onblur\",C:\"onclick|ondblclick|onmousedown|onmouseup|onmouseover|onmousemove|onmouseout|onkeypress|onkeydown|onkeyup\",B:\"lang|xml:lang|dir\",A:\"id|class|style|title\"},\"script[id|charset|type|language|src|defer|xml:space][]style[B|id|type|media|title|xml:space][]object[E|declare|classid|codebase|data|type|codetype|archive|standby|width|height|usemap|name|tabindex|align|border|hspace|vspace][#|param|Y]param[id|name|value|valuetype|type][]p[E|align][#|S]a[E|D|charset|type|name|href|hreflang|rel|rev|shape|coords|target][#|Z]br[A|clear][]span[E][#|S]bdo[A|C|B][#|S]applet[A|codebase|archive|code|object|alt|name|width|height|align|hspace|vspace][#|param|Y]h1[E|align][#|S]img[E|src|alt|name|longdesc|width|height|usemap|ismap|align|border|hspace|vspace][]map[B|C|A|name][X|form|Q|area]h2[E|align][#|S]iframe[A|longdesc|name|src|frameborder|marginwidth|marginheight|scrolling|align|width|height][#|Y]h3[E|align][#|S]tt[E][#|S]i[E][#|S]b[E][#|S]u[E][#|S]s[E][#|S]strike[E][#|S]big[E][#|S]small[E][#|S]font[A|B|size|color|face][#|S]basefont[id|size|color|face][]em[E][#|S]strong[E][#|S]dfn[E][#|S]code[E][#|S]q[E|cite][#|S]samp[E][#|S]kbd[E][#|S]var[E][#|S]cite[E][#|S]abbr[E][#|S]acronym[E][#|S]sub[E][#|S]sup[E][#|S]input[E|D|type|name|value|checked|disabled|readonly|size|maxlength|src|alt|usemap|onselect|onchange|accept|align][]select[E|name|size|multiple|disabled|tabindex|onfocus|onblur|onchange][optgroup|option]optgroup[E|disabled|label][option]option[E|selected|disabled|label|value][]textarea[E|D|name|rows|cols|disabled|readonly|onselect|onchange][]label[E|for|accesskey|onfocus|onblur][#|S]button[E|D|name|value|type|disabled][#|p|T|div|U|W|table|G|object|applet|img|map|K|N|Q]h4[E|align][#|S]ins[E|cite|datetime][#|Y]h5[E|align][#|S]del[E|cite|datetime][#|Y]h6[E|align][#|S]div[E|align][#|Y]ul[E|type|compact][li]li[E|type|value][#|Y]ol[E|type|compact|start][li]dl[E|compact][dt|dd]dt[E][#|S]dd[E][#|Y]menu[E|compact][li]dir[E|compact][li]pre[E|width|xml:space][#|ZA]hr[E|align|noshade|size|width][]blockquote[E|cite][#|Y]address[E][#|S|p]center[E][#|Y]noframes[E][#|Y]isindex[A|B|prompt][]fieldset[E][#|legend|Y]legend[E|accesskey|align][#|S]table[E|summary|width|border|frame|rules|cellspacing|cellpadding|align|bgcolor][caption|col|colgroup|thead|tfoot|tbody|tr]caption[E|align][#|S]col[ZG][]colgroup[ZG][col]thead[ZF][tr]tr[ZF|bgcolor][th|td]th[E|ZE][#|Y]form[E|action|method|name|enctype|onsubmit|onreset|accept|accept-charset|target][#|X|R|Q]noscript[E][#|Y]td[E|ZE][#|Y]tfoot[ZF][tr]tbody[ZF][tr]area[E|D|shape|coords|href|nohref|alt|target][]base[id|href|target][]body[E|onload|onunload|background|bgcolor|text|link|vlink|alink][#|Y]\");j=d(\"checked,compact,declare,defer,disabled,ismap,multiple,nohref,noresize,noshade,nowrap,readonly,selected,autoplay,loop,controls\");g=d(\"area,base,basefont,br,col,frame,hr,img,input,isindex,link,meta,param,embed,source\");f=m.extend(d(\"td,th,iframe,video,audio,object\"),g);b=d(\"pre,script,style,textarea\");e=d(\"colgroup,dd,dt,li,options,p,td,tfoot,th,thead,tr\");m.html.Schema=function(r){var A=this,n={},o={},y=[],q,p;r=r||{};if(r.verify_html===false){r.valid_elements=\"*[*]\"}if(r.valid_styles){q={};k(r.valid_styles,function(C,B){q[B]=m.explode(C)})}p=r.whitespace_elements?d(r.whitespace_elements):b;function z(B){return new RegExp(\"^\"+B.replace(/([?+*])/g,\".$1\")+\"$\")}function t(I){var H,D,W,S,X,C,F,R,U,N,V,Z,L,G,T,B,P,E,Y,aa,M,Q,K=/^([#+-])?([^\\[\\/]+)(?:\\/([^\\[]+))?(?:\\[([^\\]]+)\\])?$/,O=/^([!\\-])?(\\w+::\\w+|[^=:<]+)?(?:([=:<])(.*))?$/,J=/[*?+]/;if(I){I=i(I);if(n[\"@\"]){P=n[\"@\"].attributes;E=n[\"@\"].attributesOrder}for(H=0,D=I.length;H<D;H++){C=K.exec(I[H]);if(C){T=C[1];N=C[2];B=C[3];U=C[4];L={};G=[];F={attributes:L,attributesOrder:G};if(T===\"#\"){F.paddEmpty=true}if(T===\"-\"){F.removeEmpty=true}if(P){for(aa in P){L[aa]=P[aa]}G.push.apply(G,E)}if(U){U=i(U,\"|\");for(W=0,S=U.length;W<S;W++){C=O.exec(U[W]);if(C){R={};Z=C[1];V=C[2].replace(/::/g,\":\");T=C[3];Q=C[4];if(Z===\"!\"){F.attributesRequired=F.attributesRequired||[];F.attributesRequired.push(V);R.required=true}if(Z===\"-\"){delete L[V];G.splice(m.inArray(G,V),1);continue}if(T){if(T===\"=\"){F.attributesDefault=F.attributesDefault||[];F.attributesDefault.push({name:V,value:Q});R.defaultValue=Q}if(T===\":\"){F.attributesForced=F.attributesForced||[];F.attributesForced.push({name:V,value:Q});R.forcedValue=Q}if(T===\"<\"){R.validValues=d(Q,\"?\")}}if(J.test(V)){F.attributePatterns=F.attributePatterns||[];R.pattern=z(V);F.attributePatterns.push(R)}else{if(!L[V]){G.push(V)}L[V]=R}}}}if(!P&&N==\"@\"){P=L;E=G}if(B){F.outputName=N;n[B]=F}if(J.test(N)){F.pattern=z(N);y.push(F)}else{n[N]=F}}}}}function v(B){n={};y=[];t(B);k(h,function(D,C){o[C]=D.children})}function s(C){var B=/^(~)?(.+)$/;if(C){k(i(C),function(G){var E=B.exec(G),F=E[1]===\"~\",H=F?\"span\":\"div\",D=E[2];o[D]=o[H];c[D]=H;if(!F){l[D]={}}k(o,function(I,J){if(I[H]){I[D]=I[H]}})})}}function u(C){var B=/^([+\\-]?)(\\w+)\\[([^\\]]+)\\]$/;if(C){k(i(C),function(G){var F=B.exec(G),D,E;if(F){E=F[1];if(E){D=o[F[2]]}else{D=o[F[2]]={\"#comment\":{}}}D=o[F[2]];k(i(F[3],\"|\"),function(H){if(E===\"-\"){delete D[H]}else{D[H]={}}})}})}}function x(B){var D=n[B],C;if(D){return D}C=y.length;while(C--){D=y[C];if(D.pattern.test(B)){return D}}}if(!r.valid_elements){k(h,function(C,B){n[B]={attributes:C.attributes,attributesOrder:C.attributesOrder};o[B]=C.children});k(i(\"strong/b,em/i\"),function(B){B=i(B,\"/\");n[B[1]].outputName=B[0]});n.img.attributesDefault=[{name:\"alt\",value:\"\"}];k(i(\"ol,ul,sub,sup,blockquote,span,font,a,table,tbody,tr\"),function(B){n[B].removeEmpty=true});k(i(\"p,h1,h2,h3,h4,h5,h6,th,td,pre,div,address,caption\"),function(B){n[B].paddEmpty=true})}else{v(r.valid_elements)}s(r.custom_elements);u(r.valid_children);t(r.extended_valid_elements);u(\"+ol[ul|ol],+ul[ul|ol]\");if(!x(\"span\")){t(\"span[!data-mce-type|*]\")}if(r.invalid_elements){m.each(m.explode(r.invalid_elements),function(B){if(n[B]){delete n[B]}})}A.children=o;A.styles=q;A.getBoolAttrs=function(){return j};A.getBlockElements=function(){return l};A.getShortEndedElements=function(){return g};A.getSelfClosingElements=function(){return e};A.getNonEmptyElements=function(){return f};A.getWhiteSpaceElements=function(){return p};A.isValidChild=function(B,D){var C=o[B];return !!(C&&C[D])};A.getElementRule=x;A.getCustomElements=function(){return c};A.addValidElements=t;A.setValidElements=v;A.addCustomElements=s;A.addValidChildren=u};m.html.Schema.boolAttrMap=j;m.html.Schema.blockElementsMap=l})(tinymce);(function(a){a.html.SaxParser=function(c,e){var b=this,d=function(){};c=c||{};b.schema=e=e||new a.html.Schema();if(c.fix_self_closing!==false){c.fix_self_closing=true}a.each(\"comment cdata text start end pi doctype\".split(\" \"),function(f){if(f){b[f]=c[f]||d}});b.parse=function(D){var n=this,g,F=0,H,A,z=[],M,P,B,q,y,r,L,G,N,u,m,k,s,Q,o,O,E,R,K,f,I,l,C,J,h,v=0,j=a.html.Entities.decode,x,p;function t(S){var U,T;U=z.length;while(U--){if(z[U].name===S){break}}if(U>=0){for(T=z.length-1;T>=U;T--){S=z[T];if(S.valid){n.end(S.name)}}z.length=U}}l=new RegExp(\"<(?:(?:!--([\\\\w\\\\W]*?)-->)|(?:!\\\\[CDATA\\\\[([\\\\w\\\\W]*?)\\\\]\\\\]>)|(?:!DOCTYPE([\\\\w\\\\W]*?)>)|(?:\\\\?([^\\\\s\\\\/<>]+) ?([\\\\w\\\\W]*?)[?/]>)|(?:\\\\/([^>]+)>)|(?:([^\\\\s\\\\/<>]+)((?:\\\\s+[^\\\"'>]+(?:(?:\\\"[^\\\"]*\\\")|(?:'[^']*')|[^>]*))*|\\\\/)>))\",\"g\");C=/([\\w:\\-]+)(?:\\s*=\\s*(?:(?:\\\"((?:\\\\.|[^\\\"])*)\\\")|(?:\\'((?:\\\\.|[^\\'])*)\\')|([^>\\s]+)))?/g;J={script:/<\\/script[^>]*>/gi,style:/<\\/style[^>]*>/gi,noscript:/<\\/noscript[^>]*>/gi};L=e.getShortEndedElements();I=e.getSelfClosingElements();G=e.getBoolAttrs();u=c.validate;r=c.remove_internals;x=c.fix_self_closing;p=a.isIE;o=/^:/;while(g=l.exec(D)){if(F<g.index){n.text(j(D.substr(F,g.index-F)))}if(H=g[6]){H=H.toLowerCase();if(p&&o.test(H)){H=H.substr(1)}t(H)}else{if(H=g[7]){H=H.toLowerCase();if(p&&o.test(H)){H=H.substr(1)}N=H in L;if(x&&I[H]&&z.length>0&&z[z.length-1].name===H){t(H)}if(!u||(m=e.getElementRule(H))){k=true;if(u){O=m.attributes;E=m.attributePatterns}if(Q=g[8]){y=Q.indexOf(\"data-mce-type\")!==-1;if(y&&r){k=false}M=[];M.map={};Q.replace(C,function(T,S,X,W,V){var Y,U;S=S.toLowerCase();X=S in G?S:j(X||W||V||\"\");if(u&&!y&&S.indexOf(\"data-\")!==0){Y=O[S];if(!Y&&E){U=E.length;while(U--){Y=E[U];if(Y.pattern.test(S)){break}}if(U===-1){Y=null}}if(!Y){return}if(Y.validValues&&!(X in Y.validValues)){return}}M.map[S]=X;M.push({name:S,value:X})})}else{M=[];M.map={}}if(u&&!y){R=m.attributesRequired;K=m.attributesDefault;f=m.attributesForced;if(f){P=f.length;while(P--){s=f[P];q=s.name;h=s.value;if(h===\"{$uid}\"){h=\"mce_\"+v++}M.map[q]=h;M.push({name:q,value:h})}}if(K){P=K.length;while(P--){s=K[P];q=s.name;if(!(q in M.map)){h=s.value;if(h===\"{$uid}\"){h=\"mce_\"+v++}M.map[q]=h;M.push({name:q,value:h})}}}if(R){P=R.length;while(P--){if(R[P] in M.map){break}}if(P===-1){k=false}}if(M.map[\"data-mce-bogus\"]){k=false}}if(k){n.start(H,M,N)}}else{k=false}if(A=J[H]){A.lastIndex=F=g.index+g[0].length;if(g=A.exec(D)){if(k){B=D.substr(F,g.index-F)}F=g.index+g[0].length}else{B=D.substr(F);F=D.length}if(k&&B.length>0){n.text(B,true)}if(k){n.end(H)}l.lastIndex=F;continue}if(!N){if(!Q||Q.indexOf(\"/\")!=Q.length-1){z.push({name:H,valid:k})}else{if(k){n.end(H)}}}}else{if(H=g[1]){n.comment(H)}else{if(H=g[2]){n.cdata(H)}else{if(H=g[3]){n.doctype(H)}else{if(H=g[4]){n.pi(H,g[5])}}}}}}F=g.index+g[0].length}if(F<D.length){n.text(j(D.substr(F)))}for(P=z.length-1;P>=0;P--){H=z[P];if(H.valid){n.end(H.name)}}}}})(tinymce);(function(d){var c=/^[ \\t\\r\\n]*$/,e={\"#text\":3,\"#comment\":8,\"#cdata\":4,\"#pi\":7,\"#doctype\":10,\"#document-fragment\":11};function a(k,l,j){var i,h,f=j?\"lastChild\":\"firstChild\",g=j?\"prev\":\"next\";if(k[f]){return k[f]}if(k!==l){i=k[g];if(i){return i}for(h=k.parent;h&&h!==l;h=h.parent){i=h[g];if(i){return i}}}}function b(f,g){this.name=f;this.type=g;if(g===1){this.attributes=[];this.attributes.map={}}}d.extend(b.prototype,{replace:function(g){var f=this;if(g.parent){g.remove()}f.insert(g,f);f.remove();return f},attr:function(h,l){var f=this,g,j,k;if(typeof h!==\"string\"){for(j in h){f.attr(j,h[j])}return f}if(g=f.attributes){if(l!==k){if(l===null){if(h in g.map){delete g.map[h];j=g.length;while(j--){if(g[j].name===h){g=g.splice(j,1);return f}}}return f}if(h in g.map){j=g.length;while(j--){if(g[j].name===h){g[j].value=l;break}}}else{g.push({name:h,value:l})}g.map[h]=l;return f}else{return g.map[h]}}},clone:function(){var g=this,n=new b(g.name,g.type),h,f,m,j,k;if(m=g.attributes){k=[];k.map={};for(h=0,f=m.length;h<f;h++){j=m[h];if(j.name!==\"id\"){k[k.length]={name:j.name,value:j.value};k.map[j.name]=j.value}}n.attributes=k}n.value=g.value;n.shortEnded=g.shortEnded;return n},wrap:function(g){var f=this;f.parent.insert(g,f);g.append(f);return f},unwrap:function(){var f=this,h,g;for(h=f.firstChild;h;){g=h.next;f.insert(h,f,true);h=g}f.remove()},remove:function(){var f=this,h=f.parent,g=f.next,i=f.prev;if(h){if(h.firstChild===f){h.firstChild=g;if(g){g.prev=null}}else{i.next=g}if(h.lastChild===f){h.lastChild=i;if(i){i.next=null}}else{g.prev=i}f.parent=f.next=f.prev=null}return f},append:function(h){var f=this,g;if(h.parent){h.remove()}g=f.lastChild;if(g){g.next=h;h.prev=g;f.lastChild=h}else{f.lastChild=f.firstChild=h}h.parent=f;return h},insert:function(h,f,i){var g;if(h.parent){h.remove()}g=f.parent||this;if(i){if(f===g.firstChild){g.firstChild=h}else{f.prev.next=h}h.prev=f.prev;h.next=f;f.prev=h}else{if(f===g.lastChild){g.lastChild=h}else{f.next.prev=h}h.next=f.next;h.prev=f;f.next=h}h.parent=g;return h},getAll:function(g){var f=this,h,i=[];for(h=f.firstChild;h;h=a(h,f)){if(h.name===g){i.push(h)}}return i},empty:function(){var g=this,f,h,j;if(g.firstChild){f=[];for(j=g.firstChild;j;j=a(j,g)){f.push(j)}h=f.length;while(h--){j=f[h];j.parent=j.firstChild=j.lastChild=j.next=j.prev=null}}g.firstChild=g.lastChild=null;return g},isEmpty:function(k){var f=this,j=f.firstChild,h,g;if(j){do{if(j.type===1){if(j.attributes.map[\"data-mce-bogus\"]){continue}if(k[j.name]){return false}h=j.attributes.length;while(h--){g=j.attributes[h].name;if(g===\"name\"||g.indexOf(\"data-\")===0){return false}}}if((j.type===3&&!c.test(j.value))){return false}}while(j=a(j,f))}return true},walk:function(f){return a(this,null,f)}});d.extend(b,{create:function(g,f){var i,h;i=new b(g,e[g]||1);if(f){for(h in f){i.attr(h,f[h])}}return i}});d.html.Node=b})(tinymce);(function(b){var a=b.html.Node;b.html.DomParser=function(g,h){var f=this,e={},d=[],i={},c={};g=g||{};g.validate=\"validate\" in g?g.validate:true;g.root_name=g.root_name||\"body\";f.schema=h=h||new b.html.Schema();function j(m){var o,p,x,v,z,n,q,l,t,u,k,s,y,r;s=b.makeMap(\"tr,td,th,tbody,thead,tfoot,table\");k=h.getNonEmptyElements();for(o=0;o<m.length;o++){p=m[o];if(!p.parent){continue}v=[p];for(x=p.parent;x&&!h.isValidChild(x.name,p.name)&&!s[x.name];x=x.parent){v.push(x)}if(x&&v.length>1){v.reverse();z=n=f.filterNode(v[0].clone());for(t=0;t<v.length-1;t++){if(h.isValidChild(n.name,v[t].name)){q=f.filterNode(v[t].clone());n.append(q)}else{q=n}for(l=v[t].firstChild;l&&l!=v[t+1];){r=l.next;q.append(l);l=r}n=q}if(!z.isEmpty(k)){x.insert(z,v[0],true);x.insert(p,z)}else{x.insert(p,v[0],true)}x=v[0];if(x.isEmpty(k)||x.firstChild===x.lastChild&&x.firstChild.name===\"br\"){x.empty().remove()}}else{if(p.parent){if(p.name===\"li\"){y=p.prev;if(y&&(y.name===\"ul\"||y.name===\"ul\")){y.append(p);continue}y=p.next;if(y&&(y.name===\"ul\"||y.name===\"ul\")){y.insert(p,y.firstChild,true);continue}p.wrap(f.filterNode(new a(\"ul\",1)));continue}if(h.isValidChild(p.parent.name,\"div\")&&h.isValidChild(\"div\",p.name)){p.wrap(f.filterNode(new a(\"div\",1)))}else{if(p.name===\"style\"||p.name===\"script\"){p.empty().remove()}else{p.unwrap()}}}}}}f.filterNode=function(m){var l,k,n;if(k in e){n=i[k];if(n){n.push(m)}else{i[k]=[m]}}l=d.length;while(l--){k=d[l].name;if(k in m.attributes.map){n=c[k];if(n){n.push(m)}else{c[k]=[m]}}}return m};f.addNodeFilter=function(k,l){b.each(b.explode(k),function(m){var n=e[m];if(!n){e[m]=n=[]}n.push(l)})};f.addAttributeFilter=function(k,l){b.each(b.explode(k),function(m){var n;for(n=0;n<d.length;n++){if(d[n].name===m){d[n].callbacks.push(l);return}}d.push({name:m,callbacks:[l]})})};f.parse=function(v,m){var n,H,A,z,C,B,x,r,E,K,y,o,D,J=[],t,k,s,p,u,q;m=m||{};i={};c={};o=b.extend(b.makeMap(\"script,style,head,html,body,title,meta,param\"),h.getBlockElements());u=h.getNonEmptyElements();p=h.children;y=g.validate;q=\"forced_root_block\" in m?m.forced_root_block:g.forced_root_block;s=h.getWhiteSpaceElements();D=/^[ \\t\\r\\n]+/;t=/[ \\t\\r\\n]+$/;k=/[ \\t\\r\\n]+/g;function F(){var L=H.firstChild,l,M;while(L){l=L.next;if(L.type==3||(L.type==1&&L.name!==\"p\"&&!o[L.name]&&!L.attr(\"data-mce-type\"))){if(!M){M=I(q,1);H.insert(M,L);M.append(L)}else{M.append(L)}}else{M=null}L=l}}function I(l,L){var M=new a(l,L),N;if(l in e){N=i[l];if(N){N.push(M)}else{i[l]=[M]}}return M}function G(M){var N,l,L;for(N=M.prev;N&&N.type===3;){l=N.value.replace(t,\"\");if(l.length>0){N.value=l;N=N.prev}else{L=N.prev;N.remove();N=L}}}n=new b.html.SaxParser({validate:y,fix_self_closing:!y,cdata:function(l){A.append(I(\"#cdata\",4)).value=l},text:function(M,l){var L;if(!s[A.name]){M=M.replace(k,\" \");if(A.lastChild&&o[A.lastChild.name]){M=M.replace(D,\"\")}}if(M.length!==0){L=I(\"#text\",3);L.raw=!!l;A.append(L).value=M}},comment:function(l){A.append(I(\"#comment\",8)).value=l},pi:function(l,L){A.append(I(l,7)).value=L;G(A)},doctype:function(L){var l;l=A.append(I(\"#doctype\",10));l.value=L;G(A)},start:function(l,T,M){var R,O,N,L,P,U,S,Q;N=y?h.getElementRule(l):{};if(N){R=I(N.outputName||l,1);R.attributes=T;R.shortEnded=M;A.append(R);Q=p[A.name];if(Q&&p[R.name]&&!Q[R.name]){J.push(R)}O=d.length;while(O--){P=d[O].name;if(P in T.map){E=c[P];if(E){E.push(R)}else{c[P]=[R]}}}if(o[l]){G(R)}if(!M){A=R}}},end:function(l){var P,M,O,L,N;M=y?h.getElementRule(l):{};if(M){if(o[l]){if(!s[A.name]){for(P=A.firstChild;P&&P.type===3;){O=P.value.replace(D,\"\");if(O.length>0){P.value=O;P=P.next}else{L=P.next;P.remove();P=L}}for(P=A.lastChild;P&&P.type===3;){O=P.value.replace(t,\"\");if(O.length>0){P.value=O;P=P.prev}else{L=P.prev;P.remove();P=L}}}P=A.prev;if(P&&P.type===3){O=P.value.replace(D,\"\");if(O.length>0){P.value=O}else{P.remove()}}}if(M.removeEmpty||M.paddEmpty){if(A.isEmpty(u)){if(M.paddEmpty){A.empty().append(new a(\"#text\",\"3\")).value=\"\\u00a0\"}else{if(!A.attributes.map.name){N=A.parent;A.empty().remove();A=N;return}}}}A=A.parent}}},h);H=A=new a(m.context||g.root_name,11);n.parse(v);if(y&&J.length){if(!m.context){j(J)}else{m.invalid=true}}if(q&&H.name==\"body\"){F()}if(!m.invalid){for(K in i){E=e[K];z=i[K];x=z.length;while(x--){if(!z[x].parent){z.splice(x,1)}}for(C=0,B=E.length;C<B;C++){E[C](z,K,m)}}for(C=0,B=d.length;C<B;C++){E=d[C];if(E.name in c){z=c[E.name];x=z.length;while(x--){if(!z[x].parent){z.splice(x,1)}}for(x=0,r=E.callbacks.length;x<r;x++){E.callbacks[x](z,E.name,m)}}}}return H};if(g.remove_trailing_brs){f.addNodeFilter(\"br\",function(n,m){var r,q=n.length,o,u=h.getBlockElements(),k=h.getNonEmptyElements(),s,p,t;u.body=1;for(r=0;r<q;r++){o=n[r];s=o.parent;if(u[o.parent.name]&&o===s.lastChild){p=o.prev;while(p){t=p.name;if(t!==\"span\"||p.attr(\"data-mce-type\")!==\"bookmark\"){if(t!==\"br\"){break}if(t===\"br\"){o=null;break}}p=p.prev}if(o){o.remove();if(s.isEmpty(k)){elementRule=h.getElementRule(s.name);if(elementRule){if(elementRule.removeEmpty){s.remove()}else{if(elementRule.paddEmpty){s.empty().append(new b.html.Node(\"#text\",3)).value=\"\\u00a0\"}}}}}}}})}}})(tinymce);tinymce.html.Writer=function(e){var c=[],a,b,d,f,g;e=e||{};a=e.indent;b=tinymce.makeMap(e.indent_before||\"\");d=tinymce.makeMap(e.indent_after||\"\");f=tinymce.html.Entities.getEncodeFunc(e.entity_encoding||\"raw\",e.entities);g=e.element_format==\"html\";return{start:function(m,k,p){var n,j,h,o;if(a&&b[m]&&c.length>0){o=c[c.length-1];if(o.length>0&&o!==\"\\n\"){c.push(\"\\n\")}}c.push(\"<\",m);if(k){for(n=0,j=k.length;n<j;n++){h=k[n];c.push(\" \",h.name,'=\"',f(h.value,true),'\"')}}if(!p||g){c[c.length]=\">\"}else{c[c.length]=\" />\"}if(p&&a&&d[m]&&c.length>0){o=c[c.length-1];if(o.length>0&&o!==\"\\n\"){c.push(\"\\n\")}}},end:function(h){var i;c.push(\"</\",h,\">\");if(a&&d[h]&&c.length>0){i=c[c.length-1];if(i.length>0&&i!==\"\\n\"){c.push(\"\\n\")}}},text:function(i,h){if(i.length>0){c[c.length]=h?i:f(i)}},cdata:function(h){c.push(\"<![CDATA[\",h,\"]]>\")},comment:function(h){c.push(\"<!--\",h,\"-->\")},pi:function(h,i){if(i){c.push(\"<?\",h,\" \",i,\"?>\")}else{c.push(\"<?\",h,\"?>\")}if(a){c.push(\"\\n\")}},doctype:function(h){c.push(\"<!DOCTYPE\",h,\">\",a?\"\\n\":\"\")},reset:function(){c.length=0},getContent:function(){return c.join(\"\").replace(/\\n$/,\"\")}}};(function(a){a.html.Serializer=function(c,d){var b=this,e=new a.html.Writer(c);c=c||{};c.validate=\"validate\" in c?c.validate:true;b.schema=d=d||new a.html.Schema();b.writer=e;b.serialize=function(h){var g,i;i=c.validate;g={3:function(k,j){e.text(k.value,k.raw)},8:function(j){e.comment(j.value)},7:function(j){e.pi(j.name,j.value)},10:function(j){e.doctype(j.value)},4:function(j){e.cdata(j.value)},11:function(j){if((j=j.firstChild)){do{f(j)}while(j=j.next)}}};e.reset();function f(k){var t=g[k.type],j,o,s,r,p,u,n,m,q;if(!t){j=k.name;o=k.shortEnded;s=k.attributes;if(i&&s&&s.length>1){u=[];u.map={};q=d.getElementRule(k.name);for(n=0,m=q.attributesOrder.length;n<m;n++){r=q.attributesOrder[n];if(r in s.map){p=s.map[r];u.map[r]=p;u.push({name:r,value:p})}}for(n=0,m=s.length;n<m;n++){r=s[n].name;if(!(r in u.map)){p=s.map[r];u.map[r]=p;u.push({name:r,value:p})}}s=u}e.start(k.name,s,o);if(!o){if((k=k.firstChild)){do{f(k)}while(k=k.next)}e.end(j)}}else{t(k)}}if(h.type==1&&!c.inner){f(h)}else{g[11](h)}return e.getContent()}}})(tinymce);(function(h){var f=h.each,e=h.is,d=h.isWebKit,b=h.isIE,c=h.html.Entities,a=/^([a-z0-9],?)+$/i,g=h.html.Schema.blockElementsMap,i=/^[ \\t\\r\\n]*$/;h.create(\"tinymce.dom.DOMUtils\",{doc:null,root:null,files:null,pixelStyles:/^(top|left|bottom|right|width|height|borderWidth)$/,props:{\"for\":\"htmlFor\",\"class\":\"className\",className:\"className\",checked:\"checked\",disabled:\"disabled\",maxlength:\"maxLength\",readonly:\"readOnly\",selected:\"selected\",value:\"value\",id:\"id\",name:\"name\",type:\"type\"},DOMUtils:function(o,m){var l=this,j,k;l.doc=o;l.win=window;l.files={};l.cssFlicker=false;l.counter=0;l.stdMode=!h.isIE||o.documentMode>=8;l.boxModel=!h.isIE||o.compatMode==\"CSS1Compat\"||l.stdMode;l.hasOuterHTML=\"outerHTML\" in o.createElement(\"a\");l.settings=m=h.extend({keep_values:false,hex_colors:1},m);l.schema=m.schema;l.styles=new h.html.Styles({url_converter:m.url_converter,url_converter_scope:m.url_converter_scope},m.schema);if(h.isIE6){try{o.execCommand(\"BackgroundImageCache\",false,true)}catch(n){l.cssFlicker=true}}if(b&&m.schema){(\"abbr article aside audio canvas details figcaption figure footer header hgroup mark menu meter nav output progress section summary time video\").replace(/\\w+/g,function(p){o.createElement(p)});for(k in m.schema.getCustomElements()){o.createElement(k)}}h.addUnload(l.destroy,l)},getRoot:function(){var j=this,k=j.settings;return(k&&j.get(k.root_element))||j.doc.body},getViewPort:function(k){var l,j;k=!k?this.win:k;l=k.document;j=this.boxModel?l.documentElement:l.body;return{x:k.pageXOffset||j.scrollLeft,y:k.pageYOffset||j.scrollTop,w:k.innerWidth||j.clientWidth,h:k.innerHeight||j.clientHeight}},getRect:function(m){var l,j=this,k;m=j.get(m);l=j.getPos(m);k=j.getSize(m);return{x:l.x,y:l.y,w:k.w,h:k.h}},getSize:function(m){var k=this,j,l;m=k.get(m);j=k.getStyle(m,\"width\");l=k.getStyle(m,\"height\");if(j.indexOf(\"px\")===-1){j=0}if(l.indexOf(\"px\")===-1){l=0}return{w:parseInt(j)||m.offsetWidth||m.clientWidth,h:parseInt(l)||m.offsetHeight||m.clientHeight}},getParent:function(l,k,j){return this.getParents(l,k,j,false)},getParents:function(u,p,l,s){var k=this,j,m=k.settings,q=[];u=k.get(u);s=s===undefined;if(m.strict_root){l=l||k.getRoot()}if(e(p,\"string\")){j=p;if(p===\"*\"){p=function(o){return o.nodeType==1}}else{p=function(o){return k.is(o,j)}}}while(u){if(u==l||!u.nodeType||u.nodeType===9){break}if(!p||p(u)){if(s){q.push(u)}else{return u}}u=u.parentNode}return s?q:null},get:function(j){var k;if(j&&this.doc&&typeof(j)==\"string\"){k=j;j=this.doc.getElementById(j);if(j&&j.id!==k){return this.doc.getElementsByName(k)[1]}}return j},getNext:function(k,j){return this._findSib(k,j,\"nextSibling\")},getPrev:function(k,j){return this._findSib(k,j,\"previousSibling\")},add:function(m,q,j,l,o){var k=this;return this.run(m,function(s){var r,n;r=e(q,\"string\")?k.doc.createElement(q):q;k.setAttribs(r,j);if(l){if(l.nodeType){r.appendChild(l)}else{k.setHTML(r,l)}}return !o?s.appendChild(r):r})},create:function(l,j,k){return this.add(this.doc.createElement(l),l,j,k,1)},createHTML:function(r,j,p){var q=\"\",m=this,l;q+=\"<\"+r;for(l in j){if(j.hasOwnProperty(l)){q+=\" \"+l+'=\"'+m.encode(j[l])+'\"'}}if(typeof(p)!=\"undefined\"){return q+\">\"+p+\"</\"+r+\">\"}return q+\" />\"},remove:function(j,k){return this.run(j,function(m){var n,l=m.parentNode;if(!l){return null}if(k){while(n=m.firstChild){if(!h.isIE||n.nodeType!==3||n.nodeValue){l.insertBefore(n,m)}else{m.removeChild(n)}}}return l.removeChild(m)})},setStyle:function(m,j,k){var l=this;return l.run(m,function(p){var o,n;o=p.style;j=j.replace(/-(\\D)/g,function(r,q){return q.toUpperCase()});if(l.pixelStyles.test(j)&&(h.is(k,\"number\")||/^[\\-0-9\\.]+$/.test(k))){k+=\"px\"}switch(j){case\"opacity\":if(b){o.filter=k===\"\"?\"\":\"alpha(opacity=\"+(k*100)+\")\";if(!m.currentStyle||!m.currentStyle.hasLayout){o.display=\"inline-block\"}}o[j]=o[\"-moz-opacity\"]=o[\"-khtml-opacity\"]=k||\"\";break;case\"float\":b?o.styleFloat=k:o.cssFloat=k;break;default:o[j]=k||\"\"}if(l.settings.update_styles){l.setAttrib(p,\"data-mce-style\")}})},getStyle:function(m,j,l){m=this.get(m);if(!m){return}if(this.doc.defaultView&&l){j=j.replace(/[A-Z]/g,function(n){return\"-\"+n});try{return this.doc.defaultView.getComputedStyle(m,null).getPropertyValue(j)}catch(k){return null}}j=j.replace(/-(\\D)/g,function(o,n){return n.toUpperCase()});if(j==\"float\"){j=b?\"styleFloat\":\"cssFloat\"}if(m.currentStyle&&l){return m.currentStyle[j]}return m.style?m.style[j]:undefined},setStyles:function(m,n){var k=this,l=k.settings,j;j=l.update_styles;l.update_styles=0;f(n,function(o,p){k.setStyle(m,p,o)});l.update_styles=j;if(l.update_styles){k.setAttrib(m,l.cssText)}},removeAllAttribs:function(j){return this.run(j,function(m){var l,k=m.attributes;for(l=k.length-1;l>=0;l--){m.removeAttributeNode(k.item(l))}})},setAttrib:function(l,m,j){var k=this;if(!l||!m){return}if(k.settings.strict){m=m.toLowerCase()}return this.run(l,function(o){var n=k.settings;if(j!==null){switch(m){case\"style\":if(!e(j,\"string\")){f(j,function(p,q){k.setStyle(o,q,p)});return}if(n.keep_values){if(j&&!k._isRes(j)){o.setAttribute(\"data-mce-style\",j,2)}else{o.removeAttribute(\"data-mce-style\",2)}}o.style.cssText=j;break;case\"class\":o.className=j||\"\";break;case\"src\":case\"href\":if(n.keep_values){if(n.url_converter){j=n.url_converter.call(n.url_converter_scope||k,j,m,o)}k.setAttrib(o,\"data-mce-\"+m,j,2)}break;case\"shape\":o.setAttribute(\"data-mce-style\",j);break}}if(e(j)&&j!==null&&j.length!==0){o.setAttribute(m,\"\"+j,2)}else{o.removeAttribute(m,2)}})},setAttribs:function(k,l){var j=this;return this.run(k,function(m){f(l,function(o,p){j.setAttrib(m,p,o)})})},getAttrib:function(o,p,l){var j,k=this,m;o=k.get(o);if(!o||o.nodeType!==1){return l===m?false:l}if(!e(l)){l=\"\"}if(/^(src|href|style|coords|shape)$/.test(p)){j=o.getAttribute(\"data-mce-\"+p);if(j){return j}}if(b&&k.props[p]){j=o[k.props[p]];j=j&&j.nodeValue?j.nodeValue:j}if(!j){j=o.getAttribute(p,2)}if(/^(checked|compact|declare|defer|disabled|ismap|multiple|nohref|noshade|nowrap|readonly|selected)$/.test(p)){if(o[k.props[p]]===true&&j===\"\"){return p}return j?p:\"\"}if(o.nodeName===\"FORM\"&&o.getAttributeNode(p)){return o.getAttributeNode(p).nodeValue}if(p===\"style\"){j=j||o.style.cssText;if(j){j=k.serializeStyle(k.parseStyle(j),o.nodeName);if(k.settings.keep_values&&!k._isRes(j)){o.setAttribute(\"data-mce-style\",j)}}}if(d&&p===\"class\"&&j){j=j.replace(/(apple|webkit)\\-[a-z\\-]+/gi,\"\")}if(b){switch(p){case\"rowspan\":case\"colspan\":if(j===1){j=\"\"}break;case\"size\":if(j===\"+0\"||j===20||j===0){j=\"\"}break;case\"width\":case\"height\":case\"vspace\":case\"checked\":case\"disabled\":case\"readonly\":if(j===0){j=\"\"}break;case\"hspace\":if(j===-1){j=\"\"}break;case\"maxlength\":case\"tabindex\":if(j===32768||j===2147483647||j===\"32768\"){j=\"\"}break;case\"multiple\":case\"compact\":case\"noshade\":case\"nowrap\":if(j===65535){return p}return l;case\"shape\":j=j.toLowerCase();break;default:if(p.indexOf(\"on\")===0&&j){j=h._replace(/^function\\s+\\w+\\(\\)\\s+\\{\\s+(.*)\\s+\\}$/,\"$1\",\"\"+j)}}}return(j!==m&&j!==null&&j!==\"\")?\"\"+j:l},getPos:function(s,m){var k=this,j=0,q=0,o,p=k.doc,l;s=k.get(s);m=m||p.body;if(s){if(s.getBoundingClientRect){s=s.getBoundingClientRect();o=k.boxModel?p.documentElement:p.body;j=s.left+(p.documentElement.scrollLeft||p.body.scrollLeft)-o.clientTop;q=s.top+(p.documentElement.scrollTop||p.body.scrollTop)-o.clientLeft;return{x:j,y:q}}l=s;while(l&&l!=m&&l.nodeType){j+=l.offsetLeft||0;q+=l.offsetTop||0;l=l.offsetParent}l=s.parentNode;while(l&&l!=m&&l.nodeType){j-=l.scrollLeft||0;q-=l.scrollTop||0;l=l.parentNode}}return{x:j,y:q}},parseStyle:function(j){return this.styles.parse(j)},serializeStyle:function(k,j){return this.styles.serialize(k,j)},loadCSS:function(j){var l=this,m=l.doc,k;if(!j){j=\"\"}k=l.select(\"head\")[0];f(j.split(\",\"),function(n){var o;if(l.files[n]){return}l.files[n]=true;o=l.create(\"link\",{rel:\"stylesheet\",href:h._addVer(n)});if(b&&m.documentMode&&m.recalc){o.onload=function(){if(m.recalc){m.recalc()}o.onload=null}}k.appendChild(o)})},addClass:function(j,k){return this.run(j,function(l){var m;if(!k){return 0}if(this.hasClass(l,k)){return l.className}m=this.removeClass(l,k);return l.className=(m!=\"\"?(m+\" \"):\"\")+k})},removeClass:function(l,m){var j=this,k;return j.run(l,function(o){var n;if(j.hasClass(o,m)){if(!k){k=new RegExp(\"(^|\\\\s+)\"+m+\"(\\\\s+|$)\",\"g\")}n=o.className.replace(k,\" \");n=h.trim(n!=\" \"?n:\"\");o.className=n;if(!n){o.removeAttribute(\"class\");o.removeAttribute(\"className\")}return n}return o.className})},hasClass:function(k,j){k=this.get(k);if(!k||!j){return false}return(\" \"+k.className+\" \").indexOf(\" \"+j+\" \")!==-1},show:function(j){return this.setStyle(j,\"display\",\"block\")},hide:function(j){return this.setStyle(j,\"display\",\"none\")},isHidden:function(j){j=this.get(j);return !j||j.style.display==\"none\"||this.getStyle(j,\"display\")==\"none\"},uniqueId:function(j){return(!j?\"mce_\":j)+(this.counter++)},setHTML:function(l,k){var j=this;return j.run(l,function(n){if(b){while(n.firstChild){n.removeChild(n.firstChild)}try{n.innerHTML=\"<br />\"+k;n.removeChild(n.firstChild)}catch(m){n=j.create(\"div\");n.innerHTML=\"<br />\"+k;f(n.childNodes,function(p,o){if(o){n.appendChild(p)}})}}else{n.innerHTML=k}return k})},getOuterHTML:function(l){var k,j=this;l=j.get(l);if(!l){return null}if(l.nodeType===1&&j.hasOuterHTML){return l.outerHTML}k=(l.ownerDocument||j.doc).createElement(\"body\");k.appendChild(l.cloneNode(true));return k.innerHTML},setOuterHTML:function(m,k,n){var j=this;function l(p,o,r){var s,q;q=r.createElement(\"body\");q.innerHTML=o;s=q.lastChild;while(s){j.insertAfter(s.cloneNode(true),p);s=s.previousSibling}j.remove(p)}return this.run(m,function(p){p=j.get(p);if(p.nodeType==1){n=n||p.ownerDocument||j.doc;if(b){try{if(b&&p.nodeType==1){p.outerHTML=k}else{l(p,k,n)}}catch(o){l(p,k,n)}}else{l(p,k,n)}}})},decode:c.decode,encode:c.encodeAllRaw,insertAfter:function(j,k){k=this.get(k);return this.run(j,function(m){var l,n;l=k.parentNode;n=k.nextSibling;if(n){l.insertBefore(m,n)}else{l.appendChild(m)}return m})},isBlock:function(k){var j=k.nodeType;if(j){return !!(j===1&&g[k.nodeName])}return !!g[k]},replace:function(p,m,j){var l=this;if(e(m,\"array\")){p=p.cloneNode(true)}return l.run(m,function(k){if(j){f(h.grep(k.childNodes),function(n){p.appendChild(n)})}return k.parentNode.replaceChild(p,k)})},rename:function(m,j){var l=this,k;if(m.nodeName!=j.toUpperCase()){k=l.create(j);f(l.getAttribs(m),function(n){l.setAttrib(k,n.nodeName,l.getAttrib(m,n.nodeName))});l.replace(k,m,1)}return k||m},findCommonAncestor:function(l,j){var m=l,k;while(m){k=j;while(k&&m!=k){k=k.parentNode}if(m==k){break}m=m.parentNode}if(!m&&l.ownerDocument){return l.ownerDocument.documentElement}return m},toHex:function(j){var l=/^\\s*rgb\\s*?\\(\\s*?([0-9]+)\\s*?,\\s*?([0-9]+)\\s*?,\\s*?([0-9]+)\\s*?\\)\\s*$/i.exec(j);function k(m){m=parseInt(m).toString(16);return m.length>1?m:\"0\"+m}if(l){j=\"#\"+k(l[1])+k(l[2])+k(l[3]);return j}return j},getClasses:function(){var n=this,j=[],m,o={},p=n.settings.class_filter,l;if(n.classes){return n.classes}function q(r){f(r.imports,function(s){q(s)});f(r.cssRules||r.rules,function(s){switch(s.type||1){case 1:if(s.selectorText){f(s.selectorText.split(\",\"),function(t){t=t.replace(/^\\s*|\\s*$|^\\s\\./g,\"\");if(/\\.mce/.test(t)||!/\\.[\\w\\-]+$/.test(t)){return}l=t;t=h._replace(/.*\\.([a-z0-9_\\-]+).*/i,\"$1\",t);if(p&&!(t=p(t,l))){return}if(!o[t]){j.push({\"class\":t});o[t]=1}})}break;case 3:q(s.styleSheet);break}})}try{f(n.doc.styleSheets,q)}catch(k){}if(j.length>0){n.classes=j}return j},run:function(m,l,k){var j=this,n;if(j.doc&&typeof(m)===\"string\"){m=j.get(m)}if(!m){return false}k=k||this;if(!m.nodeType&&(m.length||m.length===0)){n=[];f(m,function(p,o){if(p){if(typeof(p)==\"string\"){p=j.doc.getElementById(p)}n.push(l.call(k,p,o))}});return n}return l.call(k,m)},getAttribs:function(k){var j;k=this.get(k);if(!k){return[]}if(b){j=[];if(k.nodeName==\"OBJECT\"){return k.attributes}if(k.nodeName===\"OPTION\"&&this.getAttrib(k,\"selected\")){j.push({specified:1,nodeName:\"selected\"})}k.cloneNode(false).outerHTML.replace(/<\\/?[\\w:\\-]+ ?|=[\\\"][^\\\"]+\\\"|=\\'[^\\']+\\'|=[\\w\\-]+|>/gi,\"\").replace(/[\\w:\\-]+/gi,function(l){j.push({specified:1,nodeName:l})});return j}return k.attributes},isEmpty:function(m,k){var r=this,o,n,q,j,l,p;m=m.firstChild;if(m){j=new h.dom.TreeWalker(m);k=k||r.schema?r.schema.getNonEmptyElements():null;do{q=m.nodeType;if(q===1){if(m.getAttribute(\"data-mce-bogus\")){continue}l=m.nodeName.toLowerCase();if(k&&k[l]){p=m.parentNode;if(l===\"br\"&&r.isBlock(p)&&p.firstChild===m&&p.lastChild===m){continue}return false}n=r.getAttribs(m);o=m.attributes.length;while(o--){l=m.attributes[o].nodeName;if(l===\"name\"||l===\"data-mce-bookmark\"){return false}}}if((q===3&&!i.test(m.nodeValue))){return false}}while(m=j.next())}return true},destroy:function(k){var j=this;if(j.events){j.events.destroy()}j.win=j.doc=j.root=j.events=null;if(!k){h.removeUnload(j.destroy)}},createRng:function(){var j=this.doc;return j.createRange?j.createRange():new h.dom.Range(this)},nodeIndex:function(n,o){var j=0,l,m,k;if(n){for(l=n.nodeType,n=n.previousSibling,m=n;n;n=n.previousSibling){k=n.nodeType;if(o&&k==3){if(k==l||!n.nodeValue.length){continue}}j++;l=k}}return j},split:function(n,m,q){var s=this,j=s.createRng(),o,l,p;function k(v){var t,r=v.childNodes,u=v.nodeType;if(u==1&&v.getAttribute(\"data-mce-type\")==\"bookmark\"){return}for(t=r.length-1;t>=0;t--){k(r[t])}if(u!=9){if(u==3&&v.nodeValue.length>0){if(!s.isBlock(v.parentNode)||h.trim(v.nodeValue).length>0){return}}else{if(u==1){r=v.childNodes;if(r.length==1&&r[0]&&r[0].nodeType==1&&r[0].getAttribute(\"data-mce-type\")==\"bookmark\"){v.parentNode.insertBefore(r[0],v)}if(r.length||/^(br|hr|input|img)$/i.test(v.nodeName)){return}}}s.remove(v)}return v}if(n&&m){j.setStart(n.parentNode,s.nodeIndex(n));j.setEnd(m.parentNode,s.nodeIndex(m));o=j.extractContents();j=s.createRng();j.setStart(m.parentNode,s.nodeIndex(m)+1);j.setEnd(n.parentNode,s.nodeIndex(n)+1);l=j.extractContents();p=n.parentNode;p.insertBefore(k(o),n);if(q){p.replaceChild(q,m)}else{p.insertBefore(m,n)}p.insertBefore(k(l),n);s.remove(n);return q||m}},bind:function(n,j,m,l){var k=this;if(!k.events){k.events=new h.dom.EventUtils()}return k.events.add(n,j,m,l||this)},unbind:function(m,j,l){var k=this;if(!k.events){k.events=new h.dom.EventUtils()}return k.events.remove(m,j,l)},_findSib:function(m,j,k){var l=this,n=j;if(m){if(e(n,\"string\")){n=function(o){return l.is(o,j)}}for(m=m[k];m;m=m[k]){if(n(m)){return m}}}return null},_isRes:function(j){return/^(top|left|bottom|right|width|height)/i.test(j)||/;\\s*(top|left|bottom|right|width|height)/i.test(j)}});h.DOM=new h.dom.DOMUtils(document,{process_html:0})})(tinymce);(function(a){function b(c){var N=this,e=c.doc,S=0,E=1,j=2,D=true,R=false,U=\"startOffset\",h=\"startContainer\",P=\"endContainer\",z=\"endOffset\",k=tinymce.extend,n=c.nodeIndex;k(N,{startContainer:e,startOffset:0,endContainer:e,endOffset:0,collapsed:D,commonAncestorContainer:e,START_TO_START:0,START_TO_END:1,END_TO_END:2,END_TO_START:3,setStart:q,setEnd:s,setStartBefore:g,setStartAfter:I,setEndBefore:J,setEndAfter:u,collapse:A,selectNode:x,selectNodeContents:F,compareBoundaryPoints:v,deleteContents:p,extractContents:H,cloneContents:d,insertNode:C,surroundContents:M,cloneRange:K});function q(V,t){B(D,V,t)}function s(V,t){B(R,V,t)}function g(t){q(t.parentNode,n(t))}function I(t){q(t.parentNode,n(t)+1)}function J(t){s(t.parentNode,n(t))}function u(t){s(t.parentNode,n(t)+1)}function A(t){if(t){N[P]=N[h];N[z]=N[U]}else{N[h]=N[P];N[U]=N[z]}N.collapsed=D}function x(t){g(t);u(t)}function F(t){q(t,0);s(t,t.nodeType===1?t.childNodes.length:t.nodeValue.length)}function v(Y,t){var ab=N[h],W=N[U],aa=N[P],V=N[z],Z=t.startContainer,ad=t.startOffset,X=t.endContainer,ac=t.endOffset;if(Y===0){return G(ab,W,Z,ad)}if(Y===1){return G(aa,V,Z,ad)}if(Y===2){return G(aa,V,X,ac)}if(Y===3){return G(ab,W,X,ac)}}function p(){m(j)}function H(){return m(S)}function d(){return m(E)}function C(Y){var V=this[h],t=this[U],X,W;if((V.nodeType===3||V.nodeType===4)&&V.nodeValue){if(!t){V.parentNode.insertBefore(Y,V)}else{if(t>=V.nodeValue.length){c.insertAfter(Y,V)}else{X=V.splitText(t);V.parentNode.insertBefore(Y,X)}}}else{if(V.childNodes.length>0){W=V.childNodes[t]}if(W){V.insertBefore(Y,W)}else{V.appendChild(Y)}}}function M(V){var t=N.extractContents();N.insertNode(V);V.appendChild(t);N.selectNode(V)}function K(){return k(new b(c),{startContainer:N[h],startOffset:N[U],endContainer:N[P],endOffset:N[z],collapsed:N.collapsed,commonAncestorContainer:N.commonAncestorContainer})}function O(t,V){var W;if(t.nodeType==3){return t}if(V<0){return t}W=t.firstChild;while(W&&V>0){--V;W=W.nextSibling}if(W){return W}return t}function l(){return(N[h]==N[P]&&N[U]==N[z])}function G(X,Z,V,Y){var aa,W,t,ab,ad,ac;if(X==V){if(Z==Y){return 0}if(Z<Y){return -1}return 1}aa=V;while(aa&&aa.parentNode!=X){aa=aa.parentNode}if(aa){W=0;t=X.firstChild;while(t!=aa&&W<Z){W++;t=t.nextSibling}if(Z<=W){return -1}return 1}aa=X;while(aa&&aa.parentNode!=V){aa=aa.parentNode}if(aa){W=0;t=V.firstChild;while(t!=aa&&W<Y){W++;t=t.nextSibling}if(W<Y){return -1}return 1}ab=c.findCommonAncestor(X,V);ad=X;while(ad&&ad.parentNode!=ab){ad=ad.parentNode}if(!ad){ad=ab}ac=V;while(ac&&ac.parentNode!=ab){ac=ac.parentNode}if(!ac){ac=ab}if(ad==ac){return 0}t=ab.firstChild;while(t){if(t==ad){return -1}if(t==ac){return 1}t=t.nextSibling}}function B(V,Y,X){var t,W;if(V){N[h]=Y;N[U]=X}else{N[P]=Y;N[z]=X}t=N[P];while(t.parentNode){t=t.parentNode}W=N[h];while(W.parentNode){W=W.parentNode}if(W==t){if(G(N[h],N[U],N[P],N[z])>0){N.collapse(V)}}else{N.collapse(V)}N.collapsed=l();N.commonAncestorContainer=c.findCommonAncestor(N[h],N[P])}function m(ab){var aa,X=0,ad=0,V,Z,W,Y,t,ac;if(N[h]==N[P]){return f(ab)}for(aa=N[P],V=aa.parentNode;V;aa=V,V=V.parentNode){if(V==N[h]){return r(aa,ab)}++X}for(aa=N[h],V=aa.parentNode;V;aa=V,V=V.parentNode){if(V==N[P]){return T(aa,ab)}++ad}Z=ad-X;W=N[h];while(Z>0){W=W.parentNode;Z--}Y=N[P];while(Z<0){Y=Y.parentNode;Z++}for(t=W.parentNode,ac=Y.parentNode;t!=ac;t=t.parentNode,ac=ac.parentNode){W=t;Y=ac}return o(W,Y,ab)}function f(Z){var ab,Y,X,aa,t,W,V;if(Z!=j){ab=e.createDocumentFragment()}if(N[U]==N[z]){return ab}if(N[h].nodeType==3){Y=N[h].nodeValue;X=Y.substring(N[U],N[z]);if(Z!=E){N[h].deleteData(N[U],N[z]-N[U]);N.collapse(D)}if(Z==j){return}ab.appendChild(e.createTextNode(X));return ab}aa=O(N[h],N[U]);t=N[z]-N[U];while(t>0){W=aa.nextSibling;V=y(aa,Z);if(ab){ab.appendChild(V)}--t;aa=W}if(Z!=E){N.collapse(D)}return ab}function r(ab,Y){var aa,Z,V,t,X,W;if(Y!=j){aa=e.createDocumentFragment()}Z=i(ab,Y);if(aa){aa.appendChild(Z)}V=n(ab);t=V-N[U];if(t<=0){if(Y!=E){N.setEndBefore(ab);N.collapse(R)}return aa}Z=ab.previousSibling;while(t>0){X=Z.previousSibling;W=y(Z,Y);if(aa){aa.insertBefore(W,aa.firstChild)}--t;Z=X}if(Y!=E){N.setEndBefore(ab);N.collapse(R)}return aa}function T(Z,Y){var ab,V,aa,t,X,W;if(Y!=j){ab=e.createDocumentFragment()}aa=Q(Z,Y);if(ab){ab.appendChild(aa)}V=n(Z);++V;t=N[z]-V;aa=Z.nextSibling;while(t>0){X=aa.nextSibling;W=y(aa,Y);if(ab){ab.appendChild(W)}--t;aa=X}if(Y!=E){N.setStartAfter(Z);N.collapse(D)}return ab}function o(Z,t,ac){var W,ae,Y,aa,ab,V,ad,X;if(ac!=j){ae=e.createDocumentFragment()}W=Q(Z,ac);if(ae){ae.appendChild(W)}Y=Z.parentNode;aa=n(Z);ab=n(t);++aa;V=ab-aa;ad=Z.nextSibling;while(V>0){X=ad.nextSibling;W=y(ad,ac);if(ae){ae.appendChild(W)}ad=X;--V}W=i(t,ac);if(ae){ae.appendChild(W)}if(ac!=E){N.setStartAfter(Z);N.collapse(D)}return ae}function i(aa,ab){var W=O(N[P],N[z]-1),ac,Z,Y,t,V,X=W!=N[P];if(W==aa){return L(W,X,R,ab)}ac=W.parentNode;Z=L(ac,R,R,ab);while(ac){while(W){Y=W.previousSibling;t=L(W,X,R,ab);if(ab!=j){Z.insertBefore(t,Z.firstChild)}X=D;W=Y}if(ac==aa){return Z}W=ac.previousSibling;ac=ac.parentNode;V=L(ac,R,R,ab);if(ab!=j){V.appendChild(Z)}Z=V}}function Q(aa,ab){var X=O(N[h],N[U]),Y=X!=N[h],ac,Z,W,t,V;if(X==aa){return L(X,Y,D,ab)}ac=X.parentNode;Z=L(ac,R,D,ab);while(ac){while(X){W=X.nextSibling;t=L(X,Y,D,ab);if(ab!=j){Z.appendChild(t)}Y=D;X=W}if(ac==aa){return Z}X=ac.nextSibling;ac=ac.parentNode;V=L(ac,R,D,ab);if(ab!=j){V.appendChild(Z)}Z=V}}function L(t,Y,ab,ac){var X,W,Z,V,aa;if(Y){return y(t,ac)}if(t.nodeType==3){X=t.nodeValue;if(ab){V=N[U];W=X.substring(V);Z=X.substring(0,V)}else{V=N[z];W=X.substring(0,V);Z=X.substring(V)}if(ac!=E){t.nodeValue=Z}if(ac==j){return}aa=t.cloneNode(R);aa.nodeValue=W;return aa}if(ac==j){return}return t.cloneNode(R)}function y(V,t){if(t!=j){return t==E?V.cloneNode(D):V}V.parentNode.removeChild(V)}}a.Range=b})(tinymce.dom);(function(){function a(d){var b=this,h=d.dom,c=true,f=false;function e(i,j){var k,t=0,q,n,m,l,o,r,p=-1,s;k=i.duplicate();k.collapse(j);s=k.parentElement();if(s.ownerDocument!==d.dom.doc){return}while(s.contentEditable===\"false\"){s=s.parentNode}if(!s.hasChildNodes()){return{node:s,inside:1}}m=s.children;q=m.length-1;while(t<=q){r=Math.floor((t+q)/2);l=m[r];k.moveToElementText(l);p=k.compareEndPoints(j?\"StartToStart\":\"EndToEnd\",i);if(p>0){q=r-1}else{if(p<0){t=r+1}else{return{node:l}}}}if(p<0){if(!l){k.moveToElementText(s);k.collapse(true);l=s;n=true}else{k.collapse(false)}k.setEndPoint(j?\"EndToStart\":\"EndToEnd\",i);if(k.compareEndPoints(j?\"StartToStart\":\"StartToEnd\",i)>0){k=i.duplicate();k.collapse(j);o=-1;while(s==k.parentElement()){if(k.move(\"character\",-1)==0){break}o++}}o=o||k.text.replace(\"\\r\\n\",\" \").length}else{k.collapse(true);k.setEndPoint(j?\"StartToStart\":\"StartToEnd\",i);o=k.text.replace(\"\\r\\n\",\" \").length}return{node:l,position:p,offset:o,inside:n}}function g(){var i=d.getRng(),r=h.createRng(),l,k,p,q,m,j;l=i.item?i.item(0):i.parentElement();if(l.ownerDocument!=h.doc){return r}k=d.isCollapsed();if(i.item){r.setStart(l.parentNode,h.nodeIndex(l));r.setEnd(r.startContainer,r.startOffset+1);return r}function o(A){var u=e(i,A),s,y,z=0,x,v,t;s=u.node;y=u.offset;if(u.inside&&!s.hasChildNodes()){r[A?\"setStart\":\"setEnd\"](s,0);return}if(y===v){r[A?\"setStartBefore\":\"setEndAfter\"](s);return}if(u.position<0){x=u.inside?s.firstChild:s.nextSibling;if(!x){r[A?\"setStartAfter\":\"setEndAfter\"](s);return}if(!y){if(x.nodeType==3){r[A?\"setStart\":\"setEnd\"](x,0)}else{r[A?\"setStartBefore\":\"setEndBefore\"](x)}return}while(x){t=x.nodeValue;z+=t.length;if(z>=y){s=x;z-=y;z=t.length-z;break}x=x.nextSibling}}else{x=s.previousSibling;if(!x){return r[A?\"setStartBefore\":\"setEndBefore\"](s)}if(!y){if(s.nodeType==3){r[A?\"setStart\":\"setEnd\"](x,s.nodeValue.length)}else{r[A?\"setStartAfter\":\"setEndAfter\"](x)}return}while(x){z+=x.nodeValue.length;if(z>=y){s=x;z-=y;break}x=x.previousSibling}}r[A?\"setStart\":\"setEnd\"](s,z)}try{o(true);if(!k){o()}}catch(n){if(n.number==-2147024809){m=b.getBookmark(2);p=i.duplicate();p.collapse(true);l=p.parentElement();if(!k){p=i.duplicate();p.collapse(false);q=p.parentElement();q.innerHTML=q.innerHTML}l.innerHTML=l.innerHTML;b.moveToBookmark(m);i=d.getRng();o(true);if(!k){o()}}else{throw n}}return r}this.getBookmark=function(m){var j=d.getRng(),o,i,l={};function n(u){var u,t,p,s,r,q=[];t=u.parentNode;p=h.getRoot().parentNode;while(t!=p&&t.nodeType!==9){s=t.children;r=s.length;while(r--){if(u===s[r]){q.push(r);break}}u=t;t=t.parentNode}return q}function k(q){var p;p=e(j,q);if(p){return{position:p.position,offset:p.offset,indexes:n(p.node),inside:p.inside}}}if(m===2){if(!j.item){l.start=k(true);if(!d.isCollapsed()){l.end=k()}}else{l.start={ctrl:true,indexes:n(j.item(0))}}}return l};this.moveToBookmark=function(k){var j,i=h.doc.body;function m(o){var r,q,n,p;r=h.getRoot();for(q=o.length-1;q>=0;q--){p=r.children;n=o[q];if(n<=p.length-1){r=p[n]}}return r}function l(r){var n=k[r?\"start\":\"end\"],q,p,o;if(n){q=n.position>0;p=i.createTextRange();p.moveToElementText(m(n.indexes));offset=n.offset;if(offset!==o){p.collapse(n.inside||q);p.moveStart(\"character\",q?-offset:offset)}else{p.collapse(r)}j.setEndPoint(r?\"StartToStart\":\"EndToStart\",p);if(r){j.collapse(true)}}}if(k.start){if(k.start.ctrl){j=i.createControlRange();j.addElement(m(k.start.indexes));j.select()}else{j=i.createTextRange();l(true);l();j.select()}}};this.addRange=function(i){var n,l,k,p,s,q,r=d.dom.doc,m=r.body;function j(z){var u,y,t,x,v;t=h.create(\"a\");u=z?k:s;y=z?p:q;x=n.duplicate();if(u==r||u==r.documentElement){u=m;y=0}if(u.nodeType==3){u.parentNode.insertBefore(t,u);x.moveToElementText(t);x.moveStart(\"character\",y);h.remove(t);n.setEndPoint(z?\"StartToStart\":\"EndToEnd\",x)}else{v=u.childNodes;if(v.length){if(y>=v.length){h.insertAfter(t,v[v.length-1])}else{u.insertBefore(t,v[y])}x.moveToElementText(t)}else{t=r.createTextNode(\"\\uFEFF\");u.appendChild(t);x.moveToElementText(t.parentNode);x.collapse(c)}n.setEndPoint(z?\"StartToStart\":\"EndToEnd\",x);h.remove(t)}}k=i.startContainer;p=i.startOffset;s=i.endContainer;q=i.endOffset;n=m.createTextRange();if(k==s&&k.nodeType==1&&p==q-1){if(p==q-1){try{l=m.createControlRange();l.addElement(k.childNodes[p]);l.select();return}catch(o){}}}j(true);j();n.select()};this.getRangeAt=g}tinymce.dom.TridentSelection=a})();(function(d){var f=d.each,c=d.DOM,b=d.isIE,e=d.isWebKit,a;d.create(\"tinymce.dom.EventUtils\",{EventUtils:function(){this.inits=[];this.events=[]},add:function(m,p,l,j){var g,h=this,i=h.events,k;if(p instanceof Array){k=[];f(p,function(o){k.push(h.add(m,o,l,j))});return k}if(m&&m.hasOwnProperty&&m instanceof Array){k=[];f(m,function(n){n=c.get(n);k.push(h.add(n,p,l,j))});return k}m=c.get(m);if(!m){return}g=function(n){if(h.disabled){return}n=n||window.event;if(n&&b){if(!n.target){n.target=n.srcElement}d.extend(n,h._stoppers)}if(!j){return l(n)}return l.call(j,n)};if(p==\"unload\"){d.unloads.unshift({func:g});return g}if(p==\"init\"){if(h.domLoaded){g()}else{h.inits.push(g)}return g}i.push({obj:m,name:p,func:l,cfunc:g,scope:j});h._add(m,p,g);return l},remove:function(l,m,k){var h=this,g=h.events,i=false,j;if(l&&l.hasOwnProperty&&l instanceof Array){j=[];f(l,function(n){n=c.get(n);j.push(h.remove(n,m,k))});return j}l=c.get(l);f(g,function(o,n){if(o.obj==l&&o.name==m&&(!k||(o.func==k||o.cfunc==k))){g.splice(n,1);h._remove(l,m,o.cfunc);i=true;return false}});return i},clear:function(l){var j=this,g=j.events,h,k;if(l){l=c.get(l);for(h=g.length-1;h>=0;h--){k=g[h];if(k.obj===l){j._remove(k.obj,k.name,k.cfunc);k.obj=k.cfunc=null;g.splice(h,1)}}}},cancel:function(g){if(!g){return false}this.stop(g);return this.prevent(g)},stop:function(g){if(g.stopPropagation){g.stopPropagation()}else{g.cancelBubble=true}return false},prevent:function(g){if(g.preventDefault){g.preventDefault()}else{g.returnValue=false}return false},destroy:function(){var g=this;f(g.events,function(j,h){g._remove(j.obj,j.name,j.cfunc);j.obj=j.cfunc=null});g.events=[];g=null},_add:function(h,i,g){if(h.attachEvent){h.attachEvent(\"on\"+i,g)}else{if(h.addEventListener){h.addEventListener(i,g,false)}else{h[\"on\"+i]=g}}},_remove:function(i,j,h){if(i){try{if(i.detachEvent){i.detachEvent(\"on\"+j,h)}else{if(i.removeEventListener){i.removeEventListener(j,h,false)}else{i[\"on\"+j]=null}}}catch(g){}}},_pageInit:function(h){var g=this;if(g.domLoaded){return}g.domLoaded=true;f(g.inits,function(i){i()});g.inits=[]},_wait:function(i){var g=this,h=i.document;if(i.tinyMCE_GZ&&tinyMCE_GZ.loaded){g.domLoaded=1;return}if(h.attachEvent){h.attachEvent(\"onreadystatechange\",function(){if(h.readyState===\"complete\"){h.detachEvent(\"onreadystatechange\",arguments.callee);g._pageInit(i)}});if(h.documentElement.doScroll&&i==i.top){(function(){if(g.domLoaded){return}try{h.documentElement.doScroll(\"left\")}catch(j){setTimeout(arguments.callee,0);return}g._pageInit(i)})()}}else{if(h.addEventListener){g._add(i,\"DOMContentLoaded\",function(){g._pageInit(i)})}}g._add(i,\"load\",function(){g._pageInit(i)})},_stoppers:{preventDefault:function(){this.returnValue=false},stopPropagation:function(){this.cancelBubble=true}}});a=d.dom.Event=new d.dom.EventUtils();a._wait(window);d.addUnload(function(){a.destroy()})})(tinymce);(function(a){a.dom.Element=function(f,d){var b=this,e,c;b.settings=d=d||{};b.id=f;b.dom=e=d.dom||a.DOM;if(!a.isIE){c=e.get(b.id)}a.each((\"getPos,getRect,getParent,add,setStyle,getStyle,setStyles,setAttrib,setAttribs,getAttrib,addClass,removeClass,hasClass,getOuterHTML,setOuterHTML,remove,show,hide,isHidden,setHTML,get\").split(/,/),function(g){b[g]=function(){var h=[f],j;for(j=0;j<arguments.length;j++){h.push(arguments[j])}h=e[g].apply(e,h);b.update(g);return h}});a.extend(b,{on:function(i,h,g){return a.dom.Event.add(b.id,i,h,g)},getXY:function(){return{x:parseInt(b.getStyle(\"left\")),y:parseInt(b.getStyle(\"top\"))}},getSize:function(){var g=e.get(b.id);return{w:parseInt(b.getStyle(\"width\")||g.clientWidth),h:parseInt(b.getStyle(\"height\")||g.clientHeight)}},moveTo:function(g,h){b.setStyles({left:g,top:h})},moveBy:function(g,i){var h=b.getXY();b.moveTo(h.x+g,h.y+i)},resizeTo:function(g,i){b.setStyles({width:g,height:i})},resizeBy:function(g,j){var i=b.getSize();b.resizeTo(i.w+g,i.h+j)},update:function(h){var g;if(a.isIE6&&d.blocker){h=h||\"\";if(h.indexOf(\"get\")===0||h.indexOf(\"has\")===0||h.indexOf(\"is\")===0){return}if(h==\"remove\"){e.remove(b.blocker);return}if(!b.blocker){b.blocker=e.uniqueId();g=e.add(d.container||e.getRoot(),\"iframe\",{id:b.blocker,style:\"position:absolute;\",frameBorder:0,src:'javascript:\"\"'});e.setStyle(g,\"opacity\",0)}else{g=e.get(b.blocker)}e.setStyles(g,{left:b.getStyle(\"left\",1),top:b.getStyle(\"top\",1),width:b.getStyle(\"width\",1),height:b.getStyle(\"height\",1),display:b.getStyle(\"display\",1),zIndex:parseInt(b.getStyle(\"zIndex\",1)||0)-1})}}})}})(tinymce);(function(c){function e(f){return f.replace(/[\\n\\r]+/g,\"\")}var b=c.is,a=c.isIE,d=c.each;c.create(\"tinymce.dom.Selection\",{Selection:function(i,h,g){var f=this;f.dom=i;f.win=h;f.serializer=g;d([\"onBeforeSetContent\",\"onBeforeGetContent\",\"onSetContent\",\"onGetContent\"],function(j){f[j]=new c.util.Dispatcher(f)});if(!f.win.getSelection){f.tridentSel=new c.dom.TridentSelection(f)}if(c.isIE&&i.boxModel){this._fixIESelection()}c.addUnload(f.destroy,f)},setCursorLocation:function(h,i){var f=this;var g=f.dom.createRng();g.setStart(h,i);g.setEnd(h,i);f.setRng(g);f.collapse(false)},getContent:function(g){var f=this,h=f.getRng(),l=f.dom.create(\"body\"),j=f.getSel(),i,k,m;g=g||{};i=k=\"\";g.get=true;g.format=g.format||\"html\";g.forced_root_block=\"\";f.onBeforeGetContent.dispatch(f,g);if(g.format==\"text\"){return f.isCollapsed()?\"\":(h.text||(j.toString?j.toString():\"\"))}if(h.cloneContents){m=h.cloneContents();if(m){l.appendChild(m)}}else{if(b(h.item)||b(h.htmlText)){l.innerHTML=\"<br>\"+(h.item?h.item(0).outerHTML:h.htmlText);l.removeChild(l.firstChild)}else{l.innerHTML=h.toString()}}if(/^\\s/.test(l.innerHTML)){i=\" \"}if(/\\s+$/.test(l.innerHTML)){k=\" \"}g.getInner=true;g.content=f.isCollapsed()?\"\":i+f.serializer.serialize(l,g)+k;f.onGetContent.dispatch(f,g);return g.content},setContent:function(g,i){var n=this,f=n.getRng(),j,k=n.win.document,m,l;i=i||{format:\"html\"};i.set=true;g=i.content=g;if(!i.no_events){n.onBeforeSetContent.dispatch(n,i)}g=i.content;if(f.insertNode){g+='<span id=\"__caret\">_</span>';if(f.startContainer==k&&f.endContainer==k){k.body.innerHTML=g}else{f.deleteContents();if(k.body.childNodes.length==0){k.body.innerHTML=g}else{if(f.createContextualFragment){f.insertNode(f.createContextualFragment(g))}else{m=k.createDocumentFragment();l=k.createElement(\"div\");m.appendChild(l);l.outerHTML=g;f.insertNode(m)}}}j=n.dom.get(\"__caret\");f=k.createRange();f.setStartBefore(j);f.setEndBefore(j);n.setRng(f);n.dom.remove(\"__caret\");try{n.setRng(f)}catch(h){}}else{if(f.item){k.execCommand(\"Delete\",false,null);f=n.getRng()}if(/^\\s+/.test(g)){f.pasteHTML('<span id=\"__mce_tmp\">_</span>'+g);n.dom.remove(\"__mce_tmp\")}else{f.pasteHTML(g)}}if(!i.no_events){n.onSetContent.dispatch(n,i)}},getStart:function(){var g=this.getRng(),h,f,j,i;if(g.duplicate||g.item){if(g.item){return g.item(0)}j=g.duplicate();j.collapse(1);h=j.parentElement();f=i=g.parentElement();while(i=i.parentNode){if(i==h){h=f;break}}return h}else{h=g.startContainer;if(h.nodeType==1&&h.hasChildNodes()){h=h.childNodes[Math.min(h.childNodes.length-1,g.startOffset)]}if(h&&h.nodeType==3){return h.parentNode}return h}},getEnd:function(){var g=this,h=g.getRng(),i,f;if(h.duplicate||h.item){if(h.item){return h.item(0)}h=h.duplicate();h.collapse(0);i=h.parentElement();if(i&&i.nodeName==\"BODY\"){return i.lastChild||i}return i}else{i=h.endContainer;f=h.endOffset;if(i.nodeType==1&&i.hasChildNodes()){i=i.childNodes[f>0?f-1:f]}if(i&&i.nodeType==3){return i.parentNode}return i}},getBookmark:function(r,s){var v=this,m=v.dom,g,j,i,n,h,o,p,l=\"\\uFEFF\",u;function f(x,y){var t=0;d(m.select(x),function(A,z){if(A==y){t=z}});return t}if(r==2){function k(){var x=v.getRng(true),t=m.getRoot(),y={};function z(C,H){var B=C[H?\"startContainer\":\"endContainer\"],G=C[H?\"startOffset\":\"endOffset\"],A=[],D,F,E=0;if(B.nodeType==3){if(s){for(D=B.previousSibling;D&&D.nodeType==3;D=D.previousSibling){G+=D.nodeValue.length}}A.push(G)}else{F=B.childNodes;if(G>=F.length&&F.length){E=1;G=Math.max(0,F.length-1)}A.push(v.dom.nodeIndex(F[G],s)+E)}for(;B&&B!=t;B=B.parentNode){A.push(v.dom.nodeIndex(B,s))}return A}y.start=z(x,true);if(!v.isCollapsed()){y.end=z(x)}return y}if(v.tridentSel){return v.tridentSel.getBookmark(r)}return k()}if(r){return{rng:v.getRng()}}g=v.getRng();i=m.uniqueId();n=tinyMCE.activeEditor.selection.isCollapsed();u=\"overflow:hidden;line-height:0px\";if(g.duplicate||g.item){if(!g.item){j=g.duplicate();try{g.collapse();g.pasteHTML('<span data-mce-type=\"bookmark\" id=\"'+i+'_start\" style=\"'+u+'\">'+l+\"</span>\");if(!n){j.collapse(false);g.moveToElementText(j.parentElement());if(g.compareEndPoints(\"StartToEnd\",j)==0){j.move(\"character\",-1)}j.pasteHTML('<span data-mce-type=\"bookmark\" id=\"'+i+'_end\" style=\"'+u+'\">'+l+\"</span>\")}}catch(q){return null}}else{o=g.item(0);h=o.nodeName;return{name:h,index:f(h,o)}}}else{o=v.getNode();h=o.nodeName;if(h==\"IMG\"){return{name:h,index:f(h,o)}}j=g.cloneRange();if(!n){j.collapse(false);j.insertNode(m.create(\"span\",{\"data-mce-type\":\"bookmark\",id:i+\"_end\",style:u},l))}g.collapse(true);g.insertNode(m.create(\"span\",{\"data-mce-type\":\"bookmark\",id:i+\"_start\",style:u},l))}v.moveToBookmark({id:i,keep:1});return{id:i}},moveToBookmark:function(n){var r=this,l=r.dom,i,h,f,q,j,s,o,p;if(n){if(n.start){f=l.createRng();q=l.getRoot();function g(z){var t=n[z?\"start\":\"end\"],v,x,y,u;if(t){y=t[0];for(x=q,v=t.length-1;v>=1;v--){u=x.childNodes;if(t[v]>u.length-1){return}x=u[t[v]]}if(x.nodeType===3){y=Math.min(t[0],x.nodeValue.length)}if(x.nodeType===1){y=Math.min(t[0],x.childNodes.length)}if(z){f.setStart(x,y)}else{f.setEnd(x,y)}}return true}if(r.tridentSel){return r.tridentSel.moveToBookmark(n)}if(g(true)&&g()){r.setRng(f)}}else{if(n.id){function k(A){var u=l.get(n.id+\"_\"+A),z,t,x,y,v=n.keep;if(u){z=u.parentNode;if(A==\"start\"){if(!v){t=l.nodeIndex(u)}else{z=u.firstChild;t=1}j=s=z;o=p=t}else{if(!v){t=l.nodeIndex(u)}else{z=u.firstChild;t=1}s=z;p=t}if(!v){y=u.previousSibling;x=u.nextSibling;d(c.grep(u.childNodes),function(B){if(B.nodeType==3){B.nodeValue=B.nodeValue.replace(/\\uFEFF/g,\"\")}});while(u=l.get(n.id+\"_\"+A)){l.remove(u,1)}if(y&&x&&y.nodeType==x.nodeType&&y.nodeType==3&&!c.isOpera){t=y.nodeValue.length;y.appendData(x.nodeValue);l.remove(x);if(A==\"start\"){j=s=y;o=p=t}else{s=y;p=t}}}}}function m(t){if(l.isBlock(t)&&!t.innerHTML){t.innerHTML=!a?'<br data-mce-bogus=\"1\" />':\" \"}return t}k(\"start\");k(\"end\");if(j){f=l.createRng();f.setStart(m(j),o);f.setEnd(m(s),p);r.setRng(f)}}else{if(n.name){r.select(l.select(n.name)[n.index])}else{if(n.rng){r.setRng(n.rng)}}}}}},select:function(k,j){var i=this,l=i.dom,g=l.createRng(),f;if(k){f=l.nodeIndex(k);g.setStart(k.parentNode,f);g.setEnd(k.parentNode,f+1);if(j){function h(m,o){var n=new c.dom.TreeWalker(m,m);do{if(m.nodeType==3&&c.trim(m.nodeValue).length!=0){if(o){g.setStart(m,0)}else{g.setEnd(m,m.nodeValue.length)}return}if(m.nodeName==\"BR\"){if(o){g.setStartBefore(m)}else{g.setEndBefore(m)}return}}while(m=(o?n.next():n.prev()))}h(k,1);h(k)}i.setRng(g)}return k},isCollapsed:function(){var f=this,h=f.getRng(),g=f.getSel();if(!h||h.item){return false}if(h.compareEndPoints){return h.compareEndPoints(\"StartToEnd\",h)===0}return !g||h.collapsed},collapse:function(f){var h=this,g=h.getRng(),i;if(g.item){i=g.item(0);g=h.win.document.body.createTextRange();g.moveToElementText(i)}g.collapse(!!f);h.setRng(g)},getSel:function(){var g=this,f=this.win;return f.getSelection?f.getSelection():f.document.selection},getRng:function(l){var g=this,h,i,k,j=g.win.document;if(l&&g.tridentSel){return g.tridentSel.getRangeAt(0)}try{if(h=g.getSel()){i=h.rangeCount>0?h.getRangeAt(0):(h.createRange?h.createRange():j.createRange())}}catch(f){}if(c.isIE&&i&&i.setStart&&j.selection.createRange().item){k=j.selection.createRange().item(0);i=j.createRange();i.setStartBefore(k);i.setEndAfter(k)}if(!i){i=j.createRange?j.createRange():j.body.createTextRange()}if(g.selectedRange&&g.explicitRange){if(i.compareBoundaryPoints(i.START_TO_START,g.selectedRange)===0&&i.compareBoundaryPoints(i.END_TO_END,g.selectedRange)===0){i=g.explicitRange}else{g.selectedRange=null;g.explicitRange=null}}return i},setRng:function(i){var h,g=this;if(!g.tridentSel){h=g.getSel();if(h){g.explicitRange=i;try{h.removeAllRanges()}catch(f){}h.addRange(i);g.selectedRange=h.getRangeAt(0)}}else{if(i.cloneRange){g.tridentSel.addRange(i);return}try{i.select()}catch(f){}}},setNode:function(g){var f=this;f.setContent(f.dom.getOuterHTML(g));return g},getNode:function(){var h=this,g=h.getRng(),i=h.getSel(),l,k=g.startContainer,f=g.endContainer;if(!g){return h.dom.getRoot()}if(g.setStart){l=g.commonAncestorContainer;if(!g.collapsed){if(g.startContainer==g.endContainer){if(g.endOffset-g.startOffset<2){if(g.startContainer.hasChildNodes()){l=g.startContainer.childNodes[g.startOffset]}}}if(k.nodeType===3&&f.nodeType===3){function j(p,m){var o=p;while(p&&p.nodeType===3&&p.length===0){p=m?p.nextSibling:p.previousSibling}return p||o}if(k.length===g.startOffset){k=j(k.nextSibling,true)}else{k=k.parentNode}if(g.endOffset===0){f=j(f.previousSibling,false)}else{f=f.parentNode}if(k&&k===f){return k}}}if(l&&l.nodeType==3){return l.parentNode}return l}return g.item?g.item(0):g.parentElement()},getSelectedBlocks:function(o,g){var m=this,j=m.dom,l,k,h,i=[];l=j.getParent(o||m.getStart(),j.isBlock);k=j.getParent(g||m.getEnd(),j.isBlock);if(l){i.push(l)}if(l&&k&&l!=k){h=l;var f=new c.dom.TreeWalker(l,j.getRoot());while((h=f.next())&&h!=k){if(j.isBlock(h)){i.push(h)}}}if(k&&l!=k){i.push(k)}return i},normalize:function(){var g=this,f,i;if(c.isIE){return}function h(p){var k,o,n,m=g.dom,j=m.getRoot(),l;k=f[(p?\"start\":\"end\")+\"Container\"];o=f[(p?\"start\":\"end\")+\"Offset\"];if(k.nodeType===9){k=k.body;o=0}if(k===j){if(k.hasChildNodes()){k=k.childNodes[Math.min(!p&&o>0?o-1:o,k.childNodes.length-1)];o=0;if(k.hasChildNodes()){l=k;n=new c.dom.TreeWalker(k,j);do{if(l.nodeType===3){o=p?0:l.nodeValue.length-1;k=l;break}if(l.nodeName===\"BR\"){o=m.nodeIndex(l);k=l.parentNode;break}}while(l=(p?n.next():n.prev()));i=true}}}if(i){f[\"set\"+(p?\"Start\":\"End\")](k,o)}}f=g.getRng();h(true);if(f.collapsed){h()}if(i){g.setRng(f)}},destroy:function(g){var f=this;f.win=null;if(!g){c.removeUnload(f.destroy)}},_fixIESelection:function(){var g=this.dom,m=g.doc,h=m.body,j,n,f;m.documentElement.unselectable=true;function i(o,r){var p=h.createTextRange();try{p.moveToPoint(o,r)}catch(q){p=null}return p}function l(p){var o;if(p.button){o=i(p.x,p.y);if(o){if(o.compareEndPoints(\"StartToStart\",n)>0){o.setEndPoint(\"StartToStart\",n)}else{o.setEndPoint(\"EndToEnd\",n)}o.select()}}else{k()}}function k(){var o=m.selection.createRange();if(n&&!o.item&&o.compareEndPoints(\"StartToEnd\",o)===0){n.select()}g.unbind(m,\"mouseup\",k);g.unbind(m,\"mousemove\",l);n=j=0}g.bind(m,[\"mousedown\",\"contextmenu\"],function(o){if(o.target.nodeName===\"HTML\"){if(j){k()}f=m.documentElement;if(f.scrollHeight>f.clientHeight){return}j=1;n=i(o.x,o.y);if(n){g.bind(m,\"mouseup\",k);g.bind(m,\"mousemove\",l);g.win.focus();n.select()}}})}})})(tinymce);(function(a){a.dom.Serializer=function(e,i,f){var h,b,d=a.isIE,g=a.each,c;if(!e.apply_source_formatting){e.indent=false}e.remove_trailing_brs=true;i=i||a.DOM;f=f||new a.html.Schema(e);e.entity_encoding=e.entity_encoding||\"named\";h=new a.util.Dispatcher(self);b=new a.util.Dispatcher(self);c=new a.html.DomParser(e,f);c.addAttributeFilter(\"src,href,style\",function(k,j){var o=k.length,l,q,n=\"data-mce-\"+j,p=e.url_converter,r=e.url_converter_scope,m;while(o--){l=k[o];q=l.attributes.map[n];if(q!==m){l.attr(j,q.length>0?q:null);l.attr(n,null)}else{q=l.attributes.map[j];if(j===\"style\"){q=i.serializeStyle(i.parseStyle(q),l.name)}else{if(p){q=p.call(r,q,j,l.name)}}l.attr(j,q.length>0?q:null)}}});c.addAttributeFilter(\"class\",function(j,k){var l=j.length,m,n;while(l--){m=j[l];n=m.attr(\"class\").replace(/\\s*mce(Item\\w+|Selected)\\s*/g,\"\");m.attr(\"class\",n.length>0?n:null)}});c.addAttributeFilter(\"data-mce-type\",function(j,l,k){var m=j.length,n;while(m--){n=j[m];if(n.attributes.map[\"data-mce-type\"]===\"bookmark\"&&!k.cleanup){n.remove()}}});c.addNodeFilter(\"script,style\",function(k,l){var m=k.length,n,o;function j(p){return p.replace(/(<!--\\[CDATA\\[|\\]\\]-->)/g,\"\\n\").replace(/^[\\r\\n]*|[\\r\\n]*$/g,\"\").replace(/^\\s*(\\/\\/\\s*<!--|\\/\\/\\s*<!\\[CDATA\\[|<!--|<!\\[CDATA\\[)[\\r\\n]*/g,\"\").replace(/\\s*(\\/\\/\\s*\\]\\]>|\\/\\/\\s*-->|\\]\\]>|-->|\\]\\]-->)\\s*$/g,\"\")}while(m--){n=k[m];o=n.firstChild?n.firstChild.value:\"\";if(l===\"script\"){n.attr(\"type\",(n.attr(\"type\")||\"text/javascript\").replace(/^mce\\-/,\"\"));if(o.length>0){n.firstChild.value=\"// <![CDATA[\\n\"+j(o)+\"\\n// ]]>\"}}else{if(o.length>0){n.firstChild.value=\"<!--\\n\"+j(o)+\"\\n-->\"}}}});c.addNodeFilter(\"#comment\",function(j,k){var l=j.length,m;while(l--){m=j[l];if(m.value.indexOf(\"[CDATA[\")===0){m.name=\"#cdata\";m.type=4;m.value=m.value.replace(/^\\[CDATA\\[|\\]\\]$/g,\"\")}else{if(m.value.indexOf(\"mce:protected \")===0){m.name=\"#text\";m.type=3;m.raw=true;m.value=unescape(m.value).substr(14)}}}});c.addNodeFilter(\"xml:namespace,input\",function(j,k){var l=j.length,m;while(l--){m=j[l];if(m.type===7){m.remove()}else{if(m.type===1){if(k===\"input\"&&!(\"type\" in m.attributes.map)){m.attr(\"type\",\"text\")}}}}});if(e.fix_list_elements){c.addNodeFilter(\"ul,ol\",function(k,l){var m=k.length,n,j;while(m--){n=k[m];j=n.parent;if(j.name===\"ul\"||j.name===\"ol\"){if(n.prev&&n.prev.name===\"li\"){n.prev.append(n)}}}})}c.addAttributeFilter(\"data-mce-src,data-mce-href,data-mce-style\",function(j,k){var l=j.length;while(l--){j[l].attr(k,null)}});return{schema:f,addNodeFilter:c.addNodeFilter,addAttributeFilter:c.addAttributeFilter,onPreProcess:h,onPostProcess:b,serialize:function(o,m){var l,p,k,j,n;if(d&&i.select(\"script,style,select,map\").length>0){n=o.innerHTML;o=o.cloneNode(false);i.setHTML(o,n)}else{o=o.cloneNode(true)}l=o.ownerDocument.implementation;if(l.createHTMLDocument){p=l.createHTMLDocument(\"\");g(o.nodeName==\"BODY\"?o.childNodes:[o],function(q){p.body.appendChild(p.importNode(q,true))});if(o.nodeName!=\"BODY\"){o=p.body.firstChild}else{o=p.body}k=i.doc;i.doc=p}m=m||{};m.format=m.format||\"html\";if(!m.no_events){m.node=o;h.dispatch(self,m)}j=new a.html.Serializer(e,f);m.content=j.serialize(c.parse(m.getInner?o.innerHTML:a.trim(i.getOuterHTML(o),m),m));if(!m.cleanup){m.content=m.content.replace(/\\uFEFF|\\u200B/g,\"\")}if(!m.no_events){b.dispatch(self,m)}if(k){i.doc=k}m.node=null;return m.content},addRules:function(j){f.addValidElements(j)},setRules:function(j){f.setValidElements(j)}}}})(tinymce);(function(a){a.dom.ScriptLoader=function(h){var c=0,k=1,i=2,l={},j=[],f={},d=[],g=0,e;function b(m,v){var x=this,q=a.DOM,s,o,r,n;function p(){q.remove(n);if(s){s.onreadystatechange=s.onload=s=null}v()}function u(){if(typeof(console)!==\"undefined\"&&console.log){console.log(\"Failed to load: \"+m)}}n=q.uniqueId();if(a.isIE6){o=new a.util.URI(m);r=location;if(o.host==r.hostname&&o.port==r.port&&(o.protocol+\":\")==r.protocol&&o.protocol.toLowerCase()!=\"file\"){a.util.XHR.send({url:a._addVer(o.getURI()),success:function(y){var t=q.create(\"script\",{type:\"text/javascript\"});t.text=y;document.getElementsByTagName(\"head\")[0].appendChild(t);q.remove(t);p()},error:u});return}}s=q.create(\"script\",{id:n,type:\"text/javascript\",src:a._addVer(m)});if(!a.isIE){s.onload=p}s.onerror=u;if(!a.isOpera){s.onreadystatechange=function(){var t=s.readyState;if(t==\"complete\"||t==\"loaded\"){p()}}}(document.getElementsByTagName(\"head\")[0]||document.body).appendChild(s)}this.isDone=function(m){return l[m]==i};this.markDone=function(m){l[m]=i};this.add=this.load=function(m,q,n){var o,p=l[m];if(p==e){j.push(m);l[m]=c}if(q){if(!f[m]){f[m]=[]}f[m].push({func:q,scope:n||this})}};this.loadQueue=function(n,m){this.loadScripts(j,n,m)};this.loadScripts=function(m,q,p){var o;function n(r){a.each(f[r],function(s){s.func.call(s.scope)});f[r]=e}d.push({func:q,scope:p||this});o=function(){var r=a.grep(m);m.length=0;a.each(r,function(s){if(l[s]==i){n(s);return}if(l[s]!=k){l[s]=k;g++;b(s,function(){l[s]=i;g--;n(s);o()})}});if(!g){a.each(d,function(s){s.func.call(s.scope)});d.length=0}};o()}};a.ScriptLoader=new a.dom.ScriptLoader()})(tinymce);tinymce.dom.TreeWalker=function(a,c){var b=a;function d(i,f,e,j){var h,g;if(i){if(!j&&i[f]){return i[f]}if(i!=c){h=i[e];if(h){return h}for(g=i.parentNode;g&&g!=c;g=g.parentNode){h=g[e];if(h){return h}}}}}this.current=function(){return b};this.next=function(e){return(b=d(b,\"firstChild\",\"nextSibling\",e))};this.prev=function(e){return(b=d(b,\"lastChild\",\"previousSibling\",e))}};(function(a){a.dom.RangeUtils=function(c){var b=\"\\uFEFF\";this.walk=function(d,s){var i=d.startContainer,l=d.startOffset,t=d.endContainer,m=d.endOffset,j,g,o,h,r,q,e;e=c.select(\"td.mceSelected,th.mceSelected\");if(e.length>0){a.each(e,function(u){s([u])});return}function f(u){var v;v=u[0];if(v.nodeType===3&&v===i&&l>=v.nodeValue.length){u.splice(0,1)}v=u[u.length-1];if(m===0&&u.length>0&&v===t&&v.nodeType===3){u.splice(u.length-1,1)}return u}function p(x,v,u){var y=[];for(;x&&x!=u;x=x[v]){y.push(x)}return y}function n(v,u){do{if(v.parentNode==u){return v}v=v.parentNode}while(v)}function k(x,v,y){var u=y?\"nextSibling\":\"previousSibling\";for(h=x,r=h.parentNode;h&&h!=v;h=r){r=h.parentNode;q=p(h==x?h:h[u],u);if(q.length){if(!y){q.reverse()}s(f(q))}}}if(i.nodeType==1&&i.hasChildNodes()){i=i.childNodes[l]}if(t.nodeType==1&&t.hasChildNodes()){t=t.childNodes[Math.min(m-1,t.childNodes.length-1)]}if(i==t){return s(f([i]))}j=c.findCommonAncestor(i,t);for(h=i;h;h=h.parentNode){if(h===t){return k(i,j,true)}if(h===j){break}}for(h=t;h;h=h.parentNode){if(h===i){return k(t,j)}if(h===j){break}}g=n(i,j)||i;o=n(t,j)||t;k(i,g,true);q=p(g==i?g:g.nextSibling,\"nextSibling\",o==t?o.nextSibling:o);if(q.length){s(f(q))}k(t,o)};this.split=function(e){var h=e.startContainer,d=e.startOffset,i=e.endContainer,g=e.endOffset;function f(j,k){return j.splitText(k)}if(h==i&&h.nodeType==3){if(d>0&&d<h.nodeValue.length){i=f(h,d);h=i.previousSibling;if(g>d){g=g-d;h=i=f(i,g).previousSibling;g=i.nodeValue.length;d=0}else{g=0}}}else{if(h.nodeType==3&&d>0&&d<h.nodeValue.length){h=f(h,d);d=0}if(i.nodeType==3&&g>0&&g<i.nodeValue.length){i=f(i,g).previousSibling;g=i.nodeValue.length}}return{startContainer:h,startOffset:d,endContainer:i,endOffset:g}}};a.dom.RangeUtils.compareRanges=function(c,b){if(c&&b){if(c.item||c.duplicate){if(c.item&&b.item&&c.item(0)===b.item(0)){return true}if(c.isEqual&&b.isEqual&&b.isEqual(c)){return true}}else{return c.startContainer==b.startContainer&&c.startOffset==b.startOffset}}return false}})(tinymce);(function(b){var a=b.dom.Event,c=b.each;b.create(\"tinymce.ui.KeyboardNavigation\",{KeyboardNavigation:function(e,f){var p=this,m=e.root,l=e.items,n=e.enableUpDown,i=e.enableLeftRight||!e.enableUpDown,k=e.excludeFromTabOrder,j,h,o,d,g;f=f||b.DOM;j=function(q){g=q.target.id};h=function(q){f.setAttrib(q.target.id,\"tabindex\",\"-1\")};d=function(q){var r=f.get(g);f.setAttrib(r,\"tabindex\",\"0\");r.focus()};p.focus=function(){f.get(g).focus()};p.destroy=function(){c(l,function(q){f.unbind(f.get(q.id),\"focus\",j);f.unbind(f.get(q.id),\"blur\",h)});f.unbind(f.get(m),\"focus\",d);f.unbind(f.get(m),\"keydown\",o);l=f=m=p.focus=j=h=o=d=null;p.destroy=function(){}};p.moveFocus=function(u,r){var q=-1,t=p.controls,s;if(!g){return}c(l,function(x,v){if(x.id===g){q=v;return false}});q+=u;if(q<0){q=l.length-1}else{if(q>=l.length){q=0}}s=l[q];f.setAttrib(g,\"tabindex\",\"-1\");f.setAttrib(s.id,\"tabindex\",\"0\");f.get(s.id).focus();if(e.actOnFocus){e.onAction(s.id)}if(r){a.cancel(r)}};o=function(y){var u=37,t=39,x=38,z=40,q=27,s=14,r=13,v=32;switch(y.keyCode){case u:if(i){p.moveFocus(-1)}break;case t:if(i){p.moveFocus(1)}break;case x:if(n){p.moveFocus(-1)}break;case z:if(n){p.moveFocus(1)}break;case q:if(e.onCancel){e.onCancel();a.cancel(y)}break;case s:case r:case v:if(e.onAction){e.onAction(g);a.cancel(y)}break}};c(l,function(s,q){var r;if(!s.id){s.id=f.uniqueId(\"_mce_item_\")}if(k){f.bind(s.id,\"blur\",h);r=\"-1\"}else{r=(q===0?\"0\":\"-1\")}f.setAttrib(s.id,\"tabindex\",r);f.bind(f.get(s.id),\"focus\",j)});if(l[0]){g=l[0].id}f.setAttrib(m,\"tabindex\",\"-1\");f.bind(f.get(m),\"focus\",d);f.bind(f.get(m),\"keydown\",o)}})})(tinymce);(function(c){var b=c.DOM,a=c.is;c.create(\"tinymce.ui.Control\",{Control:function(f,e,d){this.id=f;this.settings=e=e||{};this.rendered=false;this.onRender=new c.util.Dispatcher(this);this.classPrefix=\"\";this.scope=e.scope||this;this.disabled=0;this.active=0;this.editor=d},setAriaProperty:function(f,e){var d=b.get(this.id+\"_aria\")||b.get(this.id);if(d){b.setAttrib(d,\"aria-\"+f,!!e)}},focus:function(){b.get(this.id).focus()},setDisabled:function(d){if(d!=this.disabled){this.setAriaProperty(\"disabled\",d);this.setState(\"Disabled\",d);this.setState(\"Enabled\",!d);this.disabled=d}},isDisabled:function(){return this.disabled},setActive:function(d){if(d!=this.active){this.setState(\"Active\",d);this.active=d;this.setAriaProperty(\"pressed\",d)}},isActive:function(){return this.active},setState:function(f,d){var e=b.get(this.id);f=this.classPrefix+f;if(d){b.addClass(e,f)}else{b.removeClass(e,f)}},isRendered:function(){return this.rendered},renderHTML:function(){},renderTo:function(d){b.setHTML(d,this.renderHTML())},postRender:function(){var e=this,d;if(a(e.disabled)){d=e.disabled;e.disabled=-1;e.setDisabled(d)}if(a(e.active)){d=e.active;e.active=-1;e.setActive(d)}},remove:function(){b.remove(this.id);this.destroy()},destroy:function(){c.dom.Event.clear(this.id)}})})(tinymce);tinymce.create(\"tinymce.ui.Container:tinymce.ui.Control\",{Container:function(c,b,a){this.parent(c,b,a);this.controls=[];this.lookup={}},add:function(a){this.lookup[a.id]=a;this.controls.push(a);return a},get:function(a){return this.lookup[a]}});tinymce.create(\"tinymce.ui.Separator:tinymce.ui.Control\",{Separator:function(b,a){this.parent(b,a);this.classPrefix=\"mceSeparator\";this.setDisabled(true)},renderHTML:function(){return tinymce.DOM.createHTML(\"span\",{\"class\":this.classPrefix,role:\"separator\",\"aria-orientation\":\"vertical\",tabindex:\"-1\"})}});(function(d){var c=d.is,b=d.DOM,e=d.each,a=d.walk;d.create(\"tinymce.ui.MenuItem:tinymce.ui.Control\",{MenuItem:function(g,f){this.parent(g,f);this.classPrefix=\"mceMenuItem\"},setSelected:function(f){this.setState(\"Selected\",f);this.setAriaProperty(\"checked\",!!f);this.selected=f},isSelected:function(){return this.selected},postRender:function(){var f=this;f.parent();if(c(f.selected)){f.setSelected(f.selected)}}})})(tinymce);(function(d){var c=d.is,b=d.DOM,e=d.each,a=d.walk;d.create(\"tinymce.ui.Menu:tinymce.ui.MenuItem\",{Menu:function(h,g){var f=this;f.parent(h,g);f.items={};f.collapsed=false;f.menuCount=0;f.onAddItem=new d.util.Dispatcher(this)},expand:function(g){var f=this;if(g){a(f,function(h){if(h.expand){h.expand()}},\"items\",f)}f.collapsed=false},collapse:function(g){var f=this;if(g){a(f,function(h){if(h.collapse){h.collapse()}},\"items\",f)}f.collapsed=true},isCollapsed:function(){return this.collapsed},add:function(f){if(!f.settings){f=new d.ui.MenuItem(f.id||b.uniqueId(),f)}this.onAddItem.dispatch(this,f);return this.items[f.id]=f},addSeparator:function(){return this.add({separator:true})},addMenu:function(f){if(!f.collapse){f=this.createMenu(f)}this.menuCount++;return this.add(f)},hasMenus:function(){return this.menuCount!==0},remove:function(f){delete this.items[f.id]},removeAll:function(){var f=this;a(f,function(g){if(g.removeAll){g.removeAll()}else{g.remove()}g.destroy()},\"items\",f);f.items={}},createMenu:function(g){var f=new d.ui.Menu(g.id||b.uniqueId(),g);f.onAddItem.add(this.onAddItem.dispatch,this.onAddItem);return f}})})(tinymce);(function(e){var d=e.is,c=e.DOM,f=e.each,a=e.dom.Event,b=e.dom.Element;e.create(\"tinymce.ui.DropMenu:tinymce.ui.Menu\",{DropMenu:function(h,g){g=g||{};g.container=g.container||c.doc.body;g.offset_x=g.offset_x||0;g.offset_y=g.offset_y||0;g.vp_offset_x=g.vp_offset_x||0;g.vp_offset_y=g.vp_offset_y||0;if(d(g.icons)&&!g.icons){g[\"class\"]+=\" mceNoIcons\"}this.parent(h,g);this.onShowMenu=new e.util.Dispatcher(this);this.onHideMenu=new e.util.Dispatcher(this);this.classPrefix=\"mceMenu\"},createMenu:function(j){var h=this,i=h.settings,g;j.container=j.container||i.container;j.parent=h;j.constrain=j.constrain||i.constrain;j[\"class\"]=j[\"class\"]||i[\"class\"];j.vp_offset_x=j.vp_offset_x||i.vp_offset_x;j.vp_offset_y=j.vp_offset_y||i.vp_offset_y;j.keyboard_focus=i.keyboard_focus;g=new e.ui.DropMenu(j.id||c.uniqueId(),j);g.onAddItem.add(h.onAddItem.dispatch,h.onAddItem);return g},focus:function(){var g=this;if(g.keyboardNav){g.keyboardNav.focus()}},update:function(){var i=this,j=i.settings,g=c.get(\"menu_\"+i.id+\"_tbl\"),l=c.get(\"menu_\"+i.id+\"_co\"),h,k;h=j.max_width?Math.min(g.clientWidth,j.max_width):g.clientWidth;k=j.max_height?Math.min(g.clientHeight,j.max_height):g.clientHeight;if(!c.boxModel){i.element.setStyles({width:h+2,height:k+2})}else{i.element.setStyles({width:h,height:k})}if(j.max_width){c.setStyle(l,\"width\",h)}if(j.max_height){c.setStyle(l,\"height\",k);if(g.clientHeight<j.max_height){c.setStyle(l,\"overflow\",\"hidden\")}}},showMenu:function(p,n,r){var z=this,A=z.settings,o,g=c.getViewPort(),u,l,v,q,i=2,k,j,m=z.classPrefix;z.collapse(1);if(z.isMenuVisible){return}if(!z.rendered){o=c.add(z.settings.container,z.renderNode());f(z.items,function(h){h.postRender()});z.element=new b(\"menu_\"+z.id,{blocker:1,container:A.container})}else{o=c.get(\"menu_\"+z.id)}if(!e.isOpera){c.setStyles(o,{left:-65535,top:-65535})}c.show(o);z.update();p+=A.offset_x||0;n+=A.offset_y||0;g.w-=4;g.h-=4;if(A.constrain){u=o.clientWidth-i;l=o.clientHeight-i;v=g.x+g.w;q=g.y+g.h;if((p+A.vp_offset_x+u)>v){p=r?r-u:Math.max(0,(v-A.vp_offset_x)-u)}if((n+A.vp_offset_y+l)>q){n=Math.max(0,(q-A.vp_offset_y)-l)}}c.setStyles(o,{left:p,top:n});z.element.update();z.isMenuVisible=1;z.mouseClickFunc=a.add(o,\"click\",function(s){var h;s=s.target;if(s&&(s=c.getParent(s,\"tr\"))&&!c.hasClass(s,m+\"ItemSub\")){h=z.items[s.id];if(h.isDisabled()){return}k=z;while(k){if(k.hideMenu){k.hideMenu()}k=k.settings.parent}if(h.settings.onclick){h.settings.onclick(s)}return a.cancel(s)}});if(z.hasMenus()){z.mouseOverFunc=a.add(o,\"mouseover\",function(x){var h,t,s;x=x.target;if(x&&(x=c.getParent(x,\"tr\"))){h=z.items[x.id];if(z.lastMenu){z.lastMenu.collapse(1)}if(h.isDisabled()){return}if(x&&c.hasClass(x,m+\"ItemSub\")){t=c.getRect(x);h.showMenu((t.x+t.w-i),t.y-i,t.x);z.lastMenu=h;c.addClass(c.get(h.id).firstChild,m+\"ItemActive\")}}})}a.add(o,\"keydown\",z._keyHandler,z);z.onShowMenu.dispatch(z);if(A.keyboard_focus){z._setupKeyboardNav()}},hideMenu:function(j){var g=this,i=c.get(\"menu_\"+g.id),h;if(!g.isMenuVisible){return}if(g.keyboardNav){g.keyboardNav.destroy()}a.remove(i,\"mouseover\",g.mouseOverFunc);a.remove(i,\"click\",g.mouseClickFunc);a.remove(i,\"keydown\",g._keyHandler);c.hide(i);g.isMenuVisible=0;if(!j){g.collapse(1)}if(g.element){g.element.hide()}if(h=c.get(g.id)){c.removeClass(h.firstChild,g.classPrefix+\"ItemActive\")}g.onHideMenu.dispatch(g)},add:function(i){var g=this,h;i=g.parent(i);if(g.isRendered&&(h=c.get(\"menu_\"+g.id))){g._add(c.select(\"tbody\",h)[0],i)}return i},collapse:function(g){this.parent(g);this.hideMenu(1)},remove:function(g){c.remove(g.id);this.destroy();return this.parent(g)},destroy:function(){var g=this,h=c.get(\"menu_\"+g.id);if(g.keyboardNav){g.keyboardNav.destroy()}a.remove(h,\"mouseover\",g.mouseOverFunc);a.remove(c.select(\"a\",h),\"focus\",g.mouseOverFunc);a.remove(h,\"click\",g.mouseClickFunc);a.remove(h,\"keydown\",g._keyHandler);if(g.element){g.element.remove()}c.remove(h)},renderNode:function(){var i=this,j=i.settings,l,h,k,g;g=c.create(\"div\",{role:\"listbox\",id:\"menu_\"+i.id,\"class\":j[\"class\"],style:\"position:absolute;left:0;top:0;z-index:200000;outline:0\"});if(i.settings.parent){c.setAttrib(g,\"aria-parent\",\"menu_\"+i.settings.parent.id)}k=c.add(g,\"div\",{role:\"presentation\",id:\"menu_\"+i.id+\"_co\",\"class\":i.classPrefix+(j[\"class\"]?\" \"+j[\"class\"]:\"\")});i.element=new b(\"menu_\"+i.id,{blocker:1,container:j.container});if(j.menu_line){c.add(k,\"span\",{\"class\":i.classPrefix+\"Line\"})}l=c.add(k,\"table\",{role:\"presentation\",id:\"menu_\"+i.id+\"_tbl\",border:0,cellPadding:0,cellSpacing:0});h=c.add(l,\"tbody\");f(i.items,function(m){i._add(h,m)});i.rendered=true;return g},_setupKeyboardNav:function(){var i,h,g=this;i=c.select(\"#menu_\"+g.id)[0];h=c.select(\"a[role=option]\",\"menu_\"+g.id);h.splice(0,0,i);g.keyboardNav=new e.ui.KeyboardNavigation({root:\"menu_\"+g.id,items:h,onCancel:function(){g.hideMenu()},enableUpDown:true});i.focus()},_keyHandler:function(g){var h=this,i;switch(g.keyCode){case 37:if(h.settings.parent){h.hideMenu();h.settings.parent.focus();a.cancel(g)}break;case 39:if(h.mouseOverFunc){h.mouseOverFunc(g)}break}},_add:function(j,h){var i,q=h.settings,p,l,k,m=this.classPrefix,g;if(q.separator){l=c.add(j,\"tr\",{id:h.id,\"class\":m+\"ItemSeparator\"});c.add(l,\"td\",{\"class\":m+\"ItemSeparator\"});if(i=l.previousSibling){c.addClass(i,\"mceLast\")}return}i=l=c.add(j,\"tr\",{id:h.id,\"class\":m+\"Item \"+m+\"ItemEnabled\"});i=k=c.add(i,q.titleItem?\"th\":\"td\");i=p=c.add(i,\"a\",{id:h.id+\"_aria\",role:q.titleItem?\"presentation\":\"option\",href:\"javascript:;\",onclick:\"return false;\",onmousedown:\"return false;\"});if(q.parent){c.setAttrib(p,\"aria-haspopup\",\"true\");c.setAttrib(p,\"aria-owns\",\"menu_\"+h.id)}c.addClass(k,q[\"class\"]);g=c.add(i,\"span\",{\"class\":\"mceIcon\"+(q.icon?\" mce_\"+q.icon:\"\")});if(q.icon_src){c.add(g,\"img\",{src:q.icon_src})}i=c.add(i,q.element||\"span\",{\"class\":\"mceText\",title:h.settings.title},h.settings.title);if(h.settings.style){c.setAttrib(i,\"style\",h.settings.style)}if(j.childNodes.length==1){c.addClass(l,\"mceFirst\")}if((i=l.previousSibling)&&c.hasClass(i,m+\"ItemSeparator\")){c.addClass(l,\"mceFirst\")}if(h.collapse){c.addClass(l,m+\"ItemSub\")}if(i=l.previousSibling){c.removeClass(i,\"mceLast\")}c.addClass(l,\"mceLast\")}})})(tinymce);(function(b){var a=b.DOM;b.create(\"tinymce.ui.Button:tinymce.ui.Control\",{Button:function(e,d,c){this.parent(e,d,c);this.classPrefix=\"mceButton\"},renderHTML:function(){var f=this.classPrefix,e=this.settings,d,c;c=a.encode(e.label||\"\");d='<a role=\"button\" id=\"'+this.id+'\" href=\"javascript:;\" class=\"'+f+\" \"+f+\"Enabled \"+e[\"class\"]+(c?\" \"+f+\"Labeled\":\"\")+'\" onmousedown=\"return false;\" onclick=\"return false;\" aria-labelledby=\"'+this.id+'_voice\" title=\"'+a.encode(e.title)+'\">';if(e.image&&!(this.editor&&this.editor.forcedHighContrastMode)){d+='<img class=\"mceIcon\" src=\"'+e.image+'\" alt=\"'+a.encode(e.title)+'\" />'+c}else{d+='<span class=\"mceIcon '+e[\"class\"]+'\"></span>'+(c?'<span class=\"'+f+'Label\">'+c+\"</span>\":\"\")}d+='<span class=\"mceVoiceLabel mceIconOnly\" style=\"display: none;\" id=\"'+this.id+'_voice\">'+e.title+\"</span>\";d+=\"</a>\";return d},postRender:function(){var c=this,d=c.settings;b.dom.Event.add(c.id,\"click\",function(f){if(!c.isDisabled()){return d.onclick.call(d.scope,f)}})}})})(tinymce);(function(d){var c=d.DOM,b=d.dom.Event,e=d.each,a=d.util.Dispatcher;d.create(\"tinymce.ui.ListBox:tinymce.ui.Control\",{ListBox:function(i,h,f){var g=this;g.parent(i,h,f);g.items=[];g.onChange=new a(g);g.onPostRender=new a(g);g.onAdd=new a(g);g.onRenderMenu=new d.util.Dispatcher(this);g.classPrefix=\"mceListBox\"},select:function(h){var g=this,j,i;if(h==undefined){return g.selectByIndex(-1)}if(h&&h.call){i=h}else{i=function(f){return f==h}}if(h!=g.selectedValue){e(g.items,function(k,f){if(i(k.value)){j=1;g.selectByIndex(f);return false}});if(!j){g.selectByIndex(-1)}}},selectByIndex:function(f){var h=this,i,j,g;if(f!=h.selectedIndex){i=c.get(h.id+\"_text\");g=c.get(h.id+\"_voiceDesc\");j=h.items[f];if(j){h.selectedValue=j.value;h.selectedIndex=f;c.setHTML(i,c.encode(j.title));c.setHTML(g,h.settings.title+\" - \"+j.title);c.removeClass(i,\"mceTitle\");c.setAttrib(h.id,\"aria-valuenow\",j.title)}else{c.setHTML(i,c.encode(h.settings.title));c.setHTML(g,c.encode(h.settings.title));c.addClass(i,\"mceTitle\");h.selectedValue=h.selectedIndex=null;c.setAttrib(h.id,\"aria-valuenow\",h.settings.title)}i=0}},add:function(i,f,h){var g=this;h=h||{};h=d.extend(h,{title:i,value:f});g.items.push(h);g.onAdd.dispatch(g,h)},getLength:function(){return this.items.length},renderHTML:function(){var i=\"\",f=this,g=f.settings,j=f.classPrefix;i='<span role=\"listbox\" aria-haspopup=\"true\" aria-labelledby=\"'+f.id+'_voiceDesc\" aria-describedby=\"'+f.id+'_voiceDesc\"><table role=\"presentation\" tabindex=\"0\" id=\"'+f.id+'\" cellpadding=\"0\" cellspacing=\"0\" class=\"'+j+\" \"+j+\"Enabled\"+(g[\"class\"]?(\" \"+g[\"class\"]):\"\")+'\"><tbody><tr>';i+=\"<td>\"+c.createHTML(\"span\",{id:f.id+\"_voiceDesc\",\"class\":\"voiceLabel\",style:\"display:none;\"},f.settings.title);i+=c.createHTML(\"a\",{id:f.id+\"_text\",tabindex:-1,href:\"javascript:;\",\"class\":\"mceText\",onclick:\"return false;\",onmousedown:\"return false;\"},c.encode(f.settings.title))+\"</td>\";i+=\"<td>\"+c.createHTML(\"a\",{id:f.id+\"_open\",tabindex:-1,href:\"javascript:;\",\"class\":\"mceOpen\",onclick:\"return false;\",onmousedown:\"return false;\"},'<span><span style=\"display:none;\" class=\"mceIconOnly\" aria-hidden=\"true\">\\u25BC</span></span>')+\"</td>\";i+=\"</tr></tbody></table></span>\";return i},showMenu:function(){var g=this,i,h=c.get(this.id),f;if(g.isDisabled()||g.items.length==0){return}if(g.menu&&g.menu.isMenuVisible){return g.hideMenu()}if(!g.isMenuRendered){g.renderMenu();g.isMenuRendered=true}i=c.getPos(h);f=g.menu;f.settings.offset_x=i.x;f.settings.offset_y=i.y;f.settings.keyboard_focus=!d.isOpera;if(g.oldID){f.items[g.oldID].setSelected(0)}e(g.items,function(j){if(j.value===g.selectedValue){f.items[j.id].setSelected(1);g.oldID=j.id}});f.showMenu(0,h.clientHeight);b.add(c.doc,\"mousedown\",g.hideMenu,g);c.addClass(g.id,g.classPrefix+\"Selected\")},hideMenu:function(g){var f=this;if(f.menu&&f.menu.isMenuVisible){c.removeClass(f.id,f.classPrefix+\"Selected\");if(g&&g.type==\"mousedown\"&&(g.target.id==f.id+\"_text\"||g.target.id==f.id+\"_open\")){return}if(!g||!c.getParent(g.target,\".mceMenu\")){c.removeClass(f.id,f.classPrefix+\"Selected\");b.remove(c.doc,\"mousedown\",f.hideMenu,f);f.menu.hideMenu()}}},renderMenu:function(){var g=this,f;f=g.settings.control_manager.createDropMenu(g.id+\"_menu\",{menu_line:1,\"class\":g.classPrefix+\"Menu mceNoIcons\",max_width:150,max_height:150});f.onHideMenu.add(function(){g.hideMenu();g.focus()});f.add({title:g.settings.title,\"class\":\"mceMenuItemTitle\",onclick:function(){if(g.settings.onselect(\"\")!==false){g.select(\"\")}}});e(g.items,function(h){if(h.value===undefined){f.add({title:h.title,role:\"option\",\"class\":\"mceMenuItemTitle\",onclick:function(){if(g.settings.onselect(\"\")!==false){g.select(\"\")}}})}else{h.id=c.uniqueId();h.role=\"option\";h.onclick=function(){if(g.settings.onselect(h.value)!==false){g.select(h.value)}};f.add(h)}});g.onRenderMenu.dispatch(g,f);g.menu=f},postRender:function(){var f=this,g=f.classPrefix;b.add(f.id,\"click\",f.showMenu,f);b.add(f.id,\"keydown\",function(h){if(h.keyCode==32){f.showMenu(h);b.cancel(h)}});b.add(f.id,\"focus\",function(){if(!f._focused){f.keyDownHandler=b.add(f.id,\"keydown\",function(h){if(h.keyCode==40){f.showMenu();b.cancel(h)}});f.keyPressHandler=b.add(f.id,\"keypress\",function(i){var h;if(i.keyCode==13){h=f.selectedValue;f.selectedValue=null;b.cancel(i);f.settings.onselect(h)}})}f._focused=1});b.add(f.id,\"blur\",function(){b.remove(f.id,\"keydown\",f.keyDownHandler);b.remove(f.id,\"keypress\",f.keyPressHandler);f._focused=0});if(d.isIE6||!c.boxModel){b.add(f.id,\"mouseover\",function(){if(!c.hasClass(f.id,g+\"Disabled\")){c.addClass(f.id,g+\"Hover\")}});b.add(f.id,\"mouseout\",function(){if(!c.hasClass(f.id,g+\"Disabled\")){c.removeClass(f.id,g+\"Hover\")}})}f.onPostRender.dispatch(f,c.get(f.id))},destroy:function(){this.parent();b.clear(this.id+\"_text\");b.clear(this.id+\"_open\")}})})(tinymce);(function(d){var c=d.DOM,b=d.dom.Event,e=d.each,a=d.util.Dispatcher;d.create(\"tinymce.ui.NativeListBox:tinymce.ui.ListBox\",{NativeListBox:function(g,f){this.parent(g,f);this.classPrefix=\"mceNativeListBox\"},setDisabled:function(f){c.get(this.id).disabled=f;this.setAriaProperty(\"disabled\",f)},isDisabled:function(){return c.get(this.id).disabled},select:function(h){var g=this,j,i;if(h==undefined){return g.selectByIndex(-1)}if(h&&h.call){i=h}else{i=function(f){return f==h}}if(h!=g.selectedValue){e(g.items,function(k,f){if(i(k.value)){j=1;g.selectByIndex(f);return false}});if(!j){g.selectByIndex(-1)}}},selectByIndex:function(f){c.get(this.id).selectedIndex=f+1;this.selectedValue=this.items[f]?this.items[f].value:null},add:function(j,g,f){var i,h=this;f=f||{};f.value=g;if(h.isRendered()){c.add(c.get(this.id),\"option\",f,j)}i={title:j,value:g,attribs:f};h.items.push(i);h.onAdd.dispatch(h,i)},getLength:function(){return this.items.length},renderHTML:function(){var g,f=this;g=c.createHTML(\"option\",{value:\"\"},\"-- \"+f.settings.title+\" --\");e(f.items,function(h){g+=c.createHTML(\"option\",{value:h.value},h.title)});g=c.createHTML(\"select\",{id:f.id,\"class\":\"mceNativeListBox\",\"aria-labelledby\":f.id+\"_aria\"},g);g+=c.createHTML(\"span\",{id:f.id+\"_aria\",style:\"display: none\"},f.settings.title);return g},postRender:function(){var g=this,h,i=true;g.rendered=true;function f(k){var j=g.items[k.target.selectedIndex-1];if(j&&(j=j.value)){g.onChange.dispatch(g,j);if(g.settings.onselect){g.settings.onselect(j)}}}b.add(g.id,\"change\",f);b.add(g.id,\"keydown\",function(k){var j;b.remove(g.id,\"change\",h);i=false;j=b.add(g.id,\"blur\",function(){if(i){return}i=true;b.add(g.id,\"change\",f);b.remove(g.id,\"blur\",j)});if(d.isWebKit&&(k.keyCode==37||k.keyCode==39)){return b.prevent(k)}if(k.keyCode==13||k.keyCode==32){f(k);return b.cancel(k)}});g.onPostRender.dispatch(g,c.get(g.id))}})})(tinymce);(function(c){var b=c.DOM,a=c.dom.Event,d=c.each;c.create(\"tinymce.ui.MenuButton:tinymce.ui.Button\",{MenuButton:function(g,f,e){this.parent(g,f,e);this.onRenderMenu=new c.util.Dispatcher(this);f.menu_container=f.menu_container||b.doc.body},showMenu:function(){var g=this,j,i,h=b.get(g.id),f;if(g.isDisabled()){return}if(!g.isMenuRendered){g.renderMenu();g.isMenuRendered=true}if(g.isMenuVisible){return g.hideMenu()}j=b.getPos(g.settings.menu_container);i=b.getPos(h);f=g.menu;f.settings.offset_x=i.x;f.settings.offset_y=i.y;f.settings.vp_offset_x=i.x;f.settings.vp_offset_y=i.y;f.settings.keyboard_focus=g._focused;f.showMenu(0,h.clientHeight);a.add(b.doc,\"mousedown\",g.hideMenu,g);g.setState(\"Selected\",1);g.isMenuVisible=1},renderMenu:function(){var f=this,e;e=f.settings.control_manager.createDropMenu(f.id+\"_menu\",{menu_line:1,\"class\":this.classPrefix+\"Menu\",icons:f.settings.icons});e.onHideMenu.add(function(){f.hideMenu();f.focus()});f.onRenderMenu.dispatch(f,e);f.menu=e},hideMenu:function(g){var f=this;if(g&&g.type==\"mousedown\"&&b.getParent(g.target,function(h){return h.id===f.id||h.id===f.id+\"_open\"})){return}if(!g||!b.getParent(g.target,\".mceMenu\")){f.setState(\"Selected\",0);a.remove(b.doc,\"mousedown\",f.hideMenu,f);if(f.menu){f.menu.hideMenu()}}f.isMenuVisible=0},postRender:function(){var e=this,f=e.settings;a.add(e.id,\"click\",function(){if(!e.isDisabled()){if(f.onclick){f.onclick(e.value)}e.showMenu()}})}})})(tinymce);(function(c){var b=c.DOM,a=c.dom.Event,d=c.each;c.create(\"tinymce.ui.SplitButton:tinymce.ui.MenuButton\",{SplitButton:function(g,f,e){this.parent(g,f,e);this.classPrefix=\"mceSplitButton\"},renderHTML:function(){var i,f=this,g=f.settings,e;i=\"<tbody><tr>\";if(g.image){e=b.createHTML(\"img \",{src:g.image,role:\"presentation\",\"class\":\"mceAction \"+g[\"class\"]})}else{e=b.createHTML(\"span\",{\"class\":\"mceAction \"+g[\"class\"]},\"\")}e+=b.createHTML(\"span\",{\"class\":\"mceVoiceLabel mceIconOnly\",id:f.id+\"_voice\",style:\"display:none;\"},g.title);i+=\"<td >\"+b.createHTML(\"a\",{role:\"button\",id:f.id+\"_action\",tabindex:\"-1\",href:\"javascript:;\",\"class\":\"mceAction \"+g[\"class\"],onclick:\"return false;\",onmousedown:\"return false;\",title:g.title},e)+\"</td>\";e=b.createHTML(\"span\",{\"class\":\"mceOpen \"+g[\"class\"]},'<span style=\"display:none;\" class=\"mceIconOnly\" aria-hidden=\"true\">\\u25BC</span>');i+=\"<td >\"+b.createHTML(\"a\",{role:\"button\",id:f.id+\"_open\",tabindex:\"-1\",href:\"javascript:;\",\"class\":\"mceOpen \"+g[\"class\"],onclick:\"return false;\",onmousedown:\"return false;\",title:g.title},e)+\"</td>\";i+=\"</tr></tbody>\";i=b.createHTML(\"table\",{role:\"presentation\",\"class\":\"mceSplitButton mceSplitButtonEnabled \"+g[\"class\"],cellpadding:\"0\",cellspacing:\"0\",title:g.title},i);return b.createHTML(\"div\",{id:f.id,role:\"button\",tabindex:\"0\",\"aria-labelledby\":f.id+\"_voice\",\"aria-haspopup\":\"true\"},i)},postRender:function(){var e=this,g=e.settings,f;if(g.onclick){f=function(h){if(!e.isDisabled()){g.onclick(e.value);a.cancel(h)}};a.add(e.id+\"_action\",\"click\",f);a.add(e.id,[\"click\",\"keydown\"],function(h){var k=32,m=14,i=13,j=38,l=40;if((h.keyCode===32||h.keyCode===13||h.keyCode===14)&&!h.altKey&&!h.ctrlKey&&!h.metaKey){f();a.cancel(h)}else{if(h.type===\"click\"||h.keyCode===l){e.showMenu();a.cancel(h)}}})}a.add(e.id+\"_open\",\"click\",function(h){e.showMenu();a.cancel(h)});a.add([e.id,e.id+\"_open\"],\"focus\",function(){e._focused=1});a.add([e.id,e.id+\"_open\"],\"blur\",function(){e._focused=0});if(c.isIE6||!b.boxModel){a.add(e.id,\"mouseover\",function(){if(!b.hasClass(e.id,\"mceSplitButtonDisabled\")){b.addClass(e.id,\"mceSplitButtonHover\")}});a.add(e.id,\"mouseout\",function(){if(!b.hasClass(e.id,\"mceSplitButtonDisabled\")){b.removeClass(e.id,\"mceSplitButtonHover\")}})}},destroy:function(){this.parent();a.clear(this.id+\"_action\");a.clear(this.id+\"_open\");a.clear(this.id)}})})(tinymce);(function(d){var c=d.DOM,a=d.dom.Event,b=d.is,e=d.each;d.create(\"tinymce.ui.ColorSplitButton:tinymce.ui.SplitButton\",{ColorSplitButton:function(i,h,f){var g=this;g.parent(i,h,f);g.settings=h=d.extend({colors:\"000000,993300,333300,003300,003366,000080,333399,333333,800000,FF6600,808000,008000,008080,0000FF,666699,808080,FF0000,FF9900,99CC00,339966,33CCCC,3366FF,800080,999999,FF00FF,FFCC00,FFFF00,00FF00,00FFFF,00CCFF,993366,C0C0C0,FF99CC,FFCC99,FFFF99,CCFFCC,CCFFFF,99CCFF,CC99FF,FFFFFF\",grid_width:8,default_color:\"#888888\"},g.settings);g.onShowMenu=new d.util.Dispatcher(g);g.onHideMenu=new d.util.Dispatcher(g);g.value=h.default_color},showMenu:function(){var f=this,g,j,i,h;if(f.isDisabled()){return}if(!f.isMenuRendered){f.renderMenu();f.isMenuRendered=true}if(f.isMenuVisible){return f.hideMenu()}i=c.get(f.id);c.show(f.id+\"_menu\");c.addClass(i,\"mceSplitButtonSelected\");h=c.getPos(i);c.setStyles(f.id+\"_menu\",{left:h.x,top:h.y+i.clientHeight,zIndex:200000});i=0;a.add(c.doc,\"mousedown\",f.hideMenu,f);f.onShowMenu.dispatch(f);if(f._focused){f._keyHandler=a.add(f.id+\"_menu\",\"keydown\",function(k){if(k.keyCode==27){f.hideMenu()}});c.select(\"a\",f.id+\"_menu\")[0].focus()}f.isMenuVisible=1},hideMenu:function(g){var f=this;if(f.isMenuVisible){if(g&&g.type==\"mousedown\"&&c.getParent(g.target,function(h){return h.id===f.id+\"_open\"})){return}if(!g||!c.getParent(g.target,\".mceSplitButtonMenu\")){c.removeClass(f.id,\"mceSplitButtonSelected\");a.remove(c.doc,\"mousedown\",f.hideMenu,f);a.remove(f.id+\"_menu\",\"keydown\",f._keyHandler);c.hide(f.id+\"_menu\")}f.isMenuVisible=0;f.onHideMenu.dispatch()}},renderMenu:function(){var p=this,h,k=0,q=p.settings,g,j,l,o,f;o=c.add(q.menu_container,\"div\",{role:\"listbox\",id:p.id+\"_menu\",\"class\":q.menu_class+\" \"+q[\"class\"],style:\"position:absolute;left:0;top:-1000px;\"});h=c.add(o,\"div\",{\"class\":q[\"class\"]+\" mceSplitButtonMenu\"});c.add(h,\"span\",{\"class\":\"mceMenuLine\"});g=c.add(h,\"table\",{role:\"presentation\",\"class\":\"mceColorSplitMenu\"});j=c.add(g,\"tbody\");k=0;e(b(q.colors,\"array\")?q.colors:q.colors.split(\",\"),function(i){i=i.replace(/^#/,\"\");if(!k--){l=c.add(j,\"tr\");k=q.grid_width-1}g=c.add(l,\"td\");g=c.add(g,\"a\",{role:\"option\",href:\"javascript:;\",style:{backgroundColor:\"#\"+i},title:p.editor.getLang(\"colors.\"+i,i),\"data-mce-color\":\"#\"+i});if(p.editor.forcedHighContrastMode){g=c.add(g,\"canvas\",{width:16,height:16,\"aria-hidden\":\"true\"});if(g.getContext&&(f=g.getContext(\"2d\"))){f.fillStyle=\"#\"+i;f.fillRect(0,0,16,16)}else{c.remove(g)}}});if(q.more_colors_func){g=c.add(j,\"tr\");g=c.add(g,\"td\",{colspan:q.grid_width,\"class\":\"mceMoreColors\"});g=c.add(g,\"a\",{role:\"option\",id:p.id+\"_more\",href:\"javascript:;\",onclick:\"return false;\",\"class\":\"mceMoreColors\"},q.more_colors_title);a.add(g,\"click\",function(i){q.more_colors_func.call(q.more_colors_scope||this);return a.cancel(i)})}c.addClass(h,\"mceColorSplitMenu\");new d.ui.KeyboardNavigation({root:p.id+\"_menu\",items:c.select(\"a\",p.id+\"_menu\"),onCancel:function(){p.hideMenu();p.focus()}});a.add(p.id+\"_menu\",\"mousedown\",function(i){return a.cancel(i)});a.add(p.id+\"_menu\",\"click\",function(i){var m;i=c.getParent(i.target,\"a\",j);if(i&&i.nodeName.toLowerCase()==\"a\"&&(m=i.getAttribute(\"data-mce-color\"))){p.setColor(m)}return a.cancel(i)});return o},setColor:function(f){this.displayColor(f);this.hideMenu();this.settings.onselect(f)},displayColor:function(g){var f=this;c.setStyle(f.id+\"_preview\",\"backgroundColor\",g);f.value=g},postRender:function(){var f=this,g=f.id;f.parent();c.add(g+\"_action\",\"div\",{id:g+\"_preview\",\"class\":\"mceColorPreview\"});c.setStyle(f.id+\"_preview\",\"backgroundColor\",f.value)},destroy:function(){this.parent();a.clear(this.id+\"_menu\");a.clear(this.id+\"_more\");c.remove(this.id+\"_menu\")}})})(tinymce);(function(b){var d=b.DOM,c=b.each,a=b.dom.Event;b.create(\"tinymce.ui.ToolbarGroup:tinymce.ui.Container\",{renderHTML:function(){var f=this,i=[],e=f.controls,j=b.each,g=f.settings;i.push('<div id=\"'+f.id+'\" role=\"group\" aria-labelledby=\"'+f.id+'_voice\">');i.push(\"<span role='application'>\");i.push('<span id=\"'+f.id+'_voice\" class=\"mceVoiceLabel\" style=\"display:none;\">'+d.encode(g.name)+\"</span>\");j(e,function(h){i.push(h.renderHTML())});i.push(\"</span>\");i.push(\"</div>\");return i.join(\"\")},focus:function(){var e=this;d.get(e.id).focus()},postRender:function(){var f=this,e=[];c(f.controls,function(g){c(g.controls,function(h){if(h.id){e.push(h)}})});f.keyNav=new b.ui.KeyboardNavigation({root:f.id,items:e,onCancel:function(){if(b.isWebKit){d.get(f.editor.id+\"_ifr\").focus()}f.editor.focus()},excludeFromTabOrder:!f.settings.tab_focus_toolbar})},destroy:function(){var e=this;e.parent();e.keyNav.destroy();a.clear(e.id)}})})(tinymce);(function(a){var c=a.DOM,b=a.each;a.create(\"tinymce.ui.Toolbar:tinymce.ui.Container\",{renderHTML:function(){var m=this,f=\"\",j,k,n=m.settings,e,d,g,l;l=m.controls;for(e=0;e<l.length;e++){k=l[e];d=l[e-1];g=l[e+1];if(e===0){j=\"mceToolbarStart\";if(k.Button){j+=\" mceToolbarStartButton\"}else{if(k.SplitButton){j+=\" mceToolbarStartSplitButton\"}else{if(k.ListBox){j+=\" mceToolbarStartListBox\"}}}f+=c.createHTML(\"td\",{\"class\":j},c.createHTML(\"span\",null,\"<!-- IE -->\"))}if(d&&k.ListBox){if(d.Button||d.SplitButton){f+=c.createHTML(\"td\",{\"class\":\"mceToolbarEnd\"},c.createHTML(\"span\",null,\"<!-- IE -->\"))}}if(c.stdMode){f+='<td style=\"position: relative\">'+k.renderHTML()+\"</td>\"}else{f+=\"<td>\"+k.renderHTML()+\"</td>\"}if(g&&k.ListBox){if(g.Button||g.SplitButton){f+=c.createHTML(\"td\",{\"class\":\"mceToolbarStart\"},c.createHTML(\"span\",null,\"<!-- IE -->\"))}}}j=\"mceToolbarEnd\";if(k.Button){j+=\" mceToolbarEndButton\"}else{if(k.SplitButton){j+=\" mceToolbarEndSplitButton\"}else{if(k.ListBox){j+=\" mceToolbarEndListBox\"}}}f+=c.createHTML(\"td\",{\"class\":j},c.createHTML(\"span\",null,\"<!-- IE -->\"));return c.createHTML(\"table\",{id:m.id,\"class\":\"mceToolbar\"+(n[\"class\"]?\" \"+n[\"class\"]:\"\"),cellpadding:\"0\",cellspacing:\"0\",align:m.settings.align||\"\",role:\"presentation\",tabindex:\"-1\"},\"<tbody><tr>\"+f+\"</tr></tbody>\")}})})(tinymce);(function(b){var a=b.util.Dispatcher,c=b.each;b.create(\"tinymce.AddOnManager\",{AddOnManager:function(){var d=this;d.items=[];d.urls={};d.lookup={};d.onAdd=new a(d)},get:function(d){if(this.lookup[d]){return this.lookup[d].instance}else{return undefined}},dependencies:function(e){var d;if(this.lookup[e]){d=this.lookup[e].dependencies}return d||[]},requireLangPack:function(e){var d=b.settings;if(d&&d.language&&d.language_load!==false){b.ScriptLoader.add(this.urls[e]+\"/langs/\"+d.language+\".js\")}},add:function(f,e,d){this.items.push(e);this.lookup[f]={instance:e,dependencies:d};this.onAdd.dispatch(this,f,e);return e},createUrl:function(d,e){if(typeof e===\"object\"){return e}else{return{prefix:d.prefix,resource:e,suffix:d.suffix}}},addComponents:function(f,d){var e=this.urls[f];b.each(d,function(g){b.ScriptLoader.add(e+\"/\"+g)})},load:function(j,f,d,h){var g=this,e=f;function i(){var k=g.dependencies(j);b.each(k,function(m){var l=g.createUrl(f,m);g.load(l.resource,l,undefined,undefined)});if(d){if(h){d.call(h)}else{d.call(b.ScriptLoader)}}}if(g.urls[j]){return}if(typeof f===\"object\"){e=f.prefix+f.resource+f.suffix}if(e.indexOf(\"/\")!=0&&e.indexOf(\"://\")==-1){e=b.baseURL+\"/\"+e}g.urls[j]=e.substring(0,e.lastIndexOf(\"/\"));if(g.lookup[j]){i()}else{b.ScriptLoader.add(e,i,h)}}});b.PluginManager=new b.AddOnManager();b.ThemeManager=new b.AddOnManager()}(tinymce));(function(j){var g=j.each,d=j.extend,k=j.DOM,i=j.dom.Event,f=j.ThemeManager,b=j.PluginManager,e=j.explode,h=j.util.Dispatcher,a,c=0;j.documentBaseURL=window.location.href.replace(/[\\?#].*$/,\"\").replace(/[\\/\\\\][^\\/]+$/,\"\");if(!/[\\/\\\\]$/.test(j.documentBaseURL)){j.documentBaseURL+=\"/\"}j.baseURL=new j.util.URI(j.documentBaseURL).toAbsolute(j.baseURL);j.baseURI=new j.util.URI(j.baseURL);j.onBeforeUnload=new h(j);i.add(window,\"beforeunload\",function(l){j.onBeforeUnload.dispatch(j,l)});j.onAddEditor=new h(j);j.onRemoveEditor=new h(j);j.EditorManager=d(j,{editors:[],i18n:{},activeEditor:null,init:function(q){var n=this,p,l=j.ScriptLoader,u,o=[],m;function r(x,y,t){var v=x[y];if(!v){return}if(j.is(v,\"string\")){t=v.replace(/\\.\\w+$/,\"\");t=t?j.resolve(t):0;v=j.resolve(v)}return v.apply(t||this,Array.prototype.slice.call(arguments,2))}q=d({theme:\"simple\",language:\"en\"},q);n.settings=q;i.add(document,\"init\",function(){var s,v;r(q,\"onpageload\");switch(q.mode){case\"exact\":s=q.elements||\"\";if(s.length>0){g(e(s),function(x){if(k.get(x)){m=new j.Editor(x,q);o.push(m);m.render(1)}else{g(document.forms,function(y){g(y.elements,function(z){if(z.name===x){x=\"mce_editor_\"+c++;k.setAttrib(z,\"id\",x);m=new j.Editor(x,q);o.push(m);m.render(1)}})})}})}break;case\"textareas\":case\"specific_textareas\":function t(y,x){return x.constructor===RegExp?x.test(y.className):k.hasClass(y,x)}g(k.select(\"textarea\"),function(x){if(q.editor_deselector&&t(x,q.editor_deselector)){return}if(!q.editor_selector||t(x,q.editor_selector)){u=k.get(x.name);if(!x.id&&!u){x.id=x.name}if(!x.id||n.get(x.id)){x.id=k.uniqueId()}m=new j.Editor(x.id,q);o.push(m);m.render(1)}});break}if(q.oninit){s=v=0;g(o,function(x){v++;if(!x.initialized){x.onInit.add(function(){s++;if(s==v){r(q,\"oninit\")}})}else{s++}if(s==v){r(q,\"oninit\")}})}})},get:function(l){if(l===a){return this.editors}return this.editors[l]},getInstanceById:function(l){return this.get(l)},add:function(m){var l=this,n=l.editors;n[m.id]=m;n.push(m);l._setActive(m);l.onAddEditor.dispatch(l,m);if(j.adapter){j.adapter.patchEditor(m)}return m},remove:function(n){var m=this,l,o=m.editors;if(!o[n.id]){return null}delete o[n.id];for(l=0;l<o.length;l++){if(o[l]==n){o.splice(l,1);break}}if(m.activeEditor==n){m._setActive(o[0])}n.destroy();m.onRemoveEditor.dispatch(m,n);return n},execCommand:function(r,p,o){var q=this,n=q.get(o),l;switch(r){case\"mceFocus\":n.focus();return true;case\"mceAddEditor\":case\"mceAddControl\":if(!q.get(o)){new j.Editor(o,q.settings).render()}return true;case\"mceAddFrameControl\":l=o.window;l.tinyMCE=tinyMCE;l.tinymce=j;j.DOM.doc=l.document;j.DOM.win=l;n=new j.Editor(o.element_id,o);n.render();if(j.isIE){function m(){n.destroy();l.detachEvent(\"onunload\",m);l=l.tinyMCE=l.tinymce=null}l.attachEvent(\"onunload\",m)}o.page_window=null;return true;case\"mceRemoveEditor\":case\"mceRemoveControl\":if(n){n.remove()}return true;case\"mceToggleEditor\":if(!n){q.execCommand(\"mceAddControl\",0,o);return true}if(n.isHidden()){n.show()}else{n.hide()}return true}if(q.activeEditor){return q.activeEditor.execCommand(r,p,o)}return false},execInstanceCommand:function(p,o,n,m){var l=this.get(p);if(l){return l.execCommand(o,n,m)}return false},triggerSave:function(){g(this.editors,function(l){l.save()})},addI18n:function(n,q){var l,m=this.i18n;if(!j.is(n,\"string\")){g(n,function(r,p){g(r,function(t,s){g(t,function(v,u){if(s===\"common\"){m[p+\".\"+u]=v}else{m[p+\".\"+s+\".\"+u]=v}})})})}else{g(q,function(r,p){m[n+\".\"+p]=r})}},_setActive:function(l){this.selectedInstance=this.activeEditor=l}})})(tinymce);(function(m){var n=m.DOM,j=m.dom.Event,f=m.extend,k=m.util.Dispatcher,i=m.each,a=m.isGecko,b=m.isIE,e=m.isWebKit,d=m.is,h=m.ThemeManager,c=m.PluginManager,o=m.inArray,l=m.grep,g=m.explode;m.create(\"tinymce.Editor\",{Editor:function(r,q){var p=this;p.id=p.editorId=r;p.execCommands={};p.queryStateCommands={};p.queryValueCommands={};p.isNotDirty=false;p.plugins={};i([\"onPreInit\",\"onBeforeRenderUI\",\"onPostRender\",\"onInit\",\"onRemove\",\"onActivate\",\"onDeactivate\",\"onClick\",\"onEvent\",\"onMouseUp\",\"onMouseDown\",\"onDblClick\",\"onKeyDown\",\"onKeyUp\",\"onKeyPress\",\"onContextMenu\",\"onSubmit\",\"onReset\",\"onPaste\",\"onPreProcess\",\"onPostProcess\",\"onBeforeSetContent\",\"onBeforeGetContent\",\"onSetContent\",\"onGetContent\",\"onLoadContent\",\"onSaveContent\",\"onNodeChange\",\"onChange\",\"onBeforeExecCommand\",\"onExecCommand\",\"onUndo\",\"onRedo\",\"onVisualAid\",\"onSetProgressState\"],function(s){p[s]=new k(p)});p.settings=q=f({id:r,language:\"en\",docs_language:\"en\",theme:\"simple\",skin:\"default\",delta_width:0,delta_height:0,popup_css:\"\",plugins:\"\",document_base_url:m.documentBaseURL,add_form_submit_trigger:1,submit_patch:1,add_unload_trigger:1,convert_urls:1,relative_urls:1,remove_script_host:1,table_inline_editing:0,object_resizing:1,cleanup:1,accessibility_focus:1,custom_shortcuts:1,custom_undo_redo_keyboard_shortcuts:1,custom_undo_redo_restore_selection:1,custom_undo_redo:1,doctype:m.isIE6?'<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">':\"<!DOCTYPE>\",visual_table_class:\"mceItemTable\",visual:1,font_size_style_values:\"xx-small,x-small,small,medium,large,x-large,xx-large\",font_size_legacy_values:\"xx-small,small,medium,large,x-large,xx-large,300%\",apply_source_formatting:1,directionality:\"ltr\",forced_root_block:\"p\",hidden_input:1,padd_empty_editor:1,render_ui:1,init_theme:1,force_p_newlines:1,indentation:\"30px\",keep_styles:1,fix_table_elements:1,inline_styles:1,convert_fonts_to_spans:true,indent:\"simple\",indent_before:\"p,h1,h2,h3,h4,h5,h6,blockquote,div,title,style,pre,script,td,ul,li,area,table,thead,tfoot,tbody,tr\",indent_after:\"p,h1,h2,h3,h4,h5,h6,blockquote,div,title,style,pre,script,td,ul,li,area,table,thead,tfoot,tbody,tr\",validate:true,entity_encoding:\"named\",url_converter:p.convertURL,url_converter_scope:p,ie7_compat:true},q);p.documentBaseURI=new m.util.URI(q.document_base_url||m.documentBaseURL,{base_uri:tinyMCE.baseURI});p.baseURI=m.baseURI;p.contentCSS=[];p.execCallback(\"setup\",p)},render:function(r){var u=this,v=u.settings,x=u.id,p=m.ScriptLoader;if(!j.domLoaded){j.add(document,\"init\",function(){u.render()});return}tinyMCE.settings=v;if(!u.getElement()){return}if(m.isIDevice&&!m.isIOS5){return}if(!/TEXTAREA|INPUT/i.test(u.getElement().nodeName)&&v.hidden_input&&n.getParent(x,\"form\")){n.insertAfter(n.create(\"input\",{type:\"hidden\",name:x}),x)}if(m.WindowManager){u.windowManager=new m.WindowManager(u)}if(v.encoding==\"xml\"){u.onGetContent.add(function(s,t){if(t.save){t.content=n.encode(t.content)}})}if(v.add_form_submit_trigger){u.onSubmit.addToTop(function(){if(u.initialized){u.save();u.isNotDirty=1}})}if(v.add_unload_trigger){u._beforeUnload=tinyMCE.onBeforeUnload.add(function(){if(u.initialized&&!u.destroyed&&!u.isHidden()){u.save({format:\"raw\",no_events:true})}})}m.addUnload(u.destroy,u);if(v.submit_patch){u.onBeforeRenderUI.add(function(){var s=u.getElement().form;if(!s){return}if(s._mceOldSubmit){return}if(!s.submit.nodeType&&!s.submit.length){u.formElement=s;s._mceOldSubmit=s.submit;s.submit=function(){m.triggerSave();u.isNotDirty=1;return u.formElement._mceOldSubmit(u.formElement)}}s=null})}function q(){if(v.language&&v.language_load!==false){p.add(m.baseURL+\"/langs/\"+v.language+\".js\")}if(v.theme&&v.theme.charAt(0)!=\"-\"&&!h.urls[v.theme]){h.load(v.theme,\"themes/\"+v.theme+\"/editor_template\"+m.suffix+\".js\")}i(g(v.plugins),function(t){if(t&&!c.urls[t]){if(t.charAt(0)==\"-\"){t=t.substr(1,t.length);var s=c.dependencies(t);i(s,function(z){var y={prefix:\"plugins/\",resource:z,suffix:\"/editor_plugin\"+m.suffix+\".js\"};var z=c.createUrl(y,z);c.load(z.resource,z)})}else{if(t==\"safari\"){return}c.load(t,{prefix:\"plugins/\",resource:t,suffix:\"/editor_plugin\"+m.suffix+\".js\"})}}});p.loadQueue(function(){if(!u.removed){u.init()}})}q()},init:function(){var r,H=this,I=H.settings,E,A,D=H.getElement(),q,p,F,y,C,G,z,v=[];m.add(H);I.aria_label=I.aria_label||n.getAttrib(D,\"aria-label\",H.getLang(\"aria.rich_text_area\"));if(I.theme){I.theme=I.theme.replace(/-/,\"\");q=h.get(I.theme);H.theme=new q();if(H.theme.init&&I.init_theme){H.theme.init(H,h.urls[I.theme]||m.documentBaseURL.replace(/\\/$/,\"\"))}}function B(J){var K=c.get(J),t=c.urls[J]||m.documentBaseURL.replace(/\\/$/,\"\"),s;if(K&&m.inArray(v,J)===-1){i(c.dependencies(J),function(u){B(u)});s=new K(H,t);H.plugins[J]=s;if(s.init){s.init(H,t);v.push(J)}}}i(g(I.plugins.replace(/\\-/g,\"\")),B);if(I.popup_css!==false){if(I.popup_css){I.popup_css=H.documentBaseURI.toAbsolute(I.popup_css)}else{I.popup_css=H.baseURI.toAbsolute(\"themes/\"+I.theme+\"/skins/\"+I.skin+\"/dialog.css\")}}if(I.popup_css_add){I.popup_css+=\",\"+H.documentBaseURI.toAbsolute(I.popup_css_add)}H.controlManager=new m.ControlManager(H);if(I.custom_undo_redo){H.onBeforeExecCommand.add(function(t,J,u,K,s){if(J!=\"Undo\"&&J!=\"Redo\"&&J!=\"mceRepaint\"&&(!s||!s.skip_undo)){H.undoManager.beforeChange()}});H.onExecCommand.add(function(t,J,u,K,s){if(J!=\"Undo\"&&J!=\"Redo\"&&J!=\"mceRepaint\"&&(!s||!s.skip_undo)){H.undoManager.add()}})}H.onExecCommand.add(function(s,t){if(!/^(FontName|FontSize)$/.test(t)){H.nodeChanged()}});if(a){function x(s,t){if(!t||!t.initial){H.execCommand(\"mceRepaint\")}}H.onUndo.add(x);H.onRedo.add(x);H.onSetContent.add(x)}H.onBeforeRenderUI.dispatch(H,H.controlManager);if(I.render_ui){E=I.width||D.style.width||D.offsetWidth;A=I.height||D.style.height||D.offsetHeight;H.orgDisplay=D.style.display;G=/^[0-9\\.]+(|px)$/i;if(G.test(\"\"+E)){E=Math.max(parseInt(E)+(q.deltaWidth||0),100)}if(G.test(\"\"+A)){A=Math.max(parseInt(A)+(q.deltaHeight||0),100)}q=H.theme.renderUI({targetNode:D,width:E,height:A,deltaWidth:I.delta_width,deltaHeight:I.delta_height});H.editorContainer=q.editorContainer}if(document.domain&&location.hostname!=document.domain){m.relaxedDomain=document.domain}n.setStyles(q.sizeContainer||q.editorContainer,{width:E,height:A});if(I.content_css){m.each(g(I.content_css),function(s){H.contentCSS.push(H.documentBaseURI.toAbsolute(s))})}A=(q.iframeHeight||A)+(typeof(A)==\"number\"?(q.deltaHeight||0):\"\");if(A<100){A=100}H.iframeHTML=I.doctype+'<html><head xmlns=\"http://www.w3.org/1999/xhtml\">';if(I.document_base_url!=m.documentBaseURL){H.iframeHTML+='<base href=\"'+H.documentBaseURI.getURI()+'\" />'}if(I.ie7_compat){H.iframeHTML+='<meta http-equiv=\"X-UA-Compatible\" content=\"IE=7\" />'}else{H.iframeHTML+='<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />'}H.iframeHTML+='<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />';for(z=0;z<H.contentCSS.length;z++){H.iframeHTML+='<link type=\"text/css\" rel=\"stylesheet\" href=\"'+H.contentCSS[z]+'\" />'}y=I.body_id||\"tinymce\";if(y.indexOf(\"=\")!=-1){y=H.getParam(\"body_id\",\"\",\"hash\");y=y[H.id]||y}C=I.body_class||\"\";if(C.indexOf(\"=\")!=-1){C=H.getParam(\"body_class\",\"\",\"hash\");C=C[H.id]||\"\"}H.iframeHTML+='</head><body id=\"'+y+'\" class=\"mceContentBody '+C+'\"><br></body></html>';if(m.relaxedDomain&&(b||(m.isOpera&&parseFloat(opera.version())<11))){F='javascript:(function(){document.open();document.domain=\"'+document.domain+'\";var ed = window.parent.tinyMCE.get(\"'+H.id+'\");document.write(ed.iframeHTML);document.close();ed.setupIframe();})()'}r=n.add(q.iframeContainer,\"iframe\",{id:H.id+\"_ifr\",src:F||'javascript:\"\"',frameBorder:\"0\",allowTransparency:\"true\",title:I.aria_label,style:{width:\"100%\",height:A,display:\"block\"}});H.contentAreaContainer=q.iframeContainer;n.get(q.editorContainer).style.display=H.orgDisplay;n.get(H.id).style.display=\"none\";n.setAttrib(H.id,\"aria-hidden\",true);if(!m.relaxedDomain||!F){H.setupIframe()}D=r=q=null},setupIframe:function(){var q=this,v=q.settings,x=n.get(q.id),y=q.getDoc(),u,p;if(!b||!m.relaxedDomain){y.open();y.write(q.iframeHTML);y.close();if(m.relaxedDomain){y.domain=m.relaxedDomain}}p=q.getBody();p.disabled=true;if(!v.readonly){p.contentEditable=true}p.disabled=false;q.schema=new m.html.Schema(v);q.dom=new m.dom.DOMUtils(q.getDoc(),{keep_values:true,url_converter:q.convertURL,url_converter_scope:q,hex_colors:v.force_hex_style_colors,class_filter:v.class_filter,update_styles:1,fix_ie_paragraphs:1,schema:q.schema});q.parser=new m.html.DomParser(v,q.schema);if(!q.settings.allow_html_in_named_anchor){q.parser.addAttributeFilter(\"name\",function(s,t){var A=s.length,C,z,B,D;while(A--){D=s[A];if(D.name===\"a\"&&D.firstChild){B=D.parent;C=D.lastChild;do{z=C.prev;B.insert(C,D);C=z}while(C)}}})}q.parser.addAttributeFilter(\"src,href,style\",function(s,t){var z=s.length,B,D=q.dom,C,A;while(z--){B=s[z];C=B.attr(t);A=\"data-mce-\"+t;if(!B.attributes.map[A]){if(t===\"style\"){B.attr(A,D.serializeStyle(D.parseStyle(C),B.name))}else{B.attr(A,q.convertURL(C,t,B.name))}}}});q.parser.addNodeFilter(\"script\",function(s,t){var z=s.length,A;while(z--){A=s[z];A.attr(\"type\",\"mce-\"+(A.attr(\"type\")||\"text/javascript\"))}});q.parser.addNodeFilter(\"#cdata\",function(s,t){var z=s.length,A;while(z--){A=s[z];A.type=8;A.name=\"#comment\";A.value=\"[CDATA[\"+A.value+\"]]\"}});q.parser.addNodeFilter(\"p,h1,h2,h3,h4,h5,h6,div\",function(t,z){var A=t.length,B,s=q.schema.getNonEmptyElements();while(A--){B=t[A];if(B.isEmpty(s)){B.empty().append(new m.html.Node(\"br\",1)).shortEnded=true}}});q.serializer=new m.dom.Serializer(v,q.dom,q.schema);q.selection=new m.dom.Selection(q.dom,q.getWin(),q.serializer);q.formatter=new m.Formatter(this);q.formatter.register({alignleft:[{selector:\"p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li\",styles:{textAlign:\"left\"}},{selector:\"img,table\",collapsed:false,styles:{\"float\":\"left\"}}],aligncenter:[{selector:\"p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li\",styles:{textAlign:\"center\"}},{selector:\"img\",collapsed:false,styles:{display:\"block\",marginLeft:\"auto\",marginRight:\"auto\"}},{selector:\"table\",collapsed:false,styles:{marginLeft:\"auto\",marginRight:\"auto\"}}],alignright:[{selector:\"p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li\",styles:{textAlign:\"right\"}},{selector:\"img,table\",collapsed:false,styles:{\"float\":\"right\"}}],alignfull:[{selector:\"p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li\",styles:{textAlign:\"justify\"}}],bold:[{inline:\"strong\",remove:\"all\"},{inline:\"span\",styles:{fontWeight:\"bold\"}},{inline:\"b\",remove:\"all\"}],italic:[{inline:\"em\",remove:\"all\"},{inline:\"span\",styles:{fontStyle:\"italic\"}},{inline:\"i\",remove:\"all\"}],underline:[{inline:\"span\",styles:{textDecoration:\"underline\"},exact:true},{inline:\"u\",remove:\"all\"}],strikethrough:[{inline:\"span\",styles:{textDecoration:\"line-through\"},exact:true},{inline:\"strike\",remove:\"all\"}],forecolor:{inline:\"span\",styles:{color:\"%value\"},wrap_links:false},hilitecolor:{inline:\"span\",styles:{backgroundColor:\"%value\"},wrap_links:false},fontname:{inline:\"span\",styles:{fontFamily:\"%value\"}},fontsize:{inline:\"span\",styles:{fontSize:\"%value\"}},fontsize_class:{inline:\"span\",attributes:{\"class\":\"%value\"}},blockquote:{block:\"blockquote\",wrapper:1,remove:\"all\"},subscript:{inline:\"sub\"},superscript:{inline:\"sup\"},link:{inline:\"a\",selector:\"a\",remove:\"all\",split:true,deep:true,onmatch:function(s){return true},onformat:function(z,s,t){i(t,function(B,A){q.dom.setAttrib(z,A,B)})}},removeformat:[{selector:\"b,strong,em,i,font,u,strike\",remove:\"all\",split:true,expand:false,block_expand:true,deep:true},{selector:\"span\",attributes:[\"style\",\"class\"],remove:\"empty\",split:true,expand:false,deep:true},{selector:\"*\",attributes:[\"style\",\"class\"],split:false,expand:false,deep:true}]});i(\"p h1 h2 h3 h4 h5 h6 div address pre div code dt dd samp\".split(/\\s/),function(s){q.formatter.register(s,{block:s,remove:\"all\"})});q.formatter.register(q.settings.formats);q.undoManager=new m.UndoManager(q);q.undoManager.onAdd.add(function(t,s){if(t.hasUndo()){return q.onChange.dispatch(q,s,t)}});q.undoManager.onUndo.add(function(t,s){return q.onUndo.dispatch(q,s,t)});q.undoManager.onRedo.add(function(t,s){return q.onRedo.dispatch(q,s,t)});q.forceBlocks=new m.ForceBlocks(q,{forced_root_block:v.forced_root_block});q.editorCommands=new m.EditorCommands(q);q.serializer.onPreProcess.add(function(s,t){return q.onPreProcess.dispatch(q,t,s)});q.serializer.onPostProcess.add(function(s,t){return q.onPostProcess.dispatch(q,t,s)});q.onPreInit.dispatch(q);if(!v.gecko_spellcheck){q.getBody().spellcheck=0}if(!v.readonly){q._addEvents()}q.controlManager.onPostRender.dispatch(q,q.controlManager);q.onPostRender.dispatch(q);q.quirks=new m.util.Quirks(this);if(v.directionality){q.getBody().dir=v.directionality}if(v.nowrap){q.getBody().style.whiteSpace=\"nowrap\"}if(v.handle_node_change_callback){q.onNodeChange.add(function(t,s,z){q.execCallback(\"handle_node_change_callback\",q.id,z,-1,-1,true,q.selection.isCollapsed())})}if(v.save_callback){q.onSaveContent.add(function(s,z){var t=q.execCallback(\"save_callback\",q.id,z.content,q.getBody());if(t){z.content=t}})}if(v.onchange_callback){q.onChange.add(function(t,s){q.execCallback(\"onchange_callback\",q,s)})}if(v.protect){q.onBeforeSetContent.add(function(s,t){if(v.protect){i(v.protect,function(z){t.content=t.content.replace(z,function(A){return\"<!--mce:protected \"+escape(A)+\"-->\"})})}})}if(v.convert_newlines_to_brs){q.onBeforeSetContent.add(function(s,t){if(t.initial){t.content=t.content.replace(/\\r?\\n/g,\"<br />\")}})}if(v.preformatted){q.onPostProcess.add(function(s,t){t.content=t.content.replace(/^\\s*<pre.*?>/,\"\");t.content=t.content.replace(/<\\/pre>\\s*$/,\"\");if(t.set){t.content='<pre class=\"mceItemHidden\">'+t.content+\"</pre>\"}})}if(v.verify_css_classes){q.serializer.attribValueFilter=function(B,z){var A,t;if(B==\"class\"){if(!q.classesRE){t=q.dom.getClasses();if(t.length>0){A=\"\";i(t,function(s){A+=(A?\"|\":\"\")+s[\"class\"]});q.classesRE=new RegExp(\"(\"+A+\")\",\"gi\")}}return !q.classesRE||/(\\bmceItem\\w+\\b|\\bmceTemp\\w+\\b)/g.test(z)||q.classesRE.test(z)?z:\"\"}return z}}if(v.cleanup_callback){q.onBeforeSetContent.add(function(s,t){t.content=q.execCallback(\"cleanup_callback\",\"insert_to_editor\",t.content,t)});q.onPreProcess.add(function(s,t){if(t.set){q.execCallback(\"cleanup_callback\",\"insert_to_editor_dom\",t.node,t)}if(t.get){q.execCallback(\"cleanup_callback\",\"get_from_editor_dom\",t.node,t)}});q.onPostProcess.add(function(s,t){if(t.set){t.content=q.execCallback(\"cleanup_callback\",\"insert_to_editor\",t.content,t)}if(t.get){t.content=q.execCallback(\"cleanup_callback\",\"get_from_editor\",t.content,t)}})}if(v.save_callback){q.onGetContent.add(function(s,t){if(t.save){t.content=q.execCallback(\"save_callback\",q.id,t.content,q.getBody())}})}if(v.handle_event_callback){q.onEvent.add(function(s,t,z){if(q.execCallback(\"handle_event_callback\",t,s,z)===false){j.cancel(t)}})}q.onSetContent.add(function(){q.addVisual(q.getBody())});if(v.padd_empty_editor){q.onPostProcess.add(function(s,t){t.content=t.content.replace(/^(<p[^>]*>(&nbsp;|&#160;|\\s|\\u00a0|)<\\/p>[\\r\\n]*|<br \\/>[\\r\\n]*)$/,\"\")})}if(a){function r(s,t){i(s.dom.select(\"a\"),function(A){var z=A.parentNode;if(s.dom.isBlock(z)&&z.lastChild===A){s.dom.add(z,\"br\",{\"data-mce-bogus\":1})}})}q.onExecCommand.add(function(s,t){if(t===\"CreateLink\"){r(s)}});q.onSetContent.add(q.selection.onSetContent.add(r))}q.load({initial:true,format:\"html\"});q.startContent=q.getContent({format:\"raw\"});q.undoManager.add();q.initialized=true;q.onInit.dispatch(q);q.execCallback(\"setupcontent_callback\",q.id,q.getBody(),q.getDoc());q.execCallback(\"init_instance_callback\",q);q.focus(true);q.nodeChanged({initial:1});i(q.contentCSS,function(s){q.dom.loadCSS(s)});if(v.auto_focus){setTimeout(function(){var s=m.get(v.auto_focus);s.selection.select(s.getBody(),1);s.selection.collapse(1);s.getBody().focus();s.getWin().focus()},100)}x=null},focus:function(u){var y,q=this,s=q.selection,x=q.settings.content_editable,r,p,v=q.getDoc();if(!u){r=s.getRng();if(r.item){p=r.item(0)}q._refreshContentEditable();s.normalize();if(!x){q.getWin().focus()}if(m.isGecko){q.getBody().focus()}if(p&&p.ownerDocument==v){r=v.body.createControlRange();r.addElement(p);r.select()}}if(m.activeEditor!=q){if((y=m.activeEditor)!=null){y.onDeactivate.dispatch(y,q)}q.onActivate.dispatch(q,y)}m._setActive(q)},execCallback:function(u){var p=this,r=p.settings[u],q;if(!r){return}if(p.callbackLookup&&(q=p.callbackLookup[u])){r=q.func;q=q.scope}if(d(r,\"string\")){q=r.replace(/\\.\\w+$/,\"\");q=q?m.resolve(q):0;r=m.resolve(r);p.callbackLookup=p.callbackLookup||{};p.callbackLookup[u]={func:r,scope:q}}return r.apply(q||p,Array.prototype.slice.call(arguments,1))},translate:function(p){var r=this.settings.language||\"en\",q=m.i18n;if(!p){return\"\"}return q[r+\".\"+p]||p.replace(/{\\#([^}]+)\\}/g,function(t,s){return q[r+\".\"+s]||\"{#\"+s+\"}\"})},getLang:function(q,p){return m.i18n[(this.settings.language||\"en\")+\".\"+q]||(d(p)?p:\"{#\"+q+\"}\")},getParam:function(u,r,p){var s=m.trim,q=d(this.settings[u])?this.settings[u]:r,t;if(p===\"hash\"){t={};if(d(q,\"string\")){i(q.indexOf(\"=\")>0?q.split(/[;,](?![^=;,]*(?:[;,]|$))/):q.split(\",\"),function(x){x=x.split(\"=\");if(x.length>1){t[s(x[0])]=s(x[1])}else{t[s(x[0])]=s(x)}})}else{t=q}return t}return q},nodeChanged:function(r){var p=this,q=p.selection,u=q.getStart()||p.getBody();if(p.initialized){r=r||{};u=b&&u.ownerDocument!=p.getDoc()?p.getBody():u;r.parents=[];p.dom.getParent(u,function(s){if(s.nodeName==\"BODY\"){return true}r.parents.push(s)});p.onNodeChange.dispatch(p,r?r.controlManager||p.controlManager:p.controlManager,u,q.isCollapsed(),r)}},addButton:function(r,q){var p=this;p.buttons=p.buttons||{};p.buttons[r]=q},addCommand:function(p,r,q){this.execCommands[p]={func:r,scope:q||this}},addQueryStateHandler:function(p,r,q){this.queryStateCommands[p]={func:r,scope:q||this}},addQueryValueHandler:function(p,r,q){this.queryValueCommands[p]={func:r,scope:q||this}},addShortcut:function(r,u,p,s){var q=this,v;if(!q.settings.custom_shortcuts){return false}q.shortcuts=q.shortcuts||{};if(d(p,\"string\")){v=p;p=function(){q.execCommand(v,false,null)}}if(d(p,\"object\")){v=p;p=function(){q.execCommand(v[0],v[1],v[2])}}i(g(r),function(t){var x={func:p,scope:s||this,desc:u,alt:false,ctrl:false,shift:false};i(g(t,\"+\"),function(y){switch(y){case\"alt\":case\"ctrl\":case\"shift\":x[y]=true;break;default:x.charCode=y.charCodeAt(0);x.keyCode=y.toUpperCase().charCodeAt(0)}});q.shortcuts[(x.ctrl?\"ctrl\":\"\")+\",\"+(x.alt?\"alt\":\"\")+\",\"+(x.shift?\"shift\":\"\")+\",\"+x.keyCode]=x});return true},execCommand:function(x,v,z,p){var r=this,u=0,y,q;if(!/^(mceAddUndoLevel|mceEndUndoLevel|mceBeginUndoLevel|mceRepaint|SelectAll)$/.test(x)&&(!p||!p.skip_focus)){r.focus()}y={};r.onBeforeExecCommand.dispatch(r,x,v,z,y);if(y.terminate){return false}if(r.execCallback(\"execcommand_callback\",r.id,r.selection.getNode(),x,v,z)){r.onExecCommand.dispatch(r,x,v,z,p);return true}if(y=r.execCommands[x]){q=y.func.call(y.scope,v,z);if(q!==true){r.onExecCommand.dispatch(r,x,v,z,p);return q}}i(r.plugins,function(s){if(s.execCommand&&s.execCommand(x,v,z)){r.onExecCommand.dispatch(r,x,v,z,p);u=1;return false}});if(u){return true}if(r.theme&&r.theme.execCommand&&r.theme.execCommand(x,v,z)){r.onExecCommand.dispatch(r,x,v,z,p);return true}if(r.editorCommands.execCommand(x,v,z)){r.onExecCommand.dispatch(r,x,v,z,p);return true}r.getDoc().execCommand(x,v,z);r.onExecCommand.dispatch(r,x,v,z,p)},queryCommandState:function(u){var q=this,v,r;if(q._isHidden()){return}if(v=q.queryStateCommands[u]){r=v.func.call(v.scope);if(r!==true){return r}}v=q.editorCommands.queryCommandState(u);if(v!==-1){return v}try{return this.getDoc().queryCommandState(u)}catch(p){}},queryCommandValue:function(v){var q=this,u,r;if(q._isHidden()){return}if(u=q.queryValueCommands[v]){r=u.func.call(u.scope);if(r!==true){return r}}u=q.editorCommands.queryCommandValue(v);if(d(u)){return u}try{return this.getDoc().queryCommandValue(v)}catch(p){}},show:function(){var p=this;n.show(p.getContainer());n.hide(p.id);p.load()},hide:function(){var p=this,q=p.getDoc();if(b&&q){q.execCommand(\"SelectAll\")}p.save();n.hide(p.getContainer());n.setStyle(p.id,\"display\",p.orgDisplay)},isHidden:function(){return !n.isHidden(this.id)},setProgressState:function(p,q,r){this.onSetProgressState.dispatch(this,p,q,r);return p},load:function(s){var p=this,r=p.getElement(),q;if(r){s=s||{};s.load=true;q=p.setContent(d(r.value)?r.value:r.innerHTML,s);s.element=r;if(!s.no_events){p.onLoadContent.dispatch(p,s)}s.element=r=null;return q}},save:function(u){var p=this,s=p.getElement(),q,r;if(!s||!p.initialized){return}u=u||{};u.save=true;if(!u.no_events){p.undoManager.typing=false;p.undoManager.add()}u.element=s;q=u.content=p.getContent(u);if(!u.no_events){p.onSaveContent.dispatch(p,u)}q=u.content;if(!/TEXTAREA|INPUT/i.test(s.nodeName)){s.innerHTML=q;if(r=n.getParent(p.id,\"form\")){i(r.elements,function(t){if(t.name==p.id){t.value=q;return false}})}}else{s.value=q}u.element=s=null;return q},setContent:function(u,s){var r=this,q,p=r.getBody(),t;s=s||{};s.format=s.format||\"html\";s.set=true;s.content=u;if(!s.no_events){r.onBeforeSetContent.dispatch(r,s)}u=s.content;if(!m.isIE&&(u.length===0||/^\\s+$/.test(u))){t=r.settings.forced_root_block;if(t){u=\"<\"+t+'><br data-mce-bogus=\"1\"></'+t+\">\"}else{u='<br data-mce-bogus=\"1\">'}p.innerHTML=u;r.selection.select(p,true);r.selection.collapse(true);return}if(s.format!==\"raw\"){u=new m.html.Serializer({},r.schema).serialize(r.parser.parse(u))}s.content=m.trim(u);r.dom.setHTML(p,s.content);if(!s.no_events){r.onSetContent.dispatch(r,s)}r.selection.normalize();return s.content},getContent:function(q){var p=this,r;q=q||{};q.format=q.format||\"html\";q.get=true;if(!q.no_events){p.onBeforeGetContent.dispatch(p,q)}if(q.format==\"raw\"){r=p.getBody().innerHTML}else{r=p.serializer.serialize(p.getBody(),q)}q.content=m.trim(r);if(!q.no_events){p.onGetContent.dispatch(p,q)}return q.content},isDirty:function(){var p=this;return m.trim(p.startContent)!=m.trim(p.getContent({format:\"raw\",no_events:1}))&&!p.isNotDirty},getContainer:function(){var p=this;if(!p.container){p.container=n.get(p.editorContainer||p.id+\"_parent\")}return p.container},getContentAreaContainer:function(){return this.contentAreaContainer},getElement:function(){return n.get(this.settings.content_element||this.id)},getWin:function(){var p=this,q;if(!p.contentWindow){q=n.get(p.id+\"_ifr\");if(q){p.contentWindow=q.contentWindow}}return p.contentWindow},getDoc:function(){var q=this,p;if(!q.contentDocument){p=q.getWin();if(p){q.contentDocument=p.document}}return q.contentDocument},getBody:function(){return this.bodyElement||this.getDoc().body},convertURL:function(p,x,v){var q=this,r=q.settings;if(r.urlconverter_callback){return q.execCallback(\"urlconverter_callback\",p,v,true,x)}if(!r.convert_urls||(v&&v.nodeName==\"LINK\")||p.indexOf(\"file:\")===0){return p}if(r.relative_urls){return q.documentBaseURI.toRelative(p)}p=q.documentBaseURI.toAbsolute(p,r.remove_script_host);return p},addVisual:function(r){var p=this,q=p.settings;r=r||p.getBody();if(!d(p.hasVisual)){p.hasVisual=q.visual}i(p.dom.select(\"table,a\",r),function(t){var s;switch(t.nodeName){case\"TABLE\":s=p.dom.getAttrib(t,\"border\");if(!s||s==\"0\"){if(p.hasVisual){p.dom.addClass(t,q.visual_table_class)}else{p.dom.removeClass(t,q.visual_table_class)}}return;case\"A\":s=p.dom.getAttrib(t,\"name\");if(s){if(p.hasVisual){p.dom.addClass(t,\"mceItemAnchor\")}else{p.dom.removeClass(t,\"mceItemAnchor\")}}return}});p.onVisualAid.dispatch(p,r,p.hasVisual)},remove:function(){var p=this,q=p.getContainer();p.removed=1;p.hide();p.execCallback(\"remove_instance_callback\",p);p.onRemove.dispatch(p);p.onExecCommand.listeners=[];m.remove(p);n.remove(q)},destroy:function(q){var p=this;if(p.destroyed){return}if(!q){m.removeUnload(p.destroy);tinyMCE.onBeforeUnload.remove(p._beforeUnload);if(p.theme&&p.theme.destroy){p.theme.destroy()}p.controlManager.destroy();p.selection.destroy();p.dom.destroy();if(!p.settings.content_editable){j.clear(p.getWin());j.clear(p.getDoc())}j.clear(p.getBody());j.clear(p.formElement)}if(p.formElement){p.formElement.submit=p.formElement._mceOldSubmit;p.formElement._mceOldSubmit=null}p.contentAreaContainer=p.formElement=p.container=p.settings.content_element=p.bodyElement=p.contentDocument=p.contentWindow=null;if(p.selection){p.selection=p.selection.win=p.selection.dom=p.selection.dom.doc=null}p.destroyed=1},_addEvents:function(){var B=this,r,C=B.settings,q=B.dom,x={mouseup:\"onMouseUp\",mousedown:\"onMouseDown\",click:\"onClick\",keyup:\"onKeyUp\",keydown:\"onKeyDown\",keypress:\"onKeyPress\",submit:\"onSubmit\",reset:\"onReset\",contextmenu:\"onContextMenu\",dblclick:\"onDblClick\",paste:\"onPaste\"};function p(t,D){var s=t.type;if(B.removed){return}if(B.onEvent.dispatch(B,t,D)!==false){B[x[t.fakeType||t.type]].dispatch(B,t,D)}}i(x,function(t,s){switch(s){case\"contextmenu\":q.bind(B.getDoc(),s,p);break;case\"paste\":q.bind(B.getBody(),s,function(D){p(D)});break;case\"submit\":case\"reset\":q.bind(B.getElement().form||n.getParent(B.id,\"form\"),s,p);break;default:q.bind(C.content_editable?B.getBody():B.getDoc(),s,p)}});q.bind(C.content_editable?B.getBody():(a?B.getDoc():B.getWin()),\"focus\",function(s){B.focus(true)});if(m.isGecko){q.bind(B.getDoc(),\"DOMNodeInserted\",function(t){var s;t=t.target;if(t.nodeType===1&&t.nodeName===\"IMG\"&&(s=t.getAttribute(\"data-mce-src\"))){t.src=B.documentBaseURI.toAbsolute(s)}})}if(a){function u(){var E=this,G=E.getDoc(),F=E.settings;if(a&&!F.readonly){E._refreshContentEditable();try{G.execCommand(\"styleWithCSS\",0,false)}catch(D){if(!E._isHidden()){try{G.execCommand(\"useCSS\",0,true)}catch(D){}}}if(!F.table_inline_editing){try{G.execCommand(\"enableInlineTableEditing\",false,false)}catch(D){}}if(!F.object_resizing){try{G.execCommand(\"enableObjectResizing\",false,false)}catch(D){}}}}B.onBeforeExecCommand.add(u);B.onMouseDown.add(u)}B.onMouseUp.add(B.nodeChanged);B.onKeyUp.add(function(s,t){var D=t.keyCode;if((D>=33&&D<=36)||(D>=37&&D<=40)||D==13||D==45||D==46||D==8||(m.isMac&&(D==91||D==93))||t.ctrlKey){B.nodeChanged()}});B.onKeyDown.add(function(t,D){if(D.keyCode!=8){return}var F=t.selection.getRng().startContainer;var E=t.selection.getRng().startOffset;while(F&&F.nodeType&&F.nodeType!=1&&F.parentNode){F=F.parentNode}if(F&&F.parentNode&&F.parentNode.tagName===\"BLOCKQUOTE\"&&F.parentNode.firstChild==F&&E==0){t.formatter.toggle(\"blockquote\",null,F.parentNode);var s=t.selection.getRng();s.setStart(F,0);s.setEnd(F,0);t.selection.setRng(s);t.selection.collapse(false)}});B.onReset.add(function(){B.setContent(B.startContent,{format:\"raw\"})});if(C.custom_shortcuts){if(C.custom_undo_redo_keyboard_shortcuts){B.addShortcut(\"ctrl+z\",B.getLang(\"undo_desc\"),\"Undo\");B.addShortcut(\"ctrl+y\",B.getLang(\"redo_desc\"),\"Redo\")}B.addShortcut(\"ctrl+b\",B.getLang(\"bold_desc\"),\"Bold\");B.addShortcut(\"ctrl+i\",B.getLang(\"italic_desc\"),\"Italic\");B.addShortcut(\"ctrl+u\",B.getLang(\"underline_desc\"),\"Underline\");for(r=1;r<=6;r++){B.addShortcut(\"ctrl+\"+r,\"\",[\"FormatBlock\",false,\"h\"+r])}B.addShortcut(\"ctrl+7\",\"\",[\"FormatBlock\",false,\"p\"]);B.addShortcut(\"ctrl+8\",\"\",[\"FormatBlock\",false,\"div\"]);B.addShortcut(\"ctrl+9\",\"\",[\"FormatBlock\",false,\"address\"]);function v(t){var s=null;if(!t.altKey&&!t.ctrlKey&&!t.metaKey){return s}i(B.shortcuts,function(D){if(m.isMac&&D.ctrl!=t.metaKey){return}else{if(!m.isMac&&D.ctrl!=t.ctrlKey){return}}if(D.alt!=t.altKey){return}if(D.shift!=t.shiftKey){return}if(t.keyCode==D.keyCode||(t.charCode&&t.charCode==D.charCode)){s=D;return false}});return s}B.onKeyUp.add(function(s,t){var D=v(t);if(D){return j.cancel(t)}});B.onKeyPress.add(function(s,t){var D=v(t);if(D){return j.cancel(t)}});B.onKeyDown.add(function(s,t){var D=v(t);if(D){D.func.call(D.scope);return j.cancel(t)}})}if(m.isIE){q.bind(B.getDoc(),\"controlselect\",function(D){var t=B.resizeInfo,s;D=D.target;if(D.nodeName!==\"IMG\"){return}if(t){q.unbind(t.node,t.ev,t.cb)}if(!q.hasClass(D,\"mceItemNoResize\")){ev=\"resizeend\";s=q.bind(D,ev,function(F){var E;F=F.target;if(E=q.getStyle(F,\"width\")){q.setAttrib(F,\"width\",E.replace(/[^0-9%]+/g,\"\"));q.setStyle(F,\"width\",\"\")}if(E=q.getStyle(F,\"height\")){q.setAttrib(F,\"height\",E.replace(/[^0-9%]+/g,\"\"));q.setStyle(F,\"height\",\"\")}})}else{ev=\"resizestart\";s=q.bind(D,\"resizestart\",j.cancel,j)}t=B.resizeInfo={node:D,ev:ev,cb:s}})}if(m.isOpera){B.onClick.add(function(s,t){j.prevent(t)})}if(C.custom_undo_redo){function y(){B.undoManager.typing=false;B.undoManager.add()}q.bind(B.getDoc(),\"focusout\",function(s){if(!B.removed&&B.undoManager.typing){y()}});B.dom.bind(B.dom.getRoot(),\"dragend\",function(s){y()});B.onKeyUp.add(function(s,D){var t=D.keyCode;if((t>=33&&t<=36)||(t>=37&&t<=40)||t==13||t==45||D.ctrlKey){y()}});B.onKeyDown.add(function(s,E){var D=E.keyCode,t;if(D==8){t=B.getDoc().selection;if(t&&t.createRange&&t.createRange().item){B.undoManager.beforeChange();s.dom.remove(t.createRange().item(0));y();return j.cancel(E)}}if((D>=33&&D<=36)||(D>=37&&D<=40)||D==13||D==45){if(m.isIE&&D==13){B.undoManager.beforeChange()}if(B.undoManager.typing){y()}return}if((D<16||D>20)&&D!=224&&D!=91&&!B.undoManager.typing){B.undoManager.beforeChange();B.undoManager.typing=true;B.undoManager.add()}});B.onMouseDown.add(function(){if(B.undoManager.typing){y()}})}if(m.isGecko){function A(){var s=B.dom.getAttribs(B.selection.getStart().cloneNode(false));return function(){var t=B.selection.getStart();if(t!==B.getBody()){B.dom.setAttrib(t,\"style\",null);i(s,function(D){t.setAttributeNode(D.cloneNode(true))})}}}function z(){var t=B.selection;return !t.isCollapsed()&&t.getStart()!=t.getEnd()}B.onKeyPress.add(function(s,D){var t;if((D.keyCode==8||D.keyCode==46)&&z()){t=A();B.getDoc().execCommand(\"delete\",false,null);t();return j.cancel(D)}});B.dom.bind(B.getDoc(),\"cut\",function(t){var s;if(z()){s=A();B.onKeyUp.addToTop(j.cancel,j);setTimeout(function(){s();B.onKeyUp.remove(j.cancel,j)},0)}})}},_refreshContentEditable:function(){var q=this,p,r;if(q._isHidden()){p=q.getBody();r=p.parentNode;r.removeChild(p);r.appendChild(p);p.focus()}},_isHidden:function(){var p;if(!a){return 0}p=this.selection.getSel();return(!p||!p.rangeCount||p.rangeCount==0)}})})(tinymce);(function(c){var d=c.each,e,a=true,b=false;c.EditorCommands=function(n){var m=n.dom,p=n.selection,j={state:{},exec:{},value:{}},k=n.settings,q=n.formatter,o;function r(z,y,x){var v;z=z.toLowerCase();if(v=j.exec[z]){v(z,y,x);return a}return b}function l(x){var v;x=x.toLowerCase();if(v=j.state[x]){return v(x)}return -1}function h(x){var v;x=x.toLowerCase();if(v=j.value[x]){return v(x)}return b}function u(v,x){x=x||\"exec\";d(v,function(z,y){d(y.toLowerCase().split(\",\"),function(A){j[x][A]=z})})}c.extend(this,{execCommand:r,queryCommandState:l,queryCommandValue:h,addCommands:u});function f(y,x,v){if(x===e){x=b}if(v===e){v=null}return n.getDoc().execCommand(y,x,v)}function t(v){return q.match(v)}function s(v,x){q.toggle(v,x?{value:x}:e)}function i(v){o=p.getBookmark(v)}function g(){p.moveToBookmark(o)}u({\"mceResetDesignMode,mceBeginUndoLevel\":function(){},\"mceEndUndoLevel,mceAddUndoLevel\":function(){n.undoManager.add()},\"Cut,Copy,Paste\":function(z){var y=n.getDoc(),v;try{f(z)}catch(x){v=a}if(v||!y.queryCommandSupported(z)){if(c.isGecko){n.windowManager.confirm(n.getLang(\"clipboard_msg\"),function(A){if(A){open(\"http://www.mozilla.org/editor/midasdemo/securityprefs.html\",\"_blank\")}})}else{n.windowManager.alert(n.getLang(\"clipboard_no_support\"))}}},unlink:function(v){if(p.isCollapsed()){p.select(p.getNode())}f(v);p.collapse(b)},\"JustifyLeft,JustifyCenter,JustifyRight,JustifyFull\":function(v){var x=v.substring(7);d(\"left,center,right,full\".split(\",\"),function(y){if(x!=y){q.remove(\"align\"+y)}});s(\"align\"+x);r(\"mceRepaint\")},\"InsertUnorderedList,InsertOrderedList\":function(y){var v,x;f(y);v=m.getParent(p.getNode(),\"ol,ul\");if(v){x=v.parentNode;if(/^(H[1-6]|P|ADDRESS|PRE)$/.test(x.nodeName)){i();m.split(x,v);g()}}},\"Bold,Italic,Underline,Strikethrough,Superscript,Subscript\":function(v){s(v)},\"ForeColor,HiliteColor,FontName\":function(y,x,v){s(y,v)},FontSize:function(z,y,x){var v,A;if(x>=1&&x<=7){A=c.explode(k.font_size_style_values);v=c.explode(k.font_size_classes);if(v){x=v[x-1]||x}else{x=A[x-1]||x}}s(z,x)},RemoveFormat:function(v){q.remove(v)},mceBlockQuote:function(v){s(\"blockquote\")},FormatBlock:function(y,x,v){return s(v||\"p\")},mceCleanup:function(){var v=p.getBookmark();n.setContent(n.getContent({cleanup:a}),{cleanup:a});p.moveToBookmark(v)},mceRemoveNode:function(z,y,x){var v=x||p.getNode();if(v!=n.getBody()){i();n.dom.remove(v,a);g()}},mceSelectNodeDepth:function(z,y,x){var v=0;m.getParent(p.getNode(),function(A){if(A.nodeType==1&&v++==x){p.select(A);return b}},n.getBody())},mceSelectNode:function(y,x,v){p.select(v)},mceInsertContent:function(B,I,K){var y,J,E,z,F,G,D,C,L,x,A,M,v,H;y=n.parser;J=new c.html.Serializer({},n.schema);v='<span id=\"mce_marker\" data-mce-type=\"bookmark\">\\uFEFF</span>';G={content:K,format:\"html\"};p.onBeforeSetContent.dispatch(p,G);K=G.content;if(K.indexOf(\"{$caret}\")==-1){K+=\"{$caret}\"}K=K.replace(/\\{\\$caret\\}/,v);if(!p.isCollapsed()){n.getDoc().execCommand(\"Delete\",false,null)}E=p.getNode();G={context:E.nodeName.toLowerCase()};F=y.parse(K,G);A=F.lastChild;if(A.attr(\"id\")==\"mce_marker\"){D=A;for(A=A.prev;A;A=A.walk(true)){if(A.type==3||!m.isBlock(A.name)){A.parent.insert(D,A,A.name===\"br\");break}}}if(!G.invalid){K=J.serialize(F);A=E.firstChild;M=E.lastChild;if(!A||(A===M&&A.nodeName===\"BR\")){m.setHTML(E,K)}else{p.setContent(K)}}else{p.setContent(v);E=n.selection.getNode();z=n.getBody();if(E.nodeType==9){E=A=z}else{A=E}while(A!==z){E=A;A=A.parentNode}K=E==z?z.innerHTML:m.getOuterHTML(E);K=J.serialize(y.parse(K.replace(/<span (id=\"mce_marker\"|id=mce_marker).+?<\\/span>/i,function(){return J.serialize(F)})));if(E==z){m.setHTML(z,K)}else{m.setOuterHTML(E,K)}}D=m.get(\"mce_marker\");C=m.getRect(D);L=m.getViewPort(n.getWin());if((C.y+C.h>L.y+L.h||C.y<L.y)||(C.x>L.x+L.w||C.x<L.x)){H=c.isIE?n.getDoc().documentElement:n.getBody();H.scrollLeft=C.x;H.scrollTop=C.y-L.h+25}x=m.createRng();A=D.previousSibling;if(A&&A.nodeType==3){x.setStart(A,A.nodeValue.length)}else{x.setStartBefore(D);x.setEndBefore(D)}m.remove(D);p.setRng(x);p.onSetContent.dispatch(p,G);n.addVisual()},mceInsertRawHTML:function(y,x,v){p.setContent(\"tiny_mce_marker\");n.setContent(n.getContent().replace(/tiny_mce_marker/g,function(){return v}))},mceSetContent:function(y,x,v){n.setContent(v)},\"Indent,Outdent\":function(z){var x,v,y;x=k.indentation;v=/[a-z%]+$/i.exec(x);x=parseInt(x);if(!l(\"InsertUnorderedList\")&&!l(\"InsertOrderedList\")){d(p.getSelectedBlocks(),function(A){if(z==\"outdent\"){y=Math.max(0,parseInt(A.style.paddingLeft||0)-x);m.setStyle(A,\"paddingLeft\",y?y+v:\"\")}else{m.setStyle(A,\"paddingLeft\",(parseInt(A.style.paddingLeft||0)+x)+v)}})}else{f(z)}},mceRepaint:function(){var x;if(c.isGecko){try{i(a);if(p.getSel()){p.getSel().selectAllChildren(n.getBody())}p.collapse(a);g()}catch(v){}}},mceToggleFormat:function(y,x,v){q.toggle(v)},InsertHorizontalRule:function(){n.execCommand(\"mceInsertContent\",false,\"<hr />\")},mceToggleVisualAid:function(){n.hasVisual=!n.hasVisual;n.addVisual()},mceReplaceContent:function(y,x,v){n.execCommand(\"mceInsertContent\",false,v.replace(/\\{\\$selection\\}/g,p.getContent({format:\"text\"})))},mceInsertLink:function(z,y,x){var v;if(typeof(x)==\"string\"){x={href:x}}v=m.getParent(p.getNode(),\"a\");x.href=x.href.replace(\" \",\"%20\");if(!v||!x.href){q.remove(\"link\")}if(x.href){q.apply(\"link\",x,v)}},selectAll:function(){var x=m.getRoot(),v=m.createRng();v.setStart(x,0);v.setEnd(x,x.childNodes.length);n.selection.setRng(v)}});u({\"JustifyLeft,JustifyCenter,JustifyRight,JustifyFull\":function(v){return t(\"align\"+v.substring(7))},\"Bold,Italic,Underline,Strikethrough,Superscript,Subscript\":function(v){return t(v)},mceBlockQuote:function(){return t(\"blockquote\")},Outdent:function(){var v;if(k.inline_styles){if((v=m.getParent(p.getStart(),m.isBlock))&&parseInt(v.style.paddingLeft)>0){return a}if((v=m.getParent(p.getEnd(),m.isBlock))&&parseInt(v.style.paddingLeft)>0){return a}}return l(\"InsertUnorderedList\")||l(\"InsertOrderedList\")||(!k.inline_styles&&!!m.getParent(p.getNode(),\"BLOCKQUOTE\"))},\"InsertUnorderedList,InsertOrderedList\":function(v){return m.getParent(p.getNode(),v==\"insertunorderedlist\"?\"UL\":\"OL\")}},\"state\");u({\"FontSize,FontName\":function(y){var x=0,v;if(v=m.getParent(p.getNode(),\"span\")){if(y==\"fontsize\"){x=v.style.fontSize}else{x=v.style.fontFamily.replace(/, /g,\",\").replace(/[\\'\\\"]/g,\"\").toLowerCase()}}return x}},\"value\");if(k.custom_undo_redo){u({Undo:function(){n.undoManager.undo()},Redo:function(){n.undoManager.redo()}})}}})(tinymce);(function(b){var a=b.util.Dispatcher;b.UndoManager=function(f){var d,e=0,h=[],c;function g(){return b.trim(f.getContent({format:\"raw\",no_events:1}))}return d={typing:false,onAdd:new a(d),onUndo:new a(d),onRedo:new a(d),beforeChange:function(){c=f.selection.getBookmark(2,true)},add:function(m){var j,k=f.settings,l;m=m||{};m.content=g();l=h[e];if(l&&l.content==m.content){return null}if(h[e]){h[e].beforeBookmark=c}if(k.custom_undo_redo_levels){if(h.length>k.custom_undo_redo_levels){for(j=0;j<h.length-1;j++){h[j]=h[j+1]}h.length--;e=h.length}}m.bookmark=f.selection.getBookmark(2,true);if(e<h.length-1){h.length=e+1}h.push(m);e=h.length-1;d.onAdd.dispatch(d,m);f.isNotDirty=0;return m},undo:function(){var k,j;if(d.typing){d.add();d.typing=false}if(e>0){k=h[--e];f.setContent(k.content,{format:\"raw\"});f.selection.moveToBookmark(k.beforeBookmark);d.onUndo.dispatch(d,k)}return k},redo:function(){var i;if(e<h.length-1){i=h[++e];f.setContent(i.content,{format:\"raw\"});f.selection.moveToBookmark(i.bookmark);d.onRedo.dispatch(d,i)}return i},clear:function(){h=[];e=0;d.typing=false},hasUndo:function(){return e>0||this.typing},hasRedo:function(){return e<h.length-1&&!this.typing}}}})(tinymce);(function(l){var j=l.dom.Event,c=l.isIE,a=l.isGecko,b=l.isOpera,i=l.each,h=l.extend,d=true,g=false;function k(o){var p,n,m;do{if(/^(SPAN|STRONG|B|EM|I|FONT|STRIKE|U)$/.test(o.nodeName)){if(p){n=o.cloneNode(false);n.appendChild(p);p=n}else{p=m=o.cloneNode(false)}p.removeAttribute(\"id\")}}while(o=o.parentNode);if(p){return{wrapper:p,inner:m}}}function f(n,o){var m=o.ownerDocument.createRange();m.setStart(n.endContainer,n.endOffset);m.setEndAfter(o);return m.cloneContents().textContent.length==0}function e(o,q,m){var n,p;if(q.isEmpty(m)){n=q.getParent(m,\"ul,ol\");if(!q.getParent(n.parentNode,\"ul,ol\")){q.split(n,m);p=q.create(\"p\",0,'<br data-mce-bogus=\"1\" />');q.replace(p,m);o.select(p,1)}return g}return d}l.create(\"tinymce.ForceBlocks\",{ForceBlocks:function(m){var n=this,o=m.settings,p;n.editor=m;n.dom=m.dom;p=(o.forced_root_block||\"p\").toLowerCase();o.element=p.toUpperCase();m.onPreInit.add(n.setup,n)},setup:function(){var n=this,m=n.editor,p=m.settings,u=m.dom,o=m.selection,q=m.schema.getBlockElements();if(p.forced_root_block){function v(){var y=o.getStart(),t=m.getBody(),s,z,D,F,E,x,A,B=-16777215;if(!y||y.nodeType!==1){return}while(y!=t){if(q[y.nodeName]){return}y=y.parentNode}s=o.getRng();if(s.setStart){z=s.startContainer;D=s.startOffset;F=s.endContainer;E=s.endOffset}else{if(s.item){s=m.getDoc().body.createTextRange();s.moveToElementText(s.item(0))}tmpRng=s.duplicate();tmpRng.collapse(true);D=tmpRng.move(\"character\",B)*-1;if(!tmpRng.collapsed){tmpRng=s.duplicate();tmpRng.collapse(false);E=(tmpRng.move(\"character\",B)*-1)-D}}for(y=t.firstChild;y;y){if(y.nodeType===3||(y.nodeType==1&&!q[y.nodeName])){if(!x){x=u.create(p.forced_root_block);y.parentNode.insertBefore(x,y)}A=y;y=y.nextSibling;x.appendChild(A)}else{x=null;y=y.nextSibling}}if(s.setStart){s.setStart(z,D);s.setEnd(F,E);o.setRng(s)}else{try{s=m.getDoc().body.createTextRange();s.moveToElementText(t);s.collapse(true);s.moveStart(\"character\",D);if(E>0){s.moveEnd(\"character\",E)}s.select()}catch(C){}}m.nodeChanged()}m.onKeyUp.add(v);m.onClick.add(v)}if(p.force_br_newlines){if(c){m.onKeyPress.add(function(s,t){var x;if(t.keyCode==13&&o.getNode().nodeName!=\"LI\"){o.setContent('<br id=\"__\" /> ',{format:\"raw\"});x=u.get(\"__\");x.removeAttribute(\"id\");o.select(x);o.collapse();return j.cancel(t)}})}}if(p.force_p_newlines){if(!c){m.onKeyPress.add(function(s,t){if(t.keyCode==13&&!t.shiftKey&&!n.insertPara(t)){j.cancel(t)}})}else{l.addUnload(function(){n._previousFormats=0});m.onKeyPress.add(function(s,t){n._previousFormats=0;if(t.keyCode==13&&!t.shiftKey&&s.selection.isCollapsed()&&p.keep_styles){n._previousFormats=k(s.selection.getStart())}});m.onKeyUp.add(function(t,y){if(y.keyCode==13&&!y.shiftKey){var x=t.selection.getStart(),s=n._previousFormats;if(!x.hasChildNodes()&&s){x=u.getParent(x,u.isBlock);if(x&&x.nodeName!=\"LI\"){x.innerHTML=\"\";if(n._previousFormats){x.appendChild(s.wrapper);s.inner.innerHTML=\"\\uFEFF\"}else{x.innerHTML=\"\\uFEFF\"}o.select(x,1);o.collapse(true);t.getDoc().execCommand(\"Delete\",false,null);n._previousFormats=0}}}})}if(a){m.onKeyDown.add(function(s,t){if((t.keyCode==8||t.keyCode==46)&&!t.shiftKey){n.backspaceDelete(t,t.keyCode==8)}})}}if(l.isWebKit){function r(t){var s=o.getRng(),x,A=u.create(\"div\",null,\" \"),z,y=u.getViewPort(t.getWin()).h;s.insertNode(x=u.create(\"br\"));s.setStartAfter(x);s.setEndAfter(x);o.setRng(s);if(o.getSel().focusNode==x.previousSibling){o.select(u.insertAfter(u.doc.createTextNode(\"\\u00a0\"),x));o.collapse(d)}u.insertAfter(A,x);z=u.getPos(A).y;u.remove(A);if(z>y){t.getWin().scrollTo(0,z)}}m.onKeyPress.add(function(s,t){if(t.keyCode==13&&(t.shiftKey||(p.force_br_newlines&&!u.getParent(o.getNode(),\"h1,h2,h3,h4,h5,h6,ol,ul\")))){r(s);j.cancel(t)}})}if(c){if(p.element!=\"P\"){m.onKeyPress.add(function(s,t){n.lastElm=o.getNode().nodeName});m.onKeyUp.add(function(t,x){var z,y=o.getNode(),s=t.getBody();if(s.childNodes.length===1&&y.nodeName==\"P\"){y=u.rename(y,p.element);o.select(y);o.collapse();t.nodeChanged()}else{if(x.keyCode==13&&!x.shiftKey&&n.lastElm!=\"P\"){z=u.getParent(y,\"p\");if(z){u.rename(z,p.element);t.nodeChanged()}}}})}}},getParentBlock:function(o){var m=this.dom;return m.getParent(o,m.isBlock)},insertPara:function(Q){var E=this,v=E.editor,M=v.dom,R=v.getDoc(),V=v.settings,F=v.selection.getSel(),G=F.getRangeAt(0),U=R.body;var J,K,H,O,N,q,o,u,z,m,C,T,p,x,I,L=M.getViewPort(v.getWin()),B,D,A;v.undoManager.beforeChange();J=R.createRange();J.setStart(F.anchorNode,F.anchorOffset);J.collapse(d);K=R.createRange();K.setStart(F.focusNode,F.focusOffset);K.collapse(d);H=J.compareBoundaryPoints(J.START_TO_END,K)<0;O=H?F.anchorNode:F.focusNode;N=H?F.anchorOffset:F.focusOffset;q=H?F.focusNode:F.anchorNode;o=H?F.focusOffset:F.anchorOffset;if(O===q&&/^(TD|TH)$/.test(O.nodeName)){if(O.firstChild.nodeName==\"BR\"){M.remove(O.firstChild)}if(O.childNodes.length==0){v.dom.add(O,V.element,null,\"<br />\");T=v.dom.add(O,V.element,null,\"<br />\")}else{I=O.innerHTML;O.innerHTML=\"\";v.dom.add(O,V.element,null,I);T=v.dom.add(O,V.element,null,\"<br />\")}G=R.createRange();G.selectNodeContents(T);G.collapse(1);v.selection.setRng(G);return g}if(O==U&&q==U&&U.firstChild&&v.dom.isBlock(U.firstChild)){O=q=O.firstChild;N=o=0;J=R.createRange();J.setStart(O,0);K=R.createRange();K.setStart(q,0)}if(!R.body.hasChildNodes()){R.body.appendChild(M.create(\"br\"))}O=O.nodeName==\"HTML\"?R.body:O;O=O.nodeName==\"BODY\"?O.firstChild:O;q=q.nodeName==\"HTML\"?R.body:q;q=q.nodeName==\"BODY\"?q.firstChild:q;u=E.getParentBlock(O);z=E.getParentBlock(q);m=u?u.nodeName:V.element;if(I=E.dom.getParent(u,\"li,pre\")){if(I.nodeName==\"LI\"){return e(v.selection,E.dom,I)}return d}if(u&&(u.nodeName==\"CAPTION\"||/absolute|relative|fixed/gi.test(M.getStyle(u,\"position\",1)))){m=V.element;u=null}if(z&&(z.nodeName==\"CAPTION\"||/absolute|relative|fixed/gi.test(M.getStyle(u,\"position\",1)))){m=V.element;z=null}if(/(TD|TABLE|TH|CAPTION)/.test(m)||(u&&m==\"DIV\"&&/left|right/gi.test(M.getStyle(u,\"float\",1)))){m=V.element;u=z=null}C=(u&&u.nodeName==m)?u.cloneNode(0):v.dom.create(m);T=(z&&z.nodeName==m)?z.cloneNode(0):v.dom.create(m);T.removeAttribute(\"id\");if(/^(H[1-6])$/.test(m)&&f(G,u)){T=v.dom.create(V.element)}I=p=O;do{if(I==U||I.nodeType==9||E.dom.isBlock(I)||/(TD|TABLE|TH|CAPTION)/.test(I.nodeName)){break}p=I}while((I=I.previousSibling?I.previousSibling:I.parentNode));I=x=q;do{if(I==U||I.nodeType==9||E.dom.isBlock(I)||/(TD|TABLE|TH|CAPTION)/.test(I.nodeName)){break}x=I}while((I=I.nextSibling?I.nextSibling:I.parentNode));if(p.nodeName==m){J.setStart(p,0)}else{J.setStartBefore(p)}J.setEnd(O,N);C.appendChild(J.cloneContents()||R.createTextNode(\"\"));try{K.setEndAfter(x)}catch(P){}K.setStart(q,o);T.appendChild(K.cloneContents()||R.createTextNode(\"\"));G=R.createRange();if(!p.previousSibling&&p.parentNode.nodeName==m){G.setStartBefore(p.parentNode)}else{if(J.startContainer.nodeName==m&&J.startOffset==0){G.setStartBefore(J.startContainer)}else{G.setStart(J.startContainer,J.startOffset)}}if(!x.nextSibling&&x.parentNode.nodeName==m){G.setEndAfter(x.parentNode)}else{G.setEnd(K.endContainer,K.endOffset)}G.deleteContents();if(b){v.getWin().scrollTo(0,L.y)}if(C.firstChild&&C.firstChild.nodeName==m){C.innerHTML=C.firstChild.innerHTML}if(T.firstChild&&T.firstChild.nodeName==m){T.innerHTML=T.firstChild.innerHTML}function S(y,s){var r=[],X,W,t;y.innerHTML=\"\";if(V.keep_styles){W=s;do{if(/^(SPAN|STRONG|B|EM|I|FONT|STRIKE|U)$/.test(W.nodeName)){X=W.cloneNode(g);M.setAttrib(X,\"id\",\"\");r.push(X)}}while(W=W.parentNode)}if(r.length>0){for(t=r.length-1,X=y;t>=0;t--){X=X.appendChild(r[t])}r[0].innerHTML=b?\"\\u00a0\":\"<br />\";return r[0]}else{y.innerHTML=b?\"\\u00a0\":\"<br />\"}}if(M.isEmpty(C)){S(C,O)}if(M.isEmpty(T)){A=S(T,q)}if(b&&parseFloat(opera.version())<9.5){G.insertNode(C);G.insertNode(T)}else{G.insertNode(T);G.insertNode(C)}T.normalize();C.normalize();v.selection.select(T,true);v.selection.collapse(true);B=v.dom.getPos(T).y;if(B<L.y||B+25>L.y+L.h){v.getWin().scrollTo(0,B<L.y?B:B-L.h+25)}v.undoManager.add();return g},backspaceDelete:function(u,B){var C=this,s=C.editor,y=s.getBody(),q=s.dom,p,v=s.selection,o=v.getRng(),x=o.startContainer,p,z,A,m;if(!B&&o.collapsed&&x.nodeType==1&&o.startOffset==x.childNodes.length){m=new l.dom.TreeWalker(x.lastChild,x);for(p=x.lastChild;p;p=m.prev()){if(p.nodeType==3){o.setStart(p,p.nodeValue.length);o.collapse(true);v.setRng(o);return}}}if(x&&s.dom.isBlock(x)&&!/^(TD|TH)$/.test(x.nodeName)&&B){if(x.childNodes.length==0||(x.childNodes.length==1&&x.firstChild.nodeName==\"BR\")){p=x;while((p=p.previousSibling)&&!s.dom.isBlock(p)){}if(p){if(x!=y.firstChild){z=s.dom.doc.createTreeWalker(p,NodeFilter.SHOW_TEXT,null,g);while(A=z.nextNode()){p=A}o=s.getDoc().createRange();o.setStart(p,p.nodeValue?p.nodeValue.length:0);o.setEnd(p,p.nodeValue?p.nodeValue.length:0);v.setRng(o);s.dom.remove(x)}return j.cancel(u)}}}}})})(tinymce);(function(c){var b=c.DOM,a=c.dom.Event,d=c.each,e=c.extend;c.create(\"tinymce.ControlManager\",{ControlManager:function(f,j){var h=this,g;j=j||{};h.editor=f;h.controls={};h.onAdd=new c.util.Dispatcher(h);h.onPostRender=new c.util.Dispatcher(h);h.prefix=j.prefix||f.id+\"_\";h._cls={};h.onPostRender.add(function(){d(h.controls,function(i){i.postRender()})})},get:function(f){return this.controls[this.prefix+f]||this.controls[f]},setActive:function(h,f){var g=null;if(g=this.get(h)){g.setActive(f)}return g},setDisabled:function(h,f){var g=null;if(g=this.get(h)){g.setDisabled(f)}return g},add:function(g){var f=this;if(g){f.controls[g.id]=g;f.onAdd.dispatch(g,f)}return g},createControl:function(i){var h,g=this,f=g.editor;d(f.plugins,function(j){if(j.createControl){h=j.createControl(i,g);if(h){return false}}});switch(i){case\"|\":case\"separator\":return g.createSeparator()}if(!h&&f.buttons&&(h=f.buttons[i])){return g.createButton(i,h)}return g.add(h)},createDropMenu:function(f,n,h){var m=this,i=m.editor,j,g,k,l;n=e({\"class\":\"mceDropDown\",constrain:i.settings.constrain_menus},n);n[\"class\"]=n[\"class\"]+\" \"+i.getParam(\"skin\")+\"Skin\";if(k=i.getParam(\"skin_variant\")){n[\"class\"]+=\" \"+i.getParam(\"skin\")+\"Skin\"+k.substring(0,1).toUpperCase()+k.substring(1)}f=m.prefix+f;l=h||m._cls.dropmenu||c.ui.DropMenu;j=m.controls[f]=new l(f,n);j.onAddItem.add(function(r,q){var p=q.settings;p.title=i.getLang(p.title,p.title);if(!p.onclick){p.onclick=function(o){if(p.cmd){i.execCommand(p.cmd,p.ui||false,p.value)}}}});i.onRemove.add(function(){j.destroy()});if(c.isIE){j.onShowMenu.add(function(){i.focus();g=i.selection.getBookmark(1)});j.onHideMenu.add(function(){if(g){i.selection.moveToBookmark(g);g=0}})}return m.add(j)},createListBox:function(f,n,h){var l=this,j=l.editor,i,k,m;if(l.get(f)){return null}n.title=j.translate(n.title);n.scope=n.scope||j;if(!n.onselect){n.onselect=function(o){j.execCommand(n.cmd,n.ui||false,o||n.value)}}n=e({title:n.title,\"class\":\"mce_\"+f,scope:n.scope,control_manager:l},n);f=l.prefix+f;function g(o){return o.settings.use_accessible_selects&&!c.isGecko}if(j.settings.use_native_selects||g(j)){k=new c.ui.NativeListBox(f,n)}else{m=h||l._cls.listbox||c.ui.ListBox;k=new m(f,n,j)}l.controls[f]=k;if(c.isWebKit){k.onPostRender.add(function(p,o){a.add(o,\"mousedown\",function(){j.bookmark=j.selection.getBookmark(1)});a.add(o,\"focus\",function(){j.selection.moveToBookmark(j.bookmark);j.bookmark=null})})}if(k.hideMenu){j.onMouseDown.add(k.hideMenu,k)}return l.add(k)},createButton:function(m,i,l){var h=this,g=h.editor,j,k,f;if(h.get(m)){return null}i.title=g.translate(i.title);i.label=g.translate(i.label);i.scope=i.scope||g;if(!i.onclick&&!i.menu_button){i.onclick=function(){g.execCommand(i.cmd,i.ui||false,i.value)}}i=e({title:i.title,\"class\":\"mce_\"+m,unavailable_prefix:g.getLang(\"unavailable\",\"\"),scope:i.scope,control_manager:h},i);m=h.prefix+m;if(i.menu_button){f=l||h._cls.menubutton||c.ui.MenuButton;k=new f(m,i,g);g.onMouseDown.add(k.hideMenu,k)}else{f=h._cls.button||c.ui.Button;k=new f(m,i,g)}return h.add(k)},createMenuButton:function(h,f,g){f=f||{};f.menu_button=1;return this.createButton(h,f,g)},createSplitButton:function(m,i,l){var h=this,g=h.editor,j,k,f;if(h.get(m)){return null}i.title=g.translate(i.title);i.scope=i.scope||g;if(!i.onclick){i.onclick=function(n){g.execCommand(i.cmd,i.ui||false,n||i.value)}}if(!i.onselect){i.onselect=function(n){g.execCommand(i.cmd,i.ui||false,n||i.value)}}i=e({title:i.title,\"class\":\"mce_\"+m,scope:i.scope,control_manager:h},i);m=h.prefix+m;f=l||h._cls.splitbutton||c.ui.SplitButton;k=h.add(new f(m,i,g));g.onMouseDown.add(k.hideMenu,k);return k},createColorSplitButton:function(f,n,h){var l=this,j=l.editor,i,k,m,g;if(l.get(f)){return null}n.title=j.translate(n.title);n.scope=n.scope||j;if(!n.onclick){n.onclick=function(o){if(c.isIE){g=j.selection.getBookmark(1)}j.execCommand(n.cmd,n.ui||false,o||n.value)}}if(!n.onselect){n.onselect=function(o){j.execCommand(n.cmd,n.ui||false,o||n.value)}}n=e({title:n.title,\"class\":\"mce_\"+f,menu_class:j.getParam(\"skin\")+\"Skin\",scope:n.scope,more_colors_title:j.getLang(\"more_colors\")},n);f=l.prefix+f;m=h||l._cls.colorsplitbutton||c.ui.ColorSplitButton;k=new m(f,n,j);j.onMouseDown.add(k.hideMenu,k);j.onRemove.add(function(){k.destroy()});if(c.isIE){k.onShowMenu.add(function(){j.focus();g=j.selection.getBookmark(1)});k.onHideMenu.add(function(){if(g){j.selection.moveToBookmark(g);g=0}})}return l.add(k)},createToolbar:function(k,h,j){var i,g=this,f;k=g.prefix+k;f=j||g._cls.toolbar||c.ui.Toolbar;i=new f(k,h,g.editor);if(g.get(k)){return null}return g.add(i)},createToolbarGroup:function(k,h,j){var i,g=this,f;k=g.prefix+k;f=j||this._cls.toolbarGroup||c.ui.ToolbarGroup;i=new f(k,h,g.editor);if(g.get(k)){return null}return g.add(i)},createSeparator:function(g){var f=g||this._cls.separator||c.ui.Separator;return new f()},setControlType:function(g,f){return this._cls[g.toLowerCase()]=f},destroy:function(){d(this.controls,function(f){f.destroy()});this.controls=null}})})(tinymce);(function(d){var a=d.util.Dispatcher,e=d.each,c=d.isIE,b=d.isOpera;d.create(\"tinymce.WindowManager\",{WindowManager:function(f){var g=this;g.editor=f;g.onOpen=new a(g);g.onClose=new a(g);g.params={};g.features={}},open:function(z,h){var v=this,k=\"\",n,m,i=v.editor.settings.dialog_type==\"modal\",q,o,j,g=d.DOM.getViewPort(),r;z=z||{};h=h||{};o=b?g.w:screen.width;j=b?g.h:screen.height;z.name=z.name||\"mc_\"+new Date().getTime();z.width=parseInt(z.width||320);z.height=parseInt(z.height||240);z.resizable=true;z.left=z.left||parseInt(o/2)-(z.width/2);z.top=z.top||parseInt(j/2)-(z.height/2);h.inline=false;h.mce_width=z.width;h.mce_height=z.height;h.mce_auto_focus=z.auto_focus;if(i){if(c){z.center=true;z.help=false;z.dialogWidth=z.width+\"px\";z.dialogHeight=z.height+\"px\";z.scroll=z.scrollbars||false}}e(z,function(p,f){if(d.is(p,\"boolean\")){p=p?\"yes\":\"no\"}if(!/^(name|url)$/.test(f)){if(c&&i){k+=(k?\";\":\"\")+f+\":\"+p}else{k+=(k?\",\":\"\")+f+\"=\"+p}}});v.features=z;v.params=h;v.onOpen.dispatch(v,z,h);r=z.url||z.file;r=d._addVer(r);try{if(c&&i){q=1;window.showModalDialog(r,window,k)}else{q=window.open(r,z.name,k)}}catch(l){}if(!q){alert(v.editor.getLang(\"popup_blocked\"))}},close:function(f){f.close();this.onClose.dispatch(this)},createInstance:function(i,h,g,m,l,k){var j=d.resolve(i);return new j(h,g,m,l,k)},confirm:function(h,f,i,g){g=g||window;f.call(i||this,g.confirm(this._decode(this.editor.getLang(h,h))))},alert:function(h,f,j,g){var i=this;g=g||window;g.alert(i._decode(i.editor.getLang(h,h)));if(f){f.call(j||i)}},resizeBy:function(f,g,h){h.resizeBy(f,g)},_decode:function(f){return d.DOM.decode(f).replace(/\\\\n/g,\"\\n\")}})}(tinymce));(function(a){a.Formatter=function(U){var M={},O=a.each,c=U.dom,q=U.selection,t=a.dom.TreeWalker,K=new a.dom.RangeUtils(c),d=U.schema.isValidChild,F=c.isBlock,l=U.settings.forced_root_block,s=c.nodeIndex,E=\"\\uFEFF\",e=/^(src|href|style)$/,R=false,B=true,p;function z(V){return V instanceof Array}function m(W,V){return c.getParents(W,V,c.getRoot())}function b(V){return V.nodeType===1&&(V.face===\"mceinline\"||V.style.fontFamily===\"mceinline\")}function Q(V){return V?M[V]:M}function k(V,W){if(V){if(typeof(V)!==\"string\"){O(V,function(Y,X){k(X,Y)})}else{W=W.length?W:[W];O(W,function(X){if(X.deep===p){X.deep=!X.selector}if(X.split===p){X.split=!X.selector||X.inline}if(X.remove===p&&X.selector&&!X.inline){X.remove=\"none\"}if(X.selector&&X.inline){X.mixed=true;X.block_expand=true}if(typeof(X.classes)===\"string\"){X.classes=X.classes.split(/\\s+/)}});M[V]=W}}}var i=function(W){var V;U.dom.getParent(W,function(X){V=U.dom.getStyle(X,\"text-decoration\");return V&&V!==\"none\"});return V};var I=function(V){var W;if(V.nodeType===1&&V.parentNode&&V.parentNode.nodeType===1){W=i(V.parentNode);if(U.dom.getStyle(V,\"color\")&&W){U.dom.setStyle(V,\"text-decoration\",W)}else{if(U.dom.getStyle(V,\"textdecoration\")===W){U.dom.setStyle(V,\"text-decoration\",null)}}}};function S(Y,ag,ab){var ac=Q(Y),ah=ac[0],af,W,ae,ad=q.isCollapsed();function Z(al){var ak=al.startContainer,ao=al.startOffset,an,am;if(ak.nodeType==1||ak.nodeValue===\"\"){ak=ak.nodeType==1?ak.childNodes[ao]:ak;if(ak){an=new t(ak,ak.parentNode);for(am=an.current();am;am=an.next()){if(am.nodeType==3&&!f(am)){al.setStart(am,0);break}}}}return al}function V(al,ak){ak=ak||ah;if(al){if(ak.onformat){ak.onformat(al,ak,ag,ab)}O(ak.styles,function(an,am){c.setStyle(al,am,r(an,ag))});O(ak.attributes,function(an,am){c.setAttrib(al,am,r(an,ag))});O(ak.classes,function(am){am=r(am,ag);if(!c.hasClass(al,am)){c.addClass(al,am)}})}}function aa(){function am(at,aq){var ar=new t(aq);for(ab=ar.current();ab;ab=ar.prev()){if(ab.childNodes.length>1||ab==at){return ab}}}var al=U.selection.getRng();var ap=al.startContainer;var ak=al.endContainer;if(ap!=ak&&al.endOffset==0){var ao=am(ap,ak);var an=ao.nodeType==3?ao.length:ao.childNodes.length;al.setEnd(ao,an)}return al}function X(an,at,aq,ap,al){var ak=[],am=-1,ar,av=-1,ao=-1,au;O(an.childNodes,function(ax,aw){if(ax.nodeName===\"UL\"||ax.nodeName===\"OL\"){am=aw;ar=ax;return false}});O(an.childNodes,function(ax,aw){if(ax.nodeName===\"SPAN\"&&c.getAttrib(ax,\"data-mce-type\")==\"bookmark\"){if(ax.id==at.id+\"_start\"){av=aw}else{if(ax.id==at.id+\"_end\"){ao=aw}}}});if(am<=0||(av<am&&ao>am)){O(a.grep(an.childNodes),al);return 0}else{au=aq.cloneNode(R);O(a.grep(an.childNodes),function(ax,aw){if((av<am&&aw<am)||(av>am&&aw>am)){ak.push(ax);ax.parentNode.removeChild(ax)}});if(av<am){an.insertBefore(au,ar)}else{if(av>am){an.insertBefore(au,ar.nextSibling)}}ap.push(au);O(ak,function(aw){au.appendChild(aw)});return au}}function ai(al,an,ap){var ak=[],ao,am;ao=ah.inline||ah.block;am=c.create(ao);V(am);K.walk(al,function(aq){var ar;function at(au){var ax=au.nodeName.toLowerCase(),aw=au.parentNode.nodeName.toLowerCase(),av;if(g(ax,\"br\")){ar=0;if(ah.block){c.remove(au)}return}if(ah.wrapper&&x(au,Y,ag)){ar=0;return}if(ah.block&&!ah.wrapper&&G(ax)){au=c.rename(au,ao);V(au);ak.push(au);ar=0;return}if(ah.selector){O(ac,function(ay){if(\"collapsed\" in ay&&ay.collapsed!==ad){return}if(c.is(au,ay.selector)&&!b(au)){V(au,ay);av=true}});if(!ah.inline||av){ar=0;return}}if(d(ao,ax)&&d(aw,ao)&&!(!ap&&au.nodeType===3&&au.nodeValue.length===1&&au.nodeValue.charCodeAt(0)===65279)&&au.id!==\"_mce_caret\"){if(!ar){ar=am.cloneNode(R);au.parentNode.insertBefore(ar,au);ak.push(ar)}ar.appendChild(au)}else{if(ax==\"li\"&&an){ar=X(au,an,am,ak,at)}else{ar=0;O(a.grep(au.childNodes),at);ar=0}}}O(aq,at)});if(ah.wrap_links===false){O(ak,function(aq){function ar(aw){var av,au,at;if(aw.nodeName===\"A\"){au=am.cloneNode(R);ak.push(au);at=a.grep(aw.childNodes);for(av=0;av<at.length;av++){au.appendChild(at[av])}aw.appendChild(au)}O(a.grep(aw.childNodes),ar)}ar(aq)})}O(ak,function(at){var aq;function au(aw){var av=0;O(aw.childNodes,function(ax){if(!f(ax)&&!H(ax)){av++}});return av}function ar(av){var ax,aw;O(av.childNodes,function(ay){if(ay.nodeType==1&&!H(ay)&&!b(ay)){ax=ay;return R}});if(ax&&h(ax,ah)){aw=ax.cloneNode(R);V(aw);c.replace(aw,av,B);c.remove(ax,1)}return aw||av}aq=au(at);if((ak.length>1||!F(at))&&aq===0){c.remove(at,1);return}if(ah.inline||ah.wrapper){if(!ah.exact&&aq===1){at=ar(at)}O(ac,function(av){O(c.select(av.inline,at),function(ax){var aw;if(av.wrap_links===false){aw=ax.parentNode;do{if(aw.nodeName===\"A\"){return}}while(aw=aw.parentNode)}T(av,ag,ax,av.exact?ax:null)})});if(x(at.parentNode,Y,ag)){c.remove(at,1);at=0;return B}if(ah.merge_with_parents){c.getParent(at.parentNode,function(av){if(x(av,Y,ag)){c.remove(at,1);at=0;return B}})}if(at&&ah.merge_siblings!==false){at=u(C(at),at);at=u(at,C(at,B))}}})}if(ah){if(ab){if(ab.nodeType){W=c.createRng();W.setStartBefore(ab);W.setEndAfter(ab);ai(o(W,ac),null,true)}else{ai(ab,null,true)}}else{if(!ad||!ah.inline||c.select(\"td.mceSelected,th.mceSelected\").length){var aj=U.selection.getNode();U.selection.setRng(aa());af=q.getBookmark();ai(o(q.getRng(B),ac),af);if(ah.styles&&(ah.styles.color||ah.styles.textDecoration)){a.walk(aj,I,\"childNodes\");I(aj)}q.moveToBookmark(af);q.setRng(Z(q.getRng(B)));U.nodeChanged()}else{P(\"apply\",Y,ag)}}}}function A(X,ag,aa){var ab=Q(X),ai=ab[0],af,ae,W;function Z(al){var ak=al.startContainer,aq=al.startOffset,ap,ao,am,an;if(ak.nodeType==3&&aq>=ak.nodeValue.length-1){ak=ak.parentNode;aq=s(ak)+1}if(ak.nodeType==1){am=ak.childNodes;ak=am[Math.min(aq,am.length-1)];ap=new t(ak);if(aq>am.length-1){ap.next()}for(ao=ap.current();ao;ao=ap.next()){if(ao.nodeType==3&&!f(ao)){an=c.create(\"a\",null,E);ao.parentNode.insertBefore(an,ao);al.setStart(ao,0);q.setRng(al);c.remove(an);return}}}}function Y(an){var am,al,ak;am=a.grep(an.childNodes);for(al=0,ak=ab.length;al<ak;al++){if(T(ab[al],ag,an,an)){break}}if(ai.deep){for(al=0,ak=am.length;al<ak;al++){Y(am[al])}}}function ac(ak){var al;O(m(ak.parentNode).reverse(),function(am){var an;if(!al&&am.id!=\"_start\"&&am.id!=\"_end\"){an=x(am,X,ag);if(an&&an.split!==false){al=am}}});return al}function V(an,ak,ap,at){var au,ar,aq,am,ao,al;if(an){al=an.parentNode;for(au=ak.parentNode;au&&au!=al;au=au.parentNode){ar=au.cloneNode(R);for(ao=0;ao<ab.length;ao++){if(T(ab[ao],ag,ar,ar)){ar=0;break}}if(ar){if(aq){ar.appendChild(aq)}if(!am){am=ar}aq=ar}}if(at&&(!ai.mixed||!F(an))){ak=c.split(an,ak)}if(aq){ap.parentNode.insertBefore(aq,ap);am.appendChild(ap)}}return ak}function ah(ak){return V(ac(ak),ak,ak,true)}function ad(am){var al=c.get(am?\"_start\":\"_end\"),ak=al[am?\"firstChild\":\"lastChild\"];if(H(ak)){ak=ak[am?\"firstChild\":\"lastChild\"]}c.remove(al,true);return ak}function aj(ak){var al,am;ak=o(ak,ab,B);if(ai.split){al=J(ak,B);am=J(ak);if(al!=am){al=N(al,\"span\",{id:\"_start\",\"data-mce-type\":\"bookmark\"});am=N(am,\"span\",{id:\"_end\",\"data-mce-type\":\"bookmark\"});ah(al);ah(am);al=ad(B);am=ad()}else{al=am=ah(al)}ak.startContainer=al.parentNode;ak.startOffset=s(al);ak.endContainer=am.parentNode;ak.endOffset=s(am)+1}K.walk(ak,function(an){O(an,function(ao){Y(ao);if(ao.nodeType===1&&U.dom.getStyle(ao,\"text-decoration\")===\"underline\"&&ao.parentNode&&i(ao.parentNode)===\"underline\"){T({deep:false,exact:true,inline:\"span\",styles:{textDecoration:\"underline\"}},null,ao)}})})}if(aa){if(aa.nodeType){W=c.createRng();W.setStartBefore(aa);W.setEndAfter(aa);aj(W)}else{aj(aa)}return}if(!q.isCollapsed()||!ai.inline||c.select(\"td.mceSelected,th.mceSelected\").length){af=q.getBookmark();aj(q.getRng(B));q.moveToBookmark(af);if(ai.inline&&j(X,ag,q.getStart())){Z(q.getRng(true))}U.nodeChanged()}else{P(\"remove\",X,ag)}if(a.isWebKit){U.execCommand(\"mceCleanup\")}}function D(W,Y,X){var V=Q(W);if(j(W,Y,X)&&(!(\"toggle\" in V[0])||V[0][\"toggle\"])){A(W,Y,X)}else{S(W,Y,X)}}function x(W,V,ab,Z){var X=Q(V),ac,aa,Y;function ad(ah,aj,ak){var ag,ai,ae=aj[ak],af;if(aj.onmatch){return aj.onmatch(ah,aj,ak)}if(ae){if(ae.length===p){for(ag in ae){if(ae.hasOwnProperty(ag)){if(ak===\"attributes\"){ai=c.getAttrib(ah,ag)}else{ai=L(ah,ag)}if(Z&&!ai&&!aj.exact){return}if((!Z||aj.exact)&&!g(ai,r(ae[ag],ab))){return}}}}else{for(af=0;af<ae.length;af++){if(ak===\"attributes\"?c.getAttrib(ah,ae[af]):L(ah,ae[af])){return aj}}}}return aj}if(X&&W){for(aa=0;aa<X.length;aa++){ac=X[aa];if(h(W,ac)&&ad(W,ac,\"attributes\")&&ad(W,ac,\"styles\")){if(Y=ac.classes){for(aa=0;aa<Y.length;aa++){if(!c.hasClass(W,Y[aa])){return}}}return ac}}}}function j(X,Z,Y){var W;function V(aa){aa=c.getParent(aa,function(ab){return !!x(ab,X,Z,true)});return x(aa,X,Z)}if(Y){return V(Y)}Y=q.getNode();if(V(Y)){return B}W=q.getStart();if(W!=Y){if(V(W)){return B}}return R}function v(ac,ab){var Z,aa=[],Y={},X,W,V;Z=q.getStart();c.getParent(Z,function(af){var ae,ad;for(ae=0;ae<ac.length;ae++){ad=ac[ae];if(!Y[ad]&&x(af,ad,ab)){Y[ad]=true;aa.push(ad)}}});return aa}function y(Z){var ab=Q(Z),Y,X,aa,W,V;if(ab){Y=q.getStart();X=m(Y);for(W=ab.length-1;W>=0;W--){V=ab[W].selector;if(!V){return B}for(aa=X.length-1;aa>=0;aa--){if(c.is(X[aa],V)){return B}}}}return R}a.extend(this,{get:Q,register:k,apply:S,remove:A,toggle:D,match:j,matchAll:v,matchNode:x,canApply:y});function h(V,W){if(g(V,W.inline)){return B}if(g(V,W.block)){return B}if(W.selector){return c.is(V,W.selector)}}function g(W,V){W=W||\"\";V=V||\"\";W=\"\"+(W.nodeName||W);V=\"\"+(V.nodeName||V);return W.toLowerCase()==V.toLowerCase()}function L(W,V){var X=c.getStyle(W,V);if(V==\"color\"||V==\"backgroundColor\"){X=c.toHex(X)}if(V==\"fontWeight\"&&X==700){X=\"bold\"}return\"\"+X}function r(V,W){if(typeof(V)!=\"string\"){V=V(W)}else{if(W){V=V.replace(/%(\\w+)/g,function(Y,X){return W[X]||Y})}}return V}function f(V){return V&&V.nodeType===3&&/^([\\t \\r\\n]+|)$/.test(V.nodeValue)}function N(X,W,V){var Y=c.create(W,V);X.parentNode.insertBefore(Y,X);Y.appendChild(X);return Y}function o(V,ah,Y){var X=V.startContainer,ac=V.startOffset,ak=V.endContainer,ae=V.endOffset,aj,ag,ab,af;function ai(aq){var al,ao,ap,an,am;al=ao=aq?X:ak;am=aq?\"previousSibling\":\"nextSibling\";root=c.getRoot();if(al.nodeType==3&&!f(al)){if(aq?ac>0:ae<al.nodeValue.length){return al}}for(;;){if(ao==root||(!ah[0].block_expand&&F(ao))){return ao}for(an=ao[am];an;an=an[am]){if(!H(an)&&!f(an)){return ao}}ao=ao.parentNode}return al}function aa(al,am){if(am===p){am=al.nodeType===3?al.length:al.childNodes.length}while(al&&al.hasChildNodes()){al=al.childNodes[am];if(al){am=al.nodeType===3?al.length:al.childNodes.length}}return{node:al,offset:am}}if(X.nodeType==1&&X.hasChildNodes()){ag=X.childNodes.length-1;X=X.childNodes[ac>ag?ag:ac];if(X.nodeType==3){ac=0}}if(ak.nodeType==1&&ak.hasChildNodes()){ag=ak.childNodes.length-1;ak=ak.childNodes[ae>ag?ag:ae-1];if(ak.nodeType==3){ae=ak.nodeValue.length}}if(H(X.parentNode)||H(X)){X=H(X)?X:X.parentNode;X=X.nextSibling||X;if(X.nodeType==3){ac=0}}if(H(ak.parentNode)||H(ak)){ak=H(ak)?ak:ak.parentNode;ak=ak.previousSibling||ak;if(ak.nodeType==3){ae=ak.length}}if(ah[0].inline){if(V.collapsed){function ad(am,aq,at){var ap,an,ar,al;function ao(av,ax){var ay,au,aw=av.nodeValue;if(typeof(ax)==\"undefined\"){ax=at?aw.length:0}if(at){ay=aw.lastIndexOf(\" \",ax);au=aw.lastIndexOf(\"\\u00a0\",ax);ay=ay>au?ay:au;if(ay!==-1&&!Y){ay++}}else{ay=aw.indexOf(\" \",ax);au=aw.indexOf(\"\\u00a0\",ax);ay=ay!==-1&&(au===-1||ay<au)?ay:au}return ay}if(am.nodeType===3){ar=ao(am,aq);if(ar!==-1){return{container:am,offset:ar}}al=am}ap=new t(am,c.getParent(am,F)||U.getBody());while(an=ap[at?\"prev\":\"next\"]()){if(an.nodeType===3){al=an;ar=ao(an);if(ar!==-1){return{container:an,offset:ar}}}else{if(F(an)){break}}}if(al){if(at){aq=0}else{aq=al.length}return{container:al,offset:aq}}}af=ad(X,ac,true);if(af){X=af.container;ac=af.offset}af=ad(ak,ae);if(af){ak=af.container;ae=af.offset}}ab=aa(ak,ae);if(ab.node){while(ab.node&&ab.offset===0&&ab.node.previousSibling){ab=aa(ab.node.previousSibling)}if(ab.node&&ab.offset>0&&ab.node.nodeType===3&&ab.node.nodeValue.charAt(ab.offset-1)===\" \"){if(ab.offset>1){ak=ab.node;ak.splitText(ab.offset-1)}else{if(ab.node.previousSibling){}}}}}if(ah[0].inline||ah[0].block_expand){if(!ah[0].inline||(X.nodeType!=3||ac===0)){X=ai(true)}if(!ah[0].inline||(ak.nodeType!=3||ae===ak.nodeValue.length)){ak=ai()}}if(ah[0].selector&&ah[0].expand!==R&&!ah[0].inline){function Z(am,al){var an,ao,aq,ap;if(am.nodeType==3&&am.nodeValue.length==0&&am[al]){am=am[al]}an=m(am);for(ao=0;ao<an.length;ao++){for(aq=0;aq<ah.length;aq++){ap=ah[aq];if(\"collapsed\" in ap&&ap.collapsed!==V.collapsed){continue}if(c.is(an[ao],ap.selector)){return an[ao]}}}return am}X=Z(X,\"previousSibling\");ak=Z(ak,\"nextSibling\")}if(ah[0].block||ah[0].selector){function W(am,al,ao){var an;if(!ah[0].wrapper){an=c.getParent(am,ah[0].block)}if(!an){an=c.getParent(am.nodeType==3?am.parentNode:am,F)}if(an&&ah[0].wrapper){an=m(an,\"ul,ol\").reverse()[0]||an}if(!an){an=am;while(an[al]&&!F(an[al])){an=an[al];if(g(an,\"br\")){break}}}return an||am}X=W(X,\"previousSibling\");ak=W(ak,\"nextSibling\");if(ah[0].block){if(!F(X)){X=ai(true)}if(!F(ak)){ak=ai()}}}if(X.nodeType==1){ac=s(X);X=X.parentNode}if(ak.nodeType==1){ae=s(ak)+1;ak=ak.parentNode}return{startContainer:X,startOffset:ac,endContainer:ak,endOffset:ae}}function T(ab,aa,Y,V){var X,W,Z;if(!h(Y,ab)){return R}if(ab.remove!=\"all\"){O(ab.styles,function(ad,ac){ad=r(ad,aa);if(typeof(ac)===\"number\"){ac=ad;V=0}if(!V||g(L(V,ac),ad)){c.setStyle(Y,ac,\"\")}Z=1});if(Z&&c.getAttrib(Y,\"style\")==\"\"){Y.removeAttribute(\"style\");Y.removeAttribute(\"data-mce-style\")}O(ab.attributes,function(ae,ac){var ad;ae=r(ae,aa);if(typeof(ac)===\"number\"){ac=ae;V=0}if(!V||g(c.getAttrib(V,ac),ae)){if(ac==\"class\"){ae=c.getAttrib(Y,ac);if(ae){ad=\"\";O(ae.split(/\\s+/),function(af){if(/mce\\w+/.test(af)){ad+=(ad?\" \":\"\")+af}});if(ad){c.setAttrib(Y,ac,ad);return}}}if(ac==\"class\"){Y.removeAttribute(\"className\")}if(e.test(ac)){Y.removeAttribute(\"data-mce-\"+ac)}Y.removeAttribute(ac)}});O(ab.classes,function(ac){ac=r(ac,aa);if(!V||c.hasClass(V,ac)){c.removeClass(Y,ac)}});W=c.getAttribs(Y);for(X=0;X<W.length;X++){if(W[X].nodeName.indexOf(\"_\")!==0){return R}}}if(ab.remove!=\"none\"){n(Y,ab);return B}}function n(X,Y){var V=X.parentNode,W;if(Y.block){if(!l){function Z(ab,aa,ac){ab=C(ab,aa,ac);return !ab||(ab.nodeName==\"BR\"||F(ab))}if(F(X)&&!F(V)){if(!Z(X,R)&&!Z(X.firstChild,B,1)){X.insertBefore(c.create(\"br\"),X.firstChild)}if(!Z(X,B)&&!Z(X.lastChild,R,1)){X.appendChild(c.create(\"br\"))}}}else{if(V==c.getRoot()){if(!Y.list_block||!g(X,Y.list_block)){O(a.grep(X.childNodes),function(aa){if(d(l,aa.nodeName.toLowerCase())){if(!W){W=N(aa,l)}else{W.appendChild(aa)}}else{W=0}})}}}}if(Y.selector&&Y.inline&&!g(Y.inline,X)){return}c.remove(X,1)}function C(W,V,X){if(W){V=V?\"nextSibling\":\"previousSibling\";for(W=X?W:W[V];W;W=W[V]){if(W.nodeType==1||!f(W)){return W}}}}function H(V){return V&&V.nodeType==1&&V.getAttribute(\"data-mce-type\")==\"bookmark\"}function u(Z,Y){var V,X,W;function ab(ae,ad){if(ae.nodeName!=ad.nodeName){return R}function ac(ag){var ah={};O(c.getAttribs(ag),function(ai){var aj=ai.nodeName.toLowerCase();if(aj.indexOf(\"_\")!==0&&aj!==\"style\"){ah[aj]=c.getAttrib(ag,aj)}});return ah}function af(aj,ai){var ah,ag;for(ag in aj){if(aj.hasOwnProperty(ag)){ah=ai[ag];if(ah===p){return R}if(aj[ag]!=ah){return R}delete ai[ag]}}for(ag in ai){if(ai.hasOwnProperty(ag)){return R}}return B}if(!af(ac(ae),ac(ad))){return R}if(!af(c.parseStyle(c.getAttrib(ae,\"style\")),c.parseStyle(c.getAttrib(ad,\"style\")))){return R}return B}if(Z&&Y){function aa(ad,ac){for(X=ad;X;X=X[ac]){if(X.nodeType==3&&X.nodeValue.length!==0){return ad}if(X.nodeType==1&&!H(X)){return X}}return ad}Z=aa(Z,\"previousSibling\");Y=aa(Y,\"nextSibling\");if(ab(Z,Y)){for(X=Z.nextSibling;X&&X!=Y;){W=X;X=X.nextSibling;Z.appendChild(W)}c.remove(Y);O(a.grep(Y.childNodes),function(ac){Z.appendChild(ac)});return Z}}return Y}function G(V){return/^(h[1-6]|p|div|pre|address|dl|dt|dd)$/.test(V)}function J(W,aa){var V,Z,X,Y;V=W[aa?\"startContainer\":\"endContainer\"];Z=W[aa?\"startOffset\":\"endOffset\"];if(V.nodeType==1){X=V.childNodes.length-1;if(!aa&&Z){Z--}V=V.childNodes[Z>X?X:Z]}if(V.nodeType===3&&aa&&Z>=V.nodeValue.length){V=new t(V,U.getBody()).next()||V}if(V.nodeType===3&&!aa&&Z==0){V=new t(V,U.getBody()).prev()||V}return V}function P(ae,V,ac){var ah,af=\"_mce_caret\",W=U.settings.caret_debug;ah=a.isGecko?\"\\u200B\":E;function X(aj){var ai=c.create(\"span\",{id:af,\"data-mce-bogus\":true,style:W?\"color:red\":\"\"});if(aj){ai.appendChild(U.getDoc().createTextNode(ah))}return ai}function ad(aj,ai){while(aj){if((aj.nodeType===3&&aj.nodeValue!==ah)||aj.childNodes.length>1){return false}if(ai&&aj.nodeType===1){ai.push(aj)}aj=aj.firstChild}return true}function aa(ai){while(ai){if(ai.id===af){return ai}ai=ai.parentNode}}function Z(ai){var aj;if(ai){aj=new t(ai,ai);for(ai=aj.current();ai;ai=aj.next()){if(ai.nodeType===3){return ai}}}}function Y(ak,aj){var al,ai;if(!ak){ak=aa(q.getStart());if(!ak){while(ak=c.get(af)){Y(ak,false)}}}else{ai=q.getRng(true);if(ad(ak)){if(aj!==false){ai.setStartBefore(ak);ai.setEndBefore(ak)}c.remove(ak)}else{al=Z(ak);al=al.deleteData(0,1);c.remove(ak,1)}q.setRng(ai)}}function ab(){var ak,ai,ao,an,al,aj,am;ak=q.getRng(true);an=ak.startOffset;aj=ak.startContainer;am=aj.nodeValue;ai=aa(q.getStart());if(ai){ao=Z(ai)}if(am&&an>0&&an<am.length&&/\\w/.test(am.charAt(an))&&/\\w/.test(am.charAt(an-1))){al=q.getBookmark();ak.collapse(true);ak=o(ak,Q(V));ak=K.split(ak);S(V,ac,ak);q.moveToBookmark(al)}else{if(!ai||ao.nodeValue!==ah){ai=X(true);ao=ai.firstChild;ak.insertNode(ai);an=1;S(V,ac,ai)}else{S(V,ac,ai)}q.setCursorLocation(ao,an)}}function ag(){var ai=q.getRng(true),aj,al,ao,an,ak,ar,aq=[],am,ap;aj=ai.startContainer;al=ai.startOffset;ak=aj;if(aj.nodeType==3){if(al!=aj.nodeValue.length||aj.nodeValue===ah){an=true}ak=ak.parentNode}while(ak){if(x(ak,V,ac)){ar=ak;break}if(ak.nextSibling){an=true}aq.push(ak);ak=ak.parentNode}if(!ar){return}if(an){ao=q.getBookmark();ai.collapse(true);ai=o(ai,Q(V),true);ai=K.split(ai);A(V,ac,ai);q.moveToBookmark(ao)}else{ap=X();ak=ap;for(am=aq.length-1;am>=0;am--){ak.appendChild(aq[am].cloneNode(false));ak=ak.firstChild}ak.appendChild(c.doc.createTextNode(ah));ak=ak.firstChild;c.insertAfter(ap,ar);q.setCursorLocation(ak,1)}}U.onBeforeGetContent.addToTop(function(){var ai=[],aj;if(ad(aa(q.getStart()),ai)){aj=ai.length;while(aj--){c.setAttrib(ai[aj],\"data-mce-bogus\",\"1\")}}});a.each(\"onMouseUp onKeyUp\".split(\" \"),function(ai){U[ai].addToTop(function(){Y()})});U.onKeyDown.addToTop(function(ai,ak){var aj=ak.keyCode;if(aj==8||aj==37||aj==39){Y(aa(q.getStart()))}});if(ae==\"apply\"){ab()}else{ag()}}}})(tinymce);tinymce.onAddEditor.add(function(e,a){var d,h,g,c=a.settings;if(c.inline_styles){h=e.explode(c.font_size_legacy_values);function b(j,i){e.each(i,function(l,k){if(l){g.setStyle(j,k,l)}});g.rename(j,\"span\")}d={font:function(j,i){b(i,{backgroundColor:i.style.backgroundColor,color:i.color,fontFamily:i.face,fontSize:h[parseInt(i.size)-1]})},u:function(j,i){b(i,{textDecoration:\"underline\"})},strike:function(j,i){b(i,{textDecoration:\"line-through\"})}};function f(i,j){g=i.dom;if(c.convert_fonts_to_spans){e.each(g.select(\"font,u,strike\",j.node),function(k){d[k.nodeName.toLowerCase()](a.dom,k)})}}a.onPreProcess.add(f);a.onSetContent.add(f);a.onInit.add(function(){a.selection.onSetContent.add(f)})}});","Magento_Tinymce3/tiny_mce/tiny_mce_dev.js":"/**\n * tiny_mce_dev.js\n *\n * Copyright 2009, Moxiecode Systems AB\n * Released under LGPL License.\n *\n * License: http://tinymce.moxiecode.com/license\n * Contributing: http://tinymce.moxiecode.com/contributing\n *\n * This file should only be used while developing TinyMCE \n * tiny_mce.js or tiny_mce_src.js should be used in a production environment.\n * This file loads the js files from classes instead of a merged copy.\n */\n\n(function() {\n\tvar i, nl = document.getElementsByTagName('script'), base, src, p, li, query = '', it, scripts = [];\n\n\tif (window.tinyMCEPreInit) {\n\t\tbase = tinyMCEPreInit.base;\n\t\tquery = tinyMCEPreInit.query || '';\n\t} else {\n\t\tfor (i=0; i<nl.length; i++) {\n\t\t\tsrc = nl[i].src;\n\n\t\t\tif (src && src.indexOf(\"tiny_mce_dev.js\") != -1) {\n\t\t\t\tbase = src.substring(0, src.lastIndexOf('/'));\n\n\t\t\t\tif ((p = src.indexOf('?')) != -1)\n\t\t\t\t\tquery = src.substring(p + 1);\n\t\t\t}\n\t\t}\n\t}\n\n\t// Parse query string\n\tli = query.split('&');\n\tquery = {};\n\tfor (i=0; i<li.length; i++) {\n\t\tit = li[i].split('=');\n\t\tquery[unescape(it[0])] = unescape(it[1]);\n\t}\n\n\tnl = null; // IE leak fix\n\n\tfunction include(u) {\n\t\tscripts.push(base + '/classes/' + u);\n\t};\n\n\tfunction load() {\n\t\tvar i, html = '';\n\n\t\tfor (i = 0; i < scripts.length; i++)\n\t\t\thtml += '<script type=\"text/javascript\" src=\"' + scripts[i] + '\"></script>\\n';\n\n\t\tdocument.write(html);\n\t};\n\n\t// Firebug\n\tif (query.debug && !(\"console\" in window)) {\n\t\tinclude('firebug/firebug-lite.js');\n\t}\n\n\t// Core ns\n\tinclude('tinymce.js');\n\n\t// Load framework adapter\n\tif (query.api)\n\t\tinclude('adapter/' + query.api + '/adapter.js');\n\n\t// tinymce.util.*\n\tinclude('util/Dispatcher.js');\n\tinclude('util/URI.js');\n\tinclude('util/Cookie.js');\n\tinclude('util/JSON.js');\n\tinclude('util/JSONP.js');\n\tinclude('util/XHR.js');\n\tinclude('util/JSONRequest.js');\n\tinclude('util/VK.js');\n\tinclude('util/Quirks.js');\n\n\t// tinymce.html.*\n\tinclude('html/Entities.js');\n\tinclude('html/Styles.js');\n\tinclude('html/Schema.js');\n\tinclude('html/SaxParser.js');\n\tinclude('html/Node.js');\n\tinclude('html/DomParser.js');\n\tinclude('html/Serializer.js');\n\tinclude('html/Writer.js');\n\n\t// tinymce.dom.*\n\tinclude('dom/DOMUtils.js');\n\tinclude('dom/Range.js');\n\tinclude('dom/TridentSelection.js');\n\tinclude('dom/Sizzle.js');\n\tinclude('dom/EventUtils.js');\n\tinclude('dom/Element.js');\n\tinclude('dom/Selection.js');\n\tinclude('dom/Serializer.js');\n\tinclude('dom/ScriptLoader.js');\n\tinclude('dom/TreeWalker.js');\n\tinclude('dom/RangeUtils.js');\n\n\t// tinymce.ui.*\n\tinclude('ui/KeyboardNavigation.js');\n\tinclude('ui/Control.js');\n\tinclude('ui/Container.js');\n\tinclude('ui/Separator.js');\n\tinclude('ui/MenuItem.js');\n\tinclude('ui/Menu.js');\n\tinclude('ui/DropMenu.js');\n\tinclude('ui/Button.js');\n\tinclude('ui/ListBox.js');\n\tinclude('ui/NativeListBox.js');\n\tinclude('ui/MenuButton.js');\n\tinclude('ui/SplitButton.js');\n\tinclude('ui/ColorSplitButton.js');\n\tinclude('ui/ToolbarGroup.js');\n\tinclude('ui/Toolbar.js');\n\n\t// tinymce.*\n\tinclude('AddOnManager.js');\n\tinclude('EditorManager.js');\n\tinclude('Editor.js');\n\tinclude('EditorCommands.js');\n\tinclude('UndoManager.js');\n\tinclude('ForceBlocks.js');\n\tinclude('ControlManager.js');\n\tinclude('WindowManager.js');\n\tinclude('Formatter.js');\n\tinclude('LegacyInput.js');\n\n\tload();\n}());\n"}
}});
