# Magento Functional Testing Framework (MFTF)

[![Build Status](https://travis-ci.org/magento/magento2-functional-testing-framework.svg?branch=develop)](https://travis-ci.org/magento/magento2-functional-testing-framework) [![Coverage Status](https://coveralls.io/repos/github/magento/magento2-functional-testing-framework/badge.svg?branch=develop)](https://coveralls.io/github/magento/magento2-functional-testing-framework)

----

## Installation

For the installation guidelines and system requirements, refer to [Getting Started][].

## Contributing

We would appreciate your contributions to new components or new features, changes to the existing features, tests, documentation, specifications, bug fixes, optimizations, or just good suggestions.
Report about an issue or request features opening a GitHub issue.
Learn more about contributing in our [Contribution Guidelines][].

If you want to participate in the documentation work, see [DevDocs Contributing][].

### Labels applied by the MFTF team

Refer to the tables with descriptions of each label below.
These labels are applied by the MFTF development team to community contributed issues and pull requests, to communicate status, impact, or which team is working on it.

### Pull Request Status

| Label           | Description                                                                                                                                                                                                                                    |
| --------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **accept**      | The pull request has been accepted and will be merged into mainline code.                                                                                                                                                                      |
| **reject**      | The pull request has been rejected and will not be merged into mainline code. Possible reasons can include but are not limited to: issue has already been fixed in another code contribution, or there is an issue with the code contribution. |
| **needsUpdate** | The Magento Team needs additional information from the reporter to properly prioritize and process the pull request.                                                                                                                           |

### Issue Resolution Status

| Label                | Description                                                                                                                   |
| -------------------- | ----------------------------------------------------------------------------------------------------------------------------- |
| **acknowledged**     | The Magento Team has validated the issue and an internal ticket has been created.                                             |
| **needsUpdate**      | The Magento Team needs additional information from the reporter to properly prioritize and process the issue or pull request. |
| **cannot reproduce** | The Magento Team has not confirmed that this issue contains the minimum required information to reproduce.                    |
| **non-issue**        | The Magento Team has not recognized any issue according to provided information.                                              |

### Domains Impacted

| Label    | Description                                                                   |
| -------- | ----------------------------------------------------------------------------- |
| **PROD** | Affects the Product team (mostly feature requests or business logic change).  |
| **DOC**  | Affects Documentation domain.                                                 |
| **TECH** | Affects Architect Group (mostly to make decisions around technology changes). |

### Type

| Label           | Description                                                                                                                   |
| --------------- | ----------------------------------------------------------------------------------------------------------------------------- |
| **bugfix**      | The issue or pull request relates to bug fixing.                                                                              |
| **enhancement** | The issue or pull request that raises the MFTF to a higher degree (for example new features, optimization, refactoring, etc). |

## Reporting security issues

To report security vulnerabilities and other security issues in the Magento software or web sites, send an email with the report at [security@magento.com][].
Do not report security issues using GitHub.
Be sure to encrypt your e-mail with our [encryption key][] if it includes sensitive information.
Learn more about reporting security issues [here][].

Stay up-to-date on the latest security news and patches for Magento by signing up for [Security Alert Notifications][].

## License

Each Magento source file included in this distribution is licensed under AGPL 3.0.

See the license [here][] or contact [license@magentocommerce.com][] for a copy.

<!-- Link Definitions -->
[Getting Started]: docs/getting-started.md
[Contribution Guidelines]: .github/CONTRIBUTING.html
[DevDocs Contributing]: https://github.com/magento/devdocs/blob/master/.github/CONTRIBUTING.md
[security@magento.com]: mailto:security@magento.com
[encryption key]: https://info2.magento.com/rs/magentoenterprise/images/security_at_magento.asc
[here]: https://magento.com/security/reporting-magento-security-issue
[Security Alert Notifications]: https://magento.com/security/sign-up
[here]: LICENSE_AGPL3.txt
[license@magentocommerce.com]: mailto:license@magentocommerce.com