<?php

/**
 * BaseEmpWorkExperience
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                $emp_number                Type: integer(4), primary key
 * @property float              $seqno                     Type: decimal(10), primary key
 * @property string             $employer                  Type: string(100)
 * @property string             $jobtitle                  Type: string(120)
 * @property string             $from_date                 Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property string             $to_date                   Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property string             $comments                  Type: string(200)
 * @property int                $internal                  Type: integer(4)
 * @property Employee           $Employee                  
 *  
 * @method int                  getEmpNumber()             Type: integer(4), primary key
 * @method float                getSeqno()                 Type: decimal(10), primary key
 * @method string               getEmployer()              Type: string(100)
 * @method string               getJobtitle()              Type: string(120)
 * @method string               getFromDate()              Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method string               getToDate()                Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method string               getComments()              Type: string(200)
 * @method int                  getInternal()              Type: integer(4)
 * @method Employee             getEmployee()              
 *  
 * @method EmpWorkExperience    setEmpNumber(int $val)     Type: integer(4), primary key
 * @method EmpWorkExperience    setSeqno(float $val)       Type: decimal(10), primary key
 * @method EmpWorkExperience    setEmployer(string $val)   Type: string(100)
 * @method EmpWorkExperience    setJobtitle(string $val)   Type: string(120)
 * @method EmpWorkExperience    setFromDate(string $val)   Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method EmpWorkExperience    setToDate(string $val)     Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method EmpWorkExperience    setComments(string $val)   Type: string(200)
 * @method EmpWorkExperience    setInternal(int $val)      Type: integer(4)
 * @method EmpWorkExperience    setEmployee(Employee $val) 
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseEmpWorkExperience extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('hs_hr_emp_work_experience');
        $this->hasColumn('emp_number', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 4,
             ));
        $this->hasColumn('eexp_seqno as seqno', 'decimal', 10, array(
             'type' => 'decimal',
             'primary' => true,
             'length' => 10,
             ));
        $this->hasColumn('eexp_employer as employer', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('eexp_jobtit as jobtitle', 'string', 120, array(
             'type' => 'string',
             'length' => 120,
             ));
        $this->hasColumn('eexp_from_date as from_date', 'timestamp', 25, array(
             'type' => 'timestamp',
             'length' => 25,
             ));
        $this->hasColumn('eexp_to_date as to_date', 'timestamp', 25, array(
             'type' => 'timestamp',
             'length' => 25,
             ));
        $this->hasColumn('eexp_comments as comments', 'string', 200, array(
             'type' => 'string',
             'length' => 200,
             ));
        $this->hasColumn('eexp_internal as internal', 'integer', 4, array(
             'type' => 'integer',
             'length' => 4,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Employee', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));
    }
}