<?php

/**
 * BaseBuzzNotificationMetadata
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                       $emp_number                              Type: integer(7), primary key
 * @property string                    $last_notification_view_time             Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property string                    $last_buzz_view_time                     Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property string                    $last_clear_notifications                Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property Employee                  $employeeLastView                        
 *  
 * @method int                         getEmpNumber()                           Type: integer(7), primary key
 * @method string                      getLastNotificationViewTime()            Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method string                      getLastBuzzViewTime()                    Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method string                      getLastClearNotifications()              Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method Employee                    getEmployeeLastView()                    
 *  
 * @method BuzzNotificationMetadata    setEmpNumber(int $val)                   Type: integer(7), primary key
 * @method BuzzNotificationMetadata    setLastNotificationViewTime(string $val) Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method BuzzNotificationMetadata    setLastBuzzViewTime(string $val)         Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method BuzzNotificationMetadata    setLastClearNotifications(string $val)   Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method BuzzNotificationMetadata    setEmployeeLastView(Employee $val)       
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseBuzzNotificationMetadata extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_buzz_notification_metadata');
        $this->hasColumn('emp_number', 'integer', 7, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 7,
             ));
        $this->hasColumn('last_notification_view_time', 'timestamp', null, array(
             'type' => 'timestamp',
             ));
        $this->hasColumn('last_buzz_view_time', 'timestamp', null, array(
             'type' => 'timestamp',
             ));
        $this->hasColumn('last_clear_notifications', 'timestamp', null, array(
             'type' => 'timestamp',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Employee as employeeLastView', array(
             'local' => 'employee_number',
             'foreign' => 'empNumber'));
    }
}