<?php

/**
 * Test class for CountryDao.
 * Generated by PHPUnit on 2012-01-21 at 20:10:30.
 */
class CountryDaoTest extends PHPUnit_Framework_TestCase {

    /**
     * @var CountryDao
     */
    protected $dao;
    
    /**
     *
     * @var string
     */
    protected $fixture;

    /**
     *
     * @var array
     */
    protected $sampleCountries;
    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp() {
        $this->dao = new CountryDao();
        $this->fixture = sfConfig::get('sf_plugins_dir') . '/orangehrmAdminPlugin/test/fixtures/CountryDao.yml';
        
        $sampleData = sfYaml::load($this->fixture);
        $this->sampleCountries = $sampleData['Country'];
        TestDataService::populate($this->fixture);
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown() {
        
    }

    /**
     * @covers CountryDao::searchCountries
     */
    public function testSearchCountries_Successful_AllResults() {
        $result = $this->dao->searchCountries(array());
        
        $this->assertTrue($result instanceof Doctrine_Collection);
        $this->assertEquals(5, $result->count());
        
        foreach ($result as $index => $country) {
            $this->assertTrue($country instanceof Country);
            $this->assertEquals($this->sampleCountries[$index]['cou_code'], $country->getCouCode());
            $this->assertEquals($this->sampleCountries[$index]['name'], $country->getName());
            $this->assertEquals($this->sampleCountries[$index]['cou_name'], $country->getCouName());
            $this->assertEquals($this->sampleCountries[$index]['iso3'], $country->getIso3());
            $this->assertEquals($this->sampleCountries[$index]['numcode'], $country->getNumcode());
        }
    }
    
    /**
     * @covers CountryDao::searchCountries
     */
    public function testSearchCountries_Successful_FilteredResults() {
        $result = $this->dao->searchCountries(array(
            'cou_code' => 'LK',
        ));
        
        $this->assertTrue($result instanceof Doctrine_Collection);
        $this->assertEquals(1, $result->count());
        
        $country = $result->get(0);
        $this->assertTrue($country instanceof Country);
        $this->assertEquals($this->sampleCountries[2]['cou_code'], $country->getCouCode());
        $this->assertEquals($this->sampleCountries[2]['name'], $country->getName());
        $this->assertEquals($this->sampleCountries[2]['cou_name'], $country->getCouName());
        $this->assertEquals($this->sampleCountries[2]['iso3'], $country->getIso3());
        $this->assertEquals($this->sampleCountries[2]['numcode'], $country->getNumcode());
        
        $result = $this->dao->searchCountries(array(
            'name' => 'BRAZIL',
        ));
        
        $this->assertTrue($result instanceof Doctrine_Collection);
        $this->assertEquals(1, $result->count());
        
        $country = $result->get(0);
        $this->assertTrue($country instanceof Country);
        $this->assertEquals($this->sampleCountries[0]['cou_code'], $country->getCouCode());
        $this->assertEquals($this->sampleCountries[0]['name'], $country->getName());
        $this->assertEquals($this->sampleCountries[0]['cou_name'], $country->getCouName());
        $this->assertEquals($this->sampleCountries[0]['iso3'], $country->getIso3());
        $this->assertEquals($this->sampleCountries[0]['numcode'], $country->getNumcode());
    }
    
    /**
     * @covers CountryDao::searchCountries
     */
    public function testSearchCountries_Successful_EmptyResults() {
        $result = $this->dao->searchCountries(array(
            'cou_code' => 'IE',
        ));
        
        $this->assertTrue($result instanceof Doctrine_Collection);
        $this->assertEquals(0, $result->count());
    }

}

?>
