<?php

/**
 * Test class for WebServiceUtilityDao.
 * Generated by PHPUnit on 2012-06-14 at 02:48:10.
 * @group WebServices
 */
class WSUtilityDaoTest extends PHPUnit_Framework_TestCase {

    /**
     * @var WebServiceUtilityDao
     */
    protected $dao;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp() {
        $this->dao = new WSUtilityDao();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown() {
        
    }

    /**
     * @covers WSUtilityDao::format
     */
    public function testFormat_Collection_JSON() {
        $collection = $this->getSampleDoctrineCollection();
        $expected = '{"Employee_0":{"empNumber":null,"lastName":"Smith","firstName":"John","middleName":"","nickName":"","smoker":"0","ssn":"","sin":"","otherId":"","licenseNo":"","militaryService":"","street1":"","street2":"","city":"","country":"","province":"","employeeId":"","ethnic_race_code":null,"emp_birthday":null,"nation_code":null,"emp_gender":null,"emp_marital_status":null,"emp_dri_lice_exp_date":null,"emp_status":null,"job_title_code":null,"eeo_cat_code":null,"work_station":null,"emp_zipcode":null,"emp_hm_telephone":null,"emp_mobile":null,"emp_work_telephone":null,"emp_work_email":null,"sal_grd_code":null,"joined_date":null,"emp_oth_email":null,"termination_id":null,"custom1":null,"custom2":null,"custom3":null,"custom4":null,"custom5":null,"custom6":null,"custom7":null,"custom8":null,"custom9":null,"custom10":null,"purged_at":null},"Employee_1":{"empNumber":null,"lastName":"Carter","firstName":"John","middleName":"","nickName":"","smoker":"0","ssn":"","sin":"","otherId":"","licenseNo":"","militaryService":"","street1":"","street2":"","city":"","country":"","province":"","employeeId":"","ethnic_race_code":null,"emp_birthday":null,"nation_code":null,"emp_gender":null,"emp_marital_status":null,"emp_dri_lice_exp_date":null,"emp_status":null,"job_title_code":null,"eeo_cat_code":null,"work_station":null,"emp_zipcode":null,"emp_hm_telephone":null,"emp_mobile":null,"emp_work_telephone":null,"emp_work_email":null,"sal_grd_code":null,"joined_date":null,"emp_oth_email":null,"termination_id":null,"custom1":null,"custom2":null,"custom3":null,"custom4":null,"custom5":null,"custom6":null,"custom7":null,"custom8":null,"custom9":null,"custom10":null,"purged_at":null},"Employee_2":{"empNumber":null,"lastName":"Jayapala","firstName":"John","middleName":"","nickName":"","smoker":"0","ssn":"","sin":"","otherId":"","licenseNo":"","militaryService":"","street1":"","street2":"","city":"","country":"","province":"","employeeId":"","ethnic_race_code":null,"emp_birthday":null,"nation_code":null,"emp_gender":null,"emp_marital_status":null,"emp_dri_lice_exp_date":null,"emp_status":null,"job_title_code":null,"eeo_cat_code":null,"work_station":null,"emp_zipcode":null,"emp_hm_telephone":null,"emp_mobile":null,"emp_work_telephone":null,"emp_work_email":null,"sal_grd_code":null,"joined_date":null,"emp_oth_email":null,"termination_id":null,"custom1":null,"custom2":null,"custom3":null,"custom4":null,"custom5":null,"custom6":null,"custom7":null,"custom8":null,"custom9":null,"custom10":null,"purged_at":null}}';
        $result = $this->dao->format($collection, 'json');
        $this->assertEquals($expected, $result);
    }

    /**
     * @covers WSUtilityDao::format
     */
    public function testFormat_Record_JSON() {
        $record = $this->getSampleDoctrineRecord();
        $expected = '{"empNumber":null,"lastName":"Smith","firstName":"John","middleName":"","nickName":"","smoker":"0","ssn":"","sin":"","otherId":"","licenseNo":"","militaryService":"","street1":"","street2":"","city":"","country":"","province":"","employeeId":"","ethnic_race_code":null,"emp_birthday":null,"nation_code":null,"emp_gender":null,"emp_marital_status":null,"emp_dri_lice_exp_date":null,"emp_status":null,"job_title_code":null,"eeo_cat_code":null,"work_station":null,"emp_zipcode":null,"emp_hm_telephone":null,"emp_mobile":null,"emp_work_telephone":null,"emp_work_email":null,"sal_grd_code":null,"joined_date":null,"emp_oth_email":null,"termination_id":null,"custom1":null,"custom2":null,"custom3":null,"custom4":null,"custom5":null,"custom6":null,"custom7":null,"custom8":null,"custom9":null,"custom10":null,"purged_at":null}';
        $result = $this->dao->format($record, 'json');
        $this->assertEquals($expected, $result);
    }

    /**
     *
     * @return Doctrine_Collection 
     */
    protected function getSampleDoctrineCollection() {
        $employee1 = new Employee();
        $employee2 = new Employee();
        $employee3 = new Employee();

        $employee1->fromArray(array(
            'firstName' => 'John',
            'lastName' => 'Smith',
        ));
        $employee2->fromArray(array(
            'firstName' => 'John',
            'lastName' => 'Carter',
        ));
        $employee3->fromArray(array(
            'firstName' => 'John',
            'lastName' => 'Jayapala',
        ));

        $collection = new Doctrine_Collection('Employee');
        $collection->add($employee1);
        $collection->add($employee2);
        $collection->add($employee3);

        return $collection;
    }

    /**
     * @return Doctrine_Record
     */
    protected function getSampleDoctrineRecord() {
        $record = new Employee();
        $record->fromArray(array(
            'firstName' => 'John',
            'lastName' => 'Smith',
        ));
        return $record;
    }

}
