<?php



/**
 * Test class for AuthenticationService.
 * Generated by PHPUnit on 2011-09-13 at 02:25:47.
 */
class AuthenticationServiceTest extends PHPUnit_Framework_TestCase {

    /**
     * @var AuthenticationService
     */
    protected $authService;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp() {
        $this->authService = new AuthenticationService;
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown() {
        
    }

    /**
     * Tests the getSystemUserService() method
     */
    public function testGetSystemUserService() {
        $this->assertTrue($this->authService->getSystemUserService() instanceof SystemUserService);

        $service = new SystemUserService();
        $this->authService->setSystemUserService($service);
        $this->assertEquals($service, $this->authService->getSystemUserService());
    }

    /**
     * Tests the setSystemUserService() method
     */
    public function testSetSystemUserService() {
        $service = new SystemUserService();
        $this->authService->setSystemUserService($dao);
        $this->assertEquals($service, $this->authService->getSystemUserService());
    }

    public function testGetCookieManager() {
        $this->assertTrue($this->authService->getCookieManager() instanceof CookieManager);

        $cookieManager = new CookieManager();
        $this->authService->setCookieManager($cookieManager);
        $this->assertEquals($cookieManager, $this->authService->getCookieManager());
    }

    /**
     * Tests the setCookieManager() method
     */
    public function testSetCookieManager() {
        $cookieManager = new CookieManager();
        $this->authService->setCookieManager($cookieManager);
        $this->assertEquals($cookieManager, $this->authService->getCookieManager());
    }

    /**
     * Tests the setCredentials() method
     */
    public function testSetCredentials() {
        $user = new Users();
        $user->setUserName('test_user');

        $mockService = $this->getMockBuilder('SystemUserService')->setMethods(array('getCredentials'))->getMock();
        $mockService->expects($this->once())
                ->method('getCredentials')
                ->with('test_user', 'test_password')
                ->will($this->returnValue($user));

        $mockCookieManager = $this->getMockBuilder('CookieManager')->setMethods(array('setCookie'))->getMock();
        $mockCookieManager->expects($this->once())
                ->method('setCookie')
                ->with('Loggedin', 'True', 0, '/');

        $this->authService->setSystemUserService($mockService);
        $this->authService->setCookieManager($mockCookieManager);

        $result = $this->authService->setCredentials('test_user', 'test_password', array());
        $this->assertTrue($result);
    }

}

